LavaPack.loadBundle([[1626,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[1627,{"./build/multichain-openrpc.json":1625,"./build/openrpc.json":1626},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.MultiChainOpenRPCDocument=r.MetaMaskOpenRPCDocument=void 0;const a=n(e("./build/openrpc.json"));r.MetaMaskOpenRPCDocument=a.default;const i=n(e("./build/multichain-openrpc.json"));r.MultiChainOpenRPCDocument=i.default,r.default=a.default}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js"}],[1628,{"./constants.cjs":1630,"@metamask/base-controller":1522,"@metamask/controller-utils":1641,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a,i=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.ClaimsController=r.getDefaultClaimsControllerState=void 0;const s=e("@metamask/base-controller"),o=e("@metamask/controller-utils"),c=e("@metamask/utils"),l=e("./constants.cjs"),u={claims:{includeInStateLogs:!1,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},claimsConfigurations:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},drafts:{includeInStateLogs:!1,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0}};function d(){return{claimsConfigurations:l.DEFAULT_CLAIMS_CONFIGURATIONS,claims:[],drafts:[]}}r.getDefaultClaimsControllerState=d;class f extends s.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:u,name:l.CONTROLLER_NAME,state:{...d(),...t}}),n.add(this)}async fetchClaimsConfigurations(){const e=await this.messenger.call(`${l.SERVICE_NAME}:fetchClaimsConfigurations`),t=e.networks.map(e=>(0,o.toHex)(e)),r={validSubmissionWindowDays:e.validSubmissionWindowDays,supportedNetworks:t};return this.update(e=>{e.claimsConfigurations=r}),r}async getSubmitClaimConfig(e){i(this,n,"m",a).call(this,e);return{data:e,headers:await this.messenger.call(`${l.SERVICE_NAME}:getRequestHeaders`),method:"POST",url:`${this.messenger.call(`${l.SERVICE_NAME}:getClaimsApiUrl`)}/claims`}}async generateClaimSignature(e,t){const{message:r}=await this.messenger.call(`${l.SERVICE_NAME}:generateMessageForClaimSignature`,e,t),n=(0,c.stringToBytes)(r),a=(0,c.bytesToHex)(n),i=(0,o.detectSIWE)({data:a});if(!i.isSIWEMessage)throw new Error(l.ClaimsControllerErrorMessages.INVALID_SIGNATURE_MESSAGE);return await this.messenger.call("KeyringController:signPersonalMessage",{data:r,from:t,siwe:i})}async getClaims(){const e=await this.messenger.call(`${l.SERVICE_NAME}:getClaims`);return this.update(t=>{t.claims=e}),e}saveOrUpdateClaimDraft(e){const{drafts:t}=this.state;if(t.some(t=>e.draftId&&t.draftId===e.draftId)){const t=(new Date).toISOString();return this.update(r=>{r.drafts=r.drafts.map(r=>r.draftId===e.draftId?{...r,...e,updatedAt:t}:r)}),{...e,updatedAt:t}}const r=`draft-${Date.now()}`,n={...e,draftId:r,updatedAt:(new Date).toISOString()};return this.update(e=>{e.drafts.push(n)}),n}getClaimDrafts(){return this.state.drafts}deleteClaimDraft(e){this.update(t=>{t.drafts=t.drafts.filter(t=>t.draftId!==e)})}deleteAllClaimDrafts(){this.update(e=>{e.drafts=[]})}clearState(){this.update(()=>d())}}r.ClaimsController=f,n=new WeakSet,a=function(e){const{claims:t}=this.state;if(t.some(t=>t.impactedTxHash===e.impactedTxHash))throw new Error(l.ClaimsControllerErrorMessages.CLAIM_ALREADY_SUBMITTED)}}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/ClaimsController.cjs"}],[1629,{"./constants.cjs":1630,"./logger.cjs":1632,"./utils.cjs":1633},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a,i,s=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},o=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.ClaimsService=void 0;const c=e("./constants.cjs"),l=e("./logger.cjs"),u=e("./utils.cjs"),d=(0,l.createModuleLogger)(l.projectLogger,"ClaimsService");r.ClaimsService=class{constructor({env:e,messenger:t,fetchFunction:r}){this.name=c.SERVICE_NAME,n.set(this,void 0),a.set(this,void 0),i.set(this,void 0),s(this,n,e,"f"),s(this,i,t,"f"),s(this,a,r,"f"),o(this,i,"f").registerActionHandler(`${c.SERVICE_NAME}:fetchClaimsConfigurations`,this.fetchClaimsConfigurations.bind(this)),o(this,i,"f").registerActionHandler(`${c.SERVICE_NAME}:getClaims`,this.getClaims.bind(this)),o(this,i,"f").registerActionHandler(`${c.SERVICE_NAME}:getClaimById`,this.getClaimById.bind(this)),o(this,i,"f").registerActionHandler(`${c.SERVICE_NAME}:getRequestHeaders`,this.getRequestHeaders.bind(this)),o(this,i,"f").registerActionHandler(`${c.SERVICE_NAME}:getClaimsApiUrl`,this.getClaimsApiUrl.bind(this)),o(this,i,"f").registerActionHandler(`${c.SERVICE_NAME}:generateMessageForClaimSignature`,this.generateMessageForClaimSignature.bind(this))}async fetchClaimsConfigurations(){try{const e=await this.getRequestHeaders(),t=`${this.getClaimsApiUrl()}/configurations`,r=await o(this,a,"f").call(this,t,{headers:e});if(!r.ok){throw await(0,u.getErrorFromResponse)(r)}return await r.json()}catch(e){throw d("fetchClaimsConfigurations",e),o(this,i,"f").captureException?.((0,u.createSentryError)(c.ClaimsServiceErrorMessages.FAILED_TO_FETCH_CONFIGURATIONS,e)),new Error(c.ClaimsServiceErrorMessages.FAILED_TO_FETCH_CONFIGURATIONS)}}async getClaims(){try{const e=await this.getRequestHeaders(),t=`${this.getClaimsApiUrl()}/claims`,r=await o(this,a,"f").call(this,t,{headers:e});if(!r.ok){throw await(0,u.getErrorFromResponse)(r)}return await r.json()}catch(e){throw d("getClaims",e),o(this,i,"f").captureException?.((0,u.createSentryError)(c.ClaimsServiceErrorMessages.FAILED_TO_GET_CLAIMS,e)),new Error(c.ClaimsServiceErrorMessages.FAILED_TO_GET_CLAIMS)}}async getClaimById(e){try{const t=await this.getRequestHeaders(),r=`${this.getClaimsApiUrl()}/claims/byId/${e}`,n=await o(this,a,"f").call(this,r,{headers:t});if(!n.ok){throw await(0,u.getErrorFromResponse)(n)}return await n.json()}catch(e){throw d("getClaimById",e),o(this,i,"f").captureException?.((0,u.createSentryError)(c.ClaimsServiceErrorMessages.FAILED_TO_GET_CLAIM_BY_ID,e)),new Error(c.ClaimsServiceErrorMessages.FAILED_TO_GET_CLAIM_BY_ID)}}async generateMessageForClaimSignature(e,t){try{const r=await this.getRequestHeaders(),n=`${this.getClaimsApiUrl()}/signature/generateMessage`,i=await o(this,a,"f").call(this,n,{method:"POST",headers:{...r,"Content-Type":"application/json"},body:JSON.stringify({chainId:e,walletAddress:t})});if(!i.ok){throw await(0,u.getErrorFromResponse)(i)}return await i.json()}catch(e){throw d("generateMessageForClaimSignature",e),o(this,i,"f").captureException?.((0,u.createSentryError)(c.ClaimsServiceErrorMessages.SIGNATURE_MESSAGE_GENERATION_FAILED,e)),new Error(c.ClaimsServiceErrorMessages.SIGNATURE_MESSAGE_GENERATION_FAILED)}}async getRequestHeaders(){return{Authorization:`Bearer ${await o(this,i,"f").call("AuthenticationController:getBearerToken")}`}}getClaimsApiUrl(){return`${c.CLAIMS_API_URL_MAP[o(this,n,"f")]}`}},n=new WeakMap,a=new WeakMap,i=new WeakMap}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/ClaimsService.cjs"}],[1630,{"@metamask/controller-utils":1641},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.DEFAULT_CLAIMS_CONFIGURATIONS=r.ClaimsServiceErrorMessages=r.ClaimsControllerErrorMessages=r.CLAIMS_API_URL_MAP=r.ClaimStatusEnum=r.Env=r.SERVICE_NAME=r.CONTROLLER_NAME=void 0;const n=e("@metamask/controller-utils");var a,i;r.CONTROLLER_NAME="ClaimsController",r.SERVICE_NAME="ClaimsService",function(e){e.DEV="dev",e.UAT="uat",e.PRD="prd"}(a||(r.Env=a={})),function(e){e.CREATED="created",e.SUBMITTED="submitted",e.IN_PROGRESS="in_progress",e.WAITING_FOR_CUSTOMER="waiting_for_customer",e.APPROVED="approved",e.REJECTED="rejected",e.UNKNOWN="unknown"}(i||(r.ClaimStatusEnum=i={})),r.CLAIMS_API_URL_MAP={[a.DEV]:"https://claims.dev-api.cx.metamask.io",[a.UAT]:"https://claims.uat-api.cx.metamask.io",[a.PRD]:"https://claims.api.cx.metamask.io"},r.ClaimsControllerErrorMessages={CLAIM_ALREADY_SUBMITTED:"Claim already submitted",INVALID_CLAIM_SIGNATURE:"Invalid claim signature",INVALID_SIGNATURE_MESSAGE:"Invalid signature message"},r.ClaimsServiceErrorMessages={FAILED_TO_FETCH_CONFIGURATIONS:"Failed to fetch claims configurations",FAILED_TO_GET_CLAIMS:"Failed to get claims",FAILED_TO_GET_CLAIM_BY_ID:"Failed to get claim by id",SIGNATURE_MESSAGE_GENERATION_FAILED:"Failed to generate message for claim signature",CLAIM_SIGNATURE_VERIFICATION_REQUEST_FAILED:"Failed to verify claim signature"},r.DEFAULT_CLAIMS_CONFIGURATIONS={validSubmissionWindowDays:21,supportedNetworks:[n.ChainId[n.BuiltInNetworkName.Mainnet],n.ChainId[n.BuiltInNetworkName.LineaMainnet]]}}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/constants.cjs"}],[1631,{"./ClaimsController.cjs":1628,"./ClaimsService.cjs":1629,"./constants.cjs":1630},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.CLAIMS_API_URL_MAP=r.ClaimsServiceErrorMessages=r.DEFAULT_CLAIMS_CONFIGURATIONS=r.ClaimsControllerErrorMessages=r.Env=r.ClaimStatusEnum=r.ClaimsService=r.getDefaultClaimsControllerState=r.ClaimsController=void 0;var n=e("./ClaimsController.cjs");Object.defineProperty(r,"ClaimsController",{enumerable:!0,get:function(){return n.ClaimsController}}),Object.defineProperty(r,"getDefaultClaimsControllerState",{enumerable:!0,get:function(){return n.getDefaultClaimsControllerState}});var a=e("./ClaimsService.cjs");Object.defineProperty(r,"ClaimsService",{enumerable:!0,get:function(){return a.ClaimsService}});var i=e("./constants.cjs");Object.defineProperty(r,"ClaimStatusEnum",{enumerable:!0,get:function(){return i.ClaimStatusEnum}}),Object.defineProperty(r,"Env",{enumerable:!0,get:function(){return i.Env}}),Object.defineProperty(r,"ClaimsControllerErrorMessages",{enumerable:!0,get:function(){return i.ClaimsControllerErrorMessages}}),Object.defineProperty(r,"DEFAULT_CLAIMS_CONFIGURATIONS",{enumerable:!0,get:function(){return i.DEFAULT_CLAIMS_CONFIGURATIONS}}),Object.defineProperty(r,"ClaimsServiceErrorMessages",{enumerable:!0,get:function(){return i.ClaimsServiceErrorMessages}}),Object.defineProperty(r,"CLAIMS_API_URL_MAP",{enumerable:!0,get:function(){return i.CLAIMS_API_URL_MAP}})}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/index.cjs"}],[1632,{"./constants.cjs":1630,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}});const a=e("./constants.cjs");r.projectLogger=(0,n.createProjectLogger)(a.CONTROLLER_NAME)}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/logger.cjs"}],[1633,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createSentryError=r.getErrorFromResponse=void 0,r.getErrorFromResponse=async function(e){const t=e.headers?.get("content-type"),r=e.status;try{if(t?.includes("application/json")){const t=await e.json(),n=`error: ${t?.error??t?.message??"Unknown error"}, statusCode: ${r}`;return new Error(n)}if(t?.includes("text/plain")){const t=`error: ${await e.text()}, statusCode: ${r}`;return new Error(t)}const n=`error: ${"data"in e&&"string"==typeof e.data?e.data:"Unknown error"}, statusCode: ${r}`;return new Error(n)}catch{return new Error(`HTTP ${r} error`)}},r.createSentryError=function(e,t){const r=new Error(e);return r.cause=t,r}}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/utils.cjs"}],[1634,{"./types.cjs":1636,"@metamask/base-controller":1522},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ConnectivityController=r.getDefaultConnectivityControllerState=r.controllerName=void 0;const n=e("@metamask/base-controller"),a=e("./types.cjs");r.controllerName="ConnectivityController";const i={connectivityStatus:{persist:!1,includeInDebugSnapshot:!0,includeInStateLogs:!0,usedInUi:!0}};function s(){return{connectivityStatus:a.CONNECTIVITY_STATUSES.Online}}r.getDefaultConnectivityControllerState=s;class o extends n.BaseController{constructor({messenger:e,connectivityAdapter:t}){const n=t.getStatus();super({messenger:e,metadata:i,name:r.controllerName,state:{...s(),connectivityStatus:n}}),t.onConnectivityChange(e=>{this.update(t=>{t.connectivityStatus=e})})}}r.ConnectivityController=o}}},{package:"@metamask/connectivity-controller",file:"node_modules/@metamask/connectivity-controller/dist/ConnectivityController.cjs"}],[1635,{"./ConnectivityController.cjs":1634,"./types.cjs":1636},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getDefaultConnectivityControllerState=r.ConnectivityController=r.CONNECTIVITY_STATUSES=void 0;var n=e("./types.cjs");Object.defineProperty(r,"CONNECTIVITY_STATUSES",{enumerable:!0,get:function(){return n.CONNECTIVITY_STATUSES}});var a=e("./ConnectivityController.cjs");Object.defineProperty(r,"ConnectivityController",{enumerable:!0,get:function(){return a.ConnectivityController}}),Object.defineProperty(r,"getDefaultConnectivityControllerState",{enumerable:!0,get:function(){return a.getDefaultConnectivityControllerState}})}}},{package:"@metamask/connectivity-controller",file:"node_modules/@metamask/connectivity-controller/dist/index.cjs"}],[1636,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.CONNECTIVITY_STATUSES=void 0,r.CONNECTIVITY_STATUSES={Online:"online",Offline:"offline"}}}},{package:"@metamask/connectivity-controller",file:"node_modules/@metamask/connectivity-controller/dist/types.cjs"}],[1637,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports={"0x12652C6d93FDB6F4f37d48A8687783C782BB0d10":{name:"Entangle",logo:"NGL.svg",erc20:!0,symbol:"NGL",decimals:18},"0xB50721BCf8d664c30412Cfbc6cf7a15145234ad1":{name:"Arbitrum",logo:"Arb.svg",erc20:!0,symbol:"ARB",decimals:18},"0x4D0528598F916Fd1D8dc80e5f54a8fEEDcFd4b18":{name:"Atoshi",logo:"ATOS.svg",erc20:!0,symbol:"ATOS",decimals:18},"0x57B946008913B82E4dF85f501cbAeD910e58D26C":{name:"POND",logo:"POND.svg",erc20:!0,symbol:"POND",decimals:18},"0x5eed99d066a8CaF10f3E4327c1b3D8b673485eED":{name:"SEED",logo:"SEED.svg",erc20:!0,symbol:"SEED",decimals:18},"0x487d62468282Bd04ddf976631C23128A425555EE":{name:"UPCX",logo:"UPC.svg",erc20:!0,symbol:"UPC",decimals:5},"0xd3210F246Ae54C5a45A7b4A83315bf718F591bfc":{name:"ArkiTech",logo:"ARKI.svg",erc20:!0,symbol:"ARKI",decimals:9},"0x7d51888C5ABb7CDfa9cdd6A50673c7F8afAccD7F":{name:"DuckDAO Token",logo:"duckdao.svg",erc20:!0,symbol:"DD",decimals:18},"0x49642110B712C1FD7261Bc074105E9E44676c68F":{name:"DinoLFG",logo:"DINO.svg",erc20:!0,symbol:"DINO",decimals:18},"0xB8BAa0e4287890a5F79863aB62b7F175ceCbD433":{name:"Swerve DAO Token",logo:"swrv.svg",erc20:!0,symbol:"SWRV",decimals:18},"0x8b79656FC38a04044E495e22fAD747126ca305C4":{name:"AgaveCoin",logo:"agvc.svg",erc20:!0,symbol:"AGVC",decimals:18},"0x967da4048cD07aB37855c090aAF366e4ce1b9F48":{name:"Ocean Token",logo:"ocean.svg",erc20:!0,symbol:"OCEAN",decimals:18},"0x83e6f1E41cdd28eAcEB20Cb649155049Fac3D5Aa":{name:"PolkastarterToken",logo:"pols.svg",erc20:!0,symbol:"POLS",decimals:18},"0x08d967bb0134F2d07f7cfb6E246680c53927DD30":{name:"MATH Token",logo:"math.svg",erc20:!0,symbol:"MATH",decimals:18},"0xccC8cb5229B0ac8069C51fd58367Fd1e622aFD97":{name:"Gods Unchained",logo:"gods.svg",erc20:!0,symbol:"GODS",decimals:18},"0xF57e7e7C23978C3cAEC3C3548E3D615c346e79fF":{name:"Immutable X",logo:"imx.svg",erc20:!0,symbol:"IMX",decimals:18},"0x40D16FC0246aD3160Ccc09B8D0D3A2cD28aE6C2f":{name:"Gho Token",logo:"GHO.svg",erc20:!0,symbol:"GHO",decimals:18},"0x536381a8628dBcC8C70aC9A30A7258442eAb4c92":{name:"Pantos Token ",logo:"pan.svg",erc20:!0,symbol:"PAN",decimals:8},"0x011E128Ec62840186F4A07E85E3ACe28858c5606":{name:"Valeria",logo:"val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x6c3ea9036406852006290770BEdFcAbA0e23A0e8":{name:"PayPal USD",logo:"pyusd.svg",erc20:!0,symbol:"PYUSD",decimals:6},"0x8b385Ca3592A5EFc34E0C9fE663de56897F1751F":{name:"INFibit",logo:"INFibit.svg",erc20:!0,symbol:"IBIT",decimals:18},"0x9bf1D7D63dD7a4ce167CF4866388226EEefa702E":{name:"Ben Coin",logo:"BEN.svg",erc20:!0,symbol:"BEN",decimals:18},"0xC7a2572fA8FDB0f7E81d6D3c4e3CCF78FB0DC374":{name:"Bens Finale",logo:"BensFinale.svg",erc20:!0,symbol:"FINALE",decimals:18},"0x99cFB8cBA9c821B4a343c6a1Fc630465C9708DF5":{name:"Pepe Inu",logo:"PepeInu.svg",erc20:!0,symbol:"$PEPEINU",decimals:18},"0xCEBA2a8F6Ec221AEB5f3a7bcd15Cbc7e6a387bfb":{name:"Peter Pan",logo:"PeterPan.svg",erc20:!0,symbol:"PAN",decimals:18},"0x467719aD09025FcC6cF6F8311755809d45a5E5f3":{name:"Axelar",logo:"axelar.svg",erc20:!0,symbol:"AXL",decimals:6},"0x665F77fbA5975ab40Ce61c90F28007fb5b09D7B1":{name:"Genieswap",logo:"Genieswap.svg",erc20:!0,symbol:"GENIE",decimals:18},"0x09E6d500D14D13e0528d2c0fff24E5ffF68237B4":{name:"Dohrnii",logo:"dhn.svg",erc20:!0,symbol:"DHN",decimals:18},"0xaE0585a259A3BCAB258D6EE02FB583f7B33C2a12":{name:"TempleCoin",logo:"tem.svg",erc20:!0,symbol:"TEM",decimals:18},"0xaeDf386B755465871fF874E3E37Af5976E247064":{name:"Fasttoken",logo:"ftn.svg",erc20:!0,symbol:"FTN",decimals:18},"0x7BEF710a5759d197EC0Bf621c3Df802C2D60D848":{name:"SHOPX",logo:"SHOPX.svg",erc20:!0,symbol:"SHOPX",decimals:18},"0xBa3335588D9403515223F109EdC4eB7269a9Ab5D":{name:"Gearbox",logo:"gear.svg",erc20:!0,symbol:"GEAR",decimals:18},"0x9B6B9d2468E165a02FEf69E61B6D3D6CBC0Ac409":{name:"OASISLIFE",logo:"OFE.svg",erc20:!0,symbol:"OFE",decimals:18},"0xdf0162A6B3e9fDf0302c1e949739DeeaFafd8F89":{name:"METAOASIS",logo:"MOA.svg",erc20:!0,symbol:"MOA",decimals:18},"0xe4dae00bc1c46ea2F44ae71B1BEb8b171C15d812":{name:"PREMA",logo:"PREMA.svg",erc20:!0,symbol:"PRMX",decimals:18},"0x1416946162B1C2c871A73B07E932D2fB6C932069":{name:"Energi",logo:"energi.svg",erc20:!0,symbol:"NRG",decimals:18},"0x0d88eD6E74bbFD96B831231638b66C05571e824F":{name:"Aventus",logo:"aventus.svg",erc20:!0,symbol:"AVT",decimals:18},"0x4FC15c91a9c4A9efB404174464687E8e128730C2":{name:"STAT",logo:"STAT.svg",erc20:!0,erc721:!1,symbol:"STAT",decimals:18},"0x4ad7a056191F4c9519fAcd6D75FA94CA26003aCE":{name:"GoldPesa Option",logo:"GPO.svg",erc20:!0,symbol:"GPO",decimals:18},"0x767FE9EDC9E0dF98E07454847909b5E959D7ca0E":{name:"Illuvium",logo:"illuvium.svg",erc20:!0,erc721:!1,symbol:"ILV",decimals:18},"0x85F17Cf997934a597031b2E18a9aB6ebD4B9f6a4":{name:"NEAR",logo:"NEAR.svg",erc20:!0,symbol:"NEAR",decimals:24},"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2":{name:"SushiSwap",logo:"sushi.svg",erc20:!0,erc721:!1,symbol:"SUSHI",decimals:18},"0x881Ba05de1E78f549cC63a8f6Cabb1d4AD32250D":{name:"00",logo:"00.svg",erc20:!0,erc721:!1,symbol:"00",decimals:18},"0xC211477cb4098aC22a98432781f5f26a1E07a4d4":{name:"CULTURED",logo:"CULTURED.svg",erc20:!0,erc721:!1,symbol:"CULTURED",decimals:18},"0x86f2A193b116d1f9C53Ed26d97F77cDC8BcF4c2b":{name:"EHTAGA",logo:"EHTAGA.svg",erc20:!0,erc721:!1,symbol:"EHTAGA",decimals:18},"0x54b79A15b2e2c55c736A66bb0A978fb840407aC8":{name:"FEVER",logo:"FEVER.svg",erc20:!0,erc721:!1,symbol:"FEVER",decimals:18},"0x677c9fE4396D3D13A0F9013a8118eAE386C843A5":{name:"IAM",logo:"IAM.svg",erc20:!0,erc721:!1,symbol:"IAM",decimals:18},"0xf63c65E855020E4B74f0Ad842D9537dA0E6162eC":{name:"ISH",logo:"ISH.svg",erc20:!0,erc721:!1,symbol:"ISH",decimals:18},"0xc105fA46510F32c0444CCdB4e51065da95caA1B4":{name:"LITA",logo:"LITA.svg",erc20:!0,erc721:!1,symbol:"LITA",decimals:18},"0x5401F949cDfa3E5aF32538167c0314230769209C":{name:"MAHCOIN",logo:"MAHCOIN.svg",erc20:!0,erc721:!1,symbol:"MAHCOIN",decimals:18},"0x711D2C47aFf84B96AD0F36983b1c41Be2C509e18":{name:"NIKITA",logo:"NIKITA.svg",erc20:!0,erc721:!1,symbol:"NIKITA",decimals:18},"0x3C44aEc33993b6830e5C2a705ea879b9C9ba0f7c":{name:"NYELA",logo:"NYELA.svg",erc20:!0,erc721:!1,symbol:"NYELA",decimals:18},"0xfa9096c99e687ea8E0064C23DAaCFE87cc99E4Ba":{name:"RON",logo:"RON.svg",erc20:!0,erc721:!1,symbol:"RON",decimals:18},"0x287a7C95aD00bBDd48599Ad2919567fD09281f07":{name:"STEELO",logo:"STEELO.svg",erc20:!0,erc721:!1,symbol:"STEELO",decimals:18},"0x2Ec3275f7aCe4044e499823F511cd58250be8E3d":{name:"Privilege",logo:"prvg.svg",erc20:!0,symbol:"PRVG",decimals:8},"0x65BB569FAaDD324a00883FdE4c46346cc96D5c0A":{name:"Provide",logo:"prvd.svg",erc20:!0,symbol:"PRVD",decimals:8},"0xB4272071eCAdd69d933AdcD19cA99fe80664fc08":{name:"CryptoFranc",logo:"XCHF.svg",erc20:!0,symbol:"XCHF",decimals:18},"0x5aFE3855358E112B5647B952709E6165e1c1eEEe":{name:"Safe Token",logo:"safe-green-token.svg",erc20:!0,symbol:"SAFE",decimals:18},"0x9C8fF314C9Bc7F6e59A9d9225Fb22946427eDC03":{name:"Nouns",erc20:!1,erc721:!0,symbol:"NOUN",decimals:0,logo:"nouns.svg"},"0xBC4CA0EdA7647A8aB7C2061c2E118A18a936f13D":{name:"BoredApeYachtClub",erc20:!1,erc721:!0,symbol:"BAYC",decimals:0,logo:"bayc.svg"},"0x08D7C0242953446436F34b4C78Fe9da38c73668d":{name:"PROOF Collective",erc20:!1,erc721:!0,symbol:"PROOF",decimals:0,logo:"proof.svg"},"0x23581767a106ae21c074b2276D25e5C3e136a68b":{name:"Moonbirds",erc20:!1,erc721:!0,symbol:"MOONBIRD",decimals:0,logo:"moonbirds.svg"},"0x60E4d786628Fea6478F785A6d7e704777c86a7c6":{name:"MutantApeYachtClub",erc20:!1,erc721:!0,symbol:"MAYC",decimals:0,logo:"mayc.svg"},"0x49cF6f5d44E70224e2E23fDcdd2C053F30aDA28B":{name:"CloneX",erc20:!1,erc721:!0,symbol:"CloneX",decimals:0,logo:"clonex.svg"},"0x8a90CAb2b38dba80c64b7734e58Ee1dB38B8992e":{name:"Doodles",erc20:!1,erc721:!0,symbol:"DOODLE",decimals:0,logo:"doodles.svg"},"0xED5AF388653567Af2F388E6224dC7C4b3241C544":{name:"Azuki",erc20:!1,erc721:!0,symbol:"AZUKI",decimals:0,logo:"azuki.svg"},"0xa3AEe8BcE55BEeA1951EF834b99f3Ac60d1ABeeB":{name:"VeeFriends",erc20:!1,erc721:!0,symbol:"VFT",decimals:0,logo:"veefriends.svg"},"0x34d85c9CDeB23FA97cb08333b511ac86E1C4E258":{name:"Otherdeed",erc20:!1,erc721:!0,symbol:"OTHR",decimals:0,logo:"otherdeed.svg"},"0xBBc2AE13b23d715c30720F079fcd9B4a74093505":{name:"Ethernity Chain Token",logo:"ERN.svg",erc20:!0,symbol:"ERN",decimals:18},"0x243cACb4D5fF6814AD668C3e225246efA886AD5a":{name:"Shina Inu",logo:"shina.svg",erc20:!0,symbol:"SHI",decimals:18},"0xD057B63f5E69CF1B929b356b579Cba08D7688048":{name:"CoW Protocol Virtual Token",logo:"vCOW.svg",erc20:!0,symbol:"vCOW",decimals:18},"0xDEf1CA1fb7FBcDC777520aa7f396b4E015F497aB":{name:"CoW Protocol Token",logo:"COW.svg",erc20:!0,symbol:"COW",decimals:18},"0xEd04915c23f00A313a544955524EB7DBD823143d":{name:"Alchemy Pay",logo:"ACH.svg",erc20:!0,symbol:"ACH",decimals:8},"0xeDF6568618A00C6F0908Bf7758A16F76B6E04aF9":{name:"Arianee",logo:"aria20.svg",erc20:!0,symbol:"ARIA20",decimals:18},"0x88D8DA2A8D0fA5b1f4E38030AC486aDE0AFA2798":{name:"Terrapass Coin",logo:"tpsc.svg",erc20:!0,symbol:"TPSC",decimals:18},"0x4730fB1463A6F1F44AEB45F6c5c422427f37F4D0":{name:"The 4th Pillar Token",logo:"four.svg",erc20:!0,symbol:"FOUR",decimals:18},"0x875773784Af8135eA0ef43b5a374AaD105c5D39e":{name:"Idle DAO Token",logo:"idle.svg",erc20:!0,symbol:"IDLE",decimals:18},"0x6BeA7CFEF803D1e3d5f7C0103f7ded065644e197":{name:"Gamma",logo:"Gamma.svg",erc20:!0,symbol:"GAMMA",decimals:18},"0x26805021988F1a45dC708B5FB75Fc75F21747D8c":{name:"xGamma",logo:"xGamma.svg",erc20:!0,symbol:"xGAMMA",decimals:18},"0xc7D9c108D4E1dD1484D3e2568d7f74bfD763d356":{name:"SORA Synthetic USD",logo:"sora-xstusd.svg",erc20:!0,symbol:"XSTUSD",decimals:18},"0x519C1001D550C0a1DaE7d1fC220f7d14c2A521BB":{name:"Polkaswap",logo:"sora-pswap.svg",erc20:!0,symbol:"PSWAP",decimals:18},"0x40FD72257597aA14C7231A7B1aaa29Fce868F677":{name:"SORA",logo:"sora-xor.svg",erc20:!0,symbol:"XOR",decimals:18},"0x909E34d3f6124C324ac83DccA84b74398a6fa173":{name:"$ZKP Token",logo:"ZKP.svg",erc20:!0,erc721:!1,symbol:"$ZKP",decimals:18},"0xe88f8313e61A97cEc1871EE37fBbe2a8bf3ed1E4":{name:"SORA Validator",logo:"sora-val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x7A58c0Be72BE218B41C608b7Fe7C5bB630736C71":{name:"ConstitutionDAO",logo:"PEOPLE.svg",erc20:!0,symbol:"PEOPLE",decimals:18},"0x32E6C34Cd57087aBBD59B5A4AECC4cB495924356":{name:"BitBase",logo:"BTBS.svg",erc20:!0,symbol:"BTBS",decimals:18},"0x3fa400483487A489EC9b1dB29C4129063EEC4654":{name:"Cryptokek.com",logo:"cryptokek.svg",erc20:!0,symbol:"KEK",decimals:18},"0xEd3D4e446A96dC3b181B64B75c3c70dA41dC3CBe":{name:"Vodra",logo:"Vodra.svg",erc20:!0,symbol:"VDR",decimals:18},"0xb753428af26E81097e7fD17f40c88aaA3E04902c":{name:"Spice",logo:"sfi.svg",erc20:!0,symbol:"SFI",decimals:18},"0xd084944d3c05CD115C09d072B9F44bA3E0E45921":{name:"Manifold Finance",logo:"Manifold.svg",erc20:!0,symbol:"FOLD",decimals:18},"0x9a0242b7a33DAcbe40eDb927834F96eB39f8fBCB":{name:"BABB",logo:"bax.svg",erc20:!0,symbol:"BAX",decimals:18},"0x4Cf89ca06ad997bC732Dc876ed2A7F26a9E7f361":{name:"Mysterium",logo:"MYST.svg",erc20:!0,symbol:"MYST",decimals:18},"0x697eF32B4a3F5a4C39dE1cB7563f24CA7BfC5947":{name:"Insula Token",logo:"Insula.svg",erc20:!0,symbol:"ISLA",decimals:18},"0x62Dc4817588d53a056cBbD18231d91ffCcd34b2A":{name:"DeHive",logo:"dehive.svg",erc20:!0,erc721:!1,symbol:"DHV",decimals:18},"0x8400D94A5cb0fa0D041a3788e395285d61c9ee5e":{name:"Unibright",logo:"ubt.svg",erc20:!0,symbol:"UBT",decimals:8},"0xfAd45E47083e4607302aa43c65fB3106F1cd7607":{name:"Hoge Finance",logo:"HogeFinanceLogo.svg",erc20:!0,symbol:"HOGE",decimals:9},"0xBB0E17EF65F82Ab018d8EDd776e8DD940327B28b":{name:"Axie Infinity Shard",logo:"AXS.svg",erc20:!0,symbol:"AXS",decimals:18},"0xCC8Fa225D80b9c7D42F96e9570156c65D6cAAa25":{name:"Smooth Love Potion",logo:"SLP.svg",erc20:!0,symbol:"SLP",decimals:0},"0x10633216E7E8281e33c86F02Bf8e565a635D9770":{name:"Dvision Network",logo:"dvision.svg",erc20:!0,symbol:"DVI",decimals:18},"0x898BAD2774EB97cF6b94605677F43b41871410B1":{name:"vEth2",logo:"vEth2.svg",erc20:!0,symbol:"vEth2",decimals:18},"0x321C2fE4446C7c963dc41Dd58879AF648838f98D":{name:"Cryptex Finance",logo:"ctx.svg",erc20:!0,symbol:"CTX",decimals:18},"0x16c52CeeCE2ed57dAd87319D91B5e3637d50aFa4":{name:"TCAP Token",logo:"tcap.svg",erc20:!0,symbol:"TCAP",decimals:18},"0xE94B97b6b43639E238c851A7e693F50033EfD75C":{name:"Rainbow Token",logo:"halodao-rnbw.svg",erc20:!0,symbol:"RNBW",decimals:18},"0x47BE779De87de6580d0548cde80710a93c502405":{name:"Rainbow Pool",logo:"halodao-xrnbw.svg",erc20:!0,symbol:"xRNBW",decimals:18},"0xe7aE6D0C56CACaf007b7e4d312f9af686a9E9a04":{name:"Vabble",logo:"VAB.svg",erc20:!0,symbol:"VAB",decimals:18},"0x853d955aCEf822Db058eb8505911ED77F175b99e":{name:"Frax",logo:"frax.svg",erc20:!0,symbol:"FRAX",decimals:18},"0x3432B6A60D23Ca0dFCa7761B7ab56459D9C964D0":{name:"Frax Share",logo:"fxs.svg",erc20:!0,symbol:"FXS",decimals:18},"0x84810bcF08744d5862B8181f12d17bfd57d3b078":{name:"SharedStake",logo:"sharedstake.svg",erc20:!0,symbol:"SGT",decimals:18},"0x75387e1287Dd85482aB66102DA9f6577E027f609":{name:"MindsyncAI",logo:"MAI.svg",erc20:!0,symbol:"MAI",decimals:18},"0x196f4727526eA7FB1e17b2071B3d8eAA38486988":{name:"Reserve",logo:"rsv.svg",erc20:!0,symbol:"RSV",decimals:18},"0x320623b8E4fF03373931769A31Fc52A4E78B5d70":{name:"Reserve Rights",logo:"rsr.svg",erc20:!0,symbol:"RSR",decimals:18},"0x1cF4592ebfFd730c7dc92c1bdFFDfc3B9EfCf29a":{name:"WAVES",logo:"waves.svg",erc20:!0,symbol:"WAVES",decimals:18},"0x252739487C1fa66eaeaE7CED41d6358aB2a6bCa9":{name:"ArCoin",logo:"ArCoin.svg",erc20:!0,symbol:"RCOIN",decimals:8},"0x18aAA7115705e8be94bfFEBDE57Af9BFc265B998":{name:"Audius",logo:"audius.svg",erc20:!0,symbol:"AUDIO",decimals:18},"0x8E3BCC334657560253B83f08331d85267316e08a":{name:"Rubic",logo:"brbc.svg",erc20:!0,symbol:"BRBC",decimals:18},"0xca1207647Ff814039530D7d35df0e1Dd2e91Fa84":{name:"dHEDGE DAO Token",logo:"DHT.svg",erc20:!0,symbol:"DHT",decimals:18},"0x6243d8CEA23066d098a15582d81a598b4e8391F4":{name:"Reflexer Ungovernance Token",logo:"flx.svg",erc20:!0,symbol:"FLX",decimals:18},"0x03ab458634910AaD20eF5f1C8ee96F1D6ac54919":{name:"Rai Reflex Index",logo:"rai.svg",erc20:!0,symbol:"RAI",decimals:18},"0xF25c91C87e0B1fd9B4064Af0F427157AaB0193A7":{name:"BASIC Token",logo:"basic.svg",erc20:!0,symbol:"BASIC",decimals:18},"0x53C8395465A84955c95159814461466053DedEDE":{name:"DeGate Token",logo:"DG.svg",erc20:!0,symbol:"DG",decimals:18},"0xBCf9dBf8B14eD096B2BA08b7269356197fDd1b5D":{name:"Avaluse",logo:"avaluse.svg",erc20:!0,symbol:"AVAL",decimals:18},"0x6E765D26388A17A6e86c49A8E41DF3F58aBcd337":{name:"Kangal",logo:"kangal.svg",erc20:!0,symbol:"KANGAL",decimals:18},"0x9AF4f26941677C706cfEcf6D3379FF01bB85D5Ab":{name:"DomRaiderToken",logo:"drt.svg",erc20:!0,symbol:"DRT",decimals:8},"0x06B179e292f080871825beD5D722162fD96B4c95":{name:"10x.gg",logo:"xgg.svg",erc20:!0,symbol:"XGG",decimals:18},"0xF29992D7b589A0A6bD2de7Be29a97A6EB73EaF85":{name:"DMScript",logo:"dmst.svg",erc20:!0,symbol:"DMST",decimals:18},"0x64aa3364F17a4D01c6f1751Fd97C2BD3D7e7f1D5":{name:"Olympus",logo:"OHM.svg",erc20:!0,symbol:"OHM",decimals:9},"0x0ab87046fBb341D058F17CBC4c1133F25a20a52f":{name:"Governance OHM",logo:"gOHM.svg",erc20:!0,symbol:"gOHM",decimals:18},"0xDd1Ad9A21Ce722C151A836373baBe42c868cE9a4":{name:"Universal Basic Income",logo:"ubi.svg",erc20:!0,symbol:"UBI",decimals:18},"0xf293d23BF2CDc05411Ca0edDD588eb1977e8dcd4":{name:"Sylo",logo:"SYLO.svg",erc20:!0,symbol:"SYLO",decimals:18},"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84":{name:"Liquid staked Ether 2.0",logo:"stETH.svg",erc20:!0,symbol:"stETH",decimals:18},"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0":{name:"Wrapped liquid staked Ether 2.0",logo:"wstETH.svg",erc20:!0,symbol:"wstETH",decimals:18},"0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32":{name:"Lido DAO Token",logo:"LDO.svg",erc20:!0,symbol:"LDO",decimals:18},"0xbd31EA8212119f94A611FA969881CBa3EA06Fa3d":{name:"LUNA Token",logo:"Luna.svg",erc20:!0,symbol:"LUNA",decimals:6},"0xa693B19d2931d498c5B318dF961919BB4aee87a5":{name:"UST Token",logo:"UST.svg",erc20:!0,symbol:"UST",decimals:6},"0xd2877702675e6cEb975b4A1dFf9fb7BAF4C91ea9":{name:"LUNA Token - Shuttle",logo:"lunc.svg",erc20:!0,symbol:"LUNC",decimals:18},"0xa47c8bf37f92aBed4A126BDA807A7b7498661acD":{name:"UST Token - Shuttle",logo:"ustc.svg",erc20:!0,symbol:"USTC",decimals:18},"0xcAAfF72A8CbBfc5Cf343BA4e26f65a257065bFF1":{name:"KRT Token - Shuttle",logo:"KRT.svg",erc20:!0,symbol:"KRT-S",decimals:18},"0x676Ad1b33ae6423c6618C1AEcf53BAa29cf39EE5":{name:"SDT Token - Shuttle",logo:"SDT.svg",erc20:!0,symbol:"SDT-S",decimals:18},"0x156B36ec68FdBF84a925230BA96cb1Ca4c4bdE45":{name:"MNT Token - Shuttle",logo:"MNT.svg",erc20:!0,symbol:"MNT-S",decimals:18},"0x09a3EcAFa817268f77BE1283176B946C4ff2E608":{name:"MIR Token - Shuttle",logo:"MIR.svg",erc20:!0,symbol:"MIR-S",decimals:18},"0xd36932143F6eBDEDD872D5Fb0651f4B72Fd15a84":{name:"Mirror AAPL Token - Shuttle",logo:"mAAPL.svg",erc20:!0,symbol:"mAAPL-S",decimals:18},"0x59A921Db27Dd6d4d974745B7FfC5c33932653442":{name:"Mirror GOOGL Token - Shuttle",logo:"mGOOGL.svg",erc20:!0,symbol:"mGOGL-S",decimals:18},"0x21cA39943E91d704678F5D00b6616650F066fD63":{name:"Mirror TSLA Token - Shuttle",logo:"mTSLA.svg",erc20:!0,symbol:"mTSLA-S",decimals:18},"0xC8d674114bac90148d11D3C1d33C61835a0F9DCD":{name:"Mirror NFLX Token - Shuttle",logo:"mNFLX.svg",erc20:!0,symbol:"mNFLX-S",decimals:18},"0x13B02c8dE71680e71F0820c996E4bE43c2F57d15":{name:"Mirror QQQ Token - Shuttle",logo:"mQQQ.svg",erc20:!0,symbol:"mQQQ-S",decimals:18},"0xEdb0414627E6f1e3F082DE65cD4F9C693D78CCA9":{name:"Mirror TWTR Token - Shuttle",logo:"mTWTR.svg",erc20:!0,symbol:"mTWTR-S",decimals:18},"0x41BbEDd7286dAab5910a1f15d12CBda839852BD7":{name:"Mirror MSFT Token - Shuttle",logo:"mMSFT.svg",erc20:!0,symbol:"mMSFT-S",decimals:18},"0x0cae9e4d663793c2a2A0b211c1Cf4bBca2B9cAa7":{name:"Mirror AMZN Token - Shuttle",logo:"mAMZN.svg",erc20:!0,symbol:"mAMZN-S",decimals:18},"0x56aA298a19C93c6801FDde870fA63EF75Cc0aF72":{name:"Mirror BABA Token - Shuttle",logo:"mBABA.svg",erc20:!0,symbol:"mBABA-S",decimals:18},"0x1d350417d9787E000cc1b95d70E9536DcD91F373":{name:"Mirror IAU Token - Shuttle",logo:"mIAU.svg",erc20:!0,symbol:"mIAU-S",decimals:18},"0x9d1555d8cB3C846Bb4f7D5B1B1080872c3166676":{name:"Mirror SLV Token - Shuttle",logo:"mSLV.svg",erc20:!0,symbol:"mSLV-S",decimals:18},"0x31c63146a635EB7465e5853020b39713AC356991":{name:"Mirror USO Token - Shuttle",logo:"mUSO.svg",erc20:!0,symbol:"mUSO-S",decimals:18},"0xf72FCd9DCF0190923Fadd44811E240Ef4533fc86":{name:"Mirror VIXY Token - Shuttle",logo:"mVIXY.svg",erc20:!0,symbol:"mVIXY-S",decimals:18},"0x21BfBDa47A0B4B5b1248c767Ee49F7caA9B23697":{name:"OVR",logo:"OVR.svg",erc20:!0,symbol:"OVR",decimals:18},"0x4691937a7508860F876c9c0a2a617E7d9E945D4B":{name:"Wootrade Network",logo:"wootrade.svg",erc20:!0,symbol:"WOO",decimals:18},"0xaf9f549774ecEDbD0966C52f250aCc548D3F36E5":{name:"RFUEL",logo:"RFUEL.svg",erc20:!0,symbol:"RFUEL",decimals:18},"0x7420B4b9a0110cdC71fB720908340C03F9Bc03EC":{name:"JasmyCoin",logo:"JASMY.svg",erc20:!0,symbol:"JASMY",decimals:18},"0x947AEb02304391f8fbE5B25D7D98D649b57b1788":{name:"Mandala Exchange Token",logo:"mandala.svg",erc20:!0,symbol:"MDX",decimals:18},"0xCdeee767beD58c5325f68500115d4B722b3724EE":{name:"Carbon",logo:"CRBN.svg",erc20:!0,symbol:"CRBN",decimals:18},"0xA4EED63db85311E22dF4473f87CcfC3DaDCFA3E3":{name:"Rubic",logo:"Rubic.svg",erc20:!0,symbol:"RBC",decimals:18},"0x3A880652F47bFaa771908C07Dd8673A787dAEd3A":{name:"DerivaDAO",logo:"DDX.svg",erc20:!0,symbol:"DDX",decimals:18},"0xbC396689893D065F41bc2C6EcbeE5e0085233447":{name:"Perpetual",logo:"PERP.svg",erc20:!0,symbol:"PERP",decimals:18},"0xeca82185adCE47f39c684352B0439f030f860318":{name:"Perlin",logo:"PERL.svg",erc20:!0,symbol:"PERL",decimals:18},"0xA1AFFfE3F4D611d252010E3EAf6f4D77088b0cd7":{name:"Reflect Finance",logo:"RFI.svg",erc20:!0,symbol:"RFI",decimals:9},"0xC0bA369c8Db6eB3924965e5c4FD0b4C1B91e305F":{name:"DLP Duck Token",logo:"dlpducktoken.svg",erc20:!0,symbol:"DUCK",decimals:18},"0xFbEEa1C75E4c4465CB2FCCc9c6d6afe984558E20":{name:"DuckDaoDime",logo:"ddim.svg",erc20:!0,symbol:"DDIM",decimals:18},"0x745407c86DF8DB893011912d3aB28e68B62E49B0":{name:"MahaDAO",logo:"MAHA.svg",erc20:!0,symbol:"MAHA",decimals:18},"0x8CC0F052fff7eaD7f2EdCCcaC895502E884a8a71":{name:"ARTH Valuecoin",logo:"ARTH.svg",erc20:!0,symbol:"ARTH",decimals:18},"0x3231Cb76718CDeF2155FC47b5286d82e6eDA273f":{name:"Monerium EUR",logo:"EURe.svg",erc20:!0,symbol:"EURe",decimals:18},"0x7ba92741Bf2A568abC6f1D3413c58c6e0244F8fD":{name:"Monerium GBP",logo:"GBPe.svg",erc20:!0,symbol:"GBPe",decimals:18},"0xBc5142e0CC5eB16b47c63B0f033d4c2480853a52":{name:"Monerium USD",logo:"USDe.svg",erc20:!0,symbol:"USDe",decimals:18},"0xC642549743A93674cf38D6431f75d6443F88E3E2":{name:"Monerium ISK",logo:"ISKe.svg",erc20:!0,symbol:"ISKe",decimals:18},"0x66a0f676479Cee1d7373f3DC2e2952778BfF5bd6":{name:"WISE Token",logo:"wise.svg",erc20:!0,symbol:"WISE",decimals:18},"0x72F020f8f3E8fd9382705723Cd26380f8D0c66Bb":{name:"PlotX",logo:"plotx.svg",erc20:!0,symbol:"PLOT",decimals:18},"0x44197A4c44D6A059297cAf6be4F7e172BD56Caaf":{name:"ELTCOIN",logo:"ELTCOIN.svg",erc20:!0,symbol:"ELT",decimals:8},"0x6781a0F84c7E9e846DCb84A9a5bd49333067b104":{name:"ZAP TOKEN",logo:"zapicon.svg",erc20:!0,symbol:"ZAP",decimals:18},"0x00c83aeCC790e8a4453e5dD3B0B4b3680501a7A7":{name:"SKALE",logo:"skl.svg",erc20:!0,symbol:"SKL",decimals:18},"0x674C6Ad92Fd080e4004b2312b45f796a192D27a0":{name:"Neutrino USD",logo:"usdn.svg",erc20:!0,symbol:"USDN",decimals:18},"0xE5CAeF4Af8780E59Df925470b050Fb23C43CA68C":{name:"Ferrum Network Token",logo:"frm.svg",erc20:!0,symbol:"FRM",decimals:6},"0x998FFE1E43fAcffb941dc337dD0468d52bA5b48A":{name:"Rupiah Token",logo:"idrt.svg",erc20:!0,symbol:"IDRT",decimals:2},"0x4E15361FD6b4BB609Fa63C81A2be19d873717870":{name:"Fantom",logo:"ftm.svg",erc20:!0,symbol:"FTM",decimals:18},"0x557B933a7C2c45672B610F8954A3deB39a51A8Ca":{name:"REVV",logo:"revv.svg",erc20:!0,symbol:"REVV",decimals:18},"0xFFC97d72E13E01096502Cb8Eb52dEe56f74DAD7B":{name:"Aave AAVE",logo:"aAAVE.svg",erc20:!0,symbol:"aAAVE",decimals:18},"0x05Ec93c0365baAeAbF7AefFb0972ea7ECdD39CF1":{name:"Aave BAT",logo:"aBAT.svg",erc20:!0,symbol:"aBAT",decimals:18},"0xA361718326c15715591c299427c62086F69923D9":{name:"Aave BUSD",logo:"aBUSD.svg",erc20:!0,symbol:"aBUSD",decimals:18},"0x028171bCA77440897B824Ca71D1c56caC55b68A3":{name:"Aave DAI",logo:"aDAI.svg",erc20:!0,symbol:"aDAI",decimals:18},"0xaC6Df26a590F08dcC95D5a4705ae8abbc88509Ef":{name:"Aave ENJ",logo:"aENJ.svg",erc20:!0,symbol:"aENJ",decimals:18},"0xD37EE7e4f452C6638c96536e68090De8cBcdb583":{name:"Aave GUSD",logo:"aGUSD.svg",erc20:!0,symbol:"aGUSD",decimals:2},"0x39C6b3e42d6A679d7D776778Fe880BC9487C2EDA":{name:"Aave KNC",logo:"aKNC.svg",erc20:!0,symbol:"aKNC",decimals:18},"0xa06bC25B5805d5F8d82847D191Cb4Af5A3e873E0":{name:"Aave LINK",logo:"aLINK.svg",erc20:!0,symbol:"aLINK",decimals:18},"0xa685a61171bb30d4072B338c80Cb7b2c865c873E":{name:"Aave MANA",logo:"aMANA.svg",erc20:!0,symbol:"aMANA",decimals:18},"0xc713e5E149D5D0715DcD1c156a020976e7E56B88":{name:"Aave MKR",logo:"aMKR.svg",erc20:!0,symbol:"aMKR",decimals:18},"0xCC12AbE4ff81c9378D670De1b57F8e0Dd228D77a":{name:"Aave REN",logo:"aREN.svg",erc20:!0,symbol:"aREN",decimals:18},"0x35f6B052C598d933D69A4EEC4D04c73A191fE6c2":{name:"Aave SNX",logo:"aSNX.svg",erc20:!0,symbol:"aSNX",decimals:18},"0x6C5024Cd4F8A59110119C56f8933403A539555EB":{name:"Aave SUSD",logo:"aSUSD.svg",erc20:!0,symbol:"aSUSD",decimals:18},"0x101cc05f4A51C0319f570d5E146a8C625198e636":{name:"Aave TUSD",logo:"aTUSD.svg",erc20:!0,symbol:"aTUSD",decimals:18},"0xB9D7CB55f463405CDfBe4E90a6D2Df01C2B92BF1":{name:"Aave UNI",logo:"aUNI.svg",erc20:!0,symbol:"aUNI",decimals:18},"0xBcca60bB61934080951369a648Fb03DF4F96263C":{name:"Aave USDC",logo:"aUSDC.svg",erc20:!0,symbol:"aUSDC",decimals:6},"0x3Ed3B47Dd13EC9a98b44e6204A523E766B225811":{name:"Aave USDT",logo:"aUSDT.svg",erc20:!0,symbol:"aUSDT",decimals:6},"0x9ff58f4fFB29fA2266Ab25e75e2A8b3503311656":{name:"Aave WBTC",logo:"aWBTC.svg",erc20:!0,symbol:"aWBTC",decimals:8},"0x030bA81f1c18d280636F32af80b9AAd02Cf0854e":{name:"Aave WETH",logo:"aWETH.svg",erc20:!0,symbol:"aWETH",decimals:18},"0x5165d24277cD063F5ac44Efd447B27025e888f37":{name:"Aave YFI",logo:"aYFI.svg",erc20:!0,symbol:"aYFI",decimals:18},"0xdef1fac7Bf08f173D286BbBDcBeeADe695129840":{name:"Defi Factory Token",logo:"DEFT.svg",erc20:!0,symbol:"DEFT",decimals:18},"0xDf7FF54aAcAcbFf42dfe29DD6144A69b629f8C9e":{name:"Aave ZRX",logo:"aZRX.svg",erc20:!0,symbol:"aZRX",decimals:18},"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9":{name:"Aave",logo:"AAVE.svg",erc20:!0,symbol:"AAVE",decimals:18},"0x44e2deC86B9F0e0266E9AA66e10323A2bd69CF9A":{name:"Attrace",logo:"attr.svg",erc20:!0,symbol:"ATTR",decimals:18},"0x1Da87b114f35E1DC91F72bF57fc07A768Ad40Bb0":{name:"Equalizer",logo:"EQZ.svg",erc20:!0,symbol:"EQZ",decimals:18},"0x4da27a545c0c5B758a6BA100e3a049001de870f5":{name:"Staked Aave",logo:"stkAAVE.svg",erc20:!0,symbol:"stAAVE",decimals:18},"0xba9d4199faB4f26eFE3551D490E3821486f135Ba":{name:"SwissBorg",logo:"chsb.svg",erc20:!0,symbol:"CHSB",decimals:8},"0x7DD9c5Cba05E151C895FDe1CF355C9A1D5DA6429":{name:"Golem Network Token",logo:"glm.svg",erc20:!0,symbol:"GLM",decimals:18},"0x7240aC91f01233BaAf8b064248E80feaA5912BA3":{name:"OctoFi",logo:"octo.svg",erc20:!0,symbol:"OCTO",decimals:18},"0xff56Cc6b1E6dEd347aA0B7676C85AB0B3D08B0FA":{name:"Orbs",logo:"orbs.svg",erc20:!0,symbol:"ORBS",decimals:18},"0x63f88A2298a5c4AEE3c216Aa6D926B184a4b2437":{name:"GAME Credits",logo:"GAMECreditsLogo.svg",erc20:!0,symbol:"GAME",decimals:18},"0x5150956E082C748Ca837a5dFa0a7C10CA4697f9c":{name:"Zeedex",logo:"zdex.svg",erc20:!0,symbol:"ZDEX",decimals:18},"0x84cA8bc7997272c7CfB4D0Cd3D55cd942B3c9419":{name:"DIAdata",logo:"dia.svg",erc20:!0,symbol:"DIA",decimals:18},"0xb78B3320493a4EFaa1028130C5Ba26f0B6085Ef8":{name:"Dracula",logo:"dracula.svg",erc20:!0,symbol:"DRC",decimals:18},"0xF433089366899D83a9f26A773D59ec7eCF30355e":{name:"Metal",logo:"mtl.svg",erc20:!0,symbol:"MTL",decimals:8},"0x85Eee30c52B0b379b046Fb0F85F4f3Dc3009aFEC":{name:"KEEP",logo:"keep.svg",erc20:!0,symbol:"KEEP",decimals:18},"0x8dAEBADE922dF735c38C80C7eBD708Af50815fAa":{name:"tBTC",logo:"tbtc.svg",erc20:!0,symbol:"TBTC",decimals:18},"0xD7EFB00d12C2c13131FD319336Fdf952525dA2af":{name:"Proton",logo:"proton.svg",erc20:!0,symbol:"XPR",decimals:4},"0x178c820f862B14f316509ec36b13123DA19A6054":{name:"Energy Web Token Bridged",logo:"ewtb.svg",erc20:!0,symbol:"EWTB",decimals:18},"0x2b591e99afE9f32eAA6214f7B7629768c40Eeb39":{name:"HEX",logo:"hex.svg",erc20:!0,symbol:"HEX",decimals:8},"0xFca59Cd816aB1eaD66534D82bc21E7515cE441CF":{name:"Rarible",logo:"rari.svg",erc20:!0,symbol:"RARI",decimals:18},"0x7865af71cf0b288b4E7F654f4F7851EB46a2B7F8":{name:"Sentivate",logo:"sentivate.svg",erc20:!0,symbol:"SNTVT",decimals:18},"0xa3d58c4E56fedCae3a7c43A725aeE9A71F0ece4e":{name:"Metronome",logo:"metronome.svg",erc20:!0,symbol:"MET",decimals:18},"0x49d716DFe60b37379010A75329ae09428f17118d":{name:"PoolTogether Dai",logo:"pldai.svg",erc20:!0,symbol:"PLDAI",decimals:18},"0xfE6892654CBB05eB73d28DCc1Ff938f59666Fe9f":{name:"PoolTogether Sai",logo:"plsai.svg",erc20:!0,symbol:"PLSAI",decimals:18},"0x5732046A883704404F284Ce41FfADd5b007FD668":{name:"Bluzelle Token",logo:"Bluzelle.svg",erc20:!0,symbol:"BLZ",decimals:18},"0xBD87447F48ad729C5c4b8bcb503e1395F62e8B98":{name:"PoolTogether USDC",logo:"plusdc.svg",erc20:!0,symbol:"PLUSDC",decimals:6},"0x69A95185ee2a045CDC4bCd1b1Df10710395e4e23":{name:"$Poolz Finance",logo:"Poolz.svg",erc20:!0,symbol:"POOLZ",decimals:18},"0x0adA190c81b814548ddC2F6AdC4a689ce7C1FE73":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAXIS",decimals:18},"0xb1dC9124c395c1e97773ab855d66E879f053A289":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAX",decimals:18},"0xeF31Cb88048416E301Fee1eA13e7664b887BA7e8":{name:"Staked yAxis",logo:"yaxis.svg",erc20:!0,symbol:"sYAX",decimals:18},"0x28cb7e841ee97947a86B06fA4090C8451f64c0be":{name:"YF Link",logo:"YFL.svg",erc20:!0,symbol:"YFL",decimals:18},"0x75D1aA733920b14fC74c9F6e6faB7ac1EcE8482E":{name:"YFLink Staking Share",logo:"YFL.svg",erc20:!0,symbol:"yYFL",decimals:18},"0x7b760D06E401f85545F3B50c44bf5B05308b7b62":{name:"YFLink USD",logo:"YFLUSD.svg",erc20:!0,symbol:"YFLUSD",decimals:18},"0x8282df223AC402d04B2097d16f758Af4F70e7Db0":{name:"YFLink Synthetic",logo:"sYFL.svg",erc20:!0,symbol:"sYFL",decimals:18},"0x008377EB0C62cE8e0BA3D7Bb4A5638591f21588E":{name:"YFLink Bond",logo:"bYFL.svg",erc20:!0,symbol:"bYFL",decimals:18},"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e":{name:"yearn.finance",logo:"yfi.svg",erc20:!0,symbol:"YFI",decimals:18},"0x261b45D85cCFeAbb11F022eBa346ee8D1cd488c0":{name:"rDAI",logo:"rdai.svg",erc20:!0,symbol:"rDAI",decimals:18},"0xea8b224eDD3e342DEb514C4176c2E72Bcce6fFF9":{name:"rSAI",logo:"rsai.svg",erc20:!0,symbol:"rSAI",decimals:18},"0x12B19D3e2ccc14Da04FAe33e63652ce469b3F2FD":{name:"GridPlus",logo:"GridPlus.svg",erc20:!0,symbol:"GRID",decimals:12},"0xDb05EA0877A2622883941b939f0bb11d1ac7c400":{name:"Opacity",logo:"opct.svg",erc20:!0,symbol:"OPCT",decimals:18},"0x4575f41308EC1483f3d399aa9a2826d74Da13Deb":{name:"Orchid",logo:"OXT.svg",erc20:!0,symbol:"OXT",decimals:18},"0x4CC19356f2D37338b9802aa8E8fc58B0373296E7":{name:"Selfkey",logo:"KEY.svg",erc20:!0,symbol:"KEY",decimals:18},"0x92A5B04D0ED5D94D7a193d1d334D3D16996f4E13":{name:"Eristica",logo:"Eristica.svg",erc20:!0,symbol:"ERT",decimals:18},"0xdAC17F958D2ee523a2206206994597C13D831ec7":{name:"Tether USD",logo:"usdt.svg",erc20:!0,symbol:"USDT",decimals:6},"0x06AF07097C9Eeb7fD685c692751D5C66dB49c215":{name:"Chai",logo:"CHAI.svg",erc20:!0,symbol:"CHAI",decimals:18},"0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828":{name:"UMA",logo:"uma.svg",erc20:!0,symbol:"UMA",decimals:18},"0x5f778ec4B31a506c1Dfd8b06F131E9B451a61D39":{name:"UPX Token",logo:"UPX.svg",erc20:!0,symbol:"UPX",decimals:18},"0xb1CD6e4153B2a390Cf00A6556b0fC1458C4A5533":{name:"ETHBNT Liquidity Pool",logo:"ETHBNT.svg",erc20:!0,symbol:"ETHBNT",decimals:18},"0xf0Ee6b27b759C9893Ce4f094b49ad28fd15A23e4":{name:"Enigma",logo:"enigma.svg",erc20:!0,symbol:"ENG",decimals:8},"0xaaAEBE6Fe48E54f431b0C390CfaF0b017d09D42d":{name:"Celsius",logo:"celsius.svg",erc20:!0,symbol:"CEL",decimals:4},"0xb683D83a532e2Cb7DFa5275eED3698436371cc9f":{name:"BTU",logo:"BTU.svg",erc20:!0,symbol:"BTU",decimals:18},"0x746DdA2ea243400D5a63e0700F190aB79f06489e":{name:"BOSAGORA",logo:"BOA.svg",erc20:!0,symbol:"BOA",decimals:7},"0x5D858bcd53E085920620549214a8b27CE2f04670":{name:"POP Network Token",logo:"POP.svg",erc20:!0,symbol:"POP",decimals:18},"0x048Fe49BE32adfC9ED68C37D32B5ec9Df17b3603":{name:"Skrumble Network V2",logo:"skm.svg",erc20:!0,symbol:"SKM",decimals:18},"0x16EA01aCB4b0Bca2000ee5473348B6937ee6f72F":{name:"Enecuum",logo:"ENQ-logo.svg",erc20:!0,symbol:"ENQ",decimals:10},"0xE5B826Ca2Ca02F09c1725e9bd98d9a8874C30532":{name:"ZEON Network",logo:"ZEON_logo.png",erc20:!0,symbol:"ZEON",decimals:18},"0x13cb85823f78Cff38f0B0E90D3e975b8CB3AAd64":{name:"REMIIT REMI Token",logo:"remi.svg",erc20:!0,symbol:"REMI",decimals:18},"0x93a7174dafd31d13400cD9fa01f4e5B5BAa00D39":{name:"Shaka",logo:"hak.svg",erc20:!0,symbol:"HAK",decimals:18},"0x6fB3e0A217407EFFf7Ca062D46c26E5d60a14d69":{name:"IoTeX",logo:"iotex.svg",erc20:!0,symbol:"IOTX",decimals:18},"0xE5a3229CCb22b6484594973A03a3851dCd948756":{name:"RAE Token",logo:"rae.svg",erc20:!0,symbol:"RAE",decimals:18},"0x4470BB87d77b963A013DB939BE332f927f2b992e":{name:"AdEx Legacy Token",logo:"adex.svg",erc20:!0,symbol:"ADXL",decimals:4},"0xADE00C28244d5CE17D72E40330B1c318cD12B7c3":{name:"AdEx Token",logo:"adex.svg",erc20:!0,symbol:"ADX",decimals:18},"0xDc5864eDe28BD4405aa04d93E05A0531797D9D59":{name:"Falcon",logo:"fnt.svg",erc20:!0,symbol:"FNT",decimals:6},"0x1966d718A565566e8E202792658D7b5Ff4ECe469":{name:"nDEX",logo:"nDEX.png",erc20:!0,symbol:"NDX",decimals:18},"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599":{name:"Wrapped BTC",logo:"wbtc.svg",erc20:!0,symbol:"WBTC",decimals:8},"0x150b0b96933B75Ce27af8b92441F8fB683bF9739":{name:"Dragonereum Gold",logo:"gold.svg",erc20:!0,symbol:"GOLD",decimals:18},"0x82f4dED9Cec9B5750FBFf5C2185AEe35AfC16587":{name:"DreamTeam Token",logo:"dream.svg",erc20:!0,symbol:"DREAM",decimals:6},"0x5d60d8d7eF6d37E16EBABc324de3bE57f135e0BC":{name:"MyBit",logo:"MYB.svg",erc20:!0,symbol:"MYB",decimals:18},"0x01FA555c97D7958Fa6f771f3BbD5CCD508f81e22":{name:"Civil Token",logo:"CVL_token.svg",erc20:!0,symbol:"CVL",decimals:18},"0x5adc961D6AC3f7062D2eA45FEFB8D8167d44b190":{name:"Dether",logo:"dether.svg",erc20:!0,symbol:"DTH",decimals:18},"0x3F17Dd476faF0a4855572F0B6ed5115D9bBA22AD":{name:"Wibson",logo:"wibson-logo.png",erc20:!0,symbol:"WIB",decimals:9},"0xDF347911910b6c9A4286bA8E2EE5ea4a39eB2134":{name:"Bob's Repair",logo:"bobsrepair.png",erc20:!0,symbol:"BOB",decimals:18},"0x3505F494c3f0fed0B594E01Fa41Dd3967645ca39":{name:"SWARM",logo:"swarm.svg",erc20:!0,symbol:"SWM",decimals:18},"0x6863bE0e7CF7ce860A574760e9020D519a8bDC47":{name:"On.Live",logo:"onlive.svg",erc20:!0,symbol:"ONL",decimals:18},"0xea5f88E54d982Cbb0c441cde4E79bC305e5b43Bc":{name:"Pareto",logo:"ParetoLogo.png",erc20:!0,symbol:"PARETO",decimals:18},"0x2e91E3e54C5788e9FdD6A181497FDcEa1De1bcc1":{name:"Hercules",logo:"herc.png",erc20:!0,symbol:"HERC",decimals:18},"0x4946Fcea7C692606e8908002e55A582af44AC121":{name:"FOAM",logo:"FOAM.svg",erc20:!0,symbol:"FOAM",decimals:18},"0x4D807509aECe24C0fa5A102b6a3B059Ec6E14392":{name:"Menlo One",logo:"Menlo_One.png",erc20:!0,symbol:"ONE",decimals:18},"0x27054b13b1B798B345b591a4d22e6562d47eA75a":{name:"AirSwap Token",logo:"AirSwapLogo.svg",erc20:!0,symbol:"AST",decimals:4},"0x8D5682941cE456900b12d47ac06a88b47C764CE1":{name:"RightMesh Token",logo:"Rmesh.png",erc20:!0,symbol:"RMESH",decimals:18},"0xDDe12a12A6f67156e0DA672be05c374e1B0a3e57":{name:"JOYSO",logo:"JOY.png",erc20:!0,symbol:"JOY",decimals:6},"0x0D262e5dC4A06a0F1c90cE79C7a60C09DfC884E4":{name:"JET8 Token",logo:"J8T.svg",erc20:!0,symbol:"J8T",decimals:8},"0x4a220E6096B25EADb88358cb44068A3248254675":{name:"Quant Network",logo:"quant-network.svg",erc20:!0,symbol:"QNT",decimals:18},"0xBC86727E770de68B1060C91f6BB6945c73e10388":{name:"Ink Protocol",logo:"ink_protocol.svg",erc20:!0,symbol:"XNK",decimals:18},"0xa95592DCFfA3C080B4B40E459c5f5692F67DB7F8":{name:"ELY Token",logo:"ely.png",erc20:!0,symbol:"ELY",decimals:18},"0x9E46A38F5DaaBe8683E10793b06749EEF7D733d1":{name:"PolySwarm Nectar",logo:"polyswarm_nectar.svg",erc20:!0,symbol:"NCT",decimals:18},"0xe1A178B681BD05964d3e3Ed33AE731577d9d96dD":{name:"BOX Token",logo:"box_token.png",erc20:!0,symbol:"BOX",decimals:18},"0x543Ff227F64Aa17eA132Bf9886cAb5DB55DCAddf":{name:"DAOstack",logo:"gen.svg",erc20:!0,symbol:"GEN",decimals:18},"0x6aEDbF8dFF31437220dF351950Ba2a3362168d1b":{name:"Dragonglass",logo:"dragonglass.svg",erc20:!0,symbol:"DGS",decimals:8},"0xd26114cd6EE289AccF82350c8d8487fedB8A0C07":{name:"OmiseGO",logo:"omg.svg",erc20:!0,symbol:"OMG",decimals:18},"0x99ea4dB9EE77ACD40B119BD1dC4E33e1C070b80d":{name:"Quantstamp",logo:"qsp.svg",erc20:!0,symbol:"QSP",decimals:18},"0xB64ef51C888972c908CFacf59B47C1AfBC0Ab8aC":{name:"Storj",logo:"storj.svg",erc20:!0,symbol:"STORJ",decimals:8},"0xD8E3FB3b08eBA982F2754988d70D57eDc0055ae6":{name:"Zoracles",logo:"zora.svg",erc20:!0,symbol:"ZORA",decimals:9},"0xF938424F7210f31dF2Aee3011291b658f872e91e":{name:"VISOR",logo:"VISR.svg",erc20:!0,symbol:"VISR",decimals:18},"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942":{name:"Decentraland",logo:"mana.svg",erc20:!0,symbol:"MANA",decimals:18},"0x0F513fFb4926ff82D7F60A05069047AcA295C413":{name:"CrowdstartCoin",logo:"XSC_Logo.svg",erc20:!0,symbol:"XSC",decimals:18},"0x5BC7e5f0Ab8b2E10D2D0a3F21739FCe62459aeF3":{name:"Hut34 Entropy Token",logo:"ENTRP.png",symbol:"ENTRP",erc20:!0,decimals:18},"0x946112efaB61C3636CBD52DE2E1392D7A75A6f01":{name:"HYDRO TOKEN",logo:"hydro.svg",erc20:!0,symbol:"HYDRO",decimals:18},"0x2604FA406Be957E542BEb89E6754fCdE6815e83f":{name:"Playkey Token",logo:"playkey.svg",erc20:!0,symbol:"PKT",decimals:18},"0xE41d2489571d322189246DaFA5ebDe1F4699F498":{name:"0x",logo:"zrx.svg",erc20:!0,symbol:"ZRX",decimals:18},"0x957c30aB0426e0C93CD8241E2c60392d08c6aC8e":{name:"Modum Token",logo:"modum.svg",erc20:!0,symbol:"MOD",decimals:0},"0x1a7a8BD9106F2B8D977E08582DC7d24c723ab0DB":{name:"AppCoins",logo:"appc.svg",erc20:!0,decimals:18,symbol:"APPC"},"0xdB25f211AB05b1c97D595516F45794528a807ad8":{name:"STASIS EURS Token",logo:"stasis-eurs.svg",erc20:!0,decimals:2,symbol:"EURS"},"0xCA0e7269600d353F70b14Ad118A49575455C0f2f":{name:"AMLT",logo:"amlt.png",erc20:!0,decimals:18,symbol:"AMLT"},"0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F":{name:"Synthetix Network Token",logo:"synthetix.svg",erc20:!0,decimals:18,symbol:"SNX"},"0x57Ab1ec28D129707052df4dF418D58a2D46d5f51":{name:"Synth sUSD",logo:"synthetix_susd.svg",erc20:!0,decimals:18,symbol:"SUSD"},"0x5e74C9036fb86BD7eCdcb084a0673EFc32eA31cb":{name:"Synth sETH",logo:"synthetix_seth.svg",erc20:!0,decimals:18,symbol:"SETH"},"0xfE18be6b3Bd88A2D2A7f928d00292E7a9963CfC6":{name:"Synth sBTC",logo:"synthetix_sbtc.svg",erc20:!0,decimals:18,symbol:"SBTC"},"0x0DB8D8b76BC361bAcbB72E2C491E06085A97Ab31":{name:"IQeon",logo:"iqeon.svg",erc20:!0,decimals:18,symbol:"IQN"},"0x000C100050E98C91f9114fa5Dd75CE6869Bf4F53":{name:"CRYPTO10 Hedged",logo:"c10.svg",erc20:!0,symbol:"C10",decimals:18},"0x26E75307Fc0C021472fEb8F727839531F112f317":{name:"Crypto20",logo:"c20.svg",erc20:!0,symbol:"C20",decimals:18},"0x06012c8cf97BEaD5deAe237070F9587f8E7A266d":{name:"Crypto Kitties",logo:"ck.svg",erc20:!1,erc721:!0,symbol:"CK",decimals:0},"0xE477292f1B3268687A29376116B0ED27A9c76170":{name:"Herocoin",logo:"herocoin_logo.png",erc20:!0,symbol:"PLAY",decimals:18},"0x4F4f0Db4de903B88f2B1a2847971E231D54F8fd3":{name:"Geens Platform Token",logo:"gee-icon.svg",erc20:!0,symbol:"GEE",decimals:8},"0xec67005c4E498Ec7f55E092bd1d35cbC47C91892":{name:"Enzyme Finance",logo:"mln.svg",erc20:!0,symbol:"MLN",decimals:18},"0xba2184520A1cC49a6159c57e61E1844E085615B6":{name:"HelloGold Token",logo:"hgt.png",erc20:!0,symbol:"HGT",decimals:8},"0xba358B6f5b4c0215650444B8C30D870B55050D2D":{name:"Hub Token",logo:"hub.svg",erc20:!0,symbol:"HUB",decimals:18},"0x8727c112C712c4a03371AC87a74dD6aB104Af768":{name:"Jetcoin Institute Token",logo:"JETCOIN28.png",erc20:!0,symbol:"JET",decimals:18},"0xf8e386EDa857484f5a12e4B5DAa9984E06E73705":{name:"Indorse Token",logo:"indorseLogo.jpg",erc20:!0,symbol:"IND",decimals:18},"0xA54ddC7B3CcE7FC8b1E3Fa0256D0DB80D2c10970":{name:"NEVERDIE Coin",logo:"ndc.png",erc20:!0,symbol:"NDC",decimals:18},"0x1c4481750daa5Ff521A2a7490d9981eD46465Dbd":{name:"BlockMason Credit Protocol Token",logo:"bcpt.svg",erc20:!0,symbol:"BCPT",decimals:18},"0x20F7A3DdF244dc9299975b4Da1C39F8D5D75f05A":{name:"Sapien Network Token",logo:"spn.svg",erc20:!0,symbol:"SPN",decimals:6},"0xA4e8C3Ec456107eA67d3075bF9e3DF3A75823DB0":{name:"Loom Token",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x42476F744292107e34519F9c357927074Ea3F75D":{name:"Loom",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x4F9254C83EB525f9FCf346490bbb3ed28a81C667":{name:"Celer Network Token",logo:"CELR.svg",erc20:!0,symbol:"CELR",decimals:18},"0x71D01dB8d6a2fBEa7f8d434599C237980C234e4C":{name:"Gladius",logo:"gladius.svg",erc20:!0,symbol:"GLA",decimals:8},"0xdd974D5C2e2928deA5F71b9825b8b646686BD200":{name:"Kyber Network Crystal",logo:"kyber.svg",erc20:!0,symbol:"KNC",decimals:18},"0x1F573D6Fb3F13d689FF844B4cE37794d79a7FF1C":{name:"Bancor Network Token",logo:"bnt.svg",erc20:!0,symbol:"BNT",decimals:18},"0xfa05A73FfE78ef8f1a739473e462c54bae6567D9":{name:"Lunyr Token",logo:"lun.svg",erc20:!0,symbol:"LUN",decimals:18},"0xC741f06082AA47F93729070aD0dD95E223Bda091":{name:"LEDU Token",logo:"edu.svg",erc20:!0,symbol:"LEDU",decimals:8},"0x5c543e7AE0A1104f78406C340E9C64FD9fCE5170":{name:"vSlice",logo:"vslice.png",erc20:!0,symbol:"VSL",decimals:18},"0x1f41E42D0a9e3c0Dd3BA15B527342783B43200A9":{name:"Blockchain Capital",logo:"bcap.svg",erc20:!0,symbol:"BCAP",decimals:0},"0x6531f133e6DeeBe7F2dcE5A0441aA7ef330B4e53":{name:"Chronobank TIME",logo:"chronobank.png",erc20:!0,symbol:"TIME",decimals:8},"0xaAAf91D9b90dF800Df4F55c205fd6989c977E73a":{name:"Monolith TKN",logo:"tkn.svg",erc20:!0,symbol:"TKN",decimals:8},"0x08711D3B02C8758F2FB3ab4e80228418a7F8e39c":{name:"Edgeless",logo:"edg.svg",erc20:!0,symbol:"EDG",decimals:0},"0xf7B098298f7C69Fc14610bf71d5e02c60792894C":{name:"Guppy",logo:"guppy.png",erc20:!0,symbol:"GUP",decimals:3},"0x4DF812F6064def1e5e029f1ca858777CC98D2D81":{name:"Xaurum",logo:"xaurum_logo.svg",erc20:!0,symbol:"XAUR",decimals:8},"0xB9e7F8568e08d5659f5D29C4997173d84CdF2607":{name:"Swarm City Token",logo:"swt.svg",erc20:!0,symbol:"SWT",decimals:18},"0xCb94be6f13A1182E4A4B6140cb7bf2025d28e41B":{name:"Trustcoin",logo:"trst.svg",erc20:!0,symbol:"TRST",decimals:6},"0xCB56b52316041A62B6b5D0583DcE4A8AE7a3C629":{name:"Cigarettes",logo:"cig.svg",erc20:!0,symbol:"CIG",decimals:18},"0x960b236A07cf122663c4303350609A66A7B288C0":{name:"Aragon Network Token v1",logo:"antv1.svg",erc20:!0,symbol:"ANTv1",decimals:18},"0x667088b212ce3d06a1b553a7221E1fD19000d9aF":{name:"WINGS",logo:"wings_logo.svg",erc20:!0,symbol:"WINGS",decimals:18},"0x16484d73Ac08d2355F466d448D2b79D2039F6EBB":{name:"FortKnoxster",logo:"FortKnoxster.svg",erc20:!0,symbol:"FKX",decimals:18},"0xAf30D2a7E90d7DC361c8C4585e9BB7D2F6f15bc7":{name:"FirstBlood Token",logo:"1st.svg",erc20:!0,symbol:"1ST",decimals:18},"0x607F4C5BB672230e8672085532f7e901544a7375":{name:"iExec RLC Token",logo:"rlc.svg",erc20:!0,symbol:"RLC",decimals:9},"0xaeC2E87E0A235266D9C5ADc9DEb4b2E29b54D009":{name:"SingularDTV",logo:"singulardtv.svg",erc20:!0,symbol:"SNGLS",decimals:0},"0x888666CA69E0f178DED6D75b5726Cee99A87D698":{name:"ICONOMI",logo:"iconomi.png",erc20:!0,symbol:"ICN",decimals:18},"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2":{name:"Maker",logo:"mkr.svg",erc20:!0,symbol:"MKR",decimals:18},"0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359":{name:"Sai Stablecoin v1.0",logo:"sai.svg",erc20:!0,symbol:"SAI",decimals:18},"0x6B175474E89094C44Da98b954EedeAC495271d0F":{name:"Dai Stablecoin",logo:"dai.svg",erc20:!0,symbol:"DAI",decimals:18},"0xC477D038d5420C6A9e0b031712f61c5120090de9":{name:"Boson Token",logo:"boson.svg",erc20:!0,symbol:"BOSON",decimals:18},"0xD46bA6D942050d489DBd938a2C909A5d5039A161":{name:"Ampleforth",logo:"ampl.svg",erc20:!0,symbol:"AMPL",decimals:9},"0x4b9278b94a1112cAD404048903b8d343a810B07e":{name:"Hifi Finance",logo:"hifi.svg",erc20:!0,symbol:"HIFI",decimals:18},"0x0D8775F648430679A709E98d2b0Cb6250d2887EF":{name:"Basic Attention Token",logo:"bat.svg",erc20:!0,symbol:"BAT",decimals:18},"0x4D8fc1453a0F359e99c9675954e656D80d996FbF":{name:"BEE Token",logo:"bee_token.svg",erc20:!0,symbol:"BEE",decimals:18},"0x6810e776880C02933D47DB1b9fc05908e5386b96":{name:"Gnosis Token",logo:"gnosis.svg",erc20:!0,symbol:"GNO",decimals:18},"0x514910771AF9Ca656af840dff83E8264EcF986CA":{name:"Chainlink Token",logo:"chainlink.svg",erc20:!0,symbol:"LINK",decimals:18},"0xD8912C10681D8B21Fd3742244f44658dBA12264E":{name:"Pluton",logo:"plutus-god.svg",erc20:!0,symbol:"PLU",decimals:18},"0x1985365e9f78359a9B6AD760e32412f4a445E862":{name:"Reputation Old",logo:"rep.svg",erc20:!0,symbol:"REP",decimals:18},"0x221657776846890989a759BA2973e427DfF5C9bB":{name:"Reputation",logo:"repv2.svg",erc20:!0,symbol:"REPv2",decimals:18},"0xd0929d411954c47438dc1d871dd6081F5C5e149c":{name:"Refereum",logo:"rfr.svg",erc20:!0,symbol:"RFR",decimals:4},"0xb0866289e870D2efc282406cF4123Df6E5BcB652":{name:"NoFakeCoin",logo:"nfticon.png",erc20:!0,symbol:"NFC",decimals:18},"0x2C4e8f2D746113d0696cE89B35F0d8bF88E0AEcA":{name:"Open Simple Token",logo:"OST.svg",erc20:!0,symbol:"OST",decimals:18},"0x408e41876cCCDC0F92210600ef50372656052a38":{name:"Republic Token",logo:"ren.svg",erc20:!0,symbol:"REN",decimals:18},"0xEB4C2781e4ebA804CE9a9803C67d0893436bB27D":{name:"renBTC",logo:"renBTC.svg",erc20:!0,symbol:"renBTC",decimals:8},"0x1C5db575E2Ff833E46a2E9864C22F4B22E0B37C2":{name:"renZEC",logo:"renZEC.svg",erc20:!0,symbol:"renZEC",decimals:8},"0x459086F2376525BdCebA5bDDA135e4E9d3FeF5bf":{name:"renBCH",logo:"renBCH.svg",erc20:!0,symbol:"renBCH",decimals:8},"0xD5147bc8e386d91Cc5DBE72099DAC6C9b99276F5":{name:"renFIL",logo:"renFIL.svg",erc20:!0,symbol:"renFIL",decimals:18},"0xa74476443119A942dE498590Fe1f2454d7D4aC0d":{name:"Golem Network Token",logo:"golem.svg",erc20:!0,symbol:"GNT",decimals:18},"0x6888a16eA9792c15A4DCF2f6C623D055c8eDe792":{name:"Spectiv Signal Token",logo:"spectiv.svg",erc20:!0,symbol:"SIG",decimals:18},"0x9a642d6b3368ddc662CA244bAdf32cDA716005BC":{name:"Qtum",logo:"qtum.svg",erc20:!0,decimals:18,symbol:"QTUM"},"0x1234567461d3f8Db7496581774Bd869C83D51c93":{name:"BitClave",logo:"bitclave.svg",erc20:!0,decimals:18,symbol:"CAT"},"0x7d4b8Cce0591C9044a22ee543533b72E976E36C3":{name:"Change",logo:"change.svg",erc20:!0,decimals:18,symbol:"CAG"},"0x1d462414fe14cf489c7A21CaC78509f4bF8CD7c0":{name:"CanYaCoin",logo:"CanYa.svg",erc20:!0,decimals:6,symbol:"CAN"},"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72":{name:"Ethereum Name Service",logo:"ens.svg",erc20:!0,decimals:18,symbol:"ENS"},"0x3d1BA9be9f66B8ee101911bC36D3fB562eaC2244":{name:"Rivetz",logo:"rivetz.png",erc20:!0,decimals:18,symbol:"RVT"},"0x056017c55aE7AE32d12AeF7C679dF83A85ca75Ff":{name:"Project Wyvern Token",logo:"wyvern-logo.svg",erc20:!0,symbol:"WYV",decimals:18},"0xfec0cF7fE078a500abf15F1284958F22049c2C7e":{name:"Maecenas ART Token",logo:"art.svg",erc20:!0,symbol:"ART",decimals:18},"0x05f4a42e251f2d52b8ed15E9FEdAacFcEF1FAD27":{name:"Zilliqa",logo:"zilliqa.svg",erc20:!0,symbol:"ZIL",decimals:12},"0x986EE2B944c42D017F52Af21c4c69B84DBeA35d8":{name:"BitMartToken",logo:"bitmart.png",erc20:!0,symbol:"BMX",decimals:18},"0xF03f8D65BaFA598611C3495124093c56e8F638f0":{name:"Viewly",logo:"viewly.svg",erc20:!0,symbol:"VIEW",decimals:18},"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2":{name:"Wrapped Ether",logo:"weth.svg",erc20:!0,symbol:"WETH",decimals:18},"0xba5BDe662c17e2aDFF1075610382B9B691296350":{name:"SuperRare Token",logo:"rare.svg",erc20:!0,symbol:"RARE",decimals:18},"0x6C8c6b02E7b2BE14d4fA6022Dfd6d75921D90E4E":{name:"Compound Basic Attention Token",logo:"ctoken-bat.svg",erc20:!0,symbol:"cBAT",decimals:8},"0x70e36f6BF80a52b3B46b3aF8e106CC0ed743E8e4":{name:"Compound Collateral",logo:"ctoken-comp.svg",erc20:!0,symbol:"cCOMP",decimals:8},"0x5d3a536E4D6DbD6114cc1Ead35777bAB948E3643":{name:"Compound Dai",logo:"ctoken-dai.svg",erc20:!0,symbol:"cDAI",decimals:8},"0xF5DCe57282A584D2746FaF1593d3121Fcac444dC":{name:"Compound Sai (Legacy Dai)",logo:"ctoken-sai.svg",erc20:!0,symbol:"cSAI",decimals:8},"0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5":{name:"Compound Ether",logo:"ctoken-eth.svg",erc20:!0,symbol:"cETH",decimals:8},"0x158079Ee67Fce2f58472A96584A73C7Ab9AC95c1":{name:"Compound Augur",logo:"ctoken-rep.svg",erc20:!0,symbol:"cREP",decimals:8},"0x39AA39c021dfbaE8faC545936693aC917d5E7563":{name:"Compound USD Coin",logo:"ctoken-usdc.svg",erc20:!0,symbol:"cUSDC",decimals:8},"0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9":{name:"Compound Tether",logo:"ctoken-usdt.svg",erc20:!0,symbol:"cUSDT",decimals:8},"0xC11b1268C1A384e55C48c2391d8d480264A3A7F4":{name:"Compound Wrapped BTC",logo:"ctoken-wbtc.svg",erc20:!0,symbol:"cWBTC",decimals:8},"0xB3319f5D18Bc0D84dD1b4825Dcde5d5f7266d407":{name:"Compound 0x",logo:"ctoken-zrx.svg",erc20:!0,symbol:"cZRX",decimals:8},"0xc00e94Cb662C3520282E6f5717214004A7f26888":{name:"Compound",logo:"comp.svg",erc20:!0,symbol:"COMP",decimals:18},"0xFFE02ee4C69eDf1b340fCaD64fbd6b37a7b9e265":{name:"NANJCOIN",logo:"nanjcoin.svg",erc20:!0,symbol:"NANJ",decimals:8},"0xB6eD7644C69416d67B522e20bC294A9a9B405B31":{name:"0xBitcoin Token",logo:"0xbitcoin.svg",erc20:!0,symbol:"0xBTC",decimals:8},"0x744d70FDBE2Ba4CF95131626614a1763DF805B9E":{name:"Status Network Token",logo:"snt.svg",erc20:!0,symbol:"SNT",decimals:18},"0x42d6622deCe394b54999Fbd73D108123806f6a18":{name:"SPANK",logo:"spank.svg",erc20:!0,symbol:"SPANK",decimals:18},"0x6B01c3170ae1EFEBEe1a3159172CB3F7A5ECf9E5":{name:"BOOTY",logo:"booty.png",erc20:!0,symbol:"BOOTY",decimals:18},"0x4a6058666cf1057eaC3CD3A5a614620547559fc9":{name:"Brickblock",logo:"Brickblock.svg",erc20:!0,symbol:"BBK",decimals:18},"0x80fB784B7eD66730e8b1DBd9820aFD29931aab03":{name:"ETHLend Token",logo:"lend.svg",erc20:!0,symbol:"LEND",decimals:18},"0x48FF53777F747cFB694101222a944dE070c15D36":{name:"Ether Kingdoms Token",logo:"IMP.svg",erc20:!0,symbol:"IMP",decimals:7},"0x02F61Fd266DA6E8B102D4121f5CE7b992640CF98":{name:"LikeCoin",logo:"like.svg",erc20:!0,symbol:"LIKE",decimals:18},"0xB8c77482e45F1F44dE1745F52C74426C631bDD52":{name:"Binance Coin",logo:"bnb.png",erc20:!0,symbol:"BNB",decimals:18},"0xD850942eF8811f2A866692A623011bDE52a462C1":{name:"VeChain",logo:"ven.svg",erc20:!0,symbol:"VEN",decimals:18},"0x91Af0fBB28ABA7E31403Cb457106Ce79397FD4E6":{name:"Aergo",logo:"Aergo.svg",erc20:!0,symbol:"AERGO",decimals:18},"0x5CA9a71B1d01849C0a95490Cc00559717fCF0D1d":{name:"Aeternity",logo:"aeternity.svg",erc20:!0,symbol:"AE",decimals:18},"0xd4fa1460F537bb9085d22C7bcCB5DD450Ef28e3a":{name:"Populous",logo:"ppt.svg",erc20:!0,symbol:"PPT",decimals:8},"0xFA1a856Cfa3409CFa145Fa4e20Eb270dF3EB21ab":{name:"IOST",logo:"iost.png",erc20:!0,symbol:"IOST",decimals:18},"0x039B5649A59967e3e936D7471f9c3700100Ee1ab":{name:"Kucoin Shares",logo:"kucoin.svg",erc20:!0,symbol:"KCS",decimals:6},"0x3893b9422Cd5D70a81eDeFfe3d5A1c6A978310BB":{name:"Mithril",logo:"mith.svg",erc20:!0,symbol:"MITH",decimals:18},"0xb7cB1C96dB6B22b0D3d9536E0108d062BD488F74":{name:"Walton Token",logo:"wtc.svg",erc20:!0,symbol:"WTC",decimals:18},"0x1776e1F26f98b1A5dF9cD347953a26dd3Cb46671":{name:"Numeraire",logo:"nmr.png",erc20:!0,symbol:"NMR",decimals:18},"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd":{name:"Gemini Dollar",logo:"gusd.svg",erc20:!0,symbol:"GUSD",decimals:2},"0xA4Bdb11dc0a2bEC88d24A3aa1E6Bb17201112eBe":{name:"StableUSD",logo:"usds.svg",erc20:!0,symbol:"USDS",decimals:6},"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48":{name:"USDC",logo:"usdc.svg",erc20:!0,symbol:"USDC",decimals:6},"0x1aBaEA1f7C830bD89Acc67eC4af516284b1bC33c":{name:"EURC",logo:"eurc.svg",erc20:!0,symbol:"EURC",decimals:6},"0x93ED3FBe21207Ec2E8f2d3c3de6e058Cb73Bc04d":{name:"Pinakion Token",logo:"pinakion.svg",erc20:!0,symbol:"PNK",decimals:18},"0x419D0d8BdD9aF5e606Ae2232ed285Aff190E711b":{name:"FunFair",logo:"fun.svg",erc20:!0,symbol:"FUN",decimals:8},"0xcA2796F9F61dc7b238Aab043971e49c6164DF375":{name:"YGGDRASH YEED Token",logo:"yggdrash.svg",erc20:!0,symbol:"YEED",decimals:18},"0x03e3f0c25965f13DbbC58246738C183E27b26a56":{name:"Disciplina Token",logo:"disciplina.svg",erc20:!0,symbol:"DSCP",decimals:18},"0xE814aeE960a85208C3dB542C53E7D4a6C8D5f60F":{name:"Chronologic DAY Token",logo:"DAY.png",erc20:!0,symbol:"DAY",decimals:18},"0x7E43581b19ab509BCF9397a2eFd1ab10233f27dE":{name:"PLATINUM",logo:"plat.png",erc20:!0,symbol:"PLAT",decimals:18},"0x8E870D67F660D95d5be530380D0eC0bd388289E1":{name:"Pax Dollar",logo:"usdp.svg",erc20:!0,symbol:"USDP",decimals:18},"0x45804880De22913dAFE09f4980848ECE6EcbAf78":{name:"PAX Gold",logo:"paxg.svg",erc20:!0,symbol:"PAXG",decimals:18},"0x0000000000085d4780B73119b644AE5ecd22b376":{name:"TrueUSD",logo:"TUSD.svg",erc20:!0,symbol:"TUSD",decimals:18},"0x00000000441378008EA67F4284A57932B1c000a5":{name:"TrueGBP",logo:"TGBP.svg",erc20:!0,symbol:"TGBP",decimals:18},"0x00006100F7090010005F1bd7aE6122c3C2CF0090":{name:"TrueAUD",logo:"TAUD.svg",erc20:!0,symbol:"TAUD",decimals:18},"0x00000100F2A2bd000715001920eB70D229700085":{name:"TrueCAD",logo:"TCAD.svg",erc20:!0,symbol:"TCAD",decimals:18},"0x0000852600CEB001E08e00bC008be620d60031F2":{name:"TrueHKD",logo:"THKD.svg",erc20:!0,symbol:"THKD",decimals:18},"0x4Fabb145d64652a948d72533023f6E7A623C7C53":{name:"Binance USD",logo:"busd.svg",erc20:!0,symbol:"BUSD",decimals:18},"0x23Ccc43365D9dD3882eab88F43d515208f832430":{name:"MidasProtocol",logo:"MAS.png",erc20:!0,symbol:"MAS",decimals:18},"0xC16b542ff490e01fcc0DC58a60e1EFdc3e357cA6":{name:"ICE ROCK MINING",logo:"rock2.png",erc20:!0,symbol:"ROCK2",decimals:0},"0x6758B7d441a9739b98552B373703d8d3d14f9e62":{name:"POA20 Token",logo:"POA20.png",erc20:!0,symbol:"POA20",decimals:18},"0x3DB6Ba6ab6F95efed1a6E794caD492fAAabF294D":{name:"LTO Network Token (old)",logo:"LTO.svg",erc20:!0,symbol:"LTOOLD",decimals:8},"0xd01409314aCb3b245CEa9500eCE3F6Fd4d70ea30":{name:"LTO Network Token",logo:"LTO.svg",erc20:!0,symbol:"LTO",decimals:8},"0xfeF4185594457050cC9c23980d301908FE057Bb1":{name:"VIDT Datalink",logo:"VIDT.svg",erc20:!0,symbol:"VIDT-OLD",decimals:18},"0x3BE7bF1A5F23BD8336787D0289B70602f1940875":{name:"VIDT DAO",logo:"VIDT.svg",erc20:!0,symbol:"VIDT",decimals:18},"0x7064aAb39A0Fcf7221c3396719D0917a65E35515":{name:"Cpollo",logo:"Cpollo.svg",erc20:!0,symbol:"CPLO",decimals:18},"0xd8446236FA95b9b5f9fd0f8E7Df1a944823c683d":{name:"NEEO",logo:"neeo.png",erc20:!0,symbol:"NEEO",decimals:18},"0xA823E6722006afe99E91c30FF5295052fe6b8E32":{name:"Neumark",logo:"neu.svg",erc20:!0,symbol:"NEU",decimals:18},"0x8f693ca8D21b157107184d29D398A8D082b38b76":{name:"Streamr",logo:"streamr.svg",erc20:!0,symbol:"DATA",decimals:18},"0x0Cf0Ee63788A0849fE5297F3407f701E122cC023":{name:"Streamr (old)",logo:"streamr_old.svg",erc20:!0,symbol:"XDATA",decimals:18},"0xA0b73E1Ff0B80914AB6fe0444E65848C4C34450b":{name:"Cronos",logo:"cro.svg",erc20:!0,symbol:"CRO",decimals:8},"0xF70a642bD387F94380fFb90451C2c81d4Eb82CBc":{name:"STAR",logo:"starbase.png",erc20:!0,symbol:"STAR",decimals:18},"0x7C5A0CE9267ED19B22F8cae653F198e3E8daf098":{name:"Santiment",logo:"santiment.svg",erc20:!0,symbol:"SAN",decimals:18},"0x58b6A8A3302369DAEc383334672404Ee733aB239":{name:"Livepeer",logo:"lpt.svg",erc20:!0,symbol:"LPT",decimals:18},"0x6fe56C0bcdD471359019FcBC48863d6c3e9d4F41":{name:"Props",logo:"props.png",erc20:!0,symbol:"PROPS",decimals:18},"0x6c6EE5e31d828De241282B9606C8e98Ea48526E2":{name:"HoloToken",logo:"hot.svg",erc20:!0,symbol:"HOT",decimals:18},"0xF629cBd94d3791C9250152BD8dfBDF380E2a3B9c":{name:"Enjin Coin",logo:"enj.svg",erc20:!0,symbol:"ENJ",decimals:18},"0xbf2179859fc6D5BEE9Bf9158632Dc51678a4100e":{name:"AELF",logo:"elf.svg",erc20:!0,symbol:"ELF",decimals:18},"0x39Bb259F66E1C59d5ABEF88375979b4D20D98022":{name:"WAX Token",logo:"wax.svg",erc20:!0,symbol:"WAX",decimals:8},"0x595832F8FC6BF59c85C527fEC3740A1b7a361269":{name:"PowerLedger",logo:"powr.svg",erc20:!0,symbol:"POWR",decimals:6},"0x28dee01D53FED0Edf5f6E310BF8Ef9311513Ae40":{name:"BlitzPredict",logo:"blitzpredict.svg",erc20:!0,symbol:"XBP",decimals:18},"0x33349B282065b0284d756F0577FB39c158F935e6":{name:"Maple Finance",logo:"maple-finance.svg",erc20:!0,erc721:!1,symbol:"MPL",decimals:18},"0xFBeef911Dc5821886e1dda71586d90eD28174B7d":{name:"KnownOrigin",logo:"knownorigin.svg",erc20:!0,symbol:"KODA",decimals:0},"0x8207c1FfC5B6804F6024322CcF34F29c3541Ae26":{name:"Origin Protocol",logo:"ogn.svg",erc20:!0,symbol:"OGN",decimals:18},"0x2A8e1E676Ec238d8A992307B495b45B3fEAa5e86":{name:"Origin Dollar",logo:"ousd.svg",erc20:!0,symbol:"OUSD",decimals:18},"0x856c4Efb76C1D1AE02e20CEB03A2A6a08b0b8dC3":{name:"Origin Ether",logo:"oeth.svg",erc20:!0,symbol:"OETH",decimals:18},"0x9c354503C38481a7A7a51629142963F98eCC12D0":{name:"Origin DeFi Governance",logo:"ogv.svg",erc20:!0,symbol:"OGV",decimals:18},"0x0C4576Ca1c365868E162554AF8e385dc3e7C66D9":{name:"Vote Escrowed Origin DeFi Governance",logo:"veogv.svg",erc20:!0,symbol:"veOGV",decimals:18},"0x8f8221aFbB33998d8584A2B05749bA73c37a938a":{name:"Request",logo:"request.svg",erc20:!0,symbol:"REQ",decimals:18},"0x2aEa4Add166EBf38b63d09a75dE1a7b94Aa24163":{name:"Kudos",logo:"kudos.svg",erc20:!1,erc721:!0,symbol:"KDO",decimals:0},"0x14C926F2290044B647e1Bf2072e67B495eff1905":{name:"Bethereum",logo:"bether.jpg",erc20:!0,symbol:"BETHER",decimals:18},"0x9AAb071B4129B083B01cB5A0Cb513Ce7ecA26fa5":{name:"Hunt Token",logo:"hunt.png",erc20:!0,symbol:"HUNT",decimals:18},"0xFEF3884b603C33EF8eD4183346E093A173C94da6":{name:"Metamorph",logo:"metamorph.svg",erc20:!0,symbol:"METM",decimals:18},"0x0AbdAce70D3790235af448C88547603b945604ea":{name:"district0x",logo:"district0x.svg",erc20:!0,symbol:"DNT",decimals:18},"0xB26631c6dda06aD89B93C71400D25692de89c068":{name:"Minds",logo:"minds.svg",erc20:!0,symbol:"MINDS",decimals:18},"0xBb1f24C0c1554b9990222f036b0AaD6Ee4CAec29":{name:"CryptoSoul",logo:"SOUL.svg",erc20:!0,symbol:"SOUL",decimals:18},"0xFF0E5e014cf97e0615cb50F6f39Da6388E2FaE6E":{name:"Origo",logo:"origo.svg",erc20:!0,symbol:"OGO",decimals:18},"0x0cB8D0B37C7487b11d57F1f33dEfA2B1d3cFccfE":{name:"DANKToken",logo:"dank-logo.svg",erc20:!0,symbol:"DANK",decimals:18},"0x3a4f40631a4f906c2BaD353Ed06De7A5D3fCb430":{name:"PlayDapp Token",logo:"playdapp.svg",erc20:!0,symbol:"PLA",decimals:18},"0xE9e3F9cfc1A64DFca53614a0182CFAD56c10624F":{name:"Su Squares",logo:"Su-Squares.svg",erc20:!1,erc721:!0,symbol:"SU",decimals:0},"0xfA5047c9c78B8877af97BDcb85Db743fD7313d4a":{name:"ROOK",logo:"Rook.svg",erc20:!0,symbol:"ROOK",decimals:18},"0xa62cc35625B0C8dc1fAEA39d33625Bb4C15bD71C":{name:"StormX",logo:"stormx.svg",erc20:!0,symbol:"STMX",decimals:18},"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0":{name:"Matic Network Token",logo:"matic.svg",erc20:!0,symbol:"MATIC",decimals:18},"0x9992eC3cF6A55b00978cdDF2b27BC6882d88D1eC":{name:"Polymath",logo:"poly.svg",erc20:!0,symbol:"POLY",decimals:18},"0x0a50C93c762fDD6E56D86215C24AaAD43aB629aa":{name:"LGO Token",logo:"lgo.png",erc20:!0,symbol:"LGO",decimals:8},"0xc8Cac7672f4669685817cF332a33Eb249F085475":{name:"LivenCoin",logo:"LVN.svg",erc20:!0,symbol:"LVN",decimals:18},"0xBBbbCA6A901c926F240b89EacB641d8Aec7AEafD":{name:"Loopring",logo:"LRC.svg",erc20:!0,symbol:"LRC",decimals:18},"0x255Aa6DF07540Cb5d3d297f0D0D4D84cb52bc8e6":{name:"Raiden Network Token",logo:"raiden.svg",erc20:!0,symbol:"RDN",decimals:18},"0x66fD97a78d8854fEc445cd1C80a07896B0b4851f":{name:"Lunch Money",logo:"LMY.svg",erc20:!0,symbol:"LMY",decimals:18},"0x679131F591B4f369acB8cd8c51E68596806c3916":{name:"Trustlines Network Token",logo:"TLN128.png",erc20:!0,symbol:"TLN",decimals:18},"0xdcD85914b8aE28c1E62f1C488E1D968D5aaFfE2b":{name:"TOP Network Token",logo:"TOP.svg",erc20:!0,symbol:"TOP",decimals:18},"0xaea46A60368A7bD060eec7DF8CBa43b7EF41Ad85":{name:"Fetch",logo:"fetch.svg",erc20:!0,symbol:"FET",decimals:18},"0x2e1E15C44Ffe4Df6a0cb7371CD00d5028e571d14":{name:"Mettalex",logo:"mettalex.svg",erc20:!0,symbol:"MTLX",decimals:18},"0xf21661D0D1d76d3ECb8e1B9F1c923DBfffAe4097":{name:"Realio Network",logo:"rio.svg",erc20:!0,symbol:"RIO",decimals:18},"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{name:"Uniswap",logo:"uni.svg",erc20:!0,symbol:"UNI",decimals:18},"0x2e6539edc3b76f1E21B71d214527FAbA875F70F3":{name:"Yearn Finance Dot",logo:"YFDOT.svg",erc20:!0,symbol:"YFDOT",decimals:18},"0x9F284E1337A815fe77D2Ff4aE46544645B20c5ff":{name:"Darwinia Commitment Token",logo:"kton.svg",erc20:!0,symbol:"KTON",decimals:18},"0xE48972fCd82a274411c01834e2f031D4377Fa2c0":{name:"TwoKeyEconomy",logo:"2key.svg",erc20:!0,symbol:"2KEY",decimals:18},"0x970B9bB2C0444F5E81e9d0eFb84C8ccdcdcAf84d":{name:"Fuse Token",logo:"fuse.svg",erc20:!0,symbol:"FUSE",decimals:18},"0x0Ae055097C6d159879521C384F1D2123D1f195e6":{name:"STAKE Token",logo:"stake.svg",erc20:!0,symbol:"STAKE",decimals:18},"0x5dc60C4D5e75D22588FA17fFEB90A63E535efCE0":{name:"dKargo",logo:"DKA.svg",erc20:!0,symbol:"DKA",decimals:18},"0x9469D013805bFfB7D3DEBe5E7839237e535ec483":{name:"Darwinia Network Native Token",logo:"ring.svg",erc20:!0,symbol:"RING",decimals:18},"0xA31B1767e09f842ECFd4bc471Fe44F830E3891AA":{name:"ROOBEE",logo:"ROOBEE.svg",erc20:!0,symbol:"ROOBEE",decimals:18},"0xC7e43A1c8E118aA2965F5EAbe0e718D83DB7A63C":{name:"ZCore Token",logo:"zcrt.svg",erc20:!0,symbol:"ZCRT",decimals:18},"0x08d32b0da63e2C3bcF8019c9c5d849d7a9d791e6":{name:"Dentacoin Token",logo:"dcn.svg",erc20:!0,symbol:"DCN",decimals:0},"0xe2f2a5C287993345a840Db3B0845fbC70f5935a5":{name:"mStable USD",logo:"mUSD.svg",erc20:!0,symbol:"mUSD",decimals:18},"0xa3BeD4E1c75D00fa6f4E5E6922DB7261B5E9AcD2":{name:"Meta",logo:"MTA.svg",erc20:!0,symbol:"MTA",decimals:18},"0xe3818504c1B32bF1557b16C238B2E01Fd3149C17":{name:"Pillar",logo:"plr.svg",erc20:!0,symbol:"PLR",decimals:18},"0xba100000625a3754423978a60c9317c58a424e3D":{name:"Balancer (BAL)",logo:"balancer.svg",erc20:!0,symbol:"BAL",decimals:18},"0x8a854288a5976036A725879164Ca3e91d30c6A1B":{name:"Guaranteed Entrance Token",logo:"get-logo.svg",erc20:!0,symbol:"GET",decimals:18},"0x2781246fe707bB15CeE3e5ea354e2154a2877B16":{name:"Elysia",logo:"el.svg",erc20:!0,symbol:"EL",decimals:18},"0x4dA34f8264CB33A5c9F17081B9EF5Ff6091116f4":{name:"Elyfi",logo:"elyfi.svg",erc20:!0,symbol:"ELFI",decimals:18},"0xc12d099be31567add4e4e4d0D45691C3F58f5663":{name:"Auctus",logo:"auc.svg",erc20:!0,symbol:"AUC",decimals:18},"0xdF574c24545E5FfEcb9a659c229253D4111d87e1":{name:"HUSD",logo:"HUSD.svg",erc20:!0,symbol:"HUSD",decimals:8},"0x2ecB13A8c458c379c4d9a7259e202De03c8F3D19":{name:"Block-Chain.com Token",logo:"block-chain.svg",erc20:!0,symbol:"BC",decimals:18},"0x38e4adB44ef08F22F5B5b76A8f0c2d0dCbE7DcA1":{name:"Concentrated Voting Power",logo:"PowerPool.svg",erc20:!0,symbol:"CVP",decimals:18},"0xa117000000f279D81A1D3cc75430fAA017FA5A2e":{name:"Aragon Network Token",logo:"antv2.svg",erc20:!0,symbol:"ANT",decimals:18},"0xDecade1c6Bf2cD9fb89aFad73e4a519C867adcF5":{name:"Experty Wisdom Token",logo:"wisdom-token.svg",erc20:!0,symbol:"WIS",decimals:18},"0x7D85e23014F84E6E21d5663aCD8751bEF3562352":{name:"Axion Old",logo:"obsolete.svg",erc20:!0,symbol:"AXNv1",decimals:18},"0x358AA737e033F34df7c54306960a38d09AaBd523":{name:"Ares Token",logo:"ares.svg",erc20:!0,symbol:"ARES",decimals:18},"0xB62132e35a6c13ee1EE0f84dC5d40bad8d815206":{name:"NEXO",logo:"NEXO.svg",erc20:!0,symbol:"NEXO",decimals:18},"0x4612021C75809160Be60DB21fBc9D6adD0B32deF":{name:"BCP Coin",logo:"BCP.svg",erc20:!0,symbol:"BCP",decimals:18},"0xE9E73E1aE76D17A16cC53E3e87a9a7dA78834d37":{name:"Camp",logo:"Camp.svg",erc20:!0,symbol:"CAMP",decimals:18},"0xdacD69347dE42baBfAEcD09dC88958378780FB62":{name:"Atari Token",logo:"atrilast.svg",erc20:!0,symbol:"ATRI",decimals:0},"0x71F85B2E46976bD21302B64329868fd15eb0D127":{name:"Axion",logo:"axion.svg",erc20:!0,symbol:"AXN",decimals:18},"0xc944E90C64B2c07662A292be6244BDf05Cda44a7":{name:"Graph Token",logo:"graphToken.svg",erc20:!0,symbol:"GRT",decimals:18},"0xFE3E6a25e6b192A42a44ecDDCd13796471735ACf":{name:"Reef Finance",logo:"reef.svg",erc20:!0,symbol:"REEF",decimals:18},"0x43Dfc4159D86F3A37A5A4B3D4580b888ad7d4DDd":{name:"DODO bird",logo:"DODO.svg",erc20:!0,symbol:"DODO",decimals:18},"0x4a615bB7166210CCe20E6642a6f8Fb5d4D044496":{name:"NAOS Finance",logo:"naos.svg",erc20:!0,symbol:"NAOS",decimals:18},"0x111111111117dC0aa78b770fA6A738034120C302":{name:"1INCH Token",logo:"1inch.svg",erc20:!0,symbol:"1INCH",decimals:18},"0x27702a26126e0B3702af63Ee09aC4d1A084EF628":{name:"Aleph.im Token",logo:"aleph.svg",erc20:!0,symbol:"ALEPH",decimals:18},"0x32a7C02e79c4ea1008dD6564b35F131428673c41":{name:"CRUST",logo:"crust.svg",erc20:!0,symbol:"CRU",decimals:18},"0x3472A5A71965499acd81997a54BBA8D852C6E53d":{name:"BADGER",logo:"badger.svg",erc20:!0,symbol:"BADGER",decimals:18},"0x65Def5029A0e7591e46B38742bFEdd1Fb7b24436":{name:"Kanpeki",logo:"kanpeki-green.svg",erc20:!0,symbol:"KAE",decimals:18},"0xF94b5C5651c888d928439aB6514B93944eEE6F48":{name:"Yield App",logo:"yield-app.svg",erc20:!0,symbol:"YLD",decimals:18},"0xDcB01cc464238396E213a6fDd933E36796eAfF9f":{name:"Yield",logo:"yield-logo.svg",erc20:!0,symbol:"YLD",decimals:18},"0x968F6f898a6Df937fC1859b323aC2F14643e3fED":{name:"Newscrypto",logo:"NWC.svg",erc20:!0,symbol:"NWC",decimals:18},"0xeb269732ab75A6fD61Ea60b06fE994cD32a83549":{name:"dForce USDx",logo:"USDx.svg",erc20:!0,symbol:"USDx",decimals:18},"0x6e0daDE58D2d89eBBe7aFc384e3E4f15b70b14D8":{name:"QuiverX",logo:"quiverx.svg",erc20:!0,symbol:"QRX",decimals:18},"0x0beAD9a1bcc1b84D06E3f2df67E3549Fd55aB054":{name:"EURxb",logo:"eurxb.svg",erc20:!0,symbol:"EURxb",decimals:18},"0x9F9c8ec3534c3cE16F928381372BfbFBFb9F4D24":{name:"GraphLinq",logo:"glq.svg",erc20:!0,symbol:"GLQ",decimals:18},"0xEB58343b36C7528F23CAAe63a150240241310049":{name:"NBU",logo:"NBU.svg",erc20:!0,symbol:"NBU",decimals:18},"0x16ECCfDbb4eE1A85A33f3A9B21175Cd7Ae753dB4":{name:"Route",logo:"route.svg",erc20:!0,symbol:"ROUTE",decimals:18},"0x75739d5944534115d7C54ee8C73F186D793BAE02":{name:"Collective",logo:"CO2.svg",erc20:!0,symbol:"CO2",decimals:18},"0x35bD01FC9d6D5D81CA9E055Db88Dc49aa2c699A8":{name:"FWB Pro",logo:"FWB.svg",erc20:!0,symbol:"FWB",decimals:18},"0x9B99CcA871Be05119B2012fd4474731dd653FEBe":{name:"Antimatter",logo:"antimatter.svg",erc20:!0,symbol:"MATTER",decimals:18},"0x6De037ef9aD2725EB40118Bb1702EBb27e4Aeb24":{name:"Render Token",logo:"RNDR.svg",erc20:!0,symbol:"RNDR",decimals:18},"0xDf49C9f599A0A9049D97CFF34D0C30E468987389":{name:"SaTT",logo:"SaTT.svg",erc20:!0,symbol:"SATT",decimals:18},"0x431ad2ff6a9C365805eBaD47Ee021148d6f7DBe0":{name:"dForce",logo:"DF.svg",erc20:!0,symbol:"DF",decimals:18},"0x6e1A19F235bE7ED8E3369eF73b196C07257494DE":{name:"Wrapped Filecoin",logo:"WFIL.svg",erc20:!0,symbol:"WFIL",decimals:18},"0xE452E6Ea2dDeB012e20dB73bf5d3863A3Ac8d77a":{name:"Wrapped Celo",logo:"WCELO.svg",erc20:!0,symbol:"wCELO",decimals:18},"0x4A64515E5E1d1073e83f30cB97BEd20400b66E10":{name:"Wrapped ZEC",logo:"WZEC.svg",erc20:!0,symbol:"WZEC",decimals:18},"0xA3865E64121537b5b59B5e239Db4aCBe6F36aa74":{name:"Wrapped Tezos",logo:"WXTZ.svg",erc20:!0,symbol:"WXTZ",decimals:18},"0x53c4871322Bb47e7A24136fce291a6dcC832a294":{name:"Wrapped Litecoin",logo:"WLTC.svg",erc20:!0,symbol:"WLTC",decimals:18},"0xad3E3Fc59dff318BecEaAb7D00EB4F68b1EcF195":{name:"Wrapped Celo USD",logo:"WCUSD.svg",erc20:!0,symbol:"wCUSD",decimals:18},"0x85D7bdfc9c3426b33A684241eEEE70385Bc42820":{name:"Wrapped Kadena",logo:"WKDA.svg",erc20:!0,symbol:"WKDA",decimals:18},"0x39fBBABf11738317a448031930706cd3e612e1B9":{name:"Wrapped XRP",logo:"WXRP.svg",erc20:!0,symbol:"WXRP",decimals:18},"0xBBC7f7A6AADAc103769C66CBC69AB720f7F9Eae3":{name:"INX Token",logo:"INX.svg",erc20:!0,symbol:"INX",decimals:18},"0x1b40183EFB4Dd766f11bDa7A7c3AD8982e998421":{name:"Vesper",logo:"vsp.svg",erc20:!0,symbol:"VSP",decimals:18},"0x544c42fBB96B39B21DF61cf322b5EDC285EE7429":{name:"InsurAce",logo:"INSUR.svg",erc20:!0,symbol:"INSUR",decimals:18},"0xcC665390b03c5D324D8fAF81C15eCee29A73bCB4":{name:"ChainSwap.com Governance Token",logo:"chainswap.svg",erc20:!0,symbol:"ASAP",decimals:18},"0x182F4c4C97cd1c24E1Df8FC4c053E5C47bf53Bef":{name:"keyTango Token",logo:"keyTango.svg",erc20:!0,symbol:"TANGO",decimals:18},"0x0275E1001e293C46CFe158B3702AADe0B99f88a5":{name:"Oiler",logo:"oiler.svg",erc20:!0,symbol:"OIL",decimals:18},"0xDe30da39c46104798bB5aA3fe8B9e0e1F348163F":{name:"Gitcoin",logo:"gtc.svg",erc20:!0,symbol:"GTC",decimals:18},"0x1796ae0b0fa4862485106a0de9b654eFE301D0b2":{name:"Polychain Monsters",logo:"PMON.svg",erc20:!0,symbol:"PMON",decimals:18},"0x8eEF5a82E6Aa222a60F009ac18c24EE12dBf4b41":{name:"Tixl",logo:"TXL.svg",erc20:!0,symbol:"TXL",decimals:18},"0x5218E472cFCFE0b64A064F055B43b4cdC9EfD3A6":{name:"unFederalReserve Token",logo:"eRSDL.svg",erc20:!0,symbol:"eRSDL",decimals:18},"0xE4cC5A22B39fFB0A56d67F94f9300db20D786a5F":{name:"unFederal eRSDL",logo:"uneRSDL.svg",erc20:!0,symbol:"uneRSDL",decimals:8},"0x2dbA05B51eF5A7DE3E7c3327201CA2F8a25C2414":{name:"unFederal DAI",logo:"unDAI.svg",erc20:!0,symbol:"unDAI",decimals:8},"0xFaCecE87e14B50eafc85C44C01702F5f485CA460":{name:"unFederal ETH",logo:"unETH.svg",erc20:!0,symbol:"unETH",decimals:8},"0x6b576972de33BebDe3A703BfF52a091e79f8c87A":{name:"unFederal USDC",logo:"unUSDC.svg",erc20:!0,symbol:"unUSDC",decimals:8},"0x6e2aA5bB90ac37D9006685AFc651ef067E1c7b44":{name:"unFederal USDT",logo:"unUSDT.svg",erc20:!0,symbol:"unUSDT",decimals:8},"0x5D446FC8DBd10EBAcfE9A427aB5402586af98cD4":{name:"unFederal WBTC",logo:"unWBTC.svg",erc20:!0,symbol:"unWBTC",decimals:8},"0xD837eCa6C91c67D98461A411BA2f00bdA9960a9D":{name:"unFederal AAVE",logo:"unAAVE.svg",erc20:!0,symbol:"unAAVE",decimals:8},"0x9e29Ce9cD25F4141dF6BB85b27Ef6933a16A5824":{name:"unFederal YFI",logo:"unYFI.svg",erc20:!0,symbol:"unYFI",decimals:8},"0x031002d15B0D0Cd7c9129d6F644446368deaE391":{name:"unFederal LINK",logo:"unLINK.svg",erc20:!0,symbol:"unLINK",decimals:8},"0xB8E2e2101eD11e9138803cd3e06e16dd19910647":{name:"ArdCoin",logo:"ardcoin.svg",erc20:!0,symbol:"ARDX",decimals:2},"0x6D0F5149c502faf215C89ab306ec3E50b15e2892":{name:"Portion Token",logo:"PRT.svg",erc20:!0,symbol:"PRT",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"3SPACE ART",logo:"3SPACE.svg",erc20:!0,symbol:"PACE",decimals:18},"0x3845badAde8e6dFF049820680d1F14bD3903a5d0":{name:"SAND",logo:"SAND.svg",erc20:!0,symbol:"SAND",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"Spacelens",logo:"SPACE.svg",erc20:!0,symbol:"SPACE",decimals:18},"0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a":{name:"Sandbox's LANDs",logo:"SAND.svg",erc20:!1,erc721:!0,symbol:"LAND",decimals:0},"0x362bc847A3a9637d3af6624EeC853618a43ed7D2":{name:"PARSIQ",logo:"parsiq.svg",erc20:!0,symbol:"PRQ",decimals:18},"0x21381e026Ad6d8266244f2A583b35F9E4413FA2a":{name:"Formation Finance",logo:"form.svg",erc20:!0,symbol:"FORM",decimals:18},"0x2ba592F78dB6436527729929AAf6c908497cB200":{name:"Cream",logo:"cream.svg",erc20:!0,symbol:"CREAM",decimals:18},"0x46576e20EC5F25586A6Fa2E0d6B6058354B72E72":{name:"Cryptomind",logo:"CR.svg",erc20:!0,erc721:!1,symbol:"CR",decimals:8},"0x5ab21Ec0bfa0B29545230395e3Adaca7d552C948":{name:"PUNKS Comic",logo:"punks-comic.svg",erc20:!1,erc721:!0,symbol:"COMIC",decimals:0},"0x9C2dc0c3CC2BADdE84B0025Cf4df1c5aF288D835":{name:"Coreto",logo:"coreto.svg",erc20:!0,symbol:"COR",decimals:18},"0x0De05F6447ab4D22c8827449EE4bA2D5C288379B":{name:"OOKI",logo:"ooki.svg",erc20:!0,symbol:"OOKI",decimals:18},"0x6B4c7A5e3f0B99FCD83e9c089BDDD6c7FCe5c611":{name:"Million",logo:"million.svg",erc20:!0,symbol:"MM",decimals:18},"0x56d811088235F11C8920698a204A5010a788f4b3":{name:"bZx Protocol Token (BZRX)",logo:"ic_token_bzrx.svg",erc20:!0,symbol:"BZRX",decimals:18},"0xB72B31907C1C95F3650b64b2469e08EdACeE5e8F":{name:"bZx Vesting Token (vBZRX)",logo:"ic_token_vbzrx.svg",erc20:!0,symbol:"vBZRX",decimals:18},"0x3085154623F51b00Dedfc6Ceeb5197277A66B17B":{name:"NIFTY",logo:"nfty.svg",erc20:!0,symbol:"NFTY",decimals:18},"0xB983E01458529665007fF7E0CDdeCDB74B967Eb6":{name:"Fulcrum ETH iToken (iETH)",logo:"ic_token_ieth.svg",erc20:!0,symbol:"iETH",decimals:18},"0x32E4c68B3A4a813b710595AebA7f6B7604Ab9c15":{name:"Fulcrum USDC iToken (iUSDC)",logo:"ic_token_iusdc.svg",erc20:!0,symbol:"iUSDC",decimals:6},"0x2ffa85f655752fB2aCB210287c60b9ef335f5b6E":{name:"Fulcrum WBTC iToken (iWBTC)",logo:"ic_token_ibtc.svg",erc20:!0,symbol:"iWBTC",decimals:8},"0x687642347a9282Be8FD809d8309910A3f984Ac5a":{name:"Fulcrum KNC iToken (iKNC)",logo:"ic_token_iknc.svg",erc20:!0,symbol:"iKNC",decimals:18},"0x463538705E7d22aA7f03Ebf8ab09B067e1001B54":{name:"Fulcrum LINK iToken (iLINK)",logo:"ic_token_ilink.svg",erc20:!0,symbol:"iLINK",decimals:18},"0x6b093998D36f2C7F0cc359441FBB24CC629D5FF0":{name:"Fulcrum DAI iToken (iDAI)",logo:"ic_token_idai.svg",erc20:!0,symbol:"iDAI",decimals:18},"0x7e9997a38A439b2be7ed9c9C4628391d3e055D48":{name:"Fulcrum USDT iToken (iUSDT)",logo:"ic_token_iusdt.svg",erc20:!0,symbol:"iUSDT",decimals:6},"0x9189c499727f88F8eCC7dC4EEA22c828E6AaC015":{name:"Fulcrum MKR iToken (iMKR)",logo:"ic_token_imkr.svg",erc20:!0,symbol:"iMKR",decimals:18},"0x18240BD9C07fA6156Ce3F3f61921cC82b2619157":{name:"Fulcrum BZRX iToken (iBZRX)",logo:"ic_token_ibzrx.svg",erc20:!0,symbol:"iBZRX",decimals:18},"0x7F3Fe9D492A9a60aEBb06d82cBa23c6F32CAd10b":{name:"Fulcrum YFI iToken (iYFI)",logo:"ic_token_iyfi.svg",erc20:!0,symbol:"iYFI",decimals:18},"0x0a625FceC657053Fe2D9FFFdeb1DBb4e412Cf8A8":{name:"Fulcrum UNI iToken (iUNI)",logo:"ic_token_iuni.svg",erc20:!0,symbol:"iUNI",decimals:18},"0x0cae8d91E0b1b7Bd00D906E990C3625b2c220db1":{name:"Fulcrum AAVE iToken (iAAVE)",logo:"ic_token_iaave.svg",erc20:!0,symbol:"iAAVE",decimals:18},"0x3dA0e01472Dee3746b4D324a65D7EdFaECa9Aa4f":{name:"Fulcrum LRC iToken (iLRC)",logo:"ic_token_ilrc.svg",erc20:!0,symbol:"iLRC",decimals:18},"0x6d29903BC2c4318b59B35d97Ab98ab9eC08Ed70D":{name:"Fulcrum COMP iToken (iCOMP)",logo:"ic_token_icomp.svg",erc20:!0,symbol:"iCOMP",decimals:18},"0x08c32b0726C5684024ea6e141C50aDe9690bBdcc":{name:"Stratos Token",logo:"stos.svg",erc20:!0,symbol:"STOS",decimals:18},"0xe28b3B32B6c345A34Ff64674606124Dd5Aceca30":{name:"Injective",logo:"inj.svg",erc20:!0,symbol:"INJ",decimals:18},"0xe516D78d784C77D479977BE58905B3f2b1111126":{name:"Bitspawn",logo:"spwn.svg",erc20:!0,symbol:"SPWN",decimals:18},"0xB16e967ff83DE3F1e9FCeAfbc2C28c1c5c56eF91":{name:"Polkadog",logo:"polkadog.svg",erc20:!0,symbol:"PDOG",decimals:18},"0x07c52c2537D84e532a9F15d32E152C8B94D2b232":{name:"ZkTube",logo:"ZKT.svg",erc20:!0,symbol:"ZKT",decimals:18},"0xF4d861575ecC9493420A3f5a14F85B13f0b50EB3":{name:"Fractal Protocol",logo:"fractal.svg",erc20:!0,symbol:"FCL",decimals:18},"0x3af33bEF05C2dCb3C7288b77fe1C8d2AeBA4d789":{name:"Kromatika",logo:"krom.svg",erc20:!0,symbol:"KROM",decimals:18},"0xA130E3a33a4d84b04c3918c4E5762223Ae252F80":{name:"Swash Token",logo:"swash.svg",erc20:!0,symbol:"SWASH",decimals:18},"0xea7Cc765eBC94C4805e3BFf28D7E4aE48D06468A":{name:"NearPad Token",logo:"nearpad.svg",erc20:!0,symbol:"PAD",decimals:18},"0x87C22615435998D69ACA34889D03155B694a94fc":{name:"DiemLibre",logo:"DLB.svg",erc20:!0,symbol:"DLB",decimals:18},"0x4d224452801ACEd8B2F0aebE155379bb5D594381":{name:"ApeCoin",logo:"APE.svg",erc20:!0,symbol:"APE",decimals:18},"0xCd1fAFf6e578Fa5cAC469d2418C95671bA1a62Fe":{name:"Torum Token",logo:"torum.svg",erc20:!0,symbol:"XTM",decimals:18},"0xcf0C122c6b73ff809C693DB761e7BaeBe62b6a2E":{name:"FLOKI",logo:"floki.svg",erc20:!0,symbol:"FLOKI",decimals:9},"0xe831F96A7a1DcE1aa2EB760b1e296c6A74CaA9d5":{name:"Nexum Coin",logo:"nexum.svg",erc20:!0,symbol:"Nexm",decimals:8},"0x6710c63432A2De02954fc0f851db07146a6c0312":{name:"MFG",logo:"mfg.svg",erc20:!0,symbol:"MFG",decimals:18},"0xae78736Cd615f374D3085123A210448E74Fc6393":{name:"Rocket Pool ETH",logo:"rETH.svg",erc20:!0,symbol:"rETH",decimals:18},"0x0C10bF8FcB7Bf5412187A595ab97a3609160b5c6":{name:"Decentralized USD",logo:"USDD.svg",erc20:!0,symbol:"USDD",decimals:18},"0xD33526068D116cE69F19A9ee46F0bd304F21A51f":{name:"Rocket Pool",logo:"rpl.svg",erc20:!0,symbol:"RPL",decimals:18},"0x9d38F670D15C14716BE1F109a4F453E966A2B6D4":{name:"Quid Ika",logo:"QuidIka.svg",erc20:!0,symbol:"QUID",decimals:9},"0xD3c625F54dec647DB8780dBBe0E880eF21BA4329":{name:"HollaEx Token",logo:"xht.svg",erc20:!0,symbol:"XHT",decimals:18},"0x01e0E2e61f554eCAaeC0cC933E739Ad90f24a86d":{name:"GTON",logo:"gton.svg",erc20:!0,symbol:"GTON",decimals:18},"0xeFF66B4A84C8a6b69b99EB1C5e39aF8fc35d13db":{name:"sGTON",logo:"sgton.svg",erc20:!0,symbol:"sGTON",decimals:18},"0x7659CE147D0e714454073a5dd7003544234b6Aa0":{name:"XCAD Token",logo:"xcad.svg",erc20:!0,symbol:"XCAD",decimals:18},"0x88dF592F8eb5D7Bd38bFeF7dEb0fBc02cf3778a0":{name:"Tellor Tributes",logo:"TRB.svg",erc20:!0,symbol:"TRB",decimals:18},"0x8d96B4ab6C741a4C8679AE323a100d74f085BA8F":{name:"Bazaars",logo:"BZR.svg",erc20:!0,symbol:"BZR",decimals:18},"0x9ee91F9f426fA633d227f7a9b000E28b9dfd8599":{name:"Liquid staked MATIC",logo:"stMATIC.svg",erc20:!0,symbol:"stMATIC",decimals:18},"0x0d02755a5700414B26FF040e1dE35D337DF56218":{name:"Bend Token",logo:"BendDAO.svg",erc20:!0,symbol:"BEND",decimals:18},"0x1A4b46696b2bB4794Eb3D4c26f1c55F9170fa4C5":{name:"BitDAO",logo:"BitDAO.svg",erc20:!0,erc721:!1,symbol:"BIT",decimals:18},"0xb8919522331C59f5C16bDfAA6A121a6E03A91F62":{name:"Home",logo:"home.svg",erc20:!0,erc721:!1,symbol:"HOME",decimals:6},"0xa54d2EBfD977ad836203c85F18db2F0a0cF88854":{name:"Bacon",logo:"bacon.svg",erc20:!0,erc721:!1,symbol:"BACON",decimals:18},"0x249cA82617eC3DfB2589c4c17ab7EC9765350a18":{name:"Verse",logo:"VERSE.svg",erc20:!0,erc721:!1,symbol:"VERSE",decimals:18},"0x317eb4ad9cfaC6232f0046831322E895507bcBeb":{name:"Tidex Token",logo:"tidex.svg",erc20:!0,symbol:"TDX",decimals:18},"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE":{name:"SHIBA INU",logo:"shib.svg",erc20:!0,symbol:"SHIB",decimals:18},"0x3506424F91fD33084466F402d5D97f05F8e3b4AF":{name:"chiliZ",logo:"chz.svg",erc20:!0,symbol:"CHZ",decimals:18},"0x15D4c048F83bd7e37d49eA4C83a07267Ec4203dA":{name:"Gala",logo:"gala.svg",erc20:!0,symbol:"GALA",decimals:8},"0x69af81e73A73B40adF4f3d4223Cd9b1ECE623074":{name:"Mask Network",logo:"mask.svg",erc20:!0,symbol:"MASK",decimals:18},"0xD533a949740bb3306d119CC777fa900bA034cd52":{name:"Curve DAO Token",logo:"crv.svg",erc20:!0,symbol:"CRV",decimals:18},"0x92D6C1e31e14520e676a687F0a93788B716BEff5":{name:"dYdX",logo:"dydx.svg",erc20:!0,symbol:"DYDX",decimals:18},"0x60bE1e1fE41c1370ADaF5d8e66f07Cf1C2Df2268":{name:"Perion Credits",logo:"perc.svg",erc20:!0,symbol:"PERC",decimals:18},"0x8971f9fd7196e5cEE2C1032B50F656855af7Dd26":{name:"Lambda",logo:"LAMB.svg",erc20:!0,symbol:"LAMB",decimals:18},"0x65514b352d1d4a17DE97f95C7faB177C625Bd6ff":{name:"KIBBLE Token",logo:"kibble.svg",erc20:!0,erc721:!1,symbol:"KBLE",decimals:18},"0xd9Fcd98c322942075A5C3860693e9f4f03AAE07b":{name:"Euler",logo:"eul.svg",erc20:!0,erc721:!1,symbol:"EUL",decimals:18},"0x777fD20c983d6658c1D50b3958B3A1733d1cd1E1":{name:"PUBLISH",logo:"publish.svg",erc20:!0,symbol:"NEWS",decimals:9},"0x19062190B1925b5b6689D7073fDfC8c2976EF8Cb":{name:"Swarm",logo:"ethswarm.svg",erc20:!0,symbol:"BZZ",decimals:16},"0x6aA030a9710CAD6E719A4EC0a85260Eb3F4F86c1":{name:"Real World Asset",logo:"rwa.svg",erc20:!0,symbol:"RWA",decimals:18},"0xde16Ce60804a881e9F8c4eBB3824646EDecd478D":{name:"MagicCraft",logo:"magiccraft.svg",erc20:!0,symbol:"MCRT",decimals:9},"0x7163436b8EfFfB469F6BB81cc908b1661d4795e6":{name:"Esco coin",logo:"escocoin.svg",erc20:!0,symbol:"ESCO",decimals:18},"0x9625cE7753ace1fa1865A47aAe2c5C2Ce4418569":{name:"KAP Games",logo:"kap-games.svg",erc20:!0,symbol:"KAP",decimals:18},"0x4FbB350052Bca5417566f188eB2EBCE5b19BC964":{name:"Rigo",logo:"grg.svg",erc20:!0,symbol:"GRG",decimals:18},"0xD8E163967FED76806Df0097B704bA721B9b37656":{name:"Cope",logo:"cope.svg",erc20:!0,symbol:"COPE",decimals:18},"0xdfbc9050F5B01DF53512DCC39B4f2B2BBaCD517A":{name:"Jobchain",logo:"job.svg",erc20:!0,symbol:"JOB",decimals:8},"0x083D41d6DD21EE938f0c055CA4fb12268DF0EfaC":{name:"GogolCoin",logo:"gol.svg",erc20:!0,symbol:"GOL",decimals:4},"0x9B4a69dE6CA0deFDD02c0c4ce6Cb84de5202944E":{name:"PROOF Platform",erc20:!0,symbol:"PROOF",decimals:9,logo:"proof-platform.svg"},"0x4507cEf57C46789eF8d1a19EA45f4216bae2B528":{name:"TokenFi",logo:"tokenfi.svg",erc20:!0,symbol:"TOKEN",decimals:9},"0x8B39B70E39Aa811b69365398e0aACe9bee238AEb":{name:"PolkaFoundry",logo:"pkf.svg",erc20:!0,symbol:"PKF",decimals:18},"0x2c95D751DA37A5C1d9c5a7Fd465c1d50F3d96160":{name:"WASSIE",logo:"wassie.svg",erc20:!0,symbol:"WASSIE",decimals:18},"0x06325440D014e39736583c165C2963BA99fAf14E":{name:"Curve.fi",logo:"steCRV.png",erc20:!0,symbol:"steCRV",decimals:18},"0x4E241A9EC66832a16bceaeB9156E524487f061D7":{name:"ETF Rocks",logo:"etf.svg",erc20:!0,symbol:"ETF",decimals:18},"0xA849EaaE994fb86Afa73382e9Bd88c2B6b18Dc71":{name:"Mass Vehicle Ledger",logo:"mvl.svg",erc20:!0,symbol:"MVL",decimals:18},"0xd5F7838F5C461fefF7FE49ea5ebaF7728bB0ADfa":{name:"Mantle Staked Ether",logo:"mETH.svg",erc20:!0,erc721:!1,symbol:"mETH",decimals:18}}}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/contract-map.json"}],[1638,{"./contract-map.json":1637},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports=e("./contract-map.json")}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/index.js"}],[1639,{"./types.cjs":1644},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.DAYS=r.DAY=r.HOURS=r.HOUR=r.MINUTES=r.MINUTE=r.SECONDS=r.SECOND=r.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=r.ApprovalType=r.ORIGIN_METAMASK=r.NFT_API_TIMEOUT=r.NFT_API_VERSION=r.NFT_API_BASE_URL=r.OPENSEA_PROXY_URL=r.NETWORKS_BYPASSING_VALIDATION=r.BUILT_IN_NETWORKS=r.BUILT_IN_CUSTOM_NETWORKS_RPC=r.TESTNET_TICKER_SYMBOLS=r.ASSET_TYPES=r.GWEI=r.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=r.ERC1155_METADATA_URI_INTERFACE_ID=r.ERC1155_INTERFACE_ID=r.ERC721_ENUMERABLE_INTERFACE_ID=r.ERC721_METADATA_INTERFACE_ID=r.ERC721_INTERFACE_ID=r.ERC20=r.ERC1155=r.ERC721=r.MAX_SAFE_CHAIN_ID=r.GANACHE_CHAIN_ID=r.IPFS_DEFAULT_GATEWAY_URL=r.FALL_BACK_VS_CURRENCY=r.RPC=void 0;const n=e("./types.cjs");var a;r.RPC="rpc",r.FALL_BACK_VS_CURRENCY="ETH",r.IPFS_DEFAULT_GATEWAY_URL="https://cloudflare-ipfs.com/ipfs/",r.GANACHE_CHAIN_ID="0x539",r.MAX_SAFE_CHAIN_ID=0xfffffffffffec,r.ERC721="ERC721",r.ERC1155="ERC1155",r.ERC20="ERC20",r.ERC721_INTERFACE_ID="0x80ac58cd",r.ERC721_METADATA_INTERFACE_ID="0x5b5e139f",r.ERC721_ENUMERABLE_INTERFACE_ID="0x780e9d63",r.ERC1155_INTERFACE_ID="0xd9b67a26",r.ERC1155_METADATA_URI_INTERFACE_ID="0x0e89341c",r.ERC1155_TOKEN_RECEIVER_INTERFACE_ID="0x4e2312e0",r.GWEI="gwei",r.ASSET_TYPES={NATIVE:"NATIVE",TOKEN:"TOKEN",NFT:"NFT",UNKNOWN:"UNKNOWN"},r.TESTNET_TICKER_SYMBOLS={GOERLI:"GoerliETH",SEPOLIA:"SepoliaETH",LINEA_GOERLI:"LineaETH",LINEA_SEPOLIA:"LineaETH",MEGAETH_TESTNET:"MegaETH",MEGAETH_TESTNET_V2:"MegaETH"},r.BUILT_IN_CUSTOM_NETWORKS_RPC={MEGAETH_TESTNET:"https://carrot.megaeth.com/rpc","megaeth-testnet":"https://carrot.megaeth.com/rpc","megaeth-testnet-v2":"https://carrot.megaeth.com/rpc","monad-testnet":"https://testnet-rpc.monad.xyz"},r.BUILT_IN_NETWORKS={[n.NetworkType.goerli]:{chainId:n.ChainId.goerli,ticker:n.NetworksTicker.goerli,rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl.goerli}},[n.NetworkType.sepolia]:{chainId:n.ChainId.sepolia,ticker:n.NetworksTicker.sepolia,rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl.sepolia}},[n.NetworkType.mainnet]:{chainId:n.ChainId.mainnet,ticker:n.NetworksTicker.mainnet,rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl.mainnet}},[n.NetworkType["linea-goerli"]]:{chainId:n.ChainId["linea-goerli"],ticker:n.NetworksTicker["linea-goerli"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["linea-goerli"]}},[n.NetworkType["linea-sepolia"]]:{chainId:n.ChainId["linea-sepolia"],ticker:n.NetworksTicker["linea-sepolia"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["linea-sepolia"]}},[n.NetworkType["linea-mainnet"]]:{chainId:n.ChainId["linea-mainnet"],ticker:n.NetworksTicker["linea-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["linea-mainnet"]}},[n.NetworkType["megaeth-testnet"]]:{chainId:n.ChainId["megaeth-testnet"],ticker:n.NetworksTicker["megaeth-testnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["megaeth-testnet"]}},[n.NetworkType["megaeth-testnet-v2"]]:{chainId:n.ChainId["megaeth-testnet-v2"],ticker:n.NetworksTicker["megaeth-testnet-v2"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["megaeth-testnet-v2"]}},[n.NetworkType["monad-testnet"]]:{chainId:n.ChainId["monad-testnet"],ticker:n.NetworksTicker["monad-testnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["monad-testnet"]}},[n.NetworkType["base-mainnet"]]:{chainId:n.ChainId["base-mainnet"],ticker:n.NetworksTicker["base-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["base-mainnet"]}},[n.NetworkType["arbitrum-mainnet"]]:{chainId:n.ChainId["arbitrum-mainnet"],ticker:n.NetworksTicker["arbitrum-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["arbitrum-mainnet"]}},[n.NetworkType["bsc-mainnet"]]:{chainId:n.ChainId["bsc-mainnet"],ticker:n.NetworksTicker["bsc-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["bsc-mainnet"]}},[n.NetworkType["optimism-mainnet"]]:{chainId:n.ChainId["optimism-mainnet"],ticker:n.NetworksTicker["optimism-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["optimism-mainnet"]}},[n.NetworkType["polygon-mainnet"]]:{chainId:n.ChainId["polygon-mainnet"],ticker:n.NetworksTicker["polygon-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["polygon-mainnet"]}},[n.NetworkType["sei-mainnet"]]:{chainId:n.ChainId["sei-mainnet"],ticker:n.NetworksTicker["sei-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["sei-mainnet"]}},[n.NetworkType.rpc]:{chainId:undefined,blockExplorerUrl:undefined,ticker:undefined,rpcPrefs:undefined}},r.NETWORKS_BYPASSING_VALIDATION={"0x3e7":{name:"HyperEVM",symbol:"HYPE",rpcUrl:"https://rpc.hyperliquid.xyz"}},r.OPENSEA_PROXY_URL="https://proxy.api.cx.metamask.io/opensea/v1/api/v2",r.NFT_API_BASE_URL="https://nft.api.cx.metamask.io",r.NFT_API_VERSION="1",r.NFT_API_TIMEOUT=15e3,r.ORIGIN_METAMASK="metamask",function(e){e.AddEthereumChain="wallet_addEthereumChain",e.ConnectAccounts="connect_accounts",e.EthDecrypt="eth_decrypt",e.EthGetEncryptionPublicKey="eth_getEncryptionPublicKey",e.EthSignTypedData="eth_signTypedData",e.PersonalSign="personal_sign",e.ResultError="result_error",e.ResultSuccess="result_success",e.SnapDialogAlert="snap_dialog:alert",e.SnapDialogConfirmation="snap_dialog:confirmation",e.SnapDialogPrompt="snap_dialog:prompt",e.SnapDialogDefault="snap_dialog",e.SwitchEthereumChain="wallet_switchEthereumChain",e.Transaction="transaction",e.TransactionBatch="transaction_batch",e.Unlock="unlock",e.WalletConnect="wallet_connect",e.WalletRequestPermissions="wallet_requestPermissions",e.WatchAsset="wallet_watchAsset"}(a||(r.ApprovalType=a={})),r.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP={[n.ChainId.goerli]:n.BuiltInNetworkName.Goerli,[n.ChainId.sepolia]:n.BuiltInNetworkName.Sepolia,[n.ChainId.mainnet]:n.BuiltInNetworkName.Mainnet,[n.ChainId["linea-goerli"]]:n.BuiltInNetworkName.LineaGoerli,[n.ChainId["linea-sepolia"]]:n.BuiltInNetworkName.LineaSepolia,[n.ChainId["linea-mainnet"]]:n.BuiltInNetworkName.LineaMainnet,[n.ChainId.aurora]:n.BuiltInNetworkName.Aurora},r.SECOND=1e3,r.SECONDS=r.SECOND,r.MINUTE=60*r.SECONDS,r.MINUTES=r.MINUTE,r.HOUR=60*r.MINUTES,r.HOURS=r.HOUR,r.DAY=24*r.HOURS,r.DAYS=r.DAY}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/constants.cjs"}],[1640,{cockatiel:4586},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createServicePolicy=r.DEFAULT_DEGRADED_THRESHOLD=r.DEFAULT_CIRCUIT_BREAK_DURATION=r.DEFAULT_MAX_CONSECUTIVE_FAILURES=r.DEFAULT_MAX_RETRIES=r.handleWhen=r.handleAll=r.ExponentialBackoff=r.ConstantBackoff=r.CircuitState=r.CockatielEventEmitter=r.BrokenCircuitError=void 0;const n=e("cockatiel");Object.defineProperty(r,"BrokenCircuitError",{enumerable:!0,get:function(){return n.BrokenCircuitError}}),Object.defineProperty(r,"CircuitState",{enumerable:!0,get:function(){return n.CircuitState}}),Object.defineProperty(r,"CockatielEventEmitter",{enumerable:!0,get:function(){return n.EventEmitter}}),Object.defineProperty(r,"ExponentialBackoff",{enumerable:!0,get:function(){return n.ExponentialBackoff}}),Object.defineProperty(r,"ConstantBackoff",{enumerable:!0,get:function(){return n.ConstantBackoff}}),Object.defineProperty(r,"handleAll",{enumerable:!0,get:function(){return n.handleAll}}),Object.defineProperty(r,"handleWhen",{enumerable:!0,get:function(){return n.handleWhen}});const a="available",i="degraded",s="unavailable",o="unknown";r.DEFAULT_MAX_RETRIES=3,r.DEFAULT_MAX_CONSECUTIVE_FAILURES=3*(1+r.DEFAULT_MAX_RETRIES),r.DEFAULT_CIRCUIT_BREAK_DURATION=18e5,r.DEFAULT_DEGRADED_THRESHOLD=5e3;const c=e=>"object"!=typeof e||null===e||!("httpStatus"in e)||"number"!=typeof e.httpStatus||e.httpStatus>=500;function l(e){return e===n.CircuitState.Open?{state:e,openedAt:Date.now()}:{state:e}}r.createServicePolicy=function(e={}){const{maxRetries:t=r.DEFAULT_MAX_RETRIES,retryFilterPolicy:u=n.handleAll,maxConsecutiveFailures:d=r.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:f=r.DEFAULT_CIRCUIT_BREAK_DURATION,degradedThreshold:m=r.DEFAULT_DEGRADED_THRESHOLD,backoff:h=new n.ExponentialBackoff}=e;let p=o;const g=(0,n.retry)(u,{maxAttempts:t,backoff:h}),b=g.onRetry.bind(g),y=new n.ConsecutiveBreaker(d),v=(0,n.circuitBreaker)((0,n.handleWhen)(c),{halfOpenAfter:f,breaker:y});let w=l(v.state);v.onStateChange(e=>{w=l(e)}),v.onBreak(()=>{p=s});const _=v.onBreak.bind(v),j=new n.EventEmitter,O=j.addListener,E=new n.EventEmitter,C=E.addListener;return g.onGiveUp(e=>{v.state===n.CircuitState.Closed&&(p=i,j.emit(e))}),g.onSuccess(({duration:e})=>{v.state===n.CircuitState.Closed&&(e>m?(p=i,j.emit()):p!==a&&(p=a,E.emit()))}),{...(0,n.wrap)(g,v),circuitBreakerPolicy:v,circuitBreakDuration:f,getCircuitState:()=>v.state,getRemainingCircuitOpenDuration:()=>w.state===n.CircuitState.Open?w.openedAt+f-Date.now():null,reset:()=>{const{dispose:e}=v.isolate();e(),y.success(),p=o},retryPolicy:g,onBreak:_,onDegraded:O,onAvailable:C,onRetry:b}}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/create-service-policy.cjs"}],[1641,{"./constants.cjs":1639,"./create-service-policy.cjs":1640,"./siwe.cjs":1643,"./types.cjs":1644,"./util.cjs":1645},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.fetchWithErrorHandling=r.convertHexToDecimal=r.BNToHex=r.NETWORKS_BYPASSING_VALIDATION=r.DAYS=r.DAY=r.HOURS=r.HOUR=r.MINUTES=r.MINUTE=r.SECONDS=r.SECOND=r.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=r.ApprovalType=r.ORIGIN_METAMASK=r.NFT_API_TIMEOUT=r.NFT_API_VERSION=r.NFT_API_BASE_URL=r.OPENSEA_PROXY_URL=r.BUILT_IN_NETWORKS=r.BUILT_IN_CUSTOM_NETWORKS_RPC=r.TESTNET_TICKER_SYMBOLS=r.ASSET_TYPES=r.GWEI=r.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=r.ERC1155_METADATA_URI_INTERFACE_ID=r.ERC1155_INTERFACE_ID=r.ERC721_ENUMERABLE_INTERFACE_ID=r.ERC721_METADATA_INTERFACE_ID=r.ERC721_INTERFACE_ID=r.ERC20=r.ERC1155=r.ERC721=r.MAX_SAFE_CHAIN_ID=r.GANACHE_CHAIN_ID=r.IPFS_DEFAULT_GATEWAY_URL=r.FALL_BACK_VS_CURRENCY=r.RPC=r.handleWhen=r.handleAll=r.createServicePolicy=r.ExponentialBackoff=r.DEFAULT_MAX_RETRIES=r.DEFAULT_MAX_CONSECUTIVE_FAILURES=r.DEFAULT_DEGRADED_THRESHOLD=r.DEFAULT_CIRCUIT_BREAK_DURATION=r.ConstantBackoff=r.CockatielEventEmitter=r.CircuitState=r.BrokenCircuitError=void 0,r.isEqualCaseInsensitive=r.weiHexToGweiDec=r.toHex=r.toChecksumHexAddress=r.timeoutFetch=r.successfulFetch=r.safelyExecuteWithTimeout=r.safelyExecute=r.query=r.normalizeEnsName=r.isValidHexAddress=r.isValidJson=r.isSmartContractCode=r.isSafeDynamicKey=r.isSafeChainId=r.isPlainObject=r.isNonEmptyArray=r.HttpError=r.hexToText=r.hexToBN=r.handleFetch=r.gweiDecToWEIBN=r.getBuyURL=r.fromHex=r.fractionBN=void 0;var i=e("./create-service-policy.cjs");Object.defineProperty(r,"BrokenCircuitError",{enumerable:!0,get:function(){return i.BrokenCircuitError}}),Object.defineProperty(r,"CircuitState",{enumerable:!0,get:function(){return i.CircuitState}}),Object.defineProperty(r,"CockatielEventEmitter",{enumerable:!0,get:function(){return i.CockatielEventEmitter}}),Object.defineProperty(r,"ConstantBackoff",{enumerable:!0,get:function(){return i.ConstantBackoff}}),Object.defineProperty(r,"DEFAULT_CIRCUIT_BREAK_DURATION",{enumerable:!0,get:function(){return i.DEFAULT_CIRCUIT_BREAK_DURATION}}),Object.defineProperty(r,"DEFAULT_DEGRADED_THRESHOLD",{enumerable:!0,get:function(){return i.DEFAULT_DEGRADED_THRESHOLD}}),Object.defineProperty(r,"DEFAULT_MAX_CONSECUTIVE_FAILURES",{enumerable:!0,get:function(){return i.DEFAULT_MAX_CONSECUTIVE_FAILURES}}),Object.defineProperty(r,"DEFAULT_MAX_RETRIES",{enumerable:!0,get:function(){return i.DEFAULT_MAX_RETRIES}}),Object.defineProperty(r,"ExponentialBackoff",{enumerable:!0,get:function(){return i.ExponentialBackoff}}),Object.defineProperty(r,"createServicePolicy",{enumerable:!0,get:function(){return i.createServicePolicy}}),Object.defineProperty(r,"handleAll",{enumerable:!0,get:function(){return i.handleAll}}),Object.defineProperty(r,"handleWhen",{enumerable:!0,get:function(){return i.handleWhen}});var s=e("./constants.cjs");Object.defineProperty(r,"RPC",{enumerable:!0,get:function(){return s.RPC}}),Object.defineProperty(r,"FALL_BACK_VS_CURRENCY",{enumerable:!0,get:function(){return s.FALL_BACK_VS_CURRENCY}}),Object.defineProperty(r,"IPFS_DEFAULT_GATEWAY_URL",{enumerable:!0,get:function(){return s.IPFS_DEFAULT_GATEWAY_URL}}),Object.defineProperty(r,"GANACHE_CHAIN_ID",{enumerable:!0,get:function(){return s.GANACHE_CHAIN_ID}}),Object.defineProperty(r,"MAX_SAFE_CHAIN_ID",{enumerable:!0,get:function(){return s.MAX_SAFE_CHAIN_ID}}),Object.defineProperty(r,"ERC721",{enumerable:!0,get:function(){return s.ERC721}}),Object.defineProperty(r,"ERC1155",{enumerable:!0,get:function(){return s.ERC1155}}),Object.defineProperty(r,"ERC20",{enumerable:!0,get:function(){return s.ERC20}}),Object.defineProperty(r,"ERC721_INTERFACE_ID",{enumerable:!0,get:function(){return s.ERC721_INTERFACE_ID}}),Object.defineProperty(r,"ERC721_METADATA_INTERFACE_ID",{enumerable:!0,get:function(){return s.ERC721_METADATA_INTERFACE_ID}}),Object.defineProperty(r,"ERC721_ENUMERABLE_INTERFACE_ID",{enumerable:!0,get:function(){return s.ERC721_ENUMERABLE_INTERFACE_ID}}),Object.defineProperty(r,"ERC1155_INTERFACE_ID",{enumerable:!0,get:function(){return s.ERC1155_INTERFACE_ID}}),Object.defineProperty(r,"ERC1155_METADATA_URI_INTERFACE_ID",{enumerable:!0,get:function(){return s.ERC1155_METADATA_URI_INTERFACE_ID}}),Object.defineProperty(r,"ERC1155_TOKEN_RECEIVER_INTERFACE_ID",{enumerable:!0,get:function(){return s.ERC1155_TOKEN_RECEIVER_INTERFACE_ID}}),Object.defineProperty(r,"GWEI",{enumerable:!0,get:function(){return s.GWEI}}),Object.defineProperty(r,"ASSET_TYPES",{enumerable:!0,get:function(){return s.ASSET_TYPES}}),Object.defineProperty(r,"TESTNET_TICKER_SYMBOLS",{enumerable:!0,get:function(){return s.TESTNET_TICKER_SYMBOLS}}),Object.defineProperty(r,"BUILT_IN_CUSTOM_NETWORKS_RPC",{enumerable:!0,get:function(){return s.BUILT_IN_CUSTOM_NETWORKS_RPC}}),Object.defineProperty(r,"BUILT_IN_NETWORKS",{enumerable:!0,get:function(){return s.BUILT_IN_NETWORKS}}),Object.defineProperty(r,"OPENSEA_PROXY_URL",{enumerable:!0,get:function(){return s.OPENSEA_PROXY_URL}}),Object.defineProperty(r,"NFT_API_BASE_URL",{enumerable:!0,get:function(){return s.NFT_API_BASE_URL}}),Object.defineProperty(r,"NFT_API_VERSION",{enumerable:!0,get:function(){return s.NFT_API_VERSION}}),Object.defineProperty(r,"NFT_API_TIMEOUT",{enumerable:!0,get:function(){return s.NFT_API_TIMEOUT}}),Object.defineProperty(r,"ORIGIN_METAMASK",{enumerable:!0,get:function(){return s.ORIGIN_METAMASK}}),Object.defineProperty(r,"ApprovalType",{enumerable:!0,get:function(){return s.ApprovalType}}),Object.defineProperty(r,"CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP",{enumerable:!0,get:function(){return s.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP}}),Object.defineProperty(r,"SECOND",{enumerable:!0,get:function(){return s.SECOND}}),Object.defineProperty(r,"SECONDS",{enumerable:!0,get:function(){return s.SECONDS}}),Object.defineProperty(r,"MINUTE",{enumerable:!0,get:function(){return s.MINUTE}}),Object.defineProperty(r,"MINUTES",{enumerable:!0,get:function(){return s.MINUTES}}),Object.defineProperty(r,"HOUR",{enumerable:!0,get:function(){return s.HOUR}}),Object.defineProperty(r,"HOURS",{enumerable:!0,get:function(){return s.HOURS}}),Object.defineProperty(r,"DAY",{enumerable:!0,get:function(){return s.DAY}}),Object.defineProperty(r,"DAYS",{enumerable:!0,get:function(){return s.DAYS}}),Object.defineProperty(r,"NETWORKS_BYPASSING_VALIDATION",{enumerable:!0,get:function(){return s.NETWORKS_BYPASSING_VALIDATION}});var o=e("./util.cjs");Object.defineProperty(r,"BNToHex",{enumerable:!0,get:function(){return o.BNToHex}}),Object.defineProperty(r,"convertHexToDecimal",{enumerable:!0,get:function(){return o.convertHexToDecimal}}),Object.defineProperty(r,"fetchWithErrorHandling",{enumerable:!0,get:function(){return o.fetchWithErrorHandling}}),Object.defineProperty(r,"fractionBN",{enumerable:!0,get:function(){return o.fractionBN}}),Object.defineProperty(r,"fromHex",{enumerable:!0,get:function(){return o.fromHex}}),Object.defineProperty(r,"getBuyURL",{enumerable:!0,get:function(){return o.getBuyURL}}),Object.defineProperty(r,"gweiDecToWEIBN",{enumerable:!0,get:function(){return o.gweiDecToWEIBN}}),Object.defineProperty(r,"handleFetch",{enumerable:!0,get:function(){return o.handleFetch}}),Object.defineProperty(r,"hexToBN",{enumerable:!0,get:function(){return o.hexToBN}}),Object.defineProperty(r,"hexToText",{enumerable:!0,get:function(){return o.hexToText}}),Object.defineProperty(r,"HttpError",{enumerable:!0,get:function(){return o.HttpError}}),Object.defineProperty(r,"isNonEmptyArray",{enumerable:!0,get:function(){return o.isNonEmptyArray}}),Object.defineProperty(r,"isPlainObject",{enumerable:!0,get:function(){return o.isPlainObject}}),Object.defineProperty(r,"isSafeChainId",{enumerable:!0,get:function(){return o.isSafeChainId}}),Object.defineProperty(r,"isSafeDynamicKey",{enumerable:!0,get:function(){return o.isSafeDynamicKey}}),Object.defineProperty(r,"isSmartContractCode",{enumerable:!0,get:function(){return o.isSmartContractCode}}),Object.defineProperty(r,"isValidJson",{enumerable:!0,get:function(){return o.isValidJson}}),Object.defineProperty(r,"isValidHexAddress",{enumerable:!0,get:function(){return o.isValidHexAddress}}),Object.defineProperty(r,"normalizeEnsName",{enumerable:!0,get:function(){return o.normalizeEnsName}}),Object.defineProperty(r,"query",{enumerable:!0,get:function(){return o.query}}),Object.defineProperty(r,"safelyExecute",{enumerable:!0,get:function(){return o.safelyExecute}}),Object.defineProperty(r,"safelyExecuteWithTimeout",{enumerable:!0,get:function(){return o.safelyExecuteWithTimeout}}),Object.defineProperty(r,"successfulFetch",{enumerable:!0,get:function(){return o.successfulFetch}}),Object.defineProperty(r,"timeoutFetch",{enumerable:!0,get:function(){return o.timeoutFetch}}),Object.defineProperty(r,"toChecksumHexAddress",{enumerable:!0,get:function(){return o.toChecksumHexAddress}}),Object.defineProperty(r,"toHex",{enumerable:!0,get:function(){return o.toHex}}),Object.defineProperty(r,"weiHexToGweiDec",{enumerable:!0,get:function(){return o.weiHexToGweiDec}}),Object.defineProperty(r,"isEqualCaseInsensitive",{enumerable:!0,get:function(){return o.isEqualCaseInsensitive}}),a(e("./types.cjs"),r),a(e("./siwe.cjs"),r)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/index.cjs"}],[1642,{"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("controller-utils")}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/logger.cjs"}],[1643,{"./logger.cjs":1642,"@metamask/utils":3557,"@spruceid/siwe-parser":3645,buffer:4526},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.detectSIWE=r.isValidSIWEOrigin=r.parseDomainParts=void 0;const n=e("@metamask/utils"),a=e("@spruceid/siwe-parser"),i=e("./logger.cjs"),s=(0,i.createModuleLogger)(i.projectLogger,"detect-siwe");function o(e){try{const a="string"!=typeof(r=e)?r:(0,n.remove0x)(r),i=t.from(a,"hex");return 32===i.length?e:i.toString("utf8")}catch(t){return s(t),e}var r}const c={"http:":"80","https:":"443"};r.parseDomainParts=(e,t)=>e.match(/^[^/:]*:\/\//u)?new URL(e):new URL(`${t}//${e}`);r.isValidSIWEOrigin=e=>{try{const{origin:t,siwe:n}=e;if(!t||!n?.parsedMessage?.domain)return!1;const a=new URL(t),i=(0,r.parseDomainParts)(n.parsedMessage.domain,a.protocol);return 0===i.hostname.localeCompare(a.hostname,undefined,{sensitivity:"accent"})&&(""!==i.port&&i.port!==a.port?""===a.port&&i.port===c[a.protocol]:""===i.username||i.username===a.username)}catch(e){return s(e),!1}};r.detectSIWE=e=>{try{const{data:t}=e,r=o(t);return{isSIWEMessage:!0,parsedMessage:new a.ParsedMessage(r)}}catch{return{isSIWEMessage:!1,parsedMessage:null}}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/siwe.cjs"}],[1644,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a;Object.defineProperty(r,"__esModule",{value:!0}),r.NetworkNickname=r.BlockExplorerUrl=r.NetworksTicker=r.ChainId=r.BuiltInNetworkName=r.isInfuraNetworkType=r.isNetworkType=r.NetworkType=r.CustomNetworkType=r.InfuraNetworkType=void 0,r.InfuraNetworkType={mainnet:"mainnet",goerli:"goerli",sepolia:"sepolia","linea-goerli":"linea-goerli","linea-sepolia":"linea-sepolia","linea-mainnet":"linea-mainnet","base-mainnet":"base-mainnet","arbitrum-mainnet":"arbitrum-mainnet","bsc-mainnet":"bsc-mainnet","optimism-mainnet":"optimism-mainnet","polygon-mainnet":"polygon-mainnet","sei-mainnet":"sei-mainnet"},r.CustomNetworkType={"megaeth-testnet":"megaeth-testnet","megaeth-testnet-v2":"megaeth-testnet-v2","monad-testnet":"monad-testnet"},r.NetworkType={...r.InfuraNetworkType,...r.CustomNetworkType,rpc:"rpc"},r.isNetworkType=function(e){return Object.values(r.NetworkType).includes(e)},r.isInfuraNetworkType=function(e){return Object.keys(r.InfuraNetworkType).includes(e)},function(e){e.Mainnet="mainnet",e.Goerli="goerli",e.Sepolia="sepolia",e.LineaGoerli="linea-goerli",e.LineaSepolia="linea-sepolia",e.LineaMainnet="linea-mainnet",e.Aurora="aurora",e.MegaETHTestnet="megaeth-testnet",e.MegaETHTestnetV2="megaeth-testnet-v2",e.MonadTestnet="monad-testnet",e.BaseMainnet="base-mainnet",e.ArbitrumOne="arbitrum-mainnet",e.BscMainnet="bsc-mainnet",e.OptimismMainnet="optimism-mainnet",e.PolygonMainnet="polygon-mainnet",e.SeiMainnet="sei-mainnet"}(n||(r.BuiltInNetworkName=n={})),r.ChainId={[n.Mainnet]:"0x1",[n.Goerli]:"0x5",[n.Sepolia]:"0xaa36a7",[n.Aurora]:"0x4e454152",[n.LineaGoerli]:"0xe704",[n.LineaSepolia]:"0xe705",[n.LineaMainnet]:"0xe708",[n.MegaETHTestnet]:"0x18c6",[n.MegaETHTestnetV2]:"0x18c7",[n.MonadTestnet]:"0x279f",[n.BaseMainnet]:"0x2105",[n.ArbitrumOne]:"0xa4b1",[n.BscMainnet]:"0x38",[n.OptimismMainnet]:"0xa",[n.PolygonMainnet]:"0x89",[n.SeiMainnet]:"0x531"},function(e){e.mainnet="ETH",e.goerli="GoerliETH",e.sepolia="SepoliaETH",e["linea-goerli"]="LineaETH",e["linea-sepolia"]="LineaETH",e["linea-mainnet"]="ETH",e["megaeth-testnet"]="MegaETH",e["megaeth-testnet-v2"]="MegaETH",e["monad-testnet"]="MON",e["base-mainnet"]="ETH",e["arbitrum-mainnet"]="ETH",e["bsc-mainnet"]="BNB",e["optimism-mainnet"]="ETH",e["polygon-mainnet"]="POL",e["sei-mainnet"]="SEI",e.rpc=""}(a||(r.NetworksTicker=a={})),r.BlockExplorerUrl={[n.Mainnet]:"https://etherscan.io",[n.Goerli]:"https://goerli.etherscan.io",[n.Sepolia]:"https://sepolia.etherscan.io",[n.LineaGoerli]:"https://goerli.lineascan.build",[n.LineaSepolia]:"https://sepolia.lineascan.build",[n.LineaMainnet]:"https://lineascan.build",[n.MegaETHTestnet]:"https://megaexplorer.xyz",[n.MegaETHTestnetV2]:"https://megaeth-testnet-v2.blockscout.com",[n.MonadTestnet]:"https://testnet.monadexplorer.com",[n.BaseMainnet]:"https://basescan.org",[n.ArbitrumOne]:"https://arbiscan.io",[n.BscMainnet]:"https://bscscan.com",[n.OptimismMainnet]:"https://optimistic.etherscan.io",[n.PolygonMainnet]:"https://polygonscan.com",[n.SeiMainnet]:"https://seitrace.com"},r.NetworkNickname={[n.Mainnet]:"Ethereum Mainnet",[n.Goerli]:"Goerli",[n.Sepolia]:"Sepolia",[n.LineaGoerli]:"Linea Goerli",[n.LineaSepolia]:"Linea Sepolia",[n.LineaMainnet]:"Linea",[n.MegaETHTestnet]:"Mega Testnet",[n.MegaETHTestnetV2]:"MegaETH Testnet",[n.MonadTestnet]:"Monad Testnet",[n.BaseMainnet]:"Base Mainnet",[n.ArbitrumOne]:"Arbitrum One",[n.BscMainnet]:"BSC Mainnet",[n.OptimismMainnet]:"Optimism Mainnet",[n.PolygonMainnet]:"Polygon Mainnet",[n.SeiMainnet]:"Sei Mainnet"}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/types.cjs"}],[1645,{"./constants.cjs":1639,"@metamask/ethjs-unit":2337,"@metamask/utils":3557,"bn.js":4465,buffer:4526,"eth-ens-namehash":4730,"fast-deep-equal":4834,lodash:5291},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.isEqualCaseInsensitive=r.isValidJson=r.isNonEmptyArray=r.isPlainObject=r.convertHexToDecimal=r.query=r.normalizeEnsName=r.timeoutFetch=r.fetchWithErrorHandling=r.handleFetch=r.successfulFetch=r.HttpError=r.isSmartContractCode=r.isValidHexAddress=r.toChecksumHexAddress=r.safelyExecuteWithTimeout=r.safelyExecute=r.toHex=r.fromHex=r.hexToText=r.hexToBN=r.getBuyURL=r.weiHexToGweiDec=r.gweiDecToWEIBN=r.fractionBN=r.BNToHex=r.isSafeChainId=r.isSafeDynamicKey=r.PROTOTYPE_POLLUTION_BLOCKLIST=void 0;const a=e("@metamask/ethjs-unit"),i=e("@metamask/utils"),s=n(e("bn.js")),o=n(e("eth-ens-namehash")),c=n(e("fast-deep-equal")),l=e("lodash"),u=e("./constants.cjs"),d=new Error("timeout");function f(e){return e?new s.default((0,i.remove0x)(e),16):new s.default(0)}r.PROTOTYPE_POLLUTION_BLOCKLIST=["__proto__","constructor","prototype"],r.isSafeDynamicKey=function(e){return"string"==typeof e&&!r.PROTOTYPE_POLLUTION_BLOCKLIST.some(t=>e===t)},r.isSafeChainId=function(e){if(!(0,i.isHexString)(e))return!1;const t=Number.parseInt(e,(0,i.isStrictHexString)(e)?16:10);return Number.isSafeInteger(t)&&t>0&&t<=u.MAX_SAFE_CHAIN_ID},r.BNToHex=function(e){return(0,i.add0x)(e.toString(16))},r.fractionBN=function(e,t,r){const n=new s.default(t),a=new s.default(r);return e.mul(n).div(a)},r.gweiDecToWEIBN=function(e){if(Number.isNaN(e))return new s.default(0);const t=e.toString().split("."),r=t[0]||"0";let n=t[1]||"";if(!n)return(0,a.toWei)(r,"gwei");if(n.length<=9)return(0,a.toWei)(`${r}.${n}`,"gwei");const i=n.slice(9)[0];n=n.slice(0,9);let o=(0,a.toWei)(`${r}.${n}`,"gwei");return Number(i)>=5&&(o=o.add(new s.default(1))),o},r.weiHexToGweiDec=function(e){const t=new s.default((0,i.remove0x)(e),16);return(0,a.fromWei)(t,"gwei")},r.getBuyURL=function(e="1",t,r=5){switch(e){case"1":return`https://buy.coinbase.com/?code=9ec56d01-7e81-5017-930c-513daa27bb6a&amount=${r}&address=${t}&crypto_currency=ETH`;case"5":return"https://goerli-faucet.slock.it/";case"11155111":return"https://sepoliafaucet.net/";default:return undefined}},r.hexToBN=f,r.hexToText=function(e){try{const r=(0,i.remove0x)(e);return t.from(r,"hex").toString("utf8")}catch{return e}},r.fromHex=function(e){return s.default.isBN(e)?e:new s.default(f(e).toString(10))},r.toHex=function(e){return"string"==typeof e&&(0,i.isStrictHexString)(e)?e:`0x${s.default.isBN(e)||"bigint"==typeof e?e.toString(16):new s.default(e.toString(),10).toString(16)}`},r.safelyExecute=async function(e,t=!1){try{return await e()}catch(e){return t&&console.error(e),undefined}},r.safelyExecuteWithTimeout=async function(e,t=!1,r=500){try{return await Promise.race([e(),new Promise((e,t)=>setTimeout(()=>{t(d)},r))])}catch(e){return t&&console.error(e),undefined}},r.toChecksumHexAddress=(0,l.memoize)(function(e){if("string"!=typeof e)return e;const t=(0,i.add0x)(e);if(!(0,i.isHexString)(t))return t;try{return(0,i.getChecksumAddress)(t)}catch(e){if(e instanceof Error&&"Invalid hex address."===e.message)return t;throw e}}),r.isValidHexAddress=(0,l.memoize)(function(e,{allowNonPrefixed:t=!0}={}){const r=t?(0,i.add0x)(e):e;return!!(0,i.isStrictHexString)(r)&&(0,i.isHexChecksumAddress)(r)},(e,{allowNonPrefixed:t=!0}={})=>`${e}-${t}`),r.isSmartContractCode=function(e){return!!e&&("0x"!==e&&"0x0"!==e)};class m extends Error{constructor(e,t){super(t??`Fetch failed with status '${e}'`),this.httpStatus=e}}async function h(e,t){const r=await fetch(e,t);if(!r.ok)throw new m(r.status,`Fetch failed with status '${r.status}' for request '${String(e)}'`);return r}async function p(e,t){const r=await h(e,t);return await r.json()}r.HttpError=m,r.successfulFetch=h,r.handleFetch=p,r.fetchWithErrorHandling=async function({url:e,options:t,timeout:r,errorCodesToCatch:n}){let a;try{a=r?Promise.race([await p(e,t),new Promise((e,t)=>setTimeout(()=>{t(d)},r))]):await p(e,t)}catch(e){!function(e,t=[]){if(!e)return;if(!(e instanceof Error))throw e;if(!t.some(t=>e.message.includes(`Fetch failed with status '${t}'`))&&!e.message.includes("Failed to fetch")&&e!==d)throw e;console.error(e)}(e,n)}return a},r.timeoutFetch=async function(e,t,r=500){return Promise.race([h(e,t),new Promise((e,t)=>setTimeout(()=>{t(d)},r))])},r.normalizeEnsName=function(e){if("."===e)return e;if(e&&"string"==typeof e)try{const t=o.default.normalize(e.trim());if(t.match(/^(([\w\d-]+)\.)*[\w\d-]{7,}\.(eth|test)$/u))return t}catch{}return null},r.query=function(e,t,r=[]){return new Promise((n,a)=>{const i=(e,t)=>{e?a(e):n(t)};t in e&&"function"==typeof e[t]?e[t](...r,i):e.sendAsync({method:t,params:r},i)})};r.convertHexToDecimal=(e="0x0")=>(0,i.isStrictHexString)(e)?parseInt(e,16):Number(e)?Number(e):0,r.isPlainObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)},r.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},r.isValidJson=function(e){try{return(0,c.default)(e,JSON.parse(JSON.stringify(e)))}catch{return!1}},r.isEqualCaseInsensitive=function(e,t){return"string"==typeof e&&"string"==typeof t&&e.toLowerCase()===t.toLowerCase()}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/util.cjs"}],[1654,{"@metamask/abi-utils":1238,"@metamask/utils":3557,"@noble/hashes/sha3":3612},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e("@metamask/utils"),a={out:"hex"};function i(e,t){if("hex"===t.out){const t="string"==typeof e?e:n.bytesToHex.call(void 0,e);return t.startsWith("0x")?t:`0x${t}`}return e instanceof Uint8Array?e:n.hexToBytes.call(void 0,e)}var s=e=>"string"==typeof e?e:n.bytesToHex.call(void 0,e),o=e=>"string"==typeof e?n.hexToBytes.call(void 0,e):e,c=({value:e,size:t})=>e.toString(16).padStart(2*t,"0");var l=253402300799;var u=e("@metamask/abi-utils"),d=e("@noble/hashes/sha3"),f="0x88c1d2ecf185adf710588203a5f263f0ff61be0d33da39792cde19ba9aa4331e",m="0x80ad7e1b04ee6d994a125f4714ca0720908bd80ed16063ec8aee4b88e9253e2d",h="(address,address,bytes32,(address,bytes,bytes)[],uint256,bytes)[]";var p=(e,t)=>{const[r,n,a,i,s,o]=e;return{delegate:t(r),delegator:t(n),authority:t(a),caveats:i.map(([e,r,n])=>({enforcer:t(e),terms:t(r),args:t(n)})),salt:s,signature:t(o)}};function g(e){const t=32*e.length,r=new Uint8Array(t);for(let t=0;t<e.length;t++){const n=e[t];if(!n)throw new Error(`Caveat was undefined at index ${t}`);const a=b(n);r.set(a,32*t)}return d.keccak_256.call(void 0,r)}function b(e){const t="string"==typeof e.terms?n.hexToBytes.call(void 0,e.terms):e.terms,r=d.keccak_256.call(void 0,t),a=u.encode.call(void 0,["bytes32","address","bytes32"],[m,e.enforcer,r]);return d.keccak_256.call(void 0,a)}r.ANY_BENEFICIARY="0x0000000000000000000000000000000000000a11",r.CAVEAT_TYPEHASH=m,r.DELEGATION_TYPEHASH=f,r.ROOT_AUTHORITY="0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",r.createERC20StreamingTerms=function(e,t=a){const{tokenAddress:r,initialAmount:s,maxAmount:o,amountPerSecond:l,startTime:u}=e;if(!r)throw new Error("Invalid tokenAddress: must be a valid address");let d;if("string"==typeof r){if(!n.isHexString.call(void 0,r)||42!==r.length)throw new Error("Invalid tokenAddress: must be a valid address");d=r}else{if(20!==r.length)throw new Error("Invalid tokenAddress: must be a valid address");d=n.bytesToHex.call(void 0,r)}if(s<0n)throw new Error("Invalid initialAmount: must be greater than zero");if(o<=0n)throw new Error("Invalid maxAmount: must be a positive number");if(o<s)throw new Error("Invalid maxAmount: must be greater than initialAmount");if(l<=0n)throw new Error("Invalid amountPerSecond: must be a positive number");if(u<=0)throw new Error("Invalid startTime: must be a positive number");if(u>253402300799)throw new Error("Invalid startTime: must be less than or equal to 253402300799");return i(`${d}${c({value:s,size:32})}${c({value:o,size:32})}${c({value:l,size:32})}${c({value:u,size:32})}`,t)},r.createERC20TokenPeriodTransferTerms=function(e,t=a){const{tokenAddress:r,periodAmount:s,periodDuration:o,startDate:l}=e;if(!r)throw new Error("Invalid tokenAddress: must be a valid address");let u;if("string"==typeof r){if(!n.isHexString.call(void 0,r)||42!==r.length)throw new Error("Invalid tokenAddress: must be a valid address");u=r}else{if(20!==r.length)throw new Error("Invalid tokenAddress: must be a valid address");u=n.bytesToHex.call(void 0,r)}if(s<=0n)throw new Error("Invalid periodAmount: must be a positive number");if(o<=0)throw new Error("Invalid periodDuration: must be a positive number");if(l<=0)throw new Error("Invalid startDate: must be a positive number");return i(`${u}${c({value:s,size:32})}${c({value:o,size:32})}${c({value:l,size:32})}`,t)},r.createExactCalldataTerms=function(e,t=a){const{calldata:r}=e;if("string"==typeof r&&!r.startsWith("0x"))throw new Error("Invalid calldata: must be a hex string starting with 0x");return i(r,t)},r.createNativeTokenPeriodTransferTerms=function(e,t=a){const{periodAmount:r,periodDuration:n,startDate:s}=e;if(r<=0n)throw new Error("Invalid periodAmount: must be a positive number");if(n<=0)throw new Error("Invalid periodDuration: must be a positive number");if(s<=0)throw new Error("Invalid startDate: must be a positive number");return i(`0x${c({value:r,size:32})}${c({value:n,size:32})}${c({value:s,size:32})}`,t)},r.createNativeTokenStreamingTerms=function(e,t=a){const{initialAmount:r,maxAmount:n,amountPerSecond:s,startTime:o}=e;if(r<0n)throw new Error("Invalid initialAmount: must be greater than zero");if(n<=0n)throw new Error("Invalid maxAmount: must be a positive number");if(n<r)throw new Error("Invalid maxAmount: must be greater than initialAmount");if(s<=0n)throw new Error("Invalid amountPerSecond: must be a positive number");if(o<=0)throw new Error("Invalid startTime: must be a positive number");if(o>253402300799)throw new Error("Invalid startTime: must be less than or equal to 253402300799");return i(`0x${c({value:r,size:32})}${c({value:n,size:32})}${c({value:s,size:32})}${c({value:o,size:32})}`,t)},r.createNonceTerms=function(e,t=a){const{nonce:r}=e;if(r instanceof Uint8Array&&0===r.length)throw new Error("Invalid nonce: Uint8Array must not be empty");if("string"==typeof r&&!r.startsWith("0x"))throw new Error("Invalid nonce: string must have 0x prefix");const o=s(r);if("0x"===o)throw new Error("Invalid nonce: must not be empty");if(!n.isHexString.call(void 0,o))throw new Error("Invalid nonce: must be a valid BytesLike value");if(o.length>66)throw new Error("Invalid nonce: must be 32 bytes or less in length");return i(`0x${o.slice(2).padStart(64,"0")}`,t)},r.createTimestampTerms=function(e,t=a){const{timestampAfterThreshold:r,timestampBeforeThreshold:n}=e;if(r<0)throw new Error("Invalid timestampAfterThreshold: must be zero or positive");if(n<0)throw new Error("Invalid timestampBeforeThreshold: must be zero or positive");if(n>l)throw new Error("Invalid timestampBeforeThreshold: must be less than or equal to 253402300799");if(r>l)throw new Error("Invalid timestampAfterThreshold: must be less than or equal to 253402300799");if(0!==n&&r>=n)throw new Error("Invalid thresholds: timestampBeforeThreshold must be greater than timestampAfterThreshold when both are specified");return i(`0x${c({value:r,size:16})}${c({value:n,size:16})}`,t)},r.createValueLteTerms=function(e,t=a){const{maxValue:r}=e;if(r<0n)throw new Error("Invalid maxValue: must be greater than or equal to zero");return i(c({value:r,size:32}),t)},r.decodeDelegations=function(e,t=a){const r=u.decodeSingle.call(void 0,h,e);return"bytes"===t.out?r.map(e=>p(e,o)):r.map(e=>p(e,s))},r.encodeDelegations=function(e,t=a){let r;if(0===e.length)r=new Uint8Array(64),r[31]=32;else{const t=e.map(e=>[e.delegate,e.delegator,e.authority,e.caveats.map(e=>[e.enforcer,e.terms,e.args]),e.salt,e.signature]);r=u.encodeSingle.call(void 0,h,t)}return i(r,t)},r.hashDelegation=function(e,t=a){const r=u.encode.call(void 0,["bytes32","address","address","bytes32","bytes32","uint256"],[f,e.delegate,e.delegator,e.authority,g(e.caveats),e.salt]);return i(d.keccak_256.call(void 0,r),t)}}}},{package:"@metamask/delegation-core",file:"node_modules/@metamask/delegation-core/dist/index.cjs"}],[1656,{"../../types/index.cjs":2002,"../AvatarBase/index.cjs":1661,"../temp-components/Blockies/index.cjs":1995,"../temp-components/Jazzicon/index.cjs":1997,"../temp-components/Maskicon/index.cjs":2e3,"./AvatarAccount.constants.cjs":1657,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarAccount=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs"),l=e("../temp-components/Blockies/index.cjs"),u=e("../temp-components/Jazzicon/index.cjs"),d=e("../temp-components/Maskicon/index.cjs"),f=e("./AvatarAccount.constants.cjs");r.AvatarAccount=(0,s.forwardRef)(({address:e,variant:t=o.AvatarAccountVariant.Jazzicon,className:r,size:n=o.AvatarAccountSize.Md,blockiesProps:a,jazziconProps:i,maskiconProps:m,...h},p)=>{let g;switch(t){case o.AvatarAccountVariant.Blockies:g=s.default.createElement(l.Blockies,{address:e,size:f.MAP_AVATARACCOUNT_SIZE_SIZENUMBER[n],...a});break;case o.AvatarAccountVariant.Maskicon:g=s.default.createElement(d.Maskicon,{address:e,size:f.MAP_AVATARACCOUNT_SIZE_SIZENUMBER[n],...m});break;case o.AvatarAccountVariant.Jazzicon:default:g=s.default.createElement(u.Jazzicon,{address:e,size:f.MAP_AVATARACCOUNT_SIZE_SIZENUMBER[n],...i})}return s.default.createElement(c.AvatarBase,{ref:p,shape:o.AvatarBaseShape.Square,size:n,className:r,...h},g)}),r.AvatarAccount.displayName="AvatarAccount"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.cjs"}],[1657,{"../../types/index.cjs":2002},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAP_AVATARACCOUNT_SIZE_SIZENUMBER=void 0;const n=e("../../types/index.cjs");r.MAP_AVATARACCOUNT_SIZE_SIZENUMBER={[n.AvatarAccountSize.Xs]:16,[n.AvatarAccountSize.Sm]:24,[n.AvatarAccountSize.Md]:32,[n.AvatarAccountSize.Lg]:40,[n.AvatarAccountSize.Xl]:48}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.constants.cjs"}],[1658,{"../../types/index.cjs":2002,"./AvatarAccount.cjs":1656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarAccount=r.AvatarAccountVariant=r.AvatarAccountSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"AvatarAccountSize",{enumerable:!0,get:function(){return n.AvatarAccountSize}}),Object.defineProperty(r,"AvatarAccountVariant",{enumerable:!0,get:function(){return n.AvatarAccountVariant}});var a=e("./AvatarAccount.cjs");Object.defineProperty(r,"AvatarAccount",{enumerable:!0,get:function(){return a.AvatarAccount}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarAccount/index.cjs"}],[1659,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"../Text/index.cjs":1989,"./AvatarBase.constants.cjs":1660,"@radix-ui/react-slot":2006,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarBase=void 0;const s=e("@radix-ui/react-slot"),o=i(e("react")),c=e("../../types/index.cjs"),l=e("../../utils/tw-merge.cjs"),u=e("../Text/index.cjs"),d=e("./AvatarBase.constants.cjs");r.AvatarBase=(0,o.forwardRef)(({children:e,fallbackText:t,fallbackTextProps:r,className:n,size:a=c.AvatarBaseSize.Md,shape:i=c.AvatarBaseShape.Circle,asChild:f,style:m,hasBorder:h=!1,...p},g)=>{const b=f?s.Slot:"div",y=(0,l.twMerge)("inline-flex shrink-0 items-center justify-center overflow-hidden bg-section",i===c.AvatarBaseShape.Circle?"rounded-full":d.TWCLASSMAP_AVATARBASE_SIZE_BORDERRADIUSS_SQUARE[a],h?d.TWCLASSMAP_AVATARBASE_HASBORDER_SIZE_DIMENSION[a]:d.TWCLASSMAP_AVATARBASE_SIZE_DIMENSION[a],h&&d.TWCLASSMAP_AVATARBASE_SIZE_BORDER[a],n);return o.default.createElement(b,{ref:g,className:y,style:m,...p},t?o.default.createElement(u.Text,{variant:u.TextVariant.BodySm,fontWeight:u.FontWeight.Medium,color:u.TextColor.TextMuted,asChild:!0,className:"uppercase",...r},o.default.createElement("span",null,t)):e)}),r.AvatarBase.displayName="AvatarBase"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.cjs"}],[1660,{"../../types/index.cjs":2002},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.TWCLASSMAP_AVATARBASE_SIZE_BORDER=r.TWCLASSMAP_AVATARBASE_SIZE_BORDERRADIUSS_SQUARE=r.TWCLASSMAP_AVATARBASE_HASBORDER_SIZE_DIMENSION=r.TWCLASSMAP_AVATARBASE_SIZE_DIMENSION=void 0;const n=e("../../types/index.cjs");r.TWCLASSMAP_AVATARBASE_SIZE_DIMENSION={[n.AvatarBaseSize.Xs]:"h-4 w-4",[n.AvatarBaseSize.Sm]:"h-6 w-6",[n.AvatarBaseSize.Md]:"h-8 w-8",[n.AvatarBaseSize.Lg]:"h-10 w-10",[n.AvatarBaseSize.Xl]:"h-12 w-12"},r.TWCLASSMAP_AVATARBASE_HASBORDER_SIZE_DIMENSION={[n.AvatarBaseSize.Xs]:"h-[18px] w-[18px]",[n.AvatarBaseSize.Sm]:"h-[26px] w-[26px]",[n.AvatarBaseSize.Md]:"h-[34px] w-[34px]",[n.AvatarBaseSize.Lg]:"h-[44px] w-[44px]",[n.AvatarBaseSize.Xl]:"h-[52px] w-[52px]"},r.TWCLASSMAP_AVATARBASE_SIZE_BORDERRADIUSS_SQUARE={[n.AvatarBaseSize.Xs]:"rounded-sm",[n.AvatarBaseSize.Sm]:"rounded-md",[n.AvatarBaseSize.Md]:"rounded-lg",[n.AvatarBaseSize.Lg]:"rounded-[10px]",[n.AvatarBaseSize.Xl]:"rounded-xl"},r.TWCLASSMAP_AVATARBASE_SIZE_BORDER={[n.AvatarBaseSize.Xs]:"border-background-default border",[n.AvatarBaseSize.Sm]:"border-background-default border",[n.AvatarBaseSize.Md]:"border-background-default border",[n.AvatarBaseSize.Lg]:"border-background-default border-2",[n.AvatarBaseSize.Xl]:"border-background-default border-2"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.constants.cjs"}],[1661,{"../../types/index.cjs":2002,"./AvatarBase.cjs":1659},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarBase=r.AvatarBaseShape=r.AvatarBaseSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"AvatarBaseSize",{enumerable:!0,get:function(){return n.AvatarBaseSize}}),Object.defineProperty(r,"AvatarBaseShape",{enumerable:!0,get:function(){return n.AvatarBaseShape}});var a=e("./AvatarBase.cjs");Object.defineProperty(r,"AvatarBase",{enumerable:!0,get:function(){return a.AvatarBase}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs"}],[1662,{"../../types/index.cjs":2002,"../AvatarBase/index.cjs":1661,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarFavicon=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs");r.AvatarFavicon=(0,s.forwardRef)(({src:e,name:t="",fallbackText:r,fallbackTextProps:n,className:a,size:i=o.AvatarFaviconSize.Md,imageProps:l,...u},d)=>{const[f,m]=(0,s.useState)(""),h=r||t?.[0]||"",p=t||"Dapp logo";return s.default.createElement(c.AvatarBase,{ref:d,shape:o.AvatarBaseShape.Circle,size:i,className:a,fallbackText:e?f:h,fallbackTextProps:n,...u},e&&s.default.createElement("img",{src:e,alt:p,className:"size-full object-contain",...l,onError:e=>{m(h),l?.onError?.(e)}}))}),r.AvatarFavicon.displayName="AvatarFavicon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/AvatarFavicon.cjs"}],[1663,{"../../types/index.cjs":2002,"./AvatarFavicon.cjs":1662},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarFavicon=r.AvatarFaviconSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"AvatarFaviconSize",{enumerable:!0,get:function(){return n.AvatarFaviconSize}});var a=e("./AvatarFavicon.cjs");Object.defineProperty(r,"AvatarFavicon",{enumerable:!0,get:function(){return a.AvatarFavicon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/index.cjs"}],[1664,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"../AvatarAccount/index.cjs":1658,"../AvatarBase/index.cjs":1661,"../AvatarFavicon/index.cjs":1663,"../AvatarNetwork/index.cjs":1671,"../AvatarToken/index.cjs":1673,"../Text/index.cjs":1989,"./AvatarGroup.constants.cjs":1665,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarGroup=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),l=e("../AvatarAccount/index.cjs"),u=e("../AvatarBase/index.cjs"),d=e("../AvatarFavicon/index.cjs"),f=e("../AvatarNetwork/index.cjs"),m=e("../AvatarToken/index.cjs"),h=e("../Text/index.cjs"),p=e("./AvatarGroup.constants.cjs");r.AvatarGroup=(0,s.forwardRef)(({variant:e,avatarPropsArr:t,size:r=o.AvatarGroupSize.Md,max:n=4,isReverse:a=!1,overflowTextProps:i,style:g,className:b,...y},v)=>{const w=t.length-n,_=w>0,j=a?p.AVATAR_GROUP_SIZE_ISREVERSE_NEGATIVESPACEBETWEENAVATARS_MAP[r]:p.AVATAR_GROUP_SIZE_NEGATIVESPACEBETWEENAVATARS_MAP[r],O=(0,c.twMerge)("inline-flex",a?"flex-row-reverse":"flex-row",b),E=(0,c.twMerge)("flex",a?"flex-row-reverse":"flex-row"),C=(0,c.twMerge)("bg-icon-default",j),k=(0,s.useCallback)(()=>t.slice(0,n).map((t,n)=>{switch(e){case o.AvatarGroupVariant.Account:return s.default.createElement(l.AvatarAccount,{hasBorder:!0,key:`avatar-${n}`,...t,size:r,className:`${n>0&&j} ${t.className}`,style:{zIndex:n+1,...t.style}});case o.AvatarGroupVariant.Favicon:return s.default.createElement(d.AvatarFavicon,{hasBorder:!0,key:`avatar-${n}`,...t,size:r,className:`${n>0&&j} ${t.className}`,style:{zIndex:n+1,...t.style}});case o.AvatarGroupVariant.Network:return s.default.createElement(f.AvatarNetwork,{hasBorder:!0,key:`avatar-${n}`,...t,size:r,className:`${n>0&&j} ${t.className}`,style:{zIndex:n+1,...t.style}});case o.AvatarGroupVariant.Token:return s.default.createElement(m.AvatarToken,{hasBorder:!0,key:`avatar-${n}`,...t,size:r,className:`${n>0&&j} ${t.className}`,style:{zIndex:n+1,...t.style}});default:throw new Error(`Invalid Avatar Variant: ${String(e)}. Expected one of: ${Object.values(o.AvatarGroupVariant).join(", ")}`)}}),[t,n,r]);return s.default.createElement("div",{ref:v,...y,style:g,className:O},s.default.createElement("div",{className:E},k()),_&&s.default.createElement(u.AvatarBase,{className:C,style:{zIndex:t.length},hasBorder:!0,fallbackText:`+${w}`,fallbackTextProps:{variant:p.AVATAR_GROUP_SIZE_OVERFLOWTEXT_TEXTVARIANT_MAP[r],color:h.TextColor.PrimaryInverse},size:r,shape:e===o.AvatarGroupVariant.Network?u.AvatarBaseShape.Square:u.AvatarBaseShape.Circle,...i}))})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.cjs"}],[1665,{"../../types/index.cjs":2002,"../Text/index.cjs":1989},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AVATAR_GROUP_SIZE_OVERFLOWTEXT_TEXTVARIANT_MAP=r.AVATAR_GROUP_SIZE_ISREVERSE_NEGATIVESPACEBETWEENAVATARS_MAP=r.AVATAR_GROUP_SIZE_NEGATIVESPACEBETWEENAVATARS_MAP=void 0;const n=e("../../types/index.cjs"),a=e("../Text/index.cjs");r.AVATAR_GROUP_SIZE_NEGATIVESPACEBETWEENAVATARS_MAP={[n.AvatarGroupSize.Xs]:"ml-[-6px]",[n.AvatarGroupSize.Sm]:"ml-[-10px]",[n.AvatarGroupSize.Md]:"ml-[-14px]",[n.AvatarGroupSize.Lg]:"ml-[-18px]",[n.AvatarGroupSize.Xl]:"ml-[-22px]"},r.AVATAR_GROUP_SIZE_ISREVERSE_NEGATIVESPACEBETWEENAVATARS_MAP={[n.AvatarGroupSize.Xs]:"mr-[-6px]",[n.AvatarGroupSize.Sm]:"mr-[-10px]",[n.AvatarGroupSize.Md]:"mr-[-14px]",[n.AvatarGroupSize.Lg]:"mr-[-18px]",[n.AvatarGroupSize.Xl]:"mr-[-22px]"},r.AVATAR_GROUP_SIZE_OVERFLOWTEXT_TEXTVARIANT_MAP={[n.AvatarGroupSize.Xs]:a.TextVariant.BodyXs,[n.AvatarGroupSize.Sm]:a.TextVariant.BodySm,[n.AvatarGroupSize.Md]:a.TextVariant.BodyMd,[n.AvatarGroupSize.Lg]:a.TextVariant.HeadingMd,[n.AvatarGroupSize.Xl]:a.TextVariant.HeadingMd}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.constants.cjs"}],[1666,{"../../types/index.cjs":2002,"./AvatarGroup.cjs":1664},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarGroup=r.AvatarGroupVariant=r.AvatarGroupSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"AvatarGroupSize",{enumerable:!0,get:function(){return n.AvatarGroupSize}}),Object.defineProperty(r,"AvatarGroupVariant",{enumerable:!0,get:function(){return n.AvatarGroupVariant}});var a=e("./AvatarGroup.cjs");Object.defineProperty(r,"AvatarGroup",{enumerable:!0,get:function(){return a.AvatarGroup}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarGroup/index.cjs"}],[1667,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"../AvatarBase/index.cjs":1661,"../Icon/index.cjs":1986,"./AvatarIcon.constants.cjs":1668,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarIcon=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),l=e("../AvatarBase/index.cjs"),u=e("../Icon/index.cjs"),d=e("./AvatarIcon.constants.cjs");r.AvatarIcon=(0,s.forwardRef)(({iconName:e,iconProps:t,size:r=o.AvatarIconSize.Md,severity:n=o.AvatarIconSeverity.Neutral,className:a,...i},f)=>s.default.createElement(l.AvatarBase,{ref:f,shape:l.AvatarBaseShape.Circle,size:r,className:(0,c.twMerge)(d.TWCLASSMAP_AVATARICON_SEVERITY_BACKGROUNDCOLOR[n],a),...i},e&&s.default.createElement(u.Icon,{name:e,size:d.MAP_AVATARICON_SIZE_ICONSIZE[r],color:d.MAP_AVATARICON_SEVERITY_ICONCOLOR[n],...t}))),r.AvatarIcon.displayName="AvatarIcon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.cjs"}],[1668,{"../../types/index.cjs":2002,"../Icon/index.cjs":1986},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAP_AVATARICON_SEVERITY_ICONCOLOR=r.TWCLASSMAP_AVATARICON_SEVERITY_BACKGROUNDCOLOR=r.MAP_AVATARICON_SIZE_ICONSIZE=void 0;const n=e("../../types/index.cjs"),a=e("../Icon/index.cjs");r.MAP_AVATARICON_SIZE_ICONSIZE={[n.AvatarIconSize.Xs]:a.IconSize.Xs,[n.AvatarIconSize.Sm]:a.IconSize.Sm,[n.AvatarIconSize.Md]:a.IconSize.Md,[n.AvatarIconSize.Lg]:a.IconSize.Lg,[n.AvatarIconSize.Xl]:a.IconSize.Xl},r.TWCLASSMAP_AVATARICON_SEVERITY_BACKGROUNDCOLOR={[n.AvatarIconSeverity.Neutral]:"bg-muted",[n.AvatarIconSeverity.Info]:"bg-info-muted",[n.AvatarIconSeverity.Success]:"bg-success-muted",[n.AvatarIconSeverity.Error]:"bg-error-muted",[n.AvatarIconSeverity.Warning]:"bg-warning-muted"},r.MAP_AVATARICON_SEVERITY_ICONCOLOR={[n.AvatarIconSeverity.Neutral]:a.IconColor.IconAlternative,[n.AvatarIconSeverity.Info]:a.IconColor.InfoDefault,[n.AvatarIconSeverity.Success]:a.IconColor.SuccessDefault,[n.AvatarIconSeverity.Error]:a.IconColor.ErrorDefault,[n.AvatarIconSeverity.Warning]:a.IconColor.WarningDefault}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.constants.cjs"}],[1669,{"../../types/index.cjs":2002,"./AvatarIcon.cjs":1667},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarIcon=r.AvatarIconSeverity=r.AvatarIconSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"AvatarIconSize",{enumerable:!0,get:function(){return n.AvatarIconSize}}),Object.defineProperty(r,"AvatarIconSeverity",{enumerable:!0,get:function(){return n.AvatarIconSeverity}});var a=e("./AvatarIcon.cjs");Object.defineProperty(r,"AvatarIcon",{enumerable:!0,get:function(){return a.AvatarIcon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarIcon/index.cjs"}],[1670,{"../../types/index.cjs":2002,"../AvatarBase/index.cjs":1661,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarNetwork=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs");r.AvatarNetwork=(0,s.forwardRef)(({src:e,name:t="",fallbackText:r,fallbackTextProps:n,className:a,size:i=o.AvatarNetworkSize.Md,imageProps:l,...u},d)=>{const[f,m]=(0,s.useState)(""),h=r||t?.[0]||"",p=t||"Network logo";return s.default.createElement(c.AvatarBase,{ref:d,shape:o.AvatarBaseShape.Square,size:i,className:a,fallbackText:e?f:h,fallbackTextProps:n,...u},e&&s.default.createElement("img",{src:e,alt:p,className:"size-full object-contain",...l,onError:e=>{m(h),l?.onError?.(e)}}))}),r.AvatarNetwork.displayName="AvatarNetwork"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/AvatarNetwork.cjs"}],[1671,{"../../types/index.cjs":2002,"./AvatarNetwork.cjs":1670},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarNetwork=r.AvatarNetworkSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"AvatarNetworkSize",{enumerable:!0,get:function(){return n.AvatarNetworkSize}});var a=e("./AvatarNetwork.cjs");Object.defineProperty(r,"AvatarNetwork",{enumerable:!0,get:function(){return a.AvatarNetwork}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/index.cjs"}],[1672,{"../../types/index.cjs":2002,"../AvatarBase/index.cjs":1661,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarToken=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs");r.AvatarToken=(0,s.forwardRef)(({src:e,name:t="",fallbackText:r,fallbackTextProps:n,className:a,size:i=o.AvatarTokenSize.Md,imageProps:l,...u},d)=>{const[f,m]=(0,s.useState)(""),h=r||t?.[0]||"",p=t||"Token logo";return s.default.createElement(c.AvatarBase,{ref:d,shape:o.AvatarBaseShape.Circle,size:i,className:a,fallbackText:e?f:h,fallbackTextProps:n,...u},e&&s.default.createElement("img",{src:e,alt:p,className:"size-full object-contain",onError:e=>{m(h),l?.onError?.(e)},...l}))}),r.AvatarToken.displayName="AvatarToken"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarToken/AvatarToken.cjs"}],[1673,{"../../types/index.cjs":2002,"./AvatarToken.cjs":1672},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AvatarToken=r.AvatarTokenSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"AvatarTokenSize",{enumerable:!0,get:function(){return n.AvatarTokenSize}});var a=e("./AvatarToken.cjs");Object.defineProperty(r,"AvatarToken",{enumerable:!0,get:function(){return a.AvatarToken}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarToken/index.cjs"}],[1674,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"../Text/index.cjs":1989,"./BadgeCount.constants.cjs":1675,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeCount=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),l=e("../Text/index.cjs"),u=e("./BadgeCount.constants.cjs");r.BadgeCount=(0,s.forwardRef)(({size:e=o.BadgeCountSize.Md,count:t,max:r=99,textProps:n,className:a="",style:i,...d},f)=>{const m=(0,c.twMerge)("inline-flex items-center justify-center self-start rounded-lg bg-error-default",u.TWCLASSMAP_BADGECOUNT_SIZE_CONTAINER[e],a);return s.default.createElement("div",{ref:f,className:m,style:i,...d},s.default.createElement(l.Text,{variant:u.MAP_BADGECOUNT_SIZE_TEXTVARIANT[e],color:l.TextColor.ErrorInverse,fontWeight:l.FontWeight.Medium,...n,className:`${n?.className||""}`,asChild:!0},s.default.createElement("span",null,t>r?`${r}+`:`${t}`)))}),r.BadgeCount.displayName="BadgeCount"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.cjs"}],[1675,{"../../types/index.cjs":2002,"../Text/index.cjs":1989},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.TWCLASSMAP_BADGECOUNT_SIZE_CONTAINER=r.MAP_BADGECOUNT_SIZE_TEXTVARIANT=void 0;const n=e("../../types/index.cjs"),a=e("../Text/index.cjs");r.MAP_BADGECOUNT_SIZE_TEXTVARIANT={[n.BadgeCountSize.Md]:a.TextVariant.BodyXs,[n.BadgeCountSize.Lg]:a.TextVariant.BodySm},r.TWCLASSMAP_BADGECOUNT_SIZE_CONTAINER={[n.BadgeCountSize.Md]:"min-w-4 h-3.5 py-0 px-1",[n.BadgeCountSize.Lg]:"min-w-6 h-5 py-0.5 px-1.5"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.constants.cjs"}],[1676,{"../../types/index.cjs":2002,"./BadgeCount.cjs":1674},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeCount=r.BadgeCountSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"BadgeCountSize",{enumerable:!0,get:function(){return n.BadgeCountSize}});var a=e("./BadgeCount.cjs");Object.defineProperty(r,"BadgeCount",{enumerable:!0,get:function(){return a.BadgeCount}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeCount/index.cjs"}],[1677,{"../../utils/tw-merge.cjs":2004,"../Icon/index.cjs":1986,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeIcon=void 0;const s=i(e("react")),o=e("../../utils/tw-merge.cjs"),c=e("../Icon/index.cjs");r.BadgeIcon=(0,s.forwardRef)(({iconName:e,iconProps:t,className:r="",style:n,...a},i)=>{const l=(0,o.twMerge)("inline-flex size-4 items-center justify-center rounded-full bg-icon-default",r);return s.default.createElement("div",{ref:i,className:l,style:n,...a},s.default.createElement(c.Icon,{size:c.IconSize.Xs,name:e,...t,className:(0,o.twMerge)(t?.color?"":"text-background-default",t?.className)}))}),r.BadgeIcon.displayName="BadgeIcon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeIcon/BadgeIcon.cjs"}],[1678,{"./BadgeIcon.cjs":1677},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeIcon=void 0;var n=e("./BadgeIcon.cjs");Object.defineProperty(r,"BadgeIcon",{enumerable:!0,get:function(){return n.BadgeIcon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeIcon/index.cjs"}],[1679,{"../AvatarNetwork/index.cjs":1671,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeNetwork=void 0;const s=i(e("react")),o=e("../AvatarNetwork/index.cjs");r.BadgeNetwork=(0,s.forwardRef)(({name:e,src:t,fallbackText:r,...n},a)=>s.default.createElement(o.AvatarNetwork,{name:e,src:t,fallbackText:r,ref:a,...n,size:o.AvatarNetworkSize.Xs,hasBorder:!0})),r.BadgeNetwork.displayName="BadgeNetwork"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/BadgeNetwork.cjs"}],[1680,{"./BadgeNetwork.cjs":1679},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeNetwork=void 0;var n=e("./BadgeNetwork.cjs");Object.defineProperty(r,"BadgeNetwork",{enumerable:!0,get:function(){return n.BadgeNetwork}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/index.cjs"}],[1681,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"./BadgeStatus.constants.cjs":1682,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeStatus=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),l=e("./BadgeStatus.constants.cjs");r.BadgeStatus=(0,s.forwardRef)(({status:e,size:t=o.BadgeStatusSize.Md,hasBorder:r=!0,className:n,style:a,...i},u)=>{const d=(0,c.twMerge)("inline-flex rounded-full",r?"border-2 border-background-default":"",n),f=(0,c.twMerge)("z-10 rounded-full border-2",l.CLASSMAP_BADGESTATUS_SIZE[t],l.CLASSMAP_BADGESTATUS_STATUS_CIRCLE[e]);return s.default.createElement("div",{ref:u,className:d,style:a,...i},s.default.createElement("div",{className:f}))}),r.BadgeStatus.displayName="BadgeStatus"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.cjs"}],[1682,{"../../types/index.cjs":2002},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.CLASSMAP_BADGESTATUS_SIZE=r.CLASSMAP_BADGESTATUS_STATUS_CIRCLE=void 0;const n=e("../../types/index.cjs");r.CLASSMAP_BADGESTATUS_STATUS_CIRCLE={[n.BadgeStatusStatus.Active]:"bg-success-default border-success-default",[n.BadgeStatusStatus.Inactive]:"bg-default border-success-default",[n.BadgeStatusStatus.Disconnected]:"bg-icon-muted border-icon-muted",[n.BadgeStatusStatus.New]:"bg-primary-default border-primary-default",[n.BadgeStatusStatus.Attention]:"bg-error-default border-error-default"},r.CLASSMAP_BADGESTATUS_SIZE={[n.BadgeStatusSize.Md]:"h-2 w-2",[n.BadgeStatusSize.Lg]:"h-2.5 w-2.5"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.constants.cjs"}],[1683,{"../../types/index.cjs":2002,"./BadgeStatus.cjs":1681},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeStatus=r.BadgeStatusStatus=r.BadgeStatusSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"BadgeStatusSize",{enumerable:!0,get:function(){return n.BadgeStatusSize}}),Object.defineProperty(r,"BadgeStatusStatus",{enumerable:!0,get:function(){return n.BadgeStatusStatus}});var a=e("./BadgeStatus.cjs");Object.defineProperty(r,"BadgeStatus",{enumerable:!0,get:function(){return a.BadgeStatus}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeStatus/index.cjs"}],[1684,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeWrapper=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs");r.BadgeWrapper=(0,s.forwardRef)(({children:e,childrenContainerProps:t,badge:r,badgeContainerProps:n,position:a=o.BadgeWrapperPosition.BottomRight,positionAnchorShape:i=o.BadgeWrapperPositionAnchorShape.Circular,positionXOffset:l=0,positionYOffset:u=0,customPosition:d,className:f="",style:m,...h},p)=>{const[g,b]=(0,s.useState)(0),[y,v]=(0,s.useState)(0),[w,_]=(0,s.useState)(0),[j,O]=(0,s.useState)(0),E=(0,s.useRef)(null),C=(0,s.useRef)(null);(0,s.useLayoutEffect)(()=>{if(E.current){const{width:e,height:t}=E.current.getBoundingClientRect();b(e),v(t)}if(C.current){const{width:e,height:t}=C.current.getBoundingClientRect();_(e),O(t)}},[]);const k=(0,s.useMemo)(()=>{if(d)return d;const e=i===o.BadgeWrapperPositionAnchorShape.Rectangular?0:.1464*g,t=i===o.BadgeWrapperPositionAnchorShape.Rectangular?0:.1464*y,r=e-w/2+l,n=t-j/2+u;switch(a){case o.BadgeWrapperPosition.TopRight:return{top:n,right:r};case o.BadgeWrapperPosition.TopLeft:return{top:n,left:r};case o.BadgeWrapperPosition.BottomLeft:return{bottom:n,left:r};case o.BadgeWrapperPosition.BottomRight:default:return{bottom:n,right:r}}},[a,i,g,y,w,j,l,u,d]),x=(0,c.twMerge)("relative inline-flex self-start",f);return s.default.createElement("div",{ref:p,className:x,style:m,...h},s.default.createElement("div",{className:"inline-flex",ref:E,...t},e),s.default.createElement("div",{ref:C,className:"absolute",style:k,...n},r))}),r.BadgeWrapper.displayName="BadgeWrapper"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/BadgeWrapper.cjs"}],[1685,{"../../types/index.cjs":2002,"./BadgeWrapper.cjs":1684},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BadgeWrapper=r.BadgeWrapperPositionAnchorShape=r.BadgeWrapperPosition=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"BadgeWrapperPosition",{enumerable:!0,get:function(){return n.BadgeWrapperPosition}}),Object.defineProperty(r,"BadgeWrapperPositionAnchorShape",{enumerable:!0,get:function(){return n.BadgeWrapperPositionAnchorShape}});var a=e("./BadgeWrapper.cjs");Object.defineProperty(r,"BadgeWrapper",{enumerable:!0,get:function(){return a.BadgeWrapper}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/index.cjs"}],[1686,{"../../utils/tw-merge.cjs":2004,"./Box.constants.cjs":1687,"@radix-ui/react-slot":2006,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.Box=void 0;const s=e("@radix-ui/react-slot"),o=i(e("react")),c=e("../../utils/tw-merge.cjs"),l=e("./Box.constants.cjs");r.Box=(0,o.forwardRef)(({flexDirection:e,flexWrap:t,gap:r,alignItems:n,justifyContent:a,margin:i,marginTop:u,marginRight:d,marginBottom:f,marginLeft:m,marginHorizontal:h,marginVertical:p,padding:g,paddingTop:b,paddingRight:y,paddingBottom:v,paddingLeft:w,paddingHorizontal:_,paddingVertical:j,borderWidth:O,borderColor:E,backgroundColor:C,className:k="",style:x,asChild:T,children:A,...P},B)=>{const S=T?s.Slot:"div",M=(0,c.twMerge)(e?"flex":"",e,t,r!==undefined?l.TWCLASSMAP_BOX_GAP[r]:"",n,a,i!==undefined?l.TWCLASSMAP_BOX_MARGIN[i]:"",u!==undefined?l.TWCLASSMAP_BOX_MARGIN_TOP[u]:"",d!==undefined?l.TWCLASSMAP_BOX_MARGIN_RIGHT[d]:"",f!==undefined?l.TWCLASSMAP_BOX_MARGIN_BOTTOM[f]:"",m!==undefined?l.TWCLASSMAP_BOX_MARGIN_LEFT[m]:"",h!==undefined?l.TWCLASSMAP_BOX_MARGIN_HORIZONTAL[h]:"",p!==undefined?l.TWCLASSMAP_BOX_MARGIN_VERTICAL[p]:"",g!==undefined?l.TWCLASSMAP_BOX_PADDING[g]:"",b!==undefined?l.TWCLASSMAP_BOX_PADDING_TOP[b]:"",y!==undefined?l.TWCLASSMAP_BOX_PADDING_RIGHT[y]:"",v!==undefined?l.TWCLASSMAP_BOX_PADDING_BOTTOM[v]:"",w!==undefined?l.TWCLASSMAP_BOX_PADDING_LEFT[w]:"",_!==undefined?l.TWCLASSMAP_BOX_PADDING_HORIZONTAL[_]:"",j!==undefined?l.TWCLASSMAP_BOX_PADDING_VERTICAL[j]:"",O!==undefined?l.TWCLASSMAP_BOX_BORDER_WIDTH[O]:"",E,C,k);return o.default.createElement(S,{ref:B,className:M,style:x,...P},A)}),r.Box.displayName="Box"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Box/Box.cjs"}],[1687,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.TWCLASSMAP_BOX_BORDER_WIDTH=r.TWCLASSMAP_BOX_PADDING_VERTICAL=r.TWCLASSMAP_BOX_PADDING_HORIZONTAL=r.TWCLASSMAP_BOX_PADDING_LEFT=r.TWCLASSMAP_BOX_PADDING_BOTTOM=r.TWCLASSMAP_BOX_PADDING_RIGHT=r.TWCLASSMAP_BOX_PADDING_TOP=r.TWCLASSMAP_BOX_PADDING=r.TWCLASSMAP_BOX_MARGIN_VERTICAL=r.TWCLASSMAP_BOX_MARGIN_HORIZONTAL=r.TWCLASSMAP_BOX_MARGIN_LEFT=r.TWCLASSMAP_BOX_MARGIN_BOTTOM=r.TWCLASSMAP_BOX_MARGIN_RIGHT=r.TWCLASSMAP_BOX_MARGIN_TOP=r.TWCLASSMAP_BOX_MARGIN=r.TWCLASSMAP_BOX_GAP=void 0,r.TWCLASSMAP_BOX_GAP={0:"gap-0",1:"gap-1",2:"gap-2",3:"gap-3",4:"gap-4",5:"gap-5",6:"gap-6",7:"gap-7",8:"gap-8",9:"gap-9",10:"gap-10",11:"gap-11",12:"gap-12"},r.TWCLASSMAP_BOX_MARGIN={0:"m-0",1:"m-1",2:"m-2",3:"m-3",4:"m-4",5:"m-5",6:"m-6",7:"m-7",8:"m-8",9:"m-9",10:"m-10",11:"m-11",12:"m-12"},r.TWCLASSMAP_BOX_MARGIN_TOP={0:"mt-0",1:"mt-1",2:"mt-2",3:"mt-3",4:"mt-4",5:"mt-5",6:"mt-6",7:"mt-7",8:"mt-8",9:"mt-9",10:"mt-10",11:"mt-11",12:"mt-12"},r.TWCLASSMAP_BOX_MARGIN_RIGHT={0:"mr-0",1:"mr-1",2:"mr-2",3:"mr-3",4:"mr-4",5:"mr-5",6:"mr-6",7:"mr-7",8:"mr-8",9:"mr-9",10:"mr-10",11:"mr-11",12:"mr-12"},r.TWCLASSMAP_BOX_MARGIN_BOTTOM={0:"mb-0",1:"mb-1",2:"mb-2",3:"mb-3",4:"mb-4",5:"mb-5",6:"mb-6",7:"mb-7",8:"mb-8",9:"mb-9",10:"mb-10",11:"mb-11",12:"mb-12"},r.TWCLASSMAP_BOX_MARGIN_LEFT={0:"ml-0",1:"ml-1",2:"ml-2",3:"ml-3",4:"ml-4",5:"ml-5",6:"ml-6",7:"ml-7",8:"ml-8",9:"ml-9",10:"ml-10",11:"ml-11",12:"ml-12"},r.TWCLASSMAP_BOX_MARGIN_HORIZONTAL={0:"mx-0",1:"mx-1",2:"mx-2",3:"mx-3",4:"mx-4",5:"mx-5",6:"mx-6",7:"mx-7",8:"mx-8",9:"mx-9",10:"mx-10",11:"mx-11",12:"mx-12"},r.TWCLASSMAP_BOX_MARGIN_VERTICAL={0:"my-0",1:"my-1",2:"my-2",3:"my-3",4:"my-4",5:"my-5",6:"my-6",7:"my-7",8:"my-8",9:"my-9",10:"my-10",11:"my-11",12:"my-12"},r.TWCLASSMAP_BOX_PADDING={0:"p-0",1:"p-1",2:"p-2",3:"p-3",4:"p-4",5:"p-5",6:"p-6",7:"p-7",8:"p-8",9:"p-9",10:"p-10",11:"p-11",12:"p-12"},r.TWCLASSMAP_BOX_PADDING_TOP={0:"pt-0",1:"pt-1",2:"pt-2",3:"pt-3",4:"pt-4",5:"pt-5",6:"pt-6",7:"pt-7",8:"pt-8",9:"pt-9",10:"pt-10",11:"pt-11",12:"pt-12"},r.TWCLASSMAP_BOX_PADDING_RIGHT={0:"pr-0",1:"pr-1",2:"pr-2",3:"pr-3",4:"pr-4",5:"pr-5",6:"pr-6",7:"pr-7",8:"pr-8",9:"pr-9",10:"pr-10",11:"pr-11",12:"pr-12"},r.TWCLASSMAP_BOX_PADDING_BOTTOM={0:"pb-0",1:"pb-1",2:"pb-2",3:"pb-3",4:"pb-4",5:"pb-5",6:"pb-6",7:"pb-7",8:"pb-8",9:"pb-9",10:"pb-10",11:"pb-11",12:"pb-12"},r.TWCLASSMAP_BOX_PADDING_LEFT={0:"pl-0",1:"pl-1",2:"pl-2",3:"pl-3",4:"pl-4",5:"pl-5",6:"pl-6",7:"pl-7",8:"pl-8",9:"pl-9",10:"pl-10",11:"pl-11",12:"pl-12"},r.TWCLASSMAP_BOX_PADDING_HORIZONTAL={0:"px-0",1:"px-1",2:"px-2",3:"px-3",4:"px-4",5:"px-5",6:"px-6",7:"px-7",8:"px-8",9:"px-9",10:"px-10",11:"px-11",12:"px-12"},r.TWCLASSMAP_BOX_PADDING_VERTICAL={0:"py-0",1:"py-1",2:"py-2",3:"py-3",4:"py-4",5:"py-5",6:"py-6",7:"py-7",8:"py-8",9:"py-9",10:"py-10",11:"py-11",12:"py-12"},r.TWCLASSMAP_BOX_BORDER_WIDTH={0:"border-0",1:"border",2:"border-2",4:"border-4",8:"border-8"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Box/Box.constants.cjs"}],[1688,{"../../types/index.cjs":2002,"./Box.cjs":1686},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Box=r.BoxBorderColor=r.BoxBackgroundColor=r.BoxJustifyContent=r.BoxAlignItems=r.BoxFlexWrap=r.BoxFlexDirection=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"BoxFlexDirection",{enumerable:!0,get:function(){return n.BoxFlexDirection}}),Object.defineProperty(r,"BoxFlexWrap",{enumerable:!0,get:function(){return n.BoxFlexWrap}}),Object.defineProperty(r,"BoxAlignItems",{enumerable:!0,get:function(){return n.BoxAlignItems}}),Object.defineProperty(r,"BoxJustifyContent",{enumerable:!0,get:function(){return n.BoxJustifyContent}}),Object.defineProperty(r,"BoxBackgroundColor",{enumerable:!0,get:function(){return n.BoxBackgroundColor}}),Object.defineProperty(r,"BoxBorderColor",{enumerable:!0,get:function(){return n.BoxBorderColor}});var a=e("./Box.cjs");Object.defineProperty(r,"Box",{enumerable:!0,get:function(){return a.Box}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Box/index.cjs"}],[1689,{"../../types/index.cjs":2002,"./variants/ButtonPrimary/index.cjs":1692,"./variants/ButtonSecondary/index.cjs":1694,"./variants/ButtonTertiary/index.cjs":1696,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.Button=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("./variants/ButtonPrimary/index.cjs"),l=e("./variants/ButtonSecondary/index.cjs"),u=e("./variants/ButtonTertiary/index.cjs");r.Button=(0,s.forwardRef)(({variant:e=o.ButtonVariant.Primary,...t},r)=>{switch(e){case o.ButtonVariant.Primary:return s.default.createElement(c.ButtonPrimary,{ref:r,...t});case o.ButtonVariant.Secondary:return s.default.createElement(l.ButtonSecondary,{ref:r,...t});case o.ButtonVariant.Tertiary:return s.default.createElement(u.ButtonTertiary,{ref:r,...t});default:return s.default.createElement(c.ButtonPrimary,{ref:r,...t})}}),r.Button.displayName="Button"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/Button.cjs"}],[1690,{"../../types/index.cjs":2002,"./Button.cjs":1689},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Button=r.ButtonSize=r.ButtonVariant=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"ButtonVariant",{enumerable:!0,get:function(){return n.ButtonVariant}}),Object.defineProperty(r,"ButtonSize",{enumerable:!0,get:function(){return n.ButtonSize}});var a=e("./Button.cjs");Object.defineProperty(r,"Button",{enumerable:!0,get:function(){return a.Button}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/index.cjs"}],[1691,{"../../../../utils/tw-merge.cjs":2004,"../../../ButtonBase/index.cjs":1699,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonPrimary=void 0;const s=i(e("react")),o=e("../../../../utils/tw-merge.cjs"),c=e("../../../ButtonBase/index.cjs");r.ButtonPrimary=(0,s.forwardRef)(({className:e,isDanger:t,isInverse:r,isDisabled:n,isLoading:a,...i},l)=>{const u=!(n??a),d=(0,o.twMerge)(!t&&!r&&["bg-icon-default text-primary-inverse",a&&"bg-icon-default-pressed"],t&&!r&&["bg-error-default text-error-inverse",a&&"bg-error-default-pressed"],r&&!t&&["bg-default text-default",a&&"bg-default-pressed"],r&&t&&["bg-default text-error-default",a&&"bg-default-pressed"],u&&[!t&&!r&&["hover:bg-icon-default-hover","active:bg-icon-default-pressed"],t&&!r&&["hover:bg-error-default-hover","active:bg-error-default-pressed"],r&&!t&&["hover:bg-default-hover","active:bg-default-pressed"],r&&t&&["hover:bg-default-hover","active:bg-default-pressed"]],"focus-visible:outline-none focus-visible:ring-0",r?"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-4 focus-visible:outline-background-default":"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-default",a&&"cursor-not-allowed",n&&!a&&["opacity-50","cursor-not-allowed"],e);return s.default.createElement(c.ButtonBase,{ref:l,className:d,isDisabled:n,isLoading:a,...i})}),r.ButtonPrimary.displayName="ButtonPrimary"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/ButtonPrimary.cjs"}],[1692,{"../../../../types/index.cjs":2002,"./ButtonPrimary.cjs":1691},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonPrimary=r.ButtonPrimarySize=void 0;var n=e("../../../../types/index.cjs");Object.defineProperty(r,"ButtonPrimarySize",{enumerable:!0,get:function(){return n.ButtonPrimarySize}});var a=e("./ButtonPrimary.cjs");Object.defineProperty(r,"ButtonPrimary",{enumerable:!0,get:function(){return a.ButtonPrimary}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/index.cjs"}],[1693,{"../../../../utils/tw-merge.cjs":2004,"../../../ButtonBase/index.cjs":1699,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonSecondary=void 0;const s=i(e("react")),o=e("../../../../utils/tw-merge.cjs"),c=e("../../../ButtonBase/index.cjs");r.ButtonSecondary=(0,s.forwardRef)(({className:e,isDanger:t,isInverse:r,isDisabled:n,isLoading:a,...i},l)=>{const u=!(n??a),d=(0,o.twMerge)(!t&&!r&&["bg-muted text-default",a&&"bg-muted-pressed"],t&&!r&&["bg-muted text-error-default",a&&"bg-muted-pressed"],r&&!t&&["border-2 border-primary-inverse bg-transparent text-primary-inverse",a&&"bg-pressed"],r&&t&&["border-0 bg-default text-error-default",a&&"bg-default-pressed"],u&&[!t&&!r&&["hover:bg-muted-hover","active:bg-muted-pressed"],t&&!r&&["hover:bg-muted-hover","active:bg-muted-pressed"],r&&!t&&["hover:bg-hover","active:bg-pressed"],r&&t&&["hover:bg-default-hover","active:bg-default-pressed"]],"focus-visible:outline-none focus-visible:ring-0",r?"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-4 focus-visible:outline-background-default":"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-default",a&&"cursor-not-allowed",n&&!a&&["opacity-50","cursor-not-allowed"],e);return s.default.createElement(c.ButtonBase,{ref:l,className:d,isDisabled:n,isLoading:a,...i})}),r.ButtonSecondary.displayName="ButtonSecondary"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/ButtonSecondary.cjs"}],[1694,{"../../../../types/index.cjs":2002,"./ButtonSecondary.cjs":1693},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonSecondary=r.ButtonSecondarySize=void 0;var n=e("../../../../types/index.cjs");Object.defineProperty(r,"ButtonSecondarySize",{enumerable:!0,get:function(){return n.ButtonSecondarySize}});var a=e("./ButtonSecondary.cjs");Object.defineProperty(r,"ButtonSecondary",{enumerable:!0,get:function(){return a.ButtonSecondary}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/index.cjs"}],[1695,{"../../../../utils/tw-merge.cjs":2004,"../../../ButtonBase/index.cjs":1699,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonTertiary=void 0;const s=i(e("react")),o=e("../../../../utils/tw-merge.cjs"),c=e("../../../ButtonBase/index.cjs");r.ButtonTertiary=(0,s.forwardRef)(({className:e,isDanger:t,isInverse:r,isDisabled:n,isLoading:a,...i},l)=>{const u=!(n??a),d=(0,o.twMerge)(!t&&!r&&["bg-transparent text-primary-default",a&&"bg-pressed"],t&&!r&&["bg-transparent text-error-default",a&&"bg-error-muted-pressed text-error-default-pressed"],r&&!t&&["bg-transparent text-primary-inverse",a&&"bg-pressed"],r&&t&&["bg-default text-error-default",a&&"bg-default-pressed"],u&&["hover:bg-hover","active:bg-pressed",r&&t&&["hover:bg-default-hover","active:bg-default-pressed"],t&&!r&&["hover:bg-error-muted-hover","active:bg-error-muted-pressed"]],"focus-visible:outline-none focus-visible:ring-0",r?"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-4 focus-visible:outline-background-default":"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-default",a&&"cursor-not-allowed",n&&!a&&["opacity-50","cursor-not-allowed"],e);return s.default.createElement(c.ButtonBase,{ref:l,className:d,isDisabled:n,isLoading:a,...i})}),r.ButtonTertiary.displayName="ButtonTertiary"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/ButtonTertiary.cjs"}],[1696,{"../../../../types/index.cjs":2002,"./ButtonTertiary.cjs":1695},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonTertiary=r.ButtonTertiarySize=void 0;var n=e("../../../../types/index.cjs");Object.defineProperty(r,"ButtonTertiarySize",{enumerable:!0,get:function(){return n.ButtonTertiarySize}});var a=e("./ButtonTertiary.cjs");Object.defineProperty(r,"ButtonTertiary",{enumerable:!0,get:function(){return a.ButtonTertiary}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/index.cjs"}],[1697,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"../Icon/index.cjs":1986,"../Text/index.cjs":1989,"./ButtonBase.constants.cjs":1698,"@radix-ui/react-slot":2006,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonBase=void 0;const s=e("@radix-ui/react-slot"),o=i(e("react")),c=e("../../types/index.cjs"),l=e("../../utils/tw-merge.cjs"),u=e("../Icon/index.cjs"),d=e("../Text/index.cjs"),f=e("./ButtonBase.constants.cjs");r.ButtonBase=(0,o.forwardRef)(({children:e,className:t,size:r=c.ButtonBaseSize.Lg,isFullWidth:n,asChild:a,isDisabled:i,isLoading:m,loadingText:h,loadingIconProps:p,loadingTextProps:g,startIconName:b,startIconProps:y,startAccessory:v,endIconName:w,endIconProps:_,endAccessory:j,textProps:O,style:E,"aria-label":C,"aria-labelledby":k,"aria-describedby":x,"aria-pressed":T,"aria-expanded":A,"aria-controls":P,"aria-haspopup":B,...S},M)=>{const D=a?s.Slot:"button",I=!(i??m),R=(0,l.twMerge)("inline-flex items-center justify-center","rounded-xl px-4","font-medium text-default","bg-muted","min-w-20 overflow-hidden","relative",f.TWCLASSMAP_BUTTONBASE_SIZE_DIMENSION[r],n&&"w-full",I&&["transition-all","duration-100","ease-linear","active:scale-[0.97]","active:ease-[cubic-bezier(0.3,0.8,0.3,1)]"],(i||m)&&"cursor-not-allowed",i&&"opacity-50",t);return o.default.createElement(D,{ref:M,className:R,disabled:a?undefined:i??m,"aria-disabled":i?"true":undefined,"aria-busy":m?"true":undefined,"aria-label":C,"aria-labelledby":k,"aria-describedby":x,"aria-pressed":T,"aria-expanded":A,"aria-controls":P,"aria-haspopup":B,role:a?undefined:"button",tabIndex:a?undefined:i?-1:undefined,style:E,...S},b?o.default.createElement(u.Icon,{name:b,size:u.IconSize.Sm,className:(0,l.twMerge)("mr-2 shrink-0 text-inherit",y?.className),"aria-hidden":"true",...y}):v?o.default.createElement("span",{className:"mr-2","aria-hidden":"true"},v):null,o.default.createElement(s.Slottable,null,m?o.default.createElement(o.default.Fragment,null,o.default.createElement("span",{className:"absolute inline-flex items-center","aria-hidden":"true"},o.default.createElement(u.Icon,{name:u.IconName.Loading,size:u.IconSize.Sm,className:(0,l.twMerge)("mr-2 animate-spin text-inherit",p?.className),...p}),o.default.createElement(d.Text,{fontWeight:d.FontWeight.Medium,color:d.TextColor.Inherit,asChild:!0,...g},o.default.createElement("span",null,h))),o.default.createElement("span",{className:"invisible inline-flex items-center"},e),o.default.createElement("span",{className:"sr-only","aria-live":"polite","aria-atomic":"true"},h||"Loading")):e&&"string"==typeof e?o.default.createElement(d.Text,{fontWeight:d.FontWeight.Medium,color:d.TextColor.Inherit,asChild:!0,...O},o.default.createElement("span",null,e)):e),w?o.default.createElement(u.Icon,{name:w,size:u.IconSize.Sm,className:(0,l.twMerge)("ml-2 shrink-0 text-inherit",_?.className),"aria-hidden":"true",..._}):j?o.default.createElement("span",{className:"ml-2","aria-hidden":"true"},j):null)}),r.ButtonBase.displayName="ButtonBase"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.cjs"}],[1698,{"../../types/index.cjs":2002},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.TWCLASSMAP_BUTTONBASE_SIZE_DIMENSION=void 0;const n=e("../../types/index.cjs");r.TWCLASSMAP_BUTTONBASE_SIZE_DIMENSION={[n.ButtonBaseSize.Sm]:"h-8",[n.ButtonBaseSize.Md]:"h-10",[n.ButtonBaseSize.Lg]:"h-12"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.constants.cjs"}],[1699,{"../../types/index.cjs":2002,"./ButtonBase.cjs":1697},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonBase=r.ButtonBaseSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"ButtonBaseSize",{enumerable:!0,get:function(){return n.ButtonBaseSize}});var a=e("./ButtonBase.cjs");Object.defineProperty(r,"ButtonBase",{enumerable:!0,get:function(){return a.ButtonBase}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs"}],[1700,{"../../utils/tw-merge.cjs":2004,"../ButtonBase/index.cjs":1699,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonHero=void 0;const s=i(e("react")),o=e("../../utils/tw-merge.cjs"),c=e("../ButtonBase/index.cjs");r.ButtonHero=(0,s.forwardRef)(({className:e,isDisabled:t,isLoading:r,...n},a)=>{const i=!(t||r),l=(0,o.twMerge)("bg-primary-default text-primary-inverse",r&&"bg-primary-default-pressed",i&&["hover:bg-primary-default-hover","active:bg-primary-default-pressed"],"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-default",e);return s.default.createElement(c.ButtonBase,{ref:a,className:l,isDisabled:t,isLoading:r,"data-theme":"light",...n})}),r.ButtonHero.displayName="ButtonHero"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonHero/ButtonHero.cjs"}],[1701,{"../../types/index.cjs":2002,"./ButtonHero.cjs":1700},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonHeroSize=r.ButtonHero=void 0;var n=e("./ButtonHero.cjs");Object.defineProperty(r,"ButtonHero",{enumerable:!0,get:function(){return n.ButtonHero}});var a=e("../../types/index.cjs");Object.defineProperty(r,"ButtonHeroSize",{enumerable:!0,get:function(){return a.ButtonHeroSize}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonHero/index.cjs"}],[1702,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"../Icon/index.cjs":1986,"./ButtonIcon.constants.cjs":1703,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonIcon=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),l=e("../Icon/index.cjs"),u=e("./ButtonIcon.constants.cjs");r.ButtonIcon=(0,s.forwardRef)(({className:e,iconName:t,iconProps:r,ariaLabel:n,isDisabled:a=!1,isInverse:i=!1,isFloating:d=!1,size:f=o.ButtonIconSize.Md,style:m,...h},p)=>{const g=!a,b=(0,c.twMerge)("inline-flex items-center justify-center p-0",u.TWCLASSMAP_BUTTONICON_SIZE_DIMENSION[f],d&&["rounded-full",!i&&"bg-icon-default text-background-default",i&&"bg-icon-default text-background-default"],!d&&["rounded-lg bg-transparent",g&&"hover:bg-hover active:bg-pressed",!i&&"text-icon-default",i&&"text-background-default"],a&&"cursor-not-allowed opacity-50",e);return s.default.createElement("button",{ref:p,className:b,disabled:a,"aria-label":n,style:m,...h},s.default.createElement(l.Icon,{name:t,size:u.MAP_BUTTONICON_SIZE_ICONSIZE[f],className:(0,c.twMerge)("text-inherit",r?.className),...r}))}),r.ButtonIcon.displayName="ButtonIcon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.cjs"}],[1703,{"../../types/index.cjs":2002,"../Icon/index.cjs":1986},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAP_BUTTONICON_SIZE_ICONSIZE=r.TWCLASSMAP_BUTTONICON_SIZE_DIMENSION=void 0;const n=e("../../types/index.cjs"),a=e("../Icon/index.cjs");r.TWCLASSMAP_BUTTONICON_SIZE_DIMENSION={[n.ButtonIconSize.Sm]:"h-6 w-6",[n.ButtonIconSize.Md]:"h-8 w-8",[n.ButtonIconSize.Lg]:"h-10 w-10"},r.MAP_BUTTONICON_SIZE_ICONSIZE={[n.ButtonIconSize.Sm]:a.IconSize.Md,[n.ButtonIconSize.Md]:a.IconSize.Lg,[n.ButtonIconSize.Lg]:a.IconSize.Xl}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.constants.cjs"}],[1704,{"../../types/index.cjs":2002,"./ButtonIcon.cjs":1702},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ButtonIcon=r.ButtonIconSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"ButtonIconSize",{enumerable:!0,get:function(){return n.ButtonIconSize}});var a=e("./ButtonIcon.cjs");Object.defineProperty(r,"ButtonIcon",{enumerable:!0,get:function(){return a.ButtonIcon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonIcon/index.cjs"}],[1705,{"../../utils/tw-merge.cjs":2004,"../Icon/index.cjs":1986,"../Text/index.cjs":1989,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.Checkbox=void 0;const s=i(e("react")),o=e("../../utils/tw-merge.cjs"),c=e("../Icon/index.cjs"),l=e("../Text/index.cjs");r.Checkbox=(0,s.forwardRef)(({id:e,isSelected:t,isDisabled:r=!1,isInvalid:n=!1,label:a,labelProps:i,onChange:u,inputProps:d,checkboxContainerProps:f,checkedIconProps:m,className:h,style:p,...g},b)=>{const y=()=>{r||u?.(!t)};(0,s.useImperativeHandle)(b,()=>({toggle:y}),[y]);const v=(0,o.twMerge)("inline-flex items-center",r&&"cursor-not-allowed opacity-50",h),w=t?"bg-primary-default hover:bg-primary-default-hover active:bg-primary-default-pressed":"bg-default hover:bg-default-hover active:bg-default-pressed";let _="border-default";t?_="border-primary-default":n&&(_="border-error-default");const j=(0,o.twMerge)("relative flex size-6 items-center justify-center rounded border-2 p-0 transition-transform active:scale-95",w,_,f?.className),O=(0,o.twMerge)("pointer-events-none transition-opacity",t?"opacity-100":"opacity-0",m?.className);return s.default.createElement("label",{htmlFor:e,className:v,style:p,...g},s.default.createElement("div",{className:"relative"},s.default.createElement("input",{type:"checkbox",id:e,checked:t,disabled:r,"aria-invalid":n,onChange:e=>{r||u?.(e.target.checked)},onKeyDown:e=>{"Enter"===e.key&&(e.preventDefault(),y())},className:"absolute inset-0 size-full cursor-pointer opacity-0 disabled:cursor-not-allowed",...d}),s.default.createElement("div",{className:j,...f},s.default.createElement(c.Icon,{name:c.IconName.Check,color:c.IconColor.PrimaryInverse,size:c.IconSize.Sm,...m,className:O}))),a?s.default.createElement(l.Text,{asChild:!0,...i,className:(0,o.twMerge)("ml-3",i?.className)},s.default.createElement("span",null,a)):null)}),r.Checkbox.displayName="Checkbox"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Checkbox/Checkbox.cjs"}],[1706,{"./Checkbox.cjs":1705},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Checkbox=void 0;var n=e("./Checkbox.cjs");Object.defineProperty(r,"Checkbox",{enumerable:!0,get:function(){return n.Checkbox}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Checkbox/index.cjs"}],[1707,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"./Icon.constants.cjs":1708,"./icons/index.cjs":1985,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.Icon=void 0;const a=n(e("react")),i=e("../../types/index.cjs"),s=e("../../utils/tw-merge.cjs"),o=e("./Icon.constants.cjs"),c=e("./icons/index.cjs");r.Icon=({name:e,size:t=i.IconSize.Md,color:r=i.IconColor.IconDefault,className:n,style:l,...u})=>{if(!e)return console.warn("Icon name is required"),null;const d=c.Icons[e];if(!d)return console.warn(`Icon "${e}" not found`),null;const f=(0,s.twMerge)("inline-block",o.TWCLASSMAP_ICON_SIZE_DIMENSION[t],r,n);return a.default.createElement(d,{className:f,...u,style:l})}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/Icon.cjs"}],[1708,{"../../types/index.cjs":2002},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.TWCLASSMAP_ICON_SIZE_DIMENSION=void 0;const n=e("../../types/index.cjs");r.TWCLASSMAP_ICON_SIZE_DIMENSION={[n.IconSize.Xs]:"w-3 h-3",[n.IconSize.Sm]:"w-4 h-4",[n.IconSize.Md]:"w-5 h-5",[n.IconSize.Lg]:"w-6 h-6",[n.IconSize.Xl]:"w-8 h-8"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/Icon.constants.cjs"}],[1709,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 6q-.825 0-1.412-.587C10 4.825 10 4.55 10 4s.196-1.02.588-1.413S11.45 2 12 2s1.02.196 1.413.587S14 3.45 14 4s-.196 1.02-.587 1.412S12.55 6 12 6M9 22V9q-1.5-.125-3.05-.375C4.4 8.375 3.933 8.25 3 8l.5-2q1.95.525 4.15.763C9.85 7 10.567 7 12 7s2.883-.08 4.35-.237S19.2 6.35 20.5 6l.5 2q-1.4.375-2.95.625C16.5 8.875 16 8.917 15 9v13h-2v-6h-2v6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Accessibility.cjs"}],[1710,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m15.3 16.7 1.4-1.4-3.7-3.7V7h-2v5.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Activity.cjs"}],[1711,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 13H5v-2h6V5h2v6h6v2h-6v6h-2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Add.cjs"}],[1712,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v6H4v6h10v2zM4 8h16V6H4zm15 14v-3h-3v-2h3v-3h2v3h3v2h-3v3z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCard.cjs"}],[1713,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 17h2v-4h4v-2h-4V7h-2v4H7v2h4zm1 5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCircle.cjs"}],[1714,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 17h2v-4h4v-2h-4V7h-2v4H7v2h4zm-6 4q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddSquare.cjs"}],[1715,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("g",{fillRule:"evenodd",clipRule:"evenodd"},s.createElement("path",{d:"M17.714 3A4.86 4.86 0 0 0 22 7.304a4.86 4.86 0 0 0-4.286 4.305 4.86 4.86 0 0 0-4.285-4.305A4.86 4.86 0 0 0 17.714 3M16.46 14.913a3.44 3.44 0 0 0 3.03 3.044A3.44 3.44 0 0 0 16.46 21a3.44 3.44 0 0 0-3.03-3.043 3.44 3.44 0 0 0 3.03-3.044M9.143 4.87a8.12 8.12 0 0 1-4.383 6.349 8 8 0 0 1-2.76.824c.985.11 1.915.396 2.76.826a8.12 8.12 0 0 1 4.383 6.348 8.12 8.12 0 0 1 4.383-6.349 8 8 0 0 1 2.76-.825 8 8 0 0 1-2.76-.825A8.12 8.12 0 0 1 9.143 4.87m0 4.348a9.6 9.6 0 0 1-2.818 2.825 9.6 9.6 0 0 1 2.818 2.826 9.6 9.6 0 0 1 2.818-2.826 9.6 9.6 0 0 1-2.818-2.825"}))));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ai.cjs"}],[1716,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12v1.45q0 1.474-1.012 2.512C19.976 17 19.483 17 18.5 17q-.874 0-1.65-.375c-.776-.375-.95-.608-1.3-1.075q-.726.725-1.637 1.088C13.002 17 12.667 17 12 17q-2.075 0-3.537-1.462C7 14.075 7 13.383 7 12s.488-2.562 1.463-3.537S10.617 7 12 7s2.563.488 3.538 1.463S17 10.617 17 12v1.45q0 .65.425 1.1c.425.45.642.45 1.075.45s.792-.15 1.075-.45.425-.667.425-1.1V12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20h5v2zm0-7q1.25 0 2.125-.875C15 13.25 15 12.833 15 12s-.292-1.542-.875-2.125Q13.25 9 12 9c-1.25 0-1.542.292-2.125.875Q9 10.75 9 12c0 1.25.292 1.542.875 2.125A2.9 2.9 0 0 0 12 15"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AlternateEmail.cjs"}],[1717,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M14.935 5.204c.689-.863 1.156-2.022 1.033-3.206-1.009.05-2.24.666-2.952 1.53-.64.74-1.207 1.947-1.059 3.081 1.132.099 2.264-.566 2.978-1.405M15.955 6.83c-1.644-.097-3.042.935-3.828.935s-1.988-.885-3.289-.861c-1.693.025-3.263.983-4.122 2.508-1.767 3.049-.467 7.572 1.252 10.056.834 1.228 1.84 2.581 3.165 2.533 1.252-.05 1.742-.812 3.264-.812 1.52 0 1.963.812 3.288.787 1.374-.025 2.234-1.23 3.068-2.46.957-1.4 1.349-2.752 1.374-2.826-.025-.025-2.65-1.033-2.675-4.057-.025-2.532 2.061-3.737 2.16-3.812-1.178-1.744-3.019-1.94-3.657-1.99"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AppleLogo.cjs"}],[1718,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 20q-.824 0-1.412-.587C4 18.826 4 18.55 4 18s.196-1.02.588-1.412S5.45 16 6 16s1.02.196 1.413.587S8 17.45 8 18s-.196 1.02-.587 1.413S6.55 20 6 20m6 0q-.825 0-1.412-.587C10 18.826 10 18.55 10 18s.196-1.02.588-1.412S11.45 16 12 16s1.02.196 1.413.587S14 17.45 14 18s-.196 1.02-.587 1.413S12.55 20 12 20m6 0q-.825 0-1.412-.587C16 18.826 16 18.55 16 18s.196-1.02.587-1.412S17.45 16 18 16s1.02.196 1.413.587S20 17.45 20 18s-.196 1.02-.587 1.413S18.55 20 18 20M6 14q-.824 0-1.412-.587C4 12.825 4 12.55 4 12s.196-1.02.588-1.412S5.45 10 6 10s1.02.196 1.413.588S8 11.45 8 12s-.196 1.02-.587 1.413S6.55 14 6 14m6 0q-.825 0-1.412-.587C10 12.825 10 12.55 10 12s.196-1.02.588-1.412S11.45 10 12 10s1.02.196 1.413.588S14 11.45 14 12s-.196 1.02-.587 1.413S12.55 14 12 14m6 0q-.825 0-1.412-.587C16 12.825 16 12.55 16 12s.196-1.02.587-1.412S17.45 10 18 10s1.02.196 1.413.588S20 11.45 20 12s-.196 1.02-.587 1.413S18.55 14 18 14M6 8q-.824 0-1.412-.587C4 6.825 4 6.55 4 6s.196-1.02.588-1.412S5.45 4 6 4s1.02.196 1.413.588S8 5.45 8 6s-.196 1.02-.587 1.413S6.55 8 6 8m6 0q-.825 0-1.412-.587C10 6.825 10 6.55 10 6s.196-1.02.588-1.412S11.45 4 12 4s1.02.196 1.413.588S14 5.45 14 6s-.196 1.02-.587 1.413S12.55 8 12 8m6 0q-.825 0-1.412-.587C16 6.825 16 6.55 16 6s.196-1.02.587-1.412S17.45 4 18 4s1.02.196 1.413.588S20 5.45 20 6s-.196 1.02-.587 1.413S18.55 8 18 8"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Apps.cjs"}],[1719,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M13 4v12.175l5.6-5.6L20 12l-8 8-8-8 1.4-1.425 5.6 5.6V4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Down.cjs"}],[1720,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M20 13H7.825l5.6 5.6L12 20l-8-8 8-8 1.425 1.4-5.6 5.6H20z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Left.cjs"}],[1721,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 11h12.175l-5.6-5.6L12 4l8 8-8 8-1.425-1.4 5.6-5.6H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Right.cjs"}],[1722,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 20V7.825l-5.6 5.6L4 12l8-8 8 8-1.4 1.425-5.6-5.6V20z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Up.cjs"}],[1723,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m5.5 17.1 9.6-9.6H6.5v-2h12v12h-2V8.9l-9.6 9.6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2UpRight.cjs"}],[1724,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 16 4-4-1.4-1.4-1.6 1.6V8h-2v4.2l-1.6-1.6L8 12zm0 6q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleDown.cjs"}],[1725,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 16h2v-4.2l1.6 1.6L16 12l-4-4-4 4 1.4 1.4 1.6-1.6zm1 6q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleUp.cjs"}],[1726,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m17.7 4.886-5 7 5 7h-2.45l-5-7 5-7zm-5.95 0-5 7 5 7H9.3l-5-7 5-7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleLeft.cjs"}],[1727,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m6.3 18.886 5-7-5-7h2.45l5 7-5 7zm5.95 0 5-7-5-7h2.45l5 7-5 7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleRight.cjs"}],[1728,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m2 7.887 1.775-1.775L12 14.337l8.225-8.225L22 7.887l-10 10z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDown.cjs"}],[1729,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 15 4-4H8zm0 7q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDropDownCircle.cjs"}],[1730,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m15.112 21.886-10-10 10-10 1.775 1.775-8.225 8.224 8.225 8.226z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowLeft.cjs"}],[1731,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8.887 22-1.775-1.775L15.337 12 7.112 3.775 8.887 2l10 10z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowRight.cjs"}],[1732,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m22 16.113-1.775 1.775L12 9.661l-8.225 8.225L2 16.113l10-10z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowUp.cjs"}],[1733,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12.48 10.9c-2.27-.59-3-1.2-3-2.15 0-1.09 1.01-1.85 2.7-1.85 1.78 0 2.44.85 2.5 2.1h2.21c-.07-1.72-1.12-3.3-3.21-3.81V3h-3v2.16c-1.94.42-3.5 1.68-3.5 3.61 0 2.31 1.91 3.46 4.7 4.13 2.5.6 3 1.48 3 2.41 0 .69-.49 1.79-2.7 1.79-2.06 0-2.87-.92-2.98-2.1H7c.12 2.19 1.76 3.42 3.68 3.83V21h3v-2.15c1.95-.37 3.5-1.5 3.5-3.55 0-2.84-2.43-3.81-4.7-4.4"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AttachMoney.cjs"}],[1734,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8.25 18q-2.6 0-4.425-1.825C2 14.35 2 13.483 2 11.75s.608-3.208 1.825-4.425S6.517 5.5 8.25 5.5h9.25q1.875 0 3.188 1.313C22 8.126 22 8.75 22 10s-.437 2.313-1.312 3.188S18.75 14.5 17.5 14.5H8.75q-1.15 0-1.95-.8c-.8-.8-.8-1.183-.8-1.95s.267-1.417.8-1.95A2.65 2.65 0 0 1 8.75 9H18v2H8.75a.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75h8.75q1.05-.025 1.775-.737C20 11.05 20 10.7 20 10s-.242-1.292-.725-1.775S18.2 7.5 17.5 7.5H8.25q-1.774-.025-3.012 1.225C3.999 9.975 4 10.567 4 11.75q0 1.75 1.238 2.975C6.475 15.95 7.067 15.967 8.25 16H18v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Attachment.cjs"}],[1735,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m11.4 16 2.6-2.6 2.6 2.6 1.4-1.4-2.6-2.6L18 9.4 16.6 8 14 10.6 11.4 8 10 9.4l2.6 2.6-2.6 2.6zM9 20a1.99 1.99 0 0 1-1.6-.8L2 12l5.4-7.2q.275-.375.7-.587C8.525 4 8.683 4 9 4h11q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm-4.5-8L9 18h11V6H9z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Backspace.cjs"}],[1736,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q1.35 0 2.6-.437c1.25-.437 1.6-.713 2.3-1.263L5.7 7.1a8 8 0 0 0-1.263 2.3A7.8 7.8 0 0 0 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20m6.3-3.1q.824-1.05 1.263-2.3c.439-1.25.437-1.7.437-2.6q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4q-1.35 0-2.6.437A8 8 0 0 0 7.1 5.7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ban.cjs"}],[1737,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 17.886v-7h2v7zm6 0v-7h2v7zm-9 4v-2h20v2zm15-4v-7h2v7zm-15-9v-2l10-5 10 5v2zm4.45-2h11.1L12 4.136z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bank.cjs"}],[1738,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 17v-7h2v7zm6 0v-7h2v7zM2 8V6l10-5 10 5v2zm4.475-2h11.05L12 3.25zM2 21v-2h12.05q.05.525.125 1.013c.075.487.125.654.225.987zm15-7.75V10h2v2.25zM20 24q-1.725-.425-2.862-1.987C16 20.45 16 19.816 16 18.55V16l4-2 4 2v2.55q0 1.9-1.137 3.463C21.726 23.575 21.15 23.717 20 24m-.725-3 3.475-3.45-1.05-1.05-2.425 2.375-.975-.975-1.05 1.075z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/BankAssured.cjs"}],[1739,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6.8 19V5h5.525q1.624 0 3 1C16.7 7 16.7 7.592 16.7 8.775q0 1.275-.575 1.963c-.575.688-.742.787-1.075.987q.625.275 1.387 1.025c.762.75.763 1.25.763 2.25q0 2.224-1.625 3.113c-1.625.889-2.1.887-3.05.887zm3.025-2.8h2.6q1.2 0 1.462-.612c.262-.613.263-.705.263-.888s-.088-.48-.263-.887-.687-.613-1.537-.613H9.825zm0-5.7h2.325q.825 0 1.2-.425a1.4 1.4 0 0 0 .375-.95q0-.6-.425-.975c-.425-.375-.65-.375-1.1-.375H9.825z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bold.cjs"}],[1740,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6.5 16q1.175 0 2.288.263c1.112.262 1.479.437 2.212.787V7.2q-1.024-.6-2.175-.9C7.674 6 7.283 6 6.5 6q-.9 0-1.788.175C3.824 6.35 3.55 6.467 3 6.7v9.9q.875-.3 1.737-.45C5.6 16 5.9 16 6.5 16m6.5 1.05q1.099-.525 2.213-.787C16.327 16 16.717 16 17.5 16q.9 0 1.763.15c.862.15 1.154.25 1.737.45V6.7q-.825-.35-1.712-.525C18.4 6 18.1 6 17.5 6q-1.175 0-2.325.3c-1.15.3-1.492.5-2.175.9zM12 20a9.6 9.6 0 0 0-2.6-1.475A8.2 8.2 0 0 0 6.5 18q-1.05 0-2.062.275c-1.012.275-1.321.442-1.938.775q-.525.275-1.012-.025C1 18.725 1 18.533 1 18.15V6.1q0-.274.138-.525c.138-.251.229-.292.412-.375q1.15-.6 2.4-.9C5.2 4 5.633 4 6.5 4q1.45 0 2.838.375C10.726 4.75 11.15 5 12 5.5A10.8 10.8 0 0 1 17.5 4q1.3 0 2.55.3c1.25.3 1.633.5 2.4.9q.274.125.413.375c.139.25.137.342.137.525v12.05q0 .575-.487.875c-.488.3-.663.208-1.013.025q-.925-.5-1.937-.775C18.55 18 18.2 18 17.5 18q-1.5 0-2.9.525c-1.4.525-1.8.842-2.6 1.475"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Book.cjs"}],[1741,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h12q.824 0 1.413.588C20.002 3.175 20 3.45 20 4v16q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V4h-2v7l-2.5-1.5L11 11V4H6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bookmark.cjs"}],[1742,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M2 15.276c0-1.014.684-1.874 1.63-2.17C4.4 9.31 7.855 6.445 12 6.445c2.982 0 5.607 1.483 7.131 3.728a5.4 5.4 0 0 0-1.805.494A6.83 6.83 0 0 0 12 8.154c-3.215 0-5.906 2.172-6.594 5.084.77.374 1.3 1.146 1.3 2.038 0 1.259-1.054 2.28-2.353 2.28S2 16.534 2 15.275m17.647 2.28c1.3 0 2.353-1.021 2.353-2.28 0-1.22-.989-2.215-2.232-2.276l-.121-.003c-.379 0-.736.087-1.053.24-.771.375-1.3 1.147-1.3 2.04 0 1.258 1.053 2.278 2.353 2.278",clipRule:"evenodd"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bridge.cjs"}],[1743,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 21q-.824 0-1.412-.587C1.999 19.826 2 19.55 2 19V8q0-.824.588-1.412C3.175 6 3.45 6 4 6h4V4q0-.824.588-1.412C9.176 1.999 9.45 2 10 2h4q.824 0 1.413.588C16 3.175 16 3.45 16 4v2h4q.824 0 1.413.588C22.002 7.176 22 7.45 22 8v11q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm6-15h4V4h-4zm10 9h-5v2H9v-2H4v4h16zm-9 0h2v-2h-2zm-7-2h5v-2h6v2h5V8H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Briefcase.cjs"}],[1744,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-.65 0-1.175-.312c-.525-.312-.625-.488-.825-.838q-.825 0-1.412-.587C8 19.676 8 19.4 8 18.85V15.3q-1.474-.975-2.362-2.575c-.888-1.6-.888-2.225-.888-3.475q0-3.026 2.113-5.137C8.974 2.002 9.983 2 12 2q3.026 0 5.138 2.113c2.111 2.113 2.112 3.12 2.112 5.137q0 1.925-.887 3.5c-.887 1.575-1.38 1.9-2.363 2.55v3.55q0 .824-.587 1.413c-.588.589-.863.587-1.413.587A2.27 2.27 0 0 1 12 22m-2-3.15h4v-.9h-4zm0-1.9h4V16h-4zM9.8 14h1.45v-2.7l-2.2-2.2 1.05-1.05 1.9 1.9 1.9-1.9 1.05 1.05-2.2 2.2V14h1.45q1.35-.65 2.2-1.912c.85-1.262.85-1.788.85-2.838q0-2.2-1.525-3.725C14.2 4 13.467 4 12 4s-2.708.508-3.725 1.525S6.75 7.783 6.75 9.25q0 1.575.85 2.838C8.45 13.35 8.9 13.567 9.8 14"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bulb.cjs"}],[1745,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M7 4.252H5v3H2v2h3v3h2v-3h3v-2H7zm11 1 1.06 1.06L5.627 19.749l-1.061-1.06zm4 11v-2h-8v2z",clipRule:"evenodd"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/BuySell.cjs"}],[1746,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 22q-.424 0-.712-.287C3 21.425 3 21.283 3 21v-5q0-.825.588-1.412C4.175 14 4.45 14 5 14v-4q0-.825.588-1.412C6.176 8 6.45 8 7 8h4V6.55q-.45-.3-.725-.725C10 5.4 10 5.2 10 4.8q0-.375.15-.737c.15-.362.25-.463.45-.663L12 2l1.4 1.4q.3.3.45.663c.15.363.15.487.15.737q0 .6-.275 1.025c-.275.425-.425.525-.725.725V8h4q.824 0 1.413.588c.589.588.587.862.587 1.412v4q.824 0 1.413.588c.589.588.587.862.587 1.412v5q0 .424-.287.713C20.425 22 20.283 22 20 22zm3-8h10v-4H7zm-2 6h14v-4H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cake.cjs"}],[1747,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8 18h1.5v-2h2v-1.5h-2v-2H8v2H6V16h2zm5-.75h5v-1.5h-5zm0-2.5h5v-1.5h-5zm1.1-3.8 1.4-1.4 1.4 1.4 1.05-1.05-1.4-1.45 1.4-1.4L16.9 6l-1.4 1.4L14.1 6l-1.05 1.05 1.4 1.4-1.4 1.45zM6.25 9.2h5V7.7h-5zM5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calculator.cjs"}],[1748,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 22q-.824 0-1.412-.587C2.999 20.826 3 20.55 3 20V6q0-.824.588-1.412C4.175 4 4.45 4 5 4h1V2h2v2h8V2h2v2h1q.824 0 1.413.588C21.002 5.176 21 5.45 21 6v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V10H5zM5 8h14V6H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calendar.cjs"}],[1749,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M19.95 21q-3.125 0-6.175-1.362c-3.05-1.363-3.883-2.196-5.55-3.863s-2.954-3.517-3.863-5.55Q3 7.175 3 4.05q0-.45.3-.75c.3-.3.45-.3.75-.3H8.1q.35 0 .625.237c.275.237.292.346.325.563l.65 3.5q.05.4-.025.675c-.075.275-.142.342-.275.475L6.975 10.9q.5.925 1.187 1.787c.687.862.963 1.13 1.513 1.663q.775.776 1.625 1.437c.85.661 1.167.846 1.8 1.213l2.35-2.35q.225-.225.587-.338c.362-.113.48-.095.713-.062l3.45.7q.35.1.575.362c.225.262.225.371.225.588v4.05q0 .45-.3.75c-.3.3-.45.3-.75.3M6.025 9l1.65-1.65L7.25 5H5.025q.125 1.024.35 2.025C5.6 8.026 5.742 8.35 6.025 9m8.95 8.95q.975.424 1.987.675c1.012.251 1.355.275 2.038.325v-2.2l-2.35-.475z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Call.cjs"}],[1750,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 17.5q1.875 0 3.188-1.312C16.5 14.876 16.5 14.25 16.5 13s-.437-2.312-1.312-3.187S13.25 8.5 12 8.5s-2.312.438-3.187 1.313S7.5 11.75 7.5 13s.438 2.313 1.313 3.188S10.75 17.5 12 17.5m0-2q-1.05 0-1.775-.725T9.5 13c0-1.05.242-1.292.725-1.775Q10.95 10.5 12 10.5c1.05 0 1.292.242 1.775.725S14.5 12.3 14.5 13s-.242 1.292-.725 1.775S12.7 15.5 12 15.5M4 21q-.824 0-1.412-.587C1.999 19.826 2 19.55 2 19V7q0-.824.588-1.412C3.175 5 3.45 5 4 5h3.15L9 3h6l1.85 2H20q.824 0 1.413.588C22.002 6.176 22 6.45 22 7v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h16V7h-4.05l-1.825-2h-4.25L8.05 7H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Camera.cjs"}],[1751,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M18 13v-2h4v2zm1.2 7L16 17.6l1.2-1.6 3.2 2.4zm-2-12L16 6.4 19.2 4l1.2 1.6zM5 19v-4H4q-.824 0-1.412-.587C1.999 13.825 2 13.55 2 13v-2q0-.825.588-1.412C3.175 9 3.45 9 4 9h4l5-3v12l-5-3H7v4zm6-4.55v-4.9L8.55 11H4v2h4.55zm3 .9v-6.7q.675.6 1.088 1.462c.413.862.412 1.205.412 1.888s-.137 1.312-.412 1.887S14.45 14.95 14 15.35"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Campaign.cjs"}],[1752,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M9 4H7v2H5v12h2v2h2v-2h2V6H9zm0 12H7V8h2zM19 8h-2V4h-2v4h-2v7h2v5h2v-5h2zm-2 5h-2v-3h2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Candlestick.cjs"}],[1753,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H4q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6M4 8h16V6H4zm0 4v6h16v-6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Card.cjs"}],[1754,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8.4 14.65q.224-.6.363-1.262c.139-.662.137-.905.137-1.388s-.046-.946-.137-1.387S8.55 9.75 8.4 9.35l-1.85.75q.15.45.25.925c.1.475.1.642.1.975s-.033.658-.1.975-.15.625-.25.925zM11.6 16q.425-.95.613-1.95c.188-1 .187-1.35.187-2.05s-.062-1.383-.187-2.05A8.7 8.7 0 0 0 11.6 8l-1.85.75q.35.75.5 1.563T10.4 12c0 .875-.05 1.146-.15 1.688s-.267 1.062-.5 1.562zm3.25 1.35q.525-1.25.788-2.587c.263-1.337.262-1.813.262-2.763s-.087-1.87-.262-2.762a13.3 13.3 0 0 0-.788-2.588l-1.85.8q.45 1.05.675 2.2T13.9 12c0 1.2-.075 1.583-.225 2.35s-.375 1.5-.675 2.2zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.263-2.683.788-3.9 1.237-2.275 2.137-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CardPos.cjs"}],[1755,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 17h2v-1h1q.424 0 .713-.287c.289-.287.287-.43.287-.713v-3q0-.424-.287-.712c-.287-.289-.43-.288-.713-.288h-3v-1h4V8h-2V7h-2v1h-1q-.424 0-.712.288C8.999 8.575 9 8.717 9 9v3q0 .424.288.713c.287.289.429.287.712.287h3v1H9v2h2zm-7 3q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h16V6H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cash.cjs"}],[1756,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 11V3h8v8zm0 10v-8h8v8zm10-10V3h8v8zm0 10v-8h8v8zM5 9h4V5H5zm10 0h4V5h-4zm0 10h4v-4h-4zM5 19h4v-4H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Category.cjs"}],[1757,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M16 20v-7h4v7zm-6 0V4h4v16zm-6 0V9h4v11z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Chart.cjs"}],[1758,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m9.55 17.886-5.7-5.7 1.425-1.425 4.275 4.275 9.175-9.176 1.425 1.425z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Check.cjs"}],[1759,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m9.55 18.686-6.5-6.5 2.25-2.25 4.25 4.25 9.15-9.15 2.25 2.25z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CheckBold.cjs"}],[1760,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8.4 17 3.6-3.6 3.6 3.6 1.4-1.4-3.6-3.6L17 8.4 15.6 7 12 10.6 8.4 7 7 8.4l3.6 3.6L7 15.6zm3.6 5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CircleX.cjs"}],[1761,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8.4 17 3.6-3.6 3.6 3.6 1.4-1.4-3.6-3.6L17 8.4 15.6 7 12 10.6 8.4 7 7 8.4l3.6 3.6L7 15.6zm3.6 5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clear.cjs"}],[1762,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m15.3 16.7 1.4-1.4-3.7-3.7V7h-2v5.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clock.cjs"}],[1763,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m15.3 16.7 1.4-1.4-3.7-3.7V7h-2v5.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ClockFilled.cjs"}],[1764,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6.4 19 5 17.6l5.6-5.6L5 6.4 6.4 5l5.6 5.6L17.6 5 19 6.4 13.4 12l5.6 5.6-1.4 1.4-5.6-5.6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Close.cjs"}],[1765,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6.5 20q-2.275 0-3.887-1.575C1 16.85 1 16.092 1 14.575q0-1.95 1.175-3.475C3.35 9.575 3.983 9.433 5.25 9.15q.625-2.3 2.5-3.725C9.625 4 10.417 4 12 4q2.925 0 4.963 2.038C19 8.076 19 9.05 19 11q1.725.2 2.863 1.488C23 13.776 23 14.35 23 15.5q0 1.875-1.312 3.188C20.376 20 19.75 20 18.5 20zm0-2h12q1.05 0 1.775-.725C21 16.55 21 16.2 21 15.5s-.242-1.292-.725-1.775S19.2 13 18.5 13H17v-2q0-2.075-1.462-3.538C14.075 6 13.383 6 12 6s-2.562.487-3.537 1.462S7 9.617 7 11h-.5q-1.45 0-2.475 1.025C3 13.05 3 13.533 3 14.5s.342 1.792 1.025 2.475S5.533 18 6.5 18"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cloud.cjs"}],[1766,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6.5 20q-2.275 0-3.887-1.585C1 16.83 1 16.067 1 14.541q0-1.962 1.175-3.497A5.2 5.2 0 0 1 5.25 9.082q.425-1.812 2.125-3.447C9.075 4 9.717 4 11 4q.824 0 1.413.591C13 5.182 13 5.46 13 6.013V12.1l1.6-1.56L16 11.95l-4 4.025-4-4.025 1.4-1.41L11 12.1V6.014q-1.9.35-2.95 1.849Q7 9.359 7 10.943h-.5q-1.45 0-2.475 1.032A3.4 3.4 0 0 0 3 14.465q0 1.46 1.025 2.491A3.36 3.36 0 0 0 6.5 17.987h12q1.05 0 1.775-.73.725-.728.725-1.785c0-1.057-.242-1.3-.725-1.787a2.4 2.4 0 0 0-1.775-.729H17v-2.013q0-1.207-.55-2.251A5.6 5.6 0 0 0 15 6.918v-2.34q1.85.882 2.925 2.604C19 8.904 19 9.585 19 10.943q1.725.202 2.863 1.497A4.45 4.45 0 0 1 23 15.472q0 1.887-1.312 3.207C20.376 20 19.75 20 18.5 20z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudDownload.cjs"}],[1767,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6.5 20q-2.275 0-3.887-1.575C1 16.85 1 16.092 1 14.575q0-1.95 1.175-3.475C3.35 9.575 3.983 9.433 5.25 9.15q.625-2.3 2.5-3.725C9.625 4 10.417 4 12 4q2.925 0 4.963 2.038C19 8.076 19 9.05 19 11q1.725.2 2.863 1.488C23 13.776 23 14.35 23 15.5q0 1.875-1.312 3.188C20.376 20 19.75 20 18.5 20H13q-.825 0-1.412-.587C11 18.826 11 18.55 11 18v-5.15L9.4 14.4 8 13l4-4 4 4-1.4 1.4-1.6-1.55V18h5.5q1.05 0 1.775-.725C21 16.55 21 16.2 21 15.5s-.242-1.292-.725-1.775S19.2 13 18.5 13H17v-2q0-2.075-1.462-3.537C14.075 6 13.383 6 12 6s-2.562.488-3.537 1.463S7 9.617 7 11h-.5q-1.45 0-2.475 1.025C3 13.05 3 13.533 3 14.5s.342 1.792 1.025 2.475S5.533 18 6.5 18H9v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudUpload.cjs"}],[1768,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8 18-6-6 6-6 1.425 1.425-4.6 4.6L9.4 16.6zm8 0-1.425-1.425 4.6-4.6L14.6 7.4 16 6l6 6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Code.cjs"}],[1769,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10m-2.4-6.514L11 14.06l-2.175-2.175L11 9.712 9.6 8.286l-3.6 3.6zm4.8 0 3.6-3.6-3.6-3.6L13 9.71l2.175 2.175L13 14.06z",clipRule:"evenodd"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CodeCircle.cjs"}],[1770,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11.1 19h1.75v-1.25q1.25-.225 2.15-.975c.9-.75.9-1.242.9-2.225q0-1.05-.6-1.925c-.6-.875-1.2-1.092-2.4-1.525q-1.5-.5-2.075-.875c-.575-.375-.575-.592-.575-1.025s.154-.775.463-1.025.754-.375 1.337-.375q.8 0 1.25.387c.45.387.517.58.65.963l1.6-.65q-.274-.875-1.012-1.525C13.8 6.325 13.5 6.3 12.9 6.25V5h-1.75v1.25q-1.25.275-1.95 1.1c-.7.825-.7 1.167-.7 1.85q0 1.175.688 1.9c.688.725 1.179.9 2.162 1.25q1.576.575 2.188 1.025c.612.45.612.692.612 1.175q0 .825-.587 1.212c-.587.387-.863.388-1.413.388s-1.037-.17-1.462-.512-.738-.855-.938-1.538l-1.65.65q.35 1.2 1.088 1.938c.738.738 1.129.829 1.912 1.012zm.9 3q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Coin.cjs"}],[1771,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 13v6H9v-4H5v-2zm4-8v4h4v2h-6V5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Collapse.cjs"}],[1772,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m10.6 16.6 7.05-7.05-1.4-1.4-5.65 5.65-2.85-2.85-1.4 1.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Confirmation.cjs"}],[1773,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4.925 19.075q-1.35-1.376-2.137-3.188A9.65 9.65 0 0 1 2 12q0-2.1.787-3.913a10.1 10.1 0 0 1 2.138-3.162L6.35 6.35A8.1 8.1 0 0 0 4.625 8.9Q4 10.35 4 12a7.8 7.8 0 0 0 2.35 5.65zM7.75 16.25q-.8-.825-1.275-1.913C6 13.25 6 12.833 6 12q0-1.275.475-2.363A6.1 6.1 0 0 1 7.75 7.75l1.425 1.425a4.1 4.1 0 0 0-.862 1.275Q8 11.175 8 12c0 .825.104 1.067.313 1.55q.312.725.862 1.275zM12 14q-.825 0-1.412-.588Q10 12.825 10 12c0-.825.196-1.02.588-1.413Q11.175 10 12 10c.825 0 1.02.196 1.413.587Q14 11.175 14 12c0 .825-.196 1.02-.587 1.412A1.93 1.93 0 0 1 12 14m4.25 2.25-1.425-1.425q.55-.55.863-1.275T16 12c0-.825-.104-1.067-.312-1.55a4.1 4.1 0 0 0-.863-1.275L16.25 7.75a6.1 6.1 0 0 1 1.275 1.887Q18 10.725 18 12q0 1.25-.475 2.337c-.475 1.087-.742 1.363-1.275 1.913m2.825 2.825L17.65 17.65a8.1 8.1 0 0 0 1.725-2.55Q20 13.65 20 12a7.8 7.8 0 0 0-2.35-5.65l1.425-1.425q1.35 1.35 2.138 3.162Q21.999 9.9 22 12q0 2.075-.787 3.887a10.5 10.5 0 0 1-2.138 3.188"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Connect.cjs"}],[1774,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M9 18q-.825 0-1.412-.587C7 16.826 7 16.55 7 16V4q0-.824.588-1.412C8.176 1.999 8.45 2 9 2h9q.824 0 1.413.588C20.002 3.175 20 3.45 20 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h9V4H9zm-4 6q-.824 0-1.412-.587C2.999 20.826 3 20.55 3 20V6h2v14h11v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Copy.cjs"}],[1775,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M7.588 17.413Q8.175 18 9 18h9q.824 0 1.413-.587c.589-.587.587-.863.587-1.413V4q0-.824-.587-1.412C18.826 1.999 18.55 2 18 2H9q-.825 0-1.412.588C7 3.175 7 3.45 7 4v12q0 .824.588 1.413M18 16H9V4h9zM3.588 21.413Q4.175 22 5 22h11v-2H5V6H3v14q0 .824.588 1.413M12.7 12 10 9.491l1.084-.99 1.617 1.503L15.935 7 17 8.007z",clipRule:"evenodd"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CopySuccess.cjs"}],[1776,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 8h16V6H4zM2 6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v6H4v6h4.1v2H4q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18zm12.95 16-4.25-4.25 1.4-1.4 2.85 2.8 5.65-5.65 1.4 1.45zM4 6v12-4.5 2.825z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CreditCheck.cjs"}],[1777,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 21v-3H5v-2h2V3h11v2H9v6h8v2H9v3h4v2H9v3z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyFranc.cjs"}],[1778,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M9 21v-5.15l-3 1.875V15.35l3-1.875v-2.35L6 13v-2.35l3-1.9V3h2v4.5L15 5v2.35l-4 2.525v2.35l4-2.5v2.35L11 14.6V19q2.075 0 3.538-1.462C16 16.076 16 15.383 16 14h2q0 2.925-2.037 4.963C13.926 21 12.95 21 11 21z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyLira.cjs"}],[1779,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 21v-2l.413-.25q.411-.25.9-.737c.489-.488.62-.742.887-1.25s.4-1.096.4-1.763q0-.274-.037-.525c-.038-.251-.055-.325-.088-.475H6v-2h1.5a27 27 0 0 1-1.012-1.737Q6 9.35 6 8q0-2.3 1.6-3.9c1.6-1.6 2.367-1.6 3.9-1.6q1.774 0 3.15.975c1.376.975 1.575 1.492 1.975 2.525l-1.85.775q-.374-1-1.262-1.637C12.625 4.5 12.25 4.5 11.5 4.5q-1.45 0-2.475 1.025C8 6.55 8 7.033 8 8q0 1.2.6 2t1.225 2H14v2h-3.475q.05.225.063.475c.013.25.012.342.012.525q0 1.25-.437 2.25A7.3 7.3 0 0 1 9.1 19H14q1 0 1.525-.525c.525-.525.592-.8.725-1.35L18 18q-.275 1.375-1.412 2.188C15.45 21 14.966 21 14 21z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyPound.cjs"}],[1780,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 21v-7H6v-2h4.725L5 3h2.375L12 10.3 16.625 3H19l-5.725 9H18v2h-5v7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyYuan.cjs"}],[1781,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 21v-6h2v2h8v2h-8v2zm-8-2v-2h6v2zm4-4v-2H3v-2h4V9h2v6zm4-2v-2h10v2zm4-4V3h2v2h4v2h-4v2zM3 7V5h10v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Customize.cjs"}],[1782,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M1 21 12 2l11 19zm3.45-2h15.1L12 6zM12 18q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S12.283 16 12 16s-.52.096-.712.288S11 16.717 11 17s.096.52.288.713.429.287.712.287m-1-3h2v-5h-2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Danger.cjs"}],[1783,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 21q-3.75 0-6.375-2.625C3 15.75 3 14.5 3 12s.875-4.625 2.625-6.375S9.5 3 12 3a9 9 0 0 1 1.35.1q-1.026.725-1.637 1.888C11.102 6.15 11.1 6.6 11.1 7.5q0 2.25 1.575 3.825C14.25 12.9 15 12.9 16.5 12.9q1.375 0 2.525-.613c1.15-.613 1.392-.954 1.875-1.637A8.5 8.5 0 0 1 21 12q0 3.75-2.625 6.375C15.75 21 14.5 21 12 21m0-2q2.2 0 3.95-1.212c1.75-1.212 2.017-1.863 2.55-3.163q-.5.125-1 .2c-.5.075-.667.075-1 .075q-3.075 0-5.237-2.162T9.1 7.5q0-.5.075-1c.075-.5.117-.667.2-1q-1.95.8-3.163 2.55C5 9.8 5 10.533 5 12q0 2.9 2.05 4.95C9.1 19 10.067 19 12 19"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Dark.cjs"}],[1784,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 21q-3.75 0-6.375-2.625C3 15.75 3 14.5 3 12s.875-4.625 2.625-6.375S9.5 3 12 3a9 9 0 0 1 1.35.1q-1.026.725-1.637 1.888C11.102 6.15 11.1 6.6 11.1 7.5q0 2.25 1.575 3.825C14.25 12.9 15 12.9 16.5 12.9q1.375 0 2.525-.613c1.15-.613 1.392-.954 1.875-1.637A8.5 8.5 0 0 1 21 12q0 3.75-2.625 6.375C15.75 21 14.5 21 12 21"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/DarkFilled.cjs"}],[1785,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M22 19q0 1.25-.875 2.125C20.25 22 19.833 22 19 22q-.975 0-1.75-.562c-.775-.562-.875-.855-1.075-1.438H14q-1.25 0-2.125-.875C11 18.25 11 17.833 11 17v-4H7.825q-.3.875-1.075 1.438C5.975 15 5.65 15 5 15q-1.25 0-2.125-.875C2 13.25 2 12.833 2 12s.292-1.542.875-2.125A2.9 2.9 0 0 1 5 9q.975 0 1.75.563c.775.562.875.854 1.075 1.437H11V7q0-1.25.875-2.125C12.75 4 13.167 4 14 4h2.175q.3-.875 1.075-1.437C18.025 2 18.35 2 19 2q1.25 0 2.125.875C22 3.75 22 4.167 22 5s-.292 1.542-.875 2.125S19.833 8 19 8q-.975 0-1.75-.562c-.775-.562-.875-.855-1.075-1.438H14q-.424 0-.712.288C12.999 6.575 13 6.717 13 7v4h3.175q.3-.875 1.075-1.437C18.025 9 18.35 9 19 9q1.25 0 2.125.875T22 12c0 1.25-.292 1.542-.875 2.125S19.833 15 19 15q-.975 0-1.75-.562c-.775-.563-.875-.855-1.075-1.438H13v4q0 .424.288.713c.287.288.429.287.712.287h2.175q.3-.875 1.075-1.437C18.025 16 18.35 16 19 16q1.25 0 2.125.875C22 17.75 22 18.167 22 19m-2 0q0-.424-.287-.712C19.425 18 19.283 18 19 18s-.52.096-.712.288S18 18.717 18 19s.096.52.288.713.429.287.712.287.52-.096.713-.287S20 19.283 20 19m0-7q0-.424-.287-.712c-.288-.289-.43-.288-.713-.288s-.52.096-.712.288S18 11.717 18 12s.096.52.288.713.429.287.712.287.52-.096.713-.287S20 12.283 20 12m0-7q0-.424-.287-.712C19.425 3.998 19.283 4 19 4s-.52.096-.712.287S18 4.717 18 5s.096.52.288.713S18.717 6 19 6s.52-.096.713-.287S20 5.283 20 5M6 12q0-.424-.287-.712C5.426 10.999 5.283 11 5 11s-.52.096-.712.288S4 11.717 4 12s.096.52.287.713S4.717 13 5 13s.52-.096.713-.287S6 12.283 6 12"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Data.cjs"}],[1786,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8 18h8v-2H8zm0-4h8v-2H8zm-2 8q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Description.cjs"}],[1787,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S8.283 15 8 15s-.52.096-.712.287S7 15.717 7 16s.096.52.288.712S7.717 17 8 17m0-4q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S8.283 11 8 11s-.52.096-.712.288S7 11.717 7 12s.096.52.288.713S7.717 13 8 13m0-4q.424 0 .713-.287C9.002 8.426 9 8.283 9 8s-.096-.52-.287-.712S8.283 7 8 7s-.52.096-.712.288S7 7.717 7 8s.096.52.288.713S7.717 9 8 9m3 8h6v-2h-6zm0-4h6v-2h-6zm0-4h6V7h-6zM5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Details.cjs"}],[1788,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3.5 18.5 2 17l7.5-7.5 4 4 7.1-8L22 6.9l-8.5 9.6-4-4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Diagram.cjs"}],[1789,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"}),s.createElement("path",{d:"m11.12 15.613-1.232 1.253L6.721 13.7l3.167-3.168 1.232 1.254-1.914 1.914zM17.28 13.699l-3.168 3.167-1.232-1.253 1.914-1.914-1.914-1.914 1.232-1.254z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/DocumentCode.cjs"}],[1790,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 16-5-5 1.4-1.45 2.6 2.6V4h2v8.15l2.6-2.6L17 11zm-6 4q-.824 0-1.412-.587C4 18.826 4 18.55 4 18v-3h2v3h12v-3h2v3q0 .824-.587 1.413c-.587.589-.863.587-1.413.587z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Download.cjs"}],[1791,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 1 9.05 5.4q.45.275.7.75c.25.475.25.65.25 1V19q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H4q-.824 0-1.412-.587C1.999 19.826 2 19.55 2 19V8.15q0-.525.25-1c.25-.475.4-.567.7-.75zm0 11.65L19.8 8 12 3.35 4.2 8zM12 15l-8-4.8V19h16v-8.8zm0 4h8H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Draft.cjs"}],[1792,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5.4 19.599a8.3 8.3 0 0 1-1.762-2.601Q3 15.522 3 13.946q0-1.575.6-3.114t1.95-2.888q.875-.876 2.163-1.501t3.05-.988q1.761-.363 4.024-.438 2.263-.074 5.063.175.2 2.652.125 4.878c-.075 2.226-.187 2.822-.412 4.014s-.542 2.234-.95 3.126Q18 18.548 17.1 19.45q-1.324 1.326-2.812 1.938C12.8 22 12.283 22 11.25 22q-1.625 0-3.175-.638C6.525 20.724 6.15 20.35 5.4 19.6m2.8-.4q.725.424 1.488.612.762.189 1.562.188 1.15 0 2.275-.463c1.125-.463 1.467-.804 2.15-1.488q.45-.45.913-1.263.462-.813.8-2.126c.338-1.313.395-1.934.512-3.176q.175-1.864.05-4.44a57 57 0 0 0-2.762-.037q-1.538.012-3.063.237c-1.525.225-1.983.392-2.9.726q-1.375.5-2.25 1.375-1.125 1.126-1.55 2.226T5 13.696q0 1.476.563 2.589c.563 1.113.704 1.263.987 1.563q1.05-2.001 2.775-3.84a14.6 14.6 0 0 1 4.025-3.013 18.3 18.3 0 0 0-3.137 3.564Q8.875 16.548 8.2 19.2"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EcoLeaf.cjs"}],[1793,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 19h1.425L16.2 9.225 14.775 7.8 5 17.575zm-2 2v-4.25L16.2 3.575q.3-.275.663-.425c.363-.15.495-.15.762-.15s.525.05.775.15.467.25.65.45L20.425 5q.3.275.437.65c.137.375.138.5.138.75q0 .4-.138.763c-.138.363-.237.462-.437.662L7.25 21zM15.475 8.525l-.7-.725L16.2 9.225z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Edit.cjs"}],[1794,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587A1.92 1.92 0 0 1 3 19.003V5.02q0-.825.588-1.41c.587-.586.862-.588 1.412-.588h8.925l-2 1.998H5v13.983h14V12.06l2-1.997v8.939q0 .824-.587 1.41A1.93 1.93 0 0 1 19 21zm4-5.992v-4.245l9.175-9.164q.3-.3.675-.45T19.6 1a1.98 1.98 0 0 1 1.425.6l1.4 1.422q.275.3.425.662t.15.737-.137.736a1.9 1.9 0 0 1-.438.662l-9.175 9.189zm2-1.998h1.4l5.8-5.793-.7-.699-.725-.699L11 11.587z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EditSquare.cjs"}],[1795,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.55q0 .225-.025.475H17.95q.026-.25.038-.475c.012-.225.012-.3.012-.45V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3zm5 0v-3h-3v-2h3v-3h2v3h3v2h-3v3zm-6.5-7h3l-.575-3.225q.5-.25.788-.725C14 10.575 14 10.383 14 10q0-.825-.587-1.412C12.825 8 12.55 8 12 8s-1.02.196-1.412.588S10 9.45 10 10q0 .574.288 1.05c.287.476.454.558.787.725z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EncryptedAdd.cjs"}],[1796,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M17.241 18.5H22v2h-6.763zm-12.523 2-2.13-2.125Q2.014 17.8 2 16.95c-.013-.85.18-1.05.564-1.45l11.02-11.4q.576-.6 1.415-.6t1.416.575l4.984 4.975q.576.575.576 1.425t-.576 1.425l-8.416 8.6zm7.414-2 7.864-8.05-4.959-4.95-11.07 11.4 1.602 1.6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eraser.cjs"}],[1797,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S12.283 15 12 15s-.52.096-.712.287S11 15.717 11 16s.096.52.288.712.429.288.712.288m-1-4h2V7h-2zm1 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Error.cjs"}],[1798,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M17.934 12.188 12 15.812l-5.938-3.624L12 2zM12 16.977l-5.938-3.625L12 22l5.937-8.648z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ethereum.cjs"}],[1799,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 23q-2.8 0-5.15-1.275C4.5 20.45 4 19.742 3 18.325V21H1v-6h6v2H4.525q1.2 1.8 3.163 2.9C9.65 21 10.433 21 12 21q1.874 0 3.513-.712c1.638-.712 2.041-1.117 2.85-1.925s1.45-1.759 1.925-2.85S21 13.25 21 12h2q0 2.275-.862 4.275c-.863 2-1.363 2.5-2.363 3.5s-2.167 1.788-3.5 2.363S13.517 23 12 23m-.9-4v-1.3q-1.174-.274-1.912-1.012c-.739-.738-.855-1.138-1.088-1.938l1.65-.65q.3 1.025.938 1.538c.637.512.912.512 1.462.512s1.02-.13 1.413-.387.587-.663.587-1.213q0-.725-.612-1.175c-.613-.45-1.138-.642-2.188-1.025q-1.475-.525-2.162-1.25C8.5 10.375 8.5 9.983 8.5 9.2q0-1.024.713-1.863c.713-.839 1.12-.92 1.937-1.087V5h1.75v1.25q.9.075 1.638.725c.737.65.829.942 1.012 1.525l-1.6.65q-.2-.575-.65-.963c-.45-.388-.717-.387-1.25-.387q-.875 0-1.338.375c-.463.375-.462.592-.462 1.025s.192.775.575 1.025 1.075.542 2.075.875q1.8.65 2.4 1.525c.6.875.6 1.225.6 1.925q0 .725-.25 1.275c-.25.55-.388.68-.663.938s-.595.466-.962.624-.758.28-1.175.363V19zM1 12q0-2.276.863-4.275c.863-1.999 1.362-2.5 2.362-3.5s2.167-1.787 3.5-2.362S10.483 1 12 1q2.8 0 5.15 1.275C19.5 3.55 20 4.258 21 5.675V3h2v6h-6V7h2.475q-1.2-1.8-3.162-2.9C14.35 3 13.567 3 12 3q-1.874 0-3.512.712c-1.638.712-2.042 1.117-2.85 1.925s-1.45 1.759-1.925 2.85S3 10.75 3 12z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Exchange.cjs"}],[1800,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 21v-6h2v2.6l3.1-3.1 1.4 1.4L6.4 19H9v2zM15.9 9.5l-1.4-1.4L17.6 5H15V3h6v6h-2V6.4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Expand.cjs"}],[1801,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 22v-2h16v2zm8-3-4-4 1.4-1.4 1.6 1.55v-6.3L9.4 10.4 8 9l4-4 4 4-1.4 1.4L13 8.85v6.3l1.6-1.55L16 15zM4 4V2h16v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExpandVertical.cjs"}],[1802,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m7.5 16.5 7-2 2-7-7 2zm4.5-3q-.625 0-1.062-.437c-.438-.438-.438-.646-.438-1.063s.146-.77.438-1.062.645-.438 1.062-.438.77.146 1.063.438.437.645.437 1.062-.146.77-.437 1.063-.646.437-1.063.437m0 8.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Explore.cjs"}],[1803,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m7.5 16.5 7-2 2-7-7 2zm4.5-3q-.625 0-1.062-.437c-.438-.438-.438-.646-.438-1.063s.146-.77.438-1.062.645-.438 1.062-.438.77.146 1.063.438.437.645.437 1.062-.146.77-.437 1.063-.646.437-1.063.437m0 8.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExploreFilled.cjs"}],[1804,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h7v2H5v14h14v-7h2v7q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Export.cjs"}],[1805,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8.8 21H5q-.824 0-1.412-.587C3 19.826 3 19.55 3 19v-3.8q1.2 0 2.1-.762c.9-.763.9-1.155.9-1.938s-.3-1.43-.9-1.937S3.8 9.8 3 9.8V6q0-.825.588-1.412C4.176 4 4.45 4 5 4h4q0-1.05.725-1.775T11.5 1.5c1.05 0 1.292.242 1.775.725S14 3.3 14 4h4q.824 0 1.413.588C20.002 5.176 20 5.45 20 6v4q1.05 0 1.775.725c.725.725.725 1.075.725 1.775s-.242 1.292-.725 1.775S20.7 15 20 15v4q0 .824-.587 1.413c-.587.589-.863.587-1.413.587h-3.8q0-1.25-.787-2.125C12.625 18 12.25 18 11.5 18s-1.387.292-1.912.875S8.8 20.167 8.8 21M5 19h2.125q.6-1.65 1.925-2.325C10.375 16 10.75 16 11.5 16s1.567.225 2.45.675S15.475 17.9 15.875 19H18v-6h2q.2 0 .35-.15c.15-.15.15-.217.15-.35s-.05-.25-.15-.35S20.133 12 20 12h-2V6h-6V4q0-.2-.15-.35c-.15-.15-.217-.15-.35-.15s-.25.05-.35.15S11 3.867 11 4v2H5v2.2q1.35.5 2.175 1.675Q8 11.049 8 12.5q0 1.425-.825 2.6C6.35 16.275 5.9 16.45 5 16.8z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Extension.cjs"}],[1806,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 15.886q1.875 0 3.188-1.313C16.5 13.26 16.5 12.636 16.5 11.386s-.437-2.313-1.312-3.188S13.25 6.886 12 6.886s-2.312.437-3.187 1.312S7.5 10.136 7.5 11.386s.438 2.312 1.313 3.187S10.75 15.886 12 15.886m0-1.8q-1.125 0-1.912-.788C9.3 12.51 9.3 12.136 9.3 11.386s.263-1.388.788-1.913S11.25 8.686 12 8.686s1.388.262 1.913.787.787 1.163.787 1.913-.262 1.387-.787 1.912-1.163.788-1.913.788m0 4.8q-3.65 0-6.65-2.038c-3-2.038-3.45-3.18-4.35-5.462Q2.35 7.96 5.35 5.922T12 3.885t6.65 2.038T23 11.385q-1.35 3.426-4.35 5.463c-3 2.037-4.217 2.038-6.65 2.038m0-2q2.825 0 5.188-1.488c2.363-1.488 2.779-2.33 3.612-4.012a9.77 9.77 0 0 0-3.612-4.013Q14.825 5.886 12 5.886c-2.825 0-3.612.495-5.187 1.487A9.77 9.77 0 0 0 3.2 11.386q1.25 2.524 3.613 4.012c2.363 1.488 3.304 1.488 5.187 1.488"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eye.cjs"}],[1807,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m16.1 13.186-1.45-1.45q.225-1.176-.675-2.2t-2.325-.8l-1.45-1.45a4.2 4.2 0 0 1 .863-.3 4.2 4.2 0 0 1 .937-.1q1.875 0 3.188 1.312C16.5 9.51 16.5 10.135 16.5 11.386q0 .5-.1.937t-.3.863m3.2 3.15-1.45-1.4q.95-.726 1.688-1.588c.738-.862.912-1.23 1.262-1.963q-1.25-2.524-3.587-4.012T12 5.886q-.725 0-1.425.1a10 10 0 0 0-1.375.3l-1.55-1.55a11.1 11.1 0 0 1 4.35-.85q3.775 0 6.725 2.087T23 11.385a11.7 11.7 0 0 1-1.512 2.738 11 11 0 0 1-2.188 2.212m.5 6.15-4.2-4.15q-.874.274-1.762.412T12 18.886q-3.775 0-6.725-2.088T1 11.386q.525-1.326 1.325-2.463A11.5 11.5 0 0 1 4.15 6.886l-2.75-2.8 1.4-1.4 18.4 18.4zM5.55 8.286q-.725.65-1.325 1.425A9 9 0 0 0 3.2 11.386q1.25 2.524 3.588 4.012T12 16.886q.5 0 .975-.063t.975-.137l-.9-.95q-.274.075-.525.112a3 3 0 0 1-.525.038q-1.875 0-3.188-1.313C7.5 13.26 7.5 12.636 7.5 11.386q0-.276.037-.525.038-.25.113-.525z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EyeSlash.cjs"}],[1808,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M3.682 5.48v2.167a.84.84 0 0 1-1.682 0V5.479C2 3.56 3.56 2 5.48 2h2.167a.84.84 0 0 1 0 1.682H5.479a1.8 1.8 0 0 0-1.797 1.797m3.965 14.838a.84.84 0 0 1 0 1.682H5.479A3.483 3.483 0 0 1 2 18.52v-2.167a.84.84 0 0 1 1.682 0v2.168a1.8 1.8 0 0 0 1.797 1.797zM22 16.353v2.168C22 20.44 20.44 22 18.52 22h-2.167a.84.84 0 0 1 0-1.682h2.168a1.8 1.8 0 0 0 1.797-1.797v-2.168a.84.84 0 0 1 1.682 0M22 5.48v2.168a.84.84 0 0 1-1.682 0V5.479a1.8 1.8 0 0 0-1.797-1.797h-2.168a.84.84 0 1 1 0-1.682h2.168C20.439 2 22 3.56 22 5.48m-8.631 4.146v3.619c0 .91-.74 1.651-1.652 1.651h-.414a.86.86 0 1 1 0-1.72h.346v-3.55a.86.86 0 0 1 1.72 0m3.505-.028v1.451a.831.831 0 1 1-1.663 0v-1.45a.831.831 0 0 1 1.663 0M8.07 11.88a.83.83 0 0 1-.832-.832v-1.45a.831.831 0 0 1 1.663 0v1.45c0 .46-.372.832-.831.832",clipRule:"evenodd"}),s.createElement("path",{d:"M15.62 16.872a.86.86 0 0 0-1.167-1.263c-.67.618-1.54.959-2.453.959s-1.783-.34-2.453-.96a.86.86 0 0 0-1.167 1.264c.988.912 2.274 1.415 3.62 1.415s2.631-.503 3.62-1.415"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FaceId.cjs"}],[1809,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 15q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 13 12 13s-.52.096-.712.288S11 13.717 11 14s.096.52.288.713.429.287.712.287m-1-4h2V5h-2zM2 22V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6zm3.15-6H20V4H4v13.125z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Feedback.cjs"}],[1810,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/File.cjs"}],[1811,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M10 18v-2h4v2zm-4-5v-2h12v2zM3 8V6h18v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Filter.cjs"}],[1812,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11.97 4.468q2.65 0 5 1.137a10.45 10.45 0 0 1 3.926 3.288q.174.225.112.4a.7.7 0 0 1-.212.3.48.48 0 0 1-.35.112q-.2-.012-.35-.212a9.05 9.05 0 0 0-3.538-2.988q-2.162-1.037-4.587-1.037c-2.425 0-3.134.346-4.55 1.037a9.3 9.3 0 0 0-3.525 2.988q-.15.225-.35.25a.44.44 0 0 1-.35-.1q-.175-.126-.213-.313c-.038-.187.013-.254.113-.387a10.7 10.7 0 0 1 3.887-3.3 10.95 10.95 0 0 1 4.988-1.175m0 2.35q3.376 0 5.8 2.25 2.426 2.25 2.426 5.575 0 1.25-.888 2.087-.887.838-2.162.838c-1.275 0-1.58-.28-2.188-.838q-.912-.837-.912-2.087 0-.825-.613-1.388c-.613-.563-.896-.562-1.462-.562s-1.055.187-1.463.562-.612.838-.612 1.388q0 2.424 1.437 4.05 1.437 1.624 3.713 2.275.225.075.3.25a.575.575 0 0 1-.175.675q-.15.125-.375.075-2.6-.65-4.25-2.588-1.65-1.937-1.65-4.737 0-1.251.9-2.1t2.175-.85c1.275 0 1.575.283 2.175.85q.9.849.9 2.1 0 .825.625 1.387c.625.562.908.563 1.475.563s1.05-.188 1.45-.563.6-.837.6-1.387q0-2.901-2.125-4.875t-5.075-1.975c-2.95 0-3.659.658-5.075 1.975q-2.125 1.974-2.125 4.85 0 .6.112 1.5c.112.9.254 1.3.538 2.1q.075.225-.013.4a.5.5 0 0 1-.287.25.496.496 0 0 1-.65-.3q-.376-.975-.538-1.938a12 12 0 0 1-.162-1.987q0-3.325 2.412-5.575t5.763-2.25m0-4.8q1.6 0 3.126.387 1.525.389 2.95 1.113.225.125.262.3a.57.57 0 0 1-.037.35.57.57 0 0 1-.25.275q-.176.1-.425-.025a13.3 13.3 0 0 0-2.738-1.038 11.6 11.6 0 0 0-2.887-.362q-1.45 0-2.85.337-1.4.338-2.675 1.063a.47.47 0 0 1-.4.062.5.5 0 0 1-.3-.262.48.48 0 0 1-.05-.363q.05-.162.25-.287 1.4-.75 2.925-1.15t3.1-.4m0 7.225q2.326 0 4 1.562 1.676 1.563 1.676 3.838a.5.5 0 0 1-.138.362.5.5 0 0 1-.362.138.5.5 0 0 1-.35-.138.47.47 0 0 1-.15-.362q0-1.875-1.388-3.138t-3.287-1.262c-1.9 0-2.355.42-3.263 1.262q-1.362 1.263-1.362 3.138 0 2.025.7 3.437.7 1.413 2.05 2.838a.48.48 0 0 1 0 .7.48.48 0 0 1-.7 0q-1.476-1.55-2.263-3.163c-.787-1.613-.787-2.346-.787-3.812q0-2.275 1.65-3.838 1.65-1.562 3.975-1.562m-.024 4.9q.225 0 .362.15c.137.15.138.216.138.35q0 1.875 1.35 3.075c1.35 1.2 1.95 1.2 3.15 1.2q.15 0 .425-.025t.575-.075q.225-.05.387.062c.162.112.18.188.213.338q.05.2-.075.35a.48.48 0 0 1-.325.2q-.45.125-.788.137-.337.013-.412.013-2.226 0-3.863-1.5c-1.637-1.5-1.637-2.259-1.637-3.775q0-.2.137-.35c.137-.15.213-.15.363-.15"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fingerprint.cjs"}],[1813,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 14q0 1.3.525 2.463c.525 1.162.85 1.454 1.5 2.037A1 1 0 0 1 8 18.275v-.225q0-.8.3-1.5c.3-.7.492-.892.875-1.275L12 12.5l2.825 2.775q.575.575.875 1.275c.3.7.3.967.3 1.5v.225q0 .1-.025.225.975-.874 1.5-2.037C18 15.298 18 14.866 18 14q0-1.249-.462-2.363c-.462-1.114-.755-1.404-1.338-1.987q-.5.326-1.05.487c-.55.161-.742.163-1.125.163q-1.55 0-2.687-1.025C10.2 8.25 10.142 7.75 10.025 6.75Q9.05 7.575 8.3 8.462c-.75.887-.92 1.192-1.262 1.8q-.513.914-.775 1.863C6 13.074 6 13.383 6 14m6 1.3-1.425 1.4q-.275.275-.425.625c-.15.35-.15.475-.15.725q0 .8.587 1.375C11.174 20 11.45 20 12 20s1.02-.192 1.412-.575.588-.842.588-1.375q0-.4-.15-.737a1.6 1.6 0 0 0-.425-.613zM12 3v3.3q0 .85.588 1.425c.588.575.87.575 1.437.575q.45 0 .838-.188c.388-.188.487-.312.687-.562L16 7q1.85 1.05 2.925 2.925C20 11.8 20 12.533 20 14q0 3.35-2.325 5.675C15.35 22 14.233 22 12 22q-3.35 0-5.675-2.325C4 17.35 4 16.233 4 14q0-3.225 2.163-6.125C8.325 4.975 9.55 4.317 12 3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fire.cjs"}],[1814,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5.8 18V6h2v12zm11 0-6-6 6-6 1.4 1.4-4.6 4.6 4.6 4.6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FirstPage.cjs"}],[1815,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 20.5v-17h9l.4 2H20v10h-7l-.4-2H7v7zm9.65-7H18v-6h-5.25l-.4-2H7v6h7.25z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flag.cjs"}],[1816,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 15.486 3.2-4.6h-2.85l2-7H9v8h3zm-2 6.4v-8H7v-12h10l-2 7h4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flash.cjs"}],[1817,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 1.886h10l-2 7h4l-2.925 4.225-1.425-1.426.55-.8h-1.35L12.675 9.71l1.675-5.825H9v2.15l-2-2zm3 20v-8H7v-4.15L1.375 4.11 2.8 2.686l18.4 18.4-1.425 1.425-6.025-6.025z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FlashSlash.cjs"}],[1818,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-1.275 0-1.812-1.137t.262-2.113L9 11V5H8a.97.97 0 0 1-.712-.287Q7 4.425 7 4c0-.425.096-.52.288-.712A.97.97 0 0 1 8 3h8q.425 0 .713.288C17 3.576 17 3.717 17 4s-.096.52-.287.713S16.283 5 16 5h-1v6l5.55 6.75q.8.975.263 2.113C20.276 21 19.85 21 19 21zm2-3h10l-3.4-4h-3.2zm-2 1h14l-6-7.3V5h-2v6.7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flask.cjs"}],[1819,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M10.65 20a5.7 5.7 0 0 0-1.4-2.225q-.475-.476-1.025-.837c-.55-.361-.767-.438-1.2-.588q.05.725.35 1.35c.3.625.467.792.8 1.125s.708.604 1.125.813.867.329 1.35.362m2.7 0q.725-.075 1.35-.375c.625-.3.792-.467 1.125-.8s.6-.708.8-1.125.325-.867.375-1.35q-.65.225-1.212.575c-.563.35-.721.508-1.038.825s-.592.662-.825 1.037-.425.78-.575 1.213M12 11q1.65 0 2.825-1.175T16 7V5.8l-1.75 1.475L12 4.55 9.75 7.275 8 5.8V7q0 1.65 1.175 2.825T12 11m-1 11q-2.5 0-4.25-1.75C5 18.5 5 17.667 5 16v-2q1.775-.025 3.35.725c1.575.75 1.933 1.175 2.65 2.025v-3.825q-2.15-.35-3.575-2.013T6 7V3.6q0-.65.575-.912c.575-.262.742-.121 1.075.162l1.85 1.6 1.725-2.1Q11.525 2 12 2c.475 0 .575.117.775.35l1.725 2.1 1.85-1.6q.5-.425 1.075-.162C18 2.95 18 3.167 18 3.6V7q0 2.25-1.425 3.913T13 12.925v3.825q1.075-1.275 2.65-2.025c1.575-.75 2.167-.742 3.35-.725v2q0 2.5-1.75 4.25C15.5 22 14.667 22 13 22z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flower.cjs"}],[1820,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h6l2 2h8q.824 0 1.413.588C22.002 7.176 22 7.45 22 8v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h16V8h-8.825l-2-2H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Folder.cjs"}],[1821,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("clipPath",{id:"a"},s.createElement("path",{d:"M0 0h24v24H0z"})),s.createElement("g",{clipPath:"url(#a)"},s.createElement("path",{d:"M7 22v-4H0l3.85-6H2L9 2l3 4.3L15 2l7 10h-1.85L24 18h-7v4h-4v-4h-2v4zm9.725-6h3.625l-3.875-6h1.675L15 5.5l-1.775 2.525L16 12h-1.85zM3.65 16h10.7l-3.875-6h1.675L9 5.5 5.85 10h1.675zm0 0h3.875H5.85h6.3-1.675 3.875zm13.075 0H14.15 16h-2.775 4.925-1.675 3.875z"}))));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Forest.cjs"}],[1822,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FullCircle.cjs"}],[1823,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 21V5q0-.824.588-1.412C5.176 2.999 5.45 3 6 3h6q.824 0 1.413.588C14 4.175 14 4.45 14 5v7h1q.824 0 1.413.588c.589.588.587.862.587 1.412v4.5q0 .424.288.713c.288.288.429.287.712.287s.52-.096.713-.287.287-.43.287-.713v-7.2q-.225.125-.475.163c-.25.038-.342.037-.525.037q-1.05 0-1.775-.725C15.5 10.05 15.5 9.7 15.5 9q0-.8.438-1.437c.438-.637.679-.73 1.162-.913L15 4.55l1.05-1.05 3.7 3.6q.375.375.563.875c.188.5.187.675.187 1.025v9.5q0 1.05-.725 1.775C19.05 21 18.7 21 18 21s-1.292-.242-1.775-.725S15.5 19.2 15.5 18.5v-5H14V21zm2-11h6V5H6zm12 0q.424 0 .713-.287C19 9.426 19 9.283 19 9s-.096-.52-.287-.712S18.283 8 18 8s-.52.096-.712.288S17 8.717 17 9s.096.52.288.713.429.287.712.287M6 19h6v-7H6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gas.cjs"}],[1824,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 22V11H2V5h5.2q-.125-.225-.162-.475A3 3 0 0 1 7 4q0-1.25.875-2.125C8.75 1 9.167 1 10 1q.575 0 1.075.213c.5.212.642.337.925.587q.425-.4.925-.6c.5-.2.692-.2 1.075-.2q1.25 0 2.125.875C17 2.75 17 3.167 17 4q0 .274-.05.513c-.05.239-.083.32-.15.487H22v6h-2v11zM14 3q-.424 0-.712.288C12.999 3.576 13 3.717 13 4s.096.52.288.713S13.717 5 14 5s.52-.096.713-.287S15 4.283 15 4s-.096-.52-.287-.712S14.283 3 14 3M9 4q0 .424.288.713c.287.289.429.287.712.287q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S10.283 3 10 3q-.424 0-.712.288C8.999 3.576 9 3.717 9 4M4 7v2h7V7zm7 13v-9H6v9zm2 0h5v-9h-5zm7-11V7h-7v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gift.cjs"}],[1825,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-2.05 0-3.875-.787c-1.825-.788-2.28-1.242-3.187-2.15s-1.625-1.971-2.15-3.188S2 13.367 2 12q0-2.075.788-3.887c.788-1.812 1.241-2.267 2.15-3.175s1.97-1.625 3.187-2.15S10.633 2 12 2q2.075 0 3.888.788c1.812.788 2.266 1.241 3.174 2.15s1.625 1.966 2.15 3.175S22 10.617 22 12q0 2.05-.787 3.875c-.788 1.825-1.242 2.28-2.15 3.188s-1.967 1.625-3.175 2.15S13.383 22 12 22m0-2.05q.65-.9 1.125-1.875c.475-.975.575-1.342.775-2.075h-3.8q.3 1.1.775 2.075c.475.975.692 1.275 1.125 1.875m-2.6-.4q-.45-.825-.787-1.712A11.6 11.6 0 0 1 8.05 16H5.1q.725 1.25 1.813 2.175C8 19.1 8.467 19.25 9.4 19.55m5.2 0q1.4-.45 2.488-1.375c1.088-.925 1.329-1.342 1.812-2.175h-2.95q-.225.95-.562 1.838c-.337.887-.488 1.162-.788 1.712M4.25 14h3.4q-.075-.5-.112-.987C7.5 12.525 7.5 12.35 7.5 12a13 13 0 0 1 .15-2h-3.4q-.125.5-.187.988C4 11.476 4 11.65 4 12a8 8 0 0 0 .25 2m5.4 0h4.7q.075-.5.113-.987c.038-.488.037-.663.037-1.013a13 13 0 0 0-.15-2h-4.7q-.075.5-.112.988C9.5 11.476 9.5 11.65 9.5 12a13 13 0 0 0 .15 2m6.7 0h3.4q.125-.5.188-.987C20 12.525 20 12.35 20 12a8 8 0 0 0-.25-2h-3.4q.075.5.113.988c.038.488.037.662.037 1.012a13 13 0 0 1-.15 2m-.4-6h2.95q-.725-1.25-1.812-2.175C16 4.9 15.533 4.75 14.6 4.45q.45.824.788 1.713c.338.888.412 1.204.562 1.837M10.1 8h3.8q-.3-1.1-.775-2.075C12.65 4.95 12.433 4.65 12 4.05q-.65.9-1.125 1.875C10.4 6.9 10.3 7.267 10.1 8m-5 0h2.95q.225-.95.563-1.837C8.95 5.275 9.1 5 9.4 4.45Q8 4.9 6.913 5.825C5.826 6.75 5.583 7.167 5.1 8"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Global.cjs"}],[1826,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11.75 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.063 17.117 2.538 15.9 1.75 13.383 1.75 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.633 3.312 7.85 2.787 10.367 2 11.75 2q3.65 0 6.388 2.287c2.737 2.287 2.962 3.438 3.412 5.738H19.5q-.475-1.825-1.712-3.263C16.55 5.324 15.95 5.083 14.75 4.6V5q0 .825-.587 1.412C13.576 7 13.3 7 12.75 7h-2v2q0 .424-.287.712c-.287.288-.43.288-.713.288h-2v2h2v3h-1l-4.8-4.8q-.075.45-.137.9c-.062.45-.063.6-.063.9q0 3.274 2.3 5.625c2.3 2.351 3.433 2.358 5.7 2.375zm9.1-.5-3.2-3.2q-.525.3-1.125.5c-.6.2-.825.2-1.275.2q-1.875 0-3.187-1.312C10.75 16.375 10.75 15.75 10.75 14.5s.438-2.312 1.313-3.187S14 10 15.25 10s2.313.438 3.188 1.313S19.75 13.25 19.75 14.5q0 .675-.2 1.275c-.2.6-.3.775-.5 1.125l3.2 3.2zm-5.6-4.5q1.05 0 1.775-.725c.725-.725.725-1.075.725-1.775s-.242-1.292-.725-1.775S15.95 12 15.25 12s-1.292.242-1.775.725-.725 1.075-.725 1.775.242 1.292.725 1.775S14.55 17 15.25 17"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/GlobalSearch.cjs"}],[1827,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 21.975q-2.075 0-3.9-.788c-1.825-.788-2.275-1.241-3.175-2.15s-1.612-1.97-2.137-3.187S2 13.342 2 11.975q0-3.925 2.6-6.75t6.4-3.2v3q-2.576.35-4.287 2.312Q5 9.301 5 11.975q0 2.9 2.05 4.95c2.05 2.05 3.017 2.05 4.95 2.05q1.65 0 3.088-.7c1.438-.7 1.762-1.1 2.412-1.9l2.6 1.5q-1.35 1.875-3.475 2.987C14.5 21.974 13.667 21.975 12 21.975m9.15-5.95-2.6-1.5q.225-.6.337-1.238c.112-.638.113-.862.113-1.312q0-2.675-1.713-4.638Q15.575 5.375 13 5.025v-3q3.8.375 6.4 3.2t2.6 6.75q0 1.1-.2 2.125c-.2 1.025-.35 1.325-.65 1.925"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Graph.cjs"}],[1828,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 21q-1.25 0-2.125-.875C1 19.25 1 18.833 1 18q0-.975.563-1.75c.563-.775.854-.875 1.437-1.075v-6.35q-.875-.3-1.437-1.075C1 6.975 1 6.65 1 6q0-1.25.875-2.125C2.75 3 3.167 3 4 3s1.542.292 2.125.875S7 5.167 7 6q0 .975-.562 1.75c-.562.775-.855.875-1.438 1.075V11h6V8.825q-.875-.3-1.437-1.075C9 6.975 9 6.65 9 6q0-1.25.875-2.125T12 3c1.25 0 1.542.292 2.125.875S15 5.167 15 6q0 .975-.562 1.75c-.563.775-.855.875-1.438 1.075V11h5q.424 0 .713-.287C19 10.426 19 10.283 19 10V8.825q-.875-.3-1.437-1.075C17 6.975 17 6.65 17 6q0-1.25.875-2.125C18.75 3 19.167 3 20 3s1.542.292 2.125.875S23 5.167 23 6q0 .975-.562 1.75c-.562.775-.855.875-1.438 1.075V10q0 1.25-.875 2.125C19.25 13 18.833 13 18 13h-5v2.175q.875.3 1.438 1.075C15 17.025 15 17.35 15 18q0 1.25-.875 2.125C13.25 21 12.833 21 12 21s-1.542-.292-2.125-.875A2.9 2.9 0 0 1 9 18q0-.975.563-1.75c.562-.775.854-.875 1.437-1.075V13H5v2.175q.875.3 1.438 1.075C7 17.025 7 17.35 7 18q0 1.25-.875 2.125C5.25 21 4.833 21 4 21m0-2q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S4.283 17 4 17s-.52.096-.712.288S3 17.717 3 18s.096.52.288.713S3.717 19 4 19M4 7q.424 0 .713-.287C5.002 6.426 5 6.283 5 6s-.096-.52-.287-.712S4.283 5 4 5s-.52.096-.712.288S3 5.717 3 6s.096.52.288.713S3.717 7 4 7m8 12q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S12.283 17 12 17s-.52.096-.712.288S11 17.717 11 18s.096.52.288.713.429.287.712.287m0-12q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 5 12 5s-.52.096-.712.288S11 5.717 11 6s.096.52.288.713S11.717 7 12 7m8 0q.424 0 .713-.287C21 6.426 21 6.283 21 6s-.096-.52-.287-.712S20.283 5 20 5s-.52.096-.712.288S19 5.717 19 6s.096.52.288.713S19.717 7 20 7"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hardware.cjs"}],[1829,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m6 20 1-4H3l.5-2h4l1-4h-4L5 8h4l1-4h2l-1 4h4l1-4h2l-1 4h4l-.5 2h-4l-1 4h4l-.5 2h-4l-1 4h-2l1-4H9l-1 4zm3.5-6h4l1-4h-4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/HashTag.cjs"}],[1830,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 21-1.45-1.3q-2.525-2.275-4.175-3.925c-1.65-1.65-1.975-2.088-2.625-2.963S2.646 11.133 2.388 10.4A6.7 6.7 0 0 1 2 8.15Q2 5.8 3.575 4.225C5.15 2.65 5.933 2.65 7.5 2.65a5.8 5.8 0 0 1 2.475.55A5.9 5.9 0 0 1 12 4.75a5.9 5.9 0 0 1 2.025-1.55 5.8 5.8 0 0 1 2.475-.55q2.35 0 3.925 1.575C22 5.8 22 6.583 22 8.15q0 1.15-.387 2.25-.388 1.1-1.363 2.412c-.975 1.312-1.525 1.863-2.625 2.963s-2.492 2.408-4.175 3.925zm0-2.7q2.4-2.15 3.95-3.687c1.55-1.537 1.85-1.917 2.45-2.675q.9-1.139 1.25-2.025.35-.888.35-1.763 0-1.5-1-2.5t-2.5-1a3.86 3.86 0 0 0-2.175.663q-1 .662-1.375 1.687h-1.9q-.375-1.025-1.375-1.687A3.86 3.86 0 0 0 7.5 4.65q-1.5 0-2.5 1t-1 2.5q0 .874.35 1.763.35.886 1.25 2.025t2.45 2.674C9.6 16.15 10.4 16.868 12 18.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Heart.cjs"}],[1831,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 21-1.45-1.3q-2.525-2.275-4.175-3.925c-1.65-1.65-1.975-2.088-2.625-2.963S2.646 11.133 2.388 10.4A6.7 6.7 0 0 1 2 8.15Q2 5.8 3.575 4.225C5.15 2.65 5.933 2.65 7.5 2.65a5.8 5.8 0 0 1 2.475.55A5.9 5.9 0 0 1 12 4.75a5.9 5.9 0 0 1 2.025-1.55 5.8 5.8 0 0 1 2.475-.55q2.35 0 3.925 1.575C22 5.8 22 6.583 22 8.15q0 1.15-.387 2.25-.388 1.1-1.363 2.412c-.975 1.312-1.525 1.863-2.625 2.963s-2.492 2.408-4.175 3.925z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/HeartFilled.cjs"}],[1832,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 22q-1.25 0-2.125-.875C4 20.25 4 19.833 4 19q0-.975.563-1.75c.563-.775.854-.875 1.437-1.075v-8.35q-.875-.3-1.437-1.075C4 5.975 4 5.65 4 5q0-1.25.875-2.125C5.75 2 6.167 2 7 2s1.542.292 2.125.875S10 4.167 10 5q0 .975-.562 1.75c-.563.775-.855.875-1.438 1.075V8q0 1.25.875 2.125A2.9 2.9 0 0 0 11 11h2q2.075 0 3.538 1.463C18 13.926 18 14.617 18 16v.175q.875.3 1.438 1.075C20 18.025 20 18.35 20 19q0 1.25-.875 2.125C18.25 22 17.833 22 17 22s-1.542-.292-2.125-.875S14 19.833 14 19q0-.975.563-1.75c.562-.775.854-.875 1.437-1.075V16q0-1.25-.875-2.125C14.25 13 13.833 13 13 13h-2a4.92 4.92 0 0 1-3-1v4.175q.875.3 1.437 1.075C10 18.025 10 18.35 10 19q0 1.25-.875 2.125C8.25 22 7.833 22 7 22m0-2q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S7.283 18 7 18s-.52.096-.712.288S6 18.717 6 19s.096.52.288.713S6.717 20 7 20m10 0q.424 0 .713-.287C18 19.425 18 19.283 18 19s-.096-.52-.287-.712S17.283 18 17 18s-.52.096-.712.288S16 18.717 16 19s.096.52.288.713.429.287.712.287M7 6q.424 0 .713-.287C8.002 5.426 8 5.283 8 5s-.096-.52-.287-.712S7.283 4 7 4s-.52.096-.712.287S6 4.717 6 5s.096.52.288.713S6.717 6 7 6"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hierarchy.cjs"}],[1833,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 18.886h3v-6h6v6h3v-9l-6-4.5-6 4.5zm-2 2v-12l8-6 8 6v12h-7v-6h-2v6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Home.cjs"}],[1834,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 20.886v-12l8-6 8 6v12h-6v-7h-4v7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/HomeFilled.cjs"}],[1835,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5zm1-2h12l-3.75-5-3 4L9 13z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Image.cjs"}],[1836,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 17h2v-6h-2zm1-8q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 7 12 7s-.52.096-.712.288S11 7.717 11 8s.096.52.288.713S11.717 9 12 9m0 13q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Info.cjs"}],[1837,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 22q-.824 0-1.412-.587C2.999 20.826 3 20.55 3 20V8.725q-.45-.274-.725-.712C2 7.573 2 7.382 2 7V4q0-.824.588-1.413C3.175 1.998 3.45 2 4 2h16q.824 0 1.413.587C22.002 3.174 22 3.45 22 4v3q0 .574-.275 1.012c-.275.438-.425.53-.725.713V20q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zM5 9v11h14V9zM4 7h16V4H4zm5 7h6v-2H9z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Inventory.cjs"}],[1838,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m6.8 13 5.2 3 5.2-3-4.2-2.425V14h-2v-3.425zM11 8.275V7.85q-1.1-.326-1.8-1.237C8.5 5.702 8.5 5.3 8.5 4.5q0-1.45 1.025-2.475T12 1c1.45 0 1.792.342 2.475 1.025S15.5 3.533 15.5 4.5q0 1.2-.7 2.113c-.7.913-1.067 1.02-1.8 1.237v.425l7 4.025q.475.275.738.738c.263.463.262.645.262 1.012v1.9q0 .55-.262 1.013c-.262.463-.421.554-.738.737l-7 4.025Q12.525 22 12 22c-.525 0-.683-.092-1-.275L4 17.7q-.475-.276-.737-.737C3 16.502 3 16.317 3 15.95v-1.9q0-.55.263-1.012c.263-.462.42-.555.737-.738zm0 9.45-6-3.45v1.675L12 20l7-4.05v-1.675l-6 3.45Q12.525 18 12 18c-.525 0-.683-.092-1-.275M12 6q.624 0 1.063-.437c.438-.437.437-.646.437-1.063s-.146-.77-.437-1.062S12.417 3 12 3s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063S11.583 6 12 6"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Joystick.cjs"}],[1839,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m16 12 2 2v2h-5v6l-1 1-1-1v-6H6v-2l2-2V5H7V3h10v2h-1zm-7.15 2h6.3L14 12.85V5h-4v7.85z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Keep.cjs"}],[1840,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m16 12 2 2v2h-5v6l-1 1-1-1v-6H6v-2l2-2V5H7V3h10v2h-1z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/KeepFilled.cjs"}],[1841,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 14q-.824 0-1.412-.587C5 12.825 5 12.55 5 12s.196-1.02.588-1.412S6.45 10 7 10s1.02.196 1.413.588S9 11.45 9 12s-.196 1.02-.587 1.413S7.55 14 7 14m0 4q-2.5 0-4.25-1.75C1 14.5 1 13.667 1 12s.583-3.083 1.75-4.25S5.333 6 7 6q1.676 0 3.038.825A6.2 6.2 0 0 1 12.2 9H21l3 3-4.5 4.5-2-1.5-2 1.5-2.125-1.5H12.2a6.2 6.2 0 0 1-2.162 2.175Q8.675 18 7 18m0-2q1.4 0 2.463-.85A4.03 4.03 0 0 0 10.875 13H14l1.45 1.025L17.5 12.5l1.775 1.375L21.15 12l-1-1h-9.275a4.03 4.03 0 0 0-1.413-2.15Q8.4 8 7 8 5.35 8 4.175 9.175C3 10.35 3 10.9 3 12s.392 2.042 1.175 2.825S5.9 16 7 16"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Key.cjs"}],[1842,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m7.2 18-1.4-1.4 4.6-4.6-4.6-4.6L7.2 6l6 6zm9 0V6h2v12z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LastPage.cjs"}],[1843,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 15q1.25 0 2.125-.875C15 13.25 15 12.833 15 12s-.292-1.542-.875-2.125Q13.25 9 12 9c-1.25 0-1.542.292-2.125.875Q9 10.75 9 12c0 1.25.292 1.542.875 2.125A2.9 2.9 0 0 0 12 15m0 2q-2.075 0-3.537-1.462C7 14.075 7 13.383 7 12s.488-2.562 1.463-3.537S10.617 7 12 7s2.563.488 3.538 1.463S17 10.617 17 12s-.487 2.563-1.462 3.538S13.383 17 12 17m-7-4H1v-2h4zm18 0h-4v-2h4zM11 5V1h2v4zm0 18v-4h2v4zM6.4 7.75 3.875 5.325 5.3 3.85l2.4 2.5zm12.3 12.4-2.425-2.525L17.6 16.25l2.525 2.425zM16.25 6.4l2.425-2.525L20.15 5.3l-2.5 2.4zM3.85 18.7l2.525-2.425L7.75 17.6l-2.425 2.525z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Light.cjs"}],[1844,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 17q-2.075 0-3.537-1.462C7 14.075 7 13.383 7 12s.488-2.562 1.463-3.537S10.617 7 12 7s2.563.488 3.538 1.463S17 10.617 17 12s-.487 2.563-1.462 3.538S13.383 17 12 17m-7-4H1v-2h4zm18 0h-4v-2h4zM11 5V1h2v4zm0 18v-4h2v4zM6.4 7.75 3.875 5.325 5.3 3.85l2.4 2.5zm12.3 12.4-2.425-2.525L17.6 16.25l2.525 2.425zM16.25 6.4l2.425-2.525L20.15 5.3l-2.5 2.4zM3.85 18.7l2.525-2.425L7.75 17.6l-2.425 2.525z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LightFilled.cjs"}],[1845,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 17H7q-2.074 0-3.537-1.462C1.999 14.075 2 13.383 2 12s.488-2.562 1.463-3.537S5.617 7 7 7h4v2H7q-1.25 0-2.125.875T4 12c0 1.25.292 1.542.875 2.125S6.167 15 7 15h4zm-3-4v-2h8v2zm5 4v-2h4q1.25 0 2.125-.875C20 13.25 20 12.833 20 12s-.292-1.542-.875-2.125A2.9 2.9 0 0 0 17 9h-4V7h4q2.075 0 3.538 1.463C22 9.926 22 10.617 22 12s-.487 2.563-1.462 3.538S18.383 17 17 17z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Link.cjs"}],[1846,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-2.05 0-3.875-.787c-1.825-.788-2.28-1.242-3.187-2.15s-1.625-1.971-2.15-3.188S2 13.367 2 12q0-2.075.788-3.887c.788-1.812 1.241-2.267 2.15-3.175s1.97-1.625 3.187-2.15S10.633 2 12 2q.424 0 .713.288c.289.288.287.429.287.712s-.096.52-.287.713S12.283 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-.424.288-.712C20.576 11 20.717 11 21 11s.52.096.713.288.287.429.287.712q0 2.05-.787 3.875c-.788 1.825-1.242 2.28-2.15 3.188s-1.967 1.625-3.175 2.15S13.383 22 12 22"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Loading.cjs"}],[1847,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 12q.824 0 1.413-.587C14 10.825 14 10.55 14 10s-.196-1.02-.587-1.412S12.55 8 12 8s-1.02.196-1.412.588S10 9.45 10 10s.196 1.02.588 1.413S11.45 12 12 12m0 7.35q3.05-2.8 4.525-5.087C18 11.976 18 11.383 18 10.2q0-2.725-1.737-4.462C14.525 4 13.683 4 12 4s-3.104.58-4.262 1.738S6 8.383 6 10.2q0 1.775 1.475 4.063C8.95 16.55 9.967 17.483 12 19.35M12 22q-4.024-3.425-6.012-6.362C3.999 12.7 4 11.866 4 10.2q0-3.75 2.413-5.975C8.825 2 9.883 2 12 2q3.176 0 5.588 2.225C19.999 6.45 20 7.7 20 10.2q0 2.5-1.987 5.438C16.025 18.575 14.683 19.717 12 22"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Location.cjs"}],[1848,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 22.5q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5h1v-2q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12v-10H6zm6-3q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587m-3-9h6v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Lock.cjs"}],[1849,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 8.5h9v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5H7q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5m0 12h12v-10H6zm6-3q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockSlash.cjs"}],[1850,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 22.5q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5h1v-2q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm6-5q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587m-3-9h6v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockedFilled.cjs"}],[1851,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 21v-2h7V5h-7V3h7q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm-2-4-1.375-1.45 2.55-2.55H3v-2h8.175l-2.55-2.55L10 7l5 5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Login.cjs"}],[1852,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h7v2H5v14h7v2zm11-4-1.375-1.45 2.55-2.55H9v-2h8.175l-2.55-2.55L16 7l5 5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Logout.cjs"}],[1853,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm8-7L4 8v10h16V8zm0-2 8-5H4zM4 8V6v12z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mail.cjs"}],[1854,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m15 21-6-2.1-4.65 1.8q-.5.2-.925-.112C3 20.275 3 20.1 3 19.75v-14q0-.325.188-.575c.187-.25.295-.292.512-.375L9 3l6 2.1 4.65-1.8q.5-.2.925.113C21 3.724 21 3.9 21 4.25v14q0 .325-.187.575c-.187.25-.296.292-.513.375zm-1-2.45V6.85l-4-1.4v11.7zm2 0 3-1V5.7l-3 1.15zM5 18.3l3-1.15V5.45l-3 1z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Map.cjs"}],[1855,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 18v-2h18v2zm0-5v-2h18v2zm0-5V6h18v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Menu.cjs"}],[1856,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11.9 16.886q.525 0 .888-.363c.362-.363.362-.537.362-.887s-.12-.646-.362-.888-.538-.362-.888-.362-.646.12-.887.362-.363.538-.363.888.12.645.363.887.537.363.887.363m-.9-3.85h1.85q0-.426.038-.725c.037-.3.079-.392.162-.575s.187-.355.312-.513.305-.354.538-.587q.875-.876 1.237-1.463t.363-1.337q0-1.325-.9-2.138t-2.425-.812q-1.375 0-2.337.675T8.5 7.436l1.65.65q.175-.675.7-1.088c.525-.413.758-.412 1.225-.412q.675 0 1.125.362.45.363.45.963 0 .424-.275.9-.275.474-.925 1.05-.425.35-.688.687c-.263.337-.32.463-.437.713s-.2.512-.25.787-.075.604-.075.988m1 9.85-3-3H5q-.824 0-1.412-.588C2.999 18.71 3 18.436 3 17.886v-14q0-.825.588-1.413A1.93 1.93 0 0 1 5 1.886h14q.824 0 1.413.587.587.588.587 1.413v14q0 .825-.587 1.412c-.587.587-.863.588-1.413.588h-4zm-7-5h4.8l2.2 2.2 2.2-2.2H19v-14H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MessageQuestion.cjs"}],[1857,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M2 22V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6zm3.15-6H20V4H4v13.125z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Messages.cjs"}],[1858,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m21.996 8.44-1.353 3.615L22 16.59l-.107.287-1.64 4.385-4.048-1.016L13.145 22h-2.289l-3.06-1.754-4.047 1.016-1.743-4.66 1.35-4.967-1.231-2.883L2 8.462 3.758 2l6.69 4.128h3.106L20.244 2zm-7.93-.498h-4.13L4.867 4.813 3.911 8.33l1.357 3.174-1.363 5.01.971 2.596 3.188-.798 3.273 1.875h1.328l3.273-1.875 3.187.799.966-2.585-1.356-4.534.107-.287 1.254-3.354-.962-3.537z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MetamaskFoxOutline.cjs"}],[1859,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 14a2.9 2.9 0 0 1-2.125-.875A2.9 2.9 0 0 1 9 11V5q0-1.25.875-2.125T12 2c1.25 0 1.542.292 2.125.875S15 4.167 15 5v6q0 1.25-.875 2.125C13.25 14 12.833 14 12 14m-1 7v-3.075q-2.6-.35-4.3-2.325C5 13.625 5 12.75 5 11h2q0 2.075 1.463 3.538C9.926 16 10.617 16 12 16s2.563-.487 3.538-1.462S17 12.383 17 11h2q0 2.625-1.7 4.6c-1.7 1.975-2.567 2.092-4.3 2.325V21zm1-9q.424 0 .713-.287c.289-.287.287-.43.287-.713V5q0-.424-.287-.712C12.426 3.998 12.283 4 12 4s-.52.096-.712.287S11 4.717 11 5v6q0 .424.288.713c.287.289.429.287.712.287"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mic.cjs"}],[1860,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 13v-2h14v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Minus.cjs"}],[1861,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4.15 13.575v-3.15h15.7v3.15z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusBold.cjs"}],[1862,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8 13h8q.424 0 .713-.287C17 12.426 17 12.283 17 12s-.096-.52-.287-.712S16.282 11 16 11H8q-.424 0-.713.288C6.998 11.575 7 11.717 7 12s.096.52.287.713S7.717 13 8 13m-3 8q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusSquare.cjs"}],[1863,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 23q-.824 0-1.412-.587C5 21.826 5 21.55 5 21V3q0-.824.588-1.412C6.176.999 6.45 1 7 1h10q.824 0 1.413.587C19.002 2.175 19 2.45 19 3v18q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-3v1h10v-1zm0-2h10V6H7zM7 4h10V3H7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mobile.cjs"}],[1864,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M14 13q-1.25 0-2.125-.875C11 11.25 11 10.833 11 10q0-1.25.875-2.125C12.75 7 13.167 7 14 7s1.542.292 2.125.875S17 9.167 17 10q0 1.25-.875 2.125C15.25 13 14.833 13 14 13m-7 3q-.824 0-1.412-.587C5 14.825 5 14.55 5 14V6q0-.824.588-1.412C6.176 4 6.45 4 7 4h14q.824 0 1.413.588C23.002 5.176 23 5.45 23 6v8q0 .824-.587 1.413C21.826 16 21.55 16 21 16zm2-2h10q0-.825.588-1.412C20.175 12 20.45 12 21 12V8q-.825 0-1.412-.587C19 6.825 19 6.55 19 6H9q0 .824-.587 1.413C7.825 8 7.55 8 7 8v4q.824 0 1.413.588C9 13.176 9 13.45 9 14m11 6H3q-.824 0-1.412-.587C.999 18.826 1 18.55 1 18V7h2v11h17z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Money.cjs"}],[1865,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8.4 21q-2.275 0-3.837-1.562C3 17.876 3 17.117 3 15.6q0-.95.325-1.85c.325-.9.525-1.142.925-1.625L7.8 7.85 5.375 3h13.25L16.2 7.85l3.55 4.275q.6.725.925 1.625c.325.9.325 1.217.325 1.85q0 2.275-1.575 3.838C17.85 21 17.1 21 15.6 21zm3.6-5q-.825 0-1.412-.587C10 14.825 10 14.55 10 14s.196-1.02.588-1.412S11.45 12 12 12s1.02.196 1.413.588S14 13.45 14 14s-.196 1.02-.587 1.413S12.55 16 12 16M9.625 7h4.75l1-2h-6.75zM8.4 19h7.2q1.425 0 2.413-.987C19 17.025 19 16.55 19 15.6q0-.6-.212-1.162c-.212-.563-.338-.713-.588-1.013L14.525 9H9.5l-3.7 4.4q-.375.45-.587 1.025C5 15 5 15.2 5 15.6q0 1.425.988 2.413C6.976 19 7.45 19 8.4 19"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoneyBag.cjs"}],[1866,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8 21v-2h2v-2H4q-.824 0-1.412-.587C1.999 15.826 2 15.55 2 15V5q0-.825.588-1.412C3.175 3 3.45 3 4 3h16q.824 0 1.413.588C22.002 4.176 22 4.45 22 5v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587h-6v2h2v2zm-4-6h16V5H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Monitor.cjs"}],[1867,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M20 12q0 .824-.587 1.413C18.826 14 18.55 14 18 14s-1.02-.196-1.412-.587S16 12.55 16 12s.196-1.02.587-1.412S17.45 10 18 10s1.02.196 1.413.588S20 11.45 20 12m-6 0q0 .824-.587 1.413C12.825 14 12.55 14 12 14s-1.02-.196-1.412-.587S10 12.55 10 12s.196-1.02.588-1.412S11.45 10 12 10s1.02.196 1.413.588S14 11.45 14 12m-6 0q0 .824-.587 1.413C6.825 14 6.55 14 6 14s-1.02-.196-1.412-.587S4 12.55 4 12s.196-1.02.588-1.412S5.45 10 6 10s1.02.196 1.413.588S8 11.45 8 12"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreHorizontal.cjs"}],[1868,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 20q-.825 0-1.412-.587C10 18.826 10 18.55 10 18s.196-1.02.588-1.412S11.45 16 12 16s1.02.196 1.413.587S14 17.45 14 18s-.196 1.02-.587 1.413S12.55 20 12 20m0-6q-.825 0-1.412-.587C10 12.825 10 12.55 10 12s.196-1.02.588-1.412S11.45 10 12 10s1.02.196 1.413.588S14 11.45 14 12s-.196 1.02-.587 1.413S12.55 14 12 14m0-6q-.825 0-1.412-.587C10 6.825 10 6.55 10 6s.196-1.02.588-1.412S11.45 4 12 4s1.02.196 1.413.588S14 5.45 14 6s-.196 1.02-.587 1.413S12.55 8 12 8"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreVertical.cjs"}],[1869,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8.7 12.925 1.375.925L12 12.875l1.925.975 1.325-.875-1-1.975h-4.6zM5.225 20H18.75l-2.6-5.225-2.075 1.375L12 15.125 9.925 16.15 7.8 14.75zM2 22l5.85-11.875q.25-.5.738-.812C9.076 9 9.267 9 9.65 9H11V2h7l-1 2 1 2h-5v3h1.25q.575 0 1.05.3c.475.3.567.467.75.8L22 22z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MountainFlag.cjs"}],[1870,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M10 21q-1.65 0-2.825-1.175C6 18.65 6 18.1 6 17s.392-2.042 1.175-2.825S8.9 13 10 13q.575 0 1.063.138c.487.137.637.229.937.412V3h6v4h-4v10q0 1.65-1.175 2.825C11.65 21 11.1 21 10 21"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MusicNote.cjs"}],[1871,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 19v-2h2v-7q0-2.074 1.25-3.687C8.5 4.7 9.167 4.533 10.5 4.2v-.7q0-.625.438-1.062C11.375 2 11.583 2 12 2s.77.146 1.063.438.437.645.437 1.062v.7q2 .5 3.25 2.113C18 7.926 18 8.617 18 10v7h2v2zm8 3q-.825 0-1.412-.587C10 20.826 10 20.55 10 20h4q0 .824-.587 1.413c-.588.589-.863.587-1.413.587m-4-5h8v-7q0-1.65-1.175-2.825C13.65 6 13.1 6 12 6s-2.042.392-2.825 1.175S8 8.9 8 10z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Notification.cjs"}],[1872,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M17.75 20.25q-1.575 0-2.662-1.087C14 18.076 14 17.55 14 16.5s.363-1.937 1.088-2.662S16.7 12.75 17.75 12.75s1.938.363 2.663 1.088S21.5 15.45 21.5 16.5s-.362 1.938-1.087 2.663S18.8 20.25 17.75 20.25m0-2q.725 0 1.238-.512c.513-.512.512-.755.512-1.238s-.17-.896-.512-1.237-.755-.513-1.238-.513-.896.17-1.237.513S16 16.017 16 16.5s.17.896.513 1.238.754.512 1.237.512M4 17.5v-2h8v2zm2.25-6.25q-1.575 0-2.662-1.087C2.5 9.075 2.5 8.55 2.5 7.5s.363-1.937 1.088-2.662S5.2 3.75 6.25 3.75s1.938.363 2.663 1.088S10 6.45 10 7.5s-.362 1.938-1.087 2.663S7.3 11.25 6.25 11.25m0-2q.725 0 1.238-.512C8 8.226 8 7.983 8 7.5s-.17-.896-.512-1.237-.755-.513-1.238-.513-.896.17-1.237.513S4.5 7.017 4.5 7.5s.17.896.513 1.238.754.512 1.237.512M12 8.5v-2h8v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PageInfo.cjs"}],[1873,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-2.05 0-3.875-.787c-1.825-.788-2.28-1.242-3.187-2.15s-1.625-1.971-2.15-3.188S2 13.367 2 12q0-2.075.813-3.9c.812-1.825 1.274-2.275 2.2-3.175S7.017 3.313 8.25 2.788 10.8 2 12.2 2q2 0 3.775.687c1.775.687 2.22 1.092 3.113 1.9s1.6 1.767 2.124 2.875S22 9.768 22 11.05q0 2.875-1.75 4.412C18.5 17 17.667 17 16 17h-1.85q-.225 0-.312.125c-.087.125-.088.175-.088.275q0 .3.375.863c.375.562.375.804.375 1.287q0 1.25-.687 1.85c-.688.6-1.063.6-1.813.6m-5.5-9q.65 0 1.075-.425C8 12.15 8 11.933 8 11.5s-.142-.792-.425-1.075S6.933 10 6.5 10s-.792.142-1.075.425S5 11.067 5 11.5s.142.792.425 1.075S6.067 13 6.5 13m3-4q.65 0 1.075-.425C11 8.15 11 7.933 11 7.5s-.142-.792-.425-1.075S9.933 6 9.5 6s-.792.142-1.075.425S8 7.067 8 7.5s.142.792.425 1.075S9.067 9 9.5 9m5 0q.65 0 1.075-.425C16 8.15 16 7.933 16 7.5s-.142-.792-.425-1.075S14.933 6 14.5 6s-.792.142-1.075.425S13 7.067 13 7.5s.142.792.425 1.075S14.067 9 14.5 9m3 4q.65 0 1.075-.425C19 12.15 19 11.933 19 11.5s-.142-.792-.425-1.075S17.933 10 17.5 10s-.792.142-1.075.425S16 11.067 16 11.5s.142.792.425 1.075.642.425 1.075.425M12 20q.224 0 .363-.125c.139-.125.137-.192.137-.325q0-.35-.375-.825c-.375-.475-.375-.792-.375-1.425q0-1.05.725-1.675C13.2 15 13.55 15 14.25 15H16q1.65 0 2.825-.962C20 13.075 20 12.4 20 11.05q0-3.025-2.312-5.037C15.376 4 14.317 4 12.2 4Q8.8 4 6.4 6.325C4 8.65 4 9.767 4 12q0 3.325 2.337 5.663C8.676 20 9.784 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Palette.cjs"}],[1874,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M2 18.886v-2h20v2zm1.15-6.05-1.3-.75.85-1.5H1v-1.5h1.7l-.85-1.45 1.3-.75.85 1.45.85-1.45 1.3.75-.85 1.45H7v1.5H5.3l.85 1.5-1.3.75-.85-1.5zm8 0-1.3-.75.85-1.5H9v-1.5h1.7l-.85-1.45 1.3-.75.85 1.45.85-1.45 1.3.75-.85 1.45H15v1.5h-1.7l.85 1.5-1.3.75-.85-1.5zm8 0-1.3-.75.85-1.5H17v-1.5h1.7l-.85-1.45 1.3-.75.85 1.45.85-1.45 1.3.75-.85 1.45H23v1.5h-1.7l.85 1.5-1.3.75-.85-1.5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PasswordCheck.cjs"}],[1875,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 13.5q.624 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S7.417 10.5 7 10.5s-.77.146-1.062.438S5.5 11.583 5.5 12s.146.77.438 1.063.645.437 1.062.437m5 0q.624 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S12.417 10.5 12 10.5s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063.645.437 1.062.437m5 0q.625 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S17.417 10.5 17 10.5s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063.645.437 1.062.437M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pending.cjs"}],[1876,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M0 18v-1.575q0-1.075 1.1-1.75T4 14q.325 0 .625.013c.3.012.392.029.575.062q-.35.525-.525 1.1c-.175.575-.175.783-.175 1.2V18zm6 0v-1.625q0-.8.438-1.462c.438-.663.704-.83 1.237-1.163s1.17-.583 1.913-.75q1.112-.25 2.412-.25 1.325 0 2.438.25c1.112.25 1.379.417 1.912.75s.942.72 1.225 1.163.425.929.425 1.462V18zm13.5 0v-1.625q0-.65-.162-1.225c-.163-.575-.271-.742-.488-1.075q.274-.05.562-.062C19.7 14 19.8 14 20 14q1.8 0 2.9.663c1.1.663 1.1 1.029 1.1 1.762V18zM8.125 16H15.9q-.251-.5-1.387-.875c-1.136-.375-1.596-.375-2.513-.375s-1.754.125-2.512.375Q8.35 15.5 8.125 16M4 13q-.824 0-1.412-.587C1.999 11.825 2 11.55 2 11q0-.85.588-1.425C3.175 9 3.45 9 4 9q.85 0 1.425.575C6 10.15 6 10.433 6 11q0 .824-.575 1.413C4.85 13 4.567 13 4 13m16 0q-.825 0-1.412-.587C18 11.825 18 11.55 18 11q0-.85.588-1.425C19.175 9 19.45 9 20 9q.85 0 1.425.575C22 10.15 22 10.433 22 11q0 .824-.575 1.413C20.85 13 20.567 13 20 13m-8-1a2.9 2.9 0 0 1-2.125-.875A2.9 2.9 0 0 1 9 9q0-1.275.875-2.137T12 6q1.275 0 2.138.863C15 7.725 15 8.15 15 9q0 1.25-.862 2.125C13.275 12 12.85 12 12 12m0-2q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 8 12 8s-.52.096-.712.288S11 8.717 11 9s.096.52.288.713.429.287.712.287"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/People.cjs"}],[1877,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M17.4 13 16 11.6l2.075-2.1L16 7.425 17.4 6l2.1 2.1L21.575 6 23 7.425 20.9 9.5l2.1 2.1-1.425 1.4-2.075-2.075zM9 12q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.437-1.562c.437-.713.68-.838 1.163-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.162 1.087c.438.712.438.996.438 1.563V20zm2-2h12v-.8q0-.275-.138-.5c-.138-.225-.212-.267-.362-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.825 0 1.412-.587C11 8.825 11 8.55 11 8s-.196-1.02-.588-1.412S9.55 6 9 6s-1.02.196-1.413.588S7 7.45 7 8s.196 1.02.587 1.413S8.45 10 9 10"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PersonCancel.cjs"}],[1878,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M14.136 15.504v2.829l-1.414 1.414-3.535-3.536-4.243 4.243H3.53V19.04l4.242-4.243-3.535-3.535L5.65 9.848H8.48l4.95-4.95-.708-.707 1.414-1.415 7.072 7.072-1.415 1.414-.707-.707zm-6.47-3.641 4.455 4.455V14.69l5.55-5.55-2.827-2.829-5.551 5.55z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pin.cjs"}],[1879,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 20.886V12.91q-1.6 0-3.075-.613c-1.475-.613-1.85-.987-2.6-1.737S4 8.944 3.6 7.96 3 5.951 3 4.884v-2h2a7.9 7.9 0 0 1 3.05.613q1.475.612 2.6 1.737.775.776 1.287 1.7c.512.924.605 1.275.788 1.975q.125-.174.275-.337.15-.162.325-.338a8 8 0 0 1 2.6-1.737A7.9 7.9 0 0 1 19 5.885h2v2a7.9 7.9 0 0 1-.613 3.075q-.612 1.476-1.737 2.6c-1.125 1.124-1.613 1.325-2.588 1.725s-1.995.6-3.062.6v5zm0-10q0-1.2-.462-2.288c-.463-1.088-.746-1.37-1.313-1.937a6.1 6.1 0 0 0-1.937-1.313A5.8 5.8 0 0 0 5 4.886q0 1.2.45 2.3t1.3 1.95 1.95 1.3c1.1.45 1.5.45 2.3.45m2 3a5.92 5.92 0 0 0 4.225-1.75 6 6 0 0 0 1.313-1.95q.462-1.1.462-2.3-1.2 0-2.3.462a6 6 0 0 0-1.95 1.313A5.92 5.92 0 0 0 13 13.886"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plant.cjs"}],[1880,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11.5 19h1v-1.85l3.5-3.5V9H8v4.65l3.5 3.5zm-2 2v-3L6 14.5V9q0-.825.588-1.412C7.176 7 7.45 7 8 7h1L8 8V3h2v4h4V3h2v5l-1-1h1q.824 0 1.413.588C18.002 8.176 18 8.45 18 9v5.5L14.5 18v3z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plug.cjs"}],[1881,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M7 4.252H5v3H2v2h3v3h2v-3h3v-2H7zm11 1 1.06 1.06L5.627 19.749l-1.061-1.06zm4 11v-2h-8v2z",clipRule:"evenodd"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PlusAndMinus.cjs"}],[1882,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v5h-2V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3q.65-.2 1.238-.512c.588-.312.779-.455 1.162-.738l1.4 1.4q-.825.675-1.787 1.175c-.962.5-1.313.592-2.013.775m9 0q-.424 0-.712-.287C20 21.425 20 21.283 20 21s.096-.52.288-.712S20.717 20 21 20s.52.096.713.288.287.429.287.712-.096.52-.287.713S21.283 22 21 22m-1-4v-6h2v6zm-8-4q.824 0 1.413-.587C14 12.825 14 12.55 14 12s-.196-1.02-.587-1.412S12.55 10 12 10s-1.02.196-1.412.588S10 11.45 10 12s.196 1.02.588 1.413S11.45 14 12 14m0 2q-1.65 0-2.825-1.175C8 13.65 8 13.1 8 12s.392-2.042 1.175-2.825S10.9 8 12 8s2.042.392 2.825 1.175S16 10.9 16 12q0 .55-.137 1.063c-.137.512-.23.67-.413.987L18.425 17 17 18.425l-3-2.975q-.45.274-.962.413c-.513.139-.688.137-1.038.137"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PolicyAlert.cjs"}],[1883,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M16 8V5H8v3H6V3h12v5zm2 4.5q.424 0 .713-.287c.288-.287.287-.43.287-.713s-.096-.52-.287-.712-.43-.288-.713-.288-.52.096-.712.288-.288.429-.288.712.096.52.288.713.429.287.712.287M16 19v-4H8v4zm2 2H6v-4H2v-6q0-1.275.875-2.137C3.75 8 4.167 8 5 8h14q1.275 0 2.138.863C22 9.726 22 10.15 22 11v6h-4zm2-6v-4q0-.424-.287-.712C19.425 9.999 19.283 10 19 10H5q-.424 0-.712.288C3.998 10.575 4 10.717 4 11v4h2v-2h12v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Print.cjs"}],[1884,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 21q-.825 0-1.412-.587C10 19.826 10 19.55 10 19s.196-1.02.588-1.412S11.45 17 12 17s1.02.196 1.413.588S14 18.45 14 19s-.196 1.02-.587 1.413S12.55 21 12 21m-2-6V3h4v12z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PriorityHigh.cjs"}],[1885,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 17h2v-6h-2zm1-8q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 7 12 7s-.52.096-.712.288S11 7.717 11 8s.096.52.288.713S11.717 9 12 9m0 13q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PrivacyTip.cjs"}],[1886,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m10.75 23.25-1.4-1.425L11.175 20h-3.35q-.326.875-1.088 1.438C5.975 22 5.65 22 5 22q-1.25 0-2.125-.875C2 20.25 2 19.833 2 19q0-.976.562-1.737c.562-.762.855-.871 1.438-1.088v-8.35q-.875-.326-1.438-1.087C2 5.977 2 5.65 2 5q0-1.25.875-2.125C3.75 2 4.167 2 5 2q.976 0 1.737.563c.761.563.871.854 1.088 1.437h3.35L9.35 2.175 10.75.75 15 5l-4.25 4.25-1.4-1.425L11.175 6h-3.35A2.92 2.92 0 0 1 6 7.825v8.35A2.92 2.92 0 0 1 7.825 18h3.35L9.35 16.175l1.4-1.425L15 19zM19 22q-1.25 0-2.125-.875C16 20.25 16 19.833 16 19q0-1 .563-1.762c.563-.762.854-.863 1.437-1.063v-8.35q-.875-.3-1.437-1.062C16 6 16 5.667 16 5q0-1.25.875-2.125C17.75 2 18.167 2 19 2s1.542.292 2.125.875S22 4.167 22 5q0 1-.562 1.763c-.562.763-.855.862-1.438 1.062v8.35q.875.326 1.438 1.088C22 18.024 22 18.35 22 19q0 1.25-.875 2.125C20.25 22 19.833 22 19 22M5 20q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S5.283 18 5 18s-.52.096-.712.288S4 18.717 4 19s.096.52.287.713S4.717 20 5 20m14 0q.424 0 .713-.287C20 19.425 20 19.283 20 19s-.096-.52-.287-.712S19.283 18 19 18s-.52.096-.712.288S18 18.717 18 19s.096.52.288.713.429.287.712.287M5 6q.424 0 .713-.287C6.002 5.426 6 5.283 6 5s-.096-.52-.287-.712S5.283 4 5 4s-.52.096-.712.287S4 4.717 4 5s.096.52.287.713S4.717 6 5 6m14 0q.424 0 .713-.287C20 5.426 20 5.283 20 5s-.096-.52-.287-.712S19.283 4 19 4s-.52.096-.712.287S18 4.717 18 5s.096.52.288.713S18.717 6 19 6"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ProgrammingArrows.cjs"}],[1887,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 20v-8.15l-2.6 2.6L7 13l5-5 5 5-1.4 1.45-2.6-2.6V20zM4 9V6q0-.824.588-1.412C5.176 4 5.45 4 6 4h12q.824 0 1.413.588C20.002 5.176 20 5.45 20 6v3h-2V6H6v3z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Publish.cjs"}],[1888,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 11V3h8v8zm2-2h4V5H5zM3 21v-8h8v8zm2-2h4v-4H5zm8-8V3h8v8zm2-2h4V5h-4zm4 12v-2h2v2zm-6-6v-2h2v2zm2 2v-2h2v2zm-2 2v-2h2v2zm2 2v-2h2v2zm2-2v-2h2v2zm0-4v-2h2v2zm2 2v-2h2v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/QrCode.cjs"}],[1889,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11.95 18q.525 0 .888-.362c.362-.363.362-.538.362-.888s-.12-.646-.362-.887-.538-.363-.888-.363-.646.12-.887.363-.363.537-.363.887.12.646.363.888.537.362.887.362m-.9-3.85h1.85q0-.825.187-1.3c.187-.475.48-.75 1.063-1.3a7.5 7.5 0 0 0 1.025-1.238q.375-.587.375-1.412 0-1.4-1.025-2.15C13.5 6 13.033 6 12.1 6q-1.424 0-2.313.75-.887.75-1.237 1.8l1.65.65q.124-.45.562-.975C11.2 7.7 11.5 7.7 12.1 7.7q.8 0 1.2.437c.4.437.4.613.4.963q0 .5-.3.938t-.75.812q-1.1.975-1.35 1.475c-.25.5-.25.942-.25 1.825M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.312 17.117 2.787 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Question.cjs"}],[1890,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 11V3h8v8zm2-2h4V5H5zM3 21v-8h8v8zm2-2h4v-4H5zm8-8V3h8v8zm2-2h4V5h-4zm4 12v-2h2v2zm-6-6v-2h2v2zm2 2v-2h2v2zm-2 2v-2h2v2zm2 2v-2h2v2zm2-2v-2h2v2zm0-4v-2h2v2zm2 2v-2h2v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Receive.cjs"}],[1891,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m19 6.9-9.6 9.6H18v2H6v-12h2v8.6l9.6-9.6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Received.cjs"}],[1892,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12.05 20q-3.35 0-5.7-2.325C4 15.35 4 14.233 4 12v-.175l-1.6 1.6-1.4-1.4 4-4 4 4-1.4 1.4-1.6-1.6V12q0 2.5 1.763 4.25C9.526 18 10.367 18 12.05 18q.65 0 1.275-.15c.625-.15.825-.25 1.225-.45l1.5 1.5q-.95.55-1.95.825c-1 .275-1.35.275-2.05.275M19 15.975l-4-4 1.4-1.4 1.6 1.6V12q0-2.5-1.762-4.25C14.476 6 13.633 6 11.95 6q-.65 0-1.275.15c-.625.15-.825.25-1.225.45l-1.5-1.5a8.3 8.3 0 0 1 1.95-.825A7.7 7.7 0 0 1 11.95 4q3.35 0 5.7 2.325C20 8.65 20 9.767 20 12v.175l1.6-1.6 1.4 1.4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Refresh.cjs"}],[1893,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 13h10v-2H7zm5 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/RemoveMinus.cjs"}],[1894,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S12.283 15 12 15s-.52.096-.712.287S11 15.717 11 16s.096.52.288.712.429.288.712.288m-1-4h2V7h-2zm-2.75 8L3 15.75v-7.5L8.25 3h7.5L21 8.25v7.5L15.75 21zm.85-2h5.8l4.1-4.1V9.1L14.9 5H9.1L5 9.1v5.8z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Report.cjs"}],[1895,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m6 19.054 1.975-.8q-.25-.723-.462-1.473c-.213-.75-.255-.998-.338-1.498l-1.175.8zm4-1.049h4q.45-.999.725-2.434.275-1.437.275-2.934 0-2.472-.825-4.682T12 4.547q-1.35 1.199-2.175 3.408A13.3 13.3 0 0 0 9 12.637q0 1.497.275 2.933.275 1.437.725 2.435m2-4.994q-.825 0-1.412-.587-.588-.586-.588-1.41c0-.824.196-1.02.588-1.411q.587-.587 1.412-.587c.825 0 1.02.196 1.413.587q.587.587.587 1.41c0 .824-.196 1.02-.587 1.411a1.93 1.93 0 0 1-1.413.587m6 6.043v-2.972l-1.175-.799q-.125.75-.337 1.499c-.212.749-.296.99-.463 1.473zM12 2q2.475 1.798 3.738 4.57C17 9.34 17 10.563 17 13.01l2.1 1.398q.425.275.663.725c.238.45.237.615.237.948V22l-4.975-1.997h-6.05L4 22v-5.918a2 2 0 0 1 .9-1.673L7 13.012q0-3.67 1.263-6.442C9.526 3.797 10.35 3.2 12 2"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Rocket.cjs"}],[1896,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21V5q0-.824.588-1.412C6.176 2.999 6.45 3 7 3h10q.824 0 1.413.588C19.002 4.175 19 4.45 19 5v16l-7-3zm2-3.05 5-2.15 5 2.15V5H7z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Save.cjs"}],[1897,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21V5q0-.824.588-1.412C6.176 2.999 6.45 3 7 3h10q.824 0 1.413.588C19.002 4.175 19 4.45 19 5v16l-7-3z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SaveFilled.cjs"}],[1898,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M16 11q.424 0 .713-.287C17 10.426 17 10.283 17 10q0-.424-.287-.712C16.425 8.999 16.282 9 16 9s-.52.096-.713.288S15 9.717 15 10q0 .424.287.713c.287.289.43.287.713.287M8 9h5V7H8zM4.5 21q-.85-2.85-1.675-5.687C2 12.474 2 11.483 2 9.5q0-2.3 1.6-3.9C5.2 4 5.967 4 7.5 4h5q.724-.95 1.763-1.475C15.3 2 15.7 2 16.5 2q.625 0 1.063.437C18 2.874 18 3.083 18 3.5q0 .15-.037.3c-.038.15-.055.192-.088.275q-.101.274-.187.562a4 4 0 0 0-.138.588L19.825 7.5H22v6.975l-2.825.925L17.5 21H12v-2h-2v2zM6 19h2v-2h6v2h2l1.55-5.15 2.45-.825V9.5h-1L15.5 6a7.2 7.2 0 0 1 .25-1.9q-.724.2-1.275.688c-.551.487-.633.729-.8 1.212H7.5Q6.05 6 5.025 7.025C4 8.05 4 8.533 4 9.5q0 2.45.675 4.788C5.35 16.625 5.567 17.417 6 19"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Saving.cjs"}],[1899,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M2 7V2h5v2H4v3zm0 15v-5h2v3h3v2zm15 0v-2h3v-3h2v5zm3-15V4h-3V2h5v5zm-2.5 10.5H19V19h-1.5zm0-3H19V16h-1.5zM16 16h1.5v1.5H16zm-1.5 1.5H16V19h-1.5zM13 16h1.5v1.5H13zm3-3h1.5v1.5H16zm-1.5 1.5H16V16h-1.5zM13 13h1.5v1.5H13zm6-8v6h-6V5zm-8 8v6H5v-6zm0-8v6H5V5zM9.5 17.5v-3h-3v3zm0-8v-3h-3v3zm8 0v-3h-3v3z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Scan.cjs"}],[1900,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M2 7V2h5v2H4v3zm0 15v-5h2v3h3v2zm15 0v-2h3v-3h2v5zm3-15V4h-3V2h5v5zm-2.5 10.5H19V19h-1.5zm0-3H19V16h-1.5zM16 16h1.5v1.5H16zm-1.5 1.5H16V19h-1.5zM13 16h1.5v1.5H13zm3-3h1.5v1.5H16zm-1.5 1.5H16V16h-1.5zM13 13h1.5v1.5H13zm6-8v6h-6V5zm-8 8v6H5v-6zm0-8v6H5V5zM9.5 17.5v-3h-3v3zm0-8v-3h-3v3zm8 0v-3h-3v3z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanBarcode.cjs"}],[1901,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19v-4h2v4h4v2zm10 0v-2h4v-4h2v4q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zM3 9V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h4v2H5v4zm16 0V5h-4V3h4q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanFocus.cjs"}],[1902,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m19.6 21-6.3-6.3q-.75.6-1.725.95C10.6 16 10.233 16 9.5 16q-2.725 0-4.612-1.888C3 12.224 3 11.317 3 9.5q0-2.725 1.888-4.612C6.776 3 7.683 3 9.5 3q2.725 0 4.613 1.888C16 6.776 16 7.683 16 9.5a6.1 6.1 0 0 1-1.3 3.8l6.3 6.3zM9.5 14q1.875 0 3.188-1.312C14 11.375 14 10.75 14 9.5s-.437-2.312-1.312-3.187S10.75 5 9.5 5s-2.312.438-3.187 1.313S5 8.25 5 9.5s.438 2.313 1.313 3.188S8.25 14 9.5 14"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Search.cjs"}],[1903,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Security.cjs"}],[1904,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 16q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 14 12 14s-.52.096-.712.288S11 14.717 11 15s.096.52.288.713.429.287.712.287m-1-4h2V7h-2zm1 10q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityAlert.cjs"}],[1905,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m9.9 15.5 2.1-2.1 2.1 2.1 1.4-1.4-2.1-2.1 2.1-2.1-1.4-1.4-2.1 2.1-2.1-2.1-1.4 1.4 2.1 2.1-2.1 2.1zM12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityCross.cjs"}],[1906,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M10.5 15h3l-.575-3.225q.5-.25.788-.725C14 10.575 14 10.383 14 10q0-.825-.587-1.412C12.825 8 12.55 8 12 8s-1.02.196-1.412.588S10 9.45 10 10q0 .574.288 1.05c.287.476.454.558.787.725zm1.5 7q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityKey.cjs"}],[1907,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 2.126-.725 4.088C18.55 17.149 18.1 17.65 17.2 18.65l-3.2-3.2q-.45.274-.962.413C12.525 16 12.35 16 12 16q-1.65 0-2.825-1.175C8 13.65 8 13.1 8 12s.392-2.042 1.175-2.825S10.9 8 12 8s2.042.392 2.825 1.175S16 10.9 16 12q0 .55-.137 1.062c-.137.512-.23.671-.413.988l1.5 1.5q.5-1.025.775-2.15C18 12.275 18 11.883 18 11.1V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3q.65-.2 1.238-.512c.588-.313.779-.455 1.162-.738l1.4 1.4q-.825.675-1.787 1.175c-.962.5-1.313.592-2.013.775m0-8q.824 0 1.413-.587C14 12.825 14 12.55 14 12s-.196-1.02-.587-1.412S12.55 10 12 10s-1.02.196-1.412.588S10 11.45 10 12s.196 1.02.588 1.413S11.45 14 12 14"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySearch.cjs"}],[1908,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m18.85 16.05-1.5-1.55q.3-.8.475-1.662C18 11.976 18 11.683 18 11.1V6.375l-6-2.25L8.35 5.5 6.8 3.95 12 2l8 3v6.1a11.2 11.2 0 0 1-1.15 4.95m.95 6.55-3.25-3.25q-.95.975-2.113 1.638C13.274 21.65 12.85 21.767 12 22q-3.476-.874-5.738-3.987T4 11.1V6.8L1.4 4.2l1.4-1.4 18.4 18.4zM12 19.9q.875-.275 1.675-.775c.8-.5 1.025-.725 1.475-1.175L6 8.8v2.3q0 3.025 1.7 5.5t4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySlash.cjs"}],[1909,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M10.95 15.55 16.6 9.9l-1.425-1.425L10.95 12.7l-2.1-2.1-1.425 1.425zM12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTick.cjs"}],[1910,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 16q1.875 0 3.188-1.312C16.5 13.375 16.5 12.75 16.5 11.5s-.437-2.312-1.312-3.187S13.25 7 12 7v1.5q1.25 0 2.125.875C15 10.25 15 10.667 15 11.5s-.292 1.542-.875 2.125-1.292.875-2.125.875q-.825 0-1.537-.425c-.712-.425-.846-.667-1.113-1.15l-1.3.725q.6 1.1 1.65 1.725C10.75 16 11.167 16 12 16m-3.75-3.65A.73.73 0 0 0 9 11.6a.73.73 0 0 0-.75-.75.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75m.55-2.1a.73.73 0 0 0 .75-.75.73.73 0 0 0-.75-.75.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75m1.45-1.375a.73.73 0 0 0 .75-.75.73.73 0 0 0-.75-.75.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTime.cjs"}],[1911,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 13q-1.474 0-2.487-1.012C8.499 10.976 8.5 10.483 8.5 9.5q0-1.474 1.013-2.487C10.525 6 11.016 6 12 6s1.813.338 2.488 1.013S15.5 8.517 15.5 9.5q0 1.475-1.012 2.488C13.476 13 12.983 13 12 13m0-2q.65 0 1.075-.425c.425-.425.425-.642.425-1.075s-.142-.792-.425-1.075S12.433 8 12 8s-.792.142-1.075.425-.425.642-.425 1.075.142.792.425 1.075S11.567 11 12 11m0 11q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-17.875-6 2.25V11.1q0 1.35.375 2.625c.375 1.275.592 1.65 1.025 2.4q1.05-.525 2.2-.825T12 15c1.25 0 1.633.1 2.4.3s1.5.475 2.2.825q.65-1.125 1.025-2.4C18 12.45 18 12 18 11.1V6.375zM12 17q-.9 0-1.75.2a9 9 0 0 0-1.625.55q.724.75 1.575 1.3.85.55 1.8.85.95-.3 1.8-.85c.85-.55 1.092-.8 1.575-1.3q-.775-.35-1.625-.55C12.9 17 12.6 17 12 17"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityUser.cjs"}],[1912,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 20V4l19 8zm2-3 11.85-5L5 7v3.5l6 1.5-6 1.5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Send.cjs"}],[1913,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M15.5 11q.624 0 1.063-.437c.439-.438.437-.646.437-1.063s-.146-.77-.437-1.062S15.917 8 15.5 8s-.77.146-1.062.438S14 9.083 14 9.5s.146.77.438 1.063.645.437 1.062.437m-7 0q.624 0 1.063-.437C10 10.125 10 9.917 10 9.5s-.146-.77-.437-1.062S8.917 8 8.5 8s-.77.146-1.062.438S7 9.083 7 9.5s.146.77.438 1.063S8.083 11 8.5 11m3.5 2.5q-1.7 0-3.087.963C7.525 15.426 7.317 15.95 6.9 17h1.65a4.1 4.1 0 0 1 1.462-1.462Q10.926 15 12 15c1.075 0 1.38.18 1.988.538s1.095.845 1.462 1.462h1.65q-.625-1.575-2.013-2.537C13.7 13.5 13.134 13.5 12 13.5m0 8.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentDissatisfied.cjs"}],[1914,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M15.5 11q.624 0 1.063-.437c.439-.438.437-.646.437-1.063s-.146-.77-.437-1.062S15.917 8 15.5 8s-.77.146-1.062.438S14 9.083 14 9.5s.146.77.438 1.063.645.437 1.062.437m-7 0q.624 0 1.063-.437C10 10.125 10 9.917 10 9.5s-.146-.77-.437-1.062S8.917 8 8.5 8s-.77.146-1.062.438S7 9.083 7 9.5s.146.77.438 1.063S8.083 11 8.5 11m.5 4.5h6V14H9zm3 6.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentNeutral.cjs"}],[1915,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M15.5 11q.624 0 1.063-.437c.439-.438.437-.646.437-1.063s-.146-.77-.437-1.062S15.917 8 15.5 8s-.77.146-1.062.438S14 9.083 14 9.5s.146.77.438 1.063.645.437 1.062.437m-7 0q.624 0 1.063-.437C10 10.125 10 9.917 10 9.5s-.146-.77-.437-1.062S8.917 8 8.5 8s-.77.146-1.062.438S7 9.083 7 9.5s.146.77.438 1.063S8.083 11 8.5 11m3.5 6.5q1.7 0 3.088-.962c1.388-.962 1.595-1.488 2.012-2.538h-1.65q-.55.925-1.462 1.463C13.076 16 12.717 16 12 16s-1.38-.18-1.987-.537A4.1 4.1 0 0 1 8.55 14H6.9q.625 1.575 2.012 2.538c1.387.963 1.955.962 3.088.962m0 4.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentSatisfied.cjs"}],[1916,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 17.5q1.7 0 3.088-.962c1.388-.962 1.595-1.488 2.012-2.538H6.9q.626 1.575 2.013 2.538c1.387.963 1.954.962 3.087.962M7.8 11l1.1-1.05L9.95 11 11 9.95 8.9 7.8 6.75 9.95zm6.25 0 1.05-1.05L16.2 11l1.05-1.05L15.1 7.8 13 9.95zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentVerySatisfied.cjs"}],[1917,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m9.25 22-.4-3.2a4 4 0 0 1-.612-.3 8 8 0 0 1-.563-.375L4.7 19.375l-2.75-4.75 2.575-1.95a2.4 2.4 0 0 1-.025-.337v-.675q0-.163.025-.338L1.95 9.375l2.75-4.75 2.975 1.25q.276-.2.575-.375c.3-.175.4-.217.6-.3l.4-3.2h5.5l.4 3.2q.325.125.613.3c.288.175.379.242.562.375l2.975-1.25 2.75 4.75-2.575 1.95q.025.176.025.338v.674q0 .163-.05.338l2.575 1.95-2.75 4.75-2.95-1.25q-.275.2-.575.375c-.3.175-.4.217-.6.3l-.4 3.2zM11 20h1.975l.35-2.65q.775-.2 1.438-.587c.663-.387.845-.571 1.212-.938l2.475 1.025.975-1.7-2.15-1.625q.126-.35.175-.737c.05-.387.05-.521.05-.788s-.016-.53-.05-.787-.091-.505-.175-.738l2.15-1.625-.975-1.7-2.475 1.05q-.55-.575-1.212-.962c-.662-.387-.921-.455-1.438-.588L13 4h-1.975l-.35 2.65q-.776.2-1.437.588-.663.387-1.213.937L5.55 7.15l-.975 1.7 2.15 1.6q-.124.375-.175.75a6 6 0 0 0-.05.8q0 .4.05.775t.175.75l-2.15 1.625.975 1.7 2.475-1.05q.55.574 1.213.963.662.387 1.437.587zm1.05-4.5q1.45 0 2.475-1.025C15.55 13.45 15.55 12.967 15.55 12s-.342-1.792-1.025-2.475A3.37 3.37 0 0 0 12.05 8.5q-1.474 0-2.487 1.025T8.55 12c0 1.45.338 1.792 1.013 2.475S11.067 15.5 12.05 15.5"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Setting.cjs"}],[1918,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m9.25 22-.4-3.2a4 4 0 0 1-.612-.3 8 8 0 0 1-.563-.375L4.7 19.375l-2.75-4.75 2.575-1.95a2.4 2.4 0 0 1-.025-.337v-.675q0-.163.025-.338L1.95 9.375l2.75-4.75 2.975 1.25q.276-.2.575-.375c.3-.175.4-.217.6-.3l.4-3.2h5.5l.4 3.2q.325.125.613.3c.288.175.379.242.562.375l2.975-1.25 2.75 4.75-2.575 1.95q.025.176.025.338v.674q0 .163-.05.338l2.575 1.95-2.75 4.75-2.95-1.25q-.275.2-.575.375c-.3.175-.4.217-.6.3l-.4 3.2zm2.8-6.5q1.45 0 2.475-1.025C15.55 13.45 15.55 12.967 15.55 12s-.342-1.792-1.025-2.475A3.37 3.37 0 0 0 12.05 8.5q-1.474 0-2.487 1.025T8.55 12c0 1.45.338 1.792 1.013 2.475S11.067 15.5 12.05 15.5"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SettingFilled.cjs"}],[1919,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 23q-.824 0-1.412-.587C4 21.826 4 21.55 4 21V10q0-.825.588-1.412C5.176 8 5.45 8 6 8h3v2H6v11h12V10h-3V8h3q.824 0 1.413.588c.589.588.587.862.587 1.412v11q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm5-7V4.825l-1.6 1.6L8 5l4-4 4 4-1.4 1.425-1.6-1.6V16z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Share.cjs"}],[1920,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3M10 16h4q.424 0 .713-.288c.289-.288.287-.429.287-.712v-3q0-.424-.287-.713c-.287-.289-.43-.287-.713-.287v-1q0-.824-.587-1.413C12.825 7.998 12.55 8 12 8s-1.02.196-1.412.587S10 9.45 10 10v1q-.424 0-.712.287c-.289.287-.288.43-.288.713v3q0 .424.288.712C9.575 16 9.717 16 10 16m1-5v-1q0-.424.288-.713C11.575 8.998 11.717 9 12 9s.52.096.713.287.287.43.287.713v1z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShieldLock.cjs"}],[1921,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V8q0-.824.588-1.412C5.176 6 5.45 6 6 6h2q0-1.65 1.175-2.825C10.35 2 10.9 2 12 2s2.042.392 2.825 1.175S16 4.9 16 6h2q.824 0 1.413.588C20.002 7.176 20 7.45 20 8v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V8h-2v2q0 .424-.287.713c-.287.289-.43.287-.713.287s-.52-.096-.712-.287S14 10.283 14 10V8h-4v2q0 .424-.287.713c-.287.289-.43.287-.713.287s-.52-.096-.712-.287S8 10.283 8 10V8H6zm4-14h4q0-.824-.587-1.412C12.825 4 12.55 4 12 4s-1.02.196-1.412.588S10 5.45 10 6"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingBag.cjs"}],[1922,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7.006 22q-.826 0-1.414-.587c-.588-.587-.588-.863-.588-1.413s.196-1.02.588-1.412S6.455 18 7.006 18s1.021.196 1.413.588q.588.587.588 1.412c0 .825-.196 1.02-.588 1.413A1.93 1.93 0 0 1 7.006 22m10.009 0q-.825 0-1.414-.587c-.589-.587-.588-.863-.588-1.413s.196-1.02.588-1.412.863-.588 1.414-.588 1.022.196 1.414.588.588.862.588 1.412-.196 1.02-.588 1.413-.864.587-1.414.587M6.155 6l2.402 5h7.007l2.752-5zm-.951-2h14.764q.575 0 .875.513c.3.513.209.687.025 1.037l-3.553 6.4q-.275.5-.738.775c-.463.275-.646.275-1.013.275H8.107l-1.101 2h12.01v2H7.007q-1.126 0-1.702-.987-.576-.988-.05-1.963l1.351-2.45L3.002 4H1V2h3.253z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingCart.cjs"}],[1923,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m16.9 21.5-1.4-1.402 2.1-2.103-2.1-2.103 1.4-1.401 2.1 2.102 2.1-2.102 1.4 1.401-2.075 2.103 2.075 2.103-1.4 1.401-2.1-2.077zM2 22 22 2v10.688q-.45-.275-.95-.438c-.5-.163-.683-.196-1.05-.263V6.831L6.825 19.998h6.425q.2.575.5 1.076.3.5.675.926zm4.825-2.002L20 6.83a1217 1217 0 0 1-3.45 3.442 1072 1072 0 0 0-3.037 3.029l-3.088 3.091z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SignalCellular.cjs"}],[1924,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m20.088 22.313-2.276-2.275q-1.224.8-2.612 1.225c-1.388.425-1.887.425-2.887.425q-2.076 0-3.9-.788c-1.825-.788-2.276-1.237-3.176-2.137S3.625 16.804 3.1 15.588s-.788-2.517-.788-3.9q0-1.5.425-2.888c.425-1.388.692-1.796 1.225-2.612L1.687 3.913l1.425-1.425 18.4 18.4zm-7.776-2.625a7.93 7.93 0 0 0 4.05-1.1L5.412 7.638q-.549.95-.825 1.962c-.276 1.012-.275 1.37-.275 2.088q0 3.325 2.338 5.662c2.338 2.337 3.446 2.338 5.662 2.338m8.35-2.5-1.45-1.45q.55-.95.825-1.963c.275-1.013.275-1.37.275-2.087q0-3.326-2.337-5.663c-2.337-2.337-3.446-2.337-5.663-2.337a7.93 7.93 0 0 0-4.05 1.1l-1.45-1.45q1.225-.8 2.613-1.225c1.388-.425 1.887-.425 2.887-.425q2.076 0 3.9.787c1.824.787 2.275 1.238 3.175 2.138S21 6.57 21.525 7.788s.787 2.516.787 3.9q0 1.5-.425 2.887c-.425 1.387-.691 1.796-1.225 2.613"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Slash.cjs"}],[1925,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8 11q.424 0 .713-.287c.289-.287.287-.43.287-.713q0-.424-.287-.712C8.426 8.999 8.283 9 8 9s-.52.096-.712.288S7 9.717 7 10q0 .424.288.713c.287.289.429.287.712.287m4 0q.424 0 .713-.287c.289-.287.287-.43.287-.713q0-.424-.287-.712C12.426 8.999 12.283 9 12 9s-.52.096-.712.288S11 9.717 11 10q0 .424.288.713c.287.289.429.287.712.287m4 0q.424 0 .713-.287C17 10.426 17 10.283 17 10q0-.424-.287-.712C16.425 8.999 16.282 9 16 9s-.52.096-.713.288S15 9.717 15 10q0 .424.287.713c.287.289.43.287.713.287M2 22V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6zm3.15-6H20V4H4v13.125z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sms.cjs"}],[1926,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 19.425v-6.85L5 9.1v6.85zm2 0 6-3.475V9.1l-6 3.475zm-1-8.575 5.925-3.425L12 4 6.075 7.425zM4 17.7q-.475-.275-.737-.725c-.262-.45-.263-.633-.263-1v-7.95A1.95 1.95 0 0 1 4 6.3l7-4.025Q11.475 2 12 2c.525 0 .683.092 1 .275L20 6.3q.475.275.738.725c.263.45.262.633.262 1v7.95a1.95 1.95 0 0 1-1 1.725l-7 4.025Q12.525 22 12 22c-.525 0-.683-.092-1-.275z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Snaps.cjs"}],[1927,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M3.586 3.586C3 4.172 3 5.114 3 7v10c0 1.886 0 2.828.586 3.414S5.114 21 7 21h10c1.886 0 2.828 0 3.414-.586S21 18.886 21 17V7c0-1.886 0-2.828-.586-3.414S18.886 3 17 3H7c-1.886 0-2.828 0-3.414.586m7.747 8.797v4.567l-4-2.317v-4.566zm5.334 2.25-4 2.317v-4.567l4-2.316zM15.95 8.95 12 11.233 8.05 8.95 12 6.667zm-9.775 6.367q.175.3.492.483l4.666 2.683a1.31 1.31 0 0 0 1.334 0l4.666-2.683q.316-.183.492-.483c.176-.3.175-.422.175-.667v-5.3a1.3 1.3 0 0 0-.667-1.15l-4.666-2.683a1.31 1.31 0 0 0-1.334 0L6.667 8.2A1.299 1.299 0 0 0 6 9.35v5.3q0 .367.175.667",clipRule:"evenodd"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsMobile.cjs"}],[1928,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 4 6.075 7.425 12 10.85l5.925-3.425zM3 15.975v-7.95A1.95 1.95 0 0 1 4 6.3l7-4.025q.25-.125.488-.2C11.726 2 11.817 2 12 2s.358.025.525.075.325.117.475.2L20 6.3q.475.275.738.725c.263.45.262.633.262 1V12h-2V9.1l-7.025 4.05L5 9.1v6.85l6 3.475v2.3L4 17.7q-.475-.275-.737-.725c-.262-.45-.263-.633-.263-1"}),s.createElement("path",{d:"M17 19v3h2v-3h3v-2h-3v-3h-2v3h-3v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsPlus.cjs"}],[1929,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11.323 12.39v4.638L7.26 14.675v-4.639zM16.74 14.675l-4.063 2.353V12.39l4.064-2.353zM16.013 8.902 12 11.222l-4.012-2.32L12 6.582z"}),s.createElement("path",{fillRule:"evenodd",d:"M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10m-5.917-6.63q.178.303.5.49l4.74 2.726a1.33 1.33 0 0 0 1.354 0l4.74-2.726q.323-.187.5-.49a1.3 1.3 0 0 0 .178-.678V9.308a1.32 1.32 0 0 0-.677-1.168l-4.74-2.726a1.33 1.33 0 0 0-1.355 0L6.583 8.14q-.322.186-.5.491c-.178.305-.178.429-.178.677v5.384q0 .372.178.677",clipRule:"evenodd"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsRound.cjs"}],[1930,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 18v-2h6v2zm0-5v-2h12v2zm0-5V6h18v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sort.cjs"}],[1931,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M2 17 5.75 7H7.9l3.75 10H9.6l-.85-2.4H4.9L4.1 17zm3.5-4.1h2.6L6.9 9.15h-.15zm8.2 4.1v-1.9l5.05-6.3H13.9V7h7.05v1.9l-5 6.3H21V17zM9 5l3-3 3 3zm3 17-3-3h6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SortByAlpha.cjs"}],[1932,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("g",{fillRule:"evenodd",clipRule:"evenodd"},s.createElement("path",{d:"M17.714 3A4.86 4.86 0 0 0 22 7.304a4.86 4.86 0 0 0-4.286 4.305 4.86 4.86 0 0 0-4.285-4.305A4.86 4.86 0 0 0 17.714 3M16.46 14.913a3.44 3.44 0 0 0 3.03 3.044A3.44 3.44 0 0 0 16.46 21a3.44 3.44 0 0 0-3.03-3.043 3.44 3.44 0 0 0 3.03-3.044M9.143 4.87a8.12 8.12 0 0 1-4.383 6.349 8 8 0 0 1-2.76.824c.985.11 1.915.396 2.76.826a8.12 8.12 0 0 1 4.383 6.348 8.12 8.12 0 0 1 4.383-6.349 8 8 0 0 1 2.76-.825 8 8 0 0 1-2.76-.825A8.12 8.12 0 0 1 9.143 4.87m0 4.348a9.6 9.6 0 0 1-2.818 2.825 9.6 9.6 0 0 1 2.818 2.826 9.6 9.6 0 0 1 2.818-2.826 9.6 9.6 0 0 1-2.818-2.825"}))));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sparkle.cjs"}],[1933,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M9 3V1h6v2zm2 11h2V8h-2zm1 8q-1.85 0-3.487-.712c-1.638-.712-2.046-1.121-2.863-1.938s-1.463-1.77-1.938-2.862S3 14.233 3 13s.237-2.396.712-3.487Q4.424 7.874 5.65 6.65c1.226-1.225 1.77-1.463 2.862-1.938S10.767 4 12 4q1.55 0 2.975.5c1.425.5 1.842.817 2.675 1.45l1.4-1.4 1.4 1.4-1.4 1.4Q20 8.6 20.5 10.025c.5 1.425.5 1.942.5 2.975q0 1.85-.713 3.488c-.713 1.638-1.12 2.045-1.937 2.862s-1.77 1.463-2.863 1.938S13.233 22 12 22m0-2q2.9 0 4.95-2.05C19 15.9 19 14.933 19 13s-.683-3.583-2.05-4.95S13.933 6 12 6s-3.583.683-4.95 2.05S5 11.067 5 13s.683 3.583 2.05 4.95S10.067 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speed.cjs"}],[1934,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M10.45 15.5q.6.6 1.55.588c.95-.013 1.1-.238 1.4-.688L19 7l-8.4 5.6q-.675.45-.712 1.375c-.038.925.162 1.125.562 1.525M12 4q1.475 0 2.838.413C16.2 4.825 16.6 5.1 17.4 5.65l-1.9 1.2q-.824-.425-1.713-.637C12.898 6 12.6 6 12 6Q8.675 6 6.337 8.337C4 10.674 4 11.783 4 14q0 1.05.287 2.075C4.574 17.1 4.75 17.4 5.1 18h13.8q.575-.95.838-1.975C20 15 20 14.633 20 13.9q0-.9-.213-1.75c-.213-.85-.354-1.117-.637-1.65l1.2-1.9q.75 1.175 1.187 2.5c.437 1.325.446 1.8.463 2.75s-.092 1.858-.325 2.725-.575 1.692-1.025 2.475q-.274.45-.75.7c-.476.25-.65.25-1 .25H5.1q-.525 0-1-.25c-.475-.25-.567-.4-.75-.7q-.65-1.125-1-2.387C2 15.4 2 14.933 2 14q0-2.075.787-3.887.788-1.813 2.15-3.175C6.3 5.576 6.908 5.313 8.125 4.788S10.633 4 12 4"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speedometer.cjs"}],[1935,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Square.cjs"}],[1936,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 21v-7.975q-1.6 0-3.075-.612c-1.475-.613-1.85-.988-2.6-1.738S4 9.058 3.6 8.075 3 6.067 3 5V3h2q1.575 0 3.05.612c1.475.612 1.85.988 2.6 1.738q.775.775 1.287 1.7c.512.925.605 1.275.788 1.975q.125-.176.275-.338c.15-.162.208-.22.325-.337q1.125-1.125 2.6-1.738C17.4 6 17.933 6 19 6h2v2q0 1.6-.613 3.075c-.613 1.475-.987 1.85-1.737 2.6S17.037 15 16.062 15.4 14.067 16 13 16v5zm0-10q0-1.2-.462-2.287c-.463-1.087-.746-1.371-1.313-1.938S8.013 5.771 7.288 5.463 5.8 5 5 5q0 1.2.45 2.3c.45 1.1.733 1.383 1.3 1.95s1.217 1 1.95 1.3 1.5.45 2.3.45m2 3a5.92 5.92 0 0 0 4.225-1.75 6 6 0 0 0 1.313-1.95Q19 9.2 19 8q-1.2 0-2.3.463c-1.1.463-1.383.745-1.95 1.312A5.92 5.92 0 0 0 13 14"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Stake.cjs"}],[1937,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8.85 16.825 3.15-1.9 3.15 1.925-.825-3.6 2.775-2.4-3.65-.325-1.45-3.4-1.45 3.375-3.65.325 2.775 2.425zM5.825 21l1.625-7.025L2 9.25l7.2-.625L12 2l2.8 6.625 7.2.625-5.45 4.725L18.175 21 12 17.275z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Star.cjs"}],[1938,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m5.825 21 1.625-7.025L2 9.25l7.2-.625L12 2l2.8 6.625 7.2.625-5.45 4.725L18.175 21 12 17.275z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/StarFilled.cjs"}],[1939,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M2 18V6h2v12zm14 0-1.425-1.4 3.6-3.6H6v-2h12.175L14.6 7.4 16 6l6 6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Start.cjs"}],[1940,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M21 11.05V19q0 .824-.587 1.413A1.93 1.93 0 0 1 19 21H5q-.825 0-1.412-.587A1.93 1.93 0 0 1 3 19v-7.95q-.575-.525-.887-1.35T2.1 7.9l1.05-3.4a2.2 2.2 0 0 1 .713-1.075A1.8 1.8 0 0 1 5.05 3h13.9q.675 0 1.175.413.5.412.725 1.087l1.05 3.4q.3.975-.012 1.775A3.95 3.95 0 0 1 21 11.05M14.2 10q.675 0 1.025-.462.35-.463.275-1.038L14.95 5H13v3.7q0 .525.35.913.35.387.85.387m-4.5 0q.575 0 .938-.387Q11 9.225 11 8.7V5H9.05L8.5 8.5q-.101.6.263 1.05.362.45.937.45m-4.45 0q.45 0 .788-.325c.338-.325.362-.492.412-.825L7 5H5.05l-1 3.35q-.15.5.163 1.075Q4.525 10 5.25 10m13.5 0q.724 0 1.05-.575.325-.575.15-1.075L18.9 5H17l.55 3.85q.075.5.413.825c.338.325.487.325.787.325M5 19h14v-7.05a.6.6 0 0 1-.162.05h-.088a2.9 2.9 0 0 1-1.187-.225q-.513-.225-1.013-.725a3.3 3.3 0 0 1-1.025.7Q14.95 12 14.3 12q-.674 0-1.262-.25a3.3 3.3 0 0 1-1.038-.7q-.425.45-.987.7c-.562.25-.78.25-1.213.25a3.3 3.3 0 0 1-1.312-.25 3.3 3.3 0 0 1-1.038-.7q-.525.525-1.037.738A3 3 0 0 1 5.25 12h-.112A.25.25 0 0 1 5 11.95z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Storefront.cjs"}],[1941,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 21-7-3.8v-6L1 9l11-6 11 6v8h-2v-6.9l-2 1.1v6zm0-8.3L18.85 9 12 5.3 5.15 9zm0 6.025 5-2.7V12.25L12 15l-5-2.75v3.775z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Student.cjs"}],[1942,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m7 20-5-5 5-5 1.4 1.425L5.825 14H13v2H5.825L8.4 18.575zm10-6-1.4-1.425L18.175 10H11V8h7.175L15.6 5.425 17 4l5 5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapHorizontal.cjs"}],[1943,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M8 13V5.825L5.425 8.4 4 7l5-5 5 5-1.425 1.4L10 5.825V13zm7 9-5-5 1.425-1.4L14 18.175V11h2v7.175l2.575-2.575L20 17z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapVertical.cjs"}],[1944,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m11.9 13.5 2.1-2.1 2.1 2.1 1.4-1.4-2.1-2.1 2.1-2.1-1.4-1.4L14 8.6l-2.1-2.1-1.4 1.4 2.1 2.1-2.1 2.1zM8 18q-.824 0-1.412-.587C6 16.826 6 16.55 6 16V4q0-.824.588-1.412C7.176 1.999 7.45 2 8 2h12q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V4H8zm-4 6q-.824 0-1.412-.587C1.999 20.826 2 20.55 2 20V6h2v14h14v2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TabClose.cjs"}],[1945,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M19 19v-3H5v3zm0-5v-4H5v4zm0-6V5H5v3zM5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TableRow.cjs"}],[1946,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 20.5q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712-.43-.288-.713-.288-.52.096-.712.288-.288.429-.288.712.096.52.288.713.429.287.712.287M5 23q-.824 0-1.412-.587C2.999 21.826 3 21.55 3 21V3q0-.824.588-1.412C4.175.999 4.45 1 5 1h14q.824 0 1.413.587C21.002 2.175 21 2.45 21 3v18q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-5v3h14v-3zm0-2h14V6H5zM5 4h14V3H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tablet.cjs"}],[1947,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m21.413 14.25-7.15 7.15q-.3.3-.675.45c-.375.15-.5.15-.75.15s-.5-.05-.75-.15-.475-.25-.675-.45l-8.825-8.825q-.276-.275-.425-.637c-.15-.363-.15-.496-.15-.763V4q0-.824.587-1.412A1.93 1.93 0 0 1 4.013 2h7.175q.4 0 .775.163c.375.163.466.254.65.437l8.8 8.825q.3.3.437.675c.137.375.138.5.138.75s-.046.496-.138.738-.237.462-.437.662M12.838 20l7.15-7.15L11.163 4h-7.15v7.15zM6.513 8q.624 0 1.062-.437.438-.438.438-1.063c0-.625-.146-.77-.438-1.062A1.45 1.45 0 0 0 6.513 5q-.625 0-1.063.438-.437.436-.437 1.062c0 .626.146.77.437 1.063Q5.888 8 6.513 8"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tag.cjs"}],[1948,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 3h11v13l-7 7-1.25-1.25q-.175-.175-.287-.475c-.112-.3-.113-.392-.113-.575v-.35L9.45 16H3q-.8 0-1.4-.6C1 14.8 1 14.533 1 14v-2q0-.175.05-.375c.05-.2.067-.258.1-.375l3-7.05q.225-.5.75-.85C5.425 3 5.617 3 6 3m9 2H6l-3 7v2h9l-1.35 5.5L15 15.15zm2 11v-2h3V5h-3V3h5v13z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDown.cjs"}],[1949,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 3h10v13l-7 7-1.25-1.25q-.175-.175-.287-.475c-.112-.3-.113-.392-.113-.575v-.35L8.45 16H3q-.8 0-1.4-.6C1 14.8 1 14.533 1 14v-2a2 2 0 0 1 .15-.75l3-7.05q.225-.5.75-.85C5.425 3 5.617 3 6 3m12 13V3h4v13z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDownFilled.cjs"}],[1950,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M18 21H7V8l7-7 1.25 1.25q.175.175.288.475c.112.3.112.392.112.575v.35L14.55 8H21q.8 0 1.4.6c.6.6.6.867.6 1.4v2q0 .175-.05.375c-.05.2-.067.258-.1.375l-3 7.05q-.225.5-.75.85c-.525.35-.717.35-1.1.35m-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85zM7 8v2H4v9h3v2H2V8z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUp.cjs"}],[1951,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M18 21H8V8l7-7 1.25 1.25q.175.175.288.475c.113.3.112.392.112.575v.35L15.55 8H21q.8 0 1.4.6c.6.6.6.867.6 1.4v2a2 2 0 0 1-.15.75l-3 7.05q-.225.5-.75.85c-.525.35-.717.35-1.1.35M6 8v13H2V8z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUpFilled.cjs"}],[1952,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 21q-3.325 0-5.662-2.3C4 16.4 4 15.3 4 13.1q0-1.625.625-3.037A8.2 8.2 0 0 1 6.35 7.55L12 2l5.65 5.55a8.2 8.2 0 0 1 1.725 2.513Q20 11.474 20 13.1q0 3.3-2.337 5.6C15.326 21 14.217 21 12 21m-5.95-7H17.9q.3-1.8-.337-3.075C16.926 9.65 16.7 9.433 16.25 9L12 4.8 7.75 9q-.675.65-1.325 1.925C5.775 12.2 5.867 12.8 6.05 14"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tint.cjs"}],[1953,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 22-2.675-4H4q-.824 0-1.413-.587C1.998 16.826 2 16.55 2 16V4q0-.824.587-1.412C3.174 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587h-5.325zm0-3.6 1.6-2.4H20V4H4v12h6.4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tooltip.cjs"}],[1954,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m11.85 22 4.53-12h2.09L23 22h-2.09l-1.07-3.05H15.01L13.941 22zm-7.864-3-1.393-1.4 5.027-5.05q-.871-.875-1.58-2C5.33 9.425 5.13 8.95 4.733 8h2.09q.498.975.996 1.7t1.195 1.45q.82-.824 1.704-2.313C11.602 7.348 11.751 6.9 12.05 6H1V4h6.968V2H9.96v2h6.969v2H14.04q-.523 1.8-1.568 3.7-1.046 1.9-2.066 2.9l2.39 2.45-.747 2.05-3.036-3.125zm11.647-1.8h3.584l-1.792-5.1z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Translate.cjs"}],[1955,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 21q-.824 0-1.412-.587C5 19.826 5 19.55 5 19V6H4V4h5V3h6v1h5v2h-1v13q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zM17 6H7v13h10zM9 17h2V8H9zm4 0h2V8h-2z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Trash.cjs"}],[1956,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M16 18v-2h2.6l-5.2-5.15-4 4L2 7.4 3.4 6l6 6 4-4 6.6 6.6V12h2v6z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendDown.cjs"}],[1957,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3.4 18 2 16.6l7.4-7.45 4 4L18.6 8H16V6h6v6h-2V9.4L13.4 16l-4-4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendUp.cjs"}],[1958,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M7 19.5v-2h7.1q1.575 0 2.738-1C18 15.5 18 15 18 14s-.387-1.833-1.162-2.5-1.688-1-2.738-1H7.8l2.6 2.6L9 14.5l-5-5 5-5 1.4 1.4-2.6 2.6h6.3q2.425 0 4.162 1.575C20 11.65 20 12.433 20 14s-.58 2.875-1.738 3.925S15.717 19.5 14.1 19.5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Undo.cjs"}],[1959,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m12 20.95-4.5-4.5L8.95 15 12 18.05 15.05 15l1.45 1.45zM8.95 9 7.5 7.55l4.5-4.5 4.5 4.5L15.05 9 12 5.95z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unfold.cjs"}],[1960,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M6 8.5h9v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5H7q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5m6 9q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UnlockedFilled.cjs"}],[1961,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{fillRule:"evenodd",d:"M3.507 2.047 2.093 3.46 8.48 9.847H5.65l-1.414 1.415 3.536 3.535L3.53 19.04v1.414h1.414l4.243-4.243 3.535 3.536 1.415-1.414v-2.829l6.385 6.386 1.414-1.414zm5.786 9.816.6-.601 2.83 2.828-.602.601v1.626l-4.454-4.454z",clipRule:"evenodd"}),s.createElement("path",{d:"m16.965 12.676 2.121-2.121.708.707 1.414-1.415-7.071-7.07-1.415 1.414.708.707-2.122 2.121 1.414 1.414 2.122-2.121 2.828 2.828-2.121 2.122z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unpin.cjs"}],[1962,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 16V7.85l-2.6 2.6L7 9l5-5 5 5-1.4 1.45-2.6-2.6V16zm-5 4q-.824 0-1.412-.587C4 18.826 4 18.55 4 18v-3h2v3h12v-3h2v3q0 .824-.587 1.413c-.587.589-.863.587-1.413.587z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Upload.cjs"}],[1963,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 19h2v-4.175l1.6 1.6L16 15l-4-4-4 4 1.425 1.4L11 14.825zm-5 3q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UploadFile.cjs"}],[1964,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 22q-.825 0-1.412-.587C10 20.826 10 20.55 10 20q0-.525.275-.975c.275-.45.425-.542.725-.725V16H8q-.824 0-1.412-.588C6 14.824 6 14.55 6 14v-2.3q-.45-.225-.725-.675C5 10.575 5 10.383 5 10q0-.824.588-1.413C6.176 7.998 6.45 8 7 8s1.02.196 1.413.587S9 9.45 9 10q0 .575-.275 1c-.275.425-.425.517-.725.7V14h3V6H9l3-4 3 4h-2v8h3v-2h-1V8h4v4h-1v2q0 .824-.587 1.412C16.826 16 16.55 16 16 16h-3v2.3q.476.25.738.7c.262.45.262.633.262 1q0 .825-.587 1.412C12.825 22 12.55 22 12 22"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Usb.cjs"}],[1965,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 12q-1.65 0-2.825-1.175C8 9.65 8 9.1 8 8s.392-2.042 1.175-2.825S10.9 4 12 4s2.042.392 2.825 1.175S16 6.9 16 8s-.392 2.042-1.175 2.825S13.1 12 12 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C10.35 13 10.9 13 12 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C13.4 15 12.933 15 12 15s-1.858.112-2.775.337Q7.85 15.675 6.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C14 8.825 14 8.55 14 8s-.196-1.02-.587-1.412S12.55 6 12 6s-1.02.196-1.412.588S10 7.45 10 8s.196 1.02.588 1.413S11.45 10 12 10"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/User.cjs"}],[1966,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M17.55 12 14 8.45l1.425-1.4 2.125 2.125 4.25-4.25 1.4 1.425zM9 12q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C11 8.825 11 8.55 11 8s-.196-1.02-.587-1.412S9.55 6 9 6s-1.02.196-1.412.588S7 7.45 7 8s.196 1.02.588 1.413S8.45 10 9 10"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCheck.cjs"}],[1967,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5.85 17.1q1.275-.975 2.85-1.537C10.275 15 10.85 15 12 15s2.25.188 3.3.563 2 .887 2.85 1.537q.875-1.025 1.363-2.325C20 13.475 20 12.983 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 1.475.488 2.775c.488 1.3.779 1.642 1.362 2.325M12 13q-1.474 0-2.487-1.012C8.499 10.976 8.5 10.483 8.5 9.5q0-1.474 1.013-2.487C10.525 6 11.016 6 12 6s1.813.338 2.488 1.013S15.5 8.517 15.5 9.5q0 1.475-1.012 2.488C13.476 13 12.983 13 12 13m0 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q1.325 0 2.5-.387c1.175-.387 1.5-.63 2.15-1.113q-.975-.725-2.15-1.112C13.325 17 12.883 17 12 17s-1.717.13-2.5.388A7.5 7.5 0 0 0 7.35 18.5a7.5 7.5 0 0 0 2.15 1.113A8 8 0 0 0 12 20m0-9q.65 0 1.075-.425c.425-.425.425-.642.425-1.075s-.142-.792-.425-1.075S12.433 8 12 8s-.792.142-1.075.425-.425.642-.425 1.075.142.792.425 1.075S11.567 11 12 11"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircle.cjs"}],[1968,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M18 14v-3h-3V9h3V6h2v3h3v2h-3v3zm-9-2q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C11 8.825 11 8.55 11 8s-.196-1.02-.587-1.412S9.55 6 9 6s-1.02.196-1.412.588S7 7.45 7 8s.196 1.02.588 1.413S8.45 10 9 10"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleAdd.cjs"}],[1969,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M16 11V9h6v2zm-7 1q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C11 8.825 11 8.55 11 8s-.196-1.02-.587-1.412S9.55 6 9 6s-1.02.196-1.412.588S7 7.45 7 8s.196 1.02.588 1.413S8.45 10 9 10"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleRemove.cjs"}],[1970,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8.6 22.5-1.9-3.2-3.6-.8.35-3.7L1 12l2.45-2.8-.35-3.7 3.6-.8 1.9-3.2L12 2.95l3.4-1.45 1.9 3.2 3.6.8-.35 3.7L23 12l-2.45 2.8.35 3.7-3.6.8-1.9 3.2-3.4-1.45zm.85-2.55 2.55-1.1 2.6 1.1 1.4-2.4 2.75-.65-.25-2.8 1.85-2.1-1.85-2.15.25-2.8-2.75-.6-1.45-2.4L12 5.15l-2.6-1.1L8 6.45l-2.75.6.25 2.8L3.65 12l1.85 2.1-.25 2.85 2.75.6zm1.5-4.4L16.6 9.9l-1.4-1.45-4.25 4.25-2.15-2.1L7.4 12z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Verified.cjs"}],[1971,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m8.6 22.5-1.9-3.2-3.6-.8.35-3.7L1 12l2.45-2.8-.35-3.7 3.6-.8 1.9-3.2L12 2.95l3.4-1.45 1.9 3.2 3.6.8-.35 3.7L23 12l-2.45 2.8.35 3.7-3.6.8-1.9 3.2-3.4-1.45zm2.35-6.95L16.6 9.9l-1.4-1.45-4.25 4.25-2.15-2.1L7.4 12z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/VerifiedFilled.cjs"}],[1972,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h12q.824 0 1.413.588C18.002 5.176 18 5.45 18 6v4.5l4-4v11l-4-4V18q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V6H4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Videocam.cjs"}],[1973,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M3 17V7q0-.824.588-1.412C4.176 5 4.452 5 5.003 5h13.994q.826 0 1.415.588C21 6.176 21 6.45 21 7v10q0 .824-.588 1.413c-.588.589-.864.587-1.415.587H5.003q-.826 0-1.415-.587C3 17.826 3 17.55 3 17m1.978 0h3.33V7h-3.33zm5.332 0h3.33V7h-3.33zm5.333 0h3.33V7h-3.33z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewColumn.cjs"}],[1974,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M11 19.475 6 16.6q-.475-.275-.737-.725c-.262-.45-.263-.633-.263-1v-5.75A1.95 1.95 0 0 1 6 7.4l5-2.875q.475-.275 1-.275c.525 0 .683.092 1 .275L18 7.4q.475.275.738.725c.263.45.262.633.262 1v5.75a1.95 1.95 0 0 1-1 1.725l-5 2.875q-.475.275-1 .275c-.525 0-.683-.092-1-.275m0-2.3v-4.6L7 10.25v4.625zm2 0 4-2.3V10.25l-4 2.325zM2 7V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h3v2H4v3zm5 15H4q-.824 0-1.412-.587C1.999 20.826 2 20.55 2 20v-3h2v3h3zm10 0v-2h3v-3h2v3q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm3-15V4h-3V2h3q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v3zm-8 3.85 3.95-2.325L12 6.25 8.05 8.525z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewInAr.cjs"}],[1975,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"m19.8 22.6-3.025-3.025a8.3 8.3 0 0 1-1.325.688 9.5 9.5 0 0 1-1.45.462v-2.05q.35-.125.687-.25.338-.124.638-.3L12 14.8V20l-5-5H3V9h3.2L1.4 4.2l1.4-1.4 18.4 18.4zm-.2-5.8-1.45-1.45a6.8 6.8 0 0 0 .637-1.625q.213-.85.213-1.75 0-2.35-1.375-4.2C16.25 5.925 15.5 5.708 14 5.275v-2.05q3.1.7 5.05 3.138C21 8.8 21 9.858 21 11.975q0 1.325-.363 2.55A8.8 8.8 0 0 1 19.6 16.8m-3.35-3.35L14 11.2V7.95a4.15 4.15 0 0 1 1.837 1.65q.663 1.1.663 2.4a4.3 4.3 0 0 1-.25 1.45M12 9.2 9.4 6.6 12 4zm-2 5.95V12.8L8.2 11H5v2h2.85z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeOff.cjs"}],[1976,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M14 20.725v-2.05q2.25-.65 3.625-2.5t1.375-4.2-1.375-4.2T14 5.275v-2.05q3.1.7 5.05 3.137C21 8.8 21 9.858 21 11.975q0 3.176-1.95 5.613c-1.95 2.437-2.983 2.67-5.05 3.137M3 15V9h4l5-5v16l-5-5zm11 1V7.95a4.15 4.15 0 0 1 1.838 1.65q.662 1.1.662 2.4 0 1.275-.662 2.363C15.176 15.45 14.783 15.633 14 16m-4-7.15L7.85 11H5v2h2.85L10 15.15z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeUp.cjs"}],[1977,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v2.5h-2V5H5v14h14v-2.5h2V19q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm8-4q-.825 0-1.412-.587C11 15.826 11 15.55 11 15V9q0-.825.588-1.412C12.176 7 12.45 7 13 7h7q.824 0 1.413.588C22.002 8.176 22 8.45 22 9v6q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-2V9h-7v6zm-4-1.5q.625 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S16.417 10.5 16 10.5s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063.645.437 1.062.437"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wallet.cjs"}],[1978,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5h-8q-1.775 0-2.887 1.113T9 9v6q0 1.775 1.113 2.888T13 19h8q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm8-4q-.825 0-1.412-.587C11 15.826 11 15.55 11 15V9q0-.825.588-1.412C12.176 7 12.45 7 13 7h7q.824 0 1.413.588C22.002 8.176 22 8.45 22 9v6q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm3-3.5q.65 0 1.075-.425c.425-.425.425-.642.425-1.075s-.142-.792-.425-1.075S16.433 10.5 16 10.5s-.792.142-1.075.425-.425.642-.425 1.075.142.792.425 1.075.642.425 1.075.425"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/WalletFilled.cjs"}],[1979,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M12 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S12.283 15 12 15s-.52.096-.712.287S11 15.717 11 16s.096.52.288.712.429.288.712.288m-1-4h2V7h-2zm1 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Warning.cjs"}],[1980,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M2 12v-2h3v2zm3.4 5.55L4 16.1 6.1 14l1.45 1.4zM6.1 8 4 5.9l1.4-1.45L7.55 6.6zM18 20l-4.75-4.75L12 19 9 9l10 3-3.7 1.3L20 18zM10 6V3h2v3zm5.9 2-1.45-1.4 2.15-2.15 1.4 1.4z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/WebTraffic.cjs"}],[1981,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M16.65 13 11 7.35l5.65-5.65 5.65 5.65zM3 11V3h8v8zm10 10v-8h8v8zM3 21v-8h8v8zM5 9h4V5H5zm11.675 1.2L19.5 7.375 16.675 4.55 13.85 7.375zM15 19h4v-4h-4zM5 19h4v-4H5z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Widgets.cjs"}],[1982,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("clipPath",{id:"a"},s.createElement("path",{d:"M0 0h24v24H0z"})),s.createElement("g",{clipPath:"url(#a)"},s.createElement("path",{d:"M12 20.886q-1.05 0-1.775-.725-.725-.726-.725-1.776c0-1.05.242-1.291.725-1.775q.725-.724 1.775-.724c1.05 0 1.292.241 1.775.725s.725 1.075.725 1.775-.242 1.291-.725 1.775-1.075.724-1.775.724m-5.65-5.65-2.1-2.15q1.475-1.476 3.463-2.338C9.7 9.886 10.467 9.886 12 9.886s2.963.291 4.288.874 2.479 1.375 3.462 2.375l-2.1 2.1q-1.1-1.1-2.55-1.725c-1.45-.625-2-.625-3.1-.625s-2.133.209-3.1.625-1.817.992-2.55 1.725m-4.25-4.25L0 8.886A16.7 16.7 0 0 1 5.375 5.21Q8.45 3.886 12 3.886t6.625 1.325A16.7 16.7 0 0 1 24 8.886l-2.1 2.1q-1.924-1.926-4.462-3.013C14.9 6.886 13.933 6.886 12 6.886s-3.746.362-5.437 1.087-3.18 1.73-4.463 3.013"}))));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wifi.cjs"}],[1983,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("clipPath",{id:"a"},s.createElement("path",{d:"M0 0h24v24H0z"})),s.createElement("g",{clipPath:"url(#a)"},s.createElement("path",{d:"m19.75 22.6-9.4-9.45a8.7 8.7 0 0 0-2.187.825A7.5 7.5 0 0 0 6.35 15.35l-2.1-2.15q.8-.8 1.725-1.4c.925-.6 1.275-.75 1.975-1.05L5.7 8.5q-1.024.525-1.913 1.163Q2.9 10.3 2.1 11.1L0 8.95q.8-.8 1.662-1.437C2.524 6.876 2.85 6.683 3.5 6.3L1.4 4.2l1.4-1.4 18.4 18.4zM12 21q-1.05 0-1.775-.737A2.43 2.43 0 0 1 9.5 18.5q0-1.05.725-1.775T12 16c1.05 0 1.292.242 1.775.725q.725.725.725 1.775 0 1.024-.725 1.763A2.4 2.4 0 0 1 12 21m5.9-5.95-.725-.725-.725-.725-3.6-3.6q2.025.2 3.787 1.025C18.4 11.85 18.85 12.3 19.75 13.2zm4-3.95q-1.924-1.924-4.462-3.012C14.9 7 13.933 7 12 7a13 13 0 0 0-2 .15L7.45 4.6q1.1-.3 2.238-.45T12 4q3.55 0 6.625 1.325C21.7 6.65 22.467 7.417 24 8.95z"}))));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/WifiOff.cjs"}],[1984,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0});const s=i(e("react")),o=(0,e("react").forwardRef)((e,t)=>s.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},s.createElement("path",{d:"M20.996 20.8 13.96 10.542l.012.01L20.316 3.2h-2.12l-5.168 5.984L8.924 3.2h-5.56l6.569 9.577-.001-.001L3.004 20.8h2.12l5.746-6.658 4.566 6.658zM8.084 4.8l9.872 14.4h-1.68L6.396 4.8z"})));r.default=o}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/X.cjs"}],[1985,{"./Accessibility.cjs":1709,"./Activity.cjs":1710,"./Add.cjs":1711,"./AddCard.cjs":1712,"./AddCircle.cjs":1713,"./AddSquare.cjs":1714,"./Ai.cjs":1715,"./AlternateEmail.cjs":1716,"./AppleLogo.cjs":1717,"./Apps.cjs":1718,"./Arrow2Down.cjs":1719,"./Arrow2Left.cjs":1720,"./Arrow2Right.cjs":1721,"./Arrow2Up.cjs":1722,"./Arrow2UpRight.cjs":1723,"./ArrowCircleDown.cjs":1724,"./ArrowCircleUp.cjs":1725,"./ArrowDoubleLeft.cjs":1726,"./ArrowDoubleRight.cjs":1727,"./ArrowDown.cjs":1728,"./ArrowDropDownCircle.cjs":1729,"./ArrowLeft.cjs":1730,"./ArrowRight.cjs":1731,"./ArrowUp.cjs":1732,"./AttachMoney.cjs":1733,"./Attachment.cjs":1734,"./Backspace.cjs":1735,"./Ban.cjs":1736,"./Bank.cjs":1737,"./BankAssured.cjs":1738,"./Bold.cjs":1739,"./Book.cjs":1740,"./Bookmark.cjs":1741,"./Bridge.cjs":1742,"./Briefcase.cjs":1743,"./Bulb.cjs":1744,"./BuySell.cjs":1745,"./Cake.cjs":1746,"./Calculator.cjs":1747,"./Calendar.cjs":1748,"./Call.cjs":1749,"./Camera.cjs":1750,"./Campaign.cjs":1751,"./Candlestick.cjs":1752,"./Card.cjs":1753,"./CardPos.cjs":1754,"./Cash.cjs":1755,"./Category.cjs":1756,"./Chart.cjs":1757,"./Check.cjs":1758,"./CheckBold.cjs":1759,"./CircleX.cjs":1760,"./Clear.cjs":1761,"./Clock.cjs":1762,"./ClockFilled.cjs":1763,"./Close.cjs":1764,"./Cloud.cjs":1765,"./CloudDownload.cjs":1766,"./CloudUpload.cjs":1767,"./Code.cjs":1768,"./CodeCircle.cjs":1769,"./Coin.cjs":1770,"./Collapse.cjs":1771,"./Confirmation.cjs":1772,"./Connect.cjs":1773,"./Copy.cjs":1774,"./CopySuccess.cjs":1775,"./CreditCheck.cjs":1776,"./CurrencyFranc.cjs":1777,"./CurrencyLira.cjs":1778,"./CurrencyPound.cjs":1779,"./CurrencyYuan.cjs":1780,"./Customize.cjs":1781,"./Danger.cjs":1782,"./Dark.cjs":1783,"./DarkFilled.cjs":1784,"./Data.cjs":1785,"./Description.cjs":1786,"./Details.cjs":1787,"./Diagram.cjs":1788,"./DocumentCode.cjs":1789,"./Download.cjs":1790,"./Draft.cjs":1791,"./EcoLeaf.cjs":1792,"./Edit.cjs":1793,"./EditSquare.cjs":1794,"./EncryptedAdd.cjs":1795,"./Eraser.cjs":1796,"./Error.cjs":1797,"./Ethereum.cjs":1798,"./Exchange.cjs":1799,"./Expand.cjs":1800,"./ExpandVertical.cjs":1801,"./Explore.cjs":1802,"./ExploreFilled.cjs":1803,"./Export.cjs":1804,"./Extension.cjs":1805,"./Eye.cjs":1806,"./EyeSlash.cjs":1807,"./FaceId.cjs":1808,"./Feedback.cjs":1809,"./File.cjs":1810,"./Filter.cjs":1811,"./Fingerprint.cjs":1812,"./Fire.cjs":1813,"./FirstPage.cjs":1814,"./Flag.cjs":1815,"./Flash.cjs":1816,"./FlashSlash.cjs":1817,"./Flask.cjs":1818,"./Flower.cjs":1819,"./Folder.cjs":1820,"./Forest.cjs":1821,"./FullCircle.cjs":1822,"./Gas.cjs":1823,"./Gift.cjs":1824,"./Global.cjs":1825,"./GlobalSearch.cjs":1826,"./Graph.cjs":1827,"./Hardware.cjs":1828,"./HashTag.cjs":1829,"./Heart.cjs":1830,"./HeartFilled.cjs":1831,"./Hierarchy.cjs":1832,"./Home.cjs":1833,"./HomeFilled.cjs":1834,"./Image.cjs":1835,"./Info.cjs":1836,"./Inventory.cjs":1837,"./Joystick.cjs":1838,"./Keep.cjs":1839,"./KeepFilled.cjs":1840,"./Key.cjs":1841,"./LastPage.cjs":1842,"./Light.cjs":1843,"./LightFilled.cjs":1844,"./Link.cjs":1845,"./Loading.cjs":1846,"./Location.cjs":1847,"./Lock.cjs":1848,"./LockSlash.cjs":1849,"./LockedFilled.cjs":1850,"./Login.cjs":1851,"./Logout.cjs":1852,"./Mail.cjs":1853,"./Map.cjs":1854,"./Menu.cjs":1855,"./MessageQuestion.cjs":1856,"./Messages.cjs":1857,"./MetamaskFoxOutline.cjs":1858,"./Mic.cjs":1859,"./Minus.cjs":1860,"./MinusBold.cjs":1861,"./MinusSquare.cjs":1862,"./Mobile.cjs":1863,"./Money.cjs":1864,"./MoneyBag.cjs":1865,"./Monitor.cjs":1866,"./MoreHorizontal.cjs":1867,"./MoreVertical.cjs":1868,"./MountainFlag.cjs":1869,"./MusicNote.cjs":1870,"./Notification.cjs":1871,"./PageInfo.cjs":1872,"./Palette.cjs":1873,"./PasswordCheck.cjs":1874,"./Pending.cjs":1875,"./People.cjs":1876,"./PersonCancel.cjs":1877,"./Pin.cjs":1878,"./Plant.cjs":1879,"./Plug.cjs":1880,"./PlusAndMinus.cjs":1881,"./PolicyAlert.cjs":1882,"./Print.cjs":1883,"./PriorityHigh.cjs":1884,"./PrivacyTip.cjs":1885,"./ProgrammingArrows.cjs":1886,"./Publish.cjs":1887,"./QrCode.cjs":1888,"./Question.cjs":1889,"./Receive.cjs":1890,"./Received.cjs":1891,"./Refresh.cjs":1892,"./RemoveMinus.cjs":1893,"./Report.cjs":1894,"./Rocket.cjs":1895,"./Save.cjs":1896,"./SaveFilled.cjs":1897,"./Saving.cjs":1898,"./Scan.cjs":1899,"./ScanBarcode.cjs":1900,"./ScanFocus.cjs":1901,"./Search.cjs":1902,"./Security.cjs":1903,"./SecurityAlert.cjs":1904,"./SecurityCross.cjs":1905,"./SecurityKey.cjs":1906,"./SecuritySearch.cjs":1907,"./SecuritySlash.cjs":1908,"./SecurityTick.cjs":1909,"./SecurityTime.cjs":1910,"./SecurityUser.cjs":1911,"./Send.cjs":1912,"./SentimentDissatisfied.cjs":1913,"./SentimentNeutral.cjs":1914,"./SentimentSatisfied.cjs":1915,"./SentimentVerySatisfied.cjs":1916,"./Setting.cjs":1917,"./SettingFilled.cjs":1918,"./Share.cjs":1919,"./ShieldLock.cjs":1920,"./ShoppingBag.cjs":1921,"./ShoppingCart.cjs":1922,"./SignalCellular.cjs":1923,"./Slash.cjs":1924,"./Sms.cjs":1925,"./Snaps.cjs":1926,"./SnapsMobile.cjs":1927,"./SnapsPlus.cjs":1928,"./SnapsRound.cjs":1929,"./Sort.cjs":1930,"./SortByAlpha.cjs":1931,"./Sparkle.cjs":1932,"./Speed.cjs":1933,"./Speedometer.cjs":1934,"./Square.cjs":1935,"./Stake.cjs":1936,"./Star.cjs":1937,"./StarFilled.cjs":1938,"./Start.cjs":1939,"./Storefront.cjs":1940,"./Student.cjs":1941,"./SwapHorizontal.cjs":1942,"./SwapVertical.cjs":1943,"./TabClose.cjs":1944,"./TableRow.cjs":1945,"./Tablet.cjs":1946,"./Tag.cjs":1947,"./ThumbDown.cjs":1948,"./ThumbDownFilled.cjs":1949,"./ThumbUp.cjs":1950,"./ThumbUpFilled.cjs":1951,"./Tint.cjs":1952,"./Tooltip.cjs":1953,"./Translate.cjs":1954,"./Trash.cjs":1955,"./TrendDown.cjs":1956,"./TrendUp.cjs":1957,"./Undo.cjs":1958,"./Unfold.cjs":1959,"./UnlockedFilled.cjs":1960,"./Unpin.cjs":1961,"./Upload.cjs":1962,"./UploadFile.cjs":1963,"./Usb.cjs":1964,"./User.cjs":1965,"./UserCheck.cjs":1966,"./UserCircle.cjs":1967,"./UserCircleAdd.cjs":1968,"./UserCircleRemove.cjs":1969,"./Verified.cjs":1970,"./VerifiedFilled.cjs":1971,"./Videocam.cjs":1972,"./ViewColumn.cjs":1973,"./ViewInAr.cjs":1974,"./VolumeOff.cjs":1975,"./VolumeUp.cjs":1976,"./Wallet.cjs":1977,"./WalletFilled.cjs":1978,"./Warning.cjs":1979,"./WebTraffic.cjs":1980,"./Widgets.cjs":1981,"./Wifi.cjs":1982,"./WifiOff.cjs":1983,"./X.cjs":1984},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.Icons=void 0;const a=n(e("./Accessibility.cjs")),i=n(e("./Activity.cjs")),s=n(e("./Add.cjs")),o=n(e("./AddCard.cjs")),c=n(e("./AddCircle.cjs")),l=n(e("./AddSquare.cjs")),u=n(e("./Ai.cjs")),d=n(e("./AlternateEmail.cjs")),f=n(e("./AppleLogo.cjs")),m=n(e("./Apps.cjs")),h=n(e("./Arrow2Down.cjs")),p=n(e("./Arrow2Left.cjs")),g=n(e("./Arrow2Right.cjs")),b=n(e("./Arrow2Up.cjs")),y=n(e("./Arrow2UpRight.cjs")),v=n(e("./ArrowCircleDown.cjs")),w=n(e("./ArrowCircleUp.cjs")),_=n(e("./ArrowDoubleLeft.cjs")),j=n(e("./ArrowDoubleRight.cjs")),O=n(e("./ArrowDown.cjs")),E=n(e("./ArrowDropDownCircle.cjs")),C=n(e("./ArrowLeft.cjs")),k=n(e("./ArrowRight.cjs")),x=n(e("./ArrowUp.cjs")),T=n(e("./AttachMoney.cjs")),A=n(e("./Attachment.cjs")),P=n(e("./Backspace.cjs")),B=n(e("./Ban.cjs")),S=n(e("./Bank.cjs")),M=n(e("./BankAssured.cjs")),D=n(e("./Bold.cjs")),I=n(e("./Book.cjs")),R=n(e("./Bookmark.cjs")),q=n(e("./Bridge.cjs")),F=n(e("./Briefcase.cjs")),N=n(e("./Bulb.cjs")),L=n(e("./BuySell.cjs")),H=n(e("./Cake.cjs")),z=n(e("./Calculator.cjs")),V=n(e("./Calendar.cjs")),U=n(e("./Call.cjs")),$=n(e("./Camera.cjs")),G=n(e("./Campaign.cjs")),K=n(e("./Candlestick.cjs")),W=n(e("./Card.cjs")),X=n(e("./CardPos.cjs")),Y=n(e("./Cash.cjs")),Q=n(e("./Category.cjs")),Z=n(e("./Chart.cjs")),J=n(e("./Check.cjs")),ee=n(e("./CheckBold.cjs")),te=n(e("./CircleX.cjs")),re=n(e("./Clear.cjs")),ne=n(e("./Clock.cjs")),ae=n(e("./ClockFilled.cjs")),ie=n(e("./Close.cjs")),se=n(e("./Cloud.cjs")),oe=n(e("./CloudDownload.cjs")),ce=n(e("./CloudUpload.cjs")),le=n(e("./Code.cjs")),ue=n(e("./CodeCircle.cjs")),de=n(e("./Coin.cjs")),fe=n(e("./Collapse.cjs")),me=n(e("./Confirmation.cjs")),he=n(e("./Connect.cjs")),pe=n(e("./Copy.cjs")),ge=n(e("./CopySuccess.cjs")),be=n(e("./CreditCheck.cjs")),ye=n(e("./CurrencyFranc.cjs")),ve=n(e("./CurrencyLira.cjs")),we=n(e("./CurrencyPound.cjs")),_e=n(e("./CurrencyYuan.cjs")),je=n(e("./Customize.cjs")),Oe=n(e("./Danger.cjs")),Ee=n(e("./Dark.cjs")),Ce=n(e("./DarkFilled.cjs")),ke=n(e("./Data.cjs")),xe=n(e("./Description.cjs")),Te=n(e("./Details.cjs")),Ae=n(e("./Diagram.cjs")),Pe=n(e("./DocumentCode.cjs")),Be=n(e("./Download.cjs")),Se=n(e("./Draft.cjs")),Me=n(e("./EcoLeaf.cjs")),De=n(e("./Edit.cjs")),Ie=n(e("./EditSquare.cjs")),Re=n(e("./EncryptedAdd.cjs")),qe=n(e("./Eraser.cjs")),Fe=n(e("./Error.cjs")),Ne=n(e("./Ethereum.cjs")),Le=n(e("./Exchange.cjs")),He=n(e("./Expand.cjs")),ze=n(e("./ExpandVertical.cjs")),Ve=n(e("./Explore.cjs")),Ue=n(e("./ExploreFilled.cjs")),$e=n(e("./Export.cjs")),Ge=n(e("./Extension.cjs")),Ke=n(e("./Eye.cjs")),We=n(e("./EyeSlash.cjs")),Xe=n(e("./FaceId.cjs")),Ye=n(e("./Feedback.cjs")),Qe=n(e("./File.cjs")),Ze=n(e("./Filter.cjs")),Je=n(e("./Fingerprint.cjs")),et=n(e("./Fire.cjs")),tt=n(e("./FirstPage.cjs")),rt=n(e("./Flag.cjs")),nt=n(e("./Flash.cjs")),at=n(e("./FlashSlash.cjs")),it=n(e("./Flask.cjs")),st=n(e("./Flower.cjs")),ot=n(e("./Folder.cjs")),ct=n(e("./Forest.cjs")),lt=n(e("./FullCircle.cjs")),ut=n(e("./Gas.cjs")),dt=n(e("./Gift.cjs")),ft=n(e("./Global.cjs")),mt=n(e("./GlobalSearch.cjs")),ht=n(e("./Graph.cjs")),pt=n(e("./Hardware.cjs")),gt=n(e("./HashTag.cjs")),bt=n(e("./Heart.cjs")),yt=n(e("./HeartFilled.cjs")),vt=n(e("./Hierarchy.cjs")),wt=n(e("./Home.cjs")),_t=n(e("./HomeFilled.cjs")),jt=n(e("./Image.cjs")),Ot=n(e("./Info.cjs")),Et=n(e("./Inventory.cjs")),Ct=n(e("./Joystick.cjs")),kt=n(e("./Keep.cjs")),xt=n(e("./KeepFilled.cjs")),Tt=n(e("./Key.cjs")),At=n(e("./LastPage.cjs")),Pt=n(e("./Light.cjs")),Bt=n(e("./LightFilled.cjs")),St=n(e("./Link.cjs")),Mt=n(e("./Loading.cjs")),Dt=n(e("./Location.cjs")),It=n(e("./Lock.cjs")),Rt=n(e("./LockSlash.cjs")),qt=n(e("./LockedFilled.cjs")),Ft=n(e("./Login.cjs")),Nt=n(e("./Logout.cjs")),Lt=n(e("./Mail.cjs")),Ht=n(e("./Map.cjs")),zt=n(e("./Menu.cjs")),Vt=n(e("./MessageQuestion.cjs")),Ut=n(e("./Messages.cjs")),$t=n(e("./MetamaskFoxOutline.cjs")),Gt=n(e("./Mic.cjs")),Kt=n(e("./Minus.cjs")),Wt=n(e("./MinusBold.cjs")),Xt=n(e("./MinusSquare.cjs")),Yt=n(e("./Mobile.cjs")),Qt=n(e("./Money.cjs")),Zt=n(e("./MoneyBag.cjs")),Jt=n(e("./Monitor.cjs")),er=n(e("./MoreHorizontal.cjs")),tr=n(e("./MoreVertical.cjs")),rr=n(e("./MountainFlag.cjs")),nr=n(e("./MusicNote.cjs")),ar=n(e("./Notification.cjs")),ir=n(e("./PageInfo.cjs")),sr=n(e("./Palette.cjs")),or=n(e("./PasswordCheck.cjs")),cr=n(e("./Pending.cjs")),lr=n(e("./People.cjs")),ur=n(e("./PersonCancel.cjs")),dr=n(e("./Pin.cjs")),fr=n(e("./Plant.cjs")),mr=n(e("./Plug.cjs")),hr=n(e("./PlusAndMinus.cjs")),pr=n(e("./PolicyAlert.cjs")),gr=n(e("./Print.cjs")),br=n(e("./PriorityHigh.cjs")),yr=n(e("./PrivacyTip.cjs")),vr=n(e("./ProgrammingArrows.cjs")),wr=n(e("./Publish.cjs")),_r=n(e("./QrCode.cjs")),jr=n(e("./Question.cjs")),Or=n(e("./Receive.cjs")),Er=n(e("./Received.cjs")),Cr=n(e("./Refresh.cjs")),kr=n(e("./RemoveMinus.cjs")),xr=n(e("./Report.cjs")),Tr=n(e("./Rocket.cjs")),Ar=n(e("./Save.cjs")),Pr=n(e("./SaveFilled.cjs")),Br=n(e("./Saving.cjs")),Sr=n(e("./Scan.cjs")),Mr=n(e("./ScanBarcode.cjs")),Dr=n(e("./ScanFocus.cjs")),Ir=n(e("./Search.cjs")),Rr=n(e("./Security.cjs")),qr=n(e("./SecurityAlert.cjs")),Fr=n(e("./SecurityCross.cjs")),Nr=n(e("./SecurityKey.cjs")),Lr=n(e("./SecuritySearch.cjs")),Hr=n(e("./SecuritySlash.cjs")),zr=n(e("./SecurityTick.cjs")),Vr=n(e("./SecurityTime.cjs")),Ur=n(e("./SecurityUser.cjs")),$r=n(e("./Send.cjs")),Gr=n(e("./SentimentDissatisfied.cjs")),Kr=n(e("./SentimentNeutral.cjs")),Wr=n(e("./SentimentSatisfied.cjs")),Xr=n(e("./SentimentVerySatisfied.cjs")),Yr=n(e("./Setting.cjs")),Qr=n(e("./SettingFilled.cjs")),Zr=n(e("./Share.cjs")),Jr=n(e("./ShieldLock.cjs")),en=n(e("./ShoppingBag.cjs")),tn=n(e("./ShoppingCart.cjs")),rn=n(e("./SignalCellular.cjs")),nn=n(e("./Slash.cjs")),an=n(e("./Sms.cjs")),sn=n(e("./Snaps.cjs")),on=n(e("./SnapsMobile.cjs")),cn=n(e("./SnapsPlus.cjs")),ln=n(e("./SnapsRound.cjs")),un=n(e("./Sort.cjs")),dn=n(e("./SortByAlpha.cjs")),fn=n(e("./Sparkle.cjs")),mn=n(e("./Speed.cjs")),hn=n(e("./Speedometer.cjs")),pn=n(e("./Square.cjs")),gn=n(e("./Stake.cjs")),bn=n(e("./Star.cjs")),yn=n(e("./StarFilled.cjs")),vn=n(e("./Start.cjs")),wn=n(e("./Storefront.cjs")),_n=n(e("./Student.cjs")),jn=n(e("./SwapHorizontal.cjs")),On=n(e("./SwapVertical.cjs")),En=n(e("./TabClose.cjs")),Cn=n(e("./TableRow.cjs")),kn=n(e("./Tablet.cjs")),xn=n(e("./Tag.cjs")),Tn=n(e("./ThumbDown.cjs")),An=n(e("./ThumbDownFilled.cjs")),Pn=n(e("./ThumbUp.cjs")),Bn=n(e("./ThumbUpFilled.cjs")),Sn=n(e("./Tint.cjs")),Mn=n(e("./Tooltip.cjs")),Dn=n(e("./Translate.cjs")),In=n(e("./Trash.cjs")),Rn=n(e("./TrendDown.cjs")),qn=n(e("./TrendUp.cjs")),Fn=n(e("./Undo.cjs")),Nn=n(e("./Unfold.cjs")),Ln=n(e("./UnlockedFilled.cjs")),Hn=n(e("./Unpin.cjs")),zn=n(e("./Upload.cjs")),Vn=n(e("./UploadFile.cjs")),Un=n(e("./Usb.cjs")),$n=n(e("./User.cjs")),Gn=n(e("./UserCheck.cjs")),Kn=n(e("./UserCircle.cjs")),Wn=n(e("./UserCircleAdd.cjs")),Xn=n(e("./UserCircleRemove.cjs")),Yn=n(e("./Verified.cjs")),Qn=n(e("./VerifiedFilled.cjs")),Zn=n(e("./Videocam.cjs")),Jn=n(e("./ViewColumn.cjs")),ea=n(e("./ViewInAr.cjs")),ta=n(e("./VolumeOff.cjs")),ra=n(e("./VolumeUp.cjs")),na=n(e("./Wallet.cjs")),aa=n(e("./WalletFilled.cjs")),ia=n(e("./Warning.cjs")),sa=n(e("./WebTraffic.cjs")),oa=n(e("./Widgets.cjs")),ca=n(e("./Wifi.cjs")),la=n(e("./WifiOff.cjs")),ua=n(e("./X.cjs"));r.Icons={Accessibility:a.default,Activity:i.default,Add:s.default,AddCard:o.default,AddCircle:c.default,AddSquare:l.default,Ai:u.default,AlternateEmail:d.default,AppleLogo:f.default,Apps:m.default,Arrow2Down:h.default,Arrow2Left:p.default,Arrow2Right:g.default,Arrow2Up:b.default,Arrow2UpRight:y.default,ArrowCircleDown:v.default,ArrowCircleUp:w.default,ArrowDoubleLeft:_.default,ArrowDoubleRight:j.default,ArrowDown:O.default,ArrowDropDownCircle:E.default,ArrowLeft:C.default,ArrowRight:k.default,ArrowUp:x.default,AttachMoney:T.default,Attachment:A.default,Backspace:P.default,Ban:B.default,Bank:S.default,BankAssured:M.default,Bold:D.default,Book:I.default,Bookmark:R.default,Bridge:q.default,Briefcase:F.default,Bulb:N.default,BuySell:L.default,Cake:H.default,Calculator:z.default,Calendar:V.default,Call:U.default,Camera:$.default,Campaign:G.default,Candlestick:K.default,Card:W.default,CardPos:X.default,Cash:Y.default,Category:Q.default,Chart:Z.default,Check:J.default,CheckBold:ee.default,CircleX:te.default,Clear:re.default,Clock:ne.default,ClockFilled:ae.default,Close:ie.default,Cloud:se.default,CloudDownload:oe.default,CloudUpload:ce.default,Code:le.default,CodeCircle:ue.default,Coin:de.default,Collapse:fe.default,Confirmation:me.default,Connect:he.default,Copy:pe.default,CopySuccess:ge.default,CreditCheck:be.default,CurrencyFranc:ye.default,CurrencyLira:ve.default,CurrencyPound:we.default,CurrencyYuan:_e.default,Customize:je.default,Danger:Oe.default,Dark:Ee.default,DarkFilled:Ce.default,Data:ke.default,Description:xe.default,Details:Te.default,Diagram:Ae.default,DocumentCode:Pe.default,Download:Be.default,Draft:Se.default,EcoLeaf:Me.default,Edit:De.default,EditSquare:Ie.default,EncryptedAdd:Re.default,Eraser:qe.default,Error:Fe.default,Ethereum:Ne.default,Exchange:Le.default,Expand:He.default,ExpandVertical:ze.default,Explore:Ve.default,ExploreFilled:Ue.default,Export:$e.default,Extension:Ge.default,Eye:Ke.default,EyeSlash:We.default,FaceId:Xe.default,Feedback:Ye.default,File:Qe.default,Filter:Ze.default,Fingerprint:Je.default,Fire:et.default,FirstPage:tt.default,Flag:rt.default,Flash:nt.default,FlashSlash:at.default,Flask:it.default,Flower:st.default,Folder:ot.default,Forest:ct.default,FullCircle:lt.default,Gas:ut.default,Gift:dt.default,Global:ft.default,GlobalSearch:mt.default,Graph:ht.default,Hardware:pt.default,HashTag:gt.default,Heart:bt.default,HeartFilled:yt.default,Hierarchy:vt.default,Home:wt.default,HomeFilled:_t.default,Image:jt.default,Info:Ot.default,Inventory:Et.default,Joystick:Ct.default,Keep:kt.default,KeepFilled:xt.default,Key:Tt.default,LastPage:At.default,Light:Pt.default,LightFilled:Bt.default,Link:St.default,Loading:Mt.default,Location:Dt.default,Lock:It.default,LockSlash:Rt.default,LockedFilled:qt.default,Login:Ft.default,Logout:Nt.default,Mail:Lt.default,Map:Ht.default,Menu:zt.default,MessageQuestion:Vt.default,Messages:Ut.default,MetamaskFoxOutline:$t.default,Mic:Gt.default,Minus:Kt.default,MinusBold:Wt.default,MinusSquare:Xt.default,Mobile:Yt.default,Money:Qt.default,MoneyBag:Zt.default,Monitor:Jt.default,MoreHorizontal:er.default,MoreVertical:tr.default,MountainFlag:rr.default,MusicNote:nr.default,Notification:ar.default,PageInfo:ir.default,Palette:sr.default,PasswordCheck:or.default,Pending:cr.default,People:lr.default,PersonCancel:ur.default,Pin:dr.default,Plant:fr.default,Plug:mr.default,PlusAndMinus:hr.default,PolicyAlert:pr.default,Print:gr.default,PriorityHigh:br.default,PrivacyTip:yr.default,ProgrammingArrows:vr.default,Publish:wr.default,QrCode:_r.default,Question:jr.default,Receive:Or.default,Received:Er.default,Refresh:Cr.default,RemoveMinus:kr.default,Report:xr.default,Rocket:Tr.default,Save:Ar.default,SaveFilled:Pr.default,Saving:Br.default,Scan:Sr.default,ScanBarcode:Mr.default,ScanFocus:Dr.default,Search:Ir.default,Security:Rr.default,SecurityAlert:qr.default,SecurityCross:Fr.default,SecurityKey:Nr.default,SecuritySearch:Lr.default,SecuritySlash:Hr.default,SecurityTick:zr.default,SecurityTime:Vr.default,SecurityUser:Ur.default,Send:$r.default,SentimentDissatisfied:Gr.default,SentimentNeutral:Kr.default,SentimentSatisfied:Wr.default,SentimentVerySatisfied:Xr.default,Setting:Yr.default,SettingFilled:Qr.default,Share:Zr.default,ShieldLock:Jr.default,ShoppingBag:en.default,ShoppingCart:tn.default,SignalCellular:rn.default,Slash:nn.default,Sms:an.default,Snaps:sn.default,SnapsMobile:on.default,SnapsPlus:cn.default,SnapsRound:ln.default,Sort:un.default,SortByAlpha:dn.default,Sparkle:fn.default,Speed:mn.default,Speedometer:hn.default,Square:pn.default,Stake:gn.default,Star:bn.default,StarFilled:yn.default,Start:vn.default,Storefront:wn.default,Student:_n.default,SwapHorizontal:jn.default,SwapVertical:On.default,TabClose:En.default,TableRow:Cn.default,Tablet:kn.default,Tag:xn.default,ThumbDown:Tn.default,ThumbDownFilled:An.default,ThumbUp:Pn.default,ThumbUpFilled:Bn.default,Tint:Sn.default,Tooltip:Mn.default,Translate:Dn.default,Trash:In.default,TrendDown:Rn.default,TrendUp:qn.default,Undo:Fn.default,Unfold:Nn.default,UnlockedFilled:Ln.default,Unpin:Hn.default,Upload:zn.default,UploadFile:Vn.default,Usb:Un.default,User:$n.default,UserCheck:Gn.default,UserCircle:Kn.default,UserCircleAdd:Wn.default,UserCircleRemove:Xn.default,Verified:Yn.default,VerifiedFilled:Qn.default,Videocam:Zn.default,ViewColumn:Jn.default,ViewInAr:ea.default,VolumeOff:ta.default,VolumeUp:ra.default,Wallet:na.default,WalletFilled:aa.default,Warning:ia.default,WebTraffic:sa.default,Widgets:oa.default,Wifi:ca.default,WifiOff:la.default,X:ua.default}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/index.cjs"}],[1986,{"../../types/index.cjs":2002,"./Icon.cjs":1707},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Icon=r.IconColor=r.IconSize=r.IconName=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"IconName",{enumerable:!0,get:function(){return n.IconName}}),Object.defineProperty(r,"IconSize",{enumerable:!0,get:function(){return n.IconSize}}),Object.defineProperty(r,"IconColor",{enumerable:!0,get:function(){return n.IconColor}});var a=e("./Icon.cjs");Object.defineProperty(r,"Icon",{enumerable:!0,get:function(){return a.Icon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs"}],[1987,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"./Text.constants.cjs":1988,"@radix-ui/react-slot":2006,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.Text=void 0;const a=e("@radix-ui/react-slot"),i=n(e("react")),s=e("../../types/index.cjs"),o=e("../../utils/tw-merge.cjs"),c=e("./Text.constants.cjs");r.Text=({variant:e=s.TextVariant.BodyMd,children:t,className:r,fontWeight:n,fontFamily:l=s.FontFamily.Default,fontStyle:u,textTransform:d,textAlign:f,overflowWrap:m,ellipsis:h,asChild:p,color:g=s.TextColor.TextDefault,style:b,...y})=>{const v=p?a.Slot:c.MAP_TEXT_VARIANT_TAG[e],w=`${(0,o.twMerge)(g,c.CLASSMAP_TEXT_VARIANT_FONTSTYLE[e],n||c.CLASSMAP_TEXT_VARIANT_FONTWEIGHT[e],u,l,d,f,m,h&&"truncate",r)}`;return i.default.createElement(v,{className:w,style:b,...y},t)}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Text/Text.cjs"}],[1988,{"../../types/index.cjs":2002},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAP_TEXT_VARIANT_TAG=r.CLASSMAP_TEXT_VARIANT_FONTWEIGHT=r.CLASSMAP_TEXT_VARIANT_FONTSTYLE=void 0;const n=e("../../types/index.cjs");r.CLASSMAP_TEXT_VARIANT_FONTSTYLE={[n.TextVariant.DisplayLg]:"text-s-display-lg leading-s-display-lg tracking-s-display-lg md:text-l-display-lg md:leading-l-display-lg md:tracking-l-display-lg",[n.TextVariant.DisplayMd]:"text-s-display-md leading-s-display-md tracking-s-display-md md:text-l-display-md md:leading-l-display-md md:tracking-l-display-md",[n.TextVariant.HeadingLg]:"text-s-heading-lg leading-s-heading-lg tracking-s-heading-lg md:text-l-heading-lg md:leading-l-heading-lg md:tracking-l-heading-lg",[n.TextVariant.HeadingMd]:"text-s-heading-md leading-s-heading-md tracking-s-heading-md md:text-l-heading-md md:leading-l-heading-md md:tracking-l-heading-md",[n.TextVariant.HeadingSm]:"text-s-heading-sm leading-s-heading-sm tracking-s-heading-sm md:text-l-heading-sm md:leading-l-heading-sm md:tracking-l-heading-sm",[n.TextVariant.BodyLg]:"text-s-body-lg leading-s-body-lg tracking-s-body-lg md:text-l-body-lg md:leading-l-body-lg md:tracking-l-body-lg",[n.TextVariant.BodyMd]:"text-s-body-md leading-s-body-md tracking-s-body-md md:text-l-body-md md:leading-l-body-md md:tracking-l-body-md",[n.TextVariant.BodySm]:"text-s-body-sm leading-s-body-sm tracking-s-body-sm md:text-l-body-sm md:leading-l-body-sm md:tracking-l-body-sm",[n.TextVariant.BodyXs]:"text-s-body-xs leading-s-body-xs tracking-s-body-xs md:text-l-body-xs md:leading-l-body-xs md:tracking-l-body-xs",[n.TextVariant.PageHeading]:"text-s-page-heading leading-s-page-heading tracking-s-page-heading md:text-l-page-heading md:leading-l-page-heading md:tracking-l-page-heading",[n.TextVariant.SectionHeading]:"text-s-section-heading leading-s-section-heading tracking-s-section-heading md:text-l-section-heading md:leading-l-section-heading md:tracking-l-section-heading",[n.TextVariant.ButtonLabelMd]:"text-s-button-label-md leading-s-button-label-md tracking-s-button-label-md md:text-l-button-label-md md:leading-l-button-label-md md:tracking-l-button-label-md",[n.TextVariant.ButtonLabelLg]:"text-s-button-label-lg leading-s-button-label-lg tracking-s-button-label-lg md:text-l-button-label-lg md:leading-l-button-label-lg md:tracking-l-button-label-lg",[n.TextVariant.AmountDisplayLg]:"text-s-amount-display-lg leading-s-amount-display-lg tracking-s-amount-display-lg md:text-l-amount-display-lg md:leading-l-amount-display-lg md:tracking-l-amount-display-lg"},r.CLASSMAP_TEXT_VARIANT_FONTWEIGHT={[n.TextVariant.DisplayLg]:"font-bold md:font-medium",[n.TextVariant.DisplayMd]:"font-bold md:font-medium",[n.TextVariant.HeadingLg]:"font-bold",[n.TextVariant.HeadingMd]:"font-bold",[n.TextVariant.HeadingSm]:"font-bold",[n.TextVariant.BodyLg]:"font-medium",[n.TextVariant.BodyMd]:"font-regular",[n.TextVariant.BodySm]:"font-regular",[n.TextVariant.BodyXs]:"font-regular",[n.TextVariant.PageHeading]:"font-bold",[n.TextVariant.SectionHeading]:"font-bold",[n.TextVariant.ButtonLabelMd]:"font-medium",[n.TextVariant.ButtonLabelLg]:"font-medium",[n.TextVariant.AmountDisplayLg]:"font-bold md:font-medium"},r.MAP_TEXT_VARIANT_TAG={[n.TextVariant.DisplayLg]:"h1",[n.TextVariant.DisplayMd]:"h1",[n.TextVariant.HeadingLg]:"h2",[n.TextVariant.HeadingMd]:"h3",[n.TextVariant.HeadingSm]:"h4",[n.TextVariant.BodyLg]:"p",[n.TextVariant.BodyMd]:"p",[n.TextVariant.BodySm]:"p",[n.TextVariant.BodyXs]:"p",[n.TextVariant.PageHeading]:"h1",[n.TextVariant.SectionHeading]:"h2",[n.TextVariant.ButtonLabelMd]:"span",[n.TextVariant.ButtonLabelLg]:"span",[n.TextVariant.AmountDisplayLg]:"span"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Text/Text.constants.cjs"}],[1989,{"../../types/index.cjs":2002,"./Text.cjs":1987},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Text=r.TextColor=r.TextTransform=r.TextVariant=r.TextAlign=r.OverflowWrap=r.FontWeight=r.FontStyle=r.FontFamily=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"FontFamily",{enumerable:!0,get:function(){return n.FontFamily}}),Object.defineProperty(r,"FontStyle",{enumerable:!0,get:function(){return n.FontStyle}}),Object.defineProperty(r,"FontWeight",{enumerable:!0,get:function(){return n.FontWeight}}),Object.defineProperty(r,"OverflowWrap",{enumerable:!0,get:function(){return n.OverflowWrap}}),Object.defineProperty(r,"TextAlign",{enumerable:!0,get:function(){return n.TextAlign}}),Object.defineProperty(r,"TextVariant",{enumerable:!0,get:function(){return n.TextVariant}}),Object.defineProperty(r,"TextTransform",{enumerable:!0,get:function(){return n.TextTransform}}),Object.defineProperty(r,"TextColor",{enumerable:!0,get:function(){return n.TextColor}});var a=e("./Text.cjs");Object.defineProperty(r,"Text",{enumerable:!0,get:function(){return a.Text}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Text/index.cjs"}],[1990,{"../../types/index.cjs":2002,"../../utils/tw-merge.cjs":2004,"../ButtonBase/index.cjs":1699,"./TextButton.constants.cjs":1991,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.TextButton=void 0;const s=i(e("react")),o=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),l=e("../ButtonBase/index.cjs"),u=e("./TextButton.constants.cjs");r.TextButton=(0,s.forwardRef)(({className:e,isInverse:t,isDisabled:r,size:n=o.TextButtonSize.BodyMd,textProps:a,...i},d)=>{const f=(0,c.twMerge)("h-auto rounded-none bg-transparent px-0","transform-none transition-none active:scale-100",!t&&"text-primary-default",t&&"text-primary-inverse",!r&&[!t&&["hover:bg-hover hover:text-primary-default-hover hover:underline hover:decoration-primary-default-hover hover:decoration-2 hover:underline-offset-4","active:bg-pressed active:text-primary-default-pressed active:decoration-primary-default-pressed"],t&&["hover:bg-hover hover:text-primary-inverse hover:underline hover:decoration-primary-inverse hover:decoration-2 hover:underline-offset-4","active:bg-pressed active:text-primary-inverse active:decoration-primary-inverse"]],r&&["opacity-50","cursor-not-allowed"],e);return s.default.createElement(l.ButtonBase,{ref:d,className:f,isDisabled:r,textProps:{variant:u.MAP_TEXTBUTTON_SIZE_TEXTVARIANT[n],...a},...i})}),r.TextButton.displayName="TextButton"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.cjs"}],[1991,{"../../types/index.cjs":2002,"../Text/index.cjs":1989},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAP_TEXTBUTTON_SIZE_TEXTVARIANT=void 0;const n=e("../../types/index.cjs"),a=e("../Text/index.cjs");r.MAP_TEXTBUTTON_SIZE_TEXTVARIANT={[n.TextButtonSize.BodyXs]:a.TextVariant.BodyXs,[n.TextButtonSize.BodySm]:a.TextVariant.BodySm,[n.TextButtonSize.BodyMd]:a.TextVariant.BodyMd,[n.TextButtonSize.BodyLg]:a.TextVariant.BodyLg}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.constants.cjs"}],[1992,{"../../types/index.cjs":2002,"./TextButton.cjs":1990},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.TextButton=r.TextButtonSize=void 0;var n=e("../../types/index.cjs");Object.defineProperty(r,"TextButtonSize",{enumerable:!0,get:function(){return n.TextButtonSize}});var a=e("./TextButton.cjs");Object.defineProperty(r,"TextButton",{enumerable:!0,get:function(){return a.TextButton}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/TextButton/index.cjs"}],[1993,{"./AvatarAccount/index.cjs":1658,"./AvatarBase/index.cjs":1661,"./AvatarFavicon/index.cjs":1663,"./AvatarGroup/index.cjs":1666,"./AvatarIcon/index.cjs":1669,"./AvatarNetwork/index.cjs":1671,"./AvatarToken/index.cjs":1673,"./BadgeCount/index.cjs":1676,"./BadgeIcon/index.cjs":1678,"./BadgeNetwork/index.cjs":1680,"./BadgeStatus/index.cjs":1683,"./BadgeWrapper/index.cjs":1685,"./Box/index.cjs":1688,"./Button/index.cjs":1690,"./ButtonBase/index.cjs":1699,"./ButtonHero/index.cjs":1701,"./ButtonIcon/index.cjs":1704,"./Checkbox/index.cjs":1706,"./Icon/index.cjs":1986,"./Text/index.cjs":1989,"./TextButton/index.cjs":1992,"./temp-components/Blockies/index.cjs":1995,"./temp-components/Jazzicon/index.cjs":1997,"./temp-components/Maskicon/index.cjs":2e3},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Maskicon=r.Jazzicon=r.IconColor=r.IconSize=r.IconName=r.Icon=r.Checkbox=r.ButtonIconSize=r.ButtonIcon=r.ButtonBaseSize=r.ButtonBase=r.ButtonVariant=r.ButtonSize=r.Button=r.Box=r.BoxBorderColor=r.BoxBackgroundColor=r.BoxJustifyContent=r.BoxAlignItems=r.BoxFlexWrap=r.BoxFlexDirection=r.Blockies=r.BadgeWrapperPositionAnchorShape=r.BadgeWrapperPosition=r.BadgeWrapper=r.BadgeStatusSize=r.BadgeStatusStatus=r.BadgeStatus=r.BadgeNetwork=r.BadgeIcon=r.BadgeCountSize=r.BadgeCount=r.AvatarTokenSize=r.AvatarToken=r.AvatarNetworkSize=r.AvatarNetwork=r.AvatarIconSeverity=r.AvatarIconSize=r.AvatarIcon=r.AvatarGroupVariant=r.AvatarGroupSize=r.AvatarGroup=r.AvatarFaviconSize=r.AvatarFavicon=r.AvatarBaseShape=r.AvatarBaseSize=r.AvatarBase=r.AvatarAccountVariant=r.AvatarAccountSize=r.AvatarAccount=void 0,r.ButtonHeroSize=r.ButtonHero=r.TextButtonSize=r.TextButton=r.OverflowWrap=r.TextTransform=r.FontStyle=r.FontFamily=r.FontWeight=r.TextAlign=r.TextColor=r.TextVariant=r.Text=void 0;var n=e("./AvatarAccount/index.cjs");Object.defineProperty(r,"AvatarAccount",{enumerable:!0,get:function(){return n.AvatarAccount}}),Object.defineProperty(r,"AvatarAccountSize",{enumerable:!0,get:function(){return n.AvatarAccountSize}}),Object.defineProperty(r,"AvatarAccountVariant",{enumerable:!0,get:function(){return n.AvatarAccountVariant}});var a=e("./AvatarBase/index.cjs");Object.defineProperty(r,"AvatarBase",{enumerable:!0,get:function(){return a.AvatarBase}}),Object.defineProperty(r,"AvatarBaseSize",{enumerable:!0,get:function(){return a.AvatarBaseSize}}),Object.defineProperty(r,"AvatarBaseShape",{enumerable:!0,get:function(){return a.AvatarBaseShape}});var i=e("./AvatarFavicon/index.cjs");Object.defineProperty(r,"AvatarFavicon",{enumerable:!0,get:function(){return i.AvatarFavicon}}),Object.defineProperty(r,"AvatarFaviconSize",{enumerable:!0,get:function(){return i.AvatarFaviconSize}});var s=e("./AvatarGroup/index.cjs");Object.defineProperty(r,"AvatarGroup",{enumerable:!0,get:function(){return s.AvatarGroup}}),Object.defineProperty(r,"AvatarGroupSize",{enumerable:!0,get:function(){return s.AvatarGroupSize}}),Object.defineProperty(r,"AvatarGroupVariant",{enumerable:!0,get:function(){return s.AvatarGroupVariant}});var o=e("./AvatarIcon/index.cjs");Object.defineProperty(r,"AvatarIcon",{enumerable:!0,get:function(){return o.AvatarIcon}}),Object.defineProperty(r,"AvatarIconSize",{enumerable:!0,get:function(){return o.AvatarIconSize}}),Object.defineProperty(r,"AvatarIconSeverity",{enumerable:!0,get:function(){return o.AvatarIconSeverity}});var c=e("./AvatarNetwork/index.cjs");Object.defineProperty(r,"AvatarNetwork",{enumerable:!0,get:function(){return c.AvatarNetwork}}),Object.defineProperty(r,"AvatarNetworkSize",{enumerable:!0,get:function(){return c.AvatarNetworkSize}});var l=e("./AvatarToken/index.cjs");Object.defineProperty(r,"AvatarToken",{enumerable:!0,get:function(){return l.AvatarToken}}),Object.defineProperty(r,"AvatarTokenSize",{enumerable:!0,get:function(){return l.AvatarTokenSize}});var u=e("./BadgeCount/index.cjs");Object.defineProperty(r,"BadgeCount",{enumerable:!0,get:function(){return u.BadgeCount}});var d=e("./BadgeCount/index.cjs");Object.defineProperty(r,"BadgeCountSize",{enumerable:!0,get:function(){return d.BadgeCountSize}});var f=e("./BadgeIcon/index.cjs");Object.defineProperty(r,"BadgeIcon",{enumerable:!0,get:function(){return f.BadgeIcon}});var m=e("./BadgeNetwork/index.cjs");Object.defineProperty(r,"BadgeNetwork",{enumerable:!0,get:function(){return m.BadgeNetwork}});var h=e("./BadgeStatus/index.cjs");Object.defineProperty(r,"BadgeStatus",{enumerable:!0,get:function(){return h.BadgeStatus}});var p=e("./BadgeStatus/index.cjs");Object.defineProperty(r,"BadgeStatusStatus",{enumerable:!0,get:function(){return p.BadgeStatusStatus}}),Object.defineProperty(r,"BadgeStatusSize",{enumerable:!0,get:function(){return p.BadgeStatusSize}});var g=e("./BadgeWrapper/index.cjs");Object.defineProperty(r,"BadgeWrapper",{enumerable:!0,get:function(){return g.BadgeWrapper}});var b=e("./BadgeWrapper/index.cjs");Object.defineProperty(r,"BadgeWrapperPosition",{enumerable:!0,get:function(){return b.BadgeWrapperPosition}}),Object.defineProperty(r,"BadgeWrapperPositionAnchorShape",{enumerable:!0,get:function(){return b.BadgeWrapperPositionAnchorShape}});var y=e("./temp-components/Blockies/index.cjs");Object.defineProperty(r,"Blockies",{enumerable:!0,get:function(){return y.Blockies}});var v=e("./Box/index.cjs");Object.defineProperty(r,"BoxFlexDirection",{enumerable:!0,get:function(){return v.BoxFlexDirection}}),Object.defineProperty(r,"BoxFlexWrap",{enumerable:!0,get:function(){return v.BoxFlexWrap}}),Object.defineProperty(r,"BoxAlignItems",{enumerable:!0,get:function(){return v.BoxAlignItems}}),Object.defineProperty(r,"BoxJustifyContent",{enumerable:!0,get:function(){return v.BoxJustifyContent}}),Object.defineProperty(r,"BoxBackgroundColor",{enumerable:!0,get:function(){return v.BoxBackgroundColor}}),Object.defineProperty(r,"BoxBorderColor",{enumerable:!0,get:function(){return v.BoxBorderColor}}),Object.defineProperty(r,"Box",{enumerable:!0,get:function(){return v.Box}});var w=e("./Button/index.cjs");Object.defineProperty(r,"Button",{enumerable:!0,get:function(){return w.Button}}),Object.defineProperty(r,"ButtonSize",{enumerable:!0,get:function(){return w.ButtonSize}}),Object.defineProperty(r,"ButtonVariant",{enumerable:!0,get:function(){return w.ButtonVariant}});var _=e("./ButtonBase/index.cjs");Object.defineProperty(r,"ButtonBase",{enumerable:!0,get:function(){return _.ButtonBase}});var j=e("./ButtonBase/index.cjs");Object.defineProperty(r,"ButtonBaseSize",{enumerable:!0,get:function(){return j.ButtonBaseSize}});var O=e("./ButtonIcon/index.cjs");Object.defineProperty(r,"ButtonIcon",{enumerable:!0,get:function(){return O.ButtonIcon}}),Object.defineProperty(r,"ButtonIconSize",{enumerable:!0,get:function(){return O.ButtonIconSize}});var E=e("./Checkbox/index.cjs");Object.defineProperty(r,"Checkbox",{enumerable:!0,get:function(){return E.Checkbox}});var C=e("./Icon/index.cjs");Object.defineProperty(r,"Icon",{enumerable:!0,get:function(){return C.Icon}});var k=e("./Icon/index.cjs");Object.defineProperty(r,"IconName",{enumerable:!0,get:function(){return k.IconName}}),Object.defineProperty(r,"IconSize",{enumerable:!0,get:function(){return k.IconSize}}),Object.defineProperty(r,"IconColor",{enumerable:!0,get:function(){return k.IconColor}});var x=e("./temp-components/Jazzicon/index.cjs");Object.defineProperty(r,"Jazzicon",{enumerable:!0,get:function(){return x.Jazzicon}});var T=e("./temp-components/Maskicon/index.cjs");Object.defineProperty(r,"Maskicon",{enumerable:!0,get:function(){return T.Maskicon}});var A=e("./Text/index.cjs");Object.defineProperty(r,"Text",{enumerable:!0,get:function(){return A.Text}});var P=e("./Text/index.cjs");Object.defineProperty(r,"TextVariant",{enumerable:!0,get:function(){return P.TextVariant}}),Object.defineProperty(r,"TextColor",{enumerable:!0,get:function(){return P.TextColor}}),Object.defineProperty(r,"TextAlign",{enumerable:!0,get:function(){return P.TextAlign}}),Object.defineProperty(r,"FontWeight",{enumerable:!0,get:function(){return P.FontWeight}}),Object.defineProperty(r,"FontFamily",{enumerable:!0,get:function(){return P.FontFamily}}),Object.defineProperty(r,"FontStyle",{enumerable:!0,get:function(){return P.FontStyle}}),Object.defineProperty(r,"TextTransform",{enumerable:!0,get:function(){return P.TextTransform}}),Object.defineProperty(r,"OverflowWrap",{enumerable:!0,get:function(){return P.OverflowWrap}});var B=e("./TextButton/index.cjs");Object.defineProperty(r,"TextButton",{enumerable:!0,get:function(){return B.TextButton}}),Object.defineProperty(r,"TextButtonSize",{enumerable:!0,get:function(){return B.TextButtonSize}});var S=e("./ButtonHero/index.cjs");Object.defineProperty(r,"ButtonHero",{enumerable:!0,get:function(){return S.ButtonHero}}),Object.defineProperty(r,"ButtonHeroSize",{enumerable:!0,get:function(){return S.ButtonHeroSize}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/index.cjs"}],[1994,{"@metamask/design-system-shared":2007,blo:4462,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.Blockies=void 0;const a=e("@metamask/design-system-shared"),i=e("blo"),s=n(e("react"));r.Blockies=({address:e,size:t=32,...r})=>{const n=(0,a.extractAccountAddress)(e);return s.default.createElement("img",{src:(0,i.blo)(n),height:t,width:t,alt:`Blockies for ${e}`,...r})},r.Blockies.displayName="Blockies"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/Blockies.cjs"}],[1995,{"./Blockies.cjs":1994},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Blockies=void 0;var n=e("./Blockies.cjs");Object.defineProperty(r,"Blockies",{enumerable:!0,get:function(){return n.Blockies}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/index.cjs"}],[1996,{"../../../utils/tw-merge.cjs":2004,"@metamask/design-system-shared":2007,"@metamask/jazzicon":2408,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t},s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.Jazzicon=void 0;const o=e("@metamask/design-system-shared"),c=s(e("@metamask/jazzicon")),l=i(e("react")),u=e("../../../utils/tw-merge.cjs"),d={};r.Jazzicon=({address:e,size:t=32,className:r,...n})=>{const a=(0,l.useRef)(null);return(0,l.useEffect)(()=>{if(!a.current)return()=>{};for(;a.current.firstChild;)a.current.removeChild(a.current.firstChild);const r=`${e.toLowerCase()}:${t}`;if(d[r]){const e=d[r].cloneNode(!0);return a.current.appendChild(e),()=>{if(a.current)for(;a.current.firstChild;)a.current.removeChild(a.current.firstChild)}}const n=(0,o.extractAccountAddress)(e),i=(0,o.generateIconSeed)(n),s=(0,c.default)(t,i);return d[r]=s,a.current&&a.current.appendChild(s.cloneNode(!0)),()=>{if(a.current)for(;a.current.firstChild;)a.current.removeChild(a.current.firstChild)}},[e,t]),l.default.createElement("div",{ref:a,className:(0,u.twMerge)("flex [&>div]:!rounded-none",r),...n})},r.Jazzicon.displayName="Jazzicon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/Jazzicon.cjs"}],[1997,{"./Jazzicon.cjs":1996},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Jazzicon=void 0;var n=e("./Jazzicon.cjs");Object.defineProperty(r,"Jazzicon",{enumerable:!0,get:function(){return n.Jazzicon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/index.cjs"}],[1998,{"./Maskicon.utilities.cjs":1999,react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.Maskicon=void 0;const s=i(e("react")),o=e("./Maskicon.utilities.cjs");r.Maskicon=({address:e,size:t=32,className:r,...n})=>{const[a,i]=(0,s.useState)("");(0,s.useEffect)(()=>{let r=!1;return(async()=>{const n=await(0,o.getMaskiconSVG)(e,t);r||i(n)})(),()=>{r=!0}},[e,t]);const c=(0,s.useMemo)(()=>{if(!a)return"";const e=a.replace(/\s+/gu," ").trim();return`data:image/svg+xml,${encodeURIComponent(e)}`},[a]);return c?s.default.createElement("img",{alt:"maskicon",width:t,height:t,className:r,src:c,...n}):s.default.createElement("img",{alt:"maskicon",width:t,height:t,className:r,src:"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg'/%3E",...n})},r.Maskicon.displayName="Maskicon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.cjs"}],[1999,{"@metamask/design-system-shared":2007},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getMaskiconSVG=r.createMaskiconSVG=r.seedToString=r.sdbmHash=void 0;const n=e("@metamask/design-system-shared"),a=[["#FF5C16","#FCFCFC"],["#FF5C16","#131416"],["#D075FF","#FCFCFC"],["#D075FF","#131416"],["#BAF24A","#FCFCFC"],["#BAF24A","#131416"],["#89B0FF","#FCFCFC"],["#89B0FF","#131416"],["#FCFCFC","#FF5C16"],["#131416","#FF5C16"],["#FCFCFC","#D075FF"],["#131416","#D075FF"],["#FCFCFC","#BAF24A"],["#131416","#BAF24A"],["#FCFCFC","#89B0FF"],["#131416","#89B0FF"]].concat([["#FFA680","#FF5C16"],["#661800","#FF5C16"],["#EAC2FF","#D075FF"],["#3D065F","#D075FF"],["#E5FFC3","#BAF24A"],["#013330","#BAF24A"],["#CCE7FF","#89B0FF"],["#190066","#89B0FF"],["#FF5C16","#FFA680"],["#FF5C16","#661800"],["#D075FF","#EAC2FF"],["#D075FF","#3D065F"],["#BAF24A","#E5FFC3"],["#BAF24A","#013330"],["#89B0FF","#CCE7FF"],["#89B0FF","#190066"],["#661800","#FFA680"],["#FFA680","#661800"],["#3D065F","#EAC2FF"],["#EAC2FF","#3D065F"],["#013330","#E5FFC3"],["#E5FFC3","#013330"],["#190066","#CCE7FF"],["#CCE7FF","#190066"]]).concat([["#EAC2FF","#013330"],["#013330","#EAC2FF"],["#CCE7FF","#661800"],["#661800","#CCE7FF"],["#E5FFC3","#3D065F"],["#3D065F","#E5FFC3"],["#FFA680","#190066"],["#190066","#FFA680"],["#CCE7FF","#013330"],["#013330","#CCE7FF"]]);function i(e){let t=0;for(let r=0;r<e.length;r++)t=e.charCodeAt(r)+(t<<6)+(t<<16)-t;return t}function s(e){if("number"==typeof e){let t=e.toString(16);return t.length<6&&(t=t.padEnd(6,"0")),t}if(Array.isArray(e)){let t=e.map(e=>e.toString(16).padStart(2,"0")).join("");return t.length<6&&(t=t.padEnd(6,"0")),t}return"seed000"}function o(e,t=100){const r=i(s(e)),n=Math.abs(r)%a.length,[o,c]=a[n],l=.25*t,u=(t-2*l)/2;let d="";const f=Array.from({length:2},()=>Array(2).fill(!1)),m=Math.floor(1),h=Math.floor(1),p=[[m,h]];for(f[m][h]=!0;p.length>0;){const[e,t]=p.pop(),n=15&Math.abs(r>>3*e+5*t),a=[],i=[[0,1],[1,0],[0,-1],[-1,0]];for(const[r,n]of i){const i=e+r,s=t+n;i>=0&&i<2&&s>=0&&s<2&&!f[i][s]&&a.push([i,s])}for(;a.length>0;){const e=Math.abs(n+a.length)%a.length,[t,r]=a.splice(e,1)[0];p.push([t,r]),f[t][r]=!0}const s=n%4*90,o=l+e*u,c=l+t*u;d+=n%5==0?`M${o},${c} h${u} v${u} h-${u}z `:0===s?`M${o},${c} h${u} v${u}z `:90===s?`M${o+u},${c} v${u} h-${u}z `:180===s?`M${o+u},${c+u} h-${u} v-${u}z `:`M${o},${c+u} v-${u} h${u}z `}let g=`<svg width="${t}" height="${t}" viewBox="0 0 ${t} ${t}" xmlns="http://www.w3.org/2000/svg">`;return g+=`<rect width="${t}" height="${t}" fill="${o}" />`,g+=`<path d="${d}" fill="${c}" />`,g+="</svg>",g}r.sdbmHash=i,r.seedToString=s,r.createMaskiconSVG=o;const c={};r.getMaskiconSVG=async function(e,t){const r=`${e.toLowerCase()}:${t}`;if(c[r])return c[r];const a=(0,n.extractAccountAddress)(e),i=o((0,n.generateIconSeed)(a),t);return c[r]=i,i}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.utilities.cjs"}],[2,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports=[{code:"am",name:"አማርኛ"},{code:"ar",name:"العربية"},{code:"bg",name:"български"},{code:"bn",name:"বাংলা"},{code:"ca",name:"Català"},{code:"cs",name:"Čeština"},{code:"da",name:"Dansk"},{code:"de",name:"Deutsch"},{code:"el",name:"ελληνικά"},{code:"en",name:"English"},{code:"es",name:"Español"},{code:"es_419",name:"Español (Latin America)"},{code:"et",name:"Estonian"},{code:"fa",name:"فارسی"},{code:"fi",name:"Suomi"},{code:"fil",name:"Filipino"},{code:"fr",name:"Français"},{code:"ga",name:"Gaeilge"},{code:"gu",name:"ગુજરાત"},{code:"he",name:"עברית"},{code:"hi",name:"मानक हिन्दी"},{code:"hn",name:"हिन्दी"},{code:"hr",name:"Hrvatski"},{code:"ht",name:"Kreyòl ayisyen"},{code:"hu",name:"Magyar"},{code:"id",name:"Bahasa Indonesia"},{code:"it",name:"Italiano"},{code:"ja",name:"日本語"},{code:"kn",name:"ಕನ್ನಡ"},{code:"ko",name:"한국어"},{code:"lt",name:"Lietuviškai"},{code:"lv",name:"Latvian"},{code:"ml",name:"മലയാളം"},{code:"mr",name:"मराठी"},{code:"ms",name:"Malay"},{code:"nl",name:"Nederlands"},{code:"no",name:"Norwegian"},{code:"pl",name:"Polskie"},{code:"pt",name:"Português"},{code:"pt_BR",name:"Português (Brazillian)"},{code:"pt_PT",name:"Português (European)"},{code:"ro",name:"Limba română"},{code:"ru",name:"Русский"},{code:"sk",name:"Slovenčina"},{code:"sl",name:"Slovenščina"},{code:"sr",name:"српски"},{code:"sv",name:"Svenska"},{code:"sw",name:"Swahili"},{code:"ta",name:"தமிழ்"},{code:"te",name:"తెలుగు"},{code:"th",name:"ไทย"},{code:"tl",name:"Filipino"},{code:"tr",name:"Türkçe"},{code:"uk",name:"Українська мова"},{code:"vi",name:"Tiếng Việt"},{code:"zh_CN",name:"中文(简体)"},{code:"zh_TW",name:"中文(繁體)"}]}}},{package:"$root$",file:"app/_locales/index.json"}],[2e3,{"./Maskicon.cjs":1998},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Maskicon=void 0;var n=e("./Maskicon.cjs");Object.defineProperty(r,"Maskicon",{enumerable:!0,get:function(){return n.Maskicon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/index.cjs"}],[2001,{"./components/index.cjs":1993,"./utils/index.cjs":2003},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),a(e("./components/index.cjs"),r),a(e("./utils/index.cjs"),r)}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/index.cjs"}],[2002,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a,i,s,o,c,l,u,d,f,m,h,p,g,b,y,v,w,_,j,O,E,C,k,x,T,A,P,B,S,M;Object.defineProperty(r,"__esModule",{value:!0}),r.IconName=r.IconColor=r.IconSize=r.TextButtonSize=r.FontFamily=r.TextTransform=r.FontStyle=r.OverflowWrap=r.FontWeight=r.TextAlign=r.TextColor=r.TextVariant=r.ButtonIconSize=r.ButtonVariant=r.ButtonSize=r.ButtonHeroSize=r.ButtonTertiarySize=r.ButtonSecondarySize=r.ButtonPrimarySize=r.ButtonBaseSize=r.BoxBorderColor=r.BoxBackgroundColor=r.BoxJustifyContent=r.BoxAlignItems=r.BoxFlexWrap=r.BoxFlexDirection=r.BadgeWrapperPosition=r.BadgeWrapperPositionAnchorShape=r.BadgeStatusSize=r.BadgeStatusStatus=r.BadgeCountSize=r.AvatarGroupVariant=r.AvatarIconSeverity=r.AvatarAccountVariant=r.AvatarBaseShape=r.AvatarShape=r.AvatarSize=r.AvatarTokenSize=r.AvatarNetworkSize=r.AvatarIconSize=r.AvatarGroupSize=r.AvatarFaviconSize=r.AvatarAccountSize=r.AvatarBaseSize=void 0,function(e){e.Xs="xs",e.Sm="sm",e.Md="md",e.Lg="lg",e.Xl="xl"}(n||(r.AvatarSize=r.AvatarTokenSize=r.AvatarNetworkSize=r.AvatarIconSize=r.AvatarGroupSize=r.AvatarFaviconSize=r.AvatarAccountSize=r.AvatarBaseSize=n={})),function(e){e.Circle="circle",e.Square="square"}(a||(r.AvatarBaseShape=r.AvatarShape=a={})),function(e){e.Blockies="blockies",e.Jazzicon="jazzicon",e.Maskicon="maskicon"}(i||(r.AvatarAccountVariant=i={})),function(e){e.Neutral="neutral",e.Info="info",e.Success="success",e.Error="error",e.Warning="warning"}(s||(r.AvatarIconSeverity=s={})),function(e){e.Account="Account",e.Favicon="Favicon",e.Network="Network",e.Token="Token"}(o||(r.AvatarGroupVariant=o={})),function(e){e.Md="md",e.Lg="lg"}(c||(r.BadgeCountSize=c={})),function(e){e.Active="active",e.Inactive="inactive",e.Disconnected="disconnected",e.New="new",e.Attention="attention"}(l||(r.BadgeStatusStatus=l={})),function(e){e.Md="md",e.Lg="lg"}(u||(r.BadgeStatusSize=u={})),function(e){e.Rectangular="Rectangular",e.Circular="Circular"}(d||(r.BadgeWrapperPositionAnchorShape=d={})),function(e){e.TopRight="TopRight",e.BottomRight="BottomRight",e.BottomLeft="BottomLeft",e.TopLeft="TopLeft"}(f||(r.BadgeWrapperPosition=f={})),function(e){e.Row="flex-row",e.RowReverse="flex-row-reverse",e.Column="flex-col",e.ColumnReverse="flex-col-reverse"}(m||(r.BoxFlexDirection=m={})),function(e){e.NoWrap="flex-nowrap",e.Wrap="flex-wrap",e.WrapReverse="flex-wrap-reverse"}(h||(r.BoxFlexWrap=h={})),function(e){e.Start="items-start",e.Center="items-center",e.End="items-end",e.Stretch="items-stretch",e.Baseline="items-baseline"}(p||(r.BoxAlignItems=p={})),function(e){e.Start="justify-start",e.Center="justify-center",e.End="justify-end",e.Between="justify-between",e.Around="justify-around",e.Evenly="justify-evenly"}(g||(r.BoxJustifyContent=g={})),function(e){e.BackgroundDefault="bg-default",e.BackgroundAlternative="bg-alternative",e.BackgroundSection="bg-section",e.BackgroundSubsection="bg-subsection",e.BackgroundMuted="bg-muted",e.PrimaryDefault="bg-primary-default",e.PrimaryAlternative="bg-primary-alternative",e.PrimaryMuted="bg-primary-muted",e.PrimaryInverse="bg-primary-inverse",e.ErrorDefault="bg-error-default",e.ErrorAlternative="bg-error-alternative",e.ErrorMuted="bg-error-muted",e.ErrorInverse="bg-error-inverse",e.WarningDefault="bg-warning-default",e.WarningAlternative="bg-warning-alternative",e.WarningMuted="bg-warning-muted",e.WarningInverse="bg-warning-inverse",e.SuccessDefault="bg-success-default",e.SuccessAlternative="bg-success-alternative",e.SuccessMuted="bg-success-muted",e.SuccessInverse="bg-success-inverse",e.InfoDefault="bg-info-default",e.InfoMuted="bg-info-muted",e.InfoInverse="bg-info-inverse",e.FlaskDefault="bg-flask-default",e.FlaskInverse="bg-flask-inverse",e.OverlayAlternative="bg-overlay-alternative",e.OverlayDefault="bg-overlay-default",e.OverlayInverse="bg-overlay-inverse",e.Transparent="bg-transparent"}(b||(r.BoxBackgroundColor=b={})),function(e){e.BackgroundDefault="border-background-default",e.BorderDefault="border-default",e.BorderMuted="border-muted",e.PrimaryDefault="border-primary-default",e.PrimaryAlternative="border-primary-alternative",e.PrimaryMuted="border-primary-muted",e.PrimaryInverse="border-primary-inverse",e.ErrorDefault="border-error-default",e.ErrorAlternative="border-error-alternative",e.ErrorMuted="border-error-muted",e.ErrorInverse="border-error-inverse",e.WarningDefault="border-warning-default",e.WarningAlternative="border-warning-alternative",e.WarningMuted="border-warning-muted",e.WarningInverse="border-warning-inverse",e.SuccessDefault="border-success-default",e.SuccessAlternative="border-success-alternative",e.SuccessMuted="border-success-muted",e.SuccessInverse="border-success-inverse",e.InfoDefault="border-info-default",e.InfoAlternative="border-info-alternative",e.InfoMuted="border-info-muted",e.InfoInverse="border-info-inverse",e.FlaskDefault="border-flask-default",e.FlaskInverse="border-flask-inverse",e.OverlayAlternative="border-overlay-alternative",e.OverlayDefault="border-overlay-default",e.OverlayInverse="border-overlay-inverse",e.Transparent="border-transparent"}(y||(r.BoxBorderColor=y={})),function(e){e.Sm="sm",e.Md="md",e.Lg="lg"}(v||(r.ButtonSize=r.ButtonHeroSize=r.ButtonTertiarySize=r.ButtonSecondarySize=r.ButtonPrimarySize=r.ButtonBaseSize=v={})),function(e){e.Primary="primary",e.Secondary="secondary",e.Tertiary="tertiary"}(w||(r.ButtonVariant=w={})),function(e){e.Sm="sm",e.Md="md",e.Lg="lg"}(_||(r.ButtonIconSize=_={})),function(e){e.DisplayLg="display-lg",e.DisplayMd="display-md",e.HeadingLg="heading-lg",e.HeadingMd="heading-md",e.HeadingSm="heading-sm",e.BodyLg="body-lg",e.BodyMd="body-md",e.BodySm="body-sm",e.BodyXs="body-xs",e.PageHeading="page-heading",e.SectionHeading="section-heading",e.ButtonLabelMd="button-label-md",e.ButtonLabelLg="button-label-lg",e.AmountDisplayLg="amount-display-lg"}(j||(r.TextVariant=j={})),function(e){e.TextDefault="text-default",e.TextAlternative="text-alternative",e.TextMuted="text-muted",e.OverlayInverse="text-overlay-inverse",e.PrimaryDefault="text-primary-default",e.PrimaryDefaultHover="text-primary-default-hover",e.PrimaryDefaultPressed="text-primary-default-pressed",e.PrimaryInverse="text-primary-inverse",e.ErrorDefault="text-error-default",e.ErrorDefaultHover="text-error-default-hover",e.ErrorDefaultPressed="text-error-default-pressed",e.ErrorAlternative="text-error-alternative",e.ErrorInverse="text-error-inverse",e.SuccessDefault="text-success-default",e.SuccessDefaultHover="text-success-default-hover",e.SuccessDefaultPressed="text-success-default-pressed",e.SuccessInverse="text-success-inverse",e.WarningDefault="text-warning-default",e.WarningDefaultHover="text-warning-default-hover",e.WarningDefaultPressed="text-warning-default-pressed",e.WarningInverse="text-warning-inverse",e.InfoDefault="text-info-default",e.InfoInverse="text-info-inverse",e.Inherit="text-inherit",e.Transparent="text-transparent"}(O||(r.TextColor=O={})),function(e){e.Left="text-left",e.Center="text-center",e.Right="text-right",e.Justify="text-justify"}(E||(r.TextAlign=E={})),function(e){e.Bold="font-bold",e.Medium="font-medium",e.Regular="font-regular"}(C||(r.FontWeight=C={})),function(e){e.BreakWord="break-words",e.Anywhere="break-all",e.Normal="break-normal"}(k||(r.OverflowWrap=k={})),function(e){e.Italic="italic",e.Normal="not-italic"}(x||(r.FontStyle=x={})),function(e){e.Uppercase="uppercase",e.Lowercase="lowercase",e.Capitalize="capitalize",e.Normal="normal-case"}(T||(r.TextTransform=T={})),function(e){e.Default="font-default",e.Accent="font-accent",e.Hero="font-hero"}(A||(r.FontFamily=A={})),function(e){e.BodyLg="body-lg",e.BodyMd="body-md",e.BodySm="body-sm",e.BodyXs="body-xs"}(P||(r.TextButtonSize=P={})),function(e){e.Xs="xs",e.Sm="sm",e.Md="md",e.Lg="lg",e.Xl="xl"}(B||(r.IconSize=B={})),function(e){e.IconDefault="text-icon-default",e.IconAlternative="text-icon-alternative",e.IconMuted="text-icon-muted",e.OverlayInverse="text-overlay-inverse",e.PrimaryDefault="text-primary-default",e.PrimaryInverse="text-primary-inverse",e.ErrorDefault="text-error-default",e.ErrorInverse="text-error-inverse",e.SuccessDefault="text-success-default",e.SuccessInverse="text-success-inverse",e.WarningDefault="text-warning-default",e.WarningInverse="text-warning-inverse",e.InfoDefault="text-info-default",e.InfoInverse="text-info-inverse"}(S||(r.IconColor=S={})),function(e){e.Accessibility="Accessibility",e.Activity="Activity",e.Add="Add",e.AddCard="AddCard",e.AddCircle="AddCircle",e.AddSquare="AddSquare",e.Ai="Ai",e.AlternateEmail="AlternateEmail",e.AppleLogo="AppleLogo",e.Apps="Apps",e.Arrow2Down="Arrow2Down",e.Arrow2Left="Arrow2Left",e.Arrow2Right="Arrow2Right",e.Arrow2Up="Arrow2Up",e.Arrow2UpRight="Arrow2UpRight",e.ArrowCircleDown="ArrowCircleDown",e.ArrowCircleUp="ArrowCircleUp",e.ArrowDoubleLeft="ArrowDoubleLeft",e.ArrowDoubleRight="ArrowDoubleRight",e.ArrowDown="ArrowDown",e.ArrowDropDownCircle="ArrowDropDownCircle",e.ArrowLeft="ArrowLeft",e.ArrowRight="ArrowRight",e.ArrowUp="ArrowUp",e.AttachMoney="AttachMoney",e.Attachment="Attachment",e.Backspace="Backspace",e.Ban="Ban",e.Bank="Bank",e.BankAssured="BankAssured",e.Bold="Bold",e.Book="Book",e.Bookmark="Bookmark",e.Bridge="Bridge",e.Briefcase="Briefcase",e.Bulb="Bulb",e.BuySell="BuySell",e.Cake="Cake",e.Calculator="Calculator",e.Calendar="Calendar",e.Call="Call",e.Camera="Camera",e.Campaign="Campaign",e.Candlestick="Candlestick",e.Card="Card",e.CardPos="CardPos",e.Cash="Cash",e.Category="Category",e.Chart="Chart",e.Check="Check",e.CheckBold="CheckBold",e.CircleX="CircleX",e.Clear="Clear",e.Clock="Clock",e.ClockFilled="ClockFilled",e.Close="Close",e.Cloud="Cloud",e.CloudDownload="CloudDownload",e.CloudUpload="CloudUpload",e.Code="Code",e.CodeCircle="CodeCircle",e.Coin="Coin",e.Collapse="Collapse",e.Confirmation="Confirmation",e.Connect="Connect",e.Copy="Copy",e.CopySuccess="CopySuccess",e.CreditCheck="CreditCheck",e.CurrencyFranc="CurrencyFranc",e.CurrencyLira="CurrencyLira",e.CurrencyPound="CurrencyPound",e.CurrencyYuan="CurrencyYuan",e.Customize="Customize",e.Danger="Danger",e.Dark="Dark",e.DarkFilled="DarkFilled",e.Data="Data",e.Description="Description",e.Details="Details",e.Diagram="Diagram",e.DocumentCode="DocumentCode",e.Download="Download",e.Draft="Draft",e.EcoLeaf="EcoLeaf",e.Edit="Edit",e.EditSquare="EditSquare",e.EncryptedAdd="EncryptedAdd",e.Eraser="Eraser",e.Error="Error",e.Ethereum="Ethereum",e.Exchange="Exchange",e.Expand="Expand",e.ExpandVertical="ExpandVertical",e.Explore="Explore",e.ExploreFilled="ExploreFilled",e.Export="Export",e.Extension="Extension",e.Eye="Eye",e.EyeSlash="EyeSlash",e.FaceId="FaceId",e.Feedback="Feedback",e.File="File",e.Filter="Filter",e.Fingerprint="Fingerprint",e.Fire="Fire",e.FirstPage="FirstPage",e.Flag="Flag",e.Flash="Flash",e.FlashSlash="FlashSlash",e.Flask="Flask",e.Flower="Flower",e.Folder="Folder",e.Forest="Forest",e.FullCircle="FullCircle",e.Gas="Gas",e.Gift="Gift",e.Global="Global",e.GlobalSearch="GlobalSearch",e.Graph="Graph",e.Hardware="Hardware",e.HashTag="HashTag",e.Heart="Heart",e.HeartFilled="HeartFilled",e.Hierarchy="Hierarchy",e.Home="Home",e.HomeFilled="HomeFilled",e.Image="Image",e.Info="Info",e.Inventory="Inventory",e.Joystick="Joystick",e.Keep="Keep",e.KeepFilled="KeepFilled",e.Key="Key",e.LastPage="LastPage",e.Light="Light",e.LightFilled="LightFilled",e.Link="Link",e.Loading="Loading",e.Location="Location",e.Lock="Lock",e.LockSlash="LockSlash",e.LockedFilled="LockedFilled",e.Login="Login",e.Logout="Logout",e.Mail="Mail",e.Map="Map",e.Menu="Menu",e.MessageQuestion="MessageQuestion",e.Messages="Messages",e.MetamaskFoxOutline="MetamaskFoxOutline",e.Mic="Mic",e.Minus="Minus",e.MinusBold="MinusBold",e.MinusSquare="MinusSquare",e.Mobile="Mobile",e.Money="Money",e.MoneyBag="MoneyBag",e.Monitor="Monitor",e.MoreHorizontal="MoreHorizontal",e.MoreVertical="MoreVertical",e.MountainFlag="MountainFlag",e.MusicNote="MusicNote",e.Notification="Notification",e.PageInfo="PageInfo",e.Palette="Palette",e.PasswordCheck="PasswordCheck",e.Pending="Pending",e.People="People",e.PersonCancel="PersonCancel",e.Pin="Pin",e.Plant="Plant",e.Plug="Plug",e.PlusAndMinus="PlusAndMinus",e.PolicyAlert="PolicyAlert",e.Print="Print",e.PriorityHigh="PriorityHigh",e.PrivacyTip="PrivacyTip",e.ProgrammingArrows="ProgrammingArrows",e.Publish="Publish",e.QrCode="QrCode",e.Question="Question",e.Receive="Receive",e.Received="Received",e.Refresh="Refresh",e.RemoveMinus="RemoveMinus",e.Report="Report",e.Rocket="Rocket",e.Save="Save",e.SaveFilled="SaveFilled",e.Saving="Saving",e.Scan="Scan",e.ScanBarcode="ScanBarcode",e.ScanFocus="ScanFocus",e.Search="Search",e.Security="Security",e.SecurityAlert="SecurityAlert",e.SecurityCross="SecurityCross",e.SecurityKey="SecurityKey",e.SecuritySearch="SecuritySearch",e.SecuritySlash="SecuritySlash",e.SecurityTick="SecurityTick",e.SecurityTime="SecurityTime",e.SecurityUser="SecurityUser",e.Send="Send",e.SentimentDissatisfied="SentimentDissatisfied",e.SentimentNeutral="SentimentNeutral",e.SentimentSatisfied="SentimentSatisfied",e.SentimentVerySatisfied="SentimentVerySatisfied",e.Setting="Setting",e.SettingFilled="SettingFilled",e.Share="Share",e.ShieldLock="ShieldLock",e.ShoppingBag="ShoppingBag",e.ShoppingCart="ShoppingCart",e.SignalCellular="SignalCellular",e.Slash="Slash",e.Sms="Sms",e.Snaps="Snaps",e.SnapsMobile="SnapsMobile",e.SnapsPlus="SnapsPlus",e.SnapsRound="SnapsRound",e.Sort="Sort",e.SortByAlpha="SortByAlpha",e.Sparkle="Sparkle",e.Speed="Speed",e.Speedometer="Speedometer",e.Square="Square",e.Stake="Stake",e.Star="Star",e.StarFilled="StarFilled",e.Start="Start",e.Storefront="Storefront",e.Student="Student",e.SwapHorizontal="SwapHorizontal",e.SwapVertical="SwapVertical",e.TabClose="TabClose",e.TableRow="TableRow",e.Tablet="Tablet",e.Tag="Tag",e.ThumbDown="ThumbDown",e.ThumbDownFilled="ThumbDownFilled",e.ThumbUp="ThumbUp",e.ThumbUpFilled="ThumbUpFilled",e.Tint="Tint",e.Tooltip="Tooltip",e.Translate="Translate",e.Trash="Trash",e.TrendDown="TrendDown",e.TrendUp="TrendUp",e.Undo="Undo",e.Unfold="Unfold",e.UnlockedFilled="UnlockedFilled",e.Unpin="Unpin",e.Upload="Upload",e.UploadFile="UploadFile",e.Usb="Usb",e.User="User",e.UserCheck="UserCheck",e.UserCircle="UserCircle",e.UserCircleAdd="UserCircleAdd",e.UserCircleRemove="UserCircleRemove",e.Verified="Verified",e.VerifiedFilled="VerifiedFilled",e.Videocam="Videocam",e.ViewColumn="ViewColumn",e.ViewInAr="ViewInAr",e.VolumeOff="VolumeOff",e.VolumeUp="VolumeUp",e.Wallet="Wallet",e.WalletFilled="WalletFilled",e.Warning="Warning",e.WebTraffic="WebTraffic",e.Widgets="Widgets",e.Wifi="Wifi",e.WifiOff="WifiOff",e.X="X"}(M||(r.IconName=M={}))}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/types/index.cjs"}],[2003,{"./tw-merge.cjs":2004},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.twMerge=void 0;var n=e("./tw-merge.cjs");Object.defineProperty(r,"twMerge",{enumerable:!0,get:function(){return n.twMerge}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/utils/index.cjs"}],[2004,{"tailwind-merge":6121},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.twMerge=void 0;const n=e("tailwind-merge");r.twMerge=(0,n.extendTailwindMerge)({extend:{classGroups:{"text-color":["text-default","text-alternative","text-muted"],"font-size":[{text:["s-display-lg","s-display-md","s-heading-lg","s-heading-md","s-heading-sm","s-body-lg","s-body-md","s-body-sm","s-body-xs","l-display-lg","l-display-md","l-heading-lg","l-heading-md","l-heading-sm","l-body-lg","l-body-md","l-body-sm","l-body-xs","s-page-heading","s-section-heading","s-button-label-md","s-button-label-lg","s-amount-display-lg","l-page-heading","l-section-heading","l-button-label-md","l-button-label-lg","l-amount-display-lg"]}],"font-family":["font-default","font-accent","font-hero"],"font-weight":["font-thin","font-extralight","font-light","font-normal","font-regular","font-medium","font-semibold","font-bold","font-extrabold","font-black"]},conflictingClassGroups:{"text-color":["text-color"],"font-size":["font-size"],"font-family":["font-family"],"font-weight":["font-weight"]}}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs"}],[2005,{react:5709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a=Object.create,i=Object.defineProperty,s=Object.getOwnPropertyDescriptor,o=Object.getOwnPropertyNames,c=Object.getPrototypeOf,l=Object.prototype.hasOwnProperty,u=(e,t,r,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let a of o(t))l.call(e,a)||a===r||i(e,a,{get:()=>t[a],enumerable:!(n=s(t,a))||n.enumerable});return e},d={};((e,t)=>{for(var r in t)i(e,r,{get:t[r],enumerable:!0})})(d,{composeRefs:()=>h,useComposedRefs:()=>p}),t.exports=(n=d,u(i({},"__esModule",{value:!0}),n));var f=((e,t,r)=>(r=null!=e?a(c(e)):{},u(!t&&e&&e.__esModule?r:i(r,"default",{value:e,enumerable:!0}),e)))(e("react"));function m(e,t){if("function"==typeof e)return e(t);null!=e&&(e.current=t)}function h(...e){return t=>{let r=!1;const n=e.map(e=>{const n=m(e,t);return r||"function"!=typeof n||(r=!0),n});if(r)return()=>{for(let t=0;t<n.length;t++){const r=n[t];"function"==typeof r?r():m(e[t],null)}}}}function p(...e){return f.useCallback(h(...e),e)}}}},{package:"@metamask/design-system-react>@radix-ui/react-slot>@radix-ui/react-compose-refs",file:"node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-compose-refs/dist/index.js"}],[2006,{"@radix-ui/react-compose-refs":2005,react:5709,"react/jsx-runtime":5710},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a=Object.create,i=Object.defineProperty,s=Object.getOwnPropertyDescriptor,o=Object.getOwnPropertyNames,c=Object.getPrototypeOf,l=Object.prototype.hasOwnProperty,u=(e,t,r,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let a of o(t))l.call(e,a)||a===r||i(e,a,{get:()=>t[a],enumerable:!(n=s(t,a))||n.enumerable});return e},d={};((e,t)=>{for(var r in t)i(e,r,{get:t[r],enumerable:!0})})(d,{Root:()=>g,Slot:()=>g,Slottable:()=>w,createSlot:()=>p,createSlottable:()=>v}),t.exports=(n=d,u(i({},"__esModule",{value:!0}),n));var f=((e,t,r)=>(r=null!=e?a(c(e)):{},u(!t&&e&&e.__esModule?r:i(r,"default",{value:e,enumerable:!0}),e)))(e("react")),m=e("@radix-ui/react-compose-refs"),h=e("react/jsx-runtime");function p(e){const t=b(e),r=f.forwardRef((e,r)=>{const{children:n,...a}=e,i=f.Children.toArray(n),s=i.find(_);if(s){const e=s.props.children,n=i.map(t=>t===s?f.Children.count(e)>1?f.Children.only(null):f.isValidElement(e)?e.props.children:null:t);return(0,h.jsx)(t,{...a,ref:r,children:f.isValidElement(e)?f.cloneElement(e,void 0,n):null})}return(0,h.jsx)(t,{...a,ref:r,children:n})});return r.displayName=`${e}.Slot`,r}var g=p("Slot");function b(e){const t=f.forwardRef((e,t)=>{const{children:r,...n}=e;if(f.isValidElement(r)){const e=function(e){let t=Object.getOwnPropertyDescriptor(e.props,"ref")?.get,r=t&&"isReactWarning"in t&&t.isReactWarning;if(r)return e.ref;if(t=Object.getOwnPropertyDescriptor(e,"ref")?.get,r=t&&"isReactWarning"in t&&t.isReactWarning,r)return e.props.ref;return e.props.ref||e.ref}(r),a=function(e,t){const r={...t};for(const n in t){const a=e[n],i=t[n];/^on[A-Z]/.test(n)?a&&i?r[n]=(...e)=>{const t=i(...e);return a(...e),t}:a&&(r[n]=a):"style"===n?r[n]={...a,...i}:"className"===n&&(r[n]=[a,i].filter(Boolean).join(" "))}return{...e,...r}}(n,r.props);return r.type!==f.Fragment&&(a.ref=t?(0,m.composeRefs)(t,e):e),f.cloneElement(r,a)}return f.Children.count(r)>1?f.Children.only(null):null});return t.displayName=`${e}.SlotClone`,t}var y=Symbol("radix.slottable");function v(e){const t=({children:e})=>(0,h.jsx)(h.Fragment,{children:e});return t.displayName=`${e}.Slottable`,t.__radixId=y,t}var w=v("Slottable");function _(e){return f.isValidElement(e)&&"function"==typeof e.type&&"__radixId"in e.type&&e.type.__radixId===y}}}},{package:"@metamask/design-system-react>@radix-ui/react-slot",file:"node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-slot/dist/index.js"}],[2007,{"./utils/caip-address.cjs":2008},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.generateIconSeed=r.isEthereumAddress=r.generateSeedNonEthereum=r.generateSeedEthereum=r.extractAccountAddress=void 0;var n=e("./utils/caip-address.cjs");Object.defineProperty(r,"extractAccountAddress",{enumerable:!0,get:function(){return n.extractAccountAddress}}),Object.defineProperty(r,"generateSeedEthereum",{enumerable:!0,get:function(){return n.generateSeedEthereum}}),Object.defineProperty(r,"generateSeedNonEthereum",{enumerable:!0,get:function(){return n.generateSeedNonEthereum}}),Object.defineProperty(r,"isEthereumAddress",{enumerable:!0,get:function(){return n.isEthereumAddress}}),Object.defineProperty(r,"generateIconSeed",{enumerable:!0,get:function(){return n.generateIconSeed}})}}},{package:"@metamask/design-system-react>@metamask/design-system-shared",file:"node_modules/@metamask/design-system-shared/dist/index.cjs"}],[2008,{"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.generateIconSeed=r.isEthereumAddress=r.generateSeedNonEthereum=r.generateSeedEthereum=r.extractAccountAddress=void 0;const n=e("@metamask/utils");function a(e){const t=e.slice(2,10);return parseInt(t,16)}function i(e){return Array.from((0,n.stringToBytes)(e.normalize("NFKC").toLowerCase()))}function s(e){return e.startsWith("0x")}r.extractAccountAddress=function(e){try{if((0,n.isCaipAccountId)(e)){return(0,n.parseCaipAccountId)(e).address}}catch{}return e},r.generateSeedEthereum=a,r.generateSeedNonEthereum=i,r.isEthereumAddress=s,r.generateIconSeed=function(e){return s(e)?a(e):i(e)}}}},{package:"@metamask/design-system-react>@metamask/design-system-shared",file:"node_modules/@metamask/design-system-shared/dist/utils/caip-address.cjs"}],[2051,{"./logging-utils.cjs":2053,"@metamask/safe-event-emitter":3031,"@metamask/utils":3557,"json-rpc-random-id":5106},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a,i,s,o,c,l,u,d,f,m,h,p,g,b,y,v,w,_,j,O,E,C,k,x,T,A,P,B,S,M,D,I,R,q,F,N,L,H,z=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},V=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},U=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.PollingBlockTracker=void 0;const $=U(e("@metamask/safe-event-emitter")),G=e("@metamask/utils"),K=U(e("json-rpc-random-id")),W=e("./logging-utils.cjs"),X=(0,W.createModuleLogger)(W.projectLogger,"polling-block-tracker"),Y=(0,K.default)(),Q=["sync","latest"];class Z extends $.default{constructor(e={}){if(!e.provider)throw new Error("PollingBlockTracker - no provider specified.");super(),n.add(this),a.set(this,void 0),i.set(this,void 0),s.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),u.set(this,void 0),d.set(this,void 0),f.set(this,void 0),m.set(this,void 0),h.set(this,void 0),p.set(this,[]),g.set(this,void 0),b.set(this,void 0),y.set(this,void 0),v.set(this,void 0),w.set(this,void 0),z(this,i,e.blockResetDuration??2e4,"f"),z(this,s,e.usePastBlocks??!1,"f"),z(this,o,null,"f"),z(this,a,!1,"f"),z(this,y,V(this,n,"m",j).bind(this),"f"),z(this,v,V(this,n,"m",O).bind(this),"f"),z(this,w,V(this,n,"m",S).bind(this),"f"),V(this,n,"m",_).call(this),z(this,u,e.provider,"f"),z(this,d,e.pollingInterval??2e4,"f"),z(this,f,e.retryTimeout??V(this,d,"f")/10,"f"),z(this,m,e.keepEventLoopActive??!0,"f"),z(this,h,e.setSkipCacheFlag??!1,"f")}async destroy(){V(this,n,"m",B).call(this),super.removeAllListeners(),V(this,n,"m",C).call(this)}isRunning(){return V(this,a,"f")}getCurrentBlock(){return V(this,o,"f")}async getLatestBlock({useCache:e=!0}={}){if(V(this,o,"f")&&e)return V(this,o,"f");if(V(this,g,"f"))return await V(this,g,"f").promise;const{promise:t,resolve:r,reject:i}=(0,G.createDeferredPromise)({suppressUnhandledRejection:!0});if(z(this,g,{reject:i,promise:t},"f"),V(this,a,"f"))try{const e=t=>{V(this,n,"m",L).call(this,e),this.removeListener("latest",e),r(t)};return V(this,n,"m",N).call(this,e),this.once("latest",e),await t}catch(e){throw i(e),e}finally{z(this,g,undefined,"f")}else try{const e=await V(this,n,"m",I).call(this);return r(e),e}catch(e){throw i(e),e}finally{setTimeout(()=>{z(this,g,undefined,"f")},V(this,d,"f"))}}removeAllListeners(e){return e?super.removeAllListeners(e):super.removeAllListeners(),V(this,n,"m",_).call(this),V(this,v,"f").call(this),this}async checkForLatestBlock(){return await V(this,n,"m",I).call(this),await this.getLatestBlock()}}function J(e){return Number.parseInt(e,16)}r.PollingBlockTracker=Z,a=new WeakMap,i=new WeakMap,s=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,u=new WeakMap,d=new WeakMap,f=new WeakMap,m=new WeakMap,h=new WeakMap,p=new WeakMap,g=new WeakMap,b=new WeakMap,y=new WeakMap,v=new WeakMap,w=new WeakMap,n=new WeakSet,_=function(){this.removeListener("newListener",V(this,y,"f")),this.removeListener("removeListener",V(this,v,"f")),this.on("newListener",V(this,y,"f")),this.on("removeListener",V(this,v,"f"))},j=function(e){Q.includes(e)&&V(this,n,"m",E).call(this)},O=function(){V(this,n,"m",k).call(this)>0||V(this,n,"m",C).call(this)},E=function(){V(this,a,"f")||(z(this,a,!0,"f"),V(this,n,"m",B).call(this),V(this,n,"m",M).call(this),this.emit("_started"))},C=function(){V(this,a,"f")&&(z(this,a,!1,"f"),V(this,n,"m",P).call(this),V(this,n,"m",D).call(this),V(this,n,"m",H).call(this,new Error("Block tracker destroyed")),this.emit("_ended"))},k=function(){return Q.map(e=>this.listeners(e)).flat().filter(e=>V(this,p,"f").every(t=>!Object.is(t,e))).length},x=function(e){const t=V(this,o,"f");if(!t)return!0;const r=J(e),n=J(t);return V(this,s,"f")&&r<n||r>n},T=function(e){V(this,n,"m",x).call(this,e)&&V(this,n,"m",A).call(this,e)},A=function(e){const t=V(this,o,"f");z(this,o,e,"f"),this.emit("latest",e),this.emit("sync",{oldBlock:t,newBlock:e})},P=function(){V(this,n,"m",B).call(this),z(this,c,setTimeout(V(this,w,"f"),V(this,i,"f")),"f"),V(this,c,"f").unref&&V(this,c,"f").unref()},B=function(){V(this,c,"f")&&clearTimeout(V(this,c,"f"))},S=function(){z(this,o,null,"f")},M=function(){V(this,n,"m",q).call(this)},D=function(){V(this,n,"m",F).call(this)},I=async function(){const e=await V(this,n,"m",R).call(this);return V(this,n,"m",T).call(this,e),V(this,a,"f")||V(this,n,"m",P).call(this),V(this,o,"f")},R=async function(){if(V(this,b,"f"))return await V(this,b,"f").promise;const{promise:e,resolve:t,reject:r}=(0,G.createDeferredPromise)({suppressUnhandledRejection:!0});z(this,b,{reject:r,promise:e},"f");try{const e={jsonrpc:"2.0",id:Y(),method:"eth_blockNumber",params:[]};V(this,h,"f")&&(e.skipCache=!0),X("Making request",e);const r=await V(this,u,"f").request(e);return X("Got result",r),t(r),r}catch(e){throw X("Encountered error fetching block",(0,G.getErrorMessage)(e)),r(e),V(this,n,"m",H).call(this,e),e}finally{z(this,b,undefined,"f")}},q=async function e(){let t=V(this,d,"f");try{await V(this,n,"m",I).call(this)}catch(e){try{this.emit("error",e)}catch{console.error(`Error updating latest block: ${(0,G.getErrorMessage)(e)}`)}t=V(this,f,"f")}if(!V(this,a,"f"))return;V(this,n,"m",F).call(this);const r=setTimeout(()=>{V(this,n,"m",e).call(this)},t);r.unref&&!V(this,m,"f")&&r.unref(),z(this,l,r,"f"),this.emit("_waitingForNextIteration")},F=function(){V(this,l,"f")&&(clearTimeout(V(this,l,"f")),z(this,l,undefined,"f"))},N=function(e){V(this,p,"f").push(e)},L=function(e){V(this,p,"f").splice(V(this,p,"f").indexOf(e),1)},H=function(e){V(this,g,"f")?.reject(e),z(this,g,undefined,"f")}}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.cjs"}],[2052,{"./PollingBlockTracker.cjs":2051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),a(e("./PollingBlockTracker.cjs"),r)}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/index.cjs"}],[2053,{"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("eth-block-tracker")}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/logging-utils.cjs"}],[2054,{"@ethereumjs/util":719,"@metamask/eth-sig-util":2231,"@metamask/key-tree":2469,"@metamask/scure-bip39":3032,"@metamask/scure-bip39/dist/wordlists/english.js":3033,"@metamask/utils":3557,buffer:4526,"ethereum-cryptography/hdkey":2075,"ethereum-cryptography/keccak":2076},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n,a,i,s,o,c,l,u,d,f,m,h=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},p=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.HdKeyring=void 0;const g=e("@ethereumjs/util"),b=e("@metamask/eth-sig-util"),y=e("@metamask/key-tree"),v=e("@metamask/scure-bip39"),w=e("@metamask/scure-bip39/dist/wordlists/english.js"),_=e("@metamask/utils"),j=e("ethereum-cryptography/hdkey"),O=e("ethereum-cryptography/keccak"),E="m/44'/60'/0'/0",C="HD Key Tree";class k{constructor(e={}){n.add(this),this.type=C,this.hdPath=E,a.set(this,new Map),i.set(this,void 0),h(this,i,e.cryptographicFunctions,"f")}async generateRandomMnemonic(){await p(this,n,"m",d).call(this,(0,v.generateMnemonic)(w.wordlist))}async serialize(){let e=[];if(this.mnemonic){const t=p(this,n,"m",s).call(this,this.mnemonic);e=Array.from((new TextEncoder).encode(t))}return{mnemonic:e,numberOfAccounts:p(this,a,"f").size,hdPath:this.hdPath}}async deserialize(e){if(e.numberOfAccounts&&!e.mnemonic)throw new Error("Eth-Hd-Keyring: Deserialize method cannot be called with an opts value for numberOfAccounts and no menmonic");if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");p(this,a,"f").clear(),this.mnemonic=null,this.seed=null,this.root=null,this.hdPath=e.hdPath??E,e.mnemonic&&await p(this,n,"m",d).call(this,e.mnemonic),e.numberOfAccounts&&await this.addAccounts(e.numberOfAccounts)}async addAccounts(e=1){if(!this.root)throw new Error("Eth-Hd-Keyring: No secret recovery phrase provided");const t=p(this,a,"f").size,r=[];for(let i=t;i<e+t;i++){const e=this.root.deriveChild(i);(0,_.assert)(e.publicKey,"Expected public key to be set");const t=p(this,n,"m",f).call(this,e.publicKey),s={hdKey:e,address:t};p(this,a,"f").set(t,s),r.push(t)}return Promise.resolve(r)}async getAccounts(){return Array.from(p(this,a,"f").keys())}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const r=p(this,n,"m",u).call(this,e,{withAppKeyOrigin:t});(0,_.assert)(r.publicKey,"Expected public key to be set");return p(this,n,"m",m).call(this,(0,_.bytesToHex)((0,g.publicToAddress)(r.publicKey)))}async exportAccount(e,t){const r=t?p(this,n,"m",u).call(this,e,t):p(this,n,"m",u).call(this,e),{privateKey:a}=r;return(0,_.assert)(a instanceof Uint8Array,"Expected private key to be of type Uint8Array"),(0,_.remove0x)((0,_.bytesToHex)(a))}async signTransaction(e,r,a={}){const i=p(this,n,"m",l).call(this,e,a);return r.sign(t.from(i))??r}async signMessage(e,r,a={}){(0,_.assertIsHexString)(r);const i=(0,_.remove0x)(r),s=p(this,n,"m",l).call(this,e,a),o=(0,g.ecsign)(t.from(i,"hex"),t.from(s));return(0,b.concatSig)(t.from((0,_.bigIntToBytes)(o.v)),t.from(o.r),t.from(o.s))}async signPersonalMessage(e,r,a={}){const i=p(this,n,"m",l).call(this,e,a),s=t.from(i);return(0,b.personalSign)({privateKey:s,data:r})}async decryptMessage(e,r){const a=p(this,n,"m",u).call(this,e),{privateKey:i}=a;(0,_.assert)(i,"Expected private key to be set");const s=t.from(i).toString("hex");return(0,b.decrypt)({privateKey:s,encryptedData:r})}async signTypedData(e,r,a){let{version:i}=a??{version:b.SignTypedDataVersion.V1};i&&Object.keys(b.SignTypedDataVersion).includes(i)||(i=b.SignTypedDataVersion.V1);const s=p(this,n,"m",l).call(this,e,a);return(0,b.signTypedData)({privateKey:t.from(s),data:r,version:i})}async signEip7702Authorization(e,r,a){const i=p(this,n,"m",l).call(this,e,a);return(0,b.signEIP7702Authorization)({privateKey:t.from(i),authorization:r})}removeAccount(e){const t=p(this,n,"m",m).call(this,e);if(!p(this,a,"f").has(t))throw new Error(`Address ${t} not found in this keyring`);p(this,a,"f").delete(t)}async getEncryptionPublicKey(e,t={}){const r=p(this,n,"m",l).call(this,e,t);return(0,b.getEncryptionPublicKey)((0,_.remove0x)((0,_.bytesToHex)(r)))}}r.HdKeyring=k,a=new WeakMap,i=new WeakMap,n=new WeakSet,s=function(e){return Array.from(new Uint16Array(new Uint8Array(e).buffer)).map(e=>w.wordlist[e]).join(" ")},o=function(e){const t=e.split(" ").map(e=>w.wordlist.indexOf(e));return new Uint8Array(new Uint16Array(t).buffer)},c=function(e){let r=e;var a;if("object"==typeof(a=e)&&null!==a&&"type"in a&&"Buffer"===a.type&&"data"in a&&Array.isArray(a.data)&&(r=e.data),"string"==typeof r||t.isBuffer(r)||Array.isArray(r)){let e;return e=Array.isArray(r)?t.from(r).toString():t.isBuffer(r)?r.toString():r,p(this,n,"m",o).call(this,e)}return r instanceof Object&&!(r instanceof Uint8Array)?Uint8Array.from(Object.values(r)):((0,_.assert)(r instanceof Uint8Array,"Expected Uint8Array mnemonic"),r)},l=function(e,t){if(!e)throw new Error("Must specify address.");const r=p(this,n,"m",u).call(this,e,t);return(0,_.assert)(r.privateKey,"Missing private key"),r.privateKey},u=function(e,{withAppKeyOrigin:r}={}){const i=p(this,n,"m",m).call(this,e),s=p(this,a,"f").get(i);if(!s)throw new Error("HD Keyring - Unable to find matching address.");if(r){const{privateKey:e}=s.hdKey;(0,_.assert)(e,"Expected private key to be set");const n=t.from(r,"utf8"),a=t.concat([e,n]),i=t.from((0,O.keccak256)(a));return{privateKey:i,publicKey:t.from((0,g.privateToPublic)(i))}}return s.hdKey},d=async function(e){if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");this.mnemonic=p(this,n,"m",c).call(this,e),this.seed=await(0,y.mnemonicToSeed)(this.mnemonic,"",p(this,i,"f")),this.hdWallet=j.HDKey.fromMasterSeed(this.seed),this.root=this.hdWallet.derive(this.hdPath)},f=function(e){return(0,_.add0x)((0,_.bytesToHex)((0,g.publicToAddress)(t.from(e),!0)).toLowerCase())},m=function(e){const t=(0,b.normalize)(e);return(0,_.assert)(t,"Expected address to be set"),(0,_.add0x)(t)},k.type=C}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"}],[2055,{"./hd-keyring.cjs":2054},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.HdKeyring=void 0;var n=e("./hd-keyring.cjs");Object.defineProperty(r,"HdKeyring",{enumerable:!0,get:function(){return n.HdKeyring}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/index.cjs"}],[2056,{"./abstract/weierstrass.js":2061,"@noble/hashes/hmac":2067,"@noble/hashes/utils":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getHash=s,r.createCurve=function(e,t){const r=t=>(0,i.weierstrass)({...e,...s(t)});return Object.freeze({...r(t),create:r})};
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const n=e("@noble/hashes/hmac"),a=e("@noble/hashes/utils"),i=e("./abstract/weierstrass.js");function s(e){return{hash:e,hmac:(t,...r)=>(0,n.hmac)(e,t,(0,a.concatBytes)(...r)),randomBytes:a.randomBytes}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/curves",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/curves/_shortw_utils.js"}],[2057,{"./modular.js":2059,"./utils.js":2060},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.wNAF=function(e,t){const r=(e,t)=>{const r=t.negate();return e?r:t},n=e=>({windows:Math.ceil(t/e)+1,windowSize:2**(e-1)});return{constTimeNegate:r,unsafeLadder(t,r){let n=e.ZERO,a=t;for(;r>i;)r&s&&(n=n.add(a)),a=a.double(),r>>=s;return n},precomputeWindow(e,t){const{windows:r,windowSize:a}=n(t),i=[];let s=e,o=s;for(let e=0;e<r;e++){o=s,i.push(o);for(let e=1;e<a;e++)o=o.add(s),i.push(o);s=o.double()}return i},wNAF(t,a,i){const{windows:o,windowSize:c}=n(t);let l=e.ZERO,u=e.BASE;const d=BigInt(2**t-1),f=2**t,m=BigInt(t);for(let e=0;e<o;e++){const t=e*c;let n=Number(i&d);i>>=m,n>c&&(n-=f,i+=s);const o=t,h=t+Math.abs(n)-1,p=e%2!=0,g=n<0;0===n?u=u.add(r(p,a[o])):l=l.add(r(g,a[h]))}return{p:l,f:u}},wNAFCached(e,t,r,n){const a=e._WINDOW_SIZE||1;let i=t.get(e);return i||(i=this.precomputeWindow(e,a),1!==a&&t.set(e,n(i))),this.wNAF(a,i,r)}}},r.validateBasic=function(e){return(0,n.validateField)(e.Fp),(0,a.validateObject)(e,{n:"bigint",h:"bigint",Gx:"field",Gy:"field"},{nBitLength:"isSafeInteger",nByteLength:"isSafeInteger"}),Object.freeze({...(0,n.nLength)(e.n,e.nBitLength),...e,p:e.Fp.ORDER})};
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const n=e("./modular.js"),a=e("./utils.js"),i=BigInt(0),s=BigInt(1)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/curves",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/curves/abstract/curve.js"}],[2058,{"./modular.js":2059,"./utils.js":2060},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.expand_message_xmd=l,r.expand_message_xof=u,r.hash_to_field=d,r.isogenyMap=function(e,t){const r=t.map(e=>Array.from(e).reverse());return(t,n)=>{const[a,i,s,o]=r.map(r=>r.reduce((r,n)=>e.add(e.mul(r,t),n)));return t=e.div(a,i),n=e.mul(n,e.div(s,o)),{x:t,y:n}}},r.createHasher=function(e,t,r){if("function"!=typeof t)throw new Error("mapToCurve() must be defined");return{hashToCurve(n,a){const i=d(n,2,{...r,DST:r.DST,...a}),s=e.fromAffine(t(i[0])),o=e.fromAffine(t(i[1])),c=s.add(o).clearCofactor();return c.assertValidity(),c},encodeToCurve(n,a){const i=d(n,1,{...r,DST:r.encodeDST,...a}),s=e.fromAffine(t(i[0])).clearCofactor();return s.assertValidity(),s},mapToCurve(r){if(!Array.isArray(r))throw new Error("mapToCurve: expected array of bigints");for(const e of r)if("bigint"!=typeof e)throw new Error(`mapToCurve: expected array of bigints, got ${e} in array`);const n=e.fromAffine(t(r)).clearCofactor();return n.assertValidity(),n}}};const n=e("./modular.js"),a=e("./utils.js"),i=a.bytesToNumberBE;function s(e,t){if(e<0||e>=1<<8*t)throw new Error(`bad I2OSP call: value=${e} length=${t}`);const r=Array.from({length:t}).fill(0);for(let n=t-1;n>=0;n--)r[n]=255&e,e>>>=8;return new Uint8Array(r)}function o(e,t){const r=new Uint8Array(e.length);for(let n=0;n<e.length;n++)r[n]=e[n]^t[n];return r}function c(e){if(!Number.isSafeInteger(e))throw new Error("number expected")}function l(e,t,r,n){(0,a.abytes)(e),(0,a.abytes)(t),c(r),t.length>255&&(t=n((0,a.concatBytes)((0,a.utf8ToBytes)("H2C-OVERSIZE-DST-"),t)));const{outputLen:i,blockLen:l}=n,u=Math.ceil(r/i);if(u>255)throw new Error("Invalid xmd length");const d=(0,a.concatBytes)(t,s(t.length,1)),f=s(0,l),m=s(r,2),h=new Array(u),p=n((0,a.concatBytes)(f,e,m,s(0,1),d));h[0]=n((0,a.concatBytes)(p,s(1,1),d));for(let e=1;e<=u;e++){const t=[o(p,h[e-1]),s(e+1,1),d];h[e]=n((0,a.concatBytes)(...t))}return(0,a.concatBytes)(...h).slice(0,r)}function u(e,t,r,n,i){if((0,a.abytes)(e),(0,a.abytes)(t),c(r),t.length>255){const e=Math.ceil(2*n/8);t=i.create({dkLen:e}).update((0,a.utf8ToBytes)("H2C-OVERSIZE-DST-")).update(t).digest()}if(r>65535||t.length>255)throw new Error("expand_message_xof: invalid lenInBytes");return i.create({dkLen:r}).update(e).update(s(r,2)).update(t).update(s(t.length,1)).digest()}function d(e,t,r){(0,a.validateObject)(r,{DST:"stringOrUint8Array",p:"bigint",m:"isSafeInteger",k:"isSafeInteger",hash:"hash"});const{p:s,k:o,m:d,hash:f,expand:m,DST:h}=r;(0,a.abytes)(e),c(t);const p="string"==typeof h?(0,a.utf8ToBytes)(h):h,g=s.toString(2).length,b=Math.ceil((g+o)/8),y=t*d*b;let v;if("xmd"===m)v=l(e,p,y,f);else if("xof"===m)v=u(e,p,y,o,f);else{if("_internal_pass"!==m)throw new Error('expand must be "xmd" or "xof"');v=e}const w=new Array(t);for(let e=0;e<t;e++){const t=new Array(d);for(let r=0;r<d;r++){const a=b*(r+e*d),o=v.subarray(a,a+b);t[r]=(0,n.mod)(i(o),s)}w[e]=t}return w}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/curves",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/curves/abstract/hash-to-curve.js"}],[2059,{"./utils.js":2060},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isNegativeLE=void 0,r.mod=d,r.pow=f,r.pow2=function(e,t,r){let n=e;for(;t-- >a;)n*=n,n%=r;return n},r.invert=m,r.tonelliShanks=h,r.FpSqrt=p,r.validateField=function(e){const t=g.reduce((e,t)=>(e[t]="function",e),{ORDER:"bigint",MASK:"bigint",BYTES:"isSafeInteger",BITS:"isSafeInteger"});return(0,n.validateObject)(e,t)},r.FpPow=b,r.FpInvertBatch=y,r.FpDiv=function(e,t,r){return e.mul(t,"bigint"==typeof r?m(r,e.ORDER):e.inv(r))},r.FpIsSquare=function(e){const t=(e.ORDER-i)/s;return r=>{const n=e.pow(r,t);return e.eql(n,e.ZERO)||e.eql(n,e.ONE)}},r.nLength=v,r.Field=function(e,t,r=!1,s={}){if(e<=a)throw new Error(`Expected Field ORDER > 0, got ${e}`);const{nBitLength:o,nByteLength:c}=v(e,t);if(c>2048)throw new Error("Field lengths over 2048 bytes are not supported");const l=p(e),u=Object.freeze({ORDER:e,BITS:o,BYTES:c,MASK:(0,n.bitMask)(o),ZERO:a,ONE:i,create:t=>d(t,e),isValid:t=>{if("bigint"!=typeof t)throw new Error("Invalid field element: expected bigint, got "+typeof t);return a<=t&&t<e},is0:e=>e===a,isOdd:e=>(e&i)===i,neg:t=>d(-t,e),eql:(e,t)=>e===t,sqr:t=>d(t*t,e),add:(t,r)=>d(t+r,e),sub:(t,r)=>d(t-r,e),mul:(t,r)=>d(t*r,e),pow:(e,t)=>b(u,e,t),div:(t,r)=>d(t*m(r,e),e),sqrN:e=>e*e,addN:(e,t)=>e+t,subN:(e,t)=>e-t,mulN:(e,t)=>e*t,inv:t=>m(t,e),sqrt:s.sqrt||(e=>l(u,e)),invertBatch:e=>y(u,e),cmov:(e,t,r)=>r?t:e,toBytes:e=>r?(0,n.numberToBytesLE)(e,c):(0,n.numberToBytesBE)(e,c),fromBytes:e=>{if(e.length!==c)throw new Error(`Fp.fromBytes: expected ${c}, got ${e.length}`);return r?(0,n.bytesToNumberLE)(e):(0,n.bytesToNumberBE)(e)}});return Object.freeze(u)},r.FpSqrtOdd=function(e,t){if(!e.isOdd)throw new Error("Field doesn't have isOdd");const r=e.sqrt(t);return e.isOdd(r)?r:e.neg(r)},r.FpSqrtEven=function(e,t){if(!e.isOdd)throw new Error("Field doesn't have isOdd");const r=e.sqrt(t);return e.isOdd(r)?e.neg(r):r},r.hashToPrivateScalar=function(e,t,r=!1){const a=(e=(0,n.ensureBytes)("privateHash",e)).length,s=v(t).nByteLength+8;if(s<24||a<s||a>1024)throw new Error(`hashToPrivateScalar: expected ${s}-1024 bytes of input, got ${a}`);return d(r?(0,n.bytesToNumberLE)(e):(0,n.bytesToNumberBE)(e),t-i)+i},r.getFieldBytesLength=w,r.getMinHashLength=_,r.mapHashToField=function(e,t,r=!1){const a=e.length,s=w(t),o=_(t);if(a<16||a<o||a>1024)throw new Error(`expected ${o}-1024 bytes of input, got ${a}`);const c=d(r?(0,n.bytesToNumberBE)(e):(0,n.bytesToNumberLE)(e),t-i)+i;return r?(0,n.numberToBytesLE)(c,s):(0,n.numberToBytesBE)(c,s)};
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const n=e("./utils.js"),a=BigInt(0),i=BigInt(1),s=BigInt(2),o=BigInt(3),c=BigInt(4),l=BigInt(5),u=BigInt(8);BigInt(9),BigInt(16);function d(e,t){const r=e%t;return r>=a?r:t+r}function f(e,t,r){if(r<=a||t<a)throw new Error("Expected power/modulo > 0");if(r===i)return a;let n=i;for(;t>a;)t&i&&(n=n*e%r),e=e*e%r,t>>=i;return n}function m(e,t){if(e===a||t<=a)throw new Error(`invert: expected positive integers, got n=${e} mod=${t}`);let r=d(e,t),n=t,s=a,o=i,c=i,l=a;for(;r!==a;){const e=n/r,t=n%r,a=s-c*e,i=o-l*e;n=r,r=t,s=c,o=l,c=a,l=i}if(n!==i)throw new Error("invert: does not exist");return d(s,t)}function h(e){const t=(e-i)/s;let r,n,o;for(r=e-i,n=0;r%s===a;r/=s,n++);for(o=s;o<e&&f(o,t,e)!==e-i;o++);if(1===n){const t=(e+i)/c;return function(e,r){const n=e.pow(r,t);if(!e.eql(e.sqr(n),r))throw new Error("Cannot find square root");return n}}const l=(r+i)/s;return function(e,a){if(e.pow(a,t)===e.neg(e.ONE))throw new Error("Cannot find square root");let s=n,c=e.pow(e.mul(e.ONE,o),r),u=e.pow(a,l),d=e.pow(a,r);for(;!e.eql(d,e.ONE);){if(e.eql(d,e.ZERO))return e.ZERO;let t=1;for(let r=e.sqr(d);t<s&&!e.eql(r,e.ONE);t++)r=e.sqr(r);const r=e.pow(c,i<<BigInt(s-t-1));c=e.sqr(r),u=e.mul(u,r),d=e.mul(d,c),s=t}return u}}function p(e){if(e%c===o){const t=(e+i)/c;return function(e,r){const n=e.pow(r,t);if(!e.eql(e.sqr(n),r))throw new Error("Cannot find square root");return n}}if(e%u===l){const t=(e-l)/u;return function(e,r){const n=e.mul(r,s),a=e.pow(n,t),i=e.mul(r,a),o=e.mul(e.mul(i,s),a),c=e.mul(i,e.sub(o,e.ONE));if(!e.eql(e.sqr(c),r))throw new Error("Cannot find square root");return c}}return h(e)}r.isNegativeLE=(e,t)=>(d(e,t)&i)===i;const g=["create","isValid","is0","neg","inv","sqrt","sqr","eql","add","sub","mul","pow","div","addN","subN","mulN","sqrN"];function b(e,t,r){if(r<a)throw new Error("Expected power > 0");if(r===a)return e.ONE;if(r===i)return t;let n=e.ONE,s=t;for(;r>a;)r&i&&(n=e.mul(n,s)),s=e.sqr(s),r>>=i;return n}function y(e,t){const r=new Array(t.length),n=t.reduce((t,n,a)=>e.is0(n)?t:(r[a]=t,e.mul(t,n)),e.ONE),a=e.inv(n);return t.reduceRight((t,n,a)=>e.is0(n)?t:(r[a]=e.mul(t,r[a]),e.mul(t,n)),a),r}function v(e,t){const r=t!==undefined?t:e.toString(2).length;return{nBitLength:r,nByteLength:Math.ceil(r/8)}}function w(e){if("bigint"!=typeof e)throw new Error("field order must be bigint");const t=e.toString(2).length;return Math.ceil(t/8)}function _(e){const t=w(e);return t+Math.ceil(t/2)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/curves",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/curves/abstract/modular.js"}],[2060,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.bitMask=void 0,r.isBytes=s,r.abytes=o,r.bytesToHex=l,r.numberToHexUnpadded=u,r.hexToNumber=d,r.hexToBytes=h,r.bytesToNumberBE=function(e){return d(l(e))},r.bytesToNumberLE=function(e){return o(e),d(l(Uint8Array.from(e).reverse()))},r.numberToBytesBE=p,r.numberToBytesLE=function(e,t){return p(e,t).reverse()},r.numberToVarBytesBE=function(e){return h(u(e))},r.ensureBytes=function(e,t,r){let n;if("string"==typeof t)try{n=h(t)}catch(r){throw new Error(`${e} must be valid hex string, got "${t}". Cause: ${r}`)}else{if(!s(t))throw new Error(`${e} must be hex string or Uint8Array`);n=Uint8Array.from(t)}const a=n.length;if("number"==typeof r&&a!==r)throw new Error(`${e} expected ${r} bytes, got ${a}`);return n},r.concatBytes=g,r.equalBytes=function(e,t){if(e.length!==t.length)return!1;let r=0;for(let n=0;n<e.length;n++)r|=e[n]^t[n];return 0===r},r.utf8ToBytes=function(e){if("string"!=typeof e)throw new Error("utf8ToBytes expected string, got "+typeof e);return new Uint8Array((new TextEncoder).encode(e))},r.bitLen=function(e){let t;for(t=0;e>n;e>>=a,t+=1);return t},r.bitGet=function(e,t){return e>>BigInt(t)&a},r.bitSet=function(e,t,r){return e|(r?a:n)<<BigInt(t)},r.createHmacDrbg=function(e,t,r){if("number"!=typeof e||e<2)throw new Error("hashLen must be a number");if("number"!=typeof t||t<2)throw new Error("qByteLen must be a number");if("function"!=typeof r)throw new Error("hmacFn must be a function");let n=b(e),a=b(e),i=0;const s=()=>{n.fill(1),a.fill(0),i=0},o=(...e)=>r(a,n,...e),c=(e=b())=>{a=o(y([0]),e),n=o(),0!==e.length&&(a=o(y([1]),e),n=o())},l=()=>{if(i++>=1e3)throw new Error("drbg: tried 1000 values");let e=0;const r=[];for(;e<t;){n=o();const t=n.slice();r.push(t),e+=n.length}return g(...r)};return(e,t)=>{s(),c(e);let r=undefined;for(;!(r=t(l()));)c();return s(),r}},r.validateObject=function(e,t,r={}){const n=(t,r,n)=>{const a=v[r];if("function"!=typeof a)throw new Error(`Invalid validator "${r}", expected function`);const i=e[t];if(!(n&&i===undefined||a(i,e)))throw new Error(`Invalid param ${String(t)}=${i} (${typeof i}), expected ${r}`)};for(const[e,r]of Object.entries(t))n(e,r,!1);for(const[e,t]of Object.entries(r))n(e,t,!0);return e};
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const n=BigInt(0),a=BigInt(1),i=BigInt(2);function s(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function o(e){if(!s(e))throw new Error("Uint8Array expected")}const c=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function l(e){o(e);let t="";for(let r=0;r<e.length;r++)t+=c[e[r]];return t}function u(e){const t=e.toString(16);return 1&t.length?`0${t}`:t}function d(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);return BigInt(""===e?"0":`0x${e}`)}const f={_0:48,_9:57,_A:65,_F:70,_a:97,_f:102};function m(e){return e>=f._0&&e<=f._9?e-f._0:e>=f._A&&e<=f._F?e-(f._A-10):e>=f._a&&e<=f._f?e-(f._a-10):void 0}function h(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);const t=e.length,r=t/2;if(t%2)throw new Error("padded hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(r);for(let t=0,a=0;t<r;t++,a+=2){const r=m(e.charCodeAt(a)),i=m(e.charCodeAt(a+1));if(r===undefined||i===undefined){const t=e[a]+e[a+1];throw new Error('hex string expected, got non-hex character "'+t+'" at index '+a)}n[t]=16*r+i}return n}function p(e,t){return h(e.toString(16).padStart(2*t,"0"))}function g(...e){let t=0;for(let r=0;r<e.length;r++){const n=e[r];o(n),t+=n.length}const r=new Uint8Array(t);for(let t=0,n=0;t<e.length;t++){const a=e[t];r.set(a,n),n+=a.length}return r}r.bitMask=e=>(i<<BigInt(e-1))-a;const b=e=>new Uint8Array(e),y=e=>Uint8Array.from(e);const v={bigint:e=>"bigint"==typeof e,function:e=>"function"==typeof e,boolean:e=>"boolean"==typeof e,string:e=>"string"==typeof e,stringOrUint8Array:e=>"string"==typeof e||s(e),isSafeInteger:e=>Number.isSafeInteger(e),array:e=>Array.isArray(e),field:(e,t)=>t.Fp.isValid(e),hash:e=>"function"==typeof e&&Number.isSafeInteger(e.outputLen)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/curves",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/curves/abstract/utils.js"}],[2061,{"./curve.js":2057,"./modular.js":2059,"./utils.js":2060},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.DER=void 0,r.weierstrassPoints=h,r.weierstrass=function(e){const t=function(e){const t=(0,n.validateBasic)(e);return i.validateObject(t,{hash:"hash",hmac:"function",randomBytes:"function"},{bits2int:"function",bits2int_modN:"function",lowS:"boolean"}),Object.freeze({lowS:!0,...t})}(e),{Fp:o,n:c}=t,d=o.BYTES+1,f=2*o.BYTES+1;function m(e){return a.mod(e,c)}function p(e){return a.invert(e,c)}const{ProjectivePoint:g,normPrivateKeyToScalar:b,weierstrassEquation:y,isWithinCurveOrder:v}=h({...t,toBytes(e,t,r){const n=t.toAffine(),a=o.toBytes(n.x),s=i.concatBytes;return r?s(Uint8Array.from([t.hasEvenY()?2:3]),a):s(Uint8Array.from([4]),a,o.toBytes(n.y))},fromBytes(e){const t=e.length,r=e[0],n=e.subarray(1);if(t!==d||2!==r&&3!==r){if(t===f&&4===r){return{x:o.fromBytes(n.subarray(0,o.BYTES)),y:o.fromBytes(n.subarray(o.BYTES,2*o.BYTES))}}throw new Error(`Point of length ${t} was invalid. Expected ${d} compressed bytes or ${f} uncompressed bytes`)}{const e=i.bytesToNumberBE(n);if(!(l<(a=e)&&a<o.ORDER))throw new Error("Point is not on curve");const t=y(e);let s;try{s=o.sqrt(t)}catch(e){const t=e instanceof Error?": "+e.message:"";throw new Error("Point is not on curve"+t)}return!(1&~r)!==((s&u)===u)&&(s=o.neg(s)),{x:e,y:s}}var a}}),w=e=>i.bytesToHex(i.numberToBytesBE(e,t.nByteLength));function _(e){return e>c>>u}const j=(e,t,r)=>i.bytesToNumberBE(e.slice(t,r));class O{constructor(e,t,r){this.r=e,this.s=t,this.recovery=r,this.assertValidity()}static fromCompact(e){const r=t.nByteLength;return e=(0,s.ensureBytes)("compactSignature",e,2*r),new O(j(e,0,r),j(e,r,2*r))}static fromDER(e){const{r:t,s:n}=r.DER.toSig((0,s.ensureBytes)("DER",e));return new O(t,n)}assertValidity(){if(!v(this.r))throw new Error("r must be 0 < r < CURVE.n");if(!v(this.s))throw new Error("s must be 0 < s < CURVE.n")}addRecoveryBit(e){return new O(this.r,this.s,e)}recoverPublicKey(e){const{r:r,s:n,recovery:a}=this,i=x((0,s.ensureBytes)("msgHash",e));if(null==a||![0,1,2,3].includes(a))throw new Error("recovery id invalid");const c=2===a||3===a?r+t.n:r;if(c>=o.ORDER)throw new Error("recovery id 2 or 3 invalid");const l=1&a?"03":"02",u=g.fromHex(l+w(c)),d=p(c),f=m(-i*d),h=m(n*d),b=g.BASE.multiplyAndAddUnsafe(u,f,h);if(!b)throw new Error("point at infinify");return b.assertValidity(),b}hasHighS(){return _(this.s)}normalizeS(){return this.hasHighS()?new O(this.r,m(-this.s),this.recovery):this}toDERRawBytes(){return i.hexToBytes(this.toDERHex())}toDERHex(){return r.DER.hexFromSig({r:this.r,s:this.s})}toCompactRawBytes(){return i.hexToBytes(this.toCompactHex())}toCompactHex(){return w(this.r)+w(this.s)}}const E={isValidPrivateKey(e){try{return b(e),!0}catch(e){return!1}},normPrivateKeyToScalar:b,randomPrivateKey:()=>{const e=a.getMinHashLength(t.n);return a.mapHashToField(t.randomBytes(e),t.n)},precompute:(e=8,t=g.BASE)=>(t._setWindowSize(e),t.multiply(BigInt(3)),t)};function C(e){const t=i.isBytes(e),r="string"==typeof e,n=(t||r)&&e.length;return t?n===d||n===f:r?n===2*d||n===2*f:e instanceof g}const k=t.bits2int||function(e){const r=i.bytesToNumberBE(e),n=8*e.length-t.nBitLength;return n>0?r>>BigInt(n):r},x=t.bits2int_modN||function(e){return m(k(e))},T=i.bitMask(t.nBitLength);function A(e){if("bigint"!=typeof e)throw new Error("bigint expected");if(!(l<=e&&e<T))throw new Error(`bigint expected < 2^${t.nBitLength}`);return i.numberToBytesBE(e,t.nByteLength)}function P(e,r,n=B){if(["recovered","canonical"].some(e=>e in n))throw new Error("sign() legacy options not supported");const{hash:a,randomBytes:c}=t;let{lowS:d,prehash:f,extraEntropy:h}=n;null==d&&(d=!0),e=(0,s.ensureBytes)("msgHash",e),f&&(e=(0,s.ensureBytes)("prehashed msgHash",a(e)));const y=x(e),w=b(r),j=[A(w),A(y)];if(null!=h&&!1!==h){const e=!0===h?c(o.BYTES):h;j.push((0,s.ensureBytes)("extraEntropy",e))}const E=i.concatBytes(...j),C=y;return{seed:E,k2sig:function(e){const t=k(e);if(!v(t))return;const r=p(t),n=g.BASE.multiply(t).toAffine(),a=m(n.x);if(a===l)return;const i=m(r*m(C+a*w));if(i===l)return;let s=(n.x===a?0:2)|Number(n.y&u),o=i;return d&&_(i)&&(o=function(e){return _(e)?m(-e):e}(i),s^=1),new O(a,o,s)}}}const B={lowS:t.lowS,prehash:!1},S={lowS:t.lowS,prehash:!1};return g.BASE._setWindowSize(8),{CURVE:t,getPublicKey:function(e,t=!0){return g.fromPrivateKey(e).toRawBytes(t)},getSharedSecret:function(e,t,r=!0){if(C(e))throw new Error("first arg must be private key");if(!C(t))throw new Error("second arg must be public key");return g.fromHex(t).multiply(b(e)).toRawBytes(r)},sign:function(e,r,n=B){const{seed:a,k2sig:s}=P(e,r,n),o=t;return i.createHmacDrbg(o.hash.outputLen,o.nByteLength,o.hmac)(a,s)},verify:function(e,n,a,o=S){const c=e;if(n=(0,s.ensureBytes)("msgHash",n),a=(0,s.ensureBytes)("publicKey",a),"strict"in o)throw new Error("options.strict was renamed to lowS");const{lowS:l,prehash:u}=o;let d,f=undefined;try{if("string"==typeof c||i.isBytes(c))try{f=O.fromDER(c)}catch(e){if(!(e instanceof r.DER.Err))throw e;f=O.fromCompact(c)}else{if("object"!=typeof c||"bigint"!=typeof c.r||"bigint"!=typeof c.s)throw new Error("PARSE");{const{r:e,s:t}=c;f=new O(e,t)}}d=g.fromHex(a)}catch(e){if("PARSE"===e.message)throw new Error("signature must be Signature instance, Uint8Array or hex string");return!1}if(l&&f.hasHighS())return!1;u&&(n=t.hash(n));const{r:h,s:b}=f,y=x(n),v=p(b),w=m(y*v),_=m(h*v),j=g.BASE.multiplyAndAddUnsafe(d,w,_)?.toAffine();if(!j)return!1;return m(j.x)===h},ProjectivePoint:g,Signature:O,utils:E}},r.SWUFpSqrtRatio=p,r.mapToCurveSimpleSWU=function(e,t){if(a.validateField(e),!e.isValid(t.A)||!e.isValid(t.B)||!e.isValid(t.Z))throw new Error("mapToCurveSimpleSWU: invalid opts");const r=p(e,t.Z);if(!e.isOdd)throw new Error("Fp.isOdd is not implemented!");return n=>{let a,i,s,o,c,l,u,d;a=e.sqr(n),a=e.mul(a,t.Z),i=e.sqr(a),i=e.add(i,a),s=e.add(i,e.ONE),s=e.mul(s,t.B),o=e.cmov(t.Z,e.neg(i),!e.eql(i,e.ZERO)),o=e.mul(o,t.A),i=e.sqr(s),l=e.sqr(o),c=e.mul(l,t.A),i=e.add(i,c),i=e.mul(i,s),l=e.mul(l,o),c=e.mul(l,t.B),i=e.add(i,c),u=e.mul(a,s);const{isValid:f,value:m}=r(i,l);d=e.mul(a,n),d=e.mul(d,m),u=e.cmov(u,s,f),d=e.cmov(d,m,f);const h=e.isOdd(n)===e.isOdd(d);return d=e.cmov(e.neg(d),d,h),u=e.div(u,o),{x:u,y:d}}};
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const n=e("./curve.js"),a=e("./modular.js"),i=e("./utils.js"),s=e("./utils.js");const{bytesToNumberBE:o,hexToBytes:c}=i;r.DER={Err:class extends Error{constructor(e=""){super(e)}},_parseInt(e){const{Err:t}=r.DER;if(e.length<2||2!==e[0])throw new t("Invalid signature integer tag");const n=e[1],a=e.subarray(2,n+2);if(!n||a.length!==n)throw new t("Invalid signature integer: wrong length");if(128&a[0])throw new t("Invalid signature integer: negative");if(0===a[0]&&!(128&a[1]))throw new t("Invalid signature integer: unnecessary leading zero");return{d:o(a),l:e.subarray(n+2)}},toSig(e){const{Err:t}=r.DER,n="string"==typeof e?c(e):e;i.abytes(n);let a=n.length;if(a<2||48!=n[0])throw new t("Invalid signature tag");if(n[1]!==a-2)throw new t("Invalid signature: incorrect length");const{d:s,l:o}=r.DER._parseInt(n.subarray(2)),{d:l,l:u}=r.DER._parseInt(o);if(u.length)throw new t("Invalid signature: left bytes after parsing");return{r:s,s:l}},hexFromSig(e){const t=e=>8&Number.parseInt(e[0],16)?"00"+e:e,r=e=>{const t=e.toString(16);return 1&t.length?`0${t}`:t},n=t(r(e.s)),a=t(r(e.r)),i=n.length/2,s=a.length/2,o=r(i),c=r(s);return`30${r(s+i+4)}02${c}${a}02${o}${n}`}};const l=BigInt(0),u=BigInt(1),d=BigInt(2),f=BigInt(3),m=BigInt(4);function h(e){const t=function(e){const t=(0,n.validateBasic)(e);i.validateObject(t,{a:"field",b:"field"},{allowedPrivateKeyLengths:"array",wrapPrivateKey:"boolean",isTorsionFree:"function",clearCofactor:"function",allowInfinityPoint:"boolean",fromBytes:"function",toBytes:"function"});const{endo:r,Fp:a,a:s}=t;if(r){if(!a.eql(s,a.ZERO))throw new Error("Endomorphism can only be defined for Koblitz curves that have a=0");if("object"!=typeof r||"bigint"!=typeof r.beta||"function"!=typeof r.splitScalar)throw new Error("Expected endomorphism with beta: bigint and splitScalar: function")}return Object.freeze({...t})}(e),{Fp:r}=t,o=t.toBytes||((e,t,n)=>{const a=t.toAffine();return i.concatBytes(Uint8Array.from([4]),r.toBytes(a.x),r.toBytes(a.y))}),c=t.fromBytes||(e=>{const t=e.subarray(1);return{x:r.fromBytes(t.subarray(0,r.BYTES)),y:r.fromBytes(t.subarray(r.BYTES,2*r.BYTES))}});function d(e){const{a:n,b:a}=t,i=r.sqr(e),s=r.mul(i,e);return r.add(r.add(s,r.mul(e,n)),a)}if(!r.eql(r.sqr(t.Gy),d(t.Gx)))throw new Error("bad generator point: equation left != right");function m(e){return"bigint"==typeof e&&l<e&&e<t.n}function h(e){if(!m(e))throw new Error("Expected valid bigint: 0 < bigint < curve.n")}function p(e){const{allowedPrivateKeyLengths:r,nByteLength:n,wrapPrivateKey:o,n:c}=t;if(r&&"bigint"!=typeof e){if(i.isBytes(e)&&(e=i.bytesToHex(e)),"string"!=typeof e||!r.includes(e.length))throw new Error("Invalid key");e=e.padStart(2*n,"0")}let l;try{l="bigint"==typeof e?e:i.bytesToNumberBE((0,s.ensureBytes)("private key",e,n))}catch(t){throw new Error(`private key must be ${n} bytes, hex or bigint, not ${typeof e}`)}return o&&(l=a.mod(l,c)),h(l),l}const g=new Map;function b(e){if(!(e instanceof y))throw new Error("ProjectivePoint expected")}class y{constructor(e,t,n){if(this.px=e,this.py=t,this.pz=n,null==e||!r.isValid(e))throw new Error("x required");if(null==t||!r.isValid(t))throw new Error("y required");if(null==n||!r.isValid(n))throw new Error("z required")}static fromAffine(e){const{x:t,y:n}=e||{};if(!e||!r.isValid(t)||!r.isValid(n))throw new Error("invalid affine point");if(e instanceof y)throw new Error("projective point not allowed");const a=e=>r.eql(e,r.ZERO);return a(t)&&a(n)?y.ZERO:new y(t,n,r.ONE)}get x(){return this.toAffine().x}get y(){return this.toAffine().y}static normalizeZ(e){const t=r.invertBatch(e.map(e=>e.pz));return e.map((e,r)=>e.toAffine(t[r])).map(y.fromAffine)}static fromHex(e){const t=y.fromAffine(c((0,s.ensureBytes)("pointHex",e)));return t.assertValidity(),t}static fromPrivateKey(e){return y.BASE.multiply(p(e))}_setWindowSize(e){this._WINDOW_SIZE=e,g.delete(this)}assertValidity(){if(this.is0()){if(t.allowInfinityPoint&&!r.is0(this.py))return;throw new Error("bad point: ZERO")}const{x:e,y:n}=this.toAffine();if(!r.isValid(e)||!r.isValid(n))throw new Error("bad point: x or y not FE");const a=r.sqr(n),i=d(e);if(!r.eql(a,i))throw new Error("bad point: equation left != right");if(!this.isTorsionFree())throw new Error("bad point: not in prime-order subgroup")}hasEvenY(){const{y:e}=this.toAffine();if(r.isOdd)return!r.isOdd(e);throw new Error("Field doesn't support isOdd")}equals(e){b(e);const{px:t,py:n,pz:a}=this,{px:i,py:s,pz:o}=e,c=r.eql(r.mul(t,o),r.mul(i,a)),l=r.eql(r.mul(n,o),r.mul(s,a));return c&&l}negate(){return new y(this.px,r.neg(this.py),this.pz)}double(){const{a:e,b:n}=t,a=r.mul(n,f),{px:i,py:s,pz:o}=this;let c=r.ZERO,l=r.ZERO,u=r.ZERO,d=r.mul(i,i),m=r.mul(s,s),h=r.mul(o,o),p=r.mul(i,s);return p=r.add(p,p),u=r.mul(i,o),u=r.add(u,u),c=r.mul(e,u),l=r.mul(a,h),l=r.add(c,l),c=r.sub(m,l),l=r.add(m,l),l=r.mul(c,l),c=r.mul(p,c),u=r.mul(a,u),h=r.mul(e,h),p=r.sub(d,h),p=r.mul(e,p),p=r.add(p,u),u=r.add(d,d),d=r.add(u,d),d=r.add(d,h),d=r.mul(d,p),l=r.add(l,d),h=r.mul(s,o),h=r.add(h,h),d=r.mul(h,p),c=r.sub(c,d),u=r.mul(h,m),u=r.add(u,u),u=r.add(u,u),new y(c,l,u)}add(e){b(e);const{px:n,py:a,pz:i}=this,{px:s,py:o,pz:c}=e;let l=r.ZERO,u=r.ZERO,d=r.ZERO;const m=t.a,h=r.mul(t.b,f);let p=r.mul(n,s),g=r.mul(a,o),v=r.mul(i,c),w=r.add(n,a),_=r.add(s,o);w=r.mul(w,_),_=r.add(p,g),w=r.sub(w,_),_=r.add(n,i);let j=r.add(s,c);return _=r.mul(_,j),j=r.add(p,v),_=r.sub(_,j),j=r.add(a,i),l=r.add(o,c),j=r.mul(j,l),l=r.add(g,v),j=r.sub(j,l),d=r.mul(m,_),l=r.mul(h,v),d=r.add(l,d),l=r.sub(g,d),d=r.add(g,d),u=r.mul(l,d),g=r.add(p,p),g=r.add(g,p),v=r.mul(m,v),_=r.mul(h,_),g=r.add(g,v),v=r.sub(p,v),v=r.mul(m,v),_=r.add(_,v),p=r.mul(g,_),u=r.add(u,p),p=r.mul(j,_),l=r.mul(w,l),l=r.sub(l,p),p=r.mul(w,g),d=r.mul(j,d),d=r.add(d,p),new y(l,u,d)}subtract(e){return this.add(e.negate())}is0(){return this.equals(y.ZERO)}wNAF(e){return w.wNAFCached(this,g,e,e=>{const t=r.invertBatch(e.map(e=>e.pz));return e.map((e,r)=>e.toAffine(t[r])).map(y.fromAffine)})}multiplyUnsafe(e){const n=y.ZERO;if(e===l)return n;if(h(e),e===u)return this;const{endo:a}=t;if(!a)return w.unsafeLadder(this,e);let{k1neg:i,k1:s,k2neg:o,k2:c}=a.splitScalar(e),d=n,f=n,m=this;for(;s>l||c>l;)s&u&&(d=d.add(m)),c&u&&(f=f.add(m)),m=m.double(),s>>=u,c>>=u;return i&&(d=d.negate()),o&&(f=f.negate()),f=new y(r.mul(f.px,a.beta),f.py,f.pz),d.add(f)}multiply(e){h(e);let n,a,i=e;const{endo:s}=t;if(s){const{k1neg:e,k1:t,k2neg:o,k2:c}=s.splitScalar(i);let{p:l,f:u}=this.wNAF(t),{p:d,f:f}=this.wNAF(c);l=w.constTimeNegate(e,l),d=w.constTimeNegate(o,d),d=new y(r.mul(d.px,s.beta),d.py,d.pz),n=l.add(d),a=u.add(f)}else{const{p:e,f:t}=this.wNAF(i);n=e,a=t}return y.normalizeZ([n,a])[0]}multiplyAndAddUnsafe(e,t,r){const n=y.BASE,a=(e,t)=>t!==l&&t!==u&&e.equals(n)?e.multiply(t):e.multiplyUnsafe(t),i=a(this,t).add(a(e,r));return i.is0()?undefined:i}toAffine(e){const{px:t,py:n,pz:a}=this,i=this.is0();null==e&&(e=i?r.ONE:r.inv(a));const s=r.mul(t,e),o=r.mul(n,e),c=r.mul(a,e);if(i)return{x:r.ZERO,y:r.ZERO};if(!r.eql(c,r.ONE))throw new Error("invZ was invalid");return{x:s,y:o}}isTorsionFree(){const{h:e,isTorsionFree:r}=t;if(e===u)return!0;if(r)return r(y,this);throw new Error("isTorsionFree() has not been declared for the elliptic curve")}clearCofactor(){const{h:e,clearCofactor:r}=t;return e===u?this:r?r(y,this):this.multiplyUnsafe(t.h)}toRawBytes(e=!0){return this.assertValidity(),o(y,this,e)}toHex(e=!0){return i.bytesToHex(this.toRawBytes(e))}}y.BASE=new y(t.Gx,t.Gy,r.ONE),y.ZERO=new y(r.ZERO,r.ONE,r.ZERO);const v=t.nBitLength,w=(0,n.wNAF)(y,t.endo?Math.ceil(v/2):v);return{CURVE:t,ProjectivePoint:y,normPrivateKeyToScalar:p,weierstrassEquation:d,isWithinCurveOrder:m}}function p(e,t){const r=e.ORDER;let n=l;for(let e=r-u;e%d===l;e/=d)n+=u;const a=n,i=d<<a-u-u,s=i*d,o=(r-u)/s,c=(o-u)/d,h=s-u,p=i,g=e.pow(t,o),b=e.pow(t,(o+u)/d);let y=(t,r)=>{let n=g,i=e.pow(r,h),s=e.sqr(i);s=e.mul(s,r);let o=e.mul(t,s);o=e.pow(o,c),o=e.mul(o,i),i=e.mul(o,r),s=e.mul(o,t);let l=e.mul(s,i);o=e.pow(l,p);let f=e.eql(o,e.ONE);i=e.mul(s,b),o=e.mul(l,n),s=e.cmov(i,s,f),l=e.cmov(o,l,f);for(let t=a;t>u;t--){let r=t-d;r=d<<r-u;let a=e.pow(l,r);const o=e.eql(a,e.ONE);i=e.mul(s,n),n=e.mul(n,n),a=e.mul(l,n),s=e.cmov(i,s,o),l=e.cmov(a,l,o)}return{isValid:f,value:s}};if(e.ORDER%m===f){const r=(e.ORDER-f)/m,n=e.sqrt(e.neg(t));y=(t,a)=>{let i=e.sqr(a);const s=e.mul(t,a);i=e.mul(i,s);let o=e.pow(i,r);o=e.mul(o,s);const c=e.mul(o,n),l=e.mul(e.sqr(o),a),u=e.eql(l,t);return{isValid:u,value:e.cmov(c,o,u)}}}return y}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/curves",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/curves/abstract/weierstrass.js"}],[2062,{"./_shortw_utils.js":2056,"./abstract/hash-to-curve.js":2058,"./abstract/modular.js":2059,"./abstract/utils.js":2060,"./abstract/weierstrass.js":2061,"@noble/hashes/sha256":2069,"@noble/hashes/utils":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.encodeToCurve=r.hashToCurve=r.schnorr=r.secp256k1=void 0;
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const n=e("@noble/hashes/sha256"),a=e("@noble/hashes/utils"),i=e("./_shortw_utils.js"),s=e("./abstract/hash-to-curve.js"),o=e("./abstract/modular.js"),c=e("./abstract/utils.js"),l=e("./abstract/weierstrass.js"),u=BigInt("0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2f"),d=BigInt("0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141"),f=BigInt(1),m=BigInt(2),h=(e,t)=>(e+t/m)/t;function p(e){const t=u,r=BigInt(3),n=BigInt(6),a=BigInt(11),i=BigInt(22),s=BigInt(23),c=BigInt(44),l=BigInt(88),d=e*e*e%t,f=d*d*e%t,h=(0,o.pow2)(f,r,t)*f%t,p=(0,o.pow2)(h,r,t)*f%t,b=(0,o.pow2)(p,m,t)*d%t,y=(0,o.pow2)(b,a,t)*b%t,v=(0,o.pow2)(y,i,t)*y%t,w=(0,o.pow2)(v,c,t)*v%t,_=(0,o.pow2)(w,l,t)*w%t,j=(0,o.pow2)(_,c,t)*v%t,O=(0,o.pow2)(j,r,t)*f%t,E=(0,o.pow2)(O,s,t)*y%t,C=(0,o.pow2)(E,n,t)*d%t,k=(0,o.pow2)(C,m,t);if(!g.eql(g.sqr(k),e))throw new Error("Cannot find square root");return k}const g=(0,o.Field)(u,undefined,undefined,{sqrt:p});r.secp256k1=(0,i.createCurve)({a:BigInt(0),b:BigInt(7),Fp:g,n:d,Gx:BigInt("55066263022277343669578718895168534326250603453777594175500187360389116729240"),Gy:BigInt("32670510020758816978083085130507043184471273380659243275938904335757337482424"),h:BigInt(1),lowS:!0,endo:{beta:BigInt("0x7ae96a2b657c07106e64479eac3434e99cf0497512f58995c1396c28719501ee"),splitScalar:e=>{const t=d,r=BigInt("0x3086d221a7d46bcde86c90e49284eb15"),n=-f*BigInt("0xe4437ed6010e88286f547fa90abfe4c3"),a=BigInt("0x114ca50f7a8e2f3f657c1108d9d44cfd8"),i=r,s=BigInt("0x100000000000000000000000000000000"),c=h(i*e,t),l=h(-n*e,t);let u=(0,o.mod)(e-c*r-l*a,t),m=(0,o.mod)(-c*n-l*i,t);const p=u>s,g=m>s;if(p&&(u=t-u),g&&(m=t-m),u>s||m>s)throw new Error("splitScalar: Endomorphism failed, k="+e);return{k1neg:p,k1:u,k2neg:g,k2:m}}}},n.sha256);const b=BigInt(0),y=e=>"bigint"==typeof e&&b<e&&e<u,v={};function w(e,...t){let r=v[e];if(r===undefined){const t=(0,n.sha256)(Uint8Array.from(e,e=>e.charCodeAt(0)));r=(0,c.concatBytes)(t,t),v[e]=r}return(0,n.sha256)((0,c.concatBytes)(r,...t))}const _=e=>e.toRawBytes(!0).slice(1),j=e=>(0,c.numberToBytesBE)(e,32),O=e=>(0,o.mod)(e,u),E=e=>(0,o.mod)(e,d),C=r.secp256k1.ProjectivePoint;function k(e){let t=r.secp256k1.utils.normPrivateKeyToScalar(e),n=C.fromPrivateKey(t);return{scalar:n.hasEvenY()?t:E(-t),bytes:_(n)}}function x(e){if(!y(e))throw new Error("bad x: need 0 < x < p");const t=O(e*e);let r=p(O(t*e+BigInt(7)));r%m!==b&&(r=O(-r));const n=new C(e,r,f);return n.assertValidity(),n}function T(...e){return E((0,c.bytesToNumberBE)(w("BIP0340/challenge",...e)))}function A(e){return k(e).bytes}function P(e,t,r=(0,a.randomBytes)(32)){const n=(0,c.ensureBytes)("message",e),{bytes:i,scalar:s}=k(t),o=(0,c.ensureBytes)("auxRand",r,32),l=j(s^(0,c.bytesToNumberBE)(w("BIP0340/aux",o))),u=w("BIP0340/nonce",l,i,n),d=E((0,c.bytesToNumberBE)(u));if(d===b)throw new Error("sign failed: k is zero");const{bytes:f,scalar:m}=k(d),h=T(f,i,n),p=new Uint8Array(64);if(p.set(f,0),p.set(j(E(m+h*s)),32),!B(p,n,i))throw new Error("sign: Invalid signature produced");return p}function B(e,t,r){const n=(0,c.ensureBytes)("signature",e,64),a=(0,c.ensureBytes)("message",t),i=(0,c.ensureBytes)("publicKey",r,32);try{const e=x((0,c.bytesToNumberBE)(i)),t=(0,c.bytesToNumberBE)(n.subarray(0,32));if(!y(t))return!1;const r=(0,c.bytesToNumberBE)(n.subarray(32,64));if(!("bigint"==typeof(u=r)&&b<u&&u<d))return!1;const f=T(j(t),_(e),a),m=(s=e,o=r,l=E(-f),C.BASE.multiplyAndAddUnsafe(s,o,l));return!(!m||!m.hasEvenY()||m.toAffine().x!==t)}catch(e){return!1}var s,o,l,u}r.schnorr={getPublicKey:A,sign:P,verify:B,utils:{randomPrivateKey:r.secp256k1.utils.randomPrivateKey,lift_x:x,pointToBytes:_,numberToBytesBE:c.numberToBytesBE,bytesToNumberBE:c.bytesToNumberBE,taggedHash:w,mod:o.mod}};const S=(()=>(0,s.isogenyMap)(g,[["0x8e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38daaaaa8c7","0x7d3d4c80bc321d5b9f315cea7fd44c5d595d2fc0bf63b92dfff1044f17c6581","0x534c328d23f234e6e2a413deca25caece4506144037c40314ecbd0b53d9dd262","0x8e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38daaaaa88c"],["0xd35771193d94918a9ca34ccbb7b640dd86cd409542f8487d9fe6b745781eb49b","0xedadc6f64383dc1df7c4b2d51b54225406d36b641f5e41bbc52a56612a8c6d14","0x0000000000000000000000000000000000000000000000000000000000000001"],["0x4bda12f684bda12f684bda12f684bda12f684bda12f684bda12f684b8e38e23c","0xc75e0c32d5cb7c0fa9d0a54b12a0a6d5647ab046d686da6fdffc90fc201d71a3","0x29a6194691f91a73715209ef6512e576722830a201be2018a765e85a9ecee931","0x2f684bda12f684bda12f684bda12f684bda12f684bda12f684bda12f38e38d84"],["0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffff93b","0x7a06534bb8bdb49fd5e9e6632722c2989467c1bfc8e8d978dfb425d2685c2573","0x6484aa716545ca2cf3a70c3fa8fe337e0a3d21162f0d6299a7bf8192bfd2a76f","0x0000000000000000000000000000000000000000000000000000000000000001"]].map(e=>e.map(e=>BigInt(e)))))(),M=(()=>(0,l.mapToCurveSimpleSWU)(g,{A:BigInt("0x3f8731abdd661adca08a5558f0f5d272e953d363cb6f0e5d405447c01a444533"),B:BigInt("1771"),Z:g.create(BigInt("-11"))}))(),D=(()=>(0,s.createHasher)(r.secp256k1.ProjectivePoint,e=>{const{x:t,y:r}=M(g.create(e[0]));return S(t,r)},{DST:"secp256k1_XMD:SHA-256_SSWU_RO_",encodeDST:"secp256k1_XMD:SHA-256_SSWU_NU_",p:g.ORDER,m:1,k:128,expand:"xmd",hash:n.sha256}))();r.hashToCurve=D.hashToCurve,r.encodeToCurve=D.encodeToCurve}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/curves",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/curves/secp256k1.js"}],[2063,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`positive integer expected, not ${e}`)}function a(e){if("boolean"!=typeof e)throw new Error(`boolean expected, not ${e}`)}function i(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function s(e,...t){if(!i(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error(`Uint8Array expected of length ${t}, not of length=${e.length}`)}function o(e){if("function"!=typeof e||"function"!=typeof e.create)throw new Error("Hash should be wrapped by utils.wrapConstructor");n(e.outputLen),n(e.blockLen)}function c(e,t=!0){if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")}function l(e,t){s(e);const r=t.outputLen;if(e.length<r)throw new Error(`digestInto() expects output buffer of length at least ${r}`)}Object.defineProperty(r,"__esModule",{value:!0}),r.output=r.exists=r.hash=r.bytes=r.bool=r.number=r.isBytes=void 0,r.number=n,r.bool=a,r.isBytes=i,r.bytes=s,r.hash=o,r.exists=c,r.output=l;const u={number:n,bool:a,bytes:s,hash:o,exists:c,output:l};r.default=u}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/_assert.js"}],[2064,{"./_assert.js":2063,"./utils.js":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.HashMD=r.Maj=r.Chi=void 0;const n=e("./_assert.js"),a=e("./utils.js");r.Chi=(e,t,r)=>e&t^~e&r;r.Maj=(e,t,r)=>e&t^e&r^t&r;class i extends a.Hash{constructor(e,t,r,n){super(),this.blockLen=e,this.outputLen=t,this.padOffset=r,this.isLE=n,this.finished=!1,this.length=0,this.pos=0,this.destroyed=!1,this.buffer=new Uint8Array(e),this.view=(0,a.createView)(this.buffer)}update(e){(0,n.exists)(this);const{view:t,buffer:r,blockLen:i}=this,s=(e=(0,a.toBytes)(e)).length;for(let n=0;n<s;){const o=Math.min(i-this.pos,s-n);if(o===i){const t=(0,a.createView)(e);for(;i<=s-n;n+=i)this.process(t,n);continue}r.set(e.subarray(n,n+o),this.pos),this.pos+=o,n+=o,this.pos===i&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,n.exists)(this),(0,n.output)(e,this),this.finished=!0;const{buffer:t,view:r,blockLen:i,isLE:s}=this;let{pos:o}=this;t[o++]=128,this.buffer.subarray(o).fill(0),this.padOffset>i-o&&(this.process(r,0),o=0);for(let e=o;e<i;e++)t[e]=0;!function(e,t,r,n){if("function"==typeof e.setBigUint64)return e.setBigUint64(t,r,n);const a=BigInt(32),i=BigInt(4294967295),s=Number(r>>a&i),o=Number(r&i),c=n?4:0,l=n?0:4;e.setUint32(t+c,s,n),e.setUint32(t+l,o,n)}(r,i-8,BigInt(8*this.length),s),this.process(r,0);const c=(0,a.createView)(e),l=this.outputLen;if(l%4)throw new Error("_sha2: outputLen should be aligned to 32bit");const u=l/4,d=this.get();if(u>d.length)throw new Error("_sha2: outputLen bigger than state");for(let e=0;e<u;e++)c.setUint32(4*e,d[e],s)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const r=e.slice(0,t);return this.destroy(),r}_cloneInto(e){e||(e=new this.constructor),e.set(...this.get());const{blockLen:t,buffer:r,length:n,finished:a,destroyed:i,pos:s}=this;return e.length=n,e.pos=s,e.finished=a,e.destroyed=i,n%t&&e.buffer.set(r),e}}r.HashMD=i}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/_md.js"}],[2065,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.add5L=r.add5H=r.add4H=r.add4L=r.add3H=r.add3L=r.add=r.rotlBL=r.rotlBH=r.rotlSL=r.rotlSH=r.rotr32L=r.rotr32H=r.rotrBL=r.rotrBH=r.rotrSL=r.rotrSH=r.shrSL=r.shrSH=r.toBig=r.split=r.fromBig=void 0;const n=BigInt(2**32-1),a=BigInt(32);function i(e,t=!1){return t?{h:Number(e&n),l:Number(e>>a&n)}:{h:0|Number(e>>a&n),l:0|Number(e&n)}}function s(e,t=!1){let r=new Uint32Array(e.length),n=new Uint32Array(e.length);for(let a=0;a<e.length;a++){const{h:s,l:o}=i(e[a],t);[r[a],n[a]]=[s,o]}return[r,n]}r.fromBig=i,r.split=s;const o=(e,t)=>BigInt(e>>>0)<<a|BigInt(t>>>0);r.toBig=o;const c=(e,t,r)=>e>>>r;r.shrSH=c;const l=(e,t,r)=>e<<32-r|t>>>r;r.shrSL=l;const u=(e,t,r)=>e>>>r|t<<32-r;r.rotrSH=u;const d=(e,t,r)=>e<<32-r|t>>>r;r.rotrSL=d;const f=(e,t,r)=>e<<64-r|t>>>r-32;r.rotrBH=f;const m=(e,t,r)=>e>>>r-32|t<<64-r;r.rotrBL=m;const h=(e,t)=>t;r.rotr32H=h;const p=(e,t)=>e;r.rotr32L=p;const g=(e,t,r)=>e<<r|t>>>32-r;r.rotlSH=g;const b=(e,t,r)=>t<<r|e>>>32-r;r.rotlSL=b;const y=(e,t,r)=>t<<r-32|e>>>64-r;r.rotlBH=y;const v=(e,t,r)=>e<<r-32|t>>>64-r;function w(e,t,r,n){const a=(t>>>0)+(n>>>0);return{h:e+r+(a/2**32|0)|0,l:0|a}}r.rotlBL=v,r.add=w;const _=(e,t,r)=>(e>>>0)+(t>>>0)+(r>>>0);r.add3L=_;const j=(e,t,r,n)=>t+r+n+(e/2**32|0)|0;r.add3H=j;const O=(e,t,r,n)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0);r.add4L=O;const E=(e,t,r,n,a)=>t+r+n+a+(e/2**32|0)|0;r.add4H=E;const C=(e,t,r,n,a)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0)+(a>>>0);r.add5L=C;const k=(e,t,r,n,a,i)=>t+r+n+a+i+(e/2**32|0)|0;r.add5H=k;const x={fromBig:i,split:s,toBig:o,shrSH:c,shrSL:l,rotrSH:u,rotrSL:d,rotrBH:f,rotrBL:m,rotr32H:h,rotr32L:p,rotlSH:g,rotlSL:b,rotlBH:y,rotlBL:v,add:w,add3L:_,add3H:j,add4L:O,add4H:E,add5H:k,add5L:C};r.default=x}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/_u64.js"}],[2066,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.crypto=void 0,r.crypto="object"==typeof globalThis&&"crypto"in globalThis?globalThis.crypto:undefined}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/crypto.js"}],[2067,{"./_assert.js":2063,"./utils.js":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.hmac=r.HMAC=void 0;const n=e("./_assert.js"),a=e("./utils.js");class i extends a.Hash{constructor(e,t){super(),this.finished=!1,this.destroyed=!1,(0,n.hash)(e);const r=(0,a.toBytes)(t);if(this.iHash=e.create(),"function"!=typeof this.iHash.update)throw new Error("Expected instance of class which extends utils.Hash");this.blockLen=this.iHash.blockLen,this.outputLen=this.iHash.outputLen;const i=this.blockLen,s=new Uint8Array(i);s.set(r.length>i?e.create().update(r).digest():r);for(let e=0;e<s.length;e++)s[e]^=54;this.iHash.update(s),this.oHash=e.create();for(let e=0;e<s.length;e++)s[e]^=106;this.oHash.update(s),s.fill(0)}update(e){return(0,n.exists)(this),this.iHash.update(e),this}digestInto(e){(0,n.exists)(this),(0,n.bytes)(e,this.outputLen),this.finished=!0,this.iHash.digestInto(e),this.oHash.update(e),this.oHash.digestInto(e),this.destroy()}digest(){const e=new Uint8Array(this.oHash.outputLen);return this.digestInto(e),e}_cloneInto(e){e||(e=Object.create(Object.getPrototypeOf(this),{}));const{oHash:t,iHash:r,finished:n,destroyed:a,blockLen:i,outputLen:s}=this;return e.finished=n,e.destroyed=a,e.blockLen=i,e.outputLen=s,e.oHash=t._cloneInto(e.oHash),e.iHash=r._cloneInto(e.iHash),e}destroy(){this.destroyed=!0,this.oHash.destroy(),this.iHash.destroy()}}r.HMAC=i;r.hmac=(e,t,r)=>new i(e,t).update(r).digest(),r.hmac.create=(e,t)=>new i(e,t)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/hmac.js"}],[2068,{"./_md.js":2064,"./utils.js":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ripemd160=r.RIPEMD160=void 0;const n=e("./_md.js"),a=e("./utils.js"),i=new Uint8Array([7,4,13,1,10,6,15,3,12,0,9,5,2,14,11,8]),s=new Uint8Array(new Array(16).fill(0).map((e,t)=>t));let o=[s],c=[s.map(e=>(9*e+5)%16)];for(let e=0;e<4;e++)for(let t of[o,c])t.push(t[e].map(e=>i[e]));const l=[[11,14,15,12,5,8,7,9,11,13,14,15,6,7,9,8],[12,13,11,15,6,9,9,7,12,15,11,13,7,8,7,7],[13,15,14,11,7,7,6,8,13,14,13,12,5,5,6,9],[14,11,12,14,8,6,5,5,15,12,15,14,9,9,8,6],[15,12,13,13,9,5,8,6,14,11,12,11,8,6,5,5]].map(e=>new Uint8Array(e)),u=o.map((e,t)=>e.map(e=>l[t][e])),d=c.map((e,t)=>e.map(e=>l[t][e])),f=new Uint32Array([0,1518500249,1859775393,2400959708,2840853838]),m=new Uint32Array([1352829926,1548603684,1836072691,2053994217,0]);function h(e,t,r,n){return 0===e?t^r^n:1===e?t&r|~t&n:2===e?(t|~r)^n:3===e?t&n|r&~n:t^(r|~n)}const p=new Uint32Array(16);class g extends n.HashMD{constructor(){super(64,20,8,!0),this.h0=1732584193,this.h1=-271733879,this.h2=-1732584194,this.h3=271733878,this.h4=-1009589776}get(){const{h0:e,h1:t,h2:r,h3:n,h4:a}=this;return[e,t,r,n,a]}set(e,t,r,n,a){this.h0=0|e,this.h1=0|t,this.h2=0|r,this.h3=0|n,this.h4=0|a}process(e,t){for(let r=0;r<16;r++,t+=4)p[r]=e.getUint32(t,!0);let r=0|this.h0,n=r,i=0|this.h1,s=i,l=0|this.h2,g=l,b=0|this.h3,y=b,v=0|this.h4,w=v;for(let e=0;e<5;e++){const t=4-e,_=f[e],j=m[e],O=o[e],E=c[e],C=u[e],k=d[e];for(let t=0;t<16;t++){const n=(0,a.rotl)(r+h(e,i,l,b)+p[O[t]]+_,C[t])+v|0;r=v,v=b,b=0|(0,a.rotl)(l,10),l=i,i=n}for(let e=0;e<16;e++){const r=(0,a.rotl)(n+h(t,s,g,y)+p[E[e]]+j,k[e])+w|0;n=w,w=y,y=0|(0,a.rotl)(g,10),g=s,s=r}}this.set(this.h1+l+y|0,this.h2+b+w|0,this.h3+v+n|0,this.h4+r+s|0,this.h0+i+g|0)}roundClean(){p.fill(0)}destroy(){this.destroyed=!0,this.buffer.fill(0),this.set(0,0,0,0,0)}}r.RIPEMD160=g,r.ripemd160=(0,a.wrapConstructor)(()=>new g)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/ripemd160.js"}],[2069,{"./_md.js":2064,"./utils.js":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.sha224=r.sha256=void 0;const n=e("./_md.js"),a=e("./utils.js"),i=new Uint32Array([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),s=new Uint32Array([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),o=new Uint32Array(64);class c extends n.HashMD{constructor(){super(64,32,8,!1),this.A=0|s[0],this.B=0|s[1],this.C=0|s[2],this.D=0|s[3],this.E=0|s[4],this.F=0|s[5],this.G=0|s[6],this.H=0|s[7]}get(){const{A:e,B:t,C:r,D:n,E:a,F:i,G:s,H:o}=this;return[e,t,r,n,a,i,s,o]}set(e,t,r,n,a,i,s,o){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|a,this.F=0|i,this.G=0|s,this.H=0|o}process(e,t){for(let r=0;r<16;r++,t+=4)o[r]=e.getUint32(t,!1);for(let e=16;e<64;e++){const t=o[e-15],r=o[e-2],n=(0,a.rotr)(t,7)^(0,a.rotr)(t,18)^t>>>3,i=(0,a.rotr)(r,17)^(0,a.rotr)(r,19)^r>>>10;o[e]=i+o[e-7]+n+o[e-16]|0}let{A:r,B:s,C:c,D:l,E:u,F:d,G:f,H:m}=this;for(let e=0;e<64;e++){const t=m+((0,a.rotr)(u,6)^(0,a.rotr)(u,11)^(0,a.rotr)(u,25))+(0,n.Chi)(u,d,f)+i[e]+o[e]|0,h=((0,a.rotr)(r,2)^(0,a.rotr)(r,13)^(0,a.rotr)(r,22))+(0,n.Maj)(r,s,c)|0;m=f,f=d,d=u,u=l+t|0,l=c,c=s,s=r,r=t+h|0}r=r+this.A|0,s=s+this.B|0,c=c+this.C|0,l=l+this.D|0,u=u+this.E|0,d=d+this.F|0,f=f+this.G|0,m=m+this.H|0,this.set(r,s,c,l,u,d,f,m)}roundClean(){o.fill(0)}destroy(){this.set(0,0,0,0,0,0,0,0),this.buffer.fill(0)}}class l extends c{constructor(){super(),this.A=-1056596264,this.B=914150663,this.C=812702999,this.D=-150054599,this.E=-4191439,this.F=1750603025,this.G=1694076839,this.H=-1090891868,this.outputLen=28}}r.sha256=(0,a.wrapConstructor)(()=>new c),r.sha224=(0,a.wrapConstructor)(()=>new l)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/sha256.js"}],[2070,{"./_assert.js":2063,"./_u64.js":2065,"./utils.js":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.shake256=r.shake128=r.keccak_512=r.keccak_384=r.keccak_256=r.keccak_224=r.sha3_512=r.sha3_384=r.sha3_256=r.sha3_224=r.Keccak=r.keccakP=void 0;const n=e("./_assert.js"),a=e("./_u64.js"),i=e("./utils.js"),s=[],o=[],c=[],l=BigInt(0),u=BigInt(1),d=BigInt(2),f=BigInt(7),m=BigInt(256),h=BigInt(113);for(let e=0,t=u,r=1,n=0;e<24;e++){[r,n]=[n,(2*r+3*n)%5],s.push(2*(5*n+r)),o.push((e+1)*(e+2)/2%64);let a=l;for(let e=0;e<7;e++)t=(t<<u^(t>>f)*h)%m,t&d&&(a^=u<<(u<<BigInt(e))-u);c.push(a)}const[p,g]=(0,a.split)(c,!0),b=(e,t,r)=>r>32?(0,a.rotlBH)(e,t,r):(0,a.rotlSH)(e,t,r),y=(e,t,r)=>r>32?(0,a.rotlBL)(e,t,r):(0,a.rotlSL)(e,t,r);function v(e,t=24){const r=new Uint32Array(10);for(let n=24-t;n<24;n++){for(let t=0;t<10;t++)r[t]=e[t]^e[t+10]^e[t+20]^e[t+30]^e[t+40];for(let t=0;t<10;t+=2){const n=(t+8)%10,a=(t+2)%10,i=r[a],s=r[a+1],o=b(i,s,1)^r[n],c=y(i,s,1)^r[n+1];for(let r=0;r<50;r+=10)e[t+r]^=o,e[t+r+1]^=c}let t=e[2],a=e[3];for(let r=0;r<24;r++){const n=o[r],i=b(t,a,n),c=y(t,a,n),l=s[r];t=e[l],a=e[l+1],e[l]=i,e[l+1]=c}for(let t=0;t<50;t+=10){for(let n=0;n<10;n++)r[n]=e[t+n];for(let n=0;n<10;n++)e[t+n]^=~r[(n+2)%10]&r[(n+4)%10]}e[0]^=p[n],e[1]^=g[n]}r.fill(0)}r.keccakP=v;class w extends i.Hash{constructor(e,t,r,a=!1,s=24){if(super(),this.blockLen=e,this.suffix=t,this.outputLen=r,this.enableXOF=a,this.rounds=s,this.pos=0,this.posOut=0,this.finished=!1,this.destroyed=!1,(0,n.number)(r),0>=this.blockLen||this.blockLen>=200)throw new Error("Sha3 supports only keccak-f1600 function");this.state=new Uint8Array(200),this.state32=(0,i.u32)(this.state)}keccak(){i.isLE||(0,i.byteSwap32)(this.state32),v(this.state32,this.rounds),i.isLE||(0,i.byteSwap32)(this.state32),this.posOut=0,this.pos=0}update(e){(0,n.exists)(this);const{blockLen:t,state:r}=this,a=(e=(0,i.toBytes)(e)).length;for(let n=0;n<a;){const i=Math.min(t-this.pos,a-n);for(let t=0;t<i;t++)r[this.pos++]^=e[n++];this.pos===t&&this.keccak()}return this}finish(){if(this.finished)return;this.finished=!0;const{state:e,suffix:t,pos:r,blockLen:n}=this;e[r]^=t,128&t&&r===n-1&&this.keccak(),e[n-1]^=128,this.keccak()}writeInto(e){(0,n.exists)(this,!1),(0,n.bytes)(e),this.finish();const t=this.state,{blockLen:r}=this;for(let n=0,a=e.length;n<a;){this.posOut>=r&&this.keccak();const i=Math.min(r-this.posOut,a-n);e.set(t.subarray(this.posOut,this.posOut+i),n),this.posOut+=i,n+=i}return e}xofInto(e){if(!this.enableXOF)throw new Error("XOF is not possible for this instance");return this.writeInto(e)}xof(e){return(0,n.number)(e),this.xofInto(new Uint8Array(e))}digestInto(e){if((0,n.output)(e,this),this.finished)throw new Error("digest() was already called");return this.writeInto(e),this.destroy(),e}digest(){return this.digestInto(new Uint8Array(this.outputLen))}destroy(){this.destroyed=!0,this.state.fill(0)}_cloneInto(e){const{blockLen:t,suffix:r,outputLen:n,rounds:a,enableXOF:i}=this;return e||(e=new w(t,r,n,i,a)),e.state32.set(this.state32),e.pos=this.pos,e.posOut=this.posOut,e.finished=this.finished,e.rounds=a,e.suffix=r,e.outputLen=n,e.enableXOF=i,e.destroyed=this.destroyed,e}}r.Keccak=w;const _=(e,t,r)=>(0,i.wrapConstructor)(()=>new w(t,e,r));r.sha3_224=_(6,144,28),r.sha3_256=_(6,136,32),r.sha3_384=_(6,104,48),r.sha3_512=_(6,72,64),r.keccak_224=_(1,144,28),r.keccak_256=_(1,136,32),r.keccak_384=_(1,104,48),r.keccak_512=_(1,72,64);const j=(e,t,r)=>(0,i.wrapXOFConstructorWithOpts)((n={})=>new w(t,e,n.dkLen===undefined?r:n.dkLen,!0));r.shake128=j(31,168,16),r.shake256=j(31,136,32)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/sha3.js"}],[2071,{"./_md.js":2064,"./_u64.js":2065,"./utils.js":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.sha384=r.sha512_256=r.sha512_224=r.sha512=r.SHA512=void 0;const n=e("./_md.js"),a=e("./_u64.js"),i=e("./utils.js"),[s,o]=(()=>a.default.split(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),c=new Uint32Array(80),l=new Uint32Array(80);class u extends n.HashMD{constructor(){super(128,64,16,!1),this.Ah=1779033703,this.Al=-205731576,this.Bh=-1150833019,this.Bl=-2067093701,this.Ch=1013904242,this.Cl=-23791573,this.Dh=-1521486534,this.Dl=1595750129,this.Eh=1359893119,this.El=-1377402159,this.Fh=-1694144372,this.Fl=725511199,this.Gh=528734635,this.Gl=-79577749,this.Hh=1541459225,this.Hl=327033209}get(){const{Ah:e,Al:t,Bh:r,Bl:n,Ch:a,Cl:i,Dh:s,Dl:o,Eh:c,El:l,Fh:u,Fl:d,Gh:f,Gl:m,Hh:h,Hl:p}=this;return[e,t,r,n,a,i,s,o,c,l,u,d,f,m,h,p]}set(e,t,r,n,a,i,s,o,c,l,u,d,f,m,h,p){this.Ah=0|e,this.Al=0|t,this.Bh=0|r,this.Bl=0|n,this.Ch=0|a,this.Cl=0|i,this.Dh=0|s,this.Dl=0|o,this.Eh=0|c,this.El=0|l,this.Fh=0|u,this.Fl=0|d,this.Gh=0|f,this.Gl=0|m,this.Hh=0|h,this.Hl=0|p}process(e,t){for(let r=0;r<16;r++,t+=4)c[r]=e.getUint32(t),l[r]=e.getUint32(t+=4);for(let e=16;e<80;e++){const t=0|c[e-15],r=0|l[e-15],n=a.default.rotrSH(t,r,1)^a.default.rotrSH(t,r,8)^a.default.shrSH(t,r,7),i=a.default.rotrSL(t,r,1)^a.default.rotrSL(t,r,8)^a.default.shrSL(t,r,7),s=0|c[e-2],o=0|l[e-2],u=a.default.rotrSH(s,o,19)^a.default.rotrBH(s,o,61)^a.default.shrSH(s,o,6),d=a.default.rotrSL(s,o,19)^a.default.rotrBL(s,o,61)^a.default.shrSL(s,o,6),f=a.default.add4L(i,d,l[e-7],l[e-16]),m=a.default.add4H(f,n,u,c[e-7],c[e-16]);c[e]=0|m,l[e]=0|f}let{Ah:r,Al:n,Bh:i,Bl:u,Ch:d,Cl:f,Dh:m,Dl:h,Eh:p,El:g,Fh:b,Fl:y,Gh:v,Gl:w,Hh:_,Hl:j}=this;for(let e=0;e<80;e++){const t=a.default.rotrSH(p,g,14)^a.default.rotrSH(p,g,18)^a.default.rotrBH(p,g,41),O=a.default.rotrSL(p,g,14)^a.default.rotrSL(p,g,18)^a.default.rotrBL(p,g,41),E=p&b^~p&v,C=g&y^~g&w,k=a.default.add5L(j,O,C,o[e],l[e]),x=a.default.add5H(k,_,t,E,s[e],c[e]),T=0|k,A=a.default.rotrSH(r,n,28)^a.default.rotrBH(r,n,34)^a.default.rotrBH(r,n,39),P=a.default.rotrSL(r,n,28)^a.default.rotrBL(r,n,34)^a.default.rotrBL(r,n,39),B=r&i^r&d^i&d,S=n&u^n&f^u&f;_=0|v,j=0|w,v=0|b,w=0|y,b=0|p,y=0|g,({h:p,l:g}=a.default.add(0|m,0|h,0|x,0|T)),m=0|d,h=0|f,d=0|i,f=0|u,i=0|r,u=0|n;const M=a.default.add3L(T,P,S);r=a.default.add3H(M,x,A,B),n=0|M}({h:r,l:n}=a.default.add(0|this.Ah,0|this.Al,0|r,0|n)),({h:i,l:u}=a.default.add(0|this.Bh,0|this.Bl,0|i,0|u)),({h:d,l:f}=a.default.add(0|this.Ch,0|this.Cl,0|d,0|f)),({h:m,l:h}=a.default.add(0|this.Dh,0|this.Dl,0|m,0|h)),({h:p,l:g}=a.default.add(0|this.Eh,0|this.El,0|p,0|g)),({h:b,l:y}=a.default.add(0|this.Fh,0|this.Fl,0|b,0|y)),({h:v,l:w}=a.default.add(0|this.Gh,0|this.Gl,0|v,0|w)),({h:_,l:j}=a.default.add(0|this.Hh,0|this.Hl,0|_,0|j)),this.set(r,n,i,u,d,f,m,h,p,g,b,y,v,w,_,j)}roundClean(){c.fill(0),l.fill(0)}destroy(){this.buffer.fill(0),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}r.SHA512=u;class d extends u{constructor(){super(),this.Ah=-1942145080,this.Al=424955298,this.Bh=1944164710,this.Bl=-1982016298,this.Ch=502970286,this.Cl=855612546,this.Dh=1738396948,this.Dl=1479516111,this.Eh=258812777,this.El=2077511080,this.Fh=2011393907,this.Fl=79989058,this.Gh=1067287976,this.Gl=1780299464,this.Hh=286451373,this.Hl=-1848208735,this.outputLen=28}}class f extends u{constructor(){super(),this.Ah=573645204,this.Al=-64227540,this.Bh=-1621794909,this.Bl=-934517566,this.Ch=596883563,this.Cl=1867755857,this.Dh=-1774684391,this.Dl=1497426621,this.Eh=-1775747358,this.El=-1467023389,this.Fh=-1101128155,this.Fl=1401305490,this.Gh=721525244,this.Gl=746961066,this.Hh=246885852,this.Hl=-2117784414,this.outputLen=32}}class m extends u{constructor(){super(),this.Ah=-876896931,this.Al=-1056596264,this.Bh=1654270250,this.Bl=914150663,this.Ch=-1856437926,this.Cl=812702999,this.Dh=355462360,this.Dl=-150054599,this.Eh=1731405415,this.El=-4191439,this.Fh=-1900787065,this.Fl=1750603025,this.Gh=-619958771,this.Gl=1694076839,this.Hh=1203062813,this.Hl=-1090891868,this.outputLen=48}}r.sha512=(0,i.wrapConstructor)(()=>new u),r.sha512_224=(0,i.wrapConstructor)(()=>new d),r.sha512_256=(0,i.wrapConstructor)(()=>new f),r.sha384=(0,i.wrapConstructor)(()=>new m)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/sha512.js"}],[2072,{"./_assert.js":2063,"@noble/hashes/crypto":2066},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){
/*! noble-hashes - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(r,"__esModule",{value:!0}),r.randomBytes=r.wrapXOFConstructorWithOpts=r.wrapConstructorWithOpts=r.wrapConstructor=r.checkOpts=r.Hash=r.concatBytes=r.toBytes=r.utf8ToBytes=r.asyncLoop=r.nextTick=r.hexToBytes=r.bytesToHex=r.byteSwap32=r.byteSwapIfBE=r.byteSwap=r.isLE=r.rotl=r.rotr=r.createView=r.u32=r.u8=r.isBytes=void 0;const n=e("@noble/hashes/crypto"),a=e("./_assert.js");r.isBytes=function(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name};r.u8=e=>new Uint8Array(e.buffer,e.byteOffset,e.byteLength);r.u32=e=>new Uint32Array(e.buffer,e.byteOffset,Math.floor(e.byteLength/4));r.createView=e=>new DataView(e.buffer,e.byteOffset,e.byteLength);r.rotr=(e,t)=>e<<32-t|e>>>t;r.rotl=(e,t)=>e<<t|e>>>32-t>>>0,r.isLE=68===new Uint8Array(new Uint32Array([287454020]).buffer)[0];r.byteSwap=e=>e<<24&4278190080|e<<8&16711680|e>>>8&65280|e>>>24&255,r.byteSwapIfBE=r.isLE?e=>e:e=>(0,r.byteSwap)(e),r.byteSwap32=function(e){for(let t=0;t<e.length;t++)e[t]=(0,r.byteSwap)(e[t])};const i=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));r.bytesToHex=function(e){(0,a.bytes)(e);let t="";for(let r=0;r<e.length;r++)t+=i[e[r]];return t};const s=48,o=57,c=65,l=70,u=97,d=102;function f(e){return e>=s&&e<=o?e-s:e>=c&&e<=l?e-(c-10):e>=u&&e<=d?e-(u-10):void 0}r.hexToBytes=function(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);const t=e.length,r=t/2;if(t%2)throw new Error("padded hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(r);for(let t=0,a=0;t<r;t++,a+=2){const r=f(e.charCodeAt(a)),i=f(e.charCodeAt(a+1));if(r===undefined||i===undefined){const t=e[a]+e[a+1];throw new Error('hex string expected, got non-hex character "'+t+'" at index '+a)}n[t]=16*r+i}return n};function m(e){if("string"!=typeof e)throw new Error("utf8ToBytes expected string, got "+typeof e);return new Uint8Array((new TextEncoder).encode(e))}function h(e){return"string"==typeof e&&(e=m(e)),(0,a.bytes)(e),e}r.nextTick=async()=>{},r.asyncLoop=async function(e,t,n){let a=Date.now();for(let i=0;i<e;i++){n(i);const e=Date.now()-a;e>=0&&e<t||(await(0,r.nextTick)(),a+=e)}},r.utf8ToBytes=m,r.toBytes=h,r.concatBytes=function(...e){let t=0;for(let r=0;r<e.length;r++){const n=e[r];(0,a.bytes)(n),t+=n.length}const r=new Uint8Array(t);for(let t=0,n=0;t<e.length;t++){const a=e[t];r.set(a,n),n+=a.length}return r};r.Hash=class{clone(){return this._cloneInto()}};const p={}.toString;r.checkOpts=function(e,t){if(t!==undefined&&"[object Object]"!==p.call(t))throw new Error("Options should be object or undefined");return Object.assign(e,t)},r.wrapConstructor=function(e){const t=t=>e().update(h(t)).digest(),r=e();return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=()=>e(),t},r.wrapConstructorWithOpts=function(e){const t=(t,r)=>e(r).update(h(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t},r.wrapXOFConstructorWithOpts=function(e){const t=(t,r)=>e(r).update(h(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t},r.randomBytes=function(e=32){if(n.crypto&&"function"==typeof n.crypto.getRandomValues)return n.crypto.getRandomValues(new Uint8Array(e));throw new Error("crypto.getRandomValues must be defined")}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@noble/hashes",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@noble/hashes/utils.js"}],[2073,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function a(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function i(...e){const t=e=>e,r=(e,t)=>r=>e(t(r));return{encode:e.map(e=>e.encode).reduceRight(r,t),decode:e.map(e=>e.decode).reduce(r,t)}}function s(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map(t=>{if(n(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]})},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map(t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const r=e.indexOf(t);if(-1===r)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return r})}}}function o(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(n(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;r.length*e%8;)r.push(t);return r},decode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let n=r.length;if(n*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;n>0&&r[n-1]===t;n--)if(!((n-1)*e%8))throw new Error("Invalid padding: string has too much padding");return r.slice(0,n)}}}function l(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function u(e,t,r){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(r<2)throw new Error(`convertRadix: wrong to=${r}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let a=0;const i=[],s=Array.from(e);for(s.forEach(e=>{if(n(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)});;){let e=0,n=!0;for(let i=a;i<s.length;i++){const o=s[i],c=t*e+o;if(!Number.isSafeInteger(c)||t*e/t!==e||c-o!==t*e)throw new Error("convertRadix: carry overflow");e=c%r;const l=Math.floor(c/r);if(s[i]=l,!Number.isSafeInteger(l)||l*r+e!==c)throw new Error("convertRadix: carry overflow");n&&(l?n=!1:a=i)}if(i.push(e),n)break}for(let t=0;t<e.length-1&&0===e[t];t++)i.push(0);return i.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=r.stringToBytes=r.str=r.bytesToString=r.hex=r.utf8=r.bech32m=r.bech32=r.base58check=r.createBase58check=r.base58xmr=r.base58xrp=r.base58flickr=r.base58=r.base64urlnopad=r.base64url=r.base64nopad=r.base64=r.base32crockford=r.base32hexnopad=r.base32hex=r.base32nopad=r.base32=r.base16=r.utils=void 0,r.assertNumber=n;const d=(e,t)=>t?d(t,e%t):e,f=(e,t)=>e+(t-d(e,t));function m(e,t,r,a){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(r<=0||r>32)throw new Error(`convertRadix2: wrong to=${r}`);if(f(t,r)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${r} carryBits=${f(t,r)}`);let i=0,s=0;const o=2**r-1,c=[];for(const a of e){if(n(a),a>=2**t)throw new Error(`convertRadix2: invalid data word=${a} from=${t}`);if(i=i<<t|a,s+t>32)throw new Error(`convertRadix2: carry overflow pos=${s} from=${t}`);for(s+=t;s>=r;s-=r)c.push((i>>s-r&o)>>>0);i&=2**s-1}if(i=i<<r-s&o,!a&&s>=t)throw new Error("Excess padding");if(!a&&i)throw new Error(`Non-zero padding: ${i}`);return a&&s>0&&c.push(i>>>0),c}function h(e){return n(e),{encode:t=>{if(!a(t))throw new Error("radix.encode input should be Uint8Array");return u(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(u(t,e,256))}}}function p(e,t=!1){if(n(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(f(8,e)>32||f(e,8)>32)throw new Error("radix2: carry overflow");return{encode:r=>{if(!a(r))throw new Error("radix2.encode input should be Uint8Array");return m(Array.from(r),8,e,!t)},decode:r=>{if(!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(m(r,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function b(e,t){if(n(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(r){if(!a(r))throw new Error("checksum.encode: input should be Uint8Array");const n=t(r).slice(0,e),i=new Uint8Array(r.length+e);return i.set(r),i.set(n,r.length),i},decode(r){if(!a(r))throw new Error("checksum.decode: input should be Uint8Array");const n=r.slice(0,-e),i=t(n).slice(0,e),s=r.slice(-e);for(let t=0;t<e;t++)if(i[t]!==s[t])throw new Error("Invalid checksum");return n}}}r.utils={alphabet:s,chain:i,checksum:b,convertRadix:u,convertRadix2:m,radix:h,radix2:p,join:o,padding:c},r.base16=i(p(4),s("0123456789ABCDEF"),o("")),r.base32=i(p(5),s("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),o("")),r.base32nopad=i(p(5),s("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),o("")),r.base32hex=i(p(5),s("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),o("")),r.base32hexnopad=i(p(5),s("0123456789ABCDEFGHIJKLMNOPQRSTUV"),o("")),r.base32crockford=i(p(5),s("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),o(""),l(e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1"))),r.base64=i(p(6),s("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),o("")),r.base64nopad=i(p(6),s("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),o("")),r.base64url=i(p(6),s("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),o("")),r.base64urlnopad=i(p(6),s("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),o(""));const y=e=>i(h(58),s(e),o(""));r.base58=y("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),r.base58flickr=y("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),r.base58xrp=y("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const v=[0,2,3,5,6,7,9,10,11];r.base58xmr={encode(e){let t="";for(let n=0;n<e.length;n+=8){const a=e.subarray(n,n+8);t+=r.base58.encode(a).padStart(v[a.length],"1")}return t},decode(e){let t=[];for(let n=0;n<e.length;n+=11){const a=e.slice(n,n+11),i=v.indexOf(a.length),s=r.base58.decode(a);for(let e=0;e<s.length-i;e++)if(0!==s[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(s.slice(s.length-i)))}return Uint8Array.from(t)}};r.createBase58check=e=>i(b(4,t=>e(e(t))),r.base58),r.base58check=r.createBase58check;const w=i(s("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),o("")),_=[996825010,642813549,513874426,1027748829,705979059];function j(e){const t=e>>25;let r=(33554431&e)<<5;for(let e=0;e<_.length;e++)1==(t>>e&1)&&(r^=_[e]);return r}function O(e,t,r=1){const n=e.length;let a=1;for(let t=0;t<n;t++){const r=e.charCodeAt(t);if(r<33||r>126)throw new Error(`Invalid prefix (${e})`);a=j(a)^r>>5}a=j(a);for(let t=0;t<n;t++)a=j(a)^31&e.charCodeAt(t);for(let e of t)a=j(a)^e;for(let e=0;e<6;e++)a=j(a);return a^=r,w.encode(m([a%2**30],30,5,!1))}function E(e){const t="bech32"===e?1:734539939,r=p(5),n=r.decode,a=r.encode,i=g(n);function s(e,r,n=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(r instanceof Uint8Array&&(r=Array.from(r)),!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof r);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const a=e.length+7+r.length;if(!1!==n&&a>n)throw new TypeError(`Length ${a} exceeds limit ${n}`);const i=e.toLowerCase(),s=O(i,r,t);return`${i}1${w.encode(r)}${s}`}function o(e,r=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==r&&e.length>r)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${r})`);const n=e.toLowerCase();if(e!==n&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const a=n.lastIndexOf("1");if(0===a||-1===a)throw new Error('Letter "1" must be present between prefix and data only');const i=n.slice(0,a),s=n.slice(a+1);if(s.length<6)throw new Error("Data must be at least 6 characters long");const o=w.decode(s).slice(0,-6),c=O(i,o,t);if(!s.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:i,words:o}}return{encode:s,decode:o,encodeFromBytes:function(e,t){return s(e,a(t))},decodeToBytes:function(e){const{prefix:t,words:r}=o(e,!1);return{prefix:t,words:r,bytes:n(r)}},decodeUnsafe:g(o),fromWords:n,fromWordsUnsafe:i,toWords:a}}r.bech32=E("bech32"),r.bech32m=E("bech32m"),r.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},r.hex=i(p(4),s("0123456789abcdef"),o(""),l(e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()}));const C={utf8:r.utf8,hex:r.hex,base16:r.base16,base32:r.base32,base64:r.base64,base64url:r.base64url,base58:r.base58,base58xmr:r.base58xmr},k="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";r.bytesToString=(e,t)=>{if("string"!=typeof e||!C.hasOwnProperty(e))throw new TypeError(k);if(!a(t))throw new TypeError("bytesToString() expects Uint8Array");return C[e].encode(t)},r.str=r.bytesToString;r.stringToBytes=(e,t)=>{if(!C.hasOwnProperty(e))throw new TypeError(k);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return C[e].decode(t)},r.bytes=r.stringToBytes}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@scure/bip32>@scure/base",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@scure/base/lib/index.js"}],[2074,{"@noble/curves/abstract/modular":2059,"@noble/curves/secp256k1":2062,"@noble/hashes/_assert":2063,"@noble/hashes/hmac":2067,"@noble/hashes/ripemd160":2068,"@noble/hashes/sha256":2069,"@noble/hashes/sha512":2071,"@noble/hashes/utils":2072,"@scure/base":2073},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.HDKey=r.HARDENED_OFFSET=void 0;
/*! scure-bip32 - MIT License (c) 2022 Patricio Palladino, Paul Miller (paulmillr.com) */
const n=e("@noble/hashes/hmac"),a=e("@noble/hashes/ripemd160"),i=e("@noble/hashes/sha256"),s=e("@noble/hashes/sha512"),o=e("@noble/hashes/_assert"),c=e("@noble/hashes/utils"),l=e("@noble/curves/secp256k1"),u=e("@noble/curves/abstract/modular"),d=e("@scure/base"),f=l.secp256k1.ProjectivePoint,m=(0,d.createBase58check)(i.sha256);function h(e){return BigInt(`0x${(0,c.bytesToHex)(e)}`)}const p=(0,c.utf8ToBytes)("Bitcoin seed"),g={private:76066276,public:76067358};r.HARDENED_OFFSET=2147483648;const b=e=>{if(!Number.isSafeInteger(e)||e<0||e>2**32-1)throw new Error(`Invalid number=${e}. Should be from 0 to 2 ** 32 - 1`);const t=new Uint8Array(4);return(0,c.createView)(t).setUint32(0,e,!1),t};class y{get fingerprint(){if(!this.pubHash)throw new Error("No publicKey set!");return e=this.pubHash,(0,c.createView)(e).getUint32(0,!1);var e}get identifier(){return this.pubHash}get pubKeyHash(){return this.pubHash}get privateKey(){return this.privKeyBytes||null}get publicKey(){return this.pubKey||null}get privateExtendedKey(){const e=this.privateKey;if(!e)throw new Error("No private key");return m.encode(this.serialize(this.versions.private,(0,c.concatBytes)(new Uint8Array([0]),e)))}get publicExtendedKey(){if(!this.pubKey)throw new Error("No public key");return m.encode(this.serialize(this.versions.public,this.pubKey))}static fromMasterSeed(e,t=g){if((0,o.bytes)(e),8*e.length<128||8*e.length>512)throw new Error(`HDKey: wrong seed length=${e.length}. Should be between 128 and 512 bits; 256 bits is advised)`);const r=(0,n.hmac)(s.sha512,p,e);return new y({versions:t,chainCode:r.slice(32),privateKey:r.slice(0,32)})}static fromExtendedKey(e,t=g){const r=m.decode(e),n=(0,c.createView)(r),a=n.getUint32(0,!1),i={versions:t,depth:r[4],parentFingerprint:n.getUint32(5,!1),index:n.getUint32(9,!1),chainCode:r.slice(13,45)},s=r.slice(45),o=0===s[0];if(a!==t[o?"private":"public"])throw new Error("Version mismatch");return new y(o?{...i,privateKey:s.slice(1)}:{...i,publicKey:s})}static fromJSON(e){return y.fromExtendedKey(e.xpriv)}constructor(e){if(this.depth=0,this.index=0,this.chainCode=null,this.parentFingerprint=0,!e||"object"!=typeof e)throw new Error("HDKey.constructor must not be called directly");if(this.versions=e.versions||g,this.depth=e.depth||0,this.chainCode=e.chainCode||null,this.index=e.index||0,this.parentFingerprint=e.parentFingerprint||0,!this.depth&&(this.parentFingerprint||this.index))throw new Error("HDKey: zero depth with non-zero index/parent fingerprint");if(e.publicKey&&e.privateKey)throw new Error("HDKey: publicKey and privateKey at same time.");if(e.privateKey){if(!l.secp256k1.utils.isValidPrivateKey(e.privateKey))throw new Error("Invalid private key");this.privKey="bigint"==typeof e.privateKey?e.privateKey:h(e.privateKey),this.privKeyBytes=(t=this.privKey,(0,c.hexToBytes)(t.toString(16).padStart(64,"0"))),this.pubKey=l.secp256k1.getPublicKey(e.privateKey,!0)}else{if(!e.publicKey)throw new Error("HDKey: no public or private key provided");this.pubKey=f.fromHex(e.publicKey).toRawBytes(!0)}var t,r;this.pubHash=(r=this.pubKey,(0,a.ripemd160)((0,i.sha256)(r)))}derive(e){if(!/^[mM]'?/.test(e))throw new Error('Path must start with "m" or "M"');if(/^[mM]'?$/.test(e))return this;const t=e.replace(/^[mM]'?\//,"").split("/");let n=this;for(const e of t){const t=/^(\d+)('?)$/.exec(e),a=t&&t[1];if(!t||3!==t.length||"string"!=typeof a)throw new Error(`Invalid child index: ${e}`);let i=+a;if(!Number.isSafeInteger(i)||i>=r.HARDENED_OFFSET)throw new Error("Invalid index");"'"===t[2]&&(i+=r.HARDENED_OFFSET),n=n.deriveChild(i)}return n}deriveChild(e){if(!this.pubKey||!this.chainCode)throw new Error("No publicKey or chainCode set");let t=b(e);if(e>=r.HARDENED_OFFSET){const e=this.privateKey;if(!e)throw new Error("Could not derive hardened child key");t=(0,c.concatBytes)(new Uint8Array([0]),e,t)}else t=(0,c.concatBytes)(this.pubKey,t);const a=(0,n.hmac)(s.sha512,this.chainCode,t),i=h(a.slice(0,32)),o=a.slice(32);if(!l.secp256k1.utils.isValidPrivateKey(i))throw new Error("Tweak bigger than curve order");const d={versions:this.versions,chainCode:o,depth:this.depth+1,parentFingerprint:this.fingerprint,index:e};try{if(this.privateKey){const e=(0,u.mod)(this.privKey+i,l.secp256k1.CURVE.n);if(!l.secp256k1.utils.isValidPrivateKey(e))throw new Error("The tweak was out of range or the resulted private key is invalid");d.privateKey=e}else{const e=f.fromHex(this.pubKey).add(f.fromPrivateKey(i));if(e.equals(f.ZERO))throw new Error("The tweak was equal to negative P, which made the result key invalid");d.publicKey=e.toRawBytes(!0)}return new y(d)}catch(t){return this.deriveChild(e+1)}}sign(e){if(!this.privateKey)throw new Error("No privateKey set!");return(0,o.bytes)(e,32),l.secp256k1.sign(e,this.privKey).toCompactRawBytes()}verify(e,t){if((0,o.bytes)(e,32),(0,o.bytes)(t,64),!this.publicKey)throw new Error("No publicKey set!");let r;try{r=l.secp256k1.Signature.fromCompact(t)}catch(e){return!1}return l.secp256k1.verify(r,e,this.publicKey)}wipePrivateData(){return this.privKey=undefined,this.privKeyBytes&&(this.privKeyBytes.fill(0),this.privKeyBytes=undefined),this}toJSON(){return{xpriv:this.privateExtendedKey,xpub:this.publicExtendedKey}}serialize(e,t){if(!this.chainCode)throw new Error("No chainCode set");return(0,o.bytes)(t,33),(0,c.concatBytes)(b(e),new Uint8Array([this.depth]),b(this.parentFingerprint),b(this.index),this.chainCode,t)}}r.HDKey=y}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography>@scure/bip32",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@scure/bip32/lib/index.js"}],[2075,{"@scure/bip32":2074},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.HDKey=r.HARDENED_OFFSET=void 0;var n=e("@scure/bip32");Object.defineProperty(r,"HARDENED_OFFSET",{enumerable:!0,get:function(){return n.HARDENED_OFFSET}}),Object.defineProperty(r,"HDKey",{enumerable:!0,get:function(){return n.HDKey}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography",file:"node_modules/@metamask/eth-hd-keyring/node_modules/ethereum-cryptography/hdkey.js"}],[2076,{"./utils.js":2077,"@noble/hashes/sha3":2070},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.keccak512=r.keccak384=r.keccak256=r.keccak224=void 0;const n=e("@noble/hashes/sha3"),a=e("./utils.js");r.keccak224=(0,a.wrapHash)(n.keccak_224),r.keccak256=(()=>{const e=(0,a.wrapHash)(n.keccak_256);return e.create=n.keccak_256.create,e})(),r.keccak384=(0,a.wrapHash)(n.keccak_384),r.keccak512=(0,a.wrapHash)(n.keccak_512)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography",file:"node_modules/@metamask/eth-hd-keyring/node_modules/ethereum-cryptography/keccak.js"}],[2077,{"@noble/hashes/_assert":2063,"@noble/hashes/utils":2072},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.crypto=r.utf8ToBytes=r.createView=r.concatBytes=r.toHex=r.bytesToHex=r.assertBytes=r.assertBool=void 0,r.bytesToUtf8=function(e){if(!(e instanceof Uint8Array))throw new TypeError("bytesToUtf8 expected Uint8Array, got "+typeof e);return(new TextDecoder).decode(e)},r.hexToBytes=function(e){const t=e.startsWith("0x")?e.substring(2):e;return(0,i.hexToBytes)(t)},r.equalsBytes=function(e,t){if(e.length!==t.length)return!1;for(let r=0;r<e.length;r++)if(e[r]!==t[r])return!1;return!0},r.wrapHash=function(e){return t=>(a.default.bytes(t),e(t))};const a=n(e("@noble/hashes/_assert")),i=e("@noble/hashes/utils"),s=a.default.bool;r.assertBool=s;const o=a.default.bytes;r.assertBytes=o;var c=e("@noble/hashes/utils");Object.defineProperty(r,"bytesToHex",{enumerable:!0,get:function(){return c.bytesToHex}}),Object.defineProperty(r,"toHex",{enumerable:!0,get:function(){return c.bytesToHex}}),Object.defineProperty(r,"concatBytes",{enumerable:!0,get:function(){return c.concatBytes}}),Object.defineProperty(r,"createView",{enumerable:!0,get:function(){return c.createView}}),Object.defineProperty(r,"utf8ToBytes",{enumerable:!0,get:function(){return c.utf8ToBytes}}),r.crypto=(()=>{const e="object"==typeof globalThis&&"crypto"in globalThis?globalThis.crypto:undefined,r=void 0!==t&&"function"==typeof t.require&&t.require.bind(t);return{node:r&&!e?r("crypto"):undefined,web:e}})()}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>ethereum-cryptography",file:"node_modules/@metamask/eth-hd-keyring/node_modules/ethereum-cryptography/utils.js"}],[2087,{"./fetch-config-from-req":2089,"./logging-utils":2091,"@metamask/json-rpc-engine":2421,"@metamask/rpc-errors":3029},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createInfuraMiddlewareWithoutRpcService=r.createInfuraMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),a=e("@metamask/rpc-errors"),i=e("./fetch-config-from-req"),s=e("./logging-utils"),o=(0,s.createModuleLogger)(s.projectLogger,"create-infura-middleware"),c=["Gateway timeout","ETIMEDOUT","ECONNRESET","SyntaxError"];function l({network:e="mainnet",maxAttempts:t=5,source:r,projectId:a,headers:i={}}){if(!a||"string"!=typeof a)throw new Error(`Invalid value for 'projectId': "${a}"`);if(!i||"object"!=typeof i)throw new Error(`Invalid value for 'headers': "${i}"`);if(!t)throw new Error(`Invalid value for 'maxAttempts': "${t}" (${typeof t})`);return(0,n.createAsyncMiddleware)(async(n,s)=>{for(let c=1;c<=t;c++)try{o("Attempting request to Infura. network = %o, projectId = %s, headers = %o, req = %o",e,a,i,n),await u(e,a,i,n,s,r);break}catch(e){if(!f(e))throw o("Non-retriable request error encountered. req = %o, res = %o, error = %o",n,s,e),e;if(!(t-c)){o("Retriable request error encountered, but exceeded max attempts. req = %o, res = %o, error = %o",n,s,e);const t=`InfuraProvider - cannot complete request. All retries exhausted.\nOriginal Error:\n${e.toString()}\n\n`;throw new Error(t)}o("Retriable request error encountered. req = %o, res = %o, error = %o",n,s,e),o("Waiting 1 second to try again..."),await m(1e3)}})}async function u(e,t,r,n,s,o){const{fetchUrl:c,fetchParams:l}=(0,i.fetchConfigFromReq)({network:e,projectId:t,extraHeaders:r,req:n,source:o}),u=await fetch(c,l),f=await u.text();if(!u.ok)switch(u.status){case 405:throw a.rpcErrors.methodNotFound();case 429:throw d("Request is being rate limited.");case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",d(e)}();default:throw d(f)}if("eth_getBlockByNumber"===n.method&&"Not Found"===f)return void(s.result=null);const m=JSON.parse(f);s.result=m.result,s.error=m.error}function d(e){return a.rpcErrors.internal(e)}function f(e){const t=e.toString();return c.some(e=>t.includes(e))}async function m(e){return new Promise(t=>{setTimeout(t,e)})}r.createInfuraMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){const{source:r,headers:a={}}=t;return(0,n.createAsyncMiddleware)(async(t,n)=>{const i=r!==undefined&&t.origin!==undefined?Object.assign(Object.assign({},a),{"Infura-Source":`${r}/${t.origin}`}):a,s=await e.request({id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},{headers:i});"error"in s?n.error=s.error:(n.result=s.result,n.error=undefined)})}(e):l(e)},r.createInfuraMiddlewareWithoutRpcService=l}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js"}],[2088,{"./create-infura-middleware":2087,"@metamask/eth-json-rpc-provider":2092,"@metamask/json-rpc-engine":2421},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createProvider=void 0;const n=e("@metamask/eth-json-rpc-provider"),a=e("@metamask/json-rpc-engine"),i=e("./create-infura-middleware");r.createProvider=function(e){const t=new a.JsonRpcEngine;return t.push((0,i.createInfuraMiddleware)(e)),(0,n.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js"}],[2089,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){return{id:e.id,jsonrpc:e.jsonrpc,method:e.method,params:e.params}}Object.defineProperty(r,"__esModule",{value:!0}),r.fetchConfigFromReq=void 0,r.fetchConfigFromReq=function({network:e,projectId:t,extraHeaders:r={},req:a,source:i}){const s=a.origin||"internal",o=Object.assign({},r,{Accept:"application/json","Content-Type":"application/json"});return i&&(o["Infura-Source"]=`${i}/${s}`),{fetchUrl:`https://${e}.infura.io/v3/${t}`,fetchParams:{method:"POST",headers:o,body:JSON.stringify(n(a))}}}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"}],[2090,{"./create-infura-middleware":2087,"./create-provider":2088,"./fetch-config-from-req":2089},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),a(e("./create-infura-middleware"),r),a(e("./fetch-config-from-req"),r),a(e("./create-provider"),r)}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/index.js"}],[2091,{"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("eth-json-rpc-infura")}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js"}],[2092,{"./provider-from-engine.cjs":2093,"./provider-from-middleware.cjs":2094,"./safe-event-emitter-provider.cjs":2095},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.SafeEventEmitterProvider=void 0,a(e("./provider-from-engine.cjs"),r),a(e("./provider-from-middleware.cjs"),r);var i=e("./safe-event-emitter-provider.cjs");Object.defineProperty(r,"SafeEventEmitterProvider",{enumerable:!0,get:function(){return i.SafeEventEmitterProvider}})}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],[2093,{"./safe-event-emitter-provider.cjs":2095},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.providerFromEngine=void 0;const n=e("./safe-event-emitter-provider.cjs");r.providerFromEngine=function(e){return new n.SafeEventEmitterProvider({engine:e})}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs"}],[2094,{"./provider-from-engine.cjs":2093,"@metamask/json-rpc-engine":2421},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.providerFromMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),a=e("./provider-from-engine.cjs");r.providerFromMiddleware=function(e){const t=new n.JsonRpcEngine;return t.push(e),(0,a.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],[2095,{"@metamask/rpc-errors":3029,"@metamask/safe-event-emitter":3031,uuid:6186},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},i=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.SafeEventEmitterProvider=r.convertEip1193RequestToJsonRpcRequest=void 0;const o=e("@metamask/rpc-errors"),c=s(e("@metamask/safe-event-emitter")),l=e("uuid");function u(e){const{id:t=(0,l.v4)(),jsonrpc:r="2.0",method:n,params:a}=e;return a?{id:t,jsonrpc:r,method:n,params:a}:{id:t,jsonrpc:r,method:n}}r.convertEip1193RequestToJsonRpcRequest=u;class d extends c.default{constructor({engine:e}){super(),n.set(this,void 0),this.sendAsync=(e,t)=>{const r=u(e);i(this,n,"f").handle(r,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const r=u(e);i(this,n,"f").handle(r,t)},a(this,n,e,"f")}async request(e){const t=u(e),r=await i(this,n,"f").handle(t);if("result"in r)return r.result;const a=new o.JsonRpcError(r.error.code,r.error.message,r.error.data);throw"stack"in r.error&&(a.stack=r.error.stack),a}}r.SafeEventEmitterProvider=d,n=new WeakMap}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"}],[2096,{"./logging-utils.cjs":2103,"./utils/cache.cjs":2110},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},i=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockCacheMiddleware=void 0;const s=e("./logging-utils.cjs"),o=e("./utils/cache.cjs"),c=(0,s.createModuleLogger)(s.projectLogger,"block-cache"),l=[undefined,null,"<nil>"];class u{constructor(){n.set(this,void 0),a(this,n,{},"f")}getBlockCache(e){const t=Number.parseInt(e,16);let r=i(this,n,"f")[t];if(!r){const e={};i(this,n,"f")[t]=e,r=e}return r}async get(e,t){const r=this.getBlockCache(t),n=(0,o.cacheIdentifierForRequest)(e,!0);return n?r[n]:undefined}async set(e,t,r){if(!this.canCacheResult(e,r))return;const n=(0,o.cacheIdentifierForRequest)(e,!0);if(!n)return;this.getBlockCache(t)[n]=r}canCacheRequest(e){if(!(0,o.canCache)(e.method))return!1;return"pending"!==(0,o.blockTagForRequest)(e)}canCacheResult(e,t){return!l.includes(t)&&!(e.method&&["eth_getTransactionByHash","eth_getTransactionReceipt"].includes(e.method)&&(!t?.blockHash||"0x0000000000000000000000000000000000000000000000000000000000000000"===t.blockHash))}clearBefore(e){const t=Number.parseInt(e,16);Object.keys(i(this,n,"f")).map(Number).filter(e=>e<t).forEach(e=>delete i(this,n,"f")[e])}}n=new WeakMap,r.createBlockCacheMiddleware=function({blockTracker:e}={}){if(!e)throw new Error("createBlockCacheMiddleware - No PollingBlockTracker specified");const t=new u,r={[o.CacheStrategy.Permanent]:t,[o.CacheStrategy.Block]:t,[o.CacheStrategy.Fork]:t,[o.CacheStrategy.Never]:undefined};return async({request:n,next:a,context:i})=>{if(i.get("skipCache"))return a();const s=(0,o.cacheTypeForMethod)(n.method),l=r[s];if(!l)return a();if(!l.canCacheRequest(n))return a();const u=(0,o.blockTagForRequest)(n),d=u&&"string"==typeof u?u:"latest";let f;if(c("blockTag = %o, req = %o",d,n),"earliest"===d)f="0x00";else if("latest"===d){c("Fetching latest block number to determine cache key");const r=await e.getLatestBlock();c("Clearing values stored under block numbers before %o",r),t.clearBefore(r),f=r}else f=d;const m=await l.get(n,f);if(m===undefined){c("No cache stored under block number %o, carrying request forward",f);const e=await a();return c("Populating cache with",e),await l.set(n,f,e),e}return c("Cache hit, reusing cache result stored under block number %o",f),m}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.cjs"}],[2097,{"./utils/cache.cjs":2110},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockRefRewriteMiddleware=void 0;const n=e("./utils/cache.cjs");r.createBlockRefRewriteMiddleware=function({blockTracker:e}={}){if(!e)throw Error('BlockRefRewriteMiddleware - mandatory "blockTracker" option is missing.');return async({request:t,next:r})=>{const a=(0,n.blockTagParamIndex)(t.method);if(a===undefined)return r();if("latest"!==(Array.isArray(t.params)&&t.params[a]?t.params[a]:"latest"))return r();const i=await e.getLatestBlock();if(Array.isArray(t.params)){const e=t.params.slice();return e[a]=i,r({...t,params:e})}return r()}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.cjs"}],[2098,{"./logging-utils.cjs":2103,"./utils/cache.cjs":2110,klona:5142},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockRefMiddleware=void 0;const n=e("klona"),a=e("./logging-utils.cjs"),i=e("./utils/cache.cjs"),s=(0,a.createModuleLogger)(a.projectLogger,"block-ref");r.createBlockRefMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('BlockRefMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('BlockRefMiddleware - mandatory "blockTracker" option is missing.');return async({request:r,next:a})=>{const o=(0,i.blockTagParamIndex)(r.method);if(o===undefined)return a();if("latest"!==(Array.isArray(r.params)?r.params[o]??"latest":"latest"))return s('blockRef is not "latest", carrying request forward'),a();const c=await t.getLatestBlock();s(`blockRef is "latest", setting param ${o} to latest block ${c}`);const l=(0,n.klona)(r);return Array.isArray(l.params)&&(l.params[o]=c),s("Performing another request %o",l),await e.request(l)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.cjs"}],[2099,{"./logging-utils.cjs":2103,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockTrackerInspectorMiddleware=void 0;const n=e("@metamask/utils"),a=e("./logging-utils.cjs"),i=(0,a.createModuleLogger)(a.projectLogger,"block-tracker-inspector"),s=["eth_getTransactionByHash","eth_getTransactionReceipt"];r.createBlockTrackerInspectorMiddleware=function({blockTracker:e}){return async({request:t,next:r})=>{if(!s.includes(t.method))return r();const a=await r(),o=function(e){if(!e||"object"!=typeof e||!(0,n.hasProperty)(e,"blockNumber"))return undefined;return"string"==typeof e.blockNumber?e.blockNumber:undefined}(a);if(o){i("res.result.blockNumber exists, proceeding. res = %o",a);Number.parseInt(o,16)>Number.parseInt(e.getCurrentBlock(),16)&&(i("blockNumber from response is greater than current block number, refreshing current block number"),await e.checkForLatestBlock())}return a}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.cjs"}],[2100,{"@metamask/rpc-errors":3029},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createFetchMiddleware=void 0;const n=e("@metamask/rpc-errors");r.createFetchMiddleware=function({rpcService:e,options:t={}}){return async({request:r,context:a})=>{const i=a.get("origin"),s=t.originHttpHeaderKey!==undefined&&i!==undefined?{[t.originHttpHeaderKey]:i}:{},o=await e.request(r,{headers:s});if("error"in o)throw n.rpcErrors.internal({data:o.error});return o.result}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.cjs"}],[2101,{"./block-cache.cjs":2096,"./block-ref-rewrite.cjs":2097,"./block-ref.cjs":2098,"./block-tracker-inspector.cjs":2099,"./fetch.cjs":2100,"./inflight-cache.cjs":2102,"./methods/wallet-get-granted-execution-permissions.cjs":2104,"./methods/wallet-get-supported-execution-permissions.cjs":2105,"./providerAsMiddleware.cjs":2108,"./retryOnEmpty.cjs":2109,"./wallet.cjs":2117},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.GetSupportedExecutionPermissionsResultStruct=r.SupportedExecutionPermissionConfigStruct=r.GetGrantedExecutionPermissionsResultStruct=r.GrantedExecutionPermissionStruct=r.createFetchMiddleware=void 0,a(e("./block-cache.cjs"),r),a(e("./block-ref-rewrite.cjs"),r),a(e("./block-ref.cjs"),r),a(e("./block-tracker-inspector.cjs"),r);var i=e("./fetch.cjs");Object.defineProperty(r,"createFetchMiddleware",{enumerable:!0,get:function(){return i.createFetchMiddleware}}),a(e("./inflight-cache.cjs"),r);var s=e("./methods/wallet-get-granted-execution-permissions.cjs");Object.defineProperty(r,"GrantedExecutionPermissionStruct",{enumerable:!0,get:function(){return s.GrantedExecutionPermissionStruct}}),Object.defineProperty(r,"GetGrantedExecutionPermissionsResultStruct",{enumerable:!0,get:function(){return s.GetGrantedExecutionPermissionsResultStruct}});var o=e("./methods/wallet-get-supported-execution-permissions.cjs");Object.defineProperty(r,"SupportedExecutionPermissionConfigStruct",{enumerable:!0,get:function(){return o.SupportedExecutionPermissionConfigStruct}}),Object.defineProperty(r,"GetSupportedExecutionPermissionsResultStruct",{enumerable:!0,get:function(){return o.GetSupportedExecutionPermissionsResultStruct}}),a(e("./providerAsMiddleware.cjs"),r),a(e("./retryOnEmpty.cjs"),r),a(e("./wallet.cjs"),r)}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/index.cjs"}],[2102,{"./logging-utils.cjs":2103,"./utils/cache.cjs":2110,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createInflightCacheMiddleware=void 0;const n=e("@metamask/utils"),a=e("./logging-utils.cjs"),i=e("./utils/cache.cjs"),s=(0,a.createModuleLogger)(a.projectLogger,"inflight-cache");function o(e,t){setTimeout(()=>{t.forEach(([t,r])=>{"result"in e?t(e.result):r(e.error)})})}r.createInflightCacheMiddleware=function(){const e={};return async({request:t,context:r,next:a})=>{if(r.get("skipCache"))return a();const c=(0,i.cacheIdentifierForRequest)(t);if(!c)return s("Request is not cacheable, proceeding. req = %o",t),a();let l=e[c];if(l)return s("Running %i handler(s) for request %o",l.length,t),await function(e){const{resolve:t,promise:r,reject:a}=(0,n.createDeferredPromise)();return e.push([e=>t(e),e=>a(e)]),r}(l);l=[],e[c]=l,s("Carrying original request forward %o",t);try{const e=await a();return s("Running %i collected handler(s) for successful request %o",l.length,t),o({result:e},l),e}catch(e){throw s("Running %i collected handler(s) for failed request %o",l.length,t),o({error:e},l),e}finally{delete e[c]}}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.cjs"}],[2103,{"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("eth-json-rpc-middleware")}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs"}],[2104,{"../utils/structs.cjs":2114,"../utils/validation.cjs":2116,"@metamask/rpc-errors":3029,"@metamask/superstruct":3418,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createWalletGetGrantedExecutionPermissionsHandler=r.GetGrantedExecutionPermissionsResultStruct=r.GrantedExecutionPermissionStruct=r.GetGrantedExecutionPermissionsParamsStruct=void 0;const n=e("@metamask/rpc-errors"),a=e("@metamask/superstruct"),i=e("@metamask/utils"),s=e("../utils/structs.cjs"),o=e("../utils/validation.cjs");r.GetGrantedExecutionPermissionsParamsStruct=s.NoParamsStruct;const c=(0,a.object)({factory:i.StrictHexStruct,factoryData:i.StrictHexStruct}),l=(0,a.object)({type:(0,a.string)(),isAdjustmentAllowed:(0,a.boolean)(),data:(0,a.record)((0,a.string)(),(0,a.unknown)())});r.GrantedExecutionPermissionStruct=(0,a.object)({chainId:i.StrictHexStruct,from:i.HexChecksumAddressStruct,to:i.HexChecksumAddressStruct,permission:l,context:i.StrictHexStruct,dependencies:(0,a.array)(c),delegationManager:i.HexChecksumAddressStruct}),r.GetGrantedExecutionPermissionsResultStruct=(0,a.array)(r.GrantedExecutionPermissionStruct),r.createWalletGetGrantedExecutionPermissionsHandler=function({processGetGrantedExecutionPermissions:e}){return async({request:t,context:a})=>{if(!e)throw n.rpcErrors.methodNotSupported("wallet_getGrantedExecutionPermissions - no middleware configured");const{params:i}=t;return(0,o.validateParams)(i,r.GetGrantedExecutionPermissionsParamsStruct),await e(t,a)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-granted-execution-permissions.cjs"}],[2105,{"../utils/structs.cjs":2114,"../utils/validation.cjs":2116,"@metamask/rpc-errors":3029,"@metamask/superstruct":3418,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createWalletGetSupportedExecutionPermissionsHandler=r.GetSupportedExecutionPermissionsResultStruct=r.SupportedExecutionPermissionConfigStruct=r.GetSupportedExecutionPermissionsParamsStruct=void 0;const n=e("@metamask/rpc-errors"),a=e("@metamask/superstruct"),i=e("@metamask/utils"),s=e("../utils/structs.cjs"),o=e("../utils/validation.cjs");r.GetSupportedExecutionPermissionsParamsStruct=s.NoParamsStruct,r.SupportedExecutionPermissionConfigStruct=(0,a.object)({chainIds:(0,a.array)(i.StrictHexStruct),ruleTypes:(0,a.array)((0,a.string)())}),r.GetSupportedExecutionPermissionsResultStruct=(0,a.record)((0,a.string)(),r.SupportedExecutionPermissionConfigStruct),r.createWalletGetSupportedExecutionPermissionsHandler=function({processGetSupportedExecutionPermissions:e}){return async({request:t,context:a})=>{if(!e)throw n.rpcErrors.methodNotSupported("wallet_getSupportedExecutionPermissions - no middleware configured");const{params:i}=t;return(0,o.validateParams)(i,r.GetSupportedExecutionPermissionsParamsStruct),await e(t,a)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-supported-execution-permissions.cjs"}],[2106,{"../utils/validation.cjs":2116,"@metamask/rpc-errors":3029,"@metamask/superstruct":3418,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createWalletRequestExecutionPermissionsHandler=r.RequestExecutionPermissionsStruct=void 0;const n=e("@metamask/rpc-errors"),a=e("@metamask/superstruct"),i=e("@metamask/utils"),s=e("../utils/validation.cjs"),o=(0,a.object)({type:(0,a.string)(),isAdjustmentAllowed:(0,a.boolean)(),data:(0,a.record)((0,a.string)(),(0,a.unknown)())}),c=(0,a.object)({type:(0,a.string)(),data:(0,a.record)((0,a.string)(),(0,a.unknown)())}),l=(0,a.object)({chainId:i.StrictHexStruct,from:(0,a.optional)(i.HexChecksumAddressStruct),to:i.HexChecksumAddressStruct,permission:o,rules:(0,a.optional)((0,a.union)([(0,a.array)(c),(0,a.literal)(null)]))});r.RequestExecutionPermissionsStruct=(0,a.array)(l),r.createWalletRequestExecutionPermissionsHandler=function({processRequestExecutionPermissions:e}){return async({request:t,context:a})=>{if(!e)throw n.rpcErrors.methodNotSupported("wallet_requestExecutionPermissions - no middleware configured");const{params:i}=t;return(0,s.validateParams)(i,r.RequestExecutionPermissionsStruct),await e(i,t,a)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-request-execution-permissions.cjs"}],[2107,{"../utils/validation.cjs":2116,"@metamask/rpc-errors":3029,"@metamask/superstruct":3418,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createWalletRevokeExecutionPermissionHandler=r.RevokeExecutionPermissionRequestParamsStruct=r.RevokeExecutionPermissionResultStruct=void 0;const n=e("@metamask/rpc-errors"),a=e("@metamask/superstruct"),i=e("@metamask/utils"),s=e("../utils/validation.cjs");r.RevokeExecutionPermissionResultStruct=(0,a.object)({}),r.RevokeExecutionPermissionRequestParamsStruct=(0,a.object)({permissionContext:i.StrictHexStruct}),r.createWalletRevokeExecutionPermissionHandler=function({processRevokeExecutionPermission:e}){return async({request:t,context:a})=>{if(!e)throw n.rpcErrors.methodNotSupported("wallet_revokeExecutionPermission - no middleware configured");const{params:i}=t;return(0,s.validateParams)(i,r.RevokeExecutionPermissionRequestParamsStruct),await e(i,t,a)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-revoke-execution-permission.cjs"}],[2108,{"@metamask/json-rpc-engine":2421},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.providerAsMiddlewareV2=r.providerAsMiddleware=void 0;const n=e("@metamask/json-rpc-engine");r.providerAsMiddleware=function(e){return(0,n.createAsyncMiddleware)(async(t,r)=>{r.result=await e.request(t)})},r.providerAsMiddlewareV2=function(e){return async({request:t})=>e.request(t)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.cjs"}],[2109,{"./logging-utils.cjs":2103,"./utils/cache.cjs":2110,"./utils/error.cjs":2112,"./utils/timeout.cjs":2115,klona:5142},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createRetryOnEmptyMiddleware=void 0;const n=e("klona"),a=e("./logging-utils.cjs"),i=e("./utils/cache.cjs"),s=e("./utils/error.cjs"),o=e("./utils/timeout.cjs"),c=(0,a.createModuleLogger)(a.projectLogger,"retry-on-empty"),l=[null,"<nil>"];r.createRetryOnEmptyMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('RetryOnEmptyMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('RetryOnEmptyMiddleware - mandatory "blockTracker" option is missing.');return async({request:r,next:a})=>{const u=(0,i.blockTagParamIndex)(r.method);if(u===undefined)return a();let d=Array.isArray(r.params)&&r.params[u]?r.params[u]:undefined;if(d??(d="latest"),["latest","pending"].includes(d))return a();const f=Number.parseInt(d.slice(2),16);if(Number.isNaN(f))return a();const m=await t.getLatestBlock(),h=Number.parseInt(m.slice(2),16);if(f>h)return c("Requested block number %o is higher than latest block number %o, falling through to original request",f,h),a();c("Requested block number %o is not higher than latest block number %o, trying request until non-empty response is received",f,h);const p=(0,n.klona)(r),g=await async function(e,t){for(let r=0;r<e;r++)try{return await t()}catch(e){if((0,s.isExecutionRevertedError)(e))throw e;c("(call %i) Request failed, waiting 1s to retry again...",r+1),await(0,o.timeout)(1e3)}throw c("Retries exhausted"),new Error("RetryOnEmptyMiddleware - retries exhausted")}(10,async()=>{c("Performing request %o",p);const t=await e.request(p);c("Result is %o",t);if(l.includes(t))throw new Error(`RetryOnEmptyMiddleware - empty result "${JSON.stringify(t)}" for request "${JSON.stringify(p)}"`);return t});return c("Copying result %o",g),g}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.cjs"}],[2110,{"safe-stable-stringify":6007},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.cacheTypeForMethod=r.blockTagParamIndex=r.blockTagForRequest=r.canCache=r.cacheIdentifierForRequest=r.CacheStrategy=void 0;const n=(0,e("safe-stable-stringify").configure)({bigint:!1,circularValue:Error});var a;function i(e){return o(e)!==a.Never}function s(e){switch(e){case"eth_getStorageAt":return 2;case"eth_getBalance":case"eth_getCode":case"eth_getTransactionCount":case"eth_call":return 1;case"eth_getBlockByNumber":return 0;default:return undefined}}function o(e){switch(e){case"web3_clientVersion":case"web3_sha3":case"eth_protocolVersion":case"eth_getBlockTransactionCountByHash":case"eth_getUncleCountByBlockHash":case"eth_getCode":case"eth_getBlockByHash":case"eth_getTransactionByHash":case"eth_getTransactionByBlockHashAndIndex":case"eth_getTransactionReceipt":case"eth_getUncleByBlockHashAndIndex":case"eth_getCompilers":case"eth_compileLLL":case"eth_compileSolidity":case"eth_compileSerpent":case"shh_version":case"test_permaCache":return a.Permanent;case"eth_getBlockByNumber":case"eth_getBlockTransactionCountByNumber":case"eth_getUncleCountByBlockNumber":case"eth_getTransactionByBlockNumberAndIndex":case"eth_getUncleByBlockNumberAndIndex":case"test_forkCache":return a.Fork;case"eth_gasPrice":case"eth_blockNumber":case"eth_getBalance":case"eth_getStorageAt":case"eth_getTransactionCount":case"eth_call":case"eth_estimateGas":case"eth_getFilterLogs":case"eth_getLogs":case"test_blockCache":return a.Block;default:return a.Never}}!function(e){e.Block="block",e.Fork="fork",e.Never="never",e.Permanent="perma"}(a||(r.CacheStrategy=a={})),r.cacheIdentifierForRequest=function(e,t){const r=t?function(e){if(!e.params)return[];const t=s(e.method);if(t===undefined||!Array.isArray(e.params)||t>=e.params.length)return e.params;if("eth_getBlockByNumber"===e.method)return e.params.slice(1);return e.params.slice(0,t)}(e):e.params??[];return i(e.method)?`${e.method}:${n(r)}`:null},r.canCache=i,r.blockTagForRequest=function(e){if(!e.params)return undefined;const t=s(e.method);return t===undefined||!Array.isArray(e.params)||t>=e.params.length?undefined:e.params[t]},r.blockTagParamIndex=s,r.cacheTypeForMethod=o}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs"}],[2111,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.stripArrayTypeIfPresent=void 0;r.stripArrayTypeIfPresent=e=>e?.match(/\S\[\d*\]$/u)?e.replace(/\[\d*\]$/gu,"").trim():e}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.cjs"}],[2112,{"@metamask/rpc-errors":3029,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isExecutionRevertedError=void 0;const n=e("@metamask/rpc-errors"),a=e("@metamask/utils");r.isExecutionRevertedError=function(e){return(0,a.isJsonRpcError)(e)&&e.code===n.errorCodes.rpc.invalidInput&&"execution reverted"===e.message}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.cjs"}],[2113,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){return"string"!=typeof e?e:JSON.parse(e)}function a(e){return e.startsWith("0X")?`0x${e.slice(2)}`:e}Object.defineProperty(r,"__esModule",{value:!0}),r.parseTypedMessage=r.normalizeTypedMessage=void 0,r.normalizeTypedMessage=function(e){let t;try{t=n(e)}catch{return e}const{verifyingContract:r}=t.domain??{};return r?JSON.stringify({...t,domain:{...t.domain,verifyingContract:a(r)}}):e},r.parseTypedMessage=n}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.cjs"}],[2114,{"@metamask/superstruct":3418},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.NoParamsStruct=r.EmptyArrayStruct=void 0;const n=e("@metamask/superstruct");r.EmptyArrayStruct=(0,n.define)("EmptyArray",e=>!(!Array.isArray(e)||0!==e.length)||"Expected an empty array"),r.NoParamsStruct=(0,n.optional)((0,n.union)([(0,n.object)({}),r.EmptyArrayStruct]))}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/structs.cjs"}],[2115,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.timeout=void 0,r.timeout=async function(e){return new Promise(t=>setTimeout(t,e))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.cjs"}],[2116,{"@metamask/rpc-errors":3029,"@metamask/superstruct":3418},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.resemblesAddress=r.validateParams=r.validateAndNormalizeKeyholder=void 0;const n=e("@metamask/rpc-errors"),a=e("@metamask/superstruct");function i(e){return 42===e.length}r.validateAndNormalizeKeyholder=async function(e,t,{getAccounts:r}){if("string"==typeof e&&e.length>0&&i(e)){const a=(await r(t.assertGet("origin"))).map(e=>e.toLowerCase()),i=e.toLowerCase();if(a.includes(i))return i;throw n.providerErrors.unauthorized()}throw n.rpcErrors.invalidParams({message:"Invalid parameters: must provide an Ethereum address."})},r.validateParams=function(e,t){const[r]=(0,a.validate)(e,t);if(r)throw n.rpcErrors.invalidParams(function(e,t){return`${t}\n\n${e.failures().map(e=>`${e.path.join(" > ")}${e.path.length?" - ":""}${e.message}`).join("\n")}`}(r,"Invalid params"))},r.resemblesAddress=i}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs"}],[2117,{"./methods/wallet-get-granted-execution-permissions.cjs":2104,"./methods/wallet-get-supported-execution-permissions.cjs":2105,"./methods/wallet-request-execution-permissions.cjs":2106,"./methods/wallet-revoke-execution-permission.cjs":2107,"./utils/common.cjs":2111,"./utils/normalize.cjs":2113,"./utils/validation.cjs":2116,"@metamask/eth-sig-util":2231,"@metamask/json-rpc-engine/v2":2431,"@metamask/rpc-errors":3029,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return a(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.createWalletMiddleware=void 0;const s=i(e("@metamask/eth-sig-util")),o=e("@metamask/json-rpc-engine/v2"),c=e("@metamask/rpc-errors"),l=e("@metamask/utils"),u=e("./methods/wallet-get-granted-execution-permissions.cjs"),d=e("./methods/wallet-get-supported-execution-permissions.cjs"),f=e("./methods/wallet-request-execution-permissions.cjs"),m=e("./methods/wallet-revoke-execution-permission.cjs"),h=e("./utils/common.cjs"),p=e("./utils/normalize.cjs"),g=e("./utils/validation.cjs");function b(e){const{primaryType:t,types:r}=(0,p.parseTypedMessage)(e);if(!r)throw c.rpcErrors.invalidInput();if(!r[(0,h.stripArrayTypeIfPresent)(t)])throw c.rpcErrors.invalidInput()}function y(e){const{domain:{verifyingContract:t}={}}=(0,p.parseTypedMessage)(e);if(t&&"cosmos"!==t&&!(0,l.isValidHexAddress)(t))throw c.rpcErrors.invalidInput()}r.createWalletMiddleware=function({getAccounts:e,processDecryptMessage:t,processEncryptionPublicKey:r,processPersonalMessage:n,processTransaction:a,processSignTransaction:i,processTypedMessage:l,processTypedMessageV3:h,processTypedMessageV4:v,processRequestExecutionPermissions:w,processRevokeExecutionPermission:_,processGetGrantedExecutionPermissions:j,processGetSupportedExecutionPermissions:O}){if(!e)throw new Error("opts.getAccounts is required");return(0,o.createScaffoldMiddleware)({eth_accounts:async function({context:t}){return await e(t.assertGet("origin"))},eth_coinbase:async function({context:t}){return(await e(t.assertGet("origin")))[0]||null},eth_sendTransaction:async function({request:e,context:t}){if(!a)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params[0],n={...r,from:await E(r?.from||"",t)};return await a(n,e,t)},eth_signTransaction:async function({request:e,context:t}){if(!i)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params[0],n={...r,from:await E(r?.from||"",t)};return await i(n,e,t)},eth_signTypedData:async function({request:e,context:t}){if(!l)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=r[0],a=await E(r[1],t),i={...r[2]||{},from:a,data:n,signatureMethod:"eth_signTypedData",version:"V1"};return await l(i,e,t,"V1")},eth_signTypedData_v3:async function({request:e,context:t}){if(!h)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=await E(r[0],t),a=(0,p.normalizeTypedMessage)(r[1]);b(a),y(a);const i={data:a,from:n,version:"V3",signatureMethod:"eth_signTypedData_v3"};return await h(i,e,t,"V3")},eth_signTypedData_v4:async function({request:e,context:t}){if(!v)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=await E(r[0],t),a=(0,p.normalizeTypedMessage)(r[1]);b(a),y(a);const i={data:a,from:n,version:"V4",signatureMethod:"eth_signTypedData_v4"};return await v(i,e,t,"V4")},personal_sign:async function({request:e,context:t}){if(!n)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,a=r[0],i=r[1],s=r[2]||{};let o,l;(0,g.resemblesAddress)(a)&&!(0,g.resemblesAddress)(i)?(o=a,l=i):(l=a,o=i);o=await E(o,t);const u={...s,from:o,data:l,signatureMethod:"personal_sign"};return await n(u,e,t)},eth_getEncryptionPublicKey:async function({request:e,context:t}){if(!r)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const n=e.params,a=await E(n[0],t);return await r(a,{id:e.id,origin:t.assertGet("origin"),securityAlertResponse:t.get("securityAlertResponse")})},eth_decrypt:async function({request:e,context:r}){if(!t)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const n=e.params,a=n[0],i=await E(n[1],r),s={...n[2]||{},from:i,data:a};return await t(s,{id:e.id,origin:r.assertGet("origin"),securityAlertResponse:r.get("securityAlertResponse")})},personal_ecRecover:async function({request:e}){if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const t=e.params,r=t[0],n=t[1];return s.recoverPersonalSignature({data:r,signature:n})},wallet_requestExecutionPermissions:(0,f.createWalletRequestExecutionPermissionsHandler)({processRequestExecutionPermissions:w}),wallet_revokeExecutionPermission:(0,m.createWalletRevokeExecutionPermissionHandler)({processRevokeExecutionPermission:_}),wallet_getGrantedExecutionPermissions:(0,u.createWalletGetGrantedExecutionPermissionsHandler)({processGetGrantedExecutionPermissions:j}),wallet_getSupportedExecutionPermissions:(0,d.createWalletGetSupportedExecutionPermissionsHandler)({processGetSupportedExecutionPermissions:O})});async function E(t,r){return(0,g.validateAndNormalizeKeyholder)(t,r,{getAccounts:e})}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.cjs"}],[2118,{"./internal-provider.cjs":2119,"./provider-from-middleware.cjs":2120},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.SafeEventEmitterProvider=r.InternalProvider=void 0;const i=e("./internal-provider.cjs");Object.defineProperty(r,"InternalProvider",{enumerable:!0,get:function(){return i.InternalProvider}}),a(e("./provider-from-middleware.cjs"),r);const s=i.InternalProvider;r.SafeEventEmitterProvider=s}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],[2119,{"@metamask/json-rpc-engine":2421,"@metamask/json-rpc-engine/v2":2431,nanoid:5490},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a,i,s=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},o=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.convertEip1193RequestToJsonRpcRequest=r.InternalProvider=void 0;const c=e("@metamask/json-rpc-engine"),l=e("@metamask/json-rpc-engine/v2"),u=e("nanoid");function d(e){const{id:t=(0,u.nanoid)(),jsonrpc:r="2.0",method:n,params:a}=e;return a?{id:t,jsonrpc:r,method:n,params:a}:{id:t,jsonrpc:r,method:n}}r.InternalProvider=class{constructor({engine:e}){n.set(this,void 0),this.sendAsync=(e,t)=>{const r=d(e);o(this,i,"f").call(this,r,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const r=d(e);o(this,i,"f").call(this,r,t)},a.set(this,async(e,t)=>{const{id:r,jsonrpc:a}=e;return{id:r,jsonrpc:a,result:await o(this,n,"f").handle(e,t)}}),i.set(this,(e,t)=>{o(this,a,"f").call(this,e).then(e=>t(null,e)).catch(e=>{t(e)})}),s(this,n,"push"in e?l.JsonRpcEngineV2.create({middleware:[(0,c.asV2Middleware)(e)]}):e,"f")}async request(e,t){const r=d(e);return(await o(this,a,"f").call(this,r,t)).result}},n=new WeakMap,a=new WeakMap,i=new WeakMap,r.convertEip1193RequestToJsonRpcRequest=d}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/internal-provider.cjs"}],[2120,{"./internal-provider.cjs":2119,"@metamask/json-rpc-engine":2421,"@metamask/json-rpc-engine/v2":2431},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.providerFromMiddlewareV2=r.providerFromMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),a=e("@metamask/json-rpc-engine/v2"),i=e("./internal-provider.cjs");function s(e){return new i.InternalProvider({engine:a.JsonRpcEngineV2.create({middleware:[e]})})}r.providerFromMiddleware=function(e){return s((0,n.asV2Middleware)(e))},r.providerFromMiddlewareV2=s}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],[2130,{"./qr-keyring.cjs":2134,"@ethereumjs/rlp":685,"@ethereumjs/tx":698,"@ethereumjs/util":719,"@keystonehq/bc-ur-registry-eth":2137,"@metamask/utils":3557,buffer:4526,hdkey:5049,uuid:2213},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n,a,i,s,o,c,l=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},u=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},d=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.Device=r.DeviceMode=r.SUPPORTED_UR_TYPE=void 0;const f=e("@ethereumjs/rlp"),m=e("@ethereumjs/tx"),h=e("@ethereumjs/util"),p=e("@keystonehq/bc-ur-registry-eth"),g=e("@metamask/utils"),b=d(e("hdkey")),y=e("uuid"),v=e("./qr-keyring.cjs");var w;r.SUPPORTED_UR_TYPE={CRYPTO_HDKEY:"crypto-hdkey",CRYPTO_ACCOUNT:"crypto-account",ETH_SIGNATURE:"eth-signature"},function(e){e.HD="hd",e.ACCOUNT="account"}(w||(r.DeviceMode=w={}));function _(e){return e instanceof p.CryptoAccount?e.getMasterFingerprint()?.toString("hex"):e.getOrigin()?.getSourceFingerprint()?.toString("hex")}r.Device=class{constructor({requestScan:e,source:t}){n.add(this),a.set(this,void 0),i.set(this,void 0),l(this,a,e,"f"),l(this,i,"string"==typeof t||"cbor"in t?u(this,n,"m",s).call(this,t):t,"f")}addressFromIndex(e){if(u(this,i,"f").keyringMode===w.ACCOUNT){const t=Object.keys(u(this,i,"f").paths)[e];if(!t)throw new Error(`Address not found for index ${e}`);return(0,g.add0x)(t)}const r=`m/${u(this,i,"f").childrenPath.replace("*",e.toString())}`,n=b.default.fromExtendedKey(u(this,i,"f").xpub).derive(r),a=t.from((0,h.publicToAddress)(n.publicKey,!0)).toString("hex"),s=(0,g.getChecksumAddress)((0,g.add0x)(a));return u(this,i,"f").indexes[s]=e,s}pathFromAddress(e){const t=(0,g.getChecksumAddress)((0,g.add0x)(e));if(u(this,i,"f").keyringMode===w.ACCOUNT){const e=u(this,i,"f").paths[t];if(e===undefined)throw new Error(`Unknown address ${t}`);return e}let r=u(this,i,"f").indexes[t];if(r===undefined){for(let e=0;e<1e3;e++){if(this.addressFromIndex(e)===t){r=e;break}}if(r===undefined)throw new Error(`Unknown address ${t}`)}return`${u(this,i,"f").hdPath}/${u(this,i,"f").childrenPath.replace("*",r.toString()).replace(/\*/gu,"0")}`}getAddressesPage(e,t=5){const r=e*t,n=r+t,a=[];for(let e=r;e<n;e++){const t=this.addressFromIndex(e);a.push({address:t,index:e})}return a}getDeviceDetails(){return u(this,i,"f")}async signTransaction(e,r){const a=r.type===m.TransactionType.Legacy?p.DataType.transaction:p.DataType.typedTransaction,s=r.getMessageToSign(),c=t.from(Array.isArray(s)?f.RLP.encode(s):s),l=(0,y.v4)(),d=p.EthSignRequest.constructETHRequest(c,a,this.pathFromAddress(e),u(this,i,"f").xfp,l,Number(r.common.chainId())).toUR(),{r:h,s:g,v:b}=await u(this,n,"m",o).call(this,{requestId:l,payload:{type:d.type,cbor:d.cbor.toString("hex")},requestTitle:"Scan with your hardware wallet",requestDescription:'After your device has signed this message, click on "Scan" to receive the signature'});return m.TransactionFactory.fromTxData({...r.toJSON(),r:h,s:g,v:b},{common:r.common})}async signTypedData(e,r){const a=(0,y.v4)(),s=p.EthSignRequest.constructETHRequest(t.from(JSON.stringify(r),"utf8"),p.DataType.typedData,this.pathFromAddress(e),u(this,i,"f").xfp,a,undefined,e).toUR(),{r:c,s:l,v:d}=await u(this,n,"m",o).call(this,{requestId:a,payload:{type:s.type,cbor:s.cbor.toString("hex")}});return(0,g.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(l),Uint8Array.from(d)]).toString("hex"))}async signPersonalMessage(e,r){const a=(0,y.v4)(),s=p.EthSignRequest.constructETHRequest(t.from((0,g.remove0x)(r),"hex"),p.DataType.personalMessage,this.pathFromAddress(e),u(this,i,"f").xfp,a,undefined,e).toUR(),{r:c,s:l,v:d}=await u(this,n,"m",o).call(this,{requestId:a,payload:{type:s.type,cbor:s.cbor.toString("hex")}});return(0,g.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(l),Uint8Array.from(d)]).toString("hex"))}},a=new WeakMap,i=new WeakMap,n=new WeakSet,s=function(e){const r=u(this,n,"m",c).call(this,e),a=_(r);if(r instanceof p.CryptoAccount){const{name:e,xfp:n,paths:a,keyringAccount:i}=function(e){const r=e.getOutputDescriptors();if(!r||0===r.length)throw new Error("No output descriptors found in CryptoAccount");let n="",a="";return{paths:r.reduce((e,r)=>{const i=r.getHDKey();if(i){const r=`M/${i.getOrigin().getPath()}`;e[(0,g.getChecksumAddress)((0,g.add0x)(t.from((0,h.publicToAddress)(i.getKey(),!0)).toString("hex")))]=r,n=i.getName(),a=i.getNote()}return e},{}),name:n,keyringAccount:a,xfp:_(e)}}(r);return{keyringMode:w.ACCOUNT,keyringAccount:i,name:e,xfp:n,paths:a,indexes:{}}}const{getBip32Key:i,getOrigin:s,getChildren:o,getName:l,getNote:d}=r;return{keyringMode:w.HD,keyringAccount:d(),name:l(),xfp:a,hdPath:`m/${s().getPath()}`,childrenPath:o()?.getPath()||"0/*",xpub:i(),indexes:{}}},o=async function(e){const r=await u(this,a,"f").call(this,{type:v.QrScanRequestType.SIGN,request:e}),n=p.ETHSignature.fromCBOR(t.from(r.cbor,"hex")),i=n.getSignature(),s=n.getRequestId();if(!s)throw new Error("Signature request ID is missing.");if(e.requestId!==(0,y.stringify)(s))throw new Error(`Signature request ID mismatch. Expected: ${e.requestId}, received: ${s.toString("hex")}`);return{r:i.subarray(0,32),s:i.subarray(32,64),v:i.subarray(64)}},c=function(e){const n="string"==typeof e?p.URRegistryDecoder.decode(e):{type:e.type,cbor:t.from(e.cbor,"hex")},{type:a,cbor:i}=n;switch(a){case r.SUPPORTED_UR_TYPE.CRYPTO_HDKEY:return p.CryptoHDKey.fromCBOR(i);case r.SUPPORTED_UR_TYPE.CRYPTO_ACCOUNT:return p.CryptoAccount.fromCBOR(i);default:throw new Error("Unsupported UR type")}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/device.cjs"}],[2131,{"./qr-keyring-deferred-promise-bridge.cjs":2132,"./qr-keyring-scanner-bridge.cjs":2133,"./qr-keyring.cjs":2134},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.QrScanRequestType=r.QR_KEYRING_TYPE=r.QrKeyring=r.QrKeyringDeferredPromiseBridge=r.QrKeyringScannerBridge=void 0;var n=e("./qr-keyring-scanner-bridge.cjs");Object.defineProperty(r,"QrKeyringScannerBridge",{enumerable:!0,get:function(){return n.QrKeyringScannerBridge}});var a=e("./qr-keyring-deferred-promise-bridge.cjs");Object.defineProperty(r,"QrKeyringDeferredPromiseBridge",{enumerable:!0,get:function(){return a.QrKeyringDeferredPromiseBridge}});var i=e("./qr-keyring.cjs");Object.defineProperty(r,"QrKeyring",{enumerable:!0,get:function(){return i.QrKeyring}}),Object.defineProperty(r,"QR_KEYRING_TYPE",{enumerable:!0,get:function(){return i.QR_KEYRING_TYPE}}),Object.defineProperty(r,"QrScanRequestType",{enumerable:!0,get:function(){return i.QrScanRequestType}})}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/index.cjs"}],[2132,{"@metamask/utils":3557,"async-mutex":4348},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a,i,s,o,c=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},l=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.QrKeyringDeferredPromiseBridge=void 0;const u=e("@metamask/utils"),d=e("async-mutex");r.QrKeyringDeferredPromiseBridge=class{constructor({onScanRequested:e,onScanResolved:t,onScanRejected:r}={}){n.set(this,new d.Mutex),a.set(this,void 0),i.set(this,void 0),s.set(this,void 0),o.set(this,void 0),c(this,a,e,"f"),c(this,i,t,"f"),c(this,s,r,"f")}async requestScan(e){return l(this,n,"f").runExclusive(async()=>{const t=(0,u.createDeferredPromise)();return c(this,o,t,"f"),l(this,a,"f")?.call(this,e),t.promise})}resolvePendingScan(e){if(!l(this,o,"f"))throw new Error("No pending scan to resolve.");l(this,o,"f").resolve(e),c(this,o,null,"f"),l(this,i,"f")?.call(this,e)}rejectPendingScan(e){if(!l(this,o,"f"))throw new Error("No pending scan to reject.");l(this,o,"f").reject(e),c(this,o,null,"f"),l(this,s,"f")?.call(this,e)}},n=new WeakMap,a=new WeakMap,i=new WeakMap,s=new WeakMap,o=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs"}],[2133,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r},i=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.QrKeyringScannerBridge=void 0;r.QrKeyringScannerBridge=class{constructor({requestScan:e}){n.set(this,void 0),a(this,n,e,"f")}async requestScan(e){return i(this,n,"f").call(this,e)}},n=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs"}],[2134,{"./device.cjs":2130,"@metamask/utils":3557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,a,i,s,o,c,l=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},u=this&&this.__classPrivateFieldSet||function(e,t,r,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,r):a?a.value=r:t.set(e,r),r};Object.defineProperty(r,"__esModule",{value:!0}),r.QrKeyring=r.getDefaultSerializedQrKeyringState=r.QrScanRequestType=r.QR_KEYRING_TYPE=void 0;const d=e("@metamask/utils"),f=e("./device.cjs");var m;r.QR_KEYRING_TYPE="QR Hardware Wallet Device",function(e){e.PAIR="pair",e.SIGN="sign"}(m||(r.QrScanRequestType=m={}));function h(e){return(0,d.getChecksumAddress)((0,d.add0x)(e))}r.getDefaultSerializedQrKeyringState=()=>({initialized:!1,accounts:[]});class p{constructor(e){n.add(this),this.type=r.QR_KEYRING_TYPE,a.set(this,void 0),i.set(this,[]),s.set(this,void 0),o.set(this,0),this.bridge=e.bridge,e?.ur&&this.pairDevice(e.ur)}async serialize(){const e=l(this,a,"f")?l(this,a,"f").getDeviceDetails():undefined;return e&&[f.DeviceMode.HD,f.DeviceMode.ACCOUNT].includes(e.keyringMode)?{...e,initialized:!0,accounts:l(this,i,"f").slice()}:(0,r.getDefaultSerializedQrKeyringState)()}async deserialize(e){if(!e.initialized)return u(this,i,[],"f"),void u(this,a,undefined,"f");u(this,a,new f.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f"),u(this,i,(e.accounts??[]).map(h),"f")}async addAccounts(e){if(!l(this,a,"f"))throw new Error("No device paired.");const t=[];for(let r=0;r<e;r++){const e=l(this,s,"f")??l(this,i,"f").length+r,n=l(this,a,"f").addressFromIndex(e);this.setAccountToUnlock(e+1),l(this,i,"f").includes(n)||(l(this,i,"f").push(n),t.push(n))}return t}async getAccounts(){return l(this,i,"f").slice()}removeAccount(e){const t=h(e);u(this,i,l(this,i,"f").filter(e=>e!==t),"f")}pairDevice(e){u(this,a,new f.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f")}setAccountToUnlock(e){u(this,s,e,"f")}getName(){if(!l(this,a,"f"))return r.QR_KEYRING_TYPE;return l(this,a,"f").getDeviceDetails().name}async getFirstPage(){return u(this,o,0,"f"),this.getCurrentPage()}async getNextPage(){return u(this,o,l(this,o,"f")+1,"f"),this.getCurrentPage()}async getPreviousPage(){return l(this,o,"f")>0?u(this,o,l(this,o,"f")-1,"f"):u(this,o,0,"f"),this.getCurrentPage()}async getCurrentPage(){return l(this,a,"f")||await l(this,n,"m",c).call(this),(0,d.assert)(l(this,a,"f"),"A device is expected to be paired before fetching accounts."),l(this,a,"f").getAddressesPage(l(this,o,"f"))}async forgetDevice(){u(this,a,undefined,"f"),u(this,i,[],"f"),u(this,s,undefined,"f"),u(this,o,0,"f")}async signTransaction(e,t){if(!l(this,a,"f"))throw new Error("No device paired.");return l(this,a,"f").signTransaction(e,t)}async signTypedData(e,t){if(!l(this,a,"f"))throw new Error("No device paired.");return l(this,a,"f").signTypedData(e,t)}async signPersonalMessage(e,t){if(!l(this,a,"f"))throw new Error("No device paired.");return l(this,a,"f").signPersonalMessage(e,t)}}r.QrKeyring=p,a=new WeakMap,i=new WeakMap,s=new WeakMap,o=new WeakMap,n=new WeakSet,c=async function(){this.pairDevi