LavaPack.loadBundle([[2634,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports={openrpc:"1.2.4",info:{title:"MetaMask MultiChain API",version:"1.0.0",description:"This provides the specs for the MultiChain API Layer for the MetaMask API"},methods:[{name:"wallet_notify",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"notification",description:"an object containing a JSON-RPC notification with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}]},{name:"wallet_invokeMethod",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"request",description:"an object containing a JSON-RPC request with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}],result:{name:"wallet_invokeMethodResult",schema:!0},examples:[{name:"wallet_invokeMethodExample",params:[{name:"scope",value:"eip155:1"},{name:"request",value:{method:"eth_getBalance",params:[]}}],result:{name:"wallet_invokeMethodResult",value:"0x1"}}]},{name:"wallet_revokeSession",description:"The `wallet_revokeSession` method revokes the entire active session.",params:[],result:{name:"wallet_revokeSessionResult",schema:{type:"boolean"}},examples:[{name:"wallet_revokeSessionExample",params:[],result:{name:"wallet_revokeSessionExampleResult",value:!0}}],errors:[{$ref:"#/components/errors/UnknownError"}]},{name:"wallet_sessionChanged",paramStructure:"by-name",description:"This notification is published by the wallet to notify the callers of updates to a shared session's authorization scopes. The event payload contains the new `sessionScopes`.",params:[{name:"sessionScopes",schema:{$ref:"#/components/schemas/SessionScopes"}}],examples:[{name:"wallet_sessionChangedExample",description:"Example of a wallet_sessionChanged notification.",params:[{name:"sessionScopes",value:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}]}]},{name:"wallet_getSession",description:"The `wallet_getSession` method returns an active session.",params:[],result:{name:"wallet_getSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"}}}},examples:[{name:"wallet_getSessionExample",description:"Example of a getSession request.",params:[],result:{name:"wallet_getSessionResultExample",value:{sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}}]},{name:"wallet_createSession",paramStructure:"by-name",params:[{name:"requiredScopes",description:"Scopes that the wallet must support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"optionalScopes",description:"Scopes that the wallet may support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"sessionProperties",description:"Properties that the wallet may use to determine if the session is valid.",schema:{type:"object"}}],result:{name:"wallet_createSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"},sessionProperties:{type:"object"}}}},examples:[{name:"wallet_createSessionEthExample",description:"Example of a createSession request.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{methods:["wallet_addEthereumChain"],notifications:[]}}}],result:{name:"wallet_createSessionResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionEthUnsupportedMethodsExample",description:"Example of a createSession request with unsupported eip155 methods.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["not_supported"],notifications:[]},wallet:{methods:[],notifications:[]},"wallet:eip155":{methods:[],notifications:[]}}}],result:{name:"wallet_createSessionEthUnsupportedMethodsResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionUnsupportedScopesExample",description:"Example of a createSession request with unsupported scopes.",params:[{name:"optionalScopes",value:{foobar:{methods:["eth_getBalance"],notifications:["eth_subscription"]},"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}],result:{name:"wallet_createSessionUnsupportedScopesResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}}}],errors:[{$ref:"#/components/errors/UnknownError"},{code:5100,message:"Requested networks are not supported"},{code:5101,message:"Requested methods are not supported"},{code:5102,message:"Requested notifications are not supported"},{code:5300,message:"Invalid scopedProperties requested"},{code:5301,message:"scopedProperties can only be outside of sessionScopes"},{code:5302,message:"Invalid sessionProperties requested"}]}],components:{errors:{UnknownError:{code:5e3,message:"Unknown error with request"}},schemas:{SessionScopes:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}},ScopeString:{type:"string",pattern:"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?"},Scope:{type:"object",title:"Scope",description:"Scope for a multi-chain connection",additionalProperties:!0,required:["notifications","methods"],properties:{scopes:{type:"array",items:{$ref:"#/components/schemas/ScopeString"}},methods:{description:"Methods that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},notifications:{description:"Notifications that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},rpcEndpoints:{description:"JSON-RPC endpoints for this namespace.",type:"array",items:{type:"string",format:"uri"}},rpcDocuments:{type:"array",description:"OpenRPC documents that define RPC methods in which to anchor the methods authorized in a CAIP-25 interaction.",items:{type:"string",format:"uri"}}}}}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json"}],[2635,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[2636,{"./build/multichain-openrpc.json":2634,"./build/openrpc.json":2635},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.MultiChainOpenRPCDocument=a.MetaMaskOpenRPCDocument=void 0;const n=s(e("./build/openrpc.json"));a.MetaMaskOpenRPCDocument=n.default;const r=s(e("./build/multichain-openrpc.json"));a.MultiChainOpenRPCDocument=r.default,a.default=n.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],[264,{"../../../shared/constants/onboarding":6206,"../../../shared/lib/wallet-funds-obtained-metric":6315,"@metamask/notification-services-controller/notification-services":2731,loglevel:5255},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.WalletFundsObtainedMonitor=void 0;var s,n=e("@metamask/notification-services-controller/notification-services"),r=(s=e("loglevel"))&&s.__esModule?s:{default:s},i=e("../../../shared/lib/wallet-funds-obtained-metric"),o=e("../../../shared/constants/onboarding");function c(e,t,a){l(e,t),t.set(e,a)}function l(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function u(e,t){return e.get(m(e,t))}function d(e,t,a){return e.set(m(e,t),a),a}function m(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}var p=new WeakMap,h=new WeakMap,f=new WeakMap,b=new WeakSet;function g(){try{const e=u(p,this).call("TokenBalancesController:getState"),t=u(p,this).call("MultichainBalancesController:getState");return(0,i.hasNonZeroTokenBalance)(e.tokenBalances)||(0,i.hasNonZeroMultichainBalance)(t.balances)}catch(e){return r.default.error("Error checking for existing funds: ",e),!1}}function y(){return e=>{const t=e.filter(e=>e.type===n.TRIGGER_TYPES.ERC20_RECEIVED||e.type===n.TRIGGER_TYPES.ETH_RECEIVED);if(t.length<1)return;const a=t.at(-1);if(!a)return;const{payload:{chain_id:s}}=a,r=a.type===n.TRIGGER_TYPES.ERC20_RECEIVED?a.payload.data.token.usd:a.payload.data.amount.usd;s&&r&&(u(p,this).call("MetaMetricsController:trackEvent",(0,i.getWalletFundsObtainedEventProperties)({chainId:s,amountUsd:r})),u(p,this).call("AppStateController:setCanTrackWalletFundsObtained",!1),u(f,this)&&(u(p,this).unsubscribe("NotificationServicesController:notificationsListUpdated",u(f,this)),d(f,this,null)))}}a.WalletFundsObtainedMonitor=class{constructor({messenger:e}){!function(e,t){l(e,t),t.add(e)}(this,b),c(this,p,void 0),c(this,h,!1),c(this,f,null),d(p,this,e)}setupMonitoring(){if(u(h,this))return;const e=u(p,this).call("OnboardingController:getState"),{firstTimeFlowType:t}=e;if(t!==o.FirstTimeFlowType.create&&t!==o.FirstTimeFlowType.socialCreate)return void u(p,this).call("AppStateController:setCanTrackWalletFundsObtained",!1);u(p,this).call("NotificationServicesController:getState").isNotificationServicesEnabled?m(b,this,g).call(this)?u(p,this).call("AppStateController:setCanTrackWalletFundsObtained",!1):(d(f,this,m(b,this,y).call(this)),u(p,this).subscribe("NotificationServicesController:notificationsListUpdated",u(f,this)),d(h,this,!0)):u(p,this).call("AppStateController:setCanTrackWalletFundsObtained",!1)}}}}},{package:"$root$",file:"app/scripts/lib/WalletFundsObtainedMonitor.ts"}],[2644,{"@metamask/base-controller":1506,"@metamask/keyring-api":2486,"@metamask/keyring-snap-client":2507,"@metamask/snaps-utils":2675},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,u,d,m,p=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.MultichainTransactionsController=a.getDefaultMultichainTransactionsControllerState=void 0;const h=e("@metamask/base-controller"),f=e("@metamask/keyring-api"),b=e("@metamask/keyring-snap-client"),g=e("@metamask/snaps-utils");function y(){return{nonEvmTransactions:{}}}a.getDefaultMultichainTransactionsControllerState=y;const w={nonEvmTransactions:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0}};class v extends h.BaseController{constructor({messenger:e,state:t}){super({messenger:e,name:"MultichainTransactionsController",metadata:w,state:{nonEvmTransactions:{},...t}}),s.add(this);for(const e of p(this,s,"m",r).call(this))this.updateTransactionsForAccount(e.id).catch(t=>{console.error(`Failed to fetch initial transactions for account ${e.id}:`,t)});this.messenger.subscribe("AccountsController:accountAdded",e=>p(this,s,"m",c).call(this,e)),this.messenger.subscribe("AccountsController:accountRemoved",e=>p(this,s,"m",l).call(this,e)),this.messenger.subscribe("AccountsController:accountTransactionsUpdated",e=>p(this,s,"m",d).call(this,e))}async updateTransactionsForAccount(e){const{isUnlocked:t}=this.messenger.call("KeyringController:getState");if(t)try{const t=p(this,s,"m",r).call(this).find(t=>t.id===e);if(t?.metadata.snap){const e=await p(this,s,"m",i).call(this,t.id,t.metadata.snap.id,{limit:10}),a={};e.data.forEach(e=>{const{chain:t}=e;a[t]||(a[t]=[]),a[t].push(e)});const n=Object.entries(a).map(([t,a])=>({chain:t,entry:{transactions:a,next:e.next,lastUpdated:Date.now()}}));this.update(e=>{e.nonEvmTransactions[t.id]||(e.nonEvmTransactions[t.id]={}),n.forEach(({chain:a,entry:s})=>{e.nonEvmTransactions[t.id][a]=s})})}}catch(t){console.error(`Failed to fetch transactions for account ${e}:`,t)}}}a.MultichainTransactionsController=v,s=new WeakSet,n=function(){return this.messenger.call("AccountsController:listMultichainAccounts")},r=function(){return p(this,s,"m",n).call(this).filter(e=>p(this,s,"m",o).call(this,e))},i=async function(e,t,a){return await p(this,s,"m",m).call(this,t).listAccountTransactions(e,a)},o=function(e){return!(0,f.isEvmAccountType)(e.type)&&e.metadata.snap!==undefined},c=async function(e){p(this,s,"m",o).call(this,e)&&await this.updateTransactionsForAccount(e.id)},l=async function(e){e in this.state.nonEvmTransactions&&this.update(t=>{delete t.nonEvmTransactions[e]})},u=function(e){e.status===f.TransactionStatus.Confirmed&&this.messenger.publish("MultichainTransactionsController:transactionConfirmed",e),e.status===f.TransactionStatus.Submitted&&this.messenger.publish("MultichainTransactionsController:transactionSubmitted",e)},d=function(e){const t={},a=[];e?.transactions&&(Object.entries(e.transactions).forEach(([e,s])=>{t[e]={},s.forEach(s=>{const{chain:n}=s;t[e][n]||(t[e][n]=[]),t[e][n].push(s),a.push(s)}),Object.entries(t[e]).forEach(([a,s])=>{const n=this.state.nonEvmTransactions[e]?.[a]?.transactions??[],r=new Map;n.forEach(e=>{r.set(e.id,e)}),s.forEach(e=>{r.set(e.id,e)}),t[e][a]=Array.from(r.values()).sort((e,t)=>(t.timestamp??0)-(e.timestamp??0))})}),this.update(e=>{Object.entries(t).forEach(([t,a])=>{e.nonEvmTransactions[t]||(e.nonEvmTransactions[t]={}),Object.entries(a).forEach(([a,s])=>{e.nonEvmTransactions[t][a]={transactions:s,next:null,lastUpdated:Date.now()}})})}),a.forEach(e=>{p(this,s,"m",u).call(this,e)}))},m=function(e){return new b.KeyringClient({send:async t=>await this.messenger.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:g.HandlerType.OnKeyringRequest,request:t})})}}}},{package:"@metamask/multichain-transactions-controller",file:"node_modules/@metamask/multichain-transactions-controller/dist/MultichainTransactionsController.cjs"}],[2645,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n;Object.defineProperty(a,"__esModule",{value:!0}),a.MultichainNativeAsset=a.MultichainNetwork=void 0,function(e){e.Bitcoin="bip122:000000000019d6689c085ae165831e93",e.BitcoinTestnet="bip122:000000000933ea01ad0ee984209779ba",e.Solana="solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp",e.SolanaDevnet="solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1",e.SolanaTestnet="solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z"}(s||(a.MultichainNetwork=s={})),function(e){e.Bitcoin="bip122:000000000019d6689c085ae165831e93/slip44:0",e.BitcoinTestnet="bip122:000000000933ea01ad0ee984209779ba/slip44:0",e.Solana="solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp/slip44:501",e.SolanaDevnet="solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1/slip44:501",e.SolanaTestnet="solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z/slip44:501"}(n||(a.MultichainNativeAsset=n={}))}}},{package:"@metamask/multichain-transactions-controller",file:"node_modules/@metamask/multichain-transactions-controller/dist/constants.cjs"}],[2646,{"./MultichainTransactionsController.cjs":2644,"./constants.cjs":2645},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.MultichainNativeAsset=a.MultichainNetwork=a.MultichainTransactionsController=void 0;var s=e("./MultichainTransactionsController.cjs");Object.defineProperty(a,"MultichainTransactionsController",{enumerable:!0,get:function(){return s.MultichainTransactionsController}});var n=e("./constants.cjs");Object.defineProperty(a,"MultichainNetwork",{enumerable:!0,get:function(){return n.MultichainNetwork}}),Object.defineProperty(a,"MultichainNativeAsset",{enumerable:!0,get:function(){return n.MultichainNativeAsset}})}}},{package:"@metamask/multichain-transactions-controller",file:"node_modules/@metamask/multichain-transactions-controller/dist/index.cjs"}],[2647,{"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.snapOwnsAccount=a.createChainIdList=a.createAccountList=void 0;const s=e("@metamask/utils");a.createAccountList=function(e,t){return t.map(t=>`${t}:${e}`)},a.createChainIdList=function(e,t){return t&&0!==t.length?e.reduce((e,a)=>{if("eip155:0"===a){const a=t.filter(e=>{const{namespace:t}=(0,s.parseCaipChainId)(e);return t===s.KnownCaipNamespace.Eip155});e.push(...a)}else t.includes(a)&&e.push(a);return e},[]):e},a.snapOwnsAccount=function(e,t){var a;return(null===(a=t.metadata.snap)||void 0===a?void 0:a.id)===e}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/account.cjs"}],[2648,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isEqual=void 0,a.isEqual=function(e,t){return e.length===t.length&&e.every((e,a)=>e===t[a])}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/array.cjs"}],[2649,{"./base64.cjs":2650,"./constants.cjs":2654,"@metamask/snaps-sdk":3215,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.validateAuxiliaryFiles=a.encodeAuxiliaryFile=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/utils"),r=e("./base64.cjs"),i=e("./constants.cjs");a.encodeAuxiliaryFile=async function(e,t){if(t===s.AuxiliaryFileEncoding.Base64)return e;const a=await(0,r.decodeBase64)(e);return t===s.AuxiliaryFileEncoding.Utf8?(0,n.bytesToString)(a):(0,n.bytesToHex)(a)},a.validateAuxiliaryFiles=function(e){for(const t of e)(0,n.assert)(t.size<i.MAX_FILE_SIZE,"Static files required by the Snap must be smaller than 64 MB.")}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/auxiliary-files.cjs"}],[265,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}Object.defineProperty(a,"__esModule",{value:!0}),a.WeakRefObjectMap=void 0;class n{constructor(){s(this,"map",void 0),this.map=new Map}set(e,t){const a={};for(const e in t){if(!Object.prototype.hasOwnProperty.call(t,e))continue;const s=t[e];if("object"!=typeof s||null===s)throw new Error(`Property ${String(e)} is not an object and cannot be weakly referenced.`);a[e]=new WeakRef(s)}return this.map.set(e,a),this}get(e){const t=this.map.get(e);if(!t)return undefined;const a={};for(const s in t){if(!Object.prototype.hasOwnProperty.call(t,s))continue;const n=t[s].deref();if(n===undefined)return this.map.delete(e),undefined;a[s]=n}return a}has(e){return this.get(e)!==undefined}delete(e){return this.get(e)!==undefined&&this.map.delete(e)}clear(){this.map.clear()}get size(){return this.map.size}entries(){const e=[];return this.map.forEach((t,a)=>{const s=this.get(a);s!==undefined&&e.push([a,s])}),e.values()}keys(){return this.map.keys()}values(){const e=[];return this.map.forEach((t,a)=>{const s=this.get(a);s!==undefined&&e.push(s)}),e.values()}[Symbol.iterator](){return this.entries()}get[Symbol.toStringTag](){return"WeakRefObjectMap"}forEach(e,t){this.map.forEach((a,s)=>{const n=this.get(s);n!==undefined&&(t?e.call(t,n,s,this):e(n,s,this))})}}a.WeakRefObjectMap=n}}},{package:"$root$",file:"app/scripts/lib/WeakRefObjectMap.ts"}],[2650,{"./bytes.cjs":2651,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.decodeBase64=a.encodeBase64=void 0;const s=e("@metamask/utils"),n=e("./bytes.cjs");a.encodeBase64=async function(e){const t=(0,n.getBytes)(e),a="undefined"!=typeof navigator&&"ReactNative"===navigator.product;return"FileReader"in globalThis&&!a?await new Promise((e,a)=>{const s=Object.assign(new FileReader,{onload:()=>e(s.result.replace("data:application/octet-stream;base64,","")),onerror:()=>a(s.error)});s.readAsDataURL(new File([t],"",{type:"application/octet-stream"}))}):(0,s.bytesToBase64)(t)},a.decodeBase64=async function(e){const t=await fetch(`data:application/octet-stream;base64,${e}`);return new Uint8Array(await t.arrayBuffer())}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/base64.cjs"}],[2651,{"./virtual-file/VirtualFile.cjs":2694,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getBytes=void 0;const s=e("@metamask/utils"),n=e("./virtual-file/VirtualFile.cjs");a.getBytes=function(e){const t=e instanceof n.VirtualFile?e.value:e;return"string"==typeof t?(0,s.stringToBytes)(t):t}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/bytes.cjs"}],[2652,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;Object.defineProperty(a,"__esModule",{value:!0}),a.SnapCaveatType=void 0,function(e){e.PermittedDerivationPaths="permittedDerivationPaths",e.PermittedCoinTypes="permittedCoinTypes",e.SnapCronjob="snapCronjob",e.TransactionOrigin="transactionOrigin",e.SignatureOrigin="signatureOrigin",e.RpcOrigin="rpcOrigin",e.KeyringOrigin="keyringOrigin",e.SnapIds="snapIds",e.ChainIds="chainIds",e.LookupMatchers="lookupMatchers",e.MaxRequestTime="maxRequestTime",e.ProtocolSnapScopes="protocolSnapScopes"}(s||(a.SnapCaveatType=s={}))}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/caveats.cjs"}],[2653,{"./bytes.cjs":2651,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.checksumFiles=a.checksum=void 0;const s=e("@metamask/utils"),n=e("./bytes.cjs");async function r(e){return await(0,s.sha256)((0,n.getBytes)(e))}a.checksum=r,a.checksumFiles=async function(e){const t=await Promise.all([...e].sort((e,t)=>((0,s.assert)(e.path!==t.path,"Tried to sort files with non-unique paths."),e.path<t.path?-1:1)).map(async e=>r(e)));return r((0,s.concatBytes)(t))}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/checksum.cjs"}],[2654,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.MAX_FILE_SIZE=void 0,a.MAX_FILE_SIZE=64e6}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/constants.cjs"}],[2655,{"./time.cjs":2688,"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365,"@metamask/utils":3504,"cron-parser":4578},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isCronjobSpecificationArray=a.CronjobSpecificationArrayStruct=a.isCronjobSpecification=a.CronjobSpecificationStruct=a.CronExpressionStruct=a.CronjobRpcRequestStruct=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct"),r=e("@metamask/utils"),i=e("cron-parser"),o=e("./time.cjs");a.CronjobRpcRequestStruct=(0,n.object)({jsonrpc:(0,n.optional)(r.JsonRpcVersionStruct),id:(0,n.optional)(r.JsonRpcIdStruct),method:(0,n.string)(),params:(0,n.optional)(r.JsonRpcParamsStruct)}),a.CronExpressionStruct=(0,n.refine)((0,n.string)(),"cronjob expression",e=>{try{return(0,i.parseExpression)(e),!0}catch{return`Expected a cronjob expression, but received: "${e}"`}});const c=(0,n.object)({expression:a.CronExpressionStruct,request:a.CronjobRpcRequestStruct}),l=(0,n.object)({duration:o.ISO8601DurationStruct,request:a.CronjobRpcRequestStruct});a.CronjobSpecificationStruct=(0,s.selectiveUnion)(e=>(0,r.isObject)(e)&&(0,r.hasProperty)(e,"duration")?l:c),a.isCronjobSpecification=function(e){try{return(0,n.create)(e,a.CronjobSpecificationStruct),!0}catch{return!1}},a.CronjobSpecificationArrayStruct=(0,n.array)(a.CronjobSpecificationStruct),a.isCronjobSpecificationArray=function(e){try{return(0,n.create)(e,a.CronjobSpecificationArrayStruct),!0}catch{return!1}}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/cronjob.cjs"}],[2656,{"@metamask/superstruct":3365},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.currency=void 0;const s=e("@metamask/superstruct");a.currency=function(e){const t=e.toLowerCase();return(0,s.coerce)((0,s.literal)(t),(0,s.literal)(e.toUpperCase()),e=>(0,s.create)(e.toLowerCase(),(0,s.literal)(t)))}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/currency.cjs"}],[2657,{rfdc:5718},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.deepClone=void 0;const n=s(e("rfdc"));a.deepClone=(0,n.default)({proto:!1,circles:!1})}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/deep-clone.cjs"}],[2658,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.DEFAULT_ENDOWMENTS=void 0,a.DEFAULT_ENDOWMENTS=Object.freeze(["atob","btoa","BigInt","console","crypto","Date","Math","setTimeout","clearTimeout","SubtleCrypto","TextDecoder","TextEncoder","URL","URLSearchParams","setInterval","clearInterval","Int8Array","Uint8Array","Uint8ClampedArray","Int16Array","Uint16Array","Int32Array","isSecureContext","Intl","Uint32Array","Float32Array","Float64Array","BigInt64Array","BigUint64Array","DataView","ArrayBuffer","AbortController","AbortSignal"])}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/default-endowments.cjs"}],[2659,{"./array.cjs":2648,"@metamask/slip44":3016},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.getSlip44ProtocolName=a.getSnapDerivationPathName=a.SNAPS_DERIVATION_PATHS=void 0;const n=s(e("@metamask/slip44")),r=e("./array.cjs");function i(e){var t;return"1"===String(e)?"Test Networks":(null===(t=n.default[e])||void 0===t?void 0:t.name)??null}a.SNAPS_DERIVATION_PATHS=[{path:["m","44'","0'"],curve:"ed25519",name:"Test BIP-32 Path (ed25519)"},{path:["m","44'","1'"],curve:"secp256k1",name:"Testnet"},{path:["m","44'","0'"],curve:"secp256k1",name:"Bitcoin Legacy"},{path:["m","49'","0'"],curve:"secp256k1",name:"Bitcoin Nested SegWit"},{path:["m","49'","1'"],curve:"secp256k1",name:"Bitcoin Testnet Nested SegWit"},{path:["m","84'","0'"],curve:"secp256k1",name:"Bitcoin Native SegWit"},{path:["m","84'","1'"],curve:"secp256k1",name:"Bitcoin Testnet Native SegWit"},{path:["m","86'","0'"],curve:"secp256k1",name:"Bitcoin Taproot"},{path:["m","86'","1'"],curve:"secp256k1",name:"Bitcoin Testnet Taproot"},{path:["m","44'","501'"],curve:"ed25519",name:"Solana"},{path:["m","44'","501'","0'","0'"],curve:"ed25519",name:"Solana"},{path:["m","44'","2'"],curve:"secp256k1",name:"Litecoin"},{path:["m","44'","3'"],curve:"secp256k1",name:"Dogecoin"},{path:["m","44'","60'"],curve:"secp256k1",name:"Ethereum"},{path:["m","44'","118'"],curve:"secp256k1",name:"Atom"},{path:["m","44'","145'"],curve:"secp256k1",name:"Bitcoin Cash"},{path:["m","44'","637'"],curve:"ed25519",name:"Aptos"},{path:["m","44'","714'"],curve:"secp256k1",name:"Binance (BNB)"},{path:["m","44'","784'"],curve:"ed25519",name:"Sui"},{path:["m","44'","931'"],curve:"secp256k1",name:"THORChain (RUNE)"},{path:["m","44'","330'"],curve:"secp256k1",name:"Terra (LUNA)"},{path:["m","44'","459'"],curve:"secp256k1",name:"Kava"},{path:["m","44'","529'"],curve:"secp256k1",name:"Secret Network"},{path:["m","44'","397'","0'"],curve:"ed25519",name:"NEAR Protocol"},{path:["m","44'","1'","0'"],curve:"ed25519",name:"Testnet"},{path:["m","44'","472'"],curve:"ed25519",name:"Arweave"},{path:["m","44'","12586'"],curve:"secp256k1",name:"Mina"},{path:["m","44'","242'"],curve:"ed25519",name:"Nimiq"},{path:["m","44'","1729'","0'","0'"],curve:"ed25519",name:"Tezos"},{path:["m","1789'","0'"],curve:"ed25519",name:"Vega"},{path:["m","1852'","1815'"],curve:"ed25519Bip32",name:"Cardano"},{path:["m","44'","508'","0'","0'","0'"],curve:"ed25519",name:"MultiversX"},{path:["m","44'","709'"],curve:"secp256k1",name:"Avail"},{path:["m","44'","626'"],curve:"ed25519",name:"Kadena"},{path:["m","44'","632'"],curve:"ed25519",name:"Massa"},{path:["m","44'","4218'"],curve:"ed25519",name:"IOTA"}],a.getSnapDerivationPathName=function(e,t){const s=a.SNAPS_DERIVATION_PATHS.find(a=>a.curve===t&&(0,r.isEqual)(a.path,e));if(s)return s.name;if("secp256k1"===t&&"m"===e[0]&&"44'"===e[1]&&e[2].endsWith("'")){return i(e[2].slice(0,-1))??null}return null},a.getSlip44ProtocolName=i}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/derivation-paths.cjs"}],[266,{"../../../../shared/constants/app":6184,"@metamask/controller-utils":1625,"@metamask/rpc-errors":2976,"@metamask/snaps-rpc-methods":3159,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.rejectAllApprovals=function({approvalController:e,deleteInterface:t}){const a=e.state.pendingApprovals,s=Object.values(a);for(const a of s)l({approvalController:e,approvalRequest:a,deleteInterface:t})},a.rejectOriginApprovals=function({approvalController:e,deleteInterface:t,origin:a}){const s=e.state.pendingApprovals,n=Object.values(s).filter(e=>e.origin===a);for(const a of n)l({approvalController:e,approvalRequest:a,deleteInterface:t})};var s=e("@metamask/controller-utils"),n=e("@metamask/snaps-rpc-methods"),r=e("@metamask/rpc-errors"),i=e("@metamask/utils"),o=e("../../../../shared/constants/app");const c=(0,i.createProjectLogger)("approval-utils");function l({approvalController:e,approvalRequest:t,deleteInterface:a}){var i;const{id:l,type:u,origin:d}=t,m=null===(i=t.requestData)||void 0===i?void 0:i.id;switch(u){case s.ApprovalType.SnapDialogAlert:case s.ApprovalType.SnapDialogPrompt:case n.DIALOG_APPROVAL_TYPES.default:c("Rejecting snap dialog",{id:l,interfaceId:m,origin:d,type:u}),e.accept(l,null),null==a||a(m);break;case s.ApprovalType.SnapDialogConfirmation:c("Rejecting snap confirmation",{id:l,interfaceId:m,origin:d,type:u}),e.accept(l,!1),null==a||a(m);break;case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect:c("Rejecting snap account confirmation",{id:l,origin:d,type:u}),e.accept(l,!1);break;default:c("Rejecting pending approval",{id:l,origin:d,type:u}),e.reject(l,r.providerErrors.userRejectedRequest({data:{cause:"rejectAllApprovals"}}))}}}}},{package:"$root$",file:"app/scripts/lib/approval/utils.ts"}],[2660,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.STATE_ENCRYPTION_MAGIC_VALUE=a.SIP_6_MAGIC_VALUE=void 0,a.SIP_6_MAGIC_VALUE="1399742832'",a.STATE_ENCRYPTION_MAGIC_VALUE="572232532'"}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/entropy.cjs"}],[2661,{"@metamask/rpc-errors":2976,"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function n(e,t){return e.get(i(e,t))}function r(e,t,a){return e.set(i(e,t),a),a}function i(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.TrackableErrorStruct=a.unwrapError=a.isWrappedSnapError=a.isSerializedSnapError=a.isSnapError=a.WrappedSnapError=a.SNAP_ERROR_WRAPPER_MESSAGE=a.SNAP_ERROR_WRAPPER_CODE=void 0;const o=e("@metamask/rpc-errors"),c=e("@metamask/snaps-sdk"),l=e("@metamask/superstruct"),u=e("@metamask/utils");a.SNAP_ERROR_WRAPPER_CODE=-31001,a.SNAP_ERROR_WRAPPER_MESSAGE="Wrapped Snap Error";var d=new WeakMap,m=new WeakMap,p=new WeakMap;class h extends Error{constructor(e){const t=(0,c.getErrorMessage)(e);super(t),s(this,d,void 0),s(this,m,void 0),s(this,p,void 0),r(d,this,e),r(m,this,t),r(p,this,(0,c.getErrorStack)(e)??undefined)}get name(){return"WrappedSnapError"}get message(){return n(m,this)}get stack(){return n(p,this)}toJSON(){const e=f(n(d,this))?n(d,this).serialize():(0,o.serializeCause)(n(d,this));return{code:a.SNAP_ERROR_WRAPPER_CODE,message:a.SNAP_ERROR_WRAPPER_MESSAGE,data:{cause:e}}}serialize(){return this.toJSON()}}function f(e){if((0,u.isObject)(e)&&"serialize"in e&&"function"==typeof e.serialize){const t=e.serialize();return(0,u.isJsonRpcError)(t)&&b(t)}return!1}function b(e){return e.code===c.SNAP_ERROR_CODE&&e.message===c.SNAP_ERROR_MESSAGE}function g(e){return(0,u.isJsonRpcError)(e)&&e.code===a.SNAP_ERROR_WRAPPER_CODE&&e.message===a.SNAP_ERROR_WRAPPER_MESSAGE}function y(e,t,a,s){const n=new o.JsonRpcError(e,t,s);return n.stack=a??undefined,n}a.WrappedSnapError=h,a.isSnapError=f,a.isSerializedSnapError=b,a.isWrappedSnapError=g,a.unwrapError=function(e){if(g(e)){if((0,u.isJsonRpcError)(e.data.cause)){if(b(e.data.cause)){const{code:t,message:a,stack:s,data:n}=e.data.cause.data.cause;return[y(t,a,s,n),!0]}if((0,u.isObject)(e.data.cause.data)&&(0,u.isObject)(e.data.cause.data.cause)&&e.data.cause.message===e.data.cause.data.cause.message){const t=e.data.cause.data.cause,{code:a,message:s}=e.data.cause;return[y(a,s,(0,c.getErrorStack)(t)),!1]}const{code:t,message:a,stack:s,data:n}=e.data.cause;return[y(t,a,s,n),!1]}return[y(o.errorCodes.rpc.internal,(0,c.getErrorMessage)(e.data.cause),(0,c.getErrorStack)(e.data.cause)),!1]}if((0,u.isJsonRpcError)(e)){const{code:t,message:a,stack:s,data:n}=e;return[y(t,a,s,n),!1]}return[y(o.errorCodes.rpc.internal,(0,c.getErrorMessage)(e),(0,c.getErrorStack)(e)),!1]},a.TrackableErrorStruct=(0,l.object)({name:(0,l.string)(),message:(0,l.string)(),stack:(0,l.nullable)((0,l.string)()),cause:(0,l.nullable)((0,l.lazy)(()=>a.TrackableErrorStruct))})}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/errors.cjs"}],[2662,{"../time.cjs":2688,"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnAssetHistoricalPriceResponseStruct=a.AssetHistoricalPriceStruct=a.HistoricalPriceStruct=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct"),r=e("../time.cjs");a.HistoricalPriceStruct=(0,s.nonEmptyRecord)((0,n.union)([(0,n.literal)("all"),r.ISO8601DurationStruct]),(0,n.array)((0,n.tuple)([(0,n.number)(),(0,n.string)()]))),a.AssetHistoricalPriceStruct=(0,n.nullable)((0,n.object)({intervals:a.HistoricalPriceStruct,updateTime:(0,n.number)(),expirationTime:(0,n.optional)((0,n.number)())})),a.OnAssetHistoricalPriceResponseStruct=(0,n.object)({historicalPrice:a.AssetHistoricalPriceStruct})}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/asset-historical-price.cjs"}],[2663,{"@metamask/superstruct":3365,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnAssetsConversionResponseStruct=a.AssetConversionStruct=void 0;const s=e("@metamask/superstruct"),n=e("@metamask/utils");a.AssetConversionStruct=(0,s.object)({rate:(0,s.string)(),conversionTime:(0,s.number)(),expirationTime:(0,s.optional)((0,s.number)())}),a.OnAssetsConversionResponseStruct=(0,s.object)({conversionRates:(0,s.record)(n.CaipAssetTypeStruct,(0,s.record)(n.CaipAssetTypeStruct,(0,s.nullable)(a.AssetConversionStruct)))})}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/assets-conversion.cjs"}],[2664,{"../time.cjs":2688,"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnAssetsMarketDataResponseStruct=a.AssetMarketDataStruct=a.NonFungibleAssetMarketDataStruct=a.AssetValueStruct=a.FungibleAssetMarketDataStruct=a.PricePercentChangeStruct=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct"),r=e("@metamask/utils"),i=e("../time.cjs");a.PricePercentChangeStruct=(0,s.nonEmptyRecord)((0,n.union)([(0,n.literal)("all"),i.ISO8601DurationStruct]),(0,n.number)()),a.FungibleAssetMarketDataStruct=(0,n.object)({fungible:(0,n.literal)(!0),marketCap:(0,n.optional)((0,n.string)()),totalVolume:(0,n.optional)((0,n.string)()),circulatingSupply:(0,n.optional)((0,n.string)()),allTimeHigh:(0,n.optional)((0,n.string)()),allTimeLow:(0,n.optional)((0,n.string)()),pricePercentChange:(0,n.optional)(a.PricePercentChangeStruct)}),a.AssetValueStruct=(0,n.object)({asset:r.CaipAssetTypeOrIdStruct,amount:(0,n.string)()}),a.NonFungibleAssetMarketDataStruct=(0,n.object)({fungible:(0,n.literal)(!1),lastSale:(0,n.optional)(a.AssetValueStruct),topBid:(0,n.optional)(a.AssetValueStruct),floorPrice:(0,n.optional)(a.AssetValueStruct),rarity:(0,n.optional)((0,n.object)({ranking:(0,n.optional)((0,n.object)({source:(0,n.string)(),rank:(0,n.number)()})),metadata:(0,n.optional)((0,n.record)((0,n.string)(),(0,n.number)()))}))}),a.AssetMarketDataStruct=(0,s.selectiveUnion)(e=>(0,r.isObject)(e)&&e.fungible?a.FungibleAssetMarketDataStruct:a.NonFungibleAssetMarketDataStruct),a.OnAssetsMarketDataResponseStruct=(0,n.object)({marketData:(0,n.record)(r.CaipAssetTypeOrIdStruct,(0,n.record)(r.CaipAssetTypeStruct,(0,n.nullable)(a.AssetMarketDataStruct)))})}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/assets-market-data.cjs"}],[2665,{"./types.cjs":2672},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.SNAP_EXPORT_NAMES=a.SNAP_EXPORTS=void 0;const s=e("./types.cjs");a.SNAP_EXPORTS={[s.HandlerType.OnRpcRequest]:{type:s.HandlerType.OnRpcRequest,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnTransaction]:{type:s.HandlerType.OnTransaction,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnCronjob]:{type:s.HandlerType.OnCronjob,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnNameLookup]:{type:s.HandlerType.OnNameLookup,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnInstall]:{type:s.HandlerType.OnInstall,required:!1,validator:e=>"function"==typeof e},[s.HandlerType.OnUpdate]:{type:s.HandlerType.OnUpdate,required:!1,validator:e=>"function"==typeof e},[s.HandlerType.OnStart]:{type:s.HandlerType.OnStart,required:!1,validator:e=>"function"==typeof e},[s.HandlerType.OnActive]:{type:s.HandlerType.OnActive,required:!1,validator:e=>"function"==typeof e},[s.HandlerType.OnInactive]:{type:s.HandlerType.OnInactive,required:!1,validator:e=>"function"==typeof e},[s.HandlerType.OnKeyringRequest]:{type:s.HandlerType.OnKeyringRequest,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnHomePage]:{type:s.HandlerType.OnHomePage,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnSettingsPage]:{type:s.HandlerType.OnSettingsPage,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnSignature]:{type:s.HandlerType.OnSignature,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnUserInput]:{type:s.HandlerType.OnUserInput,required:!1,validator:e=>"function"==typeof e},[s.HandlerType.OnAssetHistoricalPrice]:{type:s.HandlerType.OnAssetHistoricalPrice,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnAssetsLookup]:{type:s.HandlerType.OnAssetsLookup,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnAssetsConversion]:{type:s.HandlerType.OnAssetsConversion,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnAssetsMarketData]:{type:s.HandlerType.OnAssetsMarketData,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnProtocolRequest]:{type:s.HandlerType.OnProtocolRequest,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnClientRequest]:{type:s.HandlerType.OnClientRequest,required:!0,validator:e=>"function"==typeof e},[s.HandlerType.OnWebSocketEvent]:{type:s.HandlerType.OnWebSocketEvent,required:!0,validator:e=>"function"==typeof e}},a.SNAP_EXPORT_NAMES=Object.values(s.HandlerType)}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/exports.cjs"}],[2666,{"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnHomePageResponseStruct=a.OnHomePageResponseWithIdStruct=a.OnHomePageResponseWithContentStruct=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct");a.OnHomePageResponseWithContentStruct=(0,n.object)({content:s.ComponentOrElementStruct}),a.OnHomePageResponseWithIdStruct=(0,n.object)({id:(0,n.string)()}),a.OnHomePageResponseStruct=(0,n.union)([a.OnHomePageResponseWithContentStruct,a.OnHomePageResponseWithIdStruct])}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/home-page.cjs"}],[2667,{"./asset-historical-price.cjs":2662,"./assets-conversion.cjs":2663,"./assets-market-data.cjs":2664,"./exports.cjs":2665,"./home-page.cjs":2666,"./name-lookup.cjs":2668,"./settings-page.cjs":2669,"./signature.cjs":2670,"./transaction.cjs":2671,"./types.cjs":2672},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./asset-historical-price.cjs"),a),n(e("./assets-conversion.cjs"),a),n(e("./assets-market-data.cjs"),a),n(e("./exports.cjs"),a),n(e("./home-page.cjs"),a),n(e("./name-lookup.cjs"),a),n(e("./settings-page.cjs"),a),n(e("./signature.cjs"),a),n(e("./transaction.cjs"),a),n(e("./types.cjs"),a)}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/index.cjs"}],[2668,{"@metamask/superstruct":3365},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnNameLookupResponseStruct=a.DomainResolutionResponseStruct=a.AddressResolutionResponseStruct=a.DomainResolutionStruct=a.AddressResolutionStruct=void 0;const s=e("@metamask/superstruct");a.AddressResolutionStruct=(0,s.object)({protocol:(0,s.string)(),resolvedDomain:(0,s.string)()}),a.DomainResolutionStruct=(0,s.object)({protocol:(0,s.string)(),resolvedAddress:(0,s.string)(),domainName:(0,s.string)()}),a.AddressResolutionResponseStruct=(0,s.object)({resolvedDomains:(0,s.size)((0,s.array)(a.AddressResolutionStruct),1,Infinity)}),a.DomainResolutionResponseStruct=(0,s.object)({resolvedAddresses:(0,s.size)((0,s.array)(a.DomainResolutionStruct),1,Infinity)}),a.OnNameLookupResponseStruct=(0,s.nullable)((0,s.union)([a.AddressResolutionResponseStruct,a.DomainResolutionResponseStruct]))}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/name-lookup.cjs"}],[2669,{"./home-page.cjs":2666},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnSettingsPageResponseStruct=void 0;const s=e("./home-page.cjs");a.OnSettingsPageResponseStruct=s.OnHomePageResponseStruct}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/settings-page.cjs"}],[267,{"../../../shared/modules/string-utils":6354},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;var s=e("../../../shared/modules/string-utils");a.default=class{constructor(e={}){const{preferencesController:t,addressBookController:a,accountsController:s,networkController:n,trackMetaMetricsEvent:r}=e;this.preferencesController=t,this.accountsController=s,this.addressBookController=a,this.networkController=n,this._trackMetaMetricsEvent=r}async restoreUserData(e){const t=this.preferencesController.state,{preferences:a,addressBook:s,network:n,internalAccounts:r}=JSON.parse(e);a&&(a.identities=t.identities,a.lostIdentities=t.lostIdentities,a.selectedAddress=t.selectedAddress,this.preferencesController.update(a)),s&&this.addressBookController.update(s,!0),n&&this.networkController.loadBackup(n),r&&this.accountsController.loadBackup(r),(a||s||n||r)&&this._trackMetaMetricsEvent({event:"User Data Imported",category:"Backup"})}async backupUserData(){const e={preferences:{...this.preferencesController.state},internalAccounts:{internalAccounts:this.accountsController.state.internalAccounts},addressBook:{...this.addressBookController.state},network:{networkConfigurationsByChainId:this.networkController.state.networkConfigurationsByChainId}};delete e.preferences.identities,delete e.preferences.lostIdentities,delete e.preferences.selectedAddress;const t=JSON.stringify(e),a=new Date,n=e=>(0,s.prependZero)(e,2);return{fileName:`MetaMaskUserData.${a.getFullYear()}_${n(a.getMonth()+1)}_${n(a.getDay())}_${n(a.getHours())}_${n(a.getMinutes())}_${n(a.getDay())}.json`,data:t}}}}}},{package:"$root$",file:"app/scripts/lib/backup.js"}],[2670,{"./transaction.cjs":2671},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnSignatureResponseStruct=void 0;const s=e("./transaction.cjs");a.OnSignatureResponseStruct=s.OnTransactionResponseStruct}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/signature.cjs"}],[2671,{"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.OnTransactionResponseStruct=a.OnTransactionResponseWithContentStruct=a.OnTransactionResponseWithIdStruct=a.OnTransactionSeverityResponseStruct=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct");a.OnTransactionSeverityResponseStruct=(0,n.object)({severity:(0,n.optional)((0,n.literal)(s.SeverityLevel.Critical))}),a.OnTransactionResponseWithIdStruct=(0,n.assign)(a.OnTransactionSeverityResponseStruct,(0,n.object)({id:(0,n.string)()})),a.OnTransactionResponseWithContentStruct=(0,n.assign)(a.OnTransactionSeverityResponseStruct,(0,n.object)({content:s.ComponentOrElementStruct})),a.OnTransactionResponseStruct=(0,n.nullable)((0,n.union)([a.OnTransactionResponseWithContentStruct,a.OnTransactionResponseWithIdStruct]))}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/transaction.cjs"}],[2672,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;Object.defineProperty(a,"__esModule",{value:!0}),a.HandlerType=void 0,function(e){e.OnRpcRequest="onRpcRequest",e.OnSignature="onSignature",e.OnTransaction="onTransaction",e.OnCronjob="onCronjob",e.OnInstall="onInstall",e.OnUpdate="onUpdate",e.OnStart="onStart",e.OnActive="onActive",e.OnInactive="onInactive",e.OnNameLookup="onNameLookup",e.OnKeyringRequest="onKeyringRequest",e.OnHomePage="onHomePage",e.OnSettingsPage="onSettingsPage",e.OnUserInput="onUserInput",e.OnAssetsLookup="onAssetsLookup",e.OnAssetsConversion="onAssetsConversion",e.OnAssetHistoricalPrice="onAssetHistoricalPrice",e.OnAssetsMarketData="onAssetsMarketData",e.OnProtocolRequest="onProtocolRequest",e.OnClientRequest="onClientRequest",e.OnWebSocketEvent="onWebSocketEvent"}(s||(a.HandlerType=s={}))}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/handlers/types.cjs"}],[2673,{"./svg.cjs":2687,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getSvgDimensions=a.assertIsSnapIcon=a.SVG_MAX_BYTE_SIZE_TEXT=a.SVG_MAX_BYTE_SIZE=void 0;const s=e("@metamask/utils"),n=e("./svg.cjs");a.SVG_MAX_BYTE_SIZE=1e5,a.SVG_MAX_BYTE_SIZE_TEXT=`${Math.floor(a.SVG_MAX_BYTE_SIZE/1e3)}kb`,a.assertIsSnapIcon=function(e){(0,s.assert)(e.path.endsWith(".svg"),'Expected snap icon to end in ".svg".');const t="string"==typeof e.value?(0,s.stringToBytes)(e.value).byteLength:e.value.byteLength;(0,s.assert)(t<=a.SVG_MAX_BYTE_SIZE,`The specified SVG icon exceeds the maximum size of ${a.SVG_MAX_BYTE_SIZE_TEXT}.`),(0,s.assert)((0,n.isSvg)(e.toString()),"Snap icon must be a valid SVG.")},a.getSvgDimensions=function(e){try{const t=(0,n.parseSvg)(e),a=t["@_height"],r=t["@_width"];if(a&&r)return{height:a,width:r};const i=t["@_viewBox"];if(i){const[e,t,a,n]=i.split(" ");if(a&&n){const e=parseInt(a,10),t=parseInt(n,10);return(0,s.assert)(Number.isInteger(e)&&e>0),(0,s.assert)(Number.isInteger(t)&&t>0),{width:e,height:t}}}}catch{throw new Error("Snap icon must be a valid SVG.")}return null}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/icon.cjs"}],[2674,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createWindow=void 0,a.createWindow=async function({uri:e,id:t,sandbox:a=!0,testId:s="snaps-iframe"}){return await new Promise((n,r)=>{const i=document.createElement("iframe");i.setAttribute("id",t),i.setAttribute("data-testid",s),a&&i.setAttribute("sandbox","allow-scripts"),i.setAttribute("src",e),document.body.appendChild(i),i.addEventListener("load",()=>{i.contentWindow?n(i.contentWindow):r(new Error(`iframe.contentWindow not present on load for job "${t}".`))},{once:!0})})}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/iframe.cjs"}],[2675,{"./account.cjs":2647,"./array.cjs":2648,"./auxiliary-files.cjs":2649,"./base64.cjs":2650,"./bytes.cjs":2651,"./caveats.cjs":2652,"./checksum.cjs":2653,"./constants.cjs":2654,"./cronjob.cjs":2655,"./currency.cjs":2656,"./deep-clone.cjs":2657,"./default-endowments.cjs":2658,"./derivation-paths.cjs":2659,"./entropy.cjs":2660,"./errors.cjs":2661,"./handlers/index.cjs":2667,"./iframe.cjs":2674,"./json-rpc.cjs":2676,"./json.cjs":2677,"./localization.cjs":2678,"./logging.cjs":2679,"./manifest/index.cjs":2680,"./path.cjs":2682,"./platform-version.cjs":2683,"./snaps.cjs":2684,"./strings.cjs":2685,"./structs.cjs":2686,"./time.cjs":2688,"./types.cjs":2689,"./ui.cjs":2690,"./url.cjs":2691,"./validation.cjs":2692,"./versions.cjs":2693,"./virtual-file/index.cjs":2695},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./account.cjs"),a),n(e("./array.cjs"),a),n(e("./auxiliary-files.cjs"),a),n(e("./base64.cjs"),a),n(e("./bytes.cjs"),a),n(e("./caveats.cjs"),a),n(e("./checksum.cjs"),a),n(e("./constants.cjs"),a),n(e("./cronjob.cjs"),a),n(e("./currency.cjs"),a),n(e("./deep-clone.cjs"),a),n(e("./default-endowments.cjs"),a),n(e("./derivation-paths.cjs"),a),n(e("./entropy.cjs"),a),n(e("./errors.cjs"),a),n(e("./handlers/index.cjs"),a),n(e("./iframe.cjs"),a),n(e("./json.cjs"),a),n(e("./json-rpc.cjs"),a),n(e("./localization.cjs"),a),n(e("./logging.cjs"),a),n(e("./manifest/index.cjs"),a),n(e("./path.cjs"),a),n(e("./platform-version.cjs"),a),n(e("./snaps.cjs"),a),n(e("./strings.cjs"),a),n(e("./structs.cjs"),a),n(e("./time.cjs"),a),n(e("./types.cjs"),a),n(e("./ui.cjs"),a),n(e("./url.cjs"),a),n(e("./validation.cjs"),a),n(e("./versions.cjs"),a),n(e("./virtual-file/index.cjs"),a)}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/index.cjs"}],[2676,{"@metamask/permission-controller":2812,"@metamask/superstruct":3365,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.assertIsJsonRpcSuccess=a.isOriginAllowed=a.assertIsKeyringOrigins=a.KeyringOriginsStruct=a.assertIsRpcOrigins=a.RpcOriginsStruct=void 0;const s=e("@metamask/permission-controller"),n=e("@metamask/superstruct"),r=e("@metamask/utils"),i=(0,n.array)((0,n.refine)((0,n.string)(),"Allowed origin",e=>!(e.split("*").length-1>2)||'No more than two wildcards ("*") are allowed in an origin specifier.'));function o(e,t){if("*"===e||e===t)return!0;const a=function(e){const t=e.replace(/[.*+?^${}()|[\]\\]/gu,"\\$&").replace(/\\\*/gu,".*");return RegExp(`^${t}$`,"u")}(e);return a.test(t)}a.RpcOriginsStruct=(0,n.refine)((0,n.object)({dapps:(0,n.optional)((0,n.boolean)()),snaps:(0,n.optional)((0,n.boolean)()),allowedOrigins:(0,n.optional)(i)}),"RPC origins",e=>!!Boolean(!0===e.snaps||!0===e.dapps||e.allowedOrigins&&e.allowedOrigins.length>0)||"Must specify at least one JSON-RPC origin."),a.assertIsRpcOrigins=function(e,t){(0,r.assertStruct)(e,a.RpcOriginsStruct,"Invalid JSON-RPC origins",t)},a.KeyringOriginsStruct=(0,n.object)({allowedOrigins:(0,n.optional)(i)}),a.assertIsKeyringOrigins=function(e,t){(0,r.assertStruct)(e,a.KeyringOriginsStruct,"Invalid keyring origins",t)},a.isOriginAllowed=function(e,t,a){var n;return"metamask"===a||(!(null===(n=e.allowedOrigins)||void 0===n||!n.some(e=>o(e,a)))||(!(t!==s.SubjectType.Website||!e.dapps)||Boolean(t===s.SubjectType.Snap&&e.snaps)))},a.assertIsJsonRpcSuccess=function(e){if(!(0,r.isJsonRpcSuccess)(e)){if((0,r.isJsonRpcFailure)(e))throw new Error(`JSON-RPC request failed: ${e.error.message}`);throw new Error("Invalid JSON-RPC response.")}}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/json-rpc.cjs"}],[2677,{"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getJsonSizeUnsafe=a.parseJson=void 0;const s=e("@metamask/utils");a.parseJson=function(e){return(0,s.getSafeJson)(JSON.parse(e))},a.getJsonSizeUnsafe=function(e,t=!1){const a=JSON.stringify(e);return t?(new TextEncoder).encode(a).byteLength:a.length}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/json.cjs"}],[2678,{"./json.cjs":2677,"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.validateSnapManifestLocalizations=a.getLocalizedSnapManifest=a.translate=a.TRANSLATION_REGEX=a.getLocalizationFile=a.getValidatedLocalizationFiles=a.LocalizationFileStruct=a.LOCALIZABLE_FIELDS=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct"),r=e("./json.cjs");function i(e,t){const a=t.find(t=>t.locale===e);return a||t.find(e=>"en"===e.locale)}function o(e,t){const s=e.matchAll(a.TRANSLATION_REGEX);return Array.from(s).reduce((a,[s,n])=>{if(!t)throw new Error(`Failed to translate "${e}": No localization file found.`);const r=t.messages[n.trim()];if(!r)throw new Error(`Failed to translate "${e}": No translation found for "${n.trim()}" in "${t.locale}" file.`);return a.replace(s,r.message)},e)}function c(e,t,s){const n=i(t,s);return a.LOCALIZABLE_FIELDS.reduce((e,t)=>{const a=o(e[t],n);return{...e,[t]:a}},e)}a.LOCALIZABLE_FIELDS=["description","proposedName"],a.LocalizationFileStruct=(0,n.object)({locale:(0,n.string)(),messages:(0,n.record)((0,n.string)(),(0,n.object)({message:(0,n.string)(),description:(0,n.optional)((0,n.string)())}))}),a.getValidatedLocalizationFiles=function(e){for(const t of e)try{t.result=(0,n.create)((0,r.parseJson)(t.toString()),a.LocalizationFileStruct)}catch(e){if(e instanceof n.StructError)throw new Error(`Failed to validate localization file "${t.path}": ${e.message}.`);if(e instanceof SyntaxError)throw new Error(`Failed to parse localization file "${t.path}" as JSON.`);throw e}return e},a.getLocalizationFile=i,a.TRANSLATION_REGEX=/\{\{\s?([a-zA-Z0-9-_\s]+)\s?\}\}/gu,a.translate=o,a.getLocalizedSnapManifest=c,a.validateSnapManifestLocalizations=function(e,t){try{t.filter(e=>"en"!==e.locale).forEach(a=>{c(e,a.locale,t)}),c(e,"en",t)}catch(e){throw new Error(`Failed to localize Snap manifest: ${(0,s.getErrorMessage)(e)}`)}}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/localization.cjs"}],[2679,{"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.logWarning=a.logError=a.logInfo=a.snapsLogger=void 0;const s=e("@metamask/utils");a.snapsLogger=(0,s.createProjectLogger)("snaps"),a.logInfo=function(e,...t){console.log(e,...t)},a.logError=function(e,...t){console.error(e,...t)},a.logWarning=function(e,...t){console.warn(e,...t)}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/logging.cjs"}],[268,{"../../../shared/constants/defi-referrals":6188,"@metamask/json-rpc-engine":2402,loglevel:5255},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ReferralTriggerType=void 0,a.createDefiReferralMiddleware=function(e){return(0,n.createAsyncMiddleware)(async(t,a,s)=>{if(await s(),!function(e){return Boolean(e.origin)&&Boolean(e.tabId)}(t))return;const n=(0,i.getPartnerByOrigin)(t.origin);if(!n)return;const c="wallet_requestPermissions"===t.method,l=Array.isArray(a.result)&&a.result.some(e=>"eth_accounts"===(null==e?void 0:e.parentCapability));c&&l&&e(n,t.tabId,o.NewConnection).catch(e=>{r.default.error(`Failed to handle ${n.name} referral after wallet_requestPermissions grant: `,e)})})};var s,n=e("@metamask/json-rpc-engine"),r=(s=e("loglevel"))&&s.__esModule?s:{default:s},i=e("../../../shared/constants/defi-referrals");let o=a.ReferralTriggerType=function(e){return e.NewConnection="new_connection",e.OnNavigateConnectedTab="on_navigate_connected_tab",e}({})}}},{package:"$root$",file:"app/scripts/lib/createDefiReferralMiddleware.ts"}],[2680,{"./validation.cjs":2681},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./validation.cjs"),a)}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/manifest/index.cjs"}],[2681,{"../array.cjs":2648,"../cronjob.cjs":2655,"../entropy.cjs":2660,"../json-rpc.cjs":2676,"../snaps.cjs":2684,"../structs.cjs":2686,"../types.cjs":2689,"@metamask/key-tree":2450,"@metamask/superstruct":3365,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSnapManifest=a.assertIsSnapManifest=a.isSnapManifest=a.SnapManifestStruct=a.InitialConnectionsStruct=a.SnapAuxilaryFilesStruct=a.SnapAuxiliaryFilesStruct=a.PermissionsStruct=a.EmptyObjectStruct=a.HandlerCaveatsStruct=a.ProtocolScopesStruct=a.MaxRequestTimeStruct=a.MAXIMUM_REQUEST_TIMEOUT=a.MINIMUM_REQUEST_TIMEOUT=a.LookupMatchersStruct=a.ChainIdsStruct=a.SnapIdsStruct=a.SemVerRangeStruct=a.SnapGetBip32EntropyPermissionsStruct=a.Bip32EntropyStruct=a.CurveStruct=a.bip32entropy=a.Bip32PathStruct=a.FORBIDDEN_COIN_TYPES=void 0;const s=e("@metamask/key-tree"),n=e("@metamask/superstruct"),r=e("@metamask/utils"),i=e("../array.cjs"),o=e("../cronjob.cjs"),c=e("../entropy.cjs"),l=e("../json-rpc.cjs"),u=e("../snaps.cjs"),d=e("../structs.cjs"),m=e("../types.cjs"),p=[c.SIP_6_MAGIC_VALUE,c.STATE_ENCRYPTION_MAGIC_VALUE];a.FORBIDDEN_COIN_TYPES=[60];const h=a.FORBIDDEN_COIN_TYPES.map(e=>["m","44'",`${e}'`]);a.Bip32PathStruct=(0,n.refine)((0,n.array)((0,n.string)()),"BIP-32 path",e=>0===e.length?"Path must be a non-empty BIP-32 derivation path array":"m"!==e[0]?'Path must start with "m".':e.length<3?"Paths must have a length of at least three.":e.slice(1).some(e=>!(0,s.isValidBIP32PathSegment)(e))?"Path must be a valid BIP-32 derivation path array.":p.includes(e[1])?`The purpose "${e[1]}" is not allowed for entropy derivation.`:!h.some(t=>(0,i.isEqual)(e.slice(0,t.length),t))||`The path "${e.join("/")}" is not allowed for entropy derivation.`);a.bip32entropy=e=>(0,n.refine)(e,"BIP-32 entropy",e=>"ed25519"!==e.curve||!e.path.slice(1).some(e=>!e.endsWith("'"))||"Ed25519 does not support unhardened paths."),a.CurveStruct=(0,n.enums)(["ed25519","secp256k1","ed25519Bip32"]),a.Bip32EntropyStruct=(0,a.bip32entropy)((0,n.type)({path:a.Bip32PathStruct,curve:a.CurveStruct})),a.SnapGetBip32EntropyPermissionsStruct=(0,n.size)((0,n.array)(a.Bip32EntropyStruct),1,Infinity),a.SemVerRangeStruct=(0,n.refine)((0,n.string)(),"SemVer range",e=>!!(0,r.isValidSemVerRange)(e)||"Expected a valid SemVer range."),a.SnapIdsStruct=(0,n.refine)((0,n.record)(u.SnapIdStruct,(0,n.object)({version:(0,n.optional)(a.SemVerRangeStruct)})),"SnapIds",e=>0!==Object.keys(e).length),a.ChainIdsStruct=(0,n.size)((0,n.array)(r.CaipChainIdStruct),1,Infinity),a.LookupMatchersStruct=(0,n.union)([(0,n.object)({tlds:(0,n.size)((0,n.array)((0,n.string)()),1,Infinity)}),(0,n.object)({schemes:(0,n.size)((0,n.array)((0,n.string)()),1,Infinity)}),(0,n.object)({tlds:(0,n.size)((0,n.array)((0,n.string)()),1,Infinity),schemes:(0,n.size)((0,n.array)((0,n.string)()),1,Infinity)})]),a.MINIMUM_REQUEST_TIMEOUT=(0,r.inMilliseconds)(5,r.Duration.Second),a.MAXIMUM_REQUEST_TIMEOUT=(0,r.inMilliseconds)(3,r.Duration.Minute),a.MaxRequestTimeStruct=(0,n.size)((0,n.integer)(),a.MINIMUM_REQUEST_TIMEOUT,a.MAXIMUM_REQUEST_TIMEOUT),a.ProtocolScopesStruct=(0,n.record)(r.CaipChainIdStruct,(0,n.object)({methods:(0,n.array)((0,n.string)())})),a.HandlerCaveatsStruct=(0,n.object)({maxRequestTime:(0,n.optional)(a.MaxRequestTimeStruct)}),a.EmptyObjectStruct=(0,n.object)({}),a.PermissionsStruct=(0,n.type)({"endowment:assets":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,(0,n.object)({scopes:a.ChainIdsStruct}))),"endowment:cronjob":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,(0,n.object)({jobs:(0,n.optional)(o.CronjobSpecificationArrayStruct)}))),"endowment:ethereum-provider":(0,n.optional)(a.EmptyObjectStruct),"endowment:keyring":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,l.KeyringOriginsStruct)),"endowment:protocol":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,(0,n.object)({scopes:a.ProtocolScopesStruct}))),"endowment:lifecycle-hooks":(0,n.optional)(a.HandlerCaveatsStruct),"endowment:name-lookup":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,(0,n.object)({chains:(0,n.optional)(a.ChainIdsStruct),matchers:(0,n.optional)(a.LookupMatchersStruct)}))),"endowment:network-access":(0,n.optional)(a.EmptyObjectStruct),"endowment:page-home":(0,n.optional)(a.HandlerCaveatsStruct),"endowment:rpc":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,l.RpcOriginsStruct)),"endowment:signature-insight":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,(0,n.object)({allowSignatureOrigin:(0,n.optional)((0,n.boolean)())}))),"endowment:transaction-insight":(0,n.optional)((0,d.mergeStructs)(a.HandlerCaveatsStruct,(0,n.object)({allowTransactionOrigin:(0,n.optional)((0,n.boolean)())}))),"endowment:webassembly":(0,n.optional)(a.EmptyObjectStruct),snap_dialog:(0,n.optional)(a.EmptyObjectStruct),snap_manageState:(0,n.optional)(a.EmptyObjectStruct),snap_manageAccounts:(0,n.optional)(a.EmptyObjectStruct),snap_notify:(0,n.optional)(a.EmptyObjectStruct),snap_getBip32Entropy:(0,n.optional)(a.SnapGetBip32EntropyPermissionsStruct),snap_getBip32PublicKey:(0,n.optional)(a.SnapGetBip32EntropyPermissionsStruct),snap_getBip44Entropy:(0,n.optional)((0,n.size)((0,n.array)((0,n.object)({coinType:(0,n.size)((0,n.integer)(),0,2**32-1)})),1,Infinity)),snap_getEntropy:(0,n.optional)(a.EmptyObjectStruct),snap_getLocale:(0,n.optional)(a.EmptyObjectStruct),wallet_snap:(0,n.optional)(a.SnapIdsStruct)}),a.SnapAuxiliaryFilesStruct=(0,n.array)((0,n.string)()),a.SnapAuxilaryFilesStruct=a.SnapAuxiliaryFilesStruct,a.InitialConnectionsStruct=(0,n.record)((0,n.intersection)([(0,n.string)(),(0,m.uri)()]),(0,n.object)({})),a.SnapManifestStruct=(0,n.object)({version:r.VersionStruct,description:(0,n.size)((0,n.string)(),1,280),proposedName:(0,n.size)((0,n.string)(),1,214),repository:(0,n.optional)((0,n.type)({type:(0,n.size)((0,n.string)(),1,Infinity),url:(0,n.size)((0,n.string)(),1,Infinity)})),source:(0,n.object)({shasum:r.ChecksumStruct,location:(0,n.object)({npm:(0,n.object)({filePath:(0,n.size)((0,n.string)(),1,Infinity),iconPath:(0,n.optional)((0,n.size)((0,n.string)(),1,Infinity)),packageName:m.NameStruct,registry:(0,n.union)([(0,n.literal)("https://registry.npmjs.org"),(0,n.literal)("https://registry.npmjs.org/")])})}),files:(0,n.optional)(a.SnapAuxiliaryFilesStruct),locales:(0,n.optional)(a.SnapAuxiliaryFilesStruct)}),initialConnections:(0,n.optional)(a.InitialConnectionsStruct),initialPermissions:a.PermissionsStruct,manifestVersion:(0,n.literal)("0.1"),platformVersion:(0,n.optional)(r.VersionStruct),$schema:(0,n.optional)((0,n.string)())}),a.isSnapManifest=function(e){return(0,n.is)(e,a.SnapManifestStruct)},a.assertIsSnapManifest=function(e){(0,r.assertStruct)(e,a.SnapManifestStruct,`"${m.NpmSnapFileNames.Manifest}" is invalid`)},a.createSnapManifest=function(e){return(0,n.create)(e,a.SnapManifestStruct)}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/manifest/validation.cjs"}],[2682,{"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.normalizeRelative=void 0;const s=e("@metamask/utils");a.normalizeRelative=function(e){return(0,s.assert)(!e.startsWith("/")),(0,s.assert)(-1===e.search(/:|\/\//u),`Path "${e}" potentially an URI instead of local relative`),e.startsWith("./")?e.slice(2):e}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/path.cjs"}],[2683,{"@metamask/snaps-sdk/package.json":3303},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.getPlatformVersion=void 0;const n=s(e("@metamask/snaps-sdk/package.json"));a.getPlatformVersion=function(){return n.default.version}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/platform-version.cjs"}],[2684,{"./caveats.cjs":2652,"./checksum.cjs":2653,"./types.cjs":2689,"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365,"@metamask/utils":3504,"@scure/base":3584,"fast-json-stable-stringify":4788,"validate-npm-package-name":6159},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.verifyRequestedSnapPermissions=a.isSnapPermitted=a.assertIsValidSnapId=a.isSnapId=a.stripSnapPrefix=a.getSnapPrefix=a.SnapIdStruct=a.SnapIdPrefixStruct=a.HttpSnapIdStruct=a.NpmSnapIdStruct=a.LocalSnapIdStruct=a.BaseSnapIdStruct=a.LOCALHOST_HOSTNAMES=a.validateSnapShasum=a.getSnapChecksum=a.SnapStatusEvents=a.SnapStatus=a.PROPOSED_NAME_REGEX=void 0;const n=e("@metamask/snaps-sdk"),r=e("@metamask/superstruct"),i=e("@metamask/utils"),o=e("@scure/base"),c=s(e("fast-json-stable-stringify")),l=s(e("validate-npm-package-name")),u=e("./caveats.cjs"),d=e("./checksum.cjs"),m=e("./types.cjs");var p,h;function f(e){const t=e.clone();return delete t.result.source.shasum,t.value=(0,c.default)(t.result),t}async function b(e){const{manifest:t,sourceCode:a,svgIcon:s,auxiliaryFiles:n,localizationFiles:r}=e,i=[f(t),a,s,...n,...r].filter(e=>e!==undefined);return o.base64.encode(await(0,d.checksumFiles)(i))}a.PROPOSED_NAME_REGEX=/^(?:[A-Za-z0-9-_]+( [A-Za-z0-9-_]+)*)|(?:(?:@[A-Za-z0-9-*~][A-Za-z0-9-*._~]*\/)?[A-Za-z0-9-~][A-Za-z0-9-._~]*)$/u,function(e){e.Installing="installing",e.Updating="updating",e.Running="running",e.Stopped="stopped",e.Crashed="crashed"}(p||(a.SnapStatus=p={})),function(e){e.Start="START",e.Stop="STOP",e.Crash="CRASH",e.Update="UPDATE"}(h||(a.SnapStatusEvents=h={})),a.getSnapChecksum=b,a.validateSnapShasum=async function(e,t="Invalid Snap manifest: manifest shasum does not match computed shasum."){if(e.manifest.result.source.shasum!==await b(e))throw new Error(t)},a.LOCALHOST_HOSTNAMES=["localhost","127.0.0.1","[::1]"],a.BaseSnapIdStruct=(0,i.definePattern)("Base Snap Id",/^[\x21-\x7E]*$/u);const g=(0,m.uri)({protocol:(0,r.enums)(["http:","https:"]),hostname:(0,r.enums)(a.LOCALHOST_HOSTNAMES),hash:(0,r.empty)((0,r.string)()),search:(0,r.empty)((0,r.string)())});function y(e){const t=Object.values(m.SnapIdPrefixes).find(t=>e.startsWith(t));if(t!==undefined)return t;throw new Error(`Invalid or no prefix found for "${e}"`)}a.LocalSnapIdStruct=(0,r.refine)(a.BaseSnapIdStruct,"local Snap Id",e=>{if(!e.startsWith(m.SnapIdPrefixes.local))return`Expected local snap ID, got "${e}".`;const[t]=(0,r.validate)(e.slice(m.SnapIdPrefixes.local.length),g);return t??!0}),a.NpmSnapIdStruct=(0,r.intersection)([a.BaseSnapIdStruct,(0,m.uri)({protocol:(0,r.literal)(m.SnapIdPrefixes.npm),pathname:(0,r.refine)((0,r.string)(),"package name",function*(e){const t=e.startsWith("/")?e.slice(1):e,{errors:a,validForNewPackages:s,warnings:n}=(0,l.default)(t);return s||(a===undefined?((0,i.assert)(n!==undefined),yield*n):yield*a),!0}),search:(0,r.empty)((0,r.string)()),hash:(0,r.empty)((0,r.string)())})]),a.HttpSnapIdStruct=(0,r.intersection)([a.BaseSnapIdStruct,(0,m.uri)({protocol:(0,r.enums)(["http:","https:"]),search:(0,r.empty)((0,r.string)()),hash:(0,r.empty)((0,r.string)())})]),a.SnapIdPrefixStruct=(0,r.refine)((0,r.string)(),"Snap ID prefix",e=>{if(Object.values(m.SnapIdPrefixes).some(t=>e.startsWith(t)))return!0;return`Invalid or no prefix found. Expected Snap ID to start with one of: ${Object.values(m.SnapIdPrefixes).map(e=>`"${e}"`).join(", ")}, but received: "${e}"`}),a.SnapIdStruct=(0,n.selectiveUnion)(e=>"string"==typeof e&&e.startsWith(m.SnapIdPrefixes.npm)?a.NpmSnapIdStruct:"string"==typeof e&&e.startsWith(m.SnapIdPrefixes.local)?a.LocalSnapIdStruct:a.SnapIdPrefixStruct),a.getSnapPrefix=y,a.stripSnapPrefix=function(e){return e.replace(y(e),"")},a.isSnapId=function(e){return(0,r.is)(e,a.SnapIdStruct)},a.assertIsValidSnapId=function(e){(0,i.assertStruct)(e,a.SnapIdStruct,"Invalid snap ID")},a.isSnapPermitted=function(e,t){var a,s;return Boolean(null===(a=((null==e||null===(s=e.wallet_snap)||void 0===s||null===(s=s.caveats)||void 0===s?void 0:s.find(e=>e.type===u.SnapCaveatType.SnapIds))??{}).value)||void 0===a?void 0:a[t])},a.verifyRequestedSnapPermissions=function(e){(0,i.assert)((0,i.isObject)(e),"Requested permissions must be an object.");const{wallet_snap:t}=e;(0,i.assert)((0,i.isObject)(t),"wallet_snap is missing from the requested permissions.");const{caveats:a}=t;(0,i.assert)(Array.isArray(a)&&1===a.length,"wallet_snap must have a caveat property with a single-item array value.");const[s]=a;(0,i.assert)((0,i.isObject)(s)&&s.type===u.SnapCaveatType.SnapIds&&(0,i.isObject)(s.value),`The requested permissions do not have a valid ${u.SnapCaveatType.SnapIds} caveat.`)}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/snaps.cjs"}],[2685,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.indent=void 0,a.indent=function(e,t=2){return e.replace(/^/gmu," ".repeat(t))}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/strings.cjs"}],[2686,{"./strings.cjs":2685,"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365,"@metamask/utils":3504,chalk:4495},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.mergeStructs=a.createUnion=a.validateUnion=a.getStructErrorMessage=a.getStructFailureMessage=a.getStructErrorPrefix=a.getUnionStructNames=a.getStructFromPath=a.createFromStruct=a.getError=a.arrayToGenerator=a.SnapsStructError=a.named=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct"),r=e("@metamask/utils"),i=e("chalk"),o=e("./strings.cjs");function c(e,t,a){return a?t(e):e}a.named=function(e,t){return new n.Struct({...t,type:e})};class l extends n.StructError{constructor(e,t,a,s,n,r=!0){super(s,n),this.name="SnapsStructError",this.message=`${t}.\n\n${b(e,[...n()],r)}${a?`\n\n${a}`:""}`}}function*u(e){for(const t of e)yield t}function d({struct:e,prefix:t,suffix:a="",error:s,colorize:n}){return new l(e,t,a,s,()=>u(s.failures()),n)}function m(e,t){return t.reduce((t,a)=>(0,r.isObject)(e.schema)&&e.schema[a]?e.schema[a]:t,e)}function p(e,t=!0){return Array.isArray(e.schema)?e.schema.map(({type:e})=>c(e,i.green,t)):null}function h(e,t=!0){return"never"===e.type||0===e.path.length?"":`At path: ${c(e.path.join("."),i.bold,t)} — `}function f(e,t,a=!0){const s=c(JSON.stringify(t.value),i.red,a),n=h(t,a);if("union"===t.type){const r=p(m(e,t.path),a);return r?`${n}Expected the value to be one of: ${r.join(", ")}, but received: ${s}.`:`${n}${t.message}.`}if("literal"===t.type){return`${n}${t.message.replace(/the literal `(.+)`,/u,`the value to be \`${c("$1",i.green,a)}\`,`).replace(/, but received: (.+)/u,`, but received: ${c("$1",i.red,a)}`)}.`}if("never"===t.type)return`Unknown key: ${c(t.path.join("."),i.bold,a)}, received: ${s}.`;if("size"===t.refinement){return`${n}${t.message.replace(/length between `(\d+)` and `(\d+)`/u,`length between ${c("$1",i.green,a)} and ${c("$2",i.green,a)},`).replace(/length of `(\d+)`/u,`length of ${c("$1",i.red,a)}`).replace(/a array/u,"an array")}.`}return t.refinement!==undefined?`${n}${t.message}.`:`${n}Expected a value of type ${c(t.type,i.green,a)}, but received: ${s}.`}function b(e,t,a=!0){return t.map(t=>(0,o.indent)(`• ${f(e,t,a)}`)).join("\n")}function g(e,t,a,i=!1){(0,r.assert)(t.schema,"Expected a struct with a schema. Make sure to use `union` from `@metamask/snaps-sdk`."),(0,r.assert)(t.schema.length>0,"Expected a non-empty array of structs.");const o=t.schema.map(e=>e.schema[a]),c=(0,n.type)({[a]:(0,s.union)(o)}),[l]=(0,n.validate)(e,c,{coerce:i});if(l)throw new Error(f(c,l.failures()[0],!1));const u=e,d=t.schema.filter(e=>(0,n.is)(u[a],e.schema[a]));(0,r.assert)(d.length>0,"Expected a struct to match the value.");const m=d.map(e=>(0,n.validate)(u,e,{coerce:i})),p=m.find(([e])=>!e);if(p)return p[1];(0,r.assert)(m[0][0],"Expected at least one error.");const h=m.reduce((e,[t])=>((0,r.assert)(t,"Expected an error."),t.failures().length<e.failures().length?t:e),m[0][0]);throw new Error(f(t,h.failures()[0],!1))}a.SnapsStructError=l,a.arrayToGenerator=u,a.getError=d,a.createFromStruct=function(e,t,a,s=""){try{return(0,n.create)(e,t)}catch(e){if(e instanceof n.StructError)throw d({struct:t,prefix:a,suffix:s,error:e});throw e}},a.getStructFromPath=m,a.getUnionStructNames=p,a.getStructErrorPrefix=h,a.getStructFailureMessage=f,a.getStructErrorMessage=b,a.validateUnion=g,a.createUnion=function(e,t,a){return g(e,t,a,!0)},a.mergeStructs=function(...e){const t=n.assign(...e);return new n.Struct({...t,*refiner(t,a){for(const s of e)yield*s.refiner(t,a)}})}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/structs.cjs"}],[2687,{"@metamask/utils":3504,"fast-xml-parser":4790},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isSvg=a.parseSvg=void 0;const s=e("@metamask/utils"),n=e("fast-xml-parser");function r(e){try{const t=e.trim();(0,s.assert)(t.length>0);const a=new n.XMLParser({ignoreAttributes:!1,parseAttributeValue:!0}).parse(t,!0);return(0,s.assert)((0,s.hasProperty)(a,"svg")),(0,s.isObject)(a.svg)?a.svg:{}}catch{throw new Error("Snap icon must be a valid SVG.")}}a.parseSvg=r,a.isSvg=function(e){try{return r(e),!0}catch{return!1}}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/svg.cjs"}],[2688,{"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365,luxon:5258},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ISO8601DateStruct=a.toCensoredISO8601String=a.ISO8601DurationStruct=void 0;const s=e("@metamask/superstruct"),n=e("luxon");a.ISO8601DurationStruct=(0,s.refine)((0,s.string)(),"ISO 8601 duration",e=>!!n.Duration.fromISO(e).isValid||"Not a valid ISO 8601 duration"),a.toCensoredISO8601String=function(e){return n.DateTime.fromISO(e,{setZone:!0}).startOf("second").toISO({suppressMilliseconds:!0})};var r=e("@metamask/snaps-sdk");Object.defineProperty(a,"ISO8601DateStruct",{enumerable:!0,get:function(){return r.ISO8601DateStruct}})}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/time.cjs"}],[2689,{"@metamask/snaps-sdk":3215,"@metamask/superstruct":3365,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.WALLET_SNAP_PERMISSION_KEY=a.isValidUrl=a.uri=a.SNAP_STREAM_NAMES=a.SnapIdPrefixes=a.NpmSnapPackageJsonStruct=a.NameStruct=a.NpmSnapFileNames=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/superstruct"),r=e("@metamask/utils");var i,o,c;!function(e){e.PackageJson="package.json",e.Manifest="snap.manifest.json"}(i||(a.NpmSnapFileNames=i={})),a.NameStruct=(0,n.size)((0,r.definePattern)("Snap Name",/^(?:@[a-z0-9-*~][a-z0-9-*._~]*\/)?[a-z0-9-~][a-z0-9-._~]*$/u),1,214),a.NpmSnapPackageJsonStruct=(0,n.type)({version:r.VersionStruct,name:a.NameStruct,main:(0,n.optional)((0,n.size)((0,n.string)(),1,Infinity)),repository:(0,n.optional)((0,n.type)({type:(0,n.size)((0,n.string)(),1,Infinity),url:(0,n.size)((0,n.string)(),1,Infinity)}))}),function(e){e.npm="npm:",e.local="local:"}(o||(a.SnapIdPrefixes=o={})),function(e){e.JSON_RPC="jsonRpc",e.COMMAND="command"}(c||(a.SNAP_STREAM_NAMES=c={}));var l=e("@metamask/snaps-sdk");Object.defineProperty(a,"uri",{enumerable:!0,get:function(){return l.uri}}),a.isValidUrl=function(e,t={}){return(0,n.is)(e,(0,s.uri)(t))},a.WALLET_SNAP_PERMISSION_KEY="wallet_snap"}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/types.cjs"}],[269,{"../../../shared/constants/time":6220,loglevel:5255,"readable-stream":5685},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.THREE_MINUTES=void 0,a.default=function(){const e=c();return new n.Transform({transform(t,a,s){const n=t.id===undefined,i=e.add(t.id);n||i?s(null,t):(r.default.debug(`RPC request with id "${t.id}" already seen.`),s())},destroy(t,a){e.destroy(),a(t)},objectMode:!0})};var s,n=e("readable-stream"),r=(s=e("loglevel"))&&s.__esModule?s:{default:s},i=e("../../../shared/constants/time");const o=a.THREE_MINUTES=3*i.MINUTE,c=()=>{const e=new Map,t=setInterval(()=>{const t=Date.now()-o;for(const[a,s]of e.entries()){if(!(s<=t))break;e.delete(a)}},o);return{add:t=>!e.has(t)&&(e.set(t,Date.now()),!0),destroy(){clearInterval(t),e.clear()}}}}}},{package:"$root$",file:"app/scripts/lib/createDupeReqFilterStream.ts"}],[2690,{"./types.cjs":2689,"./url.cjs":2691,"@metamask/snaps-sdk":3215,"@metamask/snaps-sdk/jsx":3302,"@metamask/snaps-sdk/jsx-runtime":3301,"@metamask/utils":3504,marked:5259},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.serialiseJsx=a.walkJsx=a.getJsxChildren=a.hasChildren=a.getTotalTextLength=a.validateJsxElements=a.validateAssetSelector=a.validateTextLinks=a.validateLink=a.getJsxElementFromComponent=a.getTextChildren=void 0;const s=e("@metamask/snaps-sdk/jsx-runtime"),n=e("@metamask/snaps-sdk"),r=e("@metamask/snaps-sdk/jsx"),i=e("@metamask/utils"),o=e("marked"),c=e("./types.cjs"),l=e("./url.cjs"),u=["https:","mailto:","metamask:"];function d(e){switch(e){case"primary":return"primary";case"secondary":return"destructive";default:return undefined}}function m(e){return 1===e.length?e[0]:e}function p(e){return e.tokens&&e.tokens.length>0?m(e.tokens.flatMap(f)):e.href}function h(e){return m(e.flatMap(f))}function f(e){switch(e.type){case"link":return(0,s.jsx)(r.Link,{href:e.href,children:p(e)});case"text":return e.text;case"strong":return(0,s.jsx)(r.Bold,{children:h(e.tokens)});case"em":return(0,s.jsx)(r.Italic,{children:h(e.tokens)});default:return null}}function b(e){const t=(0,o.lexer)(e,{gfm:!1}),a=[];return(0,o.walkTokens)(t,e=>{if("paragraph"===e.type){a.length>0&&a.push("\n\n");const{tokens:t}=e;a.push(...t.flatMap(f))}}),a.filter(e=>null!==e)}function g(e,t,a){try{const s=new URL(e);if((0,i.assert)(u.includes(s.protocol),`Protocol must be one of: ${u.join(", ")}.`),"metamask:"===s.protocol){const t=(0,l.parseMetaMaskUrl)(e);t.snapId&&(0,i.assert)(a(t.snapId),"The Snap being navigated to is not installed.")}else if("mailto:"===s.protocol){const e=s.pathname.split(",");for(const a of e){const e=a.split("@")[1];(0,i.assert)(!e.includes(":"));const s=`https://${e}`;(0,i.assert)(!t(s),"The specified URL is not allowed.")}return}(0,i.assert)(!t(s.href),"The specified URL is not allowed.")}catch(e){throw new Error(`Invalid URL: ${"ERR_ASSERTION"===(null==e?void 0:e.code)?e.message:"Unable to parse URL."}`)}}function y(e,t){const a=t(e);(0,i.assert)(a,`Could not find account for address: ${e}`)}function w(e){const{type:t}=e;switch(t){case n.NodeType.Panel:return e.children.reduce((e,t)=>e+w(t),0);case n.NodeType.Row:return w(e.value);case n.NodeType.Text:return e.value.length;default:return 0}}function v(e){return(0,i.hasProperty)(e.props,"children")}function k(e){return Boolean(e)&&!0!==e}function _(e){if(v(e)){if(Array.isArray(e.props.children))return e.props.children.filter(k).flat(Infinity);if(e.props.children)return[e.props.children]}return[]}function S(e,t,a=0){if(Array.isArray(e)){for(const s of e){const e=S(s,t,a);if(e!==undefined)return e}return undefined}const s=t(e,a);if(s!==undefined)return s;if((0,i.hasProperty)(e,"props")&&(0,i.isPlainObject)(e.props)&&(0,i.hasProperty)(e.props,"children")){const s=_(e);for(const e of s)if((0,i.isPlainObject)(e)){const s=S(e,t,a+1);if(s!==undefined)return s}}return undefined}function E(e){return Object.entries(e).filter(([e])=>"children"!==e).sort(([e],[t])=>e.localeCompare(t)).map(([e,t])=>{return` ${e}=${a=t,"string"==typeof a?`"${a}"`:`{${JSON.stringify(a)}}`}`;var a}).join("")}a.getTextChildren=b,a.getJsxElementFromComponent=function(e){return function(e){const t=w(e);(0,i.assert)(t<=5e4,"The text in a Snap UI may not be larger than 50 kB.")}(e),function e(t){switch(t.type){case n.NodeType.Address:return(0,s.jsx)(r.Address,{address:t.value});case n.NodeType.Button:return(0,s.jsx)(r.Button,{name:t.name,variant:d(t.variant),type:t.buttonType,children:t.value});case n.NodeType.Copyable:return(0,s.jsx)(r.Copyable,{value:t.value,sensitive:t.sensitive});case n.NodeType.Divider:return(0,s.jsx)(r.Divider,{});case n.NodeType.Form:return(0,s.jsx)(r.Form,{name:t.name,children:m(t.children.map(e))});case n.NodeType.Heading:return(0,s.jsx)(r.Heading,{children:t.value});case n.NodeType.Image:return(0,s.jsx)(r.Image,{src:t.value});case n.NodeType.Input:return(0,s.jsx)(r.Field,{label:t.label,error:t.error,children:(0,s.jsx)(r.Input,{name:t.name,type:t.inputType,value:t.value,placeholder:t.placeholder})});case n.NodeType.Panel:return(0,s.jsx)(r.Box,{children:m(t.children.map(e))});case n.NodeType.Row:return(0,s.jsx)(r.Row,{label:t.label,variant:t.variant,children:e(t.value)});case n.NodeType.Spinner:return(0,s.jsx)(r.Spinner,{});case n.NodeType.Text:return(0,s.jsx)(r.Text,{children:m(b(t.value))});default:return(0,i.assertExhaustive)(t)}}(e)},a.validateLink=g,a.validateTextLinks=function(e,t,a){const s=function(e){const t=(0,o.lexer)(e,{gfm:!1}),a=[];return(0,o.walkTokens)(t,e=>{"link"===e.type&&a.push(e)}),a}(e);for(const e of s)g(e.href,t,a)},a.validateAssetSelector=y,a.validateJsxElements=function(e,{isOnPhishingList:t,getSnap:a,getAccountByAddress:s,hasPermission:n}){S(e,e=>{switch(e.type){case"Link":g(e.props.href,t,a);break;case"AssetSelector":y(e.props.addresses[0],s);break;case"Image":{const{src:t}=e.props,a=(0,c.isValidUrl)(t);(0,i.assert)(!a||a&&n("endowment:network-access"),"Using external images is only permitted with the `endowment:network-access` permission.");break}}})},a.getTotalTextLength=w,a.hasChildren=v,a.getJsxChildren=_,a.walkJsx=S,a.serialiseJsx=function e(t,a=0){if(Array.isArray(t))return t.map(t=>e(t,a)).join("");const s="  ".repeat(a);if("string"==typeof t)return`${s}${t}\n`;if(!t)return"";const{type:n,props:r}=t,o=a>0?"\n":"";if((0,i.hasProperty)(r,"children")){const t=e(r.children,a+1);return`${s}<${n}${E(r)}>\n${t}${s}</${n}>${o}`}return`${s}<${n}${E(r)} />${o}`}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/ui.cjs"}],[2691,{"./snaps.cjs":2684,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.parseMetaMaskUrl=a.SNAP_PATHS=a.CLIENT_PATHS=void 0;const s=e("@metamask/utils"),n=e("./snaps.cjs");a.CLIENT_PATHS=["/"],a.SNAP_PATHS=["/home"],a.parseMetaMaskUrl=function(e){const t=new URL(e),{protocol:r}=t;if("metamask:"!==r)throw new Error(`Unable to parse URL. Expected the protocol to be "metamask:", but received "${r}".`);const[i,...o]=t.href.replace("metamask://","").split("/"),c=`/${o.join("/")}`;switch(i){case"client":return(0,s.assert)(a.CLIENT_PATHS.includes(c),`Unable to navigate to "${c}". The provided path is not allowed.`),{authority:i,path:c};case"snap":return function(e){const t="Invalid MetaMask url:",r=(0,n.stripSnapPrefix)(e.slice(1)),i=e.slice(1).startsWith("npm:")?"npm:":"local:",o=r.startsWith("@"),c=r.split("/"),l=`/${c[c.length-1]}`;let u;if("local:"===i){const[e,,...n]=c.slice(0,-1);u=`${e}//${n.join("/")}`,(0,s.assert)(a.SNAP_PATHS.includes(l),`${t} invalid snap path.`)}else u=o?`${c[0]}/${c[1]}`:c[0],(0,s.assert)(o?3===c.length&&a.SNAP_PATHS.includes(l):2===c.length&&a.SNAP_PATHS.includes(l),`${t} invalid snap path.`);const d=`${i}${u}`;return(0,n.assertIsValidSnapId)(d),{authority:"snap",snapId:d,path:l}}(c);default:throw new Error(`Expected "metamask:" URL to start with "client" or "snap", but received "${i}".`)}}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/url.cjs"}],[2692,{"./icon.cjs":2673,"./localization.cjs":2678,"./manifest/validation.cjs":2681,"./snaps.cjs":2684},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.validateFetchedSnap=void 0;const s=e("./icon.cjs"),n=e("./localization.cjs"),r=e("./manifest/validation.cjs"),i=e("./snaps.cjs");a.validateFetchedSnap=async function(e){(0,r.assertIsSnapManifest)(e.manifest.result),await(0,i.validateSnapShasum)(e),(0,n.validateSnapManifestLocalizations)(e.manifest.result,e.localizationFiles.map(e=>e.result)),e.svgIcon&&(0,s.assertIsSnapIcon)(e.svgIcon)}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/validation.cjs"}],[2693,{"@metamask/superstruct":3365,"@metamask/utils":3504,semver:5995},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.resolveVersionRange=a.getTargetVersion=a.DEFAULT_REQUESTED_SNAP_VERSION=void 0;const s=e("@metamask/superstruct"),n=e("@metamask/utils"),r=e("semver");a.DEFAULT_REQUESTED_SNAP_VERSION="*",a.getTargetVersion=function(e,t){const a=(0,r.maxSatisfying)(e,t);return a||(0,r.maxSatisfying)(e,t,{includePrerelease:!0})},a.resolveVersionRange=function(e){return e===undefined||"latest"===e?[undefined,a.DEFAULT_REQUESTED_SNAP_VERSION]:(0,s.validate)(e,n.VersionRangeStruct)}}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/versions.cjs"}],[2694,{"../deep-clone.cjs":2657,"@metamask/utils":3504,"@scure/base":3584},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}Object.defineProperty(a,"__esModule",{value:!0}),a.VirtualFile=void 0;const n=e("@metamask/utils"),r=e("@scure/base"),i=e("../deep-clone.cjs");class o{constructor(e){var t,a,n,r;let i;s(this,"value",void 0),s(this,"result",void 0),s(this,"data",void 0),s(this,"path",void 0),i="string"==typeof e||e instanceof Uint8Array?{value:e}:e,this.value=(null===(t=i)||void 0===t?void 0:t.value)??"",this.result=(null===(a=i)||void 0===a?void 0:a.result)??undefined,this.data=(null===(n=i)||void 0===n?void 0:n.data)??{},this.path=(null===(r=i)||void 0===r?void 0:r.path)??"/"}get size(){return"string"==typeof this.value?this.value.length:this.value.byteLength}toString(e){if("string"==typeof this.value)return(0,n.assert)(e===undefined,"Tried to encode string."),this.value;if(this.value instanceof Uint8Array&&"hex"===e)return(0,n.bytesToHex)(this.value);if(this.value instanceof Uint8Array&&"base64"===e)return r.base64.encode(this.value);return new TextDecoder(e).decode(this.value)}clone(){const e=new o;return"string"==typeof this.value?e.value=this.value:e.value=this.value.slice(0),e.result=(0,i.deepClone)(this.result),e.data=(0,i.deepClone)(this.data),e.path=this.path,e}}a.VirtualFile=o}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/virtual-file/VirtualFile.cjs"}],[2695,{"./VirtualFile.cjs":2694},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./VirtualFile.cjs"),a)}}},{package:"@metamask/multichain-transactions-controller>@metamask/snaps-utils",file:"node_modules/@metamask/multichain-transactions-controller/node_modules/@metamask/snaps-utils/dist/virtual-file/index.cjs"}],[27,{"../../../../shared/constants/network":6203,"@metamask/keyring-api":2486,"@metamask/network-enablement-controller":2717,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.NetworkEnablementControllerInit=void 0;var s=e("@metamask/network-enablement-controller"),n=e("@metamask/keyring-api"),r=e("@metamask/utils"),i=e("../../../../shared/constants/network");const o=(e,t)=>{const a={[r.KnownCaipNamespace.Eip155]:{}};return Object.keys(e).forEach(e=>{a[r.KnownCaipNamespace.Eip155][e]=t.includes(e)}),a},c=(e,t=[])=>{const a={};return Object.keys(e).forEach(e=>{const s=t.includes(e),{namespace:n}=(0,r.parseCaipChainId)(e);(a[n]??(a[n]={}))[e]=s}),a},l=(e,t)=>{const{networkConfigurationsByChainId:a}=e,{multichainNetworkConfigurationsByChainId:s}=t;const r=[n.SolScope.Mainnet];return r.push(n.BtcScope.Mainnet),r.push(n.TrxScope.Mainnet),{enabledNetworkMap:{...o(a,i.FEATURED_NETWORK_CHAIN_IDS),...c(s,r)}}};a.NetworkEnablementControllerInit=({controllerMessenger:e,initMessenger:t,persistedState:a,getController:i})=>{const o=i("MultichainNetworkController").state,c=i("NetworkController").state,u=new s.NetworkEnablementController({messenger:e,state:{...l(c,o),...a.NetworkEnablementController}});return t.subscribe("AccountsController:selectedAccountChange",e=>{e.type===n.SolAccountType.DataAccount&&u.enableNetworkInNamespace(n.SolScope.Mainnet,r.KnownCaipNamespace.Solana)}),t.subscribe("AccountTreeController:selectedAccountGroupChange",()=>{const e=t.call("AccountTreeController:getAccountsFromSelectedAccountGroup",{scopes:[n.SolScope.Mainnet]}),a=t.call("AccountTreeController:getAccountsFromSelectedAccountGroup",{scopes:[n.BtcScope.Mainnet]}),s=t.call("AccountTreeController:getAccountsFromSelectedAccountGroup",{scopes:[n.TrxScope.Mainnet]}),r={};for(const e of Object.values(u.state.enabledNetworkMap))Object.assign(r,e);if(1===Object.keys(r).length){const t=Object.keys(r)[0];let i=!1;t===n.SolScope.Mainnet&&0===e.length&&(i=!0),t===n.BtcScope.Mainnet&&0===a.length&&(i=!0),t===n.TrxScope.Mainnet&&0===s.length&&(i=!0),i&&u.enableNetwork("0x1")}}),{controller:u}}}}},{package:"$root$",file:"app/scripts/controller-init/assets/network-enablement-controller-init.ts"}],[270,{"../../../shared/constants/permissions":6207,"../controllers/permissions":240,"@metamask/keyring-api":2486},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({messenger:e}){return function(t,a,n,r){const o=e.call("AccountsController:getSelectedAccount");if((0,s.isEvmAccountType)(o.type))return n();if(i.includes(t.method))return r(new Error(`Non-EVM account cannot request this method: ${t.method}`));if("wallet_requestPermissions"===t.method&&null!=t&&t.params&&Array.isArray(t.params)&&t.params.length>0&&t.params[0]){const e=Object.keys(t.params[0]);if(i.some(t=>e.includes(t)))return r(new Error(`Non-EVM account cannot request this method: ${e.toString()}`))}return n()}};var s=e("@metamask/keyring-api"),n=e("../../../shared/constants/permissions"),r=e("../controllers/permissions");const i=[...Object.values(n.RestrictedEthMethods),...r.unrestrictedEthSigningMethods]}}},{package:"$root$",file:"app/scripts/lib/createEvmMethodsToNonEvmAccountReqFilterMiddleware.ts"}],[271,{loglevel:5255},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(t,a,s){s(s=>{a.error&&n.default.debug("Error in RPC response:\n",a),t.isMetamaskInternal||(n.default.info(`RPC (${e.origin}): ${t.method} -> ${a.error?"error":"success"}`),s())})}};var s,n=(s=e("loglevel"))&&s.__esModule?s:{default:s}}}},{package:"$root$",file:"app/scripts/lib/createLoggerMiddleware.js"}],[2715,{"./constants.cjs":2716,"./utils.cjs":2719,"@metamask/base-controller":1506,"@metamask/controller-utils":1625,"@metamask/keyring-api":2486,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.NetworkEnablementController=void 0;const l=e("@metamask/base-controller"),u=e("@metamask/controller-utils"),d=e("@metamask/keyring-api"),m=e("@metamask/utils"),p=e("./constants.cjs"),h=e("./utils.cjs"),f={enabledNetworkMap:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0}};class b extends l.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:f,name:"NetworkEnablementController",state:{enabledNetworkMap:{[m.KnownCaipNamespace.Eip155]:{[u.ChainId[u.BuiltInNetworkName.Mainnet]]:!0,[u.ChainId[u.BuiltInNetworkName.LineaMainnet]]:!0,[u.ChainId[u.BuiltInNetworkName.BaseMainnet]]:!0},[m.KnownCaipNamespace.Solana]:{[d.SolScope.Mainnet]:!0,[d.SolScope.Testnet]:!1,[d.SolScope.Devnet]:!1},[m.KnownCaipNamespace.Bip122]:{[d.BtcScope.Mainnet]:!0,[d.BtcScope.Testnet]:!1,[d.BtcScope.Signet]:!1},[m.KnownCaipNamespace.Tron]:{[d.TrxScope.Mainnet]:!0,[d.TrxScope.Nile]:!1,[d.TrxScope.Shasta]:!1}},...t}}),s.add(this),e.subscribe("NetworkController:networkAdded",({chainId:e})=>{c(this,s,"m",o).call(this,e)}),e.subscribe("NetworkController:networkRemoved",({chainId:e})=>{c(this,s,"m",i).call(this,e)})}enableNetwork(e){const{namespace:t,storageKey:a}=(0,h.deriveKeys)(e);this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})}),e.enabledNetworkMap[t]&&(e.enabledNetworkMap[t][a]=!0)})}enableNetworkInNamespace(e,t){const{namespace:a,storageKey:r}=(0,h.deriveKeys)(e);if(a!==t)throw new Error(`Chain ID ${e} belongs to namespace ${a}, but namespace ${t} was specified`);this.update(e=>{c(this,s,"m",n).call(this,e,t),e.enabledNetworkMap[t]&&Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1}),e.enabledNetworkMap[t][r]=!0})}enableAllPopularNetworks(){this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})});const t=this.messenger.call("NetworkController:getState"),a=this.messenger.call("MultichainNetworkController:getState");p.POPULAR_NETWORKS.forEach(a=>{const{namespace:r,storageKey:i}=(0,h.deriveKeys)(a);t.networkConfigurationsByChainId[a]&&(c(this,s,"m",n).call(this,e,r),e.enabledNetworkMap[r][i]=!0)});const r=(0,h.deriveKeys)(d.SolScope.Mainnet);a.multichainNetworkConfigurationsByChainId[d.SolScope.Mainnet]&&(c(this,s,"m",n).call(this,e,r.namespace),e.enabledNetworkMap[r.namespace][r.storageKey]=!0);const i=(0,h.deriveKeys)(d.BtcScope.Mainnet);a.multichainNetworkConfigurationsByChainId[d.BtcScope.Mainnet]&&(c(this,s,"m",n).call(this,e,i.namespace),e.enabledNetworkMap[i.namespace][i.storageKey]=!0);const o=(0,h.deriveKeys)(d.TrxScope.Mainnet);a.multichainNetworkConfigurationsByChainId[d.TrxScope.Mainnet]&&(c(this,s,"m",n).call(this,e,o.namespace),e.enabledNetworkMap[o.namespace][o.storageKey]=!0)})}init(){this.update(e=>{const t=this.messenger.call("NetworkController:getState"),a=this.messenger.call("MultichainNetworkController:getState");Object.keys(t.networkConfigurationsByChainId).forEach(t=>{const{namespace:a,storageKey:r}=(0,h.deriveKeys)(t);c(this,s,"m",n).call(this,e,a),e.enabledNetworkMap[a][r]===undefined&&(e.enabledNetworkMap[a][r]=!1)}),Object.keys(a.multichainNetworkConfigurationsByChainId).forEach(t=>{const{namespace:a,storageKey:r}=(0,h.deriveKeys)(t);c(this,s,"m",n).call(this,e,a),e.enabledNetworkMap[a][r]===undefined&&(e.enabledNetworkMap[a][r]=!1)})})}disableNetwork(e){const t=(0,h.deriveKeys)(e),{namespace:a,storageKey:s}=t;this.update(e=>{e.enabledNetworkMap[a][s]=!1})}isNetworkEnabled(e){const t=(0,h.deriveKeys)(e),{namespace:a,storageKey:s}=t;return this.state.enabledNetworkMap[a]?.[s]??!1}}a.NetworkEnablementController=b,s=new WeakSet,n=function(e,t){e.enabledNetworkMap[t]||(e.enabledNetworkMap[t]={})},r=function(){const e=this.messenger.call("NetworkController:getState");return p.POPULAR_NETWORKS.reduce((t,a)=>{if(!e.networkConfigurationsByChainId[a])return t;const{namespace:s,storageKey:n}=(0,h.deriveKeys)(a),r=this.state.enabledNetworkMap[s]?.[n];return r?t+1:t},0)>1},i=function(e){const t=(0,h.deriveKeys)(e),{namespace:a,storageKey:s}=t;this.update(e=>{(0,h.isOnlyNetworkEnabledInNamespace)(this.state,t)&&(e.enabledNetworkMap[a][u.ChainId[u.BuiltInNetworkName.Mainnet]]=!0),a in e.enabledNetworkMap&&delete e.enabledNetworkMap[a][s]})},o=function(e){const{namespace:t,storageKey:a,reference:i}=(0,h.deriveKeys)(e);this.update(e=>{c(this,s,"m",n).call(this,e,t);const o=c(this,s,"m",r).call(this),l=(0,h.isPopularNetwork)(i);o&&l||Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})}),e.enabledNetworkMap[t][a]=!0})}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs"}],[2716,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.POPULAR_NETWORKS=void 0,a.POPULAR_NETWORKS=["0x1","0xe708","0x2105","0xa4b1","0xa86a","0x38","0xa","0x89","0x531","0x144","0x2a15c308d","0x3e7","0x8f"]}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/constants.cjs"}],[2717,{"./NetworkEnablementController.cjs":2715,"./selectors.cjs":2718},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.selectEnabledSolanaNetworks=a.selectEnabledEvmNetworks=a.selectEnabledNetworksCount=a.selectAllEnabledNetworks=a.createSelectorForEnabledNetworksForNamespace=a.selectIsNetworkEnabled=a.selectEnabledNetworkMap=a.NetworkEnablementController=void 0;var s=e("./NetworkEnablementController.cjs");Object.defineProperty(a,"NetworkEnablementController",{enumerable:!0,get:function(){return s.NetworkEnablementController}});var n=e("./selectors.cjs");Object.defineProperty(a,"selectEnabledNetworkMap",{enumerable:!0,get:function(){return n.selectEnabledNetworkMap}}),Object.defineProperty(a,"selectIsNetworkEnabled",{enumerable:!0,get:function(){return n.selectIsNetworkEnabled}}),Object.defineProperty(a,"createSelectorForEnabledNetworksForNamespace",{enumerable:!0,get:function(){return n.createSelectorForEnabledNetworksForNamespace}}),Object.defineProperty(a,"selectAllEnabledNetworks",{enumerable:!0,get:function(){return n.selectAllEnabledNetworks}}),Object.defineProperty(a,"selectEnabledNetworksCount",{enumerable:!0,get:function(){return n.selectEnabledNetworksCount}}),Object.defineProperty(a,"selectEnabledEvmNetworks",{enumerable:!0,get:function(){return n.selectEnabledEvmNetworks}}),Object.defineProperty(a,"selectEnabledSolanaNetworks",{enumerable:!0,get:function(){return n.selectEnabledSolanaNetworks}})}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/index.cjs"}],[2718,{"./utils.cjs":2719,"@metamask/utils":3504,reselect:5717},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.selectEnabledSolanaNetworks=a.selectEnabledEvmNetworks=a.selectEnabledNetworksCount=a.selectAllEnabledNetworks=a.createSelectorForEnabledNetworksForNamespace=a.selectIsNetworkEnabled=a.selectEnabledNetworkMap=void 0;const s=e("@metamask/utils"),n=e("reselect"),r=e("./utils.cjs");a.selectEnabledNetworkMap=e=>e.enabledNetworkMap;a.selectIsNetworkEnabled=e=>(0,n.createSelector)(a.selectEnabledNetworkMap,t=>{const{namespace:a,storageKey:s}=(0,r.deriveKeys)(e);return a in t&&s in t[a]&&t[a][s]});a.createSelectorForEnabledNetworksForNamespace=e=>(0,n.createSelector)(a.selectEnabledNetworkMap,t=>Object.entries(t[e]??{}).filter(([,e])=>e).map(([e])=>e)),a.selectAllEnabledNetworks=(0,n.createSelector)(a.selectEnabledNetworkMap,e=>Object.keys(e).reduce((t,a)=>(t[a]=Object.entries(e[a]).filter(([,e])=>e).map(([e])=>e),t),{})),a.selectEnabledNetworksCount=(0,n.createSelector)(a.selectAllEnabledNetworks,e=>Object.values(e).flat().length),a.selectEnabledEvmNetworks=(0,n.createSelector)((0,a.createSelectorForEnabledNetworksForNamespace)(s.KnownCaipNamespace.Eip155),e=>e),a.selectEnabledSolanaNetworks=(0,n.createSelector)((0,a.createSelectorForEnabledNetworksForNamespace)(s.KnownCaipNamespace.Solana),e=>e)}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"}],[2719,{"./constants.cjs":2716,"@metamask/controller-utils":1625,"@metamask/multichain-network-controller":2641,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isPopularNetwork=a.isOnlyNetworkEnabledInNamespace=a.deriveKeys=void 0;const s=e("@metamask/controller-utils"),n=e("@metamask/multichain-network-controller"),r=e("@metamask/utils"),i=e("./constants.cjs");a.deriveKeys=function(e){const t=(0,r.isCaipChainId)(e)?e:(0,n.toEvmCaipChainId)(e),{namespace:a,reference:i}=(0,r.parseCaipChainId)(t);let o;return o=a===r.KnownCaipNamespace.Eip155?(0,r.isHexString)(e)?e:(0,s.toHex)(i):t,{namespace:a,storageKey:o,caipChainId:t,reference:i}},a.isOnlyNetworkEnabledInNamespace=function(e,t){const{namespace:a,storageKey:s}=t;if(!e.enabledNetworkMap[a])return!1;const n=e.enabledNetworkMap[a],r=Object.entries(n).filter(([e,t])=>t);if(1===r.length){const[e]=r[0];return e===s}return!1},a.isPopularNetwork=function(e){try{return i.POPULAR_NETWORKS.includes((0,s.toHex)(e))}catch{return!1}}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/utils.cjs"}],[272,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({mainFrameOrigin:e}){return function(t,a,s){t.mainFrameOrigin=e,s()}}}}},{package:"$root$",file:"app/scripts/lib/createMainFrameOriginMiddleware.ts"}],[273,{"./stream-utils":354,"@metamask/rpc-errors":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;var s=e("@metamask/rpc-errors"),n=e("./stream-utils");a.default=(e,t)=>async a=>{if(!(0,n.isStreamWritable)(t))return;if(!e[a.method])return void t.write({jsonrpc:"2.0",error:s.rpcErrors.methodNotFound({message:`${a.method} not found`}),id:a.id});let r,i;try{r=await e[a.method](...a.params)}catch(e){i=e}(0,n.isStreamWritable)(t)?i?t.write({jsonrpc:"2.0",error:(0,s.serializeError)(i,{shouldIncludeStack:!0}),id:a.id}):t.write({jsonrpc:"2.0",result:r,id:a.id}):i&&console.error(i)}}}},{package:"$root$",file:"app/scripts/lib/createMetaRPCHandler.js"}],[274,{"./middleware/pending":296,"@metamask/eth-json-rpc-middleware":2083,"@metamask/json-rpc-engine/v2":2412},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({version:e,getAccounts:t,processTransaction:a,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:u,processEncryptionPublicKey:d,getPendingNonce:m,getPendingTransactionByHash:p,processRequestExecutionPermissions:h,processGetSupportedExecutionPermissions:f,processGetGrantedExecutionPermissions:b}){const g=n.JsonRpcEngineV2.create({middleware:[(0,n.createScaffoldMiddleware)({eth_syncing:!1,web3_clientVersion:`MetaMask/v${e}`}),(0,s.createWalletMiddleware)({getAccounts:t,processTransaction:a,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:u,processEncryptionPublicKey:d,processRequestExecutionPermissions:h,processGetSupportedExecutionPermissions:f,processGetGrantedExecutionPermissions:b}),(0,r.createPendingNonceMiddleware)({getPendingNonce:m}),(0,r.createPendingTxMiddleware)({getPendingTransactionByHash:p})]});return(0,n.asLegacyMiddleware)(g)};var s=e("@metamask/eth-json-rpc-middleware"),n=e("@metamask/json-rpc-engine/v2"),r=e("./middleware/pending")}}},{package:"$root$",file:"app/scripts/lib/createMetamaskMiddleware.ts"}],[275,{loglevel:5255,"webextension-polyfill":6172},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({location:e,registerOnboarding:t}){return async function(a,r,i,o){try{if("wallet_registerOnboarding"!==a.method)return void i();a.tabId&&a.tabId!==n.default.tabs.TAB_ID_NONE?await t(e,a.tabId):s.default.debug(`'wallet_registerOnboarding' message from ${e} ignored due to missing tabId`),r.result=!0,o()}catch(e){o(e)}}};var s=r(e("loglevel")),n=r(e("webextension-polyfill"));function r(e){return e&&e.__esModule?e:{default:e}}}}},{package:"$root$",file:"app/scripts/lib/createOnboardingMiddleware.js"}],[276,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(t,a,s){t.origin=e.origin,s()}}}}},{package:"$root$",file:"app/scripts/lib/createOriginMiddleware.js"}],[2760,{"./push-utils.cjs":2761},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=void 0;var s=e("./push-utils.cjs");Object.defineProperty(a,"createRegToken",{enumerable:!0,get:function(){return s.createRegToken}}),Object.defineProperty(a,"deleteRegToken",{enumerable:!0,get:function(){return s.deleteRegToken}}),Object.defineProperty(a,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return s.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],[2761,{"../../NotificationServicesController/index.cjs":2731,"../../shared/to-raw-notification.cjs":2765,"firebase/app":4802,"firebase/messaging":4803,"firebase/messaging/sw":4804,loglevel:5255},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=a.supportedCache=void 0;const n=e("firebase/app"),r=e("firebase/messaging"),i=e("firebase/messaging/sw"),o=s(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),l=e("../../shared/to-raw-notification.cjs");a.supportedCache=null;const u=async e=>{if(!await(async()=>(a.supportedCache??(a.supportedCache=await(0,i.isSupported)()),a.supportedCache))())return null;const t=await(async e=>{try{return(0,n.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,n.initializeApp)(t)}})(e);return(0,i.getMessaging)(t)};a.createRegToken=async function(e){try{const t=await u(e);if(!t)return null;return await(0,r.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},a.deleteRegToken=async function(e){try{const t=await u(e);return!t||(await(0,r.deleteToken)(t),!0)}catch{return!1}},a.createSubscribeToPushNotifications=function(e){return async function(t){const a=await async function(e,t){const a=await u(e);if(!a)return null;const s=(0,i.onBackgroundMessage)(a,async e=>{try{const a=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!a)return;const s=(0,l.toRawAPINotification)(a),n=c.Processors.processNotification(s);await t(n)}catch(t){throw o.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}});return()=>s()}(t,async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)}),s=function(e){const t=t=>{const a=t?.notification?.data;e(t,a)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}((t,a)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",a),e.onClickHandler(t,a)});return()=>{a?.(),s()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],[277,{"../../../shared/constants/app":6184,"@metamask/rpc-errors":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.SPAM_FILTER_ACTIVATED_ERROR=a.REJECTION_THRESHOLD_IN_MS=a.NUMBER_OF_REJECTIONS_THRESHOLD=a.BLOCKING_THRESHOLD_IN_MS=a.BLOCKABLE_METHODS=void 0,a.default=function({getThrottledOriginState:e,updateThrottledOriginState:t}){return function(a,s,n,m){const{method:p,origin:h}=a;if(!c.has(p)||l.includes(h))return void n();!function(e){if(!e)return!1;const t=Date.now(),{rejections:a,lastRejection:s}=e,n=t-s<=o;return a>=r&&n}(e(h))?n(a=>{if("error"in s&&s.error&&d(s.error)){var n;const r=null===(n=s.error)||void 0===n?void 0:n.data;if("rejectAllApprovals"===(null==r?void 0:r.cause))return void a();const o=e(h)||{rejections:0,lastRejection:0},c=Date.now(),l=c-o.lastRejection<i?o.rejections+1:1;t(h,{rejections:l,lastRejection:c})}else{const a=e(h);Boolean(a)&&t(h,{rejections:0,lastRejection:0})}a()}):m(u)}};var s=e("@metamask/rpc-errors"),n=e("../../../shared/constants/app");const r=a.NUMBER_OF_REJECTIONS_THRESHOLD=3,i=a.REJECTION_THRESHOLD_IN_MS=3e4,o=a.BLOCKING_THRESHOLD_IN_MS=6e4,c=a.BLOCKABLE_METHODS=new Set([n.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN,n.MESSAGE_TYPE.ETH_SEND_TRANSACTION,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4,n.MESSAGE_TYPE.PERSONAL_SIGN,n.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN,n.MESSAGE_TYPE.WALLET_SEND_CALLS,n.MESSAGE_TYPE.WATCH_ASSET]),l=["http://127.0.0.1:8080","http://127.0.0.1:8081","http://127.0.0.1:8082","http://localhost:8080","http://localhost:8081","http://localhost:8082"],u=a.SPAM_FILTER_ACTIVATED_ERROR=s.providerErrors.unauthorized("Request blocked due to spam filter."),d=e=>e.code===s.errorCodes.provider.userRejectedRequest}}},{package:"$root$",file:"app/scripts/lib/createOriginThrottlingMiddleware.ts"}],[278,{"../../../shared/constants/app":6184,"../../../shared/constants/metametrics":6199,"../../../shared/constants/security-provider":6211,"../../../shared/constants/signatures":6212,"../../../shared/constants/transaction":6222,"../../../shared/lib/snaps/snaps":6302,"../../../shared/lib/trust-signals":6313,"../../../shared/modules/error":6328,"../../../shared/modules/transaction.utils":6356,"../../../ui/helpers/utils/metrics":7493,"./snap-keyring/metrics":339,"@metamask/controller-utils":1625,"@metamask/rpc-errors":2976,"ethereumjs-util":4727},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({rateLimitTimeout:e=3e5,rateLimitSamplePercent:t=.001,globalRateLimitTimeout:a=3e5,globalRateLimitMaxAmount:T=10,getAccountType:P,getDeviceModel:M,getHardwareTypeForMetric:I,snapAndHardwareMessenger:x,appStateController:C,metaMetricsController:A,getHDEntropyIndex:j}){return async function(R,O,N){const{origin:$,method:D,params:B}=R,L=function(e){return[i.MESSAGE_TYPE.WALLET_CREATE_SESSION,i.MESSAGE_TYPE.WALLET_INVOKE_METHOD].includes(e)}(D),F=L?o.MetaMetricsRequestedThrough.MultichainApi:o.MetaMetricsRequestedThrough.EthereumProvider,H=L?o.MetaMetricsEventCategory.MultichainApi:o.MetaMetricsEventCategory.InpageProvider;let U,q=D;var V;D===i.MESSAGE_TYPE.WALLET_INVOKE_METHOD&&(q=null==B||null===(V=B.request)||void 0===V?void 0:V.method,U=null==B?void 0:B.scope);const G=w[q];let W;switch(G){case g.TIMEOUT:W=void 0!==S[q];break;case g.NON_RATE_LIMITED:W=!1;break;case g.BLOCKED:W=!0;break;default:case g.RANDOM_SAMPLE:W=Math.random()>=t}const z=T>0&&E>=T,K=!0===A.state.participateInMetaMetrics,J=v[q],Y={api_source:F};let Q;U&&(Y.chain_id_caip=U);const X=(0,f.isSnapPreinstalled)($),Z=$!==i.ORIGIN_METAMASK&&!X&&!W&&!z&&!0===K;if(Z){var ee;const t=J?J.REQUESTED:o.MetaMetricsEventName.ProviderMethodCalled;if(t===o.MetaMetricsEventName.SignatureRequested){var te,ae,se,ne,re;let e;var ie,oe;if(Y.signature_type=q,Y.hd_entropy_index=j(),(0,r.isValidAddress)(null==R||null===(te=R.params)||void 0===te?void 0:te[1]))e=null==R||null===(ie=R.params)||void 0===ie?void 0:ie[0];else e=null==R||null===(oe=R.params)||void 0===oe?void 0:oe[1];null!==(ae=R.securityAlertResponse)&&void 0!==ae&&ae.providerRequestsCount&&Object.keys(R.securityAlertResponse.providerRequestsCount).forEach(e=>{Y[`ppom_${e}_count`]=R.securityAlertResponse.providerRequestsCount[e]}),Y.security_alert_response=(null===(se=R.securityAlertResponse)||void 0===se?void 0:se.result_type)??l.BlockaidResultType.NotApplicable,Y.security_alert_reason=(null===(ne=R.securityAlertResponse)||void 0===ne?void 0:ne.reason)??l.BlockaidReason.notApplicable,Y.address_alert_response=u.ResultType.Loading,null!==(re=R.securityAlertResponse)&&void 0!==re&&re.description&&(Y.security_alert_description=R.securityAlertResponse.description);const t=await(0,b.getSnapAndHardwareInfoForMetrics)(P,M,I,x);Object.assign(Y,t);try{if(q===i.MESSAGE_TYPE.PERSONAL_SIGN){const{isSIWEMessage:t}=(0,s.detectSIWE)({data:e});t&&(Y.ui_customizations=[...Y.ui_customizations||[],o.MetaMetricsEventUiCustomization.Siwe])}else if(q===i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4){const t=(0,c.parseTypedDataMessage)(e);Q={},Y.eip712_primary_type=t.primaryType,Q.eip712_verifyingContract=t.domain.verifyingContract,Q.eip712_domain_version=t.domain.version,Q.eip712_domain_name=t.domain.name,d.PRIMARY_TYPES_PERMIT.includes(t.primaryType)?Y.ui_customizations=[...Y.ui_customizations||[],o.MetaMetricsEventUiCustomization.Permit]:d.PRIMARY_TYPES_ORDER.includes(t.primaryType)&&(Y.ui_customizations=[...Y.ui_customizations||[],o.MetaMetricsEventUiCustomization.Order])}}catch(e){console.warn(`createRPCMethodTrackingMiddleware: Errored - ${e}`)}}else Y.method=q;const n=k[q];if(n&&(Y.params=n(B)),null===(ee=_[q])||void 0===ee||ee.call(_,R,undefined,y.REQUESTED,Y),t===o.MetaMetricsEventName.SignatureRequested){!function(e,t,a,s){e.createEventFragment({category:s,initialEvent:o.MetaMetricsEventName.SignatureRequested,successEvent:o.MetaMetricsEventName.SignatureApproved,failureEvent:o.MetaMetricsEventName.SignatureRejected,uniqueIdentifier:(0,h.generateSignatureUniqueId)(t.id),persist:!0,referrer:{url:t.origin},...a})}(A,R,{properties:Y,sensitiveProperties:Q},H)}else A.trackEvent({event:t,category:H,referrer:{url:$},properties:Y});G===g.TIMEOUT&&(S[q]=setTimeout(()=>{delete S[q]},e)),E+=1,setTimeout(()=>{E-=1},a)}N(async e=>{var t,a,s,r;if(!1===Z||void 0===J)return e();const i=null===(t=O.error)||void 0===t||null===(t=t.data)||void 0===t?void 0:t.location;let c,l;const u=(0,p.getErrorMessage)(O.error);if((null===(a=O.error)||void 0===a?void 0:a.code)===n.errorCodes.provider.userRejectedRequest?(c=J.REJECTED,l=y.REJECTED):(null===(s=O.error)||void 0===s?void 0:s.code)===n.errorCodes.rpc.internal&&[u,O.error.message].includes("Request rejected by user or snap.")?(c=J.REJECTED,l=y.REJECTED,Y.status=u):(c=J.APPROVED,l=y.APPROVED),!c)return e();if(null===(r=_[q])||void 0===r||r.call(_,R,O,l,Y),J.REQUESTED===o.MetaMetricsEventName.SignatureRequested){const e=await(0,b.getSnapAndHardwareInfoForMetrics)(P,M,I,x);Object.assign(Y,e)}let d={};if(m.SIGNING_METHODS.includes(q)){var f;const e=C.getSignatureSecurityAlertResponse(null===(f=R.securityAlertResponse)||void 0===f?void 0:f.securityAlertId);d=(0,h.getBlockaidMetricsProps)({securityAlertResponse:e})}const g={...Y,...d,location:i};if(delete g.address_alert_response,c===o.MetaMetricsEventName.SignatureRejected||c===o.MetaMetricsEventName.SignatureApproved){const e={abandoned:c===J.REJECTED},t={properties:{...g,hd_entropy_index:j()},sensitiveProperties:Q};!function(e,t,a,s){const n=(0,h.generateSignatureUniqueId)(t.id);e.updateEventFragment(n,s),e.finalizeEventFragment(n,a)}(A,R,e,t)}else A.trackEvent({event:c,category:H,referrer:{url:$},properties:g});return e()})}};var s=e("@metamask/controller-utils"),n=e("@metamask/rpc-errors"),r=e("ethereumjs-util"),i=e("../../../shared/constants/app"),o=e("../../../shared/constants/metametrics"),c=e("../../../shared/modules/transaction.utils"),l=e("../../../shared/constants/security-provider"),u=e("../../../shared/lib/trust-signals"),d=e("../../../shared/constants/signatures"),m=e("../../../shared/constants/transaction"),p=e("../../../shared/modules/error"),h=e("../../../ui/helpers/utils/metrics"),f=e("../../../shared/lib/snaps/snaps"),b=e("./snap-keyring/metrics");const g={TIMEOUT:"timeout",BLOCKED:"blocked",NON_RATE_LIMITED:"non_rate_limited",RANDOM_SAMPLE:"random_sample"},y={REQUESTED:"REQUESTED",APPROVED:"APPROVED",REJECTED:"REJECTED"},w={[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.PERSONAL_SIGN]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_DECRYPT]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]:g.TIMEOUT,[i.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]:g.TIMEOUT,[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.SEND_METADATA]:g.BLOCKED,[i.MESSAGE_TYPE.ETH_CHAIN_ID]:g.BLOCKED,[i.MESSAGE_TYPE.ETH_ACCOUNTS]:g.BLOCKED,[i.MESSAGE_TYPE.LOG_WEB3_SHIM_USAGE]:g.BLOCKED,[i.MESSAGE_TYPE.GET_PROVIDER_STATE]:g.BLOCKED,[i.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:g.NON_RATE_LIMITED},v={[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.PERSONAL_SIGN]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_DECRYPT]:{APPROVED:o.MetaMetricsEventName.DecryptionApproved,REJECTED:o.MetaMetricsEventName.DecryptionRejected,REQUESTED:o.MetaMetricsEventName.DecryptionRequested},[i.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]:{APPROVED:o.MetaMetricsEventName.EncryptionPublicKeyApproved,REJECTED:o.MetaMetricsEventName.EncryptionPublicKeyRejected,REQUESTED:o.MetaMetricsEventName.EncryptionPublicKeyRequested},[i.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called},[i.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called},[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called}},k={[i.MESSAGE_TYPE.WATCH_ASSET]:({type:e})=>({type:e}),[i.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]:([{chainId:e}])=>({chainId:e}),[i.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]:([{chainId:e}])=>({chainId:e})},_={[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:function(e,t,a,s){var n;if(a!==y.REQUESTED)return;const{params:r}=e,i=null==r||null===(n=r[0])||void 0===n||null===(n=n.calls)||void 0===n?void 0:n.length;i&&(s.batch_transaction_count=i)},[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:function(e,t,a,s){if(a===y.REQUESTED){const{params:t}=e,a=(null==t?void 0:t.requiredScopes)||{},n=(null==t?void 0:t.optionalScopes)||{},r=new Set;for(const e of Object.keys(a))r.add(e);for(const e of Object.keys(n))r.add(e);s.chain_id_list=Array.from(r)}else if(a===y.APPROVED){const{result:e}=t,a=Object.keys((null==e?void 0:e.sessionScopes)||{});s.chain_id_list=a}}},S={};let E=0}}},{package:"$root$",file:"app/scripts/lib/createRPCMethodTrackingMiddleware.js"}],[2786,{"./ObservableStore":2788},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ComposedStore=void 0;const s=e("./ObservableStore");class n extends s.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach(e=>{const t=this._children[e];this._addChild(e,t)})}_addChild(e,t){const a=t=>{const a=this.getState();a[e]=t,this.putState(a)};t.subscribe(a),a(t.getState())}}a.ComposedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],[2787,{"./ObservableStore":2788},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.MergedStore=void 0;const s=e("./ObservableStore");class n extends s.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach(e=>this._addChild(e)),this._updateWholeState()}_addChild(e){e.subscribe(()=>this._updateWholeState())}_updateWholeState(){const e=this._children.map(e=>e.getState()),t=Object.assign({},...e);this.putState(t)}}a.MergedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],[2788,{"@metamask/safe-event-emitter":2978},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.ObservableStore=void 0;const n=s(e("@metamask/safe-event-emitter"));class r extends n.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}a.ObservableStore=r}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],[2789,{"readable-stream":2806},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeAsStream=void 0;const s=e("readable-stream");class n extends s.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const a=super.pipe(e,t);return e.write(this.obsStore.getState()),a}_write(e,t,a){this.obsStore.putState(e),a()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}a.storeAsStream=function(e){return new n(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],[279,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(t,a,s){t.tabId=e.tabId,s()}}}}},{package:"$root$",file:"app/scripts/lib/createTabIdMiddleware.js"}],[2790,{"./ComposedStore":2786,"./MergedStore":2787,"./ObservableStore":2788,"./asStream":2789,"./transform":2791},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a),Object.defineProperty(e,s,{enumerable:!0,get:function(){return t[a]}})}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./asStream"),a),n(e("./ComposedStore"),a),n(e("./MergedStore"),a),n(e("./ObservableStore"),a),n(e("./transform"),a)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],[2791,{"readable-stream":2806},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeTransformStream=void 0;const s=e("readable-stream");a.storeTransformStream=function(e){return new s.Transform({objectMode:!0,transform:(t,a,s)=>{try{const a=e(t);return s(undefined,a),undefined}catch(e){return s(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],[2792,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s={};function n(e,t,a){a||(a=Error);var n=function(e){var a,s;function n(a,s,n){return e.call(this,function(e,a,s){return"string"==typeof t?t:t(e,a,s)}(a,s,n))||this}return s=e,(a=n).prototype=Object.create(s.prototype),a.prototype.constructor=a,a.__proto__=s,n}(a);n.prototype.name=a.name,n.prototype.code=e,s[e]=n}function r(e,t){if(Array.isArray(e)){var a=e.length;return e=e.map(function(e){return String(e)}),a>2?"one of ".concat(t," ").concat(e.slice(0,a-1).join(", "),", or ")+e[a-1]:2===a?"one of ".concat(t," ").concat(e[0]," or ").concat(e[1]):"of ".concat(t," ").concat(e[0])}return"of ".concat(t," ").concat(String(e))}n("ERR_INVALID_OPT_VALUE",function(e,t){return'The value "'+t+'" is invalid for option "'+e+'"'},TypeError),n("ERR_INVALID_ARG_TYPE",function(e,t,a){var s,n,i,o;if("string"==typeof t&&(n="not ",t.substr(!i||i<0?0:+i,n.length)===n)?(s="must not be",t=t.replace(/^not /,"")):s="must be",function(e,t,a){return(a===undefined||a>e.length)&&(a=e.length),e.substring(a-t.length,a)===t}(e," argument"))o="The ".concat(e," ").concat(s," ").concat(r(t,"type"));else{var c=function(e,t,a){return"number"!=typeof a&&(a=0),!(a+t.length>e.length)&&-1!==e.indexOf(t,a)}(e,".")?"property":"argument";o='The "'.concat(e,'" ').concat(c," ").concat(s," ").concat(r(t,"type"))}return o+=". Received type ".concat(typeof a)},TypeError),n("ERR_STREAM_PUSH_AFTER_EOF","stream.push() after EOF"),n("ERR_METHOD_NOT_IMPLEMENTED",function(e){return"The "+e+" method is not implemented"}),n("ERR_STREAM_PREMATURE_CLOSE","Premature close"),n("ERR_STREAM_DESTROYED",function(e){return"Cannot call "+e+" after a stream was destroyed"}),n("ERR_MULTIPLE_CALLBACK","Callback called multiple times"),n("ERR_STREAM_CANNOT_PIPE","Cannot pipe, not readable"),n("ERR_STREAM_WRITE_AFTER_END","write after end"),n("ERR_STREAM_NULL_VALUES","May not write null values to stream",TypeError),n("ERR_UNKNOWN_ENCODING",function(e){return"Unknown encoding: "+e},TypeError),n("ERR_STREAM_UNSHIFT_AFTER_END_EVENT","stream.unshift() after end event"),t.exports.codes=s}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/errors-browser.js"}],[2793,{"./_stream_readable":2795,"./_stream_writable":2797,_process:5498,inherits:5025},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){var s=Object.keys||function(e){var t=[];for(var a in e)t.push(a);return t};t.exports=l;var n=e("./_stream_readable"),r=e("./_stream_writable");e("inherits")(l,n);for(var i=s(r.prototype),o=0;o<i.length;o++){var c=i[o];l.prototype[c]||(l.prototype[c]=r.prototype[c])}function l(e){if(!(this instanceof l))return new l(e);n.call(this,e),r.call(this,e),this.allowHalfOpen=!0,e&&(!1===e.readable&&(this.readable=!1),!1===e.writable&&(this.writable=!1),!1===e.allowHalfOpen&&(this.allowHalfOpen=!1,this.once("end",u)))}function u(){this._writableState.ended||a.nextTick(d,this)}function d(e){e.end()}Object.defineProperty(l.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(l.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(l.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(l.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed&&this._writableState.destroyed)},set:function(e){this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_duplex.js"}],[2794,{"./_stream_transform":2796,inherits:5025},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=n;var s=e("./_stream_transform");function n(e){if(!(this instanceof n))return new n(e);s.call(this,e)}e("inherits")(n,s),n.prototype._transform=function(e,t,a){a(null,e)}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_passthrough.js"}],[2795,{"../errors":2792,"./_stream_duplex":2793,"./internal/streams/async_iterator":2798,"./internal/streams/buffer_list":2799,"./internal/streams/destroy":2800,"./internal/streams/from":2802,"./internal/streams/state":2804,"./internal/streams/stream":2805,_process:5498,buffer:4473,events:4769,inherits:5025,"string_decoder/":6074,util:4425},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){var s;t.exports=E,E.ReadableState=S;e("events").EventEmitter;var n=function(e,t){return e.listeners(t).length},r=e("./internal/streams/stream"),i=e("buffer").Buffer,o=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var c,l=e("util");c=l&&l.debuglog?l.debuglog("stream"):function(){};var u,d,m,p=e("./internal/streams/buffer_list"),h=e("./internal/streams/destroy"),f=e("./internal/streams/state").getHighWaterMark,b=e("../errors").codes,g=b.ERR_INVALID_ARG_TYPE,y=b.ERR_STREAM_PUSH_AFTER_EOF,w=b.ERR_METHOD_NOT_IMPLEMENTED,v=b.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;e("inherits")(E,r);var k=h.errorOrDestroy,_=["error","close","destroy","pause","resume"];function S(t,a,n){s=s||e("./_stream_duplex"),t=t||{},"boolean"!=typeof n&&(n=a instanceof s),this.objectMode=!!t.objectMode,n&&(this.objectMode=this.objectMode||!!t.readableObjectMode),this.highWaterMark=f(this,t,"readableHighWaterMark",n),this.buffer=new p,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.paused=!0,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.destroyed=!1,this.defaultEncoding=t.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,t.encoding&&(u||(u=e("string_decoder/").StringDecoder),this.decoder=new u(t.encoding),this.encoding=t.encoding)}function E(t){if(s=s||e("./_stream_duplex"),!(this instanceof E))return new E(t);var a=this instanceof s;this._readableState=new S(t,this,a),this.readable=!0,t&&("function"==typeof t.read&&(this._read=t.read),"function"==typeof t.destroy&&(this._destroy=t.destroy)),r.call(this)}function T(e,t,a,s,n){c("readableAddChunk",t);var r,l=e._readableState;if(null===t)l.reading=!1,function(e,t){if(c("onEofChunk"),t.ended)return;if(t.decoder){var a=t.decoder.end();a&&a.length&&(t.buffer.push(a),t.length+=t.objectMode?1:a.length)}t.ended=!0,t.sync?x(e):(t.needReadable=!1,t.emittedReadable||(t.emittedReadable=!0,C(e)))}(e,l);else if(n||(r=function(e,t){var a;s=t,i.isBuffer(s)||s instanceof o||"string"==typeof t||t===undefined||e.objectMode||(a=new g("chunk",["string","Buffer","Uint8Array"],t));var s;return a}(l,t)),r)k(e,r);else if(l.objectMode||t&&t.length>0)if("string"==typeof t||l.objectMode||Object.getPrototypeOf(t)===i.prototype||(t=function(e){return i.from(e)}(t)),s)l.endEmitted?k(e,new v):P(e,l,t,!0);else if(l.ended)k(e,new y);else{if(l.destroyed)return!1;l.reading=!1,l.decoder&&!a?(t=l.decoder.write(t),l.objectMode||0!==t.length?P(e,l,t,!1):A(e,l)):P(e,l,t,!1)}else s||(l.reading=!1,A(e,l));return!l.ended&&(l.length<l.highWaterMark||0===l.length)}function P(e,t,a,s){t.flowing&&0===t.length&&!t.sync?(t.awaitDrain=0,e.emit("data",a)):(t.length+=t.objectMode?1:a.length,s?t.buffer.unshift(a):t.buffer.push(a),t.needReadable&&x(e)),A(e,t)}Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),E.prototype.destroy=h.destroy,E.prototype._undestroy=h.undestroy,E.prototype._destroy=function(e,t){t(e)},E.prototype.push=function(e,t){var a,s=this._readableState;return s.objectMode?a=!0:"string"==typeof e&&((t=t||s.defaultEncoding)!==s.encoding&&(e=i.from(e,t),t=""),a=!0),T(this,e,t,!1,a)},E.prototype.unshift=function(e){return T(this,e,null,!0,!1)},E.prototype.isPaused=function(){return!1===this._readableState.flowing},E.prototype.setEncoding=function(t){u||(u=e("string_decoder/").StringDecoder);var a=new u(t);this._readableState.decoder=a,this._readableState.encoding=this._readableState.decoder.encoding;for(var s=this._readableState.buffer.head,n="";null!==s;)n+=a.write(s.data),s=s.next;return this._readableState.buffer.clear(),""!==n&&this._readableState.buffer.push(n),this._readableState.length=n.length,this};var M=1073741824;function I(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=M?e=M:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function x(e){var t=e._readableState;c("emitReadable",t.needReadable,t.emittedReadable),t.needReadable=!1,t.emittedReadable||(c("emitReadable",t.flowing),t.emittedReadable=!0,a.nextTick(C,e))}function C(e){var t=e._readableState;c("emitReadable_",t.destroyed,t.length,t.ended),t.destroyed||!t.length&&!t.ended||(e.emit("readable"),t.emittedReadable=!1),t.needReadable=!t.flowing&&!t.ended&&t.length<=t.highWaterMark,$(e)}function A(e,t){t.readingMore||(t.readingMore=!0,a.nextTick(j,e,t))}function j(e,t){for(;!t.reading&&!t.ended&&(t.length<t.highWaterMark||t.flowing&&0===t.length);){var a=t.length;if(c("maybeReadMore read 0"),e.read(0),a===t.length)break}t.readingMore=!1}function R(e){var t=e._readableState;t.readableListening=e.listenerCount("readable")>0,t.resumeScheduled&&!t.paused?t.flowing=!0:e.listenerCount("data")>0&&e.resume()}function O(e){c("readable nexttick read 0"),e.read(0)}function N(e,t){c("resume",t.reading),t.reading||e.read(0),t.resumeScheduled=!1,e.emit("resume"),$(e),t.flowing&&!t.reading&&e.read(0)}function $(e){var t=e._readableState;for(c("flow",t.flowing);t.flowing&&null!==e.read(););}function D(e,t){return 0===t.length?null:(t.objectMode?a=t.buffer.shift():!e||e>=t.length?(a=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.first():t.buffer.concat(t.length),t.buffer.clear()):a=t.buffer.consume(e,t.decoder),a);var a}function B(e){var t=e._readableState;c("endReadable",t.endEmitted),t.endEmitted||(t.ended=!0,a.nextTick(L,t,e))}function L(e,t){if(c("endReadableNT",e.endEmitted,e.length),!e.endEmitted&&0===e.length&&(e.endEmitted=!0,t.readable=!1,t.emit("end"),e.autoDestroy)){var a=t._writableState;(!a||a.autoDestroy&&a.finished)&&t.destroy()}}function F(e,t){for(var a=0,s=e.length;a<s;a++)if(e[a]===t)return a;return-1}E.prototype.read=function(e){c("read",e),e=parseInt(e,10);var t=this._readableState,a=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&((0!==t.highWaterMark?t.length>=t.highWaterMark:t.length>0)||t.ended))return c("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?B(this):x(this),null;if(0===(e=I(e,t))&&t.ended)return 0===t.length&&B(this),null;var s,n=t.needReadable;return c("need readable",n),(0===t.length||t.length-e<t.highWaterMark)&&c("length less than watermark",n=!0),t.ended||t.reading?c("reading or ended",n=!1):n&&(c("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=I(a,t))),null===(s=e>0?D(e,t):null)?(t.needReadable=t.length<=t.highWaterMark,e=0):(t.length-=e,t.awaitDrain=0),0===t.length&&(t.ended||(t.needReadable=!0),a!==e&&t.ended&&B(this)),null!==s&&this.emit("data",s),s},E.prototype._read=function(e){k(this,new w("_read()"))},E.prototype.pipe=function(e,t){var s=this,r=this._readableState;switch(r.pipesCount){case 0:r.pipes=e;break;case 1:r.pipes=[r.pipes,e];break;default:r.pipes.push(e)}r.pipesCount+=1,c("pipe count=%d opts=%j",r.pipesCount,t);var i=(!t||!1!==t.end)&&e!==a.stdout&&e!==a.stderr?l:b;function o(t,a){c("onunpipe"),t===s&&a&&!1===a.hasUnpiped&&(a.hasUnpiped=!0,c("cleanup"),e.removeListener("close",h),e.removeListener("finish",f),e.removeListener("drain",u),e.removeListener("error",p),e.removeListener("unpipe",o),s.removeListener("end",l),s.removeListener("end",b),s.removeListener("data",m),d=!0,!r.awaitDrain||e._writableState&&!e._writableState.needDrain||u())}function l(){c("onend"),e.end()}r.endEmitted?a.nextTick(i):s.once("end",i),e.on("unpipe",o);var u=function(e){return function(){var t=e._readableState;c("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&n(e,"data")&&(t.flowing=!0,$(e))}}(s);e.on("drain",u);var d=!1;function m(t){c("ondata");var a=e.write(t);c("dest.write",a),!1===a&&((1===r.pipesCount&&r.pipes===e||r.pipesCount>1&&-1!==F(r.pipes,e))&&!d&&(c("false write response, pause",r.awaitDrain),r.awaitDrain++),s.pause())}function p(t){c("onerror",t),b(),e.removeListener("error",p),0===n(e,"error")&&k(e,t)}function h(){e.removeListener("finish",f),b()}function f(){c("onfinish"),e.removeListener("close",h),b()}function b(){c("unpipe"),s.unpipe(e)}return s.on("data",m),function(e,t,a){if("function"==typeof e.prependListener)return e.prependListener(t,a);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(a):e._events[t]=[a,e._events[t]]:e.on(t,a)}(e,"error",p),e.once("close",h),e.once("finish",f),e.emit("pipe",s),r.flowing||(c("pipe resume"),s.resume()),e},E.prototype.unpipe=function(e){var t=this._readableState,a={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,a)),this;if(!e){var s=t.pipes,n=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var r=0;r<n;r++)s[r].emit("unpipe",this,{hasUnpiped:!1});return this}var i=F(t.pipes,e);return-1===i||(t.pipes.splice(i,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,a)),this},E.prototype.on=function(e,t){var s=r.prototype.on.call(this,e,t),n=this._readableState;return"data"===e?(n.readableListening=this.listenerCount("readable")>0,!1!==n.flowing&&this.resume()):"readable"===e&&(n.endEmitted||n.readableListening||(n.readableListening=n.needReadable=!0,n.flowing=!1,n.emittedReadable=!1,c("on readable",n.length,n.reading),n.length?x(this):n.reading||a.nextTick(O,this))),s},E.prototype.addListener=E.prototype.on,E.prototype.removeListener=function(e,t){var s=r.prototype.removeListener.call(this,e,t);return"readable"===e&&a.nextTick(R,this),s},E.prototype.removeAllListeners=function(e){var t=r.prototype.removeAllListeners.apply(this,arguments);return"readable"!==e&&e!==undefined||a.nextTick(R,this),t},E.prototype.resume=function(){var e=this._readableState;return e.flowing||(c("resume"),e.flowing=!e.readableListening,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,a.nextTick(N,e,t))}(this,e)),e.paused=!1,this},E.prototype.pause=function(){return c("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(c("pause"),this._readableState.flowing=!1,this.emit("pause")),this._readableState.paused=!0,this},E.prototype.wrap=function(e){var t=this,a=this._readableState,s=!1;for(var n in e.on("end",function(){if(c("wrapped end"),a.decoder&&!a.ended){var e=a.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(n){(c("wrapped data"),a.decoder&&(n=a.decoder.write(n)),!a.objectMode||null!==n&&n!==undefined)&&((a.objectMode||n&&n.length)&&(t.push(n)||(s=!0,e.pause())))}),e)this[n]===undefined&&"function"==typeof e[n]&&(this[n]=function(t){return function(){return e[t].apply(e,arguments)}}(n));for(var r=0;r<_.length;r++)e.on(_[r],this.emit.bind(this,_[r]));return this._read=function(t){c("wrapped _read",t),s&&(s=!1,e.resume())},this},"function"==typeof Symbol&&(E.prototype[Symbol.asyncIterator]=function(){return d===undefined&&(d=e("./internal/streams/async_iterator")),d(this)}),Object.defineProperty(E.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),Object.defineProperty(E.prototype,"readableBuffer",{enumerable:!1,get:function(){return this._readableState&&this._readableState.buffer}}),Object.defineProperty(E.prototype,"readableFlowing",{enumerable:!1,get:function(){return this._readableState.flowing},set:function(e){this._readableState&&(this._readableState.flowing=e)}}),E._fromList=D,Object.defineProperty(E.prototype,"readableLength",{enumerable:!1,get:function(){return this._readableState.length}}),"function"==typeof Symbol&&(E.from=function(t,a){return m===undefined&&(m=e("./internal/streams/from")),m(E,t,a)})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_readable.js"}],[2796,{"../errors":2792,"./_stream_duplex":2793,inherits:5025},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=u;var s=e("../errors").codes,n=s.ERR_METHOD_NOT_IMPLEMENTED,r=s.ERR_MULTIPLE_CALLBACK,i=s.ERR_TRANSFORM_ALREADY_TRANSFORMING,o=s.ERR_TRANSFORM_WITH_LENGTH_0,c=e("./_stream_duplex");function l(e,t){var a=this._transformState;a.transforming=!1;var s=a.writecb;if(null===s)return this.emit("error",new r);a.writechunk=null,a.writecb=null,null!=t&&this.push(t),s(e);var n=this._readableState;n.reading=!1,(n.needReadable||n.length<n.highWaterMark)&&this._read(n.highWaterMark)}function u(e){if(!(this instanceof u))return new u(e);c.call(this,e),this._transformState={afterTransform:l.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",d)}function d(){var e=this;"function"!=typeof this._flush||this._readableState.destroyed?m(this,null,null):this._flush(function(t,a){m(e,t,a)})}function m(e,t,a){if(t)return e.emit("error",t);if(null!=a&&e.push(a),e._writableState.length)throw new o;if(e._transformState.transforming)throw new i;return e.push(null)}e("inherits")(u,c),u.prototype.push=function(e,t){return this._transformState.needTransform=!1,c.prototype.push.call(this,e,t)},u.prototype._transform=function(e,t,a){a(new n("_transform()"))},u.prototype._write=function(e,t,a){var s=this._transformState;if(s.writecb=a,s.writechunk=e,s.writeencoding=t,!s.transforming){var n=this._readableState;(s.needTransform||n.needReadable||n.length<n.highWaterMark)&&this._read(n.highWaterMark)}},u.prototype._read=function(e){var t=this._transformState;null===t.writechunk||t.transforming?t.needTransform=!0:(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform))},u.prototype._destroy=function(e,t){c.prototype._destroy.call(this,e,function(e){t(e)})}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_transform.js"}],[2797,{"../errors":2792,"./_stream_duplex":2793,"./internal/streams/destroy":2800,"./internal/streams/state":2804,"./internal/streams/stream":2805,_process:5498,buffer:4473,inherits:5025,"util-deprecate":6139},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){function s(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t,a){var s=e.entry;e.entry=null;for(;s;){var n=s.callback;t.pendingcb--,n(a),s=s.next}t.corkedRequestsFree.next=e}(t,e)}}var n;t.exports=E,E.WritableState=S;var r={deprecate:e("util-deprecate")},i=e("./internal/streams/stream"),o=e("buffer").Buffer,c=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var l,u=e("./internal/streams/destroy"),d=e("./internal/streams/state").getHighWaterMark,m=e("../errors").codes,p=m.ERR_INVALID_ARG_TYPE,h=m.ERR_METHOD_NOT_IMPLEMENTED,f=m.ERR_MULTIPLE_CALLBACK,b=m.ERR_STREAM_CANNOT_PIPE,g=m.ERR_STREAM_DESTROYED,y=m.ERR_STREAM_NULL_VALUES,w=m.ERR_STREAM_WRITE_AFTER_END,v=m.ERR_UNKNOWN_ENCODING,k=u.errorOrDestroy;function _(){}function S(t,r,i){n=n||e("./_stream_duplex"),t=t||{},"boolean"!=typeof i&&(i=r instanceof n),this.objectMode=!!t.objectMode,i&&(this.objectMode=this.objectMode||!!t.writableObjectMode),this.highWaterMark=d(this,t,"writableHighWaterMark",i),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var o=!1===t.decodeStrings;this.decodeStrings=!o,this.defaultEncoding=t.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var s=e._writableState,n=s.sync,r=s.writecb;if("function"!=typeof r)throw new f;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(s),t)!function(e,t,s,n,r){--t.pendingcb,s?(a.nextTick(r,n),a.nextTick(C,e,t),e._writableState.errorEmitted=!0,k(e,n)):(r(n),e._writableState.errorEmitted=!0,k(e,n),C(e,t))}(e,s,n,t,r);else{var i=I(s)||e.destroyed;i||s.corked||s.bufferProcessing||!s.bufferedRequest||M(e,s),n?a.nextTick(P,e,s,i,r):P(e,s,i,r)}}(r,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.bufferedRequestCount=0,this.corkedRequestsFree=new s(this)}function E(t){var a=this instanceof(n=n||e("./_stream_duplex"));if(!a&&!l.call(E,this))return new E(t);this._writableState=new S(t,this,a),this.writable=!0,t&&("function"==typeof t.write&&(this._write=t.write),"function"==typeof t.writev&&(this._writev=t.writev),"function"==typeof t.destroy&&(this._destroy=t.destroy),"function"==typeof t.final&&(this._final=t.final)),i.call(this)}function T(e,t,a,s,n,r,i){t.writelen=s,t.writecb=i,t.writing=!0,t.sync=!0,t.destroyed?t.onwrite(new g("write")):a?e._writev(n,t.onwrite):e._write(n,r,t.onwrite),t.sync=!1}function P(e,t,a,s){a||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,s(),C(e,t)}function M(e,t){t.bufferProcessing=!0;var a=t.bufferedRequest;if(e._writev&&a&&a.next){var n=t.bufferedRequestCount,r=new Array(n),i=t.corkedRequestsFree;i.entry=a;for(var o=0,c=!0;a;)r[o]=a,a.isBuf||(c=!1),a=a.next,o+=1;r.allBuffers=c,T(e,t,!0,t.length,r,"",i.finish),t.pendingcb++,t.lastBufferedRequest=null,i.next?(t.corkedRequestsFree=i.next,i.next=null):t.corkedRequestsFree=new s(t),t.bufferedRequestCount=0}else{for(;a;){var l=a.chunk,u=a.encoding,d=a.callback;if(T(e,t,!1,t.objectMode?1:l.length,l,u,d),a=a.next,t.bufferedRequestCount--,t.writing)break}null===a&&(t.lastBufferedRequest=null)}t.bufferedRequest=a,t.bufferProcessing=!1}function I(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function x(e,t){e._final(function(a){t.pendingcb--,a&&k(e,a),t.prefinished=!0,e.emit("prefinish"),C(e,t)})}function C(e,t){var s=I(t);if(s&&(function(e,t){t.prefinished||t.finalCalled||("function"!=typeof e._final||t.destroyed?(t.prefinished=!0,e.emit("prefinish")):(t.pendingcb++,t.finalCalled=!0,a.nextTick(x,e,t)))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"),t.autoDestroy))){var n=e._readableState;(!n||n.autoDestroy&&n.endEmitted)&&e.destroy()}return s}e("inherits")(E,i),S.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(S.prototype,"buffer",{get:r.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(l=Function.prototype[Symbol.hasInstance],Object.defineProperty(E,Symbol.hasInstance,{value:function(e){return!!l.call(this,e)||this===E&&(e&&e._writableState instanceof S)}})):l=function(e){return e instanceof this},E.prototype.pipe=function(){k(this,new b)},E.prototype.write=function(e,t,s){var n,r=this._writableState,i=!1,l=!r.objectMode&&(n=e,o.isBuffer(n)||n instanceof c);return l&&!o.isBuffer(e)&&(e=function(e){return o.from(e)}(e)),"function"==typeof t&&(s=t,t=null),l?t="buffer":t||(t=r.defaultEncoding),"function"!=typeof s&&(s=_),r.ending?function(e,t){var s=new w;k(e,s),a.nextTick(t,s)}(this,s):(l||function(e,t,s,n){var r;return null===s?r=new y:"string"==typeof s||t.objectMode||(r=new p("chunk",["string","Buffer"],s)),!r||(k(e,r),a.nextTick(n,r),!1)}(this,r,e,s))&&(r.pendingcb++,i=function(e,t,a,s,n,r){if(!a){var i=function(e,t,a){e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=o.from(t,a));return t}(t,s,n);s!==i&&(a=!0,n="buffer",s=i)}var c=t.objectMode?1:s.length;t.length+=c;var l=t.length<t.highWaterMark;l||(t.needDrain=!0);if(t.writing||t.corked){var u=t.lastBufferedRequest;t.lastBufferedRequest={chunk:s,encoding:n,isBuf:a,callback:r,next:null},u?u.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else T(e,t,!1,c,s,n,r);return l}(this,r,l,e,t,s)),i},E.prototype.cork=function(){this._writableState.corked++},E.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||M(this,e))},E.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new v(e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(E.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(E.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),E.prototype._write=function(e,t,a){a(new h("_write()"))},E.prototype._writev=null,E.prototype.end=function(e,t,s){var n=this._writableState;return"function"==typeof e?(s=e,e=null,t=null):"function"==typeof t&&(s=t,t=null),null!==e&&e!==undefined&&this.write(e,t),n.corked&&(n.corked=1,this.uncork()),n.ending||function(e,t,s){t.ending=!0,C(e,t),s&&(t.finished?a.nextTick(s):e.once("finish",s));t.ended=!0,e.writable=!1}(this,n,s),this},Object.defineProperty(E.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._writableState!==undefined&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),E.prototype.destroy=u.destroy,E.prototype._undestroy=u.undestroy,E.prototype._destroy=function(e,t){t(e)}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_writable.js"}],[2798,{"./end-of-stream":2801,_process:5498},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){var s;function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var a=e[Symbol.toPrimitive];if(a!==undefined){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}var r=e("./end-of-stream"),i=Symbol("lastResolve"),o=Symbol("lastReject"),c=Symbol("error"),l=Symbol("ended"),u=Symbol("lastPromise"),d=Symbol("handlePromise"),m=Symbol("stream");function p(e,t){return{value:e,done:t}}function h(e){var t=e[i];if(null!==t){var a=e[m].read();null!==a&&(e[u]=null,e[i]=null,e[o]=null,t(p(a,!1)))}}function f(e){a.nextTick(h,e)}var b=Object.getPrototypeOf(function(){}),g=Object.setPrototypeOf((n(s={get stream(){return this[m]},next:function(){var e=this,t=this[c];if(null!==t)return Promise.reject(t);if(this[l])return Promise.resolve(p(undefined,!0));if(this[m].destroyed)return new Promise(function(t,s){a.nextTick(function(){e[c]?s(e[c]):t(p(undefined,!0))})});var s,n=this[u];if(n)s=new Promise(function(e,t){return function(a,s){e.then(function(){t[l]?a(p(undefined,!0)):t[d](a,s)},s)}}(n,this));else{var r=this[m].read();if(null!==r)return Promise.resolve(p(r,!1));s=new Promise(this[d])}return this[u]=s,s}},Symbol.asyncIterator,function(){return this}),n(s,"return",function(){var e=this;return new Promise(function(t,a){e[m].destroy(null,function(e){e?a(e):t(p(undefined,!0))})})}),s),b);t.exports=function(e){var t,a=Object.create(g,(n(t={},m,{value:e,writable:!0}),n(t,i,{value:null,writable:!0}),n(t,o,{value:null,writable:!0}),n(t,c,{value:null,writable:!0}),n(t,l,{value:e._readableState.endEmitted,writable:!0}),n(t,d,{value:function(e,t){var s=a[m].read();s?(a[u]=null,a[i]=null,a[o]=null,e(p(s,!1))):(a[i]=e,a[o]=t)},writable:!0}),t));return a[u]=null,r(e,function(e){if(e&&"ERR_STREAM_PREMATURE_CLOSE"!==e.code){var t=a[o];return null!==t&&(a[u]=null,a[i]=null,a[o]=null,t(e)),void(a[c]=e)}var s=a[i];null!==s&&(a[u]=null,a[i]=null,a[o]=null,s(p(undefined,!0))),a[l]=!0}),e.on("readable",f.bind(null,a)),a}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/async_iterator.js"}],[2799,{buffer:4473,util:4425},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t){var a=Object.keys(e);if(Object.getOwnPropertySymbols){var s=Object.getOwnPropertySymbols(e);t&&(s=s.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),a.push.apply(a,s)}return a}function n(e){for(var t=1;t<arguments.length;t++){var a=null!=arguments[t]?arguments[t]:{};t%2?s(Object(a),!0).forEach(function(t){r(e,t,a[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(a)):s(Object(a)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(a,t))})}return e}function r(e,t,a){return(t=o(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t){for(var a=0;a<t.length;a++){var s=t[a];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,o(s.key),s)}}function o(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var a=e[Symbol.toPrimitive];if(a!==undefined){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}var c=e("buffer").Buffer,l=e("util").inspect,u=l&&l.custom||"inspect";function d(e,t,a){c.prototype.copy.call(e,t,a)}t.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}var t,a,s;return t=e,(a=[{key:"push",value:function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length}},{key:"unshift",value:function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length}},{key:"shift",value:function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}}},{key:"clear",value:function(){this.head=this.tail=null,this.length=0}},{key:"join",value:function(e){if(0===this.length)return"";for(var t=this.head,a=""+t.data;t=t.next;)a+=e+t.data;return a}},{key:"concat",value:function(e){if(0===this.length)return c.alloc(0);for(var t=c.allocUnsafe(e>>>0),a=this.head,s=0;a;)d(a.data,t,s),s+=a.data.length,a=a.next;return t}},{key:"consume",value:function(e,t){var a;return e<this.head.data.length?(a=this.head.data.slice(0,e),this.head.data=this.head.data.slice(e)):a=e===this.head.data.length?this.shift():t?this._getString(e):this._getBuffer(e),a}},{key:"first",value:function(){return this.head.data}},{key:"_getString",value:function(e){var t=this.head,a=1,s=t.data;for(e-=s.length;t=t.next;){var n=t.data,r=e>n.length?n.length:e;if(r===n.length?s+=n:s+=n.slice(0,e),0===(e-=r)){r===n.length?(++a,t.next?this.head=t.next:this.head=this.tail=null):(this.head=t,t.data=n.slice(r));break}++a}return this.length-=a,s}},{key:"_getBuffer",value:function(e){var t=c.allocUnsafe(e),a=this.head,s=1;for(a.data.copy(t),e-=a.data.length;a=a.next;){var n=a.data,r=e>n.length?n.length:e;if(n.copy(t,t.length-e,0,r),0===(e-=r)){r===n.length?(++s,a.next?this.head=a.next:this.head=this.tail=null):(this.head=a,a.data=n.slice(r));break}++s}return this.length-=s,t}},{key:u,value:function(e,t){return l(this,n(n({},t),{},{depth:0,customInspect:!1}))}}])&&i(t.prototype,a),s&&i(t,s),Object.defineProperty(t,"prototype",{writable:!1}),e}()}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/buffer_list.js"}],[28,{"../../controllers/network-order":235},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.NetworkOrderControllerInit=void 0;var s=e("../../controllers/network-order");a.NetworkOrderControllerInit=({controllerMessenger:e,persistedState:t})=>({controller:new s.NetworkOrderController({messenger:e,state:{orderedNetworkList:[],...t.NetworkOrderController}})})}}},{package:"$root$",file:"app/scripts/controller-init/assets/network-order-controller-init.ts"}],[280,{"../../../shared/constants/app":6184,"../../../shared/lib/trace":6307},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(){return async function(e,t,a){const{id:s,method:o}=e,c=r[o];c&&(e.traceContext=await(0,n.trace)({name:c,id:s,tags:i[o]}),await(0,n.trace)({name:n.TraceName.Middleware,id:s,parentContext:e.traceContext})),a()}};var s=e("../../../shared/constants/app"),n=e("../../../shared/lib/trace");const r={[s.MESSAGE_TYPE.ETH_SEND_TRANSACTION]:n.TraceName.Transaction,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:n.TraceName.Signature,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1]:n.TraceName.Signature,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:n.TraceName.Signature,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:n.TraceName.Signature,[s.MESSAGE_TYPE.PERSONAL_SIGN]:n.TraceName.Signature},i={[s.MESSAGE_TYPE.ETH_SEND_TRANSACTION]:{source:"dapp"}}}}},{package:"$root$",file:"app/scripts/lib/createTracingMiddleware.ts"}],[2800,{_process:5498},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(e){(function(){function a(e,t){n(e,t),s(e)}function s(e){e._writableState&&!e._writableState.emitClose||e._readableState&&!e._readableState.emitClose||e.emit("close")}function n(e,t){e.emit("error",t)}t.exports={destroy:function(t,r){var i=this,o=this._readableState&&this._readableState.destroyed,c=this._writableState&&this._writableState.destroyed;return o||c?(r?r(t):t&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,e.nextTick(n,this,t)):e.nextTick(n,this,t)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(t||null,function(t){!r&&t?i._writableState?i._writableState.errorEmitted?e.nextTick(s,i):(i._writableState.errorEmitted=!0,e.nextTick(a,i,t)):e.nextTick(a,i,t):r?(e.nextTick(s,i),r(t)):e.nextTick(s,i)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)},errorOrDestroy:function(e,t){var a=e._readableState,s=e._writableState;a&&a.autoDestroy||s&&s.autoDestroy?e.destroy(t):e.emit("error",t)}}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/destroy.js"}],[2801,{"../../../errors":2792},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=e("../../../errors").codes.ERR_STREAM_PREMATURE_CLOSE;function n(){}t.exports=function e(t,a,r){if("function"==typeof a)return e(t,null,a);a||(a={}),r=function(e){var t=!1;return function(){if(!t){t=!0;for(var a=arguments.length,s=new Array(a),n=0;n<a;n++)s[n]=arguments[n];e.apply(this,s)}}}(r||n);var i=a.readable||!1!==a.readable&&t.readable,o=a.writable||!1!==a.writable&&t.writable,c=function(){t.writable||u()},l=t._writableState&&t._writableState.finished,u=function(){o=!1,l=!0,i||r.call(t)},d=t._readableState&&t._readableState.endEmitted,m=function(){i=!1,d=!0,o||r.call(t)},p=function(e){r.call(t,e)},h=function(){var e;return i&&!d?(t._readableState&&t._readableState.ended||(e=new s),r.call(t,e)):o&&!l?(t._writableState&&t._writableState.ended||(e=new s),r.call(t,e)):void 0},f=function(){t.req.on("finish",u)};return!function(e){return e.setHeader&&"function"==typeof e.abort}(t)?o&&!t._writableState&&(t.on("end",c),t.on("close",c)):(t.on("complete",u),t.on("abort",h),t.req?f():t.on("request",f)),t.on("end",m),t.on("finish",u),!1!==a.error&&t.on("error",p),t.on("close",h),function(){t.removeListener("complete",u),t.removeListener("abort",h),t.removeListener("request",f),t.req&&t.req.removeListener("finish",u),t.removeListener("end",c),t.removeListener("close",c),t.removeListener("finish",u),t.removeListener("end",m),t.removeListener("error",p),t.removeListener("close",h)}}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"}],[2802,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=function(){throw new Error("Readable.from is not available in the browser")}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/from-browser.js"}],[2803,{"../../../errors":2792,"./end-of-stream":2801},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;var n=e("../../../errors").codes,r=n.ERR_MISSING_ARGS,i=n.ERR_STREAM_DESTROYED;function o(e){if(e)throw e}function c(e){e()}function l(e,t){return e.pipe(t)}t.exports=function(){for(var t=arguments.length,a=new Array(t),n=0;n<t;n++)a[n]=arguments[n];var u,d=function(e){return e.length?"function"!=typeof e[e.length-1]?o:e.pop():o}(a);if(Array.isArray(a[0])&&(a=a[0]),a.length<2)throw new r("streams");var m=a.map(function(t,n){var r=n<a.length-1;return function(t,a,n,r){r=function(e){var t=!1;return function(){t||(t=!0,e.apply(void 0,arguments))}}(r);var o=!1;t.on("close",function(){o=!0}),s===undefined&&(s=e("./end-of-stream")),s(t,{readable:a,writable:n},function(e){if(e)return r(e);o=!0,r()});var c=!1;return function(e){if(!o&&!c)return c=!0,function(e){return e.setHeader&&"function"==typeof e.abort}(t)?t.abort():"function"==typeof t.destroy?t.destroy():void r(e||new i("pipe"))}}(t,r,n>0,function(e){u||(u=e),e&&m.forEach(c),r||(m.forEach(c),d(u))})});return a.reduce(l)}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/pipeline.js"}],[2804,{"../../../errors":2792},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=e("../../../errors").codes.ERR_INVALID_OPT_VALUE;t.exports={getHighWaterMark:function(e,t,a,n){var r=function(e,t,a){return null!=e.highWaterMark?e.highWaterMark:t?e[a]:null}(t,n,a);if(null!=r){if(!isFinite(r)||Math.floor(r)!==r||r<0)throw new s(n?a:"highWaterMark",r);return Math.floor(r)}return e.objectMode?16:16384}}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/state.js"}],[2805,{events:4769},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=e("events").EventEmitter}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/stream-browser.js"}],[2806,{"./lib/_stream_duplex.js":2793,"./lib/_stream_passthrough.js":2794,"./lib/_stream_readable.js":2795,"./lib/_stream_transform.js":2796,"./lib/_stream_writable.js":2797,"./lib/internal/streams/end-of-stream.js":2801,"./lib/internal/streams/pipeline.js":2803},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(a=t.exports=e("./lib/_stream_readable.js")).Stream=a,a.Readable=a,a.Writable=e("./lib/_stream_writable.js"),a.Duplex=e("./lib/_stream_duplex.js"),a.Transform=e("./lib/_stream_transform.js"),a.PassThrough=e("./lib/_stream_passthrough.js"),a.finished=e("./lib/internal/streams/end-of-stream.js"),a.pipeline=e("./lib/internal/streams/pipeline.js")}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/readable-browser.js"}],[281,{"./dapp-swap-util":282},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createDappSwapMiddleware=function({fetchQuotes:e,setDappSwapComparisonData:t,getNetworkConfigurationByNetworkClientId:a,dappSwapMetricsFlag:n}){return async(r,i,o)=>{"eth_sendTransaction"!==r.method&&"wallet_sendCalls"!==r.method||(0,s.getQuotesForConfirmation)({req:r,fetchQuotes:e,setDappSwapComparisonData:t,getNetworkConfigurationByNetworkClientId:a,dappSwapMetricsFlag:n}),o()}};var s=e("./dapp-swap-util")}}},{package:"$root$",file:"app/scripts/lib/dapp-swap/dapp-swap-middleware.ts"}],[2819,{"./enums.cjs":2820,"@metamask/base-controller":1506,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,u,d,m=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},p=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PermissionLogController=void 0;const h=e("@metamask/base-controller"),f=e("@metamask/utils"),b=e("./enums.cjs"),g={permissionHistory:{},permissionActivityLog:[]};class y extends h.BaseController{constructor({messenger:e,restrictedMethods:t,state:a}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},permissionActivityLog:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!1}},state:{...g,...a}}),s.add(this),n.set(this,void 0),m(this,n,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const a={eth_accounts:{accounts:p(this,s,"m",r).call(this,t,Date.now())}};p(this,s,"m",l).call(this,e,a)}createMiddleware(){return(e,t,a)=>{const{origin:r,method:l}=e,d=l.startsWith(b.WALLET_PREFIX),m="eth_requestAccounts"===l;if(!b.LOG_IGNORE_METHODS.includes(l)&&(d||p(this,n,"f").has(l))||m){const n=p(this,s,"m",i).call(this,e,d),l=p(this,s,"m",u).call(this,e);return void a(e=>{const a=Date.now();p(this,s,"m",o).call(this,n,t,a),l&&!t.error&&t.result&&r&&p(this,s,"m",c).call(this,l,r,t.result,a,m),e()})}a()}}}a.PermissionLogController=y,n=new WeakMap,s=new WeakSet,r=function(e,t){return e.reduce((e,a)=>({...e,[a]:t}),{})},i=function(e,t){const a={id:e.id,method:e.method,methodType:t?b.LOG_METHOD_TYPES.internal:b.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update(e=>{const t=[...e.permissionActivityLog,a];e.permissionActivityLog=t.length>b.LOG_LIMIT?t.slice(1):t}),a},o=function(e,t,a){e&&t&&this.update(s=>{s.permissionActivityLog=s.permissionActivityLog.map(s=>s.id===e.id?{...s,success:(0,f.hasProperty)(t,"result"),responseTime:a}:s)})},c=function(e,t,a,n,i){let o;if(i){const e=a;o={eth_accounts:{accounts:p(this,s,"m",r).call(this,e,n),lastApproved:n}}}else{o=a.reduce((t,a)=>{const i=a.parentCapability;if(!e.includes(i))return t;if("eth_accounts"===i){const e=p(this,s,"m",d).call(this,a);return{...t,[i]:{lastApproved:n,accounts:p(this,s,"m",r).call(this,e,n)}}}return{...t,[i]:{lastApproved:n}}},{})}Object.keys(o).length>0&&p(this,s,"m",l).call(this,t,o)},l=function(e,t){const{permissionHistory:a}=this.state,s=a[e]??{},n={...s,...t},r=s.eth_accounts,i=t.eth_accounts;if(r&&i){const e=i.lastApproved??r.lastApproved;n.eth_accounts={lastApproved:e,accounts:{...r.accounts,...i.accounts}}}this.update(t=>{t.permissionHistory={...a,[e]:n}})},u=function(e){const{method:t,params:a}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${b.WALLET_PREFIX}requestPermissions`&&a&&Array.isArray(a)&&a[0]&&"object"==typeof a[0]&&!Array.isArray(a[0])?Object.keys(a[0]):null},d=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const a of e.caveats)if(a.type===b.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(a.value))for(const e of a.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],[282,{"../../../../shared/lib/sentry":6300,"../../../../shared/modules/dapp-swap-comparison/dapp-swap-command-utils":6324,"../../../../shared/modules/dapp-swap-comparison/dapp-swap-comparison-utils":6325,loglevel:5255},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getQuotesForConfirmation=function({req:e,fetchQuotes:t,setDappSwapComparisonData:a,getNetworkConfigurationByNetworkClientId:s,dappSwapMetricsFlag:l}){let u="";const d=String(e.id);try{const{enabled:o,bridge_quote_fees:m,origins:p}=l;if(!o)return;const{params:h,origin:f}=e;if(f&&p.includes(f)){const{chainId:o}=s(e.networkClientId)??{},{data:l,from:p}=c(h);if(l&&d&&o){const e=(0,i.parseTransactionData)(l);u=e.commands;const{quotesInput:s,amountMin:c}=(0,i.getDataFromSwap)(o,e.commandBytes,e.inputs);if(s){(0,i.checkValidSingleOrBatchTransaction)(h[0].calls,null==s?void 0:s.srcTokenAddress),a(d,{commands:u,swapInfo:{srcTokenAddress:null==s?void 0:s.srcTokenAddress,destTokenAddress:null==s?void 0:s.destTokenAddress,srcTokenAmount:null==s?void 0:s.srcTokenAmount,destTokenAmountMin:c}});const e=(new Date).getTime();t({...s,walletAddress:p,fee:m}).then(t=>{const s=(new Date).getTime();t&&a(d,{quotes:t,latency:s-e})}).catch(e=>{a(d,{error:`Error fetching bridge quotes: ${e.message}`,commands:u}),n.default.error("Error fetching dapp swap quotes",e),(0,r.captureException)(e)})}}}}catch(e){d&&a(d,{error:`Error fetching bridge quotes: ${e.message}`,commands:u}),e instanceof o.DappSwapDecodingError||(0,r.captureException)(e)}};var s,n=(s=e("loglevel"))&&s.__esModule?s:{default:s},r=e("../../../../shared/lib/sentry"),i=e("../../../../shared/modules/dapp-swap-comparison/dapp-swap-comparison-utils"),o=e("../../../../shared/modules/dapp-swap-comparison/dapp-swap-command-utils");const c=e=>{if(null==e||!e.length)return{data:undefined,from:undefined,chainId:undefined};const{calls:t,chainId:a,data:s,from:n}=e[0];let r=s;if(null!=t&&t.length){const e=null==t?void 0:t.find(({data:e})=>null==e?void 0:e.startsWith("0x3593564c"));e&&(r=null==e?void 0:e.data)}return{chainId:a,data:r,from:n}}}}},{package:"$root$",file:"app/scripts/lib/dapp-swap/dapp-swap-util.ts"}],[2820,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;Object.defineProperty(a,"__esModule",{value:!0}),a.LOG_LIMIT=a.LOG_METHOD_TYPES=a.LOG_IGNORE_METHODS=a.CAVEAT_TYPES=a.WALLET_PREFIX=void 0,a.WALLET_PREFIX="wallet_",a.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),a.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(s||(a.LOG_METHOD_TYPES=s={})),a.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],[2821,{"./PermissionLogController.cjs":2819},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.PermissionLogController=void 0;var s=e("./PermissionLogController.cjs");Object.defineProperty(a,"PermissionLogController",{enumerable:!0,get:function(){return s.PermissionLogController}})}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],[283,{"../../../../shared/lib/deep-links/constants":6238,"../../../../shared/lib/deep-links/parse":6240,"../../../../shared/lib/deep-links/routes/route":6252,"../../../../shared/lib/deep-links/verify":6256,"../../../../shared/modules/mv3.utils":6335,events:4769,loglevel:5255,"webextension-polyfill":6172},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.DeepLinkRouter=void 0;var s=d(e("events")),n=d(e("webextension-polyfill")),r=d(e("loglevel")),i=e("../../../../shared/modules/mv3.utils"),o=e("../../../../shared/lib/deep-links/parse"),c=e("../../../../shared/lib/deep-links/constants"),l=e("../../../../shared/lib/deep-links/routes/route"),u=e("../../../../shared/lib/deep-links/verify");function d(e){return e&&e.__esModule?e:{default:e}}function m(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}const p=l.DEEP_LINK_ROUTE.replace(/^\//u,"");class h extends s.default{constructor({getExtensionURL:e,getState:t}){super(),m(this,"getExtensionURL",void 0),m(this,"getState",void 0),m(this,"handleBeforeRequest",({tabId:e,url:t})=>e===n.default.tabs.TAB_ID_NONE?{}:this.tryNavigateTo(e,t)),this.getExtensionURL=e,this.getState=t}formatUrlForInterstitialPage(e){return e.pathname+e.search}get404ErrorURL(e){const t=new URLSearchParams({errorCode:"404"});return e&&t.set("u",this.formatUrlForInterstitialPage(e)),this.getExtensionURL(p,t.toString())}async redirectTab(e,t){try{await n.default.tabs.update(e,{url:t})}catch(e){r.default.error("Error redirecting tab:",e),this.emit("error",e)}}install(){n.default.webRequest.onBeforeRequest.addListener(this.handleBeforeRequest,{urls:[`*://*.${c.DEEP_LINK_HOST}/*`],types:["main_frame"]},i.isManifestV3?[]:["blocking"])}uninstall(){n.default.webRequest.onBeforeRequest.removeListener(this.handleBeforeRequest)}async tryNavigateTo(e,t){if(t.length>c.DEEP_LINK_MAX_LENGTH)return r.default.debug("Url is too long, skipping deep link handling"),{};let a;try{const e=new URL(t),s=await(0,o.parse)(e);if(s)if(this.emit("navigate",{url:e,parsed:s}),"redirectTo"in s.destination)a=s.destination.redirectTo.toString();else if(this.canSkipInterstitial(s.signature))a=this.getExtensionURL(s.destination.path,s.destination.query.toString());else{const t=new URLSearchParams({u:this.formatUrlForInterstitialPage(e)});a=this.getExtensionURL(p,t.toString())}else a=this.get404ErrorURL(e)}catch(e){r.default.error("Invalid URL:",t,e),this.emit("error",e),a=this.get404ErrorURL()}return this.redirectTab(e,a),i.isManifestV3?{}:{cancel:!0}}canSkipInterstitial(e){var t;return e===u.VALID&&Boolean(null===(t=this.getState().preferences)||void 0===t?void 0:t.skipDeepLinkInterstitial)}}a.DeepLinkRouter=h}}},{package:"$root$",file:"app/scripts/lib/deep-links/deep-link-router.ts"}],[284,{"../../../../shared/constants/metametrics":6199},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createEvent=function({signature:e,url:t}){const a={route:t.pathname,signature:e},r={};for(const[e,s]of t.searchParams.entries())"sig"!==e&&("attributionId"===e?a.attribution_id=s:n.has(e)?a[e]=s:r[e]=s);return{category:s.MetaMetricsEventCategory.DeepLink,event:s.MetaMetricsEventName.DeepLinkUsed,properties:a,sensitiveProperties:r}};var s=e("../../../../shared/constants/metametrics");const n=new Set(["utm_campaign","utm_content","utm_medium","utm_source","utm_term"])}}},{package:"$root$",file:"app/scripts/lib/deep-links/metrics.ts"}],[285,{"@metamask/browser-passworder":1593},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.encryptorFactory=void 0;var s=e("@metamask/browser-passworder");const n=e=>async(t,a,n,r)=>(0,s.encrypt)(t,a,n,r,{algorithm:"PBKDF2",params:{iterations:e}}),r=e=>async(t,a,n)=>(0,s.encryptWithDetail)(t,a,n,{algorithm:"PBKDF2",params:{iterations:e}}),i=e=>async(t,a,n,r)=>(0,s.keyFromPassword)(t,a,n,r??{algorithm:"PBKDF2",params:{iterations:e}}),o=e=>t=>(0,s.isVaultUpdated)(t,{algorithm:"PBKDF2",params:{iterations:e}});a.encryptorFactory=e=>({encrypt:n(e),encryptWithKey:s.encryptWithKey,encryptWithDetail:r(e),decrypt:s.decrypt,decryptWithKey:s.decryptWithKey,decryptWithDetail:s.decryptWithDetail,keyFromPassword:i(e),isVaultUpdated:o(e),importKey:s.importKey,exportKey:s.exportKey,generateSalt:s.generateSalt})}}},{package:"$root$",file:"app/scripts/lib/encryptor-factory.ts"}],[286,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;a.default=[{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"resolver",outputs:[{name:"",type:"address"}],payable:!1,type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"owner",outputs:[{name:"",type:"address"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"label",type:"bytes32"},{name:"owner",type:"address"}],name:"setSubnodeOwner",outputs:[],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"ttl",type:"uint64"}],name:"setTTL",outputs:[],payable:!1,type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"ttl",outputs:[{name:"",type:"uint64"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"resolver",type:"address"}],name:"setResolver",outputs:[],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"owner",type:"address"}],name:"setOwner",outputs:[],payable:!1,type:"function"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"owner",type:"address"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!0,name:"label",type:"bytes32"},{indexed:!1,name:"owner",type:"address"}],name:"NewOwner",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"resolver",type:"address"}],name:"NewResolver",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"ttl",type:"uint64"}],name:"NewTTL",type:"event"}]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/contracts/registry.js"}],[2862,{"./ppom-controller":2863},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;var s=e("./ppom-controller");Object.defineProperty(a,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return s.NETWORK_CACHE_DURATION}}),Object.defineProperty(a,"PPOMController",{enumerable:!0,get:function(){return s.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],[2863,{"./ppom-storage":2864,"./util":2865,"@metamask/base-controller":1506,"@metamask/controller-utils":1625,"await-semaphore":4299},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,u,d,m,p,h,f,b,g,y,w,v,k,_,S,E,T,P,M,I,x,C,A,j,R,O,N=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},$=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;const D=e("@metamask/base-controller"),B=e("@metamask/controller-utils"),L=e("await-semaphore"),F=e("./ppom-storage"),H=e("./util");a.NETWORK_CACHE_DURATION=6048e5;const U=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],q={versionInfo:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!1},storageMetadata:{includeInStateLogs:!1,persist:!0,includeInDebugSnapshot:!1,usedInUi:!1}},V="PPOMController",G={headers:{"Content-Type":"application/json"}};class W extends D.BaseController{constructor({chainId:e,messenger:t,provider:a,storageBackend:y,securityAlertsEnabled:w,onPreferencesChange:v,ppomProvider:E,cdnBaseUrl:T,providerRequestLimit:P,state:M,blockaidPublicKey:I,nativeCrypto:x}){super({name:V,metadata:q,messenger:t,state:{versionInfo:M?.versionInfo??[],storageMetadata:M?.storageMetadata??[]}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),u.set(this,void 0),d.set(this,0),m.set(this,void 0),p.set(this,void 0),h.set(this,{}),f.set(this,void 0),b.set(this,!1),g.set(this,undefined),N(this,m,(0,H.addHexPrefix)(e),"f"),N(this,r,a,"f"),N(this,c,E,"f"),N(this,i,new F.PPOMStorage({storageBackend:y,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update(t=>{t.storageMetadata=e})}}),"f"),N(this,o,new L.Mutex,"f"),N(this,l,T,"f"),N(this,u,P??300,"f"),N(this,p,w,"f"),N(this,f,I,"f"),N(this,g,x,"f"),v($(this,s,"m",k).bind(this)),$(this,s,"m",_).call(this),$(this,s,"m",S).call(this)}async usePPOM(e,t){const a=t??$(this,m,"f");if(!$(this,p,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,H.blockaidValidationSupportedForNetwork)(a))throw Error(`Blockaid validation not available on network with chainId: ${a}`);return await $(this,o,"f").use(async()=>{const t=await $(this,s,"m",T).call(this,a);N(this,d,0,"f"),N(this,h,{},"f");return{...await e(t),providerRequestsCount:{...$(this,h,"f")}}})}}a.PPOMController=W,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,u=new WeakMap,d=new WeakMap,m=new WeakMap,p=new WeakMap,h=new WeakMap,f=new WeakMap,b=new WeakMap,g=new WeakMap,s=new WeakSet,y=async function(){if($(this,p,"f")&&!$(this,b,"f")){const{ppomInit:e}=$(this,c,"f");await e("./ppom_bg.wasm"),N(this,b,!0,"f")}},w=function(){$(this,s,"m",E).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)});const{storageMetadata:e}=this.state;this.update(e=>{e.versionInfo=[],e.storageMetadata=[]}),$(this,i,"f").deleteAllFiles(e).catch(e=>{console.error(`Error in deleting files: ${e.message}`)})},v=function(e){const t=this.messenger.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:a}=t.configuration,n=(0,H.addHexPrefix)(a);n!==$(this,m,"f")&&(N(this,m,n,"f"),$(this,s,"m",E).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)}))},k=function(e){const t=e.securityAlertsEnabled;t!==$(this,p,"f")&&(N(this,p,t,"f"),t||$(this,s,"m",w).call(this))},_=function(){this.messenger.registerActionHandler(`${V}:usePPOM`,this.usePPOM.bind(this))},S=function(){const e=$(this,s,"m",v).bind(this);this.messenger.subscribe("NetworkController:networkDidChange",e)},E=async function(){await $(this,o,"f").use(async()=>{$(this,n,"f")&&($(this,n,"f").free(),N(this,n,undefined,"f"))})},T=async function(e){const t=await $(this,s,"m",P).call(this);let a;return($(this,n,"f")===undefined||t)&&(a=await $(this,s,"m",O).call(this,e),$(this,m,"f")===e&&($(this,n,"f")&&$(this,n,"f").free(),N(this,n,a,"f")),$(this,i,"f").syncMetadata(this.state.versionInfo).catch(e=>{console.error(`Error while trying to sync metadata: ${e.message}`)})),a},P=async function(){const e=await $(this,s,"m",A).call(this);return!!e&&(this.update(t=>{t.versionInfo=e}),!0)},M=function(e,t){return e.find(e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum)},I=async function(e){const t=await Promise.all(e.map(async e=>{let t;try{t=await $(this,s,"m",x).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined}));return t?.filter(e=>e?.[1]!==undefined)},x=async function(e){const{storageMetadata:t}=this.state;if($(this,s,"m",M).call(this,t,e))try{return await $(this,i,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,H.checkFilePath)(e.filePath);const a=(0,H.constructURLHref)($(this,l,"f"),e.filePath),n=await $(this,s,"m",j).call(this,a);return await(0,H.validateSignature)(n,e.hashSignature,$(this,f,"f"),e.filePath,$(this,g,"f")),await $(this,i,"f").writeFile({data:n,...e}).catch(e=>{console.error(`Error in writing file: ${e.message}`)}),n},C=async function(e,t={},a="GET"){const s=await(0,B.safelyExecute)(async()=>(0,B.timeoutFetch)(e,{method:a,cache:"no-cache",redirect:"error",...t},1e4),!0),n=304===s?.status;if(!s?.status||s?.status<200||s?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:n,response:s}},A=async function(){const e=(0,H.constructURLHref)($(this,l,"f"),"ppom_version.json"),{cached:t,response:a}=await $(this,s,"m",C).call(this,e,{headers:G});return t&&this.state.versionInfo?.length?undefined:a.json()},j=async function(e){const{response:t}=await $(this,s,"m",C).call(this,e);return await t.arrayBuffer()},R=async function(e,t){if($(this,d,"f")>$(this,u,"f"))return H.PROVIDER_ERRORS.limitExceeded();if(N(this,d,$(this,d,"f")+1,"f"),!U.includes(e))return H.PROVIDER_ERRORS.methodNotSupported();$(this,h,"f")[e]=$(this,h,"f")[e]?Number($(this,h,"f")[e])+1:1;const a=(0,H.createPayload)(e,t);try{const e=await $(this,r,"f").request(a);return{jsonrpc:"2.0",id:a.id,result:e}}catch(e){return{jsonrpc:"2.0",id:a.id,error:e}}},O=async function(e){await $(this,s,"m",y).call(this);const t=this.state.versionInfo.filter(({chainId:t})=>t===e);if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const a=await $(this,s,"m",I).call(this,t);if(a?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:n}=$(this,c,"f");return n.new($(this,s,"m",R).bind(this),a)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],[2864,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},o=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMStorage=void 0;a.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:a}){s.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i(this,s,e,"f"),i(this,n,t,"f"),i(this,r,a,"f")}async syncMetadata(e){const t=o(this,n,"f").call(this),a=[];for(const s of t){try{await this.readFile(s.name,s.chainId)}catch(e){console.error("Error: ",e);continue}e.find(e=>e.name===s.name&&e.chainId===s.chainId&&e.version===s.version&&e.checksum===s.checksum)&&a.push(s)}const i=await o(this,s,"f").dir();for(const{name:e,chainId:t}of i)a.find(a=>a.name===e&&a.chainId===t)||await o(this,s,"f").delete({name:e,chainId:t});return o(this,r,"f").call(this,a),a}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:a}=t;try{await o(this,s,"f").delete({name:e,chainId:a})}catch(t){console.error(`Error in deleting file: ${e}, ${a}`,t)}}}async readFile(e,t){const a=o(this,n,"f").call(this).find(a=>a.name===e&&a.chainId===t);if(!a)throw new Error(`File metadata (${e}, ${t}) not found`);const r=await o(this,s,"f").read({name:e,chainId:t},a.checksum);if(!r)throw new Error(`Storage File (${e}, ${t}) not found`);return r}async writeFile({data:e,name:t,chainId:a,version:i,checksum:c}){await o(this,s,"f").write({name:t,chainId:a},e,c);const l=o(this,n,"f").call(this),u=l.find(e=>e.name===t&&e.chainId===a);u?(u.version=i,u.checksum=c):l.push({name:t,chainId:a,version:i,checksum:c}),o(this,r,"f").call(this,l)}},s=new WeakMap,n=new WeakMap,r=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],[2865,{buffer:4473,"crypto-js":4590,elliptic:4646,"json-rpc-random-id":5062},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(t){(function(){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),r=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&s(t,e,a);return n(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.checkFilePath=a.addHexPrefix=a.constructURLHref=a.validateSignature=a.PROVIDER_ERRORS=a.createPayload=a.IdGenerator=a.blockaidValidationSupportedForNetwork=a.SUPPORTED_NETWORK_CHAINIDS=void 0;const o=r(e("crypto-js")),c=i(e("elliptic")),l=i(e("json-rpc-random-id")),u=c.default.eddsa;a.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};a.blockaidValidationSupportedForNetwork=e=>Object.values(a.SUPPORTED_NETWORK_CHAINIDS).some(t=>t===e),a.IdGenerator=(0,l.default)();a.createPayload=(e,t)=>({id:(0,a.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),a.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};a.validateSignature=async(e,a,s,n,r,i)=>{const c=await(async(e,t,a=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&a){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map(e=>e.toString(16).padStart(2,"0")).join("")}return(0,o.SHA256)(o.default.lib.WordArray.create(e)).toString()})(e,r,i);if(!new u("ed25519").keyFromPublic(s).verify(t.from(c),a))throw Error(`Signature verification failed for file path: ${n}`)};a.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;a.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;a.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],[2866,{"@metamask/polling-controller":2839,"@metamask/utils":3504,"async-mutex":4295},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,u,d,m,p=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},h=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ProfileMetricsController=a.getDefaultProfileMetricsControllerState=a.DEFAULT_INITIAL_DELAY_DURATION=a.controllerName=void 0;const f=e("@metamask/polling-controller"),b=e("@metamask/utils"),g=e("async-mutex");a.controllerName="ProfileMetricsController",a.DEFAULT_INITIAL_DELAY_DURATION=(0,b.inMilliseconds)(10,b.Duration.Minute);const y={initialEnqueueCompleted:{persist:!0,includeInDebugSnapshot:!0,includeInStateLogs:!0,usedInUi:!1},syncQueue:{persist:!0,includeInDebugSnapshot:!1,includeInStateLogs:!0,usedInUi:!1},initialDelayEndTimestamp:{persist:!0,includeInDebugSnapshot:!0,includeInStateLogs:!0,usedInUi:!1}};function w(){return{initialEnqueueCompleted:!1,syncQueue:{}}}a.getDefaultProfileMetricsControllerState=w;const v=["skipInitialDelay"];class k extends((0,f.StaticIntervalPollingController)()){constructor({messenger:e,state:t,assertUserOptedIn:l,getMetaMetricsId:u,interval:f=1e4,initialDelayDuration:b=a.DEFAULT_INITIAL_DELAY_DURATION}){super({messenger:e,metadata:y,name:a.controllerName,state:{initialEnqueueCompleted:!1,syncQueue:{},...t}}),s.add(this),n.set(this,new g.Mutex),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),p(this,r,l,"f"),p(this,i,u,"f"),p(this,o,b,"f"),this.messenger.registerMethodActionHandlers(this,v),this.messenger.subscribe("KeyringController:unlock",()=>{h(this,r,"f").call(this)&&this.skipInitialDelay(),h(this,s,"m",c).call(this).catch(this.messenger.captureException??console.error),this.startPolling(null)}),this.messenger.subscribe("KeyringController:lock",()=>this.stopAllPolling()),this.messenger.subscribe("TransactionController:transactionSubmitted",()=>this.skipInitialDelay()),this.messenger.subscribe("AccountsController:accountAdded",e=>{h(this,s,"m",d).call(this,e).catch(console.error)}),this.messenger.subscribe("AccountsController:accountRemoved",e=>{h(this,s,"m",m).call(this,e).catch(console.error)}),this.setIntervalLength(f)}skipInitialDelay(){this.update(e=>{e.initialDelayEndTimestamp=Date.now()})}async _executePoll(){await h(this,n,"f").runExclusive(async()=>{if(h(this,r,"f").call(this)&&(h(this,s,"m",l).call(this),h(this,s,"m",u).call(this)))for(const[e,t]of Object.entries(this.state.syncQueue))try{await this.messenger.call("ProfileMetricsService:submitMetrics",{metametricsId:h(this,i,"f").call(this),entropySourceId:"null"===e?null:e,accounts:t}),this.update(t=>{delete t.syncQueue[e]})}catch(t){console.error(`Failed to submit profile metrics for entropy source ID ${e}:`,t)}})}}function _(e){return"mnemonic"===e.options.entropy?.type?e.options.entropy.id:null}a.ProfileMetricsController=k,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,s=new WeakSet,c=async function(){await h(this,n,"f").runExclusive(async()=>{if(this.state.initialEnqueueCompleted)return;const e=Object.values(this.messenger.call("AccountsController:getState").internalAccounts.accounts).reduce((e,t)=>{const a=_(t)??"null";return e[a]||(e[a]=[]),e[a].push({address:t.address,scopes:t.scopes}),e},{});this.update(t=>{for(const a of Object.keys(e))t.syncQueue[a]||(t.syncQueue[a]=[]),t.syncQueue[a].push(...e[a]);t.initialEnqueueCompleted=!0})})},l=function(){this.update(e=>{e.initialDelayEndTimestamp??(e.initialDelayEndTimestamp=Date.now()+h(this,o,"f"))})},u=function(){return this.state.initialDelayEndTimestamp!==undefined&&Date.now()>=this.state.initialDelayEndTimestamp},d=async function(e){await h(this,n,"f").runExclusive(async()=>{this.update(t=>{const a=_(e)??"null";t.syncQueue[a]||(t.syncQueue[a]=[]),t.syncQueue[a].push({address:e.address,scopes:e.scopes})})})},m=async function(e){await h(this,n,"f").runExclusive(async()=>{this.update(t=>{for(const[a,s]of Object.entries(t.syncQueue)){const n=s.findIndex(({address:t})=>t===e);if(-1!==n){s.splice(n,1),0===s.length&&delete t.syncQueue[a];break}}})})}}}},{package:"@metamask/profile-metrics-controller",file:"node_modules/@metamask/profile-metrics-controller/dist/ProfileMetricsController.cjs"}],[2867,{"@metamask/controller-utils":1625,"@metamask/profile-sync-controller":2885},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},c=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.getAuthUrl=a.ProfileMetricsService=a.serviceName=void 0;const l=e("@metamask/controller-utils"),u=e("@metamask/profile-sync-controller");a.serviceName="ProfileMetricsService";const d=["submitMetrics"];class m{constructor({messenger:e,fetch:t,policyOptions:m={},env:h=u.SDK.Env.DEV}){s.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),this.name=a.serviceName,o(this,s,e,"f"),o(this,n,t,"f"),o(this,r,(0,l.createServicePolicy)(m),"f"),o(this,i,p(h),"f"),c(this,s,"f").registerMethodActionHandlers(this,d)}onRetry(e){return c(this,r,"f").onRetry(e)}onBreak(e){return c(this,r,"f").onBreak(e)}onDegraded(e){return c(this,r,"f").onDegraded(e)}async submitMetrics(e){const t=await c(this,s,"f").call("AuthenticationController:getBearerToken",e.entropySourceId??undefined);await c(this,r,"f").execute(async()=>{const a=new URL(`${c(this,i,"f")}/profile/accounts`),s=await c(this,n,"f").call(this,a,{method:"PUT",headers:{Authorization:`Bearer ${t}`,"Content-Type":"application/json"},body:JSON.stringify({metametrics_id:e.metametricsId,accounts:e.accounts})});if(!s.ok)throw new l.HttpError(s.status,`Fetching '${a.toString()}' failed with status '${s.status}'`);return s})}}function p(e){return`${u.SDK.getEnvUrls(e).authApiUrl}/api/v2`}a.ProfileMetricsService=m,s=new WeakMap,n=new WeakMap,r=new WeakMap,i=new WeakMap,a.getAuthUrl=p}}},{package:"@metamask/profile-metrics-controller",file:"node_modules/@metamask/profile-metrics-controller/dist/ProfileMetricsService.cjs"}],[2868,{"./ProfileMetricsController.cjs":2866,"./ProfileMetricsService.cjs":2867},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.serviceName=a.ProfileMetricsService=a.getDefaultProfileMetricsControllerState=a.ProfileMetricsController=void 0;var s=e("./ProfileMetricsController.cjs");Object.defineProperty(a,"ProfileMetricsController",{enumerable:!0,get:function(){return s.ProfileMetricsController}}),Object.defineProperty(a,"getDefaultProfileMetricsControllerState",{enumerable:!0,get:function(){return s.getDefaultProfileMetricsControllerState}});var n=e("./ProfileMetricsService.cjs");Object.defineProperty(a,"ProfileMetricsService",{enumerable:!0,get:function(){return n.ProfileMetricsService}}),Object.defineProperty(a,"serviceName",{enumerable:!0,get:function(){return n.serviceName}})}}},{package:"@metamask/profile-metrics-controller",file:"node_modules/@metamask/profile-metrics-controller/dist/index.cjs"}],[287,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;a.default=[{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"hash",type:"bytes32"}],name:"setContent",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"content",outputs:[{name:"",type:"bytes32"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"interfaceID",type:"bytes4"}],name:"supportsInterface",outputs:[{name:"",type:"bool"}],payable:!1,stateMutability:"pure",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"key",type:"string"},{name:"value",type:"string"}],name:"setText",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"},{name:"contentTypes",type:"uint256"}],name:"ABI",outputs:[{name:"contentType",type:"uint256"},{name:"data",type:"bytes"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"x",type:"bytes32"},{name:"y",type:"bytes32"}],name:"setPubkey",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"hash",type:"bytes"}],name:"setContenthash",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"addr",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"},{name:"key",type:"string"}],name:"text",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"contentType",type:"uint256"},{name:"data",type:"bytes"}],name:"setABI",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"name",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"name",type:"string"}],name:"setName",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"contenthash",outputs:[{name:"",type:"bytes"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"pubkey",outputs:[{name:"x",type:"bytes32"},{name:"y",type:"bytes32"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"addr",type:"address"}],name:"setAddr",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{inputs:[{name:"ensAddr",type:"address"}],payable:!1,stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"a",type:"address"}],name:"AddrChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"name",type:"string"}],name:"NameChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!0,name:"contentType",type:"uint256"}],name:"ABIChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"x",type:"bytes32"},{indexed:!1,name:"y",type:"bytes32"}],name:"PubkeyChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"indexedKey",type:"string"},{indexed:!1,name:"key",type:"string"}],name:"TextChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"hash",type:"bytes"}],name:"ContenthashChanged",type:"event"}]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/contracts/resolver.js"}],[288,{"./contracts/registry":286,"./contracts/resolver":287,"@ensdomains/content-hash":663,"@ethersproject/contracts":778,"@ethersproject/providers":816,"eth-ens-namehash":4677},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=async function({provider:e,name:t}){const a=s.default.hash(t),l=Number.parseInt(await e.request({method:"net_version"}),10),d=function(e){switch(e){case 1:case 3:case 4:case 5:case 6:return"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";default:return null}}(l);if(!d)throw new Error(`EnsIpfsResolver - no known ens-ipfs registry for chainId "${l}"`);const m=new r.Web3Provider(e),p=new i.Contract(d,o.default,m),h=await p.resolver(a);if(u(h))throw new Error(`EnsIpfsResolver - no resolver found for name "${t}"`);const f=new i.Contract(h,c.default,m),b=await f.supportsInterface("0xbc1c58d1"),g=await f.supportsInterface("0xd8389dc5");if(b){const e=await f.contenthash(a);let t=n.default.decode(e);const s=n.default.getCodec(e);return"ipfs-ns"!==s&&"ipns-ns"!==s||(t=n.default.helpers.cidV0ToV1Base32(t)),{type:s,hash:t}}if(g){const e=await f.content(a);if(u(e))throw new Error(`EnsIpfsResolver - no content ID found for name "${t}"`);return{type:"swarm-ns",hash:e.slice(2)}}throw new Error(`EnsIpfsResolver - the resolver for name "${t}" is not standard, it should either supports contenthash() or content()`)};var s=l(e("eth-ens-namehash")),n=l(e("@ensdomains/content-hash")),r=e("@ethersproject/providers"),i=e("@ethersproject/contracts"),o=l(e("./contracts/registry")),c=l(e("./contracts/resolver"));function l(e){return e&&e.__esModule?e:{default:e}}function u(e){return[undefined,null,"0x","0x0","0x0000000000000000000000000000000000000000000000000000000000000000"].includes(e)}}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/resolver.js"}],[289,{"../../../../shared/modules/fetch-with-timeout":6330,"./resolver":288,"base32-encode":4358,"base64-js":4359,"webextension-polyfill":6172},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({provider:e,getCurrentChainId:t,getIpfsGateway:a,getUseAddressBarEnsResolution:i}){const c=u.map(e=>`*://*.${e}/*`);return r.default.webRequest.onErrorOccurred.addListener(d,{urls:c,types:["main_frame"]}),{remove(){r.default.webRequest.onErrorOccurred.removeListener(d)}};async function d(c){const{tabId:d,url:m}=c;if(-1===d||"0x1"!==t())return;const{hostname:p,pathname:h,search:f,hash:b}=new URL(m),g=p.split("."),y=g[g.length-1];u.includes(y)&&async function({tabId:t,name:c,pathname:u,search:d,fragment:m}){const p=a(),h=i(),f=`https://app.ens.domains/name/${c}`;h&&p&&await r.default.tabs.update(t,{url:"loading.html"});let b=f;0;try{const{type:t,hash:a}=await(0,o.default)({provider:e,name:c});if("ipfs-ns"===t||"ipns-ns"===t){if(""===p)return void(b=null);const e=`https://${a}.${t.slice(0,4)}.${p}${u}${d||""}${m||""}`;try{200===(await l(e,{method:"HEAD"})).status&&(b=e)}catch(e){console.warn(e)}}else if("swarm-ns"===t)b=`https://swarm-gateways.net/bzz:/${a}${u}${d||""}${m||""}`;else if("onion"===t||"onion3"===t)b=`http://${a}.onion${u}${d||""}${m||""}`;else if("zeronet"===t)b=`http://127.0.0.1:43110/${a}${u}${d||""}${m||""}`;else if("skynet-ns"===t){const e=a.padEnd(a.length+4-a.length%4,"="),t=n.default.toByteArray(e),r={padding:!1};b=`https://${(0,s.default)(t,"RFC4648-HEX",r).toLowerCase()}.siasky.net${u}${d||""}${m||""}`}}catch(e){console.warn(e)}finally{b&&(h||!h&&b!==f)&&await r.default.tabs.update(t,{url:b})}}({tabId:d,name:p,pathname:h,search:f,fragment:b})}};var s=c(e("base32-encode")),n=c(e("base64-js")),r=c(e("webextension-polyfill")),i=c(e("../../../../shared/modules/fetch-with-timeout")),o=c(e("./resolver"));function c(e){return e&&e.__esModule?e:{default:e}}const l=(0,i.default)(),u=["eth"]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/setup.js"}],[29,{"../../../../shared/constants/metametrics":6199,"@metamask/assets-controllers":1380,"@metamask/bridge-controller":1513},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.NftControllerInit=void 0;var s=e("@metamask/assets-controllers"),n=e("@metamask/bridge-controller"),r=e("../../../../shared/constants/metametrics");a.NftControllerInit=({controllerMessenger:e,initMessenger:t,persistedState:a})=>({controller:new s.NftController({state:a.NftController,messenger:e,onNftAdded:({address:e,symbol:a,tokenId:s,standard:i,source:o})=>t.call("MetaMetricsController:trackEvent",{event:r.MetaMetricsEventName.NftAdded,category:r.MetaMetricsEventCategory.Wallet,sensitiveProperties:{token_contract_address:e,token_symbol:a??null,token_id:s,token_standard:i,asset_type:n.AssetType.NFT,source:o}})})})}}},{package:"$root$",file:"app/scripts/controller-init/assets/nft-controller-init.ts"}],[290,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){n(e,t),t.set(e,a)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(i(e,t))}function i(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.ExtensionLazyListener=void 0;var o=new WeakMap,c=new WeakMap,l=new WeakSet;function u(e){setTimeout(()=>{for(const[t,a]of r(c,this))for(const[s,{args:n}]of a){const a=`ExtensionLazyListener: Possible memory leak detected. The event "${t}.${s}" has been listened to, but no application code has added a listener after ${e}ms. There are currently ${n.length} buffered calls. If you are a developer of this extension, please ensure that you have added a listener for this event. If you are a user of this extension, please report this warning to the developers of the extension.`;console.warn(a)}},e)}function d(e,t){return r(o,this)[e][t]}a.ExtensionLazyListener=class{constructor(e,t={},a=2e4){var m,p;n(m=this,p=l),p.add(m),s(this,o,void 0),s(this,c,new Map),function(e,t,a){e.set(i(e,t),a)}(o,this,e);for(const[e,a]of Object.entries(t)){const t=new Map;for(const s of a){const a=[],n=(...e)=>{a.push(e)};i(l,this,d).call(this,e,s).addListener(n),t.set(s,{listener:n,args:a})}r(c,this).set(e,t)}i(l,this,u).call(this,a)}addListener(e,t,a){const s=i(l,this,d).call(this,e,t);s.addListener(a);const n=r(c,this).get(e);if(n){const i=n.get(t);if(i){s.removeListener(i.listener),n.delete(t),0===n.size&&r(c,this).delete(e);const{args:o}=i;for(let l=0,{length:u}=o;l<u;l++)try{if(a(...o[l]),!s.hasListener(a)){const a=l+1;a!==u&&(o.splice(0,a),n.set(t,i),r(c,this).set(e,n),s.addListener(i.listener));break}}catch(a){const d=l+1;throw d!==u&&(o.splice(0,d),n.set(t,i),r(c,this).set(e,n),s.addListener(i.listener)),a}}}}once(e,t){return new Promise(a=>{const s=i(l,this,d).call(this,e,t),n=r(c,this).get(e);if(n){const i=n.get(t),o=null==i?void 0:i.args.length;if(o)return a(i.args.shift()),s.removeListener(i.listener),void(1===o&&(n.delete(t),0===n.size&&r(c,this).delete(e)))}const o=(...e)=>{s.removeListener(o),a(e)};s.addListener(o)})}}}}},{package:"$root$",file:"app/scripts/lib/extension-lazy-listener/extension-lazy-listener.ts"}],[291,{"@metamask/snaps-sdk":3215,"@metamask/snaps-utils":3332},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.forwardRequestToSnap=async function(e,t,a,r){const{method:i,params:o}=a,{handleRequest:c,snapId:l,onBeforeRequest:u,onAfterRequest:d}=e;if(!l)throw new n.InternalError(`No snapId configured for method ${i}`);const m=r.get("origin");if(!m)throw new n.InternalError(`No origin specified for method ${i}`);try{null==u||u()}catch(e){try{null==d||d()}catch(e){console.error("Error from onAfterRequest hook:",e)}throw e}let p;try{p=await c({snapId:l,origin:m,handler:s.HandlerType.OnRpcRequest,request:{jsonrpc:"2.0",method:i,params:o}})}catch(e){try{null==d||d()}catch(e){console.error("Error from onAfterRequest hook:",e)}throw e}return null==d||d(),p};var s=e("@metamask/snaps-utils"),n=e("@metamask/snaps-sdk")}}},{package:"$root$",file:"app/scripts/lib/forwardRequestToSnap.ts"}],[292,{lodash:5247},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return n((0,s.cloneDeep)(e),e=>null===e?"null":typeof e)};var s=e("lodash");function n(e={},t){return Object.entries(e).forEach(([a,s])=>{e[a]="object"==typeof s&&null!==s?n(s,t):t(s)}),e}}}},{package:"$root$",file:"app/scripts/lib/getObjStructure.js"}],[293,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.hardwareKeyringBuilderFactory=function(e,t){const a=()=>new e({bridge:new t});return a.type=e.type,a}}}},{package:"$root$",file:"app/scripts/lib/hardware-keyring-builder-factory.ts"}],[294,{"../../../shared/lib/sentry":6300,"@metamask/messenger":2551},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getRootMessenger=a.ROOT_MESSENGER_NAMESPACE=void 0;var s=e("@metamask/messenger"),n=e("../../../shared/lib/sentry");const r=a.ROOT_MESSENGER_NAMESPACE="Root";a.getRootMessenger=()=>new s.Messenger({namespace:r,captureException:n.captureException})}}},{package:"$root$",file:"app/scripts/lib/messenger.ts"}],[296,{"../util":375},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createPendingNonceMiddleware=function({getPendingNonce:e}){return async({request:t,context:a,next:s})=>{const{method:n,params:r}=t;if("eth_getTransactionCount"!==n)return s();const[i,o]=r;return"pending"!==o?s():await e(i,a.get("networkClientId"))}},a.createPendingTxMiddleware=function({getPendingTransactionByHash:e}){return async({request:t,next:a})=>{const{method:n,params:r}=t;if("eth_getTransactionByHash"!==n)return a();const[i]=r,o=e(i);return o?(0,s.formatTxMetaForRpcResult)(o):a()}};var s=e("../util")}}},{package:"$root$",file:"app/scripts/lib/middleware/pending.ts"}],[2964,{"@metamask/base-controller":1506,"@metamask/rpc-errors":2976,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RateLimitController=void 0;const s=e("@metamask/base-controller"),n=e("@metamask/rpc-errors"),r=e("@metamask/utils"),i="RateLimitController",o={requests:{includeInStateLogs:!1,persist:!1,includeInDebugSnapshot:!1,usedInUi:!1}};class c extends s.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:a,state:s,implementations:n}){const c={requests:(0,r.getKnownPropertyNames)(n).reduce((e,t)=>({...e,[t]:{}}),{})};super({name:i,metadata:o,messenger:a,state:{...c,...s}}),this.implementations=n,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messenger.registerActionHandler(`${i}:call`,(e,t,...a)=>this.call(e,t,...a))}async call(e,t,...a){if(this.isRateLimited(t,e))throw n.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const s=this.implementations[t].method;if(!s)throw new Error("Invalid api type");return s(...a)}isRateLimited(e,t){const a=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=a}recordRequest(e,t){const a=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,s=this.state.requests[e][t]??0;this.update(n=>{0===s&&setTimeout(()=>this.resetRequestCount(e,t),a),Object.assign(n,{requests:{...n.requests,[e]:{[t]:s+1}}})})}resetRequestCount(e,t){this.update(a=>{Object.assign(a,{requests:{...a.requests,[e]:{[t]:0}}})})}}a.RateLimitController=c}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],[2965,{"./RateLimitController.cjs":2964},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RateLimitController=void 0;var s=e("./RateLimitController.cjs");Object.defineProperty(a,"RateLimitController",{enumerable:!0,get:function(){return s.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],[2966,{"../constants.cjs":2967,"@metamask/controller-utils":1625},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},l=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ClientConfigApiService=void 0;const u=e("@metamask/controller-utils"),d=e("../constants.cjs");a.ClientConfigApiService=class{constructor({fetch:e,retries:t=u.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:a=u.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:d=u.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:m,onDegraded:p,config:h}){s.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c(this,s,e,"f"),c(this,r,h.client,"f"),c(this,i,h.distribution,"f"),c(this,o,h.environment,"f"),c(this,n,(0,u.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:a,circuitBreakDuration:d}),"f"),m&&l(this,n,"f").onBreak(m),p&&l(this,n,"f").onDegraded(p)}onBreak(...e){return l(this,n,"f").onBreak(...e)}onDegraded(...e){return l(this,n,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${d.BASE_URL}/flags?client=${l(this,r,"f")}&distribution=${l(this,i,"f")}&environment=${l(this,o,"f")}`,t=await l(this,n,"f").execute(()=>l(this,s,"f").call(this,e,{cache:"no-cache"}));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const a=await t.json();if(!Array.isArray(a))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(a),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce((e,t)=>({...e,...t}),{})}},s=new WeakMap,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],[2967,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.BASE_URL=void 0,a.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],[2968,{"./client-config-api-service/client-config-api-service.cjs":2966,"./remote-feature-flag-controller-types.cjs":2969,"./remote-feature-flag-controller.cjs":2970,"./utils/user-segmentation-utils.cjs":2971},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.generateDeterministicRandomNumber=a.ClientConfigApiService=a.EnvironmentType=a.DistributionType=a.ClientType=a.RemoteFeatureFlagController=void 0;var s=e("./remote-feature-flag-controller.cjs");Object.defineProperty(a,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return s.RemoteFeatureFlagController}});var n=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(a,"ClientType",{enumerable:!0,get:function(){return n.ClientType}}),Object.defineProperty(a,"DistributionType",{enumerable:!0,get:function(){return n.DistributionType}}),Object.defineProperty(a,"EnvironmentType",{enumerable:!0,get:function(){return n.EnvironmentType}});var r=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(a,"ClientConfigApiService",{enumerable:!0,get:function(){return r.ClientConfigApiService}});var i=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(a,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return i.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],[2969,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r;Object.defineProperty(a,"__esModule",{value:!0}),a.EnvironmentType=a.DistributionType=a.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(s||(a.ClientType=s={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(n||(a.DistributionType=n={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev",e.Beta="beta",e.Test="test",e.Exp="exp"}(r||(a.EnvironmentType=r={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],[297,{"../stores/persistence-manager":352,"@metamask/utils":3504,events:4769,loglevel:5255},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;var s=o(e("events")),n=o(e("loglevel")),r=e("@metamask/utils"),i=e("../stores/persistence-manager");function o(e){return e&&e.__esModule?e:{default:e}}class c extends s.default{constructor(e={}){super();const t=e.migrations||[];this.migrations=t.sort((e,t)=>e.version-t.version);const a=this.migrations.slice(-1)[0];this.defaultVersion=e.defaultVersion||a&&a.version||0}async migrateData(e=this.generateInitialState()){const t=(0,r.isObject)(e.data)&&e.meta.version<186?new Set(Object.keys(e.data)):new Set;let a=e;for(const e of this.migrations)if(i(e))try{let s;if(n.default.info(`Running migration ${e.version}...`),e.version<186)s=await e.migrate(a),o(s,e);else{s=structuredClone(a);const r=new Set,i=await e.migrate(s,r);if(o(s,e),void 0!==i)throw new Error("Migrator - migration returned value when none expected");if(0===r.size)n.default.debug(`Migrator - migration ${e.version} did not report any changes`);else for(const e of r)t.add(e)}a=s,n.default.info(`Migration ${e.version} complete`)}catch(t){const a=new AggregateError([t],`MetaMask Migration Error #${e.version}`);this.emit("error",a);break}const s=e.meta.version<186&&(0,r.isObject)(a.data)?new Set(Object.keys(a.data)):new Set;for(const e of t)s.add(e);return{state:a,changedKeys:s};function i(e){return e.version>a.meta.version}function o(e,t){if(!e.data)throw new Error("Migrator - migration returned empty data");if(e.version!==undefined&&e.meta.version!==t.version)throw new Error("Migrator - Migration did not update version number correctly")}}generateInitialState(e){return{data:e,meta:{storageKind:i.PersistenceManager.defaultStorageKind,version:this.defaultVersion}}}}a.default=c}}},{package:"$root$",file:"app/scripts/lib/migrator/index.js"}],[2970,{"./utils/user-segmentation-utils.cjs":2971,"./utils/version.cjs":2972,"@metamask/base-controller":1506,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,u,d,m,p,h=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},f=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.RemoteFeatureFlagController=a.getDefaultRemoteFeatureFlagControllerState=a.DEFAULT_CACHE_DURATION=void 0;const b=e("@metamask/base-controller"),g=e("@metamask/utils"),y=e("./utils/user-segmentation-utils.cjs"),w=e("./utils/version.cjs");a.DEFAULT_CACHE_DURATION=864e5;const v={remoteFeatureFlags:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},cacheTimestamp:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!1}};function k(){return{remoteFeatureFlags:{},cacheTimestamp:0}}a.getDefaultRemoteFeatureFlagControllerState=k;class _ extends b.BaseController{constructor({messenger:e,state:t,clientConfigApiService:u,fetchInterval:d=a.DEFAULT_CACHE_DURATION,disabled:m=!1,getMetaMetricsId:p,clientVersion:f}){if(!(0,g.isValidSemVerVersion)(f))throw new Error(`Invalid clientVersion: "${f}". Must be a valid 3-part SemVer version string`);super({name:"RemoteFeatureFlagController",metadata:v,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),h(this,n,d,"f"),h(this,r,m,"f"),h(this,i,u,"f"),h(this,c,p,"f"),h(this,l,f,"f")}async updateRemoteFeatureFlags(){if(f(this,r,"f")||!f(this,s,"m",u).call(this))return;let e;if(f(this,o,"f"))await f(this,o,"f");else{try{h(this,o,f(this,i,"f").fetchRemoteFeatureFlags(),"f"),e=await f(this,o,"f")}finally{h(this,o,undefined,"f")}await f(this,s,"m",d).call(this,e.remoteFeatureFlags)}}enable(){h(this,r,!1,"f")}disable(){h(this,r,!0,"f")}}a.RemoteFeatureFlagController=_,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,s=new WeakSet,u=function(){return Date.now()-this.state.cacheTimestamp>f(this,n,"f")},d=async function(e){const t=await f(this,s,"m",p).call(this,e);this.update(()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()}))},m=function(e){return(0,w.isVersionFeatureFlag)(e)?(0,w.getVersionData)(e,f(this,l,"f")):e},p=async function(e){const t={},a=f(this,c,"f").call(this),n=(0,y.generateDeterministicRandomNumber)(a);for(const[a,r]of Object.entries(e)){let e=f(this,s,"m",m).call(this,r);if(null!==e){if(Array.isArray(e)&&n){const t=e.find(e=>!!(0,y.isFeatureFlagWithScopeValue)(e)&&n<=e.scope.value);t&&(e={name:t.name,value:t.value})}t[a]=e}}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],[2971,{uuid:6143},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isFeatureFlagWithScopeValue=a.generateDeterministicRandomNumber=void 0;const s=e("uuid");function n(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const r=n("00000000-0000-4000-8000-000000000000"),i=n("ffffffff-ffff-4fff-bfff-ffffffffffff")-r;a.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,a;if((0,s.validate)(e)){if(4!==(0,s.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,s.version)(e)}`);t=n(e)-r,a=i}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const s=e.slice(2),n=64;if(s.length!==n)throw new Error(`Invalid hex ID length. Expected ${n} characters, got ${s.length}`);if(!/^[0-9a-f]+$/iu.test(s))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${s}`),a=BigInt(`0x${"f".repeat(s.length)}`)}return Number(t*BigInt(1e6)/a)/1e6};a.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],[2972,{"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getVersionData=a.isVersionFeatureFlag=a.MULTI_VERSION_FLAG_KEYS=void 0;const s=e("@metamask/utils");function n(e,t){return e===t||(0,s.gtVersion)(e,t)}a.MULTI_VERSION_FLAG_KEYS={VERSIONS:"versions"},a.isVersionFeatureFlag=function(e){if("object"!=typeof e||null===e||Array.isArray(e)||!(a.MULTI_VERSION_FLAG_KEYS.VERSIONS in e))return!1;const t=e[a.MULTI_VERSION_FLAG_KEYS.VERSIONS];return"object"==typeof t&&null!==t&&!Array.isArray(t)&&Object.keys(t).every(e=>(0,s.isValidSemVerVersion)(e))},a.getVersionData=function(e,t){const a=(s=e.versions,Object.entries(s)).sort(([e],[t])=>n(e,t)?-1:1);var s;for(const[e,s]of a)if(n(t,e))return s;return null}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/version.cjs"}],[299,{"../../../../shared/constants/metametrics":6199,"../../../../shared/lib/network-utils":6296,"../../../../shared/lib/only-keep-host":6297,"./utils":300,"@metamask/utils":3504,loglevel:5255},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.onRpcEndpointDegraded=function({chainId:e,endpointUrl:t,error:a,infuraProjectId:s,metaMetricsId:n,trackEvent:r}){u(i.MetaMetricsEventName.RpcServiceDegraded,{chainId:e,endpointUrl:t,error:a,infuraProjectId:s,metaMetricsId:n,trackEvent:r})},a.onRpcEndpointUnavailable=function({chainId:e,endpointUrl:t,error:a,infuraProjectId:s,metaMetricsId:n,trackEvent:r}){u(i.MetaMetricsEventName.RpcServiceUnavailable,{chainId:e,endpointUrl:t,error:a,infuraProjectId:s,metaMetricsId:n,trackEvent:r})},a.trackRpcEndpointEvent=u;var s,n=(s=e("loglevel"))&&s.__esModule?s:{default:s},r=e("@metamask/utils"),i=e("../../../../shared/constants/metametrics"),o=e("../../../../shared/lib/only-keep-host"),c=e("../../../../shared/lib/network-utils"),l=e("./utils");function u(e,{chainId:t,endpointUrl:a,error:s,infuraProjectId:u,trackEvent:d,metaMetricsId:m}){if(!(0,l.shouldCreateRpcServiceEvents)({error:s,metaMetricsId:m}))return;const p=(0,c.isPublicEndpointUrl)(a,u)?(0,o.onlyKeepHost)(a):"custom",h={chain_id_caip:`eip155:${(0,r.hexToNumber)(t)}`,rpc_domain:p,rpc_endpoint_url:p,...(0,r.isObject)(s)&&"httpStatus"in s&&(0,r.isValidJson)(s.httpStatus)?{http_status:s.httpStatus}:{}};n.default.debug(`Creating Segment event "${e}" with ${JSON.stringify(h)}`),d({category:i.MetaMetricsEventCategory.Network,event:e,properties:h})}}}},{package:"$root$",file:"app/scripts/lib/network-controller/messenger-action-handlers.ts"}],[2999,{"@metamask/base-controller":1506,"@metamask/swappable-obj-proxy":3374},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},u=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.SelectedNetworkController=a.SelectedNetworkControllerEventTypes=a.SelectedNetworkControllerActionTypes=a.METAMASK_DOMAIN=void 0;const d=e("@metamask/base-controller"),m=e("@metamask/swappable-obj-proxy"),p="SelectedNetworkController",h={domains:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0}};a.METAMASK_DOMAIN="metamask",a.SelectedNetworkControllerActionTypes={getState:`${p}:getState`,getNetworkClientIdForDomain:`${p}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${p}:setNetworkClientIdForDomain`},a.SelectedNetworkControllerEventTypes={stateChange:`${p}:stateChange`};class f extends d.BaseController{constructor({messenger:e,state:t={domains:{}},domainProxyMap:a}){super({name:p,metadata:h,messenger:e,state:t}),s.add(this),n.set(this,void 0),l(this,n,a,"f"),u(this,s,"m",r).call(this),this.messenger.call("PermissionController:getSubjectNames").filter(e=>this.state.domains[e]===undefined).forEach(e=>this.setNetworkClientIdForDomain(e,this.messenger.call("NetworkController:getState").selectedNetworkClientId)),this.messenger.subscribe("PermissionController:stateChange",(e,t)=>{t.forEach(({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const a=t[1];"add"===e&&this.state.domains[a]===undefined?this.setNetworkClientIdForDomain(a,this.messenger.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[a]!==undefined&&u(this,s,"m",o).call(this,a)}})}),this.messenger.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e,networkConfigurationsByChainId:t},a)=>{const s=a.find(({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]);if(s){const a=Object.values(t).reduce((e,t)=>(t.rpcEndpoints.forEach(({networkClientId:a})=>e[a]=t.chainId),e),{});Object.entries(this.state.domains).forEach(([n,r])=>{const i=a[r];if("remove"!==s.op||i){if("replace"===s.op){const e=s.path[1];if(!i||i===e){const a=t[e],{networkClientId:s}=a.rpcEndpoints[a.defaultRpcEndpointIndex];r!==s&&this.setNetworkClientIdForDomain(n,s)}}}else this.setNetworkClientIdForDomain(n,e)})}})}setNetworkClientIdForDomain(e,t){if(e===a.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${a.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!u(this,s,"m",c).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");u(this,s,"m",i).call(this,e,t)}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messenger.call("NetworkController:getState");return this.state.domains[e]??t}getProviderAndBlockTracker(e){if(e===a.METAMASK_DOMAIN){const e=this.messenger.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=u(this,n,"f").get(e);if(t===undefined){let a;if(u(this,s,"m",c).call(this,e)){const t=this.getNetworkClientIdForDomain(e);a=this.messenger.call("NetworkController:getNetworkClientById",t)}else if(a=this.messenger.call("NetworkController:getSelectedNetworkClient"),a===undefined)throw new Error("Selected network not initialized");t={provider:(0,m.createEventEmitterProxy)(a.provider),blockTracker:(0,m.createEventEmitterProxy)(a.blockTracker,{eventFilter:"skipInternal"})},u(this,n,"f").set(e,t)}return t}}a.SelectedNetworkController=f,n=new WeakMap,s=new WeakSet,r=function(){this.messenger.registerActionHandler(a.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messenger.registerActionHandler(a.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},i=function(e,t){const a=this.messenger.call("NetworkController:getNetworkClientById",t);this.update(a=>{a.domains[e]=t});const s=this.getProviderAndBlockTracker(e);s.provider.setTarget(a.provider),s.blockTracker.setTarget(a.blockTracker)},o=function(e){const t=this.messenger.call("NetworkController:getSelectedNetworkClient"),a=u(this,n,"f").get(e);a&&t?(a.provider.setTarget(t.provider),a.blockTracker.setTarget(t.blockTracker)):a&&u(this,n,"f").delete(e),this.update(t=>{delete t.domains[e]})},c=function(e){return this.messenger.call("PermissionController:hasPermissions",e)}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],[30,{"@metamask/assets-controllers":1380},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.NftDetectionControllerInit=void 0;var s=e("@metamask/assets-controllers");a.NftDetectionControllerInit=e=>{const{controllerMessenger:t,getController:a}=e,n=()=>a("NftController");return{controller:new s.NftDetectionController({messenger:t,addNfts:(...e)=>n().addNfts(...e),getNftState:()=>n().state,disabled:!a("PreferencesController").state.useNftDetection}),persistedStateKey:null}}}}},{package:"$root$",file:"app/scripts/controller-init/assets/nft-detection-controller-init.ts"}],[300,{"../../../../development/build/constants":615,"@metamask/network-controller":2710,"@metamask/remote-feature-flag-controller":2968},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.PRODUCTION_LIKE_ENVIRONMENTS=void 0,a.shouldCreateRpcServiceEvents=function({error:e,metaMetricsId:t}){return(!e||!(0,s.isConnectionError)(e))&&t!==undefined&&null!==t&&function(e){if("pull-request"===undefined)return!1;if(o.includes("pull-request"))return(0,n.generateDeterministicRandomNumber)(e)<i;return!0}(t)};var s=e("@metamask/network-controller"),n=e("@metamask/remote-feature-flag-controller"),r=e("../../../../development/build/constants");const i=.01,o=a.PRODUCTION_LIKE_ENVIRONMENTS=[r.ENVIRONMENT.PRODUCTION,r.ENVIRONMENT.RELEASE_CANDIDATE]}}},{package:"$root$",file:"app/scripts/lib/network-controller/utils.ts"}],[3e3,{"./SelectedNetworkController.cjs":2999},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSelectedNetworkMiddleware=void 0;const s=e("./SelectedNetworkController.cjs");a.createSelectedNetworkMiddleware=e=>(t,a,n)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var r;return t.networkClientId=(r=t.origin,e.call(s.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,r)),n()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],[3001,{"./SelectedNetworkController.cjs":2999,"./SelectedNetworkMiddleware.cjs":3e3},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSelectedNetworkMiddleware=a.METAMASK_DOMAIN=a.SelectedNetworkController=a.SelectedNetworkControllerEventTypes=a.SelectedNetworkControllerActionTypes=void 0;var s=e("./SelectedNetworkController.cjs");Object.defineProperty(a,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return s.SelectedNetworkControllerActionTypes}}),Object.defineProperty(a,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return s.SelectedNetworkControllerEventTypes}}),Object.defineProperty(a,"SelectedNetworkController",{enumerable:!0,get:function(){return s.SelectedNetworkController}}),Object.defineProperty(a,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return s.METAMASK_DOMAIN}});var n=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(a,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return n.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],[3002,{"./constants.cjs":3004,"./logger.cjs":3006,"@metamask/base-controller":1506,"@metamask/signature-controller":3009,"@metamask/transaction-controller":3423,lodash:5247},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,u,d,m,p,h,f,b,g,y=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},w=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ShieldController=a.getDefaultShieldControllerState=void 0;const v=e("@metamask/base-controller"),k=e("@metamask/signature-controller"),_=e("@metamask/transaction-controller"),S=e("lodash"),E=e("./constants.cjs"),T=e("./logger.cjs"),P=(0,T.createModuleLogger)(T.projectLogger,"ShieldController");function M(){return{coverageResults:{},orderedTransactionHistory:[]}}a.getDefaultShieldControllerState=M;const I={coverageResults:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},orderedTransactionHistory:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!1}};class x extends v.BaseController{constructor(e){const{messenger:t,state:a,backend:p,transactionHistoryLimit:h=100,coverageHistoryLimit:f=10,normalizeSignatureRequest:b}=e;super({name:E.controllerName,metadata:I,messenger:t,state:{coverageResults:{},orderedTransactionHistory:[],...a}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),u.set(this,void 0),y(this,n,p,"f"),y(this,r,f,"f"),y(this,i,h,"f"),y(this,c,w(this,s,"m",m).bind(this),"f"),y(this,l,w(this,s,"m",d).bind(this),"f"),y(this,u,!1,"f"),y(this,o,b,"f")}start(){w(this,u,"f")||(y(this,u,!0,"f"),this.messenger.subscribe("TransactionController:stateChange",w(this,c,"f"),e=>e.transactions),this.messenger.subscribe("SignatureController:stateChange",w(this,l,"f"),e=>e.signatureRequests))}stop(){w(this,u,"f")&&(y(this,u,!1,"f"),this.messenger.unsubscribe("TransactionController:stateChange",w(this,c,"f")),this.messenger.unsubscribe("SignatureController:stateChange",w(this,l,"f")))}async checkCoverage(e){const t=w(this,s,"m",g).call(this,e.id),a=await w(this,n,"f").checkCoverage({txMeta:e,coverageId:t});return this.messenger.publish(`${E.controllerName}:coverageResultReceived`,a),w(this,s,"m",p).call(this,e.id,a),a}async checkSignatureCoverage(e){const t=w(this,s,"m",g).call(this,e.id),a=(0,S.cloneDeep)(e),r=w(this,o,"f")?.call(this,a)??a,i=await w(this,n,"f").checkSignatureCoverage({signatureRequest:r,coverageId:t});return this.messenger.publish(`${E.controllerName}:coverageResultReceived`,i),w(this,s,"m",p).call(this,e.id,i),i}}a.ShieldController=x,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,u=new WeakMap,s=new WeakSet,d=function(e,t){const a=Object.values(e),n=Object.values(t??{}),r=new Map(n.map(e=>[e.id,e]));for(const e of a){const t=r.get(e.id);t||this.checkSignatureCoverage(e).catch(e=>P("Error checking coverage:",e)),e.status===k.SignatureRequestStatus.Signed&&e.status!==t?.status&&w(this,s,"m",h).call(this,e).catch(e=>P("Error logging signature:",e))}},m=function(e,t){const a=new Map(t?.map(e=>[e.id,e])??[]);for(const t of e){const e=a.get(t.id);if(t.status!==_.TransactionStatus.submitted&&t.status!==_.TransactionStatus.confirmed){const a=e?.simulationData&&!(0,S.isEqual)(t.simulationData,e.simulationData);e&&!a||this.checkCoverage(t).catch(e=>P("Error checking coverage:",e))}t.status===_.TransactionStatus.submitted&&t.status!==e?.status&&w(this,s,"m",f).call(this,t).catch(e=>P("Error logging transaction:",e))}},p=function(e,t){const a=w(this,s,"m",g).call(this,e);if(a&&t.coverageId!==a)throw new Error("Coverage ID has changed");this.update(a=>{let s=!1,n=a.coverageResults[e];n||(s=!0,n={results:[]},a.coverageResults[e]=n),n.results.length>=w(this,r,"f")&&n.results.pop(),n.results.unshift(t);const{orderedTransactionHistory:o}=a;let c;s&&(o.length>=w(this,i,"f")&&(c=o.pop(),c&&delete a.coverageResults[c]),o.unshift(e))})},h=async function(e){const t=e.rawSig;if(!t)throw new Error("Signature not found");const{status:a}=w(this,s,"m",b).call(this,e.id);await w(this,n,"f").logSignature({signatureRequest:e,signature:t,status:a})},f=async function(e){const t=e.hash;if(!t)throw new Error("Transaction hash not found");const a=e.rawTx;if(!a)throw new Error("Raw transaction hex not found");const{status:r}=w(this,s,"m",b).call(this,e.id);await w(this,n,"f").logTransaction({txMeta:e,transactionHash:t,rawTransactionHex:a,status:r})},b=function(e){let t="shown";return w(this,s,"m",g).call(this,e)||(P("Coverage ID not found for",e),t="not_shown"),{status:t}},g=function(e){return this.state.coverageResults[e]?.results[0]?.coverageId}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/ShieldController.cjs"}],[3003,{"./constants.cjs":3004,"./polling-with-policy.cjs":3007,"@metamask/controller-utils":1625,"@metamask/signature-controller":3009},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,u,d,m=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},p=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.parseSignatureRequestMethod=a.makeInitCoverageCheckBody=a.ShieldRemoteBackend=void 0;const h=e("@metamask/controller-utils"),f=e("@metamask/signature-controller"),b=e("./constants.cjs"),g=e("./polling-with-policy.cjs");function y(e){return{txParams:[{authorizationList:e.txParams.authorizationList,from:e.txParams.from,to:e.txParams.to,value:e.txParams.value,data:e.txParams.data,nonce:e.txParams.nonce}],chainId:e.chainId,origin:e.origin}}function w(e){const t=v(e);return{chainId:e.chainId,data:e.messageParams.data,from:e.messageParams.from,method:t,origin:e.messageParams.origin}}function v(e){if(e.type===f.SignatureRequestType.TypedSign)switch(e.version){case b.SignTypedDataVersion.V3:return f.EthMethod.SignTypedDataV3;case b.SignTypedDataVersion.V4:return f.EthMethod.SignTypedDataV4;case b.SignTypedDataVersion.V1:default:return f.SignatureRequestType.TypedSign}return e.type}function k(e,t){const a=new Error(e);return a.cause=t,a}a.ShieldRemoteBackend=class{constructor({getAccessToken:e,getCoverageResultTimeout:t=5e3,getCoverageResultPollInterval:a=1e3,baseUrl:l,fetch:u,captureException:d}){s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),m(this,n,e,"f"),m(this,r,l,"f"),m(this,i,u,"f");const{backoff:p,maxRetries:f}=function(e,t){const a=new h.ConstantBackoff(t),s=Math.floor(e/t)+1,n=isNaN(s)||!isFinite(s)?h.DEFAULT_MAX_RETRIES:s;return{backoff:a,maxRetries:n}}(t,a);m(this,o,new g.PollingWithCockatielPolicy({backoff:p,maxRetries:f}),"f"),m(this,c,e=>{try{d?.(e)}catch{}},"f")}async checkCoverage(e){let{coverageId:t}=e;if(!t){const a=y(e.txMeta);({coverageId:t}=await p(this,s,"m",l).call(this,"v1/transaction/coverage/init",a))}const a=`${p(this,r,"f")}/v1/transaction/coverage/result`,n=await p(this,s,"m",u).call(this,e.txMeta.id,t,a);return{coverageId:t,message:n.message,reasonCode:n.reasonCode,status:n.status,metrics:n.metrics}}async checkSignatureCoverage(e){let{coverageId:t}=e;if(!t){const a=w(e.signatureRequest);({coverageId:t}=await p(this,s,"m",l).call(this,"v1/signature/coverage/init",a))}const a=`${p(this,r,"f")}/v1/signature/coverage/result`,n=await p(this,s,"m",u).call(this,e.signatureRequest.id,t,a);return{coverageId:t,message:n.message,reasonCode:n.reasonCode,status:n.status,metrics:n.metrics}}async logSignature(e){try{const t=w(e.signatureRequest),a={signature:e.signature,status:e.status,...t};p(this,o,"f").abortPendingRequest(e.signatureRequest.id);const n=await p(this,i,"f").call(this,`${p(this,r,"f")}/v1/signature/coverage/log`,{method:"POST",headers:await p(this,s,"m",d).call(this),body:JSON.stringify(a)});if(200!==n.status)throw new Error(`Failed to log signature: ${n.status}`)}catch(e){const t=k("Failed to log signature",e);throw p(this,c,"f")?.call(this,t),e}}async logTransaction(e){try{const t=y(e.txMeta),a={transactionHash:e.transactionHash,rawTransactionHex:e.rawTransactionHex,status:e.status,...t};p(this,o,"f").abortPendingRequest(e.txMeta.id);const n=await p(this,i,"f").call(this,`${p(this,r,"f")}/v1/transaction/coverage/log`,{method:"POST",headers:await p(this,s,"m",d).call(this),body:JSON.stringify(a)});if(200!==n.status)throw new Error(`Failed to log transaction: ${n.status}`)}catch(e){const t=k("Failed to log transaction",e);throw p(this,c,"f")?.call(this,t),e}}},n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,s=new WeakSet,l=async function(e,t){try{const a=await p(this,i,"f").call(this,`${p(this,r,"f")}/${e}`,{method:"POST",headers:await p(this,s,"m",d).call(this),body:JSON.stringify(t)});if(200!==a.status)throw new Error(`Failed to init coverage check: ${a.status}`);return await a.json()}catch(e){const t=k("Failed to init coverage check",e);throw p(this,c,"f")?.call(this,t),e}},u=async function(e,t,a){const n={coverageId:t},r=await p(this,s,"m",d).call(this),c=Date.now();return{...await p(this,o,"f").start(e,async e=>{const t=await p(this,i,"f").call(this,a,{method:"POST",headers:r,body:JSON.stringify(n),signal:e});if(200===t.status)return await t.json();let s="Timeout waiting for coverage result";try{const e=await t.json();s=`Failed to get coverage result: ${e.message??e.status}`}catch{s=`Failed to get coverage result: ${t.status}`}throw new h.HttpError(t.status,s)}),metrics:{latency:Date.now()-c}}},d=async function(){return{"Content-Type":"application/json",Authorization:`Bearer ${await p(this,n,"f").call(this)}`}},a.makeInitCoverageCheckBody=y,a.parseSignatureRequestMethod=v}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/backend.cjs"}],[3004,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;Object.defineProperty(a,"__esModule",{value:!0}),a.SignTypedDataVersion=a.controllerName=void 0,a.controllerName="ShieldController",function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(s||(a.SignTypedDataVersion=s={}))}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/constants.cjs"}],[3005,{"./ShieldController.cjs":3002,"./backend.cjs":3003},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.parseSignatureRequestMethod=a.ShieldRemoteBackend=a.getDefaultShieldControllerState=a.ShieldController=void 0;var s=e("./ShieldController.cjs");Object.defineProperty(a,"ShieldController",{enumerable:!0,get:function(){return s.ShieldController}}),Object.defineProperty(a,"getDefaultShieldControllerState",{enumerable:!0,get:function(){return s.getDefaultShieldControllerState}});var n=e("./backend.cjs");Object.defineProperty(a,"ShieldRemoteBackend",{enumerable:!0,get:function(){return n.ShieldRemoteBackend}}),Object.defineProperty(a,"parseSignatureRequestMethod",{enumerable:!0,get:function(){return n.parseSignatureRequestMethod}})}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/index.cjs"}],[3006,{"./constants.cjs":3004,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createModuleLogger=a.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(a,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}});const n=e("./constants.cjs");a.projectLogger=(0,s.createProjectLogger)(n.controllerName)}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/logger.cjs"}],[3007,{"@metamask/controller-utils":1625,cockatiel:4533},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)},u=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a};Object.defineProperty(a,"__esModule",{value:!0}),a.PollingWithCockatielPolicy=void 0;const d=e("@metamask/controller-utils"),m=e("cockatiel");a.PollingWithCockatielPolicy=class{constructor(e={}){s.add(this),n.set(this,void 0),r.set(this,new Map);const t=l(this,s,"m",c).bind(this),a=(0,m.handleWhen)(t);u(this,n,(0,d.createServicePolicy)({...e,retryFilterPolicy:a}),"f")}async start(e,t){const a=l(this,s,"m",i).call(this,e);try{return await l(this,n,"f").execute(async({signal:e})=>t(e),a.signal)}catch(e){if(a.signal.aborted)throw new Error("Request cancelled");throw e}finally{a===l(this,r,"f").get(e)&&l(this,s,"m",o).call(this,e)}}abortPendingRequest(e){const t=l(this,r,"f").get(e);t?.abort(),l(this,s,"m",o).call(this,e)}},n=new WeakMap,r=new WeakMap,s=new WeakSet,i=function(e){this.abortPendingRequest(e);const t=new AbortController;return l(this,r,"f").set(e,t),t},o=function(e){l(this,r,"f").delete(e)},c=function(e){return e instanceof d.HttpError&&(e.httpStatus>400&&e.httpStatus<500)}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/polling-with-policy.cjs"}],[301,{"../../../shared/constants/notifications":6204,"../platforms/extension":600,"@metamask/safe-event-emitter":2978},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=a.NOTIFICATION_MANAGER_EVENTS=void 0;var s=i(e("@metamask/safe-event-emitter")),n=i(e("../platforms/extension")),r=e("../../../shared/constants/notifications");function i(e){return e&&e.__esModule?e:{default:e}}const o=a.NOTIFICATION_MANAGER_EVENTS={POPUP_CLOSED:"onPopupClosed"};class c extends s.default{constructor(){super(),this.platform=new n.default,this.platform.addOnRemovedListener(this._onWindowClosed.bind(this))}markAsAutomaticallyClosed(){this._popupAutomaticallyClosed=!0}async showPopup(e,t){this._popupId=t,this._setCurrentPopupId=e;const a=await this._getPopup(t);if(a)await this.platform.focusWindow(a.id);else{let e=0,t=0;try{const a=await this.platform.getLastFocusedWindow();t=a.top,e=Math.max(a.left+(a.width-r.NOTIFICATION_WIDTH),0)}catch(a){const{screenX:s,screenY:n,outerWidth:i}=window;t=Math.max(n,0),e=Math.max(s+(i-r.NOTIFICATION_WIDTH),0)}const a=await this.platform.openWindow({url:"notification.html",type:"popup",width:r.NOTIFICATION_WIDTH,height:r.NOTIFICATION_HEIGHT,left:e,top:t});a.left!==e&&"fullscreen"!==a.state&&await this.platform.updateWindowPosition(a.id,e,t),this._setCurrentPopupId(a.id),this._popupId=a.id}}_onWindowClosed(e){e===this._popupId&&(this._setCurrentPopupId(undefined),this._popupId=undefined,this.emit(o.POPUP_CLOSED,{automaticallyClosed:this._popupAutomaticallyClosed}),this._popupAutomaticallyClosed=undefined)}async _getPopup(){const e=await this.platform.getAllWindows();return this._getPopupIn(e)}_getPopupIn(e){return e?e.find(e=>e&&"popup"===e.type&&e.id===this._popupId):null}}a.default=c}}},{package:"$root$",file:"app/scripts/lib/notification-manager.js"}],[302,{"../../../../shared/constants/offscreen-communication":6205,"eth-lattice-keyring":4678},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.LatticeKeyringOffscreen=void 0;var s,n=(s=e("eth-lattice-keyring"))&&s.__esModule?s:{default:s},r=e("../../../../shared/constants/offscreen-communication");class i extends n.default{constructor(e={}){super(e)}async _getCreds(){try{if(this._hasCreds())return undefined;const e=this.appName?this.appName:"Unknown",t=`${r.KnownOrigins.lattice}?keyring=${e}&forceLogin=true`,a=await new Promise((e,a)=>{chrome.runtime.sendMessage({target:r.OffscreenCommunicationTarget.latticeOffscreen,params:{url:t}},t=>{chrome.runtime.lastError?a(chrome.runtime.lastError):null!=t&&t.error?a(t.error):e(null==t?void 0:t.result)})});if(null==a||!a.deviceID||null==a||!a.password)throw new Error("Invalid credentials returned from Lattice.");return a}catch(e){throw new Error(e)}}}a.LatticeKeyringOffscreen=i,function(e,t,a){(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a}(i,"type",void 0),i.type=n.default.type}}},{package:"$root$",file:"app/scripts/lib/offscreen-bridge/lattice-offscreen-keyring.ts"}],[303,{"../../../../shared/constants/offscreen-communication":6205,"@ledgerhq/errors":985},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.LedgerOffscreenBridge=void 0;var s=e("@ledgerhq/errors"),n=e("../../../../shared/constants/offscreen-communication");function r(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function i(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}const c=4e3;var l=new WeakSet;async function u(e,{timeout:t}={}){return new Promise((a,r)=>{let i;t&&(i=setTimeout(()=>{r(new Error("Ledger iframe timeout"))},t)),chrome.runtime.sendMessage({...e,target:n.OffscreenCommunicationTarget.ledgerOffscreen},e=>{if(clearTimeout(i),null!=e&&e.success)a(e.payload||e.success);else{var t;const a=null==e||null===(t=e.payload)||void 0===t?void 0:t.error;if(a&&"number"==typeof a.statusCode&&a.statusCode>0){const e=new s.TransportStatusError(a.statusCode);r(e)}else if(null!=a&&a.message){const e=new Error(a.message,{cause:a});r(e)}else r(new Error("Unknown Ledger error occurred"))}})})}a.LedgerOffscreenBridge=class{constructor(){r(this,l),i(this,"isDeviceConnected",!1)}init(){return chrome.runtime.onMessage.addListener(e=>{e.target===n.OffscreenCommunicationTarget.extension&&e.event===n.OffscreenCommunicationEvents.ledgerDeviceConnect&&(this.isDeviceConnected=!0)}),Promise.resolve()}destroy(){return Promise.resolve()}getOptions(){return Promise.resolve({})}setOptions(){return Promise.resolve()}attemptMakeApp(){return o(l,this,u).call(this,{action:n.LedgerAction.makeApp},{timeout:c})}updateTransportMethod(e){return o(l,this,u).call(this,{action:n.LedgerAction.updateTransport,params:{transportType:e}},{timeout:c})}getAppNameAndVersion(){return o(l,this,u).call(this,{action:n.LedgerAction.getAppNameAndVersion},{timeout:c})}getPublicKey(e){return o(l,this,u).call(this,{action:n.LedgerAction.getPublicKey,params:e})}deviceSignTransaction(e){return o(l,this,u).call(this,{action:n.LedgerAction.signTransaction,params:e})}deviceSignMessage(e){return o(l,this,u).call(this,{action:n.LedgerAction.signPersonalMessage,params:e})}deviceSignTypedData(e){return o(l,this,u).call(this,{action:n.LedgerAction.signTypedData,params:e})}}}}},{package:"$root$",file:"app/scripts/lib/offscreen-bridge/ledger-offscreen-bridge.ts"}],[3031,{"../snaps/Timer.cjs":3053,"../snaps/constants.cjs":3054,"./utils.cjs":3033,"@metamask/base-controller":1506,"@metamask/snaps-rpc-methods":3159,"@metamask/snaps-utils":3096,"@metamask/utils":3504,immer:5024,luxon:5258,nanoid:5446},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){n(e,t),t.set(e,a)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,a){return e.set(o(e,t),a),a}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.CronjobController=a.DAILY_TIMEOUT=void 0;const c=e("@metamask/base-controller"),l=e("@metamask/snaps-rpc-methods"),u=e("@metamask/snaps-utils"),d=e("@metamask/utils"),m=e("immer"),p=e("luxon"),h=e("nanoid"),f=e("./utils.cjs"),b=e("../snaps/constants.cjs"),g=e("../snaps/Timer.cjs");a.DAILY_TIMEOUT=(0,d.inMilliseconds)(24,d.Duration.Hour);const y="CronjobController";var w=new WeakMap,v=new WeakMap,k=new WeakMap,_=new WeakSet,S=new WeakMap,E=new WeakMap,T=new WeakMap,P=new WeakMap,M=new WeakMap;class I extends c.BaseController{constructor({messenger:e,state:t,stateManager:c}){var l,u;super({messenger:e,metadata:{events:{includeInStateLogs:!1,persist:!1,includeInDebugSnapshot:!1,usedInUi:!1}},name:y,state:{events:{},...t,...c.getInitialState()}}),n(l=this,u=_),u.add(l),s(this,w,void 0),s(this,v,void 0),s(this,k,new g.Timer(a.DAILY_TIMEOUT)),s(this,S,e=>{this.unregister(e.id),this.register(e.id)}),s(this,E,e=>{const t=this.get(e.id);o(_,this,$).call(this,t),this.register(e.id)}),s(this,T,e=>{this.unregister(e.id)}),s(this,P,e=>{this.unregister(e.id)}),s(this,M,e=>{this.unregister(e.id),this.register(e.id)}),i(w,this,new Map),i(v,this,c),this.messenger.subscribe("SnapController:snapInstalled",r(S,this)),this.messenger.subscribe("SnapController:snapUninstalled",r(T,this)),this.messenger.subscribe("SnapController:snapEnabled",r(E,this)),this.messenger.subscribe("SnapController:snapDisabled",r(P,this)),this.messenger.subscribe("SnapController:snapUpdated",r(M,this)),this.messenger.registerActionHandler(`${y}:init`,(...e)=>this.init(...e)),this.messenger.registerActionHandler(`${y}:schedule`,(...e)=>this.schedule(...e)),this.messenger.registerActionHandler(`${y}:cancel`,(...e)=>this.cancel(...e)),this.messenger.registerActionHandler(`${y}:get`,(...e)=>this.get(...e))}init(){o(_,this,x).call(this),o(_,this,D).call(this),o(_,this,$).call(this)}schedule(e){return o(_,this,C).call(this,{...e,recurring:!1})}cancel(e,t){(0,d.assert)(this.state.events[t],`A background event with the id of "${t}" does not exist.`),(0,d.assert)(this.state.events[t].snapId===e,"Only the origin that scheduled this event can cancel it."),o(_,this,O).call(this,t)}get(e){return Object.values(this.state.events).filter(t=>t.snapId===e&&!t.recurring).map(e=>({...e,date:(0,u.toCensoredISO8601String)(e.date),scheduledAt:(0,u.toCensoredISO8601String)(e.scheduledAt)}))}register(e){const t=o(_,this,N).call(this,e);null==t||t.forEach(e=>o(_,this,C).call(this,e))}unregister(e){for(const[t,a]of Object.entries(this.state.events))a.snapId===e&&o(_,this,O).call(this,t)}destroy(){super.destroy(),this.messenger.unsubscribe("SnapController:snapInstalled",r(S,this)),this.messenger.unsubscribe("SnapController:snapUninstalled",r(T,this)),this.messenger.unsubscribe("SnapController:snapEnabled",r(E,this)),this.messenger.unsubscribe("SnapController:snapDisabled",r(P,this)),this.messenger.unsubscribe("SnapController:snapUpdated",r(M,this)),r(w,this).forEach(e=>e.cancel()),r(w,this).clear(),"running"===r(k,this).status&&r(k,this).cancel()}}function x(){i(k,this,new g.Timer(a.DAILY_TIMEOUT)),r(k,this).start(()=>{o(_,this,$).call(this),o(_,this,x).call(this)})}function C(e){const t=e.id??(0,h.nanoid)(),a={...e,id:t,date:(0,f.getExecutionDate)(e.schedule),scheduledAt:(new Date).toISOString()},{nextState:s}=this.update(e=>{e.events[a.id]=(0,m.castDraft)(a)});return r(v,this).set(s),o(_,this,A).call(this,a),t}function A(e,t=!0){if(!t)return void o(_,this,j).call(this,e);const a=(0,f.getExecutionDate)(e.schedule),{nextState:s}=this.update(t=>{t.events[e.id].date=a});r(v,this).set(s),o(_,this,j).call(this,{...e,date:a})}function j(e){const t=p.DateTime.fromISO(e.date,{setZone:!0}).toMillis()-Date.now();if(t>a.DAILY_TIMEOUT)return;if(t<=0)return void o(_,this,R).call(this,e);const s=new g.Timer(t);s.start(()=>{o(_,this,R).call(this,e)}),r(w,this).set(e.id,s)}function R(e){if(this.messenger.call("SnapController:handleRequest",{snapId:e.snapId,origin:b.METAMASK_ORIGIN,handler:u.HandlerType.OnCronjob,request:e.request}).catch(t=>{(0,u.logError)(`An error occurred while executing an event for Snap "${e.snapId}":`,t)}),r(w,this).delete(e.id),!e.recurring){const{nextState:t}=this.update(t=>{delete t.events[e.id]});return void r(v,this).set(t)}o(_,this,A).call(this,e)}function O(e){const t=r(w,this).get(e);null==t||t.cancel(),r(w,this).delete(e);const{nextState:a}=this.update(t=>{delete t.events[e]});r(v,this).set(a)}function N(e){const t=this.messenger.call("PermissionController:getPermissions",e),a=null==t?void 0:t[l.SnapEndowments.Cronjob],s=(0,l.getCronjobCaveatJobs)(a);return s?s.map((t,a)=>({snapId:e,id:`cronjob-${e}-${a}`,request:t.request,schedule:(0,f.getCronjobSpecificationSchedule)(t),recurring:!0})):[]}function $(e=Object.values(this.state.events)){const t=Date.now();for(const a of e){if(r(w,this).has(a.id))continue;const e=p.DateTime.fromISO(a.date,{setZone:!0}).toUTC().toMillis();a.recurring&&e<=t?o(_,this,R).call(this,a):o(_,this,A).call(this,a,!1)}}function D(){const e=Date.now();for(const t of Object.values(this.state.events)){const a=p.DateTime.fromISO(t.date,{setZone:!0}).toUTC().toMillis();!t.recurring&&a<e&&o(_,this,O).call(this,t.id)}}a.CronjobController=I}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"}],[3032,{"./CronjobController.cjs":3031},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./CronjobController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs"}],[3033,{"@metamask/utils":3504,"cron-parser":4578,luxon:5258},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getExecutionDate=a.getCronjobSpecificationSchedule=void 0;const s=e("@metamask/utils"),n=e("cron-parser"),r=e("luxon");a.getCronjobSpecificationSchedule=function(e){return(0,s.hasProperty)(e,"duration")?e.duration:e.expression},a.getExecutionDate=function(e){const t=r.DateTime.fromISO(e,{setZone:!0});if(t.isValid){const e=Date.now(),a=t.toUTC().startOf("second");if(a.toMillis()<e)throw new Error("Cannot schedule an event in the past.");return a.toISO({suppressMilliseconds:!0})}const a=r.Duration.fromISO(e);if(a.isValid){const e=function(e){return e.as("seconds")<1?r.Duration.fromObject({seconds:1}):e}(a);return r.DateTime.now().toUTC().plus(e).toISO()}try{const t=(0,n.parseExpression)(e,{utc:!0}).next(),a=r.DateTime.fromJSDate(t.toDate());return(0,s.assert)(a.isValid),a.toUTC().toISO()}catch{throw new Error(`Unable to parse "${e}" as ISO 8601 date, ISO 8601 duration, or cron expression.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs"}],[3034,{"@metamask/utils":3504,"@xstate/fsm":3978},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.forceStrict=a.validateMachine=void 0;const s=e("@metamask/utils"),n=e("@xstate/fsm");a.validateMachine=function(e){(0,s.assert)("_options"in e,"The machine is not an @xstate/fsm machine");const t=e,a=new Set,n=e=>{return(t=e,Array.isArray(t)?t:t===undefined||null===t?[]:[t]).flatMap(e=>"string"==typeof e?[e]:((0,s.assert)("function"==typeof e),[])).forEach(a.add.bind(a));var t};for(const e of Object.values(t.config.states)){n(e.entry),n(e.exit);for(const t of Object.values(e.on??{}))n(t.actions)}a.forEach(e=>(0,s.assert)(t._options.actions!==undefined&&e in t._options.actions,`Action "${e}" doesn't have an implementation`))},a.forceStrict=function(e){let t=!1;e.subscribe(e=>{(0,s.assert)(!t||e.changed,"Invalid state transition"),t=!0});const a=e.send.bind(e);e.send=(...t)=>((0,s.assert)(e.status===n.InterpreterStatus.Running,"Interpreter is stopped"),a(...t))}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/fsm.cjs"}],[3035,{"./cronjob/index.cjs":3032,"./insights/index.cjs":3037,"./interface/index.cjs":3039,"./multichain/index.cjs":3043,"./services/index.cjs":3048,"./snaps/index.cjs":3055,"./utils.cjs":3065,"./websocket/index.cjs":3067},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./services/index.cjs"),a),n(e("./snaps/index.cjs"),a),n(e("./utils.cjs"),a),n(e("./cronjob/index.cjs"),a),n(e("./interface/index.cjs"),a),n(e("./insights/index.cjs"),a),n(e("./multichain/index.cjs"),a),n(e("./websocket/index.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/index.cjs"}],[3036,{"../snaps/index.cjs":3055,"@metamask/base-controller":1506,"@metamask/snaps-rpc-methods":3159,"@metamask/snaps-utils":3096,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function n(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.SnapInsightsController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-rpc-methods"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("../snaps/index.cjs");var u=new WeakSet;class d extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{insights:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!0}},name:"SnapInsightsController",state:{insights:{},...t}}),s(this,u),this.messenger.subscribe("TransactionController:unapprovedTransactionAdded",n(u,this,h).bind(this)),this.messenger.subscribe("TransactionController:transactionStatusUpdated",n(u,this,g).bind(this)),this.messenger.subscribe("SignatureController:stateChange",n(u,this,f).bind(this))}}function m(e){return(0,c.hasProperty)(this.state.insights,e)}function p(e){const t=this.messenger.call("SnapController:getAll");return(0,l.getRunnableSnaps)(t).reduce((t,a)=>{const s=this.messenger.call("PermissionController:getPermissions",a.id);return s&&(0,c.hasProperty)(s,e)&&t.push({snapId:a.id,permission:s[e]}),t},[])}function h(e){const{id:t,txParams:a,chainId:s,origin:r}=e,l=`eip155:${(0,c.hexToBigInt)(s).toString(10)}`;n(u,this,p).call(this,i.SnapEndowments.TransactionInsight).forEach(({snapId:e,permission:s})=>{const c=(0,i.getTransactionOriginCaveat)(s)&&r?r:null;this.update(a=>{var s;(s=a.insights)[t]??(s[t]={}),a.insights[t][e]={snapId:e,loading:!0}}),n(u,this,w).call(this,{snapId:e,handler:o.HandlerType.OnTransaction,params:{transaction:a,chainId:l,transactionOrigin:c}}).then(a=>n(u,this,v).call(this,{id:t,snapId:e,response:a})).catch(a=>n(u,this,v).call(this,{id:t,snapId:e,error:a}))})}function f(e){for(const t of Object.keys(this.state.insights))(0,c.hasProperty)(e.unapprovedTypedMessages,t)||(0,c.hasProperty)(e.unapprovedPersonalMsgs,t)||n(u,this,y).call(this,t);if(e.unapprovedPersonalMsgCount>0||e.unapprovedTypedMessagesCount>0){const t=n(u,this,p).call(this,i.SnapEndowments.SignatureInsight);for(const a of Object.values(e.unapprovedPersonalMsgs))n(u,this,b).call(this,t,a);for(const a of Object.values(e.unapprovedTypedMessages))n(u,this,b).call(this,t,a)}}function b(e,t){const{id:a,msgParams:s}=t;if(n(u,this,m).call(this,a))return;const{from:r,data:c,signatureMethod:l,origin:d}=s,p={from:r,data:"eth_signTypedData_v3"===l||"eth_signTypedData_v4"===l?JSON.parse(c):c,signatureMethod:l};e.forEach(({snapId:e,permission:t})=>{const s=(0,i.getSignatureOriginCaveat)(t),r=d&&s?d:null;this.update(t=>{var s;(s=t.insights)[a]??(s[a]={}),t.insights[a][e]={snapId:e,loading:!0}}),n(u,this,w).call(this,{snapId:e,handler:o.HandlerType.OnSignature,params:{signature:p,signatureOrigin:r}}).then(t=>n(u,this,v).call(this,{id:a,snapId:e,response:t})).catch(t=>n(u,this,v).call(this,{id:a,snapId:e,error:t}))})}function g({transactionMeta:e}){"unapproved"!==e.status&&n(u,this,y).call(this,e.id)}function y(e){n(u,this,m).call(this,e)&&(Object.values(this.state.insights[e]).filter(e=>e.interfaceId).forEach(e=>{this.messenger.call("SnapInterfaceController:deleteInterface",e.interfaceId)}),this.update(t=>{delete t.insights[e]}))}async function w({snapId:e,handler:t,params:a}){return this.messenger.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:t,request:{method:"",params:a}})}function v({id:e,snapId:t,response:a,error:s}){n(u,this,m).call(this,e)&&this.update(n=>{n.insights[e][t].loading=!1,n.insights[e][t].interfaceId=null==a?void 0:a.id,n.insights[e][t].severity=null==a?void 0:a.severity,n.insights[e][t].error=null==s?void 0:s.message})}a.SnapInsightsController=d}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"}],[3037,{"./SnapInsightsController.cjs":3036},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./SnapInsightsController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/index.cjs"}],[3038,{"./utils.cjs":3040,"@metamask/base-controller":1506,"@metamask/snaps-sdk":3215,"@metamask/snaps-utils":3096,"@metamask/utils":3504,immer:5024,nanoid:5446},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function n(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.SnapInterfaceController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-sdk"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("immer"),u=e("nanoid"),d=e("./utils.cjs"),m=1e7,p="SnapInterfaceController";var h=new WeakSet;class f extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{interfaces:{includeInStateLogs:!0,persist:e=>Object.entries(e).reduce((e,[t,a])=>a.contentType===i.ContentType.Notification?(e[t]=a,e):e,{}),includeInDebugSnapshot:!1,usedInUi:!0}},name:p,state:{interfaces:{},...t}}),s(this,h),this.messenger.subscribe("NotificationServicesController:notificationsListUpdated",n(h,this,x).bind(this)),n(h,this,b).call(this)}createInterface(e,t,a,s){const r=(0,d.getJsxInterface)(t);n(h,this,I).call(this,e,r),(0,d.validateInterfaceContext)(a);const i=(0,u.nanoid)(),c=(0,d.constructState)({},r,{getAssetsState:n(h,this,T).bind(this),getAccountByAddress:n(h,this,E).bind(this),getSelectedAccount:n(h,this,_).bind(this),listAccounts:n(h,this,S).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});return this.update(t=>{t.interfaces[i]={snapId:e,content:(0,l.castDraft)(r),state:c,context:a??null,contentType:s??null}}),i}getInterface(e,t){return n(h,this,g).call(this,e,t),this.state.interfaces[t]}updateInterface(e,t,a,s){n(h,this,g).call(this,e,t);const r=(0,d.getJsxInterface)(a);n(h,this,I).call(this,e,r),(0,d.validateInterfaceContext)(s);const i=this.state.interfaces[t].state,c=(0,d.constructState)(i,r,{getAssetsState:n(h,this,T).bind(this),getAccountByAddress:n(h,this,E).bind(this),getSelectedAccount:n(h,this,_).bind(this),listAccounts:n(h,this,S).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});this.update(e=>{e.interfaces[t].state=c,e.interfaces[t].content=(0,l.castDraft)(r),s&&(e.interfaces[t].context=s)})}deleteInterface(e){this.update(t=>{delete t.interfaces[e]})}updateInterfaceState(e,t){this.update(a=>{a.interfaces[e].state=t})}async resolveInterface(e,t,a){n(h,this,g).call(this,e,t),n(h,this,y).call(this,t),await n(h,this,k).call(this,t,a),this.deleteInterface(t)}}function b(){this.messenger.registerActionHandler(`${p}:createInterface`,this.createInterface.bind(this)),this.messenger.registerActionHandler(`${p}:getInterface`,this.getInterface.bind(this)),this.messenger.registerActionHandler(`${p}:updateInterface`,this.updateInterface.bind(this)),this.messenger.registerActionHandler(`${p}:deleteInterface`,this.deleteInterface.bind(this)),this.messenger.registerActionHandler(`${p}:updateInterfaceState`,this.updateInterfaceState.bind(this)),this.messenger.registerActionHandler(`${p}:resolveInterface`,this.resolveInterface.bind(this))}function g(e,t){const a=this.state.interfaces[t];(0,c.assert)(a!==undefined,`Interface with id '${t}' not found.`),(0,c.assert)(a.snapId===e,`Interface not created by ${e}.`)}function y(e){(0,c.assert)(n(h,this,v).call(this,e),`Approval request with id '${e}' not found.`)}function w(e){return this.messenger.call("PhishingController:testOrigin",e).result}function v(e){return this.messenger.call("ApprovalController:hasRequest",{id:e})}async function k(e,t){await this.messenger.call("ApprovalController:acceptRequest",e,t)}function _(){return this.messenger.call("AccountsController:getSelectedMultichainAccount")}function S(e){const t=this.messenger.call("AccountsController:listMultichainAccounts");return e&&0!==e.length?t.filter(t=>t.scopes.some(t=>(0,d.isMatchingChainId)(t,e))):t}function E(e){const{address:t}=(0,c.parseCaipAccountId)(e);return this.messenger.call("AccountsController:getAccountByAddress",t)}function T(){return this.messenger.call("MultichainAssetsController:getState")}function P(e){return this.messenger.call("SnapController:get",e)}function M(e,t){return this.messenger.call("PermissionController:hasPermission",e,t)}function I(e,t){const a=(0,o.getJsonSizeUnsafe)(t);(0,c.assert)(a<=m,"A Snap UI may not be larger than 10 MB."),(0,o.validateJsxElements)(t,{isOnPhishingList:n(h,this,w).bind(this),getSnap:n(h,this,P).bind(this),getAccountByAddress:n(h,this,E).bind(this),hasPermission:n(h,this,M).bind(this,e)})}function x(e){const t=e.filter(e=>"snap"===e.type&&(0,c.hasProperty)(e.data,"detailedView")),a=new Set(t.map(e=>e.data.detailedView.interfaceId));this.update(e=>{Object.entries(e.interfaces).forEach(([t,s])=>{s.contentType!==i.ContentType.Notification||a.has(t)||delete e.interfaces[t]})})}a.SnapInterfaceController=f}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"}],[3039,{"./SnapInterfaceController.cjs":3038},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./SnapInterfaceController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/index.cjs"}],[304,{"../../../../shared/constants/offscreen-communication":6205},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.TrezorOffscreenBridge=void 0;var s=e("../../../../shared/constants/offscreen-communication");function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}a.TrezorOffscreenBridge=class{constructor(){n(this,"model",void 0),n(this,"minorVersion",void 0)}init(e){return chrome.runtime.onMessage.addListener(e=>{e.target===s.OffscreenCommunicationTarget.extension&&e.event===s.OffscreenCommunicationEvents.trezorDeviceConnect&&(this.model=e.payload.model,this.minorVersion=e.payload.minorVersion)}),new Promise(t=>{chrome.runtime.sendMessage({target:s.OffscreenCommunicationTarget.trezorOffscreen,action:s.TrezorAction.init,params:e},()=>{t()})})}dispose(){return new Promise(e=>{chrome.runtime.sendMessage({target:s.OffscreenCommunicationTarget.trezorOffscreen,action:s.TrezorAction.dispose},()=>{e()})})}getPublicKey(e){return new Promise(t=>{chrome.runtime.sendMessage({target:s.OffscreenCommunicationTarget.trezorOffscreen,action:s.TrezorAction.getPublicKey,params:e},e=>{t(e)})})}ethereumSignTransaction(e){return new Promise(t=>{chrome.runtime.sendMessage({target:s.OffscreenCommunicationTarget.trezorOffscreen,action:s.TrezorAction.signTransaction,params:e},e=>{t(e)})})}ethereumSignMessage(e){return new Promise(t=>{chrome.runtime.sendMessage({target:s.OffscreenCommunicationTarget.trezorOffscreen,action:s.TrezorAction.signMessage,params:e},e=>{t(e)})})}ethereumSignTypedData(e){return new Promise(t=>{chrome.runtime.sendMessage({target:s.OffscreenCommunicationTarget.trezorOffscreen,action:s.TrezorAction.signTypedData,params:e},e=>{t(e)})})}}}}},{package:"$root$",file:"app/scripts/lib/offscreen-bridge/trezor-offscreen-bridge.ts"}],[3040,{"@metamask/snaps-sdk":3215,"@metamask/snaps-sdk/jsx":3302,"@metamask/snaps-utils":3096,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.validateInterfaceContext=a.constructState=a.getAccountSelectorStateValue=a.getAssetSelectorStateValue=a.getAccountSelectorDefaultStateValue=a.getDefaultAsset=a.formatAccountSelectorStateValue=a.isMatchingChainId=a.assertNameIsUnique=a.getJsxInterface=a.isStatefulComponent=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/snaps-sdk/jsx"),r=e("@metamask/snaps-utils"),i=e("@metamask/utils"),o=["Input","Dropdown","RadioGroup","FileInput","Checkbox","Selector","AssetSelector","AddressInput","AccountSelector","DateTimePicker"];function c(e){return o.includes(e.type)}function l(e,t){(0,s.assert)(e[t]===undefined,`Duplicate component names are not allowed, found multiple instances of: "${t}".`)}function u(e,t){return"eip155:0"===e?t.some(e=>{const{namespace:t}=(0,i.parseCaipChainId)(e);return t===i.KnownCaipNamespace.Eip155}):t.includes(e)}function d(e,t){const{id:a,address:s,scopes:n}=e,i=(0,r.createChainIdList)(n,t);return{accountId:a,addresses:(0,r.createAccountList)(s,i)}}function m(e,t,{getAccountByAddress:a,getAssetsState:n}){var r;const{assetsMetadata:o,accountsAssets:c}=n(),l=e.map(e=>(0,i.parseCaipAccountId)(e)).map(({chainId:e})=>e),u=t&&t.length>0?l.filter(e=>t.includes(e)):l,d=null===(r=a(e[0]))||void 0===r?void 0:r.id;(0,s.assert)(d,`Account not found for address: ${e[0]}.`);const m=c[d];if(0===m.length)return null;const p=m.find(e=>{const{chainId:t,assetNamespace:a}=(0,i.parseCaipAssetType)(e);return u.includes(t)&&"slip44"===a});return p?{asset:p,name:o[p].name,symbol:o[p].symbol}:{asset:m[0],name:o[m[0]].name,symbol:o[m[0]].symbol}}function p(e,{getSelectedAccount:t,listAccounts:a,snapOwnsAccount:s}){const{chainIds:n,hideExternalAccounts:r}=e.props,i=t();if((!n||0===n.length||i.scopes.some(e=>u(e,n)))&&(!r||r&&s(i)))return d(i,n);const o=a(n),c=r?o.filter(e=>s(e)):o;return 0===c.length?null:d(c[0],n)}function h(e,t){if(!e)return null;const{assetsMetadata:a}=t(),s=a[e];return s?{asset:e,name:s.name??s.symbol??"Unknown",symbol:s.symbol??"Unknown"}:null}function f(e,{getAccountByAddress:t,snapOwnsAccount:a}){const{value:s,hideExternalAccounts:n}=e.props;if(!s)return null;const r=t(s);return r?n&&!a(r)?null:d(r,e.props.chainIds):null}function b(e,t,a,s){const n=s?e[s]:e,o=null==n?void 0:n[t.props.name];return"FileInput"===t.type?o??null:function(e,t){switch(e.type){case"Checkbox":return e.props.checked;case"AssetSelector":return h(e.props.value,t.getAssetsState);case"AddressInput":{if(!e.props.value)return null;const{namespace:t,reference:a}=(0,i.parseCaipChainId)(e.props.chainId);return(0,i.toCaipAccountId)(t,a,e.props.value)}case"AccountSelector":return f(e,t);default:return e.props.value}}(t,a)??o??function(e,t){switch(e.type){case"Dropdown":var a;return null===(a=(0,r.getJsxChildren)(e)[0])||void 0===a?void 0:a.props.value;case"RadioGroup":var s;return null===(s=(0,r.getJsxChildren)(e)[0])||void 0===s?void 0:s.props.value;case"Selector":var n;return null===(n=(0,r.getJsxChildren)(e)[0])||void 0===n?void 0:n.props.value;case"AccountSelector":return p(e,t);case"Checkbox":return!1;case"AssetSelector":return m(e.props.addresses,e.props.chainIds,t);default:return null}}(t,a)??null}a.isStatefulComponent=c,a.getJsxInterface=function(e){return(0,n.isJSXElementUnsafe)(e)?e:(0,r.getJsxElementFromComponent)(e)},a.assertNameIsUnique=l,a.isMatchingChainId=u,a.formatAccountSelectorStateValue=d,a.getDefaultAsset=m,a.getAccountSelectorDefaultStateValue=p,a.getAssetSelectorStateValue=h,a.getAccountSelectorStateValue=f,a.constructState=function(e,t,a){const s={},n=[];return(0,r.walkJsx)(t,(t,r)=>{let i=n[n.length-1];if(i&&r<=i.depth&&(n.pop(),i=n[n.length-1]),"Form"===t.type)return l(s,t.props.name),n.push({name:t.props.name,depth:r}),void(s[t.props.name]={});if(i&&c(t)){const n=s[i.name];return l(n,t.props.name),void(n[t.props.name]=b(e,t,a,i.name))}c(t)&&(l(s,t.props.name),s[t.props.name]=b(e,t,a))}),s};const g=5e6;a.validateInterfaceContext=function(e){if(!e)return;const t=(0,r.getJsonSizeUnsafe)(e);(0,s.assert)(t<=g,"A Snap interface context may not be larger than 5 MB.")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs"}],[3041,{"@metamask/snaps-utils":3096,"@metamask/utils":3504},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.log=void 0;const s=e("@metamask/snaps-utils"),n=e("@metamask/utils");a.log=(0,n.createModuleLogger)(s.snapsLogger,"snaps-controllers")}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/logging.cjs"}]],[],{});