LavaPack.loadBundle([[2262,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[2263,{"./build/multichain-openrpc.json":2261,"./build/openrpc.json":2262},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.MultiChainOpenRPCDocument=s.MetaMaskOpenRPCDocument=void 0;const a=r(e("./build/openrpc.json"));s.MetaMaskOpenRPCDocument=a.default;const n=r(e("./build/multichain-openrpc.json"));s.MultiChainOpenRPCDocument=n.default,s.default=a.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],[228,{"../../../../../shared/constants/keyring":5721,"../../../../../shared/constants/snaps/permissions":5741,"@metamask/keyring-controller":2173,"@metamask/snaps-rpc-methods":2710,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getSnapPermissionSpecifications=function(e,t){return{...(0,r.buildSnapEndowmentSpecifications)(Object.keys(i.ExcludedSnapEndowments)),...(0,r.buildSnapRestrictedMethodSpecifications)(Object.keys(i.ExcludedSnapPermissions),{getPreferences:()=>{const t=e.call("CurrencyRateController:getState").currentCurrency,{currentLocale:s,openSeaEnabled:r,preferences:{privacyMode:a,showTestNetworks:n},securityAlertsEnabled:i,useCurrencyRateCheck:o,useTransactionSimulations:c,useTokenDetection:l,useMultiAccountBalanceChecker:d,useNftDetection:u}=e.call("PreferencesController:getState");return{locale:s,currency:t,hideBalances:a,useSecurityAlerts:i,useExternalPricingData:o,simulateOnChainActions:c,useTokenDetection:l,batchCheckBalances:d,displayNftMedia:r,useNftDetection:u,showTestnets:n}},clearSnapState:e.call.bind(e,"SnapController:clearSnapState"),getMnemonic:async t=>{if(!t){const[t]=e.call("KeyringController:getKeyringsByType",o.KeyringType.hdKeyTree);if(!t.mnemonic)throw new Error("Primary keyring mnemonic unavailable.");return t.mnemonic}try{const{type:s,mnemonic:r}=await e.call("KeyringController:withKeyring",{id:t},async({keyring:e})=>({type:e.type,mnemonic:(0,n.hasProperty)(e,"mnemonic")?e.mnemonic:undefined}));if(s!==a.KeyringTypes.hd||!r)throw new Error(`Entropy source with ID "${t}" not found.`);return r}catch{throw new Error(`Entropy source with ID "${t}" not found.`)}},getMnemonicSeed:async t=>{if(!t){const[t]=e.call("KeyringController:getKeyringsByType",o.KeyringType.hdKeyTree);if(!t.seed)throw new Error("Primary keyring mnemonic unavailable.");return t.seed}try{const{type:s,seed:r}=await e.call("KeyringController:withKeyring",{id:t},async({keyring:e})=>({type:e.type,seed:(0,n.hasProperty)(e,"seed")?e.seed:undefined}));if(s!==a.KeyringTypes.hd||!r)throw new Error(`Entropy source with ID "${t}" not found.`);return r}catch{throw new Error(`Entropy source with ID "${t}" not found.`)}},getUnlockPromise:e.call.bind(e,"AppStateController:getUnlockPromise"),getSnap:e.call.bind(e,"SnapController:get"),handleSnapRpcRequest:e.call.bind(e,"SnapController:handleRequest"),getSnapState:e.call.bind(e,"SnapController:getSnapState"),requestUserApproval:t.addAndShowApprovalRequest,showNativeNotification:(t,s)=>e.call("RateLimitController:call",t,"showNativeNotification",t,s.message),showInAppNotification:(t,s)=>{const{content:r,message:a,title:n,footerLink:i}=s,o={interfaceId:r,message:a,title:n,footerLink:i};return e.call("RateLimitController:call",t,"showInAppNotification",t,o)},updateSnapState:e.call.bind(e,"SnapController:updateSnapState"),maybeUpdatePhishingList:()=>{const{usePhishDetect:t}=e.call("PreferencesController:getState");t&&e.call("PhishingController:maybeUpdateState")},isOnPhishingList:t=>{const{usePhishDetect:s}=e.call("PreferencesController:getState");return!!s&&e.call("PhishingController:testOrigin",t).result},createInterface:e.call.bind(e,"SnapInterfaceController:createInterface"),getInterface:e.call.bind(e,"SnapInterfaceController:getInterface"),getClientCryptography:()=>({}),getSnapKeyring:async()=>{const[s]=e.call("KeyringController:getKeyringsByType",o.KeyringType.snap);return s||(await t.addNewKeyring(o.KeyringType.snap),e.call("KeyringController:getKeyringsByType",o.KeyringType.snap)[0])}})}};var r=e("@metamask/snaps-rpc-methods"),a=e("@metamask/keyring-controller"),n=e("@metamask/utils"),i=e("../../../../../shared/constants/snaps/permissions"),o=e("../../../../../shared/constants/keyring")}}},{package:"$root$",file:"app/scripts/controllers/permissions/snaps/specifications.ts"}],[2293,{"./constants.cjs":2294,"./utils.cjs":2297,"@metamask/base-controller":1346,"@metamask/controller-utils":1419,"@metamask/keyring-api":2163,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.NetworkEnablementController=void 0;const l=e("@metamask/base-controller"),d=e("@metamask/controller-utils"),u=e("@metamask/keyring-api"),h=e("@metamask/utils"),f=e("./constants.cjs"),m=e("./utils.cjs"),p={enabledNetworkMap:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0}};class g extends l.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:p,name:"NetworkEnablementController",state:{enabledNetworkMap:{[h.KnownCaipNamespace.Eip155]:{[d.ChainId[d.BuiltInNetworkName.Mainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.LineaMainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.BaseMainnet]]:!0},[h.KnownCaipNamespace.Solana]:{[u.SolScope.Mainnet]:!0,[u.SolScope.Testnet]:!1,[u.SolScope.Devnet]:!1},[h.KnownCaipNamespace.Bip122]:{[u.BtcScope.Mainnet]:!0,[u.BtcScope.Testnet]:!1,[u.BtcScope.Signet]:!1},[h.KnownCaipNamespace.Tron]:{[u.TrxScope.Mainnet]:!0,[u.TrxScope.Nile]:!1,[u.TrxScope.Shasta]:!1}},...t}}),r.add(this),e.subscribe("NetworkController:networkAdded",({chainId:e})=>{c(this,r,"m",o).call(this,e)}),e.subscribe("NetworkController:networkRemoved",({chainId:e})=>{c(this,r,"m",i).call(this,e)})}enableNetwork(e){const{namespace:t,storageKey:s}=(0,m.deriveKeys)(e);this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})}),e.enabledNetworkMap[t]&&(e.enabledNetworkMap[t][s]=!0)})}enableNetworkInNamespace(e,t){const{namespace:s,storageKey:n}=(0,m.deriveKeys)(e);if(s!==t)throw new Error(`Chain ID ${e} belongs to namespace ${s}, but namespace ${t} was specified`);this.update(e=>{c(this,r,"m",a).call(this,e,t),e.enabledNetworkMap[t]&&Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1}),e.enabledNetworkMap[t][n]=!0})}enableAllPopularNetworks(){this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})});const t=this.messenger.call("NetworkController:getState"),s=this.messenger.call("MultichainNetworkController:getState");f.POPULAR_NETWORKS.forEach(s=>{const{namespace:n,storageKey:i}=(0,m.deriveKeys)(s);t.networkConfigurationsByChainId[s]&&(c(this,r,"m",a).call(this,e,n),e.enabledNetworkMap[n][i]=!0)});const n=(0,m.deriveKeys)(u.SolScope.Mainnet);s.multichainNetworkConfigurationsByChainId[u.SolScope.Mainnet]&&(c(this,r,"m",a).call(this,e,n.namespace),e.enabledNetworkMap[n.namespace][n.storageKey]=!0);const i=(0,m.deriveKeys)(u.BtcScope.Mainnet);s.multichainNetworkConfigurationsByChainId[u.BtcScope.Mainnet]&&(c(this,r,"m",a).call(this,e,i.namespace),e.enabledNetworkMap[i.namespace][i.storageKey]=!0);const o=(0,m.deriveKeys)(u.TrxScope.Mainnet);s.multichainNetworkConfigurationsByChainId[u.TrxScope.Mainnet]&&(c(this,r,"m",a).call(this,e,o.namespace),e.enabledNetworkMap[o.namespace][o.storageKey]=!0)})}init(){this.update(e=>{const t=this.messenger.call("NetworkController:getState"),s=this.messenger.call("MultichainNetworkController:getState");Object.keys(t.networkConfigurationsByChainId).forEach(t=>{const{namespace:s,storageKey:n}=(0,m.deriveKeys)(t);c(this,r,"m",a).call(this,e,s),e.enabledNetworkMap[s][n]===undefined&&(e.enabledNetworkMap[s][n]=!1)}),Object.keys(s.multichainNetworkConfigurationsByChainId).forEach(t=>{const{namespace:s,storageKey:n}=(0,m.deriveKeys)(t);c(this,r,"m",a).call(this,e,s),e.enabledNetworkMap[s][n]===undefined&&(e.enabledNetworkMap[s][n]=!1)})})}disableNetwork(e){const t=(0,m.deriveKeys)(e),{namespace:s,storageKey:r}=t;this.update(e=>{e.enabledNetworkMap[s][r]=!1})}isNetworkEnabled(e){const t=(0,m.deriveKeys)(e),{namespace:s,storageKey:r}=t;return this.state.enabledNetworkMap[s]?.[r]??!1}}s.NetworkEnablementController=g,r=new WeakSet,a=function(e,t){e.enabledNetworkMap[t]||(e.enabledNetworkMap[t]={})},n=function(){const e=this.messenger.call("NetworkController:getState");return f.POPULAR_NETWORKS.reduce((t,s)=>{if(!e.networkConfigurationsByChainId[s])return t;const{namespace:r,storageKey:a}=(0,m.deriveKeys)(s),n=this.state.enabledNetworkMap[r]?.[a];return n?t+1:t},0)>1},i=function(e){const t=(0,m.deriveKeys)(e),{namespace:s,storageKey:r}=t;this.update(e=>{(0,m.isOnlyNetworkEnabledInNamespace)(this.state,t)&&(e.enabledNetworkMap[s][d.ChainId[d.BuiltInNetworkName.Mainnet]]=!0),s in e.enabledNetworkMap&&delete e.enabledNetworkMap[s][r]})},o=function(e){const{namespace:t,storageKey:s,reference:i}=(0,m.deriveKeys)(e);this.update(e=>{c(this,r,"m",a).call(this,e,t);const o=c(this,r,"m",n).call(this),l=(0,m.isPopularNetwork)(i);o&&l||Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})}),e.enabledNetworkMap[t][s]=!0})}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs"}],[2294,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.POPULAR_NETWORKS=void 0,s.POPULAR_NETWORKS=["0x1","0xe708","0x2105","0xa4b1","0xa86a","0x38","0xa","0x89","0x531","0x144","0x2a15c308d","0x3e7","0x8f"]}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/constants.cjs"}],[2295,{"./NetworkEnablementController.cjs":2293,"./selectors.cjs":2296},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.selectEnabledSolanaNetworks=s.selectEnabledEvmNetworks=s.selectEnabledNetworksCount=s.selectAllEnabledNetworks=s.createSelectorForEnabledNetworksForNamespace=s.selectIsNetworkEnabled=s.selectEnabledNetworkMap=s.NetworkEnablementController=void 0;var r=e("./NetworkEnablementController.cjs");Object.defineProperty(s,"NetworkEnablementController",{enumerable:!0,get:function(){return r.NetworkEnablementController}});var a=e("./selectors.cjs");Object.defineProperty(s,"selectEnabledNetworkMap",{enumerable:!0,get:function(){return a.selectEnabledNetworkMap}}),Object.defineProperty(s,"selectIsNetworkEnabled",{enumerable:!0,get:function(){return a.selectIsNetworkEnabled}}),Object.defineProperty(s,"createSelectorForEnabledNetworksForNamespace",{enumerable:!0,get:function(){return a.createSelectorForEnabledNetworksForNamespace}}),Object.defineProperty(s,"selectAllEnabledNetworks",{enumerable:!0,get:function(){return a.selectAllEnabledNetworks}}),Object.defineProperty(s,"selectEnabledNetworksCount",{enumerable:!0,get:function(){return a.selectEnabledNetworksCount}}),Object.defineProperty(s,"selectEnabledEvmNetworks",{enumerable:!0,get:function(){return a.selectEnabledEvmNetworks}}),Object.defineProperty(s,"selectEnabledSolanaNetworks",{enumerable:!0,get:function(){return a.selectEnabledSolanaNetworks}})}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/index.cjs"}],[2296,{"./utils.cjs":2297,"@metamask/utils":3051,reselect:5243},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.selectEnabledSolanaNetworks=s.selectEnabledEvmNetworks=s.selectEnabledNetworksCount=s.selectAllEnabledNetworks=s.createSelectorForEnabledNetworksForNamespace=s.selectIsNetworkEnabled=s.selectEnabledNetworkMap=void 0;const r=e("@metamask/utils"),a=e("reselect"),n=e("./utils.cjs");s.selectEnabledNetworkMap=e=>e.enabledNetworkMap;s.selectIsNetworkEnabled=e=>(0,a.createSelector)(s.selectEnabledNetworkMap,t=>{const{namespace:s,storageKey:r}=(0,n.deriveKeys)(e);return s in t&&r in t[s]&&t[s][r]});s.createSelectorForEnabledNetworksForNamespace=e=>(0,a.createSelector)(s.selectEnabledNetworkMap,t=>Object.entries(t[e]??{}).filter(([,e])=>e).map(([e])=>e)),s.selectAllEnabledNetworks=(0,a.createSelector)(s.selectEnabledNetworkMap,e=>Object.keys(e).reduce((t,s)=>(t[s]=Object.entries(e[s]).filter(([,e])=>e).map(([e])=>e),t),{})),s.selectEnabledNetworksCount=(0,a.createSelector)(s.selectAllEnabledNetworks,e=>Object.values(e).flat().length),s.selectEnabledEvmNetworks=(0,a.createSelector)((0,s.createSelectorForEnabledNetworksForNamespace)(r.KnownCaipNamespace.Eip155),e=>e),s.selectEnabledSolanaNetworks=(0,a.createSelector)((0,s.createSelectorForEnabledNetworksForNamespace)(r.KnownCaipNamespace.Solana),e=>e)}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"}],[2297,{"./constants.cjs":2294,"@metamask/controller-utils":1419,"@metamask/multichain-network-controller":2268,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isPopularNetwork=s.isOnlyNetworkEnabledInNamespace=s.deriveKeys=void 0;const r=e("@metamask/controller-utils"),a=e("@metamask/multichain-network-controller"),n=e("@metamask/utils"),i=e("./constants.cjs");s.deriveKeys=function(e){const t=(0,n.isCaipChainId)(e)?e:(0,a.toEvmCaipChainId)(e),{namespace:s,reference:i}=(0,n.parseCaipChainId)(t);let o;return o=s===n.KnownCaipNamespace.Eip155?(0,n.isHexString)(e)?e:(0,r.toHex)(i):t,{namespace:s,storageKey:o,caipChainId:t,reference:i}},s.isOnlyNetworkEnabledInNamespace=function(e,t){const{namespace:s,storageKey:r}=t;if(!e.enabledNetworkMap[s])return!1;const a=e.enabledNetworkMap[s],n=Object.entries(a).filter(([e,t])=>t);if(1===n.length){const[e]=n[0];return e===r}return!1},s.isPopularNetwork=function(e){try{return i.POPULAR_NETWORKS.includes((0,r.toHex)(e))}catch{return!1}}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/utils.cjs"}],[23,{"../../../../shared/constants/metametrics":5725,"@metamask/assets-controllers":1276,"@metamask/bridge-controller":1353},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.NftControllerInit=void 0;var r=e("@metamask/assets-controllers"),a=e("@metamask/bridge-controller"),n=e("../../../../shared/constants/metametrics");s.NftControllerInit=({controllerMessenger:e,initMessenger:t,persistedState:s})=>({controller:new r.NftController({state:s.NftController,messenger:e,onNftAdded:({address:e,symbol:s,tokenId:r,standard:i,source:o})=>t.call("MetaMetricsController:trackEvent",{event:n.MetaMetricsEventName.NftAdded,category:n.MetaMetricsEventCategory.Wallet,sensitiveProperties:{token_contract_address:e,token_symbol:s??null,token_id:r,token_standard:i,asset_type:a.AssetType.NFT,source:o}})})})}}},{package:"$root$",file:"app/scripts/controller-init/assets/nft-controller-init.ts"}],[230,{"../../../shared/constants/hardware-wallets":5719,"../../../shared/constants/network":5729,"../../../shared/constants/preferences":5734,"@metamask/base-controller":1346},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getDefaultPreferencesControllerState=s.ReferralStatus=s.PreferencesController=void 0;var r=e("@metamask/base-controller"),a=e("../../../shared/constants/network"),n=e("../../../shared/constants/hardware-wallets"),i=e("../../../shared/constants/preferences");function o(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}let c=s.ReferralStatus=function(e){return e.Approved="approved",e.Passed="passed",e.Declined="declined",e}({});const l=()=>({addSnapAccountEnabled:!1,advancedGasFee:{},currentLocale:"",dismissSeedBackUpReminder:!1,enableMV3TimestampSave:!0,featureFlags:{},forgottenPassword:!1,identities:{},ipfsGateway:a.IPFS_DEFAULT_GATEWAY_URL,isIpfsGatewayEnabled:!0,knownMethodData:{},ledgerTransportType:window.navigator.hid?n.LedgerTransportTypes.webhid:n.LedgerTransportTypes.u2f,lostIdentities:{},manageInstitutionalWallets:!1,openSeaEnabled:!0,overrideContentSecurityPolicyHeader:!0,preferences:{autoLockTimeLimit:undefined,avatarType:"maskicon",dismissSmartAccountSuggestionEnabled:!1,featureNotificationsEnabled:!1,hideZeroBalanceTokens:!1,petnamesEnabled:!0,privacyMode:!1,showConfirmationAdvancedDetails:!1,showExtensionInFullSizeView:!1,showFiatInTestnets:!1,showMultiRpcModal:!1,showNativeTokenAsMainBalance:!1,showTestNetworks:!1,skipDeepLinkInterstitial:!1,smartAccountOptIn:!0,smartTransactionsOptInStatus:!0,smartTransactionsMigrationApplied:!1,tokenNetworkFilter:{},tokenSortConfig:{key:"tokenFiatAmount",order:"dsc",sortCallback:"stringNumeric"},useNativeCurrencyAsPrimaryCurrency:!0,useSidePanelAsDefault:!1},securityAlertsEnabled:!0,selectedAddress:"",snapRegistryList:{},snapsAddSnapAccountModalDismissed:!1,theme:i.ThemeType.os,use4ByteResolution:!0,useAddressBarEnsResolution:!0,useBlockie:!1,useCurrencyRateCheck:!0,useExternalNameSources:!0,useExternalServices:!0,isMultiAccountBalancesEnabled:!0,useMultiAccountBalanceChecker:!0,useNftDetection:!0,usePhishDetect:!0,useSafeChainsListValidation:!0,useTokenDetection:!0,useTransactionSimulations:!0,watchEthereumAccountEnabled:!1,referrals:{hyperliquid:{}}});s.getDefaultPreferencesControllerState=l;const d={addSnapAccountEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},advancedGasFee:{persist:!0,includeInStateLogs:!0,includeInDebugSnapshot:!0,usedInUi:!0},currentLocale:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},dismissSeedBackUpReminder:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},enableMV3TimestampSave:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},featureFlags:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},forgottenPassword:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},identities:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},ipfsGateway:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},isIpfsGatewayEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},knownMethodData:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},ledgerTransportType:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},lostIdentities:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},manageInstitutionalWallets:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},openSeaEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},overrideContentSecurityPolicyHeader:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},preferences:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},securityAlertsEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},selectedAddress:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},snapRegistryList:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},snapsAddSnapAccountModalDismissed:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},textDirection:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},theme:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},use4ByteResolution:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useAddressBarEnsResolution:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useBlockie:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useCurrencyRateCheck:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useExternalNameSources:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},useExternalServices:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},isMultiAccountBalancesEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useMultiAccountBalanceChecker:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useNftDetection:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},usePhishDetect:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useSafeChainsListValidation:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},useTokenDetection:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},useTransactionSimulations:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},watchEthereumAccountEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},referrals:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0}};var u=new WeakSet;class h extends r.BaseController{constructor({messenger:e,state:t}){const s=l(),r={...s,...t,preferences:{...s.preferences,...null==t?void 0:t.preferences},isMultiAccountBalancesEnabled:(null==t?void 0:t.useMultiAccountBalanceChecker)??s.isMultiAccountBalancesEnabled};super({messenger:e,metadata:d,name:"PreferencesController",state:r}),o(this,u),this.messenger.subscribe("AccountsController:stateChange",function(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}(u,this,f).bind(this)),globalThis.setPreference=(e,t)=>this.setFeatureFlag(e,t)}setPasswordForgotten(e){this.update(t=>{t.forgottenPassword=e})}setUseBlockie(e){this.update(t=>{t.useBlockie=e})}setUsePhishDetect(e){this.update(t=>{t.usePhishDetect=e})}setUseMultiAccountBalanceChecker(e){this.update(t=>{t.useMultiAccountBalanceChecker=e,t.isMultiAccountBalancesEnabled=e})}setUseSafeChainsListValidation(e){this.update(t=>{t.useSafeChainsListValidation=e})}toggleExternalServices(e){this.update(t=>{t.useExternalServices=e}),this.setUseTokenDetection(e),this.setUseCurrencyRateCheck(e),this.setUsePhishDetect(e),this.setUseAddressBarEnsResolution(e),this.setOpenSeaEnabled(e),this.setUseNftDetection(e),this.setUseSafeChainsListValidation(e)}setUseTokenDetection(e){this.update(t=>{t.useTokenDetection=e})}setUseNftDetection(e){this.update(t=>{t.useNftDetection=e})}setUse4ByteResolution(e){this.update(t=>{t.use4ByteResolution=e})}setUseCurrencyRateCheck(e){this.update(t=>{t.useCurrencyRateCheck=e})}setOpenSeaEnabled(e){this.update(t=>{t.openSeaEnabled=e})}setSecurityAlertsEnabled(e){this.update(t=>{t.securityAlertsEnabled=e})}setAddSnapAccountEnabled(e){this.update(t=>{t.addSnapAccountEnabled=e})}setWatchEthereumAccountEnabled(e){this.update(t=>{t.watchEthereumAccountEnabled=e})}setUseExternalNameSources(e){this.update(t=>{t.useExternalNameSources=e})}setUseTransactionSimulations(e){this.update(t=>{t.useTransactionSimulations=e})}setAdvancedGasFee({chainId:e,gasFeePreferences:t}){const{advancedGasFee:s}=this.state;this.update(r=>{r.advancedGasFee={...s,[e]:t}})}setTheme(e){this.update(t=>{t.theme=e})}addKnownMethodData(e,t){const{knownMethodData:s}=this.state,r={...s};r[e]=t,this.update(e=>{e.knownMethodData=r})}setCurrentLocale(e){const t=["ar","dv","fa","he","ku"].includes(e)?"rtl":"auto";return this.update(s=>{s.currentLocale=e,s.textDirection=t}),t}setSelectedAddress(e){const t=this.messenger.call("AccountsController:getAccountByAddress",e);if(!t)throw new Error(`Identity for '${e} not found`);this.messenger.call("AccountsController:setSelectedAccount",t.id)}getSelectedAddress(){return this.messenger.call("AccountsController:getSelectedAccount").address}setAccountLabel(e,t){if(!e)throw new Error(`setAccountLabel requires a valid address, got ${String(e)}`);const s=this.messenger.call("AccountsController:getAccountByAddress",e);return s?(this.messenger.call("AccountsController:setAccountName",s.id,t),t):undefined}setFeatureFlag(e,t){const s={...this.state.featureFlags,[e]:t};return this.update(e=>{e.featureFlags=s}),s}setPreference(e,t){const s={...this.getPreferences(),[e]:t};return this.update(e=>{e.preferences=s}),s}getPreferences(){return this.state.preferences}getIpfsGateway(){return this.state.ipfsGateway}setIpfsGateway(e){return this.update(t=>{t.ipfsGateway=e}),e}setIsIpfsGatewayEnabled(e){this.update(t=>{t.isIpfsGatewayEnabled=e})}setUseAddressBarEnsResolution(e){this.update(t=>{t.useAddressBarEnsResolution=e})}setLedgerTransportPreference(e){return this.update(t=>{t.ledgerTransportType=e}),e}setDismissSeedBackUpReminder(e){this.update(t=>{t.dismissSeedBackUpReminder=e})}setOverrideContentSecurityPolicyHeader(e){this.update(t=>{t.overrideContentSecurityPolicyHeader=e})}setManageInstitutionalWallets(e){this.update(t=>{t.manageInstitutionalWallets=e})}setServiceWorkerKeepAlivePreference(e){this.update(t=>{t.enableMV3TimestampSave=e})}setUseSidePanelAsDefault(e){this.update(t=>{t.preferences.useSidePanelAsDefault=e})}setSnapsAddSnapAccountModalDismissed(e){this.update(t=>{t.snapsAddSnapAccountModalDismissed=e})}addReferralApprovedAccount(e){this.update(t=>{t.referrals.hyperliquid[e]=c.Approved})}addReferralPassedAccount(e){this.update(t=>{t.referrals.hyperliquid[e]=c.Passed})}addReferralDeclinedAccount(e){this.update(t=>{t.referrals.hyperliquid[e]=c.Declined})}removeReferralDeclinedAccount(e){this.update(t=>{delete t.referrals.hyperliquid[e]})}setAccountsReferralApproved(e){this.update(t=>{e.forEach(e=>{t.referrals.hyperliquid[e]=c.Approved})})}}function f(e){const{accounts:t,selectedAccount:s}=e.internalAccounts,r=t[s],{identities:a,lostIdentities:n}=this.state,i=Object.values(t).map(e=>e.address.toLowerCase()),o=Object.keys(a).reduce((e,t)=>(i.includes(t.toLowerCase())&&(e[t]=a[t]),e),{...n}),c=Object.values(t).reduce((e,t)=>(e[t.address]={address:t.address,name:t.metadata.name,lastSelected:t.metadata.lastSelected},e),{});this.update(e=>{e.identities=c,e.lostIdentities=o,e.selectedAddress=(null==r?void 0:r.address)||""})}s.PreferencesController=h}}},{package:"$root$",file:"app/scripts/controllers/preferences-controller.ts"}],[231,{"webextension-polyfill":5698},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getNotificationImage=async function(){return await a.default.runtime.getURL("../../images/icon-64.png")};var r,a=(r=e("webextension-polyfill"))&&r.__esModule?r:{default:r}}}},{package:"$root$",file:"app/scripts/controllers/push-notifications/get-notification-image.ts"}],[232,{"../../../../shared/lib/translate":5835,"@metamask/notification-services-controller":2340},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createNotificationMessage=function(e){return r.NotificationServicesPushController.Utils.createOnChainPushNotificationMessage(e,i)};var r=e("@metamask/notification-services-controller"),a=e("../../../../shared/lib/translate");const n=(...e)=>(0,a.t)(...e)??"",i={...{pushPlatformNotificationsFundsSentTitle:()=>n("pushPlatformNotificationsFundsSentTitle"),pushPlatformNotificationsFundsSentDescriptionDefault:()=>n("pushPlatformNotificationsFundsSentDescriptionDefault"),pushPlatformNotificationsFundsSentDescription:(e,t)=>n("pushPlatformNotificationsFundsSentDescription",e,t),pushPlatformNotificationsFundsReceivedTitle:()=>n("pushPlatformNotificationsFundsReceivedTitle"),pushPlatformNotificationsFundsReceivedDescriptionDefault:()=>n("pushPlatformNotificationsFundsReceivedDescriptionDefault"),pushPlatformNotificationsFundsReceivedDescription:(e,t)=>n("pushPlatformNotificationsFundsReceivedDescription",e,t),pushPlatformNotificationsSwapCompletedTitle:()=>n("pushPlatformNotificationsSwapCompletedTitle"),pushPlatformNotificationsSwapCompletedDescription:()=>n("pushPlatformNotificationsSwapCompletedDescription"),pushPlatformNotificationsNftSentTitle:()=>n("pushPlatformNotificationsNftSentTitle"),pushPlatformNotificationsNftSentDescription:()=>n("pushPlatformNotificationsNftSentDescription"),pushPlatformNotificationsNftReceivedTitle:()=>n("pushPlatformNotificationsNftReceivedTitle"),pushPlatformNotificationsNftReceivedDescription:()=>n("pushPlatformNotificationsNftReceivedDescription"),pushPlatformNotificationsStakingRocketpoolStakeCompletedTitle:()=>n("pushPlatformNotificationsStakingRocketpoolStakeCompletedTitle"),pushPlatformNotificationsStakingRocketpoolStakeCompletedDescription:()=>n("pushPlatformNotificationsStakingRocketpoolStakeCompletedDescription"),pushPlatformNotificationsStakingRocketpoolUnstakeCompletedTitle:()=>n("pushPlatformNotificationsStakingRocketpoolUnstakeCompletedTitle"),pushPlatformNotificationsStakingRocketpoolUnstakeCompletedDescription:()=>n("pushPlatformNotificationsStakingRocketpoolUnstakeCompletedDescription"),pushPlatformNotificationsStakingLidoStakeCompletedTitle:()=>n("pushPlatformNotificationsStakingLidoStakeCompletedTitle"),pushPlatformNotificationsStakingLidoStakeCompletedDescription:()=>n("pushPlatformNotificationsStakingLidoStakeCompletedDescription"),pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnTitle:()=>n("pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnTitle"),pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnDescription:()=>n("pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnDescription"),pushPlatformNotificationsStakingLidoWithdrawalRequestedTitle:()=>n("pushPlatformNotificationsStakingLidoWithdrawalRequestedTitle"),pushPlatformNotificationsStakingLidoWithdrawalRequestedDescription:()=>n("pushPlatformNotificationsStakingLidoWithdrawalRequestedDescription"),pushPlatformNotificationsStakingLidoWithdrawalCompletedTitle:()=>n("pushPlatformNotificationsStakingLidoWithdrawalCompletedTitle"),pushPlatformNotificationsStakingLidoWithdrawalCompletedDescription:()=>n("pushPlatformNotificationsStakingLidoWithdrawalCompletedDescription")},...{PositionLiquidatedTitle:()=>n("pushNotificationPositionLiquidatedTitle"),PositionLiquidatedDescriptionLong:e=>n("pushNotificationPositionLiquidatedDescriptionLong",e),PositionLiquidatedDescriptionShort:e=>n("pushNotificationPositionLiquidatedDescriptionShort",e),StopLossTriggeredTitle:()=>n("pushNotificationStopLossTriggeredTitle"),StopLossTriggeredDescriptionLong:e=>n("pushNotificationStopLossTriggeredDescriptionLong",e),StopLossTriggeredDescriptionShort:e=>n("pushNotificationStopLossTriggeredDescriptionShort",e),TakeProfitTriggeredTitle:()=>n("pushNotificationTakeProfitTriggeredTitle"),TakeProfitTriggeredDescriptionLong:e=>n("pushNotificationTakeProfitTriggeredDescriptionLong",e),TakeProfitTriggeredDescriptionShort:e=>n("pushNotificationTakeProfitTriggeredDescriptionShort",e),LimitOrderFilledTitle:()=>n("pushNotificationLimitOrderFilledTitle"),LimitOrderFilledDescriptionLong:e=>n("pushNotificationLimitOrderFilledDescriptionLong",e),LimitOrderFilledDescriptionShort:e=>n("pushNotificationLimitOrderFilledDescriptionShort",e)},...{ShieldSubscriptionTitle:()=>n("pushNotificationShieldSubscriptionTitle"),ShieldSubscriptionCreatedDescriptionShort:()=>n("pushNotificationShieldSubscriptionCreatedDescriptionShort"),ShieldSubscriptionPaymentFailedDescriptionShort:()=>n("pushNotificationShieldSubscriptionPaymentFailedDescriptionShort"),ShieldSubscriptionUpdatePaymentCta:()=>n("pushNotificationShieldUpdatePaymentCta"),ShieldSubscriptionLearnMoreCta:()=>n("pushNotificationShieldLearnMoreCta"),ShieldClaimCreatedTitle:()=>n("pushNotificationShieldClaimCreatedTitle"),ShieldClaimCreatedDescriptionShort:()=>n("pushNotificationShieldClaimCreatedDescriptionShort"),ShieldClaimStatusUpdatedTitle:()=>n("pushNotificationShieldClaimStatusUpdatedTitle"),ShieldClaimStatusUpdatedDescriptionShort:()=>n("pushNotificationShieldClaimStatusUpdatedDescriptionShort")}}}}},{package:"$root$",file:"app/scripts/controllers/push-notifications/get-notification-message.ts"}],[233,{"../../platforms/extension":579,"./get-notification-image":231,"./get-notification-message":232},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.onPushNotificationClicked=async function(e,t){var s;e.notification.close();const r=t??(null==e||null===(s=e.notification)||void 0===s?void 0:s.data),a=`${c.getExtensionURL(null,null)}#notifications/${r.id}`;e.waitUntil(o.clients.openWindow(a))},s.onPushNotificationReceived=async function(e){const t=(0,i.createNotificationMessage)(e);if(!t)return;const s=null==o?void 0:o.registration;if(!s)return;const r=await(0,n.getNotificationImage)();await s.showNotification(t.title,{body:t.description,icon:r,tag:null==e?void 0:e.id,data:e})};var r,a=(r=e("../../platforms/extension"))&&r.__esModule?r:{default:r},n=e("./get-notification-image"),i=e("./get-notification-message");const o=self,c=new a.default}}},{package:"$root$",file:"app/scripts/controllers/push-notifications/index.ts"}],[2338,{"./push-utils.cjs":2339},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=void 0;var r=e("./push-utils.cjs");Object.defineProperty(s,"createRegToken",{enumerable:!0,get:function(){return r.createRegToken}}),Object.defineProperty(s,"deleteRegToken",{enumerable:!0,get:function(){return r.deleteRegToken}}),Object.defineProperty(s,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return r.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],[2339,{"../../NotificationServicesController/index.cjs":2309,"../../shared/to-raw-notification.cjs":2343,"firebase/app":4347,"firebase/messaging":4348,"firebase/messaging/sw":4349,loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=s.supportedCache=void 0;const a=e("firebase/app"),n=e("firebase/messaging"),i=e("firebase/messaging/sw"),o=r(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),l=e("../../shared/to-raw-notification.cjs");s.supportedCache=null;const d=async e=>{if(!await(async()=>(s.supportedCache??(s.supportedCache=await(0,i.isSupported)()),s.supportedCache))())return null;const t=await(async e=>{try{return(0,a.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,a.initializeApp)(t)}})(e);return(0,i.getMessaging)(t)};s.createRegToken=async function(e){try{const t=await d(e);if(!t)return null;return await(0,n.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},s.deleteRegToken=async function(e){try{const t=await d(e);return!t||(await(0,n.deleteToken)(t),!0)}catch{return!1}},s.createSubscribeToPushNotifications=function(e){return async function(t){const s=await async function(e,t){const s=await d(e);if(!s)return null;const r=(0,i.onBackgroundMessage)(s,async e=>{try{const s=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!s)return;const r=(0,l.toRawAPINotification)(s),a=c.Processors.processNotification(r);await t(a)}catch(t){throw o.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}});return()=>r()}(t,async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)}),r=function(e){const t=t=>{const s=t?.notification?.data;e(t,s)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}((t,s)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",s),e.onClickHandler(t,s)});return()=>{s?.(),r()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],[234,{"../../../../shared/lib/accounts":5754,"./rewards-data-service":235,"./utils/solana-snap":236,"./utils/sortAccounts":237,"@metamask/base-controller":1346,"@metamask/utils":3051,"@solana/addresses":3132,buffer:4019,"ethers/lib/utils":4315,loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.getRewardsControllerDefaultState=s.defaultRewardsControllerState=s.RewardsController=s.DEFAULT_BLOCKED_REGIONS=void 0,s.wrapWithCache=E;var r,a=e("@metamask/base-controller"),n=(r=e("loglevel"))&&r.__esModule?r:{default:r},i=e("@solana/addresses"),o=e("@metamask/utils"),c=e("ethers/lib/utils"),l=e("../../../../shared/lib/accounts"),d=e("./rewards-data-service"),u=e("./utils/solana-snap"),h=e("./utils/sortAccounts");function f(e,t,s){m(e,t),t.set(e,s)}function m(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function p(e,t){return e.get(b(e,t))}function g(e,t,s){return e.set(b(e,t),s),s}function b(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}const w=s.DEFAULT_BLOCKED_REGIONS=["UK"],y=36e5,S={rewardsActiveAccount:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},rewardsAccounts:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},rewardsSubscriptions:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},rewardsSeasons:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},rewardsSeasonStatuses:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},rewardsSubscriptionTokens:{includeInStateLogs:!1,persist:!0,includeInDebugSnapshot:!0,usedInUi:!1},rewardsEnabled:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!0}},v=()=>({rewardsActiveAccount:null,rewardsAccounts:{},rewardsSubscriptions:{},rewardsSeasons:{},rewardsSeasonStatuses:{},rewardsSubscriptionTokens:{}});s.getRewardsControllerDefaultState=v;const _=s.defaultRewardsControllerState={rewardsActiveAccount:null,rewardsAccounts:{},rewardsSubscriptions:{},rewardsSeasons:{},rewardsSeasonStatuses:{},rewardsSubscriptionTokens:{}},k=new Date("2025-10-27T00:00:00.000Z");async function E({key:e,ttl:t,readCache:s,fetchFresh:r,writeCache:a,swrCallback:i}){try{const o=s(e);if(o){if(!(!o.lastFetched||Date.now()-o.lastFetched>t))return o.payload;if(i)return(async()=>{try{const t=await r();a(e,t),i(o.payload,t)}catch(e){n.default.error("SWR revalidation failed:",e instanceof Error?e.message:String(e))}})(),o.payload}}catch(e){n.default.error("RewardsController: wrapWithCache cache read failed, fetching fresh",e instanceof Error?e.message:String(e))}const o=await r();try{a(e,o)}catch(e){n.default.error("RewardsController: wrapWithCache writeCache failed",e instanceof Error?e.message:String(e))}return o}var T=new WeakMap,P=new WeakMap,R=new WeakSet;class A extends a.BaseController{calculateTierStatus(e,t,s){const r=[...e].sort((e,t)=>e.pointsNeeded-t.pointsNeeded),a=r.find(e=>e.id===t);if(!a)throw new Error(`Current tier ${t} not found in season tiers`);const n=r.findIndex(e=>e.id===t),i=n<r.length-1?r[n+1]:null;return{currentTier:a,nextTier:i,nextTierPointsNeeded:i?Math.max(0,i.pointsNeeded-s):null}}convertToSeasonStatusDto(e,t){return{season:{id:e.id,name:e.name,startDate:new Date(e.startDate),endDate:new Date(e.endDate),tiers:e.tiers},balance:{total:t.balance,updatedAt:t.updatedAt},currentTierId:t.currentTierId}}constructor({messenger:e,state:t,isDisabled:s}){super({name:"RewardsController",metadata:S,messenger:e,state:{..._,...t}}),function(e,t){m(e,t),t.add(e)}(this,R),f(this,T,null),f(this,P,void 0),b(R,this,M).call(this),b(R,this,O).call(this),g(P,this,s)}resetState(){this.update(()=>({rewardsActiveAccount:null,rewardsAccounts:{},rewardsSubscriptions:{},rewardsSeasons:{},rewardsSeasonStatuses:{},rewardsSubscriptionTokens:{}}))}getActualSubscriptionId(e){const t=b(R,this,j).call(this,e);return(null==t?void 0:t.subscriptionId)||null}async handleAuthenticationTrigger(e){if(this.isRewardsFeatureEnabled())try{const e=this.messenger.call("AccountTreeController:getAccountsFromSelectedAccountGroup");if(e&&0!==e.length){const t=(0,h.sortAccounts)(e);try{await this.getOptInStatus({addresses:t.map(e=>e.address)})}catch{}let s=null;for(const e of t)try{await this.performSilentAuth(e,!1,!0)&&!s&&(s=e)}catch{}const r=s||t[0];if(r){const e=this.convertInternalAccountToCaipAccountId(r);if(e){const t=b(R,this,j).call(this,e);t&&this.update(e=>{e.rewardsActiveAccount=t})}}}else await this.performSilentAuth(null,!0,!0)}catch{}else await this.performSilentAuth(null,!0,!0)}shouldSkipSilentAuth(e,t){if(!this.isOptInSupported(t))return!0;const s=b(R,this,j).call(this,e);return!!s&&(!1===s.hasOptedIn?!!s.lastFreshOptInStatusCheck&&Date.now()-s.lastFreshOptInStatusCheck<=y:Boolean(s.subscriptionId)&&Boolean(b(R,this,$).call(this,s.subscriptionId)))}isOptInSupported(e){try{return!(0,l.isHardwareAccount)(e)&&(!!(0,c.isAddress)(e.address)||!!(0,i.isAddress)(e.address))}catch(e){return n.default.error("RewardsController: Exception checking opt-in support, assuming not supported:",e),!1}}convertInternalAccountToCaipAccountId(e){try{const[t]=e.scopes,{namespace:s,reference:r}=(0,o.parseCaipChainId)(t);return(0,o.toCaipAccountId)(s,r,e.address)}catch(e){return n.default.error("RewardsController: Failed to convert address to CAIP-10 format:",e),null}}async performSilentAuth(e,t=!0,s=!0){var r;if(!e)return t&&this.update(e=>{e.rewardsActiveAccount=null}),null;const a=this.convertInternalAccountToCaipAccountId(e),i=!!a&&this.shouldSkipSilentAuth(a,e);if(i&&s){var o;let e=b(R,this,j).call(this,a);return e?this.update(s=>{t&&(s.rewardsActiveAccount=e)}):(e={account:a,hasOptedIn:!1,subscriptionId:null,perpsFeeDiscount:null,lastPerpsDiscountRateFetched:null},this.update(s=>{s.rewardsAccounts[a]=e,t&&(s.rewardsActiveAccount=e)})),(null===(o=e)||void 0===o?void 0:o.subscriptionId)||null}let c=null,l=!1;if(s&&!i)try{const s=await this.getOptInStatus({addresses:[e.address]});if(s.ois&&!1===s.ois[0])return c=null,this.update(e=>{if(!a)return;const s={account:a,hasOptedIn:!1,subscriptionId:null,perpsFeeDiscount:null,lastPerpsDiscountRateFetched:null,lastFreshOptInStatusCheck:Date.now()};e.rewardsAccounts[a]=s,t&&(e.rewardsActiveAccount=s)}),null}catch{}try{let t,s=Math.floor(Date.now()/1e3),r=0;const a=1;try{t=await b(R,this,x).call(this,e,s)}catch(e){if(n.default.error("RewardsController: Failed to generate signature:",e),e&&"object"==typeof e&&"message"in e){if(e.message.includes("controller is locked"))return null}throw e}const i=async(n,o)=>{try{return await this.messenger.call("RewardsDataService:login",{account:e.address,timestamp:n,signature:o})}catch(n){if(n instanceof d.InvalidTimestampError&&r<a)return r+=1,s=n.timestamp,t=await b(R,this,x).call(this,e,s),await i(s,t);throw n}},o=await i(s,t);c=o.subscription,b(R,this,L).call(this,c.id,o.sessionId)}catch(e){e instanceof Error&&e.message.includes("401")?n.default.error("RewardsController: Account not opt-in",a):(c=null,l=!0)}finally{this.update(e=>{var s;if(!a)return;const r={account:a,hasOptedIn:l?undefined:Boolean(c),subscriptionId:(null===(s=c)||void 0===s?void 0:s.id)||null,perpsFeeDiscount:null,lastPerpsDiscountRateFetched:null};if(e.rewardsAccounts[a]=r,t&&(e.rewardsActiveAccount=r),c){var n;if(null===(n=e.rewardsSubscriptions[c.id])||void 0===n||!n.candidateAt){const t=Object.keys(e.rewardsSubscriptions??{}).length>0?new Date:k;c.candidateAt=t.toISOString()}e.rewardsSubscriptions[c.id]=c}})}return(null===(r=c)||void 0===r?void 0:r.id)||null}async getHasAccountOptedIn(e){var t;return!!this.isRewardsFeatureEnabled()&&((null===(t=b(R,this,j).call(this,e))||void 0===t?void 0:t.hasOptedIn)??!1)}checkOptInStatusAgainstCache(e,t){const s=new Array(e.length).fill(null),r=new Array(e.length).fill(null),a=[];for(let n=0;n<e.length;n++){const i=e[n],o=t.get(i.toLowerCase());if(o){const e=this.convertInternalAccountToCaipAccountId(o);if(e){const t=b(R,this,j).call(this,e);if((null==t?void 0:t.hasOptedIn)!==undefined){const e=!t.lastFreshOptInStatusCheck||Date.now()-t.lastFreshOptInStatusCheck>y;if(!1===t.hasOptedIn&&e){a.push(i);continue}s[n]=t.hasOptedIn,r[n]=t.subscriptionId||null;continue}}}a.push(i)}return{cachedOptInResults:s,cachedSubscriptionIds:r,addressesNeedingFresh:a}}async getOptInStatus(e){if(!this.isRewardsFeatureEnabled())return{ois:e.addresses.map(()=>!1),sids:e.addresses.map(()=>null)};try{const t=this.messenger.call("AccountsController:listMultichainAccounts"),s=new Map;for(const e of t)s.set(e.address.toLowerCase(),e);const{cachedOptInResults:r,cachedSubscriptionIds:a,addressesNeedingFresh:n}=this.checkOptInStatusAgainstCache(e.addresses,s);let i=[],o=[];if(n.length>0){const e=await this.messenger.call("RewardsDataService:getOptInStatus",{addresses:n});i=e.ois,o=e.sids;for(let e=0;e<n.length;e++){const t=n[e],r=i[e],a=Array.isArray(o)&&e<o.length?o[e]:null,c=s.get(t.toLowerCase());if(c){const e=this.convertInternalAccountToCaipAccountId(c);if(e){const t=Date.now();this.update(s=>{var n;s.rewardsAccounts[e]?(s.rewardsAccounts[e].hasOptedIn=r,s.rewardsAccounts[e].subscriptionId=a,s.rewardsAccounts[e].lastFreshOptInStatusCheck=t):s.rewardsAccounts[e]={account:e,hasOptedIn:r,subscriptionId:a,perpsFeeDiscount:null,lastPerpsDiscountRateFetched:null,lastFreshOptInStatusCheck:t},(null===(n=s.rewardsActiveAccount)||void 0===n?void 0:n.account)===e&&(s.rewardsActiveAccount.hasOptedIn=r,s.rewardsActiveAccount.subscriptionId=a,s.rewardsActiveAccount.lastFreshOptInStatusCheck=t)})}}}}const c=[],l=[];let d=0;for(let t=0;t<e.addresses.length;t++)null===r[t]?(c[t]=i[d],l[t]=o[d],d+=1):(c[t]=r[t],l[t]=a[t]);return{ois:c,sids:l}}catch(e){throw n.default.error("RewardsController: Failed to get opt-in status:",e instanceof Error?e.message:String(e)),e}}async estimatePoints(e){if(!this.isRewardsFeatureEnabled())return{pointsEstimate:0,bonusBips:0};try{return await this.messenger.call("RewardsDataService:estimatePoints",e)}catch(e){throw n.default.error("RewardsController: Failed to estimate points:",e instanceof Error?e.message:String(e)),e}}isRewardsFeatureEnabled(){return!p(P,this).call(this)}async getSeasonMetadata(e="current"){return await E({key:e,ttl:6e5,readCache:e=>{const t=this.state.rewardsSeasons[e]||undefined;return t?{payload:t,lastFetched:t.lastFetched}:undefined},fetchFresh:async()=>{var t;const s=await this.messenger.call("RewardsDataService:getDiscoverSeasons");let r=null;if("current"===e?r=s.current:"next"===e&&(r=s.next),null!==(t=r)&&void 0!==t&&t.startDate){const e=await this.messenger.call("RewardsDataService:getSeasonMetadata",r.id);return{...b(R,this,C).call(this,{id:e.id,name:e.name,startDate:e.startDate,endDate:e.endDate,tiers:e.tiers}),lastFetched:Date.now()}}throw new Error(`No valid season metadata could be found for type: ${e}`)},writeCache:(e,t)=>{this.update(s=>{s.rewardsSeasons[e]=t,s.rewardsSeasons[t.id]=t})}})}async getSeasonStatus(e,t){if(!this.isRewardsFeatureEnabled())return null;const s=this.state.rewardsSeasons[t];if(!s)throw new Error(`Failed to get season status: season not found for seasonId: ${t}`);return await E({key:b(R,this,N).call(this,t,e),ttl:6e4,readCache:e=>{const t=this.state.rewardsSeasonStatuses[e]||undefined;return t?{payload:t,lastFetched:t.lastFetched}:undefined},fetchFresh:async()=>{try{const r=b(R,this,$).call(this,e);if(!r)throw new d.AuthorizationFailedError(`No subscription token found for subscription ID: ${e}`);const a=await this.messenger.call("RewardsDataService:getSeasonStatus",t,r),n=this.convertToSeasonStatusDto(s,a);return b(R,this,I).call(this,n)}catch(t){if(t instanceof d.AuthorizationFailedError)try{var r;if((null===(r=this.state.rewardsActiveAccount)||void 0===r?void 0:r.subscriptionId)===e){const e=await this.messenger.call("AccountsController:getSelectedMultichainAccount");await this.performSilentAuth(e,!1,!1)}else if(this.state.rewardsAccounts&&Object.values(this.state.rewardsAccounts).length>0){const t=Object.values(this.state.rewardsAccounts).find(t=>t.subscriptionId===e);if(t){const e=await this.messenger.call("AccountsController:listMultichainAccounts"),{convertInternalAccountToCaipAccountId:s}=this,r=e.find(e=>s(e)===t.account);r&&await this.performSilentAuth(r,!1,!1)}}const t=b(R,this,$).call(this,e);if(!t)throw new Error(`No subscription token found for subscription ID: ${e}`);const a=await this.messenger.call("RewardsDataService:getSeasonStatus",s.id,t),n=this.convertToSeasonStatusDto(s,a);return b(R,this,I).call(this,n)}catch{throw n.default.error("RewardsController: Failed to reauth with a valid account after 403 error",t instanceof Error?t.message:String(t)),this.invalidateSubscriptionCache(e),this.invalidateAccountsAndSubscriptions(),t}else if(t instanceof d.SeasonNotFoundError)throw this.update(e=>{e.rewardsSeasons={}}),t;throw n.default.error("RewardsController: Failed to get season status:",t instanceof Error?t.message:String(t)),t}},writeCache:(e,t)=>{this.update(s=>{s.rewardsSeasonStatuses[e]=t})}})}invalidateAccountsAndSubscriptions(){this.update(e=>{e.rewardsActiveAccount&&(e.rewardsActiveAccount={...e.rewardsActiveAccount,hasOptedIn:!1,subscriptionId:null,lastFreshOptInStatusCheck:null,account:e.rewardsActiveAccount.account}),e.rewardsAccounts={},e.rewardsSubscriptions={},e.rewardsSubscriptionTokens={}})}async optIn(e,t){var s;if(!this.isRewardsFeatureEnabled())return null;if(!e||0===e.length)return null;const r=(0,h.sortAccounts)(e);let a=null,n=null;for(const e of r){try{n=await b(R,this,F).call(this,e,t)}catch{}if(n){a=e;break}}if(!a||!n)throw new Error("Failed to opt in any account from the account group");const i=r.filter(e=>{var t;return e.address!==(null===(t=a)||void 0===t?void 0:t.address)});return i.length>0&&await this.linkAccountsToSubscriptionCandidate(i),(null===(s=n)||void 0===s?void 0:s.subscription.id)||null}async getRewardsGeoMetadata(){if(!this.isRewardsFeatureEnabled())return{geoLocation:"UNKNOWN",optinAllowedForGeo:!1};if(p(T,this))return p(T,this);try{const e=await this.messenger.call("RewardsDataService:fetchGeoLocation"),t=!w.some(t=>e.startsWith(t)),s={geoLocation:e,optinAllowedForGeo:t};return g(T,this,s),s}catch(e){return{geoLocation:"UNKNOWN",optinAllowedForGeo:!0}}}async validateReferralCode(e){if(!this.isRewardsFeatureEnabled())return!1;if(!e.trim())return!1;if(6!==e.length)return!1;return(await this.messenger.call("RewardsDataService:validateReferralCode",e)).valid}async getCandidateSubscriptionId(){var e;if(!this.isRewardsFeatureEnabled())return null;if(null!==(e=this.state.rewardsActiveAccount)&&void 0!==e&&e.subscriptionId)return this.state.rewardsActiveAccount.subscriptionId;const t=Object.keys(this.state.rewardsSubscriptions);if(1===t.length)return t[0];if(t.length>1){const e=Object.values(this.state.rewardsSubscriptions).sort((e,t)=>{try{const s=(null==e?void 0:e.candidateAt)||(null==e?void 0:e.createdAt),r=(null==t?void 0:t.candidateAt)||(null==t?void 0:t.createdAt);return new Date(s).getTime()-new Date(r).getTime()}catch{return 0}});return e.length>0?e[0].id:t[0]}try{var s;const e=this.messenger.call("AccountsController:listMultichainAccounts"),t=(null==e?void 0:e.filter(e=>this.isOptInSupported(e)))||[];if(!t||0===t.length)return null;const r=t.map(e=>e.address),a=await this.getOptInStatus({addresses:r});if(null==a||null===(s=a.ois)||void 0===s||!s.filter(e=>e).length)return null;const i=Math.min(10,a.ois.length);let o=0;for(let e=0;e<t.length&&!(o>i);e++){const s=t[e];if(!s||!1===a.ois[e])continue;let r=Array.isArray(null==a?void 0:a.sids)&&e<a.sids.length?a.sids[e]:null;const i=r?this.state.rewardsSubscriptionTokens[r]:undefined;if(r&&Boolean(i)&&this.state.rewardsSubscriptions[r])return r;try{if(o+=1,r=await this.performSilentAuth(s,!1,!1),r)return r}catch(e){n.default.error("RewardsController: Silent auth failed for account during candidate search:",s.address,e instanceof Error?e.message:String(e))}}}catch(e){n.default.error("RewardsController: Failed to get candidate subscription ID:",e instanceof Error?e.message:String(e))}throw new Error("No candidate subscription ID found after all silent auth attempts. There is an opted in account but we cannot use it to fetch the season status.")}async linkAccountToSubscriptionCandidate(e,t=!0){if(!this.isRewardsFeatureEnabled())return!1;const s=this.convertInternalAccountToCaipAccountId(e);if(!s)throw new Error("Failed to convert account to CAIP-10 format");const r=b(R,this,j).call(this,s);if(null!=r&&r.subscriptionId){if(this.state.rewardsSubscriptions[r.subscriptionId])return!0}const a=await this.getCandidateSubscriptionId();if(!a)throw new Error("No valid subscription found to link account to");if(!this.isOptInSupported(e))return!1;try{let r=Math.floor(Date.now()/1e3),n=await b(R,this,x).call(this,e,r),i=0;const o=1,c=async(t,s)=>{try{const r=b(R,this,$).call(this,a);if(!r)throw new Error(`No subscription token found for subscription ID: ${a}`);return await this.messenger.call("RewardsDataService:mobileJoin",{account:e.address,timestamp:t,signature:s},r)}catch(t){if(t instanceof d.InvalidTimestampError&&i<o)return i+=1,r=t.timestamp,n=await b(R,this,x).call(this,e,r),await c(r,n);if(t instanceof d.AccountAlreadyRegisteredError){const t=await this.performSilentAuth(e,!1,!1);if(t&&this.state.rewardsSubscriptions[t])return this.state.rewardsSubscriptions[t]}throw t}},l=await c(r,n);return this.update(e=>{var t;e.rewardsAccounts[s]={account:s,hasOptedIn:!0,subscriptionId:l.id,perpsFeeDiscount:null,lastPerpsDiscountRateFetched:null},(null===(t=e.rewardsActiveAccount)||void 0===t?void 0:t.account)===s&&(e.rewardsActiveAccount=e.rewardsAccounts[s])}),t&&(this.invalidateSubscriptionCache(l.id),this.messenger.publish("RewardsController:accountLinked",{subscriptionId:l.id,account:s})),!0}catch(e){return n.default.error("RewardsController: Failed to link account to subscription",s,a,e),!1}}async linkAccountsToSubscriptionCandidate(e){var t;if(!this.isRewardsFeatureEnabled())return e.map(e=>({account:e,success:!1}));if(0===e.length)return[];let s=null;const r=[];for(const t of e)try{const e=this.convertInternalAccountToCaipAccountId(t),a=b(R,this,j).call(this,e);if(null!=a&&a.subscriptionId)continue;const n=await this.linkAccountToSubscriptionCandidate(t,!1);if(n){const a=b(R,this,j).call(this,e);a&&(s=a),r.push({account:t,success:n})}else r.push({account:t,success:!1})}catch{r.push({account:t,success:!1})}return null!==(t=s)&&void 0!==t&&t.subscriptionId&&(this.invalidateSubscriptionCache(s.subscriptionId),this.messenger.publish("RewardsController:accountLinked",{subscriptionId:s.subscriptionId,account:s.account})),r}invalidateSubscriptionCache(e,t){if(t){const s=b(R,this,N).call(this,t,e);this.update(e=>{delete e.rewardsSeasonStatuses[s]})}else this.update(t=>{Object.keys(t.rewardsSeasonStatuses).forEach(s=>{s.includes(e)&&delete t.rewardsSeasonStatuses[s]})})}}function C(e){return{id:e.id,name:e.name,startDate:e.startDate.getTime(),endDate:e.endDate.getTime(),tiers:e.tiers}}function I(e){var t;const s=this.calculateTierStatus(e.season.tiers,e.currentTierId,e.balance.total);return{season:b(R,this,C).call(this,e.season),balance:{total:e.balance.total,updatedAt:null===(t=e.balance.updatedAt)||void 0===t?void 0:t.getTime()},tier:s,lastFetched:Date.now()}}function M(){this.messenger.registerActionHandler("RewardsController:getHasAccountOptedIn",this.getHasAccountOptedIn.bind(this)),this.messenger.registerActionHandler("RewardsController:estimatePoints",this.estimatePoints.bind(this)),this.messenger.registerActionHandler("RewardsController:isRewardsFeatureEnabled",this.isRewardsFeatureEnabled.bind(this)),this.messenger.registerActionHandler("RewardsController:getSeasonMetadata",this.getSeasonMetadata.bind(this)),this.messenger.registerActionHandler("RewardsController:getSeasonStatus",this.getSeasonStatus.bind(this)),this.messenger.registerActionHandler("RewardsController:optIn",this.optIn.bind(this)),this.messenger.registerActionHandler("RewardsController:getGeoRewardsMetadata",this.getRewardsGeoMetadata.bind(this)),this.messenger.registerActionHandler("RewardsController:validateReferralCode",this.validateReferralCode.bind(this)),this.messenger.registerActionHandler("RewardsController:linkAccountToSubscriptionCandidate",this.linkAccountToSubscriptionCandidate.bind(this)),this.messenger.registerActionHandler("RewardsController:linkAccountsToSubscriptionCandidate",this.linkAccountsToSubscriptionCandidate.bind(this)),this.messenger.registerActionHandler("RewardsController:getCandidateSubscriptionId",this.getCandidateSubscriptionId.bind(this)),this.messenger.registerActionHandler("RewardsController:getOptInStatus",this.getOptInStatus.bind(this)),this.messenger.registerActionHandler("RewardsController:isOptInSupported",this.isOptInSupported.bind(this)),this.messenger.registerActionHandler("RewardsController:getActualSubscriptionId",this.getActualSubscriptionId.bind(this))}function O(){this.messenger.subscribe("AccountTreeController:selectedAccountGroupChange",()=>this.handleAuthenticationTrigger("Account Group changed")),this.messenger.subscribe("KeyringController:unlock",()=>this.handleAuthenticationTrigger("KeyringController unlocked"))}function j(e){let t=null;var s;null!=e&&e.startsWith("eip155")&&(t=this.state.rewardsAccounts[`eip155:0:${null===(s=e.split(":")[2])||void 0===s?void 0:s.toLowerCase()}`]||this.state.rewardsAccounts[`eip155:0:${e.split(":")[2]}`]);return t||(t=this.state.rewardsAccounts[e]),t||null}function N(e,t){return`${e}:${t}`}async function x(e,s){const r=`rewards,${e.address},${s}`;if((0,i.isAddress)(e.address)){const s=await(0,u.signSolanaRewardsMessage)(this.messenger.call.bind(this.messenger,"SnapController:handleRequest"),e.id,t.from(r,"utf8").toString("base64"));return`0x${t.from(c.base58.decode(s.signature)).toString("hex")}`}if((0,c.isAddress)(e.address)){return await b(R,this,D).call(this,e,r)}throw new Error("Unsupported account type for signing rewards message")}async function D(e,s){const r=`0x${t.from(s,"utf8").toString("hex")}`;return await this.messenger.call("KeyringController:signPersonalMessage",{data:r,from:e.address})}function L(e,t){this.update(s=>{s.rewardsSubscriptionTokens[e]=t})}function $(e){return this.state.rewardsSubscriptionTokens[e]}async function F(e,t){var s;if(!this.isRewardsFeatureEnabled())return null;let r=Math.floor(Date.now()/1e3),a=await b(R,this,x).call(this,e,r),n=0;const i=async(s,o)=>{try{return await this.messenger.call("RewardsDataService:mobileOptin",{account:e.address,timestamp:s,signature:o,referralCode:t})}catch(t){if(t instanceof d.InvalidTimestampError&&n<1)return n+=1,r=t.timestamp,a=await b(R,this,x).call(this,e,r),await i(r,a);if(t instanceof d.AccountAlreadyRegisteredError){const t=await this.performSilentAuth(e,!1,!1);if(t&&this.state.rewardsSubscriptions[t]){const e=this.state.rewardsSubscriptions[t],s=b(R,this,$).call(this,t);if(s)return{sessionId:s,subscription:e}}}throw t}},o=await i(r,a);return null!==(s=o.subscription)&&void 0!==s&&s.id&&o.sessionId&&b(R,this,L).call(this,o.subscription.id,o.sessionId),this.update(t=>{var s,r;const a=this.convertInternalAccountToCaipAccountId(e);if(!a)return;const n={account:a,hasOptedIn:!0,subscriptionId:o.subscription.id,perpsFeeDiscount:null,lastPerpsDiscountRateFetched:null};if(t.rewardsActiveAccount&&t.rewardsActiveAccount.account===a&&(t.rewardsActiveAccount=n),t.rewardsAccounts[a]=n,null!=o&&null!==(s=o.subscription)&&void 0!==s&&s.id&&(null===(r=t.rewardsSubscriptions[o.subscription.id])||void 0===r||!r.candidateAt)){const e=Object.keys(t.rewardsSubscriptions??{}).length>0?new Date:k;o.subscription.candidateAt=e.toISOString()}t.rewardsSubscriptions[o.subscription.id]=o.subscription}),{subscription:o.subscription,sessionId:o.sessionId}}s.RewardsController=A}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"$root$",file:"app/scripts/controllers/rewards/rewards-controller.ts"}],[235,{"../../../../development/build/constants":594,"../../../../shared/constants/rewards":5737,"../../../../shared/modules/i18n":5854,"../../platforms/extension":579,loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getNormalisedLocale=s.SeasonNotFoundError=s.RewardsDataService=s.InvalidTimestampError=s.AuthorizationFailedError=s.AccountAlreadyRegisteredError=void 0;var r=c(e("loglevel")),a=e("../../../../development/build/constants"),n=c(e("../../platforms/extension")),i=e("../../../../shared/constants/rewards"),o=e("../../../../shared/modules/i18n");function c(e){return e&&e.__esModule?e:{default:e}}function l(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function d(e,t){return e.get(h(e,t))}function u(e,t,s){return e.set(h(e,t),s),s}function h(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}function f(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}class m extends Error{constructor(e,t){super(e),f(this,"timestamp",void 0),this.name="InvalidTimestampError",this.timestamp=t}}s.InvalidTimestampError=m;class p extends Error{constructor(e=p.defaultMessage){super(e),this.name="AuthorizationFailedError"}}s.AuthorizationFailedError=p,f(p,"defaultMessage",i.REWARDS_ERROR_MESSAGES.AUTHORIZATION_FAILED);class g extends Error{constructor(e=g.defaultMessage){super(e),this.name="SeasonNotFoundError"}}s.SeasonNotFoundError=g,f(g,"defaultMessage",i.REWARDS_ERROR_MESSAGES.SEASON_NOT_FOUND);class b extends Error{constructor(e){super(e),this.name="AccountAlreadyRegisteredError"}}s.AccountAlreadyRegisteredError=b;const w="RewardsDataService",y="https://on-ramp.api.cx.metamask.io/geolocation",S=e=>Intl.getCanonicalLocales(e?e.replace(/_/gu,"-"):o.FALLBACK_LOCALE)[0];s.getNormalisedLocale=S;var v=new WeakMap,_=new WeakMap,k=new WeakMap;s.RewardsDataService=class{constructor({messenger:e,fetch:t}){f(this,"name",w),l(this,v,void 0),l(this,_,void 0),l(this,k,void 0),u(v,this,e),u(_,this,t),u(k,this,this.getRewardsApiBaseUrl()),d(v,this).registerActionHandler(`${w}:login`,this.login.bind(this)),d(v,this).registerActionHandler(`${w}:estimatePoints`,this.estimatePoints.bind(this)),d(v,this).registerActionHandler(`${w}:mobileOptin`,this.mobileOptin.bind(this)),d(v,this).registerActionHandler(`${w}:getSeasonStatus`,this.getSeasonStatus.bind(this)),d(v,this).registerActionHandler(`${w}:fetchGeoLocation`,this.fetchGeoLocation.bind(this)),d(v,this).registerActionHandler(`${w}:validateReferralCode`,this.validateReferralCode.bind(this)),d(v,this).registerActionHandler(`${w}:mobileJoin`,this.mobileJoin.bind(this)),d(v,this).registerActionHandler(`${w}:getOptInStatus`,this.getOptInStatus.bind(this)),d(v,this).registerActionHandler(`${w}:getSeasonMetadata`,this.getSeasonMetadata.bind(this)),d(v,this).registerActionHandler(`${w}:getDiscoverSeasons`,this.getDiscoverSeasons.bind(this))}getRewardsApiBaseUrl(){return"pull-request"===a.ENVIRONMENT.PRODUCTION||"pull-request"===a.ENVIRONMENT.RELEASE_CANDIDATE?i.REWARDS_API_URL.PRD:i.REWARDS_API_URL.UAT}getLocale(){try{const e=d(v,this).call("PreferencesController:getState"),t=(null==e?void 0:e.currentLocale)||"en-US";return/^[a-z]{2}[-_][a-z]{2}$/iu.test(t)?t:S(t)}catch(e){r.default.warn("Failed to get locale from PreferencesController:",e);try{const e=d(v,this).call("PreferencesController:getState");return(null==e?void 0:e.currentLocale)||"en-US"}catch{return"en-US"}}}async makeRequest(e,t={},s,r=1e4){const a={"Content-Type":"application/json"};try{const e=(new n.default).getVersion();a["rewards-client-id"]=`extension-${e}`}catch(e){console.warn("Failed to retrieve app version for client header:",e)}s&&(a["rewards-access-token"]=s);const i=this.getLocale();i&&(a["Accept-Language"]=i);const o=`${d(k,this)}${e}`,c=new AbortController,l=setTimeout(()=>{c.abort()},r);try{const e=await d(_,this).call(this,o,{credentials:"omit",...t,headers:{...a,...t.headers},signal:c.signal});return clearTimeout(l),e}catch(e){if(clearTimeout(l),e instanceof Error&&"AbortError"===e.name)throw new Error(`Request timeout after ${r}ms`);throw e}}checkForAccountAlreadyRegisteredError(e,t){var s;if(409===e.status&&null!=t&&null!==(s=t.message)&&void 0!==s&&s.toLowerCase().includes("already registered"))throw new b(t.message||"Account is already registered")}async login(e){const t=await this.makeRequest("/auth/mobile-login",{method:"POST",body:JSON.stringify(e)});if(!t.ok){var s;const e=await t.json();if(null!=e&&null!==(s=e.message)&&void 0!==s&&s.includes("Invalid timestamp"))throw new m("Invalid timestamp. Please try again with a new timestamp.",Math.floor(Number(e.serverTimestamp)/1e3));throw this.checkForAccountAlreadyRegisteredError(t,e),new Error(`Login failed: ${t.status}`)}return await t.json()}async estimatePoints(e){const t=await this.makeRequest("/points-estimation",{method:"POST",body:JSON.stringify(e)});if(!t.ok)throw new Error(`Points estimation failed: ${t.status}`);return await t.json()}async mobileOptin(e){const t=await this.makeRequest("/auth/mobile-optin",{method:"POST",body:JSON.stringify(e)});if(!t.ok){var s;const e=await t.json();if(r.default.error("RewardsDataService: mobileOptin errorData",e),null!=e&&null!==(s=e.message)&&void 0!==s&&s.includes("Invalid timestamp"))throw new m("Invalid timestamp. Please try again with a new timestamp.",Math.floor(Number(e.serverTimestamp)/1e3));throw this.checkForAccountAlreadyRegisteredError(t,e),new Error(`Optin failed: ${t.status}`)}return await t.json()}async getSeasonStatus(e,t){const s=await this.makeRequest(`/seasons/${e}/state`,{method:"GET"},t);if(!s.ok){var r,a;const e=await s.json();if(null!=e&&null!==(r=e.message)&&void 0!==r&&r.includes("Rewards authorization failed"))throw new p;if(null!=e&&null!==(a=e.message)&&void 0!==a&&a.includes("Season not found"))throw new g;throw new Error(`Get season state failed: ${s.status}`)}const n=await s.json();return n.updatedAt&&(n.updatedAt=new Date(n.updatedAt)),n}async fetchGeoLocation(){let e="UNKNOWN";try{const t=await d(_,this).call(this,y);return t.ok?(e=await(null==t?void 0:t.text()),e):e}catch(t){return console.error("RewardsDataService: Failed to fetch geolocation",t),e}}async validateReferralCode(e){const t=await this.makeRequest(`/referral/validate?code=${encodeURIComponent(e)}`,{method:"GET"});if(!t.ok)throw new Error("Failed to validate referral code. Please try again shortly.");return await t.json()}async mobileJoin(e,t){const s=await this.makeRequest("/wr/subscriptions/mobile-join",{method:"POST",body:JSON.stringify(e)},t);if(!s.ok){var a;const e=await s.json();if(r.default.error("RewardsDataService: mobileJoin errorData",e),null!=e&&null!==(a=e.message)&&void 0!==a&&a.includes("Invalid timestamp"))throw new m("Invalid timestamp. Please try again with a new timestamp.",Math.floor(Number(e.serverTimestamp)/1e3));throw this.checkForAccountAlreadyRegisteredError(s,e),new Error(`Mobile join failed: ${s.status} ${(null==e?void 0:e.message)||""}`)}return await s.json()}async getOptInStatus(e){if(!e.addresses||0===e.addresses.length)throw new Error("Addresses are required");if(e.addresses.length>500)throw new Error("Addresses must be less than 500");const t=await this.makeRequest("/public/rewards/ois",{method:"POST",body:JSON.stringify(e)});if(!t.ok)throw new Error(`Get opt-in status failed: ${t.status}`);return await t.json()}async getDiscoverSeasons(){const e=await this.makeRequest("/public/seasons/status",{method:"GET"});if(!e.ok)throw new Error(`Get discover seasons failed: ${e.status}`);const t=await e.json();return t.current&&(t.current.startDate&&(t.current.startDate=new Date(t.current.startDate)),t.current.endDate&&(t.current.endDate=new Date(t.current.endDate))),t.next&&(t.next.startDate&&(t.next.startDate=new Date(t.next.startDate)),t.next.endDate&&(t.next.endDate=new Date(t.next.endDate))),t}async getSeasonMetadata(e){const t=await this.makeRequest(`/public/seasons/${e}/meta`,{method:"GET"});if(!t.ok)throw new Error(`Get season metadata failed: ${t.status}`);const s=await t.json();return s.startDate&&(s.startDate=new Date(s.startDate)),s.endDate&&(s.endDate=new Date(s.endDate)),s}}}}},{package:"$root$",file:"app/scripts/controllers/rewards/rewards-data-service.ts"}],[236,{"../../../../../shared/lib/accounts":5754,"@metamask/snaps-utils":2883,loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.signSolanaRewardsMessage=async function(e,t,s){try{return await e({origin:"metamask",snapId:i.SOLANA_WALLET_SNAP_ID,handler:a.HandlerType.OnClientRequest,request:{jsonrpc:"2.0",id:Date.now(),method:"signRewardsMessage",params:{accountId:t,message:s}}})}catch(e){throw n.default.error("Error signing Solana rewards message:",e),e}};var r,a=e("@metamask/snaps-utils"),n=(r=e("loglevel"))&&r.__esModule?r:{default:r},i=e("../../../../../shared/lib/accounts")}}},{package:"$root$",file:"app/scripts/controllers/rewards/utils/solana-snap.ts"}],[2364,{"./ObservableStore":2366},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ComposedStore=void 0;const r=e("./ObservableStore");class a extends r.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach(e=>{const t=this._children[e];this._addChild(e,t)})}_addChild(e,t){const s=t=>{const s=this.getState();s[e]=t,this.putState(s)};t.subscribe(s),s(t.getState())}}s.ComposedStore=a}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],[2365,{"./ObservableStore":2366},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MergedStore=void 0;const r=e("./ObservableStore");class a extends r.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach(e=>this._addChild(e)),this._updateWholeState()}_addChild(e){e.subscribe(()=>this._updateWholeState())}_updateWholeState(){const e=this._children.map(e=>e.getState()),t=Object.assign({},...e);this.putState(t)}}s.MergedStore=a}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],[2366,{"@metamask/safe-event-emitter":2586},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.ObservableStore=void 0;const a=r(e("@metamask/safe-event-emitter"));class n extends a.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}s.ObservableStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],[2367,{"readable-stream":2384},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeAsStream=void 0;const r=e("readable-stream");class a extends r.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const s=super.pipe(e,t);return e.write(this.obsStore.getState()),s}_write(e,t,s){this.obsStore.putState(e),s()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}s.storeAsStream=function(e){return new a(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],[2368,{"./ComposedStore":2364,"./MergedStore":2365,"./ObservableStore":2366,"./asStream":2367,"./transform":2369},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s),Object.defineProperty(e,r,{enumerable:!0,get:function(){return t[s]}})}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./asStream"),s),a(e("./ComposedStore"),s),a(e("./MergedStore"),s),a(e("./ObservableStore"),s),a(e("./transform"),s)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],[2369,{"readable-stream":2384},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeTransformStream=void 0;const r=e("readable-stream");s.storeTransformStream=function(e){return new r.Transform({objectMode:!0,transform:(t,s,r)=>{try{const s=e(t);return r(undefined,s),undefined}catch(e){return r(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],[237,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.sortAccounts=function(e){return[...e].sort((e,t)=>{const s=e.type.startsWith("eip155:"),r=t.type.startsWith("eip155:");return s&&!r?-1:!s&&r?1:0})}}}},{package:"$root$",file:"app/scripts/controllers/rewards/utils/sortAccounts.ts"}],[2370,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r={};function a(e,t,s){s||(s=Error);var a=function(e){var s,r;function a(s,r,a){return e.call(this,function(e,s,r){return"string"==typeof t?t:t(e,s,r)}(s,r,a))||this}return r=e,(s=a).prototype=Object.create(r.prototype),s.prototype.constructor=s,s.__proto__=r,a}(s);a.prototype.name=s.name,a.prototype.code=e,r[e]=a}function n(e,t){if(Array.isArray(e)){var s=e.length;return e=e.map(function(e){return String(e)}),s>2?"one of ".concat(t," ").concat(e.slice(0,s-1).join(", "),", or ")+e[s-1]:2===s?"one of ".concat(t," ").concat(e[0]," or ").concat(e[1]):"of ".concat(t," ").concat(e[0])}return"of ".concat(t," ").concat(String(e))}a("ERR_INVALID_OPT_VALUE",function(e,t){return'The value "'+t+'" is invalid for option "'+e+'"'},TypeError),a("ERR_INVALID_ARG_TYPE",function(e,t,s){var r,a,i,o;if("string"==typeof t&&(a="not ",t.substr(!i||i<0?0:+i,a.length)===a)?(r="must not be",t=t.replace(/^not /,"")):r="must be",function(e,t,s){return(s===undefined||s>e.length)&&(s=e.length),e.substring(s-t.length,s)===t}(e," argument"))o="The ".concat(e," ").concat(r," ").concat(n(t,"type"));else{var c=function(e,t,s){return"number"!=typeof s&&(s=0),!(s+t.length>e.length)&&-1!==e.indexOf(t,s)}(e,".")?"property":"argument";o='The "'.concat(e,'" ').concat(c," ").concat(r," ").concat(n(t,"type"))}return o+=". Received type ".concat(typeof s)},TypeError),a("ERR_STREAM_PUSH_AFTER_EOF","stream.push() after EOF"),a("ERR_METHOD_NOT_IMPLEMENTED",function(e){return"The "+e+" method is not implemented"}),a("ERR_STREAM_PREMATURE_CLOSE","Premature close"),a("ERR_STREAM_DESTROYED",function(e){return"Cannot call "+e+" after a stream was destroyed"}),a("ERR_MULTIPLE_CALLBACK","Callback called multiple times"),a("ERR_STREAM_CANNOT_PIPE","Cannot pipe, not readable"),a("ERR_STREAM_WRITE_AFTER_END","write after end"),a("ERR_STREAM_NULL_VALUES","May not write null values to stream",TypeError),a("ERR_UNKNOWN_ENCODING",function(e){return"Unknown encoding: "+e},TypeError),a("ERR_STREAM_UNSHIFT_AFTER_END_EVENT","stream.unshift() after end event"),t.exports.codes=r}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/errors-browser.js"}],[2371,{"./_stream_readable":2373,"./_stream_writable":2375,_process:5024,inherits:4552},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var r=Object.keys||function(e){var t=[];for(var s in e)t.push(s);return t};t.exports=l;var a=e("./_stream_readable"),n=e("./_stream_writable");e("inherits")(l,a);for(var i=r(n.prototype),o=0;o<i.length;o++){var c=i[o];l.prototype[c]||(l.prototype[c]=n.prototype[c])}function l(e){if(!(this instanceof l))return new l(e);a.call(this,e),n.call(this,e),this.allowHalfOpen=!0,e&&(!1===e.readable&&(this.readable=!1),!1===e.writable&&(this.writable=!1),!1===e.allowHalfOpen&&(this.allowHalfOpen=!1,this.once("end",d)))}function d(){this._writableState.ended||s.nextTick(u,this)}function u(e){e.end()}Object.defineProperty(l.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(l.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(l.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(l.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed&&this._writableState.destroyed)},set:function(e){this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_duplex.js"}],[2372,{"./_stream_transform":2374,inherits:4552},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=a;var r=e("./_stream_transform");function a(e){if(!(this instanceof a))return new a(e);r.call(this,e)}e("inherits")(a,r),a.prototype._transform=function(e,t,s){s(null,e)}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_passthrough.js"}],[2373,{"../errors":2370,"./_stream_duplex":2371,"./internal/streams/async_iterator":2376,"./internal/streams/buffer_list":2377,"./internal/streams/destroy":2378,"./internal/streams/from":2380,"./internal/streams/state":2382,"./internal/streams/stream":2383,_process:5024,buffer:4019,events:4319,inherits:4552,"string_decoder/":5600,util:3971},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var r;t.exports=E,E.ReadableState=k;e("events").EventEmitter;var a=function(e,t){return e.listeners(t).length},n=e("./internal/streams/stream"),i=e("buffer").Buffer,o=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var c,l=e("util");c=l&&l.debuglog?l.debuglog("stream"):function(){};var d,u,h,f=e("./internal/streams/buffer_list"),m=e("./internal/streams/destroy"),p=e("./internal/streams/state").getHighWaterMark,g=e("../errors").codes,b=g.ERR_INVALID_ARG_TYPE,w=g.ERR_STREAM_PUSH_AFTER_EOF,y=g.ERR_METHOD_NOT_IMPLEMENTED,S=g.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;e("inherits")(E,n);var v=m.errorOrDestroy,_=["error","close","destroy","pause","resume"];function k(t,s,a){r=r||e("./_stream_duplex"),t=t||{},"boolean"!=typeof a&&(a=s instanceof r),this.objectMode=!!t.objectMode,a&&(this.objectMode=this.objectMode||!!t.readableObjectMode),this.highWaterMark=p(this,t,"readableHighWaterMark",a),this.buffer=new f,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.paused=!0,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.destroyed=!1,this.defaultEncoding=t.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,t.encoding&&(d||(d=e("string_decoder/").StringDecoder),this.decoder=new d(t.encoding),this.encoding=t.encoding)}function E(t){if(r=r||e("./_stream_duplex"),!(this instanceof E))return new E(t);var s=this instanceof r;this._readableState=new k(t,this,s),this.readable=!0,t&&("function"==typeof t.read&&(this._read=t.read),"function"==typeof t.destroy&&(this._destroy=t.destroy)),n.call(this)}function T(e,t,s,r,a){c("readableAddChunk",t);var n,l=e._readableState;if(null===t)l.reading=!1,function(e,t){if(c("onEofChunk"),t.ended)return;if(t.decoder){var s=t.decoder.end();s&&s.length&&(t.buffer.push(s),t.length+=t.objectMode?1:s.length)}t.ended=!0,t.sync?C(e):(t.needReadable=!1,t.emittedReadable||(t.emittedReadable=!0,I(e)))}(e,l);else if(a||(n=function(e,t){var s;r=t,i.isBuffer(r)||r instanceof o||"string"==typeof t||t===undefined||e.objectMode||(s=new b("chunk",["string","Buffer","Uint8Array"],t));var r;return s}(l,t)),n)v(e,n);else if(l.objectMode||t&&t.length>0)if("string"==typeof t||l.objectMode||Object.getPrototypeOf(t)===i.prototype||(t=function(e){return i.from(e)}(t)),r)l.endEmitted?v(e,new S):P(e,l,t,!0);else if(l.ended)v(e,new w);else{if(l.destroyed)return!1;l.reading=!1,l.decoder&&!s?(t=l.decoder.write(t),l.objectMode||0!==t.length?P(e,l,t,!1):M(e,l)):P(e,l,t,!1)}else r||(l.reading=!1,M(e,l));return!l.ended&&(l.length<l.highWaterMark||0===l.length)}function P(e,t,s,r){t.flowing&&0===t.length&&!t.sync?(t.awaitDrain=0,e.emit("data",s)):(t.length+=t.objectMode?1:s.length,r?t.buffer.unshift(s):t.buffer.push(s),t.needReadable&&C(e)),M(e,t)}Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),E.prototype.destroy=m.destroy,E.prototype._undestroy=m.undestroy,E.prototype._destroy=function(e,t){t(e)},E.prototype.push=function(e,t){var s,r=this._readableState;return r.objectMode?s=!0:"string"==typeof e&&((t=t||r.defaultEncoding)!==r.encoding&&(e=i.from(e,t),t=""),s=!0),T(this,e,t,!1,s)},E.prototype.unshift=function(e){return T(this,e,null,!0,!1)},E.prototype.isPaused=function(){return!1===this._readableState.flowing},E.prototype.setEncoding=function(t){d||(d=e("string_decoder/").StringDecoder);var s=new d(t);this._readableState.decoder=s,this._readableState.encoding=this._readableState.decoder.encoding;for(var r=this._readableState.buffer.head,a="";null!==r;)a+=s.write(r.data),r=r.next;return this._readableState.buffer.clear(),""!==a&&this._readableState.buffer.push(a),this._readableState.length=a.length,this};var R=1073741824;function A(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=R?e=R:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function C(e){var t=e._readableState;c("emitReadable",t.needReadable,t.emittedReadable),t.needReadable=!1,t.emittedReadable||(c("emitReadable",t.flowing),t.emittedReadable=!0,s.nextTick(I,e))}function I(e){var t=e._readableState;c("emitReadable_",t.destroyed,t.length,t.ended),t.destroyed||!t.length&&!t.ended||(e.emit("readable"),t.emittedReadable=!1),t.needReadable=!t.flowing&&!t.ended&&t.length<=t.highWaterMark,D(e)}function M(e,t){t.readingMore||(t.readingMore=!0,s.nextTick(O,e,t))}function O(e,t){for(;!t.reading&&!t.ended&&(t.length<t.highWaterMark||t.flowing&&0===t.length);){var s=t.length;if(c("maybeReadMore read 0"),e.read(0),s===t.length)break}t.readingMore=!1}function j(e){var t=e._readableState;t.readableListening=e.listenerCount("readable")>0,t.resumeScheduled&&!t.paused?t.flowing=!0:e.listenerCount("data")>0&&e.resume()}function N(e){c("readable nexttick read 0"),e.read(0)}function x(e,t){c("resume",t.reading),t.reading||e.read(0),t.resumeScheduled=!1,e.emit("resume"),D(e),t.flowing&&!t.reading&&e.read(0)}function D(e){var t=e._readableState;for(c("flow",t.flowing);t.flowing&&null!==e.read(););}function L(e,t){return 0===t.length?null:(t.objectMode?s=t.buffer.shift():!e||e>=t.length?(s=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.first():t.buffer.concat(t.length),t.buffer.clear()):s=t.buffer.consume(e,t.decoder),s);var s}function $(e){var t=e._readableState;c("endReadable",t.endEmitted),t.endEmitted||(t.ended=!0,s.nextTick(F,t,e))}function F(e,t){if(c("endReadableNT",e.endEmitted,e.length),!e.endEmitted&&0===e.length&&(e.endEmitted=!0,t.readable=!1,t.emit("end"),e.autoDestroy)){var s=t._writableState;(!s||s.autoDestroy&&s.finished)&&t.destroy()}}function U(e,t){for(var s=0,r=e.length;s<r;s++)if(e[s]===t)return s;return-1}E.prototype.read=function(e){c("read",e),e=parseInt(e,10);var t=this._readableState,s=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&((0!==t.highWaterMark?t.length>=t.highWaterMark:t.length>0)||t.ended))return c("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?$(this):C(this),null;if(0===(e=A(e,t))&&t.ended)return 0===t.length&&$(this),null;var r,a=t.needReadable;return c("need readable",a),(0===t.length||t.length-e<t.highWaterMark)&&c("length less than watermark",a=!0),t.ended||t.reading?c("reading or ended",a=!1):a&&(c("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=A(s,t))),null===(r=e>0?L(e,t):null)?(t.needReadable=t.length<=t.highWaterMark,e=0):(t.length-=e,t.awaitDrain=0),0===t.length&&(t.ended||(t.needReadable=!0),s!==e&&t.ended&&$(this)),null!==r&&this.emit("data",r),r},E.prototype._read=function(e){v(this,new y("_read()"))},E.prototype.pipe=function(e,t){var r=this,n=this._readableState;switch(n.pipesCount){case 0:n.pipes=e;break;case 1:n.pipes=[n.pipes,e];break;default:n.pipes.push(e)}n.pipesCount+=1,c("pipe count=%d opts=%j",n.pipesCount,t);var i=(!t||!1!==t.end)&&e!==s.stdout&&e!==s.stderr?l:g;function o(t,s){c("onunpipe"),t===r&&s&&!1===s.hasUnpiped&&(s.hasUnpiped=!0,c("cleanup"),e.removeListener("close",m),e.removeListener("finish",p),e.removeListener("drain",d),e.removeListener("error",f),e.removeListener("unpipe",o),r.removeListener("end",l),r.removeListener("end",g),r.removeListener("data",h),u=!0,!n.awaitDrain||e._writableState&&!e._writableState.needDrain||d())}function l(){c("onend"),e.end()}n.endEmitted?s.nextTick(i):r.once("end",i),e.on("unpipe",o);var d=function(e){return function(){var t=e._readableState;c("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&a(e,"data")&&(t.flowing=!0,D(e))}}(r);e.on("drain",d);var u=!1;function h(t){c("ondata");var s=e.write(t);c("dest.write",s),!1===s&&((1===n.pipesCount&&n.pipes===e||n.pipesCount>1&&-1!==U(n.pipes,e))&&!u&&(c("false write response, pause",n.awaitDrain),n.awaitDrain++),r.pause())}function f(t){c("onerror",t),g(),e.removeListener("error",f),0===a(e,"error")&&v(e,t)}function m(){e.removeListener("finish",p),g()}function p(){c("onfinish"),e.removeListener("close",m),g()}function g(){c("unpipe"),r.unpipe(e)}return r.on("data",h),function(e,t,s){if("function"==typeof e.prependListener)return e.prependListener(t,s);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(s):e._events[t]=[s,e._events[t]]:e.on(t,s)}(e,"error",f),e.once("close",m),e.once("finish",p),e.emit("pipe",r),n.flowing||(c("pipe resume"),r.resume()),e},E.prototype.unpipe=function(e){var t=this._readableState,s={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,s)),this;if(!e){var r=t.pipes,a=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var n=0;n<a;n++)r[n].emit("unpipe",this,{hasUnpiped:!1});return this}var i=U(t.pipes,e);return-1===i||(t.pipes.splice(i,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,s)),this},E.prototype.on=function(e,t){var r=n.prototype.on.call(this,e,t),a=this._readableState;return"data"===e?(a.readableListening=this.listenerCount("readable")>0,!1!==a.flowing&&this.resume()):"readable"===e&&(a.endEmitted||a.readableListening||(a.readableListening=a.needReadable=!0,a.flowing=!1,a.emittedReadable=!1,c("on readable",a.length,a.reading),a.length?C(this):a.reading||s.nextTick(N,this))),r},E.prototype.addListener=E.prototype.on,E.prototype.removeListener=function(e,t){var r=n.prototype.removeListener.call(this,e,t);return"readable"===e&&s.nextTick(j,this),r},E.prototype.removeAllListeners=function(e){var t=n.prototype.removeAllListeners.apply(this,arguments);return"readable"!==e&&e!==undefined||s.nextTick(j,this),t},E.prototype.resume=function(){var e=this._readableState;return e.flowing||(c("resume"),e.flowing=!e.readableListening,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,s.nextTick(x,e,t))}(this,e)),e.paused=!1,this},E.prototype.pause=function(){return c("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(c("pause"),this._readableState.flowing=!1,this.emit("pause")),this._readableState.paused=!0,this},E.prototype.wrap=function(e){var t=this,s=this._readableState,r=!1;for(var a in e.on("end",function(){if(c("wrapped end"),s.decoder&&!s.ended){var e=s.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(a){(c("wrapped data"),s.decoder&&(a=s.decoder.write(a)),!s.objectMode||null!==a&&a!==undefined)&&((s.objectMode||a&&a.length)&&(t.push(a)||(r=!0,e.pause())))}),e)this[a]===undefined&&"function"==typeof e[a]&&(this[a]=function(t){return function(){return e[t].apply(e,arguments)}}(a));for(var n=0;n<_.length;n++)e.on(_[n],this.emit.bind(this,_[n]));return this._read=function(t){c("wrapped _read",t),r&&(r=!1,e.resume())},this},"function"==typeof Symbol&&(E.prototype[Symbol.asyncIterator]=function(){return u===undefined&&(u=e("./internal/streams/async_iterator")),u(this)}),Object.defineProperty(E.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),Object.defineProperty(E.prototype,"readableBuffer",{enumerable:!1,get:function(){return this._readableState&&this._readableState.buffer}}),Object.defineProperty(E.prototype,"readableFlowing",{enumerable:!1,get:function(){return this._readableState.flowing},set:function(e){this._readableState&&(this._readableState.flowing=e)}}),E._fromList=L,Object.defineProperty(E.prototype,"readableLength",{enumerable:!1,get:function(){return this._readableState.length}}),"function"==typeof Symbol&&(E.from=function(t,s){return h===undefined&&(h=e("./internal/streams/from")),h(E,t,s)})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_readable.js"}],[2374,{"../errors":2370,"./_stream_duplex":2371,inherits:4552},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=d;var r=e("../errors").codes,a=r.ERR_METHOD_NOT_IMPLEMENTED,n=r.ERR_MULTIPLE_CALLBACK,i=r.ERR_TRANSFORM_ALREADY_TRANSFORMING,o=r.ERR_TRANSFORM_WITH_LENGTH_0,c=e("./_stream_duplex");function l(e,t){var s=this._transformState;s.transforming=!1;var r=s.writecb;if(null===r)return this.emit("error",new n);s.writechunk=null,s.writecb=null,null!=t&&this.push(t),r(e);var a=this._readableState;a.reading=!1,(a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}function d(e){if(!(this instanceof d))return new d(e);c.call(this,e),this._transformState={afterTransform:l.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",u)}function u(){var e=this;"function"!=typeof this._flush||this._readableState.destroyed?h(this,null,null):this._flush(function(t,s){h(e,t,s)})}function h(e,t,s){if(t)return e.emit("error",t);if(null!=s&&e.push(s),e._writableState.length)throw new o;if(e._transformState.transforming)throw new i;return e.push(null)}e("inherits")(d,c),d.prototype.push=function(e,t){return this._transformState.needTransform=!1,c.prototype.push.call(this,e,t)},d.prototype._transform=function(e,t,s){s(new a("_transform()"))},d.prototype._write=function(e,t,s){var r=this._transformState;if(r.writecb=s,r.writechunk=e,r.writeencoding=t,!r.transforming){var a=this._readableState;(r.needTransform||a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}},d.prototype._read=function(e){var t=this._transformState;null===t.writechunk||t.transforming?t.needTransform=!0:(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform))},d.prototype._destroy=function(e,t){c.prototype._destroy.call(this,e,function(e){t(e)})}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_transform.js"}],[2375,{"../errors":2370,"./_stream_duplex":2371,"./internal/streams/destroy":2378,"./internal/streams/state":2382,"./internal/streams/stream":2383,_process:5024,buffer:4019,inherits:4552,"util-deprecate":5665},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){function r(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t,s){var r=e.entry;e.entry=null;for(;r;){var a=r.callback;t.pendingcb--,a(s),r=r.next}t.corkedRequestsFree.next=e}(t,e)}}var a;t.exports=E,E.WritableState=k;var n={deprecate:e("util-deprecate")},i=e("./internal/streams/stream"),o=e("buffer").Buffer,c=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var l,d=e("./internal/streams/destroy"),u=e("./internal/streams/state").getHighWaterMark,h=e("../errors").codes,f=h.ERR_INVALID_ARG_TYPE,m=h.ERR_METHOD_NOT_IMPLEMENTED,p=h.ERR_MULTIPLE_CALLBACK,g=h.ERR_STREAM_CANNOT_PIPE,b=h.ERR_STREAM_DESTROYED,w=h.ERR_STREAM_NULL_VALUES,y=h.ERR_STREAM_WRITE_AFTER_END,S=h.ERR_UNKNOWN_ENCODING,v=d.errorOrDestroy;function _(){}function k(t,n,i){a=a||e("./_stream_duplex"),t=t||{},"boolean"!=typeof i&&(i=n instanceof a),this.objectMode=!!t.objectMode,i&&(this.objectMode=this.objectMode||!!t.writableObjectMode),this.highWaterMark=u(this,t,"writableHighWaterMark",i),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var o=!1===t.decodeStrings;this.decodeStrings=!o,this.defaultEncoding=t.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var r=e._writableState,a=r.sync,n=r.writecb;if("function"!=typeof n)throw new p;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(r),t)!function(e,t,r,a,n){--t.pendingcb,r?(s.nextTick(n,a),s.nextTick(I,e,t),e._writableState.errorEmitted=!0,v(e,a)):(n(a),e._writableState.errorEmitted=!0,v(e,a),I(e,t))}(e,r,a,t,n);else{var i=A(r)||e.destroyed;i||r.corked||r.bufferProcessing||!r.bufferedRequest||R(e,r),a?s.nextTick(P,e,r,i,n):P(e,r,i,n)}}(n,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.bufferedRequestCount=0,this.corkedRequestsFree=new r(this)}function E(t){var s=this instanceof(a=a||e("./_stream_duplex"));if(!s&&!l.call(E,this))return new E(t);this._writableState=new k(t,this,s),this.writable=!0,t&&("function"==typeof t.write&&(this._write=t.write),"function"==typeof t.writev&&(this._writev=t.writev),"function"==typeof t.destroy&&(this._destroy=t.destroy),"function"==typeof t.final&&(this._final=t.final)),i.call(this)}function T(e,t,s,r,a,n,i){t.writelen=r,t.writecb=i,t.writing=!0,t.sync=!0,t.destroyed?t.onwrite(new b("write")):s?e._writev(a,t.onwrite):e._write(a,n,t.onwrite),t.sync=!1}function P(e,t,s,r){s||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,r(),I(e,t)}function R(e,t){t.bufferProcessing=!0;var s=t.bufferedRequest;if(e._writev&&s&&s.next){var a=t.bufferedRequestCount,n=new Array(a),i=t.corkedRequestsFree;i.entry=s;for(var o=0,c=!0;s;)n[o]=s,s.isBuf||(c=!1),s=s.next,o+=1;n.allBuffers=c,T(e,t,!0,t.length,n,"",i.finish),t.pendingcb++,t.lastBufferedRequest=null,i.next?(t.corkedRequestsFree=i.next,i.next=null):t.corkedRequestsFree=new r(t),t.bufferedRequestCount=0}else{for(;s;){var l=s.chunk,d=s.encoding,u=s.callback;if(T(e,t,!1,t.objectMode?1:l.length,l,d,u),s=s.next,t.bufferedRequestCount--,t.writing)break}null===s&&(t.lastBufferedRequest=null)}t.bufferedRequest=s,t.bufferProcessing=!1}function A(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function C(e,t){e._final(function(s){t.pendingcb--,s&&v(e,s),t.prefinished=!0,e.emit("prefinish"),I(e,t)})}function I(e,t){var r=A(t);if(r&&(function(e,t){t.prefinished||t.finalCalled||("function"!=typeof e._final||t.destroyed?(t.prefinished=!0,e.emit("prefinish")):(t.pendingcb++,t.finalCalled=!0,s.nextTick(C,e,t)))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"),t.autoDestroy))){var a=e._readableState;(!a||a.autoDestroy&&a.endEmitted)&&e.destroy()}return r}e("inherits")(E,i),k.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(k.prototype,"buffer",{get:n.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(l=Function.prototype[Symbol.hasInstance],Object.defineProperty(E,Symbol.hasInstance,{value:function(e){return!!l.call(this,e)||this===E&&(e&&e._writableState instanceof k)}})):l=function(e){return e instanceof this},E.prototype.pipe=function(){v(this,new g)},E.prototype.write=function(e,t,r){var a,n=this._writableState,i=!1,l=!n.objectMode&&(a=e,o.isBuffer(a)||a instanceof c);return l&&!o.isBuffer(e)&&(e=function(e){return o.from(e)}(e)),"function"==typeof t&&(r=t,t=null),l?t="buffer":t||(t=n.defaultEncoding),"function"!=typeof r&&(r=_),n.ending?function(e,t){var r=new y;v(e,r),s.nextTick(t,r)}(this,r):(l||function(e,t,r,a){var n;return null===r?n=new w:"string"==typeof r||t.objectMode||(n=new f("chunk",["string","Buffer"],r)),!n||(v(e,n),s.nextTick(a,n),!1)}(this,n,e,r))&&(n.pendingcb++,i=function(e,t,s,r,a,n){if(!s){var i=function(e,t,s){e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=o.from(t,s));return t}(t,r,a);r!==i&&(s=!0,a="buffer",r=i)}var c=t.objectMode?1:r.length;t.length+=c;var l=t.length<t.highWaterMark;l||(t.needDrain=!0);if(t.writing||t.corked){var d=t.lastBufferedRequest;t.lastBufferedRequest={chunk:r,encoding:a,isBuf:s,callback:n,next:null},d?d.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else T(e,t,!1,c,r,a,n);return l}(this,n,l,e,t,r)),i},E.prototype.cork=function(){this._writableState.corked++},E.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||R(this,e))},E.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new S(e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(E.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(E.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),E.prototype._write=function(e,t,s){s(new m("_write()"))},E.prototype._writev=null,E.prototype.end=function(e,t,r){var a=this._writableState;return"function"==typeof e?(r=e,e=null,t=null):"function"==typeof t&&(r=t,t=null),null!==e&&e!==undefined&&this.write(e,t),a.corked&&(a.corked=1,this.uncork()),a.ending||function(e,t,r){t.ending=!0,I(e,t),r&&(t.finished?s.nextTick(r):e.once("finish",r));t.ended=!0,e.writable=!1}(this,a,r),this},Object.defineProperty(E.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._writableState!==undefined&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),E.prototype.destroy=d.destroy,E.prototype._undestroy=d.undestroy,E.prototype._destroy=function(e,t){t(e)}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_writable.js"}],[2376,{"./end-of-stream":2379,_process:5024},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var r;function a(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var s=e[Symbol.toPrimitive];if(s!==undefined){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}var n=e("./end-of-stream"),i=Symbol("lastResolve"),o=Symbol("lastReject"),c=Symbol("error"),l=Symbol("ended"),d=Symbol("lastPromise"),u=Symbol("handlePromise"),h=Symbol("stream");function f(e,t){return{value:e,done:t}}function m(e){var t=e[i];if(null!==t){var s=e[h].read();null!==s&&(e[d]=null,e[i]=null,e[o]=null,t(f(s,!1)))}}function p(e){s.nextTick(m,e)}var g=Object.getPrototypeOf(function(){}),b=Object.setPrototypeOf((a(r={get stream(){return this[h]},next:function(){var e=this,t=this[c];if(null!==t)return Promise.reject(t);if(this[l])return Promise.resolve(f(undefined,!0));if(this[h].destroyed)return new Promise(function(t,r){s.nextTick(function(){e[c]?r(e[c]):t(f(undefined,!0))})});var r,a=this[d];if(a)r=new Promise(function(e,t){return function(s,r){e.then(function(){t[l]?s(f(undefined,!0)):t[u](s,r)},r)}}(a,this));else{var n=this[h].read();if(null!==n)return Promise.resolve(f(n,!1));r=new Promise(this[u])}return this[d]=r,r}},Symbol.asyncIterator,function(){return this}),a(r,"return",function(){var e=this;return new Promise(function(t,s){e[h].destroy(null,function(e){e?s(e):t(f(undefined,!0))})})}),r),g);t.exports=function(e){var t,s=Object.create(b,(a(t={},h,{value:e,writable:!0}),a(t,i,{value:null,writable:!0}),a(t,o,{value:null,writable:!0}),a(t,c,{value:null,writable:!0}),a(t,l,{value:e._readableState.endEmitted,writable:!0}),a(t,u,{value:function(e,t){var r=s[h].read();r?(s[d]=null,s[i]=null,s[o]=null,e(f(r,!1))):(s[i]=e,s[o]=t)},writable:!0}),t));return s[d]=null,n(e,function(e){if(e&&"ERR_STREAM_PREMATURE_CLOSE"!==e.code){var t=s[o];return null!==t&&(s[d]=null,s[i]=null,s[o]=null,t(e)),void(s[c]=e)}var r=s[i];null!==r&&(s[d]=null,s[i]=null,s[o]=null,r(f(undefined,!0))),s[l]=!0}),e.on("readable",p.bind(null,s)),s}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/async_iterator.js"}],[2377,{buffer:4019,util:3971},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e,t){var s=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),s.push.apply(s,r)}return s}function a(e){for(var t=1;t<arguments.length;t++){var s=null!=arguments[t]?arguments[t]:{};t%2?r(Object(s),!0).forEach(function(t){n(e,t,s[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(s)):r(Object(s)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(s,t))})}return e}function n(e,t,s){return(t=o(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t){for(var s=0;s<t.length;s++){var r=t[s];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,o(r.key),r)}}function o(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var s=e[Symbol.toPrimitive];if(s!==undefined){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}var c=e("buffer").Buffer,l=e("util").inspect,d=l&&l.custom||"inspect";function u(e,t,s){c.prototype.copy.call(e,t,s)}t.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}var t,s,r;return t=e,(s=[{key:"push",value:function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length}},{key:"unshift",value:function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length}},{key:"shift",value:function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}}},{key:"clear",value:function(){this.head=this.tail=null,this.length=0}},{key:"join",value:function(e){if(0===this.length)return"";for(var t=this.head,s=""+t.data;t=t.next;)s+=e+t.data;return s}},{key:"concat",value:function(e){if(0===this.length)return c.alloc(0);for(var t=c.allocUnsafe(e>>>0),s=this.head,r=0;s;)u(s.data,t,r),r+=s.data.length,s=s.next;return t}},{key:"consume",value:function(e,t){var s;return e<this.head.data.length?(s=this.head.data.slice(0,e),this.head.data=this.head.data.slice(e)):s=e===this.head.data.length?this.shift():t?this._getString(e):this._getBuffer(e),s}},{key:"first",value:function(){return this.head.data}},{key:"_getString",value:function(e){var t=this.head,s=1,r=t.data;for(e-=r.length;t=t.next;){var a=t.data,n=e>a.length?a.length:e;if(n===a.length?r+=a:r+=a.slice(0,e),0===(e-=n)){n===a.length?(++s,t.next?this.head=t.next:this.head=this.tail=null):(this.head=t,t.data=a.slice(n));break}++s}return this.length-=s,r}},{key:"_getBuffer",value:function(e){var t=c.allocUnsafe(e),s=this.head,r=1;for(s.data.copy(t),e-=s.data.length;s=s.next;){var a=s.data,n=e>a.length?a.length:e;if(a.copy(t,t.length-e,0,n),0===(e-=n)){n===a.length?(++r,s.next?this.head=s.next:this.head=this.tail=null):(this.head=s,s.data=a.slice(n));break}++r}return this.length-=r,t}},{key:d,value:function(e,t){return l(this,a(a({},t),{},{depth:0,customInspect:!1}))}}])&&i(t.prototype,s),r&&i(t,r),Object.defineProperty(t,"prototype",{writable:!1}),e}()}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/buffer_list.js"}],[2378,{_process:5024},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(e){(function(){function s(e,t){a(e,t),r(e)}function r(e){e._writableState&&!e._writableState.emitClose||e._readableState&&!e._readableState.emitClose||e.emit("close")}function a(e,t){e.emit("error",t)}t.exports={destroy:function(t,n){var i=this,o=this._readableState&&this._readableState.destroyed,c=this._writableState&&this._writableState.destroyed;return o||c?(n?n(t):t&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,e.nextTick(a,this,t)):e.nextTick(a,this,t)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(t||null,function(t){!n&&t?i._writableState?i._writableState.errorEmitted?e.nextTick(r,i):(i._writableState.errorEmitted=!0,e.nextTick(s,i,t)):e.nextTick(s,i,t):n?(e.nextTick(r,i),n(t)):e.nextTick(r,i)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)},errorOrDestroy:function(e,t){var s=e._readableState,r=e._writableState;s&&s.autoDestroy||r&&r.autoDestroy?e.destroy(t):e.emit("error",t)}}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/destroy.js"}],[2379,{"../../../errors":2370},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("../../../errors").codes.ERR_STREAM_PREMATURE_CLOSE;function a(){}t.exports=function e(t,s,n){if("function"==typeof s)return e(t,null,s);s||(s={}),n=function(e){var t=!1;return function(){if(!t){t=!0;for(var s=arguments.length,r=new Array(s),a=0;a<s;a++)r[a]=arguments[a];e.apply(this,r)}}}(n||a);var i=s.readable||!1!==s.readable&&t.readable,o=s.writable||!1!==s.writable&&t.writable,c=function(){t.writable||d()},l=t._writableState&&t._writableState.finished,d=function(){o=!1,l=!0,i||n.call(t)},u=t._readableState&&t._readableState.endEmitted,h=function(){i=!1,u=!0,o||n.call(t)},f=function(e){n.call(t,e)},m=function(){var e;return i&&!u?(t._readableState&&t._readableState.ended||(e=new r),n.call(t,e)):o&&!l?(t._writableState&&t._writableState.ended||(e=new r),n.call(t,e)):void 0},p=function(){t.req.on("finish",d)};return!function(e){return e.setHeader&&"function"==typeof e.abort}(t)?o&&!t._writableState&&(t.on("end",c),t.on("close",c)):(t.on("complete",d),t.on("abort",m),t.req?p():t.on("request",p)),t.on("end",h),t.on("finish",d),!1!==s.error&&t.on("error",f),t.on("close",m),function(){t.removeListener("complete",d),t.removeListener("abort",m),t.removeListener("request",p),t.req&&t.req.removeListener("finish",d),t.removeListener("end",c),t.removeListener("close",c),t.removeListener("finish",d),t.removeListener("end",h),t.removeListener("error",f),t.removeListener("close",m)}}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"}],[238,{"../../../../shared/constants/common":5713,"../../../../shared/constants/gas":5718,"../../../../shared/constants/metametrics":5725,"../../../../shared/constants/network":5729,"../../../../shared/constants/smartTransactions":5740,"../../../../shared/constants/swaps":5745,"../../../../shared/constants/time":5747,"../../../../shared/lib/fetch-with-cache":5804,"../../../../shared/lib/sentry":5823,"../../../../shared/lib/swaps-utils":5827,"../../../../shared/lib/transactions-controller-utils":5832,"../../../../shared/modules/Numeric":5839,"../../../../shared/modules/conversion.utils":5844,"../../../../shared/modules/string-utils":5876,"../../../../shared/modules/swaps.utils":5877,"./swaps.constants":239,"./swaps.utils":240,"@ethersproject/contracts":730,"@ethersproject/providers":768,"@metamask/base-controller":1346,"bignumber.js":3907,"human-standard-token-abi":4541,lodash:4773},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var r=e("@ethersproject/contracts"),a=e("@ethersproject/providers"),n=e("@metamask/base-controller"),i=e("bignumber.js"),o=P(e("human-standard-token-abi")),c=e("lodash"),l=e("../../../../shared/lib/sentry"),d=e("../../../../shared/constants/common"),u=e("../../../../shared/constants/gas"),h=e("../../../../shared/constants/metametrics"),f=e("../../../../shared/constants/network"),m=e("../../../../shared/constants/smartTransactions"),p=e("../../../../shared/constants/swaps"),g=e("../../../../shared/constants/time"),b=P(e("../../../../shared/lib/fetch-with-cache")),w=e("../../../../shared/lib/swaps-utils"),y=e("../../../../shared/lib/transactions-controller-utils"),S=e("../../../../shared/modules/conversion.utils"),v=e("../../../../shared/modules/Numeric"),_=e("../../../../shared/modules/string-utils"),k=e("../../../../shared/modules/swaps.utils"),E=e("./swaps.constants"),T=e("./swaps.utils");function P(e){return e&&e.__esModule?e:{default:e}}function R(e,t,s){A(e,t),t.set(e,s)}function A(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function C(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function I(e,t){return e.get(O(e,t))}function M(e,t,s){return e.set(O(e,t),s),s}function O(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}const j={swapsState:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!0}};var N=new WeakMap,x=new WeakMap,D=new WeakMap,L=new WeakMap,$=new WeakMap,F=new WeakMap,U=new WeakSet;class B extends n.BaseController{constructor(e,t){var s,r,a;super({name:E.controllerName,metadata:j,messenger:e.messenger,state:{swapsState:{...(0,E.getDefaultSwapsControllerState)().swapsState,swapsFeatureFlags:(null==t||null===(s=t.swapsState)||void 0===s?void 0:s.swapsFeatureFlags)||{}}}}),A(r=this,a=U),a.add(r),C(this,"getBufferedGasLimit",void 0),C(this,"resetState",void 0),C(this,"trackMetaMetricsEvent",void 0),R(this,N,void 0),R(this,x,void 0),R(this,D,null),R(this,L,void 0),R(this,$,void 0),R(this,F,void 0),C(this,"_fetchTradesInfo",w.fetchTradesInfo),C(this,"__test__updateState",e=>{this.update(t=>({swapsState:{...t.swapsState,...e.swapsState}}))}),this.messenger.registerActionHandler("SwapsController:fetchAndSetQuotes",this.fetchAndSetQuotes.bind(this)),this.messenger.registerActionHandler("SwapsController:setSelectedQuoteAggId",this.setSelectedQuoteAggId.bind(this)),this.messenger.registerActionHandler("SwapsController:resetSwapsState",this.resetSwapsState.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsTokens",this.setSwapsTokens.bind(this)),this.messenger.registerActionHandler("SwapsController:clearSwapsQuotes",this.clearSwapsQuotes.bind(this)),this.messenger.registerActionHandler("SwapsController:setApproveTxId",this.setApproveTxId.bind(this)),this.messenger.registerActionHandler("SwapsController:setTradeTxId",this.setTradeTxId.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsTxGasPrice",this.setSwapsTxGasPrice.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsTxGasLimit",this.setSwapsTxGasLimit.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsTxMaxFeePerGas",this.setSwapsTxMaxFeePerGas.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsTxMaxFeePriorityPerGas",this.setSwapsTxMaxFeePriorityPerGas.bind(this)),this.messenger.registerActionHandler("SwapsController:safeRefetchQuotes",this.safeRefetchQuotes.bind(this)),this.messenger.registerActionHandler("SwapsController:stopPollingForQuotes",this.stopPollingForQuotes.bind(this)),this.messenger.registerActionHandler("SwapsController:setBackgroundSwapRouteState",this.setBackgroundSwapRouteState.bind(this)),this.messenger.registerActionHandler("SwapsController:resetPostFetchState",this.resetPostFetchState.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsErrorKey",this.setSwapsErrorKey.bind(this)),this.messenger.registerActionHandler("SwapsController:setInitialGasEstimate",this.setInitialGasEstimate.bind(this)),this.messenger.registerActionHandler("SwapsController:setCustomApproveTxData",this.setCustomApproveTxData.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsLiveness",this.setSwapsLiveness.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsFeatureFlags",this.setSwapsFeatureFlags.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsUserFeeLevel",this.setSwapsUserFeeLevel.bind(this)),this.messenger.registerActionHandler("SwapsController:setSwapsQuotesPollingLimitEnabled",this.setSwapsQuotesPollingLimitEnabled.bind(this)),this.getBufferedGasLimit=e.getBufferedGasLimit,this.trackMetaMetricsEvent=e.trackMetaMetricsEvent,this.resetState=()=>{this.update(e=>{e.swapsState={...(0,E.getDefaultSwapsControllerState)().swapsState,swapsFeatureFlags:null==e?void 0:e.swapsState.swapsFeatureFlags}})},M(L,this,e.getEIP1559GasFeeEstimates),M($,this,e.getLayer1GasFee),M(N,this,0),M(x,this,0),this._fetchTradesInfo=e.fetchTradesInfo||w.fetchTradesInfo}clearSwapsQuotes(){this.update(e=>{e.swapsState.quotes={},e.swapsState.selectedAggId=null,e.swapsState.topAggId=null})}async fetchAndSetQuotes(e,t,s=!1){var r;if(!e)return null;let a;a=(null===(r=I(F,this))||void 0===r?void 0:r.clientId)===t.networkClientId?I(F,this):O(U,this,W).call(this,t.networkClientId);const{quotesPollingLimitEnabled:n,saveFetchedQuotes:i}=this.state.swapsState;s||M(x,this,0),I(D,this)&&clearTimeout(I(D,this)),s||this.setSwapsErrorKey("");const o=I(N,this)+1;M(N,this,o),i||this._setSaveFetchedQuotes(!0);let[l]=await Promise.all([this._fetchTradesInfo(e,{chainId:a.chainId}),this._setSwapsNetworkConfig(a)]);const{saveFetchedQuotes:d}=this.state.swapsState;if(!d)return[{},null];l=(0,c.mapValues)(l,e=>({...e,sourceTokenInfo:null==t?void 0:t.sourceTokenInfo,destinationTokenInfo:null==t?void 0:t.destinationTokenInfo}));const u=a.chainId===f.CHAIN_IDS.OPTIMISM.toString(),h=a.chainId===f.CHAIN_IDS.BASE.toString();(u||h)&&Object.values(l).length>0&&await Promise.all(Object.values(l).map(async e=>{if(e.trade){const t=await I($,this).call(this,{transactionParams:e.trade,networkClientId:a.clientId});e.multiLayerL1TradeFeeTotal=t}return e}));const m=Date.now();let g=!1;if(!(0,k.isSwapsDefaultTokenAddress)(e.sourceToken,a.chainId)&&Object.values(l).length){const t=await this._getERC20Allowance(e.sourceToken,e.fromAddress,a),[r]=Object.values(l);if(g=r.approvalNeeded&&(t.eq(0)||t.lt(r.sourceAmount))&&"wrappedNative"!==r.aggregator,g){if(!s&&r.approvalNeeded){const{gasLimit:e}=await this._timedoutGasReturn(r.approvalNeeded,r.aggregator);l=(0,c.mapValues)(l,t=>t.approvalNeeded?{...t,approvalNeeded:{...t.approvalNeeded,gas:e||p.DEFAULT_ERC20_APPROVE_GAS}}:t)}}else l=(0,c.mapValues)(l,e=>({...e,approvalNeeded:null}))}let b=null;if(g||null!=e&&e.balanceError||(l=await this._getAllQuotesWithGasEstimates(l)),0===Object.values(l).length)this.setSwapsErrorKey(p.QUOTES_NOT_AVAILABLE_ERROR);else{const e=await this.getTopQuoteWithCalculatedSavings({quotes:l});Array.isArray(e)&&(b=e[0],l=e[1])}if(I(N,this)!==o)throw new Error(p.SWAPS_FETCH_ORDER_CONFLICT);let{selectedAggId:w}=this.state.swapsState;return w&&l[w]||(w=null),this.update(s=>{s.swapsState.quotes=l,s.swapsState.fetchParams={...e,metaData:t},s.swapsState.quotesLastFetched=m,s.swapsState.selectedAggId=w,s.swapsState.topAggId=b}),n&&M(x,this,I(x,this)+1),!n||I(x,this)<E.POLL_COUNT_LIMIT+1?(this._pollForNewQuotes(),[l,b]):(this.resetPostFetchState(),this.setSwapsErrorKey(p.QUOTES_EXPIRED_ERROR),null)}async getTopQuoteWithCalculatedSavings({quotes:e,networkClientId:t}){var s;let r;if(t){const e=this.messenger.call("NetworkController:getNetworkClientById",t);r=e.configuration.chainId}else{if(I(F,this)===undefined)throw new Error("There is no network set");r=I(F,this).chainId}const{marketData:a}=this._getTokenRatesState(),n=(null==a?void 0:a[r])??{},{customGasPrice:o,customMaxPriorityFeePerGas:l}=this.state.swapsState;if(0===Object.keys(e).length)return{};const h=(0,c.cloneDeep)(e),{gasFeeEstimates:f,gasEstimateType:m}=await I(L,this).call(this,{networkClientId:t});let p="0x0";if(m===u.GasEstimateTypes.feeMarket){const{high:{suggestedMaxPriorityFeePerGas:e},estimatedBaseFee:t}=f,s=(0,S.decGWEIToHexWEI)(Number(e)),r=new v.Numeric(t,10,d.EtherDenomination.GWEI).toDenomination(d.EtherDenomination.WEI);p=new v.Numeric(l||s,16).add(r).round(6).toString()}else m===u.GasEstimateTypes.legacy?p=o||(0,S.decGWEIToHexWEI)(Number(f.high)):m===u.GasEstimateTypes.ethGasPrice&&(p=o||(0,S.decGWEIToHexWEI)(Number(f.gasPrice)));let g,b="";Object.values(h).forEach(e=>{const{aggregator:t,approvalNeeded:s,averageGas:a,destinationAmount:o,destinationToken:c,destinationTokenInfo:l,gasEstimateWithRefund:u,sourceAmount:h,sourceToken:f,trade:m,fee:w,multiLayerL1TradeFeeTotal:T}=e;if(!m||!c)return;const P=(u?new i.BigNumber(u,16):new i.BigNumber(a||E.MAX_GAS_LIMIT,10)).plus((null==s?void 0:s.gas)||"0x0",16).toString(16);let R=(0,y.calcGasTotal)(P,p);null!==T&&(R=(0,S.sumHexes)(R||"0x0",T||"0x0"));const A=new v.Numeric(R,16,d.EtherDenomination.WEI).add(new v.Numeric(m.value,16,d.EtherDenomination.WEI)),C=A.toDenomination(d.EtherDenomination.ETH).round(6).value,I=(0,k.isSwapsDefaultTokenAddress)(f,r)?A.minus(new v.Numeric(h,10)).toDenomination(d.EtherDenomination.ETH).round(6).value:C,M=(0,y.calcTokenAmount)(o??"0",l.decimals),O=new i.BigNumber(100,10).minus(w,10).div(100),j=M.div(O).minus(M),N=Object.keys(n).find(e=>(0,_.isEqualCaseInsensitive)(e,c)),x=N?n[N]:null,D=(null==x?void 0:x.price)||1,L=M.times(D.toString(10),10),$=(0,k.isSwapsDefaultTokenAddress)(c,r)?1:null==x?void 0:x.price,F=$?L.minus(I,10):L;e.ethFee=I.toString(10),$&&(e.ethValueOfTokens=L.toString(10),e.overallValueOfQuote=F.toString(10),e.metaMaskFeeInEth=j.times($.toString(10)).toString(10)),g&&!F.gt(g||0)||(b=t,g=F)});const w=Object.keys(n).find(e=>{var t;return(0,_.isEqualCaseInsensitive)(e,null===(t=h[b])||void 0===t?void 0:t.destinationToken)}),P=w?n[w]:null;if((0,k.isSwapsDefaultTokenAddress)(null===(s=h[b])||void 0===s?void 0:s.destinationToken,r)||Boolean(null==P?void 0:P.price)){const e=h[b],{ethFee:t,metaMaskFeeInEth:s,ethValueOfTokens:r}=(0,T.getMedianEthValueQuote)(Object.values(h)),a=new i.BigNumber(e.ethValueOfTokens,10).minus(r,10).toString(10),n=new i.BigNumber(t).minus(e.ethFee,10).toString(10),o=e.metaMaskFeeInEth,c={performance:a,fee:n,total:new i.BigNumber(a).plus(n).minus(o).toString(10),metaMaskFee:o,medianMetaMaskFee:s};h[b].isBestQuote=!0,h[b].savings=c}return[b,h]}resetPostFetchState(){this.update(e=>{e.swapsState={...(0,E.getDefaultSwapsControllerState)().swapsState,tokens:e.swapsState.tokens,fetchParams:e.swapsState.fetchParams,swapsFeatureIsLive:e.swapsState.swapsFeatureIsLive,swapsQuoteRefreshTime:e.swapsState.swapsQuoteRefreshTime,swapsQuotePrefetchingRefreshTime:e.swapsState.swapsQuotePrefetchingRefreshTime,swapsFeatureFlags:e.swapsState.swapsFeatureFlags}}),I(D,this)&&clearTimeout(I(D,this))}resetSwapsState(){this.update(e=>{e.swapsState={...(0,E.getDefaultSwapsControllerState)().swapsState,swapsQuoteRefreshTime:e.swapsState.swapsQuoteRefreshTime,swapsQuotePrefetchingRefreshTime:e.swapsState.swapsQuotePrefetchingRefreshTime,swapsFeatureFlags:e.swapsState.swapsFeatureFlags}}),I(D,this)&&clearTimeout(I(D,this))}safeRefetchQuotes(){!I(D,this)&&this.state.swapsState.fetchParams&&this.fetchAndSetQuotes(this.state.swapsState.fetchParams,{...this.state.swapsState.fetchParams.metaData})}setApproveTxId(e){this.update(t=>{t.swapsState.approveTxId=e})}setBackgroundSwapRouteState(e){this.update(t=>{t.swapsState.routeState=e})}setCustomApproveTxData(e){this.update(t=>{t.swapsState.customApproveTxData=e})}async setInitialGasEstimate(e){const t={...this.state.swapsState.quotes[e]},{gasLimit:s,simulationFails:r}=t.trade?await this._timedoutGasReturn(t.trade,t.aggregator):{gasLimit:null,simulationFails:!0};if(s&&!r){const e=(0,T.calculateGasEstimateWithRefund)(t.maxGas,t.estimatedRefund,s);t.gasEstimate=s,t.gasEstimateWithRefund=e}this.update(s=>{s.swapsState.quotes={...s.swapsState.quotes,[e]:t}})}setSelectedQuoteAggId(e){this.update(t=>{t.swapsState.selectedAggId=e})}setSwapsFeatureFlags(e){this.update(t=>{t.swapsState.swapsFeatureFlags=e})}setSwapsErrorKey(e){this.update(t=>{t.swapsState.errorKey=e})}setSwapsLiveness(e){const{swapsFeatureIsLive:t}=e;this.update(e=>{e.swapsState.swapsFeatureIsLive=t})}setSwapsQuotesPollingLimitEnabled(e){this.update(t=>{t.swapsState.quotesPollingLimitEnabled=e})}setSwapsTokens(e){this.update(t=>{t.swapsState.tokens=e})}setSwapsTxGasLimit(e){this.update(t=>{t.swapsState.customMaxGas=e})}setSwapsTxGasPrice(e){this.update(t=>{t.swapsState.customGasPrice=e})}setSwapsTxMaxFeePerGas(e){this.update(t=>{t.swapsState.customMaxFeePerGas=e})}setSwapsTxMaxFeePriorityPerGas(e){this.update(t=>{t.swapsState.customMaxPriorityFeePerGas=e})}setSwapsUserFeeLevel(e){this.update(t=>{t.swapsState.swapsUserFeeLevel=e})}setTradeTxId(e){this.update(t=>{t.swapsState.tradeTxId=e})}stopPollingForQuotes(){I(D,this)&&clearTimeout(I(D,this))}async _fetchSwapsNetworkConfig(e){const t=await(0,b.default)({url:(0,w.getBaseApi)("network",e.chainId),fetchOptions:{method:"GET"},cacheOptions:{cacheRefreshTime:6e5},functionName:"_fetchSwapsNetworkConfig"}),{refreshRates:s,parameters:r={}}=t||{};if(!s||"number"!=typeof s.quotes||"number"!=typeof s.quotesPrefetching)throw new Error(`MetaMask - invalid response for refreshRates: ${t}`);return{quotes:1e3*s.quotes,quotesPrefetching:1e3*s.quotesPrefetching,stxGetTransactions:1e3*s.stxGetTransactions,stxBatchStatus:1e3*s.stxBatchStatus,stxStatusDeadline:s.stxStatusDeadline,stxMaxFeeMultiplier:r.stxMaxFeeMultiplier}}async _getAllQuotesWithGasEstimates(e){const t=await Promise.all(Object.values(e).map(async e=>{if(!e.trade)return{gasLimit:null,simulationFails:!0,aggId:e.aggregator};const{gasLimit:t,simulationFails:s}=await this._timedoutGasReturn(e.trade,e.aggregator);return{gasLimit:t,simulationFails:s,aggId:e.aggregator}})),s={};return t.forEach(({gasLimit:t,simulationFails:r,aggId:a})=>{if(t&&!r){const r=(0,T.calculateGasEstimateWithRefund)(e[a].maxGas,e[a].estimatedRefund,t);s[a]={...e[a],gasEstimate:t,gasEstimateWithRefund:r}}else e[a].approvalNeeded&&(s[a]=e[a])}),s}async _getERC20Allowance(e,t,s){const a=new r.Contract(e,o.default,s.ethersProvider);return await a.allowance(t,p.SWAPS_CHAINID_CONTRACT_ADDRESS_MAP[s.chainId])}_getTokenRatesState(){const{marketData:e}=this.messenger.call("TokenRatesController:getState");return{marketData:e}}_pollForNewQuotes(){const{swapsQuoteRefreshTime:e,swapsQuotePrefetchingRefreshTime:t,quotesPollingLimitEnabled:s}=this.state.swapsState;M(D,this,setTimeout(()=>{var e;this.fetchAndSetQuotes(this.state.swapsState.fetchParams,null===(e=this.state.swapsState.fetchParams)||void 0===e?void 0:e.metaData,!0)},s?e:t))}_setSaveFetchedQuotes(e){this.update(t=>{t.swapsState.saveFetchedQuotes=e})}async _setSwapsNetworkConfig(e){let t=null;try{t=await this._fetchSwapsNetworkConfig(e)}catch(e){console.error("Request for Swaps network config failed: ",e)}this.update(e=>{var s,r,a,n,i,o;e.swapsState.swapsQuoteRefreshTime=(null===(s=t)||void 0===s?void 0:s.quotes)||E.FALLBACK_QUOTE_REFRESH_TIME,e.swapsState.swapsQuotePrefetchingRefreshTime=(null===(r=t)||void 0===r?void 0:r.quotesPrefetching)||E.FALLBACK_QUOTE_REFRESH_TIME,e.swapsState.swapsStxGetTransactionsRefreshTime=(null===(a=t)||void 0===a?void 0:a.stxGetTransactions)||m.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,e.swapsState.swapsStxBatchStatusRefreshTime=(null===(n=t)||void 0===n?void 0:n.stxBatchStatus)||m.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,e.swapsState.swapsStxMaxFeeMultiplier=(null===(i=t)||void 0===i?void 0:i.stxMaxFeeMultiplier)||m.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER,e.swapsState.swapsStxStatusDeadline=(null===(o=t)||void 0===o?void 0:o.stxStatusDeadline)||m.FALLBACK_SMART_TRANSACTIONS_DEADLINE})}_timedoutGasReturn(e,t=""){return new Promise(s=>{let r=!1;const a=setTimeout(()=>{r=!0,this.trackMetaMetricsEvent({event:h.MetaMetricsEventName.QuoteError,category:h.MetaMetricsEventCategory.Swaps,properties:{error_type:h.MetaMetricsEventErrorType.GasTimeout,aggregator:t}}),s({gasLimit:null,simulationFails:!0})},5*g.SECOND),n={data:e.data,from:e.from,to:e.to,value:e.value};this.getBufferedGasLimit({txParams:n},1).then(({gasLimit:e,simulationFails:t})=>{r||(clearTimeout(a),s({gasLimit:e,simulationFails:t}))}).catch(e=>{(0,l.captureException)(e,{extra:{aggregator:t}}),r||(clearTimeout(a),s({gasLimit:null,simulationFails:!0}))})})}}function W(e){const t=this.messenger.call("NetworkController:getNetworkClientById",e),{chainId:s}=t.configuration,r={client:t,clientId:e,chainId:s,ethersProvider:new a.Web3Provider(t.provider)};return M(F,this,r),r}s.default=B}}},{package:"$root$",file:"app/scripts/controllers/swaps/index.ts"}],[2380,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=function(){throw new Error("Readable.from is not available in the browser")}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/from-browser.js"}],[2381,{"../../../errors":2370,"./end-of-stream":2379},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r;var a=e("../../../errors").codes,n=a.ERR_MISSING_ARGS,i=a.ERR_STREAM_DESTROYED;function o(e){if(e)throw e}function c(e){e()}function l(e,t){return e.pipe(t)}t.exports=function(){for(var t=arguments.length,s=new Array(t),a=0;a<t;a++)s[a]=arguments[a];var d,u=function(e){return e.length?"function"!=typeof e[e.length-1]?o:e.pop():o}(s);if(Array.isArray(s[0])&&(s=s[0]),s.length<2)throw new n("streams");var h=s.map(function(t,a){var n=a<s.length-1;return function(t,s,a,n){n=function(e){var t=!1;return function(){t||(t=!0,e.apply(void 0,arguments))}}(n);var o=!1;t.on("close",function(){o=!0}),r===undefined&&(r=e("./end-of-stream")),r(t,{readable:s,writable:a},function(e){if(e)return n(e);o=!0,n()});var c=!1;return function(e){if(!o&&!c)return c=!0,function(e){return e.setHeader&&"function"==typeof e.abort}(t)?t.abort():"function"==typeof t.destroy?t.destroy():void n(e||new i("pipe"))}}(t,n,a>0,function(e){d||(d=e),e&&h.forEach(c),n||(h.forEach(c),u(d))})});return s.reduce(l)}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/pipeline.js"}],[2382,{"../../../errors":2370},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("../../../errors").codes.ERR_INVALID_OPT_VALUE;t.exports={getHighWaterMark:function(e,t,s,a){var n=function(e,t,s){return null!=e.highWaterMark?e.highWaterMark:t?e[s]:null}(t,a,s);if(null!=n){if(!isFinite(n)||Math.floor(n)!==n||n<0)throw new r(a?s:"highWaterMark",n);return Math.floor(n)}return e.objectMode?16:16384}}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/state.js"}],[2383,{events:4319},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=e("events").EventEmitter}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/stream-browser.js"}],[2384,{"./lib/_stream_duplex.js":2371,"./lib/_stream_passthrough.js":2372,"./lib/_stream_readable.js":2373,"./lib/_stream_transform.js":2374,"./lib/_stream_writable.js":2375,"./lib/internal/streams/end-of-stream.js":2379,"./lib/internal/streams/pipeline.js":2381},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(s=t.exports=e("./lib/_stream_readable.js")).Stream=s,s.Readable=s,s.Writable=e("./lib/_stream_writable.js"),s.Duplex=e("./lib/_stream_duplex.js"),s.Transform=e("./lib/_stream_transform.js"),s.PassThrough=e("./lib/_stream_passthrough.js"),s.finished=e("./lib/internal/streams/end-of-stream.js"),s.pipeline=e("./lib/internal/streams/pipeline.js")}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/readable-browser.js"}],[239,{"../../../../shared/constants/smartTransactions":5740,"../../../../shared/constants/time":5747},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.controllerName=s.POLL_COUNT_LIMIT=s.MAX_GAS_LIMIT=s.FALLBACK_QUOTE_REFRESH_TIME=void 0,s.getDefaultSwapsControllerState=function(){return{swapsState:{quotes:{},quotesPollingLimitEnabled:!1,fetchParams:null,tokens:null,tradeTxId:null,approveTxId:null,quotesLastFetched:null,customMaxGas:"",customGasPrice:null,customMaxFeePerGas:null,customMaxPriorityFeePerGas:null,swapsUserFeeLevel:"",selectedAggId:null,customApproveTxData:"",errorKey:"",topAggId:null,routeState:"",swapsFeatureIsLive:!0,saveFetchedQuotes:!1,swapsQuoteRefreshTime:n,swapsQuotePrefetchingRefreshTime:n,swapsStxBatchStatusRefreshTime:r.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,swapsStxStatusDeadline:r.FALLBACK_SMART_TRANSACTIONS_DEADLINE,swapsStxGetTransactionsRefreshTime:r.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,swapsStxMaxFeeMultiplier:r.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER,swapsFeatureFlags:{}}}};var r=e("../../../../shared/constants/smartTransactions"),a=e("../../../../shared/constants/time");s.controllerName="SwapsController",s.MAX_GAS_LIMIT=25e5,s.POLL_COUNT_LIMIT=3;const n=s.FALLBACK_QUOTE_REFRESH_TIME=a.MINUTE}}},{package:"$root$",file:"app/scripts/controllers/swaps/swaps.constants.ts"}],[2397,{"./enums.cjs":2398,"@metamask/base-controller":1346,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},f=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PermissionLogController=void 0;const m=e("@metamask/base-controller"),p=e("@metamask/utils"),g=e("./enums.cjs"),b={permissionHistory:{},permissionActivityLog:[]};class w extends m.BaseController{constructor({messenger:e,restrictedMethods:t,state:s}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},permissionActivityLog:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!1}},state:{...b,...s}}),r.add(this),a.set(this,void 0),h(this,a,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const s={eth_accounts:{accounts:f(this,r,"m",n).call(this,t,Date.now())}};f(this,r,"m",l).call(this,e,s)}createMiddleware(){return(e,t,s)=>{const{origin:n,method:l}=e,u=l.startsWith(g.WALLET_PREFIX),h="eth_requestAccounts"===l;if(!g.LOG_IGNORE_METHODS.includes(l)&&(u||f(this,a,"f").has(l))||h){const a=f(this,r,"m",i).call(this,e,u),l=f(this,r,"m",d).call(this,e);return void s(e=>{const s=Date.now();f(this,r,"m",o).call(this,a,t,s),l&&!t.error&&t.result&&n&&f(this,r,"m",c).call(this,l,n,t.result,s,h),e()})}s()}}}s.PermissionLogController=w,a=new WeakMap,r=new WeakSet,n=function(e,t){return e.reduce((e,s)=>({...e,[s]:t}),{})},i=function(e,t){const s={id:e.id,method:e.method,methodType:t?g.LOG_METHOD_TYPES.internal:g.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update(e=>{const t=[...e.permissionActivityLog,s];e.permissionActivityLog=t.length>g.LOG_LIMIT?t.slice(1):t}),s},o=function(e,t,s){e&&t&&this.update(r=>{r.permissionActivityLog=r.permissionActivityLog.map(r=>r.id===e.id?{...r,success:(0,p.hasProperty)(t,"result"),responseTime:s}:r)})},c=function(e,t,s,a,i){let o;if(i){const e=s;o={eth_accounts:{accounts:f(this,r,"m",n).call(this,e,a),lastApproved:a}}}else{o=s.reduce((t,s)=>{const i=s.parentCapability;if(!e.includes(i))return t;if("eth_accounts"===i){const e=f(this,r,"m",u).call(this,s);return{...t,[i]:{lastApproved:a,accounts:f(this,r,"m",n).call(this,e,a)}}}return{...t,[i]:{lastApproved:a}}},{})}Object.keys(o).length>0&&f(this,r,"m",l).call(this,t,o)},l=function(e,t){const{permissionHistory:s}=this.state,r=s[e]??{},a={...r,...t},n=r.eth_accounts,i=t.eth_accounts;if(n&&i){const e=i.lastApproved??n.lastApproved;a.eth_accounts={lastApproved:e,accounts:{...n.accounts,...i.accounts}}}this.update(t=>{t.permissionHistory={...s,[e]:a}})},d=function(e){const{method:t,params:s}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${g.WALLET_PREFIX}requestPermissions`&&s&&Array.isArray(s)&&s[0]&&"object"==typeof s[0]&&!Array.isArray(s[0])?Object.keys(s[0]):null},u=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const s of e.caveats)if(s.type===g.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(s.value))for(const e of s.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],[2398,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r;Object.defineProperty(s,"__esModule",{value:!0}),s.LOG_LIMIT=s.LOG_METHOD_TYPES=s.LOG_IGNORE_METHODS=s.CAVEAT_TYPES=s.WALLET_PREFIX=void 0,s.WALLET_PREFIX="wallet_",s.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),s.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(r||(s.LOG_METHOD_TYPES=r={})),s.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],[2399,{"./PermissionLogController.cjs":2397},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.PermissionLogController=void 0;var r=e("./PermissionLogController.cjs");Object.defineProperty(s,"PermissionLogController",{enumerable:!0,get:function(){return r.PermissionLogController}})}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],[24,{"@metamask/assets-controllers":1276},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.NftDetectionControllerInit=void 0;var r=e("@metamask/assets-controllers");s.NftDetectionControllerInit=e=>{const{controllerMessenger:t,getController:s}=e,a=()=>s("NftController");return{controller:new r.NftDetectionController({messenger:t,addNfts:(...e)=>a().addNfts(...e),getNftState:()=>a().state,disabled:!s("PreferencesController").state.useNftDetection}),persistedStateKey:null}}}}},{package:"$root$",file:"app/scripts/controller-init/assets/nft-detection-controller-init.ts"}],[240,{"./swaps.constants":239,"bignumber.js":3907},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.calculateGasEstimateWithRefund=function(e=a.MAX_GAS_LIMIT,t="0",s="0"){const n=new r.BigNumber(e,10).minus(t,10),i=n.lt(0);return!i&&n.lt(s,16)?`0x${n.toString(16)}`:s},s.getMedianEthValueQuote=function(e){if(!Array.isArray(e)||0===e.length)throw new Error("Expected non-empty array param.");const t=[...e];if(t.sort((e,t)=>{const s=new r.BigNumber(e.overallValueOfQuote,10),a=new r.BigNumber(t.overallValueOfQuote,10);return s.equals(a)?0:s.lessThan(a)?-1:1}),t.length%2==1){const e=t[(t.length-1)/2].overallValueOfQuote;return n(t.filter(t=>e===t.overallValueOfQuote))}const s=t.length/2,a=s-1,i=t[s].overallValueOfQuote,o=t[a].overallValueOfQuote,c=t.filter(e=>i===e.overallValueOfQuote),l=t.filter(e=>o===e.overallValueOfQuote),d=n(c),u=n(l);return{ethFee:new r.BigNumber(d.ethFee,10).plus(u.ethFee,10).dividedBy(2).toString(10),metaMaskFeeInEth:new r.BigNumber(d.metaMaskFeeInEth,10).plus(u.metaMaskFeeInEth,10).dividedBy(2).toString(10),ethValueOfTokens:new r.BigNumber(d.ethValueOfTokens,10).plus(u.ethValueOfTokens,10).dividedBy(2).toString(10)}},s.meansOfQuotesFeesAndValue=n;var r=e("bignumber.js"),a=e("./swaps.constants");function n(e){const t=e.reduce((e,t)=>({ethFee:e.ethFee.plus(t.ethFee,10),metaMaskFeeInEth:e.metaMaskFeeInEth.plus(t.metaMaskFeeInEth,10),ethValueOfTokens:e.ethValueOfTokens.plus(t.ethValueOfTokens,10)}),{ethFee:new r.BigNumber(0,10),metaMaskFeeInEth:new r.BigNumber(0,10),ethValueOfTokens:new r.BigNumber(0,10)});return{ethFee:t.ethFee.div(e.length,10).toString(10),metaMaskFeeInEth:t.metaMaskFeeInEth.div(e.length,10).toString(10),ethValueOfTokens:t.ethValueOfTokens.div(e.length,10).toString(10)}}}}},{package:"$root$",file:"app/scripts/controllers/swaps/swaps.utils.ts"}],[241,{"../../shared/constants/app":5710,"./lib/util":358,"webextension-polyfill":5698},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.onMessageReceived=s.checkForMultipleVersionsRunning=void 0;var r,a=(r=e("webextension-polyfill"))&&r.__esModule?r:{default:r},n=e("../../shared/constants/app"),i=e("./lib/util");const o="isRunning";s.onMessageReceived=e=>{e===o&&console.warn("Warning! You have multiple instances of MetaMask running!")};s.checkForMultipleVersionsRunning=async()=>{if((0,i.getPlatform)()!==n.PLATFORM_CHROME&&(0,i.getPlatform)()!==n.PLATFORM_FIREFOX)return;const e=(0,i.getPlatform)()===n.PLATFORM_CHROME?n.CHROME_BUILD_IDS:n.FIREFOX_BUILD_IDS,t=a.default.runtime.id;for(const s of e)if(s!==t)try{await a.default.runtime.sendMessage(s,o)}catch(e){}}}}},{package:"$root$",file:"app/scripts/detect-multiple-instances.js"}],[2411,{"readable-stream":2432},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BasePostMessageStream=void 0;const r=e("readable-stream"),a=()=>undefined,n="SYN",i="ACK";class o extends r.Duplex{constructor(e){super(Object.assign({objectMode:!0},e)),this._init=!1,this._haveSyn=!1,this._log=()=>null}_handshake(){this._write(n,null,a),this.cork()}_onData(e){if(this._init)try{this.push(e),this._log(e,!1)}catch(e){this.emit("error",e)}else e===n?(this._haveSyn=!0,this._write(i,null,a)):e===i&&(this._init=!0,this._haveSyn||this._write(i,null,a),this.uncork())}_read(){return undefined}_write(e,t,s){e!==i&&e!==n&&this._log(e,!0),this._postMessage(e),s()}_setLogger(e){this._log=e}}s.BasePostMessageStream=o}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs"}],[2412,{"./BasePostMessageStream.cjs":2411,"./runtime/BrowserRuntimePostMessageStream.cjs":2413,"./utils.cjs":2414,"./web-worker/WebWorkerParentPostMessageStream.cjs":2415,"./web-worker/WebWorkerPostMessageStream.cjs":2416,"./window/WindowPostMessageStream.cjs":2417},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.isValidStreamMessage=void 0,a(e("./window/WindowPostMessageStream.cjs"),s),a(e("./web-worker/WebWorkerPostMessageStream.cjs"),s),a(e("./web-worker/WebWorkerParentPostMessageStream.cjs"),s),a(e("./runtime/BrowserRuntimePostMessageStream.cjs"),s),a(e("./BasePostMessageStream.cjs"),s);var n=e("./utils.cjs");Object.defineProperty(s,"isValidStreamMessage",{enumerable:!0,get:function(){return n.isValidStreamMessage}})}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/index.cjs"}],[2413,{"../BasePostMessageStream.cjs":2411,"../utils.cjs":2414},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},i=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},o=this&&this.__rest||function(e,t){var s={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(s[r]=e[r]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var a=0;for(r=Object.getOwnPropertySymbols(e);a<r.length;a++)t.indexOf(r[a])<0&&Object.prototype.propertyIsEnumerable.call(e,r[a])&&(s[r[a]]=e[r[a]])}return s};Object.defineProperty(s,"__esModule",{value:!0}),s.BrowserRuntimePostMessageStream=void 0;const c=e("../BasePostMessageStream.cjs"),l=e("../utils.cjs");class d extends c.BasePostMessageStream{constructor(e){var{name:t,target:s}=e;super(o(e,["name","target"])),r.set(this,void 0),a.set(this,void 0),n(this,r,t,"f"),n(this,a,s,"f"),this._onMessage=this._onMessage.bind(this),this._getRuntime().onMessage.addListener(this._onMessage),this._handshake()}_postMessage(e){this._getRuntime().sendMessage({target:i(this,a,"f"),data:e})}_onMessage(e){(0,l.isValidStreamMessage)(e)&&e.target===i(this,r,"f")&&this._onData(e.data)}_getRuntime(){var e,t;if("chrome"in globalThis&&"function"==typeof(null===(e=null===chrome||void 0===chrome?void 0:chrome.runtime)||void 0===e?void 0:e.sendMessage))return chrome.runtime;if("browser"in globalThis&&"function"==typeof(null===(t=null===browser||void 0===browser?void 0:browser.runtime)||void 0===t?void 0:t.sendMessage))return browser.runtime;throw new Error("browser.runtime.sendMessage is not a function. This class should only be instantiated in a web extension.")}_destroy(){this._getRuntime().onMessage.removeListener(this._onMessage)}}s.BrowserRuntimePostMessageStream=d,r=new WeakMap,a=new WeakMap}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/runtime/BrowserRuntimePostMessageStream.cjs"}],[2414,{"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isValidStreamMessage=s.DEDICATED_WORKER_NAME=void 0;const r=e("@metamask/utils");s.DEDICATED_WORKER_NAME="dedicatedWorker",s.isValidStreamMessage=function(e){return(0,r.isObject)(e)&&Boolean(e.data)&&("number"==typeof e.data||"object"==typeof e.data||"string"==typeof e.data)}}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/utils.cjs"}],[2415,{"../BasePostMessageStream.cjs":2411,"../utils.cjs":2414},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__rest||function(e,t){var s={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(s[r]=e[r]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var a=0;for(r=Object.getOwnPropertySymbols(e);a<r.length;a++)t.indexOf(r[a])<0&&Object.prototype.propertyIsEnumerable.call(e,r[a])&&(s[r[a]]=e[r[a]])}return s};Object.defineProperty(s,"__esModule",{value:!0}),s.WebWorkerParentPostMessageStream=void 0;const a=e("../BasePostMessageStream.cjs"),n=e("../utils.cjs");class i extends a.BasePostMessageStream{constructor(e){var{worker:t}=e;super(r(e,["worker"])),this._target=n.DEDICATED_WORKER_NAME,this._worker=t,this._worker.onmessage=this._onMessage.bind(this),this._handshake()}_postMessage(e){this._worker.postMessage({target:this._target,data:e})}_onMessage(e){const t=e.data;(0,n.isValidStreamMessage)(t)&&this._onData(t.data)}_destroy(){this._worker.onmessage=null,this._worker=null}}s.WebWorkerParentPostMessageStream=i}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerParentPostMessageStream.cjs"}],[2416,{"../BasePostMessageStream.cjs":2411,"../utils.cjs":2414},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.WebWorkerPostMessageStream=void 0;const r=e("../BasePostMessageStream.cjs"),a=e("../utils.cjs");class n extends r.BasePostMessageStream{constructor(e={}){if("undefined"==typeof self||"undefined"==typeof WorkerGlobalScope)throw new Error("WorkerGlobalScope not found. This class should only be instantiated in a WebWorker.");super(e),this._name=a.DEDICATED_WORKER_NAME,self.addEventListener("message",this._onMessage.bind(this)),this._handshake()}_postMessage(e){self.postMessage({data:e})}_onMessage(e){const t=e.data;(0,a.isValidStreamMessage)(t)&&t.target===this._name&&this._onData(t.data)}_destroy(){return undefined}}s.WebWorkerPostMessageStream=n}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerPostMessageStream.cjs"}],[2417,{"../BasePostMessageStream.cjs":2411,"../utils.cjs":2414,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n=this&&this.__rest||function(e,t){var s={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(s[r]=e[r]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var a=0;for(r=Object.getOwnPropertySymbols(e);a<r.length;a++)t.indexOf(r[a])<0&&Object.prototype.propertyIsEnumerable.call(e,r[a])&&(s[r[a]]=e[r[a]])}return s};Object.defineProperty(s,"__esModule",{value:!0}),s.WindowPostMessageStream=void 0;const i=e("@metamask/utils"),o=e("../BasePostMessageStream.cjs"),c=e("../utils.cjs"),l=null===(r=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"source"))||void 0===r?void 0:r.get;(0,i.assert)(l,"MessageEvent.prototype.source getter is not defined.");const d=null===(a=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"origin"))||void 0===a?void 0:a.get;(0,i.assert)(d,"MessageEvent.prototype.origin getter is not defined.");class u extends o.BasePostMessageStream{constructor(e){var{name:t,target:s,targetOrigin:r=location.origin,targetWindow:a=window}=e;if(super(n(e,["name","target","targetOrigin","targetWindow"])),"undefined"==typeof window||"function"!=typeof window.postMessage)throw new Error("window.postMessage is not a function. This class should only be instantiated in a Window.");this._name=t,this._target=s,this._targetOrigin=r,this._targetWindow=a,this._onMessage=this._onMessage.bind(this),window.addEventListener("message",this._onMessage,!1),this._handshake()}_postMessage(e){this._targetWindow.postMessage({target:this._target,data:e},this._targetOrigin)}_onMessage(e){const t=e.data;"*"!==this._targetOrigin&&d.call(e)!==this._targetOrigin||l.call(e)!==this._targetWindow||!(0,c.isValidStreamMessage)(t)||t.target!==this._name||this._onData(t.data)}_destroy(){window.removeEventListener("message",this._onMessage,!1)}}s.WindowPostMessageStream=u}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/window/WindowPostMessageStream.cjs"}],[2418,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r={};function a(e,t,s){s||(s=Error);var a=function(e){var s,r;function a(s,r,a){return e.call(this,function(e,s,r){return"string"==typeof t?t:t(e,s,r)}(s,r,a))||this}return r=e,(s=a).prototype=Object.create(r.prototype),s.prototype.constructor=s,s.__proto__=r,a}(s);a.prototype.name=s.name,a.prototype.code=e,r[e]=a}function n(e,t){if(Array.isArray(e)){var s=e.length;return e=e.map(function(e){return String(e)}),s>2?"one of ".concat(t," ").concat(e.slice(0,s-1).join(", "),", or ")+e[s-1]:2===s?"one of ".concat(t," ").concat(e[0]," or ").concat(e[1]):"of ".concat(t," ").concat(e[0])}return"of ".concat(t," ").concat(String(e))}a("ERR_INVALID_OPT_VALUE",function(e,t){return'The value "'+t+'" is invalid for option "'+e+'"'},TypeError),a("ERR_INVALID_ARG_TYPE",function(e,t,s){var r,a,i,o;if("string"==typeof t&&(a="not ",t.substr(!i||i<0?0:+i,a.length)===a)?(r="must not be",t=t.replace(/^not /,"")):r="must be",function(e,t,s){return(s===undefined||s>e.length)&&(s=e.length),e.substring(s-t.length,s)===t}(e," argument"))o="The ".concat(e," ").concat(r," ").concat(n(t,"type"));else{var c=function(e,t,s){return"number"!=typeof s&&(s=0),!(s+t.length>e.length)&&-1!==e.indexOf(t,s)}(e,".")?"property":"argument";o='The "'.concat(e,'" ').concat(c," ").concat(r," ").concat(n(t,"type"))}return o+=". Received type ".concat(typeof s)},TypeError),a("ERR_STREAM_PUSH_AFTER_EOF","stream.push() after EOF"),a("ERR_METHOD_NOT_IMPLEMENTED",function(e){return"The "+e+" method is not implemented"}),a("ERR_STREAM_PREMATURE_CLOSE","Premature close"),a("ERR_STREAM_DESTROYED",function(e){return"Cannot call "+e+" after a stream was destroyed"}),a("ERR_MULTIPLE_CALLBACK","Callback called multiple times"),a("ERR_STREAM_CANNOT_PIPE","Cannot pipe, not readable"),a("ERR_STREAM_WRITE_AFTER_END","write after end"),a("ERR_STREAM_NULL_VALUES","May not write null values to stream",TypeError),a("ERR_UNKNOWN_ENCODING",function(e){return"Unknown encoding: "+e},TypeError),a("ERR_STREAM_UNSHIFT_AFTER_END_EVENT","stream.unshift() after end event"),t.exports.codes=r}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/errors-browser.js"}],[2419,{"./_stream_readable":2421,"./_stream_writable":2423,_process:5024,inherits:4552},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var r=Object.keys||function(e){var t=[];for(var s in e)t.push(s);return t};t.exports=l;var a=e("./_stream_readable"),n=e("./_stream_writable");e("inherits")(l,a);for(var i=r(n.prototype),o=0;o<i.length;o++){var c=i[o];l.prototype[c]||(l.prototype[c]=n.prototype[c])}function l(e){if(!(this instanceof l))return new l(e);a.call(this,e),n.call(this,e),this.allowHalfOpen=!0,e&&(!1===e.readable&&(this.readable=!1),!1===e.writable&&(this.writable=!1),!1===e.allowHalfOpen&&(this.allowHalfOpen=!1,this.once("end",d)))}function d(){this._writableState.ended||s.nextTick(u,this)}function u(e){e.end()}Object.defineProperty(l.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(l.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(l.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(l.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed&&this._writableState.destroyed)},set:function(e){this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/_stream_duplex.js"}],[242,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;s.default={config:{}}}}},{package:"$root$",file:"app/scripts/first-time-state.js"}],[2420,{"./_stream_transform":2422,inherits:4552},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=a;var r=e("./_stream_transform");function a(e){if(!(this instanceof a))return new a(e);r.call(this,e)}e("inherits")(a,r),a.prototype._transform=function(e,t,s){s(null,e)}}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/_stream_passthrough.js"}],[2421,{"../errors":2418,"./_stream_duplex":2419,"./internal/streams/async_iterator":2424,"./internal/streams/buffer_list":2425,"./internal/streams/destroy":2426,"./internal/streams/from":2428,"./internal/streams/state":2430,"./internal/streams/stream":2431,_process:5024,buffer:4019,events:4319,inherits:4552,"string_decoder/":5600,util:3971},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var r;t.exports=E,E.ReadableState=k;e("events").EventEmitter;var a=function(e,t){return e.listeners(t).length},n=e("./internal/streams/stream"),i=e("buffer").Buffer,o=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var c,l=e("util");c=l&&l.debuglog?l.debuglog("stream"):function(){};var d,u,h,f=e("./internal/streams/buffer_list"),m=e("./internal/streams/destroy"),p=e("./internal/streams/state").getHighWaterMark,g=e("../errors").codes,b=g.ERR_INVALID_ARG_TYPE,w=g.ERR_STREAM_PUSH_AFTER_EOF,y=g.ERR_METHOD_NOT_IMPLEMENTED,S=g.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;e("inherits")(E,n);var v=m.errorOrDestroy,_=["error","close","destroy","pause","resume"];function k(t,s,a){r=r||e("./_stream_duplex"),t=t||{},"boolean"!=typeof a&&(a=s instanceof r),this.objectMode=!!t.objectMode,a&&(this.objectMode=this.objectMode||!!t.readableObjectMode),this.highWaterMark=p(this,t,"readableHighWaterMark",a),this.buffer=new f,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.paused=!0,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.destroyed=!1,this.defaultEncoding=t.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,t.encoding&&(d||(d=e("string_decoder/").StringDecoder),this.decoder=new d(t.encoding),this.encoding=t.encoding)}function E(t){if(r=r||e("./_stream_duplex"),!(this instanceof E))return new E(t);var s=this instanceof r;this._readableState=new k(t,this,s),this.readable=!0,t&&("function"==typeof t.read&&(this._read=t.read),"function"==typeof t.destroy&&(this._destroy=t.destroy)),n.call(this)}function T(e,t,s,r,a){c("readableAddChunk",t);var n,l=e._readableState;if(null===t)l.reading=!1,function(e,t){if(c("onEofChunk"),t.ended)return;if(t.decoder){var s=t.decoder.end();s&&s.length&&(t.buffer.push(s),t.length+=t.objectMode?1:s.length)}t.ended=!0,t.sync?C(e):(t.needReadable=!1,t.emittedReadable||(t.emittedReadable=!0,I(e)))}(e,l);else if(a||(n=function(e,t){var s;r=t,i.isBuffer(r)||r instanceof o||"string"==typeof t||t===undefined||e.objectMode||(s=new b("chunk",["string","Buffer","Uint8Array"],t));var r;return s}(l,t)),n)v(e,n);else if(l.objectMode||t&&t.length>0)if("string"==typeof t||l.objectMode||Object.getPrototypeOf(t)===i.prototype||(t=function(e){return i.from(e)}(t)),r)l.endEmitted?v(e,new S):P(e,l,t,!0);else if(l.ended)v(e,new w);else{if(l.destroyed)return!1;l.reading=!1,l.decoder&&!s?(t=l.decoder.write(t),l.objectMode||0!==t.length?P(e,l,t,!1):M(e,l)):P(e,l,t,!1)}else r||(l.reading=!1,M(e,l));return!l.ended&&(l.length<l.highWaterMark||0===l.length)}function P(e,t,s,r){t.flowing&&0===t.length&&!t.sync?(t.awaitDrain=0,e.emit("data",s)):(t.length+=t.objectMode?1:s.length,r?t.buffer.unshift(s):t.buffer.push(s),t.needReadable&&C(e)),M(e,t)}Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),E.prototype.destroy=m.destroy,E.prototype._undestroy=m.undestroy,E.prototype._destroy=function(e,t){t(e)},E.prototype.push=function(e,t){var s,r=this._readableState;return r.objectMode?s=!0:"string"==typeof e&&((t=t||r.defaultEncoding)!==r.encoding&&(e=i.from(e,t),t=""),s=!0),T(this,e,t,!1,s)},E.prototype.unshift=function(e){return T(this,e,null,!0,!1)},E.prototype.isPaused=function(){return!1===this._readableState.flowing},E.prototype.setEncoding=function(t){d||(d=e("string_decoder/").StringDecoder);var s=new d(t);this._readableState.decoder=s,this._readableState.encoding=this._readableState.decoder.encoding;for(var r=this._readableState.buffer.head,a="";null!==r;)a+=s.write(r.data),r=r.next;return this._readableState.buffer.clear(),""!==a&&this._readableState.buffer.push(a),this._readableState.length=a.length,this};var R=1073741824;function A(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=R?e=R:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function C(e){var t=e._readableState;c("emitReadable",t.needReadable,t.emittedReadable),t.needReadable=!1,t.emittedReadable||(c("emitReadable",t.flowing),t.emittedReadable=!0,s.nextTick(I,e))}function I(e){var t=e._readableState;c("emitReadable_",t.destroyed,t.length,t.ended),t.destroyed||!t.length&&!t.ended||(e.emit("readable"),t.emittedReadable=!1),t.needReadable=!t.flowing&&!t.ended&&t.length<=t.highWaterMark,D(e)}function M(e,t){t.readingMore||(t.readingMore=!0,s.nextTick(O,e,t))}function O(e,t){for(;!t.reading&&!t.ended&&(t.length<t.highWaterMark||t.flowing&&0===t.length);){var s=t.length;if(c("maybeReadMore read 0"),e.read(0),s===t.length)break}t.readingMore=!1}function j(e){var t=e._readableState;t.readableListening=e.listenerCount("readable")>0,t.resumeScheduled&&!t.paused?t.flowing=!0:e.listenerCount("data")>0&&e.resume()}function N(e){c("readable nexttick read 0"),e.read(0)}function x(e,t){c("resume",t.reading),t.reading||e.read(0),t.resumeScheduled=!1,e.emit("resume"),D(e),t.flowing&&!t.reading&&e.read(0)}function D(e){var t=e._readableState;for(c("flow",t.flowing);t.flowing&&null!==e.read(););}function L(e,t){return 0===t.length?null:(t.objectMode?s=t.buffer.shift():!e||e>=t.length?(s=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.first():t.buffer.concat(t.length),t.buffer.clear()):s=t.buffer.consume(e,t.decoder),s);var s}function $(e){var t=e._readableState;c("endReadable",t.endEmitted),t.endEmitted||(t.ended=!0,s.nextTick(F,t,e))}function F(e,t){if(c("endReadableNT",e.endEmitted,e.length),!e.endEmitted&&0===e.length&&(e.endEmitted=!0,t.readable=!1,t.emit("end"),e.autoDestroy)){var s=t._writableState;(!s||s.autoDestroy&&s.finished)&&t.destroy()}}function U(e,t){for(var s=0,r=e.length;s<r;s++)if(e[s]===t)return s;return-1}E.prototype.read=function(e){c("read",e),e=parseInt(e,10);var t=this._readableState,s=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&((0!==t.highWaterMark?t.length>=t.highWaterMark:t.length>0)||t.ended))return c("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?$(this):C(this),null;if(0===(e=A(e,t))&&t.ended)return 0===t.length&&$(this),null;var r,a=t.needReadable;return c("need readable",a),(0===t.length||t.length-e<t.highWaterMark)&&c("length less than watermark",a=!0),t.ended||t.reading?c("reading or ended",a=!1):a&&(c("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=A(s,t))),null===(r=e>0?L(e,t):null)?(t.needReadable=t.length<=t.highWaterMark,e=0):(t.length-=e,t.awaitDrain=0),0===t.length&&(t.ended||(t.needReadable=!0),s!==e&&t.ended&&$(this)),null!==r&&this.emit("data",r),r},E.prototype._read=function(e){v(this,new y("_read()"))},E.prototype.pipe=function(e,t){var r=this,n=this._readableState;switch(n.pipesCount){case 0:n.pipes=e;break;case 1:n.pipes=[n.pipes,e];break;default:n.pipes.push(e)}n.pipesCount+=1,c("pipe count=%d opts=%j",n.pipesCount,t);var i=(!t||!1!==t.end)&&e!==s.stdout&&e!==s.stderr?l:g;function o(t,s){c("onunpipe"),t===r&&s&&!1===s.hasUnpiped&&(s.hasUnpiped=!0,c("cleanup"),e.removeListener("close",m),e.removeListener("finish",p),e.removeListener("drain",d),e.removeListener("error",f),e.removeListener("unpipe",o),r.removeListener("end",l),r.removeListener("end",g),r.removeListener("data",h),u=!0,!n.awaitDrain||e._writableState&&!e._writableState.needDrain||d())}function l(){c("onend"),e.end()}n.endEmitted?s.nextTick(i):r.once("end",i),e.on("unpipe",o);var d=function(e){return function(){var t=e._readableState;c("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&a(e,"data")&&(t.flowing=!0,D(e))}}(r);e.on("drain",d);var u=!1;function h(t){c("ondata");var s=e.write(t);c("dest.write",s),!1===s&&((1===n.pipesCount&&n.pipes===e||n.pipesCount>1&&-1!==U(n.pipes,e))&&!u&&(c("false write response, pause",n.awaitDrain),n.awaitDrain++),r.pause())}function f(t){c("onerror",t),g(),e.removeListener("error",f),0===a(e,"error")&&v(e,t)}function m(){e.removeListener("finish",p),g()}function p(){c("onfinish"),e.removeListener("close",m),g()}function g(){c("unpipe"),r.unpipe(e)}return r.on("data",h),function(e,t,s){if("function"==typeof e.prependListener)return e.prependListener(t,s);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(s):e._events[t]=[s,e._events[t]]:e.on(t,s)}(e,"error",f),e.once("close",m),e.once("finish",p),e.emit("pipe",r),n.flowing||(c("pipe resume"),r.resume()),e},E.prototype.unpipe=function(e){var t=this._readableState,s={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,s)),this;if(!e){var r=t.pipes,a=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var n=0;n<a;n++)r[n].emit("unpipe",this,{hasUnpiped:!1});return this}var i=U(t.pipes,e);return-1===i||(t.pipes.splice(i,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,s)),this},E.prototype.on=function(e,t){var r=n.prototype.on.call(this,e,t),a=this._readableState;return"data"===e?(a.readableListening=this.listenerCount("readable")>0,!1!==a.flowing&&this.resume()):"readable"===e&&(a.endEmitted||a.readableListening||(a.readableListening=a.needReadable=!0,a.flowing=!1,a.emittedReadable=!1,c("on readable",a.length,a.reading),a.length?C(this):a.reading||s.nextTick(N,this))),r},E.prototype.addListener=E.prototype.on,E.prototype.removeListener=function(e,t){var r=n.prototype.removeListener.call(this,e,t);return"readable"===e&&s.nextTick(j,this),r},E.prototype.removeAllListeners=function(e){var t=n.prototype.removeAllListeners.apply(this,arguments);return"readable"!==e&&e!==undefined||s.nextTick(j,this),t},E.prototype.resume=function(){var e=this._readableState;return e.flowing||(c("resume"),e.flowing=!e.readableListening,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,s.nextTick(x,e,t))}(this,e)),e.paused=!1,this},E.prototype.pause=function(){return c("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(c("pause"),this._readableState.flowing=!1,this.emit("pause")),this._readableState.paused=!0,this},E.prototype.wrap=function(e){var t=this,s=this._readableState,r=!1;for(var a in e.on("end",function(){if(c("wrapped end"),s.decoder&&!s.ended){var e=s.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(a){(c("wrapped data"),s.decoder&&(a=s.decoder.write(a)),!s.objectMode||null!==a&&a!==undefined)&&((s.objectMode||a&&a.length)&&(t.push(a)||(r=!0,e.pause())))}),e)this[a]===undefined&&"function"==typeof e[a]&&(this[a]=function(t){return function(){return e[t].apply(e,arguments)}}(a));for(var n=0;n<_.length;n++)e.on(_[n],this.emit.bind(this,_[n]));return this._read=function(t){c("wrapped _read",t),r&&(r=!1,e.resume())},this},"function"==typeof Symbol&&(E.prototype[Symbol.asyncIterator]=function(){return u===undefined&&(u=e("./internal/streams/async_iterator")),u(this)}),Object.defineProperty(E.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),Object.defineProperty(E.prototype,"readableBuffer",{enumerable:!1,get:function(){return this._readableState&&this._readableState.buffer}}),Object.defineProperty(E.prototype,"readableFlowing",{enumerable:!1,get:function(){return this._readableState.flowing},set:function(e){this._readableState&&(this._readableState.flowing=e)}}),E._fromList=L,Object.defineProperty(E.prototype,"readableLength",{enumerable:!1,get:function(){return this._readableState.length}}),"function"==typeof Symbol&&(E.from=function(t,s){return h===undefined&&(h=e("./internal/streams/from")),h(E,t,s)})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/_stream_readable.js"}],[2422,{"../errors":2418,"./_stream_duplex":2419,inherits:4552},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=d;var r=e("../errors").codes,a=r.ERR_METHOD_NOT_IMPLEMENTED,n=r.ERR_MULTIPLE_CALLBACK,i=r.ERR_TRANSFORM_ALREADY_TRANSFORMING,o=r.ERR_TRANSFORM_WITH_LENGTH_0,c=e("./_stream_duplex");function l(e,t){var s=this._transformState;s.transforming=!1;var r=s.writecb;if(null===r)return this.emit("error",new n);s.writechunk=null,s.writecb=null,null!=t&&this.push(t),r(e);var a=this._readableState;a.reading=!1,(a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}function d(e){if(!(this instanceof d))return new d(e);c.call(this,e),this._transformState={afterTransform:l.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",u)}function u(){var e=this;"function"!=typeof this._flush||this._readableState.destroyed?h(this,null,null):this._flush(function(t,s){h(e,t,s)})}function h(e,t,s){if(t)return e.emit("error",t);if(null!=s&&e.push(s),e._writableState.length)throw new o;if(e._transformState.transforming)throw new i;return e.push(null)}e("inherits")(d,c),d.prototype.push=function(e,t){return this._transformState.needTransform=!1,c.prototype.push.call(this,e,t)},d.prototype._transform=function(e,t,s){s(new a("_transform()"))},d.prototype._write=function(e,t,s){var r=this._transformState;if(r.writecb=s,r.writechunk=e,r.writeencoding=t,!r.transforming){var a=this._readableState;(r.needTransform||a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}},d.prototype._read=function(e){var t=this._transformState;null===t.writechunk||t.transforming?t.needTransform=!0:(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform))},d.prototype._destroy=function(e,t){c.prototype._destroy.call(this,e,function(e){t(e)})}}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/_stream_transform.js"}],[2423,{"../errors":2418,"./_stream_duplex":2419,"./internal/streams/destroy":2426,"./internal/streams/state":2430,"./internal/streams/stream":2431,_process:5024,buffer:4019,inherits:4552,"util-deprecate":5665},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){function r(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t,s){var r=e.entry;e.entry=null;for(;r;){var a=r.callback;t.pendingcb--,a(s),r=r.next}t.corkedRequestsFree.next=e}(t,e)}}var a;t.exports=E,E.WritableState=k;var n={deprecate:e("util-deprecate")},i=e("./internal/streams/stream"),o=e("buffer").Buffer,c=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var l,d=e("./internal/streams/destroy"),u=e("./internal/streams/state").getHighWaterMark,h=e("../errors").codes,f=h.ERR_INVALID_ARG_TYPE,m=h.ERR_METHOD_NOT_IMPLEMENTED,p=h.ERR_MULTIPLE_CALLBACK,g=h.ERR_STREAM_CANNOT_PIPE,b=h.ERR_STREAM_DESTROYED,w=h.ERR_STREAM_NULL_VALUES,y=h.ERR_STREAM_WRITE_AFTER_END,S=h.ERR_UNKNOWN_ENCODING,v=d.errorOrDestroy;function _(){}function k(t,n,i){a=a||e("./_stream_duplex"),t=t||{},"boolean"!=typeof i&&(i=n instanceof a),this.objectMode=!!t.objectMode,i&&(this.objectMode=this.objectMode||!!t.writableObjectMode),this.highWaterMark=u(this,t,"writableHighWaterMark",i),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var o=!1===t.decodeStrings;this.decodeStrings=!o,this.defaultEncoding=t.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var r=e._writableState,a=r.sync,n=r.writecb;if("function"!=typeof n)throw new p;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(r),t)!function(e,t,r,a,n){--t.pendingcb,r?(s.nextTick(n,a),s.nextTick(I,e,t),e._writableState.errorEmitted=!0,v(e,a)):(n(a),e._writableState.errorEmitted=!0,v(e,a),I(e,t))}(e,r,a,t,n);else{var i=A(r)||e.destroyed;i||r.corked||r.bufferProcessing||!r.bufferedRequest||R(e,r),a?s.nextTick(P,e,r,i,n):P(e,r,i,n)}}(n,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.bufferedRequestCount=0,this.corkedRequestsFree=new r(this)}function E(t){var s=this instanceof(a=a||e("./_stream_duplex"));if(!s&&!l.call(E,this))return new E(t);this._writableState=new k(t,this,s),this.writable=!0,t&&("function"==typeof t.write&&(this._write=t.write),"function"==typeof t.writev&&(this._writev=t.writev),"function"==typeof t.destroy&&(this._destroy=t.destroy),"function"==typeof t.final&&(this._final=t.final)),i.call(this)}function T(e,t,s,r,a,n,i){t.writelen=r,t.writecb=i,t.writing=!0,t.sync=!0,t.destroyed?t.onwrite(new b("write")):s?e._writev(a,t.onwrite):e._write(a,n,t.onwrite),t.sync=!1}function P(e,t,s,r){s||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,r(),I(e,t)}function R(e,t){t.bufferProcessing=!0;var s=t.bufferedRequest;if(e._writev&&s&&s.next){var a=t.bufferedRequestCount,n=new Array(a),i=t.corkedRequestsFree;i.entry=s;for(var o=0,c=!0;s;)n[o]=s,s.isBuf||(c=!1),s=s.next,o+=1;n.allBuffers=c,T(e,t,!0,t.length,n,"",i.finish),t.pendingcb++,t.lastBufferedRequest=null,i.next?(t.corkedRequestsFree=i.next,i.next=null):t.corkedRequestsFree=new r(t),t.bufferedRequestCount=0}else{for(;s;){var l=s.chunk,d=s.encoding,u=s.callback;if(T(e,t,!1,t.objectMode?1:l.length,l,d,u),s=s.next,t.bufferedRequestCount--,t.writing)break}null===s&&(t.lastBufferedRequest=null)}t.bufferedRequest=s,t.bufferProcessing=!1}function A(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function C(e,t){e._final(function(s){t.pendingcb--,s&&v(e,s),t.prefinished=!0,e.emit("prefinish"),I(e,t)})}function I(e,t){var r=A(t);if(r&&(function(e,t){t.prefinished||t.finalCalled||("function"!=typeof e._final||t.destroyed?(t.prefinished=!0,e.emit("prefinish")):(t.pendingcb++,t.finalCalled=!0,s.nextTick(C,e,t)))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"),t.autoDestroy))){var a=e._readableState;(!a||a.autoDestroy&&a.endEmitted)&&e.destroy()}return r}e("inherits")(E,i),k.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(k.prototype,"buffer",{get:n.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(l=Function.prototype[Symbol.hasInstance],Object.defineProperty(E,Symbol.hasInstance,{value:function(e){return!!l.call(this,e)||this===E&&(e&&e._writableState instanceof k)}})):l=function(e){return e instanceof this},E.prototype.pipe=function(){v(this,new g)},E.prototype.write=function(e,t,r){var a,n=this._writableState,i=!1,l=!n.objectMode&&(a=e,o.isBuffer(a)||a instanceof c);return l&&!o.isBuffer(e)&&(e=function(e){return o.from(e)}(e)),"function"==typeof t&&(r=t,t=null),l?t="buffer":t||(t=n.defaultEncoding),"function"!=typeof r&&(r=_),n.ending?function(e,t){var r=new y;v(e,r),s.nextTick(t,r)}(this,r):(l||function(e,t,r,a){var n;return null===r?n=new w:"string"==typeof r||t.objectMode||(n=new f("chunk",["string","Buffer"],r)),!n||(v(e,n),s.nextTick(a,n),!1)}(this,n,e,r))&&(n.pendingcb++,i=function(e,t,s,r,a,n){if(!s){var i=function(e,t,s){e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=o.from(t,s));return t}(t,r,a);r!==i&&(s=!0,a="buffer",r=i)}var c=t.objectMode?1:r.length;t.length+=c;var l=t.length<t.highWaterMark;l||(t.needDrain=!0);if(t.writing||t.corked){var d=t.lastBufferedRequest;t.lastBufferedRequest={chunk:r,encoding:a,isBuf:s,callback:n,next:null},d?d.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else T(e,t,!1,c,r,a,n);return l}(this,n,l,e,t,r)),i},E.prototype.cork=function(){this._writableState.corked++},E.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||R(this,e))},E.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new S(e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(E.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(E.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),E.prototype._write=function(e,t,s){s(new m("_write()"))},E.prototype._writev=null,E.prototype.end=function(e,t,r){var a=this._writableState;return"function"==typeof e?(r=e,e=null,t=null):"function"==typeof t&&(r=t,t=null),null!==e&&e!==undefined&&this.write(e,t),a.corked&&(a.corked=1,this.uncork()),a.ending||function(e,t,r){t.ending=!0,I(e,t),r&&(t.finished?s.nextTick(r):e.once("finish",r));t.ended=!0,e.writable=!1}(this,a,r),this},Object.defineProperty(E.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._writableState!==undefined&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),E.prototype.destroy=d.destroy,E.prototype._undestroy=d.undestroy,E.prototype._destroy=function(e,t){t(e)}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/_stream_writable.js"}],[2424,{"./end-of-stream":2427,_process:5024},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var r;function a(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var s=e[Symbol.toPrimitive];if(s!==undefined){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}var n=e("./end-of-stream"),i=Symbol("lastResolve"),o=Symbol("lastReject"),c=Symbol("error"),l=Symbol("ended"),d=Symbol("lastPromise"),u=Symbol("handlePromise"),h=Symbol("stream");function f(e,t){return{value:e,done:t}}function m(e){var t=e[i];if(null!==t){var s=e[h].read();null!==s&&(e[d]=null,e[i]=null,e[o]=null,t(f(s,!1)))}}function p(e){s.nextTick(m,e)}var g=Object.getPrototypeOf(function(){}),b=Object.setPrototypeOf((a(r={get stream(){return this[h]},next:function(){var e=this,t=this[c];if(null!==t)return Promise.reject(t);if(this[l])return Promise.resolve(f(undefined,!0));if(this[h].destroyed)return new Promise(function(t,r){s.nextTick(function(){e[c]?r(e[c]):t(f(undefined,!0))})});var r,a=this[d];if(a)r=new Promise(function(e,t){return function(s,r){e.then(function(){t[l]?s(f(undefined,!0)):t[u](s,r)},r)}}(a,this));else{var n=this[h].read();if(null!==n)return Promise.resolve(f(n,!1));r=new Promise(this[u])}return this[d]=r,r}},Symbol.asyncIterator,function(){return this}),a(r,"return",function(){var e=this;return new Promise(function(t,s){e[h].destroy(null,function(e){e?s(e):t(f(undefined,!0))})})}),r),g);t.exports=function(e){var t,s=Object.create(b,(a(t={},h,{value:e,writable:!0}),a(t,i,{value:null,writable:!0}),a(t,o,{value:null,writable:!0}),a(t,c,{value:null,writable:!0}),a(t,l,{value:e._readableState.endEmitted,writable:!0}),a(t,u,{value:function(e,t){var r=s[h].read();r?(s[d]=null,s[i]=null,s[o]=null,e(f(r,!1))):(s[i]=e,s[o]=t)},writable:!0}),t));return s[d]=null,n(e,function(e){if(e&&"ERR_STREAM_PREMATURE_CLOSE"!==e.code){var t=s[o];return null!==t&&(s[d]=null,s[i]=null,s[o]=null,t(e)),void(s[c]=e)}var r=s[i];null!==r&&(s[d]=null,s[i]=null,s[o]=null,r(f(undefined,!0))),s[l]=!0}),e.on("readable",p.bind(null,s)),s}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/async_iterator.js"}],[2425,{buffer:4019,util:3971},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e,t){var s=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),s.push.apply(s,r)}return s}function a(e){for(var t=1;t<arguments.length;t++){var s=null!=arguments[t]?arguments[t]:{};t%2?r(Object(s),!0).forEach(function(t){n(e,t,s[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(s)):r(Object(s)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(s,t))})}return e}function n(e,t,s){return(t=o(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t){for(var s=0;s<t.length;s++){var r=t[s];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,o(r.key),r)}}function o(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var s=e[Symbol.toPrimitive];if(s!==undefined){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}var c=e("buffer").Buffer,l=e("util").inspect,d=l&&l.custom||"inspect";function u(e,t,s){c.prototype.copy.call(e,t,s)}t.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}var t,s,r;return t=e,(s=[{key:"push",value:function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length}},{key:"unshift",value:function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length}},{key:"shift",value:function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}}},{key:"clear",value:function(){this.head=this.tail=null,this.length=0}},{key:"join",value:function(e){if(0===this.length)return"";for(var t=this.head,s=""+t.data;t=t.next;)s+=e+t.data;return s}},{key:"concat",value:function(e){if(0===this.length)return c.alloc(0);for(var t=c.allocUnsafe(e>>>0),s=this.head,r=0;s;)u(s.data,t,r),r+=s.data.length,s=s.next;return t}},{key:"consume",value:function(e,t){var s;return e<this.head.data.length?(s=this.head.data.slice(0,e),this.head.data=this.head.data.slice(e)):s=e===this.head.data.length?this.shift():t?this._getString(e):this._getBuffer(e),s}},{key:"first",value:function(){return this.head.data}},{key:"_getString",value:function(e){var t=this.head,s=1,r=t.data;for(e-=r.length;t=t.next;){var a=t.data,n=e>a.length?a.length:e;if(n===a.length?r+=a:r+=a.slice(0,e),0===(e-=n)){n===a.length?(++s,t.next?this.head=t.next:this.head=this.tail=null):(this.head=t,t.data=a.slice(n));break}++s}return this.length-=s,r}},{key:"_getBuffer",value:function(e){var t=c.allocUnsafe(e),s=this.head,r=1;for(s.data.copy(t),e-=s.data.length;s=s.next;){var a=s.data,n=e>a.length?a.length:e;if(a.copy(t,t.length-e,0,n),0===(e-=n)){n===a.length?(++r,s.next?this.head=s.next:this.head=this.tail=null):(this.head=s,s.data=a.slice(n));break}++r}return this.length-=r,t}},{key:d,value:function(e,t){return l(this,a(a({},t),{},{depth:0,customInspect:!1}))}}])&&i(t.prototype,s),r&&i(t,r),Object.defineProperty(t,"prototype",{writable:!1}),e}()}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/buffer_list.js"}],[2426,{_process:5024},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(e){(function(){function s(e,t){a(e,t),r(e)}function r(e){e._writableState&&!e._writableState.emitClose||e._readableState&&!e._readableState.emitClose||e.emit("close")}function a(e,t){e.emit("error",t)}t.exports={destroy:function(t,n){var i=this,o=this._readableState&&this._readableState.destroyed,c=this._writableState&&this._writableState.destroyed;return o||c?(n?n(t):t&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,e.nextTick(a,this,t)):e.nextTick(a,this,t)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(t||null,function(t){!n&&t?i._writableState?i._writableState.errorEmitted?e.nextTick(r,i):(i._writableState.errorEmitted=!0,e.nextTick(s,i,t)):e.nextTick(s,i,t):n?(e.nextTick(r,i),n(t)):e.nextTick(r,i)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)},errorOrDestroy:function(e,t){var s=e._readableState,r=e._writableState;s&&s.autoDestroy||r&&r.autoDestroy?e.destroy(t):e.emit("error",t)}}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/destroy.js"}],[2427,{"../../../errors":2418},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("../../../errors").codes.ERR_STREAM_PREMATURE_CLOSE;function a(){}t.exports=function e(t,s,n){if("function"==typeof s)return e(t,null,s);s||(s={}),n=function(e){var t=!1;return function(){if(!t){t=!0;for(var s=arguments.length,r=new Array(s),a=0;a<s;a++)r[a]=arguments[a];e.apply(this,r)}}}(n||a);var i=s.readable||!1!==s.readable&&t.readable,o=s.writable||!1!==s.writable&&t.writable,c=function(){t.writable||d()},l=t._writableState&&t._writableState.finished,d=function(){o=!1,l=!0,i||n.call(t)},u=t._readableState&&t._readableState.endEmitted,h=function(){i=!1,u=!0,o||n.call(t)},f=function(e){n.call(t,e)},m=function(){var e;return i&&!u?(t._readableState&&t._readableState.ended||(e=new r),n.call(t,e)):o&&!l?(t._writableState&&t._writableState.ended||(e=new r),n.call(t,e)):void 0},p=function(){t.req.on("finish",d)};return!function(e){return e.setHeader&&"function"==typeof e.abort}(t)?o&&!t._writableState&&(t.on("end",c),t.on("close",c)):(t.on("complete",d),t.on("abort",m),t.req?p():t.on("request",p)),t.on("end",h),t.on("finish",d),!1!==s.error&&t.on("error",f),t.on("close",m),function(){t.removeListener("complete",d),t.removeListener("abort",m),t.removeListener("request",p),t.req&&t.req.removeListener("finish",d),t.removeListener("end",c),t.removeListener("close",c),t.removeListener("finish",d),t.removeListener("end",h),t.removeListener("error",f),t.removeListener("close",m)}}}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"}],[2428,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=function(){throw new Error("Readable.from is not available in the browser")}}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/from-browser.js"}],[2429,{"../../../errors":2418,"./end-of-stream":2427},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r;var a=e("../../../errors").codes,n=a.ERR_MISSING_ARGS,i=a.ERR_STREAM_DESTROYED;function o(e){if(e)throw e}function c(e){e()}function l(e,t){return e.pipe(t)}t.exports=function(){for(var t=arguments.length,s=new Array(t),a=0;a<t;a++)s[a]=arguments[a];var d,u=function(e){return e.length?"function"!=typeof e[e.length-1]?o:e.pop():o}(s);if(Array.isArray(s[0])&&(s=s[0]),s.length<2)throw new n("streams");var h=s.map(function(t,a){var n=a<s.length-1;return function(t,s,a,n){n=function(e){var t=!1;return function(){t||(t=!0,e.apply(void 0,arguments))}}(n);var o=!1;t.on("close",function(){o=!0}),r===undefined&&(r=e("./end-of-stream")),r(t,{readable:s,writable:a},function(e){if(e)return n(e);o=!0,n()});var c=!1;return function(e){if(!o&&!c)return c=!0,function(e){return e.setHeader&&"function"==typeof e.abort}(t)?t.abort():"function"==typeof t.destroy?t.destroy():void n(e||new i("pipe"))}}(t,n,a>0,function(e){d||(d=e),e&&h.forEach(c),n||(h.forEach(c),u(d))})});return s.reduce(l)}}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/pipeline.js"}],[243,{"@metamask/name-controller":2276},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ChangeType=s.AbstractPetnamesBridge=void 0;var r=e("@metamask/name-controller");function a(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function n(e,t,s){i(e,t),t.set(e,s)}function i(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function o(e,t){return e.get(l(e,t))}function c(e,t,s){return e.set(l(e,t),s),s}function l(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}let d=s.ChangeType=function(e){return e.ADDED="ADDED",e.UPDATED="UPDATED",e.DELETED="DELETED",e}({});var u=function(e){return e.SOURCE_TO_PETNAMES="Source->Petnames",e.PETNAMES_TO_SOURCE="Petnames->Source",e}(u||{});function h({type:e,variation:t,value:s}){return`${e}/${t}/${e===r.NameType.ETHEREUM_ADDRESS?s.toLowerCase():s}`}var f=new WeakMap,m=new WeakMap,p=new WeakMap,g=new WeakSet;function b(e){if(o(p,this)===e)throw new Error(`Attempted to synchronize recursively in same direction: ${e}`);if(null!==o(p,this))return;c(p,this,e);const[t,s]="Source->Petnames"===e?[this.getSourceEntries(),l(g,this,w).call(this)]:[l(g,this,w).call(this),this.getSourceEntries()],r=l(g,this,S).call(this,s,t);l(g,this,v).call(this,r),c(p,this,null)}function w(){const{names:e}=o(m,this).state,t=[];for(const s of Object.values(r.NameType))for(const r of Object.keys(e[s]))for(const a of Object.keys(e[s][r])){const{name:n,sourceId:i,origin:o}=e[s][r][a];if(!n)continue;const c={value:r,type:s,name:n,variation:a,sourceId:i??undefined,origin:o??undefined};this.shouldSyncPetname(c)&&t.push(c)}return t}function y(e,t){e===d.DELETED?(delete t.sourceId,delete t.origin,o(m,this).setName({...t,name:null})):o(m,this).setName(t)}function S(e,t){const s=[],r=[],a=[],n=new Map(e.map(e=>[h(e),e])),i=new Map(t.map(e=>[h(e),e]));return i.forEach((e,t)=>{const a=n.get(t);a?e.name!==a.name&&r.push(e):s.push(e)}),n.forEach((e,t)=>{i.has(t)||a.push(e)}),{[d.ADDED]:s,[d.UPDATED]:r,[d.DELETED]:a}}function v(e){const t=o(p,this)===u.SOURCE_TO_PETNAMES?l(g,this,y).bind(this):this.updateSourceEntry.bind(this);for(const s of Object.values(d))for(const r of e[s])t(s,r)}s.AbstractPetnamesBridge=class{constructor({isTwoWay:e,nameController:t,messenger:s}){var r,o;i(r=this,o=g),o.add(r),n(this,f,void 0),n(this,m,void 0),n(this,p,null),a(this,"messenger",void 0),c(f,this,e),c(m,this,t),this.messenger=s}init(){o(f,this)&&this.messenger.subscribe("NameController:stateChange",()=>l(g,this,b).call(this,u.PETNAMES_TO_SOURCE)),this.onSourceChange(()=>l(g,this,b).call(this,u.SOURCE_TO_PETNAMES))}updateSourceEntry(e,t){throw new Error("updateSourceEntry must be overridden for two-way bridges")}shouldSyncPetname(e){return!0}}}}},{package:"$root$",file:"app/scripts/lib/AbstractPetnamesBridge.ts"}],[2430,{"../../../errors":2418},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("../../../errors").codes.ERR_INVALID_OPT_VALUE;t.exports={getHighWaterMark:function(e,t,s,a){var n=function(e,t,s){return null!=e.highWaterMark?e.highWaterMark:t?e[s]:null}(t,a,s);if(null!=n){if(!isFinite(n)||Math.floor(n)!==n||n<0)throw new r(a?s:"highWaterMark",n);return Math.floor(n)}return e.objectMode?16:16384}}}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/state.js"}],[2431,{events:4319},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=e("events").EventEmitter}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js"}],[2432,{"./lib/_stream_duplex.js":2419,"./lib/_stream_passthrough.js":2420,"./lib/_stream_readable.js":2421,"./lib/_stream_transform.js":2422,"./lib/_stream_writable.js":2423,"./lib/internal/streams/end-of-stream.js":2427,"./lib/internal/streams/pipeline.js":2429},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(s=t.exports=e("./lib/_stream_readable.js")).Stream=s,s.Readable=s,s.Writable=e("./lib/_stream_writable.js"),s.Duplex=e("./lib/_stream_duplex.js"),s.Transform=e("./lib/_stream_transform.js"),s.PassThrough=e("./lib/_stream_passthrough.js"),s.finished=e("./lib/internal/streams/end-of-stream.js"),s.pipeline=e("./lib/internal/streams/pipeline.js")}}},{package:"@metamask/post-message-stream>readable-stream",file:"node_modules/@metamask/post-message-stream/node_modules/readable-stream/readable-browser.js"}],[2433,{"./ppom-controller":2434},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;var r=e("./ppom-controller");Object.defineProperty(s,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return r.NETWORK_CACHE_DURATION}}),Object.defineProperty(s,"PPOMController",{enumerable:!0,get:function(){return r.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],[2434,{"./ppom-storage":2435,"./util":2436,"@metamask/base-controller":1346,"@metamask/controller-utils":1419,"await-semaphore":3845},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h,f,m,p,g,b,w,y,S,v,_,k,E,T,P,R,A,C,I,M,O,j,N,x=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},D=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;const L=e("@metamask/base-controller"),$=e("@metamask/controller-utils"),F=e("await-semaphore"),U=e("./ppom-storage"),B=e("./util");s.NETWORK_CACHE_DURATION=6048e5;const W=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],q={versionInfo:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!1},storageMetadata:{includeInStateLogs:!1,persist:!0,includeInDebugSnapshot:!1,usedInUi:!1}},G="PPOMController",H={headers:{"Content-Type":"application/json"}};class K extends L.BaseController{constructor({chainId:e,messenger:t,provider:s,storageBackend:w,securityAlertsEnabled:y,onPreferencesChange:S,ppomProvider:E,cdnBaseUrl:T,providerRequestLimit:P,state:R,blockaidPublicKey:A,nativeCrypto:C}){super({name:G,metadata:q,messenger:t,state:{versionInfo:R?.versionInfo??[],storageMetadata:R?.storageMetadata??[]}}),r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),u.set(this,0),h.set(this,void 0),f.set(this,void 0),m.set(this,{}),p.set(this,void 0),g.set(this,!1),b.set(this,undefined),x(this,h,(0,B.addHexPrefix)(e),"f"),x(this,n,s,"f"),x(this,c,E,"f"),x(this,i,new U.PPOMStorage({storageBackend:w,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update(t=>{t.storageMetadata=e})}}),"f"),x(this,o,new F.Mutex,"f"),x(this,l,T,"f"),x(this,d,P??300,"f"),x(this,f,y,"f"),x(this,p,A,"f"),x(this,b,C,"f"),S(D(this,r,"m",v).bind(this)),D(this,r,"m",_).call(this),D(this,r,"m",k).call(this)}async usePPOM(e,t){const s=t??D(this,h,"f");if(!D(this,f,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,B.blockaidValidationSupportedForNetwork)(s))throw Error(`Blockaid validation not available on network with chainId: ${s}`);return await D(this,o,"f").use(async()=>{const t=await D(this,r,"m",T).call(this,s);x(this,u,0,"f"),x(this,m,{},"f");return{...await e(t),providerRequestsCount:{...D(this,m,"f")}}})}}s.PPOMController=K,a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,u=new WeakMap,h=new WeakMap,f=new WeakMap,m=new WeakMap,p=new WeakMap,g=new WeakMap,b=new WeakMap,r=new WeakSet,w=async function(){if(D(this,f,"f")&&!D(this,g,"f")){const{ppomInit:e}=D(this,c,"f");await e("./ppom_bg.wasm"),x(this,g,!0,"f")}},y=function(){D(this,r,"m",E).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)});const{storageMetadata:e}=this.state;this.update(e=>{e.versionInfo=[],e.storageMetadata=[]}),D(this,i,"f").deleteAllFiles(e).catch(e=>{console.error(`Error in deleting files: ${e.message}`)})},S=function(e){const t=this.messenger.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:s}=t.configuration,a=(0,B.addHexPrefix)(s);a!==D(this,h,"f")&&(x(this,h,a,"f"),D(this,r,"m",E).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)}))},v=function(e){const t=e.securityAlertsEnabled;t!==D(this,f,"f")&&(x(this,f,t,"f"),t||D(this,r,"m",y).call(this))},_=function(){this.messenger.registerActionHandler(`${G}:usePPOM`,this.usePPOM.bind(this))},k=function(){const e=D(this,r,"m",S).bind(this);this.messenger.subscribe("NetworkController:networkDidChange",e)},E=async function(){await D(this,o,"f").use(async()=>{D(this,a,"f")&&(D(this,a,"f").free(),x(this,a,undefined,"f"))})},T=async function(e){const t=await D(this,r,"m",P).call(this);let s;return(D(this,a,"f")===undefined||t)&&(s=await D(this,r,"m",N).call(this,e),D(this,h,"f")===e&&(D(this,a,"f")&&D(this,a,"f").free(),x(this,a,s,"f")),D(this,i,"f").syncMetadata(this.state.versionInfo).catch(e=>{console.error(`Error while trying to sync metadata: ${e.message}`)})),s},P=async function(){const e=await D(this,r,"m",M).call(this);return!!e&&(this.update(t=>{t.versionInfo=e}),!0)},R=function(e,t){return e.find(e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum)},A=async function(e){const t=await Promise.all(e.map(async e=>{let t;try{t=await D(this,r,"m",C).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined}));return t?.filter(e=>e?.[1]!==undefined)},C=async function(e){const{storageMetadata:t}=this.state;if(D(this,r,"m",R).call(this,t,e))try{return await D(this,i,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,B.checkFilePath)(e.filePath);const s=(0,B.constructURLHref)(D(this,l,"f"),e.filePath),a=await D(this,r,"m",O).call(this,s);return await(0,B.validateSignature)(a,e.hashSignature,D(this,p,"f"),e.filePath,D(this,b,"f")),await D(this,i,"f").writeFile({data:a,...e}).catch(e=>{console.error(`Error in writing file: ${e.message}`)}),a},I=async function(e,t={},s="GET"){const r=await(0,$.safelyExecute)(async()=>(0,$.timeoutFetch)(e,{method:s,cache:"no-cache",redirect:"error",...t},1e4),!0),a=304===r?.status;if(!r?.status||r?.status<200||r?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:a,response:r}},M=async function(){const e=(0,B.constructURLHref)(D(this,l,"f"),"ppom_version.json"),{cached:t,response:s}=await D(this,r,"m",I).call(this,e,{headers:H});return t&&this.state.versionInfo?.length?undefined:s.json()},O=async function(e){const{response:t}=await D(this,r,"m",I).call(this,e);return await t.arrayBuffer()},j=async function(e,t){if(D(this,u,"f")>D(this,d,"f"))return B.PROVIDER_ERRORS.limitExceeded();if(x(this,u,D(this,u,"f")+1,"f"),!W.includes(e))return B.PROVIDER_ERRORS.methodNotSupported();D(this,m,"f")[e]=D(this,m,"f")[e]?Number(D(this,m,"f")[e])+1:1;const s=(0,B.createPayload)(e,t);try{const e=await D(this,n,"f").request(s);return{jsonrpc:"2.0",id:s.id,result:e}}catch(e){return{jsonrpc:"2.0",id:s.id,error:e}}},N=async function(e){await D(this,r,"m",w).call(this);const t=this.state.versionInfo.filter(({chainId:t})=>t===e);if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const s=await D(this,r,"m",A).call(this,t);if(s?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:a}=D(this,c,"f");return a.new(D(this,r,"m",j).bind(this),s)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],[2435,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},o=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMStorage=void 0;s.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:s}){r.set(this,void 0),a.set(this,void 0),n.set(this,void 0),i(this,r,e,"f"),i(this,a,t,"f"),i(this,n,s,"f")}async syncMetadata(e){const t=o(this,a,"f").call(this),s=[];for(const r of t){try{await this.readFile(r.name,r.chainId)}catch(e){console.error("Error: ",e);continue}e.find(e=>e.name===r.name&&e.chainId===r.chainId&&e.version===r.version&&e.checksum===r.checksum)&&s.push(r)}const i=await o(this,r,"f").dir();for(const{name:e,chainId:t}of i)s.find(s=>s.name===e&&s.chainId===t)||await o(this,r,"f").delete({name:e,chainId:t});return o(this,n,"f").call(this,s),s}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:s}=t;try{await o(this,r,"f").delete({name:e,chainId:s})}catch(t){console.error(`Error in deleting file: ${e}, ${s}`,t)}}}async readFile(e,t){const s=o(this,a,"f").call(this).find(s=>s.name===e&&s.chainId===t);if(!s)throw new Error(`File metadata (${e}, ${t}) not found`);const n=await o(this,r,"f").read({name:e,chainId:t},s.checksum);if(!n)throw new Error(`Storage File (${e}, ${t}) not found`);return n}async writeFile({data:e,name:t,chainId:s,version:i,checksum:c}){await o(this,r,"f").write({name:t,chainId:s},e,c);const l=o(this,a,"f").call(this),d=l.find(e=>e.name===t&&e.chainId===s);d?(d.version=i,d.checksum=c):l.push({name:t,chainId:s,version:i,checksum:c}),o(this,n,"f").call(this,l)}},r=new WeakMap,a=new WeakMap,n=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],[2436,{buffer:4019,"crypto-js":4136,elliptic:4192,"json-rpc-random-id":4589},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return a(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.checkFilePath=s.addHexPrefix=s.constructURLHref=s.validateSignature=s.PROVIDER_ERRORS=s.createPayload=s.IdGenerator=s.blockaidValidationSupportedForNetwork=s.SUPPORTED_NETWORK_CHAINIDS=void 0;const o=n(e("crypto-js")),c=i(e("elliptic")),l=i(e("json-rpc-random-id")),d=c.default.eddsa;s.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};s.blockaidValidationSupportedForNetwork=e=>Object.values(s.SUPPORTED_NETWORK_CHAINIDS).some(t=>t===e),s.IdGenerator=(0,l.default)();s.createPayload=(e,t)=>({id:(0,s.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),s.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};s.validateSignature=async(e,s,r,a,n,i)=>{const c=await(async(e,t,s=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&s){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map(e=>e.toString(16).padStart(2,"0")).join("")}return(0,o.SHA256)(o.default.lib.WordArray.create(e)).toString()})(e,n,i);if(!new d("ed25519").keyFromPublic(r).verify(t.from(c),s))throw Error(`Signature verification failed for file path: ${a}`)};s.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;s.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;s.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],[2437,{"@metamask/polling-controller":2410,"async-mutex":3841},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},u=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ProfileMetricsController=s.getDefaultProfileMetricsControllerState=s.controllerName=void 0;const h=e("@metamask/polling-controller"),f=e("async-mutex");s.controllerName="ProfileMetricsController";const m={initialEnqueueCompleted:{persist:!0,includeInDebugSnapshot:!0,includeInStateLogs:!0,usedInUi:!1},syncQueue:{persist:!0,includeInDebugSnapshot:!1,includeInStateLogs:!0,usedInUi:!1}};function p(){return{initialEnqueueCompleted:!1,syncQueue:{}}}s.getDefaultProfileMetricsControllerState=p;const g=[];class b extends((0,h.StaticIntervalPollingController)()){constructor({messenger:e,state:t,assertUserOptedIn:h,getMetaMetricsId:p,interval:b=1e4}){super({messenger:e,metadata:m,name:s.controllerName,state:{initialEnqueueCompleted:!1,syncQueue:{},...t}}),r.add(this),a.set(this,new f.Mutex),n.set(this,void 0),i.set(this,void 0),d(this,n,h,"f"),d(this,i,p,"f"),this.messenger.registerMethodActionHandlers(this,g),this.messenger.subscribe("KeyringController:unlock",()=>{u(this,r,"m",o).call(this).catch(console.error),u(this,n,"f").call(this)&&this.startPolling(null)}),this.messenger.subscribe("KeyringController:lock",()=>{this.stopAllPolling()}),this.messenger.subscribe("AccountsController:accountAdded",e=>{u(this,r,"m",c).call(this,e).catch(console.error)}),this.messenger.subscribe("AccountsController:accountRemoved",e=>{u(this,r,"m",l).call(this,e).catch(console.error)}),this.setIntervalLength(b)}async _executePoll(){await u(this,a,"f").runExclusive(async()=>{if(u(this,n,"f").call(this))for(const[e,t]of Object.entries(this.state.syncQueue))try{await this.messenger.call("ProfileMetricsService:submitMetrics",{metametricsId:u(this,i,"f").call(this),entropySourceId:"null"===e?null:e,accounts:t}),this.update(t=>{delete t.syncQueue[e]})}catch(t){console.error(`Failed to submit profile metrics for entropy source ID ${e}:`,t)}})}}function w(e){return"mnemonic"===e.options.entropy?.type?e.options.entropy.id:null}s.ProfileMetricsController=b,a=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakSet,o=async function(){await u(this,a,"f").runExclusive(async()=>{if(this.state.initialEnqueueCompleted)return;const e=Object.values(this.messenger.call("AccountsController:getState").internalAccounts.accounts).reduce((e,t)=>{const s=w(t)??"null";return e[s]||(e[s]=[]),e[s].push({address:t.address,scopes:t.scopes}),e},{});this.update(t=>{for(const s of Object.keys(e))t.syncQueue[s]||(t.syncQueue[s]=[]),t.syncQueue[s].push(...e[s]);t.initialEnqueueCompleted=!0})})},c=async function(e){await u(this,a,"f").runExclusive(async()=>{this.update(t=>{const s=w(e)??"null";t.syncQueue[s]||(t.syncQueue[s]=[]),t.syncQueue[s].push({address:e.address,scopes:e.scopes})})})},l=async function(e){await u(this,a,"f").runExclusive(async()=>{this.update(t=>{for(const[s,r]of Object.entries(t.syncQueue)){const a=r.findIndex(({address:t})=>t===e);if(-1!==a){r.splice(a,1),0===r.length&&delete t.syncQueue[s];break}}})})}}}},{package:"@metamask/profile-metrics-controller",file:"node_modules/@metamask/profile-metrics-controller/dist/ProfileMetricsController.cjs"}],[2438,{"@metamask/controller-utils":1419,"@metamask/profile-sync-controller":2456},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},c=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.getAuthUrl=s.ProfileMetricsService=s.serviceName=void 0;const l=e("@metamask/controller-utils"),d=e("@metamask/profile-sync-controller");s.serviceName="ProfileMetricsService";const u=["submitMetrics"];class h{constructor({messenger:e,fetch:t,policyOptions:h={},env:m=d.SDK.Env.DEV}){r.set(this,void 0),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),this.name=s.serviceName,o(this,r,e,"f"),o(this,a,t,"f"),o(this,n,(0,l.createServicePolicy)(h),"f"),o(this,i,f(m),"f"),c(this,r,"f").registerMethodActionHandlers(this,u)}onRetry(e){return c(this,n,"f").onRetry(e)}onBreak(e){return c(this,n,"f").onBreak(e)}onDegraded(e){return c(this,n,"f").onDegraded(e)}async submitMetrics(e){const t=await c(this,r,"f").call("AuthenticationController:getBearerToken",e.entropySourceId??undefined);await c(this,n,"f").execute(async()=>{const s=new URL(`${c(this,i,"f")}/profile/accounts`),r=await c(this,a,"f").call(this,s,{method:"PUT",headers:{Authorization:`Bearer ${t}`,"Content-Type":"application/json"},body:JSON.stringify({metametrics_id:e.metametricsId,accounts:e.accounts})});if(!r.ok)throw new l.HttpError(r.status,`Fetching '${s.toString()}' failed with status '${r.status}'`);return r})}}function f(e){return`${d.SDK.getEnvUrls(e).authApiUrl}/api/v2`}s.ProfileMetricsService=h,r=new WeakMap,a=new WeakMap,n=new WeakMap,i=new WeakMap,s.getAuthUrl=f}}},{package:"@metamask/profile-metrics-controller",file:"node_modules/@metamask/profile-metrics-controller/dist/ProfileMetricsService.cjs"}],[2439,{"./ProfileMetricsController.cjs":2437,"./ProfileMetricsService.cjs":2438},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.serviceName=s.ProfileMetricsService=s.getDefaultProfileMetricsControllerState=s.ProfileMetricsController=void 0;var r=e("./ProfileMetricsController.cjs");Object.defineProperty(s,"ProfileMetricsController",{enumerable:!0,get:function(){return r.ProfileMetricsController}}),Object.defineProperty(s,"getDefaultProfileMetricsControllerState",{enumerable:!0,get:function(){return r.getDefaultProfileMetricsControllerState}});var a=e("./ProfileMetricsService.cjs");Object.defineProperty(s,"ProfileMetricsService",{enumerable:!0,get:function(){return a.ProfileMetricsService}}),Object.defineProperty(s,"serviceName",{enumerable:!0,get:function(){return a.serviceName}})}}},{package:"@metamask/profile-metrics-controller",file:"node_modules/@metamask/profile-metrics-controller/dist/index.cjs"}],[244,{"./AbstractPetnamesBridge":243,"@metamask/name-controller":2276},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AccountIdentitiesPetnamesBridge=void 0;var r=e("@metamask/name-controller"),a=e("./AbstractPetnamesBridge");class n extends a.AbstractPetnamesBridge{constructor({nameController:e,messenger:t}){super({isTwoWay:!1,nameController:e,messenger:t})}getSourceEntries(){return this.messenger.call("AccountsController:listAccounts").map(e=>({value:e.address,type:r.NameType.ETHEREUM_ADDRESS,name:e.metadata.name,sourceId:undefined,variation:r.FALLBACK_VARIATION,origin:r.NameOrigin.ACCOUNT_IDENTITY}))}onSourceChange(e){this.messenger.subscribe("AccountsController:stateChange",e)}shouldSyncPetname(e){return e.origin===r.NameOrigin.ACCOUNT_IDENTITY}}s.AccountIdentitiesPetnamesBridge=n}}},{package:"$root$",file:"app/scripts/lib/AccountIdentitiesPetnamesBridge.ts"}],[2440,{"../../sdk/index.cjs":2465,"./auth-snap-requests.cjs":2441,"@metamask/base-controller":1346},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h,f,m,p,g,b=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},w=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s};Object.defineProperty(s,"__esModule",{value:!0}),s.defaultState=void 0;const y=e("@metamask/base-controller"),S=e("./auth-snap-requests.cjs"),v=e("../../sdk/index.cjs");s.defaultState={isSignedIn:!1};const _={isSignedIn:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},srpSessionData:{includeInStateLogs:e=>null===e||e===undefined?null:Object.entries(e).reduce((e,[t,s])=>{const{accessToken:r,...a}=s.token;return e[t]={...s,token:a},e},{}),persist:!0,includeInDebugSnapshot:!1,usedInUi:!0}};class k extends y.BaseController{constructor({messenger:e,state:t,config:h,metametrics:m}){if(super({messenger:e,metadata:_,name:"AuthenticationController",state:{...s.defaultState,...t}}),r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,{env:v.Env.PRD}),o.set(this,!1),c.set(this,{setupLockedStateSubscriptions:()=>{const{isUnlocked:e}=this.messenger.call("KeyringController:getState");w(this,o,e,"f"),this.messenger.subscribe("KeyringController:unlock",()=>{w(this,o,!0,"f")}),this.messenger.subscribe("KeyringController:lock",()=>{w(this,o,!1,"f")})}}),p.set(this,{}),!m)throw new Error("`metametrics` field is required");w(this,i,{...b(this,i,"f"),...h},"f"),w(this,a,m,"f"),w(this,n,new v.JwtBearerAuth({env:b(this,i,"f").env,platform:m.agent,type:v.AuthType.SRP},{storage:{getLoginResponse:b(this,r,"m",d).bind(this),setLoginResponse:b(this,r,"m",u).bind(this)},signing:{getIdentifier:b(this,r,"m",f).bind(this),signMessage:b(this,r,"m",g).bind(this)},metametrics:b(this,a,"f")}),"f"),b(this,c,"f").setupLockedStateSubscriptions(),b(this,r,"m",l).call(this)}async performSignIn(){b(this,r,"m",h).call(this,"performSignIn");const e=await b(this,r,"m",m).call(this),t=[];for(const[s]of e){const e=await b(this,n,"f").getAccessToken(s);t.push(e)}return t}performSignOut(){this.update(e=>{e.isSignedIn=!1,e.srpSessionData=undefined})}async getBearerToken(e){return b(this,r,"m",h).call(this,"getBearerToken"),await b(this,n,"f").getAccessToken(e)}async getSessionProfile(e){return b(this,r,"m",h).call(this,"getSessionProfile"),await b(this,n,"f").getUserProfile(e)}async getUserProfileLineage(){return b(this,r,"m",h).call(this,"getUserProfileLineage"),await b(this,n,"f").getUserProfileLineage()}isSignedIn(){return this.state.isSignedIn}}a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,p=new WeakMap,r=new WeakSet,l=function(){this.messenger.registerActionHandler("AuthenticationController:getBearerToken",this.getBearerToken.bind(this)),this.messenger.registerActionHandler("AuthenticationController:getSessionProfile",this.getSessionProfile.bind(this)),this.messenger.registerActionHandler("AuthenticationController:isSignedIn",this.isSignedIn.bind(this)),this.messenger.registerActionHandler("AuthenticationController:performSignIn",this.performSignIn.bind(this)),this.messenger.registerActionHandler("AuthenticationController:performSignOut",this.performSignOut.bind(this)),this.messenger.registerActionHandler("AuthenticationController:getUserProfileLineage",this.getUserProfileLineage.bind(this))},d=async function(e){if(e)return this.state.srpSessionData?.[e]?this.state.srpSessionData[e]:null;const t=Object.values(this.state.srpSessionData||{})?.[0];return t||null},u=async function(e,t){const s=await b(this,a,"f").getMetaMetricsId();this.update(r=>{t&&(r.isSignedIn=!0,r.srpSessionData||(r.srpSessionData={}),r.srpSessionData[t]={...e,profile:{...e.profile,metaMetricsId:s}})})},h=function(e){if(!b(this,o,"f"))throw new Error(`${e} - unable to proceed, wallet is locked`)},f=async function(e){b(this,r,"m",h).call(this,"#snapGetPublicKey");return await this.messenger.call("SnapController:handleRequest",(0,S.createSnapPublicKeyRequest)(e))},m=async function(){b(this,r,"m",h).call(this,"#snapGetAllPublicKeys");return await this.messenger.call("SnapController:handleRequest",(0,S.createSnapAllPublicKeysRequest)())},g=async function(e,t){if((0,v.assertMessageStartsWithMetamask)(e),b(this,p,"f")[e])return b(this,p,"f")[e];b(this,r,"m",h).call(this,"#snapSignMessage");const s=await this.messenger.call("SnapController:handleRequest",(0,S.createSnapSignMessageRequest)(e,t));return b(this,p,"f")[e]=s,s},s.default=k}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/AuthenticationController.cjs"}],[2441,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSnapSignMessageRequest=s.createSnapAllPublicKeysRequest=s.createSnapPublicKeyRequest=void 0;const r="npm:@metamask/message-signing-snap";s.createSnapPublicKeyRequest=function(e){return{snapId:r,origin:"metamask",handler:"onRpcRequest",request:{method:"getPublicKey",...e?{params:{entropySourceId:e}}:{}}}},s.createSnapAllPublicKeysRequest=function(){return{snapId:r,origin:"metamask",handler:"onRpcRequest",request:{method:"getAllPublicKeys"}}},s.createSnapSignMessageRequest=function(e,t){return{snapId:r,origin:"metamask",handler:"onRpcRequest",request:{method:"signMessage",params:{message:e,...t?{entropySourceId:t}:{}}}}}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/auth-snap-requests.cjs"}],[2442,{"./AuthenticationController.cjs":2440,"./mocks/index.cjs":2443},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)},i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return a(t,e),t},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.Mocks=s.Controller=void 0;const c=o(e("./AuthenticationController.cjs"));s.Controller=c.default;const l=c.default;s.default=l,n(e("./AuthenticationController.cjs"),s),s.Mocks=i(e("./mocks/index.cjs"))}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/index.cjs"}],[2443,{"./mockResponses.cjs":2444},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./mockResponses.cjs"),s)}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/index.cjs"}],[2444,{"../../../sdk/mocks/auth.cjs":2466},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getMockAuthAccessTokenResponse=s.MOCK_OATH_TOKEN_RESPONSE=s.getMockAuthLoginResponse=s.MOCK_LOGIN_RESPONSE=s.getMockAuthNonceResponse=s.MOCK_JWT=s.MOCK_NONCE=s.MOCK_NONCE_RESPONSE=void 0;const r=e("../../../sdk/mocks/auth.cjs");s.MOCK_NONCE_RESPONSE=r.MOCK_NONCE_RESPONSE,s.MOCK_NONCE=s.MOCK_NONCE_RESPONSE.nonce,s.MOCK_JWT=r.MOCK_JWT;s.getMockAuthNonceResponse=()=>({url:r.MOCK_NONCE_URL,requestMethod:"GET",response:(e,t,r)=>{const a=t?.split("?identifier=")[1],n=r?.(a??"");return{...s.MOCK_NONCE_RESPONSE,nonce:n??s.MOCK_NONCE_RESPONSE.nonce,identifier:s.MOCK_NONCE_RESPONSE.identifier}}}),s.MOCK_LOGIN_RESPONSE=r.MOCK_SRP_LOGIN_RESPONSE;s.getMockAuthLoginResponse=()=>({url:r.MOCK_SRP_LOGIN_URL,requestMethod:"POST",response:e=>{const t=e?.raw_message.split(":"),r=t?.[t.length-2];return{...s.MOCK_LOGIN_RESPONSE,token:r??s.MOCK_LOGIN_RESPONSE.token,profile:{...s.MOCK_LOGIN_RESPONSE.profile,profile_id:r??s.MOCK_LOGIN_RESPONSE.profile.profile_id,identifier_id:r??s.MOCK_LOGIN_RESPONSE.profile.identifier_id}}}}),s.MOCK_OATH_TOKEN_RESPONSE=r.MOCK_OIDC_TOKEN_RESPONSE;s.getMockAuthAccessTokenResponse=()=>({url:r.MOCK_OIDC_TOKEN_URL,requestMethod:"POST",response:e=>{const t=new URLSearchParams(e).get("assertion");return{...s.MOCK_OATH_TOKEN_RESPONSE,access_token:t??s.MOCK_OATH_TOKEN_RESPONSE.access_token}}})}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/mockResponses.cjs"}],[2445,{"../../sdk/index.cjs":2465,"../../shared/utils/event-queue.cjs":2478,"../authentication/auth-snap-requests.cjs":2441,"./constants.cjs":2446,"./contact-syncing/controller-integration.cjs":2448,"./contact-syncing/setup-subscriptions.cjs":2449,"@metamask/base-controller":1346,"@metamask/keyring-controller":2173},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h,f,m,p,g=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},b=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s};Object.defineProperty(s,"__esModule",{value:!0}),s.defaultState=void 0;const w=e("@metamask/base-controller"),y=e("@metamask/keyring-controller"),S=e("./constants.cjs"),v=e("./contact-syncing/controller-integration.cjs"),_=e("./contact-syncing/setup-subscriptions.cjs"),k=e("../../sdk/index.cjs"),E=e("../../shared/utils/event-queue.cjs"),T=e("../authentication/auth-snap-requests.cjs"),P="UserStorageController";s.defaultState={isBackupAndSyncEnabled:!0,isBackupAndSyncUpdateLoading:!1,isAccountSyncingEnabled:!0,isContactSyncingEnabled:!0,isContactSyncingInProgress:!1};const R={isBackupAndSyncEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},isBackupAndSyncUpdateLoading:{includeInStateLogs:!1,persist:!1,includeInDebugSnapshot:!1,usedInUi:!0},isAccountSyncingEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},isContactSyncingEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},isContactSyncingInProgress:{includeInStateLogs:!1,persist:!1,includeInDebugSnapshot:!1,usedInUi:!0}};class A extends w.BaseController{constructor({messenger:e,state:t,config:p,nativeScryptCrypto:w,trace:y}){super({messenger:e,metadata:R,name:P,state:{...s.defaultState,...t}}),r.add(this),a.set(this,void 0),n.set(this,{getProfileId:async e=>{const t=await this.messenger.call("AuthenticationController:getSessionProfile",e);return t?.profileId},isSignedIn:()=>this.messenger.call("AuthenticationController:isSignedIn"),signIn:async()=>await this.messenger.call("AuthenticationController:performSignIn")}),i.set(this,{env:k.Env.PRD}),o.set(this,void 0),c.set(this,!1),l.set(this,{}),d.set(this,{setupLockedStateSubscriptions:()=>{const{isUnlocked:e}=this.messenger.call("KeyringController:getState");b(this,c,e,"f"),this.messenger.subscribe("KeyringController:unlock",()=>{b(this,c,!0,"f")}),this.messenger.subscribe("KeyringController:lock",()=>{b(this,c,!1,"f")})}}),u.set(this,undefined),this.eventQueue=new E.EventQueue,f.set(this,{}),b(this,i,{...g(this,i,"f"),...p},"f"),b(this,o,y??(async(e,t)=>t?await Promise.resolve(t()):undefined),"f"),b(this,a,new k.UserStorage({env:g(this,i,"f").env,auth:{getAccessToken:e=>this.messenger.call("AuthenticationController:getBearerToken",e),getUserProfile:async e=>await this.messenger.call("AuthenticationController:getSessionProfile",e),signMessage:(e,t)=>g(this,r,"m",m).call(this,e,t)}},{storage:{getStorageKey:async e=>g(this,l,"f")[e]??null,setStorageKey:async(e,t)=>{g(this,l,"f")[e]=t}}}),"f"),g(this,d,"f").setupLockedStateSubscriptions(),g(this,r,"m",h).call(this),b(this,u,w,"f"),(0,_.setupContactSyncingSubscriptions)({getUserStorageControllerInstance:()=>this,getMessenger:()=>this.messenger,trace:g(this,o,"f")})}async performGetStorage(e,t){return await g(this,a,"f").getItem(e,{nativeScryptCrypto:g(this,u,"f"),entropySourceId:t})}async performGetStorageAllFeatureEntries(e,t){return await g(this,a,"f").getAllFeatureItems(e,{nativeScryptCrypto:g(this,u,"f"),entropySourceId:t})}async performSetStorage(e,t,s){return await g(this,a,"f").setItem(e,t,{nativeScryptCrypto:g(this,u,"f"),entropySourceId:s})}async performBatchSetStorage(e,t,s){return await g(this,a,"f").batchSetItems(e,t,{nativeScryptCrypto:g(this,u,"f"),entropySourceId:s})}async performDeleteStorage(e,t){return await g(this,a,"f").deleteItem(e,{nativeScryptCrypto:g(this,u,"f"),entropySourceId:t})}async performDeleteStorageAllFeatureEntries(e,t){return await g(this,a,"f").deleteAllFeatureItems(e,{nativeScryptCrypto:g(this,u,"f"),entropySourceId:t})}async performBatchDeleteStorage(e,t,s){return await g(this,a,"f").batchDeleteItems(e,t,{nativeScryptCrypto:g(this,u,"f"),entropySourceId:s})}async getStorageKey(){return await g(this,a,"f").getStorageKey()}flushStorageKeyCache(){b(this,l,{},"f")}async listEntropySources(){if(!g(this,c,"f"))throw new Error("listEntropySources - unable to list entropy sources, wallet is locked");const{keyrings:e}=this.messenger.call("KeyringController:getState");return e.filter(e=>e.type===y.KeyringTypes.hd.toString()).map(e=>e.metadata.id)}async setIsBackupAndSyncFeatureEnabled(e,t){try{if(g(this,r,"m",p).call(this,!0),t){g(this,n,"f").isSignedIn()||await g(this,n,"f").signIn()}this.update(s=>{e===S.BACKUPANDSYNC_FEATURES.main&&(s.isBackupAndSyncEnabled=t),e===S.BACKUPANDSYNC_FEATURES.accountSyncing&&(s.isAccountSyncingEnabled=t),e===S.BACKUPANDSYNC_FEATURES.contactSyncing&&(s.isContactSyncingEnabled=t)})}catch(s){const r=s instanceof Error?s.message:JSON.stringify(s);throw new Error(`${P} - failed to ${t?"enable":"disable"} ${e} - ${r}`)}finally{g(this,r,"m",p).call(this,!1)}}async setIsContactSyncingInProgress(e){this.update(t=>{t.isContactSyncingInProgress=e})}async syncContactsWithUserStorage(){const e=await g(this,n,"f").getProfileId(),t={onContactUpdated:()=>{g(this,i,"f")?.contactSyncing?.onContactUpdated?.(e)},onContactDeleted:()=>{g(this,i,"f")?.contactSyncing?.onContactDeleted?.(e)},onContactSyncErroneousSituation:(t,s)=>{g(this,i,"f")?.contactSyncing?.onContactSyncErroneousSituation?.(e,t,s)}};await(0,v.syncContactsWithUserStorage)(t,{getMessenger:()=>this.messenger,getUserStorageControllerInstance:()=>this,trace:g(this,o,"f")})}}a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,u=new WeakMap,f=new WeakMap,r=new WeakSet,h=function(){this.messenger.registerActionHandler("UserStorageController:performGetStorage",this.performGetStorage.bind(this)),this.messenger.registerActionHandler("UserStorageController:performGetStorageAllFeatureEntries",this.performGetStorageAllFeatureEntries.bind(this)),this.messenger.registerActionHandler("UserStorageController:performSetStorage",this.performSetStorage.bind(this)),this.messenger.registerActionHandler("UserStorageController:performBatchSetStorage",this.performBatchSetStorage.bind(this)),this.messenger.registerActionHandler("UserStorageController:performDeleteStorage",this.performDeleteStorage.bind(this)),this.messenger.registerActionHandler("UserStorageController:performBatchDeleteStorage",this.performBatchDeleteStorage.bind(this)),this.messenger.registerActionHandler("UserStorageController:getStorageKey",this.getStorageKey.bind(this))},m=async function(e,t){if(g(this,f,"f")[e])return g(this,f,"f")[e];if(!g(this,c,"f"))throw new Error("#snapSignMessage - unable to call snap, wallet is locked");const s=await this.messenger.call("SnapController:handleRequest",(0,T.createSnapSignMessageRequest)(e,t));return g(this,f,"f")[e]=s,s},p=function(e){this.update(t=>{t.isBackupAndSyncUpdateLoading=e})},s.default=A}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/UserStorageController.cjs"}],[2446,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.TraceName=s.BACKUPANDSYNC_FEATURES=void 0,s.BACKUPANDSYNC_FEATURES={main:"main",accountSyncing:"accountSyncing",contactSyncing:"contactSyncing"},s.TraceName={ContactSyncFull:"Contact Sync Full",ContactSyncSaveBatch:"Contact Sync Save Batch",ContactSyncUpdateRemote:"Contact Sync Update Remote",ContactSyncDeleteRemote:"Contact Sync Delete Remote"}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/constants.cjs"}],[2447,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.USER_STORAGE_VERSION=s.USER_STORAGE_VERSION_KEY=void 0,s.USER_STORAGE_VERSION_KEY="v",s.USER_STORAGE_VERSION="1"}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/contact-syncing/constants.cjs"}],[2448,{"../../../shared/storage-schema.cjs":2477,"../constants.cjs":2446,"./sync-utils.cjs":2450,"./utils.cjs":2451},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.deleteContactInRemoteStorage=s.updateContactInRemoteStorage=s.syncContactsWithUserStorage=void 0;const r=e("./sync-utils.cjs"),a=e("./utils.cjs"),n=e("./utils.cjs"),i=e("../../../shared/storage-schema.cjs"),o=e("../constants.cjs");function c(e){if(!e.address)throw new Error("Contact address is required to create storage key");return`${e.chainId}_${e.address.toLowerCase()}`}s.syncContactsWithUserStorage=async function(e,t){const{getMessenger:s,getUserStorageControllerInstance:l,trace:d}=t,{onContactSyncErroneousSituation:u,onContactUpdated:h,onContactDeleted:f}=e;if(!(0,r.canPerformContactSyncing)(t))return;const m=s().call("AddressBookController:list").filter(e=>!(0,n.isContactBridgedFromAccounts)(e)).filter(e=>e.address&&e.chainId&&e.name?.trim())||[],p=await async function(e){const{getUserStorageControllerInstance:t}=e;try{const e=await t().performGetStorageAllFeatureEntries(i.USER_STORAGE_FEATURE_NAMES.addressBook);if(!e||0===e.length)return null;return e.map(e=>{const t=JSON.parse(e);return(0,a.mapUserStorageEntryToAddressBookEntry)(t)})}catch{return null}}(t),g=p?.filter(e=>e.address&&e.chainId&&e.name?.trim())||[],b=async()=>{try{await l().setIsContactSyncingInProgress(!0);const e=new Map,r=new Map;m.forEach(t=>{const s=c(t);e.set(s,t)}),g.forEach(e=>{const t=c(e);r.set(t,e)});const n=[],d=[],u=[];for(const t of g){const s=c(t),r=e.get(s);if(t.deletedAt)r&&d.push(t);else if(r){if(r.name!==t.name||r.memo!==t.memo){const e=r.lastUpdatedAt||0;e>=(t.lastUpdatedAt||0)?u.push(r):n.push(t)}}else n.push(t)}for(const e of m){const t=c(e);r.get(t)||u.push(e)}for(const e of d)s().call("AddressBookController:delete",e.chainId,e.address),f&&f();for(const e of n)e.deletedAt||(s().call("AddressBookController:set",e.address,e.name||"",e.chainId,e.memo||"",e.addressType),h&&h());if(u.length>0){const e={};for(const t of u){const s=c(t);e[s]={...r.get(s),...t,lastUpdatedAt:Date.now()}}await async function(e,t){const{getUserStorageControllerInstance:s,trace:r}=t,n=async()=>{if(!e||0===e.length)return;const t=e.map(e=>{const t=c(e),s=(0,a.mapAddressBookEntryToUserStorageEntry)(e);return[t,JSON.stringify(s)]});await s().performBatchSetStorage(i.USER_STORAGE_FEATURE_NAMES.addressBook,t)};return r?await r({name:o.TraceName.ContactSyncSaveBatch,data:{contactCount:e.length,hasBatchOperations:e.length>1,chainCount:new Set(e.map(e=>e.chainId)).size,hasMemosCount:e.filter(e=>e.memo?.length).length}},n):await n()}(Object.values(e),t)}}catch(e){if(u)throw u("Error synchronizing contacts",{error:e}),e}finally{await l().setIsContactSyncingInProgress(!1)}};if(d){const e=m,t=g;return void await d({name:o.TraceName.ContactSyncFull,data:{localContactCount:e.length,remoteContactCount:t.length,isFirstSync:0===t.length&&e.length>0,isNewDeviceSync:0===e.length&&t.length>0,isRegularSync:e.length>0&&t.length>0,hasDataToSync:e.length>0||t.length>0,expectedWorkload:e.length+t.length}},b)}await b()},s.updateContactInRemoteStorage=async function(e,t){const{trace:s}=t,n=async()=>{if(!((0,r.canPerformContactSyncing)(t)&&e.address&&e.chainId&&e.name?.trim()))return;const{getUserStorageControllerInstance:s}=t,n={...e,lastUpdatedAt:e.lastUpdatedAt||Date.now()},o=c(e),l=(0,a.mapAddressBookEntryToUserStorageEntry)(n);await s().performSetStorage(`${i.USER_STORAGE_FEATURE_NAMES.addressBook}.${o}`,JSON.stringify(l))};return s?await s({name:o.TraceName.ContactSyncUpdateRemote,data:{chainId:e.chainId,hasTimestamp:Boolean(e.lastUpdatedAt),hasMemo:Boolean(e.memo?.length),isUpdate:Boolean(e.lastUpdatedAt)}},n):await n()},s.deleteContactInRemoteStorage=async function(e,t){const{trace:s}=t,n=async()=>{if(!((0,r.canPerformContactSyncing)(t)&&e.address&&e.chainId&&e.name?.trim()))return;const{getUserStorageControllerInstance:s}=t,n=c(e);try{const e=await s().performGetStorage(`${i.USER_STORAGE_FEATURE_NAMES.addressBook}.${n}`);if(e){const t=JSON.parse(e),r=(0,a.mapUserStorageEntryToAddressBookEntry)(t),o=Date.now(),c={...r,deletedAt:o,lastUpdatedAt:o},l=(0,a.mapAddressBookEntryToUserStorageEntry)(c);await s().performSetStorage(`${i.USER_STORAGE_FEATURE_NAMES.addressBook}.${n}`,JSON.stringify(l))}}catch{console.warn("Contact not found in remote storage for deletion:",n)}};return s?await s({name:o.TraceName.ContactSyncDeleteRemote},n):await n()}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/contact-syncing/controller-integration.cjs"}],[2449,{"./controller-integration.cjs":2448,"./sync-utils.cjs":2450,"./utils.cjs":2451},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.setupContactSyncingSubscriptions=void 0;const r=e("./controller-integration.cjs"),a=e("./sync-utils.cjs"),n=e("./utils.cjs");s.setupContactSyncingSubscriptions=function(e){const{getMessenger:t}=e;t().subscribe("AddressBookController:contactUpdated",t=>{(async()=>{if((0,a.canPerformContactSyncing)(e)&&!(0,n.isContactBridgedFromAccounts)(t))try{await(0,r.updateContactInRemoteStorage)(t,e)}catch(e){console.error("Error updating contact in remote storage:",e)}})()}),t().subscribe("AddressBookController:contactDeleted",t=>{(async()=>{if((0,a.canPerformContactSyncing)(e)&&!(0,n.isContactBridgedFromAccounts)(t))try{await(0,r.deleteContactInRemoteStorage)(t,e)}catch(e){console.error("Error deleting contact from remote storage:",e)}})()})}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/contact-syncing/setup-subscriptions.cjs"}],[245,{"./AbstractPetnamesBridge":243,"@metamask/name-controller":2276,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AddressBookPetnamesBridge=void 0;var r=e("@metamask/name-controller"),a=e("@metamask/utils"),n=e("./AbstractPetnamesBridge");function i(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function o(e,t){return e.get(c(e,t))}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var l=new WeakMap;class d extends n.AbstractPetnamesBridge{constructor({addressBookController:e,nameController:t,messenger:s}){var r,a,n;super({isTwoWay:!0,nameController:t,messenger:s}),i(this,l,void 0),a=this,n=e,(r=l).set(c(r,a),n)}getSourceEntries(){const e=[],{state:t}=o(l,this);for(const s of Object.keys(t.addressBook)){if(!(0,a.isStrictHexString)(s))continue;const n=t.addressBook[s];for(const a of Object.keys(n)){const n=t.addressBook[s][a],i=s.toLowerCase(),{name:o,isEns:c}=n;null!=o&&o.length&&null!=a&&a.length&&e.push({value:a,name:o,variation:i,type:r.NameType.ETHEREUM_ADDRESS,sourceId:c?"ens":undefined,origin:r.NameOrigin.ADDRESS_BOOK})}}return e}updateSourceEntry(e,t){e===n.ChangeType.DELETED?o(l,this).delete(t.variation,t.value):o(l,this).set(t.value,t.name,t.variation)}onSourceChange(e){this.messenger.subscribe("AddressBookController:stateChange",e)}}s.AddressBookPetnamesBridge=d}}},{package:"$root$",file:"app/scripts/lib/AddressBookPetnamesBridge.ts"}],[2450,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.canPerformContactSyncing=void 0,s.canPerformContactSyncing=function(e){const{getMessenger:t,getUserStorageControllerInstance:s}=e,{isBackupAndSyncEnabled:r,isContactSyncingEnabled:a,isContactSyncingInProgress:n}=s().state,i=t().call("AuthenticationController:isSignedIn");return!(!r||!a||n||!i)}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/contact-syncing/sync-utils.cjs"}],[2451,{"./constants.cjs":2447},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isContactBridgedFromAccounts=s.mapUserStorageEntryToAddressBookEntry=s.mapAddressBookEntryToUserStorageEntry=void 0;const r=e("./constants.cjs");s.mapAddressBookEntryToUserStorageEntry=e=>{const{address:t,name:s,chainId:a,memo:n,addressType:i,isEns:o,lastUpdatedAt:c,deletedAt:l}=e,d=Date.now();return{[r.USER_STORAGE_VERSION_KEY]:r.USER_STORAGE_VERSION,a:t,n:s,c:a,...n?{m:n}:{},...i?{t:i}:{},...o?{e:o}:{},lu:c||d,...l?{dt:l}:{}}};s.mapUserStorageEntryToAddressBookEntry=e=>({address:e.a,name:e.n,chainId:e.c,memo:e.m||"",isEns:e.e||!1,...e.t?{addressType:e.t}:{},...e.dt?{deletedAt:e.dt}:{},...e.lu?{lastUpdatedAt:e.lu}:{}});s.isContactBridgedFromAccounts=e=>"*"===String(e.chainId)}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/contact-syncing/utils.cjs"}],[2452,{"../../shared/encryption/index.cjs":2474,"../../shared/storage-schema.cjs":2477,"./UserStorageController.cjs":2445,"./constants.cjs":2446,"./mocks/index.cjs":2453},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)},i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return a(t,e),t},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.Mocks=s.Controller=void 0;const c=o(e("./UserStorageController.cjs"));s.Controller=c.default;const l=c.default;s.default=l,n(e("./UserStorageController.cjs"),s),s.Mocks=i(e("./mocks/index.cjs")),n(e("./constants.cjs"),s),n(e("../../shared/encryption/index.cjs"),s),n(e("../../shared/storage-schema.cjs"),s)}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/index.cjs"}],[2453,{"./mockResponses.cjs":2454,"./mockStorage.cjs":2455},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./mockResponses.cjs"),s),a(e("./mockStorage.cjs"),s)}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/mocks/index.cjs"}],[2454,{"../../../sdk/index.cjs":2465,"../../../shared/storage-schema.cjs":2477,"./mockStorage.cjs":2455},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.deleteMockUserStorageAllFeatureEntriesResponse=s.deleteMockUserStorageResponse=s.getMockUserStorageBatchDeleteResponse=s.getMockUserStorageBatchPutResponse=s.getMockUserStoragePutResponse=s.getMockUserStorageAllFeatureEntriesResponse=s.getMockUserStorageGetResponse=s.createMockAllFeatureEntriesResponse=s.createMockGetStorageResponse=s.getMockUserStorageEndpoint=void 0;const r=e("./mockStorage.cjs"),a=e("../../../sdk/index.cjs"),n=e("../../../shared/storage-schema.cjs");async function i(e){return{HashedKey:"HASHED_KEY",Data:await(0,r.MOCK_ENCRYPTED_STORAGE_DATA)(e)}}async function o(e=[r.MOCK_STORAGE_DATA]){const t=[];for(const s of e)t.push({HashedKey:"HASHED_KEY",Data:await(0,r.MOCK_ENCRYPTED_STORAGE_DATA)(s)});return t}s.getMockUserStorageEndpoint=e=>1===e.split(".").length?`${(0,a.getEnvUrls)(a.Env.PRD).userStorageApiUrl}/api/v1/userstorage/${e}`:`${(0,a.getEnvUrls)(a.Env.PRD).userStorageApiUrl}/api/v1/userstorage/${(0,n.createEntryPath)(e,r.MOCK_STORAGE_KEY)}`,s.createMockGetStorageResponse=i,s.createMockAllFeatureEntriesResponse=o,s.getMockUserStorageGetResponse=async function(e=`${n.USER_STORAGE_FEATURE_NAMES.notifications}.notification_settings`){return{url:(0,s.getMockUserStorageEndpoint)(e),requestMethod:"GET",response:await i()}},s.getMockUserStorageAllFeatureEntriesResponse=async function(e=n.USER_STORAGE_FEATURE_NAMES.notifications,t){return{url:(0,s.getMockUserStorageEndpoint)(e),requestMethod:"GET",response:await o(t)}};s.getMockUserStoragePutResponse=(e=`${n.USER_STORAGE_FEATURE_NAMES.notifications}.notification_settings`)=>({url:(0,s.getMockUserStorageEndpoint)(e),requestMethod:"PUT",response:null});s.getMockUserStorageBatchPutResponse=(e=n.USER_STORAGE_FEATURE_NAMES.notifications)=>({url:(0,s.getMockUserStorageEndpoint)(e),requestMethod:"PUT",response:null});s.getMockUserStorageBatchDeleteResponse=(e=n.USER_STORAGE_FEATURE_NAMES.notifications)=>({url:(0,s.getMockUserStorageEndpoint)(e),requestMethod:"PUT",response:null});s.deleteMockUserStorageResponse=(e=`${n.USER_STORAGE_FEATURE_NAMES.notifications}.notification_settings`)=>({url:(0,s.getMockUserStorageEndpoint)(e),requestMethod:"DELETE",response:null});s.deleteMockUserStorageAllFeatureEntriesResponse=(e=n.USER_STORAGE_FEATURE_NAMES.notifications)=>({url:(0,s.getMockUserStorageEndpoint)(e),requestMethod:"DELETE",response:null})}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/mocks/mockResponses.cjs"}],[2455,{"../../../shared/encryption/index.cjs":2474},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return a(t,e),t};Object.defineProperty(s,"__esModule",{value:!0}),s.MOCK_ENCRYPTED_STORAGE_DATA=s.MOCK_STORAGE_DATA=s.MOCK_STORAGE_KEY=s.MOCK_STORAGE_KEY_SIGNATURE=void 0;const i=n(e("../../../shared/encryption/index.cjs"));let o;s.MOCK_STORAGE_KEY_SIGNATURE="mockStorageKey",s.MOCK_STORAGE_KEY=(0,i.createSHA256Hash)(s.MOCK_STORAGE_KEY_SIGNATURE),s.MOCK_STORAGE_DATA=JSON.stringify({hello:"world"});s.MOCK_ENCRYPTED_STORAGE_DATA=async e=>o??(o=await i.default.encryptString(e??s.MOCK_STORAGE_DATA,s.MOCK_STORAGE_KEY))}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/controllers/user-storage/mocks/mockStorage.cjs"}],[2456,{"./controllers/authentication/index.cjs":2442,"./controllers/user-storage/index.cjs":2452,"./sdk/index.cjs":2465},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return a(t,e),t};Object.defineProperty(s,"__esModule",{value:!0}),s.UserStorageController=s.AuthenticationController=s.SDK=void 0,s.SDK=n(e("./sdk/index.cjs")),s.AuthenticationController=n(e("./controllers/authentication/index.cjs")),s.UserStorageController=n(e("./controllers/user-storage/index.cjs"))}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/index.cjs"}],[2457,{"../errors.cjs":2464,"../utils/validate-login-response.cjs":2470,"./services.cjs":2459,siwe:5557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.SIWEJwtBearerAuth=void 0;const f=e("siwe"),m=e("./services.cjs"),p=e("../errors.cjs"),g=e("../utils/validate-login-response.cjs");s.SIWEJwtBearerAuth=class{constructor(e,t){r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),u(this,a,e,"f"),u(this,n,t,"f")}async getAccessToken(){const e=await h(this,r,"m",o).call(this);if(e)return e.token.accessToken;return(await h(this,r,"m",c).call(this)).token.accessToken}async getUserProfile(){const e=await h(this,r,"m",o).call(this);if(e)return e.profile;return(await h(this,r,"m",c).call(this)).profile}async getIdentifier(){return h(this,r,"m",d).call(this,h(this,i,"f")),h(this,i,"f").address}async getUserProfileLineage(){const e=await this.getAccessToken();return await(0,m.getUserProfileLineage)(h(this,a,"f").env,e)}async signMessage(e){return h(this,r,"m",d).call(this,h(this,i,"f")),await h(this,i,"f").signMessage(e)}prepare(e){u(this,i,e,"f")}},a=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakSet,o=async function(){const e=await h(this,n,"f").storage.getLoginResponse();if(!(0,g.validateLoginResponse)(e))return null;return Date.now()-e.token.obtainedAt<1e3*e.token.expiresIn*.9?e:null},c=async function(){h(this,r,"m",d).call(this,h(this,i,"f"));const e=await this.getIdentifier(),t=await(0,m.getNonce)(e,h(this,a,"f").env),s=h(this,r,"m",l).call(this,t.nonce),o=await this.signMessage(s),c=await(0,m.authenticate)(s,o,h(this,a,"f").type,h(this,a,"f").env),u=await(0,m.authorizeOIDC)(c.token,h(this,a,"f").env,h(this,a,"f").platform),f={profile:c.profile,token:u};return await h(this,n,"f").storage.setLoginResponse(f),f},l=function(e){return h(this,r,"m",d).call(this,h(this,i,"f")),new f.SiweMessage({domain:h(this,i,"f")?.domain,address:h(this,i,"f")?.address,uri:(0,m.SIWE_LOGIN_URL)(h(this,a,"f").env),version:"1",chainId:h(this,i,"f")?.chainId,nonce:e,issuedAt:(new Date).toISOString()}).prepareMessage()},d=function(e){if(!e)throw new p.ValidationError("you must call 'prepare()' before logging in")}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/authentication-jwt-bearer/flow-siwe.cjs"}],[2458,{"../errors.cjs":2464,"../utils/eip-6963-metamask-provider.cjs":2468,"../utils/messaging-signing-snap-requests.cjs":2469,"../utils/validate-login-response.cjs":2470,"./services.cjs":2459,"./utils/time.cjs":2461},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h,f,m,p,g,b=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),w=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),y=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&b(t,e,s);return w(t,e),t},S=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},v=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.SRPJwtBearerAuth=void 0;const _=e("./services.cjs"),k=y(e("./utils/time.cjs")),E=e("../errors.cjs"),T=e("../utils/eip-6963-metamask-provider.cjs"),P=e("../utils/messaging-signing-snap-requests.cjs"),R=e("../utils/validate-login-response.cjs"),A=async()=>{const e=await(0,T.getMetaMaskProviderEIP6963)();if(!e)throw new E.ValidationError("No MetaMask wallet connected");return e},C=e=>({getIdentifier:async t=>{const s=e??await A();return await P.MESSAGE_SIGNING_SNAP.getPublicKey(s,t)},signMessage:async(t,s)=>{const r=e??await A();return(0,P.assertMessageStartsWithMetamask)(t),await P.MESSAGE_SIGNING_SNAP.signMessage(r,t,s)}});s.SRPJwtBearerAuth=class{constructor(e,t){r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),o.set(this,new Map),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),S(this,a,e,"f"),S(this,d,t.customProvider,"f"),S(this,n,{storage:t.storage,signing:t.signing??C(v(this,d,"f"))},"f"),S(this,i,t.metametrics,"f"),S(this,c,t.rateLimitRetry?.cooldownDefaultMs??1e4,"f"),S(this,l,t.rateLimitRetry?.maxLoginRetries??1,"f")}setCustomProvider(e){S(this,d,e,"f"),v(this,n,"f").signing=C(e)}async getAccessToken(e){const t=await v(this,r,"m",u).call(this,e);if(t)return t.token.accessToken;return(await v(this,r,"m",h).call(this,e)).token.accessToken}async getUserProfile(e){const t=await v(this,r,"m",u).call(this,e);if(t)return t.profile;return(await v(this,r,"m",h).call(this,e)).profile}async getIdentifier(e){return await v(this,n,"f").signing.getIdentifier(e)}async getUserProfileLineage(){const e=await this.getAccessToken();return await(0,_.getUserProfileLineage)(v(this,a,"f").env,e)}async signMessage(e,t){return await v(this,n,"f").signing.signMessage(e,t)}async isSnapConnected(){const e=v(this,d,"f")??await A();if(!e)return!1;return await(0,P.isSnapConnected)(e)}async connectSnap(){const e=v(this,d,"f")??await A();return await(0,P.connectSnap)(e)}},a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,r=new WeakSet,u=async function(e){const t=await v(this,n,"f").storage.getLoginResponse(e);if(!(0,R.validateLoginResponse)(t))return null;return Date.now()-t.token.obtainedAt<1e3*t.token.expiresIn*.9?t:null},h=async function(e){return await v(this,r,"m",m).call(this,e)},f=async function(e){const t=await this.getIdentifier(e),s=await(0,_.getNonce)(t,v(this,a,"f").env),o=v(this,r,"m",g).call(this,s.nonce,t),c=await this.signMessage(o,e),l=await(0,_.authenticate)(o,c,v(this,a,"f").type,v(this,a,"f").env,v(this,i,"f")),d=await(0,_.authorizeOIDC)(l.token,v(this,a,"f").env,v(this,a,"f").platform),u={profile:l.profile,token:d};return await v(this,n,"f").storage.setLoginResponse(u,e),u},m=async function(e){const t=e??"__default__",s=v(this,o,"f").get(t);if(s)return s;const a=v(this,r,"m",p).call(this,e);v(this,o,"f").set(t,a);try{return await a}finally{v(this,o,"f").delete(t)}},p=async function(e){for(let t=0;t<1+v(this,l,"f");t+=1)try{return await v(this,r,"m",f).call(this,e)}catch(e){if(!E.RateLimitedError.isRateLimitError(e))throw e;if(t>=v(this,l,"f"))throw e;const s=e.retryAfterMs??v(this,c,"f");await k.delay(s)}throw new Error("Unexpected: login loop exhausted without result")},g=function(e,t){return`metamask:${e}:${t}`}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/authentication-jwt-bearer/flow-srp.cjs"}],[2459,{"../../shared/env.cjs":2476,"../constants.cjs":2463,"../errors.cjs":2464,"./types.cjs":2460},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getUserProfileLineage=s.authenticate=s.authorizeOIDC=s.getNonce=s.pairIdentifiers=s.PROFILE_LINEAGE_URL=s.SIWE_LOGIN_URL=s.SRP_LOGIN_URL=s.OIDC_TOKEN_URL=s.PAIR_IDENTIFIERS=s.NONCE_URL=void 0;const r=e("./types.cjs"),a=e("../../shared/env.cjs"),n=e("../constants.cjs"),i=e("../errors.cjs");async function o(e,t){const{status:s}=e,r=function(e){if(!e)return null;const t=Number(e);if(!Number.isNaN(t))return 1e3*t;const s=Date.parse(e);if(!Number.isNaN(s)){const e=s-Date.now();return e>0?e:null}return null}(e.headers.get("Retry-After")),a=await e.json(),o="message"in a?a.message:a.error_description,{error:c}=a;if(s===n.HTTP_STATUS_CODES.TOO_MANY_REQUESTS)throw new i.RateLimitedError(`HTTP ${n.HTTP_STATUS_CODES.TOO_MANY_REQUESTS}: ${o} (error: ${c})`,r??undefined);throw new Error(`${t?`${t} `:""}HTTP ${s} error: ${o}, error: ${c}`)}s.NONCE_URL=e=>`${(0,a.getEnvUrls)(e).authApiUrl}/api/v2/nonce`;s.PAIR_IDENTIFIERS=e=>`${(0,a.getEnvUrls)(e).authApiUrl}/api/v2/identifiers/pair`;s.OIDC_TOKEN_URL=e=>`${(0,a.getEnvUrls)(e).oidcApiUrl}/oauth2/token`;s.SRP_LOGIN_URL=e=>`${(0,a.getEnvUrls)(e).authApiUrl}/api/v2/srp/login`;s.SIWE_LOGIN_URL=e=>`${(0,a.getEnvUrls)(e).authApiUrl}/api/v2/siwe/login`;s.PROFILE_LINEAGE_URL=e=>`${(0,a.getEnvUrls)(e).authApiUrl}/api/v2/profile/lineage`;s.pairIdentifiers=async function(e,t,r,a){const n=new URL((0,s.PAIR_IDENTIFIERS)(a));try{const s=await fetch(n,{method:"POST",headers:{"Content-Type":"application/json",Authorization:`Bearer ${r}`},body:JSON.stringify({nonce:e,logins:t})});s.ok||await o(s)}catch(e){if(i.RateLimitedError.isRateLimitError(e))throw e;const t=e instanceof Error?e.message:JSON.stringify(e??"");throw new i.PairError(`unable to pair identifiers: ${t}`)}},s.getNonce=async function(e,t){const r=new URL((0,s.NONCE_URL)(t));r.searchParams.set("identifier",e);try{const e=await fetch(r.toString());e.ok||await o(e);const t=await e.json();return{nonce:t.nonce,identifier:t.identifier,expiresIn:t.expires_in}}catch(e){if(i.RateLimitedError.isRateLimitError(e))throw e;const t=e instanceof Error?e.message:JSON.stringify(e??"");throw new i.NonceRetrievalError(`failed to generate nonce: ${t}`)}},s.authorizeOIDC=async function(e,t,r){const n=new Headers({"Content-Type":"application/x-www-form-urlencoded"}),c=new URLSearchParams;c.append("grant_type","urn:ietf:params:oauth:grant-type:jwt-bearer"),c.append("client_id",(0,a.getOidcClientId)(t,r)),c.append("assertion",e);try{const e=await fetch((0,s.OIDC_TOKEN_URL)(t),{method:"POST",headers:n,body:c.toString()});e.ok||await o(e);const r=await e.json();return{accessToken:r.access_token,expiresIn:r.expires_in,obtainedAt:Date.now()}}catch(e){if(i.RateLimitedError.isRateLimitError(e))throw e;const t=e instanceof Error?e.message:JSON.stringify(e??"");throw new i.SignInError(`unable to get access token: ${t}`)}},s.authenticate=async function(e,t,a,n,c){const l=((e,t)=>{switch(e){case r.AuthType.SRP:return(0,s.SRP_LOGIN_URL)(t);case r.AuthType.SiWE:return(0,s.SIWE_LOGIN_URL)(t);default:throw new i.ValidationError(`Invalid AuthType: ${e} - unable to create Auth URL`)}})(a,n);try{const s=await fetch(l,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify({signature:t,raw_message:e,...c?{metametrics:{metametrics_id:await c.getMetaMetricsId(),agent:c.agent}}:{}})});s.ok||await o(s,`${a} login`);const r=await s.json();return{token:r.token,expiresIn:r.expires_in,profile:{identifierId:r.profile.identifier_id,metaMetricsId:r.profile.metametrics_id,profileId:r.profile.profile_id}}}catch(e){if(i.RateLimitedError.isRateLimitError(e))throw e;const t=e instanceof Error?e.message:JSON.stringify(e??"");throw new i.SignInError(`unable to perform SRP login: ${t}`)}},s.getUserProfileLineage=async function(e,t){const r=new URL((0,s.PROFILE_LINEAGE_URL)(e));try{const e=await fetch(r,{method:"GET",headers:{Authorization:`Bearer ${t}`}});e.ok||await o(e,"profile lineage");return await e.json()}catch(e){if(i.RateLimitedError.isRateLimitError(e))throw e;const t=e instanceof Error?e.message:JSON.stringify(e??"");throw new i.SignInError(`failed to get profile lineage: ${t}`)}}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/authentication-jwt-bearer/services.cjs"}],[246,{"@metamask/base-controller":1346,"@metamask/obs-store":2368},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var r=e("@metamask/obs-store"),a=e("@metamask/base-controller");function n(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function i(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function o(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}function c(e,t){return(0,a.deriveStateFromMetadata)(e,t,"persist")}var l=new WeakSet;class d extends r.ObservableStore{constructor({config:e,controllerMessenger:t,state:s,persist:r}){super(s),n(this,l),i(this,"config",{}),this.persist=r,this.controllerMessenger=t,e&&this.updateStructure(e)}updateStructure(e){this.config=e,this.removeAllListeners();const t={};for(const r of Object.keys(e)){var s;if(!e[r])throw new Error(`Undefined '${r}'`);const a=e[r];a.subscribe?e[r].subscribe(e=>{o(l,this,u).call(this,r,e)}):this.persist?this.controllerMessenger.subscribe(`${a.name}:stateChange`,(t,s)=>{o(l,this,h).call(this,e[r].metadata,s)&&o(l,this,u).call(this,r,c(t,e[r].metadata),s)}):this.controllerMessenger.subscribe(`${a.name}:stateChange`,(e,t)=>o(l,this,u).call(this,r,e,t));const n=a.state??(null===(s=a.getState)||void 0===s?void 0:s.call(a));t[r]=this.persist&&e[r].metadata?c(n,e[r].metadata):n}this.updateState(t)}getFlatState(){if(!this.config)return{};const e={};for(const t of Object.keys(this.config)){const s=this.config[t],r=s.getState?s.getState():s.state;Object.assign(e,r)}return e}}function u(e,t,s){const r=this.getState()[e];this.updateState({[e]:t}),this.emit("stateChange",{controllerKey:e,newState:t,oldState:r,patches:s})}function h(e,t){return t.some(t=>{if(0===t.path.length)return!0;const s=t.path[0];return!e[s]||e[s].persist})}s.default=d}}},{package:"$root$",file:"app/scripts/lib/ComposableObservableStore.js"}],[2460,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r;Object.defineProperty(s,"__esModule",{value:!0}),s.AuthType=void 0,function(e){e.SRP="SRP",e.SiWE="SiWE"}(r||(s.AuthType=r={}))}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/authentication-jwt-bearer/types.cjs"}],[2461,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.delay=void 0,s.delay=async function(e){e<=0||await new Promise(t=>setTimeout(t,e))}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/authentication-jwt-bearer/utils/time.cjs"}],[2462,{"./authentication-jwt-bearer/flow-siwe.cjs":2457,"./authentication-jwt-bearer/flow-srp.cjs":2458,"./authentication-jwt-bearer/services.cjs":2459,"./authentication-jwt-bearer/types.cjs":2460,"./errors.cjs":2464},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),d=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||l(t,e,s)},u=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.SRPJwtBearerAuth=s.SIWEJwtBearerAuth=s.JwtBearerAuth=void 0;const f=e("./authentication-jwt-bearer/flow-siwe.cjs"),m=e("./authentication-jwt-bearer/flow-srp.cjs"),p=e("./authentication-jwt-bearer/services.cjs"),g=e("./authentication-jwt-bearer/types.cjs"),b=e("./errors.cjs");s.JwtBearerAuth=class{constructor(...e){if(r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),u(this,a,e[0].type,"f"),u(this,n,e[0].env,"f"),e[0].type!==g.AuthType.SRP){if(e[0].type!==g.AuthType.SiWE)throw new b.UnsupportedAuthTypeError("unsupported auth type");u(this,i,new f.SIWEJwtBearerAuth(e[0],e[1]),"f")}else u(this,i,new m.SRPJwtBearerAuth(e[0],e[1]),"f")}setCustomProvider(e){h(this,r,"m",c).call(this,h(this,a,"f"),h(this,i,"f")),h(this,i,"f").setCustomProvider(e)}async getAccessToken(e){return await h(this,i,"f").getAccessToken(e)}async connectSnap(){return h(this,r,"m",c).call(this,h(this,a,"f"),h(this,i,"f")),h(this,i,"f").connectSnap()}async isSnapConnected(){return h(this,r,"m",c).call(this,h(this,a,"f"),h(this,i,"f")),h(this,i,"f").isSnapConnected()}async getUserProfile(e){return await h(this,i,"f").getUserProfile(e)}async getIdentifier(e){return await h(this,i,"f").getIdentifier(e)}async getUserProfileLineage(){return await h(this,i,"f").getUserProfileLineage()}async signMessage(e,t){return await h(this,i,"f").signMessage(e,t)}async pairIdentifiers(e){const t=await this.getUserProfile(),s=await(0,p.getNonce)(t.profileId,h(this,n,"f")),r=await Promise.all(e.map(async e=>{try{const t=`metamask:${s.nonce}:${e.identifier}`;return{signature:await e.signMessage(t),raw_message:t,encrypted_storage_key:e.encryptedStorageKey,identifier_type:e.identifierType}}catch(e){const t=e instanceof Error?e.message:JSON.stringify(e??"");throw new b.PairError(`failed to sign pairing message: ${t}`)}})),a=await this.getAccessToken();await(0,p.pairIdentifiers)(s.nonce,r,a,h(this,n,"f"))}prepare(e){h(this,r,"m",o).call(this,h(this,a,"f"),h(this,i,"f")),h(this,i,"f").prepare(e)}},a=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakSet,o=function(e,t){if(e!==g.AuthType.SiWE)throw new b.UnsupportedAuthTypeError("This method is only available via SIWE auth type")},c=function(e,t){if(e!==g.AuthType.SRP)throw new b.UnsupportedAuthTypeError("This method is only available via SRP auth type")};var w=e("./authentication-jwt-bearer/flow-siwe.cjs");Object.defineProperty(s,"SIWEJwtBearerAuth",{enumerable:!0,get:function(){return w.SIWEJwtBearerAuth}});var y=e("./authentication-jwt-bearer/flow-srp.cjs");Object.defineProperty(s,"SRPJwtBearerAuth",{enumerable:!0,get:function(){return y.SRPJwtBearerAuth}}),d(e("./authentication-jwt-bearer/types.cjs"),s)}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/authentication.cjs"}],[2463,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.HTTP_STATUS_CODES=void 0,s.HTTP_STATUS_CODES={TOO_MANY_REQUESTS:429}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/constants.cjs"}],[2464,{"./constants.cjs":2463},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitedError=s.NotFoundError=s.UnsupportedAuthTypeError=s.ValidationError=s.UserStorageError=s.PairError=s.SignInError=s.NonceRetrievalError=void 0;const r=e("./constants.cjs");class a extends Error{constructor(e){super(e),this.name="NonceRetrievalError"}}s.NonceRetrievalError=a;class n extends Error{constructor(e){super(e),this.name="SignInError"}}s.SignInError=n;class i extends Error{constructor(e){super(e),this.name="PairError"}}s.PairError=i;class o extends Error{constructor(e){super(e),this.name="UserStorageError"}}s.UserStorageError=o;class c extends Error{constructor(e){super(e),this.name="ValidationError"}}s.ValidationError=c;class l extends Error{constructor(e){super(e),this.name="UnsupportedAuthTypeError"}}s.UnsupportedAuthTypeError=l;class d extends Error{constructor(e){super(e),this.name="NotFoundError"}}s.NotFoundError=d;class u extends Error{constructor(e,t){super(e),this.status=r.HTTP_STATUS_CODES.TOO_MANY_REQUESTS,this.name="RateLimitedError",this.retryAfterMs=t}static isRateLimitError(e){return e instanceof u||"object"==typeof e&&null!==e&&"status"in e&&e.status===r.HTTP_STATUS_CODES.TOO_MANY_REQUESTS}}s.RateLimitedError=u}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/errors.cjs"}],[2465,{"../shared/encryption/index.cjs":2474,"../shared/env.cjs":2476,"../shared/storage-schema.cjs":2477,"./authentication.cjs":2462,"./errors.cjs":2464,"./user-storage.cjs":2467,"./utils/messaging-signing-snap-requests.cjs":2469},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./authentication.cjs"),s),a(e("./user-storage.cjs"),s),a(e("./errors.cjs"),s),a(e("./utils/messaging-signing-snap-requests.cjs"),s),a(e("../shared/encryption/index.cjs"),s),a(e("../shared/env.cjs"),s),a(e("../shared/storage-schema.cjs"),s)}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/index.cjs"}],[2466,{"../../shared/env.cjs":2476,"../authentication-jwt-bearer/services.cjs":2459},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MOCK_USER_PROFILE_LINEAGE_RESPONSE=s.MOCK_OIDC_TOKEN_RESPONSE=s.MOCK_SRP_LOGIN_RESPONSE=s.MOCK_SIWE_LOGIN_RESPONSE=s.MOCK_NONCE_RESPONSE=s.MOCK_ACCESS_JWT=s.MOCK_JWT=s.MOCK_PROFILE_LINEAGE_URL=s.MOCK_PAIR_IDENTIFIERS_URL=s.MOCK_SIWE_LOGIN_URL=s.MOCK_OIDC_TOKEN_URL=s.MOCK_SRP_LOGIN_URL=s.MOCK_NONCE_URL=void 0;const r=e("../../shared/env.cjs"),a=e("../authentication-jwt-bearer/services.cjs");s.MOCK_NONCE_URL=(0,a.NONCE_URL)(r.Env.PRD),s.MOCK_SRP_LOGIN_URL=(0,a.SRP_LOGIN_URL)(r.Env.PRD),s.MOCK_OIDC_TOKEN_URL=(0,a.OIDC_TOKEN_URL)(r.Env.PRD),s.MOCK_SIWE_LOGIN_URL=(0,a.SIWE_LOGIN_URL)(r.Env.PRD),s.MOCK_PAIR_IDENTIFIERS_URL=(0,a.PAIR_IDENTIFIERS)(r.Env.PRD),s.MOCK_PROFILE_LINEAGE_URL=(0,a.PROFILE_LINEAGE_URL)(r.Env.PRD),s.MOCK_JWT="eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6ImIwNzE2N2U2LWJjNWUtNDgyZC1hNjRhLWU1MjQ0MjY2MGU3NyJ9.eyJzdWIiOiI1MzE0ODc5YWM2NDU1OGI3OTQ5ZmI4NWIzMjg2ZjZjNjUwODAzYmFiMTY0Y2QyOWNmMmM3YzdmMjMzMWMwZTRlIiwiaWF0IjoxNzA2MTEzMDYyLCJleHAiOjE3NjkxODUwNjMsImlzcyI6ImF1dGgubWV0YW1hc2suaW8iLCJhdWQiOiJwb3J0Zm9saW8ubWV0YW1hc2suaW8ifQ.E5UL6oABNweS8t5a6IBTqTf7NLOJbrhJSmEcsr7kwLp4bGvcENJzACwnsHDkA6PlzfDV09ZhAGU_F3hlS0j-erbY0k0AFR-GAtyS7E9N02D8RgUDz5oDR65CKmzM8JilgFA8UvruJ6OJGogroaOSOqzRES_s8MjHpP47RJ9lXrUesajsbOudXbuksXWg5QmWip6LLvjwr8UUzcJzNQilyIhiEpo4WdzWM4R3VtTwr4rHnWEvtYnYCov1jmI2w3YQ48y0M-3Y9IOO0ov_vlITRrOnR7Y7fRUGLUFmU5msD8mNWRywjQFLHfJJ1yNP5aJ8TkuCK3sC6kcUH335IVvukQ",s.MOCK_ACCESS_JWT="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c",s.MOCK_NONCE_RESPONSE={nonce:"xGMm9SoihEKeAEfV",identifier:"0xd8641601Cb79a94FD872fE42d5b4a067A44a7e88",expires_in:300},s.MOCK_SIWE_LOGIN_RESPONSE={token:s.MOCK_JWT,expires_in:3600,profile:{profile_id:"fa2bbf82-bd9a-4e6b-aabc-9ca0d0319b6e",metametrics_id:"de742679-4960-4977-a415-4718b5f8e86c",identifier_id:"ec9a4e9906836497efad2fd4d4290b34d2c6a2c0d93eb174aa3cd88a133adbaf",identifier_type:"SIWE",encrypted_storage_key:"2c6a2c0d93eb174aa3cd88a133adbaf"}},s.MOCK_SRP_LOGIN_RESPONSE={token:s.MOCK_JWT,expires_in:3600,profile:{profile_id:"f88227bd-b615-41a3-b0be-467dd781a4ad",metametrics_id:"561ec651-a844-4b36-a451-04d6eac35740",identifier_id:"da9a9fc7b09edde9cc23cec9b7e11a71fb0ab4d2ddd8af8af905306f3e1456fb",identifier_type:"SRP",encrypted_storage_key:"d2ddd8af8af905306f3e1456fb"}},s.MOCK_OIDC_TOKEN_RESPONSE={access_token:s.MOCK_ACCESS_JWT,expires_in:3600},s.MOCK_USER_PROFILE_LINEAGE_RESPONSE={profile_id:"f88227bd-b615-41a3-b0be-467dd781a4ad",created_at:"2025-10-01T12:00:00Z",lineage:[{metametrics_id:"561ec651-a844-4b36-a451-04d6eac35740",agent:r.Platform.MOBILE,created_at:"2025-10-01T12:00:00Z",updated_at:"2025-10-01T12:00:00Z",counter:1},{metametrics_id:"de742679-4960-4977-a415-4718b5f8e86c",agent:r.Platform.EXTENSION,created_at:"2025-10-01T12:00:00Z",updated_at:"2025-10-01T12:00:00Z",counter:2}]}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/mocks/auth.cjs"}],[2467,{"../shared/encryption/constants.cjs":2472,"../shared/encryption/index.cjs":2474,"../shared/env.cjs":2476,"../shared/storage-schema.cjs":2477,"./errors.cjs":2464},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h,f,m=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),p=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),g=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&m(t,e,s);return p(t,e),t},b=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.UserStorage=s.STORAGE_URL=void 0;const w=e("./errors.cjs"),y=g(e("../shared/encryption/index.cjs")),S=e("../shared/encryption/constants.cjs"),v=e("../shared/env.cjs"),_=e("../shared/storage-schema.cjs");s.STORAGE_URL=(e,t)=>`${(0,v.getEnvUrls)(e).userStorageApiUrl}/api/v1/userstorage/${t}`;s.UserStorage=class{constructor(e,t){r.add(this),this.env=e.env,this.config=e,this.options=t}async setItem(e,t,s){await b(this,r,"m",a).call(this,e,t,s)}async batchSetItems(e,t,s){await b(this,r,"m",n).call(this,e,t,s)}async getItem(e,t){return b(this,r,"m",o).call(this,e,t)}async getAllFeatureItems(e,t){return b(this,r,"m",c).call(this,e,t)}async deleteItem(e,t){return b(this,r,"m",l).call(this,e,t)}async deleteAllFeatureItems(e,t){return b(this,r,"m",d).call(this,e,t)}async batchDeleteItems(e,t,s){return b(this,r,"m",u).call(this,e,t,s)}async getStorageKey(e){const t=`metamask:${(await this.config.auth.getUserProfile(e)).profileId}`,s=await(this.options.storage?.getStorageKey(t));if(s)return s;const r=await this.config.auth.signMessage(t,e),a=(0,y.createSHA256Hash)(r);return await(this.options.storage?.setStorageKey(t,a)),a}},r=new WeakSet,a=async function(e,t,a){const n=a?.entropySourceId;try{const i=await b(this,r,"m",f).call(this,n),o=await this.getStorageKey(n),c=await y.default.encryptString(t,o,a?.nativeScryptCrypto),l=(0,_.createEntryPath)(e,o),d=new URL((0,s.STORAGE_URL)(this.env,l)),u=await fetch(d.toString(),{method:"PUT",headers:{"Content-Type":"application/json",...i},body:JSON.stringify({data:c})});if(!u.ok){const e=await u.json().catch(()=>({message:"unknown",error:"unknown"}));throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}}catch(t){const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to upsert user storage for path '${e}'. ${s}`)}},n=async function(e,t,a){const n=a?.entropySourceId;try{if(!t.length)return;const i=await b(this,r,"m",f).call(this,n),o=await this.getStorageKey(n),c=await Promise.all(t.map(async e=>[b(this,r,"m",h).call(this,e[0],o),await y.default.encryptString(e[1],o,a?.nativeScryptCrypto)])),l=new URL((0,s.STORAGE_URL)(this.env,e)),d=await fetch(l.toString(),{method:"PUT",headers:{"Content-Type":"application/json",...i},body:JSON.stringify({data:Object.fromEntries(c)})});if(!d.ok){const e=await d.json().catch(()=>({message:"unknown",error:"unknown"}));throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}}catch(t){const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to batch upsert user storage for path '${e}'. ${s}`)}},i=async function(e,t,a){try{const n=await b(this,r,"m",f).call(this,a),i=new URL((0,s.STORAGE_URL)(this.env,e)),o=await fetch(i.toString(),{method:"PUT",headers:{"Content-Type":"application/json",...n},body:JSON.stringify({data:Object.fromEntries(t)})});if(!o.ok){const e=await o.json().catch(()=>({message:"unknown",error:"unknown"}));throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}}catch(t){const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to batch upsert user storage for path '${e}'. ${s}`)}},o=async function(e,t){const n=t?.entropySourceId;try{const i=await b(this,r,"m",f).call(this,n),o=await this.getStorageKey(n),c=(0,_.createEntryPath)(e,o),l=new URL((0,s.STORAGE_URL)(this.env,c)),d=await fetch(l.toString(),{headers:{"Content-Type":"application/json",...i}});if(404===d.status)return null;if(!d.ok){const e=await d.json();throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}const u=await d.json(),h=u?.Data??null;if(!h)return null;const m=await y.default.decryptString(h,o,t?.nativeScryptCrypto);return y.default.getSalt(h).toString()!==S.SHARED_SALT.toString()&&await b(this,r,"m",a).call(this,e,m,t),m}catch(t){const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to get user storage for path '${e}'. ${s}`)}},c=async function(e,t){const a=t?.entropySourceId;try{const n=await b(this,r,"m",f).call(this,a),o=await this.getStorageKey(a),c=new URL((0,s.STORAGE_URL)(this.env,e)),l=await fetch(c.toString(),{headers:{"Content-Type":"application/json",...n}});if(404===l.status)return null;if(!l.ok){const e=await l.json();throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}const d=await l.json();if(!Array.isArray(d))return null;const u=[],h=[];for(const e of d)if(e.Data)try{const s=await y.default.decryptString(e.Data,o,t?.nativeScryptCrypto);u.push(s);y.default.getSalt(e.Data).toString()!==S.SHARED_SALT.toString()&&h.push([e.HashedKey,await y.default.encryptString(s,o,t?.nativeScryptCrypto)])}catch{}return h.length&&await b(this,r,"m",i).call(this,e,h,a),u}catch(t){const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to get user storage for path '${e}'. ${s}`)}},l=async function(e,t){const a=t?.entropySourceId;try{const t=await b(this,r,"m",f).call(this,a),n=await this.getStorageKey(a),i=(0,_.createEntryPath)(e,n),o=new URL((0,s.STORAGE_URL)(this.env,i)),c=await fetch(o.toString(),{method:"DELETE",headers:{"Content-Type":"application/json",...t}});if(404===c.status)throw new w.NotFoundError(`feature/key set not found for path '${e}'.`);if(!c.ok){const e=await c.json();throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}}catch(t){if(t instanceof w.NotFoundError)throw t;const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to delete user storage for path '${e}'. ${s}`)}},d=async function(e,t){try{const a=t?.entropySourceId,n=await b(this,r,"m",f).call(this,a),i=new URL((0,s.STORAGE_URL)(this.env,e)),o=await fetch(i.toString(),{method:"DELETE",headers:{"Content-Type":"application/json",...n}});if(404===o.status)throw new w.NotFoundError(`feature not found for path '${e}'.`);if(!o.ok){const e=await o.json();throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}}catch(t){if(t instanceof w.NotFoundError)throw t;const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to delete user storage for path '${e}'. ${s}`)}},u=async function(e,t,a){try{if(!t.length)return;const n=a?.entropySourceId,i=await b(this,r,"m",f).call(this,n),o=await this.getStorageKey(n),c=t.map(e=>b(this,r,"m",h).call(this,e,o)),l=new URL((0,s.STORAGE_URL)(this.env,e)),d=await fetch(l.toString(),{method:"PUT",headers:{"Content-Type":"application/json",...i},body:JSON.stringify({batch_delete:c})});if(!d.ok){const e=await d.json().catch(()=>({message:"unknown",error:"unknown"}));throw new Error(`HTTP error message: ${e.message}, error: ${e.error}`)}}catch(t){const s=t instanceof Error?t.message:JSON.stringify(t??"");throw new w.UserStorageError(`failed to batch delete user storage for path '${e}'. ${s}`)}},h=function(e,t){return(0,y.createSHA256Hash)(e+t)},f=async function(e){return{Authorization:`Bearer ${await this.config.auth.getAccessToken(e)}`}}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/user-storage.cjs"}],[2468,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getMetaMaskProviderEIP6963=s.metamaskClientsRdns=void 0,s.metamaskClientsRdns={main:"io.metamask",flask:"io.metamask.flask",institutional:"io.metamask.mmi"};const r={};s.getMetaMaskProviderEIP6963=function(e="any"){return new Promise(t=>{if("any"!==e&&s.metamaskClientsRdns[e]===undefined)return void t(null);const a=r[e];if(a)return void t(a);const n=[],i=e=>{const t=e,s=t?.detail;s?.provider&&s?.info?.rdns&&n.push({rdns:s?.info?.rdns,provider:s?.provider})};window.addEventListener("eip6963:announceProvider",i),window.dispatchEvent(new Event("eip6963:requestProvider")),setTimeout(()=>{let a;if(window.removeEventListener("eip6963:announceProvider",i),"any"===e){const e=Object.values(s.metamaskClientsRdns);a=n.find(t=>e.includes(t.rdns))?.provider??null}else{const t=s.metamaskClientsRdns[e];a=n.find(e=>e.rdns===t)?.provider??null}return a&&(r[e]=a),t(a)},100)})}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/utils/eip-6963-metamask-provider.cjs"}],[2469,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){async function r(e){return await e.request({method:"wallet_getSnaps"})}Object.defineProperty(s,"__esModule",{value:!0}),s.assertMessageStartsWithMetamask=s.MESSAGE_SIGNING_SNAP=s.isSnapConnected=s.getSnaps=s.connectSnap=s.SNAP_ORIGIN=void 0,s.SNAP_ORIGIN="npm:@metamask/message-signing-snap",s.connectSnap=async function(e){return await e.request({method:"wallet_requestSnaps",params:{[s.SNAP_ORIGIN]:{}}})},s.getSnaps=r,s.isSnapConnected=async function(e){try{const t=await r(e);return!!t&&Object.keys(t).includes(s.SNAP_ORIGIN)}catch(e){return console.error("Failed to determine if snap is connected",e),!1}},s.MESSAGE_SIGNING_SNAP={getPublicKey:async(e,t)=>await e.request({method:"wallet_invokeSnap",params:{snapId:s.SNAP_ORIGIN,request:{method:"getPublicKey",...t?{params:{entropySourceId:t}}:{}}}}),signMessage:async(e,t,r)=>await(e?.request({method:"wallet_invokeSnap",params:{snapId:s.SNAP_ORIGIN,request:{method:"signMessage",params:{message:t,...r?{entropySourceId:r}:{}}}}}))},s.assertMessageStartsWithMetamask=function(e){if(!e.startsWith("metamask:"))throw new Error('Message must start with "metamask:"')}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/utils/messaging-signing-snap-requests.cjs"}],[247,{"webextension-polyfill":5698},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.CronjobControllerStorageManager=s.CronjobControllerStorageKey=void 0;var r,a=(r=e("webextension-polyfill"))&&r.__esModule?r:{default:r};function n(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}const l=s.CronjobControllerStorageKey="temp-cronjob-storage";var d=new WeakMap,u=new WeakMap;s.CronjobControllerStorageManager=class{constructor(){n(this,d,null),n(this,u,!1)}async init(){o(d,this,(await a.default.storage.local.get(l))[l]),o(u,this,!0)}getInitialState(){if(!i(u,this))throw new Error("CronjobControllerStorageManager not yet initialized");return i(d,this)}set(e){if(!i(u,this))throw new Error("CronjobControllerStorageManager not yet initialized");a.default.storage.local.set({[l]:e}).catch(console.error)}}}}},{package:"$root$",file:"app/scripts/lib/CronjobControllerStorageManager.ts"}],[2470,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.validateLoginResponse=void 0,s.validateLoginResponse=function(e){const t=e;return!!t&&!(!t?.token||!t?.profile)}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/sdk/utils/validate-login-response.cjs"}],[2471,{"./constants.cjs":2472,"./utils.cjs":2475},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.setCachedKey=s.getCachedKeyGeneratedWithSharedSalt=s.getCachedKeyBySalt=void 0;const r=e("./constants.cjs"),a=e("./utils.cjs");let n={};const i=e=>(n[e]??(n[e]=new Map),n[e]);s.getCachedKeyBySalt=function(e,t){const s=i(e),r=(0,a.byteArrayToBase64)(t),n=s.get(r);return n?{salt:t,base64Salt:r,key:n}:undefined},s.getCachedKeyGeneratedWithSharedSalt=function(e){const t=i(e),s=(0,a.byteArrayToBase64)(r.SHARED_SALT),n=t.get(s);return n?{salt:r.SHARED_SALT,base64Salt:s,key:n}:undefined},s.setCachedKey=function(e,t,s){Object.keys(n).length>100&&(n={});const r=i(e),o=(0,a.byteArrayToBase64)(t);r.size>100&&r.clear(),r.set(o,s)}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/encryption/cache.cjs"}],[2472,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MAX_KDF_PROMISE_CACHE_SIZE=s.SHARED_SALT=s.SCRYPT_p=s.SCRYPT_r=s.SCRYPT_N=s.SCRYPT_SALT_SIZE=s.ALGORITHM_KEY_SIZE=s.ALGORITHM_NONCE_SIZE=void 0,s.ALGORITHM_NONCE_SIZE=12,s.ALGORITHM_KEY_SIZE=16,s.SCRYPT_SALT_SIZE=16,s.SCRYPT_N=2**17,s.SCRYPT_r=8,s.SCRYPT_p=1,s.SHARED_SALT=new Uint8Array([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]),s.MAX_KDF_PROMISE_CACHE_SIZE=20}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/encryption/constants.cjs"}],[2473,{"./cache.cjs":2471,"./constants.cjs":2472,"./utils.cjs":2475,"@noble/ciphers/aes":3079,"@noble/ciphers/webcrypto":3082,"@noble/hashes/scrypt":3102,"@noble/hashes/sha256":3104,"@noble/hashes/utils":3107},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.createSHA256Hash=void 0;const f=e("@noble/ciphers/aes"),m=e("@noble/ciphers/webcrypto"),p=e("@noble/hashes/scrypt"),g=e("@noble/hashes/sha256"),b=e("@noble/hashes/utils"),w=e("./cache.cjs"),y=e("./constants.cjs"),S=e("./utils.cjs");a=new WeakMap,r=new WeakSet,n=async function(e,t,s){const{key:a,salt:n}=await h(this,r,"m",l).call(this,t,{N:y.SCRYPT_N,r:y.SCRYPT_r,p:y.SCRYPT_p,dkLen:y.ALGORITHM_KEY_SIZE},undefined,s),i=(0,b.utf8ToBytes)(e),c=(0,b.concatBytes)(n,h(this,r,"m",o).call(this,i,a)),d={v:"1",t:"scrypt",d:(0,S.byteArrayToBase64)(c),o:{N:y.SCRYPT_N,r:y.SCRYPT_r,p:y.SCRYPT_p,dkLen:y.ALGORITHM_KEY_SIZE},saltLen:y.SCRYPT_SALT_SIZE};return JSON.stringify(d)},i=async function(e,t,s){const{o:a,d:n,saltLen:i}=e,o=(0,S.base64ToByteArray)(n),d=o.slice(0,i),u=o.slice(i,o.length),{key:f}=await h(this,r,"m",l).call(this,t,{N:a.N,r:a.r,p:a.p,dkLen:a.dkLen},d,s);return(0,S.bytesToUtf8)(h(this,r,"m",c).call(this,u,f))},o=function(e,t){const s=(0,m.randomBytes)(y.ALGORITHM_NONCE_SIZE),r=(0,f.gcm)(t,s).encrypt(e);return(0,b.concatBytes)(s,r)},c=function(e,t){const s=e.slice(0,y.ALGORITHM_NONCE_SIZE),r=e.slice(y.ALGORITHM_NONCE_SIZE,e.length);return(0,f.gcm)(t,s).decrypt(r)},l=async function(e,t,s,n){const i=_(e),o=s?(0,w.getCachedKeyBySalt)(i,s):(0,w.getCachedKeyGeneratedWithSharedSalt)(i);if(o)return{key:o.key,salt:o.salt};const c=s??y.SHARED_SALT,l=h(this,r,"m",d).call(this,i,t,c,n),f=h(this,a,"f").get(l);if(f)return f;if(h(this,a,"f").size>=y.MAX_KDF_PROMISE_CACHE_SIZE){const e=h(this,a,"f").keys().next().value;e&&h(this,a,"f").delete(e)}const m=h(this,r,"m",u).call(this,e,t,c,i,n);return h(this,a,"f").set(l,m),m.finally(()=>{h(this,a,"f").delete(l)}),m},d=function(e,t,s,r){const a=(0,S.byteArrayToBase64)(s),n=Boolean(r);return`${e}:${t.N}:${t.r}:${t.p}:${t.dkLen}:${a}:${n}`},u=async function(e,t,s,r,a){let n;return n=a?await a((0,S.stringToByteArray)(e),s,t.N,t.r,t.p,t.dkLen):await(0,p.scryptAsync)(e,s,{N:t.N,r:t.r,p:t.p,dkLen:t.dkLen}),(0,w.setCachedKey)(r,s,n),{key:n,salt:s}};const v=new class{constructor(){r.add(this),a.set(this,new Map)}async encryptString(e,t,s){try{return await h(this,r,"m",n).call(this,e,t,s)}catch(e){const t=e instanceof Error?e.message:JSON.stringify(e);throw new Error(`Unable to encrypt string - ${t}`)}}async decryptString(e,t,s){try{const a=JSON.parse(e);if("1"===a.v&&"scrypt"===a.t)return await h(this,r,"m",i).call(this,a,t,s);throw new Error(`Unsupported encrypted data payload - ${e}`)}catch(e){const t=e instanceof Error?e.message:JSON.stringify(e);throw new Error(`Unable to decrypt string - ${t}`)}}getSalt(e){try{const t=JSON.parse(e);if("1"===t.v&&"scrypt"===t.t){const{d:e,saltLen:s}=t,r=(0,S.base64ToByteArray)(e);return r.slice(0,s)}throw new Error(`Unsupported encrypted data payload - ${e}`)}catch(e){const t=e instanceof Error?e.message:JSON.stringify(e);throw new Error(`Unable to get salt - ${t}`)}}getIfEntriesHaveDifferentSalts(e){const t=e.map(e=>{try{return this.getSalt(e)}catch{return undefined}}).filter(e=>e!==undefined);return new Set(t.map(e=>e.toString())).size===t.length}};function _(e){const t=(0,g.sha256)(e);return(0,b.bytesToHex)(t)}s.default=v,s.createSHA256Hash=_}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/encryption/encryption.cjs"}],[2474,{"./encryption.cjs":2473},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,a)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)},n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.Encryption=void 0;const i=n(e("./encryption.cjs"));s.Encryption=i.default,a(e("./encryption.cjs"),s),s.default=i.default}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/encryption/index.cjs"}],[2475,{buffer:4019},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(e){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.stringToByteArray=s.bytesToUtf8=s.base64ToByteArray=s.byteArrayToBase64=void 0;s.byteArrayToBase64=t=>e.from(t).toString("base64");s.base64ToByteArray=t=>new Uint8Array(e.from(t,"base64"));s.bytesToUtf8=e=>new TextDecoder("utf-8").decode(e);s.stringToByteArray=e=>(new TextEncoder).encode(e)}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/encryption/utils.cjs"}],[2476,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a;Object.defineProperty(s,"__esModule",{value:!0}),s.getOidcClientId=s.getEnvUrls=s.Platform=s.Env=void 0,function(e){e.DEV="dev",e.UAT="uat",e.PRD="prd"}(r||(s.Env=r={})),function(e){e.MOBILE="mobile",e.EXTENSION="extension",e.PORTFOLIO="portfolio",e.INFURA="infura"}(a||(s.Platform=a={}));const n={dev:{authApiUrl:"https://authentication.dev-api.cx.metamask.io",oidcApiUrl:"https://oidc.dev-api.cx.metamask.io",userStorageApiUrl:"https://user-storage.dev-api.cx.metamask.io"},uat:{authApiUrl:"https://authentication.uat-api.cx.metamask.io",oidcApiUrl:"https://oidc.uat-api.cx.metamask.io",userStorageApiUrl:"https://user-storage.uat-api.cx.metamask.io"},prd:{authApiUrl:"https://authentication.api.cx.metamask.io",oidcApiUrl:"https://oidc.api.cx.metamask.io",userStorageApiUrl:"https://user-storage.api.cx.metamask.io"}};s.getEnvUrls=function(e){if(!n[e])throw new Error("invalid environment configuration");return n[e]},s.getOidcClientId=function(e,t){const s={[r.DEV]:{[a.PORTFOLIO]:"c7ca94a0-5d52-4635-9502-1a50a9c410cc",[a.MOBILE]:"e83c7cc9-267d-4fb4-8fec-f0e3bbe5ae8e",[a.EXTENSION]:"f1a963d7-50dc-4cb5-8d81-f1f3654f0df3",[a.INFURA]:"bd887006-0d55-481a-a395-5ff9a0dc52c9"},[r.UAT]:{[a.PORTFOLIO]:"8f2dd4ac-db07-4819-9ba5-1ee0ec1b56d1",[a.MOBILE]:"c3cfdcd2-51d6-4fae-ad2c-ff238c8fef53",[a.EXTENSION]:"a9de167c-c9a6-43d8-af39-d301fd44c485",[a.INFURA]:"01929890-7002-4c97-9913-8f6c09a6d674"},[r.PRD]:{[a.PORTFOLIO]:"35e1cd62-49c5-4be8-8b6e-a5212f2d2cfb",[a.MOBILE]:"75fa62a3-9ca0-4b91-9fe5-76bec86b0257",[a.EXTENSION]:"1132f10a-b4e5-4390-a5f2-d9c6022db564",[a.INFURA]:"fdde9417-e193-4d23-9943-a8346b18d097"}};if(!s[e])throw new Error(`invalid env ${e}: cannot determine oidc client id`);if(!s[e][t])throw new Error(`invalid env ${e} and platform ${t} combination: cannot determine oidc client id`);return s[e][t]}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/env.cjs"}],[2477,{"./encryption/index.cjs":2474},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createEntryPath=s.getFeatureAndKeyFromPath=s.USER_STORAGE_FEATURE_NAMES=void 0;const r=e("./encryption/index.cjs");s.USER_STORAGE_FEATURE_NAMES={notifications:"notifications",accounts:"accounts_v2",addressBook:"addressBook"};s.getFeatureAndKeyFromPath=e=>{if(!/^\w+\.\w+$/u.test(e))throw new Error("user-storage - path is not in the correct format. Correct format: 'feature.key'");const[t,s]=e.split(".");return{feature:t,key:s}},s.createEntryPath=function(e,t){const{feature:a,key:n}=(0,s.getFeatureAndKeyFromPath)(e);return`${a}/${(0,r.createSHA256Hash)(n+t)}`}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/storage-schema.cjs"}],[2478,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.EventQueue=void 0;s.EventQueue=class{constructor(){this.queue=[]}push(e){this.queue.push(e)}async run(){for(;this.queue.length>0;){const e=this.queue[0];try{await e()}finally{this.queue=this.queue.filter(t=>t!==e)}}}}}}},{package:"@metamask/profile-metrics-controller>@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-metrics-controller/node_modules/@metamask/profile-sync-controller/dist/shared/utils/event-queue.cjs"}],[248,{"./state-utils":332,"@metamask/utils":3051,lodash:4773,uuid:5669},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.PatchStore=void 0;var r=e("@metamask/utils"),a=e("uuid"),n=e("lodash"),i=e("./state-utils");function o(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}const c=(0,r.createProjectLogger)("patch-store");s.PatchStore=class{constructor(e){o(this,"id",void 0),o(this,"observableStore",void 0),o(this,"pendingPatches",[]),o(this,"listener",void 0),this.id=(0,a.v4)(),this.observableStore=e,this.listener=this._onStateChange.bind(this),this.observableStore.on("stateChange",this.listener),c("Created",this.id)}flushPendingPatches(){const e=this.pendingPatches;this.pendingPatches=[];for(const t of e)c("Flushed",t.path.join("."),this.id,t);return e}destroy(){this.observableStore.removeListener("stateChange",this.listener),c("Destroyed",this.id)}_onStateChange({newState:e,oldState:t,patches:s}){let r=[];if(s){const e=this._normalizeEventPatches(s,t);r=(0,i.sanitizePatches)(e??[])}else{const s=(0,i.sanitizeUIState)(e);r=this._generatePatches(t,s)}const a=Boolean(e.vault);if(a&&r.push({op:"replace",path:["isInitialized"],value:a}),r.length)for(const e of r){const t=e.path.join(".");this.pendingPatches.push(e),c("Added",t,this.id,e)}}_generatePatches(e,t){return Object.keys(t).map(s=>{const r=e[s],a=t[s];return r===a?null:{op:"replace",path:[s],value:a}}).filter(Boolean)}_normalizeEventPatches(e,t){return null==e?void 0:e.flatMap(e=>{if(e.path.length>0)return[e];return(0,n.uniq)([...Object.keys(t),...Object.keys(e.value)]).map(t=>({op:t in e.value?"replace":"remove",path:[t],...t in e.value?{value:e.value[t]}:{}}))})}}}}},{package:"$root$",file:"app/scripts/lib/PatchStore.ts"}],[249,{"@metamask/name-controller":2276,"@metamask/snaps-rpc-methods":2710,"@metamask/snaps-utils":2883,loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.SnapsNameProvider=void 0;var r,a=e("@metamask/name-controller"),n=e("@metamask/snaps-utils"),i=(r=e("loglevel"))&&r.__esModule?r:{default:r},o=e("@metamask/snaps-rpc-methods");function c(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function l(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function d(e,t){return e.get(u(e,t))}function u(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var h=new WeakMap,f=new WeakSet;function m(e){const t=d(h,this).call("PermissionController:getState").subjects;return d(h,this).call("SnapController:getAll").filter(({id:s})=>{var r;const a=null===(r=t[s])||void 0===r?void 0:r.permissions["endowment:name-lookup"];if(!a)return!1;const n=(0,o.getChainIdsCaveat)(a);return!(e&&n&&!n.includes(e))})}async function p(e,t,s){const r=e,a={chainId:t,address:s};let o,c;try{const t=await d(h,this).call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:n.HandlerType.OnNameLookup,request:{jsonrpc:"2.0",method:" ",params:a}}),s=null==t?void 0:t.resolvedDomains;o=s?[...new Set(s.map(e=>e.resolvedDomain))]:[]}catch(t){i.default.error("Snap name provider request failed",{snapId:e,request:a,error:t}),c=t}return{sourceId:r,result:{proposedNames:o,error:c}}}s.SnapsNameProvider=class{constructor({messenger:e}){var t,s,r;!function(e,t){c(e,t),t.add(e)}(this,f),l(this,"name","SnapsNameProvider"),l(this,"state",null),function(e,t,s){c(e,t),t.set(e,s)}(this,h,void 0),s=this,r=e,(t=h).set(u(t,s),r)}getMetadata(){const e=u(f,this,m).call(this);return{sourceIds:{[a.NameType.ETHEREUM_ADDRESS]:e.map(e=>e.id)},sourceLabels:e.reduce((e,t)=>{const s=d(h,this).call("SnapController:get",t.id),r=null==s?void 0:s.manifest.proposedName;return{...e,[t.id]:r||t.id}},{})}}async getProposedNames(e){const{variation:t,value:s}=e,r=`eip155:${parseInt(t,16)}`,a=u(f,this,m).call(this,r);return{results:(await Promise.all(a.map(e=>u(f,this,p).call(this,e.id,r,s)))).reduce((e,t)=>{const{sourceId:s,result:r}=t;return{...e,[s]:r}},{})}}}}}},{package:"$root$",file:"app/scripts/lib/SnapsNameProvider.ts"}],[25,{"../../lib/util":358,"@metamask/assets-controllers":1276},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.TokenRatesControllerInit=void 0;var r=e("@metamask/assets-controllers"),a=e("../../lib/util");s.TokenRatesControllerInit=e=>{const{controllerMessenger:t,initMessenger:s,persistedState:n}=e,i=s.call("PreferencesController:getState"),o=new r.TokenRatesController({messenger:t,state:n.TokenRatesController,tokenPricesService:new r.CodefiTokenPricesServiceV2,disabled:!i.useCurrencyRateCheck});return s.subscribe("PreferencesController:stateChange",(0,a.previousValueComparator)((e,t)=>{const{useCurrencyRateCheck:s}=e,{useCurrencyRateCheck:r}=t;return r&&!s?o.enable():!r&&s&&o.disable(),!0},i)),{controller:o}}}}},{package:"$root$",file:"app/scripts/controller-init/assets/token-rates-controller-init.ts"}],[250,{"../../../shared/constants/onboarding":5732,"../../../shared/lib/wallet-funds-obtained-metric":5838,"@metamask/notification-services-controller/notification-services":2309,loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.WalletFundsObtainedMonitor=void 0;var r,a=e("@metamask/notification-services-controller/notification-services"),n=(r=e("loglevel"))&&r.__esModule?r:{default:r},i=e("../../../shared/lib/wallet-funds-obtained-metric"),o=e("../../../shared/constants/onboarding");function c(e,t,s){l(e,t),t.set(e,s)}function l(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function d(e,t){return e.get(h(e,t))}function u(e,t,s){return e.set(h(e,t),s),s}function h(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var f=new WeakMap,m=new WeakMap,p=new WeakMap,g=new WeakSet;function b(){try{const e=d(f,this).call("TokenBalancesController:getState"),t=d(f,this).call("MultichainBalancesController:getState");return(0,i.hasNonZeroTokenBalance)(e.tokenBalances)||(0,i.hasNonZeroMultichainBalance)(t.balances)}catch(e){return n.default.error("Error checking for existing funds: ",e),!1}}function w(){return e=>{const t=e.filter(e=>e.type===a.TRIGGER_TYPES.ERC20_RECEIVED||e.type===a.TRIGGER_TYPES.ETH_RECEIVED);if(t.length<1)return;const s=t.at(-1);if(!s)return;const{payload:{chain_id:r}}=s,n=s.type===a.TRIGGER_TYPES.ERC20_RECEIVED?s.payload.data.token.usd:s.payload.data.amount.usd;r&&n&&(d(f,this).call("MetaMetricsController:trackEvent",(0,i.getWalletFundsObtainedEventProperties)({chainId:r,amountUsd:n})),d(f,this).call("AppStateController:setCanTrackWalletFundsObtained",!1),d(p,this)&&(d(f,this).unsubscribe("NotificationServicesController:notificationsListUpdated",d(p,this)),u(p,this,null)))}}s.WalletFundsObtainedMonitor=class{constructor({messenger:e}){!function(e,t){l(e,t),t.add(e)}(this,g),c(this,f,void 0),c(this,m,!1),c(this,p,null),u(f,this,e)}setupMonitoring(){if(d(m,this))return;const e=d(f,this).call("OnboardingController:getState"),{firstTimeFlowType:t}=e;if(t!==o.FirstTimeFlowType.create&&t!==o.FirstTimeFlowType.socialCreate)return void d(f,this).call("AppStateController:setCanTrackWalletFundsObtained",!1);d(f,this).call("NotificationServicesController:getState").isNotificationServicesEnabled?h(g,this,b).call(this)?d(f,this).call("AppStateController:setCanTrackWalletFundsObtained",!1):(u(p,this,h(g,this,w).call(this)),d(f,this).subscribe("NotificationServicesController:notificationsListUpdated",d(p,this)),u(m,this,!0)):d(f,this).call("AppStateController:setCanTrackWalletFundsObtained",!1)}}}}},{package:"$root$",file:"app/scripts/lib/WalletFundsObtainedMonitor.ts"}],[251,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var r=s.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.WeakRefObjectMap=void 0;class a{constructor(){r(this,"map",void 0),this.map=new Map}set(e,t){const s={};for(const e in t){if(!Object.prototype.hasOwnProperty.call(t,e))continue;const r=t[e];if("object"!=typeof r||null===r)throw new Error(`Property ${String(e)} is not an object and cannot be weakly referenced.`);s[e]=new WeakRef(r)}return this.map.set(e,s),this}get(e){const t=this.map.get(e);if(!t)return undefined;const s={};for(const r in t){if(!Object.prototype.hasOwnProperty.call(t,r))continue;const a=t[r].deref();if(a===undefined)return this.map.delete(e),undefined;s[r]=a}return s}has(e){return this.get(e)!==undefined}delete(e){return this.get(e)!==undefined&&this.map.delete(e)}clear(){this.map.clear()}get size(){return this.map.size}entries(){const e=[];return this.map.forEach((t,s)=>{const r=this.get(s);r!==undefined&&e.push([s,r])}),e.values()}keys(){return this.map.keys()}values(){const e=[];return this.map.forEach((t,s)=>{const r=this.get(s);r!==undefined&&e.push(r)}),e.values()}[Symbol.iterator](){return this.entries()}get[Symbol.toStringTag](){return"WeakRefObjectMap"}forEach(e,t){this.map.forEach((s,r)=>{const a=this.get(r);a!==undefined&&(t?e.call(t,a,r,this):e(a,r,this))})}}s.WeakRefObjectMap=a}}},{package:"$root$",file:"app/scripts/lib/WeakRefObjectMap.ts"}],[252,{"../../../../shared/constants/app":5710,"@metamask/controller-utils":1419,"@metamask/rpc-errors":2584,"@metamask/snaps-rpc-methods":2710,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.rejectAllApprovals=function({approvalController:e,deleteInterface:t}){const s=e.state.pendingApprovals,r=Object.values(s);for(const s of r)l({approvalController:e,approvalRequest:s,deleteInterface:t})},s.rejectOriginApprovals=function({approvalController:e,deleteInterface:t,origin:s}){const r=e.state.pendingApprovals,a=Object.values(r).filter(e=>e.origin===s);for(const s of a)l({approvalController:e,approvalRequest:s,deleteInterface:t})};var r=e("@metamask/controller-utils"),a=e("@metamask/snaps-rpc-methods"),n=e("@metamask/rpc-errors"),i=e("@metamask/utils"),o=e("../../../../shared/constants/app");const c=(0,i.createProjectLogger)("approval-utils");function l({approvalController:e,approvalRequest:t,deleteInterface:s}){var i;const{id:l,type:d,origin:u}=t,h=null===(i=t.requestData)||void 0===i?void 0:i.id;switch(d){case r.ApprovalType.SnapDialogAlert:case r.ApprovalType.SnapDialogPrompt:case a.DIALOG_APPROVAL_TYPES.default:c("Rejecting snap dialog",{id:l,interfaceId:h,origin:u,type:d}),e.accept(l,null),null==s||s(h);break;case r.ApprovalType.SnapDialogConfirmation:c("Rejecting snap confirmation",{id:l,interfaceId:h,origin:u,type:d}),e.accept(l,!1),null==s||s(h);break;case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect:c("Rejecting snap account confirmation",{id:l,origin:u,type:d}),e.accept(l,!1);break;default:c("Rejecting pending approval",{id:l,origin:u,type:d}),e.reject(l,n.providerErrors.userRejectedRequest({data:{cause:"rejectAllApprovals"}}))}}}}},{package:"$root$",file:"app/scripts/lib/approval/utils.ts"}],[253,{"../../../shared/modules/string-utils":5876},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var r=e("../../../shared/modules/string-utils");s.default=class{constructor(e={}){const{preferencesController:t,addressBookController:s,accountsController:r,networkController:a,trackMetaMetricsEvent:n}=e;this.preferencesController=t,this.accountsController=r,this.addressBookController=s,this.networkController=a,this._trackMetaMetricsEvent=n}async restoreUserData(e){const t=this.preferencesController.state,{preferences:s,addressBook:r,network:a,internalAccounts:n}=JSON.parse(e);s&&(s.identities=t.identities,s.lostIdentities=t.lostIdentities,s.selectedAddress=t.selectedAddress,this.preferencesController.update(s)),r&&this.addressBookController.update(r,!0),a&&this.networkController.loadBackup(a),n&&this.accountsController.loadBackup(n),(s||r||a||n)&&this._trackMetaMetricsEvent({event:"User Data Imported",category:"Backup"})}async backupUserData(){const e={preferences:{...this.preferencesController.state},internalAccounts:{internalAccounts:this.accountsController.state.internalAccounts},addressBook:{...this.addressBookController.state},network:{networkConfigurationsByChainId:this.networkController.state.networkConfigurationsByChainId}};delete e.preferences.identities,delete e.preferences.lostIdentities,delete e.preferences.selectedAddress;const t=JSON.stringify(e),s=new Date,a=e=>(0,r.prependZero)(e,2);return{fileName:`MetaMaskUserData.${s.getFullYear()}_${a(s.getMonth()+1)}_${a(s.getDay())}_${a(s.getHours())}_${a(s.getMinutes())}_${a(s.getDay())}.json`,data:t}}}}}},{package:"$root$",file:"app/scripts/lib/backup.js"}],[254,{"../../../shared/constants/time":5747,loglevel:4781,"readable-stream":5211},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.THREE_MINUTES=void 0,s.default=function(){const e=c();return new a.Transform({transform(t,s,r){const a=t.id===undefined,i=e.add(t.id);a||i?r(null,t):(n.default.debug(`RPC request with id "${t.id}" already seen.`),r())},objectMode:!0})};var r,a=e("readable-stream"),n=(r=e("loglevel"))&&r.__esModule?r:{default:r},i=e("../../../shared/constants/time");const o=s.THREE_MINUTES=3*i.MINUTE,c=()=>{const e=new Map;return setInterval(()=>{const t=Date.now()-o;for(const[s,r]of e.entries()){if(!(r<=t))break;e.delete(s)}},o),{add:t=>!e.has(t)&&(e.set(t,Date.now()),!0)}}}}},{package:"$root$",file:"app/scripts/lib/createDupeReqFilterStream.ts"}],[255,{"../../../shared/constants/permissions":5733,"../controllers/permissions":226,"@metamask/keyring-api":2163},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({messenger:e}){return function(t,s,a,n){const o=e.call("AccountsController:getSelectedAccount");if((0,r.isEvmAccountType)(o.type))return a();if(i.includes(t.method))return n(new Error(`Non-EVM account cannot request this method: ${t.method}`));if("wallet_requestPermissions"===t.method&&null!=t&&t.params&&Array.isArray(t.params)&&t.params.length>0&&t.params[0]){const e=Object.keys(t.params[0]);if(i.some(t=>e.includes(t)))return n(new Error(`Non-EVM account cannot request this method: ${e.toString()}`))}return a()}};var r=e("@metamask/keyring-api"),a=e("../../../shared/constants/permissions"),n=e("../controllers/permissions");const i=[...Object.values(a.RestrictedEthMethods),...n.unrestrictedEthSigningMethods]}}},{package:"$root$",file:"app/scripts/lib/createEvmMethodsToNonEvmAccountReqFilterMiddleware.ts"}],[256,{"../../../shared/constants/referrals":5736,"@metamask/json-rpc-engine":2079,loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.HyperliquidPermissionTriggerType=void 0,s.createHyperliquidReferralMiddleware=function(e){return(0,a.createAsyncMiddleware)(async(t,s,r)=>{if(await r(),!function(e){return Boolean(e.origin)&&Boolean(e.tabId)}(t))return;const a="wallet_requestPermissions"===t.method&&t.origin===i.HYPERLIQUID_ORIGIN,c=Array.isArray(s.result)&&s.result.some(e=>"eth_accounts"===(null==e?void 0:e.parentCapability));a&&c&&e(t.tabId,o.NewConnection).catch(e=>{n.default.error("Failed to handle Hyperliquid referral after wallet_requestPermissions grant: ",e)})})};var r,a=e("@metamask/json-rpc-engine"),n=(r=e("loglevel"))&&r.__esModule?r:{default:r},i=e("../../../shared/constants/referrals");let o=s.HyperliquidPermissionTriggerType=function(e){return e.NewConnection="new_connection",e.OnNavigateConnectedTab="on_navigate_connected_tab",e}({})}}},{package:"$root$",file:"app/scripts/lib/createHyperliquidReferralMiddleware.ts"}],[257,{loglevel:4781},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function(e){return function(t,s,r){r(r=>{s.error&&a.default.debug("Error in RPC response:\n",s),t.isMetamaskInternal||(a.default.info(`RPC (${e.origin}): ${t.method} -> ${s.error?"error":"success"}`),r())})}};var r,a=(r=e("loglevel"))&&r.__esModule?r:{default:r}}}},{package:"$root$",file:"app/scripts/lib/createLoggerMiddleware.js"}],[2572,{"@metamask/base-controller":1346,"@metamask/rpc-errors":2584,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;const r=e("@metamask/base-controller"),a=e("@metamask/rpc-errors"),n=e("@metamask/utils"),i="RateLimitController",o={requests:{includeInStateLogs:!1,persist:!1,includeInDebugSnapshot:!1,usedInUi:!1}};class c extends r.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:s,state:r,implementations:a}){const c={requests:(0,n.getKnownPropertyNames)(a).reduce((e,t)=>({...e,[t]:{}}),{})};super({name:i,metadata:o,messenger:s,state:{...c,...r}}),this.implementations=a,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messenger.registerActionHandler(`${i}:call`,(e,t,...s)=>this.call(e,t,...s))}async call(e,t,...s){if(this.isRateLimited(t,e))throw a.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const r=this.implementations[t].method;if(!r)throw new Error("Invalid api type");return r(...s)}isRateLimited(e,t){const s=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=s}recordRequest(e,t){const s=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,r=this.state.requests[e][t]??0;this.update(a=>{0===r&&setTimeout(()=>this.resetRequestCount(e,t),s),Object.assign(a,{requests:{...a.requests,[e]:{[t]:r+1}}})})}resetRequestCount(e,t){this.update(s=>{Object.assign(s,{requests:{...s.requests,[e]:{[t]:0}}})})}}s.RateLimitController=c}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],[2573,{"./RateLimitController.cjs":2572},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;var r=e("./RateLimitController.cjs");Object.defineProperty(s,"RateLimitController",{enumerable:!0,get:function(){return r.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],[2574,{"../constants.cjs":2575,"@metamask/controller-utils":1419},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},l=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ClientConfigApiService=void 0;const d=e("@metamask/controller-utils"),u=e("../constants.cjs");s.ClientConfigApiService=class{constructor({fetch:e,retries:t=d.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:s=d.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:u=d.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:h,onDegraded:f,config:m}){r.set(this,void 0),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c(this,r,e,"f"),c(this,n,m.client,"f"),c(this,i,m.distribution,"f"),c(this,o,m.environment,"f"),c(this,a,(0,d.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:s,circuitBreakDuration:u}),"f"),h&&l(this,a,"f").onBreak(h),f&&l(this,a,"f").onDegraded(f)}onBreak(...e){return l(this,a,"f").onBreak(...e)}onDegraded(...e){return l(this,a,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${u.BASE_URL}/flags?client=${l(this,n,"f")}&distribution=${l(this,i,"f")}&environment=${l(this,o,"f")}`,t=await l(this,a,"f").execute(()=>l(this,r,"f").call(this,e,{cache:"no-cache"}));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const s=await t.json();if(!Array.isArray(s))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(s),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce((e,t)=>({...e,...t}),{})}},r=new WeakMap,a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],[2575,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BASE_URL=void 0,s.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],[2576,{"./client-config-api-service/client-config-api-service.cjs":2574,"./remote-feature-flag-controller-types.cjs":2577,"./remote-feature-flag-controller.cjs":2578,"./utils/user-segmentation-utils.cjs":2579},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.generateDeterministicRandomNumber=s.ClientConfigApiService=s.EnvironmentType=s.DistributionType=s.ClientType=s.RemoteFeatureFlagController=void 0;var r=e("./remote-feature-flag-controller.cjs");Object.defineProperty(s,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return r.RemoteFeatureFlagController}});var a=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(s,"ClientType",{enumerable:!0,get:function(){return a.ClientType}}),Object.defineProperty(s,"DistributionType",{enumerable:!0,get:function(){return a.DistributionType}}),Object.defineProperty(s,"EnvironmentType",{enumerable:!0,get:function(){return a.EnvironmentType}});var n=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(s,"ClientConfigApiService",{enumerable:!0,get:function(){return n.ClientConfigApiService}});var i=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(s,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return i.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],[2577,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n;Object.defineProperty(s,"__esModule",{value:!0}),s.EnvironmentType=s.DistributionType=s.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(r||(s.ClientType=r={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(a||(s.DistributionType=a={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev",e.Beta="beta",e.Test="test",e.Exp="exp"}(n||(s.EnvironmentType=n={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],[2578,{"./utils/user-segmentation-utils.cjs":2579,"./utils/version.cjs":2580,"@metamask/base-controller":1346,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h,f,m=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},p=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RemoteFeatureFlagController=s.getDefaultRemoteFeatureFlagControllerState=s.DEFAULT_CACHE_DURATION=void 0;const g=e("@metamask/base-controller"),b=e("@metamask/utils"),w=e("./utils/user-segmentation-utils.cjs"),y=e("./utils/version.cjs");s.DEFAULT_CACHE_DURATION=864e5;const S={remoteFeatureFlags:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0},cacheTimestamp:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!1}};function v(){return{remoteFeatureFlags:{},cacheTimestamp:0}}s.getDefaultRemoteFeatureFlagControllerState=v;class _ extends g.BaseController{constructor({messenger:e,state:t,clientConfigApiService:d,fetchInterval:u=s.DEFAULT_CACHE_DURATION,disabled:h=!1,getMetaMetricsId:f,clientVersion:p}){if(!(0,b.isValidSemVerVersion)(p))throw new Error(`Invalid clientVersion: "${p}". Must be a valid 3-part SemVer version string`);super({name:"RemoteFeatureFlagController",metadata:S,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),m(this,a,u,"f"),m(this,n,h,"f"),m(this,i,d,"f"),m(this,c,f,"f"),m(this,l,p,"f")}async updateRemoteFeatureFlags(){if(p(this,n,"f")||!p(this,r,"m",d).call(this))return;let e;if(p(this,o,"f"))await p(this,o,"f");else{try{m(this,o,p(this,i,"f").fetchRemoteFeatureFlags(),"f"),e=await p(this,o,"f")}finally{m(this,o,undefined,"f")}await p(this,r,"m",u).call(this,e.remoteFeatureFlags)}}enable(){m(this,n,!1,"f")}disable(){m(this,n,!0,"f")}}s.RemoteFeatureFlagController=_,a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,r=new WeakSet,d=function(){return Date.now()-this.state.cacheTimestamp>p(this,a,"f")},u=async function(e){const t=await p(this,r,"m",f).call(this,e);this.update(()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()}))},h=function(e){return(0,y.isVersionFeatureFlag)(e)?(0,y.getVersionData)(e,p(this,l,"f")):e},f=async function(e){const t={},s=p(this,c,"f").call(this),a=(0,w.generateDeterministicRandomNumber)(s);for(const[s,n]of Object.entries(e)){let e=p(this,r,"m",h).call(this,n);if(null!==e){if(Array.isArray(e)&&a){const t=e.find(e=>!!(0,w.isFeatureFlagWithScopeValue)(e)&&a<=e.scope.value);t&&(e={name:t.name,value:t.value})}t[s]=e}}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],[2579,{uuid:5669},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isFeatureFlagWithScopeValue=s.generateDeterministicRandomNumber=void 0;const r=e("uuid");function a(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const n=a("00000000-0000-4000-8000-000000000000"),i=a("ffffffff-ffff-4fff-bfff-ffffffffffff")-n;s.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,s;if((0,r.validate)(e)){if(4!==(0,r.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,r.version)(e)}`);t=a(e)-n,s=i}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const r=e.slice(2),a=64;if(r.length!==a)throw new Error(`Invalid hex ID length. Expected ${a} characters, got ${r.length}`);if(!/^[0-9a-f]+$/iu.test(r))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${r}`),s=BigInt(`0x${"f".repeat(r.length)}`)}return Number(t*BigInt(1e6)/s)/1e6};s.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],[258,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({mainFrameOrigin:e}){return function(t,s,r){t.mainFrameOrigin=e,r()}}}}},{package:"$root$",file:"app/scripts/lib/createMainFrameOriginMiddleware.ts"}],[2580,{"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getVersionData=s.isVersionFeatureFlag=s.MULTI_VERSION_FLAG_KEYS=void 0;const r=e("@metamask/utils");function a(e,t){return e===t||(0,r.gtVersion)(e,t)}s.MULTI_VERSION_FLAG_KEYS={VERSIONS:"versions"},s.isVersionFeatureFlag=function(e){if("object"!=typeof e||null===e||Array.isArray(e)||!(s.MULTI_VERSION_FLAG_KEYS.VERSIONS in e))return!1;const t=e[s.MULTI_VERSION_FLAG_KEYS.VERSIONS];return"object"==typeof t&&null!==t&&!Array.isArray(t)&&Object.keys(t).every(e=>(0,r.isValidSemVerVersion)(e))},s.getVersionData=function(e,t){const s=(r=e.versions,Object.entries(r)).sort(([e],[t])=>a(e,t)?-1:1);var r;for(const[e,r]of s)if(a(t,e))return r;return null}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/version.cjs"}],[259,{"./stream-utils":337,"@metamask/rpc-errors":2584},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var r=e("@metamask/rpc-errors"),a=e("./stream-utils");s.default=(e,t)=>async s=>{if(!(0,a.isStreamWritable)(t))return;if(!e[s.method])return void t.write({jsonrpc:"2.0",error:r.rpcErrors.methodNotFound({message:`${s.method} not found`}),id:s.id});let n,i;try{n=await e[s.method](...s.params)}catch(e){i=e}(0,a.isStreamWritable)(t)?i?t.write({jsonrpc:"2.0",error:(0,r.serializeError)(i,{shouldIncludeStack:!0}),id:s.id}):t.write({jsonrpc:"2.0",result:n,id:s.id}):i&&console.error(i)}}}},{package:"$root$",file:"app/scripts/lib/createMetaRPCHandler.js"}],[26,{"../../../shared/constants/bridge":5712,"../../../shared/constants/time":5747,"../../../shared/lib/fetch-with-cache":5804,"../../../shared/lib/trace":5830,"../lib/util":358,"@metamask/bridge-controller":1353,"@metamask/controller-utils":1419},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BridgeControllerInit=void 0;var r,a=e("@metamask/bridge-controller"),n=e("@metamask/controller-utils"),i=e("../../../shared/constants/bridge"),o=e("../../../shared/lib/trace"),c=(r=e("../../../shared/lib/fetch-with-cache"))&&r.__esModule?r:{default:r},l=e("../../../shared/constants/time"),d=e("../lib/util");s.BridgeControllerInit=({controllerMessenger:e,initMessenger:t,getController:s})=>{const r=s("TransactionController");return{persistedStateKey:null,memStateKey:null,controller:new a.BridgeController({messenger:e,clientId:a.BridgeClientId.EXTENSION,clientVersion:"13.14.0-flask.0",getLayer1GasFee:(...e)=>r.getLayer1GasFee(...e),fetchFn:async(e,t)=>{const s=e.toString();if(s.includes("getTokens"))return await(0,c.default)({url:s,fetchOptions:{method:"GET",...t},cacheOptions:{cacheRefreshTime:10*l.MINUTE},functionName:"fetchBridgeTokens"});if(s.includes("spot-prices"))return await(0,c.default)({url:s,fetchOptions:{method:"GET",...t},cacheOptions:{cacheRefreshTime:30*l.SECOND},functionName:"fetchAssetExchangeRates"});if(s.includes("getQuote?"))return await(0,n.handleFetch)(e,{method:"GET",...t});const r=await fetch(e,t);if(!r.ok)throw new n.HttpError(r.status,`Fetch failed with status '${r.status}' for request ${s}`);return r},trackMetaMetricsFn:(e,s)=>{const r=(Date.now()+Math.random()).toString();t.call("MetaMetricsController:trackEvent",{category:a.UNIFIED_SWAP_BRIDGE_EVENT_CATEGORY,event:e,properties:{...s??{},environmentType:(0,d.getEnvironmentType)(),actionId:r}})},traceFn:(...e)=>(0,o.trace)(...e),config:{customBridgeApiBaseUrl:i.BRIDGE_API_BASE_URL}})}}}}},{package:"$root$",file:"app/scripts/controller-init/bridge-controller-init.ts"}],[260,{"./middleware/pending":282,"@metamask/eth-json-rpc-middleware":1855,"@metamask/json-rpc-engine/v2":2089},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({version:e,getAccounts:t,processTransaction:s,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:d,processEncryptionPublicKey:u,getPendingNonce:h,getPendingTransactionByHash:f,processRequestExecutionPermissions:m}){const p=a.JsonRpcEngineV2.create({middleware:[(0,a.createScaffoldMiddleware)({eth_syncing:!1,web3_clientVersion:`MetaMask/v${e}`}),(0,r.createWalletMiddleware)({getAccounts:t,processTransaction:s,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:d,processEncryptionPublicKey:u,processRequestExecutionPermissions:m}),(0,n.createPendingNonceMiddleware)({getPendingNonce:h}),(0,n.createPendingTxMiddleware)({getPendingTransactionByHash:f})]});return(0,a.asLegacyMiddleware)(p)};var r=e("@metamask/eth-json-rpc-middleware"),a=e("@metamask/json-rpc-engine/v2"),n=e("./middleware/pending")}}},{package:"$root$",file:"app/scripts/lib/createMetamaskMiddleware.ts"}],[2607,{"@metamask/base-controller":1346,"@metamask/swappable-obj-proxy":2921},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},d=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=s.METAMASK_DOMAIN=void 0;const u=e("@metamask/base-controller"),h=e("@metamask/swappable-obj-proxy"),f="SelectedNetworkController",m={domains:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0}};s.METAMASK_DOMAIN="metamask",s.SelectedNetworkControllerActionTypes={getState:`${f}:getState`,getNetworkClientIdForDomain:`${f}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${f}:setNetworkClientIdForDomain`},s.SelectedNetworkControllerEventTypes={stateChange:`${f}:stateChange`};class p extends u.BaseController{constructor({messenger:e,state:t={domains:{}},domainProxyMap:s}){super({name:f,metadata:m,messenger:e,state:t}),r.add(this),a.set(this,void 0),l(this,a,s,"f"),d(this,r,"m",n).call(this),this.messenger.call("PermissionController:getSubjectNames").filter(e=>this.state.domains[e]===undefined).forEach(e=>this.setNetworkClientIdForDomain(e,this.messenger.call("NetworkController:getState").selectedNetworkClientId)),this.messenger.subscribe("PermissionController:stateChange",(e,t)=>{t.forEach(({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const s=t[1];"add"===e&&this.state.domains[s]===undefined?this.setNetworkClientIdForDomain(s,this.messenger.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[s]!==undefined&&d(this,r,"m",o).call(this,s)}})}),this.messenger.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e,networkConfigurationsByChainId:t},s)=>{const r=s.find(({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]);if(r){const s=Object.values(t).reduce((e,t)=>(t.rpcEndpoints.forEach(({networkClientId:s})=>e[s]=t.chainId),e),{});Object.entries(this.state.domains).forEach(([a,n])=>{const i=s[n];if("remove"!==r.op||i){if("replace"===r.op){const e=r.path[1];if(!i||i===e){const s=t[e],{networkClientId:r}=s.rpcEndpoints[s.defaultRpcEndpointIndex];n!==r&&this.setNetworkClientIdForDomain(a,r)}}}else this.setNetworkClientIdForDomain(a,e)})}})}setNetworkClientIdForDomain(e,t){if(e===s.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${s.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!d(this,r,"m",c).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");d(this,r,"m",i).call(this,e,t)}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messenger.call("NetworkController:getState");return this.state.domains[e]??t}getProviderAndBlockTracker(e){if(e===s.METAMASK_DOMAIN){const e=this.messenger.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=d(this,a,"f").get(e);if(t===undefined){let s;if(d(this,r,"m",c).call(this,e)){const t=this.getNetworkClientIdForDomain(e);s=this.messenger.call("NetworkController:getNetworkClientById",t)}else if(s=this.messenger.call("NetworkController:getSelectedNetworkClient"),s===undefined)throw new Error("Selected network not initialized");t={provider:(0,h.createEventEmitterProxy)(s.provider),blockTracker:(0,h.createEventEmitterProxy)(s.blockTracker,{eventFilter:"skipInternal"})},d(this,a,"f").set(e,t)}return t}}s.SelectedNetworkController=p,a=new WeakMap,r=new WeakSet,n=function(){this.messenger.registerActionHandler(s.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messenger.registerActionHandler(s.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},i=function(e,t){const s=this.messenger.call("NetworkController:getNetworkClientById",t);this.update(s=>{s.domains[e]=t});const r=this.getProviderAndBlockTracker(e);r.provider.setTarget(s.provider),r.blockTracker.setTarget(s.blockTracker)},o=function(e){const t=this.messenger.call("NetworkController:getSelectedNetworkClient"),s=d(this,a,"f").get(e);s&&t?(s.provider.setTarget(t.provider),s.blockTracker.setTarget(t.blockTracker)):s&&d(this,a,"f").delete(e),this.update(t=>{delete t.domains[e]})},c=function(e){return this.messenger.call("PermissionController:hasPermissions",e)}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],[2608,{"./SelectedNetworkController.cjs":2607},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=void 0;const r=e("./SelectedNetworkController.cjs");s.createSelectedNetworkMiddleware=e=>(t,s,a)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var n;return t.networkClientId=(n=t.origin,e.call(r.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,n)),a()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],[2609,{"./SelectedNetworkController.cjs":2607,"./SelectedNetworkMiddleware.cjs":2608},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=s.METAMASK_DOMAIN=s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=void 0;var r=e("./SelectedNetworkController.cjs");Object.defineProperty(s,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return r.SelectedNetworkControllerActionTypes}}),Object.defineProperty(s,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return r.SelectedNetworkControllerEventTypes}}),Object.defineProperty(s,"SelectedNetworkController",{enumerable:!0,get:function(){return r.SelectedNetworkController}}),Object.defineProperty(s,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return r.METAMASK_DOMAIN}});var a=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(s,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return a.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],[261,{loglevel:4781,"webextension-polyfill":5698},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({location:e,registerOnboarding:t}){return async function(s,n,i,o){try{if("wallet_registerOnboarding"!==s.method)return void i();s.tabId&&s.tabId!==a.default.tabs.TAB_ID_NONE?await t(e,s.tabId):r.default.debug(`'wallet_registerOnboarding' message from ${e} ignored due to missing tabId`),n.result=!0,o()}catch(e){o(e)}}};var r=n(e("loglevel")),a=n(e("webextension-polyfill"));function n(e){return e&&e.__esModule?e:{default:e}}}}},{package:"$root$",file:"app/scripts/lib/createOnboardingMiddleware.js"}],[2610,{"./constants.cjs":2612,"./logger.cjs":2614,"@metamask/base-controller":1346,"@metamask/signature-controller":2617,"@metamask/transaction-controller":2970,lodash:4773},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u,h,f,m,p,g,b,w=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},y=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ShieldController=s.getDefaultShieldControllerState=void 0;const S=e("@metamask/base-controller"),v=e("@metamask/signature-controller"),_=e("@metamask/transaction-controller"),k=e("lodash"),E=e("./constants.cjs"),T=e("./logger.cjs"),P=(0,T.createModuleLogger)(T.projectLogger,"ShieldController");function R(){return{coverageResults:{},orderedTransactionHistory:[]}}s.getDefaultShieldControllerState=R;const A={coverageResults:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},orderedTransactionHistory:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!1}};class C extends S.BaseController{constructor(e){const{messenger:t,state:s,backend:f,transactionHistoryLimit:m=100,coverageHistoryLimit:p=10,normalizeSignatureRequest:g}=e;super({name:E.controllerName,metadata:A,messenger:t,state:{coverageResults:{},orderedTransactionHistory:[],...s}}),r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),w(this,a,f,"f"),w(this,n,p,"f"),w(this,i,m,"f"),w(this,c,y(this,r,"m",h).bind(this),"f"),w(this,l,y(this,r,"m",u).bind(this),"f"),w(this,d,!1,"f"),w(this,o,g,"f")}start(){y(this,d,"f")||(w(this,d,!0,"f"),this.messenger.subscribe("TransactionController:stateChange",y(this,c,"f"),e=>e.transactions),this.messenger.subscribe("SignatureController:stateChange",y(this,l,"f"),e=>e.signatureRequests))}stop(){y(this,d,"f")&&(w(this,d,!1,"f"),this.messenger.unsubscribe("TransactionController:stateChange",y(this,c,"f")),this.messenger.unsubscribe("SignatureController:stateChange",y(this,l,"f")))}async checkCoverage(e){const t=y(this,r,"m",b).call(this,e.id),s=await y(this,a,"f").checkCoverage({txMeta:e,coverageId:t});return this.messenger.publish(`${E.controllerName}:coverageResultReceived`,s),y(this,r,"m",f).call(this,e.id,s),s}async checkSignatureCoverage(e){const t=y(this,r,"m",b).call(this,e.id),s=(0,k.cloneDeep)(e),n=y(this,o,"f")?.call(this,s)??s,i=await y(this,a,"f").checkSignatureCoverage({signatureRequest:n,coverageId:t});return this.messenger.publish(`${E.controllerName}:coverageResultReceived`,i),y(this,r,"m",f).call(this,e.id,i),i}}s.ShieldController=C,a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,r=new WeakSet,u=function(e,t){const s=Object.values(e),a=Object.values(t??{}),n=new Map(a.map(e=>[e.id,e]));for(const e of s){const t=n.get(e.id);t||this.checkSignatureCoverage(e).catch(e=>P("Error checking coverage:",e)),e.status===v.SignatureRequestStatus.Signed&&e.status!==t?.status&&y(this,r,"m",m).call(this,e).catch(e=>P("Error logging signature:",e))}},h=function(e,t){const s=new Map(t?.map(e=>[e.id,e])??[]);for(const t of e){const e=s.get(t.id);if(t.status!==_.TransactionStatus.submitted&&t.status!==_.TransactionStatus.confirmed){const s=e?.simulationData&&!(0,k.isEqual)(t.simulationData,e.simulationData);e&&!s||this.checkCoverage(t).catch(e=>P("Error checking coverage:",e))}t.status===_.TransactionStatus.submitted&&t.status!==e?.status&&y(this,r,"m",p).call(this,t).catch(e=>P("Error logging transaction:",e))}},f=function(e,t){const s=y(this,r,"m",b).call(this,e);if(s&&t.coverageId!==s)throw new Error("Coverage ID has changed");this.update(s=>{let r=!1,a=s.coverageResults[e];a||(r=!0,a={results:[]},s.coverageResults[e]=a),a.results.length>=y(this,n,"f")&&a.results.pop(),a.results.unshift(t);const{orderedTransactionHistory:o}=s;let c;r&&(o.length>=y(this,i,"f")&&(c=o.pop(),c&&delete s.coverageResults[c]),o.unshift(e))})},m=async function(e){const t=e.rawSig;if(!t)throw new Error("Signature not found");const{status:s}=y(this,r,"m",g).call(this,e.id);await y(this,a,"f").logSignature({signatureRequest:e,signature:t,status:s})},p=async function(e){const t=e.hash;if(!t)throw new Error("Transaction hash not found");const s=e.rawTx;if(!s)throw new Error("Raw transaction hex not found");const{status:n}=y(this,r,"m",g).call(this,e.id);await y(this,a,"f").logTransaction({txMeta:e,transactionHash:t,rawTransactionHex:s,status:n})},g=function(e){let t="shown";return y(this,r,"m",b).call(this,e)||(P("Coverage ID not found for",e),t="not_shown"),{status:t}},b=function(e){return this.state.coverageResults[e]?.results[0]?.coverageId}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/ShieldController.cjs"}],[2611,{"./constants.cjs":2612,"./polling-with-policy.cjs":2615,"@metamask/controller-utils":1419,"@metamask/signature-controller":2617},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.parseSignatureRequestMethod=s.makeInitCoverageCheckBody=s.ShieldRemoteBackend=void 0;const f=e("@metamask/controller-utils"),m=e("@metamask/signature-controller"),p=e("./constants.cjs"),g=e("./polling-with-policy.cjs");function b(e){return{txParams:[{authorizationList:e.txParams.authorizationList,from:e.txParams.from,to:e.txParams.to,value:e.txParams.value,data:e.txParams.data,nonce:e.txParams.nonce}],chainId:e.chainId,origin:e.origin}}function w(e){const t=y(e);return{chainId:e.chainId,data:e.messageParams.data,from:e.messageParams.from,method:t,origin:e.messageParams.origin}}function y(e){if(e.type===m.SignatureRequestType.TypedSign)switch(e.version){case p.SignTypedDataVersion.V3:return m.EthMethod.SignTypedDataV3;case p.SignTypedDataVersion.V4:return m.EthMethod.SignTypedDataV4;case p.SignTypedDataVersion.V1:default:return m.SignatureRequestType.TypedSign}return e.type}s.ShieldRemoteBackend=class{constructor({getAccessToken:e,getCoverageResultTimeout:t=5e3,getCoverageResultPollInterval:s=1e3,baseUrl:c,fetch:l}){r.add(this),a.set(this,void 0),n.set(this,void 0),i.set(this,void 0),o.set(this,void 0),u(this,a,e,"f"),u(this,n,c,"f"),u(this,i,l,"f");const{backoff:d,maxRetries:h}=function(e,t){const s=new f.ConstantBackoff(t),r=Math.floor(e/t)+1,a=isNaN(r)||!isFinite(r)?f.DEFAULT_MAX_RETRIES:r;return{backoff:s,maxRetries:a}}(t,s);u(this,o,new g.PollingWithCockatielPolicy({backoff:d,maxRetries:h}),"f")}async checkCoverage(e){let{coverageId:t}=e;if(!t){const s=b(e.txMeta);({coverageId:t}=await h(this,r,"m",c).call(this,"v1/transaction/coverage/init",s))}const s=`${h(this,n,"f")}/v1/transaction/coverage/result`,a=await h(this,r,"m",l).call(this,e.txMeta.id,t,s);return{coverageId:t,message:a.message,reasonCode:a.reasonCode,status:a.status,metrics:a.metrics}}async checkSignatureCoverage(e){let{coverageId:t}=e;if(!t){const s=w(e.signatureRequest);({coverageId:t}=await h(this,r,"m",c).call(this,"v1/signature/coverage/init",s))}const s=`${h(this,n,"f")}/v1/signature/coverage/result`,a=await h(this,r,"m",l).call(this,e.signatureRequest.id,t,s);return{coverageId:t,message:a.message,reasonCode:a.reasonCode,status:a.status,metrics:a.metrics}}async logSignature(e){const t=w(e.signatureRequest),s={signature:e.signature,status:e.status,...t};h(this,o,"f").abortPendingRequest(e.signatureRequest.id);const a=await h(this,i,"f").call(this,`${h(this,n,"f")}/v1/signature/coverage/log`,{method:"POST",headers:await h(this,r,"m",d).call(this),body:JSON.stringify(s)});if(200!==a.status)throw new Error(`Failed to log signature: ${a.status}`)}async logTransaction(e){const t=b(e.txMeta),s={transactionHash:e.transactionHash,rawTransactionHex:e.rawTransactionHex,status:e.status,...t};h(this,o,"f").abortPendingRequest(e.txMeta.id);const a=await h(this,i,"f").call(this,`${h(this,n,"f")}/v1/transaction/coverage/log`,{method:"POST",headers:await h(this,r,"m",d).call(this),body:JSON.stringify(s)});if(200!==a.status)throw new Error(`Failed to log transaction: ${a.status}`)}},a=new WeakMap,n=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakSet,c=async function(e,t){const s=await h(this,i,"f").call(this,`${h(this,n,"f")}/${e}`,{method:"POST",headers:await h(this,r,"m",d).call(this),body:JSON.stringify(t)});if(200!==s.status)throw new Error(`Failed to init coverage check: ${s.status}`);return await s.json()},l=async function(e,t,s){const a={coverageId:t},n=await h(this,r,"m",d).call(this),c=Date.now();return{...await h(this,o,"f").start(e,async e=>{const t=await h(this,i,"f").call(this,s,{method:"POST",headers:n,body:JSON.stringify(a),signal:e});if(200===t.status)return await t.json();let r="Timeout waiting for coverage result";try{const e=await t.json();r=`Failed to get coverage result: ${e.message||e.status}`}catch{r=`Failed to get coverage result: ${t.status}`}throw new f.HttpError(t.status,r)}),metrics:{latency:Date.now()-c}}},d=async function(){return{"Content-Type":"application/json",Authorization:`Bearer ${await h(this,a,"f").call(this)}`}},s.makeInitCoverageCheckBody=b,s.parseSignatureRequestMethod=y}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/backend.cjs"}],[2612,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r;Object.defineProperty(s,"__esModule",{value:!0}),s.SignTypedDataVersion=s.controllerName=void 0,s.controllerName="ShieldController",function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(r||(s.SignTypedDataVersion=r={}))}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/constants.cjs"}],[2613,{"./ShieldController.cjs":2610,"./backend.cjs":2611},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.parseSignatureRequestMethod=s.ShieldRemoteBackend=s.getDefaultShieldControllerState=s.ShieldController=void 0;var r=e("./ShieldController.cjs");Object.defineProperty(s,"ShieldController",{enumerable:!0,get:function(){return r.ShieldController}}),Object.defineProperty(s,"getDefaultShieldControllerState",{enumerable:!0,get:function(){return r.getDefaultShieldControllerState}});var a=e("./backend.cjs");Object.defineProperty(s,"ShieldRemoteBackend",{enumerable:!0,get:function(){return a.ShieldRemoteBackend}}),Object.defineProperty(s,"parseSignatureRequestMethod",{enumerable:!0,get:function(){return a.parseSignatureRequestMethod}})}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/index.cjs"}],[2614,{"./constants.cjs":2612,"@metamask/utils":3051},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(s,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}});const a=e("./constants.cjs");s.projectLogger=(0,r.createProjectLogger)(a.controllerName)}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/logger.cjs"}],[2615,{"@metamask/controller-utils":1419,cockatiel:4079},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,a,n,i,o,c,l=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},d=this&&this.__classPrivateFieldSet||function(e,t,s,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,s):a?a.value=s:t.set(e,s),s};Object.defineProperty(s,"__esModule",{value:!0}),s.PollingWithCockatielPolicy=void 0;const u=e("@metamask/controller-utils"),h=e("cockatiel");s.PollingWithCockatielPolicy=class{constructor(e={}){r.add(this),a.set(this,void 0),n.set(this,new Map);const t=(0,h.handleWhen)(l(this,r,"m",c));d(this,a,(0,u.createServicePolicy)({...e,retryFilterPolicy:t}),"f")}async start(e,t){const s=l(this,r,"m",i).call(this,e);try{return await l(this,a,"f").execute(async({signal:e})=>t(e),s.signal)}catch(e){if(s.signal.aborted)throw new Error("Request cancelled");throw e}finally{s===l(this,n,"f").get(e)&&l(this,r,"m",o).call(this,e)}}abortPendingRequest(e){const t=l(this,n,"f").get(e);t?.abort(),l(this,r,"m",o).call(this,e)}},a=new WeakMap,n=new WeakMap,r=new WeakSet,i=function(e){this.abortPendingRequest(e);const t=new AbortController;return l(this,n,"f").set(e,t),t},o=function(e){l(this,n,"f").delete(e)},c=function(e){return e instanceof u.HttpError&&(e.httpStatus>400&&e.httpStatus<500)}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/polling-with-policy.cjs"}],[262,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function(e){return function(t,s,r){t.origin=e.origin,r()}}}}},{package:"$root$",file:"app/scripts/lib/createOriginMiddleware.js"}],[263,{"../../../shared/constants/app":5710,"@metamask/rpc-errors":2584},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.SPAM_FILTER_ACTIVATED_ERROR=s.REJECTION_THRESHOLD_IN_MS=s.NUMBER_OF_REJECTIONS_THRESHOLD=s.BLOCKING_THRESHOLD_IN_MS=s.BLOCKABLE_METHODS=void 0,s.default=function({getThrottledOriginState:e,updateThrottledOriginState:t}){return function(s,r,a,h){const{method:f,origin:m}=s;if(!c.has(f)||l.includes(m))return void a();!function(e){if(!e)return!1;const t=Date.now(),{rejections:s,lastRejection:r}=e,a=t-r<=o;return s>=n&&a}(e(m))?a(s=>{if("error"in r&&r.error&&u(r.error)){var a;const n=null===(a=r.error)||void 0===a?void 0:a.data;if("rejectAllApprovals"===(null==n?void 0:n.cause))return void s();const o=e(m)||{rejections:0,lastRejection:0},c=Date.now(),l=c-o.lastRejection<i?o.rejections+1:1;t(m,{rejections:l,lastRejection:c})}else{const s=e(m);Boolean(s)&&t(m,{rejections:0,lastRejection:0})}s()}):h(d)}};var r=e("@metamask/rpc-errors"),a=e("../../../shared/constants/app");const n=s.NUMBER_OF_REJECTIONS_THRESHOLD=3,i=s.REJECTION_THRESHOLD_IN_MS=3e4,o=s.BLOCKING_THRESHOLD_IN_MS=6e4,c=s.BLOCKABLE_METHODS=new Set([a.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN,a.MESSAGE_TYPE.ETH_SEND_TRANSACTION,a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA,a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1,a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3,a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4,a.MESSAGE_TYPE.PERSONAL_SIGN,a.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN,a.MESSAGE_TYPE.WALLET_SEND_CALLS,a.MESSAGE_TYPE.WATCH_ASSET]),l=["http://127.0.0.1:8080","http://127.0.0.1:8081","http://127.0.0.1:8082","http://localhost:8080","http://localhost:8081","http://localhost:8082"],d=s.SPAM_FILTER_ACTIVATED_ERROR=r.providerErrors.unauthorized("Request blocked due to spam filter."),u=e=>e.code===r.errorCodes.provider.userRejectedRequest}}},{package:"$root$",file:"app/scripts/lib/createOriginThrottlingMiddleware.ts"}]],[],{});