LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js",{"./build/multichain-openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json","./build/openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.MultiChainOpenRPCDocument=n.MetaMaskOpenRPCDocument=void 0;const s=r(e("./build/openrpc.json"));n.MetaMaskOpenRPCDocument=s.default;const o=r(e("./build/multichain-openrpc.json"));n.MultiChainOpenRPCDocument=o.default,n.default=s.default}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/ClaimsController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/constants.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.ClaimsController=n.getDefaultClaimsControllerState=void 0;const a=e("@metamask/base-controller"),i=e("@metamask/controller-utils"),c=e("@metamask/utils"),m=e("./constants.cjs"),d={claims:{includeInStateLogs:!1,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},claimsConfigurations:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!0,usedInUi:!0}};function u(){return{claimsConfigurations:m.DEFAULT_CLAIMS_CONFIGURATIONS,claims:[]}}n.getDefaultClaimsControllerState=u;class l extends a.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:d,name:m.CONTROLLER_NAME,state:{...u(),...t}}),r.add(this)}async fetchClaimsConfigurations(){const e=await this.messenger.call(`${m.SERVICE_NAME}:fetchClaimsConfigurations`),t=e.networks.map(e=>(0,i.toHex)(e)),n={validSubmissionWindowDays:e.validSubmissionWindowDays,supportedNetworks:t};return this.update(e=>{e.claimsConfigurations=n}),n}async getSubmitClaimConfig(e){o(this,r,"m",s).call(this,e);return{data:e,headers:await this.messenger.call(`${m.SERVICE_NAME}:getRequestHeaders`),method:"POST",url:`${this.messenger.call(`${m.SERVICE_NAME}:getClaimsApiUrl`)}/claims`}}async generateClaimSignature(e,t){const{message:n}=await this.messenger.call(`${m.SERVICE_NAME}:generateMessageForClaimSignature`,e,t),r=(0,c.stringToBytes)(n),s=(0,c.bytesToHex)(r),o=(0,i.detectSIWE)({data:s});if(!o.isSIWEMessage)throw new Error(m.ClaimsControllerErrorMessages.INVALID_SIGNATURE_MESSAGE);return await this.messenger.call("KeyringController:signPersonalMessage",{data:n,from:t,siwe:o})}async getClaims(){const e=await this.messenger.call(`${m.SERVICE_NAME}:getClaims`);return this.update(t=>{t.claims=e}),e}}n.ClaimsController=l,r=new WeakSet,s=function(e){const{claims:t}=this.state;if(t.some(t=>t.impactedTxHash===e.impactedTxHash))throw new Error(m.ClaimsControllerErrorMessages.CLAIM_ALREADY_SUBMITTED)}}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/ClaimsController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/ClaimsService.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/constants.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.ClaimsService=void 0;const c=e("./constants.cjs");n.ClaimsService=class{constructor({env:e,messenger:t,fetchFunction:n}){this.name=c.SERVICE_NAME,r.set(this,void 0),s.set(this,void 0),o.set(this,void 0),a(this,r,e,"f"),a(this,o,t,"f"),a(this,s,n,"f"),i(this,o,"f").registerActionHandler(`${c.SERVICE_NAME}:fetchClaimsConfigurations`,this.fetchClaimsConfigurations.bind(this)),i(this,o,"f").registerActionHandler(`${c.SERVICE_NAME}:getClaims`,this.getClaims.bind(this)),i(this,o,"f").registerActionHandler(`${c.SERVICE_NAME}:getClaimById`,this.getClaimById.bind(this)),i(this,o,"f").registerActionHandler(`${c.SERVICE_NAME}:getRequestHeaders`,this.getRequestHeaders.bind(this)),i(this,o,"f").registerActionHandler(`${c.SERVICE_NAME}:getClaimsApiUrl`,this.getClaimsApiUrl.bind(this)),i(this,o,"f").registerActionHandler(`${c.SERVICE_NAME}:generateMessageForClaimSignature`,this.generateMessageForClaimSignature.bind(this))}async fetchClaimsConfigurations(){const e=await this.getRequestHeaders(),t=`${this.getClaimsApiUrl()}/configurations`,n=await i(this,s,"f").call(this,t,{headers:e});if(!n.ok)throw new Error(c.ClaimsServiceErrorMessages.FAILED_TO_FETCH_CONFIGURATIONS);return await n.json()}async getClaims(){const e=await this.getRequestHeaders(),t=`${this.getClaimsApiUrl()}/claims`,n=await i(this,s,"f").call(this,t,{headers:e});if(!n.ok)throw new Error(c.ClaimsServiceErrorMessages.FAILED_TO_GET_CLAIMS);return await n.json()}async getClaimById(e){const t=await this.getRequestHeaders(),n=`${this.getClaimsApiUrl()}/claims/byId/${e}`,r=await i(this,s,"f").call(this,n,{headers:t});if(!r.ok)throw new Error(c.ClaimsServiceErrorMessages.FAILED_TO_GET_CLAIM_BY_ID);return await r.json()}async generateMessageForClaimSignature(e,t){const n=await this.getRequestHeaders(),r=`${this.getClaimsApiUrl()}/signature/generateMessage`,o=await i(this,s,"f").call(this,r,{method:"POST",headers:{...n,"Content-Type":"application/json"},body:JSON.stringify({chainId:e,walletAddress:t})});if(!o.ok)throw new Error(c.ClaimsServiceErrorMessages.SIGNATURE_MESSAGE_GENERATION_FAILED);return await o.json()}async getRequestHeaders(){return{Authorization:`Bearer ${await i(this,o,"f").call("AuthenticationController:getBearerToken")}`}}getClaimsApiUrl(){return`${c.CLAIMS_API_URL_MAP[i(this,r,"f")]}`}},r=new WeakMap,s=new WeakMap,o=new WeakMap}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/ClaimsService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/constants.cjs",{"@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DEFAULT_CLAIMS_CONFIGURATIONS=n.ClaimsServiceErrorMessages=n.ClaimsControllerErrorMessages=n.CLAIMS_API_URL_MAP=n.ClaimStatusEnum=n.Env=n.SERVICE_NAME=n.CONTROLLER_NAME=void 0;const r=e("@metamask/controller-utils");var s,o;n.CONTROLLER_NAME="ClaimsController",n.SERVICE_NAME="ClaimsService",function(e){e.DEV="dev",e.UAT="uat",e.PRD="prd"}(s||(n.Env=s={})),function(e){e.CREATED="created",e.SUBMITTED="submitted",e.IN_PROGRESS="in_progress",e.WAITING_FOR_CUSTOMER="waiting_for_customer",e.APPROVED="approved",e.REJECTED="rejected",e.UNKNOWN="unknown"}(o||(n.ClaimStatusEnum=o={})),n.CLAIMS_API_URL_MAP={[s.DEV]:"https://claims.dev-api.cx.metamask.io",[s.UAT]:"https://claims.uat-api.cx.metamask.io",[s.PRD]:"https://claims.api.cx.metamask.io"},n.ClaimsControllerErrorMessages={CLAIM_ALREADY_SUBMITTED:"Claim already submitted",INVALID_CLAIM_SIGNATURE:"Invalid claim signature",INVALID_SIGNATURE_MESSAGE:"Invalid signature message"},n.ClaimsServiceErrorMessages={FAILED_TO_FETCH_CONFIGURATIONS:"Failed to fetch claims configurations",FAILED_TO_GET_CLAIMS:"Failed to get claims",FAILED_TO_GET_CLAIM_BY_ID:"Failed to get claim by id",SIGNATURE_MESSAGE_GENERATION_FAILED:"Failed to generate message for claim signature",CLAIM_SIGNATURE_VERIFICATION_REQUEST_FAILED:"Failed to verify claim signature"},n.DEFAULT_CLAIMS_CONFIGURATIONS={validSubmissionWindowDays:21,supportedNetworks:[r.ChainId[r.BuiltInNetworkName.Mainnet],r.ChainId[r.BuiltInNetworkName.LineaMainnet]]}}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/index.cjs",{"./ClaimsController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/ClaimsController.cjs","./ClaimsService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/ClaimsService.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/claims-controller/dist/constants.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CLAIMS_API_URL_MAP=n.ClaimsServiceErrorMessages=n.DEFAULT_CLAIMS_CONFIGURATIONS=n.ClaimsControllerErrorMessages=n.Env=n.ClaimStatusEnum=n.ClaimsService=n.getDefaultClaimsControllerState=n.ClaimsController=void 0;var r=e("./ClaimsController.cjs");Object.defineProperty(n,"ClaimsController",{enumerable:!0,get:function(){return r.ClaimsController}}),Object.defineProperty(n,"getDefaultClaimsControllerState",{enumerable:!0,get:function(){return r.getDefaultClaimsControllerState}});var s=e("./ClaimsService.cjs");Object.defineProperty(n,"ClaimsService",{enumerable:!0,get:function(){return s.ClaimsService}});var o=e("./constants.cjs");Object.defineProperty(n,"ClaimStatusEnum",{enumerable:!0,get:function(){return o.ClaimStatusEnum}}),Object.defineProperty(n,"Env",{enumerable:!0,get:function(){return o.Env}}),Object.defineProperty(n,"ClaimsControllerErrorMessages",{enumerable:!0,get:function(){return o.ClaimsControllerErrorMessages}}),Object.defineProperty(n,"DEFAULT_CLAIMS_CONFIGURATIONS",{enumerable:!0,get:function(){return o.DEFAULT_CLAIMS_CONFIGURATIONS}}),Object.defineProperty(n,"ClaimsServiceErrorMessages",{enumerable:!0,get:function(){return o.ClaimsServiceErrorMessages}}),Object.defineProperty(n,"CLAIMS_API_URL_MAP",{enumerable:!0,get:function(){return o.CLAIMS_API_URL_MAP}})}}},{package:"@metamask/claims-controller",file:"node_modules/@metamask/claims-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={"0x12652C6d93FDB6F4f37d48A8687783C782BB0d10":{name:"Entangle",logo:"NGL.svg",erc20:!0,symbol:"NGL",decimals:18},"0xB50721BCf8d664c30412Cfbc6cf7a15145234ad1":{name:"Arbitrum",logo:"Arb.svg",erc20:!0,symbol:"ARB",decimals:18},"0x4D0528598F916Fd1D8dc80e5f54a8fEEDcFd4b18":{name:"Atoshi",logo:"ATOS.svg",erc20:!0,symbol:"ATOS",decimals:18},"0x57B946008913B82E4dF85f501cbAeD910e58D26C":{name:"POND",logo:"POND.svg",erc20:!0,symbol:"POND",decimals:18},"0x5eed99d066a8CaF10f3E4327c1b3D8b673485eED":{name:"SEED",logo:"SEED.svg",erc20:!0,symbol:"SEED",decimals:18},"0x487d62468282Bd04ddf976631C23128A425555EE":{name:"UPCX",logo:"UPC.svg",erc20:!0,symbol:"UPC",decimals:5},"0xd3210F246Ae54C5a45A7b4A83315bf718F591bfc":{name:"ArkiTech",logo:"ARKI.svg",erc20:!0,symbol:"ARKI",decimals:9},"0x7d51888C5ABb7CDfa9cdd6A50673c7F8afAccD7F":{name:"DuckDAO Token",logo:"duckdao.svg",erc20:!0,symbol:"DD",decimals:18},"0x49642110B712C1FD7261Bc074105E9E44676c68F":{name:"DinoLFG",logo:"DINO.svg",erc20:!0,symbol:"DINO",decimals:18},"0xB8BAa0e4287890a5F79863aB62b7F175ceCbD433":{name:"Swerve DAO Token",logo:"swrv.svg",erc20:!0,symbol:"SWRV",decimals:18},"0x8b79656FC38a04044E495e22fAD747126ca305C4":{name:"AgaveCoin",logo:"agvc.svg",erc20:!0,symbol:"AGVC",decimals:18},"0x967da4048cD07aB37855c090aAF366e4ce1b9F48":{name:"Ocean Token",logo:"ocean.svg",erc20:!0,symbol:"OCEAN",decimals:18},"0x83e6f1E41cdd28eAcEB20Cb649155049Fac3D5Aa":{name:"PolkastarterToken",logo:"pols.svg",erc20:!0,symbol:"POLS",decimals:18},"0x08d967bb0134F2d07f7cfb6E246680c53927DD30":{name:"MATH Token",logo:"math.svg",erc20:!0,symbol:"MATH",decimals:18},"0xccC8cb5229B0ac8069C51fd58367Fd1e622aFD97":{name:"Gods Unchained",logo:"gods.svg",erc20:!0,symbol:"GODS",decimals:18},"0xF57e7e7C23978C3cAEC3C3548E3D615c346e79fF":{name:"Immutable X",logo:"imx.svg",erc20:!0,symbol:"IMX",decimals:18},"0x40D16FC0246aD3160Ccc09B8D0D3A2cD28aE6C2f":{name:"Gho Token",logo:"GHO.svg",erc20:!0,symbol:"GHO",decimals:18},"0x536381a8628dBcC8C70aC9A30A7258442eAb4c92":{name:"Pantos Token ",logo:"pan.svg",erc20:!0,symbol:"PAN",decimals:8},"0x011E128Ec62840186F4A07E85E3ACe28858c5606":{name:"Valeria",logo:"val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x6c3ea9036406852006290770BEdFcAbA0e23A0e8":{name:"PayPal USD",logo:"pyusd.svg",erc20:!0,symbol:"PYUSD",decimals:6},"0x8b385Ca3592A5EFc34E0C9fE663de56897F1751F":{name:"INFibit",logo:"INFibit.svg",erc20:!0,symbol:"IBIT",decimals:18},"0x9bf1D7D63dD7a4ce167CF4866388226EEefa702E":{name:"Ben Coin",logo:"BEN.svg",erc20:!0,symbol:"BEN",decimals:18},"0xC7a2572fA8FDB0f7E81d6D3c4e3CCF78FB0DC374":{name:"Bens Finale",logo:"BensFinale.svg",erc20:!0,symbol:"FINALE",decimals:18},"0x99cFB8cBA9c821B4a343c6a1Fc630465C9708DF5":{name:"Pepe Inu",logo:"PepeInu.svg",erc20:!0,symbol:"$PEPEINU",decimals:18},"0xCEBA2a8F6Ec221AEB5f3a7bcd15Cbc7e6a387bfb":{name:"Peter Pan",logo:"PeterPan.svg",erc20:!0,symbol:"PAN",decimals:18},"0x467719aD09025FcC6cF6F8311755809d45a5E5f3":{name:"Axelar",logo:"axelar.svg",erc20:!0,symbol:"AXL",decimals:6},"0x665F77fbA5975ab40Ce61c90F28007fb5b09D7B1":{name:"Genieswap",logo:"Genieswap.svg",erc20:!0,symbol:"GENIE",decimals:18},"0x09E6d500D14D13e0528d2c0fff24E5ffF68237B4":{name:"Dohrnii",logo:"dhn.svg",erc20:!0,symbol:"DHN",decimals:18},"0xaE0585a259A3BCAB258D6EE02FB583f7B33C2a12":{name:"TempleCoin",logo:"tem.svg",erc20:!0,symbol:"TEM",decimals:18},"0xaeDf386B755465871fF874E3E37Af5976E247064":{name:"Fasttoken",logo:"ftn.svg",erc20:!0,symbol:"FTN",decimals:18},"0x7BEF710a5759d197EC0Bf621c3Df802C2D60D848":{name:"SHOPX",logo:"SHOPX.svg",erc20:!0,symbol:"SHOPX",decimals:18},"0xBa3335588D9403515223F109EdC4eB7269a9Ab5D":{name:"Gearbox",logo:"gear.svg",erc20:!0,symbol:"GEAR",decimals:18},"0x9B6B9d2468E165a02FEf69E61B6D3D6CBC0Ac409":{name:"OASISLIFE",logo:"OFE.svg",erc20:!0,symbol:"OFE",decimals:18},"0xdf0162A6B3e9fDf0302c1e949739DeeaFafd8F89":{name:"METAOASIS",logo:"MOA.svg",erc20:!0,symbol:"MOA",decimals:18},"0xe4dae00bc1c46ea2F44ae71B1BEb8b171C15d812":{name:"PREMA",logo:"PREMA.svg",erc20:!0,symbol:"PRMX",decimals:18},"0x1416946162B1C2c871A73B07E932D2fB6C932069":{name:"Energi",logo:"energi.svg",erc20:!0,symbol:"NRG",decimals:18},"0x0d88eD6E74bbFD96B831231638b66C05571e824F":{name:"Aventus",logo:"aventus.svg",erc20:!0,symbol:"AVT",decimals:18},"0x4FC15c91a9c4A9efB404174464687E8e128730C2":{name:"STAT",logo:"STAT.svg",erc20:!0,erc721:!1,symbol:"STAT",decimals:18},"0x4ad7a056191F4c9519fAcd6D75FA94CA26003aCE":{name:"GoldPesa Option",logo:"GPO.svg",erc20:!0,symbol:"GPO",decimals:18},"0x767FE9EDC9E0dF98E07454847909b5E959D7ca0E":{name:"Illuvium",logo:"illuvium.svg",erc20:!0,erc721:!1,symbol:"ILV",decimals:18},"0x85F17Cf997934a597031b2E18a9aB6ebD4B9f6a4":{name:"NEAR",logo:"NEAR.svg",erc20:!0,symbol:"NEAR",decimals:24},"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2":{name:"SushiSwap",logo:"sushi.svg",erc20:!0,erc721:!1,symbol:"SUSHI",decimals:18},"0x881Ba05de1E78f549cC63a8f6Cabb1d4AD32250D":{name:"00",logo:"00.svg",erc20:!0,erc721:!1,symbol:"00",decimals:18},"0xC211477cb4098aC22a98432781f5f26a1E07a4d4":{name:"CULTURED",logo:"CULTURED.svg",erc20:!0,erc721:!1,symbol:"CULTURED",decimals:18},"0x86f2A193b116d1f9C53Ed26d97F77cDC8BcF4c2b":{name:"EHTAGA",logo:"EHTAGA.svg",erc20:!0,erc721:!1,symbol:"EHTAGA",decimals:18},"0x54b79A15b2e2c55c736A66bb0A978fb840407aC8":{name:"FEVER",logo:"FEVER.svg",erc20:!0,erc721:!1,symbol:"FEVER",decimals:18},"0x677c9fE4396D3D13A0F9013a8118eAE386C843A5":{name:"IAM",logo:"IAM.svg",erc20:!0,erc721:!1,symbol:"IAM",decimals:18},"0xf63c65E855020E4B74f0Ad842D9537dA0E6162eC":{name:"ISH",logo:"ISH.svg",erc20:!0,erc721:!1,symbol:"ISH",decimals:18},"0xc105fA46510F32c0444CCdB4e51065da95caA1B4":{name:"LITA",logo:"LITA.svg",erc20:!0,erc721:!1,symbol:"LITA",decimals:18},"0x5401F949cDfa3E5aF32538167c0314230769209C":{name:"MAHCOIN",logo:"MAHCOIN.svg",erc20:!0,erc721:!1,symbol:"MAHCOIN",decimals:18},"0x711D2C47aFf84B96AD0F36983b1c41Be2C509e18":{name:"NIKITA",logo:"NIKITA.svg",erc20:!0,erc721:!1,symbol:"NIKITA",decimals:18},"0x3C44aEc33993b6830e5C2a705ea879b9C9ba0f7c":{name:"NYELA",logo:"NYELA.svg",erc20:!0,erc721:!1,symbol:"NYELA",decimals:18},"0xfa9096c99e687ea8E0064C23DAaCFE87cc99E4Ba":{name:"RON",logo:"RON.svg",erc20:!0,erc721:!1,symbol:"RON",decimals:18},"0x287a7C95aD00bBDd48599Ad2919567fD09281f07":{name:"STEELO",logo:"STEELO.svg",erc20:!0,erc721:!1,symbol:"STEELO",decimals:18},"0x2Ec3275f7aCe4044e499823F511cd58250be8E3d":{name:"Privilege",logo:"prvg.svg",erc20:!0,symbol:"PRVG",decimals:8},"0x65BB569FAaDD324a00883FdE4c46346cc96D5c0A":{name:"Provide",logo:"prvd.svg",erc20:!0,symbol:"PRVD",decimals:8},"0xB4272071eCAdd69d933AdcD19cA99fe80664fc08":{name:"CryptoFranc",logo:"XCHF.svg",erc20:!0,symbol:"XCHF",decimals:18},"0x5aFE3855358E112B5647B952709E6165e1c1eEEe":{name:"Safe Token",logo:"safe-green-token.svg",erc20:!0,symbol:"SAFE",decimals:18},"0x9C8fF314C9Bc7F6e59A9d9225Fb22946427eDC03":{name:"Nouns",erc20:!1,erc721:!0,symbol:"NOUN",decimals:0,logo:"nouns.svg"},"0xBC4CA0EdA7647A8aB7C2061c2E118A18a936f13D":{name:"BoredApeYachtClub",erc20:!1,erc721:!0,symbol:"BAYC",decimals:0,logo:"bayc.svg"},"0x08D7C0242953446436F34b4C78Fe9da38c73668d":{name:"PROOF Collective",erc20:!1,erc721:!0,symbol:"PROOF",decimals:0,logo:"proof.svg"},"0x23581767a106ae21c074b2276D25e5C3e136a68b":{name:"Moonbirds",erc20:!1,erc721:!0,symbol:"MOONBIRD",decimals:0,logo:"moonbirds.svg"},"0x60E4d786628Fea6478F785A6d7e704777c86a7c6":{name:"MutantApeYachtClub",erc20:!1,erc721:!0,symbol:"MAYC",decimals:0,logo:"mayc.svg"},"0x49cF6f5d44E70224e2E23fDcdd2C053F30aDA28B":{name:"CloneX",erc20:!1,erc721:!0,symbol:"CloneX",decimals:0,logo:"clonex.svg"},"0x8a90CAb2b38dba80c64b7734e58Ee1dB38B8992e":{name:"Doodles",erc20:!1,erc721:!0,symbol:"DOODLE",decimals:0,logo:"doodles.svg"},"0xED5AF388653567Af2F388E6224dC7C4b3241C544":{name:"Azuki",erc20:!1,erc721:!0,symbol:"AZUKI",decimals:0,logo:"azuki.svg"},"0xa3AEe8BcE55BEeA1951EF834b99f3Ac60d1ABeeB":{name:"VeeFriends",erc20:!1,erc721:!0,symbol:"VFT",decimals:0,logo:"veefriends.svg"},"0x34d85c9CDeB23FA97cb08333b511ac86E1C4E258":{name:"Otherdeed",erc20:!1,erc721:!0,symbol:"OTHR",decimals:0,logo:"otherdeed.svg"},"0xBBc2AE13b23d715c30720F079fcd9B4a74093505":{name:"Ethernity Chain Token",logo:"ERN.svg",erc20:!0,symbol:"ERN",decimals:18},"0x243cACb4D5fF6814AD668C3e225246efA886AD5a":{name:"Shina Inu",logo:"shina.svg",erc20:!0,symbol:"SHI",decimals:18},"0xD057B63f5E69CF1B929b356b579Cba08D7688048":{name:"CoW Protocol Virtual Token",logo:"vCOW.svg",erc20:!0,symbol:"vCOW",decimals:18},"0xDEf1CA1fb7FBcDC777520aa7f396b4E015F497aB":{name:"CoW Protocol Token",logo:"COW.svg",erc20:!0,symbol:"COW",decimals:18},"0xEd04915c23f00A313a544955524EB7DBD823143d":{name:"Alchemy Pay",logo:"ACH.svg",erc20:!0,symbol:"ACH",decimals:8},"0xeDF6568618A00C6F0908Bf7758A16F76B6E04aF9":{name:"Arianee",logo:"aria20.svg",erc20:!0,symbol:"ARIA20",decimals:18},"0x88D8DA2A8D0fA5b1f4E38030AC486aDE0AFA2798":{name:"Terrapass Coin",logo:"tpsc.svg",erc20:!0,symbol:"TPSC",decimals:18},"0x4730fB1463A6F1F44AEB45F6c5c422427f37F4D0":{name:"The 4th Pillar Token",logo:"four.svg",erc20:!0,symbol:"FOUR",decimals:18},"0x875773784Af8135eA0ef43b5a374AaD105c5D39e":{name:"Idle DAO Token",logo:"idle.svg",erc20:!0,symbol:"IDLE",decimals:18},"0x6BeA7CFEF803D1e3d5f7C0103f7ded065644e197":{name:"Gamma",logo:"Gamma.svg",erc20:!0,symbol:"GAMMA",decimals:18},"0x26805021988F1a45dC708B5FB75Fc75F21747D8c":{name:"xGamma",logo:"xGamma.svg",erc20:!0,symbol:"xGAMMA",decimals:18},"0xc7D9c108D4E1dD1484D3e2568d7f74bfD763d356":{name:"SORA Synthetic USD",logo:"sora-xstusd.svg",erc20:!0,symbol:"XSTUSD",decimals:18},"0x519C1001D550C0a1DaE7d1fC220f7d14c2A521BB":{name:"Polkaswap",logo:"sora-pswap.svg",erc20:!0,symbol:"PSWAP",decimals:18},"0x40FD72257597aA14C7231A7B1aaa29Fce868F677":{name:"SORA",logo:"sora-xor.svg",erc20:!0,symbol:"XOR",decimals:18},"0x909E34d3f6124C324ac83DccA84b74398a6fa173":{name:"$ZKP Token",logo:"ZKP.svg",erc20:!0,erc721:!1,symbol:"$ZKP",decimals:18},"0xe88f8313e61A97cEc1871EE37fBbe2a8bf3ed1E4":{name:"SORA Validator",logo:"sora-val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x7A58c0Be72BE218B41C608b7Fe7C5bB630736C71":{name:"ConstitutionDAO",logo:"PEOPLE.svg",erc20:!0,symbol:"PEOPLE",decimals:18},"0x32E6C34Cd57087aBBD59B5A4AECC4cB495924356":{name:"BitBase",logo:"BTBS.svg",erc20:!0,symbol:"BTBS",decimals:18},"0x3fa400483487A489EC9b1dB29C4129063EEC4654":{name:"Cryptokek.com",logo:"cryptokek.svg",erc20:!0,symbol:"KEK",decimals:18},"0xEd3D4e446A96dC3b181B64B75c3c70dA41dC3CBe":{name:"Vodra",logo:"Vodra.svg",erc20:!0,symbol:"VDR",decimals:18},"0xb753428af26E81097e7fD17f40c88aaA3E04902c":{name:"Spice",logo:"sfi.svg",erc20:!0,symbol:"SFI",decimals:18},"0xd084944d3c05CD115C09d072B9F44bA3E0E45921":{name:"Manifold Finance",logo:"Manifold.svg",erc20:!0,symbol:"FOLD",decimals:18},"0x9a0242b7a33DAcbe40eDb927834F96eB39f8fBCB":{name:"BABB",logo:"bax.svg",erc20:!0,symbol:"BAX",decimals:18},"0x4Cf89ca06ad997bC732Dc876ed2A7F26a9E7f361":{name:"Mysterium",logo:"MYST.svg",erc20:!0,symbol:"MYST",decimals:18},"0x697eF32B4a3F5a4C39dE1cB7563f24CA7BfC5947":{name:"Insula Token",logo:"Insula.svg",erc20:!0,symbol:"ISLA",decimals:18},"0x62Dc4817588d53a056cBbD18231d91ffCcd34b2A":{name:"DeHive",logo:"dehive.svg",erc20:!0,erc721:!1,symbol:"DHV",decimals:18},"0x8400D94A5cb0fa0D041a3788e395285d61c9ee5e":{name:"Unibright",logo:"ubt.svg",erc20:!0,symbol:"UBT",decimals:8},"0xfAd45E47083e4607302aa43c65fB3106F1cd7607":{name:"Hoge Finance",logo:"HogeFinanceLogo.svg",erc20:!0,symbol:"HOGE",decimals:9},"0xBB0E17EF65F82Ab018d8EDd776e8DD940327B28b":{name:"Axie Infinity Shard",logo:"AXS.svg",erc20:!0,symbol:"AXS",decimals:18},"0xCC8Fa225D80b9c7D42F96e9570156c65D6cAAa25":{name:"Smooth Love Potion",logo:"SLP.svg",erc20:!0,symbol:"SLP",decimals:0},"0x10633216E7E8281e33c86F02Bf8e565a635D9770":{name:"Dvision Network",logo:"dvision.svg",erc20:!0,symbol:"DVI",decimals:18},"0x898BAD2774EB97cF6b94605677F43b41871410B1":{name:"vEth2",logo:"vEth2.svg",erc20:!0,symbol:"vEth2",decimals:18},"0x321C2fE4446C7c963dc41Dd58879AF648838f98D":{name:"Cryptex Finance",logo:"ctx.svg",erc20:!0,symbol:"CTX",decimals:18},"0x16c52CeeCE2ed57dAd87319D91B5e3637d50aFa4":{name:"TCAP Token",logo:"tcap.svg",erc20:!0,symbol:"TCAP",decimals:18},"0xE94B97b6b43639E238c851A7e693F50033EfD75C":{name:"Rainbow Token",logo:"halodao-rnbw.svg",erc20:!0,symbol:"RNBW",decimals:18},"0x47BE779De87de6580d0548cde80710a93c502405":{name:"Rainbow Pool",logo:"halodao-xrnbw.svg",erc20:!0,symbol:"xRNBW",decimals:18},"0xe7aE6D0C56CACaf007b7e4d312f9af686a9E9a04":{name:"Vabble",logo:"VAB.svg",erc20:!0,symbol:"VAB",decimals:18},"0x853d955aCEf822Db058eb8505911ED77F175b99e":{name:"Frax",logo:"frax.svg",erc20:!0,symbol:"FRAX",decimals:18},"0x3432B6A60D23Ca0dFCa7761B7ab56459D9C964D0":{name:"Frax Share",logo:"fxs.svg",erc20:!0,symbol:"FXS",decimals:18},"0x84810bcF08744d5862B8181f12d17bfd57d3b078":{name:"SharedStake",logo:"sharedstake.svg",erc20:!0,symbol:"SGT",decimals:18},"0x75387e1287Dd85482aB66102DA9f6577E027f609":{name:"MindsyncAI",logo:"MAI.svg",erc20:!0,symbol:"MAI",decimals:18},"0x196f4727526eA7FB1e17b2071B3d8eAA38486988":{name:"Reserve",logo:"rsv.svg",erc20:!0,symbol:"RSV",decimals:18},"0x320623b8E4fF03373931769A31Fc52A4E78B5d70":{name:"Reserve Rights",logo:"rsr.svg",erc20:!0,symbol:"RSR",decimals:18},"0x1cF4592ebfFd730c7dc92c1bdFFDfc3B9EfCf29a":{name:"WAVES",logo:"waves.svg",erc20:!0,symbol:"WAVES",decimals:18},"0x252739487C1fa66eaeaE7CED41d6358aB2a6bCa9":{name:"ArCoin",logo:"ArCoin.svg",erc20:!0,symbol:"RCOIN",decimals:8},"0x18aAA7115705e8be94bfFEBDE57Af9BFc265B998":{name:"Audius",logo:"audius.svg",erc20:!0,symbol:"AUDIO",decimals:18},"0x8E3BCC334657560253B83f08331d85267316e08a":{name:"Rubic",logo:"brbc.svg",erc20:!0,symbol:"BRBC",decimals:18},"0xca1207647Ff814039530D7d35df0e1Dd2e91Fa84":{name:"dHEDGE DAO Token",logo:"DHT.svg",erc20:!0,symbol:"DHT",decimals:18},"0x6243d8CEA23066d098a15582d81a598b4e8391F4":{name:"Reflexer Ungovernance Token",logo:"flx.svg",erc20:!0,symbol:"FLX",decimals:18},"0x03ab458634910AaD20eF5f1C8ee96F1D6ac54919":{name:"Rai Reflex Index",logo:"rai.svg",erc20:!0,symbol:"RAI",decimals:18},"0xF25c91C87e0B1fd9B4064Af0F427157AaB0193A7":{name:"BASIC Token",logo:"basic.svg",erc20:!0,symbol:"BASIC",decimals:18},"0x53C8395465A84955c95159814461466053DedEDE":{name:"DeGate Token",logo:"DG.svg",erc20:!0,symbol:"DG",decimals:18},"0xBCf9dBf8B14eD096B2BA08b7269356197fDd1b5D":{name:"Avaluse",logo:"avaluse.svg",erc20:!0,symbol:"AVAL",decimals:18},"0x6E765D26388A17A6e86c49A8E41DF3F58aBcd337":{name:"Kangal",logo:"kangal.svg",erc20:!0,symbol:"KANGAL",decimals:18},"0x9AF4f26941677C706cfEcf6D3379FF01bB85D5Ab":{name:"DomRaiderToken",logo:"drt.svg",erc20:!0,symbol:"DRT",decimals:8},"0x06B179e292f080871825beD5D722162fD96B4c95":{name:"10x.gg",logo:"xgg.svg",erc20:!0,symbol:"XGG",decimals:18},"0xF29992D7b589A0A6bD2de7Be29a97A6EB73EaF85":{name:"DMScript",logo:"dmst.svg",erc20:!0,symbol:"DMST",decimals:18},"0x64aa3364F17a4D01c6f1751Fd97C2BD3D7e7f1D5":{name:"Olympus",logo:"OHM.svg",erc20:!0,symbol:"OHM",decimals:9},"0x0ab87046fBb341D058F17CBC4c1133F25a20a52f":{name:"Governance OHM",logo:"gOHM.svg",erc20:!0,symbol:"gOHM",decimals:18},"0xDd1Ad9A21Ce722C151A836373baBe42c868cE9a4":{name:"Universal Basic Income",logo:"ubi.svg",erc20:!0,symbol:"UBI",decimals:18},"0xf293d23BF2CDc05411Ca0edDD588eb1977e8dcd4":{name:"Sylo",logo:"SYLO.svg",erc20:!0,symbol:"SYLO",decimals:18},"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84":{name:"Liquid staked Ether 2.0",logo:"stETH.svg",erc20:!0,symbol:"stETH",decimals:18},"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0":{name:"Wrapped liquid staked Ether 2.0",logo:"wstETH.svg",erc20:!0,symbol:"wstETH",decimals:18},"0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32":{name:"Lido DAO Token",logo:"LDO.svg",erc20:!0,symbol:"LDO",decimals:18},"0xbd31EA8212119f94A611FA969881CBa3EA06Fa3d":{name:"LUNA Token",logo:"Luna.svg",erc20:!0,symbol:"LUNA",decimals:6},"0xa693B19d2931d498c5B318dF961919BB4aee87a5":{name:"UST Token",logo:"UST.svg",erc20:!0,symbol:"UST",decimals:6},"0xd2877702675e6cEb975b4A1dFf9fb7BAF4C91ea9":{name:"LUNA Token - Shuttle",logo:"lunc.svg",erc20:!0,symbol:"LUNC",decimals:18},"0xa47c8bf37f92aBed4A126BDA807A7b7498661acD":{name:"UST Token - Shuttle",logo:"ustc.svg",erc20:!0,symbol:"USTC",decimals:18},"0xcAAfF72A8CbBfc5Cf343BA4e26f65a257065bFF1":{name:"KRT Token - Shuttle",logo:"KRT.svg",erc20:!0,symbol:"KRT-S",decimals:18},"0x676Ad1b33ae6423c6618C1AEcf53BAa29cf39EE5":{name:"SDT Token - Shuttle",logo:"SDT.svg",erc20:!0,symbol:"SDT-S",decimals:18},"0x156B36ec68FdBF84a925230BA96cb1Ca4c4bdE45":{name:"MNT Token - Shuttle",logo:"MNT.svg",erc20:!0,symbol:"MNT-S",decimals:18},"0x09a3EcAFa817268f77BE1283176B946C4ff2E608":{name:"MIR Token - Shuttle",logo:"MIR.svg",erc20:!0,symbol:"MIR-S",decimals:18},"0xd36932143F6eBDEDD872D5Fb0651f4B72Fd15a84":{name:"Mirror AAPL Token - Shuttle",logo:"mAAPL.svg",erc20:!0,symbol:"mAAPL-S",decimals:18},"0x59A921Db27Dd6d4d974745B7FfC5c33932653442":{name:"Mirror GOOGL Token - Shuttle",logo:"mGOOGL.svg",erc20:!0,symbol:"mGOGL-S",decimals:18},"0x21cA39943E91d704678F5D00b6616650F066fD63":{name:"Mirror TSLA Token - Shuttle",logo:"mTSLA.svg",erc20:!0,symbol:"mTSLA-S",decimals:18},"0xC8d674114bac90148d11D3C1d33C61835a0F9DCD":{name:"Mirror NFLX Token - Shuttle",logo:"mNFLX.svg",erc20:!0,symbol:"mNFLX-S",decimals:18},"0x13B02c8dE71680e71F0820c996E4bE43c2F57d15":{name:"Mirror QQQ Token - Shuttle",logo:"mQQQ.svg",erc20:!0,symbol:"mQQQ-S",decimals:18},"0xEdb0414627E6f1e3F082DE65cD4F9C693D78CCA9":{name:"Mirror TWTR Token - Shuttle",logo:"mTWTR.svg",erc20:!0,symbol:"mTWTR-S",decimals:18},"0x41BbEDd7286dAab5910a1f15d12CBda839852BD7":{name:"Mirror MSFT Token - Shuttle",logo:"mMSFT.svg",erc20:!0,symbol:"mMSFT-S",decimals:18},"0x0cae9e4d663793c2a2A0b211c1Cf4bBca2B9cAa7":{name:"Mirror AMZN Token - Shuttle",logo:"mAMZN.svg",erc20:!0,symbol:"mAMZN-S",decimals:18},"0x56aA298a19C93c6801FDde870fA63EF75Cc0aF72":{name:"Mirror BABA Token - Shuttle",logo:"mBABA.svg",erc20:!0,symbol:"mBABA-S",decimals:18},"0x1d350417d9787E000cc1b95d70E9536DcD91F373":{name:"Mirror IAU Token - Shuttle",logo:"mIAU.svg",erc20:!0,symbol:"mIAU-S",decimals:18},"0x9d1555d8cB3C846Bb4f7D5B1B1080872c3166676":{name:"Mirror SLV Token - Shuttle",logo:"mSLV.svg",erc20:!0,symbol:"mSLV-S",decimals:18},"0x31c63146a635EB7465e5853020b39713AC356991":{name:"Mirror USO Token - Shuttle",logo:"mUSO.svg",erc20:!0,symbol:"mUSO-S",decimals:18},"0xf72FCd9DCF0190923Fadd44811E240Ef4533fc86":{name:"Mirror VIXY Token - Shuttle",logo:"mVIXY.svg",erc20:!0,symbol:"mVIXY-S",decimals:18},"0x21BfBDa47A0B4B5b1248c767Ee49F7caA9B23697":{name:"OVR",logo:"OVR.svg",erc20:!0,symbol:"OVR",decimals:18},"0x4691937a7508860F876c9c0a2a617E7d9E945D4B":{name:"Wootrade Network",logo:"wootrade.svg",erc20:!0,symbol:"WOO",decimals:18},"0xaf9f549774ecEDbD0966C52f250aCc548D3F36E5":{name:"RFUEL",logo:"RFUEL.svg",erc20:!0,symbol:"RFUEL",decimals:18},"0x7420B4b9a0110cdC71fB720908340C03F9Bc03EC":{name:"JasmyCoin",logo:"JASMY.svg",erc20:!0,symbol:"JASMY",decimals:18},"0x947AEb02304391f8fbE5B25D7D98D649b57b1788":{name:"Mandala Exchange Token",logo:"mandala.svg",erc20:!0,symbol:"MDX",decimals:18},"0xCdeee767beD58c5325f68500115d4B722b3724EE":{name:"Carbon",logo:"CRBN.svg",erc20:!0,symbol:"CRBN",decimals:18},"0xA4EED63db85311E22dF4473f87CcfC3DaDCFA3E3":{name:"Rubic",logo:"Rubic.svg",erc20:!0,symbol:"RBC",decimals:18},"0x3A880652F47bFaa771908C07Dd8673A787dAEd3A":{name:"DerivaDAO",logo:"DDX.svg",erc20:!0,symbol:"DDX",decimals:18},"0xbC396689893D065F41bc2C6EcbeE5e0085233447":{name:"Perpetual",logo:"PERP.svg",erc20:!0,symbol:"PERP",decimals:18},"0xeca82185adCE47f39c684352B0439f030f860318":{name:"Perlin",logo:"PERL.svg",erc20:!0,symbol:"PERL",decimals:18},"0xA1AFFfE3F4D611d252010E3EAf6f4D77088b0cd7":{name:"Reflect Finance",logo:"RFI.svg",erc20:!0,symbol:"RFI",decimals:9},"0xC0bA369c8Db6eB3924965e5c4FD0b4C1B91e305F":{name:"DLP Duck Token",logo:"dlpducktoken.svg",erc20:!0,symbol:"DUCK",decimals:18},"0xFbEEa1C75E4c4465CB2FCCc9c6d6afe984558E20":{name:"DuckDaoDime",logo:"ddim.svg",erc20:!0,symbol:"DDIM",decimals:18},"0x745407c86DF8DB893011912d3aB28e68B62E49B0":{name:"MahaDAO",logo:"MAHA.svg",erc20:!0,symbol:"MAHA",decimals:18},"0x8CC0F052fff7eaD7f2EdCCcaC895502E884a8a71":{name:"ARTH Valuecoin",logo:"ARTH.svg",erc20:!0,symbol:"ARTH",decimals:18},"0x3231Cb76718CDeF2155FC47b5286d82e6eDA273f":{name:"Monerium EUR",logo:"EURe.svg",erc20:!0,symbol:"EURe",decimals:18},"0x7ba92741Bf2A568abC6f1D3413c58c6e0244F8fD":{name:"Monerium GBP",logo:"GBPe.svg",erc20:!0,symbol:"GBPe",decimals:18},"0xBc5142e0CC5eB16b47c63B0f033d4c2480853a52":{name:"Monerium USD",logo:"USDe.svg",erc20:!0,symbol:"USDe",decimals:18},"0xC642549743A93674cf38D6431f75d6443F88E3E2":{name:"Monerium ISK",logo:"ISKe.svg",erc20:!0,symbol:"ISKe",decimals:18},"0x66a0f676479Cee1d7373f3DC2e2952778BfF5bd6":{name:"WISE Token",logo:"wise.svg",erc20:!0,symbol:"WISE",decimals:18},"0x72F020f8f3E8fd9382705723Cd26380f8D0c66Bb":{name:"PlotX",logo:"plotx.svg",erc20:!0,symbol:"PLOT",decimals:18},"0x44197A4c44D6A059297cAf6be4F7e172BD56Caaf":{name:"ELTCOIN",logo:"ELTCOIN.svg",erc20:!0,symbol:"ELT",decimals:8},"0x6781a0F84c7E9e846DCb84A9a5bd49333067b104":{name:"ZAP TOKEN",logo:"zapicon.svg",erc20:!0,symbol:"ZAP",decimals:18},"0x00c83aeCC790e8a4453e5dD3B0B4b3680501a7A7":{name:"SKALE",logo:"skl.svg",erc20:!0,symbol:"SKL",decimals:18},"0x674C6Ad92Fd080e4004b2312b45f796a192D27a0":{name:"Neutrino USD",logo:"usdn.svg",erc20:!0,symbol:"USDN",decimals:18},"0xE5CAeF4Af8780E59Df925470b050Fb23C43CA68C":{name:"Ferrum Network Token",logo:"frm.svg",erc20:!0,symbol:"FRM",decimals:6},"0x998FFE1E43fAcffb941dc337dD0468d52bA5b48A":{name:"Rupiah Token",logo:"idrt.svg",erc20:!0,symbol:"IDRT",decimals:2},"0x4E15361FD6b4BB609Fa63C81A2be19d873717870":{name:"Fantom",logo:"ftm.svg",erc20:!0,symbol:"FTM",decimals:18},"0x557B933a7C2c45672B610F8954A3deB39a51A8Ca":{name:"REVV",logo:"revv.svg",erc20:!0,symbol:"REVV",decimals:18},"0xFFC97d72E13E01096502Cb8Eb52dEe56f74DAD7B":{name:"Aave AAVE",logo:"aAAVE.svg",erc20:!0,symbol:"aAAVE",decimals:18},"0x05Ec93c0365baAeAbF7AefFb0972ea7ECdD39CF1":{name:"Aave BAT",logo:"aBAT.svg",erc20:!0,symbol:"aBAT",decimals:18},"0xA361718326c15715591c299427c62086F69923D9":{name:"Aave BUSD",logo:"aBUSD.svg",erc20:!0,symbol:"aBUSD",decimals:18},"0x028171bCA77440897B824Ca71D1c56caC55b68A3":{name:"Aave DAI",logo:"aDAI.svg",erc20:!0,symbol:"aDAI",decimals:18},"0xaC6Df26a590F08dcC95D5a4705ae8abbc88509Ef":{name:"Aave ENJ",logo:"aENJ.svg",erc20:!0,symbol:"aENJ",decimals:18},"0xD37EE7e4f452C6638c96536e68090De8cBcdb583":{name:"Aave GUSD",logo:"aGUSD.svg",erc20:!0,symbol:"aGUSD",decimals:2},"0x39C6b3e42d6A679d7D776778Fe880BC9487C2EDA":{name:"Aave KNC",logo:"aKNC.svg",erc20:!0,symbol:"aKNC",decimals:18},"0xa06bC25B5805d5F8d82847D191Cb4Af5A3e873E0":{name:"Aave LINK",logo:"aLINK.svg",erc20:!0,symbol:"aLINK",decimals:18},"0xa685a61171bb30d4072B338c80Cb7b2c865c873E":{name:"Aave MANA",logo:"aMANA.svg",erc20:!0,symbol:"aMANA",decimals:18},"0xc713e5E149D5D0715DcD1c156a020976e7E56B88":{name:"Aave MKR",logo:"aMKR.svg",erc20:!0,symbol:"aMKR",decimals:18},"0xCC12AbE4ff81c9378D670De1b57F8e0Dd228D77a":{name:"Aave REN",logo:"aREN.svg",erc20:!0,symbol:"aREN",decimals:18},"0x35f6B052C598d933D69A4EEC4D04c73A191fE6c2":{name:"Aave SNX",logo:"aSNX.svg",erc20:!0,symbol:"aSNX",decimals:18},"0x6C5024Cd4F8A59110119C56f8933403A539555EB":{name:"Aave SUSD",logo:"aSUSD.svg",erc20:!0,symbol:"aSUSD",decimals:18},"0x101cc05f4A51C0319f570d5E146a8C625198e636":{name:"Aave TUSD",logo:"aTUSD.svg",erc20:!0,symbol:"aTUSD",decimals:18},"0xB9D7CB55f463405CDfBe4E90a6D2Df01C2B92BF1":{name:"Aave UNI",logo:"aUNI.svg",erc20:!0,symbol:"aUNI",decimals:18},"0xBcca60bB61934080951369a648Fb03DF4F96263C":{name:"Aave USDC",logo:"aUSDC.svg",erc20:!0,symbol:"aUSDC",decimals:6},"0x3Ed3B47Dd13EC9a98b44e6204A523E766B225811":{name:"Aave USDT",logo:"aUSDT.svg",erc20:!0,symbol:"aUSDT",decimals:6},"0x9ff58f4fFB29fA2266Ab25e75e2A8b3503311656":{name:"Aave WBTC",logo:"aWBTC.svg",erc20:!0,symbol:"aWBTC",decimals:8},"0x030bA81f1c18d280636F32af80b9AAd02Cf0854e":{name:"Aave WETH",logo:"aWETH.svg",erc20:!0,symbol:"aWETH",decimals:18},"0x5165d24277cD063F5ac44Efd447B27025e888f37":{name:"Aave YFI",logo:"aYFI.svg",erc20:!0,symbol:"aYFI",decimals:18},"0xdef1fac7Bf08f173D286BbBDcBeeADe695129840":{name:"Defi Factory Token",logo:"DEFT.svg",erc20:!0,symbol:"DEFT",decimals:18},"0xDf7FF54aAcAcbFf42dfe29DD6144A69b629f8C9e":{name:"Aave ZRX",logo:"aZRX.svg",erc20:!0,symbol:"aZRX",decimals:18},"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9":{name:"Aave",logo:"AAVE.svg",erc20:!0,symbol:"AAVE",decimals:18},"0x44e2deC86B9F0e0266E9AA66e10323A2bd69CF9A":{name:"Attrace",logo:"attr.svg",erc20:!0,symbol:"ATTR",decimals:18},"0x1Da87b114f35E1DC91F72bF57fc07A768Ad40Bb0":{name:"Equalizer",logo:"EQZ.svg",erc20:!0,symbol:"EQZ",decimals:18},"0x4da27a545c0c5B758a6BA100e3a049001de870f5":{name:"Staked Aave",logo:"stkAAVE.svg",erc20:!0,symbol:"stAAVE",decimals:18},"0xba9d4199faB4f26eFE3551D490E3821486f135Ba":{name:"SwissBorg",logo:"chsb.svg",erc20:!0,symbol:"CHSB",decimals:8},"0x7DD9c5Cba05E151C895FDe1CF355C9A1D5DA6429":{name:"Golem Network Token",logo:"glm.svg",erc20:!0,symbol:"GLM",decimals:18},"0x7240aC91f01233BaAf8b064248E80feaA5912BA3":{name:"OctoFi",logo:"octo.svg",erc20:!0,symbol:"OCTO",decimals:18},"0xff56Cc6b1E6dEd347aA0B7676C85AB0B3D08B0FA":{name:"Orbs",logo:"orbs.svg",erc20:!0,symbol:"ORBS",decimals:18},"0x63f88A2298a5c4AEE3c216Aa6D926B184a4b2437":{name:"GAME Credits",logo:"GAMECreditsLogo.svg",erc20:!0,symbol:"GAME",decimals:18},"0x5150956E082C748Ca837a5dFa0a7C10CA4697f9c":{name:"Zeedex",logo:"zdex.svg",erc20:!0,symbol:"ZDEX",decimals:18},"0x84cA8bc7997272c7CfB4D0Cd3D55cd942B3c9419":{name:"DIAdata",logo:"dia.svg",erc20:!0,symbol:"DIA",decimals:18},"0xb78B3320493a4EFaa1028130C5Ba26f0B6085Ef8":{name:"Dracula",logo:"dracula.svg",erc20:!0,symbol:"DRC",decimals:18},"0xF433089366899D83a9f26A773D59ec7eCF30355e":{name:"Metal",logo:"mtl.svg",erc20:!0,symbol:"MTL",decimals:8},"0x85Eee30c52B0b379b046Fb0F85F4f3Dc3009aFEC":{name:"KEEP",logo:"keep.svg",erc20:!0,symbol:"KEEP",decimals:18},"0x8dAEBADE922dF735c38C80C7eBD708Af50815fAa":{name:"tBTC",logo:"tbtc.svg",erc20:!0,symbol:"TBTC",decimals:18},"0xD7EFB00d12C2c13131FD319336Fdf952525dA2af":{name:"Proton",logo:"proton.svg",erc20:!0,symbol:"XPR",decimals:4},"0x178c820f862B14f316509ec36b13123DA19A6054":{name:"Energy Web Token Bridged",logo:"ewtb.svg",erc20:!0,symbol:"EWTB",decimals:18},"0x2b591e99afE9f32eAA6214f7B7629768c40Eeb39":{name:"HEX",logo:"hex.svg",erc20:!0,symbol:"HEX",decimals:8},"0xFca59Cd816aB1eaD66534D82bc21E7515cE441CF":{name:"Rarible",logo:"rari.svg",erc20:!0,symbol:"RARI",decimals:18},"0x7865af71cf0b288b4E7F654f4F7851EB46a2B7F8":{name:"Sentivate",logo:"sentivate.svg",erc20:!0,symbol:"SNTVT",decimals:18},"0xa3d58c4E56fedCae3a7c43A725aeE9A71F0ece4e":{name:"Metronome",logo:"metronome.svg",erc20:!0,symbol:"MET",decimals:18},"0x49d716DFe60b37379010A75329ae09428f17118d":{name:"PoolTogether Dai",logo:"pldai.svg",erc20:!0,symbol:"PLDAI",decimals:18},"0xfE6892654CBB05eB73d28DCc1Ff938f59666Fe9f":{name:"PoolTogether Sai",logo:"plsai.svg",erc20:!0,symbol:"PLSAI",decimals:18},"0x5732046A883704404F284Ce41FfADd5b007FD668":{name:"Bluzelle Token",logo:"Bluzelle.svg",erc20:!0,symbol:"BLZ",decimals:18},"0xBD87447F48ad729C5c4b8bcb503e1395F62e8B98":{name:"PoolTogether USDC",logo:"plusdc.svg",erc20:!0,symbol:"PLUSDC",decimals:6},"0x69A95185ee2a045CDC4bCd1b1Df10710395e4e23":{name:"$Poolz Finance",logo:"Poolz.svg",erc20:!0,symbol:"POOLZ",decimals:18},"0x0adA190c81b814548ddC2F6AdC4a689ce7C1FE73":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAXIS",decimals:18},"0xb1dC9124c395c1e97773ab855d66E879f053A289":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAX",decimals:18},"0xeF31Cb88048416E301Fee1eA13e7664b887BA7e8":{name:"Staked yAxis",logo:"yaxis.svg",erc20:!0,symbol:"sYAX",decimals:18},"0x28cb7e841ee97947a86B06fA4090C8451f64c0be":{name:"YF Link",logo:"YFL.svg",erc20:!0,symbol:"YFL",decimals:18},"0x75D1aA733920b14fC74c9F6e6faB7ac1EcE8482E":{name:"YFLink Staking Share",logo:"YFL.svg",erc20:!0,symbol:"yYFL",decimals:18},"0x7b760D06E401f85545F3B50c44bf5B05308b7b62":{name:"YFLink USD",logo:"YFLUSD.svg",erc20:!0,symbol:"YFLUSD",decimals:18},"0x8282df223AC402d04B2097d16f758Af4F70e7Db0":{name:"YFLink Synthetic",logo:"sYFL.svg",erc20:!0,symbol:"sYFL",decimals:18},"0x008377EB0C62cE8e0BA3D7Bb4A5638591f21588E":{name:"YFLink Bond",logo:"bYFL.svg",erc20:!0,symbol:"bYFL",decimals:18},"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e":{name:"yearn.finance",logo:"yfi.svg",erc20:!0,symbol:"YFI",decimals:18},"0x261b45D85cCFeAbb11F022eBa346ee8D1cd488c0":{name:"rDAI",logo:"rdai.svg",erc20:!0,symbol:"rDAI",decimals:18},"0xea8b224eDD3e342DEb514C4176c2E72Bcce6fFF9":{name:"rSAI",logo:"rsai.svg",erc20:!0,symbol:"rSAI",decimals:18},"0x12B19D3e2ccc14Da04FAe33e63652ce469b3F2FD":{name:"GridPlus",logo:"GridPlus.svg",erc20:!0,symbol:"GRID",decimals:12},"0xDb05EA0877A2622883941b939f0bb11d1ac7c400":{name:"Opacity",logo:"opct.svg",erc20:!0,symbol:"OPCT",decimals:18},"0x4575f41308EC1483f3d399aa9a2826d74Da13Deb":{name:"Orchid",logo:"OXT.svg",erc20:!0,symbol:"OXT",decimals:18},"0x4CC19356f2D37338b9802aa8E8fc58B0373296E7":{name:"Selfkey",logo:"KEY.svg",erc20:!0,symbol:"KEY",decimals:18},"0x92A5B04D0ED5D94D7a193d1d334D3D16996f4E13":{name:"Eristica",logo:"Eristica.svg",erc20:!0,symbol:"ERT",decimals:18},"0xdAC17F958D2ee523a2206206994597C13D831ec7":{name:"Tether USD",logo:"usdt.svg",erc20:!0,symbol:"USDT",decimals:6},"0x06AF07097C9Eeb7fD685c692751D5C66dB49c215":{name:"Chai",logo:"CHAI.svg",erc20:!0,symbol:"CHAI",decimals:18},"0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828":{name:"UMA",logo:"uma.svg",erc20:!0,symbol:"UMA",decimals:18},"0x5f778ec4B31a506c1Dfd8b06F131E9B451a61D39":{name:"UPX Token",logo:"UPX.svg",erc20:!0,symbol:"UPX",decimals:18},"0xb1CD6e4153B2a390Cf00A6556b0fC1458C4A5533":{name:"ETHBNT Liquidity Pool",logo:"ETHBNT.svg",erc20:!0,symbol:"ETHBNT",decimals:18},"0xf0Ee6b27b759C9893Ce4f094b49ad28fd15A23e4":{name:"Enigma",logo:"enigma.svg",erc20:!0,symbol:"ENG",decimals:8},"0xaaAEBE6Fe48E54f431b0C390CfaF0b017d09D42d":{name:"Celsius",logo:"celsius.svg",erc20:!0,symbol:"CEL",decimals:4},"0xb683D83a532e2Cb7DFa5275eED3698436371cc9f":{name:"BTU",logo:"BTU.svg",erc20:!0,symbol:"BTU",decimals:18},"0x746DdA2ea243400D5a63e0700F190aB79f06489e":{name:"BOSAGORA",logo:"BOA.svg",erc20:!0,symbol:"BOA",decimals:7},"0x5D858bcd53E085920620549214a8b27CE2f04670":{name:"POP Network Token",logo:"POP.svg",erc20:!0,symbol:"POP",decimals:18},"0x048Fe49BE32adfC9ED68C37D32B5ec9Df17b3603":{name:"Skrumble Network V2",logo:"skm.svg",erc20:!0,symbol:"SKM",decimals:18},"0x16EA01aCB4b0Bca2000ee5473348B6937ee6f72F":{name:"Enecuum",logo:"ENQ-logo.svg",erc20:!0,symbol:"ENQ",decimals:10},"0xE5B826Ca2Ca02F09c1725e9bd98d9a8874C30532":{name:"ZEON Network",logo:"ZEON_logo.png",erc20:!0,symbol:"ZEON",decimals:18},"0x13cb85823f78Cff38f0B0E90D3e975b8CB3AAd64":{name:"REMIIT REMI Token",logo:"remi.svg",erc20:!0,symbol:"REMI",decimals:18},"0x93a7174dafd31d13400cD9fa01f4e5B5BAa00D39":{name:"Shaka",logo:"hak.svg",erc20:!0,symbol:"HAK",decimals:18},"0x6fB3e0A217407EFFf7Ca062D46c26E5d60a14d69":{name:"IoTeX",logo:"iotex.svg",erc20:!0,symbol:"IOTX",decimals:18},"0xE5a3229CCb22b6484594973A03a3851dCd948756":{name:"RAE Token",logo:"rae.svg",erc20:!0,symbol:"RAE",decimals:18},"0x4470BB87d77b963A013DB939BE332f927f2b992e":{name:"AdEx Legacy Token",logo:"adex.svg",erc20:!0,symbol:"ADXL",decimals:4},"0xADE00C28244d5CE17D72E40330B1c318cD12B7c3":{name:"AdEx Token",logo:"adex.svg",erc20:!0,symbol:"ADX",decimals:18},"0xDc5864eDe28BD4405aa04d93E05A0531797D9D59":{name:"Falcon",logo:"fnt.svg",erc20:!0,symbol:"FNT",decimals:6},"0x1966d718A565566e8E202792658D7b5Ff4ECe469":{name:"nDEX",logo:"nDEX.png",erc20:!0,symbol:"NDX",decimals:18},"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599":{name:"Wrapped BTC",logo:"wbtc.svg",erc20:!0,symbol:"WBTC",decimals:8},"0x150b0b96933B75Ce27af8b92441F8fB683bF9739":{name:"Dragonereum Gold",logo:"gold.svg",erc20:!0,symbol:"GOLD",decimals:18},"0x82f4dED9Cec9B5750FBFf5C2185AEe35AfC16587":{name:"DreamTeam Token",logo:"dream.svg",erc20:!0,symbol:"DREAM",decimals:6},"0x5d60d8d7eF6d37E16EBABc324de3bE57f135e0BC":{name:"MyBit",logo:"MYB.svg",erc20:!0,symbol:"MYB",decimals:18},"0x01FA555c97D7958Fa6f771f3BbD5CCD508f81e22":{name:"Civil Token",logo:"CVL_token.svg",erc20:!0,symbol:"CVL",decimals:18},"0x5adc961D6AC3f7062D2eA45FEFB8D8167d44b190":{name:"Dether",logo:"dether.svg",erc20:!0,symbol:"DTH",decimals:18},"0x3F17Dd476faF0a4855572F0B6ed5115D9bBA22AD":{name:"Wibson",logo:"wibson-logo.png",erc20:!0,symbol:"WIB",decimals:9},"0xDF347911910b6c9A4286bA8E2EE5ea4a39eB2134":{name:"Bob's Repair",logo:"bobsrepair.png",erc20:!0,symbol:"BOB",decimals:18},"0x3505F494c3f0fed0B594E01Fa41Dd3967645ca39":{name:"SWARM",logo:"swarm.svg",erc20:!0,symbol:"SWM",decimals:18},"0x6863bE0e7CF7ce860A574760e9020D519a8bDC47":{name:"On.Live",logo:"onlive.svg",erc20:!0,symbol:"ONL",decimals:18},"0xea5f88E54d982Cbb0c441cde4E79bC305e5b43Bc":{name:"Pareto",logo:"ParetoLogo.png",erc20:!0,symbol:"PARETO",decimals:18},"0x2e91E3e54C5788e9FdD6A181497FDcEa1De1bcc1":{name:"Hercules",logo:"herc.png",erc20:!0,symbol:"HERC",decimals:18},"0x4946Fcea7C692606e8908002e55A582af44AC121":{name:"FOAM",logo:"FOAM.svg",erc20:!0,symbol:"FOAM",decimals:18},"0x4D807509aECe24C0fa5A102b6a3B059Ec6E14392":{name:"Menlo One",logo:"Menlo_One.png",erc20:!0,symbol:"ONE",decimals:18},"0x27054b13b1B798B345b591a4d22e6562d47eA75a":{name:"AirSwap Token",logo:"AirSwapLogo.svg",erc20:!0,symbol:"AST",decimals:4},"0x8D5682941cE456900b12d47ac06a88b47C764CE1":{name:"RightMesh Token",logo:"Rmesh.png",erc20:!0,symbol:"RMESH",decimals:18},"0xDDe12a12A6f67156e0DA672be05c374e1B0a3e57":{name:"JOYSO",logo:"JOY.png",erc20:!0,symbol:"JOY",decimals:6},"0x0D262e5dC4A06a0F1c90cE79C7a60C09DfC884E4":{name:"JET8 Token",logo:"J8T.svg",erc20:!0,symbol:"J8T",decimals:8},"0x4a220E6096B25EADb88358cb44068A3248254675":{name:"Quant Network",logo:"quant-network.svg",erc20:!0,symbol:"QNT",decimals:18},"0xBC86727E770de68B1060C91f6BB6945c73e10388":{name:"Ink Protocol",logo:"ink_protocol.svg",erc20:!0,symbol:"XNK",decimals:18},"0xa95592DCFfA3C080B4B40E459c5f5692F67DB7F8":{name:"ELY Token",logo:"ely.png",erc20:!0,symbol:"ELY",decimals:18},"0x9E46A38F5DaaBe8683E10793b06749EEF7D733d1":{name:"PolySwarm Nectar",logo:"polyswarm_nectar.svg",erc20:!0,symbol:"NCT",decimals:18},"0xe1A178B681BD05964d3e3Ed33AE731577d9d96dD":{name:"BOX Token",logo:"box_token.png",erc20:!0,symbol:"BOX",decimals:18},"0x543Ff227F64Aa17eA132Bf9886cAb5DB55DCAddf":{name:"DAOstack",logo:"gen.svg",erc20:!0,symbol:"GEN",decimals:18},"0x6aEDbF8dFF31437220dF351950Ba2a3362168d1b":{name:"Dragonglass",logo:"dragonglass.svg",erc20:!0,symbol:"DGS",decimals:8},"0xd26114cd6EE289AccF82350c8d8487fedB8A0C07":{name:"OmiseGO",logo:"omg.svg",erc20:!0,symbol:"OMG",decimals:18},"0x99ea4dB9EE77ACD40B119BD1dC4E33e1C070b80d":{name:"Quantstamp",logo:"qsp.svg",erc20:!0,symbol:"QSP",decimals:18},"0xB64ef51C888972c908CFacf59B47C1AfBC0Ab8aC":{name:"Storj",logo:"storj.svg",erc20:!0,symbol:"STORJ",decimals:8},"0xD8E3FB3b08eBA982F2754988d70D57eDc0055ae6":{name:"Zoracles",logo:"zora.svg",erc20:!0,symbol:"ZORA",decimals:9},"0xF938424F7210f31dF2Aee3011291b658f872e91e":{name:"VISOR",logo:"VISR.svg",erc20:!0,symbol:"VISR",decimals:18},"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942":{name:"Decentraland",logo:"mana.svg",erc20:!0,symbol:"MANA",decimals:18},"0x0F513fFb4926ff82D7F60A05069047AcA295C413":{name:"CrowdstartCoin",logo:"XSC_Logo.svg",erc20:!0,symbol:"XSC",decimals:18},"0x5BC7e5f0Ab8b2E10D2D0a3F21739FCe62459aeF3":{name:"Hut34 Entropy Token",logo:"ENTRP.png",symbol:"ENTRP",erc20:!0,decimals:18},"0x946112efaB61C3636CBD52DE2E1392D7A75A6f01":{name:"HYDRO TOKEN",logo:"hydro.svg",erc20:!0,symbol:"HYDRO",decimals:18},"0x2604FA406Be957E542BEb89E6754fCdE6815e83f":{name:"Playkey Token",logo:"playkey.svg",erc20:!0,symbol:"PKT",decimals:18},"0xE41d2489571d322189246DaFA5ebDe1F4699F498":{name:"0x",logo:"zrx.svg",erc20:!0,symbol:"ZRX",decimals:18},"0x957c30aB0426e0C93CD8241E2c60392d08c6aC8e":{name:"Modum Token",logo:"modum.svg",erc20:!0,symbol:"MOD",decimals:0},"0x1a7a8BD9106F2B8D977E08582DC7d24c723ab0DB":{name:"AppCoins",logo:"appc.svg",erc20:!0,decimals:18,symbol:"APPC"},"0xdB25f211AB05b1c97D595516F45794528a807ad8":{name:"STASIS EURS Token",logo:"stasis-eurs.svg",erc20:!0,decimals:2,symbol:"EURS"},"0xCA0e7269600d353F70b14Ad118A49575455C0f2f":{name:"AMLT",logo:"amlt.png",erc20:!0,decimals:18,symbol:"AMLT"},"0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F":{name:"Synthetix Network Token",logo:"synthetix.svg",erc20:!0,decimals:18,symbol:"SNX"},"0x57Ab1ec28D129707052df4dF418D58a2D46d5f51":{name:"Synth sUSD",logo:"synthetix_susd.svg",erc20:!0,decimals:18,symbol:"SUSD"},"0x5e74C9036fb86BD7eCdcb084a0673EFc32eA31cb":{name:"Synth sETH",logo:"synthetix_seth.svg",erc20:!0,decimals:18,symbol:"SETH"},"0xfE18be6b3Bd88A2D2A7f928d00292E7a9963CfC6":{name:"Synth sBTC",logo:"synthetix_sbtc.svg",erc20:!0,decimals:18,symbol:"SBTC"},"0x0DB8D8b76BC361bAcbB72E2C491E06085A97Ab31":{name:"IQeon",logo:"iqeon.svg",erc20:!0,decimals:18,symbol:"IQN"},"0x000C100050E98C91f9114fa5Dd75CE6869Bf4F53":{name:"CRYPTO10 Hedged",logo:"c10.svg",erc20:!0,symbol:"C10",decimals:18},"0x26E75307Fc0C021472fEb8F727839531F112f317":{name:"Crypto20",logo:"c20.svg",erc20:!0,symbol:"C20",decimals:18},"0x06012c8cf97BEaD5deAe237070F9587f8E7A266d":{name:"Crypto Kitties",logo:"ck.svg",erc20:!1,erc721:!0,symbol:"CK",decimals:0},"0xE477292f1B3268687A29376116B0ED27A9c76170":{name:"Herocoin",logo:"herocoin_logo.png",erc20:!0,symbol:"PLAY",decimals:18},"0x4F4f0Db4de903B88f2B1a2847971E231D54F8fd3":{name:"Geens Platform Token",logo:"gee-icon.svg",erc20:!0,symbol:"GEE",decimals:8},"0xec67005c4E498Ec7f55E092bd1d35cbC47C91892":{name:"Enzyme Finance",logo:"mln.svg",erc20:!0,symbol:"MLN",decimals:18},"0xba2184520A1cC49a6159c57e61E1844E085615B6":{name:"HelloGold Token",logo:"hgt.png",erc20:!0,symbol:"HGT",decimals:8},"0xba358B6f5b4c0215650444B8C30D870B55050D2D":{name:"Hub Token",logo:"hub.svg",erc20:!0,symbol:"HUB",decimals:18},"0x8727c112C712c4a03371AC87a74dD6aB104Af768":{name:"Jetcoin Institute Token",logo:"JETCOIN28.png",erc20:!0,symbol:"JET",decimals:18},"0xf8e386EDa857484f5a12e4B5DAa9984E06E73705":{name:"Indorse Token",logo:"indorseLogo.jpg",erc20:!0,symbol:"IND",decimals:18},"0xA54ddC7B3CcE7FC8b1E3Fa0256D0DB80D2c10970":{name:"NEVERDIE Coin",logo:"ndc.png",erc20:!0,symbol:"NDC",decimals:18},"0x1c4481750daa5Ff521A2a7490d9981eD46465Dbd":{name:"BlockMason Credit Protocol Token",logo:"bcpt.svg",erc20:!0,symbol:"BCPT",decimals:18},"0x20F7A3DdF244dc9299975b4Da1C39F8D5D75f05A":{name:"Sapien Network Token",logo:"spn.svg",erc20:!0,symbol:"SPN",decimals:6},"0xA4e8C3Ec456107eA67d3075bF9e3DF3A75823DB0":{name:"Loom Token",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x42476F744292107e34519F9c357927074Ea3F75D":{name:"Loom",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x4F9254C83EB525f9FCf346490bbb3ed28a81C667":{name:"Celer Network Token",logo:"CELR.svg",erc20:!0,symbol:"CELR",decimals:18},"0x71D01dB8d6a2fBEa7f8d434599C237980C234e4C":{name:"Gladius",logo:"gladius.svg",erc20:!0,symbol:"GLA",decimals:8},"0xdd974D5C2e2928deA5F71b9825b8b646686BD200":{name:"Kyber Network Crystal",logo:"kyber.svg",erc20:!0,symbol:"KNC",decimals:18},"0x1F573D6Fb3F13d689FF844B4cE37794d79a7FF1C":{name:"Bancor Network Token",logo:"bnt.svg",erc20:!0,symbol:"BNT",decimals:18},"0xfa05A73FfE78ef8f1a739473e462c54bae6567D9":{name:"Lunyr Token",logo:"lun.svg",erc20:!0,symbol:"LUN",decimals:18},"0xC741f06082AA47F93729070aD0dD95E223Bda091":{name:"LEDU Token",logo:"edu.svg",erc20:!0,symbol:"LEDU",decimals:8},"0x5c543e7AE0A1104f78406C340E9C64FD9fCE5170":{name:"vSlice",logo:"vslice.png",erc20:!0,symbol:"VSL",decimals:18},"0x1f41E42D0a9e3c0Dd3BA15B527342783B43200A9":{name:"Blockchain Capital",logo:"bcap.svg",erc20:!0,symbol:"BCAP",decimals:0},"0x6531f133e6DeeBe7F2dcE5A0441aA7ef330B4e53":{name:"Chronobank TIME",logo:"chronobank.png",erc20:!0,symbol:"TIME",decimals:8},"0xaAAf91D9b90dF800Df4F55c205fd6989c977E73a":{name:"Monolith TKN",logo:"tkn.svg",erc20:!0,symbol:"TKN",decimals:8},"0x08711D3B02C8758F2FB3ab4e80228418a7F8e39c":{name:"Edgeless",logo:"edg.svg",erc20:!0,symbol:"EDG",decimals:0},"0xf7B098298f7C69Fc14610bf71d5e02c60792894C":{name:"Guppy",logo:"guppy.png",erc20:!0,symbol:"GUP",decimals:3},"0x4DF812F6064def1e5e029f1ca858777CC98D2D81":{name:"Xaurum",logo:"xaurum_logo.svg",erc20:!0,symbol:"XAUR",decimals:8},"0xB9e7F8568e08d5659f5D29C4997173d84CdF2607":{name:"Swarm City Token",logo:"swt.svg",erc20:!0,symbol:"SWT",decimals:18},"0xCb94be6f13A1182E4A4B6140cb7bf2025d28e41B":{name:"Trustcoin",logo:"trst.svg",erc20:!0,symbol:"TRST",decimals:6},"0xCB56b52316041A62B6b5D0583DcE4A8AE7a3C629":{name:"Cigarettes",logo:"cig.svg",erc20:!0,symbol:"CIG",decimals:18},"0x960b236A07cf122663c4303350609A66A7B288C0":{name:"Aragon Network Token v1",logo:"antv1.svg",erc20:!0,symbol:"ANTv1",decimals:18},"0x667088b212ce3d06a1b553a7221E1fD19000d9aF":{name:"WINGS",logo:"wings_logo.svg",erc20:!0,symbol:"WINGS",decimals:18},"0x16484d73Ac08d2355F466d448D2b79D2039F6EBB":{name:"FortKnoxster",logo:"FortKnoxster.svg",erc20:!0,symbol:"FKX",decimals:18},"0xAf30D2a7E90d7DC361c8C4585e9BB7D2F6f15bc7":{name:"FirstBlood Token",logo:"1st.svg",erc20:!0,symbol:"1ST",decimals:18},"0x607F4C5BB672230e8672085532f7e901544a7375":{name:"iExec RLC Token",logo:"rlc.svg",erc20:!0,symbol:"RLC",decimals:9},"0xaeC2E87E0A235266D9C5ADc9DEb4b2E29b54D009":{name:"SingularDTV",logo:"singulardtv.svg",erc20:!0,symbol:"SNGLS",decimals:0},"0x888666CA69E0f178DED6D75b5726Cee99A87D698":{name:"ICONOMI",logo:"iconomi.png",erc20:!0,symbol:"ICN",decimals:18},"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2":{name:"Maker",logo:"mkr.svg",erc20:!0,symbol:"MKR",decimals:18},"0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359":{name:"Sai Stablecoin v1.0",logo:"sai.svg",erc20:!0,symbol:"SAI",decimals:18},"0x6B175474E89094C44Da98b954EedeAC495271d0F":{name:"Dai Stablecoin",logo:"dai.svg",erc20:!0,symbol:"DAI",decimals:18},"0xC477D038d5420C6A9e0b031712f61c5120090de9":{name:"Boson Token",logo:"boson.svg",erc20:!0,symbol:"BOSON",decimals:18},"0xD46bA6D942050d489DBd938a2C909A5d5039A161":{name:"Ampleforth",logo:"ampl.svg",erc20:!0,symbol:"AMPL",decimals:9},"0x4b9278b94a1112cAD404048903b8d343a810B07e":{name:"Hifi Finance",logo:"hifi.svg",erc20:!0,symbol:"HIFI",decimals:18},"0x0D8775F648430679A709E98d2b0Cb6250d2887EF":{name:"Basic Attention Token",logo:"bat.svg",erc20:!0,symbol:"BAT",decimals:18},"0x4D8fc1453a0F359e99c9675954e656D80d996FbF":{name:"BEE Token",logo:"bee_token.svg",erc20:!0,symbol:"BEE",decimals:18},"0x6810e776880C02933D47DB1b9fc05908e5386b96":{name:"Gnosis Token",logo:"gnosis.svg",erc20:!0,symbol:"GNO",decimals:18},"0x514910771AF9Ca656af840dff83E8264EcF986CA":{name:"Chainlink Token",logo:"chainlink.svg",erc20:!0,symbol:"LINK",decimals:18},"0xD8912C10681D8B21Fd3742244f44658dBA12264E":{name:"Pluton",logo:"plutus-god.svg",erc20:!0,symbol:"PLU",decimals:18},"0x1985365e9f78359a9B6AD760e32412f4a445E862":{name:"Reputation Old",logo:"rep.svg",erc20:!0,symbol:"REP",decimals:18},"0x221657776846890989a759BA2973e427DfF5C9bB":{name:"Reputation",logo:"repv2.svg",erc20:!0,symbol:"REPv2",decimals:18},"0xd0929d411954c47438dc1d871dd6081F5C5e149c":{name:"Refereum",logo:"rfr.svg",erc20:!0,symbol:"RFR",decimals:4},"0xb0866289e870D2efc282406cF4123Df6E5BcB652":{name:"NoFakeCoin",logo:"nfticon.png",erc20:!0,symbol:"NFC",decimals:18},"0x2C4e8f2D746113d0696cE89B35F0d8bF88E0AEcA":{name:"Open Simple Token",logo:"OST.svg",erc20:!0,symbol:"OST",decimals:18},"0x408e41876cCCDC0F92210600ef50372656052a38":{name:"Republic Token",logo:"ren.svg",erc20:!0,symbol:"REN",decimals:18},"0xEB4C2781e4ebA804CE9a9803C67d0893436bB27D":{name:"renBTC",logo:"renBTC.svg",erc20:!0,symbol:"renBTC",decimals:8},"0x1C5db575E2Ff833E46a2E9864C22F4B22E0B37C2":{name:"renZEC",logo:"renZEC.svg",erc20:!0,symbol:"renZEC",decimals:8},"0x459086F2376525BdCebA5bDDA135e4E9d3FeF5bf":{name:"renBCH",logo:"renBCH.svg",erc20:!0,symbol:"renBCH",decimals:8},"0xD5147bc8e386d91Cc5DBE72099DAC6C9b99276F5":{name:"renFIL",logo:"renFIL.svg",erc20:!0,symbol:"renFIL",decimals:18},"0xa74476443119A942dE498590Fe1f2454d7D4aC0d":{name:"Golem Network Token",logo:"golem.svg",erc20:!0,symbol:"GNT",decimals:18},"0x6888a16eA9792c15A4DCF2f6C623D055c8eDe792":{name:"Spectiv Signal Token",logo:"spectiv.svg",erc20:!0,symbol:"SIG",decimals:18},"0x9a642d6b3368ddc662CA244bAdf32cDA716005BC":{name:"Qtum",logo:"qtum.svg",erc20:!0,decimals:18,symbol:"QTUM"},"0x1234567461d3f8Db7496581774Bd869C83D51c93":{name:"BitClave",logo:"bitclave.svg",erc20:!0,decimals:18,symbol:"CAT"},"0x7d4b8Cce0591C9044a22ee543533b72E976E36C3":{name:"Change",logo:"change.svg",erc20:!0,decimals:18,symbol:"CAG"},"0x1d462414fe14cf489c7A21CaC78509f4bF8CD7c0":{name:"CanYaCoin",logo:"CanYa.svg",erc20:!0,decimals:6,symbol:"CAN"},"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72":{name:"Ethereum Name Service",logo:"ens.svg",erc20:!0,decimals:18,symbol:"ENS"},"0x3d1BA9be9f66B8ee101911bC36D3fB562eaC2244":{name:"Rivetz",logo:"rivetz.png",erc20:!0,decimals:18,symbol:"RVT"},"0x056017c55aE7AE32d12AeF7C679dF83A85ca75Ff":{name:"Project Wyvern Token",logo:"wyvern-logo.svg",erc20:!0,symbol:"WYV",decimals:18},"0xfec0cF7fE078a500abf15F1284958F22049c2C7e":{name:"Maecenas ART Token",logo:"art.svg",erc20:!0,symbol:"ART",decimals:18},"0x05f4a42e251f2d52b8ed15E9FEdAacFcEF1FAD27":{name:"Zilliqa",logo:"zilliqa.svg",erc20:!0,symbol:"ZIL",decimals:12},"0x986EE2B944c42D017F52Af21c4c69B84DBeA35d8":{name:"BitMartToken",logo:"bitmart.png",erc20:!0,symbol:"BMX",decimals:18},"0xF03f8D65BaFA598611C3495124093c56e8F638f0":{name:"Viewly",logo:"viewly.svg",erc20:!0,symbol:"VIEW",decimals:18},"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2":{name:"Wrapped Ether",logo:"weth.svg",erc20:!0,symbol:"WETH",decimals:18},"0xba5BDe662c17e2aDFF1075610382B9B691296350":{name:"SuperRare Token",logo:"rare.svg",erc20:!0,symbol:"RARE",decimals:18},"0x6C8c6b02E7b2BE14d4fA6022Dfd6d75921D90E4E":{name:"Compound Basic Attention Token",logo:"ctoken-bat.svg",erc20:!0,symbol:"cBAT",decimals:8},"0x70e36f6BF80a52b3B46b3aF8e106CC0ed743E8e4":{name:"Compound Collateral",logo:"ctoken-comp.svg",erc20:!0,symbol:"cCOMP",decimals:8},"0x5d3a536E4D6DbD6114cc1Ead35777bAB948E3643":{name:"Compound Dai",logo:"ctoken-dai.svg",erc20:!0,symbol:"cDAI",decimals:8},"0xF5DCe57282A584D2746FaF1593d3121Fcac444dC":{name:"Compound Sai (Legacy Dai)",logo:"ctoken-sai.svg",erc20:!0,symbol:"cSAI",decimals:8},"0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5":{name:"Compound Ether",logo:"ctoken-eth.svg",erc20:!0,symbol:"cETH",decimals:8},"0x158079Ee67Fce2f58472A96584A73C7Ab9AC95c1":{name:"Compound Augur",logo:"ctoken-rep.svg",erc20:!0,symbol:"cREP",decimals:8},"0x39AA39c021dfbaE8faC545936693aC917d5E7563":{name:"Compound USD Coin",logo:"ctoken-usdc.svg",erc20:!0,symbol:"cUSDC",decimals:8},"0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9":{name:"Compound Tether",logo:"ctoken-usdt.svg",erc20:!0,symbol:"cUSDT",decimals:8},"0xC11b1268C1A384e55C48c2391d8d480264A3A7F4":{name:"Compound Wrapped BTC",logo:"ctoken-wbtc.svg",erc20:!0,symbol:"cWBTC",decimals:8},"0xB3319f5D18Bc0D84dD1b4825Dcde5d5f7266d407":{name:"Compound 0x",logo:"ctoken-zrx.svg",erc20:!0,symbol:"cZRX",decimals:8},"0xc00e94Cb662C3520282E6f5717214004A7f26888":{name:"Compound",logo:"comp.svg",erc20:!0,symbol:"COMP",decimals:18},"0xFFE02ee4C69eDf1b340fCaD64fbd6b37a7b9e265":{name:"NANJCOIN",logo:"nanjcoin.svg",erc20:!0,symbol:"NANJ",decimals:8},"0xB6eD7644C69416d67B522e20bC294A9a9B405B31":{name:"0xBitcoin Token",logo:"0xbitcoin.svg",erc20:!0,symbol:"0xBTC",decimals:8},"0x744d70FDBE2Ba4CF95131626614a1763DF805B9E":{name:"Status Network Token",logo:"snt.svg",erc20:!0,symbol:"SNT",decimals:18},"0x42d6622deCe394b54999Fbd73D108123806f6a18":{name:"SPANK",logo:"spank.svg",erc20:!0,symbol:"SPANK",decimals:18},"0x6B01c3170ae1EFEBEe1a3159172CB3F7A5ECf9E5":{name:"BOOTY",logo:"booty.png",erc20:!0,symbol:"BOOTY",decimals:18},"0x4a6058666cf1057eaC3CD3A5a614620547559fc9":{name:"Brickblock",logo:"Brickblock.svg",erc20:!0,symbol:"BBK",decimals:18},"0x80fB784B7eD66730e8b1DBd9820aFD29931aab03":{name:"ETHLend Token",logo:"lend.svg",erc20:!0,symbol:"LEND",decimals:18},"0x48FF53777F747cFB694101222a944dE070c15D36":{name:"Ether Kingdoms Token",logo:"IMP.svg",erc20:!0,symbol:"IMP",decimals:7},"0x02F61Fd266DA6E8B102D4121f5CE7b992640CF98":{name:"LikeCoin",logo:"like.svg",erc20:!0,symbol:"LIKE",decimals:18},"0xB8c77482e45F1F44dE1745F52C74426C631bDD52":{name:"Binance Coin",logo:"bnb.png",erc20:!0,symbol:"BNB",decimals:18},"0xD850942eF8811f2A866692A623011bDE52a462C1":{name:"VeChain",logo:"ven.svg",erc20:!0,symbol:"VEN",decimals:18},"0x91Af0fBB28ABA7E31403Cb457106Ce79397FD4E6":{name:"Aergo",logo:"Aergo.svg",erc20:!0,symbol:"AERGO",decimals:18},"0x5CA9a71B1d01849C0a95490Cc00559717fCF0D1d":{name:"Aeternity",logo:"aeternity.svg",erc20:!0,symbol:"AE",decimals:18},"0xd4fa1460F537bb9085d22C7bcCB5DD450Ef28e3a":{name:"Populous",logo:"ppt.svg",erc20:!0,symbol:"PPT",decimals:8},"0xFA1a856Cfa3409CFa145Fa4e20Eb270dF3EB21ab":{name:"IOST",logo:"iost.png",erc20:!0,symbol:"IOST",decimals:18},"0x039B5649A59967e3e936D7471f9c3700100Ee1ab":{name:"Kucoin Shares",logo:"kucoin.svg",erc20:!0,symbol:"KCS",decimals:6},"0x3893b9422Cd5D70a81eDeFfe3d5A1c6A978310BB":{name:"Mithril",logo:"mith.svg",erc20:!0,symbol:"MITH",decimals:18},"0xb7cB1C96dB6B22b0D3d9536E0108d062BD488F74":{name:"Walton Token",logo:"wtc.svg",erc20:!0,symbol:"WTC",decimals:18},"0x1776e1F26f98b1A5dF9cD347953a26dd3Cb46671":{name:"Numeraire",logo:"nmr.png",erc20:!0,symbol:"NMR",decimals:18},"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd":{name:"Gemini Dollar",logo:"gusd.svg",erc20:!0,symbol:"GUSD",decimals:2},"0xA4Bdb11dc0a2bEC88d24A3aa1E6Bb17201112eBe":{name:"StableUSD",logo:"usds.svg",erc20:!0,symbol:"USDS",decimals:6},"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48":{name:"USDC",logo:"usdc.svg",erc20:!0,symbol:"USDC",decimals:6},"0x1aBaEA1f7C830bD89Acc67eC4af516284b1bC33c":{name:"EURC",logo:"eurc.svg",erc20:!0,symbol:"EURC",decimals:6},"0x93ED3FBe21207Ec2E8f2d3c3de6e058Cb73Bc04d":{name:"Pinakion Token",logo:"pinakion.svg",erc20:!0,symbol:"PNK",decimals:18},"0x419D0d8BdD9aF5e606Ae2232ed285Aff190E711b":{name:"FunFair",logo:"fun.svg",erc20:!0,symbol:"FUN",decimals:8},"0xcA2796F9F61dc7b238Aab043971e49c6164DF375":{name:"YGGDRASH YEED Token",logo:"yggdrash.svg",erc20:!0,symbol:"YEED",decimals:18},"0x03e3f0c25965f13DbbC58246738C183E27b26a56":{name:"Disciplina Token",logo:"disciplina.svg",erc20:!0,symbol:"DSCP",decimals:18},"0xE814aeE960a85208C3dB542C53E7D4a6C8D5f60F":{name:"Chronologic DAY Token",logo:"DAY.png",erc20:!0,symbol:"DAY",decimals:18},"0x7E43581b19ab509BCF9397a2eFd1ab10233f27dE":{name:"PLATINUM",logo:"plat.png",erc20:!0,symbol:"PLAT",decimals:18},"0x8E870D67F660D95d5be530380D0eC0bd388289E1":{name:"Pax Dollar",logo:"usdp.svg",erc20:!0,symbol:"USDP",decimals:18},"0x45804880De22913dAFE09f4980848ECE6EcbAf78":{name:"PAX Gold",logo:"paxg.svg",erc20:!0,symbol:"PAXG",decimals:18},"0x0000000000085d4780B73119b644AE5ecd22b376":{name:"TrueUSD",logo:"TUSD.svg",erc20:!0,symbol:"TUSD",decimals:18},"0x00000000441378008EA67F4284A57932B1c000a5":{name:"TrueGBP",logo:"TGBP.svg",erc20:!0,symbol:"TGBP",decimals:18},"0x00006100F7090010005F1bd7aE6122c3C2CF0090":{name:"TrueAUD",logo:"TAUD.svg",erc20:!0,symbol:"TAUD",decimals:18},"0x00000100F2A2bd000715001920eB70D229700085":{name:"TrueCAD",logo:"TCAD.svg",erc20:!0,symbol:"TCAD",decimals:18},"0x0000852600CEB001E08e00bC008be620d60031F2":{name:"TrueHKD",logo:"THKD.svg",erc20:!0,symbol:"THKD",decimals:18},"0x4Fabb145d64652a948d72533023f6E7A623C7C53":{name:"Binance USD",logo:"busd.svg",erc20:!0,symbol:"BUSD",decimals:18},"0x23Ccc43365D9dD3882eab88F43d515208f832430":{name:"MidasProtocol",logo:"MAS.png",erc20:!0,symbol:"MAS",decimals:18},"0xC16b542ff490e01fcc0DC58a60e1EFdc3e357cA6":{name:"ICE ROCK MINING",logo:"rock2.png",erc20:!0,symbol:"ROCK2",decimals:0},"0x6758B7d441a9739b98552B373703d8d3d14f9e62":{name:"POA20 Token",logo:"POA20.png",erc20:!0,symbol:"POA20",decimals:18},"0x3DB6Ba6ab6F95efed1a6E794caD492fAAabF294D":{name:"LTO Network Token (old)",logo:"LTO.svg",erc20:!0,symbol:"LTOOLD",decimals:8},"0xd01409314aCb3b245CEa9500eCE3F6Fd4d70ea30":{name:"LTO Network Token",logo:"LTO.svg",erc20:!0,symbol:"LTO",decimals:8},"0xfeF4185594457050cC9c23980d301908FE057Bb1":{name:"VIDT Datalink",logo:"VIDT.svg",erc20:!0,symbol:"VIDT-OLD",decimals:18},"0x3BE7bF1A5F23BD8336787D0289B70602f1940875":{name:"VIDT DAO",logo:"VIDT.svg",erc20:!0,symbol:"VIDT",decimals:18},"0x7064aAb39A0Fcf7221c3396719D0917a65E35515":{name:"Cpollo",logo:"Cpollo.svg",erc20:!0,symbol:"CPLO",decimals:18},"0xd8446236FA95b9b5f9fd0f8E7Df1a944823c683d":{name:"NEEO",logo:"neeo.png",erc20:!0,symbol:"NEEO",decimals:18},"0xA823E6722006afe99E91c30FF5295052fe6b8E32":{name:"Neumark",logo:"neu.svg",erc20:!0,symbol:"NEU",decimals:18},"0x8f693ca8D21b157107184d29D398A8D082b38b76":{name:"Streamr",logo:"streamr.svg",erc20:!0,symbol:"DATA",decimals:18},"0x0Cf0Ee63788A0849fE5297F3407f701E122cC023":{name:"Streamr (old)",logo:"streamr_old.svg",erc20:!0,symbol:"XDATA",decimals:18},"0xA0b73E1Ff0B80914AB6fe0444E65848C4C34450b":{name:"Cronos",logo:"cro.svg",erc20:!0,symbol:"CRO",decimals:8},"0xF70a642bD387F94380fFb90451C2c81d4Eb82CBc":{name:"STAR",logo:"starbase.png",erc20:!0,symbol:"STAR",decimals:18},"0x7C5A0CE9267ED19B22F8cae653F198e3E8daf098":{name:"Santiment",logo:"santiment.svg",erc20:!0,symbol:"SAN",decimals:18},"0x58b6A8A3302369DAEc383334672404Ee733aB239":{name:"Livepeer",logo:"lpt.svg",erc20:!0,symbol:"LPT",decimals:18},"0x6fe56C0bcdD471359019FcBC48863d6c3e9d4F41":{name:"Props",logo:"props.png",erc20:!0,symbol:"PROPS",decimals:18},"0x6c6EE5e31d828De241282B9606C8e98Ea48526E2":{name:"HoloToken",logo:"hot.svg",erc20:!0,symbol:"HOT",decimals:18},"0xF629cBd94d3791C9250152BD8dfBDF380E2a3B9c":{name:"Enjin Coin",logo:"enj.svg",erc20:!0,symbol:"ENJ",decimals:18},"0xbf2179859fc6D5BEE9Bf9158632Dc51678a4100e":{name:"AELF",logo:"elf.svg",erc20:!0,symbol:"ELF",decimals:18},"0x39Bb259F66E1C59d5ABEF88375979b4D20D98022":{name:"WAX Token",logo:"wax.svg",erc20:!0,symbol:"WAX",decimals:8},"0x595832F8FC6BF59c85C527fEC3740A1b7a361269":{name:"PowerLedger",logo:"powr.svg",erc20:!0,symbol:"POWR",decimals:6},"0x28dee01D53FED0Edf5f6E310BF8Ef9311513Ae40":{name:"BlitzPredict",logo:"blitzpredict.svg",erc20:!0,symbol:"XBP",decimals:18},"0x33349B282065b0284d756F0577FB39c158F935e6":{name:"Maple Finance",logo:"maple-finance.svg",erc20:!0,erc721:!1,symbol:"MPL",decimals:18},"0xFBeef911Dc5821886e1dda71586d90eD28174B7d":{name:"KnownOrigin",logo:"knownorigin.svg",erc20:!0,symbol:"KODA",decimals:0},"0x8207c1FfC5B6804F6024322CcF34F29c3541Ae26":{name:"Origin Protocol",logo:"ogn.svg",erc20:!0,symbol:"OGN",decimals:18},"0x2A8e1E676Ec238d8A992307B495b45B3fEAa5e86":{name:"Origin Dollar",logo:"ousd.svg",erc20:!0,symbol:"OUSD",decimals:18},"0x856c4Efb76C1D1AE02e20CEB03A2A6a08b0b8dC3":{name:"Origin Ether",logo:"oeth.svg",erc20:!0,symbol:"OETH",decimals:18},"0x9c354503C38481a7A7a51629142963F98eCC12D0":{name:"Origin DeFi Governance",logo:"ogv.svg",erc20:!0,symbol:"OGV",decimals:18},"0x0C4576Ca1c365868E162554AF8e385dc3e7C66D9":{name:"Vote Escrowed Origin DeFi Governance",logo:"veogv.svg",erc20:!0,symbol:"veOGV",decimals:18},"0x8f8221aFbB33998d8584A2B05749bA73c37a938a":{name:"Request",logo:"request.svg",erc20:!0,symbol:"REQ",decimals:18},"0x2aEa4Add166EBf38b63d09a75dE1a7b94Aa24163":{name:"Kudos",logo:"kudos.svg",erc20:!1,erc721:!0,symbol:"KDO",decimals:0},"0x14C926F2290044B647e1Bf2072e67B495eff1905":{name:"Bethereum",logo:"bether.jpg",erc20:!0,symbol:"BETHER",decimals:18},"0x9AAb071B4129B083B01cB5A0Cb513Ce7ecA26fa5":{name:"Hunt Token",logo:"hunt.png",erc20:!0,symbol:"HUNT",decimals:18},"0xFEF3884b603C33EF8eD4183346E093A173C94da6":{name:"Metamorph",logo:"metamorph.svg",erc20:!0,symbol:"METM",decimals:18},"0x0AbdAce70D3790235af448C88547603b945604ea":{name:"district0x",logo:"district0x.svg",erc20:!0,symbol:"DNT",decimals:18},"0xB26631c6dda06aD89B93C71400D25692de89c068":{name:"Minds",logo:"minds.svg",erc20:!0,symbol:"MINDS",decimals:18},"0xBb1f24C0c1554b9990222f036b0AaD6Ee4CAec29":{name:"CryptoSoul",logo:"SOUL.svg",erc20:!0,symbol:"SOUL",decimals:18},"0xFF0E5e014cf97e0615cb50F6f39Da6388E2FaE6E":{name:"Origo",logo:"origo.svg",erc20:!0,symbol:"OGO",decimals:18},"0x0cB8D0B37C7487b11d57F1f33dEfA2B1d3cFccfE":{name:"DANKToken",logo:"dank-logo.svg",erc20:!0,symbol:"DANK",decimals:18},"0x3a4f40631a4f906c2BaD353Ed06De7A5D3fCb430":{name:"PlayDapp Token",logo:"playdapp.svg",erc20:!0,symbol:"PLA",decimals:18},"0xE9e3F9cfc1A64DFca53614a0182CFAD56c10624F":{name:"Su Squares",logo:"Su-Squares.svg",erc20:!1,erc721:!0,symbol:"SU",decimals:0},"0xfA5047c9c78B8877af97BDcb85Db743fD7313d4a":{name:"ROOK",logo:"Rook.svg",erc20:!0,symbol:"ROOK",decimals:18},"0xa62cc35625B0C8dc1fAEA39d33625Bb4C15bD71C":{name:"StormX",logo:"stormx.svg",erc20:!0,symbol:"STMX",decimals:18},"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0":{name:"Matic Network Token",logo:"matic.svg",erc20:!0,symbol:"MATIC",decimals:18},"0x9992eC3cF6A55b00978cdDF2b27BC6882d88D1eC":{name:"Polymath",logo:"poly.svg",erc20:!0,symbol:"POLY",decimals:18},"0x0a50C93c762fDD6E56D86215C24AaAD43aB629aa":{name:"LGO Token",logo:"lgo.png",erc20:!0,symbol:"LGO",decimals:8},"0xc8Cac7672f4669685817cF332a33Eb249F085475":{name:"LivenCoin",logo:"LVN.svg",erc20:!0,symbol:"LVN",decimals:18},"0xBBbbCA6A901c926F240b89EacB641d8Aec7AEafD":{name:"Loopring",logo:"LRC.svg",erc20:!0,symbol:"LRC",decimals:18},"0x255Aa6DF07540Cb5d3d297f0D0D4D84cb52bc8e6":{name:"Raiden Network Token",logo:"raiden.svg",erc20:!0,symbol:"RDN",decimals:18},"0x66fD97a78d8854fEc445cd1C80a07896B0b4851f":{name:"Lunch Money",logo:"LMY.svg",erc20:!0,symbol:"LMY",decimals:18},"0x679131F591B4f369acB8cd8c51E68596806c3916":{name:"Trustlines Network Token",logo:"TLN128.png",erc20:!0,symbol:"TLN",decimals:18},"0xdcD85914b8aE28c1E62f1C488E1D968D5aaFfE2b":{name:"TOP Network Token",logo:"TOP.svg",erc20:!0,symbol:"TOP",decimals:18},"0xaea46A60368A7bD060eec7DF8CBa43b7EF41Ad85":{name:"Fetch",logo:"fetch.svg",erc20:!0,symbol:"FET",decimals:18},"0x2e1E15C44Ffe4Df6a0cb7371CD00d5028e571d14":{name:"Mettalex",logo:"mettalex.svg",erc20:!0,symbol:"MTLX",decimals:18},"0xf21661D0D1d76d3ECb8e1B9F1c923DBfffAe4097":{name:"Realio Network",logo:"rio.svg",erc20:!0,symbol:"RIO",decimals:18},"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{name:"Uniswap",logo:"uni.svg",erc20:!0,symbol:"UNI",decimals:18},"0x2e6539edc3b76f1E21B71d214527FAbA875F70F3":{name:"Yearn Finance Dot",logo:"YFDOT.svg",erc20:!0,symbol:"YFDOT",decimals:18},"0x9F284E1337A815fe77D2Ff4aE46544645B20c5ff":{name:"Darwinia Commitment Token",logo:"kton.svg",erc20:!0,symbol:"KTON",decimals:18},"0xE48972fCd82a274411c01834e2f031D4377Fa2c0":{name:"TwoKeyEconomy",logo:"2key.svg",erc20:!0,symbol:"2KEY",decimals:18},"0x970B9bB2C0444F5E81e9d0eFb84C8ccdcdcAf84d":{name:"Fuse Token",logo:"fuse.svg",erc20:!0,symbol:"FUSE",decimals:18},"0x0Ae055097C6d159879521C384F1D2123D1f195e6":{name:"STAKE Token",logo:"stake.svg",erc20:!0,symbol:"STAKE",decimals:18},"0x5dc60C4D5e75D22588FA17fFEB90A63E535efCE0":{name:"dKargo",logo:"DKA.svg",erc20:!0,symbol:"DKA",decimals:18},"0x9469D013805bFfB7D3DEBe5E7839237e535ec483":{name:"Darwinia Network Native Token",logo:"ring.svg",erc20:!0,symbol:"RING",decimals:18},"0xA31B1767e09f842ECFd4bc471Fe44F830E3891AA":{name:"ROOBEE",logo:"ROOBEE.svg",erc20:!0,symbol:"ROOBEE",decimals:18},"0xC7e43A1c8E118aA2965F5EAbe0e718D83DB7A63C":{name:"ZCore Token",logo:"zcrt.svg",erc20:!0,symbol:"ZCRT",decimals:18},"0x08d32b0da63e2C3bcF8019c9c5d849d7a9d791e6":{name:"Dentacoin Token",logo:"dcn.svg",erc20:!0,symbol:"DCN",decimals:0},"0xe2f2a5C287993345a840Db3B0845fbC70f5935a5":{name:"mStable USD",logo:"mUSD.svg",erc20:!0,symbol:"mUSD",decimals:18},"0xa3BeD4E1c75D00fa6f4E5E6922DB7261B5E9AcD2":{name:"Meta",logo:"MTA.svg",erc20:!0,symbol:"MTA",decimals:18},"0xe3818504c1B32bF1557b16C238B2E01Fd3149C17":{name:"Pillar",logo:"plr.svg",erc20:!0,symbol:"PLR",decimals:18},"0xba100000625a3754423978a60c9317c58a424e3D":{name:"Balancer (BAL)",logo:"balancer.svg",erc20:!0,symbol:"BAL",decimals:18},"0x8a854288a5976036A725879164Ca3e91d30c6A1B":{name:"Guaranteed Entrance Token",logo:"get-logo.svg",erc20:!0,symbol:"GET",decimals:18},"0x2781246fe707bB15CeE3e5ea354e2154a2877B16":{name:"Elysia",logo:"el.svg",erc20:!0,symbol:"EL",decimals:18},"0x4dA34f8264CB33A5c9F17081B9EF5Ff6091116f4":{name:"Elyfi",logo:"elyfi.svg",erc20:!0,symbol:"ELFI",decimals:18},"0xc12d099be31567add4e4e4d0D45691C3F58f5663":{name:"Auctus",logo:"auc.svg",erc20:!0,symbol:"AUC",decimals:18},"0xdF574c24545E5FfEcb9a659c229253D4111d87e1":{name:"HUSD",logo:"HUSD.svg",erc20:!0,symbol:"HUSD",decimals:8},"0x2ecB13A8c458c379c4d9a7259e202De03c8F3D19":{name:"Block-Chain.com Token",logo:"block-chain.svg",erc20:!0,symbol:"BC",decimals:18},"0x38e4adB44ef08F22F5B5b76A8f0c2d0dCbE7DcA1":{name:"Concentrated Voting Power",logo:"PowerPool.svg",erc20:!0,symbol:"CVP",decimals:18},"0xa117000000f279D81A1D3cc75430fAA017FA5A2e":{name:"Aragon Network Token",logo:"antv2.svg",erc20:!0,symbol:"ANT",decimals:18},"0xDecade1c6Bf2cD9fb89aFad73e4a519C867adcF5":{name:"Experty Wisdom Token",logo:"wisdom-token.svg",erc20:!0,symbol:"WIS",decimals:18},"0x7D85e23014F84E6E21d5663aCD8751bEF3562352":{name:"Axion Old",logo:"obsolete.svg",erc20:!0,symbol:"AXNv1",decimals:18},"0x358AA737e033F34df7c54306960a38d09AaBd523":{name:"Ares Token",logo:"ares.svg",erc20:!0,symbol:"ARES",decimals:18},"0xB62132e35a6c13ee1EE0f84dC5d40bad8d815206":{name:"NEXO",logo:"NEXO.svg",erc20:!0,symbol:"NEXO",decimals:18},"0x4612021C75809160Be60DB21fBc9D6adD0B32deF":{name:"BCP Coin",logo:"BCP.svg",erc20:!0,symbol:"BCP",decimals:18},"0xE9E73E1aE76D17A16cC53E3e87a9a7dA78834d37":{name:"Camp",logo:"Camp.svg",erc20:!0,symbol:"CAMP",decimals:18},"0xdacD69347dE42baBfAEcD09dC88958378780FB62":{name:"Atari Token",logo:"atrilast.svg",erc20:!0,symbol:"ATRI",decimals:0},"0x71F85B2E46976bD21302B64329868fd15eb0D127":{name:"Axion",logo:"axion.svg",erc20:!0,symbol:"AXN",decimals:18},"0xc944E90C64B2c07662A292be6244BDf05Cda44a7":{name:"Graph Token",logo:"graphToken.svg",erc20:!0,symbol:"GRT",decimals:18},"0xFE3E6a25e6b192A42a44ecDDCd13796471735ACf":{name:"Reef Finance",logo:"reef.svg",erc20:!0,symbol:"REEF",decimals:18},"0x43Dfc4159D86F3A37A5A4B3D4580b888ad7d4DDd":{name:"DODO bird",logo:"DODO.svg",erc20:!0,symbol:"DODO",decimals:18},"0x4a615bB7166210CCe20E6642a6f8Fb5d4D044496":{name:"NAOS Finance",logo:"naos.svg",erc20:!0,symbol:"NAOS",decimals:18},"0x111111111117dC0aa78b770fA6A738034120C302":{name:"1INCH Token",logo:"1inch.svg",erc20:!0,symbol:"1INCH",decimals:18},"0x27702a26126e0B3702af63Ee09aC4d1A084EF628":{name:"Aleph.im Token",logo:"aleph.svg",erc20:!0,symbol:"ALEPH",decimals:18},"0x32a7C02e79c4ea1008dD6564b35F131428673c41":{name:"CRUST",logo:"crust.svg",erc20:!0,symbol:"CRU",decimals:18},"0x3472A5A71965499acd81997a54BBA8D852C6E53d":{name:"BADGER",logo:"badger.svg",erc20:!0,symbol:"BADGER",decimals:18},"0x65Def5029A0e7591e46B38742bFEdd1Fb7b24436":{name:"Kanpeki",logo:"kanpeki-green.svg",erc20:!0,symbol:"KAE",decimals:18},"0xF94b5C5651c888d928439aB6514B93944eEE6F48":{name:"Yield App",logo:"yield-app.svg",erc20:!0,symbol:"YLD",decimals:18},"0xDcB01cc464238396E213a6fDd933E36796eAfF9f":{name:"Yield",logo:"yield-logo.svg",erc20:!0,symbol:"YLD",decimals:18},"0x968F6f898a6Df937fC1859b323aC2F14643e3fED":{name:"Newscrypto",logo:"NWC.svg",erc20:!0,symbol:"NWC",decimals:18},"0xeb269732ab75A6fD61Ea60b06fE994cD32a83549":{name:"dForce USDx",logo:"USDx.svg",erc20:!0,symbol:"USDx",decimals:18},"0x6e0daDE58D2d89eBBe7aFc384e3E4f15b70b14D8":{name:"QuiverX",logo:"quiverx.svg",erc20:!0,symbol:"QRX",decimals:18},"0x0beAD9a1bcc1b84D06E3f2df67E3549Fd55aB054":{name:"EURxb",logo:"eurxb.svg",erc20:!0,symbol:"EURxb",decimals:18},"0x9F9c8ec3534c3cE16F928381372BfbFBFb9F4D24":{name:"GraphLinq",logo:"glq.svg",erc20:!0,symbol:"GLQ",decimals:18},"0xEB58343b36C7528F23CAAe63a150240241310049":{name:"NBU",logo:"NBU.svg",erc20:!0,symbol:"NBU",decimals:18},"0x16ECCfDbb4eE1A85A33f3A9B21175Cd7Ae753dB4":{name:"Route",logo:"route.svg",erc20:!0,symbol:"ROUTE",decimals:18},"0x75739d5944534115d7C54ee8C73F186D793BAE02":{name:"Collective",logo:"CO2.svg",erc20:!0,symbol:"CO2",decimals:18},"0x35bD01FC9d6D5D81CA9E055Db88Dc49aa2c699A8":{name:"FWB Pro",logo:"FWB.svg",erc20:!0,symbol:"FWB",decimals:18},"0x9B99CcA871Be05119B2012fd4474731dd653FEBe":{name:"Antimatter",logo:"antimatter.svg",erc20:!0,symbol:"MATTER",decimals:18},"0x6De037ef9aD2725EB40118Bb1702EBb27e4Aeb24":{name:"Render Token",logo:"RNDR.svg",erc20:!0,symbol:"RNDR",decimals:18},"0xDf49C9f599A0A9049D97CFF34D0C30E468987389":{name:"SaTT",logo:"SaTT.svg",erc20:!0,symbol:"SATT",decimals:18},"0x431ad2ff6a9C365805eBaD47Ee021148d6f7DBe0":{name:"dForce",logo:"DF.svg",erc20:!0,symbol:"DF",decimals:18},"0x6e1A19F235bE7ED8E3369eF73b196C07257494DE":{name:"Wrapped Filecoin",logo:"WFIL.svg",erc20:!0,symbol:"WFIL",decimals:18},"0xE452E6Ea2dDeB012e20dB73bf5d3863A3Ac8d77a":{name:"Wrapped Celo",logo:"WCELO.svg",erc20:!0,symbol:"wCELO",decimals:18},"0x4A64515E5E1d1073e83f30cB97BEd20400b66E10":{name:"Wrapped ZEC",logo:"WZEC.svg",erc20:!0,symbol:"WZEC",decimals:18},"0xA3865E64121537b5b59B5e239Db4aCBe6F36aa74":{name:"Wrapped Tezos",logo:"WXTZ.svg",erc20:!0,symbol:"WXTZ",decimals:18},"0x53c4871322Bb47e7A24136fce291a6dcC832a294":{name:"Wrapped Litecoin",logo:"WLTC.svg",erc20:!0,symbol:"WLTC",decimals:18},"0xad3E3Fc59dff318BecEaAb7D00EB4F68b1EcF195":{name:"Wrapped Celo USD",logo:"WCUSD.svg",erc20:!0,symbol:"wCUSD",decimals:18},"0x85D7bdfc9c3426b33A684241eEEE70385Bc42820":{name:"Wrapped Kadena",logo:"WKDA.svg",erc20:!0,symbol:"WKDA",decimals:18},"0x39fBBABf11738317a448031930706cd3e612e1B9":{name:"Wrapped XRP",logo:"WXRP.svg",erc20:!0,symbol:"WXRP",decimals:18},"0xBBC7f7A6AADAc103769C66CBC69AB720f7F9Eae3":{name:"INX Token",logo:"INX.svg",erc20:!0,symbol:"INX",decimals:18},"0x1b40183EFB4Dd766f11bDa7A7c3AD8982e998421":{name:"Vesper",logo:"vsp.svg",erc20:!0,symbol:"VSP",decimals:18},"0x544c42fBB96B39B21DF61cf322b5EDC285EE7429":{name:"InsurAce",logo:"INSUR.svg",erc20:!0,symbol:"INSUR",decimals:18},"0xcC665390b03c5D324D8fAF81C15eCee29A73bCB4":{name:"ChainSwap.com Governance Token",logo:"chainswap.svg",erc20:!0,symbol:"ASAP",decimals:18},"0x182F4c4C97cd1c24E1Df8FC4c053E5C47bf53Bef":{name:"keyTango Token",logo:"keyTango.svg",erc20:!0,symbol:"TANGO",decimals:18},"0x0275E1001e293C46CFe158B3702AADe0B99f88a5":{name:"Oiler",logo:"oiler.svg",erc20:!0,symbol:"OIL",decimals:18},"0xDe30da39c46104798bB5aA3fe8B9e0e1F348163F":{name:"Gitcoin",logo:"gtc.svg",erc20:!0,symbol:"GTC",decimals:18},"0x1796ae0b0fa4862485106a0de9b654eFE301D0b2":{name:"Polychain Monsters",logo:"PMON.svg",erc20:!0,symbol:"PMON",decimals:18},"0x8eEF5a82E6Aa222a60F009ac18c24EE12dBf4b41":{name:"Tixl",logo:"TXL.svg",erc20:!0,symbol:"TXL",decimals:18},"0x5218E472cFCFE0b64A064F055B43b4cdC9EfD3A6":{name:"unFederalReserve Token",logo:"eRSDL.svg",erc20:!0,symbol:"eRSDL",decimals:18},"0xE4cC5A22B39fFB0A56d67F94f9300db20D786a5F":{name:"unFederal eRSDL",logo:"uneRSDL.svg",erc20:!0,symbol:"uneRSDL",decimals:8},"0x2dbA05B51eF5A7DE3E7c3327201CA2F8a25C2414":{name:"unFederal DAI",logo:"unDAI.svg",erc20:!0,symbol:"unDAI",decimals:8},"0xFaCecE87e14B50eafc85C44C01702F5f485CA460":{name:"unFederal ETH",logo:"unETH.svg",erc20:!0,symbol:"unETH",decimals:8},"0x6b576972de33BebDe3A703BfF52a091e79f8c87A":{name:"unFederal USDC",logo:"unUSDC.svg",erc20:!0,symbol:"unUSDC",decimals:8},"0x6e2aA5bB90ac37D9006685AFc651ef067E1c7b44":{name:"unFederal USDT",logo:"unUSDT.svg",erc20:!0,symbol:"unUSDT",decimals:8},"0x5D446FC8DBd10EBAcfE9A427aB5402586af98cD4":{name:"unFederal WBTC",logo:"unWBTC.svg",erc20:!0,symbol:"unWBTC",decimals:8},"0xD837eCa6C91c67D98461A411BA2f00bdA9960a9D":{name:"unFederal AAVE",logo:"unAAVE.svg",erc20:!0,symbol:"unAAVE",decimals:8},"0x9e29Ce9cD25F4141dF6BB85b27Ef6933a16A5824":{name:"unFederal YFI",logo:"unYFI.svg",erc20:!0,symbol:"unYFI",decimals:8},"0x031002d15B0D0Cd7c9129d6F644446368deaE391":{name:"unFederal LINK",logo:"unLINK.svg",erc20:!0,symbol:"unLINK",decimals:8},"0xB8E2e2101eD11e9138803cd3e06e16dd19910647":{name:"ArdCoin",logo:"ardcoin.svg",erc20:!0,symbol:"ARDX",decimals:2},"0x6D0F5149c502faf215C89ab306ec3E50b15e2892":{name:"Portion Token",logo:"PRT.svg",erc20:!0,symbol:"PRT",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"3SPACE ART",logo:"3SPACE.svg",erc20:!0,symbol:"PACE",decimals:18},"0x3845badAde8e6dFF049820680d1F14bD3903a5d0":{name:"SAND",logo:"SAND.svg",erc20:!0,symbol:"SAND",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"Spacelens",logo:"SPACE.svg",erc20:!0,symbol:"SPACE",decimals:18},"0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a":{name:"Sandbox's LANDs",logo:"SAND.svg",erc20:!1,erc721:!0,symbol:"LAND",decimals:0},"0x362bc847A3a9637d3af6624EeC853618a43ed7D2":{name:"PARSIQ",logo:"parsiq.svg",erc20:!0,symbol:"PRQ",decimals:18},"0x21381e026Ad6d8266244f2A583b35F9E4413FA2a":{name:"Formation Finance",logo:"form.svg",erc20:!0,symbol:"FORM",decimals:18},"0x2ba592F78dB6436527729929AAf6c908497cB200":{name:"Cream",logo:"cream.svg",erc20:!0,symbol:"CREAM",decimals:18},"0x46576e20EC5F25586A6Fa2E0d6B6058354B72E72":{name:"Cryptomind",logo:"CR.svg",erc20:!0,erc721:!1,symbol:"CR",decimals:8},"0x5ab21Ec0bfa0B29545230395e3Adaca7d552C948":{name:"PUNKS Comic",logo:"punks-comic.svg",erc20:!1,erc721:!0,symbol:"COMIC",decimals:0},"0x9C2dc0c3CC2BADdE84B0025Cf4df1c5aF288D835":{name:"Coreto",logo:"coreto.svg",erc20:!0,symbol:"COR",decimals:18},"0x0De05F6447ab4D22c8827449EE4bA2D5C288379B":{name:"OOKI",logo:"ooki.svg",erc20:!0,symbol:"OOKI",decimals:18},"0x6B4c7A5e3f0B99FCD83e9c089BDDD6c7FCe5c611":{name:"Million",logo:"million.svg",erc20:!0,symbol:"MM",decimals:18},"0x56d811088235F11C8920698a204A5010a788f4b3":{name:"bZx Protocol Token (BZRX)",logo:"ic_token_bzrx.svg",erc20:!0,symbol:"BZRX",decimals:18},"0xB72B31907C1C95F3650b64b2469e08EdACeE5e8F":{name:"bZx Vesting Token (vBZRX)",logo:"ic_token_vbzrx.svg",erc20:!0,symbol:"vBZRX",decimals:18},"0x3085154623F51b00Dedfc6Ceeb5197277A66B17B":{name:"NIFTY",logo:"nfty.svg",erc20:!0,symbol:"NFTY",decimals:18},"0xB983E01458529665007fF7E0CDdeCDB74B967Eb6":{name:"Fulcrum ETH iToken (iETH)",logo:"ic_token_ieth.svg",erc20:!0,symbol:"iETH",decimals:18},"0x32E4c68B3A4a813b710595AebA7f6B7604Ab9c15":{name:"Fulcrum USDC iToken (iUSDC)",logo:"ic_token_iusdc.svg",erc20:!0,symbol:"iUSDC",decimals:6},"0x2ffa85f655752fB2aCB210287c60b9ef335f5b6E":{name:"Fulcrum WBTC iToken (iWBTC)",logo:"ic_token_ibtc.svg",erc20:!0,symbol:"iWBTC",decimals:8},"0x687642347a9282Be8FD809d8309910A3f984Ac5a":{name:"Fulcrum KNC iToken (iKNC)",logo:"ic_token_iknc.svg",erc20:!0,symbol:"iKNC",decimals:18},"0x463538705E7d22aA7f03Ebf8ab09B067e1001B54":{name:"Fulcrum LINK iToken (iLINK)",logo:"ic_token_ilink.svg",erc20:!0,symbol:"iLINK",decimals:18},"0x6b093998D36f2C7F0cc359441FBB24CC629D5FF0":{name:"Fulcrum DAI iToken (iDAI)",logo:"ic_token_idai.svg",erc20:!0,symbol:"iDAI",decimals:18},"0x7e9997a38A439b2be7ed9c9C4628391d3e055D48":{name:"Fulcrum USDT iToken (iUSDT)",logo:"ic_token_iusdt.svg",erc20:!0,symbol:"iUSDT",decimals:6},"0x9189c499727f88F8eCC7dC4EEA22c828E6AaC015":{name:"Fulcrum MKR iToken (iMKR)",logo:"ic_token_imkr.svg",erc20:!0,symbol:"iMKR",decimals:18},"0x18240BD9C07fA6156Ce3F3f61921cC82b2619157":{name:"Fulcrum BZRX iToken (iBZRX)",logo:"ic_token_ibzrx.svg",erc20:!0,symbol:"iBZRX",decimals:18},"0x7F3Fe9D492A9a60aEBb06d82cBa23c6F32CAd10b":{name:"Fulcrum YFI iToken (iYFI)",logo:"ic_token_iyfi.svg",erc20:!0,symbol:"iYFI",decimals:18},"0x0a625FceC657053Fe2D9FFFdeb1DBb4e412Cf8A8":{name:"Fulcrum UNI iToken (iUNI)",logo:"ic_token_iuni.svg",erc20:!0,symbol:"iUNI",decimals:18},"0x0cae8d91E0b1b7Bd00D906E990C3625b2c220db1":{name:"Fulcrum AAVE iToken (iAAVE)",logo:"ic_token_iaave.svg",erc20:!0,symbol:"iAAVE",decimals:18},"0x3dA0e01472Dee3746b4D324a65D7EdFaECa9Aa4f":{name:"Fulcrum LRC iToken (iLRC)",logo:"ic_token_ilrc.svg",erc20:!0,symbol:"iLRC",decimals:18},"0x6d29903BC2c4318b59B35d97Ab98ab9eC08Ed70D":{name:"Fulcrum COMP iToken (iCOMP)",logo:"ic_token_icomp.svg",erc20:!0,symbol:"iCOMP",decimals:18},"0x08c32b0726C5684024ea6e141C50aDe9690bBdcc":{name:"Stratos Token",logo:"stos.svg",erc20:!0,symbol:"STOS",decimals:18},"0xe28b3B32B6c345A34Ff64674606124Dd5Aceca30":{name:"Injective",logo:"inj.svg",erc20:!0,symbol:"INJ",decimals:18},"0xe516D78d784C77D479977BE58905B3f2b1111126":{name:"Bitspawn",logo:"spwn.svg",erc20:!0,symbol:"SPWN",decimals:18},"0xB16e967ff83DE3F1e9FCeAfbc2C28c1c5c56eF91":{name:"Polkadog",logo:"polkadog.svg",erc20:!0,symbol:"PDOG",decimals:18},"0x07c52c2537D84e532a9F15d32E152C8B94D2b232":{name:"ZkTube",logo:"ZKT.svg",erc20:!0,symbol:"ZKT",decimals:18},"0xF4d861575ecC9493420A3f5a14F85B13f0b50EB3":{name:"Fractal Protocol",logo:"fractal.svg",erc20:!0,symbol:"FCL",decimals:18},"0x3af33bEF05C2dCb3C7288b77fe1C8d2AeBA4d789":{name:"Kromatika",logo:"krom.svg",erc20:!0,symbol:"KROM",decimals:18},"0xA130E3a33a4d84b04c3918c4E5762223Ae252F80":{name:"Swash Token",logo:"swash.svg",erc20:!0,symbol:"SWASH",decimals:18},"0xea7Cc765eBC94C4805e3BFf28D7E4aE48D06468A":{name:"NearPad Token",logo:"nearpad.svg",erc20:!0,symbol:"PAD",decimals:18},"0x87C22615435998D69ACA34889D03155B694a94fc":{name:"DiemLibre",logo:"DLB.svg",erc20:!0,symbol:"DLB",decimals:18},"0x4d224452801ACEd8B2F0aebE155379bb5D594381":{name:"ApeCoin",logo:"APE.svg",erc20:!0,symbol:"APE",decimals:18},"0xCd1fAFf6e578Fa5cAC469d2418C95671bA1a62Fe":{name:"Torum Token",logo:"torum.svg",erc20:!0,symbol:"XTM",decimals:18},"0xcf0C122c6b73ff809C693DB761e7BaeBe62b6a2E":{name:"FLOKI",logo:"floki.svg",erc20:!0,symbol:"FLOKI",decimals:9},"0xe831F96A7a1DcE1aa2EB760b1e296c6A74CaA9d5":{name:"Nexum Coin",logo:"nexum.svg",erc20:!0,symbol:"Nexm",decimals:8},"0x6710c63432A2De02954fc0f851db07146a6c0312":{name:"MFG",logo:"mfg.svg",erc20:!0,symbol:"MFG",decimals:18},"0xae78736Cd615f374D3085123A210448E74Fc6393":{name:"Rocket Pool ETH",logo:"rETH.svg",erc20:!0,symbol:"rETH",decimals:18},"0x0C10bF8FcB7Bf5412187A595ab97a3609160b5c6":{name:"Decentralized USD",logo:"USDD.svg",erc20:!0,symbol:"USDD",decimals:18},"0xD33526068D116cE69F19A9ee46F0bd304F21A51f":{name:"Rocket Pool",logo:"rpl.svg",erc20:!0,symbol:"RPL",decimals:18},"0x9d38F670D15C14716BE1F109a4F453E966A2B6D4":{name:"Quid Ika",logo:"QuidIka.svg",erc20:!0,symbol:"QUID",decimals:9},"0xD3c625F54dec647DB8780dBBe0E880eF21BA4329":{name:"HollaEx Token",logo:"xht.svg",erc20:!0,symbol:"XHT",decimals:18},"0x01e0E2e61f554eCAaeC0cC933E739Ad90f24a86d":{name:"GTON",logo:"gton.svg",erc20:!0,symbol:"GTON",decimals:18},"0xeFF66B4A84C8a6b69b99EB1C5e39aF8fc35d13db":{name:"sGTON",logo:"sgton.svg",erc20:!0,symbol:"sGTON",decimals:18},"0x7659CE147D0e714454073a5dd7003544234b6Aa0":{name:"XCAD Token",logo:"xcad.svg",erc20:!0,symbol:"XCAD",decimals:18},"0x88dF592F8eb5D7Bd38bFeF7dEb0fBc02cf3778a0":{name:"Tellor Tributes",logo:"TRB.svg",erc20:!0,symbol:"TRB",decimals:18},"0x8d96B4ab6C741a4C8679AE323a100d74f085BA8F":{name:"Bazaars",logo:"BZR.svg",erc20:!0,symbol:"BZR",decimals:18},"0x9ee91F9f426fA633d227f7a9b000E28b9dfd8599":{name:"Liquid staked MATIC",logo:"stMATIC.svg",erc20:!0,symbol:"stMATIC",decimals:18},"0x0d02755a5700414B26FF040e1dE35D337DF56218":{name:"Bend Token",logo:"BendDAO.svg",erc20:!0,symbol:"BEND",decimals:18},"0x1A4b46696b2bB4794Eb3D4c26f1c55F9170fa4C5":{name:"BitDAO",logo:"BitDAO.svg",erc20:!0,erc721:!1,symbol:"BIT",decimals:18},"0xb8919522331C59f5C16bDfAA6A121a6E03A91F62":{name:"Home",logo:"home.svg",erc20:!0,erc721:!1,symbol:"HOME",decimals:6},"0xa54d2EBfD977ad836203c85F18db2F0a0cF88854":{name:"Bacon",logo:"bacon.svg",erc20:!0,erc721:!1,symbol:"BACON",decimals:18},"0x249cA82617eC3DfB2589c4c17ab7EC9765350a18":{name:"Verse",logo:"VERSE.svg",erc20:!0,erc721:!1,symbol:"VERSE",decimals:18},"0x317eb4ad9cfaC6232f0046831322E895507bcBeb":{name:"Tidex Token",logo:"tidex.svg",erc20:!0,symbol:"TDX",decimals:18},"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE":{name:"SHIBA INU",logo:"shib.svg",erc20:!0,symbol:"SHIB",decimals:18},"0x3506424F91fD33084466F402d5D97f05F8e3b4AF":{name:"chiliZ",logo:"chz.svg",erc20:!0,symbol:"CHZ",decimals:18},"0x15D4c048F83bd7e37d49eA4C83a07267Ec4203dA":{name:"Gala",logo:"gala.svg",erc20:!0,symbol:"GALA",decimals:8},"0x69af81e73A73B40adF4f3d4223Cd9b1ECE623074":{name:"Mask Network",logo:"mask.svg",erc20:!0,symbol:"MASK",decimals:18},"0xD533a949740bb3306d119CC777fa900bA034cd52":{name:"Curve DAO Token",logo:"crv.svg",erc20:!0,symbol:"CRV",decimals:18},"0x92D6C1e31e14520e676a687F0a93788B716BEff5":{name:"dYdX",logo:"dydx.svg",erc20:!0,symbol:"DYDX",decimals:18},"0x60bE1e1fE41c1370ADaF5d8e66f07Cf1C2Df2268":{name:"Perion Credits",logo:"perc.svg",erc20:!0,symbol:"PERC",decimals:18},"0x8971f9fd7196e5cEE2C1032B50F656855af7Dd26":{name:"Lambda",logo:"LAMB.svg",erc20:!0,symbol:"LAMB",decimals:18},"0x65514b352d1d4a17DE97f95C7faB177C625Bd6ff":{name:"KIBBLE Token",logo:"kibble.svg",erc20:!0,erc721:!1,symbol:"KBLE",decimals:18},"0xd9Fcd98c322942075A5C3860693e9f4f03AAE07b":{name:"Euler",logo:"eul.svg",erc20:!0,erc721:!1,symbol:"EUL",decimals:18},"0x777fD20c983d6658c1D50b3958B3A1733d1cd1E1":{name:"PUBLISH",logo:"publish.svg",erc20:!0,symbol:"NEWS",decimals:9},"0x19062190B1925b5b6689D7073fDfC8c2976EF8Cb":{name:"Swarm",logo:"ethswarm.svg",erc20:!0,symbol:"BZZ",decimals:16},"0x6aA030a9710CAD6E719A4EC0a85260Eb3F4F86c1":{name:"Real World Asset",logo:"rwa.svg",erc20:!0,symbol:"RWA",decimals:18},"0xde16Ce60804a881e9F8c4eBB3824646EDecd478D":{name:"MagicCraft",logo:"magiccraft.svg",erc20:!0,symbol:"MCRT",decimals:9},"0x7163436b8EfFfB469F6BB81cc908b1661d4795e6":{name:"Esco coin",logo:"escocoin.svg",erc20:!0,symbol:"ESCO",decimals:18},"0x9625cE7753ace1fa1865A47aAe2c5C2Ce4418569":{name:"KAP Games",logo:"kap-games.svg",erc20:!0,symbol:"KAP",decimals:18},"0x4FbB350052Bca5417566f188eB2EBCE5b19BC964":{name:"Rigo",logo:"grg.svg",erc20:!0,symbol:"GRG",decimals:18},"0xD8E163967FED76806Df0097B704bA721B9b37656":{name:"Cope",logo:"cope.svg",erc20:!0,symbol:"COPE",decimals:18},"0xdfbc9050F5B01DF53512DCC39B4f2B2BBaCD517A":{name:"Jobchain",logo:"job.svg",erc20:!0,symbol:"JOB",decimals:8},"0x083D41d6DD21EE938f0c055CA4fb12268DF0EfaC":{name:"GogolCoin",logo:"gol.svg",erc20:!0,symbol:"GOL",decimals:4},"0x9B4a69dE6CA0deFDD02c0c4ce6Cb84de5202944E":{name:"PROOF Platform",erc20:!0,symbol:"PROOF",decimals:9,logo:"proof-platform.svg"},"0x4507cEf57C46789eF8d1a19EA45f4216bae2B528":{name:"TokenFi",logo:"tokenfi.svg",erc20:!0,symbol:"TOKEN",decimals:9},"0x8B39B70E39Aa811b69365398e0aACe9bee238AEb":{name:"PolkaFoundry",logo:"pkf.svg",erc20:!0,symbol:"PKF",decimals:18},"0x2c95D751DA37A5C1d9c5a7Fd465c1d50F3d96160":{name:"WASSIE",logo:"wassie.svg",erc20:!0,symbol:"WASSIE",decimals:18},"0x06325440D014e39736583c165C2963BA99fAf14E":{name:"Curve.fi",logo:"steCRV.png",erc20:!0,symbol:"steCRV",decimals:18},"0x4E241A9EC66832a16bceaeB9156E524487f061D7":{name:"ETF Rocks",logo:"etf.svg",erc20:!0,symbol:"ETF",decimals:18},"0xA849EaaE994fb86Afa73382e9Bd88c2B6b18Dc71":{name:"Mass Vehicle Ledger",logo:"mvl.svg",erc20:!0,symbol:"MVL",decimals:18},"0xd5F7838F5C461fefF7FE49ea5ebaF7728bB0ADfa":{name:"Mantle Staked Ether",logo:"mETH.svg",erc20:!0,erc721:!1,symbol:"mETH",decimals:18}}}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/contract-map.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/index.js",{"./contract-map.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./contract-map.json")}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.NETWORKS_BYPASSING_VALIDATION=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=void 0;const r=e("./types.cjs");var s;n.RPC="rpc",n.FALL_BACK_VS_CURRENCY="ETH",n.IPFS_DEFAULT_GATEWAY_URL="https://cloudflare-ipfs.com/ipfs/",n.GANACHE_CHAIN_ID="0x539",n.MAX_SAFE_CHAIN_ID=0xfffffffffffec,n.ERC721="ERC721",n.ERC1155="ERC1155",n.ERC20="ERC20",n.ERC721_INTERFACE_ID="0x80ac58cd",n.ERC721_METADATA_INTERFACE_ID="0x5b5e139f",n.ERC721_ENUMERABLE_INTERFACE_ID="0x780e9d63",n.ERC1155_INTERFACE_ID="0xd9b67a26",n.ERC1155_METADATA_URI_INTERFACE_ID="0x0e89341c",n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID="0x4e2312e0",n.GWEI="gwei",n.ASSET_TYPES={NATIVE:"NATIVE",TOKEN:"TOKEN",NFT:"NFT",UNKNOWN:"UNKNOWN"},n.TESTNET_TICKER_SYMBOLS={GOERLI:"GoerliETH",SEPOLIA:"SepoliaETH",LINEA_GOERLI:"LineaETH",LINEA_SEPOLIA:"LineaETH",MEGAETH_TESTNET:"MegaETH"},n.BUILT_IN_CUSTOM_NETWORKS_RPC={MEGAETH_TESTNET:"https://carrot.megaeth.com/rpc","megaeth-testnet":"https://carrot.megaeth.com/rpc","monad-testnet":"https://testnet-rpc.monad.xyz"},n.BUILT_IN_NETWORKS={[r.NetworkType.goerli]:{chainId:r.ChainId.goerli,ticker:r.NetworksTicker.goerli,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.goerli}},[r.NetworkType.sepolia]:{chainId:r.ChainId.sepolia,ticker:r.NetworksTicker.sepolia,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.sepolia}},[r.NetworkType.mainnet]:{chainId:r.ChainId.mainnet,ticker:r.NetworksTicker.mainnet,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.mainnet}},[r.NetworkType["linea-goerli"]]:{chainId:r.ChainId["linea-goerli"],ticker:r.NetworksTicker["linea-goerli"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-goerli"]}},[r.NetworkType["linea-sepolia"]]:{chainId:r.ChainId["linea-sepolia"],ticker:r.NetworksTicker["linea-sepolia"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-sepolia"]}},[r.NetworkType["linea-mainnet"]]:{chainId:r.ChainId["linea-mainnet"],ticker:r.NetworksTicker["linea-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-mainnet"]}},[r.NetworkType["megaeth-testnet"]]:{chainId:r.ChainId["megaeth-testnet"],ticker:r.NetworksTicker["megaeth-testnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["megaeth-testnet"]}},[r.NetworkType["monad-testnet"]]:{chainId:r.ChainId["monad-testnet"],ticker:r.NetworksTicker["monad-testnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["monad-testnet"]}},[r.NetworkType["base-mainnet"]]:{chainId:r.ChainId["base-mainnet"],ticker:r.NetworksTicker["base-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["base-mainnet"]}},[r.NetworkType["arbitrum-mainnet"]]:{chainId:r.ChainId["arbitrum-mainnet"],ticker:r.NetworksTicker["arbitrum-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["arbitrum-mainnet"]}},[r.NetworkType["bsc-mainnet"]]:{chainId:r.ChainId["bsc-mainnet"],ticker:r.NetworksTicker["bsc-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["bsc-mainnet"]}},[r.NetworkType["optimism-mainnet"]]:{chainId:r.ChainId["optimism-mainnet"],ticker:r.NetworksTicker["optimism-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["optimism-mainnet"]}},[r.NetworkType["polygon-mainnet"]]:{chainId:r.ChainId["polygon-mainnet"],ticker:r.NetworksTicker["polygon-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["polygon-mainnet"]}},[r.NetworkType["sei-mainnet"]]:{chainId:r.ChainId["sei-mainnet"],ticker:r.NetworksTicker["sei-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["sei-mainnet"]}},[r.NetworkType.rpc]:{chainId:undefined,blockExplorerUrl:undefined,ticker:undefined,rpcPrefs:undefined}},n.NETWORKS_BYPASSING_VALIDATION={"0x3e7":{name:"HyperEVM",symbol:"HYPE",rpcUrl:"https://rpc.hyperliquid.xyz"}},n.OPENSEA_PROXY_URL="https://proxy.api.cx.metamask.io/opensea/v1/api/v2",n.NFT_API_BASE_URL="https://nft.api.cx.metamask.io",n.NFT_API_VERSION="1",n.NFT_API_TIMEOUT=15e3,n.ORIGIN_METAMASK="metamask",function(e){e.AddEthereumChain="wallet_addEthereumChain",e.ConnectAccounts="connect_accounts",e.EthDecrypt="eth_decrypt",e.EthGetEncryptionPublicKey="eth_getEncryptionPublicKey",e.EthSignTypedData="eth_signTypedData",e.PersonalSign="personal_sign",e.ResultError="result_error",e.ResultSuccess="result_success",e.SnapDialogAlert="snap_dialog:alert",e.SnapDialogConfirmation="snap_dialog:confirmation",e.SnapDialogPrompt="snap_dialog:prompt",e.SnapDialogDefault="snap_dialog",e.SwitchEthereumChain="wallet_switchEthereumChain",e.Transaction="transaction",e.TransactionBatch="transaction_batch",e.Unlock="unlock",e.WalletConnect="wallet_connect",e.WalletRequestPermissions="wallet_requestPermissions",e.WatchAsset="wallet_watchAsset"}(s||(n.ApprovalType=s={})),n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP={[r.ChainId.goerli]:r.BuiltInNetworkName.Goerli,[r.ChainId.sepolia]:r.BuiltInNetworkName.Sepolia,[r.ChainId.mainnet]:r.BuiltInNetworkName.Mainnet,[r.ChainId["linea-goerli"]]:r.BuiltInNetworkName.LineaGoerli,[r.ChainId["linea-sepolia"]]:r.BuiltInNetworkName.LineaSepolia,[r.ChainId["linea-mainnet"]]:r.BuiltInNetworkName.LineaMainnet,[r.ChainId.aurora]:r.BuiltInNetworkName.Aurora},n.SECOND=1e3,n.SECONDS=n.SECOND,n.MINUTE=60*n.SECONDS,n.MINUTES=n.MINUTE,n.HOUR=60*n.MINUTES,n.HOURS=n.HOUR,n.DAY=24*n.HOURS,n.DAYS=n.DAY}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs",{cockatiel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/cockatiel/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createServicePolicy=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_MAX_RETRIES=n.handleWhen=n.handleAll=n.ExponentialBackoff=n.ConstantBackoff=n.CircuitState=n.CockatielEventEmitter=n.BrokenCircuitError=void 0;const r=e("cockatiel");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return r.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return r.CircuitState}}),Object.defineProperty(n,"CockatielEventEmitter",{enumerable:!0,get:function(){return r.EventEmitter}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return r.ExponentialBackoff}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return r.ConstantBackoff}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return r.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return r.handleWhen}});const s="available",o="degraded",a="unavailable",i="unknown";n.DEFAULT_MAX_RETRIES=3,n.DEFAULT_MAX_CONSECUTIVE_FAILURES=3*(1+n.DEFAULT_MAX_RETRIES),n.DEFAULT_CIRCUIT_BREAK_DURATION=18e5,n.DEFAULT_DEGRADED_THRESHOLD=5e3;const c=e=>"object"!=typeof e||null===e||!("httpStatus"in e)||"number"!=typeof e.httpStatus||e.httpStatus>=500;function m(e){return e===r.CircuitState.Open?{state:e,openedAt:Date.now()}:{state:e}}n.createServicePolicy=function(e={}){const{maxRetries:t=n.DEFAULT_MAX_RETRIES,retryFilterPolicy:d=r.handleAll,maxConsecutiveFailures:u=n.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:l=n.DEFAULT_CIRCUIT_BREAK_DURATION,degradedThreshold:h=n.DEFAULT_DEGRADED_THRESHOLD,backoff:f=new r.ExponentialBackoff}=e;let p=i;const g=(0,r.retry)(d,{maxAttempts:t,backoff:f}),y=g.onRetry.bind(g),k=new r.ConsecutiveBreaker(u),b=(0,r.circuitBreaker)((0,r.handleWhen)(c),{halfOpenAfter:l,breaker:k});let x=m(b.state);b.onStateChange(e=>{x=m(e)}),b.onBreak(()=>{p=a});const w=b.onBreak.bind(b),_=new r.EventEmitter,v=_.addListener,E=new r.EventEmitter,j=E.addListener;return g.onGiveUp(e=>{b.state===r.CircuitState.Closed&&(p=o,_.emit(e))}),g.onSuccess(({duration:e})=>{b.state===r.CircuitState.Closed&&(e>h?(p=o,_.emit()):p!==s&&(p=s,E.emit()))}),{...(0,r.wrap)(g,b),circuitBreakerPolicy:b,circuitBreakDuration:l,getCircuitState:()=>b.state,getRemainingCircuitOpenDuration:()=>x.state===r.CircuitState.Open?x.openedAt+l-Date.now():null,reset:()=>{const{dispose:e}=b.isolate();e(),k.success(),p=i},retryPolicy:g,onBreak:w,onDegraded:v,onAvailable:j,onRetry:y}}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/create-service-policy.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","./create-service-policy.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs","./siwe.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs","./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.fetchWithErrorHandling=n.convertHexToDecimal=n.BNToHex=n.NETWORKS_BYPASSING_VALIDATION=n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=n.handleWhen=n.handleAll=n.createServicePolicy=n.ExponentialBackoff=n.DEFAULT_MAX_RETRIES=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.ConstantBackoff=n.CockatielEventEmitter=n.CircuitState=n.BrokenCircuitError=void 0,n.isEqualCaseInsensitive=n.weiHexToGweiDec=n.toHex=n.toChecksumHexAddress=n.timeoutFetch=n.successfulFetch=n.safelyExecuteWithTimeout=n.safelyExecute=n.query=n.normalizeEnsName=n.isValidHexAddress=n.isValidJson=n.isSmartContractCode=n.isSafeDynamicKey=n.isSafeChainId=n.isPlainObject=n.isNonEmptyArray=n.HttpError=n.hexToText=n.hexToBN=n.handleFetch=n.gweiDecToWEIBN=n.getBuyURL=n.fromHex=n.fractionBN=void 0;var o=e("./create-service-policy.cjs");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return o.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return o.CircuitState}}),Object.defineProperty(n,"CockatielEventEmitter",{enumerable:!0,get:function(){return o.CockatielEventEmitter}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return o.ConstantBackoff}}),Object.defineProperty(n,"DEFAULT_CIRCUIT_BREAK_DURATION",{enumerable:!0,get:function(){return o.DEFAULT_CIRCUIT_BREAK_DURATION}}),Object.defineProperty(n,"DEFAULT_DEGRADED_THRESHOLD",{enumerable:!0,get:function(){return o.DEFAULT_DEGRADED_THRESHOLD}}),Object.defineProperty(n,"DEFAULT_MAX_CONSECUTIVE_FAILURES",{enumerable:!0,get:function(){return o.DEFAULT_MAX_CONSECUTIVE_FAILURES}}),Object.defineProperty(n,"DEFAULT_MAX_RETRIES",{enumerable:!0,get:function(){return o.DEFAULT_MAX_RETRIES}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return o.ExponentialBackoff}}),Object.defineProperty(n,"createServicePolicy",{enumerable:!0,get:function(){return o.createServicePolicy}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return o.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return o.handleWhen}});var a=e("./constants.cjs");Object.defineProperty(n,"RPC",{enumerable:!0,get:function(){return a.RPC}}),Object.defineProperty(n,"FALL_BACK_VS_CURRENCY",{enumerable:!0,get:function(){return a.FALL_BACK_VS_CURRENCY}}),Object.defineProperty(n,"IPFS_DEFAULT_GATEWAY_URL",{enumerable:!0,get:function(){return a.IPFS_DEFAULT_GATEWAY_URL}}),Object.defineProperty(n,"GANACHE_CHAIN_ID",{enumerable:!0,get:function(){return a.GANACHE_CHAIN_ID}}),Object.defineProperty(n,"MAX_SAFE_CHAIN_ID",{enumerable:!0,get:function(){return a.MAX_SAFE_CHAIN_ID}}),Object.defineProperty(n,"ERC721",{enumerable:!0,get:function(){return a.ERC721}}),Object.defineProperty(n,"ERC1155",{enumerable:!0,get:function(){return a.ERC1155}}),Object.defineProperty(n,"ERC20",{enumerable:!0,get:function(){return a.ERC20}}),Object.defineProperty(n,"ERC721_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_METADATA_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_METADATA_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_ENUMERABLE_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_ENUMERABLE_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_METADATA_URI_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_METADATA_URI_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_TOKEN_RECEIVER_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_TOKEN_RECEIVER_INTERFACE_ID}}),Object.defineProperty(n,"GWEI",{enumerable:!0,get:function(){return a.GWEI}}),Object.defineProperty(n,"ASSET_TYPES",{enumerable:!0,get:function(){return a.ASSET_TYPES}}),Object.defineProperty(n,"TESTNET_TICKER_SYMBOLS",{enumerable:!0,get:function(){return a.TESTNET_TICKER_SYMBOLS}}),Object.defineProperty(n,"BUILT_IN_CUSTOM_NETWORKS_RPC",{enumerable:!0,get:function(){return a.BUILT_IN_CUSTOM_NETWORKS_RPC}}),Object.defineProperty(n,"BUILT_IN_NETWORKS",{enumerable:!0,get:function(){return a.BUILT_IN_NETWORKS}}),Object.defineProperty(n,"OPENSEA_PROXY_URL",{enumerable:!0,get:function(){return a.OPENSEA_PROXY_URL}}),Object.defineProperty(n,"NFT_API_BASE_URL",{enumerable:!0,get:function(){return a.NFT_API_BASE_URL}}),Object.defineProperty(n,"NFT_API_VERSION",{enumerable:!0,get:function(){return a.NFT_API_VERSION}}),Object.defineProperty(n,"NFT_API_TIMEOUT",{enumerable:!0,get:function(){return a.NFT_API_TIMEOUT}}),Object.defineProperty(n,"ORIGIN_METAMASK",{enumerable:!0,get:function(){return a.ORIGIN_METAMASK}}),Object.defineProperty(n,"ApprovalType",{enumerable:!0,get:function(){return a.ApprovalType}}),Object.defineProperty(n,"CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP",{enumerable:!0,get:function(){return a.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP}}),Object.defineProperty(n,"SECOND",{enumerable:!0,get:function(){return a.SECOND}}),Object.defineProperty(n,"SECONDS",{enumerable:!0,get:function(){return a.SECONDS}}),Object.defineProperty(n,"MINUTE",{enumerable:!0,get:function(){return a.MINUTE}}),Object.defineProperty(n,"MINUTES",{enumerable:!0,get:function(){return a.MINUTES}}),Object.defineProperty(n,"HOUR",{enumerable:!0,get:function(){return a.HOUR}}),Object.defineProperty(n,"HOURS",{enumerable:!0,get:function(){return a.HOURS}}),Object.defineProperty(n,"DAY",{enumerable:!0,get:function(){return a.DAY}}),Object.defineProperty(n,"DAYS",{enumerable:!0,get:function(){return a.DAYS}}),Object.defineProperty(n,"NETWORKS_BYPASSING_VALIDATION",{enumerable:!0,get:function(){return a.NETWORKS_BYPASSING_VALIDATION}});var i=e("./util.cjs");Object.defineProperty(n,"BNToHex",{enumerable:!0,get:function(){return i.BNToHex}}),Object.defineProperty(n,"convertHexToDecimal",{enumerable:!0,get:function(){return i.convertHexToDecimal}}),Object.defineProperty(n,"fetchWithErrorHandling",{enumerable:!0,get:function(){return i.fetchWithErrorHandling}}),Object.defineProperty(n,"fractionBN",{enumerable:!0,get:function(){return i.fractionBN}}),Object.defineProperty(n,"fromHex",{enumerable:!0,get:function(){return i.fromHex}}),Object.defineProperty(n,"getBuyURL",{enumerable:!0,get:function(){return i.getBuyURL}}),Object.defineProperty(n,"gweiDecToWEIBN",{enumerable:!0,get:function(){return i.gweiDecToWEIBN}}),Object.defineProperty(n,"handleFetch",{enumerable:!0,get:function(){return i.handleFetch}}),Object.defineProperty(n,"hexToBN",{enumerable:!0,get:function(){return i.hexToBN}}),Object.defineProperty(n,"hexToText",{enumerable:!0,get:function(){return i.hexToText}}),Object.defineProperty(n,"HttpError",{enumerable:!0,get:function(){return i.HttpError}}),Object.defineProperty(n,"isNonEmptyArray",{enumerable:!0,get:function(){return i.isNonEmptyArray}}),Object.defineProperty(n,"isPlainObject",{enumerable:!0,get:function(){return i.isPlainObject}}),Object.defineProperty(n,"isSafeChainId",{enumerable:!0,get:function(){return i.isSafeChainId}}),Object.defineProperty(n,"isSafeDynamicKey",{enumerable:!0,get:function(){return i.isSafeDynamicKey}}),Object.defineProperty(n,"isSmartContractCode",{enumerable:!0,get:function(){return i.isSmartContractCode}}),Object.defineProperty(n,"isValidJson",{enumerable:!0,get:function(){return i.isValidJson}}),Object.defineProperty(n,"isValidHexAddress",{enumerable:!0,get:function(){return i.isValidHexAddress}}),Object.defineProperty(n,"normalizeEnsName",{enumerable:!0,get:function(){return i.normalizeEnsName}}),Object.defineProperty(n,"query",{enumerable:!0,get:function(){return i.query}}),Object.defineProperty(n,"safelyExecute",{enumerable:!0,get:function(){return i.safelyExecute}}),Object.defineProperty(n,"safelyExecuteWithTimeout",{enumerable:!0,get:function(){return i.safelyExecuteWithTimeout}}),Object.defineProperty(n,"successfulFetch",{enumerable:!0,get:function(){return i.successfulFetch}}),Object.defineProperty(n,"timeoutFetch",{enumerable:!0,get:function(){return i.timeoutFetch}}),Object.defineProperty(n,"toChecksumHexAddress",{enumerable:!0,get:function(){return i.toChecksumHexAddress}}),Object.defineProperty(n,"toHex",{enumerable:!0,get:function(){return i.toHex}}),Object.defineProperty(n,"weiHexToGweiDec",{enumerable:!0,get:function(){return i.weiHexToGweiDec}}),Object.defineProperty(n,"isEqualCaseInsensitive",{enumerable:!0,get:function(){return i.isEqualCaseInsensitive}}),s(e("./types.cjs"),n),s(e("./siwe.cjs"),n)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("controller-utils")}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs",{"./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@spruceid/siwe-parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@spruceid/siwe-parser/dist/parsers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.detectSIWE=n.isValidSIWEOrigin=n.parseDomainParts=void 0;const r=e("@metamask/utils"),s=e("@spruceid/siwe-parser"),o=e("./logger.cjs"),a=(0,o.createModuleLogger)(o.projectLogger,"detect-siwe");function i(e){try{const s="string"!=typeof(n=e)?n:(0,r.remove0x)(n),o=t.from(s,"hex");return 32===o.length?e:o.toString("utf8")}catch(t){return a(t),e}var n}const c={"http:":"80","https:":"443"};n.parseDomainParts=(e,t)=>e.match(/^[^/:]*:\/\//u)?new URL(e):new URL(`${t}//${e}`);n.isValidSIWEOrigin=e=>{try{const{origin:t,siwe:r}=e;if(!t||!r?.parsedMessage?.domain)return!1;const s=new URL(t),o=(0,n.parseDomainParts)(r.parsedMessage.domain,s.protocol);return 0===o.hostname.localeCompare(s.hostname,undefined,{sensitivity:"accent"})&&(""!==o.port&&o.port!==s.port?""===s.port&&o.port===c[s.protocol]:""===o.username||o.username===s.username)}catch(e){return a(e),!1}};n.detectSIWE=e=>{try{const{data:t}=e,n=i(t);return{isSIWEMessage:!0,parsedMessage:new s.ParsedMessage(n)}}catch(e){return{isSIWEMessage:!1,parsedMessage:null}}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/siwe.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s;Object.defineProperty(n,"__esModule",{value:!0}),n.NetworkNickname=n.BlockExplorerUrl=n.NetworksTicker=n.ChainId=n.BuiltInNetworkName=n.isInfuraNetworkType=n.isNetworkType=n.NetworkType=n.CustomNetworkType=n.InfuraNetworkType=void 0,n.InfuraNetworkType={mainnet:"mainnet",goerli:"goerli",sepolia:"sepolia","linea-goerli":"linea-goerli","linea-sepolia":"linea-sepolia","linea-mainnet":"linea-mainnet","base-mainnet":"base-mainnet","arbitrum-mainnet":"arbitrum-mainnet","bsc-mainnet":"bsc-mainnet","optimism-mainnet":"optimism-mainnet","polygon-mainnet":"polygon-mainnet","sei-mainnet":"sei-mainnet"},n.CustomNetworkType={"megaeth-testnet":"megaeth-testnet","monad-testnet":"monad-testnet"},n.NetworkType={...n.InfuraNetworkType,...n.CustomNetworkType,rpc:"rpc"},n.isNetworkType=function(e){return Object.values(n.NetworkType).includes(e)},n.isInfuraNetworkType=function(e){return Object.keys(n.InfuraNetworkType).includes(e)},function(e){e.Mainnet="mainnet",e.Goerli="goerli",e.Sepolia="sepolia",e.LineaGoerli="linea-goerli",e.LineaSepolia="linea-sepolia",e.LineaMainnet="linea-mainnet",e.Aurora="aurora",e.MegaETHTestnet="megaeth-testnet",e.MonadTestnet="monad-testnet",e.BaseMainnet="base-mainnet",e.ArbitrumOne="arbitrum-mainnet",e.BscMainnet="bsc-mainnet",e.OptimismMainnet="optimism-mainnet",e.PolygonMainnet="polygon-mainnet",e.SeiMainnet="sei-mainnet"}(r||(n.BuiltInNetworkName=r={})),n.ChainId={[r.Mainnet]:"0x1",[r.Goerli]:"0x5",[r.Sepolia]:"0xaa36a7",[r.Aurora]:"0x4e454152",[r.LineaGoerli]:"0xe704",[r.LineaSepolia]:"0xe705",[r.LineaMainnet]:"0xe708",[r.MegaETHTestnet]:"0x18c6",[r.MonadTestnet]:"0x279f",[r.BaseMainnet]:"0x2105",[r.ArbitrumOne]:"0xa4b1",[r.BscMainnet]:"0x38",[r.OptimismMainnet]:"0xa",[r.PolygonMainnet]:"0x89",[r.SeiMainnet]:"0x531"},function(e){e.mainnet="ETH",e.goerli="GoerliETH",e.sepolia="SepoliaETH",e["linea-goerli"]="LineaETH",e["linea-sepolia"]="LineaETH",e["linea-mainnet"]="ETH",e["megaeth-testnet"]="MegaETH",e["monad-testnet"]="MON",e["base-mainnet"]="ETH",e["arbitrum-mainnet"]="ETH",e["bsc-mainnet"]="BNB",e["optimism-mainnet"]="ETH",e["polygon-mainnet"]="POL",e["sei-mainnet"]="SEI",e.rpc=""}(s||(n.NetworksTicker=s={})),n.BlockExplorerUrl={[r.Mainnet]:"https://etherscan.io",[r.Goerli]:"https://goerli.etherscan.io",[r.Sepolia]:"https://sepolia.etherscan.io",[r.LineaGoerli]:"https://goerli.lineascan.build",[r.LineaSepolia]:"https://sepolia.lineascan.build",[r.LineaMainnet]:"https://lineascan.build",[r.MegaETHTestnet]:"https://megaexplorer.xyz",[r.MonadTestnet]:"https://testnet.monadexplorer.com",[r.BaseMainnet]:"https://basescan.org",[r.ArbitrumOne]:"https://arbiscan.io",[r.BscMainnet]:"https://bscscan.com",[r.OptimismMainnet]:"https://optimistic.etherscan.io",[r.PolygonMainnet]:"https://polygonscan.com",[r.SeiMainnet]:"https://seitrace.com"},n.NetworkNickname={[r.Mainnet]:"Ethereum Mainnet",[r.Goerli]:"Goerli",[r.Sepolia]:"Sepolia",[r.LineaGoerli]:"Linea Goerli",[r.LineaSepolia]:"Linea Sepolia",[r.LineaMainnet]:"Linea",[r.MegaETHTestnet]:"Mega Testnet",[r.MonadTestnet]:"Monad Testnet",[r.BaseMainnet]:"Base Mainnet",[r.ArbitrumOne]:"Arbitrum One",[r.BscMainnet]:"BSC Mainnet",[r.OptimismMainnet]:"Optimism Mainnet",[r.PolygonMainnet]:"Polygon Mainnet",[r.SeiMainnet]:"Sei Mainnet"}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","@metamask/ethjs-unit":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-unit/lib/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","eth-ens-namehash":"/home/runner/work/metamask-extension/metamask-extension/node_modules/eth-ens-namehash/index.js","fast-deep-equal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-deep-equal/index.js",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.isEqualCaseInsensitive=n.isValidJson=n.isNonEmptyArray=n.isPlainObject=n.convertHexToDecimal=n.query=n.normalizeEnsName=n.timeoutFetch=n.fetchWithErrorHandling=n.handleFetch=n.successfulFetch=n.HttpError=n.isSmartContractCode=n.isValidHexAddress=n.toChecksumHexAddress=n.safelyExecuteWithTimeout=n.safelyExecute=n.toHex=n.fromHex=n.hexToText=n.hexToBN=n.getBuyURL=n.weiHexToGweiDec=n.gweiDecToWEIBN=n.fractionBN=n.BNToHex=n.isSafeChainId=n.isSafeDynamicKey=n.PROTOTYPE_POLLUTION_BLOCKLIST=void 0;const s=e("@metamask/ethjs-unit"),o=e("@metamask/utils"),a=r(e("bn.js")),i=r(e("eth-ens-namehash")),c=r(e("fast-deep-equal")),m=e("lodash"),d=e("./constants.cjs"),u=new Error("timeout");function l(e){return e?new a.default((0,o.remove0x)(e),16):new a.default(0)}n.PROTOTYPE_POLLUTION_BLOCKLIST=["__proto__","constructor","prototype"],n.isSafeDynamicKey=function(e){return"string"==typeof e&&!n.PROTOTYPE_POLLUTION_BLOCKLIST.some(t=>e===t)},n.isSafeChainId=function(e){if(!(0,o.isHexString)(e))return!1;const t=Number.parseInt(e,(0,o.isStrictHexString)(e)?16:10);return Number.isSafeInteger(t)&&t>0&&t<=d.MAX_SAFE_CHAIN_ID},n.BNToHex=function(e){return(0,o.add0x)(e.toString(16))},n.fractionBN=function(e,t,n){const r=new a.default(t),s=new a.default(n);return e.mul(r).div(s)},n.gweiDecToWEIBN=function(e){if(Number.isNaN(e))return new a.default(0);const t=e.toString().split("."),n=t[0]||"0";let r=t[1]||"";if(!r)return(0,s.toWei)(n,"gwei");if(r.length<=9)return(0,s.toWei)(`${n}.${r}`,"gwei");const o=r.slice(9)[0];r=r.slice(0,9);let i=(0,s.toWei)(`${n}.${r}`,"gwei");return Number(o)>=5&&(i=i.add(new a.default(1))),i},n.weiHexToGweiDec=function(e){const t=new a.default((0,o.remove0x)(e),16);return(0,s.fromWei)(t,"gwei")},n.getBuyURL=function(e="1",t,n=5){switch(e){case"1":return`https://buy.coinbase.com/?code=9ec56d01-7e81-5017-930c-513daa27bb6a&amount=${n}&address=${t}&crypto_currency=ETH`;case"5":return"https://goerli-faucet.slock.it/";case"11155111":return"https://sepoliafaucet.net/";default:return undefined}},n.hexToBN=l,n.hexToText=function(e){try{const n=(0,o.remove0x)(e);return t.from(n,"hex").toString("utf8")}catch(t){return e}},n.fromHex=function(e){return a.default.isBN(e)?e:new a.default(l(e).toString(10))},n.toHex=function(e){return"string"==typeof e&&(0,o.isStrictHexString)(e)?e:`0x${a.default.isBN(e)||"bigint"==typeof e?e.toString(16):new a.default(e.toString(),10).toString(16)}`},n.safelyExecute=async function(e,t=!1){try{return await e()}catch(e){return t&&console.error(e),undefined}},n.safelyExecuteWithTimeout=async function(e,t=!1,n=500){try{return await Promise.race([e(),new Promise((e,t)=>setTimeout(()=>{t(u)},n))])}catch(e){return t&&console.error(e),undefined}},n.toChecksumHexAddress=(0,m.memoize)(function(e){if("string"!=typeof e)return e;const t=(0,o.add0x)(e);if(!(0,o.isHexString)(t))return t;try{return(0,o.getChecksumAddress)(t)}catch(e){if(e instanceof Error&&"Invalid hex address."===e.message)return t;throw e}}),n.isValidHexAddress=(0,m.memoize)(function(e,{allowNonPrefixed:t=!0}={}){const n=t?(0,o.add0x)(e):e;return!!(0,o.isStrictHexString)(n)&&(0,o.isHexChecksumAddress)(n)},(e,{allowNonPrefixed:t=!0}={})=>`${e}-${t}`),n.isSmartContractCode=function(e){return!!e&&("0x"!==e&&"0x0"!==e)};class h extends Error{constructor(e,t){super(t||`Fetch failed with status '${e}'`),this.httpStatus=e}}async function f(e,t){const n=await fetch(e,t);if(!n.ok)throw new h(n.status,`Fetch failed with status '${n.status}' for request '${String(e)}'`);return n}async function p(e,t){const n=await f(e,t);return await n.json()}n.HttpError=h,n.successfulFetch=f,n.handleFetch=p,n.fetchWithErrorHandling=async function({url:e,options:t,timeout:n,errorCodesToCatch:r}){let s;try{s=n?Promise.race([await p(e,t),new Promise((e,t)=>setTimeout(()=>{t(u)},n))]):await p(e,t)}catch(e){!function(e,t=[]){if(!e)return;if(!(e instanceof Error))throw e;if(!t.some(t=>e.message.includes(`Fetch failed with status '${t}'`))&&!e.message.includes("Failed to fetch")&&e!==u)throw e;console.error(e)}(e,r)}return s},n.timeoutFetch=async function(e,t,n=500){return Promise.race([f(e,t),new Promise((e,t)=>setTimeout(()=>{t(u)},n))])},n.normalizeEnsName=function(e){if("."===e)return e;if(e&&"string"==typeof e)try{const t=i.default.normalize(e.trim());if(t.match(/^(([\w\d-]+)\.)*[\w\d-]{7,}\.(eth|test)$/u))return t}catch(e){}return null},n.query=function(e,t,n=[]){return new Promise((r,s)=>{const o=(e,t)=>{e?s(e):r(t)};t in e&&"function"==typeof e[t]?e[t](...n,o):e.sendAsync({method:t,params:n},o)})};n.convertHexToDecimal=(e="0x0")=>(0,o.isStrictHexString)(e)?parseInt(e,16):Number(e)?Number(e):0,n.isPlainObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)},n.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},n.isValidJson=function(e){try{return(0,c.default)(e,JSON.parse(JSON.stringify(e)))}catch(e){return!1}},n.isEqualCaseInsensitive=function(e,t){return"string"==typeof e&&"string"==typeof t&&e.toLowerCase()===t.toLowerCase()}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/delegation-core/dist/index.cjs",{"@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/hashes/sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha3.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("@metamask/utils"),s={out:"hex"};function o(e,t){if("hex"===t.out){const t="string"==typeof e?e:r.bytesToHex.call(void 0,e);return t.startsWith("0x")?t:`0x${t}`}return e instanceof Uint8Array?e:r.hexToBytes.call(void 0,e)}var a=e=>"string"==typeof e?e:r.bytesToHex.call(void 0,e),i=e=>"string"==typeof e?r.hexToBytes.call(void 0,e):e,c=({value:e,size:t})=>e.toString(16).padStart(2*t,"0");var m=253402300799;var d=e("@metamask/abi-utils"),u=e("@noble/hashes/sha3"),l="0x88c1d2ecf185adf710588203a5f263f0ff61be0d33da39792cde19ba9aa4331e",h="0x80ad7e1b04ee6d994a125f4714ca0720908bd80ed16063ec8aee4b88e9253e2d",f="(address,address,bytes32,(address,bytes,bytes)[],uint256,bytes)[]";var p=(e,t)=>{const[n,r,s,o,a,i]=e;return{delegate:t(n),delegator:t(r),authority:t(s),caveats:o.map(([e,n,r])=>({enforcer:t(e),terms:t(n),args:t(r)})),salt:a,signature:t(i)}};function g(e){const t=32*e.length,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];if(!r)throw new Error(`Caveat was undefined at index ${t}`);const s=y(r);n.set(s,32*t)}return u.keccak_256.call(void 0,n)}function y(e){const t="string"==typeof e.terms?r.hexToBytes.call(void 0,e.terms):e.terms,n=u.keccak_256.call(void 0,t),s=d.encode.call(void 0,["bytes32","address","bytes32"],[h,e.enforcer,n]);return u.keccak_256.call(void 0,s)}n.ANY_BENEFICIARY="0x0000000000000000000000000000000000000a11",n.CAVEAT_TYPEHASH=h,n.DELEGATION_TYPEHASH=l,n.ROOT_AUTHORITY="0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",n.createERC20StreamingTerms=function(e,t=s){const{tokenAddress:n,initialAmount:a,maxAmount:i,amountPerSecond:m,startTime:d}=e;if(!n)throw new Error("Invalid tokenAddress: must be a valid address");let u;if("string"==typeof n){if(!r.isHexString.call(void 0,n)||42!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");u=n}else{if(20!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");u=r.bytesToHex.call(void 0,n)}if(a<0n)throw new Error("Invalid initialAmount: must be greater than zero");if(i<=0n)throw new Error("Invalid maxAmount: must be a positive number");if(i<a)throw new Error("Invalid maxAmount: must be greater than initialAmount");if(m<=0n)throw new Error("Invalid amountPerSecond: must be a positive number");if(d<=0)throw new Error("Invalid startTime: must be a positive number");if(d>253402300799)throw new Error("Invalid startTime: must be less than or equal to 253402300799");return o(`${u}${c({value:a,size:32})}${c({value:i,size:32})}${c({value:m,size:32})}${c({value:d,size:32})}`,t)},n.createERC20TokenPeriodTransferTerms=function(e,t=s){const{tokenAddress:n,periodAmount:a,periodDuration:i,startDate:m}=e;if(!n)throw new Error("Invalid tokenAddress: must be a valid address");let d;if("string"==typeof n){if(!r.isHexString.call(void 0,n)||42!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");d=n}else{if(20!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");d=r.bytesToHex.call(void 0,n)}if(a<=0n)throw new Error("Invalid periodAmount: must be a positive number");if(i<=0)throw new Error("Invalid periodDuration: must be a positive number");if(m<=0)throw new Error("Invalid startDate: must be a positive number");return o(`${d}${c({value:a,size:32})}${c({value:i,size:32})}${c({value:m,size:32})}`,t)},n.createExactCalldataTerms=function(e,t=s){const{calldata:n}=e;if("string"==typeof n&&!n.startsWith("0x"))throw new Error("Invalid calldata: must be a hex string starting with 0x");return o(n,t)},n.createNativeTokenPeriodTransferTerms=function(e,t=s){const{periodAmount:n,periodDuration:r,startDate:a}=e;if(n<=0n)throw new Error("Invalid periodAmount: must be a positive number");if(r<=0)throw new Error("Invalid periodDuration: must be a positive number");if(a<=0)throw new Error("Invalid startDate: must be a positive number");return o(`0x${c({value:n,size:32})}${c({value:r,size:32})}${c({value:a,size:32})}`,t)},n.createNativeTokenStreamingTerms=function(e,t=s){const{initialAmount:n,maxAmount:r,amountPerSecond:a,startTime:i}=e;if(n<0n)throw new Error("Invalid initialAmount: must be greater than zero");if(r<=0n)throw new Error("Invalid maxAmount: must be a positive number");if(r<n)throw new Error("Invalid maxAmount: must be greater than initialAmount");if(a<=0n)throw new Error("Invalid amountPerSecond: must be a positive number");if(i<=0)throw new Error("Invalid startTime: must be a positive number");if(i>253402300799)throw new Error("Invalid startTime: must be less than or equal to 253402300799");return o(`0x${c({value:n,size:32})}${c({value:r,size:32})}${c({value:a,size:32})}${c({value:i,size:32})}`,t)},n.createNonceTerms=function(e,t=s){const{nonce:n}=e;if(n instanceof Uint8Array&&0===n.length)throw new Error("Invalid nonce: Uint8Array must not be empty");if("string"==typeof n&&!n.startsWith("0x"))throw new Error("Invalid nonce: string must have 0x prefix");const i=a(n);if("0x"===i)throw new Error("Invalid nonce: must not be empty");if(!r.isHexString.call(void 0,i))throw new Error("Invalid nonce: must be a valid BytesLike value");if(i.length>66)throw new Error("Invalid nonce: must be 32 bytes or less in length");return o(`0x${i.slice(2).padStart(64,"0")}`,t)},n.createTimestampTerms=function(e,t=s){const{timestampAfterThreshold:n,timestampBeforeThreshold:r}=e;if(n<0)throw new Error("Invalid timestampAfterThreshold: must be zero or positive");if(r<0)throw new Error("Invalid timestampBeforeThreshold: must be zero or positive");if(r>m)throw new Error("Invalid timestampBeforeThreshold: must be less than or equal to 253402300799");if(n>m)throw new Error("Invalid timestampAfterThreshold: must be less than or equal to 253402300799");if(0!==r&&n>=r)throw new Error("Invalid thresholds: timestampBeforeThreshold must be greater than timestampAfterThreshold when both are specified");return o(`0x${c({value:n,size:16})}${c({value:r,size:16})}`,t)},n.createValueLteTerms=function(e,t=s){const{maxValue:n}=e;if(n<0n)throw new Error("Invalid maxValue: must be greater than or equal to zero");return o(c({value:n,size:32}),t)},n.decodeDelegations=function(e,t=s){const n=d.decodeSingle.call(void 0,f,e);return"bytes"===t.out?n.map(e=>p(e,i)):n.map(e=>p(e,a))},n.encodeDelegations=function(e,t=s){let n;if(0===e.length)n=new Uint8Array(64),n[31]=32;else{const t=e.map(e=>[e.delegate,e.delegator,e.authority,e.caveats.map(e=>[e.enforcer,e.terms,e.args]),e.salt,e.signature]);n=d.encodeSingle.call(void 0,f,t)}return o(n,t)},n.hashDelegation=function(e,t=s){const n=d.encode.call(void 0,["bytes32","address","address","bytes32","bytes32","uint256"],[l,e.delegate,e.delegator,e.authority,g(e.caveats),e.salt]);return o(u.keccak_256.call(void 0,n),t)}}}},{package:"@metamask/delegation-core",file:"node_modules/@metamask/delegation-core/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i,c,m,d=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},u=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},l=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.PollingBlockTracker=void 0;const h=l(e("@metamask/safe-event-emitter")),f=e("@metamask/utils"),p=l(e("json-rpc-random-id")),g=e("./logging-utils.cjs"),y=(0,g.createModuleLogger)(g.projectLogger,"polling-block-tracker"),k=(0,p.default)(),b=["sync","latest"];class x extends h.default{constructor(e={}){if(!e.provider)throw new Error("PollingBlockTracker - no provider specified.");super(),r.add(this),s.set(this,[]),o.set(this,void 0),a.set(this,void 0),this._blockResetDuration=e.blockResetDuration||2e4,this._usePastBlocks=e.usePastBlocks||!1,this._currentBlock=null,this._isRunning=!1,this._onNewListener=this._onNewListener.bind(this),this._onRemoveListener=this._onRemoveListener.bind(this),this._resetCurrentBlock=this._resetCurrentBlock.bind(this),this._setupInternalEvents(),this._provider=e.provider,this._pollingInterval=e.pollingInterval||2e4,this._retryTimeout=e.retryTimeout||this._pollingInterval/10,this._keepEventLoopActive=e.keepEventLoopActive===undefined||e.keepEventLoopActive,this._setSkipCacheFlag=e.setSkipCacheFlag||!1}async destroy(){this._cancelBlockResetTimeout(),super.removeAllListeners(),this._maybeEnd()}isRunning(){return this._isRunning}getCurrentBlock(){return this._currentBlock}async getLatestBlock({useCache:e=!0}={}){if(this._currentBlock&&e)return this._currentBlock;if(d(this,o,"f"))return await d(this,o,"f").promise;const{promise:t,resolve:n,reject:s}=(0,f.createDeferredPromise)({suppressUnhandledRejection:!0});if(u(this,o,{reject:s,promise:t},"f"),this._isRunning)try{const e=t=>{d(this,r,"m",c).call(this,e),this.removeListener("latest",e),n(t)};return d(this,r,"m",i).call(this,e),this.once("latest",e),await t}catch(e){throw s(e),e}finally{u(this,o,undefined,"f")}else try{const e=await this._updateLatestBlock();return n(e),e}catch(e){throw s(e),e}finally{setTimeout(()=>{u(this,o,undefined,"f")},this._pollingInterval)}}removeAllListeners(e){return e?super.removeAllListeners(e):super.removeAllListeners(),this._setupInternalEvents(),this._onRemoveListener(),this}_setupInternalEvents(){this.removeListener("newListener",this._onNewListener),this.removeListener("removeListener",this._onRemoveListener),this.on("newListener",this._onNewListener),this.on("removeListener",this._onRemoveListener)}_onNewListener(e){b.includes(e)&&this._maybeStart()}_onRemoveListener(){this._getBlockTrackerEventCount()>0||this._maybeEnd()}_maybeStart(){this._isRunning||(this._isRunning=!0,this._cancelBlockResetTimeout(),this._start(),this.emit("_started"))}_maybeEnd(){this._isRunning&&(this._isRunning=!1,this._setupBlockResetTimeout(),this._end(),d(this,r,"m",m).call(this,new Error("Block tracker destroyed")),this.emit("_ended"))}_getBlockTrackerEventCount(){return b.map(e=>this.listeners(e)).flat().filter(e=>d(this,s,"f").every(t=>!Object.is(t,e))).length}_shouldUseNewBlock(e){const t=this._currentBlock;if(!t)return!0;const n=w(e),r=w(t);return this._usePastBlocks&&n<r||n>r}_newPotentialLatest(e){this._shouldUseNewBlock(e)&&this._setCurrentBlock(e)}_setCurrentBlock(e){const t=this._currentBlock;this._currentBlock=e,this.emit("latest",e),this.emit("sync",{oldBlock:t,newBlock:e})}_setupBlockResetTimeout(){this._cancelBlockResetTimeout(),this._blockResetTimeout=setTimeout(this._resetCurrentBlock,this._blockResetDuration),this._blockResetTimeout.unref&&this._blockResetTimeout.unref()}_cancelBlockResetTimeout(){this._blockResetTimeout&&clearTimeout(this._blockResetTimeout)}_resetCurrentBlock(){this._currentBlock=null}async checkForLatestBlock(){return await this._updateLatestBlock(),await this.getLatestBlock()}_start(){this._updateAndQueue()}_end(){this._clearPollingTimeout()}async _updateLatestBlock(){const e=await this._fetchLatestBlock();return this._newPotentialLatest(e),this._isRunning||this._setupBlockResetTimeout(),this._currentBlock}async _fetchLatestBlock(){if(d(this,a,"f"))return await d(this,a,"f").promise;const{promise:e,resolve:t,reject:n}=(0,f.createDeferredPromise)({suppressUnhandledRejection:!0});u(this,a,{reject:n,promise:e},"f");try{const e={jsonrpc:"2.0",id:k(),method:"eth_blockNumber",params:[]};this._setSkipCacheFlag&&(e.skipCache=!0),y("Making request",e);const n=await this._provider.request(e);return y("Got result",n),t(n),n}catch(e){throw y("Encountered error fetching block",(0,f.getErrorMessage)(e)),n(e),d(this,r,"m",m).call(this,e),e}finally{u(this,a,undefined,"f")}}async _updateAndQueue(){let e=this._pollingInterval;try{await this._updateLatestBlock()}catch(t){try{this.emit("error",t)}catch{console.error(`Error updating latest block: ${(0,f.getErrorMessage)(t)}`)}e=this._retryTimeout}if(!this._isRunning)return;this._clearPollingTimeout();const t=setTimeout(()=>{this._updateAndQueue()},e);t.unref&&!this._keepEventLoopActive&&t.unref(),this._pollingTimeout=t,this.emit("_waitingForNextIteration")}_clearPollingTimeout(){this._pollingTimeout&&(clearTimeout(this._pollingTimeout),this._pollingTimeout=undefined)}}function w(e){return Number.parseInt(e,16)}n.PollingBlockTracker=x,s=new WeakMap,o=new WeakMap,a=new WeakMap,r=new WeakSet,i=function(e){d(this,s,"f").push(e)},c=function(e){d(this,s,"f").splice(d(this,s,"f").indexOf(e),1)},m=function(e){d(this,o,"f")?.reject(e),u(this,o,undefined,"f")}}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/index.cjs",{"./PollingBlockTracker.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./PollingBlockTracker.cjs"),n)}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("eth-block-tracker")}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/logging-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/key-tree":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/index.cjs","@metamask/scure-bip39":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/index.js","@metamask/scure-bip39/dist/wordlists/english.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/wordlists/english.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/hdkey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/hdkey.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r,s,o,a,i,c,m,d,u,l,h,f=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},p=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;const g=e("@ethereumjs/util"),y=e("@metamask/eth-sig-util"),k=e("@metamask/key-tree"),b=e("@metamask/scure-bip39"),x=e("@metamask/scure-bip39/dist/wordlists/english.js"),w=e("@metamask/utils"),_=e("ethereum-cryptography/hdkey"),v=e("ethereum-cryptography/keccak"),E="m/44'/60'/0'/0",j="HD Key Tree";class T{constructor(e={}){r.add(this),this.type=j,this.hdPath=E,s.set(this,new Map),o.set(this,void 0),f(this,o,e.cryptographicFunctions,"f")}async generateRandomMnemonic(){await p(this,r,"m",u).call(this,(0,b.generateMnemonic)(x.wordlist))}async serialize(){let e=[];if(this.mnemonic){const t=p(this,r,"m",a).call(this,this.mnemonic);e=Array.from((new TextEncoder).encode(t))}return{mnemonic:e,numberOfAccounts:p(this,s,"f").size,hdPath:this.hdPath}}async deserialize(e){if(e.numberOfAccounts&&!e.mnemonic)throw new Error("Eth-Hd-Keyring: Deserialize method cannot be called with an opts value for numberOfAccounts and no menmonic");if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");p(this,s,"f").clear(),this.mnemonic=null,this.seed=null,this.root=null,this.hdPath=e.hdPath??E,e.mnemonic&&await p(this,r,"m",u).call(this,e.mnemonic),e.numberOfAccounts&&await this.addAccounts(e.numberOfAccounts)}async addAccounts(e=1){if(!this.root)throw new Error("Eth-Hd-Keyring: No secret recovery phrase provided");const t=p(this,s,"f").size,n=[];for(let o=t;o<e+t;o++){const e=this.root.deriveChild(o);(0,w.assert)(e.publicKey,"Expected public key to be set");const t=p(this,r,"m",l).call(this,e.publicKey),a={hdKey:e,address:t};p(this,s,"f").set(t,a),n.push(t)}return Promise.resolve(n)}async getAccounts(){return Array.from(p(this,s,"f").keys())}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const n=p(this,r,"m",d).call(this,e,{withAppKeyOrigin:t});(0,w.assert)(n.publicKey,"Expected public key to be set");return p(this,r,"m",h).call(this,(0,w.bytesToHex)((0,g.publicToAddress)(n.publicKey)))}async exportAccount(e,t){const n=t?p(this,r,"m",d).call(this,e,t):p(this,r,"m",d).call(this,e),{privateKey:s}=n;return(0,w.assert)(s instanceof Uint8Array,"Expected private key to be of type Uint8Array"),(0,w.remove0x)((0,w.bytesToHex)(s))}async signTransaction(e,n,s={}){const o=p(this,r,"m",m).call(this,e,s);return n.sign(t.from(o))??n}async signMessage(e,n,s={}){(0,w.assertIsHexString)(n);const o=(0,w.remove0x)(n),a=p(this,r,"m",m).call(this,e,s),i=(0,g.ecsign)(t.from(o,"hex"),t.from(a));return(0,y.concatSig)(t.from((0,w.bigIntToBytes)(i.v)),t.from(i.r),t.from(i.s))}async signPersonalMessage(e,n,s={}){const o=p(this,r,"m",m).call(this,e,s),a=t.from(o);return(0,y.personalSign)({privateKey:a,data:n})}async decryptMessage(e,n){const s=p(this,r,"m",d).call(this,e),{privateKey:o}=s;(0,w.assert)(o,"Expected private key to be set");const a=t.from(o).toString("hex");return(0,y.decrypt)({privateKey:a,encryptedData:n})}async signTypedData(e,n,s){let{version:o}=s??{version:y.SignTypedDataVersion.V1};o&&Object.keys(y.SignTypedDataVersion).includes(o)||(o=y.SignTypedDataVersion.V1);const a=p(this,r,"m",m).call(this,e,s);return(0,y.signTypedData)({privateKey:t.from(a),data:n,version:o})}async signEip7702Authorization(e,n,s){const o=p(this,r,"m",m).call(this,e,s);return(0,y.signEIP7702Authorization)({privateKey:t.from(o),authorization:n})}removeAccount(e){const t=p(this,r,"m",h).call(this,e);if(!p(this,s,"f").has(t))throw new Error(`Address ${t} not found in this keyring`);p(this,s,"f").delete(t)}async getEncryptionPublicKey(e,t={}){const n=p(this,r,"m",m).call(this,e,t);return(0,y.getEncryptionPublicKey)((0,w.remove0x)((0,w.bytesToHex)(n)))}}n.HdKeyring=T,s=new WeakMap,o=new WeakMap,r=new WeakSet,a=function(e){return Array.from(new Uint16Array(new Uint8Array(e).buffer)).map(e=>x.wordlist[e]).join(" ")},i=function(e){const t=e.split(" ").map(e=>x.wordlist.indexOf(e));return new Uint8Array(new Uint16Array(t).buffer)},c=function(e){let n=e;var s;if("object"==typeof(s=e)&&null!==s&&"type"in s&&"Buffer"===s.type&&"data"in s&&Array.isArray(s.data)&&(n=e.data),"string"==typeof n||t.isBuffer(n)||Array.isArray(n)){let e;return e=Array.isArray(n)?t.from(n).toString():t.isBuffer(n)?n.toString():n,p(this,r,"m",i).call(this,e)}return n instanceof Object&&!(n instanceof Uint8Array)?Uint8Array.from(Object.values(n)):((0,w.assert)(n instanceof Uint8Array,"Expected Uint8Array mnemonic"),n)},m=function(e,t){if(!e)throw new Error("Must specify address.");const n=p(this,r,"m",d).call(this,e,t);return(0,w.assert)(n.privateKey,"Missing private key"),n.privateKey},d=function(e,{withAppKeyOrigin:n}={}){const o=p(this,r,"m",h).call(this,e),a=p(this,s,"f").get(o);if(!a)throw new Error("HD Keyring - Unable to find matching address.");if(n){const{privateKey:e}=a.hdKey;(0,w.assert)(e,"Expected private key to be set");const r=t.from(n,"utf8"),s=t.concat([e,r]),o=t.from((0,v.keccak256)(s));return{privateKey:o,publicKey:t.from((0,g.privateToPublic)(o))}}return a.hdKey},u=async function(e){if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");this.mnemonic=p(this,r,"m",c).call(this,e),this.seed=await(0,k.mnemonicToSeed)(this.mnemonic,"",p(this,o,"f")),this.hdWallet=_.HDKey.fromMasterSeed(this.seed),this.root=this.hdWallet.derive(this.hdPath)},l=function(e){return(0,w.add0x)((0,w.bytesToHex)((0,g.publicToAddress)(t.from(e),!0)).toLowerCase())},h=function(e){const t=(0,y.normalize)(e);return(0,w.assert)(t,"Expected address to be set"),(0,w.add0x)(t)},T.type=j}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/index.cjs",{"./hd-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;var r=e("./hd-keyring.cjs");Object.defineProperty(n,"HdKeyring",{enumerable:!0,get:function(){return r.HdKeyring}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js",{"./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js","./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createInfuraMiddlewareWithoutRpcService=n.createInfuraMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),s=e("@metamask/rpc-errors"),o=e("./fetch-config-from-req"),a=e("./logging-utils"),i=(0,a.createModuleLogger)(a.projectLogger,"create-infura-middleware"),c=["Gateway timeout","ETIMEDOUT","ECONNRESET","SyntaxError"];function m({network:e="mainnet",maxAttempts:t=5,source:n,projectId:s,headers:o={}}){if(!s||"string"!=typeof s)throw new Error(`Invalid value for 'projectId': "${s}"`);if(!o||"object"!=typeof o)throw new Error(`Invalid value for 'headers': "${o}"`);if(!t)throw new Error(`Invalid value for 'maxAttempts': "${t}" (${typeof t})`);return(0,r.createAsyncMiddleware)(async(r,a)=>{for(let c=1;c<=t;c++)try{i("Attempting request to Infura. network = %o, projectId = %s, headers = %o, req = %o",e,s,o,r),await d(e,s,o,r,a,n);break}catch(e){if(!l(e))throw i("Non-retriable request error encountered. req = %o, res = %o, error = %o",r,a,e),e;if(!(t-c)){i("Retriable request error encountered, but exceeded max attempts. req = %o, res = %o, error = %o",r,a,e);const t=`InfuraProvider - cannot complete request. All retries exhausted.\nOriginal Error:\n${e.toString()}\n\n`;throw new Error(t)}i("Retriable request error encountered. req = %o, res = %o, error = %o",r,a,e),i("Waiting 1 second to try again..."),await h(1e3)}})}async function d(e,t,n,r,a,i){const{fetchUrl:c,fetchParams:m}=(0,o.fetchConfigFromReq)({network:e,projectId:t,extraHeaders:n,req:r,source:i}),d=await fetch(c,m),l=await d.text();if(!d.ok)switch(d.status){case 405:throw s.rpcErrors.methodNotFound();case 429:throw u("Request is being rate limited.");case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",u(e)}();default:throw u(l)}if("eth_getBlockByNumber"===r.method&&"Not Found"===l)return void(a.result=null);const h=JSON.parse(l);a.result=h.result,a.error=h.error}function u(e){return s.rpcErrors.internal(e)}function l(e){const t=e.toString();return c.some(e=>t.includes(e))}async function h(e){return new Promise(t=>{setTimeout(t,e)})}n.createInfuraMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){const{source:n,headers:s={}}=t;return(0,r.createAsyncMiddleware)(async(t,r)=>{const o=n!==undefined&&t.origin!==undefined?Object.assign(Object.assign({},s),{"Infura-Source":`${n}/${t.origin}`}):s,a=await e.request({id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},{headers:o});"error"in a?r.error=a.error:(r.result=a.result,r.error=undefined)})}(e):m(e)},n.createInfuraMiddlewareWithoutRpcService=m}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","@metamask/eth-json-rpc-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createProvider=void 0;const r=e("@metamask/eth-json-rpc-provider"),s=e("@metamask/json-rpc-engine"),o=e("./create-infura-middleware");n.createProvider=function(e){const t=new s.JsonRpcEngine;return t.push((0,o.createInfuraMiddleware)(e)),(0,r.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return{id:e.id,jsonrpc:e.jsonrpc,method:e.method,params:e.params}}Object.defineProperty(n,"__esModule",{value:!0}),n.fetchConfigFromReq=void 0,n.fetchConfigFromReq=function({network:e,projectId:t,extraHeaders:n={},req:s,source:o}){const a=s.origin||"internal",i=Object.assign({},n,{Accept:"application/json","Content-Type":"application/json"});return o&&(i["Infura-Source"]=`${o}/${a}`),{fetchUrl:`https://${e}.infura.io/v3/${t}`,fetchParams:{method:"POST",headers:i,body:JSON.stringify(r(s))}}}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/index.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","./create-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js","./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./create-infura-middleware"),n),s(e("./fetch-config-from-req"),n),s(e("./create-provider"),n)}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("eth-json-rpc-infura")}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs",{"./provider-from-engine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs","./provider-from-middleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs","./safe-event-emitter-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.SafeEventEmitterProvider=void 0,s(e("./provider-from-engine.cjs"),n),s(e("./provider-from-middleware.cjs"),n);var o=e("./safe-event-emitter-provider.cjs");Object.defineProperty(n,"SafeEventEmitterProvider",{enumerable:!0,get:function(){return o.SafeEventEmitterProvider}})}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs",{"./safe-event-emitter-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerFromEngine=void 0;const r=e("./safe-event-emitter-provider.cjs");n.providerFromEngine=function(e){return new r.SafeEventEmitterProvider({engine:e})}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs",{"./provider-from-engine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerFromMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),s=e("./provider-from-engine.cjs");n.providerFromMiddleware=function(e){const t=new r.JsonRpcEngine;return t.push(e),(0,s.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.SafeEventEmitterProvider=n.convertEip1193RequestToJsonRpcRequest=void 0;const i=e("@metamask/rpc-errors"),c=a(e("@metamask/safe-event-emitter")),m=e("uuid");function d(e){const{id:t=(0,m.v4)(),jsonrpc:n="2.0",method:r,params:s}=e;return s?{id:t,jsonrpc:n,method:r,params:s}:{id:t,jsonrpc:n,method:r}}n.convertEip1193RequestToJsonRpcRequest=d;class u extends c.default{constructor({engine:e}){super(),r.set(this,void 0),this.sendAsync=(e,t)=>{const n=d(e);o(this,r,"f").handle(n,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const n=d(e);o(this,r,"f").handle(n,t)},s(this,r,e,"f")}async request(e){const t=d(e),n=await o(this,r,"f").handle(t);if("result"in n)return n.result;const s=new i.JsonRpcError(n.error.code,n.error.message,n.error.data);throw"stack"in n.error&&(s.stack=n.error.stack),s}}n.SafeEventEmitterProvider=u,r=new WeakMap}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura>@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-infura/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockCacheMiddleware=void 0;const a=e("./logging-utils.cjs"),i=e("./utils/cache.cjs"),c=(0,a.createModuleLogger)(a.projectLogger,"block-cache"),m=[undefined,null,"<nil>"];class d{constructor(){r.set(this,void 0),s(this,r,{},"f")}getBlockCache(e){const t=Number.parseInt(e,16);let n=o(this,r,"f")[t];if(!n){const e={};o(this,r,"f")[t]=e,n=e}return n}async get(e,t){const n=this.getBlockCache(t),r=(0,i.cacheIdentifierForRequest)(e,!0);return r?n[r]:undefined}async set(e,t,n){if(!this.canCacheResult(e,n))return;const r=(0,i.cacheIdentifierForRequest)(e,!0);if(!r)return;this.getBlockCache(t)[r]=n}canCacheRequest(e){if(!(0,i.canCache)(e.method))return!1;return"pending"!==(0,i.blockTagForRequest)(e)}canCacheResult(e,t){return!m.includes(t)&&!(e.method&&["eth_getTransactionByHash","eth_getTransactionReceipt"].includes(e.method)&&(!t?.blockHash||"0x0000000000000000000000000000000000000000000000000000000000000000"===t.blockHash))}clearBefore(e){const t=Number.parseInt(e,16);Object.keys(o(this,r,"f")).map(Number).filter(e=>e<t).forEach(e=>delete o(this,r,"f")[e])}}r=new WeakMap,n.createBlockCacheMiddleware=function({blockTracker:e}={}){if(!e)throw new Error("createBlockCacheMiddleware - No PollingBlockTracker specified");const t=new d,n={[i.CacheStrategy.Permanent]:t,[i.CacheStrategy.Block]:t,[i.CacheStrategy.Fork]:t,[i.CacheStrategy.Never]:undefined};return async({request:r,next:s,context:o})=>{if(o.get("skipCache"))return s();const a=(0,i.cacheTypeForMethod)(r.method),m=n[a];if(!m)return s();if(!m.canCacheRequest(r))return s();const d=(0,i.blockTagForRequest)(r),u=d&&"string"==typeof d?d:"latest";let l;if(c("blockTag = %o, req = %o",u,r),"earliest"===u)l="0x00";else if("latest"===u){c("Fetching latest block number to determine cache key");const n=await e.getLatestBlock();c("Clearing values stored under block numbers before %o",n),t.clearBefore(n),l=n}else l=u;const h=await m.get(r,l);if(h===undefined){c("No cache stored under block number %o, carrying request forward",l);const e=await s();return c("Populating cache with",e),await m.set(r,l,e),e}return c("Cache hit, reusing cache result stored under block number %o",l),h}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.cjs",{"./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockRefRewriteMiddleware=void 0;const r=e("./utils/cache.cjs");n.createBlockRefRewriteMiddleware=function({blockTracker:e}={}){if(!e)throw Error('BlockRefRewriteMiddleware - mandatory "blockTracker" option is missing.');return async({request:t,next:n})=>{const s=(0,r.blockTagParamIndex)(t.method);if(s===undefined)return n();if("latest"!==(Array.isArray(t.params)&&t.params[s]?t.params[s]:"latest"))return n();const o=await e.getLatestBlock();if(Array.isArray(t.params)){const e=t.params.slice();return e[s]=o,n({...t,params:e})}return n()}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs",klona:"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockRefMiddleware=void 0;const r=e("klona"),s=e("./logging-utils.cjs"),o=e("./utils/cache.cjs"),a=(0,s.createModuleLogger)(s.projectLogger,"block-ref");n.createBlockRefMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('BlockRefMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('BlockRefMiddleware - mandatory "blockTracker" option is missing.');return async({request:n,next:s})=>{const i=(0,o.blockTagParamIndex)(n.method);if(i===undefined)return s();if("latest"!==(Array.isArray(n.params)?n.params[i]??"latest":"latest"))return a('blockRef is not "latest", carrying request forward'),s();const c=await t.getLatestBlock();a(`blockRef is "latest", setting param ${i} to latest block ${c}`);const m=(0,r.klona)(n);return Array.isArray(m.params)&&(m.params[i]=c),a("Performing another request %o",m),await e.request(m)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockTrackerInspectorMiddleware=void 0;const r=e("@metamask/utils"),s=e("./logging-utils.cjs"),o=(0,s.createModuleLogger)(s.projectLogger,"block-tracker-inspector"),a=["eth_getTransactionByHash","eth_getTransactionReceipt"];n.createBlockTrackerInspectorMiddleware=function({blockTracker:e}){return async({request:t,next:n})=>{if(!a.includes(t.method))return n();const s=await n(),i=function(e){if(!e||"object"!=typeof e||!(0,r.hasProperty)(e,"blockNumber"))return undefined;return"string"==typeof e.blockNumber?e.blockNumber:undefined}(s);if(i){o("res.result.blockNumber exists, proceeding. res = %o",s);Number.parseInt(i,16)>Number.parseInt(e.getCurrentBlock(),16)&&(o("blockNumber from response is greater than current block number, refreshing current block number"),await e.checkForLatestBlock())}return s}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createFetchMiddleware=void 0;const r=e("@metamask/rpc-errors");n.createFetchMiddleware=function({rpcService:e,options:t={}}){return async({request:n,context:s})=>{const o=s.get("origin"),a=t.originHttpHeaderKey!==undefined&&o!==undefined?{[t.originHttpHeaderKey]:o}:{},i=await e.request(n,{headers:a});if("error"in i)throw r.rpcErrors.internal({data:i.error});return i.result}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/index.cjs",{"./block-cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.cjs","./block-ref-rewrite.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.cjs","./block-ref.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.cjs","./block-tracker-inspector.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.cjs","./fetch.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.cjs","./inflight-cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.cjs","./providerAsMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.cjs","./retryOnEmpty.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.cjs","./wallet.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.createFetchMiddleware=void 0,s(e("./block-cache.cjs"),n),s(e("./block-ref-rewrite.cjs"),n),s(e("./block-ref.cjs"),n),s(e("./block-tracker-inspector.cjs"),n);var o=e("./fetch.cjs");Object.defineProperty(n,"createFetchMiddleware",{enumerable:!0,get:function(){return o.createFetchMiddleware}}),s(e("./inflight-cache.cjs"),n),s(e("./providerAsMiddleware.cjs"),n),s(e("./retryOnEmpty.cjs"),n),s(e("./wallet.cjs"),n)}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createInflightCacheMiddleware=void 0;const r=e("@metamask/utils"),s=e("./logging-utils.cjs"),o=e("./utils/cache.cjs"),a=(0,s.createModuleLogger)(s.projectLogger,"inflight-cache");function i(e,t){setTimeout(()=>{t.forEach(([t,n])=>{"result"in e?t(e.result):n(e.error)})})}n.createInflightCacheMiddleware=function(){const e={};return async({request:t,context:n,next:s})=>{if(n.get("skipCache"))return s();const c=(0,o.cacheIdentifierForRequest)(t);if(!c)return a("Request is not cacheable, proceeding. req = %o",t),s();let m=e[c];if(m)return a("Running %i handler(s) for request %o",m.length,t),await function(e){const{resolve:t,promise:n,reject:s}=(0,r.createDeferredPromise)();return e.push([e=>t(e),e=>s(e)]),n}(m);m=[],e[c]=m,a("Carrying original request forward %o",t);try{const e=await s();return a("Running %i collected handler(s) for successful request %o",m.length,t),i({result:e},m),e}catch(e){throw a("Running %i collected handler(s) for failed request %o",m.length,t),i({error:e},m),e}finally{delete e[c]}}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("eth-json-rpc-middleware")}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-request-execution-permissions.cjs",{"../utils/validation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createWalletRequestExecutionPermissionsHandler=n.RequestExecutionPermissionsStruct=void 0;const r=e("@metamask/rpc-errors"),s=e("@metamask/superstruct"),o=e("@metamask/utils"),a=e("../utils/validation.cjs"),i=(0,s.object)({type:(0,s.string)(),isAdjustmentAllowed:(0,s.boolean)(),data:(0,s.record)((0,s.string)(),(0,s.unknown)())}),c=(0,s.object)({type:(0,s.string)(),isAdjustmentAllowed:(0,s.boolean)(),data:(0,s.record)((0,s.string)(),(0,s.unknown)())}),m=(0,s.object)({type:(0,s.literal)("account"),data:(0,s.object)({address:o.HexChecksumAddressStruct})}),d=(0,s.object)({chainId:o.StrictHexStruct,address:(0,s.optional)(o.HexChecksumAddressStruct),signer:m,permission:i,rules:(0,s.optional)((0,s.union)([(0,s.array)(c),(0,s.literal)(null)]))});n.RequestExecutionPermissionsStruct=(0,s.array)(d),n.createWalletRequestExecutionPermissionsHandler=function({processRequestExecutionPermissions:e}){return async({request:t})=>{if(!e)throw r.rpcErrors.methodNotSupported("wallet_requestExecutionPermissions - no middleware configured");const{params:s}=t;return(0,a.validateParams)(s,n.RequestExecutionPermissionsStruct),await e(s,t)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-request-execution-permissions.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-revoke-execution-permission.cjs",{"../utils/validation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createWalletRevokeExecutionPermissionHandler=n.RevokeExecutionPermissionRequestParamsStruct=n.RevokeExecutionPermissionResultStruct=void 0;const r=e("@metamask/rpc-errors"),s=e("@metamask/superstruct"),o=e("@metamask/utils"),a=e("../utils/validation.cjs");n.RevokeExecutionPermissionResultStruct=(0,s.object)({}),n.RevokeExecutionPermissionRequestParamsStruct=(0,s.object)({permissionContext:o.StrictHexStruct}),n.createWalletRevokeExecutionPermissionHandler=function({processRevokeExecutionPermission:e}){return async({request:t})=>{if(!e)throw r.rpcErrors.methodNotSupported("wallet_revokeExecutionPermission - no middleware configured");const{params:s}=t;return(0,a.validateParams)(s,n.RevokeExecutionPermissionRequestParamsStruct),await e(s,t)}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-revoke-execution-permission.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.cjs",{"@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerAsMiddlewareV2=n.providerAsMiddleware=void 0;const r=e("@metamask/json-rpc-engine");n.providerAsMiddleware=function(e){return(0,r.createAsyncMiddleware)(async(t,n)=>{n.result=await e.request(t)})},n.providerAsMiddlewareV2=function(e){return async({request:t})=>e.request(t)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs","./utils/error.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.cjs","./utils/timeout.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.cjs",klona:"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createRetryOnEmptyMiddleware=void 0;const r=e("klona"),s=e("./logging-utils.cjs"),o=e("./utils/cache.cjs"),a=e("./utils/error.cjs"),i=e("./utils/timeout.cjs"),c=(0,s.createModuleLogger)(s.projectLogger,"retry-on-empty"),m=[null,"<nil>"];n.createRetryOnEmptyMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('RetryOnEmptyMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('RetryOnEmptyMiddleware - mandatory "blockTracker" option is missing.');return async({request:n,next:s})=>{const d=(0,o.blockTagParamIndex)(n.method);if(d===undefined)return s();let u=Array.isArray(n.params)&&n.params[d]?n.params[d]:undefined;if(u===undefined&&(u="latest"),["latest","pending"].includes(u))return s();const l=Number.parseInt(u.slice(2),16);if(Number.isNaN(l))return s();const h=await t.getLatestBlock(),f=Number.parseInt(h.slice(2),16);if(l>f)return c("Requested block number %o is higher than latest block number %o, falling through to original request",l,f),s();c("Requested block number %o is not higher than latest block number %o, trying request until non-empty response is received",l,f);const p=(0,r.klona)(n),g=await async function(e,t){for(let n=0;n<e;n++)try{return await t()}catch(e){if((0,a.isExecutionRevertedError)(e))throw e;c("(call %i) Request failed, waiting 1s to retry again...",n+1),await(0,i.timeout)(1e3)}throw c("Retries exhausted"),new Error("RetryOnEmptyMiddleware - retries exhausted")}(10,async()=>{c("Performing request %o",p);const t=await e.request(p);c("Result is %o",t);if(m.includes(t))throw new Error(`RetryOnEmptyMiddleware - empty result "${JSON.stringify(t)}" for request "${JSON.stringify(p)}"`);return t});return c("Copying result %o",g),g}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs",{"safe-stable-stringify":"/home/runner/work/metamask-extension/metamask-extension/node_modules/safe-stable-stringify/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.cacheTypeForMethod=n.blockTagParamIndex=n.blockTagForRequest=n.canCache=n.cacheIdentifierForRequest=n.CacheStrategy=void 0;const r=(0,e("safe-stable-stringify").configure)({bigint:!1,circularValue:Error});var s;function o(e){return i(e)!==s.Never}function a(e){switch(e){case"eth_getStorageAt":return 2;case"eth_getBalance":case"eth_getCode":case"eth_getTransactionCount":case"eth_call":return 1;case"eth_getBlockByNumber":return 0;default:return undefined}}function i(e){switch(e){case"web3_clientVersion":case"web3_sha3":case"eth_protocolVersion":case"eth_getBlockTransactionCountByHash":case"eth_getUncleCountByBlockHash":case"eth_getCode":case"eth_getBlockByHash":case"eth_getTransactionByHash":case"eth_getTransactionByBlockHashAndIndex":case"eth_getTransactionReceipt":case"eth_getUncleByBlockHashAndIndex":case"eth_getCompilers":case"eth_compileLLL":case"eth_compileSolidity":case"eth_compileSerpent":case"shh_version":case"test_permaCache":return s.Permanent;case"eth_getBlockByNumber":case"eth_getBlockTransactionCountByNumber":case"eth_getUncleCountByBlockNumber":case"eth_getTransactionByBlockNumberAndIndex":case"eth_getUncleByBlockNumberAndIndex":case"test_forkCache":return s.Fork;case"eth_gasPrice":case"eth_blockNumber":case"eth_getBalance":case"eth_getStorageAt":case"eth_getTransactionCount":case"eth_call":case"eth_estimateGas":case"eth_getFilterLogs":case"eth_getLogs":case"test_blockCache":return s.Block;default:return s.Never}}!function(e){e.Block="block",e.Fork="fork",e.Never="never",e.Permanent="perma"}(s||(n.CacheStrategy=s={})),n.cacheIdentifierForRequest=function(e,t){const n=t?function(e){if(!e.params)return[];const t=a(e.method);if(t===undefined||!Array.isArray(e.params)||t>=e.params.length)return e.params;if("eth_getBlockByNumber"===e.method)return e.params.slice(1);return e.params.slice(0,t)}(e):e.params??[];return o(e.method)?`${e.method}:${r(n)}`:null},n.canCache=o,n.blockTagForRequest=function(e){if(!e.params)return undefined;const t=a(e.method);return t===undefined||!Array.isArray(e.params)||t>=e.params.length?undefined:e.params[t]},n.blockTagParamIndex=a,n.cacheTypeForMethod=i}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.stripArrayTypeIfPresent=void 0;n.stripArrayTypeIfPresent=e=>e?.match(/\S\[\d*\]$/u)?e.replace(/\[\d*\]$/gu,"").trim():e}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isExecutionRevertedError=void 0;const r=e("@metamask/rpc-errors"),s=e("@metamask/utils");n.isExecutionRevertedError=function(e){return(0,s.isJsonRpcError)(e)&&e.code===r.errorCodes.rpc.invalidInput&&"execution reverted"===e.message}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return"string"!=typeof e?e:JSON.parse(e)}function s(e){return e.startsWith("0X")?`0x${e.slice(2)}`:e}Object.defineProperty(n,"__esModule",{value:!0}),n.parseTypedMessage=n.normalizeTypedMessage=void 0,n.normalizeTypedMessage=function(e){let t;try{t=r(e)}catch{return e}const{verifyingContract:n}=t.domain??{};return n?JSON.stringify({...t,domain:{...t.domain,verifyingContract:s(n)}}):e},n.parseTypedMessage=r}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.timeout=void 0,n.timeout=async function(e){return new Promise(t=>setTimeout(t,e))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.resemblesAddress=n.validateParams=n.validateAndNormalizeKeyholder=void 0;const r=e("@metamask/rpc-errors"),s=e("@metamask/superstruct");function o(e){return 42===e.length}n.validateAndNormalizeKeyholder=async function(e,t,{getAccounts:n}){if("string"==typeof e&&e.length>0&&o(e)){const s=(await n(t.assertGet("origin"))).map(e=>e.toLowerCase()),o=e.toLowerCase();if(s.includes(o))return o;throw r.providerErrors.unauthorized()}throw r.rpcErrors.invalidParams({message:"Invalid parameters: must provide an Ethereum address."})},n.validateParams=function(e,t){const[n]=(0,s.validate)(e,t);if(n)throw r.rpcErrors.invalidParams(function(e,t){return`${t}\n\n${e.failures().map(e=>`${e.path.join(" > ")}${e.path.length?" - ":""}${e.message}`).join("\n")}`}(n,"Invalid params"))},n.resemblesAddress=o}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.cjs",{"./methods/wallet-request-execution-permissions.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-request-execution-permissions.cjs","./methods/wallet-revoke-execution-permission.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-revoke-execution-permission.cjs","./utils/common.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.cjs","./utils/normalize.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.cjs","./utils/validation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/json-rpc-engine/v2":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/v2.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.createWalletMiddleware=void 0;const a=o(e("@metamask/eth-sig-util")),i=e("@metamask/json-rpc-engine/v2"),c=e("@metamask/rpc-errors"),m=e("@metamask/utils"),d=e("./methods/wallet-request-execution-permissions.cjs"),u=e("./methods/wallet-revoke-execution-permission.cjs"),l=e("./utils/common.cjs"),h=e("./utils/normalize.cjs"),f=e("./utils/validation.cjs");function p(e){const{primaryType:t,types:n}=(0,h.parseTypedMessage)(e);if(!n)throw c.rpcErrors.invalidInput();if(!n[(0,l.stripArrayTypeIfPresent)(t)])throw c.rpcErrors.invalidInput()}function g(e){const{domain:{verifyingContract:t}={}}=(0,h.parseTypedMessage)(e);if(t&&"cosmos"!==t&&!(0,m.isValidHexAddress)(t))throw c.rpcErrors.invalidInput()}n.createWalletMiddleware=function({getAccounts:e,processDecryptMessage:t,processEncryptionPublicKey:n,processPersonalMessage:r,processTransaction:s,processSignTransaction:o,processTypedMessage:m,processTypedMessageV3:l,processTypedMessageV4:y,processRequestExecutionPermissions:k,processRevokeExecutionPermission:b}){if(!e)throw new Error("opts.getAccounts is required");return(0,i.createScaffoldMiddleware)({eth_accounts:async function({context:t}){return await e(t.assertGet("origin"))},eth_coinbase:async function({context:t}){return(await e(t.assertGet("origin")))[0]||null},eth_sendTransaction:async function({request:e,context:t}){if(!s)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const n=e.params[0],r={...n,from:await x(n?.from||"",t)};return await s(r,e,t)},eth_signTransaction:async function({request:e,context:t}){if(!o)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const n=e.params[0],r={...n,from:await x(n?.from||"",t)};return await o(r,e,t)},eth_signTypedData:async function({request:e,context:t}){if(!m)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const n=e.params,r=n[0],s=await x(n[1],t),o={...n[2]||{},from:s,data:r,signatureMethod:"eth_signTypedData",version:"V1"};return await m(o,e,t,"V1")},eth_signTypedData_v3:async function({request:e,context:t}){if(!l)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const n=e.params,r=await x(n[0],t),s=(0,h.normalizeTypedMessage)(n[1]);p(s),g(s);const o={data:s,from:r,version:"V3",signatureMethod:"eth_signTypedData_v3"};return await l(o,e,t,"V3")},eth_signTypedData_v4:async function({request:e,context:t}){if(!y)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const n=e.params,r=await x(n[0],t),s=(0,h.normalizeTypedMessage)(n[1]);p(s),g(s);const o={data:s,from:r,version:"V4",signatureMethod:"eth_signTypedData_v4"};return await y(o,e,t,"V4")},personal_sign:async function({request:e,context:t}){if(!r)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const n=e.params,s=n[0],o=n[1],a=n[2]||{};let i,m;(0,f.resemblesAddress)(s)&&!(0,f.resemblesAddress)(o)?(i=s,m=o):(m=s,i=o);i=await x(i,t);const d={...a,from:i,data:m,signatureMethod:"personal_sign"};return await r(d,e,t)},eth_getEncryptionPublicKey:async function({request:e,context:t}){if(!n)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params,s=await x(r[0],t);return await n(s,{id:e.id,origin:t.assertGet("origin"),securityAlertResponse:t.get("securityAlertResponse")})},eth_decrypt:async function({request:e,context:n}){if(!t)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params,s=r[0],o=await x(r[1],n),a={...r[2]||{},from:o,data:s};return await t(a,{id:e.id,origin:n.assertGet("origin"),securityAlertResponse:n.get("securityAlertResponse")})},personal_ecRecover:async function({request:e}){if(!(e.params&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const t=e.params,n=t[0],r=t[1];return a.recoverPersonalSignature({data:n,signature:r})},wallet_requestExecutionPermissions:(0,d.createWalletRequestExecutionPermissionsHandler)({processRequestExecutionPermissions:k}),wallet_revokeExecutionPermission:(0,u.createWalletRevokeExecutionPermissionHandler)({processRevokeExecutionPermission:b})});async function x(t,n){return(0,f.validateAndNormalizeKeyholder)(t,n,{getAccounts:e})}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs",{"./internal-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/internal-provider.cjs","./provider-from-middleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.SafeEventEmitterProvider=n.InternalProvider=void 0;const o=e("./internal-provider.cjs");Object.defineProperty(n,"InternalProvider",{enumerable:!0,get:function(){return o.InternalProvider}}),s(e("./provider-from-middleware.cjs"),n);const a=o.InternalProvider;n.SafeEventEmitterProvider=a}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/internal-provider.cjs",{"@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/json-rpc-engine/v2":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/v2.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.convertEip1193RequestToJsonRpcRequest=n.InternalProvider=void 0;const c=e("@metamask/json-rpc-engine"),m=e("@metamask/json-rpc-engine/v2"),d=e("nanoid");function u(e){const{id:t=(0,d.nanoid)(),jsonrpc:n="2.0",method:r,params:s}=e;return s?{id:t,jsonrpc:n,method:r,params:s}:{id:t,jsonrpc:n,method:r}}n.InternalProvider=class{constructor({engine:e}){r.set(this,void 0),this.sendAsync=(e,t)=>{const n=u(e);i(this,o,"f").call(this,n,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const n=u(e);i(this,o,"f").call(this,n,t)},s.set(this,async(e,t)=>{const{id:n,jsonrpc:s}=e;return{id:n,jsonrpc:s,result:await i(this,r,"f").handle(e,t)}}),o.set(this,(e,t)=>{i(this,s,"f").call(this,e).then(e=>t(null,e)).catch(e=>{t(e)})}),a(this,r,"push"in e?m.JsonRpcEngineV2.create({middleware:[(0,c.asV2Middleware)(e)]}):e,"f")}async request(e,t){const n=u(e);return(await i(this,s,"f").call(this,n,t)).result}},r=new WeakMap,s=new WeakMap,o=new WeakMap,n.convertEip1193RequestToJsonRpcRequest=u}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/internal-provider.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs",{"./internal-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/internal-provider.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/json-rpc-engine/v2":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/v2.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerFromMiddlewareV2=n.providerFromMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),s=e("@metamask/json-rpc-engine/v2"),o=e("./internal-provider.cjs");function a(e){return new o.InternalProvider({engine:s.JsonRpcEngineV2.create({middleware:[e]})})}n.providerFromMiddleware=function(e){return a((0,r.asV2Middleware)(e))},n.providerFromMiddlewareV2=a}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/device.cjs",{"./qr-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/cjs/index.js","@ethereumjs/tx":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/tx/dist/cjs/index.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@keystonehq/bc-ur-registry-eth":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",hdkey:"/home/runner/work/metamask-extension/metamask-extension/node_modules/hdkey/lib/hdkey.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r,s,o,a,i,c,m=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},d=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},u=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Device=n.DeviceMode=n.SUPPORTED_UR_TYPE=void 0;const l=e("@ethereumjs/rlp"),h=e("@ethereumjs/tx"),f=e("@ethereumjs/util"),p=e("@keystonehq/bc-ur-registry-eth"),g=e("@metamask/utils"),y=u(e("hdkey")),k=e("uuid"),b=e("./qr-keyring.cjs");var x;n.SUPPORTED_UR_TYPE={CRYPTO_HDKEY:"crypto-hdkey",CRYPTO_ACCOUNT:"crypto-account",ETH_SIGNATURE:"eth-signature"},function(e){e.HD="hd",e.ACCOUNT="account"}(x||(n.DeviceMode=x={}));function w(e){return e instanceof p.CryptoAccount?e.getMasterFingerprint()?.toString("hex"):e.getOrigin()?.getSourceFingerprint()?.toString("hex")}n.Device=class{constructor({requestScan:e,source:t}){r.add(this),s.set(this,void 0),o.set(this,void 0),m(this,s,e,"f"),m(this,o,"string"==typeof t||"cbor"in t?d(this,r,"m",a).call(this,t):t,"f")}addressFromIndex(e){if(d(this,o,"f").keyringMode===x.ACCOUNT){const t=Object.keys(d(this,o,"f").paths)[e];if(!t)throw new Error(`Address not found for index ${e}`);return(0,g.add0x)(t)}const n=`m/${d(this,o,"f").childrenPath.replace("*",e.toString())}`,r=y.default.fromExtendedKey(d(this,o,"f").xpub).derive(n),s=t.from((0,f.publicToAddress)(r.publicKey,!0)).toString("hex"),a=(0,g.getChecksumAddress)((0,g.add0x)(s));return d(this,o,"f").indexes[a]=e,a}pathFromAddress(e){const t=(0,g.getChecksumAddress)((0,g.add0x)(e));if(d(this,o,"f").keyringMode===x.ACCOUNT){const e=d(this,o,"f").paths[t];if(e===undefined)throw new Error(`Unknown address ${t}`);return e}let n=d(this,o,"f").indexes[t];if(n===undefined){for(let e=0;e<1e3;e++){if(this.addressFromIndex(e)===t){n=e;break}}if(n===undefined)throw new Error(`Unknown address ${t}`)}return`${d(this,o,"f").hdPath}/${d(this,o,"f").childrenPath.replace("*",n.toString()).replace(/\*/gu,"0")}`}getAddressesPage(e,t=5){const n=e*t,r=n+t,s=[];for(let e=n;e<r;e++){const t=this.addressFromIndex(e);s.push({address:t,index:e})}return s}getDeviceDetails(){return d(this,o,"f")}async signTransaction(e,n){const s=n.type===h.TransactionType.Legacy?p.DataType.transaction:p.DataType.typedTransaction,a=n.getMessageToSign(),c=t.from(Array.isArray(a)?l.RLP.encode(a):a),m=(0,k.v4)(),u=p.EthSignRequest.constructETHRequest(c,s,this.pathFromAddress(e),d(this,o,"f").xfp,m,Number(n.common.chainId())).toUR(),{r:f,s:g,v:y}=await d(this,r,"m",i).call(this,{requestId:m,payload:{type:u.type,cbor:u.cbor.toString("hex")},requestTitle:"Scan with your hardware wallet",requestDescription:'After your device has signed this message, click on "Scan" to receive the signature'});return h.TransactionFactory.fromTxData({...n.toJSON(),r:f,s:g,v:y},{common:n.common})}async signTypedData(e,n){const s=(0,k.v4)(),a=p.EthSignRequest.constructETHRequest(t.from(JSON.stringify(n),"utf8"),p.DataType.typedData,this.pathFromAddress(e),d(this,o,"f").xfp,s,undefined,e).toUR(),{r:c,s:m,v:u}=await d(this,r,"m",i).call(this,{requestId:s,payload:{type:a.type,cbor:a.cbor.toString("hex")}});return(0,g.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(m),Uint8Array.from(u)]).toString("hex"))}async signPersonalMessage(e,n){const s=(0,k.v4)(),a=p.EthSignRequest.constructETHRequest(t.from((0,g.remove0x)(n),"hex"),p.DataType.personalMessage,this.pathFromAddress(e),d(this,o,"f").xfp,s,undefined,e).toUR(),{r:c,s:m,v:u}=await d(this,r,"m",i).call(this,{requestId:s,payload:{type:a.type,cbor:a.cbor.toString("hex")}});return(0,g.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(m),Uint8Array.from(u)]).toString("hex"))}},s=new WeakMap,o=new WeakMap,r=new WeakSet,a=function(e){const n=d(this,r,"m",c).call(this,e),s=w(n);if(n instanceof p.CryptoAccount){const{name:e,xfp:r,paths:s,keyringAccount:o}=function(e){const n=e.getOutputDescriptors();if(!n||0===n.length)throw new Error("No output descriptors found in CryptoAccount");let r="",s="";return{paths:n.reduce((e,n)=>{const o=n.getHDKey();if(o){const n=`M/${o.getOrigin().getPath()}`;e[(0,g.getChecksumAddress)((0,g.add0x)(t.from((0,f.publicToAddress)(o.getKey(),!0)).toString("hex")))]=n,r=o.getName(),s=o.getNote()}return e},{}),name:r,keyringAccount:s,xfp:w(e)}}(n);return{keyringMode:x.ACCOUNT,keyringAccount:o,name:e,xfp:r,paths:s,indexes:{}}}const{getBip32Key:o,getOrigin:a,getChildren:i,getName:m,getNote:u}=n;return{keyringMode:x.HD,keyringAccount:u(),name:m(),xfp:s,hdPath:`m/${a().getPath()}`,childrenPath:i()?.getPath()||"0/*",xpub:o(),indexes:{}}},i=async function(e){const n=await d(this,s,"f").call(this,{type:b.QrScanRequestType.SIGN,request:e}),r=p.ETHSignature.fromCBOR(t.from(n.cbor,"hex")),o=r.getSignature(),a=r.getRequestId();if(!a)throw new Error("Signature request ID is missing.");if(e.requestId!==(0,k.stringify)(a))throw new Error(`Signature request ID mismatch. Expected: ${e.requestId}, received: ${a.toString("hex")}`);return{r:o.subarray(0,32),s:o.subarray(32,64),v:o.subarray(64)}},c=function(e){const r="string"==typeof e?p.URRegistryDecoder.decode(e):{type:e.type,cbor:t.from(e.cbor,"hex")},{type:s,cbor:o}=r;switch(s){case n.SUPPORTED_UR_TYPE.CRYPTO_HDKEY:return p.CryptoHDKey.fromCBOR(o);case n.SUPPORTED_UR_TYPE.CRYPTO_ACCOUNT:return p.CryptoAccount.fromCBOR(o);default:throw new Error("Unsupported UR type")}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/device.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/index.cjs",{"./qr-keyring-deferred-promise-bridge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs","./qr-keyring-scanner-bridge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs","./qr-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.QrScanRequestType=n.QR_KEYRING_TYPE=n.QrKeyring=n.QrKeyringDeferredPromiseBridge=n.QrKeyringScannerBridge=void 0;var r=e("./qr-keyring-scanner-bridge.cjs");Object.defineProperty(n,"QrKeyringScannerBridge",{enumerable:!0,get:function(){return r.QrKeyringScannerBridge}});var s=e("./qr-keyring-deferred-promise-bridge.cjs");Object.defineProperty(n,"QrKeyringDeferredPromiseBridge",{enumerable:!0,get:function(){return s.QrKeyringDeferredPromiseBridge}});var o=e("./qr-keyring.cjs");Object.defineProperty(n,"QrKeyring",{enumerable:!0,get:function(){return o.QrKeyring}}),Object.defineProperty(n,"QR_KEYRING_TYPE",{enumerable:!0,get:function(){return o.QR_KEYRING_TYPE}}),Object.defineProperty(n,"QrScanRequestType",{enumerable:!0,get:function(){return o.QrScanRequestType}})}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","async-mutex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/async-mutex/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i,c=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},m=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyringDeferredPromiseBridge=void 0;const d=e("@metamask/utils"),u=e("async-mutex");n.QrKeyringDeferredPromiseBridge=class{constructor({onScanRequested:e,onScanResolved:t,onScanRejected:n}={}){r.set(this,new u.Mutex),s.set(this,void 0),o.set(this,void 0),a.set(this,void 0),i.set(this,void 0),c(this,s,e,"f"),c(this,o,t,"f"),c(this,a,n,"f")}async requestScan(e){return m(this,r,"f").runExclusive(async()=>{const t=(0,d.createDeferredPromise)();return c(this,i,t,"f"),m(this,s,"f")?.call(this,e),t.promise})}resolvePendingScan(e){if(!m(this,i,"f"))throw new Error("No pending scan to resolve.");m(this,i,"f").resolve(e),c(this,i,null,"f"),m(this,o,"f")?.call(this,e)}rejectPendingScan(e){if(!m(this,i,"f"))throw new Error("No pending scan to reject.");m(this,i,"f").reject(e),c(this,i,null,"f"),m(this,a,"f")?.call(this,e)}},r=new WeakMap,s=new WeakMap,o=new WeakMap,a=new WeakMap,i=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyringScannerBridge=void 0;n.QrKeyringScannerBridge=class{constructor({requestScan:e}){r.set(this,void 0),s(this,r,e,"f")}async requestScan(e){return o(this,r,"f").call(this,e)}},r=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs",{"./device.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/device.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i,c,m=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},d=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyring=n.getDefaultSerializedQrKeyringState=n.QrScanRequestType=n.QR_KEYRING_TYPE=void 0;const u=e("@metamask/utils"),l=e("./device.cjs");var h;n.QR_KEYRING_TYPE="QR Hardware Wallet Device",function(e){e.PAIR="pair",e.SIGN="sign"}(h||(n.QrScanRequestType=h={}));function f(e){return(0,u.getChecksumAddress)((0,u.add0x)(e))}n.getDefaultSerializedQrKeyringState=()=>({initialized:!1,accounts:[]});class p{constructor(e){r.add(this),this.type=n.QR_KEYRING_TYPE,s.set(this,void 0),o.set(this,[]),a.set(this,void 0),i.set(this,0),this.bridge=e.bridge,e?.ur&&this.pairDevice(e.ur)}async serialize(){const e=m(this,s,"f")?m(this,s,"f").getDeviceDetails():undefined;return e&&[l.DeviceMode.HD,l.DeviceMode.ACCOUNT].includes(e.keyringMode)?{...e,initialized:!0,accounts:m(this,o,"f").slice()}:(0,n.getDefaultSerializedQrKeyringState)()}async deserialize(e){if(!e.initialized)return d(this,o,[],"f"),void d(this,s,undefined,"f");d(this,s,new l.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f"),d(this,o,(e.accounts??[]).map(f),"f")}async addAccounts(e){if(!m(this,s,"f"))throw new Error("No device paired.");const t=[];for(let n=0;n<e;n++){const e=m(this,a,"f")??m(this,o,"f").length+n,r=m(this,s,"f").addressFromIndex(e);this.setAccountToUnlock(e+1),m(this,o,"f").includes(r)||(m(this,o,"f").push(r),t.push(r))}return t}async getAccounts(){return m(this,o,"f").slice()}removeAccount(e){const t=f(e);d(this,o,m(this,o,"f").filter(e=>e!==t),"f")}pairDevice(e){d(this,s,new l.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f")}setAccountToUnlock(e){d(this,a,e,"f")}getName(){if(!m(this,s,"f"))return n.QR_KEYRING_TYPE;return m(this,s,"f").getDeviceDetails().name}async getFirstPage(){return d(this,i,0,"f"),this.getCurrentPage()}async getNextPage(){return d(this,i,m(this,i,"f")+1,"f"),this.getCurrentPage()}async getPreviousPage(){return m(this,i,"f")>0?d(this,i,m(this,i,"f")-1,"f"):d(this,i,0,"f"),this.getCurrentPage()}async getCurrentPage(){return m(this,s,"f")||await m(this,r,"m",c).call(this),(0,u.assert)(m(this,s,"f"),"A device is expected to be paired before fetching accounts."),m(this,s,"f").getAddressesPage(m(this,i,"f"))}async forgetDevice(){d(this,s,undefined,"f"),d(this,o,[],"f"),d(this,a,undefined,"f"),d(this,i,0,"f")}async signTransaction(e,t){if(!m(this,s,"f"))throw new Error("No device paired.");return m(this,s,"f").signTransaction(e,t)}async signTypedData(e,t){if(!m(this,s,"f"))throw new Error("No device paired.");return m(this,s,"f").signTypedData(e,t)}async signPersonalMessage(e,t){if(!m(this,s,"f"))throw new Error("No device paired.");return m(this,s,"f").signPersonalMessage(e,t)}}n.QrKeyring=p,s=new WeakMap,o=new WeakMap,a=new WeakMap,i=new WeakMap,r=new WeakSet,c=async function(){this.pairDevice(await this.bridge.requestScan({type:h.PAIR}))},p.type=n.QR_KEYRING_TYPE}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.development.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js","@keystonehq/bc-ur-registry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",hdkey:"/home/runner/work/metamask-extension/metamask-extension/node_modules/hdkey/lib/hdkey.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0});var r,s=e("@keystonehq/bc-ur-registry"),o=e("uuid"),a=(r=e("hdkey"))&&"object"==typeof r&&"default"in r?r.default:r,i=e("@ethereumjs/util");const c={ETH_SIGN_REQUEST:new s.RegistryType("eth-sign-request",401),ETH_SIGNATURE:new s.RegistryType("eth-signature",402),ETH_NFT_ITEM:new s.RegistryType("eth-nft-item",403)},{decodeToDataItem:m,RegistryTypes:d}=s.extend;var u,l;!function(e){e[e.requestId=1]="requestId",e[e.signData=2]="signData",e[e.dataType=3]="dataType",e[e.chainId=4]="chainId",e[e.derivationPath=5]="derivationPath",e[e.address=6]="address",e[e.origin=7]="origin"}(u||(u={})),(l=n.DataType||(n.DataType={}))[l.transaction=1]="transaction",l[l.typedData=2]="typedData",l[l.personalMessage=3]="personalMessage",l[l.typedTransaction=4]="typedTransaction";class h extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_SIGN_REQUEST,this.getRequestId=()=>this.requestId,this.getSignData=()=>this.signData,this.getDataType=()=>this.dataType,this.getChainId=()=>this.chainId,this.getDerivationPath=()=>this.derivationPath.getPath(),this.getSourceFingerprint=()=>this.derivationPath.getSourceFingerprint(),this.getSignRequestAddress=()=>this.address,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};this.requestId&&(e[u.requestId]=new s.DataItem(this.requestId,d.UUID.getTag())),this.address&&(e[u.address]=this.address),this.chainId&&(e[u.chainId]=Number(this.chainId)),this.origin&&(e[u.origin]=this.origin),e[u.signData]=this.signData,e[u.dataType]=this.dataType;const t=this.derivationPath.toDataItem();return t.setTag(this.derivationPath.getRegistryType().getTag()),e[u.derivationPath]=t,new s.DataItem(e)},this.requestId=e.requestId,this.signData=e.signData,this.dataType=e.dataType,this.chainId=e.chainId,this.derivationPath=e.derivationPath,this.address=e.address,this.origin=e.origin}static constructETHRequest(e,n,r,a,i,c,m,d){const u=r.replace(/[m|M]\//,"").split("/"),l=new s.CryptoKeypath(u.map(e=>{const t=parseInt(e.replace("'",""));let n=!1;return e.endsWith("'")&&(n=!0),new s.PathComponent({index:t,hardened:n})}),t.from(a,"hex"));return new h({requestId:i?t.from(o.parse(i)):undefined,signData:e,dataType:n,derivationPath:l,chainId:c,address:m?t.from(m.replace("0x",""),"hex"):undefined,origin:d||undefined})}}h.fromDataItem=e=>{const t=e.getData(),n=t[u.signData],r=t[u.dataType],o=s.CryptoKeypath.fromDataItem(t[u.derivationPath]),a=t[u.chainId]?t[u.chainId]:undefined,i=t[u.address]?t[u.address]:undefined,c=t[u.requestId]?t[u.requestId].getData():undefined,m=t[u.origin]?t[u.origin]:undefined;return new h({requestId:c,signData:n,dataType:r,chainId:a,derivationPath:o,address:i,origin:m})},h.fromCBOR=e=>{const t=m(e);return h.fromDataItem(t)};const{RegistryTypes:f,decodeToDataItem:p}=s.extend;var g;!function(e){e[e.requestId=1]="requestId",e[e.signature=2]="signature",e[e.origin=3]="origin"}(g||(g={}));class y extends s.RegistryItem{constructor(e,t,n){super(),this.getRegistryType=()=>c.ETH_SIGNATURE,this.getRequestId=()=>this.requestId,this.getSignature=()=>this.signature,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};return this.requestId&&(e[g.requestId]=new s.DataItem(this.requestId,f.UUID.getTag())),this.origin&&(e[g.origin]=this.origin),e[g.signature]=this.signature,new s.DataItem(e)},this.signature=e,this.requestId=t,this.origin=n}}y.fromDataItem=e=>{const t=e.getData(),n=t[g.signature],r=t[g.requestId]?t[g.requestId].getData():undefined;return new y(n,r,t[g.origin])},y.fromCBOR=e=>{const t=p(e);return y.fromDataItem(t)};const{decodeToDataItem:k}=s.extend;var b;!function(e){e[e.chainId=1]="chainId",e[e.contractAddress=2]="contractAddress",e[e.contractName=3]="contractName",e[e.name=4]="name",e[e.mediaData=5]="mediaData"}(b||(b={}));class x extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_NFT_ITEM,this.getChainId=()=>this.chainId,this.getName=()=>this.name,this.getmediaData=()=>this.mediaData,this.getContractAddress=()=>this.contractAddress,this.getContractName=()=>this.contractName,this.toDataItem=()=>{const e={};return e[b.chainId]=this.chainId,e[b.name]=this.name,e[b.contractAddress]=this.contractAddress,e[b.contractName]=this.contractName,e[b.mediaData]=this.mediaData,new s.DataItem(e)},this.chainId=e.chainId,this.name=e.name,this.contractAddress=e.contractAddress,this.contractName=e.contractName,this.mediaData=e.mediaData}static constructETHNFTItem(e,t,n,r,s){return new x({chainId:e,contractAddress:t,contractName:n,mediaData:s,name:r})}}x.fromDataItem=e=>{const t=e.getData(),n=t[b.chainId],r=t[b.name],s=t[b.mediaData],o=t[b.contractAddress],a=t[b.contractName];return new x({chainId:n,name:r,contractAddress:o,contractName:a,mediaData:s})},x.fromCBOR=e=>{const t=k(e);return x.fromDataItem(t)};const w=(e,t)=>{const n=a.fromExtendedKey(e).derive(t),r="0x"+i.publicToAddress(n.publicKey,!0).toString("hex");return i.toChecksumAddress(r)};s.patchTags(Object.values(c).filter(e=>!!e.getTag()).map(e=>e.getTag())),Object.keys(s).forEach(function(e){"default"!==e&&Object.defineProperty(n,e,{enumerable:!0,get:function(){return s[e]}})}),n.ETHNFTItem=x,n.ETHSignature=y,n.EthSignRequest=h,n.findHDPathFromAddress=(e,t,n,r)=>{for(let s=0;s<n;s++){const n=w(t,`M/0/${s}`);if(e.toLowerCase()==n.toLowerCase())return`${r}/0/${s}`}return null},n.generateAddressFromXpub=w}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.development.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.production.min.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js","@keystonehq/bc-ur-registry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",hdkey:"/home/runner/work/metamask-extension/metamask-extension/node_modules/hdkey/lib/hdkey.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0});var r,s=e("@keystonehq/bc-ur-registry"),o=e("uuid"),a=(r=e("hdkey"))&&"object"==typeof r&&"default"in r?r.default:r,i=e("@ethereumjs/util");const c={ETH_SIGN_REQUEST:new s.RegistryType("eth-sign-request",401),ETH_SIGNATURE:new s.RegistryType("eth-signature",402),ETH_NFT_ITEM:new s.RegistryType("eth-nft-item",403)},{decodeToDataItem:m,RegistryTypes:d}=s.extend;var u,l;!function(e){e[e.requestId=1]="requestId",e[e.signData=2]="signData",e[e.dataType=3]="dataType",e[e.chainId=4]="chainId",e[e.derivationPath=5]="derivationPath",e[e.address=6]="address",e[e.origin=7]="origin"}(u||(u={})),(l=n.DataType||(n.DataType={}))[l.transaction=1]="transaction",l[l.typedData=2]="typedData",l[l.personalMessage=3]="personalMessage",l[l.typedTransaction=4]="typedTransaction";class h extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_SIGN_REQUEST,this.getRequestId=()=>this.requestId,this.getSignData=()=>this.signData,this.getDataType=()=>this.dataType,this.getChainId=()=>this.chainId,this.getDerivationPath=()=>this.derivationPath.getPath(),this.getSourceFingerprint=()=>this.derivationPath.getSourceFingerprint(),this.getSignRequestAddress=()=>this.address,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};this.requestId&&(e[u.requestId]=new s.DataItem(this.requestId,d.UUID.getTag())),this.address&&(e[u.address]=this.address),this.chainId&&(e[u.chainId]=Number(this.chainId)),this.origin&&(e[u.origin]=this.origin),e[u.signData]=this.signData,e[u.dataType]=this.dataType;const t=this.derivationPath.toDataItem();return t.setTag(this.derivationPath.getRegistryType().getTag()),e[u.derivationPath]=t,new s.DataItem(e)},this.requestId=e.requestId,this.signData=e.signData,this.dataType=e.dataType,this.chainId=e.chainId,this.derivationPath=e.derivationPath,this.address=e.address,this.origin=e.origin}static constructETHRequest(e,n,r,a,i,c,m,d){const u=r.replace(/[m|M]\//,"").split("/"),l=new s.CryptoKeypath(u.map(e=>{const t=parseInt(e.replace("'",""));let n=!1;return e.endsWith("'")&&(n=!0),new s.PathComponent({index:t,hardened:n})}),t.from(a,"hex"));return new h({requestId:i?t.from(o.parse(i)):void 0,signData:e,dataType:n,derivationPath:l,chainId:c,address:m?t.from(m.replace("0x",""),"hex"):void 0,origin:d||void 0})}}h.fromDataItem=e=>{const t=e.getData(),n=t[u.signData],r=t[u.dataType],o=s.CryptoKeypath.fromDataItem(t[u.derivationPath]),a=t[u.chainId]?t[u.chainId]:void 0,i=t[u.address]?t[u.address]:void 0,c=t[u.requestId]?t[u.requestId].getData():void 0;return new h({requestId:c,signData:n,dataType:r,chainId:a,derivationPath:o,address:i,origin:t[u.origin]?t[u.origin]:void 0})},h.fromCBOR=e=>{const t=m(e);return h.fromDataItem(t)};const{RegistryTypes:f,decodeToDataItem:p}=s.extend;var g;!function(e){e[e.requestId=1]="requestId",e[e.signature=2]="signature",e[e.origin=3]="origin"}(g||(g={}));class y extends s.RegistryItem{constructor(e,t,n){super(),this.getRegistryType=()=>c.ETH_SIGNATURE,this.getRequestId=()=>this.requestId,this.getSignature=()=>this.signature,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};return this.requestId&&(e[g.requestId]=new s.DataItem(this.requestId,f.UUID.getTag())),this.origin&&(e[g.origin]=this.origin),e[g.signature]=this.signature,new s.DataItem(e)},this.signature=e,this.requestId=t,this.origin=n}}y.fromDataItem=e=>{const t=e.getData(),n=t[g.signature],r=t[g.requestId]?t[g.requestId].getData():void 0;return new y(n,r,t[g.origin])},y.fromCBOR=e=>{const t=p(e);return y.fromDataItem(t)};const{decodeToDataItem:k}=s.extend;var b;!function(e){e[e.chainId=1]="chainId",e[e.contractAddress=2]="contractAddress",e[e.contractName=3]="contractName",e[e.name=4]="name",e[e.mediaData=5]="mediaData"}(b||(b={}));class x extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_NFT_ITEM,this.getChainId=()=>this.chainId,this.getName=()=>this.name,this.getmediaData=()=>this.mediaData,this.getContractAddress=()=>this.contractAddress,this.getContractName=()=>this.contractName,this.toDataItem=()=>{const e={};return e[b.chainId]=this.chainId,e[b.name]=this.name,e[b.contractAddress]=this.contractAddress,e[b.contractName]=this.contractName,e[b.mediaData]=this.mediaData,new s.DataItem(e)},this.chainId=e.chainId,this.name=e.name,this.contractAddress=e.contractAddress,this.contractName=e.contractName,this.mediaData=e.mediaData}static constructETHNFTItem(e,t,n,r,s){return new x({chainId:e,contractAddress:t,contractName:n,mediaData:s,name:r})}}x.fromDataItem=e=>{const t=e.getData();return new x({chainId:t[b.chainId],name:t[b.name],contractAddress:t[b.contractAddress],contractName:t[b.contractName],mediaData:t[b.mediaData]})},x.fromCBOR=e=>{const t=k(e);return x.fromDataItem(t)};const w=(e,t)=>{const n=a.fromExtendedKey(e).derive(t),r="0x"+i.publicToAddress(n.publicKey,!0).toString("hex");return i.toChecksumAddress(r)};s.patchTags(Object.values(c).filter(e=>!!e.getTag()).map(e=>e.getTag())),Object.keys(s).forEach(function(e){"default"!==e&&Object.defineProperty(n,e,{enumerable:!0,get:function(){return s[e]}})}),n.ETHNFTItem=x,n.ETHSignature=y,n.EthSignRequest=h,n.findHDPathFromAddress=(e,t,n,r)=>{for(let s=0;s<n;s++){const n=w(t,"M/0/"+s);if(e.toLowerCase()==n.toLowerCase())return`${r}/0/${s}`}return null},n.generateAddressFromXpub=w}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.production.min.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/index.js",{"./bc-ur-registry-eth.cjs.development.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.development.js","./bc-ur-registry-eth.cjs.production.min.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.production.min.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./bc-ur-registry-eth.cjs.production.min.js")}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/rlp/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(Array.isArray(e)){const t=[];let n=0;for(let s=0;s<e.length;s++){const o=r(e[s]);t.push(o),n+=o.length}return h(a(n,192),...t)}const t=y(e);return 1===t.length&&t[0]<128?t:h(a(t.length,128),t)}function s(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function o(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return u(d(e))}function a(e,t){if(e<56)return Uint8Array.from([e+t]);const n=p(e),r=p(t+55+n.length/2);return Uint8Array.from(l(r+n))}function i(e,t=!1){if(null==e||0===e.length)return Uint8Array.from([]);const n=c(y(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function c(e){let t,n,r,a,i;const m=[],d=e[0];if(d<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(d<=183){if(t=d-127,r=128===d?Uint8Array.from([]):s(e,1,t),2===t&&r[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:r,remainder:e.slice(t)}}if(d<=191){if(n=d-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=o(s(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return r=s(e,n,t+n),{data:r,remainder:e.slice(t+n)}}if(d<=247){for(t=d-191,a=s(e,1,t);a.length;)i=c(a),m.push(i.data),a=i.remainder;return{data:m,remainder:e.slice(t)}}{if(n=d-246,t=o(s(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const r=n+t;if(r>e.length)throw new Error("invalid RLP: total length is larger than the data");for(a=s(e,n,r);a.length;)i=c(a),m.push(i.data),a=i.remainder;return{data:m,remainder:e.slice(r)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.RLP=n.utils=n.decode=n.encode=void 0,n.encode=r,n.decode=i;const m=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function d(e){let t="";for(let n=0;n<e.length;n++)t+=m[e[n]];return t}function u(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function l(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const r=2*n;t[n]=u(e.slice(r,r+2))}return t}function h(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,r=0;t<e.length;t++){const s=e[t];n.set(s,r),r+=s.length}return n}function f(e){return(new TextEncoder).encode(e)}function p(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function g(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function y(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return g(e)?l((t="string"!=typeof(n=e)?n:g(n)?n.slice(2):n).length%2?`0${t}`:t):f(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?l(p(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:d,concatBytes:h,hexToBytes:l,utf8ToBytes:f},n.RLP={encode:r,decode:i}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util>@ethereumjs/rlp",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/rlp/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.accountBodyToRLP=n.accountBodyToSlim=n.accountBodyFromSlim=n.isZeroAddress=n.zeroAddress=n.importPublic=n.privateToAddress=n.privateToPublic=n.publicToAddress=n.pubToAddress=n.isValidPublic=n.isValidPrivate=n.generateAddress2=n.generateAddress=n.isValidChecksumAddress=n.toChecksumAddress=n.isValidAddress=n.Account=void 0;const r=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),o=e("ethereum-cryptography/secp256k1"),a=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),m=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,n=c.KECCAK256_RLP,r=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=n,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:n,storageRoot:r,codeHash:s}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,n!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(n)):undefined,r!==undefined?(0,i.toBuffer)(r):undefined,s!==undefined?(0,i.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,n,r,s]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(n),r,s)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(c.KECCAK256_NULL)}}n.Account=l;n.isValidAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};n.toChecksumAddress=function(e,n){(0,m.assertIsHexString)(e);const r=(0,d.stripHexPrefix)(e).toLowerCase();let o="";if(n!==undefined){o=(0,i.bufferToBigInt)((0,i.toBuffer)(n)).toString()+"0x"}const c=t.from(o+r,"utf8"),u=(0,a.bytesToHex)((0,s.keccak256)(c));let l="0x";for(let e=0;e<r.length;e++)parseInt(u[e],16)>=8?l+=r[e].toUpperCase():l+=r[e];return l};n.isValidChecksumAddress=function(e,t){return(0,n.isValidAddress)(e)&&(0,n.toChecksumAddress)(e,t)===e};n.generateAddress=function(e,n){return(0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,i.bufferToBigInt)(n)===BigInt(0)?t.from((0,s.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,n])))).slice(-20)};n.generateAddress2=function(e,n,r){if((0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,m.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==n.length)throw new Error("Expected salt to be of length 32");const o=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,n,(0,s.keccak256)(r)]));return(0,i.toBuffer)(o).slice(-20)};n.isValidPrivate=function(e){return o.secp256k1.utils.isValidPrivateKey(e)};n.isValidPublic=function(e,n=!1){if((0,m.assertIsBuffer)(e),64===e.length)try{return o.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!n)return!1;try{return o.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};n.pubToAddress=function(e,n=!1){if((0,m.assertIsBuffer)(e),n&&64!==e.length&&(e=t.from(o.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},n.publicToAddress=n.pubToAddress;n.privateToPublic=function(e){return(0,m.assertIsBuffer)(e),t.from(o.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};n.privateToAddress=function(e){return(0,n.publicToAddress)((0,n.privateToPublic)(e))};n.importPublic=function(e){return(0,m.assertIsBuffer)(e),64!==e.length&&(e=t.from(o.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};n.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function h(e){const[t,n,r,s]=e;return[t,n,0===(0,i.arrToBufArr)(r).length?c.KECCAK256_RLP:r,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}n.isZeroAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return(0,n.zeroAddress)()===e},n.accountBodyFromSlim=h;const f=new Uint8Array(0);n.accountBodyToSlim=function(e){const[t,n,r,s]=e;return[t,n,(0,i.arrToBufArr)(r).equals(c.KECCAK256_RLP)?f:r,(0,i.arrToBufArr)(s).equals(c.KECCAK256_NULL)?f:s]},n.accountBodyToRLP=function(e,t=!0){const n=t?h(e):e;return(0,i.arrToBufArr)(r.RLP.encode(n))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Address=void 0;const r=e("./account"),s=e("./bytes");class o{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new o((0,s.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new o((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const n=(0,r.pubToAddress)(e);return new o(n)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const n=(0,r.privateToAddress)(e);return new o(n)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new o((0,r.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,n,s){if(!t.isBuffer(n))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new o((0,r.generateAddress2)(e.buf,n,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(o.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),n=BigInt("0xffff");return e>=t&&e<=n}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}n.Address=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncEventEmitter=void 0;const r=e("events");class s extends r.EventEmitter{emit(e,...t){let[n,r]=t;const s=this;let o=s._events[e]??[];return r===undefined&&"function"==typeof n&&(r=n,n=undefined),"newListener"!==e&&"removeListener"!==e||(n={event:n,fn:r},r=undefined),o=Array.isArray(o)?o:[o],async function(e,t,n){let r;for await(const s of t)try{s.length<2?s.call(e,n):await new Promise((t,r)=>{s.call(e,n,e=>{e?r(e):t()})})}catch(e){r=e}if(r)throw r}(s,o.slice(),n).then(r).catch(r),s.listenerCount(e)>0}once(e,t){const n=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(s,o){n.removeListener(e,r),t(s,o)}:function(s){n.removeListener(e,r),t(s,r)},n.on(e,r),n}first(e,t){let n=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(n)||(this._events[e]=n=[n]),n.unshift(t),this}before(e,t,n){return this.beforeOrAfter(e,t,n)}after(e,t,n){return this.beforeOrAfter(e,t,n,"after")}beforeOrAfter(e,t,n,r){let s,o,a=this._events[e]??[];const i="after"===r?1:0;if("function"!=typeof n)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(a)||(this._events[e]=a=[a]),o=a.length,s=a.length;s--;)if(a[s]===t){o=s+i;break}return a.splice(o,0,n),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}n.AsyncEventEmitter=s}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.intToUnpaddedBuffer=n.bigIntToUnpaddedBuffer=n.bigIntToHex=n.bufArrToArr=n.arrToBufArr=n.validateNoLeadingZeroes=n.baToJSON=n.toUtf8=n.short=n.addHexPrefix=n.toUnsigned=n.fromSigned=n.bufferToInt=n.bigIntToBuffer=n.bufferToBigInt=n.bufferToHex=n.toBuffer=n.unpadHexString=n.unpadArray=n.unpadBuffer=n.setLengthRight=n.setLengthLeft=n.zeros=n.intToBuffer=n.intToHex=void 0;const r=e("./helpers"),s=e("./internal");n.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};n.intToBuffer=function(e){const r=(0,n.intToHex)(e);return t.from((0,s.padToEven)(r.slice(2)),"hex")};n.zeros=function(e){return t.allocUnsafe(e).fill(0)};const o=function(e,t,r){const s=(0,n.zeros)(t);return r?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};n.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),o(e,t,!1)};n.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),o(e,t,!0)};const a=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};n.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),a(e)};n.unpadArray=function(e){return(0,r.assertIsArray)(e),a(e)};n.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+a(e)};n.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,n.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let n=e.toString(16);return n.length%2&&(n="0"+n),t.from(n,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,n.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,n.toBuffer)("0x"+e.toString(16))}n.bufferToHex=function(e){return"0x"+(e=(0,n.toBuffer)(e)).toString("hex")},n.bufferToBigInt=i,n.bigIntToBuffer=c;n.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};n.fromSigned=function(e){return BigInt.asIntN(256,i(e))};n.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};n.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},n.short=function(e,n=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=n?r:r.slice(0,n)+"…"};n.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};n.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,n.baToJSON)(e[r]));return t}};n.validateNoLeadingZeroes=function(e){for(const[t,n]of Object.entries(e))if(n!==undefined&&n.length>0&&0===n[0])throw new Error(`${t} cannot have leading zeroes, received: ${n.toString("hex")}`)},n.arrToBufArr=function e(n){return Array.isArray(n)?n.map(t=>e(t)):t.from(n)},n.bufArrToArr=function e(t){return Array.isArray(t)?t.map(t=>e(t)):Uint8Array.from(t??[])};n.bigIntToHex=e=>"0x"+e.toString(16),n.bigIntToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)(c(e))},n.intToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)((0,n.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAX_WITHDRAWALS_PER_PAYLOAD=n.RLP_EMPTY_STRING=n.KECCAK256_RLP=n.KECCAK256_RLP_S=n.KECCAK256_RLP_ARRAY=n.KECCAK256_RLP_ARRAY_S=n.KECCAK256_NULL=n.KECCAK256_NULL_S=n.TWO_POW256=n.SECP256K1_ORDER_DIV_2=n.SECP256K1_ORDER=n.MAX_INTEGER_BIGINT=n.MAX_INTEGER=n.MAX_UINT64=void 0;const r=e("buffer"),s=e("ethereum-cryptography/secp256k1");n.MAX_UINT64=BigInt("0xffffffffffffffff"),n.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),n.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),n.SECP256K1_ORDER=s.secp256k1.CURVE.n,n.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),n.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),n.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",n.KECCAK256_NULL=r.Buffer.from(n.KECCAK256_NULL_S,"hex"),n.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",n.KECCAK256_RLP_ARRAY=r.Buffer.from(n.KECCAK256_RLP_ARRAY_S,"hex"),n.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",n.KECCAK256_RLP=r.Buffer.from(n.KECCAK256_RLP_S,"hex"),n.RLP_EMPTY_STRING=r.Buffer.from([128]),n.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compactBytesToNibbles=n.bytesToNibbles=n.nibblesToCompactBytes=n.nibblesToBytes=n.hasTerminator=void 0;n.hasTerminator=e=>e.length>0&&16===e[e.length-1];n.nibblesToBytes=(e,t)=>{for(let n=0,r=0;r<e.length;n+=1,r+=2)t[n]=e[r]<<4|e[r+1]};n.nibblesToCompactBytes=e=>{let t=0;(0,n.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,n.nibblesToBytes)(e,r.subarray(1)),r};n.bytesToNibbles=e=>{const t=2*e.length+1,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];n[2*t]=r/16,n[2*t+1]=r%16}return n[t-1]=16,n};n.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,n.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.assertIsString=n.assertIsArray=n.assertIsBuffer=n.assertIsHexString=void 0;const r=e("./internal");n.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};n.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};n.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};n.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.toAscii=n.stripHexPrefix=n.padToEven=n.isHexString=n.isHexPrefixed=n.getKeys=n.getBinarySize=n.fromUtf8=n.fromAscii=n.arrayContainsArray=void 0,s(e("./constants"),n),s(e("./units"),n),s(e("./account"),n),s(e("./address"),n),s(e("./withdrawal"),n),s(e("./signature"),n),s(e("./bytes"),n),s(e("./types"),n),s(e("./encoding"),n),s(e("./asyncEventEmitter"),n);var o=e("./internal");Object.defineProperty(n,"arrayContainsArray",{enumerable:!0,get:function(){return o.arrayContainsArray}}),Object.defineProperty(n,"fromAscii",{enumerable:!0,get:function(){return o.fromAscii}}),Object.defineProperty(n,"fromUtf8",{enumerable:!0,get:function(){return o.fromUtf8}}),Object.defineProperty(n,"getBinarySize",{enumerable:!0,get:function(){return o.getBinarySize}}),Object.defineProperty(n,"getKeys",{enumerable:!0,get:function(){return o.getKeys}}),Object.defineProperty(n,"isHexPrefixed",{enumerable:!0,get:function(){return o.isHexPrefixed}}),Object.defineProperty(n,"isHexString",{enumerable:!0,get:function(){return o.isHexString}}),Object.defineProperty(n,"padToEven",{enumerable:!0,get:function(){return o.padToEven}}),Object.defineProperty(n,"stripHexPrefix",{enumerable:!0,get:function(){return o.stripHexPrefix}}),Object.defineProperty(n,"toAscii",{enumerable:!0,get:function(){return o.toAscii}}),s(e("./lock"),n),s(e("./provider"),n)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(n,"__esModule",{value:!0}),n.isHexString=n.getKeys=n.fromAscii=n.fromUtf8=n.toAscii=n.arrayContainsArray=n.getBinarySize=n.padToEven=n.stripHexPrefix=n.isHexPrefixed=void 0,n.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}n.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},n.padToEven=r,n.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},n.arrayContainsArray=function(e,t,n){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===n?"some":"every"](t=>e.indexOf(t)>=0)},n.toAscii=function(e){let t="",n=0;const r=e.length;for("0x"===e.substring(0,2)&&(n=2);n<r;n+=2){const r=parseInt(e.substr(n,2),16);t+=String.fromCharCode(r)}return t},n.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},n.fromAscii=function(e){let t="";for(let n=0;n<e.length;n++){const r=e.charCodeAt(n).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},n.getKeys=function(e,t,n){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let s=0;s<e.length;s++){let o=e[s][t];if(!0!==n||o){if("string"!=typeof o)throw new Error("invalid abi - expected type 'string', received "+typeof o)}else o="";r.push(o)}return r},n.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Lock=void 0;n.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise(e=>this.promiseResolverQueue.push(e))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getProvider=n.fetchFromProvider=void 0;const r=e("micro-ftch");n.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;n.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashPersonalMessage=n.isValidSignature=n.fromRpcSig=n.toCompactSig=n.toRpcSig=n.ecrecover=n.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),o=e("./bytes"),a=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function m(e){return e===BigInt(0)||e===BigInt(1)}n.ecsign=function(e,n,r){const o=s.secp256k1.sign(e,n),a=o.toCompactRawBytes();return{r:t.from(a.slice(0,32)),s:t.from(a.slice(32,64)),v:r===undefined?BigInt(o.recovery+27):BigInt(o.recovery+35)+BigInt(r)*BigInt(2)}};n.ecrecover=function(e,n,r,a,i){const d=t.concat([(0,o.setLengthLeft)(r,32),(0,o.setLengthLeft)(a,32)],64),u=c(n,i);if(!m(u))throw new Error("Invalid signature v value");const l=s.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};n.toRpcSig=function(e,n,r,s){if(!m(c(e,s)))throw new Error("Invalid signature v value");return(0,o.bufferToHex)(t.concat([(0,o.setLengthLeft)(n,32),(0,o.setLengthLeft)(r,32),(0,o.toBuffer)(e)]))};n.toCompactSig=function(e,n,r,s){if(!m(c(e,s)))throw new Error("Invalid signature v value");let a=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(a=t.from(r),a[0]|=128),(0,o.bufferToHex)(t.concat([(0,o.setLengthLeft)(n,32),(0,o.setLengthLeft)(a,32)]))};n.fromRpcSig=function(e){const t=(0,o.toBuffer)(e);let n,r,s;if(t.length>=65)n=t.slice(0,32),r=t.slice(32,64),s=(0,o.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");n=t.slice(0,32),r=t.slice(32,64),s=BigInt((0,o.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:n,s:r}};n.isValidSignature=function(e,t,n,r=!0,s){if(32!==t.length||32!==n.length)return!1;if(!m(c(e,s)))return!1;const i=(0,o.bufferToBigInt)(t),d=(0,o.bufferToBigInt)(n);return!(i===BigInt(0)||i>=a.SECP256K1_ORDER||d===BigInt(0)||d>=a.SECP256K1_ORDER)&&!(r&&d>=a.SECP256K1_ORDER_DIV_2)};n.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const n=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([n,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toType=n.TypeOutput=void 0;const r=e("./bytes"),s=e("./internal");var o;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(o=n.TypeOutput||(n.TypeOutput={})),n.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const n=(0,r.toBuffer)(e);switch(t){case o.Buffer:return n;case o.BigInt:return(0,r.bufferToBigInt)(n);case o.Number:{const e=(0,r.bufferToBigInt)(n);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case o.PrefixedHexString:return(0,r.bufferToHex)(n);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.GWEI_TO_WEI=void 0,n.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Withdrawal=void 0;const r=e("./address"),s=e("./bytes"),o=e("./types");class a{constructor(e,t,n,r){this.index=e,this.validatorIndex=t,this.address=n,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:n,address:s,amount:i}=e,c=(0,o.toType)(t,o.TypeOutput.BigInt),m=(0,o.toType)(n,o.TypeOutput.BigInt),d=new r.Address((0,o.toType)(s,o.TypeOutput.Buffer)),u=(0,o.toType)(i,o.TypeOutput.BigInt);return new a(c,m,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,n,r,s]=e;return a.fromWithdrawalData({index:t,validatorIndex:n,address:r,amount:s})}static toBufferArray(e){const{index:n,validatorIndex:s,address:a,amount:i}=e,c=(0,o.toType)(n,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(n,o.TypeOutput.Buffer),m=(0,o.toType)(s,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(s,o.TypeOutput.Buffer);let d;d=a instanceof r.Address?a.buf:(0,o.toType)(a,o.TypeOutput.Buffer);return[c,m,d,(0,o.toType)(i,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(i,o.TypeOutput.Buffer)]}raw(){return a.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}n.Withdrawal=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return m.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return u.default}});var r=l(e("./v1.js")),s=l(e("./v3.js")),o=l(e("./v4.js")),a=l(e("./v5.js")),i=l(e("./nil.js")),c=l(e("./version.js")),m=l(e("./validate.js")),d=l(e("./stringify.js")),u=l(e("./parse.js"));function l(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return 14+(e+64>>>9<<4)+1}function s(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function o(e,t,n,r,o,a){return s((i=s(s(t,e),s(r,a)))<<(c=o)|i>>>32-c,n);var i,c}function a(e,t,n,r,s,a,i){return o(t&n|~t&r,e,t,s,a,i)}function i(e,t,n,r,s,a,i){return o(t&r|n&~r,e,t,s,a,i)}function c(e,t,n,r,s,a,i){return o(t^n^r,e,t,s,a,i)}function m(e,t,n,r,s,a,i){return o(n^(t|~r),e,t,s,a,i)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var d=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,r="0123456789abcdef";for(let s=0;s<n;s+=8){const n=e[s>>5]>>>s%32&255,o=parseInt(r.charAt(n>>>4&15)+r.charAt(15&n),16);t.push(o)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[r(t)-1]=t;let n=1732584193,o=-271733879,d=-1732584194,u=271733878;for(let t=0;t<e.length;t+=16){const r=n,l=o,h=d,f=u;n=a(n,o,d,u,e[t],7,-680876936),u=a(u,n,o,d,e[t+1],12,-389564586),d=a(d,u,n,o,e[t+2],17,606105819),o=a(o,d,u,n,e[t+3],22,-1044525330),n=a(n,o,d,u,e[t+4],7,-176418897),u=a(u,n,o,d,e[t+5],12,1200080426),d=a(d,u,n,o,e[t+6],17,-1473231341),o=a(o,d,u,n,e[t+7],22,-45705983),n=a(n,o,d,u,e[t+8],7,1770035416),u=a(u,n,o,d,e[t+9],12,-1958414417),d=a(d,u,n,o,e[t+10],17,-42063),o=a(o,d,u,n,e[t+11],22,-1990404162),n=a(n,o,d,u,e[t+12],7,1804603682),u=a(u,n,o,d,e[t+13],12,-40341101),d=a(d,u,n,o,e[t+14],17,-1502002290),o=a(o,d,u,n,e[t+15],22,1236535329),n=i(n,o,d,u,e[t+1],5,-165796510),u=i(u,n,o,d,e[t+6],9,-1069501632),d=i(d,u,n,o,e[t+11],14,643717713),o=i(o,d,u,n,e[t],20,-373897302),n=i(n,o,d,u,e[t+5],5,-701558691),u=i(u,n,o,d,e[t+10],9,38016083),d=i(d,u,n,o,e[t+15],14,-660478335),o=i(o,d,u,n,e[t+4],20,-405537848),n=i(n,o,d,u,e[t+9],5,568446438),u=i(u,n,o,d,e[t+14],9,-1019803690),d=i(d,u,n,o,e[t+3],14,-187363961),o=i(o,d,u,n,e[t+8],20,1163531501),n=i(n,o,d,u,e[t+13],5,-1444681467),u=i(u,n,o,d,e[t+2],9,-51403784),d=i(d,u,n,o,e[t+7],14,1735328473),o=i(o,d,u,n,e[t+12],20,-1926607734),n=c(n,o,d,u,e[t+5],4,-378558),u=c(u,n,o,d,e[t+8],11,-2022574463),d=c(d,u,n,o,e[t+11],16,1839030562),o=c(o,d,u,n,e[t+14],23,-35309556),n=c(n,o,d,u,e[t+1],4,-1530992060),u=c(u,n,o,d,e[t+4],11,1272893353),d=c(d,u,n,o,e[t+7],16,-155497632),o=c(o,d,u,n,e[t+10],23,-1094730640),n=c(n,o,d,u,e[t+13],4,681279174),u=c(u,n,o,d,e[t],11,-358537222),d=c(d,u,n,o,e[t+3],16,-722521979),o=c(o,d,u,n,e[t+6],23,76029189),n=c(n,o,d,u,e[t+9],4,-640364487),u=c(u,n,o,d,e[t+12],11,-421815835),d=c(d,u,n,o,e[t+15],16,530742520),o=c(o,d,u,n,e[t+2],23,-995338651),n=m(n,o,d,u,e[t],6,-198630844),u=m(u,n,o,d,e[t+7],10,1126891415),d=m(d,u,n,o,e[t+14],15,-1416354905),o=m(o,d,u,n,e[t+5],21,-57434055),n=m(n,o,d,u,e[t+12],6,1700485571),u=m(u,n,o,d,e[t+3],10,-1894986606),d=m(d,u,n,o,e[t+10],15,-1051523),o=m(o,d,u,n,e[t+1],21,-2054922799),n=m(n,o,d,u,e[t+8],6,1873313359),u=m(u,n,o,d,e[t+15],10,-30611744),d=m(d,u,n,o,e[t+6],15,-1560198380),o=m(o,d,u,n,e[t+13],21,1309151649),n=m(n,o,d,u,e[t+4],6,-145523070),u=m(u,n,o,d,e[t+11],10,-1120210379),d=m(d,u,n,o,e[t+2],15,718787259),o=m(o,d,u,n,e[t+9],21,-343485551),n=s(n,r),o=s(o,l),d=s(d,h),u=s(u,f)}return[n,o,d,u]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(r(t));for(let r=0;r<t;r+=8)n[r>>5]|=(255&e[r/8])<<r%32;return n}(e),8*e.length))};n.default=d}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let r;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!r&&(r="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto),!r))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return r(s)};const s=new Uint8Array(16)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n,r){switch(e){case 0:return t&n^~t&r;case 1:case 3:return t^n^r;case 2:return t&n^t&r^n&r}}function s(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var o=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const o=e.length/4+2,a=Math.ceil(o/16),i=new Array(a);for(let t=0;t<a;++t){const n=new Uint32Array(16);for(let r=0;r<16;++r)n[r]=e[64*t+4*r]<<24|e[64*t+4*r+1]<<16|e[64*t+4*r+2]<<8|e[64*t+4*r+3];i[t]=n}i[a-1][14]=8*(e.length-1)/Math.pow(2,32),i[a-1][14]=Math.floor(i[a-1][14]),i[a-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<a;++e){const o=new Uint32Array(80);for(let t=0;t<16;++t)o[t]=i[e][t];for(let e=16;e<80;++e)o[e]=s(o[e-3]^o[e-8]^o[e-14]^o[e-16],1);let a=n[0],c=n[1],m=n[2],d=n[3],u=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),i=s(a,5)+r(n,c,m,d)+u+t[n]+o[e]>>>0;u=d,d=m,m=s(c,30)>>>0,c=a,a=i}n[0]=n[0]+a>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+m>>>0,n[3]=n[3]+d>>>0,n[4]=n[4]+u>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};const o=[];for(let e=0;e<256;++e)o.push((e+256).toString(16).substr(1));var a=function(e,t=0){const n=(o[e[t+0]]+o[e[t+1]]+o[e[t+2]]+o[e[t+3]]+"-"+o[e[t+4]]+o[e[t+5]]+"-"+o[e[t+6]]+o[e[t+7]]+"-"+o[e[t+8]]+o[e[t+9]]+"-"+o[e[t+10]]+o[e[t+11]]+o[e[t+12]]+o[e[t+13]]+o[e[t+14]]+o[e[t+15]]).toLowerCase();if(!(0,s.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./rng.js")),s=o(e("./stringify.js"));function o(e){return e&&e.__esModule?e:{default:e}}let a,i,c=0,m=0;var d=function(e,t,n){let o=t&&n||0;const d=t||new Array(16);let u=(e=e||{}).node||a,l=e.clockseq!==undefined?e.clockseq:i;if(null==u||null==l){const t=e.random||(e.rng||r.default)();null==u&&(u=a=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==l&&(l=i=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),f=e.nsecs!==undefined?e.nsecs:m+1;const p=h-c+(f-m)/1e4;if(p<0&&e.clockseq===undefined&&(l=l+1&16383),(p<0||h>c)&&e.nsecs===undefined&&(f=0),f>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,m=f,i=l,h+=122192928e5;const g=(1e4*(268435455&h)+f)%4294967296;d[o++]=g>>>24&255,d[o++]=g>>>16&255,d[o++]=g>>>8&255,d[o++]=255&g;const y=h/4294967296*1e4&268435455;d[o++]=y>>>8&255,d[o++]=255&y,d[o++]=y>>>24&15|16,d[o++]=y>>>16&255,d[o++]=l>>>8|128,d[o++]=255&l;for(let e=0;e<6;++e)d[o+e]=u[e];return t||(0,s.default)(d)};n.default=d}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./md5.js"));function o(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v3",48,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,t,n){function o(e,o,a,i){if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof o&&(o=(0,s.default)(o)),16!==o.length)throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let c=new Uint8Array(16+e.length);if(c.set(o),c.set(e,o.length),c=n(c),c[6]=15&c[6]|t,c[8]=63&c[8]|128,a){i=i||0;for(let e=0;e<16;++e)a[i+e]=c[e];return a}return(0,r.default)(c)}try{o.name=e}catch(e){}return o.DNS=a,o.URL=i,o},n.URL=n.DNS=void 0;var r=o(e("./stringify.js")),s=o(e("./parse.js"));function o(e){return e&&e.__esModule?e:{default:e}}const a="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=a;const i="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v4.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./rng.js")),s=o(e("./stringify.js"));function o(e){return e&&e.__esModule?e:{default:e}}var a=function(e,t,n){const o=(e=e||{}).random||(e.rng||r.default)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=o[e];return t}return(0,s.default)(o)};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./sha1.js"));function o(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v5",80,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./regex.js"))&&r.__esModule?r:{default:r};var o=function(e){return"string"==typeof e&&s.default.test(e)};n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");return parseInt(e.substr(14,1),16)};n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Bytes.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Bytes=void 0;const r=e("./lib"),s=e("./RegistryItem"),o=e("./RegistryType");class a extends s.RegistryItem{constructor(e){super(),this.bytes=e,this.getRegistryType=()=>o.RegistryTypes.BYTES,this.getData=()=>this.bytes,this.toDataItem=()=>new r.DataItem(this.bytes)}}n.Bytes=a,a.fromDataItem=e=>{const t=e.getData();if(!t)throw new Error(`#[ur-registry][Bytes][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${e}`);return new a(t)},a.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return a.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoAccount.js",{".":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoAccount=void 0;const r=e("."),s=e("./lib"),o=e("./RegistryItem"),a=e("./RegistryType");var i;!function(e){e[e.masterFingerprint=1]="masterFingerprint",e[e.outputDescriptors=2]="outputDescriptors"}(i||(i={}));class c extends o.RegistryItem{constructor(e,t){super(),this.masterFingerprint=e,this.outputDescriptors=t,this.getRegistryType=()=>a.RegistryTypes.CRYPTO_ACCOUNT,this.getMasterFingerprint=()=>this.masterFingerprint,this.getOutputDescriptors=()=>this.outputDescriptors,this.toDataItem=()=>{const e={};return this.masterFingerprint&&(e[i.masterFingerprint]=this.masterFingerprint.readUInt32BE(0)),this.outputDescriptors&&(e[i.outputDescriptors]=this.outputDescriptors.map(e=>e.toDataItem())),new s.DataItem(e)}}}n.CryptoAccount=c,c.fromDataItem=e=>{const n=e.getData(),s=t.alloc(4),o=n[i.masterFingerprint];o&&s.writeUInt32BE(o,0);const a=n[i.outputDescriptors].map(e=>r.CryptoOutput.fromDataItem(e));return new c(s,a)},c.fromCBOR=e=>{const t=(0,s.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoAccount.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoCoinInfo=n.Network=n.Type=void 0;const r=e("./lib"),s=e("./RegistryItem"),o=e("./RegistryType");var a,i,c;!function(e){e.type="1",e.network="2"}(a||(a={})),function(e){e[e.bitcoin=0]="bitcoin"}(i=n.Type||(n.Type={})),function(e){e[e.mainnet=0]="mainnet",e[e.testnet=1]="testnet"}(c=n.Network||(n.Network={}));class m extends s.RegistryItem{constructor(e,t){super(),this.type=e,this.network=t,this.getRegistryType=()=>o.RegistryTypes.CRYPTO_COIN_INFO,this.getType=()=>this.type||i.bitcoin,this.getNetwork=()=>this.network||c.mainnet,this.toDataItem=()=>{const e={};return this.type&&(e[a.type]=this.type),this.network&&(e[a.network]=this.network),new r.DataItem(e)}}}n.CryptoCoinInfo=m,m.fromDataItem=e=>{const t=e.getData(),n=t[a.type],r=t[a.network];return new m(n,r)},m.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return m.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoECKey=void 0;const r=e("./lib"),s=e("./RegistryItem"),o=e("./RegistryType");var a;!function(e){e[e.curve=1]="curve",e[e.private=2]="private",e[e.data=3]="data"}(a||(a={}));class i extends s.RegistryItem{constructor(e){super(),this.isECKey=()=>!0,this.getCurve=()=>this.curve||0,this.isPrivateKey=()=>this.privateKey||!1,this.getData=()=>this.data,this.getRegistryType=()=>o.RegistryTypes.CRYPTO_ECKEY,this.toDataItem=()=>{const e={};return this.curve&&(e[a.curve]=this.curve),this.privateKey!==undefined&&(e[a.private]=this.privateKey),e[a.data]=this.data,new r.DataItem(e)},this.getOutputDescriptorContent=()=>this.data.toString("hex"),this.data=e.data,this.curve=e.curve,this.privateKey=e.privateKey||undefined}}n.CryptoECKey=i,i.fromDataItem=e=>{const t=e.getData(),n=t[a.curve],r=t[a.private],s=t[a.data];if(!s)throw new Error(`#[ur-registry][CryptoECKey][fn.fromDataItem]: decoded [dataItem][#data.data] is undefined: ${e}`);return new i({data:s,curve:n,privateKey:r})},i.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return i.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js",{"./CryptoCoinInfo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js","./CryptoKeypath":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",bs58check:"/home/runner/work/metamask-extension/metamask-extension/node_modules/bs58check/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoHDKey=void 0;const r=e("bs58check"),s=e("./CryptoCoinInfo"),o=e("./CryptoKeypath"),a=e("./lib"),i=e("./RegistryItem"),c=e("./RegistryType");var m;!function(e){e[e.is_master=1]="is_master",e[e.is_private=2]="is_private",e[e.key_data=3]="key_data",e[e.chain_code=4]="chain_code",e[e.use_info=5]="use_info",e[e.origin=6]="origin",e[e.children=7]="children",e[e.parent_fingerprint=8]="parent_fingerprint",e[e.name=9]="name",e[e.note=10]="note"}(m||(m={}));class d extends i.RegistryItem{constructor(e){super(),this.isECKey=()=>!1,this.getKey=()=>this.key,this.getChainCode=()=>this.chainCode,this.isMaster=()=>this.master,this.isPrivateKey=()=>!!this.privateKey,this.getUseInfo=()=>this.useInfo,this.getOrigin=()=>this.origin,this.getChildren=()=>this.children,this.getParentFingerprint=()=>this.parentFingerprint,this.getName=()=>this.name,this.getNote=()=>this.note,this.getBip32Key=()=>{var e,n,s;let o,a,i=0,c=t.alloc(4).fill(0);if(this.isMaster())o=t.from("0488ADE4","hex"),a=0,i=0;else{a=(null===(e=this.getOrigin())||void 0===e?void 0:e.getComponents().length)||(null===(n=this.getOrigin())||void 0===n?void 0:n.getDepth());const r=null===(s=this.getOrigin())||void 0===s?void 0:s.getComponents(),m=r[r.length-1];m&&(i=m.isHardened()?m.getIndex()+2147483648:m.getIndex(),this.getParentFingerprint()&&(c=this.getParentFingerprint())),o=this.isPrivateKey()?t.from("0488ADE4","hex"):t.from("0488B21E","hex")}const m=t.alloc(1);m.writeUInt8(a,0);const d=t.alloc(4);d.writeUInt32BE(i,0);const u=this.getChainCode(),l=this.getKey();return(0,r.encode)(t.concat([o,m,c,d,u,l]))},this.getRegistryType=()=>c.RegistryTypes.CRYPTO_HDKEY,this.getOutputDescriptorContent=()=>{var e,t,n,r,s,o,a;let i="";return this.getOrigin()&&(null===(e=this.getOrigin())||void 0===e?void 0:e.getSourceFingerprint())&&(null===(t=this.getOrigin())||void 0===t?void 0:t.getPath())&&(i+=`${null===(r=null===(n=this.getOrigin())||void 0===n?void 0:n.getSourceFingerprint())||void 0===r?void 0:r.toString("hex")}/${null===(s=this.getOrigin())||void 0===s?void 0:s.getPath()}`),i+=this.getBip32Key(),this.getChildren()&&(null===(o=this.getChildren())||void 0===o?void 0:o.getPath())&&(i+=`/${null===(a=this.getChildren())||void 0===a?void 0:a.getPath()}`),i},this.setupMasterKey=e=>{this.master=!0,this.key=e.key,this.chainCode=e.chainCode},this.setupDeriveKey=e=>{this.master=!1,this.privateKey=e.isPrivateKey,this.key=e.key,this.chainCode=e.chainCode,this.useInfo=e.useInfo,this.origin=e.origin,this.children=e.children,this.parentFingerprint=e.parentFingerprint,this.name=e.name,this.note=e.note},this.toDataItem=()=>{const e={};if(this.master)e[m.is_master]=!0,e[m.key_data]=this.key,e[m.chain_code]=this.chainCode;else{if(this.privateKey!==undefined&&(e[m.is_private]=this.privateKey),e[m.key_data]=this.key,this.chainCode&&(e[m.chain_code]=this.chainCode),this.useInfo){const t=this.useInfo.toDataItem();t.setTag(this.useInfo.getRegistryType().getTag()),e[m.use_info]=t}if(this.origin){const t=this.origin.toDataItem();t.setTag(this.origin.getRegistryType().getTag()),e[m.origin]=t}if(this.children){const t=this.children.toDataItem();t.setTag(this.children.getRegistryType().getTag()),e[m.children]=t}this.parentFingerprint&&(e[m.parent_fingerprint]=this.parentFingerprint.readUInt32BE(0)),this.name!==undefined&&(e[m.name]=this.name),this.note!==undefined&&(e[m.note]=this.note)}return new a.DataItem(e)},e.isMaster?this.setupMasterKey(e):this.setupDeriveKey(e)}}n.CryptoHDKey=d,d.fromDataItem=e=>{const n=e.getData(),r=!!n[m.is_master],a=n[m.is_private],i=n[m.key_data],c=n[m.chain_code],u=n[m.use_info]?s.CryptoCoinInfo.fromDataItem(n[m.use_info]):undefined,l=n[m.origin]?o.CryptoKeypath.fromDataItem(n[m.origin]):undefined,h=n[m.children]?o.CryptoKeypath.fromDataItem(n[m.children]):undefined,f=n[m.parent_fingerprint];let p=undefined;f&&(p=t.alloc(4),p.writeUInt32BE(f,0));const g=n[m.name],y=n[m.note];return new d({isMaster:r,isPrivateKey:a,key:i,chainCode:c,useInfo:u,origin:l,children:h,parentFingerprint:p,name:g,note:y})},d.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return d.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js",{"./PathComponent":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoKeypath=void 0;const r=e("./lib"),s=e("./PathComponent"),o=e("./RegistryItem"),a=e("./RegistryType");var i;!function(e){e[e.components=1]="components",e[e.source_fingerprint=2]="source_fingerprint",e[e.depth=3]="depth"}(i||(i={}));class c extends o.RegistryItem{constructor(e=[],t,n){super(),this.components=e,this.sourceFingerprint=t,this.depth=n,this.getRegistryType=()=>a.RegistryTypes.CRYPTO_KEYPATH,this.getPath=()=>{if(0===this.components.length)return undefined;return this.components.map(e=>`${e.isWildcard()?"*":e.getIndex()}${e.isHardened()?"'":""}`).join("/")},this.getComponents=()=>this.components,this.getSourceFingerprint=()=>this.sourceFingerprint,this.getDepth=()=>this.depth,this.toDataItem=()=>{const e={},t=[];return this.components&&this.components.forEach(e=>{e.isWildcard()?t.push([]):t.push(e.getIndex()),t.push(e.isHardened())}),e[i.components]=t,this.sourceFingerprint&&(e[i.source_fingerprint]=this.sourceFingerprint.readUInt32BE(0)),this.depth!==undefined&&(e[i.depth]=this.depth),new r.DataItem(e)}}}n.CryptoKeypath=c,c.fromDataItem=e=>{const n=e.getData(),r=[],o=n[i.components];if(o)for(let e=0;e<o.length;e+=2){const t=o[e+1],n=o[e];"number"==typeof n?r.push(new s.PathComponent({index:n,hardened:t})):r.push(new s.PathComponent({hardened:t}))}const a=n[i.source_fingerprint];let m;a&&(m=t.alloc(4),m.writeUInt32BE(a,0));const d=n[i.depth];return new c(r,m,d)},c.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoOutput.js",{"./CryptoECKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js","./CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","./MultiKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./ScriptExpression":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoOutput=void 0;const r=e("./CryptoECKey"),s=e("./CryptoHDKey"),o=e("./lib"),a=e("./MultiKey"),i=e("./RegistryItem"),c=e("./RegistryType"),m=e("./ScriptExpression");class d extends i.RegistryItem{constructor(e,t){super(),this.scriptExpressions=e,this.cryptoKey=t,this.getRegistryType=()=>c.RegistryTypes.CRYPTO_OUTPUT,this.getCryptoKey=()=>this.cryptoKey,this.getHDKey=()=>this.cryptoKey instanceof s.CryptoHDKey?this.cryptoKey:undefined,this.getECKey=()=>this.cryptoKey instanceof r.CryptoECKey?this.cryptoKey:undefined,this.getMultiKey=()=>this.cryptoKey instanceof a.MultiKey?this.cryptoKey:undefined,this.getScriptExpressions=()=>this.scriptExpressions,this._toOutputDescriptor=e=>e>=this.scriptExpressions.length?this.cryptoKey.getOutputDescriptorContent():`${this.scriptExpressions[e].getExpression()}(${this._toOutputDescriptor(e+1)})`,this.toString=()=>this._toOutputDescriptor(0),this.toDataItem=()=>{let e=this.cryptoKey.toDataItem();(this.cryptoKey instanceof r.CryptoECKey||this.cryptoKey instanceof s.CryptoHDKey)&&e.setTag(this.cryptoKey.getRegistryType().getTag());return[...this.scriptExpressions].reverse().forEach(t=>{const n=t.getTag();e.getTag()===undefined?e.setTag(n):e=new o.DataItem(e,n)}),e}}}n.CryptoOutput=d,d.fromDataItem=e=>{const t=[];let n=e;for(;;){let e=n.getTag();const r=m.ScriptExpression.fromTag(e);if(!r)break;if(t.push(r),!(n.getData()instanceof o.DataItem))break;n=n.getData(),e=n.getTag()}const i=t.length;if(i>0&&(t[i-1].getExpression()===m.ScriptExpressions.MULTISIG.getExpression()||t[i-1].getExpression()===m.ScriptExpressions.SORTED_MULTISIG.getExpression())){const e=a.MultiKey.fromDataItem(n);return new d(t,e)}if(n.getTag()===c.RegistryTypes.CRYPTO_HDKEY.getTag()){const e=s.CryptoHDKey.fromDataItem(n);return new d(t,e)}{const e=r.CryptoECKey.fromDataItem(n);return new d(t,e)}},d.fromCBOR=e=>{const t=(0,o.decodeToDataItem)(e);return d.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoOutput.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoPSBT.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoPSBT=void 0;const r=e("./lib"),s=e("./RegistryItem"),o=e("./RegistryType");class a extends s.RegistryItem{constructor(e){super(),this.psbt=e,this.getRegistryType=()=>o.RegistryTypes.CRYPTO_PSBT,this.getPSBT=()=>this.psbt,this.toDataItem=()=>new r.DataItem(this.psbt)}}n.CryptoPSBT=a,a.fromDataItem=e=>{const t=e.getData();if(!t)throw new Error(`#[ur-registry][CryptoPSBT][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${e}`);return new a(t)},a.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return a.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoPSBT.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Decoder/index.js",{"..":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js","@ngraveio/bc-ur":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ngraveio/bc-ur/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URRegistryDecoder=void 0;const r=e("@ngraveio/bc-ur"),s=e(".."),o=e("../RegistryType"),a=e("../errors");class i extends r.URDecoder{constructor(){super(...arguments),this.resultRegistryType=()=>{const e=this.resultUR();switch(e.type){case o.RegistryTypes.BYTES.getType():return s.Bytes.fromCBOR(e.cbor);case o.RegistryTypes.CRYPTO_HDKEY.getType():return s.CryptoHDKey.fromCBOR(e.cbor);case o.RegistryTypes.CRYPTO_KEYPATH.getType():return s.CryptoKeypath.fromCBOR(e.cbor);case o.RegistryTypes.CRYPTO_COIN_INFO.getType():return s.CryptoCoinInfo.fromCBOR(e.cbor);case o.RegistryTypes.CRYPTO_ECKEY.getType():return s.CryptoECKey.fromCBOR(e.cbor);case o.RegistryTypes.CRYPTO_OUTPUT.getType():return s.CryptoOutput.fromCBOR(e.cbor);case o.RegistryTypes.CRYPTO_PSBT.getType():return s.CryptoPSBT.fromCBOR(e.cbor);case o.RegistryTypes.CRYPTO_ACCOUNT.getType():return s.CryptoAccount.fromCBOR(e.cbor);default:throw new a.UnknownURTypeError(`#[ur-registry][Decoder][fn.resultRegistryType]: registry type ${e.type} is not supported now`)}}}}n.URRegistryDecoder=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Decoder/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js",{"./CryptoECKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js","./CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib/DataItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MultiKey=void 0;const r=e("./CryptoECKey"),s=e("./CryptoHDKey"),o=e("./lib/DataItem"),a=e("./RegistryItem"),i=e("./RegistryType");var c;!function(e){e[e.threshold=1]="threshold",e[e.keys=2]="keys"}(c||(c={}));class m extends a.RegistryItem{constructor(e,t){super(),this.threshold=e,this.keys=t,this.getThreshold=()=>this.threshold,this.getKeys=()=>this.keys,this.toDataItem=()=>{const e={};e[c.threshold]=this.threshold;const t=this.keys.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t});return e[c.keys]=t,new o.DataItem(e)},this.getOutputDescriptorContent=()=>[this.getThreshold(),this.keys.map(e=>e.getOutputDescriptorContent()).join(",")].join(",")}}n.MultiKey=m,m.fromDataItem=e=>{const t=e.getData(),n=t[c.threshold],o=t[c.keys],a=[];return o.forEach(e=>{e.getTag()===i.RegistryTypes.CRYPTO_HDKEY.getTag()?a.push(s.CryptoHDKey.fromDataItem(e)):e.getTag()===i.RegistryTypes.CRYPTO_ECKEY.getTag()&&a.push(r.CryptoECKey.fromDataItem(e))}),new m(n,a)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PathComponent=void 0;class r{constructor(e){if(this.getIndex=()=>this.index,this.isWildcard=()=>this.wildcard,this.isHardened=()=>this.hardened,this.index=e.index,this.hardened=e.hardened,this.index!==undefined?this.wildcard=!1:this.wildcard=!0,this.index&&0!==(this.index&r.HARDENED_BIT))throw new Error(`#[ur-registry][PathComponent][fn.constructor]: Invalid index ${this.index} - most significant bit cannot be set`)}}n.PathComponent=r,r.HARDENED_BIT=2147483648}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js",{"./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","@ngraveio/bc-ur":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ngraveio/bc-ur/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RegistryItem=void 0;const r=e("@ngraveio/bc-ur"),s=e("./lib");n.RegistryItem=class{constructor(){this.toCBOR=()=>{if(this.toDataItem()===undefined)throw new Error(`#[ur-registry][RegistryItem][fn.toCBOR]: registry ${this.getRegistryType()}'s method toDataItem returns undefined`);return(0,s.encodeDataItem)(this.toDataItem())},this.toUR=()=>new r.UR(this.toCBOR(),this.getRegistryType().getType()),this.toUREncoder=(e,t,n)=>{const s=this.toUR();return new r.UREncoder(s,e,t,n)}}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RegistryTypes=n.RegistryType=void 0;class r{constructor(e,t){this.type=e,this.tag=t,this.getTag=()=>this.tag,this.getType=()=>this.type}}n.RegistryType=r,n.RegistryTypes={UUID:new r("uuid",37),BYTES:new r("bytes",undefined),CRYPTO_HDKEY:new r("crypto-hdkey",303),CRYPTO_KEYPATH:new r("crypto-keypath",304),CRYPTO_COIN_INFO:new r("crypto-coin-info",305),CRYPTO_ECKEY:new r("crypto-eckey",306),CRYPTO_OUTPUT:new r("crypto-output",308),CRYPTO_PSBT:new r("crypto-psbt",310),CRYPTO_ACCOUNT:new r("crypto-account",311),CRYPTO_MULTI_ACCOUNTS:new r("crypto-multi-accounts",1103),QR_HARDWARE_CALL:new r("qr-hardware-call",1201),KEY_DERIVATION_CALL:new r("key-derivation-call",1301),KEY_DERIVATION_SCHEMA:new r("key-derivation-schema",1302)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ScriptExpressions=n.ScriptExpression=void 0;class r{constructor(e,t){this.tag=e,this.expression=t,this.getTag=()=>this.tag,this.getExpression=()=>this.expression}}n.ScriptExpression=r,r.fromTag=e=>Object.values(n.ScriptExpressions).find(t=>t.getTag()===e),n.ScriptExpressions={SCRIPT_HASH:new r(400,"sh"),WITNESS_SCRIPT_HASH:new r(401,"wsh"),PUBLIC_KEY:new r(402,"pk"),PUBLIC_KEY_HASH:new r(403,"pkh"),WITNESS_PUBLIC_KEY_HASH:new r(404,"wpkh"),COMBO:new r(405,"combo"),MULTISIG:new r(406,"multi"),SORTED_MULTISIG:new r(407,"sortedmulti"),ADDRESS:new r(307,"addr"),RAW_SCRIPT:new r(408,"raw")}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.UnknownURTypeError=void 0;class r extends Error{constructor(e){super(e)}}n.UnknownURTypeError=r}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/CryptoMultiAccounts.js",{"../CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoMultiAccounts=void 0;const r=e("../RegistryType"),s=e("../CryptoHDKey"),o=e("../RegistryItem"),a=e("../lib");var i;!function(e){e[e.masterFingerprint=1]="masterFingerprint",e[e.keys=2]="keys",e[e.device=3]="device",e[e.deviceId=4]="deviceId",e[e.version=5]="version"}(i||(i={}));class c extends o.RegistryItem{constructor(e,t,n,s,o){super(),this.masterFingerprint=e,this.keys=t,this.device=n,this.deviceId=s,this.version=o,this.getRegistryType=()=>r.RegistryTypes.CRYPTO_MULTI_ACCOUNTS,this.getMasterFingerprint=()=>this.masterFingerprint,this.getKeys=()=>this.keys,this.getDevice=()=>this.device,this.getDeviceId=()=>this.deviceId,this.getVersion=()=>this.version,this.toDataItem=()=>{const e={};return this.masterFingerprint&&(e[i.masterFingerprint]=this.masterFingerprint.readUInt32BE(0)),this.keys&&(e[i.keys]=this.keys.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t})),this.device&&(e[i.device]=this.device),this.deviceId&&(e[i.deviceId]=this.deviceId),this.version&&(e[i.version]=this.version),new a.DataItem(e)}}}n.CryptoMultiAccounts=c,c.fromDataItem=e=>{const n=e.getData(),r=t.alloc(4),o=n[i.masterFingerprint];o&&r.writeUInt32BE(o,0);const a=n[i.keys].map(e=>s.CryptoHDKey.fromDataItem(e)),m=n[i.device],d=n[i.deviceId],u=n[i.version];return new c(r,a,m,d,u)},c.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/CryptoMultiAccounts.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js",{"../CryptoKeypath":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js","../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyDerivationSchema=n.DerivationAlgorithm=n.Curve=void 0;const r=e("../RegistryType"),s=e("../RegistryItem"),o=e("../lib"),a=e("../CryptoKeypath");var i,c,m;!function(e){e[e.keyPath=1]="keyPath",e[e.curve=2]="curve",e[e.algo=3]="algo"}(i||(i={})),function(e){e[e.secp256k1=0]="secp256k1",e[e.ed25519=1]="ed25519"}(c=n.Curve||(n.Curve={})),function(e){e[e.slip10=0]="slip10",e[e.bip32ed25519=1]="bip32ed25519"}(m=n.DerivationAlgorithm||(n.DerivationAlgorithm={}));class d extends s.RegistryItem{constructor(e,t=c.secp256k1,n=m.slip10){super(),this.keypath=e,this.curve=t,this.algo=n,this.getRegistryType=()=>r.RegistryTypes.KEY_DERIVATION_SCHEMA,this.getKeypath=()=>this.keypath,this.getCurve=()=>this.curve,this.getAlgo=()=>this.algo,this.toDataItem=()=>{const e={},t=this.getKeypath().toDataItem();return t.setTag(this.getKeypath().getRegistryType().getTag()),e[i.keyPath]=t,e[i.curve]=this.curve,e[i.algo]=this.algo,new o.DataItem(e)}}}n.KeyDerivationSchema=d,d.fromDataItem=e=>{const t=e.getData(),n=a.CryptoKeypath.fromDataItem(t[i.keyPath]),r=t[i.curve],s=t[i.algo];return new d(n,r,s)},d.fromCBOR=e=>{const t=(0,o.decodeToDataItem)(e);return d.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js",{"../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","./DerivationSchema":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyDerivation=void 0;const r=e("../RegistryType"),s=e("../RegistryItem"),o=e("../lib"),a=e("./DerivationSchema");var i;!function(e){e[e.schemas=1]="schemas"}(i||(i={}));class c extends s.RegistryItem{constructor(e){super(),this.schemas=e,this.getRegistryType=()=>r.RegistryTypes.KEY_DERIVATION_CALL,this.getSchemas=()=>this.schemas,this.toDataItem=()=>{const e={};return e[i.schemas]=this.schemas.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t}),new o.DataItem(e)}}}n.KeyDerivation=c,c.fromDataItem=e=>{const t=e.getData()[i.schemas].map(e=>a.KeyDerivationSchema.fromDataItem(e));return new c(t)},c.fromCBOR=e=>{const t=(0,o.decodeToDataItem)(e);return c.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/QRHardwareCall.js",{"../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","./KeyDerivation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.QRHardwareCall=n.QRHardwareCallType=void 0;const r=e("../RegistryType"),s=e("../RegistryItem"),o=e("../lib"),a=e("./KeyDerivation");var i,c;!function(e){e[e.type=1]="type",e[e.params=2]="params",e[e.origin=3]="origin"}(i||(i={})),function(e){e[e.KeyDerivation=0]="KeyDerivation"}(c=n.QRHardwareCallType||(n.QRHardwareCallType={}));class m extends s.RegistryItem{constructor(e,t,n){super(),this.type=e,this.params=t,this.origin=n,this.getRegistryType=()=>r.RegistryTypes.QR_HARDWARE_CALL,this.getType=()=>this.type,this.getParams=()=>this.params,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};e[i.type]=this.type;const t=this.params.toDataItem();return t.setTag(this.params.getRegistryType().getTag()),e[i.params]=t,this.origin&&(e[i.origin]=this.origin),new o.DataItem(e)}}}n.QRHardwareCall=m,m.fromDataItem=e=>{const t=e.getData(),n=t[i.type]||c.KeyDerivation;let r;if(n===c.KeyDerivation)r=a.KeyDerivation.fromDataItem(t[i.params]);const s=t[i.origin];return new m(n,r,s)},m.fromCBOR=e=>{const t=(0,o.decodeToDataItem)(e);return m.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/QRHardwareCall.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js",{"./Bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Bytes.js","./CryptoAccount":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoAccount.js","./CryptoCoinInfo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js","./CryptoECKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js","./CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","./CryptoKeypath":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js","./CryptoOutput":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoOutput.js","./CryptoPSBT":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoPSBT.js","./Decoder":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Decoder/index.js","./MultiKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js","./PathComponent":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./ScriptExpression":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js","./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js","./extended/CryptoMultiAccounts":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/CryptoMultiAccounts.js","./extended/DerivationSchema":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js","./extended/KeyDerivation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js","./extended/QRHardwareCall":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/QRHardwareCall.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","./patchCBOR":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/patchCBOR.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/types.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js","buffer/":"/home/runner/work/metamask-extension/metamask-extension/node_modules/buffer/index.js",tslib:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tslib/tslib.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Buffer=n.extend=n.PathComponent=n.ScriptExpressions=n.MultiKey=n.CryptoPSBT=n.CryptoOutput=n.CryptoECKey=n.CryptoCoinInfoNetwork=n.CryptoCoinInfoType=n.CryptoCoinInfo=n.CryptoKeypath=n.CryptoMultiAccounts=n.CryptoHDKey=n.CryptoAccount=n.Bytes=n.URRegistryDecoder=n.DataItem=void 0;const r=e("tslib");e("./patchCBOR");const s=e("buffer/");Object.defineProperty(n,"Buffer",{enumerable:!0,get:function(){return s.Buffer}});const o=e("./CryptoHDKey");Object.defineProperty(n,"CryptoHDKey",{enumerable:!0,get:function(){return o.CryptoHDKey}});const a=e("./CryptoKeypath");Object.defineProperty(n,"CryptoKeypath",{enumerable:!0,get:function(){return a.CryptoKeypath}});const i=e("./CryptoCoinInfo");Object.defineProperty(n,"CryptoCoinInfo",{enumerable:!0,get:function(){return i.CryptoCoinInfo}}),Object.defineProperty(n,"CryptoCoinInfoType",{enumerable:!0,get:function(){return i.Type}}),Object.defineProperty(n,"CryptoCoinInfoNetwork",{enumerable:!0,get:function(){return i.Network}});const c=e("./CryptoECKey");Object.defineProperty(n,"CryptoECKey",{enumerable:!0,get:function(){return c.CryptoECKey}});const m=e("./Bytes");Object.defineProperty(n,"Bytes",{enumerable:!0,get:function(){return m.Bytes}});const d=e("./CryptoOutput");Object.defineProperty(n,"CryptoOutput",{enumerable:!0,get:function(){return d.CryptoOutput}});const u=e("./CryptoPSBT");Object.defineProperty(n,"CryptoPSBT",{enumerable:!0,get:function(){return u.CryptoPSBT}});const l=e("./CryptoAccount");Object.defineProperty(n,"CryptoAccount",{enumerable:!0,get:function(){return l.CryptoAccount}});const h=e("./Decoder");Object.defineProperty(n,"URRegistryDecoder",{enumerable:!0,get:function(){return h.URRegistryDecoder}});const f=e("./MultiKey");Object.defineProperty(n,"MultiKey",{enumerable:!0,get:function(){return f.MultiKey}});const p=e("./ScriptExpression");Object.defineProperty(n,"ScriptExpressions",{enumerable:!0,get:function(){return p.ScriptExpressions}});const g=e("./PathComponent");Object.defineProperty(n,"PathComponent",{enumerable:!0,get:function(){return g.PathComponent}});const y=e("./RegistryItem"),k=e("./RegistryType"),b=e("./lib");var x=e("./lib");Object.defineProperty(n,"DataItem",{enumerable:!0,get:function(){return x.DataItem}});const w=e("./utils"),_=e("./extended/CryptoMultiAccounts");Object.defineProperty(n,"CryptoMultiAccounts",{enumerable:!0,get:function(){return _.CryptoMultiAccounts}});const v={URRegistryDecoder:h.URRegistryDecoder,Bytes:m.Bytes,CryptoAccount:l.CryptoAccount,CryptoHDKey:o.CryptoHDKey,CryptoMultiAccounts:_.CryptoMultiAccounts,CryptoKeypath:a.CryptoKeypath,CryptoCoinInfo:i.CryptoCoinInfo,CryptoCoinInfoType:i.Type,CryptoCoinInfoNetwork:i.Network,CryptoECKey:c.CryptoECKey,CryptoOutput:d.CryptoOutput,CryptoPSBT:u.CryptoPSBT,MultiKey:f.MultiKey,ScriptExpressions:p.ScriptExpressions,PathComponent:g.PathComponent},E={addReader:b.addReader,addSemanticDecode:b.addSemanticDecode,addSemanticEncode:b.addSemanticEncode,addWriter:b.addWriter,patchTags:w.patchTags},j={RegistryTypes:k.RegistryTypes,RegistryItem:y.RegistryItem,RegistryType:k.RegistryType,decodeToDataItem:b.decodeToDataItem,encodeDataItem:b.encodeDataItem,cbor:E};n.extend=j,(0,r.__exportStar)(e("./errors"),n),(0,r.__exportStar)(e("./Decoder"),n),(0,r.__exportStar)(e("./lib"),n),(0,r.__exportStar)(e("./CryptoAccount"),n),(0,r.__exportStar)(e("./CryptoPSBT"),n),(0,r.__exportStar)(e("./CryptoHDKey"),n),(0,r.__exportStar)(e("./extended/CryptoMultiAccounts"),n),(0,r.__exportStar)(e("./extended/QRHardwareCall"),n),(0,r.__exportStar)(e("./extended/KeyDerivation"),n),(0,r.__exportStar)(e("./extended/DerivationSchema"),n),(0,r.__exportStar)(e("./CryptoOutput"),n),(0,r.__exportStar)(e("./CryptoCoinInfo"),n),(0,r.__exportStar)(e("./CryptoECKey"),n),(0,r.__exportStar)(e("./MultiKey"),n),(0,r.__exportStar)(e("./CryptoKeypath"),n),(0,r.__exportStar)(e("./patchCBOR"),n),(0,r.__exportStar)(e("./PathComponent"),n),(0,r.__exportStar)(e("./RegistryItem"),n),(0,r.__exportStar)(e("./RegistryType"),n),(0,r.__exportStar)(e("./types"),n),(0,r.__exportStar)(e("./utils"),n),n.default=v}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DataItem=void 0;n.DataItem=class{constructor(e,t){this.setTag=e=>{this.tag=e},this.clearTag=()=>{this.tag=undefined},this.getTag=()=>this.tag,this.getData=()=>this.data,this.data=e,this.tag=t}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/cbor-sync.js",{"./DataItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){!function(e,n){"function"==typeof define&&define.amd?define([],n):void 0!==t&&t.exports?t.exports=n():e.CBOR=n()}(this,function(){const{DataItem:t}=e("./DataItem");var r=function(){function e(e){this.$hex=e}e.prototype={length:function(){return this.$hex.length/2},toString:function(e){if(!e||"hex"===e||16===e)return this.$hex;if("utf-8"===e){for(var t="",n=0;n<this.$hex.length;n+=2)t+="%"+this.$hex.substring(n,n+2);return decodeURIComponent(t)}if("latin"===e){for(t=[],n=0;n<this.$hex.length;n+=2)t.push(parseInt(this.$hex.substring(n,n+2),16));return String.fromCharCode.apply(String,t)}throw new Error("Unrecognised format: "+e)}},e.fromLatinString=function(t){for(var n="",r=0;r<t.length;r++){var s=t.charCodeAt(r).toString(16);1===s.length&&(s="0"+s),n+=s}return new e(n)},e.fromUtf8String=function(t){for(var n=encodeURIComponent(t),r="",s=0;s<n.length;s++)if("%"===n.charAt(s))r+=n.substring(s+1,s+3),s+=2;else{var o=n.charCodeAt(s).toString(16);o.length<2&&(o="0"+o),r+=o}return new e(r)};var r=[],s={},o=function(e){return function(){throw new Error(e+" not implemented")}};function a(){}function i(){}function c(e,t){var n=e.value;return n<24?n:24==n?t.readByte():25==n?t.readUint16():26==n?t.readUint32():27==n?t.readUint64():31==n?null:void o("Additional info: "+n)()}function m(e,t,n){var r=e<<5;t<24?n.writeByte(r|t):t<256?(n.writeByte(24|r),n.writeByte(t)):t<65536?(n.writeByte(25|r),n.writeUint16(t)):t<4294967296?(n.writeByte(26|r),n.writeUint32(t)):(n.writeByte(27|r),n.writeUint64(t))}a.prototype={peekByte:o("peekByte"),readByte:o("readByte"),readChunk:o("readChunk"),readFloat16:function(){var e=this.readUint16(),t=(32767&e)>>10,n=1023&e,r=32768&e;if(31===t)return 0===n?r?-Infinity:Infinity:NaN;var s=t?Math.pow(2,t-25)*(1024+n):Math.pow(2,-24)*n;return r?-s:s},readFloat32:function(){var e=this.readUint32(),t=(2147483647&e)>>23,n=8388607&e,r=2147483648&e;if(255===t)return 0===n?r?-Infinity:Infinity:NaN;var s=t?Math.pow(2,t-23-127)*(8388608+n):Math.pow(2,-149)*n;return r?-s:s},readFloat64:function(){var e=this.readUint32(),t=e>>20&2047,n=4294967296*(1048575&e)+this.readUint32(),r=2147483648&e;if(2047===t)return 0===n?r?-Infinity:Infinity:NaN;var s=t?Math.pow(2,t-52-1023)*(4503599627370496+n):Math.pow(2,-1074)*n;return r?-s:s},readUint16:function(){return 256*this.readByte()+this.readByte()},readUint32:function(){return 65536*this.readUint16()+this.readUint16()},readUint64:function(){return 4294967296*this.readUint32()+this.readUint32()}},i.prototype={writeByte:o("writeByte"),result:o("result"),writeFloat16:o("writeFloat16"),writeFloat32:o("writeFloat32"),writeFloat64:o("writeFloat64"),writeUint16:function(e){this.writeByte(e>>8&255),this.writeByte(255&e)},writeUint32:function(e){this.writeUint16(e>>16&65535),this.writeUint16(65535&e)},writeUint64:function(e){if(e>=9007199254740992||e<=-9007199254740992)throw new Error("Cannot encode Uint64 of: "+e+" magnitude to big (floating point errors)");this.writeUint32(Math.floor(e/4294967296)),this.writeUint32(e%4294967296)},writeString:o("writeString"),canWriteBinary:function(e){return!1},writeBinary:o("writeChunk")};var d=new Error;function u(e){var t=function(e){var t=e.readByte();return{type:t>>5,value:31&t}}(e);switch(t.type){case 0:return c(t,e);case 1:return-1-c(t,e);case 2:return e.readChunk(c(t,e));case 3:return e.readChunk(c(t,e)).toString("utf-8");case 4:case 5:var n=c(t,e),r=[];if(null!==n){5===t.type&&(n*=2);for(var o=0;o<n;o++)r[o]=u(e)}else for(var a;(a=u(e))!==d;)r.push(a);if(5===t.type){var i={};for(o=0;o<r.length;o+=2)i[r[o]]=r[o+1];return i}return r;case 6:var m=c(t,e),l=s[m];r=u(e);return l?l(r):r;case 7:if(25===t.value)return e.readFloat16();if(26===t.value)return e.readFloat32();if(27===t.value)return e.readFloat64();switch(c(t,e)){case 20:return!1;case 21:return!0;case 22:return null;case 23:return undefined;case null:return d;default:throw new Error("Unknown fixed value: "+t.value)}default:throw new Error("Unsupported header: "+JSON.stringify(t))}throw new Error("not implemented yet")}function l(e,t){for(var n=0;n<r.length;n++){var s=r[n].fn(e);if(s!==undefined)return m(6,r[n].tag,t),l(s,t)}if(e&&"function"==typeof e.toCBOR&&(e=e.toCBOR()),!1===e)m(7,20,t);else if(!0===e)m(7,21,t);else if(null===e)m(7,22,t);else if(e===undefined)m(7,23,t);else if("number"==typeof e)Math.floor(e)===e&&e<9007199254740992&&e>-9007199254740992?e<0?m(1,-1-e,t):m(0,e,t):(!function(e,t,n){n.writeByte(e<<5|t)}(7,27,t),t.writeFloat64(e));else if("string"==typeof e)t.writeString(e,function(e){m(3,e,t)});else if(t.canWriteBinary(e))t.writeBinary(e,function(e){m(2,e,t)});else{if("object"!=typeof e)throw new Error("CBOR encoding not supported: "+e);if(p.config.useToJSON&&"function"==typeof e.toJSON&&(e=e.toJSON()),Array.isArray(e)){m(4,e.length,t);for(n=0;n<e.length;n++)l(e[n],t)}else{var o=Object.keys(e);m(5,o.length,t);for(n=0;n<o.length;n++){const r=parseInt(o[n]);isNaN(r)?(l(o[n],t),l(e[o[n]],t)):(l(r,t),l(e[o[n]],t))}}}}var h=[],f=[],p={config:{useToJSON:!0},addWriter:function(e,t){"string"==typeof e?f.push(function(n){if(e===n)return t(n)}):f.push(e)},addReader:function(e,t){"string"==typeof e?h.push(function(n,r){if(e===r)return t(n,r)}):h.push(e)},encode:function(e,t){for(var n=0;n<f.length;n++){var r=(0,f[n])(t);if(r)return l(e,r),r.result()}throw new Error("Unsupported output format: "+t)},encodeDataItem:function(e,t){for(var n=0;n<f.length;n++){var r=(0,f[n])(t);if(r)return e.getTag()!==undefined?(l(e,r),r.result()):(l(e.getData(),r),r.result())}throw new Error("Unsupported output format: "+t)},decode:function(e,t){for(var n=0;n<h.length;n++){var r=(0,h[n])(e,t);if(r)return u(r)}throw new Error("Unsupported input format: "+t)},decodeToDataItem:function(e,n){for(var r=0;r<h.length;r++){var s=(0,h[r])(e,n);if(s){const e=u(s);return e instanceof t?e:new t(e)}}throw new Error("Unsupported input format: "+n)},addSemanticEncode:function(e,t){if("number"!=typeof e||e%1!=0||e<0)throw new Error("Tag must be a positive integer");return r.push({tag:e,fn:t}),this},addSemanticDecode:function(e,t){if("number"!=typeof e||e%1!=0||e<0)throw new Error("Tag must be a positive integer");return s[e]=t,this}};function g(e){this.buffer=e,this.pos=0}function y(e){this.byteLength=0,this.defaultBufferLength=16384,this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0,this.completeBuffers=[],this.stringFormat=e}function k(e){this.hex=e,this.pos=0}function b(e){this.$hex="",this.finalFormat=e||"hex"}return g.prototype=Object.create(a.prototype),g.prototype.peekByte=function(){return this.buffer[this.pos]},g.prototype.readByte=function(){return this.buffer[this.pos++]},g.prototype.readUint16=function(){var e=this.buffer.readUInt16BE(this.pos);return this.pos+=2,e},g.prototype.readUint32=function(){var e=this.buffer.readUInt32BE(this.pos);return this.pos+=4,e},g.prototype.readFloat32=function(){var e=this.buffer.readFloatBE(this.pos);return this.pos+=4,e},g.prototype.readFloat64=function(){var e=this.buffer.readDoubleBE(this.pos);return this.pos+=8,e},g.prototype.readChunk=function(e){var t=n.alloc(e);return this.buffer.copy(t,0,this.pos,this.pos+=e),t},y.prototype=Object.create(i.prototype),y.prototype.writeByte=function(e){this.latestBuffer[this.latestBufferOffset++]=e,this.latestBufferOffset>=this.latestBuffer.length&&(this.completeBuffers.push(this.latestBuffer),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0),this.byteLength++},y.prototype.writeFloat32=function(e){var t=n.alloc(4);t.writeFloatBE(e,0),this.writeBuffer(t)},y.prototype.writeFloat64=function(e){var t=n.alloc(8);t.writeDoubleBE(e,0),this.writeBuffer(t)},y.prototype.writeString=function(e,t){var r=n.from(e,"utf-8");t(r.length),this.writeBuffer(r)},y.prototype.canWriteBinary=function(e){return e instanceof n},y.prototype.writeBinary=function(e,t){t(e.length),this.writeBuffer(e)},y.prototype.writeBuffer=function(e){if(!(e instanceof n))throw new TypeError("BufferWriter only accepts Buffers");this.latestBufferOffset?this.latestBuffer.length-this.latestBufferOffset>=e.length?(e.copy(this.latestBuffer,this.latestBufferOffset),this.latestBufferOffset+=e.length,this.latestBufferOffset>=this.latestBuffer.length&&(this.completeBuffers.push(this.latestBuffer),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0)):(this.completeBuffers.push(this.latestBuffer.slice(0,this.latestBufferOffset)),this.completeBuffers.push(e),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0):this.completeBuffers.push(e),this.byteLength+=e.length},y.prototype.result=function(){for(var e=n.alloc(this.byteLength),t=0,r=0;r<this.completeBuffers.length;r++){var s=this.completeBuffers[r];s.copy(e,t,0,s.length),t+=s.length}return this.latestBufferOffset&&this.latestBuffer.copy(e,t,0,this.latestBufferOffset),this.stringFormat?e.toString(this.stringFormat):e},"function"==typeof n&&(p.addReader(function(e,t){return n.isBuffer(e)?new g(e):"hex"===t||"base64"===t?new g(n.from(e,t)):void 0}),p.addWriter(function(e){return e&&"buffer"!==e?"hex"===e||"base64"===e?new y(e):void 0:new y})),k.prototype=Object.create(a.prototype),k.prototype.peekByte=function(){var e=this.hex.substring(this.pos,2);return parseInt(e,16)},k.prototype.readByte=function(){var e=this.hex.substring(this.pos,this.pos+2);return this.pos+=2,parseInt(e,16)},k.prototype.readChunk=function(t){var r=this.hex.substring(this.pos,this.pos+2*t);return this.pos+=2*t,"function"==typeof n?n.from(r,"hex"):new e(r)},b.prototype=Object.create(i.prototype),b.prototype.writeByte=function(e){if(e<0||e>255)throw new Error("Byte value out of range: "+e);var t=e.toString(16);1==t.length&&(t="0"+t),this.$hex+=t},b.prototype.canWriteBinary=function(t){return t instanceof e||"function"==typeof n&&t instanceof n},b.prototype.writeBinary=function(t,r){if(t instanceof e)r(t.length()),this.$hex+=t.$hex;else{if(!("function"==typeof n&&t instanceof n))throw new TypeError("HexWriter only accepts BinaryHex or Buffers");r(t.length),this.$hex+=t.toString("hex")}},b.prototype.result=function(){return"buffer"===this.finalFormat&&"function"==typeof n?n.from(this.$hex,"hex"):new e(this.$hex).toString(this.finalFormat)},b.prototype.writeString=function(t,n){var r=e.fromUtf8String(t);n(r.length()),this.$hex+=r.$hex},p.addReader(function(t,n){return t instanceof e||t.$hex?new k(t.$hex):"hex"===n?new k(t):void 0}),p.addWriter(function(e){if("hex"===e)return new b}),p}();return r.addSemanticEncode(0,function(e){if(e instanceof Date)return e.toISOString()}).addSemanticDecode(0,function(e){return new Date(e)}).addSemanticDecode(1,function(e){return new Date(e)}),r})}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/cbor-sync.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",{"./DataItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js","./cbor-sync":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/cbor-sync.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DataItem=n.addWriter=n.addReader=n.addSemanticEncode=n.addSemanticDecode=n.decodeToDataItem=n.encodeDataItem=void 0;var r=e("./cbor-sync");Object.defineProperty(n,"encodeDataItem",{enumerable:!0,get:function(){return r.encodeDataItem}}),Object.defineProperty(n,"decodeToDataItem",{enumerable:!0,get:function(){return r.decodeToDataItem}}),Object.defineProperty(n,"addSemanticDecode",{enumerable:!0,get:function(){return r.addSemanticDecode}}),Object.defineProperty(n,"addSemanticEncode",{enumerable:!0,get:function(){return r.addSemanticEncode}}),Object.defineProperty(n,"addReader",{enumerable:!0,get:function(){return r.addReader}}),Object.defineProperty(n,"addWriter",{enumerable:!0,get:function(){return r.addWriter}});var s=e("./DataItem");Object.defineProperty(n,"DataItem",{enumerable:!0,get:function(){return s.DataItem}})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/patchCBOR.js",{"./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./ScriptExpression":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("./utils"),s=e("./RegistryType"),o=e("./ScriptExpression"),a=Object.values(s.RegistryTypes).filter(e=>!!e.getTag()).map(e=>e.getTag()),i=Object.values(o.ScriptExpressions).map(e=>e.getTag());(0,r.patchTags)(a.concat(i))}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/patchCBOR.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/types.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js",{"./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.patchTags=void 0;const r=e("./lib"),s=[];n.patchTags=e=>{e.forEach(e=>{s.find(t=>t===e)||((0,r.addSemanticEncode)(e,t=>{if(t instanceof r.DataItem&&t.getTag()===e)return t.getData()}),(0,r.addSemanticDecode)(e,t=>new r.DataItem(t,e)),s.push(e))})}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return m.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}});var r=l(e("./v1.js")),s=l(e("./v3.js")),o=l(e("./v4.js")),a=l(e("./v5.js")),i=l(e("./nil.js")),c=l(e("./version.js")),m=l(e("./validate.js")),d=l(e("./stringify.js")),u=l(e("./parse.js"));function l(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return 14+(e+64>>>9<<4)+1}function s(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function o(e,t,n,r,o,a){return s((i=s(s(t,e),s(r,a)))<<(c=o)|i>>>32-c,n);var i,c}function a(e,t,n,r,s,a,i){return o(t&n|~t&r,e,t,s,a,i)}function i(e,t,n,r,s,a,i){return o(t&r|n&~r,e,t,s,a,i)}function c(e,t,n,r,s,a,i){return o(t^n^r,e,t,s,a,i)}function m(e,t,n,r,s,a,i){return o(n^(t|~r),e,t,s,a,i)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var d=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,r="0123456789abcdef";for(let s=0;s<n;s+=8){const n=e[s>>5]>>>s%32&255,o=parseInt(r.charAt(n>>>4&15)+r.charAt(15&n),16);t.push(o)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[r(t)-1]=t;let n=1732584193,o=-271733879,d=-1732584194,u=271733878;for(let t=0;t<e.length;t+=16){const r=n,l=o,h=d,f=u;n=a(n,o,d,u,e[t],7,-680876936),u=a(u,n,o,d,e[t+1],12,-389564586),d=a(d,u,n,o,e[t+2],17,606105819),o=a(o,d,u,n,e[t+3],22,-1044525330),n=a(n,o,d,u,e[t+4],7,-176418897),u=a(u,n,o,d,e[t+5],12,1200080426),d=a(d,u,n,o,e[t+6],17,-1473231341),o=a(o,d,u,n,e[t+7],22,-45705983),n=a(n,o,d,u,e[t+8],7,1770035416),u=a(u,n,o,d,e[t+9],12,-1958414417),d=a(d,u,n,o,e[t+10],17,-42063),o=a(o,d,u,n,e[t+11],22,-1990404162),n=a(n,o,d,u,e[t+12],7,1804603682),u=a(u,n,o,d,e[t+13],12,-40341101),d=a(d,u,n,o,e[t+14],17,-1502002290),o=a(o,d,u,n,e[t+15],22,1236535329),n=i(n,o,d,u,e[t+1],5,-165796510),u=i(u,n,o,d,e[t+6],9,-1069501632),d=i(d,u,n,o,e[t+11],14,643717713),o=i(o,d,u,n,e[t],20,-373897302),n=i(n,o,d,u,e[t+5],5,-701558691),u=i(u,n,o,d,e[t+10],9,38016083),d=i(d,u,n,o,e[t+15],14,-660478335),o=i(o,d,u,n,e[t+4],20,-405537848),n=i(n,o,d,u,e[t+9],5,568446438),u=i(u,n,o,d,e[t+14],9,-1019803690),d=i(d,u,n,o,e[t+3],14,-187363961),o=i(o,d,u,n,e[t+8],20,1163531501),n=i(n,o,d,u,e[t+13],5,-1444681467),u=i(u,n,o,d,e[t+2],9,-51403784),d=i(d,u,n,o,e[t+7],14,1735328473),o=i(o,d,u,n,e[t+12],20,-1926607734),n=c(n,o,d,u,e[t+5],4,-378558),u=c(u,n,o,d,e[t+8],11,-2022574463),d=c(d,u,n,o,e[t+11],16,1839030562),o=c(o,d,u,n,e[t+14],23,-35309556),n=c(n,o,d,u,e[t+1],4,-1530992060),u=c(u,n,o,d,e[t+4],11,1272893353),d=c(d,u,n,o,e[t+7],16,-155497632),o=c(o,d,u,n,e[t+10],23,-1094730640),n=c(n,o,d,u,e[t+13],4,681279174),u=c(u,n,o,d,e[t],11,-358537222),d=c(d,u,n,o,e[t+3],16,-722521979),o=c(o,d,u,n,e[t+6],23,76029189),n=c(n,o,d,u,e[t+9],4,-640364487),u=c(u,n,o,d,e[t+12],11,-421815835),d=c(d,u,n,o,e[t+15],16,530742520),o=c(o,d,u,n,e[t+2],23,-995338651),n=m(n,o,d,u,e[t],6,-198630844),u=m(u,n,o,d,e[t+7],10,1126891415),d=m(d,u,n,o,e[t+14],15,-1416354905),o=m(o,d,u,n,e[t+5],21,-57434055),n=m(n,o,d,u,e[t+12],6,1700485571),u=m(u,n,o,d,e[t+3],10,-1894986606),d=m(d,u,n,o,e[t+10],15,-1051523),o=m(o,d,u,n,e[t+1],21,-2054922799),n=m(n,o,d,u,e[t+8],6,1873313359),u=m(u,n,o,d,e[t+15],10,-30611744),d=m(d,u,n,o,e[t+6],15,-1560198380),o=m(o,d,u,n,e[t+13],21,1309151649),n=m(n,o,d,u,e[t+4],6,-145523070),u=m(u,n,o,d,e[t+11],10,-1120210379),d=m(d,u,n,o,e[t+2],15,718787259),o=m(o,d,u,n,e[t+9],21,-343485551),n=s(n,r),o=s(o,l),d=s(d,h),u=s(u,f)}return[n,o,d,u]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(r(t));for(let r=0;r<t;r+=8)n[r>>5]|=(255&e[r/8])<<r%32;return n}(e),8*e.length))};n.default=d}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/native-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=r}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/native-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let r;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!r&&(r="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!r))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return r(s)};const s=new Uint8Array(16)}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n,r){switch(e){case 0:return t&n^~t&r;case 1:case 3:return t^n^r;case 2:return t&n^t&r^n&r}}function s(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var o=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const o=e.length/4+2,a=Math.ceil(o/16),i=new Array(a);for(let t=0;t<a;++t){const n=new Uint32Array(16);for(let r=0;r<16;++r)n[r]=e[64*t+4*r]<<24|e[64*t+4*r+1]<<16|e[64*t+4*r+2]<<8|e[64*t+4*r+3];i[t]=n}i[a-1][14]=8*(e.length-1)/Math.pow(2,32),i[a-1][14]=Math.floor(i[a-1][14]),i[a-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<a;++e){const o=new Uint32Array(80);for(let t=0;t<16;++t)o[t]=i[e][t];for(let e=16;e<80;++e)o[e]=s(o[e-3]^o[e-8]^o[e-14]^o[e-16],1);let a=n[0],c=n[1],m=n[2],d=n[3],u=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),i=s(a,5)+r(n,c,m,d)+u+t[n]+o[e]>>>0;u=d,d=m,m=s(c,30)>>>0,c=a,a=i}n[0]=n[0]+a>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+m>>>0,n[3]=n[3]+d>>>0,n[4]=n[4]+u>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=a;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};const o=[];for(let e=0;e<256;++e)o.push((e+256).toString(16).slice(1));function a(e,t=0){return o[e[t+0]]+o[e[t+1]]+o[e[t+2]]+o[e[t+3]]+"-"+o[e[t+4]]+o[e[t+5]]+"-"+o[e[t+6]]+o[e[t+7]]+"-"+o[e[t+8]]+o[e[t+9]]+"-"+o[e[t+10]]+o[e[t+11]]+o[e[t+12]]+o[e[t+13]]+o[e[t+14]]+o[e[t+15]]}var i=function(e,t=0){const n=a(e,t);if(!(0,s.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./rng.js"))&&r.__esModule?r:{default:r},o=e("./stringify.js");let a,i,c=0,m=0;var d=function(e,t,n){let r=t&&n||0;const d=t||new Array(16);let u=(e=e||{}).node||a,l=e.clockseq!==undefined?e.clockseq:i;if(null==u||null==l){const t=e.random||(e.rng||s.default)();null==u&&(u=a=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==l&&(l=i=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),f=e.nsecs!==undefined?e.nsecs:m+1;const p=h-c+(f-m)/1e4;if(p<0&&e.clockseq===undefined&&(l=l+1&16383),(p<0||h>c)&&e.nsecs===undefined&&(f=0),f>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,m=f,i=l,h+=122192928e5;const g=(1e4*(268435455&h)+f)%4294967296;d[r++]=g>>>24&255,d[r++]=g>>>16&255,d[r++]=g>>>8&255,d[r++]=255&g;const y=h/4294967296*1e4&268435455;d[r++]=y>>>8&255,d[r++]=255&y,d[r++]=y>>>24&15|16,d[r++]=y>>>16&255,d[r++]=l>>>8|128,d[r++]=255&l;for(let e=0;e<6;++e)d[r+e]=u[e];return t||(0,o.unsafeStringify)(d)};n.default=d}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./md5.js"));function o(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v3",48,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function r(e,r,a,i){var c;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof r&&(r=(0,o.default)(r)),16!==(null===(c=r)||void 0===c?void 0:c.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let m=new Uint8Array(16+e.length);if(m.set(r),m.set(e,r.length),m=n(m),m[6]=15&m[6]|t,m[8]=63&m[8]|128,a){i=i||0;for(let e=0;e<16;++e)a[i+e]=m[e];return a}return(0,s.unsafeStringify)(m)}try{r.name=e}catch(e){}return r.DNS=a,r.URL=i,r};var r,s=e("./stringify.js"),o=(r=e("./parse.js"))&&r.__esModule?r:{default:r};const a="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=a;const i="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v4.js",{"./native.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/native-browser.js","./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=a(e("./native.js")),s=a(e("./rng.js")),o=e("./stringify.js");function a(e){return e&&e.__esModule?e:{default:e}}var i=function(e,t,n){if(r.default.randomUUID&&!t&&!e)return r.default.randomUUID();const a=(e=e||{}).random||(e.rng||s.default)();if(a[6]=15&a[6]|64,a[8]=63&a[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=a[e];return t}return(0,o.unsafeStringify)(a)};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./sha1.js"));function o(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v5",80,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./regex.js"))&&r.__esModule?r:{default:r};var o=function(e){return"string"==typeof e&&s.default.test(e)};n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js",{"json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js",xtend:"/home/runner/work/metamask-extension/metamask-extension/node_modules/xtend/immutable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("json-rpc-random-id")(),s=e("xtend");function o(e){this.currentProvider=e}function a(e){return function(...t){const n=t.pop();this.sendAsync({method:e,params:t},n)}}function i(e,t){return function(...n){const r=n.pop();n.length<e&&n.push("latest"),this.sendAsync({method:t,params:n},r)}}t.exports=o,o.prototype.getBalance=i(2,"eth_getBalance"),o.prototype.getCode=i(2,"eth_getCode"),o.prototype.getTransactionCount=i(2,"eth_getTransactionCount"),o.prototype.getStorageAt=i(3,"eth_getStorageAt"),o.prototype.call=i(2,"eth_call"),o.prototype.protocolVersion=a("eth_protocolVersion"),o.prototype.syncing=a("eth_syncing"),o.prototype.coinbase=a("eth_coinbase"),o.prototype.mining=a("eth_mining"),o.prototype.hashrate=a("eth_hashrate"),o.prototype.gasPrice=a("eth_gasPrice"),o.prototype.accounts=a("eth_accounts"),o.prototype.blockNumber=a("eth_blockNumber"),o.prototype.getBlockTransactionCountByHash=a("eth_getBlockTransactionCountByHash"),o.prototype.getBlockTransactionCountByNumber=a("eth_getBlockTransactionCountByNumber"),o.prototype.getUncleCountByBlockHash=a("eth_getUncleCountByBlockHash"),o.prototype.getUncleCountByBlockNumber=a("eth_getUncleCountByBlockNumber"),o.prototype.sign=a("eth_sign"),o.prototype.sendTransaction=a("eth_sendTransaction"),o.prototype.sendRawTransaction=a("eth_sendRawTransaction"),o.prototype.estimateGas=a("eth_estimateGas"),o.prototype.getBlockByHash=a("eth_getBlockByHash"),o.prototype.getBlockByNumber=a("eth_getBlockByNumber"),o.prototype.getTransactionByHash=a("eth_getTransactionByHash"),o.prototype.getTransactionByBlockHashAndIndex=a("eth_getTransactionByBlockHashAndIndex"),o.prototype.getTransactionByBlockNumberAndIndex=a("eth_getTransactionByBlockNumberAndIndex"),o.prototype.getTransactionReceipt=a("eth_getTransactionReceipt"),o.prototype.getUncleByBlockHashAndIndex=a("eth_getUncleByBlockHashAndIndex"),o.prototype.getUncleByBlockNumberAndIndex=a("eth_getUncleByBlockNumberAndIndex"),o.prototype.getCompilers=a("eth_getCompilers"),o.prototype.compileLLL=a("eth_compileLLL"),o.prototype.compileSolidity=a("eth_compileSolidity"),o.prototype.compileSerpent=a("eth_compileSerpent"),o.prototype.newFilter=a("eth_newFilter"),o.prototype.newBlockFilter=a("eth_newBlockFilter"),o.prototype.newPendingTransactionFilter=a("eth_newPendingTransactionFilter"),o.prototype.uninstallFilter=a("eth_uninstallFilter"),o.prototype.getFilterChanges=a("eth_getFilterChanges"),o.prototype.getFilterLogs=a("eth_getFilterLogs"),o.prototype.getLogs=a("eth_getLogs"),o.prototype.getWork=a("eth_getWork"),o.prototype.submitWork=a("eth_submitWork"),o.prototype.submitHashrate=a("eth_submitHashrate"),o.prototype.sendAsync=function(e,t){var n;this.currentProvider.sendAsync((n=e,s({id:r(),jsonrpc:"2.0",params:[]},n)),function(e,n){let r=e;return!e&&n.error&&(r=new Error(`EthQuery - RPC Error - ${n.error.message}`)),r?t(r):t(null,n.result)})}}}},{package:"@metamask/controller-utils>@metamask/eth-query",file:"node_modules/@metamask/eth-query/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/encryption.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",tweetnacl:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tweetnacl/nacl-fast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.getEncryptionPublicKey=n.decryptSafely=n.decrypt=n.encryptSafely=n.encrypt=void 0;const a=e("@scure/base"),i=o(e("tweetnacl")),c=e("./utils");function m({publicKey:e,data:t,version:n}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(n))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===n){if("string"!=typeof t)throw new Error("Message data must be given as a string");const n=i.box.keyPair();let r;try{r=a.base64.decode(e)}catch(e){throw new Error("Bad public key")}const s=a.utf8.decode(t),o=i.randomBytes(i.box.nonceLength),c=i.box(s,o,r,n.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:a.base64.encode(o),ephemPublicKey:a.base64.encode(n.publicKey),ciphertext:a.base64.encode(c)}}throw new Error("Encryption type/version not supported")}function d({encryptedData:e,privateKey:n}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(n))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const r=t.from(n,"hex"),s=i.box.keyPair.fromSecretKey(r).secretKey,o=a.base64.decode(e.nonce),c=a.base64.decode(e.ciphertext),m=a.base64.decode(e.ephemPublicKey),d=i.box.open(c,o,m,s);try{if(!d)throw new Error;const e=a.utf8.encode(d);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}n.encrypt=m,n.encryptSafely=function({publicKey:e,data:n,version:r}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(n))throw new Error("Missing data parameter");if((0,c.isNullish)(r))throw new Error("Missing version parameter");if("object"==typeof n&&n&&"toJSON"in n)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const s={data:n,padding:""},o=t.byteLength(JSON.stringify(s),"utf-8")%2048;let a=0;return o>0&&(a=2048-o-16),s.padding="0".repeat(a),m({publicKey:e,data:JSON.stringify(s),version:r})},n.decrypt=d,n.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(d({encryptedData:e,privateKey:t})).data},n.getEncryptionPublicKey=function(e){const n=t.from(e,"hex"),r=i.box.keyPair.fromSecretKey(n).publicKey;return a.base64.encode(r)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/encryption.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js",{"./encryption":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/encryption.js","./personal-sign":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/personal-sign.js","./sign-eip7702-authorization":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js","./sign-typed-data":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.normalize=n.concatSig=void 0,s(e("./personal-sign"),n),s(e("./sign-typed-data"),n),s(e("./encryption"),n),s(e("./sign-eip7702-authorization"),n);var o=e("./utils");Object.defineProperty(n,"concatSig",{enumerable:!0,get:function(){return o.concatSig}}),Object.defineProperty(n,"normalize",{enumerable:!0,get:function(){return o.normalize}})}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/personal-sign.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.extractPublicKey=n.recoverPersonalSignature=n.personalSign=void 0;const r=e("@ethereumjs/util"),s=e("./utils");function o(e,t){const n=(0,r.hashPersonalMessage)((0,s.legacyToBuffer)(e));return(0,s.recoverPublicKey)(n,t)}n.personalSign=function({privateKey:e,data:t}){if((0,s.isNullish)(t))throw new Error("Missing data parameter");if((0,s.isNullish)(e))throw new Error("Missing privateKey parameter");const n=(0,s.legacyToBuffer)(t),o=(0,r.hashPersonalMessage)(n),a=(0,r.ecsign)(o,e);return(0,s.concatSig)((0,r.toBuffer)(a.v),a.r,a.s)},n.recoverPersonalSignature=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");const n=o(e,t),a=(0,r.publicToAddress)(n);return(0,r.bufferToHex)(a)},n.extractPublicKey=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");return`0x${o(e,t).toString("hex")}`}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashEIP7702Authorization=n.recoverEIP7702Authorization=n.signEIP7702Authorization=void 0;const r=e("@ethereumjs/rlp"),s=e("@ethereumjs/util"),o=e("@metamask/utils"),a=e("ethereum-cryptography/keccak"),i=e("./utils");function c(e){m(e);const n=(0,r.encode)(e),s=t.concat([t.from("05","hex"),n]);return t.from((0,a.keccak256)(s))}function m(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,n,r]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(n))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(r))throw new Error("Missing nonce parameter")}n.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(m(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const n=c(t),{r:r,s:o,v:a}=(0,s.ecsign)(n,e),d=(0,s.toBuffer)(a);return(0,i.concatSig)(d,r,o)},n.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(m(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const n=c(t),r=(0,i.recoverPublicKey)(n,e),a=(0,s.publicToAddress)(r);return(0,o.bytesToHex)(a)},n.hashEIP7702Authorization=c}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/index.js","@metamask/abi-utils/dist/parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/parsers/index.js","@metamask/abi-utils/dist/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.recoverTypedSignature=n.signTypedData=n.typedSignatureHash=n.TypedDataUtils=n.TYPED_MESSAGE_SCHEMA=n.SignTypedDataVersion=void 0;const r=e("@ethereumjs/util"),s=e("@metamask/abi-utils"),o=e("@metamask/abi-utils/dist/parsers"),a=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),c=e("ethereum-cryptography/keccak"),m=e("./utils");var d;function u(e,t){if(!Object.keys(d).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function l(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const n=BigInt(t),r=(0,o.getLength)(e),s=BigInt(2)**BigInt(r)-BigInt(1);return(0,i.assert)(n>=-s&&n<=s,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),n}function h(e){let t=BigInt(0);for(let n=0;n<e.length;n++){const r=BigInt(e.charCodeAt(n)-48);t*=BigInt(10),t+=r>=49?r-BigInt(49)+BigInt(10):r>=17?r-BigInt(17)+BigInt(10):r}return(0,a.padStart)((0,i.bigIntToBytes)(t),20)}function f(e,t,n,o,m){if(u(m,[d.V3,d.V4]),e[n]!==undefined)return["bytes32",m===d.V4&&null==o?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,r.arrToBufArr)((0,c.keccak256)(p(n,o,e,m)))];if("function"===n)throw new Error('Unsupported or invalid type: "function"');if(o===undefined)throw new Error(`missing value for field ${t} of type ${n}`);if("address"===n){if("number"==typeof o)return["address",(0,a.padStart)((0,i.numberToBytes)(o),20)];if((0,i.isStrictHexString)(o))return["address",(0,i.add0x)(o)];if("string"==typeof o)return["address",h(o).subarray(0,20)]}if("bool"===n)return["bool",Boolean(o)];if("bytes"===n)return"number"==typeof o?o=(0,i.numberToBytes)(o):(0,i.isStrictHexString)(o)||"0x"===o?o=(0,i.hexToBytes)(o):"string"==typeof o&&(o=(0,i.stringToBytes)(o)),["bytes32",(0,r.arrToBufArr)((0,c.keccak256)(o))];if(n.startsWith("bytes")&&"bytes"!==n&&!n.includes("["))return"number"==typeof o?o<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(o))]:(0,i.isStrictHexString)(o)?["bytes32",(0,i.hexToBytes)(o)]:["bytes32",o];if(n.startsWith("int")&&!n.includes("[")){const e=l(n,o);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===n)return o="number"==typeof o?(0,i.numberToBytes)(o):(0,i.stringToBytes)(null!=o?o:""),["bytes32",(0,r.arrToBufArr)((0,c.keccak256)(o))];if(n.endsWith("]")){if(m===d.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const a=n.slice(0,n.lastIndexOf("[")),i=o.map(n=>f(e,t,a,n,m));return["bytes32",(0,r.arrToBufArr)((0,c.keccak256)((0,s.encode)(i.map(([e])=>e),i.map(([,e])=>e))))]}return[n,o]}function p(e,t,n,o){u(o,[d.V3,d.V4]);const a=["bytes32"],i=[b(e,n)];for(const r of n[e]){if(o===d.V3&&t[r.name]===undefined)continue;const[e,s]=f(n,r.name,r.type,t[r.name],o);a.push(e),i.push(s)}return(0,r.arrToBufArr)((0,s.encode)(a,i))}function g(e,t){let n="";const r=y(e,t);r.delete(e);const s=[e,...Array.from(r).sort()];for(const e of s){if(!t[e])throw new Error(`No type definition specified: ${e}`);n+=`${e}(${t[e].map(({name:e,type:t})=>`${t} ${e}`).join(",")})`}return n}function y(e,t,n=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const r=e.match(/^\w*/u);if([e]=r,n.has(e)||t[e]===undefined)return n;n.add(e);for(const r of t[e])y(r.type,t,n);return n}function k(e,t,n,s){u(s,[d.V3,d.V4]);const o=p(e,t,n,s),a=(0,c.keccak256)(o);return(0,r.arrToBufArr)(a)}function b(e,t){const n=(0,i.stringToBytes)(g(e,t));return(0,r.arrToBufArr)((0,c.keccak256)(n))}function x(e){const t={};for(const r in n.TYPED_MESSAGE_SCHEMA.properties)e[r]&&(t[r]=e[r]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function w(e,t){u(t,[d.V3,d.V4]);const n=x(e),{domain:r}=n;return k("EIP712Domain",r,{EIP712Domain:n.types.EIP712Domain},t)}function _(e,t){if((0,o.isArrayType)(e)&&Array.isArray(t)){const[n]=(0,o.getArrayType)(e);return t.map(e=>_(n,e))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,a.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,a.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const n=(0,o.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,n);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,n);if(t instanceof Uint8Array)return t.subarray(0,n)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const n=(0,o.getLength)(e);return BigInt.asIntN(n,BigInt(t))}return t}function v(e,t){return t.map(t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const n=l(e,t);if(n>=BigInt(0))return(0,a.padStart)((0,i.bigIntToBytes)(n),32);const r=(0,o.getLength)(e),s=BigInt.asIntN(r,n);return(0,i.signedBigIntToBytes)(s,32)}return t})}function E(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const n=e.map(({name:e,type:t,value:n})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(r=n,r.map(e=>"number"==typeof e?(0,a.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,a.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,a.padStart)(e.subarray(0,32),32):e))};var r;if(t.startsWith("int")&&(0,o.isArrayType)(t)){const[r,s]=(0,o.getArrayType)(t);return{name:e,type:`bytes32[${null!=s?s:""}]`,value:v(r,n)}}return{name:e,type:t,value:_(t,n)}}),d=n.map(e=>"bytes"!==e.type?e.value:(0,m.legacyToBuffer)(e.value)),u=n.map(e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type}),l=e.map(e=>{if(!e.name)throw t;return`${e.type} ${e.name}`});return(0,r.arrToBufArr)((0,c.keccak256)((0,s.encodePacked)(["bytes32","bytes32"],[(0,c.keccak256)((0,s.encodePacked)(["string[]"],[l],!0)),(0,c.keccak256)((0,s.encodePacked)(u,d,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(d=n.SignTypedDataVersion||(n.SignTypedDataVersion={})),n.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},n.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:y,hashStruct:k,hashType:b,sanitizeData:x,eip712Hash:function(e,t){u(t,[d.V3,d.V4]);const n=x(e),s=[(0,i.hexToBytes)("1901")];return s.push(w(e,t)),"EIP712Domain"!==n.primaryType&&s.push(k(n.primaryType,n.message,n.types,t)),(0,r.arrToBufArr)((0,c.keccak256)((0,i.concatBytes)(s)))},eip712DomainHash:w},n.typedSignatureHash=function(e){const t=E(e);return(0,i.bytesToHex)(t)},n.signTypedData=function({privateKey:e,data:t,version:s}){if(u(s),(0,m.isNullish)(t))throw new Error("Missing data parameter");if((0,m.isNullish)(e))throw new Error("Missing private key parameter");const o=s===d.V1?E(t):n.TypedDataUtils.eip712Hash(t,s),a=(0,r.ecsign)(o,e);return(0,m.concatSig)((0,r.arrToBufArr)((0,i.bigIntToBytes)(a.v)),a.r,a.s)},n.recoverTypedSignature=function({data:e,signature:t,version:s}){if(u(s),(0,m.isNullish)(e))throw new Error("Missing data parameter");if((0,m.isNullish)(t))throw new Error("Missing signature parameter");const o=s===d.V1?E(e):n.TypedDataUtils.eip712Hash(e,s),a=(0,m.recoverPublicKey)(o,t),c=(0,r.publicToAddress)(a);return(0,i.bytesToHex)(c)}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.normalize=n.recoverPublicKey=n.concatSig=n.legacyToBuffer=n.isNullish=n.padWithZeroes=void 0;const r=e("@ethereumjs/util"),s=e("@metamask/utils");function o(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function a(e){return null===e||e===undefined}n.padWithZeroes=o,n.isNullish=a,n.legacyToBuffer=function(e){return"string"!=typeof e||(0,r.isHexString)(e)?(0,r.toBuffer)(e):t.from(e)},n.concatSig=function(e,t,n){const a=(0,r.fromSigned)(t),i=(0,r.fromSigned)(n),c=(0,r.bufferToInt)(e),m=o((0,r.toUnsigned)(a).toString("hex"),64),d=o((0,r.toUnsigned)(i).toString("hex"),64),u=(0,s.remove0x)((0,s.numberToHex)(c));return(0,s.add0x)(m.concat(d,u))},n.recoverPublicKey=function(e,t){const n=(0,r.fromRpcSig)(t);return(0,r.ecrecover)(e,n.v,n.r,n.s)},n.normalize=function(e){if(a(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,s.numberToBytes)(e);e=(0,s.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,s.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(Array.isArray(e)){const t=[];let n=0;for(let s=0;s<e.length;s++){const o=r(e[s]);t.push(o),n+=o.length}return h(a(n,192),...t)}const t=y(e);return 1===t.length&&t[0]<128?t:h(a(t.length,128),t)}function s(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function o(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return u(d(e))}function a(e,t){if(e<56)return Uint8Array.from([e+t]);const n=p(e),r=p(t+55+n.length/2);return Uint8Array.from(l(r+n))}function i(e,t=!1){if(null==e||0===e.length)return Uint8Array.from([]);const n=c(y(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function c(e){let t,n,r,a,i;const m=[],d=e[0];if(d<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(d<=183){if(t=d-127,r=128===d?Uint8Array.from([]):s(e,1,t),2===t&&r[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:r,remainder:e.slice(t)}}if(d<=191){if(n=d-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=o(s(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return r=s(e,n,t+n),{data:r,remainder:e.slice(t+n)}}if(d<=247){for(t=d-191,a=s(e,1,t);a.length;)i=c(a),m.push(i.data),a=i.remainder;return{data:m,remainder:e.slice(t)}}{if(n=d-246,t=o(s(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const r=n+t;if(r>e.length)throw new Error("invalid RLP: total length is larger than the data");for(a=s(e,n,r);a.length;)i=c(a),m.push(i.data),a=i.remainder;return{data:m,remainder:e.slice(r)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.RLP=n.utils=n.decode=n.encode=void 0,n.encode=r,n.decode=i;const m=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function d(e){let t="";for(let n=0;n<e.length;n++)t+=m[e[n]];return t}function u(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function l(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const r=2*n;t[n]=u(e.slice(r,r+2))}return t}function h(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,r=0;t<e.length;t++){const s=e[t];n.set(s,r),r+=s.length}return n}function f(e){return(new TextEncoder).encode(e)}function p(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function g(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function y(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return g(e)?l((t="string"!=typeof(n=e)?n:g(n)?n.slice(2):n).length%2?`0${t}`:t):f(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?l(p(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:d,concatBytes:h,hexToBytes:l,utf8ToBytes:f},n.RLP={encode:r,decode:i}}}},{package:"@metamask/eth-sig-util>@ethereumjs/rlp",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.accountBodyToRLP=n.accountBodyToSlim=n.accountBodyFromSlim=n.isZeroAddress=n.zeroAddress=n.importPublic=n.privateToAddress=n.privateToPublic=n.publicToAddress=n.pubToAddress=n.isValidPublic=n.isValidPrivate=n.generateAddress2=n.generateAddress=n.isValidChecksumAddress=n.toChecksumAddress=n.isValidAddress=n.Account=void 0;const r=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),o=e("ethereum-cryptography/secp256k1"),a=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),m=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,n=c.KECCAK256_RLP,r=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=n,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:n,storageRoot:r,codeHash:s}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,n!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(n)):undefined,r!==undefined?(0,i.toBuffer)(r):undefined,s!==undefined?(0,i.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,n,r,s]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(n),r,s)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(c.KECCAK256_NULL)}}n.Account=l;n.isValidAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};n.toChecksumAddress=function(e,n){(0,m.assertIsHexString)(e);const r=(0,d.stripHexPrefix)(e).toLowerCase();let o="";if(n!==undefined){o=(0,i.bufferToBigInt)((0,i.toBuffer)(n)).toString()+"0x"}const c=t.from(o+r,"utf8"),u=(0,a.bytesToHex)((0,s.keccak256)(c));let l="0x";for(let e=0;e<r.length;e++)parseInt(u[e],16)>=8?l+=r[e].toUpperCase():l+=r[e];return l};n.isValidChecksumAddress=function(e,t){return(0,n.isValidAddress)(e)&&(0,n.toChecksumAddress)(e,t)===e};n.generateAddress=function(e,n){return(0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,i.bufferToBigInt)(n)===BigInt(0)?t.from((0,s.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,n])))).slice(-20)};n.generateAddress2=function(e,n,r){if((0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,m.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==n.length)throw new Error("Expected salt to be of length 32");const o=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,n,(0,s.keccak256)(r)]));return(0,i.toBuffer)(o).slice(-20)};n.isValidPrivate=function(e){return o.secp256k1.utils.isValidPrivateKey(e)};n.isValidPublic=function(e,n=!1){if((0,m.assertIsBuffer)(e),64===e.length)try{return o.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!n)return!1;try{return o.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};n.pubToAddress=function(e,n=!1){if((0,m.assertIsBuffer)(e),n&&64!==e.length&&(e=t.from(o.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},n.publicToAddress=n.pubToAddress;n.privateToPublic=function(e){return(0,m.assertIsBuffer)(e),t.from(o.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};n.privateToAddress=function(e){return(0,n.publicToAddress)((0,n.privateToPublic)(e))};n.importPublic=function(e){return(0,m.assertIsBuffer)(e),64!==e.length&&(e=t.from(o.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};n.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function h(e){const[t,n,r,s]=e;return[t,n,0===(0,i.arrToBufArr)(r).length?c.KECCAK256_RLP:r,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}n.isZeroAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return(0,n.zeroAddress)()===e},n.accountBodyFromSlim=h;const f=new Uint8Array(0);n.accountBodyToSlim=function(e){const[t,n,r,s]=e;return[t,n,(0,i.arrToBufArr)(r).equals(c.KECCAK256_RLP)?f:r,(0,i.arrToBufArr)(s).equals(c.KECCAK256_NULL)?f:s]},n.accountBodyToRLP=function(e,t=!0){const n=t?h(e):e;return(0,i.arrToBufArr)(r.RLP.encode(n))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Address=void 0;const r=e("./account"),s=e("./bytes");class o{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new o((0,s.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new o((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const n=(0,r.pubToAddress)(e);return new o(n)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const n=(0,r.privateToAddress)(e);return new o(n)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new o((0,r.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,n,s){if(!t.isBuffer(n))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new o((0,r.generateAddress2)(e.buf,n,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(o.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),n=BigInt("0xffff");return e>=t&&e<=n}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}n.Address=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncEventEmitter=void 0;const r=e("events");class s extends r.EventEmitter{emit(e,...t){let[n,r]=t;const s=this;let o=s._events[e]??[];return r===undefined&&"function"==typeof n&&(r=n,n=undefined),"newListener"!==e&&"removeListener"!==e||(n={event:n,fn:r},r=undefined),o=Array.isArray(o)?o:[o],async function(e,t,n){let r;for await(const s of t)try{s.length<2?s.call(e,n):await new Promise((t,r)=>{s.call(e,n,e=>{e?r(e):t()})})}catch(e){r=e}if(r)throw r}(s,o.slice(),n).then(r).catch(r),s.listenerCount(e)>0}once(e,t){const n=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(s,o){n.removeListener(e,r),t(s,o)}:function(s){n.removeListener(e,r),t(s,r)},n.on(e,r),n}first(e,t){let n=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(n)||(this._events[e]=n=[n]),n.unshift(t),this}before(e,t,n){return this.beforeOrAfter(e,t,n)}after(e,t,n){return this.beforeOrAfter(e,t,n,"after")}beforeOrAfter(e,t,n,r){let s,o,a=this._events[e]??[];const i="after"===r?1:0;if("function"!=typeof n)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(a)||(this._events[e]=a=[a]),o=a.length,s=a.length;s--;)if(a[s]===t){o=s+i;break}return a.splice(o,0,n),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}n.AsyncEventEmitter=s}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.intToUnpaddedBuffer=n.bigIntToUnpaddedBuffer=n.bigIntToHex=n.bufArrToArr=n.arrToBufArr=n.validateNoLeadingZeroes=n.baToJSON=n.toUtf8=n.short=n.addHexPrefix=n.toUnsigned=n.fromSigned=n.bufferToInt=n.bigIntToBuffer=n.bufferToBigInt=n.bufferToHex=n.toBuffer=n.unpadHexString=n.unpadArray=n.unpadBuffer=n.setLengthRight=n.setLengthLeft=n.zeros=n.intToBuffer=n.intToHex=void 0;const r=e("./helpers"),s=e("./internal");n.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};n.intToBuffer=function(e){const r=(0,n.intToHex)(e);return t.from((0,s.padToEven)(r.slice(2)),"hex")};n.zeros=function(e){return t.allocUnsafe(e).fill(0)};const o=function(e,t,r){const s=(0,n.zeros)(t);return r?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};n.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),o(e,t,!1)};n.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),o(e,t,!0)};const a=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};n.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),a(e)};n.unpadArray=function(e){return(0,r.assertIsArray)(e),a(e)};n.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+a(e)};n.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,n.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let n=e.toString(16);return n.length%2&&(n="0"+n),t.from(n,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,n.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,n.toBuffer)("0x"+e.toString(16))}n.bufferToHex=function(e){return"0x"+(e=(0,n.toBuffer)(e)).toString("hex")},n.bufferToBigInt=i,n.bigIntToBuffer=c;n.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};n.fromSigned=function(e){return BigInt.asIntN(256,i(e))};n.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};n.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},n.short=function(e,n=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=n?r:r.slice(0,n)+"…"};n.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};n.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,n.baToJSON)(e[r]));return t}};n.validateNoLeadingZeroes=function(e){for(const[t,n]of Object.entries(e))if(n!==undefined&&n.length>0&&0===n[0])throw new Error(`${t} cannot have leading zeroes, received: ${n.toString("hex")}`)},n.arrToBufArr=function e(n){return Array.isArray(n)?n.map(t=>e(t)):t.from(n)},n.bufArrToArr=function e(t){return Array.isArray(t)?t.map(t=>e(t)):Uint8Array.from(t??[])};n.bigIntToHex=e=>"0x"+e.toString(16),n.bigIntToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)(c(e))},n.intToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)((0,n.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAX_WITHDRAWALS_PER_PAYLOAD=n.RLP_EMPTY_STRING=n.KECCAK256_RLP=n.KECCAK256_RLP_S=n.KECCAK256_RLP_ARRAY=n.KECCAK256_RLP_ARRAY_S=n.KECCAK256_NULL=n.KECCAK256_NULL_S=n.TWO_POW256=n.SECP256K1_ORDER_DIV_2=n.SECP256K1_ORDER=n.MAX_INTEGER_BIGINT=n.MAX_INTEGER=n.MAX_UINT64=void 0;const r=e("buffer"),s=e("ethereum-cryptography/secp256k1");n.MAX_UINT64=BigInt("0xffffffffffffffff"),n.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),n.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),n.SECP256K1_ORDER=s.secp256k1.CURVE.n,n.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),n.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),n.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",n.KECCAK256_NULL=r.Buffer.from(n.KECCAK256_NULL_S,"hex"),n.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",n.KECCAK256_RLP_ARRAY=r.Buffer.from(n.KECCAK256_RLP_ARRAY_S,"hex"),n.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",n.KECCAK256_RLP=r.Buffer.from(n.KECCAK256_RLP_S,"hex"),n.RLP_EMPTY_STRING=r.Buffer.from([128]),n.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compactBytesToNibbles=n.bytesToNibbles=n.nibblesToCompactBytes=n.nibblesToBytes=n.hasTerminator=void 0;n.hasTerminator=e=>e.length>0&&16===e[e.length-1];n.nibblesToBytes=(e,t)=>{for(let n=0,r=0;r<e.length;n+=1,r+=2)t[n]=e[r]<<4|e[r+1]};n.nibblesToCompactBytes=e=>{let t=0;(0,n.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,n.nibblesToBytes)(e,r.subarray(1)),r};n.bytesToNibbles=e=>{const t=2*e.length+1,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];n[2*t]=r/16,n[2*t+1]=r%16}return n[t-1]=16,n};n.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,n.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.assertIsString=n.assertIsArray=n.assertIsBuffer=n.assertIsHexString=void 0;const r=e("./internal");n.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};n.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};n.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};n.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.toAscii=n.stripHexPrefix=n.padToEven=n.isHexString=n.isHexPrefixed=n.getKeys=n.getBinarySize=n.fromUtf8=n.fromAscii=n.arrayContainsArray=void 0,s(e("./constants"),n),s(e("./units"),n),s(e("./account"),n),s(e("./address"),n),s(e("./withdrawal"),n),s(e("./signature"),n),s(e("./bytes"),n),s(e("./types"),n),s(e("./encoding"),n),s(e("./asyncEventEmitter"),n);var o=e("./internal");Object.defineProperty(n,"arrayContainsArray",{enumerable:!0,get:function(){return o.arrayContainsArray}}),Object.defineProperty(n,"fromAscii",{enumerable:!0,get:function(){return o.fromAscii}}),Object.defineProperty(n,"fromUtf8",{enumerable:!0,get:function(){return o.fromUtf8}}),Object.defineProperty(n,"getBinarySize",{enumerable:!0,get:function(){return o.getBinarySize}}),Object.defineProperty(n,"getKeys",{enumerable:!0,get:function(){return o.getKeys}}),Object.defineProperty(n,"isHexPrefixed",{enumerable:!0,get:function(){return o.isHexPrefixed}}),Object.defineProperty(n,"isHexString",{enumerable:!0,get:function(){return o.isHexString}}),Object.defineProperty(n,"padToEven",{enumerable:!0,get:function(){return o.padToEven}}),Object.defineProperty(n,"stripHexPrefix",{enumerable:!0,get:function(){return o.stripHexPrefix}}),Object.defineProperty(n,"toAscii",{enumerable:!0,get:function(){return o.toAscii}}),s(e("./lock"),n),s(e("./provider"),n)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(n,"__esModule",{value:!0}),n.isHexString=n.getKeys=n.fromAscii=n.fromUtf8=n.toAscii=n.arrayContainsArray=n.getBinarySize=n.padToEven=n.stripHexPrefix=n.isHexPrefixed=void 0,n.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}n.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},n.padToEven=r,n.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},n.arrayContainsArray=function(e,t,n){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===n?"some":"every"](t=>e.indexOf(t)>=0)},n.toAscii=function(e){let t="",n=0;const r=e.length;for("0x"===e.substring(0,2)&&(n=2);n<r;n+=2){const r=parseInt(e.substr(n,2),16);t+=String.fromCharCode(r)}return t},n.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},n.fromAscii=function(e){let t="";for(let n=0;n<e.length;n++){const r=e.charCodeAt(n).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},n.getKeys=function(e,t,n){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let s=0;s<e.length;s++){let o=e[s][t];if(!0!==n||o){if("string"!=typeof o)throw new Error("invalid abi - expected type 'string', received "+typeof o)}else o="";r.push(o)}return r},n.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Lock=void 0;n.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise(e=>this.promiseResolverQueue.push(e))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getProvider=n.fetchFromProvider=void 0;const r=e("micro-ftch");n.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;n.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashPersonalMessage=n.isValidSignature=n.fromRpcSig=n.toCompactSig=n.toRpcSig=n.ecrecover=n.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),o=e("./bytes"),a=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function m(e){return e===BigInt(0)||e===BigInt(1)}n.ecsign=function(e,n,r){const o=s.secp256k1.sign(e,n),a=o.toCompactRawBytes();return{r:t.from(a.slice(0,32)),s:t.from(a.slice(32,64)),v:r===undefined?BigInt(o.recovery+27):BigInt(o.recovery+35)+BigInt(r)*BigInt(2)}};n.ecrecover=function(e,n,r,a,i){const d=t.concat([(0,o.setLengthLeft)(r,32),(0,o.setLengthLeft)(a,32)],64),u=c(n,i);if(!m(u))throw new Error("Invalid signature v value");const l=s.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};n.toRpcSig=function(e,n,r,s){if(!m(c(e,s)))throw new Error("Invalid signature v value");return(0,o.bufferToHex)(t.concat([(0,o.setLengthLeft)(n,32),(0,o.setLengthLeft)(r,32),(0,o.toBuffer)(e)]))};n.toCompactSig=function(e,n,r,s){if(!m(c(e,s)))throw new Error("Invalid signature v value");let a=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(a=t.from(r),a[0]|=128),(0,o.bufferToHex)(t.concat([(0,o.setLengthLeft)(n,32),(0,o.setLengthLeft)(a,32)]))};n.fromRpcSig=function(e){const t=(0,o.toBuffer)(e);let n,r,s;if(t.length>=65)n=t.slice(0,32),r=t.slice(32,64),s=(0,o.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");n=t.slice(0,32),r=t.slice(32,64),s=BigInt((0,o.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:n,s:r}};n.isValidSignature=function(e,t,n,r=!0,s){if(32!==t.length||32!==n.length)return!1;if(!m(c(e,s)))return!1;const i=(0,o.bufferToBigInt)(t),d=(0,o.bufferToBigInt)(n);return!(i===BigInt(0)||i>=a.SECP256K1_ORDER||d===BigInt(0)||d>=a.SECP256K1_ORDER)&&!(r&&d>=a.SECP256K1_ORDER_DIV_2)};n.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const n=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([n,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toType=n.TypeOutput=void 0;const r=e("./bytes"),s=e("./internal");var o;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(o=n.TypeOutput||(n.TypeOutput={})),n.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const n=(0,r.toBuffer)(e);switch(t){case o.Buffer:return n;case o.BigInt:return(0,r.bufferToBigInt)(n);case o.Number:{const e=(0,r.bufferToBigInt)(n);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case o.PrefixedHexString:return(0,r.bufferToHex)(n);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.GWEI_TO_WEI=void 0,n.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Withdrawal=void 0;const r=e("./address"),s=e("./bytes"),o=e("./types");class a{constructor(e,t,n,r){this.index=e,this.validatorIndex=t,this.address=n,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:n,address:s,amount:i}=e,c=(0,o.toType)(t,o.TypeOutput.BigInt),m=(0,o.toType)(n,o.TypeOutput.BigInt),d=new r.Address((0,o.toType)(s,o.TypeOutput.Buffer)),u=(0,o.toType)(i,o.TypeOutput.BigInt);return new a(c,m,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,n,r,s]=e;return a.fromWithdrawalData({index:t,validatorIndex:n,address:r,amount:s})}static toBufferArray(e){const{index:n,validatorIndex:s,address:a,amount:i}=e,c=(0,o.toType)(n,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(n,o.TypeOutput.Buffer),m=(0,o.toType)(s,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(s,o.TypeOutput.Buffer);let d;d=a instanceof r.Address?a.buf:(0,o.toType)(a,o.TypeOutput.Buffer);return[c,m,d,(0,o.toType)(i,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(i,o.TypeOutput.Buffer)]}raw(){return a.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}n.Withdrawal=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function s(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function o(...e){const t=e=>e,n=(e,t)=>n=>e(t(n));return{encode:e.map(e=>e.encode).reduceRight(n,t),decode:e.map(e=>e.decode).reduce(n,t)}}function a(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map(t=>{if(r(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]})},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map(t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const n=e.indexOf(t);if(-1===n)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return n})}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(r(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(n){if(!Array.isArray(n)||n.length&&"string"!=typeof n[0])throw new Error("padding.encode input should be array of strings");for(let e of n)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;n.length*e%8;)n.push(t);return n},decode(n){if(!Array.isArray(n)||n.length&&"string"!=typeof n[0])throw new Error("padding.encode input should be array of strings");for(let e of n)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let r=n.length;if(r*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;r>0&&n[r-1]===t;r--)if(!((r-1)*e%8))throw new Error("Invalid padding: string has too much padding");return n.slice(0,r)}}}function m(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function d(e,t,n){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(n<2)throw new Error(`convertRadix: wrong to=${n}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let s=0;const o=[],a=Array.from(e);for(a.forEach(e=>{if(r(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)});;){let e=0,r=!0;for(let o=s;o<a.length;o++){const i=a[o],c=t*e+i;if(!Number.isSafeInteger(c)||t*e/t!==e||c-i!==t*e)throw new Error("convertRadix: carry overflow");e=c%n;const m=Math.floor(c/n);if(a[o]=m,!Number.isSafeInteger(m)||m*n+e!==c)throw new Error("convertRadix: carry overflow");r&&(m?r=!1:s=o)}if(o.push(e),r)break}for(let t=0;t<e.length-1&&0===e[t];t++)o.push(0);return o.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(n,"__esModule",{value:!0}),n.bytes=n.stringToBytes=n.str=n.bytesToString=n.hex=n.utf8=n.bech32m=n.bech32=n.base58check=n.createBase58check=n.base58xmr=n.base58xrp=n.base58flickr=n.base58=n.base64urlnopad=n.base64url=n.base64nopad=n.base64=n.base32crockford=n.base32hexnopad=n.base32hex=n.base32nopad=n.base32=n.base16=n.utils=void 0,n.assertNumber=r;const u=(e,t)=>t?u(t,e%t):e,l=(e,t)=>e+(t-u(e,t));function h(e,t,n,s){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(n<=0||n>32)throw new Error(`convertRadix2: wrong to=${n}`);if(l(t,n)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${n} carryBits=${l(t,n)}`);let o=0,a=0;const i=2**n-1,c=[];for(const s of e){if(r(s),s>=2**t)throw new Error(`convertRadix2: invalid data word=${s} from=${t}`);if(o=o<<t|s,a+t>32)throw new Error(`convertRadix2: carry overflow pos=${a} from=${t}`);for(a+=t;a>=n;a-=n)c.push((o>>a-n&i)>>>0);o&=2**a-1}if(o=o<<n-a&i,!s&&a>=t)throw new Error("Excess padding");if(!s&&o)throw new Error(`Non-zero padding: ${o}`);return s&&a>0&&c.push(o>>>0),c}function f(e){return r(e),{encode:t=>{if(!s(t))throw new Error("radix.encode input should be Uint8Array");return d(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(d(t,e,256))}}}function p(e,t=!1){if(r(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(l(8,e)>32||l(e,8)>32)throw new Error("radix2: carry overflow");return{encode:n=>{if(!s(n))throw new Error("radix2.encode input should be Uint8Array");return h(Array.from(n),8,e,!t)},decode:n=>{if(!Array.isArray(n)||n.length&&"number"!=typeof n[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(h(n,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function y(e,t){if(r(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(n){if(!s(n))throw new Error("checksum.encode: input should be Uint8Array");const r=t(n).slice(0,e),o=new Uint8Array(n.length+e);return o.set(n),o.set(r,n.length),o},decode(n){if(!s(n))throw new Error("checksum.decode: input should be Uint8Array");const r=n.slice(0,-e),o=t(r).slice(0,e),a=n.slice(-e);for(let t=0;t<e;t++)if(o[t]!==a[t])throw new Error("Invalid checksum");return r}}}n.utils={alphabet:a,chain:o,checksum:y,convertRadix:d,convertRadix2:h,radix:f,radix2:p,join:i,padding:c},n.base16=o(p(4),a("0123456789ABCDEF"),i("")),n.base32=o(p(5),a("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),i("")),n.base32nopad=o(p(5),a("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),n.base32hex=o(p(5),a("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),i("")),n.base32hexnopad=o(p(5),a("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),n.base32crockford=o(p(5),a("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),m(e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1"))),n.base64=o(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),i("")),n.base64nopad=o(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),n.base64url=o(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),i("")),n.base64urlnopad=o(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const k=e=>o(f(58),a(e),i(""));n.base58=k("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),n.base58flickr=k("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),n.base58xrp=k("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const b=[0,2,3,5,6,7,9,10,11];n.base58xmr={encode(e){let t="";for(let r=0;r<e.length;r+=8){const s=e.subarray(r,r+8);t+=n.base58.encode(s).padStart(b[s.length],"1")}return t},decode(e){let t=[];for(let r=0;r<e.length;r+=11){const s=e.slice(r,r+11),o=b.indexOf(s.length),a=n.base58.decode(s);for(let e=0;e<a.length-o;e++)if(0!==a[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(a.slice(a.length-o)))}return Uint8Array.from(t)}};n.createBase58check=e=>o(y(4,t=>e(e(t))),n.base58),n.base58check=n.createBase58check;const x=o(a("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),w=[996825010,642813549,513874426,1027748829,705979059];function _(e){const t=e>>25;let n=(33554431&e)<<5;for(let e=0;e<w.length;e++)1==(t>>e&1)&&(n^=w[e]);return n}function v(e,t,n=1){const r=e.length;let s=1;for(let t=0;t<r;t++){const n=e.charCodeAt(t);if(n<33||n>126)throw new Error(`Invalid prefix (${e})`);s=_(s)^n>>5}s=_(s);for(let t=0;t<r;t++)s=_(s)^31&e.charCodeAt(t);for(let e of t)s=_(s)^e;for(let e=0;e<6;e++)s=_(s);return s^=n,x.encode(h([s%2**30],30,5,!1))}function E(e){const t="bech32"===e?1:734539939,n=p(5),r=n.decode,s=n.encode,o=g(r);function a(e,n,r=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(n instanceof Uint8Array&&(n=Array.from(n)),!Array.isArray(n)||n.length&&"number"!=typeof n[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof n);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const s=e.length+7+n.length;if(!1!==r&&s>r)throw new TypeError(`Length ${s} exceeds limit ${r}`);const o=e.toLowerCase(),a=v(o,n,t);return`${o}1${x.encode(n)}${a}`}function i(e,n=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==n&&e.length>n)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${n})`);const r=e.toLowerCase();if(e!==r&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const s=r.lastIndexOf("1");if(0===s||-1===s)throw new Error('Letter "1" must be present between prefix and data only');const o=r.slice(0,s),a=r.slice(s+1);if(a.length<6)throw new Error("Data must be at least 6 characters long");const i=x.decode(a).slice(0,-6),c=v(o,i,t);if(!a.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:o,words:i}}return{encode:a,decode:i,encodeFromBytes:function(e,t){return a(e,s(t))},decodeToBytes:function(e){const{prefix:t,words:n}=i(e,!1);return{prefix:t,words:n,bytes:r(n)}},decodeUnsafe:g(i),fromWords:r,fromWordsUnsafe:o,toWords:s}}n.bech32=E("bech32"),n.bech32m=E("bech32m"),n.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},n.hex=o(p(4),a("0123456789abcdef"),i(""),m(e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()}));const j={utf8:n.utf8,hex:n.hex,base16:n.base16,base32:n.base32,base64:n.base64,base64url:n.base64url,base58:n.base58,base58xmr:n.base58xmr},T="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";n.bytesToString=(e,t)=>{if("string"!=typeof e||!j.hasOwnProperty(e))throw new TypeError(T);if(!s(t))throw new TypeError("bytesToString() expects Uint8Array");return j[e].encode(t)},n.str=n.bytesToString;n.stringToBytes=(e,t)=>{if(!j.hasOwnProperty(e))throw new TypeError(T);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return j[e].decode(t)},n.bytes=n.stringToBytes}}},{package:"@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/index.cjs",{"./simple-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=e("./simple-keyring.cjs");Object.defineProperty(n,"default",{enumerable:!0,get:function(){return r(s).default}})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js",randombytes:"/home/runner/work/metamask-extension/metamask-extension/node_modules/randombytes/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r,s,o,a,i=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},c=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},m=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0});const d=e("@ethereumjs/util"),u=e("@metamask/eth-sig-util"),l=e("@metamask/utils"),h=e("ethereum-cryptography/keccak"),f=m(e("randombytes")),p="Simple Key Pair";class g{constructor(e=[]){r.add(this),s.set(this,void 0),this.type=p,i(this,s,[],"f"),this.deserialize(e).catch(e=>{throw new Error(`Problem deserializing SimpleKeyring ${e.message}`)})}async serialize(){return c(this,s,"f").map(e=>e.privateKey.toString("hex"))}async deserialize(e){i(this,s,e.map(e=>{const n=(0,d.stripHexPrefix)(e),r=t.from(n,"hex");return{privateKey:r,publicKey:t.from((0,d.privateToPublic)(r))}}),"f")}async addAccounts(e=1){const n=[];for(let r=0;r<e;r++){const e=y(),r=t.from((0,d.privateToPublic)(e));n.push({privateKey:e,publicKey:r})}i(this,s,c(this,s,"f").concat(n),"f");return n.map(({publicKey:e})=>(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(e))))}async getAccounts(){return c(this,s,"f").map(({publicKey:e})=>(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(e))))}async signTransaction(e,t,n={}){const s=c(this,r,"m",o).call(this,e,n);return t.sign(s)??t}async signEip7702Authorization(e,t,n={}){const s=c(this,r,"m",o).call(this,e,n);return(0,u.signEIP7702Authorization)({privateKey:s,authorization:t})}async signMessage(e,n,s={withAppKeyOrigin:"",validateMessage:!0}){const a=(0,d.stripHexPrefix)(n);if(s.validateMessage&&(0===a.length||!a.match(/^[a-fA-F0-9]*$/u)))throw new Error("Cannot sign invalid message");const i=c(this,r,"m",o).call(this,e,s),m=(0,d.ecsign)(t.from(a,"hex"),i);return(0,u.concatSig)(t.from((0,l.bigIntToBytes)(m.v)),t.from(m.r),t.from(m.s))}async signPersonalMessage(e,t,n={withAppKeyOrigin:""}){const s=c(this,r,"m",o).call(this,e,n);return(0,u.personalSign)({privateKey:s,data:t})}async decryptMessage(e,t){const n=c(this,r,"m",a).call(this,e).privateKey.toString("hex");return(0,u.decrypt)({privateKey:n,encryptedData:t})}async signTypedData(e,t,n){let{version:s}=n??{version:u.SignTypedDataVersion.V1};s&&function(e){return e in u.SignTypedDataVersion}(s)||(s=u.SignTypedDataVersion.V1);const a=c(this,r,"m",o).call(this,e,n);return(0,u.signTypedData)({privateKey:a,data:t,version:s})}async getEncryptionPublicKey(e,t){const n=c(this,r,"m",o).call(this,e,t);return(0,u.getEncryptionPublicKey)(n.toString("hex"))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const n=c(this,r,"m",a).call(this,e,{withAppKeyOrigin:t});return(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(n.publicKey)))}async exportAccount(e,t={withAppKeyOrigin:""}){return c(this,r,"m",a).call(this,e,t).privateKey.toString("hex")}removeAccount(e){if(!c(this,s,"f").map(({publicKey:e})=>(0,l.bytesToHex)((0,d.publicToAddress)(e)).toLowerCase()).includes(e.toLowerCase()))throw new Error(`Address ${e} not found in this keyring`);i(this,s,c(this,s,"f").filter(({publicKey:t})=>(0,l.bytesToHex)((0,d.publicToAddress)(t)).toLowerCase()!==e.toLowerCase()),"f")}}function y(){const e=(0,f.default)(32);if(!(0,d.isValidPrivate)(e))throw new Error("Private key does not satisfy the curve requirements (ie. it is invalid)");return e}s=new WeakMap,r=new WeakSet,o=function(e,t={withAppKeyOrigin:""}){if(!e)throw new Error("Must specify address.");return c(this,r,"m",a).call(this,e,t).privateKey},a=function(e,n={}){const r=(0,u.normalize)(e);let o=c(this,s,"f").find(({publicKey:e})=>(0,l.bytesToHex)((0,d.publicToAddress)(e))===r);if(!o)throw new Error("Simple Keyring - Unable to find matching address.");if(n.withAppKeyOrigin){const{privateKey:e}=o,r=t.from(n.withAppKeyOrigin,"utf8"),s=t.concat([e,r]),a=(0,h.keccak256)(s),i=(0,d.privateToPublic)(a);o={privateKey:t.from(a),publicKey:t.from(i)}}return o},g.type=p,n.default=g}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/CaseInsensitiveMap.cjs",{"./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/util.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CaseInsensitiveMap=void 0;const r=e("./util.cjs");class s extends Map{static fromObject(e){return new s(Object.entries(e))}toObject(){return Object.fromEntries(this.entries())}get(e){return super.get(e.toLowerCase())}getOrThrow(e,t="Key"){return this.get(e)??(0,r.throwError)(`${t} '${e}' not found`)}has(e){return super.has(e.toLowerCase())}set(e,t){return super.set(e.toLowerCase(),t)}delete(e){return super.delete(e.toLowerCase())}}n.CaseInsensitiveMap=s}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/CaseInsensitiveMap.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/DeferredPromise.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DeferredPromise=void 0;n.DeferredPromise=class{constructor(){if(this.resolve=undefined,this.reject=undefined,this.promise=new Promise((e,t)=>{this.resolve=e,this.reject=t}),!this.resolve||!this.reject)throw new Error("Promise constructor failed")}}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/DeferredPromise.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapIdMap.cjs",{"./CaseInsensitiveMap.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/CaseInsensitiveMap.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.SnapIdMap=n.InvalidSnapIdError=void 0;const a=e("./CaseInsensitiveMap.cjs");class i extends Error{constructor(e,t){super(`Snap "${e}" is not allowed to set "${t}"`),this.name="InvalidSnapIdError",this.snapId=e,this.key=t}}n.InvalidSnapIdError=i;class c{constructor(e){r.set(this,void 0),s(this,r,new a.CaseInsensitiveMap(e),"f")}toObject(){return o(this,r,"f").toObject()}static fromObject(e){return new c(Object.entries(e))}get(e,t){const n=o(this,r,"f").get(t);return n?.snapId===e?n:undefined}getSnapId(e){return o(this,r,"f").get(e)?.snapId}pop(e,t){const n=this.get(e,t);return this.delete(e,t),n}has(e,t){return this.get(e,t)!==undefined}hasSnapId(e){return[...o(this,r,"f").values()].some(t=>t.snapId===e)}delete(e,t){return this.has(e,t)&&o(this,r,"f").delete(t)}set(e,t){if(o(this,r,"f").has(e)&&!this.has(t.snapId,e))throw new i(t.snapId,e);return o(this,r,"f").set(e,t),this}values(){return o(this,r,"f").values()}get size(){return o(this,r,"f").size}}n.SnapIdMap=c,r=new WeakMap}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/SnapIdMap.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapKeyring.cjs",{"./DeferredPromise.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/DeferredPromise.cjs","./SnapIdMap.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapIdMap.cjs","./SnapKeyringMessenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapKeyringMessenger.cjs","./account.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs","./events.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/events.cjs","./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/logger.cjs","./migrations/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs","./options.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/options.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/types.cjs","./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/util.cjs","./versions.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/versions.cjs","@ethereumjs/tx":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/tx/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-internal-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/index.cjs","@metamask/keyring-internal-snap-client":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-snap-client/dist/index.cjs","@metamask/keyring-snap-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-sdk/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i,c,m,d,u,l,h,f,p,g,y,k,b,x,w,_,v,E,j,T,A,C,P,B,I,D,S,R,O,F,M,N,q,L,U,K=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},$=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.SnapKeyring=n.SNAP_KEYRING_TYPE=void 0;const H=e("@ethereumjs/tx"),G=e("@metamask/eth-sig-util"),V=e("@metamask/keyring-api"),W=e("@metamask/keyring-internal-api"),Y=e("@metamask/keyring-internal-snap-client"),z=e("@metamask/keyring-snap-sdk"),J=e("@metamask/keyring-utils"),X=e("@metamask/superstruct"),Q=e("@metamask/utils"),Z=e("uuid"),ee=e("./account.cjs"),te=e("./DeferredPromise.cjs"),ne=e("./events.cjs"),re=e("./logger.cjs"),se=e("./migrations/index.cjs"),oe=e("./options.cjs"),ae=e("./SnapIdMap.cjs"),ie=e("./SnapKeyringMessenger.cjs"),ce=e("./types.cjs"),me=e("./util.cjs"),de=e("./versions.cjs");function ue(e){return(0,V.isEvmAccountType)(e.type)?e.address.toLowerCase():e.address}n.SNAP_KEYRING_TYPE="Snap Keyring";class le{constructor({messenger:e,callbacks:t,isAnyAccountTypeAllowed:n=!1}){r.add(this),this.name=ie.SNAP_KEYRING_NAME,this.state=null,s.set(this,void 0),o.set(this,void 0),a.set(this,void 0),i.set(this,void 0),c.set(this,void 0),m.set(this,void 0),d.set(this,void 0),u.set(this,void 0),this.type=le.type,K(this,s,e,"f"),K(this,o,new Y.KeyringInternalSnapClient({messenger:e}),"f"),K(this,c,new ae.SnapIdMap,"f"),K(this,a,new ae.SnapIdMap,"f"),K(this,m,new ae.SnapIdMap,"f"),K(this,d,t,"f"),K(this,u,n,"f"),K(this,i,new Map,"f")}async handleKeyringSnapMessage(e,t){switch((0,X.assert)(t,ce.SnapMessageStruct),t.method){case`${V.KeyringEvent.AccountCreated}`:return $(this,r,"m",f).call(this,e,t);case`${V.KeyringEvent.AccountUpdated}`:return $(this,r,"m",p).call(this,e,t);case`${V.KeyringEvent.AccountDeleted}`:return $(this,r,"m",g).call(this,e,t);case`${V.KeyringEvent.RequestApproved}`:return $(this,r,"m",k).call(this,e,t);case`${V.KeyringEvent.RequestRejected}`:return $(this,r,"m",b).call(this,e,t);case`${V.KeyringEvent.AccountBalancesUpdated}`:return $(this,r,"m",w).call(this,e,t);case`${V.KeyringEvent.AccountAssetListUpdated}`:return $(this,r,"m",_).call(this,e,t);case`${V.KeyringEvent.AccountTransactionsUpdated}`:return $(this,r,"m",v).call(this,e,t);case`${z.SnapManageAccountsMethod.GetSelectedAccounts}`:return $(this,r,"m",y).call(this,e,t);default:throw new Error(`Method not supported: ${t.method}`)}}async serialize(){return{accounts:$(this,a,"f").toObject()}}async deserialize(e){if(e===undefined)return;const t={};for(const[n,r]of Object.entries(e.accounts))(0,se.isAccountV1)(r.account)?(console.info(`SnapKeyring - Found a KeyringAccountV1, migrating to V2: ${r.account.id}`),t[n]={...r,account:(0,se.migrateAccountV1)(r.account)}):t[n]=r;K(this,a,ae.SnapIdMap.fromObject(t),"f")}async getAccounts(){return(0,me.unique)([...$(this,a,"f").values()].map(({account:e})=>ue(e)))}async getAccountsBySnapId(e){return(0,me.unique)([...$(this,a,"f").values()].filter(({snapId:t})=>t===e).map(({account:e})=>ue(e)))}async createAccount(e,t,n){const r=new Y.KeyringInternalSnapClient({messenger:$(this,s,"f"),snapId:e}),o="metamask";if((0,Q.hasProperty)(t,o))throw new Error(`The '${o}' property is reserved for internal use`);if(!n)return await r.createAccount(t);const a=(0,Z.v4)();return $(this,m,"f").set(a,{snapId:e,options:n}),await r.createAccount({...t,metamask:{correlationId:a}})}hasSnapId(e){return $(this,a,"f").hasSnapId(e)}async resolveAccountAddress(e,t,n){if(!this.hasSnapId(e))throw new Error(`Unable to resolve account address: unknown Snap ID: ${e}`);return await $(this,o,"f").withSnapId(e).resolveAccountAddress(t,n)}async submitRequest({origin:e,account:t,method:n,params:s,scope:o}){const{account:a,snapId:i}=$(this,r,"m",E).call(this,t);return await $(this,r,"m",A).call(this,{origin:e,snapId:i,account:a,method:n,params:s,scope:o,noPending:!0})}async signTransaction(e,t,n={}){const s=t.common.chainId(),o=(0,me.toJson)({...t.toJSON(),from:e,type:`0x${t.type.toString(16)}`,chainId:(0,Q.bigIntToHex)(s)}),a=await $(this,r,"m",j).call(this,{origin:"metamask",address:e,method:V.EthMethod.SignTransaction,params:[o],scope:(0,Q.toCaipChainId)(Q.KnownCaipNamespace.Eip155,`${s}`)}),i=(0,X.mask)(a,(0,X.object)({r:(0,X.string)(),s:(0,X.string)(),v:(0,X.string)()}));return H.TransactionFactory.fromTxData({...o,r:i.r,s:i.s,v:i.v})}async signTypedData(e,t,n={version:G.SignTypedDataVersion.V1}){const s={[G.SignTypedDataVersion.V1]:V.EthMethod.SignTypedDataV1,[G.SignTypedDataVersion.V3]:V.EthMethod.SignTypedDataV3,[G.SignTypedDataVersion.V4]:V.EthMethod.SignTypedDataV4}[n.version]||V.EthMethod.SignTypedDataV1,o=t.domain?.chainId;return(0,J.strictMask)(await $(this,r,"m",j).call(this,{origin:"metamask",address:e,method:s,params:(0,me.toJson)([e,t]),...o===undefined?{}:{scope:(0,Q.toCaipChainId)(Q.KnownCaipNamespace.Eip155,`${o}`)}}),V.EthBytesStruct)}async signMessage(e,t){return(0,J.strictMask)(await $(this,r,"m",j).call(this,{origin:"metamask",address:e,method:V.EthMethod.Sign,params:(0,me.toJson)([e,t])}),V.EthBytesStruct)}async signPersonalMessage(e,t){return(0,J.strictMask)(await $(this,r,"m",j).call(this,{origin:"metamask",address:e,method:V.EthMethod.PersonalSign,params:(0,me.toJson)([t,e])}),V.EthBytesStruct)}async prepareUserOperation(e,t,n){return(0,J.strictMask)(await $(this,r,"m",j).call(this,{origin:"metamask",address:e,method:V.EthMethod.PrepareUserOperation,params:(0,me.toJson)(t),noPending:!0,scope:(0,Q.toCaipChainId)(Q.KnownCaipNamespace.Eip155,n.chainId)}),V.EthBaseUserOperationStruct)}async patchUserOperation(e,t,n){return(0,J.strictMask)(await $(this,r,"m",j).call(this,{origin:"metamask",address:e,method:V.EthMethod.PatchUserOperation,params:(0,me.toJson)([t]),noPending:!0,scope:(0,Q.toCaipChainId)(Q.KnownCaipNamespace.Eip155,n.chainId)}),V.EthUserOperationPatchStruct)}async signUserOperation(e,t,n){return(0,J.strictMask)(await $(this,r,"m",j).call(this,{origin:"metamask",address:e,method:V.EthMethod.SignUserOperation,params:(0,me.toJson)([t]),scope:(0,Q.toCaipChainId)(Q.KnownCaipNamespace.Eip155,n.chainId)}),V.EthBytesStruct)}exportAccount(e){throw new Error("Exporting accounts from snaps is not supported.")}async removeAccount(e){const{account:t,snapId:n}=$(this,r,"m",F).call(this,e);await $(this,r,"m",O).call(this,n,t)}async setSelectedAccounts(e){$(this,r,"m",M).call(this,e);const t=[...$(this,i,"f").entries()];await Promise.all(t.map(async([e,t])=>{try{await $(this,o,"f").withSnapId(e).setSelectedAccounts(t)}catch(t){console.error(`Failed to set selected accounts for ${e} snap: '${t.message}'`)}}))}getAccountByAddress(e){const t=[...$(this,a,"f").values()].find(({account:{address:t}})=>(0,me.equalsIgnoreCase)(t,e));return t?$(this,r,"m",U).call(this,t.account,t.snapId):undefined}listAccounts(){return[...$(this,a,"f").values()].map(({account:e,snapId:t})=>$(this,r,"m",U).call(this,e,t))}}n.SnapKeyring=le,s=new WeakMap,o=new WeakMap,a=new WeakMap,i=new WeakMap,c=new WeakMap,m=new WeakMap,d=new WeakMap,u=new WeakMap,r=new WeakSet,l=function(e){return(0,de.getKeyringVersionFromPlatform)(t=>$(this,s,"f").call("SnapController:isMinimumPlatformVersion",e,t))},h=function(e,t){if(t){const n=$(this,m,"f").pop(e,t);if(n)return n.options;console.warn(`SnapKeyring - Received unmapped correlation ID: "${t}"`)}return undefined},f=async function(e,t){(0,X.assert)(t,ne.AccountCreatedEventStruct);const{metamask:n,account:s,accountNameSuggestion:o,displayAccountNameSuggestion:i,displayConfirmation:c}=t.params,m=(0,ee.transformAccount)(s),l=ue(m);if(!$(this,u,"f")&&m.type===V.AnyAccountType.Account)throw new Error(`Cannot create generic account '${m.id}'`);const f=$(this,a,"f").get(e,m.id);if(f&&ue(f.account)===l)return null;if(await $(this,d,"f").addressExists(l))throw new Error(`Account address '${l}' already exists`);if($(this,a,"f").has(e,m.id))throw new Error(`Account '${m.id}' already exists`);const p=new te.DeferredPromise;return await $(this,d,"f").addAccount(l,e,async t=>{t&&($(this,a,"f").set(m.id,{account:m,snapId:e}),$(this,d,"f").saveState().then(()=>{p.resolve(m.id)}).catch(async t=>{await $(this,r,"m",O).call(this,e,m),p.reject(t)}))},p.promise,o,(0,oe.getInternalOptionsOf)([$(this,r,"m",h).call(this,e,n?.correlationId)??{},{displayConfirmation:c,displayAccountNameSuggestion:i}])),null},p=async function(e,t){(0,X.assert)(t,ne.AccountUpdatedEventStruct);const{account:n}=t.params,{account:r}=$(this,a,"f").get(e,n.id)??(0,me.throwError)(`Account '${n.id}' not found`),s=(0,ee.transformAccount)(n),o=s.type===V.AnyAccountType.Account||r.type===V.AnyAccountType.Account;if(!$(this,u,"f")&&o)throw new Error(`Cannot update generic account '${s.id}'`);if(!(0,me.equalsIgnoreCase)(r.address,s.address))throw new Error(`Cannot change address of account '${s.id}'`);return $(this,a,"f").set(s.id,{account:s,snapId:e}),await $(this,d,"f").saveState(),null},g=async function(e,t){(0,X.assert)(t,ne.AccountDeletedEventStruct);const{id:n}=t.params,r=$(this,a,"f").get(e,n);if(r===undefined)return null;const{account:s}=r;return await $(this,d,"f").removeAccount(ue(s),e,async e=>{e&&await $(this,d,"f").saveState()}),null},y=async function(e,t){return(0,X.assert)(t,z.GetSelectedAccountsRequestStruct),$(this,i,"f").get(e)??[]},k=async function(e,t){(0,X.assert)(t,ne.RequestApprovedEventStruct);const{id:n,result:r}=t.params,{promise:s}=$(this,c,"f").get(e,n)??(0,me.throwError)(`Request '${n}' not found`);return $(this,c,"f").delete(e,n),s.resolve(r),null},b=async function(e,t){(0,X.assert)(t,ne.RequestRejectedEventStruct);const{id:n}=t.params,{promise:r}=$(this,c,"f").get(e,n)??(0,me.throwError)(`Request '${n}' not found`);return $(this,c,"f").delete(e,n),r.reject(new Error("Request rejected by user or snap.")),null},x=async function(e,t,n){return $(this,s,"f").publish(t,...n(n=>Object.entries(n).reduce((n,[r,s])=>($(this,a,"f").has(e,r)?n[r]=s:console.warn(`SnapKeyring - ${t} - Found an unknown account ID "${r}" for Snap ID "${e}". Skipping.`),n),{}))),null},w=async function(e,t){(0,X.assert)(t,V.AccountBalancesUpdatedEventStruct);const n=t.params;return $(this,r,"m",x).call(this,e,"SnapKeyring:accountBalancesUpdated",e=>(n.balances=e(n.balances),[n]))},_=async function(e,t){(0,X.assert)(t,V.AccountAssetListUpdatedEventStruct);const n=t.params;return $(this,r,"m",x).call(this,e,"SnapKeyring:accountAssetListUpdated",e=>(n.assets=e(n.assets),[n]))},v=async function(e,t){(0,X.assert)(t,V.AccountTransactionsUpdatedEventStruct);const n=t.params;return $(this,r,"m",x).call(this,e,"SnapKeyring:accountTransactionsUpdated",e=>(n.transactions=e(n.transactions),[n]))},E=function(e){const t=[...$(this,a,"f").values()].find(t=>t.account.id===e);if(!t)throw new Error(`Unable to get account: unknown account ID: '${e}'`);return t},j=async function({origin:e,address:t,method:n,params:s,scope:o="",noPending:a=!1}){const{account:i,snapId:c}=$(this,r,"m",F).call(this,t);return await $(this,r,"m",A).call(this,{origin:e,snapId:c,account:i,method:n,params:s,scope:o,noPending:a})},T=async function({snapId:e,version:t,request:n}){const r=$(this,o,"f").withSnapId(e);return t===W.KeyringVersion.V1?await r.submitRequestV1((0,W.toKeyringRequestV1)(n)):await r.submitRequest(n)},A=async function({origin:e,snapId:t,account:n,method:s,params:o,scope:a,noPending:i}){if(!$(this,r,"m",C).call(this,n,s))throw new Error(`Method '${s}' not supported for account ${n.address}`);if(!e?.trim())throw new Error("An `origin` is required");const c=(0,Z.v4)(),m=$(this,r,"m",P).call(this,c,t);try{const d=$(this,r,"m",l).call(this,t),u={id:c,origin:e,scope:a,account:n.id,request:{method:s,...o!==undefined&&{params:o}}};(0,re.projectLogger)("Submit Snap request: ",u);const h=await $(this,r,"m",T).call(this,{version:d,snapId:t,request:u});if(i&&h.pending)throw new Error(`Request '${c}' to Snap '${t}' is pending and noPending is true.`);return h.pending?((h.redirect?.message||h.redirect?.url)&&await $(this,r,"m",D).call(this,h.redirect,t),m.promise):$(this,r,"m",I).call(this,h,c,t)}catch(e){throw(0,re.projectLogger)("Snap Request failed: ",{requestId:c}),$(this,r,"m",B).call(this,c,t),e}},C=function(e,t){return e.methods.includes(t)},P=function(e,t){const n=new te.DeferredPromise;return $(this,c,"f").set(e,{promise:n,snapId:t}),n},B=function(e,t){$(this,c,"f").delete(t,e)},I=function(e,t,n){return $(this,c,"f").delete(n,t),e.result},D=async function(e,t){const{message:n="",url:s=""}=e,o=$(this,r,"m",S).call(this,s);o&&$(this,r,"m",R).call(this,o,t),await $(this,d,"f").redirectUser(t,o,n)},S=function(e){return e?(0,me.sanitizeUrl)(e):e},R=function(e,t){const{origin:n}=new URL(e),s=$(this,r,"m",N).call(this,t);if(!s)throw new Error(`Snap '${t}' not found.`);if(!$(this,r,"m",L).call(this,s).includes(n))throw new Error(`Redirect URL domain '${n}' is not an allowed origin by snap '${t}'`)},O=async function(e,t){$(this,a,"f").delete(e,t.id);try{await $(this,o,"f").withSnapId(e).deleteAccount(t.id)}catch(n){console.error(`Account '${t.address}' may not have been removed from snap '${e}':`,n)}},F=function(e){return[...$(this,a,"f").values()].find(({account:t})=>(0,me.equalsIgnoreCase)(t.address,e))??(0,me.throwError)(`Account '${e}' not found`)},M=function(e){const t=$(this,i,"f");t.clear();for(const n of e){const e=$(this,a,"f").getSnapId(n);if(!e)continue;const r=t.get(e)??[];r.push(n),t.set(e,r)}},N=function(e){return $(this,s,"f").call("SnapController:get",e)},q=function(e){const t=$(this,r,"m",N).call(this,e);return t?{id:e,name:t.manifest.proposedName,enabled:t.enabled}:undefined},L=function(e){return e.manifest.initialPermissions["endowment:keyring"]?.allowedOrigins??[]},U=function(e,t){const n=$(this,r,"m",q).call(this,t);return{...e,address:ue(e),metadata:{name:"",importTime:0,keyring:{type:this.type},...n!==undefined&&{snap:n}}}},le.type=n.SNAP_KEYRING_TYPE}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/SnapKeyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapKeyringMessenger.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SNAP_KEYRING_NAME=void 0,n.SNAP_KEYRING_NAME="SnapKeyring"}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/SnapKeyringMessenger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs",{"./migrations/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountV1Struct=void 0,n.assertKeyringAccount=a,n.transformAccount=function(e){return a((0,o.isAccountV1)(e)?(0,o.transformAccountV1)(e):e)};const r=e("@metamask/keyring-api"),s=e("@metamask/superstruct"),o=e("./migrations/index.cjs");function a(e){switch(e.type){case r.BtcAccountType.P2pkh:return(0,s.assert)(e,r.BtcP2pkhAccountStruct),e;case r.BtcAccountType.P2sh:return(0,s.assert)(e,r.BtcP2shAccountStruct),e;case r.BtcAccountType.P2wpkh:return(0,s.assert)(e,r.BtcP2wpkhAccountStruct),e;case r.BtcAccountType.P2tr:return(0,s.assert)(e,r.BtcP2trAccountStruct),e;case r.SolAccountType.DataAccount:return(0,s.assert)(e,r.SolDataAccountStruct),e;case r.EthAccountType.Erc4337:return(0,s.assert)(e,r.EthErc4337AccountStruct),e;case r.EthAccountType.Eoa:return(0,s.assert)(e,r.EthEoaAccountStruct),e;case r.TrxAccountType.Eoa:return(0,s.assert)(e,r.TrxEoaAccountStruct),e;case r.AnyAccountType.Account:return(0,s.assert)(e,r.KeyringAccountStruct),e;default:throw new Error(`Unknown account type: '${e.type}'`)}}n.KeyringAccountV1Struct=(0,s.omit)(r.KeyringAccountStruct,["scopes"])}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/account.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/events.cjs",{"./account.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RequestRejectedEventStruct=n.RequestApprovedEventStruct=n.AccountDeletedEventStruct=n.AccountUpdatedEventStruct=n.AccountCreatedEventStruct=void 0;const r=e("@metamask/keyring-api");Object.defineProperty(n,"AccountDeletedEventStruct",{enumerable:!0,get:function(){return r.AccountDeletedEventStruct}}),Object.defineProperty(n,"RequestApprovedEventStruct",{enumerable:!0,get:function(){return r.RequestApprovedEventStruct}}),Object.defineProperty(n,"RequestRejectedEventStruct",{enumerable:!0,get:function(){return r.RequestRejectedEventStruct}});const s=e("@metamask/keyring-utils"),o=e("@metamask/superstruct"),a=e("./account.cjs");n.AccountCreatedEventStruct=(0,s.object)({...r.AccountCreatedEventStruct.schema,params:(0,s.object)({...r.AccountCreatedEventStruct.schema.params.schema,account:(0,o.union)([a.KeyringAccountV1Struct,r.KeyringAccountStruct])})}),n.AccountUpdatedEventStruct=(0,s.object)({...r.AccountUpdatedEventStruct.schema,params:(0,s.object)({...r.AccountUpdatedEventStruct.schema.params.schema,account:(0,o.union)([a.KeyringAccountV1Struct,r.KeyringAccountStruct])})})}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/events.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/index.cjs",{"./SnapKeyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapKeyring.cjs","./options.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/options.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./options.cjs"),n),s(e("./types.cjs"),n),s(e("./SnapKeyring.cjs"),n)}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("eth-snap-keyring")}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs",{"./v1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/v1.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./v1.cjs"),n)}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/v1.cjs",{"../account.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isAccountV1=i,n.getScopesForAccountV1=c,n.transformAccountV1=function(e){const{type:t}=e;if(t===r.EthAccountType.Eoa)return{...e,scopes:c(e)};return(0,a.assertKeyringAccount)(e)},n.migrateAccountV1=function(e){if(!i(e))return e;return{...e,scopes:c(e)}};const r=e("@metamask/keyring-api"),s=e("@metamask/keyring-utils"),o=e("@metamask/superstruct"),a=e("../account.cjs");function i(e){return(0,o.is)(e,a.KeyringAccountV1Struct)}function c(e){switch(e.type){case r.EthAccountType.Eoa:return[r.EthScope.Eoa];case r.EthAccountType.Erc4337:return[r.EthScope.Testnet];case r.BtcAccountType.P2pkh:case r.BtcAccountType.P2sh:case r.BtcAccountType.P2wpkh:case r.BtcAccountType.P2tr:return[(0,s.isBtcMainnetAddress)(e.address)?r.BtcScope.Mainnet:r.BtcScope.Testnet];case r.SolAccountType.DataAccount:return[r.SolScope.Mainnet,r.SolScope.Testnet,r.SolScope.Devnet];case r.TrxAccountType.Eoa:return[r.TrxScope.Mainnet,r.TrxScope.Nile,r.TrxScope.Shasta];default:return[r.EthScope.Eoa]}}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/migrations/v1.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/options.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(){return{displayAccountNameSuggestion:!0,displayConfirmation:!0,setSelectedAccount:!0}}Object.defineProperty(n,"__esModule",{value:!0}),n.getDefaultInternalOptions=r,n.getInternalOptionsOf=function(e){const t={},n={displayAccountNameSuggestion:!0,displayConfirmation:!0,setSelectedAccount:!0},r=Object.keys(n);for(const s of r){t[s]=undefined;for(const r of[...e,n])r[s]!==undefined&&t[s]===undefined&&(t[s]=r[s])}return t}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/options.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/types.cjs",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SnapMessageStruct=void 0;const r=e("@metamask/superstruct"),s=e("@metamask/utils");n.SnapMessageStruct=(0,r.object)({method:(0,r.string)(),params:(0,r.optional)((0,r.union)([(0,r.array)(s.JsonStruct),(0,r.record)((0,r.string)(),s.JsonStruct)]))})}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/util.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.unique=function(e){return[...new Set(e)]},n.toJson=function(e){return JSON.parse(JSON.stringify(e))},n.ensureDefined=function(e){if(e===undefined)throw new Error("Argument is undefined")},n.throwError=function(e){throw new Error(e)},n.equalsIgnoreCase=function(e,t){return e.toLowerCase()===t.toLowerCase()},n.sanitizeUrl=function(e){return new URL(e).toString()}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/versions.cjs",{"@metamask/keyring-internal-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PLATFORM_VERSION_TO_KEYRING_VERSION=void 0,n.getKeyringVersionFromPlatform=function(e){for(const[t,r]of n.PLATFORM_VERSION_TO_KEYRING_VERSION)if(e(t))return r;return r.KeyringVersion.V1};const r=e("@metamask/keyring-internal-api");n.PLATFORM_VERSION_TO_KEYRING_VERSION=[["7.0.0",r.KeyringVersion.V2]]}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/versions.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return m.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}});var r=l(e("./v1.js")),s=l(e("./v3.js")),o=l(e("./v4.js")),a=l(e("./v5.js")),i=l(e("./nil.js")),c=l(e("./version.js")),m=l(e("./validate.js")),d=l(e("./stringify.js")),u=l(e("./parse.js"));function l(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return 14+(e+64>>>9<<4)+1}function s(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function o(e,t,n,r,o,a){return s((i=s(s(t,e),s(r,a)))<<(c=o)|i>>>32-c,n);var i,c}function a(e,t,n,r,s,a,i){return o(t&n|~t&r,e,t,s,a,i)}function i(e,t,n,r,s,a,i){return o(t&r|n&~r,e,t,s,a,i)}function c(e,t,n,r,s,a,i){return o(t^n^r,e,t,s,a,i)}function m(e,t,n,r,s,a,i){return o(n^(t|~r),e,t,s,a,i)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var d=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,r="0123456789abcdef";for(let s=0;s<n;s+=8){const n=e[s>>5]>>>s%32&255,o=parseInt(r.charAt(n>>>4&15)+r.charAt(15&n),16);t.push(o)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[r(t)-1]=t;let n=1732584193,o=-271733879,d=-1732584194,u=271733878;for(let t=0;t<e.length;t+=16){const r=n,l=o,h=d,f=u;n=a(n,o,d,u,e[t],7,-680876936),u=a(u,n,o,d,e[t+1],12,-389564586),d=a(d,u,n,o,e[t+2],17,606105819),o=a(o,d,u,n,e[t+3],22,-1044525330),n=a(n,o,d,u,e[t+4],7,-176418897),u=a(u,n,o,d,e[t+5],12,1200080426),d=a(d,u,n,o,e[t+6],17,-1473231341),o=a(o,d,u,n,e[t+7],22,-45705983),n=a(n,o,d,u,e[t+8],7,1770035416),u=a(u,n,o,d,e[t+9],12,-1958414417),d=a(d,u,n,o,e[t+10],17,-42063),o=a(o,d,u,n,e[t+11],22,-1990404162),n=a(n,o,d,u,e[t+12],7,1804603682),u=a(u,n,o,d,e[t+13],12,-40341101),d=a(d,u,n,o,e[t+14],17,-1502002290),o=a(o,d,u,n,e[t+15],22,1236535329),n=i(n,o,d,u,e[t+1],5,-165796510),u=i(u,n,o,d,e[t+6],9,-1069501632),d=i(d,u,n,o,e[t+11],14,643717713),o=i(o,d,u,n,e[t],20,-373897302),n=i(n,o,d,u,e[t+5],5,-701558691),u=i(u,n,o,d,e[t+10],9,38016083),d=i(d,u,n,o,e[t+15],14,-660478335),o=i(o,d,u,n,e[t+4],20,-405537848),n=i(n,o,d,u,e[t+9],5,568446438),u=i(u,n,o,d,e[t+14],9,-1019803690),d=i(d,u,n,o,e[t+3],14,-187363961),o=i(o,d,u,n,e[t+8],20,1163531501),n=i(n,o,d,u,e[t+13],5,-1444681467),u=i(u,n,o,d,e[t+2],9,-51403784),d=i(d,u,n,o,e[t+7],14,1735328473),o=i(o,d,u,n,e[t+12],20,-1926607734),n=c(n,o,d,u,e[t+5],4,-378558),u=c(u,n,o,d,e[t+8],11,-2022574463),d=c(d,u,n,o,e[t+11],16,1839030562),o=c(o,d,u,n,e[t+14],23,-35309556),n=c(n,o,d,u,e[t+1],4,-1530992060),u=c(u,n,o,d,e[t+4],11,1272893353),d=c(d,u,n,o,e[t+7],16,-155497632),o=c(o,d,u,n,e[t+10],23,-1094730640),n=c(n,o,d,u,e[t+13],4,681279174),u=c(u,n,o,d,e[t],11,-358537222),d=c(d,u,n,o,e[t+3],16,-722521979),o=c(o,d,u,n,e[t+6],23,76029189),n=c(n,o,d,u,e[t+9],4,-640364487),u=c(u,n,o,d,e[t+12],11,-421815835),d=c(d,u,n,o,e[t+15],16,530742520),o=c(o,d,u,n,e[t+2],23,-995338651),n=m(n,o,d,u,e[t],6,-198630844),u=m(u,n,o,d,e[t+7],10,1126891415),d=m(d,u,n,o,e[t+14],15,-1416354905),o=m(o,d,u,n,e[t+5],21,-57434055),n=m(n,o,d,u,e[t+12],6,1700485571),u=m(u,n,o,d,e[t+3],10,-1894986606),d=m(d,u,n,o,e[t+10],15,-1051523),o=m(o,d,u,n,e[t+1],21,-2054922799),n=m(n,o,d,u,e[t+8],6,1873313359),u=m(u,n,o,d,e[t+15],10,-30611744),d=m(d,u,n,o,e[t+6],15,-1560198380),o=m(o,d,u,n,e[t+13],21,1309151649),n=m(n,o,d,u,e[t+4],6,-145523070),u=m(u,n,o,d,e[t+11],10,-1120210379),d=m(d,u,n,o,e[t+2],15,718787259),o=m(o,d,u,n,e[t+9],21,-343485551),n=s(n,r),o=s(o,l),d=s(d,h),u=s(u,f)}return[n,o,d,u]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(r(t));for(let r=0;r<t;r+=8)n[r>>5]|=(255&e[r/8])<<r%32;return n}(e),8*e.length))};n.default=d}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/native-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=r}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/native-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=o}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let r;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!r&&(r="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!r))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return r(s)};const s=new Uint8Array(16)}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n,r){switch(e){case 0:return t&n^~t&r;case 1:case 3:return t^n^r;case 2:return t&n^t&r^n&r}}function s(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var o=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const o=e.length/4+2,a=Math.ceil(o/16),i=new Array(a);for(let t=0;t<a;++t){const n=new Uint32Array(16);for(let r=0;r<16;++r)n[r]=e[64*t+4*r]<<24|e[64*t+4*r+1]<<16|e[64*t+4*r+2]<<8|e[64*t+4*r+3];i[t]=n}i[a-1][14]=8*(e.length-1)/Math.pow(2,32),i[a-1][14]=Math.floor(i[a-1][14]),i[a-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<a;++e){const o=new Uint32Array(80);for(let t=0;t<16;++t)o[t]=i[e][t];for(let e=16;e<80;++e)o[e]=s(o[e-3]^o[e-8]^o[e-14]^o[e-16],1);let a=n[0],c=n[1],m=n[2],d=n[3],u=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),i=s(a,5)+r(n,c,m,d)+u+t[n]+o[e]>>>0;u=d,d=m,m=s(c,30)>>>0,c=a,a=i}n[0]=n[0]+a>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+m>>>0,n[3]=n[3]+d>>>0,n[4]=n[4]+u>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=o}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=a;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};const o=[];for(let e=0;e<256;++e)o.push((e+256).toString(16).slice(1));function a(e,t=0){return o[e[t+0]]+o[e[t+1]]+o[e[t+2]]+o[e[t+3]]+"-"+o[e[t+4]]+o[e[t+5]]+"-"+o[e[t+6]]+o[e[t+7]]+"-"+o[e[t+8]]+o[e[t+9]]+"-"+o[e[t+10]]+o[e[t+11]]+o[e[t+12]]+o[e[t+13]]+o[e[t+14]]+o[e[t+15]]}var i=function(e,t=0){const n=a(e,t);if(!(0,s.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./rng.js"))&&r.__esModule?r:{default:r},o=e("./stringify.js");let a,i,c=0,m=0;var d=function(e,t,n){let r=t&&n||0;const d=t||new Array(16);let u=(e=e||{}).node||a,l=e.clockseq!==undefined?e.clockseq:i;if(null==u||null==l){const t=e.random||(e.rng||s.default)();null==u&&(u=a=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==l&&(l=i=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),f=e.nsecs!==undefined?e.nsecs:m+1;const p=h-c+(f-m)/1e4;if(p<0&&e.clockseq===undefined&&(l=l+1&16383),(p<0||h>c)&&e.nsecs===undefined&&(f=0),f>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,m=f,i=l,h+=122192928e5;const g=(1e4*(268435455&h)+f)%4294967296;d[r++]=g>>>24&255,d[r++]=g>>>16&255,d[r++]=g>>>8&255,d[r++]=255&g;const y=h/4294967296*1e4&268435455;d[r++]=y>>>8&255,d[r++]=255&y,d[r++]=y>>>24&15|16,d[r++]=y>>>16&255,d[r++]=l>>>8|128,d[r++]=255&l;for(let e=0;e<6;++e)d[r+e]=u[e];return t||(0,o.unsafeStringify)(d)};n.default=d}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./md5.js"));function o(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v3",48,s.default);n.default=a}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function r(e,r,a,i){var c;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof r&&(r=(0,o.default)(r)),16!==(null===(c=r)||void 0===c?void 0:c.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let m=new Uint8Array(16+e.length);if(m.set(r),m.set(e,r.length),m=n(m),m[6]=15&m[6]|t,m[8]=63&m[8]|128,a){i=i||0;for(let e=0;e<16;++e)a[i+e]=m[e];return a}return(0,s.unsafeStringify)(m)}try{r.name=e}catch(e){}return r.DNS=a,r.URL=i,r};var r,s=e("./stringify.js"),o=(r=e("./parse.js"))&&r.__esModule?r:{default:r};const a="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=a;const i="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v4.js",{"./native.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/native-browser.js","./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=a(e("./native.js")),s=a(e("./rng.js")),o=e("./stringify.js");function a(e){return e&&e.__esModule?e:{default:e}}var i=function(e,t,n){if(r.default.randomUUID&&!t&&!e)return r.default.randomUUID();const a=(e=e||{}).random||(e.rng||s.default)();if(a[6]=15&a[6]|64,a[8]=63&a[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=a[e];return t}return(0,o.unsafeStringify)(a)};n.default=i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./sha1.js"));function o(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v5",80,s.default);n.default=a}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./regex.js"))&&r.__esModule?r:{default:r};var o=function(e){return"string"==typeof e&&s.default.test(e)};n.default=o}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=o}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/account-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getAccountLink=n.createCustomAccountLink=n.createAccountLinkForChain=n.createAccountLink=void 0;const s=e("./helpers"),o=r(e("./prefix-for-chain")),a=r(e("./prefix-for-network"));function i(e,t){const n=a.default(t);return null===n?"":`https://${n}etherscan.io/address/${e}`}function c(e,t){const n=o.default(t);return null===n?"":`https://${n}etherscan.io/address/${e}`}function m(e,t){return s.addPathToUrl(t,"address",e)}n.createAccountLink=i,n.createAccountLinkForChain=c,n.createCustomAccountLink=m,n.getAccountLink=function(e,t,n={},r=""){return n.blockExplorerUrl?m(e,n.blockExplorerUrl):r?i(e,r):c(e,t)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/account-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/explorer-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getBlockExplorerLink=n.createExplorerLinkForChain=n.createExplorerLink=n.createCustomExplorerLink=void 0;const s=e("./helpers"),o=r(e("./prefix-for-chain")),a=r(e("./prefix-for-network"));function i(e,t){return s.addPathToUrl(t,"tx",e)}function c(e,t){const n=a.default(t);return null===n?"":`https://${n}etherscan.io/tx/${e}`}function m(e,t){const n=o.default(t);return null===n?"":`https://${n}etherscan.io/tx/${e}`}n.createCustomExplorerLink=i,n.createExplorerLink=c,n.createExplorerLinkForChain=m,n.getBlockExplorerLink=function(e,t={}){return t.blockExplorerUrl?i(e.hash,t.blockExplorerUrl):e.chainId?m(e.hash,e.chainId):c(e.hash,e.metamaskNetworkId)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/explorer-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.addPathToUrl=void 0,n.addPathToUrl=(e,t,n)=>{const{username:r,password:s,protocol:o,host:a,pathname:i,search:c,hash:m}=new URL(e),d=i.endsWith("/")?`${i}${t}/${n}`:`${i}/${t}/${n}`;return new URL(`${o}//${r?`${r}:${s}`:""}${a}${d}${c}${m}`).toString()}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/index.js",{"./account-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/account-link.js","./explorer-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/explorer-link.js","./token-tracker-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/token-tracker-link.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("./account-link"),s=e("./explorer-link"),o=e("./token-tracker-link");t.exports={createExplorerLink:s.createExplorerLink,createCustomExplorerLink:s.createCustomExplorerLink,createExplorerLinkForChain:s.createExplorerLinkForChain,createAccountLink:r.createAccountLink,createCustomAccountLink:r.createCustomAccountLink,createAccountLinkForChain:r.createAccountLinkForChain,createTokenTrackerLink:o.createTokenTrackerLink,createCustomTokenTrackerLink:o.createCustomTokenTrackerLink,createTokenTrackerLinkForChain:o.createTokenTrackerLinkForChain,getBlockExplorerLink:s.getBlockExplorerLink,getAccountLink:r.getAccountLink,getTokenTrackerLink:o.getTokenTrackerLink}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){let t;switch(e){case"0x1":t="";break;case"0x5":t="goerli.";break;case"0xaa36a7":t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){let t;switch(parseInt(e)){case 1:t="";break;case 5:t="goerli.";break;case 11155111:t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/token-tracker-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getTokenTrackerLink=n.createTokenTrackerLinkForChain=n.createCustomTokenTrackerLink=n.createTokenTrackerLink=void 0;const s=e("./helpers"),o=r(e("./prefix-for-chain")),a=r(e("./prefix-for-network"));function i(e,t,n){const r=a.default(t);return null===r?"":`https://${r}etherscan.io/token/${e}${n?`?a=${n}`:""}`}function c(e,t){return s.addPathToUrl(t,"token",e)}function m(e,t,n){const r=o.default(t);return null===r?"":`https://${r}etherscan.io/token/${e}${n?`?a=${n}`:""}`}n.createTokenTrackerLink=i,n.createCustomTokenTrackerLink=c,n.createTokenTrackerLinkForChain=m,n.getTokenTrackerLink=function(e,t,n,r,s={}){return s.blockExplorerUrl?c(e,s.blockExplorerUrl):n?i(e,n,r):m(e,t,r)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/token-tracker-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/contract.js",{"./has-tx-object":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js","@babel/runtime/helpers/asyncToGenerator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/helpers/asyncToGenerator.js","@babel/runtime/helpers/interopRequireDefault":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/helpers/interopRequireDefault.js","@babel/runtime/regenerator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/regenerator/index.js","@metamask/ethjs-filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js","@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","ethjs-abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-abi/lib/index.js","js-sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/js-sha3/src/sha3.js","promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("@babel/runtime/helpers/interopRequireDefault"),s=r(e("@babel/runtime/regenerator")),o=r(e("@babel/runtime/helpers/asyncToGenerator")),a=e("ethjs-abi"),i=e("@metamask/ethjs-filter"),c=e("@metamask/ethjs-util").getKeys,m=e("js-sha3").keccak_256,d=e("promise-to-callback"),u=e("./has-tx-object");t.exports=function(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{},t=this;function n(e){return function(){var t,n=[].slice.call(arguments);"function"==typeof n[n.length-1]&&(t=n.pop());var s=function(e){return r.apply(this,arguments)}({methodObject:e,methodArgs:n});return t?d(s)(t):s}}function r(){return(r=(0,o.default)(s.default.mark(function e(n){var r,o,i,c,m,d,l;return s.default.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return r=n.methodObject,o=n.methodArgs,i="call",c={},u(o)&&(c=o.pop()),(m=Object.assign({},t.defaultTxObject,c,{to:t.address})).data=a.encodeMethod(r,o),!1===r.constant&&(i="sendTransaction"),e.next=9,t.query[i](m);case 9:if(d=e.sent,"call"!==i){e.next=20;break}return e.prev=11,l=a.decodeMethod(r,d),e.abrupt("return",l);case 16:throw e.prev=16,e.t0=e.catch(11),new Error("[ethjs-contract] while formatting incoming raw call data "+JSON.stringify(d)+" "+e.t0);case 20:return e.abrupt("return",d);case 21:case"end":return e.stop()}},e,null,[[11,16]])}))).apply(this,arguments)}t.abi=e.contractABI||[],t.query=e.query,t.address=e.address||"0x",t.bytecode=e.contractBytecode||"0x",t.defaultTxObject=e.contractDefaultTxObject||{},t.filters=new i(t.query),(l=t.abi,l.filter(function(e){return("function"===e.type||"event"===e.type)&&e.name.length>0})).forEach(function(e){"function"===e.type?t[e.name]=n(e):"event"===e.type&&(t[e.name]=function(e){return function(){var n=[].slice.call(arguments),r=c(e.inputs,"type",!1),s=["0x"+m(e.name+"("+r.join(",")+")")],o=Object.assign({},n[0])||{},i=Object.assign({},n[0]||{},{to:t.address,topics:s}),d=Object.assign({},o,{decoder:function(t){return a.decodeEvent(e,t,s)},defaultFilterObject:i});return new t.filters.Filter(d)}}(e))});var l}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/contract.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=["from","to","data","value","gasPrice","gas"];t.exports=function(e){if(!Array.isArray(e)||0===e.length)return!1;var t=e[e.length-1];if(!t)return!1;if("object"!=typeof t)return!1;if(0===Object.keys(t).length)return!0;var n=Object.keys(t);if(r.some(function(e){return n.includes(e)}))return!0;return!1}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/has-tx-object.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/index.js",{"./contract":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/contract.js","./has-tx-object":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js","@metamask/ethjs-filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js","@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","ethjs-abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-abi/lib/index.js","js-sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/js-sha3/src/sha3.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("ethjs-abi"),s=(e("js-sha3").keccak_256,e("@metamask/ethjs-filter"),e("@metamask/ethjs-util").getKeys),o=e("./contract"),a=e("./has-tx-object");t.exports=function(e){return function(t,n,i){if(!Array.isArray(t))throw new Error("[ethjs-contract] Contract ABI must be type Array, got type "+typeof t);if(void 0!==n&&"string"!=typeof n)throw new Error("[ethjs-contract] Contract bytecode must be type String, got type "+typeof n);if(void 0!==i&&"object"!=typeof i)throw new Error("[ethjs-contract] Contract default tx object must be type Object, got type "+typeof t);var c={at:function(r){return new o({address:r,query:e,contractBytecode:n,contractDefaultTxObject:i,contractABI:t})},new:function(){var o={},c=null,m=[].slice.call(arguments);"function"==typeof m[m.length-1]&&(c=m.pop()),a(m)&&(o=m.pop());var d=function(e){return e.filter(function(e){return"constructor"===e.type})[0]}(t),u=Object.assign({},i,o);if(n&&(u.data=n),d){var l=r.encodeParams(s(d.inputs,"type"),m).substring(2);u.data=""+u.data+l}return c?e.sendTransaction(u,c):e.sendTransaction(u)}};return c}}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t){function n(e){var n=this;n.filterId=null,n.options=Object.assign({delay:300,decoder:function(e){return e},defaultFilterObject:{}},e||{}),n.watchers={},n.interval=setInterval(function(){null!==n.filterId&&Object.keys(n.watchers).length>0&&t.getFilterChanges(n.filterId,function(e,t){var r=[],s=null;if(!e)try{t.forEach(function(e,s){r[s]=t[s],"object"==typeof t[s]&&(r[s].data=n.options.decoder(r[s].data))})}catch(e){s=new Error("[ethjs-filter] while decoding filter change event data from RPC '"+JSON.stringify(r)+"': "+e)}Object.keys(n.watchers).forEach(function(o){var a=n.watchers[o];!0!==a.stop?s?a.callback(s,null):e?a.callback(e,null):Array.isArray(r)&&t.length>0&&a.callback(e,r):delete n.watchers[o]})})},n.options.delay)}return n.prototype.at=function(e){this.filterId=e},n.prototype.watch=function(e){var t=e||function(){},n=this,r=Math.random().toString(36).substring(7);return n.watchers[r]={callback:t,stop:!1,stopWatching:function(){n.watchers[r].stop=!0}},n.watchers[r]},n.prototype.uninstall=function(e){var n=this,r=e||null;n.watchers=Object.assign({}),clearInterval(n.interval);var s=new Promise(function(e,r){t.uninstallFilter(n.filterId,function(t,n){t?r(t):e(n)})});return r&&s.then(function(e){return r(null,e)}).catch(function(e){return r(e,null)}),r?null:s},n.prototype.new=function(){var n=null,r=this,s=[],o=[].slice.call(arguments);"function"==typeof o[o.length-1]&&(n=o.pop()),"Filter"===e&&s.push(Object.assign(r.options.defaultFilterObject,o[o.length-1]||{}));var a=new Promise(function(n,o){s.push(function(e,t){e?o(e):(r.filterId=t,n(t))}),t["new"+e].apply(t,s)});return n&&a.then(function(e){return n(null,e)}).catch(function(e){return n(e,null)}),n?null:a},n}t.exports=function e(t){var n=this;if(!(n instanceof e))throw new Error("the EthFilter object must be instantiated with `new` flag.. (e.g. `const filters = new EthFilter(query);`)");if("object"!=typeof t)throw new Error("the EthFilter object must be instantiated with an EthQuery instance (e.g. `const filters = new EthFilter(new EthQuery(provider));`). See github.com/ethjs/ethjs-query for more details..");n.Filter=r("Filter",t),n.BlockFilter=r("BlockFilter",t),n.PendingTransactionFilter=r("PendingTransactionFilter",t)}}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-filter",file:"node_modules/@metamask/ethjs-filter/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-format/lib/index.js",{"@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","@metamask/number-to-bn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/number-to-bn/src/index.js","ethjs-schema":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-schema/src/schema.json","strip-hex-prefix":"/home/runner/work/metamask-extension/metamask-extension/node_modules/strip-hex-prefix/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("@metamask/number-to-bn"),s=e("ethjs-schema"),o=e("@metamask/ethjs-util"),a=o.arrayContainsArray,i=o.getBinarySize,c=o.padToEven,m=e("strip-hex-prefix");function d(e,t,n){if(-1===["string","number","object"].indexOf(typeof e)||null===e)return e;var s=r(e),o=n&&s.toString(16).length%2?"0":"";if(r(e).isNeg())throw new Error("[ethjs-format] while formatting quantity '"+s.toString(10)+"', invalid negative number. Number must be positive or zero.");return t?"0x"+o+s.toString(16):s}function u(e,t){var n=e;return-1===s.tags.indexOf(e)&&(n=d(e,t)),n}function l(e,t){var n=e,r=0;if("string"==typeof e&&(n="0x"+c(m(e)),r=i(n)),"0x00"===n&&(n="0x0"),"number"==typeof t&&null!==e&&"0x"!==n&&"0x0"!==n&&(!/^[0-9A-Fa-f]+$/.test(m(n))||r!==2+2*t))throw new Error("[ethjs-format] hex string '"+n+"' must be an alphanumeric "+(2+2*t)+" utf8 byte hex (chars: a-fA-F) string, is "+r+" bytes");return n}function h(e,t,n){var r=Object.assign({},t),o=null;if("string"==typeof e&&(o="Boolean|EthSyncing"===e?Object.assign({},s.objects.EthSyncing):"DATA|Transaction"===e?Object.assign({},s.objects.Transaction):Object.assign({},s.objects[e])),!a(Object.keys(t),o.__required))throw new Error("[ethjs-format] object "+JSON.stringify(t)+" must contain properties: "+o.__required.join(", "));return Object.keys(o).forEach(function(e){"__required"!==e&&void 0!==t[e]&&(r[e]=p(o[e],t[e],n))}),r}function f(e,t,n,r){var s=t.slice(),o=e;if("Array|DATA"===e&&(o=["D"]),"FilterChange"===e&&"string"==typeof t[0]&&(o=["D32"]),!0===n&&"number"==typeof r&&t.length<r)throw new Error("array "+JSON.stringify(t)+" must contain at least "+r+" params, but only contains "+t.length+".");return o=o.slice(),t.forEach(function(e,t){var r=0;o.length>1&&(r=t),s[t]=p(o[r],e,n)}),s}function p(e,t,n,r){var s=t;return"Q"===e?s=d(t,n):"QP"===e?s=d(t,n,!0):"Q|T"===e?s=u(t,n):"D"===e?s=l(t):"D20"===e?s=l(t,20):"D32"===e?s=l(t,32):"object"==typeof t&&null!==t&&!1===Array.isArray(t)?s=h(e,t,n):Array.isArray(t)&&(s=f(e,t,n,r)),s}t.exports={schema:s,formatQuantity:d,formatQuantityOrTag:u,formatObject:h,formatArray:f,format:p,formatInputs:function(e,t){return p(s.methods[e][0],t,!0,s.methods[e][2])},formatOutputs:function(e,t){return p(s.methods[e][1],t,!1)}}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-format",file:"node_modules/@metamask/ethjs-format/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-query/lib/index.js",{"@metamask/ethjs-format":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-format/lib/index.js","@metamask/ethjs-rpc":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-rpc/lib/index.js","promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("@metamask/ethjs-format"),s=e("@metamask/ethjs-rpc"),o=e("promise-to-callback");function a(e,t){var n=this,r=t||{};if(!(this instanceof a))throw new Error('[ethjs-query] the Eth object requires the "new" flag in order to function normally (i.e. `const eth = new Eth(provider);`).');if("object"!=typeof e)throw new Error("[ethjs-query] the Eth object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new Eth(provider);')");n.options=Object.assign({debug:r.debug||!1,logger:r.logger||console,jsonSpace:r.jsonSpace||0}),n.rpc=new s(e),n.setProvider=n.rpc.setProvider}function i(e,t){return function(){var n=null,s=null,a=this,i=[].slice.call(arguments),c=e.replace("eth_","");i.length>0&&"function"==typeof i[i.length-1]&&(n=i.pop());var m=function(){var n=this;return new Promise(function(o,m){if(i.length<t[2])m(new Error("[ethjs-query] method '"+c+"' requires at least "+t[2]+" input (format type "+t[0][0]+"), "+i.length+" provided. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else if(i.length>t[0].length)m(new Error("[ethjs-query] method '"+c+"' requires at most "+t[0].length+" params, "+i.length+" provided '"+JSON.stringify(i,null,a.options.jsonSpace)+"'. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else{t[3]&&i.length<t[3]&&i.push("latest"),n.log("attempting method formatting for '"+c+"' with inputs "+JSON.stringify(i,null,n.options.jsonSpace));try{s=r.formatInputs(e,i),n.log("method formatting success for '"+c+"' with formatted result: "+JSON.stringify(s,null,n.options.jsonSpace))}catch(e){return void m(new Error("[ethjs-query] while formatting inputs '"+JSON.stringify(i,null,n.options.jsonSpace)+"' for method '"+c+"' error: "+e))}n.rpc.sendAsync({method:e,params:s}).then(function(t){n.log("attempting method formatting for '"+c+"' with raw outputs: "+JSON.stringify(t,null,n.options.jsonSpace));var s=r.formatOutputs(e,t);n.log("method formatting success for '"+c+"' formatted result: "+JSON.stringify(s,null,n.options.jsonSpace)),o(s)}).catch(function(e){m(e)})}})}.call(this);return n?o(m)(n):m}}t.exports=a,a.prototype.log=function(e){this.options.debug&&this.options.logger.log("[ethjs-query log] "+e)},Object.keys(r.schema.methods).forEach(function(e){Object.defineProperty(a.prototype,e.replace("eth_",""),{enumerable:!0,value:i(e,r.schema.methods[e])})})}}},{package:"eth-method-registry>@metamask/ethjs-query",file:"node_modules/@metamask/ethjs-query/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-rpc/lib/index.js",{"promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("promise-to-callback");function s(e,t){var n=this,r=t||{};if(!(this instanceof s))throw new Error('[ethjs-rpc] the EthRPC object requires the "new" flag in order to function normally (i.e. `const eth = new EthRPC(provider);`).');n.options=Object.assign({jsonSpace:r.jsonSpace||0,max:r.max||9999999999999}),n.idCounter=Math.floor(Math.random()*n.options.max),n.setProvider=function(e){if("object"!=typeof e)throw new Error("[ethjs-rpc] the EthRPC object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new EthRPC(provider);')");n.currentProvider=e},n.setProvider(e)}t.exports=s,s.prototype.sendAsync=function(e,t){var n=this;n.idCounter=n.idCounter%n.options.max;var s,o,a=(s=e,o=n.idCounter++,Object.assign({},{id:o,jsonrpc:"2.0",params:[]},s)),i=new Promise(function(e,t){n.currentProvider.sendAsync(a,function(r,s){var o=s||{};if(r||o.error){var i="[ethjs-rpc] "+(o.error?"rpc":"")+" error with payload "+JSON.stringify(a,null,n.options.jsonSpace)+" "+(r?String(r):JSON.stringify(o.error,null,n.options.jsonSpace)),c=new Error(i);return c.value=r||o.error,void t(c)}e(o.result)})});return t?r(i)(t):i}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-rpc",file:"node_modules/@metamask/ethjs-rpc/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-unit/lib/index.js",{"@metamask/number-to-bn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/number-to-bn/src/index.js","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("bn.js"),s=e("@metamask/number-to-bn"),o=new r(0),a=new r(-1),i={noether:"0",wei:"1",kwei:"1000",Kwei:"1000",babbage:"1000",femtoether:"1000",mwei:"1000000",Mwei:"1000000",lovelace:"1000000",picoether:"1000000",gwei:"1000000000",Gwei:"1000000000",shannon:"1000000000",nanoether:"1000000000",nano:"1000000000",szabo:"1000000000000",microether:"1000000000000",micro:"1000000000000",finney:"1000000000000000",milliether:"1000000000000000",milli:"1000000000000000",ether:"1000000000000000000",kether:"1000000000000000000000",grand:"1000000000000000000000",mether:"1000000000000000000000000",gether:"1000000000000000000000000000",tether:"1000000000000000000000000000000"};function c(e){var t=e?e.toLowerCase():"ether",n=i[t];if("string"!=typeof n)throw new Error("[ethjs-unit] the unit provided "+e+" doesn't exists, please use the one of the following units "+JSON.stringify(i,null,2));return new r(n,10)}function m(e){if("string"==typeof e){if(!e.match(/^-?[0-9.]+$/))throw new Error("while converting number to string, invalid number value '"+e+"', should be a number matching (^-?[0-9.]+).");return e}if("number"==typeof e)return String(e);if("object"==typeof e&&e.toString&&(e.toTwos||e.dividedToIntegerBy))return e.toPrecision?String(e.toPrecision()):e.toString(10);throw new Error("while converting number to string, invalid number value '"+e+"' type "+typeof e+".")}t.exports={unitMap:i,numberToString:m,getValueOfUnit:c,fromWei:function(e,t,n){var r=s(e),m=r.lt(o),d=c(t),u=i[t].length-1||1,l=n||{};m&&(r=r.mul(a));for(var h=r.mod(d).toString(10);h.length<u;)h="0"+h;l.pad||(h=h.match(/^([0-9]*[1-9]|0)(0*)/)[1]);var f=r.div(d).toString(10);l.commify&&(f=f.replace(/\B(?=(\d{3})+(?!\d))/g,","));var p=f+("0"==h?"":"."+h);return m&&(p="-"+p),p},toWei:function(e,t){var n=m(e),s=c(t),o=i[t].length-1||1,d="-"===n.substring(0,1);if(d&&(n=n.substring(1)),"."===n)throw new Error("[ethjs-unit] while converting number "+e+" to wei, invalid value");var u=n.split(".");if(u.length>2)throw new Error("[ethjs-unit] while converting number "+e+" to wei,  too many decimal points");var l=u[0],h=u[1];if(l||(l="0"),h||(h="0"),h.length>o)throw new Error("[ethjs-unit] while converting number "+e+" to wei, too many decimal places");for(;h.length<o;)h+="0";l=new r(l),h=new r(h);var f=l.mul(s).add(h);return d&&(f=f.mul(a)),new r(f.toString(10),10)}}}}},{package:"@metamask/controller-utils>@metamask/ethjs-unit",file:"node_modules/@metamask/ethjs-unit/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","is-hex-prefixed":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-hex-prefixed/src/index.js","strip-hex-prefix":"/home/runner/work/metamask-extension/metamask-extension/node_modules/strip-hex-prefix/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r=e("is-hex-prefixed"),s=e("strip-hex-prefix");function o(e){var t=e;if("string"!=typeof t)throw new Error("[ethjs-util] while padding to even, value must be string, is currently "+typeof t+", while padToEven.");return t.length%2&&(t="0"+t),t}function a(e){return"0x"+e.toString(16)}t.exports={arrayContainsArray:function(e,t,n){if(!0!==Array.isArray(e))throw new Error("[ethjs-util] method arrayContainsArray requires input 'superset' to be an array got type '"+typeof e+"'");if(!0!==Array.isArray(t))throw new Error("[ethjs-util] method arrayContainsArray requires input 'subset' to be an array got type '"+typeof t+"'");return t[Boolean(n)?"some":"every"](function(t){return e.indexOf(t)>=0})},intToBuffer:function(e){var t=a(e);return n.from(o(t.slice(2)),"hex")},getBinarySize:function(e){if("string"!=typeof e)throw new Error("[ethjs-util] while getting binary size, method getBinarySize requires input 'str' to be type String, got '"+typeof e+"'.");return n.byteLength(e,"utf8")},isHexPrefixed:r,stripHexPrefix:s,padToEven:o,intToHex:a,fromAscii:function(e){for(var t="",n=0;n<e.length;n++){var r=e.charCodeAt(n).toString(16);t+=r.length<2?"0"+r:r}return"0x"+t},fromUtf8:function(e){return"0x"+o(n.from(e,"utf8").toString("hex")).replace(/^0+|0+$/g,"")},toAscii:function(e){var t="",n=0,r=e.length;for("0x"===e.substring(0,2)&&(n=2);n<r;n+=2){var s=parseInt(e.substr(n,2),16);t+=String.fromCharCode(s)}return t},toUtf8:function(e){return n.from(o(s(e).replace(/^0+|0+$/g,"")),"hex").toString("utf8")},getKeys:function(e,t,n){if(!Array.isArray(e))throw new Error("[ethjs-util] method getKeys expecting type Array as 'params' input, got '"+typeof e+"'");if("string"!=typeof t)throw new Error("[ethjs-util] method getKeys expecting type String for input 'key' got '"+typeof t+"'.");for(var r=[],s=0;s<e.length;s++){var o=e[s][t];if(n&&!o)o="";else if("string"!=typeof o)throw new Error("invalid abi");r.push(o)}return r},isHexString:function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&(!t||e.length===2+2*t)}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-util",file:"node_modules/@metamask/ethjs-util/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/GatorPermissionsController.cjs",{"./decodePermission/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/decodePermission/index.cjs","./errors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/errors.cjs","./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/logger.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/types.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/delegation-deployments":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/node_modules/@metamask/delegation-deployments/dist/index.js","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i,c,m,d,u,l,h,f=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.getDefaultGatorPermissionsControllerState=n.DELEGATION_FRAMEWORK_VERSION=void 0;const p=e("@metamask/base-controller"),g=e("@metamask/delegation-deployments"),y=e("@metamask/snaps-utils"),k=e("./decodePermission/index.cjs"),b=e("./errors.cjs"),x=e("./logger.cjs"),w=e("./types.cjs"),_=e("./utils.cjs"),v="GatorPermissionsController",E={"native-token-stream":{},"native-token-periodic":{},"erc20-token-stream":{},"erc20-token-periodic":{},other:{}};n.DELEGATION_FRAMEWORK_VERSION="1.3.0";const j=g.DELEGATOR_CONTRACTS[n.DELEGATION_FRAMEWORK_VERSION],T={isGatorPermissionsEnabled:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!1},gatorPermissionsMapSerialized:{includeInStateLogs:!0,persist:!0,includeInDebugSnapshot:!1,usedInUi:!0},isFetchingGatorPermissions:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!1},gatorPermissionsProviderSnapId:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!1},pendingRevocations:{includeInStateLogs:!0,persist:!1,includeInDebugSnapshot:!1,usedInUi:!0}};function A(){return{isGatorPermissionsEnabled:!1,gatorPermissionsMapSerialized:(0,_.serializeGatorPermissionsMap)(E),isFetchingGatorPermissions:!1,gatorPermissionsProviderSnapId:"npm:@metamask/gator-permissions-snap",pendingRevocations:[]}}n.getDefaultGatorPermissionsControllerState=A;class C extends p.BaseController{constructor({messenger:e,state:t}){super({name:v,metadata:T,messenger:e,state:{...A(),...t,isFetchingGatorPermissions:!1}}),r.add(this),f(this,r,"m",m).call(this)}get gatorPermissionsMap(){return(0,_.deserializeGatorPermissionsMap)(this.state.gatorPermissionsMapSerialized)}get permissionsProviderSnapId(){return this.state.gatorPermissionsProviderSnapId}async enableGatorPermissions(){f(this,r,"m",o).call(this,!0)}async disableGatorPermissions(){this.update(e=>{e.isGatorPermissionsEnabled=!1,e.gatorPermissionsMapSerialized=(0,_.serializeGatorPermissionsMap)(E)})}get pendingRevocations(){return this.state.pendingRevocations}async fetchAndUpdateGatorPermissions(e){try{f(this,r,"m",s).call(this,!0),f(this,r,"m",d).call(this);const t=await f(this,r,"m",u).call(this,{snapId:this.state.gatorPermissionsProviderSnapId,params:e}),n=f(this,r,"m",h).call(this,t);return this.update(e=>{e.gatorPermissionsMapSerialized=(0,_.serializeGatorPermissionsMap)(n)}),n}catch(e){throw(0,x.controllerLog)("Failed to fetch gator permissions",e),new b.GatorPermissionsFetchError({message:"Failed to fetch gator permissions",cause:e})}finally{f(this,r,"m",s).call(this,!1)}}decodePermissionFromPermissionContextForOrigin({origin:e,chainId:t,delegation:{caveats:n,delegator:r,delegate:s,authority:o},metadata:{justification:a,origin:i}}){if(e!==this.permissionsProviderSnapId)throw new b.OriginNotAllowedError({origin:e});const c=j[t];if(!c)throw new Error(`Contracts not found for chainId: ${t}`);try{const e=n.map(e=>e.enforcer),m=(0,k.identifyPermissionByEnforcers)({enforcers:e,contracts:c}),{expiry:d,data:u}=(0,k.getPermissionDataAndExpiry)({contracts:c,caveats:n,permissionType:m});return(0,k.reconstructDecodedPermission)({chainId:t,permissionType:m,delegator:r,delegate:s,authority:o,expiry:d,data:u,justification:a,specifiedOrigin:i})}catch(e){throw new b.PermissionDecodingError({cause:e})}}async submitRevocation(e){(0,x.controllerLog)("submitRevocation method called",{permissionContext:e.permissionContext}),f(this,r,"m",d).call(this);const t={snapId:this.state.gatorPermissionsProviderSnapId,origin:"metamask",handler:y.HandlerType.OnRpcRequest,request:{jsonrpc:"2.0",method:w.GatorPermissionsSnapRpcMethod.PermissionProviderSubmitRevocation,params:e}};try{const n=await this.messenger.call("SnapController:handleRequest",t);await this.fetchAndUpdateGatorPermissions({isRevoked:!1}),(0,x.controllerLog)("Successfully submitted revocation",{permissionContext:e.permissionContext,result:n})}catch(t){if(t instanceof b.GatorPermissionsFetchError)throw(0,x.controllerLog)("Revocation submitted successfully but failed to refresh permissions list",{error:t,permissionContext:e.permissionContext}),new b.GatorPermissionsFetchError({message:"Failed to refresh permissions list after successful revocation",cause:t});throw(0,x.controllerLog)("Failed to submit revocation",{error:t,permissionContext:e.permissionContext}),new b.GatorPermissionsProviderError({method:w.GatorPermissionsSnapRpcMethod.PermissionProviderSubmitRevocation,cause:t})}finally{f(this,r,"m",c).call(this,e.permissionContext)}}async addPendingRevocation(e){const{txId:t,permissionContext:n}=e;(0,x.controllerLog)("addPendingRevocation method called",{txId:t,permissionContext:n}),f(this,r,"m",d).call(this);const s={approved:undefined,rejected:undefined,confirmed:undefined,failed:undefined,dropped:undefined,timeoutId:undefined},o=e=>{this.fetchAndUpdateGatorPermissions({isRevoked:!1}).catch(r=>{(0,x.controllerLog)(`Failed to refresh permissions after ${e}`,{txId:t,permissionContext:n,error:r})})},c=()=>{s.approved&&(this.messenger.unsubscribe("TransactionController:transactionApproved",s.approved),s.approved=undefined),s.rejected&&(this.messenger.unsubscribe("TransactionController:transactionRejected",s.rejected),s.rejected=undefined)},m=(e,t=!0)=>{c(),s.confirmed&&this.messenger.unsubscribe("TransactionController:transactionConfirmed",s.confirmed),s.failed&&this.messenger.unsubscribe("TransactionController:transactionFailed",s.failed),s.dropped&&this.messenger.unsubscribe("TransactionController:transactionDropped",s.dropped),s.timeoutId!==undefined&&clearTimeout(s.timeoutId),t&&f(this,r,"m",i).call(this,e)};s.approved=e=>{e.transactionMeta.id===t&&((0,x.controllerLog)("Transaction approved by user, adding to pending revocations",{txId:t,permissionContext:n}),f(this,r,"m",a).call(this,t,n),c())},s.rejected=e=>{e.transactionMeta.id===t&&((0,x.controllerLog)("Transaction rejected by user, cleaning up listeners",{txId:t,permissionContext:n}),m(e.transactionMeta.id,!1))},s.confirmed=e=>{e.id===t&&((0,x.controllerLog)("Transaction confirmed, submitting revocation",{txId:t,permissionContext:n}),this.submitRevocation({permissionContext:n}).catch(e=>{(0,x.controllerLog)("Failed to submit revocation after transaction confirmed",{txId:t,permissionContext:n,error:e})}).finally(()=>o("transaction confirmed")),m(e.id))},s.failed=e=>{e.transactionMeta.id===t&&((0,x.controllerLog)("Transaction failed, cleaning up revocation listener",{txId:t,permissionContext:n,error:e.error}),m(e.transactionMeta.id),o("transaction failed"))},s.dropped=e=>{e.transactionMeta.id===t&&((0,x.controllerLog)("Transaction dropped, cleaning up revocation listener",{txId:t,permissionContext:n}),m(e.transactionMeta.id),o("transaction dropped"))},this.messenger.subscribe("TransactionController:transactionApproved",s.approved),this.messenger.subscribe("TransactionController:transactionRejected",s.rejected),this.messenger.subscribe("TransactionController:transactionConfirmed",s.confirmed),this.messenger.subscribe("TransactionController:transactionFailed",s.failed),this.messenger.subscribe("TransactionController:transactionDropped",s.dropped),s.timeoutId=setTimeout(()=>{(0,x.controllerLog)("Pending revocation timed out, cleaning up listeners",{txId:t,permissionContext:n}),m(t)},72e5)}async submitDirectRevocation(e){f(this,r,"m",d).call(this);const t=`no-tx-${e.permissionContext}`;f(this,r,"m",a).call(this,t,e.permissionContext),await this.submitRevocation(e)}isPendingRevocation(e){return this.state.pendingRevocations.some(t=>t.permissionContext.toLowerCase()===e.toLowerCase())}}r=new WeakSet,s=function(e){this.update(t=>{t.isFetchingGatorPermissions=e})},o=function(e){this.update(t=>{t.isGatorPermissionsEnabled=e})},a=function(e,t){this.update(n=>{n.pendingRevocations=[...n.pendingRevocations,{txId:e,permissionContext:t}]})},i=function(e){this.update(t=>{t.pendingRevocations=t.pendingRevocations.filter(t=>t.txId!==e)})},c=function(e){this.update(t=>{t.pendingRevocations=t.pendingRevocations.filter(t=>t.permissionContext.toLowerCase()!==e.toLowerCase())})},m=function(){this.messenger.registerActionHandler(`${v}:fetchAndUpdateGatorPermissions`,this.fetchAndUpdateGatorPermissions.bind(this)),this.messenger.registerActionHandler(`${v}:enableGatorPermissions`,this.enableGatorPermissions.bind(this)),this.messenger.registerActionHandler(`${v}:disableGatorPermissions`,this.disableGatorPermissions.bind(this)),this.messenger.registerActionHandler(`${v}:decodePermissionFromPermissionContextForOrigin`,this.decodePermissionFromPermissionContextForOrigin.bind(this));const e=`${v}:submitRevocation`;this.messenger.registerActionHandler(e,this.submitRevocation.bind(this)),this.messenger.registerActionHandler(`${v}:addPendingRevocation`,this.addPendingRevocation.bind(this)),this.messenger.registerActionHandler(`${v}:submitDirectRevocation`,this.submitDirectRevocation.bind(this)),this.messenger.registerActionHandler(`${v}:isPendingRevocation`,this.isPendingRevocation.bind(this))},d=function(){if(!this.state.isGatorPermissionsEnabled)throw new b.GatorPermissionsNotEnabledError},u=async function({snapId:e,params:t}){try{return await this.messenger.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:y.HandlerType.OnRpcRequest,request:{jsonrpc:"2.0",method:w.GatorPermissionsSnapRpcMethod.PermissionProviderGetGrantedPermissions,...t!==undefined&&{params:t}}})}catch(e){throw(0,x.controllerLog)("Failed to handle snap request to gator permissions provider",e),new b.GatorPermissionsProviderError({method:w.GatorPermissionsSnapRpcMethod.PermissionProviderGetGrantedPermissions,cause:e})}},l=function(e){const{permissionResponse:t}=e,{rules:n,dependencyInfo:r,signer:s,...o}=t;return{...e,permissionResponse:{...o}}},h=function(e){return e?e.reduce((e,t)=>{const{permissionResponse:n}=t,s=n.permission.type,{chainId:o}=n,a=f(this,r,"m",l).call(this,t);switch(s){case"native-token-stream":case"native-token-periodic":case"erc20-token-stream":case"erc20-token-periodic":e[s][o]||(e[s][o]=[]),e[s][o].push(a);break;default:e.other[o]||(e.other[o]=[]),e.other[o].push(a)}return e},{"native-token-stream":{},"native-token-periodic":{},"erc20-token-stream":{},"erc20-token-periodic":{},other:{}}):E},n.default=C}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/GatorPermissionsController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/decodePermission/decodePermission.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/decodePermission/utils.cjs","@metamask/delegation-core":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/delegation-core/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.reconstructDecodedPermission=n.getPermissionDataAndExpiry=n.identifyPermissionByEnforcers=void 0;const r=e("@metamask/delegation-core"),s=e("@metamask/utils"),o=e("./utils.cjs");n.identifyPermissionByEnforcers=({enforcers:e,contracts:t})=>{const n=new Set(e.map(s.getChecksumAddress)),r=(0,o.createPermissionRulesForChainId)(t);let a=null;for(const{allowedEnforcers:e,requiredEnforcers:t,permissionType:s}of r){const r=(0,o.isSubset)(t,n);let i=!1;for(const r of n)if(!e.has(r)&&!t.has(r)){i=!0;break}if(r&&!i){if(a)throw new Error("Multiple permission types match");a=s}}if(!a)throw new Error("Unable to identify permission type");return a};n.getPermissionDataAndExpiry=({contracts:e,caveats:t,permissionType:n})=>{const r=t.map(e=>({...e,enforcer:(0,s.getChecksumAddress)(e.enforcer)})),{erc20StreamingEnforcer:a,erc20PeriodicEnforcer:i,nativeTokenStreamingEnforcer:c,nativeTokenPeriodicEnforcer:m,timestampEnforcer:d}=(0,o.getChecksumEnforcersByChainId)(e),u=(0,o.getTermsByEnforcer)({caveats:r,enforcer:d,throwIfNotFound:!1});let l,h=null;if(u){const[e,t]=(0,o.splitHex)(u,[16,16]);if(0!==(0,s.hexToNumber)(e))throw new Error("Invalid expiry");h=(0,s.hexToNumber)(t)}switch(n){case"erc20-token-stream":{const e=(0,o.getTermsByEnforcer)({caveats:r,enforcer:a}),[t,n,i,c,m]=(0,o.splitHex)(e,[20,32,32,32,32]);l={tokenAddress:t,initialAmount:n,maxAmount:i,amountPerSecond:c,startTime:(0,s.hexToNumber)(m)};break}case"erc20-token-periodic":{const e=(0,o.getTermsByEnforcer)({caveats:r,enforcer:i}),[t,n,a,c]=(0,o.splitHex)(e,[20,32,32,32]);l={tokenAddress:t,periodAmount:n,periodDuration:(0,s.hexToNumber)(a),startTime:(0,s.hexToNumber)(c)};break}case"native-token-stream":{const e=(0,o.getTermsByEnforcer)({caveats:r,enforcer:c}),[t,n,a,i]=(0,o.splitHex)(e,[32,32,32,32]);l={initialAmount:t,maxAmount:n,amountPerSecond:a,startTime:(0,s.hexToNumber)(i)};break}case"native-token-periodic":{const e=(0,o.getTermsByEnforcer)({caveats:r,enforcer:m}),[t,n,a]=(0,o.splitHex)(e,[32,32,32]);l={periodAmount:t,periodDuration:(0,s.hexToNumber)(n),startTime:(0,s.hexToNumber)(a)};break}default:throw new Error("Invalid permission type")}return{expiry:h,data:l}};n.reconstructDecodedPermission=({chainId:e,permissionType:t,delegator:n,delegate:o,authority:a,expiry:i,data:c,justification:m,specifiedOrigin:d})=>{if(a!==r.ROOT_AUTHORITY)throw new Error("Invalid authority");return{chainId:(0,s.numberToHex)(e),address:n,signer:{type:"account",data:{address:o}},permission:{type:t,data:c,justification:m},expiry:i,origin:d}}}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/decodePermission/decodePermission.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/decodePermission/index.cjs",{"./decodePermission.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/decodePermission/decodePermission.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.reconstructDecodedPermission=n.getPermissionDataAndExpiry=n.identifyPermissionByEnforcers=void 0;var r=e("./decodePermission.cjs");Object.defineProperty(n,"identifyPermissionByEnforcers",{enumerable:!0,get:function(){return r.identifyPermissionByEnforcers}}),Object.defineProperty(n,"getPermissionDataAndExpiry",{enumerable:!0,get:function(){return r.getPermissionDataAndExpiry}}),Object.defineProperty(n,"reconstructDecodedPermission",{enumerable:!0,get:function(){return r.reconstructDecodedPermission}})}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/decodePermission/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/decodePermission/utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.splitHex=n.getTermsByEnforcer=n.isSubset=n.createPermissionRulesForChainId=n.getChecksumEnforcersByChainId=void 0;const r=e("@metamask/utils"),s="ERC20PeriodTransferEnforcer",o="ERC20StreamingEnforcer",a="ExactCalldataEnforcer",i="NativeTokenPeriodTransferEnforcer",c="NativeTokenStreamingEnforcer",m="TimestampEnforcer",d="ValueLteEnforcer",u="NonceEnforcer";n.getChecksumEnforcersByChainId=e=>{const t=t=>{const n=e[t];if(!n)throw new Error(`Contract not found: ${t}`);return(0,r.getChecksumAddress)(n)};return{erc20StreamingEnforcer:t(o),erc20PeriodicEnforcer:t(s),nativeTokenStreamingEnforcer:t(c),nativeTokenPeriodicEnforcer:t(i),exactCalldataEnforcer:t(a),valueLteEnforcer:t(d),timestampEnforcer:t(m),nonceEnforcer:t(u)}};n.createPermissionRulesForChainId=e=>{const{erc20StreamingEnforcer:t,erc20PeriodicEnforcer:r,nativeTokenStreamingEnforcer:s,nativeTokenPeriodicEnforcer:o,exactCalldataEnforcer:a,valueLteEnforcer:i,timestampEnforcer:c,nonceEnforcer:m}=(0,n.getChecksumEnforcersByChainId)(e),d=new Set([c]);return[{requiredEnforcers:new Set([s,a,m]),allowedEnforcers:d,permissionType:"native-token-stream"},{requiredEnforcers:new Set([o,a,m]),allowedEnforcers:d,permissionType:"native-token-periodic"},{requiredEnforcers:new Set([t,i,m]),allowedEnforcers:d,permissionType:"erc20-token-stream"},{requiredEnforcers:new Set([r,i,m]),allowedEnforcers:d,permissionType:"erc20-token-periodic"}]};n.isSubset=(e,t)=>{for(const n of e)if(!t.has(n))return!1;return!0},n.getTermsByEnforcer=function({caveats:e,enforcer:t,throwIfNotFound:n}){const r=e.filter(e=>e.enforcer===t);if(0===r.length){if(n??1)throw new Error("Invalid caveats");return null}if(r.length>1)throw new Error("Invalid caveats");return r[0].terms},n.splitHex=function(e,t){let n=2;const r=[];for(const s of t){const t=2*s,o=e.slice(n,n+t);n+=t,r.push(`0x${o}`)}return r}}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/decodePermission/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/errors.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PermissionDecodingError=n.OriginNotAllowedError=n.GatorPermissionsProviderError=n.GatorPermissionsNotEnabledError=n.GatorPermissionsMapSerializationError=n.GatorPermissionsFetchError=n.GatorPermissionsControllerError=void 0;const r=e("./types.cjs");class s extends Error{constructor({cause:e,message:t,code:n}){super(t),this.cause=e,this.code=n}}n.GatorPermissionsControllerError=s;n.GatorPermissionsFetchError=class extends s{constructor({cause:e,message:t}){super({cause:e,message:t,code:r.GatorPermissionsControllerErrorCode.GatorPermissionsFetchError})}};n.GatorPermissionsMapSerializationError=class extends s{constructor({cause:e,message:t,data:n}){super({cause:e,message:t,code:r.GatorPermissionsControllerErrorCode.GatorPermissionsMapSerializationError}),this.data=n}};n.GatorPermissionsNotEnabledError=class extends s{constructor(){super({cause:new Error("Gator permissions are not enabled"),message:"Gator permissions are not enabled",code:r.GatorPermissionsControllerErrorCode.GatorPermissionsNotEnabled})}};n.GatorPermissionsProviderError=class extends s{constructor({cause:e,method:t}){super({cause:e,message:`Failed to handle snap request to gator permissions provider for method ${t}`,code:r.GatorPermissionsControllerErrorCode.GatorPermissionsProviderError})}};n.OriginNotAllowedError=class extends s{constructor({origin:e}){const t=`Origin ${e} not allowed`;super({cause:new Error(t),message:t,code:r.GatorPermissionsControllerErrorCode.OriginNotAllowedError})}};n.PermissionDecodingError=class extends s{constructor({cause:e}){super({cause:e,message:"Failed to decode permission",code:r.GatorPermissionsControllerErrorCode.PermissionDecodingError})}}}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/errors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/index.cjs",{"./GatorPermissionsController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/GatorPermissionsController.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.deserializeGatorPermissionsMap=n.serializeGatorPermissionsMap=n.GatorPermissionsController=void 0;var s=e("./GatorPermissionsController.cjs");Object.defineProperty(n,"GatorPermissionsController",{enumerable:!0,get:function(){return r(s).default}});var o=e("./utils.cjs");Object.defineProperty(n,"serializeGatorPermissionsMap",{enumerable:!0,get:function(){return o.serializeGatorPermissionsMap}}),Object.defineProperty(n,"deserializeGatorPermissionsMap",{enumerable:!0,get:function(){return o.deserializeGatorPermissionsMap}})}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.utilsLog=n.controllerLog=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("gator-permissions-controller"),n.controllerLog=(0,r.createModuleLogger)(n.projectLogger,"GatorPermissionsController"),n.utilsLog=(0,r.createModuleLogger)(n.projectLogger,"utils")}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s;Object.defineProperty(n,"__esModule",{value:!0}),n.GatorPermissionsSnapRpcMethod=n.GatorPermissionsControllerErrorCode=void 0,function(e){e.GatorPermissionsFetchError="gator-permissions-fetch-error",e.GatorPermissionsNotEnabled="gator-permissions-not-enabled",e.GatorPermissionsProviderError="gator-permissions-provider-error",e.GatorPermissionsMapSerializationError="gator-permissions-map-serialization-error",e.PermissionDecodingError="permission-decoding-error",e.OriginNotAllowedError="origin-not-allowed-error"}(r||(n.GatorPermissionsControllerErrorCode=r={})),function(e){e.PermissionProviderGetGrantedPermissions="permissionsProvider_getGrantedPermissions",e.PermissionProviderSubmitRevocation="permissionsProvider_submitRevocation"}(s||(n.GatorPermissionsSnapRpcMethod=s={}))}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/utils.cjs",{"./errors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/errors.cjs","./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/dist/logger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deserializeGatorPermissionsMap=n.serializeGatorPermissionsMap=void 0;const r=e("./errors.cjs"),s=e("./logger.cjs");n.serializeGatorPermissionsMap=function(e){try{return JSON.stringify(e)}catch(t){throw(0,s.utilsLog)("Failed to serialize gator permissions map",t),new r.GatorPermissionsMapSerializationError({cause:t,message:"Failed to serialize gator permissions map",data:e})}},n.deserializeGatorPermissionsMap=function(e){try{return JSON.parse(e)}catch(t){throw(0,s.utilsLog)("Failed to deserialize gator permissions map",t),new r.GatorPermissionsMapSerializationError({cause:t,message:"Failed to deserialize gator permissions map",data:e})}}}}},{package:"@metamask/gator-permissions-controller",file:"node_modules/@metamask/gator-permissions-controller/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gator-permissions-controller/node_modules/@metamask/delegation-deployments/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r={DelegationManager:"0xdb9B1e94B5b69Df7e401DDbedE43491141047dB3",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x69Aa2f9fe1572F1B640E1bbc512f5c3a734fc77c",MultiSigDeleGatorImpl:"0x56a9EdB16a0105eb5a4C54f4C062e2868844f3A7",HybridDeleGatorImpl:"0x48dBe696A4D990079e039489bA2053B36E8FFEC4",EIP7702StatelessDeleGatorImpl:"0x63c0c19a282a1B52b07dD5a65b58948A07DAE32B",AllowedCalldataEnforcer:"0xc2b0d624c1c4319760C96503BA27C347F3260f55",AllowedMethodsEnforcer:"0x2c21fD0Cb9DC8445CB3fb0DC5E7Bb0Aca01842B5",AllowedTargetsEnforcer:"0x7F20f61b1f09b08D970938F6fa563634d65c4EeB",BlockNumberEnforcer:"0x5d9818dF0AE3f66e9c3D0c5029DAF99d1823ca6c",DeployedEnforcer:"0x24ff2AA430D53a8CD6788018E902E098083dcCd2",ERC20BalanceChangeEnforcer:"0xcdF6aB796408598Cea671d79506d7D48E97a5437",ERC20TransferAmountEnforcer:"0xf100b0819427117EcF76Ed94B358B1A5b5C6D2Fc",ERC20PeriodTransferEnforcer:"0x474e3Ae7E169e940607cC624Da8A15Eb120139aB",ERC20StreamingEnforcer:"0x56c97aE02f233B29fa03502Ecc0457266d9be00e",ERC721BalanceChangeEnforcer:"0x8aFdf96eDBbe7e1eD3f5Cd89C7E084841e12A09e",ERC721TransferEnforcer:"0x3790e6B7233f779b09DA74C72b6e94813925b9aF",ERC1155BalanceChangeEnforcer:"0x63c322732695cAFbbD488Fc6937A0A7B66fC001A",ExactCalldataBatchEnforcer:"0x982FD5C86BBF425d7d1451f974192d4525113DfD",ExactCalldataEnforcer:"0x99F2e9bF15ce5eC84685604836F71aB835DBBdED",ExactExecutionBatchEnforcer:"0x1e141e455d08721Dd5BCDA1BaA6Ea5633Afd5017",ExactExecutionEnforcer:"0x146713078D39eCC1F5338309c28405ccf85Abfbb",IdEnforcer:"0xC8B5D93463c893401094cc70e66A206fb5987997",LimitedCallsEnforcer:"0x04658B29F6b82ed55274221a06Fc97D318E25416",NativeBalanceChangeEnforcer:"0xbD7B277507723490Cd50b12EaaFe87C616be6880",ArgsEqualityCheckEnforcer:"0x44B8C6ae3C304213c3e298495e12497Ed3E56E41",NativeTokenPaymentEnforcer:"0x4803a326ddED6dDBc60e659e5ed12d85c7582811",NativeTokenTransferAmountEnforcer:"0xF71af580b9c3078fbc2BBF16FbB8EEd82b330320",NativeTokenStreamingEnforcer:"0xD10b97905a320b13a0608f7E9cC506b56747df19",NativeTokenPeriodTransferEnforcer:"0x9BC0FAf4Aca5AE429F4c06aEEaC517520CB16BD9",NonceEnforcer:"0xDE4f2FAC4B3D87A1d9953Ca5FC09FCa7F366254f",OwnershipTransferEnforcer:"0x7EEf9734E7092032B5C56310Eb9BbD1f4A524681",RedeemerEnforcer:"0xE144b0b2618071B4E56f746313528a669c7E65c5",SpecificActionERC20TransferBatchEnforcer:"0x00e0251aaA263dfE3B3541B758A82D1CBA1c3B6D",TimestampEnforcer:"0x1046bb45C8d673d4ea75321280DB34899413c069",ValueLteEnforcer:"0x92Bf12322527cAA612fd31a0e810472BBB106A8F",MultiTokenPeriodEnforcer:"0xFB2f1a9BD76d3701B730E5d69C3219D42D80eBb7"},s={DelegationManager:"0x56D56e07e3d6Ee5a24e30203A37a0a460f42D7A3",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",MultiSigDeleGatorImpl:"0xd1f421EDbA5e3FA9efe3874827114b20C5BEC40C",HybridDeleGatorImpl:"0x941f3a016F8726d5643Ce62452d0D78492D42b42",AllowedCalldataEnforcer:"0xff71d60f3208469cBCE0859717B5198042DCB3F3",AllowedMethodsEnforcer:"0xe32C2561792e8446Abe73B9f557B881C13906186",AllowedTargetsEnforcer:"0x06aaE4c67EEA95277c46Bf79b1583d4a01772D22",BlockNumberEnforcer:"0x8E470D2Ae278457b42d2405E0B8Cd4BE21Ed9045",DeployedEnforcer:"0xf9088f013dBD9ebb7Cebd66fEB48253c6Ac5a820",ERC20BalanceGteEnforcer:"0xB7B6f32ec6343261D814e55Ed8C5925d91Cab861",ERC20TransferAmountEnforcer:"0x9A069b18032B31429A363AeCFb1B6A0564b44471",IdEnforcer:"0x91015c3b9D9523966eD2399885e5Df7A567f916c",LimitedCallsEnforcer:"0xe694bFfffEA3E85923b1210b37e6a0175e910863",NonceEnforcer:"0xE83BCFD8bBE672A96747e831050a91cf44F4F87A",TimestampEnforcer:"0x550FdD13eEBC1f22ea2a2480024BacBF0Ad7e5CE",ValueLteEnforcer:"0xBE32a6DB7471F63BB168C088c57Db01AfAe87967",NativeTokenTransferAmountEnforcer:"0x5eD3833d7B957A8DB8A461c3AF2d668Ec25382E0",NativeBalanceGteEnforcer:"0x376a98860E210DdEda3689fb39565592c563cB0A",ArgsEqualityCheckEnforcer:"0x7378dE585998d3E18Ce147867C335C25B3dB8Ee5",NativeTokenPaymentEnforcer:"0x87Fe18EbF99e42fcE8A03a25F1d20E119407f8e7",RedeemerEnforcer:"0x926672b130D1EF60A9d6b11D2048d121b30f40C1"},o={DelegationManager:"0xbe4138886cb096bdc1b930f2f0ca7892aa234d78",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",MultiSigDeleGatorImpl:"0x11f555af5844d85bfcf5d61d2a22866527eb585a",HybridDeleGatorImpl:"0xd6edd1256deccb2b06bdecef92dc16bcf26e531b",AllowedCalldataEnforcer:"0x48db3835a873d64a4af2c09f014052407c003bd7",AllowedMethodsEnforcer:"0xfd731951bf1c52afccee3e6f14ab656475b76dd4",AllowedTargetsEnforcer:"0xbc8673c0afa52d86d991c06881e55b2966920564",BlockNumberEnforcer:"0xc15faffa0d879b9263c15a46ce31eacfa2e0e8ae",DeployedEnforcer:"0x5accb9559b56a6c1e3f90e342c85c42d93720d43",ERC20BalanceGteEnforcer:"0xb5d6b1ec6d868a3bae5b7f48178eaa2686a7a087",ERC20TransferAmountEnforcer:"0x92ac423b9c111962179a6242e1adb58d02c103be",IdEnforcer:"0x34152d9f3f8f74338d50703e780389e829b4abac",LimitedCallsEnforcer:"0x4b3adad4a328bee8ba17b86074d92fe7372180cd",NonceEnforcer:"0x2f32ff3fc3086d7f63f16fe8d0065390d460b40d",TimestampEnforcer:"0x78e05f779490c24bf3bfa135b4112e7003b321cd",ValueLteEnforcer:"0xfc20ede0a1132e839fbda9d7ed3904ff3c89540f"},a={mainnet:1,optimism:10,bsc:56,gnosis:100,polygon:137,base:8453,arbitrum:42161,linea:59144,berachain:80094,unichain:130,arbitrumNova:42170,bscTestnet:97,megaEthTestnet:6342,chiado:10200,lineaSepolia:59141,berachainBepolia:80069,baseSepolia:84532,arbitrumSepolia:421614,sepolia:11155111,optimismSepolia:11155420,unichainSepolia:1301,polygonAmoy:80002,monadTestnet:10143,lineaGoerli:59140},i={"1.0.0":{[a.optimism]:o,[a.polygon]:o,[a.base]:o,[a.arbitrum]:o,[a.linea]:o,[a.sepolia]:{...o,HybridDeleGatorImpl:"0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"},[a.lineaSepolia]:{...o,HybridDeleGatorImpl:"0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"}},"1.1.0":{[a.arbitrum]:s,[a.base]:s,[a.linea]:s,[a.optimism]:s,[a.polygon]:s,[a.sepolia]:s,[a.lineaSepolia]:s,[a.baseSepolia]:{...s,SimpleFactory:"0xE8eA1DE8D6AfE400B7C8C1A81B7C29B7876b4d02"}},"1.3.0":{[a.mainnet]:r,[a.polygon]:r,[a.bsc]:r,[a.optimism]:r,[a.arbitrum]:r,[a.linea]:r,[a.base]:r,[a.gnosis]:r,[a.berachain]:r,[a.unichain]:r,[a.arbitrumNova]:r,[a.sepolia]:r,[a.lineaSepolia]:r,[a.baseSepolia]:r,[a.megaEthTestnet]:r,[a.chiado]:r,[a.bscTestnet]:r,[a.optimismSepolia]:r,[a.arbitrumSepolia]:r,[a.berachainBepolia]:r,[a.unichainSepolia]:r,[a.polygonAmoy]:r,[a.monadTestnet]:r}};n.CHAIN_ID=a,n.DELEGATOR_CONTRACTS=i}}},{package:"@metamask/gator-permissions-controller>@metamask/delegation-deployments",file:"node_modules/@metamask/gator-permissions-controller/node_modules/@metamask/delegation-deployments/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs",{"./v2/utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/utils.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i,c,m,d,u,l,h,f,p,g=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},y=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},k=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcEngine=void 0;const b=e("@metamask/rpc-errors"),x=k(e("@metamask/safe-event-emitter")),w=e("@metamask/utils"),_=e("./v2/utils.cjs");class v extends x.default{constructor({notificationHandler:e}={}){super(),r.add(this),o.set(this,!1),a.set(this,void 0),i.set(this,void 0),g(this,a,[],"f"),g(this,i,e,"f")}destroy(){y(this,a,"f").forEach(e=>{"destroy"in e&&"function"==typeof e.destroy&&e.destroy()}),g(this,a,[],"f"),g(this,o,!0,"f")}push(e){y(this,r,"m",c).call(this),y(this,a,"f").push(e)}handle(e,t){if(y(this,r,"m",c).call(this),t&&"function"!=typeof t)throw new Error('"callback" must be a function if provided.');return Array.isArray(e)?t?y(this,r,"m",m).call(this,e,t):y(this,r,"m",m).call(this,e):t?y(this,r,"m",d).call(this,e,t):this._promiseHandle(e)}asMiddleware(){return y(this,r,"m",c).call(this),async(e,t,n,r)=>{try{const[o,i,c]=await y(s,s,"m",l).call(s,e,t,y(this,a,"f"));return i?(await y(s,s,"m",f).call(s,c),r(o)):n(async e=>{try{await y(s,s,"m",f).call(s,c)}catch(t){return e(t)}return e()})}catch(e){return r(e)}}}async _promiseHandle(e){return new Promise((t,n)=>{y(this,r,"m",d).call(this,e,(e,r)=>{e&&r===undefined?n(e):t(r)}).catch(n)})}}n.JsonRpcEngine=v,s=v,o=new WeakMap,a=new WeakMap,i=new WeakMap,r=new WeakSet,c=function(){if(y(this,o,"f"))throw new Error("This engine is destroyed and can no longer be used.")},m=async function(e,t){try{if(0===e.length){const e=[{id:null,jsonrpc:"2.0",error:new b.JsonRpcError(b.errorCodes.rpc.invalidRequest,"Request batch must contain plain objects. Received an empty array")}];return t?t(null,e):e}const n=(await Promise.all(e.map(this._promiseHandle.bind(this)))).filter(e=>e!==undefined);return t?t(null,n):n}catch(e){if(t)return t(e);throw e}},d=async function(e,t){if(!e||Array.isArray(e)||"object"!=typeof e){const n=new b.JsonRpcError(b.errorCodes.rpc.invalidRequest,"Requests must be plain objects. Received: "+typeof e,{request:e});return t(n,{id:null,jsonrpc:"2.0",error:n})}if("string"!=typeof e.method){const n=new b.JsonRpcError(b.errorCodes.rpc.invalidRequest,"Must specify a string method. Received: "+typeof e.method,{request:e});return y(this,i,"f")&&!(0,w.isJsonRpcRequest)(e)?t(null):t(n,{id:e.id??null,jsonrpc:"2.0",error:n})}if(y(this,i,"f")&&(0,w.isJsonRpcNotification)(e)&&!(0,w.isJsonRpcRequest)(e)){try{await y(this,i,"f").call(this,e)}catch(n){return t(n)}return t(null)}let n=null;const r={...e},o={id:r.id,jsonrpc:r.jsonrpc};try{await y(s,s,"m",u).call(s,r,o,y(this,a,"f"))}catch(e){n=e}return n&&(delete o.result,o.error||(o.error=(0,b.serializeError)(n))),t(n,o)},u=async function(e,t,n){const[r,o,a]=await y(s,s,"m",l).call(s,e,t,n);if(y(s,s,"m",p).call(s,e,t,o),await y(s,s,"m",f).call(s,a),r)throw r},l=async function(e,t,n){const r=[];let o=null,a=!1;for(const i of n)if([o,a]=await y(s,s,"m",h).call(s,e,t,i,r),a)break;return[o,a,r.reverse()]},h=async function(e,t,n,r){return new Promise(s=>{const o=e=>{const n=e||t.error;n&&(t.error=(0,b.serializeError)(n)),s([n,!0])},a=n=>{t.error?o(t.error):(n&&("function"!=typeof n&&o(new b.JsonRpcError(b.errorCodes.rpc.internal,`JsonRpcEngine: "next" return handlers must be functions. Received "${typeof n}" for request:\n${(0,_.stringify)(e)}`,{request:e})),r.push(n)),s([null,!1]))};try{n(e,t,a,o)}catch(e){o(e)}})},f=async function(e){for(const t of e)await new Promise((e,n)=>{t(t=>t?n(t):e())})},p=function(e,t,n){if(!(0,w.hasProperty)(t,"result")&&!(0,w.hasProperty)(t,"error"))throw new b.JsonRpcError(b.errorCodes.rpc.internal,`JsonRpcEngine: Response has no error or result for request:\n${(0,_.stringify)(e)}`,{request:e});if(!n)throw new b.JsonRpcError(b.errorCodes.rpc.internal,`JsonRpcEngine: Nothing ended request:\n${(0,_.stringify)(e)}`,{request:e})}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/asV2Middleware.cjs",{"./mergeMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs","./v2/compatibility-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/compatibility-utils.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.asV2Middleware=void 0;const r=e("@metamask/rpc-errors"),s=e("@metamask/utils"),o=e("./mergeMiddleware.cjs"),a=e("./v2/compatibility-utils.cjs");n.asV2Middleware=function(e,...t){const n="function"==typeof e?(0,o.mergeMiddleware)([e,...t]):e.asMiddleware();return async({request:e,context:t,next:o})=>{const i=(0,a.deepClone)(e);(0,a.propagateToRequest)(i,t);const c=await new Promise(e=>{const t={jsonrpc:"2.0",id:i.id},s=n=>{n!==undefined&&(t.error=(0,r.serializeError)(n)),e(t)};n(i,t,e=>e(s),s)});if((0,a.propagateToContext)(i,t),(0,s.hasProperty)(c,"error")&&c.error)throw(0,a.deserializeError)(c.error);return(0,s.hasProperty)(c,"result")?c.result:o((0,a.fromLegacyRequest)(i))}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/asV2Middleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createAsyncMiddleware=void 0,n.createAsyncMiddleware=function(e){return async(t,n,r,s)=>{let o;const a=new Promise(e=>{o=e});let i=null,c=!1;const m=async()=>(c=!0,r(e=>{i=e,o()}),a);try{await e(t,n,m),c?(await a,i(null)):s(null)}catch(e){i?i(e):s(e)}}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createScaffoldMiddleware=void 0,n.createScaffoldMiddleware=function(e){return(t,n,r,s)=>{const o=e[t.method];return o===undefined?r():"function"==typeof o?o(t,n,r,s):(n.result=o,s())}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getUniqueId=void 0;const r=4294967295;let s=Math.floor(Math.random()*r);n.getUniqueId=function(){return s=(s+1)%r,s}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs",{"./getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createIdRemapMiddleware=void 0;const r=e("./getUniqueId.cjs");n.createIdRemapMiddleware=function(){return(e,t,n,s)=>{const o=e.id,a=(0,r.getUniqueId)();e.id=a,t.id=a,n(n=>{e.id=o,t.id=o,n()})}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs",{"./JsonRpcEngine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs","./asV2Middleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/asV2Middleware.cjs","./createAsyncMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs","./createScaffoldMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs","./getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs","./idRemapMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs","./mergeMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMiddleware=n.JsonRpcEngine=n.createIdRemapMiddleware=n.getUniqueId=n.createScaffoldMiddleware=n.createAsyncMiddleware=n.asV2Middleware=void 0;var r=e("./asV2Middleware.cjs");Object.defineProperty(n,"asV2Middleware",{enumerable:!0,get:function(){return r.asV2Middleware}});var s=e("./createAsyncMiddleware.cjs");Object.defineProperty(n,"createAsyncMiddleware",{enumerable:!0,get:function(){return s.createAsyncMiddleware}});var o=e("./createScaffoldMiddleware.cjs");Object.defineProperty(n,"createScaffoldMiddleware",{enumerable:!0,get:function(){return o.createScaffoldMiddleware}});var a=e("./getUniqueId.cjs");Object.defineProperty(n,"getUniqueId",{enumerable:!0,get:function(){return a.getUniqueId}});var i=e("./idRemapMiddleware.cjs");Object.defineProperty(n,"createIdRemapMiddleware",{enumerable:!0,get:function(){return i.createIdRemapMiddleware}});var c=e("./JsonRpcEngine.cjs");Object.defineProperty(n,"JsonRpcEngine",{enumerable:!0,get:function(){return c.JsonRpcEngine}});var m=e("./mergeMiddleware.cjs");Object.defineProperty(n,"mergeMiddleware",{enumerable:!0,get:function(){return m.mergeMiddleware}})}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs",{"./JsonRpcEngine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMiddleware=void 0;const r=e("./JsonRpcEngine.cjs");n.mergeMiddleware=function(e){const t=new r.JsonRpcEngine;return e.forEach(e=>t.push(e)),t.asMiddleware()}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcEngineV2.cjs",{"./MiddlewareContext.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/MiddlewareContext.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","deep-freeze-strict":"/home/runner/work/metamask-extension/metamask-extension/node_modules/deep-freeze-strict/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i,c,m,d,u,l=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},h=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcEngineV2=void 0;const p=e("@metamask/utils"),g=f(e("deep-freeze-strict")),y=e("./MiddlewareContext.cjs"),k=e("./utils.cjs");Symbol("Invalid engine");class b{constructor({middleware:e}){r.add(this),s.set(this,void 0),o.set(this,!1),l(this,s,[...e],"f")}static create({middleware:e}){if(0===e.length)throw new k.JsonRpcEngineError("Middleware array cannot be empty");return new b({middleware:e})}async handle(e,{context:t}={}){const n=(0,k.isRequest)(e),{result:s}=await h(this,r,"m",a).call(this,e,t);if(n&&s===undefined)throw new k.JsonRpcEngineError(`Nothing ended request: ${(0,k.stringify)(e)}`);return s}asMiddleware(){return h(this,r,"m",u).call(this),async({request:e,context:t,next:n})=>{const{result:s,request:o}=await h(this,r,"m",a).call(this,e,t);return s===undefined?await n(o):s}}async destroy(){if(h(this,o,"f"))return;l(this,o,!0,"f");const e=Promise.all(h(this,s,"f").map(async e=>"destroy"in e&&"function"==typeof e.destroy?e.destroy():undefined));l(this,s,[],"f"),await e}}n.JsonRpcEngineV2=b,s=new WeakMap,o=new WeakMap,r=new WeakSet,a=async function(e,t=new y.MiddlewareContext){h(this,r,"m",u).call(this),(0,g.default)(e);const n={request:e,result:undefined},s=h(this,r,"m",c).call(this),o=s.next().value,a=y.MiddlewareContext.isInstance(t)?t:new y.MiddlewareContext(t),d=h(this,r,"m",i).call(this,s,n,a),l=await o({request:e,context:a,next:d()});return h(this,r,"m",m).call(this,l,n),n},i=function(e,t,n){const s=()=>{let o=!1;return async(a=t.request)=>{if(o)throw new k.JsonRpcEngineError(`Middleware attempted to call next() multiple times for request: ${(0,k.stringify)(a)}`);o=!0,a!==t.request&&(h(this,r,"m",d).call(this,t.request,a),t.request=(0,g.default)(a));const{value:i,done:c}=e.next();if(c)return undefined;const u=await i({request:a,context:n,next:s()});return h(this,r,"m",m).call(this,u,t),t.result}};return s},c=function(){return h(this,s,"f")[Symbol.iterator]()},m=function(e,t){if((0,k.isNotification)(t.request)&&e!==undefined)throw new k.JsonRpcEngineError(`Result returned for notification: ${(0,k.stringify)(t.request)}`);e!==undefined&&e!==t.result&&("object"==typeof e&&null!==e&&(0,g.default)(e),t.result=e)},d=function(e,t){if(t.jsonrpc!==e.jsonrpc)throw new k.JsonRpcEngineError(`Middleware attempted to modify readonly property "jsonrpc" for request: ${(0,k.stringify)(e)}`);if((0,p.hasProperty)(t,"id")!==(0,p.hasProperty)(e,"id")||t.id!==e.id)throw new k.JsonRpcEngineError(`Middleware attempted to modify readonly property "id" for request: ${(0,k.stringify)(e)}`)},u=function(){if(h(this,o,"f"))throw new k.JsonRpcEngineError("Engine is destroyed")}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcEngineV2.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcServer.cjs",{"../getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs","./JsonRpcEngineV2.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcEngineV2.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},c=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcServer=void 0;const m=e("@metamask/rpc-errors"),d=e("@metamask/utils"),u=e("./JsonRpcEngineV2.cjs"),l=e("../getUniqueId.cjs"),h="2.0";class f{constructor(e){s.set(this,void 0),o.set(this,void 0),i(this,o,e.onError,"f"),(0,d.hasProperty)(e,"engine")?i(this,s,e.engine,"f"):i(this,s,u.JsonRpcEngineV2.create({middleware:e.middleware}),"f")}async handle(e,t){const[n,i]=function(e){if((0,d.isObject)(e)&&(0,d.hasProperty)(e,"id"))return[e.id,!0];return[undefined,!1]}(e);try{const o=c(r,r,"m",a).call(r,e,i),m=await c(this,s,"f").handle(o,t);if(m!==undefined)return{jsonrpc:h,id:n,result:m}}catch(e){if(c(this,o,"f")?.call(this,e),i)return{jsonrpc:h,id:n,error:(0,m.serializeError)(e,{shouldIncludeStack:!1,shouldPreserveMessage:!0})}}return undefined}}n.JsonRpcServer=f,r=f,s=new WeakMap,o=new WeakMap,a=function(e,t){if(!function(e){return(0,d.isObject)(e)&&(0,d.hasProperty)(e,"method")&&"string"==typeof e.method&&function(e){if((0,d.hasProperty)(e,"params"))return Array.isArray(e.params)||(0,d.isObject)(e.params);return!0}(e)}(e))throw m.rpcErrors.invalidRequest({data:{request:e}});const n={jsonrpc:h,method:e.method};return(0,d.hasProperty)(e,"params")&&(n.params=e.params),t&&(n.id=(0,l.getUniqueId)()),n}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcServer.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/MiddlewareContext.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.MiddlewareContext=void 0;const s=e("./utils.cjs"),o=Symbol.for("json-rpc-engine#MiddlewareContext");class a extends Map{static isInstance(e){return(0,s.isInstance)(e,o)}constructor(e){var t,n;super(e&&(n=e,Symbol.iterator in n)?e:(t=e??{},Reflect.ownKeys(t).map(e=>[e,t[e]]))),this[r]=!0,Object.freeze(this)}get(e){return super.get(e)}assertGet(e){if(!super.has(e))throw new Error(`Context key "${String(e)}" not found`);return super.get(e)}set(e,t){if(super.has(e))throw new Error(`MiddlewareContext key "${String(e)}" already exists`);return super.set(e,t),this}}n.MiddlewareContext=a,r=o}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/MiddlewareContext.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/asLegacyMiddleware.cjs",{"../index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","./JsonRpcEngineV2.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcEngineV2.cjs","./compatibility-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/compatibility-utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.asLegacyMiddleware=void 0;const r=e("./compatibility-utils.cjs"),s=e("./JsonRpcEngineV2.cjs"),o=e("../index.cjs");n.asLegacyMiddleware=function(e,...t){const n="function"==typeof e?s.JsonRpcEngineV2.create({middleware:[e,...t]}).asMiddleware():e.asMiddleware();return(0,o.createAsyncMiddleware)(async(e,t,s)=>{const o=(0,r.fromLegacyRequest)(e),a=(0,r.makeContext)(e);let i;const c=await n({request:o,context:a,next:e=>(i=e,Promise.resolve(undefined))});return i!==undefined&&i!==o&&Object.assign(e,(0,r.deepClone)(i)),(0,r.propagateToRequest)(e,a),c!==undefined?(t.result=(0,r.deepClone)(c),undefined):s()})}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/asLegacyMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/compatibility-utils.cjs",{"./MiddlewareContext.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/MiddlewareContext.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/utils.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",klona:"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deserializeError=n.propagateToRequest=n.propagateToContext=n.makeContext=n.fromLegacyRequest=n.requestProps=n.deepClone=void 0;const r=e("@metamask/rpc-errors"),s=e("@metamask/utils"),o=e("klona"),a=e("./MiddlewareContext.cjs"),i=e("./utils.cjs");function c(e,t){Object.keys(e).filter(e=>"string"==typeof e&&!n.requestProps.includes(e)&&!t.has(e)).forEach(n=>{t.set(n,e[n])})}n.deepClone=e=>(0,o.klona)(e),n.requestProps=["jsonrpc","method","params","id"],n.fromLegacyRequest=function(e){const t={jsonrpc:"2.0",method:e.method};return t.id=e.id,(0,s.hasProperty)(e,"params")&&e.params!==undefined&&(t.params=(0,n.deepClone)(e.params)),t},n.makeContext=function(e){const t=new a.MiddlewareContext;return c(e,t),t},n.propagateToContext=c,n.propagateToRequest=function(e,t){Array.from(t.keys()).filter(e=>"string"==typeof e&&!n.requestProps.includes(e)).forEach(n=>{e[n]=t.get(n)})},n.deserializeError=function(e){if("function"==typeof Error.isError&&Error.isError(e))return e;if(e instanceof Error)return e;if("string"==typeof e)return new Error(e);if(!(0,s.isObject)(e))return new Error(`Unknown error: ${(0,i.stringify)(e)}`);const t="number"==typeof e.code&&Number.isInteger(e.code)?e.code:undefined;let n="Unknown error";"string"==typeof e.message?n=e.message:"number"==typeof t&&(n=(0,r.getMessageFromCode)(t,n));const{stack:o,cause:a,data:c}=e,m=t===undefined?new Error(n,{cause:a}):new r.JsonRpcError(t,n,{...(0,s.isObject)(c)?c:undefined,cause:a});return"string"==typeof o&&(m.stack=o),m}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/compatibility-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/createScaffoldMiddleware.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createScaffoldMiddleware=void 0,n.createScaffoldMiddleware=function(e){return({request:t,context:n,next:r})=>{const s=e[t.method];return s===undefined?r():"function"==typeof s?s({request:t,context:n,next:r}):s}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/createScaffoldMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/index.cjs",{"../getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs","./JsonRpcEngineV2.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcEngineV2.cjs","./JsonRpcServer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/JsonRpcServer.cjs","./MiddlewareContext.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/MiddlewareContext.cjs","./asLegacyMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/asLegacyMiddleware.cjs","./createScaffoldMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/createScaffoldMiddleware.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcEngineError=n.isRequest=n.isNotification=n.MiddlewareContext=n.JsonRpcServer=n.JsonRpcEngineV2=n.createScaffoldMiddleware=n.getUniqueId=n.asLegacyMiddleware=void 0;var r=e("./asLegacyMiddleware.cjs");Object.defineProperty(n,"asLegacyMiddleware",{enumerable:!0,get:function(){return r.asLegacyMiddleware}});var s=e("../getUniqueId.cjs");Object.defineProperty(n,"getUniqueId",{enumerable:!0,get:function(){return s.getUniqueId}});var o=e("./createScaffoldMiddleware.cjs");Object.defineProperty(n,"createScaffoldMiddleware",{enumerable:!0,get:function(){return o.createScaffoldMiddleware}});var a=e("./JsonRpcEngineV2.cjs");Object.defineProperty(n,"JsonRpcEngineV2",{enumerable:!0,get:function(){return a.JsonRpcEngineV2}});var i=e("./JsonRpcServer.cjs");Object.defineProperty(n,"JsonRpcServer",{enumerable:!0,get:function(){return i.JsonRpcServer}});var c=e("./MiddlewareContext.cjs");Object.defineProperty(n,"MiddlewareContext",{enumerable:!0,get:function(){return c.MiddlewareContext}});var m=e("./utils.cjs");Object.defineProperty(n,"isNotification",{enumerable:!0,get:function(){return m.isNotification}}),Object.defineProperty(n,"isRequest",{enumerable:!0,get:function(){return m.isRequest}}),Object.defineProperty(n,"JsonRpcEngineError",{enumerable:!0,get:function(){return m.JsonRpcEngineError}})}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcEngineError=n.isInstance=n.stringify=n.isNotification=n.isRequest=void 0;const s=e("@metamask/utils");n.isRequest=e=>(0,s.hasProperty)(e,"id");n.isNotification=e=>!(0,n.isRequest)(e),n.stringify=function(e){return JSON.stringify(e,null,2)};n.isInstance=(e,t)=>(0,s.isObject)(e)&&t in e&&!0===e[t];const o=Symbol.for("json-rpc-engine#JsonRpcEngineError");class a extends Error{constructor(e){super(e),this[r]=!0,this.name="JsonRpcEngineError"}static isInstance(e){return(0,n.isInstance)(e,o)}}n.JsonRpcEngineError=a,r=o}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/v2/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/v2.js",{"./dist/v2/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/v2/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./dist/v2/index.cjs")}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/v2.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createEngineStream.cjs",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("readable-stream");n.default=function(e){if(!e?.engine)throw new Error("Missing engine parameter!");const{engine:t}=e,n=new r.Duplex({objectMode:!0,read:()=>undefined,write:function(e,r,s){t.handle(e,(e,t)=>{n.push(t)}),s()}});return t.on&&t.on("notification",e=>{n.push(e)}),n}}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/createEngineStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createStreamMiddleware.cjs",{"@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0});const s=r(e("@metamask/safe-event-emitter")),o=e("@metamask/utils"),a=e("readable-stream");n.default=function(e={}){const t={},n=new a.Duplex({objectMode:!0,read:()=>undefined,write:function(n,s,a){let c=null;try{!(0,o.hasProperty)(n,"id")?function(n){e?.retryOnMessage&&n.method===e.retryOnMessage&&Object.values(t).forEach(({req:e,retryCount:n=0})=>{if(!e.id)return;if(n>=3)throw new Error(`StreamMiddleware - Retry limit exceeded for request id "${e.id}"`);const r=t[e.id];r&&(r.retryCount=n+1),i(e)});r.emit("notification",n)}(n):function(e){const{id:n}=e;if(null===n)return;const r=t[n];if(!r)return void console.warn(`StreamMiddleware - Unknown response id "${n}"`);delete t[n],Object.assign(r.res,e),setTimeout(r.end)}(n)}catch(e){c=e}a(c)}}),r=new s.default;return{events:r,middleware:(e,n,r,s)=>{t[e.id]={req:e,res:n,next:r,end:s},i(e)},stream:n};function i(e){n.push(e)}}}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/createStreamMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs",{"./createEngineStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createEngineStream.cjs","./createStreamMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createStreamMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.createStreamMiddleware=n.createEngineStream=void 0;const s=r(e("./createEngineStream.cjs"));n.createEngineStream=s.default;const o=r(e("./createStreamMiddleware.cjs"));n.createStreamMiddleware=o.default}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r={};function s(e,t,n){n||(n=Error);var s=function(e){var n,r;function s(n,r,s){return e.call(this,function(e,n,r){return"string"==typeof t?t:t(e,n,r)}(n,r,s))||this}return r=e,(n=s).prototype=Object.create(r.prototype),n.prototype.constructor=n,n.__proto__=r,s}(n);s.prototype.name=n.name,s.prototype.code=e,r[e]=s}function o(e,t){if(Array.isArray(e)){var n=e.length;return e=e.map(function(e){return String(e)}),n>2?"one of ".concat(t," ").concat(e.slice(0,n-1).join(", "),", or ")+e[n-1]:2===n?"one of ".concat(t," ").concat(e[0]," or ").concat(e[1]):"of ".concat(t," ").concat(e[0])}return"of ".concat(t," ").concat(String(e))}s("ERR_INVALID_OPT_VALUE",function(e,t){return'The value "'+t+'" is invalid for option "'+e+'"'},TypeError),s("ERR_INVALID_ARG_TYPE",function(e,t,n){var r,s,a,i;if("string"==typeof t&&(s="not ",t.substr(!a||a<0?0:+a,s.length)===s)?(r="must not be",t=t.replace(/^not /,"")):r="must be",function(e,t,n){return(n===undefined||n>e.length)&&(n=e.length),e.substring(n-t.length,n)===t}(e," argument"))i="The ".concat(e," ").concat(r," ").concat(o(t,"type"));else{var c=function(e,t,n){return"number"!=typeof n&&(n=0),!(n+t.length>e.length)&&-1!==e.indexOf(t,n)}(e,".")?"property":"argument";i='The "'.concat(e,'" ').concat(c," ").concat(r," ").concat(o(t,"type"))}return i+=". Received type ".concat(typeof n)},TypeError),s("ERR_STREAM_PUSH_AFTER_EOF","stream.push() after EOF"),s("ERR_METHOD_NOT_IMPLEMENTED",function(e){return"The "+e+" method is not implemented"}),s("ERR_STREAM_PREMATURE_CLOSE","Premature close"),s("ERR_STREAM_DESTROYED",function(e){return"Cannot call "+e+" after a stream was destroyed"}),s("ERR_MULTIPLE_CALLBACK","Callback called multiple times"),s("ERR_STREAM_CANNOT_PIPE","Cannot pipe, not readable"),s("ERR_STREAM_WRITE_AFTER_END","write after end"),s("ERR_STREAM_NULL_VALUES","May not write null values to stream",TypeError),s("ERR_UNKNOWN_ENCODING",function(e){return"Unknown encoding: "+e},TypeError),s("ERR_STREAM_UNSHIFT_AFTER_END_EVENT","stream.unshift() after end event"),t.exports.codes=r}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_duplex.js",{"./_stream_readable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_readable.js","./_stream_writable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_writable.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r=Object.keys||function(e){var t=[];for(var n in e)t.push(n);return t};t.exports=m;var s=e("./_stream_readable"),o=e("./_stream_writable");e("inherits")(m,s);for(var a=r(o.prototype),i=0;i<a.length;i++){var c=a[i];m.prototype[c]||(m.prototype[c]=o.prototype[c])}function m(e){if(!(this instanceof m))return new m(e);s.call(this,e),o.call(this,e),this.allowHalfOpen=!0,e&&(!1===e.readable&&(this.readable=!1),!1===e.writable&&(this.writable=!1),!1===e.allowHalfOpen&&(this.allowHalfOpen=!1,this.once("end",d)))}function d(){this._writableState.ended||n.nextTick(u,this)}function u(e){e.end()}Object.defineProperty(m.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(m.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(m.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(m.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed&&this._writableState.destroyed)},set:function(e){this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_duplex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_passthrough.js",{"./_stream_transform":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_transform.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=s;var r=e("./_stream_transform");function s(e){if(!(this instanceof s))return new s(e);r.call(this,e)}e("inherits")(s,r),s.prototype._transform=function(e,t,n){n(null,e)}}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_passthrough.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_readable.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js","./_stream_duplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_duplex.js","./internal/streams/async_iterator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/async_iterator.js","./internal/streams/buffer_list":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/buffer_list.js","./internal/streams/destroy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/destroy.js","./internal/streams/from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/from-browser.js","./internal/streams/state":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/state.js","./internal/streams/stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js","string_decoder/":"/home/runner/work/metamask-extension/metamask-extension/node_modules/string_decoder/lib/string_decoder.js",util:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r;t.exports=E,E.ReadableState=v;e("events").EventEmitter;var s=function(e,t){return e.listeners(t).length},o=e("./internal/streams/stream"),a=e("buffer").Buffer,i=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var c,m=e("util");c=m&&m.debuglog?m.debuglog("stream"):function(){};var d,u,l,h=e("./internal/streams/buffer_list"),f=e("./internal/streams/destroy"),p=e("./internal/streams/state").getHighWaterMark,g=e("../errors").codes,y=g.ERR_INVALID_ARG_TYPE,k=g.ERR_STREAM_PUSH_AFTER_EOF,b=g.ERR_METHOD_NOT_IMPLEMENTED,x=g.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;e("inherits")(E,o);var w=f.errorOrDestroy,_=["error","close","destroy","pause","resume"];function v(t,n,s){r=r||e("./_stream_duplex"),t=t||{},"boolean"!=typeof s&&(s=n instanceof r),this.objectMode=!!t.objectMode,s&&(this.objectMode=this.objectMode||!!t.readableObjectMode),this.highWaterMark=p(this,t,"readableHighWaterMark",s),this.buffer=new h,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.paused=!0,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.destroyed=!1,this.defaultEncoding=t.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,t.encoding&&(d||(d=e("string_decoder/").StringDecoder),this.decoder=new d(t.encoding),this.encoding=t.encoding)}function E(t){if(r=r||e("./_stream_duplex"),!(this instanceof E))return new E(t);var n=this instanceof r;this._readableState=new v(t,this,n),this.readable=!0,t&&("function"==typeof t.read&&(this._read=t.read),"function"==typeof t.destroy&&(this._destroy=t.destroy)),o.call(this)}function j(e,t,n,r,s){c("readableAddChunk",t);var o,m=e._readableState;if(null===t)m.reading=!1,function(e,t){if(c("onEofChunk"),t.ended)return;if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,t.sync?P(e):(t.needReadable=!1,t.emittedReadable||(t.emittedReadable=!0,B(e)))}(e,m);else if(s||(o=function(e,t){var n;r=t,a.isBuffer(r)||r instanceof i||"string"==typeof t||t===undefined||e.objectMode||(n=new y("chunk",["string","Buffer","Uint8Array"],t));var r;return n}(m,t)),o)w(e,o);else if(m.objectMode||t&&t.length>0)if("string"==typeof t||m.objectMode||Object.getPrototypeOf(t)===a.prototype||(t=function(e){return a.from(e)}(t)),r)m.endEmitted?w(e,new x):T(e,m,t,!0);else if(m.ended)w(e,new k);else{if(m.destroyed)return!1;m.reading=!1,m.decoder&&!n?(t=m.decoder.write(t),m.objectMode||0!==t.length?T(e,m,t,!1):I(e,m)):T(e,m,t,!1)}else r||(m.reading=!1,I(e,m));return!m.ended&&(m.length<m.highWaterMark||0===m.length)}function T(e,t,n,r){t.flowing&&0===t.length&&!t.sync?(t.awaitDrain=0,e.emit("data",n)):(t.length+=t.objectMode?1:n.length,r?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&P(e)),I(e,t)}Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),E.prototype.destroy=f.destroy,E.prototype._undestroy=f.undestroy,E.prototype._destroy=function(e,t){t(e)},E.prototype.push=function(e,t){var n,r=this._readableState;return r.objectMode?n=!0:"string"==typeof e&&((t=t||r.defaultEncoding)!==r.encoding&&(e=a.from(e,t),t=""),n=!0),j(this,e,t,!1,n)},E.prototype.unshift=function(e){return j(this,e,null,!0,!1)},E.prototype.isPaused=function(){return!1===this._readableState.flowing},E.prototype.setEncoding=function(t){d||(d=e("string_decoder/").StringDecoder);var n=new d(t);this._readableState.decoder=n,this._readableState.encoding=this._readableState.decoder.encoding;for(var r=this._readableState.buffer.head,s="";null!==r;)s+=n.write(r.data),r=r.next;return this._readableState.buffer.clear(),""!==s&&this._readableState.buffer.push(s),this._readableState.length=s.length,this};var A=1073741824;function C(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=A?e=A:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function P(e){var t=e._readableState;c("emitReadable",t.needReadable,t.emittedReadable),t.needReadable=!1,t.emittedReadable||(c("emitReadable",t.flowing),t.emittedReadable=!0,n.nextTick(B,e))}function B(e){var t=e._readableState;c("emitReadable_",t.destroyed,t.length,t.ended),t.destroyed||!t.length&&!t.ended||(e.emit("readable"),t.emittedReadable=!1),t.needReadable=!t.flowing&&!t.ended&&t.length<=t.highWaterMark,F(e)}function I(e,t){t.readingMore||(t.readingMore=!0,n.nextTick(D,e,t))}function D(e,t){for(;!t.reading&&!t.ended&&(t.length<t.highWaterMark||t.flowing&&0===t.length);){var n=t.length;if(c("maybeReadMore read 0"),e.read(0),n===t.length)break}t.readingMore=!1}function S(e){var t=e._readableState;t.readableListening=e.listenerCount("readable")>0,t.resumeScheduled&&!t.paused?t.flowing=!0:e.listenerCount("data")>0&&e.resume()}function R(e){c("readable nexttick read 0"),e.read(0)}function O(e,t){c("resume",t.reading),t.reading||e.read(0),t.resumeScheduled=!1,e.emit("resume"),F(e),t.flowing&&!t.reading&&e.read(0)}function F(e){var t=e._readableState;for(c("flow",t.flowing);t.flowing&&null!==e.read(););}function M(e,t){return 0===t.length?null:(t.objectMode?n=t.buffer.shift():!e||e>=t.length?(n=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.first():t.buffer.concat(t.length),t.buffer.clear()):n=t.buffer.consume(e,t.decoder),n);var n}function N(e){var t=e._readableState;c("endReadable",t.endEmitted),t.endEmitted||(t.ended=!0,n.nextTick(q,t,e))}function q(e,t){if(c("endReadableNT",e.endEmitted,e.length),!e.endEmitted&&0===e.length&&(e.endEmitted=!0,t.readable=!1,t.emit("end"),e.autoDestroy)){var n=t._writableState;(!n||n.autoDestroy&&n.finished)&&t.destroy()}}function L(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}E.prototype.read=function(e){c("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&((0!==t.highWaterMark?t.length>=t.highWaterMark:t.length>0)||t.ended))return c("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?N(this):P(this),null;if(0===(e=C(e,t))&&t.ended)return 0===t.length&&N(this),null;var r,s=t.needReadable;return c("need readable",s),(0===t.length||t.length-e<t.highWaterMark)&&c("length less than watermark",s=!0),t.ended||t.reading?c("reading or ended",s=!1):s&&(c("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=C(n,t))),null===(r=e>0?M(e,t):null)?(t.needReadable=t.length<=t.highWaterMark,e=0):(t.length-=e,t.awaitDrain=0),0===t.length&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&N(this)),null!==r&&this.emit("data",r),r},E.prototype._read=function(e){w(this,new b("_read()"))},E.prototype.pipe=function(e,t){var r=this,o=this._readableState;switch(o.pipesCount){case 0:o.pipes=e;break;case 1:o.pipes=[o.pipes,e];break;default:o.pipes.push(e)}o.pipesCount+=1,c("pipe count=%d opts=%j",o.pipesCount,t);var a=(!t||!1!==t.end)&&e!==n.stdout&&e!==n.stderr?m:g;function i(t,n){c("onunpipe"),t===r&&n&&!1===n.hasUnpiped&&(n.hasUnpiped=!0,c("cleanup"),e.removeListener("close",f),e.removeListener("finish",p),e.removeListener("drain",d),e.removeListener("error",h),e.removeListener("unpipe",i),r.removeListener("end",m),r.removeListener("end",g),r.removeListener("data",l),u=!0,!o.awaitDrain||e._writableState&&!e._writableState.needDrain||d())}function m(){c("onend"),e.end()}o.endEmitted?n.nextTick(a):r.once("end",a),e.on("unpipe",i);var d=function(e){return function(){var t=e._readableState;c("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&s(e,"data")&&(t.flowing=!0,F(e))}}(r);e.on("drain",d);var u=!1;function l(t){c("ondata");var n=e.write(t);c("dest.write",n),!1===n&&((1===o.pipesCount&&o.pipes===e||o.pipesCount>1&&-1!==L(o.pipes,e))&&!u&&(c("false write response, pause",o.awaitDrain),o.awaitDrain++),r.pause())}function h(t){c("onerror",t),g(),e.removeListener("error",h),0===s(e,"error")&&w(e,t)}function f(){e.removeListener("finish",p),g()}function p(){c("onfinish"),e.removeListener("close",f),g()}function g(){c("unpipe"),r.unpipe(e)}return r.on("data",l),function(e,t,n){if("function"==typeof e.prependListener)return e.prependListener(t,n);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]:e.on(t,n)}(e,"error",h),e.once("close",f),e.once("finish",p),e.emit("pipe",r),o.flowing||(c("pipe resume"),r.resume()),e},E.prototype.unpipe=function(e){var t=this._readableState,n={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,n)),this;if(!e){var r=t.pipes,s=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var o=0;o<s;o++)r[o].emit("unpipe",this,{hasUnpiped:!1});return this}var a=L(t.pipes,e);return-1===a||(t.pipes.splice(a,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,n)),this},E.prototype.on=function(e,t){var r=o.prototype.on.call(this,e,t),s=this._readableState;return"data"===e?(s.readableListening=this.listenerCount("readable")>0,!1!==s.flowing&&this.resume()):"readable"===e&&(s.endEmitted||s.readableListening||(s.readableListening=s.needReadable=!0,s.flowing=!1,s.emittedReadable=!1,c("on readable",s.length,s.reading),s.length?P(this):s.reading||n.nextTick(R,this))),r},E.prototype.addListener=E.prototype.on,E.prototype.removeListener=function(e,t){var r=o.prototype.removeListener.call(this,e,t);return"readable"===e&&n.nextTick(S,this),r},E.prototype.removeAllListeners=function(e){var t=o.prototype.removeAllListeners.apply(this,arguments);return"readable"!==e&&e!==undefined||n.nextTick(S,this),t},E.prototype.resume=function(){var e=this._readableState;return e.flowing||(c("resume"),e.flowing=!e.readableListening,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,n.nextTick(O,e,t))}(this,e)),e.paused=!1,this},E.prototype.pause=function(){return c("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(c("pause"),this._readableState.flowing=!1,this.emit("pause")),this._readableState.paused=!0,this},E.prototype.wrap=function(e){var t=this,n=this._readableState,r=!1;for(var s in e.on("end",function(){if(c("wrapped end"),n.decoder&&!n.ended){var e=n.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(s){(c("wrapped data"),n.decoder&&(s=n.decoder.write(s)),!n.objectMode||null!==s&&s!==undefined)&&((n.objectMode||s&&s.length)&&(t.push(s)||(r=!0,e.pause())))}),e)this[s]===undefined&&"function"==typeof e[s]&&(this[s]=function(t){return function(){return e[t].apply(e,arguments)}}(s));for(var o=0;o<_.length;o++)e.on(_[o],this.emit.bind(this,_[o]));return this._read=function(t){c("wrapped _read",t),r&&(r=!1,e.resume())},this},"function"==typeof Symbol&&(E.prototype[Symbol.asyncIterator]=function(){return u===undefined&&(u=e("./internal/streams/async_iterator")),u(this)}),Object.defineProperty(E.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),Object.defineProperty(E.prototype,"readableBuffer",{enumerable:!1,get:function(){return this._readableState&&this._readableState.buffer}}),Object.defineProperty(E.prototype,"readableFlowing",{enumerable:!1,get:function(){return this._readableState.flowing},set:function(e){this._readableState&&(this._readableState.flowing=e)}}),E._fromList=M,Object.defineProperty(E.prototype,"readableLength",{enumerable:!1,get:function(){return this._readableState.length}}),"function"==typeof Symbol&&(E.from=function(t,n){return l===undefined&&(l=e("./internal/streams/from")),l(E,t,n)})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_readable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_transform.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js","./_stream_duplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_duplex.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=d;var r=e("../errors").codes,s=r.ERR_METHOD_NOT_IMPLEMENTED,o=r.ERR_MULTIPLE_CALLBACK,a=r.ERR_TRANSFORM_ALREADY_TRANSFORMING,i=r.ERR_TRANSFORM_WITH_LENGTH_0,c=e("./_stream_duplex");function m(e,t){var n=this._transformState;n.transforming=!1;var r=n.writecb;if(null===r)return this.emit("error",new o);n.writechunk=null,n.writecb=null,null!=t&&this.push(t),r(e);var s=this._readableState;s.reading=!1,(s.needReadable||s.length<s.highWaterMark)&&this._read(s.highWaterMark)}function d(e){if(!(this instanceof d))return new d(e);c.call(this,e),this._transformState={afterTransform:m.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",u)}function u(){var e=this;"function"!=typeof this._flush||this._readableState.destroyed?l(this,null,null):this._flush(function(t,n){l(e,t,n)})}function l(e,t,n){if(t)return e.emit("error",t);if(null!=n&&e.push(n),e._writableState.length)throw new i;if(e._transformState.transforming)throw new a;return e.push(null)}e("inherits")(d,c),d.prototype.push=function(e,t){return this._transformState.needTransform=!1,c.prototype.push.call(this,e,t)},d.prototype._transform=function(e,t,n){n(new s("_transform()"))},d.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var s=this._readableState;(r.needTransform||s.needReadable||s.length<s.highWaterMark)&&this._read(s.highWaterMark)}},d.prototype._read=function(e){var t=this._transformState;null===t.writechunk||t.transforming?t.needTransform=!0:(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform))},d.prototype._destroy=function(e,t){c.prototype._destroy.call(this,e,function(e){t(e)})}}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_transform.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_writable.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js","./_stream_duplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_duplex.js","./internal/streams/destroy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/destroy.js","./internal/streams/state":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/state.js","./internal/streams/stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js","util-deprecate":"/home/runner/work/metamask-extension/metamask-extension/node_modules/util-deprecate/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){function r(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t,n){var r=e.entry;e.entry=null;for(;r;){var s=r.callback;t.pendingcb--,s(n),r=r.next}t.corkedRequestsFree.next=e}(t,e)}}var s;t.exports=E,E.WritableState=v;var o={deprecate:e("util-deprecate")},a=e("./internal/streams/stream"),i=e("buffer").Buffer,c=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var m,d=e("./internal/streams/destroy"),u=e("./internal/streams/state").getHighWaterMark,l=e("../errors").codes,h=l.ERR_INVALID_ARG_TYPE,f=l.ERR_METHOD_NOT_IMPLEMENTED,p=l.ERR_MULTIPLE_CALLBACK,g=l.ERR_STREAM_CANNOT_PIPE,y=l.ERR_STREAM_DESTROYED,k=l.ERR_STREAM_NULL_VALUES,b=l.ERR_STREAM_WRITE_AFTER_END,x=l.ERR_UNKNOWN_ENCODING,w=d.errorOrDestroy;function _(){}function v(t,o,a){s=s||e("./_stream_duplex"),t=t||{},"boolean"!=typeof a&&(a=o instanceof s),this.objectMode=!!t.objectMode,a&&(this.objectMode=this.objectMode||!!t.writableObjectMode),this.highWaterMark=u(this,t,"writableHighWaterMark",a),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var i=!1===t.decodeStrings;this.decodeStrings=!i,this.defaultEncoding=t.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var r=e._writableState,s=r.sync,o=r.writecb;if("function"!=typeof o)throw new p;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(r),t)!function(e,t,r,s,o){--t.pendingcb,r?(n.nextTick(o,s),n.nextTick(B,e,t),e._writableState.errorEmitted=!0,w(e,s)):(o(s),e._writableState.errorEmitted=!0,w(e,s),B(e,t))}(e,r,s,t,o);else{var a=C(r)||e.destroyed;a||r.corked||r.bufferProcessing||!r.bufferedRequest||A(e,r),s?n.nextTick(T,e,r,a,o):T(e,r,a,o)}}(o,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.bufferedRequestCount=0,this.corkedRequestsFree=new r(this)}function E(t){var n=this instanceof(s=s||e("./_stream_duplex"));if(!n&&!m.call(E,this))return new E(t);this._writableState=new v(t,this,n),this.writable=!0,t&&("function"==typeof t.write&&(this._write=t.write),"function"==typeof t.writev&&(this._writev=t.writev),"function"==typeof t.destroy&&(this._destroy=t.destroy),"function"==typeof t.final&&(this._final=t.final)),a.call(this)}function j(e,t,n,r,s,o,a){t.writelen=r,t.writecb=a,t.writing=!0,t.sync=!0,t.destroyed?t.onwrite(new y("write")):n?e._writev(s,t.onwrite):e._write(s,o,t.onwrite),t.sync=!1}function T(e,t,n,r){n||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,r(),B(e,t)}function A(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var s=t.bufferedRequestCount,o=new Array(s),a=t.corkedRequestsFree;a.entry=n;for(var i=0,c=!0;n;)o[i]=n,n.isBuf||(c=!1),n=n.next,i+=1;o.allBuffers=c,j(e,t,!0,t.length,o,"",a.finish),t.pendingcb++,t.lastBufferedRequest=null,a.next?(t.corkedRequestsFree=a.next,a.next=null):t.corkedRequestsFree=new r(t),t.bufferedRequestCount=0}else{for(;n;){var m=n.chunk,d=n.encoding,u=n.callback;if(j(e,t,!1,t.objectMode?1:m.length,m,d,u),n=n.next,t.bufferedRequestCount--,t.writing)break}null===n&&(t.lastBufferedRequest=null)}t.bufferedRequest=n,t.bufferProcessing=!1}function C(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function P(e,t){e._final(function(n){t.pendingcb--,n&&w(e,n),t.prefinished=!0,e.emit("prefinish"),B(e,t)})}function B(e,t){var r=C(t);if(r&&(function(e,t){t.prefinished||t.finalCalled||("function"!=typeof e._final||t.destroyed?(t.prefinished=!0,e.emit("prefinish")):(t.pendingcb++,t.finalCalled=!0,n.nextTick(P,e,t)))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"),t.autoDestroy))){var s=e._readableState;(!s||s.autoDestroy&&s.endEmitted)&&e.destroy()}return r}e("inherits")(E,a),v.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(v.prototype,"buffer",{get:o.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(m=Function.prototype[Symbol.hasInstance],Object.defineProperty(E,Symbol.hasInstance,{value:function(e){return!!m.call(this,e)||this===E&&(e&&e._writableState instanceof v)}})):m=function(e){return e instanceof this},E.prototype.pipe=function(){w(this,new g)},E.prototype.write=function(e,t,r){var s,o=this._writableState,a=!1,m=!o.objectMode&&(s=e,i.isBuffer(s)||s instanceof c);return m&&!i.isBuffer(e)&&(e=function(e){return i.from(e)}(e)),"function"==typeof t&&(r=t,t=null),m?t="buffer":t||(t=o.defaultEncoding),"function"!=typeof r&&(r=_),o.ending?function(e,t){var r=new b;w(e,r),n.nextTick(t,r)}(this,r):(m||function(e,t,r,s){var o;return null===r?o=new k:"string"==typeof r||t.objectMode||(o=new h("chunk",["string","Buffer"],r)),!o||(w(e,o),n.nextTick(s,o),!1)}(this,o,e,r))&&(o.pendingcb++,a=function(e,t,n,r,s,o){if(!n){var a=function(e,t,n){e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=i.from(t,n));return t}(t,r,s);r!==a&&(n=!0,s="buffer",r=a)}var c=t.objectMode?1:r.length;t.length+=c;var m=t.length<t.highWaterMark;m||(t.needDrain=!0);if(t.writing||t.corked){var d=t.lastBufferedRequest;t.lastBufferedRequest={chunk:r,encoding:s,isBuf:n,callback:o,next:null},d?d.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else j(e,t,!1,c,r,s,o);return m}(this,o,m,e,t,r)),a},E.prototype.cork=function(){this._writableState.corked++},E.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||A(this,e))},E.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new x(e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(E.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(E.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),E.prototype._write=function(e,t,n){n(new f("_write()"))},E.prototype._writev=null,E.prototype.end=function(e,t,r){var s=this._writableState;return"function"==typeof e?(r=e,e=null,t=null):"function"==typeof t&&(r=t,t=null),null!==e&&e!==undefined&&this.write(e,t),s.corked&&(s.corked=1,this.uncork()),s.ending||function(e,t,r){t.ending=!0,B(e,t),r&&(t.finished?n.nextTick(r):e.once("finish",r));t.ended=!0,e.writable=!1}(this,s,r),this},Object.defineProperty(E.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(E.prototype,"destroyed",{enumerable:!1,get:function(){return this._writableState!==undefined&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),E.prototype.destroy=d.destroy,E.prototype._undestroy=d.undestroy,E.prototype._destroy=function(e,t){t(e)}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_writable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/async_iterator.js",{"./end-of-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r;function s(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var n=e[Symbol.toPrimitive];if(n!==undefined){var r=n.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var o=e("./end-of-stream"),a=Symbol("lastResolve"),i=Symbol("lastReject"),c=Symbol("error"),m=Symbol("ended"),d=Symbol("lastPromise"),u=Symbol("handlePromise"),l=Symbol("stream");function h(e,t){return{value:e,done:t}}function f(e){var t=e[a];if(null!==t){var n=e[l].read();null!==n&&(e[d]=null,e[a]=null,e[i]=null,t(h(n,!1)))}}function p(e){n.nextTick(f,e)}var g=Object.getPrototypeOf(function(){}),y=Object.setPrototypeOf((s(r={get stream(){return this[l]},next:function(){var e=this,t=this[c];if(null!==t)return Promise.reject(t);if(this[m])return Promise.resolve(h(undefined,!0));if(this[l].destroyed)return new Promise(function(t,r){n.nextTick(function(){e[c]?r(e[c]):t(h(undefined,!0))})});var r,s=this[d];if(s)r=new Promise(function(e,t){return function(n,r){e.then(function(){t[m]?n(h(undefined,!0)):t[u](n,r)},r)}}(s,this));else{var o=this[l].read();if(null!==o)return Promise.resolve(h(o,!1));r=new Promise(this[u])}return this[d]=r,r}},Symbol.asyncIterator,function(){return this}),s(r,"return",function(){var e=this;return new Promise(function(t,n){e[l].destroy(null,function(e){e?n(e):t(h(undefined,!0))})})}),r),g);t.exports=function(e){var t,n=Object.create(y,(s(t={},l,{value:e,writable:!0}),s(t,a,{value:null,writable:!0}),s(t,i,{value:null,writable:!0}),s(t,c,{value:null,writable:!0}),s(t,m,{value:e._readableState.endEmitted,writable:!0}),s(t,u,{value:function(e,t){var r=n[l].read();r?(n[d]=null,n[a]=null,n[i]=null,e(h(r,!1))):(n[a]=e,n[i]=t)},writable:!0}),t));return n[d]=null,o(e,function(e){if(e&&"ERR_STREAM_PREMATURE_CLOSE"!==e.code){var t=n[i];return null!==t&&(n[d]=null,n[a]=null,n[i]=null,t(e)),void(n[c]=e)}var r=n[a];null!==r&&(n[d]=null,n[a]=null,n[i]=null,r(h(undefined,!0))),n[m]=!0}),e.on("readable",p.bind(null,n)),n}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/async_iterator.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/buffer_list.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",util:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function s(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?r(Object(n),!0).forEach(function(t){o(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):r(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function o(e,t,n){return(t=i(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function a(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,i(r.key),r)}}function i(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var n=e[Symbol.toPrimitive];if(n!==undefined){var r=n.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}var c=e("buffer").Buffer,m=e("util").inspect,d=m&&m.custom||"inspect";function u(e,t,n){c.prototype.copy.call(e,t,n)}t.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}var t,n,r;return t=e,(n=[{key:"push",value:function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length}},{key:"unshift",value:function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length}},{key:"shift",value:function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}}},{key:"clear",value:function(){this.head=this.tail=null,this.length=0}},{key:"join",value:function(e){if(0===this.length)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n}},{key:"concat",value:function(e){if(0===this.length)return c.alloc(0);for(var t=c.allocUnsafe(e>>>0),n=this.head,r=0;n;)u(n.data,t,r),r+=n.data.length,n=n.next;return t}},{key:"consume",value:function(e,t){var n;return e<this.head.data.length?(n=this.head.data.slice(0,e),this.head.data=this.head.data.slice(e)):n=e===this.head.data.length?this.shift():t?this._getString(e):this._getBuffer(e),n}},{key:"first",value:function(){return this.head.data}},{key:"_getString",value:function(e){var t=this.head,n=1,r=t.data;for(e-=r.length;t=t.next;){var s=t.data,o=e>s.length?s.length:e;if(o===s.length?r+=s:r+=s.slice(0,e),0===(e-=o)){o===s.length?(++n,t.next?this.head=t.next:this.head=this.tail=null):(this.head=t,t.data=s.slice(o));break}++n}return this.length-=n,r}},{key:"_getBuffer",value:function(e){var t=c.allocUnsafe(e),n=this.head,r=1;for(n.data.copy(t),e-=n.data.length;n=n.next;){var s=n.data,o=e>s.length?s.length:e;if(s.copy(t,t.length-e,0,o),0===(e-=o)){o===s.length?(++r,n.next?this.head=n.next:this.head=this.tail=null):(this.head=n,n.data=s.slice(o));break}++r}return this.length-=r,t}},{key:d,value:function(e,t){return m(this,s(s({},t),{},{depth:0,customInspect:!1}))}}])&&a(t.prototype,n),r&&a(t,r),Object.defineProperty(t,"prototype",{writable:!1}),e}()}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/buffer_list.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/destroy.js",{_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function n(e,t){s(e,t),r(e)}function r(e){e._writableState&&!e._writableState.emitClose||e._readableState&&!e._readableState.emitClose||e.emit("close")}function s(e,t){e.emit("error",t)}t.exports={destroy:function(t,o){var a=this,i=this._readableState&&this._readableState.destroyed,c=this._writableState&&this._writableState.destroyed;return i||c?(o?o(t):t&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,e.nextTick(s,this,t)):e.nextTick(s,this,t)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(t||null,function(t){!o&&t?a._writableState?a._writableState.errorEmitted?e.nextTick(r,a):(a._writableState.errorEmitted=!0,e.nextTick(n,a,t)):e.nextTick(n,a,t):o?(e.nextTick(r,a),o(t)):e.nextTick(r,a)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)},errorOrDestroy:function(e,t){var n=e._readableState,r=e._writableState;n&&n.autoDestroy||r&&r.autoDestroy?e.destroy(t):e.emit("error",t)}}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/destroy.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js",{"../../../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("../../../errors").codes.ERR_STREAM_PREMATURE_CLOSE;function s(){}t.exports=function e(t,n,o){if("function"==typeof n)return e(t,null,n);n||(n={}),o=function(e){var t=!1;return function(){if(!t){t=!0;for(var n=arguments.length,r=new Array(n),s=0;s<n;s++)r[s]=arguments[s];e.apply(this,r)}}}(o||s);var a=n.readable||!1!==n.readable&&t.readable,i=n.writable||!1!==n.writable&&t.writable,c=function(){t.writable||d()},m=t._writableState&&t._writableState.finished,d=function(){i=!1,m=!0,a||o.call(t)},u=t._readableState&&t._readableState.endEmitted,l=function(){a=!1,u=!0,i||o.call(t)},h=function(e){o.call(t,e)},f=function(){var e;return a&&!u?(t._readableState&&t._readableState.ended||(e=new r),o.call(t,e)):i&&!m?(t._writableState&&t._writableState.ended||(e=new r),o.call(t,e)):void 0},p=function(){t.req.on("finish",d)};return!function(e){return e.setHeader&&"function"==typeof e.abort}(t)?i&&!t._writableState&&(t.on("end",c),t.on("close",c)):(t.on("complete",d),t.on("abort",f),t.req?p():t.on("request",p)),t.on("end",l),t.on("finish",d),!1!==n.error&&t.on("error",h),t.on("close",f),function(){t.removeListener("complete",d),t.removeListener("abort",f),t.removeListener("request",p),t.req&&t.req.removeListener("finish",d),t.removeListener("end",c),t.removeListener("close",c),t.removeListener("finish",d),t.removeListener("end",l),t.removeListener("error",h),t.removeListener("close",f)}}}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/from-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(){throw new Error("Readable.from is not available in the browser")}}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/from-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/pipeline.js",{"../../../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js","./end-of-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;var s=e("../../../errors").codes,o=s.ERR_MISSING_ARGS,a=s.ERR_STREAM_DESTROYED;function i(e){if(e)throw e}function c(e){e()}function m(e,t){return e.pipe(t)}t.exports=function(){for(var t=arguments.length,n=new Array(t),s=0;s<t;s++)n[s]=arguments[s];var d,u=function(e){return e.length?"function"!=typeof e[e.length-1]?i:e.pop():i}(n);if(Array.isArray(n[0])&&(n=n[0]),n.length<2)throw new o("streams");var l=n.map(function(t,s){var o=s<n.length-1;return function(t,n,s,o){o=function(e){var t=!1;return function(){t||(t=!0,e.apply(void 0,arguments))}}(o);var i=!1;t.on("close",function(){i=!0}),r===undefined&&(r=e("./end-of-stream")),r(t,{readable:n,writable:s},function(e){if(e)return o(e);i=!0,o()});var c=!1;return function(e){if(!i&&!c)return c=!0,function(e){return e.setHeader&&"function"==typeof e.abort}(t)?t.abort():"function"==typeof t.destroy?t.destroy():void o(e||new a("pipe"))}}(t,o,s>0,function(e){d||(d=e),e&&l.forEach(c),o||(l.forEach(c),u(d))})});return n.reduce(m)}}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/pipeline.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/state.js",{"../../../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/errors-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("../../../errors").codes.ERR_INVALID_OPT_VALUE;t.exports={getHighWaterMark:function(e,t,n,s){var o=function(e,t,n){return null!=e.highWaterMark?e.highWaterMark:t?e[n]:null}(t,s,n);if(null!=o){if(!isFinite(o)||Math.floor(o)!==o||o<0)throw new r(s?n:"highWaterMark",o);return Math.floor(o)}return e.objectMode?16:16384}}}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/state.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("events").EventEmitter}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/readable-browser.js",{"./lib/_stream_duplex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_duplex.js","./lib/_stream_passthrough.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_passthrough.js","./lib/_stream_readable.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_readable.js","./lib/_stream_transform.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_transform.js","./lib/_stream_writable.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/_stream_writable.js","./lib/internal/streams/end-of-stream.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js","./lib/internal/streams/pipeline.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/lib/internal/streams/pipeline.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(n=t.exports=e("./lib/_stream_readable.js")).Stream=n,n.Readable=n,n.Writable=e("./lib/_stream_writable.js"),n.Duplex=e("./lib/_stream_duplex.js"),n.Transform=e("./lib/_stream_transform.js"),n.PassThrough=e("./lib/_stream_passthrough.js"),n.finished=e("./lib/internal/streams/end-of-stream.js"),n.pipeline=e("./lib/internal/streams/pipeline.js")}}},{package:"@metamask/json-rpc-middleware-stream>readable-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/node_modules/readable-stream/readable-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs",{"./BIP44Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs","./SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.getBIP44AddressKeyDeriver=n.deriveBIP44AddressKey=n.BIP44CoinTypeNode=n.BIP_44_COIN_TYPE_DEPTH=void 0;const a=e("./BIP44Node.cjs"),i=e("./constants.cjs"),c=e("./SLIP10Node.cjs"),m=e("./utils.cjs");n.BIP_44_COIN_TYPE_DEPTH=2;class d{static async fromJSON(e,t,n){l(t),u(e.depth);const r=await a.BIP44Node.fromExtendedKey({depth:e.depth,index:e.index,network:e.network,parentFingerprint:e.parentFingerprint,chainCode:(0,m.hexStringToBytes)(e.chainCode),privateKey:(0,m.nullableHexStringToBytes)(e.privateKey),publicKey:(0,m.hexStringToBytes)(e.publicKey)},n);return new d(r,t)}static async fromDerivationPath(e,t,n){u(e.length-1);const r=await a.BIP44Node.fromDerivationPath({derivationPath:e,network:t},n),s=(0,m.getBIP44CoinType)(e);return new d(r,s)}static async fromSeed({derivationPath:e,network:t},n){u(e.length-1);const r=await a.BIP44Node.fromSeed({derivationPath:e,network:t},n),s=(0,m.getBIP44CoinType)(e);return new d(r,s)}static async fromNode(e,t){if(!(e instanceof a.BIP44Node))throw new Error("Invalid node: Expected an instance of BIP44Node.");return l(t),u(e.depth),Promise.resolve(new d(e,t))}constructor(e,t){r.set(this,void 0),s(this,r,e,"f"),this.coin_type=t,this.path=(0,m.getBIP44CoinTypePathString)(t),Object.freeze(this)}get depth(){return o(this,r,"f").depth}get privateKeyBytes(){return o(this,r,"f").privateKeyBytes}get publicKeyBytes(){return o(this,r,"f").publicKeyBytes}get chainCodeBytes(){return o(this,r,"f").chainCodeBytes}get privateKey(){return o(this,r,"f").privateKey}get publicKey(){return o(this,r,"f").publicKey}get compressedPublicKey(){return o(this,r,"f").compressedPublicKey}get compressedPublicKeyBytes(){return o(this,r,"f").compressedPublicKeyBytes}get chainCode(){return o(this,r,"f").chainCode}get address(){return o(this,r,"f").address}get masterFingerprint(){return o(this,r,"f").masterFingerprint}get parentFingerprint(){return o(this,r,"f").parentFingerprint}get fingerprint(){return o(this,r,"f").fingerprint}get index(){return o(this,r,"f").index}get network(){return o(this,r,"f").network}get curve(){return o(this,r,"f").curve}get extendedKey(){return o(this,r,"f").extendedKey}async deriveBIP44AddressKey({account:e=0,change:t=0,address_index:n}){return await o(this,r,"f").derive((0,m.getBIP44CoinTypeToAddressPathTuple)({account:e,change:t,address_index:n}))}toJSON(){return{...o(this,r,"f").toJSON(),coin_type:this.coin_type,path:this.path}}}function u(e){if(e!==n.BIP_44_COIN_TYPE_DEPTH)throw new Error(`Invalid depth: Coin type nodes must be of depth ${n.BIP_44_COIN_TYPE_DEPTH}. Received: "${e}"`)}function l(e){if("number"!=typeof e||!Number.isInteger(e)||e<0)throw new Error("Invalid coin type: The specified coin type must be a non-negative integer number.")}async function h(e,t){if(e instanceof d)return u(e.depth),e;if("string"==typeof e){const n=await a.BIP44Node.fromExtendedKey(e,t),r=await d.fromNode(n,n.index-i.BIP_32_HARDENED_OFFSET);return u(r.depth),r}return d.fromJSON(e,e.coin_type,t)}n.BIP44CoinTypeNode=d,r=new WeakMap,n.deriveBIP44AddressKey=async function(e,{account:t=0,change:n=0,address_index:r},s){const o=(0,m.getBIP44CoinTypeToAddressPathTuple)({account:t,change:n,address_index:r}),i=await h(e,s),d=await(0,c.deriveChildNode)({path:o,node:i},s);return new a.BIP44Node(d)},n.getBIP44AddressKeyDeriver=async function(e,t,n){const{account:r=0,change:s=0}=t??{},o=await h(e,n),i=(0,m.getHardenedBIP32NodeToken)(r),d=(0,m.getBIP32NodeToken)(s),u=async(e,t=!1)=>{const r=await(0,c.deriveChildNode)({path:[i,d,t?(0,m.getHardenedBIP32NodeToken)(e):(0,m.getUnhardenedBIP32NodeToken)(e)],node:o},n);return new a.BIP44Node(r)};return u.coin_type=o.coin_type,u.path=(0,m.getBIP44ChangePathString)(o.path,{account:r,change:s}),Object.freeze(u),u}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs",{"./SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./extended-keys.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/extended-keys.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},o=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.validateBIP44Depth=n.BIP44Node=void 0;const a=e("@metamask/utils"),i=e("./constants.cjs"),c=e("./extended-keys.cjs"),m=e("./SLIP10Node.cjs"),d=e("./utils.cjs");class u{static async fromJSON(e,t){return u.fromExtendedKey(e,t)}static async fromExtendedKey(e,t){if("string"==typeof e){const n=(0,c.decodeExtendedKey)(e),{type:r,chainCode:s,depth:o,parentFingerprint:a,index:i,network:m}=n;if("private"===r){const{privateKey:e}=n;return u.fromExtendedKey({depth:o,parentFingerprint:a,index:i,network:m,privateKey:e,chainCode:s},t)}const{publicKey:d}=n;return u.fromExtendedKey({depth:o,parentFingerprint:a,index:i,network:m,publicKey:d,chainCode:s},t)}const{privateKey:n,publicKey:r,chainCode:s,depth:o,parentFingerprint:a,index:i,network:d}=e;l(o);const h=await m.SLIP10Node.fromExtendedKey({privateKey:n,publicKey:r,chainCode:s,depth:o,parentFingerprint:a,index:i,network:d,curve:"secp256k1"},t);return new u(h)}static async fromDerivationPath({derivationPath:e,network:t},n){l(e.length-1),h(e,i.MIN_BIP_44_DEPTH);const r=await m.SLIP10Node.fromDerivationPath({derivationPath:e,network:t,curve:"secp256k1"},n);return new u(r)}static async fromSeed({derivationPath:e,network:t},n){l(e.length-1),h(e,i.MIN_BIP_44_DEPTH);const r=await m.SLIP10Node.fromSeed({derivationPath:e,network:t,curve:"secp256k1"},n);return new u(r)}get depth(){return s(this,r,"f").depth}get privateKeyBytes(){return s(this,r,"f").privateKeyBytes}get publicKeyBytes(){return s(this,r,"f").publicKeyBytes}get chainCodeBytes(){return s(this,r,"f").chainCodeBytes}get privateKey(){return s(this,r,"f").privateKey}get publicKey(){return s(this,r,"f").publicKey}get compressedPublicKey(){return s(this,r,"f").compressedPublicKey}get compressedPublicKeyBytes(){return s(this,r,"f").compressedPublicKeyBytes}get chainCode(){return s(this,r,"f").chainCode}get address(){return s(this,r,"f").address}get masterFingerprint(){return s(this,r,"f").masterFingerprint}get parentFingerprint(){return s(this,r,"f").parentFingerprint}get fingerprint(){return s(this,r,"f").fingerprint}get index(){return s(this,r,"f").index}get network(){return s(this,r,"f").network}get extendedKey(){return s(this,r,"f").extendedKey}get curve(){return s(this,r,"f").curve}constructor(e){r.set(this,void 0),o(this,r,e,"f"),Object.freeze(this)}neuter(){const e=s(this,r,"f").neuter();return new u(e)}async derive(e){if(this.depth===i.MAX_BIP_44_DEPTH)throw new Error("Illegal operation: This HD tree node is already a leaf node.");l(this.depth+e.length),h(e,this.depth+1);const t=await s(this,r,"f").derive(e);return new u(t)}toJSON(){return{depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,privateKey:this.privateKey,publicKey:this.publicKey,chainCode:this.chainCode}}}function l(e){if((0,m.validateBIP32Depth)(e),e<i.MIN_BIP_44_DEPTH||e>i.MAX_BIP_44_DEPTH)throw new Error(`Invalid HD tree path depth: The depth must be a positive integer N such that 0 <= N <= 5. Received: "${e}"`)}function h(e,t){e.forEach((e,n)=>{const r=t+n;if(r!==i.MIN_BIP_44_DEPTH)switch((0,a.assert)("string"==typeof e),r){case 1:if(e!==i.BIP44PurposeNodeToken)throw new Error(`Invalid derivation path: The "purpose" node (depth 1) must be the string "${i.BIP44PurposeNodeToken}".`);break;case 2:if(!i.BIP_32_PATH_REGEX.test(e)||!(0,d.isHardened)(e))throw new Error('Invalid derivation path: The "coin_type" node (depth 2) must be a hardened BIP-32 node.');break;case 3:if(!i.BIP_32_PATH_REGEX.test(e)||!(0,d.isHardened)(e))throw new Error('Invalid derivation path: The "account" node (depth 3) must be a hardened BIP-32 node.');break;case 4:if(!i.BIP_32_PATH_REGEX.test(e))throw new Error('Invalid derivation path: The "change" node (depth 4) must be a BIP-32 node.');break;case i.MAX_BIP_44_DEPTH:if(!i.BIP_32_PATH_REGEX.test(e))throw new Error('Invalid derivation path: The "address_index" node (depth 5) must be a BIP-32 node.')}else if(!(e instanceof Uint8Array||i.BIP_39_PATH_REGEX.test(e)))throw new Error('Invalid derivation path: The "m" / seed node (depth 0) must be a BIP-39 node.')})}n.BIP44Node=u,r=new WeakMap,n.validateBIP44Depth=l}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/BIP44Node.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","./derivation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivation.cjs","./derivers/bip32.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip32.cjs","./derivers/bip39.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip39.cjs","./extended-keys.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/extended-keys.cjs","./guard.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/guard.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,a,i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},c=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildNode=n.validateRootIndex=n.validateMasterParentFingerprint=n.validateParentFingerprint=n.validateBIP32Depth=n.SLIP10Node=void 0;const m=e("@metamask/utils"),d=e("./constants.cjs"),u=e("./curves/index.cjs"),l=e("./derivation.cjs"),h=e("./derivers/bip32.cjs"),f=e("./derivers/bip39.cjs"),p=e("./extended-keys.cjs"),g=e("./guard.cjs"),y=e("./utils.cjs");class k{static async fromJSON(e,t){return r.fromExtendedKey(e,t)}static async fromExtendedKey(e,t){if("string"==typeof e){const n=(0,p.decodeExtendedKey)(e),{chainCode:s,depth:o,parentFingerprint:a,index:i}=n;if("private"===n.type){const{privateKey:e}=n;return r.fromExtendedKey({depth:o,parentFingerprint:a,index:i,privateKey:e,chainCode:s,curve:"secp256k1"},t)}const{publicKey:c}=n;return r.fromExtendedKey({depth:o,parentFingerprint:a,index:i,publicKey:c,chainCode:s,curve:"secp256k1"},t)}const{depth:n,masterFingerprint:o,parentFingerprint:a,index:c,network:l,privateKey:h,publicKey:f,chainCode:k,curve:v,guard:E}=e,j=(0,y.getBytes)(k,d.BYTES_KEY_LENGTH);(0,y.validateCurve)(v),b(n),(0,y.validateBIP32Index)(c),_(c,n),(0,y.validateNetwork)(l),x(a,n),w(o,a,n);const T=(0,u.getCurveByName)(v);if(h){const e=(0,y.getBytesUnsafe)(h,T.privateKeyLength);(0,m.assert)(T.isValidPrivateKey(e),`Invalid private key: Value is not a valid ${v} private key.`);const d=E===g.PUBLIC_KEY_GUARD&&f?(0,y.getBytes)(f,T.publicKeyLength):undefined;return new r({depth:n,masterFingerprint:o,parentFingerprint:a,index:c,network:l,chainCode:j,privateKey:e,publicKey:d,curve:v},t,i(this,r,"f",s))}if(f){const e=(0,y.getBytes)(f,T.publicKeyLength);return new r({depth:n,masterFingerprint:o,parentFingerprint:a,index:c,network:l,chainCode:j,publicKey:e,curve:v},t,i(this,r,"f",s))}throw new Error("Invalid options: Must provide either a private key or a public key.")}static async fromDerivationPath({derivationPath:e,network:t,curve:n},r){if((0,y.validateCurve)(n),!e)throw new Error("Invalid options: Must provide a derivation path.");if(0===e.length)throw new Error("Invalid derivation path: May not specify an empty derivation path.");const s=await(0,f.getDerivationPathWithSeed)({path:e,curve:n},r);return await(0,l.deriveKeyFromPath)({path:s,depth:e.length-1,network:t,curve:n},r)}static async fromSeed({derivationPath:e,network:t,curve:n},r){if((0,y.validateCurve)(n),"ed25519Bip32"===n)throw new Error('Invalid curve: The curve "ed25519Bip32" is not supported by the `fromSeed` function.');if(!e)throw new Error("Invalid options: Must provide a derivation path.");if(0===e.length)throw new Error("Invalid derivation path: May not specify an empty derivation path.");return await(0,l.deriveKeyFromPath)({path:e,depth:e.length-1,network:t,curve:n},r)}constructor({depth:e,masterFingerprint:t,parentFingerprint:n,index:d,network:u="mainnet",chainCode:l,privateKey:h,publicKey:f,curve:p},g={},y){o.set(this,void 0),a.set(this,void 0),(0,m.assert)(y===i(r,r,"f",s),"SLIP10Node can only be constructed using `SLIP10Node.fromJSON`, `SLIP10Node.fromExtendedKey`, `SLIP10Node.fromDerivationPath`, or `SLIP10Node.fromSeed`."),(0,m.assert)(h!==undefined||f!==undefined,"SLIP10Node requires either a private key or a public key to be set."),this.depth=e,this.masterFingerprint=t,this.parentFingerprint=n,this.index=d,this.network=u,this.chainCodeBytes=l,this.privateKeyBytes=h,this.curve=p,c(this,o,f,"f"),c(this,a,g,"f"),Object.freeze(this)}get chainCode(){return(0,m.bytesToHex)(this.chainCodeBytes)}get privateKey(){return this.privateKeyBytes?(0,m.bytesToHex)(this.privateKeyBytes):undefined}get publicKey(){return(0,m.bytesToHex)(this.publicKeyBytes)}get publicKeyBytes(){return i(this,o,"f")!==undefined||((0,m.assert)(this.privateKeyBytes,"Either a private key or public key is required."),c(this,o,(0,u.getCurveByName)(this.curve).getPublicKey(this.privateKeyBytes),"f")),i(this,o,"f")}get compressedPublicKeyBytes(){return(0,u.getCurveByName)(this.curve).compressPublicKey(this.publicKeyBytes)}get compressedPublicKey(){return(0,m.bytesToHex)(this.compressedPublicKeyBytes)}get address(){if("secp256k1"!==this.curve)throw new Error("Unable to get address for this node: Only secp256k1 is supported.");return(0,m.bytesToHex)((0,h.publicKeyToEthAddress)(this.publicKeyBytes))}get fingerprint(){return(0,y.getFingerprint)(this.compressedPublicKeyBytes,(0,u.getCurveByName)(this.curve).compressedPublicKeyLength)}get extendedKey(){(0,m.assert)("secp256k1"===this.curve,"Unable to get extended key for this node: Only secp256k1 is supported.");const e={depth:this.depth,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,chainCode:this.chainCodeBytes};return this.privateKeyBytes?(0,p.encodeExtendedKey)({...e,type:"private",privateKey:this.privateKeyBytes}):(0,p.encodeExtendedKey)({...e,type:"public",publicKey:this.publicKeyBytes})}neuter(){return new r({depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,chainCode:this.chainCodeBytes,publicKey:this.publicKeyBytes,curve:this.curve,network:this.network},i(this,a,"f"),i(r,r,"f",s))}async derive(e){return await v({path:e,node:this},i(this,a,"f"))}toJSON(){return{depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,curve:this.curve,privateKey:this.privateKey,publicKey:this.publicKey,chainCode:this.chainCode}}}function b(e){if(!(0,y.isValidInteger)(e))throw new Error(`Invalid HD tree path depth: The depth must be a positive integer. Received: "${String(e)}".`)}function x(e,t){if(!(0,y.isValidInteger)(e))throw new Error(`Invalid parent fingerprint: The fingerprint must be a positive integer. Received: "${String(e)}".`);if(0===t&&0!==e)throw new Error(`Invalid parent fingerprint: The fingerprint of the root node must be 0. Received: "${String(e)}".`);if(t>0&&0===e)throw new Error(`Invalid parent fingerprint: The fingerprint of a child node must not be 0. Received: "${String(e)}".`)}function w(e,t,n){if(e&&n>=2&&e===t)throw new Error(`Invalid parent fingerprint: The fingerprint of a child node cannot be equal to the master fingerprint. Received: "${String(t)}".`)}function _(e,t){if(0===t&&0!==e)throw new Error(`Invalid index: The index of the root node must be 0. Received: "${String(e)}".`)}async function v({path:e,node:t},n){if(0===e.length)throw new Error("Invalid HD tree derivation path: Deriving a path of length 0 is not defined.");const r=t.depth+e.length;return b(r),await(0,l.deriveKeyFromPath)({path:e,node:t,depth:r},n)}n.SLIP10Node=k,r=k,o=new WeakMap,a=new WeakMap,s={value:Symbol("SLIP10Node.constructor")},n.validateBIP32Depth=b,n.validateParentFingerprint=x,n.validateMasterParentFingerprint=w,n.validateRootIndex=_,n.deriveChildNode=v}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/SLIP10Node.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BIP_32_HARDENED_OFFSET=n.BIP_39_PATH_REGEX=n.CIP_3_PATH_REGEX=n.SLIP_10_PATH_REGEX=n.BIP_32_PATH_REGEX=n.UNPREFIXED_BIP_32_PATH_REGEX=n.UNPREFIXED_PATH_REGEX=n.BIP44PurposeNodeToken=n.MAX_BIP_32_INDEX=n.MAX_UNHARDENED_BIP_32_INDEX=n.MAX_BIP_44_DEPTH=n.MIN_BIP_44_DEPTH=n.BYTES_KEY_LENGTH=void 0,n.BYTES_KEY_LENGTH=32,n.MIN_BIP_44_DEPTH=0,n.MAX_BIP_44_DEPTH=5,n.MAX_UNHARDENED_BIP_32_INDEX=2147483647,n.MAX_BIP_32_INDEX=4294967295,n.BIP44PurposeNodeToken="bip32:44'",n.UNPREFIXED_PATH_REGEX=/^\d+$/u,n.UNPREFIXED_BIP_32_PATH_REGEX=/^(?<index>\d+)'?$/u,n.BIP_32_PATH_REGEX=/^bip32:\d+'?$/u,n.SLIP_10_PATH_REGEX=/^slip10:\d+'?$/u,n.CIP_3_PATH_REGEX=/^cip3:\d+'?$/u,n.BIP_39_PATH_REGEX=/^bip39:([a-z]+){1}( [a-z]+){11,23}$/u,n.BIP_32_HARDENED_OFFSET=2147483648}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@noble/hashes/hmac":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/hmac.js","@noble/hashes/pbkdf2":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/pbkdf2.js","@noble/hashes/ripemd160":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/ripemd160.js","@noble/hashes/sha256":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha256.js","@noble/hashes/sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha3.js","@noble/hashes/sha512":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha512.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.sha256=n.ripemd160=n.pbkdf2Sha512=n.keccak256=n.hmacSha512=void 0;const r=e("@noble/hashes/hmac"),s=e("@noble/hashes/pbkdf2"),o=e("@noble/hashes/ripemd160"),a=e("@noble/hashes/sha256"),i=e("@noble/hashes/sha3"),c=e("@noble/hashes/sha512"),m=e("./utils.cjs");n.hmacSha512=async function(e,t,n={}){if(n.hmacSha512)return await n.hmacSha512(e,t);if((0,m.isWebCryptoSupported)()){const n=await crypto.subtle.importKey("raw",e,{name:"HMAC",hash:"SHA-512"},!1,["sign"]),r=await crypto.subtle.sign("HMAC",n,t);return new Uint8Array(r)}return(0,r.hmac)(c.sha512,e,t)},n.keccak256=function(e){return(0,i.keccak_256)(e)},n.pbkdf2Sha512=async function(e,t,n,r,o={}){if(o.pbkdf2Sha512)return await o.pbkdf2Sha512(e,t,n,r);if((0,m.isWebCryptoSupported)()){const s=await crypto.subtle.importKey("raw",e,{name:"PBKDF2"},!1,["deriveBits"]),o=await crypto.subtle.deriveBits({name:"PBKDF2",salt:t,iterations:n,hash:{name:"SHA-512"}},s,8*r);return new Uint8Array(o)}return await(0,s.pbkdf2Async)(c.sha512,e,t,{c:n,dkLen:r})},n.ripemd160=function(e){return(0,o.ripemd160)(e)},n.sha256=function(e){return(0,a.sha256)(e)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/cryptography.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/curve.cjs",{"./ed25519.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519.cjs","./ed25519Bip32.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs","./secp256k1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs","@noble/curves/abstract/modular":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/abstract/modular.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.mod=n.getCurveByName=n.curves=void 0;const a=o(e("./ed25519.cjs")),i=o(e("./ed25519Bip32.cjs")),c=o(e("./secp256k1.cjs"));n.curves={secp256k1:c,ed25519:a,ed25519Bip32:i},n.getCurveByName=function(e){return n.curves[e]};var m=e("@noble/curves/abstract/modular");Object.defineProperty(n,"mod",{enumerable:!0,get:function(){return m.mod}})}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/curve.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/ed25519":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/ed25519.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.publicKeyLength=n.deriveUnhardenedKeys=n.isValidPrivateKey=n.secret=n.name=n.curve=void 0;const r=e("@metamask/utils"),s=e("@noble/curves/ed25519");n.curve=s.ed25519.CURVE,n.name="ed25519",n.secret=(0,r.stringToBytes)("ed25519 seed");n.isValidPrivateKey=e=>!0,n.deriveUnhardenedKeys=!1,n.publicKeyLength=33;n.getPublicKey=(()=>{let e=!1;return(t,n)=>{e||(s.ed25519.ExtendedPoint.BASE._setWindowSize(4),e=!0);const o=s.ed25519.getPublicKey(t);return(0,r.concatBytes)([new Uint8Array([0]),o])}})();n.publicAdd=(e,t)=>{throw new Error("Ed25519 does not support public key derivation.")};n.compressPublicKey=e=>e;n.decompressPublicKey=e=>e,n.privateKeyLength=32,n.masterNodeGenerationSpec="slip10",n.compressedPublicKeyLength=33}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/ed25519.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/abstract/modular":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/abstract/modular.js","@noble/curves/ed25519":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/ed25519.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.multiplyWithBase=n.bytesToNumberLE=n.publicKeyLength=n.deriveUnhardenedKeys=n.isValidPrivateKey=n.secret=n.name=n.curve=void 0;const r=e("@metamask/utils"),s=e("@noble/curves/abstract/modular"),o=e("@noble/curves/ed25519");function a(e,t){const n=e[t];return(0,r.assert)(n!==undefined,"Private key is too short."),n}n.curve=o.ed25519.CURVE,n.name="ed25519Bip32",n.secret=(0,r.stringToBytes)("");n.isValidPrivateKey=e=>!(7&a(e,0))&&(!(128&a(e,31))&&!(64&~a(e,31))),n.deriveUnhardenedKeys=!0,n.publicKeyLength=32;n.bytesToNumberLE=e=>(0,r.hexToBigInt)((0,r.bytesToHex)(Uint8Array.from(e).reverse()));n.multiplyWithBase=e=>{const t=(0,s.mod)((0,n.bytesToNumberLE)(e),n.curve.n);return o.ed25519.ExtendedPoint.BASE.multiply(t).toRawBytes()};n.getPublicKey=(e,t)=>(0,n.multiplyWithBase)(e.slice(0,32));n.publicAdd=(e,t)=>o.ed25519.ExtendedPoint.fromHex((0,r.remove0x)((0,r.bytesToHex)(e))).add(o.ed25519.ExtendedPoint.fromHex((0,r.remove0x)((0,r.bytesToHex)(t)))).toRawBytes();n.compressPublicKey=e=>e;n.decompressPublicKey=e=>e,n.privateKeyLength=64,n.masterNodeGenerationSpec="cip3",n.compressedPublicKeyLength=32}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs",{"./curve.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/curve.cjs","./ed25519.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519.cjs","./ed25519Bip32.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs","./secp256k1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)},a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ed25519Bip32=n.ed25519=n.secp256k1=void 0,o(e("./curve.cjs"),n),n.secp256k1=a(e("./secp256k1.cjs")),n.ed25519=a(e("./ed25519.cjs")),n.ed25519Bip32=a(e("./ed25519Bip32.cjs"))}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs",{"../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.isValidPrivateKey=n.publicKeyLength=n.deriveUnhardenedKeys=n.secret=n.name=n.curve=void 0;const r=e("@metamask/utils"),s=e("@noble/curves/secp256k1"),o=e("../utils.cjs");n.curve=s.secp256k1.CURVE,n.name="secp256k1",n.secret=(0,r.stringToBytes)("Bitcoin seed"),n.deriveUnhardenedKeys=!0,n.publicKeyLength=65;n.isValidPrivateKey=e=>s.secp256k1.utils.isValidPrivateKey(e);n.getPublicKey=(()=>{let e=!1;return(t,n=!1)=>(e||(s.secp256k1.ProjectivePoint.BASE._setWindowSize(4),e=!0),s.secp256k1.getPublicKey(t,n))})();n.publicAdd=(e,t)=>{(0,r.assert)((0,o.isValidBytesKey)(t,32),"Invalid tweak: Tweak must be a non-zero 32-byte Uint8Array.");const n=s.secp256k1.ProjectivePoint.fromHex(e).add(s.secp256k1.ProjectivePoint.fromPrivateKey(t));return n.assertValidity(),n.toRawBytes(!1)};n.compressPublicKey=e=>s.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!0);n.decompressPublicKey=e=>s.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1),n.privateKeyLength=32,n.masterNodeGenerationSpec="slip10",n.compressedPublicKeyLength=33}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivation.cjs",{"./BIP44CoinTypeNode.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs","./BIP44Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs","./SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","./derivers/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.validatePathSegment=n.deriveKeyFromPath=void 0;const r=e("@metamask/utils"),s=e("./BIP44CoinTypeNode.cjs"),o=e("./BIP44Node.cjs"),a=e("./constants.cjs"),i=e("./curves/index.cjs"),c=e("./derivers/index.cjs"),m=e("./SLIP10Node.cjs");function d(e,t,n){if(0===e.length)throw new Error("Invalid HD path segment: The segment must not be empty.");let s=!1;if(e.forEach((e,t)=>{if(0===t){if(s=e instanceof Uint8Array||a.BIP_39_PATH_REGEX.test(e),!(e instanceof Uint8Array||s||a.BIP_32_PATH_REGEX.test(e)||a.SLIP_10_PATH_REGEX.test(e)||a.CIP_3_PATH_REGEX.test(e)))throw u()}else if(e instanceof Uint8Array||!a.BIP_32_PATH_REGEX.test(e)&&!a.SLIP_10_PATH_REGEX.test(e)&&!a.CIP_3_PATH_REGEX.test(e))throw u()}),n===a.MIN_BIP_44_DEPTH&&(!s||1!==e.length))throw new Error(`Invalid HD path segment: The segment must consist of a single BIP-39 node for depths of ${a.MIN_BIP_44_DEPTH}. Received: "${String(e)}".`);if(!t&&!s)throw new Error("Invalid derivation parameters: Must specify parent key if the first node of the path segment is not a BIP-39 node.");if(t&&s)throw new Error("Invalid derivation parameters: May not specify parent key if the path segment starts with a BIP-39 node.");const o=s?e.slice(1):e;if(o.length>0){const e=o[0]?.split(":")[0];(0,r.assert)(e),(0,r.assert)(o.every(t=>t.startsWith(`${e}:`)),"Invalid HD path segment: Cannot mix 'bip32' and 'slip10' path segments.")}}function u(){return new Error("Invalid HD path segment: The path segment is malformed.")}n.deriveKeyFromPath=async function(e,t){const{path:n,depth:a=n.length}=e,l="node"in e?e.node:undefined,h="network"in e?e.network:l?.network,f="curve"in e?e.curve:l?.curve;if(l&&!(l instanceof m.SLIP10Node)&&!(l instanceof o.BIP44Node)&&!(l instanceof s.BIP44CoinTypeNode))throw new Error("Invalid arguments: Node must be a SLIP-10 node or a BIP-44 node when provided.");if(!f)throw new Error("Invalid arguments: Must specify either a parent node or curve.");return d(n,Boolean(l?.privateKey)||Boolean(l?.publicKey),a),await n.reduce(async(e,n,s)=>{const o=await e;if("string"==typeof n){const[e,s]=n.split(":");(0,r.assert)(e),(0,r.assert)(s),(0,r.assert)(function(e){return e in c.derivers}(e),`Unknown derivation type: "${e}".`);const a=c.derivers[e];return await a.deriveChildKey({path:s,node:o,curve:(0,i.getCurveByName)(f),network:h},t)}return(0,r.assert)(0===s,u()),await c.derivers.bip39.deriveChildKey({path:n,node:o,curve:(0,i.getCurveByName)(f),network:h},t)},Promise.resolve(l))},n.validatePathSegment=d}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivation.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip32.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","../cryptography.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs","../curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","./shared.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/shared.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildKey=n.publicKeyToEthAddress=n.privateKeyToEthAddress=void 0;const r=e("@metamask/utils"),s=e("./shared.cjs"),o=e("../constants.cjs"),a=e("../cryptography.cjs"),i=e("../curves/index.cjs"),c=e("../utils.cjs");function m(e){return(0,r.assert)(e instanceof Uint8Array&&(0,c.isValidBytesKey)(e,i.secp256k1.publicKeyLength),"Invalid key: The key must be a 65-byte, non-zero Uint8Array."),(0,a.keccak256)(e.slice(1)).slice(-20)}async function d(e,t,n){const{childIndex:r,privateKey:o,publicKey:a,isHardened:i,chainCode:m,curve:d}=t;if((0,c.validateBIP32Index)(r+1),o){const e=await(0,s.deriveSecretExtension)({privateKey:o,publicKey:d.compressPublicKey(a),childIndex:r+1,isHardened:i,curve:d}),c=await(0,s.generateEntropy)({chainCode:m,extension:e},n);return{...t,childIndex:r+1,entropy:c}}const u=(0,s.derivePublicExtension)({parentPublicKey:a,childIndex:r+1}),l=await(0,s.generateEntropy)({chainCode:m,extension:u});return{...t,childIndex:r+1,entropy:l}}n.privateKeyToEthAddress=function(e){return(0,r.assert)(e instanceof Uint8Array&&(0,c.isValidBytesKey)(e,o.BYTES_KEY_LENGTH),"Invalid key: The key must be a 32-byte, non-zero Uint8Array."),m(i.secp256k1.getPublicKey(e,!1))},n.publicKeyToEthAddress=m,n.deriveChildKey=async function(e,t){return(0,r.assert)("secp256k1"===e.curve.name,"Invalid curve: Only secp256k1 is supported by BIP-32."),(0,s.deriveChildKey)(e,d,t)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/bip32.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip39.cjs",{"../SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","../cryptography.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs","../curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","../guard.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/guard.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/scure-bip39":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/index.js","@metamask/scure-bip39/dist/wordlists/english.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/wordlists/english.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.entropyToCip3MasterNode=n.createBip39KeyFromSeed=n.deriveChildKey=n.getDerivationPathWithSeed=n.multipathToBip39Mnemonic=n.bip39MnemonicToMultipath=n.mnemonicToSeed=void 0;const r=e("@metamask/scure-bip39"),s=e("@metamask/scure-bip39/dist/wordlists/english.js"),o=e("@metamask/utils"),a=e("../constants.cjs"),i=e("../cryptography.cjs"),c=e("../curves/index.cjs"),m=e("../guard.cjs"),d=e("../SLIP10Node.cjs"),u=e("../utils.cjs"),l=[12,15,18,21,24];function h(e){const t=e.split(" ");(0,o.assert)(l.includes(t.length),"Invalid mnemonic phrase: The mnemonic phrase must consist of 12, 15, 18, 21, or 24 words."),(0,o.assert)(t.every(e=>s.wordlist.includes(e)),"Invalid mnemonic phrase: The mnemonic phrase contains an unknown word.")}async function f(e,t="",n){const r=`mnemonic${t}`.normalize("NFKD");return await(0,i.pbkdf2Sha512)(function(e,t){if("string"==typeof e)return h(e),(0,o.stringToBytes)(e.normalize("NFKD"));const n=Array.from(new Uint16Array(e.buffer)).map(e=>t[e]).join(" ");return h(n),(0,o.stringToBytes)(n)}(e,s.wordlist),(0,o.stringToBytes)(r),2048,64,n)}function p(e){return e instanceof Uint8Array?e:((0,o.assert)(e.startsWith("bip39:"),'Invalid HD path segment: The BIP-39 path must start with "bip39:".'),e.slice(6))}async function g(e,t,n,r){(0,o.assert)(e.length>=16&&e.length<=64,"Invalid seed: The seed must be between 16 and 64 bytes long.");const s=await(0,i.hmacSha512)(t.secret,e,r),c=s.slice(0,a.BYTES_KEY_LENGTH),l=s.slice(a.BYTES_KEY_LENGTH);(0,o.assert)(t.isValidPrivateKey(c),"Invalid private key: The private key must greater than 0 and less than the curve order.");const h=t.getPublicKey(c,!1),f=(0,u.getFingerprint)(t.compressPublicKey(h),t.compressedPublicKeyLength);return d.SLIP10Node.fromExtendedKey({privateKey:c,publicKey:h,chainCode:l,masterFingerprint:f,network:n,depth:0,parentFingerprint:0,index:0,curve:t.name,guard:m.PUBLIC_KEY_GUARD},r)}async function y(e,t,n,r){(0,o.assert)(e.length>=16&&e.length<=64,"Invalid entropy: The entropy must be between 16 and 64 bytes long.");const s=await(0,i.pbkdf2Sha512)(t.secret,e,4096,96,r);s[0]&=248,s[31]&=31,s[31]|=64;const a=s.slice(0,t.privateKeyLength),c=s.slice(t.privateKeyLength);(0,o.assert)(t.isValidPrivateKey(a),"Invalid private key.");const l=t.getPublicKey(a,!1),h=(0,u.getFingerprint)(t.compressPublicKey(l),t.compressedPublicKeyLength);return d.SLIP10Node.fromExtendedKey({privateKey:a,publicKey:l,chainCode:c,masterFingerprint:h,network:n,depth:0,parentFingerprint:0,index:0,curve:t.name,guard:m.PUBLIC_KEY_GUARD},r)}n.mnemonicToSeed=f,n.bip39MnemonicToMultipath=function(e){return`bip39:${e.toLowerCase().trim()}`},n.multipathToBip39Mnemonic=p,n.getDerivationPathWithSeed=async function({path:e,curve:t},n){const[a,...i]=e,m=p(a),d=(0,c.getCurveByName)(t);switch(d.masterNodeGenerationSpec){case"slip10":return[await f(m,"",n),...i];case"cip3":return[(0,r.mnemonicToEntropy)(m,s.wordlist),...i];default:return(0,o.assertExhaustive)(d)}},n.deriveChildKey=async function({path:e,curve:t,network:n},r){switch((0,o.assert)(e instanceof Uint8Array,"Invalid path: The path must be a Uint8Array."),t.masterNodeGenerationSpec){case"slip10":return g(e,t,n,r);case"cip3":return y(e,t,n,r);default:throw new Error("Unsupported master node generation spec.")}},n.createBip39KeyFromSeed=g,n.entropyToCip3MasterNode=y}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/bip39.cjs"}]],[],{});