LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/ropsten.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"ropsten",chainId:3,networkId:3,defaultHardfork:"merge",consensus:{type:"pow",algorithm:"ethash",ethash:{}},comment:"PoW test network",url:"https://github.com/ethereum/ropsten",genesis:{gasLimit:16777216,difficulty:1048576,nonce:"0x0000000000000042",extraData:"0x3535353535353535353535353535353535353535353535353535353535353535"},hardforks:[{name:"chainstart",block:0,forkHash:"0x30c7ddbc"},{name:"homestead",block:0,forkHash:"0x30c7ddbc"},{name:"tangerineWhistle",block:0,forkHash:"0x30c7ddbc"},{name:"spuriousDragon",block:10,forkHash:"0x63760190"},{name:"byzantium",block:17e5,forkHash:"0x3ea159c7"},{name:"constantinople",block:423e4,forkHash:"0x97b544f3"},{name:"petersburg",block:4939394,forkHash:"0xd6e2149b"},{name:"istanbul",block:6485846,forkHash:"0x4bc66396"},{name:"muirGlacier",block:7117117,forkHash:"0x6727ef90"},{name:"berlin",block:9812189,forkHash:"0xa157d377"},{name:"london",block:10499401,forkHash:"0x7119b6b3"},{"//_comment":"The forkHash will remain same as mergeForkIdTransition is post merge",name:"merge",ttd:"50000000000000000",block:null,forkHash:"0x7119b6b3"},{name:"mergeForkIdTransition",block:null,forkHash:null},{name:"shanghai",block:null,forkHash:null}],bootstrapNodes:[{ip:"52.176.7.10",port:30303,id:"30b7ab30a01c124a6cceca36863ece12c4f5fa68e3ba9b0b51407ccc002eeed3b3102d20a88f1c1d3c3154e2449317b8ef95090e77b312d5cc39354f86d5d606",location:"",comment:"US-Azure geth"},{ip:"52.176.100.77",port:30303,id:"865a63255b3bb68023b6bffd5095118fcc13e79dcf014fe4e47e065c350c7cc72af2e53eff895f11ba1bbb6a2b33271c1116ee870f266618eadfc2e78aa7349c",location:"",comment:"US-Azure parity"},{ip:"52.232.243.152",port:30303,id:"6332792c4a00e3e4ee0926ed89e0d27ef985424d97b6a45bf0f23e51f0dcb5e66b875777506458aea7af6f9e4ffb69f43f3778ee73c81ed9d34c51c4b16b0b0f",location:"",comment:"Parity"},{ip:"192.81.208.223",port:30303,id:"94c15d1b9e2fe7ce56e458b9a3b672ef11894ddedd0c6f247e0f1d3487f52b66208fb4aeb8179fce6e3a749ea93ed147c37976d67af557508d199d9594c35f09",location:"",comment:"@gpip"}],dnsNetworks:["enrtree://AKA3AM6LPBYEUDMVNU3BSVQJ5AD45Y7YPOHJLEF6W26QOE4VTUDPE@all.ropsten.ethdisco.net"]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/ropsten.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/sepolia.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"sepolia",chainId:11155111,networkId:11155111,defaultHardfork:"merge",consensus:{type:"pow",algorithm:"ethash",ethash:{}},comment:"PoW test network to replace Ropsten",url:"https://github.com/ethereum/go-ethereum/pull/23730",genesis:{timestamp:"0x6159af19",gasLimit:3e7,difficulty:131072,nonce:"0x0000000000000000",extraData:"0x5365706f6c69612c20417468656e732c204174746963612c2047726565636521"},hardforks:[{name:"chainstart",block:0,forkHash:"0xfe3366e7"},{name:"homestead",block:0,forkHash:"0xfe3366e7"},{name:"tangerineWhistle",block:0,forkHash:"0xfe3366e7"},{name:"spuriousDragon",block:0,forkHash:"0xfe3366e7"},{name:"byzantium",block:0,forkHash:"0xfe3366e7"},{name:"constantinople",block:0,forkHash:"0xfe3366e7"},{name:"petersburg",block:0,forkHash:"0xfe3366e7"},{name:"istanbul",block:0,forkHash:"0xfe3366e7"},{name:"muirGlacier",block:0,forkHash:"0xfe3366e7"},{name:"berlin",block:0,forkHash:"0xfe3366e7"},{name:"london",block:0,forkHash:"0xfe3366e7"},{"//_comment":"The forkHash will remain same as mergeForkIdTransition is post merge, terminal block: https://sepolia.etherscan.io/block/1450408",name:"merge",ttd:"17000000000000000",block:1450409,forkHash:"0xfe3366e7"},{name:"mergeForkIdTransition",block:1735371,forkHash:"0xb96cbd13"},{name:"shanghai",block:null,timestamp:"1677557088",forkHash:"0xf7f9bc08"}],bootstrapNodes:[{ip:"18.168.182.86",port:30303,id:"9246d00bc8fd1742e5ad2428b80fc4dc45d786283e05ef6edbd9002cbc335d40998444732fbe921cb88e1d2c73d1b1de53bae6a2237996e9bfe14f871baf7066",location:"",comment:"geth"},{ip:"52.14.151.177",port:30303,id:"ec66ddcf1a974950bd4c782789a7e04f8aa7110a72569b6e65fcd51e937e74eed303b1ea734e4d19cfaec9fbff9b6ee65bf31dcb50ba79acce9dd63a6aca61c7",location:"",comment:"besu"},{ip:"165.22.196.173",port:30303,id:"ce970ad2e9daa9e14593de84a8b49da3d54ccfdf83cbc4fe519cb8b36b5918ed4eab087dedd4a62479b8d50756b492d5f762367c8d20329a7854ec01547568a6",location:"",comment:"EF"},{ip:"65.108.95.67",port:30303,id:"075503b13ed736244896efcde2a992ec0b451357d46cb7a8132c0384721742597fc8f0d91bbb40bb52e7d6e66728d36a1fda09176294e4a30cfac55dcce26bc6",location:"",comment:"lodestar"}],dnsNetworks:["enrtree://AKA3AM6LPBYEUDMVNU3BSVQJ5AD45Y7YPOHJLEF6W26QOE4VTUDPE@all.sepolia.ethdisco.net"]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/sepolia.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/common.js",{"./chains/goerli.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/goerli.json","./chains/mainnet.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/mainnet.json","./chains/rinkeby.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/rinkeby.json","./chains/ropsten.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/ropsten.json","./chains/sepolia.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/chains/sepolia.json","./eips":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/index.js","./enums":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/enums.js","./hardforks":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/index.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","crc-32":"/home/runner/work/metamask-extension/metamask-extension/node_modules/crc-32/crc32.js",events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Common=void 0;const r=e("@ethereumjs/util"),s=e("crc-32"),o=e("events"),i=e("./chains/goerli.json"),a=e("./chains/mainnet.json"),f=e("./chains/rinkeby.json"),u=e("./chains/ropsten.json"),l=e("./chains/sepolia.json"),d=e("./eips"),c=e("./enums"),m=e("./hardforks"),h=e("./utils");class b extends o.EventEmitter{constructor(e){super(),this._eips=[],this._customChains=e.customChains??[],this._chainParams=this.setChain(e.chain),this.DEFAULT_HARDFORK=this._chainParams.defaultHardfork??c.Hardfork.Merge,this.HARDFORK_CHANGES=this.hardforks().map(e=>[e.name,m.hardforks[e.name]]),this._hardfork=this.DEFAULT_HARDFORK,e.hardfork!==undefined&&this.setHardfork(e.hardfork),e.eips&&this.setEIPs(e.eips)}static custom(e,t={}){const n=t.baseChain??"mainnet",r={...b._getChainParams(n)};if(r.name="custom-chain","string"!=typeof e)return new b({chain:{...r,...e},...t});if(e===c.CustomChain.PolygonMainnet)return b.custom({name:c.CustomChain.PolygonMainnet,chainId:137,networkId:137},t);if(e===c.CustomChain.PolygonMumbai)return b.custom({name:c.CustomChain.PolygonMumbai,chainId:80001,networkId:80001},t);if(e===c.CustomChain.ArbitrumRinkebyTestnet)return b.custom({name:c.CustomChain.ArbitrumRinkebyTestnet,chainId:421611,networkId:421611},t);if(e===c.CustomChain.ArbitrumOne)return b.custom({name:c.CustomChain.ArbitrumOne,chainId:42161,networkId:42161},t);if(e===c.CustomChain.xDaiChain)return b.custom({name:c.CustomChain.xDaiChain,chainId:100,networkId:100},t);if(e===c.CustomChain.OptimisticKovan)return b.custom({name:c.CustomChain.OptimisticKovan,chainId:69,networkId:69},{hardfork:c.Hardfork.Berlin,...t});if(e===c.CustomChain.OptimisticEthereum)return b.custom({name:c.CustomChain.OptimisticEthereum,chainId:10,networkId:10},{hardfork:c.Hardfork.Berlin,...t});throw new Error(`Custom chain ${e} not supported`)}static fromGethGenesis(e,{chain:t,eips:n,genesisHash:r,hardfork:s,mergeForkIdPostMerge:o}){const i=(0,h.parseGethGenesis)(e,t,o),a=new b({chain:i.name??"custom",customChains:[i],eips:n,hardfork:s??i.hardfork});return r!==undefined&&a.setForkHashes(r),a}static isSupportedChainId(e){const t=this._getInitializedChains();return Boolean(t.names[e.toString()])}static _getChainParams(e,t){const n=this._getInitializedChains(t);if("number"==typeof e||"bigint"==typeof e){if(e=e.toString(),n.names[e]){return n[n.names[e]]}throw new Error(`Chain with ID ${e} not supported`)}if(n[e]!==undefined)return n[e];throw new Error(`Chain with name ${e} not supported`)}setChain(e){if("number"==typeof e||"bigint"==typeof e||"string"==typeof e)this._chainParams=b._getChainParams(e,this._customChains);else{if("object"!=typeof e)throw new Error("Wrong input format");{if(this._customChains.length>0)throw new Error("Chain must be a string, number, or bigint when initialized with customChains passed in");const t=["networkId","genesis","hardforks","bootstrapNodes"];for(const n of t)if(!(n in e))throw new Error(`Missing required chain parameter: ${n}`);this._chainParams=e}}for(const e of this.hardforks())if(e.block===undefined)throw new Error("Hardfork cannot have undefined block number");return this._chainParams}setHardfork(e){let t=!1;for(const n of this.HARDFORK_CHANGES)n[0]===e&&(this._hardfork!==e&&(this._hardfork=e,this.emit("hardforkChanged",e)),t=!0);if(!t)throw new Error(`Hardfork with name ${e} not supported`)}getHardforkByBlockNumber(e,t,n){e=(0,r.toType)(e,r.TypeOutput.BigInt),t=(0,r.toType)(t,r.TypeOutput.BigInt),n=(0,r.toType)(n,r.TypeOutput.Number);const s=this.hardforks().filter(e=>null!==e.block||null!==e.ttd&&e.ttd!==undefined||e.timestamp!==undefined),o=s.findIndex(e=>null!==e.ttd&&e.ttd!==undefined);if(s.slice(o+1).findIndex(e=>null!==e.ttd&&e.ttd!==undefined)>=0)throw Error("More than one merge hardforks found with ttd specified");let i=s.findIndex(t=>null!==t.block&&t.block>e||n!==undefined&&Number(t.timestamp)>n);if(-1===i)i=s.length;else if(0===i)throw Error("Must have at least one hardfork at block 0");if(n===undefined){i-=s.slice(0,i).reverse().findIndex(e=>null!==e.block||e.ttd!==undefined)}if(i-=1,null===s[i].block&&s[i].timestamp===undefined)(t===undefined||null===t||BigInt(s[i].ttd)>t)&&(i-=1);else if(o>=0&&t!==undefined&&null!==t){if(i>=o&&BigInt(s[o].ttd)>t)throw Error("Maximum HF determined by total difficulty is lower than the block number HF");if(i<o&&BigInt(s[o].ttd)<=t)throw Error("HF determined by block number is lower than the minimum total difficulty HF")}const a=i;for(;i<s.length-1&&(s[i].block===s[i+1].block&&s[i].timestamp===s[i+1].timestamp);i++);if(n){if(s.slice(0,a).reduce((e,t)=>Math.max(Number(t.timestamp??"0"),e),0)>n)throw Error("Maximum HF determined by timestamp is lower than the block number/ttd HF");if(s.slice(i+1).reduce((e,t)=>Math.min(Number(t.timestamp??n),e),n)<n)throw Error("Maximum HF determined by block number/ttd is lower than timestamp HF")}return s[i].name}setHardforkByBlockNumber(e,t,n){const r=this.getHardforkByBlockNumber(e,t,n);return this.setHardfork(r),r}_getHardfork(e){const t=this.hardforks();for(const n of t)if(n.name===e)return n;return null}setEIPs(e=[]){for(const t of e){if(!(t in d.EIPs))throw new Error(`${t} not supported`);const n=this.gteHardfork(d.EIPs[t].minimumHardfork);if(!n)throw new Error(`${t} cannot be activated on hardfork ${this.hardfork()}, minimumHardfork: ${n}`);if(d.EIPs[t].requiredEIPs!==undefined)for(const n of d.EIPs[t].requiredEIPs)if(!e.includes(n)&&!this.isActivatedEIP(n))throw new Error(`${t} requires EIP ${n}, but is not included in the EIP list`)}this._eips=e}param(e,t){let n;for(const r of this._eips)if(n=this.paramByEIP(e,t,r),n!==undefined)return n;return this.paramByHardfork(e,t,this._hardfork)}paramByHardfork(e,t,n){let r=null;for(const s of this.HARDFORK_CHANGES){if("eips"in s[1]){const n=s[1].eips;for(const s of n){const n=this.paramByEIP(e,t,s);r="bigint"==typeof n?n:r}}else{if(s[1][e]===undefined)throw new Error(`Topic ${e} not defined`);s[1][e][t]!==undefined&&(r=s[1][e][t].v)}if(s[0]===n)break}return BigInt(r??0)}paramByEIP(e,t,n){if(!(n in d.EIPs))throw new Error(`${n} not supported`);const r=d.EIPs[n];if(!(e in r))throw new Error(`Topic ${e} not defined`);if(r[e][t]===undefined)return undefined;const s=r[e][t].v;return BigInt(s)}paramByBlock(e,t,n,r,s){const o=this.getHardforkByBlockNumber(n,r,s);return this.paramByHardfork(e,t,o)}isActivatedEIP(e){if(this.eips().includes(e))return!0;for(const t of this.HARDFORK_CHANGES){const n=t[1];if(this.gteHardfork(n.name)&&"eips"in n&&n.eips.includes(e))return!0}return!1}hardforkIsActiveOnBlock(e,t){t=(0,r.toType)(t,r.TypeOutput.BigInt),e=e??this._hardfork;const n=this.hardforkBlock(e);return"bigint"==typeof n&&n!==BigInt(0)&&t>=n}activeOnBlock(e){return this.hardforkIsActiveOnBlock(null,e)}hardforkGteHardfork(e,t){e=e??this._hardfork;const n=this.hardforks();let r=-1,s=-1,o=0;for(const i of n)i.name===e&&(r=o),i.name===t&&(s=o),o+=1;return r>=s&&-1!==s}gteHardfork(e){return this.hardforkGteHardfork(null,e)}hardforkBlock(e){e=e??this._hardfork;const t=this._getHardfork(e)?.block;return t===undefined||null===t?null:BigInt(t)}hardforkTimestamp(e){e=e??this._hardfork;const t=this._getHardfork(e)?.timestamp;return t===undefined||null===t?null:BigInt(t)}eipBlock(e){for(const t of this.HARDFORK_CHANGES){const n=t[1];if("eips"in n&&n.eips.includes(e))return this.hardforkBlock(t[0])}return null}hardforkTTD(e){e=e??this._hardfork;const t=this._getHardfork(e)?.ttd;return t===undefined||null===t?null:BigInt(t)}isHardforkBlock(e,t){e=(0,r.toType)(e,r.TypeOutput.BigInt),t=t??this._hardfork;const n=this.hardforkBlock(t);return"bigint"==typeof n&&n!==BigInt(0)&&n===e}nextHardforkBlockOrTimestamp(e){e=e??this._hardfork;const t=this.hardforks();let n=t.findIndex(t=>t.name===e);if(e===c.Hardfork.Merge&&(n-=1),n<0)return null;let r=t[n].timestamp??t[n].block;r=null!==r&&r!==undefined?Number(r):null;const s=t.slice(n+1).find(e=>{let t=e.timestamp??e.block;return t=null!==t&&t!==undefined?Number(t):null,e.name!==c.Hardfork.Merge&&null!==t&&t!==undefined&&t!==r});if(s===undefined)return null;const o=s.timestamp??s.block;return null===o||o===undefined?null:BigInt(o)}nextHardforkBlock(e){e=e??this._hardfork;let t=this.hardforkBlock(e);if(null===t&&e===c.Hardfork.Merge){const e=this.hardforks(),n=e.findIndex(e=>null!==e.ttd&&e.ttd!==undefined);if(n<0)throw Error("Merge hardfork should have been found");t=this.hardforkBlock(e[n-1].name)}if(null===t)return null;return this.hardforks().reduce((e,n)=>{const r=BigInt(null===n.block||n.ttd!==undefined&&null!==n.ttd?0:n.block);return r>t&&null===e?r:e},null)}isNextHardforkBlock(e,t){e=(0,r.toType)(e,r.TypeOutput.BigInt),t=t??this._hardfork;const n=this.nextHardforkBlock(t);return null!==n&&n===e}_calcForkHash(e,n){let o=t.alloc(0),i=0;for(const n of this.hardforks()){const{block:r,timestamp:s,name:a}=n;let f=s??r;if(f=null!==f?Number(f):null,"number"==typeof f&&0!==f&&f!==i&&a!==c.Hardfork.Merge){const e=t.from(f.toString(16).padStart(16,"0"),"hex");o=t.concat([o,e]),i=f}if(n.name===e)break}const a=t.concat([n,o]);return`0x${(0,r.intToBuffer)((0,s.buf)(a)>>>0).toString("hex")}`}forkHash(e,t){e=e??this._hardfork;const n=this._getHardfork(e);if(null===n||null===n?.block&&n?.timestamp===undefined&&n?.ttd===undefined){throw new Error("No fork hash calculation possible for future hardfork")}if(null!==n?.forkHash&&n?.forkHash!==undefined)return n.forkHash;if(!t)throw new Error("genesisHash required for forkHash calculation");return this._calcForkHash(e,t)}hardforkForForkHash(e){const t=this.hardforks().filter(t=>t.forkHash===e);return t.length>=1?t[t.length-1]:null}setForkHashes(e){for(const t of this.hardforks()){const n=t.timestamp??t.block;null!==t.forkHash&&t.forkHash!==undefined||(null===n||n===undefined)&&void 0===t.ttd||(t.forkHash=this.forkHash(t.name,e))}}genesis(){return this._chainParams.genesis}hardforks(){return this._chainParams.hardforks}bootstrapNodes(){return this._chainParams.bootstrapNodes}dnsNetworks(){return this._chainParams.dnsNetworks}hardfork(){return this._hardfork}chainId(){return BigInt(this._chainParams.chainId)}chainName(){return this._chainParams.name}networkId(){return BigInt(this._chainParams.networkId)}eips(){return this._eips}consensusType(){const e=this.hardfork();let t;for(const n of this.HARDFORK_CHANGES)if("consensus"in n[1]&&(t=n[1].consensus.type),n[0]===e)break;return t??this._chainParams.consensus.type}consensusAlgorithm(){const e=this.hardfork();let t;for(const n of this.HARDFORK_CHANGES)if("consensus"in n[1]&&(t=n[1].consensus.algorithm),n[0]===e)break;return t??this._chainParams.consensus.algorithm}consensusConfig(){const e=this.hardfork();let t;for(const n of this.HARDFORK_CHANGES)if("consensus"in n[1]&&(t=n[1].consensus[n[1].consensus.algorithm]),n[0]===e)break;return t??this._chainParams.consensus[this.consensusAlgorithm()]??{}}copy(){const e=Object.assign(Object.create(Object.getPrototypeOf(this)),this);return e.removeAllListeners(),e}static _getInitializedChains(e){const t={};for(const[e,n]of Object.entries(c.Chain))t[n]=e.toLowerCase();const n={mainnet:a,ropsten:u,rinkeby:f,goerli:i,sepolia:l};if(e)for(const r of e){const{name:e}=r;t[r.chainId.toString()]=e,n[e]=r}return n.names=t,n}}n.Common=b}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/common.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/1153.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-1153",number:1153,comment:"Transient Storage",url:"https://eips.ethereum.org/EIPS/eip-1153",status:"Review",minimumHardfork:"chainstart",requiredEIPs:[],gasConfig:{},gasPrices:{tstore:{v:100,d:"Base fee of the TSTORE opcode"},tload:{v:100,d:"Base fee of the TLOAD opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/1153.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/1559.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-1559",number:1559,comment:"Fee market change for ETH 1.0 chain",url:"https://eips.ethereum.org/EIPS/eip-1559",status:"Final",minimumHardfork:"berlin",requiredEIPs:[2930],gasConfig:{baseFeeMaxChangeDenominator:{v:8,d:"Maximum base fee change denominator"},elasticityMultiplier:{v:2,d:"Maximum block gas target elasticity"},initialBaseFee:{v:1e9,d:"Initial base fee on first EIP1559 block"}},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/1559.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2315.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-2315",number:2315,comment:"Simple subroutines for the EVM",url:"https://eips.ethereum.org/EIPS/eip-2315",status:"Draft",minimumHardfork:"istanbul",gasConfig:{},gasPrices:{beginsub:{v:2,d:"Base fee of the BEGINSUB opcode"},returnsub:{v:5,d:"Base fee of the RETURNSUB opcode"},jumpsub:{v:10,d:"Base fee of the JUMPSUB opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2315.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2537.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-2537",number:2537,comment:"BLS12-381 precompiles",url:"https://eips.ethereum.org/EIPS/eip-2537",status:"Draft",minimumHardfork:"chainstart",gasConfig:{},gasPrices:{Bls12381G1AddGas:{v:600,d:"Gas cost of a single BLS12-381 G1 addition precompile-call"},Bls12381G1MulGas:{v:12e3,d:"Gas cost of a single BLS12-381 G1 multiplication precompile-call"},Bls12381G2AddGas:{v:4500,d:"Gas cost of a single BLS12-381 G2 addition precompile-call"},Bls12381G2MulGas:{v:55e3,d:"Gas cost of a single BLS12-381 G2 multiplication precompile-call"},Bls12381PairingBaseGas:{v:115e3,d:"Base gas cost of BLS12-381 pairing check"},Bls12381PairingPerPairGas:{v:23e3,d:"Per-pair gas cost of BLS12-381 pairing check"},Bls12381MapG1Gas:{v:5500,d:"Gas cost of BLS12-381 map field element to G1"},Bls12381MapG2Gas:{v:11e4,d:"Gas cost of BLS12-381 map field element to G2"},Bls12381MultiExpGasDiscount:{v:[[1,1200],[2,888],[3,764],[4,641],[5,594],[6,547],[7,500],[8,453],[9,438],[10,423],[11,408],[12,394],[13,379],[14,364],[15,349],[16,334],[17,330],[18,326],[19,322],[20,318],[21,314],[22,310],[23,306],[24,302],[25,298],[26,294],[27,289],[28,285],[29,281],[30,277],[31,273],[32,269],[33,268],[34,266],[35,265],[36,263],[37,262],[38,260],[39,259],[40,257],[41,256],[42,254],[43,253],[44,251],[45,250],[46,248],[47,247],[48,245],[49,244],[50,242],[51,241],[52,239],[53,238],[54,236],[55,235],[56,233],[57,232],[58,231],[59,229],[60,228],[61,226],[62,225],[63,223],[64,222],[65,221],[66,220],[67,219],[68,219],[69,218],[70,217],[71,216],[72,216],[73,215],[74,214],[75,213],[76,213],[77,212],[78,211],[79,211],[80,210],[81,209],[82,208],[83,208],[84,207],[85,206],[86,205],[87,205],[88,204],[89,203],[90,202],[91,202],[92,201],[93,200],[94,199],[95,199],[96,198],[97,197],[98,196],[99,196],[100,195],[101,194],[102,193],[103,193],[104,192],[105,191],[106,191],[107,190],[108,189],[109,188],[110,188],[111,187],[112,186],[113,185],[114,185],[115,184],[116,183],[117,182],[118,182],[119,181],[120,180],[121,179],[122,179],[123,178],[124,177],[125,176],[126,176],[127,175],[128,174]],d:"Discount gas costs of calls to the MultiExp precompiles with `k` (point, scalar) pair"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2537.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2565.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-2565",number:2565,comment:"ModExp gas cost",url:"https://eips.ethereum.org/EIPS/eip-2565",status:"Final",minimumHardfork:"byzantium",gasConfig:{},gasPrices:{modexpGquaddivisor:{v:3,d:"Gquaddivisor from modexp precompile for gas calculation"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2565.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2718.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-2718",comment:"Typed Transaction Envelope",url:"https://eips.ethereum.org/EIPS/eip-2718",status:"Final",minimumHardfork:"chainstart",gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2718.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2929.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-2929",comment:"Gas cost increases for state access opcodes",url:"https://eips.ethereum.org/EIPS/eip-2929",status:"Final",minimumHardfork:"chainstart",gasConfig:{},gasPrices:{coldsload:{v:2100,d:"Gas cost of the first read of storage from a given location (per transaction)"},coldaccountaccess:{v:2600,d:"Gas cost of the first read of a given address (per transaction)"},warmstorageread:{v:100,d:"Gas cost of reading storage locations which have already loaded 'cold'"},sstoreCleanGasEIP2200:{v:2900,d:"Once per SSTORE operation from clean non-zero to something else"},sstoreNoopGasEIP2200:{v:100,d:"Once per SSTORE operation if the value doesn't change"},sstoreDirtyGasEIP2200:{v:100,d:"Once per SSTORE operation if a dirty value is changed"},sstoreInitRefundEIP2200:{v:19900,d:"Once per SSTORE operation for resetting to the original zero value"},sstoreCleanRefundEIP2200:{v:4900,d:"Once per SSTORE operation for resetting to the original non-zero value"},call:{v:0,d:"Base fee of the CALL opcode"},callcode:{v:0,d:"Base fee of the CALLCODE opcode"},delegatecall:{v:0,d:"Base fee of the DELEGATECALL opcode"},staticcall:{v:0,d:"Base fee of the STATICCALL opcode"},balance:{v:0,d:"Base fee of the BALANCE opcode"},extcodesize:{v:0,d:"Base fee of the EXTCODESIZE opcode"},extcodecopy:{v:0,d:"Base fee of the EXTCODECOPY opcode"},extcodehash:{v:0,d:"Base fee of the EXTCODEHASH opcode"},sload:{v:0,d:"Base fee of the SLOAD opcode"},sstore:{v:0,d:"Base fee of the SSTORE opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2929.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2930.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-2930",comment:"Optional access lists",url:"https://eips.ethereum.org/EIPS/eip-2930",status:"Final",minimumHardfork:"istanbul",requiredEIPs:[2718,2929],gasConfig:{},gasPrices:{accessListStorageKeyCost:{v:1900,d:"Gas cost per storage key in an Access List transaction"},accessListAddressCost:{v:2400,d:"Gas cost per storage key in an Access List transaction"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2930.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3074.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3074",number:3074,comment:"AUTH and AUTHCALL opcodes",url:"https://eips.ethereum.org/EIPS/eip-3074",status:"Review",minimumHardfork:"london",gasConfig:{},gasPrices:{auth:{v:3100,d:"Gas cost of the AUTH opcode"},authcall:{v:0,d:"Gas cost of the AUTHCALL opcode"},authcallValueTransfer:{v:6700,d:"Paid for CALL when the value transfer is non-zero"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3074.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3198.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3198",number:3198,comment:"BASEFEE opcode",url:"https://eips.ethereum.org/EIPS/eip-3198",status:"Final",minimumHardfork:"london",gasConfig:{},gasPrices:{basefee:{v:2,d:"Gas cost of the BASEFEE opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3198.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3529.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3529",comment:"Reduction in refunds",url:"https://eips.ethereum.org/EIPS/eip-3529",status:"Final",minimumHardfork:"berlin",requiredEIPs:[2929],gasConfig:{maxRefundQuotient:{v:5,d:"Maximum refund quotient; max tx refund is min(tx.gasUsed/maxRefundQuotient, tx.gasRefund)"}},gasPrices:{selfdestructRefund:{v:0,d:"Refunded following a selfdestruct operation"},sstoreClearRefundEIP2200:{v:4800,d:"Once per SSTORE operation for clearing an originally existing storage slot"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3529.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3540.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3540",number:3540,comment:"EVM Object Format (EOF) v1",url:"https://eips.ethereum.org/EIPS/eip-3540",status:"Review",minimumHardfork:"london",requiredEIPs:[3541],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3540.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3541.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3541",comment:"Reject new contracts starting with the 0xEF byte",url:"https://eips.ethereum.org/EIPS/eip-3541",status:"Final",minimumHardfork:"berlin",requiredEIPs:[],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3541.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3554.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3554",comment:"Reduction in refunds",url:"Difficulty Bomb Delay to December 1st 2021",status:"Final",minimumHardfork:"muirGlacier",requiredEIPs:[],gasConfig:{},gasPrices:{},vm:{},pow:{difficultyBombDelay:{v:95e5,d:"the amount of blocks to delay the difficulty bomb with"}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3554.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3607.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3607",number:3607,comment:"Reject transactions from senders with deployed code",url:"https://eips.ethereum.org/EIPS/eip-3607",status:"Final",minimumHardfork:"chainstart",requiredEIPs:[],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3607.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3651.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3651",number:3198,comment:"Warm COINBASE",url:"https://eips.ethereum.org/EIPS/eip-3651",status:"Review",minimumHardfork:"london",requiredEIPs:[2929],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3651.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3670.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3670",number:3670,comment:"EOF - Code Validation",url:"https://eips.ethereum.org/EIPS/eip-3670",status:"Review",minimumHardfork:"london",requiredEIPs:[3540],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3670.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3675.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3675",number:3675,comment:"Upgrade consensus to Proof-of-Stake",url:"https://eips.ethereum.org/EIPS/eip-3675",status:"Final",minimumHardfork:"london",requiredEIPs:[],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3675.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3855.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3855",number:3855,comment:"PUSH0 instruction",url:"https://eips.ethereum.org/EIPS/eip-3855",status:"Review",minimumHardfork:"chainstart",requiredEIPs:[],gasConfig:{},gasPrices:{push0:{v:2,d:"Base fee of the PUSH0 opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3855.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3860.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-3860",number:3860,comment:"Limit and meter initcode",url:"https://eips.ethereum.org/EIPS/eip-3860",status:"Review",minimumHardfork:"spuriousDragon",requiredEIPs:[],gasConfig:{},gasPrices:{initCodeWordCost:{v:2,d:"Gas to pay for each word (32 bytes) of initcode when creating a contract"}},vm:{maxInitCodeSize:{v:49152,d:"Maximum length of initialization code when creating a contract"}},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3860.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4345.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-4345",number:4345,comment:"Difficulty Bomb Delay to June 2022",url:"https://eips.ethereum.org/EIPS/eip-4345",status:"Final",minimumHardfork:"london",gasConfig:{},gasPrices:{},vm:{},pow:{difficultyBombDelay:{v:107e5,d:"the amount of blocks to delay the difficulty bomb with"}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4345.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4399.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-4399",number:4399,comment:"Supplant DIFFICULTY opcode with PREVRANDAO",url:"https://eips.ethereum.org/EIPS/eip-4399",status:"Review",minimumHardfork:"london",requiredEIPs:[],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4399.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4844.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-4844",number:4844,comment:"Shard Blob Transactions",url:"https://eips.ethereum.org/EIPS/eip-4844",status:"Draft",minimumHardfork:"merge",requiredEIPs:[1559,2718,2930,4895],gasConfig:{dataGasPerBlob:{v:131072,d:"The base fee for data gas per blob"},targetDataGasPerBlock:{v:262144,d:"The target data gas consumed per block"},maxDataGasPerBlock:{v:524288,d:"The max data gas allowable per block"},dataGasPriceUpdateFraction:{v:2225652,d:"The denominator used in the exponential when calculating a data gas price"}},gasPrices:{simpleGasPerBlob:{v:12e3,d:"The basic gas fee for each blob"},minDataGasPrice:{v:1,d:"The minimum fee per data gas"},kzgPointEvaluationGasPrecompilePrice:{v:5e4,d:"The fee associated with the point evaluation precompile"},datahash:{v:3,d:"Base fee of the DATAHASH opcode"}},sharding:{blobCommitmentVersionKzg:{v:1,d:"The number indicated a versioned hash is a KZG commitment"},fieldElementsPerBlob:{v:4096,d:"The number of field elements allowed per blob"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4844.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4895.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-4895",number:4895,comment:"Beacon chain push withdrawals as operations",url:"https://eips.ethereum.org/EIPS/eip-4895",status:"Review",minimumHardfork:"merge",requiredEIPs:[],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4895.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/5133.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"EIP-5133",number:5133,comment:"Delaying Difficulty Bomb to mid-September 2022",url:"https://eips.ethereum.org/EIPS/eip-5133",status:"Draft",minimumHardfork:"grayGlacier",gasConfig:{},gasPrices:{},vm:{},pow:{difficultyBombDelay:{v:114e5,d:"the amount of blocks to delay the difficulty bomb with"}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/5133.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/index.js",{"./1153.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/1153.json","./1559.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/1559.json","./2315.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2315.json","./2537.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2537.json","./2565.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2565.json","./2718.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2718.json","./2929.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2929.json","./2930.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/2930.json","./3074.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3074.json","./3198.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3198.json","./3529.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3529.json","./3540.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3540.json","./3541.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3541.json","./3554.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3554.json","./3607.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3607.json","./3651.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3651.json","./3670.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3670.json","./3675.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3675.json","./3855.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3855.json","./3860.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/3860.json","./4345.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4345.json","./4399.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4399.json","./4844.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4844.json","./4895.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/4895.json","./5133.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/5133.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.EIPs=void 0,n.EIPs={1153:e("./1153.json"),1559:e("./1559.json"),2315:e("./2315.json"),2537:e("./2537.json"),2565:e("./2565.json"),2718:e("./2718.json"),2929:e("./2929.json"),2930:e("./2930.json"),3074:e("./3074.json"),3198:e("./3198.json"),3529:e("./3529.json"),3540:e("./3540.json"),3541:e("./3541.json"),3554:e("./3554.json"),3607:e("./3607.json"),3651:e("./3651.json"),3670:e("./3670.json"),3675:e("./3675.json"),3855:e("./3855.json"),3860:e("./3860.json"),4345:e("./4345.json"),4399:e("./4399.json"),4844:e("./4844.json"),4895:e("./4895.json"),5133:e("./5133.json")}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/eips/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/enums.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CustomChain=n.ConsensusAlgorithm=n.ConsensusType=n.Hardfork=n.Chain=void 0,function(e){e[e.Mainnet=1]="Mainnet",e[e.Ropsten=3]="Ropsten",e[e.Rinkeby=4]="Rinkeby",e[e.Goerli=5]="Goerli",e[e.Sepolia=11155111]="Sepolia"}(n.Chain||(n.Chain={})),function(e){e.Chainstart="chainstart",e.Homestead="homestead",e.Dao="dao",e.TangerineWhistle="tangerineWhistle",e.SpuriousDragon="spuriousDragon",e.Byzantium="byzantium",e.Constantinople="constantinople",e.Petersburg="petersburg",e.Istanbul="istanbul",e.MuirGlacier="muirGlacier",e.Berlin="berlin",e.London="london",e.ArrowGlacier="arrowGlacier",e.GrayGlacier="grayGlacier",e.MergeForkIdTransition="mergeForkIdTransition",e.Merge="merge",e.Shanghai="shanghai",e.ShardingForkDev="shardingFork"}(n.Hardfork||(n.Hardfork={})),function(e){e.ProofOfStake="pos",e.ProofOfWork="pow",e.ProofOfAuthority="poa"}(n.ConsensusType||(n.ConsensusType={})),function(e){e.Ethash="ethash",e.Clique="clique",e.Casper="casper"}(n.ConsensusAlgorithm||(n.ConsensusAlgorithm={})),function(e){e.PolygonMainnet="polygon-mainnet",e.PolygonMumbai="polygon-mumbai",e.ArbitrumRinkebyTestnet="arbitrum-rinkeby-testnet",e.ArbitrumOne="arbitrum-one",e.xDaiChain="x-dai-chain",e.OptimisticKovan="optimistic-kovan",e.OptimisticEthereum="optimistic-ethereum"}(n.CustomChain||(n.CustomChain={}))}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/enums.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/arrowGlacier.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"arrowGlacier",comment:"HF to delay the difficulty bomb",url:"https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/arrow-glacier.md",status:"Final",eips:[4345],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/arrowGlacier.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/berlin.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"berlin",comment:"HF targeted for July 2020 following the Muir Glacier HF",url:"https://eips.ethereum.org/EIPS/eip-2070",status:"Final",eips:[2565,2929,2718,2930]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/berlin.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/byzantium.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"byzantium",comment:"Hardfork with new precompiles, instructions and other protocol changes",url:"https://eips.ethereum.org/EIPS/eip-609",status:"Final",gasConfig:{},gasPrices:{modexpGquaddivisor:{v:20,d:"Gquaddivisor from modexp precompile for gas calculation"},ecAdd:{v:500,d:"Gas costs for curve addition precompile"},ecMul:{v:4e4,d:"Gas costs for curve multiplication precompile"},ecPairing:{v:1e5,d:"Base gas costs for curve pairing precompile"},ecPairingWord:{v:8e4,d:"Gas costs regarding curve pairing precompile input length"},revert:{v:0,d:"Base fee of the REVERT opcode"},staticcall:{v:700,d:"Base fee of the STATICCALL opcode"},returndatasize:{v:2,d:"Base fee of the RETURNDATASIZE opcode"},returndatacopy:{v:3,d:"Base fee of the RETURNDATACOPY opcode"}},vm:{},pow:{minerReward:{v:"3000000000000000000",d:"the amount a miner get rewarded for mining a block"},difficultyBombDelay:{v:3e6,d:"the amount of blocks to delay the difficulty bomb with"}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/byzantium.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/chainstart.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"chainstart",comment:"Start of the Ethereum main chain",url:"",status:"",gasConfig:{minGasLimit:{v:5e3,d:"Minimum the gas limit may ever be"},gasLimitBoundDivisor:{v:1024,d:"The bound divisor of the gas limit, used in update calculations"},maxRefundQuotient:{v:2,d:"Maximum refund quotient; max tx refund is min(tx.gasUsed/maxRefundQuotient, tx.gasRefund)"}},gasPrices:{base:{v:2,d:"Gas base cost, used e.g. for ChainID opcode (Istanbul)"},tierStep:{v:[0,2,3,5,8,10,20],d:"Once per operation, for a selection of them"},exp:{v:10,d:"Base fee of the EXP opcode"},expByte:{v:10,d:"Times ceil(log256(exponent)) for the EXP instruction"},sha3:{v:30,d:"Base fee of the SHA3 opcode"},sha3Word:{v:6,d:"Once per word of the SHA3 operation's data"},sload:{v:50,d:"Base fee of the SLOAD opcode"},sstoreSet:{v:2e4,d:"Once per SSTORE operation if the zeroness changes from zero"},sstoreReset:{v:5e3,d:"Once per SSTORE operation if the zeroness does not change from zero"},sstoreRefund:{v:15e3,d:"Once per SSTORE operation if the zeroness changes to zero"},jumpdest:{v:1,d:"Base fee of the JUMPDEST opcode"},log:{v:375,d:"Base fee of the LOG opcode"},logData:{v:8,d:"Per byte in a LOG* operation's data"},logTopic:{v:375,d:"Multiplied by the * of the LOG*, per LOG transaction. e.g. LOG0 incurs 0 * c_txLogTopicGas, LOG4 incurs 4 * c_txLogTopicGas"},create:{v:32e3,d:"Base fee of the CREATE opcode"},call:{v:40,d:"Base fee of the CALL opcode"},callStipend:{v:2300,d:"Free gas given at beginning of call"},callValueTransfer:{v:9e3,d:"Paid for CALL when the value transfor is non-zero"},callNewAccount:{v:25e3,d:"Paid for CALL when the destination address didn't exist prior"},selfdestructRefund:{v:24e3,d:"Refunded following a selfdestruct operation"},memory:{v:3,d:"Times the address of the (highest referenced byte in memory + 1). NOTE: referencing happens on read, write and in instructions such as RETURN and CALL"},quadCoeffDiv:{v:512,d:"Divisor for the quadratic particle of the memory cost equation"},createData:{v:200,d:""},tx:{v:21e3,d:"Per transaction. NOTE: Not payable on data of calls between transactions"},txCreation:{v:32e3,d:"The cost of creating a contract via tx"},txDataZero:{v:4,d:"Per byte of data attached to a transaction that equals zero. NOTE: Not payable on data of calls between transactions"},txDataNonZero:{v:68,d:"Per byte of data attached to a transaction that is not equal to zero. NOTE: Not payable on data of calls between transactions"},copy:{v:3,d:"Multiplied by the number of 32-byte words that are copied (round up) for any *COPY operation and added"},ecRecover:{v:3e3,d:""},sha256:{v:60,d:""},sha256Word:{v:12,d:""},ripemd160:{v:600,d:""},ripemd160Word:{v:120,d:""},identity:{v:15,d:""},identityWord:{v:3,d:""},stop:{v:0,d:"Base fee of the STOP opcode"},add:{v:3,d:"Base fee of the ADD opcode"},mul:{v:5,d:"Base fee of the MUL opcode"},sub:{v:3,d:"Base fee of the SUB opcode"},div:{v:5,d:"Base fee of the DIV opcode"},sdiv:{v:5,d:"Base fee of the SDIV opcode"},mod:{v:5,d:"Base fee of the MOD opcode"},smod:{v:5,d:"Base fee of the SMOD opcode"},addmod:{v:8,d:"Base fee of the ADDMOD opcode"},mulmod:{v:8,d:"Base fee of the MULMOD opcode"},signextend:{v:5,d:"Base fee of the SIGNEXTEND opcode"},lt:{v:3,d:"Base fee of the LT opcode"},gt:{v:3,d:"Base fee of the GT opcode"},slt:{v:3,d:"Base fee of the SLT opcode"},sgt:{v:3,d:"Base fee of the SGT opcode"},eq:{v:3,d:"Base fee of the EQ opcode"},iszero:{v:3,d:"Base fee of the ISZERO opcode"},and:{v:3,d:"Base fee of the AND opcode"},or:{v:3,d:"Base fee of the OR opcode"},xor:{v:3,d:"Base fee of the XOR opcode"},not:{v:3,d:"Base fee of the NOT opcode"},byte:{v:3,d:"Base fee of the BYTE opcode"},address:{v:2,d:"Base fee of the ADDRESS opcode"},balance:{v:20,d:"Base fee of the BALANCE opcode"},origin:{v:2,d:"Base fee of the ORIGIN opcode"},caller:{v:2,d:"Base fee of the CALLER opcode"},callvalue:{v:2,d:"Base fee of the CALLVALUE opcode"},calldataload:{v:3,d:"Base fee of the CALLDATALOAD opcode"},calldatasize:{v:2,d:"Base fee of the CALLDATASIZE opcode"},calldatacopy:{v:3,d:"Base fee of the CALLDATACOPY opcode"},codesize:{v:2,d:"Base fee of the CODESIZE opcode"},codecopy:{v:3,d:"Base fee of the CODECOPY opcode"},gasprice:{v:2,d:"Base fee of the GASPRICE opcode"},extcodesize:{v:20,d:"Base fee of the EXTCODESIZE opcode"},extcodecopy:{v:20,d:"Base fee of the EXTCODECOPY opcode"},blockhash:{v:20,d:"Base fee of the BLOCKHASH opcode"},coinbase:{v:2,d:"Base fee of the COINBASE opcode"},timestamp:{v:2,d:"Base fee of the TIMESTAMP opcode"},number:{v:2,d:"Base fee of the NUMBER opcode"},difficulty:{v:2,d:"Base fee of the DIFFICULTY opcode"},gaslimit:{v:2,d:"Base fee of the GASLIMIT opcode"},pop:{v:2,d:"Base fee of the POP opcode"},mload:{v:3,d:"Base fee of the MLOAD opcode"},mstore:{v:3,d:"Base fee of the MSTORE opcode"},mstore8:{v:3,d:"Base fee of the MSTORE8 opcode"},sstore:{v:0,d:"Base fee of the SSTORE opcode"},jump:{v:8,d:"Base fee of the JUMP opcode"},jumpi:{v:10,d:"Base fee of the JUMPI opcode"},pc:{v:2,d:"Base fee of the PC opcode"},msize:{v:2,d:"Base fee of the MSIZE opcode"},gas:{v:2,d:"Base fee of the GAS opcode"},push:{v:3,d:"Base fee of the PUSH opcode"},dup:{v:3,d:"Base fee of the DUP opcode"},swap:{v:3,d:"Base fee of the SWAP opcode"},callcode:{v:40,d:"Base fee of the CALLCODE opcode"},return:{v:0,d:"Base fee of the RETURN opcode"},invalid:{v:0,d:"Base fee of the INVALID opcode"},selfdestruct:{v:0,d:"Base fee of the SELFDESTRUCT opcode"}},vm:{stackLimit:{v:1024,d:"Maximum size of VM stack allowed"},callCreateDepth:{v:1024,d:"Maximum depth of call/create stack"},maxExtraDataSize:{v:32,d:"Maximum size extra data may be after Genesis"}},pow:{minimumDifficulty:{v:131072,d:"The minimum that the difficulty may ever be"},difficultyBoundDivisor:{v:2048,d:"The bound divisor of the difficulty, used in the update calculations"},durationLimit:{v:13,d:"The decision boundary on the blocktime duration used to determine whether difficulty should go up or not"},epochDuration:{v:3e4,d:"Duration between proof-of-work epochs"},timebombPeriod:{v:1e5,d:"Exponential difficulty timebomb period"},minerReward:{v:"5000000000000000000",d:"the amount a miner get rewarded for mining a block"},difficultyBombDelay:{v:0,d:"the amount of blocks to delay the difficulty bomb with"}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/chainstart.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/constantinople.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"constantinople",comment:"Postponed hardfork including EIP-1283 (SSTORE gas metering changes)",url:"https://eips.ethereum.org/EIPS/eip-1013",status:"Final",gasConfig:{},gasPrices:{netSstoreNoopGas:{v:200,d:"Once per SSTORE operation if the value doesn't change"},netSstoreInitGas:{v:2e4,d:"Once per SSTORE operation from clean zero"},netSstoreCleanGas:{v:5e3,d:"Once per SSTORE operation from clean non-zero"},netSstoreDirtyGas:{v:200,d:"Once per SSTORE operation from dirty"},netSstoreClearRefund:{v:15e3,d:"Once per SSTORE operation for clearing an originally existing storage slot"},netSstoreResetRefund:{v:4800,d:"Once per SSTORE operation for resetting to the original non-zero value"},netSstoreResetClearRefund:{v:19800,d:"Once per SSTORE operation for resetting to the original zero value"},shl:{v:3,d:"Base fee of the SHL opcode"},shr:{v:3,d:"Base fee of the SHR opcode"},sar:{v:3,d:"Base fee of the SAR opcode"},extcodehash:{v:400,d:"Base fee of the EXTCODEHASH opcode"},create2:{v:32e3,d:"Base fee of the CREATE2 opcode"}},vm:{},pow:{minerReward:{v:"2000000000000000000",d:"The amount a miner gets rewarded for mining a block"},difficultyBombDelay:{v:5e6,d:"the amount of blocks to delay the difficulty bomb with"}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/constantinople.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/dao.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"dao",comment:"DAO rescue hardfork",url:"https://eips.ethereum.org/EIPS/eip-779",status:"Final",gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/dao.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/grayGlacier.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"grayGlacier",comment:"Delaying the difficulty bomb to Mid September 2022",url:"https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/gray-glacier.md",status:"Draft",eips:[5133],gasConfig:{},gasPrices:{},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/grayGlacier.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/homestead.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"homestead",comment:"Homestead hardfork with protocol and network changes",url:"https://eips.ethereum.org/EIPS/eip-606",status:"Final",gasConfig:{},gasPrices:{delegatecall:{v:40,d:"Base fee of the DELEGATECALL opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/homestead.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/index.js",{"./arrowGlacier.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/arrowGlacier.json","./berlin.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/berlin.json","./byzantium.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/byzantium.json","./chainstart.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/chainstart.json","./constantinople.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/constantinople.json","./dao.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/dao.json","./grayGlacier.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/grayGlacier.json","./homestead.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/homestead.json","./istanbul.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/istanbul.json","./london.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/london.json","./merge.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/merge.json","./mergeForkIdTransition.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/mergeForkIdTransition.json","./muirGlacier.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/muirGlacier.json","./petersburg.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/petersburg.json","./shanghai.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/shanghai.json","./sharding.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/sharding.json","./spuriousDragon.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/spuriousDragon.json","./tangerineWhistle.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/tangerineWhistle.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.hardforks=void 0,n.hardforks={chainstart:e("./chainstart.json"),homestead:e("./homestead.json"),dao:e("./dao.json"),tangerineWhistle:e("./tangerineWhistle.json"),spuriousDragon:e("./spuriousDragon.json"),byzantium:e("./byzantium.json"),constantinople:e("./constantinople.json"),petersburg:e("./petersburg.json"),istanbul:e("./istanbul.json"),muirGlacier:e("./muirGlacier.json"),berlin:e("./berlin.json"),london:e("./london.json"),shanghai:e("./shanghai.json"),arrowGlacier:e("./arrowGlacier.json"),grayGlacier:e("./grayGlacier.json"),mergeForkIdTransition:e("./mergeForkIdTransition.json"),merge:e("./merge.json"),shardingFork:e("./sharding.json")}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/istanbul.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"istanbul",comment:"HF targeted for December 2019 following the Constantinople/Petersburg HF",url:"https://eips.ethereum.org/EIPS/eip-1679",status:"Final",gasConfig:{},gasPrices:{blake2Round:{v:1,d:"Gas cost per round for the Blake2 F precompile"},ecAdd:{v:150,d:"Gas costs for curve addition precompile"},ecMul:{v:6e3,d:"Gas costs for curve multiplication precompile"},ecPairing:{v:45e3,d:"Base gas costs for curve pairing precompile"},ecPairingWord:{v:34e3,d:"Gas costs regarding curve pairing precompile input length"},txDataNonZero:{v:16,d:"Per byte of data attached to a transaction that is not equal to zero. NOTE: Not payable on data of calls between transactions"},sstoreSentryGasEIP2200:{v:2300,d:"Minimum gas required to be present for an SSTORE call, not consumed"},sstoreNoopGasEIP2200:{v:800,d:"Once per SSTORE operation if the value doesn't change"},sstoreDirtyGasEIP2200:{v:800,d:"Once per SSTORE operation if a dirty value is changed"},sstoreInitGasEIP2200:{v:2e4,d:"Once per SSTORE operation from clean zero to non-zero"},sstoreInitRefundEIP2200:{v:19200,d:"Once per SSTORE operation for resetting to the original zero value"},sstoreCleanGasEIP2200:{v:5e3,d:"Once per SSTORE operation from clean non-zero to something else"},sstoreCleanRefundEIP2200:{v:4200,d:"Once per SSTORE operation for resetting to the original non-zero value"},sstoreClearRefundEIP2200:{v:15e3,d:"Once per SSTORE operation for clearing an originally existing storage slot"},balance:{v:700,d:"Base fee of the BALANCE opcode"},extcodehash:{v:700,d:"Base fee of the EXTCODEHASH opcode"},chainid:{v:2,d:"Base fee of the CHAINID opcode"},selfbalance:{v:5,d:"Base fee of the SELFBALANCE opcode"},sload:{v:800,d:"Base fee of the SLOAD opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/istanbul.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/london.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"london",comment:"HF targeted for July 2021 following the Berlin fork",url:"https://github.com/ethereum/eth1.0-specs/blob/master/network-upgrades/mainnet-upgrades/london.md",status:"Final",eips:[1559,3198,3529,3541]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/london.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/merge.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"merge",comment:"Hardfork to upgrade the consensus mechanism to Proof-of-Stake",url:"https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/merge.md",status:"Final",consensus:{type:"pos",algorithm:"casper",casper:{}},eips:[3675,4399]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/merge.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/mergeForkIdTransition.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"mergeForkIdTransition",comment:"Pre-merge hardfork to fork off non-upgraded clients",url:"https://eips.ethereum.org/EIPS/eip-3675",status:"Draft",eips:[]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/mergeForkIdTransition.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/muirGlacier.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"muirGlacier",comment:"HF to delay the difficulty bomb",url:"https://eips.ethereum.org/EIPS/eip-2384",status:"Final",gasConfig:{},gasPrices:{},vm:{},pow:{difficultyBombDelay:{v:9e6,d:"the amount of blocks to delay the difficulty bomb with"}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/muirGlacier.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/petersburg.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"petersburg",comment:"Aka constantinopleFix, removes EIP-1283, activate together with or after constantinople",url:"https://eips.ethereum.org/EIPS/eip-1716",status:"Final",gasConfig:{},gasPrices:{netSstoreNoopGas:{v:null,d:"Removed along EIP-1283"},netSstoreInitGas:{v:null,d:"Removed along EIP-1283"},netSstoreCleanGas:{v:null,d:"Removed along EIP-1283"},netSstoreDirtyGas:{v:null,d:"Removed along EIP-1283"},netSstoreClearRefund:{v:null,d:"Removed along EIP-1283"},netSstoreResetRefund:{v:null,d:"Removed along EIP-1283"},netSstoreResetClearRefund:{v:null,d:"Removed along EIP-1283"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/petersburg.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/shanghai.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"shanghai",comment:"Next feature hardfork after the merge hardfork having withdrawals, warm coinbase, push0, limit/meter initcode",url:"https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/shanghai.md",status:"Final",eips:[3651,3855,3860,4895]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/shanghai.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/sharding.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"shardingFork",comment:"Internal hardfork to test proto-danksharding (do not use in production)",url:"https://eips.ethereum.org/EIPS/eip-4844",status:"Experimental",eips:[4844]}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/sharding.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/spuriousDragon.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"spuriousDragon",comment:"HF with EIPs for simple replay attack protection, EXP cost increase, state trie clearing, contract code size limit",url:"https://eips.ethereum.org/EIPS/eip-607",status:"Final",gasConfig:{},gasPrices:{expByte:{v:50,d:"Times ceil(log256(exponent)) for the EXP instruction"}},vm:{maxCodeSize:{v:24576,d:"Maximum length of contract code"}},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/spuriousDragon.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/tangerineWhistle.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={name:"tangerineWhistle",comment:"Hardfork with gas cost changes for IO-heavy operations",url:"https://eips.ethereum.org/EIPS/eip-608",status:"Final",gasConfig:{},gasPrices:{sload:{v:200,d:"Once per SLOAD operation"},call:{v:700,d:"Once per CALL operation & message call transaction"},extcodesize:{v:700,d:"Base fee of the EXTCODESIZE opcode"},extcodecopy:{v:700,d:"Base fee of the EXTCODECOPY opcode"},balance:{v:400,d:"Base fee of the BALANCE opcode"},delegatecall:{v:700,d:"Base fee of the DELEGATECALL opcode"},callcode:{v:700,d:"Base fee of the CALLCODE opcode"},selfdestruct:{v:5e3,d:"Base fee of the SELFDESTRUCT opcode"}},vm:{},pow:{}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/hardforks/tangerineWhistle.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/index.js",{"./common":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/common.js","./enums":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/enums.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/types.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./common"),n),s(e("./enums"),n),s(e("./types"),n),s(e("./utils"),n)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/types.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/utils.js",{"./enums":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/enums.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.parseGethGenesis=void 0;const r=e("@ethereumjs/util"),s=e("./enums");function o(e,t=!0){const{name:n,config:o,difficulty:i,mixHash:a,gasLimit:f,coinbase:u,baseFeePerGas:l}=e;let{extraData:d,timestamp:c,nonce:m}=e;const h=Number(c),{chainId:b}=o;if(""===d&&(d="0x"),(0,r.isHexPrefixed)(c)||(c=(0,r.intToHex)(parseInt(c))),18!==m.length&&(m=function(e){return e&&"0x0"!==e?(0,r.isHexPrefixed)(e)?"0x"+(0,r.stripHexPrefix)(e).padStart(16,"0"):"0x"+e.padStart(16,"0"):"0x0000000000000000"}(m)),o.eip155Block!==o.eip158Block)throw new Error("EIP155 block number must equal EIP 158 block number since both are part of SpuriousDragon hardfork and the client only supports activating the full hardfork");const p={name:n,chainId:b,networkId:b,genesis:{timestamp:c,gasLimit:parseInt(f),difficulty:parseInt(i),nonce:m,extraData:d,mixHash:a,coinbase:u,baseFeePerGas:l},hardfork:undefined,hardforks:[],bootstrapNodes:[],consensus:o.clique!==undefined?{type:"poa",algorithm:"clique",clique:{period:o.clique.period??o.clique.blockperiodseconds,epoch:o.clique.epoch??o.clique.epochlength}}:{type:"pow",algorithm:"ethash",ethash:{}}},k={[s.Hardfork.Homestead]:{name:"homesteadBlock"},[s.Hardfork.Dao]:{name:"daoForkBlock"},[s.Hardfork.TangerineWhistle]:{name:"eip150Block"},[s.Hardfork.SpuriousDragon]:{name:"eip155Block"},[s.Hardfork.Byzantium]:{name:"byzantiumBlock"},[s.Hardfork.Constantinople]:{name:"constantinopleBlock"},[s.Hardfork.Petersburg]:{name:"petersburgBlock"},[s.Hardfork.Istanbul]:{name:"istanbulBlock"},[s.Hardfork.MuirGlacier]:{name:"muirGlacierBlock"},[s.Hardfork.Berlin]:{name:"berlinBlock"},[s.Hardfork.London]:{name:"londonBlock"},[s.Hardfork.MergeForkIdTransition]:{name:"mergeForkBlock",postMerge:t},[s.Hardfork.Shanghai]:{name:"shanghaiTime",postMerge:!0,isTimestamp:!0},[s.Hardfork.ShardingForkDev]:{name:"shardingForkTime",postMerge:!0,isTimestamp:!0}},x=Object.keys(k).reduce((e,t)=>(e[k[t].name]=t,e),{}),j=Object.keys(o).filter(e=>x[e]!==undefined&&o[e]!==undefined&&null!==o[e]);if(p.hardforks=j.map(e=>({name:x[e],block:!0===k[x[e]].isTimestamp||"number"!=typeof o[e]?null:o[e],timestamp:!0===k[x[e]].isTimestamp&&"number"==typeof o[e]?o[e]:undefined})).filter(e=>null!==e.block||e.timestamp!==undefined),p.hardforks.sort(function(e,t){return(e.block??Infinity)-(t.block??Infinity)}),p.hardforks.sort(function(e,t){return(e.timestamp??h)-(t.timestamp??h)}),o.terminalTotalDifficulty!==undefined){const e={name:s.Hardfork.Merge,ttd:o.terminalTotalDifficulty,block:null},t=p.hardforks.findIndex(e=>!0===k[e.name]?.postMerge);-1!==t?p.hardforks.splice(t,0,e):p.hardforks.push(e)}const w=p.hardforks.length>0?p.hardforks.slice(-1)[0]:undefined;return p.hardfork=w?.name,p.hardforks.unshift({name:s.Hardfork.Chainstart,block:0}),p}n.parseGethGenesis=function(e,t,n){try{if(["config","difficulty","gasLimit","alloc"].some(t=>!(t in e)))throw new Error("Invalid format, expected geth genesis fields missing");return t!==undefined&&(e.name=t),o(e,n)}catch(e){throw new Error(`Error parsing parameters file: ${e.message}`)}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/common/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/rlp/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(Array.isArray(e)){const t=[];let n=0;for(let s=0;s<e.length;s++){const o=r(e[s]);t.push(o),n+=o.length}return m(i(n,192),...t)}const t=k(e);return 1===t.length&&t[0]<128?t:m(i(t.length,128),t)}function s(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function o(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return d(l(e))}function i(e,t){if(e<56)return Uint8Array.from([e+t]);const n=b(e),r=b(t+55+n.length/2);return Uint8Array.from(c(r+n))}function a(e,t=!1){if(null==e||0===e.length)return Uint8Array.from([]);const n=f(k(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function f(e){let t,n,r,i,a;const u=[],l=e[0];if(l<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(l<=183){if(t=l-127,r=128===l?Uint8Array.from([]):s(e,1,t),2===t&&r[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:r,remainder:e.slice(t)}}if(l<=191){if(n=l-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=o(s(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return r=s(e,n,t+n),{data:r,remainder:e.slice(t+n)}}if(l<=247){for(t=l-191,i=s(e,1,t);i.length;)a=f(i),u.push(a.data),i=a.remainder;return{data:u,remainder:e.slice(t)}}{if(n=l-246,t=o(s(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const r=n+t;if(r>e.length)throw new Error("invalid RLP: total length is larger than the data");for(i=s(e,n,r);i.length;)a=f(i),u.push(a.data),i=a.remainder;return{data:u,remainder:e.slice(r)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.RLP=n.utils=n.decode=n.encode=void 0,n.encode=r,n.decode=a;const u=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function l(e){let t="";for(let n=0;n<e.length;n++)t+=u[e[n]];return t}function d(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function c(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const r=2*n;t[n]=d(e.slice(r,r+2))}return t}function m(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,r=0;t<e.length;t++){const s=e[t];n.set(s,r),r+=s.length}return n}function h(e){return(new TextEncoder).encode(e)}function b(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function p(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function k(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return p(e)?c((t="string"!=typeof(n=e)?n:p(n)?n.slice(2):n).length%2?`0${t}`:t):h(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?c(b(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:l,concatBytes:m,hexToBytes:c,utf8ToBytes:h},n.RLP={encode:r,decode:a}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util>@ethereumjs/rlp",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/rlp/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.accountBodyToRLP=n.accountBodyToSlim=n.accountBodyFromSlim=n.isZeroAddress=n.zeroAddress=n.importPublic=n.privateToAddress=n.privateToPublic=n.publicToAddress=n.pubToAddress=n.isValidPublic=n.isValidPrivate=n.generateAddress2=n.generateAddress=n.isValidChecksumAddress=n.toChecksumAddress=n.isValidAddress=n.Account=void 0;const r=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),o=e("ethereum-cryptography/secp256k1"),i=e("ethereum-cryptography/utils"),a=e("./bytes"),f=e("./constants"),u=e("./helpers"),l=e("./internal"),d=BigInt(0);class c{constructor(e=d,t=d,n=f.KECCAK256_RLP,r=f.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=n,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:n,storageRoot:r,codeHash:s}=e;return new c(t!==undefined?(0,a.bufferToBigInt)((0,a.toBuffer)(t)):undefined,n!==undefined?(0,a.bufferToBigInt)((0,a.toBuffer)(n)):undefined,r!==undefined?(0,a.toBuffer)(r):undefined,s!==undefined?(0,a.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,a.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,n,r,s]=e;return new c((0,a.bufferToBigInt)(t),(0,a.bufferToBigInt)(n),r,s)}_validate(){if(this.nonce<d)throw new Error("nonce must be greater than zero");if(this.balance<d)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,a.bigIntToUnpaddedBuffer)(this.nonce),(0,a.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,a.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(f.KECCAK256_NULL)}isEmpty(){return this.balance===d&&this.nonce===d&&this.codeHash.equals(f.KECCAK256_NULL)}}n.Account=c;n.isValidAddress=function(e){try{(0,u.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};n.toChecksumAddress=function(e,n){(0,u.assertIsHexString)(e);const r=(0,l.stripHexPrefix)(e).toLowerCase();let o="";if(n!==undefined){o=(0,a.bufferToBigInt)((0,a.toBuffer)(n)).toString()+"0x"}const f=t.from(o+r,"utf8"),d=(0,i.bytesToHex)((0,s.keccak256)(f));let c="0x";for(let e=0;e<r.length;e++)parseInt(d[e],16)>=8?c+=r[e].toUpperCase():c+=r[e];return c};n.isValidChecksumAddress=function(e,t){return(0,n.isValidAddress)(e)&&(0,n.toChecksumAddress)(e,t)===e};n.generateAddress=function(e,n){return(0,u.assertIsBuffer)(e),(0,u.assertIsBuffer)(n),(0,a.bufferToBigInt)(n)===BigInt(0)?t.from((0,s.keccak256)(r.RLP.encode((0,a.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(r.RLP.encode((0,a.bufArrToArr)([e,n])))).slice(-20)};n.generateAddress2=function(e,n,r){if((0,u.assertIsBuffer)(e),(0,u.assertIsBuffer)(n),(0,u.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==n.length)throw new Error("Expected salt to be of length 32");const o=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,n,(0,s.keccak256)(r)]));return(0,a.toBuffer)(o).slice(-20)};n.isValidPrivate=function(e){return o.secp256k1.utils.isValidPrivateKey(e)};n.isValidPublic=function(e,n=!1){if((0,u.assertIsBuffer)(e),64===e.length)try{return o.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!n)return!1;try{return o.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};n.pubToAddress=function(e,n=!1){if((0,u.assertIsBuffer)(e),n&&64!==e.length&&(e=t.from(o.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},n.publicToAddress=n.pubToAddress;n.privateToPublic=function(e){return(0,u.assertIsBuffer)(e),t.from(o.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};n.privateToAddress=function(e){return(0,n.publicToAddress)((0,n.privateToPublic)(e))};n.importPublic=function(e){return(0,u.assertIsBuffer)(e),64!==e.length&&(e=t.from(o.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};n.zeroAddress=function(){const e=(0,a.zeros)(20);return(0,a.bufferToHex)(e)};function m(e){const[t,n,r,s]=e;return[t,n,0===(0,a.arrToBufArr)(r).length?f.KECCAK256_RLP:r,0===(0,a.arrToBufArr)(s).length?f.KECCAK256_NULL:s]}n.isZeroAddress=function(e){try{(0,u.assertIsString)(e)}catch(e){return!1}return(0,n.zeroAddress)()===e},n.accountBodyFromSlim=m;const h=new Uint8Array(0);n.accountBodyToSlim=function(e){const[t,n,r,s]=e;return[t,n,(0,a.arrToBufArr)(r).equals(f.KECCAK256_RLP)?h:r,(0,a.arrToBufArr)(s).equals(f.KECCAK256_NULL)?h:s]},n.accountBodyToRLP=function(e,t=!0){const n=t?m(e):e;return(0,a.arrToBufArr)(r.RLP.encode(n))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Address=void 0;const r=e("./account"),s=e("./bytes");class o{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new o((0,s.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new o((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const n=(0,r.pubToAddress)(e);return new o(n)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const n=(0,r.privateToAddress)(e);return new o(n)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new o((0,r.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,n,s){if(!t.isBuffer(n))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new o((0,r.generateAddress2)(e.buf,n,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(o.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),n=BigInt("0xffff");return e>=t&&e<=n}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}n.Address=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncEventEmitter=void 0;const r=e("events");class s extends r.EventEmitter{emit(e,...t){let[n,r]=t;const s=this;let o=s._events[e]??[];return r===undefined&&"function"==typeof n&&(r=n,n=undefined),"newListener"!==e&&"removeListener"!==e||(n={event:n,fn:r},r=undefined),o=Array.isArray(o)?o:[o],async function(e,t,n){let r;for await(const s of t)try{s.length<2?s.call(e,n):await new Promise((t,r)=>{s.call(e,n,e=>{e?r(e):t()})})}catch(e){r=e}if(r)throw r}(s,o.slice(),n).then(r).catch(r),s.listenerCount(e)>0}once(e,t){const n=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(s,o){n.removeListener(e,r),t(s,o)}:function(s){n.removeListener(e,r),t(s,r)},n.on(e,r),n}first(e,t){let n=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(n)||(this._events[e]=n=[n]),n.unshift(t),this}before(e,t,n){return this.beforeOrAfter(e,t,n)}after(e,t,n){return this.beforeOrAfter(e,t,n,"after")}beforeOrAfter(e,t,n,r){let s,o,i=this._events[e]??[];const a="after"===r?1:0;if("function"!=typeof n)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(i)||(this._events[e]=i=[i]),o=i.length,s=i.length;s--;)if(i[s]===t){o=s+a;break}return i.splice(o,0,n),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}n.AsyncEventEmitter=s}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.intToUnpaddedBuffer=n.bigIntToUnpaddedBuffer=n.bigIntToHex=n.bufArrToArr=n.arrToBufArr=n.validateNoLeadingZeroes=n.baToJSON=n.toUtf8=n.short=n.addHexPrefix=n.toUnsigned=n.fromSigned=n.bufferToInt=n.bigIntToBuffer=n.bufferToBigInt=n.bufferToHex=n.toBuffer=n.unpadHexString=n.unpadArray=n.unpadBuffer=n.setLengthRight=n.setLengthLeft=n.zeros=n.intToBuffer=n.intToHex=void 0;const r=e("./helpers"),s=e("./internal");n.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};n.intToBuffer=function(e){const r=(0,n.intToHex)(e);return t.from((0,s.padToEven)(r.slice(2)),"hex")};n.zeros=function(e){return t.allocUnsafe(e).fill(0)};const o=function(e,t,r){const s=(0,n.zeros)(t);return r?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};n.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),o(e,t,!1)};n.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),o(e,t,!0)};const i=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};n.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),i(e)};n.unpadArray=function(e){return(0,r.assertIsArray)(e),i(e)};n.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+i(e)};n.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,n.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let n=e.toString(16);return n.length%2&&(n="0"+n),t.from(n,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function a(e){const t=(0,n.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function f(e){return(0,n.toBuffer)("0x"+e.toString(16))}n.bufferToHex=function(e){return"0x"+(e=(0,n.toBuffer)(e)).toString("hex")},n.bufferToBigInt=a,n.bigIntToBuffer=f;n.bufferToInt=function(e){const t=Number(a(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};n.fromSigned=function(e){return BigInt.asIntN(256,a(e))};n.toUnsigned=function(e){return f(BigInt.asUintN(256,e))};n.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},n.short=function(e,n=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=n?r:r.slice(0,n)+"…"};n.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};n.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,n.baToJSON)(e[r]));return t}};n.validateNoLeadingZeroes=function(e){for(const[t,n]of Object.entries(e))if(n!==undefined&&n.length>0&&0===n[0])throw new Error(`${t} cannot have leading zeroes, received: ${n.toString("hex")}`)},n.arrToBufArr=function e(n){return Array.isArray(n)?n.map(t=>e(t)):t.from(n)},n.bufArrToArr=function e(t){return Array.isArray(t)?t.map(t=>e(t)):Uint8Array.from(t??[])};n.bigIntToHex=e=>"0x"+e.toString(16),n.bigIntToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)(f(e))},n.intToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)((0,n.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAX_WITHDRAWALS_PER_PAYLOAD=n.RLP_EMPTY_STRING=n.KECCAK256_RLP=n.KECCAK256_RLP_S=n.KECCAK256_RLP_ARRAY=n.KECCAK256_RLP_ARRAY_S=n.KECCAK256_NULL=n.KECCAK256_NULL_S=n.TWO_POW256=n.SECP256K1_ORDER_DIV_2=n.SECP256K1_ORDER=n.MAX_INTEGER_BIGINT=n.MAX_INTEGER=n.MAX_UINT64=void 0;const r=e("buffer"),s=e("ethereum-cryptography/secp256k1");n.MAX_UINT64=BigInt("0xffffffffffffffff"),n.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),n.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),n.SECP256K1_ORDER=s.secp256k1.CURVE.n,n.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),n.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),n.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",n.KECCAK256_NULL=r.Buffer.from(n.KECCAK256_NULL_S,"hex"),n.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",n.KECCAK256_RLP_ARRAY=r.Buffer.from(n.KECCAK256_RLP_ARRAY_S,"hex"),n.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",n.KECCAK256_RLP=r.Buffer.from(n.KECCAK256_RLP_S,"hex"),n.RLP_EMPTY_STRING=r.Buffer.from([128]),n.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compactBytesToNibbles=n.bytesToNibbles=n.nibblesToCompactBytes=n.nibblesToBytes=n.hasTerminator=void 0;n.hasTerminator=e=>e.length>0&&16===e[e.length-1];n.nibblesToBytes=(e,t)=>{for(let n=0,r=0;r<e.length;n+=1,r+=2)t[n]=e[r]<<4|e[r+1]};n.nibblesToCompactBytes=e=>{let t=0;(0,n.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,n.nibblesToBytes)(e,r.subarray(1)),r};n.bytesToNibbles=e=>{const t=2*e.length+1,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];n[2*t]=r/16,n[2*t+1]=r%16}return n[t-1]=16,n};n.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,n.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.assertIsString=n.assertIsArray=n.assertIsBuffer=n.assertIsHexString=void 0;const r=e("./internal");n.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};n.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};n.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};n.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../is-buffer/index.js")})}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.toAscii=n.stripHexPrefix=n.padToEven=n.isHexString=n.isHexPrefixed=n.getKeys=n.getBinarySize=n.fromUtf8=n.fromAscii=n.arrayContainsArray=void 0,s(e("./constants"),n),s(e("./units"),n),s(e("./account"),n),s(e("./address"),n),s(e("./withdrawal"),n),s(e("./signature"),n),s(e("./bytes"),n),s(e("./types"),n),s(e("./encoding"),n),s(e("./asyncEventEmitter"),n);var o=e("./internal");Object.defineProperty(n,"arrayContainsArray",{enumerable:!0,get:function(){return o.arrayContainsArray}}),Object.defineProperty(n,"fromAscii",{enumerable:!0,get:function(){return o.fromAscii}}),Object.defineProperty(n,"fromUtf8",{enumerable:!0,get:function(){return o.fromUtf8}}),Object.defineProperty(n,"getBinarySize",{enumerable:!0,get:function(){return o.getBinarySize}}),Object.defineProperty(n,"getKeys",{enumerable:!0,get:function(){return o.getKeys}}),Object.defineProperty(n,"isHexPrefixed",{enumerable:!0,get:function(){return o.isHexPrefixed}}),Object.defineProperty(n,"isHexString",{enumerable:!0,get:function(){return o.isHexString}}),Object.defineProperty(n,"padToEven",{enumerable:!0,get:function(){return o.padToEven}}),Object.defineProperty(n,"stripHexPrefix",{enumerable:!0,get:function(){return o.stripHexPrefix}}),Object.defineProperty(n,"toAscii",{enumerable:!0,get:function(){return o.toAscii}}),s(e("./lock"),n),s(e("./provider"),n)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(n,"__esModule",{value:!0}),n.isHexString=n.getKeys=n.fromAscii=n.fromUtf8=n.toAscii=n.arrayContainsArray=n.getBinarySize=n.padToEven=n.stripHexPrefix=n.isHexPrefixed=void 0,n.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}n.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},n.padToEven=r,n.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},n.arrayContainsArray=function(e,t,n){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===n?"some":"every"](t=>e.indexOf(t)>=0)},n.toAscii=function(e){let t="",n=0;const r=e.length;for("0x"===e.substring(0,2)&&(n=2);n<r;n+=2){const r=parseInt(e.substr(n,2),16);t+=String.fromCharCode(r)}return t},n.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},n.fromAscii=function(e){let t="";for(let n=0;n<e.length;n++){const r=e.charCodeAt(n).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},n.getKeys=function(e,t,n){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let s=0;s<e.length;s++){let o=e[s][t];if(!0!==n||o){if("string"!=typeof o)throw new Error("invalid abi - expected type 'string', received "+typeof o)}else o="";r.push(o)}return r},n.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Lock=void 0;n.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise(e=>this.promiseResolverQueue.push(e))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getProvider=n.fetchFromProvider=void 0;const r=e("micro-ftch");n.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;n.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashPersonalMessage=n.isValidSignature=n.fromRpcSig=n.toCompactSig=n.toRpcSig=n.ecrecover=n.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),o=e("./bytes"),i=e("./constants"),a=e("./helpers");function f(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function u(e){return e===BigInt(0)||e===BigInt(1)}n.ecsign=function(e,n,r){const o=s.secp256k1.sign(e,n),i=o.toCompactRawBytes();return{r:t.from(i.slice(0,32)),s:t.from(i.slice(32,64)),v:r===undefined?BigInt(o.recovery+27):BigInt(o.recovery+35)+BigInt(r)*BigInt(2)}};n.ecrecover=function(e,n,r,i,a){const l=t.concat([(0,o.setLengthLeft)(r,32),(0,o.setLengthLeft)(i,32)],64),d=f(n,a);if(!u(d))throw new Error("Invalid signature v value");const c=s.secp256k1.Signature.fromCompact(l).addRecoveryBit(Number(d)).recoverPublicKey(e);return t.from(c.toRawBytes(!1).slice(1))};n.toRpcSig=function(e,n,r,s){if(!u(f(e,s)))throw new Error("Invalid signature v value");return(0,o.bufferToHex)(t.concat([(0,o.setLengthLeft)(n,32),(0,o.setLengthLeft)(r,32),(0,o.toBuffer)(e)]))};n.toCompactSig=function(e,n,r,s){if(!u(f(e,s)))throw new Error("Invalid signature v value");let i=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(i=t.from(r),i[0]|=128),(0,o.bufferToHex)(t.concat([(0,o.setLengthLeft)(n,32),(0,o.setLengthLeft)(i,32)]))};n.fromRpcSig=function(e){const t=(0,o.toBuffer)(e);let n,r,s;if(t.length>=65)n=t.slice(0,32),r=t.slice(32,64),s=(0,o.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");n=t.slice(0,32),r=t.slice(32,64),s=BigInt((0,o.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:n,s:r}};n.isValidSignature=function(e,t,n,r=!0,s){if(32!==t.length||32!==n.length)return!1;if(!u(f(e,s)))return!1;const a=(0,o.bufferToBigInt)(t),l=(0,o.bufferToBigInt)(n);return!(a===BigInt(0)||a>=i.SECP256K1_ORDER||l===BigInt(0)||l>=i.SECP256K1_ORDER)&&!(r&&l>=i.SECP256K1_ORDER_DIV_2)};n.hashPersonalMessage=function(e){(0,a.assertIsBuffer)(e);const n=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([n,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toType=n.TypeOutput=void 0;const r=e("./bytes"),s=e("./internal");var o;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(o=n.TypeOutput||(n.TypeOutput={})),n.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const n=(0,r.toBuffer)(e);switch(t){case o.Buffer:return n;case o.BigInt:return(0,r.bufferToBigInt)(n);case o.Number:{const e=(0,r.bufferToBigInt)(n);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case o.PrefixedHexString:return(0,r.bufferToHex)(n);default:throw new Error("unknown outputType")}}}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.GWEI_TO_WEI=void 0,n.GWEI_TO_WEI=BigInt(1e9)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Withdrawal=void 0;const r=e("./address"),s=e("./bytes"),o=e("./types");class i{constructor(e,t,n,r){this.index=e,this.validatorIndex=t,this.address=n,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:n,address:s,amount:a}=e,f=(0,o.toType)(t,o.TypeOutput.BigInt),u=(0,o.toType)(n,o.TypeOutput.BigInt),l=new r.Address((0,o.toType)(s,o.TypeOutput.Buffer)),d=(0,o.toType)(a,o.TypeOutput.BigInt);return new i(f,u,l,d)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,n,r,s]=e;return i.fromWithdrawalData({index:t,validatorIndex:n,address:r,amount:s})}static toBufferArray(e){const{index:n,validatorIndex:s,address:i,amount:a}=e,f=(0,o.toType)(n,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(n,o.TypeOutput.Buffer),u=(0,o.toType)(s,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(s,o.TypeOutput.Buffer);let l;l=i instanceof r.Address?i.buf:(0,o.toType)(i,o.TypeOutput.Buffer);return[f,u,l,(0,o.toType)(a,o.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,o.toType)(a,o.TypeOutput.Buffer)]}raw(){return i.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}n.Withdrawal=i}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules/gridplus-sdk/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/bignumber.js/bignumber.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){!function(e){var n,r=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,s=Math.ceil,o=Math.floor,i="[BigNumber Error] ",a=i+"Number primitive has more than 15 significant digits: ",f=1e14,u=14,l=9007199254740991,d=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],c=1e7,m=1e9;function h(e){var t=0|e;return e>0||e===t?t:t-1}function b(e){for(var t,n,r=1,s=e.length,o=e[0]+"";r<s;){for(t=e[r++]+"",n=u-t.length;n--;t="0"+t);o+=t}for(s=o.length;48===o.charCodeAt(--s););return o.slice(0,s+1||1)}function p(e,t){var n,r,s=e.c,o=t.c,i=e.s,a=t.s,f=e.e,u=t.e;if(!i||!a)return null;if(n=s&&!s[0],r=o&&!o[0],n||r)return n?r?0:-a:i;if(i!=a)return i;if(n=i<0,r=f==u,!s||!o)return r?0:!s^n?1:-1;if(!r)return f>u^n?1:-1;for(a=(f=s.length)<(u=o.length)?f:u,i=0;i<a;i++)if(s[i]!=o[i])return s[i]>o[i]^n?1:-1;return f==u?0:f>u^n?1:-1}function k(e,t,n,r){if(e<t||e>n||e!==o(e))throw Error(i+(r||"Argument")+("number"==typeof e?e<t||e>n?" out of range: ":" not an integer: ":" not a primitive number: ")+String(e))}function x(e){var t=e.c.length-1;return h(e.e/u)==t&&e.c[t]%2!=0}function j(e,t){return(e.length>1?e.charAt(0)+"."+e.slice(1):e)+(t<0?"e":"e+")+t}function w(e,t,n){var r,s;if(t<0){for(s=n+".";++t;s+=n);e=s+e}else if(++t>(r=e.length)){for(s=n,t-=r;--t;s+=n);e+=s}else t<r&&(e=e.slice(0,t)+"."+e.slice(t));return e}n=function e(t){var n,g,y,_,v,T,S,E,O,A,C=z.prototype={constructor:z,toString:null,valueOf:null},P=new z(1),I=20,M=4,R=-7,L=21,B=-1e7,F=1e7,N=!1,D=1,U=0,H={prefix:"",groupSize:3,secondaryGroupSize:0,groupSeparator:",",decimalSeparator:".",fractionGroupSize:0,fractionGroupSeparator:" ",suffix:""},W="0123456789abcdefghijklmnopqrstuvwxyz",G=!0;function z(e,t){var n,s,i,f,d,c,m,h,b=this;if(!(b instanceof z))return new z(e,t);if(null==t){if(e&&!0===e._isBigNumber)return b.s=e.s,void(!e.c||e.e>F?b.c=b.e=null:e.e<B?b.c=[b.e=0]:(b.e=e.e,b.c=e.c.slice()));if((c="number"==typeof e)&&0*e==0){if(b.s=1/e<0?(e=-e,-1):1,e===~~e){for(f=0,d=e;d>=10;d/=10,f++);return void(f>F?b.c=b.e=null:(b.e=f,b.c=[e]))}h=String(e)}else{if(!r.test(h=String(e)))return y(b,h,c);b.s=45==h.charCodeAt(0)?(h=h.slice(1),-1):1}(f=h.indexOf("."))>-1&&(h=h.replace(".","")),(d=h.search(/e/i))>0?(f<0&&(f=d),f+=+h.slice(d+1),h=h.substring(0,d)):f<0&&(f=h.length)}else{if(k(t,2,W.length,"Base"),10==t&&G)return Y(b=new z(e),I+b.e+1,M);if(h=String(e),c="number"==typeof e){if(0*e!=0)return y(b,h,c,t);if(b.s=1/e<0?(h=h.slice(1),-1):1,z.DEBUG&&h.replace(/^0\.0*|\./,"").length>15)throw Error(a+e)}else b.s=45===h.charCodeAt(0)?(h=h.slice(1),-1):1;for(n=W.slice(0,t),f=d=0,m=h.length;d<m;d++)if(n.indexOf(s=h.charAt(d))<0){if("."==s){if(d>f){f=m;continue}}else if(!i&&(h==h.toUpperCase()&&(h=h.toLowerCase())||h==h.toLowerCase()&&(h=h.toUpperCase()))){i=!0,d=-1,f=0;continue}return y(b,String(e),c,t)}c=!1,(f=(h=g(h,t,10,b.s)).indexOf("."))>-1?h=h.replace(".",""):f=h.length}for(d=0;48===h.charCodeAt(d);d++);for(m=h.length;48===h.charCodeAt(--m););if(h=h.slice(d,++m)){if(m-=d,c&&z.DEBUG&&m>15&&(e>l||e!==o(e)))throw Error(a+b.s*e);if((f=f-d-1)>F)b.c=b.e=null;else if(f<B)b.c=[b.e=0];else{if(b.e=f,b.c=[],d=(f+1)%u,f<0&&(d+=u),d<m){for(d&&b.c.push(+h.slice(0,d)),m-=u;d<m;)b.c.push(+h.slice(d,d+=u));d=u-(h=h.slice(d)).length}else d-=m;for(;d--;h+="0");b.c.push(+h)}}else b.c=[b.e=0]}function V(e,t,n,r){var s,o,i,a,f;if(null==n?n=M:k(n,0,8),!e.c)return e.toString();if(s=e.c[0],i=e.e,null==t)f=b(e.c),f=1==r||2==r&&(i<=R||i>=L)?j(f,i):w(f,i,"0");else if(o=(e=Y(new z(e),t,n)).e,a=(f=b(e.c)).length,1==r||2==r&&(t<=o||o<=R)){for(;a<t;f+="0",a++);f=j(f,o)}else if(t-=i,f=w(f,o,"0"),o+1>a){if(--t>0)for(f+=".";t--;f+="0");}else if((t+=o-a)>0)for(o+1==a&&(f+=".");t--;f+="0");return e.s<0&&s?"-"+f:f}function q(e,t){for(var n,r,s=1,o=new z(e[0]);s<e.length;s++)(!(r=new z(e[s])).s||(n=p(o,r))===t||0===n&&o.s===t)&&(o=r);return o}function K(e,t,n){for(var r=1,s=t.length;!t[--s];t.pop());for(s=t[0];s>=10;s/=10,r++);return(n=r+n*u-1)>F?e.c=e.e=null:n<B?e.c=[e.e=0]:(e.e=n,e.c=t),e}function Y(e,t,n,r){var i,a,l,c,m,h,b,p=e.c,k=d;if(p){e:{for(i=1,c=p[0];c>=10;c/=10,i++);if((a=t-i)<0)a+=u,l=t,m=p[h=0],b=o(m/k[i-l-1]%10);else if((h=s((a+1)/u))>=p.length){if(!r)break e;for(;p.length<=h;p.push(0));m=b=0,i=1,l=(a%=u)-u+1}else{for(m=c=p[h],i=1;c>=10;c/=10,i++);b=(l=(a%=u)-u+i)<0?0:o(m/k[i-l-1]%10)}if(r=r||t<0||null!=p[h+1]||(l<0?m:m%k[i-l-1]),r=n<4?(b||r)&&(0==n||n==(e.s<0?3:2)):b>5||5==b&&(4==n||r||6==n&&(a>0?l>0?m/k[i-l]:0:p[h-1])%10&1||n==(e.s<0?8:7)),t<1||!p[0])return p.length=0,r?(t-=e.e+1,p[0]=k[(u-t%u)%u],e.e=-t||0):p[0]=e.e=0,e;if(0==a?(p.length=h,c=1,h--):(p.length=h+1,c=k[u-a],p[h]=l>0?o(m/k[i-l]%k[l])*c:0),r)for(;;){if(0==h){for(a=1,l=p[0];l>=10;l/=10,a++);for(l=p[0]+=c,c=1;l>=10;l/=10,c++);a!=c&&(e.e++,p[0]==f&&(p[0]=1));break}if(p[h]+=c,p[h]!=f)break;p[h--]=0,c=1}for(a=p.length;0===p[--a];p.pop());}e.e>F?e.c=e.e=null:e.e<B&&(e.c=[e.e=0])}return e}function J(e){var t,n=e.e;return null===n?e.toString():(t=b(e.c),t=n<=R||n>=L?j(t,n):w(t,n,"0"),e.s<0?"-"+t:t)}return z.clone=e,z.ROUND_UP=0,z.ROUND_DOWN=1,z.ROUND_CEIL=2,z.ROUND_FLOOR=3,z.ROUND_HALF_UP=4,z.ROUND_HALF_DOWN=5,z.ROUND_HALF_EVEN=6,z.ROUND_HALF_CEIL=7,z.ROUND_HALF_FLOOR=8,z.EUCLID=9,z.config=z.set=function(e){var t,n;if(null!=e){if("object"!=typeof e)throw Error(i+"Object expected: "+e);if(e.hasOwnProperty(t="DECIMAL_PLACES")&&(k(n=e[t],0,m,t),I=n),e.hasOwnProperty(t="ROUNDING_MODE")&&(k(n=e[t],0,8,t),M=n),e.hasOwnProperty(t="EXPONENTIAL_AT")&&((n=e[t])&&n.pop?(k(n[0],-m,0,t),k(n[1],0,m,t),R=n[0],L=n[1]):(k(n,-m,m,t),R=-(L=n<0?-n:n))),e.hasOwnProperty(t="RANGE"))if((n=e[t])&&n.pop)k(n[0],-m,-1,t),k(n[1],1,m,t),B=n[0],F=n[1];else{if(k(n,-m,m,t),!n)throw Error(i+t+" cannot be zero: "+n);B=-(F=n<0?-n:n)}if(e.hasOwnProperty(t="CRYPTO")){if((n=e[t])!==!!n)throw Error(i+t+" not true or false: "+n);if(n){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw N=!n,Error(i+"crypto unavailable");N=n}else N=n}if(e.hasOwnProperty(t="MODULO_MODE")&&(k(n=e[t],0,9,t),D=n),e.hasOwnProperty(t="POW_PRECISION")&&(k(n=e[t],0,m,t),U=n),e.hasOwnProperty(t="FORMAT")){if("object"!=typeof(n=e[t]))throw Error(i+t+" not an object: "+n);H=n}if(e.hasOwnProperty(t="ALPHABET")){if("string"!=typeof(n=e[t])||/^.?$|[+\-.\s]|(.).*\1/.test(n))throw Error(i+t+" invalid: "+n);G="0123456789"==n.slice(0,10),W=n}}return{DECIMAL_PLACES:I,ROUNDING_MODE:M,EXPONENTIAL_AT:[R,L],RANGE:[B,F],CRYPTO:N,MODULO_MODE:D,POW_PRECISION:U,FORMAT:H,ALPHABET:W}},z.isBigNumber=function(e){if(!e||!0!==e._isBigNumber)return!1;if(!z.DEBUG)return!0;var t,n,r=e.c,s=e.e,a=e.s;e:if("[object Array]"=={}.toString.call(r)){if((1===a||-1===a)&&s>=-m&&s<=m&&s===o(s)){if(0===r[0]){if(0===s&&1===r.length)return!0;break e}if((t=(s+1)%u)<1&&(t+=u),String(r[0]).length==t){for(t=0;t<r.length;t++)if((n=r[t])<0||n>=f||n!==o(n))break e;if(0!==n)return!0}}}else if(null===r&&null===s&&(null===a||1===a||-1===a))return!0;throw Error(i+"Invalid BigNumber: "+e)},z.maximum=z.max=function(){return q(arguments,-1)},z.minimum=z.min=function(){return q(arguments,1)},z.random=(_=9007199254740992,v=Math.random()*_&2097151?function(){return o(Math.random()*_)}:function(){return 8388608*(1073741824*Math.random()|0)+(8388608*Math.random()|0)},function(e){var t,n,r,a,f,l=0,c=[],h=new z(P);if(null==e?e=I:k(e,0,m),a=s(e/u),N)if(crypto.getRandomValues){for(t=crypto.getRandomValues(new Uint32Array(a*=2));l<a;)(f=131072*t[l]+(t[l+1]>>>11))>=9e15?(n=crypto.getRandomValues(new Uint32Array(2)),t[l]=n[0],t[l+1]=n[1]):(c.push(f%1e14),l+=2);l=a/2}else{if(!crypto.randomBytes)throw N=!1,Error(i+"crypto unavailable");for(t=crypto.randomBytes(a*=7);l<a;)(f=281474976710656*(31&t[l])+1099511627776*t[l+1]+4294967296*t[l+2]+16777216*t[l+3]+(t[l+4]<<16)+(t[l+5]<<8)+t[l+6])>=9e15?crypto.randomBytes(7).copy(t,l):(c.push(f%1e14),l+=7);l=a/7}if(!N)for(;l<a;)(f=v())<9e15&&(c[l++]=f%1e14);for(a=c[--l],e%=u,a&&e&&(f=d[u-e],c[l]=o(a/f)*f);0===c[l];c.pop(),l--);if(l<0)c=[r=0];else{for(r=-1;0===c[0];c.splice(0,1),r-=u);for(l=1,f=c[0];f>=10;f/=10,l++);l<u&&(r-=u-l)}return h.e=r,h.c=c,h}),z.sum=function(){for(var e=1,t=arguments,n=new z(t[0]);e<t.length;)n=n.plus(t[e++]);return n},g=function(){var e="0123456789";function t(e,t,n,r){for(var s,o,i=[0],a=0,f=e.length;a<f;){for(o=i.length;o--;i[o]*=t);for(i[0]+=r.indexOf(e.charAt(a++)),s=0;s<i.length;s++)i[s]>n-1&&(null==i[s+1]&&(i[s+1]=0),i[s+1]+=i[s]/n|0,i[s]%=n)}return i.reverse()}return function(r,s,o,i,a){var f,u,l,d,c,m,h,p,k=r.indexOf("."),x=I,j=M;for(k>=0&&(d=U,U=0,r=r.replace(".",""),m=(p=new z(s)).pow(r.length-k),U=d,p.c=t(w(b(m.c),m.e,"0"),10,o,e),p.e=p.c.length),l=d=(h=t(r,s,o,a?(f=W,e):(f=e,W))).length;0==h[--d];h.pop());if(!h[0])return f.charAt(0);if(k<0?--l:(m.c=h,m.e=l,m.s=i,h=(m=n(m,p,x,j,o)).c,c=m.r,l=m.e),k=h[u=l+x+1],d=o/2,c=c||u<0||null!=h[u+1],c=j<4?(null!=k||c)&&(0==j||j==(m.s<0?3:2)):k>d||k==d&&(4==j||c||6==j&&1&h[u-1]||j==(m.s<0?8:7)),u<1||!h[0])r=c?w(f.charAt(1),-x,f.charAt(0)):f.charAt(0);else{if(h.length=u,c)for(--o;++h[--u]>o;)h[u]=0,u||(++l,h=[1].concat(h));for(d=h.length;!h[--d];);for(k=0,r="";k<=d;r+=f.charAt(h[k++]));r=w(r,l,f.charAt(0))}return r}}(),n=function(){function e(e,t,n){var r,s,o,i,a=0,f=e.length,u=t%c,l=t/c|0;for(e=e.slice();f--;)a=((s=u*(o=e[f]%c)+(r=l*o+(i=e[f]/c|0)*u)%c*c+a)/n|0)+(r/c|0)+l*i,e[f]=s%n;return a&&(e=[a].concat(e)),e}function t(e,t,n,r){var s,o;if(n!=r)o=n>r?1:-1;else for(s=o=0;s<n;s++)if(e[s]!=t[s]){o=e[s]>t[s]?1:-1;break}return o}function n(e,t,n,r){for(var s=0;n--;)e[n]-=s,s=e[n]<t[n]?1:0,e[n]=s*r+e[n]-t[n];for(;!e[0]&&e.length>1;e.splice(0,1));}return function(r,s,i,a,l){var d,c,m,b,p,k,x,j,w,g,y,_,v,T,S,E,O,A=r.s==s.s?1:-1,C=r.c,P=s.c;if(!(C&&C[0]&&P&&P[0]))return new z(r.s&&s.s&&(C?!P||C[0]!=P[0]:P)?C&&0==C[0]||!P?0*A:A/0:NaN);for(w=(j=new z(A)).c=[],A=i+(c=r.e-s.e)+1,l||(l=f,c=h(r.e/u)-h(s.e/u),A=A/u|0),m=0;P[m]==(C[m]||0);m++);if(P[m]>(C[m]||0)&&c--,A<0)w.push(1),b=!0;else{for(T=C.length,E=P.length,m=0,A+=2,(p=o(l/(P[0]+1)))>1&&(P=e(P,p,l),C=e(C,p,l),E=P.length,T=C.length),v=E,y=(g=C.slice(0,E)).length;y<E;g[y++]=0);O=P.slice(),O=[0].concat(O),S=P[0],P[1]>=l/2&&S++;do{if(p=0,(d=t(P,g,E,y))<0){if(_=g[0],E!=y&&(_=_*l+(g[1]||0)),(p=o(_/S))>1)for(p>=l&&(p=l-1),x=(k=e(P,p,l)).length,y=g.length;1==t(k,g,x,y);)p--,n(k,E<x?O:P,x,l),x=k.length,d=1;else 0==p&&(d=p=1),x=(k=P.slice()).length;if(x<y&&(k=[0].concat(k)),n(g,k,y,l),y=g.length,-1==d)for(;t(P,g,E,y)<1;)p++,n(g,E<y?O:P,y,l),y=g.length}else 0===d&&(p++,g=[0]);w[m++]=p,g[0]?g[y++]=C[v]||0:(g=[C[v]],y=1)}while((v++<T||null!=g[0])&&A--);b=null!=g[0],w[0]||w.splice(0,1)}if(l==f){for(m=1,A=w[0];A>=10;A/=10,m++);Y(j,i+(j.e=m+c*u-1)+1,a,b)}else j.e=c,j.r=+b;return j}}(),T=/^(-?)0([xbo])(?=\w[\w.]*$)/i,S=/^([^.]+)\.$/,E=/^\.([^.]+)$/,O=/^-?(Infinity|NaN)$/,A=/^\s*\+(?=[\w.])|^\s+|\s+$/g,y=function(e,t,n,r){var s,o=n?t:t.replace(A,"");if(O.test(o))e.s=isNaN(o)?null:o<0?-1:1;else{if(!n&&(o=o.replace(T,function(e,t,n){return s="x"==(n=n.toLowerCase())?16:"b"==n?2:8,r&&r!=s?e:t}),r&&(s=r,o=o.replace(S,"$1").replace(E,"0.$1")),t!=o))return new z(o,s);if(z.DEBUG)throw Error(i+"Not a"+(r?" base "+r:"")+" number: "+t);e.s=null}e.c=e.e=null},C.absoluteValue=C.abs=function(){var e=new z(this);return e.s<0&&(e.s=1),e},C.comparedTo=function(e,t){return p(this,new z(e,t))},C.decimalPlaces=C.dp=function(e,t){var n,r,s,o=this;if(null!=e)return k(e,0,m),null==t?t=M:k(t,0,8),Y(new z(o),e+o.e+1,t);if(!(n=o.c))return null;if(r=((s=n.length-1)-h(this.e/u))*u,s=n[s])for(;s%10==0;s/=10,r--);return r<0&&(r=0),r},C.dividedBy=C.div=function(e,t){return n(this,new z(e,t),I,M)},C.dividedToIntegerBy=C.idiv=function(e,t){return n(this,new z(e,t),0,1)},C.exponentiatedBy=C.pow=function(e,t){var n,r,a,f,l,d,c,m,h=this;if((e=new z(e)).c&&!e.isInteger())throw Error(i+"Exponent not an integer: "+J(e));if(null!=t&&(t=new z(t)),l=e.e>14,!h.c||!h.c[0]||1==h.c[0]&&!h.e&&1==h.c.length||!e.c||!e.c[0])return m=new z(Math.pow(+J(h),l?e.s*(2-x(e)):+J(e))),t?m.mod(t):m;if(d=e.s<0,t){if(t.c?!t.c[0]:!t.s)return new z(NaN);(r=!d&&h.isInteger()&&t.isInteger())&&(h=h.mod(t))}else{if(e.e>9&&(h.e>0||h.e<-1||(0==h.e?h.c[0]>1||l&&h.c[1]>=24e7:h.c[0]<8e13||l&&h.c[0]<=9999975e7)))return f=h.s<0&&x(e)?-0:0,h.e>-1&&(f=1/f),new z(d?1/f:f);U&&(f=s(U/u+2))}for(l?(n=new z(.5),d&&(e.s=1),c=x(e)):c=(a=Math.abs(+J(e)))%2,m=new z(P);;){if(c){if(!(m=m.times(h)).c)break;f?m.c.length>f&&(m.c.length=f):r&&(m=m.mod(t))}if(a){if(0===(a=o(a/2)))break;c=a%2}else if(Y(e=e.times(n),e.e+1,1),e.e>14)c=x(e);else{if(0===(a=+J(e)))break;c=a%2}h=h.times(h),f?h.c&&h.c.length>f&&(h.c.length=f):r&&(h=h.mod(t))}return r?m:(d&&(m=P.div(m)),t?m.mod(t):f?Y(m,U,M,undefined):m)},C.integerValue=function(e){var t=new z(this);return null==e?e=M:k(e,0,8),Y(t,t.e+1,e)},C.isEqualTo=C.eq=function(e,t){return 0===p(this,new z(e,t))},C.isFinite=function(){return!!this.c},C.isGreaterThan=C.gt=function(e,t){return p(this,new z(e,t))>0},C.isGreaterThanOrEqualTo=C.gte=function(e,t){return 1===(t=p(this,new z(e,t)))||0===t},C.isInteger=function(){return!!this.c&&h(this.e/u)>this.c.length-2},C.isLessThan=C.lt=function(e,t){return p(this,new z(e,t))<0},C.isLessThanOrEqualTo=C.lte=function(e,t){return-1===(t=p(this,new z(e,t)))||0===t},C.isNaN=function(){return!this.s},C.isNegative=function(){return this.s<0},C.isPositive=function(){return this.s>0},C.isZero=function(){return!!this.c&&0==this.c[0]},C.minus=function(e,t){var n,r,s,o,i=this,a=i.s;if(t=(e=new z(e,t)).s,!a||!t)return new z(NaN);if(a!=t)return e.s=-t,i.plus(e);var l=i.e/u,d=e.e/u,c=i.c,m=e.c;if(!l||!d){if(!c||!m)return c?(e.s=-t,e):new z(m?i:NaN);if(!c[0]||!m[0])return m[0]?(e.s=-t,e):new z(c[0]?i:3==M?-0:0)}if(l=h(l),d=h(d),c=c.slice(),a=l-d){for((o=a<0)?(a=-a,s=c):(d=l,s=m),s.reverse(),t=a;t--;s.push(0));s.reverse()}else for(r=(o=(a=c.length)<(t=m.length))?a:t,a=t=0;t<r;t++)if(c[t]!=m[t]){o=c[t]<m[t];break}if(o&&(s=c,c=m,m=s,e.s=-e.s),(t=(r=m.length)-(n=c.length))>0)for(;t--;c[n++]=0);for(t=f-1;r>a;){if(c[--r]<m[r]){for(n=r;n&&!c[--n];c[n]=t);--c[n],c[r]+=f}c[r]-=m[r]}for(;0==c[0];c.splice(0,1),--d);return c[0]?K(e,c,d):(e.s=3==M?-1:1,e.c=[e.e=0],e)},C.modulo=C.mod=function(e,t){var r,s,o=this;return e=new z(e,t),!o.c||!e.s||e.c&&!e.c[0]?new z(NaN):!e.c||o.c&&!o.c[0]?new z(o):(9==D?(s=e.s,e.s=1,r=n(o,e,0,3),e.s=s,r.s*=s):r=n(o,e,0,D),(e=o.minus(r.times(e))).c[0]||1!=D||(e.s=o.s),e)},C.multipliedBy=C.times=function(e,t){var n,r,s,o,i,a,l,d,m,b,p,k,x,j,w,g=this,y=g.c,_=(e=new z(e,t)).c;if(!(y&&_&&y[0]&&_[0]))return!g.s||!e.s||y&&!y[0]&&!_||_&&!_[0]&&!y?e.c=e.e=e.s=null:(e.s*=g.s,y&&_?(e.c=[0],e.e=0):e.c=e.e=null),e;for(r=h(g.e/u)+h(e.e/u),e.s*=g.s,(l=y.length)<(b=_.length)&&(x=y,y=_,_=x,s=l,l=b,b=s),s=l+b,x=[];s--;x.push(0));for(j=f,w=c,s=b;--s>=0;){for(n=0,p=_[s]%w,k=_[s]/w|0,o=s+(i=l);o>s;)n=((d=p*(d=y[--i]%w)+(a=k*d+(m=y[i]/w|0)*p)%w*w+x[o]+n)/j|0)+(a/w|0)+k*m,x[o--]=d%j;x[o]=n}return n?++r:x.splice(0,1),K(e,x,r)},C.negated=function(){var e=new z(this);return e.s=-e.s||null,e},C.plus=function(e,t){var n,r=this,s=r.s;if(t=(e=new z(e,t)).s,!s||!t)return new z(NaN);if(s!=t)return e.s=-t,r.minus(e);var o=r.e/u,i=e.e/u,a=r.c,l=e.c;if(!o||!i){if(!a||!l)return new z(s/0);if(!a[0]||!l[0])return l[0]?e:new z(a[0]?r:0*s)}if(o=h(o),i=h(i),a=a.slice(),s=o-i){for(s>0?(i=o,n=l):(s=-s,n=a),n.reverse();s--;n.push(0));n.reverse()}for((s=a.length)-(t=l.length)<0&&(n=l,l=a,a=n,t=s),s=0;t;)s=(a[--t]=a[t]+l[t]+s)/f|0,a[t]=f===a[t]?0:a[t]%f;return s&&(a=[s].concat(a),++i),K(e,a,i)},C.precision=C.sd=function(e,t){var n,r,s,o=this;if(null!=e&&e!==!!e)return k(e,1,m),null==t?t=M:k(t,0,8),Y(new z(o),e,t);if(!(n=o.c))return null;if(r=(s=n.length-1)*u+1,s=n[s]){for(;s%10==0;s/=10,r--);for(s=n[0];s>=10;s/=10,r++);}return e&&o.e+1>r&&(r=o.e+1),r},C.shiftedBy=function(e){return k(e,-9007199254740991,l),this.times("1e"+e)},C.squareRoot=C.sqrt=function(){var e,t,r,s,o,i=this,a=i.c,f=i.s,u=i.e,l=I+4,d=new z("0.5");if(1!==f||!a||!a[0])return new z(!f||f<0&&(!a||a[0])?NaN:a?i:1/0);if(0==(f=Math.sqrt(+J(i)))||f==1/0?(((t=b(a)).length+u)%2==0&&(t+="0"),f=Math.sqrt(+t),u=h((u+1)/2)-(u<0||u%2),r=new z(t=f==1/0?"5e"+u:(t=f.toExponential()).slice(0,t.indexOf("e")+1)+u)):r=new z(f+""),r.c[0])for((f=(u=r.e)+l)<3&&(f=0);;)if(o=r,r=d.times(o.plus(n(i,o,l,1))),b(o.c).slice(0,f)===(t=b(r.c)).slice(0,f)){if(r.e<u&&--f,"9999"!=(t=t.slice(f-3,f+1))&&(s||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(Y(r,r.e+I+2,1),e=!r.times(r).eq(i));break}if(!s&&(Y(o,o.e+I+2,0),o.times(o).eq(i))){r=o;break}l+=4,f+=4,s=1}return Y(r,r.e+I+1,M,e)},C.toExponential=function(e,t){return null!=e&&(k(e,0,m),e++),V(this,e,t,1)},C.toFixed=function(e,t){return null!=e&&(k(e,0,m),e=e+this.e+1),V(this,e,t)},C.toFormat=function(e,t,n){var r,s=this;if(null==n)null!=e&&t&&"object"==typeof t?(n=t,t=null):e&&"object"==typeof e?(n=e,e=t=null):n=H;else if("object"!=typeof n)throw Error(i+"Argument not an object: "+n);if(r=s.toFixed(e,t),s.c){var o,a=r.split("."),f=+n.groupSize,u=+n.secondaryGroupSize,l=n.groupSeparator||"",d=a[0],c=a[1],m=s.s<0,h=m?d.slice(1):d,b=h.length;if(u&&(o=f,f=u,u=o,b-=o),f>0&&b>0){for(o=b%f||f,d=h.substr(0,o);o<b;o+=f)d+=l+h.substr(o,f);u>0&&(d+=l+h.slice(o)),m&&(d="-"+d)}r=c?d+(n.decimalSeparator||"")+((u=+n.fractionGroupSize)?c.replace(new RegExp("\\d{"+u+"}\\B","g"),"$&"+(n.fractionGroupSeparator||"")):c):d}return(n.prefix||"")+r+(n.suffix||"")},C.toFraction=function(e){var t,r,s,o,a,f,l,c,m,h,p,k,x=this,j=x.c;if(null!=e&&(!(l=new z(e)).isInteger()&&(l.c||1!==l.s)||l.lt(P)))throw Error(i+"Argument "+(l.isInteger()?"out of range: ":"not an integer: ")+J(l));if(!j)return new z(x);for(t=new z(P),m=r=new z(P),s=c=new z(P),k=b(j),a=t.e=k.length-x.e-1,t.c[0]=d[(f=a%u)<0?u+f:f],e=!e||l.comparedTo(t)>0?a>0?t:m:l,f=F,F=1/0,l=new z(k),c.c[0]=0;h=n(l,t,0,1),1!=(o=r.plus(h.times(s))).comparedTo(e);)r=s,s=o,m=c.plus(h.times(o=m)),c=o,t=l.minus(h.times(o=t)),l=o;return o=n(e.minus(r),s,0,1),c=c.plus(o.times(m)),r=r.plus(o.times(s)),c.s=m.s=x.s,p=n(m,s,a*=2,M).minus(x).abs().comparedTo(n(c,r,a,M).minus(x).abs())<1?[m,s]:[c,r],F=f,p},C.toNumber=function(){return+J(this)},C.toPrecision=function(e,t){return null!=e&&k(e,1,m),V(this,e,t,2)},C.toString=function(e){var t,n=this,r=n.s,s=n.e;return null===s?r?(t="Infinity",r<0&&(t="-"+t)):t="NaN":(null==e?t=s<=R||s>=L?j(b(n.c),s):w(b(n.c),s,"0"):10===e&&G?t=w(b((n=Y(new z(n),I+s+1,M)).c),n.e,"0"):(k(e,2,W.length,"Base"),t=g(w(b(n.c),s,"0"),10,e,r,!0)),r<0&&n.c[0]&&(t="-"+t)),t},C.valueOf=C.toJSON=function(){return J(this)},C._isBigNumber=!0,null!=t&&z.set(t),z}(),n.default=n.BigNumber=n,"function"==typeof define&&define.amd?define(function(){return n}):void 0!==t&&t.exports?t.exports=n:(e||(e="undefined"!=typeof self&&self?self:window),e.BigNumber=n)}(this)}}},{package:"eth-lattice-keyring>gridplus-sdk>bignumber.js",file:"node_modules/gridplus-sdk/node_modules/bignumber.js/bignumber.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/rlp/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(Array.isArray(e)){const t=[];for(let n=0;n<e.length;n++)t.push(r(e[n]));const n=m(...t);return m(i(n.length,192),n)}const t=k(e);return 1===t.length&&t[0]<128?t:m(i(t.length,128),t)}function s(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function o(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return d(l(e))}function i(e,t){if(e<56)return Uint8Array.from([e+t]);const n=b(e),r=b(t+55+n.length/2);return Uint8Array.from(c(r+n))}function a(e,t=!1){if(!e||0===e.length)return Uint8Array.from([]);const n=f(k(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function f(e){let t,n,r,i,a;const u=[],l=e[0];if(l<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(l<=183){if(t=l-127,r=128===l?Uint8Array.from([]):s(e,1,t),2===t&&r[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:r,remainder:e.slice(t)}}if(l<=191){if(n=l-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=o(s(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return r=s(e,n,t+n),{data:r,remainder:e.slice(t+n)}}if(l<=247){for(t=l-191,i=s(e,1,t);i.length;)a=f(i),u.push(a.data),i=a.remainder;return{data:u,remainder:e.slice(t)}}{if(n=l-246,t=o(s(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const r=n+t;if(r>e.length)throw new Error("invalid RLP: total length is larger than the data");for(i=s(e,n,r);i.length;)a=f(i),u.push(a.data),i=a.remainder;return{data:u,remainder:e.slice(r)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.utils=n.decode=n.encode=void 0,n.encode=r,n.decode=a;const u=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function l(e){let t="";for(let n=0;n<e.length;n++)t+=u[e[n]];return t}function d(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function c(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const r=2*n;t[n]=d(e.slice(r,r+2))}return t}function m(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,r=0;t<e.length;t++){const s=e[t];n.set(s,r),r+=s.length}return n}function h(e){return(new TextEncoder).encode(e)}function b(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function p(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function k(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return p(e)?c((t="string"!=typeof(n=e)?n:p(n)?n.slice(2):n).length%2?`0${t}`:t):h(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?c(b(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:l,concatBytes:m,hexToBytes:c,utf8ToBytes:h};const x={encode:r,decode:a};n.default=x}}},{package:"eth-lattice-keyring>gridplus-sdk>rlp",file:"node_modules/gridplus-sdk/node_modules/rlp/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return l.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return f.default}});var r=c(e("./v1.js")),s=c(e("./v3.js")),o=c(e("./v4.js")),i=c(e("./v5.js")),a=c(e("./nil.js")),f=c(e("./version.js")),u=c(e("./validate.js")),l=c(e("./stringify.js")),d=c(e("./parse.js"));function c(e){return e&&e.__esModule?e:{default:e}}}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return 14+(e+64>>>9<<4)+1}function s(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function o(e,t,n,r,o,i){return s((a=s(s(t,e),s(r,i)))<<(f=o)|a>>>32-f,n);var a,f}function i(e,t,n,r,s,i,a){return o(t&n|~t&r,e,t,s,i,a)}function a(e,t,n,r,s,i,a){return o(t&r|n&~r,e,t,s,i,a)}function f(e,t,n,r,s,i,a){return o(t^n^r,e,t,s,i,a)}function u(e,t,n,r,s,i,a){return o(n^(t|~r),e,t,s,i,a)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var l=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,r="0123456789abcdef";for(let s=0;s<n;s+=8){const n=e[s>>5]>>>s%32&255,o=parseInt(r.charAt(n>>>4&15)+r.charAt(15&n),16);t.push(o)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[r(t)-1]=t;let n=1732584193,o=-271733879,l=-1732584194,d=271733878;for(let t=0;t<e.length;t+=16){const r=n,c=o,m=l,h=d;n=i(n,o,l,d,e[t],7,-680876936),d=i(d,n,o,l,e[t+1],12,-389564586),l=i(l,d,n,o,e[t+2],17,606105819),o=i(o,l,d,n,e[t+3],22,-1044525330),n=i(n,o,l,d,e[t+4],7,-176418897),d=i(d,n,o,l,e[t+5],12,1200080426),l=i(l,d,n,o,e[t+6],17,-1473231341),o=i(o,l,d,n,e[t+7],22,-45705983),n=i(n,o,l,d,e[t+8],7,1770035416),d=i(d,n,o,l,e[t+9],12,-1958414417),l=i(l,d,n,o,e[t+10],17,-42063),o=i(o,l,d,n,e[t+11],22,-1990404162),n=i(n,o,l,d,e[t+12],7,1804603682),d=i(d,n,o,l,e[t+13],12,-40341101),l=i(l,d,n,o,e[t+14],17,-1502002290),o=i(o,l,d,n,e[t+15],22,1236535329),n=a(n,o,l,d,e[t+1],5,-165796510),d=a(d,n,o,l,e[t+6],9,-1069501632),l=a(l,d,n,o,e[t+11],14,643717713),o=a(o,l,d,n,e[t],20,-373897302),n=a(n,o,l,d,e[t+5],5,-701558691),d=a(d,n,o,l,e[t+10],9,38016083),l=a(l,d,n,o,e[t+15],14,-660478335),o=a(o,l,d,n,e[t+4],20,-405537848),n=a(n,o,l,d,e[t+9],5,568446438),d=a(d,n,o,l,e[t+14],9,-1019803690),l=a(l,d,n,o,e[t+3],14,-187363961),o=a(o,l,d,n,e[t+8],20,1163531501),n=a(n,o,l,d,e[t+13],5,-1444681467),d=a(d,n,o,l,e[t+2],9,-51403784),l=a(l,d,n,o,e[t+7],14,1735328473),o=a(o,l,d,n,e[t+12],20,-1926607734),n=f(n,o,l,d,e[t+5],4,-378558),d=f(d,n,o,l,e[t+8],11,-2022574463),l=f(l,d,n,o,e[t+11],16,1839030562),o=f(o,l,d,n,e[t+14],23,-35309556),n=f(n,o,l,d,e[t+1],4,-1530992060),d=f(d,n,o,l,e[t+4],11,1272893353),l=f(l,d,n,o,e[t+7],16,-155497632),o=f(o,l,d,n,e[t+10],23,-1094730640),n=f(n,o,l,d,e[t+13],4,681279174),d=f(d,n,o,l,e[t],11,-358537222),l=f(l,d,n,o,e[t+3],16,-722521979),o=f(o,l,d,n,e[t+6],23,76029189),n=f(n,o,l,d,e[t+9],4,-640364487),d=f(d,n,o,l,e[t+12],11,-421815835),l=f(l,d,n,o,e[t+15],16,530742520),o=f(o,l,d,n,e[t+2],23,-995338651),n=u(n,o,l,d,e[t],6,-198630844),d=u(d,n,o,l,e[t+7],10,1126891415),l=u(l,d,n,o,e[t+14],15,-1416354905),o=u(o,l,d,n,e[t+5],21,-57434055),n=u(n,o,l,d,e[t+12],6,1700485571),d=u(d,n,o,l,e[t+3],10,-1894986606),l=u(l,d,n,o,e[t+10],15,-1051523),o=u(o,l,d,n,e[t+1],21,-2054922799),n=u(n,o,l,d,e[t+8],6,1873313359),d=u(d,n,o,l,e[t+15],10,-30611744),l=u(l,d,n,o,e[t+6],15,-1560198380),o=u(o,l,d,n,e[t+13],21,1309151649),n=u(n,o,l,d,e[t+4],6,-145523070),d=u(d,n,o,l,e[t+11],10,-1120210379),l=u(l,d,n,o,e[t+2],15,718787259),o=u(o,l,d,n,e[t+9],21,-343485551),n=s(n,r),o=s(o,c),l=s(l,m),d=s(d,h)}return[n,o,l,d]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(r(t));for(let r=0;r<t;r+=8)n[r>>5]|=(255&e[r/8])<<r%32;return n}(e),8*e.length))};n.default=l}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/native-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=r}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/native-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=o}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let r;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!r&&(r="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!r))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return r(s)};const s=new Uint8Array(16)}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n,r){switch(e){case 0:return t&n^~t&r;case 1:case 3:return t^n^r;case 2:return t&n^t&r^n&r}}function s(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var o=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const o=e.length/4+2,i=Math.ceil(o/16),a=new Array(i);for(let t=0;t<i;++t){const n=new Uint32Array(16);for(let r=0;r<16;++r)n[r]=e[64*t+4*r]<<24|e[64*t+4*r+1]<<16|e[64*t+4*r+2]<<8|e[64*t+4*r+3];a[t]=n}a[i-1][14]=8*(e.length-1)/Math.pow(2,32),a[i-1][14]=Math.floor(a[i-1][14]),a[i-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<i;++e){const o=new Uint32Array(80);for(let t=0;t<16;++t)o[t]=a[e][t];for(let e=16;e<80;++e)o[e]=s(o[e-3]^o[e-8]^o[e-14]^o[e-16],1);let i=n[0],f=n[1],u=n[2],l=n[3],d=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),a=s(i,5)+r(n,f,u,l)+d+t[n]+o[e]>>>0;d=l,l=u,u=s(f,30)>>>0,f=i,i=a}n[0]=n[0]+i>>>0,n[1]=n[1]+f>>>0,n[2]=n[2]+u>>>0,n[3]=n[3]+l>>>0,n[4]=n[4]+d>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=o}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=i;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};const o=[];for(let e=0;e<256;++e)o.push((e+256).toString(16).slice(1));function i(e,t=0){return o[e[t+0]]+o[e[t+1]]+o[e[t+2]]+o[e[t+3]]+"-"+o[e[t+4]]+o[e[t+5]]+"-"+o[e[t+6]]+o[e[t+7]]+"-"+o[e[t+8]]+o[e[t+9]]+"-"+o[e[t+10]]+o[e[t+11]]+o[e[t+12]]+o[e[t+13]]+o[e[t+14]]+o[e[t+15]]}var a=function(e,t=0){const n=i(e,t);if(!(0,s.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=a}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./rng.js"))&&r.__esModule?r:{default:r},o=e("./stringify.js");let i,a,f=0,u=0;var l=function(e,t,n){let r=t&&n||0;const l=t||new Array(16);let d=(e=e||{}).node||i,c=e.clockseq!==undefined?e.clockseq:a;if(null==d||null==c){const t=e.random||(e.rng||s.default)();null==d&&(d=i=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==c&&(c=a=16383&(t[6]<<8|t[7]))}let m=e.msecs!==undefined?e.msecs:Date.now(),h=e.nsecs!==undefined?e.nsecs:u+1;const b=m-f+(h-u)/1e4;if(b<0&&e.clockseq===undefined&&(c=c+1&16383),(b<0||m>f)&&e.nsecs===undefined&&(h=0),h>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");f=m,u=h,a=c,m+=122192928e5;const p=(1e4*(268435455&m)+h)%4294967296;l[r++]=p>>>24&255,l[r++]=p>>>16&255,l[r++]=p>>>8&255,l[r++]=255&p;const k=m/4294967296*1e4&268435455;l[r++]=k>>>8&255,l[r++]=255&k,l[r++]=k>>>24&15|16,l[r++]=k>>>16&255,l[r++]=c>>>8|128,l[r++]=255&c;for(let e=0;e<6;++e)l[r+e]=d[e];return t||(0,o.unsafeStringify)(l)};n.default=l}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./md5.js"));function o(e){return e&&e.__esModule?e:{default:e}}var i=(0,r.default)("v3",48,s.default);n.default=i}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function r(e,r,i,a){var f;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof r&&(r=(0,o.default)(r)),16!==(null===(f=r)||void 0===f?void 0:f.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let u=new Uint8Array(16+e.length);if(u.set(r),u.set(e,r.length),u=n(u),u[6]=15&u[6]|t,u[8]=63&u[8]|128,i){a=a||0;for(let e=0;e<16;++e)i[a+e]=u[e];return i}return(0,s.unsafeStringify)(u)}try{r.name=e}catch(e){}return r.DNS=i,r.URL=a,r};var r,s=e("./stringify.js"),o=(r=e("./parse.js"))&&r.__esModule?r:{default:r};const i="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=i;const a="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=a}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v4.js",{"./native.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/native-browser.js","./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./native.js")),s=i(e("./rng.js")),o=e("./stringify.js");function i(e){return e&&e.__esModule?e:{default:e}}var a=function(e,t,n){if(r.default.randomUUID&&!t&&!e)return r.default.randomUUID();const i=(e=e||{}).random||(e.rng||s.default)();if(i[6]=15&i[6]|64,i[8]=63&i[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=i[e];return t}return(0,o.unsafeStringify)(i)};n.default=a}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=o(e("./v35.js")),s=o(e("./sha1.js"));function o(e){return e&&e.__esModule?e:{default:e}}var i=(0,r.default)("v5",80,s.default);n.default=i}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./regex.js"))&&r.__esModule?r:{default:r};var o=function(e){return"string"==typeof e&&s.default.test(e)};n.default=o}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/gridplus-sdk/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var o=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=o}}},{package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules/gridplus-sdk/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/idb/build/index.cjs",{"./wrap-idb-value.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/idb/build/wrap-idb-value.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./wrap-idb-value.cjs");const s=["get","getKey","getAll","getAllKeys","count"],o=["put","add","delete","clear"],i=new Map;function a(e,t){if(!(e instanceof IDBDatabase)||t in e||"string"!=typeof t)return;if(i.get(t))return i.get(t);const n=t.replace(/FromIndex$/,""),r=t!==n,a=o.includes(n);if(!(n in(r?IDBIndex:IDBObjectStore).prototype)||!a&&!s.includes(n))return;const f=async function(e,...t){const s=this.transaction(e,a?"readwrite":"readonly");let o=s.store;return r&&(o=o.index(t.shift())),(await Promise.all([o[n](...t),a&&s.done]))[0]};return i.set(t,f),f}r.replaceTraps(e=>({...e,get:(t,n,r)=>a(t,n)||e.get(t,n,r),has:(t,n)=>!!a(t,n)||e.has(t,n)})),n.unwrap=r.unwrap,n.wrap=r.wrap,n.deleteDB=function(e,{blocked:t}={}){const n=indexedDB.deleteDatabase(e);return t&&n.addEventListener("blocked",e=>t(e.oldVersion,e)),r.wrap(n).then(()=>undefined)},n.openDB=function(e,t,{blocked:n,upgrade:s,blocking:o,terminated:i}={}){const a=indexedDB.open(e,t),f=r.wrap(a);return s&&a.addEventListener("upgradeneeded",e=>{s(r.wrap(a.result),e.oldVersion,e.newVersion,r.wrap(a.transaction),e)}),n&&a.addEventListener("blocked",e=>n(e.oldVersion,e.newVersion,e)),f.then(e=>{i&&e.addEventListener("close",()=>i()),o&&e.addEventListener("versionchange",e=>o(e.oldVersion,e.newVersion,e))}).catch(()=>{}),f}}}},{package:"@metamask/notification-services-controller>firebase>@firebase/app>idb",file:"node_modules/idb/build/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/idb/build/wrap-idb-value.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=(e,t)=>t.some(t=>e instanceof t);let s,o;const i=new WeakMap,a=new WeakMap,f=new WeakMap,u=new WeakMap,l=new WeakMap;let d={get(e,t,n){if(e instanceof IDBTransaction){if("done"===t)return a.get(e);if("objectStoreNames"===t)return e.objectStoreNames||f.get(e);if("store"===t)return n.objectStoreNames[1]?undefined:n.objectStore(n.objectStoreNames[0])}return h(e[t])},set:(e,t,n)=>(e[t]=n,!0),has:(e,t)=>e instanceof IDBTransaction&&("done"===t||"store"===t)||t in e};function c(e){return e!==IDBDatabase.prototype.transaction||"objectStoreNames"in IDBTransaction.prototype?(o||(o=[IDBCursor.prototype.advance,IDBCursor.prototype.continue,IDBCursor.prototype.continuePrimaryKey])).includes(e)?function(...t){return e.apply(b(this),t),h(i.get(this))}:function(...t){return h(e.apply(b(this),t))}:function(t,...n){const r=e.call(b(this),t,...n);return f.set(r,t.sort?t.sort():[t]),h(r)}}function m(e){return"function"==typeof e?c(e):(e instanceof IDBTransaction&&function(e){if(a.has(e))return;const t=new Promise((t,n)=>{const r=()=>{e.removeEventListener("complete",s),e.removeEventListener("error",o),e.removeEventListener("abort",o)},s=()=>{t(),r()},o=()=>{n(e.error||new DOMException("AbortError","AbortError")),r()};e.addEventListener("complete",s),e.addEventListener("error",o),e.addEventListener("abort",o)});a.set(e,t)}(e),r(e,s||(s=[IDBDatabase,IDBObjectStore,IDBIndex,IDBCursor,IDBTransaction]))?new Proxy(e,d):e)}function h(e){if(e instanceof IDBRequest)return function(e){const t=new Promise((t,n)=>{const r=()=>{e.removeEventListener("success",s),e.removeEventListener("error",o)},s=()=>{t(h(e.result)),r()},o=()=>{n(e.error),r()};e.addEventListener("success",s),e.addEventListener("error",o)});return t.then(t=>{t instanceof IDBCursor&&i.set(t,e)}).catch(()=>{}),l.set(t,e),t}(e);if(u.has(e))return u.get(e);const t=m(e);return t!==e&&(u.set(e,t),l.set(t,e)),t}const b=e=>l.get(e);n.instanceOfAny=r,n.replaceTraps=function(e){d=e(d)},n.reverseTransformCache=l,n.unwrap=b,n.wrap=h}}},{package:"@metamask/notification-services-controller>firebase>@firebase/app>idb",file:"node_modules/idb/build/wrap-idb-value.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/is-retry-allowed/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=new Set(["ENOTFOUND","ENETUNREACH","UNABLE_TO_GET_ISSUER_CERT","UNABLE_TO_GET_CRL","UNABLE_TO_DECRYPT_CERT_SIGNATURE","UNABLE_TO_DECRYPT_CRL_SIGNATURE","UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY","CERT_SIGNATURE_FAILURE","CRL_SIGNATURE_FAILURE","CERT_NOT_YET_VALID","CERT_HAS_EXPIRED","CRL_NOT_YET_VALID","CRL_HAS_EXPIRED","ERROR_IN_CERT_NOT_BEFORE_FIELD","ERROR_IN_CERT_NOT_AFTER_FIELD","ERROR_IN_CRL_LAST_UPDATE_FIELD","ERROR_IN_CRL_NEXT_UPDATE_FIELD","OUT_OF_MEM","DEPTH_ZERO_SELF_SIGNED_CERT","SELF_SIGNED_CERT_IN_CHAIN","UNABLE_TO_GET_ISSUER_CERT_LOCALLY","UNABLE_TO_VERIFY_LEAF_SIGNATURE","CERT_CHAIN_TOO_LONG","CERT_REVOKED","INVALID_CA","PATH_LENGTH_EXCEEDED","INVALID_PURPOSE","CERT_UNTRUSTED","CERT_REJECTED","HOSTNAME_MISMATCH"]);t.exports=e=>!r.has(e&&e.code)}}},{package:"is-retry-allowed",file:"node_modules/is-retry-allowed/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/is-url/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){if("string"!=typeof e)return!1;var t=e.match(r);if(!t)return!1;var n=t[1];if(!n)return!1;if(s.test(n)||o.test(n))return!0;return!1};var r=/^(?:\w+:)?\/\/(\S+)$/,s=/^localhost[\:?\d]*(?:[^\:?\d]\S*)?$/,o=/^[^\s\.]+\.\S{2,}$/}}},{package:"@open-rpc/schema-utils-js>is-url",file:"node_modules/is-url/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/iso-url/index.js",{"./src/relative":"/home/runner/work/metamask-extension/metamask-extension/node_modules/iso-url/src/relative.js","./src/url":"/home/runner/work/metamask-extension/metamask-extension/node_modules/iso-url/src/url-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{URLWithLegacySupport:r,format:s,URLSearchParams:o,defaultBase:i}=e("./src/url"),a=e("./src/relative");t.exports={URL:r,URLSearchParams:o,format:s,relative:a,defaultBase:i}}}},{package:"eth-lattice-keyring>gridplus-sdk>borc>iso-url",file:"node_modules/iso-url/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/iso-url/src/relative.js",{"./url":"/home/runner/work/metamask-extension/metamask-extension/node_modules/iso-url/src/url-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{URLWithLegacySupport:r,format:s}=e("./url");t.exports=(e,t={},n={},o)=>{let i,a=t.protocol?t.protocol.replace(":",""):"http";a=(n[a]||o||a)+":";try{i=new r(e)}catch(e){i={}}const f=Object.assign({},t,{protocol:a||i.protocol,host:t.host||i.host});return new r(e,s(f)).toString()}}}},{package:"eth-lattice-keyring>gridplus-sdk>borc>iso-url",file:"node_modules/iso-url/src/relative.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/iso-url/src/url-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=self.location?self.location.protocol+"//"+self.location.host:"",s=self.URL;t.exports={URLWithLegacySupport:class{constructor(e="",t=r){this.super=new s(e,t),this.path=this.pathname+this.search,this.auth=this.username&&this.password?this.username+":"+this.password:null,this.query=this.search&&this.search.startsWith("?")?this.search.slice(1):null}get hash(){return this.super.hash}get host(){return this.super.host}get hostname(){return this.super.hostname}get href(){return this.super.href}get origin(){return this.super.origin}get password(){return this.super.password}get pathname(){return this.super.pathname}get port(){return this.super.port}get protocol(){return this.super.protocol}get search(){return this.super.search}get searchParams(){return this.super.searchParams}get username(){return this.super.username}set hash(e){this.super.hash=e}set host(e){this.super.host=e}set hostname(e){this.super.hostname=e}set href(e){this.super.href=e}set origin(e){this.super.origin=e}set password(e){this.super.password=e}set pathname(e){this.super.pathname=e}set port(e){this.super.port=e}set protocol(e){this.super.protocol=e}set search(e){this.super.search=e}set searchParams(e){this.super.searchParams=e}set username(e){this.super.username=e}createObjectURL(e){return this.super.createObjectURL(e)}revokeObjectURL(e){this.super.revokeObjectURL(e)}toJSON(){return this.super.toJSON()}toString(){return this.super.toString()}format(){return this.toString()}},URLSearchParams:self.URLSearchParams,defaultBase:r,format:function(e){if("string"==typeof e){return new s(e).toString()}if(!(e instanceof s)){const t=e.username&&e.password?`${e.username}:${e.password}@`:"",n=e.auth?e.auth+"@":"",r=e.port?":"+e.port:"",s=e.protocol?e.protocol+"//":"",o=e.host||"",i=e.hostname||"",a=e.search||(e.query?"?"+e.query:""),f=e.hash||"",u=e.pathname||"";return`${s}${t||n}${o||i+r}${e.path||u+a}${f}`}}}}}},{package:"eth-lattice-keyring>gridplus-sdk>borc>iso-url",file:"node_modules/iso-url/src/url-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/isomorphic-fetch/fetch-npm-browserify.js",{"whatwg-fetch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/whatwg-fetch/dist/fetch.umd.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){e("whatwg-fetch"),t.exports=self.fetch.bind(self)}}},{package:"@open-rpc/test-coverage>isomorphic-fetch",file:"node_modules/isomorphic-fetch/fetch-npm-browserify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/join-component/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e,t,n){return t=t||"and",n=n||", ",e.length<2?e[0]||"":(t.slice(0,2)===n?2==e.length&&(t=t.slice(1)):t=" "+t,e.slice(0,-1).join(n)+t+" "+e[e.length-1])}}}},{package:"@segment/loosely-validate-event>join-component",file:"node_modules/join-component/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/js-base64/base64.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){!function(e,r){var s,o;"object"==typeof n&&void 0!==t?t.exports=r():"function"==typeof define&&define.amd?define(r):(s=e.Base64,(o=r()).noConflict=function(){return e.Base64=s,o},e.Meteor&&(Base64=o),e.Base64=o)}("undefined"!=typeof self?self:"undefined"!=typeof window?window:"undefined"!=typeof global?global:this,function(){var t,n="3.7.7",r=n,s="function"==typeof e,o="function"==typeof TextDecoder?new TextDecoder:undefined,i="function"==typeof TextEncoder?new TextEncoder:undefined,a=Array.prototype.slice.call("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="),f=(t={},a.forEach(function(e,n){return t[e]=n}),t),u=/^(?:[A-Za-z\d+\/]{4})*?(?:[A-Za-z\d+\/]{2}(?:==)?|[A-Za-z\d+\/]{3}=?)?$/,l=String.fromCharCode.bind(String),d="function"==typeof Uint8Array.from?Uint8Array.from.bind(Uint8Array):function(e){return new Uint8Array(Array.prototype.slice.call(e,0))},c=function(e){return e.replace(/=/g,"").replace(/[+\/]/g,function(e){return"+"==e?"-":"_"})},m=function(e){return e.replace(/[^A-Za-z0-9\+\/]/g,"")},h=function(e){for(var t,n,r,s,o="",i=e.length%3,f=0;f<e.length;){if((n=e.charCodeAt(f++))>255||(r=e.charCodeAt(f++))>255||(s=e.charCodeAt(f++))>255)throw new TypeError("invalid character found");o+=a[(t=n<<16|r<<8|s)>>18&63]+a[t>>12&63]+a[t>>6&63]+a[63&t]}return i?o.slice(0,i-3)+"===".substring(i):o},b="function"==typeof btoa?function(e){return btoa(e)}:s?function(t){return e.from(t,"binary").toString("base64")}:h,p=s?function(t){return e.from(t).toString("base64")}:function(e){for(var t=[],n=0,r=e.length;n<r;n+=4096)t.push(l.apply(null,e.subarray(n,n+4096)));return b(t.join(""))},k=function(e,t){return void 0===t&&(t=!1),t?c(p(e)):p(e)},x=function(e){if(e.length<2)return(t=e.charCodeAt(0))<128?e:t<2048?l(192|t>>>6)+l(128|63&t):l(224|t>>>12&15)+l(128|t>>>6&63)+l(128|63&t);var t=65536+1024*(e.charCodeAt(0)-55296)+(e.charCodeAt(1)-56320);return l(240|t>>>18&7)+l(128|t>>>12&63)+l(128|t>>>6&63)+l(128|63&t)},j=/[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g,w=function(e){return e.replace(j,x)},g=s?function(t){return e.from(t,"utf8").toString("base64")}:i?function(e){return p(i.encode(e))}:function(e){return b(w(e))},y=function(e,t){return void 0===t&&(t=!1),t?c(g(e)):g(e)},_=function(e){return y(e,!0)},v=/[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3}/g,T=function(e){switch(e.length){case 4:var t=((7&e.charCodeAt(0))<<18|(63&e.charCodeAt(1))<<12|(63&e.charCodeAt(2))<<6|63&e.charCodeAt(3))-65536;return l((t>>>10)+55296)+l(56320+(1023&t));case 3:return l((15&e.charCodeAt(0))<<12|(63&e.charCodeAt(1))<<6|63&e.charCodeAt(2));default:return l((31&e.charCodeAt(0))<<6|63&e.charCodeAt(1))}},S=function(e){return e.replace(v,T)},E=function(e){if(e=e.replace(/\s+/g,""),!u.test(e))throw new TypeError("malformed base64.");e+="==".slice(2-(3&e.length));for(var t,n,r,s="",o=0;o<e.length;)t=f[e.charAt(o++)]<<18|f[e.charAt(o++)]<<12|(n=f[e.charAt(o++)])<<6|(r=f[e.charAt(o++)]),s+=64===n?l(t>>16&255):64===r?l(t>>16&255,t>>8&255):l(t>>16&255,t>>8&255,255&t);return s},O="function"==typeof atob?function(e){return atob(m(e))}:s?function(t){return e.from(t,"base64").toString("binary")}:E,A=s?function(t){return d(e.from(t,"base64"))}:function(e){return d(O(e).split("").map(function(e){return e.charCodeAt(0)}))},C=function(e){return A(I(e))},P=s?function(t){return e.from(t,"base64").toString("utf8")}:o?function(e){return o.decode(A(e))}:function(e){return S(O(e))},I=function(e){return m(e.replace(/[-_]/g,function(e){return"-"==e?"+":"/"}))},M=function(e){return P(I(e))},R=function(e){return{value:e,enumerable:!1,writable:!0,configurable:!0}},L=function(){var e=function(e,t){return Object.defineProperty(String.prototype,e,R(t))};e("fromBase64",function(){return M(this)}),e("toBase64",function(e){return y(this,e)}),e("toBase64URI",function(){return y(this,!0)}),e("toBase64URL",function(){return y(this,!0)}),e("toUint8Array",function(){return C(this)})},B=function(){var e=function(e,t){return Object.defineProperty(Uint8Array.prototype,e,R(t))};e("toBase64",function(e){return k(this,e)}),e("toBase64URI",function(){return k(this,!0)}),e("toBase64URL",function(){return k(this,!0)})},F={version:n,VERSION:r,atob:O,atobPolyfill:E,btoa:b,btoaPolyfill:h,fromBase64:M,toBase64:y,encode:y,encodeURI:_,encodeURL:_,utob:w,btou:S,decode:M,isValid:function(e){if("string"!=typeof e)return!1;var t=e.replace(/\s+/g,"").replace(/={0,2}$/,"");return!/[^\s0-9a-zA-Z\+/]/.test(t)||!/[^\s0-9a-zA-Z\-_]/.test(t)},fromUint8Array:k,toUint8Array:C,extendString:L,extendUint8Array:B,extendBuiltins:function(){L(),B()},Base64:{}};return Object.keys(F).forEach(function(e){return F.Base64[e]=F[e]}),F})}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@ensdomains/content-hash>js-base64",file:"node_modules/js-base64/base64.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_baseInRange.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=Math.max,s=Math.min;t.exports=function(e,t,n){return e>=s(t,n)&&e<r(t,n)}}}},{package:"lodash",file:"node_modules/lodash/_baseInRange.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_baseTrim.js",{"./_trimmedEndIndex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_trimmedEndIndex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./_trimmedEndIndex"),s=/^\s+/;t.exports=function(e){return e?e.slice(0,r(e)+1).replace(s,""):e}}}},{package:"lodash",file:"node_modules/lodash/_baseTrim.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_trimmedEndIndex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=/\s/;t.exports=function(e){for(var t=e.length;t--&&r.test(e.charAt(t)););return t}}}},{package:"lodash",file:"node_modules/lodash/_trimmedEndIndex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/inRange.js",{"./_baseInRange":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_baseInRange.js","./toFinite":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toFinite.js","./toNumber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toNumber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./_baseInRange"),s=e("./toFinite"),o=e("./toNumber");t.exports=function(e,t,n){return t=s(t),n===undefined?(n=t,t=0):n=s(n),e=o(e),r(e,t,n)}}}},{package:"lodash",file:"node_modules/lodash/inRange.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isEmpty.js",{"./_baseKeys":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_baseKeys.js","./_getTag":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_getTag.js","./_isPrototype":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_isPrototype.js","./isArguments":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isArguments.js","./isArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isArray.js","./isArrayLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isArrayLike.js","./isBuffer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isBuffer.js","./isTypedArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isTypedArray.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./_baseKeys"),s=e("./_getTag"),o=e("./isArguments"),i=e("./isArray"),a=e("./isArrayLike"),f=e("./isBuffer"),u=e("./_isPrototype"),l=e("./isTypedArray"),d=Object.prototype.hasOwnProperty;t.exports=function(e){if(null==e)return!0;if(a(e)&&(i(e)||"string"==typeof e||"function"==typeof e.splice||f(e)||l(e)||o(e)))return!e.length;var t=s(e);if("[object Map]"==t||"[object Set]"==t)return!e.size;if(u(e))return!r(e).length;for(var n in e)if(d.call(e,n))return!1;return!0}}}},{package:"lodash",file:"node_modules/lodash/isEmpty.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isInteger.js",{"./toInteger":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toInteger.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./toInteger");t.exports=function(e){return"number"==typeof e&&e==r(e)}}}},{package:"lodash",file:"node_modules/lodash/isInteger.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isSymbol.js",{"./_baseGetTag":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_baseGetTag.js","./isObjectLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isObjectLike.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./_baseGetTag"),s=e("./isObjectLike");t.exports=function(e){return"symbol"==typeof e||s(e)&&"[object Symbol]"==r(e)}}}},{package:"lodash",file:"node_modules/lodash/isSymbol.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toFinite.js",{"./toNumber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toNumber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./toNumber"),s=1/0;t.exports=function(e){return e?(e=r(e))===s||e===-1/0?17976931348623157e292*(e<0?-1:1):e==e?e:0:0===e?e:0}}}},{package:"lodash",file:"node_modules/lodash/toFinite.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toInteger.js",{"./toFinite":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toFinite.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./toFinite");t.exports=function(e){var t=r(e),n=t%1;return t==t?n?t-n:t:0}}}},{package:"lodash",file:"node_modules/lodash/toInteger.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/toNumber.js",{"./_baseTrim":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/_baseTrim.js","./isObject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isObject.js","./isSymbol":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/isSymbol.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./_baseTrim"),s=e("./isObject"),o=e("./isSymbol"),i=0/0,a=/^[-+]0x[0-9a-f]+$/i,f=/^0b[01]+$/i,u=/^0o[0-7]+$/i,l=parseInt;t.exports=function(e){if("number"==typeof e)return e;if(o(e))return i;if(s(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=s(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=r(e);var n=f.test(e);return n||u.test(e)?l(e.slice(2),n?2:8):a.test(e)?i:+e}}}},{package:"lodash",file:"node_modules/lodash/toNumber.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/base.js",{"./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/util.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{encodeText:r}=e("./util");t.exports=class{constructor(e,t,n,s){this.name=e,this.code=t,this.codeBuf=r(this.code),this.alphabet=s,this.codec=n(s)}encode(e){return this.codec.encode(e)}decode(e){for(const t of e)if(this.alphabet&&this.alphabet.indexOf(t)<0)throw new Error(`invalid character '${t}' in '${e}'`);return this.codec.decode(e)}}}}},{package:"@ensdomains/content-hash>cids>multibase",file:"node_modules/multibase/src/base.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/constants.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/base.js","./rfc4648":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/rfc4648.js","./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/util.js","@multiformats/base-x":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@multiformats/base-x/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("@multiformats/base-x"),s=e("./base.js"),{rfc4648:o}=e("./rfc4648"),{decodeText:i,encodeText:a}=e("./util"),f=[["identity","\0",()=>({encode:i,decode:a}),""],["base2","0",o(1),"01"],["base8","7",o(3),"01234567"],["base10","9",r,"0123456789"],["base16","f",o(4),"0123456789abcdef"],["base16upper","F",o(4),"0123456789ABCDEF"],["base32hex","v",o(5),"0123456789abcdefghijklmnopqrstuv"],["base32hexupper","V",o(5),"0123456789ABCDEFGHIJKLMNOPQRSTUV"],["base32hexpad","t",o(5),"0123456789abcdefghijklmnopqrstuv="],["base32hexpadupper","T",o(5),"0123456789ABCDEFGHIJKLMNOPQRSTUV="],["base32","b",o(5),"abcdefghijklmnopqrstuvwxyz234567"],["base32upper","B",o(5),"ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"],["base32pad","c",o(5),"abcdefghijklmnopqrstuvwxyz234567="],["base32padupper","C",o(5),"ABCDEFGHIJKLMNOPQRSTUVWXYZ234567="],["base32z","h",o(5),"ybndrfg8ejkmcpqxot1uwisza345h769"],["base36","k",r,"0123456789abcdefghijklmnopqrstuvwxyz"],["base36upper","K",r,"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"],["base58btc","z",r,"123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"],["base58flickr","Z",r,"123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"],["base64","m",o(6),"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"],["base64pad","M",o(6),"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="],["base64url","u",o(6),"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"],["base64urlpad","U",o(6),"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_="]],u=f.reduce((e,t)=>(e[t[0]]=new s(t[0],t[1],t[2],t[3]),e),{}),l=f.reduce((e,t)=>(e[t[1]]=u[t[0]],e),{});t.exports={names:u,codes:l}}}},{package:"@ensdomains/content-hash>cids>multibase",file:"node_modules/multibase/src/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/index.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/constants.js","./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/util.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("./constants"),{encodeText:s,decodeText:o,concat:i}=e("./util");function a(e){if(Object.prototype.hasOwnProperty.call(r.names,e))return r.names[e];if(Object.prototype.hasOwnProperty.call(r.codes,e))return r.codes[e];throw new Error(`Unsupported encoding: ${e}`)}(n=t.exports=function(e,t){if(!t)throw new Error("requires an encoded Uint8Array");const{name:n,codeBuf:r}=a(e);return function(e,t){const n=a(e);n.decode(o(t))}(n,t),i([r,t],r.length+t.length)}).encode=function(e,t){const n=a(e),r=s(n.encode(t));return i([n.codeBuf,r],n.codeBuf.length+r.length)},n.decode=function(e){e instanceof Uint8Array&&(e=o(e));const t=e[0];return["f","F","v","V","t","T","b","B","c","C","h","k","K"].includes(t)&&(e=e.toLowerCase()),a(e[0]).decode(e.substring(1))},n.isEncoded=function(e){if(e instanceof Uint8Array&&(e=o(e)),"[object String]"!==Object.prototype.toString.call(e))return!1;try{return a(e[0]).name}catch(e){return!1}},n.encoding=a,n.encodingFromData=function(e){return e instanceof Uint8Array&&(e=o(e)),a(e[0])};const f=Object.freeze(r.names),u=Object.freeze(r.codes);n.names=f,n.codes=u}}},{package:"@ensdomains/content-hash>cids>multibase",file:"node_modules/multibase/src/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/rfc4648.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={rfc4648:e=>t=>({encode:n=>((e,t,n)=>{const r="="===t[t.length-1],s=(1<<n)-1;let o="",i=0,a=0;for(let r=0;r<e.length;++r)for(a=a<<8|e[r],i+=8;i>n;)i-=n,o+=t[s&a>>i];if(i&&(o+=t[s&a<<n-i]),r)for(;o.length*n&7;)o+="=";return o})(n,t,e),decode:n=>((e,t,n)=>{const r={};for(let e=0;e<t.length;++e)r[t[e]]=e;let s=e.length;for(;"="===e[s-1];)--s;const o=new Uint8Array(s*n/8|0);let i=0,a=0,f=0;for(let t=0;t<s;++t){const s=r[e[t]];if(s===undefined)throw new SyntaxError("Invalid character "+e[t]);a=a<<n|s,i+=n,i>=8&&(i-=8,o[f++]=255&a>>i)}if(i>=n||255&a<<8-i)throw new SyntaxError("Unexpected end of data");return o})(n,t,e)})}}}},{package:"@ensdomains/content-hash>cids>multibase",file:"node_modules/multibase/src/rfc4648.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/util.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=new TextDecoder,s=new TextEncoder;t.exports={decodeText:e=>r.decode(e),encodeText:e=>s.encode(e),concat:function(e,t){const n=new Uint8Array(t);let r=0;for(const t of e)n.set(t,r),r+=t.length;return n}}}}},{package:"@ensdomains/content-hash>cids>multibase",file:"node_modules/multibase/src/util.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/alloc.js",{"./util/as-uint8array.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/as-uint8array.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./util/as-uint8array.js");n.alloc=function(e=0){return null!=globalThis.Buffer&&null!=globalThis.Buffer.alloc?r.asUint8Array(globalThis.Buffer.alloc(e)):new Uint8Array(e)},n.allocUnsafe=function(e=0){return null!=globalThis.Buffer&&null!=globalThis.Buffer.allocUnsafe?r.asUint8Array(globalThis.Buffer.allocUnsafe(e)):new Uint8Array(e)}}}},{package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules/multicodec/node_modules/uint8arrays/cjs/src/alloc.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/concat.js",{"./alloc.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/alloc.js","./util/as-uint8array.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/as-uint8array.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./alloc.js"),s=e("./util/as-uint8array.js");n.concat=function(e,t){t||(t=e.reduce((e,t)=>e+t.length,0));const n=r.allocUnsafe(t);let o=0;for(const t of e)n.set(t,o),o+=t.length;return s.asUint8Array(n)}}}},{package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules/multicodec/node_modules/uint8arrays/cjs/src/concat.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/from-string.js",{"./util/as-uint8array.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/as-uint8array.js","./util/bases.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/bases.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./util/bases.js"),s=e("./util/as-uint8array.js");n.fromString=function(e,t="utf8"){const n=r[t];if(!n)throw new Error(`Unsupported encoding "${t}"`);return"utf8"!==t&&"utf-8"!==t||null==globalThis.Buffer||null==globalThis.Buffer.from?n.decoder.decode(`${n.prefix}${e}`):s.asUint8Array(globalThis.Buffer.from(e,"utf-8"))}}}},{package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules/multicodec/node_modules/uint8arrays/cjs/src/from-string.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/to-string.js",{"./util/bases.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/bases.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./util/bases.js");n.toString=function(e,t="utf8"){const n=r[t];if(!n)throw new Error(`Unsupported encoding "${t}"`);return"utf8"!==t&&"utf-8"!==t||null==globalThis.Buffer||null==globalThis.Buffer.from?n.encoder.encode(e).substring(1):globalThis.Buffer.from(e.buffer,e.byteOffset,e.byteLength).toString("utf8")}}}},{package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules/multicodec/node_modules/uint8arrays/cjs/src/to-string.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/as-uint8array.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.asUint8Array=function(e){return null!=globalThis.Buffer?new Uint8Array(e.buffer,e.byteOffset,e.byteLength):e}}}},{package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/as-uint8array.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/bases.js",{"../alloc.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/alloc.js","multiformats/basics":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/basics.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("multiformats/basics"),s=e("../alloc.js");function o(e,t,n,r){return{name:e,prefix:t,encoder:{name:e,prefix:t,encode:n},decoder:{decode:r}}}const i=o("utf8","u",e=>"u"+new TextDecoder("utf8").decode(e),e=>(new TextEncoder).encode(e.substring(1))),a=o("ascii","a",e=>{let t="a";for(let n=0;n<e.length;n++)t+=String.fromCharCode(e[n]);return t},e=>{e=e.substring(1);const t=s.allocUnsafe(e.length);for(let n=0;n<e.length;n++)t[n]=e.charCodeAt(n);return t}),f={utf8:i,"utf-8":i,hex:r.bases.base16,latin1:a,ascii:a,binary:a,...r.bases};t.exports=f}}},{package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules/multicodec/node_modules/uint8arrays/cjs/src/util/bases.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/generated-table.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=Object.freeze({identity:0,cidv1:1,cidv2:2,cidv3:3,ip4:4,tcp:6,sha1:17,"sha2-256":18,"sha2-512":19,"sha3-512":20,"sha3-384":21,"sha3-256":22,"sha3-224":23,"shake-128":24,"shake-256":25,"keccak-224":26,"keccak-256":27,"keccak-384":28,"keccak-512":29,blake3:30,dccp:33,"murmur3-128":34,"murmur3-32":35,ip6:41,ip6zone:42,path:47,multicodec:48,multihash:49,multiaddr:50,multibase:51,dns:53,dns4:54,dns6:55,dnsaddr:56,protobuf:80,cbor:81,raw:85,"dbl-sha2-256":86,rlp:96,bencode:99,"dag-pb":112,"dag-cbor":113,"libp2p-key":114,"git-raw":120,"torrent-info":123,"torrent-file":124,"leofcoin-block":129,"leofcoin-tx":130,"leofcoin-pr":131,sctp:132,"dag-jose":133,"dag-cose":134,"eth-block":144,"eth-block-list":145,"eth-tx-trie":146,"eth-tx":147,"eth-tx-receipt-trie":148,"eth-tx-receipt":149,"eth-state-trie":150,"eth-account-snapshot":151,"eth-storage-trie":152,"eth-receipt-log-trie":153,"eth-reciept-log":154,"bitcoin-block":176,"bitcoin-tx":177,"bitcoin-witness-commitment":178,"zcash-block":192,"zcash-tx":193,"caip-50":202,streamid:206,"stellar-block":208,"stellar-tx":209,md4:212,md5:213,bmt:214,"decred-block":224,"decred-tx":225,"ipld-ns":226,"ipfs-ns":227,"swarm-ns":228,"ipns-ns":229,zeronet:230,"secp256k1-pub":231,"bls12_381-g1-pub":234,"bls12_381-g2-pub":235,"x25519-pub":236,"ed25519-pub":237,"bls12_381-g1g2-pub":238,"dash-block":240,"dash-tx":241,"swarm-manifest":250,"swarm-feed":251,udp:273,"p2p-webrtc-star":275,"p2p-webrtc-direct":276,"p2p-stardust":277,"p2p-circuit":290,"dag-json":297,udt:301,utp:302,unix:400,thread:406,p2p:421,ipfs:421,https:443,onion:444,onion3:445,garlic64:446,garlic32:447,tls:448,noise:454,quic:460,ws:477,wss:478,"p2p-websocket-star":479,http:480,"swhid-1-snp":496,json:512,messagepack:513,"libp2p-peer-record":769,"libp2p-relay-rsvp":770,"car-index-sorted":1024,"sha2-256-trunc254-padded":4114,"ripemd-128":4178,"ripemd-160":4179,"ripemd-256":4180,"ripemd-320":4181,x11:4352,"p256-pub":4608,"p384-pub":4609,"p521-pub":4610,"ed448-pub":4611,"x448-pub":4612,"ed25519-priv":4864,"secp256k1-priv":4865,"x25519-priv":4866,kangarootwelve:7425,"sm3-256":21325,"blake2b-8":45569,"blake2b-16":45570,"blake2b-24":45571,"blake2b-32":45572,"blake2b-40":45573,"blake2b-48":45574,"blake2b-56":45575,"blake2b-64":45576,"blake2b-72":45577,"blake2b-80":45578,"blake2b-88":45579,"blake2b-96":45580,"blake2b-104":45581,"blake2b-112":45582,"blake2b-120":45583,"blake2b-128":45584,"blake2b-136":45585,"blake2b-144":45586,"blake2b-152":45587,"blake2b-160":45588,"blake2b-168":45589,"blake2b-176":45590,"blake2b-184":45591,"blake2b-192":45592,"blake2b-200":45593,"blake2b-208":45594,"blake2b-216":45595,"blake2b-224":45596,"blake2b-232":45597,"blake2b-240":45598,"blake2b-248":45599,"blake2b-256":45600,"blake2b-264":45601,"blake2b-272":45602,"blake2b-280":45603,"blake2b-288":45604,"blake2b-296":45605,"blake2b-304":45606,"blake2b-312":45607,"blake2b-320":45608,"blake2b-328":45609,"blake2b-336":45610,"blake2b-344":45611,"blake2b-352":45612,"blake2b-360":45613,"blake2b-368":45614,"blake2b-376":45615,"blake2b-384":45616,"blake2b-392":45617,"blake2b-400":45618,"blake2b-408":45619,"blake2b-416":45620,"blake2b-424":45621,"blake2b-432":45622,"blake2b-440":45623,"blake2b-448":45624,"blake2b-456":45625,"blake2b-464":45626,"blake2b-472":45627,"blake2b-480":45628,"blake2b-488":45629,"blake2b-496":45630,"blake2b-504":45631,"blake2b-512":45632,"blake2s-8":45633,"blake2s-16":45634,"blake2s-24":45635,"blake2s-32":45636,"blake2s-40":45637,"blake2s-48":45638,"blake2s-56":45639,"blake2s-64":45640,"blake2s-72":45641,"blake2s-80":45642,"blake2s-88":45643,"blake2s-96":45644,"blake2s-104":45645,"blake2s-112":45646,"blake2s-120":45647,"blake2s-128":45648,"blake2s-136":45649,"blake2s-144":45650,"blake2s-152":45651,"blake2s-160":45652,"blake2s-168":45653,"blake2s-176":45654,"blake2s-184":45655,"blake2s-192":45656,"blake2s-200":45657,"blake2s-208":45658,"blake2s-216":45659,"blake2s-224":45660,"blake2s-232":45661,"blake2s-240":45662,"blake2s-248":45663,"blake2s-256":45664,"skein256-8":45825,"skein256-16":45826,"skein256-24":45827,"skein256-32":45828,"skein256-40":45829,"skein256-48":45830,"skein256-56":45831,"skein256-64":45832,"skein256-72":45833,"skein256-80":45834,"skein256-88":45835,"skein256-96":45836,"skein256-104":45837,"skein256-112":45838,"skein256-120":45839,"skein256-128":45840,"skein256-136":45841,"skein256-144":45842,"skein256-152":45843,"skein256-160":45844,"skein256-168":45845,"skein256-176":45846,"skein256-184":45847,"skein256-192":45848,"skein256-200":45849,"skein256-208":45850,"skein256-216":45851,"skein256-224":45852,"skein256-232":45853,"skein256-240":45854,"skein256-248":45855,"skein256-256":45856,"skein512-8":45857,"skein512-16":45858,"skein512-24":45859,"skein512-32":45860,"skein512-40":45861,"skein512-48":45862,"skein512-56":45863,"skein512-64":45864,"skein512-72":45865,"skein512-80":45866,"skein512-88":45867,"skein512-96":45868,"skein512-104":45869,"skein512-112":45870,"skein512-120":45871,"skein512-128":45872,"skein512-136":45873,"skein512-144":45874,"skein512-152":45875,"skein512-160":45876,"skein512-168":45877,"skein512-176":45878,"skein512-184":45879,"skein512-192":45880,"skein512-200":45881,"skein512-208":45882,"skein512-216":45883,"skein512-224":45884,"skein512-232":45885,"skein512-240":45886,"skein512-248":45887,"skein512-256":45888,"skein512-264":45889,"skein512-272":45890,"skein512-280":45891,"skein512-288":45892,"skein512-296":45893,"skein512-304":45894,"skein512-312":45895,"skein512-320":45896,"skein512-328":45897,"skein512-336":45898,"skein512-344":45899,"skein512-352":45900,"skein512-360":45901,"skein512-368":45902,"skein512-376":45903,"skein512-384":45904,"skein512-392":45905,"skein512-400":45906,"skein512-408":45907,"skein512-416":45908,"skein512-424":45909,"skein512-432":45910,"skein512-440":45911,"skein512-448":45912,"skein512-456":45913,"skein512-464":45914,"skein512-472":45915,"skein512-480":45916,"skein512-488":45917,"skein512-496":45918,"skein512-504":45919,"skein512-512":45920,"skein1024-8":45921,"skein1024-16":45922,"skein1024-24":45923,"skein1024-32":45924,"skein1024-40":45925,"skein1024-48":45926,"skein1024-56":45927,"skein1024-64":45928,"skein1024-72":45929,"skein1024-80":45930,"skein1024-88":45931,"skein1024-96":45932,"skein1024-104":45933,"skein1024-112":45934,"skein1024-120":45935,"skein1024-128":45936,"skein1024-136":45937,"skein1024-144":45938,"skein1024-152":45939,"skein1024-160":45940,"skein1024-168":45941,"skein1024-176":45942,"skein1024-184":45943,"skein1024-192":45944,"skein1024-200":45945,"skein1024-208":45946,"skein1024-216":45947,"skein1024-224":45948,"skein1024-232":45949,"skein1024-240":45950,"skein1024-248":45951,"skein1024-256":45952,"skein1024-264":45953,"skein1024-272":45954,"skein1024-280":45955,"skein1024-288":45956,"skein1024-296":45957,"skein1024-304":45958,"skein1024-312":45959,"skein1024-320":45960,"skein1024-328":45961,"skein1024-336":45962,"skein1024-344":45963,"skein1024-352":45964,"skein1024-360":45965,"skein1024-368":45966,"skein1024-376":45967,"skein1024-384":45968,"skein1024-392":45969,"skein1024-400":45970,"skein1024-408":45971,"skein1024-416":45972,"skein1024-424":45973,"skein1024-432":45974,"skein1024-440":45975,"skein1024-448":45976,"skein1024-456":45977,"skein1024-464":45978,"skein1024-472":45979,"skein1024-480":45980,"skein1024-488":45981,"skein1024-496":45982,"skein1024-504":45983,"skein1024-512":45984,"skein1024-520":45985,"skein1024-528":45986,"skein1024-536":45987,"skein1024-544":45988,"skein1024-552":45989,"skein1024-560":45990,"skein1024-568":45991,"skein1024-576":45992,"skein1024-584":45993,"skein1024-592":45994,"skein1024-600":45995,"skein1024-608":45996,"skein1024-616":45997,"skein1024-624":45998,"skein1024-632":45999,"skein1024-640":46e3,"skein1024-648":46001,"skein1024-656":46002,"skein1024-664":46003,"skein1024-672":46004,"skein1024-680":46005,"skein1024-688":46006,"skein1024-696":46007,"skein1024-704":46008,"skein1024-712":46009,"skein1024-720":46010,"skein1024-728":46011,"skein1024-736":46012,"skein1024-744":46013,"skein1024-752":46014,"skein1024-760":46015,"skein1024-768":46016,"skein1024-776":46017,"skein1024-784":46018,"skein1024-792":46019,"skein1024-800":46020,"skein1024-808":46021,"skein1024-816":46022,"skein1024-824":46023,"skein1024-832":46024,"skein1024-840":46025,"skein1024-848":46026,"skein1024-856":46027,"skein1024-864":46028,"skein1024-872":46029,"skein1024-880":46030,"skein1024-888":46031,"skein1024-896":46032,"skein1024-904":46033,"skein1024-912":46034,"skein1024-920":46035,"skein1024-928":46036,"skein1024-936":46037,"skein1024-944":46038,"skein1024-952":46039,"skein1024-960":46040,"skein1024-968":46041,"skein1024-976":46042,"skein1024-984":46043,"skein1024-992":46044,"skein1024-1000":46045,"skein1024-1008":46046,"skein1024-1016":46047,"skein1024-1024":46048,"poseidon-bls12_381-a2-fc1":46081,"poseidon-bls12_381-a2-fc1-sc":46082,"zeroxcert-imprint-256":52753,"fil-commitment-unsealed":61697,"fil-commitment-sealed":61698,"holochain-adr-v0":8417572,"holochain-adr-v1":8483108,"holochain-key-v0":9728292,"holochain-key-v1":9793828,"holochain-sig-v0":10645796,"holochain-sig-v1":10711332,"skynet-ns":11639056,"arweave-ns":11704592});t.exports={baseTable:r}}}},{package:"@ensdomains/content-hash>multicodec",file:"node_modules/multicodec/src/generated-table.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/index.js",{"./maps":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/maps.js","./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/util.js","uint8arrays/concat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/concat.js",varint:"/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("varint"),{concat:s}=e("uint8arrays/concat"),o=e("./util"),{nameToVarint:i,constantToCode:a,nameToCode:f,codeToName:u}=e("./maps");function l(e){const t=r.decode(e),n=u[t];if(n===undefined)throw new Error(`Code "${t}" not found`);return n}function d(e){return u[e]}function c(e){const t=f[e];if(t===undefined)throw new Error(`Codec "${e}" not found`);return t}function m(e){return r.decode(e)}function h(e){const t=i[e];if(t===undefined)throw new Error(`Codec "${e}" not found`);return t}function b(e){return o.varintEncode(e)}t.exports={addPrefix:function(e,t){let n;if(e instanceof Uint8Array)n=o.varintUint8ArrayEncode(e);else{if(!i[e])throw new Error("multicodec not recognized");n=i[e]}return s([n,t],n.length+t.length)},rmPrefix:function(e){return r.decode(e),e.slice(r.decode.bytes)},getNameFromData:l,getNameFromCode:d,getCodeFromName:c,getCodeFromData:m,getVarintFromName:h,getVarintFromCode:b,getCodec:function(e){return l(e)},getName:function(e){return d(e)},getNumber:function(e){return c(e)},getCode:function(e){return m(e)},getCodeVarint:function(e){return h(e)},getVarint:function(e){return Array.from(b(e))},...a,nameToVarint:i,nameToCode:f,codeToName:u}}}},{package:"@ensdomains/content-hash>multicodec",file:"node_modules/multicodec/src/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/maps.js",{"./generated-table":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/generated-table.js","./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/util.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{baseTable:r}=e("./generated-table"),s=e("./util").varintEncode,o={},i={},a={};for(const e in r){const t=e,n=r[t];o[t]=s(n);i[t.toUpperCase().replace(/-/g,"_")]=n,a[n]||(a[n]=t)}Object.freeze(o),Object.freeze(i),Object.freeze(a);const f=Object.freeze(r);t.exports={nameToVarint:o,constantToCode:i,nameToCode:f,codeToName:a}}}},{package:"@ensdomains/content-hash>multicodec",file:"node_modules/multicodec/src/maps.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/src/util.js",{"uint8arrays/from-string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/from-string.js","uint8arrays/to-string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multicodec/node_modules/uint8arrays/cjs/src/to-string.js",varint:"/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("varint"),{toString:s}=e("uint8arrays/to-string"),{fromString:o}=e("uint8arrays/from-string");function i(e){return parseInt(s(e,"base16"),16)}t.exports={numberToUint8Array:function(e){let t=e.toString(16);t.length%2==1&&(t="0"+t);return o(t,"base16")},uint8ArrayToNumber:i,varintUint8ArrayEncode:function(e){return Uint8Array.from(r.encode(i(e)))},varintEncode:function(e){return Uint8Array.from(r.encode(e))}}}}},{package:"@ensdomains/content-hash>multicodec",file:"node_modules/multicodec/src/util.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base10.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("./base.js").baseX({prefix:"9",name:"base10",alphabet:"0123456789"});n.base10=r}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/base10.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base16.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./base.js");const s=r.rfc4648({prefix:"f",name:"base16",alphabet:"0123456789abcdef",bitsPerChar:4}),o=r.rfc4648({prefix:"F",name:"base16upper",alphabet:"0123456789ABCDEF",bitsPerChar:4});n.base16=s,n.base16upper=o}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/base16.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base2.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("./base.js").rfc4648({prefix:"0",name:"base2",alphabet:"01",bitsPerChar:1});n.base2=r}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/base2.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base256emoji.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./base.js");const s=Array.from("🚀🪐☄🛰🌌🌑🌒🌓🌔🌕🌖🌗🌘🌍🌏🌎🐉☀💻🖥💾💿😂❤😍🤣😊🙏💕😭😘👍😅👏😁🔥🥰💔💖💙😢🤔😆🙄💪😉☺👌🤗💜😔😎😇🌹🤦🎉💞✌✨🤷😱😌🌸🙌😋💗💚😏💛🙂💓🤩😄😀🖤😃💯🙈👇🎶😒🤭❣😜💋👀😪😑💥🙋😞😩😡🤪👊🥳😥🤤👉💃😳✋😚😝😴🌟😬🙃🍀🌷😻😓⭐✅🥺🌈😈🤘💦✔😣🏃💐☹🎊💘😠☝😕🌺🎂🌻😐🖕💝🙊😹🗣💫💀👑🎵🤞😛🔴😤🌼😫⚽🤙☕🏆🤫👈😮🙆🍻🍃🐶💁😲🌿🧡🎁⚡🌞🎈❌✊👋😰🤨😶🤝🚶💰🍓💢🤟🙁🚨💨🤬✈🎀🍺🤓😙💟🌱😖👶🥴▶➡❓💎💸⬇😨🌚🦋😷🕺⚠🙅😟😵👎🤲🤠🤧📌🔵💅🧐🐾🍒😗🤑🌊🤯🐷☎💧😯💆👆🎤🙇🍑❄🌴💣🐸💌📍🥀🤢👅💡💩👐📸👻🤐🤮🎼🥵🚩🍎🍊👼💍📣🥂"),o=s.reduce((e,t,n)=>(e[n]=t,e),[]),i=s.reduce((e,t,n)=>(e[t.codePointAt(0)]=n,e),[]);const a=r.from({prefix:"🚀",name:"base256emoji",encode:function(e){return e.reduce((e,t)=>e+=o[t],"")},decode:function(e){const t=[];for(const n of e){const e=i[n.codePointAt(0)];if(e===undefined)throw new Error(`Non-base256emoji character: ${n}`);t.push(e)}return new Uint8Array(t)}});n.base256emoji=a}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/base256emoji.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base36.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./base.js");const s=r.baseX({prefix:"k",name:"base36",alphabet:"0123456789abcdefghijklmnopqrstuvwxyz"}),o=r.baseX({prefix:"K",name:"base36upper",alphabet:"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"});n.base36=s,n.base36upper=o}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/base36.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base64.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./base.js");const s=r.rfc4648({prefix:"m",name:"base64",alphabet:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",bitsPerChar:6}),o=r.rfc4648({prefix:"M",name:"base64pad",alphabet:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",bitsPerChar:6}),i=r.rfc4648({prefix:"u",name:"base64url",alphabet:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_",bitsPerChar:6}),a=r.rfc4648({prefix:"U",name:"base64urlpad",alphabet:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=",bitsPerChar:6});n.base64=s,n.base64pad=o,n.base64url=i,n.base64urlpad=a}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/base64.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base8.js",{"./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("./base.js").rfc4648({prefix:"7",name:"base8",alphabet:"01234567",bitsPerChar:3});n.base8=r}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/base8.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/identity.js",{"../bytes.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bytes.js","./base.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./base.js"),s=e("../bytes.js");const o=r.from({prefix:"\0",name:"identity",encode:e=>s.toString(e),decode:e=>s.fromString(e)});n.identity=o}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/bases/identity.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/basics.js",{"./bases/base10.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base10.js","./bases/base16.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base16.js","./bases/base2.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base2.js","./bases/base256emoji.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base256emoji.js","./bases/base32.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base32.js","./bases/base36.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base36.js","./bases/base58.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base58.js","./bases/base64.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base64.js","./bases/base8.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/base8.js","./bases/identity.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bases/identity.js","./bytes.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bytes.js","./cid.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/cid.js","./codecs/json.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/codecs/json.js","./codecs/raw.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/codecs/raw.js","./hashes/digest.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/digest.js","./hashes/hasher.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/hasher.js","./hashes/identity.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/identity.js","./hashes/sha2.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/sha2-browser.js","./index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/index.js","./varint.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/varint.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./bases/identity.js"),s=e("./bases/base2.js"),o=e("./bases/base8.js"),i=e("./bases/base10.js"),a=e("./bases/base16.js"),f=e("./bases/base32.js"),u=e("./bases/base36.js"),l=e("./bases/base58.js"),d=e("./bases/base64.js"),c=e("./bases/base256emoji.js"),m=e("./hashes/sha2.js"),h=e("./hashes/identity.js"),b=e("./codecs/raw.js"),p=e("./codecs/json.js");e("./index.js");var k=e("./cid.js"),x=e("./hashes/hasher.js"),j=e("./hashes/digest.js"),w=e("./varint.js"),g=e("./bytes.js");const y={...r,...s,...o,...i,...a,...f,...u,...l,...d,...c},_={...m,...h},v={raw:b,json:p};n.CID=k.CID,n.hasher=x,n.digest=j,n.varint=w,n.bytes=g,n.bases=y,n.codecs=v,n.hashes=_}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/basics.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/codecs/json.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=new TextEncoder,s=new TextDecoder;n.code=512,n.decode=e=>JSON.parse(s.decode(e)),n.encode=e=>r.encode(JSON.stringify(e)),n.name="json"}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/codecs/json.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/codecs/raw.js",{"../bytes.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bytes.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("../bytes.js");n.code=85,n.decode=e=>r.coerce(e),n.encode=e=>r.coerce(e),n.name="raw"}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/codecs/raw.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/hasher.js",{"./digest.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/digest.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./digest.js");class s{constructor(e,t,n){this.name=e,this.code=t,this.encode=n}digest(e){if(e instanceof Uint8Array){const t=this.encode(e);return t instanceof Uint8Array?r.create(this.code,t):t.then(e=>r.create(this.code,e))}throw Error("Unknown type, must be binary type")}}n.Hasher=s,n.from=({name:e,code:t,encode:n})=>new s(e,t,n)}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/hashes/hasher.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/identity.js",{"../bytes.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bytes.js","./digest.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/digest.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("../bytes.js"),s=e("./digest.js");const o=r.coerce,i={code:0,name:"identity",encode:o,digest:e=>s.create(0,o(e))};n.identity=i}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/hashes/identity.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/sha2-browser.js",{"./hasher.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/hasher.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./hasher.js");const s=e=>async t=>new Uint8Array(await crypto.subtle.digest(e,t)),o=r.from({name:"sha2-256",code:18,encode:s("SHA-256")}),i=r.from({name:"sha2-512",code:19,encode:s("SHA-512")});n.sha256=o,n.sha512=i}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/hashes/sha2-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/index.js",{"./bytes.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/bytes.js","./cid.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/cid.js","./hashes/digest.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/digest.js","./hashes/hasher.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/hashes/hasher.js","./varint.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multiformats/cjs/src/varint.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./cid.js"),s=e("./varint.js"),o=e("./bytes.js"),i=e("./hashes/hasher.js"),a=e("./hashes/digest.js");n.CID=r.CID,n.varint=s,n.bytes=o,n.hasher=i,n.digest=a}}},{package:"@metamask/assets-controllers>multiformats",file:"node_modules/multiformats/cjs/src/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/uint8arrays/concat.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e,t){t||(t=e.reduce((e,t)=>e+t.length,0));const n=new Uint8Array(t);let r=0;for(const t of e)n.set(t,r),r+=t.length;return n}}}},{package:"@ensdomains/content-hash>cids>multihashes>uint8arrays",file:"node_modules/multihashes/node_modules/uint8arrays/concat.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/uint8arrays/from-string.js",{multibase:"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{encoding:r}=e("multibase"),s=new TextEncoder;t.exports=function(e,t="utf8"){return"utf8"===t||"utf-8"===t?s.encode(e):"ascii"===t?function(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)t[n]=e.charCodeAt(n);return t}(e):r(t).decode(e)}}}},{package:"@ensdomains/content-hash>cids>multihashes>uint8arrays",file:"node_modules/multihashes/node_modules/uint8arrays/from-string.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/uint8arrays/to-string.js",{multibase:"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{encoding:r}=e("multibase"),s=new TextDecoder("utf8");t.exports=function(e,t="utf8"){return"utf8"===t||"utf-8"===t?s.decode(e):"ascii"===t?function(e){let t="";for(let n=0;n<e.length;n++)t+=String.fromCharCode(e[n]);return t}(e):r(t).encode(e)}}}},{package:"@ensdomains/content-hash>cids>multihashes>uint8arrays",file:"node_modules/multihashes/node_modules/uint8arrays/to-string.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/decode.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function e(t,n){var o,i=0,a=0,f=n=n||0,u=t.length;do{if(f>=u)throw e.bytes=0,new RangeError("Could not decode varint");o=t[f++],i+=a<28?(o&s)<<a:(o&s)*Math.pow(2,a),a+=7}while(o>=r);return e.bytes=f-n,i};var r=128,s=127}}},{package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules/multihashes/node_modules/varint/decode.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/encode.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function e(t,n,i){n=n||[];var a=i=i||0;for(;t>=o;)n[i++]=255&t|r,t/=128;for(;t&s;)n[i++]=255&t|r,t>>>=7;return n[i]=0|t,e.bytes=i-a+1,n};var r=128,s=-128,o=Math.pow(2,31)}}},{package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules/multihashes/node_modules/varint/encode.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/index.js",{"./decode.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/decode.js","./encode.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/encode.js","./length.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/length.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={encode:e("./encode.js"),decode:e("./decode.js"),encodingLength:e("./length.js")}}}},{package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules/multihashes/node_modules/varint/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/length.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=Math.pow(2,7),s=Math.pow(2,14),o=Math.pow(2,21),i=Math.pow(2,28),a=Math.pow(2,35),f=Math.pow(2,42),u=Math.pow(2,49),l=Math.pow(2,56),d=Math.pow(2,63);t.exports=function(e){return e<r?1:e<s?2:e<o?3:e<i?4:e<a?5:e<f?6:e<u?7:e<l?8:e<d?9:10}}}},{package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules/multihashes/node_modules/varint/length.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/src/constants.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=Object.freeze({identity:0,sha1:17,"sha2-256":18,"sha2-512":19,"sha3-512":20,"sha3-384":21,"sha3-256":22,"sha3-224":23,"shake-128":24,"shake-256":25,"keccak-224":26,"keccak-256":27,"keccak-384":28,"keccak-512":29,blake3:30,"murmur3-128":34,"murmur3-32":35,"dbl-sha2-256":86,md4:212,md5:213,bmt:214,"sha2-256-trunc254-padded":4114,"ripemd-128":4178,"ripemd-160":4179,"ripemd-256":4180,"ripemd-320":4181,x11:4352,kangarootwelve:7425,"sm3-256":21325,"blake2b-8":45569,"blake2b-16":45570,"blake2b-24":45571,"blake2b-32":45572,"blake2b-40":45573,"blake2b-48":45574,"blake2b-56":45575,"blake2b-64":45576,"blake2b-72":45577,"blake2b-80":45578,"blake2b-88":45579,"blake2b-96":45580,"blake2b-104":45581,"blake2b-112":45582,"blake2b-120":45583,"blake2b-128":45584,"blake2b-136":45585,"blake2b-144":45586,"blake2b-152":45587,"blake2b-160":45588,"blake2b-168":45589,"blake2b-176":45590,"blake2b-184":45591,"blake2b-192":45592,"blake2b-200":45593,"blake2b-208":45594,"blake2b-216":45595,"blake2b-224":45596,"blake2b-232":45597,"blake2b-240":45598,"blake2b-248":45599,"blake2b-256":45600,"blake2b-264":45601,"blake2b-272":45602,"blake2b-280":45603,"blake2b-288":45604,"blake2b-296":45605,"blake2b-304":45606,"blake2b-312":45607,"blake2b-320":45608,"blake2b-328":45609,"blake2b-336":45610,"blake2b-344":45611,"blake2b-352":45612,"blake2b-360":45613,"blake2b-368":45614,"blake2b-376":45615,"blake2b-384":45616,"blake2b-392":45617,"blake2b-400":45618,"blake2b-408":45619,"blake2b-416":45620,"blake2b-424":45621,"blake2b-432":45622,"blake2b-440":45623,"blake2b-448":45624,"blake2b-456":45625,"blake2b-464":45626,"blake2b-472":45627,"blake2b-480":45628,"blake2b-488":45629,"blake2b-496":45630,"blake2b-504":45631,"blake2b-512":45632,"blake2s-8":45633,"blake2s-16":45634,"blake2s-24":45635,"blake2s-32":45636,"blake2s-40":45637,"blake2s-48":45638,"blake2s-56":45639,"blake2s-64":45640,"blake2s-72":45641,"blake2s-80":45642,"blake2s-88":45643,"blake2s-96":45644,"blake2s-104":45645,"blake2s-112":45646,"blake2s-120":45647,"blake2s-128":45648,"blake2s-136":45649,"blake2s-144":45650,"blake2s-152":45651,"blake2s-160":45652,"blake2s-168":45653,"blake2s-176":45654,"blake2s-184":45655,"blake2s-192":45656,"blake2s-200":45657,"blake2s-208":45658,"blake2s-216":45659,"blake2s-224":45660,"blake2s-232":45661,"blake2s-240":45662,"blake2s-248":45663,"blake2s-256":45664,"skein256-8":45825,"skein256-16":45826,"skein256-24":45827,"skein256-32":45828,"skein256-40":45829,"skein256-48":45830,"skein256-56":45831,"skein256-64":45832,"skein256-72":45833,"skein256-80":45834,"skein256-88":45835,"skein256-96":45836,"skein256-104":45837,"skein256-112":45838,"skein256-120":45839,"skein256-128":45840,"skein256-136":45841,"skein256-144":45842,"skein256-152":45843,"skein256-160":45844,"skein256-168":45845,"skein256-176":45846,"skein256-184":45847,"skein256-192":45848,"skein256-200":45849,"skein256-208":45850,"skein256-216":45851,"skein256-224":45852,"skein256-232":45853,"skein256-240":45854,"skein256-248":45855,"skein256-256":45856,"skein512-8":45857,"skein512-16":45858,"skein512-24":45859,"skein512-32":45860,"skein512-40":45861,"skein512-48":45862,"skein512-56":45863,"skein512-64":45864,"skein512-72":45865,"skein512-80":45866,"skein512-88":45867,"skein512-96":45868,"skein512-104":45869,"skein512-112":45870,"skein512-120":45871,"skein512-128":45872,"skein512-136":45873,"skein512-144":45874,"skein512-152":45875,"skein512-160":45876,"skein512-168":45877,"skein512-176":45878,"skein512-184":45879,"skein512-192":45880,"skein512-200":45881,"skein512-208":45882,"skein512-216":45883,"skein512-224":45884,"skein512-232":45885,"skein512-240":45886,"skein512-248":45887,"skein512-256":45888,"skein512-264":45889,"skein512-272":45890,"skein512-280":45891,"skein512-288":45892,"skein512-296":45893,"skein512-304":45894,"skein512-312":45895,"skein512-320":45896,"skein512-328":45897,"skein512-336":45898,"skein512-344":45899,"skein512-352":45900,"skein512-360":45901,"skein512-368":45902,"skein512-376":45903,"skein512-384":45904,"skein512-392":45905,"skein512-400":45906,"skein512-408":45907,"skein512-416":45908,"skein512-424":45909,"skein512-432":45910,"skein512-440":45911,"skein512-448":45912,"skein512-456":45913,"skein512-464":45914,"skein512-472":45915,"skein512-480":45916,"skein512-488":45917,"skein512-496":45918,"skein512-504":45919,"skein512-512":45920,"skein1024-8":45921,"skein1024-16":45922,"skein1024-24":45923,"skein1024-32":45924,"skein1024-40":45925,"skein1024-48":45926,"skein1024-56":45927,"skein1024-64":45928,"skein1024-72":45929,"skein1024-80":45930,"skein1024-88":45931,"skein1024-96":45932,"skein1024-104":45933,"skein1024-112":45934,"skein1024-120":45935,"skein1024-128":45936,"skein1024-136":45937,"skein1024-144":45938,"skein1024-152":45939,"skein1024-160":45940,"skein1024-168":45941,"skein1024-176":45942,"skein1024-184":45943,"skein1024-192":45944,"skein1024-200":45945,"skein1024-208":45946,"skein1024-216":45947,"skein1024-224":45948,"skein1024-232":45949,"skein1024-240":45950,"skein1024-248":45951,"skein1024-256":45952,"skein1024-264":45953,"skein1024-272":45954,"skein1024-280":45955,"skein1024-288":45956,"skein1024-296":45957,"skein1024-304":45958,"skein1024-312":45959,"skein1024-320":45960,"skein1024-328":45961,"skein1024-336":45962,"skein1024-344":45963,"skein1024-352":45964,"skein1024-360":45965,"skein1024-368":45966,"skein1024-376":45967,"skein1024-384":45968,"skein1024-392":45969,"skein1024-400":45970,"skein1024-408":45971,"skein1024-416":45972,"skein1024-424":45973,"skein1024-432":45974,"skein1024-440":45975,"skein1024-448":45976,"skein1024-456":45977,"skein1024-464":45978,"skein1024-472":45979,"skein1024-480":45980,"skein1024-488":45981,"skein1024-496":45982,"skein1024-504":45983,"skein1024-512":45984,"skein1024-520":45985,"skein1024-528":45986,"skein1024-536":45987,"skein1024-544":45988,"skein1024-552":45989,"skein1024-560":45990,"skein1024-568":45991,"skein1024-576":45992,"skein1024-584":45993,"skein1024-592":45994,"skein1024-600":45995,"skein1024-608":45996,"skein1024-616":45997,"skein1024-624":45998,"skein1024-632":45999,"skein1024-640":46e3,"skein1024-648":46001,"skein1024-656":46002,"skein1024-664":46003,"skein1024-672":46004,"skein1024-680":46005,"skein1024-688":46006,"skein1024-696":46007,"skein1024-704":46008,"skein1024-712":46009,"skein1024-720":46010,"skein1024-728":46011,"skein1024-736":46012,"skein1024-744":46013,"skein1024-752":46014,"skein1024-760":46015,"skein1024-768":46016,"skein1024-776":46017,"skein1024-784":46018,"skein1024-792":46019,"skein1024-800":46020,"skein1024-808":46021,"skein1024-816":46022,"skein1024-824":46023,"skein1024-832":46024,"skein1024-840":46025,"skein1024-848":46026,"skein1024-856":46027,"skein1024-864":46028,"skein1024-872":46029,"skein1024-880":46030,"skein1024-888":46031,"skein1024-896":46032,"skein1024-904":46033,"skein1024-912":46034,"skein1024-920":46035,"skein1024-928":46036,"skein1024-936":46037,"skein1024-944":46038,"skein1024-952":46039,"skein1024-960":46040,"skein1024-968":46041,"skein1024-976":46042,"skein1024-984":46043,"skein1024-992":46044,"skein1024-1000":46045,"skein1024-1008":46046,"skein1024-1016":46047,"skein1024-1024":46048,"poseidon-bls12_381-a2-fc1":46081,"poseidon-bls12_381-a2-fc1-sc":46082});t.exports={names:r}}}},{package:"@ensdomains/content-hash>cids>multihashes",file:"node_modules/multihashes/src/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/src/index.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/src/constants.js",multibase:"/home/runner/work/metamask-extension/metamask-extension/node_modules/multibase/src/index.js","uint8arrays/concat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/uint8arrays/concat.js","uint8arrays/from-string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/uint8arrays/from-string.js","uint8arrays/to-string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/uint8arrays/to-string.js",varint:"/home/runner/work/metamask-extension/metamask-extension/node_modules/multihashes/node_modules/varint/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("multibase"),s=e("varint"),{names:o}=e("./constants"),i=e("uint8arrays/to-string"),a=e("uint8arrays/from-string"),f=e("uint8arrays/concat"),u={};for(const e in o){const t=e;u[o[t]]=t}function l(e){if(!(e instanceof Uint8Array))throw new Error("multihash must be a Uint8Array");if(e.length<2)throw new Error("multihash too short. must be > 2 bytes.");const t=s.decode(e);if(!m(t))throw new Error(`multihash unknown function code: 0x${t.toString(16)}`);e=e.slice(s.decode.bytes);const n=s.decode(e);if(n<0)throw new Error(`multihash invalid length: ${n}`);if((e=e.slice(s.decode.bytes)).length!==n)throw new Error(`multihash length inconsistent: 0x${i(e,"base16")}`);return{code:t,name:u[t],length:n,digest:e}}function d(e){let t=e;if("string"==typeof e){if(o[e]===undefined)throw new Error(`Unrecognized hash function named: ${e}`);t=o[e]}if("number"!=typeof t)throw new Error(`Hash function code should be a number. Got: ${t}`);if(u[t]===undefined&&!c(t))throw new Error(`Unrecognized function code: ${t}`);return t}function c(e){return e>0&&e<16}function m(e){return!!c(e)||!!u[e]}function h(e){l(e)}Object.freeze(u),t.exports={names:o,codes:u,toHexString:function(e){if(!(e instanceof Uint8Array))throw new Error("must be passed a Uint8Array");return i(e,"base16")},fromHexString:function(e){return a(e,"base16")},toB58String:function(e){if(!(e instanceof Uint8Array))throw new Error("must be passed a Uint8Array");return i(r.encode("base58btc",e)).slice(1)},fromB58String:function(e){const t=e instanceof Uint8Array?i(e):e;return r.decode("z"+t)},decode:l,encode:function(e,t,n){if(!e||t===undefined)throw new Error("multihash encode requires at least two args: digest, code");const r=d(t);if(!(e instanceof Uint8Array))throw new Error("digest should be a Uint8Array");if(null==n&&(n=e.length),n&&e.length!==n)throw new Error("digest length should be equal to specified length.");const o=s.encode(r),i=s.encode(n);return f([o,i,e],o.length+i.length+e.length)},coerceCode:d,isAppCode:c,validate:h,prefix:function(e){return h(e),e.subarray(0,2)},isValidCode:m}}}},{package:"@ensdomains/content-hash>cids>multihashes",file:"node_modules/multihashes/src/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/pify/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=(e,t,n,r)=>function(...s){return new(0,t.promiseModule)((o,i)=>{t.multiArgs?s.push((...e)=>{t.errorFirst?e[0]?i(e):(e.shift(),o(e)):o(e)}):t.errorFirst?s.push((e,t)=>{e?i(e):o(t)}):s.push(o);const a=this===n?r:this;Reflect.apply(e,a,s)})},s=new WeakMap;t.exports=(e,t)=>{t={exclude:[/.+(?:Sync|Stream)$/],errorFirst:!0,promiseModule:Promise,...t};const n=typeof e;if(null===e||"object"!==n&&"function"!==n)throw new TypeError(`Expected \`input\` to be a \`Function\` or \`Object\`, got \`${null===e?"null":n}\``);const o=new WeakMap,i=new Proxy(e,{apply(e,n,s){const a=o.get(e);if(a)return Reflect.apply(a,n,s);const f=t.excludeMain?e:r(e,t,i,e);return o.set(e,f),Reflect.apply(f,n,s)},get(e,n){const a=e[n];if(!((e,n)=>{let r=s.get(e);if(r||(r={},s.set(e,r)),n in r)return r[n];const o=e=>"string"==typeof e||"symbol"==typeof n?n===e:e.test(n),i=Reflect.getOwnPropertyDescriptor(e,n),a=i===undefined||i.writable||i.configurable,f=(t.include?t.include.some(o):!t.exclude.some(o))&&a;return r[n]=f,f})(e,n)||a===Function.prototype[n])return a;const f=o.get(a);if(f)return f;if("function"==typeof a){const n=r(a,t,i,e);return o.set(a,n),n}return a}});return i}}}},{package:"pify",file:"node_modules/pify/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/queue-tick/queue-microtask.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports="function"==typeof queueMicrotask?queueMicrotask:e=>Promise.resolve().then(e)}}},{package:"@metamask/snaps-controllers>tar-stream>streamx>queue-tick",file:"node_modules/queue-tick/queue-microtask.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/lib/index.js",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ReadableWebToNodeStream=void 0;const r=e("readable-stream");class s extends r.Readable{constructor(e){super(),this.bytesRead=0,this.released=!1,this.reader=e.getReader()}async _read(){if(this.released)return void this.push(null);this.pendingRead=this.reader.read();const e=await this.pendingRead;delete this.pendingRead,e.done||this.released?this.push(null):(this.bytesRead+=e.value.length,this.push(e.value))}async waitForReadToComplete(){this.pendingRead&&await this.pendingRead}async close(){await this.syncAndRelease()}async syncAndRelease(){this.released=!0,await this.waitForReadToComplete(),await this.reader.releaseLock()}}n.ReadableWebToNodeStream=s}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream",file:"node_modules/readable-web-to-node-stream/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r={};function s(e,t,n){n||(n=Error);var s=function(e){var n,r;function s(n,r,s){return e.call(this,function(e,n,r){return"string"==typeof t?t:t(e,n,r)}(n,r,s))||this}return r=e,(n=s).prototype=Object.create(r.prototype),n.prototype.constructor=n,n.__proto__=r,s}(n);s.prototype.name=n.name,s.prototype.code=e,r[e]=s}function o(e,t){if(Array.isArray(e)){var n=e.length;return e=e.map(function(e){return String(e)}),n>2?"one of ".concat(t," ").concat(e.slice(0,n-1).join(", "),", or ")+e[n-1]:2===n?"one of ".concat(t," ").concat(e[0]," or ").concat(e[1]):"of ".concat(t," ").concat(e[0])}return"of ".concat(t," ").concat(String(e))}s("ERR_INVALID_OPT_VALUE",function(e,t){return'The value "'+t+'" is invalid for option "'+e+'"'},TypeError),s("ERR_INVALID_ARG_TYPE",function(e,t,n){var r,s,i,a;if("string"==typeof t&&(s="not ",t.substr(!i||i<0?0:+i,s.length)===s)?(r="must not be",t=t.replace(/^not /,"")):r="must be",function(e,t,n){return(n===undefined||n>e.length)&&(n=e.length),e.substring(n-t.length,n)===t}(e," argument"))a="The ".concat(e," ").concat(r," ").concat(o(t,"type"));else{var f=function(e,t,n){return"number"!=typeof n&&(n=0),!(n+t.length>e.length)&&-1!==e.indexOf(t,n)}(e,".")?"property":"argument";a='The "'.concat(e,'" ').concat(f," ").concat(r," ").concat(o(t,"type"))}return a+=". Received type ".concat(typeof n)},TypeError),s("ERR_STREAM_PUSH_AFTER_EOF","stream.push() after EOF"),s("ERR_METHOD_NOT_IMPLEMENTED",function(e){return"The "+e+" method is not implemented"}),s("ERR_STREAM_PREMATURE_CLOSE","Premature close"),s("ERR_STREAM_DESTROYED",function(e){return"Cannot call "+e+" after a stream was destroyed"}),s("ERR_MULTIPLE_CALLBACK","Callback called multiple times"),s("ERR_STREAM_CANNOT_PIPE","Cannot pipe, not readable"),s("ERR_STREAM_WRITE_AFTER_END","write after end"),s("ERR_STREAM_NULL_VALUES","May not write null values to stream",TypeError),s("ERR_UNKNOWN_ENCODING",function(e){return"Unknown encoding: "+e},TypeError),s("ERR_STREAM_UNSHIFT_AFTER_END_EVENT","stream.unshift() after end event"),t.exports.codes=r}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_duplex.js",{"./_stream_readable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_readable.js","./_stream_writable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_writable.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r=Object.keys||function(e){var t=[];for(var n in e)t.push(n);return t};t.exports=u;var s=e("./_stream_readable"),o=e("./_stream_writable");e("inherits")(u,s);for(var i=r(o.prototype),a=0;a<i.length;a++){var f=i[a];u.prototype[f]||(u.prototype[f]=o.prototype[f])}function u(e){if(!(this instanceof u))return new u(e);s.call(this,e),o.call(this,e),this.allowHalfOpen=!0,e&&(!1===e.readable&&(this.readable=!1),!1===e.writable&&(this.writable=!1),!1===e.allowHalfOpen&&(this.allowHalfOpen=!1,this.once("end",l)))}function l(){this._writableState.ended||n.nextTick(d,this)}function d(e){e.end()}Object.defineProperty(u.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(u.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(u.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(u.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed&&this._writableState.destroyed)},set:function(e){this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_duplex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_passthrough.js",{"./_stream_transform":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_transform.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=s;var r=e("./_stream_transform");function s(e){if(!(this instanceof s))return new s(e);r.call(this,e)}e("inherits")(s,r),s.prototype._transform=function(e,t,n){n(null,e)}}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_passthrough.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_readable.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js","./_stream_duplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_duplex.js","./internal/streams/async_iterator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/async_iterator.js","./internal/streams/buffer_list":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/buffer_list.js","./internal/streams/destroy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/destroy.js","./internal/streams/from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/from-browser.js","./internal/streams/state":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/state.js","./internal/streams/stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js","string_decoder/":"/home/runner/work/metamask-extension/metamask-extension/node_modules/string_decoder/lib/string_decoder.js",util:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r;t.exports=v,v.ReadableState=_;e("events").EventEmitter;var s=function(e,t){return e.listeners(t).length},o=e("./internal/streams/stream"),i=e("buffer").Buffer,a=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var f,u=e("util");f=u&&u.debuglog?u.debuglog("stream"):function(){};var l,d,c,m=e("./internal/streams/buffer_list"),h=e("./internal/streams/destroy"),b=e("./internal/streams/state").getHighWaterMark,p=e("../errors").codes,k=p.ERR_INVALID_ARG_TYPE,x=p.ERR_STREAM_PUSH_AFTER_EOF,j=p.ERR_METHOD_NOT_IMPLEMENTED,w=p.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;e("inherits")(v,o);var g=h.errorOrDestroy,y=["error","close","destroy","pause","resume"];function _(t,n,s){r=r||e("./_stream_duplex"),t=t||{},"boolean"!=typeof s&&(s=n instanceof r),this.objectMode=!!t.objectMode,s&&(this.objectMode=this.objectMode||!!t.readableObjectMode),this.highWaterMark=b(this,t,"readableHighWaterMark",s),this.buffer=new m,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.paused=!0,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.destroyed=!1,this.defaultEncoding=t.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,t.encoding&&(l||(l=e("string_decoder/").StringDecoder),this.decoder=new l(t.encoding),this.encoding=t.encoding)}function v(t){if(r=r||e("./_stream_duplex"),!(this instanceof v))return new v(t);var n=this instanceof r;this._readableState=new _(t,this,n),this.readable=!0,t&&("function"==typeof t.read&&(this._read=t.read),"function"==typeof t.destroy&&(this._destroy=t.destroy)),o.call(this)}function T(e,t,n,r,s){f("readableAddChunk",t);var o,u=e._readableState;if(null===t)u.reading=!1,function(e,t){if(f("onEofChunk"),t.ended)return;if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,t.sync?A(e):(t.needReadable=!1,t.emittedReadable||(t.emittedReadable=!0,C(e)))}(e,u);else if(s||(o=function(e,t){var n;r=t,i.isBuffer(r)||r instanceof a||"string"==typeof t||t===undefined||e.objectMode||(n=new k("chunk",["string","Buffer","Uint8Array"],t));var r;return n}(u,t)),o)g(e,o);else if(u.objectMode||t&&t.length>0)if("string"==typeof t||u.objectMode||Object.getPrototypeOf(t)===i.prototype||(t=function(e){return i.from(e)}(t)),r)u.endEmitted?g(e,new w):S(e,u,t,!0);else if(u.ended)g(e,new x);else{if(u.destroyed)return!1;u.reading=!1,u.decoder&&!n?(t=u.decoder.write(t),u.objectMode||0!==t.length?S(e,u,t,!1):P(e,u)):S(e,u,t,!1)}else r||(u.reading=!1,P(e,u));return!u.ended&&(u.length<u.highWaterMark||0===u.length)}function S(e,t,n,r){t.flowing&&0===t.length&&!t.sync?(t.awaitDrain=0,e.emit("data",n)):(t.length+=t.objectMode?1:n.length,r?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&A(e)),P(e,t)}Object.defineProperty(v.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),v.prototype.destroy=h.destroy,v.prototype._undestroy=h.undestroy,v.prototype._destroy=function(e,t){t(e)},v.prototype.push=function(e,t){var n,r=this._readableState;return r.objectMode?n=!0:"string"==typeof e&&((t=t||r.defaultEncoding)!==r.encoding&&(e=i.from(e,t),t=""),n=!0),T(this,e,t,!1,n)},v.prototype.unshift=function(e){return T(this,e,null,!0,!1)},v.prototype.isPaused=function(){return!1===this._readableState.flowing},v.prototype.setEncoding=function(t){l||(l=e("string_decoder/").StringDecoder);var n=new l(t);this._readableState.decoder=n,this._readableState.encoding=this._readableState.decoder.encoding;for(var r=this._readableState.buffer.head,s="";null!==r;)s+=n.write(r.data),r=r.next;return this._readableState.buffer.clear(),""!==s&&this._readableState.buffer.push(s),this._readableState.length=s.length,this};var E=1073741824;function O(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=E?e=E:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function A(e){var t=e._readableState;f("emitReadable",t.needReadable,t.emittedReadable),t.needReadable=!1,t.emittedReadable||(f("emitReadable",t.flowing),t.emittedReadable=!0,n.nextTick(C,e))}function C(e){var t=e._readableState;f("emitReadable_",t.destroyed,t.length,t.ended),t.destroyed||!t.length&&!t.ended||(e.emit("readable"),t.emittedReadable=!1),t.needReadable=!t.flowing&&!t.ended&&t.length<=t.highWaterMark,B(e)}function P(e,t){t.readingMore||(t.readingMore=!0,n.nextTick(I,e,t))}function I(e,t){for(;!t.reading&&!t.ended&&(t.length<t.highWaterMark||t.flowing&&0===t.length);){var n=t.length;if(f("maybeReadMore read 0"),e.read(0),n===t.length)break}t.readingMore=!1}function M(e){var t=e._readableState;t.readableListening=e.listenerCount("readable")>0,t.resumeScheduled&&!t.paused?t.flowing=!0:e.listenerCount("data")>0&&e.resume()}function R(e){f("readable nexttick read 0"),e.read(0)}function L(e,t){f("resume",t.reading),t.reading||e.read(0),t.resumeScheduled=!1,e.emit("resume"),B(e),t.flowing&&!t.reading&&e.read(0)}function B(e){var t=e._readableState;for(f("flow",t.flowing);t.flowing&&null!==e.read(););}function F(e,t){return 0===t.length?null:(t.objectMode?n=t.buffer.shift():!e||e>=t.length?(n=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.first():t.buffer.concat(t.length),t.buffer.clear()):n=t.buffer.consume(e,t.decoder),n);var n}function N(e){var t=e._readableState;f("endReadable",t.endEmitted),t.endEmitted||(t.ended=!0,n.nextTick(D,t,e))}function D(e,t){if(f("endReadableNT",e.endEmitted,e.length),!e.endEmitted&&0===e.length&&(e.endEmitted=!0,t.readable=!1,t.emit("end"),e.autoDestroy)){var n=t._writableState;(!n||n.autoDestroy&&n.finished)&&t.destroy()}}function U(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}v.prototype.read=function(e){f("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&((0!==t.highWaterMark?t.length>=t.highWaterMark:t.length>0)||t.ended))return f("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?N(this):A(this),null;if(0===(e=O(e,t))&&t.ended)return 0===t.length&&N(this),null;var r,s=t.needReadable;return f("need readable",s),(0===t.length||t.length-e<t.highWaterMark)&&f("length less than watermark",s=!0),t.ended||t.reading?f("reading or ended",s=!1):s&&(f("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=O(n,t))),null===(r=e>0?F(e,t):null)?(t.needReadable=t.length<=t.highWaterMark,e=0):(t.length-=e,t.awaitDrain=0),0===t.length&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&N(this)),null!==r&&this.emit("data",r),r},v.prototype._read=function(e){g(this,new j("_read()"))},v.prototype.pipe=function(e,t){var r=this,o=this._readableState;switch(o.pipesCount){case 0:o.pipes=e;break;case 1:o.pipes=[o.pipes,e];break;default:o.pipes.push(e)}o.pipesCount+=1,f("pipe count=%d opts=%j",o.pipesCount,t);var i=(!t||!1!==t.end)&&e!==n.stdout&&e!==n.stderr?u:p;function a(t,n){f("onunpipe"),t===r&&n&&!1===n.hasUnpiped&&(n.hasUnpiped=!0,f("cleanup"),e.removeListener("close",h),e.removeListener("finish",b),e.removeListener("drain",l),e.removeListener("error",m),e.removeListener("unpipe",a),r.removeListener("end",u),r.removeListener("end",p),r.removeListener("data",c),d=!0,!o.awaitDrain||e._writableState&&!e._writableState.needDrain||l())}function u(){f("onend"),e.end()}o.endEmitted?n.nextTick(i):r.once("end",i),e.on("unpipe",a);var l=function(e){return function(){var t=e._readableState;f("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&s(e,"data")&&(t.flowing=!0,B(e))}}(r);e.on("drain",l);var d=!1;function c(t){f("ondata");var n=e.write(t);f("dest.write",n),!1===n&&((1===o.pipesCount&&o.pipes===e||o.pipesCount>1&&-1!==U(o.pipes,e))&&!d&&(f("false write response, pause",o.awaitDrain),o.awaitDrain++),r.pause())}function m(t){f("onerror",t),p(),e.removeListener("error",m),0===s(e,"error")&&g(e,t)}function h(){e.removeListener("finish",b),p()}function b(){f("onfinish"),e.removeListener("close",h),p()}function p(){f("unpipe"),r.unpipe(e)}return r.on("data",c),function(e,t,n){if("function"==typeof e.prependListener)return e.prependListener(t,n);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]:e.on(t,n)}(e,"error",m),e.once("close",h),e.once("finish",b),e.emit("pipe",r),o.flowing||(f("pipe resume"),r.resume()),e},v.prototype.unpipe=function(e){var t=this._readableState,n={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,n)),this;if(!e){var r=t.pipes,s=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var o=0;o<s;o++)r[o].emit("unpipe",this,{hasUnpiped:!1});return this}var i=U(t.pipes,e);return-1===i||(t.pipes.splice(i,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,n)),this},v.prototype.on=function(e,t){var r=o.prototype.on.call(this,e,t),s=this._readableState;return"data"===e?(s.readableListening=this.listenerCount("readable")>0,!1!==s.flowing&&this.resume()):"readable"===e&&(s.endEmitted||s.readableListening||(s.readableListening=s.needReadable=!0,s.flowing=!1,s.emittedReadable=!1,f("on readable",s.length,s.reading),s.length?A(this):s.reading||n.nextTick(R,this))),r},v.prototype.addListener=v.prototype.on,v.prototype.removeListener=function(e,t){var r=o.prototype.removeListener.call(this,e,t);return"readable"===e&&n.nextTick(M,this),r},v.prototype.removeAllListeners=function(e){var t=o.prototype.removeAllListeners.apply(this,arguments);return"readable"!==e&&e!==undefined||n.nextTick(M,this),t},v.prototype.resume=function(){var e=this._readableState;return e.flowing||(f("resume"),e.flowing=!e.readableListening,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,n.nextTick(L,e,t))}(this,e)),e.paused=!1,this},v.prototype.pause=function(){return f("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(f("pause"),this._readableState.flowing=!1,this.emit("pause")),this._readableState.paused=!0,this},v.prototype.wrap=function(e){var t=this,n=this._readableState,r=!1;for(var s in e.on("end",function(){if(f("wrapped end"),n.decoder&&!n.ended){var e=n.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(s){(f("wrapped data"),n.decoder&&(s=n.decoder.write(s)),!n.objectMode||null!==s&&s!==undefined)&&((n.objectMode||s&&s.length)&&(t.push(s)||(r=!0,e.pause())))}),e)this[s]===undefined&&"function"==typeof e[s]&&(this[s]=function(t){return function(){return e[t].apply(e,arguments)}}(s));for(var o=0;o<y.length;o++)e.on(y[o],this.emit.bind(this,y[o]));return this._read=function(t){f("wrapped _read",t),r&&(r=!1,e.resume())},this},"function"==typeof Symbol&&(v.prototype[Symbol.asyncIterator]=function(){return d===undefined&&(d=e("./internal/streams/async_iterator")),d(this)}),Object.defineProperty(v.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),Object.defineProperty(v.prototype,"readableBuffer",{enumerable:!1,get:function(){return this._readableState&&this._readableState.buffer}}),Object.defineProperty(v.prototype,"readableFlowing",{enumerable:!1,get:function(){return this._readableState.flowing},set:function(e){this._readableState&&(this._readableState.flowing=e)}}),v._fromList=F,Object.defineProperty(v.prototype,"readableLength",{enumerable:!1,get:function(){return this._readableState.length}}),"function"==typeof Symbol&&(v.from=function(t,n){return c===undefined&&(c=e("./internal/streams/from")),c(v,t,n)})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_readable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_transform.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js","./_stream_duplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_duplex.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=l;var r=e("../errors").codes,s=r.ERR_METHOD_NOT_IMPLEMENTED,o=r.ERR_MULTIPLE_CALLBACK,i=r.ERR_TRANSFORM_ALREADY_TRANSFORMING,a=r.ERR_TRANSFORM_WITH_LENGTH_0,f=e("./_stream_duplex");function u(e,t){var n=this._transformState;n.transforming=!1;var r=n.writecb;if(null===r)return this.emit("error",new o);n.writechunk=null,n.writecb=null,null!=t&&this.push(t),r(e);var s=this._readableState;s.reading=!1,(s.needReadable||s.length<s.highWaterMark)&&this._read(s.highWaterMark)}function l(e){if(!(this instanceof l))return new l(e);f.call(this,e),this._transformState={afterTransform:u.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",d)}function d(){var e=this;"function"!=typeof this._flush||this._readableState.destroyed?c(this,null,null):this._flush(function(t,n){c(e,t,n)})}function c(e,t,n){if(t)return e.emit("error",t);if(null!=n&&e.push(n),e._writableState.length)throw new a;if(e._transformState.transforming)throw new i;return e.push(null)}e("inherits")(l,f),l.prototype.push=function(e,t){return this._transformState.needTransform=!1,f.prototype.push.call(this,e,t)},l.prototype._transform=function(e,t,n){n(new s("_transform()"))},l.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var s=this._readableState;(r.needTransform||s.needReadable||s.length<s.highWaterMark)&&this._read(s.highWaterMark)}},l.prototype._read=function(e){var t=this._transformState;null===t.writechunk||t.transforming?t.needTransform=!0:(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform))},l.prototype._destroy=function(e,t){f.prototype._destroy.call(this,e,function(e){t(e)})}}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_transform.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_writable.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js","./_stream_duplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_duplex.js","./internal/streams/destroy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/destroy.js","./internal/streams/state":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/state.js","./internal/streams/stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js","util-deprecate":"/home/runner/work/metamask-extension/metamask-extension/node_modules/util-deprecate/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){function r(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t,n){var r=e.entry;e.entry=null;for(;r;){var s=r.callback;t.pendingcb--,s(n),r=r.next}t.corkedRequestsFree.next=e}(t,e)}}var s;t.exports=v,v.WritableState=_;var o={deprecate:e("util-deprecate")},i=e("./internal/streams/stream"),a=e("buffer").Buffer,f=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var u,l=e("./internal/streams/destroy"),d=e("./internal/streams/state").getHighWaterMark,c=e("../errors").codes,m=c.ERR_INVALID_ARG_TYPE,h=c.ERR_METHOD_NOT_IMPLEMENTED,b=c.ERR_MULTIPLE_CALLBACK,p=c.ERR_STREAM_CANNOT_PIPE,k=c.ERR_STREAM_DESTROYED,x=c.ERR_STREAM_NULL_VALUES,j=c.ERR_STREAM_WRITE_AFTER_END,w=c.ERR_UNKNOWN_ENCODING,g=l.errorOrDestroy;function y(){}function _(t,o,i){s=s||e("./_stream_duplex"),t=t||{},"boolean"!=typeof i&&(i=o instanceof s),this.objectMode=!!t.objectMode,i&&(this.objectMode=this.objectMode||!!t.writableObjectMode),this.highWaterMark=d(this,t,"writableHighWaterMark",i),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var a=!1===t.decodeStrings;this.decodeStrings=!a,this.defaultEncoding=t.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var r=e._writableState,s=r.sync,o=r.writecb;if("function"!=typeof o)throw new b;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(r),t)!function(e,t,r,s,o){--t.pendingcb,r?(n.nextTick(o,s),n.nextTick(C,e,t),e._writableState.errorEmitted=!0,g(e,s)):(o(s),e._writableState.errorEmitted=!0,g(e,s),C(e,t))}(e,r,s,t,o);else{var i=O(r)||e.destroyed;i||r.corked||r.bufferProcessing||!r.bufferedRequest||E(e,r),s?n.nextTick(S,e,r,i,o):S(e,r,i,o)}}(o,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.bufferedRequestCount=0,this.corkedRequestsFree=new r(this)}function v(t){var n=this instanceof(s=s||e("./_stream_duplex"));if(!n&&!u.call(v,this))return new v(t);this._writableState=new _(t,this,n),this.writable=!0,t&&("function"==typeof t.write&&(this._write=t.write),"function"==typeof t.writev&&(this._writev=t.writev),"function"==typeof t.destroy&&(this._destroy=t.destroy),"function"==typeof t.final&&(this._final=t.final)),i.call(this)}function T(e,t,n,r,s,o,i){t.writelen=r,t.writecb=i,t.writing=!0,t.sync=!0,t.destroyed?t.onwrite(new k("write")):n?e._writev(s,t.onwrite):e._write(s,o,t.onwrite),t.sync=!1}function S(e,t,n,r){n||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,r(),C(e,t)}function E(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var s=t.bufferedRequestCount,o=new Array(s),i=t.corkedRequestsFree;i.entry=n;for(var a=0,f=!0;n;)o[a]=n,n.isBuf||(f=!1),n=n.next,a+=1;o.allBuffers=f,T(e,t,!0,t.length,o,"",i.finish),t.pendingcb++,t.lastBufferedRequest=null,i.next?(t.corkedRequestsFree=i.next,i.next=null):t.corkedRequestsFree=new r(t),t.bufferedRequestCount=0}else{for(;n;){var u=n.chunk,l=n.encoding,d=n.callback;if(T(e,t,!1,t.objectMode?1:u.length,u,l,d),n=n.next,t.bufferedRequestCount--,t.writing)break}null===n&&(t.lastBufferedRequest=null)}t.bufferedRequest=n,t.bufferProcessing=!1}function O(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function A(e,t){e._final(function(n){t.pendingcb--,n&&g(e,n),t.prefinished=!0,e.emit("prefinish"),C(e,t)})}function C(e,t){var r=O(t);if(r&&(function(e,t){t.prefinished||t.finalCalled||("function"!=typeof e._final||t.destroyed?(t.prefinished=!0,e.emit("prefinish")):(t.pendingcb++,t.finalCalled=!0,n.nextTick(A,e,t)))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"),t.autoDestroy))){var s=e._readableState;(!s||s.autoDestroy&&s.endEmitted)&&e.destroy()}return r}e("inherits")(v,i),_.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(_.prototype,"buffer",{get:o.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(u=Function.prototype[Symbol.hasInstance],Object.defineProperty(v,Symbol.hasInstance,{value:function(e){return!!u.call(this,e)||this===v&&(e&&e._writableState instanceof _)}})):u=function(e){return e instanceof this},v.prototype.pipe=function(){g(this,new p)},v.prototype.write=function(e,t,r){var s,o=this._writableState,i=!1,u=!o.objectMode&&(s=e,a.isBuffer(s)||s instanceof f);return u&&!a.isBuffer(e)&&(e=function(e){return a.from(e)}(e)),"function"==typeof t&&(r=t,t=null),u?t="buffer":t||(t=o.defaultEncoding),"function"!=typeof r&&(r=y),o.ending?function(e,t){var r=new j;g(e,r),n.nextTick(t,r)}(this,r):(u||function(e,t,r,s){var o;return null===r?o=new x:"string"==typeof r||t.objectMode||(o=new m("chunk",["string","Buffer"],r)),!o||(g(e,o),n.nextTick(s,o),!1)}(this,o,e,r))&&(o.pendingcb++,i=function(e,t,n,r,s,o){if(!n){var i=function(e,t,n){e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=a.from(t,n));return t}(t,r,s);r!==i&&(n=!0,s="buffer",r=i)}var f=t.objectMode?1:r.length;t.length+=f;var u=t.length<t.highWaterMark;u||(t.needDrain=!0);if(t.writing||t.corked){var l=t.lastBufferedRequest;t.lastBufferedRequest={chunk:r,encoding:s,isBuf:n,callback:o,next:null},l?l.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else T(e,t,!1,f,r,s,o);return u}(this,o,u,e,t,r)),i},v.prototype.cork=function(){this._writableState.corked++},v.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||E(this,e))},v.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new w(e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(v.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(v.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),v.prototype._write=function(e,t,n){n(new h("_write()"))},v.prototype._writev=null,v.prototype.end=function(e,t,r){var s=this._writableState;return"function"==typeof e?(r=e,e=null,t=null):"function"==typeof t&&(r=t,t=null),null!==e&&e!==undefined&&this.write(e,t),s.corked&&(s.corked=1,this.uncork()),s.ending||function(e,t,r){t.ending=!0,C(e,t),r&&(t.finished?n.nextTick(r):e.once("finish",r));t.ended=!0,e.writable=!1}(this,s,r),this},Object.defineProperty(v.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(v.prototype,"destroyed",{enumerable:!1,get:function(){return this._writableState!==undefined&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),v.prototype.destroy=l.destroy,v.prototype._undestroy=l.undestroy,v.prototype._destroy=function(e,t){t(e)}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_writable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/async_iterator.js",{"./end-of-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js",_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r;function s(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var n=e[Symbol.toPrimitive];if(n!==undefined){var r=n.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var o=e("./end-of-stream"),i=Symbol("lastResolve"),a=Symbol("lastReject"),f=Symbol("error"),u=Symbol("ended"),l=Symbol("lastPromise"),d=Symbol("handlePromise"),c=Symbol("stream");function m(e,t){return{value:e,done:t}}function h(e){var t=e[i];if(null!==t){var n=e[c].read();null!==n&&(e[l]=null,e[i]=null,e[a]=null,t(m(n,!1)))}}function b(e){n.nextTick(h,e)}var p=Object.getPrototypeOf(function(){}),k=Object.setPrototypeOf((s(r={get stream(){return this[c]},next:function(){var e=this,t=this[f];if(null!==t)return Promise.reject(t);if(this[u])return Promise.resolve(m(undefined,!0));if(this[c].destroyed)return new Promise(function(t,r){n.nextTick(function(){e[f]?r(e[f]):t(m(undefined,!0))})});var r,s=this[l];if(s)r=new Promise(function(e,t){return function(n,r){e.then(function(){t[u]?n(m(undefined,!0)):t[d](n,r)},r)}}(s,this));else{var o=this[c].read();if(null!==o)return Promise.resolve(m(o,!1));r=new Promise(this[d])}return this[l]=r,r}},Symbol.asyncIterator,function(){return this}),s(r,"return",function(){var e=this;return new Promise(function(t,n){e[c].destroy(null,function(e){e?n(e):t(m(undefined,!0))})})}),r),p);t.exports=function(e){var t,n=Object.create(k,(s(t={},c,{value:e,writable:!0}),s(t,i,{value:null,writable:!0}),s(t,a,{value:null,writable:!0}),s(t,f,{value:null,writable:!0}),s(t,u,{value:e._readableState.endEmitted,writable:!0}),s(t,d,{value:function(e,t){var r=n[c].read();r?(n[l]=null,n[i]=null,n[a]=null,e(m(r,!1))):(n[i]=e,n[a]=t)},writable:!0}),t));return n[l]=null,o(e,function(e){if(e&&"ERR_STREAM_PREMATURE_CLOSE"!==e.code){var t=n[a];return null!==t&&(n[l]=null,n[i]=null,n[a]=null,t(e)),void(n[f]=e)}var r=n[i];null!==r&&(n[l]=null,n[i]=null,n[a]=null,r(m(undefined,!0))),n[u]=!0}),e.on("readable",b.bind(null,n)),n}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/async_iterator.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/buffer_list.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",util:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function s(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?r(Object(n),!0).forEach(function(t){o(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):r(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function o(e,t,n){return(t=a(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,a(r.key),r)}}function a(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var n=e[Symbol.toPrimitive];if(n!==undefined){var r=n.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}var f=e("buffer").Buffer,u=e("util").inspect,l=u&&u.custom||"inspect";function d(e,t,n){f.prototype.copy.call(e,t,n)}t.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}var t,n,r;return t=e,(n=[{key:"push",value:function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length}},{key:"unshift",value:function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length}},{key:"shift",value:function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}}},{key:"clear",value:function(){this.head=this.tail=null,this.length=0}},{key:"join",value:function(e){if(0===this.length)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n}},{key:"concat",value:function(e){if(0===this.length)return f.alloc(0);for(var t=f.allocUnsafe(e>>>0),n=this.head,r=0;n;)d(n.data,t,r),r+=n.data.length,n=n.next;return t}},{key:"consume",value:function(e,t){var n;return e<this.head.data.length?(n=this.head.data.slice(0,e),this.head.data=this.head.data.slice(e)):n=e===this.head.data.length?this.shift():t?this._getString(e):this._getBuffer(e),n}},{key:"first",value:function(){return this.head.data}},{key:"_getString",value:function(e){var t=this.head,n=1,r=t.data;for(e-=r.length;t=t.next;){var s=t.data,o=e>s.length?s.length:e;if(o===s.length?r+=s:r+=s.slice(0,e),0===(e-=o)){o===s.length?(++n,t.next?this.head=t.next:this.head=this.tail=null):(this.head=t,t.data=s.slice(o));break}++n}return this.length-=n,r}},{key:"_getBuffer",value:function(e){var t=f.allocUnsafe(e),n=this.head,r=1;for(n.data.copy(t),e-=n.data.length;n=n.next;){var s=n.data,o=e>s.length?s.length:e;if(s.copy(t,t.length-e,0,o),0===(e-=o)){o===s.length?(++r,n.next?this.head=n.next:this.head=this.tail=null):(this.head=n,n.data=s.slice(o));break}++r}return this.length-=r,t}},{key:l,value:function(e,t){return u(this,s(s({},t),{},{depth:0,customInspect:!1}))}}])&&i(t.prototype,n),r&&i(t,r),Object.defineProperty(t,"prototype",{writable:!1}),e}()}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/buffer_list.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/destroy.js",{_process:"/home/runner/work/metamask-extension/metamask-extension/node_modules/process/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function n(e,t){s(e,t),r(e)}function r(e){e._writableState&&!e._writableState.emitClose||e._readableState&&!e._readableState.emitClose||e.emit("close")}function s(e,t){e.emit("error",t)}t.exports={destroy:function(t,o){var i=this,a=this._readableState&&this._readableState.destroyed,f=this._writableState&&this._writableState.destroyed;return a||f?(o?o(t):t&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,e.nextTick(s,this,t)):e.nextTick(s,this,t)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(t||null,function(t){!o&&t?i._writableState?i._writableState.errorEmitted?e.nextTick(r,i):(i._writableState.errorEmitted=!0,e.nextTick(n,i,t)):e.nextTick(n,i,t):o?(e.nextTick(r,i),o(t)):e.nextTick(r,i)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)},errorOrDestroy:function(e,t){var n=e._readableState,r=e._writableState;n&&n.autoDestroy||r&&r.autoDestroy?e.destroy(t):e.emit("error",t)}}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/destroy.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js",{"../../../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("../../../errors").codes.ERR_STREAM_PREMATURE_CLOSE;function s(){}t.exports=function e(t,n,o){if("function"==typeof n)return e(t,null,n);n||(n={}),o=function(e){var t=!1;return function(){if(!t){t=!0;for(var n=arguments.length,r=new Array(n),s=0;s<n;s++)r[s]=arguments[s];e.apply(this,r)}}}(o||s);var i=n.readable||!1!==n.readable&&t.readable,a=n.writable||!1!==n.writable&&t.writable,f=function(){t.writable||l()},u=t._writableState&&t._writableState.finished,l=function(){a=!1,u=!0,i||o.call(t)},d=t._readableState&&t._readableState.endEmitted,c=function(){i=!1,d=!0,a||o.call(t)},m=function(e){o.call(t,e)},h=function(){var e;return i&&!d?(t._readableState&&t._readableState.ended||(e=new r),o.call(t,e)):a&&!u?(t._writableState&&t._writableState.ended||(e=new r),o.call(t,e)):void 0},b=function(){t.req.on("finish",l)};return!function(e){return e.setHeader&&"function"==typeof e.abort}(t)?a&&!t._writableState&&(t.on("end",f),t.on("close",f)):(t.on("complete",l),t.on("abort",h),t.req?b():t.on("request",b)),t.on("end",c),t.on("finish",l),!1!==n.error&&t.on("error",m),t.on("close",h),function(){t.removeListener("complete",l),t.removeListener("abort",h),t.removeListener("request",b),t.req&&t.req.removeListener("finish",l),t.removeListener("end",f),t.removeListener("close",f),t.removeListener("finish",l),t.removeListener("end",c),t.removeListener("error",m),t.removeListener("close",h)}}}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/from-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(){throw new Error("Readable.from is not available in the browser")}}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/from-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/pipeline.js",{"../../../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js","./end-of-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;var s=e("../../../errors").codes,o=s.ERR_MISSING_ARGS,i=s.ERR_STREAM_DESTROYED;function a(e){if(e)throw e}function f(e){e()}function u(e,t){return e.pipe(t)}t.exports=function(){for(var t=arguments.length,n=new Array(t),s=0;s<t;s++)n[s]=arguments[s];var l,d=function(e){return e.length?"function"!=typeof e[e.length-1]?a:e.pop():a}(n);if(Array.isArray(n[0])&&(n=n[0]),n.length<2)throw new o("streams");var c=n.map(function(t,s){var o=s<n.length-1;return function(t,n,s,o){o=function(e){var t=!1;return function(){t||(t=!0,e.apply(void 0,arguments))}}(o);var a=!1;t.on("close",function(){a=!0}),r===undefined&&(r=e("./end-of-stream")),r(t,{readable:n,writable:s},function(e){if(e)return o(e);a=!0,o()});var f=!1;return function(e){if(!a&&!f)return f=!0,function(e){return e.setHeader&&"function"==typeof e.abort}(t)?t.abort():"function"==typeof t.destroy?t.destroy():void o(e||new i("pipe"))}}(t,o,s>0,function(e){l||(l=e),e&&c.forEach(f),o||(c.forEach(f),d(l))})});return n.reduce(u)}}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/pipeline.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/state.js",{"../../../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/errors-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("../../../errors").codes.ERR_INVALID_OPT_VALUE;t.exports={getHighWaterMark:function(e,t,n,s){var o=function(e,t,n){return null!=e.highWaterMark?e.highWaterMark:t?e[n]:null}(t,s,n);if(null!=o){if(!isFinite(o)||Math.floor(o)!==o||o<0)throw new r(s?n:"highWaterMark",o);return Math.floor(o)}return e.objectMode?16:16384}}}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/state.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("events").EventEmitter}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/stream-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/readable-browser.js",{"./lib/_stream_duplex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_duplex.js","./lib/_stream_passthrough.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_passthrough.js","./lib/_stream_readable.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_readable.js","./lib/_stream_transform.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_transform.js","./lib/_stream_writable.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/_stream_writable.js","./lib/internal/streams/end-of-stream.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/end-of-stream.js","./lib/internal/streams/pipeline.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/node_modules/readable-stream/lib/internal/streams/pipeline.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(n=t.exports=e("./lib/_stream_readable.js")).Stream=n,n.Readable=n,n.Writable=e("./lib/_stream_writable.js"),n.Duplex=e("./lib/_stream_duplex.js"),n.Transform=e("./lib/_stream_transform.js"),n.PassThrough=e("./lib/_stream_passthrough.js"),n.finished=e("./lib/internal/streams/end-of-stream.js"),n.pipeline=e("./lib/internal/streams/pipeline.js")}}},{package:"@metamask/snaps-controllers>readable-web-to-node-stream>readable-stream",file:"node_modules/readable-web-to-node-stream/node_modules/readable-stream/readable-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/remove-trailing-slash/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(n=t.exports=function(e){return String(e).replace(n.expr,"")}).expr=/\/+$/}}},{package:"remove-trailing-slash",file:"node_modules/remove-trailing-slash/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/index.js",{"./internal/AsyncSubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/AsyncSubject.js","./internal/BehaviorSubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/BehaviorSubject.js","./internal/Notification":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Notification.js","./internal/Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","./internal/ReplaySubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/ReplaySubject.js","./internal/Scheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Scheduler.js","./internal/Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","./internal/Subscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscriber.js","./internal/Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","./internal/config":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/config.js","./internal/firstValueFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/firstValueFrom.js","./internal/lastValueFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/lastValueFrom.js","./internal/observable/ConnectableObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/ConnectableObservable.js","./internal/observable/bindCallback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/bindCallback.js","./internal/observable/bindNodeCallback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/bindNodeCallback.js","./internal/observable/combineLatest":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/combineLatest.js","./internal/observable/concat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/concat.js","./internal/observable/connectable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/connectable.js","./internal/observable/defer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/defer.js","./internal/observable/dom/animationFrames":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/dom/animationFrames.js","./internal/observable/empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","./internal/observable/forkJoin":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/forkJoin.js","./internal/observable/from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js","./internal/observable/fromEvent":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/fromEvent.js","./internal/observable/fromEventPattern":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/fromEventPattern.js","./internal/observable/generate":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/generate.js","./internal/observable/iif":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/iif.js","./internal/observable/interval":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/interval.js","./internal/observable/merge":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/merge.js","./internal/observable/never":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/never.js","./internal/observable/of":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/of.js","./internal/observable/onErrorResumeNext":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/onErrorResumeNext.js","./internal/observable/pairs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/pairs.js","./internal/observable/partition":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/partition.js","./internal/observable/race":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/race.js","./internal/observable/range":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/range.js","./internal/observable/throwError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/throwError.js","./internal/observable/timer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js","./internal/observable/using":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/using.js","./internal/observable/zip":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/zip.js","./internal/operators/audit":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/audit.js","./internal/operators/auditTime":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/auditTime.js","./internal/operators/buffer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/buffer.js","./internal/operators/bufferCount":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferCount.js","./internal/operators/bufferTime":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferTime.js","./internal/operators/bufferToggle":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferToggle.js","./internal/operators/bufferWhen":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferWhen.js","./internal/operators/catchError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/catchError.js","./internal/operators/combineAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineAll.js","./internal/operators/combineLatestAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineLatestAll.js","./internal/operators/combineLatestWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineLatestWith.js","./internal/operators/concatAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatAll.js","./internal/operators/concatMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatMap.js","./internal/operators/concatMapTo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatMapTo.js","./internal/operators/concatWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatWith.js","./internal/operators/connect":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/connect.js","./internal/operators/count":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/count.js","./internal/operators/debounce":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/debounce.js","./internal/operators/debounceTime":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/debounceTime.js","./internal/operators/defaultIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js","./internal/operators/delay":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/delay.js","./internal/operators/delayWhen":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/delayWhen.js","./internal/operators/dematerialize":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/dematerialize.js","./internal/operators/distinct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/distinct.js","./internal/operators/distinctUntilChanged":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/distinctUntilChanged.js","./internal/operators/distinctUntilKeyChanged":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/distinctUntilKeyChanged.js","./internal/operators/elementAt":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/elementAt.js","./internal/operators/endWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/endWith.js","./internal/operators/every":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/every.js","./internal/operators/exhaust":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaust.js","./internal/operators/exhaustAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaustAll.js","./internal/operators/exhaustMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaustMap.js","./internal/operators/expand":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/expand.js","./internal/operators/filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/filter.js","./internal/operators/finalize":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/finalize.js","./internal/operators/find":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/find.js","./internal/operators/findIndex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/findIndex.js","./internal/operators/first":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/first.js","./internal/operators/flatMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/flatMap.js","./internal/operators/groupBy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/groupBy.js","./internal/operators/ignoreElements":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/ignoreElements.js","./internal/operators/isEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/isEmpty.js","./internal/operators/last":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/last.js","./internal/operators/map":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js","./internal/operators/mapTo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mapTo.js","./internal/operators/materialize":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/materialize.js","./internal/operators/max":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/max.js","./internal/operators/mergeAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeAll.js","./internal/operators/mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js","./internal/operators/mergeMapTo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMapTo.js","./internal/operators/mergeScan":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeScan.js","./internal/operators/mergeWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeWith.js","./internal/operators/min":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/min.js","./internal/operators/multicast":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/multicast.js","./internal/operators/observeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/observeOn.js","./internal/operators/onErrorResumeNextWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/onErrorResumeNextWith.js","./internal/operators/pairwise":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/pairwise.js","./internal/operators/pluck":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/pluck.js","./internal/operators/publish":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publish.js","./internal/operators/publishBehavior":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publishBehavior.js","./internal/operators/publishLast":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publishLast.js","./internal/operators/publishReplay":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publishReplay.js","./internal/operators/raceWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/raceWith.js","./internal/operators/reduce":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/reduce.js","./internal/operators/refCount":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/refCount.js","./internal/operators/repeat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/repeat.js","./internal/operators/repeatWhen":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/repeatWhen.js","./internal/operators/retry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/retry.js","./internal/operators/retryWhen":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/retryWhen.js","./internal/operators/sample":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/sample.js","./internal/operators/sampleTime":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/sampleTime.js","./internal/operators/scan":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/scan.js","./internal/operators/sequenceEqual":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/sequenceEqual.js","./internal/operators/share":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/share.js","./internal/operators/shareReplay":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/shareReplay.js","./internal/operators/single":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/single.js","./internal/operators/skip":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skip.js","./internal/operators/skipLast":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skipLast.js","./internal/operators/skipUntil":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skipUntil.js","./internal/operators/skipWhile":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skipWhile.js","./internal/operators/startWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/startWith.js","./internal/operators/subscribeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/subscribeOn.js","./internal/operators/switchAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchAll.js","./internal/operators/switchMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchMap.js","./internal/operators/switchMapTo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchMapTo.js","./internal/operators/switchScan":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchScan.js","./internal/operators/take":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/take.js","./internal/operators/takeLast":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/takeLast.js","./internal/operators/takeUntil":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/takeUntil.js","./internal/operators/takeWhile":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/takeWhile.js","./internal/operators/tap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/tap.js","./internal/operators/throttle":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throttle.js","./internal/operators/throttleTime":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throttleTime.js","./internal/operators/throwIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throwIfEmpty.js","./internal/operators/timeInterval":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timeInterval.js","./internal/operators/timeout":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timeout.js","./internal/operators/timeoutWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timeoutWith.js","./internal/operators/timestamp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timestamp.js","./internal/operators/toArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/toArray.js","./internal/operators/window":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/window.js","./internal/operators/windowCount":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowCount.js","./internal/operators/windowTime":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowTime.js","./internal/operators/windowToggle":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowToggle.js","./internal/operators/windowWhen":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowWhen.js","./internal/operators/withLatestFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/withLatestFrom.js","./internal/operators/zipAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/zipAll.js","./internal/operators/zipWith":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/zipWith.js","./internal/scheduled/scheduled":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduled.js","./internal/scheduler/VirtualTimeScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/VirtualTimeScheduler.js","./internal/scheduler/animationFrame":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/animationFrame.js","./internal/scheduler/asap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/asap.js","./internal/scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","./internal/scheduler/queue":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/queue.js","./internal/symbol/observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/observable.js","./internal/types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/types.js","./internal/util/ArgumentOutOfRangeError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/ArgumentOutOfRangeError.js","./internal/util/EmptyError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js","./internal/util/NotFoundError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/NotFoundError.js","./internal/util/ObjectUnsubscribedError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/ObjectUnsubscribedError.js","./internal/util/SequenceError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/SequenceError.js","./internal/util/UnsubscriptionError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/UnsubscriptionError.js","./internal/util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","./internal/util/isObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isObservable.js","./internal/util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./internal/util/pipe":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/pipe.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n),Object.defineProperty(e,r,{enumerable:!0,get:function(){return t[n]}})}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.interval=n.iif=n.generate=n.fromEventPattern=n.fromEvent=n.from=n.forkJoin=n.empty=n.defer=n.connectable=n.concat=n.combineLatest=n.bindNodeCallback=n.bindCallback=n.UnsubscriptionError=n.TimeoutError=n.SequenceError=n.ObjectUnsubscribedError=n.NotFoundError=n.EmptyError=n.ArgumentOutOfRangeError=n.firstValueFrom=n.lastValueFrom=n.isObservable=n.identity=n.noop=n.pipe=n.NotificationKind=n.Notification=n.Subscriber=n.Subscription=n.Scheduler=n.VirtualAction=n.VirtualTimeScheduler=n.animationFrameScheduler=n.animationFrame=n.queueScheduler=n.queue=n.asyncScheduler=n.async=n.asapScheduler=n.asap=n.AsyncSubject=n.ReplaySubject=n.BehaviorSubject=n.Subject=n.animationFrames=n.observable=n.ConnectableObservable=n.Observable=void 0,n.filter=n.expand=n.exhaustMap=n.exhaustAll=n.exhaust=n.every=n.endWith=n.elementAt=n.distinctUntilKeyChanged=n.distinctUntilChanged=n.distinct=n.dematerialize=n.delayWhen=n.delay=n.defaultIfEmpty=n.debounceTime=n.debounce=n.count=n.connect=n.concatWith=n.concatMapTo=n.concatMap=n.concatAll=n.combineLatestWith=n.combineLatestAll=n.combineAll=n.catchError=n.bufferWhen=n.bufferToggle=n.bufferTime=n.bufferCount=n.buffer=n.auditTime=n.audit=n.config=n.NEVER=n.EMPTY=n.scheduled=n.zip=n.using=n.timer=n.throwError=n.range=n.race=n.partition=n.pairs=n.onErrorResumeNext=n.of=n.never=n.merge=void 0,n.switchMap=n.switchAll=n.subscribeOn=n.startWith=n.skipWhile=n.skipUntil=n.skipLast=n.skip=n.single=n.shareReplay=n.share=n.sequenceEqual=n.scan=n.sampleTime=n.sample=n.refCount=n.retryWhen=n.retry=n.repeatWhen=n.repeat=n.reduce=n.raceWith=n.publishReplay=n.publishLast=n.publishBehavior=n.publish=n.pluck=n.pairwise=n.onErrorResumeNextWith=n.observeOn=n.multicast=n.min=n.mergeWith=n.mergeScan=n.mergeMapTo=n.mergeMap=n.flatMap=n.mergeAll=n.max=n.materialize=n.mapTo=n.map=n.last=n.isEmpty=n.ignoreElements=n.groupBy=n.first=n.findIndex=n.find=n.finalize=void 0,n.zipWith=n.zipAll=n.withLatestFrom=n.windowWhen=n.windowToggle=n.windowTime=n.windowCount=n.window=n.toArray=n.timestamp=n.timeoutWith=n.timeout=n.timeInterval=n.throwIfEmpty=n.throttleTime=n.throttle=n.tap=n.takeWhile=n.takeUntil=n.takeLast=n.take=n.switchScan=n.switchMapTo=void 0;var o=e("./internal/Observable");Object.defineProperty(n,"Observable",{enumerable:!0,get:function(){return o.Observable}});var i=e("./internal/observable/ConnectableObservable");Object.defineProperty(n,"ConnectableObservable",{enumerable:!0,get:function(){return i.ConnectableObservable}});var a=e("./internal/symbol/observable");Object.defineProperty(n,"observable",{enumerable:!0,get:function(){return a.observable}});var f=e("./internal/observable/dom/animationFrames");Object.defineProperty(n,"animationFrames",{enumerable:!0,get:function(){return f.animationFrames}});var u=e("./internal/Subject");Object.defineProperty(n,"Subject",{enumerable:!0,get:function(){return u.Subject}});var l=e("./internal/BehaviorSubject");Object.defineProperty(n,"BehaviorSubject",{enumerable:!0,get:function(){return l.BehaviorSubject}});var d=e("./internal/ReplaySubject");Object.defineProperty(n,"ReplaySubject",{enumerable:!0,get:function(){return d.ReplaySubject}});var c=e("./internal/AsyncSubject");Object.defineProperty(n,"AsyncSubject",{enumerable:!0,get:function(){return c.AsyncSubject}});var m=e("./internal/scheduler/asap");Object.defineProperty(n,"asap",{enumerable:!0,get:function(){return m.asap}}),Object.defineProperty(n,"asapScheduler",{enumerable:!0,get:function(){return m.asapScheduler}});var h=e("./internal/scheduler/async");Object.defineProperty(n,"async",{enumerable:!0,get:function(){return h.async}}),Object.defineProperty(n,"asyncScheduler",{enumerable:!0,get:function(){return h.asyncScheduler}});var b=e("./internal/scheduler/queue");Object.defineProperty(n,"queue",{enumerable:!0,get:function(){return b.queue}}),Object.defineProperty(n,"queueScheduler",{enumerable:!0,get:function(){return b.queueScheduler}});var p=e("./internal/scheduler/animationFrame");Object.defineProperty(n,"animationFrame",{enumerable:!0,get:function(){return p.animationFrame}}),Object.defineProperty(n,"animationFrameScheduler",{enumerable:!0,get:function(){return p.animationFrameScheduler}});var k=e("./internal/scheduler/VirtualTimeScheduler");Object.defineProperty(n,"VirtualTimeScheduler",{enumerable:!0,get:function(){return k.VirtualTimeScheduler}}),Object.defineProperty(n,"VirtualAction",{enumerable:!0,get:function(){return k.VirtualAction}});var x=e("./internal/Scheduler");Object.defineProperty(n,"Scheduler",{enumerable:!0,get:function(){return x.Scheduler}});var j=e("./internal/Subscription");Object.defineProperty(n,"Subscription",{enumerable:!0,get:function(){return j.Subscription}});var w=e("./internal/Subscriber");Object.defineProperty(n,"Subscriber",{enumerable:!0,get:function(){return w.Subscriber}});var g=e("./internal/Notification");Object.defineProperty(n,"Notification",{enumerable:!0,get:function(){return g.Notification}}),Object.defineProperty(n,"NotificationKind",{enumerable:!0,get:function(){return g.NotificationKind}});var y=e("./internal/util/pipe");Object.defineProperty(n,"pipe",{enumerable:!0,get:function(){return y.pipe}});var _=e("./internal/util/noop");Object.defineProperty(n,"noop",{enumerable:!0,get:function(){return _.noop}});var v=e("./internal/util/identity");Object.defineProperty(n,"identity",{enumerable:!0,get:function(){return v.identity}});var T=e("./internal/util/isObservable");Object.defineProperty(n,"isObservable",{enumerable:!0,get:function(){return T.isObservable}});var S=e("./internal/lastValueFrom");Object.defineProperty(n,"lastValueFrom",{enumerable:!0,get:function(){return S.lastValueFrom}});var E=e("./internal/firstValueFrom");Object.defineProperty(n,"firstValueFrom",{enumerable:!0,get:function(){return E.firstValueFrom}});var O=e("./internal/util/ArgumentOutOfRangeError");Object.defineProperty(n,"ArgumentOutOfRangeError",{enumerable:!0,get:function(){return O.ArgumentOutOfRangeError}});var A=e("./internal/util/EmptyError");Object.defineProperty(n,"EmptyError",{enumerable:!0,get:function(){return A.EmptyError}});var C=e("./internal/util/NotFoundError");Object.defineProperty(n,"NotFoundError",{enumerable:!0,get:function(){return C.NotFoundError}});var P=e("./internal/util/ObjectUnsubscribedError");Object.defineProperty(n,"ObjectUnsubscribedError",{enumerable:!0,get:function(){return P.ObjectUnsubscribedError}});var I=e("./internal/util/SequenceError");Object.defineProperty(n,"SequenceError",{enumerable:!0,get:function(){return I.SequenceError}});var M=e("./internal/operators/timeout");Object.defineProperty(n,"TimeoutError",{enumerable:!0,get:function(){return M.TimeoutError}});var R=e("./internal/util/UnsubscriptionError");Object.defineProperty(n,"UnsubscriptionError",{enumerable:!0,get:function(){return R.UnsubscriptionError}});var L=e("./internal/observable/bindCallback");Object.defineProperty(n,"bindCallback",{enumerable:!0,get:function(){return L.bindCallback}});var B=e("./internal/observable/bindNodeCallback");Object.defineProperty(n,"bindNodeCallback",{enumerable:!0,get:function(){return B.bindNodeCallback}});var F=e("./internal/observable/combineLatest");Object.defineProperty(n,"combineLatest",{enumerable:!0,get:function(){return F.combineLatest}});var N=e("./internal/observable/concat");Object.defineProperty(n,"concat",{enumerable:!0,get:function(){return N.concat}});var D=e("./internal/observable/connectable");Object.defineProperty(n,"connectable",{enumerable:!0,get:function(){return D.connectable}});var U=e("./internal/observable/defer");Object.defineProperty(n,"defer",{enumerable:!0,get:function(){return U.defer}});var H=e("./internal/observable/empty");Object.defineProperty(n,"empty",{enumerable:!0,get:function(){return H.empty}});var W=e("./internal/observable/forkJoin");Object.defineProperty(n,"forkJoin",{enumerable:!0,get:function(){return W.forkJoin}});var G=e("./internal/observable/from");Object.defineProperty(n,"from",{enumerable:!0,get:function(){return G.from}});var z=e("./internal/observable/fromEvent");Object.defineProperty(n,"fromEvent",{enumerable:!0,get:function(){return z.fromEvent}});var V=e("./internal/observable/fromEventPattern");Object.defineProperty(n,"fromEventPattern",{enumerable:!0,get:function(){return V.fromEventPattern}});var q=e("./internal/observable/generate");Object.defineProperty(n,"generate",{enumerable:!0,get:function(){return q.generate}});var K=e("./internal/observable/iif");Object.defineProperty(n,"iif",{enumerable:!0,get:function(){return K.iif}});var Y=e("./internal/observable/interval");Object.defineProperty(n,"interval",{enumerable:!0,get:function(){return Y.interval}});var J=e("./internal/observable/merge");Object.defineProperty(n,"merge",{enumerable:!0,get:function(){return J.merge}});var Z=e("./internal/observable/never");Object.defineProperty(n,"never",{enumerable:!0,get:function(){return Z.never}});var X=e("./internal/observable/of");Object.defineProperty(n,"of",{enumerable:!0,get:function(){return X.of}});var Q=e("./internal/observable/onErrorResumeNext");Object.defineProperty(n,"onErrorResumeNext",{enumerable:!0,get:function(){return Q.onErrorResumeNext}});var $=e("./internal/observable/pairs");Object.defineProperty(n,"pairs",{enumerable:!0,get:function(){return $.pairs}});var ee=e("./internal/observable/partition");Object.defineProperty(n,"partition",{enumerable:!0,get:function(){return ee.partition}});var te=e("./internal/observable/race");Object.defineProperty(n,"race",{enumerable:!0,get:function(){return te.race}});var ne=e("./internal/observable/range");Object.defineProperty(n,"range",{enumerable:!0,get:function(){return ne.range}});var re=e("./internal/observable/throwError");Object.defineProperty(n,"throwError",{enumerable:!0,get:function(){return re.throwError}});var se=e("./internal/observable/timer");Object.defineProperty(n,"timer",{enumerable:!0,get:function(){return se.timer}});var oe=e("./internal/observable/using");Object.defineProperty(n,"using",{enumerable:!0,get:function(){return oe.using}});var ie=e("./internal/observable/zip");Object.defineProperty(n,"zip",{enumerable:!0,get:function(){return ie.zip}});var ae=e("./internal/scheduled/scheduled");Object.defineProperty(n,"scheduled",{enumerable:!0,get:function(){return ae.scheduled}});var fe=e("./internal/observable/empty");Object.defineProperty(n,"EMPTY",{enumerable:!0,get:function(){return fe.EMPTY}});var ue=e("./internal/observable/never");Object.defineProperty(n,"NEVER",{enumerable:!0,get:function(){return ue.NEVER}}),s(e("./internal/types"),n);var le=e("./internal/config");Object.defineProperty(n,"config",{enumerable:!0,get:function(){return le.config}});var de=e("./internal/operators/audit");Object.defineProperty(n,"audit",{enumerable:!0,get:function(){return de.audit}});var ce=e("./internal/operators/auditTime");Object.defineProperty(n,"auditTime",{enumerable:!0,get:function(){return ce.auditTime}});var me=e("./internal/operators/buffer");Object.defineProperty(n,"buffer",{enumerable:!0,get:function(){return me.buffer}});var he=e("./internal/operators/bufferCount");Object.defineProperty(n,"bufferCount",{enumerable:!0,get:function(){return he.bufferCount}});var be=e("./internal/operators/bufferTime");Object.defineProperty(n,"bufferTime",{enumerable:!0,get:function(){return be.bufferTime}});var pe=e("./internal/operators/bufferToggle");Object.defineProperty(n,"bufferToggle",{enumerable:!0,get:function(){return pe.bufferToggle}});var ke=e("./internal/operators/bufferWhen");Object.defineProperty(n,"bufferWhen",{enumerable:!0,get:function(){return ke.bufferWhen}});var xe=e("./internal/operators/catchError");Object.defineProperty(n,"catchError",{enumerable:!0,get:function(){return xe.catchError}});var je=e("./internal/operators/combineAll");Object.defineProperty(n,"combineAll",{enumerable:!0,get:function(){return je.combineAll}});var we=e("./internal/operators/combineLatestAll");Object.defineProperty(n,"combineLatestAll",{enumerable:!0,get:function(){return we.combineLatestAll}});var ge=e("./internal/operators/combineLatestWith");Object.defineProperty(n,"combineLatestWith",{enumerable:!0,get:function(){return ge.combineLatestWith}});var ye=e("./internal/operators/concatAll");Object.defineProperty(n,"concatAll",{enumerable:!0,get:function(){return ye.concatAll}});var _e=e("./internal/operators/concatMap");Object.defineProperty(n,"concatMap",{enumerable:!0,get:function(){return _e.concatMap}});var ve=e("./internal/operators/concatMapTo");Object.defineProperty(n,"concatMapTo",{enumerable:!0,get:function(){return ve.concatMapTo}});var Te=e("./internal/operators/concatWith");Object.defineProperty(n,"concatWith",{enumerable:!0,get:function(){return Te.concatWith}});var Se=e("./internal/operators/connect");Object.defineProperty(n,"connect",{enumerable:!0,get:function(){return Se.connect}});var Ee=e("./internal/operators/count");Object.defineProperty(n,"count",{enumerable:!0,get:function(){return Ee.count}});var Oe=e("./internal/operators/debounce");Object.defineProperty(n,"debounce",{enumerable:!0,get:function(){return Oe.debounce}});var Ae=e("./internal/operators/debounceTime");Object.defineProperty(n,"debounceTime",{enumerable:!0,get:function(){return Ae.debounceTime}});var Ce=e("./internal/operators/defaultIfEmpty");Object.defineProperty(n,"defaultIfEmpty",{enumerable:!0,get:function(){return Ce.defaultIfEmpty}});var Pe=e("./internal/operators/delay");Object.defineProperty(n,"delay",{enumerable:!0,get:function(){return Pe.delay}});var Ie=e("./internal/operators/delayWhen");Object.defineProperty(n,"delayWhen",{enumerable:!0,get:function(){return Ie.delayWhen}});var Me=e("./internal/operators/dematerialize");Object.defineProperty(n,"dematerialize",{enumerable:!0,get:function(){return Me.dematerialize}});var Re=e("./internal/operators/distinct");Object.defineProperty(n,"distinct",{enumerable:!0,get:function(){return Re.distinct}});var Le=e("./internal/operators/distinctUntilChanged");Object.defineProperty(n,"distinctUntilChanged",{enumerable:!0,get:function(){return Le.distinctUntilChanged}});var Be=e("./internal/operators/distinctUntilKeyChanged");Object.defineProperty(n,"distinctUntilKeyChanged",{enumerable:!0,get:function(){return Be.distinctUntilKeyChanged}});var Fe=e("./internal/operators/elementAt");Object.defineProperty(n,"elementAt",{enumerable:!0,get:function(){return Fe.elementAt}});var Ne=e("./internal/operators/endWith");Object.defineProperty(n,"endWith",{enumerable:!0,get:function(){return Ne.endWith}});var De=e("./internal/operators/every");Object.defineProperty(n,"every",{enumerable:!0,get:function(){return De.every}});var Ue=e("./internal/operators/exhaust");Object.defineProperty(n,"exhaust",{enumerable:!0,get:function(){return Ue.exhaust}});var He=e("./internal/operators/exhaustAll");Object.defineProperty(n,"exhaustAll",{enumerable:!0,get:function(){return He.exhaustAll}});var We=e("./internal/operators/exhaustMap");Object.defineProperty(n,"exhaustMap",{enumerable:!0,get:function(){return We.exhaustMap}});var Ge=e("./internal/operators/expand");Object.defineProperty(n,"expand",{enumerable:!0,get:function(){return Ge.expand}});var ze=e("./internal/operators/filter");Object.defineProperty(n,"filter",{enumerable:!0,get:function(){return ze.filter}});var Ve=e("./internal/operators/finalize");Object.defineProperty(n,"finalize",{enumerable:!0,get:function(){return Ve.finalize}});var qe=e("./internal/operators/find");Object.defineProperty(n,"find",{enumerable:!0,get:function(){return qe.find}});var Ke=e("./internal/operators/findIndex");Object.defineProperty(n,"findIndex",{enumerable:!0,get:function(){return Ke.findIndex}});var Ye=e("./internal/operators/first");Object.defineProperty(n,"first",{enumerable:!0,get:function(){return Ye.first}});var Je=e("./internal/operators/groupBy");Object.defineProperty(n,"groupBy",{enumerable:!0,get:function(){return Je.groupBy}});var Ze=e("./internal/operators/ignoreElements");Object.defineProperty(n,"ignoreElements",{enumerable:!0,get:function(){return Ze.ignoreElements}});var Xe=e("./internal/operators/isEmpty");Object.defineProperty(n,"isEmpty",{enumerable:!0,get:function(){return Xe.isEmpty}});var Qe=e("./internal/operators/last");Object.defineProperty(n,"last",{enumerable:!0,get:function(){return Qe.last}});var $e=e("./internal/operators/map");Object.defineProperty(n,"map",{enumerable:!0,get:function(){return $e.map}});var et=e("./internal/operators/mapTo");Object.defineProperty(n,"mapTo",{enumerable:!0,get:function(){return et.mapTo}});var tt=e("./internal/operators/materialize");Object.defineProperty(n,"materialize",{enumerable:!0,get:function(){return tt.materialize}});var nt=e("./internal/operators/max");Object.defineProperty(n,"max",{enumerable:!0,get:function(){return nt.max}});var rt=e("./internal/operators/mergeAll");Object.defineProperty(n,"mergeAll",{enumerable:!0,get:function(){return rt.mergeAll}});var st=e("./internal/operators/flatMap");Object.defineProperty(n,"flatMap",{enumerable:!0,get:function(){return st.flatMap}});var ot=e("./internal/operators/mergeMap");Object.defineProperty(n,"mergeMap",{enumerable:!0,get:function(){return ot.mergeMap}});var it=e("./internal/operators/mergeMapTo");Object.defineProperty(n,"mergeMapTo",{enumerable:!0,get:function(){return it.mergeMapTo}});var at=e("./internal/operators/mergeScan");Object.defineProperty(n,"mergeScan",{enumerable:!0,get:function(){return at.mergeScan}});var ft=e("./internal/operators/mergeWith");Object.defineProperty(n,"mergeWith",{enumerable:!0,get:function(){return ft.mergeWith}});var ut=e("./internal/operators/min");Object.defineProperty(n,"min",{enumerable:!0,get:function(){return ut.min}});var lt=e("./internal/operators/multicast");Object.defineProperty(n,"multicast",{enumerable:!0,get:function(){return lt.multicast}});var dt=e("./internal/operators/observeOn");Object.defineProperty(n,"observeOn",{enumerable:!0,get:function(){return dt.observeOn}});var ct=e("./internal/operators/onErrorResumeNextWith");Object.defineProperty(n,"onErrorResumeNextWith",{enumerable:!0,get:function(){return ct.onErrorResumeNextWith}});var mt=e("./internal/operators/pairwise");Object.defineProperty(n,"pairwise",{enumerable:!0,get:function(){return mt.pairwise}});var ht=e("./internal/operators/pluck");Object.defineProperty(n,"pluck",{enumerable:!0,get:function(){return ht.pluck}});var bt=e("./internal/operators/publish");Object.defineProperty(n,"publish",{enumerable:!0,get:function(){return bt.publish}});var pt=e("./internal/operators/publishBehavior");Object.defineProperty(n,"publishBehavior",{enumerable:!0,get:function(){return pt.publishBehavior}});var kt=e("./internal/operators/publishLast");Object.defineProperty(n,"publishLast",{enumerable:!0,get:function(){return kt.publishLast}});var xt=e("./internal/operators/publishReplay");Object.defineProperty(n,"publishReplay",{enumerable:!0,get:function(){return xt.publishReplay}});var jt=e("./internal/operators/raceWith");Object.defineProperty(n,"raceWith",{enumerable:!0,get:function(){return jt.raceWith}});var wt=e("./internal/operators/reduce");Object.defineProperty(n,"reduce",{enumerable:!0,get:function(){return wt.reduce}});var gt=e("./internal/operators/repeat");Object.defineProperty(n,"repeat",{enumerable:!0,get:function(){return gt.repeat}});var yt=e("./internal/operators/repeatWhen");Object.defineProperty(n,"repeatWhen",{enumerable:!0,get:function(){return yt.repeatWhen}});var _t=e("./internal/operators/retry");Object.defineProperty(n,"retry",{enumerable:!0,get:function(){return _t.retry}});var vt=e("./internal/operators/retryWhen");Object.defineProperty(n,"retryWhen",{enumerable:!0,get:function(){return vt.retryWhen}});var Tt=e("./internal/operators/refCount");Object.defineProperty(n,"refCount",{enumerable:!0,get:function(){return Tt.refCount}});var St=e("./internal/operators/sample");Object.defineProperty(n,"sample",{enumerable:!0,get:function(){return St.sample}});var Et=e("./internal/operators/sampleTime");Object.defineProperty(n,"sampleTime",{enumerable:!0,get:function(){return Et.sampleTime}});var Ot=e("./internal/operators/scan");Object.defineProperty(n,"scan",{enumerable:!0,get:function(){return Ot.scan}});var At=e("./internal/operators/sequenceEqual");Object.defineProperty(n,"sequenceEqual",{enumerable:!0,get:function(){return At.sequenceEqual}});var Ct=e("./internal/operators/share");Object.defineProperty(n,"share",{enumerable:!0,get:function(){return Ct.share}});var Pt=e("./internal/operators/shareReplay");Object.defineProperty(n,"shareReplay",{enumerable:!0,get:function(){return Pt.shareReplay}});var It=e("./internal/operators/single");Object.defineProperty(n,"single",{enumerable:!0,get:function(){return It.single}});var Mt=e("./internal/operators/skip");Object.defineProperty(n,"skip",{enumerable:!0,get:function(){return Mt.skip}});var Rt=e("./internal/operators/skipLast");Object.defineProperty(n,"skipLast",{enumerable:!0,get:function(){return Rt.skipLast}});var Lt=e("./internal/operators/skipUntil");Object.defineProperty(n,"skipUntil",{enumerable:!0,get:function(){return Lt.skipUntil}});var Bt=e("./internal/operators/skipWhile");Object.defineProperty(n,"skipWhile",{enumerable:!0,get:function(){return Bt.skipWhile}});var Ft=e("./internal/operators/startWith");Object.defineProperty(n,"startWith",{enumerable:!0,get:function(){return Ft.startWith}});var Nt=e("./internal/operators/subscribeOn");Object.defineProperty(n,"subscribeOn",{enumerable:!0,get:function(){return Nt.subscribeOn}});var Dt=e("./internal/operators/switchAll");Object.defineProperty(n,"switchAll",{enumerable:!0,get:function(){return Dt.switchAll}});var Ut=e("./internal/operators/switchMap");Object.defineProperty(n,"switchMap",{enumerable:!0,get:function(){return Ut.switchMap}});var Ht=e("./internal/operators/switchMapTo");Object.defineProperty(n,"switchMapTo",{enumerable:!0,get:function(){return Ht.switchMapTo}});var Wt=e("./internal/operators/switchScan");Object.defineProperty(n,"switchScan",{enumerable:!0,get:function(){return Wt.switchScan}});var Gt=e("./internal/operators/take");Object.defineProperty(n,"take",{enumerable:!0,get:function(){return Gt.take}});var zt=e("./internal/operators/takeLast");Object.defineProperty(n,"takeLast",{enumerable:!0,get:function(){return zt.takeLast}});var Vt=e("./internal/operators/takeUntil");Object.defineProperty(n,"takeUntil",{enumerable:!0,get:function(){return Vt.takeUntil}});var qt=e("./internal/operators/takeWhile");Object.defineProperty(n,"takeWhile",{enumerable:!0,get:function(){return qt.takeWhile}});var Kt=e("./internal/operators/tap");Object.defineProperty(n,"tap",{enumerable:!0,get:function(){return Kt.tap}});var Yt=e("./internal/operators/throttle");Object.defineProperty(n,"throttle",{enumerable:!0,get:function(){return Yt.throttle}});var Jt=e("./internal/operators/throttleTime");Object.defineProperty(n,"throttleTime",{enumerable:!0,get:function(){return Jt.throttleTime}});var Zt=e("./internal/operators/throwIfEmpty");Object.defineProperty(n,"throwIfEmpty",{enumerable:!0,get:function(){return Zt.throwIfEmpty}});var Xt=e("./internal/operators/timeInterval");Object.defineProperty(n,"timeInterval",{enumerable:!0,get:function(){return Xt.timeInterval}});var Qt=e("./internal/operators/timeout");Object.defineProperty(n,"timeout",{enumerable:!0,get:function(){return Qt.timeout}});var $t=e("./internal/operators/timeoutWith");Object.defineProperty(n,"timeoutWith",{enumerable:!0,get:function(){return $t.timeoutWith}});var en=e("./internal/operators/timestamp");Object.defineProperty(n,"timestamp",{enumerable:!0,get:function(){return en.timestamp}});var tn=e("./internal/operators/toArray");Object.defineProperty(n,"toArray",{enumerable:!0,get:function(){return tn.toArray}});var nn=e("./internal/operators/window");Object.defineProperty(n,"window",{enumerable:!0,get:function(){return nn.window}});var rn=e("./internal/operators/windowCount");Object.defineProperty(n,"windowCount",{enumerable:!0,get:function(){return rn.windowCount}});var sn=e("./internal/operators/windowTime");Object.defineProperty(n,"windowTime",{enumerable:!0,get:function(){return sn.windowTime}});var on=e("./internal/operators/windowToggle");Object.defineProperty(n,"windowToggle",{enumerable:!0,get:function(){return on.windowToggle}});var an=e("./internal/operators/windowWhen");Object.defineProperty(n,"windowWhen",{enumerable:!0,get:function(){return an.windowWhen}});var fn=e("./internal/operators/withLatestFrom");Object.defineProperty(n,"withLatestFrom",{enumerable:!0,get:function(){return fn.withLatestFrom}});var un=e("./internal/operators/zipAll");Object.defineProperty(n,"zipAll",{enumerable:!0,get:function(){return un.zipAll}});var ln=e("./internal/operators/zipWith");Object.defineProperty(n,"zipWith",{enumerable:!0,get:function(){return ln.zipWith}})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/AsyncSubject.js",{"./Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncSubject=void 0;var o=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._value=null,t._hasValue=!1,t._isComplete=!1,t}return s(t,e),t.prototype._checkFinalizedStatuses=function(e){var t=this,n=t.hasError,r=t._hasValue,s=t._value,o=t.thrownError,i=t.isStopped,a=t._isComplete;n?e.error(o):(i||a)&&(r&&e.next(s),e.complete())},t.prototype.next=function(e){this.isStopped||(this._value=e,this._hasValue=!0)},t.prototype.complete=function(){var t=this,n=t._hasValue,r=t._value;t._isComplete||(this._isComplete=!0,n&&e.prototype.next.call(this,r),e.prototype.complete.call(this))},t}(e("./Subject").Subject);n.AsyncSubject=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/AsyncSubject.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/BehaviorSubject.js",{"./Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.BehaviorSubject=void 0;var o=function(e){function t(t){var n=e.call(this)||this;return n._value=t,n}return s(t,e),Object.defineProperty(t.prototype,"value",{get:function(){return this.getValue()},enumerable:!1,configurable:!0}),t.prototype._subscribe=function(t){var n=e.prototype._subscribe.call(this,t);return!n.closed&&t.next(this._value),n},t.prototype.getValue=function(){var e=this,t=e.hasError,n=e.thrownError,r=e._value;if(t)throw n;return this._throwIfClosed(),r},t.prototype.next=function(t){e.prototype.next.call(this,this._value=t)},t}(e("./Subject").Subject);n.BehaviorSubject=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/BehaviorSubject.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Notification.js",{"./observable/empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","./observable/of":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/of.js","./observable/throwError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/throwError.js","./util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.observeNotification=n.Notification=n.NotificationKind=void 0;var r=e("./observable/empty"),s=e("./observable/of"),o=e("./observable/throwError"),i=e("./util/isFunction");!function(e){e.NEXT="N",e.ERROR="E",e.COMPLETE="C"}(n.NotificationKind||(n.NotificationKind={}));var a=function(){function e(e,t,n){this.kind=e,this.value=t,this.error=n,this.hasValue="N"===e}return e.prototype.observe=function(e){return f(this,e)},e.prototype.do=function(e,t,n){var r=this,s=r.kind,o=r.value,i=r.error;return"N"===s?null==e?void 0:e(o):"E"===s?null==t?void 0:t(i):null==n?void 0:n()},e.prototype.accept=function(e,t,n){var r;return i.isFunction(null===(r=e)||void 0===r?void 0:r.next)?this.observe(e):this.do(e,t,n)},e.prototype.toObservable=function(){var e=this,t=e.kind,n=e.value,i=e.error,a="N"===t?s.of(n):"E"===t?o.throwError(function(){return i}):"C"===t?r.EMPTY:0;if(!a)throw new TypeError("Unexpected notification kind "+t);return a},e.createNext=function(t){return new e("N",t)},e.createError=function(t){return new e("E",undefined,t)},e.createComplete=function(){return e.completeNotification},e.completeNotification=new e("C"),e}();function f(e,t){var n,r,s,o=e,i=o.kind,a=o.value,f=o.error;if("string"!=typeof i)throw new TypeError('Invalid notification, missing "kind"');"N"===i?null===(n=t.next)||void 0===n||n.call(t,a):"E"===i?null===(r=t.error)||void 0===r||r.call(t,f):null===(s=t.complete)||void 0===s||s.call(t)}n.Notification=a,n.observeNotification=f}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/Notification.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/NotificationFactories.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n){return{kind:e,value:t,error:n}}Object.defineProperty(n,"__esModule",{value:!0}),n.createNotification=n.nextNotification=n.errorNotification=n.COMPLETE_NOTIFICATION=void 0,n.COMPLETE_NOTIFICATION=r("C",undefined,undefined),n.errorNotification=function(e){return r("E",undefined,e)},n.nextNotification=function(e){return r("N",e,undefined)},n.createNotification=r}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/NotificationFactories.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js",{"./Subscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscriber.js","./Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","./config":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/config.js","./symbol/observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/observable.js","./util/errorContext":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/errorContext.js","./util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./util/pipe":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/pipe.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Observable=void 0;var r=e("./Subscriber"),s=e("./Subscription"),o=e("./symbol/observable"),i=e("./util/pipe"),a=e("./config"),f=e("./util/isFunction"),u=e("./util/errorContext"),l=function(){function e(e){e&&(this._subscribe=e)}return e.prototype.lift=function(t){var n=new e;return n.source=this,n.operator=t,n},e.prototype.subscribe=function(e,t,n){var o,i=this,a=(o=e)&&o instanceof r.Subscriber||function(e){return e&&f.isFunction(e.next)&&f.isFunction(e.error)&&f.isFunction(e.complete)}(o)&&s.isSubscription(o)?e:new r.SafeSubscriber(e,t,n);return u.errorContext(function(){var e=i,t=e.operator,n=e.source;a.add(t?t.call(a,n):n?i._subscribe(a):i._trySubscribe(a))}),a},e.prototype._trySubscribe=function(e){try{return this._subscribe(e)}catch(t){e.error(t)}},e.prototype.forEach=function(e,t){var n=this;return new(t=d(t))(function(t,s){var o=new r.SafeSubscriber({next:function(t){try{e(t)}catch(e){s(e),o.unsubscribe()}},error:s,complete:t});n.subscribe(o)})},e.prototype._subscribe=function(e){var t;return null===(t=this.source)||void 0===t?void 0:t.subscribe(e)},e.prototype[o.observable]=function(){return this},e.prototype.pipe=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return i.pipeFromArray(e)(this)},e.prototype.toPromise=function(e){var t=this;return new(e=d(e))(function(e,n){var r;t.subscribe(function(e){return r=e},function(e){return n(e)},function(){return e(r)})})},e.create=function(t){return new e(t)},e}();function d(e){var t;return null!==(t=null!=e?e:a.config.Promise)&&void 0!==t?t:Promise}n.Observable=l}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/Observable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/ReplaySubject.js",{"./Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","./scheduler/dateTimestampProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/dateTimestampProvider.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.ReplaySubject=void 0;var o=e("./Subject"),i=e("./scheduler/dateTimestampProvider"),a=function(e){function t(t,n,r){void 0===t&&(t=Infinity),void 0===n&&(n=Infinity),void 0===r&&(r=i.dateTimestampProvider);var s=e.call(this)||this;return s._bufferSize=t,s._windowTime=n,s._timestampProvider=r,s._buffer=[],s._infiniteTimeWindow=!0,s._infiniteTimeWindow=n===Infinity,s._bufferSize=Math.max(1,t),s._windowTime=Math.max(1,n),s}return s(t,e),t.prototype.next=function(t){var n=this,r=n.isStopped,s=n._buffer,o=n._infiniteTimeWindow,i=n._timestampProvider,a=n._windowTime;r||(s.push(t),!o&&s.push(i.now()+a)),this._trimBuffer(),e.prototype.next.call(this,t)},t.prototype._subscribe=function(e){this._throwIfClosed(),this._trimBuffer();for(var t=this._innerSubscribe(e),n=this._infiniteTimeWindow,r=this._buffer.slice(),s=0;s<r.length&&!e.closed;s+=n?1:2)e.next(r[s]);return this._checkFinalizedStatuses(e),t},t.prototype._trimBuffer=function(){var e=this,t=e._bufferSize,n=e._timestampProvider,r=e._buffer,s=e._infiniteTimeWindow,o=(s?1:2)*t;if(t<Infinity&&o<r.length&&r.splice(0,r.length-o),!s){for(var i=n.now(),a=0,f=1;f<r.length&&r[f]<=i;f+=2)a=f;a&&r.splice(0,a+1)}},t}(o.Subject);n.ReplaySubject=a}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/ReplaySubject.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Scheduler.js",{"./scheduler/dateTimestampProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/dateTimestampProvider.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Scheduler=void 0;var r=e("./scheduler/dateTimestampProvider"),s=function(){function e(t,n){void 0===n&&(n=e.now),this.schedulerActionCtor=t,this.now=n}return e.prototype.schedule=function(e,t,n){return void 0===t&&(t=0),new this.schedulerActionCtor(this,e).schedule(n,t)},e.now=r.dateTimestampProvider.now,e}();n.Scheduler=s}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/Scheduler.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js",{"./Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","./Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","./util/ObjectUnsubscribedError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/ObjectUnsubscribedError.js","./util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","./util/errorContext":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/errorContext.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),o=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.AnonymousSubject=n.Subject=void 0;var i=e("./Observable"),a=e("./Subscription"),f=e("./util/ObjectUnsubscribedError"),u=e("./util/arrRemove"),l=e("./util/errorContext"),d=function(e){function t(){var t=e.call(this)||this;return t.closed=!1,t.currentObservers=null,t.observers=[],t.isStopped=!1,t.hasError=!1,t.thrownError=null,t}return s(t,e),t.prototype.lift=function(e){var t=new c(this,this);return t.operator=e,t},t.prototype._throwIfClosed=function(){if(this.closed)throw new f.ObjectUnsubscribedError},t.prototype.next=function(e){var t=this;l.errorContext(function(){var n,r;if(t._throwIfClosed(),!t.isStopped){t.currentObservers||(t.currentObservers=Array.from(t.observers));try{for(var s=o(t.currentObservers),i=s.next();!i.done;i=s.next()){i.value.next(e)}}catch(e){n={error:e}}finally{try{i&&!i.done&&(r=s.return)&&r.call(s)}finally{if(n)throw n.error}}}})},t.prototype.error=function(e){var t=this;l.errorContext(function(){if(t._throwIfClosed(),!t.isStopped){t.hasError=t.isStopped=!0,t.thrownError=e;for(var n=t.observers;n.length;)n.shift().error(e)}})},t.prototype.complete=function(){var e=this;l.errorContext(function(){if(e._throwIfClosed(),!e.isStopped){e.isStopped=!0;for(var t=e.observers;t.length;)t.shift().complete()}})},t.prototype.unsubscribe=function(){this.isStopped=this.closed=!0,this.observers=this.currentObservers=null},Object.defineProperty(t.prototype,"observed",{get:function(){var e;return(null===(e=this.observers)||void 0===e?void 0:e.length)>0},enumerable:!1,configurable:!0}),t.prototype._trySubscribe=function(t){return this._throwIfClosed(),e.prototype._trySubscribe.call(this,t)},t.prototype._subscribe=function(e){return this._throwIfClosed(),this._checkFinalizedStatuses(e),this._innerSubscribe(e)},t.prototype._innerSubscribe=function(e){var t=this,n=this,r=n.hasError,s=n.isStopped,o=n.observers;return r||s?a.EMPTY_SUBSCRIPTION:(this.currentObservers=null,o.push(e),new a.Subscription(function(){t.currentObservers=null,u.arrRemove(o,e)}))},t.prototype._checkFinalizedStatuses=function(e){var t=this,n=t.hasError,r=t.thrownError,s=t.isStopped;n?e.error(r):s&&e.complete()},t.prototype.asObservable=function(){var e=new i.Observable;return e.source=this,e},t.create=function(e,t){return new c(e,t)},t}(i.Observable);n.Subject=d;var c=function(e){function t(t,n){var r=e.call(this)||this;return r.destination=t,r.source=n,r}return s(t,e),t.prototype.next=function(e){var t,n;null===(n=null===(t=this.destination)||void 0===t?void 0:t.next)||void 0===n||n.call(t,e)},t.prototype.error=function(e){var t,n;null===(n=null===(t=this.destination)||void 0===t?void 0:t.error)||void 0===n||n.call(t,e)},t.prototype.complete=function(){var e,t;null===(t=null===(e=this.destination)||void 0===e?void 0:e.complete)||void 0===t||t.call(e)},t.prototype._subscribe=function(e){var t,n;return null!==(n=null===(t=this.source)||void 0===t?void 0:t.subscribe(e))&&void 0!==n?n:a.EMPTY_SUBSCRIPTION},t}(d);n.AnonymousSubject=c}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/Subject.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscriber.js",{"./NotificationFactories":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/NotificationFactories.js","./Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","./config":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/config.js","./scheduler/timeoutProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/timeoutProvider.js","./util/errorContext":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/errorContext.js","./util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./util/reportUnhandledError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/reportUnhandledError.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.EMPTY_OBSERVER=n.SafeSubscriber=n.Subscriber=void 0;var o=e("./util/isFunction"),i=e("./Subscription"),a=e("./config"),f=e("./util/reportUnhandledError"),u=e("./util/noop"),l=e("./NotificationFactories"),d=e("./scheduler/timeoutProvider"),c=e("./util/errorContext"),m=function(e){function t(t){var r=e.call(this)||this;return r.isStopped=!1,t?(r.destination=t,i.isSubscription(t)&&t.add(r)):r.destination=n.EMPTY_OBSERVER,r}return s(t,e),t.create=function(e,t,n){return new k(e,t,n)},t.prototype.next=function(e){this.isStopped?j(l.nextNotification(e),this):this._next(e)},t.prototype.error=function(e){this.isStopped?j(l.errorNotification(e),this):(this.isStopped=!0,this._error(e))},t.prototype.complete=function(){this.isStopped?j(l.COMPLETE_NOTIFICATION,this):(this.isStopped=!0,this._complete())},t.prototype.unsubscribe=function(){this.closed||(this.isStopped=!0,e.prototype.unsubscribe.call(this),this.destination=null)},t.prototype._next=function(e){this.destination.next(e)},t.prototype._error=function(e){try{this.destination.error(e)}finally{this.unsubscribe()}},t.prototype._complete=function(){try{this.destination.complete()}finally{this.unsubscribe()}},t}(i.Subscription);n.Subscriber=m;var h=Function.prototype.bind;function b(e,t){return h.call(e,t)}var p=function(){function e(e){this.partialObserver=e}return e.prototype.next=function(e){var t=this.partialObserver;if(t.next)try{t.next(e)}catch(e){x(e)}},e.prototype.error=function(e){var t=this.partialObserver;if(t.error)try{t.error(e)}catch(e){x(e)}else x(e)},e.prototype.complete=function(){var e=this.partialObserver;if(e.complete)try{e.complete()}catch(e){x(e)}},e}(),k=function(e){function t(t,n,r){var s,i,f=e.call(this)||this;o.isFunction(t)||!t?s={next:null!=t?t:undefined,error:null!=n?n:undefined,complete:null!=r?r:undefined}:f&&a.config.useDeprecatedNextContext?((i=Object.create(t)).unsubscribe=function(){return f.unsubscribe()},s={next:t.next&&b(t.next,i),error:t.error&&b(t.error,i),complete:t.complete&&b(t.complete,i)}):s=t;return f.destination=new p(s),f}return s(t,e),t}(m);function x(e){a.config.useDeprecatedSynchronousErrorHandling?c.captureError(e):f.reportUnhandledError(e)}function j(e,t){var n=a.config.onStoppedNotification;n&&d.timeoutProvider.setTimeout(function(){return n(e,t)})}n.SafeSubscriber=k,n.EMPTY_OBSERVER={closed:!0,next:u.noop,error:function(e){throw e},complete:u.noop}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/Subscriber.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js",{"./util/UnsubscriptionError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/UnsubscriptionError.js","./util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","./util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")},s=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},o=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.isSubscription=n.EMPTY_SUBSCRIPTION=n.Subscription=void 0;var i=e("./util/isFunction"),a=e("./util/UnsubscriptionError"),f=e("./util/arrRemove"),u=function(){function e(e){this.initialTeardown=e,this.closed=!1,this._parentage=null,this._finalizers=null}var t;return e.prototype.unsubscribe=function(){var e,t,n,f,u;if(!this.closed){this.closed=!0;var d=this._parentage;if(d)if(this._parentage=null,Array.isArray(d))try{for(var c=r(d),m=c.next();!m.done;m=c.next()){m.value.remove(this)}}catch(t){e={error:t}}finally{try{m&&!m.done&&(t=c.return)&&t.call(c)}finally{if(e)throw e.error}}else d.remove(this);var h=this.initialTeardown;if(i.isFunction(h))try{h()}catch(e){u=e instanceof a.UnsubscriptionError?e.errors:[e]}var b=this._finalizers;if(b){this._finalizers=null;try{for(var p=r(b),k=p.next();!k.done;k=p.next()){var x=k.value;try{l(x)}catch(e){u=null!=u?u:[],e instanceof a.UnsubscriptionError?u=o(o([],s(u)),s(e.errors)):u.push(e)}}}catch(e){n={error:e}}finally{try{k&&!k.done&&(f=p.return)&&f.call(p)}finally{if(n)throw n.error}}}if(u)throw new a.UnsubscriptionError(u)}},e.prototype.add=function(t){var n;if(t&&t!==this)if(this.closed)l(t);else{if(t instanceof e){if(t.closed||t._hasParent(this))return;t._addParent(this)}(this._finalizers=null!==(n=this._finalizers)&&void 0!==n?n:[]).push(t)}},e.prototype._hasParent=function(e){var t=this._parentage;return t===e||Array.isArray(t)&&t.includes(e)},e.prototype._addParent=function(e){var t=this._parentage;this._parentage=Array.isArray(t)?(t.push(e),t):t?[t,e]:e},e.prototype._removeParent=function(e){var t=this._parentage;t===e?this._parentage=null:Array.isArray(t)&&f.arrRemove(t,e)},e.prototype.remove=function(t){var n=this._finalizers;n&&f.arrRemove(n,t),t instanceof e&&t._removeParent(this)},e.EMPTY=((t=new e).closed=!0,t),e}();function l(e){i.isFunction(e)?e():e.unsubscribe()}n.Subscription=u,n.EMPTY_SUBSCRIPTION=u.EMPTY,n.isSubscription=function(e){return e instanceof u||e&&"closed"in e&&i.isFunction(e.remove)&&i.isFunction(e.add)&&i.isFunction(e.unsubscribe)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/Subscription.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/config.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.config=void 0,n.config={onUnhandledError:null,onStoppedNotification:null,Promise:undefined,useDeprecatedSynchronousErrorHandling:!1,useDeprecatedNextContext:!1}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/config.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/firstValueFrom.js",{"./Subscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscriber.js","./util/EmptyError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.firstValueFrom=void 0;var r=e("./util/EmptyError"),s=e("./Subscriber");n.firstValueFrom=function(e,t){var n="object"==typeof t;return new Promise(function(o,i){var a=new s.SafeSubscriber({next:function(e){o(e),a.unsubscribe()},error:i,complete:function(){n?o(t.defaultValue):i(new r.EmptyError)}});e.subscribe(a)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/firstValueFrom.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/lastValueFrom.js",{"./util/EmptyError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.lastValueFrom=void 0;var r=e("./util/EmptyError");n.lastValueFrom=function(e,t){var n="object"==typeof t;return new Promise(function(s,o){var i,a=!1;e.subscribe({next:function(e){i=e,a=!0},error:o,complete:function(){a?s(i):n?s(t.defaultValue):o(new r.EmptyError)}})})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/lastValueFrom.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/ConnectableObservable.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","../operators/OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js","../operators/refCount":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/refCount.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.ConnectableObservable=void 0;var o=e("../Observable"),i=e("../Subscription"),a=e("../operators/refCount"),f=e("../operators/OperatorSubscriber"),u=e("../util/lift"),l=function(e){function t(t,n){var r=e.call(this)||this;return r.source=t,r.subjectFactory=n,r._subject=null,r._refCount=0,r._connection=null,u.hasLift(t)&&(r.lift=t.lift),r}return s(t,e),t.prototype._subscribe=function(e){return this.getSubject().subscribe(e)},t.prototype.getSubject=function(){var e=this._subject;return e&&!e.isStopped||(this._subject=this.subjectFactory()),this._subject},t.prototype._teardown=function(){this._refCount=0;var e=this._connection;this._subject=this._connection=null,null==e||e.unsubscribe()},t.prototype.connect=function(){var e=this,t=this._connection;if(!t){t=this._connection=new i.Subscription;var n=this.getSubject();t.add(this.source.subscribe(f.createOperatorSubscriber(n,undefined,function(){e._teardown(),n.complete()},function(t){e._teardown(),n.error(t)},function(){return e._teardown()}))),t.closed&&(this._connection=null,t=i.Subscription.EMPTY)}return t},t.prototype.refCount=function(){return a.refCount()(this)},t}(o.Observable);n.ConnectableObservable=l}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/ConnectableObservable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/bindCallback.js",{"./bindCallbackInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/bindCallbackInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.bindCallback=void 0;var r=e("./bindCallbackInternals");n.bindCallback=function(e,t,n){return r.bindCallbackInternals(!1,e,t,n)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/bindCallback.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/bindCallbackInternals.js",{"../AsyncSubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/AsyncSubject.js","../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../operators/observeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/observeOn.js","../operators/subscribeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/subscribeOn.js","../util/isScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isScheduler.js","../util/mapOneOrManyArgs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.bindCallbackInternals=void 0;var o=e("../util/isScheduler"),i=e("../Observable"),a=e("../operators/subscribeOn"),f=e("../util/mapOneOrManyArgs"),u=e("../operators/observeOn"),l=e("../AsyncSubject");n.bindCallbackInternals=function e(t,n,d,c){if(d){if(!o.isScheduler(d))return function(){for(var r=[],s=0;s<arguments.length;s++)r[s]=arguments[s];return e(t,n,c).apply(this,r).pipe(f.mapOneOrManyArgs(d))};c=d}return c?function(){for(var r=[],s=0;s<arguments.length;s++)r[s]=arguments[s];return e(t,n).apply(this,r).pipe(a.subscribeOn(c),u.observeOn(c))}:function(){for(var e=this,o=[],a=0;a<arguments.length;a++)o[a]=arguments[a];var f=new l.AsyncSubject,u=!0;return new i.Observable(function(i){var a=f.subscribe(i);if(u){u=!1;var l=!1,d=!1;n.apply(e,s(s([],r(o)),[function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];if(t){var r=e.shift();if(null!=r)return void f.error(r)}f.next(1<e.length?e:e[0]),d=!0,l&&f.complete()}])),d&&f.complete(),l=!0}return a})}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/bindCallbackInternals.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/bindNodeCallback.js",{"./bindCallbackInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/bindCallbackInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.bindNodeCallback=void 0;var r=e("./bindCallbackInternals");n.bindNodeCallback=function(e,t,n){return r.bindCallbackInternals(!0,e,t,n)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/bindNodeCallback.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/combineLatest.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../operators/OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/argsArgArrayOrObject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsArgArrayOrObject.js","../util/createObject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createObject.js","../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js","../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/mapOneOrManyArgs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js","./from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.combineLatestInit=n.combineLatest=void 0;var r=e("../Observable"),s=e("../util/argsArgArrayOrObject"),o=e("./from"),i=e("../util/identity"),a=e("../util/mapOneOrManyArgs"),f=e("../util/args"),u=e("../util/createObject"),l=e("../operators/OperatorSubscriber"),d=e("../util/executeSchedule");function c(e,t,n){return void 0===n&&(n=i.identity),function(r){m(t,function(){for(var s=e.length,i=new Array(s),a=s,f=s,u=function(s){m(t,function(){var u=o.from(e[s],t),d=!1;u.subscribe(l.createOperatorSubscriber(r,function(e){i[s]=e,d||(d=!0,f--),f||r.next(n(i.slice()))},function(){--a||r.complete()}))},r)},d=0;d<s;d++)u(d)},r)}}function m(e,t,n){e?d.executeSchedule(n,e,t):t()}n.combineLatest=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=f.popScheduler(e),l=f.popResultSelector(e),d=s.argsArgArrayOrObject(e),m=d.args,h=d.keys;if(0===m.length)return o.from([],n);var b=new r.Observable(c(m,n,h?function(e){return u.createObject(h,e)}:i.identity));return l?b.pipe(a.mapOneOrManyArgs(l)):b},n.combineLatestInit=c}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/combineLatest.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/concat.js",{"../operators/concatAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatAll.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","./from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.concat=void 0;var r=e("../operators/concatAll"),s=e("../util/args"),o=e("./from");n.concat=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return r.concatAll()(o.from(e,s.popScheduler(e)))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/concat.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/connectable.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","./defer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/defer.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.connectable=void 0;var r=e("../Subject"),s=e("../Observable"),o=e("./defer"),i={connector:function(){return new r.Subject},resetOnDisconnect:!0};n.connectable=function(e,t){void 0===t&&(t=i);var n=null,r=t.connector,a=t.resetOnDisconnect,f=void 0===a||a,u=r(),l=new s.Observable(function(e){return u.subscribe(e)});return l.connect=function(){return n&&!n.closed||(n=o.defer(function(){return e}).subscribe(u),f&&n.add(function(){return u=r()})),n},l}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/connectable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/defer.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.defer=void 0;var r=e("../Observable"),s=e("./innerFrom");n.defer=function(e){return new r.Observable(function(t){s.innerFrom(e()).subscribe(t)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/defer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/dom/animationFrames.js",{"../../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../../scheduler/animationFrameProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/animationFrameProvider.js","../../scheduler/performanceTimestampProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/performanceTimestampProvider.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.animationFrames=void 0;var r=e("../../Observable"),s=e("../../scheduler/performanceTimestampProvider"),o=e("../../scheduler/animationFrameProvider");function i(e){return new r.Observable(function(t){var n=e||s.performanceTimestampProvider,r=n.now(),i=0,a=function(){t.closed||(i=o.animationFrameProvider.requestAnimationFrame(function(s){i=0;var o=n.now();t.next({timestamp:e?o:s,elapsed:o-r}),a()}))};return a(),function(){i&&o.animationFrameProvider.cancelAnimationFrame(i)}})}n.animationFrames=function(e){return e?i(e):a};var a=i()}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/dom/animationFrames.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.empty=n.EMPTY=void 0;var r=e("../Observable");n.EMPTY=new r.Observable(function(e){return e.complete()}),n.empty=function(e){return e?function(e){return new r.Observable(function(t){return e.schedule(function(){return t.complete()})})}(e):n.EMPTY}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/empty.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/forkJoin.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../operators/OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/argsArgArrayOrObject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsArgArrayOrObject.js","../util/createObject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createObject.js","../util/mapOneOrManyArgs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.forkJoin=void 0;var r=e("../Observable"),s=e("../util/argsArgArrayOrObject"),o=e("./innerFrom"),i=e("../util/args"),a=e("../operators/OperatorSubscriber"),f=e("../util/mapOneOrManyArgs"),u=e("../util/createObject");n.forkJoin=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=i.popResultSelector(e),l=s.argsArgArrayOrObject(e),d=l.args,c=l.keys,m=new r.Observable(function(e){var t=d.length;if(t)for(var n=new Array(t),r=t,s=t,i=function(t){var i=!1;o.innerFrom(d[t]).subscribe(a.createOperatorSubscriber(e,function(e){i||(i=!0,s--),n[t]=e},function(){return r--},undefined,function(){r&&i||(s||e.next(c?u.createObject(c,n):n),e.complete())}))},f=0;f<t;f++)i(f);else e.complete()});return n?m.pipe(f.mapOneOrManyArgs(n)):m}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/forkJoin.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js",{"../scheduled/scheduled":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduled.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.from=void 0;var r=e("../scheduled/scheduled"),s=e("./innerFrom");n.from=function(e,t){return t?r.scheduled(e,t):s.innerFrom(e)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/from.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/fromEvent.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../operators/mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js","../util/isArrayLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isArrayLike.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","../util/mapOneOrManyArgs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i};Object.defineProperty(n,"__esModule",{value:!0}),n.fromEvent=void 0;var s=e("../observable/innerFrom"),o=e("../Observable"),i=e("../operators/mergeMap"),a=e("../util/isArrayLike"),f=e("../util/isFunction"),u=e("../util/mapOneOrManyArgs"),l=["addListener","removeListener"],d=["addEventListener","removeEventListener"],c=["on","off"];function m(e,t){return function(n){return function(r){return e[n](t,r)}}}n.fromEvent=function e(t,n,h,b){if(f.isFunction(h)&&(b=h,h=undefined),b)return e(t,n,h).pipe(u.mapOneOrManyArgs(b));var p=r(function(e){return f.isFunction(e.addEventListener)&&f.isFunction(e.removeEventListener)}(t)?d.map(function(e){return function(r){return t[e](n,r,h)}}):function(e){return f.isFunction(e.addListener)&&f.isFunction(e.removeListener)}(t)?l.map(m(t,n)):function(e){return f.isFunction(e.on)&&f.isFunction(e.off)}(t)?c.map(m(t,n)):[],2),k=p[0],x=p[1];if(!k&&a.isArrayLike(t))return i.mergeMap(function(t){return e(t,n,h)})(s.innerFrom(t));if(!k)throw new TypeError("Invalid event target");return new o.Observable(function(e){var t=function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return e.next(1<t.length?t:t[0])};return k(t),function(){return x(t)}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/fromEvent.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/fromEventPattern.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","../util/mapOneOrManyArgs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.fromEventPattern=void 0;var r=e("../Observable"),s=e("../util/isFunction"),o=e("../util/mapOneOrManyArgs");n.fromEventPattern=function e(t,n,i){return i?e(t,n).pipe(o.mapOneOrManyArgs(i)):new r.Observable(function(e){var r=function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return e.next(1===t.length?t[0]:t)},o=t(r);return s.isFunction(n)?function(){return n(r,o)}:undefined})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/fromEventPattern.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/fromSubscribable.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.fromSubscribable=void 0;var r=e("../Observable");n.fromSubscribable=function(e){return new r.Observable(function(t){return e.subscribe(t)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/fromSubscribable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/generate.js",{"../scheduled/scheduleIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleIterable.js","../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/isScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isScheduler.js","./defer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/defer.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__generator||function(e,t){var n,r,s,o,i={label:0,sent:function(){if(1&s[0])throw s[1];return s[1]},trys:[],ops:[]};return o={next:a(0),throw:a(1),return:a(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function a(o){return function(a){return function(o){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(s=2&o[0]?r.return:o[0]?r.throw||((s=r.return)&&s.call(r),0):r.next)&&!(s=s.call(r,o[1])).done)return s;switch(r=0,s&&(o=[2&o[0],s.value]),o[0]){case 0:case 1:s=o;break;case 4:return i.label++,{value:o[1],done:!1};case 5:i.label++,r=o[1],o=[0];continue;case 7:o=i.ops.pop(),i.trys.pop();continue;default:if(!(s=i.trys,(s=s.length>0&&s[s.length-1])||6!==o[0]&&2!==o[0])){i=0;continue}if(3===o[0]&&(!s||o[1]>s[0]&&o[1]<s[3])){i.label=o[1];break}if(6===o[0]&&i.label<s[1]){i.label=s[1],s=o;break}if(s&&i.label<s[2]){i.label=s[2],i.ops.push(o);break}s[2]&&i.ops.pop(),i.trys.pop();continue}o=t.call(e,i)}catch(e){o=[6,e],r=0}finally{n=s=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,a])}}};Object.defineProperty(n,"__esModule",{value:!0}),n.generate=void 0;var s=e("../util/identity"),o=e("../util/isScheduler"),i=e("./defer"),a=e("../scheduled/scheduleIterable");n.generate=function(e,t,n,f,u){var l,d,c,m;function h(){var e;return r(this,function(r){switch(r.label){case 0:e=m,r.label=1;case 1:return t&&!t(e)?[3,4]:[4,c(e)];case 2:r.sent(),r.label=3;case 3:return e=n(e),[3,1];case 4:return[2]}})}return 1===arguments.length?(m=(l=e).initialState,t=l.condition,n=l.iterate,d=l.resultSelector,c=void 0===d?s.identity:d,u=l.scheduler):(m=e,!f||o.isScheduler(f)?(c=s.identity,u=f):c=f),i.defer(u?function(){return a.scheduleIterable(h(),u)}:h)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/generate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/iif.js",{"./defer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/defer.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.iif=void 0;var r=e("./defer");n.iif=function(e,t,n){return r.defer(function(){return e()?t:n})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/iif.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../symbol/observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/observable.js","../util/isArrayLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isArrayLike.js","../util/isAsyncIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isAsyncIterable.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","../util/isInteropObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isInteropObservable.js","../util/isIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isIterable.js","../util/isPromise":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isPromise.js","../util/isReadableStreamLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isReadableStreamLike.js","../util/reportUnhandledError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/reportUnhandledError.js","../util/throwUnobservableError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/throwUnobservableError.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))(function(s,o){function i(e){try{f(r.next(e))}catch(e){o(e)}}function a(e){try{f(r.throw(e))}catch(e){o(e)}}function f(e){var t;e.done?s(e.value):(t=e.value,t instanceof n?t:new n(function(e){e(t)})).then(i,a)}f((r=r.apply(e,t||[])).next())})},s=this&&this.__generator||function(e,t){var n,r,s,o,i={label:0,sent:function(){if(1&s[0])throw s[1];return s[1]},trys:[],ops:[]};return o={next:a(0),throw:a(1),return:a(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function a(o){return function(a){return function(o){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(s=2&o[0]?r.return:o[0]?r.throw||((s=r.return)&&s.call(r),0):r.next)&&!(s=s.call(r,o[1])).done)return s;switch(r=0,s&&(o=[2&o[0],s.value]),o[0]){case 0:case 1:s=o;break;case 4:return i.label++,{value:o[1],done:!1};case 5:i.label++,r=o[1],o=[0];continue;case 7:o=i.ops.pop(),i.trys.pop();continue;default:if(!(s=i.trys,(s=s.length>0&&s[s.length-1])||6!==o[0]&&2!==o[0])){i=0;continue}if(3===o[0]&&(!s||o[1]>s[0]&&o[1]<s[3])){i.label=o[1];break}if(6===o[0]&&i.label<s[1]){i.label=s[1],s=o;break}if(s&&i.label<s[2]){i.label=s[2],i.ops.push(o);break}s[2]&&i.ops.pop(),i.trys.pop();continue}o=t.call(e,i)}catch(e){o=[6,e],r=0}finally{n=s=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,a])}}},o=this&&this.__asyncValues||function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,n=e[Symbol.asyncIterator];return n?n.call(e):(e="function"==typeof i?i(e):e[Symbol.iterator](),t={},r("next"),r("throw"),r("return"),t[Symbol.asyncIterator]=function(){return this},t);function r(n){t[n]=e[n]&&function(t){return new Promise(function(r,s){(function(e,t,n,r){Promise.resolve(r).then(function(t){e({value:t,done:n})},t)})(r,s,(t=e[n](t)).done,t.value)})}}},i=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.fromReadableStreamLike=n.fromAsyncIterable=n.fromIterable=n.fromPromise=n.fromArrayLike=n.fromInteropObservable=n.innerFrom=void 0;var a=e("../util/isArrayLike"),f=e("../util/isPromise"),u=e("../Observable"),l=e("../util/isInteropObservable"),d=e("../util/isAsyncIterable"),c=e("../util/throwUnobservableError"),m=e("../util/isIterable"),h=e("../util/isReadableStreamLike"),b=e("../util/isFunction"),p=e("../util/reportUnhandledError"),k=e("../symbol/observable");function x(e){return new u.Observable(function(t){var n=e[k.observable]();if(b.isFunction(n.subscribe))return n.subscribe(t);throw new TypeError("Provided object does not correctly implement Symbol.observable")})}function j(e){return new u.Observable(function(t){for(var n=0;n<e.length&&!t.closed;n++)t.next(e[n]);t.complete()})}function w(e){return new u.Observable(function(t){e.then(function(e){t.closed||(t.next(e),t.complete())},function(e){return t.error(e)}).then(null,p.reportUnhandledError)})}function g(e){return new u.Observable(function(t){var n,r;try{for(var s=i(e),o=s.next();!o.done;o=s.next()){var a=o.value;if(t.next(a),t.closed)return}}catch(e){n={error:e}}finally{try{o&&!o.done&&(r=s.return)&&r.call(s)}finally{if(n)throw n.error}}t.complete()})}function y(e){return new u.Observable(function(t){(function(e,t){var n,i,a,f;return r(this,void 0,void 0,function(){var r,u;return s(this,function(s){switch(s.label){case 0:s.trys.push([0,5,6,11]),n=o(e),s.label=1;case 1:return[4,n.next()];case 2:if((i=s.sent()).done)return[3,4];if(r=i.value,t.next(r),t.closed)return[2];s.label=3;case 3:return[3,1];case 4:return[3,11];case 5:return u=s.sent(),a={error:u},[3,11];case 6:return s.trys.push([6,,9,10]),i&&!i.done&&(f=n.return)?[4,f.call(n)]:[3,8];case 7:s.sent(),s.label=8;case 8:return[3,10];case 9:if(a)throw a.error;return[7];case 10:return[7];case 11:return t.complete(),[2]}})})})(e,t).catch(function(e){return t.error(e)})})}function _(e){return y(h.readableStreamLikeToAsyncGenerator(e))}n.innerFrom=function(e){if(e instanceof u.Observable)return e;if(null!=e){if(l.isInteropObservable(e))return x(e);if(a.isArrayLike(e))return j(e);if(f.isPromise(e))return w(e);if(d.isAsyncIterable(e))return y(e);if(m.isIterable(e))return g(e);if(h.isReadableStreamLike(e))return _(e)}throw c.createInvalidObservableTypeError(e)},n.fromInteropObservable=x,n.fromArrayLike=j,n.fromPromise=w,n.fromIterable=g,n.fromAsyncIterable=y,n.fromReadableStreamLike=_}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/interval.js",{"../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","./timer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.interval=void 0;var r=e("../scheduler/async"),s=e("./timer");n.interval=function(e,t){return void 0===e&&(e=0),void 0===t&&(t=r.asyncScheduler),e<0&&(e=0),s.timer(e,e,t)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/interval.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/merge.js",{"../operators/mergeAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeAll.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","./empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","./from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.merge=void 0;var r=e("../operators/mergeAll"),s=e("./innerFrom"),o=e("./empty"),i=e("../util/args"),a=e("./from");n.merge=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=i.popScheduler(e),f=i.popNumber(e,Infinity),u=e;return u.length?1===u.length?s.innerFrom(u[0]):r.mergeAll(f)(a.from(u,n)):o.EMPTY}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/merge.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/never.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.never=n.NEVER=void 0;var r=e("../Observable"),s=e("../util/noop");n.NEVER=new r.Observable(s.noop),n.never=function(){return n.NEVER}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/never.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/of.js",{"../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","./from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.of=void 0;var r=e("../util/args"),s=e("./from");n.of=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=r.popScheduler(e);return s.from(e,n)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/of.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/onErrorResumeNext.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../operators/OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js","../util/argsOrArgArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.onErrorResumeNext=void 0;var r=e("../Observable"),s=e("../util/argsOrArgArray"),o=e("../operators/OperatorSubscriber"),i=e("../util/noop"),a=e("./innerFrom");n.onErrorResumeNext=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=s.argsOrArgArray(e);return new r.Observable(function(e){var t=0,r=function(){if(t<n.length){var s=void 0;try{s=a.innerFrom(n[t++])}catch(e){return void r()}var f=new o.OperatorSubscriber(e,undefined,i.noop,i.noop);s.subscribe(f),f.add(r)}else e.complete()};r()})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/onErrorResumeNext.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/pairs.js",{"./from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.pairs=void 0;var r=e("./from");n.pairs=function(e,t){return r.from(Object.entries(e),t)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/pairs.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/partition.js",{"../operators/filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/filter.js","../util/not":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/not.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.partition=void 0;var r=e("../util/not"),s=e("../operators/filter"),o=e("./innerFrom");n.partition=function(e,t,n){return[s.filter(t,n)(o.innerFrom(e)),s.filter(r.not(t,n))(o.innerFrom(e))]}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/partition.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/race.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../operators/OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js","../util/argsOrArgArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.raceInit=n.race=void 0;var r=e("../Observable"),s=e("./innerFrom"),o=e("../util/argsOrArgArray"),i=e("../operators/OperatorSubscriber");function a(e){return function(t){for(var n=[],r=function(r){n.push(s.innerFrom(e[r]).subscribe(i.createOperatorSubscriber(t,function(e){if(n){for(var s=0;s<n.length;s++)s!==r&&n[s].unsubscribe();n=null}t.next(e)})))},o=0;n&&!t.closed&&o<e.length;o++)r(o)}}n.race=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return 1===(e=o.argsOrArgArray(e)).length?s.innerFrom(e[0]):new r.Observable(a(e))},n.raceInit=a}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/race.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/range.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","./empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.range=void 0;var r=e("../Observable"),s=e("./empty");n.range=function(e,t,n){if(null==t&&(t=e,e=0),t<=0)return s.EMPTY;var o=t+e;return new r.Observable(n?function(t){var r=e;return n.schedule(function(){r<o?(t.next(r++),this.schedule()):t.complete()})}:function(t){for(var n=e;n<o&&!t.closed;)t.next(n++);t.complete()})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/range.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/throwError.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.throwError=void 0;var r=e("../Observable"),s=e("../util/isFunction");n.throwError=function(e,t){var n=s.isFunction(e)?e:function(){return e},o=function(e){return e.error(n())};return new r.Observable(t?function(e){return t.schedule(o,0,e)}:o)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/throwError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","../util/isDate":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isDate.js","../util/isScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.timer=void 0;var r=e("../Observable"),s=e("../scheduler/async"),o=e("../util/isScheduler"),i=e("../util/isDate");n.timer=function(e,t,n){void 0===e&&(e=0),void 0===n&&(n=s.async);var a=-1;return null!=t&&(o.isScheduler(t)?n=t:a=t),new r.Observable(function(t){var r=i.isValidDate(e)?+e-n.now():e;r<0&&(r=0);var s=0;return n.schedule(function(){t.closed||(t.next(s++),0<=a?this.schedule(undefined,a):t.complete())},r)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/timer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/using.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","./empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.using=void 0;var r=e("../Observable"),s=e("./innerFrom"),o=e("./empty");n.using=function(e,t){return new r.Observable(function(n){var r=e(),i=t(r);return(i?s.innerFrom(i):o.EMPTY).subscribe(n),function(){r&&r.unsubscribe()}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/using.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/zip.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../operators/OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/argsOrArgArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js","./empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","./innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.zip=void 0;var o=e("../Observable"),i=e("./innerFrom"),a=e("../util/argsOrArgArray"),f=e("./empty"),u=e("../operators/OperatorSubscriber"),l=e("../util/args");n.zip=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=l.popResultSelector(e),d=a.argsOrArgArray(e);return d.length?new o.Observable(function(e){var t=d.map(function(){return[]}),o=d.map(function(){return!1});e.add(function(){t=o=null});for(var a=function(a){i.innerFrom(d[a]).subscribe(u.createOperatorSubscriber(e,function(i){if(t[a].push(i),t.every(function(e){return e.length})){var f=t.map(function(e){return e.shift()});e.next(n?n.apply(void 0,s([],r(f))):f),t.some(function(e,t){return!e.length&&o[t]})&&e.complete()}},function(){o[a]=!0,!t[a].length&&e.complete()}))},f=0;!e.closed&&f<d.length;f++)a(f);return function(){t=o=null}}):f.EMPTY}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/observable/zip.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js",{"../Subscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.OperatorSubscriber=n.createOperatorSubscriber=void 0;var o=e("../Subscriber");n.createOperatorSubscriber=function(e,t,n,r,s){return new i(e,t,n,r,s)};var i=function(e){function t(t,n,r,s,o,i){var a=e.call(this,t)||this;return a.onFinalize=o,a.shouldUnsubscribe=i,a._next=n?function(e){try{n(e)}catch(e){t.error(e)}}:e.prototype._next,a._error=s?function(e){try{s(e)}catch(e){t.error(e)}finally{this.unsubscribe()}}:e.prototype._error,a._complete=r?function(){try{r()}catch(e){t.error(e)}finally{this.unsubscribe()}}:e.prototype._complete,a}return s(t,e),t.prototype.unsubscribe=function(){var t;if(!this.shouldUnsubscribe||this.shouldUnsubscribe()){var n=this.closed;e.prototype.unsubscribe.call(this),!n&&(null===(t=this.onFinalize)||void 0===t||t.call(this))}},t}(o.Subscriber);n.OperatorSubscriber=i}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/audit.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.audit=void 0;var r=e("../util/lift"),s=e("../observable/innerFrom"),o=e("./OperatorSubscriber");n.audit=function(e){return r.operate(function(t,n){var r=!1,i=null,a=null,f=!1,u=function(){if(null==a||a.unsubscribe(),a=null,r){r=!1;var e=i;i=null,n.next(e)}f&&n.complete()},l=function(){a=null,f&&n.complete()};t.subscribe(o.createOperatorSubscriber(n,function(t){r=!0,i=t,a||s.innerFrom(e(t)).subscribe(a=o.createOperatorSubscriber(n,u,l))},function(){f=!0,(!r||!a||a.closed)&&n.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/audit.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/auditTime.js",{"../observable/timer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","./audit":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/audit.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.auditTime=void 0;var r=e("../scheduler/async"),s=e("./audit"),o=e("../observable/timer");n.auditTime=function(e,t){return void 0===t&&(t=r.asyncScheduler),s.audit(function(){return o.timer(e,t)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/auditTime.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/buffer.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.buffer=void 0;var r=e("../util/lift"),s=e("../util/noop"),o=e("./OperatorSubscriber"),i=e("../observable/innerFrom");n.buffer=function(e){return r.operate(function(t,n){var r=[];return t.subscribe(o.createOperatorSubscriber(n,function(e){return r.push(e)},function(){n.next(r),n.complete()})),i.innerFrom(e).subscribe(o.createOperatorSubscriber(n,function(){var e=r;r=[],n.next(e)},s.noop)),function(){r=null}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/buffer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferCount.js",{"../util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.bufferCount=void 0;var s=e("../util/lift"),o=e("./OperatorSubscriber"),i=e("../util/arrRemove");n.bufferCount=function(e,t){return void 0===t&&(t=null),t=null!=t?t:e,s.operate(function(n,s){var a=[],f=0;n.subscribe(o.createOperatorSubscriber(s,function(n){var o,u,l,d,c=null;f++%t===0&&a.push([]);try{for(var m=r(a),h=m.next();!h.done;h=m.next()){(k=h.value).push(n),e<=k.length&&(c=null!=c?c:[]).push(k)}}catch(e){o={error:e}}finally{try{h&&!h.done&&(u=m.return)&&u.call(m)}finally{if(o)throw o.error}}if(c)try{for(var b=r(c),p=b.next();!p.done;p=b.next()){var k=p.value;i.arrRemove(a,k),s.next(k)}}catch(e){l={error:e}}finally{try{p&&!p.done&&(d=b.return)&&d.call(b)}finally{if(l)throw l.error}}},function(){var e,t;try{for(var n=r(a),o=n.next();!o.done;o=n.next()){var i=o.value;s.next(i)}}catch(t){e={error:t}}finally{try{o&&!o.done&&(t=n.return)&&t.call(n)}finally{if(e)throw e.error}}s.complete()},undefined,function(){a=null}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/bufferCount.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferTime.js",{"../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.bufferTime=void 0;var s=e("../Subscription"),o=e("../util/lift"),i=e("./OperatorSubscriber"),a=e("../util/arrRemove"),f=e("../scheduler/async"),u=e("../util/args"),l=e("../util/executeSchedule");n.bufferTime=function(e){for(var t,n,d=[],c=1;c<arguments.length;c++)d[c-1]=arguments[c];var m=null!==(t=u.popScheduler(d))&&void 0!==t?t:f.asyncScheduler,h=null!==(n=d[0])&&void 0!==n?n:null,b=d[1]||Infinity;return o.operate(function(t,n){var o=[],f=!1,u=function(e){var t=e.buffer;e.subs.unsubscribe(),a.arrRemove(o,e),n.next(t),f&&d()},d=function(){if(o){var t=new s.Subscription;n.add(t);var r={buffer:[],subs:t};o.push(r),l.executeSchedule(t,m,function(){return u(r)},e)}};null!==h&&h>=0?l.executeSchedule(n,m,d,h,!0):f=!0,d();var c=i.createOperatorSubscriber(n,function(e){var t,n,s=o.slice();try{for(var i=r(s),a=i.next();!a.done;a=i.next()){var f=a.value,l=f.buffer;l.push(e),b<=l.length&&u(f)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}},function(){for(;null==o?void 0:o.length;)n.next(o.shift().buffer);null==c||c.unsubscribe(),n.complete(),n.unsubscribe()},undefined,function(){return o=null});t.subscribe(c)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/bufferTime.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferToggle.js",{"../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.bufferToggle=void 0;var s=e("../Subscription"),o=e("../util/lift"),i=e("../observable/innerFrom"),a=e("./OperatorSubscriber"),f=e("../util/noop"),u=e("../util/arrRemove");n.bufferToggle=function(e,t){return o.operate(function(n,o){var l=[];i.innerFrom(e).subscribe(a.createOperatorSubscriber(o,function(e){var n=[];l.push(n);var r=new s.Subscription;r.add(i.innerFrom(t(e)).subscribe(a.createOperatorSubscriber(o,function(){u.arrRemove(l,n),o.next(n),r.unsubscribe()},f.noop)))},f.noop)),n.subscribe(a.createOperatorSubscriber(o,function(e){var t,n;try{for(var s=r(l),o=s.next();!o.done;o=s.next()){o.value.push(e)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(n=s.return)&&n.call(s)}finally{if(t)throw t.error}}},function(){for(;l.length>0;)o.next(l.shift());o.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/bufferToggle.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/bufferWhen.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.bufferWhen=void 0;var r=e("../util/lift"),s=e("../util/noop"),o=e("./OperatorSubscriber"),i=e("../observable/innerFrom");n.bufferWhen=function(e){return r.operate(function(t,n){var r=null,a=null,f=function(){null==a||a.unsubscribe();var t=r;r=[],t&&n.next(t),i.innerFrom(e()).subscribe(a=o.createOperatorSubscriber(n,f,s.noop))};f(),t.subscribe(o.createOperatorSubscriber(n,function(e){return null==r?void 0:r.push(e)},function(){r&&n.next(r),n.complete()},undefined,function(){return r=a=null}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/bufferWhen.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/catchError.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.catchError=void 0;var r=e("../observable/innerFrom"),s=e("./OperatorSubscriber"),o=e("../util/lift");n.catchError=function e(t){return o.operate(function(n,o){var i,a=null,f=!1;a=n.subscribe(s.createOperatorSubscriber(o,undefined,undefined,function(s){i=r.innerFrom(t(s,e(t)(n))),a?(a.unsubscribe(),a=null,i.subscribe(o)):f=!0})),f&&(a.unsubscribe(),a=null,i.subscribe(o))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/catchError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineAll.js",{"./combineLatestAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineLatestAll.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.combineAll=void 0;var r=e("./combineLatestAll");n.combineAll=r.combineLatestAll}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/combineAll.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineLatest.js",{"../observable/combineLatest":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/combineLatest.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/argsOrArgArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/mapOneOrManyArgs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js","../util/pipe":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/pipe.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.combineLatest=void 0;var o=e("../observable/combineLatest"),i=e("../util/lift"),a=e("../util/argsOrArgArray"),f=e("../util/mapOneOrManyArgs"),u=e("../util/pipe"),l=e("../util/args");n.combineLatest=function e(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];var d=l.popResultSelector(t);return d?u.pipe(e.apply(void 0,s([],r(t))),f.mapOneOrManyArgs(d)):i.operate(function(e,n){o.combineLatestInit(s([e],r(a.argsOrArgArray(t))))(n)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/combineLatest.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineLatestAll.js",{"../observable/combineLatest":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/combineLatest.js","./joinAllInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/joinAllInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.combineLatestAll=void 0;var r=e("../observable/combineLatest"),s=e("./joinAllInternals");n.combineLatestAll=function(e){return s.joinAllInternals(r.combineLatest,e)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/combineLatestAll.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineLatestWith.js",{"./combineLatest":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/combineLatest.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.combineLatestWith=void 0;var o=e("./combineLatest");n.combineLatestWith=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return o.combineLatest.apply(void 0,s([],r(e)))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/combineLatestWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concat.js",{"../observable/from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./concatAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatAll.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.concat=void 0;var o=e("../util/lift"),i=e("./concatAll"),a=e("../util/args"),f=e("../observable/from");n.concat=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=a.popScheduler(e);return o.operate(function(t,o){i.concatAll()(f.from(s([t],r(e)),n)).subscribe(o)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/concat.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatAll.js",{"./mergeAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeAll.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.concatAll=void 0;var r=e("./mergeAll");n.concatAll=function(){return r.mergeAll(1)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/concatAll.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatMap.js",{"../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.concatMap=void 0;var r=e("./mergeMap"),s=e("../util/isFunction");n.concatMap=function(e,t){return s.isFunction(t)?r.mergeMap(e,t,1):r.mergeMap(e,1)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/concatMap.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatMapTo.js",{"../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./concatMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.concatMapTo=void 0;var r=e("./concatMap"),s=e("../util/isFunction");n.concatMapTo=function(e,t){return s.isFunction(t)?r.concatMap(function(){return e},t):r.concatMap(function(){return e})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/concatMapTo.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concatWith.js",{"./concat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/concat.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.concatWith=void 0;var o=e("./concat");n.concatWith=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return o.concat.apply(void 0,s([],r(e)))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/concatWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/connect.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../observable/fromSubscribable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/fromSubscribable.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.connect=void 0;var r=e("../Subject"),s=e("../observable/innerFrom"),o=e("../util/lift"),i=e("../observable/fromSubscribable"),a={connector:function(){return new r.Subject}};n.connect=function(e,t){void 0===t&&(t=a);var n=t.connector;return o.operate(function(t,r){var o=n();s.innerFrom(e(i.fromSubscribable(o))).subscribe(r),r.add(t.subscribe(o))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/connect.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/count.js",{"./reduce":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/reduce.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.count=void 0;var r=e("./reduce");n.count=function(e){return r.reduce(function(t,n,r){return!e||e(n,r)?t+1:t},0)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/count.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/debounce.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.debounce=void 0;var r=e("../util/lift"),s=e("../util/noop"),o=e("./OperatorSubscriber"),i=e("../observable/innerFrom");n.debounce=function(e){return r.operate(function(t,n){var r=!1,a=null,f=null,u=function(){if(null==f||f.unsubscribe(),f=null,r){r=!1;var e=a;a=null,n.next(e)}};t.subscribe(o.createOperatorSubscriber(n,function(t){null==f||f.unsubscribe(),r=!0,a=t,f=o.createOperatorSubscriber(n,u,s.noop),i.innerFrom(e(t)).subscribe(f)},function(){u(),n.complete()},undefined,function(){a=f=null}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/debounce.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/debounceTime.js",{"../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.debounceTime=void 0;var r=e("../scheduler/async"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.debounceTime=function(e,t){return void 0===t&&(t=r.asyncScheduler),s.operate(function(n,r){var s=null,i=null,a=null,f=function(){if(s){s.unsubscribe(),s=null;var e=i;i=null,r.next(e)}};function u(){var n=a+e,o=t.now();if(o<n)return s=this.schedule(undefined,n-o),void r.add(s);f()}n.subscribe(o.createOperatorSubscriber(r,function(n){i=n,a=t.now(),s||(s=t.schedule(u,e),r.add(s))},function(){f(),r.complete()},undefined,function(){i=s=null}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/debounceTime.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.defaultIfEmpty=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.defaultIfEmpty=function(e){return r.operate(function(t,n){var r=!1;t.subscribe(s.createOperatorSubscriber(n,function(e){r=!0,n.next(e)},function(){r||n.next(e),n.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/delay.js",{"../observable/timer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","./delayWhen":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/delayWhen.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.delay=void 0;var r=e("../scheduler/async"),s=e("./delayWhen"),o=e("../observable/timer");n.delay=function(e,t){void 0===t&&(t=r.asyncScheduler);var n=o.timer(e,t);return s.delayWhen(function(){return n})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/delay.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/delayWhen.js",{"../observable/concat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/concat.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","./ignoreElements":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/ignoreElements.js","./mapTo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mapTo.js","./mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js","./take":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/take.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.delayWhen=void 0;var r=e("../observable/concat"),s=e("./take"),o=e("./ignoreElements"),i=e("./mapTo"),a=e("./mergeMap"),f=e("../observable/innerFrom");n.delayWhen=function e(t,n){return n?function(i){return r.concat(n.pipe(s.take(1),o.ignoreElements()),i.pipe(e(t)))}:a.mergeMap(function(e,n){return f.innerFrom(t(e,n)).pipe(s.take(1),i.mapTo(e))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/delayWhen.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/dematerialize.js",{"../Notification":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Notification.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.dematerialize=void 0;var r=e("../Notification"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.dematerialize=function(){return s.operate(function(e,t){e.subscribe(o.createOperatorSubscriber(t,function(e){return r.observeNotification(e,t)}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/dematerialize.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/distinct.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.distinct=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber"),o=e("../util/noop"),i=e("../observable/innerFrom");n.distinct=function(e,t){return r.operate(function(n,r){var a=new Set;n.subscribe(s.createOperatorSubscriber(r,function(t){var n=e?e(t):t;a.has(n)||(a.add(n),r.next(t))})),t&&i.innerFrom(t).subscribe(s.createOperatorSubscriber(r,function(){return a.clear()},o.noop))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/distinct.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/distinctUntilChanged.js",{"../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.distinctUntilChanged=void 0;var r=e("../util/identity"),s=e("../util/lift"),o=e("./OperatorSubscriber");function i(e,t){return e===t}n.distinctUntilChanged=function(e,t){return void 0===t&&(t=r.identity),e=null!=e?e:i,s.operate(function(n,r){var s,i=!0;n.subscribe(o.createOperatorSubscriber(r,function(n){var o=t(n);!i&&e(s,o)||(i=!1,s=o,r.next(n))}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/distinctUntilChanged.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/distinctUntilKeyChanged.js",{"./distinctUntilChanged":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/distinctUntilChanged.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.distinctUntilKeyChanged=void 0;var r=e("./distinctUntilChanged");n.distinctUntilKeyChanged=function(e,t){return r.distinctUntilChanged(function(n,r){return t?t(n[e],r[e]):n[e]===r[e]})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/distinctUntilKeyChanged.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/elementAt.js",{"../util/ArgumentOutOfRangeError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/ArgumentOutOfRangeError.js","./defaultIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js","./filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/filter.js","./take":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/take.js","./throwIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throwIfEmpty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.elementAt=void 0;var r=e("../util/ArgumentOutOfRangeError"),s=e("./filter"),o=e("./throwIfEmpty"),i=e("./defaultIfEmpty"),a=e("./take");n.elementAt=function(e,t){if(e<0)throw new r.ArgumentOutOfRangeError;var n=arguments.length>=2;return function(f){return f.pipe(s.filter(function(t,n){return n===e}),a.take(1),n?i.defaultIfEmpty(t):o.throwIfEmpty(function(){return new r.ArgumentOutOfRangeError}))}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/elementAt.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/endWith.js",{"../observable/concat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/concat.js","../observable/of":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/of.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.endWith=void 0;var o=e("../observable/concat"),i=e("../observable/of");n.endWith=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return function(t){return o.concat(t,i.of.apply(void 0,s([],r(e))))}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/endWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/every.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.every=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.every=function(e,t){return r.operate(function(n,r){var o=0;n.subscribe(s.createOperatorSubscriber(r,function(s){e.call(t,s,o++,n)||(r.next(!1),r.complete())},function(){r.next(!0),r.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/every.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaust.js",{"./exhaustAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaustAll.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.exhaust=void 0;var r=e("./exhaustAll");n.exhaust=r.exhaustAll}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/exhaust.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaustAll.js",{"../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","./exhaustMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaustMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.exhaustAll=void 0;var r=e("./exhaustMap"),s=e("../util/identity");n.exhaustAll=function(){return r.exhaustMap(s.identity)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/exhaustAll.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/exhaustMap.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js","./map":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.exhaustMap=void 0;var r=e("./map"),s=e("../observable/innerFrom"),o=e("../util/lift"),i=e("./OperatorSubscriber");n.exhaustMap=function e(t,n){return n?function(o){return o.pipe(e(function(e,o){return s.innerFrom(t(e,o)).pipe(r.map(function(t,r){return n(e,t,o,r)}))}))}:o.operate(function(e,n){var r=0,o=null,a=!1;e.subscribe(i.createOperatorSubscriber(n,function(e){o||(o=i.createOperatorSubscriber(n,undefined,function(){o=null,a&&n.complete()}),s.innerFrom(t(e,r++)).subscribe(o))},function(){a=!0,!o&&n.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/exhaustMap.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/expand.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./mergeInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.expand=void 0;var r=e("../util/lift"),s=e("./mergeInternals");n.expand=function(e,t,n){return void 0===t&&(t=Infinity),t=(t||0)<1?Infinity:t,r.operate(function(r,o){return s.mergeInternals(r,o,e,t,undefined,!0,n)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/expand.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/filter.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.filter=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.filter=function(e,t){return r.operate(function(n,r){var o=0;n.subscribe(s.createOperatorSubscriber(r,function(n){return e.call(t,n,o++)&&r.next(n)}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/filter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/finalize.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.finalize=void 0;var r=e("../util/lift");n.finalize=function(e){return r.operate(function(t,n){try{t.subscribe(n)}finally{n.add(e)}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/finalize.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/find.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createFind=n.find=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");function o(e,t,n){var r="index"===n;return function(n,o){var i=0;n.subscribe(s.createOperatorSubscriber(o,function(s){var a=i++;e.call(t,s,a,n)&&(o.next(r?a:s),o.complete())},function(){o.next(r?-1:undefined),o.complete()}))}}n.find=function(e,t){return r.operate(o(e,t,"value"))},n.createFind=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/find.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/findIndex.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./find":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/find.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.findIndex=void 0;var r=e("../util/lift"),s=e("./find");n.findIndex=function(e,t){return r.operate(s.createFind(e,t,"index"))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/findIndex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/first.js",{"../util/EmptyError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js","../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","./defaultIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js","./filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/filter.js","./take":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/take.js","./throwIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throwIfEmpty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.first=void 0;var r=e("../util/EmptyError"),s=e("./filter"),o=e("./take"),i=e("./defaultIfEmpty"),a=e("./throwIfEmpty"),f=e("../util/identity");n.first=function(e,t){var n=arguments.length>=2;return function(u){return u.pipe(e?s.filter(function(t,n){return e(t,n,u)}):f.identity,o.take(1),n?i.defaultIfEmpty(t):a.throwIfEmpty(function(){return new r.EmptyError}))}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/first.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/flatMap.js",{"./mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.flatMap=void 0;var r=e("./mergeMap");n.flatMap=r.mergeMap}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/flatMap.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/groupBy.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.groupBy=void 0;var r=e("../Observable"),s=e("../observable/innerFrom"),o=e("../Subject"),i=e("../util/lift"),a=e("./OperatorSubscriber");n.groupBy=function(e,t,n,f){return i.operate(function(i,u){var l;t&&"function"!=typeof t?(n=t.duration,l=t.element,f=t.connector):l=t;var d=new Map,c=function(e){d.forEach(e),e(u)},m=function(e){return c(function(t){return t.error(e)})},h=0,b=!1,p=new a.OperatorSubscriber(u,function(t){try{var i=e(t),c=d.get(i);if(!c){d.set(i,c=f?f():new o.Subject);var k=(j=i,w=c,(g=new r.Observable(function(e){h++;var t=w.subscribe(e);return function(){t.unsubscribe(),0===--h&&b&&p.unsubscribe()}})).key=j,g);if(u.next(k),n){var x=a.createOperatorSubscriber(c,function(){c.complete(),null==x||x.unsubscribe()},undefined,undefined,function(){return d.delete(i)});p.add(s.innerFrom(n(k)).subscribe(x))}}c.next(l?l(t):t)}catch(e){m(e)}var j,w,g},function(){return c(function(e){return e.complete()})},m,function(){return d.clear()},function(){return b=!0,0===h});i.subscribe(p)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/groupBy.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/ignoreElements.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ignoreElements=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber"),o=e("../util/noop");n.ignoreElements=function(){return r.operate(function(e,t){e.subscribe(s.createOperatorSubscriber(t,o.noop))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/ignoreElements.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/isEmpty.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isEmpty=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.isEmpty=function(){return r.operate(function(e,t){e.subscribe(s.createOperatorSubscriber(t,function(){t.next(!1),t.complete()},function(){t.next(!0),t.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/isEmpty.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/joinAllInternals.js",{"../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/mapOneOrManyArgs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js","../util/pipe":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/pipe.js","./mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js","./toArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/toArray.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.joinAllInternals=void 0;var r=e("../util/identity"),s=e("../util/mapOneOrManyArgs"),o=e("../util/pipe"),i=e("./mergeMap"),a=e("./toArray");n.joinAllInternals=function(e,t){return o.pipe(a.toArray(),i.mergeMap(function(t){return e(t)}),t?s.mapOneOrManyArgs(t):r.identity)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/joinAllInternals.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/last.js",{"../util/EmptyError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js","../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","./defaultIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js","./filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/filter.js","./takeLast":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/takeLast.js","./throwIfEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throwIfEmpty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.last=void 0;var r=e("../util/EmptyError"),s=e("./filter"),o=e("./takeLast"),i=e("./throwIfEmpty"),a=e("./defaultIfEmpty"),f=e("../util/identity");n.last=function(e,t){var n=arguments.length>=2;return function(u){return u.pipe(e?s.filter(function(t,n){return e(t,n,u)}):f.identity,o.takeLast(1),n?a.defaultIfEmpty(t):i.throwIfEmpty(function(){return new r.EmptyError}))}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/last.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.map=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.map=function(e,t){return r.operate(function(n,r){var o=0;n.subscribe(s.createOperatorSubscriber(r,function(n){r.next(e.call(t,n,o++))}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/map.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mapTo.js",{"./map":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mapTo=void 0;var r=e("./map");n.mapTo=function(e){return r.map(function(){return e})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/mapTo.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/materialize.js",{"../Notification":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Notification.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.materialize=void 0;var r=e("../Notification"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.materialize=function(){return s.operate(function(e,t){e.subscribe(o.createOperatorSubscriber(t,function(e){t.next(r.Notification.createNext(e))},function(){t.next(r.Notification.createComplete()),t.complete()},function(e){t.next(r.Notification.createError(e)),t.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/materialize.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/max.js",{"../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./reduce":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/reduce.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.max=void 0;var r=e("./reduce"),s=e("../util/isFunction");n.max=function(e){return r.reduce(s.isFunction(e)?function(t,n){return e(t,n)>0?t:n}:function(e,t){return e>t?e:t})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/max.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/merge.js",{"../observable/from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/from.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/argsOrArgArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./mergeAll":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeAll.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.merge=void 0;var o=e("../util/lift"),i=e("../util/argsOrArgArray"),a=e("./mergeAll"),f=e("../util/args"),u=e("../observable/from");n.merge=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=f.popScheduler(e),l=f.popNumber(e,Infinity);return e=i.argsOrArgArray(e),o.operate(function(t,o){a.mergeAll(l)(u.from(s([t],r(e)),n)).subscribe(o)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/merge.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeAll.js",{"../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","./mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeAll=void 0;var r=e("./mergeMap"),s=e("../util/identity");n.mergeAll=function(e){return void 0===e&&(e=Infinity),r.mergeMap(s.identity,e)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/mergeAll.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeInternals.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeInternals=void 0;var r=e("../observable/innerFrom"),s=e("../util/executeSchedule"),o=e("./OperatorSubscriber");n.mergeInternals=function(e,t,n,i,a,f,u,l){var d=[],c=0,m=0,h=!1,b=function(){!h||d.length||c||t.complete()},p=function(e){return c<i?k(e):d.push(e)},k=function(e){f&&t.next(e),c++;var l=!1;r.innerFrom(n(e,m++)).subscribe(o.createOperatorSubscriber(t,function(e){null==a||a(e),f?p(e):t.next(e)},function(){l=!0},undefined,function(){if(l)try{c--;for(var e=function(){var e=d.shift();u?s.executeSchedule(t,u,function(){return k(e)}):k(e)};d.length&&c<i;)e();b()}catch(e){t.error(e)}}))};return e.subscribe(o.createOperatorSubscriber(t,p,function(){h=!0,b()})),function(){null==l||l()}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/mergeInternals.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./map":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js","./mergeInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMap=void 0;var r=e("./map"),s=e("../observable/innerFrom"),o=e("../util/lift"),i=e("./mergeInternals"),a=e("../util/isFunction");n.mergeMap=function e(t,n,f){return void 0===f&&(f=Infinity),a.isFunction(n)?e(function(e,o){return r.map(function(t,r){return n(e,t,o,r)})(s.innerFrom(t(e,o)))},f):("number"==typeof n&&(f=n),o.operate(function(e,n){return i.mergeInternals(e,n,t,f)}))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMapTo.js",{"../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./mergeMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMapTo=void 0;var r=e("./mergeMap"),s=e("../util/isFunction");n.mergeMapTo=function(e,t,n){return void 0===n&&(n=Infinity),s.isFunction(t)?r.mergeMap(function(){return e},t,n):("number"==typeof t&&(n=t),r.mergeMap(function(){return e},n))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/mergeMapTo.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeScan.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./mergeInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeScan=void 0;var r=e("../util/lift"),s=e("./mergeInternals");n.mergeScan=function(e,t,n){return void 0===n&&(n=Infinity),r.operate(function(r,o){var i=t;return s.mergeInternals(r,o,function(t,n){return e(i,t,n)},n,function(e){i=e},!1,undefined,function(){return i=null})})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/mergeScan.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/mergeWith.js",{"./merge":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/merge.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.mergeWith=void 0;var o=e("./merge");n.mergeWith=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return o.merge.apply(void 0,s([],r(e)))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/mergeWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/min.js",{"../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./reduce":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/reduce.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.min=void 0;var r=e("./reduce"),s=e("../util/isFunction");n.min=function(e){return r.reduce(s.isFunction(e)?function(t,n){return e(t,n)<0?t:n}:function(e,t){return e<t?e:t})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/min.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/multicast.js",{"../observable/ConnectableObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/ConnectableObservable.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./connect":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/connect.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.multicast=void 0;var r=e("../observable/ConnectableObservable"),s=e("../util/isFunction"),o=e("./connect");n.multicast=function(e,t){var n=s.isFunction(e)?e:function(){return e};return s.isFunction(t)?o.connect(t,{connector:n}):function(e){return new r.ConnectableObservable(e,n)}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/multicast.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/observeOn.js",{"../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.observeOn=void 0;var r=e("../util/executeSchedule"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.observeOn=function(e,t){return void 0===t&&(t=0),s.operate(function(n,s){n.subscribe(o.createOperatorSubscriber(s,function(n){return r.executeSchedule(s,e,function(){return s.next(n)},t)},function(){return r.executeSchedule(s,e,function(){return s.complete()},t)},function(n){return r.executeSchedule(s,e,function(){return s.error(n)},t)}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/observeOn.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/onErrorResumeNextWith.js",{"../observable/onErrorResumeNext":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/onErrorResumeNext.js","../util/argsOrArgArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.onErrorResumeNext=n.onErrorResumeNextWith=void 0;var o=e("../util/argsOrArgArray"),i=e("../observable/onErrorResumeNext");function a(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=o.argsOrArgArray(e);return function(e){return i.onErrorResumeNext.apply(void 0,s([e],r(n)))}}n.onErrorResumeNextWith=a,n.onErrorResumeNext=a}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/onErrorResumeNextWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/pairwise.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.pairwise=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.pairwise=function(){return r.operate(function(e,t){var n,r=!1;e.subscribe(s.createOperatorSubscriber(t,function(e){var s=n;n=e,r&&t.next([s,e]),r=!0}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/pairwise.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/pluck.js",{"./map":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.pluck=void 0;var r=e("./map");n.pluck=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=e.length;if(0===n)throw new Error("list of properties cannot be empty.");return r.map(function(t){for(var r=t,s=0;s<n;s++){var o=null==r?void 0:r[e[s]];if(void 0===o)return undefined;r=o}return r})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/pluck.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publish.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","./connect":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/connect.js","./multicast":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/multicast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.publish=void 0;var r=e("../Subject"),s=e("./multicast"),o=e("./connect");n.publish=function(e){return e?function(t){return o.connect(e)(t)}:function(e){return s.multicast(new r.Subject)(e)}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/publish.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publishBehavior.js",{"../BehaviorSubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/BehaviorSubject.js","../observable/ConnectableObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/ConnectableObservable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.publishBehavior=void 0;var r=e("../BehaviorSubject"),s=e("../observable/ConnectableObservable");n.publishBehavior=function(e){return function(t){var n=new r.BehaviorSubject(e);return new s.ConnectableObservable(t,function(){return n})}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/publishBehavior.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publishLast.js",{"../AsyncSubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/AsyncSubject.js","../observable/ConnectableObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/ConnectableObservable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.publishLast=void 0;var r=e("../AsyncSubject"),s=e("../observable/ConnectableObservable");n.publishLast=function(){return function(e){var t=new r.AsyncSubject;return new s.ConnectableObservable(e,function(){return t})}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/publishLast.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/publishReplay.js",{"../ReplaySubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/ReplaySubject.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./multicast":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/multicast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.publishReplay=void 0;var r=e("../ReplaySubject"),s=e("./multicast"),o=e("../util/isFunction");n.publishReplay=function(e,t,n,i){n&&!o.isFunction(n)&&(i=n);var a=o.isFunction(n)?n:undefined;return function(n){return s.multicast(new r.ReplaySubject(e,t,i),a)(n)}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/publishReplay.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/raceWith.js",{"../observable/race":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/race.js","../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.raceWith=void 0;var o=e("../observable/race"),i=e("../util/lift"),a=e("../util/identity");n.raceWith=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return e.length?i.operate(function(t,n){o.raceInit(s([t],r(e)))(n)}):a.identity}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/raceWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/reduce.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./scanInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/scanInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.reduce=void 0;var r=e("./scanInternals"),s=e("../util/lift");n.reduce=function(e,t){return s.operate(r.scanInternals(e,t,arguments.length>=2,!1,!0))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/reduce.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/refCount.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.refCount=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.refCount=function(){return r.operate(function(e,t){var n=null;e._refCount++;var r=s.createOperatorSubscriber(t,undefined,undefined,undefined,function(){if(!e||e._refCount<=0||0<--e._refCount)n=null;else{var r=e._connection,s=n;n=null,!r||s&&r!==s||r.unsubscribe(),t.unsubscribe()}});e.subscribe(r),r.closed||(n=e.connect())})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/refCount.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/repeat.js",{"../observable/empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../observable/timer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.repeat=void 0;var r=e("../observable/empty"),s=e("../util/lift"),o=e("./OperatorSubscriber"),i=e("../observable/innerFrom"),a=e("../observable/timer");n.repeat=function(e){var t,n,f=Infinity;return null!=e&&("object"==typeof e?(t=e.count,f=void 0===t?Infinity:t,n=e.delay):f=e),f<=0?function(){return r.EMPTY}:s.operate(function(e,t){var r,s=0,u=function(){if(null==r||r.unsubscribe(),r=null,null!=n){var e="number"==typeof n?a.timer(n):i.innerFrom(n(s)),f=o.createOperatorSubscriber(t,function(){f.unsubscribe(),l()});e.subscribe(f)}else l()},l=function(){var n=!1;r=e.subscribe(o.createOperatorSubscriber(t,undefined,function(){++s<f?r?u():n=!0:t.complete()})),n&&u()};l()})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/repeat.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/repeatWhen.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.repeatWhen=void 0;var r=e("../observable/innerFrom"),s=e("../Subject"),o=e("../util/lift"),i=e("./OperatorSubscriber");n.repeatWhen=function(e){return o.operate(function(t,n){var o,a,f=!1,u=!1,l=!1,d=function(){return l&&u&&(n.complete(),!0)},c=function(){l=!1,o=t.subscribe(i.createOperatorSubscriber(n,undefined,function(){l=!0,!d()&&(a||(a=new s.Subject,r.innerFrom(e(a)).subscribe(i.createOperatorSubscriber(n,function(){o?c():f=!0},function(){u=!0,d()}))),a).next()})),f&&(o.unsubscribe(),o=null,f=!1,c())};c()})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/repeatWhen.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/retry.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../observable/timer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js","../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.retry=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber"),o=e("../util/identity"),i=e("../observable/timer"),a=e("../observable/innerFrom");n.retry=function(e){var t;void 0===e&&(e=Infinity);var n=(t=e&&"object"==typeof e?e:{count:e}).count,f=void 0===n?Infinity:n,u=t.delay,l=t.resetOnSuccess,d=void 0!==l&&l;return f<=0?o.identity:r.operate(function(e,t){var n,r=0,o=function(){var l=!1;n=e.subscribe(s.createOperatorSubscriber(t,function(e){d&&(r=0),t.next(e)},undefined,function(e){if(r++<f){var d=function(){n?(n.unsubscribe(),n=null,o()):l=!0};if(null!=u){var c="number"==typeof u?i.timer(u):a.innerFrom(u(e,r)),m=s.createOperatorSubscriber(t,function(){m.unsubscribe(),d()},function(){t.complete()});c.subscribe(m)}else d()}else t.error(e)})),l&&(n.unsubscribe(),n=null,o())};o()})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/retry.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/retryWhen.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.retryWhen=void 0;var r=e("../observable/innerFrom"),s=e("../Subject"),o=e("../util/lift"),i=e("./OperatorSubscriber");n.retryWhen=function(e){return o.operate(function(t,n){var o,a,f=!1,u=function(){o=t.subscribe(i.createOperatorSubscriber(n,undefined,undefined,function(t){a||(a=new s.Subject,r.innerFrom(e(a)).subscribe(i.createOperatorSubscriber(n,function(){return o?u():f=!0}))),a&&a.next(t)})),f&&(o.unsubscribe(),o=null,f=!1,u())};u()})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/retryWhen.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/sample.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.sample=void 0;var r=e("../observable/innerFrom"),s=e("../util/lift"),o=e("../util/noop"),i=e("./OperatorSubscriber");n.sample=function(e){return s.operate(function(t,n){var s=!1,a=null;t.subscribe(i.createOperatorSubscriber(n,function(e){s=!0,a=e})),r.innerFrom(e).subscribe(i.createOperatorSubscriber(n,function(){if(s){s=!1;var e=a;a=null,n.next(e)}},o.noop))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/sample.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/sampleTime.js",{"../observable/interval":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/interval.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","./sample":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/sample.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.sampleTime=void 0;var r=e("../scheduler/async"),s=e("./sample"),o=e("../observable/interval");n.sampleTime=function(e,t){return void 0===t&&(t=r.asyncScheduler),s.sample(o.interval(e,t))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/sampleTime.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/scan.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./scanInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/scanInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scan=void 0;var r=e("../util/lift"),s=e("./scanInternals");n.scan=function(e,t){return r.operate(s.scanInternals(e,t,arguments.length>=2,!0))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/scan.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/scanInternals.js",{"./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scanInternals=void 0;var r=e("./OperatorSubscriber");n.scanInternals=function(e,t,n,s,o){return function(i,a){var f=n,u=t,l=0;i.subscribe(r.createOperatorSubscriber(a,function(t){var n=l++;u=f?e(u,t,n):(f=!0,t),s&&a.next(u)},o&&function(){f&&a.next(u),a.complete()}))}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/scanInternals.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/sequenceEqual.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.sequenceEqual=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber"),o=e("../observable/innerFrom");n.sequenceEqual=function(e,t){return void 0===t&&(t=function(e,t){return e===t}),r.operate(function(n,r){var i={buffer:[],complete:!1},a={buffer:[],complete:!1},f=function(e){r.next(e),r.complete()},u=function(e,n){var o=s.createOperatorSubscriber(r,function(r){var s=n.buffer,o=n.complete;0===s.length?o?f(!1):e.buffer.push(r):!t(r,s.shift())&&f(!1)},function(){e.complete=!0;var t=n.complete,r=n.buffer;t&&f(0===r.length),null==o||o.unsubscribe()});return o};n.subscribe(u(i,a)),o.innerFrom(e).subscribe(u(a,i))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/sequenceEqual.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/share.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../Subscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscriber.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.share=void 0;var o=e("../observable/innerFrom"),i=e("../Subject"),a=e("../Subscriber"),f=e("../util/lift");function u(e,t){for(var n=[],i=2;i<arguments.length;i++)n[i-2]=arguments[i];if(!0!==t){if(!1!==t){var f=new a.SafeSubscriber({next:function(){f.unsubscribe(),e()}});return o.innerFrom(t.apply(void 0,s([],r(n)))).subscribe(f)}}else e()}n.share=function(e){void 0===e&&(e={});var t=e.connector,n=void 0===t?function(){return new i.Subject}:t,r=e.resetOnError,s=void 0===r||r,l=e.resetOnComplete,d=void 0===l||l,c=e.resetOnRefCountZero,m=void 0===c||c;return function(e){var t,r,i,l=0,c=!1,h=!1,b=function(){null==r||r.unsubscribe(),r=undefined},p=function(){b(),t=i=undefined,c=h=!1},k=function(){var e=t;p(),null==e||e.unsubscribe()};return f.operate(function(e,f){l++,h||c||b();var x=i=null!=i?i:n();f.add(function(){0!==--l||h||c||(r=u(k,m))}),x.subscribe(f),!t&&l>0&&(t=new a.SafeSubscriber({next:function(e){return x.next(e)},error:function(e){h=!0,b(),r=u(p,s,e),x.error(e)},complete:function(){c=!0,b(),r=u(p,d),x.complete()}}),o.innerFrom(e).subscribe(t))})(e)}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/share.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/shareReplay.js",{"../ReplaySubject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/ReplaySubject.js","./share":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/share.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.shareReplay=void 0;var r=e("../ReplaySubject"),s=e("./share");n.shareReplay=function(e,t,n){var o,i,a,f,u=!1;return e&&"object"==typeof e?(o=e.bufferSize,f=void 0===o?Infinity:o,i=e.windowTime,t=void 0===i?Infinity:i,u=void 0!==(a=e.refCount)&&a,n=e.scheduler):f=null!=e?e:Infinity,s.share({connector:function(){return new r.ReplaySubject(f,t,n)},resetOnError:!0,resetOnComplete:!1,resetOnRefCountZero:u})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/shareReplay.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/single.js",{"../util/EmptyError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js","../util/NotFoundError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/NotFoundError.js","../util/SequenceError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/SequenceError.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.single=void 0;var r=e("../util/EmptyError"),s=e("../util/SequenceError"),o=e("../util/NotFoundError"),i=e("../util/lift"),a=e("./OperatorSubscriber");n.single=function(e){return i.operate(function(t,n){var i,f=!1,u=!1,l=0;t.subscribe(a.createOperatorSubscriber(n,function(r){u=!0,e&&!e(r,l++,t)||(f&&n.error(new s.SequenceError("Too many matching values")),f=!0,i=r)},function(){f?(n.next(i),n.complete()):n.error(u?new o.NotFoundError("No matching values"):new r.EmptyError)}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/single.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skip.js",{"./filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/filter.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.skip=void 0;var r=e("./filter");n.skip=function(e){return r.filter(function(t,n){return e<=n})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/skip.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skipLast.js",{"../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.skipLast=void 0;var r=e("../util/identity"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.skipLast=function(e){return e<=0?r.identity:s.operate(function(t,n){var r=new Array(e),s=0;return t.subscribe(o.createOperatorSubscriber(n,function(t){var o=s++;if(o<e)r[o]=t;else{var i=o%e,a=r[i];r[i]=t,n.next(a)}})),function(){r=null}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/skipLast.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skipUntil.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.skipUntil=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber"),o=e("../observable/innerFrom"),i=e("../util/noop");n.skipUntil=function(e){return r.operate(function(t,n){var r=!1,a=s.createOperatorSubscriber(n,function(){null==a||a.unsubscribe(),r=!0},i.noop);o.innerFrom(e).subscribe(a),t.subscribe(s.createOperatorSubscriber(n,function(e){return r&&n.next(e)}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/skipUntil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/skipWhile.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.skipWhile=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.skipWhile=function(e){return r.operate(function(t,n){var r=!1,o=0;t.subscribe(s.createOperatorSubscriber(n,function(t){return(r||(r=!e(t,o++)))&&n.next(t)}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/skipWhile.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/startWith.js",{"../observable/concat":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/concat.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.startWith=void 0;var r=e("../observable/concat"),s=e("../util/args"),o=e("../util/lift");n.startWith=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=s.popScheduler(e);return o.operate(function(t,s){(n?r.concat(e,t,n):r.concat(e,t)).subscribe(s)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/startWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/subscribeOn.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.subscribeOn=void 0;var r=e("../util/lift");n.subscribeOn=function(e,t){return void 0===t&&(t=0),r.operate(function(n,r){r.add(e.schedule(function(){return n.subscribe(r)},t))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/subscribeOn.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchAll.js",{"../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","./switchMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.switchAll=void 0;var r=e("./switchMap"),s=e("../util/identity");n.switchAll=function(){return r.switchMap(s.identity)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/switchAll.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchMap.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.switchMap=void 0;var r=e("../observable/innerFrom"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.switchMap=function(e,t){return s.operate(function(n,s){var i=null,a=0,f=!1,u=function(){return f&&!i&&s.complete()};n.subscribe(o.createOperatorSubscriber(s,function(n){null==i||i.unsubscribe();var f=0,l=a++;r.innerFrom(e(n,l)).subscribe(i=o.createOperatorSubscriber(s,function(e){return s.next(t?t(n,e,l,f++):e)},function(){i=null,u()}))},function(){f=!0,u()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/switchMap.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchMapTo.js",{"../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./switchMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.switchMapTo=void 0;var r=e("./switchMap"),s=e("../util/isFunction");n.switchMapTo=function(e,t){return s.isFunction(t)?r.switchMap(function(){return e},t):r.switchMap(function(){return e})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/switchMapTo.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchScan.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./switchMap":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/switchMap.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.switchScan=void 0;var r=e("./switchMap"),s=e("../util/lift");n.switchScan=function(e,t){return s.operate(function(n,s){var o=t;return r.switchMap(function(t,n){return e(o,t,n)},function(e,t){return o=t,t})(n).subscribe(s),function(){o=null}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/switchScan.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/take.js",{"../observable/empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.take=void 0;var r=e("../observable/empty"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.take=function(e){return e<=0?function(){return r.EMPTY}:s.operate(function(t,n){var r=0;t.subscribe(o.createOperatorSubscriber(n,function(t){++r<=e&&(n.next(t),e<=r&&n.complete())}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/take.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/takeLast.js",{"../observable/empty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/empty.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.takeLast=void 0;var s=e("../observable/empty"),o=e("../util/lift"),i=e("./OperatorSubscriber");n.takeLast=function(e){return e<=0?function(){return s.EMPTY}:o.operate(function(t,n){var s=[];t.subscribe(i.createOperatorSubscriber(n,function(t){s.push(t),e<s.length&&s.shift()},function(){var e,t;try{for(var o=r(s),i=o.next();!i.done;i=o.next()){var a=i.value;n.next(a)}}catch(t){e={error:t}}finally{try{i&&!i.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}n.complete()},undefined,function(){s=null}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/takeLast.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/takeUntil.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.takeUntil=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber"),o=e("../observable/innerFrom"),i=e("../util/noop");n.takeUntil=function(e){return r.operate(function(t,n){o.innerFrom(e).subscribe(s.createOperatorSubscriber(n,function(){return n.complete()},i.noop)),!n.closed&&t.subscribe(n)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/takeUntil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/takeWhile.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.takeWhile=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber");n.takeWhile=function(e,t){return void 0===t&&(t=!1),r.operate(function(n,r){var o=0;n.subscribe(s.createOperatorSubscriber(r,function(n){var s=e(n,o++);(s||t)&&r.next(n),!s&&r.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/takeWhile.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/tap.js",{"../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.tap=void 0;var r=e("../util/isFunction"),s=e("../util/lift"),o=e("./OperatorSubscriber"),i=e("../util/identity");n.tap=function(e,t,n){var a=r.isFunction(e)||t||n?{next:e,error:t,complete:n}:e;return a?s.operate(function(e,t){var n;null===(n=a.subscribe)||void 0===n||n.call(a);var r=!0;e.subscribe(o.createOperatorSubscriber(t,function(e){var n;null===(n=a.next)||void 0===n||n.call(a,e),t.next(e)},function(){var e;r=!1,null===(e=a.complete)||void 0===e||e.call(a),t.complete()},function(e){var n;r=!1,null===(n=a.error)||void 0===n||n.call(a,e),t.error(e)},function(){var e,t;r&&(null===(e=a.unsubscribe)||void 0===e||e.call(a)),null===(t=a.finalize)||void 0===t||t.call(a)}))}):i.identity}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/tap.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throttle.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.throttle=void 0;var r=e("../util/lift"),s=e("./OperatorSubscriber"),o=e("../observable/innerFrom");n.throttle=function(e,t){return r.operate(function(n,r){var i=null!=t?t:{},a=i.leading,f=void 0===a||a,u=i.trailing,l=void 0!==u&&u,d=!1,c=null,m=null,h=!1,b=function(){null==m||m.unsubscribe(),m=null,l&&(x(),h&&r.complete())},p=function(){m=null,h&&r.complete()},k=function(t){return m=o.innerFrom(e(t)).subscribe(s.createOperatorSubscriber(r,b,p))},x=function(){if(d){d=!1;var e=c;c=null,r.next(e),!h&&k(e)}};n.subscribe(s.createOperatorSubscriber(r,function(e){d=!0,c=e,(!m||m.closed)&&(f?x():k(e))},function(){h=!0,(!(l&&d&&m)||m.closed)&&r.complete()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/throttle.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throttleTime.js",{"../observable/timer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/timer.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","./throttle":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throttle.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.throttleTime=void 0;var r=e("../scheduler/async"),s=e("./throttle"),o=e("../observable/timer");n.throttleTime=function(e,t,n){void 0===t&&(t=r.asyncScheduler);var i=o.timer(e,t);return s.throttle(function(){return i},n)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/throttleTime.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/throwIfEmpty.js",{"../util/EmptyError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.throwIfEmpty=void 0;var r=e("../util/EmptyError"),s=e("../util/lift"),o=e("./OperatorSubscriber");function i(){return new r.EmptyError}n.throwIfEmpty=function(e){return void 0===e&&(e=i),s.operate(function(t,n){var r=!1;t.subscribe(o.createOperatorSubscriber(n,function(e){r=!0,n.next(e)},function(){return r?n.complete():n.error(e())}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/throwIfEmpty.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timeInterval.js",{"../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TimeInterval=n.timeInterval=void 0;var r=e("../scheduler/async"),s=e("../util/lift"),o=e("./OperatorSubscriber");n.timeInterval=function(e){return void 0===e&&(e=r.asyncScheduler),s.operate(function(t,n){var r=e.now();t.subscribe(o.createOperatorSubscriber(n,function(t){var s=e.now(),o=s-r;r=s,n.next(new i(t,o))}))})};var i=function(e,t){this.value=e,this.interval=t};n.TimeInterval=i}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/timeInterval.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timeout.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","../util/createErrorClass":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js","../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js","../util/isDate":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isDate.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.timeout=n.TimeoutError=void 0;var r=e("../scheduler/async"),s=e("../util/isDate"),o=e("../util/lift"),i=e("../observable/innerFrom"),a=e("../util/createErrorClass"),f=e("./OperatorSubscriber"),u=e("../util/executeSchedule");function l(e){throw new n.TimeoutError(e)}n.TimeoutError=a.createErrorClass(function(e){return function(t){void 0===t&&(t=null),e(this),this.message="Timeout has occurred",this.name="TimeoutError",this.info=t}}),n.timeout=function(e,t){var n=s.isValidDate(e)?{first:e}:"number"==typeof e?{each:e}:e,a=n.first,d=n.each,c=n.with,m=void 0===c?l:c,h=n.scheduler,b=void 0===h?null!=t?t:r.asyncScheduler:h,p=n.meta,k=void 0===p?null:p;if(null==a&&null==d)throw new TypeError("No timeout provided.");return o.operate(function(e,t){var n,r,s=null,o=0,l=function(e){r=u.executeSchedule(t,b,function(){try{n.unsubscribe(),i.innerFrom(m({meta:k,lastValue:s,seen:o})).subscribe(t)}catch(e){t.error(e)}},e)};n=e.subscribe(f.createOperatorSubscriber(t,function(e){null==r||r.unsubscribe(),o++,t.next(s=e),d>0&&l(d)},undefined,undefined,function(){(null==r?void 0:r.closed)||null==r||r.unsubscribe(),s=null})),!o&&l(null!=a?"number"==typeof a?a:+a-b.now():d)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/timeout.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timeoutWith.js",{"../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","../util/isDate":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isDate.js","./timeout":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timeout.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.timeoutWith=void 0;var r=e("../scheduler/async"),s=e("../util/isDate"),o=e("./timeout");n.timeoutWith=function(e,t,n){var i,a,f;if(n=null!=n?n:r.async,s.isValidDate(e)?i=e:"number"==typeof e&&(a=e),!t)throw new TypeError("No observable provided to switch to");if(f=function(){return t},null==i&&null==a)throw new TypeError("No timeout provided.");return o.timeout({first:i,each:a,scheduler:n,with:f})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/timeoutWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/timestamp.js",{"../scheduler/dateTimestampProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/dateTimestampProvider.js","./map":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.timestamp=void 0;var r=e("../scheduler/dateTimestampProvider"),s=e("./map");n.timestamp=function(e){return void 0===e&&(e=r.dateTimestampProvider),s.map(function(t){return{value:t,timestamp:e.now()}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/timestamp.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/toArray.js",{"../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./reduce":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/reduce.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toArray=void 0;var r=e("./reduce"),s=e("../util/lift"),o=function(e,t){return e.push(t),e};n.toArray=function(){return s.operate(function(e,t){r.reduce(o,[])(e).subscribe(t)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/toArray.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/window.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.window=void 0;var r=e("../Subject"),s=e("../util/lift"),o=e("./OperatorSubscriber"),i=e("../util/noop"),a=e("../observable/innerFrom");n.window=function(e){return s.operate(function(t,n){var s=new r.Subject;n.next(s.asObservable());var f=function(e){s.error(e),n.error(e)};return t.subscribe(o.createOperatorSubscriber(n,function(e){return null==s?void 0:s.next(e)},function(){s.complete(),n.complete()},f)),a.innerFrom(e).subscribe(o.createOperatorSubscriber(n,function(){s.complete(),n.next(s=new r.Subject)},i.noop,f)),function(){null==s||s.unsubscribe(),s=null}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/window.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowCount.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.windowCount=void 0;var s=e("../Subject"),o=e("../util/lift"),i=e("./OperatorSubscriber");n.windowCount=function(e,t){void 0===t&&(t=0);var n=t>0?t:e;return o.operate(function(t,o){var a=[new s.Subject],f=0;o.next(a[0].asObservable()),t.subscribe(i.createOperatorSubscriber(o,function(t){var i,u;try{for(var l=r(a),d=l.next();!d.done;d=l.next()){d.value.next(t)}}catch(e){i={error:e}}finally{try{d&&!d.done&&(u=l.return)&&u.call(l)}finally{if(i)throw i.error}}var c=f-e+1;if(c>=0&&c%n===0&&a.shift().complete(),++f%n===0){var m=new s.Subject;a.push(m),o.next(m.asObservable())}},function(){for(;a.length>0;)a.shift().complete();o.complete()},function(e){for(;a.length>0;)a.shift().error(e);o.error(e)},function(){a=null}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/windowCount.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowTime.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","../scheduler/async":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.windowTime=void 0;var r=e("../Subject"),s=e("../scheduler/async"),o=e("../Subscription"),i=e("../util/lift"),a=e("./OperatorSubscriber"),f=e("../util/arrRemove"),u=e("../util/args"),l=e("../util/executeSchedule");n.windowTime=function(e){for(var t,n,d=[],c=1;c<arguments.length;c++)d[c-1]=arguments[c];var m=null!==(t=u.popScheduler(d))&&void 0!==t?t:s.asyncScheduler,h=null!==(n=d[0])&&void 0!==n?n:null,b=d[1]||Infinity;return i.operate(function(t,n){var s=[],i=!1,u=function(e){var t=e.window,n=e.subs;t.complete(),n.unsubscribe(),f.arrRemove(s,e),i&&d()},d=function(){if(s){var t=new o.Subscription;n.add(t);var i=new r.Subject,a={window:i,subs:t,seen:0};s.push(a),n.next(i.asObservable()),l.executeSchedule(t,m,function(){return u(a)},e)}};null!==h&&h>=0?l.executeSchedule(n,m,d,h,!0):i=!0,d();var c=function(e){return s.slice().forEach(e)},p=function(e){c(function(t){var n=t.window;return e(n)}),e(n),n.unsubscribe()};return t.subscribe(a.createOperatorSubscriber(n,function(e){c(function(t){t.window.next(e),b<=++t.seen&&u(t)})},function(){return p(function(e){return e.complete()})},function(e){return p(function(t){return t.error(e)})})),function(){s=null}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/windowTime.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowToggle.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__values||function(e){var t="function"==typeof Symbol&&Symbol.iterator,n=t&&e[t],r=0;if(n)return n.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&r>=e.length&&(e=void 0),{value:e&&e[r++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")};Object.defineProperty(n,"__esModule",{value:!0}),n.windowToggle=void 0;var s=e("../Subject"),o=e("../Subscription"),i=e("../util/lift"),a=e("../observable/innerFrom"),f=e("./OperatorSubscriber"),u=e("../util/noop"),l=e("../util/arrRemove");n.windowToggle=function(e,t){return i.operate(function(n,i){var d=[],c=function(e){for(;0<d.length;)d.shift().error(e);i.error(e)};a.innerFrom(e).subscribe(f.createOperatorSubscriber(i,function(e){var n=new s.Subject;d.push(n);var r,m=new o.Subscription;try{r=a.innerFrom(t(e))}catch(e){return void c(e)}i.next(n.asObservable()),m.add(r.subscribe(f.createOperatorSubscriber(i,function(){l.arrRemove(d,n),n.complete(),m.unsubscribe()},u.noop,c)))},u.noop)),n.subscribe(f.createOperatorSubscriber(i,function(e){var t,n,s=d.slice();try{for(var o=r(s),i=o.next();!i.done;i=o.next()){i.value.next(e)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(n=o.return)&&n.call(o)}finally{if(t)throw t.error}}},function(){for(;0<d.length;)d.shift().complete();i.complete()},c,function(){for(;0<d.length;)d.shift().unsubscribe()}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/windowToggle.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/windowWhen.js",{"../Subject":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subject.js","../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.windowWhen=void 0;var r=e("../Subject"),s=e("../util/lift"),o=e("./OperatorSubscriber"),i=e("../observable/innerFrom");n.windowWhen=function(e){return s.operate(function(t,n){var s,a,f=function(e){s.error(e),n.error(e)},u=function(){var t;null==a||a.unsubscribe(),null==s||s.complete(),s=new r.Subject,n.next(s.asObservable());try{t=i.innerFrom(e())}catch(e){return void f(e)}t.subscribe(a=o.createOperatorSubscriber(n,u,u,f))};u(),t.subscribe(o.createOperatorSubscriber(n,function(e){return s.next(e)},function(){s.complete(),n.complete()},f,function(){null==a||a.unsubscribe(),s=null}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/windowWhen.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/withLatestFrom.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../util/args":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js","../util/identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js","../util/noop":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js","./OperatorSubscriber":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/OperatorSubscriber.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.withLatestFrom=void 0;var o=e("../util/lift"),i=e("./OperatorSubscriber"),a=e("../observable/innerFrom"),f=e("../util/identity"),u=e("../util/noop"),l=e("../util/args");n.withLatestFrom=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=l.popResultSelector(e);return o.operate(function(t,o){for(var l=e.length,d=new Array(l),c=e.map(function(){return!1}),m=!1,h=function(t){a.innerFrom(e[t]).subscribe(i.createOperatorSubscriber(o,function(e){d[t]=e,m||c[t]||(c[t]=!0,(m=c.every(f.identity))&&(c=null))},u.noop))},b=0;b<l;b++)h(b);t.subscribe(i.createOperatorSubscriber(o,function(e){if(m){var t=s([e],r(d));o.next(n?n.apply(void 0,s([],r(t))):t)}}))})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/withLatestFrom.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/zip.js",{"../observable/zip":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/zip.js","../util/lift":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.zip=void 0;var o=e("../observable/zip"),i=e("../util/lift");n.zip=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return i.operate(function(t,n){o.zip.apply(void 0,s([t],r(e))).subscribe(n)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/zip.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/zipAll.js",{"../observable/zip":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/zip.js","./joinAllInternals":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/joinAllInternals.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.zipAll=void 0;var r=e("../observable/zip"),s=e("./joinAllInternals");n.zipAll=function(e){return s.joinAllInternals(r.zip,e)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/zipAll.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/zipWith.js",{"./zip":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/zip.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.zipWith=void 0;var o=e("./zip");n.zipWith=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return o.zip.apply(void 0,s([],r(e)))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/operators/zipWith.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleArray.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scheduleArray=void 0;var r=e("../Observable");n.scheduleArray=function(e,t){return new r.Observable(function(n){var r=0;return t.schedule(function(){r===e.length?n.complete():(n.next(e[r++]),n.closed||this.schedule())})})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduled/scheduleArray.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleAsyncIterable.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scheduleAsyncIterable=void 0;var r=e("../Observable"),s=e("../util/executeSchedule");n.scheduleAsyncIterable=function(e,t){if(!e)throw new Error("Iterable cannot be null");return new r.Observable(function(n){s.executeSchedule(n,t,function(){var r=e[Symbol.asyncIterator]();s.executeSchedule(n,t,function(){r.next().then(function(e){e.done?n.complete():n.next(e.value)})},0,!0)})})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduled/scheduleAsyncIterable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleIterable.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","../symbol/iterator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/iterator.js","../util/executeSchedule":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js","../util/isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scheduleIterable=void 0;var r=e("../Observable"),s=e("../symbol/iterator"),o=e("../util/isFunction"),i=e("../util/executeSchedule");n.scheduleIterable=function(e,t){return new r.Observable(function(n){var r;return i.executeSchedule(n,t,function(){r=e[s.iterator](),i.executeSchedule(n,t,function(){var e,t,s;try{t=(e=r.next()).value,s=e.done}catch(e){return void n.error(e)}s?n.complete():n.next(t)},0,!0)}),function(){return o.isFunction(null==r?void 0:r.return)&&r.return()}})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduled/scheduleIterable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleObservable.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../operators/observeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/observeOn.js","../operators/subscribeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/subscribeOn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scheduleObservable=void 0;var r=e("../observable/innerFrom"),s=e("../operators/observeOn"),o=e("../operators/subscribeOn");n.scheduleObservable=function(e,t){return r.innerFrom(e).pipe(o.subscribeOn(t),s.observeOn(t))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduled/scheduleObservable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/schedulePromise.js",{"../observable/innerFrom":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/observable/innerFrom.js","../operators/observeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/observeOn.js","../operators/subscribeOn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/subscribeOn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.schedulePromise=void 0;var r=e("../observable/innerFrom"),s=e("../operators/observeOn"),o=e("../operators/subscribeOn");n.schedulePromise=function(e,t){return r.innerFrom(e).pipe(o.subscribeOn(t),s.observeOn(t))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduled/schedulePromise.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleReadableStreamLike.js",{"../util/isReadableStreamLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isReadableStreamLike.js","./scheduleAsyncIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleAsyncIterable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scheduleReadableStreamLike=void 0;var r=e("./scheduleAsyncIterable"),s=e("../util/isReadableStreamLike");n.scheduleReadableStreamLike=function(e,t){return r.scheduleAsyncIterable(s.readableStreamLikeToAsyncGenerator(e),t)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduled/scheduleReadableStreamLike.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduled.js",{"../util/isArrayLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isArrayLike.js","../util/isAsyncIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isAsyncIterable.js","../util/isInteropObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isInteropObservable.js","../util/isIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isIterable.js","../util/isPromise":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isPromise.js","../util/isReadableStreamLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isReadableStreamLike.js","../util/throwUnobservableError":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/throwUnobservableError.js","./scheduleArray":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleArray.js","./scheduleAsyncIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleAsyncIterable.js","./scheduleIterable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleIterable.js","./scheduleObservable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleObservable.js","./schedulePromise":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/schedulePromise.js","./scheduleReadableStreamLike":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleReadableStreamLike.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.scheduled=void 0;var r=e("./scheduleObservable"),s=e("./schedulePromise"),o=e("./scheduleArray"),i=e("./scheduleIterable"),a=e("./scheduleAsyncIterable"),f=e("../util/isInteropObservable"),u=e("../util/isPromise"),l=e("../util/isArrayLike"),d=e("../util/isIterable"),c=e("../util/isAsyncIterable"),m=e("../util/throwUnobservableError"),h=e("../util/isReadableStreamLike"),b=e("./scheduleReadableStreamLike");n.scheduled=function(e,t){if(null!=e){if(f.isInteropObservable(e))return r.scheduleObservable(e,t);if(l.isArrayLike(e))return o.scheduleArray(e,t);if(u.isPromise(e))return s.schedulePromise(e,t);if(c.isAsyncIterable(e))return a.scheduleAsyncIterable(e,t);if(d.isIterable(e))return i.scheduleIterable(e,t);if(h.isReadableStreamLike(e))return b.scheduleReadableStreamLike(e,t)}throw m.createInvalidObservableTypeError(e)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduled/scheduled.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/Action.js",{"../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.Action=void 0;var o=function(e){function t(t,n){return e.call(this)||this}return s(t,e),t.prototype.schedule=function(e,t){return void 0===t&&(t=0),this},t}(e("../Subscription").Subscription);n.Action=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/Action.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AnimationFrameAction.js",{"./AsyncAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncAction.js","./animationFrameProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/animationFrameProvider.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.AnimationFrameAction=void 0;var o=e("./AsyncAction"),i=e("./animationFrameProvider"),a=function(e){function t(t,n){var r=e.call(this,t,n)||this;return r.scheduler=t,r.work=n,r}return s(t,e),t.prototype.requestAsyncId=function(t,n,r){return void 0===r&&(r=0),null!==r&&r>0?e.prototype.requestAsyncId.call(this,t,n,r):(t.actions.push(this),t._scheduled||(t._scheduled=i.animationFrameProvider.requestAnimationFrame(function(){return t.flush(undefined)})))},t.prototype.recycleAsyncId=function(t,n,r){var s;if(void 0===r&&(r=0),null!=r?r>0:this.delay>0)return e.prototype.recycleAsyncId.call(this,t,n,r);var o=t.actions;return null!=n&&(null===(s=o[o.length-1])||void 0===s?void 0:s.id)!==n&&(i.animationFrameProvider.cancelAnimationFrame(n),t._scheduled=undefined),undefined},t}(o.AsyncAction);n.AnimationFrameAction=a}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/AnimationFrameAction.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AnimationFrameScheduler.js",{"./AsyncScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.AnimationFrameScheduler=void 0;var o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s(t,e),t.prototype.flush=function(e){this._active=!0;var t=this._scheduled;this._scheduled=undefined;var n,r=this.actions;e=e||r.shift();do{if(n=e.execute(e.state,e.delay))break}while((e=r[0])&&e.id===t&&r.shift());if(this._active=!1,n){for(;(e=r[0])&&e.id===t&&r.shift();)e.unsubscribe();throw n}},t}(e("./AsyncScheduler").AsyncScheduler);n.AnimationFrameScheduler=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/AnimationFrameScheduler.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsapAction.js",{"./AsyncAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncAction.js","./immediateProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/immediateProvider.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.AsapAction=void 0;var o=e("./AsyncAction"),i=e("./immediateProvider"),a=function(e){function t(t,n){var r=e.call(this,t,n)||this;return r.scheduler=t,r.work=n,r}return s(t,e),t.prototype.requestAsyncId=function(t,n,r){return void 0===r&&(r=0),null!==r&&r>0?e.prototype.requestAsyncId.call(this,t,n,r):(t.actions.push(this),t._scheduled||(t._scheduled=i.immediateProvider.setImmediate(t.flush.bind(t,undefined))))},t.prototype.recycleAsyncId=function(t,n,r){var s;if(void 0===r&&(r=0),null!=r?r>0:this.delay>0)return e.prototype.recycleAsyncId.call(this,t,n,r);var o=t.actions;return null!=n&&(null===(s=o[o.length-1])||void 0===s?void 0:s.id)!==n&&(i.immediateProvider.clearImmediate(n),t._scheduled===n&&(t._scheduled=undefined)),undefined},t}(o.AsyncAction);n.AsapAction=a}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/AsapAction.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsapScheduler.js",{"./AsyncScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.AsapScheduler=void 0;var o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s(t,e),t.prototype.flush=function(e){this._active=!0;var t=this._scheduled;this._scheduled=undefined;var n,r=this.actions;e=e||r.shift();do{if(n=e.execute(e.state,e.delay))break}while((e=r[0])&&e.id===t&&r.shift());if(this._active=!1,n){for(;(e=r[0])&&e.id===t&&r.shift();)e.unsubscribe();throw n}},t}(e("./AsyncScheduler").AsyncScheduler);n.AsapScheduler=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/AsapScheduler.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncAction.js",{"../util/arrRemove":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js","./Action":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/Action.js","./intervalProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/intervalProvider.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncAction=void 0;var o=e("./Action"),i=e("./intervalProvider"),a=e("../util/arrRemove"),f=function(e){function t(t,n){var r=e.call(this,t,n)||this;return r.scheduler=t,r.work=n,r.pending=!1,r}return s(t,e),t.prototype.schedule=function(e,t){var n;if(void 0===t&&(t=0),this.closed)return this;this.state=e;var r=this.id,s=this.scheduler;return null!=r&&(this.id=this.recycleAsyncId(s,r,t)),this.pending=!0,this.delay=t,this.id=null!==(n=this.id)&&void 0!==n?n:this.requestAsyncId(s,this.id,t),this},t.prototype.requestAsyncId=function(e,t,n){return void 0===n&&(n=0),i.intervalProvider.setInterval(e.flush.bind(e,this),n)},t.prototype.recycleAsyncId=function(e,t,n){return void 0===n&&(n=0),null!=n&&this.delay===n&&!1===this.pending?t:(null!=t&&i.intervalProvider.clearInterval(t),undefined)},t.prototype.execute=function(e,t){if(this.closed)return new Error("executing a cancelled action");this.pending=!1;var n=this._execute(e,t);if(n)return n;!1===this.pending&&null!=this.id&&(this.id=this.recycleAsyncId(this.scheduler,this.id,null))},t.prototype._execute=function(e,t){var n,r=!1;try{this.work(e)}catch(e){r=!0,n=e||new Error("Scheduled action threw falsy error")}if(r)return this.unsubscribe(),n},t.prototype.unsubscribe=function(){if(!this.closed){var t=this.id,n=this.scheduler,r=n.actions;this.work=this.state=this.scheduler=null,this.pending=!1,a.arrRemove(r,this),null!=t&&(this.id=this.recycleAsyncId(n,t,null)),this.delay=null,e.prototype.unsubscribe.call(this)}},t}(o.Action);n.AsyncAction=f}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/AsyncAction.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js",{"../Scheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Scheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncScheduler=void 0;var o=e("../Scheduler"),i=function(e){function t(t,n){void 0===n&&(n=o.Scheduler.now);var r=e.call(this,t,n)||this;return r.actions=[],r._active=!1,r}return s(t,e),t.prototype.flush=function(e){var t=this.actions;if(this._active)t.push(e);else{var n;this._active=!0;do{if(n=e.execute(e.state,e.delay))break}while(e=t.shift());if(this._active=!1,n){for(;e=t.shift();)e.unsubscribe();throw n}}},t}(o.Scheduler);n.AsyncScheduler=i}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/QueueAction.js",{"./AsyncAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncAction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.QueueAction=void 0;var o=function(e){function t(t,n){var r=e.call(this,t,n)||this;return r.scheduler=t,r.work=n,r}return s(t,e),t.prototype.schedule=function(t,n){return void 0===n&&(n=0),n>0?e.prototype.schedule.call(this,t,n):(this.delay=n,this.state=t,this.scheduler.flush(this),this)},t.prototype.execute=function(t,n){return n>0||this.closed?e.prototype.execute.call(this,t,n):this._execute(t,n)},t.prototype.requestAsyncId=function(t,n,r){return void 0===r&&(r=0),null!=r&&r>0||null==r&&this.delay>0?e.prototype.requestAsyncId.call(this,t,n,r):(t.flush(this),0)},t}(e("./AsyncAction").AsyncAction);n.QueueAction=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/QueueAction.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/QueueScheduler.js",{"./AsyncScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.QueueScheduler=void 0;var o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s(t,e),t}(e("./AsyncScheduler").AsyncScheduler);n.QueueScheduler=o}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/QueueScheduler.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/VirtualTimeScheduler.js",{"../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js","./AsyncAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncAction.js","./AsyncScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__extends||(r=function(e,t){return r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},r(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});Object.defineProperty(n,"__esModule",{value:!0}),n.VirtualAction=n.VirtualTimeScheduler=void 0;var o=e("./AsyncAction"),i=e("../Subscription"),a=function(e){function t(t,n){void 0===t&&(t=f),void 0===n&&(n=Infinity);var r=e.call(this,t,function(){return r.frame})||this;return r.maxFrames=n,r.frame=0,r.index=-1,r}return s(t,e),t.prototype.flush=function(){for(var e,t,n=this.actions,r=this.maxFrames;(t=n[0])&&t.delay<=r&&(n.shift(),this.frame=t.delay,!(e=t.execute(t.state,t.delay))););if(e){for(;t=n.shift();)t.unsubscribe();throw e}},t.frameTimeFactor=10,t}(e("./AsyncScheduler").AsyncScheduler);n.VirtualTimeScheduler=a;var f=function(e){function t(t,n,r){void 0===r&&(r=t.index+=1);var s=e.call(this,t,n)||this;return s.scheduler=t,s.work=n,s.index=r,s.active=!0,s.index=t.index=r,s}return s(t,e),t.prototype.schedule=function(n,r){if(void 0===r&&(r=0),Number.isFinite(r)){if(!this.id)return e.prototype.schedule.call(this,n,r);this.active=!1;var s=new t(this.scheduler,this.work);return this.add(s),s.schedule(n,r)}return i.Subscription.EMPTY},t.prototype.requestAsyncId=function(e,n,r){void 0===r&&(r=0),this.delay=e.frame+r;var s=e.actions;return s.push(this),s.sort(t.sortActions),1},t.prototype.recycleAsyncId=function(e,t,n){return void 0===n&&(n=0),undefined},t.prototype._execute=function(t,n){if(!0===this.active)return e.prototype._execute.call(this,t,n)},t.sortActions=function(e,t){return e.delay===t.delay?e.index===t.index?0:e.index>t.index?1:-1:e.delay>t.delay?1:-1},t}(o.AsyncAction);n.VirtualAction=f}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/VirtualTimeScheduler.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/animationFrame.js",{"./AnimationFrameAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AnimationFrameAction.js","./AnimationFrameScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AnimationFrameScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.animationFrame=n.animationFrameScheduler=void 0;var r=e("./AnimationFrameAction"),s=e("./AnimationFrameScheduler");n.animationFrameScheduler=new s.AnimationFrameScheduler(r.AnimationFrameAction),n.animationFrame=n.animationFrameScheduler}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/animationFrame.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/animationFrameProvider.js",{"../Subscription":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Subscription.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.animationFrameProvider=void 0;var o=e("../Subscription");n.animationFrameProvider={schedule:function(e){var t=requestAnimationFrame,r=cancelAnimationFrame,s=n.animationFrameProvider.delegate;s&&(t=s.requestAnimationFrame,r=s.cancelAnimationFrame);var i=t(function(t){r=undefined,e(t)});return new o.Subscription(function(){return null==r?void 0:r(i)})},requestAnimationFrame:function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var o=n.animationFrameProvider.delegate;return((null==o?void 0:o.requestAnimationFrame)||requestAnimationFrame).apply(void 0,s([],r(e)))},cancelAnimationFrame:function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var o=n.animationFrameProvider.delegate;return((null==o?void 0:o.cancelAnimationFrame)||cancelAnimationFrame).apply(void 0,s([],r(e)))},delegate:undefined}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/animationFrameProvider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/asap.js",{"./AsapAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsapAction.js","./AsapScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsapScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.asap=n.asapScheduler=void 0;var r=e("./AsapAction"),s=e("./AsapScheduler");n.asapScheduler=new s.AsapScheduler(r.AsapAction),n.asap=n.asapScheduler}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/asap.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/async.js",{"./AsyncAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncAction.js","./AsyncScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.async=n.asyncScheduler=void 0;var r=e("./AsyncAction"),s=e("./AsyncScheduler");n.asyncScheduler=new s.AsyncScheduler(r.AsyncAction),n.async=n.asyncScheduler}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/async.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/dateTimestampProvider.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.dateTimestampProvider=void 0,n.dateTimestampProvider={now:function(){return(n.dateTimestampProvider.delegate||Date).now()},delegate:undefined}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/dateTimestampProvider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/immediateProvider.js",{"../util/Immediate":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/Immediate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.immediateProvider=void 0;var o=e("../util/Immediate"),i=o.Immediate.setImmediate,a=o.Immediate.clearImmediate;n.immediateProvider={setImmediate:function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var o=n.immediateProvider.delegate;return((null==o?void 0:o.setImmediate)||i).apply(void 0,s([],r(e)))},clearImmediate:function(e){var t=n.immediateProvider.delegate;return((null==t?void 0:t.clearImmediate)||a)(e)},delegate:undefined}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/immediateProvider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/intervalProvider.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.intervalProvider=void 0,n.intervalProvider={setInterval:function(e,t){for(var o=[],i=2;i<arguments.length;i++)o[i-2]=arguments[i];var a=n.intervalProvider.delegate;return(null==a?void 0:a.setInterval)?a.setInterval.apply(a,s([e,t],r(o))):setInterval.apply(void 0,s([e,t],r(o)))},clearInterval:function(e){var t=n.intervalProvider.delegate;return((null==t?void 0:t.clearInterval)||clearInterval)(e)},delegate:undefined}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/intervalProvider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/performanceTimestampProvider.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.performanceTimestampProvider=void 0,n.performanceTimestampProvider={now:function(){return(n.performanceTimestampProvider.delegate||performance).now()},delegate:undefined}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/performanceTimestampProvider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/queue.js",{"./QueueAction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/QueueAction.js","./QueueScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/QueueScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.queue=n.queueScheduler=void 0;var r=e("./QueueAction"),s=e("./QueueScheduler");n.queueScheduler=new s.QueueScheduler(r.QueueAction),n.queue=n.queueScheduler}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/queue.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/timeoutProvider.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.timeoutProvider=void 0,n.timeoutProvider={setTimeout:function(e,t){for(var o=[],i=2;i<arguments.length;i++)o[i-2]=arguments[i];var a=n.timeoutProvider.delegate;return(null==a?void 0:a.setTimeout)?a.setTimeout.apply(a,s([e,t],r(o))):setTimeout.apply(void 0,s([e,t],r(o)))},clearTimeout:function(e){var t=n.timeoutProvider.delegate;return((null==t?void 0:t.clearTimeout)||clearTimeout)(e)},delegate:undefined}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/scheduler/timeoutProvider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/iterator.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(){return"function"==typeof Symbol&&Symbol.iterator?Symbol.iterator:"@@iterator"}Object.defineProperty(n,"__esModule",{value:!0}),n.iterator=n.getSymbolIterator=void 0,n.getSymbolIterator=r,n.iterator=r()}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/symbol/iterator.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/observable.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.observable=void 0,n.observable="function"==typeof Symbol&&Symbol.observable||"@@observable"}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/symbol/observable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/types.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/ArgumentOutOfRangeError.js",{"./createErrorClass":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ArgumentOutOfRangeError=void 0;var r=e("./createErrorClass");n.ArgumentOutOfRangeError=r.createErrorClass(function(e){return function(){e(this),this.name="ArgumentOutOfRangeError",this.message="argument out of range"}})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/ArgumentOutOfRangeError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/EmptyError.js",{"./createErrorClass":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.EmptyError=void 0;var r=e("./createErrorClass");n.EmptyError=r.createErrorClass(function(e){return function(){e(this),this.name="EmptyError",this.message="no elements in sequence"}})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/EmptyError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/Immediate.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TestTools=n.Immediate=void 0;var r,s=1,o={};function i(e){return e in o&&(delete o[e],!0)}n.Immediate={setImmediate:function(e){var t=s++;return o[t]=!0,r||(r=Promise.resolve()),r.then(function(){return i(t)&&e()}),t},clearImmediate:function(e){i(e)}},n.TestTools={pending:function(){return Object.keys(o).length}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/Immediate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/NotFoundError.js",{"./createErrorClass":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.NotFoundError=void 0;var r=e("./createErrorClass");n.NotFoundError=r.createErrorClass(function(e){return function(t){e(this),this.name="NotFoundError",this.message=t}})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/NotFoundError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/ObjectUnsubscribedError.js",{"./createErrorClass":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ObjectUnsubscribedError=void 0;var r=e("./createErrorClass");n.ObjectUnsubscribedError=r.createErrorClass(function(e){return function(){e(this),this.name="ObjectUnsubscribedError",this.message="object unsubscribed"}})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/ObjectUnsubscribedError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/SequenceError.js",{"./createErrorClass":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SequenceError=void 0;var r=e("./createErrorClass");n.SequenceError=r.createErrorClass(function(e){return function(t){e(this),this.name="SequenceError",this.message=t}})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/SequenceError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/UnsubscriptionError.js",{"./createErrorClass":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.UnsubscriptionError=void 0;var r=e("./createErrorClass");n.UnsubscriptionError=r.createErrorClass(function(e){return function(t){e(this),this.message=t?t.length+" errors occurred during unsubscription:\n"+t.map(function(e,t){return t+1+") "+e.toString()}).join("\n  "):"",this.name="UnsubscriptionError",this.errors=t}})}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/UnsubscriptionError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/args.js",{"./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js","./isScheduler":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isScheduler.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.popNumber=n.popScheduler=n.popResultSelector=void 0;var r=e("./isFunction"),s=e("./isScheduler");function o(e){return e[e.length-1]}n.popResultSelector=function(e){return r.isFunction(o(e))?e.pop():undefined},n.popScheduler=function(e){return s.isScheduler(o(e))?e.pop():undefined},n.popNumber=function(e,t){return"number"==typeof o(e)?e.pop():t}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/args.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsArgArrayOrObject.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.argsArgArrayOrObject=void 0;var r=Array.isArray,s=Object.getPrototypeOf,o=Object.prototype,i=Object.keys;n.argsArgArrayOrObject=function(e){if(1===e.length){var t=e[0];if(r(t))return{args:t,keys:null};if((a=t)&&"object"==typeof a&&s(a)===o){var n=i(t);return{args:n.map(function(e){return t[e]}),keys:n}}}var a;return{args:e,keys:null}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/argsArgArrayOrObject.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.argsOrArgArray=void 0;var r=Array.isArray;n.argsOrArgArray=function(e){return 1===e.length&&r(e[0])?e[0]:e}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/argsOrArgArray.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/arrRemove.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.arrRemove=void 0,n.arrRemove=function(e,t){if(e){var n=e.indexOf(t);0<=n&&e.splice(n,1)}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/arrRemove.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createErrorClass=void 0,n.createErrorClass=function(e){var t=e(function(e){Error.call(e),e.stack=(new Error).stack});return t.prototype=Object.create(Error.prototype),t.prototype.constructor=t,t}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/createErrorClass.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/createObject.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createObject=void 0,n.createObject=function(e,t){return e.reduce(function(e,n,r){return e[n]=t[r],e},{})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/createObject.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/errorContext.js",{"../config":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/config.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.captureError=n.errorContext=void 0;var r=e("../config"),s=null;n.errorContext=function(e){if(r.config.useDeprecatedSynchronousErrorHandling){var t=!s;if(t&&(s={errorThrown:!1,error:null}),e(),t){var n=s,o=n.errorThrown,i=n.error;if(s=null,o)throw i}}else e()},n.captureError=function(e){r.config.useDeprecatedSynchronousErrorHandling&&s&&(s.errorThrown=!0,s.error=e)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/errorContext.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.executeSchedule=void 0,n.executeSchedule=function(e,t,n,r,s){void 0===r&&(r=0),void 0===s&&(s=!1);var o=t.schedule(function(){n(),s?e.add(this.schedule(null,r)):this.unsubscribe()},r);if(e.add(o),!s)return o}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/executeSchedule.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.identity=void 0,n.identity=function(e){return e}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/identity.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isArrayLike.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isArrayLike=void 0,n.isArrayLike=function(e){return e&&"number"==typeof e.length&&"function"!=typeof e}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isArrayLike.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isAsyncIterable.js",{"./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isAsyncIterable=void 0;var r=e("./isFunction");n.isAsyncIterable=function(e){return Symbol.asyncIterator&&r.isFunction(null==e?void 0:e[Symbol.asyncIterator])}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isAsyncIterable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isDate.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isValidDate=void 0,n.isValidDate=function(e){return e instanceof Date&&!isNaN(e)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isDate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isFunction=void 0,n.isFunction=function(e){return"function"==typeof e}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isFunction.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isInteropObservable.js",{"../symbol/observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/observable.js","./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isInteropObservable=void 0;var r=e("../symbol/observable"),s=e("./isFunction");n.isInteropObservable=function(e){return s.isFunction(e[r.observable])}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isInteropObservable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isIterable.js",{"../symbol/iterator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/symbol/iterator.js","./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isIterable=void 0;var r=e("../symbol/iterator"),s=e("./isFunction");n.isIterable=function(e){return s.isFunction(null==e?void 0:e[r.iterator])}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isIterable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isObservable.js",{"../Observable":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/Observable.js","./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isObservable=void 0;var r=e("../Observable"),s=e("./isFunction");n.isObservable=function(e){return!!e&&(e instanceof r.Observable||s.isFunction(e.lift)&&s.isFunction(e.subscribe))}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isObservable.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isPromise.js",{"./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isPromise=void 0;var r=e("./isFunction");n.isPromise=function(e){return r.isFunction(null==e?void 0:e.then)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isPromise.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isReadableStreamLike.js",{"./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__generator||function(e,t){var n,r,s,o,i={label:0,sent:function(){if(1&s[0])throw s[1];return s[1]},trys:[],ops:[]};return o={next:a(0),throw:a(1),return:a(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function a(o){return function(a){return function(o){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(s=2&o[0]?r.return:o[0]?r.throw||((s=r.return)&&s.call(r),0):r.next)&&!(s=s.call(r,o[1])).done)return s;switch(r=0,s&&(o=[2&o[0],s.value]),o[0]){case 0:case 1:s=o;break;case 4:return i.label++,{value:o[1],done:!1};case 5:i.label++,r=o[1],o=[0];continue;case 7:o=i.ops.pop(),i.trys.pop();continue;default:if(!(s=i.trys,(s=s.length>0&&s[s.length-1])||6!==o[0]&&2!==o[0])){i=0;continue}if(3===o[0]&&(!s||o[1]>s[0]&&o[1]<s[3])){i.label=o[1];break}if(6===o[0]&&i.label<s[1]){i.label=s[1],s=o;break}if(s&&i.label<s[2]){i.label=s[2],i.ops.push(o);break}s[2]&&i.ops.pop(),i.trys.pop();continue}o=t.call(e,i)}catch(e){o=[6,e],r=0}finally{n=s=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,a])}}},s=this&&this.__await||function(e){return this instanceof s?(this.v=e,this):new s(e)},o=this&&this.__asyncGenerator||function(e,t,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(e,t||[]),i=[];return r={},a("next"),a("throw"),a("return"),r[Symbol.asyncIterator]=function(){return this},r;function a(e){o[e]&&(r[e]=function(t){return new Promise(function(n,r){i.push([e,t,n,r])>1||f(e,t)})})}function f(e,t){try{(n=o[e](t)).value instanceof s?Promise.resolve(n.value.v).then(u,l):d(i[0][2],n)}catch(e){d(i[0][3],e)}var n}function u(e){f("next",e)}function l(e){f("throw",e)}function d(e,t){e(t),i.shift(),i.length&&f(i[0][0],i[0][1])}};Object.defineProperty(n,"__esModule",{value:!0}),n.isReadableStreamLike=n.readableStreamLikeToAsyncGenerator=void 0;var i=e("./isFunction");n.readableStreamLikeToAsyncGenerator=function(e){return o(this,arguments,function(){var t,n,o;return r(this,function(r){switch(r.label){case 0:t=e.getReader(),r.label=1;case 1:r.trys.push([1,,9,10]),r.label=2;case 2:return[4,s(t.read())];case 3:return n=r.sent(),o=n.value,n.done?[4,s(void 0)]:[3,5];case 4:return[2,r.sent()];case 5:return[4,s(o)];case 6:return[4,r.sent()];case 7:return r.sent(),[3,2];case 8:return[3,10];case 9:return t.releaseLock(),[7];case 10:return[2]}})})},n.isReadableStreamLike=function(e){return i.isFunction(null==e?void 0:e.getReader)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isReadableStreamLike.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isScheduler.js",{"./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isScheduler=void 0;var r=e("./isFunction");n.isScheduler=function(e){return e&&r.isFunction(e.schedule)}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/isScheduler.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/lift.js",{"./isFunction":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/isFunction.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.operate=n.hasLift=void 0;var r=e("./isFunction");function s(e){return r.isFunction(null==e?void 0:e.lift)}n.hasLift=s,n.operate=function(e){return function(t){if(s(t))return t.lift(function(t){try{return e(t,this)}catch(e){this.error(e)}});throw new TypeError("Unable to lift unknown Observable type")}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/lift.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js",{"../operators/map":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/operators/map.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__read||function(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,s,o=n.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(r=o.next()).done;)i.push(r.value)}catch(e){s={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(s)throw s.error}}return i},s=this&&this.__spreadArray||function(e,t){for(var n=0,r=t.length,s=e.length;n<r;n++,s++)e[s]=t[n];return e};Object.defineProperty(n,"__esModule",{value:!0}),n.mapOneOrManyArgs=void 0;var o=e("../operators/map"),i=Array.isArray;n.mapOneOrManyArgs=function(e){return o.map(function(t){return function(e,t){return i(t)?e.apply(void 0,s([],r(t))):e(t)}(e,t)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/mapOneOrManyArgs.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/noop.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.noop=void 0,n.noop=function(){}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/noop.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/not.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.not=void 0,n.not=function(e,t){return function(n,r){return!e.call(t,n,r)}}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/not.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/pipe.js",{"./identity":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/identity.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.pipeFromArray=n.pipe=void 0;var r=e("./identity");function s(e){return 0===e.length?r.identity:1===e.length?e[0]:function(t){return e.reduce(function(e,t){return t(e)},t)}}n.pipe=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return s(e)},n.pipeFromArray=s}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/pipe.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/reportUnhandledError.js",{"../config":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/config.js","../scheduler/timeoutProvider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/scheduler/timeoutProvider.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.reportUnhandledError=void 0;var r=e("../config"),s=e("../scheduler/timeoutProvider");n.reportUnhandledError=function(e){s.timeoutProvider.setTimeout(function(){var t=r.config.onUnhandledError;if(!t)throw e;t(e)})}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/reportUnhandledError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/rxjs/dist/cjs/internal/util/throwUnobservableError.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createInvalidObservableTypeError=void 0,n.createInvalidObservableTypeError=function(e){return new TypeError("You provided "+(null!==e&&"object"==typeof e?"an invalid object":"'"+e+"'")+" where a stream was expected. You can provide an Observable, Promise, ReadableStream, Array, AsyncIterable, or Iterable.")}}}},{package:"wait-on>rxjs",file:"node_modules/rxjs/dist/cjs/internal/util/throwUnobservableError.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js","fast-fifo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-fifo/index.js","queue-tick":"/home/runner/work/metamask-extension/metamask-extension/node_modules/queue-tick/queue-microtask.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{EventEmitter:r}=e("events"),s=new Error("Stream was destroyed"),o=new Error("Premature close"),i=e("queue-tick"),a=e("fast-fifo"),f=134217727,u=1^f,l=2^f,d=64,c=128,m=256,h=1024,b=2048,p=4096,k=8192,x=16384,j=32768,w=16^f,g=768^f,y=134184959,_=32^f,v=2<<17,T=4<<17,S=8<<17,E=16<<17,O=32<<17,A=64<<17,C=128<<17,P=256<<17,I=512<<17,M=100532223,R=133693439,L=117440511,B=131088,F=134086639,N=4210688,D=14,U=15,H=4210702,W=16809984,G=16809999,z=1179648,V=1179663,q=Symbol.asyncIterator||Symbol("asyncIterator");class K{constructor(e,{highWaterMark:t=16384,map:n=null,mapWritable:r,byteLength:s,byteLengthWritable:o}={}){this.stream=e,this.queue=new a,this.highWaterMark=t,this.buffered=0,this.error=null,this.pipeline=null,this.drains=null,this.byteLength=o||s||he,this.map=r||n,this.afterWrite=ee.bind(this),this.afterUpdateNextTick=re.bind(this)}get ended(){return 0!==(this.stream._duplexState&O)}push(e){return null!==this.map&&(e=this.map(e)),this.buffered+=this.byteLength(e),this.queue.push(e),this.buffered<this.highWaterMark?(this.stream._duplexState|=S,!0):(this.stream._duplexState|=3145728,!1)}shift(){const e=this.queue.shift();return this.buffered-=this.byteLength(e),0===this.buffered&&(this.stream._duplexState&=133169151),e}end(e){"function"==typeof e?this.stream.once("finish",e):e!==undefined&&null!==e&&this.push(e),this.stream._duplexState=(this.stream._duplexState|I)&R}autoBatch(e,t){const n=[],r=this.stream;for(n.push(e);(r._duplexState&V)===z;)n.push(r._writableState.shift());if(0!==(r._duplexState&U))return t(null);r._writev(n,t)}update(){const e=this.stream;e._duplexState|=v;do{for(;(e._duplexState&V)===S;){const t=this.shift();e._duplexState|=33685504,e._write(t,this.afterWrite)}655360&e._duplexState||this.updateNonPrimary()}while(!0===this.continueUpdate());e._duplexState&=133955583}updateNonPrimary(){const e=this.stream;if((72482831&e._duplexState)===I)return e._duplexState=67108863&e._duplexState|131072,void e._final(Q.bind(this));4!==(e._duplexState&D)?1===(e._duplexState&G)&&(e._duplexState=(e._duplexState|B)&u,e._open(se.bind(this))):0===(e._duplexState&W)&&(e._duplexState|=B,e._destroy($.bind(this)))}continueUpdate(){return 0!==(this.stream._duplexState&C)&&(this.stream._duplexState&=L,!0)}updateCallback(){(17563663&this.stream._duplexState)===T?this.update():this.updateNextTick()}updateNextTick(){0===(this.stream._duplexState&C)&&(this.stream._duplexState|=C,0===(this.stream._duplexState&v)&&i(this.afterUpdateNextTick))}}class Y{constructor(e,{highWaterMark:t=16384,map:n=null,mapReadable:r,byteLength:s,byteLengthReadable:o}={}){this.stream=e,this.queue=new a,this.highWaterMark=t,this.buffered=0,this.error=null,this.pipeline=null,this.byteLength=o||s||he,this.map=r||n,this.pipeTo=null,this.afterRead=te.bind(this),this.afterUpdateNextTick=ne.bind(this)}get ended(){return 0!==(this.stream._duplexState&x)}pipe(e,t){if(null!==this.pipeTo)throw new Error("Can only pipe to one destination");if("function"!=typeof t&&(t=null),this.stream._duplexState|=512,this.pipeTo=e,this.pipeline=new Z(this.stream,e,t),t&&this.stream.on("error",be),me(e))e._writableState.pipeline=this.pipeline,t&&e.on("error",be),e.on("finish",this.pipeline.finished.bind(this.pipeline));else{const t=this.pipeline.done.bind(this.pipeline,e),n=this.pipeline.done.bind(this.pipeline,e,null);e.on("error",t),e.on("close",n),e.on("finish",this.pipeline.finished.bind(this.pipeline))}e.on("drain",X.bind(this)),this.stream.emit("piping",e),e.emit("pipe",this.stream)}push(e){const t=this.stream;return null===e?(this.highWaterMark=0,t._duplexState=134152127&t._duplexState|1024,!1):(null!==this.map&&(e=this.map(e)),this.buffered+=this.byteLength(e),this.queue.push(e),t._duplexState=134152191&t._duplexState|128,this.buffered<this.highWaterMark)}shift(){const e=this.queue.shift();return this.buffered-=this.byteLength(e),0===this.buffered&&(this.stream._duplexState&=134209407),e}unshift(e){const t=[null!==this.map?this.map(e):e];for(;this.buffered>0;)t.push(this.shift());for(let e=0;e<t.length-1;e++){const n=t[e];this.buffered+=this.byteLength(n),this.queue.push(n)}this.push(t[t.length-1])}read(){const e=this.stream;if((16527&e._duplexState)===c){const t=this.shift();return null!==this.pipeTo&&!1===this.pipeTo.write(t)&&(e._duplexState&=g),0!==(e._duplexState&b)&&e.emit("data",t),t}return null}drain(){const e=this.stream;for(;(16527&e._duplexState)===c&&768&e._duplexState;){const t=this.shift();null!==this.pipeTo&&!1===this.pipeTo.write(t)&&(e._duplexState&=g),0!==(e._duplexState&b)&&e.emit("data",t)}}update(){const e=this.stream;e._duplexState|=32;do{for(this.drain();this.buffered<this.highWaterMark&&!(82975&e._duplexState);)e._duplexState|=65552,e._read(this.afterRead),this.drain();4224==(12431&e._duplexState)&&(e._duplexState|=k,e.emit("readable")),80&e._duplexState||this.updateNonPrimary()}while(!0===this.continueUpdate());e._duplexState&=_}updateNonPrimary(){const e=this.stream;(1167&e._duplexState)===h&&(e._duplexState=134216703&e._duplexState|16384,e.emit("end"),(e._duplexState&H)===N&&(e._duplexState|=4),null!==this.pipeTo&&this.pipeTo.end()),4!==(e._duplexState&D)?1===(e._duplexState&G)&&(e._duplexState=(e._duplexState|B)&u,e._open(se.bind(this))):0===(e._duplexState&W)&&(e._duplexState|=B,e._destroy($.bind(this)))}continueUpdate(){return 0!==(this.stream._duplexState&j)&&(this.stream._duplexState&=y,!0)}updateCallback(){(32879&this.stream._duplexState)===d?this.update():this.updateNextTick()}updateNextTick(){0===(this.stream._duplexState&j)&&(this.stream._duplexState|=j,32&this.stream._duplexState||i(this.afterUpdateNextTick))}}class J{constructor(e){this.data=null,this.afterTransform=oe.bind(e),this.afterFinal=null}}class Z{constructor(e,t,n){this.from=e,this.to=t,this.afterPipe=n,this.error=null,this.pipeToFinished=!1}finished(){this.pipeToFinished=!0}done(e,t){t&&(this.error=t),e!==this.to||(this.to=null,null===this.from)?e!==this.from||(this.from=null,null===this.to)?(null!==this.afterPipe&&this.afterPipe(this.error),this.to=this.from=this.afterPipe=null):0===(e._duplexState&x)&&this.to.destroy(this.error||new Error("Readable stream closed before ending")):0!==(this.from._duplexState&x)&&this.pipeToFinished||this.from.destroy(this.error||new Error("Writable stream closed prematurely"))}}function X(){this.stream._duplexState|=512,this.updateCallback()}function Q(e){const t=this.stream;e&&t.destroy(e),0===(t._duplexState&D)&&(t._duplexState|=O,t.emit("finish")),(t._duplexState&H)===N&&(t._duplexState|=4),t._duplexState&=M,0===(t._duplexState&v)?this.update():this.updateNextTick()}function $(e){const t=this.stream;e||this.error===s||(e=this.error),e&&t.emit("error",e),t._duplexState|=8,t.emit("close");const n=t._readableState,r=t._writableState;if(null!==n&&null!==n.pipeline&&n.pipeline.done(t,e),null!==r){for(;null!==r.drains&&r.drains.length>0;)r.drains.shift().resolve(!1);null!==r.pipeline&&r.pipeline.done(t,e)}}function ee(e){const t=this.stream;e&&t.destroy(e),t._duplexState&=M,null!==this.drains&&function(e){for(let t=0;t<e.length;t++)0===--e[t].writes&&(e.shift().resolve(!0),t--)}(this.drains),(3276815&t._duplexState)===E&&(t._duplexState&=132120575,(t._duplexState&A)===A&&t.emit("drain")),this.updateCallback()}function te(e){e&&this.stream.destroy(e),this.stream._duplexState&=w,this.updateCallback()}function ne(){32&this.stream._duplexState||(this.stream._duplexState&=y,this.update())}function re(){0===(this.stream._duplexState&v)&&(this.stream._duplexState&=L,this.update())}function se(e){const t=this.stream;e&&t.destroy(e),4&t._duplexState||(17423&t._duplexState||(t._duplexState|=d),71303183&t._duplexState||(t._duplexState|=T),t.emit("open")),t._duplexState&=F,null!==t._writableState&&t._writableState.updateCallback(),null!==t._readableState&&t._readableState.updateCallback()}function oe(e,t){t!==undefined&&null!==t&&this.push(t),this._writableState.afterWrite(e)}class ie extends r{constructor(e){super(),this._duplexState=0,this._readableState=null,this._writableState=null,e&&(e.open&&(this._open=e.open),e.destroy&&(this._destroy=e.destroy),e.predestroy&&(this._predestroy=e.predestroy),e.signal&&e.signal.addEventListener("abort",pe.bind(this)))}_open(e){e(null)}_destroy(e){e(null)}_predestroy(){}get readable(){return null!==this._readableState||undefined}get writable(){return null!==this._writableState||undefined}get destroyed(){return!!(8&this._duplexState)}get destroying(){return 0!==(this._duplexState&D)}destroy(e){0===(this._duplexState&D)&&(e||(e=s),this._duplexState=133693375&this._duplexState|4,null!==this._readableState&&(this._readableState.highWaterMark=0,this._readableState.error=e),null!==this._writableState&&(this._writableState.highWaterMark=0,this._writableState.error=e),this._duplexState|=2,this._predestroy(),this._duplexState&=l,null!==this._readableState&&this._readableState.updateNextTick(),null!==this._writableState&&this._writableState.updateNextTick())}on(e,t){return null!==this._readableState&&("data"===e&&(this._duplexState|=2304,this._readableState.updateNextTick()),"readable"===e&&(this._duplexState|=p,this._readableState.updateNextTick())),null!==this._writableState&&"drain"===e&&(this._duplexState|=A,this._writableState.updateNextTick()),super.on(e,t)}}class ae extends ie{constructor(e){super(e),this._duplexState|=4194305,this._readableState=new Y(this,e),e&&(e.read&&(this._read=e.read),e.eagerOpen&&this._readableState.updateNextTick())}_read(e){e(null)}pipe(e,t){return this._readableState.updateNextTick(),this._readableState.pipe(e,t),e}read(){return this._readableState.updateNextTick(),this._readableState.read()}push(e){return this._readableState.updateNextTick(),this._readableState.push(e)}unshift(e){return this._readableState.updateNextTick(),this._readableState.unshift(e)}resume(){return this._duplexState|=m,this._readableState.updateNextTick(),this}pause(){return this._duplexState&=134217471,this}static _fromAsyncIterator(e,t){let n;const r=new ae({...t,read(t){e.next().then(s).then(t.bind(null,null)).catch(t)},predestroy(){n=e.return()},destroy(e){if(!n)return e(null);n.then(e.bind(null,null)).catch(e)}});return r;function s(e){e.done?r.push(null):r.push(e.value)}}static from(e,t){if(me(n=e)&&n.readable)return e;var n;if(e[q])return this._fromAsyncIterator(e[q](),t);Array.isArray(e)||(e=e===undefined?[]:[e]);let r=0;return new ae({...t,read(t){this.push(r===e.length?null:e[r++]),t(null)}})}static isBackpressured(e){return!!(17422&e._duplexState)||e._readableState.buffered>=e._readableState.highWaterMark}static isPaused(e){return 0===(e._duplexState&m)}[q](){const e=this;let t=null,n=null,r=null;return this.on("error",e=>{t=e}),this.on("readable",function(){null!==n&&o(e.read())}),this.on("close",function(){null!==n&&o(null)}),{[q](){return this},next:()=>new Promise(function(t,s){n=t,r=s;const i=e.read();null!==i?o(i):8&e._duplexState&&o(null)}),return:()=>i(null),throw:e=>i(e)};function o(o){null!==r&&(t?r(t):null===o&&0===(e._duplexState&x)?r(s):n({value:o,done:null===o}),r=n=null)}function i(t){return e.destroy(t),new Promise((n,r)=>{if(8&e._duplexState)return n({value:undefined,done:!0});e.once("close",function(){t?r(t):n({value:undefined,done:!0})})})}}}class fe extends ae{constructor(e){super(e),this._duplexState=1,this._writableState=new K(this,e),e&&(e.writev&&(this._writev=e.writev),e.write&&(this._write=e.write),e.final&&(this._final=e.final))}_writev(e,t){t(null)}_write(e,t){this._writableState.autoBatch(e,t)}_final(e){e(null)}write(e){return this._writableState.updateNextTick(),this._writableState.push(e)}end(e){return this._writableState.updateNextTick(),this._writableState.end(e),this}}class ue extends fe{constructor(e){super(e),this._transformState=new J(this),e&&(e.transform&&(this._transform=e.transform),e.flush&&(this._flush=e.flush))}_write(e,t){this._readableState.buffered>=this._readableState.highWaterMark?this._transformState.data=e:this._transform(e,this._transformState.afterTransform)}_read(e){if(null!==this._transformState.data){const t=this._transformState.data;this._transformState.data=null,e(null),this._transform(t,this._transformState.afterTransform)}else e(null)}_transform(e,t){t(null,e)}_flush(e){e(null)}_final(e){this._transformState.afterFinal=e,this._flush(le.bind(this))}}function le(e,t){const n=this._transformState.afterFinal;if(e)return n(e);null!==t&&t!==undefined&&this.push(t),this.push(null),n(null)}function de(e,...t){const n=Array.isArray(e)?[...e,...t]:[e,...t],r=n.length&&"function"==typeof n[n.length-1]?n.pop():null;if(n.length<2)throw new Error("Pipeline requires at least 2 streams");let s=n[0],i=null,a=null;for(let e=1;e<n.length;e++)i=n[e],me(s)?s.pipe(i,u):(f(s,!0,e>1,u),s.pipe(i)),s=i;if(r){let e=!1;const t=me(i)||!(!i._writableState||!i._writableState.autoDestroy);i.on("error",e=>{null===a&&(a=e)}),i.on("finish",()=>{e=!0,t||r(a)}),t&&i.on("close",()=>r(a||(e?null:o)))}return i;function f(e,t,n,r){e.on("error",r),e.on("close",function(){if(t&&e._readableState&&!e._readableState.ended)return r(o);if(n&&e._writableState&&!e._writableState.ended)return r(o)})}function u(e){if(e&&!a){a=e;for(const t of n)t.destroy(e)}}}function ce(e){return!!e._readableState||!!e._writableState}function me(e){return"number"==typeof e._duplexState&&ce(e)}function he(e){return function(e){return"object"==typeof e&&null!==e&&"number"==typeof e.byteLength}(e)?e.byteLength:1024}function be(){}function pe(){this.destroy(new Error("Stream aborted."))}t.exports={pipeline:de,pipelinePromise:function(...e){return new Promise((t,n)=>de(...e,e=>{if(e)return n(e);t()}))},isStream:ce,isStreamx:me,getStreamError:function(e){const t=e._readableState&&e._readableState.error||e._writableState&&e._writableState.error;return t===s?null:t},Stream:ie,Writable:class extends ie{constructor(e){super(e),this._duplexState|=16385,this._writableState=new K(this,e),e&&(e.writev&&(this._writev=e.writev),e.write&&(this._write=e.write),e.final&&(this._final=e.final),e.eagerOpen&&this._writableState.updateNextTick())}_writev(e,t){t(null)}_write(e,t){this._writableState.autoBatch(e,t)}_final(e){e(null)}static isBackpressured(e){return!!(73400334&e._duplexState)}static drained(e){if(e.destroyed)return Promise.resolve(!1);const t=e._writableState,n=t.queue.length+(e._duplexState&P?1:0);return 0===n?Promise.resolve(!0):(null===t.drains&&(t.drains=[]),new Promise(e=>{t.drains.push({writes:n,resolve:e})}))}write(e){return this._writableState.updateNextTick(),this._writableState.push(e)}end(e){return this._writableState.updateNextTick(),this._writableState.end(e),this}},Readable:ae,Duplex:fe,Transform:ue,PassThrough:class extends ue{}}}}},{package:"@metamask/snaps-controllers>tar-stream>streamx",file:"node_modules/streamx/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/constants.js",{fs:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r={S_IFMT:61440,S_IFDIR:16384,S_IFCHR:8192,S_IFBLK:24576,S_IFIFO:4096,S_IFLNK:40960};try{t.exports=e("fs").constants||r}catch{t.exports=r}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/tar-stream/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/extract.js",{"./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js","fast-fifo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-fifo/index.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{Writable:r,Readable:s,getStreamError:o}=e("streamx"),i=e("fast-fifo"),a=e("b4a"),f=e("./headers"),u=a.alloc(0);class l{constructor(){this.buffered=0,this.shifted=0,this.queue=new i,this._offset=0}push(e){this.buffered+=e.byteLength,this.queue.push(e)}shiftFirst(e){return 0===this._buffered?null:this._next(e)}shift(e){if(e>this.buffered)return null;if(0===e)return u;let t=this._next(e);if(e===t.byteLength)return t;const n=[t];for(;(e-=t.byteLength)>0;)t=this._next(e),n.push(t);return a.concat(n)}_next(e){const t=this.queue.peek(),n=t.byteLength-this._offset;if(e>=n){const e=this._offset?t.subarray(this._offset,t.byteLength):t;return this.queue.shift(),this._offset=0,this.buffered-=n,this.shifted+=n,e}return this.buffered-=e,this.shifted+=e,t.subarray(this._offset,this._offset+=e)}}class d extends s{constructor(e,t,n){super(),this.header=t,this.offset=n,this._parent=e}_read(e){0===this.header.size&&this.push(null),this._parent._stream===this&&this._parent._update(),e(null)}_predestroy(){this._parent.destroy(o(this))}_detach(){this._parent._stream===this&&(this._parent._stream=null,this._parent._missing=h(this.header.size),this._parent._update())}_destroy(e){this._detach(),e(null)}}class c extends r{constructor(e){super(e),e||(e={}),this._buffer=new l,this._offset=0,this._header=null,this._stream=null,this._missing=0,this._longHeader=!1,this._callback=m,this._locked=!1,this._finished=!1,this._pax=null,this._paxGlobal=null,this._gnuLongPath=null,this._gnuLongLinkPath=null,this._filenameEncoding=e.filenameEncoding||"utf-8",this._allowUnknownFormat=!!e.allowUnknownFormat,this._unlockBound=this._unlock.bind(this)}_unlock(e){if(this._locked=!1,e)return this.destroy(e),void this._continueWrite(e);this._update()}_consumeHeader(){if(this._locked)return!1;this._offset=this._buffer.shifted;try{this._header=f.decode(this._buffer.shift(512),this._filenameEncoding,this._allowUnknownFormat)}catch(e){return this._continueWrite(e),!1}if(!this._header)return!0;switch(this._header.type){case"gnu-long-path":case"gnu-long-link-path":case"pax-global-header":case"pax-header":return this._longHeader=!0,this._missing=this._header.size,!0}return this._locked=!0,this._applyLongHeaders(),0===this._header.size||"directory"===this._header.type?(this.emit("entry",this._header,this._createStream(),this._unlockBound),!0):(this._stream=this._createStream(),this._missing=this._header.size,this.emit("entry",this._header,this._stream,this._unlockBound),!0)}_applyLongHeaders(){this._gnuLongPath&&(this._header.name=this._gnuLongPath,this._gnuLongPath=null),this._gnuLongLinkPath&&(this._header.linkname=this._gnuLongLinkPath,this._gnuLongLinkPath=null),this._pax&&(this._pax.path&&(this._header.name=this._pax.path),this._pax.linkpath&&(this._header.linkname=this._pax.linkpath),this._pax.size&&(this._header.size=parseInt(this._pax.size,10)),this._header.pax=this._pax,this._pax=null)}_decodeLongHeader(e){switch(this._header.type){case"gnu-long-path":this._gnuLongPath=f.decodeLongPath(e,this._filenameEncoding);break;case"gnu-long-link-path":this._gnuLongLinkPath=f.decodeLongPath(e,this._filenameEncoding);break;case"pax-global-header":this._paxGlobal=f.decodePax(e);break;case"pax-header":this._pax=null===this._paxGlobal?f.decodePax(e):Object.assign({},this._paxGlobal,f.decodePax(e))}}_consumeLongHeader(){this._longHeader=!1,this._missing=h(this._header.size);const e=this._buffer.shift(this._header.size);try{this._decodeLongHeader(e)}catch(e){return this._continueWrite(e),!1}return!0}_consumeStream(){const e=this._buffer.shiftFirst(this._missing);if(null===e)return!1;this._missing-=e.byteLength;const t=this._stream.push(e);return 0===this._missing?(this._stream.push(null),t&&this._stream._detach(),t&&!1===this._locked):t}_createStream(){return new d(this,this._header,this._offset)}_update(){for(;this._buffer.buffered>0&&!this.destroying;){if(this._missing>0){if(null!==this._stream){if(!1===this._consumeStream())return;continue}if(!0===this._longHeader){if(this._missing>this._buffer.buffered)break;if(!1===this._consumeLongHeader())return!1;continue}const e=this._buffer.shiftFirst(this._missing);null!==e&&(this._missing-=e.byteLength);continue}if(this._buffer.buffered<512)break;if(null!==this._stream||!1===this._consumeHeader())return}this._continueWrite(null)}_continueWrite(e){const t=this._callback;this._callback=m,t(e)}_write(e,t){this._callback=t,this._buffer.push(e),this._update()}_final(e){this._finished=0===this._missing&&0===this._buffer.buffered,e(this._finished?null:new Error("Unexpected end of data"))}_predestroy(){this._continueWrite(null)}_destroy(e){this._stream&&this._stream.destroy(o(this)),e(null)}[Symbol.asyncIterator](){let e=null,t=null,n=null,r=null,s=null;const o=this;return this.on("entry",function(e,o,i){s=i,o.on("error",m),t?(t({value:o,done:!1}),t=n=null):r=o}),this.on("error",t=>{e=t}),this.on("close",function(){if(i(e),!t)return;e?n(e):t({value:undefined,done:!0});t=n=null}),{[Symbol.asyncIterator](){return this},next:()=>new Promise(a),return:()=>f(null),throw:e=>f(e)};function i(e){if(!s)return;const t=s;s=null,t(e)}function a(s,a){return e?a(e):r?(s({value:r,done:!1}),void(r=null)):(t=s,n=a,i(null),void(o._finished&&t&&(t({value:undefined,done:!0}),t=n=null)))}function f(e){return o.destroy(e),i(e),new Promise((t,n)=>{if(o.destroyed)return t({value:undefined,done:!0});o.once("close",function(){e?n(e):t({value:undefined,done:!0})})})}}}function m(){}function h(e){return(e&=511)&&512-e}t.exports=function(e){return new c(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/tar-stream/extract.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/headers.js",{b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("b4a"),s="0".charCodeAt(0),o=r.from([117,115,116,97,114,0]),i=r.from([s,s]),a=r.from([117,115,116,97,114,32]),f=r.from([32,0]),u=257,l=263;function d(e,t,n,r){for(;n<r;n++)if(e[n]===t)return n;return r}function c(e){let t=256;for(let n=0;n<148;n++)t+=e[n];for(let n=156;n<512;n++)t+=e[n];return t}function m(e,t){return(e=e.toString(8)).length>t?"7777777777777777777".slice(0,t)+" ":"0000000000000000000".slice(0,t-e.length)+e+" "}function h(e,t,n){if(128&(e=e.subarray(t,t+n))[t=0])return function(e){let t;if(128===e[0])t=!0;else{if(255!==e[0])return null;t=!1}const n=[];let r;for(r=e.length-1;r>0;r--){const s=e[r];t?n.push(s):n.push(255-s)}let s=0;const o=n.length;for(r=0;r<o;r++)s+=n[r]*Math.pow(256,r);return t?s:-1*s}(e);{for(;t<e.length&&32===e[t];)t++;const n=(s=d(e,32,t,e.length),o=e.length,i=e.length,"number"!=typeof s?i:(s=~~s)>=o?o:s>=0||(s+=o)>=0?s:0);for(;t<n&&0===e[t];)t++;return n===t?0:parseInt(r.toString(e.subarray(t,n)),8)}var s,o,i}function b(e,t,n,s){return r.toString(e.subarray(t,d(e,0,t,t+n)),s)}function p(e){const t=r.byteLength(e);let n=Math.floor(Math.log(t)/Math.log(10))+1;return t+n>=Math.pow(10,n)&&n++,t+n+e}n.decodeLongPath=function(e,t){return b(e,0,e.length,t)},n.encodePax=function(e){let t="";e.name&&(t+=p(" path="+e.name+"\n")),e.linkname&&(t+=p(" linkpath="+e.linkname+"\n"));const n=e.pax;if(n)for(const e in n)t+=p(" "+e+"="+n[e]+"\n");return r.from(t)},n.decodePax=function(e){const t={};for(;e.length;){let n=0;for(;n<e.length&&32!==e[n];)n++;const s=parseInt(r.toString(e.subarray(0,n)),10);if(!s)return t;const o=r.toString(e.subarray(n+1,s-1)),i=o.indexOf("=");if(-1===i)return t;t[o.slice(0,i)]=o.slice(i+1),e=e.subarray(s)}return t},n.encode=function(e){const t=r.alloc(512);let n=e.name,a="";if(5===e.typeflag&&"/"!==n[n.length-1]&&(n+="/"),r.byteLength(n)!==n.length)return null;for(;r.byteLength(n)>100;){const e=n.indexOf("/");if(-1===e)return null;a+=a?"/"+n.slice(0,e):n.slice(0,e),n=n.slice(e+1)}return r.byteLength(n)>100||r.byteLength(a)>155||e.linkname&&r.byteLength(e.linkname)>100?null:(r.write(t,n),r.write(t,m(4095&e.mode,6),100),r.write(t,m(e.uid,6),108),r.write(t,m(e.gid,6),116),function(e,t,n){e.toString(8).length>11?function(e,t,n){t[n]=128;for(let r=11;r>0;r--)t[n+r]=255&e,e=Math.floor(e/256)}(e,t,n):r.write(t,m(e,11),n)}(e.size,t,124),r.write(t,m(e.mtime.getTime()/1e3|0,11),136),t[156]=s+function(e){switch(e){case"file":return 0;case"link":return 1;case"symlink":return 2;case"character-device":return 3;case"block-device":return 4;case"directory":return 5;case"fifo":return 6;case"contiguous-file":return 7;case"pax-header":return 72}return 0}(e.type),e.linkname&&r.write(t,e.linkname,157),r.copy(o,t,u),r.copy(i,t,263),e.uname&&r.write(t,e.uname,265),e.gname&&r.write(t,e.gname,297),r.write(t,m(e.devmajor||0,6),329),r.write(t,m(e.devminor||0,6),337),a&&r.write(t,a,345),r.write(t,m(c(t),6),148),t)},n.decode=function(e,t,n){let i=0===e[156]?0:e[156]-s,d=b(e,0,100,t);const m=h(e,100,8),p=h(e,108,8),k=h(e,116,8),x=h(e,124,12),j=h(e,136,12),w=function(e){switch(e){case 0:return"file";case 1:return"link";case 2:return"symlink";case 3:return"character-device";case 4:return"block-device";case 5:return"directory";case 6:return"fifo";case 7:return"contiguous-file";case 72:return"pax-header";case 55:return"pax-global-header";case 27:return"gnu-long-link-path";case 28:case 30:return"gnu-long-path"}return null}(i),g=0===e[157]?null:b(e,157,100,t),y=b(e,265,32),_=b(e,297,32),v=h(e,329,8),T=h(e,337,8),S=c(e);if(256===S)return null;if(S!==h(e,148,8))throw new Error("Invalid tar header. Maybe the tar is corrupted or it needs to be gunzipped?");if(function(e){return r.equals(o,e.subarray(u,263))}(e))e[345]&&(d=b(e,345,155,t)+"/"+d);else if(function(e){return r.equals(a,e.subarray(u,263))&&r.equals(f,e.subarray(l,265))}(e));else if(!n)throw new Error("Invalid tar header: unknown format.");return 0===i&&d&&"/"===d[d.length-1]&&(i=5),{name:d,mode:m,uid:p,gid:k,size:x,mtime:new Date(1e3*j),type:w,linkname:g,uname:y,gname:_,devmajor:v,devminor:T,pax:null}}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/tar-stream/headers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/index.js",{"./extract":"/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/extract.js","./pack":"/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/pack.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){n.extract=e("./extract"),n.pack=e("./pack")}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/tar-stream/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/pack.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/constants.js","./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{Readable:r,Writable:s,getStreamError:o}=e("streamx"),i=e("b4a"),a=e("./constants"),f=e("./headers"),u=i.alloc(1024);class l extends s{constructor(e,t,n){super({mapWritable:h,eagerOpen:!0}),this.written=0,this.header=t,this._callback=n,this._linkname=null,this._isLinkname="symlink"===t.type&&!t.linkname,this._isVoid="file"!==t.type&&"contiguous-file"!==t.type,this._finished=!1,this._pack=e,this._openCallback=null,null===this._pack._stream?this._pack._stream=this:this._pack._pending.push(this)}_open(e){this._openCallback=e,this._pack._stream===this&&this._continueOpen()}_continuePack(e){if(null===this._callback)return;const t=this._callback;this._callback=null,t(e)}_continueOpen(){null===this._pack._stream&&(this._pack._stream=this);const e=this._openCallback;if(this._openCallback=null,null!==e){if(this._pack.destroying)return e(new Error("pack stream destroyed"));if(this._pack._finalized)return e(new Error("pack stream is already finalized"));this._pack._stream=this,this._isLinkname||this._pack._encode(this.header),this._isVoid&&(this._finish(),this._continuePack(null)),e(null)}}_write(e,t){return this._isLinkname?(this._linkname=this._linkname?i.concat([this._linkname,e]):e,t(null)):this._isVoid?e.byteLength>0?t(new Error("No body allowed for this entry")):t():(this.written+=e.byteLength,this._pack.push(e)?t():void(this._pack._drain=t))}_finish(){this._finished||(this._finished=!0,this._isLinkname&&(this.header.linkname=this._linkname?i.toString(this._linkname,"utf-8"):"",this._pack._encode(this.header)),m(this._pack,this.header.size),this._pack._done(this))}_final(e){if(this.written!==this.header.size)return e(new Error("Size mismatch"));this._finish(),e(null)}_getError(){return o(this)||new Error("tar entry destroyed")}_predestroy(){this._pack.destroy(this._getError())}_destroy(e){this._pack._done(this),this._continuePack(this._finished?null:this._getError()),e()}}class d extends r{constructor(e){super(e),this._drain=c,this._finalized=!1,this._finalizing=!1,this._pending=[],this._stream=null}entry(e,t,n){if(this._finalized||this.destroying)throw new Error("already finalized or destroyed");"function"==typeof t&&(n=t,t=null),n||(n=c),e.size&&"symlink"!==e.type||(e.size=0),e.type||(e.type=function(e){switch(e&a.S_IFMT){case a.S_IFBLK:return"block-device";case a.S_IFCHR:return"character-device";case a.S_IFDIR:return"directory";case a.S_IFIFO:return"fifo";case a.S_IFLNK:return"symlink"}return"file"}(e.mode)),e.mode||(e.mode="directory"===e.type?493:420),e.uid||(e.uid=0),e.gid||(e.gid=0),e.mtime||(e.mtime=new Date),"string"==typeof t&&(t=i.from(t));const r=new l(this,e,n);return i.isBuffer(t)?(e.size=t.byteLength,r.write(t),r.end(),r):(r._isVoid,r)}finalize(){this._stream||this._pending.length>0?this._finalizing=!0:this._finalized||(this._finalized=!0,this.push(u),this.push(null))}_done(e){e===this._stream&&(this._stream=null,this._finalizing&&this.finalize(),this._pending.length&&this._pending.shift()._continueOpen())}_encode(e){if(!e.pax){const t=f.encode(e);if(t)return void this.push(t)}this._encodePax(e)}_encodePax(e){const t=f.encodePax({name:e.name,linkname:e.linkname,pax:e.pax}),n={name:"PaxHeader",mode:e.mode,uid:e.uid,gid:e.gid,size:t.byteLength,mtime:e.mtime,type:"pax-header",linkname:e.linkname&&"PaxHeader",uname:e.uname,gname:e.gname,devmajor:e.devmajor,devminor:e.devminor};this.push(f.encode(n)),this.push(t),m(this,t.byteLength),n.size=e.size,n.type=e.type,this.push(f.encode(n))}_doDrain(){const e=this._drain;this._drain=c,e()}_predestroy(){const e=o(this);for(this._stream&&this._stream.destroy(e);this._pending.length;){const t=this._pending.shift();t.destroy(e),t._continueOpen()}this._doDrain()}_read(e){this._doDrain(),e()}}function c(){}function m(e,t){(t&=511)&&e.push(u.subarray(0,512-t))}function h(e){return i.isBuffer(e)?e:i.from(e)}t.exports=function(e){return new d(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/tar-stream/pack.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/to-data-view/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){if(e instanceof Int8Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray)return new DataView(e.buffer,e.byteOffset,e.byteLength);if(e instanceof ArrayBuffer)return new DataView(e);throw new TypeError("Expected `data` to be an ArrayBuffer, Buffer, Int8Array, Uint8Array or Uint8ClampedArray")}}}},{package:"base32-encode>to-data-view",file:"node_modules/to-data-view/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/typedarray/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,o,i=void 0,a=(r=Object.prototype.toString,s=Object.prototype.hasOwnProperty,{Class:function(e){return r.call(e).replace(/^\[object *|\]$/g,"")},HasProperty:function(e,t){return t in e},HasOwnProperty:function(e,t){return s.call(e,t)},IsCallable:function(e){return"function"==typeof e},ToInt32:function(e){return 0|e},ToUint32:function(e){return e>>>0}}),f=Math.LN2,u=Math.abs,l=Math.floor,d=Math.log,c=Math.min,m=Math.pow,h=Math.round;function b(e){if(p&&o){var t,n=p(e);for(t=0;t<n.length;t+=1)o(e,n[t],{value:e[n[t]],writable:!1,enumerable:!1,configurable:!1})}}o=Object.defineProperty&&function(){try{return Object.defineProperty({},"x",{}),!0}catch(e){return!1}}()?Object.defineProperty:function(e,t,n){if(!e===Object(e))throw new TypeError("Object.defineProperty called on non-object");return a.HasProperty(n,"get")&&Object.prototype.__defineGetter__&&Object.prototype.__defineGetter__.call(e,t,n.get),a.HasProperty(n,"set")&&Object.prototype.__defineSetter__&&Object.prototype.__defineSetter__.call(e,t,n.set),a.HasProperty(n,"value")&&(e[t]=n.value),e};var p=Object.getOwnPropertyNames||function(e){if(e!==Object(e))throw new TypeError("Object.getOwnPropertyNames called on non-object");var t,n=[];for(t in e)a.HasOwnProperty(e,t)&&n.push(t);return n};function k(e,t){var n=32-t;return e<<n>>n}function x(e,t){var n=32-t;return e<<n>>>n}function j(e){return[255&e]}function w(e){return k(e[0],8)}function g(e){return[255&e]}function y(e){return x(e[0],8)}function _(e){return[(e=h(Number(e)))<0?0:e>255?255:255&e]}function v(e){return[e>>8&255,255&e]}function T(e){return k(e[0]<<8|e[1],16)}function S(e){return[e>>8&255,255&e]}function E(e){return x(e[0]<<8|e[1],16)}function O(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}function A(e){return k(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)}function C(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}function P(e){return x(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)}function I(e,t,n){var r,s,o,i,a,h,b,p=(1<<t-1)-1;function k(e){var t=l(e),n=e-t;return n<.5?t:n>.5||t%2?t+1:t}for(e!=e?(s=(1<<t)-1,o=m(2,n-1),r=0):e===Infinity||e===-Infinity?(s=(1<<t)-1,o=0,r=e<0?1:0):0===e?(s=0,o=0,r=1/e===-Infinity?1:0):(r=e<0,(e=u(e))>=m(2,1-p)?(s=c(l(d(e)/f),1023),(o=k(e/m(2,s)*m(2,n)))/m(2,n)>=2&&(s+=1,o=1),s>p?(s=(1<<t)-1,o=0):(s+=p,o-=m(2,n))):(s=0,o=k(e/m(2,1-p-n)))),a=[],i=n;i;i-=1)a.push(o%2?1:0),o=l(o/2);for(i=t;i;i-=1)a.push(s%2?1:0),s=l(s/2);for(a.push(r?1:0),a.reverse(),h=a.join(""),b=[];h.length;)b.push(parseInt(h.substring(0,8),2)),h=h.substring(8);return b}function M(e,t,n){var r,s,o,i,a,f,u,l,d=[];for(r=e.length;r;r-=1)for(o=e[r-1],s=8;s;s-=1)d.push(o%2?1:0),o>>=1;return d.reverse(),i=d.join(""),a=(1<<t-1)-1,f=parseInt(i.substring(0,1),2)?-1:1,u=parseInt(i.substring(1,1+t),2),l=parseInt(i.substring(1+t),2),u===(1<<t)-1?0!==l?NaN:f*Infinity:u>0?f*m(2,u-a)*(1+l/m(2,n)):0!==l?f*m(2,-(a-1))*(l/m(2,n)):f<0?-0:0}function R(e){return M(e,11,52)}function L(e){return I(e,11,52)}function B(e){return M(e,8,23)}function F(e){return I(e,8,23)}!function(){var e=function(e){if((e=a.ToInt32(e))<0)throw new RangeError("ArrayBuffer size is not a small enough positive integer");var t;for(this.byteLength=e,this._bytes=[],this._bytes.length=e,t=0;t<this.byteLength;t+=1)this._bytes[t]=0;b(this)};n.ArrayBuffer=n.ArrayBuffer||e;var t=function(){};function r(n,r,s){var f;return f=function(t,n,r){var s,i,u,l;if(arguments.length&&"number"!=typeof arguments[0])if("object"==typeof arguments[0]&&arguments[0].constructor===f)for(s=arguments[0],this.length=s.length,this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new e(this.byteLength),this.byteOffset=0,u=0;u<this.length;u+=1)this._setter(u,s._getter(u));else if("object"!=typeof arguments[0]||(arguments[0]instanceof e||"ArrayBuffer"===a.Class(arguments[0]))){if("object"!=typeof arguments[0]||!(arguments[0]instanceof e||"ArrayBuffer"===a.Class(arguments[0])))throw new TypeError("Unexpected argument type(s)");if(this.buffer=t,this.byteOffset=a.ToUint32(n),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteOffset%this.BYTES_PER_ELEMENT)throw new RangeError("ArrayBuffer length minus the byteOffset is not a multiple of the element size.");if(arguments.length<3){if(this.byteLength=this.buffer.byteLength-this.byteOffset,this.byteLength%this.BYTES_PER_ELEMENT)throw new RangeError("length of buffer minus byteOffset not a multiple of the element size");this.length=this.byteLength/this.BYTES_PER_ELEMENT}else this.length=a.ToUint32(r),this.byteLength=this.length*this.BYTES_PER_ELEMENT;if(this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer")}else for(i=arguments[0],this.length=a.ToUint32(i.length),this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new e(this.byteLength),this.byteOffset=0,u=0;u<this.length;u+=1)l=i[u],this._setter(u,Number(l));else{if(this.length=a.ToInt32(arguments[0]),r<0)throw new RangeError("ArrayBufferView size is not a small enough positive integer");this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new e(this.byteLength),this.byteOffset=0}this.constructor=f,b(this),function(e){if(o){if(e.length>1e5)throw new RangeError("Array too large for polyfill");var t;for(t=0;t<e.length;t+=1)n(t)}function n(t){o(e,t,{get:function(){return e._getter(t)},set:function(n){e._setter(t,n)},enumerable:!0,configurable:!1})}}(this)},f.prototype=new t,f.prototype.BYTES_PER_ELEMENT=n,f.prototype._pack=r,f.prototype._unpack=s,f.BYTES_PER_ELEMENT=n,f.prototype._getter=function(e){if(arguments.length<1)throw new SyntaxError("Not enough arguments");if((e=a.ToUint32(e))>=this.length)return i;var t,n,r=[];for(t=0,n=this.byteOffset+e*this.BYTES_PER_ELEMENT;t<this.BYTES_PER_ELEMENT;t+=1,n+=1)r.push(this.buffer._bytes[n]);return this._unpack(r)},f.prototype.get=f.prototype._getter,f.prototype._setter=function(e,t){if(arguments.length<2)throw new SyntaxError("Not enough arguments");if((e=a.ToUint32(e))>=this.length)return i;var n,r,s=this._pack(t);for(n=0,r=this.byteOffset+e*this.BYTES_PER_ELEMENT;n<this.BYTES_PER_ELEMENT;n+=1,r+=1)this.buffer._bytes[r]=s[n]},f.prototype.set=function(e,t){if(arguments.length<1)throw new SyntaxError("Not enough arguments");var n,r,s,o,i,f,u,l,d,c;if("object"==typeof arguments[0]&&arguments[0].constructor===this.constructor){if(n=arguments[0],(s=a.ToUint32(arguments[1]))+n.length>this.length)throw new RangeError("Offset plus length of array is out of range");if(l=this.byteOffset+s*this.BYTES_PER_ELEMENT,d=n.length*this.BYTES_PER_ELEMENT,n.buffer===this.buffer){for(c=[],i=0,f=n.byteOffset;i<d;i+=1,f+=1)c[i]=n.buffer._bytes[f];for(i=0,u=l;i<d;i+=1,u+=1)this.buffer._bytes[u]=c[i]}else for(i=0,f=n.byteOffset,u=l;i<d;i+=1,f+=1,u+=1)this.buffer._bytes[u]=n.buffer._bytes[f]}else{if("object"!=typeof arguments[0]||void 0===arguments[0].length)throw new TypeError("Unexpected argument type(s)");if(r=arguments[0],o=a.ToUint32(r.length),(s=a.ToUint32(arguments[1]))+o>this.length)throw new RangeError("Offset plus length of array is out of range");for(i=0;i<o;i+=1)f=r[i],this._setter(s+i,Number(f))}},f.prototype.subarray=function(e,t){function n(e,t,n){return e<t?t:e>n?n:e}e=a.ToInt32(e),t=a.ToInt32(t),arguments.length<1&&(e=0),arguments.length<2&&(t=this.length),e<0&&(e=this.length+e),t<0&&(t=this.length+t),e=n(e,0,this.length);var r=(t=n(t,0,this.length))-e;return r<0&&(r=0),new this.constructor(this.buffer,this.byteOffset+e*this.BYTES_PER_ELEMENT,r)},f}var s=r(1,j,w),f=r(1,g,y),u=r(1,_,y),l=r(2,v,T),d=r(2,S,E),c=r(4,O,A),m=r(4,C,P),h=r(4,F,B),p=r(8,L,R);n.Int8Array=n.Int8Array||s,n.Uint8Array=n.Uint8Array||f,n.Uint8ClampedArray=n.Uint8ClampedArray||u,n.Int16Array=n.Int16Array||l,n.Uint16Array=n.Uint16Array||d,n.Int32Array=n.Int32Array||c,n.Uint32Array=n.Uint32Array||m,n.Float32Array=n.Float32Array||h,n.Float64Array=n.Float64Array||p}(),function(){function e(e,t){return a.IsCallable(e.get)?e.get(t):e[t]}var t,r=(t=new n.Uint16Array([4660]),18===e(new n.Uint8Array(t.buffer),0)),s=function(e,t,r){if(0===arguments.length)e=new n.ArrayBuffer(0);else if(!(e instanceof n.ArrayBuffer||"ArrayBuffer"===a.Class(e)))throw new TypeError("TypeError");if(this.buffer=e||new n.ArrayBuffer(0),this.byteOffset=a.ToUint32(t),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteLength=arguments.length<3?this.buffer.byteLength-this.byteOffset:a.ToUint32(r),this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer");b(this)};function o(t){return function(s,o){if((s=a.ToUint32(s))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");s+=this.byteOffset;var i,f=new n.Uint8Array(this.buffer,s,t.BYTES_PER_ELEMENT),u=[];for(i=0;i<t.BYTES_PER_ELEMENT;i+=1)u.push(e(f,i));return Boolean(o)===Boolean(r)&&u.reverse(),e(new t(new n.Uint8Array(u).buffer),0)}}function i(t){return function(s,o,i){if((s=a.ToUint32(s))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");var f,u=new t([o]),l=new n.Uint8Array(u.buffer),d=[];for(f=0;f<t.BYTES_PER_ELEMENT;f+=1)d.push(e(l,f));Boolean(i)===Boolean(r)&&d.reverse(),new n.Uint8Array(this.buffer,s,t.BYTES_PER_ELEMENT).set(d)}}s.prototype.getUint8=o(n.Uint8Array),s.prototype.getInt8=o(n.Int8Array),s.prototype.getUint16=o(n.Uint16Array),s.prototype.getInt16=o(n.Int16Array),s.prototype.getUint32=o(n.Uint32Array),s.prototype.getInt32=o(n.Int32Array),s.prototype.getFloat32=o(n.Float32Array),s.prototype.getFloat64=o(n.Float64Array),s.prototype.setUint8=i(n.Uint8Array),s.prototype.setInt8=i(n.Int8Array),s.prototype.setUint16=i(n.Uint16Array),s.prototype.setInt16=i(n.Int16Array),s.prototype.setUint32=i(n.Uint32Array),s.prototype.setInt32=i(n.Int32Array),s.prototype.setFloat32=i(n.Float32Array),s.prototype.setFloat64=i(n.Float64Array),n.DataView=n.DataView||s}()}}},{package:"browserify>concat-stream>typedarray",file:"node_modules/typedarray/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/decode.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function e(t,n){var o,i=0,a=0,f=n=n||0,u=t.length;do{if(f>=u||a>49)throw e.bytes=0,new RangeError("Could not decode varint");o=t[f++],i+=a<28?(o&s)<<a:(o&s)*Math.pow(2,a),a+=7}while(o>=r);return e.bytes=f-n,i};var r=128,s=127}}},{package:"sass-embedded>varint",file:"node_modules/varint/decode.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/encode.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function e(t,n,i){if(Number.MAX_SAFE_INTEGER&&t>Number.MAX_SAFE_INTEGER)throw e.bytes=0,new RangeError("Could not encode varint");n=n||[];var a=i=i||0;for(;t>=o;)n[i++]=255&t|r,t/=128;for(;t&s;)n[i++]=255&t|r,t>>>=7;return n[i]=0|t,e.bytes=i-a+1,n};var r=128,s=-128,o=Math.pow(2,31)}}},{package:"sass-embedded>varint",file:"node_modules/varint/encode.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/index.js",{"./decode.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/decode.js","./encode.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/encode.js","./length.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/length.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={encode:e("./encode.js"),decode:e("./decode.js"),encodingLength:e("./length.js")}}}},{package:"sass-embedded>varint",file:"node_modules/varint/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/varint/length.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=Math.pow(2,7),s=Math.pow(2,14),o=Math.pow(2,21),i=Math.pow(2,28),a=Math.pow(2,35),f=Math.pow(2,42),u=Math.pow(2,49),l=Math.pow(2,56),d=Math.pow(2,63);t.exports=function(e){return e<r?1:e<s?2:e<o?3:e<i?4:e<a?5:e<f?6:e<u?7:e<l?8:e<d?9:10}}}},{package:"sass-embedded>varint",file:"node_modules/varint/length.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/web-encoding/src/lib.js",{util:"/home/runner/work/metamask-extension/metamask-extension/node_modules/util/util.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){n.TextEncoder="undefined"!=typeof TextEncoder?TextEncoder:e("util").TextEncoder,n.TextDecoder="undefined"!=typeof TextDecoder?TextDecoder:e("util").TextDecoder}}},{package:"@ensdomains/content-hash>multihashes>web-encoding",file:"node_modules/web-encoding/src/lib.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/whatwg-fetch/dist/fetch.umd.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){!function(e,r){"object"==typeof n&&void 0!==t?r(n):"function"==typeof define&&define.amd?define(["exports"],r):r(e.WHATWGFetch={})}(this,function(e){var t="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof self&&self||"undefined"!=typeof global&&global||{},n="URLSearchParams"in t,r="Symbol"in t&&"iterator"in Symbol,s="FileReader"in t&&"Blob"in t&&function(){try{return new Blob,!0}catch(e){return!1}}(),o="FormData"in t,i="ArrayBuffer"in t;if(i)var a=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],f=ArrayBuffer.isView||function(e){return e&&a.indexOf(Object.prototype.toString.call(e))>-1};function u(e){if("string"!=typeof e&&(e=String(e)),/[^a-z0-9\-#$%&'*+.^_`|~!]/i.test(e)||""===e)throw new TypeError('Invalid character in header field name: "'+e+'"');return e.toLowerCase()}function l(e){return"string"!=typeof e&&(e=String(e)),e}function d(e){var t={next:function(){var t=e.shift();return{done:t===undefined,value:t}}};return r&&(t[Symbol.iterator]=function(){return t}),t}function c(e){this.map={},e instanceof c?e.forEach(function(e,t){this.append(t,e)},this):Array.isArray(e)?e.forEach(function(e){if(2!=e.length)throw new TypeError("Headers constructor: expected name/value pair to be length 2, found"+e.length);this.append(e[0],e[1])},this):e&&Object.getOwnPropertyNames(e).forEach(function(t){this.append(t,e[t])},this)}function m(e){if(!e._noBody)return e.bodyUsed?Promise.reject(new TypeError("Already read")):void(e.bodyUsed=!0)}function h(e){return new Promise(function(t,n){e.onload=function(){t(e.result)},e.onerror=function(){n(e.error)}})}function b(e){var t=new FileReader,n=h(t);return t.readAsArrayBuffer(e),n}function p(e){if(e.slice)return e.slice(0);var t=new Uint8Array(e.byteLength);return t.set(new Uint8Array(e)),t.buffer}function k(){return this.bodyUsed=!1,this._initBody=function(e){var t;this.bodyUsed=this.bodyUsed,this._bodyInit=e,e?"string"==typeof e?this._bodyText=e:s&&Blob.prototype.isPrototypeOf(e)?this._bodyBlob=e:o&&FormData.prototype.isPrototypeOf(e)?this._bodyFormData=e:n&&URLSearchParams.prototype.isPrototypeOf(e)?this._bodyText=e.toString():i&&s&&((t=e)&&DataView.prototype.isPrototypeOf(t))?(this._bodyArrayBuffer=p(e.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):i&&(ArrayBuffer.prototype.isPrototypeOf(e)||f(e))?this._bodyArrayBuffer=p(e):this._bodyText=e=Object.prototype.toString.call(e):(this._noBody=!0,this._bodyText=""),this.headers.get("content-type")||("string"==typeof e?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):n&&URLSearchParams.prototype.isPrototypeOf(e)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},s&&(this.blob=function(){var e=m(this);if(e)return e;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))}),this.arrayBuffer=function(){if(this._bodyArrayBuffer){var e=m(this);return e||(ArrayBuffer.isView(this._bodyArrayBuffer)?Promise.resolve(this._bodyArrayBuffer.buffer.slice(this._bodyArrayBuffer.byteOffset,this._bodyArrayBuffer.byteOffset+this._bodyArrayBuffer.byteLength)):Promise.resolve(this._bodyArrayBuffer))}if(s)return this.blob().then(b);throw new Error("could not read as ArrayBuffer")},this.text=function(){var e,t,n,r,s,o=m(this);if(o)return o;if(this._bodyBlob)return e=this._bodyBlob,t=new FileReader,n=h(t),r=/charset=([A-Za-z0-9_-]+)/.exec(e.type),s=r?r[1]:"utf-8",t.readAsText(e,s),n;if(this._bodyArrayBuffer)return Promise.resolve(function(e){for(var t=new Uint8Array(e),n=new Array(t.length),r=0;r<t.length;r++)n[r]=String.fromCharCode(t[r]);return n.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},o&&(this.formData=function(){return this.text().then(w)}),this.json=function(){return this.text().then(JSON.parse)},this}c.prototype.append=function(e,t){e=u(e),t=l(t);var n=this.map[e];this.map[e]=n?n+", "+t:t},c.prototype.delete=function(e){delete this.map[u(e)]},c.prototype.get=function(e){return e=u(e),this.has(e)?this.map[e]:null},c.prototype.has=function(e){return this.map.hasOwnProperty(u(e))},c.prototype.set=function(e,t){this.map[u(e)]=l(t)},c.prototype.forEach=function(e,t){for(var n in this.map)this.map.hasOwnProperty(n)&&e.call(t,this.map[n],n,this)},c.prototype.keys=function(){var e=[];return this.forEach(function(t,n){e.push(n)}),d(e)},c.prototype.values=function(){var e=[];return this.forEach(function(t){e.push(t)}),d(e)},c.prototype.entries=function(){var e=[];return this.forEach(function(t,n){e.push([n,t])}),d(e)},r&&(c.prototype[Symbol.iterator]=c.prototype.entries);var x=["CONNECT","DELETE","GET","HEAD","OPTIONS","PATCH","POST","PUT","TRACE"];function j(e,n){if(!(this instanceof j))throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');var r,s,o=(n=n||{}).body;if(e instanceof j){if(e.bodyUsed)throw new TypeError("Already read");this.url=e.url,this.credentials=e.credentials,n.headers||(this.headers=new c(e.headers)),this.method=e.method,this.mode=e.mode,this.signal=e.signal,o||null==e._bodyInit||(o=e._bodyInit,e.bodyUsed=!0)}else this.url=String(e);if(this.credentials=n.credentials||this.credentials||"same-origin",!n.headers&&this.headers||(this.headers=new c(n.headers)),this.method=(r=n.method||this.method||"GET",s=r.toUpperCase(),x.indexOf(s)>-1?s:r),this.mode=n.mode||this.mode||null,this.signal=n.signal||this.signal||function(){if("AbortController"in t)return(new AbortController).signal}(),this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&o)throw new TypeError("Body not allowed for GET or HEAD requests");if(this._initBody(o),!("GET"!==this.method&&"HEAD"!==this.method||"no-store"!==n.cache&&"no-cache"!==n.cache)){var i=/([?&])_=[^&]*/;if(i.test(this.url))this.url=this.url.replace(i,"$1_="+(new Date).getTime());else{this.url+=(/\?/.test(this.url)?"&":"?")+"_="+(new Date).getTime()}}}function w(e){var t=new FormData;return e.trim().split("&").forEach(function(e){if(e){var n=e.split("="),r=n.shift().replace(/\+/g," "),s=n.join("=").replace(/\+/g," ");t.append(decodeURIComponent(r),decodeURIComponent(s))}}),t}function g(e,t){if(!(this instanceof g))throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');if(t||(t={}),this.type="default",this.status=t.status===undefined?200:t.status,this.status<200||this.status>599)throw new RangeError("Failed to construct 'Response': The status provided (0) is outside the range [200, 599].");this.ok=this.status>=200&&this.status<300,this.statusText=t.statusText===undefined?"":""+t.statusText,this.headers=new c(t.headers),this.url=t.url||"",this._initBody(e)}j.prototype.clone=function(){return new j(this,{body:this._bodyInit})},k.call(j.prototype),k.call(g.prototype),g.prototype.clone=function(){return new g(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new c(this.headers),url:this.url})},g.error=function(){var e=new g(null,{status:200,statusText:""});return e.ok=!1,e.status=0,e.type="error",e};var y=[301,302,303,307,308];g.redirect=function(e,t){if(-1===y.indexOf(t))throw new RangeError("Invalid status code");return new g(null,{status:t,headers:{location:e}})},e.DOMException=t.DOMException;try{new e.DOMException}catch(t){e.DOMException=function(e,t){this.message=e,this.name=t;var n=Error(e);this.stack=n.stack},e.DOMException.prototype=Object.create(Error.prototype),e.DOMException.prototype.constructor=e.DOMException}function _(n,r){return new Promise(function(o,a){var f=new j(n,r);if(f.signal&&f.signal.aborted)return a(new e.DOMException("Aborted","AbortError"));var d=new XMLHttpRequest;function m(){d.abort()}if(d.onload=function(){var e,t,n={statusText:d.statusText,headers:(e=d.getAllResponseHeaders()||"",t=new c,e.replace(/\r?\n[\t ]+/g," ").split("\r").map(function(e){return 0===e.indexOf("\n")?e.substr(1,e.length):e}).forEach(function(e){var n=e.split(":"),r=n.shift().trim();if(r){var s=n.join(":").trim();try{t.append(r,s)}catch(e){console.warn("Response "+e.message)}}}),t)};0===f.url.indexOf("file://")&&(d.status<200||d.status>599)?n.status=200:n.status=d.status,n.url="responseURL"in d?d.responseURL:n.headers.get("X-Request-URL");var r="response"in d?d.response:d.responseText;setTimeout(function(){o(new g(r,n))},0)},d.onerror=function(){setTimeout(function(){a(new TypeError("Network request failed"))},0)},d.ontimeout=function(){setTimeout(function(){a(new TypeError("Network request timed out"))},0)},d.onabort=function(){setTimeout(function(){a(new e.DOMException("Aborted","AbortError"))},0)},d.open(f.method,function(e){try{return""===e&&t.location.href?t.location.href:e}catch(t){return e}}(f.url),!0),"include"===f.credentials?d.withCredentials=!0:"omit"===f.credentials&&(d.withCredentials=!1),"responseType"in d&&(s?d.responseType="blob":i&&(d.responseType="arraybuffer")),r&&"object"==typeof r.headers&&!(r.headers instanceof c||t.Headers&&r.headers instanceof t.Headers)){var h=[];Object.getOwnPropertyNames(r.headers).forEach(function(e){h.push(u(e)),d.setRequestHeader(e,l(r.headers[e]))}),f.headers.forEach(function(e,t){-1===h.indexOf(t)&&d.setRequestHeader(t,e)})}else f.headers.forEach(function(e,t){d.setRequestHeader(t,e)});f.signal&&(f.signal.addEventListener("abort",m),d.onreadystatechange=function(){4===d.readyState&&f.signal.removeEventListener("abort",m)}),d.send(void 0===f._bodyInit?null:f._bodyInit)})}_.polyfill=!0,t.fetch||(t.fetch=_,t.Headers=c,t.Request=j,t.Response=g),e.Headers=c,e.Request=j,e.Response=g,e.fetch=_,Object.defineProperty(e,"__esModule",{value:!0})})}}},{package:"@open-rpc/test-coverage>isomorphic-fetch>whatwg-fetch",file:"node_modules/whatwg-fetch/dist/fetch.umd.js"}],["/home/runner/work/metamask-extension/metamask-extension/shared/constants/alarms.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.METAMETRICS_FINALIZE_EVENT_FRAGMENT_ALARM=n.AUTO_LOCK_TIMEOUT_ALARM=void 0;n.AUTO_LOCK_TIMEOUT_ALARM="AUTO_LOCK_TIMEOUT_ALARM",n.METAMETRICS_FINALIZE_EVENT_FRAGMENT_ALARM="METAMETRICS_FINALIZE_EVENT_FRAGMENT_ALARM"}}},{package:"$root$",file:"shared/constants/alarms.js"}],["/home/runner/work/metamask-extension/metamask-extension/shared/constants/eth-methods.ts",{"@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ETH_EOA_METHODS=n.ETH_4337_METHODS=void 0;var r=e("@metamask/keyring-api");n.ETH_EOA_METHODS=[r.EthMethod.PersonalSign,r.EthMethod.SignTransaction,r.EthMethod.SignTypedDataV1,r.EthMethod.SignTypedDataV3,r.EthMethod.SignTypedDataV4],n.ETH_4337_METHODS=[r.EthMethod.PrepareUserOperation,r.EthMethod.PatchUserOperation,r.EthMethod.SignUserOperation]}}},{package:"$root$",file:"shared/constants/eth-methods.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/constants/logs.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.LOG_EVENT=void 0;n.LOG_EVENT={VERSION_UPDATE:"Extension version update"}}}},{package:"$root$",file:"shared/constants/logs.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/constants/messages.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.EXTENSION_MESSAGES=void 0;n.EXTENSION_MESSAGES={READY:"METAMASK_EXTENSION_READY"}}}},{package:"$root$",file:"shared/constants/messages.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/constants/price-api-currencies.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PRICE_API_CURRENCIES=void 0;n.PRICE_API_CURRENCIES=["aud","hkd","sgd","idr","inr","nzd","php","btc","cad","eur","gbp","jpy","ltc","rub","uah","usd","xlm","xrp","sek","aed","ars","bch","bnb","brl","clp","cny","czk","dkk","chf","dot","eos","eth","gel","huf","ils","krw","mxn","myr","ngn","nok","pln","thb","try","zar"]}}},{package:"$root$",file:"shared/constants/price-api-currencies.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/constants/referrals.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.METAMASK_REFERRAL_CODE=n.HYPERLIQUID_ORIGIN=void 0;n.HYPERLIQUID_ORIGIN="https://app.hyperliquid.xyz",n.METAMASK_REFERRAL_CODE="MMREFCSI"}}},{package:"$root$",file:"shared/constants/referrals.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/caveat.ts",{"@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/index.js","@metamask/delegation-core":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/delegation-core/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereumjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereumjs-util/dist.browser/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.getCaveatArrayPacketHash=n.createCaveat=void 0;var r=e("@metamask/abi-utils"),s=e("ethereumjs-util"),o=e("@metamask/delegation-core");const i=e=>{const n=(0,r.encode)(["bytes32","address","bytes32"],[o.CAVEAT_TYPEHASH,e.enforcer,(0,s.keccak)((0,s.toBuffer)(e.terms))]);return(0,s.keccak)(t.from(n))};n.getCaveatArrayPacketHash=e=>{let n=t.from([]);for(const s of e){const e=i(s);n=t.from((0,r.encode)(["bytes","bytes32"],[n,e],!0))}return(0,s.keccak)(n)};n.createCaveat=(e,t,n="0x")=>({enforcer:e,terms:t,args:n})}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"$root$",file:"shared/lib/delegation/caveat.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/environment.ts",{"@metamask/delegation-deployments":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/delegation-deployments/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PREFERRED_VERSION=void 0,n.getDeleGatorEnvironment=function(e,t=s){var n;const o=null===(n=r.DELEGATOR_CONTRACTS[t])||void 0===n?void 0:n[e];if(!o)throw new Error(`No contracts found for version ${t} chain ${e}`);return{EIP7702StatelessDeleGatorImpl:o.EIP7702StatelessDeleGatorImpl,DelegationManager:o.DelegationManager,EntryPoint:o.EntryPoint,SimpleFactory:o.SimpleFactory,implementations:{MultiSigDeleGatorImpl:o.MultiSigDeleGatorImpl,HybridDeleGatorImpl:o.HybridDeleGatorImpl},caveatEnforcers:{AllowedCalldataEnforcer:o.AllowedCalldataEnforcer,AllowedMethodsEnforcer:o.AllowedMethodsEnforcer,AllowedTargetsEnforcer:o.AllowedTargetsEnforcer,ArgsEqualityCheckEnforcer:o.ArgsEqualityCheckEnforcer,BlockNumberEnforcer:o.BlockNumberEnforcer,DeployedEnforcer:o.DeployedEnforcer,ERC20BalanceChangeEnforcer:o.ERC20BalanceChangeEnforcer,ERC20BalanceGteEnforcer:o.ERC20BalanceGteEnforcer,ERC20TransferAmountEnforcer:o.ERC20TransferAmountEnforcer,ERC20StreamingEnforcer:o.ERC20StreamingEnforcer,ERC721BalanceChangeEnforcer:o.ERC721BalanceChangeEnforcer,ERC721BalanceGteEnforcer:o.ERC721BalanceGteEnforcer,ERC721TransferEnforcer:o.ERC721TransferEnforcer,ERC1155BalanceChangeEnforcer:o.ERC1155BalanceChangeEnforcer,ERC1155BalanceGteEnforcer:o.ERC1155BalanceGteEnforcer,IdEnforcer:o.IdEnforcer,LimitedCallsEnforcer:o.LimitedCallsEnforcer,NonceEnforcer:o.NonceEnforcer,TimestampEnforcer:o.TimestampEnforcer,ValueLteEnforcer:o.ValueLteEnforcer,MultiTokenPeriodEnforcer:o.MultiTokenPeriodEnforcer,NativeTokenTransferAmountEnforcer:o.NativeTokenTransferAmountEnforcer,NativeBalanceChangeEnforcer:o.NativeBalanceChangeEnforcer,NativeBalanceGteEnforcer:o.NativeBalanceGteEnforcer,NativeTokenStreamingEnforcer:o.NativeTokenStreamingEnforcer,NativeTokenPaymentEnforcer:o.NativeTokenPaymentEnforcer,OwnershipTransferEnforcer:o.OwnershipTransferEnforcer,RedeemerEnforcer:o.RedeemerEnforcer,SpecificActionERC20TransferBatchEnforcer:"0x6649b61c873F6F9686A1E1ae9ee98aC380c7bA13",ERC20PeriodTransferEnforcer:o.ERC20PeriodTransferEnforcer,NativeTokenPeriodTransferEnforcer:o.NativeTokenPeriodTransferEnforcer,ExactCalldataBatchEnforcer:o.ExactCalldataBatchEnforcer,ExactCalldataEnforcer:o.ExactCalldataEnforcer,ExactExecutionEnforcer:o.ExactExecutionEnforcer,ExactExecutionBatchEnforcer:o.ExactExecutionBatchEnforcer}}};var r=e("@metamask/delegation-deployments");const s=n.PREFERRED_VERSION="1.3.0"}}},{package:"$root$",file:"shared/lib/delegation/environment.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/index.ts",{"./caveat":"/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/caveat.ts","./caveatBuilder":"/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/caveatBuilder/index.ts","./delegation":"/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/delegation.ts","./environment":"/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/environment.ts","./execution":"/home/runner/work/metamask-extension/metamask-extension/shared/lib/delegation/execution.ts"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"ANY_BENEFICIARY",{enumerable:!0,get:function(){return s.ANY_BENEFICIARY}}),Object.defineProperty(n,"BATCH_DEFAULT_MODE",{enumerable:!0,get:function(){return o.BATCH_DEFAULT_MODE}}),Object.defineProperty(n,"BATCH_TRY_MODE",{enumerable:!0,get:function(){return o.BATCH_TRY_MODE}}),Object.defineProperty(n,"ROOT_AUTHORITY",{enumerable:!0,get:function(){return s.ROOT_AUTHORITY}}),Object.defineProperty(n,"SINGLE_DEFAULT_MODE",{enumerable:!0,get:function(){return o.SINGLE_DEFAULT_MODE}}),Object.defineProperty(n,"SINGLE_TRY_MODE",{enumerable:!0,get:function(){return o.SINGLE_TRY_MODE}}),Object.defineProperty(n,"createCaveat",{enumerable:!0,get:function(){return i.createCaveat}}),Object.defineProperty(n,"createCaveatBuilder",{enumerable:!0,get:function(){return a.createCaveatBuilder}}),Object.defineProperty(n,"createDelegation",{enumerable:!0,get:function(){return s.createDelegation}}),Object.defineProperty(n,"createExecution",{enumerable:!0,get:function(){return o.createExecution}}),Object.defineProperty(n,"createOpenDelegation",{enumerable:!0,get:function(){return s.createOpenDelegation}}),Object.defineProperty(n,"encodeBatchExecution",{enumerable:!0,get:function(){return o.encodeBatchExecution}}),Object.defineProperty(n,"encodeDelegation",{enumerable:!0,get:function(){return s.encodeDelegation}}),Object.defineProperty(n,"encodeExecutionCalldata",{enumerable:!0,get:function(){return o.encodeExecutionCalldata}}),Object.defineProperty(n,"encodeExecutionCalldatas",{enumerable:!0,get:function(){return o.encodeExecutionCalldatas}}),Object.defineProperty(n,"encodePermissionContexts",{enumerable:!0,get:function(){return s.encodePermissionContexts}}),Object.defineProperty(n,"encodeSingleExecution",{enumerable:!0,get:function(){return o.encodeSingleExecution}}),Object.defineProperty(n,"getDeleGatorEnvironment",{enumerable:!0,get:function(){return r.getDeleGatorEnvironment}}),Object.defineProperty(n,"getDelegationHashOffchain",{enumerable:!0,get:function(){return s.getDelegationHashOffchain}}),Object.defineProperty(n,"toDelegationStruct",{enumerable:!0,get:function(){return s.toDelegationStruct}});var r=e("./environment"),s=e("./delegation"),o=e("./execution"),i=e("./caveat"),a=e("./caveatBuilder")}}},{package:"$root$",file:"shared/lib/delegation/index.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/lib/eip7702-support-utils.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.checkEip7702Support=function(e){const t=Boolean(e&&(!e.delegationAddress||e.isSupported));return{isSupported:t,upgradeContractAddress:t?(null==e?void 0:e.upgradeContractAddress)??null:null,delegationAddress:t?(null==e?void 0:e.delegationAddress)??null:null}},n.findAtomicBatchSupportForChain=function(e,t){return e.find(e=>e.chainId.toLowerCase()===t.toLowerCase())}}}},{package:"$root$",file:"shared/lib/eip7702-support-utils.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/lib/token-util.ts",{"@ethersproject/contracts":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/contracts/lib/index.js","@ethersproject/providers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/providers/lib/index.js","@metamask/metamask-eth-abis":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/metamask-eth-abis/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.fetchERC1155Balance=async function(e,t,n,i){if(!t||!n)return null;const a=new o.Web3Provider(i),f=new s.Contract(e,r.abiERC1155,a),u=f?f.balanceOf(t,n):Promise.resolve();return await u},n.fetchTokenBalance=async function(e,t,n){const i=new o.Web3Provider(n),a=new s.Contract(e,r.abiERC20,i),f=a?a.balanceOf(t):Promise.resolve();return await f},n.getTokenIdParam=function(e={}){var t,n;return(null==e||null===(t=e.args)||void 0===t||null===(t=t._tokenId)||void 0===t?void 0:t.toString())??(null==e||null===(n=e.args)||void 0===n||null===(n=n.id)||void 0===n?void 0:n.toString())};var r=e("@metamask/metamask-eth-abis"),s=e("@ethersproject/contracts"),o=e("@ethersproject/providers")}}},{package:"$root$",file:"shared/lib/token-util.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/lib/wallet-funds-obtained-metric.ts",{"../constants/metametrics":"/home/runner/work/metamask-extension/metamask-extension/shared/constants/metametrics.ts","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.hasNonZeroTokenBalance=n.hasNonZeroMultichainBalance=n.getWalletFundsObtainedEventProperties=n.getMidnightISOTimestamp=n.getAmountBucket=n.AmountBucket=void 0;var r=e("@metamask/utils"),s=e("../constants/metametrics");const o=n.AmountBucket={Low:"<$100",Medium:"$100-1000",High:">$1000"},i=e=>{const t=Number(e);return t<100?o.Low:t<=1e3?o.Medium:o.High};n.getAmountBucket=i;const a=()=>{const e=new Date;return e.setHours(0,0,0,0),e.toISOString()};n.getMidnightISOTimestamp=a;n.hasNonZeroTokenBalance=(e={})=>{for(const t of Object.values(e))for(const e of Object.values(t||{}))for(const t of Object.values(e||{}))if((0,r.hexToNumber)(t||"0x0")>0)return!0;return!1};n.hasNonZeroMultichainBalance=(e={})=>{for(const t of Object.values(e))for(const e of Object.values(t||{}))if(null!=e&&e.amount&&"0"!==e.amount)return!0;return!1};n.getWalletFundsObtainedEventProperties=({chainId:e,amountUsd:t})=>({event:s.MetaMetricsEventName.WalletFundsObtained,timestamp:a(),properties:{chain_id_caip:(0,r.toCaipChainId)(r.KnownCaipNamespace.Eip155,e.toString()),funding_amount_usd:i(t)}})}}},{package:"$root$",file:"shared/lib/wallet-funds-obtained-metric.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/modules/caip-stream.ts",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/lib/ours/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createCaipStream=n.CaipStream=void 0;var r=e("@metamask/utils"),s=e("readable-stream");function o(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}class i extends s.Duplex{constructor(e){super({objectMode:!0}),o(this,"parent",void 0),this.parent=e}_read(){return undefined}_write(e,t,n){this.parent.push({type:"caip-348",data:e}),n()}}class a extends s.Duplex{constructor(){super({objectMode:!0}),o(this,"substream",void 0),this.substream=new i(this)}_read(){return undefined}_write(e,t,n){(0,r.isObject)(e)&&"caip-348"===e.type&&this.substream.push(e.data),n()}}n.CaipStream=a;n.createCaipStream=e=>{var t,n;const r=new a,o=()=>{r.substream.destroyed||r.substream.writableEnded||r.substream.end()};return null===(t=e.once)||void 0===t||t.call(e,"close",o),null===(n=e.once)||void 0===n||n.call(e,"end",o),(0,s.pipeline)(e,r,e,e=>{r.substream.destroy(),e&&"Premature close"!==e.message&&console.error("MetaMask CAIP stream error:",e)}),r.substream}}}},{package:"$root$",file:"shared/modules/caip-stream.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/modules/metametrics.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getSmartTransactionMetricsProperties=void 0;n.getSmartTransactionMetricsProperties=(e,t)=>{var n;const r=e.getIsSmartTransaction(t.chainId),s={is_smart_transaction:r};if(!r)return s;s.gas_included=null===(n=t.swapMetaData)||void 0===n?void 0:n.gas_included;const o=e.getSmartTransactionByMinedTxHash(t.hash),i=null==o?void 0:o.statusMetadata;return i?(s.smart_transaction_timed_out=i.timedOut,s.smart_transaction_proxied=i.proxied,s):s}}}},{package:"$root$",file:"shared/modules/metametrics.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/modules/typed-signature.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.sanitizeMessageRecursively=function e(t,n,r){const s={},o=n[r];if(!o)return t;for(const r of o){const{name:o,type:i}=r;t[o]!==undefined&&(n[i]?s[o]=e(t[o],n,i):s[o]=t[o])}return s}}}},{package:"$root$",file:"shared/modules/typed-signature.ts"}],["/home/runner/work/metamask-extension/metamask-extension/shared/notifications/index.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.UI_NOTIFICATIONS=void 0;n.UI_NOTIFICATIONS={}}}},{package:"$root$",file:"shared/notifications/index.ts"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/background-socket/socket-background-to-mocha.ts",{"../../../shared/modules/mv3.utils":"/home/runner/work/metamask-extension/metamask-extension/shared/modules/mv3.utils.js",loglevel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/loglevel/lib/loglevel.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getSocketBackgroundToMocha=function(){f||(f=new a);return f};var r,s=(r=e("loglevel"))&&r.__esModule?r:{default:r},o=e("../../../shared/modules/mv3.utils");function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}class a{constructor(){i(this,"client",void 0),this.client=new WebSocket("ws://localhost:8111"),this.client.onopen=()=>s.default.debug("SocketBackgroundToMocha WebSocket connection opened"),this.client.onmessage=e=>{let t;try{t=JSON.parse(e.data)}catch(e){throw new Error(`Error in JSON sent to SocketBackgroundToMocha: ${e.message}`)}this.receivedMessage(t)},this.client.onclose=()=>s.default.debug("SocketBackgroundToMocha WebSocket connection closed"),this.client.onerror=e=>s.default.error("SocketBackgroundToMocha WebSocket error:",e)}async waitUntilWindowWithProperty(e,t){let n=[];for(let r=0;r<=1e4;r+=200){n=await this.queryTabs({});if(-1!==n.findIndex(n=>n[e]===t))return void this.send({command:"openTabs",tabs:this.cleanTabs(n)});await new Promise(e=>setTimeout(e,200))}this.send({command:"notFound",property:e,value:t,tabs:this.cleanTabs(n)})}async queryTabs(e){return o.isManifestV3?await chrome.tabs.query(e):new Promise(t=>{chrome.tabs.query(e,e=>{t(e)})})}cleanTabs(e){return e.map(e=>(e.favIconUrl&&e.favIconUrl.length>40&&(e.favIconUrl=undefined),e))}send(e){this.client.send(JSON.stringify(e))}async receivedMessage(e){if(s.default.debug("SocketBackgroundToMocha received message:",e),"queryTabs"===e.command){const t=await this.queryTabs({title:e.title});s.default.debug("SocketBackgroundToMocha sending tabs:",t),this.send({command:"openTabs",tabs:this.cleanTabs(t)})}else"waitUntilWindowWithProperty"===e.command&&e.property&&e.value&&this.waitUntilWindowWithProperty(e.property,e.value)}}let f}}},{package:"$root$",file:"test/e2e/background-socket/socket-background-to-mocha.ts"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/constants.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.WINDOW_TITLES=n.WALLET_PASSWORD=n.VERIFYING_PAYMASTER=n.TEST_SNAPS_SIMPLE_KEYRING_WEBSITE_URL=n.TEST_SEED_PHRASE_TWO=n.TEST_SEED_PHRASE=n.SIMPLE_ACCOUNT_FACTORY=n.SATS_IN_1_BTC=n.PRIVATE_KEY_TWO=n.PRIVATE_KEY=n.PORTFOLIO_PAGE_TITLE=n.MOCK_REMOTE_FEATURE_FLAGS_RESPONSE=n.MOCK_META_METRICS_ID=n.MOCK_GROUPED_AUTH_CONNECTION_ID=n.MOCK_GOOGLE_ACCOUNT_WALLET_ADDRESS=n.MOCK_GOOGLE_ACCOUNT=n.MOCK_CUSTOMIZED_REMOTE_FEATURE_FLAGS=n.MOCK_AUTH_CONNECTION_ID=n.MOCK_APPLE_ACCOUNT=n.LOCAL_NODE_PRIVATE_KEY=n.LOCAL_NODE_ACCOUNT=n.ERC_4337_ACCOUNT_SNAP_URL=n.ERC_4337_ACCOUNT_SALT=n.ERC_4337_ACCOUNT=n.ENTRYPOINT=n.DEFAULT_SOL_CONVERSION_RATE=n.DEFAULT_SOLANA_BALANCE=n.DEFAULT_SOLANA_ACCOUNT=n.DEFAULT_LOCAL_NODE_USD_BALANCE=n.DEFAULT_LOCAL_NODE_ETH_BALANCE_DEC=n.DEFAULT_FIXTURE_ACCOUNT_SHORTENED=n.DEFAULT_FIXTURE_ACCOUNT_LOWERCASE=n.DEFAULT_FIXTURE_ACCOUNT=n.DEFAULT_BTC_TRANSACTION_ID=n.DEFAULT_BTC_FEE_RATE=n.DEFAULT_BTC_CONVERSION_RATE=n.DEFAULT_BTC_BALANCE=n.DEFAULT_BTC_ADDRESS=n.DEFAULT_BTC_ACCOUNT_NAME=n.DAPP_URL_LOCALHOST=n.DAPP_URL=n.DAPP_TWO_URL=n.DAPP_PATHS=n.DAPP_PATH=n.DAPP_ONE_URL=n.DAPP_ONE_ADDRESS=n.DAPP_HOST_ADDRESS=n.BUNDLER_URL=n.ACCOUNT_TYPE=n.ACCOUNT_2=n.ACCOUNT_1=void 0;n.LOCAL_NODE_ACCOUNT="0xe18035bf8712672935fdb4e5e431b1a0183d2dfc",n.LOCAL_NODE_PRIVATE_KEY="0x4cfd3e90fc78b0f86bf7524722150bb8da9c60cd532564d7ff43f5716514f553";const r=n.DEFAULT_FIXTURE_ACCOUNT="0x5CfE73b6021E818B776b421B1c4Db2474086a7e1",s=n.DEFAULT_FIXTURE_ACCOUNT_LOWERCASE=r.toLowerCase(),o=(n.DEFAULT_FIXTURE_ACCOUNT_SHORTENED="0x5CfE73b602...474086a7e1",n.ENTRYPOINT="0x18b06605539dc02ecD3f7AB314e38eB7c1dA5c9b",n.ERC_4337_ACCOUNT="0x8FCd29A7887f82463E0eA7332CB1ce431A4430F7",n.BUNDLER_URL="http://localhost:3000/rpc",n.ERC_4337_ACCOUNT_SNAP_URL="https://metamask.github.io/snap-account-abstraction-keyring/0.5.0/",n.ERC_4337_ACCOUNT_SALT="0x1",n.SIMPLE_ACCOUNT_FACTORY="0x4aFf835038b16dccDb1670103C4877A8F93E5219",n.TEST_SNAPS_SIMPLE_KEYRING_WEBSITE_URL="https://metamask.github.io/snap-simple-keyring/1.1.6/",n.VERIFYING_PAYMASTER="0xbdbDEc38ed168331b1F7004cc9e5392A2272C1D7",n.DEFAULT_LOCAL_NODE_ETH_BALANCE_DEC="25",n.DEFAULT_LOCAL_NODE_USD_BALANCE="85,000.00",n.DAPP_HOST_ADDRESS="127.0.0.1:8080"),i=n.DAPP_ONE_ADDRESS="127.0.0.1:8081",a=(n.DAPP_URL_LOCALHOST="http://localhost:8080",n.DAPP_URL=`http://${o}`,n.DAPP_ONE_URL=`http://${i}`,n.DAPP_TWO_URL="http://127.0.0.1:8082",["..","..","node_modules"]),f=(e,...t)=>[...a,"@metamask",e,...t];n.DAPP_PATHS=Object.freeze({"snap-simple-keyring-site":f("snap-simple-keyring-site","public"),"snap-account-abstraction-keyring":f("snap-account-abstraction-keyring-site","public"),"test-dapp":f("test-dapp","dist"),"test-dapp-multichain":f("test-dapp-multichain","build"),"test-dapp-solana":f("test-dapp-solana","dist"),"test-snaps":f("test-snaps","dist")}),n.DAPP_PATH=Object.freeze({TEST_DAPP:"test-dapp",TEST_DAPP_MULTICHAIN:"test-dapp-multichain",TEST_DAPP_SOLANA:"test-dapp-solana",TEST_SNAPS:"test-snaps",SNAP_SIMPLE_KEYRING_SITE:"snap-simple-keyring-site",SNAP_ACCOUNT_ABSTRACTION_KEYRING:"snap-account-abstraction-keyring"}),n.DEFAULT_BTC_ADDRESS="bc1qg6whd6pc0cguh6gpp3ewujm53hv32ta9hdp252",n.DEFAULT_BTC_ACCOUNT_NAME="Bitcoin Account 1",n.DEFAULT_BTC_BALANCE=1,n.DEFAULT_BTC_FEE_RATE=2.0060000000000002,n.DEFAULT_BTC_CONVERSION_RATE=106763,n.DEFAULT_SOL_CONVERSION_RATE=226,n.DEFAULT_BTC_TRANSACTION_ID="e4111a707317da67d49a71af4cbcf6c0546f900ca32c3842d2254e315d1fca18",n.SATS_IN_1_BTC=1e8,n.DEFAULT_SOLANA_ACCOUNT="E6Aa9DDv7zsePJHosoqiNb3cFuup3fkXTyRH2pZ1nVzP",n.DEFAULT_SOLANA_BALANCE=1,n.PORTFOLIO_PAGE_TITLE="MetaMask Portfolio";n.ACCOUNT_TYPE=function(e){return e[e.Ethereum=0]="Ethereum",e[e.Bitcoin=1]="Bitcoin",e[e.Solana=2]="Solana",e}({});n.MOCK_META_METRICS_ID="0x86bacb9b2bf9a7e8d2b147eadb95ac9aaa26842327cd24afc8bd4b3c1d136420",n.MOCK_REMOTE_FEATURE_FLAGS_RESPONSE={feature1:!0,feature2:!1,feature3:{name:"groupC",value:"valueC"},sendRedesign:{enabled:!1}},n.MOCK_CUSTOMIZED_REMOTE_FEATURE_FLAGS={feature3:{name:"groupA",value:"valueA"}},n.WALLET_PASSWORD="correct horse battery staple",n.MOCK_AUTH_CONNECTION_ID="torus-test-health",n.MOCK_GROUPED_AUTH_CONNECTION_ID="torus-test-health-aggregate",n.MOCK_GOOGLE_ACCOUNT="e2e-user-mock@gmail.com",n.MOCK_GOOGLE_ACCOUNT_WALLET_ADDRESS="0x5CfE73b6021E818B776b421B1c4Db2474086a7e1",n.MOCK_APPLE_ACCOUNT="e2e-user-mock@appleid.com",n.TEST_SEED_PHRASE="forum vessel pink push lonely enact gentle tail admit parrot grunt dress",n.TEST_SEED_PHRASE_TWO="phrase upgrade clock rough situate wedding elder clever doctor stamp excess tent",n.PRIVATE_KEY="0x7C9529A67102755B7E6102D6D950AC5D5863C98713805CEC576B945B15B71EAC",n.PRIVATE_KEY_TWO="0xf444f52ea41e3a39586d7069cb8e8233e9f6b9dea9cbb700cce69ae860661cc8",n.ACCOUNT_1=s,n.ACCOUNT_2="0x09781764c08de8ca82e156bbf156a3ca217c7950",n.WINDOW_TITLES=Object.freeze({ExtensionInFullScreenView:"MetaMask",ExtensionUpdating:"MetaMask Updating",InstalledExtensions:"Extensions",Dialog:"MetaMask Dialog",Phishing:"MetaMask Phishing Detection",ServiceWorkerSettings:"Inspect with Chrome Developer Tools",SnapSimpleKeyringDapp:"SSK - Simple Snap Keyring",TestDApp:"E2E Test Dapp",TestDappSendIndividualRequest:"E2E Test Dapp - Send Individual Request",MultichainTestDApp:"Multichain Test Dapp",SolanaTestDApp:"Solana Test Dapp",TestSnaps:"Test Snaps",ERC4337Snap:"Account Abstraction Snap"})}}},{package:"$root$",file:"test/e2e/constants.ts"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/fixtures/default-fixture.js",{"../../../shared/constants/network":"/home/runner/work/metamask-extension/metamask-extension/shared/constants/network.ts","../../../shared/constants/onboarding":"/home/runner/work/metamask-extension/metamask-extension/shared/constants/onboarding.ts","../../stub/networks":"/home/runner/work/metamask-extension/metamask-extension/test/stub/networks.ts"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{mockNetworkStateOld:r}=e("../../stub/networks"),{CHAIN_IDS:s}=e("../../../shared/constants/network"),{FirstTimeFlowType:o}=e("../../../shared/constants/onboarding");t.exports={defaultFixture:function(e=s.LOCALHOST){return{data:{AuthenticationController:{isSignedIn:!0},NotificationServicesController:{subscriptionAccountsSeen:[],isFeatureAnnouncementsEnabled:!1,isNotificationServicesEnabled:!1,isMetamaskNotificationsFeatureSeen:!1,metamaskNotificationsList:[],metamaskNotificationsReadList:[]},AccountsController:{internalAccounts:{selectedAccount:"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4",accounts:{"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4":{id:"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4",address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",metadata:{name:"Account 1",lastSelected:16655076e5,keyring:{type:"HD Key Tree"}},options:{},methods:["personal_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"]}}}},AlertController:{alertEnabledness:{unconnectedAccount:!0,web3ShimUsage:!0},unconnectedAccountAlertShownOrigins:{},web3ShimUsageOrigins:{}},AnnouncementController:{announcements:{8:{date:"2021-11-01",id:8,isShown:!1}}},NetworkOrderController:{orderedNetworkList:[{networkId:"0x1",networkRpcUrl:"https://mainnet.infura.io/v3/00000000000000000000000000000000"},{networkId:"0xe708",networkRpcUrl:"https://linea-mainnet.infura.io/v3/00000000000000000000000000000000"},{networkId:e,networkRpcUrl:"http://localhost:8545"}]},NetworkEnablementController:{enabledNetworkMap:{eip155:{[e]:!0},solana:{"solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp":!0}}},AccountOrderController:{pinnedAccountList:[],hiddenAccountList:[]},AppStateController:{browserEnvironment:{},nftsDropdownState:{},connectedStatusPopoverHasBeenShown:!0,termsOfUseLastAgreed:"__FIXTURE_SUBSTITUTION__currentDateInMilliseconds",defaultHomeActiveTabName:null,fullScreenGasPollTokens:[],notificationGasPollTokens:[],popupGasPollTokens:[],recoveryPhraseReminderHasBeenShown:!0,pna25Acknowledged:!1,recoveryPhraseReminderLastShown:"__FIXTURE_SUBSTITUTION__currentDateInMilliseconds",showTestnetMessageInDropdown:!0,trezorModel:null,isRampCardClosed:!1,newPrivacyPolicyToastClickedOrClosed:!0,newPrivacyPolicyToastShownDate:Date.now(),snapsInstallPrivacyWarningShown:!0,hasShownMultichainAccountsIntroModal:!0,showShieldEntryModalOnce:!1,pendingShieldCohort:null,pendingShieldCohortTxType:null,appActiveTab:{id:1,title:"E2E Test Dapp",origin:"http://127.0.0.1:8080",protocol:"http:",url:"http://127.0.0.1:8080",host:"127.0.0.1:8080",href:"http://127.0.0.1:8080"}},BridgeController:{},CurrencyController:{currentCurrency:"usd",currencyRates:{ETH:{conversionDate:1665507600,conversionRate:1700,usdConversionRate:1700},MON:{conversionDate:1665507600,conversionRate:.2,usdConversionRate:.2}}},GasFeeController:{estimatedGasFeeTimeBounds:{},gasEstimateType:"none",gasFeeEstimates:{}},KeyringController:{vault:'{"data":"WHaP1FrrtV4zUonudIppDifsLHF39g6oPkVksAIdWAHBRzax1uy1asfAJprR7u72t4/HuYz5yPIFQrnNnv+hwQu9GRuty88VKMnvMy+sq8MNtoXI+C54bZpWa8r4iUQfa0Mj/cfJbpFpzOdF1ZYXahTfTcU5WsrHwvJew842CiJR4B2jmCHHXfm/DxLK3WazsVQwXJGx/U71UelGoOOrT8NI28EKrAwgPn+7Xmv0j92gmhau30N7Bo2fr6Zv","iv":"LfD8/tY1EjXzxuemSmDVdA==","keyMetadata":{"algorithm":"PBKDF2","params":{"iterations":600000}},"salt":"nk4xdpmMR+1s5BYe4Vnk++XAQwrISI2bCtbMg7V1wUA="}'},MetaMetricsController:{eventsBeforeMetricsOptIn:[],tracesBeforeMetricsOptIn:[],fragments:{},metaMetricsId:null,participateInMetaMetrics:!1,dataCollectionForMarketing:!1,traits:{},latestNonAnonymousEventTimestamp:0},MetaMetricsDataDeletionController:{metaMetricsDataDeletionId:null,metaMetricsDataDeletionTimestamp:0},NetworkController:{...r({id:"networkConfigurationId",chainId:e,nickname:"Localhost 8545",rpcUrl:"http://localhost:8545",ticker:"ETH",blockExplorerUrl:undefined}),providerConfig:{id:"networkConfigurationId"}},OnboardingController:{completedOnboarding:!0,firstTimeFlowType:o.import,onboardingTabs:{},seedPhraseBackedUp:!0},PermissionController:{subjects:{}},PreferencesController:{advancedGasFee:null,currentLocale:"en",useExternalServices:!0,dismissSeedBackUpReminder:!0,overrideContentSecurityPolicyHeader:!0,featureFlags:{},forgottenPassword:!1,identities:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",lastSelected:16655076e5,name:"Account 1"}},ipfsGateway:"dweb.link",knownMethodData:{},ledgerTransportType:"webhid",lostIdentities:{},openSeaEnabled:!1,preferences:{hideZeroBalanceTokens:!1,showExtensionInFullSizeView:!1,showFiatInTestnets:!1,showTestNetworks:!1,smartTransactionsOptInStatus:!0,showNativeTokenAsMainBalance:!0,petnamesEnabled:!0,showMultiRpcModal:!1,showConfirmationAdvancedDetails:!1,tokenSortConfig:{key:"tokenFiatAmount",order:"dsc",sortCallback:"stringNumeric"},shouldShowAggregatedBalancePopover:!0,tokenNetworkFilter:{},avatarType:"maskicon"},selectedAddress:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",theme:"light",useBlockie:!1,useNftDetection:!1,usePhishDetect:!0,useTokenDetection:!1,useCurrencyRateCheck:!0,useMultiAccountBalanceChecker:!0,isMultiAccountBalancesEnabled:!0,referrals:{hyperliquid:{}}},SelectedNetworkController:{domains:{}},SmartTransactionsController:{smartTransactionsState:{fees:{},feesByChainId:{},liveness:!0,livenessByChainId:{},smartTransactions:{[s.MAINNET]:[]}}},SubjectMetadataController:{subjectMetadata:{"https://metamask.github.io":{extensionId:null,iconUrl:null,name:"MetaMask < = > Ledger Bridge",origin:"https://metamask.github.io",subjectType:"website"}}},TokensController:{allDetectedTokens:{},allIgnoredTokens:{},allTokens:{}},MultichainAccountService:{},TransactionController:{transactions:{}},config:{},firstTimeInfo:{date:16655076e5,version:"10.21.0"}}}},FIXTURE_STATE_METADATA_VERSION:74,E2E_SRP:"spread raise short crane omit tent fringe mandate neglect detail suspect cradle"}}}},{package:"$root$",file:"test/e2e/fixtures/default-fixture.js"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/fixtures/fixture-builder.js",{"../../../shared/constants/network":"/home/runner/work/metamask-extension/metamask-extension/shared/constants/network.ts","../../stub/networks":"/home/runner/work/metamask-extension/metamask-extension/test/stub/networks.ts","../constants":"/home/runner/work/metamask-extension/metamask-extension/test/e2e/constants.ts","../seeder/smart-contracts":"/home/runner/work/metamask-extension/metamask-extension/test/e2e/seeder/smart-contracts.js","./default-fixture":"/home/runner/work/metamask-extension/metamask-extension/test/e2e/fixtures/default-fixture.js","./onboarding-fixture.json":"/home/runner/work/metamask-extension/metamask-extension/test/e2e/fixtures/onboarding-fixture.json","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const{WALLET_SNAP_PERMISSION_KEY:r,SnapCaveatType:s}=e("@metamask/snaps-utils"),{merge:o,mergeWith:i}=e("lodash"),{toHex:a}=e("@metamask/controller-utils"),{mockNetworkStateOld:f}=e("../../stub/networks"),{AVALANCHE_DISPLAY_NAME:u,BNB_DISPLAY_NAME:l,CHAIN_IDS:d,LOCALHOST_DISPLAY_NAME:c,POLYGON_DISPLAY_NAME:m,ZK_SYNC_ERA_DISPLAY_NAME:h}=e("../../../shared/constants/network"),{SMART_CONTRACTS:b}=e("../seeder/smart-contracts"),{DAPP_URL:p,DAPP_URL_LOCALHOST:k,DAPP_ONE_URL:x,DEFAULT_FIXTURE_ACCOUNT:j}=e("../constants"),{defaultFixture:w,FIXTURE_STATE_METADATA_VERSION:g}=e("./default-fixture"),y=e("./onboarding-fixture.json");t.exports=class{constructor({onboarding:e=!1,inputChainId:t=d.LOCALHOST}={}){this.fixture=!0===e?y:w(t)}withAccountTracker(e){return o(this.fixture.data.AccountTracker,e),this}withAddressBookController(e){return o(this.fixture.data.AddressBookController?this.fixture.data.AddressBookController:this.fixture.data.AddressBookController={},e),this}withAlertController(e){return o(this.fixture.data.AlertController,e),this}withAnnouncementController(e){return o(this.fixture.data.AnnouncementController,e),this}withNetworkOrderController(e){return o(this.fixture.data.NetworkOrderController,e),this}withEnabledNetworks(e){var t;return o(this.fixture.data.NetworkOrderController,{networkOrder:null===(t=this.fixture.data.NetworkOrderController)||void 0===t?void 0:t.networkOrder}),this.fixture.data.NetworkEnablementController.enabledNetworkMap=e,this}withAccountOrderController(e){return o(this.fixture.data.AccountOrderController,e),this}withAppStateController(e){return o(this.fixture.data.AppStateController,e),this}withCurrencyController(e){return o(this.fixture.data.CurrencyController,e),this}withConversionRateDisabled(){return this.withPreferencesController({useCurrencyRateCheck:!1})}withShowFiatTestnetEnabled(){return this.withPreferencesController({preferences:{showFiatInTestnets:!0}})}withConversionRateEnabled(){return this.withPreferencesController({useCurrencyRateCheck:!0})}withUseBasicFunctionalityDisabled(){return this.withPreferencesController({useExternalServices:!1})}withUseBasicFunctionalityEnabled(){return this.withPreferencesController({useExternalServices:!0})}withGasFeeController(e){return o(this.fixture.data.GasFeeController,e),this}withKeyringController(e){return o(this.fixture.data.KeyringController,e),this}withKeyringControllerAdditionalAccountVault(){return this.withKeyringController({vault:'{"data":"XBb1KJiGsxNOhcTC/xtzaNmpDqnMibJ/HCIjMGUHF/jPIghM63+xkoGcko9T2NKjeMyt2QLbl7K9tr0/qQgbAJP/LUn6gfovkajBdeBQ5N/qztdw7uGJsnrKnzo1krmb2wWeFstwoolcZ9GYwhYVSmCO/tYba50eanY2XvmFheT1ghowtiFmTIGRWV2X1HacnpI4n0rW88ZyBaVuOJOIJGEBiiTD+b0V5l9Tv4sFEms4jvatJwhjDQnx1HmyQE3K64+W5yJe764B0ZdcQ6j2dyIaGgutcz8PoQLBJR1uo78fufZeFzk1gk/BreXn2+4vQnPxQ3prhnXHO4S+7Kj1h2ticxYb3XWnprFLWyksu9ChMyqDXwgM6edLBRDH2jz/IMuC5g9JhABl7PsSH+001z/uBx3GvRTFviFF9dztf195/EPy8YbuYUVbYtJy1aPSju84efWYvb7GrzrmgFnbeh2BpjyWqHoCTdw8fhdm7HQO8GFF7JdGtoIpjkhwPrudIQeIYhGCezd+n5GFp3mdmFNrLbOVFgxufTdY6hlYkg6c5XuHC2VnWCSPwWKIn6t9VuvuyIxXBnol/bgYC8R/d99ctkPDHykigQcgr6cCnhPOwUFOLwrmXqm9HQeWiKb8WxwdGeRnblS+fhFhB+lSy7RvyTUb7HFogDPnDLP/LlUFxdSNNBgqNJU1Dc07Np65PZrpsPvSCfkFttzTytHswhtTEMOg/faaH2D6AwIGbh5Z9cubiNcMrdD75aT1WGuecJ8P7uOMYJq9C7e5l/35","iv":"U81Cv/oryQ1DI9lRezx1iw==","keyMetadata":{"algorithm":"PBKDF2","params":{"iterations":600000}},"salt":"ejIn0xx5qZMA0m2ekjvXJF2pJa8ocL11wEdNIFJsKZQ="}'})}withKeyringControllerImportedAccountVault(){return this.withKeyringController({vault:'{"data":"NlxYVSDJJV4B1DWM+fZ0KX1K2lIU9ozK3WMbbL23WEY036umZ9//qB+bN9R1jKMm6xqHGSGgq9EteFMy2Ix5Bx1/c4hV2QquFRTEzPB4TkQ6+P5eJUvgvZ7vqvVU+2W8719T1oz/O7DH7HbO05JPLD1RBY+XOyHzUzAgwmXq0mwxNpqji3ejHyrjZ/1l06igircW/qysLcjZFZ52Vv4a/q1zCL37/4heHDRVmfEob//ulUbJ/5M=","iv":"b9n77dsUqvww9nGcWfPuIA==","keyMetadata":{"algorithm":"PBKDF2","params":{"iterations":600000}},"salt":"XrmM930Jqnb7C9Ow5NErAMkSGR3vuMLsqUrkGjzpwaY="}'})}withKeyringControllerOldVault(){return this.withKeyringController({vault:'{"data":"s6TpYjlUNsn7ifhEFTkuDGBUM1GyOlPrim7JSjtfIxgTt8/6MiXgiR/CtFfR4dWW2xhq85/NGIBYEeWrZThGdKGarBzeIqBfLFhw9n509jprzJ0zc2Rf+9HVFGLw+xxC4xPxgCS0IIWeAJQ+XtGcHmn0UZXriXm8Ja4kdlow6SWinB7sr/WM3R0+frYs4WgllkwggDf2/Tv6VHygvLnhtzp6hIJFyTjh+l/KnyJTyZW1TkZhDaNDzX3SCOHT","iv":"FbeHDAW5afeWNORfNJBR0Q==","salt":"TxZ+WbCW6891C9LK/hbMAoUsSEW1E8pyGLVBU6x5KR8="}'})}withKeyringControllerMultiSRP(){return this.withKeyringController({vault:'{"data":"tM9QywcUa46iRvWsfvOL9mJqOrRLoVZoDuqTwxEt1Jz4qCpVIx8I/+7wMQuHBhe+DLBMSB7DzWeBpkCngTSE/mt6ygXWd96aKPH00PCW7uq/Z+8gdHQ3+ZGVCkTIDvLwOzG2gywrOfWRzRRcFwV545EV2iC6Q47A6KcgK/YokBeT4uVJ+oC309490eYn6/LkC+e+DNzJOlESs0LOynMJPMP0Wc53AvEuVlmYA2QLUKa+X6Eo1FEm91lg7znnNGTH7d7PVzDjElTQAUcQmiCvLfJU3cCmnVubarG/eOPWyL41u1z2IFMuf2QKoJNG7garFS+z4THtqWuR/NiYbNCJ70G6V2P0+9ntIWMk4qs4cBY4Pl3MPsyXBVhVoL+sLmuguY6iPijQVcPtd8G1HjTWOXNAVYSrdXjd4YHJuBBqgrjsqkkCHknilv6BiyHFH+pURP7zuPley9hiru5szuaKKU4NtpawQe0STQO5X35fI2xrH603etO9lhlK9lU+eFA+6jO0EynA1+HDIWT8iqX0gaOF6aPR/K1EKzbveP+EQbj7vIpOQs2+EJ4F4LYkExKczpvacgci84sLWGeT1e/aP1/dsVjuApUo0mtJaUtbljSvWoGuh6y8orTt6voyvHvbA+atPX+jla0/rWwy1lJ8o6PoXnyBMsgS+DSSamqXeMRKPI4S6GWiAMxLmvJvOEiC/uYRLrCzE0RxjIP9W6f2K+0VhAXJjPBp/t32NeHiwBfVeitdPwZUmMfhqzE0gvXyAd6cfzEnlyICfS8/DQkn74GDbdd1MdikdETCutDpiGEshacQT/scy0Z6n/5vuKkAGgrW66m39Ewqz6H2Rida5zgx1esrwZFy+8H57M2fa9KPa3ddye6J5Cd00JiqK/HiT20Uzt4h725iLNdkDrDT/mLlIGwbcSsSZxpTCYjtAAcN5JtWZNIp6xPOT889Tg9u3hHNy3g3VhVbYevtfTnVSgFFi+9B1JZ1OhL4NZC8bjyeNJ1pOUyLRZiRhgQ8aJPv5QytwDth+pJBvQslQ5UlrbhHRyd0RC0YrcyQ3WbapuDlJtdkkDuQg0OvevX+3F/Z/84uWvJ9qWBPkbOcn+ydULRDDouBmwsHqyY=","iv":"CR5flTdOsO77up6hbd8qQA==","keyMetadata":{"algorithm":"PBKDF2","params":{"iterations":600000}},"salt":"VY02O4NjlOhOKZI0/WPievKNVo2vOcg237YR5MrUW+c="}'})}withMetaMetricsController(e){return o(this.fixture.data.MetaMetricsController,e),this}withNetworkController(e){return o(this.fixture.data.NetworkController,e),this.fixture.data.NetworkController.providerConfig={id:this.fixture.data.NetworkController.selectedNetworkClientId},this}withNetworkControllerOnBnb(){return this.withNetworkController({networkConfigurations:{networkConfigurationId:{chainId:d.BSC,nickname:l,rpcPrefs:{},rpcUrl:"https://bsc-dataseed.binance.org",ticker:"BNB",networkConfigurationId:"networkConfigurationId",id:"networkConfigurationId"}}})}withNetworkControllerOnMainnet(){return this.withNetworkController({selectedNetworkClientId:"mainnet"})}withNetworkControllerOnArbitrumGoerli(){return this.withNetworkController({selectedNetworkClientId:"arbitrum-goerli"})}withNetworkControllerOnLinea(){return this.withNetworkController({selectedNetworkClientId:"linea-mainnet"})}withNetworkControllerOnLineaLocahost(){return this.withNetworkController({networkConfigurations:{networkConfigurationId:{chainId:d.LINEA_MAINNET,nickname:c,rpcPrefs:{},rpcUrl:"http://localhost:8545",ticker:"ETH",networkConfigurationId:"networkConfigurationId",id:"networkConfigurationId"}}})}withNetworkControllerOnOptimism(){return this.withNetworkController({networkConfigurations:{networkConfigurationId:{chainId:d.OPTIMISM,nickname:c,rpcPrefs:{},rpcUrl:"https://mainnet.infura.io",ticker:"ETH",networkConfigurationId:"networkConfigurationId",id:"networkConfigurationId"}}})}withNetworkControllerOnPolygon(){return this.withNetworkController({networkConfigurations:{networkConfigurationId:{chainId:d.POLYGON,nickname:m,rpcPrefs:{},rpcUrl:"https://mainnet.infura.io",ticker:"ETH",networkConfigurationId:"networkConfigurationId",id:"networkConfigurationId"}}})}withNetworkControllerDoubleNode(){const e=f({id:"76e9cd59-d8e2-47e7-b369-9c205ccb602c",rpcUrl:"http://localhost:8546",chainId:"0x53a",ticker:"ETH",nickname:"Localhost 8546"});return delete e.selectedNetworkClientId,this.withNetworkController(e)}withNetworkControllerTripleNode(){this.withNetworkControllerDoubleNode();const e=f({rpcUrl:"http://localhost:7777",chainId:"0x3e8",ticker:"ETH",nickname:"Localhost 7777",blockExplorerUrl:undefined});return delete e.selectedNetworkClientId,o(this.fixture.data.NetworkController,e),this}withNetworkControllerOnMegaETH(){return this.withNetworkController({selectedNetworkClientId:"megaeth-testnet",networkConfigurations:{"megaeth-testnet":{chainId:d.MEGAETH_TESTNET,nickname:"Mega Testnet",rpcUrl:"https://carrot.megaeth.com/rpc",ticker:"MegaETH",rpcPrefs:{blockExplorerUrl:"https://testnet.megaeth.com"},id:"megaeth-testnet",type:"rpc",isCustom:!0}}})}withNetworkControllerOnMonad(){return this.withNetworkController({selectedNetworkClientId:"monad-testnet",networkConfigurations:{"monad-testnet":{chainId:d.MONAD_TESTNET,nickname:"Monad Testnet",rpcUrl:"https://testnet-rpc.monad.xyz",ticker:"MON",rpcPrefs:{blockExplorerUrl:"https://testnet.monadexplorer.com"},id:"monad-testnet",type:"rpc",isCustom:!0}}})}withNetworkControllerOnSei(){return this.withNetworkController({selectedNetworkClientId:"sei",networkConfigurations:{sei:{chainId:d.SEI,nickname:"Sei",rpcUrl:"https://sei-mainnet.infura.io/v3/",ticker:"SEI",rpcPrefs:{blockExplorerUrl:"https://seitrace.com"},id:"sei",type:"rpc",isCustom:!0}}})}withNftController(e){return o(this.fixture.data.NftController?this.fixture.data.NftController:this.fixture.data.NftController={},e),this}withDeFiPositionsController(e){return o(this.fixture.data.DeFiPositionsController?this.fixture.data.DeFiPositionsController:this.fixture.data.DeFiPositionsController={},e),this}withNftControllerERC1155(){return this.withNftController({allNftContracts:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{[a(1337)]:[{address:`__FIXTURE_SUBSTITUTION__CONTRACT${b.ERC1155}`}]}},allNfts:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{[a(1337)]:[{address:`__FIXTURE_SUBSTITUTION__CONTRACT${b.ERC1155}`,tokenId:"1",favorite:!1,isCurrentlyOwned:!0,name:"Rocks",description:"This is a collection of Rock NFTs.",image:"ipfs://bafkreifvhjdf6ve4jfv6qytqtux5nd4nwnelioeiqx5x2ez5yrgrzk7ypi",standard:"ERC1155",chainId:1337}]}},ignoredNfts:[]})}withNftControllerERC721(){return this.withNftController({allNftContracts:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{[a(1337)]:[{address:`__FIXTURE_SUBSTITUTION__CONTRACT${b.NFTS}`,name:"TestDappNFTs",symbol:"TDC"}]}},allNfts:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{[a(1337)]:[{address:`__FIXTURE_SUBSTITUTION__CONTRACT${b.NFTS}`,description:"Test Dapp NFTs for testing.",favorite:!1,image:"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjM1MCIgd2lkdGg9IjM1MCIgdmlld0JveD0iMCAwIDEwMCAxMDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdGggaWQ9Ik15UGF0aCIgZmlsbD0ibm9uZSIgc3Ryb2tlPSJyZWQiIGQ9Ik0xMCw5MCBROTAsOTAgOTAsNDUgUTkwLDEwIDUwLDEwIFExMCwxMCAxMCw0MCBRMTAsNzAgNDUsNzAgUTcwLDcwIDc1LDUwIiAvPjwvZGVmcz48dGV4dD48dGV4dFBhdGggaHJlZj0iI015UGF0aCI+UXVpY2sgYnJvd24gZm94IGp1bXBzIG92ZXIgdGhlIGxhenkgZG9nLjwvdGV4dFBhdGg+PC90ZXh0Pjwvc3ZnPg==",isCurrentlyOwned:!0,name:"Test Dapp NFTs #1",standard:"ERC721",tokenId:"1",chainId:1337}]}},ignoredNfts:[]})}withNotificationServicesController(e){return i(this.fixture.data.NotificationServicesController,e,(e,t)=>(Array.isArray(e)&&e.concat(t),undefined)),this}withOnboardingController(e){return o(this.fixture.data.OnboardingController,e),this}withPermissionController(e){return o(this.fixture.data.PermissionController,e),this}withBridgeControllerDefaultState(){return this.fixture.data.BridgeController={},this}withPermissionControllerConnectedToTestDapp({account:e="",useLocalhostHostname:t=!1}={}){const n=e||j;return this.withPermissionController({subjects:{[t?k:p]:{origin:t?k:p,permissions:{eth_accounts:{id:"ZaqPEWxyhNCJYACFw93jE",parentCapability:"eth_accounts",invoker:p,caveats:[{type:"restrictReturnedAccounts",value:[n.toLowerCase()]}],date:1664388714636}}}}})}withPermissionControllerConnectedToTestDappWithChains(e){return this.withPermissionController({subjects:{[p]:{origin:p,permissions:{eth_accounts:{id:"ZaqPEWxyhNCJYACFw93jE",parentCapability:"eth_accounts",invoker:p,caveats:[{type:"restrictReturnedAccounts",value:[j.toLowerCase()]}],date:1664388714636},"endowment:permitted-chains":{id:"D7cac0a2e3BD8f349506a",parentCapability:"endowment:permitted-chains",invoker:p,caveats:[{type:"restrictNetworkSwitching",value:e}],date:1664388714637}}}}})}withPermissionControllerConnectedToMultichainTestDapp({account:e="",useLocalhostHostname:t=!1,value:n=null}={}){const r=e||j,s={[t?k:p]:{origin:t?k:p,permissions:{"endowment:caip25":{caveats:[{type:"authorizedScopes",value:n??{requiredScopes:{},optionalScopes:{"eip155:1337":{accounts:[`eip155:1337:${r.toLowerCase()}`]},"wallet:eip155":{accounts:[`wallet:eip155:${r.toLowerCase()}`]},wallet:{accounts:[]}},isMultichainOrigin:!0}}],id:"ZaqPEWxyhNCJYACFw93jE",date:1664388714636,invoker:p,parentCapability:"endowment:caip25"}}}};return this.withPermissionController({subjects:s})}withPermissionControllerConnectedToMultichainTestDappWithTwoAccounts({scopes:e=["eip155:1337"]}){const t={};for(const n of e)t[n]={accounts:[`${n}:0x5cfe73b6021e818b776b421b1c4db2474086a7e1`,`${n}:0x09781764c08de8ca82e156bbf156a3ca217c7950`]};const n={[p]:{origin:p,permissions:{"endowment:caip25":{caveats:[{type:"authorizedScopes",value:{requiredScopes:{},optionalScopes:t,isMultichainOrigin:!0}}],id:"ZaqPEWxyhNCJYACFw93jE",date:1664388714636,invoker:p,parentCapability:"endowment:caip25"}}}};return this.withPermissionController({subjects:n})}withPermissionControllerConnectedToTestDappWithTwoAccounts(){const e={[p]:{origin:p,permissions:{eth_accounts:{id:"ZaqPEWxyhNCJYACFw93jE",parentCapability:"eth_accounts",invoker:p,caveats:[{type:"restrictReturnedAccounts",value:["0x5cfe73b6021e818b776b421b1c4db2474086a7e1","0x09781764c08de8ca82e156bbf156a3ca217c7950"]}],date:1664388714636}}}};return this.withPermissionController({subjects:e})}withPermissionControllerSnapAccountConnectedToTestDapp(){return this.withPermissionController({subjects:{[p]:{origin:p,permissions:{eth_accounts:{id:"ZaqPEWxyhNCJYACFw93jE",parentCapability:"eth_accounts",invoker:p,caveats:[{type:"restrictReturnedAccounts",value:["0x09781764c08de8ca82e156bbf156a3ca217c7950"]}],date:1664388714636}}}}})}withPermissionControllerConnectedToTwoTestDapps(){return this.withPermissionController({subjects:{[p]:{origin:p,permissions:{eth_accounts:{id:"ZaqPEWxyhNCJYACFw93jE",parentCapability:"eth_accounts",invoker:p,caveats:[{type:"restrictReturnedAccounts",value:["0x5cfe73b6021e818b776b421b1c4db2474086a7e1"]}],date:1664388714636}}},[x]:{origin:x,permissions:{eth_accounts:{id:"AqPEWxyhNCJYACFw93jE4",parentCapability:"eth_accounts",invoker:x,caveats:[{type:"restrictReturnedAccounts",value:["0x5cfe73b6021e818b776b421b1c4db2474086a7e1"]}],date:1664388714636}}}}})}withPermissionControllerConnectedToSnapDapp(){return this.withPermissionController({subjects:{"https://metamask.github.io":{origin:"https://metamask.github.io",permissions:{[r]:{caveats:[{type:s.SnapIds,value:{"npm@metamask/test-snap-bip32":{},"npm@metamask/test-snap-bip44":{},"npm@metamask/test-snap-error":{},"npm@metamask/test-snap-managestate":{},"npm@metamask/test-snap-notification":{}}}],id:"CwdJq0x8N_b9FNxn6dVuP",parentCapability:r,invoker:"https://metamask.github.io",date:1664388714636}}}}})}withPermissionLogController(e){return o(this.fixture.data.PermissionLogController?this.fixture.data.PermissionLogController:this.fixture.data.PermissionLogController={},e),this}withPreferencesController(e){return o(this.fixture.data.PreferencesController,e),this}withPreferencesControllerAdditionalAccountIdentities(){return this.withPreferencesController({identities:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",lastSelected:16655076e5,name:"Account 1"},"0x09781764c08de8ca82e156bbf156a3ca217c7950":{address:"0x09781764c08de8ca82e156bbf156a3ca217c7950",lastSelected:16655078e5,name:"Account 2"}}})}withPreferencesControllerImportedAccountIdentities(){return this.withPreferencesController({identities:{"0x0cc5261ab8ce458dc977078a3623e2badd27afd3":{name:"Account 1",address:"0x0cc5261ab8ce458dc977078a3623e2badd27afd3",lastSelected:16655076e5},"0x3ed0ee22e0685ebbf07b2360a8331693c413cc59":{name:"Account 2",address:"0x3ed0ee22e0685ebbf07b2360a8331693c413cc59"},"0xd38d853771fb546bd8b18b2f3638491bc0b0e906":{name:"Account 3",address:"0xd38d853771fb546bd8b18b2f3638491bc0b0e906"}},selectedAddress:"0x0cc5261ab8ce458dc977078a3623e2badd27afd3"})}withPreferencesControllerPetnamesDisabled(){return this.withPreferencesController({preferences:{petnamesEnabled:!1}})}withPreferencesControllerShowNativeTokenAsMainBalanceDisabled(){return this.withPreferencesController({preferences:{showNativeTokenAsMainBalance:!1}})}withPreferencesControllerTxSimulationsDisabled(){return this.withPreferencesController({useTransactionSimulations:!1})}withPreferencesControllerSmartTransactionsOptedOut(){return this.withPreferencesController({preferences:{smartTransactionsOptInStatus:!1}})}withAccountsController(e){return o(this.fixture.data.AccountsController,e),this}withAccountsControllerImportedAccount(){return this.withAccountsController({internalAccounts:{selectedAccount:"2fdb2de6-80c7-4d2f-9f95-cb6895389843",accounts:{"2fdb2de6-80c7-4d2f-9f95-cb6895389843":{id:"2fdb2de6-80c7-4d2f-9f95-cb6895389843",address:"0x0cc5261ab8ce458dc977078a3623e2badd27afd3",options:{},methods:["personal_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"],metadata:{name:"Account 1",lastSelected:16655076e5,keyring:{type:"HD Key Tree"}}},"58093703-57e9-4ea9-8545-49e8a75cb084":{id:"58093703-57e9-4ea9-8545-49e8a75cb084",address:"0x3ed0ee22e0685ebbf07b2360a8331693c413cc59",options:{},methods:["personal_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"],metadata:{name:"Account 2",keyring:{type:"HD Key Tree"}}},"dd658aab-abf2-4f53-b735-c8a57151d447":{id:"dd658aab-abf2-4f53-b735-c8a57151d447",address:"0xd38d853771fb546bd8b18b2f3638491bc0b0e906",options:{},methods:["personal_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"],metadata:{name:"Account 3",keyring:{type:"HD Key Tree"}}}}}})}withAccountsControllerAdditionalAccountIdentities(){return this.withAccountsController({internalAccounts:{accounts:{"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4":{id:"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4",address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",options:{},methods:["personal_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"],metadata:{name:"Account 1",lastSelected:16655076e5,keyring:{type:"HD Key Tree"}}},"e9976a84-110e-46c3-9811-e2da7b5528d3":{id:"e9976a84-110e-46c3-9811-e2da7b5528d3",address:"0x09781764c08de8ca82e156bbf156a3ca217c7950",options:{},methods:["personal_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"],metadata:{name:"Account 2",lastSelected:16655078e5,keyring:{type:"HD Key Tree"}}}}},selectedAccount:"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4"})}withPreferencesControllerNftDetectionEnabled(){return this.withPreferencesController({openSeaEnabled:!0,useNftDetection:!0})}withSelectedNetworkController(e){return o(this.fixture.data.SelectedNetworkController,e),this}withSelectedNetworkControllerPerDomain(){return o(this.withSelectedNetworkController({domains:{[p]:"networkConfigurationId",[x]:"76e9cd59-d8e2-47e7-b369-9c205ccb602c"}}),this)}withSmartTransactionsController(e){return o(this.fixture.data.SmartTransactionsController,e),this}withSubjectMetadataController(e){return o(this.fixture.data.SubjectMetadataController,e),this}withAccountTreeController(e={}){var t;(t=this.fixture.data).AccountTreeController??(t.AccountTreeController={});const n={accountTree:(()=>{var e,t;const n=(null===(e=this.fixture)||void 0===e||null===(e=e.data)||void 0===e||null===(e=e.AccountsController)||void 0===e||null===(e=e.internalAccounts)||void 0===e?void 0:e.accounts)||{},r=(null===(t=this.fixture)||void 0===t||null===(t=t.data)||void 0===t||null===(t=t.AccountsController)||void 0===t||null===(t=t.internalAccounts)||void 0===t?void 0:t.selectedAccount)||null,s=Object.values(n),o={},i={};for(const e of s){var a;if("HD Key Tree"===(null==e||null===(a=e.metadata)||void 0===a||null===(a=a.keyring)||void 0===a?void 0:a.type)){var f;const t=(null==e||null===(f=e.options)||void 0===f?void 0:f.entropySource)||"UNKNOWN_ENTROPY_SOURCE";i[t]||(i[t]=[]),i[t].push(e.id)}}Object.entries(i).forEach(([e,t],n)=>{const r=`entropy:${e}`,s=`${r}/0`;o[r]={id:r,type:"entropy",groups:{[s]:{id:s,type:"multichain-account",accounts:t,metadata:{name:"Default",pinned:!1,hidden:!1,entropy:{groupIndex:0}}}},metadata:{name:`Wallet ${n+1}`,entropy:{id:e}}}});for(const e of s){var u,l;const t=null==e||null===(u=e.metadata)||void 0===u||null===(u=u.keyring)||void 0===u?void 0:u.type,n="HD Key Tree"===t,r=Boolean(null==e||null===(l=e.metadata)||void 0===l||null===(l=l.snap)||void 0===l?void 0:l.id);if(!n&&t&&!r){const n=`keyring:${t}`,r=`${n}/${((null==e?void 0:e.address)||"").toLowerCase()}`;o[n]||(o[n]={id:n,type:"keyring",groups:{},metadata:{name:t,keyring:{type:t}}}),o[n].groups[r]={id:r,type:"single-account",accounts:[e.id],metadata:{name:`${t} Account 1`,pinned:!1,hidden:!1}}}}for(const e of s){var d;const t=null==e||null===(d=e.metadata)||void 0===d||null===(d=d.snap)||void 0===d?void 0:d.id;if(t){var c,m;const n=`snap:${t}`,r=`${n}/${((null==e?void 0:e.address)||"").toLowerCase()}`;o[n]||(o[n]={id:n,type:"snap",groups:{},metadata:{name:(null==e||null===(c=e.metadata)||void 0===c||null===(c=c.snap)||void 0===c?void 0:c.name)||t,snap:{id:t}}}),o[n].groups[r]={id:r,type:"single-account",accounts:[e.id],metadata:{name:`${(null==e||null===(m=e.metadata)||void 0===m||null===(m=m.snap)||void 0===m?void 0:m.name)||"Snap Account"} 1`,pinned:!1,hidden:!1}}}}let h=null;if(r)for(const e of Object.values(o)){const t=Object.values(e.groups).find(e=>e.accounts.includes(r));if(t){h=t.id;break}}if(!h){const e=Object.values(o)[0],t=e?Object.values(e.groups)[0]:null;h=t?t.id:null}return{selectedAccountGroup:h,wallets:o}})(),accountGroupsMetadata:{},accountWalletsMetadata:{}};return o(n,e),o(this.fixture.data.AccountTreeController,n),this}withTokenListController(e){return o(this.fixture.data.TokenListController?this.fixture.data.TokenListController:this.fixture.data.TokenListController={},e),this}withTokensController(e){return o(this.fixture.data.TokensController,e),this}withBadPreferencesControllerState(){return o(this.fixture.data,{PreferencesController:5}),this}withTokensControllerERC20({chainId:e=1337}={}){return o(this.fixture.data.TokensController,{allTokens:{[a(e)]:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":[{address:`__FIXTURE_SUBSTITUTION__CONTRACT${b.HST}`,symbol:"TST",decimals:4,image:"https://static.cx.metamask.io/api/v1/tokenIcons/1337/0x581c3c1a2a4ebde2a0df29b5cf4c116e42945947.png",isERC721:!1,aggregators:[]}]}},allIgnoredTokens:{},allDetectedTokens:{}}),this}withTransactionController(e){return o(this.fixture.data.TransactionController?this.fixture.data.TransactionController:this.fixture.data.TransactionController={},e),this}withTransactionControllerApprovedTransaction(){return this.withTransactionController({transactions:{"13a01e77-a368-4bb9-aba9-e7435580e3b9":{chainId:d.LOCALHOST,history:[{chainId:d.LOCALHOST,id:"13a01e77-a368-4bb9-aba9-e7435580e3b9",loadingDefaults:!0,origin:"metamask",status:"unapproved",time:1617228030067,txParams:{from:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",gas:"0x61a8",maxFeePerGas:"0x59682f0c",maxPriorityFeePerGas:"0x59682f00",to:"0x2f318C334780961FB129D2a6c30D0763d9a5C970",type:"0x2",value:"0xde0b6b3a7640000"},type:"simpleSend"},[{note:"Added new unapproved transaction.",op:"replace",path:"/loadingDefaults",timestamp:1617228030069,value:!1}],[{op:"add",path:"/txParams/nonce",value:"0x0",note:"transactions#approveTransaction",timestamp:1617228031069}]],id:"13a01e77-a368-4bb9-aba9-e7435580e3b9",loadingDefaults:!1,origin:"metamask",primaryTransaction:{chainId:d.LOCALHOST,id:"13a01e77-a368-4bb9-aba9-e7435580e3b9",loadingDefaults:!0,origin:"metamask",status:"approved",time:1617228030067,txParams:{from:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",gas:"0x61a8",maxFeePerGas:"0x59682f0c",maxPriorityFeePerGas:"0x59682f00",to:"0x2f318C334780961FB129D2a6c30D0763d9a5C970",type:"0x2",value:"0xde0b6b3a7640000"},type:"sentEther"},status:"approved",time:1617228030067,txParams:{from:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",gas:"0x61a8",maxFeePerGas:"0x59682f0c",maxPriorityFeePerGas:"0x59682f00",to:"0x2f318C334780961FB129D2a6c30D0763d9a5C970",type:"0x2",value:"0xde0b6b3a7640000"},type:"simpleSend"}}})}withTransactionControllerCompletedTransaction(){return this.withTransactionController({transactions:{"0c9342ce-ef3f-4cab-9425-8e57144256a6":{chainId:d.LOCALHOST,history:[{chainId:d.LOCALHOST,id:"0c9342ce-ef3f-4cab-9425-8e57144256a6",loadingDefaults:!0,origin:"metamask",status:"unapproved",time:1671635506502,txParams:{from:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",gas:"0x5208",maxFeePerGas:"0x4c03c96f8",maxPriorityFeePerGas:"0x59682f00",to:"0x2f318C334780961FB129D2a6c30D0763d9a5C970",type:"0x2",value:"0xde0b6b3a7640000"},type:"simpleSend"},[{note:"Added new unapproved transaction.",op:"replace",path:"/loadingDefaults",timestamp:1671635506520,value:!1}],[{note:"confTx: user approved transaction",op:"replace",path:"/txParams/maxFeePerGas",timestamp:1671635510589,value:"0x4d7fc07fb"}],[{note:"txStateManager: setting status to approved",op:"replace",path:"/status",timestamp:1671635510589,value:"approved"}],[{note:"transactions#approveTransaction",op:"add",path:"/txParams/nonce",timestamp:1671635510592,value:"0x2"}],[{note:"txStateManager: setting status to signed",op:"replace",path:"/status",timestamp:1671635510651,value:"signed"}],[{note:"transactions#publishTransaction",op:"add",path:"/rawTx",timestamp:1671635510653,value:"0x02f87205028459682f008504d7fc07fb825208947d17148ed7ec802e4458e94deec1ef28aef645e987038d7ea4c6800080c001a0c60aeaef1556a52b009e3973f06c64d5cd6dc935463afd0d2b1c00661655e47ea061b121db8f2cb2241b1454d1794256e5634d26a5b873e89a816efe210377492a"}],[{note:"txStateManager: setting status to submitted",op:"replace",path:"/status",timestamp:1671635510753,value:"submitted"}],[{note:"txStateManager: setting status to confirmed",op:"replace",path:"/status",timestamp:1671635522978,value:"confirmed"},{op:"add",path:"/txReceipt",value:{blockNumber:"7cbf95",from:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",gasUsed:"5208",status:"0x1",to:"0x2f318C334780961FB129D2a6c30D0763d9a5C970",type:"0x2"}}],[{note:"transactions#confirmTransaction - add txReceipt",op:"replace",path:"/blockTimestamp",timestamp:1671635522999,value:"63a32240"}]],id:"0c9342ce-ef3f-4cab-9425-8e57144256a6",loadingDefaults:!1,origin:"metamask",status:"confirmed",submittedTime:1671635510753,time:1671635506502,txParams:{from:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",gas:"0x5208",to:"0x2f318C334780961FB129D2a6c30D0763d9a5C970",type:"0x2",value:"0xde0b6b3a7640000"},hash:"0xe5e7b95690f584b8f66b33e31acc6184fea553fa6722d42486a59990d13d5fa2",txReceipt:{blockNumber:{length:1,negative:0,words:[8175509,null]},from:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",status:"0x1",to:"0x2f318C334780961FB129D2a6c30D0763d9a5C970",type:"0x2"},type:"simpleSend"}}})}withTransactionControllerIncomingTransaction(){return this.withTransactionController({transactions:{"8a13fd36-fdad-48ae-8b6a-c8991026d550":{blockNumber:"1",chainId:d.LOCALHOST,hash:"0xf1af8286e4fa47578c2aec5f08c108290643df978ebc766d72d88476eee90bab",id:"8a13fd36-fdad-48ae-8b6a-c8991026d550",status:"confirmed",time:167163552e4,txParams:{from:"0xc87261ba337be737fa744f50e7aaf4a920bdfcd6",gas:"0x5208",gasPrice:"0x329af9707",to:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",value:"0xDE0B6B3A7640000"},type:"incoming"}}})}withTransactionControllerCompletedAndIncomingTransaction(){const e=this.withTransactionControllerCompletedTransaction().fixture.data.TransactionController.transactions,t=this.withTransactionControllerIncomingTransaction().fixture.data.TransactionController.transactions;return this.withTransactionController({transactions:{...e,...t}})}withConnectionsToManyDapps(){return this.withPermissionController({subjects:{"https://app.ens.domains":{origin:"https://app.ens.domains",permissions:{eth_accounts:{id:"oKXoF_MNlffiR2u1Y3mDE",parentCapability:"eth_accounts",invoker:"https://app.ens.domains",caveats:[{type:"restrictReturnedAccounts",value:["0xbee150bdc171c7d4190891e78234f791a3ac7b24","0xb9504634e5788208933b51ae7440b478bfadf865"]}],date:1708029792962}}},"https://app.uniswap.org":{origin:"https://app.uniswap.org",permissions:{eth_accounts:{id:"vaa88u5Iv3VmsJwG3bDKW",parentCapability:"eth_accounts",invoker:"https://app.uniswap.org",caveats:[{type:"restrictReturnedAccounts",value:["0xbee150bdc171c7d4190891e78234f791a3ac7b24","0xd1ca923697a701cba1364d803d72b4740fc39bc9"]}],date:1708029870079}}},"https://www.dextools.io":{origin:"https://www.dextools.io",permissions:{eth_accounts:{id:"bvvPcFtIhkFyHyW0Tmwi4",parentCapability:"eth_accounts",invoker:"https://www.dextools.io",caveats:[{type:"restrictReturnedAccounts",value:["0xbee150bdc171c7d4190891e78234f791a3ac7b24","0xa5c5293e124d04e2f85e8553851001fd2f192647","0xb9504634e5788208933b51ae7440b478bfadf865"]}],date:1708029948170}}},"https://coinmarketcap.com":{origin:"https://coinmarketcap.com",permissions:{eth_accounts:{id:"AiblK84K1Cic-Y0FDSzMD",parentCapability:"eth_accounts",invoker:"https://coinmarketcap.com",caveats:[{type:"restrictReturnedAccounts",value:["0xbee150bdc171c7d4190891e78234f791a3ac7b24"]}],date:1708030049641}}}},subjectMetadata:{"https://ens.domains":{iconUrl:null,name:"ens.domains",subjectType:"website",origin:"https://ens.domains",extensionId:null},"https://app.ens.domains":{iconUrl:"https://app.ens.domains/favicon-32x32.png",name:"ENS",subjectType:"website",origin:"https://app.ens.domains",extensionId:null},"https://app.uniswap.org":{iconUrl:"https://app.uniswap.org/favicon.png",name:"Uniswap Interface",subjectType:"website",origin:"https://app.uniswap.org",extensionId:null},"https://www.dextools.io":{iconUrl:"https://www.dextools.io/app/favicon.ico",name:"DEXTools.io",subjectType:"website",origin:"https://www.dextools.io",extensionId:null},"https://coinmarketcap.com":{iconUrl:"https://coinmarketcap.com/favicon.ico",name:"CoinMarketCap",subjectType:"website",origin:"https://coinmarketcap.com",extensionId:null}}})}withNameController(e){return o(this.fixture.data.NameController?this.fixture.data.NameController:this.fixture.data.NameController={},e),this}withNoNames(){return this.withNameController({names:{}})}withLedgerAccount(){return this.withKeyringController({vault:'{"data":"kCehIbrW5j8AKVLEdUUaidsTomloRQLmLnEIYUA+HHMCJTJ9/dX+B692ExnrgWlZK4PySLTVoofQZjgQcKVMHi+mO5wnPV3p4sKKpv/w1zh0AIx5h25zDln5DbyHWjJtUKISOvKyLvZ02I0oqFvVGF6Wae/TNLelUleYwjP02h39//Fkgy8hukDNMmscBlX/Vx3iNwyie9X7FXKXMHrHcMhSjRJaZxri48SOWbchx31hfZuv8oP2l1yJkrWv82JjkiZYoQcbGkBRis06GnfFU62cKyqh9ZrIRHb6yj8g7SjRF5mMe7czA3QdJQjUMHJLq9IV2To+WOiOsKd+CVrjvNR9A1fWrRlAvQENDWO9FxaBuuBsNF2mm9KHqowSXD+/TUP1fiftyTnxs9mzojKReX8fPP0qjlIE7Sv71OfKvD1+7zW1udWmgoO+RcCFj3tQ5wXc6/MAYB2N2vfSHB9k+AgUYvajtaf0cb4gdm3KDPhriv1sDkOenaKbZLGLnsbfMWAbTQPrwCDdhiOvHBUfCVrV1ac0FlUIERdNkxDMwbd9BllyscPsif9VNuZCUzzeboTk0LTm1FszgFD8UxlvCfxB9Z5pZgk5ublhAkWZGZuckfVTEPofcELNx8VVf2Un8Yju8QzX7XGwNTTg/v5jLx52NrGWHvWIRUHRjnLK6hOVL26yRbds4e6FK4vsi1Hxi85HiiB1J2RX3gBfl14R2/1nCpLZePnEUaH6TgGPzsbzlJsSsCktGvMZaLdD","iv":"utoVJtRyaiuYF9PnhgZD8w==","keyMetadata":{"algorithm":"PBKDF2","params":{"iterations":600000}},"salt":"PwqqENo0YiZXcRrMzg+ujLG2VtyTNkKBCvFMsnzFefk="}'}).withPreferencesController({identities:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",lastSelected:16655076e5,name:"Account 1"},"0xf68464152d7289d7ea9a2bec2e0035c45188223c":{address:"0xf68464152d7289d7ea9a2bec2e0035c45188223c",lastSelected:16655078e5,name:"Ledger 1"}},selectedAddress:"0xf68464152d7289d7ea9a2bec2e0035c45188223c"})}withTrezorAccount(){return this.withAccountTracker({accountsByChainId:{"0x539":{"0x5CfE73b6021E818B776b421B1c4Db2474086a7e1":{balance:"0x15af1d78b58c40000"},"0xF68464152d7289D7eA9a2bEC2E0035c45188223c":{balance:"0x100000000000000000000"}}}}).withAccountsController({internalAccounts:{accounts:{"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4":{id:"d5e45e4a-3b04-4a09-a5e1-39762e5c6be4",address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",options:{},methods:["personal_sign","eth_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"],metadata:{name:"Account 1",importTime:1724486724986,lastSelected:16655076e5,keyring:{type:"HD Key Tree"}}},"221ecb67-0d29-4c04-83b2-dff07c263634":{id:"221ecb67-0d29-4c04-83b2-dff07c263634",address:"0xf68464152d7289d7ea9a2bec2e0035c45188223c",options:{},methods:["personal_sign","eth_sign","eth_signTransaction","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"],type:"eip155:eoa",scopes:["eip155:0"],metadata:{name:"Trezor 1",importTime:1724486729079,keyring:{type:"Trezor Hardware"},lastSelected:1724486729083}}},selectedAccount:"221ecb67-0d29-4c04-83b2-dff07c263634"}}).withKeyringController({vault:'{"data":"NPUZE4s9SQOrsw1GtJSnQ9ptC3J1nf3O+hWT3N8Oh5MDcyO0XojQfSBZL88FgjuAGMT+oFEnX8gzsd1x0/Z7iinNSOD+U22LJ6w37Pkfw4mqAYvKJDbnb2HAdjNbjGD99PKn1qe5eR0vohL5taFW2lTKdlE3dficITFM9wm9mQTegQVvYClTSktweumFSTMxqO1fUPj7oacLmw69ZAk2/am4fhI4c6ZeJoAkvPTJvYZDOne3WkUlcuUoeJjCX7b/59NQNHeCry8OyWVMCZDMYFsJT9Pk2vlFgnVL69n9dRGHrZNuNGFOhFawta5TqDUn1Ya7Iq0FjBW1WQv+HKktMM+RA8KZZyAAJkXYHRMpmUhQkw4wQFELgHjKFm/NIYcFVT5t6/XIj9kLqh4+55krUGoEHygzX41uSNie/wNmLjTgNAZv/eK9R81vyv1FR8N1fgkr13KxQT/0o/bQZhnaVClFa/3t13epiRrU/1plVh2TaI7HLFLj69d4c7w96J7Z33osjCywpNCJLam3Xx5OLAaPVe+L7a9u/zOMmryxX37xCrQhn9YSzZ0+E9Hik9CZU9ZXqmNgRhYAoqpcRWgMVmEC2HRLBIXXF0VTyYvfUvEfn87iAsqw0KeoQagDpUPsEr8UU9zs6cGRqZZTfR6/Wa3UwuIwV5XnCRg3Eifiz2BHKG4kutxKIJJak9habIfXBjxMrrwrHns7tWmWmE3JRYoekJQxFdWP3mcnDHVNz2VscgWeW5bZEoBim91iPRbsXimX9605xE0WOaHpwu27G9LwTNwL+0f8BgwoCcfMbaKwoDGVqKFOSbKurYBByPmWsm1b10vVrnsxA3VZMd2HWhicD7DE5h/4R+7Z90VthpVwt4NQ7+QmXeSXqCpPcoq7UTrchdYgV95xbKna1r0lSnZSfUMALji1I2Nh96ki24SbbUEeFZGm4dxNSnub07hTKF6xeqS1FvV79hBpZi/6v+pS+SDNSlwEcfRWW3S02Ec6JAhK2rVCQqSwasFcVcznYB5OaKL6QCmriIpqH0ATsthAwsf9naHSU+36wwi3xogxbpzecjaZ8gxKs2wmJk+Rz6VoGB+z9DTzvha5sm4DmfuQ2CtbQNYZq20VG3hO9g7wzWwa5xZmbH7njBDqlpaNgmxMrAX1S+T8D7X6ElD+aH0MyP9UD5E5tT5xxgUAV0wi+LY0+uCi2Y2lragFM7ihmPr1MP5wEy/1eIf45cY3imfl9w0F/FrCo+Hy2Au9AueCCab2eabA8QAum3lhXtdOyc123sSghIPjC6RUlZE53skLx1cPaV5JJAkneQJ44QMWecLQjh3YyCzRQ8XCnFAL+Kmf7zW5t+l25PLCkcfuLE7zxvLsTz3w2TCIXzEJyw1vXjBzPTUdKCNSva0WGsbq5B93zYot6bmvK1RKHeje8Ed/4N/l8uwxulUAjYQ+94qDKkxTVxvAZ8ydoxwKuB8QCTXgbymDsF/Y5l+RDXmzMT8BdN/QtdjsCXJ2PjvBG+srQOPntOCZMS7FVMk9yc6MWE/DBDm7HtY5CiY3af4A5sOZmLSP3Ek91ijmYdr/nO32DnkV4NJ2/Hj8SWAK5OD8zq8q5uRlR8BDcj7oLnzJX4S+yJNJ/nZSleUyTsv5v6YZ8hno","iv":"6SgfUVcvgUDGbCuqmdZgbA==","keyMetadata":{"algorithm":"PBKDF2","params":{"iterations":600000}},"salt":"nk4xdpmMR+1s5BYe4Vnk++XAQwrISI2bCtbMg7V1wUA="}'}).withNameController({names:{ethereumAddress:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{"*":{name:"Account 1",sourceId:null,proposedNames:{},origin:"account-identity"}},"0xf68464152d7289d7ea9a2bec2e0035c45188223c":{"*":{proposedNames:{},name:"Trezor 1",sourceId:null,origin:"account-identity"}}}}}).withPreferencesController({identities:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",lastSelected:16655076e5,name:"Account 1"},"0xf68464152d7289d7ea9a2bec2e0035c45188223c":{address:"0xf68464152d7289d7ea9a2bec2e0035c45188223c",lastSelected:16655078e5,name:"Trezor 1"}},lostIdentities:{"0x5cfe73b6021e818b776b421b1c4db2474086a7e1":{address:"0x5cfe73b6021e818b776b421b1c4db2474086a7e1",name:"Account 1",lastSelected:16655076e5},"0xf68464152d7289d7ea9a2bec2e0035c45188223c":{address:"0xf68464152d7289d7ea9a2bec2e0035c45188223c",name:"Trezor 1",lastSelected:16655078e5}},selectedAddress:"0xf68464152d7289d7ea9a2bec2e0035c45188223c"})}withIncomingTransactionsCache(e){return this.withTransactionController({lastFetchedBlockNumbers:e})}withTransactions(e){return this.withTransactionController({transactions:e})}withPopularNetworks(){return this.withNetworkController({networkConfigurations:{"avalanche-mainnet":{chainId:d.AVALANCHE,nickname:u,rpcPrefs:{},rpcUrl:"https://api.avax.network/ext/bc/C/rpc",ticker:"AVAX",id:"avalanche-mainnet"},"zksync-mainnet":{chainId:d.ZKSYNC_ERA,nickname:h,rpcPrefs:{},rpcUrl:"https://mainnet.era.zksync.io",ticker:"ETH",id:"zksync-mainnet"}}})}withSnapController(e){var t;return(t=this.fixture.data).SnapController??(t.SnapController={}),o(this.fixture.data.SnapController,e),this}withSnapControllerOnStartLifecycleSnap(){return this.withPermissionController({subjects:{"npm:@metamask/lifecycle-hooks-example-snap":{origin:"npm:@metamask/lifecycle-hooks-example-snap",permissions:{"endowment:lifecycle-hooks":{caveats:null,date:1750244440562,id:"0eKn8SjGEH6o_6Mhcq3Lw",invoker:"npm:@metamask/lifecycle-hooks-example-snap",parentCapability:"endowment:lifecycle-hooks"},snap_dialog:{caveats:null,date:1750244440562,id:"Fbme_UWcuSK92JqfrT4G2",invoker:"npm:@metamask/lifecycle-hooks-example-snap",parentCapability:"snap_dialog"}}}}}).withSnapController({snaps:{"npm:@metamask/lifecycle-hooks-example-snap":{auxiliaryFiles:[],blocked:!1,enabled:!0,id:"npm:@metamask/lifecycle-hooks-example-snap",initialPermissions:{"endowment:lifecycle-hooks":{},snap_dialog:{}},localizationFiles:[],manifest:{description:"MetaMask example snap demonstrating the use of the `onStart`, `onInstall`, and `onUpdate` lifecycle hooks.",initialPermissions:{"endowment:lifecycle-hooks":{},snap_dialog:{}},manifestVersion:"0.1",platformVersion:"8.1.0",proposedName:"Lifecycle Hooks Example Snap",repository:{type:"git",url:"https://github.com/MetaMask/snaps.git"},source:{location:{npm:{filePath:"dist/bundle.js",packageName:"@metamask/lifecycle-hooks-example-snap",registry:"https://registry.npmjs.org"}},shasum:"5tlM5E71Fbeid7I3F0oQURWL7/+0620wplybtklBCHQ="},version:"2.2.0"},sourceCode:'(()=>{var e={d:(n,t)=>{for(var a in t)e.o(t,a)&&!e.o(n,a)&&Object.defineProperty(n,a,{enumerable:!0,get:t[a]})},o:(e,n)=>Object.prototype.hasOwnProperty.call(e,n),r:e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})}},n={};(()=>{"use strict";function t(e,n,t){if("string"==typeof e)throw new Error(`An HTML element ("${String(e)}") was used in a Snap component, which is not supported by Snaps UI. Please use one of the supported Snap components.`);if(!e)throw new Error("A JSX fragment was used in a Snap component, which is not supported by Snaps UI. Please use one of the supported Snap components.");return e({...n,key:t})}function a(e){return Object.fromEntries(Object.entries(e).filter((([,e])=>void 0!==e)))}function r(e){return n=>{const{key:t=null,...r}=n;return{type:e,props:a(r),key:t}}}e.r(n),e.d(n,{onInstall:()=>p,onStart:()=>l,onUpdate:()=>d});const o=r("Box"),s=r("Text"),l=async()=>await snap.request({method:"snap_dialog",params:{type:"alert",content:t(o,{children:t(s,{children:\'The client was started successfully, and the "onStart" handler was called.\'})})}}),p=async()=>await snap.request({method:"snap_dialog",params:{type:"alert",content:t(o,{children:t(s,{children:\'The Snap was installed successfully, and the "onInstall" handler was called.\'})})}}),d=async()=>await snap.request({method:"snap_dialog",params:{type:"alert",content:t(o,{children:t(s,{children:\'The Snap was updated successfully, and the "onUpdate" handler was called.\'})})}})})(),module.exports=n})();',status:"stopped",version:"2.2.0",versionHistory:[{date:1750244439310,origin:"https://metamask.github.io",version:"2.2.0"}]}}})}withBackupAndSyncSettings(e={}){const{isBackupAndSyncEnabled:t=!0,isAccountSyncingEnabled:n=!0,isBackupAndSyncUpdateLoading:r=!1}=e;return o(this.fixture.data.UserStorageController,{isBackupAndSyncEnabled:t,isAccountSyncingEnabled:n,isBackupAndSyncUpdateLoading:r}),this}withRemoteFeatureFlags(e={}){return o(this.fixture.data.RemoteFeatureFlagController.remoteFeatureFlags,e),this}build(){return this.fixture.meta||(this.fixture.meta={version:g}),this.fixture}}}}},{package:"$root$",file:"test/e2e/fixtures/fixture-builder.js"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/fixtures/onboarding-fixture.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={data:{AccountOrderController:{hiddenAccountList:[],pinnedAccountList:[]},AccountTracker:{accountsByChainId:{"0x1":{}}},AccountTreeController:{accountGroupsMetadata:{},accountWalletsMetadata:{},hasAccountTreeSyncingSyncedAtLeastOnce:!1},AccountsController:{internalAccounts:{accounts:{},selectedAccount:""}},AddressBookController:{addressBook:{}},AlertController:{alertEnabledness:{smartTransactionsMigration:!0,unconnectedAccount:!0,web3ShimUsage:!0},unconnectedAccountAlertShownOrigins:{},web3ShimUsageOrigins:{}},AnnouncementController:{announcements:{}},AppMetadataController:{currentAppVersion:"13.12.0",currentMigrationVersion:183,previousAppVersion:"",previousMigrationVersion:0},AppStateController:{browserEnvironment:{browser:"chrome",os:"mac"},canTrackWalletFundsObtained:!0,connectedStatusPopoverHasBeenShown:!0,defaultHomeActiveTabName:null,enableEnforcedSimulations:!0,enforcedSimulationsSlippage:10,hadAdvancedGasFeesSetPriorToMigration92_3:!1,hasShownMultichainAccountsIntroModal:!1,isRampCardClosed:!1,isWalletResetInProgress:!1,lastUpdatedAt:null,lastUpdatedFromVersion:null,lastViewedUserSurvey:null,newPrivacyPolicyToastClickedOrClosed:null,newPrivacyPolicyToastShownDate:1764061390419,nftsDetectionNoticeDismissed:!1,onboardingDate:1764061390455,outdatedBrowserWarningLastShown:null,pendingShieldCohortTxType:null,productTour:"accountIcon",recoveryPhraseReminderHasBeenShown:!1,recoveryPhraseReminderLastShown:1764061389868,shieldEndingToastLastClickedOrClosed:null,shieldPausedToastLastClickedOrClosed:null,showAccountBanner:!0,showBetaHeader:!1,showDownloadMobileAppSlide:!0,showNetworkBanner:!0,showPermissionsTour:!0,showShieldEntryModalOnce:null,showTestnetMessageInDropdown:!0,slides:[],surveyLinkLastClickedOrClosed:null,timeoutMinutes:0,trezorModel:null,updateModalLastDismissedAt:null},ApprovalController:{},AuthenticationController:{isSignedIn:!1},BridgeController:{},BridgeStatusController:{txHistory:{}},ClaimsController:{claims:[],claimsConfigurations:{supportedNetworks:["0x1","0xe708"],validSubmissionWindowDays:21}},CurrencyController:{currencyRates:{ETH:{conversionDate:0,conversionRate:0,usdConversionRate:null}},currentCurrency:"usd"},DeFiPositionsController:{},DecryptMessageController:{},DelegationController:{delegations:{}},EncryptionPublicKeyController:{},EnsController:{ensEntries:{"0x1":{".":{address:"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",chainId:"0x1",ensName:"."}},"0x3":{".":{address:"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",chainId:"0x3",ensName:"."}},"0x4":{".":{address:"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",chainId:"0x4",ensName:"."}},"0x4268":{".":{address:"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",chainId:"0x4268",ensName:"."}},"0x5":{".":{address:"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",chainId:"0x5",ensName:"."}},"0xaa36a7":{".":{address:"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",chainId:"0xaa36a7",ensName:"."}}},ensResolutionsByAddress:{}},GasFeeController:{estimatedGasFeeTimeBounds:{},gasEstimateType:"none",gasFeeEstimates:{},gasFeeEstimatesByChainId:{},nonRPCGasFeeApisDisabled:!1},GatorPermissionsController:{gatorPermissionsMapSerialized:'{"native-token-stream":{},"native-token-periodic":{},"erc20-token-stream":{},"erc20-token-periodic":{},"other":{}}',isGatorPermissionsEnabled:!1},KeyringController:{},LoggingController:{logs:{}},MetaMetricsController:{dataCollectionForMarketing:null,eventsBeforeMetricsOptIn:[{category:"App",event:"App Installed",properties:{}}],fragments:{},latestNonAnonymousEventTimestamp:0,marketingCampaignCookieId:null,metaMetricsId:null,participateInMetaMetrics:null,segmentApiCalls:{},tracesBeforeMetricsOptIn:[{request:{name:"Onboarding - Overall Journey",op:"onboarding.user_journey",startTime:1764061390458},type:"start"}],traits:{install_date_ext:"2025-11-25"}},MetaMetricsDataDeletionController:{metaMetricsDataDeletionId:null,metaMetricsDataDeletionTimestamp:0},MultichainAssetsController:{accountsAssets:{},allIgnoredAssets:{},assetsMetadata:{}},MultichainAssetsRatesController:{conversionRates:{}},MultichainBalancesController:{balances:{}},MultichainNetworkController:{isEvmSelected:!0,multichainNetworkConfigurationsByChainId:{"bip122:000000000019d6689c085ae165831e93":{chainId:"bip122:000000000019d6689c085ae165831e93",isEvm:!1,name:"Bitcoin",nativeCurrency:"bip122:000000000019d6689c085ae165831e93/slip44:0"},"bip122:000000000933ea01ad0ee984209779ba":{chainId:"bip122:000000000933ea01ad0ee984209779ba",isEvm:!1,name:"Bitcoin Testnet",nativeCurrency:"bip122:000000000933ea01ad0ee984209779ba/slip44:0"},"bip122:00000000da84f2bafbbc53dee25a72ae":{chainId:"bip122:00000000da84f2bafbbc53dee25a72ae",isEvm:!1,name:"Bitcoin Testnet4",nativeCurrency:"bip122:00000000da84f2bafbbc53dee25a72ae/slip44:0"},"bip122:00000008819873e925422c1ff0f99f7c":{chainId:"bip122:00000008819873e925422c1ff0f99f7c",isEvm:!1,name:"Bitcoin Mutinynet",nativeCurrency:"bip122:00000008819873e925422c1ff0f99f7c/slip44:0"},"bip122:regtest":{chainId:"bip122:regtest",isEvm:!1,name:"Bitcoin Regtest",nativeCurrency:"bip122:regtest/slip44:0"},"solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z":{chainId:"solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z",isEvm:!1,name:"Solana Testnet",nativeCurrency:"solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z/slip44:501"},"solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp":{chainId:"solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp",isEvm:!1,name:"Solana",nativeCurrency:"solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp/slip44:501"},"solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1":{chainId:"solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1",isEvm:!1,name:"Solana Devnet",nativeCurrency:"solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1/slip44:501"},"tron:2494104990":{chainId:"tron:2494104990",isEvm:!1,name:"Tron Shasta",nativeCurrency:"tron:2494104990/slip44:195"},"tron:3448148188":{chainId:"tron:3448148188",isEvm:!1,name:"Tron Nile",nativeCurrency:"tron:3448148188/slip44:195"},"tron:728126428":{chainId:"tron:728126428",isEvm:!1,name:"Tron",nativeCurrency:"tron:728126428/slip44:195"}},networksWithTransactionActivity:{},selectedMultichainNetworkChainId:"solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp"},MultichainRatesController:{cryptocurrencies:["btc","sol"],fiatCurrency:"usd",rates:{btc:{conversionDate:0,conversionRate:0},sol:{conversionDate:0,conversionRate:0}}},MultichainTransactionsController:{nonEvmTransactions:{}},NameController:{nameSources:{},names:{ethereumAddress:{}}},NetworkController:{networkConfigurationsByChainId:{"0x1":{blockExplorerUrls:["https://etherscan.io"],chainId:"0x1",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Ethereum",nativeCurrency:"ETH",rpcEndpoints:[{failoverUrls:["https://dimensional-special-breeze.quiknode.pro/d5e2d185c1561ef5ecb9aadf1ae7cc58863f4fa4/"],networkClientId:"mainnet",type:"infura",url:"https://mainnet.infura.io/v3/{infuraProjectId}"}]},"0x18c6":{blockExplorerUrls:["https://megaexplorer.xyz"],chainId:"0x18c6",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Mega Testnet",nativeCurrency:"MegaETH",rpcEndpoints:[{failoverUrls:[],networkClientId:"megaeth-testnet",type:"custom",url:"https://carrot.megaeth.com/rpc"}]},"0x2105":{blockExplorerUrls:["https://basescan.org"],chainId:"0x2105",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Base",nativeCurrency:"ETH",rpcEndpoints:[{failoverUrls:["https://ancient-quaint-water.base-mainnet.quiknode.pro/a2cb04635063b578dba24f656fe376a55e8d9939/"],networkClientId:"base-mainnet",type:"infura",url:"https://base-mainnet.infura.io/v3/{infuraProjectId}"}]},"0x279f":{blockExplorerUrls:["https://testnet.monadexplorer.com"],chainId:"0x279f",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Monad Testnet",nativeCurrency:"MON",rpcEndpoints:[{failoverUrls:[],networkClientId:"monad-testnet",type:"custom",url:"https://testnet-rpc.monad.xyz"}]},"0x38":{blockExplorerUrls:["https://bscscan.com"],chainId:"0x38",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"BNB Chain",nativeCurrency:"BNB",rpcEndpoints:[{failoverUrls:[],networkClientId:"bsc-mainnet",type:"infura",url:"https://bsc-mainnet.infura.io/v3/{infuraProjectId}"}]},"0x89":{blockExplorerUrls:["https://polygonscan.com"],chainId:"0x89",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Polygon",nativeCurrency:"POL",rpcEndpoints:[{failoverUrls:["https://powerful-radial-aura.matic.quiknode.pro/edaa1cc73ef2a19230e2e715e766b6783ad8126a/"],networkClientId:"polygon-mainnet",type:"infura",url:"https://polygon-mainnet.infura.io/v3/{infuraProjectId}"}]},"0xa":{blockExplorerUrls:["https://optimistic.etherscan.io"],chainId:"0xa",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"OP",nativeCurrency:"ETH",rpcEndpoints:[{failoverUrls:["https://holy-convincing-diagram.optimism.quiknode.pro/4804f72f80b7566982ad24a7a1d8e1ae48bca208/"],networkClientId:"optimism-mainnet",type:"infura",url:"https://optimism-mainnet.infura.io/v3/{infuraProjectId}"}]},"0xa4b1":{blockExplorerUrls:["https://arbiscan.io"],chainId:"0xa4b1",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Arbitrum",nativeCurrency:"ETH",rpcEndpoints:[{failoverUrls:["https://purple-young-mansion.arbitrum-mainnet.quiknode.pro/f48c5cbfd1f5b39f0e5542d3b23c181b4085a2b5/"],networkClientId:"arbitrum-mainnet",type:"infura",url:"https://arbitrum-mainnet.infura.io/v3/{infuraProjectId}"}]},"0xaa36a7":{blockExplorerUrls:["https://sepolia.etherscan.io"],chainId:"0xaa36a7",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Sepolia",nativeCurrency:"SepoliaETH",rpcEndpoints:[{failoverUrls:[],networkClientId:"sepolia",type:"infura",url:"https://sepolia.infura.io/v3/{infuraProjectId}"}]},"0xe705":{blockExplorerUrls:["https://sepolia.lineascan.build"],chainId:"0xe705",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Linea Sepolia",nativeCurrency:"LineaETH",rpcEndpoints:[{failoverUrls:[],networkClientId:"linea-sepolia",type:"infura",url:"https://linea-sepolia.infura.io/v3/{infuraProjectId}"}]},"0xe708":{blockExplorerUrls:["https://lineascan.build"],chainId:"0xe708",defaultBlockExplorerUrlIndex:0,defaultRpcEndpointIndex:0,name:"Linea",nativeCurrency:"ETH",rpcEndpoints:[{failoverUrls:["https://patient-sleek-daylight.linea-mainnet.quiknode.pro/d0e608bf5f231ef9ae6756de4d7876cb0f5ece55/"],networkClientId:"linea-mainnet",type:"infura",url:"https://linea-mainnet.infura.io/v3/{infuraProjectId}"}]}},networksMetadata:{mainnet:{EIPS:{},status:"unknown"}},selectedNetworkClientId:"mainnet"},NetworkEnablementController:{enabledNetworkMap:{bip122:{"bip122:000000000019d6689c085ae165831e93":!0,"bip122:000000000933ea01ad0ee984209779ba":!1,"bip122:00000000da84f2bafbbc53dee25a72ae":!1,"bip122:00000008819873e925422c1ff0f99f7c":!1,"bip122:regtest":!1},eip155:{"0x1":!0,"0x18c6":!1,"0x2105":!0,"0x279f":!1,"0x38":!0,"0x89":!0,"0xa":!0,"0xa4b1":!0,"0xaa36a7":!1,"0xe705":!1,"0xe708":!0},solana:{"solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z":!1,"solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp":!0,"solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1":!1},tron:{"tron:2494104990":!1,"tron:3448148188":!1,"tron:728126428":!0}}},NetworkOrderController:{orderedNetworkList:[]},NftController:{allNftContracts:{},allNfts:{},ignoredNfts:[]},NotificationServicesController:{isFeatureAnnouncementsEnabled:!1,isMetamaskNotificationsFeatureSeen:!1,isNotificationServicesEnabled:!1,metamaskNotificationsList:[],metamaskNotificationsReadList:[],subscriptionAccountsSeen:[]},NotificationServicesPushController:{fcmToken:"",isPushEnabled:!0},OnboardingController:{completedOnboarding:!1,firstTimeFlowType:null,seedPhraseBackedUp:null},PPOMController:{storageMetadata:[],versionInfo:[]},PermissionController:{subjects:{"http://localhost:3000":{origin:"http://localhost:3000",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389882,id:"jhd9UNjo8ODWAV2iy_Ir7",invoker:"http://localhost:3000",parentCapability:"wallet_snap"}}},"http://localhost:8000":{origin:"http://localhost:8000",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389882,id:"aZbz1rktoFGnqND2wqSCw",invoker:"http://localhost:8000",parentCapability:"wallet_snap"}}},"https://alpha.mycactus.io":{origin:"https://alpha.mycactus.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389885,id:"MESnGgj_JsysGkw6Et-_s",invoker:"https://alpha.mycactus.io",parentCapability:"wallet_snap"}}},"https://app.bitgo-test.com":{origin:"https://app.bitgo-test.com",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389884,id:"UJoc3SbEoOUfCrFdt-NN5",invoker:"https://app.bitgo-test.com",parentCapability:"wallet_snap"}}},"https://app.bitgo.com":{origin:"https://app.bitgo.com",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389884,id:"7BE6pedVgFZ5EDErCZdmn",invoker:"https://app.bitgo.com",parentCapability:"wallet_snap"}}},"https://app.metamask.io":{origin:"https://app.metamask.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/message-signing-snap":{}}}],date:1764061389877,id:"fYsfFXNA_41cOKy-O4dN0",invoker:"https://app.metamask.io",parentCapability:"wallet_snap"}}},"https://apps-portal.safe.global":{origin:"https://apps-portal.safe.global",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389885,id:"NOrkSaWWNK4vxhCHa8gT9",invoker:"https://apps-portal.safe.global",parentCapability:"wallet_snap"}}},"https://console.dev.mpcvault.com":{origin:"https://console.dev.mpcvault.com",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389884,id:"r51FvcE0sk-4ivdsPKhAM",invoker:"https://console.dev.mpcvault.com",parentCapability:"wallet_snap"}}},"https://console.fireblocks.io":{origin:"https://console.fireblocks.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"dz4k_w8Y-hnSgsBkj-h0T",invoker:"https://console.fireblocks.io",parentCapability:"wallet_snap"}}},"https://console.mpcvault.com":{origin:"https://console.mpcvault.com",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389884,id:"EEmUYoGtEjV91wg4J_x1S",invoker:"https://console.mpcvault.com",parentCapability:"wallet_snap"}}},"https://debug.mycactus.dev:1443":{origin:"https://debug.mycactus.dev:1443",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389885,id:"dzW1QUb4IhX4IhA6kmnq6",invoker:"https://debug.mycactus.dev:1443",parentCapability:"wallet_snap"}}},"https://dev10-console.waterballoons.xyz":{origin:"https://dev10-console.waterballoons.xyz",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389884,id:"BDtrzw9Z2Rw7-gPx0pwX9",invoker:"https://dev10-console.waterballoons.xyz",parentCapability:"wallet_snap"}}},"https://dev4-console.waterballoons.xyz":{origin:"https://dev4-console.waterballoons.xyz",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389884,id:"3ujqOhlsg03F6u_goGSCU",invoker:"https://dev4-console.waterballoons.xyz",parentCapability:"wallet_snap"}}},"https://developer.metamask.io":{origin:"https://developer.metamask.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/message-signing-snap":{}}}],date:1764061389878,id:"bfINOzA4uykf8SzTWot38",invoker:"https://developer.metamask.io",parentCapability:"wallet_snap"}}},"https://docs.metamask.io":{origin:"https://docs.metamask.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/message-signing-snap":{}}}],date:1764061389877,id:"-NzTLBxNAie7bAXimXptV",invoker:"https://docs.metamask.io",parentCapability:"wallet_snap"}}},"https://eu-console.fireblocks.io":{origin:"https://eu-console.fireblocks.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"7TLSxUx6BEtY2PXQpkm98",invoker:"https://eu-console.fireblocks.io",parentCapability:"wallet_snap"}}},"https://eu2-console.fireblocks.io":{origin:"https://eu2-console.fireblocks.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"MXXsufmLFG-oSHgQh3Q10",invoker:"https://eu2-console.fireblocks.io",parentCapability:"wallet_snap"}}},"https://local.waterballoons.xyz:4200":{origin:"https://local.waterballoons.xyz:4200",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"5NBYRl51NE1rt79Z2oLHz",invoker:"https://local.waterballoons.xyz:4200",parentCapability:"wallet_snap"}}},"https://localhost:3000":{origin:"https://localhost:3000",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389882,id:"u2wx6NlWgb9f08E7VJVv5",invoker:"https://localhost:3000",parentCapability:"wallet_snap"}}},"https://neptune-custody-ui.metamask-institutional.io":{origin:"https://neptune-custody-ui.metamask-institutional.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389882,id:"dMC3k0iQ08ppqmfWjXe-p",invoker:"https://neptune-custody-ui.metamask-institutional.io",parentCapability:"wallet_snap"}}},"https://portfolio-builds.metafi-dev.codefi.network":{origin:"https://portfolio-builds.metafi-dev.codefi.network",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/message-signing-snap":{}}}],date:1764061389877,id:"PTjIbijRl-DcUdwylgdgH",invoker:"https://portfolio-builds.metafi-dev.codefi.network",parentCapability:"wallet_snap"}}},"https://portfolio.metamask.io":{origin:"https://portfolio.metamask.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/message-signing-snap":{},"npm:@metamask/solana-wallet-snap":{},"npm:@metamask/tron-wallet-snap":{}}}],date:1764061389877,id:"v7Le9coHUEN5BEGHvzvVg",invoker:"https://portfolio.metamask.io",parentCapability:"wallet_snap"}}},"https://pre.mycactus.com":{origin:"https://pre.mycactus.com",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389885,id:"u6f3XRClnFjzJgF_GfJvu",invoker:"https://pre.mycactus.com",parentCapability:"wallet_snap"}}},"https://sandbox.fireblocks.io":{origin:"https://sandbox.fireblocks.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"JocFBtJeBM37jLCnWKCgT",invoker:"https://sandbox.fireblocks.io",parentCapability:"wallet_snap"}}},"https://saturn-custody-ui.metamask-institutional.io":{origin:"https://saturn-custody-ui.metamask-institutional.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389884,id:"_LlYwTWBCHa-P52sWybAl",invoker:"https://saturn-custody-ui.metamask-institutional.io",parentCapability:"wallet_snap"}}},"https://ui-preprod-v2.qa.zodia.io":{origin:"https://ui-preprod-v2.qa.zodia.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"A5Q8B6IFW5d6pa_8DaLJI",invoker:"https://ui-preprod-v2.qa.zodia.io",parentCapability:"wallet_snap"}}},"https://ui-preprod-v2.uat.zodia.io":{origin:"https://ui-preprod-v2.uat.zodia.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"8-kzqjTGuBYpjpRrwOL8S",invoker:"https://ui-preprod-v2.uat.zodia.io",parentCapability:"wallet_snap"}}},"https://ui-v2.qa.zodia.io":{origin:"https://ui-v2.qa.zodia.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"K5wauVhfKHwOxNvU6To_n",invoker:"https://ui-v2.qa.zodia.io",parentCapability:"wallet_snap"}}},"https://ui-v2.sit.zodia.io":{origin:"https://ui-v2.sit.zodia.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389882,id:"oWlQcu2GKeDM9hQcYu5cC",invoker:"https://ui-v2.sit.zodia.io",parentCapability:"wallet_snap"}}},"https://v2.custody.zodia.io":{origin:"https://v2.custody.zodia.io",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389883,id:"_cA4fG-H-ikQGFsHe9tOt",invoker:"https://v2.custody.zodia.io",parentCapability:"wallet_snap"}}},"https://www.mycactus.com":{origin:"https://www.mycactus.com",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389885,id:"k6qPaTjMd6RSkC0clOIdO",invoker:"https://www.mycactus.com",parentCapability:"wallet_snap"}}},"https://www.mycactus.dev":{origin:"https://www.mycactus.dev",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389885,id:"jch7JFImk_KHgWS-RJQVA",invoker:"https://www.mycactus.dev",parentCapability:"wallet_snap"}}},"localhost:8000":{origin:"localhost:8000",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/institutional-wallet-snap":{}}}],date:1764061389882,id:"sJ_ygDK55u69EvJBp3hUe",invoker:"localhost:8000",parentCapability:"wallet_snap"}}},"npm:@metamask/bitcoin-wallet-snap":{origin:"npm:@metamask/bitcoin-wallet-snap",permissions:{"endowment:assets":{caveats:[{type:"chainIds",value:["bip122:000000000019d6689c085ae165831e93","bip122:000000000933ea01ad0ee984209779ba","bip122:00000000da84f2bafbbc53dee25a72ae","bip122:00000008819873e925422c1ff0f99f7c","bip122:regtest"]}],date:1764061389895,id:"yc8JfgpoCqnMCNKwbYNKj",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"endowment:assets"},"endowment:cronjob":{caveats:[{type:"snapCronjob",value:{jobs:[{duration:"PT30S",request:{method:"synchronizeAccounts"}}]}}],date:1764061389895,id:"sIBiQ1G6Uq6ShpA1DXh8H",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"endowment:cronjob"},"endowment:keyring":{caveats:[{type:"keyringOrigin",value:{}}],date:1764061389895,id:"95yCWbjxUqXMp3kFCRPjV",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"endowment:keyring"},"endowment:lifecycle-hooks":{caveats:null,date:1764061389895,id:"IdJRG1stVP2SBQLnyy1im",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"endowment:lifecycle-hooks"},"endowment:network-access":{caveats:null,date:1764061389895,id:"O_ba7U1sX_nkWbAu2wwrE",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"endowment:network-access"},"endowment:rpc":{caveats:[{type:"rpcOrigin",value:{dapps:!0,snaps:!1}}],date:1764061389895,id:"aHIZtJ2MvslVAUxLcbZHi",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"endowment:rpc"},"endowment:webassembly":{caveats:null,date:1764061389895,id:"jd8lG6zRuKTNuPYAxBkQX",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"endowment:webassembly"},snap_dialog:{caveats:null,date:1764061389895,id:"0UKi16_qKXVWrYxquXC8A",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"snap_dialog"},snap_getBip32Entropy:{caveats:[{type:"permittedDerivationPaths",value:[{curve:"secp256k1",path:["m","44'","0'"]},{curve:"secp256k1",path:["m","44'","1'"]},{curve:"secp256k1",path:["m","49'","0'"]},{curve:"secp256k1",path:["m","49'","1'"]},{curve:"secp256k1",path:["m","84'","0'"]},{curve:"secp256k1",path:["m","84'","1'"]},{curve:"secp256k1",path:["m","86'","0'"]},{curve:"secp256k1",path:["m","86'","1'"]}]}],date:1764061389895,id:"8gTRjqUkgxiDA-fx--q1e",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"snap_getBip32Entropy"},snap_getPreferences:{caveats:null,date:1764061389895,id:"D79JuTdxTyAF0W0vr-QDm",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"snap_getPreferences"},snap_manageAccounts:{caveats:null,date:1764061389895,id:"QE4C7l8UvVuy00U4kcOWt",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"snap_manageAccounts"},snap_manageState:{caveats:null,date:1764061389895,id:"qi6Rh1wxuP49hiD-H8b3e",invoker:"npm:@metamask/bitcoin-wallet-snap",parentCapability:"snap_manageState"}}},"npm:@metamask/ens-resolver-snap":{origin:"npm:@metamask/ens-resolver-snap",permissions:{"endowment:ethereum-provider":{caveats:null,date:1764061389878,id:"Bi1H2aZ3gpz8bO7fvhIBm",invoker:"npm:@metamask/ens-resolver-snap",parentCapability:"endowment:ethereum-provider"},"endowment:name-lookup":{caveats:null,date:1764061389878,id:"Mb3ye5CIzaneLUP5cBWJX",invoker:"npm:@metamask/ens-resolver-snap",parentCapability:"endowment:name-lookup"},"endowment:network-access":{caveats:null,date:1764061389878,id:"ni7Cr5p8EjYt1VsTxSy6l",invoker:"npm:@metamask/ens-resolver-snap",parentCapability:"endowment:network-access"}}},"npm:@metamask/gator-permissions-snap":{origin:"npm:@metamask/gator-permissions-snap",permissions:{wallet_snap:{caveats:[{type:"snapIds",value:{"npm:@metamask/message-signing-snap":{}}}],date:1764061389878,id:"henkI7uGEsPTHMAE6T3BC",invoker:"npm:@metamask/gator-permissions-snap",parentCapability:"wallet_snap"}}},"npm:@metamask/institutional-wallet-snap":{origin:"npm:@metamask/institutional-wallet-snap",permissions:{"endowment:cronjob":{caveats:[{type:"snapCronjob",value:{jobs:[{expression:"5/15 * * * * *",request:{method:"execute"}},{expression:"* * * * *",request:{method:"manageSleepState"}}]}}],date:1764061389881,id:"LLSWgD-M8-IWr0YFMI5U6",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"endowment:cronjob"},"endowment:ethereum-provider":{caveats:null,date:1764061389881,id:"25IP6pd5N1lUAzA7Ngrjp",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"endowment:ethereum-provider"},"endowment:keyring":{caveats:[{type:"keyringOrigin",value:{allowedOrigins:["localhost:8000","http://localhost:8000"]}}],date:1764061389881,id:"8lQZkbr9lyuUEe4oVMIXQ",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"endowment:keyring"},"endowment:network-access":{caveats:null,date:1764061389881,id:"y5F-p8KklvjaXtbZJbz7N",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"endowment:network-access"},"endowment:page-home":{caveats:null,date:1764061389882,id:"lyuyyI6cJ8Xta7wRIZNhR",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"endowment:page-home"},"endowment:rpc":{caveats:[{type:"rpcOrigin",value:{allowedOrigins:["localhost:8000","http://localhost:8000","localhost:3000","https://localhost:3000","http://localhost:3000","https://neptune-custody-ui.metamask-institutional.io","https://zodia.io","https://ui-v2.sit.zodia.io","https://ui-v2.qa.zodia.io","https://ui-preprod-v2.qa.zodia.io","https://ui-preprod-v2.uat.zodia.io","https://v2.custody.zodia.io","https://console.fireblocks.io","https://eu-console.fireblocks.io","https://eu2-console.fireblocks.io","https://sandbox.fireblocks.io","https://local.waterballoons.xyz:4200","https://dev4-console.waterballoons.xyz","https://dev10-console.waterballoons.xyz","https://console.dev.mpcvault.com","https://saturn-custody-ui.metamask-institutional.io","https://console.mpcvault.com","https://app.bitgo.com","https://app.bitgo-test.com","https://apps-portal.safe.global","https://alpha.mycactus.io","https://pre.mycactus.com","https://www.mycactus.dev","https://debug.mycactus.dev:1443","https://www.mycactus.com"]}}],date:1764061389881,id:"5hJmzGcmTdHwMhouO_VC2",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"endowment:rpc"},snap_dialog:{caveats:null,date:1764061389882,id:"AO0l0ZfwjJ_kQ8-wdjRMN",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"snap_dialog"},snap_manageAccounts:{caveats:null,date:1764061389882,id:"yWVwVp3m2T1HXpK9fbxvg",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"snap_manageAccounts"},snap_manageState:{caveats:null,date:1764061389882,id:"yD5ZTSSZGmOQKDJbESQj9",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"snap_manageState"},snap_notify:{caveats:null,date:1764061389881,id:"O8rLXJpp7-KBVT9YnpgDl",invoker:"npm:@metamask/institutional-wallet-snap",parentCapability:"snap_notify"}}},"npm:@metamask/message-signing-snap":{origin:"npm:@metamask/message-signing-snap",permissions:{"endowment:rpc":{caveats:[{type:"rpcOrigin",value:{dapps:!0,snaps:!0}}],date:1764061389876,id:"OpSK7ZNouHUKfoTXHfOEY",invoker:"npm:@metamask/message-signing-snap",parentCapability:"endowment:rpc"},snap_getEntropy:{caveats:null,date:1764061389876,id:"G5LIG8YQu_PhSdnu2r6-H",invoker:"npm:@metamask/message-signing-snap",parentCapability:"snap_getEntropy"}}},"npm:@metamask/solana-wallet-snap":{origin:"npm:@metamask/solana-wallet-snap",permissions:{"endowment:assets":{caveats:[{type:"chainIds",value:["solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp","solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1"]}],date:1764061389897,id:"D9XrNUBAnpoUUufrE-Qgf",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:assets"},"endowment:cronjob":{caveats:[{type:"snapCronjob",value:{jobs:[]}}],date:1764061389897,id:"8F75H-WFseKVjJWU8fxJ6",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:cronjob"},"endowment:ethereum-provider":{caveats:null,date:1764061389897,id:"3zIMEvpLri-t0vbw1BOcg",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:ethereum-provider"},"endowment:keyring":{caveats:[{type:"keyringOrigin",value:{allowedOrigins:["https://portfolio.metamask.io"]}}],date:1764061389897,id:"M_c-zKHTqCgsLJnjXScUO",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:keyring"},"endowment:lifecycle-hooks":{caveats:null,date:1764061389897,id:"Au4kA6IyG-VCoMTXQHTXo",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:lifecycle-hooks"},"endowment:name-lookup":{caveats:[{type:"chainIds",value:["solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp","solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1"]}],date:1764061389897,id:"K7XuKSDbnWYxtwyTNhzpV",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:name-lookup"},"endowment:network-access":{caveats:null,date:1764061389897,id:"nj2-sPZ6c6XsukTT02KBK",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:network-access"},"endowment:protocol":{caveats:[{type:"protocolSnapScopes",value:{"solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp":{methods:["getGenesisHash","getLatestBlockhash","getMinimumBalanceForRentExemption"]},"solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1":{methods:["getGenesisHash","getLatestBlockhash","getMinimumBalanceForRentExemption"]}}}],date:1764061389897,id:"XCPv8ZXC7EV4uqLV-palJ",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:protocol"},"endowment:rpc":{caveats:[{type:"rpcOrigin",value:{dapps:!0,snaps:!1}}],date:1764061389897,id:"hBv_-kvX8FkItghjQssbU",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"endowment:rpc"},snap_dialog:{caveats:null,date:1764061389897,id:"ejG_nZg2xl1dNwhqlz2OG",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"snap_dialog"},snap_getBip32Entropy:{caveats:[{type:"permittedDerivationPaths",value:[{curve:"ed25519",path:["m","44'","501'"]}]}],date:1764061389897,id:"4V9DSZIY_TLRg1F6yCg96",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"snap_getBip32Entropy"},snap_getPreferences:{caveats:null,date:1764061389897,id:"u-p2iyzu0uwKCkaNzaZMC",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"snap_getPreferences"},snap_manageAccounts:{caveats:null,date:1764061389897,id:"xC0Q5eIeXNoHUAN0A26MJ",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"snap_manageAccounts"},snap_manageState:{caveats:null,date:1764061389897,id:"wZRSCoJ8R2U76GbLqcyeJ",invoker:"npm:@metamask/solana-wallet-snap",parentCapability:"snap_manageState"}}},"npm:@metamask/tron-wallet-snap":{origin:"npm:@metamask/tron-wallet-snap",permissions:{"endowment:assets":{caveats:[{type:"chainIds",value:["tron:728126428"]}],date:1764061389898,id:"qLZ8t-zdDEI15o6hhwENt",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"endowment:assets"},"endowment:cronjob":{caveats:null,date:1764061389898,id:"N350vEClrUxYB0SCiJNCM",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"endowment:cronjob"},"endowment:keyring":{caveats:[{type:"keyringOrigin",value:{allowedOrigins:["https://portfolio.metamask.io"]}}],date:1764061389898,id:"NF_UNUiQrqeMzhvjUpetP",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"endowment:keyring"},"endowment:network-access":{caveats:null,date:1764061389898,id:"6ftFC-DJ-hTdl9KNBUJHD",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"endowment:network-access"},"endowment:rpc":{caveats:[{type:"rpcOrigin",value:{dapps:!0,snaps:!1}}],date:1764061389898,id:"Ev5mw5oFsz_TJ0DAX0RVQ",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"endowment:rpc"},snap_dialog:{caveats:null,date:1764061389898,id:"3Qz9awmY7gqxDuEDVec5b",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"snap_dialog"},snap_getBip32Entropy:{caveats:[{type:"permittedDerivationPaths",value:[{curve:"secp256k1",path:["m","44'","195'"]}]}],date:1764061389898,id:"TE-SVfyz81vRQH52zOnn0",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"snap_getBip32Entropy"},snap_getPreferences:{caveats:null,date:1764061389898,id:"-Xzv8v6VExuesI41PgH0g",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"snap_getPreferences"},snap_manageAccounts:{caveats:null,date:1764061389898,id:"uAUmchDx0EhCeXAMi5cUc",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"snap_manageAccounts"},snap_manageState:{caveats:null,date:1764061389898,id:"7Oa1WdlzQ0kR1SMJ2o-vs",invoker:"npm:@metamask/tron-wallet-snap",parentCapability:"snap_manageState"}}}}},PermissionLogController:{permissionHistory:{}},PhishingController:{c2DomainBlocklistLastFetched:0,hotlistLastFetched:0,phishingLists:[],stalelistLastFetched:0,tokenScanCache:{},urlScanCache:{},whitelist:[],whitelistPaths:{}},PreferencesController:{addSnapAccountEnabled:!1,advancedGasFee:{},currentLocale:"en",dismissSeedBackUpReminder:!1,enableMV3TimestampSave:!0,featureFlags:{},forgottenPassword:!1,identities:{},ipfsGateway:"dweb.link",isIpfsGatewayEnabled:!0,isMultiAccountBalancesEnabled:!0,knownMethodData:{},ledgerTransportType:"webhid",lostIdentities:{},manageInstitutionalWallets:!1,openSeaEnabled:!0,overrideContentSecurityPolicyHeader:!0,preferences:{avatarType:"maskicon",dismissSmartAccountSuggestionEnabled:!1,featureNotificationsEnabled:!1,hideZeroBalanceTokens:!1,petnamesEnabled:!0,privacyMode:!1,showConfirmationAdvancedDetails:!1,showExtensionInFullSizeView:!1,showFiatInTestnets:!1,showMultiRpcModal:!1,showNativeTokenAsMainBalance:!1,showTestNetworks:!1,skipDeepLinkInterstitial:!1,smartAccountOptIn:!0,smartTransactionsMigrationApplied:!1,smartTransactionsOptInStatus:!0,tokenNetworkFilter:{},tokenSortConfig:{key:"tokenFiatAmount",order:"dsc",sortCallback:"stringNumeric"},useNativeCurrencyAsPrimaryCurrency:!0,useSidePanelAsDefault:!1},referrals:{hyperliquid:{}},securityAlertsEnabled:!0,selectedAddress:"",snapRegistryList:{},snapsAddSnapAccountModalDismissed:!1,theme:"os",use4ByteResolution:!0,useAddressBarEnsResolution:!0,useBlockie:!1,useCurrencyRateCheck:!0,useExternalNameSources:!0,useExternalServices:!0,useMultiAccountBalanceChecker:!0,useNftDetection:!0,usePhishDetect:!0,useSafeChainsListValidation:!0,useTokenDetection:!0,useTransactionSimulations:!0,watchEthereumAccountEnabled:!1},RemoteFeatureFlagController:{cacheTimestamp:0,remoteFeatureFlags:{}},RewardsController:{rewardsAccounts:{},rewardsActiveAccount:null,rewardsSeasonStatuses:{},rewardsSeasons:{},rewardsSubscriptionTokens:{},rewardsSubscriptions:{}},SeedlessOnboardingController:{isSeedlessOnboardingUserAuthenticated:!1,socialBackupsMetadata:[]},SelectedNetworkController:{domains:{"http://localhost:3000":"mainnet","http://localhost:8000":"mainnet","https://alpha.mycactus.io":"mainnet","https://app.bitgo-test.com":"mainnet","https://app.bitgo.com":"mainnet","https://app.metamask.io":"mainnet","https://apps-portal.safe.global":"mainnet","https://console.dev.mpcvault.com":"mainnet","https://console.fireblocks.io":"mainnet","https://console.mpcvault.com":"mainnet","https://debug.mycactus.dev:1443":"mainnet","https://dev10-console.waterballoons.xyz":"mainnet","https://dev4-console.waterballoons.xyz":"mainnet","https://developer.metamask.io":"mainnet","https://docs.metamask.io":"mainnet","https://eu-console.fireblocks.io":"mainnet","https://eu2-console.fireblocks.io":"mainnet","https://local.waterballoons.xyz:4200":"mainnet","https://localhost:3000":"mainnet","https://neptune-custody-ui.metamask-institutional.io":"mainnet","https://portfolio-builds.metafi-dev.codefi.network":"mainnet","https://portfolio.metamask.io":"mainnet","https://pre.mycactus.com":"mainnet","https://sandbox.fireblocks.io":"mainnet","https://saturn-custody-ui.metamask-institutional.io":"mainnet","https://ui-preprod-v2.qa.zodia.io":"mainnet","https://ui-preprod-v2.uat.zodia.io":"mainnet","https://ui-v2.qa.zodia.io":"mainnet","https://ui-v2.sit.zodia.io":"mainnet","https://v2.custody.zodia.io":"mainnet","https://www.mycactus.com":"mainnet","https://www.mycactus.dev":"mainnet","localhost:8000":"mainnet","npm:@metamask/bitcoin-wallet-snap":"mainnet","npm:@metamask/ens-resolver-snap":"mainnet","npm:@metamask/gator-permissions-snap":"mainnet","npm:@metamask/institutional-wallet-snap":"mainnet","npm:@metamask/message-signing-snap":"mainnet","npm:@metamask/solana-wallet-snap":"mainnet","npm:@metamask/tron-wallet-snap":"mainnet"}},ShieldController:{coverageResults:{},orderedTransactionHistory:[]},SignatureController:{},SmartTransactionsController:{},SnapController:{snapStates:{},snaps:{},unencryptedSnapStates:{}},SnapInsightsController:{},SnapInterfaceController:{interfaces:{}},SnapsRegistry:{database:null,databaseUnavailable:!1,lastUpdated:null},SubjectMetadataController:{subjectMetadata:{"https://metamask.github.io":{extensionId:null,iconUrl:null,name:"MetaMask < = > Ledger Bridge",origin:"https://metamask.github.io",subjectType:"website"},"https://seaona.github.io":{extensionId:null,iconUrl:null,name:"MetaMask State Diff",origin:"https://seaona.github.io",subjectType:"website"},"npm:@metamask/bitcoin-wallet-snap":{extensionId:null,iconUrl:null,name:"Bitcoin",origin:"npm:@metamask/bitcoin-wallet-snap",subjectType:"snap",svgIcon:'<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">\n<circle cx="20" cy="20.0002" r="18.8889" fill="url(#paint0_linear_69_841)"/>\n<path fill-rule="evenodd" clip-rule="evenodd" d="M24.8152 12.1716C27.4342 13.1325 29.3206 14.5561 28.8882 17.2879C28.5609 19.2765 27.5188 20.2485 26.1106 20.5915C27.9845 21.6404 28.8865 23.2325 27.9216 26.0252C26.7217 29.5278 24.0359 29.8455 20.4784 29.167L19.5625 32.8636L17.4955 32.3513L18.4113 28.6548C18.1864 28.5949 17.9494 28.5397 17.7063 28.4831C17.3815 28.4075 17.0458 28.3293 16.7136 28.2339L15.7977 31.9307L13.7345 31.4193L14.6503 27.7226L10.5403 26.6032L11.5619 23.9894C11.5619 23.9894 13.1132 24.4161 13.0891 24.3893C13.6645 24.5292 13.9459 24.1273 14.0611 23.8458L15.5278 17.9197L16.5951 13.7077C16.6413 13.2524 16.4987 12.6568 15.658 12.4302C15.7152 12.3966 14.1445 12.0551 14.1445 12.0551L14.7566 9.57797L18.9926 10.6278L19.8897 7.00684L22.0237 7.53573L21.1266 11.1567C21.5415 11.2469 21.947 11.3518 22.3568 11.4578L22.357 11.4578C22.4915 11.4926 22.6265 11.5275 22.7624 11.5621L23.6595 7.94112L25.7359 8.45571L24.8152 12.1716ZM19.1525 17.994C19.1848 18.0036 19.2194 18.014 19.2561 18.025C20.497 18.398 24.1766 19.5037 24.7964 17.0417C25.3735 14.7014 22.1857 13.9866 20.7045 13.6544C20.5296 13.6152 20.3784 13.5813 20.2601 13.5507L19.1525 17.994ZM17.5196 25.2939C17.4544 25.2744 17.3943 25.2567 17.3398 25.2406L18.4474 20.7974C18.5783 20.8314 18.7438 20.8703 18.9352 20.9152C20.6813 21.3255 24.5813 22.242 23.9751 24.5954C23.3868 27.039 19.0484 25.7487 17.5196 25.2939Z" fill="white"/>\n<defs>\n<linearGradient id="paint0_linear_69_841" x1="20" y1="1.11133" x2="20" y2="38.8891" gradientUnits="userSpaceOnUse">\n<stop stop-color="#FFB60A"/>\n<stop offset="1" stop-color="#F58300"/>\n</linearGradient>\n</defs>\n</svg>\n',version:"1.6.0"},"npm:@metamask/ens-resolver-snap":{extensionId:null,iconUrl:null,name:"Ethereum Name Service resolver",origin:"npm:@metamask/ens-resolver-snap",subjectType:"snap",svgIcon:'<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" height="3rem">\n  <path fill="url(#ENSWithGradient_svg__a)"\n        d="M4.049 5.663a2.9 2.9 0 0 1 .942-1.038L11.611 0 4.828 11.222s-.592-1.002-.823-1.51a4.8 4.8 0 0 1 .044-4.05m-2.732 7.74a7.55 7.55 0 0 0 2.963 5.489L11.602 24s-4.58-6.606-8.445-13.178a6.6 6.6 0 0 1-.776-2.242 3.6 3.6 0 0 1 0-1.076c-.101.187-.297.57-.297.57a8.7 8.7 0 0 0-.79 2.534c-.077.93-.07 1.867.023 2.796m18.668.89c-.237-.507-.824-1.509-.824-1.509L12.391 24l6.62-4.622c.394-.263.717-.62.942-1.038a4.8 4.8 0 0 0 .044-4.05zm2.688-3.694a7.55 7.55 0 0 0-2.963-5.488L12.4 0s4.577 6.606 8.445 13.179a6.6 6.6 0 0 1 .773 2.24c.054.358.054.72 0 1.077.1-.187.296-.57.296-.57.392-.799.659-1.654.791-2.534.078-.93.07-1.866-.02-2.796z"/>\n  <defs>\n    <linearGradient id="ENSWithGradient_svg__a" x1="15.574" x2="-8.982" y1="26.845" y2="-11.906"\n                    gradientUnits="userSpaceOnUse">\n      <stop stop-color="#44BCF0"/>\n      <stop offset="0.428" stop-color="#628BF3"/>\n      <stop offset="1" stop-color="#A099FF"/>\n    </linearGradient>\n  </defs>\n</svg>\n',version:"1.0.0"},"npm:@metamask/institutional-wallet-snap":{extensionId:null,iconUrl:null,name:"Institutional Wallet",origin:"npm:@metamask/institutional-wallet-snap",subjectType:"snap",svgIcon:'<svg width="24" height="25" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M17.037 0H6.975C2.605 0 0 2.617 0 6.987v10.05c0 4.37 2.605 6.975 6.975 6.975h10.05c4.37 0 6.975-2.605 6.975-6.976V6.988C24.012 2.617 21.407 0 17.037 0ZM11.49 17.757c0 .36-.18.684-.492.876a.975.975 0 0 1-.54.156 1.11 1.11 0 0 1-.469-.108l-4.202-2.1a1.811 1.811 0 0 1-.985-1.61v-3.973c0-.36.18-.685.493-.877a1.04 1.04 0 0 1 1.008-.048l4.202 2.101a1.8 1.8 0 0 1 .997 1.609v3.974h-.012Zm-.252-6.423L6.723 8.896a1.045 1.045 0 0 1-.528-.924c0-.384.204-.744.528-.924l4.515-2.438a1.631 1.631 0 0 1 1.524 0l4.515 2.438c.324.18.528.528.528.924s-.204.744-.528.924l-4.515 2.438c-.24.132-.504.192-.768.192a1.54 1.54 0 0 1-.756-.192Zm7.972 3.638c0 .684-.385 1.308-.997 1.608l-4.202 2.101c-.144.072-.3.108-.468.108a.975.975 0 0 1-.54-.156 1.017 1.017 0 0 1-.493-.876v-3.974c0-.684.384-1.309.997-1.609l4.202-2.101a1.04 1.04 0 0 1 1.008.048c.313.192.493.516.493.877v3.974Z" fill="#24272A"/></svg>\n',version:"1.3.4"},"npm:@metamask/message-signing-snap":{extensionId:null,iconUrl:null,name:"Sign in with MetaMask",origin:"npm:@metamask/message-signing-snap",subjectType:"snap",svgIcon:'<svg width="500" height="500" viewBox="0 0 500 500" fill="none" xmlns="http://www.w3.org/2000/svg">\n<rect width="500" height="500" fill="black"/>\n<g filter="url(#filter0_f_8_91)">\n<path d="M249.444 373.519C249.444 373.519 364.118 343.192 364.118 257.188L378.333 248.251L364.118 239.314L378.333 230.378L364.118 221.441V203.568V185.695V149.948V114.202L301.639 132.596C267.566 142.628 231.323 142.628 197.25 132.596L134.771 114.202V149.948V167.821V185.695V203.568V221.441L120.556 230.378L134.771 239.314L120.556 248.251L134.771 257.188C134.771 343.192 249.444 373.519 249.444 373.519Z" fill="#F1CA77"/>\n</g>\n<path d="M249.445 406.215C249.445 406.215 364.118 348.879 364.118 262.874L378.333 253.937L364.118 245.001L378.333 236.064L364.118 227.127V209.254V191.381V155.634V119.888L249.445 162.179L134.771 119.888V155.634V173.508V191.381V209.254V227.127L120.556 236.064L134.771 245.001L120.556 253.937L134.771 262.874C134.771 348.879 249.445 406.215 249.445 406.215Z" fill="#233447"/>\n<path d="M249.445 399.107C249.445 399.107 364.118 348.879 364.118 262.874L378.333 253.937L364.118 245.001L378.333 236.064L364.118 227.127V209.254V191.381V155.634V119.888L249.445 162.179L134.771 119.888V155.634V173.508V191.381V209.254V227.127L120.556 236.064L134.771 245.001L120.556 253.937L134.771 262.874C134.771 348.879 249.445 399.107 249.445 399.107Z" fill="#123AF0"/>\n<path d="M249.445 392C249.445 392 364.118 348.879 364.118 262.874L378.333 253.937L364.118 245.001L378.333 236.064L364.118 227.127V209.254V191.381V155.634V119.888L249.445 162.179L134.771 119.888V155.634V173.508V191.381V209.254V227.127L120.556 236.064L134.771 245.001L120.556 253.937L134.771 262.874C134.771 348.879 249.445 392 249.445 392Z" fill="#CD6116"/>\n<path d="M249.445 382.049C249.445 382.049 364.118 348.879 364.118 262.874L378.333 253.937L364.118 245.001L378.333 236.064L364.118 227.127V209.254V191.381V155.634V119.888L249.445 162.179L134.771 119.888V155.634V173.508V191.381V209.254V227.127L120.556 236.064L134.771 245.001L120.556 253.937L134.771 262.874C134.771 348.879 249.445 382.049 249.445 382.049Z" fill="#E4751F"/>\n<path d="M249.445 370.676C249.445 370.676 364.118 348.879 364.118 262.874L378.333 253.937L364.118 245.001L378.333 236.064L364.118 227.127V209.254V191.381V155.634V119.888L249.445 162.179L134.771 119.888V155.634V173.508V191.381V209.254V227.127L120.556 236.064L134.771 245.001L120.556 253.937L134.771 262.874C134.771 348.879 249.445 370.676 249.445 370.676Z" fill="#F6851B"/>\n<path d="M249.445 352.196C249.445 352.196 364.118 348.879 364.118 262.874L378.333 253.937L364.118 245.001L378.333 236.064L364.118 227.127V209.254V191.381V155.634V119.888C290.105 147.184 208.784 147.184 134.771 119.888V155.634V173.508V191.381V209.254V227.127L120.556 236.064L134.771 245.001L120.556 253.937L134.771 262.874C134.771 348.879 249.445 352.196 249.445 352.196Z" fill="url(#paint0_linear_8_91)"/>\n<defs>\n<filter id="filter0_f_8_91" x="94.9674" y="88.6133" width="308.954" height="310.494" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">\n<feFlood flood-opacity="0" result="BackgroundImageFix"/>\n<feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>\n<feGaussianBlur stdDeviation="12.7941" result="effect1_foregroundBlur_8_91"/>\n</filter>\n<linearGradient id="paint0_linear_8_91" x1="144.012" y1="132.09" x2="425.482" y2="446.967" gradientUnits="userSpaceOnUse">\n<stop stop-color="#F1CA77"/>\n<stop offset="1" stop-color="#F6851B"/>\n</linearGradient>\n</defs>\n</svg>\n',version:"1.1.4"},"npm:@metamask/solana-wallet-snap":{extensionId:null,iconUrl:null,name:"Solana",origin:"npm:@metamask/solana-wallet-snap",subjectType:"snap",svgIcon:'<svg width="101" height="101" viewBox="0 0 101 101" fill="none" xmlns="http://www.w3.org/2000/svg">\n<path d="M100.48 69.3817L83.8068 86.8015C83.4444 87.1799 83.0058 87.4816 82.5185 87.6878C82.0312 87.894 81.5055 88.0003 80.9743 88H1.93563C1.55849 88 1.18957 87.8926 0.874202 87.6912C0.558829 87.4897 0.31074 87.2029 0.160416 86.8659C0.0100923 86.529 -0.0359181 86.1566 0.0280382 85.7945C0.0919944 85.4324 0.263131 85.0964 0.520422 84.8278L17.2061 67.408C17.5676 67.0306 18.0047 66.7295 18.4904 66.5234C18.9762 66.3172 19.5002 66.2104 20.0301 66.2095H99.0644C99.4415 66.2095 99.8104 66.3169 100.126 66.5183C100.441 66.7198 100.689 67.0067 100.84 67.3436C100.99 67.6806 101.036 68.0529 100.972 68.415C100.908 68.7771 100.737 69.1131 100.48 69.3817ZM83.8068 34.3032C83.4444 33.9248 83.0058 33.6231 82.5185 33.4169C82.0312 33.2108 81.5055 33.1045 80.9743 33.1048H1.93563C1.55849 33.1048 1.18957 33.2121 0.874202 33.4136C0.558829 33.6151 0.31074 33.9019 0.160416 34.2388C0.0100923 34.5758 -0.0359181 34.9482 0.0280382 35.3103C0.0919944 35.6723 0.263131 36.0083 0.520422 36.277L17.2061 53.6968C17.5676 54.0742 18.0047 54.3752 18.4904 54.5814C18.9762 54.7875 19.5002 54.8944 20.0301 54.8952H99.0644C99.4415 54.8952 99.8104 54.7879 100.126 54.5864C100.441 54.3849 100.689 54.0981 100.84 53.7612C100.99 53.4242 101.036 53.0518 100.972 52.6897C100.908 52.3277 100.737 51.9917 100.48 51.723L83.8068 34.3032ZM1.93563 21.7905H80.9743C81.5055 21.7907 82.0312 21.6845 82.5185 21.4783C83.0058 21.2721 83.4444 20.9704 83.8068 20.592L100.48 3.17219C100.737 2.90357 100.908 2.56758 100.972 2.2055C101.036 1.84342 100.99 1.47103 100.84 1.13408C100.689 0.79713 100.441 0.510296 100.126 0.308823C99.8104 0.107349 99.4415 1.24074e-05 99.0644 0L20.0301 0C19.5002 0.000878397 18.9762 0.107699 18.4904 0.313848C18.0047 0.519998 17.5676 0.821087 17.2061 1.19848L0.524723 18.6183C0.267681 18.8866 0.0966198 19.2223 0.0325185 19.5839C-0.0315829 19.9456 0.0140624 20.3177 0.163856 20.6545C0.31365 20.9913 0.561081 21.2781 0.875804 21.4799C1.19053 21.6817 1.55886 21.7896 1.93563 21.7905Z" fill="url(#paint0_linear_174_4403)"/>\n<defs>\n<linearGradient id="paint0_linear_174_4403" x1="8.52558" y1="90.0973" x2="88.9933" y2="-3.01622" gradientUnits="userSpaceOnUse">\n<stop offset="0.08" stop-color="#9945FF"/>\n<stop offset="0.3" stop-color="#8752F3"/>\n<stop offset="0.5" stop-color="#5497D5"/>\n<stop offset="0.6" stop-color="#43B4CA"/>\n<stop offset="0.72" stop-color="#28E0B9"/>\n<stop offset="0.97" stop-color="#19FB9B"/>\n</linearGradient>\n</defs>\n</svg>\n',version:"2.4.6"},"npm:@metamask/tron-wallet-snap":{extensionId:null,iconUrl:null,name:"Tron",origin:"npm:@metamask/tron-wallet-snap",subjectType:"snap",svgIcon:'<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" style="enable-background:new 0 0 2680.2 2915.7" viewBox="0 0 2680.2 2915.7"><path d="M1929.1 757.7 332 463.8l840.5 2114.9 1171.1-1426.8-414.5-394.2zm-25.7 129.5 244.3 232.2-668.2 121 423.9-353.2zm-569 329L630.1 632.1l1151.1 211.8-446.8 372.3zm-50.2 103.3-114.8 949.4L550.2 710.7l734 608.8zm106.3 50.4 739.9-134-848.7 1034 108.8-900z" style="fill:#eb0029"/></svg>',version:"1.10.0"}}},SubscriptionController:{subscriptions:[],trialedProducts:[]},SwapsController:{},TokenBalancesController:{tokenBalances:{}},TokenListController:{preventPollingOnNetworkRestart:!1,tokensChainsCache:{}},TokenRatesController:{marketData:{}},TokensController:{allDetectedTokens:{},allIgnoredTokens:{},allTokens:{}},TransactionController:{lastFetchedBlockNumbers:{},methodData:{},submitHistory:[],transactionBatches:[],transactions:[]},UserOperationController:{userOperations:{}},UserStorageController:{isAccountSyncingEnabled:!0,isBackupAndSyncEnabled:!0,isContactSyncingEnabled:!0},config:{},firstTimeInfo:{date:1764061389865,version:"13.12.0"}},meta:{version:183}}}}},{package:"$root$",file:"test/e2e/fixtures/onboarding-fixture.json"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/helpers/seedless-onboarding/mock-web-authenticator.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mockWebAuthenticator=function(){const e=Math.random().toString(36).substring(2,15),t=JSON.stringify({nonce:e});return{generateNonce:()=>e,launchWebAuthFlow:(n,r)=>Promise.resolve(null==r?void 0:r(`https://mock-redirect-url.com?nonce=${e}&state=${t}&code=mock-code`)),generateCodeVerifierAndChallenge:()=>Promise.resolve({codeVerifier:"mock-code-verifier",challenge:"mock-challenge"}),getRedirectURL:()=>"https://mock-redirect-url.com"}}}}},{package:"$root$",file:"test/e2e/helpers/seedless-onboarding/mock-web-authenticator.ts"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/seeder/contracts/entrypoint.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.entrypointBytecode=n.entrypointAbi=void 0;n.entrypointAbi=[{inputs:[{internalType:"uint256",name:"preOpGas",type:"uint256"},{internalType:"uint256",name:"paid",type:"uint256"},{internalType:"uint48",name:"validAfter",type:"uint48"},{internalType:"uint48",name:"validUntil",type:"uint48"},{internalType:"bool",name:"targetSuccess",type:"bool"},{internalType:"bytes",name:"targetResult",type:"bytes"}],name:"ExecutionResult",type:"error"},{inputs:[{internalType:"uint256",name:"opIndex",type:"uint256"},{internalType:"string",name:"reason",type:"string"}],name:"FailedOp",type:"error"},{inputs:[{internalType:"address",name:"sender",type:"address"}],name:"SenderAddressResult",type:"error"},{inputs:[{internalType:"address",name:"aggregator",type:"address"}],name:"SignatureValidationFailed",type:"error"},{inputs:[{components:[{internalType:"uint256",name:"preOpGas",type:"uint256"},{internalType:"uint256",name:"prefund",type:"uint256"},{internalType:"bool",name:"sigFailed",type:"bool"},{internalType:"uint48",name:"validAfter",type:"uint48"},{internalType:"uint48",name:"validUntil",type:"uint48"},{internalType:"bytes",name:"paymasterContext",type:"bytes"}],internalType:"struct IEntryPoint.ReturnInfo",name:"returnInfo",type:"tuple"},{components:[{internalType:"uint256",name:"stake",type:"uint256"},{internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],internalType:"struct IStakeManager.StakeInfo",name:"senderInfo",type:"tuple"},{components:[{internalType:"uint256",name:"stake",type:"uint256"},{internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],internalType:"struct IStakeManager.StakeInfo",name:"factoryInfo",type:"tuple"},{components:[{internalType:"uint256",name:"stake",type:"uint256"},{internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],internalType:"struct IStakeManager.StakeInfo",name:"paymasterInfo",type:"tuple"}],name:"ValidationResult",type:"error"},{inputs:[{components:[{internalType:"uint256",name:"preOpGas",type:"uint256"},{internalType:"uint256",name:"prefund",type:"uint256"},{internalType:"bool",name:"sigFailed",type:"bool"},{internalType:"uint48",name:"validAfter",type:"uint48"},{internalType:"uint48",name:"validUntil",type:"uint48"},{internalType:"bytes",name:"paymasterContext",type:"bytes"}],internalType:"struct IEntryPoint.ReturnInfo",name:"returnInfo",type:"tuple"},{components:[{internalType:"uint256",name:"stake",type:"uint256"},{internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],internalType:"struct IStakeManager.StakeInfo",name:"senderInfo",type:"tuple"},{components:[{internalType:"uint256",name:"stake",type:"uint256"},{internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],internalType:"struct IStakeManager.StakeInfo",name:"factoryInfo",type:"tuple"},{components:[{internalType:"uint256",name:"stake",type:"uint256"},{internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],internalType:"struct IStakeManager.StakeInfo",name:"paymasterInfo",type:"tuple"},{components:[{internalType:"address",name:"aggregator",type:"address"},{components:[{internalType:"uint256",name:"stake",type:"uint256"},{internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],internalType:"struct IStakeManager.StakeInfo",name:"stakeInfo",type:"tuple"}],internalType:"struct IEntryPoint.AggregatorStakeInfo",name:"aggregatorInfo",type:"tuple"}],name:"ValidationResultWithAggregation",type:"error"},{anonymous:!1,inputs:[{indexed:!0,internalType:"bytes32",name:"userOpHash",type:"bytes32"},{indexed:!0,internalType:"address",name:"sender",type:"address"},{indexed:!1,internalType:"address",name:"factory",type:"address"},{indexed:!1,internalType:"address",name:"paymaster",type:"address"}],name:"AccountDeployed",type:"event"},{anonymous:!1,inputs:[],name:"BeforeExecution",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!1,internalType:"uint256",name:"totalDeposit",type:"uint256"}],name:"Deposited",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"aggregator",type:"address"}],name:"SignatureAggregatorChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!1,internalType:"uint256",name:"totalStaked",type:"uint256"},{indexed:!1,internalType:"uint256",name:"unstakeDelaySec",type:"uint256"}],name:"StakeLocked",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!1,internalType:"uint256",name:"withdrawTime",type:"uint256"}],name:"StakeUnlocked",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!1,internalType:"address",name:"withdrawAddress",type:"address"},{indexed:!1,internalType:"uint256",name:"amount",type:"uint256"}],name:"StakeWithdrawn",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"bytes32",name:"userOpHash",type:"bytes32"},{indexed:!0,internalType:"address",name:"sender",type:"address"},{indexed:!0,internalType:"address",name:"paymaster",type:"address"},{indexed:!1,internalType:"uint256",name:"nonce",type:"uint256"},{indexed:!1,internalType:"bool",name:"success",type:"bool"},{indexed:!1,internalType:"uint256",name:"actualGasCost",type:"uint256"},{indexed:!1,internalType:"uint256",name:"actualGasUsed",type:"uint256"}],name:"UserOperationEvent",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"bytes32",name:"userOpHash",type:"bytes32"},{indexed:!0,internalType:"address",name:"sender",type:"address"},{indexed:!1,internalType:"uint256",name:"nonce",type:"uint256"},{indexed:!1,internalType:"bytes",name:"revertReason",type:"bytes"}],name:"UserOperationRevertReason",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!1,internalType:"address",name:"withdrawAddress",type:"address"},{indexed:!1,internalType:"uint256",name:"amount",type:"uint256"}],name:"Withdrawn",type:"event"},{inputs:[],name:"SIG_VALIDATION_FAILED",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"bytes",name:"initCode",type:"bytes"},{internalType:"address",name:"sender",type:"address"},{internalType:"bytes",name:"paymasterAndData",type:"bytes"}],name:"_validateSenderAndPaymaster",outputs:[],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint32",name:"unstakeDelaySec",type:"uint32"}],name:"addStake",outputs:[],stateMutability:"payable",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"}],name:"balanceOf",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"}],name:"depositTo",outputs:[],stateMutability:"payable",type:"function"},{inputs:[{internalType:"address",name:"",type:"address"}],name:"deposits",outputs:[{internalType:"uint112",name:"deposit",type:"uint112"},{internalType:"bool",name:"staked",type:"bool"},{internalType:"uint112",name:"stake",type:"uint112"},{internalType:"uint32",name:"unstakeDelaySec",type:"uint32"},{internalType:"uint48",name:"withdrawTime",type:"uint48"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"}],name:"getDepositInfo",outputs:[{components:[{internalType:"uint112",name:"deposit",type:"uint112"},{internalType:"bool",name:"staked",type:"bool"},{internalType:"uint112",name:"stake",type:"uint112"},{internalType:"uint32",name:"unstakeDelaySec",type:"uint32"},{internalType:"uint48",name:"withdrawTime",type:"uint48"}],internalType:"struct IStakeManager.DepositInfo",name:"info",type:"tuple"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"sender",type:"address"},{internalType:"uint192",name:"key",type:"uint192"}],name:"getNonce",outputs:[{internalType:"uint256",name:"nonce",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"bytes",name:"initCode",type:"bytes"}],name:"getSenderAddress",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{components:[{internalType:"address",name:"sender",type:"address"},{internalType:"uint256",name:"nonce",type:"uint256"},{internalType:"bytes",name:"initCode",type:"bytes"},{internalType:"bytes",name:"callData",type:"bytes"},{internalType:"uint256",name:"callGasLimit",type:"uint256"},{internalType:"uint256",name:"verificationGasLimit",type:"uint256"},{internalType:"uint256",name:"preVerificationGas",type:"uint256"},{internalType:"uint256",name:"maxFeePerGas",type:"uint256"},{internalType:"uint256",name:"maxPriorityFeePerGas",type:"uint256"},{internalType:"bytes",name:"paymasterAndData",type:"bytes"},{internalType:"bytes",name:"signature",type:"bytes"}],internalType:"struct UserOperation",name:"userOp",type:"tuple"}],name:"getUserOpHash",outputs:[{internalType:"bytes32",name:"",type:"bytes32"}],stateMutability:"view",type:"function"},{inputs:[{components:[{components:[{internalType:"address",name:"sender",type:"address"},{internalType:"uint256",name:"nonce",type:"uint256"},{internalType:"bytes",name:"initCode",type:"bytes"},{internalType:"bytes",name:"callData",type:"bytes"},{internalType:"uint256",name:"callGasLimit",type:"uint256"},{internalType:"uint256",name:"verificationGasLimit",type:"uint256"},{internalType:"uint256",name:"preVerificationGas",type:"uint256"},{internalType:"uint256",name:"maxFeePerGas",type:"uint256"},{internalType:"uint256",name:"maxPriorityFeePerGas",type:"uint256"},{internalType:"bytes",name:"paymasterAndData",type:"bytes"},{internalType:"bytes",name:"signature",type:"bytes"}],internalType:"struct UserOperation[]",name:"userOps",type:"tuple[]"},{internalType:"contract IAggregator",name:"aggregator",type:"address"},{internalType:"bytes",name:"signature",type:"bytes"}],internalType:"struct IEntryPoint.UserOpsPerAggregator[]",name:"opsPerAggregator",type:"tuple[]"},{internalType:"address payable",name:"beneficiary",type:"address"}],name:"handleAggregatedOps",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{components:[{internalType:"address",name:"sender",type:"address"},{internalType:"uint256",name:"nonce",type:"uint256"},{internalType:"bytes",name:"initCode",type:"bytes"},{internalType:"bytes",name:"callData",type:"bytes"},{internalType:"uint256",name:"callGasLimit",type:"uint256"},{internalType:"uint256",name:"verificationGasLimit",type:"uint256"},{internalType:"uint256",name:"preVerificationGas",type:"uint256"},{internalType:"uint256",name:"maxFeePerGas",type:"uint256"},{internalType:"uint256",name:"maxPriorityFeePerGas",type:"uint256"},{internalType:"bytes",name:"paymasterAndData",type:"bytes"},{internalType:"bytes",name:"signature",type:"bytes"}],internalType:"struct UserOperation[]",name:"ops",type:"tuple[]"},{internalType:"address payable",name:"beneficiary",type:"address"}],name:"handleOps",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"uint192",name:"key",type:"uint192"}],name:"incrementNonce",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"bytes",name:"callData",type:"bytes"},{components:[{components:[{internalType:"address",name:"sender",type:"address"},{internalType:"uint256",name:"nonce",type:"uint256"},{internalType:"uint256",name:"callGasLimit",type:"uint256"},{internalType:"uint256",name:"verificationGasLimit",type:"uint256"},{internalType:"uint256",name:"preVerificationGas",type:"uint256"},{internalType:"address",name:"paymaster",type:"address"},{internalType:"uint256",name:"maxFeePerGas",type:"uint256"},{internalType:"uint256",name:"maxPriorityFeePerGas",type:"uint256"}],internalType:"struct EntryPoint.MemoryUserOp",name:"mUserOp",type:"tuple"},{internalType:"bytes32",name:"userOpHash",type:"bytes32"},{internalType:"uint256",name:"prefund",type:"uint256"},{internalType:"uint256",name:"contextOffset",type:"uint256"},{internalType:"uint256",name:"preOpGas",type:"uint256"}],internalType:"struct EntryPoint.UserOpInfo",name:"opInfo",type:"tuple"},{internalType:"bytes",name:"context",type:"bytes"}],name:"innerHandleOp",outputs:[{internalType:"uint256",name:"actualGasCost",type:"uint256"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"",type:"address"},{internalType:"uint192",name:"",type:"uint192"}],name:"nonceSequenceNumber",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{components:[{internalType:"address",name:"sender",type:"address"},{internalType:"uint256",name:"nonce",type:"uint256"},{internalType:"bytes",name:"initCode",type:"bytes"},{internalType:"bytes",name:"callData",type:"bytes"},{internalType:"uint256",name:"callGasLimit",type:"uint256"},{internalType:"uint256",name:"verificationGasLimit",type:"uint256"},{internalType:"uint256",name:"preVerificationGas",type:"uint256"},{internalType:"uint256",name:"maxFeePerGas",type:"uint256"},{internalType:"uint256",name:"maxPriorityFeePerGas",type:"uint256"},{internalType:"bytes",name:"paymasterAndData",type:"bytes"},{internalType:"bytes",name:"signature",type:"bytes"}],internalType:"struct UserOperation",name:"op",type:"tuple"},{internalType:"address",name:"target",type:"address"},{internalType:"bytes",name:"targetCallData",type:"bytes"}],name:"simulateHandleOp",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{components:[{internalType:"address",name:"sender",type:"address"},{internalType:"uint256",name:"nonce",type:"uint256"},{internalType:"bytes",name:"initCode",type:"bytes"},{internalType:"bytes",name:"callData",type:"bytes"},{internalType:"uint256",name:"callGasLimit",type:"uint256"},{internalType:"uint256",name:"verificationGasLimit",type:"uint256"},{internalType:"uint256",name:"preVerificationGas",type:"uint256"},{internalType:"uint256",name:"maxFeePerGas",type:"uint256"},{internalType:"uint256",name:"maxPriorityFeePerGas",type:"uint256"},{internalType:"bytes",name:"paymasterAndData",type:"bytes"},{internalType:"bytes",name:"signature",type:"bytes"}],internalType:"struct UserOperation",name:"userOp",type:"tuple"}],name:"simulateValidation",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"unlockStake",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address payable",name:"withdrawAddress",type:"address"}],name:"withdrawStake",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address payable",name:"withdrawAddress",type:"address"},{internalType:"uint256",name:"withdrawAmount",type:"uint256"}],name:"withdrawTo",outputs:[],stateMutability:"nonpayable",type:"function"},{stateMutability:"payable",type:"receive"}],n.entrypointBytecode="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"}}},{package:"$root$",file:"test/e2e/seeder/contracts/entrypoint.ts"}],["/home/runner/work/metamask-extension/metamask-extension/test/e2e/seeder/contracts/simpleAccountFactory.ts",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.simpleAccountFactoryBytecode=n.simpleAccountFactoryAbi=void 0;n.simpleAccountFactoryAbi=[{inputs:[{internalType:"contract IEntryPoint",name:"_entryPoint",type:"address"}],stateMutability:"nonpayable",type:"constructor"},{inputs:[],name:"accountImplementation",outputs:[{internalType:"contract SimpleAccount",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"uint256",name:"salt",type:"uint256"}],name:"createAccount",outputs:[{internalType:"contract SimpleAccount",name:"ret",type:"address"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"uint256",name:"salt",type:"uint256"}],name:"getAccountAddress",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"}],n.simpleAccountFactoryBytecode="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"}}},{package:"$root$",file:"test/e2e/seeder/contracts/simpleAccountFactory.ts"}]],[],{});