LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js",{"./build/multichain-openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json","./build/openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.MultiChainOpenRPCDocument=n.MetaMaskOpenRPCDocument=void 0;const r=s(e("./build/openrpc.json"));n.MetaMaskOpenRPCDocument=r.default;const o=s(e("./build/multichain-openrpc.json"));n.MultiChainOpenRPCDocument=o.default,n.default=r.default}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={"0x12652C6d93FDB6F4f37d48A8687783C782BB0d10":{name:"Entangle",logo:"NGL.svg",erc20:!0,symbol:"NGL",decimals:18},"0xB50721BCf8d664c30412Cfbc6cf7a15145234ad1":{name:"Arbitrum",logo:"Arb.svg",erc20:!0,symbol:"ARB",decimals:18},"0x4D0528598F916Fd1D8dc80e5f54a8fEEDcFd4b18":{name:"Atoshi",logo:"ATOS.svg",erc20:!0,symbol:"ATOS",decimals:18},"0x57B946008913B82E4dF85f501cbAeD910e58D26C":{name:"POND",logo:"POND.svg",erc20:!0,symbol:"POND",decimals:18},"0x5eed99d066a8CaF10f3E4327c1b3D8b673485eED":{name:"SEED",logo:"SEED.svg",erc20:!0,symbol:"SEED",decimals:18},"0x487d62468282Bd04ddf976631C23128A425555EE":{name:"UPCX",logo:"UPC.svg",erc20:!0,symbol:"UPC",decimals:5},"0xd3210F246Ae54C5a45A7b4A83315bf718F591bfc":{name:"ArkiTech",logo:"ARKI.svg",erc20:!0,symbol:"ARKI",decimals:9},"0x7d51888C5ABb7CDfa9cdd6A50673c7F8afAccD7F":{name:"DuckDAO Token",logo:"duckdao.svg",erc20:!0,symbol:"DD",decimals:18},"0x49642110B712C1FD7261Bc074105E9E44676c68F":{name:"DinoLFG",logo:"DINO.svg",erc20:!0,symbol:"DINO",decimals:18},"0xB8BAa0e4287890a5F79863aB62b7F175ceCbD433":{name:"Swerve DAO Token",logo:"swrv.svg",erc20:!0,symbol:"SWRV",decimals:18},"0x8b79656FC38a04044E495e22fAD747126ca305C4":{name:"AgaveCoin",logo:"agvc.svg",erc20:!0,symbol:"AGVC",decimals:18},"0x967da4048cD07aB37855c090aAF366e4ce1b9F48":{name:"Ocean Token",logo:"ocean.svg",erc20:!0,symbol:"OCEAN",decimals:18},"0x83e6f1E41cdd28eAcEB20Cb649155049Fac3D5Aa":{name:"PolkastarterToken",logo:"pols.svg",erc20:!0,symbol:"POLS",decimals:18},"0x08d967bb0134F2d07f7cfb6E246680c53927DD30":{name:"MATH Token",logo:"math.svg",erc20:!0,symbol:"MATH",decimals:18},"0xccC8cb5229B0ac8069C51fd58367Fd1e622aFD97":{name:"Gods Unchained",logo:"gods.svg",erc20:!0,symbol:"GODS",decimals:18},"0xF57e7e7C23978C3cAEC3C3548E3D615c346e79fF":{name:"Immutable X",logo:"imx.svg",erc20:!0,symbol:"IMX",decimals:18},"0x40D16FC0246aD3160Ccc09B8D0D3A2cD28aE6C2f":{name:"Gho Token",logo:"GHO.svg",erc20:!0,symbol:"GHO",decimals:18},"0x536381a8628dBcC8C70aC9A30A7258442eAb4c92":{name:"Pantos Token ",logo:"pan.svg",erc20:!0,symbol:"PAN",decimals:8},"0x011E128Ec62840186F4A07E85E3ACe28858c5606":{name:"Valeria",logo:"val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x6c3ea9036406852006290770BEdFcAbA0e23A0e8":{name:"PayPal USD",logo:"pyusd.svg",erc20:!0,symbol:"PYUSD",decimals:6},"0x8b385Ca3592A5EFc34E0C9fE663de56897F1751F":{name:"INFibit",logo:"INFibit.svg",erc20:!0,symbol:"IBIT",decimals:18},"0x9bf1D7D63dD7a4ce167CF4866388226EEefa702E":{name:"Ben Coin",logo:"BEN.svg",erc20:!0,symbol:"BEN",decimals:18},"0xC7a2572fA8FDB0f7E81d6D3c4e3CCF78FB0DC374":{name:"Bens Finale",logo:"BensFinale.svg",erc20:!0,symbol:"FINALE",decimals:18},"0x99cFB8cBA9c821B4a343c6a1Fc630465C9708DF5":{name:"Pepe Inu",logo:"PepeInu.svg",erc20:!0,symbol:"$PEPEINU",decimals:18},"0xCEBA2a8F6Ec221AEB5f3a7bcd15Cbc7e6a387bfb":{name:"Peter Pan",logo:"PeterPan.svg",erc20:!0,symbol:"PAN",decimals:18},"0x467719aD09025FcC6cF6F8311755809d45a5E5f3":{name:"Axelar",logo:"axelar.svg",erc20:!0,symbol:"AXL",decimals:6},"0x665F77fbA5975ab40Ce61c90F28007fb5b09D7B1":{name:"Genieswap",logo:"Genieswap.svg",erc20:!0,symbol:"GENIE",decimals:18},"0x09E6d500D14D13e0528d2c0fff24E5ffF68237B4":{name:"Dohrnii",logo:"dhn.svg",erc20:!0,symbol:"DHN",decimals:18},"0xaE0585a259A3BCAB258D6EE02FB583f7B33C2a12":{name:"TempleCoin",logo:"tem.svg",erc20:!0,symbol:"TEM",decimals:18},"0xaeDf386B755465871fF874E3E37Af5976E247064":{name:"Fasttoken",logo:"ftn.svg",erc20:!0,symbol:"FTN",decimals:18},"0x7BEF710a5759d197EC0Bf621c3Df802C2D60D848":{name:"SHOPX",logo:"SHOPX.svg",erc20:!0,symbol:"SHOPX",decimals:18},"0xBa3335588D9403515223F109EdC4eB7269a9Ab5D":{name:"Gearbox",logo:"gear.svg",erc20:!0,symbol:"GEAR",decimals:18},"0x9B6B9d2468E165a02FEf69E61B6D3D6CBC0Ac409":{name:"OASISLIFE",logo:"OFE.svg",erc20:!0,symbol:"OFE",decimals:18},"0xdf0162A6B3e9fDf0302c1e949739DeeaFafd8F89":{name:"METAOASIS",logo:"MOA.svg",erc20:!0,symbol:"MOA",decimals:18},"0xe4dae00bc1c46ea2F44ae71B1BEb8b171C15d812":{name:"PREMA",logo:"PREMA.svg",erc20:!0,symbol:"PRMX",decimals:18},"0x1416946162B1C2c871A73B07E932D2fB6C932069":{name:"Energi",logo:"energi.svg",erc20:!0,symbol:"NRG",decimals:18},"0x0d88eD6E74bbFD96B831231638b66C05571e824F":{name:"Aventus",logo:"aventus.svg",erc20:!0,symbol:"AVT",decimals:18},"0x4FC15c91a9c4A9efB404174464687E8e128730C2":{name:"STAT",logo:"STAT.svg",erc20:!0,erc721:!1,symbol:"STAT",decimals:18},"0x4ad7a056191F4c9519fAcd6D75FA94CA26003aCE":{name:"GoldPesa Option",logo:"GPO.svg",erc20:!0,symbol:"GPO",decimals:18},"0x767FE9EDC9E0dF98E07454847909b5E959D7ca0E":{name:"Illuvium",logo:"illuvium.svg",erc20:!0,erc721:!1,symbol:"ILV",decimals:18},"0x85F17Cf997934a597031b2E18a9aB6ebD4B9f6a4":{name:"NEAR",logo:"NEAR.svg",erc20:!0,symbol:"NEAR",decimals:24},"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2":{name:"SushiSwap",logo:"sushi.svg",erc20:!0,erc721:!1,symbol:"SUSHI",decimals:18},"0x881Ba05de1E78f549cC63a8f6Cabb1d4AD32250D":{name:"00",logo:"00.svg",erc20:!0,erc721:!1,symbol:"00",decimals:18},"0xC211477cb4098aC22a98432781f5f26a1E07a4d4":{name:"CULTURED",logo:"CULTURED.svg",erc20:!0,erc721:!1,symbol:"CULTURED",decimals:18},"0x86f2A193b116d1f9C53Ed26d97F77cDC8BcF4c2b":{name:"EHTAGA",logo:"EHTAGA.svg",erc20:!0,erc721:!1,symbol:"EHTAGA",decimals:18},"0x54b79A15b2e2c55c736A66bb0A978fb840407aC8":{name:"FEVER",logo:"FEVER.svg",erc20:!0,erc721:!1,symbol:"FEVER",decimals:18},"0x677c9fE4396D3D13A0F9013a8118eAE386C843A5":{name:"IAM",logo:"IAM.svg",erc20:!0,erc721:!1,symbol:"IAM",decimals:18},"0xf63c65E855020E4B74f0Ad842D9537dA0E6162eC":{name:"ISH",logo:"ISH.svg",erc20:!0,erc721:!1,symbol:"ISH",decimals:18},"0xc105fA46510F32c0444CCdB4e51065da95caA1B4":{name:"LITA",logo:"LITA.svg",erc20:!0,erc721:!1,symbol:"LITA",decimals:18},"0x5401F949cDfa3E5aF32538167c0314230769209C":{name:"MAHCOIN",logo:"MAHCOIN.svg",erc20:!0,erc721:!1,symbol:"MAHCOIN",decimals:18},"0x711D2C47aFf84B96AD0F36983b1c41Be2C509e18":{name:"NIKITA",logo:"NIKITA.svg",erc20:!0,erc721:!1,symbol:"NIKITA",decimals:18},"0x3C44aEc33993b6830e5C2a705ea879b9C9ba0f7c":{name:"NYELA",logo:"NYELA.svg",erc20:!0,erc721:!1,symbol:"NYELA",decimals:18},"0xfa9096c99e687ea8E0064C23DAaCFE87cc99E4Ba":{name:"RON",logo:"RON.svg",erc20:!0,erc721:!1,symbol:"RON",decimals:18},"0x287a7C95aD00bBDd48599Ad2919567fD09281f07":{name:"STEELO",logo:"STEELO.svg",erc20:!0,erc721:!1,symbol:"STEELO",decimals:18},"0x2Ec3275f7aCe4044e499823F511cd58250be8E3d":{name:"Privilege",logo:"prvg.svg",erc20:!0,symbol:"PRVG",decimals:8},"0x65BB569FAaDD324a00883FdE4c46346cc96D5c0A":{name:"Provide",logo:"prvd.svg",erc20:!0,symbol:"PRVD",decimals:8},"0xB4272071eCAdd69d933AdcD19cA99fe80664fc08":{name:"CryptoFranc",logo:"XCHF.svg",erc20:!0,symbol:"XCHF",decimals:18},"0x5aFE3855358E112B5647B952709E6165e1c1eEEe":{name:"Safe Token",logo:"safe-green-token.svg",erc20:!0,symbol:"SAFE",decimals:18},"0x9C8fF314C9Bc7F6e59A9d9225Fb22946427eDC03":{name:"Nouns",erc20:!1,erc721:!0,symbol:"NOUN",decimals:0,logo:"nouns.svg"},"0xBC4CA0EdA7647A8aB7C2061c2E118A18a936f13D":{name:"BoredApeYachtClub",erc20:!1,erc721:!0,symbol:"BAYC",decimals:0,logo:"bayc.svg"},"0x08D7C0242953446436F34b4C78Fe9da38c73668d":{name:"PROOF Collective",erc20:!1,erc721:!0,symbol:"PROOF",decimals:0,logo:"proof.svg"},"0x23581767a106ae21c074b2276D25e5C3e136a68b":{name:"Moonbirds",erc20:!1,erc721:!0,symbol:"MOONBIRD",decimals:0,logo:"moonbirds.svg"},"0x60E4d786628Fea6478F785A6d7e704777c86a7c6":{name:"MutantApeYachtClub",erc20:!1,erc721:!0,symbol:"MAYC",decimals:0,logo:"mayc.svg"},"0x49cF6f5d44E70224e2E23fDcdd2C053F30aDA28B":{name:"CloneX",erc20:!1,erc721:!0,symbol:"CloneX",decimals:0,logo:"clonex.svg"},"0x8a90CAb2b38dba80c64b7734e58Ee1dB38B8992e":{name:"Doodles",erc20:!1,erc721:!0,symbol:"DOODLE",decimals:0,logo:"doodles.svg"},"0xED5AF388653567Af2F388E6224dC7C4b3241C544":{name:"Azuki",erc20:!1,erc721:!0,symbol:"AZUKI",decimals:0,logo:"azuki.svg"},"0xa3AEe8BcE55BEeA1951EF834b99f3Ac60d1ABeeB":{name:"VeeFriends",erc20:!1,erc721:!0,symbol:"VFT",decimals:0,logo:"veefriends.svg"},"0x34d85c9CDeB23FA97cb08333b511ac86E1C4E258":{name:"Otherdeed",erc20:!1,erc721:!0,symbol:"OTHR",decimals:0,logo:"otherdeed.svg"},"0xBBc2AE13b23d715c30720F079fcd9B4a74093505":{name:"Ethernity Chain Token",logo:"ERN.svg",erc20:!0,symbol:"ERN",decimals:18},"0x243cACb4D5fF6814AD668C3e225246efA886AD5a":{name:"Shina Inu",logo:"shina.svg",erc20:!0,symbol:"SHI",decimals:18},"0xD057B63f5E69CF1B929b356b579Cba08D7688048":{name:"CoW Protocol Virtual Token",logo:"vCOW.svg",erc20:!0,symbol:"vCOW",decimals:18},"0xDEf1CA1fb7FBcDC777520aa7f396b4E015F497aB":{name:"CoW Protocol Token",logo:"COW.svg",erc20:!0,symbol:"COW",decimals:18},"0xEd04915c23f00A313a544955524EB7DBD823143d":{name:"Alchemy Pay",logo:"ACH.svg",erc20:!0,symbol:"ACH",decimals:8},"0xeDF6568618A00C6F0908Bf7758A16F76B6E04aF9":{name:"Arianee",logo:"aria20.svg",erc20:!0,symbol:"ARIA20",decimals:18},"0x88D8DA2A8D0fA5b1f4E38030AC486aDE0AFA2798":{name:"Terrapass Coin",logo:"tpsc.svg",erc20:!0,symbol:"TPSC",decimals:18},"0x4730fB1463A6F1F44AEB45F6c5c422427f37F4D0":{name:"The 4th Pillar Token",logo:"four.svg",erc20:!0,symbol:"FOUR",decimals:18},"0x875773784Af8135eA0ef43b5a374AaD105c5D39e":{name:"Idle DAO Token",logo:"idle.svg",erc20:!0,symbol:"IDLE",decimals:18},"0x6BeA7CFEF803D1e3d5f7C0103f7ded065644e197":{name:"Gamma",logo:"Gamma.svg",erc20:!0,symbol:"GAMMA",decimals:18},"0x26805021988F1a45dC708B5FB75Fc75F21747D8c":{name:"xGamma",logo:"xGamma.svg",erc20:!0,symbol:"xGAMMA",decimals:18},"0xc7D9c108D4E1dD1484D3e2568d7f74bfD763d356":{name:"SORA Synthetic USD",logo:"sora-xstusd.svg",erc20:!0,symbol:"XSTUSD",decimals:18},"0x519C1001D550C0a1DaE7d1fC220f7d14c2A521BB":{name:"Polkaswap",logo:"sora-pswap.svg",erc20:!0,symbol:"PSWAP",decimals:18},"0x40FD72257597aA14C7231A7B1aaa29Fce868F677":{name:"SORA",logo:"sora-xor.svg",erc20:!0,symbol:"XOR",decimals:18},"0x909E34d3f6124C324ac83DccA84b74398a6fa173":{name:"$ZKP Token",logo:"ZKP.svg",erc20:!0,erc721:!1,symbol:"$ZKP",decimals:18},"0xe88f8313e61A97cEc1871EE37fBbe2a8bf3ed1E4":{name:"SORA Validator",logo:"sora-val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x7A58c0Be72BE218B41C608b7Fe7C5bB630736C71":{name:"ConstitutionDAO",logo:"PEOPLE.svg",erc20:!0,symbol:"PEOPLE",decimals:18},"0x32E6C34Cd57087aBBD59B5A4AECC4cB495924356":{name:"BitBase",logo:"BTBS.svg",erc20:!0,symbol:"BTBS",decimals:18},"0x3fa400483487A489EC9b1dB29C4129063EEC4654":{name:"Cryptokek.com",logo:"cryptokek.svg",erc20:!0,symbol:"KEK",decimals:18},"0xEd3D4e446A96dC3b181B64B75c3c70dA41dC3CBe":{name:"Vodra",logo:"Vodra.svg",erc20:!0,symbol:"VDR",decimals:18},"0xb753428af26E81097e7fD17f40c88aaA3E04902c":{name:"Spice",logo:"sfi.svg",erc20:!0,symbol:"SFI",decimals:18},"0xd084944d3c05CD115C09d072B9F44bA3E0E45921":{name:"Manifold Finance",logo:"Manifold.svg",erc20:!0,symbol:"FOLD",decimals:18},"0x9a0242b7a33DAcbe40eDb927834F96eB39f8fBCB":{name:"BABB",logo:"bax.svg",erc20:!0,symbol:"BAX",decimals:18},"0x4Cf89ca06ad997bC732Dc876ed2A7F26a9E7f361":{name:"Mysterium",logo:"MYST.svg",erc20:!0,symbol:"MYST",decimals:18},"0x697eF32B4a3F5a4C39dE1cB7563f24CA7BfC5947":{name:"Insula Token",logo:"Insula.svg",erc20:!0,symbol:"ISLA",decimals:18},"0x62Dc4817588d53a056cBbD18231d91ffCcd34b2A":{name:"DeHive",logo:"dehive.svg",erc20:!0,erc721:!1,symbol:"DHV",decimals:18},"0x8400D94A5cb0fa0D041a3788e395285d61c9ee5e":{name:"Unibright",logo:"ubt.svg",erc20:!0,symbol:"UBT",decimals:8},"0xfAd45E47083e4607302aa43c65fB3106F1cd7607":{name:"Hoge Finance",logo:"HogeFinanceLogo.svg",erc20:!0,symbol:"HOGE",decimals:9},"0xBB0E17EF65F82Ab018d8EDd776e8DD940327B28b":{name:"Axie Infinity Shard",logo:"AXS.svg",erc20:!0,symbol:"AXS",decimals:18},"0xCC8Fa225D80b9c7D42F96e9570156c65D6cAAa25":{name:"Smooth Love Potion",logo:"SLP.svg",erc20:!0,symbol:"SLP",decimals:0},"0x10633216E7E8281e33c86F02Bf8e565a635D9770":{name:"Dvision Network",logo:"dvision.svg",erc20:!0,symbol:"DVI",decimals:18},"0x898BAD2774EB97cF6b94605677F43b41871410B1":{name:"vEth2",logo:"vEth2.svg",erc20:!0,symbol:"vEth2",decimals:18},"0x321C2fE4446C7c963dc41Dd58879AF648838f98D":{name:"Cryptex Finance",logo:"ctx.svg",erc20:!0,symbol:"CTX",decimals:18},"0x16c52CeeCE2ed57dAd87319D91B5e3637d50aFa4":{name:"TCAP Token",logo:"tcap.svg",erc20:!0,symbol:"TCAP",decimals:18},"0xE94B97b6b43639E238c851A7e693F50033EfD75C":{name:"Rainbow Token",logo:"halodao-rnbw.svg",erc20:!0,symbol:"RNBW",decimals:18},"0x47BE779De87de6580d0548cde80710a93c502405":{name:"Rainbow Pool",logo:"halodao-xrnbw.svg",erc20:!0,symbol:"xRNBW",decimals:18},"0xe7aE6D0C56CACaf007b7e4d312f9af686a9E9a04":{name:"Vabble",logo:"VAB.svg",erc20:!0,symbol:"VAB",decimals:18},"0x853d955aCEf822Db058eb8505911ED77F175b99e":{name:"Frax",logo:"frax.svg",erc20:!0,symbol:"FRAX",decimals:18},"0x3432B6A60D23Ca0dFCa7761B7ab56459D9C964D0":{name:"Frax Share",logo:"fxs.svg",erc20:!0,symbol:"FXS",decimals:18},"0x84810bcF08744d5862B8181f12d17bfd57d3b078":{name:"SharedStake",logo:"sharedstake.svg",erc20:!0,symbol:"SGT",decimals:18},"0x75387e1287Dd85482aB66102DA9f6577E027f609":{name:"MindsyncAI",logo:"MAI.svg",erc20:!0,symbol:"MAI",decimals:18},"0x196f4727526eA7FB1e17b2071B3d8eAA38486988":{name:"Reserve",logo:"rsv.svg",erc20:!0,symbol:"RSV",decimals:18},"0x320623b8E4fF03373931769A31Fc52A4E78B5d70":{name:"Reserve Rights",logo:"rsr.svg",erc20:!0,symbol:"RSR",decimals:18},"0x1cF4592ebfFd730c7dc92c1bdFFDfc3B9EfCf29a":{name:"WAVES",logo:"waves.svg",erc20:!0,symbol:"WAVES",decimals:18},"0x252739487C1fa66eaeaE7CED41d6358aB2a6bCa9":{name:"ArCoin",logo:"ArCoin.svg",erc20:!0,symbol:"RCOIN",decimals:8},"0x18aAA7115705e8be94bfFEBDE57Af9BFc265B998":{name:"Audius",logo:"audius.svg",erc20:!0,symbol:"AUDIO",decimals:18},"0x8E3BCC334657560253B83f08331d85267316e08a":{name:"Rubic",logo:"brbc.svg",erc20:!0,symbol:"BRBC",decimals:18},"0xca1207647Ff814039530D7d35df0e1Dd2e91Fa84":{name:"dHEDGE DAO Token",logo:"DHT.svg",erc20:!0,symbol:"DHT",decimals:18},"0x6243d8CEA23066d098a15582d81a598b4e8391F4":{name:"Reflexer Ungovernance Token",logo:"flx.svg",erc20:!0,symbol:"FLX",decimals:18},"0x03ab458634910AaD20eF5f1C8ee96F1D6ac54919":{name:"Rai Reflex Index",logo:"rai.svg",erc20:!0,symbol:"RAI",decimals:18},"0xF25c91C87e0B1fd9B4064Af0F427157AaB0193A7":{name:"BASIC Token",logo:"basic.svg",erc20:!0,symbol:"BASIC",decimals:18},"0x53C8395465A84955c95159814461466053DedEDE":{name:"DeGate Token",logo:"DG.svg",erc20:!0,symbol:"DG",decimals:18},"0xBCf9dBf8B14eD096B2BA08b7269356197fDd1b5D":{name:"Avaluse",logo:"avaluse.svg",erc20:!0,symbol:"AVAL",decimals:18},"0x6E765D26388A17A6e86c49A8E41DF3F58aBcd337":{name:"Kangal",logo:"kangal.svg",erc20:!0,symbol:"KANGAL",decimals:18},"0x9AF4f26941677C706cfEcf6D3379FF01bB85D5Ab":{name:"DomRaiderToken",logo:"drt.svg",erc20:!0,symbol:"DRT",decimals:8},"0x06B179e292f080871825beD5D722162fD96B4c95":{name:"10x.gg",logo:"xgg.svg",erc20:!0,symbol:"XGG",decimals:18},"0xF29992D7b589A0A6bD2de7Be29a97A6EB73EaF85":{name:"DMScript",logo:"dmst.svg",erc20:!0,symbol:"DMST",decimals:18},"0x64aa3364F17a4D01c6f1751Fd97C2BD3D7e7f1D5":{name:"Olympus",logo:"OHM.svg",erc20:!0,symbol:"OHM",decimals:9},"0x0ab87046fBb341D058F17CBC4c1133F25a20a52f":{name:"Governance OHM",logo:"gOHM.svg",erc20:!0,symbol:"gOHM",decimals:18},"0xDd1Ad9A21Ce722C151A836373baBe42c868cE9a4":{name:"Universal Basic Income",logo:"ubi.svg",erc20:!0,symbol:"UBI",decimals:18},"0xf293d23BF2CDc05411Ca0edDD588eb1977e8dcd4":{name:"Sylo",logo:"SYLO.svg",erc20:!0,symbol:"SYLO",decimals:18},"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84":{name:"Liquid staked Ether 2.0",logo:"stETH.svg",erc20:!0,symbol:"stETH",decimals:18},"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0":{name:"Wrapped liquid staked Ether 2.0",logo:"wstETH.svg",erc20:!0,symbol:"wstETH",decimals:18},"0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32":{name:"Lido DAO Token",logo:"LDO.svg",erc20:!0,symbol:"LDO",decimals:18},"0xbd31EA8212119f94A611FA969881CBa3EA06Fa3d":{name:"LUNA Token",logo:"Luna.svg",erc20:!0,symbol:"LUNA",decimals:6},"0xa693B19d2931d498c5B318dF961919BB4aee87a5":{name:"UST Token",logo:"UST.svg",erc20:!0,symbol:"UST",decimals:6},"0xd2877702675e6cEb975b4A1dFf9fb7BAF4C91ea9":{name:"LUNA Token - Shuttle",logo:"lunc.svg",erc20:!0,symbol:"LUNC",decimals:18},"0xa47c8bf37f92aBed4A126BDA807A7b7498661acD":{name:"UST Token - Shuttle",logo:"ustc.svg",erc20:!0,symbol:"USTC",decimals:18},"0xcAAfF72A8CbBfc5Cf343BA4e26f65a257065bFF1":{name:"KRT Token - Shuttle",logo:"KRT.svg",erc20:!0,symbol:"KRT-S",decimals:18},"0x676Ad1b33ae6423c6618C1AEcf53BAa29cf39EE5":{name:"SDT Token - Shuttle",logo:"SDT.svg",erc20:!0,symbol:"SDT-S",decimals:18},"0x156B36ec68FdBF84a925230BA96cb1Ca4c4bdE45":{name:"MNT Token - Shuttle",logo:"MNT.svg",erc20:!0,symbol:"MNT-S",decimals:18},"0x09a3EcAFa817268f77BE1283176B946C4ff2E608":{name:"MIR Token - Shuttle",logo:"MIR.svg",erc20:!0,symbol:"MIR-S",decimals:18},"0xd36932143F6eBDEDD872D5Fb0651f4B72Fd15a84":{name:"Mirror AAPL Token - Shuttle",logo:"mAAPL.svg",erc20:!0,symbol:"mAAPL-S",decimals:18},"0x59A921Db27Dd6d4d974745B7FfC5c33932653442":{name:"Mirror GOOGL Token - Shuttle",logo:"mGOOGL.svg",erc20:!0,symbol:"mGOGL-S",decimals:18},"0x21cA39943E91d704678F5D00b6616650F066fD63":{name:"Mirror TSLA Token - Shuttle",logo:"mTSLA.svg",erc20:!0,symbol:"mTSLA-S",decimals:18},"0xC8d674114bac90148d11D3C1d33C61835a0F9DCD":{name:"Mirror NFLX Token - Shuttle",logo:"mNFLX.svg",erc20:!0,symbol:"mNFLX-S",decimals:18},"0x13B02c8dE71680e71F0820c996E4bE43c2F57d15":{name:"Mirror QQQ Token - Shuttle",logo:"mQQQ.svg",erc20:!0,symbol:"mQQQ-S",decimals:18},"0xEdb0414627E6f1e3F082DE65cD4F9C693D78CCA9":{name:"Mirror TWTR Token - Shuttle",logo:"mTWTR.svg",erc20:!0,symbol:"mTWTR-S",decimals:18},"0x41BbEDd7286dAab5910a1f15d12CBda839852BD7":{name:"Mirror MSFT Token - Shuttle",logo:"mMSFT.svg",erc20:!0,symbol:"mMSFT-S",decimals:18},"0x0cae9e4d663793c2a2A0b211c1Cf4bBca2B9cAa7":{name:"Mirror AMZN Token - Shuttle",logo:"mAMZN.svg",erc20:!0,symbol:"mAMZN-S",decimals:18},"0x56aA298a19C93c6801FDde870fA63EF75Cc0aF72":{name:"Mirror BABA Token - Shuttle",logo:"mBABA.svg",erc20:!0,symbol:"mBABA-S",decimals:18},"0x1d350417d9787E000cc1b95d70E9536DcD91F373":{name:"Mirror IAU Token - Shuttle",logo:"mIAU.svg",erc20:!0,symbol:"mIAU-S",decimals:18},"0x9d1555d8cB3C846Bb4f7D5B1B1080872c3166676":{name:"Mirror SLV Token - Shuttle",logo:"mSLV.svg",erc20:!0,symbol:"mSLV-S",decimals:18},"0x31c63146a635EB7465e5853020b39713AC356991":{name:"Mirror USO Token - Shuttle",logo:"mUSO.svg",erc20:!0,symbol:"mUSO-S",decimals:18},"0xf72FCd9DCF0190923Fadd44811E240Ef4533fc86":{name:"Mirror VIXY Token - Shuttle",logo:"mVIXY.svg",erc20:!0,symbol:"mVIXY-S",decimals:18},"0x21BfBDa47A0B4B5b1248c767Ee49F7caA9B23697":{name:"OVR",logo:"OVR.svg",erc20:!0,symbol:"OVR",decimals:18},"0x4691937a7508860F876c9c0a2a617E7d9E945D4B":{name:"Wootrade Network",logo:"wootrade.svg",erc20:!0,symbol:"WOO",decimals:18},"0xaf9f549774ecEDbD0966C52f250aCc548D3F36E5":{name:"RFUEL",logo:"RFUEL.svg",erc20:!0,symbol:"RFUEL",decimals:18},"0x7420B4b9a0110cdC71fB720908340C03F9Bc03EC":{name:"JasmyCoin",logo:"JASMY.svg",erc20:!0,symbol:"JASMY",decimals:18},"0x947AEb02304391f8fbE5B25D7D98D649b57b1788":{name:"Mandala Exchange Token",logo:"mandala.svg",erc20:!0,symbol:"MDX",decimals:18},"0xCdeee767beD58c5325f68500115d4B722b3724EE":{name:"Carbon",logo:"CRBN.svg",erc20:!0,symbol:"CRBN",decimals:18},"0xA4EED63db85311E22dF4473f87CcfC3DaDCFA3E3":{name:"Rubic",logo:"Rubic.svg",erc20:!0,symbol:"RBC",decimals:18},"0x3A880652F47bFaa771908C07Dd8673A787dAEd3A":{name:"DerivaDAO",logo:"DDX.svg",erc20:!0,symbol:"DDX",decimals:18},"0xbC396689893D065F41bc2C6EcbeE5e0085233447":{name:"Perpetual",logo:"PERP.svg",erc20:!0,symbol:"PERP",decimals:18},"0xeca82185adCE47f39c684352B0439f030f860318":{name:"Perlin",logo:"PERL.svg",erc20:!0,symbol:"PERL",decimals:18},"0xA1AFFfE3F4D611d252010E3EAf6f4D77088b0cd7":{name:"Reflect Finance",logo:"RFI.svg",erc20:!0,symbol:"RFI",decimals:9},"0xC0bA369c8Db6eB3924965e5c4FD0b4C1B91e305F":{name:"DLP Duck Token",logo:"dlpducktoken.svg",erc20:!0,symbol:"DUCK",decimals:18},"0xFbEEa1C75E4c4465CB2FCCc9c6d6afe984558E20":{name:"DuckDaoDime",logo:"ddim.svg",erc20:!0,symbol:"DDIM",decimals:18},"0x745407c86DF8DB893011912d3aB28e68B62E49B0":{name:"MahaDAO",logo:"MAHA.svg",erc20:!0,symbol:"MAHA",decimals:18},"0x8CC0F052fff7eaD7f2EdCCcaC895502E884a8a71":{name:"ARTH Valuecoin",logo:"ARTH.svg",erc20:!0,symbol:"ARTH",decimals:18},"0x3231Cb76718CDeF2155FC47b5286d82e6eDA273f":{name:"Monerium EUR",logo:"EURe.svg",erc20:!0,symbol:"EURe",decimals:18},"0x7ba92741Bf2A568abC6f1D3413c58c6e0244F8fD":{name:"Monerium GBP",logo:"GBPe.svg",erc20:!0,symbol:"GBPe",decimals:18},"0xBc5142e0CC5eB16b47c63B0f033d4c2480853a52":{name:"Monerium USD",logo:"USDe.svg",erc20:!0,symbol:"USDe",decimals:18},"0xC642549743A93674cf38D6431f75d6443F88E3E2":{name:"Monerium ISK",logo:"ISKe.svg",erc20:!0,symbol:"ISKe",decimals:18},"0x66a0f676479Cee1d7373f3DC2e2952778BfF5bd6":{name:"WISE Token",logo:"wise.svg",erc20:!0,symbol:"WISE",decimals:18},"0x72F020f8f3E8fd9382705723Cd26380f8D0c66Bb":{name:"PlotX",logo:"plotx.svg",erc20:!0,symbol:"PLOT",decimals:18},"0x44197A4c44D6A059297cAf6be4F7e172BD56Caaf":{name:"ELTCOIN",logo:"ELTCOIN.svg",erc20:!0,symbol:"ELT",decimals:8},"0x6781a0F84c7E9e846DCb84A9a5bd49333067b104":{name:"ZAP TOKEN",logo:"zapicon.svg",erc20:!0,symbol:"ZAP",decimals:18},"0x00c83aeCC790e8a4453e5dD3B0B4b3680501a7A7":{name:"SKALE",logo:"skl.svg",erc20:!0,symbol:"SKL",decimals:18},"0x674C6Ad92Fd080e4004b2312b45f796a192D27a0":{name:"Neutrino USD",logo:"usdn.svg",erc20:!0,symbol:"USDN",decimals:18},"0xE5CAeF4Af8780E59Df925470b050Fb23C43CA68C":{name:"Ferrum Network Token",logo:"frm.svg",erc20:!0,symbol:"FRM",decimals:6},"0x998FFE1E43fAcffb941dc337dD0468d52bA5b48A":{name:"Rupiah Token",logo:"idrt.svg",erc20:!0,symbol:"IDRT",decimals:2},"0x4E15361FD6b4BB609Fa63C81A2be19d873717870":{name:"Fantom",logo:"ftm.svg",erc20:!0,symbol:"FTM",decimals:18},"0x557B933a7C2c45672B610F8954A3deB39a51A8Ca":{name:"REVV",logo:"revv.svg",erc20:!0,symbol:"REVV",decimals:18},"0xFFC97d72E13E01096502Cb8Eb52dEe56f74DAD7B":{name:"Aave AAVE",logo:"aAAVE.svg",erc20:!0,symbol:"aAAVE",decimals:18},"0x05Ec93c0365baAeAbF7AefFb0972ea7ECdD39CF1":{name:"Aave BAT",logo:"aBAT.svg",erc20:!0,symbol:"aBAT",decimals:18},"0xA361718326c15715591c299427c62086F69923D9":{name:"Aave BUSD",logo:"aBUSD.svg",erc20:!0,symbol:"aBUSD",decimals:18},"0x028171bCA77440897B824Ca71D1c56caC55b68A3":{name:"Aave DAI",logo:"aDAI.svg",erc20:!0,symbol:"aDAI",decimals:18},"0xaC6Df26a590F08dcC95D5a4705ae8abbc88509Ef":{name:"Aave ENJ",logo:"aENJ.svg",erc20:!0,symbol:"aENJ",decimals:18},"0xD37EE7e4f452C6638c96536e68090De8cBcdb583":{name:"Aave GUSD",logo:"aGUSD.svg",erc20:!0,symbol:"aGUSD",decimals:2},"0x39C6b3e42d6A679d7D776778Fe880BC9487C2EDA":{name:"Aave KNC",logo:"aKNC.svg",erc20:!0,symbol:"aKNC",decimals:18},"0xa06bC25B5805d5F8d82847D191Cb4Af5A3e873E0":{name:"Aave LINK",logo:"aLINK.svg",erc20:!0,symbol:"aLINK",decimals:18},"0xa685a61171bb30d4072B338c80Cb7b2c865c873E":{name:"Aave MANA",logo:"aMANA.svg",erc20:!0,symbol:"aMANA",decimals:18},"0xc713e5E149D5D0715DcD1c156a020976e7E56B88":{name:"Aave MKR",logo:"aMKR.svg",erc20:!0,symbol:"aMKR",decimals:18},"0xCC12AbE4ff81c9378D670De1b57F8e0Dd228D77a":{name:"Aave REN",logo:"aREN.svg",erc20:!0,symbol:"aREN",decimals:18},"0x35f6B052C598d933D69A4EEC4D04c73A191fE6c2":{name:"Aave SNX",logo:"aSNX.svg",erc20:!0,symbol:"aSNX",decimals:18},"0x6C5024Cd4F8A59110119C56f8933403A539555EB":{name:"Aave SUSD",logo:"aSUSD.svg",erc20:!0,symbol:"aSUSD",decimals:18},"0x101cc05f4A51C0319f570d5E146a8C625198e636":{name:"Aave TUSD",logo:"aTUSD.svg",erc20:!0,symbol:"aTUSD",decimals:18},"0xB9D7CB55f463405CDfBe4E90a6D2Df01C2B92BF1":{name:"Aave UNI",logo:"aUNI.svg",erc20:!0,symbol:"aUNI",decimals:18},"0xBcca60bB61934080951369a648Fb03DF4F96263C":{name:"Aave USDC",logo:"aUSDC.svg",erc20:!0,symbol:"aUSDC",decimals:6},"0x3Ed3B47Dd13EC9a98b44e6204A523E766B225811":{name:"Aave USDT",logo:"aUSDT.svg",erc20:!0,symbol:"aUSDT",decimals:6},"0x9ff58f4fFB29fA2266Ab25e75e2A8b3503311656":{name:"Aave WBTC",logo:"aWBTC.svg",erc20:!0,symbol:"aWBTC",decimals:8},"0x030bA81f1c18d280636F32af80b9AAd02Cf0854e":{name:"Aave WETH",logo:"aWETH.svg",erc20:!0,symbol:"aWETH",decimals:18},"0x5165d24277cD063F5ac44Efd447B27025e888f37":{name:"Aave YFI",logo:"aYFI.svg",erc20:!0,symbol:"aYFI",decimals:18},"0xdef1fac7Bf08f173D286BbBDcBeeADe695129840":{name:"Defi Factory Token",logo:"DEFT.svg",erc20:!0,symbol:"DEFT",decimals:18},"0xDf7FF54aAcAcbFf42dfe29DD6144A69b629f8C9e":{name:"Aave ZRX",logo:"aZRX.svg",erc20:!0,symbol:"aZRX",decimals:18},"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9":{name:"Aave",logo:"AAVE.svg",erc20:!0,symbol:"AAVE",decimals:18},"0x44e2deC86B9F0e0266E9AA66e10323A2bd69CF9A":{name:"Attrace",logo:"attr.svg",erc20:!0,symbol:"ATTR",decimals:18},"0x1Da87b114f35E1DC91F72bF57fc07A768Ad40Bb0":{name:"Equalizer",logo:"EQZ.svg",erc20:!0,symbol:"EQZ",decimals:18},"0x4da27a545c0c5B758a6BA100e3a049001de870f5":{name:"Staked Aave",logo:"stkAAVE.svg",erc20:!0,symbol:"stAAVE",decimals:18},"0xba9d4199faB4f26eFE3551D490E3821486f135Ba":{name:"SwissBorg",logo:"chsb.svg",erc20:!0,symbol:"CHSB",decimals:8},"0x7DD9c5Cba05E151C895FDe1CF355C9A1D5DA6429":{name:"Golem Network Token",logo:"glm.svg",erc20:!0,symbol:"GLM",decimals:18},"0x7240aC91f01233BaAf8b064248E80feaA5912BA3":{name:"OctoFi",logo:"octo.svg",erc20:!0,symbol:"OCTO",decimals:18},"0xff56Cc6b1E6dEd347aA0B7676C85AB0B3D08B0FA":{name:"Orbs",logo:"orbs.svg",erc20:!0,symbol:"ORBS",decimals:18},"0x63f88A2298a5c4AEE3c216Aa6D926B184a4b2437":{name:"GAME Credits",logo:"GAMECreditsLogo.svg",erc20:!0,symbol:"GAME",decimals:18},"0x5150956E082C748Ca837a5dFa0a7C10CA4697f9c":{name:"Zeedex",logo:"zdex.svg",erc20:!0,symbol:"ZDEX",decimals:18},"0x84cA8bc7997272c7CfB4D0Cd3D55cd942B3c9419":{name:"DIAdata",logo:"dia.svg",erc20:!0,symbol:"DIA",decimals:18},"0xb78B3320493a4EFaa1028130C5Ba26f0B6085Ef8":{name:"Dracula",logo:"dracula.svg",erc20:!0,symbol:"DRC",decimals:18},"0xF433089366899D83a9f26A773D59ec7eCF30355e":{name:"Metal",logo:"mtl.svg",erc20:!0,symbol:"MTL",decimals:8},"0x85Eee30c52B0b379b046Fb0F85F4f3Dc3009aFEC":{name:"KEEP",logo:"keep.svg",erc20:!0,symbol:"KEEP",decimals:18},"0x8dAEBADE922dF735c38C80C7eBD708Af50815fAa":{name:"tBTC",logo:"tbtc.svg",erc20:!0,symbol:"TBTC",decimals:18},"0xD7EFB00d12C2c13131FD319336Fdf952525dA2af":{name:"Proton",logo:"proton.svg",erc20:!0,symbol:"XPR",decimals:4},"0x178c820f862B14f316509ec36b13123DA19A6054":{name:"Energy Web Token Bridged",logo:"ewtb.svg",erc20:!0,symbol:"EWTB",decimals:18},"0x2b591e99afE9f32eAA6214f7B7629768c40Eeb39":{name:"HEX",logo:"hex.svg",erc20:!0,symbol:"HEX",decimals:8},"0xFca59Cd816aB1eaD66534D82bc21E7515cE441CF":{name:"Rarible",logo:"rari.svg",erc20:!0,symbol:"RARI",decimals:18},"0x7865af71cf0b288b4E7F654f4F7851EB46a2B7F8":{name:"Sentivate",logo:"sentivate.svg",erc20:!0,symbol:"SNTVT",decimals:18},"0xa3d58c4E56fedCae3a7c43A725aeE9A71F0ece4e":{name:"Metronome",logo:"metronome.svg",erc20:!0,symbol:"MET",decimals:18},"0x49d716DFe60b37379010A75329ae09428f17118d":{name:"PoolTogether Dai",logo:"pldai.svg",erc20:!0,symbol:"PLDAI",decimals:18},"0xfE6892654CBB05eB73d28DCc1Ff938f59666Fe9f":{name:"PoolTogether Sai",logo:"plsai.svg",erc20:!0,symbol:"PLSAI",decimals:18},"0x5732046A883704404F284Ce41FfADd5b007FD668":{name:"Bluzelle Token",logo:"Bluzelle.svg",erc20:!0,symbol:"BLZ",decimals:18},"0xBD87447F48ad729C5c4b8bcb503e1395F62e8B98":{name:"PoolTogether USDC",logo:"plusdc.svg",erc20:!0,symbol:"PLUSDC",decimals:6},"0x69A95185ee2a045CDC4bCd1b1Df10710395e4e23":{name:"$Poolz Finance",logo:"Poolz.svg",erc20:!0,symbol:"POOLZ",decimals:18},"0x0adA190c81b814548ddC2F6AdC4a689ce7C1FE73":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAXIS",decimals:18},"0xb1dC9124c395c1e97773ab855d66E879f053A289":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAX",decimals:18},"0xeF31Cb88048416E301Fee1eA13e7664b887BA7e8":{name:"Staked yAxis",logo:"yaxis.svg",erc20:!0,symbol:"sYAX",decimals:18},"0x28cb7e841ee97947a86B06fA4090C8451f64c0be":{name:"YF Link",logo:"YFL.svg",erc20:!0,symbol:"YFL",decimals:18},"0x75D1aA733920b14fC74c9F6e6faB7ac1EcE8482E":{name:"YFLink Staking Share",logo:"YFL.svg",erc20:!0,symbol:"yYFL",decimals:18},"0x7b760D06E401f85545F3B50c44bf5B05308b7b62":{name:"YFLink USD",logo:"YFLUSD.svg",erc20:!0,symbol:"YFLUSD",decimals:18},"0x8282df223AC402d04B2097d16f758Af4F70e7Db0":{name:"YFLink Synthetic",logo:"sYFL.svg",erc20:!0,symbol:"sYFL",decimals:18},"0x008377EB0C62cE8e0BA3D7Bb4A5638591f21588E":{name:"YFLink Bond",logo:"bYFL.svg",erc20:!0,symbol:"bYFL",decimals:18},"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e":{name:"yearn.finance",logo:"yfi.svg",erc20:!0,symbol:"YFI",decimals:18},"0x261b45D85cCFeAbb11F022eBa346ee8D1cd488c0":{name:"rDAI",logo:"rdai.svg",erc20:!0,symbol:"rDAI",decimals:18},"0xea8b224eDD3e342DEb514C4176c2E72Bcce6fFF9":{name:"rSAI",logo:"rsai.svg",erc20:!0,symbol:"rSAI",decimals:18},"0x12B19D3e2ccc14Da04FAe33e63652ce469b3F2FD":{name:"GridPlus",logo:"GridPlus.svg",erc20:!0,symbol:"GRID",decimals:12},"0xDb05EA0877A2622883941b939f0bb11d1ac7c400":{name:"Opacity",logo:"opct.svg",erc20:!0,symbol:"OPCT",decimals:18},"0x4575f41308EC1483f3d399aa9a2826d74Da13Deb":{name:"Orchid",logo:"OXT.svg",erc20:!0,symbol:"OXT",decimals:18},"0x4CC19356f2D37338b9802aa8E8fc58B0373296E7":{name:"Selfkey",logo:"KEY.svg",erc20:!0,symbol:"KEY",decimals:18},"0x92A5B04D0ED5D94D7a193d1d334D3D16996f4E13":{name:"Eristica",logo:"Eristica.svg",erc20:!0,symbol:"ERT",decimals:18},"0xdAC17F958D2ee523a2206206994597C13D831ec7":{name:"Tether USD",logo:"usdt.svg",erc20:!0,symbol:"USDT",decimals:6},"0x06AF07097C9Eeb7fD685c692751D5C66dB49c215":{name:"Chai",logo:"CHAI.svg",erc20:!0,symbol:"CHAI",decimals:18},"0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828":{name:"UMA",logo:"uma.svg",erc20:!0,symbol:"UMA",decimals:18},"0x5f778ec4B31a506c1Dfd8b06F131E9B451a61D39":{name:"UPX Token",logo:"UPX.svg",erc20:!0,symbol:"UPX",decimals:18},"0xb1CD6e4153B2a390Cf00A6556b0fC1458C4A5533":{name:"ETHBNT Liquidity Pool",logo:"ETHBNT.svg",erc20:!0,symbol:"ETHBNT",decimals:18},"0xf0Ee6b27b759C9893Ce4f094b49ad28fd15A23e4":{name:"Enigma",logo:"enigma.svg",erc20:!0,symbol:"ENG",decimals:8},"0xaaAEBE6Fe48E54f431b0C390CfaF0b017d09D42d":{name:"Celsius",logo:"celsius.svg",erc20:!0,symbol:"CEL",decimals:4},"0xb683D83a532e2Cb7DFa5275eED3698436371cc9f":{name:"BTU",logo:"BTU.svg",erc20:!0,symbol:"BTU",decimals:18},"0x746DdA2ea243400D5a63e0700F190aB79f06489e":{name:"BOSAGORA",logo:"BOA.svg",erc20:!0,symbol:"BOA",decimals:7},"0x5D858bcd53E085920620549214a8b27CE2f04670":{name:"POP Network Token",logo:"POP.svg",erc20:!0,symbol:"POP",decimals:18},"0x048Fe49BE32adfC9ED68C37D32B5ec9Df17b3603":{name:"Skrumble Network V2",logo:"skm.svg",erc20:!0,symbol:"SKM",decimals:18},"0x16EA01aCB4b0Bca2000ee5473348B6937ee6f72F":{name:"Enecuum",logo:"ENQ-logo.svg",erc20:!0,symbol:"ENQ",decimals:10},"0xE5B826Ca2Ca02F09c1725e9bd98d9a8874C30532":{name:"ZEON Network",logo:"ZEON_logo.png",erc20:!0,symbol:"ZEON",decimals:18},"0x13cb85823f78Cff38f0B0E90D3e975b8CB3AAd64":{name:"REMIIT REMI Token",logo:"remi.svg",erc20:!0,symbol:"REMI",decimals:18},"0x93a7174dafd31d13400cD9fa01f4e5B5BAa00D39":{name:"Shaka",logo:"hak.svg",erc20:!0,symbol:"HAK",decimals:18},"0x6fB3e0A217407EFFf7Ca062D46c26E5d60a14d69":{name:"IoTeX",logo:"iotex.svg",erc20:!0,symbol:"IOTX",decimals:18},"0xE5a3229CCb22b6484594973A03a3851dCd948756":{name:"RAE Token",logo:"rae.svg",erc20:!0,symbol:"RAE",decimals:18},"0x4470BB87d77b963A013DB939BE332f927f2b992e":{name:"AdEx Legacy Token",logo:"adex.svg",erc20:!0,symbol:"ADXL",decimals:4},"0xADE00C28244d5CE17D72E40330B1c318cD12B7c3":{name:"AdEx Token",logo:"adex.svg",erc20:!0,symbol:"ADX",decimals:18},"0xDc5864eDe28BD4405aa04d93E05A0531797D9D59":{name:"Falcon",logo:"fnt.svg",erc20:!0,symbol:"FNT",decimals:6},"0x1966d718A565566e8E202792658D7b5Ff4ECe469":{name:"nDEX",logo:"nDEX.png",erc20:!0,symbol:"NDX",decimals:18},"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599":{name:"Wrapped BTC",logo:"wbtc.svg",erc20:!0,symbol:"WBTC",decimals:8},"0x150b0b96933B75Ce27af8b92441F8fB683bF9739":{name:"Dragonereum Gold",logo:"gold.svg",erc20:!0,symbol:"GOLD",decimals:18},"0x82f4dED9Cec9B5750FBFf5C2185AEe35AfC16587":{name:"DreamTeam Token",logo:"dream.svg",erc20:!0,symbol:"DREAM",decimals:6},"0x5d60d8d7eF6d37E16EBABc324de3bE57f135e0BC":{name:"MyBit",logo:"MYB.svg",erc20:!0,symbol:"MYB",decimals:18},"0x01FA555c97D7958Fa6f771f3BbD5CCD508f81e22":{name:"Civil Token",logo:"CVL_token.svg",erc20:!0,symbol:"CVL",decimals:18},"0x5adc961D6AC3f7062D2eA45FEFB8D8167d44b190":{name:"Dether",logo:"dether.svg",erc20:!0,symbol:"DTH",decimals:18},"0x3F17Dd476faF0a4855572F0B6ed5115D9bBA22AD":{name:"Wibson",logo:"wibson-logo.png",erc20:!0,symbol:"WIB",decimals:9},"0xDF347911910b6c9A4286bA8E2EE5ea4a39eB2134":{name:"Bob's Repair",logo:"bobsrepair.png",erc20:!0,symbol:"BOB",decimals:18},"0x3505F494c3f0fed0B594E01Fa41Dd3967645ca39":{name:"SWARM",logo:"swarm.svg",erc20:!0,symbol:"SWM",decimals:18},"0x6863bE0e7CF7ce860A574760e9020D519a8bDC47":{name:"On.Live",logo:"onlive.svg",erc20:!0,symbol:"ONL",decimals:18},"0xea5f88E54d982Cbb0c441cde4E79bC305e5b43Bc":{name:"Pareto",logo:"ParetoLogo.png",erc20:!0,symbol:"PARETO",decimals:18},"0x2e91E3e54C5788e9FdD6A181497FDcEa1De1bcc1":{name:"Hercules",logo:"herc.png",erc20:!0,symbol:"HERC",decimals:18},"0x4946Fcea7C692606e8908002e55A582af44AC121":{name:"FOAM",logo:"FOAM.svg",erc20:!0,symbol:"FOAM",decimals:18},"0x4D807509aECe24C0fa5A102b6a3B059Ec6E14392":{name:"Menlo One",logo:"Menlo_One.png",erc20:!0,symbol:"ONE",decimals:18},"0x27054b13b1B798B345b591a4d22e6562d47eA75a":{name:"AirSwap Token",logo:"AirSwapLogo.svg",erc20:!0,symbol:"AST",decimals:4},"0x8D5682941cE456900b12d47ac06a88b47C764CE1":{name:"RightMesh Token",logo:"Rmesh.png",erc20:!0,symbol:"RMESH",decimals:18},"0xDDe12a12A6f67156e0DA672be05c374e1B0a3e57":{name:"JOYSO",logo:"JOY.png",erc20:!0,symbol:"JOY",decimals:6},"0x0D262e5dC4A06a0F1c90cE79C7a60C09DfC884E4":{name:"JET8 Token",logo:"J8T.svg",erc20:!0,symbol:"J8T",decimals:8},"0x4a220E6096B25EADb88358cb44068A3248254675":{name:"Quant Network",logo:"quant-network.svg",erc20:!0,symbol:"QNT",decimals:18},"0xBC86727E770de68B1060C91f6BB6945c73e10388":{name:"Ink Protocol",logo:"ink_protocol.svg",erc20:!0,symbol:"XNK",decimals:18},"0xa95592DCFfA3C080B4B40E459c5f5692F67DB7F8":{name:"ELY Token",logo:"ely.png",erc20:!0,symbol:"ELY",decimals:18},"0x9E46A38F5DaaBe8683E10793b06749EEF7D733d1":{name:"PolySwarm Nectar",logo:"polyswarm_nectar.svg",erc20:!0,symbol:"NCT",decimals:18},"0xe1A178B681BD05964d3e3Ed33AE731577d9d96dD":{name:"BOX Token",logo:"box_token.png",erc20:!0,symbol:"BOX",decimals:18},"0x543Ff227F64Aa17eA132Bf9886cAb5DB55DCAddf":{name:"DAOstack",logo:"gen.svg",erc20:!0,symbol:"GEN",decimals:18},"0x6aEDbF8dFF31437220dF351950Ba2a3362168d1b":{name:"Dragonglass",logo:"dragonglass.svg",erc20:!0,symbol:"DGS",decimals:8},"0xd26114cd6EE289AccF82350c8d8487fedB8A0C07":{name:"OmiseGO",logo:"omg.svg",erc20:!0,symbol:"OMG",decimals:18},"0x99ea4dB9EE77ACD40B119BD1dC4E33e1C070b80d":{name:"Quantstamp",logo:"qsp.svg",erc20:!0,symbol:"QSP",decimals:18},"0xB64ef51C888972c908CFacf59B47C1AfBC0Ab8aC":{name:"Storj",logo:"storj.svg",erc20:!0,symbol:"STORJ",decimals:8},"0xD8E3FB3b08eBA982F2754988d70D57eDc0055ae6":{name:"Zoracles",logo:"zora.svg",erc20:!0,symbol:"ZORA",decimals:9},"0xF938424F7210f31dF2Aee3011291b658f872e91e":{name:"VISOR",logo:"VISR.svg",erc20:!0,symbol:"VISR",decimals:18},"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942":{name:"Decentraland",logo:"mana.svg",erc20:!0,symbol:"MANA",decimals:18},"0x0F513fFb4926ff82D7F60A05069047AcA295C413":{name:"CrowdstartCoin",logo:"XSC_Logo.svg",erc20:!0,symbol:"XSC",decimals:18},"0x5BC7e5f0Ab8b2E10D2D0a3F21739FCe62459aeF3":{name:"Hut34 Entropy Token",logo:"ENTRP.png",symbol:"ENTRP",erc20:!0,decimals:18},"0x946112efaB61C3636CBD52DE2E1392D7A75A6f01":{name:"HYDRO TOKEN",logo:"hydro.svg",erc20:!0,symbol:"HYDRO",decimals:18},"0x2604FA406Be957E542BEb89E6754fCdE6815e83f":{name:"Playkey Token",logo:"playkey.svg",erc20:!0,symbol:"PKT",decimals:18},"0xE41d2489571d322189246DaFA5ebDe1F4699F498":{name:"0x",logo:"zrx.svg",erc20:!0,symbol:"ZRX",decimals:18},"0x957c30aB0426e0C93CD8241E2c60392d08c6aC8e":{name:"Modum Token",logo:"modum.svg",erc20:!0,symbol:"MOD",decimals:0},"0x1a7a8BD9106F2B8D977E08582DC7d24c723ab0DB":{name:"AppCoins",logo:"appc.svg",erc20:!0,decimals:18,symbol:"APPC"},"0xdB25f211AB05b1c97D595516F45794528a807ad8":{name:"STASIS EURS Token",logo:"stasis-eurs.svg",erc20:!0,decimals:2,symbol:"EURS"},"0xCA0e7269600d353F70b14Ad118A49575455C0f2f":{name:"AMLT",logo:"amlt.png",erc20:!0,decimals:18,symbol:"AMLT"},"0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F":{name:"Synthetix Network Token",logo:"synthetix.svg",erc20:!0,decimals:18,symbol:"SNX"},"0x57Ab1ec28D129707052df4dF418D58a2D46d5f51":{name:"Synth sUSD",logo:"synthetix_susd.svg",erc20:!0,decimals:18,symbol:"SUSD"},"0x5e74C9036fb86BD7eCdcb084a0673EFc32eA31cb":{name:"Synth sETH",logo:"synthetix_seth.svg",erc20:!0,decimals:18,symbol:"SETH"},"0xfE18be6b3Bd88A2D2A7f928d00292E7a9963CfC6":{name:"Synth sBTC",logo:"synthetix_sbtc.svg",erc20:!0,decimals:18,symbol:"SBTC"},"0x0DB8D8b76BC361bAcbB72E2C491E06085A97Ab31":{name:"IQeon",logo:"iqeon.svg",erc20:!0,decimals:18,symbol:"IQN"},"0x000C100050E98C91f9114fa5Dd75CE6869Bf4F53":{name:"CRYPTO10 Hedged",logo:"c10.svg",erc20:!0,symbol:"C10",decimals:18},"0x26E75307Fc0C021472fEb8F727839531F112f317":{name:"Crypto20",logo:"c20.svg",erc20:!0,symbol:"C20",decimals:18},"0x06012c8cf97BEaD5deAe237070F9587f8E7A266d":{name:"Crypto Kitties",logo:"ck.svg",erc20:!1,erc721:!0,symbol:"CK",decimals:0},"0xE477292f1B3268687A29376116B0ED27A9c76170":{name:"Herocoin",logo:"herocoin_logo.png",erc20:!0,symbol:"PLAY",decimals:18},"0x4F4f0Db4de903B88f2B1a2847971E231D54F8fd3":{name:"Geens Platform Token",logo:"gee-icon.svg",erc20:!0,symbol:"GEE",decimals:8},"0xec67005c4E498Ec7f55E092bd1d35cbC47C91892":{name:"Enzyme Finance",logo:"mln.svg",erc20:!0,symbol:"MLN",decimals:18},"0xba2184520A1cC49a6159c57e61E1844E085615B6":{name:"HelloGold Token",logo:"hgt.png",erc20:!0,symbol:"HGT",decimals:8},"0xba358B6f5b4c0215650444B8C30D870B55050D2D":{name:"Hub Token",logo:"hub.svg",erc20:!0,symbol:"HUB",decimals:18},"0x8727c112C712c4a03371AC87a74dD6aB104Af768":{name:"Jetcoin Institute Token",logo:"JETCOIN28.png",erc20:!0,symbol:"JET",decimals:18},"0xf8e386EDa857484f5a12e4B5DAa9984E06E73705":{name:"Indorse Token",logo:"indorseLogo.jpg",erc20:!0,symbol:"IND",decimals:18},"0xA54ddC7B3CcE7FC8b1E3Fa0256D0DB80D2c10970":{name:"NEVERDIE Coin",logo:"ndc.png",erc20:!0,symbol:"NDC",decimals:18},"0x1c4481750daa5Ff521A2a7490d9981eD46465Dbd":{name:"BlockMason Credit Protocol Token",logo:"bcpt.svg",erc20:!0,symbol:"BCPT",decimals:18},"0x20F7A3DdF244dc9299975b4Da1C39F8D5D75f05A":{name:"Sapien Network Token",logo:"spn.svg",erc20:!0,symbol:"SPN",decimals:6},"0xA4e8C3Ec456107eA67d3075bF9e3DF3A75823DB0":{name:"Loom Token",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x42476F744292107e34519F9c357927074Ea3F75D":{name:"Loom",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x4F9254C83EB525f9FCf346490bbb3ed28a81C667":{name:"Celer Network Token",logo:"CELR.svg",erc20:!0,symbol:"CELR",decimals:18},"0x71D01dB8d6a2fBEa7f8d434599C237980C234e4C":{name:"Gladius",logo:"gladius.svg",erc20:!0,symbol:"GLA",decimals:8},"0xdd974D5C2e2928deA5F71b9825b8b646686BD200":{name:"Kyber Network Crystal",logo:"kyber.svg",erc20:!0,symbol:"KNC",decimals:18},"0x1F573D6Fb3F13d689FF844B4cE37794d79a7FF1C":{name:"Bancor Network Token",logo:"bnt.svg",erc20:!0,symbol:"BNT",decimals:18},"0xfa05A73FfE78ef8f1a739473e462c54bae6567D9":{name:"Lunyr Token",logo:"lun.svg",erc20:!0,symbol:"LUN",decimals:18},"0xC741f06082AA47F93729070aD0dD95E223Bda091":{name:"LEDU Token",logo:"edu.svg",erc20:!0,symbol:"LEDU",decimals:8},"0x5c543e7AE0A1104f78406C340E9C64FD9fCE5170":{name:"vSlice",logo:"vslice.png",erc20:!0,symbol:"VSL",decimals:18},"0x1f41E42D0a9e3c0Dd3BA15B527342783B43200A9":{name:"Blockchain Capital",logo:"bcap.svg",erc20:!0,symbol:"BCAP",decimals:0},"0x6531f133e6DeeBe7F2dcE5A0441aA7ef330B4e53":{name:"Chronobank TIME",logo:"chronobank.png",erc20:!0,symbol:"TIME",decimals:8},"0xaAAf91D9b90dF800Df4F55c205fd6989c977E73a":{name:"Monolith TKN",logo:"tkn.svg",erc20:!0,symbol:"TKN",decimals:8},"0x08711D3B02C8758F2FB3ab4e80228418a7F8e39c":{name:"Edgeless",logo:"edg.svg",erc20:!0,symbol:"EDG",decimals:0},"0xf7B098298f7C69Fc14610bf71d5e02c60792894C":{name:"Guppy",logo:"guppy.png",erc20:!0,symbol:"GUP",decimals:3},"0x4DF812F6064def1e5e029f1ca858777CC98D2D81":{name:"Xaurum",logo:"xaurum_logo.svg",erc20:!0,symbol:"XAUR",decimals:8},"0xB9e7F8568e08d5659f5D29C4997173d84CdF2607":{name:"Swarm City Token",logo:"swt.svg",erc20:!0,symbol:"SWT",decimals:18},"0xCb94be6f13A1182E4A4B6140cb7bf2025d28e41B":{name:"Trustcoin",logo:"trst.svg",erc20:!0,symbol:"TRST",decimals:6},"0xCB56b52316041A62B6b5D0583DcE4A8AE7a3C629":{name:"Cigarettes",logo:"cig.svg",erc20:!0,symbol:"CIG",decimals:18},"0x960b236A07cf122663c4303350609A66A7B288C0":{name:"Aragon Network Token v1",logo:"antv1.svg",erc20:!0,symbol:"ANTv1",decimals:18},"0x667088b212ce3d06a1b553a7221E1fD19000d9aF":{name:"WINGS",logo:"wings_logo.svg",erc20:!0,symbol:"WINGS",decimals:18},"0x16484d73Ac08d2355F466d448D2b79D2039F6EBB":{name:"FortKnoxster",logo:"FortKnoxster.svg",erc20:!0,symbol:"FKX",decimals:18},"0xAf30D2a7E90d7DC361c8C4585e9BB7D2F6f15bc7":{name:"FirstBlood Token",logo:"1st.svg",erc20:!0,symbol:"1ST",decimals:18},"0x607F4C5BB672230e8672085532f7e901544a7375":{name:"iExec RLC Token",logo:"rlc.svg",erc20:!0,symbol:"RLC",decimals:9},"0xaeC2E87E0A235266D9C5ADc9DEb4b2E29b54D009":{name:"SingularDTV",logo:"singulardtv.svg",erc20:!0,symbol:"SNGLS",decimals:0},"0x888666CA69E0f178DED6D75b5726Cee99A87D698":{name:"ICONOMI",logo:"iconomi.png",erc20:!0,symbol:"ICN",decimals:18},"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2":{name:"Maker",logo:"mkr.svg",erc20:!0,symbol:"MKR",decimals:18},"0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359":{name:"Sai Stablecoin v1.0",logo:"sai.svg",erc20:!0,symbol:"SAI",decimals:18},"0x6B175474E89094C44Da98b954EedeAC495271d0F":{name:"Dai Stablecoin",logo:"dai.svg",erc20:!0,symbol:"DAI",decimals:18},"0xC477D038d5420C6A9e0b031712f61c5120090de9":{name:"Boson Token",logo:"boson.svg",erc20:!0,symbol:"BOSON",decimals:18},"0xD46bA6D942050d489DBd938a2C909A5d5039A161":{name:"Ampleforth",logo:"ampl.svg",erc20:!0,symbol:"AMPL",decimals:9},"0x4b9278b94a1112cAD404048903b8d343a810B07e":{name:"Hifi Finance",logo:"hifi.svg",erc20:!0,symbol:"HIFI",decimals:18},"0x0D8775F648430679A709E98d2b0Cb6250d2887EF":{name:"Basic Attention Token",logo:"bat.svg",erc20:!0,symbol:"BAT",decimals:18},"0x4D8fc1453a0F359e99c9675954e656D80d996FbF":{name:"BEE Token",logo:"bee_token.svg",erc20:!0,symbol:"BEE",decimals:18},"0x6810e776880C02933D47DB1b9fc05908e5386b96":{name:"Gnosis Token",logo:"gnosis.svg",erc20:!0,symbol:"GNO",decimals:18},"0x514910771AF9Ca656af840dff83E8264EcF986CA":{name:"Chainlink Token",logo:"chainlink.svg",erc20:!0,symbol:"LINK",decimals:18},"0xD8912C10681D8B21Fd3742244f44658dBA12264E":{name:"Pluton",logo:"plutus-god.svg",erc20:!0,symbol:"PLU",decimals:18},"0x1985365e9f78359a9B6AD760e32412f4a445E862":{name:"Reputation Old",logo:"rep.svg",erc20:!0,symbol:"REP",decimals:18},"0x221657776846890989a759BA2973e427DfF5C9bB":{name:"Reputation",logo:"repv2.svg",erc20:!0,symbol:"REPv2",decimals:18},"0xd0929d411954c47438dc1d871dd6081F5C5e149c":{name:"Refereum",logo:"rfr.svg",erc20:!0,symbol:"RFR",decimals:4},"0xb0866289e870D2efc282406cF4123Df6E5BcB652":{name:"NoFakeCoin",logo:"nfticon.png",erc20:!0,symbol:"NFC",decimals:18},"0x2C4e8f2D746113d0696cE89B35F0d8bF88E0AEcA":{name:"Open Simple Token",logo:"OST.svg",erc20:!0,symbol:"OST",decimals:18},"0x408e41876cCCDC0F92210600ef50372656052a38":{name:"Republic Token",logo:"ren.svg",erc20:!0,symbol:"REN",decimals:18},"0xEB4C2781e4ebA804CE9a9803C67d0893436bB27D":{name:"renBTC",logo:"renBTC.svg",erc20:!0,symbol:"renBTC",decimals:8},"0x1C5db575E2Ff833E46a2E9864C22F4B22E0B37C2":{name:"renZEC",logo:"renZEC.svg",erc20:!0,symbol:"renZEC",decimals:8},"0x459086F2376525BdCebA5bDDA135e4E9d3FeF5bf":{name:"renBCH",logo:"renBCH.svg",erc20:!0,symbol:"renBCH",decimals:8},"0xD5147bc8e386d91Cc5DBE72099DAC6C9b99276F5":{name:"renFIL",logo:"renFIL.svg",erc20:!0,symbol:"renFIL",decimals:18},"0xa74476443119A942dE498590Fe1f2454d7D4aC0d":{name:"Golem Network Token",logo:"golem.svg",erc20:!0,symbol:"GNT",decimals:18},"0x6888a16eA9792c15A4DCF2f6C623D055c8eDe792":{name:"Spectiv Signal Token",logo:"spectiv.svg",erc20:!0,symbol:"SIG",decimals:18},"0x9a642d6b3368ddc662CA244bAdf32cDA716005BC":{name:"Qtum",logo:"qtum.svg",erc20:!0,decimals:18,symbol:"QTUM"},"0x1234567461d3f8Db7496581774Bd869C83D51c93":{name:"BitClave",logo:"bitclave.svg",erc20:!0,decimals:18,symbol:"CAT"},"0x7d4b8Cce0591C9044a22ee543533b72E976E36C3":{name:"Change",logo:"change.svg",erc20:!0,decimals:18,symbol:"CAG"},"0x1d462414fe14cf489c7A21CaC78509f4bF8CD7c0":{name:"CanYaCoin",logo:"CanYa.svg",erc20:!0,decimals:6,symbol:"CAN"},"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72":{name:"Ethereum Name Service",logo:"ens.svg",erc20:!0,decimals:18,symbol:"ENS"},"0x3d1BA9be9f66B8ee101911bC36D3fB562eaC2244":{name:"Rivetz",logo:"rivetz.png",erc20:!0,decimals:18,symbol:"RVT"},"0x056017c55aE7AE32d12AeF7C679dF83A85ca75Ff":{name:"Project Wyvern Token",logo:"wyvern-logo.svg",erc20:!0,symbol:"WYV",decimals:18},"0xfec0cF7fE078a500abf15F1284958F22049c2C7e":{name:"Maecenas ART Token",logo:"art.svg",erc20:!0,symbol:"ART",decimals:18},"0x05f4a42e251f2d52b8ed15E9FEdAacFcEF1FAD27":{name:"Zilliqa",logo:"zilliqa.svg",erc20:!0,symbol:"ZIL",decimals:12},"0x986EE2B944c42D017F52Af21c4c69B84DBeA35d8":{name:"BitMartToken",logo:"bitmart.png",erc20:!0,symbol:"BMX",decimals:18},"0xF03f8D65BaFA598611C3495124093c56e8F638f0":{name:"Viewly",logo:"viewly.svg",erc20:!0,symbol:"VIEW",decimals:18},"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2":{name:"Wrapped Ether",logo:"weth.svg",erc20:!0,symbol:"WETH",decimals:18},"0xba5BDe662c17e2aDFF1075610382B9B691296350":{name:"SuperRare Token",logo:"rare.svg",erc20:!0,symbol:"RARE",decimals:18},"0x6C8c6b02E7b2BE14d4fA6022Dfd6d75921D90E4E":{name:"Compound Basic Attention Token",logo:"ctoken-bat.svg",erc20:!0,symbol:"cBAT",decimals:8},"0x70e36f6BF80a52b3B46b3aF8e106CC0ed743E8e4":{name:"Compound Collateral",logo:"ctoken-comp.svg",erc20:!0,symbol:"cCOMP",decimals:8},"0x5d3a536E4D6DbD6114cc1Ead35777bAB948E3643":{name:"Compound Dai",logo:"ctoken-dai.svg",erc20:!0,symbol:"cDAI",decimals:8},"0xF5DCe57282A584D2746FaF1593d3121Fcac444dC":{name:"Compound Sai (Legacy Dai)",logo:"ctoken-sai.svg",erc20:!0,symbol:"cSAI",decimals:8},"0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5":{name:"Compound Ether",logo:"ctoken-eth.svg",erc20:!0,symbol:"cETH",decimals:8},"0x158079Ee67Fce2f58472A96584A73C7Ab9AC95c1":{name:"Compound Augur",logo:"ctoken-rep.svg",erc20:!0,symbol:"cREP",decimals:8},"0x39AA39c021dfbaE8faC545936693aC917d5E7563":{name:"Compound USD Coin",logo:"ctoken-usdc.svg",erc20:!0,symbol:"cUSDC",decimals:8},"0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9":{name:"Compound Tether",logo:"ctoken-usdt.svg",erc20:!0,symbol:"cUSDT",decimals:8},"0xC11b1268C1A384e55C48c2391d8d480264A3A7F4":{name:"Compound Wrapped BTC",logo:"ctoken-wbtc.svg",erc20:!0,symbol:"cWBTC",decimals:8},"0xB3319f5D18Bc0D84dD1b4825Dcde5d5f7266d407":{name:"Compound 0x",logo:"ctoken-zrx.svg",erc20:!0,symbol:"cZRX",decimals:8},"0xc00e94Cb662C3520282E6f5717214004A7f26888":{name:"Compound",logo:"comp.svg",erc20:!0,symbol:"COMP",decimals:18},"0xFFE02ee4C69eDf1b340fCaD64fbd6b37a7b9e265":{name:"NANJCOIN",logo:"nanjcoin.svg",erc20:!0,symbol:"NANJ",decimals:8},"0xB6eD7644C69416d67B522e20bC294A9a9B405B31":{name:"0xBitcoin Token",logo:"0xbitcoin.svg",erc20:!0,symbol:"0xBTC",decimals:8},"0x744d70FDBE2Ba4CF95131626614a1763DF805B9E":{name:"Status Network Token",logo:"snt.svg",erc20:!0,symbol:"SNT",decimals:18},"0x42d6622deCe394b54999Fbd73D108123806f6a18":{name:"SPANK",logo:"spank.svg",erc20:!0,symbol:"SPANK",decimals:18},"0x6B01c3170ae1EFEBEe1a3159172CB3F7A5ECf9E5":{name:"BOOTY",logo:"booty.png",erc20:!0,symbol:"BOOTY",decimals:18},"0x4a6058666cf1057eaC3CD3A5a614620547559fc9":{name:"Brickblock",logo:"Brickblock.svg",erc20:!0,symbol:"BBK",decimals:18},"0x80fB784B7eD66730e8b1DBd9820aFD29931aab03":{name:"ETHLend Token",logo:"lend.svg",erc20:!0,symbol:"LEND",decimals:18},"0x48FF53777F747cFB694101222a944dE070c15D36":{name:"Ether Kingdoms Token",logo:"IMP.svg",erc20:!0,symbol:"IMP",decimals:7},"0x02F61Fd266DA6E8B102D4121f5CE7b992640CF98":{name:"LikeCoin",logo:"like.svg",erc20:!0,symbol:"LIKE",decimals:18},"0xB8c77482e45F1F44dE1745F52C74426C631bDD52":{name:"Binance Coin",logo:"bnb.png",erc20:!0,symbol:"BNB",decimals:18},"0xD850942eF8811f2A866692A623011bDE52a462C1":{name:"VeChain",logo:"ven.svg",erc20:!0,symbol:"VEN",decimals:18},"0x91Af0fBB28ABA7E31403Cb457106Ce79397FD4E6":{name:"Aergo",logo:"Aergo.svg",erc20:!0,symbol:"AERGO",decimals:18},"0x5CA9a71B1d01849C0a95490Cc00559717fCF0D1d":{name:"Aeternity",logo:"aeternity.svg",erc20:!0,symbol:"AE",decimals:18},"0xd4fa1460F537bb9085d22C7bcCB5DD450Ef28e3a":{name:"Populous",logo:"ppt.svg",erc20:!0,symbol:"PPT",decimals:8},"0xFA1a856Cfa3409CFa145Fa4e20Eb270dF3EB21ab":{name:"IOST",logo:"iost.png",erc20:!0,symbol:"IOST",decimals:18},"0x039B5649A59967e3e936D7471f9c3700100Ee1ab":{name:"Kucoin Shares",logo:"kucoin.svg",erc20:!0,symbol:"KCS",decimals:6},"0x3893b9422Cd5D70a81eDeFfe3d5A1c6A978310BB":{name:"Mithril",logo:"mith.svg",erc20:!0,symbol:"MITH",decimals:18},"0xb7cB1C96dB6B22b0D3d9536E0108d062BD488F74":{name:"Walton Token",logo:"wtc.svg",erc20:!0,symbol:"WTC",decimals:18},"0x1776e1F26f98b1A5dF9cD347953a26dd3Cb46671":{name:"Numeraire",logo:"nmr.png",erc20:!0,symbol:"NMR",decimals:18},"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd":{name:"Gemini Dollar",logo:"gusd.svg",erc20:!0,symbol:"GUSD",decimals:2},"0xA4Bdb11dc0a2bEC88d24A3aa1E6Bb17201112eBe":{name:"StableUSD",logo:"usds.svg",erc20:!0,symbol:"USDS",decimals:6},"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48":{name:"USDC",logo:"usdc.svg",erc20:!0,symbol:"USDC",decimals:6},"0x1aBaEA1f7C830bD89Acc67eC4af516284b1bC33c":{name:"EURC",logo:"eurc.svg",erc20:!0,symbol:"EURC",decimals:6},"0x93ED3FBe21207Ec2E8f2d3c3de6e058Cb73Bc04d":{name:"Pinakion Token",logo:"pinakion.svg",erc20:!0,symbol:"PNK",decimals:18},"0x419D0d8BdD9aF5e606Ae2232ed285Aff190E711b":{name:"FunFair",logo:"fun.svg",erc20:!0,symbol:"FUN",decimals:8},"0xcA2796F9F61dc7b238Aab043971e49c6164DF375":{name:"YGGDRASH YEED Token",logo:"yggdrash.svg",erc20:!0,symbol:"YEED",decimals:18},"0x03e3f0c25965f13DbbC58246738C183E27b26a56":{name:"Disciplina Token",logo:"disciplina.svg",erc20:!0,symbol:"DSCP",decimals:18},"0xE814aeE960a85208C3dB542C53E7D4a6C8D5f60F":{name:"Chronologic DAY Token",logo:"DAY.png",erc20:!0,symbol:"DAY",decimals:18},"0x7E43581b19ab509BCF9397a2eFd1ab10233f27dE":{name:"PLATINUM",logo:"plat.png",erc20:!0,symbol:"PLAT",decimals:18},"0x8E870D67F660D95d5be530380D0eC0bd388289E1":{name:"Pax Dollar",logo:"usdp.svg",erc20:!0,symbol:"USDP",decimals:18},"0x45804880De22913dAFE09f4980848ECE6EcbAf78":{name:"PAX Gold",logo:"paxg.svg",erc20:!0,symbol:"PAXG",decimals:18},"0x0000000000085d4780B73119b644AE5ecd22b376":{name:"TrueUSD",logo:"TUSD.svg",erc20:!0,symbol:"TUSD",decimals:18},"0x00000000441378008EA67F4284A57932B1c000a5":{name:"TrueGBP",logo:"TGBP.svg",erc20:!0,symbol:"TGBP",decimals:18},"0x00006100F7090010005F1bd7aE6122c3C2CF0090":{name:"TrueAUD",logo:"TAUD.svg",erc20:!0,symbol:"TAUD",decimals:18},"0x00000100F2A2bd000715001920eB70D229700085":{name:"TrueCAD",logo:"TCAD.svg",erc20:!0,symbol:"TCAD",decimals:18},"0x0000852600CEB001E08e00bC008be620d60031F2":{name:"TrueHKD",logo:"THKD.svg",erc20:!0,symbol:"THKD",decimals:18},"0x4Fabb145d64652a948d72533023f6E7A623C7C53":{name:"Binance USD",logo:"busd.svg",erc20:!0,symbol:"BUSD",decimals:18},"0x23Ccc43365D9dD3882eab88F43d515208f832430":{name:"MidasProtocol",logo:"MAS.png",erc20:!0,symbol:"MAS",decimals:18},"0xC16b542ff490e01fcc0DC58a60e1EFdc3e357cA6":{name:"ICE ROCK MINING",logo:"rock2.png",erc20:!0,symbol:"ROCK2",decimals:0},"0x6758B7d441a9739b98552B373703d8d3d14f9e62":{name:"POA20 Token",logo:"POA20.png",erc20:!0,symbol:"POA20",decimals:18},"0x3DB6Ba6ab6F95efed1a6E794caD492fAAabF294D":{name:"LTO Network Token (old)",logo:"LTO.svg",erc20:!0,symbol:"LTOOLD",decimals:8},"0xd01409314aCb3b245CEa9500eCE3F6Fd4d70ea30":{name:"LTO Network Token",logo:"LTO.svg",erc20:!0,symbol:"LTO",decimals:8},"0xfeF4185594457050cC9c23980d301908FE057Bb1":{name:"VIDT Datalink",logo:"VIDT.svg",erc20:!0,symbol:"VIDT-OLD",decimals:18},"0x3BE7bF1A5F23BD8336787D0289B70602f1940875":{name:"VIDT DAO",logo:"VIDT.svg",erc20:!0,symbol:"VIDT",decimals:18},"0x7064aAb39A0Fcf7221c3396719D0917a65E35515":{name:"Cpollo",logo:"Cpollo.svg",erc20:!0,symbol:"CPLO",decimals:18},"0xd8446236FA95b9b5f9fd0f8E7Df1a944823c683d":{name:"NEEO",logo:"neeo.png",erc20:!0,symbol:"NEEO",decimals:18},"0xA823E6722006afe99E91c30FF5295052fe6b8E32":{name:"Neumark",logo:"neu.svg",erc20:!0,symbol:"NEU",decimals:18},"0x8f693ca8D21b157107184d29D398A8D082b38b76":{name:"Streamr",logo:"streamr.svg",erc20:!0,symbol:"DATA",decimals:18},"0x0Cf0Ee63788A0849fE5297F3407f701E122cC023":{name:"Streamr (old)",logo:"streamr_old.svg",erc20:!0,symbol:"XDATA",decimals:18},"0xA0b73E1Ff0B80914AB6fe0444E65848C4C34450b":{name:"Cronos",logo:"cro.svg",erc20:!0,symbol:"CRO",decimals:8},"0xF70a642bD387F94380fFb90451C2c81d4Eb82CBc":{name:"STAR",logo:"starbase.png",erc20:!0,symbol:"STAR",decimals:18},"0x7C5A0CE9267ED19B22F8cae653F198e3E8daf098":{name:"Santiment",logo:"santiment.svg",erc20:!0,symbol:"SAN",decimals:18},"0x58b6A8A3302369DAEc383334672404Ee733aB239":{name:"Livepeer",logo:"lpt.svg",erc20:!0,symbol:"LPT",decimals:18},"0x6fe56C0bcdD471359019FcBC48863d6c3e9d4F41":{name:"Props",logo:"props.png",erc20:!0,symbol:"PROPS",decimals:18},"0x6c6EE5e31d828De241282B9606C8e98Ea48526E2":{name:"HoloToken",logo:"hot.svg",erc20:!0,symbol:"HOT",decimals:18},"0xF629cBd94d3791C9250152BD8dfBDF380E2a3B9c":{name:"Enjin Coin",logo:"enj.svg",erc20:!0,symbol:"ENJ",decimals:18},"0xbf2179859fc6D5BEE9Bf9158632Dc51678a4100e":{name:"AELF",logo:"elf.svg",erc20:!0,symbol:"ELF",decimals:18},"0x39Bb259F66E1C59d5ABEF88375979b4D20D98022":{name:"WAX Token",logo:"wax.svg",erc20:!0,symbol:"WAX",decimals:8},"0x595832F8FC6BF59c85C527fEC3740A1b7a361269":{name:"PowerLedger",logo:"powr.svg",erc20:!0,symbol:"POWR",decimals:6},"0x28dee01D53FED0Edf5f6E310BF8Ef9311513Ae40":{name:"BlitzPredict",logo:"blitzpredict.svg",erc20:!0,symbol:"XBP",decimals:18},"0x33349B282065b0284d756F0577FB39c158F935e6":{name:"Maple Finance",logo:"maple-finance.svg",erc20:!0,erc721:!1,symbol:"MPL",decimals:18},"0xFBeef911Dc5821886e1dda71586d90eD28174B7d":{name:"KnownOrigin",logo:"knownorigin.svg",erc20:!0,symbol:"KODA",decimals:0},"0x8207c1FfC5B6804F6024322CcF34F29c3541Ae26":{name:"Origin Protocol",logo:"ogn.svg",erc20:!0,symbol:"OGN",decimals:18},"0x2A8e1E676Ec238d8A992307B495b45B3fEAa5e86":{name:"Origin Dollar",logo:"ousd.svg",erc20:!0,symbol:"OUSD",decimals:18},"0x856c4Efb76C1D1AE02e20CEB03A2A6a08b0b8dC3":{name:"Origin Ether",logo:"oeth.svg",erc20:!0,symbol:"OETH",decimals:18},"0x9c354503C38481a7A7a51629142963F98eCC12D0":{name:"Origin DeFi Governance",logo:"ogv.svg",erc20:!0,symbol:"OGV",decimals:18},"0x0C4576Ca1c365868E162554AF8e385dc3e7C66D9":{name:"Vote Escrowed Origin DeFi Governance",logo:"veogv.svg",erc20:!0,symbol:"veOGV",decimals:18},"0x8f8221aFbB33998d8584A2B05749bA73c37a938a":{name:"Request",logo:"request.svg",erc20:!0,symbol:"REQ",decimals:18},"0x2aEa4Add166EBf38b63d09a75dE1a7b94Aa24163":{name:"Kudos",logo:"kudos.svg",erc20:!1,erc721:!0,symbol:"KDO",decimals:0},"0x14C926F2290044B647e1Bf2072e67B495eff1905":{name:"Bethereum",logo:"bether.jpg",erc20:!0,symbol:"BETHER",decimals:18},"0x9AAb071B4129B083B01cB5A0Cb513Ce7ecA26fa5":{name:"Hunt Token",logo:"hunt.png",erc20:!0,symbol:"HUNT",decimals:18},"0xFEF3884b603C33EF8eD4183346E093A173C94da6":{name:"Metamorph",logo:"metamorph.svg",erc20:!0,symbol:"METM",decimals:18},"0x0AbdAce70D3790235af448C88547603b945604ea":{name:"district0x",logo:"district0x.svg",erc20:!0,symbol:"DNT",decimals:18},"0xB26631c6dda06aD89B93C71400D25692de89c068":{name:"Minds",logo:"minds.svg",erc20:!0,symbol:"MINDS",decimals:18},"0xBb1f24C0c1554b9990222f036b0AaD6Ee4CAec29":{name:"CryptoSoul",logo:"SOUL.svg",erc20:!0,symbol:"SOUL",decimals:18},"0xFF0E5e014cf97e0615cb50F6f39Da6388E2FaE6E":{name:"Origo",logo:"origo.svg",erc20:!0,symbol:"OGO",decimals:18},"0x0cB8D0B37C7487b11d57F1f33dEfA2B1d3cFccfE":{name:"DANKToken",logo:"dank-logo.svg",erc20:!0,symbol:"DANK",decimals:18},"0x3a4f40631a4f906c2BaD353Ed06De7A5D3fCb430":{name:"PlayDapp Token",logo:"playdapp.svg",erc20:!0,symbol:"PLA",decimals:18},"0xE9e3F9cfc1A64DFca53614a0182CFAD56c10624F":{name:"Su Squares",logo:"Su-Squares.svg",erc20:!1,erc721:!0,symbol:"SU",decimals:0},"0xfA5047c9c78B8877af97BDcb85Db743fD7313d4a":{name:"ROOK",logo:"Rook.svg",erc20:!0,symbol:"ROOK",decimals:18},"0xa62cc35625B0C8dc1fAEA39d33625Bb4C15bD71C":{name:"StormX",logo:"stormx.svg",erc20:!0,symbol:"STMX",decimals:18},"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0":{name:"Matic Network Token",logo:"matic.svg",erc20:!0,symbol:"MATIC",decimals:18},"0x9992eC3cF6A55b00978cdDF2b27BC6882d88D1eC":{name:"Polymath",logo:"poly.svg",erc20:!0,symbol:"POLY",decimals:18},"0x0a50C93c762fDD6E56D86215C24AaAD43aB629aa":{name:"LGO Token",logo:"lgo.png",erc20:!0,symbol:"LGO",decimals:8},"0xc8Cac7672f4669685817cF332a33Eb249F085475":{name:"LivenCoin",logo:"LVN.svg",erc20:!0,symbol:"LVN",decimals:18},"0xBBbbCA6A901c926F240b89EacB641d8Aec7AEafD":{name:"Loopring",logo:"LRC.svg",erc20:!0,symbol:"LRC",decimals:18},"0x255Aa6DF07540Cb5d3d297f0D0D4D84cb52bc8e6":{name:"Raiden Network Token",logo:"raiden.svg",erc20:!0,symbol:"RDN",decimals:18},"0x66fD97a78d8854fEc445cd1C80a07896B0b4851f":{name:"Lunch Money",logo:"LMY.svg",erc20:!0,symbol:"LMY",decimals:18},"0x679131F591B4f369acB8cd8c51E68596806c3916":{name:"Trustlines Network Token",logo:"TLN128.png",erc20:!0,symbol:"TLN",decimals:18},"0xdcD85914b8aE28c1E62f1C488E1D968D5aaFfE2b":{name:"TOP Network Token",logo:"TOP.svg",erc20:!0,symbol:"TOP",decimals:18},"0xaea46A60368A7bD060eec7DF8CBa43b7EF41Ad85":{name:"Fetch",logo:"fetch.svg",erc20:!0,symbol:"FET",decimals:18},"0x2e1E15C44Ffe4Df6a0cb7371CD00d5028e571d14":{name:"Mettalex",logo:"mettalex.svg",erc20:!0,symbol:"MTLX",decimals:18},"0xf21661D0D1d76d3ECb8e1B9F1c923DBfffAe4097":{name:"Realio Network",logo:"rio.svg",erc20:!0,symbol:"RIO",decimals:18},"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{name:"Uniswap",logo:"uni.svg",erc20:!0,symbol:"UNI",decimals:18},"0x2e6539edc3b76f1E21B71d214527FAbA875F70F3":{name:"Yearn Finance Dot",logo:"YFDOT.svg",erc20:!0,symbol:"YFDOT",decimals:18},"0x9F284E1337A815fe77D2Ff4aE46544645B20c5ff":{name:"Darwinia Commitment Token",logo:"kton.svg",erc20:!0,symbol:"KTON",decimals:18},"0xE48972fCd82a274411c01834e2f031D4377Fa2c0":{name:"TwoKeyEconomy",logo:"2key.svg",erc20:!0,symbol:"2KEY",decimals:18},"0x970B9bB2C0444F5E81e9d0eFb84C8ccdcdcAf84d":{name:"Fuse Token",logo:"fuse.svg",erc20:!0,symbol:"FUSE",decimals:18},"0x0Ae055097C6d159879521C384F1D2123D1f195e6":{name:"STAKE Token",logo:"stake.svg",erc20:!0,symbol:"STAKE",decimals:18},"0x5dc60C4D5e75D22588FA17fFEB90A63E535efCE0":{name:"dKargo",logo:"DKA.svg",erc20:!0,symbol:"DKA",decimals:18},"0x9469D013805bFfB7D3DEBe5E7839237e535ec483":{name:"Darwinia Network Native Token",logo:"ring.svg",erc20:!0,symbol:"RING",decimals:18},"0xA31B1767e09f842ECFd4bc471Fe44F830E3891AA":{name:"ROOBEE",logo:"ROOBEE.svg",erc20:!0,symbol:"ROOBEE",decimals:18},"0xC7e43A1c8E118aA2965F5EAbe0e718D83DB7A63C":{name:"ZCore Token",logo:"zcrt.svg",erc20:!0,symbol:"ZCRT",decimals:18},"0x08d32b0da63e2C3bcF8019c9c5d849d7a9d791e6":{name:"Dentacoin Token",logo:"dcn.svg",erc20:!0,symbol:"DCN",decimals:0},"0xe2f2a5C287993345a840Db3B0845fbC70f5935a5":{name:"mStable USD",logo:"mUSD.svg",erc20:!0,symbol:"mUSD",decimals:18},"0xa3BeD4E1c75D00fa6f4E5E6922DB7261B5E9AcD2":{name:"Meta",logo:"MTA.svg",erc20:!0,symbol:"MTA",decimals:18},"0xe3818504c1B32bF1557b16C238B2E01Fd3149C17":{name:"Pillar",logo:"plr.svg",erc20:!0,symbol:"PLR",decimals:18},"0xba100000625a3754423978a60c9317c58a424e3D":{name:"Balancer (BAL)",logo:"balancer.svg",erc20:!0,symbol:"BAL",decimals:18},"0x8a854288a5976036A725879164Ca3e91d30c6A1B":{name:"Guaranteed Entrance Token",logo:"get-logo.svg",erc20:!0,symbol:"GET",decimals:18},"0x2781246fe707bB15CeE3e5ea354e2154a2877B16":{name:"Elysia",logo:"el.svg",erc20:!0,symbol:"EL",decimals:18},"0x4dA34f8264CB33A5c9F17081B9EF5Ff6091116f4":{name:"Elyfi",logo:"elyfi.svg",erc20:!0,symbol:"ELFI",decimals:18},"0xc12d099be31567add4e4e4d0D45691C3F58f5663":{name:"Auctus",logo:"auc.svg",erc20:!0,symbol:"AUC",decimals:18},"0xdF574c24545E5FfEcb9a659c229253D4111d87e1":{name:"HUSD",logo:"HUSD.svg",erc20:!0,symbol:"HUSD",decimals:8},"0x2ecB13A8c458c379c4d9a7259e202De03c8F3D19":{name:"Block-Chain.com Token",logo:"block-chain.svg",erc20:!0,symbol:"BC",decimals:18},"0x38e4adB44ef08F22F5B5b76A8f0c2d0dCbE7DcA1":{name:"Concentrated Voting Power",logo:"PowerPool.svg",erc20:!0,symbol:"CVP",decimals:18},"0xa117000000f279D81A1D3cc75430fAA017FA5A2e":{name:"Aragon Network Token",logo:"antv2.svg",erc20:!0,symbol:"ANT",decimals:18},"0xDecade1c6Bf2cD9fb89aFad73e4a519C867adcF5":{name:"Experty Wisdom Token",logo:"wisdom-token.svg",erc20:!0,symbol:"WIS",decimals:18},"0x7D85e23014F84E6E21d5663aCD8751bEF3562352":{name:"Axion Old",logo:"obsolete.svg",erc20:!0,symbol:"AXNv1",decimals:18},"0x358AA737e033F34df7c54306960a38d09AaBd523":{name:"Ares Token",logo:"ares.svg",erc20:!0,symbol:"ARES",decimals:18},"0xB62132e35a6c13ee1EE0f84dC5d40bad8d815206":{name:"NEXO",logo:"NEXO.svg",erc20:!0,symbol:"NEXO",decimals:18},"0x4612021C75809160Be60DB21fBc9D6adD0B32deF":{name:"BCP Coin",logo:"BCP.svg",erc20:!0,symbol:"BCP",decimals:18},"0xE9E73E1aE76D17A16cC53E3e87a9a7dA78834d37":{name:"Camp",logo:"Camp.svg",erc20:!0,symbol:"CAMP",decimals:18},"0xdacD69347dE42baBfAEcD09dC88958378780FB62":{name:"Atari Token",logo:"atrilast.svg",erc20:!0,symbol:"ATRI",decimals:0},"0x71F85B2E46976bD21302B64329868fd15eb0D127":{name:"Axion",logo:"axion.svg",erc20:!0,symbol:"AXN",decimals:18},"0xc944E90C64B2c07662A292be6244BDf05Cda44a7":{name:"Graph Token",logo:"graphToken.svg",erc20:!0,symbol:"GRT",decimals:18},"0xFE3E6a25e6b192A42a44ecDDCd13796471735ACf":{name:"Reef Finance",logo:"reef.svg",erc20:!0,symbol:"REEF",decimals:18},"0x43Dfc4159D86F3A37A5A4B3D4580b888ad7d4DDd":{name:"DODO bird",logo:"DODO.svg",erc20:!0,symbol:"DODO",decimals:18},"0x4a615bB7166210CCe20E6642a6f8Fb5d4D044496":{name:"NAOS Finance",logo:"naos.svg",erc20:!0,symbol:"NAOS",decimals:18},"0x111111111117dC0aa78b770fA6A738034120C302":{name:"1INCH Token",logo:"1inch.svg",erc20:!0,symbol:"1INCH",decimals:18},"0x27702a26126e0B3702af63Ee09aC4d1A084EF628":{name:"Aleph.im Token",logo:"aleph.svg",erc20:!0,symbol:"ALEPH",decimals:18},"0x32a7C02e79c4ea1008dD6564b35F131428673c41":{name:"CRUST",logo:"crust.svg",erc20:!0,symbol:"CRU",decimals:18},"0x3472A5A71965499acd81997a54BBA8D852C6E53d":{name:"BADGER",logo:"badger.svg",erc20:!0,symbol:"BADGER",decimals:18},"0x65Def5029A0e7591e46B38742bFEdd1Fb7b24436":{name:"Kanpeki",logo:"kanpeki-green.svg",erc20:!0,symbol:"KAE",decimals:18},"0xF94b5C5651c888d928439aB6514B93944eEE6F48":{name:"Yield App",logo:"yield-app.svg",erc20:!0,symbol:"YLD",decimals:18},"0xDcB01cc464238396E213a6fDd933E36796eAfF9f":{name:"Yield",logo:"yield-logo.svg",erc20:!0,symbol:"YLD",decimals:18},"0x968F6f898a6Df937fC1859b323aC2F14643e3fED":{name:"Newscrypto",logo:"NWC.svg",erc20:!0,symbol:"NWC",decimals:18},"0xeb269732ab75A6fD61Ea60b06fE994cD32a83549":{name:"dForce USDx",logo:"USDx.svg",erc20:!0,symbol:"USDx",decimals:18},"0x6e0daDE58D2d89eBBe7aFc384e3E4f15b70b14D8":{name:"QuiverX",logo:"quiverx.svg",erc20:!0,symbol:"QRX",decimals:18},"0x0beAD9a1bcc1b84D06E3f2df67E3549Fd55aB054":{name:"EURxb",logo:"eurxb.svg",erc20:!0,symbol:"EURxb",decimals:18},"0x9F9c8ec3534c3cE16F928381372BfbFBFb9F4D24":{name:"GraphLinq",logo:"glq.svg",erc20:!0,symbol:"GLQ",decimals:18},"0xEB58343b36C7528F23CAAe63a150240241310049":{name:"NBU",logo:"NBU.svg",erc20:!0,symbol:"NBU",decimals:18},"0x16ECCfDbb4eE1A85A33f3A9B21175Cd7Ae753dB4":{name:"Route",logo:"route.svg",erc20:!0,symbol:"ROUTE",decimals:18},"0x75739d5944534115d7C54ee8C73F186D793BAE02":{name:"Collective",logo:"CO2.svg",erc20:!0,symbol:"CO2",decimals:18},"0x35bD01FC9d6D5D81CA9E055Db88Dc49aa2c699A8":{name:"FWB Pro",logo:"FWB.svg",erc20:!0,symbol:"FWB",decimals:18},"0x9B99CcA871Be05119B2012fd4474731dd653FEBe":{name:"Antimatter",logo:"antimatter.svg",erc20:!0,symbol:"MATTER",decimals:18},"0x6De037ef9aD2725EB40118Bb1702EBb27e4Aeb24":{name:"Render Token",logo:"RNDR.svg",erc20:!0,symbol:"RNDR",decimals:18},"0xDf49C9f599A0A9049D97CFF34D0C30E468987389":{name:"SaTT",logo:"SaTT.svg",erc20:!0,symbol:"SATT",decimals:18},"0x431ad2ff6a9C365805eBaD47Ee021148d6f7DBe0":{name:"dForce",logo:"DF.svg",erc20:!0,symbol:"DF",decimals:18},"0x6e1A19F235bE7ED8E3369eF73b196C07257494DE":{name:"Wrapped Filecoin",logo:"WFIL.svg",erc20:!0,symbol:"WFIL",decimals:18},"0xE452E6Ea2dDeB012e20dB73bf5d3863A3Ac8d77a":{name:"Wrapped Celo",logo:"WCELO.svg",erc20:!0,symbol:"wCELO",decimals:18},"0x4A64515E5E1d1073e83f30cB97BEd20400b66E10":{name:"Wrapped ZEC",logo:"WZEC.svg",erc20:!0,symbol:"WZEC",decimals:18},"0xA3865E64121537b5b59B5e239Db4aCBe6F36aa74":{name:"Wrapped Tezos",logo:"WXTZ.svg",erc20:!0,symbol:"WXTZ",decimals:18},"0x53c4871322Bb47e7A24136fce291a6dcC832a294":{name:"Wrapped Litecoin",logo:"WLTC.svg",erc20:!0,symbol:"WLTC",decimals:18},"0xad3E3Fc59dff318BecEaAb7D00EB4F68b1EcF195":{name:"Wrapped Celo USD",logo:"WCUSD.svg",erc20:!0,symbol:"wCUSD",decimals:18},"0x85D7bdfc9c3426b33A684241eEEE70385Bc42820":{name:"Wrapped Kadena",logo:"WKDA.svg",erc20:!0,symbol:"WKDA",decimals:18},"0x39fBBABf11738317a448031930706cd3e612e1B9":{name:"Wrapped XRP",logo:"WXRP.svg",erc20:!0,symbol:"WXRP",decimals:18},"0xBBC7f7A6AADAc103769C66CBC69AB720f7F9Eae3":{name:"INX Token",logo:"INX.svg",erc20:!0,symbol:"INX",decimals:18},"0x1b40183EFB4Dd766f11bDa7A7c3AD8982e998421":{name:"Vesper",logo:"vsp.svg",erc20:!0,symbol:"VSP",decimals:18},"0x544c42fBB96B39B21DF61cf322b5EDC285EE7429":{name:"InsurAce",logo:"INSUR.svg",erc20:!0,symbol:"INSUR",decimals:18},"0xcC665390b03c5D324D8fAF81C15eCee29A73bCB4":{name:"ChainSwap.com Governance Token",logo:"chainswap.svg",erc20:!0,symbol:"ASAP",decimals:18},"0x182F4c4C97cd1c24E1Df8FC4c053E5C47bf53Bef":{name:"keyTango Token",logo:"keyTango.svg",erc20:!0,symbol:"TANGO",decimals:18},"0x0275E1001e293C46CFe158B3702AADe0B99f88a5":{name:"Oiler",logo:"oiler.svg",erc20:!0,symbol:"OIL",decimals:18},"0xDe30da39c46104798bB5aA3fe8B9e0e1F348163F":{name:"Gitcoin",logo:"gtc.svg",erc20:!0,symbol:"GTC",decimals:18},"0x1796ae0b0fa4862485106a0de9b654eFE301D0b2":{name:"Polychain Monsters",logo:"PMON.svg",erc20:!0,symbol:"PMON",decimals:18},"0x8eEF5a82E6Aa222a60F009ac18c24EE12dBf4b41":{name:"Tixl",logo:"TXL.svg",erc20:!0,symbol:"TXL",decimals:18},"0x5218E472cFCFE0b64A064F055B43b4cdC9EfD3A6":{name:"unFederalReserve Token",logo:"eRSDL.svg",erc20:!0,symbol:"eRSDL",decimals:18},"0xE4cC5A22B39fFB0A56d67F94f9300db20D786a5F":{name:"unFederal eRSDL",logo:"uneRSDL.svg",erc20:!0,symbol:"uneRSDL",decimals:8},"0x2dbA05B51eF5A7DE3E7c3327201CA2F8a25C2414":{name:"unFederal DAI",logo:"unDAI.svg",erc20:!0,symbol:"unDAI",decimals:8},"0xFaCecE87e14B50eafc85C44C01702F5f485CA460":{name:"unFederal ETH",logo:"unETH.svg",erc20:!0,symbol:"unETH",decimals:8},"0x6b576972de33BebDe3A703BfF52a091e79f8c87A":{name:"unFederal USDC",logo:"unUSDC.svg",erc20:!0,symbol:"unUSDC",decimals:8},"0x6e2aA5bB90ac37D9006685AFc651ef067E1c7b44":{name:"unFederal USDT",logo:"unUSDT.svg",erc20:!0,symbol:"unUSDT",decimals:8},"0x5D446FC8DBd10EBAcfE9A427aB5402586af98cD4":{name:"unFederal WBTC",logo:"unWBTC.svg",erc20:!0,symbol:"unWBTC",decimals:8},"0xD837eCa6C91c67D98461A411BA2f00bdA9960a9D":{name:"unFederal AAVE",logo:"unAAVE.svg",erc20:!0,symbol:"unAAVE",decimals:8},"0x9e29Ce9cD25F4141dF6BB85b27Ef6933a16A5824":{name:"unFederal YFI",logo:"unYFI.svg",erc20:!0,symbol:"unYFI",decimals:8},"0x031002d15B0D0Cd7c9129d6F644446368deaE391":{name:"unFederal LINK",logo:"unLINK.svg",erc20:!0,symbol:"unLINK",decimals:8},"0xB8E2e2101eD11e9138803cd3e06e16dd19910647":{name:"ArdCoin",logo:"ardcoin.svg",erc20:!0,symbol:"ARDX",decimals:2},"0x6D0F5149c502faf215C89ab306ec3E50b15e2892":{name:"Portion Token",logo:"PRT.svg",erc20:!0,symbol:"PRT",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"3SPACE ART",logo:"3SPACE.svg",erc20:!0,symbol:"PACE",decimals:18},"0x3845badAde8e6dFF049820680d1F14bD3903a5d0":{name:"SAND",logo:"SAND.svg",erc20:!0,symbol:"SAND",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"Spacelens",logo:"SPACE.svg",erc20:!0,symbol:"SPACE",decimals:18},"0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a":{name:"Sandbox's LANDs",logo:"SAND.svg",erc20:!1,erc721:!0,symbol:"LAND",decimals:0},"0x362bc847A3a9637d3af6624EeC853618a43ed7D2":{name:"PARSIQ",logo:"parsiq.svg",erc20:!0,symbol:"PRQ",decimals:18},"0x21381e026Ad6d8266244f2A583b35F9E4413FA2a":{name:"Formation Finance",logo:"form.svg",erc20:!0,symbol:"FORM",decimals:18},"0x2ba592F78dB6436527729929AAf6c908497cB200":{name:"Cream",logo:"cream.svg",erc20:!0,symbol:"CREAM",decimals:18},"0x46576e20EC5F25586A6Fa2E0d6B6058354B72E72":{name:"Cryptomind",logo:"CR.svg",erc20:!0,erc721:!1,symbol:"CR",decimals:8},"0x5ab21Ec0bfa0B29545230395e3Adaca7d552C948":{name:"PUNKS Comic",logo:"punks-comic.svg",erc20:!1,erc721:!0,symbol:"COMIC",decimals:0},"0x9C2dc0c3CC2BADdE84B0025Cf4df1c5aF288D835":{name:"Coreto",logo:"coreto.svg",erc20:!0,symbol:"COR",decimals:18},"0x0De05F6447ab4D22c8827449EE4bA2D5C288379B":{name:"OOKI",logo:"ooki.svg",erc20:!0,symbol:"OOKI",decimals:18},"0x6B4c7A5e3f0B99FCD83e9c089BDDD6c7FCe5c611":{name:"Million",logo:"million.svg",erc20:!0,symbol:"MM",decimals:18},"0x56d811088235F11C8920698a204A5010a788f4b3":{name:"bZx Protocol Token (BZRX)",logo:"ic_token_bzrx.svg",erc20:!0,symbol:"BZRX",decimals:18},"0xB72B31907C1C95F3650b64b2469e08EdACeE5e8F":{name:"bZx Vesting Token (vBZRX)",logo:"ic_token_vbzrx.svg",erc20:!0,symbol:"vBZRX",decimals:18},"0x3085154623F51b00Dedfc6Ceeb5197277A66B17B":{name:"NIFTY",logo:"nfty.svg",erc20:!0,symbol:"NFTY",decimals:18},"0xB983E01458529665007fF7E0CDdeCDB74B967Eb6":{name:"Fulcrum ETH iToken (iETH)",logo:"ic_token_ieth.svg",erc20:!0,symbol:"iETH",decimals:18},"0x32E4c68B3A4a813b710595AebA7f6B7604Ab9c15":{name:"Fulcrum USDC iToken (iUSDC)",logo:"ic_token_iusdc.svg",erc20:!0,symbol:"iUSDC",decimals:6},"0x2ffa85f655752fB2aCB210287c60b9ef335f5b6E":{name:"Fulcrum WBTC iToken (iWBTC)",logo:"ic_token_ibtc.svg",erc20:!0,symbol:"iWBTC",decimals:8},"0x687642347a9282Be8FD809d8309910A3f984Ac5a":{name:"Fulcrum KNC iToken (iKNC)",logo:"ic_token_iknc.svg",erc20:!0,symbol:"iKNC",decimals:18},"0x463538705E7d22aA7f03Ebf8ab09B067e1001B54":{name:"Fulcrum LINK iToken (iLINK)",logo:"ic_token_ilink.svg",erc20:!0,symbol:"iLINK",decimals:18},"0x6b093998D36f2C7F0cc359441FBB24CC629D5FF0":{name:"Fulcrum DAI iToken (iDAI)",logo:"ic_token_idai.svg",erc20:!0,symbol:"iDAI",decimals:18},"0x7e9997a38A439b2be7ed9c9C4628391d3e055D48":{name:"Fulcrum USDT iToken (iUSDT)",logo:"ic_token_iusdt.svg",erc20:!0,symbol:"iUSDT",decimals:6},"0x9189c499727f88F8eCC7dC4EEA22c828E6AaC015":{name:"Fulcrum MKR iToken (iMKR)",logo:"ic_token_imkr.svg",erc20:!0,symbol:"iMKR",decimals:18},"0x18240BD9C07fA6156Ce3F3f61921cC82b2619157":{name:"Fulcrum BZRX iToken (iBZRX)",logo:"ic_token_ibzrx.svg",erc20:!0,symbol:"iBZRX",decimals:18},"0x7F3Fe9D492A9a60aEBb06d82cBa23c6F32CAd10b":{name:"Fulcrum YFI iToken (iYFI)",logo:"ic_token_iyfi.svg",erc20:!0,symbol:"iYFI",decimals:18},"0x0a625FceC657053Fe2D9FFFdeb1DBb4e412Cf8A8":{name:"Fulcrum UNI iToken (iUNI)",logo:"ic_token_iuni.svg",erc20:!0,symbol:"iUNI",decimals:18},"0x0cae8d91E0b1b7Bd00D906E990C3625b2c220db1":{name:"Fulcrum AAVE iToken (iAAVE)",logo:"ic_token_iaave.svg",erc20:!0,symbol:"iAAVE",decimals:18},"0x3dA0e01472Dee3746b4D324a65D7EdFaECa9Aa4f":{name:"Fulcrum LRC iToken (iLRC)",logo:"ic_token_ilrc.svg",erc20:!0,symbol:"iLRC",decimals:18},"0x6d29903BC2c4318b59B35d97Ab98ab9eC08Ed70D":{name:"Fulcrum COMP iToken (iCOMP)",logo:"ic_token_icomp.svg",erc20:!0,symbol:"iCOMP",decimals:18},"0x08c32b0726C5684024ea6e141C50aDe9690bBdcc":{name:"Stratos Token",logo:"stos.svg",erc20:!0,symbol:"STOS",decimals:18},"0xe28b3B32B6c345A34Ff64674606124Dd5Aceca30":{name:"Injective",logo:"inj.svg",erc20:!0,symbol:"INJ",decimals:18},"0xe516D78d784C77D479977BE58905B3f2b1111126":{name:"Bitspawn",logo:"spwn.svg",erc20:!0,symbol:"SPWN",decimals:18},"0xB16e967ff83DE3F1e9FCeAfbc2C28c1c5c56eF91":{name:"Polkadog",logo:"polkadog.svg",erc20:!0,symbol:"PDOG",decimals:18},"0x07c52c2537D84e532a9F15d32E152C8B94D2b232":{name:"ZkTube",logo:"ZKT.svg",erc20:!0,symbol:"ZKT",decimals:18},"0xF4d861575ecC9493420A3f5a14F85B13f0b50EB3":{name:"Fractal Protocol",logo:"fractal.svg",erc20:!0,symbol:"FCL",decimals:18},"0x3af33bEF05C2dCb3C7288b77fe1C8d2AeBA4d789":{name:"Kromatika",logo:"krom.svg",erc20:!0,symbol:"KROM",decimals:18},"0xA130E3a33a4d84b04c3918c4E5762223Ae252F80":{name:"Swash Token",logo:"swash.svg",erc20:!0,symbol:"SWASH",decimals:18},"0xea7Cc765eBC94C4805e3BFf28D7E4aE48D06468A":{name:"NearPad Token",logo:"nearpad.svg",erc20:!0,symbol:"PAD",decimals:18},"0x87C22615435998D69ACA34889D03155B694a94fc":{name:"DiemLibre",logo:"DLB.svg",erc20:!0,symbol:"DLB",decimals:18},"0x4d224452801ACEd8B2F0aebE155379bb5D594381":{name:"ApeCoin",logo:"APE.svg",erc20:!0,symbol:"APE",decimals:18},"0xCd1fAFf6e578Fa5cAC469d2418C95671bA1a62Fe":{name:"Torum Token",logo:"torum.svg",erc20:!0,symbol:"XTM",decimals:18},"0xcf0C122c6b73ff809C693DB761e7BaeBe62b6a2E":{name:"FLOKI",logo:"floki.svg",erc20:!0,symbol:"FLOKI",decimals:9},"0xe831F96A7a1DcE1aa2EB760b1e296c6A74CaA9d5":{name:"Nexum Coin",logo:"nexum.svg",erc20:!0,symbol:"Nexm",decimals:8},"0x6710c63432A2De02954fc0f851db07146a6c0312":{name:"MFG",logo:"mfg.svg",erc20:!0,symbol:"MFG",decimals:18},"0xae78736Cd615f374D3085123A210448E74Fc6393":{name:"Rocket Pool ETH",logo:"rETH.svg",erc20:!0,symbol:"rETH",decimals:18},"0x0C10bF8FcB7Bf5412187A595ab97a3609160b5c6":{name:"Decentralized USD",logo:"USDD.svg",erc20:!0,symbol:"USDD",decimals:18},"0xD33526068D116cE69F19A9ee46F0bd304F21A51f":{name:"Rocket Pool",logo:"rpl.svg",erc20:!0,symbol:"RPL",decimals:18},"0x9d38F670D15C14716BE1F109a4F453E966A2B6D4":{name:"Quid Ika",logo:"QuidIka.svg",erc20:!0,symbol:"QUID",decimals:9},"0xD3c625F54dec647DB8780dBBe0E880eF21BA4329":{name:"HollaEx Token",logo:"xht.svg",erc20:!0,symbol:"XHT",decimals:18},"0x01e0E2e61f554eCAaeC0cC933E739Ad90f24a86d":{name:"GTON",logo:"gton.svg",erc20:!0,symbol:"GTON",decimals:18},"0xeFF66B4A84C8a6b69b99EB1C5e39aF8fc35d13db":{name:"sGTON",logo:"sgton.svg",erc20:!0,symbol:"sGTON",decimals:18},"0x7659CE147D0e714454073a5dd7003544234b6Aa0":{name:"XCAD Token",logo:"xcad.svg",erc20:!0,symbol:"XCAD",decimals:18},"0x88dF592F8eb5D7Bd38bFeF7dEb0fBc02cf3778a0":{name:"Tellor Tributes",logo:"TRB.svg",erc20:!0,symbol:"TRB",decimals:18},"0x8d96B4ab6C741a4C8679AE323a100d74f085BA8F":{name:"Bazaars",logo:"BZR.svg",erc20:!0,symbol:"BZR",decimals:18},"0x9ee91F9f426fA633d227f7a9b000E28b9dfd8599":{name:"Liquid staked MATIC",logo:"stMATIC.svg",erc20:!0,symbol:"stMATIC",decimals:18},"0x0d02755a5700414B26FF040e1dE35D337DF56218":{name:"Bend Token",logo:"BendDAO.svg",erc20:!0,symbol:"BEND",decimals:18},"0x1A4b46696b2bB4794Eb3D4c26f1c55F9170fa4C5":{name:"BitDAO",logo:"BitDAO.svg",erc20:!0,erc721:!1,symbol:"BIT",decimals:18},"0xb8919522331C59f5C16bDfAA6A121a6E03A91F62":{name:"Home",logo:"home.svg",erc20:!0,erc721:!1,symbol:"HOME",decimals:6},"0xa54d2EBfD977ad836203c85F18db2F0a0cF88854":{name:"Bacon",logo:"bacon.svg",erc20:!0,erc721:!1,symbol:"BACON",decimals:18},"0x249cA82617eC3DfB2589c4c17ab7EC9765350a18":{name:"Verse",logo:"VERSE.svg",erc20:!0,erc721:!1,symbol:"VERSE",decimals:18},"0x317eb4ad9cfaC6232f0046831322E895507bcBeb":{name:"Tidex Token",logo:"tidex.svg",erc20:!0,symbol:"TDX",decimals:18},"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE":{name:"SHIBA INU",logo:"shib.svg",erc20:!0,symbol:"SHIB",decimals:18},"0x3506424F91fD33084466F402d5D97f05F8e3b4AF":{name:"chiliZ",logo:"chz.svg",erc20:!0,symbol:"CHZ",decimals:18},"0x15D4c048F83bd7e37d49eA4C83a07267Ec4203dA":{name:"Gala",logo:"gala.svg",erc20:!0,symbol:"GALA",decimals:8},"0x69af81e73A73B40adF4f3d4223Cd9b1ECE623074":{name:"Mask Network",logo:"mask.svg",erc20:!0,symbol:"MASK",decimals:18},"0xD533a949740bb3306d119CC777fa900bA034cd52":{name:"Curve DAO Token",logo:"crv.svg",erc20:!0,symbol:"CRV",decimals:18},"0x92D6C1e31e14520e676a687F0a93788B716BEff5":{name:"dYdX",logo:"dydx.svg",erc20:!0,symbol:"DYDX",decimals:18},"0x60bE1e1fE41c1370ADaF5d8e66f07Cf1C2Df2268":{name:"Perion Credits",logo:"perc.svg",erc20:!0,symbol:"PERC",decimals:18},"0x8971f9fd7196e5cEE2C1032B50F656855af7Dd26":{name:"Lambda",logo:"LAMB.svg",erc20:!0,symbol:"LAMB",decimals:18},"0x65514b352d1d4a17DE97f95C7faB177C625Bd6ff":{name:"KIBBLE Token",logo:"kibble.svg",erc20:!0,erc721:!1,symbol:"KBLE",decimals:18},"0xd9Fcd98c322942075A5C3860693e9f4f03AAE07b":{name:"Euler",logo:"eul.svg",erc20:!0,erc721:!1,symbol:"EUL",decimals:18},"0x777fD20c983d6658c1D50b3958B3A1733d1cd1E1":{name:"PUBLISH",logo:"publish.svg",erc20:!0,symbol:"NEWS",decimals:9},"0x19062190B1925b5b6689D7073fDfC8c2976EF8Cb":{name:"Swarm",logo:"ethswarm.svg",erc20:!0,symbol:"BZZ",decimals:16},"0x6aA030a9710CAD6E719A4EC0a85260Eb3F4F86c1":{name:"Real World Asset",logo:"rwa.svg",erc20:!0,symbol:"RWA",decimals:18},"0xde16Ce60804a881e9F8c4eBB3824646EDecd478D":{name:"MagicCraft",logo:"magiccraft.svg",erc20:!0,symbol:"MCRT",decimals:9},"0x7163436b8EfFfB469F6BB81cc908b1661d4795e6":{name:"Esco coin",logo:"escocoin.svg",erc20:!0,symbol:"ESCO",decimals:18},"0x9625cE7753ace1fa1865A47aAe2c5C2Ce4418569":{name:"KAP Games",logo:"kap-games.svg",erc20:!0,symbol:"KAP",decimals:18},"0x4FbB350052Bca5417566f188eB2EBCE5b19BC964":{name:"Rigo",logo:"grg.svg",erc20:!0,symbol:"GRG",decimals:18},"0xD8E163967FED76806Df0097B704bA721B9b37656":{name:"Cope",logo:"cope.svg",erc20:!0,symbol:"COPE",decimals:18},"0xdfbc9050F5B01DF53512DCC39B4f2B2BBaCD517A":{name:"Jobchain",logo:"job.svg",erc20:!0,symbol:"JOB",decimals:8},"0x083D41d6DD21EE938f0c055CA4fb12268DF0EfaC":{name:"GogolCoin",logo:"gol.svg",erc20:!0,symbol:"GOL",decimals:4},"0x9B4a69dE6CA0deFDD02c0c4ce6Cb84de5202944E":{name:"PROOF Platform",erc20:!0,symbol:"PROOF",decimals:9,logo:"proof-platform.svg"},"0x4507cEf57C46789eF8d1a19EA45f4216bae2B528":{name:"TokenFi",logo:"tokenfi.svg",erc20:!0,symbol:"TOKEN",decimals:9},"0x8B39B70E39Aa811b69365398e0aACe9bee238AEb":{name:"PolkaFoundry",logo:"pkf.svg",erc20:!0,symbol:"PKF",decimals:18},"0x2c95D751DA37A5C1d9c5a7Fd465c1d50F3d96160":{name:"WASSIE",logo:"wassie.svg",erc20:!0,symbol:"WASSIE",decimals:18},"0x06325440D014e39736583c165C2963BA99fAf14E":{name:"Curve.fi",logo:"steCRV.png",erc20:!0,symbol:"steCRV",decimals:18},"0x4E241A9EC66832a16bceaeB9156E524487f061D7":{name:"ETF Rocks",logo:"etf.svg",erc20:!0,symbol:"ETF",decimals:18},"0xA849EaaE994fb86Afa73382e9Bd88c2B6b18Dc71":{name:"Mass Vehicle Ledger",logo:"mvl.svg",erc20:!0,symbol:"MVL",decimals:18},"0xd5F7838F5C461fefF7FE49ea5ebaF7728bB0ADfa":{name:"Mantle Staked Ether",logo:"mETH.svg",erc20:!0,erc721:!1,symbol:"mETH",decimals:18}}}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/contract-map.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/index.js",{"./contract-map.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./contract-map.json")}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.NETWORKS_BYPASSING_VALIDATION=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=void 0;const s=e("./types.cjs");var r;n.RPC="rpc",n.FALL_BACK_VS_CURRENCY="ETH",n.IPFS_DEFAULT_GATEWAY_URL="https://cloudflare-ipfs.com/ipfs/",n.GANACHE_CHAIN_ID="0x539",n.MAX_SAFE_CHAIN_ID=0xfffffffffffec,n.ERC721="ERC721",n.ERC1155="ERC1155",n.ERC20="ERC20",n.ERC721_INTERFACE_ID="0x80ac58cd",n.ERC721_METADATA_INTERFACE_ID="0x5b5e139f",n.ERC721_ENUMERABLE_INTERFACE_ID="0x780e9d63",n.ERC1155_INTERFACE_ID="0xd9b67a26",n.ERC1155_METADATA_URI_INTERFACE_ID="0x0e89341c",n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID="0x4e2312e0",n.GWEI="gwei",n.ASSET_TYPES={NATIVE:"NATIVE",TOKEN:"TOKEN",NFT:"NFT",UNKNOWN:"UNKNOWN"},n.TESTNET_TICKER_SYMBOLS={GOERLI:"GoerliETH",SEPOLIA:"SepoliaETH",LINEA_GOERLI:"LineaETH",LINEA_SEPOLIA:"LineaETH",MEGAETH_TESTNET:"MegaETH"},n.BUILT_IN_CUSTOM_NETWORKS_RPC={MEGAETH_TESTNET:"https://carrot.megaeth.com/rpc","megaeth-testnet":"https://carrot.megaeth.com/rpc","monad-testnet":"https://testnet-rpc.monad.xyz"},n.BUILT_IN_NETWORKS={[s.NetworkType.goerli]:{chainId:s.ChainId.goerli,ticker:s.NetworksTicker.goerli,rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl.goerli}},[s.NetworkType.sepolia]:{chainId:s.ChainId.sepolia,ticker:s.NetworksTicker.sepolia,rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl.sepolia}},[s.NetworkType.mainnet]:{chainId:s.ChainId.mainnet,ticker:s.NetworksTicker.mainnet,rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl.mainnet}},[s.NetworkType["linea-goerli"]]:{chainId:s.ChainId["linea-goerli"],ticker:s.NetworksTicker["linea-goerli"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["linea-goerli"]}},[s.NetworkType["linea-sepolia"]]:{chainId:s.ChainId["linea-sepolia"],ticker:s.NetworksTicker["linea-sepolia"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["linea-sepolia"]}},[s.NetworkType["linea-mainnet"]]:{chainId:s.ChainId["linea-mainnet"],ticker:s.NetworksTicker["linea-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["linea-mainnet"]}},[s.NetworkType["megaeth-testnet"]]:{chainId:s.ChainId["megaeth-testnet"],ticker:s.NetworksTicker["megaeth-testnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["megaeth-testnet"]}},[s.NetworkType["monad-testnet"]]:{chainId:s.ChainId["monad-testnet"],ticker:s.NetworksTicker["monad-testnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["monad-testnet"]}},[s.NetworkType["base-mainnet"]]:{chainId:s.ChainId["base-mainnet"],ticker:s.NetworksTicker["base-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["base-mainnet"]}},[s.NetworkType["arbitrum-mainnet"]]:{chainId:s.ChainId["arbitrum-mainnet"],ticker:s.NetworksTicker["arbitrum-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["arbitrum-mainnet"]}},[s.NetworkType["bsc-mainnet"]]:{chainId:s.ChainId["bsc-mainnet"],ticker:s.NetworksTicker["bsc-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["bsc-mainnet"]}},[s.NetworkType["optimism-mainnet"]]:{chainId:s.ChainId["optimism-mainnet"],ticker:s.NetworksTicker["optimism-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["optimism-mainnet"]}},[s.NetworkType["polygon-mainnet"]]:{chainId:s.ChainId["polygon-mainnet"],ticker:s.NetworksTicker["polygon-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["polygon-mainnet"]}},[s.NetworkType["sei-mainnet"]]:{chainId:s.ChainId["sei-mainnet"],ticker:s.NetworksTicker["sei-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["sei-mainnet"]}},[s.NetworkType.rpc]:{chainId:undefined,blockExplorerUrl:undefined,ticker:undefined,rpcPrefs:undefined}},n.NETWORKS_BYPASSING_VALIDATION={"0x3e7":{name:"HyperEVM",symbol:"HYPE",rpcUrl:"https://rpc.hyperliquid.xyz"}},n.OPENSEA_PROXY_URL="https://proxy.api.cx.metamask.io/opensea/v1/api/v2",n.NFT_API_BASE_URL="https://nft.api.cx.metamask.io",n.NFT_API_VERSION="1",n.NFT_API_TIMEOUT=15e3,n.ORIGIN_METAMASK="metamask",function(e){e.AddEthereumChain="wallet_addEthereumChain",e.ConnectAccounts="connect_accounts",e.EthDecrypt="eth_decrypt",e.EthGetEncryptionPublicKey="eth_getEncryptionPublicKey",e.EthSignTypedData="eth_signTypedData",e.PersonalSign="personal_sign",e.ResultError="result_error",e.ResultSuccess="result_success",e.SnapDialogAlert="snap_dialog:alert",e.SnapDialogConfirmation="snap_dialog:confirmation",e.SnapDialogPrompt="snap_dialog:prompt",e.SnapDialogDefault="snap_dialog",e.SwitchEthereumChain="wallet_switchEthereumChain",e.Transaction="transaction",e.TransactionBatch="transaction_batch",e.Unlock="unlock",e.WalletConnect="wallet_connect",e.WalletRequestPermissions="wallet_requestPermissions",e.WatchAsset="wallet_watchAsset"}(r||(n.ApprovalType=r={})),n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP={[s.ChainId.goerli]:s.BuiltInNetworkName.Goerli,[s.ChainId.sepolia]:s.BuiltInNetworkName.Sepolia,[s.ChainId.mainnet]:s.BuiltInNetworkName.Mainnet,[s.ChainId["linea-goerli"]]:s.BuiltInNetworkName.LineaGoerli,[s.ChainId["linea-sepolia"]]:s.BuiltInNetworkName.LineaSepolia,[s.ChainId["linea-mainnet"]]:s.BuiltInNetworkName.LineaMainnet,[s.ChainId.aurora]:s.BuiltInNetworkName.Aurora},n.SECOND=1e3,n.SECONDS=n.SECOND,n.MINUTE=60*n.SECONDS,n.MINUTES=n.MINUTE,n.HOUR=60*n.MINUTES,n.HOURS=n.HOUR,n.DAY=24*n.HOURS,n.DAYS=n.DAY}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs",{cockatiel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/cockatiel/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createServicePolicy=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_MAX_RETRIES=n.handleWhen=n.handleAll=n.ExponentialBackoff=n.ConstantBackoff=n.CircuitState=n.BrokenCircuitError=void 0;const s=e("cockatiel");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return s.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return s.CircuitState}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return s.ExponentialBackoff}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return s.ConstantBackoff}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return s.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return s.handleWhen}}),n.DEFAULT_MAX_RETRIES=3,n.DEFAULT_MAX_CONSECUTIVE_FAILURES=3*(1+n.DEFAULT_MAX_RETRIES),n.DEFAULT_CIRCUIT_BREAK_DURATION=18e5,n.DEFAULT_DEGRADED_THRESHOLD=5e3;const r=e=>"object"!=typeof e||null===e||!("httpStatus"in e)||"number"!=typeof e.httpStatus||e.httpStatus>=500;function o(e){return e===s.CircuitState.Open?{state:e,openedAt:Date.now()}:{state:e}}n.createServicePolicy=function(e={}){const{maxRetries:t=n.DEFAULT_MAX_RETRIES,retryFilterPolicy:a=s.handleAll,maxConsecutiveFailures:i=n.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:c=n.DEFAULT_CIRCUIT_BREAK_DURATION,degradedThreshold:m=n.DEFAULT_DEGRADED_THRESHOLD,backoff:d=new s.ExponentialBackoff}=e,u=(0,s.retry)(a,{maxAttempts:t,backoff:d}),l=u.onRetry.bind(u),f=(0,s.circuitBreaker)((0,s.handleWhen)(r),{halfOpenAfter:c,breaker:new s.ConsecutiveBreaker(i)});let h=o(f.state);f.onStateChange(e=>{h=o(e)});const p=f.onBreak.bind(f),g=new s.EventEmitter;u.onGiveUp(e=>{f.state===s.CircuitState.Closed&&g.emit(e)}),u.onSuccess(({duration:e})=>{f.state===s.CircuitState.Closed&&e>m&&g.emit()});const k=g.addListener;return{...(0,s.wrap)(u,f),circuitBreakerPolicy:f,circuitBreakDuration:c,getRemainingCircuitOpenDuration:()=>h.state===s.CircuitState.Open?h.openedAt+c-Date.now():null,retryPolicy:u,onBreak:p,onDegraded:k,onRetry:l}}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/create-service-policy.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","./create-service-policy.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs","./siwe.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs","./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.fractionBN=n.fetchWithErrorHandling=n.convertHexToDecimal=n.BNToHex=n.NETWORKS_BYPASSING_VALIDATION=n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=n.handleWhen=n.handleAll=n.createServicePolicy=n.ExponentialBackoff=n.DEFAULT_MAX_RETRIES=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.ConstantBackoff=n.CircuitState=n.BrokenCircuitError=void 0,n.isEqualCaseInsensitive=n.weiHexToGweiDec=n.toHex=n.toChecksumHexAddress=n.timeoutFetch=n.successfulFetch=n.safelyExecuteWithTimeout=n.safelyExecute=n.query=n.normalizeEnsName=n.isValidHexAddress=n.isValidJson=n.isSmartContractCode=n.isSafeDynamicKey=n.isSafeChainId=n.isPlainObject=n.isNonEmptyArray=n.HttpError=n.hexToText=n.hexToBN=n.handleFetch=n.gweiDecToWEIBN=n.getBuyURL=n.fromHex=void 0;var o=e("./create-service-policy.cjs");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return o.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return o.CircuitState}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return o.ConstantBackoff}}),Object.defineProperty(n,"DEFAULT_CIRCUIT_BREAK_DURATION",{enumerable:!0,get:function(){return o.DEFAULT_CIRCUIT_BREAK_DURATION}}),Object.defineProperty(n,"DEFAULT_DEGRADED_THRESHOLD",{enumerable:!0,get:function(){return o.DEFAULT_DEGRADED_THRESHOLD}}),Object.defineProperty(n,"DEFAULT_MAX_CONSECUTIVE_FAILURES",{enumerable:!0,get:function(){return o.DEFAULT_MAX_CONSECUTIVE_FAILURES}}),Object.defineProperty(n,"DEFAULT_MAX_RETRIES",{enumerable:!0,get:function(){return o.DEFAULT_MAX_RETRIES}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return o.ExponentialBackoff}}),Object.defineProperty(n,"createServicePolicy",{enumerable:!0,get:function(){return o.createServicePolicy}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return o.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return o.handleWhen}});var a=e("./constants.cjs");Object.defineProperty(n,"RPC",{enumerable:!0,get:function(){return a.RPC}}),Object.defineProperty(n,"FALL_BACK_VS_CURRENCY",{enumerable:!0,get:function(){return a.FALL_BACK_VS_CURRENCY}}),Object.defineProperty(n,"IPFS_DEFAULT_GATEWAY_URL",{enumerable:!0,get:function(){return a.IPFS_DEFAULT_GATEWAY_URL}}),Object.defineProperty(n,"GANACHE_CHAIN_ID",{enumerable:!0,get:function(){return a.GANACHE_CHAIN_ID}}),Object.defineProperty(n,"MAX_SAFE_CHAIN_ID",{enumerable:!0,get:function(){return a.MAX_SAFE_CHAIN_ID}}),Object.defineProperty(n,"ERC721",{enumerable:!0,get:function(){return a.ERC721}}),Object.defineProperty(n,"ERC1155",{enumerable:!0,get:function(){return a.ERC1155}}),Object.defineProperty(n,"ERC20",{enumerable:!0,get:function(){return a.ERC20}}),Object.defineProperty(n,"ERC721_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_METADATA_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_METADATA_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_ENUMERABLE_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_ENUMERABLE_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_METADATA_URI_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_METADATA_URI_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_TOKEN_RECEIVER_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_TOKEN_RECEIVER_INTERFACE_ID}}),Object.defineProperty(n,"GWEI",{enumerable:!0,get:function(){return a.GWEI}}),Object.defineProperty(n,"ASSET_TYPES",{enumerable:!0,get:function(){return a.ASSET_TYPES}}),Object.defineProperty(n,"TESTNET_TICKER_SYMBOLS",{enumerable:!0,get:function(){return a.TESTNET_TICKER_SYMBOLS}}),Object.defineProperty(n,"BUILT_IN_CUSTOM_NETWORKS_RPC",{enumerable:!0,get:function(){return a.BUILT_IN_CUSTOM_NETWORKS_RPC}}),Object.defineProperty(n,"BUILT_IN_NETWORKS",{enumerable:!0,get:function(){return a.BUILT_IN_NETWORKS}}),Object.defineProperty(n,"OPENSEA_PROXY_URL",{enumerable:!0,get:function(){return a.OPENSEA_PROXY_URL}}),Object.defineProperty(n,"NFT_API_BASE_URL",{enumerable:!0,get:function(){return a.NFT_API_BASE_URL}}),Object.defineProperty(n,"NFT_API_VERSION",{enumerable:!0,get:function(){return a.NFT_API_VERSION}}),Object.defineProperty(n,"NFT_API_TIMEOUT",{enumerable:!0,get:function(){return a.NFT_API_TIMEOUT}}),Object.defineProperty(n,"ORIGIN_METAMASK",{enumerable:!0,get:function(){return a.ORIGIN_METAMASK}}),Object.defineProperty(n,"ApprovalType",{enumerable:!0,get:function(){return a.ApprovalType}}),Object.defineProperty(n,"CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP",{enumerable:!0,get:function(){return a.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP}}),Object.defineProperty(n,"SECOND",{enumerable:!0,get:function(){return a.SECOND}}),Object.defineProperty(n,"SECONDS",{enumerable:!0,get:function(){return a.SECONDS}}),Object.defineProperty(n,"MINUTE",{enumerable:!0,get:function(){return a.MINUTE}}),Object.defineProperty(n,"MINUTES",{enumerable:!0,get:function(){return a.MINUTES}}),Object.defineProperty(n,"HOUR",{enumerable:!0,get:function(){return a.HOUR}}),Object.defineProperty(n,"HOURS",{enumerable:!0,get:function(){return a.HOURS}}),Object.defineProperty(n,"DAY",{enumerable:!0,get:function(){return a.DAY}}),Object.defineProperty(n,"DAYS",{enumerable:!0,get:function(){return a.DAYS}}),Object.defineProperty(n,"NETWORKS_BYPASSING_VALIDATION",{enumerable:!0,get:function(){return a.NETWORKS_BYPASSING_VALIDATION}});var i=e("./util.cjs");Object.defineProperty(n,"BNToHex",{enumerable:!0,get:function(){return i.BNToHex}}),Object.defineProperty(n,"convertHexToDecimal",{enumerable:!0,get:function(){return i.convertHexToDecimal}}),Object.defineProperty(n,"fetchWithErrorHandling",{enumerable:!0,get:function(){return i.fetchWithErrorHandling}}),Object.defineProperty(n,"fractionBN",{enumerable:!0,get:function(){return i.fractionBN}}),Object.defineProperty(n,"fromHex",{enumerable:!0,get:function(){return i.fromHex}}),Object.defineProperty(n,"getBuyURL",{enumerable:!0,get:function(){return i.getBuyURL}}),Object.defineProperty(n,"gweiDecToWEIBN",{enumerable:!0,get:function(){return i.gweiDecToWEIBN}}),Object.defineProperty(n,"handleFetch",{enumerable:!0,get:function(){return i.handleFetch}}),Object.defineProperty(n,"hexToBN",{enumerable:!0,get:function(){return i.hexToBN}}),Object.defineProperty(n,"hexToText",{enumerable:!0,get:function(){return i.hexToText}}),Object.defineProperty(n,"HttpError",{enumerable:!0,get:function(){return i.HttpError}}),Object.defineProperty(n,"isNonEmptyArray",{enumerable:!0,get:function(){return i.isNonEmptyArray}}),Object.defineProperty(n,"isPlainObject",{enumerable:!0,get:function(){return i.isPlainObject}}),Object.defineProperty(n,"isSafeChainId",{enumerable:!0,get:function(){return i.isSafeChainId}}),Object.defineProperty(n,"isSafeDynamicKey",{enumerable:!0,get:function(){return i.isSafeDynamicKey}}),Object.defineProperty(n,"isSmartContractCode",{enumerable:!0,get:function(){return i.isSmartContractCode}}),Object.defineProperty(n,"isValidJson",{enumerable:!0,get:function(){return i.isValidJson}}),Object.defineProperty(n,"isValidHexAddress",{enumerable:!0,get:function(){return i.isValidHexAddress}}),Object.defineProperty(n,"normalizeEnsName",{enumerable:!0,get:function(){return i.normalizeEnsName}}),Object.defineProperty(n,"query",{enumerable:!0,get:function(){return i.query}}),Object.defineProperty(n,"safelyExecute",{enumerable:!0,get:function(){return i.safelyExecute}}),Object.defineProperty(n,"safelyExecuteWithTimeout",{enumerable:!0,get:function(){return i.safelyExecuteWithTimeout}}),Object.defineProperty(n,"successfulFetch",{enumerable:!0,get:function(){return i.successfulFetch}}),Object.defineProperty(n,"timeoutFetch",{enumerable:!0,get:function(){return i.timeoutFetch}}),Object.defineProperty(n,"toChecksumHexAddress",{enumerable:!0,get:function(){return i.toChecksumHexAddress}}),Object.defineProperty(n,"toHex",{enumerable:!0,get:function(){return i.toHex}}),Object.defineProperty(n,"weiHexToGweiDec",{enumerable:!0,get:function(){return i.weiHexToGweiDec}}),Object.defineProperty(n,"isEqualCaseInsensitive",{enumerable:!0,get:function(){return i.isEqualCaseInsensitive}}),r(e("./types.cjs"),n),r(e("./siwe.cjs"),n)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("controller-utils")}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs",{"./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@spruceid/siwe-parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@spruceid/siwe-parser/dist/parsers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.detectSIWE=n.isValidSIWEOrigin=n.parseDomainParts=void 0;const s=e("@metamask/utils"),r=e("@spruceid/siwe-parser"),o=e("./logger.cjs"),a=(0,o.createModuleLogger)(o.projectLogger,"detect-siwe");function i(e){try{const r="string"!=typeof(n=e)?n:(0,s.remove0x)(n),o=t.from(r,"hex");return 32===o.length?e:o.toString("utf8")}catch(t){return a(t),e}var n}const c={"http:":"80","https:":"443"};n.parseDomainParts=(e,t)=>e.match(/^[^/:]*:\/\//u)?new URL(e):new URL(`${t}//${e}`);n.isValidSIWEOrigin=e=>{try{const{origin:t,siwe:s}=e;if(!t||!s?.parsedMessage?.domain)return!1;const r=new URL(t),o=(0,n.parseDomainParts)(s.parsedMessage.domain,r.protocol);return 0===o.hostname.localeCompare(r.hostname,undefined,{sensitivity:"accent"})&&(""!==o.port&&o.port!==r.port?""===r.port&&o.port===c[r.protocol]:""===o.username||o.username===r.username)}catch(e){return a(e),!1}};n.detectSIWE=e=>{try{const{data:t}=e,n=i(t);return{isSIWEMessage:!0,parsedMessage:new r.ParsedMessage(n)}}catch(e){return{isSIWEMessage:!1,parsedMessage:null}}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/siwe.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r;Object.defineProperty(n,"__esModule",{value:!0}),n.NetworkNickname=n.BlockExplorerUrl=n.NetworksTicker=n.ChainId=n.BuiltInNetworkName=n.isInfuraNetworkType=n.isNetworkType=n.NetworkType=n.CustomNetworkType=n.InfuraNetworkType=void 0,n.InfuraNetworkType={mainnet:"mainnet",goerli:"goerli",sepolia:"sepolia","linea-goerli":"linea-goerli","linea-sepolia":"linea-sepolia","linea-mainnet":"linea-mainnet","base-mainnet":"base-mainnet","arbitrum-mainnet":"arbitrum-mainnet","bsc-mainnet":"bsc-mainnet","optimism-mainnet":"optimism-mainnet","polygon-mainnet":"polygon-mainnet","sei-mainnet":"sei-mainnet"},n.CustomNetworkType={"megaeth-testnet":"megaeth-testnet","monad-testnet":"monad-testnet"},n.NetworkType={...n.InfuraNetworkType,...n.CustomNetworkType,rpc:"rpc"},n.isNetworkType=function(e){return Object.values(n.NetworkType).includes(e)},n.isInfuraNetworkType=function(e){return Object.keys(n.InfuraNetworkType).includes(e)},function(e){e.Mainnet="mainnet",e.Goerli="goerli",e.Sepolia="sepolia",e.LineaGoerli="linea-goerli",e.LineaSepolia="linea-sepolia",e.LineaMainnet="linea-mainnet",e.Aurora="aurora",e.MegaETHTestnet="megaeth-testnet",e.MonadTestnet="monad-testnet",e.BaseMainnet="base-mainnet",e.ArbitrumOne="arbitrum-mainnet",e.BscMainnet="bsc-mainnet",e.OptimismMainnet="optimism-mainnet",e.PolygonMainnet="polygon-mainnet",e.SeiMainnet="sei-mainnet"}(s||(n.BuiltInNetworkName=s={})),n.ChainId={[s.Mainnet]:"0x1",[s.Goerli]:"0x5",[s.Sepolia]:"0xaa36a7",[s.Aurora]:"0x4e454152",[s.LineaGoerli]:"0xe704",[s.LineaSepolia]:"0xe705",[s.LineaMainnet]:"0xe708",[s.MegaETHTestnet]:"0x18c6",[s.MonadTestnet]:"0x279f",[s.BaseMainnet]:"0x2105",[s.ArbitrumOne]:"0xa4b1",[s.BscMainnet]:"0x38",[s.OptimismMainnet]:"0xa",[s.PolygonMainnet]:"0x89",[s.SeiMainnet]:"0x531"},function(e){e.mainnet="ETH",e.goerli="GoerliETH",e.sepolia="SepoliaETH",e["linea-goerli"]="LineaETH",e["linea-sepolia"]="LineaETH",e["linea-mainnet"]="ETH",e["megaeth-testnet"]="MegaETH",e["monad-testnet"]="MON",e["base-mainnet"]="ETH",e["arbitrum-mainnet"]="ETH",e["bsc-mainnet"]="BNB",e["optimism-mainnet"]="ETH",e["polygon-mainnet"]="POL",e["sei-mainnet"]="SEI",e.rpc=""}(r||(n.NetworksTicker=r={})),n.BlockExplorerUrl={[s.Mainnet]:"https://etherscan.io",[s.Goerli]:"https://goerli.etherscan.io",[s.Sepolia]:"https://sepolia.etherscan.io",[s.LineaGoerli]:"https://goerli.lineascan.build",[s.LineaSepolia]:"https://sepolia.lineascan.build",[s.LineaMainnet]:"https://lineascan.build",[s.MegaETHTestnet]:"https://megaexplorer.xyz",[s.MonadTestnet]:"https://testnet.monadexplorer.com",[s.BaseMainnet]:"https://basescan.org",[s.ArbitrumOne]:"https://arbiscan.io",[s.BscMainnet]:"https://bscscan.com",[s.OptimismMainnet]:"https://optimistic.etherscan.io",[s.PolygonMainnet]:"https://polygonscan.com",[s.SeiMainnet]:"https://seitrace.com"},n.NetworkNickname={[s.Mainnet]:"Ethereum Mainnet",[s.Goerli]:"Goerli",[s.Sepolia]:"Sepolia",[s.LineaGoerli]:"Linea Goerli",[s.LineaSepolia]:"Linea Sepolia",[s.LineaMainnet]:"Linea",[s.MegaETHTestnet]:"Mega Testnet",[s.MonadTestnet]:"Monad Testnet",[s.BaseMainnet]:"Base Mainnet",[s.ArbitrumOne]:"Arbitrum One",[s.BscMainnet]:"BSC Mainnet",[s.OptimismMainnet]:"Optimism Mainnet",[s.PolygonMainnet]:"Polygon Mainnet",[s.SeiMainnet]:"Sei Mainnet"}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","@metamask/ethjs-unit":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-unit/lib/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","eth-ens-namehash":"/home/runner/work/metamask-extension/metamask-extension/node_modules/eth-ens-namehash/index.js","fast-deep-equal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-deep-equal/index.js",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.isEqualCaseInsensitive=n.isValidJson=n.isNonEmptyArray=n.isPlainObject=n.convertHexToDecimal=n.query=n.normalizeEnsName=n.timeoutFetch=n.fetchWithErrorHandling=n.handleFetch=n.successfulFetch=n.HttpError=n.isSmartContractCode=n.isValidHexAddress=n.toChecksumHexAddress=n.safelyExecuteWithTimeout=n.safelyExecute=n.toHex=n.fromHex=n.hexToText=n.hexToBN=n.getBuyURL=n.weiHexToGweiDec=n.gweiDecToWEIBN=n.fractionBN=n.BNToHex=n.isSafeChainId=n.isSafeDynamicKey=n.PROTOTYPE_POLLUTION_BLOCKLIST=void 0;const r=e("@metamask/ethjs-unit"),o=e("@metamask/utils"),a=s(e("bn.js")),i=s(e("eth-ens-namehash")),c=s(e("fast-deep-equal")),m=e("lodash"),d=e("./constants.cjs"),u=new Error("timeout");function l(e){return e?new a.default((0,o.remove0x)(e),16):new a.default(0)}n.PROTOTYPE_POLLUTION_BLOCKLIST=["__proto__","constructor","prototype"],n.isSafeDynamicKey=function(e){return"string"==typeof e&&!n.PROTOTYPE_POLLUTION_BLOCKLIST.some(t=>e===t)},n.isSafeChainId=function(e){if(!(0,o.isHexString)(e))return!1;const t=Number.parseInt(e,(0,o.isStrictHexString)(e)?16:10);return Number.isSafeInteger(t)&&t>0&&t<=d.MAX_SAFE_CHAIN_ID},n.BNToHex=function(e){return(0,o.add0x)(e.toString(16))},n.fractionBN=function(e,t,n){const s=new a.default(t),r=new a.default(n);return e.mul(s).div(r)},n.gweiDecToWEIBN=function(e){if(Number.isNaN(e))return new a.default(0);const t=e.toString().split("."),n=t[0]||"0";let s=t[1]||"";if(!s)return(0,r.toWei)(n,"gwei");if(s.length<=9)return(0,r.toWei)(`${n}.${s}`,"gwei");const o=s.slice(9)[0];s=s.slice(0,9);let i=(0,r.toWei)(`${n}.${s}`,"gwei");return Number(o)>=5&&(i=i.add(new a.default(1))),i},n.weiHexToGweiDec=function(e){const t=new a.default((0,o.remove0x)(e),16);return(0,r.fromWei)(t,"gwei")},n.getBuyURL=function(e="1",t,n=5){switch(e){case"1":return`https://buy.coinbase.com/?code=9ec56d01-7e81-5017-930c-513daa27bb6a&amount=${n}&address=${t}&crypto_currency=ETH`;case"5":return"https://goerli-faucet.slock.it/";case"11155111":return"https://sepoliafaucet.net/";default:return undefined}},n.hexToBN=l,n.hexToText=function(e){try{const n=(0,o.remove0x)(e);return t.from(n,"hex").toString("utf8")}catch(t){return e}},n.fromHex=function(e){return a.default.isBN(e)?e:new a.default(l(e).toString(10))},n.toHex=function(e){return"string"==typeof e&&(0,o.isStrictHexString)(e)?e:`0x${a.default.isBN(e)||"bigint"==typeof e?e.toString(16):new a.default(e.toString(),10).toString(16)}`},n.safelyExecute=async function(e,t=!1){try{return await e()}catch(e){return t&&console.error(e),undefined}},n.safelyExecuteWithTimeout=async function(e,t=!1,n=500){try{return await Promise.race([e(),new Promise((e,t)=>setTimeout(()=>{t(u)},n))])}catch(e){return t&&console.error(e),undefined}},n.toChecksumHexAddress=(0,m.memoize)(function(e){if("string"!=typeof e)return e;const t=(0,o.add0x)(e);if(!(0,o.isHexString)(t))return t;try{return(0,o.getChecksumAddress)(t)}catch(e){if(e instanceof Error&&"Invalid hex address."===e.message)return t;throw e}}),n.isValidHexAddress=(0,m.memoize)(function(e,{allowNonPrefixed:t=!0}={}){const n=t?(0,o.add0x)(e):e;return!!(0,o.isStrictHexString)(n)&&(0,o.isHexChecksumAddress)(n)},(e,{allowNonPrefixed:t=!0}={})=>`${e}-${t}`),n.isSmartContractCode=function(e){return!!e&&("0x"!==e&&"0x0"!==e)};class f extends Error{constructor(e,t){super(t||`Fetch failed with status '${e}'`),this.httpStatus=e}}async function h(e,t){const n=await fetch(e,t);if(!n.ok)throw new f(n.status,`Fetch failed with status '${n.status}' for request '${String(e)}'`);return n}async function p(e,t){const n=await h(e,t);return await n.json()}n.HttpError=f,n.successfulFetch=h,n.handleFetch=p,n.fetchWithErrorHandling=async function({url:e,options:t,timeout:n,errorCodesToCatch:s}){let r;try{r=n?Promise.race([await p(e,t),new Promise((e,t)=>setTimeout(()=>{t(u)},n))]):await p(e,t)}catch(e){!function(e,t=[]){if(!e)return;if(!(e instanceof Error))throw e;if(!t.some(t=>e.message.includes(`Fetch failed with status '${t}'`))&&!e.message.includes("Failed to fetch")&&e!==u)throw e;console.error(e)}(e,s)}return r},n.timeoutFetch=async function(e,t,n=500){return Promise.race([h(e,t),new Promise((e,t)=>setTimeout(()=>{t(u)},n))])},n.normalizeEnsName=function(e){if("."===e)return e;if(e&&"string"==typeof e)try{const t=i.default.normalize(e.trim());if(t.match(/^(([\w\d-]+)\.)*[\w\d-]{7,}\.(eth|test)$/u))return t}catch(e){}return null},n.query=function(e,t,n=[]){return new Promise((s,r)=>{const o=(e,t)=>{e?r(e):s(t)};t in e&&"function"==typeof e[t]?e[t](...n,o):e.sendAsync({method:t,params:n},o)})};n.convertHexToDecimal=(e="0x0")=>(0,o.isStrictHexString)(e)?parseInt(e,16):Number(e)?Number(e):0,n.isPlainObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)},n.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},n.isValidJson=function(e){try{return(0,c.default)(e,JSON.parse(JSON.stringify(e)))}catch(e){return!1}},n.isEqualCaseInsensitive=function(e,t){return"string"==typeof e&&"string"==typeof t&&e.toLowerCase()===t.toLowerCase()}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/delegation-core/dist/index.cjs",{"@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/hashes/sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha3.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var s=e("@metamask/utils"),r={out:"hex"};function o(e,t){if("hex"===t.out){const t="string"==typeof e?e:s.bytesToHex.call(void 0,e);return t.startsWith("0x")?t:`0x${t}`}return e instanceof Uint8Array?e:s.hexToBytes.call(void 0,e)}var a=e=>"string"==typeof e?e:s.bytesToHex.call(void 0,e),i=e=>"string"==typeof e?s.hexToBytes.call(void 0,e):e,c=({value:e,size:t})=>e.toString(16).padStart(2*t,"0");var m=253402300799;var d=e("@metamask/abi-utils"),u=e("@noble/hashes/sha3"),l="0x88c1d2ecf185adf710588203a5f263f0ff61be0d33da39792cde19ba9aa4331e",f="0x80ad7e1b04ee6d994a125f4714ca0720908bd80ed16063ec8aee4b88e9253e2d",h="(address,address,bytes32,(address,bytes,bytes)[],uint256,bytes)[]";var p=(e,t)=>{const[n,s,r,o,a,i]=e;return{delegate:t(n),delegator:t(s),authority:t(r),caveats:o.map(([e,n,s])=>({enforcer:t(e),terms:t(n),args:t(s)})),salt:a,signature:t(i)}};function g(e){const t=32*e.length,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const s=e[t];if(!s)throw new Error(`Caveat was undefined at index ${t}`);const r=k(s);n.set(r,32*t)}return u.keccak_256.call(void 0,n)}function k(e){const t="string"==typeof e.terms?s.hexToBytes.call(void 0,e.terms):e.terms,n=u.keccak_256.call(void 0,t),r=d.encode.call(void 0,["bytes32","address","bytes32"],[f,e.enforcer,n]);return u.keccak_256.call(void 0,r)}n.ANY_BENEFICIARY="0x0000000000000000000000000000000000000a11",n.CAVEAT_TYPEHASH=f,n.DELEGATION_TYPEHASH=l,n.ROOT_AUTHORITY="0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",n.createERC20StreamingTerms=function(e,t=r){const{tokenAddress:n,initialAmount:a,maxAmount:i,amountPerSecond:m,startTime:d}=e;if(!n)throw new Error("Invalid tokenAddress: must be a valid address");let u;if("string"==typeof n){if(!s.isHexString.call(void 0,n)||42!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");u=n}else{if(20!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");u=s.bytesToHex.call(void 0,n)}if(a<0n)throw new Error("Invalid initialAmount: must be greater than zero");if(i<=0n)throw new Error("Invalid maxAmount: must be a positive number");if(i<a)throw new Error("Invalid maxAmount: must be greater than initialAmount");if(m<=0n)throw new Error("Invalid amountPerSecond: must be a positive number");if(d<=0)throw new Error("Invalid startTime: must be a positive number");if(d>253402300799)throw new Error("Invalid startTime: must be less than or equal to 253402300799");return o(`${u}${c({value:a,size:32})}${c({value:i,size:32})}${c({value:m,size:32})}${c({value:d,size:32})}`,t)},n.createERC20TokenPeriodTransferTerms=function(e,t=r){const{tokenAddress:n,periodAmount:a,periodDuration:i,startDate:m}=e;if(!n)throw new Error("Invalid tokenAddress: must be a valid address");let d;if("string"==typeof n){if(!s.isHexString.call(void 0,n)||42!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");d=n}else{if(20!==n.length)throw new Error("Invalid tokenAddress: must be a valid address");d=s.bytesToHex.call(void 0,n)}if(a<=0n)throw new Error("Invalid periodAmount: must be a positive number");if(i<=0)throw new Error("Invalid periodDuration: must be a positive number");if(m<=0)throw new Error("Invalid startDate: must be a positive number");return o(`${d}${c({value:a,size:32})}${c({value:i,size:32})}${c({value:m,size:32})}`,t)},n.createExactCalldataTerms=function(e,t=r){const{calldata:n}=e;if("string"==typeof n&&!n.startsWith("0x"))throw new Error("Invalid calldata: must be a hex string starting with 0x");return o(n,t)},n.createNativeTokenPeriodTransferTerms=function(e,t=r){const{periodAmount:n,periodDuration:s,startDate:a}=e;if(n<=0n)throw new Error("Invalid periodAmount: must be a positive number");if(s<=0)throw new Error("Invalid periodDuration: must be a positive number");if(a<=0)throw new Error("Invalid startDate: must be a positive number");return o(`0x${c({value:n,size:32})}${c({value:s,size:32})}${c({value:a,size:32})}`,t)},n.createNativeTokenStreamingTerms=function(e,t=r){const{initialAmount:n,maxAmount:s,amountPerSecond:a,startTime:i}=e;if(n<0n)throw new Error("Invalid initialAmount: must be greater than zero");if(s<=0n)throw new Error("Invalid maxAmount: must be a positive number");if(s<n)throw new Error("Invalid maxAmount: must be greater than initialAmount");if(a<=0n)throw new Error("Invalid amountPerSecond: must be a positive number");if(i<=0)throw new Error("Invalid startTime: must be a positive number");if(i>253402300799)throw new Error("Invalid startTime: must be less than or equal to 253402300799");return o(`0x${c({value:n,size:32})}${c({value:s,size:32})}${c({value:a,size:32})}${c({value:i,size:32})}`,t)},n.createNonceTerms=function(e,t=r){const{nonce:n}=e;if(n instanceof Uint8Array&&0===n.length)throw new Error("Invalid nonce: Uint8Array must not be empty");if("string"==typeof n&&!n.startsWith("0x"))throw new Error("Invalid nonce: string must have 0x prefix");const i=a(n);if("0x"===i)throw new Error("Invalid nonce: must not be empty");if(!s.isHexString.call(void 0,i))throw new Error("Invalid nonce: must be a valid BytesLike value");if(i.length>66)throw new Error("Invalid nonce: must be 32 bytes or less in length");return o(`0x${i.slice(2).padStart(64,"0")}`,t)},n.createTimestampTerms=function(e,t=r){const{timestampAfterThreshold:n,timestampBeforeThreshold:s}=e;if(n<0)throw new Error("Invalid timestampAfterThreshold: must be zero or positive");if(s<0)throw new Error("Invalid timestampBeforeThreshold: must be zero or positive");if(s>m)throw new Error("Invalid timestampBeforeThreshold: must be less than or equal to 253402300799");if(n>m)throw new Error("Invalid timestampAfterThreshold: must be less than or equal to 253402300799");if(0!==s&&n>=s)throw new Error("Invalid thresholds: timestampBeforeThreshold must be greater than timestampAfterThreshold when both are specified");return o(`0x${c({value:n,size:16})}${c({value:s,size:16})}`,t)},n.createValueLteTerms=function(e,t=r){const{maxValue:n}=e;if(n<0n)throw new Error("Invalid maxValue: must be greater than or equal to zero");return o(c({value:n,size:32}),t)},n.decodeDelegations=function(e,t=r){const n=d.decodeSingle.call(void 0,h,e);return"bytes"===t.out?n.map(e=>p(e,i)):n.map(e=>p(e,a))},n.encodeDelegations=function(e,t=r){let n;if(0===e.length)n=new Uint8Array(64),n[31]=32;else{const t=e.map(e=>[e.delegate,e.delegator,e.authority,e.caveats.map(e=>[e.enforcer,e.terms,e.args]),e.salt,e.signature]);n=d.encodeSingle.call(void 0,h,t)}return o(n,t)},n.hashDelegation=function(e,t=r){const n=d.encode.call(void 0,["bytes32","address","address","bytes32","bytes32","uint256"],[l,e.delegate,e.delegator,e.authority,g(e.caveats),e.salt]);return o(u.keccak_256.call(void 0,n),t)}}}},{package:"@metamask/delegation-core",file:"node_modules/@metamask/delegation-core/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../AvatarBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs","../temp-components/Blockies/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/index.cjs","../temp-components/Jazzicon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/index.cjs","../temp-components/Maskicon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/index.cjs","./AvatarAccount.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.constants.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarAccount=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs"),m=e("../temp-components/Blockies/index.cjs"),d=e("../temp-components/Jazzicon/index.cjs"),u=e("../temp-components/Maskicon/index.cjs"),l=e("./AvatarAccount.constants.cjs");n.AvatarAccount=(0,a.forwardRef)(({address:e,variant:t=i.AvatarAccountVariant.Jazzicon,className:n,size:s=i.AvatarAccountSize.Md,blockiesProps:r,jazziconProps:o,maskiconProps:f,...h},p)=>{let g;switch(t){case i.AvatarAccountVariant.Blockies:g=a.default.createElement(m.Blockies,{address:e,size:l.MAP_AVATARACCOUNT_SIZE_SIZENUMBER[s],...r});break;case i.AvatarAccountVariant.Maskicon:g=a.default.createElement(u.Maskicon,{address:e,size:l.MAP_AVATARACCOUNT_SIZE_SIZENUMBER[s],...f});break;case i.AvatarAccountVariant.Jazzicon:default:g=a.default.createElement(d.Jazzicon,{address:e,size:l.MAP_AVATARACCOUNT_SIZE_SIZENUMBER[s],...o})}return a.default.createElement(c.AvatarBase,{ref:p,shape:i.AvatarBaseShape.Square,size:s,className:n,...h},g)}),n.AvatarAccount.displayName="AvatarAccount"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAP_AVATARACCOUNT_SIZE_SIZENUMBER=void 0;const s=e("../../types/index.cjs");n.MAP_AVATARACCOUNT_SIZE_SIZENUMBER={[s.AvatarAccountSize.Xs]:16,[s.AvatarAccountSize.Sm]:24,[s.AvatarAccountSize.Md]:32,[s.AvatarAccountSize.Lg]:40,[s.AvatarAccountSize.Xl]:48}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarAccount/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./AvatarAccount.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarAccount/AvatarAccount.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarAccount=n.AvatarAccountVariant=n.AvatarAccountSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"AvatarAccountSize",{enumerable:!0,get:function(){return s.AvatarAccountSize}}),Object.defineProperty(n,"AvatarAccountVariant",{enumerable:!0,get:function(){return s.AvatarAccountVariant}});var r=e("./AvatarAccount.cjs");Object.defineProperty(n,"AvatarAccount",{enumerable:!0,get:function(){return r.AvatarAccount}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarAccount/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs","./AvatarBase.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.constants.cjs","@radix-ui/react-slot":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-slot/dist/index.js",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarBase=void 0;const a=e("@radix-ui/react-slot"),i=o(e("react")),c=e("../../types/index.cjs"),m=e("../../utils/tw-merge.cjs"),d=e("../Text/index.cjs"),u=e("./AvatarBase.constants.cjs");n.AvatarBase=(0,i.forwardRef)(({children:e,fallbackText:t,fallbackTextProps:n,className:s,size:r=c.AvatarBaseSize.Md,shape:o=c.AvatarBaseShape.Circle,asChild:l,style:f,hasBorder:h=!1,...p},g)=>{const k=l?a.Slot:"div",b=(0,m.twMerge)("inline-flex shrink-0 items-center justify-center overflow-hidden bg-section",o===c.AvatarBaseShape.Circle?"rounded-full":u.TWCLASSMAP_AVATARBASE_SIZE_BORDERRADIUSS_SQUARE[r],h?u.TWCLASSMAP_AVATARBASE_HASBORDER_SIZE_DIMENSION[r]:u.TWCLASSMAP_AVATARBASE_SIZE_DIMENSION[r],h&&u.TWCLASSMAP_AVATARBASE_SIZE_BORDER[r],s);return i.default.createElement(k,{ref:g,className:b,style:f,...p},t?i.default.createElement(d.Text,{variant:d.TextVariant.BodySm,fontWeight:d.FontWeight.Medium,color:d.TextColor.TextMuted,asChild:!0,className:"uppercase",...n},i.default.createElement("span",null,t)):e)}),n.AvatarBase.displayName="AvatarBase"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TWCLASSMAP_AVATARBASE_SIZE_BORDER=n.TWCLASSMAP_AVATARBASE_SIZE_BORDERRADIUSS_SQUARE=n.TWCLASSMAP_AVATARBASE_HASBORDER_SIZE_DIMENSION=n.TWCLASSMAP_AVATARBASE_SIZE_DIMENSION=void 0;const s=e("../../types/index.cjs");n.TWCLASSMAP_AVATARBASE_SIZE_DIMENSION={[s.AvatarBaseSize.Xs]:"h-4 w-4",[s.AvatarBaseSize.Sm]:"h-6 w-6",[s.AvatarBaseSize.Md]:"h-8 w-8",[s.AvatarBaseSize.Lg]:"h-10 w-10",[s.AvatarBaseSize.Xl]:"h-12 w-12"},n.TWCLASSMAP_AVATARBASE_HASBORDER_SIZE_DIMENSION={[s.AvatarBaseSize.Xs]:"h-[18px] w-[18px]",[s.AvatarBaseSize.Sm]:"h-[26px] w-[26px]",[s.AvatarBaseSize.Md]:"h-[34px] w-[34px]",[s.AvatarBaseSize.Lg]:"h-[44px] w-[44px]",[s.AvatarBaseSize.Xl]:"h-[52px] w-[52px]"},n.TWCLASSMAP_AVATARBASE_SIZE_BORDERRADIUSS_SQUARE={[s.AvatarBaseSize.Xs]:"rounded-sm",[s.AvatarBaseSize.Sm]:"rounded-md",[s.AvatarBaseSize.Md]:"rounded-lg",[s.AvatarBaseSize.Lg]:"rounded-[10px]",[s.AvatarBaseSize.Xl]:"rounded-xl"},n.TWCLASSMAP_AVATARBASE_SIZE_BORDER={[s.AvatarBaseSize.Xs]:"border-background-default border",[s.AvatarBaseSize.Sm]:"border-background-default border",[s.AvatarBaseSize.Md]:"border-background-default border",[s.AvatarBaseSize.Lg]:"border-background-default border-2",[s.AvatarBaseSize.Xl]:"border-background-default border-2"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./AvatarBase.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/AvatarBase.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarBase=n.AvatarBaseShape=n.AvatarBaseSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"AvatarBaseSize",{enumerable:!0,get:function(){return s.AvatarBaseSize}}),Object.defineProperty(n,"AvatarBaseShape",{enumerable:!0,get:function(){return s.AvatarBaseShape}});var r=e("./AvatarBase.cjs");Object.defineProperty(n,"AvatarBase",{enumerable:!0,get:function(){return r.AvatarBase}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/AvatarFavicon.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../AvatarBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarFavicon=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs");n.AvatarFavicon=(0,a.forwardRef)(({src:e,name:t="",fallbackText:n,fallbackTextProps:s,className:r,size:o=i.AvatarFaviconSize.Md,imageProps:m,...d},u)=>{const[l,f]=(0,a.useState)(""),h=n||t?.[0]||"",p=t||"Dapp logo";return a.default.createElement(c.AvatarBase,{ref:u,shape:i.AvatarBaseShape.Circle,size:o,className:r,fallbackText:e?l:h,fallbackTextProps:s,...d},e&&a.default.createElement("img",{src:e,alt:p,className:"size-full object-contain",...m,onError:e=>{f(h),m?.onError?.(e)}}))}),n.AvatarFavicon.displayName="AvatarFavicon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/AvatarFavicon.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./AvatarFavicon.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/AvatarFavicon.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarFavicon=n.AvatarFaviconSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"AvatarFaviconSize",{enumerable:!0,get:function(){return s.AvatarFaviconSize}});var r=e("./AvatarFavicon.cjs");Object.defineProperty(n,"AvatarFavicon",{enumerable:!0,get:function(){return r.AvatarFavicon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../AvatarAccount/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarAccount/index.cjs","../AvatarBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs","../AvatarFavicon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/index.cjs","../AvatarNetwork/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/index.cjs","../AvatarToken/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarToken/index.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs","./AvatarGroup.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.constants.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarGroup=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),m=e("../AvatarAccount/index.cjs"),d=e("../AvatarBase/index.cjs"),u=e("../AvatarFavicon/index.cjs"),l=e("../AvatarNetwork/index.cjs"),f=e("../AvatarToken/index.cjs"),h=e("../Text/index.cjs"),p=e("./AvatarGroup.constants.cjs");n.AvatarGroup=(0,a.forwardRef)(({variant:e,avatarPropsArr:t,size:n=i.AvatarGroupSize.Md,max:s=4,isReverse:r=!1,overflowTextProps:o,style:g,className:k,...b},y)=>{const _=t.length-s,x=_>0,w=r?p.AVATAR_GROUP_SIZE_ISREVERSE_NEGATIVESPACEBETWEENAVATARS_MAP[n]:p.AVATAR_GROUP_SIZE_NEGATIVESPACEBETWEENAVATARS_MAP[n],v=(0,c.twMerge)("inline-flex",r?"flex-row-reverse":"flex-row",k),j=(0,c.twMerge)("flex",r?"flex-row-reverse":"flex-row"),O=(0,c.twMerge)("bg-icon-default",w),C=(0,a.useCallback)(()=>t.slice(0,s).map((t,s)=>{switch(e){case i.AvatarGroupVariant.Account:return a.default.createElement(m.AvatarAccount,{hasBorder:!0,key:`avatar-${s}`,...t,size:n,className:`${s>0&&w} ${t.className}`,style:{zIndex:s+1,...t.style}});case i.AvatarGroupVariant.Favicon:return a.default.createElement(u.AvatarFavicon,{hasBorder:!0,key:`avatar-${s}`,...t,size:n,className:`${s>0&&w} ${t.className}`,style:{zIndex:s+1,...t.style}});case i.AvatarGroupVariant.Network:return a.default.createElement(l.AvatarNetwork,{hasBorder:!0,key:`avatar-${s}`,...t,size:n,className:`${s>0&&w} ${t.className}`,style:{zIndex:s+1,...t.style}});case i.AvatarGroupVariant.Token:return a.default.createElement(f.AvatarToken,{hasBorder:!0,key:`avatar-${s}`,...t,size:n,className:`${s>0&&w} ${t.className}`,style:{zIndex:s+1,...t.style}});default:throw new Error(`Invalid Avatar Variant: ${String(e)}. Expected one of: ${Object.values(i.AvatarGroupVariant).join(", ")}`)}}),[t,s,n]);return a.default.createElement("div",{ref:y,...b,style:g,className:v},a.default.createElement("div",{className:j},C()),x&&a.default.createElement(d.AvatarBase,{className:O,style:{zIndex:t.length},hasBorder:!0,fallbackText:`+${_}`,fallbackTextProps:{variant:p.AVATAR_GROUP_SIZE_OVERFLOWTEXT_TEXTVARIANT_MAP[n],color:h.TextColor.PrimaryInverse},size:n,shape:e===i.AvatarGroupVariant.Network?d.AvatarBaseShape.Square:d.AvatarBaseShape.Circle,...o}))})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AVATAR_GROUP_SIZE_OVERFLOWTEXT_TEXTVARIANT_MAP=n.AVATAR_GROUP_SIZE_ISREVERSE_NEGATIVESPACEBETWEENAVATARS_MAP=n.AVATAR_GROUP_SIZE_NEGATIVESPACEBETWEENAVATARS_MAP=void 0;const s=e("../../types/index.cjs"),r=e("../Text/index.cjs");n.AVATAR_GROUP_SIZE_NEGATIVESPACEBETWEENAVATARS_MAP={[s.AvatarGroupSize.Xs]:"ml-[-6px]",[s.AvatarGroupSize.Sm]:"ml-[-10px]",[s.AvatarGroupSize.Md]:"ml-[-14px]",[s.AvatarGroupSize.Lg]:"ml-[-18px]",[s.AvatarGroupSize.Xl]:"ml-[-22px]"},n.AVATAR_GROUP_SIZE_ISREVERSE_NEGATIVESPACEBETWEENAVATARS_MAP={[s.AvatarGroupSize.Xs]:"mr-[-6px]",[s.AvatarGroupSize.Sm]:"mr-[-10px]",[s.AvatarGroupSize.Md]:"mr-[-14px]",[s.AvatarGroupSize.Lg]:"mr-[-18px]",[s.AvatarGroupSize.Xl]:"mr-[-22px]"},n.AVATAR_GROUP_SIZE_OVERFLOWTEXT_TEXTVARIANT_MAP={[s.AvatarGroupSize.Xs]:r.TextVariant.BodyXs,[s.AvatarGroupSize.Sm]:r.TextVariant.BodySm,[s.AvatarGroupSize.Md]:r.TextVariant.BodyMd,[s.AvatarGroupSize.Lg]:r.TextVariant.HeadingMd,[s.AvatarGroupSize.Xl]:r.TextVariant.HeadingMd}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarGroup/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./AvatarGroup.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarGroup/AvatarGroup.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarGroup=n.AvatarGroupVariant=n.AvatarGroupSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"AvatarGroupSize",{enumerable:!0,get:function(){return s.AvatarGroupSize}}),Object.defineProperty(n,"AvatarGroupVariant",{enumerable:!0,get:function(){return s.AvatarGroupVariant}});var r=e("./AvatarGroup.cjs");Object.defineProperty(n,"AvatarGroup",{enumerable:!0,get:function(){return r.AvatarGroup}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarGroup/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../AvatarBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs","../Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs","./AvatarIcon.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.constants.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarIcon=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),m=e("../AvatarBase/index.cjs"),d=e("../Icon/index.cjs"),u=e("./AvatarIcon.constants.cjs");n.AvatarIcon=(0,a.forwardRef)(({iconName:e,iconProps:t,size:n=i.AvatarIconSize.Md,severity:s=i.AvatarIconSeverity.Neutral,className:r,...o},l)=>a.default.createElement(m.AvatarBase,{ref:l,shape:m.AvatarBaseShape.Circle,size:n,className:(0,c.twMerge)(u.TWCLASSMAP_AVATARICON_SEVERITY_BACKGROUNDCOLOR[s],r),...o},e&&a.default.createElement(d.Icon,{name:e,size:u.MAP_AVATARICON_SIZE_ICONSIZE[n],color:u.MAP_AVATARICON_SEVERITY_ICONCOLOR[s],...t}))),n.AvatarIcon.displayName="AvatarIcon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAP_AVATARICON_SEVERITY_ICONCOLOR=n.TWCLASSMAP_AVATARICON_SEVERITY_BACKGROUNDCOLOR=n.MAP_AVATARICON_SIZE_ICONSIZE=void 0;const s=e("../../types/index.cjs"),r=e("../Icon/index.cjs");n.MAP_AVATARICON_SIZE_ICONSIZE={[s.AvatarIconSize.Xs]:r.IconSize.Xs,[s.AvatarIconSize.Sm]:r.IconSize.Sm,[s.AvatarIconSize.Md]:r.IconSize.Md,[s.AvatarIconSize.Lg]:r.IconSize.Lg,[s.AvatarIconSize.Xl]:r.IconSize.Xl},n.TWCLASSMAP_AVATARICON_SEVERITY_BACKGROUNDCOLOR={[s.AvatarIconSeverity.Neutral]:"bg-muted",[s.AvatarIconSeverity.Info]:"bg-info-muted",[s.AvatarIconSeverity.Success]:"bg-success-muted",[s.AvatarIconSeverity.Error]:"bg-error-muted",[s.AvatarIconSeverity.Warning]:"bg-warning-muted"},n.MAP_AVATARICON_SEVERITY_ICONCOLOR={[s.AvatarIconSeverity.Neutral]:r.IconColor.IconAlternative,[s.AvatarIconSeverity.Info]:r.IconColor.InfoDefault,[s.AvatarIconSeverity.Success]:r.IconColor.SuccessDefault,[s.AvatarIconSeverity.Error]:r.IconColor.ErrorDefault,[s.AvatarIconSeverity.Warning]:r.IconColor.WarningDefault}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarIcon/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./AvatarIcon.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarIcon/AvatarIcon.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarIcon=n.AvatarIconSeverity=n.AvatarIconSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"AvatarIconSize",{enumerable:!0,get:function(){return s.AvatarIconSize}}),Object.defineProperty(n,"AvatarIconSeverity",{enumerable:!0,get:function(){return s.AvatarIconSeverity}});var r=e("./AvatarIcon.cjs");Object.defineProperty(n,"AvatarIcon",{enumerable:!0,get:function(){return r.AvatarIcon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarIcon/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/AvatarNetwork.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../AvatarBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarNetwork=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs");n.AvatarNetwork=(0,a.forwardRef)(({src:e,name:t="",fallbackText:n,fallbackTextProps:s,className:r,size:o=i.AvatarNetworkSize.Md,imageProps:m,...d},u)=>{const[l,f]=(0,a.useState)(""),h=n||t?.[0]||"",p=t||"Network logo";return a.default.createElement(c.AvatarBase,{ref:u,shape:i.AvatarBaseShape.Square,size:o,className:r,fallbackText:e?l:h,fallbackTextProps:s,...d},e&&a.default.createElement("img",{src:e,alt:p,className:"size-full object-contain",...m,onError:e=>{f(h),m?.onError?.(e)}}))}),n.AvatarNetwork.displayName="AvatarNetwork"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/AvatarNetwork.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./AvatarNetwork.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/AvatarNetwork.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarNetwork=n.AvatarNetworkSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"AvatarNetworkSize",{enumerable:!0,get:function(){return s.AvatarNetworkSize}});var r=e("./AvatarNetwork.cjs");Object.defineProperty(n,"AvatarNetwork",{enumerable:!0,get:function(){return r.AvatarNetwork}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarToken/AvatarToken.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../AvatarBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarToken=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../AvatarBase/index.cjs");n.AvatarToken=(0,a.forwardRef)(({src:e,name:t="",fallbackText:n,fallbackTextProps:s,className:r,size:o=i.AvatarTokenSize.Md,imageProps:m,...d},u)=>{const[l,f]=(0,a.useState)(""),h=n||t?.[0]||"",p=t||"Token logo";return a.default.createElement(c.AvatarBase,{ref:u,shape:i.AvatarBaseShape.Circle,size:o,className:r,fallbackText:e?l:h,fallbackTextProps:s,...d},e&&a.default.createElement("img",{src:e,alt:p,className:"size-full object-contain",onError:e=>{f(h),m?.onError?.(e)},...m}))}),n.AvatarToken.displayName="AvatarToken"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarToken/AvatarToken.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarToken/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./AvatarToken.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarToken/AvatarToken.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AvatarToken=n.AvatarTokenSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"AvatarTokenSize",{enumerable:!0,get:function(){return s.AvatarTokenSize}});var r=e("./AvatarToken.cjs");Object.defineProperty(n,"AvatarToken",{enumerable:!0,get:function(){return r.AvatarToken}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/AvatarToken/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs","./BadgeCount.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.constants.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeCount=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),m=e("../Text/index.cjs"),d=e("./BadgeCount.constants.cjs");n.BadgeCount=(0,a.forwardRef)(({size:e=i.BadgeCountSize.Md,count:t,max:n=99,textProps:s,className:r="",style:o,...u},l)=>{const f=(0,c.twMerge)("inline-flex items-center justify-center self-start rounded-lg bg-error-default",d.TWCLASSMAP_BADGECOUNT_SIZE_CONTAINER[e],r);return a.default.createElement("div",{ref:l,className:f,style:o,...u},a.default.createElement(m.Text,{variant:d.MAP_BADGECOUNT_SIZE_TEXTVARIANT[e],color:m.TextColor.ErrorInverse,fontWeight:m.FontWeight.Medium,...s,className:`${s?.className||""}`,asChild:!0},a.default.createElement("span",null,t>n?`${n}+`:`${t}`)))}),n.BadgeCount.displayName="BadgeCount"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TWCLASSMAP_BADGECOUNT_SIZE_CONTAINER=n.MAP_BADGECOUNT_SIZE_TEXTVARIANT=void 0;const s=e("../../types/index.cjs"),r=e("../Text/index.cjs");n.MAP_BADGECOUNT_SIZE_TEXTVARIANT={[s.BadgeCountSize.Md]:r.TextVariant.BodyXs,[s.BadgeCountSize.Lg]:r.TextVariant.BodySm},n.TWCLASSMAP_BADGECOUNT_SIZE_CONTAINER={[s.BadgeCountSize.Md]:"min-w-4 h-3.5 py-0 px-1",[s.BadgeCountSize.Lg]:"min-w-6 h-5 py-0.5 px-1.5"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeCount/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./BadgeCount.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeCount/BadgeCount.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeCount=n.BadgeCountSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"BadgeCountSize",{enumerable:!0,get:function(){return s.BadgeCountSize}});var r=e("./BadgeCount.cjs");Object.defineProperty(n,"BadgeCount",{enumerable:!0,get:function(){return r.BadgeCount}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeCount/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeIcon/BadgeIcon.cjs",{"../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeIcon=void 0;const a=o(e("react")),i=e("../../utils/tw-merge.cjs"),c=e("../Icon/index.cjs");n.BadgeIcon=(0,a.forwardRef)(({iconName:e,iconProps:t,className:n="",style:s,...r},o)=>{const m=(0,i.twMerge)("inline-flex size-4 items-center justify-center rounded-full bg-icon-default",n);return a.default.createElement("div",{ref:o,className:m,style:s,...r},a.default.createElement(c.Icon,{size:c.IconSize.Xs,name:e,...t,className:(0,i.twMerge)(t?.color?"":"text-background-default",t?.className)}))}),n.BadgeIcon.displayName="BadgeIcon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeIcon/BadgeIcon.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeIcon/index.cjs",{"./BadgeIcon.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeIcon/BadgeIcon.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeIcon=void 0;var s=e("./BadgeIcon.cjs");Object.defineProperty(n,"BadgeIcon",{enumerable:!0,get:function(){return s.BadgeIcon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeIcon/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/BadgeNetwork.cjs",{"../AvatarNetwork/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeNetwork=void 0;const a=o(e("react")),i=e("../AvatarNetwork/index.cjs");n.BadgeNetwork=(0,a.forwardRef)(({name:e,src:t,fallbackText:n,...s},r)=>a.default.createElement(i.AvatarNetwork,{name:e,src:t,fallbackText:n,ref:r,...s,size:i.AvatarNetworkSize.Xs,hasBorder:!0})),n.BadgeNetwork.displayName="BadgeNetwork"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/BadgeNetwork.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/index.cjs",{"./BadgeNetwork.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/BadgeNetwork.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeNetwork=void 0;var s=e("./BadgeNetwork.cjs");Object.defineProperty(n,"BadgeNetwork",{enumerable:!0,get:function(){return s.BadgeNetwork}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","./BadgeStatus.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.constants.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeStatus=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),m=e("./BadgeStatus.constants.cjs");n.BadgeStatus=(0,a.forwardRef)(({status:e,size:t=i.BadgeStatusSize.Md,hasBorder:n=!0,className:s,style:r,...o},d)=>{const u=(0,c.twMerge)("inline-flex rounded-full",n?"border-2 border-background-default":"",s),l=(0,c.twMerge)("z-10 rounded-full border-2",m.CLASSMAP_BADGESTATUS_SIZE[t],m.CLASSMAP_BADGESTATUS_STATUS_CIRCLE[e]);return a.default.createElement("div",{ref:d,className:u,style:r,...o},a.default.createElement("div",{className:l}))}),n.BadgeStatus.displayName="BadgeStatus"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CLASSMAP_BADGESTATUS_SIZE=n.CLASSMAP_BADGESTATUS_STATUS_CIRCLE=void 0;const s=e("../../types/index.cjs");n.CLASSMAP_BADGESTATUS_STATUS_CIRCLE={[s.BadgeStatusStatus.Active]:"bg-success-default border-success-default",[s.BadgeStatusStatus.Inactive]:"bg-default border-success-default",[s.BadgeStatusStatus.Disconnected]:"bg-icon-muted border-icon-muted",[s.BadgeStatusStatus.New]:"bg-primary-default border-primary-default",[s.BadgeStatusStatus.Attention]:"bg-error-default border-error-default"},n.CLASSMAP_BADGESTATUS_SIZE={[s.BadgeStatusSize.Md]:"h-2 w-2",[s.BadgeStatusSize.Lg]:"h-2.5 w-2.5"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeStatus/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./BadgeStatus.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeStatus/BadgeStatus.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeStatus=n.BadgeStatusStatus=n.BadgeStatusSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"BadgeStatusSize",{enumerable:!0,get:function(){return s.BadgeStatusSize}}),Object.defineProperty(n,"BadgeStatusStatus",{enumerable:!0,get:function(){return s.BadgeStatusStatus}});var r=e("./BadgeStatus.cjs");Object.defineProperty(n,"BadgeStatus",{enumerable:!0,get:function(){return r.BadgeStatus}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeStatus/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/BadgeWrapper.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeWrapper=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs");n.BadgeWrapper=(0,a.forwardRef)(({children:e,childrenContainerProps:t,badge:n,badgeContainerProps:s,position:r=i.BadgeWrapperPosition.BottomRight,positionAnchorShape:o=i.BadgeWrapperPositionAnchorShape.Circular,positionXOffset:m=0,positionYOffset:d=0,customPosition:u,className:l="",style:f,...h},p)=>{const[g,k]=(0,a.useState)(0),[b,y]=(0,a.useState)(0),[_,x]=(0,a.useState)(0),[w,v]=(0,a.useState)(0),j=(0,a.useRef)(null),O=(0,a.useRef)(null);(0,a.useLayoutEffect)(()=>{if(j.current){const{width:e,height:t}=j.current.getBoundingClientRect();k(e),y(t)}if(O.current){const{width:e,height:t}=O.current.getBoundingClientRect();x(e),v(t)}},[]);const C=(0,a.useMemo)(()=>{if(u)return u;const e=o===i.BadgeWrapperPositionAnchorShape.Rectangular?0:.1464*g,t=o===i.BadgeWrapperPositionAnchorShape.Rectangular?0:.1464*b,n=e-_/2+m,s=t-w/2+d;switch(r){case i.BadgeWrapperPosition.TopRight:return{top:s,right:n};case i.BadgeWrapperPosition.TopLeft:return{top:s,left:n};case i.BadgeWrapperPosition.BottomLeft:return{bottom:s,left:n};case i.BadgeWrapperPosition.BottomRight:default:return{bottom:s,right:n}}},[r,o,g,b,_,w,m,d,u]),T=(0,c.twMerge)("relative inline-flex self-start",l);return a.default.createElement("div",{ref:p,className:T,style:f,...h},a.default.createElement("div",{className:"inline-flex",ref:j,...t},e),a.default.createElement("div",{ref:O,className:"absolute",style:C,...s},n))}),n.BadgeWrapper.displayName="BadgeWrapper"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/BadgeWrapper.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./BadgeWrapper.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/BadgeWrapper.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BadgeWrapper=n.BadgeWrapperPositionAnchorShape=n.BadgeWrapperPosition=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"BadgeWrapperPosition",{enumerable:!0,get:function(){return s.BadgeWrapperPosition}}),Object.defineProperty(n,"BadgeWrapperPositionAnchorShape",{enumerable:!0,get:function(){return s.BadgeWrapperPositionAnchorShape}});var r=e("./BadgeWrapper.cjs");Object.defineProperty(n,"BadgeWrapper",{enumerable:!0,get:function(){return r.BadgeWrapper}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Box/Box.cjs",{"../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","./Box.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Box/Box.constants.cjs","@radix-ui/react-slot":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-slot/dist/index.js",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.Box=void 0;const a=e("@radix-ui/react-slot"),i=o(e("react")),c=e("../../utils/tw-merge.cjs"),m=e("./Box.constants.cjs");n.Box=(0,i.forwardRef)(({flexDirection:e,flexWrap:t,gap:n,alignItems:s,justifyContent:r,margin:o,marginTop:d,marginRight:u,marginBottom:l,marginLeft:f,marginHorizontal:h,marginVertical:p,padding:g,paddingTop:k,paddingRight:b,paddingBottom:y,paddingLeft:_,paddingHorizontal:x,paddingVertical:w,borderWidth:v,borderColor:j,backgroundColor:O,className:C="",style:T,asChild:A,children:E,...P},B)=>{const S=A?a.Slot:"div",I=(0,c.twMerge)(e?"flex":"",e,t,n!==undefined?m.TWCLASSMAP_BOX_GAP[n]:"",s,r,o!==undefined?m.TWCLASSMAP_BOX_MARGIN[o]:"",d!==undefined?m.TWCLASSMAP_BOX_MARGIN_TOP[d]:"",u!==undefined?m.TWCLASSMAP_BOX_MARGIN_RIGHT[u]:"",l!==undefined?m.TWCLASSMAP_BOX_MARGIN_BOTTOM[l]:"",f!==undefined?m.TWCLASSMAP_BOX_MARGIN_LEFT[f]:"",h!==undefined?m.TWCLASSMAP_BOX_MARGIN_HORIZONTAL[h]:"",p!==undefined?m.TWCLASSMAP_BOX_MARGIN_VERTICAL[p]:"",g!==undefined?m.TWCLASSMAP_BOX_PADDING[g]:"",k!==undefined?m.TWCLASSMAP_BOX_PADDING_TOP[k]:"",b!==undefined?m.TWCLASSMAP_BOX_PADDING_RIGHT[b]:"",y!==undefined?m.TWCLASSMAP_BOX_PADDING_BOTTOM[y]:"",_!==undefined?m.TWCLASSMAP_BOX_PADDING_LEFT[_]:"",x!==undefined?m.TWCLASSMAP_BOX_PADDING_HORIZONTAL[x]:"",w!==undefined?m.TWCLASSMAP_BOX_PADDING_VERTICAL[w]:"",v!==undefined?m.TWCLASSMAP_BOX_BORDER_WIDTH[v]:"",j,O,C);return i.default.createElement(S,{ref:B,className:I,style:T,...P},E)}),n.Box.displayName="Box"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Box/Box.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Box/Box.constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TWCLASSMAP_BOX_BORDER_WIDTH=n.TWCLASSMAP_BOX_PADDING_VERTICAL=n.TWCLASSMAP_BOX_PADDING_HORIZONTAL=n.TWCLASSMAP_BOX_PADDING_LEFT=n.TWCLASSMAP_BOX_PADDING_BOTTOM=n.TWCLASSMAP_BOX_PADDING_RIGHT=n.TWCLASSMAP_BOX_PADDING_TOP=n.TWCLASSMAP_BOX_PADDING=n.TWCLASSMAP_BOX_MARGIN_VERTICAL=n.TWCLASSMAP_BOX_MARGIN_HORIZONTAL=n.TWCLASSMAP_BOX_MARGIN_LEFT=n.TWCLASSMAP_BOX_MARGIN_BOTTOM=n.TWCLASSMAP_BOX_MARGIN_RIGHT=n.TWCLASSMAP_BOX_MARGIN_TOP=n.TWCLASSMAP_BOX_MARGIN=n.TWCLASSMAP_BOX_GAP=void 0,n.TWCLASSMAP_BOX_GAP={0:"gap-0",1:"gap-1",2:"gap-2",3:"gap-3",4:"gap-4",5:"gap-5",6:"gap-6",7:"gap-7",8:"gap-8",9:"gap-9",10:"gap-10",11:"gap-11",12:"gap-12"},n.TWCLASSMAP_BOX_MARGIN={0:"m-0",1:"m-1",2:"m-2",3:"m-3",4:"m-4",5:"m-5",6:"m-6",7:"m-7",8:"m-8",9:"m-9",10:"m-10",11:"m-11",12:"m-12"},n.TWCLASSMAP_BOX_MARGIN_TOP={0:"mt-0",1:"mt-1",2:"mt-2",3:"mt-3",4:"mt-4",5:"mt-5",6:"mt-6",7:"mt-7",8:"mt-8",9:"mt-9",10:"mt-10",11:"mt-11",12:"mt-12"},n.TWCLASSMAP_BOX_MARGIN_RIGHT={0:"mr-0",1:"mr-1",2:"mr-2",3:"mr-3",4:"mr-4",5:"mr-5",6:"mr-6",7:"mr-7",8:"mr-8",9:"mr-9",10:"mr-10",11:"mr-11",12:"mr-12"},n.TWCLASSMAP_BOX_MARGIN_BOTTOM={0:"mb-0",1:"mb-1",2:"mb-2",3:"mb-3",4:"mb-4",5:"mb-5",6:"mb-6",7:"mb-7",8:"mb-8",9:"mb-9",10:"mb-10",11:"mb-11",12:"mb-12"},n.TWCLASSMAP_BOX_MARGIN_LEFT={0:"ml-0",1:"ml-1",2:"ml-2",3:"ml-3",4:"ml-4",5:"ml-5",6:"ml-6",7:"ml-7",8:"ml-8",9:"ml-9",10:"ml-10",11:"ml-11",12:"ml-12"},n.TWCLASSMAP_BOX_MARGIN_HORIZONTAL={0:"mx-0",1:"mx-1",2:"mx-2",3:"mx-3",4:"mx-4",5:"mx-5",6:"mx-6",7:"mx-7",8:"mx-8",9:"mx-9",10:"mx-10",11:"mx-11",12:"mx-12"},n.TWCLASSMAP_BOX_MARGIN_VERTICAL={0:"my-0",1:"my-1",2:"my-2",3:"my-3",4:"my-4",5:"my-5",6:"my-6",7:"my-7",8:"my-8",9:"my-9",10:"my-10",11:"my-11",12:"my-12"},n.TWCLASSMAP_BOX_PADDING={0:"p-0",1:"p-1",2:"p-2",3:"p-3",4:"p-4",5:"p-5",6:"p-6",7:"p-7",8:"p-8",9:"p-9",10:"p-10",11:"p-11",12:"p-12"},n.TWCLASSMAP_BOX_PADDING_TOP={0:"pt-0",1:"pt-1",2:"pt-2",3:"pt-3",4:"pt-4",5:"pt-5",6:"pt-6",7:"pt-7",8:"pt-8",9:"pt-9",10:"pt-10",11:"pt-11",12:"pt-12"},n.TWCLASSMAP_BOX_PADDING_RIGHT={0:"pr-0",1:"pr-1",2:"pr-2",3:"pr-3",4:"pr-4",5:"pr-5",6:"pr-6",7:"pr-7",8:"pr-8",9:"pr-9",10:"pr-10",11:"pr-11",12:"pr-12"},n.TWCLASSMAP_BOX_PADDING_BOTTOM={0:"pb-0",1:"pb-1",2:"pb-2",3:"pb-3",4:"pb-4",5:"pb-5",6:"pb-6",7:"pb-7",8:"pb-8",9:"pb-9",10:"pb-10",11:"pb-11",12:"pb-12"},n.TWCLASSMAP_BOX_PADDING_LEFT={0:"pl-0",1:"pl-1",2:"pl-2",3:"pl-3",4:"pl-4",5:"pl-5",6:"pl-6",7:"pl-7",8:"pl-8",9:"pl-9",10:"pl-10",11:"pl-11",12:"pl-12"},n.TWCLASSMAP_BOX_PADDING_HORIZONTAL={0:"px-0",1:"px-1",2:"px-2",3:"px-3",4:"px-4",5:"px-5",6:"px-6",7:"px-7",8:"px-8",9:"px-9",10:"px-10",11:"px-11",12:"px-12"},n.TWCLASSMAP_BOX_PADDING_VERTICAL={0:"py-0",1:"py-1",2:"py-2",3:"py-3",4:"py-4",5:"py-5",6:"py-6",7:"py-7",8:"py-8",9:"py-9",10:"py-10",11:"py-11",12:"py-12"},n.TWCLASSMAP_BOX_BORDER_WIDTH={0:"border-0",1:"border",2:"border-2",4:"border-4",8:"border-8"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Box/Box.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Box/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./Box.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Box/Box.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Box=n.BoxBorderColor=n.BoxBackgroundColor=n.BoxJustifyContent=n.BoxAlignItems=n.BoxFlexWrap=n.BoxFlexDirection=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"BoxFlexDirection",{enumerable:!0,get:function(){return s.BoxFlexDirection}}),Object.defineProperty(n,"BoxFlexWrap",{enumerable:!0,get:function(){return s.BoxFlexWrap}}),Object.defineProperty(n,"BoxAlignItems",{enumerable:!0,get:function(){return s.BoxAlignItems}}),Object.defineProperty(n,"BoxJustifyContent",{enumerable:!0,get:function(){return s.BoxJustifyContent}}),Object.defineProperty(n,"BoxBackgroundColor",{enumerable:!0,get:function(){return s.BoxBackgroundColor}}),Object.defineProperty(n,"BoxBorderColor",{enumerable:!0,get:function(){return s.BoxBorderColor}});var r=e("./Box.cjs");Object.defineProperty(n,"Box",{enumerable:!0,get:function(){return r.Box}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Box/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/Button.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./variants/ButtonPrimary/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/index.cjs","./variants/ButtonSecondary/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/index.cjs","./variants/ButtonTertiary/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.Button=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("./variants/ButtonPrimary/index.cjs"),m=e("./variants/ButtonSecondary/index.cjs"),d=e("./variants/ButtonTertiary/index.cjs");n.Button=(0,a.forwardRef)(({variant:e=i.ButtonVariant.Primary,...t},n)=>{switch(e){case i.ButtonVariant.Primary:return a.default.createElement(c.ButtonPrimary,{ref:n,...t});case i.ButtonVariant.Secondary:return a.default.createElement(m.ButtonSecondary,{ref:n,...t});case i.ButtonVariant.Tertiary:return a.default.createElement(d.ButtonTertiary,{ref:n,...t});default:return a.default.createElement(c.ButtonPrimary,{ref:n,...t})}}),n.Button.displayName="Button"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/Button.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./Button.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/Button.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Button=n.ButtonSize=n.ButtonVariant=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"ButtonVariant",{enumerable:!0,get:function(){return s.ButtonVariant}}),Object.defineProperty(n,"ButtonSize",{enumerable:!0,get:function(){return s.ButtonSize}});var r=e("./Button.cjs");Object.defineProperty(n,"Button",{enumerable:!0,get:function(){return r.Button}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/ButtonPrimary.cjs",{"../../../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../../../ButtonBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonPrimary=void 0;const a=o(e("react")),i=e("../../../../utils/tw-merge.cjs"),c=e("../../../ButtonBase/index.cjs");n.ButtonPrimary=(0,a.forwardRef)(({className:e,isDanger:t,isInverse:n,isDisabled:s,isLoading:r,...o},m)=>{const d=!(s??r),u=(0,i.twMerge)(!t&&!n&&["bg-icon-default text-primary-inverse",r&&"bg-icon-default-pressed"],t&&!n&&["bg-error-default text-error-inverse",r&&"bg-error-default-pressed"],n&&!t&&["bg-default text-default",r&&"bg-default-pressed"],n&&t&&["bg-default text-error-default",r&&"bg-default-pressed"],d&&[!t&&!n&&["hover:bg-icon-default-hover","active:bg-icon-default-pressed"],t&&!n&&["hover:bg-error-default-hover","active:bg-error-default-pressed"],n&&!t&&["hover:bg-default-hover","active:bg-default-pressed"],n&&t&&["hover:bg-default-hover","active:bg-default-pressed"]],"focus-visible:outline-none focus-visible:ring-0",n?"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-4 focus-visible:outline-background-default":"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-default",r&&"cursor-not-allowed",s&&!r&&["opacity-50","cursor-not-allowed"],e);return a.default.createElement(c.ButtonBase,{ref:m,className:u,isDisabled:s,isLoading:r,...o})}),n.ButtonPrimary.displayName="ButtonPrimary"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/ButtonPrimary.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/index.cjs",{"../../../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./ButtonPrimary.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/ButtonPrimary.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonPrimary=n.ButtonPrimarySize=void 0;var s=e("../../../../types/index.cjs");Object.defineProperty(n,"ButtonPrimarySize",{enumerable:!0,get:function(){return s.ButtonPrimarySize}});var r=e("./ButtonPrimary.cjs");Object.defineProperty(n,"ButtonPrimary",{enumerable:!0,get:function(){return r.ButtonPrimary}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonPrimary/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/ButtonSecondary.cjs",{"../../../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../../../ButtonBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonSecondary=void 0;const a=o(e("react")),i=e("../../../../utils/tw-merge.cjs"),c=e("../../../ButtonBase/index.cjs");n.ButtonSecondary=(0,a.forwardRef)(({className:e,isDanger:t,isInverse:n,isDisabled:s,isLoading:r,...o},m)=>{const d=!(s??r),u=(0,i.twMerge)(!t&&!n&&["bg-muted text-default",r&&"bg-muted-pressed"],t&&!n&&["bg-muted text-error-default",r&&"bg-muted-pressed"],n&&!t&&["border-2 border-primary-inverse bg-transparent text-primary-inverse",r&&"bg-pressed"],n&&t&&["border-0 bg-default text-error-default",r&&"bg-default-pressed"],d&&[!t&&!n&&["hover:bg-muted-hover","active:bg-muted-pressed"],t&&!n&&["hover:bg-muted-hover","active:bg-muted-pressed"],n&&!t&&["hover:bg-hover","active:bg-pressed"],n&&t&&["hover:bg-default-hover","active:bg-default-pressed"]],"focus-visible:outline-none focus-visible:ring-0",n?"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-4 focus-visible:outline-background-default":"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-default",r&&"cursor-not-allowed",s&&!r&&["opacity-50","cursor-not-allowed"],e);return a.default.createElement(c.ButtonBase,{ref:m,className:u,isDisabled:s,isLoading:r,...o})}),n.ButtonSecondary.displayName="ButtonSecondary"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/ButtonSecondary.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/index.cjs",{"../../../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./ButtonSecondary.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/ButtonSecondary.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonSecondary=n.ButtonSecondarySize=void 0;var s=e("../../../../types/index.cjs");Object.defineProperty(n,"ButtonSecondarySize",{enumerable:!0,get:function(){return s.ButtonSecondarySize}});var r=e("./ButtonSecondary.cjs");Object.defineProperty(n,"ButtonSecondary",{enumerable:!0,get:function(){return r.ButtonSecondary}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonSecondary/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/ButtonTertiary.cjs",{"../../../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../../../ButtonBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonTertiary=void 0;const a=o(e("react")),i=e("../../../../utils/tw-merge.cjs"),c=e("../../../ButtonBase/index.cjs");n.ButtonTertiary=(0,a.forwardRef)(({className:e,isDanger:t,isInverse:n,isDisabled:s,isLoading:r,...o},m)=>{const d=!(s??r),u=(0,i.twMerge)(!t&&!n&&["bg-transparent text-primary-default",r&&"bg-pressed"],t&&!n&&["bg-transparent text-error-default",r&&"bg-error-muted-pressed text-error-default-pressed"],n&&!t&&["bg-transparent text-primary-inverse",r&&"bg-pressed"],n&&t&&["bg-default text-error-default",r&&"bg-default-pressed"],d&&["hover:bg-hover","active:bg-pressed",n&&t&&["hover:bg-default-hover","active:bg-default-pressed"],t&&!n&&["hover:bg-error-muted-hover","active:bg-error-muted-pressed"]],"focus-visible:outline-none focus-visible:ring-0",n?"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-4 focus-visible:outline-background-default":"focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-default",r&&"cursor-not-allowed",s&&!r&&["opacity-50","cursor-not-allowed"],e);return a.default.createElement(c.ButtonBase,{ref:m,className:u,isDisabled:s,isLoading:r,...o})}),n.ButtonTertiary.displayName="ButtonTertiary"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/ButtonTertiary.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/index.cjs",{"../../../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./ButtonTertiary.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/ButtonTertiary.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonTertiary=n.ButtonTertiarySize=void 0;var s=e("../../../../types/index.cjs");Object.defineProperty(n,"ButtonTertiarySize",{enumerable:!0,get:function(){return s.ButtonTertiarySize}});var r=e("./ButtonTertiary.cjs");Object.defineProperty(n,"ButtonTertiary",{enumerable:!0,get:function(){return r.ButtonTertiary}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Button/variants/ButtonTertiary/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs","./ButtonBase.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.constants.cjs","@radix-ui/react-slot":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-slot/dist/index.js",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonBase=void 0;const a=e("@radix-ui/react-slot"),i=o(e("react")),c=e("../../types/index.cjs"),m=e("../../utils/tw-merge.cjs"),d=e("../Icon/index.cjs"),u=e("../Text/index.cjs"),l=e("./ButtonBase.constants.cjs");n.ButtonBase=(0,i.forwardRef)(({children:e,className:t,size:n=c.ButtonBaseSize.Lg,isFullWidth:s,asChild:r,isDisabled:o,isLoading:f,loadingText:h,loadingIconProps:p,loadingTextProps:g,startIconName:k,startIconProps:b,startAccessory:y,endIconName:_,endIconProps:x,endAccessory:w,textProps:v,style:j,"aria-label":O,"aria-labelledby":C,"aria-describedby":T,"aria-pressed":A,"aria-expanded":E,"aria-controls":P,"aria-haspopup":B,...S},I)=>{const M=r?a.Slot:"button",D=!(o??f),q=(0,m.twMerge)("inline-flex items-center justify-center","rounded-xl px-4","font-medium text-default","bg-muted","min-w-20 overflow-hidden","relative",l.TWCLASSMAP_BUTTONBASE_SIZE_DIMENSION[n],s&&"w-full",D&&["transition-all","duration-100","ease-linear","active:scale-[0.97]","active:ease-[cubic-bezier(0.3,0.8,0.3,1)]"],(o||f)&&"cursor-not-allowed",o&&"opacity-50",t);return i.default.createElement(M,{ref:I,className:q,disabled:r?undefined:o??f,"aria-disabled":o?"true":undefined,"aria-busy":f?"true":undefined,"aria-label":O,"aria-labelledby":C,"aria-describedby":T,"aria-pressed":A,"aria-expanded":E,"aria-controls":P,"aria-haspopup":B,role:r?undefined:"button",tabIndex:r?undefined:o?-1:undefined,style:j,...S},k?i.default.createElement(d.Icon,{name:k,size:d.IconSize.Sm,className:(0,m.twMerge)("mr-2 shrink-0 text-inherit",b?.className),"aria-hidden":"true",...b}):y?i.default.createElement("span",{className:"mr-2","aria-hidden":"true"},y):null,i.default.createElement(a.Slottable,null,f?i.default.createElement(i.default.Fragment,null,i.default.createElement("span",{className:"absolute inline-flex items-center","aria-hidden":"true"},i.default.createElement(d.Icon,{name:d.IconName.Loading,size:d.IconSize.Sm,className:(0,m.twMerge)("mr-2 animate-spin text-inherit",p?.className),...p}),i.default.createElement(u.Text,{fontWeight:u.FontWeight.Medium,color:u.TextColor.Inherit,asChild:!0,...g},i.default.createElement("span",null,h))),i.default.createElement("span",{className:"invisible inline-flex items-center"},e),i.default.createElement("span",{className:"sr-only","aria-live":"polite","aria-atomic":"true"},h||"Loading")):e&&"string"==typeof e?i.default.createElement(u.Text,{fontWeight:u.FontWeight.Medium,color:u.TextColor.Inherit,asChild:!0,...v},i.default.createElement("span",null,e)):e),_?i.default.createElement(d.Icon,{name:_,size:d.IconSize.Sm,className:(0,m.twMerge)("ml-2 shrink-0 text-inherit",x?.className),"aria-hidden":"true",...x}):w?i.default.createElement("span",{className:"ml-2","aria-hidden":"true"},w):null)}),n.ButtonBase.displayName="ButtonBase"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TWCLASSMAP_BUTTONBASE_SIZE_DIMENSION=void 0;const s=e("../../types/index.cjs");n.TWCLASSMAP_BUTTONBASE_SIZE_DIMENSION={[s.ButtonBaseSize.Sm]:"h-8",[s.ButtonBaseSize.Md]:"h-10",[s.ButtonBaseSize.Lg]:"h-12"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./ButtonBase.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/ButtonBase.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonBase=n.ButtonBaseSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"ButtonBaseSize",{enumerable:!0,get:function(){return s.ButtonBaseSize}});var r=e("./ButtonBase.cjs");Object.defineProperty(n,"ButtonBase",{enumerable:!0,get:function(){return r.ButtonBase}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs","./ButtonIcon.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.constants.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonIcon=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),m=e("../Icon/index.cjs"),d=e("./ButtonIcon.constants.cjs");n.ButtonIcon=(0,a.forwardRef)(({className:e,iconName:t,iconProps:n,ariaLabel:s,isDisabled:r=!1,isInverse:o=!1,isFloating:u=!1,size:l=i.ButtonIconSize.Md,style:f,...h},p)=>{const g=!r,k=(0,c.twMerge)("inline-flex items-center justify-center p-0",d.TWCLASSMAP_BUTTONICON_SIZE_DIMENSION[l],u&&["rounded-full",!o&&"bg-icon-default text-background-default",o&&"bg-icon-default text-background-default"],!u&&["rounded bg-transparent",g&&"hover:bg-hover active:bg-pressed",!o&&"text-icon-default",o&&"text-background-default"],r&&"cursor-not-allowed opacity-50",e);return a.default.createElement("button",{ref:p,className:k,disabled:r,"aria-label":s,style:f,...h},a.default.createElement(m.Icon,{name:t,size:d.MAP_BUTTONICON_SIZE_ICONSIZE[l],className:(0,c.twMerge)("text-inherit",n?.className),...n}))}),n.ButtonIcon.displayName="ButtonIcon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAP_BUTTONICON_SIZE_ICONSIZE=n.TWCLASSMAP_BUTTONICON_SIZE_DIMENSION=void 0;const s=e("../../types/index.cjs"),r=e("../Icon/index.cjs");n.TWCLASSMAP_BUTTONICON_SIZE_DIMENSION={[s.ButtonIconSize.Sm]:"h-6 w-6",[s.ButtonIconSize.Md]:"h-8 w-8",[s.ButtonIconSize.Lg]:"h-10 w-10"},n.MAP_BUTTONICON_SIZE_ICONSIZE={[s.ButtonIconSize.Sm]:r.IconSize.Sm,[s.ButtonIconSize.Md]:r.IconSize.Md,[s.ButtonIconSize.Lg]:r.IconSize.Lg}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonIcon/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./ButtonIcon.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonIcon/ButtonIcon.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ButtonIcon=n.ButtonIconSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"ButtonIconSize",{enumerable:!0,get:function(){return s.ButtonIconSize}});var r=e("./ButtonIcon.cjs");Object.defineProperty(n,"ButtonIcon",{enumerable:!0,get:function(){return r.ButtonIcon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/ButtonIcon/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Checkbox/Checkbox.cjs",{"../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.Checkbox=void 0;const a=o(e("react")),i=e("../../utils/tw-merge.cjs"),c=e("../Icon/index.cjs"),m=e("../Text/index.cjs");n.Checkbox=(0,a.forwardRef)(({id:e,isSelected:t,isDisabled:n=!1,isInvalid:s=!1,label:r,labelProps:o,onChange:d,inputProps:u,checkboxContainerProps:l,checkedIconProps:f,className:h,style:p,...g},k)=>{const b=()=>{n||d?.(!t)};(0,a.useImperativeHandle)(k,()=>({toggle:b}),[b]);const y=(0,i.twMerge)("inline-flex items-center",n&&"cursor-not-allowed opacity-50",h),_=t?"bg-primary-default hover:bg-primary-default-hover active:bg-primary-default-pressed":"bg-default hover:bg-default-hover active:bg-default-pressed";let x="border-default";t?x="border-primary-default":s&&(x="border-error-default");const w=(0,i.twMerge)("relative flex size-6 items-center justify-center rounded border-2 p-0 transition-transform active:scale-95",_,x,l?.className),v=(0,i.twMerge)("pointer-events-none transition-opacity",t?"opacity-100":"opacity-0",f?.className);return a.default.createElement("label",{htmlFor:e,className:y,style:p,...g},a.default.createElement("div",{className:"relative"},a.default.createElement("input",{type:"checkbox",id:e,checked:t,disabled:n,"aria-invalid":s,onChange:e=>{n||d?.(e.target.checked)},onKeyDown:e=>{"Enter"===e.key&&(e.preventDefault(),b())},className:"absolute inset-0 size-full cursor-pointer opacity-0 disabled:cursor-not-allowed",...u}),a.default.createElement("div",{className:w,...l},a.default.createElement(c.Icon,{name:c.IconName.Check,color:c.IconColor.PrimaryInverse,size:c.IconSize.Sm,...f,className:v}))),r?a.default.createElement(m.Text,{asChild:!0,...o,className:(0,i.twMerge)("ml-3",o?.className)},a.default.createElement("span",null,r)):null)}),n.Checkbox.displayName="Checkbox"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Checkbox/Checkbox.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Checkbox/index.cjs",{"./Checkbox.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Checkbox/Checkbox.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Checkbox=void 0;var s=e("./Checkbox.cjs");Object.defineProperty(n,"Checkbox",{enumerable:!0,get:function(){return s.Checkbox}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Checkbox/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/Icon.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","./Icon.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/Icon.constants.cjs","./icons/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/index.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Icon=void 0;const r=s(e("react")),o=e("../../types/index.cjs"),a=e("../../utils/tw-merge.cjs"),i=e("./Icon.constants.cjs"),c=e("./icons/index.cjs");n.Icon=({name:e,size:t=o.IconSize.Md,color:n=o.IconColor.IconDefault,className:s,style:m,...d})=>{if(!e)return console.warn("Icon name is required"),null;const u=c.Icons[e];if(!u)return console.warn(`Icon "${e}" not found`),null;const l=(0,a.twMerge)("inline-block",i.TWCLASSMAP_ICON_SIZE_DIMENSION[t],n,s);return r.default.createElement(u,{className:l,...d,style:m})}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/Icon.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/Icon.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TWCLASSMAP_ICON_SIZE_DIMENSION=void 0;const s=e("../../types/index.cjs");n.TWCLASSMAP_ICON_SIZE_DIMENSION={[s.IconSize.Xs]:"w-3 h-3",[s.IconSize.Sm]:"w-4 h-4",[s.IconSize.Md]:"w-5 h-5",[s.IconSize.Lg]:"w-6 h-6",[s.IconSize.Xl]:"w-8 h-8"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/Icon.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Accessibility.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 6q-.825 0-1.412-.587C10 4.825 10 4.55 10 4s.196-1.02.588-1.413S11.45 2 12 2s1.02.196 1.413.587S14 3.45 14 4s-.196 1.02-.587 1.412S12.55 6 12 6M9 22V9q-1.5-.125-3.05-.375C4.4 8.375 3.933 8.25 3 8l.5-2q1.95.525 4.15.763C9.85 7 10.567 7 12 7s2.883-.08 4.35-.237S19.2 6.35 20.5 6l.5 2q-1.4.375-2.95.625C16.5 8.875 16 8.917 15 9v13h-2v-6h-2v6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Accessibility.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Activity.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m15.3 16.7 1.4-1.4-3.7-3.7V7h-2v5.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Activity.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Add.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 13H5v-2h6V5h2v6h6v2h-6v6h-2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Add.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCard.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v6H4v6h10v2zM4 8h16V6H4zm15 14v-3h-3v-2h3v-3h2v3h3v2h-3v3z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCard.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCircle.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 17h2v-4h4v-2h-4V7h-2v4H7v2h4zm1 5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCircle.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddSquare.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 17h2v-4h4v-2h-4V7h-2v4H7v2h4zm-6 4q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddSquare.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ai.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("g",{fillRule:"evenodd",clipRule:"evenodd"},a.createElement("path",{d:"M17.714 3A4.86 4.86 0 0 0 22 7.304a4.86 4.86 0 0 0-4.286 4.305 4.86 4.86 0 0 0-4.285-4.305A4.86 4.86 0 0 0 17.714 3M16.46 14.913a3.44 3.44 0 0 0 3.03 3.044A3.44 3.44 0 0 0 16.46 21a3.44 3.44 0 0 0-3.03-3.043 3.44 3.44 0 0 0 3.03-3.044M9.143 4.87a8.12 8.12 0 0 1-4.383 6.349 8 8 0 0 1-2.76.824c.985.11 1.915.396 2.76.826a8.12 8.12 0 0 1 4.383 6.348 8.12 8.12 0 0 1 4.383-6.349 8 8 0 0 1 2.76-.825 8 8 0 0 1-2.76-.825A8.12 8.12 0 0 1 9.143 4.87m0 4.348a9.6 9.6 0 0 1-2.818 2.825 9.6 9.6 0 0 1 2.818 2.826 9.6 9.6 0 0 1 2.818-2.826 9.6 9.6 0 0 1-2.818-2.825"}))));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ai.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AlternateEmail.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12v1.45q0 1.474-1.012 2.512C19.976 17 19.483 17 18.5 17q-.874 0-1.65-.375c-.776-.375-.95-.608-1.3-1.075q-.726.725-1.637 1.088C13.002 17 12.667 17 12 17q-2.075 0-3.537-1.462C7 14.075 7 13.383 7 12s.488-2.562 1.463-3.537S10.617 7 12 7s2.563.488 3.538 1.463S17 10.617 17 12v1.45q0 .65.425 1.1c.425.45.642.45 1.075.45s.792-.15 1.075-.45.425-.667.425-1.1V12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20h5v2zm0-7q1.25 0 2.125-.875C15 13.25 15 12.833 15 12s-.292-1.542-.875-2.125Q13.25 9 12 9c-1.25 0-1.542.292-2.125.875Q9 10.75 9 12c0 1.25.292 1.542.875 2.125A2.9 2.9 0 0 0 12 15"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AlternateEmail.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AppleLogo.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M14.935 5.204c.689-.863 1.156-2.022 1.033-3.206-1.009.05-2.24.666-2.952 1.53-.64.74-1.207 1.947-1.059 3.081 1.132.099 2.264-.566 2.978-1.405M15.955 6.83c-1.644-.097-3.042.935-3.828.935s-1.988-.885-3.289-.861c-1.693.025-3.263.983-4.122 2.508-1.767 3.049-.467 7.572 1.252 10.056.834 1.228 1.84 2.581 3.165 2.533 1.252-.05 1.742-.812 3.264-.812 1.52 0 1.963.812 3.288.787 1.374-.025 2.234-1.23 3.068-2.46.957-1.4 1.349-2.752 1.374-2.826-.025-.025-2.65-1.033-2.675-4.057-.025-2.532 2.061-3.737 2.16-3.812-1.178-1.744-3.019-1.94-3.657-1.99"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AppleLogo.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Apps.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 20q-.824 0-1.412-.587C4 18.826 4 18.55 4 18s.196-1.02.588-1.412S5.45 16 6 16s1.02.196 1.413.587S8 17.45 8 18s-.196 1.02-.587 1.413S6.55 20 6 20m6 0q-.825 0-1.412-.587C10 18.826 10 18.55 10 18s.196-1.02.588-1.412S11.45 16 12 16s1.02.196 1.413.587S14 17.45 14 18s-.196 1.02-.587 1.413S12.55 20 12 20m6 0q-.825 0-1.412-.587C16 18.826 16 18.55 16 18s.196-1.02.587-1.412S17.45 16 18 16s1.02.196 1.413.587S20 17.45 20 18s-.196 1.02-.587 1.413S18.55 20 18 20M6 14q-.824 0-1.412-.587C4 12.825 4 12.55 4 12s.196-1.02.588-1.412S5.45 10 6 10s1.02.196 1.413.588S8 11.45 8 12s-.196 1.02-.587 1.413S6.55 14 6 14m6 0q-.825 0-1.412-.587C10 12.825 10 12.55 10 12s.196-1.02.588-1.412S11.45 10 12 10s1.02.196 1.413.588S14 11.45 14 12s-.196 1.02-.587 1.413S12.55 14 12 14m6 0q-.825 0-1.412-.587C16 12.825 16 12.55 16 12s.196-1.02.587-1.412S17.45 10 18 10s1.02.196 1.413.588S20 11.45 20 12s-.196 1.02-.587 1.413S18.55 14 18 14M6 8q-.824 0-1.412-.587C4 6.825 4 6.55 4 6s.196-1.02.588-1.412S5.45 4 6 4s1.02.196 1.413.588S8 5.45 8 6s-.196 1.02-.587 1.413S6.55 8 6 8m6 0q-.825 0-1.412-.587C10 6.825 10 6.55 10 6s.196-1.02.588-1.412S11.45 4 12 4s1.02.196 1.413.588S14 5.45 14 6s-.196 1.02-.587 1.413S12.55 8 12 8m6 0q-.825 0-1.412-.587C16 6.825 16 6.55 16 6s.196-1.02.587-1.412S17.45 4 18 4s1.02.196 1.413.588S20 5.45 20 6s-.196 1.02-.587 1.413S18.55 8 18 8"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Apps.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Down.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M13 4v12.175l5.6-5.6L20 12l-8 8-8-8 1.4-1.425 5.6 5.6V4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Down.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Left.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M20 13H7.825l5.6 5.6L12 20l-8-8 8-8 1.425 1.4-5.6 5.6H20z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Left.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Right.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 11h12.175l-5.6-5.6L12 4l8 8-8 8-1.425-1.4 5.6-5.6H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Right.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Up.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 20V7.825l-5.6 5.6L4 12l8-8 8 8-1.4 1.425-5.6-5.6V20z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Up.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2UpRight.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m5.5 17.1 9.6-9.6H6.5v-2h12v12h-2V8.9l-9.6 9.6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2UpRight.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleDown.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 16 4-4-1.4-1.4-1.6 1.6V8h-2v4.2l-1.6-1.6L8 12zm0 6q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleDown.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleUp.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 16h2v-4.2l1.6 1.6L16 12l-4-4-4 4 1.4 1.4 1.6-1.6zm1 6q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleUp.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleLeft.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m17.7 4.886-5 7 5 7h-2.45l-5-7 5-7zm-5.95 0-5 7 5 7H9.3l-5-7 5-7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleLeft.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleRight.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m6.3 18.886 5-7-5-7h2.45l5 7-5 7zm5.95 0 5-7-5-7h2.45l5 7-5 7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleRight.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDown.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m2 7.887 1.775-1.775L12 14.337l8.225-8.225L22 7.887l-10 10z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDown.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDropDownCircle.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 15 4-4H8zm0 7q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDropDownCircle.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowLeft.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m15.112 21.886-10-10 10-10 1.775 1.775-8.225 8.224 8.225 8.226z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowLeft.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowRight.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8.887 22-1.775-1.775L15.337 12 7.112 3.775 8.887 2l10 10z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowRight.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowUp.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m22 16.113-1.775 1.775L12 9.661l-8.225 8.225L2 16.113l10-10z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowUp.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AttachMoney.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12.48 10.9c-2.27-.59-3-1.2-3-2.15 0-1.09 1.01-1.85 2.7-1.85 1.78 0 2.44.85 2.5 2.1h2.21c-.07-1.72-1.12-3.3-3.21-3.81V3h-3v2.16c-1.94.42-3.5 1.68-3.5 3.61 0 2.31 1.91 3.46 4.7 4.13 2.5.6 3 1.48 3 2.41 0 .69-.49 1.79-2.7 1.79-2.06 0-2.87-.92-2.98-2.1H7c.12 2.19 1.76 3.42 3.68 3.83V21h3v-2.15c1.95-.37 3.5-1.5 3.5-3.55 0-2.84-2.43-3.81-4.7-4.4"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/AttachMoney.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Attachment.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8.25 18q-2.6 0-4.425-1.825C2 14.35 2 13.483 2 11.75s.608-3.208 1.825-4.425S6.517 5.5 8.25 5.5h9.25q1.875 0 3.188 1.313C22 8.126 22 8.75 22 10s-.437 2.313-1.312 3.188S18.75 14.5 17.5 14.5H8.75q-1.15 0-1.95-.8c-.8-.8-.8-1.183-.8-1.95s.267-1.417.8-1.95A2.65 2.65 0 0 1 8.75 9H18v2H8.75a.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75h8.75q1.05-.025 1.775-.737C20 11.05 20 10.7 20 10s-.242-1.292-.725-1.775S18.2 7.5 17.5 7.5H8.25q-1.774-.025-3.012 1.225C3.999 9.975 4 10.567 4 11.75q0 1.75 1.238 2.975C6.475 15.95 7.067 15.967 8.25 16H18v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Attachment.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Backspace.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m11.4 16 2.6-2.6 2.6 2.6 1.4-1.4-2.6-2.6L18 9.4 16.6 8 14 10.6 11.4 8 10 9.4l2.6 2.6-2.6 2.6zM9 20a1.99 1.99 0 0 1-1.6-.8L2 12l5.4-7.2q.275-.375.7-.587C8.525 4 8.683 4 9 4h11q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm-4.5-8L9 18h11V6H9z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Backspace.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ban.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q1.35 0 2.6-.437c1.25-.437 1.6-.713 2.3-1.263L5.7 7.1a8 8 0 0 0-1.263 2.3A7.8 7.8 0 0 0 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20m6.3-3.1q.824-1.05 1.263-2.3c.439-1.25.437-1.7.437-2.6q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4q-1.35 0-2.6.437A8 8 0 0 0 7.1 5.7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ban.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bank.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 17.886v-7h2v7zm6 0v-7h2v7zm-9 4v-2h20v2zm15-4v-7h2v7zm-15-9v-2l10-5 10 5v2zm4.45-2h11.1L12 4.136z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bank.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/BankAssured.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 17v-7h2v7zm6 0v-7h2v7zM2 8V6l10-5 10 5v2zm4.475-2h11.05L12 3.25zM2 21v-2h12.05q.05.525.125 1.013c.075.487.125.654.225.987zm15-7.75V10h2v2.25zM20 24q-1.725-.425-2.862-1.987C16 20.45 16 19.816 16 18.55V16l4-2 4 2v2.55q0 1.9-1.137 3.463C21.726 23.575 21.15 23.717 20 24m-.725-3 3.475-3.45-1.05-1.05-2.425 2.375-.975-.975-1.05 1.075z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/BankAssured.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bold.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6.8 19V5h5.525q1.624 0 3 1C16.7 7 16.7 7.592 16.7 8.775q0 1.275-.575 1.963c-.575.688-.742.787-1.075.987q.625.275 1.387 1.025c.762.75.763 1.25.763 2.25q0 2.224-1.625 3.113c-1.625.889-2.1.887-3.05.887zm3.025-2.8h2.6q1.2 0 1.462-.612c.262-.613.263-.705.263-.888s-.088-.48-.263-.887-.687-.613-1.537-.613H9.825zm0-5.7h2.325q.825 0 1.2-.425a1.4 1.4 0 0 0 .375-.95q0-.6-.425-.975c-.425-.375-.65-.375-1.1-.375H9.825z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bold.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Book.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6.5 16q1.175 0 2.288.263c1.112.262 1.479.437 2.212.787V7.2q-1.024-.6-2.175-.9C7.674 6 7.283 6 6.5 6q-.9 0-1.788.175C3.824 6.35 3.55 6.467 3 6.7v9.9q.875-.3 1.737-.45C5.6 16 5.9 16 6.5 16m6.5 1.05q1.099-.525 2.213-.787C16.327 16 16.717 16 17.5 16q.9 0 1.763.15c.862.15 1.154.25 1.737.45V6.7q-.825-.35-1.712-.525C18.4 6 18.1 6 17.5 6q-1.175 0-2.325.3c-1.15.3-1.492.5-2.175.9zM12 20a9.6 9.6 0 0 0-2.6-1.475A8.2 8.2 0 0 0 6.5 18q-1.05 0-2.062.275c-1.012.275-1.321.442-1.938.775q-.525.275-1.012-.025C1 18.725 1 18.533 1 18.15V6.1q0-.274.138-.525c.138-.251.229-.292.412-.375q1.15-.6 2.4-.9C5.2 4 5.633 4 6.5 4q1.45 0 2.838.375C10.726 4.75 11.15 5 12 5.5A10.8 10.8 0 0 1 17.5 4q1.3 0 2.55.3c1.25.3 1.633.5 2.4.9q.274.125.413.375c.139.25.137.342.137.525v12.05q0 .575-.487.875c-.488.3-.663.208-1.013.025q-.925-.5-1.937-.775C18.55 18 18.2 18 17.5 18q-1.5 0-2.9.525c-1.4.525-1.8.842-2.6 1.475"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Book.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bookmark.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h12q.824 0 1.413.588C20.002 3.175 20 3.45 20 4v16q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V4h-2v7l-2.5-1.5L11 11V4H6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bookmark.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bridge.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M2 15.276c0-1.014.684-1.874 1.63-2.17C4.4 9.31 7.855 6.445 12 6.445c2.982 0 5.607 1.483 7.131 3.728a5.4 5.4 0 0 0-1.805.494A6.83 6.83 0 0 0 12 8.154c-3.215 0-5.906 2.172-6.594 5.084.77.374 1.3 1.146 1.3 2.038 0 1.259-1.054 2.28-2.353 2.28S2 16.534 2 15.275m17.647 2.28c1.3 0 2.353-1.021 2.353-2.28 0-1.22-.989-2.215-2.232-2.276l-.121-.003c-.379 0-.736.087-1.053.24-.771.375-1.3 1.147-1.3 2.04 0 1.258 1.053 2.278 2.353 2.278",clipRule:"evenodd"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bridge.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Briefcase.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 21q-.824 0-1.412-.587C1.999 19.826 2 19.55 2 19V8q0-.824.588-1.412C3.175 6 3.45 6 4 6h4V4q0-.824.588-1.412C9.176 1.999 9.45 2 10 2h4q.824 0 1.413.588C16 3.175 16 3.45 16 4v2h4q.824 0 1.413.588C22.002 7.176 22 7.45 22 8v11q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm6-15h4V4h-4zm10 9h-5v2H9v-2H4v4h16zm-9 0h2v-2h-2zm-7-2h5v-2h6v2h5V8H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Briefcase.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bulb.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-.65 0-1.175-.312c-.525-.312-.625-.488-.825-.838q-.825 0-1.412-.587C8 19.676 8 19.4 8 18.85V15.3q-1.474-.975-2.362-2.575c-.888-1.6-.888-2.225-.888-3.475q0-3.026 2.113-5.137C8.974 2.002 9.983 2 12 2q3.026 0 5.138 2.113c2.111 2.113 2.112 3.12 2.112 5.137q0 1.925-.887 3.5c-.887 1.575-1.38 1.9-2.363 2.55v3.55q0 .824-.587 1.413c-.588.589-.863.587-1.413.587A2.27 2.27 0 0 1 12 22m-2-3.15h4v-.9h-4zm0-1.9h4V16h-4zM9.8 14h1.45v-2.7l-2.2-2.2 1.05-1.05 1.9 1.9 1.9-1.9 1.05 1.05-2.2 2.2V14h1.45q1.35-.65 2.2-1.912c.85-1.262.85-1.788.85-2.838q0-2.2-1.525-3.725C14.2 4 13.467 4 12 4s-2.708.508-3.725 1.525S6.75 7.783 6.75 9.25q0 1.575.85 2.838C8.45 13.35 8.9 13.567 9.8 14"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bulb.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/BuySell.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M7 4.252H5v3H2v2h3v3h2v-3h3v-2H7zm11 1 1.06 1.06L5.627 19.749l-1.061-1.06zm4 11v-2h-8v2z",clipRule:"evenodd"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/BuySell.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cake.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 22q-.424 0-.712-.287C3 21.425 3 21.283 3 21v-5q0-.825.588-1.412C4.175 14 4.45 14 5 14v-4q0-.825.588-1.412C6.176 8 6.45 8 7 8h4V6.55q-.45-.3-.725-.725C10 5.4 10 5.2 10 4.8q0-.375.15-.737c.15-.362.25-.463.45-.663L12 2l1.4 1.4q.3.3.45.663c.15.363.15.487.15.737q0 .6-.275 1.025c-.275.425-.425.525-.725.725V8h4q.824 0 1.413.588c.589.588.587.862.587 1.412v4q.824 0 1.413.588c.589.588.587.862.587 1.412v5q0 .424-.287.713C20.425 22 20.283 22 20 22zm3-8h10v-4H7zm-2 6h14v-4H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cake.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calculator.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8 18h1.5v-2h2v-1.5h-2v-2H8v2H6V16h2zm5-.75h5v-1.5h-5zm0-2.5h5v-1.5h-5zm1.1-3.8 1.4-1.4 1.4 1.4 1.05-1.05-1.4-1.45 1.4-1.4L16.9 6l-1.4 1.4L14.1 6l-1.05 1.05 1.4 1.4-1.4 1.45zM6.25 9.2h5V7.7h-5zM5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calculator.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calendar.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 22q-.824 0-1.412-.587C2.999 20.826 3 20.55 3 20V6q0-.824.588-1.412C4.175 4 4.45 4 5 4h1V2h2v2h8V2h2v2h1q.824 0 1.413.588C21.002 5.176 21 5.45 21 6v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V10H5zM5 8h14V6H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calendar.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Call.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M19.95 21q-3.125 0-6.175-1.362c-3.05-1.363-3.883-2.196-5.55-3.863s-2.954-3.517-3.863-5.55Q3 7.175 3 4.05q0-.45.3-.75c.3-.3.45-.3.75-.3H8.1q.35 0 .625.237c.275.237.292.346.325.563l.65 3.5q.05.4-.025.675c-.075.275-.142.342-.275.475L6.975 10.9q.5.925 1.187 1.787c.687.862.963 1.13 1.513 1.663q.775.776 1.625 1.437c.85.661 1.167.846 1.8 1.213l2.35-2.35q.225-.225.587-.338c.362-.113.48-.095.713-.062l3.45.7q.35.1.575.362c.225.262.225.371.225.588v4.05q0 .45-.3.75c-.3.3-.45.3-.75.3M6.025 9l1.65-1.65L7.25 5H5.025q.125 1.024.35 2.025C5.6 8.026 5.742 8.35 6.025 9m8.95 8.95q.975.424 1.987.675c1.012.251 1.355.275 2.038.325v-2.2l-2.35-.475z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Call.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Camera.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 17.5q1.875 0 3.188-1.312C16.5 14.876 16.5 14.25 16.5 13s-.437-2.312-1.312-3.187S13.25 8.5 12 8.5s-2.312.438-3.187 1.313S7.5 11.75 7.5 13s.438 2.313 1.313 3.188S10.75 17.5 12 17.5m0-2q-1.05 0-1.775-.725T9.5 13c0-1.05.242-1.292.725-1.775Q10.95 10.5 12 10.5c1.05 0 1.292.242 1.775.725S14.5 12.3 14.5 13s-.242 1.292-.725 1.775S12.7 15.5 12 15.5M4 21q-.824 0-1.412-.587C1.999 19.826 2 19.55 2 19V7q0-.824.588-1.412C3.175 5 3.45 5 4 5h3.15L9 3h6l1.85 2H20q.824 0 1.413.588C22.002 6.176 22 6.45 22 7v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h16V7h-4.05l-1.825-2h-4.25L8.05 7H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Camera.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Campaign.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M18 13v-2h4v2zm1.2 7L16 17.6l1.2-1.6 3.2 2.4zm-2-12L16 6.4 19.2 4l1.2 1.6zM5 19v-4H4q-.824 0-1.412-.587C1.999 13.825 2 13.55 2 13v-2q0-.825.588-1.412C3.175 9 3.45 9 4 9h4l5-3v12l-5-3H7v4zm6-4.55v-4.9L8.55 11H4v2h4.55zm3 .9v-6.7q.675.6 1.088 1.462c.413.862.412 1.205.412 1.888s-.137 1.312-.412 1.887S14.45 14.95 14 15.35"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Campaign.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Candlestick.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M9 4H7v2H5v12h2v2h2v-2h2V6H9zm0 12H7V8h2zM19 8h-2V4h-2v4h-2v7h2v5h2v-5h2zm-2 5h-2v-3h2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Candlestick.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Card.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H4q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6M4 8h16V6H4zm0 4v6h16v-6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Card.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CardPos.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8.4 14.65q.224-.6.363-1.262c.139-.662.137-.905.137-1.388s-.046-.946-.137-1.387S8.55 9.75 8.4 9.35l-1.85.75q.15.45.25.925c.1.475.1.642.1.975s-.033.658-.1.975-.15.625-.25.925zM11.6 16q.425-.95.613-1.95c.188-1 .187-1.35.187-2.05s-.062-1.383-.187-2.05A8.7 8.7 0 0 0 11.6 8l-1.85.75q.35.75.5 1.563T10.4 12c0 .875-.05 1.146-.15 1.688s-.267 1.062-.5 1.562zm3.25 1.35q.525-1.25.788-2.587c.263-1.337.262-1.813.262-2.763s-.087-1.87-.262-2.762a13.3 13.3 0 0 0-.788-2.588l-1.85.8q.45 1.05.675 2.2T13.9 12c0 1.2-.075 1.583-.225 2.35s-.375 1.5-.675 2.2zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.263-2.683.788-3.9 1.237-2.275 2.137-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CardPos.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 17h2v-1h1q.424 0 .713-.287c.289-.287.287-.43.287-.713v-3q0-.424-.287-.712c-.287-.289-.43-.288-.713-.288h-3v-1h4V8h-2V7h-2v1h-1q-.424 0-.712.288C8.999 8.575 9 8.717 9 9v3q0 .424.288.713c.287.289.429.287.712.287h3v1H9v2h2zm-7 3q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h16V6H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Category.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 11V3h8v8zm0 10v-8h8v8zm10-10V3h8v8zm0 10v-8h8v8zM5 9h4V5H5zm10 0h4V5h-4zm0 10h4v-4h-4zM5 19h4v-4H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Category.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Chart.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M16 20v-7h4v7zm-6 0V4h4v16zm-6 0V9h4v11z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Chart.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Check.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m9.55 17.886-5.7-5.7 1.425-1.425 4.275 4.275 9.175-9.176 1.425 1.425z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Check.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CheckBold.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m9.55 18.686-6.5-6.5 2.25-2.25 4.25 4.25 9.15-9.15 2.25 2.25z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CheckBold.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CircleX.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8.4 17 3.6-3.6 3.6 3.6 1.4-1.4-3.6-3.6L17 8.4 15.6 7 12 10.6 8.4 7 7 8.4l3.6 3.6L7 15.6zm3.6 5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CircleX.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clear.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8.4 17 3.6-3.6 3.6 3.6 1.4-1.4-3.6-3.6L17 8.4 15.6 7 12 10.6 8.4 7 7 8.4l3.6 3.6L7 15.6zm3.6 5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clear.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clock.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m15.3 16.7 1.4-1.4-3.7-3.7V7h-2v5.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clock.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ClockFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m15.3 16.7 1.4-1.4-3.7-3.7V7h-2v5.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ClockFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Close.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6.4 19 5 17.6l5.6-5.6L5 6.4 6.4 5l5.6 5.6L17.6 5 19 6.4 13.4 12l5.6 5.6-1.4 1.4-5.6-5.6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Close.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cloud.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6.5 20q-2.275 0-3.887-1.575C1 16.85 1 16.092 1 14.575q0-1.95 1.175-3.475C3.35 9.575 3.983 9.433 5.25 9.15q.625-2.3 2.5-3.725C9.625 4 10.417 4 12 4q2.925 0 4.963 2.038C19 8.076 19 9.05 19 11q1.725.2 2.863 1.488C23 13.776 23 14.35 23 15.5q0 1.875-1.312 3.188C20.376 20 19.75 20 18.5 20zm0-2h12q1.05 0 1.775-.725C21 16.55 21 16.2 21 15.5s-.242-1.292-.725-1.775S19.2 13 18.5 13H17v-2q0-2.075-1.462-3.538C14.075 6 13.383 6 12 6s-2.562.487-3.537 1.462S7 9.617 7 11h-.5q-1.45 0-2.475 1.025C3 13.05 3 13.533 3 14.5s.342 1.792 1.025 2.475S5.533 18 6.5 18"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cloud.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudDownload.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6.5 20q-2.275 0-3.887-1.585C1 16.83 1 16.067 1 14.541q0-1.962 1.175-3.497A5.2 5.2 0 0 1 5.25 9.082q.425-1.812 2.125-3.447C9.075 4 9.717 4 11 4q.824 0 1.413.591C13 5.182 13 5.46 13 6.013V12.1l1.6-1.56L16 11.95l-4 4.025-4-4.025 1.4-1.41L11 12.1V6.014q-1.9.35-2.95 1.849Q7 9.359 7 10.943h-.5q-1.45 0-2.475 1.032A3.4 3.4 0 0 0 3 14.465q0 1.46 1.025 2.491A3.36 3.36 0 0 0 6.5 17.987h12q1.05 0 1.775-.73.725-.728.725-1.785c0-1.057-.242-1.3-.725-1.787a2.4 2.4 0 0 0-1.775-.729H17v-2.013q0-1.207-.55-2.251A5.6 5.6 0 0 0 15 6.918v-2.34q1.85.882 2.925 2.604C19 8.904 19 9.585 19 10.943q1.725.202 2.863 1.497A4.45 4.45 0 0 1 23 15.472q0 1.887-1.312 3.207C20.376 20 19.75 20 18.5 20z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudDownload.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudUpload.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6.5 20q-2.275 0-3.887-1.575C1 16.85 1 16.092 1 14.575q0-1.95 1.175-3.475C3.35 9.575 3.983 9.433 5.25 9.15q.625-2.3 2.5-3.725C9.625 4 10.417 4 12 4q2.925 0 4.963 2.038C19 8.076 19 9.05 19 11q1.725.2 2.863 1.488C23 13.776 23 14.35 23 15.5q0 1.875-1.312 3.188C20.376 20 19.75 20 18.5 20H13q-.825 0-1.412-.587C11 18.826 11 18.55 11 18v-5.15L9.4 14.4 8 13l4-4 4 4-1.4 1.4-1.6-1.55V18h5.5q1.05 0 1.775-.725C21 16.55 21 16.2 21 15.5s-.242-1.292-.725-1.775S19.2 13 18.5 13H17v-2q0-2.075-1.462-3.537C14.075 6 13.383 6 12 6s-2.562.488-3.537 1.463S7 9.617 7 11h-.5q-1.45 0-2.475 1.025C3 13.05 3 13.533 3 14.5s.342 1.792 1.025 2.475S5.533 18 6.5 18H9v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudUpload.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Code.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8 18-6-6 6-6 1.425 1.425-4.6 4.6L9.4 16.6zm8 0-1.425-1.425 4.6-4.6L14.6 7.4 16 6l6 6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Code.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CodeCircle.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10m-2.4-6.514L11 14.06l-2.175-2.175L11 9.712 9.6 8.286l-3.6 3.6zm4.8 0 3.6-3.6-3.6-3.6L13 9.71l2.175 2.175L13 14.06z",clipRule:"evenodd"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CodeCircle.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Coin.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11.1 19h1.75v-1.25q1.25-.225 2.15-.975c.9-.75.9-1.242.9-2.225q0-1.05-.6-1.925c-.6-.875-1.2-1.092-2.4-1.525q-1.5-.5-2.075-.875c-.575-.375-.575-.592-.575-1.025s.154-.775.463-1.025.754-.375 1.337-.375q.8 0 1.25.387c.45.387.517.58.65.963l1.6-.65q-.274-.875-1.012-1.525C13.8 6.325 13.5 6.3 12.9 6.25V5h-1.75v1.25q-1.25.275-1.95 1.1c-.7.825-.7 1.167-.7 1.85q0 1.175.688 1.9c.688.725 1.179.9 2.162 1.25q1.576.575 2.188 1.025c.612.45.612.692.612 1.175q0 .825-.587 1.212c-.587.387-.863.388-1.413.388s-1.037-.17-1.462-.512-.738-.855-.938-1.538l-1.65.65q.35 1.2 1.088 1.938c.738.738 1.129.829 1.912 1.012zm.9 3q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Coin.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Collapse.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 13v6H9v-4H5v-2zm4-8v4h4v2h-6V5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Collapse.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Confirmation.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m10.6 16.6 7.05-7.05-1.4-1.4-5.65 5.65-2.85-2.85-1.4 1.4zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Confirmation.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Connect.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4.925 19.075q-1.35-1.376-2.137-3.188A9.65 9.65 0 0 1 2 12q0-2.1.787-3.913a10.1 10.1 0 0 1 2.138-3.162L6.35 6.35A8.1 8.1 0 0 0 4.625 8.9Q4 10.35 4 12a7.8 7.8 0 0 0 2.35 5.65zM7.75 16.25q-.8-.825-1.275-1.913C6 13.25 6 12.833 6 12q0-1.275.475-2.363A6.1 6.1 0 0 1 7.75 7.75l1.425 1.425a4.1 4.1 0 0 0-.862 1.275Q8 11.175 8 12c0 .825.104 1.067.313 1.55q.312.725.862 1.275zM12 14q-.825 0-1.412-.588Q10 12.825 10 12c0-.825.196-1.02.588-1.413Q11.175 10 12 10c.825 0 1.02.196 1.413.587Q14 11.175 14 12c0 .825-.196 1.02-.587 1.412A1.93 1.93 0 0 1 12 14m4.25 2.25-1.425-1.425q.55-.55.863-1.275T16 12c0-.825-.104-1.067-.312-1.55a4.1 4.1 0 0 0-.863-1.275L16.25 7.75a6.1 6.1 0 0 1 1.275 1.887Q18 10.725 18 12q0 1.25-.475 2.337c-.475 1.087-.742 1.363-1.275 1.913m2.825 2.825L17.65 17.65a8.1 8.1 0 0 0 1.725-2.55Q20 13.65 20 12a7.8 7.8 0 0 0-2.35-5.65l1.425-1.425q1.35 1.35 2.138 3.162Q21.999 9.9 22 12q0 2.075-.787 3.887a10.5 10.5 0 0 1-2.138 3.188"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Connect.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Copy.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M9 18q-.825 0-1.412-.587C7 16.826 7 16.55 7 16V4q0-.824.588-1.412C8.176 1.999 8.45 2 9 2h9q.824 0 1.413.588C20.002 3.175 20 3.45 20 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h9V4H9zm-4 6q-.824 0-1.412-.587C2.999 20.826 3 20.55 3 20V6h2v14h11v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Copy.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CopySuccess.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M7.588 17.413Q8.175 18 9 18h9q.824 0 1.413-.587c.589-.587.587-.863.587-1.413V4q0-.824-.587-1.412C18.826 1.999 18.55 2 18 2H9q-.825 0-1.412.588C7 3.175 7 3.45 7 4v12q0 .824.588 1.413M18 16H9V4h9zM3.588 21.413Q4.175 22 5 22h11v-2H5V6H3v14q0 .824.588 1.413M12.7 12 10 9.491l1.084-.99 1.617 1.503L15.935 7 17 8.007z",clipRule:"evenodd"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CopySuccess.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CreditCheck.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 8h16V6H4zM2 6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v6H4v6h4.1v2H4q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18zm12.95 16-4.25-4.25 1.4-1.4 2.85 2.8 5.65-5.65 1.4 1.45zM4 6v12-4.5 2.825z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CreditCheck.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyFranc.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 21v-3H5v-2h2V3h11v2H9v6h8v2H9v3h4v2H9v3z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyFranc.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyLira.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M9 21v-5.15l-3 1.875V15.35l3-1.875v-2.35L6 13v-2.35l3-1.9V3h2v4.5L15 5v2.35l-4 2.525v2.35l4-2.5v2.35L11 14.6V19q2.075 0 3.538-1.462C16 16.076 16 15.383 16 14h2q0 2.925-2.037 4.963C13.926 21 12.95 21 11 21z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyLira.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyPound.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 21v-2l.413-.25q.411-.25.9-.737c.489-.488.62-.742.887-1.25s.4-1.096.4-1.763q0-.274-.037-.525c-.038-.251-.055-.325-.088-.475H6v-2h1.5a27 27 0 0 1-1.012-1.737Q6 9.35 6 8q0-2.3 1.6-3.9c1.6-1.6 2.367-1.6 3.9-1.6q1.774 0 3.15.975c1.376.975 1.575 1.492 1.975 2.525l-1.85.775q-.374-1-1.262-1.637C12.625 4.5 12.25 4.5 11.5 4.5q-1.45 0-2.475 1.025C8 6.55 8 7.033 8 8q0 1.2.6 2t1.225 2H14v2h-3.475q.05.225.063.475c.013.25.012.342.012.525q0 1.25-.437 2.25A7.3 7.3 0 0 1 9.1 19H14q1 0 1.525-.525c.525-.525.592-.8.725-1.35L18 18q-.275 1.375-1.412 2.188C15.45 21 14.966 21 14 21z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyPound.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyYuan.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 21v-7H6v-2h4.725L5 3h2.375L12 10.3 16.625 3H19l-5.725 9H18v2h-5v7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyYuan.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Customize.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 21v-6h2v2h8v2h-8v2zm-8-2v-2h6v2zm4-4v-2H3v-2h4V9h2v6zm4-2v-2h10v2zm4-4V3h2v2h4v2h-4v2zM3 7V5h10v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Customize.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Danger.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M1 21 12 2l11 19zm3.45-2h15.1L12 6zM12 18q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S12.283 16 12 16s-.52.096-.712.288S11 16.717 11 17s.096.52.288.713.429.287.712.287m-1-3h2v-5h-2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Danger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Dark.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 21q-3.75 0-6.375-2.625C3 15.75 3 14.5 3 12s.875-4.625 2.625-6.375S9.5 3 12 3a9 9 0 0 1 1.35.1q-1.026.725-1.637 1.888C11.102 6.15 11.1 6.6 11.1 7.5q0 2.25 1.575 3.825C14.25 12.9 15 12.9 16.5 12.9q1.375 0 2.525-.613c1.15-.613 1.392-.954 1.875-1.637A8.5 8.5 0 0 1 21 12q0 3.75-2.625 6.375C15.75 21 14.5 21 12 21m0-2q2.2 0 3.95-1.212c1.75-1.212 2.017-1.863 2.55-3.163q-.5.125-1 .2c-.5.075-.667.075-1 .075q-3.075 0-5.237-2.162T9.1 7.5q0-.5.075-1c.075-.5.117-.667.2-1q-1.95.8-3.163 2.55C5 9.8 5 10.533 5 12q0 2.9 2.05 4.95C9.1 19 10.067 19 12 19"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Dark.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/DarkFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 21q-3.75 0-6.375-2.625C3 15.75 3 14.5 3 12s.875-4.625 2.625-6.375S9.5 3 12 3a9 9 0 0 1 1.35.1q-1.026.725-1.637 1.888C11.102 6.15 11.1 6.6 11.1 7.5q0 2.25 1.575 3.825C14.25 12.9 15 12.9 16.5 12.9q1.375 0 2.525-.613c1.15-.613 1.392-.954 1.875-1.637A8.5 8.5 0 0 1 21 12q0 3.75-2.625 6.375C15.75 21 14.5 21 12 21"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/DarkFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Data.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M22 19q0 1.25-.875 2.125C20.25 22 19.833 22 19 22q-.975 0-1.75-.562c-.775-.562-.875-.855-1.075-1.438H14q-1.25 0-2.125-.875C11 18.25 11 17.833 11 17v-4H7.825q-.3.875-1.075 1.438C5.975 15 5.65 15 5 15q-1.25 0-2.125-.875C2 13.25 2 12.833 2 12s.292-1.542.875-2.125A2.9 2.9 0 0 1 5 9q.975 0 1.75.563c.775.562.875.854 1.075 1.437H11V7q0-1.25.875-2.125C12.75 4 13.167 4 14 4h2.175q.3-.875 1.075-1.437C18.025 2 18.35 2 19 2q1.25 0 2.125.875C22 3.75 22 4.167 22 5s-.292 1.542-.875 2.125S19.833 8 19 8q-.975 0-1.75-.562c-.775-.562-.875-.855-1.075-1.438H14q-.424 0-.712.288C12.999 6.575 13 6.717 13 7v4h3.175q.3-.875 1.075-1.437C18.025 9 18.35 9 19 9q1.25 0 2.125.875T22 12c0 1.25-.292 1.542-.875 2.125S19.833 15 19 15q-.975 0-1.75-.562c-.775-.563-.875-.855-1.075-1.438H13v4q0 .424.288.713c.287.288.429.287.712.287h2.175q.3-.875 1.075-1.437C18.025 16 18.35 16 19 16q1.25 0 2.125.875C22 17.75 22 18.167 22 19m-2 0q0-.424-.287-.712C19.425 18 19.283 18 19 18s-.52.096-.712.288S18 18.717 18 19s.096.52.288.713.429.287.712.287.52-.096.713-.287S20 19.283 20 19m0-7q0-.424-.287-.712c-.288-.289-.43-.288-.713-.288s-.52.096-.712.288S18 11.717 18 12s.096.52.288.713.429.287.712.287.52-.096.713-.287S20 12.283 20 12m0-7q0-.424-.287-.712C19.425 3.998 19.283 4 19 4s-.52.096-.712.287S18 4.717 18 5s.096.52.288.713S18.717 6 19 6s.52-.096.713-.287S20 5.283 20 5M6 12q0-.424-.287-.712C5.426 10.999 5.283 11 5 11s-.52.096-.712.288S4 11.717 4 12s.096.52.287.713S4.717 13 5 13s.52-.096.713-.287S6 12.283 6 12"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Data.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Description.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8 18h8v-2H8zm0-4h8v-2H8zm-2 8q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Description.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Details.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S8.283 15 8 15s-.52.096-.712.287S7 15.717 7 16s.096.52.288.712S7.717 17 8 17m0-4q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S8.283 11 8 11s-.52.096-.712.288S7 11.717 7 12s.096.52.288.713S7.717 13 8 13m0-4q.424 0 .713-.287C9.002 8.426 9 8.283 9 8s-.096-.52-.287-.712S8.283 7 8 7s-.52.096-.712.288S7 7.717 7 8s.096.52.288.713S7.717 9 8 9m3 8h6v-2h-6zm0-4h6v-2h-6zm0-4h6V7h-6zM5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Details.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Diagram.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3.5 18.5 2 17l7.5-7.5 4 4 7.1-8L22 6.9l-8.5 9.6-4-4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Diagram.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/DocumentCode.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"}),a.createElement("path",{d:"m11.12 15.613-1.232 1.253L6.721 13.7l3.167-3.168 1.232 1.254-1.914 1.914zM17.28 13.699l-3.168 3.167-1.232-1.253 1.914-1.914-1.914-1.914 1.232-1.254z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/DocumentCode.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Download.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 16-5-5 1.4-1.45 2.6 2.6V4h2v8.15l2.6-2.6L17 11zm-6 4q-.824 0-1.412-.587C4 18.826 4 18.55 4 18v-3h2v3h12v-3h2v3q0 .824-.587 1.413c-.587.589-.863.587-1.413.587z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Download.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Draft.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 1 9.05 5.4q.45.275.7.75c.25.475.25.65.25 1V19q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H4q-.824 0-1.412-.587C1.999 19.826 2 19.55 2 19V8.15q0-.525.25-1c.25-.475.4-.567.7-.75zm0 11.65L19.8 8 12 3.35 4.2 8zM12 15l-8-4.8V19h16v-8.8zm0 4h8H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Draft.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EcoLeaf.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5.4 19.599a8.3 8.3 0 0 1-1.762-2.601Q3 15.522 3 13.946q0-1.575.6-3.114t1.95-2.888q.875-.876 2.163-1.501t3.05-.988q1.761-.363 4.024-.438 2.263-.074 5.063.175.2 2.652.125 4.878c-.075 2.226-.187 2.822-.412 4.014s-.542 2.234-.95 3.126Q18 18.548 17.1 19.45q-1.324 1.326-2.812 1.938C12.8 22 12.283 22 11.25 22q-1.625 0-3.175-.638C6.525 20.724 6.15 20.35 5.4 19.6m2.8-.4q.725.424 1.488.612.762.189 1.562.188 1.15 0 2.275-.463c1.125-.463 1.467-.804 2.15-1.488q.45-.45.913-1.263.462-.813.8-2.126c.338-1.313.395-1.934.512-3.176q.175-1.864.05-4.44a57 57 0 0 0-2.762-.037q-1.538.012-3.063.237c-1.525.225-1.983.392-2.9.726q-1.375.5-2.25 1.375-1.125 1.126-1.55 2.226T5 13.696q0 1.476.563 2.589c.563 1.113.704 1.263.987 1.563q1.05-2.001 2.775-3.84a14.6 14.6 0 0 1 4.025-3.013 18.3 18.3 0 0 0-3.137 3.564Q8.875 16.548 8.2 19.2"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EcoLeaf.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Edit.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 19h1.425L16.2 9.225 14.775 7.8 5 17.575zm-2 2v-4.25L16.2 3.575q.3-.275.663-.425c.363-.15.495-.15.762-.15s.525.05.775.15.467.25.65.45L20.425 5q.3.275.437.65c.137.375.138.5.138.75q0 .4-.138.763c-.138.363-.237.462-.437.662L7.25 21zM15.475 8.525l-.7-.725L16.2 9.225z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Edit.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EditSquare.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587A1.92 1.92 0 0 1 3 19.003V5.02q0-.825.588-1.41c.587-.586.862-.588 1.412-.588h8.925l-2 1.998H5v13.983h14V12.06l2-1.997v8.939q0 .824-.587 1.41A1.93 1.93 0 0 1 19 21zm4-5.992v-4.245l9.175-9.164q.3-.3.675-.45T19.6 1a1.98 1.98 0 0 1 1.425.6l1.4 1.422q.275.3.425.662t.15.737-.137.736a1.9 1.9 0 0 1-.438.662l-9.175 9.189zm2-1.998h1.4l5.8-5.793-.7-.699-.725-.699L11 11.587z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EditSquare.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EncryptedAdd.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.55q0 .225-.025.475H17.95q.026-.25.038-.475c.012-.225.012-.3.012-.45V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3zm5 0v-3h-3v-2h3v-3h2v3h3v2h-3v3zm-6.5-7h3l-.575-3.225q.5-.25.788-.725C14 10.575 14 10.383 14 10q0-.825-.587-1.412C12.825 8 12.55 8 12 8s-1.02.196-1.412.588S10 9.45 10 10q0 .574.288 1.05c.287.476.454.558.787.725z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EncryptedAdd.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eraser.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M17.241 18.5H22v2h-6.763zm-12.523 2-2.13-2.125Q2.014 17.8 2 16.95c-.013-.85.18-1.05.564-1.45l11.02-11.4q.576-.6 1.415-.6t1.416.575l4.984 4.975q.576.575.576 1.425t-.576 1.425l-8.416 8.6zm7.414-2 7.864-8.05-4.959-4.95-11.07 11.4 1.602 1.6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eraser.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Error.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S12.283 15 12 15s-.52.096-.712.287S11 15.717 11 16s.096.52.288.712.429.288.712.288m-1-4h2V7h-2zm1 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Error.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ethereum.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M17.934 12.188 12 15.812l-5.938-3.624L12 2zM12 16.977l-5.938-3.625L12 22l5.937-8.648z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ethereum.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Exchange.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 23q-2.8 0-5.15-1.275C4.5 20.45 4 19.742 3 18.325V21H1v-6h6v2H4.525q1.2 1.8 3.163 2.9C9.65 21 10.433 21 12 21q1.874 0 3.513-.712c1.638-.712 2.041-1.117 2.85-1.925s1.45-1.759 1.925-2.85S21 13.25 21 12h2q0 2.275-.862 4.275c-.863 2-1.363 2.5-2.363 3.5s-2.167 1.788-3.5 2.363S13.517 23 12 23m-.9-4v-1.3q-1.174-.274-1.912-1.012c-.739-.738-.855-1.138-1.088-1.938l1.65-.65q.3 1.025.938 1.538c.637.512.912.512 1.462.512s1.02-.13 1.413-.387.587-.663.587-1.213q0-.725-.612-1.175c-.613-.45-1.138-.642-2.188-1.025q-1.475-.525-2.162-1.25C8.5 10.375 8.5 9.983 8.5 9.2q0-1.024.713-1.863c.713-.839 1.12-.92 1.937-1.087V5h1.75v1.25q.9.075 1.638.725c.737.65.829.942 1.012 1.525l-1.6.65q-.2-.575-.65-.963c-.45-.388-.717-.387-1.25-.387q-.875 0-1.338.375c-.463.375-.462.592-.462 1.025s.192.775.575 1.025 1.075.542 2.075.875q1.8.65 2.4 1.525c.6.875.6 1.225.6 1.925q0 .725-.25 1.275c-.25.55-.388.68-.663.938s-.595.466-.962.624-.758.28-1.175.363V19zM1 12q0-2.276.863-4.275c.863-1.999 1.362-2.5 2.362-3.5s2.167-1.787 3.5-2.362S10.483 1 12 1q2.8 0 5.15 1.275C19.5 3.55 20 4.258 21 5.675V3h2v6h-6V7h2.475q-1.2-1.8-3.162-2.9C14.35 3 13.567 3 12 3q-1.874 0-3.512.712c-1.638.712-2.042 1.117-2.85 1.925s-1.45 1.759-1.925 2.85S3 10.75 3 12z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Exchange.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Expand.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 21v-6h2v2.6l3.1-3.1 1.4 1.4L6.4 19H9v2zM15.9 9.5l-1.4-1.4L17.6 5H15V3h6v6h-2V6.4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Expand.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExpandVertical.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 22v-2h16v2zm8-3-4-4 1.4-1.4 1.6 1.55v-6.3L9.4 10.4 8 9l4-4 4 4-1.4 1.4L13 8.85v6.3l1.6-1.55L16 15zM4 4V2h16v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExpandVertical.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Explore.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m7.5 16.5 7-2 2-7-7 2zm4.5-3q-.625 0-1.062-.437c-.438-.438-.438-.646-.438-1.063s.146-.77.438-1.062.645-.438 1.062-.438.77.146 1.063.438.437.645.437 1.062-.146.77-.437 1.063-.646.437-1.063.437m0 8.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Explore.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExploreFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m7.5 16.5 7-2 2-7-7 2zm4.5-3q-.625 0-1.062-.437c-.438-.438-.438-.646-.438-1.063s.146-.77.438-1.062.645-.438 1.062-.438.77.146 1.063.438.437.645.437 1.062-.146.77-.437 1.063-.646.437-1.063.437m0 8.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExploreFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Export.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h7v2H5v14h14v-7h2v7q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Export.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Extension.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8.8 21H5q-.824 0-1.412-.587C3 19.826 3 19.55 3 19v-3.8q1.2 0 2.1-.762c.9-.763.9-1.155.9-1.938s-.3-1.43-.9-1.937S3.8 9.8 3 9.8V6q0-.825.588-1.412C4.176 4 4.45 4 5 4h4q0-1.05.725-1.775T11.5 1.5c1.05 0 1.292.242 1.775.725S14 3.3 14 4h4q.824 0 1.413.588C20.002 5.176 20 5.45 20 6v4q1.05 0 1.775.725c.725.725.725 1.075.725 1.775s-.242 1.292-.725 1.775S20.7 15 20 15v4q0 .824-.587 1.413c-.587.589-.863.587-1.413.587h-3.8q0-1.25-.787-2.125C12.625 18 12.25 18 11.5 18s-1.387.292-1.912.875S8.8 20.167 8.8 21M5 19h2.125q.6-1.65 1.925-2.325C10.375 16 10.75 16 11.5 16s1.567.225 2.45.675S15.475 17.9 15.875 19H18v-6h2q.2 0 .35-.15c.15-.15.15-.217.15-.35s-.05-.25-.15-.35S20.133 12 20 12h-2V6h-6V4q0-.2-.15-.35c-.15-.15-.217-.15-.35-.15s-.25.05-.35.15S11 3.867 11 4v2H5v2.2q1.35.5 2.175 1.675Q8 11.049 8 12.5q0 1.425-.825 2.6C6.35 16.275 5.9 16.45 5 16.8z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Extension.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eye.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 15.886q1.875 0 3.188-1.313C16.5 13.26 16.5 12.636 16.5 11.386s-.437-2.313-1.312-3.188S13.25 6.886 12 6.886s-2.312.437-3.187 1.312S7.5 10.136 7.5 11.386s.438 2.312 1.313 3.187S10.75 15.886 12 15.886m0-1.8q-1.125 0-1.912-.788C9.3 12.51 9.3 12.136 9.3 11.386s.263-1.388.788-1.913S11.25 8.686 12 8.686s1.388.262 1.913.787.787 1.163.787 1.913-.262 1.387-.787 1.912-1.163.788-1.913.788m0 4.8q-3.65 0-6.65-2.038c-3-2.038-3.45-3.18-4.35-5.462Q2.35 7.96 5.35 5.922T12 3.885t6.65 2.038T23 11.385q-1.35 3.426-4.35 5.463c-3 2.037-4.217 2.038-6.65 2.038m0-2q2.825 0 5.188-1.488c2.363-1.488 2.779-2.33 3.612-4.012a9.77 9.77 0 0 0-3.612-4.013Q14.825 5.886 12 5.886c-2.825 0-3.612.495-5.187 1.487A9.77 9.77 0 0 0 3.2 11.386q1.25 2.524 3.613 4.012c2.363 1.488 3.304 1.488 5.187 1.488"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eye.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EyeSlash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m16.1 13.186-1.45-1.45q.225-1.176-.675-2.2t-2.325-.8l-1.45-1.45a4.2 4.2 0 0 1 .863-.3 4.2 4.2 0 0 1 .937-.1q1.875 0 3.188 1.312C16.5 9.51 16.5 10.135 16.5 11.386q0 .5-.1.937t-.3.863m3.2 3.15-1.45-1.4q.95-.726 1.688-1.588c.738-.862.912-1.23 1.262-1.963q-1.25-2.524-3.587-4.012T12 5.886q-.725 0-1.425.1a10 10 0 0 0-1.375.3l-1.55-1.55a11.1 11.1 0 0 1 4.35-.85q3.775 0 6.725 2.087T23 11.385a11.7 11.7 0 0 1-1.512 2.738 11 11 0 0 1-2.188 2.212m.5 6.15-4.2-4.15q-.874.274-1.762.412T12 18.886q-3.775 0-6.725-2.088T1 11.386q.525-1.326 1.325-2.463A11.5 11.5 0 0 1 4.15 6.886l-2.75-2.8 1.4-1.4 18.4 18.4zM5.55 8.286q-.725.65-1.325 1.425A9 9 0 0 0 3.2 11.386q1.25 2.524 3.588 4.012T12 16.886q.5 0 .975-.063t.975-.137l-.9-.95q-.274.075-.525.112a3 3 0 0 1-.525.038q-1.875 0-3.188-1.313C7.5 13.26 7.5 12.636 7.5 11.386q0-.276.037-.525.038-.25.113-.525z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/EyeSlash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FaceId.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M3.682 5.48v2.167a.84.84 0 0 1-1.682 0V5.479C2 3.56 3.56 2 5.48 2h2.167a.84.84 0 0 1 0 1.682H5.479a1.8 1.8 0 0 0-1.797 1.797m3.965 14.838a.84.84 0 0 1 0 1.682H5.479A3.483 3.483 0 0 1 2 18.52v-2.167a.84.84 0 0 1 1.682 0v2.168a1.8 1.8 0 0 0 1.797 1.797zM22 16.353v2.168C22 20.44 20.44 22 18.52 22h-2.167a.84.84 0 0 1 0-1.682h2.168a1.8 1.8 0 0 0 1.797-1.797v-2.168a.84.84 0 0 1 1.682 0M22 5.48v2.168a.84.84 0 0 1-1.682 0V5.479a1.8 1.8 0 0 0-1.797-1.797h-2.168a.84.84 0 1 1 0-1.682h2.168C20.439 2 22 3.56 22 5.48m-8.631 4.146v3.619c0 .91-.74 1.651-1.652 1.651h-.414a.86.86 0 1 1 0-1.72h.346v-3.55a.86.86 0 0 1 1.72 0m3.505-.028v1.451a.831.831 0 1 1-1.663 0v-1.45a.831.831 0 0 1 1.663 0M8.07 11.88a.83.83 0 0 1-.832-.832v-1.45a.831.831 0 0 1 1.663 0v1.45c0 .46-.372.832-.831.832",clipRule:"evenodd"}),a.createElement("path",{d:"M15.62 16.872a.86.86 0 0 0-1.167-1.263c-.67.618-1.54.959-2.453.959s-1.783-.34-2.453-.96a.86.86 0 0 0-1.167 1.264c.988.912 2.274 1.415 3.62 1.415s2.631-.503 3.62-1.415"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FaceId.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Feedback.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 15q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 13 12 13s-.52.096-.712.288S11 13.717 11 14s.096.52.288.713.429.287.712.287m-1-4h2V5h-2zM2 22V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6zm3.15-6H20V4H4v13.125z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Feedback.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/File.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/File.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Filter.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M10 18v-2h4v2zm-4-5v-2h12v2zM3 8V6h18v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Filter.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fingerprint.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11.97 4.468q2.65 0 5 1.137a10.45 10.45 0 0 1 3.926 3.288q.174.225.112.4a.7.7 0 0 1-.212.3.48.48 0 0 1-.35.112q-.2-.012-.35-.212a9.05 9.05 0 0 0-3.538-2.988q-2.162-1.037-4.587-1.037c-2.425 0-3.134.346-4.55 1.037a9.3 9.3 0 0 0-3.525 2.988q-.15.225-.35.25a.44.44 0 0 1-.35-.1q-.175-.126-.213-.313c-.038-.187.013-.254.113-.387a10.7 10.7 0 0 1 3.887-3.3 10.95 10.95 0 0 1 4.988-1.175m0 2.35q3.376 0 5.8 2.25 2.426 2.25 2.426 5.575 0 1.25-.888 2.087-.887.838-2.162.838c-1.275 0-1.58-.28-2.188-.838q-.912-.837-.912-2.087 0-.825-.613-1.388c-.613-.563-.896-.562-1.462-.562s-1.055.187-1.463.562-.612.838-.612 1.388q0 2.424 1.437 4.05 1.437 1.624 3.713 2.275.225.075.3.25a.575.575 0 0 1-.175.675q-.15.125-.375.075-2.6-.65-4.25-2.588-1.65-1.937-1.65-4.737 0-1.251.9-2.1t2.175-.85c1.275 0 1.575.283 2.175.85q.9.849.9 2.1 0 .825.625 1.387c.625.562.908.563 1.475.563s1.05-.188 1.45-.563.6-.837.6-1.387q0-2.901-2.125-4.875t-5.075-1.975c-2.95 0-3.659.658-5.075 1.975q-2.125 1.974-2.125 4.85 0 .6.112 1.5c.112.9.254 1.3.538 2.1q.075.225-.013.4a.5.5 0 0 1-.287.25.496.496 0 0 1-.65-.3q-.376-.975-.538-1.938a12 12 0 0 1-.162-1.987q0-3.325 2.412-5.575t5.763-2.25m0-4.8q1.6 0 3.126.387 1.525.389 2.95 1.113.225.125.262.3a.57.57 0 0 1-.037.35.57.57 0 0 1-.25.275q-.176.1-.425-.025a13.3 13.3 0 0 0-2.738-1.038 11.6 11.6 0 0 0-2.887-.362q-1.45 0-2.85.337-1.4.338-2.675 1.063a.47.47 0 0 1-.4.062.5.5 0 0 1-.3-.262.48.48 0 0 1-.05-.363q.05-.162.25-.287 1.4-.75 2.925-1.15t3.1-.4m0 7.225q2.326 0 4 1.562 1.676 1.563 1.676 3.838a.5.5 0 0 1-.138.362.5.5 0 0 1-.362.138.5.5 0 0 1-.35-.138.47.47 0 0 1-.15-.362q0-1.875-1.388-3.138t-3.287-1.262c-1.9 0-2.355.42-3.263 1.262q-1.362 1.263-1.362 3.138 0 2.025.7 3.437.7 1.413 2.05 2.838a.48.48 0 0 1 0 .7.48.48 0 0 1-.7 0q-1.476-1.55-2.263-3.163c-.787-1.613-.787-2.346-.787-3.812q0-2.275 1.65-3.838 1.65-1.562 3.975-1.562m-.024 4.9q.225 0 .362.15c.137.15.138.216.138.35q0 1.875 1.35 3.075c1.35 1.2 1.95 1.2 3.15 1.2q.15 0 .425-.025t.575-.075q.225-.05.387.062c.162.112.18.188.213.338q.05.2-.075.35a.48.48 0 0 1-.325.2q-.45.125-.788.137-.337.013-.412.013-2.226 0-3.863-1.5c-1.637-1.5-1.637-2.259-1.637-3.775q0-.2.137-.35c.137-.15.213-.15.363-.15"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fingerprint.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fire.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 14q0 1.3.525 2.463c.525 1.162.85 1.454 1.5 2.037A1 1 0 0 1 8 18.275v-.225q0-.8.3-1.5c.3-.7.492-.892.875-1.275L12 12.5l2.825 2.775q.575.575.875 1.275c.3.7.3.967.3 1.5v.225q0 .1-.025.225.975-.874 1.5-2.037C18 15.298 18 14.866 18 14q0-1.249-.462-2.363c-.462-1.114-.755-1.404-1.338-1.987q-.5.326-1.05.487c-.55.161-.742.163-1.125.163q-1.55 0-2.687-1.025C10.2 8.25 10.142 7.75 10.025 6.75Q9.05 7.575 8.3 8.462c-.75.887-.92 1.192-1.262 1.8q-.513.914-.775 1.863C6 13.074 6 13.383 6 14m6 1.3-1.425 1.4q-.275.275-.425.625c-.15.35-.15.475-.15.725q0 .8.587 1.375C11.174 20 11.45 20 12 20s1.02-.192 1.412-.575.588-.842.588-1.375q0-.4-.15-.737a1.6 1.6 0 0 0-.425-.613zM12 3v3.3q0 .85.588 1.425c.588.575.87.575 1.437.575q.45 0 .838-.188c.388-.188.487-.312.687-.562L16 7q1.85 1.05 2.925 2.925C20 11.8 20 12.533 20 14q0 3.35-2.325 5.675C15.35 22 14.233 22 12 22q-3.35 0-5.675-2.325C4 17.35 4 16.233 4 14q0-3.225 2.163-6.125C8.325 4.975 9.55 4.317 12 3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fire.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FirstPage.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5.8 18V6h2v12zm11 0-6-6 6-6 1.4 1.4-4.6 4.6 4.6 4.6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FirstPage.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flag.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 20.5v-17h9l.4 2H20v10h-7l-.4-2H7v7zm9.65-7H18v-6h-5.25l-.4-2H7v6h7.25z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flag.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 15.486 3.2-4.6h-2.85l2-7H9v8h3zm-2 6.4v-8H7v-12h10l-2 7h4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FlashSlash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 1.886h10l-2 7h4l-2.925 4.225-1.425-1.426.55-.8h-1.35L12.675 9.71l1.675-5.825H9v2.15l-2-2zm3 20v-8H7v-4.15L1.375 4.11 2.8 2.686l18.4 18.4-1.425 1.425-6.025-6.025z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FlashSlash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flask.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-1.275 0-1.812-1.137t.262-2.113L9 11V5H8a.97.97 0 0 1-.712-.287Q7 4.425 7 4c0-.425.096-.52.288-.712A.97.97 0 0 1 8 3h8q.425 0 .713.288C17 3.576 17 3.717 17 4s-.096.52-.287.713S16.283 5 16 5h-1v6l5.55 6.75q.8.975.263 2.113C20.276 21 19.85 21 19 21zm2-3h10l-3.4-4h-3.2zm-2 1h14l-6-7.3V5h-2v6.7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flask.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flower.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M10.65 20a5.7 5.7 0 0 0-1.4-2.225q-.475-.476-1.025-.837c-.55-.361-.767-.438-1.2-.588q.05.725.35 1.35c.3.625.467.792.8 1.125s.708.604 1.125.813.867.329 1.35.362m2.7 0q.725-.075 1.35-.375c.625-.3.792-.467 1.125-.8s.6-.708.8-1.125.325-.867.375-1.35q-.65.225-1.212.575c-.563.35-.721.508-1.038.825s-.592.662-.825 1.037-.425.78-.575 1.213M12 11q1.65 0 2.825-1.175T16 7V5.8l-1.75 1.475L12 4.55 9.75 7.275 8 5.8V7q0 1.65 1.175 2.825T12 11m-1 11q-2.5 0-4.25-1.75C5 18.5 5 17.667 5 16v-2q1.775-.025 3.35.725c1.575.75 1.933 1.175 2.65 2.025v-3.825q-2.15-.35-3.575-2.013T6 7V3.6q0-.65.575-.912c.575-.262.742-.121 1.075.162l1.85 1.6 1.725-2.1Q11.525 2 12 2c.475 0 .575.117.775.35l1.725 2.1 1.85-1.6q.5-.425 1.075-.162C18 2.95 18 3.167 18 3.6V7q0 2.25-1.425 3.913T13 12.925v3.825q1.075-1.275 2.65-2.025c1.575-.75 2.167-.742 3.35-.725v2q0 2.5-1.75 4.25C15.5 22 14.667 22 13 22z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flower.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Folder.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h6l2 2h8q.824 0 1.413.588C22.002 7.176 22 7.45 22 8v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h16V8h-8.825l-2-2H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Folder.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Forest.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("clipPath",{id:"a"},a.createElement("path",{d:"M0 0h24v24H0z"})),a.createElement("g",{clipPath:"url(#a)"},a.createElement("path",{d:"M7 22v-4H0l3.85-6H2L9 2l3 4.3L15 2l7 10h-1.85L24 18h-7v4h-4v-4h-2v4zm9.725-6h3.625l-3.875-6h1.675L15 5.5l-1.775 2.525L16 12h-1.85zM3.65 16h10.7l-3.875-6h1.675L9 5.5 5.85 10h1.675zm0 0h3.875H5.85h6.3-1.675 3.875zm13.075 0H14.15 16h-2.775 4.925-1.675 3.875z"}))));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Forest.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FullCircle.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/FullCircle.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gas.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 21V5q0-.824.588-1.412C5.176 2.999 5.45 3 6 3h6q.824 0 1.413.588C14 4.175 14 4.45 14 5v7h1q.824 0 1.413.588c.589.588.587.862.587 1.412v4.5q0 .424.288.713c.288.288.429.287.712.287s.52-.096.713-.287.287-.43.287-.713v-7.2q-.225.125-.475.163c-.25.038-.342.037-.525.037q-1.05 0-1.775-.725C15.5 10.05 15.5 9.7 15.5 9q0-.8.438-1.437c.438-.637.679-.73 1.162-.913L15 4.55l1.05-1.05 3.7 3.6q.375.375.563.875c.188.5.187.675.187 1.025v9.5q0 1.05-.725 1.775C19.05 21 18.7 21 18 21s-1.292-.242-1.775-.725S15.5 19.2 15.5 18.5v-5H14V21zm2-11h6V5H6zm12 0q.424 0 .713-.287C19 9.426 19 9.283 19 9s-.096-.52-.287-.712S18.283 8 18 8s-.52.096-.712.288S17 8.717 17 9s.096.52.288.713.429.287.712.287M6 19h6v-7H6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gas.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gift.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 22V11H2V5h5.2q-.125-.225-.162-.475A3 3 0 0 1 7 4q0-1.25.875-2.125C8.75 1 9.167 1 10 1q.575 0 1.075.213c.5.212.642.337.925.587q.425-.4.925-.6c.5-.2.692-.2 1.075-.2q1.25 0 2.125.875C17 2.75 17 3.167 17 4q0 .274-.05.513c-.05.239-.083.32-.15.487H22v6h-2v11zM14 3q-.424 0-.712.288C12.999 3.576 13 3.717 13 4s.096.52.288.713S13.717 5 14 5s.52-.096.713-.287S15 4.283 15 4s-.096-.52-.287-.712S14.283 3 14 3M9 4q0 .424.288.713c.287.289.429.287.712.287q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S10.283 3 10 3q-.424 0-.712.288C8.999 3.576 9 3.717 9 4M4 7v2h7V7zm7 13v-9H6v9zm2 0h5v-9h-5zm7-11V7h-7v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gift.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Global.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-2.05 0-3.875-.787c-1.825-.788-2.28-1.242-3.187-2.15s-1.625-1.971-2.15-3.188S2 13.367 2 12q0-2.075.788-3.887c.788-1.812 1.241-2.267 2.15-3.175s1.97-1.625 3.187-2.15S10.633 2 12 2q2.075 0 3.888.788c1.812.788 2.266 1.241 3.174 2.15s1.625 1.966 2.15 3.175S22 10.617 22 12q0 2.05-.787 3.875c-.788 1.825-1.242 2.28-2.15 3.188s-1.967 1.625-3.175 2.15S13.383 22 12 22m0-2.05q.65-.9 1.125-1.875c.475-.975.575-1.342.775-2.075h-3.8q.3 1.1.775 2.075c.475.975.692 1.275 1.125 1.875m-2.6-.4q-.45-.825-.787-1.712A11.6 11.6 0 0 1 8.05 16H5.1q.725 1.25 1.813 2.175C8 19.1 8.467 19.25 9.4 19.55m5.2 0q1.4-.45 2.488-1.375c1.088-.925 1.329-1.342 1.812-2.175h-2.95q-.225.95-.562 1.838c-.337.887-.488 1.162-.788 1.712M4.25 14h3.4q-.075-.5-.112-.987C7.5 12.525 7.5 12.35 7.5 12a13 13 0 0 1 .15-2h-3.4q-.125.5-.187.988C4 11.476 4 11.65 4 12a8 8 0 0 0 .25 2m5.4 0h4.7q.075-.5.113-.987c.038-.488.037-.663.037-1.013a13 13 0 0 0-.15-2h-4.7q-.075.5-.112.988C9.5 11.476 9.5 11.65 9.5 12a13 13 0 0 0 .15 2m6.7 0h3.4q.125-.5.188-.987C20 12.525 20 12.35 20 12a8 8 0 0 0-.25-2h-3.4q.075.5.113.988c.038.488.037.662.037 1.012a13 13 0 0 1-.15 2m-.4-6h2.95q-.725-1.25-1.812-2.175C16 4.9 15.533 4.75 14.6 4.45q.45.824.788 1.713c.338.888.412 1.204.562 1.837M10.1 8h3.8q-.3-1.1-.775-2.075C12.65 4.95 12.433 4.65 12 4.05q-.65.9-1.125 1.875C10.4 6.9 10.3 7.267 10.1 8m-5 0h2.95q.225-.95.563-1.837C8.95 5.275 9.1 5 9.4 4.45Q8 4.9 6.913 5.825C5.826 6.75 5.583 7.167 5.1 8"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Global.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/GlobalSearch.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11.75 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.063 17.117 2.538 15.9 1.75 13.383 1.75 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.633 3.312 7.85 2.787 10.367 2 11.75 2q3.65 0 6.388 2.287c2.737 2.287 2.962 3.438 3.412 5.738H19.5q-.475-1.825-1.712-3.263C16.55 5.324 15.95 5.083 14.75 4.6V5q0 .825-.587 1.412C13.576 7 13.3 7 12.75 7h-2v2q0 .424-.287.712c-.287.288-.43.288-.713.288h-2v2h2v3h-1l-4.8-4.8q-.075.45-.137.9c-.062.45-.063.6-.063.9q0 3.274 2.3 5.625c2.3 2.351 3.433 2.358 5.7 2.375zm9.1-.5-3.2-3.2q-.525.3-1.125.5c-.6.2-.825.2-1.275.2q-1.875 0-3.187-1.312C10.75 16.375 10.75 15.75 10.75 14.5s.438-2.312 1.313-3.187S14 10 15.25 10s2.313.438 3.188 1.313S19.75 13.25 19.75 14.5q0 .675-.2 1.275c-.2.6-.3.775-.5 1.125l3.2 3.2zm-5.6-4.5q1.05 0 1.775-.725c.725-.725.725-1.075.725-1.775s-.242-1.292-.725-1.775S15.95 12 15.25 12s-1.292.242-1.775.725-.725 1.075-.725 1.775.242 1.292.725 1.775S14.55 17 15.25 17"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/GlobalSearch.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Graph.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 21.975q-2.075 0-3.9-.788c-1.825-.788-2.275-1.241-3.175-2.15s-1.612-1.97-2.137-3.187S2 13.342 2 11.975q0-3.925 2.6-6.75t6.4-3.2v3q-2.576.35-4.287 2.312Q5 9.301 5 11.975q0 2.9 2.05 4.95c2.05 2.05 3.017 2.05 4.95 2.05q1.65 0 3.088-.7c1.438-.7 1.762-1.1 2.412-1.9l2.6 1.5q-1.35 1.875-3.475 2.987C14.5 21.974 13.667 21.975 12 21.975m9.15-5.95-2.6-1.5q.225-.6.337-1.238c.112-.638.113-.862.113-1.312q0-2.675-1.713-4.638Q15.575 5.375 13 5.025v-3q3.8.375 6.4 3.2t2.6 6.75q0 1.1-.2 2.125c-.2 1.025-.35 1.325-.65 1.925"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Graph.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hardware.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 21q-1.25 0-2.125-.875C1 19.25 1 18.833 1 18q0-.975.563-1.75c.563-.775.854-.875 1.437-1.075v-6.35q-.875-.3-1.437-1.075C1 6.975 1 6.65 1 6q0-1.25.875-2.125C2.75 3 3.167 3 4 3s1.542.292 2.125.875S7 5.167 7 6q0 .975-.562 1.75c-.562.775-.855.875-1.438 1.075V11h6V8.825q-.875-.3-1.437-1.075C9 6.975 9 6.65 9 6q0-1.25.875-2.125T12 3c1.25 0 1.542.292 2.125.875S15 5.167 15 6q0 .975-.562 1.75c-.563.775-.855.875-1.438 1.075V11h5q.424 0 .713-.287C19 10.426 19 10.283 19 10V8.825q-.875-.3-1.437-1.075C17 6.975 17 6.65 17 6q0-1.25.875-2.125C18.75 3 19.167 3 20 3s1.542.292 2.125.875S23 5.167 23 6q0 .975-.562 1.75c-.562.775-.855.875-1.438 1.075V10q0 1.25-.875 2.125C19.25 13 18.833 13 18 13h-5v2.175q.875.3 1.438 1.075C15 17.025 15 17.35 15 18q0 1.25-.875 2.125C13.25 21 12.833 21 12 21s-1.542-.292-2.125-.875A2.9 2.9 0 0 1 9 18q0-.975.563-1.75c.562-.775.854-.875 1.437-1.075V13H5v2.175q.875.3 1.438 1.075C7 17.025 7 17.35 7 18q0 1.25-.875 2.125C5.25 21 4.833 21 4 21m0-2q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S4.283 17 4 17s-.52.096-.712.288S3 17.717 3 18s.096.52.288.713S3.717 19 4 19M4 7q.424 0 .713-.287C5.002 6.426 5 6.283 5 6s-.096-.52-.287-.712S4.283 5 4 5s-.52.096-.712.288S3 5.717 3 6s.096.52.288.713S3.717 7 4 7m8 12q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S12.283 17 12 17s-.52.096-.712.288S11 17.717 11 18s.096.52.288.713.429.287.712.287m0-12q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 5 12 5s-.52.096-.712.288S11 5.717 11 6s.096.52.288.713S11.717 7 12 7m8 0q.424 0 .713-.287C21 6.426 21 6.283 21 6s-.096-.52-.287-.712S20.283 5 20 5s-.52.096-.712.288S19 5.717 19 6s.096.52.288.713S19.717 7 20 7"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hardware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/HashTag.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m6 20 1-4H3l.5-2h4l1-4h-4L5 8h4l1-4h2l-1 4h4l1-4h2l-1 4h4l-.5 2h-4l-1 4h4l-.5 2h-4l-1 4h-2l1-4H9l-1 4zm3.5-6h4l1-4h-4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/HashTag.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Heart.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 21-1.45-1.3q-2.525-2.275-4.175-3.925c-1.65-1.65-1.975-2.088-2.625-2.963S2.646 11.133 2.388 10.4A6.7 6.7 0 0 1 2 8.15Q2 5.8 3.575 4.225C5.15 2.65 5.933 2.65 7.5 2.65a5.8 5.8 0 0 1 2.475.55A5.9 5.9 0 0 1 12 4.75a5.9 5.9 0 0 1 2.025-1.55 5.8 5.8 0 0 1 2.475-.55q2.35 0 3.925 1.575C22 5.8 22 6.583 22 8.15q0 1.15-.387 2.25-.388 1.1-1.363 2.412c-.975 1.312-1.525 1.863-2.625 2.963s-2.492 2.408-4.175 3.925zm0-2.7q2.4-2.15 3.95-3.687c1.55-1.537 1.85-1.917 2.45-2.675q.9-1.139 1.25-2.025.35-.888.35-1.763 0-1.5-1-2.5t-2.5-1a3.86 3.86 0 0 0-2.175.663q-1 .662-1.375 1.687h-1.9q-.375-1.025-1.375-1.687A3.86 3.86 0 0 0 7.5 4.65q-1.5 0-2.5 1t-1 2.5q0 .874.35 1.763.35.886 1.25 2.025t2.45 2.674C9.6 16.15 10.4 16.868 12 18.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Heart.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/HeartFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 21-1.45-1.3q-2.525-2.275-4.175-3.925c-1.65-1.65-1.975-2.088-2.625-2.963S2.646 11.133 2.388 10.4A6.7 6.7 0 0 1 2 8.15Q2 5.8 3.575 4.225C5.15 2.65 5.933 2.65 7.5 2.65a5.8 5.8 0 0 1 2.475.55A5.9 5.9 0 0 1 12 4.75a5.9 5.9 0 0 1 2.025-1.55 5.8 5.8 0 0 1 2.475-.55q2.35 0 3.925 1.575C22 5.8 22 6.583 22 8.15q0 1.15-.387 2.25-.388 1.1-1.363 2.412c-.975 1.312-1.525 1.863-2.625 2.963s-2.492 2.408-4.175 3.925z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/HeartFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hierarchy.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 22q-1.25 0-2.125-.875C4 20.25 4 19.833 4 19q0-.975.563-1.75c.563-.775.854-.875 1.437-1.075v-8.35q-.875-.3-1.437-1.075C4 5.975 4 5.65 4 5q0-1.25.875-2.125C5.75 2 6.167 2 7 2s1.542.292 2.125.875S10 4.167 10 5q0 .975-.562 1.75c-.563.775-.855.875-1.438 1.075V8q0 1.25.875 2.125A2.9 2.9 0 0 0 11 11h2q2.075 0 3.538 1.463C18 13.926 18 14.617 18 16v.175q.875.3 1.438 1.075C20 18.025 20 18.35 20 19q0 1.25-.875 2.125C18.25 22 17.833 22 17 22s-1.542-.292-2.125-.875S14 19.833 14 19q0-.975.563-1.75c.562-.775.854-.875 1.437-1.075V16q0-1.25-.875-2.125C14.25 13 13.833 13 13 13h-2a4.92 4.92 0 0 1-3-1v4.175q.875.3 1.437 1.075C10 18.025 10 18.35 10 19q0 1.25-.875 2.125C8.25 22 7.833 22 7 22m0-2q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S7.283 18 7 18s-.52.096-.712.288S6 18.717 6 19s.096.52.288.713S6.717 20 7 20m10 0q.424 0 .713-.287C18 19.425 18 19.283 18 19s-.096-.52-.287-.712S17.283 18 17 18s-.52.096-.712.288S16 18.717 16 19s.096.52.288.713.429.287.712.287M7 6q.424 0 .713-.287C8.002 5.426 8 5.283 8 5s-.096-.52-.287-.712S7.283 4 7 4s-.52.096-.712.287S6 4.717 6 5s.096.52.288.713S6.717 6 7 6"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hierarchy.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Home.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 18.886h3v-6h6v6h3v-9l-6-4.5-6 4.5zm-2 2v-12l8-6 8 6v12h-7v-6h-2v6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Home.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/HomeFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 20.886v-12l8-6 8 6v12h-6v-7h-4v7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/HomeFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Image.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5zm1-2h12l-3.75-5-3 4L9 13z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Image.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Info.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 17h2v-6h-2zm1-8q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 7 12 7s-.52.096-.712.288S11 7.717 11 8s.096.52.288.713S11.717 9 12 9m0 13q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Info.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Inventory.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 22q-.824 0-1.412-.587C2.999 20.826 3 20.55 3 20V8.725q-.45-.274-.725-.712C2 7.573 2 7.382 2 7V4q0-.824.588-1.413C3.175 1.998 3.45 2 4 2h16q.824 0 1.413.587C22.002 3.174 22 3.45 22 4v3q0 .574-.275 1.012c-.275.438-.425.53-.725.713V20q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zM5 9v11h14V9zM4 7h16V4H4zm5 7h6v-2H9z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Inventory.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Joystick.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m6.8 13 5.2 3 5.2-3-4.2-2.425V14h-2v-3.425zM11 8.275V7.85q-1.1-.326-1.8-1.237C8.5 5.702 8.5 5.3 8.5 4.5q0-1.45 1.025-2.475T12 1c1.45 0 1.792.342 2.475 1.025S15.5 3.533 15.5 4.5q0 1.2-.7 2.113c-.7.913-1.067 1.02-1.8 1.237v.425l7 4.025q.475.275.738.738c.263.463.262.645.262 1.012v1.9q0 .55-.262 1.013c-.262.463-.421.554-.738.737l-7 4.025Q12.525 22 12 22c-.525 0-.683-.092-1-.275L4 17.7q-.475-.276-.737-.737C3 16.502 3 16.317 3 15.95v-1.9q0-.55.263-1.012c.263-.462.42-.555.737-.738zm0 9.45-6-3.45v1.675L12 20l7-4.05v-1.675l-6 3.45Q12.525 18 12 18c-.525 0-.683-.092-1-.275M12 6q.624 0 1.063-.437c.438-.437.437-.646.437-1.063s-.146-.77-.437-1.062S12.417 3 12 3s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063S11.583 6 12 6"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Joystick.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Keep.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m16 12 2 2v2h-5v6l-1 1-1-1v-6H6v-2l2-2V5H7V3h10v2h-1zm-7.15 2h6.3L14 12.85V5h-4v7.85z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Keep.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/KeepFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m16 12 2 2v2h-5v6l-1 1-1-1v-6H6v-2l2-2V5H7V3h10v2h-1z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/KeepFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Key.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 14q-.824 0-1.412-.587C5 12.825 5 12.55 5 12s.196-1.02.588-1.412S6.45 10 7 10s1.02.196 1.413.588S9 11.45 9 12s-.196 1.02-.587 1.413S7.55 14 7 14m0 4q-2.5 0-4.25-1.75C1 14.5 1 13.667 1 12s.583-3.083 1.75-4.25S5.333 6 7 6q1.676 0 3.038.825A6.2 6.2 0 0 1 12.2 9H21l3 3-4.5 4.5-2-1.5-2 1.5-2.125-1.5H12.2a6.2 6.2 0 0 1-2.162 2.175Q8.675 18 7 18m0-2q1.4 0 2.463-.85A4.03 4.03 0 0 0 10.875 13H14l1.45 1.025L17.5 12.5l1.775 1.375L21.15 12l-1-1h-9.275a4.03 4.03 0 0 0-1.413-2.15Q8.4 8 7 8 5.35 8 4.175 9.175C3 10.35 3 10.9 3 12s.392 2.042 1.175 2.825S5.9 16 7 16"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Key.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LastPage.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m7.2 18-1.4-1.4 4.6-4.6-4.6-4.6L7.2 6l6 6zm9 0V6h2v12z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LastPage.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Light.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 15q1.25 0 2.125-.875C15 13.25 15 12.833 15 12s-.292-1.542-.875-2.125Q13.25 9 12 9c-1.25 0-1.542.292-2.125.875Q9 10.75 9 12c0 1.25.292 1.542.875 2.125A2.9 2.9 0 0 0 12 15m0 2q-2.075 0-3.537-1.462C7 14.075 7 13.383 7 12s.488-2.562 1.463-3.537S10.617 7 12 7s2.563.488 3.538 1.463S17 10.617 17 12s-.487 2.563-1.462 3.538S13.383 17 12 17m-7-4H1v-2h4zm18 0h-4v-2h4zM11 5V1h2v4zm0 18v-4h2v4zM6.4 7.75 3.875 5.325 5.3 3.85l2.4 2.5zm12.3 12.4-2.425-2.525L17.6 16.25l2.525 2.425zM16.25 6.4l2.425-2.525L20.15 5.3l-2.5 2.4zM3.85 18.7l2.525-2.425L7.75 17.6l-2.425 2.525z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Light.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LightFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 17q-2.075 0-3.537-1.462C7 14.075 7 13.383 7 12s.488-2.562 1.463-3.537S10.617 7 12 7s2.563.488 3.538 1.463S17 10.617 17 12s-.487 2.563-1.462 3.538S13.383 17 12 17m-7-4H1v-2h4zm18 0h-4v-2h4zM11 5V1h2v4zm0 18v-4h2v4zM6.4 7.75 3.875 5.325 5.3 3.85l2.4 2.5zm12.3 12.4-2.425-2.525L17.6 16.25l2.525 2.425zM16.25 6.4l2.425-2.525L20.15 5.3l-2.5 2.4zM3.85 18.7l2.525-2.425L7.75 17.6l-2.425 2.525z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LightFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Link.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 17H7q-2.074 0-3.537-1.462C1.999 14.075 2 13.383 2 12s.488-2.562 1.463-3.537S5.617 7 7 7h4v2H7q-1.25 0-2.125.875T4 12c0 1.25.292 1.542.875 2.125S6.167 15 7 15h4zm-3-4v-2h8v2zm5 4v-2h4q1.25 0 2.125-.875C20 13.25 20 12.833 20 12s-.292-1.542-.875-2.125A2.9 2.9 0 0 0 17 9h-4V7h4q2.075 0 3.538 1.463C22 9.926 22 10.617 22 12s-.487 2.563-1.462 3.538S18.383 17 17 17z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Link.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Loading.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-2.05 0-3.875-.787c-1.825-.788-2.28-1.242-3.187-2.15s-1.625-1.971-2.15-3.188S2 13.367 2 12q0-2.075.788-3.887c.788-1.812 1.241-2.267 2.15-3.175s1.97-1.625 3.187-2.15S10.633 2 12 2q.424 0 .713.288c.289.288.287.429.287.712s-.096.52-.287.713S12.283 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 3.325 2.338 5.663C8.676 20 9.783 20 12 20q3.325 0 5.663-2.337C20 15.326 20 14.217 20 12q0-.424.288-.712C20.576 11 20.717 11 21 11s.52.096.713.288.287.429.287.712q0 2.05-.787 3.875c-.788 1.825-1.242 2.28-2.15 3.188s-1.967 1.625-3.175 2.15S13.383 22 12 22"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Loading.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Location.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 12q.824 0 1.413-.587C14 10.825 14 10.55 14 10s-.196-1.02-.587-1.412S12.55 8 12 8s-1.02.196-1.412.588S10 9.45 10 10s.196 1.02.588 1.413S11.45 12 12 12m0 7.35q3.05-2.8 4.525-5.087C18 11.976 18 11.383 18 10.2q0-2.725-1.737-4.462C14.525 4 13.683 4 12 4s-3.104.58-4.262 1.738S6 8.383 6 10.2q0 1.775 1.475 4.063C8.95 16.55 9.967 17.483 12 19.35M12 22q-4.024-3.425-6.012-6.362C3.999 12.7 4 11.866 4 10.2q0-3.75 2.413-5.975C8.825 2 9.883 2 12 2q3.176 0 5.588 2.225C19.999 6.45 20 7.7 20 10.2q0 2.5-1.987 5.438C16.025 18.575 14.683 19.717 12 22"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Location.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Lock.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 22.5q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5h1v-2q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12v-10H6zm6-3q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587m-3-9h6v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Lock.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockSlash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 8.5h9v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5H7q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5m0 12h12v-10H6zm6-3q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockSlash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockedFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 22.5q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5h1v-2q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm6-5q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587m-3-9h6v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockedFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Login.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 21v-2h7V5h-7V3h7q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm-2-4-1.375-1.45 2.55-2.55H3v-2h8.175l-2.55-2.55L10 7l5 5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Login.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Logout.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h7v2H5v14h7v2zm11-4-1.375-1.45 2.55-2.55H9v-2h8.175l-2.55-2.55L16 7l5 5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Logout.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mail.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h16q.824 0 1.413.588C22.002 5.176 22 5.45 22 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm8-7L4 8v10h16V8zm0-2 8-5H4zM4 8V6v12z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mail.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Map.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m15 21-6-2.1-4.65 1.8q-.5.2-.925-.112C3 20.275 3 20.1 3 19.75v-14q0-.325.188-.575c.187-.25.295-.292.512-.375L9 3l6 2.1 4.65-1.8q.5-.2.925.113C21 3.724 21 3.9 21 4.25v14q0 .325-.187.575c-.187.25-.296.292-.513.375zm-1-2.45V6.85l-4-1.4v11.7zm2 0 3-1V5.7l-3 1.15zM5 18.3l3-1.15V5.45l-3 1z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Map.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Menu.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 18v-2h18v2zm0-5v-2h18v2zm0-5V6h18v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Menu.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MessageQuestion.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11.9 16.886q.525 0 .888-.363c.362-.363.362-.537.362-.887s-.12-.646-.362-.888-.538-.362-.888-.362-.646.12-.887.362-.363.538-.363.888.12.645.363.887.537.363.887.363m-.9-3.85h1.85q0-.426.038-.725c.037-.3.079-.392.162-.575s.187-.355.312-.513.305-.354.538-.587q.875-.876 1.237-1.463t.363-1.337q0-1.325-.9-2.138t-2.425-.812q-1.375 0-2.337.675T8.5 7.436l1.65.65q.175-.675.7-1.088c.525-.413.758-.412 1.225-.412q.675 0 1.125.362.45.363.45.963 0 .424-.275.9-.275.474-.925 1.05-.425.35-.688.687c-.263.337-.32.463-.437.713s-.2.512-.25.787-.075.604-.075.988m1 9.85-3-3H5q-.824 0-1.412-.588C2.999 18.71 3 18.436 3 17.886v-14q0-.825.588-1.413A1.93 1.93 0 0 1 5 1.886h14q.824 0 1.413.587.587.588.587 1.413v14q0 .825-.587 1.412c-.587.587-.863.588-1.413.588h-4zm-7-5h4.8l2.2 2.2 2.2-2.2H19v-14H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MessageQuestion.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Messages.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M2 22V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6zm3.15-6H20V4H4v13.125z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Messages.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MetamaskFoxOutline.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m21.996 8.44-1.353 3.615L22 16.59l-.107.287-1.64 4.385-4.048-1.016L13.145 22h-2.289l-3.06-1.754-4.047 1.016-1.743-4.66 1.35-4.967-1.231-2.883L2 8.462 3.758 2l6.69 4.128h3.106L20.244 2zm-7.93-.498h-4.13L4.867 4.813 3.911 8.33l1.357 3.174-1.363 5.01.971 2.596 3.188-.798 3.273 1.875h1.328l3.273-1.875 3.187.799.966-2.585-1.356-4.534.107-.287 1.254-3.354-.962-3.537z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MetamaskFoxOutline.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mic.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 14a2.9 2.9 0 0 1-2.125-.875A2.9 2.9 0 0 1 9 11V5q0-1.25.875-2.125T12 2c1.25 0 1.542.292 2.125.875S15 4.167 15 5v6q0 1.25-.875 2.125C13.25 14 12.833 14 12 14m-1 7v-3.075q-2.6-.35-4.3-2.325C5 13.625 5 12.75 5 11h2q0 2.075 1.463 3.538C9.926 16 10.617 16 12 16s2.563-.487 3.538-1.462S17 12.383 17 11h2q0 2.625-1.7 4.6c-1.7 1.975-2.567 2.092-4.3 2.325V21zm1-9q.424 0 .713-.287c.289-.287.287-.43.287-.713V5q0-.424-.287-.712C12.426 3.998 12.283 4 12 4s-.52.096-.712.287S11 4.717 11 5v6q0 .424.288.713c.287.289.429.287.712.287"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mic.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Minus.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 13v-2h14v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Minus.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusBold.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4.15 13.575v-3.15h15.7v3.15z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusBold.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusSquare.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8 13h8q.424 0 .713-.287C17 12.426 17 12.283 17 12s-.096-.52-.287-.712S16.282 11 16 11H8q-.424 0-.713.288C6.998 11.575 7 11.717 7 12s.096.52.287.713S7.717 13 8 13m-3 8q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusSquare.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mobile.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 23q-.824 0-1.412-.587C5 21.826 5 21.55 5 21V3q0-.824.588-1.412C6.176.999 6.45 1 7 1h10q.824 0 1.413.587C19.002 2.175 19 2.45 19 3v18q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-3v1h10v-1zm0-2h10V6H7zM7 4h10V3H7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mobile.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Money.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M14 13q-1.25 0-2.125-.875C11 11.25 11 10.833 11 10q0-1.25.875-2.125C12.75 7 13.167 7 14 7s1.542.292 2.125.875S17 9.167 17 10q0 1.25-.875 2.125C15.25 13 14.833 13 14 13m-7 3q-.824 0-1.412-.587C5 14.825 5 14.55 5 14V6q0-.824.588-1.412C6.176 4 6.45 4 7 4h14q.824 0 1.413.588C23.002 5.176 23 5.45 23 6v8q0 .824-.587 1.413C21.826 16 21.55 16 21 16zm2-2h10q0-.825.588-1.412C20.175 12 20.45 12 21 12V8q-.825 0-1.412-.587C19 6.825 19 6.55 19 6H9q0 .824-.587 1.413C7.825 8 7.55 8 7 8v4q.824 0 1.413.588C9 13.176 9 13.45 9 14m11 6H3q-.824 0-1.412-.587C.999 18.826 1 18.55 1 18V7h2v11h17z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Money.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoneyBag.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8.4 21q-2.275 0-3.837-1.562C3 17.876 3 17.117 3 15.6q0-.95.325-1.85c.325-.9.525-1.142.925-1.625L7.8 7.85 5.375 3h13.25L16.2 7.85l3.55 4.275q.6.725.925 1.625c.325.9.325 1.217.325 1.85q0 2.275-1.575 3.838C17.85 21 17.1 21 15.6 21zm3.6-5q-.825 0-1.412-.587C10 14.825 10 14.55 10 14s.196-1.02.588-1.412S11.45 12 12 12s1.02.196 1.413.588S14 13.45 14 14s-.196 1.02-.587 1.413S12.55 16 12 16M9.625 7h4.75l1-2h-6.75zM8.4 19h7.2q1.425 0 2.413-.987C19 17.025 19 16.55 19 15.6q0-.6-.212-1.162c-.212-.563-.338-.713-.588-1.013L14.525 9H9.5l-3.7 4.4q-.375.45-.587 1.025C5 15 5 15.2 5 15.6q0 1.425.988 2.413C6.976 19 7.45 19 8.4 19"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoneyBag.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Monitor.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8 21v-2h2v-2H4q-.824 0-1.412-.587C1.999 15.826 2 15.55 2 15V5q0-.825.588-1.412C3.175 3 3.45 3 4 3h16q.824 0 1.413.588C22.002 4.176 22 4.45 22 5v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587h-6v2h2v2zm-4-6h16V5H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Monitor.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreHorizontal.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M20 12q0 .824-.587 1.413C18.826 14 18.55 14 18 14s-1.02-.196-1.412-.587S16 12.55 16 12s.196-1.02.587-1.412S17.45 10 18 10s1.02.196 1.413.588S20 11.45 20 12m-6 0q0 .824-.587 1.413C12.825 14 12.55 14 12 14s-1.02-.196-1.412-.587S10 12.55 10 12s.196-1.02.588-1.412S11.45 10 12 10s1.02.196 1.413.588S14 11.45 14 12m-6 0q0 .824-.587 1.413C6.825 14 6.55 14 6 14s-1.02-.196-1.412-.587S4 12.55 4 12s.196-1.02.588-1.412S5.45 10 6 10s1.02.196 1.413.588S8 11.45 8 12"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreHorizontal.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreVertical.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 20q-.825 0-1.412-.587C10 18.826 10 18.55 10 18s.196-1.02.588-1.412S11.45 16 12 16s1.02.196 1.413.587S14 17.45 14 18s-.196 1.02-.587 1.413S12.55 20 12 20m0-6q-.825 0-1.412-.587C10 12.825 10 12.55 10 12s.196-1.02.588-1.412S11.45 10 12 10s1.02.196 1.413.588S14 11.45 14 12s-.196 1.02-.587 1.413S12.55 14 12 14m0-6q-.825 0-1.412-.587C10 6.825 10 6.55 10 6s.196-1.02.588-1.412S11.45 4 12 4s1.02.196 1.413.588S14 5.45 14 6s-.196 1.02-.587 1.413S12.55 8 12 8"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreVertical.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MountainFlag.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8.7 12.925 1.375.925L12 12.875l1.925.975 1.325-.875-1-1.975h-4.6zM5.225 20H18.75l-2.6-5.225-2.075 1.375L12 15.125 9.925 16.15 7.8 14.75zM2 22l5.85-11.875q.25-.5.738-.812C9.076 9 9.267 9 9.65 9H11V2h7l-1 2 1 2h-5v3h1.25q.575 0 1.05.3c.475.3.567.467.75.8L22 22z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MountainFlag.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MusicNote.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M10 21q-1.65 0-2.825-1.175C6 18.65 6 18.1 6 17s.392-2.042 1.175-2.825S8.9 13 10 13q.575 0 1.063.138c.487.137.637.229.937.412V3h6v4h-4v10q0 1.65-1.175 2.825C11.65 21 11.1 21 10 21"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/MusicNote.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Notification.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 19v-2h2v-7q0-2.074 1.25-3.687C8.5 4.7 9.167 4.533 10.5 4.2v-.7q0-.625.438-1.062C11.375 2 11.583 2 12 2s.77.146 1.063.438.437.645.437 1.062v.7q2 .5 3.25 2.113C18 7.926 18 8.617 18 10v7h2v2zm8 3q-.825 0-1.412-.587C10 20.826 10 20.55 10 20h4q0 .824-.587 1.413c-.588.589-.863.587-1.413.587m-4-5h8v-7q0-1.65-1.175-2.825C13.65 6 13.1 6 12 6s-2.042.392-2.825 1.175S8 8.9 8 10z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Notification.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PageInfo.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M17.75 20.25q-1.575 0-2.662-1.087C14 18.076 14 17.55 14 16.5s.363-1.937 1.088-2.662S16.7 12.75 17.75 12.75s1.938.363 2.663 1.088S21.5 15.45 21.5 16.5s-.362 1.938-1.087 2.663S18.8 20.25 17.75 20.25m0-2q.725 0 1.238-.512c.513-.512.512-.755.512-1.238s-.17-.896-.512-1.237-.755-.513-1.238-.513-.896.17-1.237.513S16 16.017 16 16.5s.17.896.513 1.238.754.512 1.237.512M4 17.5v-2h8v2zm2.25-6.25q-1.575 0-2.662-1.087C2.5 9.075 2.5 8.55 2.5 7.5s.363-1.937 1.088-2.662S5.2 3.75 6.25 3.75s1.938.363 2.663 1.088S10 6.45 10 7.5s-.362 1.938-1.087 2.663S7.3 11.25 6.25 11.25m0-2q.725 0 1.238-.512C8 8.226 8 7.983 8 7.5s-.17-.896-.512-1.237-.755-.513-1.238-.513-.896.17-1.237.513S4.5 7.017 4.5 7.5s.17.896.513 1.238.754.512 1.237.512M12 8.5v-2h8v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PageInfo.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Palette.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-2.05 0-3.875-.787c-1.825-.788-2.28-1.242-3.187-2.15s-1.625-1.971-2.15-3.188S2 13.367 2 12q0-2.075.813-3.9c.812-1.825 1.274-2.275 2.2-3.175S7.017 3.313 8.25 2.788 10.8 2 12.2 2q2 0 3.775.687c1.775.687 2.22 1.092 3.113 1.9s1.6 1.767 2.124 2.875S22 9.768 22 11.05q0 2.875-1.75 4.412C18.5 17 17.667 17 16 17h-1.85q-.225 0-.312.125c-.087.125-.088.175-.088.275q0 .3.375.863c.375.562.375.804.375 1.287q0 1.25-.687 1.85c-.688.6-1.063.6-1.813.6m-5.5-9q.65 0 1.075-.425C8 12.15 8 11.933 8 11.5s-.142-.792-.425-1.075S6.933 10 6.5 10s-.792.142-1.075.425S5 11.067 5 11.5s.142.792.425 1.075S6.067 13 6.5 13m3-4q.65 0 1.075-.425C11 8.15 11 7.933 11 7.5s-.142-.792-.425-1.075S9.933 6 9.5 6s-.792.142-1.075.425S8 7.067 8 7.5s.142.792.425 1.075S9.067 9 9.5 9m5 0q.65 0 1.075-.425C16 8.15 16 7.933 16 7.5s-.142-.792-.425-1.075S14.933 6 14.5 6s-.792.142-1.075.425S13 7.067 13 7.5s.142.792.425 1.075S14.067 9 14.5 9m3 4q.65 0 1.075-.425C19 12.15 19 11.933 19 11.5s-.142-.792-.425-1.075S17.933 10 17.5 10s-.792.142-1.075.425S16 11.067 16 11.5s.142.792.425 1.075.642.425 1.075.425M12 20q.224 0 .363-.125c.139-.125.137-.192.137-.325q0-.35-.375-.825c-.375-.475-.375-.792-.375-1.425q0-1.05.725-1.675C13.2 15 13.55 15 14.25 15H16q1.65 0 2.825-.962C20 13.075 20 12.4 20 11.05q0-3.025-2.312-5.037C15.376 4 14.317 4 12.2 4Q8.8 4 6.4 6.325C4 8.65 4 9.767 4 12q0 3.325 2.337 5.663C8.676 20 9.784 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Palette.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PasswordCheck.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M2 18.886v-2h20v2zm1.15-6.05-1.3-.75.85-1.5H1v-1.5h1.7l-.85-1.45 1.3-.75.85 1.45.85-1.45 1.3.75-.85 1.45H7v1.5H5.3l.85 1.5-1.3.75-.85-1.5zm8 0-1.3-.75.85-1.5H9v-1.5h1.7l-.85-1.45 1.3-.75.85 1.45.85-1.45 1.3.75-.85 1.45H15v1.5h-1.7l.85 1.5-1.3.75-.85-1.5zm8 0-1.3-.75.85-1.5H17v-1.5h1.7l-.85-1.45 1.3-.75.85 1.45.85-1.45 1.3.75-.85 1.45H23v1.5h-1.7l.85 1.5-1.3.75-.85-1.5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PasswordCheck.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pending.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 13.5q.624 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S7.417 10.5 7 10.5s-.77.146-1.062.438S5.5 11.583 5.5 12s.146.77.438 1.063.645.437 1.062.437m5 0q.624 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S12.417 10.5 12 10.5s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063.645.437 1.062.437m5 0q.625 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S17.417 10.5 17 10.5s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063.645.437 1.062.437M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pending.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/People.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M0 18v-1.575q0-1.075 1.1-1.75T4 14q.325 0 .625.013c.3.012.392.029.575.062q-.35.525-.525 1.1c-.175.575-.175.783-.175 1.2V18zm6 0v-1.625q0-.8.438-1.462c.438-.663.704-.83 1.237-1.163s1.17-.583 1.913-.75q1.112-.25 2.412-.25 1.325 0 2.438.25c1.112.25 1.379.417 1.912.75s.942.72 1.225 1.163.425.929.425 1.462V18zm13.5 0v-1.625q0-.65-.162-1.225c-.163-.575-.271-.742-.488-1.075q.274-.05.562-.062C19.7 14 19.8 14 20 14q1.8 0 2.9.663c1.1.663 1.1 1.029 1.1 1.762V18zM8.125 16H15.9q-.251-.5-1.387-.875c-1.136-.375-1.596-.375-2.513-.375s-1.754.125-2.512.375Q8.35 15.5 8.125 16M4 13q-.824 0-1.412-.587C1.999 11.825 2 11.55 2 11q0-.85.588-1.425C3.175 9 3.45 9 4 9q.85 0 1.425.575C6 10.15 6 10.433 6 11q0 .824-.575 1.413C4.85 13 4.567 13 4 13m16 0q-.825 0-1.412-.587C18 11.825 18 11.55 18 11q0-.85.588-1.425C19.175 9 19.45 9 20 9q.85 0 1.425.575C22 10.15 22 10.433 22 11q0 .824-.575 1.413C20.85 13 20.567 13 20 13m-8-1a2.9 2.9 0 0 1-2.125-.875A2.9 2.9 0 0 1 9 9q0-1.275.875-2.137T12 6q1.275 0 2.138.863C15 7.725 15 8.15 15 9q0 1.25-.862 2.125C13.275 12 12.85 12 12 12m0-2q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 8 12 8s-.52.096-.712.288S11 8.717 11 9s.096.52.288.713.429.287.712.287"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/People.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PersonCancel.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M17.4 13 16 11.6l2.075-2.1L16 7.425 17.4 6l2.1 2.1L21.575 6 23 7.425 20.9 9.5l2.1 2.1-1.425 1.4-2.075-2.075zM9 12q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.437-1.562c.437-.713.68-.838 1.163-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.162 1.087c.438.712.438.996.438 1.563V20zm2-2h12v-.8q0-.275-.138-.5c-.138-.225-.212-.267-.362-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.825 0 1.412-.587C11 8.825 11 8.55 11 8s-.196-1.02-.588-1.412S9.55 6 9 6s-1.02.196-1.413.588S7 7.45 7 8s.196 1.02.587 1.413S8.45 10 9 10"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PersonCancel.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pin.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M14.136 15.504v2.829l-1.414 1.414-3.535-3.536-4.243 4.243H3.53V19.04l4.242-4.243-3.535-3.535L5.65 9.848H8.48l4.95-4.95-.708-.707 1.414-1.415 7.072 7.072-1.415 1.414-.707-.707zm-6.47-3.641 4.455 4.455V14.69l5.55-5.55-2.827-2.829-5.551 5.55z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pin.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plant.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 20.886V12.91q-1.6 0-3.075-.613c-1.475-.613-1.85-.987-2.6-1.737S4 8.944 3.6 7.96 3 5.951 3 4.884v-2h2a7.9 7.9 0 0 1 3.05.613q1.475.612 2.6 1.737.775.776 1.287 1.7c.512.924.605 1.275.788 1.975q.125-.174.275-.337.15-.162.325-.338a8 8 0 0 1 2.6-1.737A7.9 7.9 0 0 1 19 5.885h2v2a7.9 7.9 0 0 1-.613 3.075q-.612 1.476-1.737 2.6c-1.125 1.124-1.613 1.325-2.588 1.725s-1.995.6-3.062.6v5zm0-10q0-1.2-.462-2.288c-.463-1.088-.746-1.37-1.313-1.937a6.1 6.1 0 0 0-1.937-1.313A5.8 5.8 0 0 0 5 4.886q0 1.2.45 2.3t1.3 1.95 1.95 1.3c1.1.45 1.5.45 2.3.45m2 3a5.92 5.92 0 0 0 4.225-1.75 6 6 0 0 0 1.313-1.95q.462-1.1.462-2.3-1.2 0-2.3.462a6 6 0 0 0-1.95 1.313A5.92 5.92 0 0 0 13 13.886"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plant.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plug.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11.5 19h1v-1.85l3.5-3.5V9H8v4.65l3.5 3.5zm-2 2v-3L6 14.5V9q0-.825.588-1.412C7.176 7 7.45 7 8 7h1L8 8V3h2v4h4V3h2v5l-1-1h1q.824 0 1.413.588C18.002 8.176 18 8.45 18 9v5.5L14.5 18v3z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plug.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PlusAndMinus.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M7 4.252H5v3H2v2h3v3h2v-3h3v-2H7zm11 1 1.06 1.06L5.627 19.749l-1.061-1.06zm4 11v-2h-8v2z",clipRule:"evenodd"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PlusAndMinus.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PolicyAlert.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v5h-2V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3q.65-.2 1.238-.512c.588-.312.779-.455 1.162-.738l1.4 1.4q-.825.675-1.787 1.175c-.962.5-1.313.592-2.013.775m9 0q-.424 0-.712-.287C20 21.425 20 21.283 20 21s.096-.52.288-.712S20.717 20 21 20s.52.096.713.288.287.429.287.712-.096.52-.287.713S21.283 22 21 22m-1-4v-6h2v6zm-8-4q.824 0 1.413-.587C14 12.825 14 12.55 14 12s-.196-1.02-.587-1.412S12.55 10 12 10s-1.02.196-1.412.588S10 11.45 10 12s.196 1.02.588 1.413S11.45 14 12 14m0 2q-1.65 0-2.825-1.175C8 13.65 8 13.1 8 12s.392-2.042 1.175-2.825S10.9 8 12 8s2.042.392 2.825 1.175S16 10.9 16 12q0 .55-.137 1.063c-.137.512-.23.67-.413.987L18.425 17 17 18.425l-3-2.975q-.45.274-.962.413c-.513.139-.688.137-1.038.137"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PolicyAlert.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Print.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M16 8V5H8v3H6V3h12v5zm2 4.5q.424 0 .713-.287c.288-.287.287-.43.287-.713s-.096-.52-.287-.712-.43-.288-.713-.288-.52.096-.712.288-.288.429-.288.712.096.52.288.713.429.287.712.287M16 19v-4H8v4zm2 2H6v-4H2v-6q0-1.275.875-2.137C3.75 8 4.167 8 5 8h14q1.275 0 2.138.863C22 9.726 22 10.15 22 11v6h-4zm2-6v-4q0-.424-.287-.712C19.425 9.999 19.283 10 19 10H5q-.424 0-.712.288C3.998 10.575 4 10.717 4 11v4h2v-2h12v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Print.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PriorityHigh.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 21q-.825 0-1.412-.587C10 19.826 10 19.55 10 19s.196-1.02.588-1.412S11.45 17 12 17s1.02.196 1.413.588S14 18.45 14 19s-.196 1.02-.587 1.413S12.55 21 12 21m-2-6V3h4v12z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PriorityHigh.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PrivacyTip.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 17h2v-6h-2zm1-8q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 7 12 7s-.52.096-.712.288S11 7.717 11 8s.096.52.288.713S11.717 9 12 9m0 13q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/PrivacyTip.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ProgrammingArrows.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m10.75 23.25-1.4-1.425L11.175 20h-3.35q-.326.875-1.088 1.438C5.975 22 5.65 22 5 22q-1.25 0-2.125-.875C2 20.25 2 19.833 2 19q0-.976.562-1.737c.562-.762.855-.871 1.438-1.088v-8.35q-.875-.326-1.438-1.087C2 5.977 2 5.65 2 5q0-1.25.875-2.125C3.75 2 4.167 2 5 2q.976 0 1.737.563c.761.563.871.854 1.088 1.437h3.35L9.35 2.175 10.75.75 15 5l-4.25 4.25-1.4-1.425L11.175 6h-3.35A2.92 2.92 0 0 1 6 7.825v8.35A2.92 2.92 0 0 1 7.825 18h3.35L9.35 16.175l1.4-1.425L15 19zM19 22q-1.25 0-2.125-.875C16 20.25 16 19.833 16 19q0-1 .563-1.762c.563-.762.854-.863 1.437-1.063v-8.35q-.875-.3-1.437-1.062C16 6 16 5.667 16 5q0-1.25.875-2.125C17.75 2 18.167 2 19 2s1.542.292 2.125.875S22 4.167 22 5q0 1-.562 1.763c-.562.763-.855.862-1.438 1.062v8.35q.875.326 1.438 1.088C22 18.024 22 18.35 22 19q0 1.25-.875 2.125C20.25 22 19.833 22 19 22M5 20q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712S5.283 18 5 18s-.52.096-.712.288S4 18.717 4 19s.096.52.287.713S4.717 20 5 20m14 0q.424 0 .713-.287C20 19.425 20 19.283 20 19s-.096-.52-.287-.712S19.283 18 19 18s-.52.096-.712.288S18 18.717 18 19s.096.52.288.713.429.287.712.287M5 6q.424 0 .713-.287C6.002 5.426 6 5.283 6 5s-.096-.52-.287-.712S5.283 4 5 4s-.52.096-.712.287S4 4.717 4 5s.096.52.287.713S4.717 6 5 6m14 0q.424 0 .713-.287C20 5.426 20 5.283 20 5s-.096-.52-.287-.712S19.283 4 19 4s-.52.096-.712.287S18 4.717 18 5s.096.52.288.713S18.717 6 19 6"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ProgrammingArrows.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Publish.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 20v-8.15l-2.6 2.6L7 13l5-5 5 5-1.4 1.45-2.6-2.6V20zM4 9V6q0-.824.588-1.412C5.176 4 5.45 4 6 4h12q.824 0 1.413.588C20.002 5.176 20 5.45 20 6v3h-2V6H6v3z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Publish.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/QrCode.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 11V3h8v8zm2-2h4V5H5zM3 21v-8h8v8zm2-2h4v-4H5zm8-8V3h8v8zm2-2h4V5h-4zm4 12v-2h2v2zm-6-6v-2h2v2zm2 2v-2h2v2zm-2 2v-2h2v2zm2 2v-2h2v2zm2-2v-2h2v2zm0-4v-2h2v2zm2 2v-2h2v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/QrCode.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Question.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11.95 18q.525 0 .888-.362c.362-.363.362-.538.362-.888s-.12-.646-.362-.887-.538-.363-.888-.363-.646.12-.887.363-.363.537-.363.887.12.646.363.888.537.362.887.362m-.9-3.85h1.85q0-.825.187-1.3c.187-.475.48-.75 1.063-1.3a7.5 7.5 0 0 0 1.025-1.238q.375-.587.375-1.412 0-1.4-1.025-2.15C13.5 6 13.033 6 12.1 6q-1.424 0-2.313.75-.887.75-1.237 1.8l1.65.65q.124-.45.562-.975C11.2 7.7 11.5 7.7 12.1 7.7q.8 0 1.2.437c.4.437.4.613.4.963q0 .5-.3.938t-.75.812q-1.1.975-1.35 1.475c-.25.5-.25.942-.25 1.825M12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.312 17.117 2.787 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Question.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Receive.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 11V3h8v8zm2-2h4V5H5zM3 21v-8h8v8zm2-2h4v-4H5zm8-8V3h8v8zm2-2h4V5h-4zm4 12v-2h2v2zm-6-6v-2h2v2zm2 2v-2h2v2zm-2 2v-2h2v2zm2 2v-2h2v2zm2-2v-2h2v2zm0-4v-2h2v2zm2 2v-2h2v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Receive.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Received.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m19 6.9-9.6 9.6H18v2H6v-12h2v8.6l9.6-9.6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Received.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Refresh.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12.05 20q-3.35 0-5.7-2.325C4 15.35 4 14.233 4 12v-.175l-1.6 1.6-1.4-1.4 4-4 4 4-1.4 1.4-1.6-1.6V12q0 2.5 1.763 4.25C9.526 18 10.367 18 12.05 18q.65 0 1.275-.15c.625-.15.825-.25 1.225-.45l1.5 1.5q-.95.55-1.95.825c-1 .275-1.35.275-2.05.275M19 15.975l-4-4 1.4-1.4 1.6 1.6V12q0-2.5-1.762-4.25C14.476 6 13.633 6 11.95 6q-.65 0-1.275.15c-.625.15-.825.25-1.225.45l-1.5-1.5a8.3 8.3 0 0 1 1.95-.825A7.7 7.7 0 0 1 11.95 4q3.35 0 5.7 2.325C20 8.65 20 9.767 20 12v.175l1.6-1.6 1.4 1.4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Refresh.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/RemoveMinus.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 13h10v-2H7zm5 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/RemoveMinus.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Report.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S12.283 15 12 15s-.52.096-.712.287S11 15.717 11 16s.096.52.288.712.429.288.712.288m-1-4h2V7h-2zm-2.75 8L3 15.75v-7.5L8.25 3h7.5L21 8.25v7.5L15.75 21zm.85-2h5.8l4.1-4.1V9.1L14.9 5H9.1L5 9.1v5.8z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Report.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Rocket.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m6 19.054 1.975-.8q-.25-.723-.462-1.473c-.213-.75-.255-.998-.338-1.498l-1.175.8zm4-1.049h4q.45-.999.725-2.434.275-1.437.275-2.934 0-2.472-.825-4.682T12 4.547q-1.35 1.199-2.175 3.408A13.3 13.3 0 0 0 9 12.637q0 1.497.275 2.933.275 1.437.725 2.435m2-4.994q-.825 0-1.412-.587-.588-.586-.588-1.41c0-.824.196-1.02.588-1.411q.587-.587 1.412-.587c.825 0 1.02.196 1.413.587q.587.587.587 1.41c0 .824-.196 1.02-.587 1.411a1.93 1.93 0 0 1-1.413.587m6 6.043v-2.972l-1.175-.799q-.125.75-.337 1.499c-.212.749-.296.99-.463 1.473zM12 2q2.475 1.798 3.738 4.57C17 9.34 17 10.563 17 13.01l2.1 1.398q.425.275.663.725c.238.45.237.615.237.948V22l-4.975-1.997h-6.05L4 22v-5.918a2 2 0 0 1 .9-1.673L7 13.012q0-3.67 1.263-6.442C9.526 3.797 10.35 3.2 12 2"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Rocket.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Save.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21V5q0-.824.588-1.412C6.176 2.999 6.45 3 7 3h10q.824 0 1.413.588C19.002 4.175 19 4.45 19 5v16l-7-3zm2-3.05 5-2.15 5 2.15V5H7z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Save.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SaveFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21V5q0-.824.588-1.412C6.176 2.999 6.45 3 7 3h10q.824 0 1.413.588C19.002 4.175 19 4.45 19 5v16l-7-3z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SaveFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Saving.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M16 11q.424 0 .713-.287C17 10.426 17 10.283 17 10q0-.424-.287-.712C16.425 8.999 16.282 9 16 9s-.52.096-.713.288S15 9.717 15 10q0 .424.287.713c.287.289.43.287.713.287M8 9h5V7H8zM4.5 21q-.85-2.85-1.675-5.687C2 12.474 2 11.483 2 9.5q0-2.3 1.6-3.9C5.2 4 5.967 4 7.5 4h5q.724-.95 1.763-1.475C15.3 2 15.7 2 16.5 2q.625 0 1.063.437C18 2.874 18 3.083 18 3.5q0 .15-.037.3c-.038.15-.055.192-.088.275q-.101.274-.187.562a4 4 0 0 0-.138.588L19.825 7.5H22v6.975l-2.825.925L17.5 21H12v-2h-2v2zM6 19h2v-2h6v2h2l1.55-5.15 2.45-.825V9.5h-1L15.5 6a7.2 7.2 0 0 1 .25-1.9q-.724.2-1.275.688c-.551.487-.633.729-.8 1.212H7.5Q6.05 6 5.025 7.025C4 8.05 4 8.533 4 9.5q0 2.45.675 4.788C5.35 16.625 5.567 17.417 6 19"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Saving.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Scan.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M2 7V2h5v2H4v3zm0 15v-5h2v3h3v2zm15 0v-2h3v-3h2v5zm3-15V4h-3V2h5v5zm-2.5 10.5H19V19h-1.5zm0-3H19V16h-1.5zM16 16h1.5v1.5H16zm-1.5 1.5H16V19h-1.5zM13 16h1.5v1.5H13zm3-3h1.5v1.5H16zm-1.5 1.5H16V16h-1.5zM13 13h1.5v1.5H13zm6-8v6h-6V5zm-8 8v6H5v-6zm0-8v6H5V5zM9.5 17.5v-3h-3v3zm0-8v-3h-3v3zm8 0v-3h-3v3z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Scan.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanBarcode.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M2 7V2h5v2H4v3zm0 15v-5h2v3h3v2zm15 0v-2h3v-3h2v5zm3-15V4h-3V2h5v5zm-2.5 10.5H19V19h-1.5zm0-3H19V16h-1.5zM16 16h1.5v1.5H16zm-1.5 1.5H16V19h-1.5zM13 16h1.5v1.5H13zm3-3h1.5v1.5H16zm-1.5 1.5H16V16h-1.5zM13 13h1.5v1.5H13zm6-8v6h-6V5zm-8 8v6H5v-6zm0-8v6H5V5zM9.5 17.5v-3h-3v3zm0-8v-3h-3v3zm8 0v-3h-3v3z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanBarcode.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanFocus.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19v-4h2v4h4v2zm10 0v-2h4v-4h2v4q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zM3 9V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h4v2H5v4zm16 0V5h-4V3h4q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanFocus.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Search.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m19.6 21-6.3-6.3q-.75.6-1.725.95C10.6 16 10.233 16 9.5 16q-2.725 0-4.612-1.888C3 12.224 3 11.317 3 9.5q0-2.725 1.888-4.612C6.776 3 7.683 3 9.5 3q2.725 0 4.613 1.888C16 6.776 16 7.683 16 9.5a6.1 6.1 0 0 1-1.3 3.8l6.3 6.3zM9.5 14q1.875 0 3.188-1.312C14 11.375 14 10.75 14 9.5s-.437-2.312-1.312-3.187S10.75 5 9.5 5s-2.312.438-3.187 1.313S5 8.25 5 9.5s.438 2.313 1.313 3.188S8.25 14 9.5 14"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Search.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Security.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Security.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityAlert.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 16q.424 0 .713-.287c.289-.287.287-.43.287-.713s-.096-.52-.287-.712S12.283 14 12 14s-.52.096-.712.288S11 14.717 11 15s.096.52.288.713.429.287.712.287m-1-4h2V7h-2zm1 10q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityAlert.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityCross.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m9.9 15.5 2.1-2.1 2.1 2.1 1.4-1.4-2.1-2.1 2.1-2.1-1.4-1.4-2.1 2.1-2.1-2.1-1.4 1.4 2.1 2.1-2.1 2.1zM12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityCross.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityKey.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M10.5 15h3l-.575-3.225q.5-.25.788-.725C14 10.575 14 10.383 14 10q0-.825-.587-1.412C12.825 8 12.55 8 12 8s-1.02.196-1.412.588S10 9.45 10 10q0 .574.288 1.05c.287.476.454.558.787.725zm1.5 7q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityKey.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySearch.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 2.126-.725 4.088C18.55 17.149 18.1 17.65 17.2 18.65l-3.2-3.2q-.45.274-.962.413C12.525 16 12.35 16 12 16q-1.65 0-2.825-1.175C8 13.65 8 13.1 8 12s.392-2.042 1.175-2.825S10.9 8 12 8s2.042.392 2.825 1.175S16 10.9 16 12q0 .55-.137 1.062c-.137.512-.23.671-.413.988l1.5 1.5q.5-1.025.775-2.15C18 12.275 18 11.883 18 11.1V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3q.65-.2 1.238-.512c.588-.313.779-.455 1.162-.738l1.4 1.4q-.825.675-1.787 1.175c-.962.5-1.313.592-2.013.775m0-8q.824 0 1.413-.587C14 12.825 14 12.55 14 12s-.196-1.02-.587-1.412S12.55 10 12 10s-1.02.196-1.412.588S10 11.45 10 12s.196 1.02.588 1.413S11.45 14 12 14"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySearch.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySlash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m18.85 16.05-1.5-1.55q.3-.8.475-1.662C18 11.976 18 11.683 18 11.1V6.375l-6-2.25L8.35 5.5 6.8 3.95 12 2l8 3v6.1a11.2 11.2 0 0 1-1.15 4.95m.95 6.55-3.25-3.25q-.95.975-2.113 1.638C13.274 21.65 12.85 21.767 12 22q-3.476-.874-5.738-3.987T4 11.1V6.8L1.4 4.2l1.4-1.4 18.4 18.4zM12 19.9q.875-.275 1.675-.775c.8-.5 1.025-.725 1.475-1.175L6 8.8v2.3q0 3.025 1.7 5.5t4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySlash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTick.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M10.95 15.55 16.6 9.9l-1.425-1.425L10.95 12.7l-2.1-2.1-1.425 1.425zM12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTick.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTime.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 16q1.875 0 3.188-1.312C16.5 13.375 16.5 12.75 16.5 11.5s-.437-2.312-1.312-3.187S13.25 7 12 7v1.5q1.25 0 2.125.875C15 10.25 15 10.667 15 11.5s-.292 1.542-.875 2.125-1.292.875-2.125.875q-.825 0-1.537-.425c-.712-.425-.846-.667-1.113-1.15l-1.3.725q.6 1.1 1.65 1.725C10.75 16 11.167 16 12 16m-3.75-3.65A.73.73 0 0 0 9 11.6a.73.73 0 0 0-.75-.75.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75m.55-2.1a.73.73 0 0 0 .75-.75.73.73 0 0 0-.75-.75.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75m1.45-1.375a.73.73 0 0 0 .75-.75.73.73 0 0 0-.75-.75.73.73 0 0 0-.75.75.73.73 0 0 0 .75.75M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTime.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityUser.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 13q-1.474 0-2.487-1.012C8.499 10.976 8.5 10.483 8.5 9.5q0-1.474 1.013-2.487C10.525 6 11.016 6 12 6s1.813.338 2.488 1.013S15.5 8.517 15.5 9.5q0 1.475-1.012 2.488C13.476 13 12.983 13 12 13m0-2q.65 0 1.075-.425c.425-.425.425-.642.425-1.075s-.142-.792-.425-1.075S12.433 8 12 8s-.792.142-1.075.425-.425.642-.425 1.075.142.792.425 1.075S11.567 11 12 11m0 11q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-17.875-6 2.25V11.1q0 1.35.375 2.625c.375 1.275.592 1.65 1.025 2.4q1.05-.525 2.2-.825T12 15c1.25 0 1.633.1 2.4.3s1.5.475 2.2.825q.65-1.125 1.025-2.4C18 12.45 18 12 18 11.1V6.375zM12 17q-.9 0-1.75.2a9 9 0 0 0-1.625.55q.724.75 1.575 1.3.85.55 1.8.85.95-.3 1.8-.85c.85-.55 1.092-.8 1.575-1.3q-.775-.35-1.625-.55C12.9 17 12.6 17 12 17"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityUser.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Send.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 20V4l19 8zm2-3 11.85-5L5 7v3.5l6 1.5-6 1.5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Send.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentDissatisfied.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M15.5 11q.624 0 1.063-.437c.439-.438.437-.646.437-1.063s-.146-.77-.437-1.062S15.917 8 15.5 8s-.77.146-1.062.438S14 9.083 14 9.5s.146.77.438 1.063.645.437 1.062.437m-7 0q.624 0 1.063-.437C10 10.125 10 9.917 10 9.5s-.146-.77-.437-1.062S8.917 8 8.5 8s-.77.146-1.062.438S7 9.083 7 9.5s.146.77.438 1.063S8.083 11 8.5 11m3.5 2.5q-1.7 0-3.087.963C7.525 15.426 7.317 15.95 6.9 17h1.65a4.1 4.1 0 0 1 1.462-1.462Q10.926 15 12 15c1.075 0 1.38.18 1.988.538s1.095.845 1.462 1.462h1.65q-.625-1.575-2.013-2.537C13.7 13.5 13.134 13.5 12 13.5m0 8.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentDissatisfied.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentNeutral.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M15.5 11q.624 0 1.063-.437c.439-.438.437-.646.437-1.063s-.146-.77-.437-1.062S15.917 8 15.5 8s-.77.146-1.062.438S14 9.083 14 9.5s.146.77.438 1.063.645.437 1.062.437m-7 0q.624 0 1.063-.437C10 10.125 10 9.917 10 9.5s-.146-.77-.437-1.062S8.917 8 8.5 8s-.77.146-1.062.438S7 9.083 7 9.5s.146.77.438 1.063S8.083 11 8.5 11m.5 4.5h6V14H9zm3 6.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentNeutral.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentSatisfied.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M15.5 11q.624 0 1.063-.437c.439-.438.437-.646.437-1.063s-.146-.77-.437-1.062S15.917 8 15.5 8s-.77.146-1.062.438S14 9.083 14 9.5s.146.77.438 1.063.645.437 1.062.437m-7 0q.624 0 1.063-.437C10 10.125 10 9.917 10 9.5s-.146-.77-.437-1.062S8.917 8 8.5 8s-.77.146-1.062.438S7 9.083 7 9.5s.146.77.438 1.063S8.083 11 8.5 11m3.5 6.5q1.7 0 3.088-.962c1.388-.962 1.595-1.488 2.012-2.538h-1.65q-.55.925-1.462 1.463C13.076 16 12.717 16 12 16s-1.38-.18-1.987-.537A4.1 4.1 0 0 1 8.55 14H6.9q.625 1.575 2.012 2.538c1.387.963 1.955.962 3.088.962m0 4.5q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentSatisfied.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentVerySatisfied.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 17.5q1.7 0 3.088-.962c1.388-.962 1.595-1.488 2.012-2.538H6.9q.626 1.575 2.013 2.538c1.387.963 1.954.962 3.087.962M7.8 11l1.1-1.05L9.95 11 11 9.95 8.9 7.8 6.75 9.95zm6.25 0 1.05-1.05L16.2 11l1.05-1.05L15.1 7.8 13 9.95zM12 22q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentVerySatisfied.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Setting.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m9.25 22-.4-3.2a4 4 0 0 1-.612-.3 8 8 0 0 1-.563-.375L4.7 19.375l-2.75-4.75 2.575-1.95a2.4 2.4 0 0 1-.025-.337v-.675q0-.163.025-.338L1.95 9.375l2.75-4.75 2.975 1.25q.276-.2.575-.375c.3-.175.4-.217.6-.3l.4-3.2h5.5l.4 3.2q.325.125.613.3c.288.175.379.242.562.375l2.975-1.25 2.75 4.75-2.575 1.95q.025.176.025.338v.674q0 .163-.05.338l2.575 1.95-2.75 4.75-2.95-1.25q-.275.2-.575.375c-.3.175-.4.217-.6.3l-.4 3.2zM11 20h1.975l.35-2.65q.775-.2 1.438-.587c.663-.387.845-.571 1.212-.938l2.475 1.025.975-1.7-2.15-1.625q.126-.35.175-.737c.05-.387.05-.521.05-.788s-.016-.53-.05-.787-.091-.505-.175-.738l2.15-1.625-.975-1.7-2.475 1.05q-.55-.575-1.212-.962c-.662-.387-.921-.455-1.438-.588L13 4h-1.975l-.35 2.65q-.776.2-1.437.588-.663.387-1.213.937L5.55 7.15l-.975 1.7 2.15 1.6q-.124.375-.175.75a6 6 0 0 0-.05.8q0 .4.05.775t.175.75l-2.15 1.625.975 1.7 2.475-1.05q.55.574 1.213.963.662.387 1.437.587zm1.05-4.5q1.45 0 2.475-1.025C15.55 13.45 15.55 12.967 15.55 12s-.342-1.792-1.025-2.475A3.37 3.37 0 0 0 12.05 8.5q-1.474 0-2.487 1.025T8.55 12c0 1.45.338 1.792 1.013 2.475S11.067 15.5 12.05 15.5"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Setting.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SettingFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m9.25 22-.4-3.2a4 4 0 0 1-.612-.3 8 8 0 0 1-.563-.375L4.7 19.375l-2.75-4.75 2.575-1.95a2.4 2.4 0 0 1-.025-.337v-.675q0-.163.025-.338L1.95 9.375l2.75-4.75 2.975 1.25q.276-.2.575-.375c.3-.175.4-.217.6-.3l.4-3.2h5.5l.4 3.2q.325.125.613.3c.288.175.379.242.562.375l2.975-1.25 2.75 4.75-2.575 1.95q.025.176.025.338v.674q0 .163-.05.338l2.575 1.95-2.75 4.75-2.95-1.25q-.275.2-.575.375c-.3.175-.4.217-.6.3l-.4 3.2zm2.8-6.5q1.45 0 2.475-1.025C15.55 13.45 15.55 12.967 15.55 12s-.342-1.792-1.025-2.475A3.37 3.37 0 0 0 12.05 8.5q-1.474 0-2.487 1.025T8.55 12c0 1.45.338 1.792 1.013 2.475S11.067 15.5 12.05 15.5"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SettingFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Share.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 23q-.824 0-1.412-.587C4 21.826 4 21.55 4 21V10q0-.825.588-1.412C5.176 8 5.45 8 6 8h3v2H6v11h12V10h-3V8h3q.824 0 1.413.588c.589.588.587.862.587 1.412v11q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm5-7V4.825l-1.6 1.6L8 5l4-4 4 4-1.4 1.425-1.6-1.6V16z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Share.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShieldLock.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-3.476-.874-5.737-3.987C4.002 14.898 4 13.633 4 11.1V5l8-3 8 3v6.1q0 3.8-2.262 6.913C15.476 21.124 14.317 21.417 12 22m0-2.1q2.6-.825 4.3-3.3c1.7-2.475 1.7-3.483 1.7-5.5V6.375l-6-2.25-6 2.25V11.1q0 3.025 1.7 5.5c1.7 2.475 2.567 2.75 4.3 3.3M10 16h4q.424 0 .713-.288c.289-.288.287-.429.287-.712v-3q0-.424-.287-.713c-.287-.289-.43-.287-.713-.287v-1q0-.824-.587-1.413C12.825 7.998 12.55 8 12 8s-1.02.196-1.412.587S10 9.45 10 10v1q-.424 0-.712.287c-.289.287-.288.43-.288.713v3q0 .424.288.712C9.575 16 9.717 16 10 16m1-5v-1q0-.424.288-.713C11.575 8.998 11.717 9 12 9s.52.096.713.287.287.43.287.713v1z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShieldLock.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingBag.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 22q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V8q0-.824.588-1.412C5.176 6 5.45 6 6 6h2q0-1.65 1.175-2.825C10.35 2 10.9 2 12 2s2.042.392 2.825 1.175S16 4.9 16 6h2q.824 0 1.413.588C20.002 7.176 20 7.45 20 8v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V8h-2v2q0 .424-.287.713c-.287.289-.43.287-.713.287s-.52-.096-.712-.287S14 10.283 14 10V8h-4v2q0 .424-.287.713c-.287.289-.43.287-.713.287s-.52-.096-.712-.287S8 10.283 8 10V8H6zm4-14h4q0-.824-.587-1.412C12.825 4 12.55 4 12 4s-1.02.196-1.412.588S10 5.45 10 6"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingBag.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingCart.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7.006 22q-.826 0-1.414-.587c-.588-.587-.588-.863-.588-1.413s.196-1.02.588-1.412S6.455 18 7.006 18s1.021.196 1.413.588q.588.587.588 1.412c0 .825-.196 1.02-.588 1.413A1.93 1.93 0 0 1 7.006 22m10.009 0q-.825 0-1.414-.587c-.589-.587-.588-.863-.588-1.413s.196-1.02.588-1.412.863-.588 1.414-.588 1.022.196 1.414.588.588.862.588 1.412-.196 1.02-.588 1.413-.864.587-1.414.587M6.155 6l2.402 5h7.007l2.752-5zm-.951-2h14.764q.575 0 .875.513c.3.513.209.687.025 1.037l-3.553 6.4q-.275.5-.738.775c-.463.275-.646.275-1.013.275H8.107l-1.101 2h12.01v2H7.007q-1.126 0-1.702-.987-.576-.988-.05-1.963l1.351-2.45L3.002 4H1V2h3.253z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingCart.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SignalCellular.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m16.9 21.5-1.4-1.402 2.1-2.103-2.1-2.103 1.4-1.401 2.1 2.102 2.1-2.102 1.4 1.401-2.075 2.103 2.075 2.103-1.4 1.401-2.1-2.077zM2 22 22 2v10.688q-.45-.275-.95-.438c-.5-.163-.683-.196-1.05-.263V6.831L6.825 19.998h6.425q.2.575.5 1.076.3.5.675.926zm4.825-2.002L20 6.83a1217 1217 0 0 1-3.45 3.442 1072 1072 0 0 0-3.037 3.029l-3.088 3.091z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SignalCellular.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Slash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m20.088 22.313-2.276-2.275q-1.224.8-2.612 1.225c-1.388.425-1.887.425-2.887.425q-2.076 0-3.9-.788c-1.825-.788-2.276-1.237-3.176-2.137S3.625 16.804 3.1 15.588s-.788-2.517-.788-3.9q0-1.5.425-2.888c.425-1.388.692-1.796 1.225-2.612L1.687 3.913l1.425-1.425 18.4 18.4zm-7.776-2.625a7.93 7.93 0 0 0 4.05-1.1L5.412 7.638q-.549.95-.825 1.962c-.276 1.012-.275 1.37-.275 2.088q0 3.325 2.338 5.662c2.338 2.337 3.446 2.338 5.662 2.338m8.35-2.5-1.45-1.45q.55-.95.825-1.963c.275-1.013.275-1.37.275-2.087q0-3.326-2.337-5.663c-2.337-2.337-3.446-2.337-5.663-2.337a7.93 7.93 0 0 0-4.05 1.1l-1.45-1.45q1.225-.8 2.613-1.225c1.388-.425 1.887-.425 2.887-.425q2.076 0 3.9.787c1.824.787 2.275 1.238 3.175 2.138S21 6.57 21.525 7.788s.787 2.516.787 3.9q0 1.5-.425 2.887c-.425 1.387-.691 1.796-1.225 2.613"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Slash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sms.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8 11q.424 0 .713-.287c.289-.287.287-.43.287-.713q0-.424-.287-.712C8.426 8.999 8.283 9 8 9s-.52.096-.712.288S7 9.717 7 10q0 .424.288.713c.287.289.429.287.712.287m4 0q.424 0 .713-.287c.289-.287.287-.43.287-.713q0-.424-.287-.712C12.426 8.999 12.283 9 12 9s-.52.096-.712.288S11 9.717 11 10q0 .424.288.713c.287.289.429.287.712.287m4 0q.424 0 .713-.287C17 10.426 17 10.283 17 10q0-.424-.287-.712C16.425 8.999 16.282 9 16 9s-.52.096-.713.288S15 9.717 15 10q0 .424.287.713c.287.289.43.287.713.287M2 22V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6zm3.15-6H20V4H4v13.125z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sms.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Snaps.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 19.425v-6.85L5 9.1v6.85zm2 0 6-3.475V9.1l-6 3.475zm-1-8.575 5.925-3.425L12 4 6.075 7.425zM4 17.7q-.475-.275-.737-.725c-.262-.45-.263-.633-.263-1v-7.95A1.95 1.95 0 0 1 4 6.3l7-4.025Q11.475 2 12 2c.525 0 .683.092 1 .275L20 6.3q.475.275.738.725c.263.45.262.633.262 1v7.95a1.95 1.95 0 0 1-1 1.725l-7 4.025Q12.525 22 12 22c-.525 0-.683-.092-1-.275z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Snaps.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsMobile.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M3.586 3.586C3 4.172 3 5.114 3 7v10c0 1.886 0 2.828.586 3.414S5.114 21 7 21h10c1.886 0 2.828 0 3.414-.586S21 18.886 21 17V7c0-1.886 0-2.828-.586-3.414S18.886 3 17 3H7c-1.886 0-2.828 0-3.414.586m7.747 8.797v4.567l-4-2.317v-4.566zm5.334 2.25-4 2.317v-4.567l4-2.316zM15.95 8.95 12 11.233 8.05 8.95 12 6.667zm-9.775 6.367q.175.3.492.483l4.666 2.683a1.31 1.31 0 0 0 1.334 0l4.666-2.683q.316-.183.492-.483c.176-.3.175-.422.175-.667v-5.3a1.3 1.3 0 0 0-.667-1.15l-4.666-2.683a1.31 1.31 0 0 0-1.334 0L6.667 8.2A1.299 1.299 0 0 0 6 9.35v5.3q0 .367.175.667",clipRule:"evenodd"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsMobile.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsPlus.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 4 6.075 7.425 12 10.85l5.925-3.425zM3 15.975v-7.95A1.95 1.95 0 0 1 4 6.3l7-4.025q.25-.125.488-.2C11.726 2 11.817 2 12 2s.358.025.525.075.325.117.475.2L20 6.3q.475.275.738.725c.263.45.262.633.262 1V12h-2V9.1l-7.025 4.05L5 9.1v6.85l6 3.475v2.3L4 17.7q-.475-.275-.737-.725c-.262-.45-.263-.633-.263-1"}),a.createElement("path",{d:"M17 19v3h2v-3h3v-2h-3v-3h-2v3h-3v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsPlus.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsRound.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11.323 12.39v4.638L7.26 14.675v-4.639zM16.74 14.675l-4.063 2.353V12.39l4.064-2.353zM16.013 8.902 12 11.222l-4.012-2.32L12 6.582z"}),a.createElement("path",{fillRule:"evenodd",d:"M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10m-5.917-6.63q.178.303.5.49l4.74 2.726a1.33 1.33 0 0 0 1.354 0l4.74-2.726q.323-.187.5-.49a1.3 1.3 0 0 0 .178-.678V9.308a1.32 1.32 0 0 0-.677-1.168l-4.74-2.726a1.33 1.33 0 0 0-1.355 0L6.583 8.14q-.322.186-.5.491c-.178.305-.178.429-.178.677v5.384q0 .372.178.677",clipRule:"evenodd"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsRound.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sort.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 18v-2h6v2zm0-5v-2h12v2zm0-5V6h18v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sort.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SortByAlpha.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M2 17 5.75 7H7.9l3.75 10H9.6l-.85-2.4H4.9L4.1 17zm3.5-4.1h2.6L6.9 9.15h-.15zm8.2 4.1v-1.9l5.05-6.3H13.9V7h7.05v1.9l-5 6.3H21V17zM9 5l3-3 3 3zm3 17-3-3h6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SortByAlpha.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sparkle.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("g",{fillRule:"evenodd",clipRule:"evenodd"},a.createElement("path",{d:"M17.714 3A4.86 4.86 0 0 0 22 7.304a4.86 4.86 0 0 0-4.286 4.305 4.86 4.86 0 0 0-4.285-4.305A4.86 4.86 0 0 0 17.714 3M16.46 14.913a3.44 3.44 0 0 0 3.03 3.044A3.44 3.44 0 0 0 16.46 21a3.44 3.44 0 0 0-3.03-3.043 3.44 3.44 0 0 0 3.03-3.044M9.143 4.87a8.12 8.12 0 0 1-4.383 6.349 8 8 0 0 1-2.76.824c.985.11 1.915.396 2.76.826a8.12 8.12 0 0 1 4.383 6.348 8.12 8.12 0 0 1 4.383-6.349 8 8 0 0 1 2.76-.825 8 8 0 0 1-2.76-.825A8.12 8.12 0 0 1 9.143 4.87m0 4.348a9.6 9.6 0 0 1-2.818 2.825 9.6 9.6 0 0 1 2.818 2.826 9.6 9.6 0 0 1 2.818-2.826 9.6 9.6 0 0 1-2.818-2.825"}))));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sparkle.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speed.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M9 3V1h6v2zm2 11h2V8h-2zm1 8q-1.85 0-3.487-.712c-1.638-.712-2.046-1.121-2.863-1.938s-1.463-1.77-1.938-2.862S3 14.233 3 13s.237-2.396.712-3.487Q4.424 7.874 5.65 6.65c1.226-1.225 1.77-1.463 2.862-1.938S10.767 4 12 4q1.55 0 2.975.5c1.425.5 1.842.817 2.675 1.45l1.4-1.4 1.4 1.4-1.4 1.4Q20 8.6 20.5 10.025c.5 1.425.5 1.942.5 2.975q0 1.85-.713 3.488c-.713 1.638-1.12 2.045-1.937 2.862s-1.77 1.463-2.863 1.938S13.233 22 12 22m0-2q2.9 0 4.95-2.05C19 15.9 19 14.933 19 13s-.683-3.583-2.05-4.95S13.933 6 12 6s-3.583.683-4.95 2.05S5 11.067 5 13s.683 3.583 2.05 4.95S10.067 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speed.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speedometer.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M10.45 15.5q.6.6 1.55.588c.95-.013 1.1-.238 1.4-.688L19 7l-8.4 5.6q-.675.45-.712 1.375c-.038.925.162 1.125.562 1.525M12 4q1.475 0 2.838.413C16.2 4.825 16.6 5.1 17.4 5.65l-1.9 1.2q-.824-.425-1.713-.637C12.898 6 12.6 6 12 6Q8.675 6 6.337 8.337C4 10.674 4 11.783 4 14q0 1.05.287 2.075C4.574 17.1 4.75 17.4 5.1 18h13.8q.575-.95.838-1.975C20 15 20 14.633 20 13.9q0-.9-.213-1.75c-.213-.85-.354-1.117-.637-1.65l1.2-1.9q.75 1.175 1.187 2.5c.437 1.325.446 1.8.463 2.75s-.092 1.858-.325 2.725-.575 1.692-1.025 2.475q-.274.45-.75.7c-.476.25-.65.25-1 .25H5.1q-.525 0-1-.25c-.475-.25-.567-.4-.75-.7q-.65-1.125-1-2.387C2 15.4 2 14.933 2 14q0-2.075.787-3.887.788-1.813 2.15-3.175C6.3 5.576 6.908 5.313 8.125 4.788S10.633 4 12 4"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speedometer.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Square.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h14V5H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Square.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Stake.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 21v-7.975q-1.6 0-3.075-.612c-1.475-.613-1.85-.988-2.6-1.738S4 9.058 3.6 8.075 3 6.067 3 5V3h2q1.575 0 3.05.612c1.475.612 1.85.988 2.6 1.738q.775.775 1.287 1.7c.512.925.605 1.275.788 1.975q.125-.176.275-.338c.15-.162.208-.22.325-.337q1.125-1.125 2.6-1.738C17.4 6 17.933 6 19 6h2v2q0 1.6-.613 3.075c-.613 1.475-.987 1.85-1.737 2.6S17.037 15 16.062 15.4 14.067 16 13 16v5zm0-10q0-1.2-.462-2.287c-.463-1.087-.746-1.371-1.313-1.938S8.013 5.771 7.288 5.463 5.8 5 5 5q0 1.2.45 2.3c.45 1.1.733 1.383 1.3 1.95s1.217 1 1.95 1.3 1.5.45 2.3.45m2 3a5.92 5.92 0 0 0 4.225-1.75 6 6 0 0 0 1.313-1.95Q19 9.2 19 8q-1.2 0-2.3.463c-1.1.463-1.383.745-1.95 1.312A5.92 5.92 0 0 0 13 14"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Stake.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Star.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8.85 16.825 3.15-1.9 3.15 1.925-.825-3.6 2.775-2.4-3.65-.325-1.45-3.4-1.45 3.375-3.65.325 2.775 2.425zM5.825 21l1.625-7.025L2 9.25l7.2-.625L12 2l2.8 6.625 7.2.625-5.45 4.725L18.175 21 12 17.275z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Star.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/StarFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m5.825 21 1.625-7.025L2 9.25l7.2-.625L12 2l2.8 6.625 7.2.625-5.45 4.725L18.175 21 12 17.275z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/StarFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Start.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M2 18V6h2v12zm14 0-1.425-1.4 3.6-3.6H6v-2h12.175L14.6 7.4 16 6l6 6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Start.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Storefront.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M21 11.05V19q0 .824-.587 1.413A1.93 1.93 0 0 1 19 21H5q-.825 0-1.412-.587A1.93 1.93 0 0 1 3 19v-7.95q-.575-.525-.887-1.35T2.1 7.9l1.05-3.4a2.2 2.2 0 0 1 .713-1.075A1.8 1.8 0 0 1 5.05 3h13.9q.675 0 1.175.413.5.412.725 1.087l1.05 3.4q.3.975-.012 1.775A3.95 3.95 0 0 1 21 11.05M14.2 10q.675 0 1.025-.462.35-.463.275-1.038L14.95 5H13v3.7q0 .525.35.913.35.387.85.387m-4.5 0q.575 0 .938-.387Q11 9.225 11 8.7V5H9.05L8.5 8.5q-.101.6.263 1.05.362.45.937.45m-4.45 0q.45 0 .788-.325c.338-.325.362-.492.412-.825L7 5H5.05l-1 3.35q-.15.5.163 1.075Q4.525 10 5.25 10m13.5 0q.724 0 1.05-.575.325-.575.15-1.075L18.9 5H17l.55 3.85q.075.5.413.825c.338.325.487.325.787.325M5 19h14v-7.05a.6.6 0 0 1-.162.05h-.088a2.9 2.9 0 0 1-1.187-.225q-.513-.225-1.013-.725a3.3 3.3 0 0 1-1.025.7Q14.95 12 14.3 12q-.674 0-1.262-.25a3.3 3.3 0 0 1-1.038-.7q-.425.45-.987.7c-.562.25-.78.25-1.213.25a3.3 3.3 0 0 1-1.312-.25 3.3 3.3 0 0 1-1.038-.7q-.525.525-1.037.738A3 3 0 0 1 5.25 12h-.112A.25.25 0 0 1 5 11.95z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Storefront.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Student.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 21-7-3.8v-6L1 9l11-6 11 6v8h-2v-6.9l-2 1.1v6zm0-8.3L18.85 9 12 5.3 5.15 9zm0 6.025 5-2.7V12.25L12 15l-5-2.75v3.775z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Student.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapHorizontal.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m7 20-5-5 5-5 1.4 1.425L5.825 14H13v2H5.825L8.4 18.575zm10-6-1.4-1.425L18.175 10H11V8h7.175L15.6 5.425 17 4l5 5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapHorizontal.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapVertical.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M8 13V5.825L5.425 8.4 4 7l5-5 5 5-1.425 1.4L10 5.825V13zm7 9-5-5 1.425-1.4L14 18.175V11h2v7.175l2.575-2.575L20 17z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapVertical.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TabClose.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m11.9 13.5 2.1-2.1 2.1 2.1 1.4-1.4-2.1-2.1 2.1-2.1-1.4-1.4L14 8.6l-2.1-2.1-1.4 1.4 2.1 2.1-2.1 2.1zM8 18q-.824 0-1.412-.587C6 16.826 6 16.55 6 16V4q0-.824.588-1.412C7.176 1.999 7.45 2 8 2h12q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V4H8zm-4 6q-.824 0-1.412-.587C1.999 20.826 2 20.55 2 20V6h2v14h14v2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TabClose.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TableRow.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M19 19v-3H5v3zm0-5v-4H5v4zm0-6V5H5v3zM5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v14q0 .824-.587 1.413c-.587.589-.863.587-1.413.587z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TableRow.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tablet.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 20.5q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.712-.43-.288-.713-.288-.52.096-.712.288-.288.429-.288.712.096.52.288.713.429.287.712.287M5 23q-.824 0-1.412-.587C2.999 21.826 3 21.55 3 21V3q0-.824.588-1.412C4.175.999 4.45 1 5 1h14q.824 0 1.413.587C21.002 2.175 21 2.45 21 3v18q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-5v3h14v-3zm0-2h14V6H5zM5 4h14V3H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tablet.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tag.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m21.413 14.25-7.15 7.15q-.3.3-.675.45c-.375.15-.5.15-.75.15s-.5-.05-.75-.15-.475-.25-.675-.45l-8.825-8.825q-.276-.275-.425-.637c-.15-.363-.15-.496-.15-.763V4q0-.824.587-1.412A1.93 1.93 0 0 1 4.013 2h7.175q.4 0 .775.163c.375.163.466.254.65.437l8.8 8.825q.3.3.437.675c.137.375.138.5.138.75s-.046.496-.138.738-.237.462-.437.662M12.838 20l7.15-7.15L11.163 4h-7.15v7.15zM6.513 8q.624 0 1.062-.437.438-.438.438-1.063c0-.625-.146-.77-.438-1.062A1.45 1.45 0 0 0 6.513 5q-.625 0-1.063.438-.437.436-.437 1.062c0 .626.146.77.437 1.063Q5.888 8 6.513 8"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tag.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDown.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 3h11v13l-7 7-1.25-1.25q-.175-.175-.287-.475c-.112-.3-.113-.392-.113-.575v-.35L9.45 16H3q-.8 0-1.4-.6C1 14.8 1 14.533 1 14v-2q0-.175.05-.375c.05-.2.067-.258.1-.375l3-7.05q.225-.5.75-.85C5.425 3 5.617 3 6 3m9 2H6l-3 7v2h9l-1.35 5.5L15 15.15zm2 11v-2h3V5h-3V3h5v13z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDown.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDownFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 3h10v13l-7 7-1.25-1.25q-.175-.175-.287-.475c-.112-.3-.113-.392-.113-.575v-.35L8.45 16H3q-.8 0-1.4-.6C1 14.8 1 14.533 1 14v-2a2 2 0 0 1 .15-.75l3-7.05q.225-.5.75-.85C5.425 3 5.617 3 6 3m12 13V3h4v13z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDownFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUp.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M18 21H7V8l7-7 1.25 1.25q.175.175.288.475c.112.3.112.392.112.575v.35L14.55 8H21q.8 0 1.4.6c.6.6.6.867.6 1.4v2q0 .175-.05.375c-.05.2-.067.258-.1.375l-3 7.05q-.225.5-.75.85c-.525.35-.717.35-1.1.35m-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85zM7 8v2H4v9h3v2H2V8z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUp.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUpFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M18 21H8V8l7-7 1.25 1.25q.175.175.288.475c.113.3.112.392.112.575v.35L15.55 8H21q.8 0 1.4.6c.6.6.6.867.6 1.4v2a2 2 0 0 1-.15.75l-3 7.05q-.225.5-.75.85c-.525.35-.717.35-1.1.35M6 8v13H2V8z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUpFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tint.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 21q-3.325 0-5.662-2.3C4 16.4 4 15.3 4 13.1q0-1.625.625-3.037A8.2 8.2 0 0 1 6.35 7.55L12 2l5.65 5.55a8.2 8.2 0 0 1 1.725 2.513Q20 11.474 20 13.1q0 3.3-2.337 5.6C15.326 21 14.217 21 12 21m-5.95-7H17.9q.3-1.8-.337-3.075C16.926 9.65 16.7 9.433 16.25 9L12 4.8 7.75 9q-.675.65-1.325 1.925C5.775 12.2 5.867 12.8 6.05 14"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tint.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tooltip.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 22-2.675-4H4q-.824 0-1.413-.587C1.998 16.826 2 16.55 2 16V4q0-.824.587-1.412C3.174 1.999 3.45 2 4 2h16q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587h-5.325zm0-3.6 1.6-2.4H20V4H4v12h6.4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tooltip.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Translate.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m11.85 22 4.53-12h2.09L23 22h-2.09l-1.07-3.05H15.01L13.941 22zm-7.864-3-1.393-1.4 5.027-5.05q-.871-.875-1.58-2C5.33 9.425 5.13 8.95 4.733 8h2.09q.498.975.996 1.7t1.195 1.45q.82-.824 1.704-2.313C11.602 7.348 11.751 6.9 12.05 6H1V4h6.968V2H9.96v2h6.969v2H14.04q-.523 1.8-1.568 3.7-1.046 1.9-2.066 2.9l2.39 2.45-.747 2.05-3.036-3.125zm11.647-1.8h3.584l-1.792-5.1z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Translate.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Trash.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 21q-.824 0-1.412-.587C5 19.826 5 19.55 5 19V6H4V4h5V3h6v1h5v2h-1v13q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zM17 6H7v13h10zM9 17h2V8H9zm4 0h2V8h-2z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Trash.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendDown.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M16 18v-2h2.6l-5.2-5.15-4 4L2 7.4 3.4 6l6 6 4-4 6.6 6.6V12h2v6z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendDown.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendUp.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3.4 18 2 16.6l7.4-7.45 4 4L18.6 8H16V6h6v6h-2V9.4L13.4 16l-4-4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendUp.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Undo.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M7 19.5v-2h7.1q1.575 0 2.738-1C18 15.5 18 15 18 14s-.387-1.833-1.162-2.5-1.688-1-2.738-1H7.8l2.6 2.6L9 14.5l-5-5 5-5 1.4 1.4-2.6 2.6h6.3q2.425 0 4.162 1.575C20 11.65 20 12.433 20 14s-.58 2.875-1.738 3.925S15.717 19.5 14.1 19.5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Undo.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unfold.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m12 20.95-4.5-4.5L8.95 15 12 18.05 15.05 15l1.45 1.45zM8.95 9 7.5 7.55l4.5-4.5 4.5 4.5L15.05 9 12 5.95z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unfold.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UnlockedFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M6 8.5h9v-2q0-1.25-.875-2.125C13.25 3.5 12.833 3.5 12 3.5s-1.542.292-2.125.875A2.9 2.9 0 0 0 9 6.5H7q0-2.075 1.463-3.537C9.926 1.5 10.617 1.5 12 1.5s2.563.488 3.538 1.463S17 5.117 17 6.5v2h1q.824 0 1.413.588c.589.588.587.862.587 1.412v10q0 .824-.587 1.413c-.587.589-.863.587-1.413.587H6q-.824 0-1.412-.587C4 21.326 4 21.05 4 20.5v-10q0-.825.588-1.412C5.176 8.5 5.45 8.5 6 8.5m6 9q.824 0 1.413-.587C14 16.326 14 16.05 14 15.5s-.196-1.02-.587-1.412S12.55 13.5 12 13.5s-1.02.196-1.412.588S10 14.95 10 15.5s.196 1.02.588 1.413.862.587 1.412.587"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UnlockedFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unpin.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{fillRule:"evenodd",d:"M3.507 2.047 2.093 3.46 8.48 9.847H5.65l-1.414 1.415 3.536 3.535L3.53 19.04v1.414h1.414l4.243-4.243 3.535 3.536 1.415-1.414v-2.829l6.385 6.386 1.414-1.414zm5.786 9.816.6-.601 2.83 2.828-.602.601v1.626l-4.454-4.454z",clipRule:"evenodd"}),a.createElement("path",{d:"m16.965 12.676 2.121-2.121.708.707 1.414-1.415-7.071-7.07-1.415 1.414.708.707-2.122 2.121 1.414 1.414 2.122-2.121 2.828 2.828-2.121 2.122z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unpin.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Upload.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 16V7.85l-2.6 2.6L7 9l5-5 5 5-1.4 1.45-2.6-2.6V16zm-5 4q-.824 0-1.412-.587C4 18.826 4 18.55 4 18v-3h2v3h12v-3h2v3q0 .824-.587 1.413c-.587.589-.863.587-1.413.587z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Upload.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UploadFile.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 19h2v-4.175l1.6 1.6L16 15l-4-4-4 4 1.425 1.4L11 14.825zm-5 3q-.824 0-1.412-.587C4 20.826 4 20.55 4 20V4q0-.824.588-1.412C5.176 1.999 5.45 2 6 2h8l6 6v12q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-13V4H6v16h12V9z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UploadFile.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Usb.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 22q-.825 0-1.412-.587C10 20.826 10 20.55 10 20q0-.525.275-.975c.275-.45.425-.542.725-.725V16H8q-.824 0-1.412-.588C6 14.824 6 14.55 6 14v-2.3q-.45-.225-.725-.675C5 10.575 5 10.383 5 10q0-.824.588-1.413C6.176 7.998 6.45 8 7 8s1.02.196 1.413.587S9 9.45 9 10q0 .575-.275 1c-.275.425-.425.517-.725.7V14h3V6H9l3-4 3 4h-2v8h3v-2h-1V8h4v4h-1v2q0 .824-.587 1.412C16.826 16 16.55 16 16 16h-3v2.3q.476.25.738.7c.262.45.262.633.262 1q0 .825-.587 1.412C12.825 22 12.55 22 12 22"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Usb.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/User.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 12q-1.65 0-2.825-1.175C8 9.65 8 9.1 8 8s.392-2.042 1.175-2.825S10.9 4 12 4s2.042.392 2.825 1.175S16 6.9 16 8s-.392 2.042-1.175 2.825S13.1 12 12 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C10.35 13 10.9 13 12 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C13.4 15 12.933 15 12 15s-1.858.112-2.775.337Q7.85 15.675 6.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C14 8.825 14 8.55 14 8s-.196-1.02-.587-1.412S12.55 6 12 6s-1.02.196-1.412.588S10 7.45 10 8s.196 1.02.588 1.413S11.45 10 12 10"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/User.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCheck.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M17.55 12 14 8.45l1.425-1.4 2.125 2.125 4.25-4.25 1.4 1.425zM9 12q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C11 8.825 11 8.55 11 8s-.196-1.02-.587-1.412S9.55 6 9 6s-1.02.196-1.412.588S7 7.45 7 8s.196 1.02.588 1.413S8.45 10 9 10"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCheck.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircle.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5.85 17.1q1.275-.975 2.85-1.537C10.275 15 10.85 15 12 15s2.25.188 3.3.563 2 .887 2.85 1.537q.875-1.025 1.363-2.325C20 13.475 20 12.983 20 12q0-3.325-2.337-5.662C15.326 4 14.217 4 12 4Q8.675 4 6.338 6.338C4 8.676 4 9.783 4 12q0 1.475.488 2.775c.488 1.3.779 1.642 1.362 2.325M12 13q-1.474 0-2.487-1.012C8.499 10.976 8.5 10.483 8.5 9.5q0-1.474 1.013-2.487C10.525 6 11.016 6 12 6s1.813.338 2.488 1.013S15.5 8.517 15.5 9.5q0 1.475-1.012 2.488C13.476 13 12.983 13 12 13m0 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q1.325 0 2.5-.387c1.175-.387 1.5-.63 2.15-1.113q-.975-.725-2.15-1.112C13.325 17 12.883 17 12 17s-1.717.13-2.5.388A7.5 7.5 0 0 0 7.35 18.5a7.5 7.5 0 0 0 2.15 1.113A8 8 0 0 0 12 20m0-9q.65 0 1.075-.425c.425-.425.425-.642.425-1.075s-.142-.792-.425-1.075S12.433 8 12 8s-.792.142-1.075.425-.425.642-.425 1.075.142.792.425 1.075S11.567 11 12 11"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircle.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleAdd.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M18 14v-3h-3V9h3V6h2v3h3v2h-3v3zm-9-2q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C11 8.825 11 8.55 11 8s-.196-1.02-.587-1.412S9.55 6 9 6s-1.02.196-1.412.588S7 7.45 7 8s.196 1.02.588 1.413S8.45 10 9 10"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleAdd.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleRemove.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M16 11V9h6v2zm-7 1q-1.65 0-2.825-1.175C5 9.65 5 9.1 5 8s.392-2.042 1.175-2.825S7.9 4 9 4s2.042.392 2.825 1.175S13 6.9 13 8s-.392 2.042-1.175 2.825S10.1 12 9 12m-8 8v-2.8q0-.85.438-1.562c.438-.713.679-.838 1.162-1.088q1.55-.775 3.15-1.163C7.35 13 7.9 13 9 13s2.183.13 3.25.388 2.117.645 3.15 1.162q.724.375 1.163 1.087c.439.712.437.996.437 1.563V20zm2-2h12v-.8q0-.275-.137-.5c-.137-.225-.213-.267-.363-.35q-1.35-.675-2.725-1.013C10.4 15 9.933 15 9 15s-1.858.112-2.775.337S4.4 15.9 3.5 16.35a.97.97 0 0 0-.5.85zm6-8q.824 0 1.413-.587C11 8.825 11 8.55 11 8s-.196-1.02-.587-1.412S9.55 6 9 6s-1.02.196-1.412.588S7 7.45 7 8s.196 1.02.588 1.413S8.45 10 9 10"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleRemove.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Verified.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8.6 22.5-1.9-3.2-3.6-.8.35-3.7L1 12l2.45-2.8-.35-3.7 3.6-.8 1.9-3.2L12 2.95l3.4-1.45 1.9 3.2 3.6.8-.35 3.7L23 12l-2.45 2.8.35 3.7-3.6.8-1.9 3.2-3.4-1.45zm.85-2.55 2.55-1.1 2.6 1.1 1.4-2.4 2.75-.65-.25-2.8 1.85-2.1-1.85-2.15.25-2.8-2.75-.6-1.45-2.4L12 5.15l-2.6-1.1L8 6.45l-2.75.6.25 2.8L3.65 12l1.85 2.1-.25 2.85 2.75.6zm1.5-4.4L16.6 9.9l-1.4-1.45-4.25 4.25-2.15-2.1L7.4 12z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Verified.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/VerifiedFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m8.6 22.5-1.9-3.2-3.6-.8.35-3.7L1 12l2.45-2.8-.35-3.7 3.6-.8 1.9-3.2L12 2.95l3.4-1.45 1.9 3.2 3.6.8-.35 3.7L23 12l-2.45 2.8.35 3.7-3.6.8-1.9 3.2-3.4-1.45zm2.35-6.95L16.6 9.9l-1.4-1.45-4.25 4.25-2.15-2.1L7.4 12z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/VerifiedFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Videocam.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M4 20q-.824 0-1.412-.587C1.999 18.826 2 18.55 2 18V6q0-.824.588-1.412C3.175 4 3.45 4 4 4h12q.824 0 1.413.588C18.002 5.176 18 5.45 18 6v4.5l4-4v11l-4-4V18q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm0-2h12V6H4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Videocam.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewColumn.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M3 17V7q0-.824.588-1.412C4.176 5 4.452 5 5.003 5h13.994q.826 0 1.415.588C21 6.176 21 6.45 21 7v10q0 .824-.588 1.413c-.588.589-.864.587-1.415.587H5.003q-.826 0-1.415-.587C3 17.826 3 17.55 3 17m1.978 0h3.33V7h-3.33zm5.332 0h3.33V7h-3.33zm5.333 0h3.33V7h-3.33z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewColumn.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewInAr.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M11 19.475 6 16.6q-.475-.275-.737-.725c-.262-.45-.263-.633-.263-1v-5.75A1.95 1.95 0 0 1 6 7.4l5-2.875q.475-.275 1-.275c.525 0 .683.092 1 .275L18 7.4q.475.275.738.725c.263.45.262.633.262 1v5.75a1.95 1.95 0 0 1-1 1.725l-5 2.875q-.475.275-1 .275c-.525 0-.683-.092-1-.275m0-2.3v-4.6L7 10.25v4.625zm2 0 4-2.3V10.25l-4 2.325zM2 7V4q0-.824.588-1.412C3.175 1.999 3.45 2 4 2h3v2H4v3zm5 15H4q-.824 0-1.412-.587C1.999 20.826 2 20.55 2 20v-3h2v3h3zm10 0v-2h3v-3h2v3q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm3-15V4h-3V2h3q.824 0 1.413.588C22.002 3.175 22 3.45 22 4v3zm-8 3.85 3.95-2.325L12 6.25 8.05 8.525z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewInAr.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeOff.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"m19.8 22.6-3.025-3.025a8.3 8.3 0 0 1-1.325.688 9.5 9.5 0 0 1-1.45.462v-2.05q.35-.125.687-.25.338-.124.638-.3L12 14.8V20l-5-5H3V9h3.2L1.4 4.2l1.4-1.4 18.4 18.4zm-.2-5.8-1.45-1.45a6.8 6.8 0 0 0 .637-1.625q.213-.85.213-1.75 0-2.35-1.375-4.2C16.25 5.925 15.5 5.708 14 5.275v-2.05q3.1.7 5.05 3.138C21 8.8 21 9.858 21 11.975q0 1.325-.363 2.55A8.8 8.8 0 0 1 19.6 16.8m-3.35-3.35L14 11.2V7.95a4.15 4.15 0 0 1 1.837 1.65q.663 1.1.663 2.4a4.3 4.3 0 0 1-.25 1.45M12 9.2 9.4 6.6 12 4zm-2 5.95V12.8L8.2 11H5v2h2.85z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeOff.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeUp.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M14 20.725v-2.05q2.25-.65 3.625-2.5t1.375-4.2-1.375-4.2T14 5.275v-2.05q3.1.7 5.05 3.137C21 8.8 21 9.858 21 11.975q0 3.176-1.95 5.613c-1.95 2.437-2.983 2.67-5.05 3.137M3 15V9h4l5-5v16l-5-5zm11 1V7.95a4.15 4.15 0 0 1 1.838 1.65q.662 1.1.662 2.4 0 1.275-.662 2.363C15.176 15.45 14.783 15.633 14 16m-4-7.15L7.85 11H5v2h2.85L10 15.15z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeUp.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wallet.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5v2.5h-2V5H5v14h14v-2.5h2V19q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm8-4q-.825 0-1.412-.587C11 15.826 11 15.55 11 15V9q0-.825.588-1.412C12.176 7 12.45 7 13 7h7q.824 0 1.413.588C22.002 8.176 22 8.45 22 9v6q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm7-2V9h-7v6zm-4-1.5q.625 0 1.063-.437c.438-.438.437-.646.437-1.063s-.146-.77-.437-1.062S16.417 10.5 16 10.5s-.77.146-1.062.438-.438.645-.438 1.062.146.77.438 1.063.645.437 1.062.437"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wallet.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/WalletFilled.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M5 21q-.824 0-1.412-.587C2.999 19.826 3 19.55 3 19V5q0-.824.588-1.412C4.175 2.999 4.45 3 5 3h14q.824 0 1.413.588C21.002 4.175 21 4.45 21 5h-8q-1.775 0-2.887 1.113T9 9v6q0 1.775 1.113 2.888T13 19h8q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm8-4q-.825 0-1.412-.587C11 15.826 11 15.55 11 15V9q0-.825.588-1.412C12.176 7 12.45 7 13 7h7q.824 0 1.413.588C22.002 8.176 22 8.45 22 9v6q0 .824-.587 1.413c-.587.589-.863.587-1.413.587zm3-3.5q.65 0 1.075-.425c.425-.425.425-.642.425-1.075s-.142-.792-.425-1.075S16.433 10.5 16 10.5s-.792.142-1.075.425-.425.642-.425 1.075.142.792.425 1.075.642.425 1.075.425"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/WalletFilled.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Warning.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M12 17q.424 0 .713-.287c.289-.288.287-.43.287-.713s-.096-.52-.287-.713S12.283 15 12 15s-.52.096-.712.287S11 15.717 11 16s.096.52.288.712.429.288.712.288m-1-4h2V7h-2zm1 9q-2.075 0-3.9-.787c-1.825-.788-2.275-1.238-3.175-2.138S3.313 17.117 2.788 15.9 2 13.383 2 12s.262-2.683.787-3.9 1.238-2.275 2.138-3.175S6.883 3.312 8.1 2.787 10.617 2 12 2s2.683.262 3.9.787 2.275 1.238 3.175 2.138 1.613 1.958 2.138 3.175S22 10.617 22 12s-.262 2.683-.787 3.9-1.238 2.275-2.138 3.175-1.958 1.613-3.175 2.138S13.383 22 12 22m0-2q3.35 0 5.675-2.325C20 15.35 20 14.233 20 12q0-3.35-2.325-5.675C15.35 4 14.233 4 12 4Q8.65 4 6.325 6.325C4 8.65 4 9.767 4 12q0 3.35 2.325 5.675C8.65 20 9.767 20 12 20"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Warning.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/WebTraffic.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M2 12v-2h3v2zm3.4 5.55L4 16.1 6.1 14l1.45 1.4zM6.1 8 4 5.9l1.4-1.45L7.55 6.6zM18 20l-4.75-4.75L12 19 9 9l10 3-3.7 1.3L20 18zM10 6V3h2v3zm5.9 2-1.45-1.4 2.15-2.15 1.4 1.4z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/WebTraffic.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Widgets.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M16.65 13 11 7.35l5.65-5.65 5.65 5.65zM3 11V3h8v8zm10 10v-8h8v8zM3 21v-8h8v8zM5 9h4V5H5zm11.675 1.2L19.5 7.375 16.675 4.55 13.85 7.375zM15 19h4v-4h-4zM5 19h4v-4H5z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Widgets.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wifi.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("clipPath",{id:"a"},a.createElement("path",{d:"M0 0h24v24H0z"})),a.createElement("g",{clipPath:"url(#a)"},a.createElement("path",{d:"M12 20.886q-1.05 0-1.775-.725-.725-.726-.725-1.776c0-1.05.242-1.291.725-1.775q.725-.724 1.775-.724c1.05 0 1.292.241 1.775.725s.725 1.075.725 1.775-.242 1.291-.725 1.775-1.075.724-1.775.724m-5.65-5.65-2.1-2.15q1.475-1.476 3.463-2.338C9.7 9.886 10.467 9.886 12 9.886s2.963.291 4.288.874 2.479 1.375 3.462 2.375l-2.1 2.1q-1.1-1.1-2.55-1.725c-1.45-.625-2-.625-3.1-.625s-2.133.209-3.1.625-1.817.992-2.55 1.725m-4.25-4.25L0 8.886A16.7 16.7 0 0 1 5.375 5.21Q8.45 3.886 12 3.886t6.625 1.325A16.7 16.7 0 0 1 24 8.886l-2.1 2.1q-1.924-1.926-4.462-3.013C14.9 6.886 13.933 6.886 12 6.886s-3.746.362-5.437 1.087-3.18 1.73-4.463 3.013"}))));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wifi.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/WifiOff.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("clipPath",{id:"a"},a.createElement("path",{d:"M0 0h24v24H0z"})),a.createElement("g",{clipPath:"url(#a)"},a.createElement("path",{d:"m19.75 22.6-9.4-9.45a8.7 8.7 0 0 0-2.187.825A7.5 7.5 0 0 0 6.35 15.35l-2.1-2.15q.8-.8 1.725-1.4c.925-.6 1.275-.75 1.975-1.05L5.7 8.5q-1.024.525-1.913 1.163Q2.9 10.3 2.1 11.1L0 8.95q.8-.8 1.662-1.437C2.524 6.876 2.85 6.683 3.5 6.3L1.4 4.2l1.4-1.4 18.4 18.4zM12 21q-1.05 0-1.775-.737A2.43 2.43 0 0 1 9.5 18.5q0-1.05.725-1.775T12 16c1.05 0 1.292.242 1.775.725q.725.725.725 1.775 0 1.024-.725 1.763A2.4 2.4 0 0 1 12 21m5.9-5.95-.725-.725-.725-.725-3.6-3.6q2.025.2 3.787 1.025C18.4 11.85 18.85 12.3 19.75 13.2zm4-3.95q-1.924-1.924-4.462-3.012C14.9 7 13.933 7 12 7a13 13 0 0 0-2 .15L7.45 4.6q1.1-.3 2.238-.45T12 4q3.55 0 6.625 1.325C21.7 6.65 22.467 7.417 24 8.95z"}))));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/WifiOff.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/X.cjs",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0});const a=o(e("react")),i=(0,e("react").forwardRef)((e,t)=>a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24",fill:"currentColor",ref:t,...e},a.createElement("path",{d:"M20.996 20.8 13.96 10.542l.012.01L20.316 3.2h-2.12l-5.168 5.984L8.924 3.2h-5.56l6.569 9.577-.001-.001L3.004 20.8h2.12l5.746-6.658 4.566 6.658zM8.084 4.8l9.872 14.4h-1.68L6.396 4.8z"})));n.default=i}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/X.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/index.cjs",{"./Accessibility.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Accessibility.cjs","./Activity.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Activity.cjs","./Add.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Add.cjs","./AddCard.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCard.cjs","./AddCircle.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddCircle.cjs","./AddSquare.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AddSquare.cjs","./Ai.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ai.cjs","./AlternateEmail.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AlternateEmail.cjs","./AppleLogo.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AppleLogo.cjs","./Apps.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Apps.cjs","./Arrow2Down.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Down.cjs","./Arrow2Left.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Left.cjs","./Arrow2Right.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Right.cjs","./Arrow2Up.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2Up.cjs","./Arrow2UpRight.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Arrow2UpRight.cjs","./ArrowCircleDown.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleDown.cjs","./ArrowCircleUp.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowCircleUp.cjs","./ArrowDoubleLeft.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleLeft.cjs","./ArrowDoubleRight.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDoubleRight.cjs","./ArrowDown.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDown.cjs","./ArrowDropDownCircle.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowDropDownCircle.cjs","./ArrowLeft.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowLeft.cjs","./ArrowRight.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowRight.cjs","./ArrowUp.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ArrowUp.cjs","./AttachMoney.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/AttachMoney.cjs","./Attachment.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Attachment.cjs","./Backspace.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Backspace.cjs","./Ban.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ban.cjs","./Bank.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bank.cjs","./BankAssured.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/BankAssured.cjs","./Bold.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bold.cjs","./Book.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Book.cjs","./Bookmark.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bookmark.cjs","./Bridge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bridge.cjs","./Briefcase.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Briefcase.cjs","./Bulb.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Bulb.cjs","./BuySell.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/BuySell.cjs","./Cake.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cake.cjs","./Calculator.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calculator.cjs","./Calendar.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Calendar.cjs","./Call.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Call.cjs","./Camera.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Camera.cjs","./Campaign.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Campaign.cjs","./Candlestick.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Candlestick.cjs","./Card.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Card.cjs","./CardPos.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CardPos.cjs","./Cash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cash.cjs","./Category.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Category.cjs","./Chart.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Chart.cjs","./Check.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Check.cjs","./CheckBold.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CheckBold.cjs","./CircleX.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CircleX.cjs","./Clear.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clear.cjs","./Clock.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Clock.cjs","./ClockFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ClockFilled.cjs","./Close.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Close.cjs","./Cloud.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Cloud.cjs","./CloudDownload.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudDownload.cjs","./CloudUpload.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CloudUpload.cjs","./Code.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Code.cjs","./CodeCircle.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CodeCircle.cjs","./Coin.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Coin.cjs","./Collapse.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Collapse.cjs","./Confirmation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Confirmation.cjs","./Connect.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Connect.cjs","./Copy.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Copy.cjs","./CopySuccess.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CopySuccess.cjs","./CreditCheck.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CreditCheck.cjs","./CurrencyFranc.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyFranc.cjs","./CurrencyLira.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyLira.cjs","./CurrencyPound.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyPound.cjs","./CurrencyYuan.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/CurrencyYuan.cjs","./Customize.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Customize.cjs","./Danger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Danger.cjs","./Dark.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Dark.cjs","./DarkFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/DarkFilled.cjs","./Data.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Data.cjs","./Description.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Description.cjs","./Details.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Details.cjs","./Diagram.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Diagram.cjs","./DocumentCode.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/DocumentCode.cjs","./Download.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Download.cjs","./Draft.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Draft.cjs","./EcoLeaf.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EcoLeaf.cjs","./Edit.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Edit.cjs","./EditSquare.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EditSquare.cjs","./EncryptedAdd.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EncryptedAdd.cjs","./Eraser.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eraser.cjs","./Error.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Error.cjs","./Ethereum.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Ethereum.cjs","./Exchange.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Exchange.cjs","./Expand.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Expand.cjs","./ExpandVertical.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExpandVertical.cjs","./Explore.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Explore.cjs","./ExploreFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ExploreFilled.cjs","./Export.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Export.cjs","./Extension.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Extension.cjs","./Eye.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Eye.cjs","./EyeSlash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/EyeSlash.cjs","./FaceId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FaceId.cjs","./Feedback.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Feedback.cjs","./File.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/File.cjs","./Filter.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Filter.cjs","./Fingerprint.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fingerprint.cjs","./Fire.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Fire.cjs","./FirstPage.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FirstPage.cjs","./Flag.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flag.cjs","./Flash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flash.cjs","./FlashSlash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FlashSlash.cjs","./Flask.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flask.cjs","./Flower.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Flower.cjs","./Folder.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Folder.cjs","./Forest.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Forest.cjs","./FullCircle.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/FullCircle.cjs","./Gas.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gas.cjs","./Gift.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Gift.cjs","./Global.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Global.cjs","./GlobalSearch.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/GlobalSearch.cjs","./Graph.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Graph.cjs","./Hardware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hardware.cjs","./HashTag.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/HashTag.cjs","./Heart.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Heart.cjs","./HeartFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/HeartFilled.cjs","./Hierarchy.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Hierarchy.cjs","./Home.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Home.cjs","./HomeFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/HomeFilled.cjs","./Image.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Image.cjs","./Info.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Info.cjs","./Inventory.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Inventory.cjs","./Joystick.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Joystick.cjs","./Keep.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Keep.cjs","./KeepFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/KeepFilled.cjs","./Key.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Key.cjs","./LastPage.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LastPage.cjs","./Light.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Light.cjs","./LightFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LightFilled.cjs","./Link.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Link.cjs","./Loading.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Loading.cjs","./Location.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Location.cjs","./Lock.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Lock.cjs","./LockSlash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockSlash.cjs","./LockedFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/LockedFilled.cjs","./Login.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Login.cjs","./Logout.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Logout.cjs","./Mail.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mail.cjs","./Map.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Map.cjs","./Menu.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Menu.cjs","./MessageQuestion.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MessageQuestion.cjs","./Messages.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Messages.cjs","./MetamaskFoxOutline.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MetamaskFoxOutline.cjs","./Mic.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mic.cjs","./Minus.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Minus.cjs","./MinusBold.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusBold.cjs","./MinusSquare.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MinusSquare.cjs","./Mobile.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Mobile.cjs","./Money.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Money.cjs","./MoneyBag.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoneyBag.cjs","./Monitor.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Monitor.cjs","./MoreHorizontal.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreHorizontal.cjs","./MoreVertical.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MoreVertical.cjs","./MountainFlag.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MountainFlag.cjs","./MusicNote.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/MusicNote.cjs","./Notification.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Notification.cjs","./PageInfo.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PageInfo.cjs","./Palette.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Palette.cjs","./PasswordCheck.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PasswordCheck.cjs","./Pending.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pending.cjs","./People.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/People.cjs","./PersonCancel.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PersonCancel.cjs","./Pin.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Pin.cjs","./Plant.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plant.cjs","./Plug.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Plug.cjs","./PlusAndMinus.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PlusAndMinus.cjs","./PolicyAlert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PolicyAlert.cjs","./Print.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Print.cjs","./PriorityHigh.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PriorityHigh.cjs","./PrivacyTip.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/PrivacyTip.cjs","./ProgrammingArrows.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ProgrammingArrows.cjs","./Publish.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Publish.cjs","./QrCode.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/QrCode.cjs","./Question.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Question.cjs","./Receive.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Receive.cjs","./Received.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Received.cjs","./Refresh.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Refresh.cjs","./RemoveMinus.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/RemoveMinus.cjs","./Report.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Report.cjs","./Rocket.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Rocket.cjs","./Save.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Save.cjs","./SaveFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SaveFilled.cjs","./Saving.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Saving.cjs","./Scan.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Scan.cjs","./ScanBarcode.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanBarcode.cjs","./ScanFocus.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ScanFocus.cjs","./Search.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Search.cjs","./Security.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Security.cjs","./SecurityAlert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityAlert.cjs","./SecurityCross.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityCross.cjs","./SecurityKey.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityKey.cjs","./SecuritySearch.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySearch.cjs","./SecuritySlash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecuritySlash.cjs","./SecurityTick.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTick.cjs","./SecurityTime.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityTime.cjs","./SecurityUser.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SecurityUser.cjs","./Send.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Send.cjs","./SentimentDissatisfied.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentDissatisfied.cjs","./SentimentNeutral.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentNeutral.cjs","./SentimentSatisfied.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentSatisfied.cjs","./SentimentVerySatisfied.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SentimentVerySatisfied.cjs","./Setting.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Setting.cjs","./SettingFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SettingFilled.cjs","./Share.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Share.cjs","./ShieldLock.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShieldLock.cjs","./ShoppingBag.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingBag.cjs","./ShoppingCart.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ShoppingCart.cjs","./SignalCellular.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SignalCellular.cjs","./Slash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Slash.cjs","./Sms.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sms.cjs","./Snaps.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Snaps.cjs","./SnapsMobile.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsMobile.cjs","./SnapsPlus.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsPlus.cjs","./SnapsRound.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SnapsRound.cjs","./Sort.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sort.cjs","./SortByAlpha.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SortByAlpha.cjs","./Sparkle.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Sparkle.cjs","./Speed.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speed.cjs","./Speedometer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Speedometer.cjs","./Square.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Square.cjs","./Stake.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Stake.cjs","./Star.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Star.cjs","./StarFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/StarFilled.cjs","./Start.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Start.cjs","./Storefront.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Storefront.cjs","./Student.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Student.cjs","./SwapHorizontal.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapHorizontal.cjs","./SwapVertical.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/SwapVertical.cjs","./TabClose.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TabClose.cjs","./TableRow.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TableRow.cjs","./Tablet.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tablet.cjs","./Tag.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tag.cjs","./ThumbDown.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDown.cjs","./ThumbDownFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbDownFilled.cjs","./ThumbUp.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUp.cjs","./ThumbUpFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ThumbUpFilled.cjs","./Tint.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tint.cjs","./Tooltip.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Tooltip.cjs","./Translate.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Translate.cjs","./Trash.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Trash.cjs","./TrendDown.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendDown.cjs","./TrendUp.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/TrendUp.cjs","./Undo.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Undo.cjs","./Unfold.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unfold.cjs","./UnlockedFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UnlockedFilled.cjs","./Unpin.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Unpin.cjs","./Upload.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Upload.cjs","./UploadFile.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UploadFile.cjs","./Usb.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Usb.cjs","./User.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/User.cjs","./UserCheck.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCheck.cjs","./UserCircle.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircle.cjs","./UserCircleAdd.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleAdd.cjs","./UserCircleRemove.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/UserCircleRemove.cjs","./Verified.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Verified.cjs","./VerifiedFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/VerifiedFilled.cjs","./Videocam.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Videocam.cjs","./ViewColumn.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewColumn.cjs","./ViewInAr.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/ViewInAr.cjs","./VolumeOff.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeOff.cjs","./VolumeUp.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/VolumeUp.cjs","./Wallet.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wallet.cjs","./WalletFilled.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/WalletFilled.cjs","./Warning.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Warning.cjs","./WebTraffic.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/WebTraffic.cjs","./Widgets.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Widgets.cjs","./Wifi.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/Wifi.cjs","./WifiOff.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/WifiOff.cjs","./X.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/icons/X.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Icons=void 0;const r=s(e("./Accessibility.cjs")),o=s(e("./Activity.cjs")),a=s(e("./Add.cjs")),i=s(e("./AddCard.cjs")),c=s(e("./AddCircle.cjs")),m=s(e("./AddSquare.cjs")),d=s(e("./Ai.cjs")),u=s(e("./AlternateEmail.cjs")),l=s(e("./AppleLogo.cjs")),f=s(e("./Apps.cjs")),h=s(e("./Arrow2Down.cjs")),p=s(e("./Arrow2Left.cjs")),g=s(e("./Arrow2Right.cjs")),k=s(e("./Arrow2Up.cjs")),b=s(e("./Arrow2UpRight.cjs")),y=s(e("./ArrowCircleDown.cjs")),_=s(e("./ArrowCircleUp.cjs")),x=s(e("./ArrowDoubleLeft.cjs")),w=s(e("./ArrowDoubleRight.cjs")),v=s(e("./ArrowDown.cjs")),j=s(e("./ArrowDropDownCircle.cjs")),O=s(e("./ArrowLeft.cjs")),C=s(e("./ArrowRight.cjs")),T=s(e("./ArrowUp.cjs")),A=s(e("./AttachMoney.cjs")),E=s(e("./Attachment.cjs")),P=s(e("./Backspace.cjs")),B=s(e("./Ban.cjs")),S=s(e("./Bank.cjs")),I=s(e("./BankAssured.cjs")),M=s(e("./Bold.cjs")),D=s(e("./Book.cjs")),q=s(e("./Bookmark.cjs")),R=s(e("./Bridge.cjs")),F=s(e("./Briefcase.cjs")),N=s(e("./Bulb.cjs")),L=s(e("./BuySell.cjs")),z=s(e("./Cake.cjs")),H=s(e("./Calculator.cjs")),V=s(e("./Calendar.cjs")),U=s(e("./Call.cjs")),$=s(e("./Camera.cjs")),K=s(e("./Campaign.cjs")),G=s(e("./Candlestick.cjs")),W=s(e("./Card.cjs")),X=s(e("./CardPos.cjs")),Y=s(e("./Cash.cjs")),Q=s(e("./Category.cjs")),J=s(e("./Chart.cjs")),Z=s(e("./Check.cjs")),ee=s(e("./CheckBold.cjs")),te=s(e("./CircleX.cjs")),ne=s(e("./Clear.cjs")),se=s(e("./Clock.cjs")),re=s(e("./ClockFilled.cjs")),oe=s(e("./Close.cjs")),ae=s(e("./Cloud.cjs")),ie=s(e("./CloudDownload.cjs")),ce=s(e("./CloudUpload.cjs")),me=s(e("./Code.cjs")),de=s(e("./CodeCircle.cjs")),ue=s(e("./Coin.cjs")),le=s(e("./Collapse.cjs")),fe=s(e("./Confirmation.cjs")),he=s(e("./Connect.cjs")),pe=s(e("./Copy.cjs")),ge=s(e("./CopySuccess.cjs")),ke=s(e("./CreditCheck.cjs")),be=s(e("./CurrencyFranc.cjs")),ye=s(e("./CurrencyLira.cjs")),_e=s(e("./CurrencyPound.cjs")),xe=s(e("./CurrencyYuan.cjs")),we=s(e("./Customize.cjs")),ve=s(e("./Danger.cjs")),je=s(e("./Dark.cjs")),Oe=s(e("./DarkFilled.cjs")),Ce=s(e("./Data.cjs")),Te=s(e("./Description.cjs")),Ae=s(e("./Details.cjs")),Ee=s(e("./Diagram.cjs")),Pe=s(e("./DocumentCode.cjs")),Be=s(e("./Download.cjs")),Se=s(e("./Draft.cjs")),Ie=s(e("./EcoLeaf.cjs")),Me=s(e("./Edit.cjs")),De=s(e("./EditSquare.cjs")),qe=s(e("./EncryptedAdd.cjs")),Re=s(e("./Eraser.cjs")),Fe=s(e("./Error.cjs")),Ne=s(e("./Ethereum.cjs")),Le=s(e("./Exchange.cjs")),ze=s(e("./Expand.cjs")),He=s(e("./ExpandVertical.cjs")),Ve=s(e("./Explore.cjs")),Ue=s(e("./ExploreFilled.cjs")),$e=s(e("./Export.cjs")),Ke=s(e("./Extension.cjs")),Ge=s(e("./Eye.cjs")),We=s(e("./EyeSlash.cjs")),Xe=s(e("./FaceId.cjs")),Ye=s(e("./Feedback.cjs")),Qe=s(e("./File.cjs")),Je=s(e("./Filter.cjs")),Ze=s(e("./Fingerprint.cjs")),et=s(e("./Fire.cjs")),tt=s(e("./FirstPage.cjs")),nt=s(e("./Flag.cjs")),st=s(e("./Flash.cjs")),rt=s(e("./FlashSlash.cjs")),ot=s(e("./Flask.cjs")),at=s(e("./Flower.cjs")),it=s(e("./Folder.cjs")),ct=s(e("./Forest.cjs")),mt=s(e("./FullCircle.cjs")),dt=s(e("./Gas.cjs")),ut=s(e("./Gift.cjs")),lt=s(e("./Global.cjs")),ft=s(e("./GlobalSearch.cjs")),ht=s(e("./Graph.cjs")),pt=s(e("./Hardware.cjs")),gt=s(e("./HashTag.cjs")),kt=s(e("./Heart.cjs")),bt=s(e("./HeartFilled.cjs")),yt=s(e("./Hierarchy.cjs")),_t=s(e("./Home.cjs")),xt=s(e("./HomeFilled.cjs")),wt=s(e("./Image.cjs")),vt=s(e("./Info.cjs")),jt=s(e("./Inventory.cjs")),Ot=s(e("./Joystick.cjs")),Ct=s(e("./Keep.cjs")),Tt=s(e("./KeepFilled.cjs")),At=s(e("./Key.cjs")),Et=s(e("./LastPage.cjs")),Pt=s(e("./Light.cjs")),Bt=s(e("./LightFilled.cjs")),St=s(e("./Link.cjs")),It=s(e("./Loading.cjs")),Mt=s(e("./Location.cjs")),Dt=s(e("./Lock.cjs")),qt=s(e("./LockSlash.cjs")),Rt=s(e("./LockedFilled.cjs")),Ft=s(e("./Login.cjs")),Nt=s(e("./Logout.cjs")),Lt=s(e("./Mail.cjs")),zt=s(e("./Map.cjs")),Ht=s(e("./Menu.cjs")),Vt=s(e("./MessageQuestion.cjs")),Ut=s(e("./Messages.cjs")),$t=s(e("./MetamaskFoxOutline.cjs")),Kt=s(e("./Mic.cjs")),Gt=s(e("./Minus.cjs")),Wt=s(e("./MinusBold.cjs")),Xt=s(e("./MinusSquare.cjs")),Yt=s(e("./Mobile.cjs")),Qt=s(e("./Money.cjs")),Jt=s(e("./MoneyBag.cjs")),Zt=s(e("./Monitor.cjs")),en=s(e("./MoreHorizontal.cjs")),tn=s(e("./MoreVertical.cjs")),nn=s(e("./MountainFlag.cjs")),sn=s(e("./MusicNote.cjs")),rn=s(e("./Notification.cjs")),on=s(e("./PageInfo.cjs")),an=s(e("./Palette.cjs")),cn=s(e("./PasswordCheck.cjs")),mn=s(e("./Pending.cjs")),dn=s(e("./People.cjs")),un=s(e("./PersonCancel.cjs")),ln=s(e("./Pin.cjs")),fn=s(e("./Plant.cjs")),hn=s(e("./Plug.cjs")),pn=s(e("./PlusAndMinus.cjs")),gn=s(e("./PolicyAlert.cjs")),kn=s(e("./Print.cjs")),bn=s(e("./PriorityHigh.cjs")),yn=s(e("./PrivacyTip.cjs")),_n=s(e("./ProgrammingArrows.cjs")),xn=s(e("./Publish.cjs")),wn=s(e("./QrCode.cjs")),vn=s(e("./Question.cjs")),jn=s(e("./Receive.cjs")),On=s(e("./Received.cjs")),Cn=s(e("./Refresh.cjs")),Tn=s(e("./RemoveMinus.cjs")),An=s(e("./Report.cjs")),En=s(e("./Rocket.cjs")),Pn=s(e("./Save.cjs")),Bn=s(e("./SaveFilled.cjs")),Sn=s(e("./Saving.cjs")),In=s(e("./Scan.cjs")),Mn=s(e("./ScanBarcode.cjs")),Dn=s(e("./ScanFocus.cjs")),qn=s(e("./Search.cjs")),Rn=s(e("./Security.cjs")),Fn=s(e("./SecurityAlert.cjs")),Nn=s(e("./SecurityCross.cjs")),Ln=s(e("./SecurityKey.cjs")),zn=s(e("./SecuritySearch.cjs")),Hn=s(e("./SecuritySlash.cjs")),Vn=s(e("./SecurityTick.cjs")),Un=s(e("./SecurityTime.cjs")),$n=s(e("./SecurityUser.cjs")),Kn=s(e("./Send.cjs")),Gn=s(e("./SentimentDissatisfied.cjs")),Wn=s(e("./SentimentNeutral.cjs")),Xn=s(e("./SentimentSatisfied.cjs")),Yn=s(e("./SentimentVerySatisfied.cjs")),Qn=s(e("./Setting.cjs")),Jn=s(e("./SettingFilled.cjs")),Zn=s(e("./Share.cjs")),es=s(e("./ShieldLock.cjs")),ts=s(e("./ShoppingBag.cjs")),ns=s(e("./ShoppingCart.cjs")),ss=s(e("./SignalCellular.cjs")),rs=s(e("./Slash.cjs")),os=s(e("./Sms.cjs")),as=s(e("./Snaps.cjs")),is=s(e("./SnapsMobile.cjs")),cs=s(e("./SnapsPlus.cjs")),ms=s(e("./SnapsRound.cjs")),ds=s(e("./Sort.cjs")),us=s(e("./SortByAlpha.cjs")),ls=s(e("./Sparkle.cjs")),fs=s(e("./Speed.cjs")),hs=s(e("./Speedometer.cjs")),ps=s(e("./Square.cjs")),gs=s(e("./Stake.cjs")),ks=s(e("./Star.cjs")),bs=s(e("./StarFilled.cjs")),ys=s(e("./Start.cjs")),_s=s(e("./Storefront.cjs")),xs=s(e("./Student.cjs")),ws=s(e("./SwapHorizontal.cjs")),vs=s(e("./SwapVertical.cjs")),js=s(e("./TabClose.cjs")),Os=s(e("./TableRow.cjs")),Cs=s(e("./Tablet.cjs")),Ts=s(e("./Tag.cjs")),As=s(e("./ThumbDown.cjs")),Es=s(e("./ThumbDownFilled.cjs")),Ps=s(e("./ThumbUp.cjs")),Bs=s(e("./ThumbUpFilled.cjs")),Ss=s(e("./Tint.cjs")),Is=s(e("./Tooltip.cjs")),Ms=s(e("./Translate.cjs")),Ds=s(e("./Trash.cjs")),qs=s(e("./TrendDown.cjs")),Rs=s(e("./TrendUp.cjs")),Fs=s(e("./Undo.cjs")),Ns=s(e("./Unfold.cjs")),Ls=s(e("./UnlockedFilled.cjs")),zs=s(e("./Unpin.cjs")),Hs=s(e("./Upload.cjs")),Vs=s(e("./UploadFile.cjs")),Us=s(e("./Usb.cjs")),$s=s(e("./User.cjs")),Ks=s(e("./UserCheck.cjs")),Gs=s(e("./UserCircle.cjs")),Ws=s(e("./UserCircleAdd.cjs")),Xs=s(e("./UserCircleRemove.cjs")),Ys=s(e("./Verified.cjs")),Qs=s(e("./VerifiedFilled.cjs")),Js=s(e("./Videocam.cjs")),Zs=s(e("./ViewColumn.cjs")),er=s(e("./ViewInAr.cjs")),tr=s(e("./VolumeOff.cjs")),nr=s(e("./VolumeUp.cjs")),sr=s(e("./Wallet.cjs")),rr=s(e("./WalletFilled.cjs")),or=s(e("./Warning.cjs")),ar=s(e("./WebTraffic.cjs")),ir=s(e("./Widgets.cjs")),cr=s(e("./Wifi.cjs")),mr=s(e("./WifiOff.cjs")),dr=s(e("./X.cjs"));n.Icons={Accessibility:r.default,Activity:o.default,Add:a.default,AddCard:i.default,AddCircle:c.default,AddSquare:m.default,Ai:d.default,AlternateEmail:u.default,AppleLogo:l.default,Apps:f.default,Arrow2Down:h.default,Arrow2Left:p.default,Arrow2Right:g.default,Arrow2Up:k.default,Arrow2UpRight:b.default,ArrowCircleDown:y.default,ArrowCircleUp:_.default,ArrowDoubleLeft:x.default,ArrowDoubleRight:w.default,ArrowDown:v.default,ArrowDropDownCircle:j.default,ArrowLeft:O.default,ArrowRight:C.default,ArrowUp:T.default,AttachMoney:A.default,Attachment:E.default,Backspace:P.default,Ban:B.default,Bank:S.default,BankAssured:I.default,Bold:M.default,Book:D.default,Bookmark:q.default,Bridge:R.default,Briefcase:F.default,Bulb:N.default,BuySell:L.default,Cake:z.default,Calculator:H.default,Calendar:V.default,Call:U.default,Camera:$.default,Campaign:K.default,Candlestick:G.default,Card:W.default,CardPos:X.default,Cash:Y.default,Category:Q.default,Chart:J.default,Check:Z.default,CheckBold:ee.default,CircleX:te.default,Clear:ne.default,Clock:se.default,ClockFilled:re.default,Close:oe.default,Cloud:ae.default,CloudDownload:ie.default,CloudUpload:ce.default,Code:me.default,CodeCircle:de.default,Coin:ue.default,Collapse:le.default,Confirmation:fe.default,Connect:he.default,Copy:pe.default,CopySuccess:ge.default,CreditCheck:ke.default,CurrencyFranc:be.default,CurrencyLira:ye.default,CurrencyPound:_e.default,CurrencyYuan:xe.default,Customize:we.default,Danger:ve.default,Dark:je.default,DarkFilled:Oe.default,Data:Ce.default,Description:Te.default,Details:Ae.default,Diagram:Ee.default,DocumentCode:Pe.default,Download:Be.default,Draft:Se.default,EcoLeaf:Ie.default,Edit:Me.default,EditSquare:De.default,EncryptedAdd:qe.default,Eraser:Re.default,Error:Fe.default,Ethereum:Ne.default,Exchange:Le.default,Expand:ze.default,ExpandVertical:He.default,Explore:Ve.default,ExploreFilled:Ue.default,Export:$e.default,Extension:Ke.default,Eye:Ge.default,EyeSlash:We.default,FaceId:Xe.default,Feedback:Ye.default,File:Qe.default,Filter:Je.default,Fingerprint:Ze.default,Fire:et.default,FirstPage:tt.default,Flag:nt.default,Flash:st.default,FlashSlash:rt.default,Flask:ot.default,Flower:at.default,Folder:it.default,Forest:ct.default,FullCircle:mt.default,Gas:dt.default,Gift:ut.default,Global:lt.default,GlobalSearch:ft.default,Graph:ht.default,Hardware:pt.default,HashTag:gt.default,Heart:kt.default,HeartFilled:bt.default,Hierarchy:yt.default,Home:_t.default,HomeFilled:xt.default,Image:wt.default,Info:vt.default,Inventory:jt.default,Joystick:Ot.default,Keep:Ct.default,KeepFilled:Tt.default,Key:At.default,LastPage:Et.default,Light:Pt.default,LightFilled:Bt.default,Link:St.default,Loading:It.default,Location:Mt.default,Lock:Dt.default,LockSlash:qt.default,LockedFilled:Rt.default,Login:Ft.default,Logout:Nt.default,Mail:Lt.default,Map:zt.default,Menu:Ht.default,MessageQuestion:Vt.default,Messages:Ut.default,MetamaskFoxOutline:$t.default,Mic:Kt.default,Minus:Gt.default,MinusBold:Wt.default,MinusSquare:Xt.default,Mobile:Yt.default,Money:Qt.default,MoneyBag:Jt.default,Monitor:Zt.default,MoreHorizontal:en.default,MoreVertical:tn.default,MountainFlag:nn.default,MusicNote:sn.default,Notification:rn.default,PageInfo:on.default,Palette:an.default,PasswordCheck:cn.default,Pending:mn.default,People:dn.default,PersonCancel:un.default,Pin:ln.default,Plant:fn.default,Plug:hn.default,PlusAndMinus:pn.default,PolicyAlert:gn.default,Print:kn.default,PriorityHigh:bn.default,PrivacyTip:yn.default,ProgrammingArrows:_n.default,Publish:xn.default,QrCode:wn.default,Question:vn.default,Receive:jn.default,Received:On.default,Refresh:Cn.default,RemoveMinus:Tn.default,Report:An.default,Rocket:En.default,Save:Pn.default,SaveFilled:Bn.default,Saving:Sn.default,Scan:In.default,ScanBarcode:Mn.default,ScanFocus:Dn.default,Search:qn.default,Security:Rn.default,SecurityAlert:Fn.default,SecurityCross:Nn.default,SecurityKey:Ln.default,SecuritySearch:zn.default,SecuritySlash:Hn.default,SecurityTick:Vn.default,SecurityTime:Un.default,SecurityUser:$n.default,Send:Kn.default,SentimentDissatisfied:Gn.default,SentimentNeutral:Wn.default,SentimentSatisfied:Xn.default,SentimentVerySatisfied:Yn.default,Setting:Qn.default,SettingFilled:Jn.default,Share:Zn.default,ShieldLock:es.default,ShoppingBag:ts.default,ShoppingCart:ns.default,SignalCellular:ss.default,Slash:rs.default,Sms:os.default,Snaps:as.default,SnapsMobile:is.default,SnapsPlus:cs.default,SnapsRound:ms.default,Sort:ds.default,SortByAlpha:us.default,Sparkle:ls.default,Speed:fs.default,Speedometer:hs.default,Square:ps.default,Stake:gs.default,Star:ks.default,StarFilled:bs.default,Start:ys.default,Storefront:_s.default,Student:xs.default,SwapHorizontal:ws.default,SwapVertical:vs.default,TabClose:js.default,TableRow:Os.default,Tablet:Cs.default,Tag:Ts.default,ThumbDown:As.default,ThumbDownFilled:Es.default,ThumbUp:Ps.default,ThumbUpFilled:Bs.default,Tint:Ss.default,Tooltip:Is.default,Translate:Ms.default,Trash:Ds.default,TrendDown:qs.default,TrendUp:Rs.default,Undo:Fs.default,Unfold:Ns.default,UnlockedFilled:Ls.default,Unpin:zs.default,Upload:Hs.default,UploadFile:Vs.default,Usb:Us.default,User:$s.default,UserCheck:Ks.default,UserCircle:Gs.default,UserCircleAdd:Ws.default,UserCircleRemove:Xs.default,Verified:Ys.default,VerifiedFilled:Qs.default,Videocam:Js.default,ViewColumn:Zs.default,ViewInAr:er.default,VolumeOff:tr.default,VolumeUp:nr.default,Wallet:sr.default,WalletFilled:rr.default,Warning:or.default,WebTraffic:ar.default,Widgets:ir.default,Wifi:cr.default,WifiOff:mr.default,X:dr.default}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/icons/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./Icon.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/Icon.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Icon=n.IconColor=n.IconSize=n.IconName=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"IconName",{enumerable:!0,get:function(){return s.IconName}}),Object.defineProperty(n,"IconSize",{enumerable:!0,get:function(){return s.IconSize}}),Object.defineProperty(n,"IconColor",{enumerable:!0,get:function(){return s.IconColor}});var r=e("./Icon.cjs");Object.defineProperty(n,"Icon",{enumerable:!0,get:function(){return r.Icon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/Text.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","./Text.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/Text.constants.cjs","@radix-ui/react-slot":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-slot/dist/index.js",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Text=void 0;const r=e("@radix-ui/react-slot"),o=s(e("react")),a=e("../../types/index.cjs"),i=e("../../utils/tw-merge.cjs"),c=e("./Text.constants.cjs");n.Text=({variant:e=a.TextVariant.BodyMd,children:t,className:n,fontWeight:s,fontFamily:m=a.FontFamily.Default,fontStyle:d,textTransform:u,textAlign:l,overflowWrap:f,ellipsis:h,asChild:p,color:g=a.TextColor.TextDefault,style:k,...b})=>{const y=p?r.Slot:c.MAP_TEXT_VARIANT_TAG[e],_=`${(0,i.twMerge)(g,c.CLASSMAP_TEXT_VARIANT_FONTSTYLE[e],s||c.CLASSMAP_TEXT_VARIANT_FONTWEIGHT[e],d,m,u,l,f,h&&"truncate",n)}`;return o.default.createElement(y,{className:_,style:k,...b},t)}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Text/Text.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/Text.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAP_TEXT_VARIANT_TAG=n.CLASSMAP_TEXT_VARIANT_FONTWEIGHT=n.CLASSMAP_TEXT_VARIANT_FONTSTYLE=void 0;const s=e("../../types/index.cjs");n.CLASSMAP_TEXT_VARIANT_FONTSTYLE={[s.TextVariant.DisplayLg]:"text-s-display-lg leading-s-display-lg tracking-s-display-lg md:text-l-display-lg md:leading-l-display-lg md:tracking-l-display-lg",[s.TextVariant.DisplayMd]:"text-s-display-md leading-s-display-md tracking-s-display-md md:text-l-display-md md:leading-l-display-md md:tracking-l-display-md",[s.TextVariant.HeadingLg]:"text-s-heading-lg leading-s-heading-lg tracking-s-heading-lg md:text-l-heading-lg md:leading-l-heading-lg md:tracking-l-heading-lg",[s.TextVariant.HeadingMd]:"text-s-heading-md leading-s-heading-md tracking-s-heading-md md:text-l-heading-md md:leading-l-heading-md md:tracking-l-heading-md",[s.TextVariant.HeadingSm]:"text-s-heading-sm leading-s-heading-sm tracking-s-heading-sm md:text-l-heading-sm md:leading-l-heading-sm md:tracking-l-heading-sm",[s.TextVariant.BodyLg]:"text-s-body-lg leading-s-body-lg tracking-s-body-lg md:text-l-body-lg md:leading-l-body-lg md:tracking-l-body-lg",[s.TextVariant.BodyMd]:"text-s-body-md leading-s-body-md tracking-s-body-md md:text-l-body-md md:leading-l-body-md md:tracking-l-body-md",[s.TextVariant.BodySm]:"text-s-body-sm leading-s-body-sm tracking-s-body-sm md:text-l-body-sm md:leading-l-body-sm md:tracking-l-body-sm",[s.TextVariant.BodyXs]:"text-s-body-xs leading-s-body-xs tracking-s-body-xs md:text-l-body-xs md:leading-l-body-xs md:tracking-l-body-xs",[s.TextVariant.PageHeading]:"text-s-page-heading leading-s-page-heading tracking-s-page-heading md:text-l-page-heading md:leading-l-page-heading md:tracking-l-page-heading",[s.TextVariant.SectionHeading]:"text-s-section-heading leading-s-section-heading tracking-s-section-heading md:text-l-section-heading md:leading-l-section-heading md:tracking-l-section-heading",[s.TextVariant.ButtonLabelMd]:"text-s-button-label-md leading-s-button-label-md tracking-s-button-label-md md:text-l-button-label-md md:leading-l-button-label-md md:tracking-l-button-label-md",[s.TextVariant.ButtonLabelLg]:"text-s-button-label-lg leading-s-button-label-lg tracking-s-button-label-lg md:text-l-button-label-lg md:leading-l-button-label-lg md:tracking-l-button-label-lg",[s.TextVariant.AmountDisplayLg]:"text-s-amount-display-lg leading-s-amount-display-lg tracking-s-amount-display-lg md:text-l-amount-display-lg md:leading-l-amount-display-lg md:tracking-l-amount-display-lg"},n.CLASSMAP_TEXT_VARIANT_FONTWEIGHT={[s.TextVariant.DisplayLg]:"font-bold md:font-medium",[s.TextVariant.DisplayMd]:"font-bold md:font-medium",[s.TextVariant.HeadingLg]:"font-bold",[s.TextVariant.HeadingMd]:"font-bold",[s.TextVariant.HeadingSm]:"font-bold",[s.TextVariant.BodyLg]:"font-medium",[s.TextVariant.BodyMd]:"font-regular",[s.TextVariant.BodySm]:"font-regular",[s.TextVariant.BodyXs]:"font-regular",[s.TextVariant.PageHeading]:"font-bold",[s.TextVariant.SectionHeading]:"font-bold",[s.TextVariant.ButtonLabelMd]:"font-medium",[s.TextVariant.ButtonLabelLg]:"font-medium",[s.TextVariant.AmountDisplayLg]:"font-bold md:font-medium"},n.MAP_TEXT_VARIANT_TAG={[s.TextVariant.DisplayLg]:"h1",[s.TextVariant.DisplayMd]:"h1",[s.TextVariant.HeadingLg]:"h2",[s.TextVariant.HeadingMd]:"h3",[s.TextVariant.HeadingSm]:"h4",[s.TextVariant.BodyLg]:"p",[s.TextVariant.BodyMd]:"p",[s.TextVariant.BodySm]:"p",[s.TextVariant.BodyXs]:"p",[s.TextVariant.PageHeading]:"h1",[s.TextVariant.SectionHeading]:"h2",[s.TextVariant.ButtonLabelMd]:"span",[s.TextVariant.ButtonLabelLg]:"span",[s.TextVariant.AmountDisplayLg]:"span"}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Text/Text.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./Text.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/Text.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Text=n.TextColor=n.TextTransform=n.TextVariant=n.TextAlign=n.OverflowWrap=n.FontWeight=n.FontStyle=n.FontFamily=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"FontFamily",{enumerable:!0,get:function(){return s.FontFamily}}),Object.defineProperty(n,"FontStyle",{enumerable:!0,get:function(){return s.FontStyle}}),Object.defineProperty(n,"FontWeight",{enumerable:!0,get:function(){return s.FontWeight}}),Object.defineProperty(n,"OverflowWrap",{enumerable:!0,get:function(){return s.OverflowWrap}}),Object.defineProperty(n,"TextAlign",{enumerable:!0,get:function(){return s.TextAlign}}),Object.defineProperty(n,"TextVariant",{enumerable:!0,get:function(){return s.TextVariant}}),Object.defineProperty(n,"TextTransform",{enumerable:!0,get:function(){return s.TextTransform}}),Object.defineProperty(n,"TextColor",{enumerable:!0,get:function(){return s.TextColor}});var r=e("./Text.cjs");Object.defineProperty(n,"Text",{enumerable:!0,get:function(){return r.Text}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/Text/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","../ButtonBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs","./TextButton.constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.constants.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.TextButton=void 0;const a=o(e("react")),i=e("../../types/index.cjs"),c=e("../../utils/tw-merge.cjs"),m=e("../ButtonBase/index.cjs"),d=e("./TextButton.constants.cjs");n.TextButton=(0,a.forwardRef)(({className:e,isInverse:t,isDisabled:n,size:s=i.TextButtonSize.BodyMd,textProps:r,...o},u)=>{const l=(0,c.twMerge)("h-auto rounded-none bg-transparent px-0","transform-none transition-none active:scale-100",!t&&"text-primary-default",t&&"text-primary-inverse",!n&&[!t&&["hover:bg-hover hover:text-primary-default-hover hover:underline hover:decoration-primary-default-hover hover:decoration-2 hover:underline-offset-4","active:bg-pressed active:text-primary-default-pressed active:decoration-primary-default-pressed"],t&&["hover:bg-hover hover:text-primary-inverse hover:underline hover:decoration-primary-inverse hover:decoration-2 hover:underline-offset-4","active:bg-pressed active:text-primary-inverse active:decoration-primary-inverse"]],n&&["opacity-50","cursor-not-allowed"],e);return a.default.createElement(m.ButtonBase,{ref:u,className:l,isDisabled:n,textProps:{variant:d.MAP_TEXTBUTTON_SIZE_TEXTVARIANT[s],...r},...o})}),n.TextButton.displayName="TextButton"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.constants.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","../Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAP_TEXTBUTTON_SIZE_TEXTVARIANT=void 0;const s=e("../../types/index.cjs"),r=e("../Text/index.cjs");n.MAP_TEXTBUTTON_SIZE_TEXTVARIANT={[s.TextButtonSize.BodyXs]:r.TextVariant.BodyXs,[s.TextButtonSize.BodySm]:r.TextVariant.BodySm,[s.TextButtonSize.BodyMd]:r.TextVariant.BodyMd,[s.TextButtonSize.BodyLg]:r.TextVariant.BodyLg}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/TextButton/index.cjs",{"../../types/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs","./TextButton.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/TextButton/TextButton.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TextButton=n.TextButtonSize=void 0;var s=e("../../types/index.cjs");Object.defineProperty(n,"TextButtonSize",{enumerable:!0,get:function(){return s.TextButtonSize}});var r=e("./TextButton.cjs");Object.defineProperty(n,"TextButton",{enumerable:!0,get:function(){return r.TextButton}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/TextButton/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/index.cjs",{"./AvatarAccount/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarAccount/index.cjs","./AvatarBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarBase/index.cjs","./AvatarFavicon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarFavicon/index.cjs","./AvatarGroup/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarGroup/index.cjs","./AvatarIcon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarIcon/index.cjs","./AvatarNetwork/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarNetwork/index.cjs","./AvatarToken/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/AvatarToken/index.cjs","./BadgeCount/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeCount/index.cjs","./BadgeIcon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeIcon/index.cjs","./BadgeNetwork/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeNetwork/index.cjs","./BadgeStatus/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeStatus/index.cjs","./BadgeWrapper/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/BadgeWrapper/index.cjs","./Box/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Box/index.cjs","./Button/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Button/index.cjs","./ButtonBase/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonBase/index.cjs","./ButtonIcon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/ButtonIcon/index.cjs","./Checkbox/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Checkbox/index.cjs","./Icon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Icon/index.cjs","./Text/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/Text/index.cjs","./TextButton/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/TextButton/index.cjs","./temp-components/Blockies/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/index.cjs","./temp-components/Jazzicon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/index.cjs","./temp-components/Maskicon/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Maskicon=n.Jazzicon=n.IconColor=n.IconSize=n.IconName=n.Icon=n.Checkbox=n.ButtonIconSize=n.ButtonIcon=n.ButtonBaseSize=n.ButtonBase=n.ButtonVariant=n.ButtonSize=n.Button=n.Box=n.BoxBorderColor=n.BoxBackgroundColor=n.BoxJustifyContent=n.BoxAlignItems=n.BoxFlexWrap=n.BoxFlexDirection=n.Blockies=n.BadgeWrapperPositionAnchorShape=n.BadgeWrapperPosition=n.BadgeWrapper=n.BadgeStatusSize=n.BadgeStatusStatus=n.BadgeStatus=n.BadgeNetwork=n.BadgeIcon=n.BadgeCountSize=n.BadgeCount=n.AvatarTokenSize=n.AvatarToken=n.AvatarNetworkSize=n.AvatarNetwork=n.AvatarIconSeverity=n.AvatarIconSize=n.AvatarIcon=n.AvatarGroupVariant=n.AvatarGroupSize=n.AvatarGroup=n.AvatarFaviconSize=n.AvatarFavicon=n.AvatarBaseShape=n.AvatarBaseSize=n.AvatarBase=n.AvatarAccountVariant=n.AvatarAccountSize=n.AvatarAccount=void 0,n.TextButtonSize=n.TextButton=n.OverflowWrap=n.TextTransform=n.FontStyle=n.FontFamily=n.FontWeight=n.TextAlign=n.TextColor=n.TextVariant=n.Text=void 0;var s=e("./AvatarAccount/index.cjs");Object.defineProperty(n,"AvatarAccount",{enumerable:!0,get:function(){return s.AvatarAccount}}),Object.defineProperty(n,"AvatarAccountSize",{enumerable:!0,get:function(){return s.AvatarAccountSize}}),Object.defineProperty(n,"AvatarAccountVariant",{enumerable:!0,get:function(){return s.AvatarAccountVariant}});var r=e("./AvatarBase/index.cjs");Object.defineProperty(n,"AvatarBase",{enumerable:!0,get:function(){return r.AvatarBase}}),Object.defineProperty(n,"AvatarBaseSize",{enumerable:!0,get:function(){return r.AvatarBaseSize}}),Object.defineProperty(n,"AvatarBaseShape",{enumerable:!0,get:function(){return r.AvatarBaseShape}});var o=e("./AvatarFavicon/index.cjs");Object.defineProperty(n,"AvatarFavicon",{enumerable:!0,get:function(){return o.AvatarFavicon}}),Object.defineProperty(n,"AvatarFaviconSize",{enumerable:!0,get:function(){return o.AvatarFaviconSize}});var a=e("./AvatarGroup/index.cjs");Object.defineProperty(n,"AvatarGroup",{enumerable:!0,get:function(){return a.AvatarGroup}}),Object.defineProperty(n,"AvatarGroupSize",{enumerable:!0,get:function(){return a.AvatarGroupSize}}),Object.defineProperty(n,"AvatarGroupVariant",{enumerable:!0,get:function(){return a.AvatarGroupVariant}});var i=e("./AvatarIcon/index.cjs");Object.defineProperty(n,"AvatarIcon",{enumerable:!0,get:function(){return i.AvatarIcon}}),Object.defineProperty(n,"AvatarIconSize",{enumerable:!0,get:function(){return i.AvatarIconSize}}),Object.defineProperty(n,"AvatarIconSeverity",{enumerable:!0,get:function(){return i.AvatarIconSeverity}});var c=e("./AvatarNetwork/index.cjs");Object.defineProperty(n,"AvatarNetwork",{enumerable:!0,get:function(){return c.AvatarNetwork}}),Object.defineProperty(n,"AvatarNetworkSize",{enumerable:!0,get:function(){return c.AvatarNetworkSize}});var m=e("./AvatarToken/index.cjs");Object.defineProperty(n,"AvatarToken",{enumerable:!0,get:function(){return m.AvatarToken}}),Object.defineProperty(n,"AvatarTokenSize",{enumerable:!0,get:function(){return m.AvatarTokenSize}});var d=e("./BadgeCount/index.cjs");Object.defineProperty(n,"BadgeCount",{enumerable:!0,get:function(){return d.BadgeCount}});var u=e("./BadgeCount/index.cjs");Object.defineProperty(n,"BadgeCountSize",{enumerable:!0,get:function(){return u.BadgeCountSize}});var l=e("./BadgeIcon/index.cjs");Object.defineProperty(n,"BadgeIcon",{enumerable:!0,get:function(){return l.BadgeIcon}});var f=e("./BadgeNetwork/index.cjs");Object.defineProperty(n,"BadgeNetwork",{enumerable:!0,get:function(){return f.BadgeNetwork}});var h=e("./BadgeStatus/index.cjs");Object.defineProperty(n,"BadgeStatus",{enumerable:!0,get:function(){return h.BadgeStatus}});var p=e("./BadgeStatus/index.cjs");Object.defineProperty(n,"BadgeStatusStatus",{enumerable:!0,get:function(){return p.BadgeStatusStatus}}),Object.defineProperty(n,"BadgeStatusSize",{enumerable:!0,get:function(){return p.BadgeStatusSize}});var g=e("./BadgeWrapper/index.cjs");Object.defineProperty(n,"BadgeWrapper",{enumerable:!0,get:function(){return g.BadgeWrapper}});var k=e("./BadgeWrapper/index.cjs");Object.defineProperty(n,"BadgeWrapperPosition",{enumerable:!0,get:function(){return k.BadgeWrapperPosition}}),Object.defineProperty(n,"BadgeWrapperPositionAnchorShape",{enumerable:!0,get:function(){return k.BadgeWrapperPositionAnchorShape}});var b=e("./temp-components/Blockies/index.cjs");Object.defineProperty(n,"Blockies",{enumerable:!0,get:function(){return b.Blockies}});var y=e("./Box/index.cjs");Object.defineProperty(n,"BoxFlexDirection",{enumerable:!0,get:function(){return y.BoxFlexDirection}}),Object.defineProperty(n,"BoxFlexWrap",{enumerable:!0,get:function(){return y.BoxFlexWrap}}),Object.defineProperty(n,"BoxAlignItems",{enumerable:!0,get:function(){return y.BoxAlignItems}}),Object.defineProperty(n,"BoxJustifyContent",{enumerable:!0,get:function(){return y.BoxJustifyContent}}),Object.defineProperty(n,"BoxBackgroundColor",{enumerable:!0,get:function(){return y.BoxBackgroundColor}}),Object.defineProperty(n,"BoxBorderColor",{enumerable:!0,get:function(){return y.BoxBorderColor}}),Object.defineProperty(n,"Box",{enumerable:!0,get:function(){return y.Box}});var _=e("./Button/index.cjs");Object.defineProperty(n,"Button",{enumerable:!0,get:function(){return _.Button}}),Object.defineProperty(n,"ButtonSize",{enumerable:!0,get:function(){return _.ButtonSize}}),Object.defineProperty(n,"ButtonVariant",{enumerable:!0,get:function(){return _.ButtonVariant}});var x=e("./ButtonBase/index.cjs");Object.defineProperty(n,"ButtonBase",{enumerable:!0,get:function(){return x.ButtonBase}});var w=e("./ButtonBase/index.cjs");Object.defineProperty(n,"ButtonBaseSize",{enumerable:!0,get:function(){return w.ButtonBaseSize}});var v=e("./ButtonIcon/index.cjs");Object.defineProperty(n,"ButtonIcon",{enumerable:!0,get:function(){return v.ButtonIcon}}),Object.defineProperty(n,"ButtonIconSize",{enumerable:!0,get:function(){return v.ButtonIconSize}});var j=e("./Checkbox/index.cjs");Object.defineProperty(n,"Checkbox",{enumerable:!0,get:function(){return j.Checkbox}});var O=e("./Icon/index.cjs");Object.defineProperty(n,"Icon",{enumerable:!0,get:function(){return O.Icon}});var C=e("./Icon/index.cjs");Object.defineProperty(n,"IconName",{enumerable:!0,get:function(){return C.IconName}}),Object.defineProperty(n,"IconSize",{enumerable:!0,get:function(){return C.IconSize}}),Object.defineProperty(n,"IconColor",{enumerable:!0,get:function(){return C.IconColor}});var T=e("./temp-components/Jazzicon/index.cjs");Object.defineProperty(n,"Jazzicon",{enumerable:!0,get:function(){return T.Jazzicon}});var A=e("./temp-components/Maskicon/index.cjs");Object.defineProperty(n,"Maskicon",{enumerable:!0,get:function(){return A.Maskicon}});var E=e("./Text/index.cjs");Object.defineProperty(n,"Text",{enumerable:!0,get:function(){return E.Text}});var P=e("./Text/index.cjs");Object.defineProperty(n,"TextVariant",{enumerable:!0,get:function(){return P.TextVariant}}),Object.defineProperty(n,"TextColor",{enumerable:!0,get:function(){return P.TextColor}}),Object.defineProperty(n,"TextAlign",{enumerable:!0,get:function(){return P.TextAlign}}),Object.defineProperty(n,"FontWeight",{enumerable:!0,get:function(){return P.FontWeight}}),Object.defineProperty(n,"FontFamily",{enumerable:!0,get:function(){return P.FontFamily}}),Object.defineProperty(n,"FontStyle",{enumerable:!0,get:function(){return P.FontStyle}}),Object.defineProperty(n,"TextTransform",{enumerable:!0,get:function(){return P.TextTransform}}),Object.defineProperty(n,"OverflowWrap",{enumerable:!0,get:function(){return P.OverflowWrap}});var B=e("./TextButton/index.cjs");Object.defineProperty(n,"TextButton",{enumerable:!0,get:function(){return B.TextButton}}),Object.defineProperty(n,"TextButtonSize",{enumerable:!0,get:function(){return B.TextButtonSize}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/Blockies.cjs",{"@metamask/design-system-shared":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-shared/dist/index.cjs",blo:"/home/runner/work/metamask-extension/metamask-extension/node_modules/blo/dist/cjs/index.js",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Blockies=void 0;const r=e("@metamask/design-system-shared"),o=e("blo"),a=s(e("react"));n.Blockies=({address:e,size:t=32,...n})=>{const s=(0,r.extractAccountAddress)(e);return a.default.createElement("img",{src:(0,o.blo)(s),height:t,width:t,alt:`Blockies for ${e}`,...n})},n.Blockies.displayName="Blockies"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/Blockies.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/index.cjs",{"./Blockies.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/Blockies.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Blockies=void 0;var s=e("./Blockies.cjs");Object.defineProperty(n,"Blockies",{enumerable:!0,get:function(){return s.Blockies}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Blockies/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/Jazzicon.cjs",{"../../../utils/tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs","@metamask/design-system-shared":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-shared/dist/index.cjs","@metamask/jazzicon":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/index.js",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t},a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Jazzicon=void 0;const i=e("@metamask/design-system-shared"),c=a(e("@metamask/jazzicon")),m=o(e("react")),d=e("../../../utils/tw-merge.cjs"),u={};n.Jazzicon=({address:e,size:t=32,className:n,...s})=>{const r=(0,m.useRef)(null);return(0,m.useEffect)(()=>{if(!r.current)return()=>{};for(;r.current.firstChild;)r.current.removeChild(r.current.firstChild);const n=`${e.toLowerCase()}:${t}`;if(u[n]){const e=u[n].cloneNode(!0);return r.current.appendChild(e),()=>{if(r.current)for(;r.current.firstChild;)r.current.removeChild(r.current.firstChild)}}const s=(0,i.extractAccountAddress)(e),o=(0,i.generateIconSeed)(s),a=(0,c.default)(t,o);return u[n]=a,r.current&&r.current.appendChild(a.cloneNode(!0)),()=>{if(r.current)for(;r.current.firstChild;)r.current.removeChild(r.current.firstChild)}},[e,t]),m.default.createElement("div",{ref:r,className:(0,d.twMerge)("flex [&>div]:!rounded-none",n),...s})},n.Jazzicon.displayName="Jazzicon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/Jazzicon.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/index.cjs",{"./Jazzicon.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/Jazzicon.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Jazzicon=void 0;var s=e("./Jazzicon.cjs");Object.defineProperty(n,"Jazzicon",{enumerable:!0,get:function(){return s.Jazzicon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Jazzicon/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.cjs",{"./Maskicon.utilities.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.utilities.cjs",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.Maskicon=void 0;const a=o(e("react")),i=e("./Maskicon.utilities.cjs");n.Maskicon=({address:e,size:t=32,className:n,...s})=>{const[r,o]=(0,a.useState)("");(0,a.useEffect)(()=>{let n=!1;return(async()=>{const s=await(0,i.getMaskiconSVG)(e,t);n||o(s)})(),()=>{n=!0}},[e,t]);const c=(0,a.useMemo)(()=>{if(!r)return"";const e=r.replace(/\s+/gu," ").trim();return`data:image/svg+xml,${encodeURIComponent(e)}`},[r]);return c?a.default.createElement("img",{alt:"maskicon",width:t,height:t,className:n,src:c,...s}):a.default.createElement("img",{alt:"maskicon",width:t,height:t,className:n,src:"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg'/%3E",...s})},n.Maskicon.displayName="Maskicon"}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.utilities.cjs",{"@metamask/design-system-shared":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-shared/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getMaskiconSVG=n.createMaskiconSVG=n.seedToString=n.sdbmHash=void 0;const s=e("@metamask/design-system-shared"),r=[["#FF5C16","#FCFCFC"],["#FF5C16","#131416"],["#D075FF","#FCFCFC"],["#D075FF","#131416"],["#BAF24A","#FCFCFC"],["#BAF24A","#131416"],["#89B0FF","#FCFCFC"],["#89B0FF","#131416"],["#FCFCFC","#FF5C16"],["#131416","#FF5C16"],["#FCFCFC","#D075FF"],["#131416","#D075FF"],["#FCFCFC","#BAF24A"],["#131416","#BAF24A"],["#FCFCFC","#89B0FF"],["#131416","#89B0FF"]].concat([["#FFA680","#FF5C16"],["#661800","#FF5C16"],["#EAC2FF","#D075FF"],["#3D065F","#D075FF"],["#E5FFC3","#BAF24A"],["#013330","#BAF24A"],["#CCE7FF","#89B0FF"],["#190066","#89B0FF"],["#FF5C16","#FFA680"],["#FF5C16","#661800"],["#D075FF","#EAC2FF"],["#D075FF","#3D065F"],["#BAF24A","#E5FFC3"],["#BAF24A","#013330"],["#89B0FF","#CCE7FF"],["#89B0FF","#190066"],["#661800","#FFA680"],["#FFA680","#661800"],["#3D065F","#EAC2FF"],["#EAC2FF","#3D065F"],["#013330","#E5FFC3"],["#E5FFC3","#013330"],["#190066","#CCE7FF"],["#CCE7FF","#190066"]]).concat([["#EAC2FF","#013330"],["#013330","#EAC2FF"],["#CCE7FF","#661800"],["#661800","#CCE7FF"],["#E5FFC3","#3D065F"],["#3D065F","#E5FFC3"],["#FFA680","#190066"],["#190066","#FFA680"],["#CCE7FF","#013330"],["#013330","#CCE7FF"]]);function o(e){let t=0;for(let n=0;n<e.length;n++)t=e.charCodeAt(n)+(t<<6)+(t<<16)-t;return t}function a(e){if("number"==typeof e){let t=e.toString(16);return t.length<6&&(t=t.padEnd(6,"0")),t}if(Array.isArray(e)){let t=e.map(e=>e.toString(16).padStart(2,"0")).join("");return t.length<6&&(t=t.padEnd(6,"0")),t}return"seed000"}function i(e,t=100){const n=o(a(e)),s=Math.abs(n)%r.length,[i,c]=r[s],m=.25*t,d=(t-2*m)/2;let u="";const l=Array.from({length:2},()=>Array(2).fill(!1)),f=Math.floor(1),h=Math.floor(1),p=[[f,h]];for(l[f][h]=!0;p.length>0;){const[e,t]=p.pop(),s=15&Math.abs(n>>3*e+5*t),r=[],o=[[0,1],[1,0],[0,-1],[-1,0]];for(const[n,s]of o){const o=e+n,a=t+s;o>=0&&o<2&&a>=0&&a<2&&!l[o][a]&&r.push([o,a])}for(;r.length>0;){const e=Math.abs(s+r.length)%r.length,[t,n]=r.splice(e,1)[0];p.push([t,n]),l[t][n]=!0}const a=s%4*90,i=m+e*d,c=m+t*d;u+=s%5==0?`M${i},${c} h${d} v${d} h-${d}z `:0===a?`M${i},${c} h${d} v${d}z `:90===a?`M${i+d},${c} v${d} h-${d}z `:180===a?`M${i+d},${c+d} h-${d} v-${d}z `:`M${i},${c+d} v-${d} h${d}z `}let g=`<svg width="${t}" height="${t}" viewBox="0 0 ${t} ${t}" xmlns="http://www.w3.org/2000/svg">`;return g+=`<rect width="${t}" height="${t}" fill="${i}" />`,g+=`<path d="${u}" fill="${c}" />`,g+="</svg>",g}n.sdbmHash=o,n.seedToString=a,n.createMaskiconSVG=i;const c={};n.getMaskiconSVG=async function(e,t){const n=`${e.toLowerCase()}:${t}`;if(c[n])return c[n];const r=(0,s.extractAccountAddress)(e),o=i((0,s.generateIconSeed)(r),t);return c[n]=o,o}}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.utilities.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/index.cjs",{"./Maskicon.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/Maskicon.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Maskicon=void 0;var s=e("./Maskicon.cjs");Object.defineProperty(n,"Maskicon",{enumerable:!0,get:function(){return s.Maskicon}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/components/temp-components/Maskicon/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/index.cjs",{"./components/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/components/index.cjs","./utils/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./components/index.cjs"),n),r(e("./utils/index.cjs"),n)}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/types/index.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,o,a,i,c,m,d,u,l,f,h,p,g,k,b,y,_,x,w,v,j,O,C,T,A,E,P,B,S,I;Object.defineProperty(n,"__esModule",{value:!0}),n.IconName=n.IconColor=n.IconSize=n.TextButtonSize=n.FontFamily=n.TextTransform=n.FontStyle=n.OverflowWrap=n.FontWeight=n.TextAlign=n.TextColor=n.TextVariant=n.ButtonIconSize=n.ButtonVariant=n.ButtonSize=n.ButtonTertiarySize=n.ButtonSecondarySize=n.ButtonPrimarySize=n.ButtonBaseSize=n.BoxBorderColor=n.BoxBackgroundColor=n.BoxJustifyContent=n.BoxAlignItems=n.BoxFlexWrap=n.BoxFlexDirection=n.BadgeWrapperPosition=n.BadgeWrapperPositionAnchorShape=n.BadgeStatusSize=n.BadgeStatusStatus=n.BadgeCountSize=n.AvatarGroupVariant=n.AvatarIconSeverity=n.AvatarAccountVariant=n.AvatarBaseShape=n.AvatarShape=n.AvatarSize=n.AvatarTokenSize=n.AvatarNetworkSize=n.AvatarIconSize=n.AvatarGroupSize=n.AvatarFaviconSize=n.AvatarAccountSize=n.AvatarBaseSize=void 0,function(e){e.Xs="xs",e.Sm="sm",e.Md="md",e.Lg="lg",e.Xl="xl"}(s||(n.AvatarSize=n.AvatarTokenSize=n.AvatarNetworkSize=n.AvatarIconSize=n.AvatarGroupSize=n.AvatarFaviconSize=n.AvatarAccountSize=n.AvatarBaseSize=s={})),function(e){e.Circle="circle",e.Square="square"}(r||(n.AvatarBaseShape=n.AvatarShape=r={})),function(e){e.Blockies="blockies",e.Jazzicon="jazzicon",e.Maskicon="maskicon"}(o||(n.AvatarAccountVariant=o={})),function(e){e.Neutral="neutral",e.Info="info",e.Success="success",e.Error="error",e.Warning="warning"}(a||(n.AvatarIconSeverity=a={})),function(e){e.Account="Account",e.Favicon="Favicon",e.Network="Network",e.Token="Token"}(i||(n.AvatarGroupVariant=i={})),function(e){e.Md="md",e.Lg="lg"}(c||(n.BadgeCountSize=c={})),function(e){e.Active="active",e.Inactive="inactive",e.Disconnected="disconnected",e.New="new",e.Attention="attention"}(m||(n.BadgeStatusStatus=m={})),function(e){e.Md="md",e.Lg="lg"}(d||(n.BadgeStatusSize=d={})),function(e){e.Rectangular="Rectangular",e.Circular="Circular"}(u||(n.BadgeWrapperPositionAnchorShape=u={})),function(e){e.TopRight="TopRight",e.BottomRight="BottomRight",e.BottomLeft="BottomLeft",e.TopLeft="TopLeft"}(l||(n.BadgeWrapperPosition=l={})),function(e){e.Row="flex-row",e.RowReverse="flex-row-reverse",e.Column="flex-col",e.ColumnReverse="flex-col-reverse"}(f||(n.BoxFlexDirection=f={})),function(e){e.NoWrap="flex-nowrap",e.Wrap="flex-wrap",e.WrapReverse="flex-wrap-reverse"}(h||(n.BoxFlexWrap=h={})),function(e){e.Start="items-start",e.Center="items-center",e.End="items-end",e.Stretch="items-stretch",e.Baseline="items-baseline"}(p||(n.BoxAlignItems=p={})),function(e){e.Start="justify-start",e.Center="justify-center",e.End="justify-end",e.Between="justify-between",e.Around="justify-around",e.Evenly="justify-evenly"}(g||(n.BoxJustifyContent=g={})),function(e){e.BackgroundDefault="bg-default",e.BackgroundAlternative="bg-alternative",e.BackgroundSection="bg-section",e.BackgroundSubsection="bg-subsection",e.BackgroundMuted="bg-muted",e.PrimaryDefault="bg-primary-default",e.PrimaryAlternative="bg-primary-alternative",e.PrimaryMuted="bg-primary-muted",e.PrimaryInverse="bg-primary-inverse",e.ErrorDefault="bg-error-default",e.ErrorAlternative="bg-error-alternative",e.ErrorMuted="bg-error-muted",e.ErrorInverse="bg-error-inverse",e.WarningDefault="bg-warning-default",e.WarningAlternative="bg-warning-alternative",e.WarningMuted="bg-warning-muted",e.WarningInverse="bg-warning-inverse",e.SuccessDefault="bg-success-default",e.SuccessAlternative="bg-success-alternative",e.SuccessMuted="bg-success-muted",e.SuccessInverse="bg-success-inverse",e.InfoDefault="bg-info-default",e.InfoMuted="bg-info-muted",e.InfoInverse="bg-info-inverse",e.FlaskDefault="bg-flask-default",e.FlaskInverse="bg-flask-inverse",e.OverlayAlternative="bg-overlay-alternative",e.OverlayDefault="bg-overlay-default",e.OverlayInverse="bg-overlay-inverse",e.Transparent="bg-transparent"}(k||(n.BoxBackgroundColor=k={})),function(e){e.BackgroundDefault="border-background-default",e.BorderDefault="border-default",e.BorderMuted="border-muted",e.PrimaryDefault="border-primary-default",e.PrimaryAlternative="border-primary-alternative",e.PrimaryMuted="border-primary-muted",e.PrimaryInverse="border-primary-inverse",e.ErrorDefault="border-error-default",e.ErrorAlternative="border-error-alternative",e.ErrorMuted="border-error-muted",e.ErrorInverse="border-error-inverse",e.WarningDefault="border-warning-default",e.WarningAlternative="border-warning-alternative",e.WarningMuted="border-warning-muted",e.WarningInverse="border-warning-inverse",e.SuccessDefault="border-success-default",e.SuccessAlternative="border-success-alternative",e.SuccessMuted="border-success-muted",e.SuccessInverse="border-success-inverse",e.InfoDefault="border-info-default",e.InfoAlternative="border-info-alternative",e.InfoMuted="border-info-muted",e.InfoInverse="border-info-inverse",e.FlaskDefault="border-flask-default",e.FlaskInverse="border-flask-inverse",e.OverlayAlternative="border-overlay-alternative",e.OverlayDefault="border-overlay-default",e.OverlayInverse="border-overlay-inverse",e.Transparent="border-transparent"}(b||(n.BoxBorderColor=b={})),function(e){e.Sm="sm",e.Md="md",e.Lg="lg"}(y||(n.ButtonSize=n.ButtonTertiarySize=n.ButtonSecondarySize=n.ButtonPrimarySize=n.ButtonBaseSize=y={})),function(e){e.Primary="primary",e.Secondary="secondary",e.Tertiary="tertiary"}(_||(n.ButtonVariant=_={})),function(e){e.Sm="sm",e.Md="md",e.Lg="lg"}(x||(n.ButtonIconSize=x={})),function(e){e.DisplayLg="display-lg",e.DisplayMd="display-md",e.HeadingLg="heading-lg",e.HeadingMd="heading-md",e.HeadingSm="heading-sm",e.BodyLg="body-lg",e.BodyMd="body-md",e.BodySm="body-sm",e.BodyXs="body-xs",e.PageHeading="page-heading",e.SectionHeading="section-heading",e.ButtonLabelMd="button-label-md",e.ButtonLabelLg="button-label-lg",e.AmountDisplayLg="amount-display-lg"}(w||(n.TextVariant=w={})),function(e){e.TextDefault="text-default",e.TextAlternative="text-alternative",e.TextMuted="text-muted",e.OverlayInverse="text-overlay-inverse",e.PrimaryDefault="text-primary-default",e.PrimaryDefaultHover="text-primary-default-hover",e.PrimaryDefaultPressed="text-primary-default-pressed",e.PrimaryInverse="text-primary-inverse",e.ErrorDefault="text-error-default",e.ErrorDefaultHover="text-error-default-hover",e.ErrorDefaultPressed="text-error-default-pressed",e.ErrorAlternative="text-error-alternative",e.ErrorInverse="text-error-inverse",e.SuccessDefault="text-success-default",e.SuccessDefaultHover="text-success-default-hover",e.SuccessDefaultPressed="text-success-default-pressed",e.SuccessInverse="text-success-inverse",e.WarningDefault="text-warning-default",e.WarningDefaultHover="text-warning-default-hover",e.WarningDefaultPressed="text-warning-default-pressed",e.WarningInverse="text-warning-inverse",e.InfoDefault="text-info-default",e.InfoInverse="text-info-inverse",e.Inherit="text-inherit",e.Transparent="text-transparent"}(v||(n.TextColor=v={})),function(e){e.Left="text-left",e.Center="text-center",e.Right="text-right",e.Justify="text-justify"}(j||(n.TextAlign=j={})),function(e){e.Bold="font-bold",e.Medium="font-medium",e.Regular="font-regular"}(O||(n.FontWeight=O={})),function(e){e.BreakWord="break-words",e.Anywhere="break-all",e.Normal="break-normal"}(C||(n.OverflowWrap=C={})),function(e){e.Italic="italic",e.Normal="not-italic"}(T||(n.FontStyle=T={})),function(e){e.Uppercase="uppercase",e.Lowercase="lowercase",e.Capitalize="capitalize",e.Normal="normal-case"}(A||(n.TextTransform=A={})),function(e){e.Default="font-default",e.Accent="font-accent",e.Hero="font-hero"}(E||(n.FontFamily=E={})),function(e){e.BodyLg="body-lg",e.BodyMd="body-md",e.BodySm="body-sm",e.BodyXs="body-xs"}(P||(n.TextButtonSize=P={})),function(e){e.Xs="xs",e.Sm="sm",e.Md="md",e.Lg="lg",e.Xl="xl"}(B||(n.IconSize=B={})),function(e){e.IconDefault="text-icon-default",e.IconAlternative="text-icon-alternative",e.IconMuted="text-icon-muted",e.OverlayInverse="text-overlay-inverse",e.PrimaryDefault="text-primary-default",e.PrimaryInverse="text-primary-inverse",e.ErrorDefault="text-error-default",e.ErrorInverse="text-error-inverse",e.SuccessDefault="text-success-default",e.SuccessInverse="text-success-inverse",e.WarningDefault="text-warning-default",e.WarningInverse="text-warning-inverse",e.InfoDefault="text-info-default",e.InfoInverse="text-info-inverse"}(S||(n.IconColor=S={})),function(e){e.Accessibility="Accessibility",e.Activity="Activity",e.Add="Add",e.AddCard="AddCard",e.AddCircle="AddCircle",e.AddSquare="AddSquare",e.Ai="Ai",e.AlternateEmail="AlternateEmail",e.AppleLogo="AppleLogo",e.Apps="Apps",e.Arrow2Down="Arrow2Down",e.Arrow2Left="Arrow2Left",e.Arrow2Right="Arrow2Right",e.Arrow2Up="Arrow2Up",e.Arrow2UpRight="Arrow2UpRight",e.ArrowCircleDown="ArrowCircleDown",e.ArrowCircleUp="ArrowCircleUp",e.ArrowDoubleLeft="ArrowDoubleLeft",e.ArrowDoubleRight="ArrowDoubleRight",e.ArrowDown="ArrowDown",e.ArrowDropDownCircle="ArrowDropDownCircle",e.ArrowLeft="ArrowLeft",e.ArrowRight="ArrowRight",e.ArrowUp="ArrowUp",e.AttachMoney="AttachMoney",e.Attachment="Attachment",e.Backspace="Backspace",e.Ban="Ban",e.Bank="Bank",e.BankAssured="BankAssured",e.Bold="Bold",e.Book="Book",e.Bookmark="Bookmark",e.Bridge="Bridge",e.Briefcase="Briefcase",e.Bulb="Bulb",e.BuySell="BuySell",e.Cake="Cake",e.Calculator="Calculator",e.Calendar="Calendar",e.Call="Call",e.Camera="Camera",e.Campaign="Campaign",e.Candlestick="Candlestick",e.Card="Card",e.CardPos="CardPos",e.Cash="Cash",e.Category="Category",e.Chart="Chart",e.Check="Check",e.CheckBold="CheckBold",e.CircleX="CircleX",e.Clear="Clear",e.Clock="Clock",e.ClockFilled="ClockFilled",e.Close="Close",e.Cloud="Cloud",e.CloudDownload="CloudDownload",e.CloudUpload="CloudUpload",e.Code="Code",e.CodeCircle="CodeCircle",e.Coin="Coin",e.Collapse="Collapse",e.Confirmation="Confirmation",e.Connect="Connect",e.Copy="Copy",e.CopySuccess="CopySuccess",e.CreditCheck="CreditCheck",e.CurrencyFranc="CurrencyFranc",e.CurrencyLira="CurrencyLira",e.CurrencyPound="CurrencyPound",e.CurrencyYuan="CurrencyYuan",e.Customize="Customize",e.Danger="Danger",e.Dark="Dark",e.DarkFilled="DarkFilled",e.Data="Data",e.Description="Description",e.Details="Details",e.Diagram="Diagram",e.DocumentCode="DocumentCode",e.Download="Download",e.Draft="Draft",e.EcoLeaf="EcoLeaf",e.Edit="Edit",e.EditSquare="EditSquare",e.EncryptedAdd="EncryptedAdd",e.Eraser="Eraser",e.Error="Error",e.Ethereum="Ethereum",e.Exchange="Exchange",e.Expand="Expand",e.ExpandVertical="ExpandVertical",e.Explore="Explore",e.ExploreFilled="ExploreFilled",e.Export="Export",e.Extension="Extension",e.Eye="Eye",e.EyeSlash="EyeSlash",e.FaceId="FaceId",e.Feedback="Feedback",e.File="File",e.Filter="Filter",e.Fingerprint="Fingerprint",e.Fire="Fire",e.FirstPage="FirstPage",e.Flag="Flag",e.Flash="Flash",e.FlashSlash="FlashSlash",e.Flask="Flask",e.Flower="Flower",e.Folder="Folder",e.Forest="Forest",e.FullCircle="FullCircle",e.Gas="Gas",e.Gift="Gift",e.Global="Global",e.GlobalSearch="GlobalSearch",e.Graph="Graph",e.Hardware="Hardware",e.HashTag="HashTag",e.Heart="Heart",e.HeartFilled="HeartFilled",e.Hierarchy="Hierarchy",e.Home="Home",e.HomeFilled="HomeFilled",e.Image="Image",e.Info="Info",e.Inventory="Inventory",e.Joystick="Joystick",e.Keep="Keep",e.KeepFilled="KeepFilled",e.Key="Key",e.LastPage="LastPage",e.Light="Light",e.LightFilled="LightFilled",e.Link="Link",e.Loading="Loading",e.Location="Location",e.Lock="Lock",e.LockSlash="LockSlash",e.LockedFilled="LockedFilled",e.Login="Login",e.Logout="Logout",e.Mail="Mail",e.Map="Map",e.Menu="Menu",e.MessageQuestion="MessageQuestion",e.Messages="Messages",e.MetamaskFoxOutline="MetamaskFoxOutline",e.Mic="Mic",e.Minus="Minus",e.MinusBold="MinusBold",e.MinusSquare="MinusSquare",e.Mobile="Mobile",e.Money="Money",e.MoneyBag="MoneyBag",e.Monitor="Monitor",e.MoreHorizontal="MoreHorizontal",e.MoreVertical="MoreVertical",e.MountainFlag="MountainFlag",e.MusicNote="MusicNote",e.Notification="Notification",e.PageInfo="PageInfo",e.Palette="Palette",e.PasswordCheck="PasswordCheck",e.Pending="Pending",e.People="People",e.PersonCancel="PersonCancel",e.Pin="Pin",e.Plant="Plant",e.Plug="Plug",e.PlusAndMinus="PlusAndMinus",e.PolicyAlert="PolicyAlert",e.Print="Print",e.PriorityHigh="PriorityHigh",e.PrivacyTip="PrivacyTip",e.ProgrammingArrows="ProgrammingArrows",e.Publish="Publish",e.QrCode="QrCode",e.Question="Question",e.Receive="Receive",e.Received="Received",e.Refresh="Refresh",e.RemoveMinus="RemoveMinus",e.Report="Report",e.Rocket="Rocket",e.Save="Save",e.SaveFilled="SaveFilled",e.Saving="Saving",e.Scan="Scan",e.ScanBarcode="ScanBarcode",e.ScanFocus="ScanFocus",e.Search="Search",e.Security="Security",e.SecurityAlert="SecurityAlert",e.SecurityCross="SecurityCross",e.SecurityKey="SecurityKey",e.SecuritySearch="SecuritySearch",e.SecuritySlash="SecuritySlash",e.SecurityTick="SecurityTick",e.SecurityTime="SecurityTime",e.SecurityUser="SecurityUser",e.Send="Send",e.SentimentDissatisfied="SentimentDissatisfied",e.SentimentNeutral="SentimentNeutral",e.SentimentSatisfied="SentimentSatisfied",e.SentimentVerySatisfied="SentimentVerySatisfied",e.Setting="Setting",e.SettingFilled="SettingFilled",e.Share="Share",e.ShieldLock="ShieldLock",e.ShoppingBag="ShoppingBag",e.ShoppingCart="ShoppingCart",e.SignalCellular="SignalCellular",e.Slash="Slash",e.Sms="Sms",e.Snaps="Snaps",e.SnapsMobile="SnapsMobile",e.SnapsPlus="SnapsPlus",e.SnapsRound="SnapsRound",e.Sort="Sort",e.SortByAlpha="SortByAlpha",e.Sparkle="Sparkle",e.Speed="Speed",e.Speedometer="Speedometer",e.Square="Square",e.Stake="Stake",e.Star="Star",e.StarFilled="StarFilled",e.Start="Start",e.Storefront="Storefront",e.Student="Student",e.SwapHorizontal="SwapHorizontal",e.SwapVertical="SwapVertical",e.TabClose="TabClose",e.TableRow="TableRow",e.Tablet="Tablet",e.Tag="Tag",e.ThumbDown="ThumbDown",e.ThumbDownFilled="ThumbDownFilled",e.ThumbUp="ThumbUp",e.ThumbUpFilled="ThumbUpFilled",e.Tint="Tint",e.Tooltip="Tooltip",e.Translate="Translate",e.Trash="Trash",e.TrendDown="TrendDown",e.TrendUp="TrendUp",e.Undo="Undo",e.Unfold="Unfold",e.UnlockedFilled="UnlockedFilled",e.Unpin="Unpin",e.Upload="Upload",e.UploadFile="UploadFile",e.Usb="Usb",e.User="User",e.UserCheck="UserCheck",e.UserCircle="UserCircle",e.UserCircleAdd="UserCircleAdd",e.UserCircleRemove="UserCircleRemove",e.Verified="Verified",e.VerifiedFilled="VerifiedFilled",e.Videocam="Videocam",e.ViewColumn="ViewColumn",e.ViewInAr="ViewInAr",e.VolumeOff="VolumeOff",e.VolumeUp="VolumeUp",e.Wallet="Wallet",e.WalletFilled="WalletFilled",e.Warning="Warning",e.WebTraffic="WebTraffic",e.Widgets="Widgets",e.Wifi="Wifi",e.WifiOff="WifiOff",e.X="X"}(I||(n.IconName=I={}))}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/types/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/index.cjs",{"./tw-merge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.twMerge=void 0;var s=e("./tw-merge.cjs");Object.defineProperty(n,"twMerge",{enumerable:!0,get:function(){return s.twMerge}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/utils/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs",{"tailwind-merge":"/home/runner/work/metamask-extension/metamask-extension/node_modules/tailwind-merge/dist/bundle-cjs.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.twMerge=void 0;const s=e("tailwind-merge");n.twMerge=(0,s.extendTailwindMerge)({extend:{classGroups:{"text-color":["text-default","text-alternative","text-muted"],"font-size":[{text:["s-display-lg","s-display-md","s-heading-lg","s-heading-md","s-heading-sm","s-body-lg","s-body-md","s-body-sm","s-body-xs","l-display-lg","l-display-md","l-heading-lg","l-heading-md","l-heading-sm","l-body-lg","l-body-md","l-body-sm","l-body-xs","s-page-heading","s-section-heading","s-button-label-md","s-button-label-lg","s-amount-display-lg","l-page-heading","l-section-heading","l-button-label-md","l-button-label-lg","l-amount-display-lg"]}],"font-family":["font-default","font-accent","font-hero"],"font-weight":["font-thin","font-extralight","font-light","font-normal","font-regular","font-medium","font-semibold","font-bold","font-extrabold","font-black"]},conflictingClassGroups:{"text-color":["text-color"],"font-size":["font-size"],"font-family":["font-family"],"font-weight":["font-weight"]}}})}}},{package:"@metamask/design-system-react",file:"node_modules/@metamask/design-system-react/dist/utils/tw-merge.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-compose-refs/dist/index.js",{react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=Object.create,o=Object.defineProperty,a=Object.getOwnPropertyDescriptor,i=Object.getOwnPropertyNames,c=Object.getPrototypeOf,m=Object.prototype.hasOwnProperty,d=(e,t,n,s)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let r of i(t))m.call(e,r)||r===n||o(e,r,{get:()=>t[r],enumerable:!(s=a(t,r))||s.enumerable});return e},u={};((e,t)=>{for(var n in t)o(e,n,{get:t[n],enumerable:!0})})(u,{composeRefs:()=>h,useComposedRefs:()=>p}),t.exports=(s=u,d(o({},"__esModule",{value:!0}),s));var l=((e,t,n)=>(n=null!=e?r(c(e)):{},d(!t&&e&&e.__esModule?n:o(n,"default",{value:e,enumerable:!0}),e)))(e("react"));function f(e,t){if("function"==typeof e)return e(t);null!=e&&(e.current=t)}function h(...e){return t=>{let n=!1;const s=e.map(e=>{const s=f(e,t);return n||"function"!=typeof s||(n=!0),s});if(n)return()=>{for(let t=0;t<s.length;t++){const n=s[t];"function"==typeof n?n():f(e[t],null)}}}}function p(...e){return l.useCallback(h(...e),e)}}}},{package:"@metamask/design-system-react>@radix-ui/react-slot>@radix-ui/react-compose-refs",file:"node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-compose-refs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-slot/dist/index.js",{"@radix-ui/react-compose-refs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-compose-refs/dist/index.js",react:"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/index.js","react/jsx-runtime":"/home/runner/work/metamask-extension/metamask-extension/node_modules/react/jsx-runtime.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=Object.create,o=Object.defineProperty,a=Object.getOwnPropertyDescriptor,i=Object.getOwnPropertyNames,c=Object.getPrototypeOf,m=Object.prototype.hasOwnProperty,d=(e,t,n,s)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let r of i(t))m.call(e,r)||r===n||o(e,r,{get:()=>t[r],enumerable:!(s=a(t,r))||s.enumerable});return e},u={};((e,t)=>{for(var n in t)o(e,n,{get:t[n],enumerable:!0})})(u,{Root:()=>g,Slot:()=>g,Slottable:()=>_,createSlot:()=>p,createSlottable:()=>y}),t.exports=(s=u,d(o({},"__esModule",{value:!0}),s));var l=((e,t,n)=>(n=null!=e?r(c(e)):{},d(!t&&e&&e.__esModule?n:o(n,"default",{value:e,enumerable:!0}),e)))(e("react")),f=e("@radix-ui/react-compose-refs"),h=e("react/jsx-runtime");function p(e){const t=k(e),n=l.forwardRef((e,n)=>{const{children:s,...r}=e,o=l.Children.toArray(s),a=o.find(x);if(a){const e=a.props.children,s=o.map(t=>t===a?l.Children.count(e)>1?l.Children.only(null):l.isValidElement(e)?e.props.children:null:t);return(0,h.jsx)(t,{...r,ref:n,children:l.isValidElement(e)?l.cloneElement(e,void 0,s):null})}return(0,h.jsx)(t,{...r,ref:n,children:s})});return n.displayName=`${e}.Slot`,n}var g=p("Slot");function k(e){const t=l.forwardRef((e,t)=>{const{children:n,...s}=e;if(l.isValidElement(n)){const e=function(e){let t=Object.getOwnPropertyDescriptor(e.props,"ref")?.get,n=t&&"isReactWarning"in t&&t.isReactWarning;if(n)return e.ref;if(t=Object.getOwnPropertyDescriptor(e,"ref")?.get,n=t&&"isReactWarning"in t&&t.isReactWarning,n)return e.props.ref;return e.props.ref||e.ref}(n),r=function(e,t){const n={...t};for(const s in t){const r=e[s],o=t[s];/^on[A-Z]/.test(s)?r&&o?n[s]=(...e)=>{const t=o(...e);return r(...e),t}:r&&(n[s]=r):"style"===s?n[s]={...r,...o}:"className"===s&&(n[s]=[r,o].filter(Boolean).join(" "))}return{...e,...n}}(s,n.props);return n.type!==l.Fragment&&(r.ref=t?(0,f.composeRefs)(t,e):e),l.cloneElement(n,r)}return l.Children.count(n)>1?l.Children.only(null):null});return t.displayName=`${e}.SlotClone`,t}var b=Symbol("radix.slottable");function y(e){const t=({children:e})=>(0,h.jsx)(h.Fragment,{children:e});return t.displayName=`${e}.Slottable`,t.__radixId=b,t}var _=y("Slottable");function x(e){return l.isValidElement(e)&&"function"==typeof e.type&&"__radixId"in e.type&&e.type.__radixId===b}}}},{package:"@metamask/design-system-react>@radix-ui/react-slot",file:"node_modules/@metamask/design-system-react/node_modules/@radix-ui/react-slot/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-shared/dist/index.cjs",{"./utils/caip-address.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-shared/dist/utils/caip-address.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.generateIconSeed=n.isEthereumAddress=n.generateSeedNonEthereum=n.generateSeedEthereum=n.extractAccountAddress=void 0;var s=e("./utils/caip-address.cjs");Object.defineProperty(n,"extractAccountAddress",{enumerable:!0,get:function(){return s.extractAccountAddress}}),Object.defineProperty(n,"generateSeedEthereum",{enumerable:!0,get:function(){return s.generateSeedEthereum}}),Object.defineProperty(n,"generateSeedNonEthereum",{enumerable:!0,get:function(){return s.generateSeedNonEthereum}}),Object.defineProperty(n,"isEthereumAddress",{enumerable:!0,get:function(){return s.isEthereumAddress}}),Object.defineProperty(n,"generateIconSeed",{enumerable:!0,get:function(){return s.generateIconSeed}})}}},{package:"@metamask/design-system-react>@metamask/design-system-shared",file:"node_modules/@metamask/design-system-shared/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/design-system-shared/dist/utils/caip-address.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.generateIconSeed=n.isEthereumAddress=n.generateSeedNonEthereum=n.generateSeedEthereum=n.extractAccountAddress=void 0;const s=e("@metamask/utils");function r(e){const t=e.slice(2,10);return parseInt(t,16)}function o(e){return Array.from((0,s.stringToBytes)(e.normalize("NFKC").toLowerCase()))}function a(e){return e.startsWith("0x")}n.extractAccountAddress=function(e){try{if((0,s.isCaipAccountId)(e)){return(0,s.parseCaipAccountId)(e).address}}catch{}return e},n.generateSeedEthereum=r,n.generateSeedNonEthereum=o,n.isEthereumAddress=a,n.generateIconSeed=function(e){return a(e)?r(e):o(e)}}}},{package:"@metamask/design-system-react>@metamask/design-system-shared",file:"node_modules/@metamask/design-system-shared/dist/utils/caip-address.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,o,a,i,c,m,d=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},u=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},l=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.PollingBlockTracker=void 0;const f=l(e("@metamask/safe-event-emitter")),h=e("@metamask/utils"),p=l(e("json-rpc-random-id")),g=e("./logging-utils.cjs"),k=(0,g.createModuleLogger)(g.projectLogger,"polling-block-tracker"),b=(0,p.default)(),y=["sync","latest"];class _ extends f.default{constructor(e={}){if(!e.provider)throw new Error("PollingBlockTracker - no provider specified.");super(),s.add(this),r.set(this,[]),o.set(this,void 0),a.set(this,void 0),this._blockResetDuration=e.blockResetDuration||2e4,this._usePastBlocks=e.usePastBlocks||!1,this._currentBlock=null,this._isRunning=!1,this._onNewListener=this._onNewListener.bind(this),this._onRemoveListener=this._onRemoveListener.bind(this),this._resetCurrentBlock=this._resetCurrentBlock.bind(this),this._setupInternalEvents(),this._provider=e.provider,this._pollingInterval=e.pollingInterval||2e4,this._retryTimeout=e.retryTimeout||this._pollingInterval/10,this._keepEventLoopActive=e.keepEventLoopActive===undefined||e.keepEventLoopActive,this._setSkipCacheFlag=e.setSkipCacheFlag||!1}async destroy(){this._cancelBlockResetTimeout(),super.removeAllListeners(),this._maybeEnd()}isRunning(){return this._isRunning}getCurrentBlock(){return this._currentBlock}async getLatestBlock({useCache:e=!0}={}){if(this._currentBlock&&e)return this._currentBlock;if(d(this,o,"f"))return await d(this,o,"f").promise;const{promise:t,resolve:n,reject:r}=(0,h.createDeferredPromise)({suppressUnhandledRejection:!0});if(u(this,o,{reject:r,promise:t},"f"),this._isRunning)try{const e=t=>{d(this,s,"m",c).call(this,e),this.removeListener("latest",e),n(t)};return d(this,s,"m",i).call(this,e),this.once("latest",e),await t}catch(e){throw r(e),e}finally{u(this,o,undefined,"f")}else try{const e=await this._updateLatestBlock();return n(e),e}catch(e){throw r(e),e}finally{setTimeout(()=>{u(this,o,undefined,"f")},this._pollingInterval)}}removeAllListeners(e){return e?super.removeAllListeners(e):super.removeAllListeners(),this._setupInternalEvents(),this._onRemoveListener(),this}_setupInternalEvents(){this.removeListener("newListener",this._onNewListener),this.removeListener("removeListener",this._onRemoveListener),this.on("newListener",this._onNewListener),this.on("removeListener",this._onRemoveListener)}_onNewListener(e){y.includes(e)&&this._maybeStart()}_onRemoveListener(){this._getBlockTrackerEventCount()>0||this._maybeEnd()}_maybeStart(){this._isRunning||(this._isRunning=!0,this._cancelBlockResetTimeout(),this._start(),this.emit("_started"))}_maybeEnd(){this._isRunning&&(this._isRunning=!1,this._setupBlockResetTimeout(),this._end(),d(this,s,"m",m).call(this,new Error("Block tracker destroyed")),this.emit("_ended"))}_getBlockTrackerEventCount(){return y.map(e=>this.listeners(e)).flat().filter(e=>d(this,r,"f").every(t=>!Object.is(t,e))).length}_shouldUseNewBlock(e){const t=this._currentBlock;if(!t)return!0;const n=x(e),s=x(t);return this._usePastBlocks&&n<s||n>s}_newPotentialLatest(e){this._shouldUseNewBlock(e)&&this._setCurrentBlock(e)}_setCurrentBlock(e){const t=this._currentBlock;this._currentBlock=e,this.emit("latest",e),this.emit("sync",{oldBlock:t,newBlock:e})}_setupBlockResetTimeout(){this._cancelBlockResetTimeout(),this._blockResetTimeout=setTimeout(this._resetCurrentBlock,this._blockResetDuration),this._blockResetTimeout.unref&&this._blockResetTimeout.unref()}_cancelBlockResetTimeout(){this._blockResetTimeout&&clearTimeout(this._blockResetTimeout)}_resetCurrentBlock(){this._currentBlock=null}async checkForLatestBlock(){return await this._updateLatestBlock(),await this.getLatestBlock()}_start(){this._updateAndQueue()}_end(){this._clearPollingTimeout()}async _updateLatestBlock(){const e=await this._fetchLatestBlock();return this._newPotentialLatest(e),this._isRunning||this._setupBlockResetTimeout(),this._currentBlock}async _fetchLatestBlock(){if(d(this,a,"f"))return await d(this,a,"f").promise;const{promise:e,resolve:t,reject:n}=(0,h.createDeferredPromise)({suppressUnhandledRejection:!0});u(this,a,{reject:n,promise:e},"f");try{const e={jsonrpc:"2.0",id:b(),method:"eth_blockNumber",params:[]};this._setSkipCacheFlag&&(e.skipCache=!0),k("Making request",e);const n=await this._provider.request(e);return k("Got result",n),t(n),n}catch(e){throw k("Encountered error fetching block",(0,h.getErrorMessage)(e)),n(e),d(this,s,"m",m).call(this,e),e}finally{u(this,a,undefined,"f")}}async _updateAndQueue(){let e=this._pollingInterval;try{await this._updateLatestBlock()}catch(t){try{this.emit("error",t)}catch{console.error(`Error updating latest block: ${(0,h.getErrorMessage)(t)}`)}e=this._retryTimeout}if(!this._isRunning)return;this._clearPollingTimeout();const t=setTimeout(()=>{this._updateAndQueue()},e);t.unref&&!this._keepEventLoopActive&&t.unref(),this._pollingTimeout=t,this.emit("_waitingForNextIteration")}_clearPollingTimeout(){this._pollingTimeout&&(clearTimeout(this._pollingTimeout),this._pollingTimeout=undefined)}}function x(e){return Number.parseInt(e,16)}n.PollingBlockTracker=_,r=new WeakMap,o=new WeakMap,a=new WeakMap,s=new WeakSet,i=function(e){d(this,r,"f").push(e)},c=function(e){d(this,r,"f").splice(d(this,r,"f").indexOf(e),1)},m=function(e){d(this,o,"f")?.reject(e),u(this,o,undefined,"f")}}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/index.cjs",{"./PollingBlockTracker.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./PollingBlockTracker.cjs"),n)}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("eth-block-tracker")}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/logging-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/key-tree":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/index.cjs","@metamask/scure-bip39":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/index.js","@metamask/scure-bip39/dist/wordlists/english.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/wordlists/english.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/hdkey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/hdkey.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var s,r,o,a,i,c,m,d,u,l,f,h=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},p=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;const g=e("@ethereumjs/util"),k=e("@metamask/eth-sig-util"),b=e("@metamask/key-tree"),y=e("@metamask/scure-bip39"),_=e("@metamask/scure-bip39/dist/wordlists/english.js"),x=e("@metamask/utils"),w=e("ethereum-cryptography/hdkey"),v=e("ethereum-cryptography/keccak"),j="m/44'/60'/0'/0",O="HD Key Tree";class C{constructor(e={}){s.add(this),this.type=O,this.hdPath=j,r.set(this,new Map),o.set(this,void 0),h(this,o,e.cryptographicFunctions,"f")}async generateRandomMnemonic(){await p(this,s,"m",u).call(this,(0,y.generateMnemonic)(_.wordlist))}async serialize(){let e=[];if(this.mnemonic){const t=p(this,s,"m",a).call(this,this.mnemonic);e=Array.from((new TextEncoder).encode(t))}return{mnemonic:e,numberOfAccounts:p(this,r,"f").size,hdPath:this.hdPath}}async deserialize(e){if(e.numberOfAccounts&&!e.mnemonic)throw new Error("Eth-Hd-Keyring: Deserialize method cannot be called with an opts value for numberOfAccounts and no menmonic");if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");p(this,r,"f").clear(),this.mnemonic=null,this.seed=null,this.root=null,this.hdPath=e.hdPath??j,e.mnemonic&&await p(this,s,"m",u).call(this,e.mnemonic),e.numberOfAccounts&&await this.addAccounts(e.numberOfAccounts)}async addAccounts(e=1){if(!this.root)throw new Error("Eth-Hd-Keyring: No secret recovery phrase provided");const t=p(this,r,"f").size,n=[];for(let o=t;o<e+t;o++){const e=this.root.deriveChild(o);(0,x.assert)(e.publicKey,"Expected public key to be set");const t=p(this,s,"m",l).call(this,e.publicKey),a={hdKey:e,address:t};p(this,r,"f").set(t,a),n.push(t)}return Promise.resolve(n)}async getAccounts(){return Array.from(p(this,r,"f").keys())}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const n=p(this,s,"m",d).call(this,e,{withAppKeyOrigin:t});(0,x.assert)(n.publicKey,"Expected public key to be set");return p(this,s,"m",f).call(this,(0,x.bytesToHex)((0,g.publicToAddress)(n.publicKey)))}async exportAccount(e,t){const n=t?p(this,s,"m",d).call(this,e,t):p(this,s,"m",d).call(this,e),{privateKey:r}=n;return(0,x.assert)(r instanceof Uint8Array,"Expected private key to be of type Uint8Array"),(0,x.remove0x)((0,x.bytesToHex)(r))}async signTransaction(e,n,r={}){const o=p(this,s,"m",m).call(this,e,r);return n.sign(t.from(o))??n}async signMessage(e,n,r={}){(0,x.assertIsHexString)(n);const o=(0,x.remove0x)(n),a=p(this,s,"m",m).call(this,e,r),i=(0,g.ecsign)(t.from(o,"hex"),t.from(a));return(0,k.concatSig)(t.from((0,x.bigIntToBytes)(i.v)),t.from(i.r),t.from(i.s))}async signPersonalMessage(e,n,r={}){const o=p(this,s,"m",m).call(this,e,r),a=t.from(o);return(0,k.personalSign)({privateKey:a,data:n})}async decryptMessage(e,n){const r=p(this,s,"m",d).call(this,e),{privateKey:o}=r;(0,x.assert)(o,"Expected private key to be set");const a=t.from(o).toString("hex");return(0,k.decrypt)({privateKey:a,encryptedData:n})}async signTypedData(e,n,r){let{version:o}=r??{version:k.SignTypedDataVersion.V1};o&&Object.keys(k.SignTypedDataVersion).includes(o)||(o=k.SignTypedDataVersion.V1);const a=p(this,s,"m",m).call(this,e,r);return(0,k.signTypedData)({privateKey:t.from(a),data:n,version:o})}async signEip7702Authorization(e,n,r){const o=p(this,s,"m",m).call(this,e,r);return(0,k.signEIP7702Authorization)({privateKey:t.from(o),authorization:n})}removeAccount(e){const t=p(this,s,"m",f).call(this,e);if(!p(this,r,"f").has(t))throw new Error(`Address ${t} not found in this keyring`);p(this,r,"f").delete(t)}async getEncryptionPublicKey(e,t={}){const n=p(this,s,"m",m).call(this,e,t);return(0,k.getEncryptionPublicKey)((0,x.remove0x)((0,x.bytesToHex)(n)))}}n.HdKeyring=C,r=new WeakMap,o=new WeakMap,s=new WeakSet,a=function(e){return Array.from(new Uint16Array(new Uint8Array(e).buffer)).map(e=>_.wordlist[e]).join(" ")},i=function(e){const t=e.split(" ").map(e=>_.wordlist.indexOf(e));return new Uint8Array(new Uint16Array(t).buffer)},c=function(e){let n=e;var r;if("object"==typeof(r=e)&&null!==r&&"type"in r&&"Buffer"===r.type&&"data"in r&&Array.isArray(r.data)&&(n=e.data),"string"==typeof n||t.isBuffer(n)||Array.isArray(n)){let e;return e=Array.isArray(n)?t.from(n).toString():t.isBuffer(n)?n.toString():n,p(this,s,"m",i).call(this,e)}return n instanceof Object&&!(n instanceof Uint8Array)?Uint8Array.from(Object.values(n)):((0,x.assert)(n instanceof Uint8Array,"Expected Uint8Array mnemonic"),n)},m=function(e,t){if(!e)throw new Error("Must specify address.");const n=p(this,s,"m",d).call(this,e,t);return(0,x.assert)(n.privateKey,"Missing private key"),n.privateKey},d=function(e,{withAppKeyOrigin:n}={}){const o=p(this,s,"m",f).call(this,e),a=p(this,r,"f").get(o);if(!a)throw new Error("HD Keyring - Unable to find matching address.");if(n){const{privateKey:e}=a.hdKey;(0,x.assert)(e,"Expected private key to be set");const s=t.from(n,"utf8"),r=t.concat([e,s]),o=t.from((0,v.keccak256)(r));return{privateKey:o,publicKey:t.from((0,g.privateToPublic)(o))}}return a.hdKey},u=async function(e){if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");this.mnemonic=p(this,s,"m",c).call(this,e),this.seed=await(0,b.mnemonicToSeed)(this.mnemonic,"",p(this,o,"f")),this.hdWallet=w.HDKey.fromMasterSeed(this.seed),this.root=this.hdWallet.derive(this.hdPath)},l=function(e){return(0,x.add0x)((0,x.bytesToHex)((0,g.publicToAddress)(t.from(e),!0)).toLowerCase())},f=function(e){const t=(0,k.normalize)(e);return(0,x.assert)(t,"Expected address to be set"),(0,x.add0x)(t)},C.type=O}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/index.cjs",{"./hd-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;var s=e("./hd-keyring.cjs");Object.defineProperty(n,"HdKeyring",{enumerable:!0,get:function(){return s.HdKeyring}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js",{"./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js","./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createInfuraMiddlewareWithoutRpcService=n.createInfuraMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("@metamask/rpc-errors"),o=e("./fetch-config-from-req"),a=e("./logging-utils"),i=(0,a.createModuleLogger)(a.projectLogger,"create-infura-middleware"),c=["Gateway timeout","ETIMEDOUT","ECONNRESET","SyntaxError"];function m({network:e="mainnet",maxAttempts:t=5,source:n,projectId:r,headers:o={}}){if(!r||"string"!=typeof r)throw new Error(`Invalid value for 'projectId': "${r}"`);if(!o||"object"!=typeof o)throw new Error(`Invalid value for 'headers': "${o}"`);if(!t)throw new Error(`Invalid value for 'maxAttempts': "${t}" (${typeof t})`);return(0,s.createAsyncMiddleware)(async(s,a)=>{for(let c=1;c<=t;c++)try{i("Attempting request to Infura. network = %o, projectId = %s, headers = %o, req = %o",e,r,o,s),await d(e,r,o,s,a,n);break}catch(e){if(!l(e))throw i("Non-retriable request error encountered. req = %o, res = %o, error = %o",s,a,e),e;if(!(t-c)){i("Retriable request error encountered, but exceeded max attempts. req = %o, res = %o, error = %o",s,a,e);const t=`InfuraProvider - cannot complete request. All retries exhausted.\nOriginal Error:\n${e.toString()}\n\n`;throw new Error(t)}i("Retriable request error encountered. req = %o, res = %o, error = %o",s,a,e),i("Waiting 1 second to try again..."),await f(1e3)}})}async function d(e,t,n,s,a,i){const{fetchUrl:c,fetchParams:m}=(0,o.fetchConfigFromReq)({network:e,projectId:t,extraHeaders:n,req:s,source:i}),d=await fetch(c,m),l=await d.text();if(!d.ok)switch(d.status){case 405:throw r.rpcErrors.methodNotFound();case 429:throw u("Request is being rate limited.");case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",u(e)}();default:throw u(l)}if("eth_getBlockByNumber"===s.method&&"Not Found"===l)return void(a.result=null);const f=JSON.parse(l);a.result=f.result,a.error=f.error}function u(e){return r.rpcErrors.internal(e)}function l(e){const t=e.toString();return c.some(e=>t.includes(e))}async function f(e){return new Promise(t=>{setTimeout(t,e)})}n.createInfuraMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){const{source:n,headers:r={}}=t;return(0,s.createAsyncMiddleware)(async(t,s)=>{const o=n!==undefined&&t.origin!==undefined?Object.assign(Object.assign({},r),{"Infura-Source":`${n}/${t.origin}`}):r,a=await e.request({id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},{headers:o});"error"in a?s.error=a.error:(s.result=a.result,s.error=undefined)})}(e):m(e)},n.createInfuraMiddlewareWithoutRpcService=m}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","@metamask/eth-json-rpc-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createProvider=void 0;const s=e("@metamask/eth-json-rpc-provider"),r=e("@metamask/json-rpc-engine"),o=e("./create-infura-middleware");n.createProvider=function(e){const t=new r.JsonRpcEngine;return t.push((0,o.createInfuraMiddleware)(e)),(0,s.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){return{id:e.id,jsonrpc:e.jsonrpc,method:e.method,params:e.params}}Object.defineProperty(n,"__esModule",{value:!0}),n.fetchConfigFromReq=void 0,n.fetchConfigFromReq=function({network:e,projectId:t,extraHeaders:n={},req:r,source:o}){const a=r.origin||"internal",i=Object.assign({},n,{Accept:"application/json","Content-Type":"application/json"});return o&&(i["Infura-Source"]=`${o}/${a}`),{fetchUrl:`https://${e}.infura.io/v3/${t}`,fetchParams:{method:"POST",headers:i,body:JSON.stringify(s(r))}}}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/index.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","./create-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js","./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./create-infura-middleware"),n),r(e("./fetch-config-from-req"),n),r(e("./create-provider"),n)}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("eth-json-rpc-infura")}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockCacheMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("./logging-utils.cjs"),o=e("./utils/cache.cjs"),a=(0,r.createModuleLogger)(r.projectLogger,"block-cache"),i=[undefined,null,"<nil>"];class c{constructor(){this.cache={}}getBlockCache(e){const t=Number.parseInt(e,16);let n=this.cache[t];if(!n){const e={};this.cache[t]=e,n=e}return n}async get(e,t){const n=this.getBlockCache(t),s=(0,o.cacheIdentifierForRequest)(e,!0);return s?n[s]:undefined}async set(e,t,n){if(!this.canCacheResult(e,n))return;const s=(0,o.cacheIdentifierForRequest)(e,!0);if(!s)return;this.getBlockCache(t)[s]=n}canCacheRequest(e){if(!(0,o.canCache)(e.method))return!1;return"pending"!==(0,o.blockTagForRequest)(e)}canCacheResult(e,t){return!i.includes(t)&&!(e.method&&["eth_getTransactionByHash","eth_getTransactionReceipt"].includes(e.method)&&(!t?.blockHash||"0x0000000000000000000000000000000000000000000000000000000000000000"===t.blockHash))}clearBefore(e){const t=Number.parseInt(e,16);Object.keys(this.cache).map(Number).filter(e=>e<t).forEach(e=>delete this.cache[e])}}n.createBlockCacheMiddleware=function({blockTracker:e}={}){if(!e)throw new Error("createBlockCacheMiddleware - No PollingBlockTracker specified");const t=new c,n={[o.CacheStrategy.Permanent]:t,[o.CacheStrategy.Block]:t,[o.CacheStrategy.Fork]:t,[o.CacheStrategy.Never]:undefined};return(0,s.createAsyncMiddleware)(async(s,r,i)=>{if(s.skipCache)return i();const c=(0,o.cacheTypeForMethod)(s.method),m=n[c];if(!m)return i();if(!m.canCacheRequest(s))return i();const d=(0,o.blockTagForRequest)(s),u=d&&"string"==typeof d?d:"latest";let l;if(a("blockTag = %o, req = %o",u,s),"earliest"===u)l="0x00";else if("latest"===u){a("Fetching latest block number to determine cache key");const n=await e.getLatestBlock();a("Clearing values stored under block numbers before %o",n),t.clearBefore(n),l=n}else l=u;const f=await m.get(s,l);return f===undefined?(a("No cache stored under block number %o, carrying request forward",l),await i(),a("Populating cache with",r),await m.set(s,l,r.result)):(a("Cache hit, reusing cache result stored under block number %o",l),r.result=f),undefined})}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.cjs",{"./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockRefRewriteMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("./utils/cache.cjs");n.createBlockRefRewriteMiddleware=function({blockTracker:e}={}){if(!e)throw Error('BlockRefRewriteMiddleware - mandatory "blockTracker" option is missing.');return(0,s.createAsyncMiddleware)(async(t,n,s)=>{const o=(0,r.blockTagParamIndex)(t.method);if(o===undefined)return s();if("latest"!==(Array.isArray(t.params)&&t.params[o]?t.params[o]:"latest"))return s();const a=await e.getLatestBlock();return Array.isArray(t.params)&&(t.params[o]=a),s()})}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","klona/full":"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/full/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockRefMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("klona/full"),o=e("./logging-utils.cjs"),a=e("./utils/cache.cjs"),i=(0,o.createModuleLogger)(o.projectLogger,"block-ref");n.createBlockRefMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('BlockRefMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('BlockRefMiddleware - mandatory "blockTracker" option is missing.');return(0,s.createAsyncMiddleware)(async(n,s,o)=>{const c=(0,a.blockTagParamIndex)(n.method);if(c===undefined)return o();if("latest"!==(Array.isArray(n.params)?n.params[c]??"latest":"latest"))return i('blockRef is not "latest", carrying request forward'),o();const m=await t.getLatestBlock();i(`blockRef is "latest", setting param ${c} to latest block ${m}`);const d=(0,r.klona)(n);return Array.isArray(d.params)&&(d.params[c]=m),i("Performing another request %o",d),s.result=await e.request(d),undefined})}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createBlockTrackerInspectorMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("./logging-utils.cjs"),o=(0,r.createModuleLogger)(r.projectLogger,"block-tracker-inspector"),a=["eth_getTransactionByHash","eth_getTransactionReceipt"];function i(e){const{result:t}=e;return t&&"object"==typeof t&&(n=t,s="blockNumber",Object.hasOwnProperty.call(n,s))&&"string"==typeof t.blockNumber?t.blockNumber:undefined;var n,s}n.createBlockTrackerInspectorMiddleware=function({blockTracker:e}){return(0,s.createAsyncMiddleware)(async(t,n,s)=>{if(!a.includes(t.method))return s();await s();const r=i(n);if(!r)return undefined;o("res.result.blockNumber exists, proceeding. res = %o",n);return Number.parseInt(r,16)>Number.parseInt(e.getCurrentBlock(),16)&&(o("blockNumber from response is greater than current block number, refreshing current block number"),await e.checkForLatestBlock()),undefined})}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.cjs",{"@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createFetchMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("@metamask/rpc-errors");n.createFetchMiddleware=function({rpcService:e,options:t={}}){return(0,s.createAsyncMiddleware)(async(n,s)=>{const o="originHttpHeaderKey"in t&&t.originHttpHeaderKey!==undefined&&n.origin!==undefined?{[t.originHttpHeaderKey]:n.origin}:{},a=await e.request({id:n.id,jsonrpc:n.jsonrpc,method:n.method,params:n.params},{headers:o});if("error"in a)throw r.rpcErrors.internal({data:a.error});s.result=a.result})}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/index.cjs",{"./block-cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.cjs","./block-ref-rewrite.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.cjs","./block-ref.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.cjs","./block-tracker-inspector.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.cjs","./fetch.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.cjs","./inflight-cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.cjs","./providerAsMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.cjs","./retryOnEmpty.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.cjs","./wallet.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.createFetchMiddleware=void 0,r(e("./block-cache.cjs"),n),r(e("./block-ref-rewrite.cjs"),n),r(e("./block-ref.cjs"),n),r(e("./block-tracker-inspector.cjs"),n);var o=e("./fetch.cjs");Object.defineProperty(n,"createFetchMiddleware",{enumerable:!0,get:function(){return o.createFetchMiddleware}}),r(e("./inflight-cache.cjs"),n),r(e("./providerAsMiddleware.cjs"),n),r(e("./retryOnEmpty.cjs"),n),r(e("./wallet.cjs"),n)}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.cjs",{"./logging-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs","./utils/cache.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","klona/full":"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/full/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createInflightCacheMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("klona/full"),o=e("./logging-utils.cjs"),a=e("./utils/cache.cjs"),i=(0,o.createModuleLogger)(o.projectLogger,"inflight-cache");n.createInflightCacheMiddleware=function(){const e={};return(0,s.createAsyncMiddleware)(async(t,n,s)=>{if(t.skipCache)return s();const o=(0,a.cacheIdentifierForRequest)(t);if(!o)return i("Request is not cacheable, proceeding. req = %o",t),s();let c=e[o];return c?(i("Running %i handler(s) for request %o",c.length,t),await async function(e,t){const{resolve:n,promise:s}=function(){let e;const t=new Promise(t=>{e=t});return{resolve:e,promise:t}}();return t.push(t=>{e.result=(0,r.klona)(t.result),e.error=(0,r.klona)(t.error),n()}),s}(n,c),undefined):(c=[],e[o]=c,i("Carrying original request forward %o",t),await s(),delete e[o],i("Running %i collected handler(s) for request %o",c.length,t),function(e,t){setTimeout(()=>{t.forEach(t=>{try{t(e)}catch(e){console.error(e)}})})}(n,c),undefined)})}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("eth-json-rpc-middleware")}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-request-execution-permissions.cjs",{"../utils/validation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.walletRequestExecutionPermissions=n.RequestExecutionPermissionsStruct=void 0;const s=e("@metamask/rpc-errors"),r=e("@metamask/superstruct"),o=e("@metamask/utils"),a=e("../utils/validation.cjs"),i=(0,r.object)({type:(0,r.string)(),isAdjustmentAllowed:(0,r.boolean)(),data:(0,r.record)((0,r.string)(),(0,r.unknown)())}),c=(0,r.object)({type:(0,r.string)(),isAdjustmentAllowed:(0,r.boolean)(),data:(0,r.record)((0,r.string)(),(0,r.unknown)())}),m=(0,r.object)({type:(0,r.literal)("account"),data:(0,r.object)({address:o.HexChecksumAddressStruct})}),d=(0,r.object)({chainId:o.StrictHexStruct,address:(0,r.optional)(o.HexChecksumAddressStruct),signer:m,permission:i,rules:(0,r.optional)((0,r.union)([(0,r.array)(c),(0,r.literal)(null)]))});n.RequestExecutionPermissionsStruct=(0,r.array)(d),n.walletRequestExecutionPermissions=async function(e,t,{processRequestExecutionPermissions:r}){if(!r)throw s.rpcErrors.methodNotSupported("wallet_requestExecutionPermissions - no middleware configured");const{params:o}=e;(0,a.validateParams)(o,n.RequestExecutionPermissionsStruct),t.result=await r(o,e)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-request-execution-permissions.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-revoke-execution-permission.cjs",{"../utils/validation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.walletRevokeExecutionPermission=n.RevokeExecutionPermissionRequestParamsStruct=n.RevokeExecutionPermissionResultStruct=void 0;const s=e("@metamask/rpc-errors"),r=e("@metamask/utils"),o=e("../utils/validation.cjs");n.RevokeExecutionPermissionResultStruct=(0,r.object)({}),n.RevokeExecutionPermissionRequestParamsStruct=(0,r.object)({permissionContext:r.StrictHexStruct}),n.walletRevokeExecutionPermission=async function(e,t,{processRevokeExecutionPermission:r}){if(!r)throw s.rpcErrors.methodNotSupported("wallet_revokeExecutionPermission - no middleware configured");const{params:a}=e;(0,o.validateParams)(a,n.RevokeExecutionPermissionRequestParamsStruct),t.result=await r(a,e)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-revoke-execution-permission.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.cjs",{"@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use s