LavaPack.loadBundle([[2160,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[2161,{"./build/multichain-openrpc.json":2159,"./build/openrpc.json":2160},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.MultiChainOpenRPCDocument=a.MetaMaskOpenRPCDocument=void 0;const n=s(e("./build/openrpc.json"));a.MetaMaskOpenRPCDocument=n.default;const r=s(e("./build/multichain-openrpc.json"));a.MultiChainOpenRPCDocument=r.default,a.default=n.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],[217,{"webextension-polyfill":5769},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getNotificationImage=async function(){return await n.default.runtime.getURL("../../images/icon-64.png")};var s,n=(s=e("webextension-polyfill"))&&s.__esModule?s:{default:s}}}},{package:"$root$",file:"app/scripts/controllers/push-notifications/get-notification-image.ts"}],[218,{"../../../../shared/lib/translate":5898,"@metamask/notification-services-controller":2289},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createNotificationMessage=function(e){return s.NotificationServicesPushController.Utils.createOnChainPushNotificationMessage(e,i)};var s=e("@metamask/notification-services-controller"),n=e("../../../../shared/lib/translate");const r=(...e)=>(0,n.t)(...e)??"",i={...{pushPlatformNotificationsFundsSentTitle:()=>r("pushPlatformNotificationsFundsSentTitle"),pushPlatformNotificationsFundsSentDescriptionDefault:()=>r("pushPlatformNotificationsFundsSentDescriptionDefault"),pushPlatformNotificationsFundsSentDescription:(e,t)=>r("pushPlatformNotificationsFundsSentDescription",e,t),pushPlatformNotificationsFundsReceivedTitle:()=>r("pushPlatformNotificationsFundsReceivedTitle"),pushPlatformNotificationsFundsReceivedDescriptionDefault:()=>r("pushPlatformNotificationsFundsReceivedDescriptionDefault"),pushPlatformNotificationsFundsReceivedDescription:(e,t)=>r("pushPlatformNotificationsFundsReceivedDescription",e,t),pushPlatformNotificationsSwapCompletedTitle:()=>r("pushPlatformNotificationsSwapCompletedTitle"),pushPlatformNotificationsSwapCompletedDescription:()=>r("pushPlatformNotificationsSwapCompletedDescription"),pushPlatformNotificationsNftSentTitle:()=>r("pushPlatformNotificationsNftSentTitle"),pushPlatformNotificationsNftSentDescription:()=>r("pushPlatformNotificationsNftSentDescription"),pushPlatformNotificationsNftReceivedTitle:()=>r("pushPlatformNotificationsNftReceivedTitle"),pushPlatformNotificationsNftReceivedDescription:()=>r("pushPlatformNotificationsNftReceivedDescription"),pushPlatformNotificationsStakingRocketpoolStakeCompletedTitle:()=>r("pushPlatformNotificationsStakingRocketpoolStakeCompletedTitle"),pushPlatformNotificationsStakingRocketpoolStakeCompletedDescription:()=>r("pushPlatformNotificationsStakingRocketpoolStakeCompletedDescription"),pushPlatformNotificationsStakingRocketpoolUnstakeCompletedTitle:()=>r("pushPlatformNotificationsStakingRocketpoolUnstakeCompletedTitle"),pushPlatformNotificationsStakingRocketpoolUnstakeCompletedDescription:()=>r("pushPlatformNotificationsStakingRocketpoolUnstakeCompletedDescription"),pushPlatformNotificationsStakingLidoStakeCompletedTitle:()=>r("pushPlatformNotificationsStakingLidoStakeCompletedTitle"),pushPlatformNotificationsStakingLidoStakeCompletedDescription:()=>r("pushPlatformNotificationsStakingLidoStakeCompletedDescription"),pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnTitle:()=>r("pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnTitle"),pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnDescription:()=>r("pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnDescription"),pushPlatformNotificationsStakingLidoWithdrawalRequestedTitle:()=>r("pushPlatformNotificationsStakingLidoWithdrawalRequestedTitle"),pushPlatformNotificationsStakingLidoWithdrawalRequestedDescription:()=>r("pushPlatformNotificationsStakingLidoWithdrawalRequestedDescription"),pushPlatformNotificationsStakingLidoWithdrawalCompletedTitle:()=>r("pushPlatformNotificationsStakingLidoWithdrawalCompletedTitle"),pushPlatformNotificationsStakingLidoWithdrawalCompletedDescription:()=>r("pushPlatformNotificationsStakingLidoWithdrawalCompletedDescription")},...{PositionLiquidatedTitle:()=>r("pushNotificationPositionLiquidatedTitle"),PositionLiquidatedDescriptionLong:e=>r("pushNotificationPositionLiquidatedDescriptionLong",e),PositionLiquidatedDescriptionShort:e=>r("pushNotificationPositionLiquidatedDescriptionShort",e),StopLossTriggeredTitle:()=>r("pushNotificationStopLossTriggeredTitle"),StopLossTriggeredDescriptionLong:e=>r("pushNotificationStopLossTriggeredDescriptionLong",e),StopLossTriggeredDescriptionShort:e=>r("pushNotificationStopLossTriggeredDescriptionShort",e),TakeProfitTriggeredTitle:()=>r("pushNotificationTakeProfitTriggeredTitle"),TakeProfitTriggeredDescriptionLong:e=>r("pushNotificationTakeProfitTriggeredDescriptionLong",e),TakeProfitTriggeredDescriptionShort:e=>r("pushNotificationTakeProfitTriggeredDescriptionShort",e),LimitOrderFilledTitle:()=>r("pushNotificationLimitOrderFilledTitle"),LimitOrderFilledDescriptionLong:e=>r("pushNotificationLimitOrderFilledDescriptionLong",e),LimitOrderFilledDescriptionShort:e=>r("pushNotificationLimitOrderFilledDescriptionShort",e)}}}}},{package:"$root$",file:"app/scripts/controllers/push-notifications/get-notification-message.ts"}],[219,{"../../platforms/extension":547,"./get-notification-image":217,"./get-notification-message":218},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.onPushNotificationClicked=async function(e,t){var a;e.notification.close();const s=t??(null==e||null===(a=e.notification)||void 0===a?void 0:a.data),n=`${c.getExtensionURL(null,null)}#notifications/${s.id}`;e.waitUntil(o.clients.openWindow(n))},a.onPushNotificationReceived=async function(e){const t=(0,i.createNotificationMessage)(e);if(!t)return;const a=null==o?void 0:o.registration;if(!a)return;const s=await(0,r.getNotificationImage)();await a.showNotification(t.title,{body:t.description,icon:s,tag:null==e?void 0:e.id,data:e})};var s,n=(s=e("../../platforms/extension"))&&s.__esModule?s:{default:s},r=e("./get-notification-image"),i=e("./get-notification-message");const o=self,c=new n.default}}},{package:"$root$",file:"app/scripts/controllers/push-notifications/index.ts"}],[22,{"../../controllers/network-order":207},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.NetworkOrderControllerInit=void 0;var s=e("../../controllers/network-order");a.NetworkOrderControllerInit=({controllerMessenger:e,persistedState:t})=>({controller:new s.NetworkOrderController({messenger:e,state:{orderedNetworkList:[],...t.NetworkOrderController}})})}}},{package:"$root$",file:"app/scripts/controller-init/assets/network-order-controller-init.ts"}],[220,{"../../../../shared/constants/common":5789,"../../../../shared/constants/gas":5794,"../../../../shared/constants/metametrics":5801,"../../../../shared/constants/network":5805,"../../../../shared/constants/smartTransactions":5815,"../../../../shared/constants/swaps":5820,"../../../../shared/constants/time":5822,"../../../../shared/lib/fetch-with-cache":5872,"../../../../shared/lib/sentry":5886,"../../../../shared/lib/swaps-utils":5890,"../../../../shared/lib/transactions-controller-utils":5895,"../../../../shared/modules/Numeric":5900,"../../../../shared/modules/conversion.utils":5905,"../../../../shared/modules/string-utils":5927,"../../../../shared/modules/swaps.utils":5928,"./swaps.constants":221,"./swaps.utils":222,"@ethersproject/contracts":697,"@ethersproject/providers":735,"@metamask/base-controller":1273,"bignumber.js":3954,"human-standard-token-abi":4590,lodash:4821},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;var s=e("@ethersproject/contracts"),n=e("@ethersproject/providers"),r=e("@metamask/base-controller"),i=e("bignumber.js"),o=P(e("human-standard-token-abi")),c=e("lodash"),l=e("../../../../shared/lib/sentry"),d=e("../../../../shared/constants/common"),u=e("../../../../shared/constants/gas"),m=e("../../../../shared/constants/metametrics"),h=e("../../../../shared/constants/network"),p=e("../../../../shared/constants/smartTransactions"),f=e("../../../../shared/constants/swaps"),b=e("../../../../shared/constants/time"),g=P(e("../../../../shared/lib/fetch-with-cache")),y=e("../../../../shared/lib/swaps-utils"),w=e("../../../../shared/lib/transactions-controller-utils"),v=e("../../../../shared/modules/conversion.utils"),S=e("../../../../shared/modules/Numeric"),E=e("../../../../shared/modules/string-utils"),k=e("../../../../shared/modules/swaps.utils"),T=e("./swaps.constants"),_=e("./swaps.utils");function P(e){return e&&e.__esModule?e:{default:e}}function M(e,t,a){x(e,t),t.set(e,a)}function x(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function A(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function C(e,t){return e.get(R(e,t))}function I(e,t,a){return e.set(R(e,t),a),a}function R(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}const N={swapsState:{includeInStateLogs:!0,persist:!1,anonymous:!1,usedInUi:!0}};var j=new WeakMap,O=new WeakMap,$=new WeakMap,D=new WeakMap,L=new WeakMap,B=new WeakMap,F=new WeakSet;class q extends r.BaseController{constructor(e,t){var a,s,n;super({name:T.controllerName,metadata:N,messenger:e.messenger,state:{swapsState:{...(0,T.getDefaultSwapsControllerState)().swapsState,swapsFeatureFlags:(null==t||null===(a=t.swapsState)||void 0===a?void 0:a.swapsFeatureFlags)||{}}}}),x(s=this,n=F),n.add(s),A(this,"getBufferedGasLimit",void 0),A(this,"resetState",void 0),A(this,"trackMetaMetricsEvent",void 0),M(this,j,void 0),M(this,O,void 0),M(this,$,null),M(this,D,void 0),M(this,L,void 0),M(this,B,void 0),A(this,"_fetchTradesInfo",y.fetchTradesInfo),A(this,"__test__updateState",e=>{this.update(t=>({swapsState:{...t.swapsState,...e.swapsState}}))}),this.messagingSystem.registerActionHandler("SwapsController:fetchAndSetQuotes",this.fetchAndSetQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSelectedQuoteAggId",this.setSelectedQuoteAggId.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:resetSwapsState",this.resetSwapsState.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTokens",this.setSwapsTokens.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:clearSwapsQuotes",this.clearSwapsQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setApproveTxId",this.setApproveTxId.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setTradeTxId",this.setTradeTxId.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxGasPrice",this.setSwapsTxGasPrice.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxGasLimit",this.setSwapsTxGasLimit.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxMaxFeePerGas",this.setSwapsTxMaxFeePerGas.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxMaxFeePriorityPerGas",this.setSwapsTxMaxFeePriorityPerGas.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:safeRefetchQuotes",this.safeRefetchQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:stopPollingForQuotes",this.stopPollingForQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setBackgroundSwapRouteState",this.setBackgroundSwapRouteState.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:resetPostFetchState",this.resetPostFetchState.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsErrorKey",this.setSwapsErrorKey.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setInitialGasEstimate",this.setInitialGasEstimate.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setCustomApproveTxData",this.setCustomApproveTxData.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsLiveness",this.setSwapsLiveness.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsFeatureFlags",this.setSwapsFeatureFlags.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsUserFeeLevel",this.setSwapsUserFeeLevel.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsQuotesPollingLimitEnabled",this.setSwapsQuotesPollingLimitEnabled.bind(this)),this.getBufferedGasLimit=e.getBufferedGasLimit,this.trackMetaMetricsEvent=e.trackMetaMetricsEvent,this.resetState=()=>{this.update(e=>{e.swapsState={...(0,T.getDefaultSwapsControllerState)().swapsState,swapsFeatureFlags:null==e?void 0:e.swapsState.swapsFeatureFlags}})},I(D,this,e.getEIP1559GasFeeEstimates),I(L,this,e.getLayer1GasFee),I(j,this,0),I(O,this,0),this._fetchTradesInfo=e.fetchTradesInfo||y.fetchTradesInfo}clearSwapsQuotes(){this.update(e=>{e.swapsState.quotes={},e.swapsState.selectedAggId=null,e.swapsState.topAggId=null})}async fetchAndSetQuotes(e,t,a=!1){var s;if(!e)return null;let n;n=(null===(s=C(B,this))||void 0===s?void 0:s.clientId)===t.networkClientId?C(B,this):R(F,this,H).call(this,t.networkClientId);const{quotesPollingLimitEnabled:r,saveFetchedQuotes:i}=this.state.swapsState;a||I(O,this,0),C($,this)&&clearTimeout(C($,this)),a||this.setSwapsErrorKey("");const o=C(j,this)+1;I(j,this,o),i||this._setSaveFetchedQuotes(!0);let[l]=await Promise.all([this._fetchTradesInfo(e,{chainId:n.chainId}),this._setSwapsNetworkConfig(n)]);const{saveFetchedQuotes:d}=this.state.swapsState;if(!d)return[{},null];l=(0,c.mapValues)(l,e=>({...e,sourceTokenInfo:null==t?void 0:t.sourceTokenInfo,destinationTokenInfo:null==t?void 0:t.destinationTokenInfo}));const u=n.chainId===h.CHAIN_IDS.OPTIMISM.toString(),m=n.chainId===h.CHAIN_IDS.BASE.toString();(u||m)&&Object.values(l).length>0&&await Promise.all(Object.values(l).map(async e=>{if(e.trade){const t=await C(L,this).call(this,{transactionParams:e.trade,networkClientId:n.clientId});e.multiLayerL1TradeFeeTotal=t}return e}));const p=Date.now();let b=!1;if(!(0,k.isSwapsDefaultTokenAddress)(e.sourceToken,n.chainId)&&Object.values(l).length){const t=await this._getERC20Allowance(e.sourceToken,e.fromAddress,n),[s]=Object.values(l);if(b=s.approvalNeeded&&(t.eq(0)||t.lt(s.sourceAmount))&&"wrappedNative"!==s.aggregator,b){if(!a&&s.approvalNeeded){const{gasLimit:e}=await this._timedoutGasReturn(s.approvalNeeded,s.aggregator);l=(0,c.mapValues)(l,t=>t.approvalNeeded?{...t,approvalNeeded:{...t.approvalNeeded,gas:e||f.DEFAULT_ERC20_APPROVE_GAS}}:t)}}else l=(0,c.mapValues)(l,e=>({...e,approvalNeeded:null}))}let g=null;if(b||null!=e&&e.balanceError||(l=await this._getAllQuotesWithGasEstimates(l)),0===Object.values(l).length)this.setSwapsErrorKey(f.QUOTES_NOT_AVAILABLE_ERROR);else{const e=await this.getTopQuoteWithCalculatedSavings({quotes:l});Array.isArray(e)&&(g=e[0],l=e[1])}if(C(j,this)!==o)throw new Error(f.SWAPS_FETCH_ORDER_CONFLICT);let{selectedAggId:y}=this.state.swapsState;return y&&l[y]||(y=null),this.update(a=>{a.swapsState.quotes=l,a.swapsState.fetchParams={...e,metaData:t},a.swapsState.quotesLastFetched=p,a.swapsState.selectedAggId=y,a.swapsState.topAggId=g}),r&&I(O,this,C(O,this)+1),!r||C(O,this)<T.POLL_COUNT_LIMIT+1?(this._pollForNewQuotes(),[l,g]):(this.resetPostFetchState(),this.setSwapsErrorKey(f.QUOTES_EXPIRED_ERROR),null)}async getTopQuoteWithCalculatedSavings({quotes:e,networkClientId:t}){var a;let s;if(t){const e=this.messagingSystem.call("NetworkController:getNetworkClientById",t);s=e.configuration.chainId}else{if(C(B,this)===undefined)throw new Error("There is no network set");s=C(B,this).chainId}const{marketData:n}=this._getTokenRatesState(),r=(null==n?void 0:n[s])??{},{customGasPrice:o,customMaxPriorityFeePerGas:l}=this.state.swapsState;if(0===Object.keys(e).length)return{};const m=(0,c.cloneDeep)(e),{gasFeeEstimates:h,gasEstimateType:p}=await C(D,this).call(this,{networkClientId:t});let f="0x0";if(p===u.GasEstimateTypes.feeMarket){const{high:{suggestedMaxPriorityFeePerGas:e},estimatedBaseFee:t}=h,a=(0,v.decGWEIToHexWEI)(Number(e)),s=new S.Numeric(t,10,d.EtherDenomination.GWEI).toDenomination(d.EtherDenomination.WEI);f=new S.Numeric(l||a,16).add(s).round(6).toString()}else p===u.GasEstimateTypes.legacy?f=o||(0,v.decGWEIToHexWEI)(Number(h.high)):p===u.GasEstimateTypes.ethGasPrice&&(f=o||(0,v.decGWEIToHexWEI)(Number(h.gasPrice)));let b,g="";Object.values(m).forEach(e=>{const{aggregator:t,approvalNeeded:a,averageGas:n,destinationAmount:o,destinationToken:c,destinationTokenInfo:l,gasEstimateWithRefund:u,sourceAmount:m,sourceToken:h,trade:p,fee:y,multiLayerL1TradeFeeTotal:_}=e;if(!p||!c)return;const P=(u?new i.BigNumber(u,16):new i.BigNumber(n||T.MAX_GAS_LIMIT,10)).plus((null==a?void 0:a.gas)||"0x0",16).toString(16);let M=(0,w.calcGasTotal)(P,f);null!==_&&(M=(0,v.sumHexes)(M||"0x0",_||"0x0"));const x=new S.Numeric(M,16,d.EtherDenomination.WEI).add(new S.Numeric(p.value,16,d.EtherDenomination.WEI)),A=x.toDenomination(d.EtherDenomination.ETH).round(6).value,C=(0,k.isSwapsDefaultTokenAddress)(h,s)?x.minus(new S.Numeric(m,10)).toDenomination(d.EtherDenomination.ETH).round(6).value:A,I=(0,w.calcTokenAmount)(o??"0",l.decimals),R=new i.BigNumber(100,10).minus(y,10).div(100),N=I.div(R).minus(I),j=Object.keys(r).find(e=>(0,E.isEqualCaseInsensitive)(e,c)),O=j?r[j]:null,$=(null==O?void 0:O.price)||1,D=I.times($.toString(10),10),L=(0,k.isSwapsDefaultTokenAddress)(c,s)?1:null==O?void 0:O.price,B=L?D.minus(C,10):D;e.ethFee=C.toString(10),L&&(e.ethValueOfTokens=D.toString(10),e.overallValueOfQuote=B.toString(10),e.metaMaskFeeInEth=N.times(L.toString(10)).toString(10)),b&&!B.gt(b||0)||(g=t,b=B)});const y=Object.keys(r).find(e=>{var t;return(0,E.isEqualCaseInsensitive)(e,null===(t=m[g])||void 0===t?void 0:t.destinationToken)}),P=y?r[y]:null;if((0,k.isSwapsDefaultTokenAddress)(null===(a=m[g])||void 0===a?void 0:a.destinationToken,s)||Boolean(null==P?void 0:P.price)){const e=m[g],{ethFee:t,metaMaskFeeInEth:a,ethValueOfTokens:s}=(0,_.getMedianEthValueQuote)(Object.values(m)),n=new i.BigNumber(e.ethValueOfTokens,10).minus(s,10).toString(10),r=new i.BigNumber(t).minus(e.ethFee,10).toString(10),o=e.metaMaskFeeInEth,c={performance:n,fee:r,total:new i.BigNumber(n).plus(r).minus(o).toString(10),metaMaskFee:o,medianMetaMaskFee:a};m[g].isBestQuote=!0,m[g].savings=c}return[g,m]}resetPostFetchState(){this.update(e=>{e.swapsState={...(0,T.getDefaultSwapsControllerState)().swapsState,tokens:e.swapsState.tokens,fetchParams:e.swapsState.fetchParams,swapsFeatureIsLive:e.swapsState.swapsFeatureIsLive,swapsQuoteRefreshTime:e.swapsState.swapsQuoteRefreshTime,swapsQuotePrefetchingRefreshTime:e.swapsState.swapsQuotePrefetchingRefreshTime,swapsFeatureFlags:e.swapsState.swapsFeatureFlags}}),C($,this)&&clearTimeout(C($,this))}resetSwapsState(){this.update(e=>{e.swapsState={...(0,T.getDefaultSwapsControllerState)().swapsState,swapsQuoteRefreshTime:e.swapsState.swapsQuoteRefreshTime,swapsQuotePrefetchingRefreshTime:e.swapsState.swapsQuotePrefetchingRefreshTime,swapsFeatureFlags:e.swapsState.swapsFeatureFlags}}),C($,this)&&clearTimeout(C($,this))}safeRefetchQuotes(){!C($,this)&&this.state.swapsState.fetchParams&&this.fetchAndSetQuotes(this.state.swapsState.fetchParams,{...this.state.swapsState.fetchParams.metaData})}setApproveTxId(e){this.update(t=>{t.swapsState.approveTxId=e})}setBackgroundSwapRouteState(e){this.update(t=>{t.swapsState.routeState=e})}setCustomApproveTxData(e){this.update(t=>{t.swapsState.customApproveTxData=e})}async setInitialGasEstimate(e){const t={...this.state.swapsState.quotes[e]},{gasLimit:a,simulationFails:s}=t.trade?await this._timedoutGasReturn(t.trade,t.aggregator):{gasLimit:null,simulationFails:!0};if(a&&!s){const e=(0,_.calculateGasEstimateWithRefund)(t.maxGas,t.estimatedRefund,a);t.gasEstimate=a,t.gasEstimateWithRefund=e}this.update(a=>{a.swapsState.quotes={...a.swapsState.quotes,[e]:t}})}setSelectedQuoteAggId(e){this.update(t=>{t.swapsState.selectedAggId=e})}setSwapsFeatureFlags(e){this.update(t=>{t.swapsState.swapsFeatureFlags=e})}setSwapsErrorKey(e){this.update(t=>{t.swapsState.errorKey=e})}setSwapsLiveness(e){const{swapsFeatureIsLive:t}=e;this.update(e=>{e.swapsState.swapsFeatureIsLive=t})}setSwapsQuotesPollingLimitEnabled(e){this.update(t=>{t.swapsState.quotesPollingLimitEnabled=e})}setSwapsTokens(e){this.update(t=>{t.swapsState.tokens=e})}setSwapsTxGasLimit(e){this.update(t=>{t.swapsState.customMaxGas=e})}setSwapsTxGasPrice(e){this.update(t=>{t.swapsState.customGasPrice=e})}setSwapsTxMaxFeePerGas(e){this.update(t=>{t.swapsState.customMaxFeePerGas=e})}setSwapsTxMaxFeePriorityPerGas(e){this.update(t=>{t.swapsState.customMaxPriorityFeePerGas=e})}setSwapsUserFeeLevel(e){this.update(t=>{t.swapsState.swapsUserFeeLevel=e})}setTradeTxId(e){this.update(t=>{t.swapsState.tradeTxId=e})}stopPollingForQuotes(){C($,this)&&clearTimeout(C($,this))}async _fetchSwapsNetworkConfig(e){const t=await(0,g.default)({url:(0,y.getBaseApi)("network",e.chainId),fetchOptions:{method:"GET"},cacheOptions:{cacheRefreshTime:6e5},functionName:"_fetchSwapsNetworkConfig"}),{refreshRates:a,parameters:s={}}=t||{};if(!a||"number"!=typeof a.quotes||"number"!=typeof a.quotesPrefetching)throw new Error(`MetaMask - invalid response for refreshRates: ${t}`);return{quotes:1e3*a.quotes,quotesPrefetching:1e3*a.quotesPrefetching,stxGetTransactions:1e3*a.stxGetTransactions,stxBatchStatus:1e3*a.stxBatchStatus,stxStatusDeadline:a.stxStatusDeadline,stxMaxFeeMultiplier:s.stxMaxFeeMultiplier}}async _getAllQuotesWithGasEstimates(e){const t=await Promise.all(Object.values(e).map(async e=>{if(!e.trade)return{gasLimit:null,simulationFails:!0,aggId:e.aggregator};const{gasLimit:t,simulationFails:a}=await this._timedoutGasReturn(e.trade,e.aggregator);return{gasLimit:t,simulationFails:a,aggId:e.aggregator}})),a={};return t.forEach(({gasLimit:t,simulationFails:s,aggId:n})=>{if(t&&!s){const s=(0,_.calculateGasEstimateWithRefund)(e[n].maxGas,e[n].estimatedRefund,t);a[n]={...e[n],gasEstimate:t,gasEstimateWithRefund:s}}else e[n].approvalNeeded&&(a[n]=e[n])}),a}async _getERC20Allowance(e,t,a){const n=new s.Contract(e,o.default,a.ethersProvider);return await n.allowance(t,f.SWAPS_CHAINID_CONTRACT_ADDRESS_MAP[a.chainId])}_getTokenRatesState(){const{marketData:e}=this.messagingSystem.call("TokenRatesController:getState");return{marketData:e}}_pollForNewQuotes(){const{swapsQuoteRefreshTime:e,swapsQuotePrefetchingRefreshTime:t,quotesPollingLimitEnabled:a}=this.state.swapsState;I($,this,setTimeout(()=>{var e;this.fetchAndSetQuotes(this.state.swapsState.fetchParams,null===(e=this.state.swapsState.fetchParams)||void 0===e?void 0:e.metaData,!0)},a?e:t))}_setSaveFetchedQuotes(e){this.update(t=>{t.swapsState.saveFetchedQuotes=e})}async _setSwapsNetworkConfig(e){let t=null;try{t=await this._fetchSwapsNetworkConfig(e)}catch(e){console.error("Request for Swaps network config failed: ",e)}this.update(e=>{var a,s,n,r,i,o;e.swapsState.swapsQuoteRefreshTime=(null===(a=t)||void 0===a?void 0:a.quotes)||T.FALLBACK_QUOTE_REFRESH_TIME,e.swapsState.swapsQuotePrefetchingRefreshTime=(null===(s=t)||void 0===s?void 0:s.quotesPrefetching)||T.FALLBACK_QUOTE_REFRESH_TIME,e.swapsState.swapsStxGetTransactionsRefreshTime=(null===(n=t)||void 0===n?void 0:n.stxGetTransactions)||p.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,e.swapsState.swapsStxBatchStatusRefreshTime=(null===(r=t)||void 0===r?void 0:r.stxBatchStatus)||p.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,e.swapsState.swapsStxMaxFeeMultiplier=(null===(i=t)||void 0===i?void 0:i.stxMaxFeeMultiplier)||p.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER,e.swapsState.swapsStxStatusDeadline=(null===(o=t)||void 0===o?void 0:o.stxStatusDeadline)||p.FALLBACK_SMART_TRANSACTIONS_DEADLINE})}_timedoutGasReturn(e,t=""){return new Promise(a=>{let s=!1;const n=setTimeout(()=>{s=!0,this.trackMetaMetricsEvent({event:m.MetaMetricsEventName.QuoteError,category:m.MetaMetricsEventCategory.Swaps,properties:{error_type:m.MetaMetricsEventErrorType.GasTimeout,aggregator:t}}),a({gasLimit:null,simulationFails:!0})},5*b.SECOND),r={data:e.data,from:e.from,to:e.to,value:e.value};this.getBufferedGasLimit({txParams:r},1).then(({gasLimit:e,simulationFails:t})=>{s||(clearTimeout(n),a({gasLimit:e,simulationFails:t}))}).catch(e=>{(0,l.captureException)(e,{extra:{aggregator:t}}),s||(clearTimeout(n),a({gasLimit:null,simulationFails:!0}))})})}}function H(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e),{chainId:a}=t.configuration,s={client:t,clientId:e,chainId:a,ethersProvider:new n.Web3Provider(t.provider)};return I(B,this,s),s}a.default=q}}},{package:"$root$",file:"app/scripts/controllers/swaps/index.ts"}],[221,{"../../../../shared/constants/smartTransactions":5815,"../../../../shared/constants/time":5822},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.controllerName=a.POLL_COUNT_LIMIT=a.MAX_GAS_LIMIT=a.FALLBACK_QUOTE_REFRESH_TIME=void 0,a.getDefaultSwapsControllerState=function(){return{swapsState:{quotes:{},quotesPollingLimitEnabled:!1,fetchParams:null,tokens:null,tradeTxId:null,approveTxId:null,quotesLastFetched:null,customMaxGas:"",customGasPrice:null,customMaxFeePerGas:null,customMaxPriorityFeePerGas:null,swapsUserFeeLevel:"",selectedAggId:null,customApproveTxData:"",errorKey:"",topAggId:null,routeState:"",swapsFeatureIsLive:!0,saveFetchedQuotes:!1,swapsQuoteRefreshTime:r,swapsQuotePrefetchingRefreshTime:r,swapsStxBatchStatusRefreshTime:s.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,swapsStxStatusDeadline:s.FALLBACK_SMART_TRANSACTIONS_DEADLINE,swapsStxGetTransactionsRefreshTime:s.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,swapsStxMaxFeeMultiplier:s.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER,swapsFeatureFlags:{}}}};var s=e("../../../../shared/constants/smartTransactions"),n=e("../../../../shared/constants/time");a.controllerName="SwapsController",a.MAX_GAS_LIMIT=25e5,a.POLL_COUNT_LIMIT=3;const r=a.FALLBACK_QUOTE_REFRESH_TIME=n.MINUTE}}},{package:"$root$",file:"app/scripts/controllers/swaps/swaps.constants.ts"}],[222,{"./swaps.constants":221,"bignumber.js":3954},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.calculateGasEstimateWithRefund=function(e=n.MAX_GAS_LIMIT,t="0",a="0"){const r=new s.BigNumber(e,10).minus(t,10),i=r.lt(0);return!i&&r.lt(a,16)?`0x${r.toString(16)}`:a},a.getMedianEthValueQuote=function(e){if(!Array.isArray(e)||0===e.length)throw new Error("Expected non-empty array param.");const t=[...e];if(t.sort((e,t)=>{const a=new s.BigNumber(e.overallValueOfQuote,10),n=new s.BigNumber(t.overallValueOfQuote,10);return a.equals(n)?0:a.lessThan(n)?-1:1}),t.length%2==1){const e=t[(t.length-1)/2].overallValueOfQuote;return r(t.filter(t=>e===t.overallValueOfQuote))}const a=t.length/2,n=a-1,i=t[a].overallValueOfQuote,o=t[n].overallValueOfQuote,c=t.filter(e=>i===e.overallValueOfQuote),l=t.filter(e=>o===e.overallValueOfQuote),d=r(c),u=r(l);return{ethFee:new s.BigNumber(d.ethFee,10).plus(u.ethFee,10).dividedBy(2).toString(10),metaMaskFeeInEth:new s.BigNumber(d.metaMaskFeeInEth,10).plus(u.metaMaskFeeInEth,10).dividedBy(2).toString(10),ethValueOfTokens:new s.BigNumber(d.ethValueOfTokens,10).plus(u.ethValueOfTokens,10).dividedBy(2).toString(10)}},a.meansOfQuotesFeesAndValue=r;var s=e("bignumber.js"),n=e("./swaps.constants");function r(e){const t=e.reduce((e,t)=>({ethFee:e.ethFee.plus(t.ethFee,10),metaMaskFeeInEth:e.metaMaskFeeInEth.plus(t.metaMaskFeeInEth,10),ethValueOfTokens:e.ethValueOfTokens.plus(t.ethValueOfTokens,10)}),{ethFee:new s.BigNumber(0,10),metaMaskFeeInEth:new s.BigNumber(0,10),ethValueOfTokens:new s.BigNumber(0,10)});return{ethFee:t.ethFee.div(e.length,10).toString(10),metaMaskFeeInEth:t.metaMaskFeeInEth.div(e.length,10).toString(10),ethValueOfTokens:t.ethValueOfTokens.div(e.length,10).toString(10)}}}}},{package:"$root$",file:"app/scripts/controllers/swaps/swaps.utils.ts"}],[223,{"../../shared/constants/app":5786,"./lib/util":332,"webextension-polyfill":5769},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.onMessageReceived=a.checkForMultipleVersionsRunning=void 0;var s,n=(s=e("webextension-polyfill"))&&s.__esModule?s:{default:s},r=e("../../shared/constants/app"),i=e("./lib/util");const o="isRunning";a.onMessageReceived=e=>{e===o&&console.warn("Warning! You have multiple instances of MetaMask running!")};a.checkForMultipleVersionsRunning=async()=>{if((0,i.getPlatform)()!==r.PLATFORM_CHROME&&(0,i.getPlatform)()!==r.PLATFORM_FIREFOX)return;const e=(0,i.getPlatform)()===r.PLATFORM_CHROME?r.CHROME_BUILD_IDS:r.FIREFOX_BUILD_IDS,t=n.default.runtime.id;for(const a of e)if(a!==t)try{await n.default.runtime.sendMessage(a,o)}catch(e){}}}}},{package:"$root$",file:"app/scripts/detect-multiple-instances.js"}],[224,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;a.default={config:{}}}}},{package:"$root$",file:"app/scripts/first-time-state.js"}],[2244,{"./constants.cjs":2245,"./utils.cjs":2248,"@metamask/base-controller":1273,"@metamask/controller-utils":1354,"@metamask/keyring-api":2065,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.NetworkEnablementController=void 0;const l=e("@metamask/base-controller"),d=e("@metamask/controller-utils"),u=e("@metamask/keyring-api"),m=e("@metamask/utils"),h=e("./constants.cjs"),p=e("./utils.cjs"),f={enabledNetworkMap:{includeInStateLogs:!0,persist:!0,anonymous:!0,usedInUi:!0}};class b extends l.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:f,name:"NetworkEnablementController",state:{enabledNetworkMap:{[m.KnownCaipNamespace.Eip155]:{[d.ChainId[d.BuiltInNetworkName.Mainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.LineaMainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.BaseMainnet]]:!0},[m.KnownCaipNamespace.Solana]:{[u.SolScope.Mainnet]:!0,[u.SolScope.Testnet]:!1,[u.SolScope.Devnet]:!1},[m.KnownCaipNamespace.Bip122]:{[u.BtcScope.Mainnet]:!0,[u.BtcScope.Testnet]:!1,[u.BtcScope.Signet]:!1},[m.KnownCaipNamespace.Tron]:{[u.TrxScope.Mainnet]:!0,[u.TrxScope.Nile]:!1,[u.TrxScope.Shasta]:!1}},...t}}),s.add(this),e.subscribe("NetworkController:networkAdded",({chainId:e})=>{c(this,s,"m",o).call(this,e)}),e.subscribe("NetworkController:networkRemoved",({chainId:e})=>{c(this,s,"m",i).call(this,e)})}enableNetwork(e){const{namespace:t,storageKey:a}=(0,p.deriveKeys)(e);this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})}),e.enabledNetworkMap[t]&&(e.enabledNetworkMap[t][a]=!0)})}enableNetworkInNamespace(e,t){const{namespace:a,storageKey:r}=(0,p.deriveKeys)(e);if(a!==t)throw new Error(`Chain ID ${e} belongs to namespace ${a}, but namespace ${t} was specified`);this.update(e=>{c(this,s,"m",n).call(this,e,t),e.enabledNetworkMap[t]&&Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1}),e.enabledNetworkMap[t][r]=!0})}enableAllPopularNetworks(){this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})});const t=this.messagingSystem.call("NetworkController:getState"),a=this.messagingSystem.call("MultichainNetworkController:getState");h.POPULAR_NETWORKS.forEach(a=>{const{namespace:r,storageKey:i}=(0,p.deriveKeys)(a);t.networkConfigurationsByChainId[a]&&(c(this,s,"m",n).call(this,e,r),e.enabledNetworkMap[r][i]=!0)});const r=(0,p.deriveKeys)(u.SolScope.Mainnet);a.multichainNetworkConfigurationsByChainId[u.SolScope.Mainnet]&&(c(this,s,"m",n).call(this,e,r.namespace),e.enabledNetworkMap[r.namespace][r.storageKey]=!0);const i=(0,p.deriveKeys)(u.BtcScope.Mainnet);a.multichainNetworkConfigurationsByChainId[u.BtcScope.Mainnet]&&(c(this,s,"m",n).call(this,e,i.namespace),e.enabledNetworkMap[i.namespace][i.storageKey]=!0);const o=(0,p.deriveKeys)(u.TrxScope.Mainnet);a.multichainNetworkConfigurationsByChainId[u.TrxScope.Mainnet]&&(c(this,s,"m",n).call(this,e,o.namespace),e.enabledNetworkMap[o.namespace][o.storageKey]=!0)})}init(){this.update(e=>{const t=this.messagingSystem.call("NetworkController:getState"),a=this.messagingSystem.call("MultichainNetworkController:getState");Object.keys(t.networkConfigurationsByChainId).forEach(t=>{const{namespace:a,storageKey:r}=(0,p.deriveKeys)(t);c(this,s,"m",n).call(this,e,a),e.enabledNetworkMap[a][r]===undefined&&(e.enabledNetworkMap[a][r]=!1)}),Object.keys(a.multichainNetworkConfigurationsByChainId).forEach(t=>{const{namespace:a,storageKey:r}=(0,p.deriveKeys)(t);c(this,s,"m",n).call(this,e,a),e.enabledNetworkMap[a][r]===undefined&&(e.enabledNetworkMap[a][r]=!1)})})}disableNetwork(e){const t=(0,p.deriveKeys)(e),{namespace:a,storageKey:s}=t;this.update(e=>{e.enabledNetworkMap[a][s]=!1})}isNetworkEnabled(e){const t=(0,p.deriveKeys)(e),{namespace:a,storageKey:s}=t;return this.state.enabledNetworkMap[a]?.[s]??!1}}a.NetworkEnablementController=b,s=new WeakSet,n=function(e,t){e.enabledNetworkMap[t]||(e.enabledNetworkMap[t]={})},r=function(){const e=this.messagingSystem.call("NetworkController:getState");return h.POPULAR_NETWORKS.reduce((t,a)=>{if(!e.networkConfigurationsByChainId[a])return t;const{namespace:s,storageKey:n}=(0,p.deriveKeys)(a),r=this.state.enabledNetworkMap[s]?.[n];return r?t+1:t},0)>1},i=function(e){const t=(0,p.deriveKeys)(e),{namespace:a,storageKey:s}=t;this.update(e=>{(0,p.isOnlyNetworkEnabledInNamespace)(this.state,t)&&(e.enabledNetworkMap[a][d.ChainId[d.BuiltInNetworkName.Mainnet]]=!0),a in e.enabledNetworkMap&&delete e.enabledNetworkMap[a][s]})},o=function(e){const{namespace:t,storageKey:a,reference:i}=(0,p.deriveKeys)(e);this.update(e=>{c(this,s,"m",n).call(this,e,t);const o=c(this,s,"m",r).call(this),l=(0,p.isPopularNetwork)(i);o&&l||Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})}),e.enabledNetworkMap[t][a]=!0})}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs"}],[2245,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.POPULAR_NETWORKS=void 0,a.POPULAR_NETWORKS=["0x1","0xe708","0x2105","0xa4b1","0xa86a","0x38","0xa","0x89","0x531","0x144","0x2a15c308d","0x3e7"]}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/constants.cjs"}],[2246,{"./NetworkEnablementController.cjs":2244,"./selectors.cjs":2247},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.selectEnabledSolanaNetworks=a.selectEnabledEvmNetworks=a.selectEnabledNetworksCount=a.selectAllEnabledNetworks=a.createSelectorForEnabledNetworksForNamespace=a.selectIsNetworkEnabled=a.selectEnabledNetworkMap=a.NetworkEnablementController=void 0;var s=e("./NetworkEnablementController.cjs");Object.defineProperty(a,"NetworkEnablementController",{enumerable:!0,get:function(){return s.NetworkEnablementController}});var n=e("./selectors.cjs");Object.defineProperty(a,"selectEnabledNetworkMap",{enumerable:!0,get:function(){return n.selectEnabledNetworkMap}}),Object.defineProperty(a,"selectIsNetworkEnabled",{enumerable:!0,get:function(){return n.selectIsNetworkEnabled}}),Object.defineProperty(a,"createSelectorForEnabledNetworksForNamespace",{enumerable:!0,get:function(){return n.createSelectorForEnabledNetworksForNamespace}}),Object.defineProperty(a,"selectAllEnabledNetworks",{enumerable:!0,get:function(){return n.selectAllEnabledNetworks}}),Object.defineProperty(a,"selectEnabledNetworksCount",{enumerable:!0,get:function(){return n.selectEnabledNetworksCount}}),Object.defineProperty(a,"selectEnabledEvmNetworks",{enumerable:!0,get:function(){return n.selectEnabledEvmNetworks}}),Object.defineProperty(a,"selectEnabledSolanaNetworks",{enumerable:!0,get:function(){return n.selectEnabledSolanaNetworks}})}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/index.cjs"}],[2247,{"./utils.cjs":2248,"@metamask/utils":2913,reselect:5315},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.selectEnabledSolanaNetworks=a.selectEnabledEvmNetworks=a.selectEnabledNetworksCount=a.selectAllEnabledNetworks=a.createSelectorForEnabledNetworksForNamespace=a.selectIsNetworkEnabled=a.selectEnabledNetworkMap=void 0;const s=e("@metamask/utils"),n=e("reselect"),r=e("./utils.cjs");a.selectEnabledNetworkMap=e=>e.enabledNetworkMap;a.selectIsNetworkEnabled=e=>(0,n.createSelector)(a.selectEnabledNetworkMap,t=>{const{namespace:a,storageKey:s}=(0,r.deriveKeys)(e);return a in t&&s in t[a]&&t[a][s]});a.createSelectorForEnabledNetworksForNamespace=e=>(0,n.createSelector)(a.selectEnabledNetworkMap,t=>Object.entries(t[e]??{}).filter(([,e])=>e).map(([e])=>e)),a.selectAllEnabledNetworks=(0,n.createSelector)(a.selectEnabledNetworkMap,e=>Object.keys(e).reduce((t,a)=>(t[a]=Object.entries(e[a]).filter(([,e])=>e).map(([e])=>e),t),{})),a.selectEnabledNetworksCount=(0,n.createSelector)(a.selectAllEnabledNetworks,e=>Object.values(e).flat().length),a.selectEnabledEvmNetworks=(0,n.createSelector)((0,a.createSelectorForEnabledNetworksForNamespace)(s.KnownCaipNamespace.Eip155),e=>e),a.selectEnabledSolanaNetworks=(0,n.createSelector)((0,a.createSelectorForEnabledNetworksForNamespace)(s.KnownCaipNamespace.Solana),e=>e)}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"}],[2248,{"./constants.cjs":2245,"@metamask/controller-utils":1354,"@metamask/multichain-network-controller":2166,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isPopularNetwork=a.isOnlyNetworkEnabledInNamespace=a.deriveKeys=void 0;const s=e("@metamask/controller-utils"),n=e("@metamask/multichain-network-controller"),r=e("@metamask/utils"),i=e("./constants.cjs");a.deriveKeys=function(e){const t=(0,r.isCaipChainId)(e)?e:(0,n.toEvmCaipChainId)(e),{namespace:a,reference:i}=(0,r.parseCaipChainId)(t);let o;return o=a===r.KnownCaipNamespace.Eip155?(0,r.isHexString)(e)?e:(0,s.toHex)(i):t,{namespace:a,storageKey:o,caipChainId:t,reference:i}},a.isOnlyNetworkEnabledInNamespace=function(e,t){const{namespace:a,storageKey:s}=t;if(!e.enabledNetworkMap[a])return!1;const n=e.enabledNetworkMap[a],r=Object.entries(n).filter(([e,t])=>t);if(1===r.length){const[e]=r[0];return e===s}return!1},a.isPopularNetwork=function(e){try{return i.POPULAR_NETWORKS.includes((0,s.toHex)(e))}catch{return!1}}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/utils.cjs"}],[225,{"@metamask/name-controller":2227},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ChangeType=a.AbstractPetnamesBridge=void 0;var s=e("@metamask/name-controller");function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function r(e,t,a){i(e,t),t.set(e,a)}function i(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function o(e,t){return e.get(l(e,t))}function c(e,t,a){return e.set(l(e,t),a),a}function l(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}let d=a.ChangeType=function(e){return e.ADDED="ADDED",e.UPDATED="UPDATED",e.DELETED="DELETED",e}({});var u=function(e){return e.SOURCE_TO_PETNAMES="Source->Petnames",e.PETNAMES_TO_SOURCE="Petnames->Source",e}(u||{});function m({type:e,variation:t,value:a}){return`${e}/${t}/${e===s.NameType.ETHEREUM_ADDRESS?a.toLowerCase():a}`}var h=new WeakMap,p=new WeakMap,f=new WeakMap,b=new WeakSet;function g(e){if(o(f,this)===e)throw new Error(`Attempted to synchronize recursively in same direction: ${e}`);if(null!==o(f,this))return;c(f,this,e);const[t,a]="Source->Petnames"===e?[this.getSourceEntries(),l(b,this,y).call(this)]:[l(b,this,y).call(this),this.getSourceEntries()],s=l(b,this,v).call(this,a,t);l(b,this,S).call(this,s),c(f,this,null)}function y(){const{names:e}=o(p,this).state,t=[];for(const a of Object.values(s.NameType))for(const s of Object.keys(e[a]))for(const n of Object.keys(e[a][s])){const{name:r,sourceId:i,origin:o}=e[a][s][n];if(!r)continue;const c={value:s,type:a,name:r,variation:n,sourceId:i??undefined,origin:o??undefined};this.shouldSyncPetname(c)&&t.push(c)}return t}function w(e,t){e===d.DELETED?(delete t.sourceId,delete t.origin,o(p,this).setName({...t,name:null})):o(p,this).setName(t)}function v(e,t){const a=[],s=[],n=[],r=new Map(e.map(e=>[m(e),e])),i=new Map(t.map(e=>[m(e),e]));return i.forEach((e,t)=>{const n=r.get(t);n?e.name!==n.name&&s.push(e):a.push(e)}),r.forEach((e,t)=>{i.has(t)||n.push(e)}),{[d.ADDED]:a,[d.UPDATED]:s,[d.DELETED]:n}}function S(e){const t=o(f,this)===u.SOURCE_TO_PETNAMES?l(b,this,w).bind(this):this.updateSourceEntry.bind(this);for(const a of Object.values(d))for(const s of e[a])t(a,s)}a.AbstractPetnamesBridge=class{constructor({isTwoWay:e,nameController:t,messenger:a}){var s,o;i(s=this,o=b),o.add(s),r(this,h,void 0),r(this,p,void 0),r(this,f,null),n(this,"messenger",void 0),c(h,this,e),c(p,this,t),this.messenger=a}init(){o(h,this)&&this.messenger.subscribe("NameController:stateChange",()=>l(b,this,g).call(this,u.PETNAMES_TO_SOURCE)),this.onSourceChange(()=>l(b,this,g).call(this,u.SOURCE_TO_PETNAMES))}updateSourceEntry(e,t){throw new Error("updateSourceEntry must be overridden for two-way bridges")}shouldSyncPetname(e){return!0}}}}},{package:"$root$",file:"app/scripts/lib/AbstractPetnamesBridge.ts"}],[226,{"./AbstractPetnamesBridge":225,"@metamask/name-controller":2227},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.AccountIdentitiesPetnamesBridge=void 0;var s=e("@metamask/name-controller"),n=e("./AbstractPetnamesBridge");class r extends n.AbstractPetnamesBridge{constructor({nameController:e,messenger:t}){super({isTwoWay:!1,nameController:e,messenger:t})}getSourceEntries(){return this.messenger.call("AccountsController:listAccounts").map(e=>({value:e.address,type:s.NameType.ETHEREUM_ADDRESS,name:e.metadata.name,sourceId:undefined,variation:s.FALLBACK_VARIATION,origin:s.NameOrigin.ACCOUNT_IDENTITY}))}onSourceChange(e){this.messenger.subscribe("AccountsController:stateChange",e)}shouldSyncPetname(e){return e.origin===s.NameOrigin.ACCOUNT_IDENTITY}}a.AccountIdentitiesPetnamesBridge=r}}},{package:"$root$",file:"app/scripts/lib/AccountIdentitiesPetnamesBridge.ts"}],[227,{"./AbstractPetnamesBridge":225,"@metamask/name-controller":2227,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.AddressBookPetnamesBridge=void 0;var s=e("@metamask/name-controller"),n=e("@metamask/utils"),r=e("./AbstractPetnamesBridge");function i(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function o(e,t){return e.get(c(e,t))}function c(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}var l=new WeakMap;class d extends r.AbstractPetnamesBridge{constructor({addressBookController:e,nameController:t,messenger:a}){var s,n,r;super({isTwoWay:!0,nameController:t,messenger:a}),i(this,l,void 0),n=this,r=e,(s=l).set(c(s,n),r)}getSourceEntries(){const e=[],{state:t}=o(l,this);for(const a of Object.keys(t.addressBook)){if(!(0,n.isStrictHexString)(a))continue;const r=t.addressBook[a];for(const n of Object.keys(r)){const r=t.addressBook[a][n],i=a.toLowerCase(),{name:o,isEns:c}=r;null!=o&&o.length&&null!=n&&n.length&&e.push({value:n,name:o,variation:i,type:s.NameType.ETHEREUM_ADDRESS,sourceId:c?"ens":undefined,origin:s.NameOrigin.ADDRESS_BOOK})}}return e}updateSourceEntry(e,t){e===r.ChangeType.DELETED?o(l,this).delete(t.variation,t.value):o(l,this).set(t.value,t.name,t.variation)}onSourceChange(e){this.messenger.subscribe("AddressBookController:stateChange",e)}}a.AddressBookPetnamesBridge=d}}},{package:"$root$",file:"app/scripts/lib/AddressBookPetnamesBridge.ts"}],[228,{"@metamask/base-controller":1273,"@metamask/obs-store":2317},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;var s=e("@metamask/obs-store"),n=e("@metamask/base-controller");function r(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function i(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}var c=new WeakSet;class l extends s.ObservableStore{constructor({config:e,controllerMessenger:t,state:a,persist:s}){super(a),r(this,c),i(this,"config",{}),this.persist=s,this.controllerMessenger=t,e&&this.updateStructure(e)}updateStructure(e){this.config=e,this.removeAllListeners();const t={};for(const s of Object.keys(e)){var a;if(!e[s])throw new Error(`Undefined '${s}'`);const r=e[s];r.subscribe?e[s].subscribe(e=>{o(c,this,d).call(this,s,e)}):this.persist?this.controllerMessenger.subscribe(`${r.name}:stateChange`,(t,a)=>{o(c,this,u).call(this,e[s].metadata,a)&&o(c,this,d).call(this,s,(0,n.getPersistentState)(t,e[s].metadata),a)}):this.controllerMessenger.subscribe(`${r.name}:stateChange`,(e,t)=>o(c,this,d).call(this,s,e,t));const i=r.state??(null===(a=r.getState)||void 0===a?void 0:a.call(r));t[s]=this.persist&&e[s].metadata?(0,n.getPersistentState)(i,e[s].metadata):i}this.updateState(t)}getFlatState(){if(!this.config)return{};let e={};for(const t of Object.keys(this.config)){const a=this.config[t],s=a.getState?a.getState():a.state;e={...e,...s}}return e}}function d(e,t,a){const s=this.getState()[e];this.updateState({[e]:t}),this.emit("stateChange",{controllerKey:e,newState:t,oldState:s,patches:a})}function u(e,t){return t.some(t=>{if(0===t.path.length)return!0;const a=t.path[0];return!e[a]||e[a].persist})}a.default=l}}},{package:"$root$",file:"app/scripts/lib/ComposableObservableStore.js"}],[2287,{"./push-utils.cjs":2288},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=void 0;var s=e("./push-utils.cjs");Object.defineProperty(a,"createRegToken",{enumerable:!0,get:function(){return s.createRegToken}}),Object.defineProperty(a,"deleteRegToken",{enumerable:!0,get:function(){return s.deleteRegToken}}),Object.defineProperty(a,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return s.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],[2288,{"../../NotificationServicesController/index.cjs":2260,"../../shared/to-raw-notification.cjs":2292,"firebase/app":4394,"firebase/messaging":4395,"firebase/messaging/sw":4396,loglevel:4829},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=a.supportedCache=void 0;const n=e("firebase/app"),r=e("firebase/messaging"),i=e("firebase/messaging/sw"),o=s(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),l=e("../../shared/to-raw-notification.cjs");a.supportedCache=null;const d=async e=>{if(!await(async()=>(a.supportedCache??(a.supportedCache=await(0,i.isSupported)()),a.supportedCache))())return null;const t=await(async e=>{try{return(0,n.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,n.initializeApp)(t)}})(e);return(0,i.getMessaging)(t)};a.createRegToken=async function(e){try{const t=await d(e);if(!t)return null;return await(0,r.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},a.deleteRegToken=async function(e){try{const t=await d(e);return!t||(await(0,r.deleteToken)(t),!0)}catch{return!1}},a.createSubscribeToPushNotifications=function(e){return async function(t){const a=await async function(e,t){const a=await d(e);if(!a)return null;const s=(0,i.onBackgroundMessage)(a,async e=>{try{const a=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!a)return;const s=(0,l.toRawOnChainNotification)(a),n=c.Processors.processNotification(s);await t(n)}catch(t){throw o.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}});return()=>s()}(t,async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)}),s=function(e){const t=t=>{const a=t?.notification?.data;e(t,a)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}((t,a)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",a),e.onClickHandler(t,a)});return()=>{a?.(),s()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],[229,{"webextension-polyfill":5769},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.CronjobControllerStorageManager=a.CronjobControllerStorageKey=void 0;var s,n=(s=e("webextension-polyfill"))&&s.__esModule?s:{default:s};function r(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function i(e,t){return e.get(c(e,t))}function o(e,t,a){return e.set(c(e,t),a),a}function c(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}const l=a.CronjobControllerStorageKey="temp-cronjob-storage";var d=new WeakMap,u=new WeakMap;a.CronjobControllerStorageManager=class{constructor(){r(this,d,null),r(this,u,!1)}async init(){o(d,this,(await n.default.storage.local.get(l))[l]),o(u,this,!0)}getInitialState(){if(!i(u,this))throw new Error("CronjobControllerStorageManager not yet initialized");return i(d,this)}set(e){if(!i(u,this))throw new Error("CronjobControllerStorageManager not yet initialized");n.default.storage.local.set({[l]:e}).catch(console.error)}}}}},{package:"$root$",file:"app/scripts/lib/CronjobControllerStorageManager.ts"}],[23,{"../../../../shared/constants/metametrics":5801,"@metamask/assets-controllers":1203,"@metamask/bridge-controller":1280},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.NftControllerInit=void 0;var s=e("@metamask/assets-controllers"),n=e("@metamask/bridge-controller"),r=e("../../../../shared/constants/metametrics");a.NftControllerInit=({controllerMessenger:e,initMessenger:t,persistedState:a})=>({controller:new s.NftController({state:a.NftController,messenger:e,onNftAdded:({address:e,symbol:a,tokenId:s,standard:i,source:o})=>t.call("MetaMetricsController:trackEvent",{event:r.MetaMetricsEventName.NftAdded,category:r.MetaMetricsEventCategory.Wallet,sensitiveProperties:{token_contract_address:e,token_symbol:a??null,token_id:s,token_standard:i,asset_type:n.AssetType.NFT,source:o}})})})}}},{package:"$root$",file:"app/scripts/controller-init/assets/nft-controller-init.ts"}],[230,{"./state-utils":308,"@metamask/utils":2913,lodash:4821,uuid:5737},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.PatchStore=void 0;var s=e("@metamask/utils"),n=e("uuid"),r=e("lodash"),i=e("./state-utils");function o(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}const c=(0,s.createProjectLogger)("patch-store");a.PatchStore=class{constructor(e){o(this,"id",void 0),o(this,"observableStore",void 0),o(this,"pendingPatches",[]),o(this,"listener",void 0),this.id=(0,n.v4)(),this.observableStore=e,this.listener=this._onStateChange.bind(this),this.observableStore.on("stateChange",this.listener),c("Created",this.id)}flushPendingPatches(){const e=this.pendingPatches;this.pendingPatches=[];for(const t of e)c("Flushed",t.path.join("."),this.id,t);return e}destroy(){this.observableStore.removeListener("stateChange",this.listener),c("Destroyed",this.id)}_onStateChange({newState:e,oldState:t,patches:a}){let s=[];if(a){const e=this._normalizeEventPatches(a,t);s=(0,i.sanitizePatches)(e??[])}else{const a=(0,i.sanitizeUIState)(e);s=this._generatePatches(t,a)}const n=Boolean(e.vault);if(n&&s.push({op:"replace",path:["isInitialized"],value:n}),s.length)for(const e of s){const t=e.path.join(".");this.pendingPatches.push(e),c("Added",t,this.id,e)}}_generatePatches(e,t){return Object.keys(t).map(a=>{const s=e[a],n=t[a];return s===n?null:{op:"replace",path:[a],value:n}}).filter(Boolean)}_normalizeEventPatches(e,t){return null==e?void 0:e.flatMap(e=>{if(e.path.length>0)return[e];return(0,r.uniq)([...Object.keys(t),...Object.keys(e.value)]).map(t=>({op:t in e.value?"replace":"remove",path:[t],...t in e.value?{value:e.value[t]}:{}}))})}}}}},{package:"$root$",file:"app/scripts/lib/PatchStore.ts"}],[231,{"@metamask/name-controller":2227,"@metamask/snaps-rpc-methods":2620,"@metamask/snaps-utils":2790,loglevel:4829},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.SnapsNameProvider=void 0;var s,n=e("@metamask/name-controller"),r=e("@metamask/snaps-utils"),i=(s=e("loglevel"))&&s.__esModule?s:{default:s},o=e("@metamask/snaps-rpc-methods");function c(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function l(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function d(e,t){return e.get(u(e,t))}function u(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}var m=new WeakMap,h=new WeakSet;function p(e){const t=d(m,this).call("PermissionController:getState").subjects;return d(m,this).call("SnapController:getAll").filter(({id:a})=>{var s;const n=null===(s=t[a])||void 0===s?void 0:s.permissions["endowment:name-lookup"];if(!n)return!1;const r=(0,o.getChainIdsCaveat)(n);return!(e&&r&&!r.includes(e))})}async function f(e,t,a){const s=e,n={chainId:t,address:a};let o,c;try{const t=await d(m,this).call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:r.HandlerType.OnNameLookup,request:{jsonrpc:"2.0",method:" ",params:n}}),a=null==t?void 0:t.resolvedDomains;o=a?[...new Set(a.map(e=>e.resolvedDomain))]:[]}catch(t){i.default.error("Snap name provider request failed",{snapId:e,request:n,error:t}),c=t}return{sourceId:s,result:{proposedNames:o,error:c}}}a.SnapsNameProvider=class{constructor({messenger:e}){var t,a,s;!function(e,t){c(e,t),t.add(e)}(this,h),l(this,"name","SnapsNameProvider"),l(this,"state",null),function(e,t,a){c(e,t),t.set(e,a)}(this,m,void 0),a=this,s=e,(t=m).set(u(t,a),s)}getMetadata(){const e=u(h,this,p).call(this);return{sourceIds:{[n.NameType.ETHEREUM_ADDRESS]:e.map(e=>e.id)},sourceLabels:e.reduce((e,t)=>{const a=d(m,this).call("SnapController:get",t.id),s=null==a?void 0:a.manifest.proposedName;return{...e,[t.id]:s||t.id}},{})}}async getProposedNames(e){const{variation:t,value:a}=e,s=`eip155:${parseInt(t,16)}`,n=u(h,this,p).call(this,s);return{results:(await Promise.all(n.map(e=>u(h,this,f).call(this,e.id,s,a)))).reduce((e,t)=>{const{sourceId:a,result:s}=t;return{...e,[a]:s}},{})}}}}}},{package:"$root$",file:"app/scripts/lib/SnapsNameProvider.ts"}],[2313,{"./ObservableStore":2315},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ComposedStore=void 0;const s=e("./ObservableStore");class n extends s.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach(e=>{const t=this._children[e];this._addChild(e,t)})}_addChild(e,t){const a=t=>{const a=this.getState();a[e]=t,this.putState(a)};t.subscribe(a),a(t.getState())}}a.ComposedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],[2314,{"./ObservableStore":2315},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.MergedStore=void 0;const s=e("./ObservableStore");class n extends s.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach(e=>this._addChild(e)),this._updateWholeState()}_addChild(e){e.subscribe(()=>this._updateWholeState())}_updateWholeState(){const e=this._children.map(e=>e.getState()),t=Object.assign({},...e);this.putState(t)}}a.MergedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],[2315,{"@metamask/safe-event-emitter":2492},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.ObservableStore=void 0;const n=s(e("@metamask/safe-event-emitter"));class r extends n.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}a.ObservableStore=r}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],[2316,{"readable-stream":2333},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeAsStream=void 0;const s=e("readable-stream");class n extends s.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const a=super.pipe(e,t);return e.write(this.obsStore.getState()),a}_write(e,t,a){this.obsStore.putState(e),a()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}a.storeAsStream=function(e){return new n(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],[2317,{"./ComposedStore":2313,"./MergedStore":2314,"./ObservableStore":2315,"./asStream":2316,"./transform":2318},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a),Object.defineProperty(e,s,{enumerable:!0,get:function(){return t[a]}})}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./asStream"),a),n(e("./ComposedStore"),a),n(e("./MergedStore"),a),n(e("./ObservableStore"),a),n(e("./transform"),a)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],[2318,{"readable-stream":2333},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeTransformStream=void 0;const s=e("readable-stream");a.storeTransformStream=function(e){return new s.Transform({objectMode:!0,transform:(t,a,s)=>{try{const a=e(t);return s(undefined,a),undefined}catch(e){return s(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],[2319,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s={};function n(e,t,a){a||(a=Error);var n=function(e){var a,s;function n(a,s,n){return e.call(this,function(e,a,s){return"string"==typeof t?t:t(e,a,s)}(a,s,n))||this}return s=e,(a=n).prototype=Object.create(s.prototype),a.prototype.constructor=a,a.__proto__=s,n}(a);n.prototype.name=a.name,n.prototype.code=e,s[e]=n}function r(e,t){if(Array.isArray(e)){var a=e.length;return e=e.map(function(e){return String(e)}),a>2?"one of ".concat(t," ").concat(e.slice(0,a-1).join(", "),", or ")+e[a-1]:2===a?"one of ".concat(t," ").concat(e[0]," or ").concat(e[1]):"of ".concat(t," ").concat(e[0])}return"of ".concat(t," ").concat(String(e))}n("ERR_INVALID_OPT_VALUE",function(e,t){return'The value "'+t+'" is invalid for option "'+e+'"'},TypeError),n("ERR_INVALID_ARG_TYPE",function(e,t,a){var s,n,i,o;if("string"==typeof t&&(n="not ",t.substr(!i||i<0?0:+i,n.length)===n)?(s="must not be",t=t.replace(/^not /,"")):s="must be",function(e,t,a){return(a===undefined||a>e.length)&&(a=e.length),e.substring(a-t.length,a)===t}(e," argument"))o="The ".concat(e," ").concat(s," ").concat(r(t,"type"));else{var c=function(e,t,a){return"number"!=typeof a&&(a=0),!(a+t.length>e.length)&&-1!==e.indexOf(t,a)}(e,".")?"property":"argument";o='The "'.concat(e,'" ').concat(c," ").concat(s," ").concat(r(t,"type"))}return o+=". Received type ".concat(typeof a)},TypeError),n("ERR_STREAM_PUSH_AFTER_EOF","stream.push() after EOF"),n("ERR_METHOD_NOT_IMPLEMENTED",function(e){return"The "+e+" method is not implemented"}),n("ERR_STREAM_PREMATURE_CLOSE","Premature close"),n("ERR_STREAM_DESTROYED",function(e){return"Cannot call "+e+" after a stream was destroyed"}),n("ERR_MULTIPLE_CALLBACK","Callback called multiple times"),n("ERR_STREAM_CANNOT_PIPE","Cannot pipe, not readable"),n("ERR_STREAM_WRITE_AFTER_END","write after end"),n("ERR_STREAM_NULL_VALUES","May not write null values to stream",TypeError),n("ERR_UNKNOWN_ENCODING",function(e){return"Unknown encoding: "+e},TypeError),n("ERR_STREAM_UNSHIFT_AFTER_END_EVENT","stream.unshift() after end event"),t.exports.codes=s}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/errors-browser.js"}],[232,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}Object.defineProperty(a,"__esModule",{value:!0}),a.WeakRefObjectMap=void 0;class n{constructor(){s(this,"map",void 0),this.map=new Map}set(e,t){const a={};for(const e in t){if(!Object.prototype.hasOwnProperty.call(t,e))continue;const s=t[e];if("object"!=typeof s||null===s)throw new Error(`Property ${String(e)} is not an object and cannot be weakly referenced.`);a[e]=new WeakRef(s)}return this.map.set(e,a),this}get(e){const t=this.map.get(e);if(!t)return undefined;const a={};for(const s in t){if(!Object.prototype.hasOwnProperty.call(t,s))continue;const n=t[s].deref();if(n===undefined)return this.map.delete(e),undefined;a[s]=n}return a}has(e){return this.get(e)!==undefined}delete(e){return this.get(e)!==undefined&&this.map.delete(e)}clear(){this.map.clear()}get size(){return this.map.size}entries(){const e=[];return this.map.forEach((t,a)=>{const s=this.get(a);s!==undefined&&e.push([a,s])}),e.values()}keys(){return this.map.keys()}values(){const e=[];return this.map.forEach((t,a)=>{const s=this.get(a);s!==undefined&&e.push(s)}),e.values()}[Symbol.iterator](){return this.entries()}get[Symbol.toStringTag](){return"WeakRefObjectMap"}forEach(e,t){this.map.forEach((a,s)=>{const n=this.get(s);n!==undefined&&(t?e.call(t,n,s,this):e(n,s,this))})}}a.WeakRefObjectMap=n}}},{package:"$root$",file:"app/scripts/lib/WeakRefObjectMap.ts"}],[2320,{"./_stream_readable":2322,"./_stream_writable":2324,_process:5074,inherits:4600},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){var s=Object.keys||function(e){var t=[];for(var a in e)t.push(a);return t};t.exports=l;var n=e("./_stream_readable"),r=e("./_stream_writable");e("inherits")(l,n);for(var i=s(r.prototype),o=0;o<i.length;o++){var c=i[o];l.prototype[c]||(l.prototype[c]=r.prototype[c])}function l(e){if(!(this instanceof l))return new l(e);n.call(this,e),r.call(this,e),this.allowHalfOpen=!0,e&&(!1===e.readable&&(this.readable=!1),!1===e.writable&&(this.writable=!1),!1===e.allowHalfOpen&&(this.allowHalfOpen=!1,this.once("end",d)))}function d(){this._writableState.ended||a.nextTick(u,this)}function u(e){e.end()}Object.defineProperty(l.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(l.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(l.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(l.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed&&this._writableState.destroyed)},set:function(e){this._readableState!==undefined&&this._writableState!==undefined&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_duplex.js"}],[2321,{"./_stream_transform":2323,inherits:4600},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=n;var s=e("./_stream_transform");function n(e){if(!(this instanceof n))return new n(e);s.call(this,e)}e("inherits")(n,s),n.prototype._transform=function(e,t,a){a(null,e)}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_passthrough.js"}],[2322,{"../errors":2319,"./_stream_duplex":2320,"./internal/streams/async_iterator":2325,"./internal/streams/buffer_list":2326,"./internal/streams/destroy":2327,"./internal/streams/from":2329,"./internal/streams/state":2331,"./internal/streams/stream":2332,_process:5074,buffer:4066,events:4366,inherits:4600,"string_decoder/":5673,util:4018},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){var s;t.exports=T,T.ReadableState=k;e("events").EventEmitter;var n=function(e,t){return e.listeners(t).length},r=e("./internal/streams/stream"),i=e("buffer").Buffer,o=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var c,l=e("util");c=l&&l.debuglog?l.debuglog("stream"):function(){};var d,u,m,h=e("./internal/streams/buffer_list"),p=e("./internal/streams/destroy"),f=e("./internal/streams/state").getHighWaterMark,b=e("../errors").codes,g=b.ERR_INVALID_ARG_TYPE,y=b.ERR_STREAM_PUSH_AFTER_EOF,w=b.ERR_METHOD_NOT_IMPLEMENTED,v=b.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;e("inherits")(T,r);var S=p.errorOrDestroy,E=["error","close","destroy","pause","resume"];function k(t,a,n){s=s||e("./_stream_duplex"),t=t||{},"boolean"!=typeof n&&(n=a instanceof s),this.objectMode=!!t.objectMode,n&&(this.objectMode=this.objectMode||!!t.readableObjectMode),this.highWaterMark=f(this,t,"readableHighWaterMark",n),this.buffer=new h,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.paused=!0,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.destroyed=!1,this.defaultEncoding=t.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,t.encoding&&(d||(d=e("string_decoder/").StringDecoder),this.decoder=new d(t.encoding),this.encoding=t.encoding)}function T(t){if(s=s||e("./_stream_duplex"),!(this instanceof T))return new T(t);var a=this instanceof s;this._readableState=new k(t,this,a),this.readable=!0,t&&("function"==typeof t.read&&(this._read=t.read),"function"==typeof t.destroy&&(this._destroy=t.destroy)),r.call(this)}function _(e,t,a,s,n){c("readableAddChunk",t);var r,l=e._readableState;if(null===t)l.reading=!1,function(e,t){if(c("onEofChunk"),t.ended)return;if(t.decoder){var a=t.decoder.end();a&&a.length&&(t.buffer.push(a),t.length+=t.objectMode?1:a.length)}t.ended=!0,t.sync?A(e):(t.needReadable=!1,t.emittedReadable||(t.emittedReadable=!0,C(e)))}(e,l);else if(n||(r=function(e,t){var a;s=t,i.isBuffer(s)||s instanceof o||"string"==typeof t||t===undefined||e.objectMode||(a=new g("chunk",["string","Buffer","Uint8Array"],t));var s;return a}(l,t)),r)S(e,r);else if(l.objectMode||t&&t.length>0)if("string"==typeof t||l.objectMode||Object.getPrototypeOf(t)===i.prototype||(t=function(e){return i.from(e)}(t)),s)l.endEmitted?S(e,new v):P(e,l,t,!0);else if(l.ended)S(e,new y);else{if(l.destroyed)return!1;l.reading=!1,l.decoder&&!a?(t=l.decoder.write(t),l.objectMode||0!==t.length?P(e,l,t,!1):I(e,l)):P(e,l,t,!1)}else s||(l.reading=!1,I(e,l));return!l.ended&&(l.length<l.highWaterMark||0===l.length)}function P(e,t,a,s){t.flowing&&0===t.length&&!t.sync?(t.awaitDrain=0,e.emit("data",a)):(t.length+=t.objectMode?1:a.length,s?t.buffer.unshift(a):t.buffer.push(a),t.needReadable&&A(e)),I(e,t)}Object.defineProperty(T.prototype,"destroyed",{enumerable:!1,get:function(){return this._readableState!==undefined&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),T.prototype.destroy=p.destroy,T.prototype._undestroy=p.undestroy,T.prototype._destroy=function(e,t){t(e)},T.prototype.push=function(e,t){var a,s=this._readableState;return s.objectMode?a=!0:"string"==typeof e&&((t=t||s.defaultEncoding)!==s.encoding&&(e=i.from(e,t),t=""),a=!0),_(this,e,t,!1,a)},T.prototype.unshift=function(e){return _(this,e,null,!0,!1)},T.prototype.isPaused=function(){return!1===this._readableState.flowing},T.prototype.setEncoding=function(t){d||(d=e("string_decoder/").StringDecoder);var a=new d(t);this._readableState.decoder=a,this._readableState.encoding=this._readableState.decoder.encoding;for(var s=this._readableState.buffer.head,n="";null!==s;)n+=a.write(s.data),s=s.next;return this._readableState.buffer.clear(),""!==n&&this._readableState.buffer.push(n),this._readableState.length=n.length,this};var M=1073741824;function x(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=M?e=M:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function A(e){var t=e._readableState;c("emitReadable",t.needReadable,t.emittedReadable),t.needReadable=!1,t.emittedReadable||(c("emitReadable",t.flowing),t.emittedReadable=!0,a.nextTick(C,e))}function C(e){var t=e._readableState;c("emitReadable_",t.destroyed,t.length,t.ended),t.destroyed||!t.length&&!t.ended||(e.emit("readable"),t.emittedReadable=!1),t.needReadable=!t.flowing&&!t.ended&&t.length<=t.highWaterMark,$(e)}function I(e,t){t.readingMore||(t.readingMore=!0,a.nextTick(R,e,t))}function R(e,t){for(;!t.reading&&!t.ended&&(t.length<t.highWaterMark||t.flowing&&0===t.length);){var a=t.length;if(c("maybeReadMore read 0"),e.read(0),a===t.length)break}t.readingMore=!1}function N(e){var t=e._readableState;t.readableListening=e.listenerCount("readable")>0,t.resumeScheduled&&!t.paused?t.flowing=!0:e.listenerCount("data")>0&&e.resume()}function j(e){c("readable nexttick read 0"),e.read(0)}function O(e,t){c("resume",t.reading),t.reading||e.read(0),t.resumeScheduled=!1,e.emit("resume"),$(e),t.flowing&&!t.reading&&e.read(0)}function $(e){var t=e._readableState;for(c("flow",t.flowing);t.flowing&&null!==e.read(););}function D(e,t){return 0===t.length?null:(t.objectMode?a=t.buffer.shift():!e||e>=t.length?(a=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.first():t.buffer.concat(t.length),t.buffer.clear()):a=t.buffer.consume(e,t.decoder),a);var a}function L(e){var t=e._readableState;c("endReadable",t.endEmitted),t.endEmitted||(t.ended=!0,a.nextTick(B,t,e))}function B(e,t){if(c("endReadableNT",e.endEmitted,e.length),!e.endEmitted&&0===e.length&&(e.endEmitted=!0,t.readable=!1,t.emit("end"),e.autoDestroy)){var a=t._writableState;(!a||a.autoDestroy&&a.finished)&&t.destroy()}}function F(e,t){for(var a=0,s=e.length;a<s;a++)if(e[a]===t)return a;return-1}T.prototype.read=function(e){c("read",e),e=parseInt(e,10);var t=this._readableState,a=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&((0!==t.highWaterMark?t.length>=t.highWaterMark:t.length>0)||t.ended))return c("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?L(this):A(this),null;if(0===(e=x(e,t))&&t.ended)return 0===t.length&&L(this),null;var s,n=t.needReadable;return c("need readable",n),(0===t.length||t.length-e<t.highWaterMark)&&c("length less than watermark",n=!0),t.ended||t.reading?c("reading or ended",n=!1):n&&(c("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=x(a,t))),null===(s=e>0?D(e,t):null)?(t.needReadable=t.length<=t.highWaterMark,e=0):(t.length-=e,t.awaitDrain=0),0===t.length&&(t.ended||(t.needReadable=!0),a!==e&&t.ended&&L(this)),null!==s&&this.emit("data",s),s},T.prototype._read=function(e){S(this,new w("_read()"))},T.prototype.pipe=function(e,t){var s=this,r=this._readableState;switch(r.pipesCount){case 0:r.pipes=e;break;case 1:r.pipes=[r.pipes,e];break;default:r.pipes.push(e)}r.pipesCount+=1,c("pipe count=%d opts=%j",r.pipesCount,t);var i=(!t||!1!==t.end)&&e!==a.stdout&&e!==a.stderr?l:b;function o(t,a){c("onunpipe"),t===s&&a&&!1===a.hasUnpiped&&(a.hasUnpiped=!0,c("cleanup"),e.removeListener("close",p),e.removeListener("finish",f),e.removeListener("drain",d),e.removeListener("error",h),e.removeListener("unpipe",o),s.removeListener("end",l),s.removeListener("end",b),s.removeListener("data",m),u=!0,!r.awaitDrain||e._writableState&&!e._writableState.needDrain||d())}function l(){c("onend"),e.end()}r.endEmitted?a.nextTick(i):s.once("end",i),e.on("unpipe",o);var d=function(e){return function(){var t=e._readableState;c("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&n(e,"data")&&(t.flowing=!0,$(e))}}(s);e.on("drain",d);var u=!1;function m(t){c("ondata");var a=e.write(t);c("dest.write",a),!1===a&&((1===r.pipesCount&&r.pipes===e||r.pipesCount>1&&-1!==F(r.pipes,e))&&!u&&(c("false write response, pause",r.awaitDrain),r.awaitDrain++),s.pause())}function h(t){c("onerror",t),b(),e.removeListener("error",h),0===n(e,"error")&&S(e,t)}function p(){e.removeListener("finish",f),b()}function f(){c("onfinish"),e.removeListener("close",p),b()}function b(){c("unpipe"),s.unpipe(e)}return s.on("data",m),function(e,t,a){if("function"==typeof e.prependListener)return e.prependListener(t,a);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(a):e._events[t]=[a,e._events[t]]:e.on(t,a)}(e,"error",h),e.once("close",p),e.once("finish",f),e.emit("pipe",s),r.flowing||(c("pipe resume"),s.resume()),e},T.prototype.unpipe=function(e){var t=this._readableState,a={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,a)),this;if(!e){var s=t.pipes,n=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var r=0;r<n;r++)s[r].emit("unpipe",this,{hasUnpiped:!1});return this}var i=F(t.pipes,e);return-1===i||(t.pipes.splice(i,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,a)),this},T.prototype.on=function(e,t){var s=r.prototype.on.call(this,e,t),n=this._readableState;return"data"===e?(n.readableListening=this.listenerCount("readable")>0,!1!==n.flowing&&this.resume()):"readable"===e&&(n.endEmitted||n.readableListening||(n.readableListening=n.needReadable=!0,n.flowing=!1,n.emittedReadable=!1,c("on readable",n.length,n.reading),n.length?A(this):n.reading||a.nextTick(j,this))),s},T.prototype.addListener=T.prototype.on,T.prototype.removeListener=function(e,t){var s=r.prototype.removeListener.call(this,e,t);return"readable"===e&&a.nextTick(N,this),s},T.prototype.removeAllListeners=function(e){var t=r.prototype.removeAllListeners.apply(this,arguments);return"readable"!==e&&e!==undefined||a.nextTick(N,this),t},T.prototype.resume=function(){var e=this._readableState;return e.flowing||(c("resume"),e.flowing=!e.readableListening,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,a.nextTick(O,e,t))}(this,e)),e.paused=!1,this},T.prototype.pause=function(){return c("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(c("pause"),this._readableState.flowing=!1,this.emit("pause")),this._readableState.paused=!0,this},T.prototype.wrap=function(e){var t=this,a=this._readableState,s=!1;for(var n in e.on("end",function(){if(c("wrapped end"),a.decoder&&!a.ended){var e=a.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(n){(c("wrapped data"),a.decoder&&(n=a.decoder.write(n)),!a.objectMode||null!==n&&n!==undefined)&&((a.objectMode||n&&n.length)&&(t.push(n)||(s=!0,e.pause())))}),e)this[n]===undefined&&"function"==typeof e[n]&&(this[n]=function(t){return function(){return e[t].apply(e,arguments)}}(n));for(var r=0;r<E.length;r++)e.on(E[r],this.emit.bind(this,E[r]));return this._read=function(t){c("wrapped _read",t),s&&(s=!1,e.resume())},this},"function"==typeof Symbol&&(T.prototype[Symbol.asyncIterator]=function(){return u===undefined&&(u=e("./internal/streams/async_iterator")),u(this)}),Object.defineProperty(T.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),Object.defineProperty(T.prototype,"readableBuffer",{enumerable:!1,get:function(){return this._readableState&&this._readableState.buffer}}),Object.defineProperty(T.prototype,"readableFlowing",{enumerable:!1,get:function(){return this._readableState.flowing},set:function(e){this._readableState&&(this._readableState.flowing=e)}}),T._fromList=D,Object.defineProperty(T.prototype,"readableLength",{enumerable:!1,get:function(){return this._readableState.length}}),"function"==typeof Symbol&&(T.from=function(t,a){return m===undefined&&(m=e("./internal/streams/from")),m(T,t,a)})}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_readable.js"}],[2323,{"../errors":2319,"./_stream_duplex":2320,inherits:4600},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=d;var s=e("../errors").codes,n=s.ERR_METHOD_NOT_IMPLEMENTED,r=s.ERR_MULTIPLE_CALLBACK,i=s.ERR_TRANSFORM_ALREADY_TRANSFORMING,o=s.ERR_TRANSFORM_WITH_LENGTH_0,c=e("./_stream_duplex");function l(e,t){var a=this._transformState;a.transforming=!1;var s=a.writecb;if(null===s)return this.emit("error",new r);a.writechunk=null,a.writecb=null,null!=t&&this.push(t),s(e);var n=this._readableState;n.reading=!1,(n.needReadable||n.length<n.highWaterMark)&&this._read(n.highWaterMark)}function d(e){if(!(this instanceof d))return new d(e);c.call(this,e),this._transformState={afterTransform:l.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",u)}function u(){var e=this;"function"!=typeof this._flush||this._readableState.destroyed?m(this,null,null):this._flush(function(t,a){m(e,t,a)})}function m(e,t,a){if(t)return e.emit("error",t);if(null!=a&&e.push(a),e._writableState.length)throw new o;if(e._transformState.transforming)throw new i;return e.push(null)}e("inherits")(d,c),d.prototype.push=function(e,t){return this._transformState.needTransform=!1,c.prototype.push.call(this,e,t)},d.prototype._transform=function(e,t,a){a(new n("_transform()"))},d.prototype._write=function(e,t,a){var s=this._transformState;if(s.writecb=a,s.writechunk=e,s.writeencoding=t,!s.transforming){var n=this._readableState;(s.needTransform||n.needReadable||n.length<n.highWaterMark)&&this._read(n.highWaterMark)}},d.prototype._read=function(e){var t=this._transformState;null===t.writechunk||t.transforming?t.needTransform=!0:(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform))},d.prototype._destroy=function(e,t){c.prototype._destroy.call(this,e,function(e){t(e)})}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_transform.js"}],[2324,{"../errors":2319,"./_stream_duplex":2320,"./internal/streams/destroy":2327,"./internal/streams/state":2331,"./internal/streams/stream":2332,_process:5074,buffer:4066,inherits:4600,"util-deprecate":5733},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){function s(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t,a){var s=e.entry;e.entry=null;for(;s;){var n=s.callback;t.pendingcb--,n(a),s=s.next}t.corkedRequestsFree.next=e}(t,e)}}var n;t.exports=T,T.WritableState=k;var r={deprecate:e("util-deprecate")},i=e("./internal/streams/stream"),o=e("buffer").Buffer,c=("undefined"!=typeof global?global:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){};var l,d=e("./internal/streams/destroy"),u=e("./internal/streams/state").getHighWaterMark,m=e("../errors").codes,h=m.ERR_INVALID_ARG_TYPE,p=m.ERR_METHOD_NOT_IMPLEMENTED,f=m.ERR_MULTIPLE_CALLBACK,b=m.ERR_STREAM_CANNOT_PIPE,g=m.ERR_STREAM_DESTROYED,y=m.ERR_STREAM_NULL_VALUES,w=m.ERR_STREAM_WRITE_AFTER_END,v=m.ERR_UNKNOWN_ENCODING,S=d.errorOrDestroy;function E(){}function k(t,r,i){n=n||e("./_stream_duplex"),t=t||{},"boolean"!=typeof i&&(i=r instanceof n),this.objectMode=!!t.objectMode,i&&(this.objectMode=this.objectMode||!!t.writableObjectMode),this.highWaterMark=u(this,t,"writableHighWaterMark",i),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var o=!1===t.decodeStrings;this.decodeStrings=!o,this.defaultEncoding=t.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var s=e._writableState,n=s.sync,r=s.writecb;if("function"!=typeof r)throw new f;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(s),t)!function(e,t,s,n,r){--t.pendingcb,s?(a.nextTick(r,n),a.nextTick(C,e,t),e._writableState.errorEmitted=!0,S(e,n)):(r(n),e._writableState.errorEmitted=!0,S(e,n),C(e,t))}(e,s,n,t,r);else{var i=x(s)||e.destroyed;i||s.corked||s.bufferProcessing||!s.bufferedRequest||M(e,s),n?a.nextTick(P,e,s,i,r):P(e,s,i,r)}}(r,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.emitClose=!1!==t.emitClose,this.autoDestroy=!!t.autoDestroy,this.bufferedRequestCount=0,this.corkedRequestsFree=new s(this)}function T(t){var a=this instanceof(n=n||e("./_stream_duplex"));if(!a&&!l.call(T,this))return new T(t);this._writableState=new k(t,this,a),this.writable=!0,t&&("function"==typeof t.write&&(this._write=t.write),"function"==typeof t.writev&&(this._writev=t.writev),"function"==typeof t.destroy&&(this._destroy=t.destroy),"function"==typeof t.final&&(this._final=t.final)),i.call(this)}function _(e,t,a,s,n,r,i){t.writelen=s,t.writecb=i,t.writing=!0,t.sync=!0,t.destroyed?t.onwrite(new g("write")):a?e._writev(n,t.onwrite):e._write(n,r,t.onwrite),t.sync=!1}function P(e,t,a,s){a||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,s(),C(e,t)}function M(e,t){t.bufferProcessing=!0;var a=t.bufferedRequest;if(e._writev&&a&&a.next){var n=t.bufferedRequestCount,r=new Array(n),i=t.corkedRequestsFree;i.entry=a;for(var o=0,c=!0;a;)r[o]=a,a.isBuf||(c=!1),a=a.next,o+=1;r.allBuffers=c,_(e,t,!0,t.length,r,"",i.finish),t.pendingcb++,t.lastBufferedRequest=null,i.next?(t.corkedRequestsFree=i.next,i.next=null):t.corkedRequestsFree=new s(t),t.bufferedRequestCount=0}else{for(;a;){var l=a.chunk,d=a.encoding,u=a.callback;if(_(e,t,!1,t.objectMode?1:l.length,l,d,u),a=a.next,t.bufferedRequestCount--,t.writing)break}null===a&&(t.lastBufferedRequest=null)}t.bufferedRequest=a,t.bufferProcessing=!1}function x(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function A(e,t){e._final(function(a){t.pendingcb--,a&&S(e,a),t.prefinished=!0,e.emit("prefinish"),C(e,t)})}function C(e,t){var s=x(t);if(s&&(function(e,t){t.prefinished||t.finalCalled||("function"!=typeof e._final||t.destroyed?(t.prefinished=!0,e.emit("prefinish")):(t.pendingcb++,t.finalCalled=!0,a.nextTick(A,e,t)))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"),t.autoDestroy))){var n=e._readableState;(!n||n.autoDestroy&&n.endEmitted)&&e.destroy()}return s}e("inherits")(T,i),k.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(k.prototype,"buffer",{get:r.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(l=Function.prototype[Symbol.hasInstance],Object.defineProperty(T,Symbol.hasInstance,{value:function(e){return!!l.call(this,e)||this===T&&(e&&e._writableState instanceof k)}})):l=function(e){return e instanceof this},T.prototype.pipe=function(){S(this,new b)},T.prototype.write=function(e,t,s){var n,r=this._writableState,i=!1,l=!r.objectMode&&(n=e,o.isBuffer(n)||n instanceof c);return l&&!o.isBuffer(e)&&(e=function(e){return o.from(e)}(e)),"function"==typeof t&&(s=t,t=null),l?t="buffer":t||(t=r.defaultEncoding),"function"!=typeof s&&(s=E),r.ending?function(e,t){var s=new w;S(e,s),a.nextTick(t,s)}(this,s):(l||function(e,t,s,n){var r;return null===s?r=new y:"string"==typeof s||t.objectMode||(r=new h("chunk",["string","Buffer"],s)),!r||(S(e,r),a.nextTick(n,r),!1)}(this,r,e,s))&&(r.pendingcb++,i=function(e,t,a,s,n,r){if(!a){var i=function(e,t,a){e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=o.from(t,a));return t}(t,s,n);s!==i&&(a=!0,n="buffer",s=i)}var c=t.objectMode?1:s.length;t.length+=c;var l=t.length<t.highWaterMark;l||(t.needDrain=!0);if(t.writing||t.corked){var d=t.lastBufferedRequest;t.lastBufferedRequest={chunk:s,encoding:n,isBuf:a,callback:r,next:null},d?d.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else _(e,t,!1,c,s,n,r);return l}(this,r,l,e,t,s)),i},T.prototype.cork=function(){this._writableState.corked++},T.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||M(this,e))},T.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new v(e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(T.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(T.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),T.prototype._write=function(e,t,a){a(new p("_write()"))},T.prototype._writev=null,T.prototype.end=function(e,t,s){var n=this._writableState;return"function"==typeof e?(s=e,e=null,t=null):"function"==typeof t&&(s=t,t=null),null!==e&&e!==undefined&&this.write(e,t),n.corked&&(n.corked=1,this.uncork()),n.ending||function(e,t,s){t.ending=!0,C(e,t),s&&(t.finished?a.nextTick(s):e.once("finish",s));t.ended=!0,e.writable=!1}(this,n,s),this},Object.defineProperty(T.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(T.prototype,"destroyed",{enumerable:!1,get:function(){return this._writableState!==undefined&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),T.prototype.destroy=d.destroy,T.prototype._undestroy=d.undestroy,T.prototype._destroy=function(e,t){t(e)}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/_stream_writable.js"}],[2325,{"./end-of-stream":2328,_process:5074},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){var s;function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var a=e[Symbol.toPrimitive];if(a!==undefined){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}var r=e("./end-of-stream"),i=Symbol("lastResolve"),o=Symbol("lastReject"),c=Symbol("error"),l=Symbol("ended"),d=Symbol("lastPromise"),u=Symbol("handlePromise"),m=Symbol("stream");function h(e,t){return{value:e,done:t}}function p(e){var t=e[i];if(null!==t){var a=e[m].read();null!==a&&(e[d]=null,e[i]=null,e[o]=null,t(h(a,!1)))}}function f(e){a.nextTick(p,e)}var b=Object.getPrototypeOf(function(){}),g=Object.setPrototypeOf((n(s={get stream(){return this[m]},next:function(){var e=this,t=this[c];if(null!==t)return Promise.reject(t);if(this[l])return Promise.resolve(h(undefined,!0));if(this[m].destroyed)return new Promise(function(t,s){a.nextTick(function(){e[c]?s(e[c]):t(h(undefined,!0))})});var s,n=this[d];if(n)s=new Promise(function(e,t){return function(a,s){e.then(function(){t[l]?a(h(undefined,!0)):t[u](a,s)},s)}}(n,this));else{var r=this[m].read();if(null!==r)return Promise.resolve(h(r,!1));s=new Promise(this[u])}return this[d]=s,s}},Symbol.asyncIterator,function(){return this}),n(s,"return",function(){var e=this;return new Promise(function(t,a){e[m].destroy(null,function(e){e?a(e):t(h(undefined,!0))})})}),s),b);t.exports=function(e){var t,a=Object.create(g,(n(t={},m,{value:e,writable:!0}),n(t,i,{value:null,writable:!0}),n(t,o,{value:null,writable:!0}),n(t,c,{value:null,writable:!0}),n(t,l,{value:e._readableState.endEmitted,writable:!0}),n(t,u,{value:function(e,t){var s=a[m].read();s?(a[d]=null,a[i]=null,a[o]=null,e(h(s,!1))):(a[i]=e,a[o]=t)},writable:!0}),t));return a[d]=null,r(e,function(e){if(e&&"ERR_STREAM_PREMATURE_CLOSE"!==e.code){var t=a[o];return null!==t&&(a[d]=null,a[i]=null,a[o]=null,t(e)),void(a[c]=e)}var s=a[i];null!==s&&(a[d]=null,a[i]=null,a[o]=null,s(h(undefined,!0))),a[l]=!0}),e.on("readable",f.bind(null,a)),a}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/async_iterator.js"}],[2326,{buffer:4066,util:4018},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t){var a=Object.keys(e);if(Object.getOwnPropertySymbols){var s=Object.getOwnPropertySymbols(e);t&&(s=s.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),a.push.apply(a,s)}return a}function n(e){for(var t=1;t<arguments.length;t++){var a=null!=arguments[t]?arguments[t]:{};t%2?s(Object(a),!0).forEach(function(t){r(e,t,a[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(a)):s(Object(a)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(a,t))})}return e}function r(e,t,a){return(t=o(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t){for(var a=0;a<t.length;a++){var s=t[a];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,o(s.key),s)}}function o(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var a=e[Symbol.toPrimitive];if(a!==undefined){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:String(t)}var c=e("buffer").Buffer,l=e("util").inspect,d=l&&l.custom||"inspect";function u(e,t,a){c.prototype.copy.call(e,t,a)}t.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}var t,a,s;return t=e,(a=[{key:"push",value:function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length}},{key:"unshift",value:function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length}},{key:"shift",value:function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}}},{key:"clear",value:function(){this.head=this.tail=null,this.length=0}},{key:"join",value:function(e){if(0===this.length)return"";for(var t=this.head,a=""+t.data;t=t.next;)a+=e+t.data;return a}},{key:"concat",value:function(e){if(0===this.length)return c.alloc(0);for(var t=c.allocUnsafe(e>>>0),a=this.head,s=0;a;)u(a.data,t,s),s+=a.data.length,a=a.next;return t}},{key:"consume",value:function(e,t){var a;return e<this.head.data.length?(a=this.head.data.slice(0,e),this.head.data=this.head.data.slice(e)):a=e===this.head.data.length?this.shift():t?this._getString(e):this._getBuffer(e),a}},{key:"first",value:function(){return this.head.data}},{key:"_getString",value:function(e){var t=this.head,a=1,s=t.data;for(e-=s.length;t=t.next;){var n=t.data,r=e>n.length?n.length:e;if(r===n.length?s+=n:s+=n.slice(0,e),0===(e-=r)){r===n.length?(++a,t.next?this.head=t.next:this.head=this.tail=null):(this.head=t,t.data=n.slice(r));break}++a}return this.length-=a,s}},{key:"_getBuffer",value:function(e){var t=c.allocUnsafe(e),a=this.head,s=1;for(a.data.copy(t),e-=a.data.length;a=a.next;){var n=a.data,r=e>n.length?n.length:e;if(n.copy(t,t.length-e,0,r),0===(e-=r)){r===n.length?(++s,a.next?this.head=a.next:this.head=this.tail=null):(this.head=a,a.data=n.slice(r));break}++s}return this.length-=s,t}},{key:d,value:function(e,t){return l(this,n(n({},t),{},{depth:0,customInspect:!1}))}}])&&i(t.prototype,a),s&&i(t,s),Object.defineProperty(t,"prototype",{writable:!1}),e}()}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/buffer_list.js"}],[2327,{_process:5074},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(e){(function(){function a(e,t){n(e,t),s(e)}function s(e){e._writableState&&!e._writableState.emitClose||e._readableState&&!e._readableState.emitClose||e.emit("close")}function n(e,t){e.emit("error",t)}t.exports={destroy:function(t,r){var i=this,o=this._readableState&&this._readableState.destroyed,c=this._writableState&&this._writableState.destroyed;return o||c?(r?r(t):t&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,e.nextTick(n,this,t)):e.nextTick(n,this,t)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(t||null,function(t){!r&&t?i._writableState?i._writableState.errorEmitted?e.nextTick(s,i):(i._writableState.errorEmitted=!0,e.nextTick(a,i,t)):e.nextTick(a,i,t):r?(e.nextTick(s,i),r(t)):e.nextTick(s,i)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)},errorOrDestroy:function(e,t){var a=e._readableState,s=e._writableState;a&&a.autoDestroy||s&&s.autoDestroy?e.destroy(t):e.emit("error",t)}}}).call(this)}).call(this,e("_process"))}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/destroy.js"}],[2328,{"../../../errors":2319},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=e("../../../errors").codes.ERR_STREAM_PREMATURE_CLOSE;function n(){}t.exports=function e(t,a,r){if("function"==typeof a)return e(t,null,a);a||(a={}),r=function(e){var t=!1;return function(){if(!t){t=!0;for(var a=arguments.length,s=new Array(a),n=0;n<a;n++)s[n]=arguments[n];e.apply(this,s)}}}(r||n);var i=a.readable||!1!==a.readable&&t.readable,o=a.writable||!1!==a.writable&&t.writable,c=function(){t.writable||d()},l=t._writableState&&t._writableState.finished,d=function(){o=!1,l=!0,i||r.call(t)},u=t._readableState&&t._readableState.endEmitted,m=function(){i=!1,u=!0,o||r.call(t)},h=function(e){r.call(t,e)},p=function(){var e;return i&&!u?(t._readableState&&t._readableState.ended||(e=new s),r.call(t,e)):o&&!l?(t._writableState&&t._writableState.ended||(e=new s),r.call(t,e)):void 0},f=function(){t.req.on("finish",d)};return!function(e){return e.setHeader&&"function"==typeof e.abort}(t)?o&&!t._writableState&&(t.on("end",c),t.on("close",c)):(t.on("complete",d),t.on("abort",p),t.req?f():t.on("request",f)),t.on("end",m),t.on("finish",d),!1!==a.error&&t.on("error",h),t.on("close",p),function(){t.removeListener("complete",d),t.removeListener("abort",p),t.removeListener("request",f),t.req&&t.req.removeListener("finish",d),t.removeListener("end",c),t.removeListener("close",c),t.removeListener("finish",d),t.removeListener("end",m),t.removeListener("error",h),t.removeListener("close",p)}}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"}],[2329,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=function(){throw new Error("Readable.from is not available in the browser")}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/from-browser.js"}],[233,{"../../../../shared/constants/app":5786,"@metamask/controller-utils":1354,"@metamask/rpc-errors":2490,"@metamask/snaps-rpc-methods":2620,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.rejectAllApprovals=function({approvalController:e,deleteInterface:t}){const a=e.state.pendingApprovals,s=Object.values(a);for(const a of s)l({approvalController:e,approvalRequest:a,deleteInterface:t})},a.rejectOriginApprovals=function({approvalController:e,deleteInterface:t,origin:a}){const s=e.state.pendingApprovals,n=Object.values(s).filter(e=>e.origin===a);for(const a of n)l({approvalController:e,approvalRequest:a,deleteInterface:t})};var s=e("@metamask/controller-utils"),n=e("@metamask/snaps-rpc-methods"),r=e("@metamask/rpc-errors"),i=e("@metamask/utils"),o=e("../../../../shared/constants/app");const c=(0,i.createProjectLogger)("approval-utils");function l({approvalController:e,approvalRequest:t,deleteInterface:a}){var i;const{id:l,type:d,origin:u}=t,m=null===(i=t.requestData)||void 0===i?void 0:i.id;switch(d){case s.ApprovalType.SnapDialogAlert:case s.ApprovalType.SnapDialogPrompt:case n.DIALOG_APPROVAL_TYPES.default:c("Rejecting snap dialog",{id:l,interfaceId:m,origin:u,type:d}),e.accept(l,null),null==a||a(m);break;case s.ApprovalType.SnapDialogConfirmation:c("Rejecting snap confirmation",{id:l,interfaceId:m,origin:u,type:d}),e.accept(l,!1),null==a||a(m);break;case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect:c("Rejecting snap account confirmation",{id:l,origin:u,type:d}),e.accept(l,!1);break;default:c("Rejecting pending approval",{id:l,origin:u,type:d}),e.reject(l,r.providerErrors.userRejectedRequest({data:{cause:"rejectAllApprovals"}}))}}}}},{package:"$root$",file:"app/scripts/lib/approval/utils.ts"}],[2330,{"../../../errors":2319,"./end-of-stream":2328},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;var n=e("../../../errors").codes,r=n.ERR_MISSING_ARGS,i=n.ERR_STREAM_DESTROYED;function o(e){if(e)throw e}function c(e){e()}function l(e,t){return e.pipe(t)}t.exports=function(){for(var t=arguments.length,a=new Array(t),n=0;n<t;n++)a[n]=arguments[n];var d,u=function(e){return e.length?"function"!=typeof e[e.length-1]?o:e.pop():o}(a);if(Array.isArray(a[0])&&(a=a[0]),a.length<2)throw new r("streams");var m=a.map(function(t,n){var r=n<a.length-1;return function(t,a,n,r){r=function(e){var t=!1;return function(){t||(t=!0,e.apply(void 0,arguments))}}(r);var o=!1;t.on("close",function(){o=!0}),s===undefined&&(s=e("./end-of-stream")),s(t,{readable:a,writable:n},function(e){if(e)return r(e);o=!0,r()});var c=!1;return function(e){if(!o&&!c)return c=!0,function(e){return e.setHeader&&"function"==typeof e.abort}(t)?t.abort():"function"==typeof t.destroy?t.destroy():void r(e||new i("pipe"))}}(t,r,n>0,function(e){d||(d=e),e&&m.forEach(c),r||(m.forEach(c),u(d))})});return a.reduce(l)}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/pipeline.js"}],[2331,{"../../../errors":2319},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=e("../../../errors").codes.ERR_INVALID_OPT_VALUE;t.exports={getHighWaterMark:function(e,t,a,n){var r=function(e,t,a){return null!=e.highWaterMark?e.highWaterMark:t?e[a]:null}(t,n,a);if(null!=r){if(!isFinite(r)||Math.floor(r)!==r||r<0)throw new s(n?a:"highWaterMark",r);return Math.floor(r)}return e.objectMode?16:16384}}}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/state.js"}],[2332,{events:4366},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=e("events").EventEmitter}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/lib/internal/streams/stream-browser.js"}],[2333,{"./lib/_stream_duplex.js":2320,"./lib/_stream_passthrough.js":2321,"./lib/_stream_readable.js":2322,"./lib/_stream_transform.js":2323,"./lib/_stream_writable.js":2324,"./lib/internal/streams/end-of-stream.js":2328,"./lib/internal/streams/pipeline.js":2330},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(a=t.exports=e("./lib/_stream_readable.js")).Stream=a,a.Readable=a,a.Writable=e("./lib/_stream_writable.js"),a.Duplex=e("./lib/_stream_duplex.js"),a.Transform=e("./lib/_stream_transform.js"),a.PassThrough=e("./lib/_stream_passthrough.js"),a.finished=e("./lib/internal/streams/end-of-stream.js"),a.pipeline=e("./lib/internal/streams/pipeline.js")}}},{package:"@metamask/obs-store>readable-stream",file:"node_modules/@metamask/obs-store/node_modules/readable-stream/readable-browser.js"}],[234,{"../../../shared/modules/string-utils":5927},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;var s=e("../../../shared/modules/string-utils");a.default=class{constructor(e={}){const{preferencesController:t,addressBookController:a,accountsController:s,networkController:n,trackMetaMetricsEvent:r}=e;this.preferencesController=t,this.accountsController=s,this.addressBookController=a,this.networkController=n,this._trackMetaMetricsEvent=r}async restoreUserData(e){const t=this.preferencesController.state,{preferences:a,addressBook:s,network:n,internalAccounts:r}=JSON.parse(e);a&&(a.identities=t.identities,a.lostIdentities=t.lostIdentities,a.selectedAddress=t.selectedAddress,this.preferencesController.update(a)),s&&this.addressBookController.update(s,!0),n&&this.networkController.loadBackup(n),r&&this.accountsController.loadBackup(r),(a||s||n||r)&&this._trackMetaMetricsEvent({event:"User Data Imported",category:"Backup"})}async backupUserData(){const e={preferences:{...this.preferencesController.state},internalAccounts:{internalAccounts:this.accountsController.state.internalAccounts},addressBook:{...this.addressBookController.state},network:{networkConfigurationsByChainId:this.networkController.state.networkConfigurationsByChainId}};delete e.preferences.identities,delete e.preferences.lostIdentities,delete e.preferences.selectedAddress;const t=JSON.stringify(e),a=new Date,n=e=>(0,s.prependZero)(e,2);return{fileName:`MetaMaskUserData.${a.getFullYear()}_${n(a.getMonth()+1)}_${n(a.getDay())}_${n(a.getHours())}_${n(a.getMinutes())}_${n(a.getDay())}.json`,data:t}}}}}},{package:"$root$",file:"app/scripts/lib/backup.js"}],[2346,{"./enums.cjs":2347,"@metamask/base-controller":1273,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,d,u,m=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},h=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PermissionLogController=void 0;const p=e("@metamask/base-controller"),f=e("@metamask/utils"),b=e("./enums.cjs"),g={permissionHistory:{},permissionActivityLog:[]};class y extends p.BaseController{constructor({messenger:e,restrictedMethods:t,state:a}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{persist:!0,anonymous:!1},permissionActivityLog:{persist:!1,anonymous:!1}},state:{...g,...a}}),s.add(this),n.set(this,void 0),m(this,n,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const a={eth_accounts:{accounts:h(this,s,"m",r).call(this,t,Date.now())}};h(this,s,"m",l).call(this,e,a)}createMiddleware(){return(e,t,a)=>{const{origin:r,method:l}=e,u=l.startsWith(b.WALLET_PREFIX),m="eth_requestAccounts"===l;if(!b.LOG_IGNORE_METHODS.includes(l)&&(u||h(this,n,"f").has(l))||m){const n=h(this,s,"m",i).call(this,e,u),l=h(this,s,"m",d).call(this,e);return void a(e=>{const a=Date.now();h(this,s,"m",o).call(this,n,t,a),l&&!t.error&&t.result&&r&&h(this,s,"m",c).call(this,l,r,t.result,a,m),e()})}a()}}}a.PermissionLogController=y,n=new WeakMap,s=new WeakSet,r=function(e,t){return e.reduce((e,a)=>({...e,[a]:t}),{})},i=function(e,t){const a={id:e.id,method:e.method,methodType:t?b.LOG_METHOD_TYPES.internal:b.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update(e=>{const t=[...e.permissionActivityLog,a];e.permissionActivityLog=t.length>b.LOG_LIMIT?t.slice(1):t}),a},o=function(e,t,a){e&&t&&this.update(s=>{s.permissionActivityLog=s.permissionActivityLog.map(s=>s.id===e.id?{...s,success:(0,f.hasProperty)(t,"result"),responseTime:a}:s)})},c=function(e,t,a,n,i){let o;if(i){const e=a;o={eth_accounts:{accounts:h(this,s,"m",r).call(this,e,n),lastApproved:n}}}else{o=a.reduce((t,a)=>{const i=a.parentCapability;if(!e.includes(i))return t;if("eth_accounts"===i){const e=h(this,s,"m",u).call(this,a);return{...t,[i]:{lastApproved:n,accounts:h(this,s,"m",r).call(this,e,n)}}}return{...t,[i]:{lastApproved:n}}},{})}Object.keys(o).length>0&&h(this,s,"m",l).call(this,t,o)},l=function(e,t){const{permissionHistory:a}=this.state,s=a[e]??{},n={...s,...t},r=s.eth_accounts,i=t.eth_accounts;if(r&&i){const e=i.lastApproved??r.lastApproved;n.eth_accounts={lastApproved:e,accounts:{...r.accounts,...i.accounts}}}this.update(t=>{t.permissionHistory={...a,[e]:n}})},d=function(e){const{method:t,params:a}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${b.WALLET_PREFIX}requestPermissions`&&a&&Array.isArray(a)&&a[0]&&"object"==typeof a[0]&&!Array.isArray(a[0])?Object.keys(a[0]):null},u=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const a of e.caveats)if(a.type===b.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(a.value))for(const e of a.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],[2347,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;Object.defineProperty(a,"__esModule",{value:!0}),a.LOG_LIMIT=a.LOG_METHOD_TYPES=a.LOG_IGNORE_METHODS=a.CAVEAT_TYPES=a.WALLET_PREFIX=void 0,a.WALLET_PREFIX="wallet_",a.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),a.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(s||(a.LOG_METHOD_TYPES=s={})),a.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],[2348,{"./PermissionLogController.cjs":2346},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./PermissionLogController.cjs"),a)}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],[235,{"@metamask/utils":2913,lodash:4821},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.fetchAccountBalancesInBatches=async function(e){const{addresses:t,supportedChainIds:a,accountApiBaseUrl:n,batchSize:i=50,logger:o}=e,c=a.join(",");return r({items:t,batchSize:i,processBatch:async e=>{const t=a[0],r=e.map(e=>(0,s.toCaipAccountId)("eip155",t,e)).join(","),i=`${n}/v4/multiaccount/balances?networks=${c}&accountAddresses=${r}`,l=await fetch(i,{method:"GET",headers:{Accept:"application/json"}});if(!l.ok)return null==o||o.warn(`Account API batch request failed with status ${l.status}: ${l.statusText}`),null;return await l.json()},mergeResults:e=>{const t={balances:{}};return e.forEach(e=>{Object.assign(t.balances,e.balances)}),t},logger:o})},a.processInBatches=r;var s=e("@metamask/utils"),n=e("lodash");async function r(e){const{items:t,batchSize:a,processBatch:s,mergeResults:r,logger:i}=e;if(0===t.length)return null;const o=(0,n.chunk)(t,a);null==i||i.debug(`Processing ${t.length} items in ${o.length} batches of max ${a} each`);try{const e=await Promise.all(o.map(async(e,t)=>{try{const a=await s(e);return null===a&&(null==i||i.warn(`Batch ${t+1} failed and returned null`)),a}catch(e){return null==i||i.warn(`Batch ${t+1} failed with error: ${String(e)}`),null}})),t=[];for(const a of e)null!==a&&t.push(a);if(t.length<=0)return null==i||i.warn("All batches failed"),null;if(null==i||i.debug(`Successfully processed ${t.length}/${o.length} batches`),r)return r(t);return t[0]||null}catch(e){return null==i||i.warn(`Batch processing failed: ${String(e)}`),null}}}}},{package:"$root$",file:"app/scripts/lib/batch-utils.ts"}],[236,{"../../../shared/constants/time":5822,loglevel:4829,"readable-stream":5283},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.THREE_MINUTES=void 0,a.default=function(){const e=c();return new n.Transform({transform(t,a,s){const n=t.id===undefined,i=e.add(t.id);n||i?s(null,t):(r.default.debug(`RPC request with id "${t.id}" already seen.`),s())},objectMode:!0})};var s,n=e("readable-stream"),r=(s=e("loglevel"))&&s.__esModule?s:{default:s},i=e("../../../shared/constants/time");const o=a.THREE_MINUTES=3*i.MINUTE,c=()=>{const e=new Map;return setInterval(()=>{const t=Date.now()-o;for(const[a,s]of e.entries()){if(!(s<=t))break;e.delete(a)}},o),{add:t=>!e.has(t)&&(e.set(t,Date.now()),!0)}}}}},{package:"$root$",file:"app/scripts/lib/createDupeReqFilterStream.ts"}],[237,{"../../../shared/constants/permissions":5809,"../controllers/permissions":212,"@metamask/keyring-api":2065},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({messenger:e}){return function(t,a,n,r){const o=e.call("AccountsController:getSelectedAccount");if((0,s.isEvmAccountType)(o.type))return n();if(i.includes(t.method))return r(new Error(`Non-EVM account cannot request this method: ${t.method}`));if("wallet_requestPermissions"===t.method&&null!=t&&t.params&&Array.isArray(t.params)&&t.params.length>0&&t.params[0]){const e=Object.keys(t.params[0]);if(i.some(t=>e.includes(t)))return r(new Error(`Non-EVM account cannot request this method: ${e.toString()}`))}return n()}};var s=e("@metamask/keyring-api"),n=e("../../../shared/constants/permissions"),r=e("../controllers/permissions");const i=[...Object.values(n.RestrictedEthMethods),...r.unrestrictedEthSigningMethods]}}},{package:"$root$",file:"app/scripts/lib/createEvmMethodsToNonEvmAccountReqFilterMiddleware.ts"}],[238,{"../../../shared/constants/referrals":5812,"@metamask/json-rpc-engine":1999,loglevel:4829},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.HyperliquidPermissionTriggerType=void 0,a.createHyperliquidReferralMiddleware=function(e){return(0,n.createAsyncMiddleware)(async(t,a,s)=>{if(await s(),!function(e){return Boolean(e.origin)&&Boolean(e.tabId)}(t))return;const n="wallet_requestPermissions"===t.method&&t.origin===i.HYPERLIQUID_ORIGIN,c=Array.isArray(a.result)&&a.result.some(e=>"eth_accounts"===(null==e?void 0:e.parentCapability));n&&c&&e(t.tabId,o.NewConnection).catch(e=>{r.default.error("Failed to handle Hyperliquid referral after wallet_requestPermissions grant: ",e)})})};var s,n=e("@metamask/json-rpc-engine"),r=(s=e("loglevel"))&&s.__esModule?s:{default:s},i=e("../../../shared/constants/referrals");let o=a.HyperliquidPermissionTriggerType=function(e){return e.NewConnection="new_connection",e.OnNavigateConnectedTab="on_navigate_connected_tab",e}({})}}},{package:"$root$",file:"app/scripts/lib/createHyperliquidReferralMiddleware.ts"}],[2382,{"./ppom-controller":2383},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;var s=e("./ppom-controller");Object.defineProperty(a,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return s.NETWORK_CACHE_DURATION}}),Object.defineProperty(a,"PPOMController",{enumerable:!0,get:function(){return s.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],[2383,{"./ppom-storage":2384,"./util":2385,"@metamask/base-controller":1273,"@metamask/controller-utils":1354,"await-semaphore":3892},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,d,u,m,h,p,f,b,g,y,w,v,S,E,k,T,_,P,M,x,A,C,I,R,N,j,O=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},$=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;const D=e("@metamask/base-controller"),L=e("@metamask/controller-utils"),B=e("await-semaphore"),F=e("./ppom-storage"),q=e("./util");a.NETWORK_CACHE_DURATION=6048e5;const H=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],U={versionInfo:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1},storageMetadata:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1}},G="PPOMController",V={headers:{"Content-Type":"application/json"}};class W extends D.BaseController{constructor({chainId:e,messenger:t,provider:a,storageBackend:y,securityAlertsEnabled:w,onPreferencesChange:v,ppomProvider:T,cdnBaseUrl:_,providerRequestLimit:P,state:M,blockaidPublicKey:x,nativeCrypto:A}){super({name:G,metadata:U,messenger:t,state:{versionInfo:M?.versionInfo??[],storageMetadata:M?.storageMetadata??[]}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),u.set(this,0),m.set(this,void 0),h.set(this,void 0),p.set(this,{}),f.set(this,void 0),b.set(this,!1),g.set(this,undefined),O(this,m,(0,q.addHexPrefix)(e),"f"),O(this,r,a,"f"),O(this,c,T,"f"),O(this,i,new F.PPOMStorage({storageBackend:y,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update(t=>{t.storageMetadata=e})}}),"f"),O(this,o,new B.Mutex,"f"),O(this,l,_,"f"),O(this,d,P??300,"f"),O(this,h,w,"f"),O(this,f,x,"f"),O(this,g,A,"f"),v($(this,s,"m",S).bind(this)),$(this,s,"m",E).call(this),$(this,s,"m",k).call(this)}async usePPOM(e,t){const a=t??$(this,m,"f");if(!$(this,h,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,q.blockaidValidationSupportedForNetwork)(a))throw Error(`Blockaid validation not available on network with chainId: ${a}`);return await $(this,o,"f").use(async()=>{const t=await $(this,s,"m",_).call(this,a);O(this,u,0,"f"),O(this,p,{},"f");return{...await e(t),providerRequestsCount:{...$(this,p,"f")}}})}}a.PPOMController=W,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,u=new WeakMap,m=new WeakMap,h=new WeakMap,p=new WeakMap,f=new WeakMap,b=new WeakMap,g=new WeakMap,s=new WeakSet,y=async function(){if($(this,h,"f")&&!$(this,b,"f")){const{ppomInit:e}=$(this,c,"f");await e("./ppom_bg.wasm"),O(this,b,!0,"f")}},w=function(){$(this,s,"m",T).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)});const{storageMetadata:e}=this.state;this.update(e=>{e.versionInfo=[],e.storageMetadata=[]}),$(this,i,"f").deleteAllFiles(e).catch(e=>{console.error(`Error in deleting files: ${e.message}`)})},v=function(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:a}=t.configuration,n=(0,q.addHexPrefix)(a);n!==$(this,m,"f")&&(O(this,m,n,"f"),$(this,s,"m",T).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)}))},S=function(e){const t=e.securityAlertsEnabled;t!==$(this,h,"f")&&(O(this,h,t,"f"),t||$(this,s,"m",w).call(this))},E=function(){this.messagingSystem.registerActionHandler(`${G}:usePPOM`,this.usePPOM.bind(this))},k=function(){const e=$(this,s,"m",v).bind(this);this.messagingSystem.subscribe("NetworkController:networkDidChange",e)},T=async function(){await $(this,o,"f").use(async()=>{$(this,n,"f")&&($(this,n,"f").free(),O(this,n,undefined,"f"))})},_=async function(e){const t=await $(this,s,"m",P).call(this);let a;return($(this,n,"f")===undefined||t)&&(a=await $(this,s,"m",j).call(this,e),$(this,m,"f")===e&&($(this,n,"f")&&$(this,n,"f").free(),O(this,n,a,"f")),$(this,i,"f").syncMetadata(this.state.versionInfo).catch(e=>{console.error(`Error while trying to sync metadata: ${e.message}`)})),a},P=async function(){const e=await $(this,s,"m",I).call(this);return!!e&&(this.update(t=>{t.versionInfo=e}),!0)},M=function(e,t){return e.find(e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum)},x=async function(e){const t=await Promise.all(e.map(async e=>{let t;try{t=await $(this,s,"m",A).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined}));return t?.filter(e=>e?.[1]!==undefined)},A=async function(e){const{storageMetadata:t}=this.state;if($(this,s,"m",M).call(this,t,e))try{return await $(this,i,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,q.checkFilePath)(e.filePath);const a=(0,q.constructURLHref)($(this,l,"f"),e.filePath),n=await $(this,s,"m",R).call(this,a);return await(0,q.validateSignature)(n,e.hashSignature,$(this,f,"f"),e.filePath,$(this,g,"f")),await $(this,i,"f").writeFile({data:n,...e}).catch(e=>{console.error(`Error in writing file: ${e.message}`)}),n},C=async function(e,t={},a="GET"){const s=await(0,L.safelyExecute)(async()=>(0,L.timeoutFetch)(e,{method:a,cache:"no-cache",redirect:"error",...t},1e4),!0),n=304===s?.status;if(!s?.status||s?.status<200||s?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:n,response:s}},I=async function(){const e=(0,q.constructURLHref)($(this,l,"f"),"ppom_version.json"),{cached:t,response:a}=await $(this,s,"m",C).call(this,e,{headers:V});return t&&this.state.versionInfo?.length?undefined:a.json()},R=async function(e){const{response:t}=await $(this,s,"m",C).call(this,e);return await t.arrayBuffer()},N=async function(e,t){if($(this,u,"f")>$(this,d,"f"))return q.PROVIDER_ERRORS.limitExceeded();if(O(this,u,$(this,u,"f")+1,"f"),!H.includes(e))return q.PROVIDER_ERRORS.methodNotSupported();$(this,p,"f")[e]=$(this,p,"f")[e]?Number($(this,p,"f")[e])+1:1;const a=(0,q.createPayload)(e,t);try{const e=await $(this,r,"f").request(a);return{jsonrpc:"2.0",id:a.id,result:e}}catch(e){return{jsonrpc:"2.0",id:a.id,error:e}}},j=async function(e){await $(this,s,"m",y).call(this);const t=this.state.versionInfo.filter(({chainId:t})=>t===e);if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const a=await $(this,s,"m",x).call(this,t);if(a?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:n}=$(this,c,"f");return n.new($(this,s,"m",N).bind(this),a)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],[2384,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},o=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMStorage=void 0;a.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:a}){s.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i(this,s,e,"f"),i(this,n,t,"f"),i(this,r,a,"f")}async syncMetadata(e){const t=o(this,n,"f").call(this),a=[];for(const s of t){try{await this.readFile(s.name,s.chainId)}catch(e){console.error("Error: ",e);continue}e.find(e=>e.name===s.name&&e.chainId===s.chainId&&e.version===s.version&&e.checksum===s.checksum)&&a.push(s)}const i=await o(this,s,"f").dir();for(const{name:e,chainId:t}of i)a.find(a=>a.name===e&&a.chainId===t)||await o(this,s,"f").delete({name:e,chainId:t});return o(this,r,"f").call(this,a),a}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:a}=t;try{await o(this,s,"f").delete({name:e,chainId:a})}catch(t){console.error(`Error in deleting file: ${e}, ${a}`,t)}}}async readFile(e,t){const a=o(this,n,"f").call(this).find(a=>a.name===e&&a.chainId===t);if(!a)throw new Error(`File metadata (${e}, ${t}) not found`);const r=await o(this,s,"f").read({name:e,chainId:t},a.checksum);if(!r)throw new Error(`Storage File (${e}, ${t}) not found`);return r}async writeFile({data:e,name:t,chainId:a,version:i,checksum:c}){await o(this,s,"f").write({name:t,chainId:a},e,c);const l=o(this,n,"f").call(this),d=l.find(e=>e.name===t&&e.chainId===a);d?(d.version=i,d.checksum=c):l.push({name:t,chainId:a,version:i,checksum:c}),o(this,r,"f").call(this,l)}},s=new WeakMap,n=new WeakMap,r=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],[2385,{buffer:4066,"crypto-js":4183,elliptic:4239,"json-rpc-random-id":4637},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(t){(function(){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),r=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&s(t,e,a);return n(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.checkFilePath=a.addHexPrefix=a.constructURLHref=a.validateSignature=a.PROVIDER_ERRORS=a.createPayload=a.IdGenerator=a.blockaidValidationSupportedForNetwork=a.SUPPORTED_NETWORK_CHAINIDS=void 0;const o=r(e("crypto-js")),c=i(e("elliptic")),l=i(e("json-rpc-random-id")),d=c.default.eddsa;a.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};a.blockaidValidationSupportedForNetwork=e=>Object.values(a.SUPPORTED_NETWORK_CHAINIDS).some(t=>t===e),a.IdGenerator=(0,l.default)();a.createPayload=(e,t)=>({id:(0,a.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),a.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};a.validateSignature=async(e,a,s,n,r,i)=>{const c=await(async(e,t,a=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&a){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map(e=>e.toString(16).padStart(2,"0")).join("")}return(0,o.SHA256)(o.default.lib.WordArray.create(e)).toString()})(e,r,i);if(!new d("ed25519").keyFromPublic(s).verify(t.from(c),a))throw Error(`Signature verification failed for file path: ${n}`)};a.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;a.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;a.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],[239,{loglevel:4829},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(t,a,s){s(s=>{a.error&&n.default.debug("Error in RPC response:\n",a),t.isMetamaskInternal||(n.default.info(`RPC (${e.origin}): ${t.method} -> ${a.error?"error":"success"}`),s())})}};var s,n=(s=e("loglevel"))&&s.__esModule?s:{default:s}}}},{package:"$root$",file:"app/scripts/lib/createLoggerMiddleware.js"}],[24,{"@metamask/assets-controllers":1203},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.NftDetectionControllerInit=void 0;var s=e("@metamask/assets-controllers");a.NftDetectionControllerInit=e=>{const{controllerMessenger:t,getController:a}=e,n=()=>a("NftController");return{controller:new s.NftDetectionController({messenger:t,addNft:(...e)=>n().addNft(...e),getNftState:()=>n().state,disabled:!a("PreferencesController").state.useNftDetection})}}}}},{package:"$root$",file:"app/scripts/controller-init/assets/nft-detection-controller-init.ts"}],[240,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({mainFrameOrigin:e}){return function(t,a,s){t.mainFrameOrigin=e,s()}}}}},{package:"$root$",file:"app/scripts/lib/createMainFrameOriginMiddleware.ts"}],[241,{"./stream-utils":313,"@metamask/rpc-errors":2490},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;var s=e("@metamask/rpc-errors"),n=e("./stream-utils");a.default=(e,t)=>async a=>{if(!(0,n.isStreamWritable)(t))return;if(!e[a.method])return void t.write({jsonrpc:"2.0",error:s.rpcErrors.methodNotFound({message:`${a.method} not found`}),id:a.id});let r,i;try{r=await e[a.method](...a.params)}catch(e){i=e}(0,n.isStreamWritable)(t)?i?t.write({jsonrpc:"2.0",error:(0,s.serializeError)(i,{shouldIncludeStack:!0}),id:a.id}):t.write({jsonrpc:"2.0",result:r,id:a.id}):i&&console.error(i)}}}},{package:"$root$",file:"app/scripts/lib/createMetaRPCHandler.js"}],[242,{"./middleware/pending":260,"@metamask/eth-json-rpc-middleware":1780,"@metamask/json-rpc-engine":1999},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({version:e,getAccounts:t,processTransaction:a,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:d,processEncryptionPublicKey:u,getPendingNonce:m,getPendingTransactionByHash:h,processRequestExecutionPermissions:p}){return(0,s.mergeMiddleware)([(0,s.createScaffoldMiddleware)({eth_syncing:!1,web3_clientVersion:`MetaMask/v${e}`}),(0,n.createWalletMiddleware)({getAccounts:t,processTransaction:a,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:d,processEncryptionPublicKey:u,processRequestExecutionPermissions:p}),(0,r.createPendingNonceMiddleware)({getPendingNonce:m}),(0,r.createPendingTxMiddleware)({getPendingTransactionByHash:h})])};var s=e("@metamask/json-rpc-engine"),n=e("@metamask/eth-json-rpc-middleware"),r=e("./middleware/pending")}}},{package:"$root$",file:"app/scripts/lib/createMetamaskMiddleware.js"}],[243,{loglevel:4829,"webextension-polyfill":5769},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({location:e,registerOnboarding:t}){return async function(a,r,i,o){try{if("wallet_registerOnboarding"!==a.method)return void i();a.tabId&&a.tabId!==n.default.tabs.TAB_ID_NONE?await t(e,a.tabId):s.default.debug(`'wallet_registerOnboarding' message from ${e} ignored due to missing tabId`),r.result=!0,o()}catch(e){o(e)}}};var s=r(e("loglevel")),n=r(e("webextension-polyfill"));function r(e){return e&&e.__esModule?e:{default:e}}}}},{package:"$root$",file:"app/scripts/lib/createOnboardingMiddleware.js"}],[244,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(t,a,s){t.origin=e.origin,s()}}}}},{package:"$root$",file:"app/scripts/lib/createOriginMiddleware.js"}],[245,{"../../../shared/constants/app":5786,"@metamask/rpc-errors":2490},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.SPAM_FILTER_ACTIVATED_ERROR=a.REJECTION_THRESHOLD_IN_MS=a.NUMBER_OF_REJECTIONS_THRESHOLD=a.BLOCKING_THRESHOLD_IN_MS=a.BLOCKABLE_METHODS=void 0,a.default=function({getThrottledOriginState:e,updateThrottledOriginState:t}){return function(a,s,n,m){const{method:h,origin:p}=a;if(!c.has(h)||l.includes(p))return void n();!function(e){if(!e)return!1;const t=Date.now(),{rejections:a,lastRejection:s}=e,n=t-s<=o;return a>=r&&n}(e(p))?n(a=>{if("error"in s&&s.error&&u(s.error)){var n;const r=null===(n=s.error)||void 0===n?void 0:n.data;if("rejectAllApprovals"===(null==r?void 0:r.cause))return void a();const o=e(p)||{rejections:0,lastRejection:0},c=Date.now(),l=c-o.lastRejection<i?o.rejections+1:1;t(p,{rejections:l,lastRejection:c})}else{const a=e(p);Boolean(a)&&t(p,{rejections:0,lastRejection:0})}a()}):m(d)}};var s=e("@metamask/rpc-errors"),n=e("../../../shared/constants/app");const r=a.NUMBER_OF_REJECTIONS_THRESHOLD=3,i=a.REJECTION_THRESHOLD_IN_MS=3e4,o=a.BLOCKING_THRESHOLD_IN_MS=6e4,c=a.BLOCKABLE_METHODS=new Set([n.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN,n.MESSAGE_TYPE.ETH_SEND_TRANSACTION,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4,n.MESSAGE_TYPE.PERSONAL_SIGN,n.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN,n.MESSAGE_TYPE.WALLET_SEND_CALLS,n.MESSAGE_TYPE.WATCH_ASSET]),l=["http://127.0.0.1:8080","http://127.0.0.1:8081","http://127.0.0.1:8082","http://localhost:8080","http://localhost:8081","http://localhost:8082"],d=a.SPAM_FILTER_ACTIVATED_ERROR=s.providerErrors.unauthorized("Request blocked due to spam filter."),u=e=>e.code===s.errorCodes.provider.userRejectedRequest}}},{package:"$root$",file:"app/scripts/lib/createOriginThrottlingMiddleware.ts"}],[246,{"../../../shared/constants/app":5786,"../../../shared/constants/metametrics":5801,"../../../shared/constants/security-provider":5813,"../../../shared/constants/signatures":5814,"../../../shared/constants/transaction":5824,"../../../shared/lib/confirmation.utils":5836,"../../../shared/lib/snaps/snaps":5888,"../../../shared/modules/error":5907,"../../../shared/modules/transaction.utils":5929,"../../../ui/helpers/utils/metrics":7067,"./snap-keyring/metrics":301,"@metamask/controller-utils":1354,"@metamask/rpc-errors":2490,"ethereumjs-util":4324},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({rateLimitTimeout:e=3e5,rateLimitSamplePercent:t=.001,globalRateLimitTimeout:a=3e5,globalRateLimitMaxAmount:P=10,getAccountType:M,getDeviceModel:x,getHardwareTypeForMetric:A,snapAndHardwareMessenger:C,appStateController:I,metaMetricsController:R,getHDEntropyIndex:N}){return async function(j,O,$){const{origin:D,method:L,params:B}=j,F=function(e){return[i.MESSAGE_TYPE.WALLET_CREATE_SESSION,i.MESSAGE_TYPE.WALLET_INVOKE_METHOD].includes(e)}(L),q=F?o.MetaMetricsRequestedThrough.MultichainApi:o.MetaMetricsRequestedThrough.EthereumProvider,H=F?o.MetaMetricsEventCategory.MultichainApi:o.MetaMetricsEventCategory.InpageProvider;let U,G=L;var V;L===i.MESSAGE_TYPE.WALLET_INVOKE_METHOD&&(G=null==B||null===(V=B.request)||void 0===V?void 0:V.method,U=null==B?void 0:B.scope);const W=w[G];let K;switch(W){case g.TIMEOUT:K=void 0!==T[G];break;case g.NON_RATE_LIMITED:K=!1;break;case g.BLOCKED:K=!0;break;default:case g.RANDOM_SAMPLE:K=Math.random()>=t}const Y=P>0&&_>=P,J=!0===R.state.participateInMetaMetrics,Q=S[G],z={api_source:q};let X;U&&(z.chain_id_caip=U);const Z=(0,f.isSnapPreinstalled)(D),ee=D!==i.ORIGIN_METAMASK&&!Z&&!K&&!Y&&!0===J;if(ee){var te;const t=Q?Q.REQUESTED:o.MetaMetricsEventName.ProviderMethodCalled;if(t===o.MetaMetricsEventName.SignatureRequested){var ae,se,ne,re,ie;let e;var oe,ce;if(z.signature_type=G,z.hd_entropy_index=N(),(0,r.isValidAddress)(null==j||null===(ae=j.params)||void 0===ae?void 0:ae[1]))e=null==j||null===(oe=j.params)||void 0===oe?void 0:oe[0];else e=null==j||null===(ce=j.params)||void 0===ce?void 0:ce[1];null!==(se=j.securityAlertResponse)&&void 0!==se&&se.providerRequestsCount&&Object.keys(j.securityAlertResponse.providerRequestsCount).forEach(e=>{z[`ppom_${e}_count`]=j.securityAlertResponse.providerRequestsCount[e]}),z.security_alert_response=(null===(ne=j.securityAlertResponse)||void 0===ne?void 0:ne.result_type)??l.BlockaidResultType.NotApplicable,z.security_alert_reason=(null===(re=j.securityAlertResponse)||void 0===re?void 0:re.reason)??l.BlockaidReason.notApplicable,null!==(ie=j.securityAlertResponse)&&void 0!==ie&&ie.description&&(z.security_alert_description=j.securityAlertResponse.description),(0,p.shouldUseRedesignForSignatures)({approvalType:v[G]})&&(z.ui_customizations=[...z.ui_customizations||[],o.MetaMetricsEventUiCustomization.RedesignedConfirmation]);const t=await(0,b.getSnapAndHardwareInfoForMetrics)(M,x,A,C);Object.assign(z,t);try{if(G===i.MESSAGE_TYPE.PERSONAL_SIGN){const{isSIWEMessage:t}=(0,s.detectSIWE)({data:e});t&&(z.ui_customizations=[...z.ui_customizations||[],o.MetaMetricsEventUiCustomization.Siwe])}else if(G===i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4){const t=(0,c.parseTypedDataMessage)(e);X={},z.eip712_primary_type=t.primaryType,X.eip712_verifyingContract=t.domain.verifyingContract,X.eip712_domain_version=t.domain.version,X.eip712_domain_name=t.domain.name,d.PRIMARY_TYPES_PERMIT.includes(t.primaryType)?z.ui_customizations=[...z.ui_customizations||[],o.MetaMetricsEventUiCustomization.Permit]:d.PRIMARY_TYPES_ORDER.includes(t.primaryType)&&(z.ui_customizations=[...z.ui_customizations||[],o.MetaMetricsEventUiCustomization.Order])}}catch(e){console.warn(`createRPCMethodTrackingMiddleware: Errored - ${e}`)}}else z.method=G;const n=E[G];if(n&&(z.params=n(B)),null===(te=k[G])||void 0===te||te.call(k,j,undefined,y.REQUESTED,z),t===o.MetaMetricsEventName.SignatureRequested){!function(e,t,a,s){e.createEventFragment({category:s,initialEvent:o.MetaMetricsEventName.SignatureRequested,successEvent:o.MetaMetricsEventName.SignatureApproved,failureEvent:o.MetaMetricsEventName.SignatureRejected,uniqueIdentifier:(0,h.generateSignatureUniqueId)(t.id),persist:!0,referrer:{url:t.origin},...a})}(R,j,{properties:z,sensitiveProperties:X},H)}else R.trackEvent({event:t,category:H,referrer:{url:D},properties:z});W===g.TIMEOUT&&(T[G]=setTimeout(()=>{delete T[G]},e)),_+=1,setTimeout(()=>{_-=1},a)}$(async e=>{var t,a,s,r;if(!1===ee||void 0===Q)return e();const i=null===(t=O.error)||void 0===t||null===(t=t.data)||void 0===t?void 0:t.location;let c,l;const d=(0,m.getErrorMessage)(O.error);if((null===(a=O.error)||void 0===a?void 0:a.code)===n.errorCodes.provider.userRejectedRequest?(c=Q.REJECTED,l=y.REJECTED):(null===(s=O.error)||void 0===s?void 0:s.code)===n.errorCodes.rpc.internal&&[d,O.error.message].includes("Request rejected by user or snap.")?(c=Q.REJECTED,l=y.REJECTED,z.status=d):(c=Q.APPROVED,l=y.APPROVED),!c)return e();if(null===(r=k[G])||void 0===r||r.call(k,j,O,l,z),Q.REQUESTED===o.MetaMetricsEventName.SignatureRequested){const e=await(0,b.getSnapAndHardwareInfoForMetrics)(M,x,A,C);Object.assign(z,e)}let p={};if(u.SIGNING_METHODS.includes(G)){var f;const e=I.getSignatureSecurityAlertResponse(null===(f=j.securityAlertResponse)||void 0===f?void 0:f.securityAlertId);p=(0,h.getBlockaidMetricsProps)({securityAlertResponse:e})}const g={...z,...p,location:i};if(c===o.MetaMetricsEventName.SignatureRejected||c===o.MetaMetricsEventName.SignatureApproved){const e={abandoned:c===Q.REJECTED},t={properties:{...g,hd_entropy_index:N()},sensitiveProperties:X};!function(e,t,a,s){const n=(0,h.generateSignatureUniqueId)(t.id);e.updateEventFragment(n,s),e.finalizeEventFragment(n,a)}(R,j,e,t)}else R.trackEvent({event:c,category:H,referrer:{url:D},properties:g});return e()})}};var s=e("@metamask/controller-utils"),n=e("@metamask/rpc-errors"),r=e("ethereumjs-util"),i=e("../../../shared/constants/app"),o=e("../../../shared/constants/metametrics"),c=e("../../../shared/modules/transaction.utils"),l=e("../../../shared/constants/security-provider"),d=e("../../../shared/constants/signatures"),u=e("../../../shared/constants/transaction"),m=e("../../../shared/modules/error"),h=e("../../../ui/helpers/utils/metrics"),p=e("../../../shared/lib/confirmation.utils"),f=e("../../../shared/lib/snaps/snaps"),b=e("./snap-keyring/metrics");const g={TIMEOUT:"timeout",BLOCKED:"blocked",NON_RATE_LIMITED:"non_rate_limited",RANDOM_SAMPLE:"random_sample"},y={REQUESTED:"REQUESTED",APPROVED:"APPROVED",REJECTED:"REJECTED"},w={[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.PERSONAL_SIGN]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_DECRYPT]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]:g.TIMEOUT,[i.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]:g.TIMEOUT,[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.SEND_METADATA]:g.BLOCKED,[i.MESSAGE_TYPE.ETH_CHAIN_ID]:g.BLOCKED,[i.MESSAGE_TYPE.ETH_ACCOUNTS]:g.BLOCKED,[i.MESSAGE_TYPE.LOG_WEB3_SHIM_USAGE]:g.BLOCKED,[i.MESSAGE_TYPE.GET_PROVIDER_STATE]:g.BLOCKED,[i.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]:g.NON_RATE_LIMITED,[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:g.NON_RATE_LIMITED},v={[i.MESSAGE_TYPE.PERSONAL_SIGN]:s.ApprovalType.PersonalSign,[i.MESSAGE_TYPE.SIGN]:s.ApprovalType.SignTransaction,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:s.ApprovalType.EthSignTypedData,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1]:s.ApprovalType.EthSignTypedData,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:s.ApprovalType.EthSignTypedData,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:s.ApprovalType.EthSignTypedData},S={[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.PERSONAL_SIGN]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_DECRYPT]:{APPROVED:o.MetaMetricsEventName.DecryptionApproved,REJECTED:o.MetaMetricsEventName.DecryptionRejected,REQUESTED:o.MetaMetricsEventName.DecryptionRequested},[i.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]:{APPROVED:o.MetaMetricsEventName.EncryptionPublicKeyApproved,REJECTED:o.MetaMetricsEventName.EncryptionPublicKeyRejected,REQUESTED:o.MetaMetricsEventName.EncryptionPublicKeyRequested},[i.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called},[i.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called},[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called}},E={[i.MESSAGE_TYPE.WATCH_ASSET]:({type:e})=>({type:e}),[i.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]:([{chainId:e}])=>({chainId:e}),[i.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]:([{chainId:e}])=>({chainId:e})},k={[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:function(e,t,a,s){var n;if(a!==y.REQUESTED)return;const{params:r}=e,i=null==r||null===(n=r[0])||void 0===n||null===(n=n.calls)||void 0===n?void 0:n.length;i&&(s.batch_transaction_count=i)},[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:function(e,t,a,s){if(a===y.REQUESTED){const{params:t}=e,a=(null==t?void 0:t.requiredScopes)||{},n=(null==t?void 0:t.optionalScopes)||{},r=new Set;for(const e of Object.keys(a))r.add(e);for(const e of Object.keys(n))r.add(e);s.chain_id_list=Array.from(r)}else if(a===y.APPROVED){const{result:e}=t,a=Object.keys((null==e?void 0:e.sessionScopes)||{});s.chain_id_list=a}}},T={};let _=0}}},{package:"$root$",file:"app/scripts/lib/createRPCMethodTrackingMiddleware.js"}],[247,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(t,a,s){t.tabId=e.tabId,s()}}}}},{package:"$root$",file:"app/scripts/lib/createTabIdMiddleware.js"}],[2479,{"@metamask/base-controller":1273,"@metamask/rpc-errors":2490,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RateLimitController=void 0;const s=e("@metamask/base-controller"),n=e("@metamask/rpc-errors"),r=e("@metamask/utils"),i="RateLimitController",o={requests:{persist:!1,anonymous:!1}};class c extends s.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:a,state:s,implementations:n}){const c={requests:(0,r.getKnownPropertyNames)(n).reduce((e,t)=>({...e,[t]:{}}),{})};super({name:i,metadata:o,messenger:a,state:{...c,...s}}),this.implementations=n,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messagingSystem.registerActionHandler(`${i}:call`,(e,t,...a)=>this.call(e,t,...a))}async call(e,t,...a){if(this.isRateLimited(t,e))throw n.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const s=this.implementations[t].method;if(!s)throw new Error("Invalid api type");return s(...a)}isRateLimited(e,t){const a=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=a}recordRequest(e,t){const a=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,s=this.state.requests[e][t]??0;this.update(n=>{0===s&&setTimeout(()=>this.resetRequestCount(e,t),a),Object.assign(n,{requests:{...n.requests,[e]:{[t]:s+1}}})})}resetRequestCount(e,t){this.update(a=>{Object.assign(a,{requests:{...a.requests,[e]:{[t]:0}}})})}}a.RateLimitController=c}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],[248,{"../../../shared/constants/app":5786,"../../../shared/lib/trace":5893},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(){return async function(e,t,a){const{id:s,method:o}=e,c=r[o];c&&(e.traceContext=await(0,n.trace)({name:c,id:s,tags:i[o]}),await(0,n.trace)({name:n.TraceName.Middleware,id:s,parentContext:e.traceContext})),a()}};var s=e("../../../shared/constants/app"),n=e("../../../shared/lib/trace");const r={[s.MESSAGE_TYPE.ETH_SEND_TRANSACTION]:n.TraceName.Transaction,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:n.TraceName.Signature,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1]:n.TraceName.Signature,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:n.TraceName.Signature,[s.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:n.TraceName.Signature,[s.MESSAGE_TYPE.PERSONAL_SIGN]:n.TraceName.Signature},i={[s.MESSAGE_TYPE.ETH_SEND_TRANSACTION]:{source:"dapp"}}}}},{package:"$root$",file:"app/scripts/lib/createTracingMiddleware.ts"}],[2480,{"./RateLimitController.cjs":2479},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RateLimitController=void 0;var s=e("./RateLimitController.cjs");Object.defineProperty(a,"RateLimitController",{enumerable:!0,get:function(){return s.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],[2481,{"../constants.cjs":2482,"@metamask/controller-utils":1354},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},l=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ClientConfigApiService=void 0;const d=e("@metamask/controller-utils"),u=e("../constants.cjs");a.ClientConfigApiService=class{constructor({fetch:e,retries:t=d.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:a=d.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:u=d.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:m,onDegraded:h,config:p}){s.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c(this,s,e,"f"),c(this,r,p.client,"f"),c(this,i,p.distribution,"f"),c(this,o,p.environment,"f"),c(this,n,(0,d.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:a,circuitBreakDuration:u}),"f"),m&&l(this,n,"f").onBreak(m),h&&l(this,n,"f").onDegraded(h)}onBreak(...e){return l(this,n,"f").onBreak(...e)}onDegraded(...e){return l(this,n,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${u.BASE_URL}/flags?client=${l(this,r,"f")}&distribution=${l(this,i,"f")}&environment=${l(this,o,"f")}`,t=await l(this,n,"f").execute(()=>l(this,s,"f").call(this,e,{cache:"no-cache"}));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const a=await t.json();if(!Array.isArray(a))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(a),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce((e,t)=>({...e,...t}),{})}},s=new WeakMap,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],[2482,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.BASE_URL=void 0,a.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],[2483,{"./client-config-api-service/client-config-api-service.cjs":2481,"./remote-feature-flag-controller-types.cjs":2484,"./remote-feature-flag-controller.cjs":2485,"./utils/user-segmentation-utils.cjs":2486},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.generateDeterministicRandomNumber=a.ClientConfigApiService=a.EnvironmentType=a.DistributionType=a.ClientType=a.RemoteFeatureFlagController=void 0;var s=e("./remote-feature-flag-controller.cjs");Object.defineProperty(a,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return s.RemoteFeatureFlagController}});var n=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(a,"ClientType",{enumerable:!0,get:function(){return n.ClientType}}),Object.defineProperty(a,"DistributionType",{enumerable:!0,get:function(){return n.DistributionType}}),Object.defineProperty(a,"EnvironmentType",{enumerable:!0,get:function(){return n.EnvironmentType}});var r=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(a,"ClientConfigApiService",{enumerable:!0,get:function(){return r.ClientConfigApiService}});var i=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(a,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return i.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],[2484,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r;Object.defineProperty(a,"__esModule",{value:!0}),a.EnvironmentType=a.DistributionType=a.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(s||(a.ClientType=s={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(n||(a.DistributionType=n={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev",e.Beta="beta",e.Test="test",e.Exp="exp"}(r||(a.EnvironmentType=r={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],[2485,{"./utils/user-segmentation-utils.cjs":2486,"@metamask/base-controller":1273},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,d,u,m=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},h=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.RemoteFeatureFlagController=a.getDefaultRemoteFeatureFlagControllerState=a.DEFAULT_CACHE_DURATION=a.controllerName=void 0;const p=e("@metamask/base-controller"),f=e("./utils/user-segmentation-utils.cjs");a.controllerName="RemoteFeatureFlagController",a.DEFAULT_CACHE_DURATION=864e5;const b={remoteFeatureFlags:{includeInStateLogs:!0,persist:!0,anonymous:!0,usedInUi:!0},cacheTimestamp:{includeInStateLogs:!0,persist:!0,anonymous:!0,usedInUi:!1}};function g(){return{remoteFeatureFlags:{},cacheTimestamp:0}}a.getDefaultRemoteFeatureFlagControllerState=g;class y extends p.BaseController{constructor({messenger:e,state:t,clientConfigApiService:l,fetchInterval:d=a.DEFAULT_CACHE_DURATION,disabled:u=!1,getMetaMetricsId:h}){super({name:a.controllerName,metadata:b,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),m(this,n,d,"f"),m(this,r,u,"f"),m(this,i,l,"f"),m(this,c,h,"f")}async updateRemoteFeatureFlags(){if(h(this,r,"f")||!h(this,s,"m",l).call(this))return;let e;if(h(this,o,"f"))await h(this,o,"f");else{try{m(this,o,h(this,i,"f").fetchRemoteFeatureFlags(),"f"),e=await h(this,o,"f")}finally{m(this,o,undefined,"f")}await h(this,s,"m",d).call(this,e.remoteFeatureFlags)}}enable(){m(this,r,!1,"f")}disable(){m(this,r,!0,"f")}}a.RemoteFeatureFlagController=y,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,s=new WeakSet,l=function(){return Date.now()-this.state.cacheTimestamp>h(this,n,"f")},d=async function(e){const t=await h(this,s,"m",u).call(this,e);this.update(()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()}))},u=async function(e){const t={},a=h(this,c,"f").call(this),s=(0,f.generateDeterministicRandomNumber)(a);for(const[a,n]of Object.entries(e)){let e=n;if(Array.isArray(n)&&s){const t=n.find(e=>!!(0,f.isFeatureFlagWithScopeValue)(e)&&s<=e.scope.value);t&&(e={name:t.name,value:t.value})}t[a]=e}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],[2486,{uuid:5737},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isFeatureFlagWithScopeValue=a.generateDeterministicRandomNumber=void 0;const s=e("uuid");function n(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const r=n("00000000-0000-4000-8000-000000000000"),i=n("ffffffff-ffff-4fff-bfff-ffffffffffff")-r;a.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,a;if((0,s.validate)(e)){if(4!==(0,s.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,s.version)(e)}`);t=n(e)-r,a=i}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const s=e.slice(2),n=64;if(s.length!==n)throw new Error(`Invalid hex ID length. Expected ${n} characters, got ${s.length}`);if(!/^[0-9a-f]+$/iu.test(s))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${s}`),a=BigInt(`0x${"f".repeat(s.length)}`)}return Number(t*BigInt(1e6)/a)/1e6};a.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],[249,{"../../../../shared/lib/deep-links/constants":5838,"../../../../shared/lib/deep-links/parse":5840,"../../../../shared/lib/deep-links/routes/route":5849,"../../../../shared/lib/deep-links/verify":5851,"../../../../shared/modules/mv3.utils":5914,events:4366,loglevel:4829,"webextension-polyfill":5769},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.DeepLinkRouter=void 0;var s=u(e("events")),n=u(e("webextension-polyfill")),r=u(e("loglevel")),i=e("../../../../shared/modules/mv3.utils"),o=e("../../../../shared/lib/deep-links/parse"),c=e("../../../../shared/lib/deep-links/constants"),l=e("../../../../shared/lib/deep-links/routes/route"),d=e("../../../../shared/lib/deep-links/verify");function u(e){return e&&e.__esModule?e:{default:e}}function m(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}const h=l.DEEP_LINK_ROUTE.replace(/^\//u,"");class p extends s.default{constructor({getExtensionURL:e,getState:t}){super(),m(this,"getExtensionURL",void 0),m(this,"getState",void 0),m(this,"handleBeforeRequest",({tabId:e,url:t})=>e===n.default.tabs.TAB_ID_NONE?{}:this.tryNavigateTo(e,t)),this.getExtensionURL=e,this.getState=t}formatUrlForInterstitialPage(e){return e.pathname+e.search}get404ErrorURL(e){const t=new URLSearchParams({errorCode:"404"});return e&&t.set("u",this.formatUrlForInterstitialPage(e)),this.getExtensionURL(h,t.toString())}async redirectTab(e,t){try{await n.default.tabs.update(e,{url:t})}catch(e){r.default.error("Error redirecting tab:",e),this.emit("error",e)}}install(){n.default.webRequest.onBeforeRequest.addListener(this.handleBeforeRequest,{urls:[`*://*.${c.DEEP_LINK_HOST}/*`],types:["main_frame"]},i.isManifestV3?[]:["blocking"])}uninstall(){n.default.webRequest.onBeforeRequest.removeListener(this.handleBeforeRequest)}async tryNavigateTo(e,t){if(t.length>c.DEEP_LINK_MAX_LENGTH)return r.default.debug("Url is too long, skipping deep link handling"),{};let a;try{const e=new URL(t),s=await(0,o.parse)(e);if(s)if(this.emit("navigate",{url:e,parsed:s}),"redirectTo"in s.destination)a=s.destination.redirectTo.toString();else if(this.canSkipInterstitial(s.signature))a=this.getExtensionURL(s.destination.path,s.destination.query.toString());else{const t=new URLSearchParams({u:this.formatUrlForInterstitialPage(e)});a=this.getExtensionURL(h,t.toString())}else a=this.get404ErrorURL(e)}catch(e){r.default.error("Invalid URL:",t,e),this.emit("error",e),a=this.get404ErrorURL()}return this.redirectTab(e,a),i.isManifestV3?{}:{cancel:!0}}canSkipInterstitial(e){var t;return e===d.VALID&&Boolean(null===(t=this.getState().preferences)||void 0===t?void 0:t.skipDeepLinkInterstitial)}}a.DeepLinkRouter=p}}},{package:"$root$",file:"app/scripts/lib/deep-links/deep-link-router.ts"}],[25,{"../../lib/util":332,"@metamask/assets-controllers":1203},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.TokenRatesControllerInit=void 0;var s=e("@metamask/assets-controllers"),n=e("../../lib/util");a.TokenRatesControllerInit=e=>{const{controllerMessenger:t,initMessenger:a,persistedState:r}=e,i=a.call("PreferencesController:getState"),o=new s.TokenRatesController({messenger:t,state:r.TokenRatesController,tokenPricesService:new s.CodefiTokenPricesServiceV2,disabled:!i.useCurrencyRateCheck});return a.subscribe("PreferencesController:stateChange",(0,n.previousValueComparator)((e,t)=>{const{useCurrencyRateCheck:a}=e,{useCurrencyRateCheck:s}=t;return s&&!a?o.enable():!s&&a&&o.disable(),!0},i)),{controller:o}}}}},{package:"$root$",file:"app/scripts/controller-init/assets/token-rates-controller-init.ts"}],[250,{"../../../../shared/constants/metametrics":5801},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createEvent=function({signature:e,url:t}){const a={route:t.pathname,signature:e},r={};for(const[e,s]of t.searchParams.entries())"sig"!==e&&("attributionId"===e?a.attribution_id=s:n.has(e)?a[e]=s:r[e]=s);return{category:s.MetaMetricsEventCategory.DeepLink,event:s.MetaMetricsEventName.DeepLinkUsed,properties:a,sensitiveProperties:r}};var s=e("../../../../shared/constants/metametrics");const n=new Set(["utm_campaign","utm_content","utm_medium","utm_source","utm_term"])}}},{package:"$root$",file:"app/scripts/lib/deep-links/metrics.ts"}],[251,{"@metamask/browser-passworder":1310},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.encryptorFactory=void 0;var s=e("@metamask/browser-passworder");const n=e=>async(t,a,n,r)=>(0,s.encrypt)(t,a,n,r,{algorithm:"PBKDF2",params:{iterations:e}}),r=e=>async(t,a,n)=>(0,s.encryptWithDetail)(t,a,n,{algorithm:"PBKDF2",params:{iterations:e}}),i=e=>async(t,a,n,r)=>(0,s.keyFromPassword)(t,a,n,r??{algorithm:"PBKDF2",params:{iterations:e}}),o=e=>t=>(0,s.isVaultUpdated)(t,{algorithm:"PBKDF2",params:{iterations:e}});a.encryptorFactory=e=>({encrypt:n(e),encryptWithKey:s.encryptWithKey,encryptWithDetail:r(e),decrypt:s.decrypt,decryptWithKey:s.decryptWithKey,decryptWithDetail:s.decryptWithDetail,keyFromPassword:i(e),isVaultUpdated:o(e),importKey:s.importKey,exportKey:s.exportKey,generateSalt:s.generateSalt})}}},{package:"$root$",file:"app/scripts/lib/encryptor-factory.ts"}],[2513,{"@metamask/base-controller":1273,"@metamask/swappable-obj-proxy":2827},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},d=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.SelectedNetworkController=a.SelectedNetworkControllerEventTypes=a.SelectedNetworkControllerActionTypes=a.METAMASK_DOMAIN=a.controllerName=void 0;const u=e("@metamask/base-controller"),m=e("@metamask/swappable-obj-proxy");a.controllerName="SelectedNetworkController";const h={domains:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0}};a.METAMASK_DOMAIN="metamask",a.SelectedNetworkControllerActionTypes={getState:`${a.controllerName}:getState`,getNetworkClientIdForDomain:`${a.controllerName}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${a.controllerName}:setNetworkClientIdForDomain`},a.SelectedNetworkControllerEventTypes={stateChange:`${a.controllerName}:stateChange`};class p extends u.BaseController{constructor({messenger:e,state:t={domains:{}},domainProxyMap:i}){super({name:a.controllerName,metadata:h,messenger:e,state:t}),s.add(this),n.set(this,void 0),l(this,n,i,"f"),d(this,s,"m",r).call(this),this.messagingSystem.call("PermissionController:getSubjectNames").filter(e=>this.state.domains[e]===undefined).forEach(e=>this.setNetworkClientIdForDomain(e,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId)),this.messagingSystem.subscribe("PermissionController:stateChange",(e,t)=>{t.forEach(({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const a=t[1];"add"===e&&this.state.domains[a]===undefined?this.setNetworkClientIdForDomain(a,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[a]!==undefined&&d(this,s,"m",o).call(this,a)}})}),this.messagingSystem.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e,networkConfigurationsByChainId:t},a)=>{const s=a.find(({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]);if(s){const a=Object.values(t).reduce((e,t)=>(t.rpcEndpoints.forEach(({networkClientId:a})=>e[a]=t.chainId),e),{});Object.entries(this.state.domains).forEach(([n,r])=>{const i=a[r];if("remove"!==s.op||i){if("replace"===s.op){const e=s.path[1];if(!i||i===e){const a=t[e],{networkClientId:s}=a.rpcEndpoints[a.defaultRpcEndpointIndex];r!==s&&this.setNetworkClientIdForDomain(n,s)}}}else this.setNetworkClientIdForDomain(n,e)})}})}setNetworkClientIdForDomain(e,t){if(e===a.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${a.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!d(this,s,"m",c).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");d(this,s,"m",i).call(this,e,t)}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messagingSystem.call("NetworkController:getState");return this.state.domains[e]??t}getProviderAndBlockTracker(e){if(e===a.METAMASK_DOMAIN){const e=this.messagingSystem.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=d(this,n,"f").get(e);if(t===undefined){let a;if(d(this,s,"m",c).call(this,e)){const t=this.getNetworkClientIdForDomain(e);a=this.messagingSystem.call("NetworkController:getNetworkClientById",t)}else if(a=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),a===undefined)throw new Error("Selected network not initialized");t={provider:(0,m.createEventEmitterProxy)(a.provider),blockTracker:(0,m.createEventEmitterProxy)(a.blockTracker,{eventFilter:"skipInternal"})},d(this,n,"f").set(e,t)}return t}}a.SelectedNetworkController=p,n=new WeakMap,s=new WeakSet,r=function(){this.messagingSystem.registerActionHandler(a.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messagingSystem.registerActionHandler(a.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},i=function(e,t){const a=this.messagingSystem.call("NetworkController:getNetworkClientById",t);this.update(a=>{a.domains[e]=t});const s=this.getProviderAndBlockTracker(e);s.provider.setTarget(a.provider),s.blockTracker.setTarget(a.blockTracker)},o=function(e){const t=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),a=d(this,n,"f").get(e);a&&t?(a.provider.setTarget(t.provider),a.blockTracker.setTarget(t.blockTracker)):a&&d(this,n,"f").delete(e),this.update(t=>{delete t.domains[e]})},c=function(e){return this.messagingSystem.call("PermissionController:hasPermissions",e)}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],[2514,{"./SelectedNetworkController.cjs":2513},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSelectedNetworkMiddleware=void 0;const s=e("./SelectedNetworkController.cjs");a.createSelectedNetworkMiddleware=e=>(t,a,n)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var r;return t.networkClientId=(r=t.origin,e.call(s.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,r)),n()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],[2515,{"./SelectedNetworkController.cjs":2513,"./SelectedNetworkMiddleware.cjs":2514},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSelectedNetworkMiddleware=a.METAMASK_DOMAIN=a.SelectedNetworkController=a.SelectedNetworkControllerEventTypes=a.SelectedNetworkControllerActionTypes=void 0;var s=e("./SelectedNetworkController.cjs");Object.defineProperty(a,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return s.SelectedNetworkControllerActionTypes}}),Object.defineProperty(a,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return s.SelectedNetworkControllerEventTypes}}),Object.defineProperty(a,"SelectedNetworkController",{enumerable:!0,get:function(){return s.SelectedNetworkController}}),Object.defineProperty(a,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return s.METAMASK_DOMAIN}});var n=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(a,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return n.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],[2516,{"./constants.cjs":2518,"./logger.cjs":2520,"@metamask/base-controller":1273,"@metamask/signature-controller":2522,"@metamask/transaction-controller":2867,lodash:4821},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,d,u,m,h,p,f,b,g,y=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},w=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ShieldController=a.getDefaultShieldControllerState=void 0;const v=e("@metamask/base-controller"),S=e("@metamask/signature-controller"),E=e("@metamask/transaction-controller"),k=e("lodash"),T=e("./constants.cjs"),_=e("./logger.cjs"),P=(0,_.createModuleLogger)(_.projectLogger,"ShieldController");function M(){return{coverageResults:{},orderedTransactionHistory:[]}}a.getDefaultShieldControllerState=M;const x={coverageResults:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0},orderedTransactionHistory:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1}};class A extends v.BaseController{constructor(e){const{messenger:t,state:a,backend:h,transactionHistoryLimit:p=100,coverageHistoryLimit:f=10,normalizeSignatureRequest:b}=e;super({name:T.controllerName,metadata:x,messenger:t,state:{coverageResults:{},orderedTransactionHistory:[],...a}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),y(this,n,h,"f"),y(this,r,f,"f"),y(this,i,p,"f"),y(this,c,w(this,s,"m",m).bind(this),"f"),y(this,l,w(this,s,"m",u).bind(this),"f"),y(this,d,!1,"f"),y(this,o,b,"f")}start(){w(this,d,"f")||(y(this,d,!0,"f"),this.messagingSystem.subscribe("TransactionController:stateChange",w(this,c,"f"),e=>e.transactions),this.messagingSystem.subscribe("SignatureController:stateChange",w(this,l,"f"),e=>e.signatureRequests))}stop(){w(this,d,"f")&&(y(this,d,!1,"f"),this.messagingSystem.unsubscribe("TransactionController:stateChange",w(this,c,"f")),this.messagingSystem.unsubscribe("SignatureController:stateChange",w(this,l,"f")))}async checkCoverage(e){const t=w(this,s,"m",g).call(this,e.id),a=await w(this,n,"f").checkCoverage({txMeta:e,coverageId:t});return this.messagingSystem.publish(`${T.controllerName}:coverageResultReceived`,a),w(this,s,"m",h).call(this,e.id,a),a}async checkSignatureCoverage(e){const t=w(this,s,"m",g).call(this,e.id),a=(0,k.cloneDeep)(e),r=w(this,o,"f")?.call(this,a)??a,i=await w(this,n,"f").checkSignatureCoverage({signatureRequest:r,coverageId:t});return this.messagingSystem.publish(`${T.controllerName}:coverageResultReceived`,i),w(this,s,"m",h).call(this,e.id,i),i}}a.ShieldController=A,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,s=new WeakSet,u=function(e,t){const a=Object.values(e),n=Object.values(t??{}),r=new Map(n.map(e=>[e.id,e]));for(const e of a){const t=r.get(e.id);t||this.checkSignatureCoverage(e).catch(e=>P("Error checking coverage:",e)),e.status===S.SignatureRequestStatus.Signed&&e.status!==t?.status&&w(this,s,"m",p).call(this,e).catch(e=>P("Error logging signature:",e))}},m=function(e,t){const a=new Map(t?.map(e=>[e.id,e])??[]);for(const t of e){const e=a.get(t.id),n=(0,k.isEqual)(t.simulationData,e?.simulationData);e&&n||this.checkCoverage(t).catch(e=>P("Error checking coverage:",e)),t.status===E.TransactionStatus.submitted&&t.status!==e?.status&&w(this,s,"m",f).call(this,t).catch(e=>P("Error logging transaction:",e))}},h=function(e,t){const a=w(this,s,"m",g).call(this,e);if(a&&t.coverageId!==a)throw new Error("Coverage ID has changed");this.update(a=>{let s=!1,n=a.coverageResults[e];n||(s=!0,n={results:[]},a.coverageResults[e]=n),n.results.length>=w(this,r,"f")&&n.results.pop(),n.results.unshift(t);const{orderedTransactionHistory:o}=a;let c;s&&(o.length>=w(this,i,"f")&&(c=o.pop(),c&&delete a.coverageResults[c]),o.unshift(e))})},p=async function(e){const t=e.rawSig;if(!t)throw new Error("Signature not found");const{status:a}=w(this,s,"m",b).call(this,e.id);await w(this,n,"f").logSignature({signatureRequest:e,signature:t,status:a})},f=async function(e){const t=e.hash;if(!t)throw new Error("Transaction hash not found");const{status:a}=w(this,s,"m",b).call(this,e.id);await w(this,n,"f").logTransaction({txMeta:e,transactionHash:t,status:a})},b=function(e){let t="shown";return w(this,s,"m",g).call(this,e)||(P("Coverage ID not found for",e),t="not_shown"),{status:t}},g=function(e){return this.state.coverageResults[e]?.results[0]?.coverageId}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/ShieldController.cjs"}],[2517,{"./constants.cjs":2518,"@metamask/signature-controller":2522},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,l,d,u,m=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},h=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.parseSignatureRequestMethod=a.ShieldRemoteBackend=void 0;const p=e("@metamask/signature-controller"),f=e("./constants.cjs");async function b(e){return new Promise(t=>setTimeout(t,e))}function g(e){return{txParams:[{from:e.txParams.from,to:e.txParams.to,value:e.txParams.value,data:e.txParams.data,nonce:e.txParams.nonce}],chainId:e.chainId,origin:e.origin}}function y(e){const t=w(e);return{chainId:e.chainId,data:e.messageParams.data,from:e.messageParams.from,method:t,origin:e.messageParams.origin}}function w(e){if(e.type===p.SignatureRequestType.TypedSign)switch(e.version){case f.SignTypedDataVersion.V3:return p.EthMethod.SignTypedDataV3;case f.SignTypedDataVersion.V4:return p.EthMethod.SignTypedDataV4;case f.SignTypedDataVersion.V1:default:return p.SignatureRequestType.TypedSign}return e.type}a.ShieldRemoteBackend=class{constructor({getAccessToken:e,getCoverageResultTimeout:t=5e3,getCoverageResultPollInterval:a=1e3,baseUrl:l,fetch:d}){s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),m(this,n,e,"f"),m(this,r,t,"f"),m(this,i,a,"f"),m(this,o,l,"f"),m(this,c,d,"f")}async checkCoverage(e){let{coverageId:t}=e;if(!t){const a=g(e.txMeta);({coverageId:t}=await h(this,s,"m",l).call(this,"v1/transaction/coverage/init",a))}const a=`${h(this,o,"f")}/v1/transaction/coverage/result`,n=await h(this,s,"m",d).call(this,t,{coverageResultUrl:a});return{coverageId:t,message:n.message,reasonCode:n.reasonCode,status:n.status}}async checkSignatureCoverage(e){let{coverageId:t}=e;if(!t){const a=y(e.signatureRequest);({coverageId:t}=await h(this,s,"m",l).call(this,"v1/signature/coverage/init",a))}const a=`${h(this,o,"f")}/v1/signature/coverage/result`,n=await h(this,s,"m",d).call(this,t,{coverageResultUrl:a});return{coverageId:t,message:n.message,reasonCode:n.reasonCode,status:n.status}}async logSignature(e){const t=y(e.signatureRequest),a={signature:e.signature,status:e.status,...t},n=await h(this,c,"f").call(this,`${h(this,o,"f")}/v1/signature/coverage/log`,{method:"POST",headers:await h(this,s,"m",u).call(this),body:JSON.stringify(a)});if(200!==n.status)throw new Error(`Failed to log signature: ${n.status}`)}async logTransaction(e){const t=g(e.txMeta),a={transactionHash:e.transactionHash,status:e.status,...t},n=await h(this,c,"f").call(this,`${h(this,o,"f")}/v1/transaction/coverage/log`,{method:"POST",headers:await h(this,s,"m",u).call(this),body:JSON.stringify(a)});if(200!==n.status)throw new Error(`Failed to log transaction: ${n.status}`)}},n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,s=new WeakSet,l=async function(e,t){const a=await h(this,c,"f").call(this,`${h(this,o,"f")}/${e}`,{method:"POST",headers:await h(this,s,"m",u).call(this),body:JSON.stringify(t)});if(200!==a.status)throw new Error(`Failed to init coverage check: ${a.status}`);return await a.json()},d=async function(e,t){const a={coverageId:e},n=t?.timeout??h(this,r,"f"),o=t?.pollInterval??h(this,i,"f"),l=await h(this,s,"m",u).call(this);return await new Promise((e,s)=>{let r=!1;setTimeout(()=>{r=!0,s(new Error("Timeout waiting for coverage result"))},n);(async()=>{for(;!r;){const e=Date.now(),s=await h(this,c,"f").call(this,t.coverageResultUrl,{method:"POST",headers:l,body:JSON.stringify(a)});if(200===s.status)return await s.json();await b(o-(Date.now()-e))}throw new Error("unexpected error")})().then(e).catch(s)})},u=async function(){return{"Content-Type":"application/json",Authorization:`Bearer ${await h(this,n,"f").call(this)}`}},a.parseSignatureRequestMethod=w}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/backend.cjs"}],[2518,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;Object.defineProperty(a,"__esModule",{value:!0}),a.SignTypedDataVersion=a.controllerName=void 0,a.controllerName="ShieldController",function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(s||(a.SignTypedDataVersion=s={}))}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/constants.cjs"}],[2519,{"./ShieldController.cjs":2516,"./backend.cjs":2517},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.parseSignatureRequestMethod=a.ShieldRemoteBackend=a.getDefaultShieldControllerState=a.ShieldController=void 0;var s=e("./ShieldController.cjs");Object.defineProperty(a,"ShieldController",{enumerable:!0,get:function(){return s.ShieldController}}),Object.defineProperty(a,"getDefaultShieldControllerState",{enumerable:!0,get:function(){return s.getDefaultShieldControllerState}});var n=e("./backend.cjs");Object.defineProperty(a,"ShieldRemoteBackend",{enumerable:!0,get:function(){return n.ShieldRemoteBackend}}),Object.defineProperty(a,"parseSignatureRequestMethod",{enumerable:!0,get:function(){return n.parseSignatureRequestMethod}})}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/index.cjs"}],[252,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;a.default=[{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"resolver",outputs:[{name:"",type:"address"}],payable:!1,type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"owner",outputs:[{name:"",type:"address"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"label",type:"bytes32"},{name:"owner",type:"address"}],name:"setSubnodeOwner",outputs:[],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"ttl",type:"uint64"}],name:"setTTL",outputs:[],payable:!1,type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"ttl",outputs:[{name:"",type:"uint64"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"resolver",type:"address"}],name:"setResolver",outputs:[],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"owner",type:"address"}],name:"setOwner",outputs:[],payable:!1,type:"function"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"owner",type:"address"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!0,name:"label",type:"bytes32"},{indexed:!1,name:"owner",type:"address"}],name:"NewOwner",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"resolver",type:"address"}],name:"NewResolver",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"ttl",type:"uint64"}],name:"NewTTL",type:"event"}]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/contracts/registry.js"}],[2520,{"./constants.cjs":2518,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createModuleLogger=a.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(a,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}});const n=e("./constants.cjs");a.projectLogger=(0,s.createProjectLogger)(n.controllerName)}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/logger.cjs"}],[253,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=void 0;a.default=[{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"hash",type:"bytes32"}],name:"setContent",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"content",outputs:[{name:"",type:"bytes32"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"interfaceID",type:"bytes4"}],name:"supportsInterface",outputs:[{name:"",type:"bool"}],payable:!1,stateMutability:"pure",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"key",type:"string"},{name:"value",type:"string"}],name:"setText",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"},{name:"contentTypes",type:"uint256"}],name:"ABI",outputs:[{name:"contentType",type:"uint256"},{name:"data",type:"bytes"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"x",type:"bytes32"},{name:"y",type:"bytes32"}],name:"setPubkey",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"hash",type:"bytes"}],name:"setContenthash",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"addr",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"},{name:"key",type:"string"}],name:"text",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"contentType",type:"uint256"},{name:"data",type:"bytes"}],name:"setABI",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"name",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"name",type:"string"}],name:"setName",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"contenthash",outputs:[{name:"",type:"bytes"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"pubkey",outputs:[{name:"x",type:"bytes32"},{name:"y",type:"bytes32"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"addr",type:"address"}],name:"setAddr",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{inputs:[{name:"ensAddr",type:"address"}],payable:!1,stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"a",type:"address"}],name:"AddrChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"name",type:"string"}],name:"NameChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!0,name:"contentType",type:"uint256"}],name:"ABIChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"x",type:"bytes32"},{indexed:!1,name:"y",type:"bytes32"}],name:"PubkeyChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"indexedKey",type:"string"},{indexed:!1,name:"key",type:"string"}],name:"TextChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"hash",type:"bytes"}],name:"ContenthashChanged",type:"event"}]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/contracts/resolver.js"}],[2537,{"../snaps/Timer.cjs":2559,"../snaps/constants.cjs":2560,"./utils.cjs":2539,"@metamask/base-controller":1273,"@metamask/snaps-rpc-methods":2620,"@metamask/snaps-utils":2790,"@metamask/utils":2913,immer:4599,luxon:4832,nanoid:5020},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){n(e,t),t.set(e,a)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,a){return e.set(o(e,t),a),a}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.CronjobController=a.DAILY_TIMEOUT=void 0;const c=e("@metamask/base-controller"),l=e("@metamask/snaps-rpc-methods"),d=e("@metamask/snaps-utils"),u=e("@metamask/utils"),m=e("immer"),h=e("luxon"),p=e("nanoid"),f=e("./utils.cjs"),b=e("../snaps/constants.cjs"),g=e("../snaps/Timer.cjs");a.DAILY_TIMEOUT=(0,u.inMilliseconds)(24,u.Duration.Hour);const y="CronjobController";var w=new WeakMap,v=new WeakMap,S=new WeakMap,E=new WeakSet,k=new WeakMap,T=new WeakMap,_=new WeakMap,P=new WeakMap,M=new WeakMap;class x extends c.BaseController{constructor({messenger:e,state:t,stateManager:c}){var l,d;super({messenger:e,metadata:{events:{includeInStateLogs:!1,persist:!1,anonymous:!1,usedInUi:!1}},name:y,state:{events:{},...t,...c.getInitialState()}}),n(l=this,d=E),d.add(l),s(this,w,void 0),s(this,v,void 0),s(this,S,new g.Timer(a.DAILY_TIMEOUT)),s(this,k,e=>{this.unregister(e.id),this.register(e.id)}),s(this,T,e=>{const t=this.get(e.id);o(E,this,$).call(this,t),this.register(e.id)}),s(this,_,e=>{this.unregister(e.id)}),s(this,P,e=>{this.unregister(e.id)}),s(this,M,e=>{this.unregister(e.id),this.register(e.id)}),i(w,this,new Map),i(v,this,c),this.messagingSystem.subscribe("SnapController:snapInstalled",r(k,this)),this.messagingSystem.subscribe("SnapController:snapUninstalled",r(_,this)),this.messagingSystem.subscribe("SnapController:snapEnabled",r(T,this)),this.messagingSystem.subscribe("SnapController:snapDisabled",r(P,this)),this.messagingSystem.subscribe("SnapController:snapUpdated",r(M,this)),this.messagingSystem.registerActionHandler(`${y}:init`,(...e)=>this.init(...e)),this.messagingSystem.registerActionHandler(`${y}:schedule`,(...e)=>this.schedule(...e)),this.messagingSystem.registerActionHandler(`${y}:cancel`,(...e)=>this.cancel(...e)),this.messagingSystem.registerActionHandler(`${y}:get`,(...e)=>this.get(...e))}init(){o(E,this,A).call(this),o(E,this,D).call(this),o(E,this,$).call(this)}schedule(e){return o(E,this,C).call(this,{...e,recurring:!1})}cancel(e,t){(0,u.assert)(this.state.events[t],`A background event with the id of "${t}" does not exist.`),(0,u.assert)(this.state.events[t].snapId===e,"Only the origin that scheduled this event can cancel it."),o(E,this,j).call(this,t)}get(e){return Object.values(this.state.events).filter(t=>t.snapId===e&&!t.recurring).map(e=>({...e,date:(0,d.toCensoredISO8601String)(e.date),scheduledAt:(0,d.toCensoredISO8601String)(e.scheduledAt)}))}register(e){const t=o(E,this,O).call(this,e);null==t||t.forEach(e=>o(E,this,C).call(this,e))}unregister(e){for(const[t,a]of Object.entries(this.state.events))a.snapId===e&&o(E,this,j).call(this,t)}destroy(){super.destroy(),this.messagingSystem.unsubscribe("SnapController:snapInstalled",r(k,this)),this.messagingSystem.unsubscribe("SnapController:snapUninstalled",r(_,this)),this.messagingSystem.unsubscribe("SnapController:snapEnabled",r(T,this)),this.messagingSystem.unsubscribe("SnapController:snapDisabled",r(P,this)),this.messagingSystem.unsubscribe("SnapController:snapUpdated",r(M,this)),r(w,this).forEach(e=>e.cancel()),r(w,this).clear(),"running"===r(S,this).status&&r(S,this).cancel()}}function A(){i(S,this,new g.Timer(a.DAILY_TIMEOUT)),r(S,this).start(()=>{o(E,this,$).call(this),o(E,this,A).call(this)})}function C(e){const t=e.id??(0,p.nanoid)(),a={...e,id:t,date:(0,f.getExecutionDate)(e.schedule),scheduledAt:(new Date).toISOString()},{nextState:s}=this.update(e=>{e.events[a.id]=(0,m.castDraft)(a)});return r(v,this).set(s),o(E,this,I).call(this,a),t}function I(e,t=!0){if(!t)return void o(E,this,R).call(this,e);const a=(0,f.getExecutionDate)(e.schedule),{nextState:s}=this.update(t=>{t.events[e.id].date=a});r(v,this).set(s),o(E,this,R).call(this,{...e,date:a})}function R(e){const t=h.DateTime.fromISO(e.date,{setZone:!0}).toMillis()-Date.now();if(t>a.DAILY_TIMEOUT)return;if(t<=0)return void o(E,this,N).call(this,e);const s=new g.Timer(t);s.start(()=>{o(E,this,N).call(this,e)}),r(w,this).set(e.id,s)}function N(e){if(this.messagingSystem.call("SnapController:handleRequest",{snapId:e.snapId,origin:b.METAMASK_ORIGIN,handler:d.HandlerType.OnCronjob,request:e.request}).catch(t=>{(0,d.logError)(`An error occurred while executing an event for Snap "${e.snapId}":`,t)}),r(w,this).delete(e.id),!e.recurring){const{nextState:t}=this.update(t=>{delete t.events[e.id]});return void r(v,this).set(t)}o(E,this,I).call(this,e)}function j(e){const t=r(w,this).get(e);null==t||t.cancel(),r(w,this).delete(e);const{nextState:a}=this.update(t=>{delete t.events[e]});r(v,this).set(a)}function O(e){const t=this.messagingSystem.call("PermissionController:getPermissions",e),a=null==t?void 0:t[l.SnapEndowments.Cronjob],s=(0,l.getCronjobCaveatJobs)(a);return s?s.map((t,a)=>({snapId:e,id:`cronjob-${e}-${a}`,request:t.request,schedule:(0,f.getCronjobSpecificationSchedule)(t),recurring:!0})):[]}function $(e=Object.values(this.state.events)){const t=Date.now();for(const a of e){if(r(w,this).has(a.id))continue;const e=h.DateTime.fromISO(a.date,{setZone:!0}).toUTC().toMillis();a.recurring&&e<=t?o(E,this,N).call(this,a):o(E,this,I).call(this,a,!1)}}function D(){const e=Date.now();for(const t of Object.values(this.state.events)){const a=h.DateTime.fromISO(t.date,{setZone:!0}).toUTC().toMillis();!t.recurring&&a<e&&o(E,this,j).call(this,t.id)}}a.CronjobController=x}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"}],[2538,{"./CronjobController.cjs":2537},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./CronjobController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs"}],[2539,{"@metamask/utils":2913,"cron-parser":4171,luxon:4832},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getExecutionDate=a.getCronjobSpecificationSchedule=void 0;const s=e("@metamask/utils"),n=e("cron-parser"),r=e("luxon");a.getCronjobSpecificationSchedule=function(e){return(0,s.hasProperty)(e,"duration")?e.duration:e.expression},a.getExecutionDate=function(e){const t=r.DateTime.fromISO(e,{setZone:!0});if(t.isValid){const e=Date.now(),a=t.toUTC().startOf("second");if(a.toMillis()<e)throw new Error("Cannot schedule an event in the past.");return a.toISO({suppressMilliseconds:!0})}const a=r.Duration.fromISO(e);if(a.isValid){const e=function(e){return e.as("seconds")<1?r.Duration.fromObject({seconds:1}):e}(a);return r.DateTime.now().toUTC().plus(e).toISO()}try{const t=(0,n.parseExpression)(e,{utc:!0}).next(),a=r.DateTime.fromJSDate(t.toDate());return(0,s.assert)(a.isValid),a.toUTC().toISO()}catch{throw new Error(`Unable to parse "${e}" as ISO 8601 date, ISO 8601 duration, or cron expression.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs"}],[254,{"./contracts/registry":252,"./contracts/resolver":253,"@ensdomains/content-hash":609,"@ethersproject/contracts":697,"@ethersproject/providers":735,"eth-ens-namehash":4270},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=async function({provider:e,name:t}){const a=s.default.hash(t),l=Number.parseInt(await e.request({method:"net_version"}),10),u=function(e){switch(e){case 1:case 3:case 4:case 5:case 6:return"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";default:return null}}(l);if(!u)throw new Error(`EnsIpfsResolver - no known ens-ipfs registry for chainId "${l}"`);const m=new r.Web3Provider(e),h=new i.Contract(u,o.default,m),p=await h.resolver(a);if(d(p))throw new Error(`EnsIpfsResolver - no resolver found for name "${t}"`);const f=new i.Contract(p,c.default,m),b=await f.supportsInterface("0xbc1c58d1"),g=await f.supportsInterface("0xd8389dc5");if(b){const e=await f.contenthash(a);let t=n.default.decode(e);const s=n.default.getCodec(e);return"ipfs-ns"!==s&&"ipns-ns"!==s||(t=n.default.helpers.cidV0ToV1Base32(t)),{type:s,hash:t}}if(g){const e=await f.content(a);if(d(e))throw new Error(`EnsIpfsResolver - no content ID found for name "${t}"`);return{type:"swarm-ns",hash:e.slice(2)}}throw new Error(`EnsIpfsResolver - the resolver for name "${t}" is not standard, it should either supports contenthash() or content()`)};var s=l(e("eth-ens-namehash")),n=l(e("@ensdomains/content-hash")),r=e("@ethersproject/providers"),i=e("@ethersproject/contracts"),o=l(e("./contracts/registry")),c=l(e("./contracts/resolver"));function l(e){return e&&e.__esModule?e:{default:e}}function d(e){return[undefined,null,"0x","0x0","0x0000000000000000000000000000000000000000000000000000000000000000"].includes(e)}}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/resolver.js"}],[2540,{"@metamask/utils":2913,"@xstate/fsm":3573},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.forceStrict=a.validateMachine=void 0;const s=e("@metamask/utils"),n=e("@xstate/fsm");a.validateMachine=function(e){(0,s.assert)("_options"in e,"The machine is not an @xstate/fsm machine");const t=e,a=new Set,n=e=>{return(t=e,Array.isArray(t)?t:t===undefined||null===t?[]:[t]).flatMap(e=>"string"==typeof e?[e]:((0,s.assert)("function"==typeof e),[])).forEach(a.add.bind(a));var t};for(const e of Object.values(t.config.states)){n(e.entry),n(e.exit);for(const t of Object.values(e.on??{}))n(t.actions)}a.forEach(e=>(0,s.assert)(t._options.actions!==undefined&&e in t._options.actions,`Action "${e}" doesn't have an implementation`))},a.forceStrict=function(e){let t=!1;e.subscribe(e=>{(0,s.assert)(!t||e.changed,"Invalid state transition"),t=!0});const a=e.send.bind(e);e.send=(...t)=>((0,s.assert)(e.status===n.InterpreterStatus.Running,"Interpreter is stopped"),a(...t))}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/fsm.cjs"}],[2541,{"./cronjob/index.cjs":2538,"./insights/index.cjs":2543,"./interface/index.cjs":2545,"./multichain/index.cjs":2549,"./services/index.cjs":2554,"./snaps/index.cjs":2561,"./utils.cjs":2571,"./websocket/index.cjs":2573},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./services/index.cjs"),a),n(e("./snaps/index.cjs"),a),n(e("./utils.cjs"),a),n(e("./cronjob/index.cjs"),a),n(e("./interface/index.cjs"),a),n(e("./insights/index.cjs"),a),n(e("./multichain/index.cjs"),a),n(e("./websocket/index.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/index.cjs"}],[2542,{"../snaps/index.cjs":2561,"@metamask/base-controller":1273,"@metamask/snaps-rpc-methods":2620,"@metamask/snaps-utils":2790,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function n(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.SnapInsightsController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-rpc-methods"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("../snaps/index.cjs");var d=new WeakSet;class u extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{insights:{includeInStateLogs:!0,persist:!1,anonymous:!1,usedInUi:!0}},name:"SnapInsightsController",state:{insights:{},...t}}),s(this,d),this.messagingSystem.subscribe("TransactionController:unapprovedTransactionAdded",n(d,this,p).bind(this)),this.messagingSystem.subscribe("TransactionController:transactionStatusUpdated",n(d,this,g).bind(this)),this.messagingSystem.subscribe("SignatureController:stateChange",n(d,this,f).bind(this))}}function m(e){return(0,c.hasProperty)(this.state.insights,e)}function h(e){const t=this.messagingSystem.call("SnapController:getAll");return(0,l.getRunnableSnaps)(t).reduce((t,a)=>{const s=this.messagingSystem.call("PermissionController:getPermissions",a.id);return s&&(0,c.hasProperty)(s,e)&&t.push({snapId:a.id,permission:s[e]}),t},[])}function p(e){const{id:t,txParams:a,chainId:s,origin:r}=e,l=`eip155:${(0,c.hexToBigInt)(s).toString(10)}`;n(d,this,h).call(this,i.SnapEndowments.TransactionInsight).forEach(({snapId:e,permission:s})=>{const c=(0,i.getTransactionOriginCaveat)(s)&&r?r:null;this.update(a=>{var s;(s=a.insights)[t]??(s[t]={}),a.insights[t][e]={snapId:e,loading:!0}}),n(d,this,w).call(this,{snapId:e,handler:o.HandlerType.OnTransaction,params:{transaction:a,chainId:l,transactionOrigin:c}}).then(a=>n(d,this,v).call(this,{id:t,snapId:e,response:a})).catch(a=>n(d,this,v).call(this,{id:t,snapId:e,error:a}))})}function f(e){for(const t of Object.keys(this.state.insights))(0,c.hasProperty)(e.unapprovedTypedMessages,t)||(0,c.hasProperty)(e.unapprovedPersonalMsgs,t)||n(d,this,y).call(this,t);if(e.unapprovedPersonalMsgCount>0||e.unapprovedTypedMessagesCount>0){const t=n(d,this,h).call(this,i.SnapEndowments.SignatureInsight);for(const a of Object.values(e.unapprovedPersonalMsgs))n(d,this,b).call(this,t,a);for(const a of Object.values(e.unapprovedTypedMessages))n(d,this,b).call(this,t,a)}}function b(e,t){const{id:a,msgParams:s}=t;if(n(d,this,m).call(this,a))return;const{from:r,data:c,signatureMethod:l,origin:u}=s,h={from:r,data:"eth_signTypedData_v3"===l||"eth_signTypedData_v4"===l?JSON.parse(c):c,signatureMethod:l};e.forEach(({snapId:e,permission:t})=>{const s=(0,i.getSignatureOriginCaveat)(t),r=u&&s?u:null;this.update(t=>{var s;(s=t.insights)[a]??(s[a]={}),t.insights[a][e]={snapId:e,loading:!0}}),n(d,this,w).call(this,{snapId:e,handler:o.HandlerType.OnSignature,params:{signature:h,signatureOrigin:r}}).then(t=>n(d,this,v).call(this,{id:a,snapId:e,response:t})).catch(t=>n(d,this,v).call(this,{id:a,snapId:e,error:t}))})}function g({transactionMeta:e}){"unapproved"!==e.status&&n(d,this,y).call(this,e.id)}function y(e){n(d,this,m).call(this,e)&&(Object.values(this.state.insights[e]).filter(e=>e.interfaceId).forEach(e=>{this.messagingSystem.call("SnapInterfaceController:deleteInterface",e.interfaceId)}),this.update(t=>{delete t.insights[e]}))}async function w({snapId:e,handler:t,params:a}){return this.messagingSystem.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:t,request:{method:"",params:a}})}function v({id:e,snapId:t,response:a,error:s}){n(d,this,m).call(this,e)&&this.update(n=>{n.insights[e][t].loading=!1,n.insights[e][t].interfaceId=null==a?void 0:a.id,n.insights[e][t].severity=null==a?void 0:a.severity,n.insights[e][t].error=null==s?void 0:s.message})}a.SnapInsightsController=u}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"}],[2543,{"./SnapInsightsController.cjs":2542},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./SnapInsightsController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/index.cjs"}],[2544,{"./utils.cjs":2546,"@metamask/base-controller":1273,"@metamask/snaps-sdk":2676,"@metamask/snaps-utils":2790,"@metamask/utils":2913,immer:4599,nanoid:5020},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function n(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.SnapInterfaceController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-sdk"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("immer"),d=e("nanoid"),u=e("./utils.cjs"),m=1e7,h="SnapInterfaceController";var p=new WeakSet;class f extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{interfaces:{includeInStateLogs:!0,persist:e=>Object.entries(e).reduce((e,[t,a])=>a.contentType===i.ContentType.Notification?(e[t]=a,e):e,{}),anonymous:!1,usedInUi:!0}},name:h,state:{interfaces:{},...t}}),s(this,p),this.messagingSystem.subscribe("NotificationServicesController:notificationsListUpdated",n(p,this,x).bind(this)),n(p,this,b).call(this)}createInterface(e,t,a,s){const r=(0,u.getJsxInterface)(t);n(p,this,M).call(this,r),(0,u.validateInterfaceContext)(a);const i=(0,d.nanoid)(),c=(0,u.constructState)({},r,{getAssetsState:n(p,this,_).bind(this),getAccountByAddress:n(p,this,T).bind(this),getSelectedAccount:n(p,this,E).bind(this),listAccounts:n(p,this,k).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});return this.update(t=>{t.interfaces[i]={snapId:e,content:(0,l.castDraft)(r),state:c,context:a??null,contentType:s??null}}),i}getInterface(e,t){return n(p,this,g).call(this,e,t),this.state.interfaces[t]}updateInterface(e,t,a,s){n(p,this,g).call(this,e,t);const r=(0,u.getJsxInterface)(a);n(p,this,M).call(this,r),(0,u.validateInterfaceContext)(s);const i=this.state.interfaces[t].state,c=(0,u.constructState)(i,r,{getAssetsState:n(p,this,_).bind(this),getAccountByAddress:n(p,this,T).bind(this),getSelectedAccount:n(p,this,E).bind(this),listAccounts:n(p,this,k).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});this.update(e=>{e.interfaces[t].state=c,e.interfaces[t].content=(0,l.castDraft)(r),s&&(e.interfaces[t].context=s)})}deleteInterface(e){this.update(t=>{delete t.interfaces[e]})}updateInterfaceState(e,t){this.update(a=>{a.interfaces[e].state=t})}async resolveInterface(e,t,a){n(p,this,g).call(this,e,t),n(p,this,y).call(this,t),await n(p,this,S).call(this,t,a),this.deleteInterface(t)}}function b(){this.messagingSystem.registerActionHandler(`${h}:createInterface`,this.createInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:getInterface`,this.getInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterface`,this.updateInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:deleteInterface`,this.deleteInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterfaceState`,this.updateInterfaceState.bind(this)),this.messagingSystem.registerActionHandler(`${h}:resolveInterface`,this.resolveInterface.bind(this))}function g(e,t){const a=this.state.interfaces[t];(0,c.assert)(a!==undefined,`Interface with id '${t}' not found.`),(0,c.assert)(a.snapId===e,`Interface not created by ${e}.`)}function y(e){(0,c.assert)(n(p,this,v).call(this,e),`Approval request with id '${e}' not found.`)}function w(e){return this.messagingSystem.call("PhishingController:testOrigin",e).result}function v(e){return this.messagingSystem.call("ApprovalController:hasRequest",{id:e})}async function S(e,t){await this.messagingSystem.call("ApprovalController:acceptRequest",e,t)}function E(){return this.messagingSystem.call("AccountsController:getSelectedMultichainAccount")}function k(e){const t=this.messagingSystem.call("AccountsController:listMultichainAccounts");return e&&0!==e.length?t.filter(t=>t.scopes.some(t=>(0,u.isMatchingChainId)(t,e))):t}function T(e){const{address:t}=(0,c.parseCaipAccountId)(e);return this.messagingSystem.call("AccountsController:getAccountByAddress",t)}function _(){return this.messagingSystem.call("MultichainAssetsController:getState")}function P(e){return this.messagingSystem.call("SnapController:get",e)}function M(e){const t=(0,o.getJsonSizeUnsafe)(e);(0,c.assert)(t<=m,"A Snap UI may not be larger than 10 MB."),(0,o.validateJsxElements)(e,{isOnPhishingList:n(p,this,w).bind(this),getSnap:n(p,this,P).bind(this),getAccountByAddress:n(p,this,T).bind(this)})}function x(e){const t=e.filter(e=>"snap"===e.type&&(0,c.hasProperty)(e.data,"detailedView")),a=new Set(t.map(e=>e.data.detailedView.interfaceId));this.update(e=>{Object.entries(e.interfaces).forEach(([t,s])=>{s.contentType!==i.ContentType.Notification||a.has(t)||delete e.interfaces[t]})})}a.SnapInterfaceController=f}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"}],[2545,{"./SnapInterfaceController.cjs":2544},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./SnapInterfaceController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/index.cjs"}],[2546,{"@metamask/snaps-sdk":2676,"@metamask/snaps-sdk/jsx":2760,"@metamask/snaps-utils":2790,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.validateInterfaceContext=a.constructState=a.getAccountSelectorStateValue=a.getAssetSelectorStateValue=a.getAccountSelectorDefaultStateValue=a.getDefaultAsset=a.formatAccountSelectorStateValue=a.isMatchingChainId=a.assertNameIsUnique=a.getJsxInterface=a.isStatefulComponent=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/snaps-sdk/jsx"),r=e("@metamask/snaps-utils"),i=e("@metamask/utils"),o=["Input","Dropdown","RadioGroup","FileInput","Checkbox","Selector","AssetSelector","AddressInput","AccountSelector"];function c(e){return o.includes(e.type)}function l(e,t){(0,s.assert)(e[t]===undefined,`Duplicate component names are not allowed, found multiple instances of: "${t}".`)}function d(e,t){return"eip155:0"===e?t.some(e=>{const{namespace:t}=(0,i.parseCaipChainId)(e);return t===i.KnownCaipNamespace.Eip155}):t.includes(e)}function u(e,t){const{id:a,address:s,scopes:n}=e,i=(0,r.createChainIdList)(n,t);return{accountId:a,addresses:(0,r.createAccountList)(s,i)}}function m(e,t,{getAccountByAddress:a,getAssetsState:n}){var r;const{assetsMetadata:o,accountsAssets:c}=n(),l=e.map(e=>(0,i.parseCaipAccountId)(e)).map(({chainId:e})=>e),d=t&&t.length>0?l.filter(e=>t.includes(e)):l,u=null===(r=a(e[0]))||void 0===r?void 0:r.id;(0,s.assert)(u,`Account not found for address: ${e[0]}.`);const m=c[u];if(0===m.length)return null;const h=m.find(e=>{const{chainId:t,assetNamespace:a}=(0,i.parseCaipAssetType)(e);return d.includes(t)&&"slip44"===a});return h?{asset:h,name:o[h].name,symbol:o[h].symbol}:{asset:m[0],name:o[m[0]].name,symbol:o[m[0]].symbol}}function h(e,{getSelectedAccount:t,listAccounts:a,snapOwnsAccount:s}){const{chainIds:n,hideExternalAccounts:r}=e.props,i=t();if((!n||0===n.length||i.scopes.some(e=>d(e,n)))&&(!r||r&&s(i)))return u(i,n);const o=a(n),c=r?o.filter(e=>s(e)):o;return 0===c.length?null:u(c[0],n)}function p(e,t){if(!e)return null;const{assetsMetadata:a}=t(),s=a[e];return s?{asset:e,name:s.name??s.symbol??"Unknown",symbol:s.symbol??"Unknown"}:null}function f(e,{getAccountByAddress:t,snapOwnsAccount:a}){const{value:s,hideExternalAccounts:n}=e.props;if(!s)return null;const r=t(s);return r?n&&!a(r)?null:u(r,e.props.chainIds):null}function b(e,t,a,s){const n=s?e[s]:e,o=null==n?void 0:n[t.props.name];return"FileInput"===t.type?o??null:function(e,t){switch(e.type){case"Checkbox":return e.props.checked;case"AssetSelector":return p(e.props.value,t.getAssetsState);case"AddressInput":{if(!e.props.value)return null;const{namespace:t,reference:a}=(0,i.parseCaipChainId)(e.props.chainId);return(0,i.toCaipAccountId)(t,a,e.props.value)}case"AccountSelector":return f(e,t);default:return e.props.value}}(t,a)??o??function(e,t){switch(e.type){case"Dropdown":var a;return null===(a=(0,r.getJsxChildren)(e)[0])||void 0===a?void 0:a.props.value;case"RadioGroup":var s;return null===(s=(0,r.getJsxChildren)(e)[0])||void 0===s?void 0:s.props.value;case"Selector":var n;return null===(n=(0,r.getJsxChildren)(e)[0])||void 0===n?void 0:n.props.value;case"AccountSelector":return h(e,t);case"Checkbox":return!1;case"AssetSelector":return m(e.props.addresses,e.props.chainIds,t);default:return null}}(t,a)??null}a.isStatefulComponent=c,a.getJsxInterface=function(e){return(0,n.isJSXElementUnsafe)(e)?e:(0,r.getJsxElementFromComponent)(e)},a.assertNameIsUnique=l,a.isMatchingChainId=d,a.formatAccountSelectorStateValue=u,a.getDefaultAsset=m,a.getAccountSelectorDefaultStateValue=h,a.getAssetSelectorStateValue=p,a.getAccountSelectorStateValue=f,a.constructState=function(e,t,a){const s={},n=[];return(0,r.walkJsx)(t,(t,r)=>{let i=n[n.length-1];if(i&&r<=i.depth&&(n.pop(),i=n[n.length-1]),"Form"===t.type)return l(s,t.props.name),n.push({name:t.props.name,depth:r}),void(s[t.props.name]={});if(i&&c(t)){const n=s[i.name];return l(n,t.props.name),void(n[t.props.name]=b(e,t,a,i.name))}c(t)&&(l(s,t.props.name),s[t.props.name]=b(e,t,a))}),s};const g=5e6;a.validateInterfaceContext=function(e){if(!e)return;const t=(0,r.getJsonSizeUnsafe)(e);(0,s.assert)(t<=g,"A Snap interface context may not be larger than 5 MB.")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs"}],[2547,{"@metamask/snaps-utils":2790,"@metamask/utils":2913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.log=void 0;const s=e("@metamask/snaps-utils"),n=e("@metamask/utils");a.log=(0,n.createModuleLogger)(s.snapsLogger,"snaps-controllers")}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/logging.cjs"}],[2548,{"../snaps/index.cjs":2561,"@metamask/rpc-errors":2490,"@metamask/snaps-rpc-methods":2620,"@metamask/snaps-utils":2790,"@metamask/utils":2913,nanoid:5020},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){n(e,t),t.set(e,a)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t){return e.get(c(e,t))}function o(e,t,a){return e.set(c(e,t),a),a}function c(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.MultichainRouter=void 0;const l=e("@metamask/rpc-errors"),d=e("@metamask/snaps-rpc-methods"),u=e("@metamask/snaps-utils"),m=e("@metamask/utils"),h=e("nanoid"),p=e("../snaps/index.cjs"),f="MultichainRouter";var b=new WeakMap,g=new WeakMap,y=new WeakSet;async function w(e,t,a){try{const s=await i(g,this).call(this,async({keyring:s})=>s.resolveAccountAddress(e,t,a)),n=null==s?void 0:s.address;return n?(0,m.parseCaipAccountId)(n).address:null}catch{throw l.rpcErrors.internal()}}async function v(e,t,a){const s=i(b,this).call("AccountsController:listMultichainAccounts",t).filter(e=>{var t;return Boolean(null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled)&&e.methods.includes(a.method)});if(0===s.length)return null;const n=s[0].metadata.snap.id,r=await c(y,this,w).call(this,n,t,a),o=e.map(e=>(0,m.parseCaipAccountId)(e).address),d=s.find(e=>o.includes(e.address)&&(!r||e.address===r));if(!d)throw l.rpcErrors.invalidParams({message:"No available account found for request."});return d.id}function S(e){const t=i(b,this).call("SnapController:getAll");return(0,p.getRunnableSnaps)(t).reduce((t,a)=>{const s=i(b,this).call("PermissionController:getPermissions",a.id);if(s&&(0,m.hasProperty)(s,d.SnapEndowments.Protocol)){const n=s[d.SnapEndowments.Protocol],r=(0,d.getProtocolCaveatScopes)(n);r&&(0,m.hasProperty)(r,e)&&t.push({snapId:a.id,methods:r[e].methods})}return t},[])}function E(e){return i(b,this).call("AccountsController:listMultichainAccounts",e).filter(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})}a.MultichainRouter=class{constructor({messenger:e,withSnapKeyring:t}){var a,c;n(a=this,c=y),c.add(a),r(this,"name",f),r(this,"state",null),s(this,b,void 0),s(this,g,void 0),o(b,this,e),o(g,this,t),i(b,this).registerActionHandler(`${f}:handleRequest`,async(...e)=>this.handleRequest(...e)),i(b,this).registerActionHandler(`${f}:getSupportedMethods`,(...e)=>this.getSupportedMethods(...e)),i(b,this).registerActionHandler(`${f}:getSupportedAccounts`,(...e)=>this.getSupportedAccounts(...e)),i(b,this).registerActionHandler(`${f}:isSupportedScope`,(...e)=>this.isSupportedScope(...e))}async handleRequest({connectedAddresses:e,origin:t,scope:a,request:s}){(0,m.assert)(!a.startsWith(m.KnownCaipNamespace.Eip155)&&!a.startsWith("wallet:eip155"));const n={jsonrpc:"2.0",id:s.id??(0,h.nanoid)(),method:s.method,...s.params?{params:s.params}:{}},{method:r,params:o}=n,d=await c(y,this,v).call(this,e,a,n);if(d)return i(g,this).call(this,async({keyring:e})=>e.submitRequest({origin:t,account:d,scope:a,method:r,params:o}));const p=c(y,this,S).call(this,a).find(e=>e.methods.includes(r));if(p)return i(b,this).call("SnapController:handleRequest",{snapId:p.snapId,origin:t,request:{method:"",params:{request:n,scope:a}},handler:u.HandlerType.OnProtocolRequest});throw l.rpcErrors.methodNotFound()}getSupportedMethods(e){const t=c(y,this,E).call(this,e).flatMap(e=>e.methods),a=c(y,this,S).call(this,e).flatMap(e=>e.methods);return Array.from(new Set([...t,...a]))}getSupportedAccounts(e){return c(y,this,E).call(this,e).map(t=>`${e}:${t.address}`)}isSupportedScope(e){return i(b,this).call("AccountsController:listMultichainAccounts",e).some(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})||c(y,this,S).call(this,e).length>0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"}],[2549,{"./MultichainRouter.cjs":2548},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./MultichainRouter.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs"}],[255,{"../../../../shared/modules/fetch-with-timeout":5909,"./resolver":254,"base32-encode":3951,"base64-js":3952,"webextension-polyfill":5769},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.default=function({provider:e,getCurrentChainId:t,getIpfsGateway:a,getUseAddressBarEnsResolution:i}){const c=d.map(e=>`*://*.${e}/*`);return r.default.webRequest.onErrorOccurred.addListener(u,{urls:c,types:["main_frame"]}),{remove(){r.default.webRequest.onErrorOccurred.removeListener(u)}};async function u(c){const{tabId:u,url:m}=c;if(-1===u||"0x1"!==t())return;const{hostname:h,pathname:p,search:f,hash:b}=new URL(m),g=h.split("."),y=g[g.length-1];d.includes(y)&&async function({tabId:t,name:c,pathname:d,search:u,fragment:m}){const h=a(),p=i(),f=`https://app.ens.domains/name/${c}`;p&&h&&await r.default.tabs.update(t,{url:"loading.html"});let b=f;0;try{const{type:t,hash:a}=await(0,o.default)({provider:e,name:c});if("ipfs-ns"===t||"ipns-ns"===t){if(""===h)return void(b=null);const e=`https://${a}.${t.slice(0,4)}.${h}${d}${u||""}${m||""}`;try{200===(await l(e,{method:"HEAD"})).status&&(b=e)}catch(e){console.warn(e)}}else if("swarm-ns"===t)b=`https://swarm-gateways.net/bzz:/${a}${d}${u||""}${m||""}`;else if("onion"===t||"onion3"===t)b=`http://${a}.onion${d}${u||""}${m||""}`;else if("zeronet"===t)b=`http://127.0.0.1:43110/${a}${d}${u||""}${m||""}`;else if("skynet-ns"===t){const e=a.padEnd(a.length+4-a.length%4,"="),t=n.default.toByteArray(e),r={padding:!1};b=`https://${(0,s.default)(t,"RFC4648-HEX",r).toLowerCase()}.siasky.net${d}${u||""}${m||""}`}}catch(e){console.warn(e)}finally{b&&(p||!p&&b!==f)&&await r.default.tabs.update(t,{url:b})}}({tabId:u,name:h,pathname:p,search:f,fragment:b})}};var s=c(e("base32-encode")),n=c(e("base64-js")),r=c(e("webextension-polyfill")),i=c(e("../../../../shared/modules/fetch-with-timeout")),o=c(e("./resolver"));function c(e){return e&&e.__esModule?e:{default:e}}const l=(0,i.default)(),d=["eth"]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/setup.js"}],[2550,{"../logging.cjs":2547,"../snaps/Timer.cjs":2559,"../utils.cjs":2571,"@metamask/json-rpc-engine":1999,"@metamask/json-rpc-middleware-stream":2003,"@metamask/object-multiplex":2297,"@metamask/rpc-errors":2490,"@metamask/snaps-utils":2790,"@metamask/utils":2913,nanoid:5020,"readable-stream":2589},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){n(e,t),t.set(e,a)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t){return e.get(c(e,t))}function o(e,t,a){return e.set(c(e,t),a),a}function c(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}var l=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.setupMultiplex=a.AbstractExecutionService=void 0;const d=e("@metamask/json-rpc-engine"),u=e("@metamask/json-rpc-middleware-stream"),m=l(e("@metamask/object-multiplex")),h=e("@metamask/rpc-errors"),p=e("@metamask/snaps-utils"),f=e("@metamask/utils"),b=e("nanoid"),g=e("readable-stream"),y=e("../logging.cjs"),w=e("../snaps/Timer.cjs"),v=e("../utils.cjs"),S="ExecutionService";var E=new WeakMap,k=new WeakMap,T=new WeakMap,_=new WeakMap,P=new WeakMap,M=new WeakMap,x=new WeakMap,A=new WeakMap,C=new WeakSet;function I(){i(_,this).registerActionHandler(`${S}:handleRpcRequest`,async(e,t)=>this.handleRpcRequest(e,t)),i(_,this).registerActionHandler(`${S}:executeSnap`,async e=>this.executeSnap(e)),i(_,this).registerActionHandler(`${S}:terminateSnap`,async e=>this.terminateSnap(e)),i(_,this).registerActionHandler(`${S}:terminateAllSnaps`,async()=>this.terminateAllSnaps())}async function R(e,t){const{streams:a,worker:s}=await c(C,this,N).call(this,e,t),n=new d.JsonRpcEngine,r=(0,u.createStreamMiddleware)();(0,g.pipeline)(r.stream,a.command,r.stream,e=>{var t;!e||null!==(t=e.message)&&void 0!==t&&t.match("Premature close")||(0,p.logError)("Command stream failure.",e)}),n.push(r.middleware);const o={id:e,streams:a,rpcEngine:n,worker:s};return i(E,this).set(e,o),o}async function N(e,t){const a=await(0,v.withTimeout)(this.initEnvStream(e),t);if(a===v.hasTimedOut){this.terminateJob({id:e});if("created"===i(k,this).get(e))throw new Error(`The executor for "${e}" couldn't start initialization. The offscreen document may not exist.`);throw new Error(`The executor for "${e}" failed to initialize. The iframe/webview/worker failed to load.`)}const{worker:s,stream:n}=a,r=O(n,`Snap: "${e}"`),o=r.createStream(p.SNAP_STREAM_NAMES.COMMAND),c=t=>{(0,f.hasProperty)(t,"id")||("OutboundRequest"===t.method?i(_,this).publish("ExecutionService:outboundRequest",e):"OutboundResponse"===t.method?i(_,this).publish("ExecutionService:outboundResponse",e):"UnhandledError"===t.method?(i(_,this).publish("ExecutionService:unhandledError",e,t.params.error),o.removeListener("data",c)):(0,p.logError)(new Error(`Received unexpected command stream notification "${t.method}".`)))};o.on("data",c);const l=r.createStream(p.SNAP_STREAM_NAMES.JSON_RPC);l.on("data",t=>{null!=t&&t.data&&(0,f.hasProperty)(null==t?void 0:t.data,"id")&&i(_,this).publish("ExecutionService:outboundRequest",e)});const d=l.write.bind(l);return l.write=(t,a,s)=>{var n;return"metamask_chainChanged"===(null==t||null===(n=t.data)||void 0===n?void 0:n.method)||(null!=t&&t.data&&(0,f.hasProperty)(null==t?void 0:t.data,"id")&&i(_,this).publish("ExecutionService:outboundResponse",e),d(t,a,s))},{streams:{command:o,rpc:l,_connection:n},worker:s}}async function j(e,t){const a=i(E,this).get(e);if(!a)throw new Error(`"${e}" is not currently running.`);(0,y.log)("Parent: Sending Command",t);const s=await a.rpcEngine.handle(t);if((0,f.hasProperty)(s,"error")){const e=s.error;throw new h.JsonRpcError(e.code,e.message,e.data)}return s.result}function O(e,t){const a=new m.default;return(0,g.pipeline)(e,a,e,e=>{var a;!e||null!==(a=e.message)&&void 0!==a&&a.match("Premature close")||(0,p.logError)(`"${t}" stream failure.`,e)}),a}a.AbstractExecutionService=class{constructor({setupSnapProvider:e,messenger:t,initTimeout:a=(0,f.inMilliseconds)(60,f.Duration.Second),pingTimeout:i=(0,f.inMilliseconds)(2,f.Duration.Second),terminationTimeout:l=(0,f.inMilliseconds)(1,f.Duration.Second),usePing:d=!0}){var u,m;n(u=this,m=C),m.add(u),r(this,"name",S),r(this,"state",null),s(this,E,void 0),s(this,k,void 0),s(this,T,void 0),s(this,_,void 0),s(this,P,void 0),s(this,M,void 0),s(this,x,void 0),s(this,A,void 0),o(E,this,new Map),o(k,this,new Map),o(T,this,e),o(_,this,t),o(P,this,a),o(M,this,i),o(x,this,l),o(A,this,d),c(C,this,I).call(this)}async terminateSnap(e){const t=i(E,this).get(e);if(t){try{const t=await(0,v.withTimeout)(c(C,this,j).call(this,e,{jsonrpc:"2.0",method:"terminate",params:[],id:(0,b.nanoid)()}),i(x,this));t!==v.hasTimedOut&&"OK"===t||(0,p.logWarning)(`Snap "${e}" failed to terminate gracefully.`)}catch{}Object.values(t.streams).forEach(e=>{try{e.destroyed||e.destroy()}catch(e){(0,p.logError)("Error while destroying stream",e)}}),this.terminateJob(t),i(E,this).delete(e),i(k,this).delete(e),(0,y.log)(`Snap "${e}" terminated.`)}}setSnapStatus(e,t){i(k,this).set(e,t)}async terminateAllSnaps(){await Promise.all([...i(E,this).keys()].map(async e=>this.terminateSnap(e)))}async executeSnap({snapId:e,sourceCode:t,endowments:a}){if(i(E,this).has(e))throw new Error(`"${e}" is already running.`);this.setSnapStatus(e,"created");const s=new w.Timer(i(P,this)),n=await c(C,this,R).call(this,e,s);if(i(A,this)){if(await(0,v.withTimeout)(c(C,this,j).call(this,n.id,{jsonrpc:"2.0",method:"ping",id:(0,b.nanoid)()}),i(M,this))===v.hasTimedOut)throw new Error(`The executor for "${e}" was unreachable. The executor did not respond in time.`)}const r=n.streams.rpc;i(T,this).call(this,e,r);const o=Math.max(s.remaining,i(P,this)/2);this.setSnapStatus(e,"initialized");const l={jsonrpc:"2.0",method:"executeSnap",params:{snapId:e,sourceCode:t,endowments:a},id:(0,b.nanoid)()};(0,f.assertIsJsonRpcRequest)(l),this.setSnapStatus(e,"executing");const d=await(0,v.withTimeout)(c(C,this,j).call(this,n.id,l),o);if(d===v.hasTimedOut)throw new Error(`${e} failed to start.`);return"OK"===d&&this.setSnapStatus(e,"running"),d}async handleRpcRequest(e,t){const{handler:a,request:s,origin:n}=t;return await c(C,this,j).call(this,e,{id:(0,b.nanoid)(),jsonrpc:"2.0",method:"snapRpc",params:{origin:n,handler:a,request:s,target:e}})}},a.setupMultiplex=O}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs"}],[2551,{"@metamask/post-message-stream":2361},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){n(e,t),t.set(e,a)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,a){return e.set(o(e,t),a),a}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.ProxyPostMessageStream=void 0;const c=e("@metamask/post-message-stream");var l=new WeakMap,d=new WeakMap,u=new WeakSet;class m extends c.BasePostMessageStream{constructor({stream:e,jobId:t}){var a,c;super(),n(a=this,c=u),c.add(a),s(this,l,void 0),s(this,d,void 0),i(l,this,e),i(d,this,t),r(l,this).on("data",o(u,this,h).bind(this))}_postMessage(e){r(l,this).write({jobId:r(d,this),data:e})}}function h(e){e.jobId===r(d,this)&&this.push(e.data)}a.ProxyPostMessageStream=m}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs"}],[2552,{"../AbstractExecutionService.cjs":2550,"@metamask/post-message-stream":2361,"@metamask/snaps-utils":2790},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var s=a.call(e,t||"default");if("object"!=typeof s)return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}Object.defineProperty(a,"__esModule",{value:!0}),a.IframeExecutionService=void 0;const n=e("@metamask/post-message-stream"),r=e("@metamask/snaps-utils"),i=e("../AbstractExecutionService.cjs");class o extends i.AbstractExecutionService{constructor({iframeUrl:e,messenger:t,setupSnapProvider:a,...n}){super({...n,messenger:t,setupSnapProvider:a}),s(this,"iframeUrl",void 0),this.iframeUrl=e}terminateJob(e){var t;null===(t=document.getElementById(e.id))||void 0===t||t.remove()}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=await(0,r.createWindow)({uri:this.iframeUrl.toString(),id:e});return{worker:t,stream:new n.WindowPostMessageStream({name:"parent",target:"child",targetWindow:t,targetOrigin:"*"})}}}a.IframeExecutionService=o}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"}],[2553,{"./IframeExecutionService.cjs":2552},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./IframeExecutionService.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs"}],[2554,{"./AbstractExecutionService.cjs":2550,"./ProxyPostMessageStream.cjs":2551,"./iframe/index.cjs":2553,"./offscreen/index.cjs":2556},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./AbstractExecutionService.cjs"),a),n(e("./ProxyPostMessageStream.cjs"),a),n(e("./iframe/index.cjs"),a),n(e("./offscreen/index.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/index.cjs"}],[2555,{"../proxy/ProxyExecutionService.cjs":2557,"@metamask/post-message-stream":2361},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function n(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.OffscreenExecutionService=void 0;const r=e("@metamask/post-message-stream"),i=e("../proxy/ProxyExecutionService.cjs");var o=new WeakMap;class c extends i.ProxyExecutionService{constructor({messenger:e,setupSnapProvider:t,offscreenPromise:a,...i}){var c,l,d;super({...i,messenger:e,setupSnapProvider:t,stream:new r.BrowserRuntimePostMessageStream({name:"parent",target:"child"})}),s(this,o,void 0),l=this,d=a,(c=o).set(n(c,l),d)}async initEnvStream(e){var t,a;return await(t=o,a=this,t.get(n(t,a))),await super.initEnvStream(e)}}a.OffscreenExecutionService=c}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"}],[2556,{"./OffscreenExecutionService.cjs":2555},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]},n=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./OffscreenExecutionService.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"}],[2557,{"../AbstractExecutionService.cjs":2550,"../ProxyPostMessageStream.cjs":2551,nanoid:5020},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function s(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function n(e,t){return e.get(r(e,t))}function r(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.ProxyExecutionService=void 0;const i=e("nanoid"),o=e("../AbstractExecutionService.cjs"),c=e("../ProxyPostMessageStream.cjs");var l=new WeakMap;class d extends o.AbstractExecutionService{constructor({stream:e,messenger:t,setupSnapProvider:a,...n}){var i,o,c;super({...n,messenger:t,setupSnapProvider:a,usePing:!1}),s(this,l,void 0),o=this,c=e,(i=l).set(r(i,o),c)}async terminateJob(e){n(l,this).write({jobId:e.id,data:{jsonrpc:"2.0",method:"terminateJob",id:(0,i.nanoid)()}})}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=new c.ProxyPostMessageStream({stream:n(l,this),jobId:e});return await new Promise(e=>{t.once("data",e),t.write({name:"command",data:{jsonrpc:"2.0",method:"ping",id:(0,i.nanoid)()}})}),{worker:e,stream:t}}}a.ProxyExecutionService=d}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs"}]],[],{});