LavaPack.loadBundle([[2131,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[2132,{"./build/multichain-openrpc.json":2130,"./build/openrpc.json":2131},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.MultiChainOpenRPCDocument=s.MetaMaskOpenRPCDocument=void 0;const n=a(e("./build/openrpc.json"));s.MetaMaskOpenRPCDocument=n.default;const r=a(e("./build/multichain-openrpc.json"));s.MultiChainOpenRPCDocument=r.default,s.default=n.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],[214,{"../../platforms/extension":543,"./get-notification-image":212,"./get-notification-message":213},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.onPushNotificationClicked=async function(e,t){var s;e.notification.close();const a=t??(null==e||null===(s=e.notification)||void 0===s?void 0:s.data),n=`${c.getExtensionURL(null,null)}#notifications/${a.id}`;e.waitUntil(o.clients.openWindow(n))},s.onPushNotificationReceived=async function(e){const t=(0,i.createNotificationMessage)(e);if(!t)return;const s=null==o?void 0:o.registration;if(!s)return;const a=await(0,r.getNotificationImage)();await s.showNotification(t.title,{body:t.description,icon:a,tag:null==e?void 0:e.id,data:e})};var a,n=(a=e("../../platforms/extension"))&&a.__esModule?a:{default:a},r=e("./get-notification-image"),i=e("./get-notification-message");const o=self,c=new n.default}}},{package:"$root$",file:"app/scripts/controllers/push-notifications/index.ts"}],[215,{"../../../../shared/constants/common":5439,"../../../../shared/constants/gas":5444,"../../../../shared/constants/metametrics":5451,"../../../../shared/constants/network":5455,"../../../../shared/constants/smartTransactions":5465,"../../../../shared/constants/swaps":5470,"../../../../shared/constants/time":5472,"../../../../shared/lib/fetch-with-cache":5521,"../../../../shared/lib/sentry":5534,"../../../../shared/lib/swaps-utils":5538,"../../../../shared/lib/transactions-controller-utils":5543,"../../../../shared/modules/Numeric":5548,"../../../../shared/modules/conversion.utils":5553,"../../../../shared/modules/string-utils":5575,"../../../../shared/modules/swaps.utils":5576,"./swaps.constants":216,"./swaps.utils":217,"@ethersproject/contracts":693,"@ethersproject/providers":731,"@metamask/base-controller":1264,"bignumber.js":3686,"human-standard-token-abi":4344,lodash:4560},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var a=e("@ethersproject/contracts"),n=e("@ethersproject/providers"),r=e("@metamask/base-controller"),i=e("bignumber.js"),o=_(e("human-standard-token-abi")),c=e("lodash"),l=e("../../../../shared/lib/sentry"),d=e("../../../../shared/constants/common"),u=e("../../../../shared/constants/gas"),m=e("../../../../shared/constants/metametrics"),h=e("../../../../shared/constants/network"),p=e("../../../../shared/constants/smartTransactions"),f=e("../../../../shared/constants/swaps"),g=e("../../../../shared/constants/time"),b=_(e("../../../../shared/lib/fetch-with-cache")),y=e("../../../../shared/lib/swaps-utils"),w=e("../../../../shared/lib/transactions-controller-utils"),v=e("../../../../shared/modules/conversion.utils"),S=e("../../../../shared/modules/Numeric"),E=e("../../../../shared/modules/string-utils"),k=e("../../../../shared/modules/swaps.utils"),T=e("./swaps.constants"),P=e("./swaps.utils");function _(e){return e&&e.__esModule?e:{default:e}}function M(e,t,s){x(e,t),t.set(e,s)}function x(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function C(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function I(e,t){return e.get(N(e,t))}function A(e,t,s){return e.set(N(e,t),s),s}function N(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}const j={swapsState:{includeInStateLogs:!0,persist:!1,anonymous:!1,usedInUi:!0}};var O=new WeakMap,R=new WeakMap,$=new WeakMap,D=new WeakMap,B=new WeakMap,F=new WeakMap,L=new WeakSet;class H extends r.BaseController{constructor(e,t){var s,a,n;super({name:T.controllerName,metadata:j,messenger:e.messenger,state:{swapsState:{...(0,T.getDefaultSwapsControllerState)().swapsState,swapsFeatureFlags:(null==t||null===(s=t.swapsState)||void 0===s?void 0:s.swapsFeatureFlags)||{}}}}),x(a=this,n=L),n.add(a),C(this,"getBufferedGasLimit",void 0),C(this,"resetState",void 0),C(this,"trackMetaMetricsEvent",void 0),M(this,O,void 0),M(this,R,void 0),M(this,$,null),M(this,D,void 0),M(this,B,void 0),M(this,F,void 0),C(this,"_fetchTradesInfo",y.fetchTradesInfo),C(this,"__test__updateState",e=>{this.update(t=>({swapsState:{...t.swapsState,...e.swapsState}}))}),this.messagingSystem.registerActionHandler("SwapsController:fetchAndSetQuotes",this.fetchAndSetQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSelectedQuoteAggId",this.setSelectedQuoteAggId.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:resetSwapsState",this.resetSwapsState.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTokens",this.setSwapsTokens.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:clearSwapsQuotes",this.clearSwapsQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setApproveTxId",this.setApproveTxId.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setTradeTxId",this.setTradeTxId.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxGasPrice",this.setSwapsTxGasPrice.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxGasLimit",this.setSwapsTxGasLimit.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxMaxFeePerGas",this.setSwapsTxMaxFeePerGas.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsTxMaxFeePriorityPerGas",this.setSwapsTxMaxFeePriorityPerGas.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:safeRefetchQuotes",this.safeRefetchQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:stopPollingForQuotes",this.stopPollingForQuotes.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setBackgroundSwapRouteState",this.setBackgroundSwapRouteState.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:resetPostFetchState",this.resetPostFetchState.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsErrorKey",this.setSwapsErrorKey.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setInitialGasEstimate",this.setInitialGasEstimate.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setCustomApproveTxData",this.setCustomApproveTxData.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsLiveness",this.setSwapsLiveness.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsFeatureFlags",this.setSwapsFeatureFlags.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsUserFeeLevel",this.setSwapsUserFeeLevel.bind(this)),this.messagingSystem.registerActionHandler("SwapsController:setSwapsQuotesPollingLimitEnabled",this.setSwapsQuotesPollingLimitEnabled.bind(this)),this.getBufferedGasLimit=e.getBufferedGasLimit,this.trackMetaMetricsEvent=e.trackMetaMetricsEvent,this.resetState=()=>{this.update(e=>{e.swapsState={...(0,T.getDefaultSwapsControllerState)().swapsState,swapsFeatureFlags:null==e?void 0:e.swapsState.swapsFeatureFlags}})},A(D,this,e.getEIP1559GasFeeEstimates),A(B,this,e.getLayer1GasFee),A(O,this,0),A(R,this,0),this._fetchTradesInfo=e.fetchTradesInfo||y.fetchTradesInfo}clearSwapsQuotes(){this.update(e=>{e.swapsState.quotes={},e.swapsState.selectedAggId=null,e.swapsState.topAggId=null})}async fetchAndSetQuotes(e,t,s=!1){var a;if(!e)return null;let n;n=(null===(a=I(F,this))||void 0===a?void 0:a.clientId)===t.networkClientId?I(F,this):N(L,this,U).call(this,t.networkClientId);const{quotesPollingLimitEnabled:r,saveFetchedQuotes:i}=this.state.swapsState;s||A(R,this,0),I($,this)&&clearTimeout(I($,this)),s||this.setSwapsErrorKey("");const o=I(O,this)+1;A(O,this,o),i||this._setSaveFetchedQuotes(!0);let[l]=await Promise.all([this._fetchTradesInfo(e,{chainId:n.chainId}),this._setSwapsNetworkConfig(n)]);const{saveFetchedQuotes:d}=this.state.swapsState;if(!d)return[{},null];l=(0,c.mapValues)(l,e=>({...e,sourceTokenInfo:null==t?void 0:t.sourceTokenInfo,destinationTokenInfo:null==t?void 0:t.destinationTokenInfo}));const u=n.chainId===h.CHAIN_IDS.OPTIMISM.toString(),m=n.chainId===h.CHAIN_IDS.BASE.toString();(u||m)&&Object.values(l).length>0&&await Promise.all(Object.values(l).map(async e=>{if(e.trade){const t=await I(B,this).call(this,{transactionParams:e.trade,networkClientId:n.clientId});e.multiLayerL1TradeFeeTotal=t}return e}));const p=Date.now();let g=!1;if(!(0,k.isSwapsDefaultTokenAddress)(e.sourceToken,n.chainId)&&Object.values(l).length){const t=await this._getERC20Allowance(e.sourceToken,e.fromAddress,n),[a]=Object.values(l);if(g=a.approvalNeeded&&(t.eq(0)||t.lt(a.sourceAmount))&&"wrappedNative"!==a.aggregator,g){if(!s&&a.approvalNeeded){const{gasLimit:e}=await this._timedoutGasReturn(a.approvalNeeded,a.aggregator);l=(0,c.mapValues)(l,t=>t.approvalNeeded?{...t,approvalNeeded:{...t.approvalNeeded,gas:e||f.DEFAULT_ERC20_APPROVE_GAS}}:t)}}else l=(0,c.mapValues)(l,e=>({...e,approvalNeeded:null}))}let b=null;if(g||null!=e&&e.balanceError||(l=await this._getAllQuotesWithGasEstimates(l)),0===Object.values(l).length)this.setSwapsErrorKey(f.QUOTES_NOT_AVAILABLE_ERROR);else{const e=await this.getTopQuoteWithCalculatedSavings({quotes:l});Array.isArray(e)&&(b=e[0],l=e[1])}if(I(O,this)!==o)throw new Error(f.SWAPS_FETCH_ORDER_CONFLICT);let{selectedAggId:y}=this.state.swapsState;return y&&l[y]||(y=null),this.update(s=>{s.swapsState.quotes=l,s.swapsState.fetchParams={...e,metaData:t},s.swapsState.quotesLastFetched=p,s.swapsState.selectedAggId=y,s.swapsState.topAggId=b}),r&&A(R,this,I(R,this)+1),!r||I(R,this)<T.POLL_COUNT_LIMIT+1?(this._pollForNewQuotes(),[l,b]):(this.resetPostFetchState(),this.setSwapsErrorKey(f.QUOTES_EXPIRED_ERROR),null)}async getTopQuoteWithCalculatedSavings({quotes:e,networkClientId:t}){var s;let a;if(t){const e=this.messagingSystem.call("NetworkController:getNetworkClientById",t);a=e.configuration.chainId}else{if(I(F,this)===undefined)throw new Error("There is no network set");a=I(F,this).chainId}const{marketData:n}=this._getTokenRatesState(),r=(null==n?void 0:n[a])??{},{customGasPrice:o,customMaxPriorityFeePerGas:l}=this.state.swapsState;if(0===Object.keys(e).length)return{};const m=(0,c.cloneDeep)(e),{gasFeeEstimates:h,gasEstimateType:p}=await I(D,this).call(this,{networkClientId:t});let f="0x0";if(p===u.GasEstimateTypes.feeMarket){const{high:{suggestedMaxPriorityFeePerGas:e},estimatedBaseFee:t}=h,s=(0,v.decGWEIToHexWEI)(Number(e)),a=new S.Numeric(t,10,d.EtherDenomination.GWEI).toDenomination(d.EtherDenomination.WEI);f=new S.Numeric(l||s,16).add(a).round(6).toString()}else p===u.GasEstimateTypes.legacy?f=o||(0,v.decGWEIToHexWEI)(Number(h.high)):p===u.GasEstimateTypes.ethGasPrice&&(f=o||(0,v.decGWEIToHexWEI)(Number(h.gasPrice)));let g,b="";Object.values(m).forEach(e=>{const{aggregator:t,approvalNeeded:s,averageGas:n,destinationAmount:o,destinationToken:c,destinationTokenInfo:l,gasEstimateWithRefund:u,sourceAmount:m,sourceToken:h,trade:p,fee:y,multiLayerL1TradeFeeTotal:P}=e;if(!p||!c)return;const _=(u?new i.BigNumber(u,16):new i.BigNumber(n||T.MAX_GAS_LIMIT,10)).plus((null==s?void 0:s.gas)||"0x0",16).toString(16);let M=(0,w.calcGasTotal)(_,f);null!==P&&(M=(0,v.sumHexes)(M||"0x0",P||"0x0"));const x=new S.Numeric(M,16,d.EtherDenomination.WEI).add(new S.Numeric(p.value,16,d.EtherDenomination.WEI)),C=x.toDenomination(d.EtherDenomination.ETH).round(6).value,I=(0,k.isSwapsDefaultTokenAddress)(h,a)?x.minus(new S.Numeric(m,10)).toDenomination(d.EtherDenomination.ETH).round(6).value:C,A=(0,w.calcTokenAmount)(o??"0",l.decimals),N=new i.BigNumber(100,10).minus(y,10).div(100),j=A.div(N).minus(A),O=Object.keys(r).find(e=>(0,E.isEqualCaseInsensitive)(e,c)),R=O?r[O]:null,$=(null==R?void 0:R.price)||1,D=A.times($.toString(10),10),B=(0,k.isSwapsDefaultTokenAddress)(c,a)?1:null==R?void 0:R.price,F=B?D.minus(I,10):D;e.ethFee=I.toString(10),B&&(e.ethValueOfTokens=D.toString(10),e.overallValueOfQuote=F.toString(10),e.metaMaskFeeInEth=j.times(B.toString(10)).toString(10)),g&&!F.gt(g||0)||(b=t,g=F)});const y=Object.keys(r).find(e=>{var t;return(0,E.isEqualCaseInsensitive)(e,null===(t=m[b])||void 0===t?void 0:t.destinationToken)}),_=y?r[y]:null;if((0,k.isSwapsDefaultTokenAddress)(null===(s=m[b])||void 0===s?void 0:s.destinationToken,a)||Boolean(null==_?void 0:_.price)){const e=m[b],{ethFee:t,metaMaskFeeInEth:s,ethValueOfTokens:a}=(0,P.getMedianEthValueQuote)(Object.values(m)),n=new i.BigNumber(e.ethValueOfTokens,10).minus(a,10).toString(10),r=new i.BigNumber(t).minus(e.ethFee,10).toString(10),o=e.metaMaskFeeInEth,c={performance:n,fee:r,total:new i.BigNumber(n).plus(r).minus(o).toString(10),metaMaskFee:o,medianMetaMaskFee:s};m[b].isBestQuote=!0,m[b].savings=c}return[b,m]}resetPostFetchState(){this.update(e=>{e.swapsState={...(0,T.getDefaultSwapsControllerState)().swapsState,tokens:e.swapsState.tokens,fetchParams:e.swapsState.fetchParams,swapsFeatureIsLive:e.swapsState.swapsFeatureIsLive,swapsQuoteRefreshTime:e.swapsState.swapsQuoteRefreshTime,swapsQuotePrefetchingRefreshTime:e.swapsState.swapsQuotePrefetchingRefreshTime,swapsFeatureFlags:e.swapsState.swapsFeatureFlags}}),I($,this)&&clearTimeout(I($,this))}resetSwapsState(){this.update(e=>{e.swapsState={...(0,T.getDefaultSwapsControllerState)().swapsState,swapsQuoteRefreshTime:e.swapsState.swapsQuoteRefreshTime,swapsQuotePrefetchingRefreshTime:e.swapsState.swapsQuotePrefetchingRefreshTime,swapsFeatureFlags:e.swapsState.swapsFeatureFlags}}),I($,this)&&clearTimeout(I($,this))}safeRefetchQuotes(){!I($,this)&&this.state.swapsState.fetchParams&&this.fetchAndSetQuotes(this.state.swapsState.fetchParams,{...this.state.swapsState.fetchParams.metaData})}setApproveTxId(e){this.update(t=>{t.swapsState.approveTxId=e})}setBackgroundSwapRouteState(e){this.update(t=>{t.swapsState.routeState=e})}setCustomApproveTxData(e){this.update(t=>{t.swapsState.customApproveTxData=e})}async setInitialGasEstimate(e){const t={...this.state.swapsState.quotes[e]},{gasLimit:s,simulationFails:a}=t.trade?await this._timedoutGasReturn(t.trade,t.aggregator):{gasLimit:null,simulationFails:!0};if(s&&!a){const e=(0,P.calculateGasEstimateWithRefund)(t.maxGas,t.estimatedRefund,s);t.gasEstimate=s,t.gasEstimateWithRefund=e}this.update(s=>{s.swapsState.quotes={...s.swapsState.quotes,[e]:t}})}setSelectedQuoteAggId(e){this.update(t=>{t.swapsState.selectedAggId=e})}setSwapsFeatureFlags(e){this.update(t=>{t.swapsState.swapsFeatureFlags=e})}setSwapsErrorKey(e){this.update(t=>{t.swapsState.errorKey=e})}setSwapsLiveness(e){const{swapsFeatureIsLive:t}=e;this.update(e=>{e.swapsState.swapsFeatureIsLive=t})}setSwapsQuotesPollingLimitEnabled(e){this.update(t=>{t.swapsState.quotesPollingLimitEnabled=e})}setSwapsTokens(e){this.update(t=>{t.swapsState.tokens=e})}setSwapsTxGasLimit(e){this.update(t=>{t.swapsState.customMaxGas=e})}setSwapsTxGasPrice(e){this.update(t=>{t.swapsState.customGasPrice=e})}setSwapsTxMaxFeePerGas(e){this.update(t=>{t.swapsState.customMaxFeePerGas=e})}setSwapsTxMaxFeePriorityPerGas(e){this.update(t=>{t.swapsState.customMaxPriorityFeePerGas=e})}setSwapsUserFeeLevel(e){this.update(t=>{t.swapsState.swapsUserFeeLevel=e})}setTradeTxId(e){this.update(t=>{t.swapsState.tradeTxId=e})}stopPollingForQuotes(){I($,this)&&clearTimeout(I($,this))}async _fetchSwapsNetworkConfig(e){const t=await(0,b.default)({url:(0,y.getBaseApi)("network",e.chainId),fetchOptions:{method:"GET"},cacheOptions:{cacheRefreshTime:6e5},functionName:"_fetchSwapsNetworkConfig"}),{refreshRates:s,parameters:a={}}=t||{};if(!s||"number"!=typeof s.quotes||"number"!=typeof s.quotesPrefetching)throw new Error(`MetaMask - invalid response for refreshRates: ${t}`);return{quotes:1e3*s.quotes,quotesPrefetching:1e3*s.quotesPrefetching,stxGetTransactions:1e3*s.stxGetTransactions,stxBatchStatus:1e3*s.stxBatchStatus,stxStatusDeadline:s.stxStatusDeadline,stxMaxFeeMultiplier:a.stxMaxFeeMultiplier}}async _getAllQuotesWithGasEstimates(e){const t=await Promise.all(Object.values(e).map(async e=>{if(!e.trade)return{gasLimit:null,simulationFails:!0,aggId:e.aggregator};const{gasLimit:t,simulationFails:s}=await this._timedoutGasReturn(e.trade,e.aggregator);return{gasLimit:t,simulationFails:s,aggId:e.aggregator}})),s={};return t.forEach(({gasLimit:t,simulationFails:a,aggId:n})=>{if(t&&!a){const a=(0,P.calculateGasEstimateWithRefund)(e[n].maxGas,e[n].estimatedRefund,t);s[n]={...e[n],gasEstimate:t,gasEstimateWithRefund:a}}else e[n].approvalNeeded&&(s[n]=e[n])}),s}async _getERC20Allowance(e,t,s){const n=new a.Contract(e,o.default,s.ethersProvider);return await n.allowance(t,f.SWAPS_CHAINID_CONTRACT_ADDRESS_MAP[s.chainId])}_getTokenRatesState(){const{marketData:e}=this.messagingSystem.call("TokenRatesController:getState");return{marketData:e}}_pollForNewQuotes(){const{swapsQuoteRefreshTime:e,swapsQuotePrefetchingRefreshTime:t,quotesPollingLimitEnabled:s}=this.state.swapsState;A($,this,setTimeout(()=>{var e;this.fetchAndSetQuotes(this.state.swapsState.fetchParams,null===(e=this.state.swapsState.fetchParams)||void 0===e?void 0:e.metaData,!0)},s?e:t))}_setSaveFetchedQuotes(e){this.update(t=>{t.swapsState.saveFetchedQuotes=e})}async _setSwapsNetworkConfig(e){let t=null;try{t=await this._fetchSwapsNetworkConfig(e)}catch(e){console.error("Request for Swaps network config failed: ",e)}this.update(e=>{var s,a,n,r,i,o;e.swapsState.swapsQuoteRefreshTime=(null===(s=t)||void 0===s?void 0:s.quotes)||T.FALLBACK_QUOTE_REFRESH_TIME,e.swapsState.swapsQuotePrefetchingRefreshTime=(null===(a=t)||void 0===a?void 0:a.quotesPrefetching)||T.FALLBACK_QUOTE_REFRESH_TIME,e.swapsState.swapsStxGetTransactionsRefreshTime=(null===(n=t)||void 0===n?void 0:n.stxGetTransactions)||p.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,e.swapsState.swapsStxBatchStatusRefreshTime=(null===(r=t)||void 0===r?void 0:r.stxBatchStatus)||p.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,e.swapsState.swapsStxMaxFeeMultiplier=(null===(i=t)||void 0===i?void 0:i.stxMaxFeeMultiplier)||p.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER,e.swapsState.swapsStxStatusDeadline=(null===(o=t)||void 0===o?void 0:o.stxStatusDeadline)||p.FALLBACK_SMART_TRANSACTIONS_DEADLINE})}_timedoutGasReturn(e,t=""){return new Promise(s=>{let a=!1;const n=setTimeout(()=>{a=!0,this.trackMetaMetricsEvent({event:m.MetaMetricsEventName.QuoteError,category:m.MetaMetricsEventCategory.Swaps,properties:{error_type:m.MetaMetricsEventErrorType.GasTimeout,aggregator:t}}),s({gasLimit:null,simulationFails:!0})},5*g.SECOND),r={data:e.data,from:e.from,to:e.to,value:e.value};this.getBufferedGasLimit({txParams:r},1).then(({gasLimit:e,simulationFails:t})=>{a||(clearTimeout(n),s({gasLimit:e,simulationFails:t}))}).catch(e=>{(0,l.captureException)(e,{extra:{aggregator:t}}),a||(clearTimeout(n),s({gasLimit:null,simulationFails:!0}))})})}}function U(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e),{chainId:s}=t.configuration,a={client:t,clientId:e,chainId:s,ethersProvider:new n.Web3Provider(t.provider)};return A(F,this,a),a}s.default=H}}},{package:"$root$",file:"app/scripts/controllers/swaps/index.ts"}],[216,{"../../../../shared/constants/smartTransactions":5465,"../../../../shared/constants/time":5472},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.controllerName=s.POLL_COUNT_LIMIT=s.MAX_GAS_LIMIT=s.FALLBACK_QUOTE_REFRESH_TIME=void 0,s.getDefaultSwapsControllerState=function(){return{swapsState:{quotes:{},quotesPollingLimitEnabled:!1,fetchParams:null,tokens:null,tradeTxId:null,approveTxId:null,quotesLastFetched:null,customMaxGas:"",customGasPrice:null,customMaxFeePerGas:null,customMaxPriorityFeePerGas:null,swapsUserFeeLevel:"",selectedAggId:null,customApproveTxData:"",errorKey:"",topAggId:null,routeState:"",swapsFeatureIsLive:!0,saveFetchedQuotes:!1,swapsQuoteRefreshTime:r,swapsQuotePrefetchingRefreshTime:r,swapsStxBatchStatusRefreshTime:a.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,swapsStxStatusDeadline:a.FALLBACK_SMART_TRANSACTIONS_DEADLINE,swapsStxGetTransactionsRefreshTime:a.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,swapsStxMaxFeeMultiplier:a.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER,swapsFeatureFlags:{}}}};var a=e("../../../../shared/constants/smartTransactions"),n=e("../../../../shared/constants/time");s.controllerName="SwapsController",s.MAX_GAS_LIMIT=25e5,s.POLL_COUNT_LIMIT=3;const r=s.FALLBACK_QUOTE_REFRESH_TIME=n.MINUTE}}},{package:"$root$",file:"app/scripts/controllers/swaps/swaps.constants.ts"}],[217,{"./swaps.constants":216,"bignumber.js":3686},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.calculateGasEstimateWithRefund=function(e=n.MAX_GAS_LIMIT,t="0",s="0"){const r=new a.BigNumber(e,10).minus(t,10),i=r.lt(0);return!i&&r.lt(s,16)?`0x${r.toString(16)}`:s},s.getMedianEthValueQuote=function(e){if(!Array.isArray(e)||0===e.length)throw new Error("Expected non-empty array param.");const t=[...e];if(t.sort((e,t)=>{const s=new a.BigNumber(e.overallValueOfQuote,10),n=new a.BigNumber(t.overallValueOfQuote,10);return s.equals(n)?0:s.lessThan(n)?-1:1}),t.length%2==1){const e=t[(t.length-1)/2].overallValueOfQuote;return r(t.filter(t=>e===t.overallValueOfQuote))}const s=t.length/2,n=s-1,i=t[s].overallValueOfQuote,o=t[n].overallValueOfQuote,c=t.filter(e=>i===e.overallValueOfQuote),l=t.filter(e=>o===e.overallValueOfQuote),d=r(c),u=r(l);return{ethFee:new a.BigNumber(d.ethFee,10).plus(u.ethFee,10).dividedBy(2).toString(10),metaMaskFeeInEth:new a.BigNumber(d.metaMaskFeeInEth,10).plus(u.metaMaskFeeInEth,10).dividedBy(2).toString(10),ethValueOfTokens:new a.BigNumber(d.ethValueOfTokens,10).plus(u.ethValueOfTokens,10).dividedBy(2).toString(10)}},s.meansOfQuotesFeesAndValue=r;var a=e("bignumber.js"),n=e("./swaps.constants");function r(e){const t=e.reduce((e,t)=>({ethFee:e.ethFee.plus(t.ethFee,10),metaMaskFeeInEth:e.metaMaskFeeInEth.plus(t.metaMaskFeeInEth,10),ethValueOfTokens:e.ethValueOfTokens.plus(t.ethValueOfTokens,10)}),{ethFee:new a.BigNumber(0,10),metaMaskFeeInEth:new a.BigNumber(0,10),ethValueOfTokens:new a.BigNumber(0,10)});return{ethFee:t.ethFee.div(e.length,10).toString(10),metaMaskFeeInEth:t.metaMaskFeeInEth.div(e.length,10).toString(10),ethValueOfTokens:t.ethValueOfTokens.div(e.length,10).toString(10)}}}}},{package:"$root$",file:"app/scripts/controllers/swaps/swaps.utils.ts"}],[218,{"../../shared/constants/app":5436,"./lib/util":328,"webextension-polyfill":5424},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.onMessageReceived=s.checkForMultipleVersionsRunning=void 0;var a,n=(a=e("webextension-polyfill"))&&a.__esModule?a:{default:a},r=e("../../shared/constants/app"),i=e("./lib/util");const o="isRunning";s.onMessageReceived=e=>{e===o&&console.warn("Warning! You have multiple instances of MetaMask running!")};s.checkForMultipleVersionsRunning=async()=>{if((0,i.getPlatform)()!==r.PLATFORM_CHROME&&(0,i.getPlatform)()!==r.PLATFORM_FIREFOX)return;const e=(0,i.getPlatform)()===r.PLATFORM_CHROME?r.CHROME_BUILD_IDS:r.FIREFOX_BUILD_IDS,t=n.default.runtime.id;for(const s of e)if(s!==t)try{await n.default.runtime.sendMessage(s,o)}catch(e){}}}}},{package:"$root$",file:"app/scripts/detect-multiple-instances.js"}],[219,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;s.default={config:{}}}}},{package:"$root$",file:"app/scripts/first-time-state.js"}],[22,{"../../../../shared/constants/network":5455,"@metamask/keyring-api":2036,"@metamask/network-enablement-controller":2239,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.NetworkEnablementControllerInit=void 0;var a=e("@metamask/network-enablement-controller"),n=e("@metamask/keyring-api"),r=e("@metamask/utils"),i=e("../../../../shared/constants/network");const o=(e,t)=>{const s={[r.KnownCaipNamespace.Eip155]:{}};return Object.keys(e).forEach(e=>{s[r.KnownCaipNamespace.Eip155][e]=t.includes(e)}),s},c=(e,t=[])=>{const s={};return Object.keys(e).forEach(e=>{const a=t.includes(e),{namespace:n}=(0,r.parseCaipChainId)(e);(s[n]??(s[n]={}))[e]=a}),s},l=(e,t)=>{const{networkConfigurationsByChainId:s}=e,{multichainNetworkConfigurationsByChainId:a}=t;const r=[n.SolScope.Mainnet];return r.push(n.BtcScope.Mainnet),{enabledNetworkMap:{...o(s,i.FEATURED_NETWORK_CHAIN_IDS),...c(a,r)}}};s.NetworkEnablementControllerInit=({controllerMessenger:e,initMessenger:t,persistedState:s,getController:i})=>{const o=i("MultichainNetworkController").state,c=i("NetworkController").state,d=new a.NetworkEnablementController({messenger:e,state:{...l(c,o),...s.NetworkEnablementController}});return t.subscribe("AccountsController:selectedAccountChange",e=>{e.type===n.SolAccountType.DataAccount&&d.enableNetworkInNamespace(n.SolScope.Mainnet,r.KnownCaipNamespace.Solana)}),t.subscribe("AccountTreeController:selectedAccountGroupChange",()=>{const e=t.call("AccountTreeController:getAccountsFromSelectedAccountGroup",{scopes:[n.SolScope.Mainnet]}),s=t.call("AccountTreeController:getAccountsFromSelectedAccountGroup",{scopes:[n.BtcScope.Mainnet]}),a=Object.values(d.state.enabledNetworkMap).reduce((e,t)=>({...e,...t}),{});if(1===Object.keys(a).length){const t=Object.keys(a)[0];let r=!1;t===n.SolScope.Mainnet&&0===e.length&&(r=!0),t===n.BtcScope.Mainnet&&0===s.length&&(r=!0),r&&d.enableNetwork("0x1")}}),{controller:d}}}}},{package:"$root$",file:"app/scripts/controller-init/assets/network-enablement-controller-init.ts"}],[220,{"@metamask/name-controller":2198},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ChangeType=s.AbstractPetnamesBridge=void 0;var a=e("@metamask/name-controller");function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function r(e,t,s){i(e,t),t.set(e,s)}function i(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function o(e,t){return e.get(l(e,t))}function c(e,t,s){return e.set(l(e,t),s),s}function l(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}let d=s.ChangeType=function(e){return e.ADDED="ADDED",e.UPDATED="UPDATED",e.DELETED="DELETED",e}({});var u=function(e){return e.SOURCE_TO_PETNAMES="Source->Petnames",e.PETNAMES_TO_SOURCE="Petnames->Source",e}(u||{});function m({type:e,variation:t,value:s}){return`${e}/${t}/${e===a.NameType.ETHEREUM_ADDRESS?s.toLowerCase():s}`}var h=new WeakMap,p=new WeakMap,f=new WeakMap,g=new WeakSet;function b(e){if(o(f,this)===e)throw new Error(`Attempted to synchronize recursively in same direction: ${e}`);if(null!==o(f,this))return;c(f,this,e);const[t,s]="Source->Petnames"===e?[this.getSourceEntries(),l(g,this,y).call(this)]:[l(g,this,y).call(this),this.getSourceEntries()],a=l(g,this,v).call(this,s,t);l(g,this,S).call(this,a),c(f,this,null)}function y(){const{names:e}=o(p,this).state,t=[];for(const s of Object.values(a.NameType))for(const a of Object.keys(e[s]))for(const n of Object.keys(e[s][a])){const{name:r,sourceId:i,origin:o}=e[s][a][n];if(!r)continue;const c={value:a,type:s,name:r,variation:n,sourceId:i??undefined,origin:o??undefined};this.shouldSyncPetname(c)&&t.push(c)}return t}function w(e,t){e===d.DELETED?(delete t.sourceId,delete t.origin,o(p,this).setName({...t,name:null})):o(p,this).setName(t)}function v(e,t){const s=[],a=[],n=[],r=new Map(e.map(e=>[m(e),e])),i=new Map(t.map(e=>[m(e),e]));return i.forEach((e,t)=>{const n=r.get(t);n?e.name!==n.name&&a.push(e):s.push(e)}),r.forEach((e,t)=>{i.has(t)||n.push(e)}),{[d.ADDED]:s,[d.UPDATED]:a,[d.DELETED]:n}}function S(e){const t=o(f,this)===u.SOURCE_TO_PETNAMES?l(g,this,w).bind(this):this.updateSourceEntry.bind(this);for(const s of Object.values(d))for(const a of e[s])t(s,a)}s.AbstractPetnamesBridge=class{constructor({isTwoWay:e,nameController:t,messenger:s}){var a,o;i(a=this,o=g),o.add(a),r(this,h,void 0),r(this,p,void 0),r(this,f,null),n(this,"messenger",void 0),c(h,this,e),c(p,this,t),this.messenger=s}init(){o(h,this)&&this.messenger.subscribe("NameController:stateChange",()=>l(g,this,b).call(this,u.PETNAMES_TO_SOURCE)),this.onSourceChange(()=>l(g,this,b).call(this,u.SOURCE_TO_PETNAMES))}updateSourceEntry(e,t){throw new Error("updateSourceEntry must be overridden for two-way bridges")}shouldSyncPetname(e){return!0}}}}},{package:"$root$",file:"app/scripts/lib/AbstractPetnamesBridge.ts"}],[221,{"./AbstractPetnamesBridge":220,"@metamask/name-controller":2198},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AccountIdentitiesPetnamesBridge=void 0;var a=e("@metamask/name-controller"),n=e("./AbstractPetnamesBridge");class r extends n.AbstractPetnamesBridge{constructor({nameController:e,messenger:t}){super({isTwoWay:!1,nameController:e,messenger:t})}getSourceEntries(){return this.messenger.call("AccountsController:listAccounts").map(e=>({value:e.address,type:a.NameType.ETHEREUM_ADDRESS,name:e.metadata.name,sourceId:undefined,variation:a.FALLBACK_VARIATION,origin:a.NameOrigin.ACCOUNT_IDENTITY}))}onSourceChange(e){this.messenger.subscribe("AccountsController:stateChange",e)}shouldSyncPetname(e){return e.origin===a.NameOrigin.ACCOUNT_IDENTITY}}s.AccountIdentitiesPetnamesBridge=r}}},{package:"$root$",file:"app/scripts/lib/AccountIdentitiesPetnamesBridge.ts"}],[222,{"./AbstractPetnamesBridge":220,"@metamask/name-controller":2198,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AddressBookPetnamesBridge=void 0;var a=e("@metamask/name-controller"),n=e("@metamask/utils"),r=e("./AbstractPetnamesBridge");function i(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function o(e,t){return e.get(c(e,t))}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var l=new WeakMap;class d extends r.AbstractPetnamesBridge{constructor({addressBookController:e,nameController:t,messenger:s}){var a,n,r;super({isTwoWay:!0,nameController:t,messenger:s}),i(this,l,void 0),n=this,r=e,(a=l).set(c(a,n),r)}getSourceEntries(){const e=[],{state:t}=o(l,this);for(const s of Object.keys(t.addressBook)){if(!(0,n.isStrictHexString)(s))continue;const r=t.addressBook[s];for(const n of Object.keys(r)){const r=t.addressBook[s][n],i=s.toLowerCase(),{name:o,isEns:c}=r;null!=o&&o.length&&null!=n&&n.length&&e.push({value:n,name:o,variation:i,type:a.NameType.ETHEREUM_ADDRESS,sourceId:c?"ens":undefined,origin:a.NameOrigin.ADDRESS_BOOK})}}return e}updateSourceEntry(e,t){e===r.ChangeType.DELETED?o(l,this).delete(t.variation,t.value):o(l,this).set(t.value,t.name,t.variation)}onSourceChange(e){this.messenger.subscribe("AddressBookController:stateChange",e)}}s.AddressBookPetnamesBridge=d}}},{package:"$root$",file:"app/scripts/lib/AddressBookPetnamesBridge.ts"}],[223,{"@metamask/base-controller":1264,"@metamask/obs-store":2295},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var a=e("@metamask/obs-store"),n=e("@metamask/base-controller");function r(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function i(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function o(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var c=new WeakSet;class l extends a.ObservableStore{constructor({config:e,controllerMessenger:t,state:s,persist:a}){super(s),r(this,c),i(this,"config",{}),this.persist=a,this.controllerMessenger=t,e&&this.updateStructure(e)}updateStructure(e){this.config=e,this.removeAllListeners();const t={};for(const a of Object.keys(e)){var s;if(!e[a])throw new Error(`Undefined '${a}'`);const r=e[a];r.subscribe?e[a].subscribe(e=>{o(c,this,d).call(this,a,e)}):this.persist?this.controllerMessenger.subscribe(`${r.name}:stateChange`,(t,s)=>{o(c,this,u).call(this,e[a].metadata,s)&&o(c,this,d).call(this,a,(0,n.getPersistentState)(t,e[a].metadata),s)}):this.controllerMessenger.subscribe(`${r.name}:stateChange`,(e,t)=>o(c,this,d).call(this,a,e,t));const i=r.state??(null===(s=r.getState)||void 0===s?void 0:s.call(r));t[a]=this.persist&&e[a].metadata?(0,n.getPersistentState)(i,e[a].metadata):i}this.updateState(t)}getFlatState(){if(!this.config)return{};let e={};for(const t of Object.keys(this.config)){const s=this.config[t],a=s.getState?s.getState():s.state;e={...e,...a}}return e}}function d(e,t,s){const a=this.getState()[e];this.updateState({[e]:t}),this.emit("stateChange",{controllerKey:e,newState:t,oldState:a,patches:s})}function u(e,t){return t.some(t=>{if(0===t.path.length)return!0;const s=t.path[0];return!e[s]||e[s].persist})}s.default=l}}},{package:"$root$",file:"app/scripts/lib/ComposableObservableStore.js"}],[2237,{"./constants.cjs":2238,"./utils.cjs":2241,"@metamask/base-controller":1264,"@metamask/controller-utils":1343,"@metamask/keyring-api":2036,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.NetworkEnablementController=void 0;const l=e("@metamask/base-controller"),d=e("@metamask/controller-utils"),u=e("@metamask/keyring-api"),m=e("@metamask/utils"),h=e("./constants.cjs"),p=e("./utils.cjs"),f={enabledNetworkMap:{includeInStateLogs:!0,persist:!0,anonymous:!0,usedInUi:!0}};class g extends l.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:f,name:"NetworkEnablementController",state:{enabledNetworkMap:{[m.KnownCaipNamespace.Eip155]:{[d.ChainId[d.BuiltInNetworkName.Mainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.LineaMainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.BaseMainnet]]:!0},[m.KnownCaipNamespace.Solana]:{[u.SolScope.Mainnet]:!0,[u.SolScope.Testnet]:!1,[u.SolScope.Devnet]:!1},[m.KnownCaipNamespace.Bip122]:{[u.BtcScope.Mainnet]:!0,[u.BtcScope.Testnet]:!1,[u.BtcScope.Signet]:!1},[m.KnownCaipNamespace.Tron]:{[u.TrxScope.Mainnet]:!0,[u.TrxScope.Nile]:!1,[u.TrxScope.Shasta]:!1}},...t}}),a.add(this),e.subscribe("NetworkController:networkAdded",({chainId:e})=>{c(this,a,"m",o).call(this,e)}),e.subscribe("NetworkController:networkRemoved",({chainId:e})=>{c(this,a,"m",i).call(this,e)})}enableNetwork(e){const{namespace:t,storageKey:s}=(0,p.deriveKeys)(e);this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})}),e.enabledNetworkMap[t]&&(e.enabledNetworkMap[t][s]=!0)})}enableNetworkInNamespace(e,t){const{namespace:s,storageKey:r}=(0,p.deriveKeys)(e);if(s!==t)throw new Error(`Chain ID ${e} belongs to namespace ${s}, but namespace ${t} was specified`);this.update(e=>{c(this,a,"m",n).call(this,e,t),e.enabledNetworkMap[t]&&Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1}),e.enabledNetworkMap[t][r]=!0})}enableAllPopularNetworks(){this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})});const t=this.messagingSystem.call("NetworkController:getState"),s=this.messagingSystem.call("MultichainNetworkController:getState");h.POPULAR_NETWORKS.forEach(s=>{const{namespace:r,storageKey:i}=(0,p.deriveKeys)(s);t.networkConfigurationsByChainId[s]&&(c(this,a,"m",n).call(this,e,r),e.enabledNetworkMap[r][i]=!0)});const r=(0,p.deriveKeys)(u.SolScope.Mainnet);s.multichainNetworkConfigurationsByChainId[u.SolScope.Mainnet]&&(c(this,a,"m",n).call(this,e,r.namespace),e.enabledNetworkMap[r.namespace][r.storageKey]=!0);const i=(0,p.deriveKeys)(u.BtcScope.Mainnet);s.multichainNetworkConfigurationsByChainId[u.BtcScope.Mainnet]&&(c(this,a,"m",n).call(this,e,i.namespace),e.enabledNetworkMap[i.namespace][i.storageKey]=!0);const o=(0,p.deriveKeys)(u.TrxScope.Mainnet);s.multichainNetworkConfigurationsByChainId[u.TrxScope.Mainnet]&&(c(this,a,"m",n).call(this,e,o.namespace),e.enabledNetworkMap[o.namespace][o.storageKey]=!0)})}init(){this.update(e=>{const t=this.messagingSystem.call("NetworkController:getState"),s=this.messagingSystem.call("MultichainNetworkController:getState");Object.keys(t.networkConfigurationsByChainId).forEach(t=>{const{namespace:s,storageKey:r}=(0,p.deriveKeys)(t);c(this,a,"m",n).call(this,e,s),e.enabledNetworkMap[s][r]===undefined&&(e.enabledNetworkMap[s][r]=!1)}),Object.keys(s.multichainNetworkConfigurationsByChainId).forEach(t=>{const{namespace:s,storageKey:r}=(0,p.deriveKeys)(t);c(this,a,"m",n).call(this,e,s),e.enabledNetworkMap[s][r]===undefined&&(e.enabledNetworkMap[s][r]=!1)})})}disableNetwork(e){const t=(0,p.deriveKeys)(e),{namespace:s,storageKey:a}=t;this.update(e=>{e.enabledNetworkMap[s][a]=!1})}isNetworkEnabled(e){const t=(0,p.deriveKeys)(e),{namespace:s,storageKey:a}=t;return this.state.enabledNetworkMap[s]?.[a]??!1}}s.NetworkEnablementController=g,a=new WeakSet,n=function(e,t){e.enabledNetworkMap[t]||(e.enabledNetworkMap[t]={})},r=function(){const e=this.messagingSystem.call("NetworkController:getState");return h.POPULAR_NETWORKS.reduce((t,s)=>{if(!e.networkConfigurationsByChainId[s])return t;const{namespace:a,storageKey:n}=(0,p.deriveKeys)(s),r=this.state.enabledNetworkMap[a]?.[n];return r?t+1:t},0)>1},i=function(e){const t=(0,p.deriveKeys)(e),{namespace:s,storageKey:a}=t;this.update(e=>{(0,p.isOnlyNetworkEnabledInNamespace)(this.state,t)&&(e.enabledNetworkMap[s][d.ChainId[d.BuiltInNetworkName.Mainnet]]=!0),s in e.enabledNetworkMap&&delete e.enabledNetworkMap[s][a]})},o=function(e){const{namespace:t,storageKey:s,reference:i}=(0,p.deriveKeys)(e);this.update(e=>{c(this,a,"m",n).call(this,e,t);const o=c(this,a,"m",r).call(this),l=(0,p.isPopularNetwork)(i);o&&l||Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})}),e.enabledNetworkMap[t][s]=!0})}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs"}],[2238,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.POPULAR_NETWORKS=void 0,s.POPULAR_NETWORKS=["0x1","0xe708","0x2105","0xa4b1","0xa86a","0x38","0xa","0x89","0x531","0x144","0x2a15c308d","0x3e7"]}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/constants.cjs"}],[2239,{"./NetworkEnablementController.cjs":2237,"./selectors.cjs":2240},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.selectEnabledSolanaNetworks=s.selectEnabledEvmNetworks=s.selectEnabledNetworksCount=s.selectAllEnabledNetworks=s.createSelectorForEnabledNetworksForNamespace=s.selectIsNetworkEnabled=s.selectEnabledNetworkMap=s.NetworkEnablementController=void 0;var a=e("./NetworkEnablementController.cjs");Object.defineProperty(s,"NetworkEnablementController",{enumerable:!0,get:function(){return a.NetworkEnablementController}});var n=e("./selectors.cjs");Object.defineProperty(s,"selectEnabledNetworkMap",{enumerable:!0,get:function(){return n.selectEnabledNetworkMap}}),Object.defineProperty(s,"selectIsNetworkEnabled",{enumerable:!0,get:function(){return n.selectIsNetworkEnabled}}),Object.defineProperty(s,"createSelectorForEnabledNetworksForNamespace",{enumerable:!0,get:function(){return n.createSelectorForEnabledNetworksForNamespace}}),Object.defineProperty(s,"selectAllEnabledNetworks",{enumerable:!0,get:function(){return n.selectAllEnabledNetworks}}),Object.defineProperty(s,"selectEnabledNetworksCount",{enumerable:!0,get:function(){return n.selectEnabledNetworksCount}}),Object.defineProperty(s,"selectEnabledEvmNetworks",{enumerable:!0,get:function(){return n.selectEnabledEvmNetworks}}),Object.defineProperty(s,"selectEnabledSolanaNetworks",{enumerable:!0,get:function(){return n.selectEnabledSolanaNetworks}})}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/index.cjs"}],[224,{"webextension-polyfill":5424},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.CronjobControllerStorageManager=s.CronjobControllerStorageKey=void 0;var a,n=(a=e("webextension-polyfill"))&&a.__esModule?a:{default:a};function r(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}const l=s.CronjobControllerStorageKey="temp-cronjob-storage";var d=new WeakMap,u=new WeakMap;s.CronjobControllerStorageManager=class{constructor(){r(this,d,null),r(this,u,!1)}async init(){o(d,this,(await n.default.storage.local.get(l))[l]),o(u,this,!0)}getInitialState(){if(!i(u,this))throw new Error("CronjobControllerStorageManager not yet initialized");return i(d,this)}set(e){if(!i(u,this))throw new Error("CronjobControllerStorageManager not yet initialized");n.default.storage.local.set({[l]:e}).catch(console.error)}}}}},{package:"$root$",file:"app/scripts/lib/CronjobControllerStorageManager.ts"}],[2240,{"./utils.cjs":2241,"@metamask/utils":2835,reselect:5014},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.selectEnabledSolanaNetworks=s.selectEnabledEvmNetworks=s.selectEnabledNetworksCount=s.selectAllEnabledNetworks=s.createSelectorForEnabledNetworksForNamespace=s.selectIsNetworkEnabled=s.selectEnabledNetworkMap=void 0;const a=e("@metamask/utils"),n=e("reselect"),r=e("./utils.cjs");s.selectEnabledNetworkMap=e=>e.enabledNetworkMap;s.selectIsNetworkEnabled=e=>(0,n.createSelector)(s.selectEnabledNetworkMap,t=>{const{namespace:s,storageKey:a}=(0,r.deriveKeys)(e);return s in t&&a in t[s]&&t[s][a]});s.createSelectorForEnabledNetworksForNamespace=e=>(0,n.createSelector)(s.selectEnabledNetworkMap,t=>Object.entries(t[e]??{}).filter(([,e])=>e).map(([e])=>e)),s.selectAllEnabledNetworks=(0,n.createSelector)(s.selectEnabledNetworkMap,e=>Object.keys(e).reduce((t,s)=>(t[s]=Object.entries(e[s]).filter(([,e])=>e).map(([e])=>e),t),{})),s.selectEnabledNetworksCount=(0,n.createSelector)(s.selectAllEnabledNetworks,e=>Object.values(e).flat().length),s.selectEnabledEvmNetworks=(0,n.createSelector)((0,s.createSelectorForEnabledNetworksForNamespace)(a.KnownCaipNamespace.Eip155),e=>e),s.selectEnabledSolanaNetworks=(0,n.createSelector)((0,s.createSelectorForEnabledNetworksForNamespace)(a.KnownCaipNamespace.Solana),e=>e)}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"}],[2241,{"./constants.cjs":2238,"@metamask/controller-utils":1343,"@metamask/multichain-network-controller":2137,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isPopularNetwork=s.isOnlyNetworkEnabledInNamespace=s.deriveKeys=void 0;const a=e("@metamask/controller-utils"),n=e("@metamask/multichain-network-controller"),r=e("@metamask/utils"),i=e("./constants.cjs");s.deriveKeys=function(e){const t=(0,r.isCaipChainId)(e)?e:(0,n.toEvmCaipChainId)(e),{namespace:s,reference:i}=(0,r.parseCaipChainId)(t);let o;return o=s===r.KnownCaipNamespace.Eip155?(0,r.isHexString)(e)?e:(0,a.toHex)(i):t,{namespace:s,storageKey:o,caipChainId:t,reference:i}},s.isOnlyNetworkEnabledInNamespace=function(e,t){const{namespace:s,storageKey:a}=t;if(!e.enabledNetworkMap[s])return!1;const n=e.enabledNetworkMap[s],r=Object.entries(n).filter(([e,t])=>t);if(1===r.length){const[e]=r[0];return e===a}return!1},s.isPopularNetwork=function(e){try{return i.POPULAR_NETWORKS.includes((0,a.toHex)(e))}catch{return!1}}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/utils.cjs"}],[225,{"./state-utils":304,"@metamask/utils":2835,lodash:4560,uuid:5392},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.PatchStore=void 0;var a=e("@metamask/utils"),n=e("uuid"),r=e("lodash"),i=e("./state-utils");function o(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}const c=(0,a.createProjectLogger)("patch-store");s.PatchStore=class{constructor(e){o(this,"id",void 0),o(this,"observableStore",void 0),o(this,"pendingPatches",[]),o(this,"listener",void 0),this.id=(0,n.v4)(),this.observableStore=e,this.listener=this._onStateChange.bind(this),this.observableStore.on("stateChange",this.listener),c("Created",this.id)}flushPendingPatches(){const e=this.pendingPatches;this.pendingPatches=[];for(const t of e)c("Flushed",t.path.join("."),this.id,t);return e}destroy(){this.observableStore.removeListener("stateChange",this.listener),c("Destroyed",this.id)}_onStateChange({newState:e,oldState:t,patches:s}){let a=[];if(s){const e=this._normalizeEventPatches(s,t);a=(0,i.sanitizePatches)(e??[])}else{const s=(0,i.sanitizeUIState)(e);a=this._generatePatches(t,s)}const n=Boolean(e.vault);if(n&&a.push({op:"replace",path:["isInitialized"],value:n}),a.length)for(const e of a){const t=e.path.join(".");this.pendingPatches.push(e),c("Added",t,this.id,e)}}_generatePatches(e,t){return Object.keys(t).map(s=>{const a=e[s],n=t[s];return a===n?null:{op:"replace",path:[s],value:n}}).filter(Boolean)}_normalizeEventPatches(e,t){return null==e?void 0:e.flatMap(e=>{if(e.path.length>0)return[e];return(0,r.uniq)([...Object.keys(t),...Object.keys(e.value)]).map(t=>({op:t in e.value?"replace":"remove",path:[t],...t in e.value?{value:e.value[t]}:{}}))})}}}}},{package:"$root$",file:"app/scripts/lib/PatchStore.ts"}],[226,{"@metamask/name-controller":2198,"@metamask/snaps-rpc-methods":2542,"@metamask/snaps-utils":2712,loglevel:4568},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.SnapsNameProvider=void 0;var a,n=e("@metamask/name-controller"),r=e("@metamask/snaps-utils"),i=(a=e("loglevel"))&&a.__esModule?a:{default:a},o=e("@metamask/snaps-rpc-methods");function c(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function l(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function d(e,t){return e.get(u(e,t))}function u(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var m=new WeakMap,h=new WeakSet;function p(e){const t=d(m,this).call("PermissionController:getState").subjects;return d(m,this).call("SnapController:getAll").filter(({id:s})=>{var a;const n=null===(a=t[s])||void 0===a?void 0:a.permissions["endowment:name-lookup"];if(!n)return!1;const r=(0,o.getChainIdsCaveat)(n);return!(e&&r&&!r.includes(e))})}async function f(e,t,s){const a=e,n={chainId:t,address:s};let o,c;try{const t=await d(m,this).call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:r.HandlerType.OnNameLookup,request:{jsonrpc:"2.0",method:" ",params:n}}),s=null==t?void 0:t.resolvedDomains;o=s?[...new Set(s.map(e=>e.resolvedDomain))]:[]}catch(t){i.default.error("Snap name provider request failed",{snapId:e,request:n,error:t}),c=t}return{sourceId:a,result:{proposedNames:o,error:c}}}s.SnapsNameProvider=class{constructor({messenger:e}){var t,s,a;!function(e,t){c(e,t),t.add(e)}(this,h),l(this,"name","SnapsNameProvider"),l(this,"state",null),function(e,t,s){c(e,t),t.set(e,s)}(this,m,void 0),s=this,a=e,(t=m).set(u(t,s),a)}getMetadata(){const e=u(h,this,p).call(this);return{sourceIds:{[n.NameType.ETHEREUM_ADDRESS]:e.map(e=>e.id)},sourceLabels:e.reduce((e,t)=>{const s=d(m,this).call("SnapController:get",t.id),a=null==s?void 0:s.manifest.proposedName;return{...e,[t.id]:a||t.id}},{})}}async getProposedNames(e){const{variation:t,value:s}=e,a=`eip155:${parseInt(t,16)}`,n=u(h,this,p).call(this,a);return{results:(await Promise.all(n.map(e=>u(h,this,f).call(this,e.id,a,s)))).reduce((e,t)=>{const{sourceId:s,result:a}=t;return{...e,[s]:a}},{})}}}}}},{package:"$root$",file:"app/scripts/lib/SnapsNameProvider.ts"}],[227,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.WeakRefObjectMap=void 0;class n{constructor(){a(this,"map",void 0),this.map=new Map}set(e,t){const s={};for(const e in t){if(!Object.prototype.hasOwnProperty.call(t,e))continue;const a=t[e];if("object"!=typeof a||null===a)throw new Error(`Property ${String(e)} is not an object and cannot be weakly referenced.`);s[e]=new WeakRef(a)}return this.map.set(e,s),this}get(e){const t=this.map.get(e);if(!t)return undefined;const s={};for(const a in t){if(!Object.prototype.hasOwnProperty.call(t,a))continue;const n=t[a].deref();if(n===undefined)return this.map.delete(e),undefined;s[a]=n}return s}has(e){return this.get(e)!==undefined}delete(e){return this.get(e)!==undefined&&this.map.delete(e)}clear(){this.map.clear()}get size(){return this.map.size}entries(){const e=[];return this.map.forEach((t,s)=>{const a=this.get(s);a!==undefined&&e.push([s,a])}),e.values()}keys(){return this.map.keys()}values(){const e=[];return this.map.forEach((t,s)=>{const a=this.get(s);a!==undefined&&e.push(a)}),e.values()}[Symbol.iterator](){return this.entries()}get[Symbol.toStringTag](){return"WeakRefObjectMap"}forEach(e,t){this.map.forEach((s,a)=>{const n=this.get(a);n!==undefined&&(t?e.call(t,n,a,this):e(n,a,this))})}}s.WeakRefObjectMap=n}}},{package:"$root$",file:"app/scripts/lib/WeakRefObjectMap.ts"}],[228,{"../../../../shared/constants/app":5436,"@metamask/controller-utils":1343,"@metamask/rpc-errors":2423,"@metamask/snaps-rpc-methods":2542,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.rejectAllApprovals=function({approvalController:e,deleteInterface:t}){const s=e.state.pendingApprovals,a=Object.values(s);for(const s of a)l({approvalController:e,approvalRequest:s,deleteInterface:t})},s.rejectOriginApprovals=function({approvalController:e,deleteInterface:t,origin:s}){const a=e.state.pendingApprovals,n=Object.values(a).filter(e=>e.origin===s);for(const s of n)l({approvalController:e,approvalRequest:s,deleteInterface:t})};var a=e("@metamask/controller-utils"),n=e("@metamask/snaps-rpc-methods"),r=e("@metamask/rpc-errors"),i=e("@metamask/utils"),o=e("../../../../shared/constants/app");const c=(0,i.createProjectLogger)("approval-utils");function l({approvalController:e,approvalRequest:t,deleteInterface:s}){var i;const{id:l,type:d,origin:u}=t,m=null===(i=t.requestData)||void 0===i?void 0:i.id;switch(d){case a.ApprovalType.SnapDialogAlert:case a.ApprovalType.SnapDialogPrompt:case n.DIALOG_APPROVAL_TYPES.default:c("Rejecting snap dialog",{id:l,interfaceId:m,origin:u,type:d}),e.accept(l,null),null==s||s(m);break;case a.ApprovalType.SnapDialogConfirmation:c("Rejecting snap confirmation",{id:l,interfaceId:m,origin:u,type:d}),e.accept(l,!1),null==s||s(m);break;case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval:case o.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect:c("Rejecting snap account confirmation",{id:l,origin:u,type:d}),e.accept(l,!1);break;default:c("Rejecting pending approval",{id:l,origin:u,type:d}),e.reject(l,r.providerErrors.userRejectedRequest({data:{cause:"rejectAllApprovals"}}))}}}}},{package:"$root$",file:"app/scripts/lib/approval/utils.ts"}],[2280,{"./push-utils.cjs":2281},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=void 0;var a=e("./push-utils.cjs");Object.defineProperty(s,"createRegToken",{enumerable:!0,get:function(){return a.createRegToken}}),Object.defineProperty(s,"deleteRegToken",{enumerable:!0,get:function(){return a.deleteRegToken}}),Object.defineProperty(s,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return a.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],[2281,{"../../NotificationServicesController/index.cjs":2253,"../../shared/to-raw-notification.cjs":2285,"firebase/app":4148,"firebase/messaging":4149,"firebase/messaging/sw":4150,loglevel:4568},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=s.supportedCache=void 0;const n=e("firebase/app"),r=e("firebase/messaging"),i=e("firebase/messaging/sw"),o=a(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),l=e("../../shared/to-raw-notification.cjs");s.supportedCache=null;const d=async e=>{if(!await(async()=>(s.supportedCache??(s.supportedCache=await(0,i.isSupported)()),s.supportedCache))())return null;const t=await(async e=>{try{return(0,n.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,n.initializeApp)(t)}})(e);return(0,i.getMessaging)(t)};s.createRegToken=async function(e){try{const t=await d(e);if(!t)return null;return await(0,r.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},s.deleteRegToken=async function(e){try{const t=await d(e);return!t||(await(0,r.deleteToken)(t),!0)}catch{return!1}},s.createSubscribeToPushNotifications=function(e){return async function(t){const s=await async function(e,t){const s=await d(e);if(!s)return null;const a=(0,i.onBackgroundMessage)(s,async e=>{try{const s=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!s)return;const a=(0,l.toRawOnChainNotification)(s),n=c.Processors.processNotification(a);await t(n)}catch(t){throw o.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}});return()=>a()}(t,async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)}),a=function(e){const t=t=>{const s=t?.notification?.data;e(t,s)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}((t,s)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",s),e.onClickHandler(t,s)});return()=>{s?.(),a()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],[229,{"../../../shared/modules/string-utils":5575},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var a=e("../../../shared/modules/string-utils");s.default=class{constructor(e={}){const{preferencesController:t,addressBookController:s,accountsController:a,networkController:n,trackMetaMetricsEvent:r}=e;this.preferencesController=t,this.accountsController=a,this.addressBookController=s,this.networkController=n,this._trackMetaMetricsEvent=r}async restoreUserData(e){const t=this.preferencesController.state,{preferences:s,addressBook:a,network:n,internalAccounts:r}=JSON.parse(e);s&&(s.identities=t.identities,s.lostIdentities=t.lostIdentities,s.selectedAddress=t.selectedAddress,this.preferencesController.update(s)),a&&this.addressBookController.update(a,!0),n&&this.networkController.loadBackup(n),r&&this.accountsController.loadBackup(r),(s||a||n||r)&&this._trackMetaMetricsEvent({event:"User Data Imported",category:"Backup"})}async backupUserData(){const e={preferences:{...this.preferencesController.state},internalAccounts:{internalAccounts:this.accountsController.state.internalAccounts},addressBook:{...this.addressBookController.state},network:{networkConfigurationsByChainId:this.networkController.state.networkConfigurationsByChainId}};delete e.preferences.identities,delete e.preferences.lostIdentities,delete e.preferences.selectedAddress;const t=JSON.stringify(e),s=new Date,n=e=>(0,a.prependZero)(e,2);return{fileName:`MetaMaskUserData.${s.getFullYear()}_${n(s.getMonth()+1)}_${n(s.getDay())}_${n(s.getHours())}_${n(s.getMinutes())}_${n(s.getDay())}.json`,data:t}}}}}},{package:"$root$",file:"app/scripts/lib/backup.js"}],[2291,{"./ObservableStore":2293},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ComposedStore=void 0;const a=e("./ObservableStore");class n extends a.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach(e=>{const t=this._children[e];this._addChild(e,t)})}_addChild(e,t){const s=t=>{const s=this.getState();s[e]=t,this.putState(s)};t.subscribe(s),s(t.getState())}}s.ComposedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],[2292,{"./ObservableStore":2293},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MergedStore=void 0;const a=e("./ObservableStore");class n extends a.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach(e=>this._addChild(e)),this._updateWholeState()}_addChild(e){e.subscribe(()=>this._updateWholeState())}_updateWholeState(){const e=this._children.map(e=>e.getState()),t=Object.assign({},...e);this.putState(t)}}s.MergedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],[2293,{"@metamask/safe-event-emitter":2425},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.ObservableStore=void 0;const n=a(e("@metamask/safe-event-emitter"));class r extends n.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}s.ObservableStore=r}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],[2294,{"readable-stream":5003},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeAsStream=void 0;const a=e("readable-stream");class n extends a.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const s=super.pipe(e,t);return e.write(this.obsStore.getState()),s}_write(e,t,s){this.obsStore.putState(e),s()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}s.storeAsStream=function(e){return new n(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],[2295,{"./ComposedStore":2291,"./MergedStore":2292,"./ObservableStore":2293,"./asStream":2294,"./transform":2296},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__createBinding||(Object.create?function(e,t,s,a){a===undefined&&(a=s),Object.defineProperty(e,a,{enumerable:!0,get:function(){return t[s]}})}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./asStream"),s),n(e("./ComposedStore"),s),n(e("./MergedStore"),s),n(e("./ObservableStore"),s),n(e("./transform"),s)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],[2296,{"readable-stream":5003},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeTransformStream=void 0;const a=e("readable-stream");s.storeTransformStream=function(e){return new a.Transform({objectMode:!0,transform:(t,s,a)=>{try{const s=e(t);return a(undefined,s),undefined}catch(e){return a(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],[23,{"../../controllers/network-order":202},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.NetworkOrderControllerInit=void 0;var a=e("../../controllers/network-order");s.NetworkOrderControllerInit=({controllerMessenger:e,persistedState:t})=>({controller:new a.NetworkOrderController({messenger:e,state:{orderedNetworkList:[],...t.NetworkOrderController}})})}}},{package:"$root$",file:"app/scripts/controller-init/assets/network-order-controller-init.ts"}],[230,{"@metamask/utils":2835,lodash:4560},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fetchAccountBalancesInBatches=async function(e){const{addresses:t,supportedChainIds:s,accountApiBaseUrl:n,batchSize:i=50,logger:o}=e,c=s.join(",");return r({items:t,batchSize:i,processBatch:async e=>{const t=s[0],r=e.map(e=>(0,a.toCaipAccountId)("eip155",t,e)).join(","),i=`${n}/v4/multiaccount/balances?networks=${c}&accountAddresses=${r}`,l=await fetch(i,{method:"GET",headers:{Accept:"application/json"}});if(!l.ok)return null==o||o.warn(`Account API batch request failed with status ${l.status}: ${l.statusText}`),null;return await l.json()},mergeResults:e=>{const t={balances:{}};return e.forEach(e=>{Object.assign(t.balances,e.balances)}),t},logger:o})},s.processInBatches=r;var a=e("@metamask/utils"),n=e("lodash");async function r(e){const{items:t,batchSize:s,processBatch:a,mergeResults:r,logger:i}=e;if(0===t.length)return null;const o=(0,n.chunk)(t,s);null==i||i.debug(`Processing ${t.length} items in ${o.length} batches of max ${s} each`);try{const e=await Promise.all(o.map(async(e,t)=>{try{const s=await a(e);return null===s&&(null==i||i.warn(`Batch ${t+1} failed and returned null`)),s}catch(e){return null==i||i.warn(`Batch ${t+1} failed with error: ${String(e)}`),null}})),t=[];for(const s of e)null!==s&&t.push(s);if(t.length<=0)return null==i||i.warn("All batches failed"),null;if(null==i||i.debug(`Successfully processed ${t.length}/${o.length} batches`),r)return r(t);return t[0]||null}catch(e){return null==i||i.warn(`Batch processing failed: ${String(e)}`),null}}}}},{package:"$root$",file:"app/scripts/lib/batch-utils.ts"}],[2309,{"./enums.cjs":2310,"@metamask/base-controller":1264,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l,d,u,m=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PermissionLogController=void 0;const p=e("@metamask/base-controller"),f=e("@metamask/utils"),g=e("./enums.cjs"),b={permissionHistory:{},permissionActivityLog:[]};class y extends p.BaseController{constructor({messenger:e,restrictedMethods:t,state:s}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{persist:!0,anonymous:!1},permissionActivityLog:{persist:!1,anonymous:!1}},state:{...b,...s}}),a.add(this),n.set(this,void 0),m(this,n,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const s={eth_accounts:{accounts:h(this,a,"m",r).call(this,t,Date.now())}};h(this,a,"m",l).call(this,e,s)}createMiddleware(){return(e,t,s)=>{const{origin:r,method:l}=e,u=l.startsWith(g.WALLET_PREFIX),m="eth_requestAccounts"===l;if(!g.LOG_IGNORE_METHODS.includes(l)&&(u||h(this,n,"f").has(l))||m){const n=h(this,a,"m",i).call(this,e,u),l=h(this,a,"m",d).call(this,e);return void s(e=>{const s=Date.now();h(this,a,"m",o).call(this,n,t,s),l&&!t.error&&t.result&&r&&h(this,a,"m",c).call(this,l,r,t.result,s,m),e()})}s()}}}s.PermissionLogController=y,n=new WeakMap,a=new WeakSet,r=function(e,t){return e.reduce((e,s)=>({...e,[s]:t}),{})},i=function(e,t){const s={id:e.id,method:e.method,methodType:t?g.LOG_METHOD_TYPES.internal:g.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update(e=>{const t=[...e.permissionActivityLog,s];e.permissionActivityLog=t.length>g.LOG_LIMIT?t.slice(1):t}),s},o=function(e,t,s){e&&t&&this.update(a=>{a.permissionActivityLog=a.permissionActivityLog.map(a=>a.id===e.id?{...a,success:(0,f.hasProperty)(t,"result"),responseTime:s}:a)})},c=function(e,t,s,n,i){let o;if(i){const e=s;o={eth_accounts:{accounts:h(this,a,"m",r).call(this,e,n),lastApproved:n}}}else{o=s.reduce((t,s)=>{const i=s.parentCapability;if(!e.includes(i))return t;if("eth_accounts"===i){const e=h(this,a,"m",u).call(this,s);return{...t,[i]:{lastApproved:n,accounts:h(this,a,"m",r).call(this,e,n)}}}return{...t,[i]:{lastApproved:n}}},{})}Object.keys(o).length>0&&h(this,a,"m",l).call(this,t,o)},l=function(e,t){const{permissionHistory:s}=this.state,a=s[e]??{},n={...a,...t},r=a.eth_accounts,i=t.eth_accounts;if(r&&i){const e=i.lastApproved??r.lastApproved;n.eth_accounts={lastApproved:e,accounts:{...r.accounts,...i.accounts}}}this.update(t=>{t.permissionHistory={...s,[e]:n}})},d=function(e){const{method:t,params:s}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${g.WALLET_PREFIX}requestPermissions`&&s&&Array.isArray(s)&&s[0]&&"object"==typeof s[0]&&!Array.isArray(s[0])?Object.keys(s[0]):null},u=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const s of e.caveats)if(s.type===g.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(s.value))for(const e of s.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],[231,{"../../../shared/constants/time":5472,loglevel:4568,"readable-stream":5003},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.THREE_MINUTES=void 0,s.default=function(){const e=c();return new n.Transform({transform(t,s,a){const n=t.id===undefined,i=e.add(t.id);n||i?a(null,t):(r.default.debug(`RPC request with id "${t.id}" already seen.`),a())},objectMode:!0})};var a,n=e("readable-stream"),r=(a=e("loglevel"))&&a.__esModule?a:{default:a},i=e("../../../shared/constants/time");const o=s.THREE_MINUTES=3*i.MINUTE,c=()=>{const e=new Map;return setInterval(()=>{const t=Date.now()-o;for(const[s,a]of e.entries()){if(!(a<=t))break;e.delete(s)}},o),{add:t=>!e.has(t)&&(e.set(t,Date.now()),!0)}}}}},{package:"$root$",file:"app/scripts/lib/createDupeReqFilterStream.ts"}],[2310,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a;Object.defineProperty(s,"__esModule",{value:!0}),s.LOG_LIMIT=s.LOG_METHOD_TYPES=s.LOG_IGNORE_METHODS=s.CAVEAT_TYPES=s.WALLET_PREFIX=void 0,s.WALLET_PREFIX="wallet_",s.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),s.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(a||(s.LOG_METHOD_TYPES=a={})),s.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],[2311,{"./PermissionLogController.cjs":2309},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__createBinding||(Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./PermissionLogController.cjs"),s)}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],[232,{"../../../shared/constants/permissions":5459,"../controllers/permissions":207,"@metamask/keyring-api":2036},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({messenger:e}){return function(t,s,n,r){const o=e.call("AccountsController:getSelectedAccount");if((0,a.isEvmAccountType)(o.type))return n();if(i.includes(t.method))return r(new Error(`Non-EVM account cannot request this method: ${t.method}`));if("wallet_requestPermissions"===t.method&&null!=t&&t.params&&Array.isArray(t.params)&&t.params.length>0&&t.params[0]){const e=Object.keys(t.params[0]);if(i.some(t=>e.includes(t)))return r(new Error(`Non-EVM account cannot request this method: ${e.toString()}`))}return n()}};var a=e("@metamask/keyring-api"),n=e("../../../shared/constants/permissions"),r=e("../controllers/permissions");const i=[...Object.values(n.RestrictedEthMethods),...r.unrestrictedEthSigningMethods]}}},{package:"$root$",file:"app/scripts/lib/createEvmMethodsToNonEvmAccountReqFilterMiddleware.ts"}],[2323,{"readable-stream":5003},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BasePostMessageStream=void 0;const a=e("readable-stream"),n=()=>undefined,r="SYN",i="ACK";class o extends a.Duplex{constructor(e){super(Object.assign({objectMode:!0},e)),this._init=!1,this._haveSyn=!1,this._log=()=>null}_handshake(){this._write(r,null,n),this.cork()}_onData(e){if(this._init)try{this.push(e),this._log(e,!1)}catch(e){this.emit("error",e)}else e===r?(this._haveSyn=!0,this._write(i,null,n)):e===i&&(this._init=!0,this._haveSyn||this._write(i,null,n),this.uncork())}_read(){return undefined}_write(e,t,s){e!==i&&e!==r&&this._log(e,!0),this._postMessage(e),s()}_setLogger(e){this._log=e}}s.BasePostMessageStream=o}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs"}],[2324,{"./BasePostMessageStream.cjs":2323,"./runtime/BrowserRuntimePostMessageStream.cjs":2325,"./utils.cjs":2326,"./web-worker/WebWorkerParentPostMessageStream.cjs":2327,"./web-worker/WebWorkerPostMessageStream.cjs":2328,"./window/WindowPostMessageStream.cjs":2329},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__createBinding||(Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.isValidStreamMessage=void 0,n(e("./window/WindowPostMessageStream.cjs"),s),n(e("./web-worker/WebWorkerPostMessageStream.cjs"),s),n(e("./web-worker/WebWorkerParentPostMessageStream.cjs"),s),n(e("./runtime/BrowserRuntimePostMessageStream.cjs"),s),n(e("./BasePostMessageStream.cjs"),s);var r=e("./utils.cjs");Object.defineProperty(s,"isValidStreamMessage",{enumerable:!0,get:function(){return r.isValidStreamMessage}})}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/index.cjs"}],[2325,{"../BasePostMessageStream.cjs":2323,"../utils.cjs":2326},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},i=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)},o=this&&this.__rest||function(e,t){var s={};for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&t.indexOf(a)<0&&(s[a]=e[a]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(a=Object.getOwnPropertySymbols(e);n<a.length;n++)t.indexOf(a[n])<0&&Object.prototype.propertyIsEnumerable.call(e,a[n])&&(s[a[n]]=e[a[n]])}return s};Object.defineProperty(s,"__esModule",{value:!0}),s.BrowserRuntimePostMessageStream=void 0;const c=e("../BasePostMessageStream.cjs"),l=e("../utils.cjs");class d extends c.BasePostMessageStream{constructor(e){var{name:t,target:s}=e;super(o(e,["name","target"])),a.set(this,void 0),n.set(this,void 0),r(this,a,t,"f"),r(this,n,s,"f"),this._onMessage=this._onMessage.bind(this),this._getRuntime().onMessage.addListener(this._onMessage),this._handshake()}_postMessage(e){this._getRuntime().sendMessage({target:i(this,n,"f"),data:e})}_onMessage(e){(0,l.isValidStreamMessage)(e)&&e.target===i(this,a,"f")&&this._onData(e.data)}_getRuntime(){var e,t;if("chrome"in globalThis&&"function"==typeof(null===(e=null===chrome||void 0===chrome?void 0:chrome.runtime)||void 0===e?void 0:e.sendMessage))return chrome.runtime;if("browser"in globalThis&&"function"==typeof(null===(t=null===browser||void 0===browser?void 0:browser.runtime)||void 0===t?void 0:t.sendMessage))return browser.runtime;throw new Error("browser.runtime.sendMessage is not a function. This class should only be instantiated in a web extension.")}_destroy(){this._getRuntime().onMessage.removeListener(this._onMessage)}}s.BrowserRuntimePostMessageStream=d,a=new WeakMap,n=new WeakMap}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/runtime/BrowserRuntimePostMessageStream.cjs"}],[2326,{"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isValidStreamMessage=s.DEDICATED_WORKER_NAME=void 0;const a=e("@metamask/utils");s.DEDICATED_WORKER_NAME="dedicatedWorker",s.isValidStreamMessage=function(e){return(0,a.isObject)(e)&&Boolean(e.data)&&("number"==typeof e.data||"object"==typeof e.data||"string"==typeof e.data)}}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/utils.cjs"}],[2327,{"../BasePostMessageStream.cjs":2323,"../utils.cjs":2326},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__rest||function(e,t){var s={};for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&t.indexOf(a)<0&&(s[a]=e[a]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(a=Object.getOwnPropertySymbols(e);n<a.length;n++)t.indexOf(a[n])<0&&Object.prototype.propertyIsEnumerable.call(e,a[n])&&(s[a[n]]=e[a[n]])}return s};Object.defineProperty(s,"__esModule",{value:!0}),s.WebWorkerParentPostMessageStream=void 0;const n=e("../BasePostMessageStream.cjs"),r=e("../utils.cjs");class i extends n.BasePostMessageStream{constructor(e){var{worker:t}=e;super(a(e,["worker"])),this._target=r.DEDICATED_WORKER_NAME,this._worker=t,this._worker.onmessage=this._onMessage.bind(this),this._handshake()}_postMessage(e){this._worker.postMessage({target:this._target,data:e})}_onMessage(e){const t=e.data;(0,r.isValidStreamMessage)(t)&&this._onData(t.data)}_destroy(){this._worker.onmessage=null,this._worker=null}}s.WebWorkerParentPostMessageStream=i}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerParentPostMessageStream.cjs"}],[2328,{"../BasePostMessageStream.cjs":2323,"../utils.cjs":2326},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.WebWorkerPostMessageStream=void 0;const a=e("../BasePostMessageStream.cjs"),n=e("../utils.cjs");class r extends a.BasePostMessageStream{constructor(e={}){if("undefined"==typeof self||"undefined"==typeof WorkerGlobalScope)throw new Error("WorkerGlobalScope not found. This class should only be instantiated in a WebWorker.");super(e),this._name=n.DEDICATED_WORKER_NAME,self.addEventListener("message",this._onMessage.bind(this)),this._handshake()}_postMessage(e){self.postMessage({data:e})}_onMessage(e){const t=e.data;(0,n.isValidStreamMessage)(t)&&t.target===this._name&&this._onData(t.data)}_destroy(){return undefined}}s.WebWorkerPostMessageStream=r}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerPostMessageStream.cjs"}],[2329,{"../BasePostMessageStream.cjs":2323,"../utils.cjs":2326,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r=this&&this.__rest||function(e,t){var s={};for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&t.indexOf(a)<0&&(s[a]=e[a]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(a=Object.getOwnPropertySymbols(e);n<a.length;n++)t.indexOf(a[n])<0&&Object.prototype.propertyIsEnumerable.call(e,a[n])&&(s[a[n]]=e[a[n]])}return s};Object.defineProperty(s,"__esModule",{value:!0}),s.WindowPostMessageStream=void 0;const i=e("@metamask/utils"),o=e("../BasePostMessageStream.cjs"),c=e("../utils.cjs"),l=null===(a=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"source"))||void 0===a?void 0:a.get;(0,i.assert)(l,"MessageEvent.prototype.source getter is not defined.");const d=null===(n=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"origin"))||void 0===n?void 0:n.get;(0,i.assert)(d,"MessageEvent.prototype.origin getter is not defined.");class u extends o.BasePostMessageStream{constructor(e){var{name:t,target:s,targetOrigin:a=location.origin,targetWindow:n=window}=e;if(super(r(e,["name","target","targetOrigin","targetWindow"])),"undefined"==typeof window||"function"!=typeof window.postMessage)throw new Error("window.postMessage is not a function. This class should only be instantiated in a Window.");this._name=t,this._target=s,this._targetOrigin=a,this._targetWindow=n,this._onMessage=this._onMessage.bind(this),window.addEventListener("message",this._onMessage,!1),this._handshake()}_postMessage(e){this._targetWindow.postMessage({target:this._target,data:e},this._targetOrigin)}_onMessage(e){const t=e.data;"*"!==this._targetOrigin&&d.call(e)!==this._targetOrigin||l.call(e)!==this._targetWindow||!(0,c.isValidStreamMessage)(t)||t.target!==this._name||this._onData(t.data)}_destroy(){window.removeEventListener("message",this._onMessage,!1)}}s.WindowPostMessageStream=u}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/window/WindowPostMessageStream.cjs"}],[233,{"../../../shared/constants/referrals":5462,"@metamask/json-rpc-engine":1985,loglevel:4568},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.HyperliquidPermissionTriggerType=void 0,s.createHyperliquidReferralMiddleware=function(e){return(0,n.createAsyncMiddleware)(async(t,s,a)=>{if(await a(),!function(e){return Boolean(e.origin)&&Boolean(e.tabId)}(t))return;const n="wallet_requestPermissions"===t.method&&t.origin===i.HYPERLIQUID_ORIGIN,c=Array.isArray(s.result)&&s.result.some(e=>"eth_accounts"===(null==e?void 0:e.parentCapability));n&&c&&e(t.tabId,o.NewConnection).catch(e=>{r.default.error("Failed to handle Hyperliquid referral after wallet_requestPermissions grant: ",e)})})};var a,n=e("@metamask/json-rpc-engine"),r=(a=e("loglevel"))&&a.__esModule?a:{default:a},i=e("../../../shared/constants/referrals");let o=s.HyperliquidPermissionTriggerType=function(e){return e.NewConnection="new_connection",e.OnNavigateConnectedTab="on_navigate_connected_tab",e}({})}}},{package:"$root$",file:"app/scripts/lib/createHyperliquidReferralMiddleware.ts"}],[2330,{"./ppom-controller":2331},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;var a=e("./ppom-controller");Object.defineProperty(s,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return a.NETWORK_CACHE_DURATION}}),Object.defineProperty(s,"PPOMController",{enumerable:!0,get:function(){return a.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],[2331,{"./ppom-storage":2332,"./util":2333,"@metamask/base-controller":1264,"@metamask/controller-utils":1343,"await-semaphore":3624},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l,d,u,m,h,p,f,g,b,y,w,v,S,E,k,T,P,_,M,x,C,I,A,N,j,O,R=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},$=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;const D=e("@metamask/base-controller"),B=e("@metamask/controller-utils"),F=e("await-semaphore"),L=e("./ppom-storage"),H=e("./util");s.NETWORK_CACHE_DURATION=6048e5;const U=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],q={versionInfo:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1},storageMetadata:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1}},G="PPOMController",W={headers:{"Content-Type":"application/json"}};class V extends D.BaseController{constructor({chainId:e,messenger:t,provider:s,storageBackend:y,securityAlertsEnabled:w,onPreferencesChange:v,ppomProvider:T,cdnBaseUrl:P,providerRequestLimit:_,state:M,blockaidPublicKey:x,nativeCrypto:C}){super({name:G,metadata:q,messenger:t,state:{versionInfo:M?.versionInfo??[],storageMetadata:M?.storageMetadata??[]}}),a.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),u.set(this,0),m.set(this,void 0),h.set(this,void 0),p.set(this,{}),f.set(this,void 0),g.set(this,!1),b.set(this,undefined),R(this,m,(0,H.addHexPrefix)(e),"f"),R(this,r,s,"f"),R(this,c,T,"f"),R(this,i,new L.PPOMStorage({storageBackend:y,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update(t=>{t.storageMetadata=e})}}),"f"),R(this,o,new F.Mutex,"f"),R(this,l,P,"f"),R(this,d,_??300,"f"),R(this,h,w,"f"),R(this,f,x,"f"),R(this,b,C,"f"),v($(this,a,"m",S).bind(this)),$(this,a,"m",E).call(this),$(this,a,"m",k).call(this)}async usePPOM(e,t){const s=t??$(this,m,"f");if(!$(this,h,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,H.blockaidValidationSupportedForNetwork)(s))throw Error(`Blockaid validation not available on network with chainId: ${s}`);return await $(this,o,"f").use(async()=>{const t=await $(this,a,"m",P).call(this,s);R(this,u,0,"f"),R(this,p,{},"f");return{...await e(t),providerRequestsCount:{...$(this,p,"f")}}})}}s.PPOMController=V,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,u=new WeakMap,m=new WeakMap,h=new WeakMap,p=new WeakMap,f=new WeakMap,g=new WeakMap,b=new WeakMap,a=new WeakSet,y=async function(){if($(this,h,"f")&&!$(this,g,"f")){const{ppomInit:e}=$(this,c,"f");await e("./ppom_bg.wasm"),R(this,g,!0,"f")}},w=function(){$(this,a,"m",T).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)});const{storageMetadata:e}=this.state;this.update(e=>{e.versionInfo=[],e.storageMetadata=[]}),$(this,i,"f").deleteAllFiles(e).catch(e=>{console.error(`Error in deleting files: ${e.message}`)})},v=function(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:s}=t.configuration,n=(0,H.addHexPrefix)(s);n!==$(this,m,"f")&&(R(this,m,n,"f"),$(this,a,"m",T).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)}))},S=function(e){const t=e.securityAlertsEnabled;t!==$(this,h,"f")&&(R(this,h,t,"f"),t||$(this,a,"m",w).call(this))},E=function(){this.messagingSystem.registerActionHandler(`${G}:usePPOM`,this.usePPOM.bind(this))},k=function(){const e=$(this,a,"m",v).bind(this);this.messagingSystem.subscribe("NetworkController:networkDidChange",e)},T=async function(){await $(this,o,"f").use(async()=>{$(this,n,"f")&&($(this,n,"f").free(),R(this,n,undefined,"f"))})},P=async function(e){const t=await $(this,a,"m",_).call(this);let s;return($(this,n,"f")===undefined||t)&&(s=await $(this,a,"m",O).call(this,e),$(this,m,"f")===e&&($(this,n,"f")&&$(this,n,"f").free(),R(this,n,s,"f")),$(this,i,"f").syncMetadata(this.state.versionInfo).catch(e=>{console.error(`Error while trying to sync metadata: ${e.message}`)})),s},_=async function(){const e=await $(this,a,"m",A).call(this);return!!e&&(this.update(t=>{t.versionInfo=e}),!0)},M=function(e,t){return e.find(e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum)},x=async function(e){const t=await Promise.all(e.map(async e=>{let t;try{t=await $(this,a,"m",C).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined}));return t?.filter(e=>e?.[1]!==undefined)},C=async function(e){const{storageMetadata:t}=this.state;if($(this,a,"m",M).call(this,t,e))try{return await $(this,i,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,H.checkFilePath)(e.filePath);const s=(0,H.constructURLHref)($(this,l,"f"),e.filePath),n=await $(this,a,"m",N).call(this,s);return await(0,H.validateSignature)(n,e.hashSignature,$(this,f,"f"),e.filePath,$(this,b,"f")),await $(this,i,"f").writeFile({data:n,...e}).catch(e=>{console.error(`Error in writing file: ${e.message}`)}),n},I=async function(e,t={},s="GET"){const a=await(0,B.safelyExecute)(async()=>(0,B.timeoutFetch)(e,{method:s,cache:"no-cache",redirect:"error",...t},1e4),!0),n=304===a?.status;if(!a?.status||a?.status<200||a?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:n,response:a}},A=async function(){const e=(0,H.constructURLHref)($(this,l,"f"),"ppom_version.json"),{cached:t,response:s}=await $(this,a,"m",I).call(this,e,{headers:W});return t&&this.state.versionInfo?.length?undefined:s.json()},N=async function(e){const{response:t}=await $(this,a,"m",I).call(this,e);return await t.arrayBuffer()},j=async function(e,t){if($(this,u,"f")>$(this,d,"f"))return H.PROVIDER_ERRORS.limitExceeded();if(R(this,u,$(this,u,"f")+1,"f"),!U.includes(e))return H.PROVIDER_ERRORS.methodNotSupported();$(this,p,"f")[e]=$(this,p,"f")[e]?Number($(this,p,"f")[e])+1:1;const s=(0,H.createPayload)(e,t);try{const e=await $(this,r,"f").request(s);return{jsonrpc:"2.0",id:s.id,result:e}}catch(e){return{jsonrpc:"2.0",id:s.id,error:e}}},O=async function(e){await $(this,a,"m",y).call(this);const t=this.state.versionInfo.filter(({chainId:t})=>t===e);if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const s=await $(this,a,"m",x).call(this,t);if(s?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:n}=$(this,c,"f");return n.new($(this,a,"m",j).bind(this),s)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],[2332,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},o=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMStorage=void 0;s.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:s}){a.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i(this,a,e,"f"),i(this,n,t,"f"),i(this,r,s,"f")}async syncMetadata(e){const t=o(this,n,"f").call(this),s=[];for(const a of t){try{await this.readFile(a.name,a.chainId)}catch(e){console.error("Error: ",e);continue}e.find(e=>e.name===a.name&&e.chainId===a.chainId&&e.version===a.version&&e.checksum===a.checksum)&&s.push(a)}const i=await o(this,a,"f").dir();for(const{name:e,chainId:t}of i)s.find(s=>s.name===e&&s.chainId===t)||await o(this,a,"f").delete({name:e,chainId:t});return o(this,r,"f").call(this,s),s}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:s}=t;try{await o(this,a,"f").delete({name:e,chainId:s})}catch(t){console.error(`Error in deleting file: ${e}, ${s}`,t)}}}async readFile(e,t){const s=o(this,n,"f").call(this).find(s=>s.name===e&&s.chainId===t);if(!s)throw new Error(`File metadata (${e}, ${t}) not found`);const r=await o(this,a,"f").read({name:e,chainId:t},s.checksum);if(!r)throw new Error(`Storage File (${e}, ${t}) not found`);return r}async writeFile({data:e,name:t,chainId:s,version:i,checksum:c}){await o(this,a,"f").write({name:t,chainId:s},e,c);const l=o(this,n,"f").call(this),d=l.find(e=>e.name===t&&e.chainId===s);d?(d.version=i,d.checksum=c):l.push({name:t,chainId:s,version:i,checksum:c}),o(this,r,"f").call(this,l)}},a=new WeakMap,n=new WeakMap,r=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],[2333,{buffer:3798,"crypto-js":3915,elliptic:3971,"json-rpc-random-id":4391},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var a=this&&this.__createBinding||(Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),r=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&a(t,e,s);return n(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.checkFilePath=s.addHexPrefix=s.constructURLHref=s.validateSignature=s.PROVIDER_ERRORS=s.createPayload=s.IdGenerator=s.blockaidValidationSupportedForNetwork=s.SUPPORTED_NETWORK_CHAINIDS=void 0;const o=r(e("crypto-js")),c=i(e("elliptic")),l=i(e("json-rpc-random-id")),d=c.default.eddsa;s.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};s.blockaidValidationSupportedForNetwork=e=>Object.values(s.SUPPORTED_NETWORK_CHAINIDS).some(t=>t===e),s.IdGenerator=(0,l.default)();s.createPayload=(e,t)=>({id:(0,s.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),s.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};s.validateSignature=async(e,s,a,n,r,i)=>{const c=await(async(e,t,s=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&s){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map(e=>e.toString(16).padStart(2,"0")).join("")}return(0,o.SHA256)(o.default.lib.WordArray.create(e)).toString()})(e,r,i);if(!new d("ed25519").keyFromPublic(a).verify(t.from(c),s))throw Error(`Signature verification failed for file path: ${n}`)};s.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;s.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;s.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],[234,{loglevel:4568},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function(e){return function(t,s,a){a(a=>{s.error&&n.default.debug("Error in RPC response:\n",s),t.isMetamaskInternal||(n.default.info(`RPC (${e.origin}): ${t.method} -> ${s.error?"error":"success"}`),a())})}};var a,n=(a=e("loglevel"))&&a.__esModule?a:{default:a}}}},{package:"$root$",file:"app/scripts/lib/createLoggerMiddleware.js"}],[235,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({mainFrameOrigin:e}){return function(t,s,a){t.mainFrameOrigin=e,a()}}}}},{package:"$root$",file:"app/scripts/lib/createMainFrameOriginMiddleware.ts"}],[236,{"./stream-utils":309,"@metamask/rpc-errors":2423},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var a=e("@metamask/rpc-errors"),n=e("./stream-utils");s.default=(e,t)=>async s=>{if(!(0,n.isStreamWritable)(t))return;if(!e[s.method])return void t.write({jsonrpc:"2.0",error:a.rpcErrors.methodNotFound({message:`${s.method} not found`}),id:s.id});let r,i;try{r=await e[s.method](...s.params)}catch(e){i=e}(0,n.isStreamWritable)(t)?i?t.write({jsonrpc:"2.0",error:(0,a.serializeError)(i,{shouldIncludeStack:!0}),id:s.id}):t.write({jsonrpc:"2.0",result:r,id:s.id}):i&&console.error(i)}}}},{package:"$root$",file:"app/scripts/lib/createMetaRPCHandler.js"}],[237,{"./middleware/pending":255,"@metamask/eth-json-rpc-middleware":1766,"@metamask/json-rpc-engine":1985},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({version:e,getAccounts:t,processTransaction:s,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:d,processEncryptionPublicKey:u,getPendingNonce:m,getPendingTransactionByHash:h,processRequestExecutionPermissions:p}){return(0,a.mergeMiddleware)([(0,a.createScaffoldMiddleware)({eth_syncing:!1,web3_clientVersion:`MetaMask/v${e}`}),(0,n.createWalletMiddleware)({getAccounts:t,processTransaction:s,processTypedMessage:i,processTypedMessageV3:o,processTypedMessageV4:c,processPersonalMessage:l,processDecryptMessage:d,processEncryptionPublicKey:u,processRequestExecutionPermissions:p}),(0,r.createPendingNonceMiddleware)({getPendingNonce:m}),(0,r.createPendingTxMiddleware)({getPendingTransactionByHash:h})])};var a=e("@metamask/json-rpc-engine"),n=e("@metamask/eth-json-rpc-middleware"),r=e("./middleware/pending")}}},{package:"$root$",file:"app/scripts/lib/createMetamaskMiddleware.js"}],[238,{loglevel:4568,"webextension-polyfill":5424},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({location:e,registerOnboarding:t}){return async function(s,r,i,o){try{if("wallet_registerOnboarding"!==s.method)return void i();s.tabId&&s.tabId!==n.default.tabs.TAB_ID_NONE?await t(e,s.tabId):a.default.debug(`'wallet_registerOnboarding' message from ${e} ignored due to missing tabId`),r.result=!0,o()}catch(e){o(e)}}};var a=r(e("loglevel")),n=r(e("webextension-polyfill"));function r(e){return e&&e.__esModule?e:{default:e}}}}},{package:"$root$",file:"app/scripts/lib/createOnboardingMiddleware.js"}],[239,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function(e){return function(t,s,a){t.origin=e.origin,a()}}}}},{package:"$root$",file:"app/scripts/lib/createOriginMiddleware.js"}],[24,{"../../../../shared/constants/metametrics":5451,"@metamask/assets-controllers":1199,"@metamask/bridge-controller":1271},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.NftControllerInit=void 0;var a=e("@metamask/assets-controllers"),n=e("@metamask/bridge-controller"),r=e("../../../../shared/constants/metametrics");s.NftControllerInit=({controllerMessenger:e,initMessenger:t,persistedState:s})=>({controller:new a.NftController({state:s.NftController,messenger:e,onNftAdded:({address:e,symbol:s,tokenId:a,standard:i,source:o})=>t.call("MetaMetricsController:trackEvent",{event:r.MetaMetricsEventName.NftAdded,category:r.MetaMetricsEventCategory.Wallet,sensitiveProperties:{token_contract_address:e,token_symbol:s??null,token_id:a,token_standard:i,asset_type:n.AssetType.NFT,source:o}})})})}}},{package:"$root$",file:"app/scripts/controller-init/assets/nft-controller-init.ts"}],[240,{"../../../shared/constants/app":5436,"@metamask/rpc-errors":2423},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.SPAM_FILTER_ACTIVATED_ERROR=s.REJECTION_THRESHOLD_IN_MS=s.NUMBER_OF_REJECTIONS_THRESHOLD=s.BLOCKING_THRESHOLD_IN_MS=s.BLOCKABLE_METHODS=void 0,s.default=function({getThrottledOriginState:e,updateThrottledOriginState:t}){return function(s,a,n,m){const{method:h,origin:p}=s;if(!c.has(h)||l.includes(p))return void n();!function(e){if(!e)return!1;const t=Date.now(),{rejections:s,lastRejection:a}=e,n=t-a<=o;return s>=r&&n}(e(p))?n(s=>{if("error"in a&&a.error&&u(a.error)){var n;const r=null===(n=a.error)||void 0===n?void 0:n.data;if("rejectAllApprovals"===(null==r?void 0:r.cause))return void s();const o=e(p)||{rejections:0,lastRejection:0},c=Date.now(),l=c-o.lastRejection<i?o.rejections+1:1;t(p,{rejections:l,lastRejection:c})}else{const s=e(p);Boolean(s)&&t(p,{rejections:0,lastRejection:0})}s()}):m(d)}};var a=e("@metamask/rpc-errors"),n=e("../../../shared/constants/app");const r=s.NUMBER_OF_REJECTIONS_THRESHOLD=3,i=s.REJECTION_THRESHOLD_IN_MS=3e4,o=s.BLOCKING_THRESHOLD_IN_MS=6e4,c=s.BLOCKABLE_METHODS=new Set([n.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN,n.MESSAGE_TYPE.ETH_SEND_TRANSACTION,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3,n.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4,n.MESSAGE_TYPE.PERSONAL_SIGN,n.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN,n.MESSAGE_TYPE.WALLET_SEND_CALLS,n.MESSAGE_TYPE.WATCH_ASSET]),l=["http://127.0.0.1:8080","http://127.0.0.1:8081","http://127.0.0.1:8082","http://localhost:8080","http://localhost:8081","http://localhost:8082"],d=s.SPAM_FILTER_ACTIVATED_ERROR=a.providerErrors.unauthorized("Request blocked due to spam filter."),u=e=>e.code===a.errorCodes.provider.userRejectedRequest}}},{package:"$root$",file:"app/scripts/lib/createOriginThrottlingMiddleware.ts"}],[241,{"../../../shared/constants/app":5436,"../../../shared/constants/metametrics":5451,"../../../shared/constants/security-provider":5463,"../../../shared/constants/signatures":5464,"../../../shared/constants/transaction":5474,"../../../shared/lib/confirmation.utils":5486,"../../../shared/lib/snaps/snaps":5536,"../../../shared/modules/error":5555,"../../../shared/modules/transaction.utils":5577,"../../../ui/helpers/utils/metrics":6715,"./snap-keyring/metrics":297,"@metamask/controller-utils":1343,"@metamask/rpc-errors":2423,"ethereumjs-util":4056},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function({rateLimitTimeout:e=3e5,rateLimitSamplePercent:t=.001,globalRateLimitTimeout:s=3e5,globalRateLimitMaxAmount:_=10,getAccountType:M,getDeviceModel:x,getHardwareTypeForMetric:C,snapAndHardwareMessenger:I,appStateController:A,metaMetricsController:N,getHDEntropyIndex:j}){return async function(O,R,$){const{origin:D,method:B,params:F}=O,L=function(e){return[i.MESSAGE_TYPE.WALLET_CREATE_SESSION,i.MESSAGE_TYPE.WALLET_INVOKE_METHOD].includes(e)}(B),H=L?o.MetaMetricsRequestedThrough.MultichainApi:o.MetaMetricsRequestedThrough.EthereumProvider,U=L?o.MetaMetricsEventCategory.MultichainApi:o.MetaMetricsEventCategory.InpageProvider;let q,G=B;var W;B===i.MESSAGE_TYPE.WALLET_INVOKE_METHOD&&(G=null==F||null===(W=F.request)||void 0===W?void 0:W.method,q=null==F?void 0:F.scope);const V=w[G];let K;switch(V){case b.TIMEOUT:K=void 0!==T[G];break;case b.NON_RATE_LIMITED:K=!1;break;case b.BLOCKED:K=!0;break;default:case b.RANDOM_SAMPLE:K=Math.random()>=t}const Y=_>0&&P>=_,J=!0===N.state.participateInMetaMetrics,z=S[G],Q={api_source:H};let X;q&&(Q.chain_id_caip=q);const Z=(0,f.isSnapPreinstalled)(D),ee=D!==i.ORIGIN_METAMASK&&!Z&&!K&&!Y&&!0===J;if(ee){var te;const t=z?z.REQUESTED:o.MetaMetricsEventName.ProviderMethodCalled;if(t===o.MetaMetricsEventName.SignatureRequested){var se,ae,ne,re,ie;let e;var oe,ce;if(Q.signature_type=G,Q.hd_entropy_index=j(),(0,r.isValidAddress)(null==O||null===(se=O.params)||void 0===se?void 0:se[1]))e=null==O||null===(oe=O.params)||void 0===oe?void 0:oe[0];else e=null==O||null===(ce=O.params)||void 0===ce?void 0:ce[1];null!==(ae=O.securityAlertResponse)&&void 0!==ae&&ae.providerRequestsCount&&Object.keys(O.securityAlertResponse.providerRequestsCount).forEach(e=>{Q[`ppom_${e}_count`]=O.securityAlertResponse.providerRequestsCount[e]}),Q.security_alert_response=(null===(ne=O.securityAlertResponse)||void 0===ne?void 0:ne.result_type)??l.BlockaidResultType.NotApplicable,Q.security_alert_reason=(null===(re=O.securityAlertResponse)||void 0===re?void 0:re.reason)??l.BlockaidReason.notApplicable,null!==(ie=O.securityAlertResponse)&&void 0!==ie&&ie.description&&(Q.security_alert_description=O.securityAlertResponse.description),(0,p.shouldUseRedesignForSignatures)({approvalType:v[G]})&&(Q.ui_customizations=[...Q.ui_customizations||[],o.MetaMetricsEventUiCustomization.RedesignedConfirmation]);const t=await(0,g.getSnapAndHardwareInfoForMetrics)(M,x,C,I);Object.assign(Q,t);try{if(G===i.MESSAGE_TYPE.PERSONAL_SIGN){const{isSIWEMessage:t}=(0,a.detectSIWE)({data:e});t&&(Q.ui_customizations=[...Q.ui_customizations||[],o.MetaMetricsEventUiCustomization.Siwe])}else if(G===i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4){const t=(0,c.parseTypedDataMessage)(e);X={},Q.eip712_primary_type=t.primaryType,X.eip712_verifyingContract=t.domain.verifyingContract,X.eip712_domain_version=t.domain.version,X.eip712_domain_name=t.domain.name,d.PRIMARY_TYPES_PERMIT.includes(t.primaryType)?Q.ui_customizations=[...Q.ui_customizations||[],o.MetaMetricsEventUiCustomization.Permit]:d.PRIMARY_TYPES_ORDER.includes(t.primaryType)&&(Q.ui_customizations=[...Q.ui_customizations||[],o.MetaMetricsEventUiCustomization.Order])}}catch(e){console.warn(`createRPCMethodTrackingMiddleware: Errored - ${e}`)}}else Q.method=G;const n=E[G];if(n&&(Q.params=n(F)),null===(te=k[G])||void 0===te||te.call(k,O,undefined,y.REQUESTED,Q),t===o.MetaMetricsEventName.SignatureRequested){!function(e,t,s,a){e.createEventFragment({category:a,initialEvent:o.MetaMetricsEventName.SignatureRequested,successEvent:o.MetaMetricsEventName.SignatureApproved,failureEvent:o.MetaMetricsEventName.SignatureRejected,uniqueIdentifier:(0,h.generateSignatureUniqueId)(t.id),persist:!0,referrer:{url:t.origin},...s})}(N,O,{properties:Q,sensitiveProperties:X},U)}else N.trackEvent({event:t,category:U,referrer:{url:D},properties:Q});V===b.TIMEOUT&&(T[G]=setTimeout(()=>{delete T[G]},e)),P+=1,setTimeout(()=>{P-=1},s)}$(async e=>{var t,s,a,r;if(!1===ee||void 0===z)return e();const i=null===(t=R.error)||void 0===t||null===(t=t.data)||void 0===t?void 0:t.location;let c,l;const d=(0,m.getErrorMessage)(R.error);if((null===(s=R.error)||void 0===s?void 0:s.code)===n.errorCodes.provider.userRejectedRequest?(c=z.REJECTED,l=y.REJECTED):(null===(a=R.error)||void 0===a?void 0:a.code)===n.errorCodes.rpc.internal&&[d,R.error.message].includes("Request rejected by user or snap.")?(c=z.REJECTED,l=y.REJECTED,Q.status=d):(c=z.APPROVED,l=y.APPROVED),!c)return e();null===(r=k[G])||void 0===r||r.call(k,O,R,l,Q);let p={};if(u.SIGNING_METHODS.includes(G)){var f;const e=A.getSignatureSecurityAlertResponse(null===(f=O.securityAlertResponse)||void 0===f?void 0:f.securityAlertId);p=(0,h.getBlockaidMetricsProps)({securityAlertResponse:e})}const g={...Q,...p,location:i};if(c===o.MetaMetricsEventName.SignatureRejected||c===o.MetaMetricsEventName.SignatureApproved){const e={abandoned:c===z.REJECTED},t={properties:{...g,hd_entropy_index:j()},sensitiveProperties:X};!function(e,t,s,a){const n=(0,h.generateSignatureUniqueId)(t.id);e.updateEventFragment(n,a),e.finalizeEventFragment(n,s)}(N,O,e,t)}else N.trackEvent({event:c,category:U,referrer:{url:D},properties:g});return e()})}};var a=e("@metamask/controller-utils"),n=e("@metamask/rpc-errors"),r=e("ethereumjs-util"),i=e("../../../shared/constants/app"),o=e("../../../shared/constants/metametrics"),c=e("../../../shared/modules/transaction.utils"),l=e("../../../shared/constants/security-provider"),d=e("../../../shared/constants/signatures"),u=e("../../../shared/constants/transaction"),m=e("../../../shared/modules/error"),h=e("../../../ui/helpers/utils/metrics"),p=e("../../../shared/lib/confirmation.utils"),f=e("../../../shared/lib/snaps/snaps"),g=e("./snap-keyring/metrics");const b={TIMEOUT:"timeout",BLOCKED:"blocked",NON_RATE_LIMITED:"non_rate_limited",RANDOM_SAMPLE:"random_sample"},y={REQUESTED:"REQUESTED",APPROVED:"APPROVED",REJECTED:"REJECTED"},w={[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.PERSONAL_SIGN]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_DECRYPT]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]:b.TIMEOUT,[i.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]:b.TIMEOUT,[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.SEND_METADATA]:b.BLOCKED,[i.MESSAGE_TYPE.ETH_CHAIN_ID]:b.BLOCKED,[i.MESSAGE_TYPE.ETH_ACCOUNTS]:b.BLOCKED,[i.MESSAGE_TYPE.LOG_WEB3_SHIM_USAGE]:b.BLOCKED,[i.MESSAGE_TYPE.GET_PROVIDER_STATE]:b.BLOCKED,[i.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]:b.NON_RATE_LIMITED,[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:b.NON_RATE_LIMITED},v={[i.MESSAGE_TYPE.PERSONAL_SIGN]:a.ApprovalType.PersonalSign,[i.MESSAGE_TYPE.SIGN]:a.ApprovalType.SignTransaction,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:a.ApprovalType.EthSignTypedData,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1]:a.ApprovalType.EthSignTypedData,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:a.ApprovalType.EthSignTypedData,[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:a.ApprovalType.EthSignTypedData},S={[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.PERSONAL_SIGN]:{APPROVED:o.MetaMetricsEventName.SignatureApproved,REJECTED:o.MetaMetricsEventName.SignatureRejected,REQUESTED:o.MetaMetricsEventName.SignatureRequested},[i.MESSAGE_TYPE.ETH_DECRYPT]:{APPROVED:o.MetaMetricsEventName.DecryptionApproved,REJECTED:o.MetaMetricsEventName.DecryptionRejected,REQUESTED:o.MetaMetricsEventName.DecryptionRequested},[i.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]:{APPROVED:o.MetaMetricsEventName.EncryptionPublicKeyApproved,REJECTED:o.MetaMetricsEventName.EncryptionPublicKeyRejected,REQUESTED:o.MetaMetricsEventName.EncryptionPublicKeyRequested},[i.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:{APPROVED:o.MetaMetricsEventName.PermissionsApproved,REJECTED:o.MetaMetricsEventName.PermissionsRejected,REQUESTED:o.MetaMetricsEventName.PermissionsRequested},[i.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called},[i.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called},[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:{REQUESTED:o.MetaMetricsEventName.Wallet5792Called}},E={[i.MESSAGE_TYPE.WATCH_ASSET]:({type:e})=>({type:e}),[i.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]:([{chainId:e}])=>({chainId:e}),[i.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]:([{chainId:e}])=>({chainId:e})},k={[i.MESSAGE_TYPE.WALLET_SEND_CALLS]:function(e,t,s,a){var n;if(s!==y.REQUESTED)return;const{params:r}=e,i=null==r||null===(n=r[0])||void 0===n||null===(n=n.calls)||void 0===n?void 0:n.length;i&&(a.batch_transaction_count=i)},[i.MESSAGE_TYPE.WALLET_CREATE_SESSION]:function(e,t,s,a){if(s===y.REQUESTED){const{params:t}=e,s=(null==t?void 0:t.requiredScopes)||{},n=(null==t?void 0:t.optionalScopes)||{},r=new Set;for(const e of Object.keys(s))r.add(e);for(const e of Object.keys(n))r.add(e);a.chain_id_list=Array.from(r)}else if(s===y.APPROVED){const{result:e}=t,s=Object.keys((null==e?void 0:e.sessionScopes)||{});a.chain_id_list=s}}},T={};let P=0}}},{package:"$root$",file:"app/scripts/lib/createRPCMethodTrackingMiddleware.js"}],[2412,{"@metamask/base-controller":1264,"@metamask/rpc-errors":2423,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;const a=e("@metamask/base-controller"),n=e("@metamask/rpc-errors"),r=e("@metamask/utils"),i="RateLimitController",o={requests:{persist:!1,anonymous:!1}};class c extends a.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:s,state:a,implementations:n}){const c={requests:(0,r.getKnownPropertyNames)(n).reduce((e,t)=>({...e,[t]:{}}),{})};super({name:i,metadata:o,messenger:s,state:{...c,...a}}),this.implementations=n,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messagingSystem.registerActionHandler(`${i}:call`,(e,t,...s)=>this.call(e,t,...s))}async call(e,t,...s){if(this.isRateLimited(t,e))throw n.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const a=this.implementations[t].method;if(!a)throw new Error("Invalid api type");return a(...s)}isRateLimited(e,t){const s=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=s}recordRequest(e,t){const s=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,a=this.state.requests[e][t]??0;this.update(n=>{0===a&&setTimeout(()=>this.resetRequestCount(e,t),s),Object.assign(n,{requests:{...n.requests,[e]:{[t]:a+1}}})})}resetRequestCount(e,t){this.update(s=>{Object.assign(s,{requests:{...s.requests,[e]:{[t]:0}}})})}}s.RateLimitController=c}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],[2413,{"./RateLimitController.cjs":2412},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;var a=e("./RateLimitController.cjs");Object.defineProperty(s,"RateLimitController",{enumerable:!0,get:function(){return a.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],[2414,{"../constants.cjs":2415,"@metamask/controller-utils":1343},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},l=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ClientConfigApiService=void 0;const d=e("@metamask/controller-utils"),u=e("../constants.cjs");s.ClientConfigApiService=class{constructor({fetch:e,retries:t=d.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:s=d.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:u=d.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:m,onDegraded:h,config:p}){a.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c(this,a,e,"f"),c(this,r,p.client,"f"),c(this,i,p.distribution,"f"),c(this,o,p.environment,"f"),c(this,n,(0,d.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:s,circuitBreakDuration:u}),"f"),m&&l(this,n,"f").onBreak(m),h&&l(this,n,"f").onDegraded(h)}onBreak(...e){return l(this,n,"f").onBreak(...e)}onDegraded(...e){return l(this,n,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${u.BASE_URL}/flags?client=${l(this,r,"f")}&distribution=${l(this,i,"f")}&environment=${l(this,o,"f")}`,t=await l(this,n,"f").execute(()=>l(this,a,"f").call(this,e,{cache:"no-cache"}));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const s=await t.json();if(!Array.isArray(s))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(s),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce((e,t)=>({...e,...t}),{})}},a=new WeakMap,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],[2415,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BASE_URL=void 0,s.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],[2416,{"./client-config-api-service/client-config-api-service.cjs":2414,"./remote-feature-flag-controller-types.cjs":2417,"./remote-feature-flag-controller.cjs":2418,"./utils/user-segmentation-utils.cjs":2419},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.generateDeterministicRandomNumber=s.ClientConfigApiService=s.EnvironmentType=s.DistributionType=s.ClientType=s.RemoteFeatureFlagController=void 0;var a=e("./remote-feature-flag-controller.cjs");Object.defineProperty(s,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return a.RemoteFeatureFlagController}});var n=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(s,"ClientType",{enumerable:!0,get:function(){return n.ClientType}}),Object.defineProperty(s,"DistributionType",{enumerable:!0,get:function(){return n.DistributionType}}),Object.defineProperty(s,"EnvironmentType",{enumerable:!0,get:function(){return n.EnvironmentType}});var r=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(s,"ClientConfigApiService",{enumerable:!0,get:function(){return r.ClientConfigApiService}});var i=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(s,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return i.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],[2417,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r;Object.defineProperty(s,"__esModule",{value:!0}),s.EnvironmentType=s.DistributionType=s.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(a||(s.ClientType=a={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(n||(s.DistributionType=n={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev"}(r||(s.EnvironmentType=r={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],[2418,{"./utils/user-segmentation-utils.cjs":2419,"@metamask/base-controller":1264},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l,d,u,m=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RemoteFeatureFlagController=s.getDefaultRemoteFeatureFlagControllerState=s.DEFAULT_CACHE_DURATION=s.controllerName=void 0;const p=e("@metamask/base-controller"),f=e("./utils/user-segmentation-utils.cjs");s.controllerName="RemoteFeatureFlagController",s.DEFAULT_CACHE_DURATION=864e5;const g={remoteFeatureFlags:{persist:!0,anonymous:!0},cacheTimestamp:{persist:!0,anonymous:!0}};function b(){return{remoteFeatureFlags:{},cacheTimestamp:0}}s.getDefaultRemoteFeatureFlagControllerState=b;class y extends p.BaseController{constructor({messenger:e,state:t,clientConfigApiService:l,fetchInterval:d=s.DEFAULT_CACHE_DURATION,disabled:u=!1,getMetaMetricsId:h}){super({name:s.controllerName,metadata:g,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),a.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),m(this,n,d,"f"),m(this,r,u,"f"),m(this,i,l,"f"),m(this,c,h,"f")}async updateRemoteFeatureFlags(){if(h(this,r,"f")||!h(this,a,"m",l).call(this))return;let e;if(h(this,o,"f"))await h(this,o,"f");else{try{m(this,o,h(this,i,"f").fetchRemoteFeatureFlags(),"f"),e=await h(this,o,"f")}finally{m(this,o,undefined,"f")}await h(this,a,"m",d).call(this,e.remoteFeatureFlags)}}enable(){m(this,r,!1,"f")}disable(){m(this,r,!0,"f")}}s.RemoteFeatureFlagController=y,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,a=new WeakSet,l=function(){return Date.now()-this.state.cacheTimestamp>h(this,n,"f")},d=async function(e){const t=await h(this,a,"m",u).call(this,e);this.update(()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()}))},u=async function(e){const t={},s=h(this,c,"f").call(this),a=(0,f.generateDeterministicRandomNumber)(s);for(const[s,n]of Object.entries(e)){let e=n;if(Array.isArray(n)&&a){const t=n.find(e=>!!(0,f.isFeatureFlagWithScopeValue)(e)&&a<=e.scope.value);t&&(e={name:t.name,value:t.value})}t[s]=e}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],[2419,{uuid:5392},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isFeatureFlagWithScopeValue=s.generateDeterministicRandomNumber=void 0;const a=e("uuid");function n(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const r=n("00000000-0000-4000-8000-000000000000"),i=n("ffffffff-ffff-4fff-bfff-ffffffffffff")-r;s.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,s;if((0,a.validate)(e)){if(4!==(0,a.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,a.version)(e)}`);t=n(e)-r,s=i}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const a=e.slice(2),n=64;if(a.length!==n)throw new Error(`Invalid hex ID length. Expected ${n} characters, got ${a.length}`);if(!/^[0-9a-f]+$/iu.test(a))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${a}`),s=BigInt(`0x${"f".repeat(a.length)}`)}return Number(t*BigInt(1e6)/s)/1e6};s.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],[242,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function(e){return function(t,s,a){t.tabId=e.tabId,a()}}}}},{package:"$root$",file:"app/scripts/lib/createTabIdMiddleware.js"}],[243,{"../../../shared/constants/app":5436,"../../../shared/lib/trace":5541},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=function(){return async function(e,t,s){const{id:a,method:o}=e,c=r[o];c&&(e.traceContext=await(0,n.trace)({name:c,id:a,tags:i[o]}),await(0,n.trace)({name:n.TraceName.Middleware,id:a,parentContext:e.traceContext})),s()}};var a=e("../../../shared/constants/app"),n=e("../../../shared/lib/trace");const r={[a.MESSAGE_TYPE.ETH_SEND_TRANSACTION]:n.TraceName.Transaction,[a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]:n.TraceName.Signature,[a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1]:n.TraceName.Signature,[a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]:n.TraceName.Signature,[a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]:n.TraceName.Signature,[a.MESSAGE_TYPE.PERSONAL_SIGN]:n.TraceName.Signature},i={[a.MESSAGE_TYPE.ETH_SEND_TRANSACTION]:{source:"dapp"}}}}},{package:"$root$",file:"app/scripts/lib/createTracingMiddleware.ts"}],[244,{"../../../../shared/lib/deep-links/constants":5488,"../../../../shared/lib/deep-links/parse":5490,"../../../../shared/lib/deep-links/routes/route":5498,"../../../../shared/lib/deep-links/verify":5500,"../../../../shared/modules/mv3.utils":5562,events:4098,loglevel:4568,"webextension-polyfill":5424},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.DeepLinkRouter=void 0;var a=u(e("events")),n=u(e("webextension-polyfill")),r=u(e("loglevel")),i=e("../../../../shared/modules/mv3.utils"),o=e("../../../../shared/lib/deep-links/parse"),c=e("../../../../shared/lib/deep-links/constants"),l=e("../../../../shared/lib/deep-links/routes/route"),d=e("../../../../shared/lib/deep-links/verify");function u(e){return e&&e.__esModule?e:{default:e}}function m(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}const h=l.DEEP_LINK_ROUTE.replace(/^\//u,"");class p extends a.default{constructor({getExtensionURL:e,getState:t}){super(),m(this,"getExtensionURL",void 0),m(this,"getState",void 0),m(this,"handleBeforeRequest",({tabId:e,url:t})=>e===n.default.tabs.TAB_ID_NONE?{}:this.tryNavigateTo(e,t)),this.getExtensionURL=e,this.getState=t}formatUrlForInterstitialPage(e){return e.pathname+e.search}get404ErrorURL(e){const t=new URLSearchParams({errorCode:"404"});return e&&t.set("u",this.formatUrlForInterstitialPage(e)),this.getExtensionURL(h,t.toString())}async redirectTab(e,t){try{await n.default.tabs.update(e,{url:t})}catch(e){r.default.error("Error redirecting tab:",e),this.emit("error",e)}}install(){n.default.webRequest.onBeforeRequest.addListener(this.handleBeforeRequest,{urls:[`*://*.${c.DEEP_LINK_HOST}/*`],types:["main_frame"]},i.isManifestV3?[]:["blocking"])}uninstall(){n.default.webRequest.onBeforeRequest.removeListener(this.handleBeforeRequest)}async tryNavigateTo(e,t){if(t.length>c.DEEP_LINK_MAX_LENGTH)return r.default.debug("Url is too long, skipping deep link handling"),{};let s;try{const e=new URL(t),a=await(0,o.parse)(e);if(a)if(this.emit("navigate",{url:e,parsed:a}),"redirectTo"in a.destination)s=a.destination.redirectTo.toString();else if(this.canSkipInterstitial(a.signature))s=this.getExtensionURL(a.destination.path,a.destination.query.toString());else{const t=new URLSearchParams({u:this.formatUrlForInterstitialPage(e)});s=this.getExtensionURL(h,t.toString())}else s=this.get404ErrorURL(e)}catch(e){r.default.error("Invalid URL:",t,e),this.emit("error",e),s=this.get404ErrorURL()}return this.redirectTab(e,s),i.isManifestV3?{}:{cancel:!0}}canSkipInterstitial(e){var t;return e===d.VALID&&Boolean(null===(t=this.getState().preferences)||void 0===t?void 0:t.skipDeepLinkInterstitial)}}s.DeepLinkRouter=p}}},{package:"$root$",file:"app/scripts/lib/deep-links/deep-link-router.ts"}],[2446,{"@metamask/base-controller":1264,"@metamask/swappable-obj-proxy":2749},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},d=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=s.METAMASK_DOMAIN=s.controllerName=void 0;const u=e("@metamask/base-controller"),m=e("@metamask/swappable-obj-proxy");s.controllerName="SelectedNetworkController";const h={domains:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0}};s.METAMASK_DOMAIN="metamask",s.SelectedNetworkControllerActionTypes={getState:`${s.controllerName}:getState`,getNetworkClientIdForDomain:`${s.controllerName}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${s.controllerName}:setNetworkClientIdForDomain`},s.SelectedNetworkControllerEventTypes={stateChange:`${s.controllerName}:stateChange`};class p extends u.BaseController{constructor({messenger:e,state:t={domains:{}},domainProxyMap:i}){super({name:s.controllerName,metadata:h,messenger:e,state:t}),a.add(this),n.set(this,void 0),l(this,n,i,"f"),d(this,a,"m",r).call(this),this.messagingSystem.call("PermissionController:getSubjectNames").filter(e=>this.state.domains[e]===undefined).forEach(e=>this.setNetworkClientIdForDomain(e,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId)),this.messagingSystem.subscribe("PermissionController:stateChange",(e,t)=>{t.forEach(({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const s=t[1];"add"===e&&this.state.domains[s]===undefined?this.setNetworkClientIdForDomain(s,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[s]!==undefined&&d(this,a,"m",o).call(this,s)}})}),this.messagingSystem.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e,networkConfigurationsByChainId:t},s)=>{const a=s.find(({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]);if(a){const s=Object.values(t).reduce((e,t)=>(t.rpcEndpoints.forEach(({networkClientId:s})=>e[s]=t.chainId),e),{});Object.entries(this.state.domains).forEach(([n,r])=>{const i=s[r];if("remove"!==a.op||i){if("replace"===a.op){const e=a.path[1];if(!i||i===e){const s=t[e],{networkClientId:a}=s.rpcEndpoints[s.defaultRpcEndpointIndex];r!==a&&this.setNetworkClientIdForDomain(n,a)}}}else this.setNetworkClientIdForDomain(n,e)})}})}setNetworkClientIdForDomain(e,t){if(e===s.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${s.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!d(this,a,"m",c).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");d(this,a,"m",i).call(this,e,t)}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messagingSystem.call("NetworkController:getState");return this.state.domains[e]??t}getProviderAndBlockTracker(e){if(e===s.METAMASK_DOMAIN){const e=this.messagingSystem.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=d(this,n,"f").get(e);if(t===undefined){let s;if(d(this,a,"m",c).call(this,e)){const t=this.getNetworkClientIdForDomain(e);s=this.messagingSystem.call("NetworkController:getNetworkClientById",t)}else if(s=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),s===undefined)throw new Error("Selected network not initialized");t={provider:(0,m.createEventEmitterProxy)(s.provider),blockTracker:(0,m.createEventEmitterProxy)(s.blockTracker,{eventFilter:"skipInternal"})},d(this,n,"f").set(e,t)}return t}}s.SelectedNetworkController=p,n=new WeakMap,a=new WeakSet,r=function(){this.messagingSystem.registerActionHandler(s.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messagingSystem.registerActionHandler(s.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},i=function(e,t){const s=this.messagingSystem.call("NetworkController:getNetworkClientById",t);this.update(s=>{s.domains[e]=t});const a=this.getProviderAndBlockTracker(e);a.provider.setTarget(s.provider),a.blockTracker.setTarget(s.blockTracker)},o=function(e){const t=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),s=d(this,n,"f").get(e);s&&t?(s.provider.setTarget(t.provider),s.blockTracker.setTarget(t.blockTracker)):s&&d(this,n,"f").delete(e),this.update(t=>{delete t.domains[e]})},c=function(e){return this.messagingSystem.call("PermissionController:hasPermissions",e)}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],[2447,{"./SelectedNetworkController.cjs":2446},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=void 0;const a=e("./SelectedNetworkController.cjs");s.createSelectedNetworkMiddleware=e=>(t,s,n)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var r;return t.networkClientId=(r=t.origin,e.call(a.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,r)),n()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],[2448,{"./SelectedNetworkController.cjs":2446,"./SelectedNetworkMiddleware.cjs":2447},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=s.METAMASK_DOMAIN=s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=void 0;var a=e("./SelectedNetworkController.cjs");Object.defineProperty(s,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return a.SelectedNetworkControllerActionTypes}}),Object.defineProperty(s,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return a.SelectedNetworkControllerEventTypes}}),Object.defineProperty(s,"SelectedNetworkController",{enumerable:!0,get:function(){return a.SelectedNetworkController}}),Object.defineProperty(s,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return a.METAMASK_DOMAIN}});var n=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(s,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return n.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],[2449,{"./constants.cjs":2451,"./logger.cjs":2453,"@metamask/base-controller":1264,"@metamask/signature-controller":2455,"@metamask/transaction-controller":2789},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l,d,u,m,h,p,f,g,b=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},y=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ShieldController=s.getDefaultShieldControllerState=void 0;const w=e("@metamask/base-controller"),v=e("@metamask/signature-controller"),S=e("@metamask/transaction-controller"),E=e("./constants.cjs"),k=e("./logger.cjs"),T=(0,k.createModuleLogger)(k.projectLogger,"ShieldController");function P(){return{coverageResults:{},orderedTransactionHistory:[]}}s.getDefaultShieldControllerState=P;const _={coverageResults:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0},orderedTransactionHistory:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1}};class M extends w.BaseController{constructor(e){const{messenger:t,state:s,backend:m,transactionHistoryLimit:h=100,coverageHistoryLimit:p=10}=e;super({name:E.controllerName,metadata:_,messenger:t,state:{coverageResults:{},orderedTransactionHistory:[],...s}}),a.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),b(this,n,m,"f"),b(this,r,p,"f"),b(this,i,h,"f"),b(this,o,y(this,a,"m",u).bind(this),"f"),b(this,c,y(this,a,"m",d).bind(this),"f"),b(this,l,!1,"f")}start(){y(this,l,"f")||(b(this,l,!0,"f"),this.messagingSystem.subscribe("TransactionController:stateChange",y(this,o,"f"),e=>e.transactions),this.messagingSystem.subscribe("SignatureController:stateChange",y(this,c,"f"),e=>e.signatureRequests))}stop(){y(this,l,"f")&&(b(this,l,!1,"f"),this.messagingSystem.unsubscribe("TransactionController:stateChange",y(this,o,"f")),this.messagingSystem.unsubscribe("SignatureController:stateChange",y(this,c,"f")))}async checkCoverage(e){const t=y(this,a,"m",g).call(this,e.id),s=await y(this,n,"f").checkCoverage({txMeta:e,coverageId:t});return this.messagingSystem.publish(`${E.controllerName}:coverageResultReceived`,s),y(this,a,"m",m).call(this,e.id,s),s}async checkSignatureCoverage(e){const t=y(this,a,"m",g).call(this,e.id),s=await y(this,n,"f").checkSignatureCoverage({signatureRequest:e,coverageId:t});return this.messagingSystem.publish(`${E.controllerName}:coverageResultReceived`,s),y(this,a,"m",m).call(this,e.id,s),s}}s.ShieldController=M,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,a=new WeakSet,d=function(e,t){const s=Object.values(e),n=Object.values(t??{}),r=new Map(n.map(e=>[e.id,e]));for(const e of s){const t=r.get(e.id);t||e.type!==v.SignatureRequestType.PersonalSign||this.checkSignatureCoverage(e).catch(e=>T("Error checking coverage:",e)),e.status===v.SignatureRequestStatus.Signed&&e.status!==t?.status&&y(this,a,"m",h).call(this,e).catch(e=>T("Error logging signature:",e))}},u=function(e,t){const s=new Map(t?.map(e=>[e.id,e])??[]);for(const t of e){const e=s.get(t.id);e&&e.simulationData===t.simulationData||this.checkCoverage(t).catch(e=>T("Error checking coverage:",e)),t.status===S.TransactionStatus.submitted&&t.status!==e?.status&&y(this,a,"m",p).call(this,t).catch(e=>T("Error logging transaction:",e))}},m=function(e,t){const s=y(this,a,"m",g).call(this,e);if(s&&t.coverageId!==s)throw new Error("Coverage ID has changed");this.update(s=>{let a=!1,n=s.coverageResults[e];n||(a=!0,n={results:[]},s.coverageResults[e]=n),n.results.length>=y(this,r,"f")&&n.results.pop(),n.results.unshift(t);const{orderedTransactionHistory:o}=s;let c;a&&(o.length>=y(this,i,"f")&&(c=o.pop(),c&&delete s.coverageResults[c]),o.unshift(e))})},h=async function(e){const t=e.rawSig;if(!t)throw new Error("Signature not found");const{status:s}=y(this,a,"m",f).call(this,e.id);await y(this,n,"f").logSignature({signatureRequest:e,signature:t,status:s})},p=async function(e){const t=e.hash;if(!t)throw new Error("Transaction hash not found");const{status:s}=y(this,a,"m",f).call(this,e.id);await y(this,n,"f").logTransaction({txMeta:e,transactionHash:t,status:s})},f=function(e){let t="shown";return y(this,a,"m",g).call(this,e)||(T("Coverage ID not found for",e),t="not_shown"),{status:t}},g=function(e){return this.state.coverageResults[e]?.results[0]?.coverageId}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/ShieldController.cjs"}],[245,{"../../../../shared/constants/metametrics":5451},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createEvent=function({signature:e,url:t}){const s={route:t.pathname,signature:e},r={};for(const[e,a]of t.searchParams.entries())"sig"!==e&&("attributionId"===e?s.attribution_id=a:n.has(e)?s[e]=a:r[e]=a);return{category:a.MetaMetricsEventCategory.DeepLink,event:a.MetaMetricsEventName.DeepLinkUsed,properties:s,sensitiveProperties:r}};var a=e("../../../../shared/constants/metametrics");const n=new Set(["utm_campaign","utm_content","utm_medium","utm_source","utm_term"])}}},{package:"$root$",file:"app/scripts/lib/deep-links/metrics.ts"}],[2450,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l,d,u,m=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ShieldRemoteBackend=void 0;async function p(e){return new Promise(t=>setTimeout(t,e))}function f(e){return{txParams:[{from:e.txParams.from,to:e.txParams.to,value:e.txParams.value,data:e.txParams.data,nonce:e.txParams.nonce}],chainId:e.chainId,origin:e.origin}}function g(e){if("string"!=typeof e.messageParams.data)throw new Error("Signature data must be a string");return{chainId:e.chainId,data:e.messageParams.data,from:e.messageParams.from,method:e.type,origin:e.messageParams.origin}}s.ShieldRemoteBackend=class{constructor({getAccessToken:e,getCoverageResultTimeout:t=5e3,getCoverageResultPollInterval:s=1e3,baseUrl:l,fetch:d}){a.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),m(this,n,e,"f"),m(this,r,t,"f"),m(this,i,s,"f"),m(this,o,l,"f"),m(this,c,d,"f")}async checkCoverage(e){let{coverageId:t}=e;if(!t){const s=f(e.txMeta);({coverageId:t}=await h(this,a,"m",l).call(this,"v1/transaction/coverage/init",s))}const s=`${h(this,o,"f")}/v1/transaction/coverage/result`,n=await h(this,a,"m",d).call(this,t,{coverageResultUrl:s});return{coverageId:t,message:n.message,reasonCode:n.reasonCode,status:n.status}}async checkSignatureCoverage(e){let{coverageId:t}=e;if(!t){const s=g(e.signatureRequest);({coverageId:t}=await h(this,a,"m",l).call(this,"v1/signature/coverage/init",s))}const s=`${h(this,o,"f")}/v1/signature/coverage/result`,n=await h(this,a,"m",d).call(this,t,{coverageResultUrl:s});return{coverageId:t,message:n.message,reasonCode:n.reasonCode,status:n.status}}async logSignature(e){const t=g(e.signatureRequest),s={signature:e.signature,status:e.status,...t},n=await h(this,c,"f").call(this,`${h(this,o,"f")}/v1/signature/coverage/log`,{method:"POST",headers:await h(this,a,"m",u).call(this),body:JSON.stringify(s)});if(200!==n.status)throw new Error(`Failed to log signature: ${n.status}`)}async logTransaction(e){const t=f(e.txMeta),s={transactionHash:e.transactionHash,status:e.status,...t},n=await h(this,c,"f").call(this,`${h(this,o,"f")}/v1/transaction/coverage/log`,{method:"POST",headers:await h(this,a,"m",u).call(this),body:JSON.stringify(s)});if(200!==n.status)throw new Error(`Failed to log transaction: ${n.status}`)}},n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,a=new WeakSet,l=async function(e,t){const s=await h(this,c,"f").call(this,`${h(this,o,"f")}/${e}`,{method:"POST",headers:await h(this,a,"m",u).call(this),body:JSON.stringify(t)});if(200!==s.status)throw new Error(`Failed to init coverage check: ${s.status}`);return await s.json()},d=async function(e,t){const s={coverageId:e},n=t?.timeout??h(this,r,"f"),o=t?.pollInterval??h(this,i,"f"),l=await h(this,a,"m",u).call(this);return await new Promise((e,a)=>{let r=!1;setTimeout(()=>{r=!0,a(new Error("Timeout waiting for coverage result"))},n);(async()=>{for(;!r;){const e=Date.now(),a=await h(this,c,"f").call(this,t.coverageResultUrl,{method:"POST",headers:l,body:JSON.stringify(s)});if(200===a.status)return await a.json();await p(o-(Date.now()-e))}throw new Error("unexpected error")})().then(e).catch(a)})},u=async function(){return{"Content-Type":"application/json",Authorization:`Bearer ${await h(this,n,"f").call(this)}`}}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/backend.cjs"}],[2451,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.controllerName=void 0,s.controllerName="ShieldController"}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/constants.cjs"}],[2452,{"./ShieldController.cjs":2449,"./backend.cjs":2450},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ShieldRemoteBackend=s.getDefaultShieldControllerState=s.ShieldController=void 0;var a=e("./ShieldController.cjs");Object.defineProperty(s,"ShieldController",{enumerable:!0,get:function(){return a.ShieldController}}),Object.defineProperty(s,"getDefaultShieldControllerState",{enumerable:!0,get:function(){return a.getDefaultShieldControllerState}});var n=e("./backend.cjs");Object.defineProperty(s,"ShieldRemoteBackend",{enumerable:!0,get:function(){return n.ShieldRemoteBackend}})}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/index.cjs"}],[2453,{"./constants.cjs":2451,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.projectLogger=void 0;const a=e("@metamask/utils");Object.defineProperty(s,"createModuleLogger",{enumerable:!0,get:function(){return a.createModuleLogger}});const n=e("./constants.cjs");s.projectLogger=(0,a.createProjectLogger)(n.controllerName)}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/logger.cjs"}],[246,{"@metamask/browser-passworder":1299},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.encryptorFactory=void 0;var a=e("@metamask/browser-passworder");const n=e=>async(t,s,n,r)=>(0,a.encrypt)(t,s,n,r,{algorithm:"PBKDF2",params:{iterations:e}}),r=e=>async(t,s,n)=>(0,a.encryptWithDetail)(t,s,n,{algorithm:"PBKDF2",params:{iterations:e}}),i=e=>async(t,s,n,r)=>(0,a.keyFromPassword)(t,s,n,r??{algorithm:"PBKDF2",params:{iterations:e}}),o=e=>t=>(0,a.isVaultUpdated)(t,{algorithm:"PBKDF2",params:{iterations:e}});s.encryptorFactory=e=>({encrypt:n(e),encryptWithKey:a.encryptWithKey,encryptWithDetail:r(e),decrypt:a.decrypt,decryptWithKey:a.decryptWithKey,decryptWithDetail:a.decryptWithDetail,keyFromPassword:i(e),isVaultUpdated:o(e),importKey:a.importKey,exportKey:a.exportKey,generateSalt:a.generateSalt})}}},{package:"$root$",file:"app/scripts/lib/encryptor-factory.ts"}],[2463,{"./constants":2464,"./types":2466,"./utils":2467,"@ethersproject/bytes":686,"@metamask/controller-utils":1343,"@metamask/eth-query":1873,"@metamask/polling-controller":2471,"@metamask/transaction-controller":2789,"bignumber.js":2476,"lodash/cloneDeep":4536},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l,d,u,m,h,p,f,g,b,y,w,v,S,E,k,T,P,_,M,x,C,I=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},A=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)},N=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getDefaultSmartTransactionsControllerState=s.DEFAULT_INTERVAL=void 0;const j=e("@ethersproject/bytes"),O=e("@metamask/controller-utils"),R=N(e("@metamask/eth-query")),$=e("@metamask/polling-controller"),D=e("@metamask/transaction-controller"),B=e("bignumber.js"),F=N(e("lodash/cloneDeep")),L=e("./constants"),H=e("./types"),U=e("./utils");s.DEFAULT_INTERVAL=5e3;const q="`ethQuery` is not defined on SmartTransactionsController",G="SmartTransactionsController",W={smartTransactionsState:{persist:!1,anonymous:!0}};function V(){return{smartTransactionsState:{smartTransactions:{},userOptIn:null,userOptInV2:null,fees:{approvalTxFees:null,tradeTxFees:null},liveness:!0,livenessByChainId:{[O.ChainId.mainnet]:!0,[O.ChainId.sepolia]:!0},feesByChainId:{[O.ChainId.mainnet]:{approvalTxFees:null,tradeTxFees:null},[O.ChainId.sepolia]:{approvalTxFees:null,tradeTxFees:null}}}}}s.getDefaultSmartTransactionsControllerState=V;class K extends((0,$.StaticIntervalPollingController)()){constructor({interval:e=s.DEFAULT_INTERVAL,clientId:t,chainId:b=O.ChainId.mainnet,supportedChainIds:y=[O.ChainId.mainnet,O.ChainId.sepolia],getNonceLock:w,confirmExternalTransaction:v,trackMetaMetricsEvent:S,state:E={},messenger:k,getTransactions:T,getMetaMetricsProps:P,getFeatureFlags:_,updateTransaction:M,trace:x}){super({name:G,metadata:W,messenger:k,state:Object.assign(Object.assign({},V()),E)}),a.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),u.set(this,void 0),m.set(this,void 0),h.set(this,void 0),p.set(this,void 0),f.set(this,void 0),g.set(this,void 0),I(this,n,e,"f"),I(this,r,t,"f"),I(this,i,b,"f"),I(this,o,y,"f"),this.setIntervalLength(e),I(this,c,w,"f"),I(this,l,undefined,"f"),I(this,d,v,"f"),I(this,u,T,"f"),I(this,m,S,"f"),I(this,h,P,"f"),I(this,p,_,"f"),I(this,f,M,"f"),I(this,g,null!=x?x:(e,t)=>null==t?void 0:t(),"f"),this.initializeSmartTransactionsForChainId(),this.messagingSystem.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e})=>{const{configuration:{chainId:t},provider:s}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);I(this,i,t,"f"),I(this,l,new R.default(s),"f"),this.initializeSmartTransactionsForChainId(),this.checkPoll(this.state)}),this.messagingSystem.subscribe(`${G}:stateChange`,e=>this.checkPoll(e))}async _executePoll({chainIds:e}){const t=(null!=e?e:[]).filter(e=>A(this,o,"f").includes(e));return 0===t.length?Promise.resolve():this.updateSmartTransactions({chainIds:t})}checkPoll({smartTransactionsState:{smartTransactions:e}}){const t=Object.values(e).flat(),s=null==t?void 0:t.filter(U.isSmartTransactionPending);!this.timeoutHandle&&(null==s?void 0:s.length)>0?this.poll():this.timeoutHandle&&0===(null==s?void 0:s.length)&&this.stop()}initializeSmartTransactionsForChainId(){A(this,o,"f").includes(A(this,i,"f"))&&this.update(e=>{var t;e.smartTransactionsState.smartTransactions[A(this,i,"f")]=null!==(t=e.smartTransactionsState.smartTransactions[A(this,i,"f")])&&void 0!==t?t:[]})}async poll(e){e&&I(this,n,e,"f"),this.timeoutHandle&&clearInterval(this.timeoutHandle),A(this,o,"f").includes(A(this,i,"f"))&&(this.timeoutHandle=setInterval(()=>{(0,O.safelyExecute)(async()=>this.updateSmartTransactions())},A(this,n,"f")),await(0,O.safelyExecute)(async()=>this.updateSmartTransactions()))}async stop(){this.timeoutHandle&&clearInterval(this.timeoutHandle),this.timeoutHandle=undefined}setOptInState(e){this.update(t=>{t.smartTransactionsState.userOptInV2=e})}trackStxStatusChange(e,t){let s=(0,F.default)(e);s=Object.assign(Object.assign({},(0,F.default)(t)),s),s.status!==(null==t?void 0:t.status)&&A(this,m,"f").call(this,{event:L.MetaMetricsEventName.StxStatusUpdated,category:L.MetaMetricsEventCategory.Transactions,properties:(0,U.getSmartTransactionMetricsProperties)(s),sensitiveProperties:(0,U.getSmartTransactionMetricsSensitiveProperties)(s)})}isNewSmartTransaction(e,t){const{smartTransactionsState:{smartTransactions:s}}=this.state,a=s[null!=t?t:A(this,i,"f")],n=null==a?void 0:a.findIndex(t=>t.uuid===e);return-1===n||n===undefined}updateSmartTransaction(e,{networkClientId:t}={}){let s=A(this,l,"f"),n=A(this,i,"f");if(t){const{configuration:e,provider:a}=this.messagingSystem.call("NetworkController:getNetworkClientById",t);n=e.chainId,s=new R.default(a)}A(this,a,"m",v).call(this,e,{chainId:n,ethQuery:s})}async updateSmartTransactions({chainIds:e}={chainIds:A(this,a,"m",P).call(this)}){const{smartTransactionsState:{smartTransactions:t}}=this.state;for(const[s,n]of Object.entries(t)){if(e&&!e.includes(s))continue;const t=n.filter(U.isSmartTransactionPending).map(e=>{const t=A(this,a,"m",_).call(this,{chainId:s});return{uuid:e.uuid,networkClientId:t,chainId:e.chainId}});t.length>0&&await this.fetchSmartTransactionsStatus(t)}}async fetchSmartTransactionsStatus(e){const{chainId:t}=e[0],s=e.map(e=>e.uuid),n=new URLSearchParams({uuids:s.join(",")}),r=A(this,a,"m",M).call(this,{networkClientId:e[0].networkClientId}),i=`${(0,U.getAPIRequestURL)(H.APIType.BATCH_STATUS,t)}?${n.toString()}`,o=await A(this,a,"m",b).call(this,i);for(const[s,n]of Object.entries(o)){const i=e.find(e=>e.uuid===s);if(!i){console.error(`No matching transaction found for uuid: ${s}`);continue}const o={statusMetadata:n,status:(0,U.calculateStatus)(n),cancellable:(0,U.isSmartTransactionCancellable)(n),uuid:s,networkClientId:i.networkClientId};await A(this,a,"m",v).call(this,o,{chainId:t,ethQuery:r})}return o}clearFees(){const e={approvalTxFees:null,tradeTxFees:null};return this.update(t=>{t.smartTransactionsState.fees=e}),e}async getFees(e,t,{networkClientId:s}={}){const n=null!=s?s:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,r=A(this,a,"m",T).call(this,{networkClientId:n}),o=[];let c;if(t){const s=await A(this,a,"m",k).call(this,t,n);o.push(s),c=Object.assign(Object.assign({},e),{nonce:(0,U.incrementNonceInHex)(s.nonce)})}else c=e.nonce?e:await A(this,a,"m",k).call(this,e,n);o.push(c);const l=await A(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.GetFees},async()=>await A(this,a,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.GET_FEES,r),{method:"POST",body:JSON.stringify({txs:o})}));let d,u;return t?(d=null==l?void 0:l.txs[0],u=null==l?void 0:l.txs[1]):(d=null,u=null==l?void 0:l.txs[0]),this.update(e=>{r===A(this,i,"f")&&(e.smartTransactionsState.fees={approvalTxFees:d,tradeTxFees:u}),e.smartTransactionsState.feesByChainId[r]={approvalTxFees:d,tradeTxFees:u}}),{approvalTxFees:d,tradeTxFees:u}}async submitSignedTransactions({transactionMeta:e,txParams:t,signedTransactions:s,signedCanceledTransactions:n=[],networkClientId:r}){var i,o;const l=null!=r?r:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,d=A(this,a,"m",T).call(this,{networkClientId:l}),u=A(this,a,"m",M).call(this,{networkClientId:l}),m=await A(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.SubmitTransactions},async()=>await A(this,a,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.SUBMIT_TRANSACTIONS,d),{method:"POST",body:JSON.stringify({rawTxs:s,rawCancelTxs:n})})),h=Date.now();let p;try{if(null==t?void 0:t.from){const e=await(0,O.query)(u,"getBalance",[t.from]);p=new B.BigNumber(e).toString(16)}}catch(e){console.error("ethQuery.getBalance error:",e)}let f,y,w={};if(t&&!t.nonce)try{y=await A(this,c,"f").call(this,t.from,l),f=(0,j.hexlify)(y.nextNonce),w=y.nonceDetails,null!==(i=t.nonce)&&void 0!==i||(t.nonce=f)}catch(e){throw console.error("Failed to acquire nonce lock:",e),e}const S=s.map(e=>(0,U.getTxHash)(e)),E=Object.assign(Object.assign({},m),{txHash:S[S.length-1],txHashes:S});try{await A(this,a,"m",v).call(this,{chainId:d,nonceDetails:w,preTxBalance:p,status:H.SmartTransactionStatuses.PENDING,time:h,txParams:t,uuid:E.uuid,txHash:E.txHash,cancellable:!0,type:null!==(o=null==e?void 0:e.type)&&void 0!==o?o:"swap",transactionId:null==e?void 0:e.id,networkClientId:l,txHashes:S},{chainId:d,ethQuery:u})}catch(e){throw console.error("Failed to create a smart transaction:",e),e}finally{y&&y.releaseLock()}return E}async cancelSmartTransaction(e,{networkClientId:t}={}){const s=A(this,a,"m",T).call(this,{networkClientId:t});await A(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.CancelTransaction},async()=>await A(this,a,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.CANCEL,s),{method:"POST",body:JSON.stringify({uuid:e})}))}async fetchLiveness({networkClientId:e}={}){const t=A(this,a,"m",T).call(this,{networkClientId:e});let s=!1;try{const e=await A(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.FetchLiveness},async()=>await A(this,a,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.LIVENESS,t)));s=Boolean(e.smartTransactions)}catch(e){console.log('"fetchLiveness" API call failed')}return this.update(e=>{t===A(this,i,"f")&&(e.smartTransactionsState.liveness=s),e.smartTransactionsState.livenessByChainId[t]=s}),s}async setStatusRefreshInterval(e){e!==A(this,n,"f")&&I(this,n,e,"f")}getTransactions({addressFrom:e,status:t}){return A(this,a,"m",x).call(this).filter(s=>{var a;return s.status===t&&(null===(a=s.txParams)||void 0===a?void 0:a.from)===e})}getSmartTransactionByMinedTxHash(e){if(!e)return undefined;return A(this,a,"m",x).call(this).find(t=>{var s,a;return(null===(a=null===(s=t.statusMetadata)||void 0===s?void 0:s.minedHash)||void 0===a?void 0:a.toLowerCase())===e.toLowerCase()})}wipeSmartTransactions({address:e,ignoreNetwork:t}){if(!e)return;const s=e.toLowerCase();if(t){const{smartTransactionsState:{smartTransactions:e}}=this.state;Object.keys(e).forEach(e=>{A(this,a,"m",C).call(this,{chainId:e,addressLowerCase:s})})}else A(this,a,"m",C).call(this,{chainId:A(this,i,"f"),addressLowerCase:s})}}s.default=K,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,u=new WeakMap,m=new WeakMap,h=new WeakMap,p=new WeakMap,f=new WeakMap,g=new WeakMap,a=new WeakSet,b=async function(e,t){const s=Object.assign(Object.assign({},t),{headers:Object.assign({"Content-Type":"application/json"},A(this,r,"f")&&{"X-Client-Id":A(this,r,"f")})});return(0,U.handleFetch)(e,s)},y=function(e,{chainId:t=A(this,i,"f")}){var s;const{smartTransactionsState:{smartTransactions:a}}=this.state,n=null!==(s=a[t])&&void 0!==s?s:[],r=null==n?void 0:n.findIndex(t=>t.uuid===e.uuid);-1!==r&&(0,O.isSafeDynamicKey)(t)&&this.update(s=>{s.smartTransactionsState.smartTransactions[t][r]=Object.assign(Object.assign({},s.smartTransactionsState.smartTransactions[t][r]),e)})},w=async function(e){const t=await A(this,h,"f").call(this);e.accountHardwareType=null==t?void 0:t.accountHardwareType,e.accountType=null==t?void 0:t.accountType,e.deviceModel=null==t?void 0:t.deviceModel},v=async function(e,{chainId:t=A(this,i,"f"),ethQuery:s=A(this,l,"f")}){var n;const{smartTransactionsState:{smartTransactions:o}}=this.state,c=null!==(n=o[t])&&void 0!==n?n:[],d=null==c?void 0:c.findIndex(t=>t.uuid===e.uuid),m=this.isNewSmartTransaction(e.uuid,t);if(s===undefined)throw new Error(q);if(m)try{await A(this,a,"m",w).call(this,e)}catch(e){console.error("Failed to add metrics props to smart transaction:",e)}if(this.trackStxStatusChange(e,m?undefined:c[d]),m){const s=null==c?void 0:c.findIndex(t=>{var s,a,n;return(null===(s=t.txParams)||void 0===s?void 0:s.nonce)===(null===(a=e.txParams)||void 0===a?void 0:a.nonce)&&(null===(n=t.status)||void 0===n?void 0:n.startsWith("cancelled"))}),a=[(0,F.default)(e)],n=Object.assign(Object.assign({},e),{history:a}),r=s>-1?c.slice(0,s).concat(c.slice(s+1)).concat(n):c.concat(n);return void this.update(e=>{e.smartTransactionsState.smartTransactions[t]=r})}const h=c[d],g=Object.assign(Object.assign({},h),e);this.messagingSystem.publish("SmartTransactionsController:smartTransaction",g),(0,U.shouldMarkRegularTransactionAsFailed)({smartTransaction:g,clientId:A(this,r,"f"),getFeatureFlags:A(this,p,"f")})&&(0,U.markRegularTransactionAsFailed)({smartTransaction:g,getRegularTransactions:A(this,u,"f"),updateTransaction:A(this,f,"f")}),e.status!==H.SmartTransactionStatuses.SUCCESS&&e.status!==H.SmartTransactionStatuses.REVERTED||e.confirmed?A(this,a,"m",y).call(this,e,{chainId:t}):await A(this,a,"m",E).call(this,g,{chainId:t,ethQuery:s})},S=function(e){if(!e)return!0;const t=A(this,u,"f").call(this),s=null==t?void 0:t.find(t=>{var s;return(null===(s=t.hash)||void 0===s?void 0:s.toLowerCase())===e.toLowerCase()});return!s||![D.TransactionStatus.confirmed,D.TransactionStatus.submitted].includes(s.status)},E=async function(e,{chainId:t=A(this,i,"f"),ethQuery:s=A(this,l,"f")}){var n;if(s===undefined)throw new Error(q);const r=null===(n=e.statusMetadata)||void 0===n?void 0:n.minedHash;try{const n=await(0,O.query)(s,"getTransactionReceipt",[r]),i=await(0,O.query)(s,"getTransactionByHash",[r]),o=null==i?void 0:i.maxFeePerGas,c=null==i?void 0:i.maxPriorityFeePerGas;if(null==n?void 0:n.blockNumber){const i=await(0,O.query)(s,"getBlockByNumber",[null==n?void 0:n.blockNumber,!1]),l=null==i?void 0:i.baseFeePerGas,u=Object.assign(Object.assign({},e.txParams),{maxFeePerGas:o,maxPriorityFeePerGas:c}),h=Object.assign(Object.assign({},e),{id:e.uuid,status:D.TransactionStatus.confirmed,hash:r,txParams:u}),p=(0,U.snapshotFromTxMeta)(h),f=(0,U.replayHistory)(h.history),g=(0,U.generateHistoryEntry)(f,p,"txStateManager: setting status to confirmed"),b=g.length>0?Object.assign(Object.assign({},h),{history:h.history.concat(g)}):h;A(this,a,"m",S).call(this,r)&&A(this,d,"f").call(this,b,n,l),A(this,m,"f").call(this,{event:L.MetaMetricsEventName.StxConfirmed,category:L.MetaMetricsEventCategory.Transactions,properties:(0,U.getSmartTransactionMetricsProperties)(e),sensitiveProperties:(0,U.getSmartTransactionMetricsSensitiveProperties)(e)}),A(this,a,"m",y).call(this,Object.assign(Object.assign({},e),{confirmed:!0}),{chainId:t})}}catch(e){A(this,m,"f").call(this,{event:L.MetaMetricsEventName.StxConfirmationFailed,category:L.MetaMetricsEventCategory.Transactions}),console.error("confirm error",e)}finally{this.messagingSystem.publish("SmartTransactionsController:smartTransactionConfirmationDone",e)}},k=async function(e,t){const s=await A(this,c,"f").call(this,e.from,t),a=s.nextNonce;return s.releaseLock(),Object.assign(Object.assign({},e),{nonce:`0x${a.toString(16)}`})},T=function({networkClientId:e}={}){return e?this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId:A(this,i,"f")},P=function(){const{networkConfigurationsByChainId:e}=this.messagingSystem.call("NetworkController:getState");return Object.keys(e).filter(e=>A(this,o,"f").includes(e))},_=function({chainId:e}){const{networkConfigurationsByChainId:t}=this.messagingSystem.call("NetworkController:getState");return t[e].rpcEndpoints[t[e].defaultRpcEndpointIndex].networkClientId},M=function({networkClientId:e}={}){if(e){const{provider:t}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);return new R.default(t)}if(A(this,l,"f")===undefined)throw new Error(q);return A(this,l,"f")},x=function(){const{smartTransactionsState:{smartTransactions:e}}=this.state,t=Object.values(e).flat();return t&&0!==t.length?t:[]},C=function({chainId:e,addressLowerCase:t}){const{smartTransactionsState:{smartTransactions:s}}=this.state,a=null==s?void 0:s[e];if(!a||0===a.length)return;const n=a.filter(e=>{var s;return(null===(s=e.txParams)||void 0===s?void 0:s.from)!==t});this.update(t=>{t.smartTransactionsState.smartTransactions[e]=n})}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js"}],[2464,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.SmartTransactionsTraceName=s.MetaMetricsEventCategory=s.MetaMetricsEventName=s.SENTINEL_API_BASE_URL_MAP=s.API_BASE_URL=void 0,s.API_BASE_URL="https://transaction.api.cx.metamask.io",s.SENTINEL_API_BASE_URL_MAP={1:"https://tx-sentinel-ethereum-mainnet.api.cx.metamask.io",56:"https://tx-sentinel-bsc-mainnet.api.cx.metamask.io",8453:"https://tx-sentinel-base-mainnet.api.cx.metamask.io",42161:"https://tx-sentinel-arbitrum-mainnet.api.cx.metamask.io",59144:"https://tx-sentinel-linea-mainnet.api.cx.metamask.io",11155111:"https://tx-sentinel-ethereum-sepolia.api.cx.metamask.io"},function(e){e.StxStatusUpdated="STX Status Updated",e.StxConfirmed="STX Confirmed",e.StxConfirmationFailed="STX Confirmation Failed",e.ReceiveRequest="Receive Request"}(s.MetaMetricsEventName||(s.MetaMetricsEventName={})),function(e){e.Transactions="Transactions",e.Navigation="Navigation"}(s.MetaMetricsEventCategory||(s.MetaMetricsEventCategory={})),function(e){e.GetFees="Smart Transactions: Get Fees",e.SubmitTransactions="Smart Transactions: Submit Transactions",e.CancelTransaction="Smart Transactions: Cancel Transaction",e.FetchLiveness="Smart Transactions: Fetch Liveness"}(s.SmartTransactionsTraceName||(s.SmartTransactionsTraceName={}))}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/constants.js"}],[2465,{"./SmartTransactionsController":2463},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var n=e("./SmartTransactionsController");Object.defineProperty(s,"default",{enumerable:!0,get:function(){return a(n).default}})}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/index.js"}],[2467,{"../package.json":2477,"./constants":2464,"./types":2466,"@ethersproject/bytes":686,"@ethersproject/keccak256":712,"@ethersproject/transactions":763,"@metamask/transaction-controller":2789,"bignumber.js":2476,"fast-json-patch":4133,lodash:4560},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.markRegularTransactionAsFailed=s.shouldMarkRegularTransactionAsFailed=s.getReturnTxHashAsap=s.getSmartTransactionMetricsSensitiveProperties=s.getSmartTransactionMetricsProperties=s.getTxHash=s.incrementNonceInHex=s.isSmartTransactionCancellable=s.handleFetch=s.mapKeysToCamel=s.getStxProcessingTime=s.snapshotFromTxMeta=s.replayHistory=s.generateHistoryEntry=s.calculateStatus=s.getAPIRequestURL=s.isSmartTransactionStatusResolved=s.isSmartTransactionPending=void 0;const n=e("@ethersproject/bytes"),r=e("@ethersproject/keccak256"),i=e("@ethersproject/transactions"),o=e("@metamask/transaction-controller"),c=e("bignumber.js"),l=a(e("fast-json-patch")),d=a(e("lodash")),u=a(e("../package.json")),m=e("./constants"),h=e("./types");s.isSmartTransactionPending=function(e){return e.status===h.SmartTransactionStatuses.PENDING};s.isSmartTransactionStatusResolved=e=>"uuid_not_found"===e,s.getAPIRequestURL=function(e,t){const s=parseInt(t,16);switch(e){case h.APIType.GET_FEES:return`${m.API_BASE_URL}/networks/${s}/getFees`;case h.APIType.ESTIMATE_GAS:return`${m.API_BASE_URL}/networks/${s}/estimateGas`;case h.APIType.SUBMIT_TRANSACTIONS:return`${m.API_BASE_URL}/networks/${s}/submitTransactions?stxControllerVersion=${u.default.version}`;case h.APIType.CANCEL:return`${m.API_BASE_URL}/networks/${s}/cancel`;case h.APIType.BATCH_STATUS:return`${m.API_BASE_URL}/networks/${s}/batchStatus`;case h.APIType.LIVENESS:return`${m.SENTINEL_API_BASE_URL_MAP[s]}/network`;default:throw new Error("Invalid APIType")}};s.calculateStatus=e=>{if((0,s.isSmartTransactionStatusResolved)(e))return h.SmartTransactionStatuses.RESOLVED;const t=[h.SmartTransactionCancellationReason.WOULD_REVERT,h.SmartTransactionCancellationReason.TOO_CHEAP,h.SmartTransactionCancellationReason.DEADLINE_MISSED,h.SmartTransactionCancellationReason.INVALID_NONCE,h.SmartTransactionCancellationReason.USER_CANCELLED];if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.NOT_MINED){if(e.cancellationReason===h.SmartTransactionCancellationReason.NOT_CANCELLED)return h.SmartTransactionStatuses.PENDING;const s=t.findIndex(t=>t===e.cancellationReason)>-1;if(e.cancellationReason&&s)return e.isSettled?h.cancellationReasonToStatusMap[e.cancellationReason]:h.SmartTransactionStatuses.PENDING}else{if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.SUCCESS)return h.SmartTransactionStatuses.SUCCESS;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.CANCELLED)return h.SmartTransactionStatuses.CANCELLED;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.REVERTED)return h.SmartTransactionStatuses.REVERTED;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.UNKNOWN)return h.SmartTransactionStatuses.UNKNOWN}return h.SmartTransactionStatuses.UNKNOWN},s.generateHistoryEntry=function(e,t,s){const a=l.default.compare(e,t);return a[0]&&(s&&(a[0].note=s),a[0].timestamp=Date.now()),a},s.replayHistory=function(e){return d.default.cloneDeep(e).reduce((e,t)=>l.default.applyPatch(e,t).newDocument)},s.snapshotFromTxMeta=function(e){const t=Object.assign({},e);return delete t.history,d.default.cloneDeep(t)};s.getStxProcessingTime=e=>e?Math.round((Date.now()-e)/1e3):undefined;s.mapKeysToCamel=e=>{if(!d.default.isObject(e))return e;const t=d.default.mapValues(e,e=>d.default.isArray(e)?e.map(s.mapKeysToCamel):d.default.isObject(e)?(0,s.mapKeysToCamel)(e):e);return d.default.mapKeys(t,(e,t)=>d.default.camelCase(t))},s.handleFetch=async function(e,t){const a=await fetch(e,t),n=await a.json();if(!a.ok)throw console.log("response",a),new Error(`Fetch error:${JSON.stringify(Object.assign({status:a.status},(0,s.mapKeysToCamel)(n)))}`);return n};s.isSmartTransactionCancellable=e=>e.minedTx===h.SmartTransactionMinedTx.NOT_MINED&&(!e.cancellationReason||e.cancellationReason===h.SmartTransactionCancellationReason.NOT_CANCELLED);s.incrementNonceInHex=e=>{const t=new c.BigNumber(e,16).toString(10);return(0,n.hexlify)(Number(t)+1)};s.getTxHash=e=>{var t;if(!e)return"";try{const s=(0,i.parse)(e);return null!==(t=null==s?void 0:s.hash)&&void 0!==t?t:""}catch(t){if((e=>"string"==typeof e&&e.startsWith("0x04"))(e))return(0,n.hexlify)((0,r.keccak256)((0,n.arrayify)(e)));throw t}};s.getSmartTransactionMetricsProperties=e=>{if(!e)return{};const t=e.statusMetadata;return{stx_status:e.status,type:e.type,processing_time:(0,s.getStxProcessingTime)(e.time),is_smart_transaction:!0,stx_enabled:!0,current_stx_enabled:!0,stx_user_opt_in:!0,stx_duplicated:null==t?void 0:t.duplicated,stx_timed_out:null==t?void 0:t.timedOut,stx_proxied:null==t?void 0:t.proxied}};s.getSmartTransactionMetricsSensitiveProperties=e=>e?{token_from_symbol:e.sourceTokenSymbol,token_to_symbol:e.destinationTokenSymbol,account_hardware_type:e.accountHardwareType,account_type:e.accountType,device_model:e.deviceModel}:{};s.getReturnTxHashAsap=(e,t)=>e===h.ClientId.Extension?null==t?void 0:t.extensionReturnTxHashAsap:null==t?void 0:t.mobileReturnTxHashAsap;s.shouldMarkRegularTransactionAsFailed=({smartTransaction:e,clientId:t,getFeatureFlags:a})=>{var n;const{status:r,transactionId:i}=e,o=[h.SmartTransactionStatuses.CANCELLED,h.SmartTransactionStatuses.CANCELLED_USER_CANCELLED,h.SmartTransactionStatuses.UNKNOWN,h.SmartTransactionStatuses.RESOLVED];if(!r||!o.includes(r))return!1;const{smartTransactions:c}=null!==(n=a())&&void 0!==n?n:{},l=(0,s.getReturnTxHashAsap)(t,c);return Boolean(l&&i)};s.markRegularTransactionAsFailed=({smartTransaction:e,getRegularTransactions:t,updateTransaction:s})=>{const{transactionId:a,status:n}=e,r=t().find(e=>e.id===a);if(!r)throw new Error("Cannot find regular transaction to mark it as failed");if(r.status===o.TransactionStatus.failed)return;s(Object.assign(Object.assign({},r),{status:o.TransactionStatus.failed,error:{name:"SmartTransactionFailed",message:`Smart transaction failed with status: ${n}`}}),`Smart transaction status: ${n}`)}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/utils.js"}],[2468,{"fast-json-stable-stringify":4134,uuid:5392},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)},n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.AbstractPollingControllerBaseMixin=s.getKey=void 0;const r=n(e("fast-json-stable-stringify")),i=e("uuid");s.getKey=e=>(0,r.default)(e),s.AbstractPollingControllerBaseMixin=function(e){var t,n;return t=new WeakMap,n=new WeakMap,class extends e{constructor(){super(...arguments),t.set(this,new Map),n.set(this,new Map)}startPolling(e){const n=(0,i.v4)(),r=(0,s.getKey)(e),o=a(this,t,"f").get(r)??new Set;return o.add(n),a(this,t,"f").set(r,o),1===o.size&&this._startPolling(e),n}stopAllPolling(){a(this,t,"f").forEach((e,t)=>{e.forEach(e=>{this.stopPollingByPollingToken(e)})})}stopPollingByPollingToken(e){if(!e)throw new Error("pollingToken required");let s=null;for(const[n,r]of a(this,t,"f"))if(r.delete(e)){0===r.size&&(s=n);break}if(s){this._stopPollingByPollingTokenSetId(s),a(this,t,"f").delete(s);const e=a(this,n,"f").get(s);if(e){for(const t of e)t(JSON.parse(s));e.clear()}}}onPollingComplete(e,t){const r=(0,s.getKey)(e),i=a(this,n,"f").get(r)??new Set;i.add(t),a(this,n,"f").set(r,i)}}}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs"}],[2469,{"./AbstractPollingController.cjs":2468,"@metamask/base-controller":2475},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.BlockTrackerPollingController=s.BlockTrackerPollingControllerOnly=void 0;const n=e("@metamask/base-controller"),r=e("./AbstractPollingController.cjs");function i(e){var t;class s extends((0,r.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{})}_startPolling(e){const s=(0,r.getKey)(e);if(a(this,t,"f")[s])return;const n=this._getNetworkClientById(e.networkClientId);if(!n)throw new Error(`Unable to retrieve blockTracker for networkClientId ${e.networkClientId}`);{const r=this._executePoll.bind(this,e);n.blockTracker.addListener("latest",r),a(this,t,"f")[s]=r}}_stopPollingByPollingTokenSetId(e){const{networkClientId:s}=JSON.parse(e),n=this._getNetworkClientById(s);if(n&&a(this,t,"f")[e]){const s=a(this,t,"f")[e];s&&(n.blockTracker.removeListener("latest",s),delete a(this,t,"f")[e])}}}return t=new WeakMap,s}class o{}s.BlockTrackerPollingControllerOnly=()=>i(o);s.BlockTrackerPollingController=()=>i(n.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs"}],[247,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;s.default=[{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"resolver",outputs:[{name:"",type:"address"}],payable:!1,type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"owner",outputs:[{name:"",type:"address"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"label",type:"bytes32"},{name:"owner",type:"address"}],name:"setSubnodeOwner",outputs:[],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"ttl",type:"uint64"}],name:"setTTL",outputs:[],payable:!1,type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"ttl",outputs:[{name:"",type:"uint64"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"resolver",type:"address"}],name:"setResolver",outputs:[],payable:!1,type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"owner",type:"address"}],name:"setOwner",outputs:[],payable:!1,type:"function"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"owner",type:"address"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!0,name:"label",type:"bytes32"},{indexed:!1,name:"owner",type:"address"}],name:"NewOwner",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"resolver",type:"address"}],name:"NewResolver",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"ttl",type:"uint64"}],name:"NewTTL",type:"event"}]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/contracts/registry.js"}],[2470,{"./AbstractPollingController.cjs":2468,"@metamask/base-controller":2475},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},n=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.StaticIntervalPollingController=s.StaticIntervalPollingControllerOnly=void 0;const r=e("@metamask/base-controller"),i=e("./AbstractPollingController.cjs");function o(e){var t,s;class r extends((0,i.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{}),s.set(this,1e3)}setIntervalLength(e){a(this,s,e,"f")}getIntervalLength(){return n(this,s,"f")}_startPolling(e){if(!n(this,s,"f"))throw new Error("intervalLength must be defined and greater than 0");const a=(0,i.getKey)(e),r=n(this,t,"f")[a];this._stopPollingByPollingTokenSetId(a);const o=n(this,t,"f")[a]=setTimeout(async()=>{try{await this._executePoll(e)}catch(e){console.error(e)}o===n(this,t,"f")[a]&&this._startPolling(e)},r?n(this,s,"f"):0)}_stopPollingByPollingTokenSetId(e){const s=n(this,t,"f")[e];s&&(clearTimeout(s),delete n(this,t,"f")[e])}}return t=new WeakMap,s=new WeakMap,r}class c{}s.StaticIntervalPollingControllerOnly=()=>o(c);s.StaticIntervalPollingController=()=>o(r.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs"}],[2471,{"./BlockTrackerPollingController.cjs":2469,"./StaticIntervalPollingController.cjs":2470},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.StaticIntervalPollingController=s.StaticIntervalPollingControllerOnly=s.BlockTrackerPollingController=s.BlockTrackerPollingControllerOnly=void 0;var a=e("./BlockTrackerPollingController.cjs");Object.defineProperty(s,"BlockTrackerPollingControllerOnly",{enumerable:!0,get:function(){return a.BlockTrackerPollingControllerOnly}}),Object.defineProperty(s,"BlockTrackerPollingController",{enumerable:!0,get:function(){return a.BlockTrackerPollingController}});var n=e("./StaticIntervalPollingController.cjs");Object.defineProperty(s,"StaticIntervalPollingControllerOnly",{enumerable:!0,get:function(){return n.StaticIntervalPollingControllerOnly}}),Object.defineProperty(s,"StaticIntervalPollingController",{enumerable:!0,get:function(){return n.StaticIntervalPollingController}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs"}],[2472,{immer:4353},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},r=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.deriveStateFromMetadata=s.getPersistentState=s.getAnonymizedState=s.BaseController=s.isBaseController=void 0;const i=e("immer");(0,i.enablePatches)(),s.isBaseController=function(e){return"object"==typeof e&&null!==e&&"name"in e&&"string"==typeof e.name&&"state"in e&&"object"==typeof e.state&&"metadata"in e&&"object"==typeof e.metadata};function o(e,t,s,a){return Object.keys(e).reduce((n,r)=>{try{const a=t[r];if(!a)throw new Error(`No metadata found for '${String(r)}'`);const i=a[s],o=e[r];return"function"==typeof i?n[r]=i(o):i&&(n[r]=o),n}catch(e){if(a)try{a(e instanceof Error?e:new Error(String(e)))}catch(t){console.error(new Error("Error thrown when calling 'captureException'"),t),console.error(e)}else console.error(e);return n}},{})}s.BaseController=class{constructor({messenger:e,metadata:t,name:s,state:r}){a.set(this,void 0),this.messagingSystem=e,this.name=s,n(this,a,(0,i.freeze)(r,!0),"f"),this.metadata=t,this.messagingSystem.registerActionHandler(`${s}:getState`,()=>this.state),this.messagingSystem.registerInitialEventPayload({eventType:`${s}:stateChange`,getPayload:()=>[this.state,[]]})}get state(){return r(this,a,"f")}set state(e){throw new Error("Controller state cannot be directly mutated; use 'update' method instead.")}update(e){const[t,s,o]=i.produceWithPatches(r(this,a,"f"),e);return s.length>0&&(n(this,a,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,s)),{nextState:t,patches:s,inversePatches:o}}applyPatches(e){const t=(0,i.applyPatches)(r(this,a,"f"),e);n(this,a,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,e)}destroy(){this.messagingSystem.clearEventSubscriptions(`${this.name}:stateChange`)}},a=new WeakMap,s.getAnonymizedState=function(e,t,s){return o(e,t,"anonymous",s)},s.getPersistentState=function(e,t,s){return o(e,t,"persist",s)},s.deriveStateFromMetadata=o}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseController.cjs"}],[2473,{"./RestrictedMessenger.cjs":2474},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.Messenger=void 0;const c=e("./RestrictedMessenger.cjs");s.Messenger=class{constructor(){a.set(this,new Map),n.set(this,new Map),r.set(this,new Map),i.set(this,new Map)}registerActionHandler(e,t){if(o(this,a,"f").has(e))throw new Error(`A handler for ${e} has already been registered`);o(this,a,"f").set(e,t)}registerMethodActionHandlers(e,t){for(const s of t){const t=e[s];if("function"==typeof t){const a=`${e.name}:${s}`;this.registerActionHandler(a,t.bind(e))}}}unregisterActionHandler(e){o(this,a,"f").delete(e)}clearActions(){o(this,a,"f").clear()}call(e,...t){const s=o(this,a,"f").get(e);if(!s)throw new Error(`A handler for ${e} has not been registered`);return s(...t)}registerInitialEventPayload({eventType:e,getPayload:t}){o(this,r,"f").set(e,t)}publish(e,...t){const s=o(this,n,"f").get(e);if(s)for(const[e,a]of s.entries())try{if(a){const s=o(this,i,"f").get(e),n=a(...t);n!==s&&(o(this,i,"f").set(e,n),e(n,s))}else e(...t)}catch(e){setTimeout(()=>{throw e})}}subscribe(e,t,s){let a=o(this,n,"f").get(e);a||(a=new Map,o(this,n,"f").set(e,a));const c=t;if(a.set(c,s),s){const t=o(this,r,"f").get(e);if(t){const e=s(...t());o(this,i,"f").set(c,e)}}}unsubscribe(e,t){const s=o(this,n,"f").get(e),a=t;if(!s||!s.has(a))throw new Error(`Subscription not found for event: ${e}`);s.get(a)&&o(this,i,"f").delete(a),s.delete(a)}clearEventSubscriptions(e){o(this,n,"f").delete(e)}clearSubscriptions(){o(this,n,"f").clear()}getRestricted({name:e,allowedActions:t,allowedEvents:s}){return new c.RestrictedMessenger({messenger:this,name:e,allowedActions:t,allowedEvents:s})}},a=new WeakMap,n=new WeakMap,r=new WeakMap,i=new WeakMap}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs"}],[2474,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a,n,r,i,o,c,l,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,a,n){if("m"===a)throw new TypeError("Private method is not writable");if("a"===a&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===a?n.call(e,s):n?n.value=s:t.set(e,s),s},m=this&&this.__classPrivateFieldGet||function(e,t,s,a){if("a"===s&&!a)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?a:"a"===s?a.call(e):a?a.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedMessenger=void 0;s.RestrictedMessenger=class{constructor({messenger:e,name:t,allowedActions:s,allowedEvents:c}){if(a.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),!e)throw new Error("Messenger not provided");u(this,n,e,"f"),u(this,r,t,"f"),u(this,i,s,"f"),u(this,o,c,"f")}registerActionHandler(e,t){if(!m(this,a,"m",d).call(this,e))throw new Error(`Only allowed registering action handlers prefixed by '${m(this,r,"f")}:'`);m(this,n,"f").registerActionHandler(e,t)}registerMethodActionHandlers(e,t){m(this,n,"f").registerMethodActionHandlers(e,t)}unregisterActionHandler(e){if(!m(this,a,"m",d).call(this,e))throw new Error(`Only allowed unregistering action handlers prefixed by '${m(this,r,"f")}:'`);m(this,n,"f").unregisterActionHandler(e)}call(e,...t){if(!m(this,a,"m",l).call(this,e))throw new Error(`Action missing from allow list: ${e}`);return m(this,n,"f").call(e,...t)}registerInitialEventPayload({eventType:e,getPayload:t}){if(!m(this,a,"m",d).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${m(this,r,"f")}:'`);m(this,n,"f").registerInitialEventPayload({eventType:e,getPayload:t})}publish(e,...t){if(!m(this,a,"m",d).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${m(this,r,"f")}:'`);m(this,n,"f").publish(e,...t)}subscribe(e,t,s){if(!m(this,a,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);return s?m(this,n,"f").subscribe(e,t,s):m(this,n,"f").subscribe(e,t)}unsubscribe(e,t){if(!m(this,a,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);m(this,n,"f").unsubscribe(e,t)}clearEventSubscriptions(e){if(!m(this,a,"m",d).call(this,e))throw new Error(`Only allowed clearing events prefixed by '${m(this,r,"f")}:'`);m(this,n,"f").clearEventSubscriptions(e)}},n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,a=new WeakSet,c=function(e){const t=m(this,o,"f");return m(this,a,"m",d).call(this,e)||null!==t&&t.includes(e)},l=function(e){const t=m(this,i,"f");return m(this,a,"m",d).call(this,e)||null!==t&&t.includes(e)},d=function(e){return e.startsWith(`${m(this,r,"f")}:`)}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"}],[2475,{"./BaseController.cjs":2472,"./Messenger.cjs":2473,"./RestrictedMessenger.cjs":2474},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedMessenger=s.Messenger=s.isBaseController=s.getPersistentState=s.getAnonymizedState=s.deriveStateFromMetadata=s.BaseController=void 0;var a=e("./BaseController.cjs");Object.defineProperty(s,"BaseController",{enumerable:!0,get:function(){return a.BaseController}}),Object.defineProperty(s,"deriveStateFromMetadata",{enumerable:!0,get:function(){return a.deriveStateFromMetadata}}),Object.defineProperty(s,"getAnonymizedState",{enumerable:!0,get:function(){return a.getAnonymizedState}}),Object.defineProperty(s,"getPersistentState",{enumerable:!0,get:function(){return a.getPersistentState}}),Object.defineProperty(s,"isBaseController",{enumerable:!0,get:function(){return a.isBaseController}});var n=e("./Messenger.cjs");Object.defineProperty(s,"Messenger",{enumerable:!0,get:function(){return n.Messenger}});var r=e("./RestrictedMessenger.cjs");Object.defineProperty(s,"RestrictedMessenger",{enumerable:!0,get:function(){return r.RestrictedMessenger}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"}],[2476,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){!function(e){var s,a=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,n=Math.ceil,r=Math.floor,i="[BigNumber Error] ",o=i+"Number primitive has more than 15 significant digits: ",c=1e14,l=14,d=9007199254740991,u=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],m=1e7,h=1e9;function p(e){var t=0|e;return e>0||e===t?t:t-1}function f(e){for(var t,s,a=1,n=e.length,r=e[0]+"";a<n;){for(t=e[a++]+"",s=l-t.length;s--;t="0"+t);r+=t}for(n=r.length;48===r.charCodeAt(--n););return r.slice(0,n+1||1)}function g(e,t){var s,a,n=e.c,r=t.c,i=e.s,o=t.s,c=e.e,l=t.e;if(!i||!o)return null;if(s=n&&!n[0],a=r&&!r[0],s||a)return s?a?0:-o:i;if(i!=o)return i;if(s=i<0,a=c==l,!n||!r)return a?0:!n^s?1:-1;if(!a)return c>l^s?1:-1;for(o=(c=n.length)<(l=r.length)?c:l,i=0;i<o;i++)if(n[i]!=r[i])return n[i]>r[i]^s?1:-1;return c==l?0:c>l^s?1:-1}function b(e,t,s,a){if(e<t||e>s||e!==r(e))throw Error(i+(a||"Argument")+("number"==typeof e?e<t||e>s?" out of range: ":" not an integer: ":" not a primitive number: ")+String(e))}function y(e){var t=e.c.length-1;return p(e.e/l)==t&&e.c[t]%2!=0}function w(e,t){return(e.length>1?e.charAt(0)+"."+e.slice(1):e)+(t<0?"e":"e+")+t}function v(e,t,s){var a,n;if(t<0){for(n=s+".";++t;n+=s);e=n+e}else if(++t>(a=e.length)){for(n=s,t-=a;--t;n+=s);e+=n}else t<a&&(e=e.slice(0,t)+"."+e.slice(t));return e}s=function e(t){var s,S,E,k,T,P,_,M,x,C,I=G.prototype={constructor:G,toString:null,valueOf:null},A=new G(1),N=20,j=4,O=-7,R=21,$=-1e7,D=1e7,B=!1,F=1,L=0,H={prefix:"",groupSize:3,secondaryGroupSize:0,groupSeparator:",",decimalSeparator:".",fractionGroupSize:0,fractionGroupSeparator:" ",suffix:""},U="0123456789abcdefghijklmnopqrstuvwxyz",q=!0;function G(e,t){var s,n,i,c,u,m,h,p,f=this;if(!(f instanceof G))return new G(e,t);if(null==t){if(e&&!0===e._isBigNumber)return f.s=e.s,void(!e.c||e.e>D?f.c=f.e=null:e.e<$?f.c=[f.e=0]:(f.e=e.e,f.c=e.c.slice()));if((m="number"==typeof e)&&0*e==0){if(f.s=1/e<0?(e=-e,-1):1,e===~~e){for(c=0,u=e;u>=10;u/=10,c++);return void(c>D?f.c=f.e=null:(f.e=c,f.c=[e]))}p=String(e)}else{if(!a.test(p=String(e)))return E(f,p,m);f.s=45==p.charCodeAt(0)?(p=p.slice(1),-1):1}(c=p.indexOf("."))>-1&&(p=p.replace(".","")),(u=p.search(/e/i))>0?(c<0&&(c=u),c+=+p.slice(u+1),p=p.substring(0,u)):c<0&&(c=p.length)}else{if(b(t,2,U.length,"Base"),10==t&&q)return Y(f=new G(e),N+f.e+1,j);if(p=String(e),m="number"==typeof e){if(0*e!=0)return E(f,p,m,t);if(f.s=1/e<0?(p=p.slice(1),-1):1,G.DEBUG&&p.replace(/^0\.0*|\./,"").length>15)throw Error(o+e)}else f.s=45===p.charCodeAt(0)?(p=p.slice(1),-1):1;for(s=U.slice(0,t),c=u=0,h=p.length;u<h;u++)if(s.indexOf(n=p.charAt(u))<0){if("."==n){if(u>c){c=h;continue}}else if(!i&&(p==p.toUpperCase()&&(p=p.toLowerCase())||p==p.toLowerCase()&&(p=p.toUpperCase()))){i=!0,u=-1,c=0;continue}return E(f,String(e),m,t)}m=!1,(c=(p=S(p,t,10,f.s)).indexOf("."))>-1?p=p.replace(".",""):c=p.length}for(u=0;48===p.charCodeAt(u);u++);for(h=p.length;48===p.charCodeAt(--h););if(p=p.slice(u,++h)){if(h-=u,m&&G.DEBUG&&h>15&&(e>d||e!==r(e)))throw Error(o+f.s*e);if((c=c-u-1)>D)f.c=f.e=null;else if(c<$)f.c=[f.e=0];else{if(f.e=c,f.c=[],u=(c+1)%l,c<0&&(u+=l),u<h){for(u&&f.c.push(+p.slice(0,u)),h-=l;u<h;)f.c.push(+p.slice(u,u+=l));u=l-(p=p.slice(u)).length}else u-=h;for(;u--;p+="0");f.c.push(+p)}}else f.c=[f.e=0]}function W(e,t,s,a){var n,r,i,o,c;if(null==s?s=j:b(s,0,8),!e.c)return e.toString();if(n=e.c[0],i=e.e,null==t)c=f(e.c),c=1==a||2==a&&(i<=O||i>=R)?w(c,i):v(c,i,"0");else if(r=(e=Y(new G(e),t,s)).e,o=(c=f(e.c)).length,1==a||2==a&&(t<=r||r<=O)){for(;o<t;c+="0",o++);c=w(c,r)}else if(t-=i,c=v(c,r,"0"),r+1>o){if(--t>0)for(c+=".";t--;c+="0");}else if((t+=r-o)>0)for(r+1==o&&(c+=".");t--;c+="0");return e.s<0&&n?"-"+c:c}function V(e,t){for(var s,a,n=1,r=new G(e[0]);n<e.length;n++)(!(a=new G(e[n])).s||(s=g(r,a))===t||0===s&&r.s===t)&&(r=a);return r}function K(e,t,s){for(var a=1,n=t.length;!t[--n];t.pop());for(n=t[0];n>=10;n/=10,a++);return(s=a+s*l-1)>D?e.c=e.e=null:s<$?e.c=[e.e=0]:(e.e=s,e.c=t),e}function Y(e,t,s,a){var i,o,d,m,h,p,f,g=e.c,b=u;if(g){e:{for(i=1,m=g[0];m>=10;m/=10,i++);if((o=t-i)<0)o+=l,d=t,h=g[p=0],f=r(h/b[i-d-1]%10);else if((p=n((o+1)/l))>=g.length){if(!a)break e;for(;g.length<=p;g.push(0));h=f=0,i=1,d=(o%=l)-l+1}else{for(h=m=g[p],i=1;m>=10;m/=10,i++);f=(d=(o%=l)-l+i)<0?0:r(h/b[i-d-1]%10)}if(a=a||t<0||null!=g[p+1]||(d<0?h:h%b[i-d-1]),a=s<4?(f||a)&&(0==s||s==(e.s<0?3:2)):f>5||5==f&&(4==s||a||6==s&&(o>0?d>0?h/b[i-d]:0:g[p-1])%10&1||s==(e.s<0?8:7)),t<1||!g[0])return g.length=0,a?(t-=e.e+1,g[0]=b[(l-t%l)%l],e.e=-t||0):g[0]=e.e=0,e;if(0==o?(g.length=p,m=1,p--):(g.length=p+1,m=b[l-o],g[p]=d>0?r(h/b[i-d]%b[d])*m:0),a)for(;;){if(0==p){for(o=1,d=g[0];d>=10;d/=10,o++);for(d=g[0]+=m,m=1;d>=10;d/=10,m++);o!=m&&(e.e++,g[0]==c&&(g[0]=1));break}if(g[p]+=m,g[p]!=c)break;g[p--]=0,m=1}for(o=g.length;0===g[--o];g.pop());}e.e>D?e.c=e.e=null:e.e<$&&(e.c=[e.e=0])}return e}function J(e){var t,s=e.e;return null===s?e.toString():(t=f(e.c),t=s<=O||s>=R?w(t,s):v(t,s,"0"),e.s<0?"-"+t:t)}return G.clone=e,G.ROUND_UP=0,G.ROUND_DOWN=1,G.ROUND_CEIL=2,G.ROUND_FLOOR=3,G.ROUND_HALF_UP=4,G.ROUND_HALF_DOWN=5,G.ROUND_HALF_EVEN=6,G.ROUND_HALF_CEIL=7,G.ROUND_HALF_FLOOR=8,G.EUCLID=9,G.config=G.set=function(e){var t,s;if(null!=e){if("object"!=typeof e)throw Error(i+"Object expected: "+e);if(e.hasOwnProperty(t="DECIMAL_PLACES")&&(b(s=e[t],0,h,t),N=s),e.hasOwnProperty(t="ROUNDING_MODE")&&(b(s=e[t],0,8,t),j=s),e.hasOwnProperty(t="EXPONENTIAL_AT")&&((s=e[t])&&s.pop?(b(s[0],-h,0,t),b(s[1],0,h,t),O=s[0],R=s[1]):(b(s,-h,h,t),O=-(R=s<0?-s:s))),e.hasOwnProperty(t="RANGE"))if((s=e[t])&&s.pop)b(s[0],-h,-1,t),b(s[1],1,h,t),$=s[0],D=s[1];else{if(b(s,-h,h,t),!s)throw Error(i+t+" cannot be zero: "+s);$=-(D=s<0?-s:s)}if(e.hasOwnProperty(t="CRYPTO")){if((s=e[t])!==!!s)throw Error(i+t+" not true or false: "+s);if(s){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw B=!s,Error(i+"crypto unavailable");B=s}else B=s}if(e.hasOwnProperty(t="MODULO_MODE")&&(b(s=e[t],0,9,t),F=s),e.hasOwnProperty(t="POW_PRECISION")&&(b(s=e[t],0,h,t),L=s),e.hasOwnProperty(t="FORMAT")){if("object"!=typeof(s=e[t]))throw Error(i+t+" not an object: "+s);H=s}if(e.hasOwnProperty(t="ALPHABET")){if("string"!=typeof(s=e[t])||/^.?$|[+\-.\s]|(.).*\1/.test(s))throw Error(i+t+" invalid: "+s);q="0123456789"==s.slice(0,10),U=s}}return{DECIMAL_PLACES:N,ROUNDING_MODE:j,EXPONENTIAL_AT:[O,R],RANGE:[$,D],CRYPTO:B,MODULO_MODE:F,POW_PRECISION:L,FORMAT:H,ALPHABET:U}},G.isBigNumber=function(e){if(!e||!0!==e._isBigNumber)return!1;if(!G.DEBUG)return!0;var t,s,a=e.c,n=e.e,o=e.s;e:if("[object Array]"=={}.toString.call(a)){if((1===o||-1===o)&&n>=-h&&n<=h&&n===r(n)){if(0===a[0]){if(0===n&&1===a.length)return!0;break e}if((t=(n+1)%l)<1&&(t+=l),String(a[0]).length==t){for(t=0;t<a.length;t++)if((s=a[t])<0||s>=c||s!==r(s))break e;if(0!==s)return!0}}}else if(null===a&&null===n&&(null===o||1===o||-1===o))return!0;throw Error(i+"Invalid BigNumber: "+e)},G.maximum=G.max=function(){return V(arguments,-1)},G.minimum=G.min=function(){return V(arguments,1)},G.random=(k=9007199254740992,T=Math.random()*k&2097151?function(){return r(Math.random()*k)}:function(){return 8388608*(1073741824*Math.random()|0)+(8388608*Math.random()|0)},function(e){var t,s,a,o,c,d=0,m=[],p=new G(A);if(null==e?e=N:b(e,0,h),o=n(e/l),B)if(crypto.getRandomValues){for(t=crypto.getRandomValues(new Uint32Array(o*=2));d<o;)(c=131072*t[d]+(t[d+1]>>>11))>=9e15?(s=crypto.getRandomValues(new Uint32Array(2)),t[d]=s[0],t[d+1]=s[1]):(m.push(c%1e14),d+=2);d=o/2}else{if(!crypto.randomBytes)throw B=!1,Error(i+"crypto unavailable");for(t=crypto.randomBytes(o*=7);d<o;)(c=281474976710656*(31&t[d])+1099511627776*t[d+1]+4294967296*t[d+2]+16777216*t[d+3]+(t[d+4]<<16)+(t[d+5]<<8)+t[d+6])>=9e15?crypto.randomBytes(7).copy(t,d):(m.push(c%1e14),d+=7);d=o/7}if(!B)for(;d<o;)(c=T())<9e15&&(m[d++]=c%1e14);for(o=m[--d],e%=l,o&&e&&(c=u[l-e],m[d]=r(o/c)*c);0===m[d];m.pop(),d--);if(d<0)m=[a=0];else{for(a=-1;0===m[0];m.splice(0,1),a-=l);for(d=1,c=m[0];c>=10;c/=10,d++);d<l&&(a-=l-d)}return p.e=a,p.c=m,p}),G.sum=function(){for(var e=1,t=arguments,s=new G(t[0]);e<t.length;)s=s.plus(t[e++]);return s},S=function(){var e="0123456789";function t(e,t,s,a){for(var n,r,i=[0],o=0,c=e.length;o<c;){for(r=i.length;r--;i[r]*=t);for(i[0]+=a.indexOf(e.charAt(o++)),n=0;n<i.length;n++)i[n]>s-1&&(null==i[n+1]&&(i[n+1]=0),i[n+1]+=i[n]/s|0,i[n]%=s)}return i.reverse()}return function(a,n,r,i,o){var c,l,d,u,m,h,p,g,b=a.indexOf("."),y=N,w=j;for(b>=0&&(u=L,L=0,a=a.replace(".",""),h=(g=new G(n)).pow(a.length-b),L=u,g.c=t(v(f(h.c),h.e,"0"),10,r,e),g.e=g.c.length),d=u=(p=t(a,n,r,o?(c=U,e):(c=e,U))).length;0==p[--u];p.pop());if(!p[0])return c.charAt(0);if(b<0?--d:(h.c=p,h.e=d,h.s=i,p=(h=s(h,g,y,w,r)).c,m=h.r,d=h.e),b=p[l=d+y+1],u=r/2,m=m||l<0||null!=p[l+1],m=w<4?(null!=b||m)&&(0==w||w==(h.s<0?3:2)):b>u||b==u&&(4==w||m||6==w&&1&p[l-1]||w==(h.s<0?8:7)),l<1||!p[0])a=m?v(c.charAt(1),-y,c.charAt(0)):c.charAt(0);else{if(p.length=l,m)for(--r;++p[--l]>r;)p[l]=0,l||(++d,p=[1].concat(p));for(u=p.length;!p[--u];);for(b=0,a="";b<=u;a+=c.charAt(p[b++]));a=v(a,d,c.charAt(0))}return a}}(),s=function(){function e(e,t,s){var a,n,r,i,o=0,c=e.length,l=t%m,d=t/m|0;for(e=e.slice();c--;)o=((n=l*(r=e[c]%m)+(a=d*r+(i=e[c]/m|0)*l)%m*m+o)/s|0)+(a/m|0)+d*i,e[c]=n%s;return o&&(e=[o].concat(e)),e}function t(e,t,s,a){var n,r;if(s!=a)r=s>a?1:-1;else for(n=r=0;n<s;n++)if(e[n]!=t[n]){r=e[n]>t[n]?1:-1;break}return r}function s(e,t,s,a){for(var n=0;s--;)e[s]-=n,n=e[s]<t[s]?1:0,e[s]=n*a+e[s]-t[s];for(;!e[0]&&e.length>1;e.splice(0,1));}return function(a,n,i,o,d){var u,m,h,f,g,b,y,w,v,S,E,k,T,P,_,M,x,C=a.s==n.s?1:-1,I=a.c,A=n.c;if(!(I&&I[0]&&A&&A[0]))return new G(a.s&&n.s&&(I?!A||I[0]!=A[0]:A)?I&&0==I[0]||!A?0*C:C/0:NaN);for(v=(w=new G(C)).c=[],C=i+(m=a.e-n.e)+1,d||(d=c,m=p(a.e/l)-p(n.e/l),C=C/l|0),h=0;A[h]==(I[h]||0);h++);if(A[h]>(I[h]||0)&&m--,C<0)v.push(1),f=!0;else{for(P=I.length,M=A.length,h=0,C+=2,(g=r(d/(A[0]+1)))>1&&(A=e(A,g,d),I=e(I,g,d),M=A.length,P=I.length),T=M,E=(S=I.slice(0,M)).length;E<M;S[E++]=0);x=A.slice(),x=[0].concat(x),_=A[0],A[1]>=d/2&&_++;do{if(g=0,(u=t(A,S,M,E))<0){if(k=S[0],M!=E&&(k=k*d+(S[1]||0)),(g=r(k/_))>1)for(g>=d&&(g=d-1),y=(b=e(A,g,d)).length,E=S.length;1==t(b,S,y,E);)g--,s(b,M<y?x:A,y,d),y=b.length,u=1;else 0==g&&(u=g=1),y=(b=A.slice()).length;if(y<E&&(b=[0].concat(b)),s(S,b,E,d),E=S.length,-1==u)for(;t(A,S,M,E)<1;)g++,s(S,M<E?x:A,E,d),E=S.length}else 0===u&&(g++,S=[0]);v[h++]=g,S[0]?S[E++]=I[T]||0:(S=[I[T]],E=1)}while((T++<P||null!=S[0])&&C--);f=null!=S[0],v[0]||v.splice(0,1)}if(d==c){for(h=1,C=v[0];C>=10;C/=10,h++);Y(w,i+(w.e=h+m*l-1)+1,o,f)}else w.e=m,w.r=+f;return w}}(),P=/^(-?)0([xbo])(?=\w[\w.]*$)/i,_=/^([^.]+)\.$/,M=/^\.([^.]+)$/,x=/^-?(Infinity|NaN)$/,C=/^\s*\+(?=[\w.])|^\s+|\s+$/g,E=function(e,t,s,a){var n,r=s?t:t.replace(C,"");if(x.test(r))e.s=isNaN(r)?null:r<0?-1:1;else{if(!s&&(r=r.replace(P,function(e,t,s){return n="x"==(s=s.toLowerCase())?16:"b"==s?2:8,a&&a!=n?e:t}),a&&(n=a,r=r.replace(_,"$1").replace(M,"0.$1")),t!=r))return new G(r,n);if(G.DEBUG)throw Error(i+"Not a"+(a?" base "+a:"")+" number: "+t);e.s=null}e.c=e.e=null},I.absoluteValue=I.abs=function(){var e=new G(this);return e.s<0&&(e.s=1),e},I.comparedTo=function(e,t){return g(this,new G(e,t))},I.decimalPlaces=I.dp=function(e,t){var s,a,n,r=this;if(null!=e)return b(e,0,h),null==t?t=j:b(t,0,8),Y(new G(r),e+r.e+1,t);if(!(s=r.c))return null;if(a=((n=s.length-1)-p(this.e/l))*l,n=s[n])for(;n%10==0;n/=10,a--);return a<0&&(a=0),a},I.dividedBy=I.div=function(e,t){return s(this,new G(e,t),N,j)},I.dividedToIntegerBy=I.idiv=function(e,t){return s(this,new G(e,t),0,1)},I.exponentiatedBy=I.pow=function(e,t){var s,a,o,c,d,u,m,h,p=this;if((e=new G(e)).c&&!e.isInteger())throw Error(i+"Exponent not an integer: "+J(e));if(null!=t&&(t=new G(t)),d=e.e>14,!p.c||!p.c[0]||1==p.c[0]&&!p.e&&1==p.c.length||!e.c||!e.c[0])return h=new G(Math.pow(+J(p),d?e.s*(2-y(e)):+J(e))),t?h.mod(t):h;if(u=e.s<0,t){if(t.c?!t.c[0]:!t.s)return new G(NaN);(a=!u&&p.isInteger()&&t.isInteger())&&(p=p.mod(t))}else{if(e.e>9&&(p.e>0||p.e<-1||(0==p.e?p.c[0]>1||d&&p.c[1]>=24e7:p.c[0]<8e13||d&&p.c[0]<=9999975e7)))return c=p.s<0&&y(e)?-0:0,p.e>-1&&(c=1/c),new G(u?1/c:c);L&&(c=n(L/l+2))}for(d?(s=new G(.5),u&&(e.s=1),m=y(e)):m=(o=Math.abs(+J(e)))%2,h=new G(A);;){if(m){if(!(h=h.times(p)).c)break;c?h.c.length>c&&(h.c.length=c):a&&(h=h.mod(t))}if(o){if(0===(o=r(o/2)))break;m=o%2}else if(Y(e=e.times(s),e.e+1,1),e.e>14)m=y(e);else{if(0===(o=+J(e)))break;m=o%2}p=p.times(p),c?p.c&&p.c.length>c&&(p.c.length=c):a&&(p=p.mod(t))}return a?h:(u&&(h=A.div(h)),t?h.mod(t):c?Y(h,L,j,undefined):h)},I.integerValue=function(e){var t=new G(this);return null==e?e=j:b(e,0,8),Y(t,t.e+1,e)},I.isEqualTo=I.eq=function(e,t){return 0===g(this,new G(e,t))},I.isFinite=function(){return!!this.c},I.isGreaterThan=I.gt=function(e,t){return g(this,new G(e,t))>0},I.isGreaterThanOrEqualTo=I.gte=function(e,t){return 1===(t=g(this,new G(e,t)))||0===t},I.isInteger=function(){return!!this.c&&p(this.e/l)>this.c.length-2},I.isLessThan=I.lt=function(e,t){return g(this,new G(e,t))<0},I.isLessThanOrEqualTo=I.lte=function(e,t){return-1===(t=g(this,new G(e,t)))||0===t},I.isNaN=function(){return!this.s},I.isNegative=function(){return this.s<0},I.isPositive=function(){return this.s>0},I.isZero=function(){return!!this.c&&0==this.c[0]},I.minus=function(e,t){var s,a,n,r,i=this,o=i.s;if(t=(e=new G(e,t)).s,!o||!t)return new G(NaN);if(o!=t)return e.s=-t,i.plus(e);var d=i.e/l,u=e.e/l,m=i.c,h=e.c;if(!d||!u){if(!m||!h)return m?(e.s=-t,e):new G(h?i:NaN);if(!m[0]||!h[0])return h[0]?(e.s=-t,e):new G(m[0]?i:3==j?-0:0)}if(d=p(d),u=p(u),m=m.slice(),o=d-u){for((r=o<0)?(o=-o,n=m):(u=d,n=h),n.reverse(),t=o;t--;n.push(0));n.reverse()}else for(a=(r=(o=m.length)<(t=h.length))?o:t,o=t=0;t<a;t++)if(m[t]!=h[t]){r=m[t]<h[t];break}if(r&&(n=m,m=h,h=n,e.s=-e.s),(t=(a=h.length)-(s=m.length))>0)for(;t--;m[s++]=0);for(t=c-1;a>o;){if(m[--a]<h[a]){for(s=a;s&&!m[--s];m[s]=t);--m[s],m[a]+=c}m[a]-=h[a]}for(;0==m[0];m.splice(0,1),--u);return m[0]?K(e,m,u):(e.s=3==j?-1:1,e.c=[e.e=0],e)},I.modulo=I.mod=function(e,t){var a,n,r=this;return e=new G(e,t),!r.c||!e.s||e.c&&!e.c[0]?new G(NaN):!e.c||r.c&&!r.c[0]?new G(r):(9==F?(n=e.s,e.s=1,a=s(r,e,0,3),e.s=n,a.s*=n):a=s(r,e,0,F),(e=r.minus(a.times(e))).c[0]||1!=F||(e.s=r.s),e)},I.multipliedBy=I.times=function(e,t){var s,a,n,r,i,o,d,u,h,f,g,b,y,w,v,S=this,E=S.c,k=(e=new G(e,t)).c;if(!(E&&k&&E[0]&&k[0]))return!S.s||!e.s||E&&!E[0]&&!k||k&&!k[0]&&!E?e.c=e.e=e.s=null:(e.s*=S.s,E&&k?(e.c=[0],e.e=0):e.c=e.e=null),e;for(a=p(S.e/l)+p(e.e/l),e.s*=S.s,(d=E.length)<(f=k.length)&&(y=E,E=k,k=y,n=d,d=f,f=n),n=d+f,y=[];n--;y.push(0));for(w=c,v=m,n=f;--n>=0;){for(s=0,g=k[n]%v,b=k[n]/v|0,r=n+(i=d);r>n;)s=((u=g*(u=E[--i]%v)+(o=b*u+(h=E[i]/v|0)*g)%v*v+y[r]+s)/w|0)+(o/v|0)+b*h,y[r--]=u%w;y[r]=s}return s?++a:y.splice(0,1),K(e,y,a)},I.negated=function(){var e=new G(this);return e.s=-e.s||null,e},I.plus=function(e,t){var s,a=this,n=a.s;if(t=(e=new G(e,t)).s,!n||!t)return new G(NaN);if(n!=t)return e.s=-t,a.minus(e);var r=a.e/l,i=e.e/l,o=a.c,d=e.c;if(!r||!i){if(!o||!d)return new G(n/0);if(!o[0]||!d[0])return d[0]?e:new G(o[0]?a:0*n)}if(r=p(r),i=p(i),o=o.slice(),n=r-i){for(n>0?(i=r,s=d):(n=-n,s=o),s.reverse();n--;s.push(0));s.reverse()}for((n=o.length)-(t=d.length)<0&&(s=d,d=o,o=s,t=n),n=0;t;)n=(o[--t]=o[t]+d[t]+n)/c|0,o[t]=c===o[t]?0:o[t]%c;return n&&(o=[n].concat(o),++i),K(e,o,i)},I.precision=I.sd=function(e,t){var s,a,n,r=this;if(null!=e&&e!==!!e)return b(e,1,h),null==t?t=j:b(t,0,8),Y(new G(r),e,t);if(!(s=r.c))return null;if(a=(n=s.length-1)*l+1,n=s[n]){for(;n%10==0;n/=10,a--);for(n=s[0];n>=10;n/=10,a++);}return e&&r.e+1>a&&(a=r.e+1),a},I.shiftedBy=function(e){return b(e,-9007199254740991,d),this.times("1e"+e)},I.squareRoot=I.sqrt=function(){var e,t,a,n,r,i=this,o=i.c,c=i.s,l=i.e,d=N+4,u=new G("0.5");if(1!==c||!o||!o[0])return new G(!c||c<0&&(!o||o[0])?NaN:o?i:1/0);if(0==(c=Math.sqrt(+J(i)))||c==1/0?(((t=f(o)).length+l)%2==0&&(t+="0"),c=Math.sqrt(+t),l=p((l+1)/2)-(l<0||l%2),a=new G(t=c==1/0?"5e"+l:(t=c.toExponential()).slice(0,t.indexOf("e")+1)+l)):a=new G(c+""),a.c[0])for((c=(l=a.e)+d)<3&&(c=0);;)if(r=a,a=u.times(r.plus(s(i,r,d,1))),f(r.c).slice(0,c)===(t=f(a.c)).slice(0,c)){if(a.e<l&&--c,"9999"!=(t=t.slice(c-3,c+1))&&(n||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(Y(a,a.e+N+2,1),e=!a.times(a).eq(i));break}if(!n&&(Y(r,r.e+N+2,0),r.times(r).eq(i))){a=r;break}d+=4,c+=4,n=1}return Y(a,a.e+N+1,j,e)},I.toExponential=function(e,t){return null!=e&&(b(e,0,h),e++),W(this,e,t,1)},I.toFixed=function(e,t){return null!=e&&(b(e,0,h),e=e+this.e+1),W(this,e,t)},I.toFormat=function(e,t,s){var a,n=this;if(null==s)null!=e&&t&&"object"==typeof t?(s=t,t=null):e&&"object"==typeof e?(s=e,e=t=null):s=H;else if("object"!=typeof s)throw Error(i+"Argument not an object: "+s);if(a=n.toFixed(e,t),n.c){var r,o=a.split("."),c=+s.groupSize,l=+s.secondaryGroupSize,d=s.groupSeparator||"",u=o[0],m=o[1],h=n.s<0,p=h?u.slice(1):u,f=p.length;if(l&&(r=c,c=l,l=r,f-=r),c>0&&f>0){for(r=f%c||c,u=p.substr(0,r);r<f;r+=c)u+=d+p.substr(r,c);l>0&&(u+=d+p.slice(r)),h&&(u="-"+u)}a=m?u+(s.decimalSeparator||"")+((l=+s.fractionGroupSize)?m.replace(new RegExp("\\d{"+l+"}\\B","g"),"$&"+(s.fractionGroupSeparator||"")):m):u}return(s.prefix||"")+a+(s.suffix||"")},I.toFraction=function(e){var t,a,n,r,o,c,d,m,h,p,g,b,y=this,w=y.c;if(null!=e&&(!(d=new G(e)).isInteger()&&(d.c||1!==d.s)||d.lt(A)))throw Error(i+"Argument "+(d.isInteger()?"out of range: ":"not an integer: ")+J(d));if(!w)return new G(y);for(t=new G(A),h=a=new G(A),n=m=new G(A),b=f(w),o=t.e=b.length-y.e-1,t.c[0]=u[(c=o%l)<0?l+c:c],e=!e||d.comparedTo(t)>0?o>0?t:h:d,c=D,D=1/0,d=new G(b),m.c[0]=0;p=s(d,t,0,1),1!=(r=a.plus(p.times(n))).comparedTo(e);)a=n,n=r,h=m.plus(p.times(r=h)),m=r,t=d.minus(p.times(r=t)),d=r;return r=s(e.minus(a),n,0,1),m=m.plus(r.times(h)),a=a.plus(r.times(n)),m.s=h.s=y.s,g=s(h,n,o*=2,j).minus(y).abs().comparedTo(s(m,a,o,j).minus(y).abs())<1?[h,n]:[m,a],D=c,g},I.toNumber=function(){return+J(this)},I.toPrecision=function(e,t){return null!=e&&b(e,1,h),W(this,e,t,2)},I.toString=function(e){var t,s=this,a=s.s,n=s.e;return null===n?a?(t="Infinity",a<0&&(t="-"+t)):t="NaN":(null==e?t=n<=O||n>=R?w(f(s.c),n):v(f(s.c),n,"0"):10===e&&q?t=v(f((s=Y(new G(s),N+n+1,j)).c),s.e,"0"):(b(e,2,U.length,"Base"),t=S(v(f(s.c),n,"0"),10,e,a,!0)),a<0&&s.c[0]&&(t="-"+t)),t},I.valueOf=I.toJSON=function(){return J(this)},I._isBigNumber=!0,null!=t&&G.set(t),G}(),s.default=s.BigNumber=s,"function"==typeof define&&define.amd?define(function(){return s}):void 0!==t&&t.exports?t.exports=s:(e||(e="undefined"!=typeof self&&self?self:window),e.BigNumber=s)}(this)}}},{package:"@metamask/smart-transactions-controller>bignumber.js",file:"node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js"}],[2477,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={name:"@metamask/smart-transactions-controller",version:"18.1.0",description:"Improves success rates for swaps by trialing transactions privately and finding minimum fees",repository:{type:"git",url:"https://github.com/MetaMask/smart-transactions-controller.git"},license:"SEE LICENSE IN LICENSE",main:"dist/index.js",types:"dist/index.d.ts",files:["dist/"],scripts:{build:"tsc --project tsconfig.build.json","build:clean":"rm -rf dist && yarn build","build:link":"yarn build && cd dist && yarn link && rm -rf node_modules && cd ..",lint:"yarn lint:eslint && yarn lint:misc --check && yarn lint:changelog","lint:changelog":"auto-changelog validate --prettier","lint:eslint":"eslint . --cache --ext js,ts","lint:fix":"yarn lint:eslint --fix && yarn lint:misc --write && yarn lint:changelog","lint:misc":"prettier '**/*.json' '**/*.md' '**/*.yml' '!.yarnrc.yml' --ignore-path .gitignore --no-error-on-unmatched-pattern",prepack:"./scripts/prepack.sh",test:"jest","test:watch":"jest --watchAll"},dependencies:{"@babel/runtime":"^7.24.1","@ethereumjs/tx":"^5.2.1","@ethereumjs/util":"^9.0.2","@ethersproject/bytes":"^5.7.0","@ethersproject/keccak256":"^5.8.0","@ethersproject/transactions":"^5.7.0","@metamask/base-controller":"^7.0.1","@metamask/controller-utils":"^11.0.0","@metamask/eth-json-rpc-provider":"^4.1.6","@metamask/eth-query":"^4.0.0","@metamask/polling-controller":"^12.0.0","bignumber.js":"^9.0.1","fast-json-patch":"^3.1.0",lodash:"^4.17.21"},devDependencies:{"@lavamoat/allow-scripts":"^3.2.1","@lavamoat/preinstall-always-fail":"^2.1.0","@metamask/auto-changelog":"^3.1.0","@metamask/eslint-config":"^12.2.0","@metamask/eslint-config-jest":"^12.1.0","@metamask/eslint-config-nodejs":"^12.1.0","@metamask/eslint-config-typescript":"^12.1.0","@metamask/gas-fee-controller":"^22.0.0","@metamask/json-rpc-engine":"^10.0.1","@metamask/network-controller":"^24.0.0","@metamask/transaction-controller":"^42.0.0","@types/jest":"^26.0.24","@types/lodash":"^4.14.194","@types/node":"^18.19.17","@types/sinon":"^9.0.10","@typescript-eslint/eslint-plugin":"^5.33.0","@typescript-eslint/parser":"^5.33.0",eslint:"^8.48.0","eslint-config-prettier":"^8.8.0","eslint-plugin-import":"~2.26.0","eslint-plugin-jest":"^27.1.5","eslint-plugin-jsdoc":"^39.2.9","eslint-plugin-n":"^15.7.0","eslint-plugin-prettier":"^4.2.1","eslint-plugin-promise":"^6.1.1","isomorphic-fetch":"^3.0.0",jest:"^29.7.0",nock:"^14.0.0-beta.7",prettier:"^2.8.8","prettier-plugin-packagejson":"^2.4.3",sinon:"^9.2.4","ts-jest":"^29.1.4",typescript:"~4.8.4"},peerDependencies:{"@metamask/network-controller":"^24.0.0","@metamask/transaction-controller":"^42.0.0"},peerDependenciesMeta:{"@metamask/accounts-controller":{optional:!0},"@metamask/approval-controller":{optional:!0}},packageManager:"yarn@3.2.1",engines:{node:"^18.18 || >=20"},publishConfig:{access:"public",registry:"https://registry.npmjs.org/"},lavamoat:{allowScripts:{"@lavamoat/preinstall-always-fail":!1,"@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>keccak":!1,"@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>secp256k1":!1,"@metamask/controller-utils>babel-runtime>core-js":!1,"@metamask/transaction-controller>@metamask/accounts-controller>@metamask/keyring-controller>ethereumjs-wallet>ethereum-cryptography>keccak":!1,"@metamask/transaction-controller>@metamask/accounts-controller>@metamask/keyring-controller>ethereumjs-wallet>ethereum-cryptography>secp256k1":!1}}}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/package.json"}],[2478,{"../snaps/Timer.cjs":2500,"../snaps/constants.cjs":2501,"./utils.cjs":2480,"@metamask/base-controller":1264,"@metamask/snaps-rpc-methods":2542,"@metamask/snaps-utils":2712,"@metamask/utils":2835,immer:4353,luxon:4571,nanoid:4744},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){n(e,t),t.set(e,s)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,s){return e.set(o(e,t),s),s}function o(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.CronjobController=s.DAILY_TIMEOUT=void 0;const c=e("@metamask/base-controller"),l=e("@metamask/snaps-rpc-methods"),d=e("@metamask/snaps-utils"),u=e("@metamask/utils"),m=e("immer"),h=e("luxon"),p=e("nanoid"),f=e("./utils.cjs"),g=e("../snaps/constants.cjs"),b=e("../snaps/Timer.cjs");s.DAILY_TIMEOUT=(0,u.inMilliseconds)(24,u.Duration.Hour);const y="CronjobController";var w=new WeakMap,v=new WeakMap,S=new WeakMap,E=new WeakSet,k=new WeakMap,T=new WeakMap,P=new WeakMap,_=new WeakMap,M=new WeakMap;class x extends c.BaseController{constructor({messenger:e,state:t,stateManager:c}){var l,d;super({messenger:e,metadata:{events:{includeInStateLogs:!1,persist:!1,anonymous:!1,usedInUi:!1}},name:y,state:{events:{},...t,...c.getInitialState()}}),n(l=this,d=E),d.add(l),a(this,w,void 0),a(this,v,void 0),a(this,S,new b.Timer(s.DAILY_TIMEOUT)),a(this,k,e=>{this.unregister(e.id),this.register(e.id)}),a(this,T,e=>{const t=this.get(e.id);o(E,this,$).call(this,t),this.register(e.id)}),a(this,P,e=>{this.unregister(e.id)}),a(this,_,e=>{this.unregister(e.id)}),a(this,M,e=>{this.unregister(e.id),this.register(e.id)}),i(w,this,new Map),i(v,this,c),this.messagingSystem.subscribe("SnapController:snapInstalled",r(k,this)),this.messagingSystem.subscribe("SnapController:snapUninstalled",r(P,this)),this.messagingSystem.subscribe("SnapController:snapEnabled",r(T,this)),this.messagingSystem.subscribe("SnapController:snapDisabled",r(_,this)),this.messagingSystem.subscribe("SnapController:snapUpdated",r(M,this)),this.messagingSystem.registerActionHandler(`${y}:init`,(...e)=>this.init(...e)),this.messagingSystem.registerActionHandler(`${y}:schedule`,(...e)=>this.schedule(...e)),this.messagingSystem.registerActionHandler(`${y}:cancel`,(...e)=>this.cancel(...e)),this.messagingSystem.registerActionHandler(`${y}:get`,(...e)=>this.get(...e))}init(){o(E,this,C).call(this),o(E,this,D).call(this),o(E,this,$).call(this)}schedule(e){return o(E,this,I).call(this,{...e,recurring:!1})}cancel(e,t){(0,u.assert)(this.state.events[t],`A background event with the id of "${t}" does not exist.`),(0,u.assert)(this.state.events[t].snapId===e,"Only the origin that scheduled this event can cancel it."),o(E,this,O).call(this,t)}get(e){return Object.values(this.state.events).filter(t=>t.snapId===e&&!t.recurring).map(e=>({...e,date:(0,d.toCensoredISO8601String)(e.date),scheduledAt:(0,d.toCensoredISO8601String)(e.scheduledAt)}))}register(e){const t=o(E,this,R).call(this,e);null==t||t.forEach(e=>o(E,this,I).call(this,e))}unregister(e){for(const[t,s]of Object.entries(this.state.events))s.snapId===e&&o(E,this,O).call(this,t)}destroy(){super.destroy(),this.messagingSystem.unsubscribe("SnapController:snapInstalled",r(k,this)),this.messagingSystem.unsubscribe("SnapController:snapUninstalled",r(P,this)),this.messagingSystem.unsubscribe("SnapController:snapEnabled",r(T,this)),this.messagingSystem.unsubscribe("SnapController:snapDisabled",r(_,this)),this.messagingSystem.unsubscribe("SnapController:snapUpdated",r(M,this)),r(w,this).forEach(e=>e.cancel()),r(w,this).clear(),"running"===r(S,this).status&&r(S,this).cancel()}}function C(){i(S,this,new b.Timer(s.DAILY_TIMEOUT)),r(S,this).start(()=>{o(E,this,$).call(this),o(E,this,C).call(this)})}function I(e){const t=e.id??(0,p.nanoid)(),s={...e,id:t,date:(0,f.getExecutionDate)(e.schedule),scheduledAt:(new Date).toISOString()},{nextState:a}=this.update(e=>{e.events[s.id]=(0,m.castDraft)(s)});return r(v,this).set(a),o(E,this,A).call(this,s),t}function A(e,t=!0){if(!t)return void o(E,this,N).call(this,e);const s=(0,f.getExecutionDate)(e.schedule),{nextState:a}=this.update(t=>{t.events[e.id].date=s});r(v,this).set(a),o(E,this,N).call(this,{...e,date:s})}function N(e){const t=h.DateTime.fromISO(e.date,{setZone:!0}).toMillis()-Date.now();if(t>s.DAILY_TIMEOUT)return;if(t<=0)return void o(E,this,j).call(this,e);const a=new b.Timer(t);a.start(()=>{o(E,this,j).call(this,e)}),r(w,this).set(e.id,a)}function j(e){if(this.messagingSystem.call("SnapController:handleRequest",{snapId:e.snapId,origin:g.METAMASK_ORIGIN,handler:d.HandlerType.OnCronjob,request:e.request}).catch(t=>{(0,d.logError)(`An error occurred while executing an event for Snap "${e.snapId}":`,t)}),r(w,this).delete(e.id),!e.recurring){const{nextState:t}=this.update(t=>{delete t.events[e.id]});return void r(v,this).set(t)}o(E,this,A).call(this,e)}function O(e){const t=r(w,this).get(e);null==t||t.cancel(),r(w,this).delete(e);const{nextState:s}=this.update(t=>{delete t.events[e]});r(v,this).set(s)}function R(e){const t=this.messagingSystem.call("PermissionController:getPermissions",e),s=null==t?void 0:t[l.SnapEndowments.Cronjob],a=(0,l.getCronjobCaveatJobs)(s);return a?a.map((t,s)=>({snapId:e,id:`cronjob-${e}-${s}`,request:t.request,schedule:(0,f.getCronjobSpecificationSchedule)(t),recurring:!0})):[]}function $(e=Object.values(this.state.events)){const t=Date.now();for(const s of e){if(r(w,this).has(s.id))continue;const e=h.DateTime.fromISO(s.date,{setZone:!0}).toUTC().toMillis();s.recurring&&e<=t?o(E,this,j).call(this,s):o(E,this,A).call(this,s,!1)}}function D(){const e=Date.now();for(const t of Object.values(this.state.events)){const s=h.DateTime.fromISO(t.date,{setZone:!0}).toUTC().toMillis();!t.recurring&&s<e&&o(E,this,O).call(this,t.id)}}s.CronjobController=x}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"}],[2479,{"./CronjobController.cjs":2478},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./CronjobController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs"}],[248,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;s.default=[{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"hash",type:"bytes32"}],name:"setContent",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"content",outputs:[{name:"",type:"bytes32"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"interfaceID",type:"bytes4"}],name:"supportsInterface",outputs:[{name:"",type:"bool"}],payable:!1,stateMutability:"pure",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"key",type:"string"},{name:"value",type:"string"}],name:"setText",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"},{name:"contentTypes",type:"uint256"}],name:"ABI",outputs:[{name:"contentType",type:"uint256"},{name:"data",type:"bytes"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"x",type:"bytes32"},{name:"y",type:"bytes32"}],name:"setPubkey",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"hash",type:"bytes"}],name:"setContenthash",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"addr",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"},{name:"key",type:"string"}],name:"text",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"contentType",type:"uint256"},{name:"data",type:"bytes"}],name:"setABI",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"name",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"name",type:"string"}],name:"setName",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"contenthash",outputs:[{name:"",type:"bytes"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"node",type:"bytes32"}],name:"pubkey",outputs:[{name:"x",type:"bytes32"},{name:"y",type:"bytes32"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"node",type:"bytes32"},{name:"addr",type:"address"}],name:"setAddr",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{inputs:[{name:"ensAddr",type:"address"}],payable:!1,stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"a",type:"address"}],name:"AddrChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"name",type:"string"}],name:"NameChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!0,name:"contentType",type:"uint256"}],name:"ABIChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"x",type:"bytes32"},{indexed:!1,name:"y",type:"bytes32"}],name:"PubkeyChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"indexedKey",type:"string"},{indexed:!1,name:"key",type:"string"}],name:"TextChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"node",type:"bytes32"},{indexed:!1,name:"hash",type:"bytes"}],name:"ContenthashChanged",type:"event"}]}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/contracts/resolver.js"}],[2480,{"@metamask/utils":2835,"cron-parser":3903,luxon:4571},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getExecutionDate=s.getCronjobSpecificationSchedule=void 0;const a=e("@metamask/utils"),n=e("cron-parser"),r=e("luxon");s.getCronjobSpecificationSchedule=function(e){return(0,a.hasProperty)(e,"duration")?e.duration:e.expression},s.getExecutionDate=function(e){const t=r.DateTime.fromISO(e,{setZone:!0});if(t.isValid){const e=Date.now(),s=t.toUTC().startOf("second");if(s.toMillis()<e)throw new Error("Cannot schedule an event in the past.");return s.toISO({suppressMilliseconds:!0})}const s=r.Duration.fromISO(e);if(s.isValid){const e=function(e){return e.as("seconds")<1?r.Duration.fromObject({seconds:1}):e}(s);return r.DateTime.now().toUTC().plus(e).toISO()}try{const t=(0,n.parseExpression)(e,{utc:!0}).next(),s=r.DateTime.fromJSDate(t.toDate());return(0,a.assert)(s.isValid),s.toUTC().toISO()}catch{throw new Error(`Unable to parse "${e}" as ISO 8601 date, ISO 8601 duration, or cron expression.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs"}],[2481,{"@metamask/utils":2835,"@xstate/fsm":3305},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.forceStrict=s.validateMachine=void 0;const a=e("@metamask/utils"),n=e("@xstate/fsm");s.validateMachine=function(e){(0,a.assert)("_options"in e,"The machine is not an @xstate/fsm machine");const t=e,s=new Set,n=e=>{return(t=e,Array.isArray(t)?t:t===undefined||null===t?[]:[t]).flatMap(e=>"string"==typeof e?[e]:((0,a.assert)("function"==typeof e),[])).forEach(s.add.bind(s));var t};for(const e of Object.values(t.config.states)){n(e.entry),n(e.exit);for(const t of Object.values(e.on??{}))n(t.actions)}s.forEach(e=>(0,a.assert)(t._options.actions!==undefined&&e in t._options.actions,`Action "${e}" doesn't have an implementation`))},s.forceStrict=function(e){let t=!1;e.subscribe(e=>{(0,a.assert)(!t||e.changed,"Invalid state transition"),t=!0});const s=e.send.bind(e);e.send=(...t)=>((0,a.assert)(e.status===n.InterpreterStatus.Running,"Interpreter is stopped"),s(...t))}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/fsm.cjs"}],[2482,{"./cronjob/index.cjs":2479,"./insights/index.cjs":2484,"./interface/index.cjs":2486,"./multichain/index.cjs":2490,"./services/index.cjs":2495,"./snaps/index.cjs":2502,"./utils.cjs":2512,"./websocket/index.cjs":2514},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./services/index.cjs"),s),n(e("./snaps/index.cjs"),s),n(e("./utils.cjs"),s),n(e("./cronjob/index.cjs"),s),n(e("./interface/index.cjs"),s),n(e("./insights/index.cjs"),s),n(e("./multichain/index.cjs"),s),n(e("./websocket/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/index.cjs"}],[2483,{"../snaps/index.cjs":2502,"@metamask/base-controller":1264,"@metamask/snaps-rpc-methods":2542,"@metamask/snaps-utils":2712,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function n(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapInsightsController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-rpc-methods"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("../snaps/index.cjs");var d=new WeakSet;class u extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{insights:{includeInStateLogs:!0,persist:!1,anonymous:!1,usedInUi:!0}},name:"SnapInsightsController",state:{insights:{},...t}}),a(this,d),this.messagingSystem.subscribe("TransactionController:unapprovedTransactionAdded",n(d,this,p).bind(this)),this.messagingSystem.subscribe("TransactionController:transactionStatusUpdated",n(d,this,b).bind(this)),this.messagingSystem.subscribe("SignatureController:stateChange",n(d,this,f).bind(this))}}function m(e){return(0,c.hasProperty)(this.state.insights,e)}function h(e){const t=this.messagingSystem.call("SnapController:getAll");return(0,l.getRunnableSnaps)(t).reduce((t,s)=>{const a=this.messagingSystem.call("PermissionController:getPermissions",s.id);return a&&(0,c.hasProperty)(a,e)&&t.push({snapId:s.id,permission:a[e]}),t},[])}function p(e){const{id:t,txParams:s,chainId:a,origin:r}=e,l=`eip155:${(0,c.hexToBigInt)(a).toString(10)}`;n(d,this,h).call(this,i.SnapEndowments.TransactionInsight).forEach(({snapId:e,permission:a})=>{const c=(0,i.getTransactionOriginCaveat)(a)&&r?r:null;this.update(s=>{var a;(a=s.insights)[t]??(a[t]={}),s.insights[t][e]={snapId:e,loading:!0}}),n(d,this,w).call(this,{snapId:e,handler:o.HandlerType.OnTransaction,params:{transaction:s,chainId:l,transactionOrigin:c}}).then(s=>n(d,this,v).call(this,{id:t,snapId:e,response:s})).catch(s=>n(d,this,v).call(this,{id:t,snapId:e,error:s}))})}function f(e){for(const t of Object.keys(this.state.insights))(0,c.hasProperty)(e.unapprovedTypedMessages,t)||(0,c.hasProperty)(e.unapprovedPersonalMsgs,t)||n(d,this,y).call(this,t);if(e.unapprovedPersonalMsgCount>0||e.unapprovedTypedMessagesCount>0){const t=n(d,this,h).call(this,i.SnapEndowments.SignatureInsight);for(const s of Object.values(e.unapprovedPersonalMsgs))n(d,this,g).call(this,t,s);for(const s of Object.values(e.unapprovedTypedMessages))n(d,this,g).call(this,t,s)}}function g(e,t){const{id:s,msgParams:a}=t;if(n(d,this,m).call(this,s))return;const{from:r,data:c,signatureMethod:l,origin:u}=a,h={from:r,data:"eth_signTypedData_v3"===l||"eth_signTypedData_v4"===l?JSON.parse(c):c,signatureMethod:l};e.forEach(({snapId:e,permission:t})=>{const a=(0,i.getSignatureOriginCaveat)(t),r=u&&a?u:null;this.update(t=>{var a;(a=t.insights)[s]??(a[s]={}),t.insights[s][e]={snapId:e,loading:!0}}),n(d,this,w).call(this,{snapId:e,handler:o.HandlerType.OnSignature,params:{signature:h,signatureOrigin:r}}).then(t=>n(d,this,v).call(this,{id:s,snapId:e,response:t})).catch(t=>n(d,this,v).call(this,{id:s,snapId:e,error:t}))})}function b({transactionMeta:e}){"unapproved"!==e.status&&n(d,this,y).call(this,e.id)}function y(e){n(d,this,m).call(this,e)&&(Object.values(this.state.insights[e]).filter(e=>e.interfaceId).forEach(e=>{this.messagingSystem.call("SnapInterfaceController:deleteInterface",e.interfaceId)}),this.update(t=>{delete t.insights[e]}))}async function w({snapId:e,handler:t,params:s}){return this.messagingSystem.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:t,request:{method:"",params:s}})}function v({id:e,snapId:t,response:s,error:a}){n(d,this,m).call(this,e)&&this.update(n=>{n.insights[e][t].loading=!1,n.insights[e][t].interfaceId=null==s?void 0:s.id,n.insights[e][t].severity=null==s?void 0:s.severity,n.insights[e][t].error=null==a?void 0:a.message})}s.SnapInsightsController=u}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"}],[2484,{"./SnapInsightsController.cjs":2483},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./SnapInsightsController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/index.cjs"}],[2485,{"./utils.cjs":2487,"@metamask/base-controller":1264,"@metamask/snaps-sdk":2598,"@metamask/snaps-utils":2712,"@metamask/utils":2835,immer:4353,nanoid:4744},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function n(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapInterfaceController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-sdk"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("immer"),d=e("nanoid"),u=e("./utils.cjs"),m=1e7,h="SnapInterfaceController";var p=new WeakSet;class f extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{interfaces:{includeInStateLogs:!0,persist:e=>Object.entries(e).reduce((e,[t,s])=>s.contentType===i.ContentType.Notification?(e[t]=s,e):e,{}),anonymous:!1,usedInUi:!0}},name:h,state:{interfaces:{},...t}}),a(this,p),this.messagingSystem.subscribe("NotificationServicesController:notificationsListUpdated",n(p,this,x).bind(this)),n(p,this,g).call(this)}createInterface(e,t,s,a){const r=(0,u.getJsxInterface)(t);n(p,this,M).call(this,r),(0,u.validateInterfaceContext)(s);const i=(0,d.nanoid)(),c=(0,u.constructState)({},r,{getAssetsState:n(p,this,P).bind(this),getAccountByAddress:n(p,this,T).bind(this),getSelectedAccount:n(p,this,E).bind(this),listAccounts:n(p,this,k).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});return this.update(t=>{t.interfaces[i]={snapId:e,content:(0,l.castDraft)(r),state:c,context:s??null,contentType:a??null}}),i}getInterface(e,t){return n(p,this,b).call(this,e,t),this.state.interfaces[t]}updateInterface(e,t,s,a){n(p,this,b).call(this,e,t);const r=(0,u.getJsxInterface)(s);n(p,this,M).call(this,r),(0,u.validateInterfaceContext)(a);const i=this.state.interfaces[t].state,c=(0,u.constructState)(i,r,{getAssetsState:n(p,this,P).bind(this),getAccountByAddress:n(p,this,T).bind(this),getSelectedAccount:n(p,this,E).bind(this),listAccounts:n(p,this,k).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});this.update(e=>{e.interfaces[t].state=c,e.interfaces[t].content=(0,l.castDraft)(r),a&&(e.interfaces[t].context=a)})}deleteInterface(e){this.update(t=>{delete t.interfaces[e]})}updateInterfaceState(e,t){this.update(s=>{s.interfaces[e].state=t})}async resolveInterface(e,t,s){n(p,this,b).call(this,e,t),n(p,this,y).call(this,t),await n(p,this,S).call(this,t,s),this.deleteInterface(t)}}function g(){this.messagingSystem.registerActionHandler(`${h}:createInterface`,this.createInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:getInterface`,this.getInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterface`,this.updateInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:deleteInterface`,this.deleteInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterfaceState`,this.updateInterfaceState.bind(this)),this.messagingSystem.registerActionHandler(`${h}:resolveInterface`,this.resolveInterface.bind(this))}function b(e,t){const s=this.state.interfaces[t];(0,c.assert)(s!==undefined,`Interface with id '${t}' not found.`),(0,c.assert)(s.snapId===e,`Interface not created by ${e}.`)}function y(e){(0,c.assert)(n(p,this,v).call(this,e),`Approval request with id '${e}' not found.`)}function w(e){return this.messagingSystem.call("PhishingController:testOrigin",e).result}function v(e){return this.messagingSystem.call("ApprovalController:hasRequest",{id:e})}async function S(e,t){await this.messagingSystem.call("ApprovalController:acceptRequest",e,t)}function E(){return this.messagingSystem.call("AccountsController:getSelectedMultichainAccount")}function k(e){const t=this.messagingSystem.call("AccountsController:listMultichainAccounts");return e&&0!==e.length?t.filter(t=>t.scopes.some(t=>(0,u.isMatchingChainId)(t,e))):t}function T(e){const{address:t}=(0,c.parseCaipAccountId)(e);return this.messagingSystem.call("AccountsController:getAccountByAddress",t)}function P(){return this.messagingSystem.call("MultichainAssetsController:getState")}function _(e){return this.messagingSystem.call("SnapController:get",e)}function M(e){const t=(0,o.getJsonSizeUnsafe)(e);(0,c.assert)(t<=m,"A Snap UI may not be larger than 10 MB."),(0,o.validateJsxElements)(e,{isOnPhishingList:n(p,this,w).bind(this),getSnap:n(p,this,_).bind(this),getAccountByAddress:n(p,this,T).bind(this)})}function x(e){const t=e.filter(e=>"snap"===e.type&&(0,c.hasProperty)(e.data,"detailedView")),s=new Set(t.map(e=>e.data.detailedView.interfaceId));this.update(e=>{Object.entries(e.interfaces).forEach(([t,a])=>{a.contentType!==i.ContentType.Notification||s.has(t)||delete e.interfaces[t]})})}s.SnapInterfaceController=f}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"}],[2486,{"./SnapInterfaceController.cjs":2485},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./SnapInterfaceController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/index.cjs"}],[2487,{"@metamask/snaps-sdk":2598,"@metamask/snaps-sdk/jsx":2682,"@metamask/snaps-utils":2712,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.validateInterfaceContext=s.constructState=s.getAccountSelectorStateValue=s.getAssetSelectorStateValue=s.getAccountSelectorDefaultStateValue=s.getDefaultAsset=s.formatAccountSelectorStateValue=s.isMatchingChainId=s.assertNameIsUnique=s.getJsxInterface=s.isStatefulComponent=void 0;const a=e("@metamask/snaps-sdk"),n=e("@metamask/snaps-sdk/jsx"),r=e("@metamask/snaps-utils"),i=e("@metamask/utils"),o=["Input","Dropdown","RadioGroup","FileInput","Checkbox","Selector","AssetSelector","AddressInput","AccountSelector"];function c(e){return o.includes(e.type)}function l(e,t){(0,a.assert)(e[t]===undefined,`Duplicate component names are not allowed, found multiple instances of: "${t}".`)}function d(e,t){return"eip155:0"===e?t.some(e=>{const{namespace:t}=(0,i.parseCaipChainId)(e);return t===i.KnownCaipNamespace.Eip155}):t.includes(e)}function u(e,t){const{id:s,address:a,scopes:n}=e,i=(0,r.createChainIdList)(n,t);return{accountId:s,addresses:(0,r.createAccountList)(a,i)}}function m(e,t,{getAccountByAddress:s,getAssetsState:n}){var r;const{assetsMetadata:o,accountsAssets:c}=n(),l=e.map(e=>(0,i.parseCaipAccountId)(e)).map(({chainId:e})=>e),d=t&&t.length>0?l.filter(e=>t.includes(e)):l,u=null===(r=s(e[0]))||void 0===r?void 0:r.id;(0,a.assert)(u,`Account not found for address: ${e[0]}.`);const m=c[u];if(0===m.length)return null;const h=m.find(e=>{const{chainId:t,assetNamespace:s}=(0,i.parseCaipAssetType)(e);return d.includes(t)&&"slip44"===s});return h?{asset:h,name:o[h].name,symbol:o[h].symbol}:{asset:m[0],name:o[m[0]].name,symbol:o[m[0]].symbol}}function h(e,{getSelectedAccount:t,listAccounts:s,snapOwnsAccount:a}){const{chainIds:n,hideExternalAccounts:r}=e.props,i=t();if((!n||0===n.length||i.scopes.some(e=>d(e,n)))&&(!r||r&&a(i)))return u(i,n);const o=s(n),c=r?o.filter(e=>a(e)):o;return 0===c.length?null:u(c[0],n)}function p(e,t){if(!e)return null;const{assetsMetadata:s}=t(),a=s[e];return a?{asset:e,name:a.name??a.symbol??"Unknown",symbol:a.symbol??"Unknown"}:null}function f(e,{getAccountByAddress:t,snapOwnsAccount:s}){const{value:a,hideExternalAccounts:n}=e.props;if(!a)return null;const r=t(a);return r?n&&!s(r)?null:u(r,e.props.chainIds):null}function g(e,t,s,a){const n=a?e[a]:e,o=null==n?void 0:n[t.props.name];return"FileInput"===t.type?o??null:function(e,t){switch(e.type){case"Checkbox":return e.props.checked;case"AssetSelector":return p(e.props.value,t.getAssetsState);case"AddressInput":{if(!e.props.value)return null;const{namespace:t,reference:s}=(0,i.parseCaipChainId)(e.props.chainId);return(0,i.toCaipAccountId)(t,s,e.props.value)}case"AccountSelector":return f(e,t);default:return e.props.value}}(t,s)??o??function(e,t){switch(e.type){case"Dropdown":var s;return null===(s=(0,r.getJsxChildren)(e)[0])||void 0===s?void 0:s.props.value;case"RadioGroup":var a;return null===(a=(0,r.getJsxChildren)(e)[0])||void 0===a?void 0:a.props.value;case"Selector":var n;return null===(n=(0,r.getJsxChildren)(e)[0])||void 0===n?void 0:n.props.value;case"AccountSelector":return h(e,t);case"Checkbox":return!1;case"AssetSelector":return m(e.props.addresses,e.props.chainIds,t);default:return null}}(t,s)??null}s.isStatefulComponent=c,s.getJsxInterface=function(e){return(0,n.isJSXElementUnsafe)(e)?e:(0,r.getJsxElementFromComponent)(e)},s.assertNameIsUnique=l,s.isMatchingChainId=d,s.formatAccountSelectorStateValue=u,s.getDefaultAsset=m,s.getAccountSelectorDefaultStateValue=h,s.getAssetSelectorStateValue=p,s.getAccountSelectorStateValue=f,s.constructState=function(e,t,s){const a={},n=[];return(0,r.walkJsx)(t,(t,r)=>{let i=n[n.length-1];if(i&&r<=i.depth&&(n.pop(),i=n[n.length-1]),"Form"===t.type)return l(a,t.props.name),n.push({name:t.props.name,depth:r}),void(a[t.props.name]={});if(i&&c(t)){const n=a[i.name];return l(n,t.props.name),void(n[t.props.name]=g(e,t,s,i.name))}c(t)&&(l(a,t.props.name),a[t.props.name]=g(e,t,s))}),a};const b=5e6;s.validateInterfaceContext=function(e){if(!e)return;const t=(0,r.getJsonSizeUnsafe)(e);(0,a.assert)(t<=b,"A Snap interface context may not be larger than 5 MB.")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs"}],[2488,{"@metamask/snaps-utils":2712,"@metamask/utils":2835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.log=void 0;const a=e("@metamask/snaps-utils"),n=e("@metamask/utils");s.log=(0,n.createModuleLogger)(a.snapsLogger,"snaps-controllers")}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/logging.cjs"}],[2489,{"../snaps/index.cjs":2502,"@metamask/rpc-errors":2423,"@metamask/snaps-rpc-methods":2542,"@metamask/snaps-utils":2712,"@metamask/utils":2835,nanoid:4744},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){n(e,t),t.set(e,s)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.MultichainRouter=void 0;const l=e("@metamask/rpc-errors"),d=e("@metamask/snaps-rpc-methods"),u=e("@metamask/snaps-utils"),m=e("@metamask/utils"),h=e("nanoid"),p=e("../snaps/index.cjs"),f="MultichainRouter";var g=new WeakMap,b=new WeakMap,y=new WeakSet;async function w(e,t,s){try{const a=await i(b,this).call(this,async({keyring:a})=>a.resolveAccountAddress(e,t,s)),n=null==a?void 0:a.address;return n?(0,m.parseCaipAccountId)(n).address:null}catch{throw l.rpcErrors.internal()}}async function v(e,t,s){const a=i(g,this).call("AccountsController:listMultichainAccounts",t).filter(e=>{var t;return Boolean(null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled)&&e.methods.includes(s.method)});if(0===a.length)return null;const n=a[0].metadata.snap.id,r=await c(y,this,w).call(this,n,t,s),o=e.map(e=>(0,m.parseCaipAccountId)(e).address),d=a.find(e=>o.includes(e.address)&&(!r||e.address===r));if(!d)throw l.rpcErrors.invalidParams({message:"No available account found for request."});return d.id}function S(e){const t=i(g,this).call("SnapController:getAll");return(0,p.getRunnableSnaps)(t).reduce((t,s)=>{const a=i(g,this).call("PermissionController:getPermissions",s.id);if(a&&(0,m.hasProperty)(a,d.SnapEndowments.Protocol)){const n=a[d.SnapEndowments.Protocol],r=(0,d.getProtocolCaveatScopes)(n);r&&(0,m.hasProperty)(r,e)&&t.push({snapId:s.id,methods:r[e].methods})}return t},[])}function E(e){return i(g,this).call("AccountsController:listMultichainAccounts",e).filter(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})}s.MultichainRouter=class{constructor({messenger:e,withSnapKeyring:t}){var s,c;n(s=this,c=y),c.add(s),r(this,"name",f),r(this,"state",null),a(this,g,void 0),a(this,b,void 0),o(g,this,e),o(b,this,t),i(g,this).registerActionHandler(`${f}:handleRequest`,async(...e)=>this.handleRequest(...e)),i(g,this).registerActionHandler(`${f}:getSupportedMethods`,(...e)=>this.getSupportedMethods(...e)),i(g,this).registerActionHandler(`${f}:getSupportedAccounts`,(...e)=>this.getSupportedAccounts(...e)),i(g,this).registerActionHandler(`${f}:isSupportedScope`,(...e)=>this.isSupportedScope(...e))}async handleRequest({connectedAddresses:e,origin:t,scope:s,request:a}){(0,m.assert)(!s.startsWith(m.KnownCaipNamespace.Eip155)&&!s.startsWith("wallet:eip155"));const n={jsonrpc:"2.0",id:a.id??(0,h.nanoid)(),method:a.method,...a.params?{params:a.params}:{}},{method:r,params:o}=n,d=await c(y,this,v).call(this,e,s,n);if(d)return i(b,this).call(this,async({keyring:e})=>e.submitRequest({origin:t,account:d,scope:s,method:r,params:o}));const p=c(y,this,S).call(this,s).find(e=>e.methods.includes(r));if(p)return i(g,this).call("SnapController:handleRequest",{snapId:p.snapId,origin:t,request:{method:"",params:{request:n,scope:s}},handler:u.HandlerType.OnProtocolRequest});throw l.rpcErrors.methodNotFound()}getSupportedMethods(e){const t=c(y,this,E).call(this,e).flatMap(e=>e.methods),s=c(y,this,S).call(this,e).flatMap(e=>e.methods);return Array.from(new Set([...t,...s]))}getSupportedAccounts(e){return c(y,this,E).call(this,e).map(t=>`${e}:${t.address}`)}isSupportedScope(e){return i(g,this).call("AccountsController:listMultichainAccounts",e).some(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})||c(y,this,S).call(this,e).length>0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"}],[249,{"./contracts/registry":247,"./contracts/resolver":248,"@ensdomains/content-hash":605,"@ethersproject/contracts":693,"@ethersproject/providers":731,"eth-ens-namehash":4002},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.default=async function({provider:e,name:t}){const s=a.default.hash(t),l=Number.parseInt(await e.request({method:"net_version"}),10),u=function(e){switch(e){case 1:case 3:case 4:case 5:case 6:return"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";default:return null}}(l);if(!u)throw new Error(`EnsIpfsResolver - no known ens-ipfs registry for chainId "${l}"`);const m=new r.Web3Provider(e),h=new i.Contract(u,o.default,m),p=await h.resolver(s);if(d(p))throw new Error(`EnsIpfsResolver - no resolver found for name "${t}"`);const f=new i.Contract(p,c.default,m),g=await f.supportsInterface("0xbc1c58d1"),b=await f.supportsInterface("0xd8389dc5");if(g){const e=await f.contenthash(s);let t=n.default.decode(e);const a=n.default.getCodec(e);return"ipfs-ns"!==a&&"ipns-ns"!==a||(t=n.default.helpers.cidV0ToV1Base32(t)),{type:a,hash:t}}if(b){const e=await f.content(s);if(d(e))throw new Error(`EnsIpfsResolver - no content ID found for name "${t}"`);return{type:"swarm-ns",hash:e.slice(2)}}throw new Error(`EnsIpfsResolver - the resolver for name "${t}" is not standard, it should either supports contenthash() or content()`)};var a=l(e("eth-ens-namehash")),n=l(e("@ensdomains/content-hash")),r=e("@ethersproject/providers"),i=e("@ethersproject/contracts"),o=l(e("./contracts/registry")),c=l(e("./contracts/resolver"));function l(e){return e&&e.__esModule?e:{default:e}}function d(e){return[undefined,null,"0x","0x0","0x0000000000000000000000000000000000000000000000000000000000000000"].includes(e)}}}},{package:"$root$",file:"app/scripts/lib/ens-ipfs/resolver.js"}],[2490,{"./MultichainRouter.cjs":2489},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./MultichainRouter.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs"}],[2491,{"../logging.cjs":2488,"../snaps/Timer.cjs":2500,"../utils.cjs":2512,"@metamask/json-rpc-engine":1985,"@metamask/json-rpc-middleware-stream":1989,"@metamask/object-multiplex":2290,"@metamask/rpc-errors":2423,"@metamask/snaps-utils":2712,"@metamask/utils":2835,nanoid:4744,"readable-stream":5003},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){n(e,t),t.set(e,s)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var l=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.setupMultiplex=s.AbstractExecutionService=void 0;const d=e("@metamask/json-rpc-engine"),u=e("@metamask/json-rpc-middleware-stream"),m=l(e("@metamask/object-multiplex")),h=e("@metamask/rpc-errors"),p=e("@metamask/snaps-utils"),f=e("@metamask/utils"),g=e("nanoid"),b=e("readable-stream"),y=e("../logging.cjs"),w=e("../snaps/Timer.cjs"),v=e("../utils.cjs"),S="ExecutionService";var E=new WeakMap,k=new WeakMap,T=new WeakMap,P=new WeakMap,_=new WeakMap,M=new WeakMap,x=new WeakMap,C=new WeakMap,I=new WeakSet;function A(){i(P,this).registerActionHandler(`${S}:handleRpcRequest`,async(e,t)=>this.handleRpcRequest(e,t)),i(P,this).registerActionHandler(`${S}:executeSnap`,async e=>this.executeSnap(e)),i(P,this).registerActionHandler(`${S}:terminateSnap`,async e=>this.terminateSnap(e)),i(P,this).registerActionHandler(`${S}:terminateAllSnaps`,async()=>this.terminateAllSnaps())}async function N(e,t){const{streams:s,worker:a}=await c(I,this,j).call(this,e,t),n=new d.JsonRpcEngine,r=(0,u.createStreamMiddleware)();(0,b.pipeline)(r.stream,s.command,r.stream,e=>{var t;!e||null!==(t=e.message)&&void 0!==t&&t.match("Premature close")||(0,p.logError)("Command stream failure.",e)}),n.push(r.middleware);const o={id:e,streams:s,rpcEngine:n,worker:a};return i(E,this).set(e,o),o}async function j(e,t){const s=await(0,v.withTimeout)(this.initEnvStream(e),t);if(s===v.hasTimedOut){this.terminateJob({id:e});if("created"===i(k,this).get(e))throw new Error(`The executor for "${e}" couldn't start initialization. The offscreen document may not exist.`);throw new Error(`The executor for "${e}" failed to initialize. The iframe/webview/worker failed to load.`)}const{worker:a,stream:n}=s,r=R(n,`Snap: "${e}"`),o=r.createStream(p.SNAP_STREAM_NAMES.COMMAND),c=t=>{(0,f.hasProperty)(t,"id")||("OutboundRequest"===t.method?i(P,this).publish("ExecutionService:outboundRequest",e):"OutboundResponse"===t.method?i(P,this).publish("ExecutionService:outboundResponse",e):"UnhandledError"===t.method?(i(P,this).publish("ExecutionService:unhandledError",e,t.params.error),o.removeListener("data",c)):(0,p.logError)(new Error(`Received unexpected command stream notification "${t.method}".`)))};o.on("data",c);const l=r.createStream(p.SNAP_STREAM_NAMES.JSON_RPC);l.on("data",t=>{null!=t&&t.data&&(0,f.hasProperty)(null==t?void 0:t.data,"id")&&i(P,this).publish("ExecutionService:outboundRequest",e)});const d=l.write.bind(l);return l.write=(t,s,a)=>{var n;return"metamask_chainChanged"===(null==t||null===(n=t.data)||void 0===n?void 0:n.method)||(null!=t&&t.data&&(0,f.hasProperty)(null==t?void 0:t.data,"id")&&i(P,this).publish("ExecutionService:outboundResponse",e),d(t,s,a))},{streams:{command:o,rpc:l,_connection:n},worker:a}}async function O(e,t){const s=i(E,this).get(e);if(!s)throw new Error(`"${e}" is not currently running.`);(0,y.log)("Parent: Sending Command",t);const a=await s.rpcEngine.handle(t);if((0,f.hasProperty)(a,"error")){const e=a.error;throw new h.JsonRpcError(e.code,e.message,e.data)}return a.result}function R(e,t){const s=new m.default;return(0,b.pipeline)(e,s,e,e=>{var s;!e||null!==(s=e.message)&&void 0!==s&&s.match("Premature close")||(0,p.logError)(`"${t}" stream failure.`,e)}),s}s.AbstractExecutionService=class{constructor({setupSnapProvider:e,messenger:t,initTimeout:s=(0,f.inMilliseconds)(60,f.Duration.Second),pingTimeout:i=(0,f.inMilliseconds)(2,f.Duration.Second),terminationTimeout:l=(0,f.inMilliseconds)(1,f.Duration.Second),usePing:d=!0}){var u,m;n(u=this,m=I),m.add(u),r(this,"name",S),r(this,"state",null),a(this,E,void 0),a(this,k,void 0),a(this,T,void 0),a(this,P,void 0),a(this,_,void 0),a(this,M,void 0),a(this,x,void 0),a(this,C,void 0),o(E,this,new Map),o(k,this,new Map),o(T,this,e),o(P,this,t),o(_,this,s),o(M,this,i),o(x,this,l),o(C,this,d),c(I,this,A).call(this)}async terminateSnap(e){const t=i(E,this).get(e);if(t){try{const t=await(0,v.withTimeout)(c(I,this,O).call(this,e,{jsonrpc:"2.0",method:"terminate",params:[],id:(0,g.nanoid)()}),i(x,this));t!==v.hasTimedOut&&"OK"===t||(0,p.logWarning)(`Snap "${e}" failed to terminate gracefully.`)}catch{}Object.values(t.streams).forEach(e=>{try{e.destroyed||e.destroy()}catch(e){(0,p.logError)("Error while destroying stream",e)}}),this.terminateJob(t),i(E,this).delete(e),i(k,this).delete(e),(0,y.log)(`Snap "${e}" terminated.`)}}setSnapStatus(e,t){i(k,this).set(e,t)}async terminateAllSnaps(){await Promise.all([...i(E,this).keys()].map(async e=>this.terminateSnap(e)))}async executeSnap({snapId:e,sourceCode:t,endowments:s}){if(i(E,this).has(e))throw new Error(`"${e}" is already running.`);this.setSnapStatus(e,"created");const a=new w.Timer(i(_,this)),n=await c(I,this,N).call(this,e,a);if(i(C,this)){if(await(0,v.withTimeout)(c(I,this,O).call(this,n.id,{jsonrpc:"2.0",method:"ping",id:(0,g.nanoid)()}),i(M,this))===v.hasTimedOut)throw new Error(`The executor for "${e}" was unreachable. The executor did not respond in time.`)}const r=n.streams.rpc;i(T,this).call(this,e,r);const o=Math.max(a.remaining,i(_,this)/2);this.setSnapStatus(e,"initialized");const l={jsonrpc:"2.0",method:"executeSnap",params:{snapId:e,sourceCode:t,endowments:s},id:(0,g.nanoid)()};(0,f.assertIsJsonRpcRequest)(l),this.setSnapStatus(e,"executing");const d=await(0,v.withTimeout)(c(I,this,O).call(this,n.id,l),o);if(d===v.hasTimedOut)throw new Error(`${e} failed to start.`);return"OK"===d&&this.setSnapStatus(e,"running"),d}async handleRpcRequest(e,t){const{handler:s,request:a,origin:n}=t;return await c(I,this,O).call(this,e,{id:(0,g.nanoid)(),jsonrpc:"2.0",method:"snapRpc",params:{origin:n,handler:s,request:a,target:e}})}},s.setupMultiplex=R}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs"}],[2492,{"@metamask/post-message-stream":2324},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){n(e,t),t.set(e,s)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,s){return e.set(o(e,t),s),s}function o(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.ProxyPostMessageStream=void 0;const c=e("@metamask/post-message-stream");var l=new WeakMap,d=new WeakMap,u=new WeakSet;class m extends c.BasePostMessageStream{constructor({stream:e,jobId:t}){var s,c;super(),n(s=this,c=u),c.add(s),a(this,l,void 0),a(this,d,void 0),i(l,this,e),i(d,this,t),r(l,this).on("data",o(u,this,h).bind(this))}_postMessage(e){r(l,this).write({jobId:r(d,this),data:e})}}function h(e){e.jobId===r(d,this)&&this.push(e.data)}s.ProxyPostMessageStream=m}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs"}],[2493,{"../AbstractExecutionService.cjs":2491,"@metamask/post-message-stream":2324,"@metamask/snaps-utils":2712},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var a=s.call(e,t||"default");if("object"!=typeof a)return a;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.IframeExecutionService=void 0;const n=e("@metamask/post-message-stream"),r=e("@metamask/snaps-utils"),i=e("../AbstractExecutionService.cjs");class o extends i.AbstractExecutionService{constructor({iframeUrl:e,messenger:t,setupSnapProvider:s,...n}){super({...n,messenger:t,setupSnapProvider:s}),a(this,"iframeUrl",void 0),this.iframeUrl=e}terminateJob(e){var t;null===(t=document.getElementById(e.id))||void 0===t||t.remove()}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=await(0,r.createWindow)({uri:this.iframeUrl.toString(),id:e});return{worker:t,stream:new n.WindowPostMessageStream({name:"parent",target:"child",targetWindow:t,targetOrigin:"*"})}}}s.IframeExecutionService=o}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"}],[2494,{"./IframeExecutionService.cjs":2493},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./IframeExecutionService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs"}],[2495,{"./AbstractExecutionService.cjs":2491,"./ProxyPostMessageStream.cjs":2492,"./iframe/index.cjs":2494,"./offscreen/index.cjs":2497},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./AbstractExecutionService.cjs"),s),n(e("./ProxyPostMessageStream.cjs"),s),n(e("./iframe/index.cjs"),s),n(e("./offscreen/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/index.cjs"}],[2496,{"../proxy/ProxyExecutionService.cjs":2498,"@metamask/post-message-stream":2324},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function n(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.OffscreenExecutionService=void 0;const r=e("@metamask/post-message-stream"),i=e("../proxy/ProxyExecutionService.cjs");var o=new WeakMap;class c extends i.ProxyExecutionService{constructor({messenger:e,setupSnapProvider:t,offscreenPromise:s,...i}){var c,l,d;super({...i,messenger:e,setupSnapProvider:t,stream:new r.BrowserRuntimePostMessageStream({name:"parent",target:"child"})}),a(this,o,void 0),l=this,d=s,(c=o).set(n(c,l),d)}async initEnvStream(e){var t,s;return await(t=o,s=this,t.get(n(t,s))),await super.initEnvStream(e)}}s.OffscreenExecutionService=c}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"}],[2497,{"./OffscreenExecutionService.cjs":2496},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var a=Object.create?function(e,t,s,a){a===undefined&&(a=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,n)}:function(e,t,s,a){a===undefined&&(a=s),e[a]=t[s]},n=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||a(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./OffscreenExecutionService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"}],[2498,{"../AbstractExecutionService.cjs":2491,"../ProxyPostMessageStream.cjs":2492,nanoid:4744},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function a(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function n(e,t){return e.get(r(e,t))}function r(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.ProxyExecutionService=void 0;const i=e("nanoid"),o=e("../AbstractExecutionService.cjs"),c=e("../ProxyPostMessageStream.cjs");var l=new WeakMap;class d extends o.AbstractExecutionService{constructor({stream:e,messenger:t,setupSnapProvider:s,...n}){var i,o,c;super({...n,messenger:t,setupSnapProvider:s,usePing:!1}),a(this,l,void 0),o=this,c=e,(i=l).set(r(i,o),c)}async terminateJob(e){n(l,this).write({jobId:e.id,data:{jsonrpc:"2.0",method:"terminateJob",id:(0,i.nanoid)()}})}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=new c.ProxyPostMessageStream({stream:n(l,this),jobId:e});return await new Promise(e=>{t.once("data",e),t.write({name:"command",data:{jsonrpc:"2.0",method:"ping",id:(0,i.nanoid)()}})}),{worker:e,stream:t}}}s.ProxyExecutionService=d}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs"}]],[],{});