LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js",{"./build/multichain-openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json","./build/openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.MultiChainOpenRPCDocument=s.MetaMaskOpenRPCDocument=void 0;const a=n(e("./build/openrpc.json"));s.MetaMaskOpenRPCDocument=a.default;const r=n(e("./build/multichain-openrpc.json"));s.MultiChainOpenRPCDocument=r.default,s.default=a.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/constants.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.NetworkEnablementController=void 0;const l=e("@metamask/base-controller"),m=e("@metamask/controller-utils"),d=e("@metamask/keyring-api"),u=e("@metamask/utils"),h=e("./constants.cjs"),p=e("./utils.cjs"),f={enabledNetworkMap:{includeInStateLogs:!0,persist:!0,anonymous:!0,usedInUi:!0}};class g extends l.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:f,name:"NetworkEnablementController",state:{enabledNetworkMap:{[u.KnownCaipNamespace.Eip155]:{[m.ChainId[m.BuiltInNetworkName.Mainnet]]:!0,[m.ChainId[m.BuiltInNetworkName.LineaMainnet]]:!0,[m.ChainId[m.BuiltInNetworkName.BaseMainnet]]:!0},[u.KnownCaipNamespace.Solana]:{[d.SolScope.Mainnet]:!0,[d.SolScope.Testnet]:!1,[d.SolScope.Devnet]:!1},[u.KnownCaipNamespace.Bip122]:{[d.BtcScope.Mainnet]:!0,[d.BtcScope.Testnet]:!1,[d.BtcScope.Signet]:!1},[u.KnownCaipNamespace.Tron]:{[d.TrxScope.Mainnet]:!0,[d.TrxScope.Nile]:!1,[d.TrxScope.Shasta]:!1}},...t}}),n.add(this),e.subscribe("NetworkController:networkAdded",({chainId:e})=>{c(this,n,"m",o).call(this,e)}),e.subscribe("NetworkController:networkRemoved",({chainId:e})=>{c(this,n,"m",i).call(this,e)})}enableNetwork(e){const{namespace:t,storageKey:s}=(0,p.deriveKeys)(e);this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})}),e.enabledNetworkMap[t]&&(e.enabledNetworkMap[t][s]=!0)})}enableNetworkInNamespace(e,t){const{namespace:s,storageKey:r}=(0,p.deriveKeys)(e);if(s!==t)throw new Error(`Chain ID ${e} belongs to namespace ${s}, but namespace ${t} was specified`);this.update(e=>{c(this,n,"m",a).call(this,e,t),e.enabledNetworkMap[t]&&Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1}),e.enabledNetworkMap[t][r]=!0})}enableAllPopularNetworks(){this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})});const t=this.messagingSystem.call("NetworkController:getState"),s=this.messagingSystem.call("MultichainNetworkController:getState");h.POPULAR_NETWORKS.forEach(s=>{const{namespace:r,storageKey:i}=(0,p.deriveKeys)(s);t.networkConfigurationsByChainId[s]&&(c(this,n,"m",a).call(this,e,r),e.enabledNetworkMap[r][i]=!0)});const r=(0,p.deriveKeys)(d.SolScope.Mainnet);s.multichainNetworkConfigurationsByChainId[d.SolScope.Mainnet]&&(c(this,n,"m",a).call(this,e,r.namespace),e.enabledNetworkMap[r.namespace][r.storageKey]=!0);const i=(0,p.deriveKeys)(d.BtcScope.Mainnet);s.multichainNetworkConfigurationsByChainId[d.BtcScope.Mainnet]&&(c(this,n,"m",a).call(this,e,i.namespace),e.enabledNetworkMap[i.namespace][i.storageKey]=!0);const o=(0,p.deriveKeys)(d.TrxScope.Mainnet);s.multichainNetworkConfigurationsByChainId[d.TrxScope.Mainnet]&&(c(this,n,"m",a).call(this,e,o.namespace),e.enabledNetworkMap[o.namespace][o.storageKey]=!0)})}init(){this.update(e=>{const t=this.messagingSystem.call("NetworkController:getState"),s=this.messagingSystem.call("MultichainNetworkController:getState");Object.keys(t.networkConfigurationsByChainId).forEach(t=>{const{namespace:s,storageKey:r}=(0,p.deriveKeys)(t);c(this,n,"m",a).call(this,e,s),e.enabledNetworkMap[s][r]===undefined&&(e.enabledNetworkMap[s][r]=!1)}),Object.keys(s.multichainNetworkConfigurationsByChainId).forEach(t=>{const{namespace:s,storageKey:r}=(0,p.deriveKeys)(t);c(this,n,"m",a).call(this,e,s),e.enabledNetworkMap[s][r]===undefined&&(e.enabledNetworkMap[s][r]=!1)})})}disableNetwork(e){const t=(0,p.deriveKeys)(e),{namespace:s,storageKey:n}=t;this.update(e=>{e.enabledNetworkMap[s][n]=!1})}isNetworkEnabled(e){const t=(0,p.deriveKeys)(e),{namespace:s,storageKey:n}=t;return this.state.enabledNetworkMap[s]?.[n]??!1}}s.NetworkEnablementController=g,n=new WeakSet,a=function(e,t){e.enabledNetworkMap[t]||(e.enabledNetworkMap[t]={})},r=function(){const e=this.messagingSystem.call("NetworkController:getState");return h.POPULAR_NETWORKS.reduce((t,s)=>{if(!e.networkConfigurationsByChainId[s])return t;const{namespace:n,storageKey:a}=(0,p.deriveKeys)(s),r=this.state.enabledNetworkMap[n]?.[a];return r?t+1:t},0)>1},i=function(e){const t=(0,p.deriveKeys)(e),{namespace:s,storageKey:n}=t;this.update(e=>{(0,p.isOnlyNetworkEnabledInNamespace)(this.state,t)&&(e.enabledNetworkMap[s][m.ChainId[m.BuiltInNetworkName.Mainnet]]=!0),s in e.enabledNetworkMap&&delete e.enabledNetworkMap[s][n]})},o=function(e){const{namespace:t,storageKey:s,reference:i}=(0,p.deriveKeys)(e);this.update(e=>{c(this,n,"m",a).call(this,e,t);const o=c(this,n,"m",r).call(this),l=(0,p.isPopularNetwork)(i);o&&l||Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(s=>{e.enabledNetworkMap[t][s]=!1})}),e.enabledNetworkMap[t][s]=!0})}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.POPULAR_NETWORKS=void 0,s.POPULAR_NETWORKS=["0x1","0xe708","0x2105","0xa4b1","0xa86a","0x38","0xa","0x89","0x531","0x144","0x2a15c308d","0x3e7"]}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/index.cjs",{"./NetworkEnablementController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.selectEnabledSolanaNetworks=s.selectEnabledEvmNetworks=s.selectEnabledNetworksCount=s.selectAllEnabledNetworks=s.createSelectorForEnabledNetworksForNamespace=s.selectIsNetworkEnabled=s.selectEnabledNetworkMap=s.NetworkEnablementController=void 0;var n=e("./NetworkEnablementController.cjs");Object.defineProperty(s,"NetworkEnablementController",{enumerable:!0,get:function(){return n.NetworkEnablementController}});var a=e("./selectors.cjs");Object.defineProperty(s,"selectEnabledNetworkMap",{enumerable:!0,get:function(){return a.selectEnabledNetworkMap}}),Object.defineProperty(s,"selectIsNetworkEnabled",{enumerable:!0,get:function(){return a.selectIsNetworkEnabled}}),Object.defineProperty(s,"createSelectorForEnabledNetworksForNamespace",{enumerable:!0,get:function(){return a.createSelectorForEnabledNetworksForNamespace}}),Object.defineProperty(s,"selectAllEnabledNetworks",{enumerable:!0,get:function(){return a.selectAllEnabledNetworks}}),Object.defineProperty(s,"selectEnabledNetworksCount",{enumerable:!0,get:function(){return a.selectEnabledNetworksCount}}),Object.defineProperty(s,"selectEnabledEvmNetworks",{enumerable:!0,get:function(){return a.selectEnabledEvmNetworks}}),Object.defineProperty(s,"selectEnabledSolanaNetworks",{enumerable:!0,get:function(){return a.selectEnabledSolanaNetworks}})}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/selectors.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",reselect:"/home/runner/work/metamask-extension/metamask-extension/node_modules/reselect/dist/cjs/reselect.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.selectEnabledSolanaNetworks=s.selectEnabledEvmNetworks=s.selectEnabledNetworksCount=s.selectAllEnabledNetworks=s.createSelectorForEnabledNetworksForNamespace=s.selectIsNetworkEnabled=s.selectEnabledNetworkMap=void 0;const n=e("@metamask/utils"),a=e("reselect"),r=e("./utils.cjs");s.selectEnabledNetworkMap=e=>e.enabledNetworkMap;s.selectIsNetworkEnabled=e=>(0,a.createSelector)(s.selectEnabledNetworkMap,t=>{const{namespace:s,storageKey:n}=(0,r.deriveKeys)(e);return s in t&&n in t[s]&&t[s][n]});s.createSelectorForEnabledNetworksForNamespace=e=>(0,a.createSelector)(s.selectEnabledNetworkMap,t=>Object.entries(t[e]??{}).filter(([,e])=>e).map(([e])=>e)),s.selectAllEnabledNetworks=(0,a.createSelector)(s.selectEnabledNetworkMap,e=>Object.keys(e).reduce((t,s)=>(t[s]=Object.entries(e[s]).filter(([,e])=>e).map(([e])=>e),t),{})),s.selectEnabledNetworksCount=(0,a.createSelector)(s.selectAllEnabledNetworks,e=>Object.values(e).flat().length),s.selectEnabledEvmNetworks=(0,a.createSelector)((0,s.createSelectorForEnabledNetworksForNamespace)(n.KnownCaipNamespace.Eip155),e=>e),s.selectEnabledSolanaNetworks=(0,a.createSelector)((0,s.createSelectorForEnabledNetworksForNamespace)(n.KnownCaipNamespace.Solana),e=>e)}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/utils.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/constants.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/multichain-network-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-network-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isPopularNetwork=s.isOnlyNetworkEnabledInNamespace=s.deriveKeys=void 0;const n=e("@metamask/controller-utils"),a=e("@metamask/multichain-network-controller"),r=e("@metamask/utils"),i=e("./constants.cjs");s.deriveKeys=function(e){const t=(0,r.isCaipChainId)(e)?e:(0,a.toEvmCaipChainId)(e),{namespace:s,reference:i}=(0,r.parseCaipChainId)(t);let o;return o=s===r.KnownCaipNamespace.Eip155?(0,r.isHexString)(e)?e:(0,n.toHex)(i):t,{namespace:s,storageKey:o,caipChainId:t,reference:i}},s.isOnlyNetworkEnabledInNamespace=function(e,t){const{namespace:s,storageKey:n}=t;if(!e.enabledNetworkMap[s])return!1;const a=e.enabledNetworkMap[s],r=Object.entries(a).filter(([e,t])=>t);if(1===r.length){const[e]=r[0];return e===n}return!1},s.isPopularNetwork=function(e){try{return i.POPULAR_NETWORKS.includes((0,n.toHex)(e))}catch{return!1}}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs",{"./push-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=void 0;var n=e("./push-utils.cjs");Object.defineProperty(s,"createRegToken",{enumerable:!0,get:function(){return n.createRegToken}}),Object.defineProperty(s,"deleteRegToken",{enumerable:!0,get:function(){return n.deleteRegToken}}),Object.defineProperty(s,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return n.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs",{"../../NotificationServicesController/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesController/index.cjs","../../shared/to-raw-notification.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/shared/to-raw-notification.cjs","firebase/app":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/app/dist/esm/index.esm.js","firebase/messaging":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/messaging/dist/esm/index.esm.js","firebase/messaging/sw":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/messaging/sw/dist/esm/index.esm.js",loglevel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/loglevel/lib/loglevel.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=s.supportedCache=void 0;const a=e("firebase/app"),r=e("firebase/messaging"),i=e("firebase/messaging/sw"),o=n(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),l=e("../../shared/to-raw-notification.cjs");s.supportedCache=null;const m=async e=>{if(!await(async()=>(s.supportedCache??(s.supportedCache=await(0,i.isSupported)()),s.supportedCache))())return null;const t=await(async e=>{try{return(0,a.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,a.initializeApp)(t)}})(e);return(0,i.getMessaging)(t)};s.createRegToken=async function(e){try{const t=await m(e);if(!t)return null;return await(0,r.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},s.deleteRegToken=async function(e){try{const t=await m(e);return!t||(await(0,r.deleteToken)(t),!0)}catch{return!1}},s.createSubscribeToPushNotifications=function(e){return async function(t){const s=await async function(e,t){const s=await m(e);if(!s)return null;const n=(0,i.onBackgroundMessage)(s,async e=>{try{const s=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!s)return;const n=(0,l.toRawOnChainNotification)(s),a=c.Processors.processNotification(n);await t(a)}catch(t){throw o.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}});return()=>n()}(t,async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)}),n=function(e){const t=t=>{const s=t?.notification?.data;e(t,s)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}((t,s)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",s),e.onClickHandler(t,s)});return()=>{s?.(),n()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ComposedStore.js",{"./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ComposedStore=void 0;const n=e("./ObservableStore");class a extends n.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach(e=>{const t=this._children[e];this._addChild(e,t)})}_addChild(e,t){const s=t=>{const s=this.getState();s[e]=t,this.putState(s)};t.subscribe(s),s(t.getState())}}s.ComposedStore=a}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/MergedStore.js",{"./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MergedStore=void 0;const n=e("./ObservableStore");class a extends n.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach(e=>this._addChild(e)),this._updateWholeState()}_addChild(e){e.subscribe(()=>this._updateWholeState())}_updateWholeState(){const e=this._children.map(e=>e.getState()),t=Object.assign({},...e);this.putState(t)}}s.MergedStore=a}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js",{"@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.ObservableStore=void 0;const a=n(e("@metamask/safe-event-emitter"));class r extends a.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}s.ObservableStore=r}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/asStream.js",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeAsStream=void 0;const n=e("readable-stream");class a extends n.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const s=super.pipe(e,t);return e.write(this.obsStore.getState()),s}_write(e,t,s){this.obsStore.putState(e),s()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}s.storeAsStream=function(e){return new a(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/index.js",{"./ComposedStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ComposedStore.js","./MergedStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/MergedStore.js","./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js","./asStream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/asStream.js","./transform":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/transform.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s),Object.defineProperty(e,n,{enumerable:!0,get:function(){return t[s]}})}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./asStream"),s),a(e("./ComposedStore"),s),a(e("./MergedStore"),s),a(e("./ObservableStore"),s),a(e("./transform"),s)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/transform.js",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeTransformStream=void 0;const n=e("readable-stream");s.storeTransformStream=function(e){return new n.Transform({objectMode:!0,transform:(t,s,n)=>{try{const s=e(t);return n(undefined,s),undefined}catch(e){return n(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs",{"./enums.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/enums.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l,m,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PermissionLogController=void 0;const p=e("@metamask/base-controller"),f=e("@metamask/utils"),g=e("./enums.cjs"),b={permissionHistory:{},permissionActivityLog:[]};class k extends p.BaseController{constructor({messenger:e,restrictedMethods:t,state:s}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{persist:!0,anonymous:!1},permissionActivityLog:{persist:!1,anonymous:!1}},state:{...b,...s}}),n.add(this),a.set(this,void 0),u(this,a,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const s={eth_accounts:{accounts:h(this,n,"m",r).call(this,t,Date.now())}};h(this,n,"m",l).call(this,e,s)}createMiddleware(){return(e,t,s)=>{const{origin:r,method:l}=e,d=l.startsWith(g.WALLET_PREFIX),u="eth_requestAccounts"===l;if(!g.LOG_IGNORE_METHODS.includes(l)&&(d||h(this,a,"f").has(l))||u){const a=h(this,n,"m",i).call(this,e,d),l=h(this,n,"m",m).call(this,e);return void s(e=>{const s=Date.now();h(this,n,"m",o).call(this,a,t,s),l&&!t.error&&t.result&&r&&h(this,n,"m",c).call(this,l,r,t.result,s,u),e()})}s()}}}s.PermissionLogController=k,a=new WeakMap,n=new WeakSet,r=function(e,t){return e.reduce((e,s)=>({...e,[s]:t}),{})},i=function(e,t){const s={id:e.id,method:e.method,methodType:t?g.LOG_METHOD_TYPES.internal:g.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update(e=>{const t=[...e.permissionActivityLog,s];e.permissionActivityLog=t.length>g.LOG_LIMIT?t.slice(1):t}),s},o=function(e,t,s){e&&t&&this.update(n=>{n.permissionActivityLog=n.permissionActivityLog.map(n=>n.id===e.id?{...n,success:(0,f.hasProperty)(t,"result"),responseTime:s}:n)})},c=function(e,t,s,a,i){let o;if(i){const e=s;o={eth_accounts:{accounts:h(this,n,"m",r).call(this,e,a),lastApproved:a}}}else{o=s.reduce((t,s)=>{const i=s.parentCapability;if(!e.includes(i))return t;if("eth_accounts"===i){const e=h(this,n,"m",d).call(this,s);return{...t,[i]:{lastApproved:a,accounts:h(this,n,"m",r).call(this,e,a)}}}return{...t,[i]:{lastApproved:a}}},{})}Object.keys(o).length>0&&h(this,n,"m",l).call(this,t,o)},l=function(e,t){const{permissionHistory:s}=this.state,n=s[e]??{},a={...n,...t},r=n.eth_accounts,i=t.eth_accounts;if(r&&i){const e=i.lastApproved??r.lastApproved;a.eth_accounts={lastApproved:e,accounts:{...r.accounts,...i.accounts}}}this.update(t=>{t.permissionHistory={...s,[e]:a}})},m=function(e){const{method:t,params:s}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${g.WALLET_PREFIX}requestPermissions`&&s&&Array.isArray(s)&&s[0]&&"object"==typeof s[0]&&!Array.isArray(s[0])?Object.keys(s[0]):null},d=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const s of e.caveats)if(s.type===g.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(s.value))for(const e of s.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/enums.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n;Object.defineProperty(s,"__esModule",{value:!0}),s.LOG_LIMIT=s.LOG_METHOD_TYPES=s.LOG_IGNORE_METHODS=s.CAVEAT_TYPES=s.WALLET_PREFIX=void 0,s.WALLET_PREFIX="wallet_",s.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),s.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(n||(s.LOG_METHOD_TYPES=n={})),s.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/index.cjs",{"./PermissionLogController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./PermissionLogController.cjs"),s)}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/index.js",{"./ppom-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-controller.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;var n=e("./ppom-controller");Object.defineProperty(s,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return n.NETWORK_CACHE_DURATION}}),Object.defineProperty(s,"PPOMController",{enumerable:!0,get:function(){return n.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-controller.js",{"./ppom-storage":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-storage.js","./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/util.js","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","await-semaphore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/await-semaphore/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l,m,d,u,h,p,f,g,b,k,y,w,x,v,S,_,P,T,j,E,C,I,A,M,O,R,N=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},$=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;const L=e("@metamask/base-controller"),B=e("@metamask/controller-utils"),F=e("await-semaphore"),D=e("./ppom-storage"),H=e("./util");s.NETWORK_CACHE_DURATION=6048e5;const U=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],q={versionInfo:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1},storageMetadata:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1}},V="PPOMController",W={headers:{"Content-Type":"application/json"}};class G extends L.BaseController{constructor({chainId:e,messenger:t,provider:s,storageBackend:k,securityAlertsEnabled:y,onPreferencesChange:w,ppomProvider:_,cdnBaseUrl:P,providerRequestLimit:T,state:j,blockaidPublicKey:E,nativeCrypto:C}){super({name:V,metadata:q,messenger:t,state:{versionInfo:j?.versionInfo??[],storageMetadata:j?.storageMetadata??[]}}),n.add(this),a.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),m.set(this,void 0),d.set(this,0),u.set(this,void 0),h.set(this,void 0),p.set(this,{}),f.set(this,void 0),g.set(this,!1),b.set(this,undefined),N(this,u,(0,H.addHexPrefix)(e),"f"),N(this,r,s,"f"),N(this,c,_,"f"),N(this,i,new D.PPOMStorage({storageBackend:k,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update(t=>{t.storageMetadata=e})}}),"f"),N(this,o,new F.Mutex,"f"),N(this,l,P,"f"),N(this,m,T??300,"f"),N(this,h,y,"f"),N(this,f,E,"f"),N(this,b,C,"f"),w($(this,n,"m",x).bind(this)),$(this,n,"m",v).call(this),$(this,n,"m",S).call(this)}async usePPOM(e,t){const s=t??$(this,u,"f");if(!$(this,h,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,H.blockaidValidationSupportedForNetwork)(s))throw Error(`Blockaid validation not available on network with chainId: ${s}`);return await $(this,o,"f").use(async()=>{const t=await $(this,n,"m",P).call(this,s);N(this,d,0,"f"),N(this,p,{},"f");return{...await e(t),providerRequestsCount:{...$(this,p,"f")}}})}}s.PPOMController=G,a=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,m=new WeakMap,d=new WeakMap,u=new WeakMap,h=new WeakMap,p=new WeakMap,f=new WeakMap,g=new WeakMap,b=new WeakMap,n=new WeakSet,k=async function(){if($(this,h,"f")&&!$(this,g,"f")){const{ppomInit:e}=$(this,c,"f");await e("./ppom_bg.wasm"),N(this,g,!0,"f")}},y=function(){$(this,n,"m",_).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)});const{storageMetadata:e}=this.state;this.update(e=>{e.versionInfo=[],e.storageMetadata=[]}),$(this,i,"f").deleteAllFiles(e).catch(e=>{console.error(`Error in deleting files: ${e.message}`)})},w=function(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:s}=t.configuration,a=(0,H.addHexPrefix)(s);a!==$(this,u,"f")&&(N(this,u,a,"f"),$(this,n,"m",_).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)}))},x=function(e){const t=e.securityAlertsEnabled;t!==$(this,h,"f")&&(N(this,h,t,"f"),t||$(this,n,"m",y).call(this))},v=function(){this.messagingSystem.registerActionHandler(`${V}:usePPOM`,this.usePPOM.bind(this))},S=function(){const e=$(this,n,"m",w).bind(this);this.messagingSystem.subscribe("NetworkController:networkDidChange",e)},_=async function(){await $(this,o,"f").use(async()=>{$(this,a,"f")&&($(this,a,"f").free(),N(this,a,undefined,"f"))})},P=async function(e){const t=await $(this,n,"m",T).call(this);let s;return($(this,a,"f")===undefined||t)&&(s=await $(this,n,"m",R).call(this,e),$(this,u,"f")===e&&($(this,a,"f")&&$(this,a,"f").free(),N(this,a,s,"f")),$(this,i,"f").syncMetadata(this.state.versionInfo).catch(e=>{console.error(`Error while trying to sync metadata: ${e.message}`)})),s},T=async function(){const e=await $(this,n,"m",A).call(this);return!!e&&(this.update(t=>{t.versionInfo=e}),!0)},j=function(e,t){return e.find(e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum)},E=async function(e){const t=await Promise.all(e.map(async e=>{let t;try{t=await $(this,n,"m",C).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined}));return t?.filter(e=>e?.[1]!==undefined)},C=async function(e){const{storageMetadata:t}=this.state;if($(this,n,"m",j).call(this,t,e))try{return await $(this,i,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,H.checkFilePath)(e.filePath);const s=(0,H.constructURLHref)($(this,l,"f"),e.filePath),a=await $(this,n,"m",M).call(this,s);return await(0,H.validateSignature)(a,e.hashSignature,$(this,f,"f"),e.filePath,$(this,b,"f")),await $(this,i,"f").writeFile({data:a,...e}).catch(e=>{console.error(`Error in writing file: ${e.message}`)}),a},I=async function(e,t={},s="GET"){const n=await(0,B.safelyExecute)(async()=>(0,B.timeoutFetch)(e,{method:s,cache:"no-cache",redirect:"error",...t},1e4),!0),a=304===n?.status;if(!n?.status||n?.status<200||n?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:a,response:n}},A=async function(){const e=(0,H.constructURLHref)($(this,l,"f"),"ppom_version.json"),{cached:t,response:s}=await $(this,n,"m",I).call(this,e,{headers:W});return t&&this.state.versionInfo?.length?undefined:s.json()},M=async function(e){const{response:t}=await $(this,n,"m",I).call(this,e);return await t.arrayBuffer()},O=async function(e,t){if($(this,d,"f")>$(this,m,"f"))return H.PROVIDER_ERRORS.limitExceeded();if(N(this,d,$(this,d,"f")+1,"f"),!U.includes(e))return H.PROVIDER_ERRORS.methodNotSupported();$(this,p,"f")[e]=$(this,p,"f")[e]?Number($(this,p,"f")[e])+1:1;const s=(0,H.createPayload)(e,t);try{const e=await $(this,r,"f").request(s);return{jsonrpc:"2.0",id:s.id,result:e}}catch(e){return{jsonrpc:"2.0",id:s.id,error:e}}},R=async function(e){await $(this,n,"m",k).call(this);const t=this.state.versionInfo.filter(({chainId:t})=>t===e);if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const s=await $(this,n,"m",E).call(this,t);if(s?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:a}=$(this,c,"f");return a.new($(this,n,"m",O).bind(this),s)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-storage.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},o=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMStorage=void 0;s.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:s}){n.set(this,void 0),a.set(this,void 0),r.set(this,void 0),i(this,n,e,"f"),i(this,a,t,"f"),i(this,r,s,"f")}async syncMetadata(e){const t=o(this,a,"f").call(this),s=[];for(const n of t){try{await this.readFile(n.name,n.chainId)}catch(e){console.error("Error: ",e);continue}e.find(e=>e.name===n.name&&e.chainId===n.chainId&&e.version===n.version&&e.checksum===n.checksum)&&s.push(n)}const i=await o(this,n,"f").dir();for(const{name:e,chainId:t}of i)s.find(s=>s.name===e&&s.chainId===t)||await o(this,n,"f").delete({name:e,chainId:t});return o(this,r,"f").call(this,s),s}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:s}=t;try{await o(this,n,"f").delete({name:e,chainId:s})}catch(t){console.error(`Error in deleting file: ${e}, ${s}`,t)}}}async readFile(e,t){const s=o(this,a,"f").call(this).find(s=>s.name===e&&s.chainId===t);if(!s)throw new Error(`File metadata (${e}, ${t}) not found`);const r=await o(this,n,"f").read({name:e,chainId:t},s.checksum);if(!r)throw new Error(`Storage File (${e}, ${t}) not found`);return r}async writeFile({data:e,name:t,chainId:s,version:i,checksum:c}){await o(this,n,"f").write({name:t,chainId:s},e,c);const l=o(this,a,"f").call(this),m=l.find(e=>e.name===t&&e.chainId===s);m?(m.version=i,m.checksum=c):l.push({name:t,chainId:s,version:i,checksum:c}),o(this,r,"f").call(this,l)}},n=new WeakMap,a=new WeakMap,r=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/util.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","crypto-js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/crypto-js/index.js",elliptic:"/home/runner/work/metamask-extension/metamask-extension/node_modules/elliptic/lib/elliptic.js","json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),r=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&n(t,e,s);return a(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.checkFilePath=s.addHexPrefix=s.constructURLHref=s.validateSignature=s.PROVIDER_ERRORS=s.createPayload=s.IdGenerator=s.blockaidValidationSupportedForNetwork=s.SUPPORTED_NETWORK_CHAINIDS=void 0;const o=r(e("crypto-js")),c=i(e("elliptic")),l=i(e("json-rpc-random-id")),m=c.default.eddsa;s.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};s.blockaidValidationSupportedForNetwork=e=>Object.values(s.SUPPORTED_NETWORK_CHAINIDS).some(t=>t===e),s.IdGenerator=(0,l.default)();s.createPayload=(e,t)=>({id:(0,s.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),s.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};s.validateSignature=async(e,s,n,a,r,i)=>{const c=await(async(e,t,s=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&s){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map(e=>e.toString(16).padStart(2,"0")).join("")}return(0,o.SHA256)(o.default.lib.WordArray.create(e)).toString()})(e,r,i);if(!new m("ed25519").keyFromPublic(n).verify(t.from(c),s))throw Error(`Signature verification failed for file path: ${a}`)};s.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;s.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;s.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs",{"@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;const n=e("@metamask/base-controller"),a=e("@metamask/rpc-errors"),r=e("@metamask/utils"),i="RateLimitController",o={requests:{persist:!1,anonymous:!1}};class c extends n.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:s,state:n,implementations:a}){const c={requests:(0,r.getKnownPropertyNames)(a).reduce((e,t)=>({...e,[t]:{}}),{})};super({name:i,metadata:o,messenger:s,state:{...c,...n}}),this.implementations=a,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messagingSystem.registerActionHandler(`${i}:call`,(e,t,...s)=>this.call(e,t,...s))}async call(e,t,...s){if(this.isRateLimited(t,e))throw a.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const n=this.implementations[t].method;if(!n)throw new Error("Invalid api type");return n(...s)}isRateLimited(e,t){const s=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=s}recordRequest(e,t){const s=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,n=this.state.requests[e][t]??0;this.update(a=>{0===n&&setTimeout(()=>this.resetRequestCount(e,t),s),Object.assign(a,{requests:{...a.requests,[e]:{[t]:n+1}}})})}resetRequestCount(e,t){this.update(s=>{Object.assign(s,{requests:{...s.requests,[e]:{[t]:0}}})})}}s.RateLimitController=c}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/index.cjs",{"./RateLimitController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;var n=e("./RateLimitController.cjs");Object.defineProperty(s,"RateLimitController",{enumerable:!0,get:function(){return n.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},l=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ClientConfigApiService=void 0;const m=e("@metamask/controller-utils"),d=e("../constants.cjs");s.ClientConfigApiService=class{constructor({fetch:e,retries:t=m.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:s=m.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:d=m.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:u,onDegraded:h,config:p}){n.set(this,void 0),a.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c(this,n,e,"f"),c(this,r,p.client,"f"),c(this,i,p.distribution,"f"),c(this,o,p.environment,"f"),c(this,a,(0,m.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:s,circuitBreakDuration:d}),"f"),u&&l(this,a,"f").onBreak(u),h&&l(this,a,"f").onDegraded(h)}onBreak(...e){return l(this,a,"f").onBreak(...e)}onDegraded(...e){return l(this,a,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${d.BASE_URL}/flags?client=${l(this,r,"f")}&distribution=${l(this,i,"f")}&environment=${l(this,o,"f")}`,t=await l(this,a,"f").execute(()=>l(this,n,"f").call(this,e,{cache:"no-cache"}));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const s=await t.json();if(!Array.isArray(s))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(s),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce((e,t)=>({...e,...t}),{})}},n=new WeakMap,a=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BASE_URL=void 0,s.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs",{"./client-config-api-service/client-config-api-service.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs","./remote-feature-flag-controller-types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs","./remote-feature-flag-controller.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs","./utils/user-segmentation-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.generateDeterministicRandomNumber=s.ClientConfigApiService=s.EnvironmentType=s.DistributionType=s.ClientType=s.RemoteFeatureFlagController=void 0;var n=e("./remote-feature-flag-controller.cjs");Object.defineProperty(s,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return n.RemoteFeatureFlagController}});var a=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(s,"ClientType",{enumerable:!0,get:function(){return a.ClientType}}),Object.defineProperty(s,"DistributionType",{enumerable:!0,get:function(){return a.DistributionType}}),Object.defineProperty(s,"EnvironmentType",{enumerable:!0,get:function(){return a.EnvironmentType}});var r=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(s,"ClientConfigApiService",{enumerable:!0,get:function(){return r.ClientConfigApiService}});var i=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(s,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return i.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r;Object.defineProperty(s,"__esModule",{value:!0}),s.EnvironmentType=s.DistributionType=s.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(n||(s.ClientType=n={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(a||(s.DistributionType=a={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev"}(r||(s.EnvironmentType=r={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs",{"./utils/user-segmentation-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l,m,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RemoteFeatureFlagController=s.getDefaultRemoteFeatureFlagControllerState=s.DEFAULT_CACHE_DURATION=s.controllerName=void 0;const p=e("@metamask/base-controller"),f=e("./utils/user-segmentation-utils.cjs");s.controllerName="RemoteFeatureFlagController",s.DEFAULT_CACHE_DURATION=864e5;const g={remoteFeatureFlags:{persist:!0,anonymous:!0},cacheTimestamp:{persist:!0,anonymous:!0}};function b(){return{remoteFeatureFlags:{},cacheTimestamp:0}}s.getDefaultRemoteFeatureFlagControllerState=b;class k extends p.BaseController{constructor({messenger:e,state:t,clientConfigApiService:l,fetchInterval:m=s.DEFAULT_CACHE_DURATION,disabled:d=!1,getMetaMetricsId:h}){super({name:s.controllerName,metadata:g,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),n.add(this),a.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),u(this,a,m,"f"),u(this,r,d,"f"),u(this,i,l,"f"),u(this,c,h,"f")}async updateRemoteFeatureFlags(){if(h(this,r,"f")||!h(this,n,"m",l).call(this))return;let e;if(h(this,o,"f"))await h(this,o,"f");else{try{u(this,o,h(this,i,"f").fetchRemoteFeatureFlags(),"f"),e=await h(this,o,"f")}finally{u(this,o,undefined,"f")}await h(this,n,"m",m).call(this,e.remoteFeatureFlags)}}enable(){u(this,r,!1,"f")}disable(){u(this,r,!0,"f")}}s.RemoteFeatureFlagController=k,a=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,n=new WeakSet,l=function(){return Date.now()-this.state.cacheTimestamp>h(this,a,"f")},m=async function(e){const t=await h(this,n,"m",d).call(this,e);this.update(()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()}))},d=async function(e){const t={},s=h(this,c,"f").call(this),n=(0,f.generateDeterministicRandomNumber)(s);for(const[s,a]of Object.entries(e)){let e=a;if(Array.isArray(a)&&n){const t=a.find(e=>!!(0,f.isFeatureFlagWithScopeValue)(e)&&n<=e.scope.value);t&&(e={name:t.name,value:t.value})}t[s]=e}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs",{uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isFeatureFlagWithScopeValue=s.generateDeterministicRandomNumber=void 0;const n=e("uuid");function a(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const r=a("00000000-0000-4000-8000-000000000000"),i=a("ffffffff-ffff-4fff-bfff-ffffffffffff")-r;s.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,s;if((0,n.validate)(e)){if(4!==(0,n.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,n.version)(e)}`);t=a(e)-r,s=i}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const n=e.slice(2),a=64;if(n.length!==a)throw new Error(`Invalid hex ID length. Expected ${a} characters, got ${n.length}`);if(!/^[0-9a-f]+$/iu.test(n))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${n}`),s=BigInt(`0x${"f".repeat(n.length)}`)}return Number(t*BigInt(1e6)/s)/1e6};s.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs",{"@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/swappable-obj-proxy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/swappable-obj-proxy/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},m=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=s.METAMASK_DOMAIN=s.controllerName=void 0;const d=e("@metamask/base-controller"),u=e("@metamask/swappable-obj-proxy");s.controllerName="SelectedNetworkController";const h={domains:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0}};s.METAMASK_DOMAIN="metamask",s.SelectedNetworkControllerActionTypes={getState:`${s.controllerName}:getState`,getNetworkClientIdForDomain:`${s.controllerName}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${s.controllerName}:setNetworkClientIdForDomain`},s.SelectedNetworkControllerEventTypes={stateChange:`${s.controllerName}:stateChange`};class p extends d.BaseController{constructor({messenger:e,state:t={domains:{}},domainProxyMap:i}){super({name:s.controllerName,metadata:h,messenger:e,state:t}),n.add(this),a.set(this,void 0),l(this,a,i,"f"),m(this,n,"m",r).call(this),this.messagingSystem.call("PermissionController:getSubjectNames").filter(e=>this.state.domains[e]===undefined).forEach(e=>this.setNetworkClientIdForDomain(e,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId)),this.messagingSystem.subscribe("PermissionController:stateChange",(e,t)=>{t.forEach(({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const s=t[1];"add"===e&&this.state.domains[s]===undefined?this.setNetworkClientIdForDomain(s,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[s]!==undefined&&m(this,n,"m",o).call(this,s)}})}),this.messagingSystem.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e,networkConfigurationsByChainId:t},s)=>{const n=s.find(({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]);if(n){const s=Object.values(t).reduce((e,t)=>(t.rpcEndpoints.forEach(({networkClientId:s})=>e[s]=t.chainId),e),{});Object.entries(this.state.domains).forEach(([a,r])=>{const i=s[r];if("remove"!==n.op||i){if("replace"===n.op){const e=n.path[1];if(!i||i===e){const s=t[e],{networkClientId:n}=s.rpcEndpoints[s.defaultRpcEndpointIndex];r!==n&&this.setNetworkClientIdForDomain(a,n)}}}else this.setNetworkClientIdForDomain(a,e)})}})}setNetworkClientIdForDomain(e,t){if(e===s.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${s.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!m(this,n,"m",c).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");m(this,n,"m",i).call(this,e,t)}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messagingSystem.call("NetworkController:getState");return this.state.domains[e]??t}getProviderAndBlockTracker(e){if(e===s.METAMASK_DOMAIN){const e=this.messagingSystem.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=m(this,a,"f").get(e);if(t===undefined){let s;if(m(this,n,"m",c).call(this,e)){const t=this.getNetworkClientIdForDomain(e);s=this.messagingSystem.call("NetworkController:getNetworkClientById",t)}else if(s=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),s===undefined)throw new Error("Selected network not initialized");t={provider:(0,u.createEventEmitterProxy)(s.provider),blockTracker:(0,u.createEventEmitterProxy)(s.blockTracker,{eventFilter:"skipInternal"})},m(this,a,"f").set(e,t)}return t}}s.SelectedNetworkController=p,a=new WeakMap,n=new WeakSet,r=function(){this.messagingSystem.registerActionHandler(s.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messagingSystem.registerActionHandler(s.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},i=function(e,t){const s=this.messagingSystem.call("NetworkController:getNetworkClientById",t);this.update(s=>{s.domains[e]=t});const n=this.getProviderAndBlockTracker(e);n.provider.setTarget(s.provider),n.blockTracker.setTarget(s.blockTracker)},o=function(e){const t=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),s=m(this,a,"f").get(e);s&&t?(s.provider.setTarget(t.provider),s.blockTracker.setTarget(t.blockTracker)):s&&m(this,a,"f").delete(e),this.update(t=>{delete t.domains[e]})},c=function(e){return this.messagingSystem.call("PermissionController:hasPermissions",e)}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs",{"./SelectedNetworkController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=void 0;const n=e("./SelectedNetworkController.cjs");s.createSelectedNetworkMiddleware=e=>(t,s,a)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var r;return t.networkClientId=(r=t.origin,e.call(n.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,r)),a()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/index.cjs",{"./SelectedNetworkController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs","./SelectedNetworkMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=s.METAMASK_DOMAIN=s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=void 0;var n=e("./SelectedNetworkController.cjs");Object.defineProperty(s,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return n.SelectedNetworkControllerActionTypes}}),Object.defineProperty(s,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return n.SelectedNetworkControllerEventTypes}}),Object.defineProperty(s,"SelectedNetworkController",{enumerable:!0,get:function(){return n.SelectedNetworkController}}),Object.defineProperty(s,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return n.METAMASK_DOMAIN}});var a=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(s,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return a.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/ShieldController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/constants.cjs","./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/logger.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/signature-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/signature-controller/dist/index.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l,m,d,u,h,p,f,g,b=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},k=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ShieldController=s.getDefaultShieldControllerState=void 0;const y=e("@metamask/base-controller"),w=e("@metamask/signature-controller"),x=e("@metamask/transaction-controller"),v=e("./constants.cjs"),S=e("./logger.cjs"),_=(0,S.createModuleLogger)(S.projectLogger,"ShieldController");function P(){return{coverageResults:{},orderedTransactionHistory:[]}}s.getDefaultShieldControllerState=P;const T={coverageResults:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0},orderedTransactionHistory:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1}};class j extends y.BaseController{constructor(e){const{messenger:t,state:s,backend:u,transactionHistoryLimit:h=100,coverageHistoryLimit:p=10}=e;super({name:v.controllerName,metadata:T,messenger:t,state:{coverageResults:{},orderedTransactionHistory:[],...s}}),n.add(this),a.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),b(this,a,u,"f"),b(this,r,p,"f"),b(this,i,h,"f"),b(this,o,k(this,n,"m",d).bind(this),"f"),b(this,c,k(this,n,"m",m).bind(this),"f"),b(this,l,!1,"f")}start(){k(this,l,"f")||(b(this,l,!0,"f"),this.messagingSystem.subscribe("TransactionController:stateChange",k(this,o,"f"),e=>e.transactions),this.messagingSystem.subscribe("SignatureController:stateChange",k(this,c,"f"),e=>e.signatureRequests))}stop(){k(this,l,"f")&&(b(this,l,!1,"f"),this.messagingSystem.unsubscribe("TransactionController:stateChange",k(this,o,"f")),this.messagingSystem.unsubscribe("SignatureController:stateChange",k(this,c,"f")))}async checkCoverage(e){const t=k(this,n,"m",g).call(this,e.id),s=await k(this,a,"f").checkCoverage({txMeta:e,coverageId:t});return this.messagingSystem.publish(`${v.controllerName}:coverageResultReceived`,s),k(this,n,"m",u).call(this,e.id,s),s}async checkSignatureCoverage(e){const t=k(this,n,"m",g).call(this,e.id),s=await k(this,a,"f").checkSignatureCoverage({signatureRequest:e,coverageId:t});return this.messagingSystem.publish(`${v.controllerName}:coverageResultReceived`,s),k(this,n,"m",u).call(this,e.id,s),s}}s.ShieldController=j,a=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,n=new WeakSet,m=function(e,t){const s=Object.values(e),a=Object.values(t??{}),r=new Map(a.map(e=>[e.id,e]));for(const e of s){const t=r.get(e.id);t||e.type!==w.SignatureRequestType.PersonalSign||this.checkSignatureCoverage(e).catch(e=>_("Error checking coverage:",e)),e.status===w.SignatureRequestStatus.Signed&&e.status!==t?.status&&k(this,n,"m",h).call(this,e).catch(e=>_("Error logging signature:",e))}},d=function(e,t){const s=new Map(t?.map(e=>[e.id,e])??[]);for(const t of e){const e=s.get(t.id);e&&e.simulationData===t.simulationData||this.checkCoverage(t).catch(e=>_("Error checking coverage:",e)),t.status===x.TransactionStatus.submitted&&t.status!==e?.status&&k(this,n,"m",p).call(this,t).catch(e=>_("Error logging transaction:",e))}},u=function(e,t){const s=k(this,n,"m",g).call(this,e);if(s&&t.coverageId!==s)throw new Error("Coverage ID has changed");this.update(s=>{let n=!1,a=s.coverageResults[e];a||(n=!0,a={results:[]},s.coverageResults[e]=a),a.results.length>=k(this,r,"f")&&a.results.pop(),a.results.unshift(t);const{orderedTransactionHistory:o}=s;let c;n&&(o.length>=k(this,i,"f")&&(c=o.pop(),c&&delete s.coverageResults[c]),o.unshift(e))})},h=async function(e){const t=e.rawSig;if(!t)throw new Error("Signature not found");const{status:s}=k(this,n,"m",f).call(this,e.id);await k(this,a,"f").logSignature({signatureRequest:e,signature:t,status:s})},p=async function(e){const t=e.hash;if(!t)throw new Error("Transaction hash not found");const{status:s}=k(this,n,"m",f).call(this,e.id);await k(this,a,"f").logTransaction({txMeta:e,transactionHash:t,status:s})},f=function(e){let t="shown";return k(this,n,"m",g).call(this,e)||(_("Coverage ID not found for",e),t="not_shown"),{status:t}},g=function(e){return this.state.coverageResults[e]?.results[0]?.coverageId}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/ShieldController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/backend.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l,m,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ShieldRemoteBackend=void 0;async function p(e){return new Promise(t=>setTimeout(t,e))}function f(e){return{txParams:[{from:e.txParams.from,to:e.txParams.to,value:e.txParams.value,data:e.txParams.data,nonce:e.txParams.nonce}],chainId:e.chainId,origin:e.origin}}function g(e){if("string"!=typeof e.messageParams.data)throw new Error("Signature data must be a string");return{chainId:e.chainId,data:e.messageParams.data,from:e.messageParams.from,method:e.type,origin:e.messageParams.origin}}s.ShieldRemoteBackend=class{constructor({getAccessToken:e,getCoverageResultTimeout:t=5e3,getCoverageResultPollInterval:s=1e3,baseUrl:l,fetch:m}){n.add(this),a.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),u(this,a,e,"f"),u(this,r,t,"f"),u(this,i,s,"f"),u(this,o,l,"f"),u(this,c,m,"f")}async checkCoverage(e){let{coverageId:t}=e;if(!t){const s=f(e.txMeta);({coverageId:t}=await h(this,n,"m",l).call(this,"v1/transaction/coverage/init",s))}const s=`${h(this,o,"f")}/v1/transaction/coverage/result`,a=await h(this,n,"m",m).call(this,t,{coverageResultUrl:s});return{coverageId:t,message:a.message,reasonCode:a.reasonCode,status:a.status}}async checkSignatureCoverage(e){let{coverageId:t}=e;if(!t){const s=g(e.signatureRequest);({coverageId:t}=await h(this,n,"m",l).call(this,"v1/signature/coverage/init",s))}const s=`${h(this,o,"f")}/v1/signature/coverage/result`,a=await h(this,n,"m",m).call(this,t,{coverageResultUrl:s});return{coverageId:t,message:a.message,reasonCode:a.reasonCode,status:a.status}}async logSignature(e){const t=g(e.signatureRequest),s={signature:e.signature,status:e.status,...t},a=await h(this,c,"f").call(this,`${h(this,o,"f")}/v1/signature/coverage/log`,{method:"POST",headers:await h(this,n,"m",d).call(this),body:JSON.stringify(s)});if(200!==a.status)throw new Error(`Failed to log signature: ${a.status}`)}async logTransaction(e){const t=f(e.txMeta),s={transactionHash:e.transactionHash,status:e.status,...t},a=await h(this,c,"f").call(this,`${h(this,o,"f")}/v1/transaction/coverage/log`,{method:"POST",headers:await h(this,n,"m",d).call(this),body:JSON.stringify(s)});if(200!==a.status)throw new Error(`Failed to log transaction: ${a.status}`)}},a=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,n=new WeakSet,l=async function(e,t){const s=await h(this,c,"f").call(this,`${h(this,o,"f")}/${e}`,{method:"POST",headers:await h(this,n,"m",d).call(this),body:JSON.stringify(t)});if(200!==s.status)throw new Error(`Failed to init coverage check: ${s.status}`);return await s.json()},m=async function(e,t){const s={coverageId:e},a=t?.timeout??h(this,r,"f"),o=t?.pollInterval??h(this,i,"f"),l=await h(this,n,"m",d).call(this);return await new Promise((e,n)=>{let r=!1;setTimeout(()=>{r=!0,n(new Error("Timeout waiting for coverage result"))},a);(async()=>{for(;!r;){const e=Date.now(),n=await h(this,c,"f").call(this,t.coverageResultUrl,{method:"POST",headers:l,body:JSON.stringify(s)});if(200===n.status)return await n.json();await p(o-(Date.now()-e))}throw new Error("unexpected error")})().then(e).catch(n)})},d=async function(){return{"Content-Type":"application/json",Authorization:`Bearer ${await h(this,a,"f").call(this)}`}}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/backend.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.controllerName=void 0,s.controllerName="ShieldController"}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/index.cjs",{"./ShieldController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/ShieldController.cjs","./backend.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/backend.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ShieldRemoteBackend=s.getDefaultShieldControllerState=s.ShieldController=void 0;var n=e("./ShieldController.cjs");Object.defineProperty(s,"ShieldController",{enumerable:!0,get:function(){return n.ShieldController}}),Object.defineProperty(s,"getDefaultShieldControllerState",{enumerable:!0,get:function(){return n.getDefaultShieldControllerState}});var a=e("./backend.cjs");Object.defineProperty(s,"ShieldRemoteBackend",{enumerable:!0,get:function(){return a.ShieldRemoteBackend}})}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/logger.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/constants.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(s,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}});const a=e("./constants.cjs");s.projectLogger=(0,n.createProjectLogger)(a.controllerName)}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/constants.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/types.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/utils.js","@ethersproject/bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/bytes/lib/index.js","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/eth-query":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js","@metamask/polling-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","bignumber.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js","lodash/cloneDeep":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/cloneDeep.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l,m,d,u,h,p,f,g,b,k,y,w,x,v,S,_,P,T,j,E,C,I=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},A=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)},M=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getDefaultSmartTransactionsControllerState=s.DEFAULT_INTERVAL=void 0;const O=e("@ethersproject/bytes"),R=e("@metamask/controller-utils"),N=M(e("@metamask/eth-query")),$=e("@metamask/polling-controller"),L=e("@metamask/transaction-controller"),B=e("bignumber.js"),F=M(e("lodash/cloneDeep")),D=e("./constants"),H=e("./types"),U=e("./utils");s.DEFAULT_INTERVAL=5e3;const q="`ethQuery` is not defined on SmartTransactionsController",V="SmartTransactionsController",W={smartTransactionsState:{persist:!1,anonymous:!0}};function G(){return{smartTransactionsState:{smartTransactions:{},userOptIn:null,userOptInV2:null,fees:{approvalTxFees:null,tradeTxFees:null},liveness:!0,livenessByChainId:{[R.ChainId.mainnet]:!0,[R.ChainId.sepolia]:!0},feesByChainId:{[R.ChainId.mainnet]:{approvalTxFees:null,tradeTxFees:null},[R.ChainId.sepolia]:{approvalTxFees:null,tradeTxFees:null}}}}}s.getDefaultSmartTransactionsControllerState=G;class K extends((0,$.StaticIntervalPollingController)()){constructor({interval:e=s.DEFAULT_INTERVAL,clientId:t,chainId:b=R.ChainId.mainnet,supportedChainIds:k=[R.ChainId.mainnet,R.ChainId.sepolia],getNonceLock:y,confirmExternalTransaction:w,trackMetaMetricsEvent:x,state:v={},messenger:S,getTransactions:_,getMetaMetricsProps:P,getFeatureFlags:T,updateTransaction:j,trace:E}){super({name:V,metadata:W,messenger:S,state:Object.assign(Object.assign({},G()),v)}),n.add(this),a.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),l.set(this,void 0),m.set(this,void 0),d.set(this,void 0),u.set(this,void 0),h.set(this,void 0),p.set(this,void 0),f.set(this,void 0),g.set(this,void 0),I(this,a,e,"f"),I(this,r,t,"f"),I(this,i,b,"f"),I(this,o,k,"f"),this.setIntervalLength(e),I(this,c,y,"f"),I(this,l,undefined,"f"),I(this,m,w,"f"),I(this,d,_,"f"),I(this,u,x,"f"),I(this,h,P,"f"),I(this,p,T,"f"),I(this,f,j,"f"),I(this,g,null!=E?E:(e,t)=>null==t?void 0:t(),"f"),this.initializeSmartTransactionsForChainId(),this.messagingSystem.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e})=>{const{configuration:{chainId:t},provider:s}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);I(this,i,t,"f"),I(this,l,new N.default(s),"f"),this.initializeSmartTransactionsForChainId(),this.checkPoll(this.state)}),this.messagingSystem.subscribe(`${V}:stateChange`,e=>this.checkPoll(e))}async _executePoll({chainIds:e}){const t=(null!=e?e:[]).filter(e=>A(this,o,"f").includes(e));return 0===t.length?Promise.resolve():this.updateSmartTransactions({chainIds:t})}checkPoll({smartTransactionsState:{smartTransactions:e}}){const t=Object.values(e).flat(),s=null==t?void 0:t.filter(U.isSmartTransactionPending);!this.timeoutHandle&&(null==s?void 0:s.length)>0?this.poll():this.timeoutHandle&&0===(null==s?void 0:s.length)&&this.stop()}initializeSmartTransactionsForChainId(){A(this,o,"f").includes(A(this,i,"f"))&&this.update(e=>{var t;e.smartTransactionsState.smartTransactions[A(this,i,"f")]=null!==(t=e.smartTransactionsState.smartTransactions[A(this,i,"f")])&&void 0!==t?t:[]})}async poll(e){e&&I(this,a,e,"f"),this.timeoutHandle&&clearInterval(this.timeoutHandle),A(this,o,"f").includes(A(this,i,"f"))&&(this.timeoutHandle=setInterval(()=>{(0,R.safelyExecute)(async()=>this.updateSmartTransactions())},A(this,a,"f")),await(0,R.safelyExecute)(async()=>this.updateSmartTransactions()))}async stop(){this.timeoutHandle&&clearInterval(this.timeoutHandle),this.timeoutHandle=undefined}setOptInState(e){this.update(t=>{t.smartTransactionsState.userOptInV2=e})}trackStxStatusChange(e,t){let s=(0,F.default)(e);s=Object.assign(Object.assign({},(0,F.default)(t)),s),s.status!==(null==t?void 0:t.status)&&A(this,u,"f").call(this,{event:D.MetaMetricsEventName.StxStatusUpdated,category:D.MetaMetricsEventCategory.Transactions,properties:(0,U.getSmartTransactionMetricsProperties)(s),sensitiveProperties:(0,U.getSmartTransactionMetricsSensitiveProperties)(s)})}isNewSmartTransaction(e,t){const{smartTransactionsState:{smartTransactions:s}}=this.state,n=s[null!=t?t:A(this,i,"f")],a=null==n?void 0:n.findIndex(t=>t.uuid===e);return-1===a||a===undefined}updateSmartTransaction(e,{networkClientId:t}={}){let s=A(this,l,"f"),a=A(this,i,"f");if(t){const{configuration:e,provider:n}=this.messagingSystem.call("NetworkController:getNetworkClientById",t);a=e.chainId,s=new N.default(n)}A(this,n,"m",w).call(this,e,{chainId:a,ethQuery:s})}async updateSmartTransactions({chainIds:e}={chainIds:A(this,n,"m",P).call(this)}){const{smartTransactionsState:{smartTransactions:t}}=this.state;for(const[s,a]of Object.entries(t)){if(e&&!e.includes(s))continue;const t=a.filter(U.isSmartTransactionPending).map(e=>{const t=A(this,n,"m",T).call(this,{chainId:s});return{uuid:e.uuid,networkClientId:t,chainId:e.chainId}});t.length>0&&await this.fetchSmartTransactionsStatus(t)}}async fetchSmartTransactionsStatus(e){const{chainId:t}=e[0],s=e.map(e=>e.uuid),a=new URLSearchParams({uuids:s.join(",")}),r=A(this,n,"m",j).call(this,{networkClientId:e[0].networkClientId}),i=`${(0,U.getAPIRequestURL)(H.APIType.BATCH_STATUS,t)}?${a.toString()}`,o=await A(this,n,"m",b).call(this,i);for(const[s,a]of Object.entries(o)){const i=e.find(e=>e.uuid===s);if(!i){console.error(`No matching transaction found for uuid: ${s}`);continue}const o={statusMetadata:a,status:(0,U.calculateStatus)(a),cancellable:(0,U.isSmartTransactionCancellable)(a),uuid:s,networkClientId:i.networkClientId};await A(this,n,"m",w).call(this,o,{chainId:t,ethQuery:r})}return o}clearFees(){const e={approvalTxFees:null,tradeTxFees:null};return this.update(t=>{t.smartTransactionsState.fees=e}),e}async getFees(e,t,{networkClientId:s}={}){const a=null!=s?s:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,r=A(this,n,"m",_).call(this,{networkClientId:a}),o=[];let c;if(t){const s=await A(this,n,"m",S).call(this,t,a);o.push(s),c=Object.assign(Object.assign({},e),{nonce:(0,U.incrementNonceInHex)(s.nonce)})}else c=e.nonce?e:await A(this,n,"m",S).call(this,e,a);o.push(c);const l=await A(this,g,"f").call(this,{name:D.SmartTransactionsTraceName.GetFees},async()=>await A(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.GET_FEES,r),{method:"POST",body:JSON.stringify({txs:o})}));let m,d;return t?(m=null==l?void 0:l.txs[0],d=null==l?void 0:l.txs[1]):(m=null,d=null==l?void 0:l.txs[0]),this.update(e=>{r===A(this,i,"f")&&(e.smartTransactionsState.fees={approvalTxFees:m,tradeTxFees:d}),e.smartTransactionsState.feesByChainId[r]={approvalTxFees:m,tradeTxFees:d}}),{approvalTxFees:m,tradeTxFees:d}}async submitSignedTransactions({transactionMeta:e,txParams:t,signedTransactions:s,signedCanceledTransactions:a=[],networkClientId:r}){var i,o;const l=null!=r?r:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,m=A(this,n,"m",_).call(this,{networkClientId:l}),d=A(this,n,"m",j).call(this,{networkClientId:l}),u=await A(this,g,"f").call(this,{name:D.SmartTransactionsTraceName.SubmitTransactions},async()=>await A(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.SUBMIT_TRANSACTIONS,m),{method:"POST",body:JSON.stringify({rawTxs:s,rawCancelTxs:a})})),h=Date.now();let p;try{if(null==t?void 0:t.from){const e=await(0,R.query)(d,"getBalance",[t.from]);p=new B.BigNumber(e).toString(16)}}catch(e){console.error("ethQuery.getBalance error:",e)}let f,k,y={};if(t&&!t.nonce)try{k=await A(this,c,"f").call(this,t.from,l),f=(0,O.hexlify)(k.nextNonce),y=k.nonceDetails,null!==(i=t.nonce)&&void 0!==i||(t.nonce=f)}catch(e){throw console.error("Failed to acquire nonce lock:",e),e}const x=s.map(e=>(0,U.getTxHash)(e)),v=Object.assign(Object.assign({},u),{txHash:x[x.length-1],txHashes:x});try{await A(this,n,"m",w).call(this,{chainId:m,nonceDetails:y,preTxBalance:p,status:H.SmartTransactionStatuses.PENDING,time:h,txParams:t,uuid:v.uuid,txHash:v.txHash,cancellable:!0,type:null!==(o=null==e?void 0:e.type)&&void 0!==o?o:"swap",transactionId:null==e?void 0:e.id,networkClientId:l,txHashes:x},{chainId:m,ethQuery:d})}catch(e){throw console.error("Failed to create a smart transaction:",e),e}finally{k&&k.releaseLock()}return v}async cancelSmartTransaction(e,{networkClientId:t}={}){const s=A(this,n,"m",_).call(this,{networkClientId:t});await A(this,g,"f").call(this,{name:D.SmartTransactionsTraceName.CancelTransaction},async()=>await A(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.CANCEL,s),{method:"POST",body:JSON.stringify({uuid:e})}))}async fetchLiveness({networkClientId:e}={}){const t=A(this,n,"m",_).call(this,{networkClientId:e});let s=!1;try{const e=await A(this,g,"f").call(this,{name:D.SmartTransactionsTraceName.FetchLiveness},async()=>await A(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.LIVENESS,t)));s=Boolean(e.smartTransactions)}catch(e){console.log('"fetchLiveness" API call failed')}return this.update(e=>{t===A(this,i,"f")&&(e.smartTransactionsState.liveness=s),e.smartTransactionsState.livenessByChainId[t]=s}),s}async setStatusRefreshInterval(e){e!==A(this,a,"f")&&I(this,a,e,"f")}getTransactions({addressFrom:e,status:t}){return A(this,n,"m",E).call(this).filter(s=>{var n;return s.status===t&&(null===(n=s.txParams)||void 0===n?void 0:n.from)===e})}getSmartTransactionByMinedTxHash(e){if(!e)return undefined;return A(this,n,"m",E).call(this).find(t=>{var s,n;return(null===(n=null===(s=t.statusMetadata)||void 0===s?void 0:s.minedHash)||void 0===n?void 0:n.toLowerCase())===e.toLowerCase()})}wipeSmartTransactions({address:e,ignoreNetwork:t}){if(!e)return;const s=e.toLowerCase();if(t){const{smartTransactionsState:{smartTransactions:e}}=this.state;Object.keys(e).forEach(e=>{A(this,n,"m",C).call(this,{chainId:e,addressLowerCase:s})})}else A(this,n,"m",C).call(this,{chainId:A(this,i,"f"),addressLowerCase:s})}}s.default=K,a=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,l=new WeakMap,m=new WeakMap,d=new WeakMap,u=new WeakMap,h=new WeakMap,p=new WeakMap,f=new WeakMap,g=new WeakMap,n=new WeakSet,b=async function(e,t){const s=Object.assign(Object.assign({},t),{headers:Object.assign({"Content-Type":"application/json"},A(this,r,"f")&&{"X-Client-Id":A(this,r,"f")})});return(0,U.handleFetch)(e,s)},k=function(e,{chainId:t=A(this,i,"f")}){var s;const{smartTransactionsState:{smartTransactions:n}}=this.state,a=null!==(s=n[t])&&void 0!==s?s:[],r=null==a?void 0:a.findIndex(t=>t.uuid===e.uuid);-1!==r&&(0,R.isSafeDynamicKey)(t)&&this.update(s=>{s.smartTransactionsState.smartTransactions[t][r]=Object.assign(Object.assign({},s.smartTransactionsState.smartTransactions[t][r]),e)})},y=async function(e){const t=await A(this,h,"f").call(this);e.accountHardwareType=null==t?void 0:t.accountHardwareType,e.accountType=null==t?void 0:t.accountType,e.deviceModel=null==t?void 0:t.deviceModel},w=async function(e,{chainId:t=A(this,i,"f"),ethQuery:s=A(this,l,"f")}){var a;const{smartTransactionsState:{smartTransactions:o}}=this.state,c=null!==(a=o[t])&&void 0!==a?a:[],m=null==c?void 0:c.findIndex(t=>t.uuid===e.uuid),u=this.isNewSmartTransaction(e.uuid,t);if(s===undefined)throw new Error(q);if(u)try{await A(this,n,"m",y).call(this,e)}catch(e){console.error("Failed to add metrics props to smart transaction:",e)}if(this.trackStxStatusChange(e,u?undefined:c[m]),u){const s=null==c?void 0:c.findIndex(t=>{var s,n,a;return(null===(s=t.txParams)||void 0===s?void 0:s.nonce)===(null===(n=e.txParams)||void 0===n?void 0:n.nonce)&&(null===(a=t.status)||void 0===a?void 0:a.startsWith("cancelled"))}),n=[(0,F.default)(e)],a=Object.assign(Object.assign({},e),{history:n}),r=s>-1?c.slice(0,s).concat(c.slice(s+1)).concat(a):c.concat(a);return void this.update(e=>{e.smartTransactionsState.smartTransactions[t]=r})}const h=c[m],g=Object.assign(Object.assign({},h),e);this.messagingSystem.publish("SmartTransactionsController:smartTransaction",g),(0,U.shouldMarkRegularTransactionAsFailed)({smartTransaction:g,clientId:A(this,r,"f"),getFeatureFlags:A(this,p,"f")})&&(0,U.markRegularTransactionAsFailed)({smartTransaction:g,getRegularTransactions:A(this,d,"f"),updateTransaction:A(this,f,"f")}),e.status!==H.SmartTransactionStatuses.SUCCESS&&e.status!==H.SmartTransactionStatuses.REVERTED||e.confirmed?A(this,n,"m",k).call(this,e,{chainId:t}):await A(this,n,"m",v).call(this,g,{chainId:t,ethQuery:s})},x=function(e){if(!e)return!0;const t=A(this,d,"f").call(this),s=null==t?void 0:t.find(t=>{var s;return(null===(s=t.hash)||void 0===s?void 0:s.toLowerCase())===e.toLowerCase()});return!s||![L.TransactionStatus.confirmed,L.TransactionStatus.submitted].includes(s.status)},v=async function(e,{chainId:t=A(this,i,"f"),ethQuery:s=A(this,l,"f")}){var a;if(s===undefined)throw new Error(q);const r=null===(a=e.statusMetadata)||void 0===a?void 0:a.minedHash;try{const a=await(0,R.query)(s,"getTransactionReceipt",[r]),i=await(0,R.query)(s,"getTransactionByHash",[r]),o=null==i?void 0:i.maxFeePerGas,c=null==i?void 0:i.maxPriorityFeePerGas;if(null==a?void 0:a.blockNumber){const i=await(0,R.query)(s,"getBlockByNumber",[null==a?void 0:a.blockNumber,!1]),l=null==i?void 0:i.baseFeePerGas,d=Object.assign(Object.assign({},e.txParams),{maxFeePerGas:o,maxPriorityFeePerGas:c}),h=Object.assign(Object.assign({},e),{id:e.uuid,status:L.TransactionStatus.confirmed,hash:r,txParams:d}),p=(0,U.snapshotFromTxMeta)(h),f=(0,U.replayHistory)(h.history),g=(0,U.generateHistoryEntry)(f,p,"txStateManager: setting status to confirmed"),b=g.length>0?Object.assign(Object.assign({},h),{history:h.history.concat(g)}):h;A(this,n,"m",x).call(this,r)&&A(this,m,"f").call(this,b,a,l),A(this,u,"f").call(this,{event:D.MetaMetricsEventName.StxConfirmed,category:D.MetaMetricsEventCategory.Transactions,properties:(0,U.getSmartTransactionMetricsProperties)(e),sensitiveProperties:(0,U.getSmartTransactionMetricsSensitiveProperties)(e)}),A(this,n,"m",k).call(this,Object.assign(Object.assign({},e),{confirmed:!0}),{chainId:t})}}catch(e){A(this,u,"f").call(this,{event:D.MetaMetricsEventName.StxConfirmationFailed,category:D.MetaMetricsEventCategory.Transactions}),console.error("confirm error",e)}finally{this.messagingSystem.publish("SmartTransactionsController:smartTransactionConfirmationDone",e)}},S=async function(e,t){const s=await A(this,c,"f").call(this,e.from,t),n=s.nextNonce;return s.releaseLock(),Object.assign(Object.assign({},e),{nonce:`0x${n.toString(16)}`})},_=function({networkClientId:e}={}){return e?this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId:A(this,i,"f")},P=function(){const{networkConfigurationsByChainId:e}=this.messagingSystem.call("NetworkController:getState");return Object.keys(e).filter(e=>A(this,o,"f").includes(e))},T=function({chainId:e}){const{networkConfigurationsByChainId:t}=this.messagingSystem.call("NetworkController:getState");return t[e].rpcEndpoints[t[e].defaultRpcEndpointIndex].networkClientId},j=function({networkClientId:e}={}){if(e){const{provider:t}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);return new N.default(t)}if(A(this,l,"f")===undefined)throw new Error(q);return A(this,l,"f")},E=function(){const{smartTransactionsState:{smartTransactions:e}}=this.state,t=Object.values(e).flat();return t&&0!==t.length?t:[]},C=function({chainId:e,addressLowerCase:t}){const{smartTransactionsState:{smartTransactions:s}}=this.state,n=null==s?void 0:s[e];if(!n||0===n.length)return;const a=n.filter(e=>{var s;return(null===(s=e.txParams)||void 0===s?void 0:s.from)!==t});this.update(t=>{t.smartTransactionsState.smartTransactions[e]=a})}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/constants.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.SmartTransactionsTraceName=s.MetaMetricsEventCategory=s.MetaMetricsEventName=s.SENTINEL_API_BASE_URL_MAP=s.API_BASE_URL=void 0,s.API_BASE_URL="https://transaction.api.cx.metamask.io",s.SENTINEL_API_BASE_URL_MAP={1:"https://tx-sentinel-ethereum-mainnet.api.cx.metamask.io",56:"https://tx-sentinel-bsc-mainnet.api.cx.metamask.io",8453:"https://tx-sentinel-base-mainnet.api.cx.metamask.io",42161:"https://tx-sentinel-arbitrum-mainnet.api.cx.metamask.io",59144:"https://tx-sentinel-linea-mainnet.api.cx.metamask.io",11155111:"https://tx-sentinel-ethereum-sepolia.api.cx.metamask.io"},function(e){e.StxStatusUpdated="STX Status Updated",e.StxConfirmed="STX Confirmed",e.StxConfirmationFailed="STX Confirmation Failed",e.ReceiveRequest="Receive Request"}(s.MetaMetricsEventName||(s.MetaMetricsEventName={})),function(e){e.Transactions="Transactions",e.Navigation="Navigation"}(s.MetaMetricsEventCategory||(s.MetaMetricsEventCategory={})),function(e){e.GetFees="Smart Transactions: Get Fees",e.SubmitTransactions="Smart Transactions: Submit Transactions",e.CancelTransaction="Smart Transactions: Cancel Transaction",e.FetchLiveness="Smart Transactions: Fetch Liveness"}(s.SmartTransactionsTraceName||(s.SmartTransactionsTraceName={}))}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/index.js",{"./SmartTransactionsController":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var a=e("./SmartTransactionsController");Object.defineProperty(s,"default",{enumerable:!0,get:function(){return n(a).default}})}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/utils.js",{"../package.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/package.json","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/constants.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/types.js","@ethersproject/bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/bytes/lib/index.js","@ethersproject/keccak256":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/keccak256/lib/index.js","@ethersproject/transactions":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/transactions/lib/index.js","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","bignumber.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js","fast-json-patch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-json-patch/index.js",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.markRegularTransactionAsFailed=s.shouldMarkRegularTransactionAsFailed=s.getReturnTxHashAsap=s.getSmartTransactionMetricsSensitiveProperties=s.getSmartTransactionMetricsProperties=s.getTxHash=s.incrementNonceInHex=s.isSmartTransactionCancellable=s.handleFetch=s.mapKeysToCamel=s.getStxProcessingTime=s.snapshotFromTxMeta=s.replayHistory=s.generateHistoryEntry=s.calculateStatus=s.getAPIRequestURL=s.isSmartTransactionStatusResolved=s.isSmartTransactionPending=void 0;const a=e("@ethersproject/bytes"),r=e("@ethersproject/keccak256"),i=e("@ethersproject/transactions"),o=e("@metamask/transaction-controller"),c=e("bignumber.js"),l=n(e("fast-json-patch")),m=n(e("lodash")),d=n(e("../package.json")),u=e("./constants"),h=e("./types");s.isSmartTransactionPending=function(e){return e.status===h.SmartTransactionStatuses.PENDING};s.isSmartTransactionStatusResolved=e=>"uuid_not_found"===e,s.getAPIRequestURL=function(e,t){const s=parseInt(t,16);switch(e){case h.APIType.GET_FEES:return`${u.API_BASE_URL}/networks/${s}/getFees`;case h.APIType.ESTIMATE_GAS:return`${u.API_BASE_URL}/networks/${s}/estimateGas`;case h.APIType.SUBMIT_TRANSACTIONS:return`${u.API_BASE_URL}/networks/${s}/submitTransactions?stxControllerVersion=${d.default.version}`;case h.APIType.CANCEL:return`${u.API_BASE_URL}/networks/${s}/cancel`;case h.APIType.BATCH_STATUS:return`${u.API_BASE_URL}/networks/${s}/batchStatus`;case h.APIType.LIVENESS:return`${u.SENTINEL_API_BASE_URL_MAP[s]}/network`;default:throw new Error("Invalid APIType")}};s.calculateStatus=e=>{if((0,s.isSmartTransactionStatusResolved)(e))return h.SmartTransactionStatuses.RESOLVED;const t=[h.SmartTransactionCancellationReason.WOULD_REVERT,h.SmartTransactionCancellationReason.TOO_CHEAP,h.SmartTransactionCancellationReason.DEADLINE_MISSED,h.SmartTransactionCancellationReason.INVALID_NONCE,h.SmartTransactionCancellationReason.USER_CANCELLED];if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.NOT_MINED){if(e.cancellationReason===h.SmartTransactionCancellationReason.NOT_CANCELLED)return h.SmartTransactionStatuses.PENDING;const s=t.findIndex(t=>t===e.cancellationReason)>-1;if(e.cancellationReason&&s)return e.isSettled?h.cancellationReasonToStatusMap[e.cancellationReason]:h.SmartTransactionStatuses.PENDING}else{if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.SUCCESS)return h.SmartTransactionStatuses.SUCCESS;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.CANCELLED)return h.SmartTransactionStatuses.CANCELLED;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.REVERTED)return h.SmartTransactionStatuses.REVERTED;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.UNKNOWN)return h.SmartTransactionStatuses.UNKNOWN}return h.SmartTransactionStatuses.UNKNOWN},s.generateHistoryEntry=function(e,t,s){const n=l.default.compare(e,t);return n[0]&&(s&&(n[0].note=s),n[0].timestamp=Date.now()),n},s.replayHistory=function(e){return m.default.cloneDeep(e).reduce((e,t)=>l.default.applyPatch(e,t).newDocument)},s.snapshotFromTxMeta=function(e){const t=Object.assign({},e);return delete t.history,m.default.cloneDeep(t)};s.getStxProcessingTime=e=>e?Math.round((Date.now()-e)/1e3):undefined;s.mapKeysToCamel=e=>{if(!m.default.isObject(e))return e;const t=m.default.mapValues(e,e=>m.default.isArray(e)?e.map(s.mapKeysToCamel):m.default.isObject(e)?(0,s.mapKeysToCamel)(e):e);return m.default.mapKeys(t,(e,t)=>m.default.camelCase(t))},s.handleFetch=async function(e,t){const n=await fetch(e,t),a=await n.json();if(!n.ok)throw console.log("response",n),new Error(`Fetch error:${JSON.stringify(Object.assign({status:n.status},(0,s.mapKeysToCamel)(a)))}`);return a};s.isSmartTransactionCancellable=e=>e.minedTx===h.SmartTransactionMinedTx.NOT_MINED&&(!e.cancellationReason||e.cancellationReason===h.SmartTransactionCancellationReason.NOT_CANCELLED);s.incrementNonceInHex=e=>{const t=new c.BigNumber(e,16).toString(10);return(0,a.hexlify)(Number(t)+1)};s.getTxHash=e=>{var t;if(!e)return"";try{const s=(0,i.parse)(e);return null!==(t=null==s?void 0:s.hash)&&void 0!==t?t:""}catch(t){if((e=>"string"==typeof e&&e.startsWith("0x04"))(e))return(0,a.hexlify)((0,r.keccak256)((0,a.arrayify)(e)));throw t}};s.getSmartTransactionMetricsProperties=e=>{if(!e)return{};const t=e.statusMetadata;return{stx_status:e.status,type:e.type,processing_time:(0,s.getStxProcessingTime)(e.time),is_smart_transaction:!0,stx_enabled:!0,current_stx_enabled:!0,stx_user_opt_in:!0,stx_duplicated:null==t?void 0:t.duplicated,stx_timed_out:null==t?void 0:t.timedOut,stx_proxied:null==t?void 0:t.proxied}};s.getSmartTransactionMetricsSensitiveProperties=e=>e?{token_from_symbol:e.sourceTokenSymbol,token_to_symbol:e.destinationTokenSymbol,account_hardware_type:e.accountHardwareType,account_type:e.accountType,device_model:e.deviceModel}:{};s.getReturnTxHashAsap=(e,t)=>e===h.ClientId.Extension?null==t?void 0:t.extensionReturnTxHashAsap:null==t?void 0:t.mobileReturnTxHashAsap;s.shouldMarkRegularTransactionAsFailed=({smartTransaction:e,clientId:t,getFeatureFlags:n})=>{var a;const{status:r,transactionId:i}=e,o=[h.SmartTransactionStatuses.CANCELLED,h.SmartTransactionStatuses.CANCELLED_USER_CANCELLED,h.SmartTransactionStatuses.UNKNOWN,h.SmartTransactionStatuses.RESOLVED];if(!r||!o.includes(r))return!1;const{smartTransactions:c}=null!==(a=n())&&void 0!==a?a:{},l=(0,s.getReturnTxHashAsap)(t,c);return Boolean(l&&i)};s.markRegularTransactionAsFailed=({smartTransaction:e,getRegularTransactions:t,updateTransaction:s})=>{const{transactionId:n,status:a}=e,r=t().find(e=>e.id===n);if(!r)throw new Error("Cannot find regular transaction to mark it as failed");if(r.status===o.TransactionStatus.failed)return;s(Object.assign(Object.assign({},r),{status:o.TransactionStatus.failed,error:{name:"SmartTransactionFailed",message:`Smart transaction failed with status: ${a}`}}),`Smart transaction status: ${a}`)}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs",{"fast-json-stable-stringify":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-json-stable-stringify/index.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)},a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.AbstractPollingControllerBaseMixin=s.getKey=void 0;const r=a(e("fast-json-stable-stringify")),i=e("uuid");s.getKey=e=>(0,r.default)(e),s.AbstractPollingControllerBaseMixin=function(e){var t,a;return t=new WeakMap,a=new WeakMap,class extends e{constructor(){super(...arguments),t.set(this,new Map),a.set(this,new Map)}startPolling(e){const a=(0,i.v4)(),r=(0,s.getKey)(e),o=n(this,t,"f").get(r)??new Set;return o.add(a),n(this,t,"f").set(r,o),1===o.size&&this._startPolling(e),a}stopAllPolling(){n(this,t,"f").forEach((e,t)=>{e.forEach(e=>{this.stopPollingByPollingToken(e)})})}stopPollingByPollingToken(e){if(!e)throw new Error("pollingToken required");let s=null;for(const[a,r]of n(this,t,"f"))if(r.delete(e)){0===r.size&&(s=a);break}if(s){this._stopPollingByPollingTokenSetId(s),n(this,t,"f").delete(s);const e=n(this,a,"f").get(s);if(e){for(const t of e)t(JSON.parse(s));e.clear()}}}onPollingComplete(e,t){const r=(0,s.getKey)(e),i=n(this,a,"f").get(r)??new Set;i.add(t),n(this,a,"f").set(r,i)}}}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs",{"./AbstractPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.BlockTrackerPollingController=s.BlockTrackerPollingControllerOnly=void 0;const a=e("@metamask/base-controller"),r=e("./AbstractPollingController.cjs");function i(e){var t;class s extends((0,r.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{})}_startPolling(e){const s=(0,r.getKey)(e);if(n(this,t,"f")[s])return;const a=this._getNetworkClientById(e.networkClientId);if(!a)throw new Error(`Unable to retrieve blockTracker for networkClientId ${e.networkClientId}`);{const r=this._executePoll.bind(this,e);a.blockTracker.addListener("latest",r),n(this,t,"f")[s]=r}}_stopPollingByPollingTokenSetId(e){const{networkClientId:s}=JSON.parse(e),a=this._getNetworkClientById(s);if(a&&n(this,t,"f")[e]){const s=n(this,t,"f")[e];s&&(a.blockTracker.removeListener("latest",s),delete n(this,t,"f")[e])}}}return t=new WeakMap,s}class o{}s.BlockTrackerPollingControllerOnly=()=>i(o);s.BlockTrackerPollingController=()=>i(a.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs",{"./AbstractPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},a=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.StaticIntervalPollingController=s.StaticIntervalPollingControllerOnly=void 0;const r=e("@metamask/base-controller"),i=e("./AbstractPollingController.cjs");function o(e){var t,s;class r extends((0,i.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{}),s.set(this,1e3)}setIntervalLength(e){n(this,s,e,"f")}getIntervalLength(){return a(this,s,"f")}_startPolling(e){if(!a(this,s,"f"))throw new Error("intervalLength must be defined and greater than 0");const n=(0,i.getKey)(e),r=a(this,t,"f")[n];this._stopPollingByPollingTokenSetId(n);const o=a(this,t,"f")[n]=setTimeout(async()=>{try{await this._executePoll(e)}catch(e){console.error(e)}o===a(this,t,"f")[n]&&this._startPolling(e)},r?a(this,s,"f"):0)}_stopPollingByPollingTokenSetId(e){const s=a(this,t,"f")[e];s&&(clearTimeout(s),delete a(this,t,"f")[e])}}return t=new WeakMap,s=new WeakMap,r}class c{}s.StaticIntervalPollingControllerOnly=()=>o(c);s.StaticIntervalPollingController=()=>o(r.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs",{"./BlockTrackerPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs","./StaticIntervalPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.StaticIntervalPollingController=s.StaticIntervalPollingControllerOnly=s.BlockTrackerPollingController=s.BlockTrackerPollingControllerOnly=void 0;var n=e("./BlockTrackerPollingController.cjs");Object.defineProperty(s,"BlockTrackerPollingControllerOnly",{enumerable:!0,get:function(){return n.BlockTrackerPollingControllerOnly}}),Object.defineProperty(s,"BlockTrackerPollingController",{enumerable:!0,get:function(){return n.BlockTrackerPollingController}});var a=e("./StaticIntervalPollingController.cjs");Object.defineProperty(s,"StaticIntervalPollingControllerOnly",{enumerable:!0,get:function(){return a.StaticIntervalPollingControllerOnly}}),Object.defineProperty(s,"StaticIntervalPollingController",{enumerable:!0,get:function(){return a.StaticIntervalPollingController}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseController.cjs",{immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},r=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.deriveStateFromMetadata=s.getPersistentState=s.getAnonymizedState=s.BaseController=s.isBaseController=void 0;const i=e("immer");(0,i.enablePatches)(),s.isBaseController=function(e){return"object"==typeof e&&null!==e&&"name"in e&&"string"==typeof e.name&&"state"in e&&"object"==typeof e.state&&"metadata"in e&&"object"==typeof e.metadata};function o(e,t,s,n){return Object.keys(e).reduce((a,r)=>{try{const n=t[r];if(!n)throw new Error(`No metadata found for '${String(r)}'`);const i=n[s],o=e[r];return"function"==typeof i?a[r]=i(o):i&&(a[r]=o),a}catch(e){if(n)try{n(e instanceof Error?e:new Error(String(e)))}catch(t){console.error(new Error("Error thrown when calling 'captureException'"),t),console.error(e)}else console.error(e);return a}},{})}s.BaseController=class{constructor({messenger:e,metadata:t,name:s,state:r}){n.set(this,void 0),this.messagingSystem=e,this.name=s,a(this,n,(0,i.freeze)(r,!0),"f"),this.metadata=t,this.messagingSystem.registerActionHandler(`${s}:getState`,()=>this.state),this.messagingSystem.registerInitialEventPayload({eventType:`${s}:stateChange`,getPayload:()=>[this.state,[]]})}get state(){return r(this,n,"f")}set state(e){throw new Error("Controller state cannot be directly mutated; use 'update' method instead.")}update(e){const[t,s,o]=i.produceWithPatches(r(this,n,"f"),e);return s.length>0&&(a(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,s)),{nextState:t,patches:s,inversePatches:o}}applyPatches(e){const t=(0,i.applyPatches)(r(this,n,"f"),e);a(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,e)}destroy(){this.messagingSystem.clearEventSubscriptions(`${this.name}:stateChange`)}},n=new WeakMap,s.getAnonymizedState=function(e,t,s){return o(e,t,"anonymous",s)},s.getPersistentState=function(e,t,s){return o(e,t,"persist",s)},s.deriveStateFromMetadata=o}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs",{"./RestrictedMessenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.Messenger=void 0;const c=e("./RestrictedMessenger.cjs");s.Messenger=class{constructor(){n.set(this,new Map),a.set(this,new Map),r.set(this,new Map),i.set(this,new Map)}registerActionHandler(e,t){if(o(this,n,"f").has(e))throw new Error(`A handler for ${e} has already been registered`);o(this,n,"f").set(e,t)}registerMethodActionHandlers(e,t){for(const s of t){const t=e[s];if("function"==typeof t){const n=`${e.name}:${s}`;this.registerActionHandler(n,t.bind(e))}}}unregisterActionHandler(e){o(this,n,"f").delete(e)}clearActions(){o(this,n,"f").clear()}call(e,...t){const s=o(this,n,"f").get(e);if(!s)throw new Error(`A handler for ${e} has not been registered`);return s(...t)}registerInitialEventPayload({eventType:e,getPayload:t}){o(this,r,"f").set(e,t)}publish(e,...t){const s=o(this,a,"f").get(e);if(s)for(const[e,n]of s.entries())try{if(n){const s=o(this,i,"f").get(e),a=n(...t);a!==s&&(o(this,i,"f").set(e,a),e(a,s))}else e(...t)}catch(e){setTimeout(()=>{throw e})}}subscribe(e,t,s){let n=o(this,a,"f").get(e);n||(n=new Map,o(this,a,"f").set(e,n));const c=t;if(n.set(c,s),s){const t=o(this,r,"f").get(e);if(t){const e=s(...t());o(this,i,"f").set(c,e)}}}unsubscribe(e,t){const s=o(this,a,"f").get(e),n=t;if(!s||!s.has(n))throw new Error(`Subscription not found for event: ${e}`);s.get(n)&&o(this,i,"f").delete(n),s.delete(n)}clearEventSubscriptions(e){o(this,a,"f").delete(e)}clearSubscriptions(){o(this,a,"f").clear()}getRestricted({name:e,allowedActions:t,allowedEvents:s}){return new c.RestrictedMessenger({messenger:this,name:e,allowedActions:t,allowedEvents:s})}},n=new WeakMap,a=new WeakMap,r=new WeakMap,i=new WeakMap}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,r,i,o,c,l,m,d=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},u=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedMessenger=void 0;s.RestrictedMessenger=class{constructor({messenger:e,name:t,allowedActions:s,allowedEvents:c}){if(n.add(this),a.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),!e)throw new Error("Messenger not provided");d(this,a,e,"f"),d(this,r,t,"f"),d(this,i,s,"f"),d(this,o,c,"f")}registerActionHandler(e,t){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed registering action handlers prefixed by '${u(this,r,"f")}:'`);u(this,a,"f").registerActionHandler(e,t)}registerMethodActionHandlers(e,t){u(this,a,"f").registerMethodActionHandlers(e,t)}unregisterActionHandler(e){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed unregistering action handlers prefixed by '${u(this,r,"f")}:'`);u(this,a,"f").unregisterActionHandler(e)}call(e,...t){if(!u(this,n,"m",l).call(this,e))throw new Error(`Action missing from allow list: ${e}`);return u(this,a,"f").call(e,...t)}registerInitialEventPayload({eventType:e,getPayload:t}){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,r,"f")}:'`);u(this,a,"f").registerInitialEventPayload({eventType:e,getPayload:t})}publish(e,...t){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,r,"f")}:'`);u(this,a,"f").publish(e,...t)}subscribe(e,t,s){if(!u(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);return s?u(this,a,"f").subscribe(e,t,s):u(this,a,"f").subscribe(e,t)}unsubscribe(e,t){if(!u(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);u(this,a,"f").unsubscribe(e,t)}clearEventSubscriptions(e){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed clearing events prefixed by '${u(this,r,"f")}:'`);u(this,a,"f").clearEventSubscriptions(e)}},a=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,n=new WeakSet,c=function(e){const t=u(this,o,"f");return u(this,n,"m",m).call(this,e)||null!==t&&t.includes(e)},l=function(e){const t=u(this,i,"f");return u(this,n,"m",m).call(this,e)||null!==t&&t.includes(e)},m=function(e){return e.startsWith(`${u(this,r,"f")}:`)}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs",{"./BaseController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseController.cjs","./Messenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs","./RestrictedMessenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedMessenger=s.Messenger=s.isBaseController=s.getPersistentState=s.getAnonymizedState=s.deriveStateFromMetadata=s.BaseController=void 0;var n=e("./BaseController.cjs");Object.defineProperty(s,"BaseController",{enumerable:!0,get:function(){return n.BaseController}}),Object.defineProperty(s,"deriveStateFromMetadata",{enumerable:!0,get:function(){return n.deriveStateFromMetadata}}),Object.defineProperty(s,"getAnonymizedState",{enumerable:!0,get:function(){return n.getAnonymizedState}}),Object.defineProperty(s,"getPersistentState",{enumerable:!0,get:function(){return n.getPersistentState}}),Object.defineProperty(s,"isBaseController",{enumerable:!0,get:function(){return n.isBaseController}});var a=e("./Messenger.cjs");Object.defineProperty(s,"Messenger",{enumerable:!0,get:function(){return a.Messenger}});var r=e("./RestrictedMessenger.cjs");Object.defineProperty(s,"RestrictedMessenger",{enumerable:!0,get:function(){return r.RestrictedMessenger}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){!function(e){var s,n=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,a=Math.ceil,r=Math.floor,i="[BigNumber Error] ",o=i+"Number primitive has more than 15 significant digits: ",c=1e14,l=14,m=9007199254740991,d=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],u=1e7,h=1e9;function p(e){var t=0|e;return e>0||e===t?t:t-1}function f(e){for(var t,s,n=1,a=e.length,r=e[0]+"";n<a;){for(t=e[n++]+"",s=l-t.length;s--;t="0"+t);r+=t}for(a=r.length;48===r.charCodeAt(--a););return r.slice(0,a+1||1)}function g(e,t){var s,n,a=e.c,r=t.c,i=e.s,o=t.s,c=e.e,l=t.e;if(!i||!o)return null;if(s=a&&!a[0],n=r&&!r[0],s||n)return s?n?0:-o:i;if(i!=o)return i;if(s=i<0,n=c==l,!a||!r)return n?0:!a^s?1:-1;if(!n)return c>l^s?1:-1;for(o=(c=a.length)<(l=r.length)?c:l,i=0;i<o;i++)if(a[i]!=r[i])return a[i]>r[i]^s?1:-1;return c==l?0:c>l^s?1:-1}function b(e,t,s,n){if(e<t||e>s||e!==r(e))throw Error(i+(n||"Argument")+("number"==typeof e?e<t||e>s?" out of range: ":" not an integer: ":" not a primitive number: ")+String(e))}function k(e){var t=e.c.length-1;return p(e.e/l)==t&&e.c[t]%2!=0}function y(e,t){return(e.length>1?e.charAt(0)+"."+e.slice(1):e)+(t<0?"e":"e+")+t}function w(e,t,s){var n,a;if(t<0){for(a=s+".";++t;a+=s);e=a+e}else if(++t>(n=e.length)){for(a=s,t-=n;--t;a+=s);e+=a}else t<n&&(e=e.slice(0,t)+"."+e.slice(t));return e}s=function e(t){var s,x,v,S,_,P,T,j,E,C,I=V.prototype={constructor:V,toString:null,valueOf:null},A=new V(1),M=20,O=4,R=-7,N=21,$=-1e7,L=1e7,B=!1,F=1,D=0,H={prefix:"",groupSize:3,secondaryGroupSize:0,groupSeparator:",",decimalSeparator:".",fractionGroupSize:0,fractionGroupSeparator:" ",suffix:""},U="0123456789abcdefghijklmnopqrstuvwxyz",q=!0;function V(e,t){var s,a,i,c,d,u,h,p,f=this;if(!(f instanceof V))return new V(e,t);if(null==t){if(e&&!0===e._isBigNumber)return f.s=e.s,void(!e.c||e.e>L?f.c=f.e=null:e.e<$?f.c=[f.e=0]:(f.e=e.e,f.c=e.c.slice()));if((u="number"==typeof e)&&0*e==0){if(f.s=1/e<0?(e=-e,-1):1,e===~~e){for(c=0,d=e;d>=10;d/=10,c++);return void(c>L?f.c=f.e=null:(f.e=c,f.c=[e]))}p=String(e)}else{if(!n.test(p=String(e)))return v(f,p,u);f.s=45==p.charCodeAt(0)?(p=p.slice(1),-1):1}(c=p.indexOf("."))>-1&&(p=p.replace(".","")),(d=p.search(/e/i))>0?(c<0&&(c=d),c+=+p.slice(d+1),p=p.substring(0,d)):c<0&&(c=p.length)}else{if(b(t,2,U.length,"Base"),10==t&&q)return z(f=new V(e),M+f.e+1,O);if(p=String(e),u="number"==typeof e){if(0*e!=0)return v(f,p,u,t);if(f.s=1/e<0?(p=p.slice(1),-1):1,V.DEBUG&&p.replace(/^0\.0*|\./,"").length>15)throw Error(o+e)}else f.s=45===p.charCodeAt(0)?(p=p.slice(1),-1):1;for(s=U.slice(0,t),c=d=0,h=p.length;d<h;d++)if(s.indexOf(a=p.charAt(d))<0){if("."==a){if(d>c){c=h;continue}}else if(!i&&(p==p.toUpperCase()&&(p=p.toLowerCase())||p==p.toLowerCase()&&(p=p.toUpperCase()))){i=!0,d=-1,c=0;continue}return v(f,String(e),u,t)}u=!1,(c=(p=x(p,t,10,f.s)).indexOf("."))>-1?p=p.replace(".",""):c=p.length}for(d=0;48===p.charCodeAt(d);d++);for(h=p.length;48===p.charCodeAt(--h););if(p=p.slice(d,++h)){if(h-=d,u&&V.DEBUG&&h>15&&(e>m||e!==r(e)))throw Error(o+f.s*e);if((c=c-d-1)>L)f.c=f.e=null;else if(c<$)f.c=[f.e=0];else{if(f.e=c,f.c=[],d=(c+1)%l,c<0&&(d+=l),d<h){for(d&&f.c.push(+p.slice(0,d)),h-=l;d<h;)f.c.push(+p.slice(d,d+=l));d=l-(p=p.slice(d)).length}else d-=h;for(;d--;p+="0");f.c.push(+p)}}else f.c=[f.e=0]}function W(e,t,s,n){var a,r,i,o,c;if(null==s?s=O:b(s,0,8),!e.c)return e.toString();if(a=e.c[0],i=e.e,null==t)c=f(e.c),c=1==n||2==n&&(i<=R||i>=N)?y(c,i):w(c,i,"0");else if(r=(e=z(new V(e),t,s)).e,o=(c=f(e.c)).length,1==n||2==n&&(t<=r||r<=R)){for(;o<t;c+="0",o++);c=y(c,r)}else if(t-=i,c=w(c,r,"0"),r+1>o){if(--t>0)for(c+=".";t--;c+="0");}else if((t+=r-o)>0)for(r+1==o&&(c+=".");t--;c+="0");return e.s<0&&a?"-"+c:c}function G(e,t){for(var s,n,a=1,r=new V(e[0]);a<e.length;a++)(!(n=new V(e[a])).s||(s=g(r,n))===t||0===s&&r.s===t)&&(r=n);return r}function K(e,t,s){for(var n=1,a=t.length;!t[--a];t.pop());for(a=t[0];a>=10;a/=10,n++);return(s=n+s*l-1)>L?e.c=e.e=null:s<$?e.c=[e.e=0]:(e.e=s,e.c=t),e}function z(e,t,s,n){var i,o,m,u,h,p,f,g=e.c,b=d;if(g){e:{for(i=1,u=g[0];u>=10;u/=10,i++);if((o=t-i)<0)o+=l,m=t,h=g[p=0],f=r(h/b[i-m-1]%10);else if((p=a((o+1)/l))>=g.length){if(!n)break e;for(;g.length<=p;g.push(0));h=f=0,i=1,m=(o%=l)-l+1}else{for(h=u=g[p],i=1;u>=10;u/=10,i++);f=(m=(o%=l)-l+i)<0?0:r(h/b[i-m-1]%10)}if(n=n||t<0||null!=g[p+1]||(m<0?h:h%b[i-m-1]),n=s<4?(f||n)&&(0==s||s==(e.s<0?3:2)):f>5||5==f&&(4==s||n||6==s&&(o>0?m>0?h/b[i-m]:0:g[p-1])%10&1||s==(e.s<0?8:7)),t<1||!g[0])return g.length=0,n?(t-=e.e+1,g[0]=b[(l-t%l)%l],e.e=-t||0):g[0]=e.e=0,e;if(0==o?(g.length=p,u=1,p--):(g.length=p+1,u=b[l-o],g[p]=m>0?r(h/b[i-m]%b[m])*u:0),n)for(;;){if(0==p){for(o=1,m=g[0];m>=10;m/=10,o++);for(m=g[0]+=u,u=1;m>=10;m/=10,u++);o!=u&&(e.e++,g[0]==c&&(g[0]=1));break}if(g[p]+=u,g[p]!=c)break;g[p--]=0,u=1}for(o=g.length;0===g[--o];g.pop());}e.e>L?e.c=e.e=null:e.e<$&&(e.c=[e.e=0])}return e}function J(e){var t,s=e.e;return null===s?e.toString():(t=f(e.c),t=s<=R||s>=N?y(t,s):w(t,s,"0"),e.s<0?"-"+t:t)}return V.clone=e,V.ROUND_UP=0,V.ROUND_DOWN=1,V.ROUND_CEIL=2,V.ROUND_FLOOR=3,V.ROUND_HALF_UP=4,V.ROUND_HALF_DOWN=5,V.ROUND_HALF_EVEN=6,V.ROUND_HALF_CEIL=7,V.ROUND_HALF_FLOOR=8,V.EUCLID=9,V.config=V.set=function(e){var t,s;if(null!=e){if("object"!=typeof e)throw Error(i+"Object expected: "+e);if(e.hasOwnProperty(t="DECIMAL_PLACES")&&(b(s=e[t],0,h,t),M=s),e.hasOwnProperty(t="ROUNDING_MODE")&&(b(s=e[t],0,8,t),O=s),e.hasOwnProperty(t="EXPONENTIAL_AT")&&((s=e[t])&&s.pop?(b(s[0],-h,0,t),b(s[1],0,h,t),R=s[0],N=s[1]):(b(s,-h,h,t),R=-(N=s<0?-s:s))),e.hasOwnProperty(t="RANGE"))if((s=e[t])&&s.pop)b(s[0],-h,-1,t),b(s[1],1,h,t),$=s[0],L=s[1];else{if(b(s,-h,h,t),!s)throw Error(i+t+" cannot be zero: "+s);$=-(L=s<0?-s:s)}if(e.hasOwnProperty(t="CRYPTO")){if((s=e[t])!==!!s)throw Error(i+t+" not true or false: "+s);if(s){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw B=!s,Error(i+"crypto unavailable");B=s}else B=s}if(e.hasOwnProperty(t="MODULO_MODE")&&(b(s=e[t],0,9,t),F=s),e.hasOwnProperty(t="POW_PRECISION")&&(b(s=e[t],0,h,t),D=s),e.hasOwnProperty(t="FORMAT")){if("object"!=typeof(s=e[t]))throw Error(i+t+" not an object: "+s);H=s}if(e.hasOwnProperty(t="ALPHABET")){if("string"!=typeof(s=e[t])||/^.?$|[+\-.\s]|(.).*\1/.test(s))throw Error(i+t+" invalid: "+s);q="0123456789"==s.slice(0,10),U=s}}return{DECIMAL_PLACES:M,ROUNDING_MODE:O,EXPONENTIAL_AT:[R,N],RANGE:[$,L],CRYPTO:B,MODULO_MODE:F,POW_PRECISION:D,FORMAT:H,ALPHABET:U}},V.isBigNumber=function(e){if(!e||!0!==e._isBigNumber)return!1;if(!V.DEBUG)return!0;var t,s,n=e.c,a=e.e,o=e.s;e:if("[object Array]"=={}.toString.call(n)){if((1===o||-1===o)&&a>=-h&&a<=h&&a===r(a)){if(0===n[0]){if(0===a&&1===n.length)return!0;break e}if((t=(a+1)%l)<1&&(t+=l),String(n[0]).length==t){for(t=0;t<n.length;t++)if((s=n[t])<0||s>=c||s!==r(s))break e;if(0!==s)return!0}}}else if(null===n&&null===a&&(null===o||1===o||-1===o))return!0;throw Error(i+"Invalid BigNumber: "+e)},V.maximum=V.max=function(){return G(arguments,-1)},V.minimum=V.min=function(){return G(arguments,1)},V.random=(S=9007199254740992,_=Math.random()*S&2097151?function(){return r(Math.random()*S)}:function(){return 8388608*(1073741824*Math.random()|0)+(8388608*Math.random()|0)},function(e){var t,s,n,o,c,m=0,u=[],p=new V(A);if(null==e?e=M:b(e,0,h),o=a(e/l),B)if(crypto.getRandomValues){for(t=crypto.getRandomValues(new Uint32Array(o*=2));m<o;)(c=131072*t[m]+(t[m+1]>>>11))>=9e15?(s=crypto.getRandomValues(new Uint32Array(2)),t[m]=s[0],t[m+1]=s[1]):(u.push(c%1e14),m+=2);m=o/2}else{if(!crypto.randomBytes)throw B=!1,Error(i+"crypto unavailable");for(t=crypto.randomBytes(o*=7);m<o;)(c=281474976710656*(31&t[m])+1099511627776*t[m+1]+4294967296*t[m+2]+16777216*t[m+3]+(t[m+4]<<16)+(t[m+5]<<8)+t[m+6])>=9e15?crypto.randomBytes(7).copy(t,m):(u.push(c%1e14),m+=7);m=o/7}if(!B)for(;m<o;)(c=_())<9e15&&(u[m++]=c%1e14);for(o=u[--m],e%=l,o&&e&&(c=d[l-e],u[m]=r(o/c)*c);0===u[m];u.pop(),m--);if(m<0)u=[n=0];else{for(n=-1;0===u[0];u.splice(0,1),n-=l);for(m=1,c=u[0];c>=10;c/=10,m++);m<l&&(n-=l-m)}return p.e=n,p.c=u,p}),V.sum=function(){for(var e=1,t=arguments,s=new V(t[0]);e<t.length;)s=s.plus(t[e++]);return s},x=function(){var e="0123456789";function t(e,t,s,n){for(var a,r,i=[0],o=0,c=e.length;o<c;){for(r=i.length;r--;i[r]*=t);for(i[0]+=n.indexOf(e.charAt(o++)),a=0;a<i.length;a++)i[a]>s-1&&(null==i[a+1]&&(i[a+1]=0),i[a+1]+=i[a]/s|0,i[a]%=s)}return i.reverse()}return function(n,a,r,i,o){var c,l,m,d,u,h,p,g,b=n.indexOf("."),k=M,y=O;for(b>=0&&(d=D,D=0,n=n.replace(".",""),h=(g=new V(a)).pow(n.length-b),D=d,g.c=t(w(f(h.c),h.e,"0"),10,r,e),g.e=g.c.length),m=d=(p=t(n,a,r,o?(c=U,e):(c=e,U))).length;0==p[--d];p.pop());if(!p[0])return c.charAt(0);if(b<0?--m:(h.c=p,h.e=m,h.s=i,p=(h=s(h,g,k,y,r)).c,u=h.r,m=h.e),b=p[l=m+k+1],d=r/2,u=u||l<0||null!=p[l+1],u=y<4?(null!=b||u)&&(0==y||y==(h.s<0?3:2)):b>d||b==d&&(4==y||u||6==y&&1&p[l-1]||y==(h.s<0?8:7)),l<1||!p[0])n=u?w(c.charAt(1),-k,c.charAt(0)):c.charAt(0);else{if(p.length=l,u)for(--r;++p[--l]>r;)p[l]=0,l||(++m,p=[1].concat(p));for(d=p.length;!p[--d];);for(b=0,n="";b<=d;n+=c.charAt(p[b++]));n=w(n,m,c.charAt(0))}return n}}(),s=function(){function e(e,t,s){var n,a,r,i,o=0,c=e.length,l=t%u,m=t/u|0;for(e=e.slice();c--;)o=((a=l*(r=e[c]%u)+(n=m*r+(i=e[c]/u|0)*l)%u*u+o)/s|0)+(n/u|0)+m*i,e[c]=a%s;return o&&(e=[o].concat(e)),e}function t(e,t,s,n){var a,r;if(s!=n)r=s>n?1:-1;else for(a=r=0;a<s;a++)if(e[a]!=t[a]){r=e[a]>t[a]?1:-1;break}return r}function s(e,t,s,n){for(var a=0;s--;)e[s]-=a,a=e[s]<t[s]?1:0,e[s]=a*n+e[s]-t[s];for(;!e[0]&&e.length>1;e.splice(0,1));}return function(n,a,i,o,m){var d,u,h,f,g,b,k,y,w,x,v,S,_,P,T,j,E,C=n.s==a.s?1:-1,I=n.c,A=a.c;if(!(I&&I[0]&&A&&A[0]))return new V(n.s&&a.s&&(I?!A||I[0]!=A[0]:A)?I&&0==I[0]||!A?0*C:C/0:NaN);for(w=(y=new V(C)).c=[],C=i+(u=n.e-a.e)+1,m||(m=c,u=p(n.e/l)-p(a.e/l),C=C/l|0),h=0;A[h]==(I[h]||0);h++);if(A[h]>(I[h]||0)&&u--,C<0)w.push(1),f=!0;else{for(P=I.length,j=A.length,h=0,C+=2,(g=r(m/(A[0]+1)))>1&&(A=e(A,g,m),I=e(I,g,m),j=A.length,P=I.length),_=j,v=(x=I.slice(0,j)).length;v<j;x[v++]=0);E=A.slice(),E=[0].concat(E),T=A[0],A[1]>=m/2&&T++;do{if(g=0,(d=t(A,x,j,v))<0){if(S=x[0],j!=v&&(S=S*m+(x[1]||0)),(g=r(S/T))>1)for(g>=m&&(g=m-1),k=(b=e(A,g,m)).length,v=x.length;1==t(b,x,k,v);)g--,s(b,j<k?E:A,k,m),k=b.length,d=1;else 0==g&&(d=g=1),k=(b=A.slice()).length;if(k<v&&(b=[0].concat(b)),s(x,b,v,m),v=x.length,-1==d)for(;t(A,x,j,v)<1;)g++,s(x,j<v?E:A,v,m),v=x.length}else 0===d&&(g++,x=[0]);w[h++]=g,x[0]?x[v++]=I[_]||0:(x=[I[_]],v=1)}while((_++<P||null!=x[0])&&C--);f=null!=x[0],w[0]||w.splice(0,1)}if(m==c){for(h=1,C=w[0];C>=10;C/=10,h++);z(y,i+(y.e=h+u*l-1)+1,o,f)}else y.e=u,y.r=+f;return y}}(),P=/^(-?)0([xbo])(?=\w[\w.]*$)/i,T=/^([^.]+)\.$/,j=/^\.([^.]+)$/,E=/^-?(Infinity|NaN)$/,C=/^\s*\+(?=[\w.])|^\s+|\s+$/g,v=function(e,t,s,n){var a,r=s?t:t.replace(C,"");if(E.test(r))e.s=isNaN(r)?null:r<0?-1:1;else{if(!s&&(r=r.replace(P,function(e,t,s){return a="x"==(s=s.toLowerCase())?16:"b"==s?2:8,n&&n!=a?e:t}),n&&(a=n,r=r.replace(T,"$1").replace(j,"0.$1")),t!=r))return new V(r,a);if(V.DEBUG)throw Error(i+"Not a"+(n?" base "+n:"")+" number: "+t);e.s=null}e.c=e.e=null},I.absoluteValue=I.abs=function(){var e=new V(this);return e.s<0&&(e.s=1),e},I.comparedTo=function(e,t){return g(this,new V(e,t))},I.decimalPlaces=I.dp=function(e,t){var s,n,a,r=this;if(null!=e)return b(e,0,h),null==t?t=O:b(t,0,8),z(new V(r),e+r.e+1,t);if(!(s=r.c))return null;if(n=((a=s.length-1)-p(this.e/l))*l,a=s[a])for(;a%10==0;a/=10,n--);return n<0&&(n=0),n},I.dividedBy=I.div=function(e,t){return s(this,new V(e,t),M,O)},I.dividedToIntegerBy=I.idiv=function(e,t){return s(this,new V(e,t),0,1)},I.exponentiatedBy=I.pow=function(e,t){var s,n,o,c,m,d,u,h,p=this;if((e=new V(e)).c&&!e.isInteger())throw Error(i+"Exponent not an integer: "+J(e));if(null!=t&&(t=new V(t)),m=e.e>14,!p.c||!p.c[0]||1==p.c[0]&&!p.e&&1==p.c.length||!e.c||!e.c[0])return h=new V(Math.pow(+J(p),m?e.s*(2-k(e)):+J(e))),t?h.mod(t):h;if(d=e.s<0,t){if(t.c?!t.c[0]:!t.s)return new V(NaN);(n=!d&&p.isInteger()&&t.isInteger())&&(p=p.mod(t))}else{if(e.e>9&&(p.e>0||p.e<-1||(0==p.e?p.c[0]>1||m&&p.c[1]>=24e7:p.c[0]<8e13||m&&p.c[0]<=9999975e7)))return c=p.s<0&&k(e)?-0:0,p.e>-1&&(c=1/c),new V(d?1/c:c);D&&(c=a(D/l+2))}for(m?(s=new V(.5),d&&(e.s=1),u=k(e)):u=(o=Math.abs(+J(e)))%2,h=new V(A);;){if(u){if(!(h=h.times(p)).c)break;c?h.c.length>c&&(h.c.length=c):n&&(h=h.mod(t))}if(o){if(0===(o=r(o/2)))break;u=o%2}else if(z(e=e.times(s),e.e+1,1),e.e>14)u=k(e);else{if(0===(o=+J(e)))break;u=o%2}p=p.times(p),c?p.c&&p.c.length>c&&(p.c.length=c):n&&(p=p.mod(t))}return n?h:(d&&(h=A.div(h)),t?h.mod(t):c?z(h,D,O,undefined):h)},I.integerValue=function(e){var t=new V(this);return null==e?e=O:b(e,0,8),z(t,t.e+1,e)},I.isEqualTo=I.eq=function(e,t){return 0===g(this,new V(e,t))},I.isFinite=function(){return!!this.c},I.isGreaterThan=I.gt=function(e,t){return g(this,new V(e,t))>0},I.isGreaterThanOrEqualTo=I.gte=function(e,t){return 1===(t=g(this,new V(e,t)))||0===t},I.isInteger=function(){return!!this.c&&p(this.e/l)>this.c.length-2},I.isLessThan=I.lt=function(e,t){return g(this,new V(e,t))<0},I.isLessThanOrEqualTo=I.lte=function(e,t){return-1===(t=g(this,new V(e,t)))||0===t},I.isNaN=function(){return!this.s},I.isNegative=function(){return this.s<0},I.isPositive=function(){return this.s>0},I.isZero=function(){return!!this.c&&0==this.c[0]},I.minus=function(e,t){var s,n,a,r,i=this,o=i.s;if(t=(e=new V(e,t)).s,!o||!t)return new V(NaN);if(o!=t)return e.s=-t,i.plus(e);var m=i.e/l,d=e.e/l,u=i.c,h=e.c;if(!m||!d){if(!u||!h)return u?(e.s=-t,e):new V(h?i:NaN);if(!u[0]||!h[0])return h[0]?(e.s=-t,e):new V(u[0]?i:3==O?-0:0)}if(m=p(m),d=p(d),u=u.slice(),o=m-d){for((r=o<0)?(o=-o,a=u):(d=m,a=h),a.reverse(),t=o;t--;a.push(0));a.reverse()}else for(n=(r=(o=u.length)<(t=h.length))?o:t,o=t=0;t<n;t++)if(u[t]!=h[t]){r=u[t]<h[t];break}if(r&&(a=u,u=h,h=a,e.s=-e.s),(t=(n=h.length)-(s=u.length))>0)for(;t--;u[s++]=0);for(t=c-1;n>o;){if(u[--n]<h[n]){for(s=n;s&&!u[--s];u[s]=t);--u[s],u[n]+=c}u[n]-=h[n]}for(;0==u[0];u.splice(0,1),--d);return u[0]?K(e,u,d):(e.s=3==O?-1:1,e.c=[e.e=0],e)},I.modulo=I.mod=function(e,t){var n,a,r=this;return e=new V(e,t),!r.c||!e.s||e.c&&!e.c[0]?new V(NaN):!e.c||r.c&&!r.c[0]?new V(r):(9==F?(a=e.s,e.s=1,n=s(r,e,0,3),e.s=a,n.s*=a):n=s(r,e,0,F),(e=r.minus(n.times(e))).c[0]||1!=F||(e.s=r.s),e)},I.multipliedBy=I.times=function(e,t){var s,n,a,r,i,o,m,d,h,f,g,b,k,y,w,x=this,v=x.c,S=(e=new V(e,t)).c;if(!(v&&S&&v[0]&&S[0]))return!x.s||!e.s||v&&!v[0]&&!S||S&&!S[0]&&!v?e.c=e.e=e.s=null:(e.s*=x.s,v&&S?(e.c=[0],e.e=0):e.c=e.e=null),e;for(n=p(x.e/l)+p(e.e/l),e.s*=x.s,(m=v.length)<(f=S.length)&&(k=v,v=S,S=k,a=m,m=f,f=a),a=m+f,k=[];a--;k.push(0));for(y=c,w=u,a=f;--a>=0;){for(s=0,g=S[a]%w,b=S[a]/w|0,r=a+(i=m);r>a;)s=((d=g*(d=v[--i]%w)+(o=b*d+(h=v[i]/w|0)*g)%w*w+k[r]+s)/y|0)+(o/w|0)+b*h,k[r--]=d%y;k[r]=s}return s?++n:k.splice(0,1),K(e,k,n)},I.negated=function(){var e=new V(this);return e.s=-e.s||null,e},I.plus=function(e,t){var s,n=this,a=n.s;if(t=(e=new V(e,t)).s,!a||!t)return new V(NaN);if(a!=t)return e.s=-t,n.minus(e);var r=n.e/l,i=e.e/l,o=n.c,m=e.c;if(!r||!i){if(!o||!m)return new V(a/0);if(!o[0]||!m[0])return m[0]?e:new V(o[0]?n:0*a)}if(r=p(r),i=p(i),o=o.slice(),a=r-i){for(a>0?(i=r,s=m):(a=-a,s=o),s.reverse();a--;s.push(0));s.reverse()}for((a=o.length)-(t=m.length)<0&&(s=m,m=o,o=s,t=a),a=0;t;)a=(o[--t]=o[t]+m[t]+a)/c|0,o[t]=c===o[t]?0:o[t]%c;return a&&(o=[a].concat(o),++i),K(e,o,i)},I.precision=I.sd=function(e,t){var s,n,a,r=this;if(null!=e&&e!==!!e)return b(e,1,h),null==t?t=O:b(t,0,8),z(new V(r),e,t);if(!(s=r.c))return null;if(n=(a=s.length-1)*l+1,a=s[a]){for(;a%10==0;a/=10,n--);for(a=s[0];a>=10;a/=10,n++);}return e&&r.e+1>n&&(n=r.e+1),n},I.shiftedBy=function(e){return b(e,-9007199254740991,m),this.times("1e"+e)},I.squareRoot=I.sqrt=function(){var e,t,n,a,r,i=this,o=i.c,c=i.s,l=i.e,m=M+4,d=new V("0.5");if(1!==c||!o||!o[0])return new V(!c||c<0&&(!o||o[0])?NaN:o?i:1/0);if(0==(c=Math.sqrt(+J(i)))||c==1/0?(((t=f(o)).length+l)%2==0&&(t+="0"),c=Math.sqrt(+t),l=p((l+1)/2)-(l<0||l%2),n=new V(t=c==1/0?"5e"+l:(t=c.toExponential()).slice(0,t.indexOf("e")+1)+l)):n=new V(c+""),n.c[0])for((c=(l=n.e)+m)<3&&(c=0);;)if(r=n,n=d.times(r.plus(s(i,r,m,1))),f(r.c).slice(0,c)===(t=f(n.c)).slice(0,c)){if(n.e<l&&--c,"9999"!=(t=t.slice(c-3,c+1))&&(a||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(z(n,n.e+M+2,1),e=!n.times(n).eq(i));break}if(!a&&(z(r,r.e+M+2,0),r.times(r).eq(i))){n=r;break}m+=4,c+=4,a=1}return z(n,n.e+M+1,O,e)},I.toExponential=function(e,t){return null!=e&&(b(e,0,h),e++),W(this,e,t,1)},I.toFixed=function(e,t){return null!=e&&(b(e,0,h),e=e+this.e+1),W(this,e,t)},I.toFormat=function(e,t,s){var n,a=this;if(null==s)null!=e&&t&&"object"==typeof t?(s=t,t=null):e&&"object"==typeof e?(s=e,e=t=null):s=H;else if("object"!=typeof s)throw Error(i+"Argument not an object: "+s);if(n=a.toFixed(e,t),a.c){var r,o=n.split("."),c=+s.groupSize,l=+s.secondaryGroupSize,m=s.groupSeparator||"",d=o[0],u=o[1],h=a.s<0,p=h?d.slice(1):d,f=p.length;if(l&&(r=c,c=l,l=r,f-=r),c>0&&f>0){for(r=f%c||c,d=p.substr(0,r);r<f;r+=c)d+=m+p.substr(r,c);l>0&&(d+=m+p.slice(r)),h&&(d="-"+d)}n=u?d+(s.decimalSeparator||"")+((l=+s.fractionGroupSize)?u.replace(new RegExp("\\d{"+l+"}\\B","g"),"$&"+(s.fractionGroupSeparator||"")):u):d}return(s.prefix||"")+n+(s.suffix||"")},I.toFraction=function(e){var t,n,a,r,o,c,m,u,h,p,g,b,k=this,y=k.c;if(null!=e&&(!(m=new V(e)).isInteger()&&(m.c||1!==m.s)||m.lt(A)))throw Error(i+"Argument "+(m.isInteger()?"out of range: ":"not an integer: ")+J(m));if(!y)return new V(k);for(t=new V(A),h=n=new V(A),a=u=new V(A),b=f(y),o=t.e=b.length-k.e-1,t.c[0]=d[(c=o%l)<0?l+c:c],e=!e||m.comparedTo(t)>0?o>0?t:h:m,c=L,L=1/0,m=new V(b),u.c[0]=0;p=s(m,t,0,1),1!=(r=n.plus(p.times(a))).comparedTo(e);)n=a,a=r,h=u.plus(p.times(r=h)),u=r,t=m.minus(p.times(r=t)),m=r;return r=s(e.minus(n),a,0,1),u=u.plus(r.times(h)),n=n.plus(r.times(a)),u.s=h.s=k.s,g=s(h,a,o*=2,O).minus(k).abs().comparedTo(s(u,n,o,O).minus(k).abs())<1?[h,a]:[u,n],L=c,g},I.toNumber=function(){return+J(this)},I.toPrecision=function(e,t){return null!=e&&b(e,1,h),W(this,e,t,2)},I.toString=function(e){var t,s=this,n=s.s,a=s.e;return null===a?n?(t="Infinity",n<0&&(t="-"+t)):t="NaN":(null==e?t=a<=R||a>=N?y(f(s.c),a):w(f(s.c),a,"0"):10===e&&q?t=w(f((s=z(new V(s),M+a+1,O)).c),s.e,"0"):(b(e,2,U.length,"Base"),t=x(w(f(s.c),a,"0"),10,e,n,!0)),n<0&&s.c[0]&&(t="-"+t)),t},I.valueOf=I.toJSON=function(){return J(this)},I._isBigNumber=!0,null!=t&&V.set(t),V}(),s.default=s.BigNumber=s,"function"==typeof define&&define.amd?define(function(){return s}):void 0!==t&&t.exports?t.exports=s:(e||(e="undefined"!=typeof self&&self?self:window),e.BigNumber=s)}(this)}}},{package:"@metamask/smart-transactions-controller>bignumber.js",file:"node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/package.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={name:"@metamask/smart-transactions-controller",version:"18.1.0",description:"Improves success rates for swaps by trialing transactions privately and finding minimum fees",repository:{type:"git",url:"https://github.com/MetaMask/smart-transactions-controller.git"},license:"SEE LICENSE IN LICENSE",main:"dist/index.js",types:"dist/index.d.ts",files:["dist/"],scripts:{build:"tsc --project tsconfig.build.json","build:clean":"rm -rf dist && yarn build","build:link":"yarn build && cd dist && yarn link && rm -rf node_modules && cd ..",lint:"yarn lint:eslint && yarn lint:misc --check && yarn lint:changelog","lint:changelog":"auto-changelog validate --prettier","lint:eslint":"eslint . --cache --ext js,ts","lint:fix":"yarn lint:eslint --fix && yarn lint:misc --write && yarn lint:changelog","lint:misc":"prettier '**/*.json' '**/*.md' '**/*.yml' '!.yarnrc.yml' --ignore-path .gitignore --no-error-on-unmatched-pattern",prepack:"./scripts/prepack.sh",test:"jest","test:watch":"jest --watchAll"},dependencies:{"@babel/runtime":"^7.24.1","@ethereumjs/tx":"^5.2.1","@ethereumjs/util":"^9.0.2","@ethersproject/bytes":"^5.7.0","@ethersproject/keccak256":"^5.8.0","@ethersproject/transactions":"^5.7.0","@metamask/base-controller":"^7.0.1","@metamask/controller-utils":"^11.0.0","@metamask/eth-json-rpc-provider":"^4.1.6","@metamask/eth-query":"^4.0.0","@metamask/polling-controller":"^12.0.0","bignumber.js":"^9.0.1","fast-json-patch":"^3.1.0",lodash:"^4.17.21"},devDependencies:{"@lavamoat/allow-scripts":"^3.2.1","@lavamoat/preinstall-always-fail":"^2.1.0","@metamask/auto-changelog":"^3.1.0","@metamask/eslint-config":"^12.2.0","@metamask/eslint-config-jest":"^12.1.0","@metamask/eslint-config-nodejs":"^12.1.0","@metamask/eslint-config-typescript":"^12.1.0","@metamask/gas-fee-controller":"^22.0.0","@metamask/json-rpc-engine":"^10.0.1","@metamask/network-controller":"^24.0.0","@metamask/transaction-controller":"^42.0.0","@types/jest":"^26.0.24","@types/lodash":"^4.14.194","@types/node":"^18.19.17","@types/sinon":"^9.0.10","@typescript-eslint/eslint-plugin":"^5.33.0","@typescript-eslint/parser":"^5.33.0",eslint:"^8.48.0","eslint-config-prettier":"^8.8.0","eslint-plugin-import":"~2.26.0","eslint-plugin-jest":"^27.1.5","eslint-plugin-jsdoc":"^39.2.9","eslint-plugin-n":"^15.7.0","eslint-plugin-prettier":"^4.2.1","eslint-plugin-promise":"^6.1.1","isomorphic-fetch":"^3.0.0",jest:"^29.7.0",nock:"^14.0.0-beta.7",prettier:"^2.8.8","prettier-plugin-packagejson":"^2.4.3",sinon:"^9.2.4","ts-jest":"^29.1.4",typescript:"~4.8.4"},peerDependencies:{"@metamask/network-controller":"^24.0.0","@metamask/transaction-controller":"^42.0.0"},peerDependenciesMeta:{"@metamask/accounts-controller":{optional:!0},"@metamask/approval-controller":{optional:!0}},packageManager:"yarn@3.2.1",engines:{node:"^18.18 || >=20"},publishConfig:{access:"public",registry:"https://registry.npmjs.org/"},lavamoat:{allowScripts:{"@lavamoat/preinstall-always-fail":!1,"@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>keccak":!1,"@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>secp256k1":!1,"@metamask/controller-utils>babel-runtime>core-js":!1,"@metamask/transaction-controller>@metamask/accounts-controller>@metamask/keyring-controller>ethereumjs-wallet>ethereum-cryptography>keccak":!1,"@metamask/transaction-controller>@metamask/accounts-controller>@metamask/keyring-controller>ethereumjs-wallet>ethereum-cryptography>secp256k1":!1}}}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/package.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs",{"../snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","../snaps/constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js",luxon:"/home/runner/work/metamask-extension/metamask-extension/node_modules/luxon/build/cjs-browser/luxon.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,s){return e.set(o(e,t),s),s}function o(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.CronjobController=s.DAILY_TIMEOUT=void 0;const c=e("@metamask/base-controller"),l=e("@metamask/snaps-rpc-methods"),m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=e("immer"),h=e("luxon"),p=e("nanoid"),f=e("./utils.cjs"),g=e("../snaps/constants.cjs"),b=e("../snaps/Timer.cjs");s.DAILY_TIMEOUT=(0,d.inMilliseconds)(24,d.Duration.Hour);const k="CronjobController";var y=new WeakMap,w=new WeakMap,x=new WeakMap,v=new WeakSet,S=new WeakMap,_=new WeakMap,P=new WeakMap,T=new WeakMap,j=new WeakMap;class E extends c.BaseController{constructor({messenger:e,state:t,stateManager:c}){var l,m;super({messenger:e,metadata:{events:{includeInStateLogs:!1,persist:!1,anonymous:!1,usedInUi:!1}},name:k,state:{events:{},...t,...c.getInitialState()}}),a(l=this,m=v),m.add(l),n(this,y,void 0),n(this,w,void 0),n(this,x,new b.Timer(s.DAILY_TIMEOUT)),n(this,S,e=>{this.unregister(e.id),this.register(e.id)}),n(this,_,e=>{const t=this.get(e.id);o(v,this,$).call(this,t),this.register(e.id)}),n(this,P,e=>{this.unregister(e.id)}),n(this,T,e=>{this.unregister(e.id)}),n(this,j,e=>{this.unregister(e.id),this.register(e.id)}),i(y,this,new Map),i(w,this,c),this.messagingSystem.subscribe("SnapController:snapInstalled",r(S,this)),this.messagingSystem.subscribe("SnapController:snapUninstalled",r(P,this)),this.messagingSystem.subscribe("SnapController:snapEnabled",r(_,this)),this.messagingSystem.subscribe("SnapController:snapDisabled",r(T,this)),this.messagingSystem.subscribe("SnapController:snapUpdated",r(j,this)),this.messagingSystem.registerActionHandler(`${k}:init`,(...e)=>this.init(...e)),this.messagingSystem.registerActionHandler(`${k}:schedule`,(...e)=>this.schedule(...e)),this.messagingSystem.registerActionHandler(`${k}:cancel`,(...e)=>this.cancel(...e)),this.messagingSystem.registerActionHandler(`${k}:get`,(...e)=>this.get(...e))}init(){o(v,this,C).call(this),o(v,this,L).call(this),o(v,this,$).call(this)}schedule(e){return o(v,this,I).call(this,{...e,recurring:!1})}cancel(e,t){(0,d.assert)(this.state.events[t],`A background event with the id of "${t}" does not exist.`),(0,d.assert)(this.state.events[t].snapId===e,"Only the origin that scheduled this event can cancel it."),o(v,this,R).call(this,t)}get(e){return Object.values(this.state.events).filter(t=>t.snapId===e&&!t.recurring).map(e=>({...e,date:(0,m.toCensoredISO8601String)(e.date),scheduledAt:(0,m.toCensoredISO8601String)(e.scheduledAt)}))}register(e){const t=o(v,this,N).call(this,e);null==t||t.forEach(e=>o(v,this,I).call(this,e))}unregister(e){for(const[t,s]of Object.entries(this.state.events))s.snapId===e&&o(v,this,R).call(this,t)}destroy(){super.destroy(),this.messagingSystem.unsubscribe("SnapController:snapInstalled",r(S,this)),this.messagingSystem.unsubscribe("SnapController:snapUninstalled",r(P,this)),this.messagingSystem.unsubscribe("SnapController:snapEnabled",r(_,this)),this.messagingSystem.unsubscribe("SnapController:snapDisabled",r(T,this)),this.messagingSystem.unsubscribe("SnapController:snapUpdated",r(j,this)),r(y,this).forEach(e=>e.cancel()),r(y,this).clear(),"running"===r(x,this).status&&r(x,this).cancel()}}function C(){i(x,this,new b.Timer(s.DAILY_TIMEOUT)),r(x,this).start(()=>{o(v,this,$).call(this),o(v,this,C).call(this)})}function I(e){const t=e.id??(0,p.nanoid)(),s={...e,id:t,date:(0,f.getExecutionDate)(e.schedule),scheduledAt:(new Date).toISOString()},{nextState:n}=this.update(e=>{e.events[s.id]=(0,u.castDraft)(s)});return r(w,this).set(n),o(v,this,A).call(this,s),t}function A(e,t=!0){if(!t)return void o(v,this,M).call(this,e);const s=(0,f.getExecutionDate)(e.schedule),{nextState:n}=this.update(t=>{t.events[e.id].date=s});r(w,this).set(n),o(v,this,M).call(this,{...e,date:s})}function M(e){const t=h.DateTime.fromISO(e.date,{setZone:!0}).toMillis()-Date.now();if(t>s.DAILY_TIMEOUT)return;if(t<=0)return void o(v,this,O).call(this,e);const n=new b.Timer(t);n.start(()=>{o(v,this,O).call(this,e)}),r(y,this).set(e.id,n)}function O(e){if(this.messagingSystem.call("SnapController:handleRequest",{snapId:e.snapId,origin:g.METAMASK_ORIGIN,handler:m.HandlerType.OnCronjob,request:e.request}).catch(t=>{(0,m.logError)(`An error occurred while executing an event for Snap "${e.snapId}":`,t)}),r(y,this).delete(e.id),!e.recurring){const{nextState:t}=this.update(t=>{delete t.events[e.id]});return void r(w,this).set(t)}o(v,this,A).call(this,e)}function R(e){const t=r(y,this).get(e);null==t||t.cancel(),r(y,this).delete(e);const{nextState:s}=this.update(t=>{delete t.events[e]});r(w,this).set(s)}function N(e){const t=this.messagingSystem.call("PermissionController:getPermissions",e),s=null==t?void 0:t[l.SnapEndowments.Cronjob],n=(0,l.getCronjobCaveatJobs)(s);return n?n.map((t,s)=>({snapId:e,id:`cronjob-${e}-${s}`,request:t.request,schedule:(0,f.getCronjobSpecificationSchedule)(t),recurring:!0})):[]}function $(e=Object.values(this.state.events)){const t=Date.now();for(const s of e){if(r(y,this).has(s.id))continue;const e=h.DateTime.fromISO(s.date,{setZone:!0}).toUTC().toMillis();s.recurring&&e<=t?o(v,this,O).call(this,s):o(v,this,A).call(this,s,!1)}}function L(){const e=Date.now();for(const t of Object.values(this.state.events)){const s=h.DateTime.fromISO(t.date,{setZone:!0}).toUTC().toMillis();!t.recurring&&s<e&&o(v,this,R).call(this,t.id)}}s.CronjobController=E}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs",{"./CronjobController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./CronjobController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","cron-parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/cron-parser/lib/parser.js",luxon:"/home/runner/work/metamask-extension/metamask-extension/node_modules/luxon/build/cjs-browser/luxon.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getExecutionDate=s.getCronjobSpecificationSchedule=void 0;const n=e("@metamask/utils"),a=e("cron-parser"),r=e("luxon");s.getCronjobSpecificationSchedule=function(e){return(0,n.hasProperty)(e,"duration")?e.duration:e.expression},s.getExecutionDate=function(e){const t=r.DateTime.fromISO(e,{setZone:!0});if(t.isValid){const e=Date.now(),s=t.toUTC().startOf("second");if(s.toMillis()<e)throw new Error("Cannot schedule an event in the past.");return s.toISO({suppressMilliseconds:!0})}const s=r.Duration.fromISO(e);if(s.isValid){const e=function(e){return e.as("seconds")<1?r.Duration.fromObject({seconds:1}):e}(s);return r.DateTime.now().toUTC().plus(e).toISO()}try{const t=(0,a.parseExpression)(e,{utc:!0}).next(),s=r.DateTime.fromJSDate(t.toDate());return(0,n.assert)(s.isValid),s.toUTC().toISO()}catch{throw new Error(`Unable to parse "${e}" as ISO 8601 date, ISO 8601 duration, or cron expression.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/fsm.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@xstate/fsm":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@xstate/fsm/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.forceStrict=s.validateMachine=void 0;const n=e("@metamask/utils"),a=e("@xstate/fsm");s.validateMachine=function(e){(0,n.assert)("_options"in e,"The machine is not an @xstate/fsm machine");const t=e,s=new Set,a=e=>{return(t=e,Array.isArray(t)?t:t===undefined||null===t?[]:[t]).flatMap(e=>"string"==typeof e?[e]:((0,n.assert)("function"==typeof e),[])).forEach(s.add.bind(s));var t};for(const e of Object.values(t.config.states)){a(e.entry),a(e.exit);for(const t of Object.values(e.on??{}))a(t.actions)}s.forEach(e=>(0,n.assert)(t._options.actions!==undefined&&e in t._options.actions,`Action "${e}" doesn't have an implementation`))},s.forceStrict=function(e){let t=!1;e.subscribe(e=>{(0,n.assert)(!t||e.changed,"Invalid state transition"),t=!0});const s=e.send.bind(e);e.send=(...t)=>((0,n.assert)(e.status===a.InterpreterStatus.Running,"Interpreter is stopped"),s(...t))}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/fsm.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/index.cjs",{"./cronjob/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs","./insights/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/index.cjs","./interface/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/index.cjs","./multichain/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs","./services/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/index.cjs","./snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","./websocket/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./services/index.cjs"),s),a(e("./snaps/index.cjs"),s),a(e("./utils.cjs"),s),a(e("./cronjob/index.cjs"),s),a(e("./interface/index.cjs"),s),a(e("./insights/index.cjs"),s),a(e("./multichain/index.cjs"),s),a(e("./websocket/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function a(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapInsightsController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-rpc-methods"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("../snaps/index.cjs");var m=new WeakSet;class d extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{insights:{includeInStateLogs:!0,persist:!1,anonymous:!1,usedInUi:!0}},name:"SnapInsightsController",state:{insights:{},...t}}),n(this,m),this.messagingSystem.subscribe("TransactionController:unapprovedTransactionAdded",a(m,this,p).bind(this)),this.messagingSystem.subscribe("TransactionController:transactionStatusUpdated",a(m,this,b).bind(this)),this.messagingSystem.subscribe("SignatureController:stateChange",a(m,this,f).bind(this))}}function u(e){return(0,c.hasProperty)(this.state.insights,e)}function h(e){const t=this.messagingSystem.call("SnapController:getAll");return(0,l.getRunnableSnaps)(t).reduce((t,s)=>{const n=this.messagingSystem.call("PermissionController:getPermissions",s.id);return n&&(0,c.hasProperty)(n,e)&&t.push({snapId:s.id,permission:n[e]}),t},[])}function p(e){const{id:t,txParams:s,chainId:n,origin:r}=e,l=`eip155:${(0,c.hexToBigInt)(n).toString(10)}`;a(m,this,h).call(this,i.SnapEndowments.TransactionInsight).forEach(({snapId:e,permission:n})=>{const c=(0,i.getTransactionOriginCaveat)(n)&&r?r:null;this.update(s=>{var n;(n=s.insights)[t]??(n[t]={}),s.insights[t][e]={snapId:e,loading:!0}}),a(m,this,y).call(this,{snapId:e,handler:o.HandlerType.OnTransaction,params:{transaction:s,chainId:l,transactionOrigin:c}}).then(s=>a(m,this,w).call(this,{id:t,snapId:e,response:s})).catch(s=>a(m,this,w).call(this,{id:t,snapId:e,error:s}))})}function f(e){for(const t of Object.keys(this.state.insights))(0,c.hasProperty)(e.unapprovedTypedMessages,t)||(0,c.hasProperty)(e.unapprovedPersonalMsgs,t)||a(m,this,k).call(this,t);if(e.unapprovedPersonalMsgCount>0||e.unapprovedTypedMessagesCount>0){const t=a(m,this,h).call(this,i.SnapEndowments.SignatureInsight);for(const s of Object.values(e.unapprovedPersonalMsgs))a(m,this,g).call(this,t,s);for(const s of Object.values(e.unapprovedTypedMessages))a(m,this,g).call(this,t,s)}}function g(e,t){const{id:s,msgParams:n}=t;if(a(m,this,u).call(this,s))return;const{from:r,data:c,signatureMethod:l,origin:d}=n,h={from:r,data:"eth_signTypedData_v3"===l||"eth_signTypedData_v4"===l?JSON.parse(c):c,signatureMethod:l};e.forEach(({snapId:e,permission:t})=>{const n=(0,i.getSignatureOriginCaveat)(t),r=d&&n?d:null;this.update(t=>{var n;(n=t.insights)[s]??(n[s]={}),t.insights[s][e]={snapId:e,loading:!0}}),a(m,this,y).call(this,{snapId:e,handler:o.HandlerType.OnSignature,params:{signature:h,signatureOrigin:r}}).then(t=>a(m,this,w).call(this,{id:s,snapId:e,response:t})).catch(t=>a(m,this,w).call(this,{id:s,snapId:e,error:t}))})}function b({transactionMeta:e}){"unapproved"!==e.status&&a(m,this,k).call(this,e.id)}function k(e){a(m,this,u).call(this,e)&&(Object.values(this.state.insights[e]).filter(e=>e.interfaceId).forEach(e=>{this.messagingSystem.call("SnapInterfaceController:deleteInterface",e.interfaceId)}),this.update(t=>{delete t.insights[e]}))}async function y({snapId:e,handler:t,params:s}){return this.messagingSystem.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:t,request:{method:"",params:s}})}function w({id:e,snapId:t,response:s,error:n}){a(m,this,u).call(this,e)&&this.update(a=>{a.insights[e][t].loading=!1,a.insights[e][t].interfaceId=null==s?void 0:s.id,a.insights[e][t].severity=null==s?void 0:s.severity,a.insights[e][t].error=null==n?void 0:n.message})}s.SnapInsightsController=d}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/index.cjs",{"./SnapInsightsController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./SnapInsightsController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function a(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapInterfaceController=void 0;const r=e("@metamask/base-controller"),i=e("@metamask/snaps-sdk"),o=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("immer"),m=e("nanoid"),d=e("./utils.cjs"),u=1e7,h="SnapInterfaceController";var p=new WeakSet;class f extends r.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{interfaces:{includeInStateLogs:!0,persist:e=>Object.entries(e).reduce((e,[t,s])=>s.contentType===i.ContentType.Notification?(e[t]=s,e):e,{}),anonymous:!1,usedInUi:!0}},name:h,state:{interfaces:{},...t}}),n(this,p),this.messagingSystem.subscribe("NotificationServicesController:notificationsListUpdated",a(p,this,E).bind(this)),a(p,this,g).call(this)}createInterface(e,t,s,n){const r=(0,d.getJsxInterface)(t);a(p,this,j).call(this,r),(0,d.validateInterfaceContext)(s);const i=(0,m.nanoid)(),c=(0,d.constructState)({},r,{getAssetsState:a(p,this,P).bind(this),getAccountByAddress:a(p,this,_).bind(this),getSelectedAccount:a(p,this,v).bind(this),listAccounts:a(p,this,S).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});return this.update(t=>{t.interfaces[i]={snapId:e,content:(0,l.castDraft)(r),state:c,context:s??null,contentType:n??null}}),i}getInterface(e,t){return a(p,this,b).call(this,e,t),this.state.interfaces[t]}updateInterface(e,t,s,n){a(p,this,b).call(this,e,t);const r=(0,d.getJsxInterface)(s);a(p,this,j).call(this,r),(0,d.validateInterfaceContext)(n);const i=this.state.interfaces[t].state,c=(0,d.constructState)(i,r,{getAssetsState:a(p,this,P).bind(this),getAccountByAddress:a(p,this,_).bind(this),getSelectedAccount:a(p,this,v).bind(this),listAccounts:a(p,this,S).bind(this),snapOwnsAccount:t=>(0,o.snapOwnsAccount)(e,t)});this.update(e=>{e.interfaces[t].state=c,e.interfaces[t].content=(0,l.castDraft)(r),n&&(e.interfaces[t].context=n)})}deleteInterface(e){this.update(t=>{delete t.interfaces[e]})}updateInterfaceState(e,t){this.update(s=>{s.interfaces[e].state=t})}async resolveInterface(e,t,s){a(p,this,b).call(this,e,t),a(p,this,k).call(this,t),await a(p,this,x).call(this,t,s),this.deleteInterface(t)}}function g(){this.messagingSystem.registerActionHandler(`${h}:createInterface`,this.createInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:getInterface`,this.getInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterface`,this.updateInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:deleteInterface`,this.deleteInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterfaceState`,this.updateInterfaceState.bind(this)),this.messagingSystem.registerActionHandler(`${h}:resolveInterface`,this.resolveInterface.bind(this))}function b(e,t){const s=this.state.interfaces[t];(0,c.assert)(s!==undefined,`Interface with id '${t}' not found.`),(0,c.assert)(s.snapId===e,`Interface not created by ${e}.`)}function k(e){(0,c.assert)(a(p,this,w).call(this,e),`Approval request with id '${e}' not found.`)}function y(e){return this.messagingSystem.call("PhishingController:testOrigin",e).result}function w(e){return this.messagingSystem.call("ApprovalController:hasRequest",{id:e})}async function x(e,t){await this.messagingSystem.call("ApprovalController:acceptRequest",e,t)}function v(){return this.messagingSystem.call("AccountsController:getSelectedMultichainAccount")}function S(e){const t=this.messagingSystem.call("AccountsController:listMultichainAccounts");return e&&0!==e.length?t.filter(t=>t.scopes.some(t=>(0,d.isMatchingChainId)(t,e))):t}function _(e){const{address:t}=(0,c.parseCaipAccountId)(e);return this.messagingSystem.call("AccountsController:getAccountByAddress",t)}function P(){return this.messagingSystem.call("MultichainAssetsController:getState")}function T(e){return this.messagingSystem.call("SnapController:get",e)}function j(e){const t=(0,o.getJsonSizeUnsafe)(e);(0,c.assert)(t<=u,"A Snap UI may not be larger than 10 MB."),(0,o.validateJsxElements)(e,{isOnPhishingList:a(p,this,y).bind(this),getSnap:a(p,this,T).bind(this),getAccountByAddress:a(p,this,_).bind(this)})}function E(e){const t=e.filter(e=>"snap"===e.type&&(0,c.hasProperty)(e.data,"detailedView")),s=new Set(t.map(e=>e.data.detailedView.interfaceId));this.update(e=>{Object.entries(e.interfaces).forEach(([t,n])=>{n.contentType!==i.ContentType.Notification||s.has(t)||delete e.interfaces[t]})})}s.SnapInterfaceController=f}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/index.cjs",{"./SnapInterfaceController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./SnapInterfaceController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs",{"@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-sdk/jsx":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/jsx.js","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.validateInterfaceContext=s.constructState=s.getAccountSelectorStateValue=s.getAssetSelectorStateValue=s.getAccountSelectorDefaultStateValue=s.getDefaultAsset=s.formatAccountSelectorStateValue=s.isMatchingChainId=s.assertNameIsUnique=s.getJsxInterface=s.isStatefulComponent=void 0;const n=e("@metamask/snaps-sdk"),a=e("@metamask/snaps-sdk/jsx"),r=e("@metamask/snaps-utils"),i=e("@metamask/utils"),o=["Input","Dropdown","RadioGroup","FileInput","Checkbox","Selector","AssetSelector","AddressInput","AccountSelector"];function c(e){return o.includes(e.type)}function l(e,t){(0,n.assert)(e[t]===undefined,`Duplicate component names are not allowed, found multiple instances of: "${t}".`)}function m(e,t){return"eip155:0"===e?t.some(e=>{const{namespace:t}=(0,i.parseCaipChainId)(e);return t===i.KnownCaipNamespace.Eip155}):t.includes(e)}function d(e,t){const{id:s,address:n,scopes:a}=e,i=(0,r.createChainIdList)(a,t);return{accountId:s,addresses:(0,r.createAccountList)(n,i)}}function u(e,t,{getAccountByAddress:s,getAssetsState:a}){var r;const{assetsMetadata:o,accountsAssets:c}=a(),l=e.map(e=>(0,i.parseCaipAccountId)(e)).map(({chainId:e})=>e),m=t&&t.length>0?l.filter(e=>t.includes(e)):l,d=null===(r=s(e[0]))||void 0===r?void 0:r.id;(0,n.assert)(d,`Account not found for address: ${e[0]}.`);const u=c[d];if(0===u.length)return null;const h=u.find(e=>{const{chainId:t,assetNamespace:s}=(0,i.parseCaipAssetType)(e);return m.includes(t)&&"slip44"===s});return h?{asset:h,name:o[h].name,symbol:o[h].symbol}:{asset:u[0],name:o[u[0]].name,symbol:o[u[0]].symbol}}function h(e,{getSelectedAccount:t,listAccounts:s,snapOwnsAccount:n}){const{chainIds:a,hideExternalAccounts:r}=e.props,i=t();if((!a||0===a.length||i.scopes.some(e=>m(e,a)))&&(!r||r&&n(i)))return d(i,a);const o=s(a),c=r?o.filter(e=>n(e)):o;return 0===c.length?null:d(c[0],a)}function p(e,t){if(!e)return null;const{assetsMetadata:s}=t(),n=s[e];return n?{asset:e,name:n.name??n.symbol??"Unknown",symbol:n.symbol??"Unknown"}:null}function f(e,{getAccountByAddress:t,snapOwnsAccount:s}){const{value:n,hideExternalAccounts:a}=e.props;if(!n)return null;const r=t(n);return r?a&&!s(r)?null:d(r,e.props.chainIds):null}function g(e,t,s,n){const a=n?e[n]:e,o=null==a?void 0:a[t.props.name];return"FileInput"===t.type?o??null:function(e,t){switch(e.type){case"Checkbox":return e.props.checked;case"AssetSelector":return p(e.props.value,t.getAssetsState);case"AddressInput":{if(!e.props.value)return null;const{namespace:t,reference:s}=(0,i.parseCaipChainId)(e.props.chainId);return(0,i.toCaipAccountId)(t,s,e.props.value)}case"AccountSelector":return f(e,t);default:return e.props.value}}(t,s)??o??function(e,t){switch(e.type){case"Dropdown":var s;return null===(s=(0,r.getJsxChildren)(e)[0])||void 0===s?void 0:s.props.value;case"RadioGroup":var n;return null===(n=(0,r.getJsxChildren)(e)[0])||void 0===n?void 0:n.props.value;case"Selector":var a;return null===(a=(0,r.getJsxChildren)(e)[0])||void 0===a?void 0:a.props.value;case"AccountSelector":return h(e,t);case"Checkbox":return!1;case"AssetSelector":return u(e.props.addresses,e.props.chainIds,t);default:return null}}(t,s)??null}s.isStatefulComponent=c,s.getJsxInterface=function(e){return(0,a.isJSXElementUnsafe)(e)?e:(0,r.getJsxElementFromComponent)(e)},s.assertNameIsUnique=l,s.isMatchingChainId=m,s.formatAccountSelectorStateValue=d,s.getDefaultAsset=u,s.getAccountSelectorDefaultStateValue=h,s.getAssetSelectorStateValue=p,s.getAccountSelectorStateValue=f,s.constructState=function(e,t,s){const n={},a=[];return(0,r.walkJsx)(t,(t,r)=>{let i=a[a.length-1];if(i&&r<=i.depth&&(a.pop(),i=a[a.length-1]),"Form"===t.type)return l(n,t.props.name),a.push({name:t.props.name,depth:r}),void(n[t.props.name]={});if(i&&c(t)){const a=n[i.name];return l(a,t.props.name),void(a[t.props.name]=g(e,t,s,i.name))}c(t)&&(l(n,t.props.name),n[t.props.name]=g(e,t,s))}),n};const b=5e6;s.validateInterfaceContext=function(e){if(!e)return;const t=(0,r.getJsonSizeUnsafe)(e);(0,n.assert)(t<=b,"A Snap interface context may not be larger than 5 MB.")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.log=void 0;const n=e("@metamask/snaps-utils"),a=e("@metamask/utils");s.log=(0,a.createModuleLogger)(n.snapsLogger,"snaps-controllers")}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/logging.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.MultichainRouter=void 0;const l=e("@metamask/rpc-errors"),m=e("@metamask/snaps-rpc-methods"),d=e("@metamask/snaps-utils"),u=e("@metamask/utils"),h=e("nanoid"),p=e("../snaps/index.cjs"),f="MultichainRouter";var g=new WeakMap,b=new WeakMap,k=new WeakSet;async function y(e,t,s){try{const n=await i(b,this).call(this,async({keyring:n})=>n.resolveAccountAddress(e,t,s)),a=null==n?void 0:n.address;return a?(0,u.parseCaipAccountId)(a).address:null}catch{throw l.rpcErrors.internal()}}async function w(e,t,s){const n=i(g,this).call("AccountsController:listMultichainAccounts",t).filter(e=>{var t;return Boolean(null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled)&&e.methods.includes(s.method)});if(0===n.length)return null;const a=n[0].metadata.snap.id,r=await c(k,this,y).call(this,a,t,s),o=e.map(e=>(0,u.parseCaipAccountId)(e).address),m=n.find(e=>o.includes(e.address)&&(!r||e.address===r));if(!m)throw l.rpcErrors.invalidParams({message:"No available account found for request."});return m.id}function x(e){const t=i(g,this).call("SnapController:getAll");return(0,p.getRunnableSnaps)(t).reduce((t,s)=>{const n=i(g,this).call("PermissionController:getPermissions",s.id);if(n&&(0,u.hasProperty)(n,m.SnapEndowments.Protocol)){const a=n[m.SnapEndowments.Protocol],r=(0,m.getProtocolCaveatScopes)(a);r&&(0,u.hasProperty)(r,e)&&t.push({snapId:s.id,methods:r[e].methods})}return t},[])}function v(e){return i(g,this).call("AccountsController:listMultichainAccounts",e).filter(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})}s.MultichainRouter=class{constructor({messenger:e,withSnapKeyring:t}){var s,c;a(s=this,c=k),c.add(s),r(this,"name",f),r(this,"state",null),n(this,g,void 0),n(this,b,void 0),o(g,this,e),o(b,this,t),i(g,this).registerActionHandler(`${f}:handleRequest`,async(...e)=>this.handleRequest(...e)),i(g,this).registerActionHandler(`${f}:getSupportedMethods`,(...e)=>this.getSupportedMethods(...e)),i(g,this).registerActionHandler(`${f}:getSupportedAccounts`,(...e)=>this.getSupportedAccounts(...e)),i(g,this).registerActionHandler(`${f}:isSupportedScope`,(...e)=>this.isSupportedScope(...e))}async handleRequest({connectedAddresses:e,origin:t,scope:s,request:n}){(0,u.assert)(!s.startsWith(u.KnownCaipNamespace.Eip155)&&!s.startsWith("wallet:eip155"));const a={jsonrpc:"2.0",id:n.id??(0,h.nanoid)(),method:n.method,...n.params?{params:n.params}:{}},{method:r,params:o}=a,m=await c(k,this,w).call(this,e,s,a);if(m)return i(b,this).call(this,async({keyring:e})=>e.submitRequest({origin:t,account:m,scope:s,method:r,params:o}));const p=c(k,this,x).call(this,s).find(e=>e.methods.includes(r));if(p)return i(g,this).call("SnapController:handleRequest",{snapId:p.snapId,origin:t,request:{method:"",params:{request:a,scope:s}},handler:d.HandlerType.OnProtocolRequest});throw l.rpcErrors.methodNotFound()}getSupportedMethods(e){const t=c(k,this,v).call(this,e).flatMap(e=>e.methods),s=c(k,this,x).call(this,e).flatMap(e=>e.methods);return Array.from(new Set([...t,...s]))}getSupportedAccounts(e){return c(k,this,v).call(this,e).map(t=>`${e}:${t.address}`)}isSupportedScope(e){return i(g,this).call("AccountsController:listMultichainAccounts",e).some(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})||c(k,this,x).call(this,e).length>0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs",{"./MultichainRouter.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./MultichainRouter.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs",{"../logging.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs","../snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/json-rpc-middleware-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs","@metamask/object-multiplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/object-multiplex/dist/index.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var l=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.setupMultiplex=s.AbstractExecutionService=void 0;const m=e("@metamask/json-rpc-engine"),d=e("@metamask/json-rpc-middleware-stream"),u=l(e("@metamask/object-multiplex")),h=e("@metamask/rpc-errors"),p=e("@metamask/snaps-utils"),f=e("@metamask/utils"),g=e("nanoid"),b=e("readable-stream"),k=e("../logging.cjs"),y=e("../snaps/Timer.cjs"),w=e("../utils.cjs"),x="ExecutionService";var v=new WeakMap,S=new WeakMap,_=new WeakMap,P=new WeakMap,T=new WeakMap,j=new WeakMap,E=new WeakMap,C=new WeakMap,I=new WeakSet;function A(){i(P,this).registerActionHandler(`${x}:handleRpcRequest`,async(e,t)=>this.handleRpcRequest(e,t)),i(P,this).registerActionHandler(`${x}:executeSnap`,async e=>this.executeSnap(e)),i(P,this).registerActionHandler(`${x}:terminateSnap`,async e=>this.terminateSnap(e)),i(P,this).registerActionHandler(`${x}:terminateAllSnaps`,async()=>this.terminateAllSnaps())}async function M(e,t){const{streams:s,worker:n}=await c(I,this,O).call(this,e,t),a=new m.JsonRpcEngine,r=(0,d.createStreamMiddleware)();(0,b.pipeline)(r.stream,s.command,r.stream,e=>{var t;!e||null!==(t=e.message)&&void 0!==t&&t.match("Premature close")||(0,p.logError)("Command stream failure.",e)}),a.push(r.middleware);const o={id:e,streams:s,rpcEngine:a,worker:n};return i(v,this).set(e,o),o}async function O(e,t){const s=await(0,w.withTimeout)(this.initEnvStream(e),t);if(s===w.hasTimedOut){this.terminateJob({id:e});if("created"===i(S,this).get(e))throw new Error(`The executor for "${e}" couldn't start initialization. The offscreen document may not exist.`);throw new Error(`The executor for "${e}" failed to initialize. The iframe/webview/worker failed to load.`)}const{worker:n,stream:a}=s,r=N(a,`Snap: "${e}"`),o=r.createStream(p.SNAP_STREAM_NAMES.COMMAND),c=t=>{(0,f.hasProperty)(t,"id")||("OutboundRequest"===t.method?i(P,this).publish("ExecutionService:outboundRequest",e):"OutboundResponse"===t.method?i(P,this).publish("ExecutionService:outboundResponse",e):"UnhandledError"===t.method?(i(P,this).publish("ExecutionService:unhandledError",e,t.params.error),o.removeListener("data",c)):(0,p.logError)(new Error(`Received unexpected command stream notification "${t.method}".`)))};o.on("data",c);const l=r.createStream(p.SNAP_STREAM_NAMES.JSON_RPC);l.on("data",t=>{null!=t&&t.data&&(0,f.hasProperty)(null==t?void 0:t.data,"id")&&i(P,this).publish("ExecutionService:outboundRequest",e)});const m=l.write.bind(l);return l.write=(t,s,n)=>{var a;return"metamask_chainChanged"===(null==t||null===(a=t.data)||void 0===a?void 0:a.method)||(null!=t&&t.data&&(0,f.hasProperty)(null==t?void 0:t.data,"id")&&i(P,this).publish("ExecutionService:outboundResponse",e),m(t,s,n))},{streams:{command:o,rpc:l,_connection:a},worker:n}}async function R(e,t){const s=i(v,this).get(e);if(!s)throw new Error(`"${e}" is not currently running.`);(0,k.log)("Parent: Sending Command",t);const n=await s.rpcEngine.handle(t);if((0,f.hasProperty)(n,"error")){const e=n.error;throw new h.JsonRpcError(e.code,e.message,e.data)}return n.result}function N(e,t){const s=new u.default;return(0,b.pipeline)(e,s,e,e=>{var s;!e||null!==(s=e.message)&&void 0!==s&&s.match("Premature close")||(0,p.logError)(`"${t}" stream failure.`,e)}),s}s.AbstractExecutionService=class{constructor({setupSnapProvider:e,messenger:t,initTimeout:s=(0,f.inMilliseconds)(60,f.Duration.Second),pingTimeout:i=(0,f.inMilliseconds)(2,f.Duration.Second),terminationTimeout:l=(0,f.inMilliseconds)(1,f.Duration.Second),usePing:m=!0}){var d,u;a(d=this,u=I),u.add(d),r(this,"name",x),r(this,"state",null),n(this,v,void 0),n(this,S,void 0),n(this,_,void 0),n(this,P,void 0),n(this,T,void 0),n(this,j,void 0),n(this,E,void 0),n(this,C,void 0),o(v,this,new Map),o(S,this,new Map),o(_,this,e),o(P,this,t),o(T,this,s),o(j,this,i),o(E,this,l),o(C,this,m),c(I,this,A).call(this)}async terminateSnap(e){const t=i(v,this).get(e);if(t){try{const t=await(0,w.withTimeout)(c(I,this,R).call(this,e,{jsonrpc:"2.0",method:"terminate",params:[],id:(0,g.nanoid)()}),i(E,this));t!==w.hasTimedOut&&"OK"===t||(0,p.logWarning)(`Snap "${e}" failed to terminate gracefully.`)}catch{}Object.values(t.streams).forEach(e=>{try{e.destroyed||e.destroy()}catch(e){(0,p.logError)("Error while destroying stream",e)}}),this.terminateJob(t),i(v,this).delete(e),i(S,this).delete(e),(0,k.log)(`Snap "${e}" terminated.`)}}setSnapStatus(e,t){i(S,this).set(e,t)}async terminateAllSnaps(){await Promise.all([...i(v,this).keys()].map(async e=>this.terminateSnap(e)))}async executeSnap({snapId:e,sourceCode:t,endowments:s}){if(i(v,this).has(e))throw new Error(`"${e}" is already running.`);this.setSnapStatus(e,"created");const n=new y.Timer(i(T,this)),a=await c(I,this,M).call(this,e,n);if(i(C,this)){if(await(0,w.withTimeout)(c(I,this,R).call(this,a.id,{jsonrpc:"2.0",method:"ping",id:(0,g.nanoid)()}),i(j,this))===w.hasTimedOut)throw new Error(`The executor for "${e}" was unreachable. The executor did not respond in time.`)}const r=a.streams.rpc;i(_,this).call(this,e,r);const o=Math.max(n.remaining,i(T,this)/2);this.setSnapStatus(e,"initialized");const l={jsonrpc:"2.0",method:"executeSnap",params:{snapId:e,sourceCode:t,endowments:s},id:(0,g.nanoid)()};(0,f.assertIsJsonRpcRequest)(l),this.setSnapStatus(e,"executing");const m=await(0,w.withTimeout)(c(I,this,R).call(this,a.id,l),o);if(m===w.hasTimedOut)throw new Error(`${e} failed to start.`);return"OK"===m&&this.setSnapStatus(e,"running"),m}async handleRpcRequest(e,t){const{handler:s,request:n,origin:a}=t;return await c(I,this,R).call(this,e,{id:(0,g.nanoid)(),jsonrpc:"2.0",method:"snapRpc",params:{origin:a,handler:s,request:n,target:e}})}},s.setupMultiplex=N}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs",{"@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,s){return e.set(o(e,t),s),s}function o(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.ProxyPostMessageStream=void 0;const c=e("@metamask/post-message-stream");var l=new WeakMap,m=new WeakMap,d=new WeakSet;class u extends c.BasePostMessageStream{constructor({stream:e,jobId:t}){var s,c;super(),a(s=this,c=d),c.add(s),n(this,l,void 0),n(this,m,void 0),i(l,this,e),i(m,this,t),r(l,this).on("data",o(d,this,h).bind(this))}_postMessage(e){r(l,this).write({jobId:r(m,this),data:e})}}function h(e){e.jobId===r(m,this)&&this.push(e.data)}s.ProxyPostMessageStream=u}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs",{"../AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.IframeExecutionService=void 0;const a=e("@metamask/post-message-stream"),r=e("@metamask/snaps-utils"),i=e("../AbstractExecutionService.cjs");class o extends i.AbstractExecutionService{constructor({iframeUrl:e,messenger:t,setupSnapProvider:s,...a}){super({...a,messenger:t,setupSnapProvider:s}),n(this,"iframeUrl",void 0),this.iframeUrl=e}terminateJob(e){var t;null===(t=document.getElementById(e.id))||void 0===t||t.remove()}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=await(0,r.createWindow)({uri:this.iframeUrl.toString(),id:e});return{worker:t,stream:new a.WindowPostMessageStream({name:"parent",target:"child",targetWindow:t,targetOrigin:"*"})}}}s.IframeExecutionService=o}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs",{"./IframeExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./IframeExecutionService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/index.cjs",{"./AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","./ProxyPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs","./iframe/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs","./offscreen/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./AbstractExecutionService.cjs"),s),a(e("./ProxyPostMessageStream.cjs"),s),a(e("./iframe/index.cjs"),s),a(e("./offscreen/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs",{"../proxy/ProxyExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs","@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function a(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.OffscreenExecutionService=void 0;const r=e("@metamask/post-message-stream"),i=e("../proxy/ProxyExecutionService.cjs");var o=new WeakMap;class c extends i.ProxyExecutionService{constructor({messenger:e,setupSnapProvider:t,offscreenPromise:s,...i}){var c,l,m;super({...i,messenger:e,setupSnapProvider:t,stream:new r.BrowserRuntimePostMessageStream({name:"parent",target:"child"})}),n(this,o,void 0),l=this,m=s,(c=o).set(a(c,l),m)}async initEnvStream(e){var t,s;return await(t=o,s=this,t.get(a(t,s))),await super.initEnvStream(e)}}s.OffscreenExecutionService=c}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs",{"./OffscreenExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./OffscreenExecutionService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs",{"../AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","../ProxyPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function a(e,t){return e.get(r(e,t))}function r(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.ProxyExecutionService=void 0;const i=e("nanoid"),o=e("../AbstractExecutionService.cjs"),c=e("../ProxyPostMessageStream.cjs");var l=new WeakMap;class m extends o.AbstractExecutionService{constructor({stream:e,messenger:t,setupSnapProvider:s,...a}){var i,o,c;super({...a,messenger:t,setupSnapProvider:s,usePing:!1}),n(this,l,void 0),o=this,c=e,(i=l).set(r(i,o),c)}async terminateJob(e){a(l,this).write({jobId:e.id,data:{jsonrpc:"2.0",method:"terminateJob",id:(0,i.nanoid)()}})}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=new c.ProxyPostMessageStream({stream:a(l,this),jobId:e});return await new Promise(e=>{t.once("data",e),t.write({name:"command",data:{jsonrpc:"2.0",method:"ping",id:(0,i.nanoid)()}})}),{worker:e,stream:t}}}s.ProxyExecutionService=m}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs",{"../fsm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/fsm.cjs","../logging.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","./Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./location/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs","./registry/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs","@metamask/approval-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/approval-controller/dist/index.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/permission-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-controller/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@xstate/fsm":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@xstate/fsm/lib/index.js","async-mutex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/async-mutex/lib/index.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs",semver:"/home/runner/work/metamask-extension/metamask-extension/node_modules/semver/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function a(e,t,s){r(e,t),t.set(e,s)}function r(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapController=s.SNAP_APPROVAL_RESULT=s.SNAP_APPROVAL_UPDATE=s.SNAP_APPROVAL_INSTALL=s.controllerName=void 0;const l=e("@metamask/approval-controller"),m=e("@metamask/base-controller"),d=e("@metamask/permission-controller"),u=e("@metamask/rpc-errors"),h=e("@metamask/snaps-rpc-methods"),p=e("@metamask/snaps-sdk"),f=e("@metamask/snaps-utils"),g=e("@metamask/utils"),b=e("@xstate/fsm"),k=e("async-mutex"),y=e("nanoid"),w=e("semver"),x=e("./constants.cjs"),v=e("./location/index.cjs"),S=e("./registry/index.cjs"),_=e("./selectors.cjs"),P=e("./Timer.cjs"),T=e("../fsm.cjs"),j=e("../logging.cjs"),E=e("../utils.cjs");s.controllerName="SnapController",s.SNAP_APPROVAL_INSTALL="wallet_installSnap",s.SNAP_APPROVAL_UPDATE="wallet_updateSnap",s.SNAP_APPROVAL_RESULT="wallet_installSnapResult";const C=new Set(["initialPermissions","id","version","enabled","blocked"]),I={snaps:{},snapStates:{},unencryptedSnapStates:{}};function A(e){return Object.keys(e).reduce((t,s)=>(C.has(s)&&(t[s]=e[s]),t),{})}var M=new WeakMap,O=new WeakMap,R=new WeakMap,N=new WeakMap,$=new WeakMap,L=new WeakMap,B=new WeakMap,F=new WeakMap,D=new WeakMap,H=new WeakMap,U=new WeakMap,q=new WeakMap,V=new WeakMap,W=new WeakMap,G=new WeakMap,K=new WeakMap,z=new WeakMap,J=new WeakMap,Y=new WeakMap,X=new WeakMap,Z=new WeakSet,Q=new WeakMap;class ee extends m.BaseController{constructor({closeAllConnections:e,messenger:t,state:l,dynamicPermissions:m=["eth_accounts"],environmentEndowmentPermissions:d=[],excludedPermissions:u={},idleTimeCheckInterval:h=(0,g.inMilliseconds)(5,g.Duration.Second),maxIdleTime:b=(0,g.inMilliseconds)(30,g.Duration.Second),maxRequestTime:k=(0,g.inMilliseconds)(60,g.Duration.Second),fetchFunction:y=globalThis.fetch.bind(undefined),featureFlags:w={},detectSnapLocation:S=v.detectSnapLocation,preinstalledSnaps:_=null,encryptor:P,getMnemonicSeed:T,getFeatureFlags:j=()=>({}),clientCryptography:C,trackEvent:A}){var ee,re,ie;super({messenger:t,metadata:{snapStates:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1},unencryptedSnapStates:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1},snaps:{includeInStateLogs:e=>Object.values(e).reduce((e,t)=>{const s={...t};return delete s.sourceCode,delete s.auxiliaryFiles,e[t.id]=s,e},{}),persist:e=>Object.values(e).filter(e=>e.status!==f.SnapStatus.Installing).map(e=>({...e,status:f.SnapStatus.Stopped})).reduce((e,t)=>(e[t.id]=t,e),{}),anonymous:!1,usedInUi:!0}},name:s.controllerName,state:{...I,...l}}),r(re=this,ie=Z),ie.add(re),a(this,M,void 0),a(this,O,void 0),a(this,R,void 0),a(this,N,void 0),a(this,$,void 0),a(this,L,void 0),a(this,B,void 0),a(this,F,void 0),n(this,"maxRequestTime",void 0),a(this,D,void 0),a(this,H,void 0),a(this,U,void 0),a(this,q,void 0),a(this,V,void 0),a(this,W,void 0),a(this,G,void 0),a(this,K,void 0),a(this,z,void 0),a(this,J,void 0),a(this,Y,void 0),a(this,X,void 0),a(this,Q,(0,E.debouncePersistState)((e,t,s)=>{c(Z,this,Ye).call(this,e).stateMutex.runExclusive(async()=>{const n=await c(Z,this,be).call(this,e,t,s);return s?this.update(t=>{t.snapStates[e]=n}):this.update(t=>{t.unencryptedSnapStates[e]=n})}).catch(f.logError)},x.STATE_DEBOUNCE_TIMEOUT)),o(M,this,e),o(O,this,m),o(R,this,d),o(N,this,u),o($,this,w),o(L,this,y),o(B,this,h),o(F,this,b),this.maxRequestTime=k,o(V,this,S),o(D,this,P),o(H,this,T),o(U,this,j),o(q,this,C),o(J,this,_),this._onUnhandledSnapError=this._onUnhandledSnapError.bind(this),this._onOutboundRequest=this._onOutboundRequest.bind(this),this._onOutboundResponse=this._onOutboundResponse.bind(this),o(G,this,new Map),o(W,this,new Map),o(Y,this,A),c(Z,this,ae).call(this),this.messagingSystem.subscribe("ExecutionService:unhandledError",this._onUnhandledSnapError),this.messagingSystem.subscribe("ExecutionService:outboundRequest",this._onOutboundRequest),this.messagingSystem.subscribe("ExecutionService:outboundResponse",this._onOutboundResponse),this.messagingSystem.subscribe("SnapController:snapInstalled",({id:e},t)=>{c(Z,this,rt).call(this,t,e,f.HandlerType.OnInstall).catch(t=>{(0,f.logError)(`Error when calling \`onInstall\` lifecycle hook for snap "${e}": ${(0,p.getErrorMessage)(t)}`)})}),this.messagingSystem.subscribe("SnapController:snapUpdated",({id:e},t,s)=>{c(Z,this,rt).call(this,s,e,f.HandlerType.OnUpdate).catch(t=>{(0,f.logError)(`Error when calling \`onUpdate\` lifecycle hook for snap "${e}": ${(0,p.getErrorMessage)(t)}`)})}),this.messagingSystem.subscribe("KeyringController:lock",c(Z,this,it).bind(this)),c(Z,this,te).call(this),c(Z,this,se).call(this),Object.values((null===(ee=this.state)||void 0===ee?void 0:ee.snaps)??{}).forEach(e=>c(Z,this,Xe).call(this,e.id)),i(J,this)&&c(Z,this,ne).call(this,i(J,this)),o(X,this,(0,E.throttleTracking)((e,t,s,n)=>{const a=this.messagingSystem.call("SnapsRegistry:getMetadata",e);i(Y,this).call(this,{event:"Snap Export Used",category:"Snaps",properties:{snap_id:e,export:t,snap_category:null==a?void 0:a.category,success:s,origin:n}})}))}init(){c(Z,this,at).call(this,x.METAMASK_ORIGIN,f.HandlerType.OnStart)}async updateRegistry(){c(Z,this,le).call(this),await this.messagingSystem.call("SnapsRegistry:update");const e=await this.messagingSystem.call("SnapsRegistry:get",Object.values(this.state.snaps).reduce((e,t)=>(e[t.id]={version:t.version,checksum:t.manifest.source.shasum},e),{}));if(await Promise.all(Object.entries(e).map(async([e,{status:t,reason:s}])=>t===S.SnapsRegistryStatus.Blocked?c(Z,this,re).call(this,e,s):c(Z,this,ie).call(this,e))),!i($,this).autoUpdatePreinstalledSnaps)return;await Promise.allSettled(Object.values(this.state.snaps).filter(e=>e.preinstalled).map(async e=>{const t=await c(Z,this,Te).call(this,e.id,"*");if("*"!==t&&(0,g.gtVersion)(t,e.version)){const s=i(V,this).call(this,e.id,{versionRange:t,fetch:i(L,this),allowLocal:!1});await c(Z,this,Pe).call(this,{origin:l.ORIGIN_METAMASK,snapId:e.id,location:s,versionRange:t,automaticUpdate:!0})}}))}_onUnhandledSnapError(e,t){(0,f.logError)(`Unhandled error from "${e}":`,t),this.stopSnap(e,f.SnapStatusEvents.Crash).catch(e=>{(0,f.logError)(e)})}_onOutboundRequest(e){const t=c(Z,this,Ye).call(this,e);t.pendingInboundRequests.filter(e=>"running"===e.timer.status).forEach(e=>e.timer.pause()),t.pendingOutboundRequests+=1}_onOutboundResponse(e){const t=c(Z,this,Ye).call(this,e);t.pendingOutboundRequests-=1,0===t.pendingOutboundRequests&&t.pendingInboundRequests.filter(e=>"paused"===e.timer.status).forEach(e=>e.timer.resume())}async startSnap(e){c(Z,this,le).call(this);const t=this.state.snaps[e];if(!t.enabled)throw new Error(`Snap "${e}" is disabled.`);await c(Z,this,Ee).call(this,{snapId:e,sourceCode:t.sourceCode})}enableSnap(e){if(this.getExpect(e),this.state.snaps[e].blocked)throw new Error(`Snap "${e}" is blocked and cannot be enabled.`);this.update(t=>{t.snaps[e].enabled=!0}),this.messagingSystem.publish("SnapController:snapEnabled",this.getTruncatedExpect(e))}async disableSnap(e){if(!this.has(e))throw new Error(`Snap "${e}" not found.`);this.update(t=>{t.snaps[e].enabled=!1}),this.isRunning(e)&&await this.stopSnap(e,f.SnapStatusEvents.Stop),this.messagingSystem.publish("SnapController:snapDisabled",this.getTruncatedExpect(e))}async stopSnap(e,t=f.SnapStatusEvents.Stop){const s=c(Z,this,Je).call(this,e);if(!s)throw new Error(`The snap "${e}" is not running.`);if(s.stopPromise)return void await s.stopPromise;const{promise:n,resolve:a}=(0,g.createDeferredPromise)();s.stopPromise=n;try{var r;if(this.isRunning(e))null===(r=i(M,this))||void 0===r||r.call(this,e),await c(Z,this,ue).call(this,e)}finally{s.lastRequest=null,s.pendingInboundRequests=[],s.pendingOutboundRequests=0,s.stopPromise=null,this.isRunning(e)&&c(Z,this,de).call(this,e,t),a()}}async stopAllSnaps(e=f.SnapStatusEvents.Stop){const t=Object.values(this.state.snaps).filter(e=>this.isRunning(e.id)).map(async t=>this.stopSnap(t.id,e));await Promise.allSettled(t)}isRunning(e){return"running"===this.getExpect(e).status}has(e){return Boolean(this.get(e))}get(e){return this.state.snaps[e]}getExpect(e){const t=this.get(e);return(0,g.assert)(t!==undefined,`Snap "${e}" not found.`),t}getTruncated(e){const t=this.get(e);return t?A(t):null}getTruncatedExpect(e){return A(this.getExpect(e))}async updateSnapState(e,t,s){const n=c(Z,this,Ye).call(this,e);s?n.state=t:n.unencryptedState=t,i(Q,this).call(this,e,t,s)}clearSnapState(e,t){const s=c(Z,this,Ye).call(this,e);t?s.state=null:s.unencryptedState=null,i(Q,this).call(this,e,null,t)}async getSnapState(e,t){const s=c(Z,this,Ye).call(this,e);return await s.getStateMutex.runExclusive(async()=>{const n=t?s.state:s.unencryptedState;if(n!==undefined)return n;const a=t?this.state.snapStates[e]:this.state.unencryptedSnapStates[e];if(null===a||a===undefined)return null;if(!t){const e=JSON.parse(a);return s.unencryptedState=e,e}const r=await c(Z,this,fe).call(this,e,a);return s.state=r,r})}async getSnapFile(e,t,s=p.AuxiliaryFileEncoding.Base64){var n;const a=this.getExpect(e),r=(0,f.normalizeRelative)(t),i=null===(n=a.auxiliaryFiles)||void 0===n||null===(n=n.find(e=>e.path===r))||void 0===n?void 0:n.value;if(!i)return null;const o=await(0,f.encodeAuxiliaryFile)(i,s);return(0,g.assert)(o.length<f.MAX_FILE_SIZE,`Failed to encode static file to "${s}": Static files must be less than 64 MB when encoded.`),o}isMinimumPlatformVersion(e,t){const s=this.getExpect(e),{platformVersion:n}=s.manifest;return!!n&&(0,w.gte)(n,t)}async clearState(){const e=Object.keys(this.state.snaps);await this.stopAllSnaps(),e.forEach(e=>c(Z,this,xe).call(this,e)),this.update(e=>{e.snaps={},e.snapStates={},e.unencryptedSnapStates={}}),i(W,this).clear(),i(G,this).clear(),i(J,this)&&c(Z,this,ne).call(this,i(J,this))}async removeSnap(e){return this.removeSnaps([e])}async removeSnaps(e){if(!Array.isArray(e))throw new Error("Expected array of snap ids.");e.forEach(e=>{const t=this.getExpect(e);(0,g.assert)(!1!==t.removable,`${e} is not removable.`)}),await Promise.all(e.map(async e=>{const t=this.getExpect(e),s=this.getTruncatedExpect(e);await this.disableSnap(e),c(Z,this,xe).call(this,e),c(Z,this,we).call(this,e),i(W,this).delete(e),this.update(t=>{delete t.snaps[e],delete t.snapStates[e],delete t.unencryptedSnapStates[e]}),t.status!==f.SnapStatus.Installing&&this.messagingSystem.publish("SnapController:snapUninstalled",s)}))}removeSnapFromSubject(e,t){var s,n;const a=this.messagingSystem.call("PermissionController:getPermissions",e),r=null==a||null===(s=a[h.WALLET_SNAP_PERMISSION_KEY])||void 0===s||null===(s=s.caveats)||void 0===s?void 0:s.find(e=>e.type===f.SnapCaveatType.SnapIds);if(!r)return;if(Boolean(null===(n=r.value)||void 0===n?void 0:n[t])){const s={...r.value};delete s[t],Object.keys(s).length>0?this.messagingSystem.call("PermissionController:updateCaveat",e,h.WALLET_SNAP_PERMISSION_KEY,f.SnapCaveatType.SnapIds,s):this.messagingSystem.call("PermissionController:revokePermissions",{[e]:[h.WALLET_SNAP_PERMISSION_KEY]})}}revokeDynamicSnapPermissions(e,t){(0,g.assert)(t.every(e=>i(O,this).includes(e)),"Non-dynamic permissions cannot be revoked"),this.messagingSystem.call("PermissionController:revokePermissions",{[e]:t})}incrementActiveReferences(e){c(Z,this,Ye).call(this,e).activeReferences+=1}decrementActiveReferences(e){const t=c(Z,this,Ye).call(this,e);(0,g.assert)(t.activeReferences>0,"SnapController reference management is in an invalid state."),t.activeReferences-=1}getAllSnaps(){return Object.values(this.state.snaps).map(A)}getRunnableSnaps(){return(0,_.getRunnableSnaps)(this.getAllSnaps())}getPermittedSnaps(e){var t;const s=(null===(t=(this.messagingSystem.call("PermissionController:getPermissions",e)??{})[h.WALLET_SNAP_PERMISSION_KEY])||void 0===t||null===(t=t.caveats)||void 0===t||null===(t=t.find(e=>e.type===f.SnapCaveatType.SnapIds))||void 0===t?void 0:t.value)??{};return Object.keys(s).reduce((e,t)=>{const s=this.get(t),n=this.getTruncated(t);return n&&(null==s?void 0:s.status)!==f.SnapStatus.Installing&&(e[t]=n),e},{})}async installSnaps(e,t){c(Z,this,le).call(this);const s={},n=Object.keys(t),a=[],r=[];try{for(const[n,{version:o}]of Object.entries(t)){(0,f.assertIsValidSnapId)(n);const[t,l]=(0,f.resolveVersionRange)(o);if(t)throw u.rpcErrors.invalidParams(`The "version" field must be a valid SemVer version range if specified. Received: "${o}".`);const m=i(V,this).call(this,n,{versionRange:l,fetch:i(L,this),allowLocal:i($,this).allowLocalSnaps,resolveVersion:async e=>i($,this).requireAllowlist?await c(Z,this,Te).call(this,n,e):e}),d=this.has(n)&&!m.shouldAlwaysReload;if(d&&c(Z,this,nt).call(this,n,l)){const e=this.getExpect(n);a.push({snapId:n,oldVersion:e.version});let t=c(Z,this,We).call(this,n);if(t!==undefined)throw new Error("This snap is already being updated.");t=c(Z,this,Ge).call(this,n),t.newVersion=l}else d||r.push(n);s[n]=await c(Z,this,ve).call(this,e,n,m,l)}r.forEach(t=>this.messagingSystem.publish("SnapController:snapInstalled",this.getTruncatedExpect(t),e,!1)),a.forEach(({snapId:t,oldVersion:s})=>this.messagingSystem.publish("SnapController:snapUpdated",this.getTruncatedExpect(t),s,e,!1)),n.forEach(e=>i(G,this).delete(e))}catch(e){const t=r.filter(e=>this.has(e));await this.removeSnaps(t);const s=[...i(G,this).keys()],n=a.map(({snapId:e})=>e).filter(e=>s.includes(e));throw await c(Z,this,ze).call(this,n),e}return s}destroy(){super.destroy(),i(K,this)&&clearTimeout(i(K,this)),this.messagingSystem.unsubscribe("ExecutionService:unhandledError",this._onUnhandledSnapError),this.messagingSystem.unsubscribe("ExecutionService:outboundRequest",this._onOutboundRequest),this.messagingSystem.unsubscribe("ExecutionService:outboundResponse",this._onOutboundResponse),this.messagingSystem.clearEventSubscriptions("SnapController:snapInstalled"),this.messagingSystem.clearEventSubscriptions("SnapController:snapUpdated")}async handleRequest({snapId:e,origin:t,handler:s,request:n}){c(Z,this,le).call(this),(0,g.assert)(t===x.METAMASK_ORIGIN||(0,f.isValidUrl)(t),"'origin' must be a valid URL or 'metamask'.");const a={jsonrpc:"2.0",id:(0,y.nanoid)(),...n};(0,g.assertIsJsonRpcRequest)(a);const r=h.handlerEndowments[s];(0,g.assert)("string"==typeof r||null===r,"'permissionName' must be either a string or null.");const i=this.messagingSystem.call("PermissionController:getPermissions",e);if(!(null===r||i&&(0,g.hasProperty)(i,r)))throw new Error(`Snap "${e}" is not permitted to use "${r}".`);const o=r?i[r]:undefined;if(r===h.SnapEndowments.Rpc||r===h.SnapEndowments.Keyring){(0,g.assert)(o);const s=this.messagingSystem.call("SubjectMetadataController:getSubjectMetadata",t),n=r===h.SnapEndowments.Rpc?(0,h.getRpcCaveatOrigins)(o):(0,h.getKeyringCaveatOrigins)(o);if((0,g.assert)(n),!(0,f.isOriginAllowed)(n,(null==s?void 0:s.subjectType)??d.SubjectType.Website,t))throw new Error(`Snap "${e}" is not permitted to handle requests from "${t}".`)}if(t!==x.METAMASK_ORIGIN&&x.CLIENT_ONLY_HANDLERS.includes(s))throw new Error(`"${s}" can only be invoked by MetaMask.`);if(!this.state.snaps[e].enabled)throw new Error(`Snap "${e}" is disabled.`);if(this.state.snaps[e].status===f.SnapStatus.Installing)throw new Error(`Snap "${e}" is currently being installed. Please try again later.`);const l=c(Z,this,Re).call(this,o),m=c(Z,this,Ye).call(this,e);if(m.stopPromise&&await m.stopPromise,!this.isRunning(e)){m.startPromise||(m.startPromise=this.startSnap(e));try{await m.startPromise}finally{m.startPromise=null}}const u=c(Z,this,He).call(this,e,s,a),p=new P.Timer(l);c(Z,this,qe).call(this,e,u.id,p);const b=this.messagingSystem.call("ExecutionService:handleRpcRequest",e,{origin:t,handler:s,request:u});try{const n=await(0,E.withTimeout)(b,p);if(n===E.hasTimedOut){const t=null!==m.stopPromise||!this.isRunning(e);throw new Error(t?`${e} was stopped and the request was cancelled. This is likely because the Snap crashed.`:`${e} failed to respond to the request in time.`)}await c(Z,this,Ue).call(this,e,s,n);const a=await c(Z,this,Le).call(this,e,s,u,n);return c(Z,this,Ve).call(this,e,u.id,s,t,!0),a}catch(n){c(Z,this,Ve).call(this,e,u.id,s,t,!1);const[a,r]=(0,f.unwrapError)(n),i=null!==m.stopPromise||!this.isRunning(e);throw r||(i||(0,f.logError)(`"${e}" crashed due to an unhandled error:`,a),await this.stopSnap(e,f.SnapStatusEvents.Crash)),a}}setClientActive(e){e?c(Z,this,at).call(this,x.METAMASK_ORIGIN,f.HandlerType.OnActive):c(Z,this,at).call(this,x.METAMASK_ORIGIN,f.HandlerType.OnInactive)}}function te(){const e=({snapId:e})=>this.getExpect(e).enabled,t={initial:f.SnapStatus.Installing,states:{[f.SnapStatus.Installing]:{on:{[f.SnapStatusEvents.Start]:{target:f.SnapStatus.Running,cond:e}}},[f.SnapStatus.Updating]:{on:{[f.SnapStatusEvents.Start]:{target:f.SnapStatus.Running,cond:e},[f.SnapStatusEvents.Stop]:f.SnapStatus.Stopped}},[f.SnapStatus.Running]:{on:{[f.SnapStatusEvents.Stop]:f.SnapStatus.Stopped,[f.SnapStatusEvents.Crash]:f.SnapStatus.Crashed}},[f.SnapStatus.Stopped]:{on:{[f.SnapStatusEvents.Start]:{target:f.SnapStatus.Running,cond:e},[f.SnapStatusEvents.Update]:f.SnapStatus.Updating}},[f.SnapStatus.Crashed]:{on:{[f.SnapStatusEvents.Start]:{target:f.SnapStatus.Running,cond:e},[f.SnapStatusEvents.Update]:f.SnapStatus.Updating}}}};o(z,this,(0,b.createMachine)(t)),(0,T.validateMachine)(i(z,this))}function se(){this.messagingSystem.registerActionHandler(`${s.controllerName}:init`,(...e)=>this.init(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:clearSnapState`,(...e)=>this.clearSnapState(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:get`,(...e)=>this.get(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:getSnapState`,async(...e)=>this.getSnapState(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:handleRequest`,async(...e)=>this.handleRequest(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:has`,(...e)=>this.has(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:updateRegistry`,async()=>this.updateRegistry()),this.messagingSystem.registerActionHandler(`${s.controllerName}:updateSnapState`,async(...e)=>this.updateSnapState(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:enable`,(...e)=>this.enableSnap(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:disable`,async(...e)=>this.disableSnap(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:remove`,async(...e)=>this.removeSnap(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:getPermitted`,(...e)=>this.getPermittedSnaps(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:install`,async(...e)=>this.installSnaps(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:getAll`,(...e)=>this.getAllSnaps(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:getRunnableSnaps`,(...e)=>this.getRunnableSnaps(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:incrementActiveReferences`,(...e)=>this.incrementActiveReferences(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:decrementActiveReferences`,(...e)=>this.decrementActiveReferences(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:disconnectOrigin`,(...e)=>this.removeSnapFromSubject(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:revokeDynamicPermissions`,(...e)=>this.revokeDynamicSnapPermissions(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:getFile`,async(...e)=>this.getSnapFile(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:stopAllSnaps`,async(...e)=>this.stopAllSnaps(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:isMinimumPlatformVersion`,(...e)=>this.isMinimumPlatformVersion(...e)),this.messagingSystem.registerActionHandler(`${s.controllerName}:setClientActive`,(...e)=>this.setClientActive(...e))}function ne(e){for(const{snapId:s,manifest:n,files:a,removable:r,hidden:i,hideSnapBranding:o}of e){var t;const e=this.get(s),l=e!==undefined,m=l&&(0,g.gtVersion)(n.version,e.version);if(l&&(!m||!0!==e.preinstalled))continue;const d=new f.VirtualFile({path:f.NpmSnapFileNames.Manifest,value:JSON.stringify(n),result:n}),u=a.map(({path:e,value:t})=>new f.VirtualFile({value:t,path:e})),{filePath:p,iconPath:b}=n.source.location.npm,k=u.find(e=>e.path===p),y=b?u.find(e=>e.path===b):undefined;(0,g.assert)(k,"Source code not provided for preinstalled snap."),(0,g.assert)(!b||b&&y,"Icon not provided for preinstalled snap."),(0,g.assert)(n.source.files===undefined,"Auxiliary files are not currently supported for preinstalled snaps.");const w=(null===(t=n.source.locales)||void 0===t?void 0:t.map(e=>u.find(t=>t.path===e)))??[],v=(0,f.getValidatedLocalizationFiles)(w.filter(Boolean));(0,g.assert)(w.length===v.length,"Missing localization files for preinstalled snap.");const S={manifest:d,sourceCode:k,svgIcon:y,auxiliaryFiles:[],localizationFiles:v};c(Z,this,Ie).call(this,{id:s,origin:x.METAMASK_ORIGIN,files:S,removable:r,hidden:i,hideSnapBranding:o,preinstalled:!0});const _=(0,h.processSnapPermissions)(n.initialPermissions);c(Z,this,Ae).call(this,_);const{newPermissions:P,unusedPermissions:T}=c(Z,this,Ze).call(this,s,_);c(Z,this,st).call(this,{snapId:s,newPermissions:P,unusedPermissions:T}),n.initialConnections&&c(Z,this,ke).call(this,s,(null==e?void 0:e.initialConnections)??null,n.initialConnections),this.update(e=>{e.snaps[s].status=f.SnapStatus.Stopped}),c(Z,this,Xe).call(this,s),m?this.messagingSystem.publish("SnapController:snapUpdated",this.getTruncatedExpect(s),e.version,x.METAMASK_ORIGIN,!0):this.messagingSystem.publish("SnapController:snapInstalled",this.getTruncatedExpect(s),x.METAMASK_ORIGIN,!0)}}function ae(){o(K,this,setTimeout(()=>{c(Z,this,me).call(this).catch(e=>{(0,f.logError)(e)}),c(Z,this,ae).call(this)},i(B,this)))}async function re(e,t){if(this.has(e)){try{this.update(s=>{s.snaps[e].blocked=!0,s.snaps[e].blockInformation=t}),await this.disableSnap(e)}catch(t){(0,f.logError)(`Encountered error when stopping blocked snap "${e}".`,t)}this.messagingSystem.publish(`${s.controllerName}:snapBlocked`,e,t)}}function ie(e){this.has(e)&&this.state.snaps[e].blocked&&(this.update(t=>{t.snaps[e].blocked=!1,delete t.snaps[e].blockInformation}),this.messagingSystem.publish(`${s.controllerName}:snapUnblocked`,e))}async function oe(e,{platformVersion:t,...s}){const n=(await this.messagingSystem.call("SnapsRegistry:get",{[e]:s}))[e];var a;if(n.status===S.SnapsRegistryStatus.Blocked)throw new Error(`Cannot install version "${s.version}" of snap "${e}": The version is blocked. ${(null===(a=n.reason)||void 0===a?void 0:a.explanation)??""}`);const r=Object.keys(s.permissions).some(e=>!x.ALLOWED_PERMISSIONS.includes(e));if(i($,this).requireAllowlist&&r&&n.status!==S.SnapsRegistryStatus.Verified)throw new Error(`Cannot install version "${s.version}" of snap "${e}": ${n.status===S.SnapsRegistryStatus.Unavailable?"The registry is temporarily unavailable.":"The snap is not on the allowlist."}`);c(Z,this,Me).call(this,e,t)}function ce(){(0,g.assert)(!0!==i($,this).disableSnapInstallation,"Installing Snaps is currently disabled in this version of MetaMask.")}function le(){const e=i(U,this).call(this);(0,g.assert)(!0!==e.disableSnaps,"The Snaps platform requires basic functionality to be used. Enable basic functionality in the settings to use the Snaps platform.")}async function me(){const e=[...i(W,this).entries()];return Promise.all(e.filter(([e,t])=>0===t.activeReferences&&0===t.pendingInboundRequests.length&&t.lastRequest&&i(F,this)&&(0,g.timeSince)(t.lastRequest)>i(F,this)).map(async([e])=>this.stopSnap(e,f.SnapStatusEvents.Stop)))}function de(e,t){const{interpreter:s}=c(Z,this,Ye).call(this,e);s.send(t),this.update(t=>{t.snaps[e].status=s.state.value})}async function ue(e){await this.messagingSystem.call("ExecutionService:terminateSnap",e),await new Promise(e=>setTimeout(e,1));c(Z,this,Ye).call(this,e).pendingInboundRequests.filter(e=>"finished"!==e.timer.status).forEach(e=>e.timer.finish()),await new Promise(e=>setTimeout(e,1)),this.messagingSystem.publish("SnapController:snapTerminated",this.getTruncatedExpect(e))}function he(e,t=c(Z,this,Ye).call(this,e)){return null!==t.encryptionKey&&null!==t.encryptionSalt}async function pe({snapId:e,salt:t,useCache:s,keyMetadata:n}){const a=c(Z,this,Ye).call(this,e);if(c(Z,this,he).call(this,e,a)&&s)return{key:await i(D,this).importKey(a.encryptionKey),salt:a.encryptionSalt};const r=t??i(D,this).generateSalt(),o=await i(H,this).call(this),l=await(0,h.getEncryptionEntropy)({snapId:e,seed:o,cryptographicFunctions:i(q,this)}),m=await i(D,this).keyFromPassword(l,r,!0,n),d=await i(D,this).exportKey(m);return s&&(a.encryptionKey=d,a.encryptionSalt=r),{key:m,salt:r}}async function fe(e,t){try{const s=JSON.parse(t),{salt:n,keyMetadata:a}=s,r=c(Z,this,he).call(this,e)||i(D,this).isVaultUpdated(t),{key:o}=await c(Z,this,pe).call(this,{snapId:e,salt:n,useCache:r,keyMetadata:a??x.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS});return await i(D,this).decryptWithKey(o,s)}catch{throw u.rpcErrors.internal({message:"Failed to decrypt snap state, the state must be corrupted."})}}async function ge(e,t){const{key:s,salt:n}=await c(Z,this,pe).call(this,{snapId:e,useCache:!0}),a=await i(D,this).encryptWithKey(s,t);return a.salt=n,JSON.stringify(a)}async function be(e,t,s){return null===t?null:s?await c(Z,this,ge).call(this,e,t):JSON.stringify(t)}function ke(e,t,s){if(t){const n=(0,E.setDiff)(t,s);for(const t of Object.keys(n))this.removeSnapFromSubject(t,e)}for(const t of Object.keys(s))c(Z,this,ye).call(this,t,e)}function ye(e,t){var s,n;const a=this.messagingSystem.call("PermissionController:getPermissions",e),r=null==a||null===(s=a[h.WALLET_SNAP_PERMISSION_KEY])||void 0===s||null===(s=s.caveats)||void 0===s?void 0:s.find(e=>e.type===f.SnapCaveatType.SnapIds);if(Boolean(null==r||null===(n=r.value)||void 0===n?void 0:n[t]))return;if(r)return void this.messagingSystem.call("PermissionController:updateCaveat",e,h.WALLET_SNAP_PERMISSION_KEY,f.SnapCaveatType.SnapIds,{...r.value,[t]:{}});const i={[h.WALLET_SNAP_PERMISSION_KEY]:{caveats:[{type:f.SnapCaveatType.SnapIds,value:{[t]:{}}}]}};this.messagingSystem.call("PermissionController:grantPermissions",{approvedPermissions:i,subject:{origin:e}})}function we(e){const t=this.messagingSystem.call("PermissionController:getSubjectNames");for(const s of t)this.removeSnapFromSubject(s,e)}function xe(e){this.messagingSystem.call("PermissionController:hasPermissions",e)&&this.messagingSystem.call("PermissionController:revokeAllPermissions",e)}async function ve(e,t,n,a){const r=this.getTruncated(t);if(r&&!n.shouldAlwaysReload)return(0,g.satisfiesVersionRange)(r.version,a)?r:await c(Z,this,Pe).call(this,{origin:e,snapId:t,location:n,versionRange:a});c(Z,this,ce).call(this);let i=c(Z,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_INSTALL});this.messagingSystem.publish("SnapController:snapInstallStarted",t,e,!1),r&&this.isRunning(t)&&await this.stopSnap(t,f.SnapStatusEvents.Stop),r&&n.shouldAlwaysReload&&c(Z,this,xe).call(this,t);try{const{sourceCode:r}=await c(Z,this,je).call(this,{origin:e,id:t,location:n,versionRange:a});await c(Z,this,Oe).call(this,t,i),i=c(Z,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_RESULT}),await c(Z,this,Ee).call(this,{snapId:t,sourceCode:r});const o=this.getTruncatedExpect(t);return c(Z,this,_e).call(this,i.id,{loading:!1,type:s.SNAP_APPROVAL_INSTALL}),o}catch(n){(0,f.logError)(`Error when adding ${t}.`,n);const a=n instanceof Error?n.message:n.toString();throw c(Z,this,_e).call(this,i.id,{loading:!1,type:s.SNAP_APPROVAL_INSTALL,error:a}),this.messagingSystem.publish("SnapController:snapInstallFailed",t,e,!1,a),n}}function Se({origin:e,snapId:t,type:s}){const n=(0,y.nanoid)();return{id:n,promise:this.messagingSystem.call("ApprovalController:addRequest",{origin:e,id:n,type:s,requestData:{metadata:{id:n,origin:t,dappOrigin:e},snapId:t},requestState:{loading:!0}},!0)}}function _e(e,t){try{this.messagingSystem.call("ApprovalController:updateRequestState",{id:e,requestState:t})}catch{}}async function Pe({origin:e,snapId:t,location:n,versionRange:a,automaticUpdate:r=!1}){c(Z,this,ce).call(this),c(Z,this,le).call(this);const i=this.getExpect(t),{preinstalled:o,removable:l,hidden:m,hideSnapBranding:d}=i;if(o&&!r)throw new Error("Preinstalled Snaps cannot be manually updated.");let p=r?null:c(Z,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_UPDATE});try{this.messagingSystem.publish("SnapController:snapInstallStarted",t,e,!0);const b=i.manifest,k=await(0,E.fetchSnap)(t,n),{sourceCode:y,manifest:w}=k,x=w.result,v=x.version;if(!(0,g.gtVersion)(v,i.version))throw u.rpcErrors.invalidParams(`Snap "${t}@${i.version}" is already installed. Couldn't update to a version inside requested "${a}" range.`);if(!(0,g.satisfiesVersionRange)(v,a))throw new Error(`Version mismatch. Manifest for "${t}" specifies version "${v}" which doesn't satisfy requested version range "${a}".`);await c(Z,this,oe).call(this,t,{version:v,checksum:x.source.shasum,permissions:x.initialPermissions,platformVersion:x.platformVersion});const S=(0,h.processSnapPermissions)(x.initialPermissions);c(Z,this,Ae).call(this,S);const{newPermissions:_,unusedPermissions:P,approvedPermissions:T}=c(Z,this,Ze).call(this,t,S),{newConnections:j,unusedConnections:C,approvedConnections:I}=c(Z,this,et).call(this,t,b.initialConnections??{},x.initialConnections??{});let A,M;if(p){c(Z,this,_e).call(this,p.id,{permissions:_,newVersion:x.version,newPermissions:_,approvedPermissions:T,unusedPermissions:P,newConnections:j,unusedConnections:C,approvedConnections:I,loading:!1});const{permissions:n,...a}=await p.promise;A=n,M=a,p=c(Z,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_RESULT})}else(0,g.assert)(r),A=_;this.isRunning(t)&&await this.stopSnap(t,f.SnapStatusEvents.Stop),c(Z,this,de).call(this,t,f.SnapStatusEvents.Update),c(Z,this,Ie).call(this,{origin:e,id:t,files:k,removable:l,preinstalled:o,hidden:m,hideSnapBranding:d,isUpdate:!0}),c(Z,this,st).call(this,{snapId:t,unusedPermissions:P,newPermissions:A,requestData:M});const O=b.initialConnections??null,R=x.initialConnections??{};c(Z,this,ke).call(this,t,O,R);const N=c(Z,this,We).call(this,t);N!==undefined&&(N.permissions.revoked=P,N.permissions.granted=A,N.permissions.requestData=M,N.previousInitialConnections=O,N.newInitialConnections=R);const $=y.toString();(0,g.assert)("string"==typeof $&&$.length>0,`Invalid source code for snap "${t}".`);try{await c(Z,this,Ee).call(this,{snapId:t,sourceCode:$})}catch{throw new Error(`Snap ${t} crashed with updated source code.`)}const L=this.getTruncatedExpect(t);return p&&c(Z,this,_e).call(this,p.id,{loading:!1,type:s.SNAP_APPROVAL_UPDATE}),L}catch(n){(0,f.logError)(`Error when updating ${t},`,n);const a=n instanceof Error?n.message:n.toString();throw p&&c(Z,this,_e).call(this,p.id,{loading:!1,error:a,type:s.SNAP_APPROVAL_UPDATE}),this.messagingSystem.publish("SnapController:snapInstallFailed",t,e,!0,a),n}}async function Te(e,t){return await this.messagingSystem.call("SnapsRegistry:resolveVersion",e,t)}async function je(e){const{id:t,location:s,versionRange:n}=e;c(Z,this,Xe).call(this,t);const a=c(Z,this,Ye).call(this,t);a.installPromise||((0,j.log)(`Adding snap: ${t}`),a.installPromise=(async()=>{const a=await(0,E.fetchSnap)(t,s),r=a.manifest.result;if(!(0,g.satisfiesVersionRange)(r.version,n))throw new Error(`Version mismatch. Manifest for "${t}" specifies version "${r.version}" which doesn't satisfy requested version range "${n}".`);await c(Z,this,oe).call(this,t,{version:r.version,checksum:r.source.shasum,permissions:r.initialPermissions,platformVersion:r.platformVersion});const o=i($,this).forcePreinstalledSnaps&&(0,E.isLocalSnapId)(t)?{preinstalled:!0,hideSnapBranding:!0,hidden:!1}:{};return c(Z,this,Ie).call(this,{...e,files:a,id:t,...o})})());try{return await a.installPromise}catch(e){throw a.installPromise=null,e}}async function Ee(e){const{snapId:t}=e;if(this.isRunning(t))throw new Error(`Snap "${t}" is already started.`);try{const s=c(Z,this,Ye).call(this,t),n=await this.messagingSystem.call("ExecutionService:executeSnap",{...e,endowments:await c(Z,this,Ce).call(this,t)});return c(Z,this,de).call(this,t,f.SnapStatusEvents.Start),s.lastRequest=Date.now(),n}catch(e){throw await c(Z,this,ue).call(this,t),e}}async function Ce(e){let t=[];for(const s of i(R,this))if(this.messagingSystem.call("PermissionController:hasPermission",e,s)){const n=await this.messagingSystem.call("PermissionController:getEndowments",e,s);if(n){if(!Array.isArray(n)||n.some(e=>"string"!=typeof e))throw new Error("Expected an array of string endowment names.");t=t.concat(n)}}const s=[...new Set([...f.DEFAULT_ENDOWMENTS,...t])];return s.length<f.DEFAULT_ENDOWMENTS.length+t.length&&(0,f.logError)(`Duplicate endowments found for ${e}. Default endowments should not be requested.`,t),s}function Ie(e){const{id:t,origin:s,files:n,isUpdate:a=!1,removable:r,preinstalled:o,hidden:l,hideSnapBranding:m}=e,{manifest:u,sourceCode:h,svgIcon:p,auxiliaryFiles:b,localizationFiles:k}=n;(0,f.assertIsSnapManifest)(u.result);const{version:y}=u.result,w=h.toString();(0,g.assert)("string"==typeof w&&w.length>0,`Invalid source code for snap "${t}".`);const x=b.map(e=>((0,g.assert)("string"==typeof e.data.base64),{path:e.path,value:e.data.base64})),v=this.state.snaps[t],S=[...(null==v?void 0:v.versionHistory)??[],{version:y,date:Date.now(),origin:s}],_=k.map(e=>e.result),P={...v,blocked:!1,enabled:!0,removable:r,preinstalled:o,hidden:l,hideSnapBranding:m,id:t,initialConnections:u.result.initialConnections,initialPermissions:u.result.initialPermissions,manifest:u.result,status:i(z,this).config.initial,sourceCode:w,version:y,versionHistory:S,auxiliaryFiles:x,localizationFiles:_};delete P.blockInformation;const{inversePatches:T}=this.update(e=>{e.snaps[t]=P});if(a){const e=c(Z,this,We).call(this,t);e!==undefined&&(e.statePatches=T)}const{proposedName:j}=(0,f.getLocalizedSnapManifest)(u.result,"en",_);return this.messagingSystem.call("SubjectMetadataController:addSubjectMetadata",{subjectType:d.SubjectType.Snap,name:j,origin:P.id,version:y,svgIcon:(null==p?void 0:p.toString())??null}),{...P,sourceCode:w}}function Ae(e){const t=Object.keys(e),s=Array.from(new Set(Object.values(h.handlerEndowments)));(0,g.assert)(t.some(e=>s.includes(e)),`A snap must request at least one of the following permissions: ${s.filter(e=>null!==e).join(", ")}.`);const n=t.reduce((e,t)=>((0,g.hasProperty)(i(N,this),t)&&e.push(i(N,this)[t]),e),[]);(0,g.assert)(0===n.length,`One or more permissions are not allowed:\n${n.join("\n")}`)}function Me(e,t){if(t!==undefined&&(0,w.gt)(t,(0,f.getPlatformVersion)())){const s=`The Snap "${e}" requires platform version "${t}" which is greater than the current platform version "${(0,f.getPlatformVersion)()}".`;if(i($,this).rejectInvalidPlatformVersion)throw new Error(s);(0,f.logWarning)(s)}}async function Oe(e,t){(0,j.log)(`Authorizing snap: ${e}`);const s=this.state.snaps[e],{initialPermissions:n,initialConnections:a}=s;try{const r=(0,h.processSnapPermissions)(n);c(Z,this,Ae).call(this,r),c(Z,this,_e).call(this,t.id,{loading:!1,connections:a??{},permissions:r});const{permissions:i,...o}=await t.promise;c(Z,this,st).call(this,{snapId:e,newPermissions:i,requestData:o}),s.manifest.initialConnections&&c(Z,this,ke).call(this,e,null,s.manifest.initialConnections)}finally{c(Z,this,Ye).call(this,e).installPromise=null}}function Re(e){return(0,h.getMaxRequestTimeCaveat)(e)??this.maxRequestTime}async function Ne(e,t,s){return this.messagingSystem.call("SnapInterfaceController:createInterface",e,t,undefined,s)}function $e(e,t){(0,g.assert)(this.messagingSystem.call("SnapInterfaceController:getInterface",e,t))}async function Le(e,t,s,n){switch(t){case f.HandlerType.OnTransaction:case f.HandlerType.OnSignature:case f.HandlerType.OnHomePage:case f.HandlerType.OnSettingsPage:{const t=n;if(t&&(0,g.hasProperty)(t,"content")){const{content:s,...n}=t;return{...n,id:await c(Z,this,Ne).call(this,e,s)}}return n}case f.HandlerType.OnAssetsLookup:return c(Z,this,Be).call(this,e,s,n);case f.HandlerType.OnAssetsConversion:return c(Z,this,Fe).call(this,s,n);case f.HandlerType.OnAssetsMarketData:return c(Z,this,De).call(this,s,n);default:return n}}function Be(e,{params:t},{assets:s}){const n=this.messagingSystem.call("PermissionController:getPermissions",e);(0,g.assert)(n);const a=n[h.SnapEndowments.Assets],r=(0,h.getChainIdsCaveat)(a);(0,g.assert)(r);const{assets:i}=t;return{assets:Object.keys(s).reduce((e,t)=>{const n=t;return r.some(e=>n.startsWith(e))&&i.includes(n)&&(e[n]=s[n]),e},{})}}function Fe({params:e},{conversionRates:t}){const{conversions:s}=e;return{conversionRates:s.reduce((e,s)=>{var n;const a=null===(n=t[s.from])||void 0===n?void 0:n[s.to];var r;a&&(e[r=s.from]??(e[r]={}),e[s.from][s.to]=a);return e},{})}}function De({params:e},{marketData:t}){const{assets:s}=e;return{marketData:s.reduce((e,s)=>{var n;const a=null===(n=t[s.asset])||void 0===n?void 0:n[s.unit];var r;a&&(e[r=s.asset]??(e[r]={}),e[s.asset][s.unit]=a);return e},{})}}function He(e,t,s){if(t===f.HandlerType.OnUserInput){(0,g.assert)(s.params&&(0,g.hasProperty)(s.params,"id"));const t=s.params.id,{context:n}=this.messagingSystem.call("SnapInterfaceController:getInterface",e,t);return{...s,params:{...s.params,context:n}}}return s}async function Ue(e,t,s){switch(t){case f.HandlerType.OnTransaction:(0,g.assertStruct)(s,f.OnTransactionResponseStruct),s&&(0,g.hasProperty)(s,"id")&&c(Z,this,$e).call(this,e,s.id);break;case f.HandlerType.OnSignature:(0,g.assertStruct)(s,f.OnSignatureResponseStruct),s&&(0,g.hasProperty)(s,"id")&&c(Z,this,$e).call(this,e,s.id);break;case f.HandlerType.OnHomePage:(0,g.assertStruct)(s,f.OnHomePageResponseStruct),s&&(0,g.hasProperty)(s,"id")&&c(Z,this,$e).call(this,e,s.id);break;case f.HandlerType.OnSettingsPage:(0,g.assertStruct)(s,f.OnSettingsPageResponseStruct),s&&(0,g.hasProperty)(s,"id")&&c(Z,this,$e).call(this,e,s.id);break;case f.HandlerType.OnNameLookup:(0,g.assertStruct)(s,f.OnNameLookupResponseStruct);break;case f.HandlerType.OnAssetsLookup:(0,g.assertStruct)(s,p.OnAssetsLookupResponseStruct);break;case f.HandlerType.OnAssetsConversion:(0,g.assertStruct)(s,f.OnAssetsConversionResponseStruct);break;case f.HandlerType.OnAssetHistoricalPrice:(0,g.assertStruct)(s,f.OnAssetHistoricalPriceResponseStruct);break;case f.HandlerType.OnAssetsMarketData:(0,g.assertStruct)(s,f.OnAssetsMarketDataResponseStruct)}}function qe(e,t,s){const n=c(Z,this,Ye).call(this,e);n.pendingInboundRequests.push({requestId:t,timer:s}),n.lastRequest=null}function Ve(e,t,s,n,a){const r=c(Z,this,Ye).call(this,e);r.pendingInboundRequests=r.pendingInboundRequests.filter(e=>e.requestId!==t),0===r.pendingInboundRequests.length&&(r.lastRequest=Date.now());const o=this.get(e);if((0,E.isTrackableHandler)(s)&&(null==o||!o.preinstalled))try{i(X,this).call(this,e,s,a,n)}catch(e){(0,f.logError)(`Error when calling MetaMetrics hook for snap "${null==o?void 0:o.id}": ${(0,p.getErrorMessage)(e)}`)}}function We(e){return i(G,this).get(e)}function Ge(e){(0,g.assert)(i(G,this).get(e)===undefined,`Snap "${e}" rollback snapshot already exists.`),i(G,this).set(e,{statePatches:[],permissions:{},newVersion:""});const t=i(G,this).get(e);return(0,g.assert)(t!==undefined,`Snapshot creation failed for ${e}.`),t}async function Ke(e){var t,s;const n=c(Z,this,We).call(this,e);if(!n)throw new Error("A snapshot does not exist for this snap.");await this.stopSnap(e,f.SnapStatusEvents.Stop),(null===(t=this.get(e))||void 0===t?void 0:t.status)!==f.SnapStatus.Stopped&&c(Z,this,de).call(this,e,f.SnapStatusEvents.Stop);const{statePatches:a,permissions:r,previousInitialConnections:o,newInitialConnections:l}=n;null!=a&&a.length&&this.applyPatches(a),(null===(s=this.get(e))||void 0===s?void 0:s.status)!==f.SnapStatus.Stopped&&this.update(t=>{t.snaps[e].status=f.SnapStatus.Stopped}),c(Z,this,st).call(this,{snapId:e,unusedPermissions:r.granted,newPermissions:r.revoked,requestData:r.requestData}),c(Z,this,ke).call(this,e,l??null,o??{});const m=this.getTruncatedExpect(e);this.messagingSystem.publish("SnapController:snapRolledback",m,n.newVersion),i(G,this).delete(e)}async function ze(e){for(const t of e)await c(Z,this,Ke).call(this,t)}function Je(e){return i(W,this).get(e)}function Ye(e){const t=c(Z,this,Je).call(this,e);return(0,g.assert)(t!==undefined,`Snap "${e}" runtime data not found`),t}function Xe(e){if(i(W,this).has(e))return;const t=this.get(e),s=(0,b.interpret)(i(z,this));s.start({context:{snapId:e},value:(null==t?void 0:t.status)??i(z,this).config.initial}),(0,T.forceStrict)(s),i(W,this).set(e,{lastRequest:null,startPromise:null,stopPromise:null,installPromise:null,encryptionKey:null,encryptionSalt:null,activeReferences:0,pendingInboundRequests:[],pendingOutboundRequests:0,interpreter:s,stateMutex:new k.Mutex,getStateMutex:new k.Mutex})}function Ze(e,t){const s=this.messagingSystem.call("PermissionController:getPermissions",e)??{},n=(0,E.permissionsDiff)(t,s),a=(0,E.permissionsDiff)(s,t);return{newPermissions:n,unusedPermissions:a,approvedPermissions:(0,E.permissionsDiff)(s,a)}}function Qe(e,t){var s,n;const a=this.messagingSystem.call("PermissionController:getPermissions",t),r=null==a||null===(s=a[h.WALLET_SNAP_PERMISSION_KEY])||void 0===s||null===(s=s.caveats)||void 0===s?void 0:s.find(e=>e.type===f.SnapCaveatType.SnapIds);return Boolean(null==r||null===(n=r.value)||void 0===n?void 0:n[e])}function et(e,t,s){const n=Object.keys(t).filter(t=>c(Z,this,Qe).call(this,e,t)).reduce((e,s)=>(e[s]=t[s],e),{}),a=(0,E.setDiff)(s,n),r=(0,E.setDiff)(n,s);return{newConnections:a,unusedConnections:r,approvedConnections:(0,E.setDiff)(n,r)}}function tt(e,t){if(Object.keys(t).includes(h.SnapEndowments.EthereumProvider)){const s=this.messagingSystem.call("SelectedNetworkController:getNetworkClientIdForDomain",e),{configuration:n}=this.messagingSystem.call("NetworkController:getNetworkClientById",s),a=(0,g.hexToNumber)(n.chainId);return{...t,"endowment:caip25":{caveats:[{type:"authorizedScopes",value:{requiredScopes:{},optionalScopes:{[`eip155:${a}`]:{accounts:[]}},sessionProperties:{},isMultichainOrigin:!1}}]}}}return t}function st({snapId:e,unusedPermissions:t={},newPermissions:s={},requestData:n}){const a=Object.keys(t);if((0,g.isNonEmptyArray)(a)&&this.messagingSystem.call("PermissionController:revokePermissions",{[e]:a}),(0,g.isNonEmptyArray)(Object.keys(s))){const t=c(Z,this,tt).call(this,e,s);this.messagingSystem.call("PermissionController:grantPermissions",{approvedPermissions:t,subject:{origin:e},requestData:n})}}function nt(e,t){const s=this.getExpect(e);return!(0,g.satisfiesVersionRange)(s.version,t)&&!(0,g.gtRange)(s.version,t)}function at(e,t){const s=this.getRunnableSnaps();for(const{id:n}of s){this.messagingSystem.call("PermissionController:hasPermission",n,h.SnapEndowments.LifecycleHooks)&&c(Z,this,rt).call(this,e,n,t).catch(e=>{(0,f.logError)(`Error calling lifecycle hook "${t}" for Snap "${n}": ${(0,p.getErrorMessage)(e)}`)})}}async function rt(e,t,s){const n=h.handlerEndowments[s];(0,g.assert)(n,"Lifecycle hook must have an endowment.");this.messagingSystem.call("PermissionController:hasPermission",t,n)&&await this.handleRequest({snapId:t,handler:s,origin:e,request:{jsonrpc:"2.0",method:s}})}function it(){for(const e of i(W,this).values())e.encryptionKey=null,e.encryptionSalt=null,e.state=undefined}s.SnapController=ee}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.Timer=void 0;const a=e("@metamask/utils");s.Timer=class{constructor(e){n(this,"state",void 0),(0,a.assert)(!Number.isNaN(e),new TypeError("Can't start a timer with NaN time")),(0,a.assert)(e>=0,new TypeError("Can't start a timer with negative time")),this.state={value:"stopped",remaining:e}}get status(){return this.state.value}get remaining(){return this.state.remaining}cancel(){(0,a.assert)("paused"===this.status||"running"===this.status,"Tried to cancel a not running Timer"),this.onFinish(!1)}finish(){(0,a.assert)("finished"!==this.status,"Tried to finish a finished Timer."),this.onFinish(!0)}pause(){(0,a.assert)("running"===this.state.value,"Tried to pause a not running Timer");const{callback:e,start:t,timeout:s,remaining:n}=this.state;s!==undefined&&clearTimeout(s),this.state={value:"paused",callback:e,remaining:n-(Date.now()-t)}}start(e){(0,a.assert)("stopped"===this.state.value,"Tried to start an already running Timer");const{remaining:t}=this.state;this.state={value:"paused",remaining:t,callback:e},this.resume()}resume(){(0,a.assert)("paused"===this.state.value,"Tried to resume not paused Timer");const{remaining:e,callback:t}=this.state,s=Date.now();let n;e!==Number.POSITIVE_INFINITY&&(n=setTimeout(()=>this.onFinish(!0),e)),this.state={value:"running",callback:t,remaining:e,start:s,timeout:n}}onFinish(e){(0,a.assert)("running"===this.state.value||"paused"===this.state.value),"running"===this.state.value&&this.state.timeout!==undefined&&clearTimeout(this.state.timeout);const{callback:t,remaining:s}=this.state;this.state={value:"finished",remaining:"running"===this.state.value?s-(Date.now()-this.state.start):s},e&&t()}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs",{"@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.CLIENT_ONLY_HANDLERS=s.METAMASK_ORIGIN=s.STATE_DEBOUNCE_TIMEOUT=s.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS=s.ALLOWED_PERMISSIONS=void 0;const n=e("@metamask/snaps-rpc-methods"),a=e("@metamask/snaps-utils");s.ALLOWED_PERMISSIONS=Object.freeze(["snap_dialog","snap_manageState","snap_notify","snap_getLocale",n.SnapEndowments.Cronjob,n.SnapEndowments.HomePage,n.SnapEndowments.LifecycleHooks,n.SnapEndowments.EthereumProvider,n.SnapEndowments.TransactionInsight,n.SnapEndowments.SignatureInsight]),s.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS={algorithm:"PBKDF2",params:{iterations:1e4}},s.STATE_DEBOUNCE_TIMEOUT=500,s.METAMASK_ORIGIN="metamask",s.CLIENT_ONLY_HANDLERS=Object.freeze([a.HandlerType.OnClientRequest,a.HandlerType.OnSignature,a.HandlerType.OnTransaction,a.HandlerType.OnCronjob,a.HandlerType.OnNameLookup,a.HandlerType.OnHomePage,a.HandlerType.OnSettingsPage,a.HandlerType.OnUserInput,a.HandlerType.OnAssetsLookup,a.HandlerType.OnAssetsConversion,a.HandlerType.OnAssetHistoricalPrice,a.HandlerType.OnAssetsMarketData,a.HandlerType.OnWebSocketEvent])}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs",{"./SnapController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./location/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs","./registry/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./constants.cjs"),s),a(e("./location/index.cjs"),s),a(e("./SnapController.cjs"),s),a(e("./selectors.cjs"),s),a(e("./registry/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.HttpLocation=void 0;const a=e("@metamask/snaps-utils"),r=e("@metamask/utils");s.HttpLocation=class{constructor(e,t={}){n(this,"cache",new Map),n(this,"validatedManifest",void 0),n(this,"url",void 0),n(this,"fetchFn",void 0),n(this,"fetchOptions",void 0),(0,r.assertStruct)(e.toString(),a.HttpSnapIdStruct,"Invalid Snap Id: "),this.fetchFn=t.fetch??globalThis.fetch.bind(undefined),this.fetchOptions=t.fetchOptions,this.url=e}async manifest(){if(this.validatedManifest)return this.validatedManifest.clone();const e=new URL(a.NpmSnapFileNames.Manifest,this.url).toString(),t=await this.fetchFn(e,this.fetchOptions);if(!t.ok)throw new Error(`Failed to fetch "${e}". Status code: ${t.status}.`);const s=await t.text(),n=(0,a.parseJson)(s),r=new a.VirtualFile({value:s,result:(0,a.createSnapManifest)(n),path:a.NpmSnapFileNames.Manifest,data:{canonicalPath:e}});return this.validatedManifest=r,this.manifest()}async fetch(e){const t=(0,a.normalizeRelative)(e),s=this.cache.get(t);if(s!==undefined)return s.clone();const n=this.toCanonical(t).toString(),i=await this.fetchFn(n,this.fetchOptions);if(!i.ok)throw new Error(`Failed to fetch "${n}". Status code: ${i.status}.`);const o=await i.arrayBuffer(),c=new a.VirtualFile({value:new Uint8Array(o),path:t,data:{canonicalPath:n}});return(0,r.assert)(!this.cache.has(t),"Corrupted cache, multiple files with same path."),this.cache.set(t,c),this.fetch(t)}get root(){return new URL(this.url)}toCanonical(e){return(0,r.assert)(!e.startsWith("/"),"Tried to parse absolute path."),new URL(e,this.url)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","./local.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs","./location.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs","./npm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./location.cjs"),s),a(e("./npm.cjs"),s),a(e("./local.cjs"),s),a(e("./http.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function a(e,t){return e.get(r(e,t))}function r(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.LocalLocation=void 0;const i=e("@metamask/snaps-utils"),o=e("@metamask/utils"),c=e("./http.cjs");var l=new WeakMap;function m(e){return(0,o.assert)(e.data.canonicalPath!==undefined),e.data.canonicalPath=`local:${e.data.canonicalPath}`,e}s.LocalLocation=class{constructor(e,t={}){var s,a,m;n(this,l,void 0),(0,o.assertStruct)(e.toString(),i.LocalSnapIdStruct,"Invalid Snap Id"),(0,o.assert)(t.fetchOptions===undefined,"Currently adding fetch options to local: is unsupported."),s=l,a=this,m=new c.HttpLocation(new URL(e.toString().slice(i.SnapIdPrefixes.local.length)),{...t,fetchOptions:{cache:"no-cache"}}),s.set(r(s,a),m)}async manifest(){return m(await a(l,this).manifest())}async fetch(e){return m(await a(l,this).fetch(e))}get shouldAlwaysReload(){return!0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","./local.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs","./npm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.detectSnapLocation=void 0;const n=e("@metamask/utils"),a=e("./http.cjs"),r=e("./local.cjs"),i=e("./npm.cjs");s.detectSnapLocation=function(e,t){const s=(null==t?void 0:t.allowHttp)??!1,o=(null==t?void 0:t.allowLocal)??!1,c=new URL(e);switch(c.protocol){case"npm:":return new i.NpmLocation(c,t);case"local:":return(0,n.assert)(o,new TypeError("Fetching local snaps is disabled.")),new r.LocalLocation(c,t);case"http:":case"https:":return(0,n.assert)(s,new TypeError("Fetching snaps through http/https is disabled.")),new a.HttpLocation(c,t);default:throw new TypeError(`Unrecognized "${c.protocol}" snap location protocol.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","concat-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js","get-npm-tarball-url":"/home/runner/work/metamask-extension/metamask-extension/node_modules/get-npm-tarball-url/lib/index.js","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js","readable-web-to-node-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/lib/index.js","tar-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t,s){return e.set(c(e,t),s),s}function o(e,t){return e.get(c(e,t))}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var l=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getNpmCanonicalBasePath=s.fetchNpmMetadata=s.NpmLocation=s.TARBALL_SIZE_SAFETY_LIMIT=s.BaseNpmLocation=s.DEFAULT_NPM_REGISTRY=void 0;const m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=l(e("concat-stream")),h=l(e("get-npm-tarball-url")),p=e("readable-stream"),f=e("readable-web-to-node-stream"),g=e("tar-stream");s.DEFAULT_NPM_REGISTRY=new URL("https://registry.npmjs.org");var b=new WeakMap,k=new WeakMap,y=new WeakSet;class w{constructor(e,t={}){var i,o;a(i=this,o=y),o.add(i),r(this,"meta",void 0),n(this,b,void 0),n(this,k,void 0);const c=t.allowCustomRegistries??!1,l=t.fetch??globalThis.fetch.bind(undefined),u=t.versionRange??m.DEFAULT_REQUESTED_SNAP_VERSION,h=t.resolveVersion??(async e=>e);let p;(0,d.assertStruct)(e.toString(),m.NpmSnapIdStruct,"Invalid Snap Id: "),""===e.host&&""===e.port&&""===e.username&&""===e.password?p=s.DEFAULT_NPM_REGISTRY:(p="https://",e.username&&(p+=e.username,e.password&&(p+=`:${e.password}`),p+="@"),p+=e.host,p=new URL(p),(0,d.assert)(c,new TypeError(`Custom NPM registries are disabled, tried to use "${p.toString()}".`))),(0,d.assert)("/"===p.pathname&&""===p.search&&""===p.hash),(0,d.assert)(""!==e.pathname&&"/"!==e.pathname,new TypeError("The package name in NPM location is empty."));let f=e.pathname;f.startsWith("/")&&(f=f.slice(1)),this.meta={requestedRange:u,registry:p,packageName:f,fetch:l,resolveVersion:h}}async manifest(){if(o(b,this))return o(b,this).clone();const e=await this.fetch("snap.manifest.json"),t=(0,m.parseJson)(e.toString());return e.result=(0,m.createSnapManifest)(t),i(b,this,e),this.manifest()}async fetch(e){const t=(0,m.normalizeRelative)(e);o(k,this)||(await c(y,this,x).call(this),(0,d.assert)(o(k,this)!==undefined));const s=o(k,this).get(t);return(0,d.assert)(s!==undefined,new TypeError(`File "${e}" not found in package.`)),s.clone()}get packageName(){return this.meta.packageName}get version(){return(0,d.assert)(this.meta.version!==undefined,"Tried to access version without first fetching NPM package."),this.meta.version}get registry(){return this.meta.registry}get versionRange(){return this.meta.requestedRange}}async function x(){(0,d.assert)(o(k,this)===undefined);const e=await this.meta.resolveVersion(this.meta.requestedRange),{tarballURL:t,targetVersion:s}=await async function(e,t,s,n){var a;if(_(s)&&(0,d.isValidSemVerVersion)(t))return{tarballURL:(0,h.default)(e,t),targetVersion:t};const r=await v(e,s,n),i=Object.keys((null==r?void 0:r.versions)??{}).map(e=>((0,d.assertIsSemVerVersion)(e),e)),o=(0,m.getTargetVersion)(i,t);if(null===o)throw new Error(`Failed to find a matching version in npm metadata for package "${e}" and requested semver range "${t}".`);const c=null==r||null===(a=r.versions)||void 0===a||null===(a=a[o])||void 0===a||null===(a=a.dist)||void 0===a?void 0:a.tarball;return{tarballURL:c,targetVersion:o}}(this.meta.packageName,e,this.meta.registry,this.meta.fetch);if(!(0,m.isValidUrl)(t)||!t.toString().endsWith(".tgz"))throw new Error(`Failed to find valid tarball URL in NPM metadata for package "${this.meta.packageName}".`);const n=new URL(t);n.hostname=this.meta.registry.hostname,n.protocol=this.meta.registry.protocol;const a=await this.fetchNpmTarball(n);i(k,this,a),this.meta.version=s}s.BaseNpmLocation=w,s.TARBALL_SIZE_SAFETY_LIMIT=262144e3;async function v(e,t,s){const n=await s(new URL(e,t).toString(),{headers:{accept:_(t)?"application/vnd.npm.install-v1+json; q=1.0, application/json; q=0.8, */*":"application/json"}});if(!n.ok)throw new Error(`Failed to fetch NPM registry entry. Status code: ${n.status}.`);const a=await n.json();if(!(0,d.isObject)(a))throw new Error(`Failed to fetch package "${e}" metadata from npm.`);return a}function S(e,t){let s="npm://";return""!==e.username&&(s+=e.username,""!==e.password&&(s+=`:${e.password}`),s+="@"),`${s}${e.host}/${t}/`}function _(e){return e.toString()===s.DEFAULT_NPM_REGISTRY.toString()}s.NpmLocation=class extends w{async fetchNpmTarball(e){const t=await this.meta.fetch(e.toString());(0,d.assert)(404!==t.status,`"${this.meta.packageName}" was not found in the NPM registry`),(0,d.assert)(t.ok&&t.body,`Failed to fetch tarball for package "${this.meta.packageName}"`);const n=t.headers.get("content-length");(0,d.assert)(n,"Snap tarball has invalid content-length");const a=parseInt(n,10);return(0,d.assert)(a<=s.TARBALL_SIZE_SAFETY_LIMIT,"Snap tarball exceeds size limit"),new Promise((e,n)=>{const a=new Map,r=function(e,t){(0,d.assert)(e.endsWith("/"),"Base needs to end with '/' for relative paths to be added as children instead of siblings."),(0,d.assert)(e.startsWith("npm:"),'Protocol mismatch, expected "npm:".');const n=(0,g.extract)();let a=0;return n.on("entry",(r,i,o)=>{const{name:c,type:l}=r;if("file"===l){const r=c.replace(P,"");return i.pipe((0,u.default)({encoding:"uint8array"},i=>{try{a+=i.byteLength,(0,d.assert)(a<s.TARBALL_SIZE_SAFETY_LIMIT,`Snap tarball exceeds limit of ${s.TARBALL_SIZE_SAFETY_LIMIT} bytes.`);const n=new m.VirtualFile({value:i,path:r,data:{canonicalPath:new URL(r,e).toString()}});return(0,d.assert)(!t.has(r),"Malformed tarball, multiple files with the same path."),t.set(r,n),o()}catch(e){return n.destroy(e)}}))}return i.on("end",()=>o()),i.resume()}),n}(S(this.meta.registry,this.meta.packageName),a),i=t.body,o=new DecompressionStream("gzip"),c=i.pipeThrough(o);(0,p.pipeline)(function(e){if("function"!=typeof e.getReader)return e;return new f.ReadableWebToNodeStream(e)}(c),r,t=>{t?n(t):e(a)})})}},s.fetchNpmMetadata=v,s.getNpmCanonicalBasePath=S;const P=/^package\//u}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs",{"./json.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs","./registry.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./registry.cjs"),s),a(e("./json.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs",{"./registry.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-registry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/index.js","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(o(e,t))}function i(e,t,s){return e.set(o(e,t),s),s}function o(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.JsonSnapsRegistry=void 0;const c=e("@metamask/base-controller"),l=e("@metamask/snaps-registry"),m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=e("./registry.cjs"),h={database:null,lastUpdated:null,databaseUnavailable:!1};var p=new WeakMap,f=new WeakMap,g=new WeakMap,b=new WeakMap,k=new WeakMap,y=new WeakMap,w=new WeakSet;class x extends c.BaseController{constructor({messenger:e,state:t,url:s={registry:"https://acl.execution.metamask.io/latest/registry.json",signature:"https://acl.execution.metamask.io/latest/signature.json"},publicKey:r="0x025b65308f0f0fb8bc7f7ff87bfc296e0330eee5d3c1d1ee4a048b2fd6a86fa0a6",fetchFunction:c=globalThis.fetch.bind(undefined),recentFetchThreshold:l=(0,d.inMilliseconds)(5,d.Duration.Minute),refetchOnAllowlistMiss:m=!0}){var u,x;super({messenger:e,metadata:{database:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0},lastUpdated:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1},databaseUnavailable:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1}},name:"SnapsRegistry",state:{...h,...t}}),a(u=this,x=w),x.add(u),n(this,p,void 0),n(this,f,void 0),n(this,g,void 0),n(this,b,void 0),n(this,k,void 0),n(this,y,void 0),i(p,this,s),i(f,this,r),i(g,this,c),i(b,this,l),i(k,this,m),i(y,this,null),this.messagingSystem.registerActionHandler("SnapsRegistry:get",async(...e)=>o(w,this,j).call(this,...e)),this.messagingSystem.registerActionHandler("SnapsRegistry:getMetadata",(...e)=>o(w,this,C).call(this,...e)),this.messagingSystem.registerActionHandler("SnapsRegistry:resolveVersion",async(...e)=>o(w,this,E).call(this,...e)),this.messagingSystem.registerActionHandler("SnapsRegistry:update",async()=>o(w,this,S).call(this))}}function v(){return this.state.lastUpdated&&Date.now()-this.state.lastUpdated<r(b,this)}async function S(){r(y,this)?await r(y,this):(null===r(y,this)&&i(y,this,o(w,this,_).call(this)),await r(y,this),i(y,this,null))}async function _(){if(!o(w,this,v).call(this))try{const[e,t]=await Promise.all([o(w,this,A).call(this,r(p,this).registry),o(w,this,A).call(this,r(p,this).signature)]);o(w,this,I).call(this,e,t),this.update(t=>{t.database=JSON.parse(e),t.lastUpdated=Date.now(),t.databaseUnavailable=!1})}catch{this.update(e=>{e.databaseUnavailable=!0})}}async function P(){return null===this.state.database&&await o(w,this,S).call(this),this.state.database}async function T(e,t,s=!1){var n;const a=await o(w,this,P).call(this),i=null==a?void 0:a.blockedSnaps.find(s=>"id"in s?s.id===e&&(0,d.satisfiesVersionRange)(t.version,s.versionRange):s.checksum===t.checksum);if(i)return{status:u.SnapsRegistryStatus.Blocked,reason:i.reason};const c=null==a?void 0:a.verifiedSnaps[e],l=null==c||null===(n=c.versions)||void 0===n?void 0:n[t.version];return l&&l.checksum===t.checksum?{status:u.SnapsRegistryStatus.Verified}:r(k,this)&&!s?(await o(w,this,S).call(this),o(w,this,T).call(this,e,t,!0)):{status:this.state.databaseUnavailable?u.SnapsRegistryStatus.Unavailable:u.SnapsRegistryStatus.Unverified}}async function j(e){return Object.entries(e).reduce(async(e,[t,s])=>{const n=await o(w,this,T).call(this,t,s),a=await e;return a[t]=n,a},Promise.resolve({}))}async function E(e,t,s=!1){var n;const a=await o(w,this,P).call(this),i=(null==a||null===(n=a.verifiedSnaps[e])||void 0===n?void 0:n.versions)??null;if(!i&&r(k,this)&&!s)return await o(w,this,S).call(this),o(w,this,E).call(this,e,t,!0);if(!i)return t;const c=(0,m.getTargetVersion)(Object.keys(i),t);return c||!r(k,this)||s?c?((0,d.assertIsSemVerRange)(c),c):t:(await o(w,this,S).call(this),o(w,this,E).call(this,e,t,!0))}function C(e){var t;return(null===(t=this.state)||void 0===t||null===(t=t.database)||void 0===t||null===(t=t.verifiedSnaps[e])||void 0===t?void 0:t.metadata)??null}function I(e,t){(0,d.assert)(r(f,this),"No public key provided.");const s=(0,l.verify)({registry:e,signature:JSON.parse(t),publicKey:r(f,this)});(0,d.assert)(s,"Invalid registry signature.")}async function A(e){const t=await r(g,this).call(this,e);if(!t.ok)throw new Error(`Failed to fetch ${e}.`);return await t.text()}s.JsonSnapsRegistry=x}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n;Object.defineProperty(s,"__esModule",{value:!0}),s.SnapsRegistryStatus=void 0,function(e){e[e.Unverified=0]="Unverified",e[e.Blocked=1]="Blocked",e[e.Verified=2]="Verified",e[e.Unavailable=3]="Unavailable"}(n||(s.SnapsRegistryStatus=n={}))}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getRunnableSnaps=void 0;s.getRunnableSnaps=e=>e.filter(e=>e.enabled&&!e.blocked)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs",{"./snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","fast-deep-equal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-deep-equal/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.isLocalSnapId=s.isTrackableHandler=s.throttleTracking=s.TRACKABLE_HANDLERS=s.debouncePersistState=s.fetchSnap=s.getSnapFiles=s.withTimeout=s.hasTimedOut=s.delayWithTimer=s.delay=s.permissionsDiff=s.setDiff=void 0;const a=e("@metamask/snaps-sdk"),r=e("@metamask/snaps-utils"),i=n(e("fast-deep-equal")),o=e("./snaps/Timer.cjs");function c(e,t){let s;const n=new Promise((n,a)=>{e.start(()=>{t===undefined?n():n(t)}),s=a});return n.cancel=()=>{"finished"!==e.status&&(e.cancel(),s(new Error("The delay has been canceled.")))},n}async function l(e,t){return t&&0!==t.length?await Promise.all(t.map(async t=>e.fetch(t))):[]}s.setDiff=function(e,t){return Object.entries(e).reduce((e,[s,n])=>(s in t||(e[s]=n),e),{})},s.permissionsDiff=function(e,t){return Object.entries(e).reduce((e,[s,n])=>{const a=s in t;return(!a||a&&!(0,i.default)(n.caveats??[],t[s].caveats??[]))&&(e[s]=n),e},{})},s.delay=function(e,t){return c(new o.Timer(e),t)},s.delayWithTimer=c,s.hasTimedOut=Symbol("Used to check if the requested promise has timeout (see withTimeout)"),s.withTimeout=async function(e,t){const n=c("number"==typeof t?new o.Timer(t):t,s.hasTimedOut);try{return await Promise.race([e,n])}finally{n.cancel()}},s.getSnapFiles=l,s.fetchSnap=async function(e,t){try{const e=await t.manifest(),s=await t.fetch(e.result.source.location.npm.filePath);(0,a.assert)(s.size<r.MAX_FILE_SIZE,"Snap source code must be smaller than 64 MB.");const{iconPath:n}=e.result.source.location.npm,i=n?await t.fetch(n):undefined,o=await l(t,e.result.source.files);(0,r.validateAuxiliaryFiles)(o),await Promise.all(o.map(async e=>{e.data.base64=await(0,r.encodeBase64)(e)}));const c=await l(t,e.result.source.locales),m={manifest:e,sourceCode:s,svgIcon:i,auxiliaryFiles:o,localizationFiles:(0,r.getValidatedLocalizationFiles)(c)};return await(0,r.validateFetchedSnap)(m),m}catch(t){throw new Error(`Failed to fetch snap "${e}": ${(0,a.getErrorMessage)(t)}.`)}},s.debouncePersistState=function(e,t=1e3){const s=new Map;return(n,a,r)=>{const i=`${n}-${r}`;s.has(i)&&clearTimeout(s.get(i)),s.set(i,setTimeout(()=>{e(n,a,r),s.delete(i)},t))}},s.TRACKABLE_HANDLERS=Object.freeze([r.HandlerType.OnHomePage,r.HandlerType.OnInstall,r.HandlerType.OnNameLookup,r.HandlerType.OnRpcRequest,r.HandlerType.OnSignature,r.HandlerType.OnTransaction,r.HandlerType.OnUpdate]),s.throttleTracking=function(e,t=6e4){const s=new Map,n=new Map;return(a,r,i,o)=>{const c=`${a}${r}${i}${o}`,l=Date.now(),m=s.get(c)??0,d=[a,r,i,o];if(l-m>=t)return s.set(c,l),void e(...d);const u=n.get(c);null!=u&&u.timer&&clearTimeout(u.timer),s.set(c,l),n.set(c,{args:d,timer:setTimeout(()=>{e(...d),n.delete(c)},t)})}},s.isTrackableHandler=function(e){return s.TRACKABLE_HANDLERS.includes(e)},s.isLocalSnapId=function(e){return e.startsWith("local:")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function i(e,t){return e.get(c(e,t))}function o(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.WebSocketService=void 0;const l=e("@metamask/rpc-errors"),m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=e("nanoid"),h=e("../snaps/index.cjs"),p="WebSocketService";var f=new WeakMap,g=new WeakMap,b=new WeakSet;function k(e,t){const s=i(g,this).get(t);return(0,d.assert)(s&&s.snapId===e,`Socket with ID "${t}" not found.`),s}function y(e,t,s){return c(b,this,P).call(this,e).some(e=>e.url===t&&(0,m.isEqual)(e.protocols,s))}function w(e,t){i(f,this).call("SnapController:handleRequest",{origin:h.METAMASK_ORIGIN,snapId:e,handler:m.HandlerType.OnWebSocketEvent,request:{method:"",params:{event:t}}}).catch(t=>{(0,m.logError)(`An error occurred while handling a WebSocket message for Snap "${e}":`,t)})}async function x(e,t,s=[]){(0,d.assert)(!c(b,this,y).call(this,e,t,s),`An open WebSocket connection to ${t} already exists.`);const n=new URL(t),{origin:a}=n,r=(0,u.nanoid)(),o=new WebSocket(t,s);o.binaryType="arraybuffer";const{promise:m,resolve:h,reject:p}=(0,d.createDeferredPromise)();o.addEventListener("open",()=>{h(),c(b,this,w).call(this,e,{type:"open",id:r,origin:a})}),o.addEventListener("close",t=>{i(g,this).delete(r),c(b,this,w).call(this,e,{type:"close",id:r,origin:a,code:t.code,reason:t.reason,wasClean:t.wasClean??null})});const f=()=>{p(l.rpcErrors.resourceUnavailable("An error occurred while opening the WebSocket."))};return o.addEventListener("error",f),o.addEventListener("message",t=>{const s="string"==typeof t.data?{type:"text",message:t.data}:{type:"binary",message:Array.from(new Uint8Array(t.data))};c(b,this,w).call(this,e,{type:"message",id:r,origin:a,data:s})}),i(g,this).set(r,{id:r,snapId:e,url:t,protocols:s,socket:o,openPromise:m}),await m,o.removeEventListener("error",f),r}function v(e,t){const{socket:s}=c(b,this,k).call(this,e,t);s.close()}function S(e){for(const t of c(b,this,P).call(this,e))c(b,this,v).call(this,e,t.id)}async function _(e,t,s){const{socket:n,openPromise:a}=c(b,this,k).call(this,e,t);await a;const r=Array.isArray(s)?new Uint8Array(s):s;n.send(r)}function P(e){return[...i(g,this).values()].filter(t=>t.snapId===e).map(e=>({id:e.id,url:e.url,protocols:e.protocols}))}s.WebSocketService=class{constructor({messenger:e}){var t,s;a(t=this,s=b),s.add(t),r(this,"name",p),r(this,"state",null),n(this,f,void 0),n(this,g,void 0),o(f,this,e),o(g,this,new Map),i(f,this).registerActionHandler(`${p}:open`,async(...e)=>c(b,this,x).call(this,...e)),i(f,this).registerActionHandler(`${p}:close`,(...e)=>c(b,this,v).call(this,...e)),i(f,this).registerActionHandler(`${p}:sendMessage`,async(...e)=>c(b,this,_).call(this,...e)),i(f,this).registerActionHandler(`${p}:getAll`,(...e)=>c(b,this,P).call(this,...e)),i(f,this).subscribe("SnapController:snapUpdated",e=>{c(b,this,S).call(this,e.id)}),i(f,this).subscribe("SnapController:snapUninstalled",e=>{c(b,this,S).call(this,e.id)}),i(f,this).subscribe("SnapController:snapInstalled",e=>{c(b,this,S).call(this,e.id)})}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs",{"./WebSocketService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./WebSocketService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","buffer-from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/buffer-from/index.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js",typedarray:"/home/runner/work/metamask-extension/metamask-extension/node_modules/typedarray/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var n=e("readable-stream").Writable,a=e("inherits"),r=e("buffer-from");if("undefined"==typeof Uint8Array)var i=e("typedarray").Uint8Array;else i=Uint8Array;function o(e,t){if(!(this instanceof o))return new o(e,t);"function"==typeof e&&(t=e,e={}),e||(e={});var s=e.encoding,a=!1;s?"u8"!==(s=String(s).toLowerCase())&&"uint8"!==s||(s="uint8array"):a=!0,n.call(this,{objectMode:!0}),this.encoding=s,this.shouldInferEncoding=a,t&&this.on("finish",function(){t(this.getBody())}),this.body=[]}t.exports=o,a(o,n),o.prototype._write=function(e,t,s){this.body.push(e),s()},o.prototype.inferEncoding=function(e){var t=e===undefined?this.body[0]:e;return s.isBuffer(t)?"buffer":"undefined"!=typeof Uint8Array&&t instanceof Uint8Array?"uint8array":Array.isArray(t)?"array":"string"==typeof t?"string":"[object Object]"===Object.prototype.toString.call(t)?"object":"buffer"},o.prototype.getBody=function(){return this.encoding||0!==this.body.length?(this.shouldInferEncoding&&(this.encoding=this.inferEncoding()),"array"===this.encoding?function(e){for(var t=[],s=0;s<e.length;s++)t.push.apply(t,e[s]);return t}(this.body):"string"===this.encoding?function(e){for(var t=[],n=0;n<e.length;n++){var a=e[n];"string"==typeof a||s.isBuffer(a)?t.push(a):c(a)?t.push(r(a)):t.push(r(String(a)))}t=s.isBuffer(e[0])?(t=s.concat(t)).toString("utf8"):t.join("");return t}(this.body):"buffer"===this.encoding?function(e){for(var t=[],n=0;n<e.length;n++){var a=e[n];s.isBuffer(a)?t.push(a):c(a)?t.push(r(a)):t.push(r(String(a)))}return s.concat(t)}(this.body):"uint8array"===this.encoding?function(e){for(var t=0,s=0;s<e.length;s++)"string"==typeof e[s]&&(e[s]=r(e[s])),t+=e[s].length;for(var n=new i(t),a=(s=0,0);s<e.length;s++)for(var o=e[s],c=0;c<o.length;c++)n[a++]=o[c];return n}(this.body):this.body):[]};Array.isArray;function c(e){return"string"==typeof e||(t=e,/Array\]$/.test(Object.prototype.toString.call(t)))||e&&"function"==typeof e.subarray;var t}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/snaps-controllers>concat-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js",{fs:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const n={S_IFMT:61440,S_IFDIR:16384,S_IFCHR:8192,S_IFBLK:24576,S_IFIFO:4096,S_IFLNK:40960};try{t.exports=e("fs").constants||n}catch{t.exports=n}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js",{"./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js","fast-fifo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-fifo/index.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const{Writable:n,Readable:a,getStreamError:r}=e("streamx"),i=e("fast-fifo"),o=e("b4a"),c=e("./headers"),l=o.alloc(0);class m{constructor(){this.buffered=0,this.shifted=0,this.queue=new i,this._offset=0}push(e){this.buffered+=e.byteLength,this.queue.push(e)}shiftFirst(e){return 0===this._buffered?null:this._next(e)}shift(e){if(e>this.buffered)return null;if(0===e)return l;let t=this._next(e);if(e===t.byteLength)return t;const s=[t];for(;(e-=t.byteLength)>0;)t=this._next(e),s.push(t);return o.concat(s)}_next(e){const t=this.queue.peek(),s=t.byteLength-this._offset;if(e>=s){const e=this._offset?t.subarray(this._offset,t.byteLength):t;return this.queue.shift(),this._offset=0,this.buffered-=s,this.shifted+=s,e}return this.buffered-=e,this.shifted+=e,t.subarray(this._offset,this._offset+=e)}}class d extends a{constructor(e,t,s){super(),this.header=t,this.offset=s,this._parent=e}_read(e){0===this.header.size&&this.push(null),this._parent._stream===this&&this._parent._update(),e(null)}_predestroy(){this._parent.destroy(r(this))}_detach(){this._parent._stream===this&&(this._parent._stream=null,this._parent._missing=p(this.header.size),this._parent._update())}_destroy(e){this._detach(),e(null)}}class u extends n{constructor(e){super(e),e||(e={}),this._buffer=new m,this._offset=0,this._header=null,this._stream=null,this._missing=0,this._longHeader=!1,this._callback=h,this._locked=!1,this._finished=!1,this._pax=null,this._paxGlobal=null,this._gnuLongPath=null,this._gnuLongLinkPath=null,this._filenameEncoding=e.filenameEncoding||"utf-8",this._allowUnknownFormat=!!e.allowUnknownFormat,this._unlockBound=this._unlock.bind(this)}_unlock(e){if(this._locked=!1,e)return this.destroy(e),void this._continueWrite(e);this._update()}_consumeHeader(){if(this._locked)return!1;this._offset=this._buffer.shifted;try{this._header=c.decode(this._buffer.shift(512),this._filenameEncoding,this._allowUnknownFormat)}catch(e){return this._continueWrite(e),!1}if(!this._header)return!0;switch(this._header.type){case"gnu-long-path":case"gnu-long-link-path":case"pax-global-header":case"pax-header":return this._longHeader=!0,this._missing=this._header.size,!0}return this._locked=!0,this._applyLongHeaders(),0===this._header.size||"directory"===this._header.type?(this.emit("entry",this._header,this._createStream(),this._unlockBound),!0):(this._stream=this._createStream(),this._missing=this._header.size,this.emit("entry",this._header,this._stream,this._unlockBound),!0)}_applyLongHeaders(){this._gnuLongPath&&(this._header.name=this._gnuLongPath,this._gnuLongPath=null),this._gnuLongLinkPath&&(this._header.linkname=this._gnuLongLinkPath,this._gnuLongLinkPath=null),this._pax&&(this._pax.path&&(this._header.name=this._pax.path),this._pax.linkpath&&(this._header.linkname=this._pax.linkpath),this._pax.size&&(this._header.size=parseInt(this._pax.size,10)),this._header.pax=this._pax,this._pax=null)}_decodeLongHeader(e){switch(this._header.type){case"gnu-long-path":this._gnuLongPath=c.decodeLongPath(e,this._filenameEncoding);break;case"gnu-long-link-path":this._gnuLongLinkPath=c.decodeLongPath(e,this._filenameEncoding);break;case"pax-global-header":this._paxGlobal=c.decodePax(e);break;case"pax-header":this._pax=null===this._paxGlobal?c.decodePax(e):Object.assign({},this._paxGlobal,c.decodePax(e))}}_consumeLongHeader(){this._longHeader=!1,this._missing=p(this._header.size);const e=this._buffer.shift(this._header.size);try{this._decodeLongHeader(e)}catch(e){return this._continueWrite(e),!1}return!0}_consumeStream(){const e=this._buffer.shiftFirst(this._missing);if(null===e)return!1;this._missing-=e.byteLength;const t=this._stream.push(e);return 0===this._missing?(this._stream.push(null),t&&this._stream._detach(),t&&!1===this._locked):t}_createStream(){return new d(this,this._header,this._offset)}_update(){for(;this._buffer.buffered>0&&!this.destroying;){if(this._missing>0){if(null!==this._stream){if(!1===this._consumeStream())return;continue}if(!0===this._longHeader){if(this._missing>this._buffer.buffered)break;if(!1===this._consumeLongHeader())return!1;continue}const e=this._buffer.shiftFirst(this._missing);null!==e&&(this._missing-=e.byteLength);continue}if(this._buffer.buffered<512)break;if(null!==this._stream||!1===this._consumeHeader())return}this._continueWrite(null)}_continueWrite(e){const t=this._callback;this._callback=h,t(e)}_write(e,t){this._callback=t,this._buffer.push(e),this._update()}_final(e){this._finished=0===this._missing&&0===this._buffer.buffered,e(this._finished?null:new Error("Unexpected end of data"))}_predestroy(){this._continueWrite(null)}_destroy(e){this._stream&&this._stream.destroy(r(this)),e(null)}[Symbol.asyncIterator](){let e=null,t=null,s=null,n=null,a=null;const r=this;return this.on("entry",function(e,r,i){a=i,r.on("error",h),t?(t({value:r,done:!1}),t=s=null):n=r}),this.on("error",t=>{e=t}),this.on("close",function(){if(i(e),!t)return;e?s(e):t({value:undefined,done:!0});t=s=null}),{[Symbol.asyncIterator](){return this},next:()=>new Promise(o),return:()=>c(null),throw:e=>c(e)};function i(e){if(!a)return;const t=a;a=null,t(e)}function o(a,o){return e?o(e):n?(a({value:n,done:!1}),void(n=null)):(t=a,s=o,i(null),void(r._finished&&t&&(t({value:undefined,done:!0}),t=s=null)))}function c(e){return r.destroy(e),i(e),new Promise((t,s)=>{if(r.destroyed)return t({value:undefined,done:!0});r.once("close",function(){e?s(e):t({value:undefined,done:!0})})})}}}function h(){}function p(e){return(e&=511)&&512-e}t.exports=function(e){return new u(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",{b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const n=e("b4a"),a="0".charCodeAt(0),r=n.from([117,115,116,97,114,0]),i=n.from([a,a]),o=n.from([117,115,116,97,114,32]),c=n.from([32,0]),l=257,m=263;function d(e,t,s,n){for(;s<n;s++)if(e[s]===t)return s;return n}function u(e){let t=256;for(let s=0;s<148;s++)t+=e[s];for(let s=156;s<512;s++)t+=e[s];return t}function h(e,t){return(e=e.toString(8)).length>t?"7777777777777777777".slice(0,t)+" ":"0000000000000000000".slice(0,t-e.length)+e+" "}function p(e,t,s){if(128&(e=e.subarray(t,t+s))[t=0])return function(e){let t;if(128===e[0])t=!0;else{if(255!==e[0])return null;t=!1}const s=[];let n;for(n=e.length-1;n>0;n--){const a=e[n];t?s.push(a):s.push(255-a)}let a=0;const r=s.length;for(n=0;n<r;n++)a+=s[n]*Math.pow(256,n);return t?a:-1*a}(e);{for(;t<e.length&&32===e[t];)t++;const s=(a=d(e,32,t,e.length),r=e.length,i=e.length,"number"!=typeof a?i:(a=~~a)>=r?r:a>=0||(a+=r)>=0?a:0);for(;t<s&&0===e[t];)t++;return s===t?0:parseInt(n.toString(e.subarray(t,s)),8)}var a,r,i}function f(e,t,s,a){return n.toString(e.subarray(t,d(e,0,t,t+s)),a)}function g(e){const t=n.byteLength(e);let s=Math.floor(Math.log(t)/Math.log(10))+1;return t+s>=Math.pow(10,s)&&s++,t+s+e}s.decodeLongPath=function(e,t){return f(e,0,e.length,t)},s.encodePax=function(e){let t="";e.name&&(t+=g(" path="+e.name+"\n")),e.linkname&&(t+=g(" linkpath="+e.linkname+"\n"));const s=e.pax;if(s)for(const e in s)t+=g(" "+e+"="+s[e]+"\n");return n.from(t)},s.decodePax=function(e){const t={};for(;e.length;){let s=0;for(;s<e.length&&32!==e[s];)s++;const a=parseInt(n.toString(e.subarray(0,s)),10);if(!a)return t;const r=n.toString(e.subarray(s+1,a-1)),i=r.indexOf("=");if(-1===i)return t;t[r.slice(0,i)]=r.slice(i+1),e=e.subarray(a)}return t},s.encode=function(e){const t=n.alloc(512);let s=e.name,o="";if(5===e.typeflag&&"/"!==s[s.length-1]&&(s+="/"),n.byteLength(s)!==s.length)return null;for(;n.byteLength(s)>100;){const e=s.indexOf("/");if(-1===e)return null;o+=o?"/"+s.slice(0,e):s.slice(0,e),s=s.slice(e+1)}return n.byteLength(s)>100||n.byteLength(o)>155||e.linkname&&n.byteLength(e.linkname)>100?null:(n.write(t,s),n.write(t,h(4095&e.mode,6),100),n.write(t,h(e.uid,6),108),n.write(t,h(e.gid,6),116),function(e,t,s){e.toString(8).length>11?function(e,t,s){t[s]=128;for(let n=11;n>0;n--)t[s+n]=255&e,e=Math.floor(e/256)}(e,t,s):n.write(t,h(e,11),s)}(e.size,t,124),n.write(t,h(e.mtime.getTime()/1e3|0,11),136),t[156]=a+function(e){switch(e){case"file":return 0;case"link":return 1;case"symlink":return 2;case"character-device":return 3;case"block-device":return 4;case"directory":return 5;case"fifo":return 6;case"contiguous-file":return 7;case"pax-header":return 72}return 0}(e.type),e.linkname&&n.write(t,e.linkname,157),n.copy(r,t,l),n.copy(i,t,263),e.uname&&n.write(t,e.uname,265),e.gname&&n.write(t,e.gname,297),n.write(t,h(e.devmajor||0,6),329),n.write(t,h(e.devminor||0,6),337),o&&n.write(t,o,345),n.write(t,h(u(t),6),148),t)},s.decode=function(e,t,s){let i=0===e[156]?0:e[156]-a,d=f(e,0,100,t);const h=p(e,100,8),g=p(e,108,8),b=p(e,116,8),k=p(e,124,12),y=p(e,136,12),w=function(e){switch(e){case 0:return"file";case 1:return"link";case 2:return"symlink";case 3:return"character-device";case 4:return"block-device";case 5:return"directory";case 6:return"fifo";case 7:return"contiguous-file";case 72:return"pax-header";case 55:return"pax-global-header";case 27:return"gnu-long-link-path";case 28:case 30:return"gnu-long-path"}return null}(i),x=0===e[157]?null:f(e,157,100,t),v=f(e,265,32),S=f(e,297,32),_=p(e,329,8),P=p(e,337,8),T=u(e);if(256===T)return null;if(T!==p(e,148,8))throw new Error("Invalid tar header. Maybe the tar is corrupted or it needs to be gunzipped?");if(function(e){return n.equals(r,e.subarray(l,263))}(e))e[345]&&(d=f(e,345,155,t)+"/"+d);else if(function(e){return n.equals(o,e.subarray(l,263))&&n.equals(c,e.subarray(m,265))}(e));else if(!s)throw new Error("Invalid tar header: unknown format.");return 0===i&&d&&"/"===d[d.length-1]&&(i=5),{name:d,mode:h,uid:g,gid:b,size:k,mtime:new Date(1e3*y),type:w,linkname:x,uname:v,gname:S,devmajor:_,devminor:P,pax:null}}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js",{"./extract":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js","./pack":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){s.extract=e("./extract"),s.pack=e("./pack")}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js","./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const{Readable:n,Writable:a,getStreamError:r}=e("streamx"),i=e("b4a"),o=e("./constants"),c=e("./headers"),l=i.alloc(1024);class m extends a{constructor(e,t,s){super({mapWritable:p,eagerOpen:!0}),this.written=0,this.header=t,this._callback=s,this._linkname=null,this._isLinkname="symlink"===t.type&&!t.linkname,this._isVoid="file"!==t.type&&"contiguous-file"!==t.type,this._finished=!1,this._pack=e,this._openCallback=null,null===this._pack._stream?this._pack._stream=this:this._pack._pending.push(this)}_open(e){this._openCallback=e,this._pack._stream===this&&this._continueOpen()}_continuePack(e){if(null===this._callback)return;const t=this._callback;this._callback=null,t(e)}_continueOpen(){null===this._pack._stream&&(this._pack._stream=this);const e=this._openCallback;if(this._openCallback=null,null!==e){if(this._pack.destroying)return e(new Error("pack stream destroyed"));if(this._pack._finalized)return e(new Error("pack stream is already finalized"));this._pack._stream=this,this._isLinkname||this._pack._encode(this.header),this._isVoid&&(this._finish(),this._continuePack(null)),e(null)}}_write(e,t){return this._isLinkname?(this._linkname=this._linkname?i.concat([this._linkname,e]):e,t(null)):this._isVoid?e.byteLength>0?t(new Error("No body allowed for this entry")):t():(this.written+=e.byteLength,this._pack.push(e)?t():void(this._pack._drain=t))}_finish(){this._finished||(this._finished=!0,this._isLinkname&&(this.header.linkname=this._linkname?i.toString(this._linkname,"utf-8"):"",this._pack._encode(this.header)),h(this._pack,this.header.size),this._pack._done(this))}_final(e){if(this.written!==this.header.size)return e(new Error("Size mismatch"));this._finish(),e(null)}_getError(){return r(this)||new Error("tar entry destroyed")}_predestroy(){this._pack.destroy(this._getError())}_destroy(e){this._pack._done(this),this._continuePack(this._finished?null:this._getError()),e()}}class d extends n{constructor(e){super(e),this._drain=u,this._finalized=!1,this._finalizing=!1,this._pending=[],this._stream=null}entry(e,t,s){if(this._finalized||this.destroying)throw new Error("already finalized or destroyed");"function"==typeof t&&(s=t,t=null),s||(s=u),e.size&&"symlink"!==e.type||(e.size=0),e.type||(e.type=function(e){switch(e&o.S_IFMT){case o.S_IFBLK:return"block-device";case o.S_IFCHR:return"character-device";case o.S_IFDIR:return"directory";case o.S_IFIFO:return"fifo";case o.S_IFLNK:return"symlink"}return"file"}(e.mode)),e.mode||(e.mode="directory"===e.type?493:420),e.uid||(e.uid=0),e.gid||(e.gid=0),e.mtime||(e.mtime=new Date),"string"==typeof t&&(t=i.from(t));const n=new m(this,e,s);return i.isBuffer(t)?(e.size=t.byteLength,n.write(t),n.end(),n):(n._isVoid,n)}finalize(){this._stream||this._pending.length>0?this._finalizing=!0:this._finalized||(this._finalized=!0,this.push(l),this.push(null))}_done(e){e===this._stream&&(this._stream=null,this._finalizing&&this.finalize(),this._pending.length&&this._pending.shift()._continueOpen())}_encode(e){if(!e.pax){const t=c.encode(e);if(t)return void this.push(t)}this._encodePax(e)}_encodePax(e){const t=c.encodePax({name:e.name,linkname:e.linkname,pax:e.pax}),s={name:"PaxHeader",mode:e.mode,uid:e.uid,gid:e.gid,size:t.byteLength,mtime:e.mtime,type:"pax-header",linkname:e.linkname&&"PaxHeader",uname:e.uname,gname:e.gname,devmajor:e.devmajor,devminor:e.devminor};this.push(c.encode(s)),this.push(t),h(this,t.byteLength),s.size=e.size,s.type=e.type,this.push(c.encode(s))}_doDrain(){const e=this._drain;this._drain=u,e()}_predestroy(){const e=r(this);for(this._stream&&this._stream.destroy(e);this._pending.length;){const t=this._pending.shift();t.destroy(e),t._continueOpen()}this._doDrain()}_read(e){this._doDrain(),e()}}function u(){}function h(e,t){(t&=511)&&e.push(l.subarray(0,512-t))}function p(e){return i.isBuffer(e)?e:i.from(e)}t.exports=function(e){return new d(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/index.js",{"./verify":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/verify.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.SnapsRegistryDatabaseStruct=s.BlockedSnapStruct=s.BlockReasonStruct=s.VerifiedSnapStruct=s.ImagePathStruct=s.AdditionalSourceCodeStruct=s.SupportStruct=s.AuditStruct=s.AuthorStruct=void 0;const r=e("@metamask/superstruct"),i=e("@metamask/utils"),o=(0,r.refine)((0,r.string)(),"Npm ID",e=>e.startsWith("npm:")),c=(0,r.object)({checksum:i.ChecksumStruct});s.AuthorStruct=(0,r.object)({name:(0,r.string)(),website:(0,r.string)()}),s.AuditStruct=(0,r.object)({auditor:(0,r.string)(),report:(0,r.string)()}),s.SupportStruct=(0,r.object)({knowledgeBase:(0,r.optional)((0,r.string)()),faq:(0,r.optional)((0,r.string)()),contact:(0,r.optional)((0,r.string)()),keyRecovery:(0,r.optional)((0,r.string)())}),s.AdditionalSourceCodeStruct=(0,r.object)({name:(0,r.string)(),url:(0,r.string)()}),s.ImagePathStruct=(0,r.pattern)((0,r.string)(),/\.\/images\/.*\/\d+\.(?:png|jpe?g)$/u),s.VerifiedSnapStruct=(0,r.object)({id:o,metadata:(0,r.object)({name:(0,r.string)(),type:(0,r.optional)((0,r.enums)(["account"])),author:(0,r.optional)(s.AuthorStruct),website:(0,r.optional)((0,r.string)()),onboard:(0,r.optional)((0,r.boolean)()),summary:(0,r.optional)((0,r.string)()),description:(0,r.optional)((0,r.string)()),audits:(0,r.optional)((0,r.array)(s.AuditStruct)),category:(0,r.optional)((0,r.enums)(["interoperability","notifications","transaction insights","account management","name resolution"])),tags:(0,r.optional)((0,r.array)((0,r.string)())),support:(0,r.optional)(s.SupportStruct),sourceCode:(0,r.optional)((0,r.string)()),hidden:(0,r.optional)((0,r.boolean)()),privateCode:(0,r.optional)((0,r.boolean)()),privacyPolicy:(0,r.optional)((0,r.string)()),termsOfUse:(0,r.optional)((0,r.string)()),additionalSourceCode:(0,r.optional)((0,r.array)(s.AdditionalSourceCodeStruct)),screenshots:(0,r.optional)((0,r.size)((0,r.array)(s.ImagePathStruct),3,3))}),versions:(0,r.record)(i.VersionStruct,c)}),s.BlockReasonStruct=(0,r.object)({explanation:(0,r.optional)((0,r.string)()),url:(0,r.optional)((0,r.string)())}),s.BlockedSnapStruct=(0,r.union)([(0,r.object)({id:o,versionRange:i.VersionRangeStruct,reason:(0,r.optional)(s.BlockReasonStruct)}),(0,r.object)({checksum:i.ChecksumStruct,reason:(0,r.optional)(s.BlockReasonStruct)})]),s.SnapsRegistryDatabaseStruct=(0,r.object)({verifiedSnaps:(0,r.record)(o,s.VerifiedSnapStruct),blockedSnaps:(0,r.array)(s.BlockedSnapStruct)}),a(e("./verify"),s)}}},{package:"@metamask/snaps-utils>@metamask/snaps-registry",file:"node_modules/@metamask/snaps-registry/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/verify.js",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/secp256k1.js","@noble/hashes/sha256":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha256.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.verify=s.SignatureStruct=void 0;const n=e("@metamask/superstruct"),a=e("@metamask/utils"),r=e("@noble/curves/secp256k1"),i=e("@noble/hashes/sha256");s.SignatureStruct=(0,n.object)({signature:a.StrictHexStruct,curve:(0,n.literal)("secp256k1"),format:(0,n.literal)("DER")}),s.verify=function({registry:e,signature:t,publicKey:n}){(0,a.assertStruct)(t,s.SignatureStruct,"Invalid signature object");const o=(0,a.hexToBytes)(n);return r.secp256k1.verify((0,a.remove0x)(t.signature),(0,i.sha256)((0,a.stringToBytes)(e)),o)}}}},{package:"@metamask/snaps-utils>@metamask/snaps-registry",file:"node_modules/@metamask/snaps-registry/dist/verify.js"}]],[],{});