LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js",{"./build/multichain-openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json","./build/openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.MultiChainOpenRPCDocument=a.MetaMaskOpenRPCDocument=void 0;const s=f(e("./build/openrpc.json"));a.MetaMaskOpenRPCDocument=s.default;const n=f(e("./build/multichain-openrpc.json"));a.MultiChainOpenRPCDocument=n.default,a.default=s.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/constants.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.NetworkEnablementController=void 0;const c=e("@metamask/base-controller"),d=e("@metamask/controller-utils"),l=e("@metamask/keyring-api"),b=e("@metamask/utils"),m=e("./constants.cjs"),u=e("./utils.cjs"),p={enabledNetworkMap:{includeInStateLogs:!0,persist:!0,anonymous:!0,usedInUi:!0}};class h extends c.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:p,name:"NetworkEnablementController",state:{enabledNetworkMap:{[b.KnownCaipNamespace.Eip155]:{[d.ChainId[d.BuiltInNetworkName.Mainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.LineaMainnet]]:!0,[d.ChainId[d.BuiltInNetworkName.BaseMainnet]]:!0},[b.KnownCaipNamespace.Solana]:{[l.SolScope.Mainnet]:!0,[l.SolScope.Testnet]:!1,[l.SolScope.Devnet]:!1},[b.KnownCaipNamespace.Bip122]:{[l.BtcScope.Mainnet]:!0,[l.BtcScope.Testnet]:!1,[l.BtcScope.Signet]:!1},[b.KnownCaipNamespace.Tron]:{[l.TrxScope.Mainnet]:!0,[l.TrxScope.Nile]:!1,[l.TrxScope.Shasta]:!1}},...t}}),f.add(this),e.subscribe("NetworkController:networkAdded",({chainId:e})=>{o(this,f,"m",r).call(this,e)}),e.subscribe("NetworkController:networkRemoved",({chainId:e})=>{o(this,f,"m",i).call(this,e)})}enableNetwork(e){const{namespace:t,storageKey:a}=(0,u.deriveKeys)(e);this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})}),e.enabledNetworkMap[t]&&(e.enabledNetworkMap[t][a]=!0)})}enableNetworkInNamespace(e,t){const{namespace:a,storageKey:n}=(0,u.deriveKeys)(e);if(a!==t)throw new Error(`Chain ID ${e} belongs to namespace ${a}, but namespace ${t} was specified`);this.update(e=>{o(this,f,"m",s).call(this,e,t),e.enabledNetworkMap[t]&&Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1}),e.enabledNetworkMap[t][n]=!0})}enableAllPopularNetworks(){this.update(e=>{Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})});const t=this.messagingSystem.call("NetworkController:getState"),a=this.messagingSystem.call("MultichainNetworkController:getState");m.POPULAR_NETWORKS.forEach(a=>{const{namespace:n,storageKey:i}=(0,u.deriveKeys)(a);t.networkConfigurationsByChainId[a]&&(o(this,f,"m",s).call(this,e,n),e.enabledNetworkMap[n][i]=!0)});const n=(0,u.deriveKeys)(l.SolScope.Mainnet);a.multichainNetworkConfigurationsByChainId[l.SolScope.Mainnet]&&(o(this,f,"m",s).call(this,e,n.namespace),e.enabledNetworkMap[n.namespace][n.storageKey]=!0);const i=(0,u.deriveKeys)(l.BtcScope.Mainnet);a.multichainNetworkConfigurationsByChainId[l.BtcScope.Mainnet]&&(o(this,f,"m",s).call(this,e,i.namespace),e.enabledNetworkMap[i.namespace][i.storageKey]=!0);const r=(0,u.deriveKeys)(l.TrxScope.Mainnet);a.multichainNetworkConfigurationsByChainId[l.TrxScope.Mainnet]&&(o(this,f,"m",s).call(this,e,r.namespace),e.enabledNetworkMap[r.namespace][r.storageKey]=!0)})}init(){this.update(e=>{const t=this.messagingSystem.call("NetworkController:getState"),a=this.messagingSystem.call("MultichainNetworkController:getState");Object.keys(t.networkConfigurationsByChainId).forEach(t=>{const{namespace:a,storageKey:n}=(0,u.deriveKeys)(t);o(this,f,"m",s).call(this,e,a),e.enabledNetworkMap[a][n]===undefined&&(e.enabledNetworkMap[a][n]=!1)}),Object.keys(a.multichainNetworkConfigurationsByChainId).forEach(t=>{const{namespace:a,storageKey:n}=(0,u.deriveKeys)(t);o(this,f,"m",s).call(this,e,a),e.enabledNetworkMap[a][n]===undefined&&(e.enabledNetworkMap[a][n]=!1)})})}disableNetwork(e){const t=(0,u.deriveKeys)(e),{namespace:a,storageKey:f}=t;this.update(e=>{e.enabledNetworkMap[a][f]=!1})}isNetworkEnabled(e){const t=(0,u.deriveKeys)(e),{namespace:a,storageKey:f}=t;return this.state.enabledNetworkMap[a]?.[f]??!1}}a.NetworkEnablementController=h,f=new WeakSet,s=function(e,t){e.enabledNetworkMap[t]||(e.enabledNetworkMap[t]={})},n=function(){const e=this.messagingSystem.call("NetworkController:getState");return m.POPULAR_NETWORKS.reduce((t,a)=>{if(!e.networkConfigurationsByChainId[a])return t;const{namespace:f,storageKey:s}=(0,u.deriveKeys)(a),n=this.state.enabledNetworkMap[f]?.[s];return n?t+1:t},0)>1},i=function(e){const t=(0,u.deriveKeys)(e),{namespace:a,storageKey:f}=t;this.update(e=>{(0,u.isOnlyNetworkEnabledInNamespace)(this.state,t)&&(e.enabledNetworkMap[a][d.ChainId[d.BuiltInNetworkName.Mainnet]]=!0),a in e.enabledNetworkMap&&delete e.enabledNetworkMap[a][f]})},r=function(e){const{namespace:t,storageKey:a,reference:i}=(0,u.deriveKeys)(e);this.update(e=>{o(this,f,"m",s).call(this,e,t);const r=o(this,f,"m",n).call(this),c=(0,u.isPopularNetwork)(i);r&&c||Object.keys(e.enabledNetworkMap).forEach(t=>{Object.keys(e.enabledNetworkMap[t]).forEach(a=>{e.enabledNetworkMap[t][a]=!1})}),e.enabledNetworkMap[t][a]=!0})}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.POPULAR_NETWORKS=void 0,a.POPULAR_NETWORKS=["0x1","0xe708","0x2105","0xa4b1","0xa86a","0x38","0xa","0x89","0x531","0x144","0x2a15c308d","0x3e7"]}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/index.cjs",{"./NetworkEnablementController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/NetworkEnablementController.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.selectEnabledSolanaNetworks=a.selectEnabledEvmNetworks=a.selectEnabledNetworksCount=a.selectAllEnabledNetworks=a.createSelectorForEnabledNetworksForNamespace=a.selectIsNetworkEnabled=a.selectEnabledNetworkMap=a.NetworkEnablementController=void 0;var f=e("./NetworkEnablementController.cjs");Object.defineProperty(a,"NetworkEnablementController",{enumerable:!0,get:function(){return f.NetworkEnablementController}});var s=e("./selectors.cjs");Object.defineProperty(a,"selectEnabledNetworkMap",{enumerable:!0,get:function(){return s.selectEnabledNetworkMap}}),Object.defineProperty(a,"selectIsNetworkEnabled",{enumerable:!0,get:function(){return s.selectIsNetworkEnabled}}),Object.defineProperty(a,"createSelectorForEnabledNetworksForNamespace",{enumerable:!0,get:function(){return s.createSelectorForEnabledNetworksForNamespace}}),Object.defineProperty(a,"selectAllEnabledNetworks",{enumerable:!0,get:function(){return s.selectAllEnabledNetworks}}),Object.defineProperty(a,"selectEnabledNetworksCount",{enumerable:!0,get:function(){return s.selectEnabledNetworksCount}}),Object.defineProperty(a,"selectEnabledEvmNetworks",{enumerable:!0,get:function(){return s.selectEnabledEvmNetworks}}),Object.defineProperty(a,"selectEnabledSolanaNetworks",{enumerable:!0,get:function(){return s.selectEnabledSolanaNetworks}})}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/selectors.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",reselect:"/home/runner/work/metamask-extension/metamask-extension/node_modules/reselect/dist/cjs/reselect.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.selectEnabledSolanaNetworks=a.selectEnabledEvmNetworks=a.selectEnabledNetworksCount=a.selectAllEnabledNetworks=a.createSelectorForEnabledNetworksForNamespace=a.selectIsNetworkEnabled=a.selectEnabledNetworkMap=void 0;const f=e("@metamask/utils"),s=e("reselect"),n=e("./utils.cjs");a.selectEnabledNetworkMap=e=>e.enabledNetworkMap;a.selectIsNetworkEnabled=e=>(0,s.createSelector)(a.selectEnabledNetworkMap,t=>{const{namespace:a,storageKey:f}=(0,n.deriveKeys)(e);return a in t&&f in t[a]&&t[a][f]});a.createSelectorForEnabledNetworksForNamespace=e=>(0,s.createSelector)(a.selectEnabledNetworkMap,t=>Object.entries(t[e]??{}).filter(([,e])=>e).map(([e])=>e)),a.selectAllEnabledNetworks=(0,s.createSelector)(a.selectEnabledNetworkMap,e=>Object.keys(e).reduce((t,a)=>(t[a]=Object.entries(e[a]).filter(([,e])=>e).map(([e])=>e),t),{})),a.selectEnabledNetworksCount=(0,s.createSelector)(a.selectAllEnabledNetworks,e=>Object.values(e).flat().length),a.selectEnabledEvmNetworks=(0,s.createSelector)((0,a.createSelectorForEnabledNetworksForNamespace)(f.KnownCaipNamespace.Eip155),e=>e),a.selectEnabledSolanaNetworks=(0,s.createSelector)((0,a.createSelectorForEnabledNetworksForNamespace)(f.KnownCaipNamespace.Solana),e=>e)}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/selectors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/utils.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/network-enablement-controller/dist/constants.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/multichain-network-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-network-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isPopularNetwork=a.isOnlyNetworkEnabledInNamespace=a.deriveKeys=void 0;const f=e("@metamask/controller-utils"),s=e("@metamask/multichain-network-controller"),n=e("@metamask/utils"),i=e("./constants.cjs");a.deriveKeys=function(e){const t=(0,n.isCaipChainId)(e)?e:(0,s.toEvmCaipChainId)(e),{namespace:a,reference:i}=(0,n.parseCaipChainId)(t);let r;return r=a===n.KnownCaipNamespace.Eip155?(0,n.isHexString)(e)?e:(0,f.toHex)(i):t,{namespace:a,storageKey:r,caipChainId:t,reference:i}},a.isOnlyNetworkEnabledInNamespace=function(e,t){const{namespace:a,storageKey:f}=t;if(!e.enabledNetworkMap[a])return!1;const s=e.enabledNetworkMap[a],n=Object.entries(s).filter(([e,t])=>t);if(1===n.length){const[e]=n[0];return e===f}return!1},a.isPopularNetwork=function(e){try{return i.POPULAR_NETWORKS.includes((0,f.toHex)(e))}catch{return!1}}}}},{package:"@metamask/network-enablement-controller",file:"node_modules/@metamask/network-enablement-controller/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs",{"./push-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=void 0;var f=e("./push-utils.cjs");Object.defineProperty(a,"createRegToken",{enumerable:!0,get:function(){return f.createRegToken}}),Object.defineProperty(a,"deleteRegToken",{enumerable:!0,get:function(){return f.deleteRegToken}}),Object.defineProperty(a,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return f.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs",{"../../NotificationServicesController/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesController/index.cjs","../../shared/to-raw-notification.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/shared/to-raw-notification.cjs","firebase/app":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/app/dist/esm/index.esm.js","firebase/messaging":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/messaging/dist/esm/index.esm.js","firebase/messaging/sw":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/messaging/sw/dist/esm/index.esm.js",loglevel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/loglevel/lib/loglevel.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=a.supportedCache=void 0;const s=e("firebase/app"),n=e("firebase/messaging"),i=e("firebase/messaging/sw"),r=f(e("loglevel")),o=e("../../NotificationServicesController/index.cjs"),c=e("../../shared/to-raw-notification.cjs");a.supportedCache=null;const d=async e=>{if(!await(async()=>(a.supportedCache??(a.supportedCache=await(0,i.isSupported)()),a.supportedCache))())return null;const t=await(async e=>{try{return(0,s.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,s.initializeApp)(t)}})(e);return(0,i.getMessaging)(t)};a.createRegToken=async function(e){try{const t=await d(e);if(!t)return null;return await(0,n.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},a.deleteRegToken=async function(e){try{const t=await d(e);return!t||(await(0,n.deleteToken)(t),!0)}catch{return!1}},a.createSubscribeToPushNotifications=function(e){return async function(t){const a=await async function(e,t){const a=await d(e);if(!a)return null;const f=(0,i.onBackgroundMessage)(a,async e=>{try{const a=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!a)return;const f=(0,c.toRawOnChainNotification)(a),s=o.Processors.processNotification(f);await t(s)}catch(t){throw r.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}});return()=>f()}(t,async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)}),f=function(e){const t=t=>{const a=t?.notification?.data;e(t,a)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}((t,a)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",a),e.onClickHandler(t,a)});return()=>{a?.(),f()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ComposedStore.js",{"./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ComposedStore=void 0;const f=e("./ObservableStore");class s extends f.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach(e=>{const t=this._children[e];this._addChild(e,t)})}_addChild(e,t){const a=t=>{const a=this.getState();a[e]=t,this.putState(a)};t.subscribe(a),a(t.getState())}}a.ComposedStore=s}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/MergedStore.js",{"./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.MergedStore=void 0;const f=e("./ObservableStore");class s extends f.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach(e=>this._addChild(e)),this._updateWholeState()}_addChild(e){e.subscribe(()=>this._updateWholeState())}_updateWholeState(){const e=this._children.map(e=>e.getState()),t=Object.assign({},...e);this.putState(t)}}a.MergedStore=s}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js",{"@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.ObservableStore=void 0;const s=f(e("@metamask/safe-event-emitter"));class n extends s.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}a.ObservableStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/asStream.js",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeAsStream=void 0;const f=e("readable-stream");class s extends f.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const a=super.pipe(e,t);return e.write(this.obsStore.getState()),a}_write(e,t,a){this.obsStore.putState(e),a()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}a.storeAsStream=function(e){return new s(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/index.js",{"./ComposedStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ComposedStore.js","./MergedStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/MergedStore.js","./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js","./asStream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/asStream.js","./transform":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/transform.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__createBinding||(Object.create?function(e,t,a,f){f===undefined&&(f=a),Object.defineProperty(e,f,{enumerable:!0,get:function(){return t[a]}})}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]}),s=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./asStream"),a),s(e("./ComposedStore"),a),s(e("./MergedStore"),a),s(e("./ObservableStore"),a),s(e("./transform"),a)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/transform.js",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeTransformStream=void 0;const f=e("readable-stream");a.storeTransformStream=function(e){return new f.Transform({objectMode:!0,transform:(t,a,f)=>{try{const a=e(t);return f(undefined,a),undefined}catch(e){return f(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs",{"./enums.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/enums.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c,d,l,b=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},m=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PermissionLogController=void 0;const u=e("@metamask/base-controller"),p=e("@metamask/utils"),h=e("./enums.cjs"),g={permissionHistory:{},permissionActivityLog:[]};class k extends u.BaseController{constructor({messenger:e,restrictedMethods:t,state:a}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{persist:!0,anonymous:!1},permissionActivityLog:{persist:!1,anonymous:!1}},state:{...g,...a}}),f.add(this),s.set(this,void 0),b(this,s,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const a={eth_accounts:{accounts:m(this,f,"m",n).call(this,t,Date.now())}};m(this,f,"m",c).call(this,e,a)}createMiddleware(){return(e,t,a)=>{const{origin:n,method:c}=e,l=c.startsWith(h.WALLET_PREFIX),b="eth_requestAccounts"===c;if(!h.LOG_IGNORE_METHODS.includes(c)&&(l||m(this,s,"f").has(c))||b){const s=m(this,f,"m",i).call(this,e,l),c=m(this,f,"m",d).call(this,e);return void a(e=>{const a=Date.now();m(this,f,"m",r).call(this,s,t,a),c&&!t.error&&t.result&&n&&m(this,f,"m",o).call(this,c,n,t.result,a,b),e()})}a()}}}a.PermissionLogController=k,s=new WeakMap,f=new WeakSet,n=function(e,t){return e.reduce((e,a)=>({...e,[a]:t}),{})},i=function(e,t){const a={id:e.id,method:e.method,methodType:t?h.LOG_METHOD_TYPES.internal:h.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update(e=>{const t=[...e.permissionActivityLog,a];e.permissionActivityLog=t.length>h.LOG_LIMIT?t.slice(1):t}),a},r=function(e,t,a){e&&t&&this.update(f=>{f.permissionActivityLog=f.permissionActivityLog.map(f=>f.id===e.id?{...f,success:(0,p.hasProperty)(t,"result"),responseTime:a}:f)})},o=function(e,t,a,s,i){let r;if(i){const e=a;r={eth_accounts:{accounts:m(this,f,"m",n).call(this,e,s),lastApproved:s}}}else{r=a.reduce((t,a)=>{const i=a.parentCapability;if(!e.includes(i))return t;if("eth_accounts"===i){const e=m(this,f,"m",l).call(this,a);return{...t,[i]:{lastApproved:s,accounts:m(this,f,"m",n).call(this,e,s)}}}return{...t,[i]:{lastApproved:s}}},{})}Object.keys(r).length>0&&m(this,f,"m",c).call(this,t,r)},c=function(e,t){const{permissionHistory:a}=this.state,f=a[e]??{},s={...f,...t},n=f.eth_accounts,i=t.eth_accounts;if(n&&i){const e=i.lastApproved??n.lastApproved;s.eth_accounts={lastApproved:e,accounts:{...n.accounts,...i.accounts}}}this.update(t=>{t.permissionHistory={...a,[e]:s}})},d=function(e){const{method:t,params:a}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${h.WALLET_PREFIX}requestPermissions`&&a&&Array.isArray(a)&&a[0]&&"object"==typeof a[0]&&!Array.isArray(a[0])?Object.keys(a[0]):null},l=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const a of e.caveats)if(a.type===h.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(a.value))for(const e of a.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/enums.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f;Object.defineProperty(a,"__esModule",{value:!0}),a.LOG_LIMIT=a.LOG_METHOD_TYPES=a.LOG_IGNORE_METHODS=a.CAVEAT_TYPES=a.WALLET_PREFIX=void 0,a.WALLET_PREFIX="wallet_",a.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),a.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(f||(a.LOG_METHOD_TYPES=f={})),a.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/index.cjs",{"./PermissionLogController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__createBinding||(Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]}),s=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./PermissionLogController.cjs"),a)}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.BasePostMessageStream=void 0;const f=e("readable-stream"),s=()=>undefined,n="SYN",i="ACK";class r extends f.Duplex{constructor(e){super(Object.assign({objectMode:!0},e)),this._init=!1,this._haveSyn=!1,this._log=()=>null}_handshake(){this._write(n,null,s),this.cork()}_onData(e){if(this._init)try{this.push(e),this._log(e,!1)}catch(e){this.emit("error",e)}else e===n?(this._haveSyn=!0,this._write(i,null,s)):e===i&&(this._init=!0,this._haveSyn||this._write(i,null,s),this.uncork())}_read(){return undefined}_write(e,t,a){e!==i&&e!==n&&this._log(e,!0),this._postMessage(e),a()}_setLogger(e){this._log=e}}a.BasePostMessageStream=r}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs",{"./BasePostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs","./runtime/BrowserRuntimePostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/runtime/BrowserRuntimePostMessageStream.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/utils.cjs","./web-worker/WebWorkerParentPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerParentPostMessageStream.cjs","./web-worker/WebWorkerPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerPostMessageStream.cjs","./window/WindowPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/window/WindowPostMessageStream.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__createBinding||(Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]}),s=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),a.isValidStreamMessage=void 0,s(e("./window/WindowPostMessageStream.cjs"),a),s(e("./web-worker/WebWorkerPostMessageStream.cjs"),a),s(e("./web-worker/WebWorkerParentPostMessageStream.cjs"),a),s(e("./runtime/BrowserRuntimePostMessageStream.cjs"),a),s(e("./BasePostMessageStream.cjs"),a);var n=e("./utils.cjs");Object.defineProperty(a,"isValidStreamMessage",{enumerable:!0,get:function(){return n.isValidStreamMessage}})}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/runtime/BrowserRuntimePostMessageStream.cjs",{"../BasePostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},i=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)},r=this&&this.__rest||function(e,t){var a={};for(var f in e)Object.prototype.hasOwnProperty.call(e,f)&&t.indexOf(f)<0&&(a[f]=e[f]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var s=0;for(f=Object.getOwnPropertySymbols(e);s<f.length;s++)t.indexOf(f[s])<0&&Object.prototype.propertyIsEnumerable.call(e,f[s])&&(a[f[s]]=e[f[s]])}return a};Object.defineProperty(a,"__esModule",{value:!0}),a.BrowserRuntimePostMessageStream=void 0;const o=e("../BasePostMessageStream.cjs"),c=e("../utils.cjs");class d extends o.BasePostMessageStream{constructor(e){var{name:t,target:a}=e;super(r(e,["name","target"])),f.set(this,void 0),s.set(this,void 0),n(this,f,t,"f"),n(this,s,a,"f"),this._onMessage=this._onMessage.bind(this),this._getRuntime().onMessage.addListener(this._onMessage),this._handshake()}_postMessage(e){this._getRuntime().sendMessage({target:i(this,s,"f"),data:e})}_onMessage(e){(0,c.isValidStreamMessage)(e)&&e.target===i(this,f,"f")&&this._onData(e.data)}_getRuntime(){var e,t;if("chrome"in globalThis&&"function"==typeof(null===(e=null===chrome||void 0===chrome?void 0:chrome.runtime)||void 0===e?void 0:e.sendMessage))return chrome.runtime;if("browser"in globalThis&&"function"==typeof(null===(t=null===browser||void 0===browser?void 0:browser.runtime)||void 0===t?void 0:t.sendMessage))return browser.runtime;throw new Error("browser.runtime.sendMessage is not a function. This class should only be instantiated in a web extension.")}_destroy(){this._getRuntime().onMessage.removeListener(this._onMessage)}}a.BrowserRuntimePostMessageStream=d,f=new WeakMap,s=new WeakMap}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/runtime/BrowserRuntimePostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isValidStreamMessage=a.DEDICATED_WORKER_NAME=void 0;const f=e("@metamask/utils");a.DEDICATED_WORKER_NAME="dedicatedWorker",a.isValidStreamMessage=function(e){return(0,f.isObject)(e)&&Boolean(e.data)&&("number"==typeof e.data||"object"==typeof e.data||"string"==typeof e.data)}}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerParentPostMessageStream.cjs",{"../BasePostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__rest||function(e,t){var a={};for(var f in e)Object.prototype.hasOwnProperty.call(e,f)&&t.indexOf(f)<0&&(a[f]=e[f]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var s=0;for(f=Object.getOwnPropertySymbols(e);s<f.length;s++)t.indexOf(f[s])<0&&Object.prototype.propertyIsEnumerable.call(e,f[s])&&(a[f[s]]=e[f[s]])}return a};Object.defineProperty(a,"__esModule",{value:!0}),a.WebWorkerParentPostMessageStream=void 0;const s=e("../BasePostMessageStream.cjs"),n=e("../utils.cjs");class i extends s.BasePostMessageStream{constructor(e){var{worker:t}=e;super(f(e,["worker"])),this._target=n.DEDICATED_WORKER_NAME,this._worker=t,this._worker.onmessage=this._onMessage.bind(this),this._handshake()}_postMessage(e){this._worker.postMessage({target:this._target,data:e})}_onMessage(e){const t=e.data;(0,n.isValidStreamMessage)(t)&&this._onData(t.data)}_destroy(){this._worker.onmessage=null,this._worker=null}}a.WebWorkerParentPostMessageStream=i}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerParentPostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerPostMessageStream.cjs",{"../BasePostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.WebWorkerPostMessageStream=void 0;const f=e("../BasePostMessageStream.cjs"),s=e("../utils.cjs");class n extends f.BasePostMessageStream{constructor(e={}){if("undefined"==typeof self||"undefined"==typeof WorkerGlobalScope)throw new Error("WorkerGlobalScope not found. This class should only be instantiated in a WebWorker.");super(e),this._name=s.DEDICATED_WORKER_NAME,self.addEventListener("message",this._onMessage.bind(this)),this._handshake()}_postMessage(e){self.postMessage({data:e})}_onMessage(e){const t=e.data;(0,s.isValidStreamMessage)(t)&&t.target===this._name&&this._onData(t.data)}_destroy(){return undefined}}a.WebWorkerPostMessageStream=n}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerPostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/window/WindowPostMessageStream.cjs",{"../BasePostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n=this&&this.__rest||function(e,t){var a={};for(var f in e)Object.prototype.hasOwnProperty.call(e,f)&&t.indexOf(f)<0&&(a[f]=e[f]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var s=0;for(f=Object.getOwnPropertySymbols(e);s<f.length;s++)t.indexOf(f[s])<0&&Object.prototype.propertyIsEnumerable.call(e,f[s])&&(a[f[s]]=e[f[s]])}return a};Object.defineProperty(a,"__esModule",{value:!0}),a.WindowPostMessageStream=void 0;const i=e("@metamask/utils"),r=e("../BasePostMessageStream.cjs"),o=e("../utils.cjs"),c=null===(f=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"source"))||void 0===f?void 0:f.get;(0,i.assert)(c,"MessageEvent.prototype.source getter is not defined.");const d=null===(s=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"origin"))||void 0===s?void 0:s.get;(0,i.assert)(d,"MessageEvent.prototype.origin getter is not defined.");class l extends r.BasePostMessageStream{constructor(e){var{name:t,target:a,targetOrigin:f=location.origin,targetWindow:s=window}=e;if(super(n(e,["name","target","targetOrigin","targetWindow"])),"undefined"==typeof window||"function"!=typeof window.postMessage)throw new Error("window.postMessage is not a function. This class should only be instantiated in a Window.");this._name=t,this._target=a,this._targetOrigin=f,this._targetWindow=s,this._onMessage=this._onMessage.bind(this),window.addEventListener("message",this._onMessage,!1),this._handshake()}_postMessage(e){this._targetWindow.postMessage({target:this._target,data:e},this._targetOrigin)}_onMessage(e){const t=e.data;"*"!==this._targetOrigin&&d.call(e)!==this._targetOrigin||c.call(e)!==this._targetWindow||!(0,o.isValidStreamMessage)(t)||t.target!==this._name||this._onData(t.data)}_destroy(){window.removeEventListener("message",this._onMessage,!1)}}a.WindowPostMessageStream=l}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/window/WindowPostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/index.js",{"./ppom-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-controller.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;var f=e("./ppom-controller");Object.defineProperty(a,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return f.NETWORK_CACHE_DURATION}}),Object.defineProperty(a,"PPOMController",{enumerable:!0,get:function(){return f.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-controller.js",{"./ppom-storage":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-storage.js","./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/util.js","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","await-semaphore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/await-semaphore/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c,d,l,b,m,u,p,h,g,k,y,w,x,v,S,_,j,P,T,E,O,M,I,C,A,R,$=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},N=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;const L=e("@metamask/base-controller"),D=e("@metamask/controller-utils"),F=e("await-semaphore"),B=e("./ppom-storage"),U=e("./util");a.NETWORK_CACHE_DURATION=6048e5;const q=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],H={versionInfo:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1},storageMetadata:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1}},V="PPOMController",G={headers:{"Content-Type":"application/json"}};class W extends L.BaseController{constructor({chainId:e,messenger:t,provider:a,storageBackend:k,securityAlertsEnabled:y,onPreferencesChange:w,ppomProvider:_,cdnBaseUrl:j,providerRequestLimit:P,state:T,blockaidPublicKey:E,nativeCrypto:O}){super({name:V,metadata:H,messenger:t,state:{versionInfo:T?.versionInfo??[],storageMetadata:T?.storageMetadata??[]}}),f.add(this),s.set(this,void 0),n.set(this,void 0),i.set(this,void 0),r.set(this,void 0),o.set(this,void 0),c.set(this,void 0),d.set(this,void 0),l.set(this,0),b.set(this,void 0),m.set(this,void 0),u.set(this,{}),p.set(this,void 0),h.set(this,!1),g.set(this,undefined),$(this,b,(0,U.addHexPrefix)(e),"f"),$(this,n,a,"f"),$(this,o,_,"f"),$(this,i,new B.PPOMStorage({storageBackend:k,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update(t=>{t.storageMetadata=e})}}),"f"),$(this,r,new F.Mutex,"f"),$(this,c,j,"f"),$(this,d,P??300,"f"),$(this,m,y,"f"),$(this,p,E,"f"),$(this,g,O,"f"),w(N(this,f,"m",x).bind(this)),N(this,f,"m",v).call(this),N(this,f,"m",S).call(this)}async usePPOM(e,t){const a=t??N(this,b,"f");if(!N(this,m,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,U.blockaidValidationSupportedForNetwork)(a))throw Error(`Blockaid validation not available on network with chainId: ${a}`);return await N(this,r,"f").use(async()=>{const t=await N(this,f,"m",j).call(this,a);$(this,l,0,"f"),$(this,u,{},"f");return{...await e(t),providerRequestsCount:{...N(this,u,"f")}}})}}a.PPOMController=W,s=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakMap,o=new WeakMap,c=new WeakMap,d=new WeakMap,l=new WeakMap,b=new WeakMap,m=new WeakMap,u=new WeakMap,p=new WeakMap,h=new WeakMap,g=new WeakMap,f=new WeakSet,k=async function(){if(N(this,m,"f")&&!N(this,h,"f")){const{ppomInit:e}=N(this,o,"f");await e("./ppom_bg.wasm"),$(this,h,!0,"f")}},y=function(){N(this,f,"m",_).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)});const{storageMetadata:e}=this.state;this.update(e=>{e.versionInfo=[],e.storageMetadata=[]}),N(this,i,"f").deleteAllFiles(e).catch(e=>{console.error(`Error in deleting files: ${e.message}`)})},w=function(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:a}=t.configuration,s=(0,U.addHexPrefix)(a);s!==N(this,b,"f")&&($(this,b,s,"f"),N(this,f,"m",_).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)}))},x=function(e){const t=e.securityAlertsEnabled;t!==N(this,m,"f")&&($(this,m,t,"f"),t||N(this,f,"m",y).call(this))},v=function(){this.messagingSystem.registerActionHandler(`${V}:usePPOM`,this.usePPOM.bind(this))},S=function(){const e=N(this,f,"m",w).bind(this);this.messagingSystem.subscribe("NetworkController:networkDidChange",e)},_=async function(){await N(this,r,"f").use(async()=>{N(this,s,"f")&&(N(this,s,"f").free(),$(this,s,undefined,"f"))})},j=async function(e){const t=await N(this,f,"m",P).call(this);let a;return(N(this,s,"f")===undefined||t)&&(a=await N(this,f,"m",R).call(this,e),N(this,b,"f")===e&&(N(this,s,"f")&&N(this,s,"f").free(),$(this,s,a,"f")),N(this,i,"f").syncMetadata(this.state.versionInfo).catch(e=>{console.error(`Error while trying to sync metadata: ${e.message}`)})),a},P=async function(){const e=await N(this,f,"m",I).call(this);return!!e&&(this.update(t=>{t.versionInfo=e}),!0)},T=function(e,t){return e.find(e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum)},E=async function(e){const t=await Promise.all(e.map(async e=>{let t;try{t=await N(this,f,"m",O).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined}));return t?.filter(e=>e?.[1]!==undefined)},O=async function(e){const{storageMetadata:t}=this.state;if(N(this,f,"m",T).call(this,t,e))try{return await N(this,i,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,U.checkFilePath)(e.filePath);const a=(0,U.constructURLHref)(N(this,c,"f"),e.filePath),s=await N(this,f,"m",C).call(this,a);return await(0,U.validateSignature)(s,e.hashSignature,N(this,p,"f"),e.filePath,N(this,g,"f")),await N(this,i,"f").writeFile({data:s,...e}).catch(e=>{console.error(`Error in writing file: ${e.message}`)}),s},M=async function(e,t={},a="GET"){const f=await(0,D.safelyExecute)(async()=>(0,D.timeoutFetch)(e,{method:a,cache:"no-cache",redirect:"error",...t},1e4),!0),s=304===f?.status;if(!f?.status||f?.status<200||f?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:s,response:f}},I=async function(){const e=(0,U.constructURLHref)(N(this,c,"f"),"ppom_version.json"),{cached:t,response:a}=await N(this,f,"m",M).call(this,e,{headers:G});return t&&this.state.versionInfo?.length?undefined:a.json()},C=async function(e){const{response:t}=await N(this,f,"m",M).call(this,e);return await t.arrayBuffer()},A=async function(e,t){if(N(this,l,"f")>N(this,d,"f"))return U.PROVIDER_ERRORS.limitExceeded();if($(this,l,N(this,l,"f")+1,"f"),!q.includes(e))return U.PROVIDER_ERRORS.methodNotSupported();N(this,u,"f")[e]=N(this,u,"f")[e]?Number(N(this,u,"f")[e])+1:1;const a=(0,U.createPayload)(e,t);try{const e=await N(this,n,"f").request(a);return{jsonrpc:"2.0",id:a.id,result:e}}catch(e){return{jsonrpc:"2.0",id:a.id,error:e}}},R=async function(e){await N(this,f,"m",k).call(this);const t=this.state.versionInfo.filter(({chainId:t})=>t===e);if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const a=await N(this,f,"m",E).call(this,t);if(a?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:s}=N(this,o,"f");return s.new(N(this,f,"m",A).bind(this),a)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-storage.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},r=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMStorage=void 0;a.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:a}){f.set(this,void 0),s.set(this,void 0),n.set(this,void 0),i(this,f,e,"f"),i(this,s,t,"f"),i(this,n,a,"f")}async syncMetadata(e){const t=r(this,s,"f").call(this),a=[];for(const f of t){try{await this.readFile(f.name,f.chainId)}catch(e){console.error("Error: ",e);continue}e.find(e=>e.name===f.name&&e.chainId===f.chainId&&e.version===f.version&&e.checksum===f.checksum)&&a.push(f)}const i=await r(this,f,"f").dir();for(const{name:e,chainId:t}of i)a.find(a=>a.name===e&&a.chainId===t)||await r(this,f,"f").delete({name:e,chainId:t});return r(this,n,"f").call(this,a),a}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:a}=t;try{await r(this,f,"f").delete({name:e,chainId:a})}catch(t){console.error(`Error in deleting file: ${e}, ${a}`,t)}}}async readFile(e,t){const a=r(this,s,"f").call(this).find(a=>a.name===e&&a.chainId===t);if(!a)throw new Error(`File metadata (${e}, ${t}) not found`);const n=await r(this,f,"f").read({name:e,chainId:t},a.checksum);if(!n)throw new Error(`Storage File (${e}, ${t}) not found`);return n}async writeFile({data:e,name:t,chainId:a,version:i,checksum:o}){await r(this,f,"f").write({name:t,chainId:a},e,o);const c=r(this,s,"f").call(this),d=c.find(e=>e.name===t&&e.chainId===a);d?(d.version=i,d.checksum=o):c.push({name:t,chainId:a,version:i,checksum:o}),r(this,n,"f").call(this,c)}},f=new WeakMap,s=new WeakMap,n=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/util.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","crypto-js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/crypto-js/index.js",elliptic:"/home/runner/work/metamask-extension/metamask-extension/node_modules/elliptic/lib/elliptic.js","json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(t){(function(){var f=this&&this.__createBinding||(Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&f(t,e,a);return s(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.checkFilePath=a.addHexPrefix=a.constructURLHref=a.validateSignature=a.PROVIDER_ERRORS=a.createPayload=a.IdGenerator=a.blockaidValidationSupportedForNetwork=a.SUPPORTED_NETWORK_CHAINIDS=void 0;const r=n(e("crypto-js")),o=i(e("elliptic")),c=i(e("json-rpc-random-id")),d=o.default.eddsa;a.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};a.blockaidValidationSupportedForNetwork=e=>Object.values(a.SUPPORTED_NETWORK_CHAINIDS).some(t=>t===e),a.IdGenerator=(0,c.default)();a.createPayload=(e,t)=>({id:(0,a.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),a.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};a.validateSignature=async(e,a,f,s,n,i)=>{const o=await(async(e,t,a=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&a){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map(e=>e.toString(16).padStart(2,"0")).join("")}return(0,r.SHA256)(r.default.lib.WordArray.create(e)).toString()})(e,n,i);if(!new d("ed25519").keyFromPublic(f).verify(t.from(o),a))throw Error(`Signature verification failed for file path: ${s}`)};a.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;a.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;a.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs",{"@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RateLimitController=void 0;const f=e("@metamask/base-controller"),s=e("@metamask/rpc-errors"),n=e("@metamask/utils"),i="RateLimitController",r={requests:{persist:!1,anonymous:!1}};class o extends f.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:a,state:f,implementations:s}){const o={requests:(0,n.getKnownPropertyNames)(s).reduce((e,t)=>({...e,[t]:{}}),{})};super({name:i,metadata:r,messenger:a,state:{...o,...f}}),this.implementations=s,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messagingSystem.registerActionHandler(`${i}:call`,(e,t,...a)=>this.call(e,t,...a))}async call(e,t,...a){if(this.isRateLimited(t,e))throw s.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const f=this.implementations[t].method;if(!f)throw new Error("Invalid api type");return f(...a)}isRateLimited(e,t){const a=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=a}recordRequest(e,t){const a=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,f=this.state.requests[e][t]??0;this.update(s=>{0===f&&setTimeout(()=>this.resetRequestCount(e,t),a),Object.assign(s,{requests:{...s.requests,[e]:{[t]:f+1}}})})}resetRequestCount(e,t){this.update(a=>{Object.assign(a,{requests:{...a.requests,[e]:{[t]:0}}})})}}a.RateLimitController=o}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/index.cjs",{"./RateLimitController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RateLimitController=void 0;var f=e("./RateLimitController.cjs");Object.defineProperty(a,"RateLimitController",{enumerable:!0,get:function(){return f.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},c=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ClientConfigApiService=void 0;const d=e("@metamask/controller-utils"),l=e("../constants.cjs");a.ClientConfigApiService=class{constructor({fetch:e,retries:t=d.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:a=d.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:l=d.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:b,onDegraded:m,config:u}){f.set(this,void 0),s.set(this,void 0),n.set(this,void 0),i.set(this,void 0),r.set(this,void 0),o(this,f,e,"f"),o(this,n,u.client,"f"),o(this,i,u.distribution,"f"),o(this,r,u.environment,"f"),o(this,s,(0,d.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:a,circuitBreakDuration:l}),"f"),b&&c(this,s,"f").onBreak(b),m&&c(this,s,"f").onDegraded(m)}onBreak(...e){return c(this,s,"f").onBreak(...e)}onDegraded(...e){return c(this,s,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${l.BASE_URL}/flags?client=${c(this,n,"f")}&distribution=${c(this,i,"f")}&environment=${c(this,r,"f")}`,t=await c(this,s,"f").execute(()=>c(this,f,"f").call(this,e,{cache:"no-cache"}));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const a=await t.json();if(!Array.isArray(a))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(a),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce((e,t)=>({...e,...t}),{})}},f=new WeakMap,s=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.BASE_URL=void 0,a.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs",{"./client-config-api-service/client-config-api-service.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs","./remote-feature-flag-controller-types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs","./remote-feature-flag-controller.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs","./utils/user-segmentation-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.generateDeterministicRandomNumber=a.ClientConfigApiService=a.EnvironmentType=a.DistributionType=a.ClientType=a.RemoteFeatureFlagController=void 0;var f=e("./remote-feature-flag-controller.cjs");Object.defineProperty(a,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return f.RemoteFeatureFlagController}});var s=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(a,"ClientType",{enumerable:!0,get:function(){return s.ClientType}}),Object.defineProperty(a,"DistributionType",{enumerable:!0,get:function(){return s.DistributionType}}),Object.defineProperty(a,"EnvironmentType",{enumerable:!0,get:function(){return s.EnvironmentType}});var n=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(a,"ClientConfigApiService",{enumerable:!0,get:function(){return n.ClientConfigApiService}});var i=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(a,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return i.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n;Object.defineProperty(a,"__esModule",{value:!0}),a.EnvironmentType=a.DistributionType=a.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(f||(a.ClientType=f={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(s||(a.DistributionType=s={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev"}(n||(a.EnvironmentType=n={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs",{"./utils/user-segmentation-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c,d,l,b=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},m=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.RemoteFeatureFlagController=a.getDefaultRemoteFeatureFlagControllerState=a.DEFAULT_CACHE_DURATION=a.controllerName=void 0;const u=e("@metamask/base-controller"),p=e("./utils/user-segmentation-utils.cjs");a.controllerName="RemoteFeatureFlagController",a.DEFAULT_CACHE_DURATION=864e5;const h={remoteFeatureFlags:{persist:!0,anonymous:!0},cacheTimestamp:{persist:!0,anonymous:!0}};function g(){return{remoteFeatureFlags:{},cacheTimestamp:0}}a.getDefaultRemoteFeatureFlagControllerState=g;class k extends u.BaseController{constructor({messenger:e,state:t,clientConfigApiService:c,fetchInterval:d=a.DEFAULT_CACHE_DURATION,disabled:l=!1,getMetaMetricsId:m}){super({name:a.controllerName,metadata:h,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),f.add(this),s.set(this,void 0),n.set(this,void 0),i.set(this,void 0),r.set(this,void 0),o.set(this,void 0),b(this,s,d,"f"),b(this,n,l,"f"),b(this,i,c,"f"),b(this,o,m,"f")}async updateRemoteFeatureFlags(){if(m(this,n,"f")||!m(this,f,"m",c).call(this))return;let e;if(m(this,r,"f"))await m(this,r,"f");else{try{b(this,r,m(this,i,"f").fetchRemoteFeatureFlags(),"f"),e=await m(this,r,"f")}finally{b(this,r,undefined,"f")}await m(this,f,"m",d).call(this,e.remoteFeatureFlags)}}enable(){b(this,n,!1,"f")}disable(){b(this,n,!0,"f")}}a.RemoteFeatureFlagController=k,s=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakMap,o=new WeakMap,f=new WeakSet,c=function(){return Date.now()-this.state.cacheTimestamp>m(this,s,"f")},d=async function(e){const t=await m(this,f,"m",l).call(this,e);this.update(()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()}))},l=async function(e){const t={},a=m(this,o,"f").call(this),f=(0,p.generateDeterministicRandomNumber)(a);for(const[a,s]of Object.entries(e)){let e=s;if(Array.isArray(s)&&f){const t=s.find(e=>!!(0,p.isFeatureFlagWithScopeValue)(e)&&f<=e.scope.value);t&&(e={name:t.name,value:t.value})}t[a]=e}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs",{uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isFeatureFlagWithScopeValue=a.generateDeterministicRandomNumber=void 0;const f=e("uuid");function s(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const n=s("00000000-0000-4000-8000-000000000000"),i=s("ffffffff-ffff-4fff-bfff-ffffffffffff")-n;a.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,a;if((0,f.validate)(e)){if(4!==(0,f.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,f.version)(e)}`);t=s(e)-n,a=i}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const f=e.slice(2),s=64;if(f.length!==s)throw new Error(`Invalid hex ID length. Expected ${s} characters, got ${f.length}`);if(!/^[0-9a-f]+$/iu.test(f))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${f}`),a=BigInt(`0x${"f".repeat(f.length)}`)}return Number(t*BigInt(1e6)/a)/1e6};a.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs",{"@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/swappable-obj-proxy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/swappable-obj-proxy/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},d=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.SelectedNetworkController=a.SelectedNetworkControllerEventTypes=a.SelectedNetworkControllerActionTypes=a.METAMASK_DOMAIN=a.controllerName=void 0;const l=e("@metamask/base-controller"),b=e("@metamask/swappable-obj-proxy");a.controllerName="SelectedNetworkController";const m={domains:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0}};a.METAMASK_DOMAIN="metamask",a.SelectedNetworkControllerActionTypes={getState:`${a.controllerName}:getState`,getNetworkClientIdForDomain:`${a.controllerName}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${a.controllerName}:setNetworkClientIdForDomain`},a.SelectedNetworkControllerEventTypes={stateChange:`${a.controllerName}:stateChange`};class u extends l.BaseController{constructor({messenger:e,state:t={domains:{}},domainProxyMap:i}){super({name:a.controllerName,metadata:m,messenger:e,state:t}),f.add(this),s.set(this,void 0),c(this,s,i,"f"),d(this,f,"m",n).call(this),this.messagingSystem.call("PermissionController:getSubjectNames").filter(e=>this.state.domains[e]===undefined).forEach(e=>this.setNetworkClientIdForDomain(e,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId)),this.messagingSystem.subscribe("PermissionController:stateChange",(e,t)=>{t.forEach(({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const a=t[1];"add"===e&&this.state.domains[a]===undefined?this.setNetworkClientIdForDomain(a,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[a]!==undefined&&d(this,f,"m",r).call(this,a)}})}),this.messagingSystem.subscribe("NetworkController:stateChange",({selectedNetworkClientId:e,networkConfigurationsByChainId:t},a)=>{const f=a.find(({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]);if(f){const a=Object.values(t).reduce((e,t)=>(t.rpcEndpoints.forEach(({networkClientId:a})=>e[a]=t.chainId),e),{});Object.entries(this.state.domains).forEach(([s,n])=>{const i=a[n];if("remove"!==f.op||i){if("replace"===f.op){const e=f.path[1];if(!i||i===e){const a=t[e],{networkClientId:f}=a.rpcEndpoints[a.defaultRpcEndpointIndex];n!==f&&this.setNetworkClientIdForDomain(s,f)}}}else this.setNetworkClientIdForDomain(s,e)})}})}setNetworkClientIdForDomain(e,t){if(e===a.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${a.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!d(this,f,"m",o).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");d(this,f,"m",i).call(this,e,t)}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messagingSystem.call("NetworkController:getState");return this.state.domains[e]??t}getProviderAndBlockTracker(e){if(e===a.METAMASK_DOMAIN){const e=this.messagingSystem.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=d(this,s,"f").get(e);if(t===undefined){let a;if(d(this,f,"m",o).call(this,e)){const t=this.getNetworkClientIdForDomain(e);a=this.messagingSystem.call("NetworkController:getNetworkClientById",t)}else if(a=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),a===undefined)throw new Error("Selected network not initialized");t={provider:(0,b.createEventEmitterProxy)(a.provider),blockTracker:(0,b.createEventEmitterProxy)(a.blockTracker,{eventFilter:"skipInternal"})},d(this,s,"f").set(e,t)}return t}}a.SelectedNetworkController=u,s=new WeakMap,f=new WeakSet,n=function(){this.messagingSystem.registerActionHandler(a.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messagingSystem.registerActionHandler(a.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},i=function(e,t){const a=this.messagingSystem.call("NetworkController:getNetworkClientById",t);this.update(a=>{a.domains[e]=t});const f=this.getProviderAndBlockTracker(e);f.provider.setTarget(a.provider),f.blockTracker.setTarget(a.blockTracker)},r=function(e){const t=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),a=d(this,s,"f").get(e);a&&t?(a.provider.setTarget(t.provider),a.blockTracker.setTarget(t.blockTracker)):a&&d(this,s,"f").delete(e),this.update(t=>{delete t.domains[e]})},o=function(e){return this.messagingSystem.call("PermissionController:hasPermissions",e)}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs",{"./SelectedNetworkController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSelectedNetworkMiddleware=void 0;const f=e("./SelectedNetworkController.cjs");a.createSelectedNetworkMiddleware=e=>(t,a,s)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var n;return t.networkClientId=(n=t.origin,e.call(f.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,n)),s()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/index.cjs",{"./SelectedNetworkController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs","./SelectedNetworkMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSelectedNetworkMiddleware=a.METAMASK_DOMAIN=a.SelectedNetworkController=a.SelectedNetworkControllerEventTypes=a.SelectedNetworkControllerActionTypes=void 0;var f=e("./SelectedNetworkController.cjs");Object.defineProperty(a,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return f.SelectedNetworkControllerActionTypes}}),Object.defineProperty(a,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return f.SelectedNetworkControllerEventTypes}}),Object.defineProperty(a,"SelectedNetworkController",{enumerable:!0,get:function(){return f.SelectedNetworkController}}),Object.defineProperty(a,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return f.METAMASK_DOMAIN}});var s=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(a,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return s.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/ShieldController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/constants.cjs","./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/logger.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/signature-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/signature-controller/dist/index.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c,d,l,b,m,u,p,h=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},g=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ShieldController=a.getDefaultShieldControllerState=void 0;const k=e("@metamask/base-controller"),y=e("@metamask/signature-controller"),w=e("@metamask/transaction-controller"),x=e("./constants.cjs"),v=e("./logger.cjs"),S=(0,v.createModuleLogger)(v.projectLogger,"ShieldController");function _(){return{coverageResults:{},orderedTransactionHistory:[]}}a.getDefaultShieldControllerState=_;const j={coverageResults:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0},orderedTransactionHistory:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1}};class P extends k.BaseController{constructor(e){const{messenger:t,state:a,backend:l,transactionHistoryLimit:b=100,coverageHistoryLimit:m=10}=e;super({name:x.controllerName,metadata:j,messenger:t,state:{coverageResults:{},orderedTransactionHistory:[],...a}}),f.add(this),s.set(this,void 0),n.set(this,void 0),i.set(this,void 0),r.set(this,void 0),o.set(this,void 0),h(this,s,l,"f"),h(this,n,m,"f"),h(this,i,b,"f"),h(this,r,g(this,f,"m",d).bind(this),"f"),h(this,o,g(this,f,"m",c).bind(this),"f")}start(){this.messagingSystem.subscribe("TransactionController:stateChange",g(this,r,"f"),e=>e.transactions),this.messagingSystem.subscribe("SignatureController:stateChange",g(this,o,"f"),e=>e.signatureRequests)}stop(){this.messagingSystem.unsubscribe("TransactionController:stateChange",g(this,r,"f")),this.messagingSystem.unsubscribe("SignatureController:stateChange",g(this,o,"f"))}async checkCoverage(e){const t=g(this,f,"m",p).call(this,e.id),a=await g(this,s,"f").checkCoverage({txMeta:e,coverageId:t});return this.messagingSystem.publish(`${x.controllerName}:coverageResultReceived`,a),g(this,f,"m",l).call(this,e.id,a),a}async checkSignatureCoverage(e){const t=g(this,f,"m",p).call(this,e.id),a=await g(this,s,"f").checkSignatureCoverage({signatureRequest:e,coverageId:t});return this.messagingSystem.publish(`${x.controllerName}:coverageResultReceived`,a),g(this,f,"m",l).call(this,e.id,a),a}}a.ShieldController=P,s=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakMap,o=new WeakMap,f=new WeakSet,c=function(e,t){const a=Object.values(e),s=Object.values(t??{}),n=new Map(s.map(e=>[e.id,e]));for(const e of a){const t=n.get(e.id);t||e.type!==y.SignatureRequestType.PersonalSign||this.checkSignatureCoverage(e).catch(e=>S("Error checking coverage:",e)),e.status===y.SignatureRequestStatus.Signed&&e.status!==t?.status&&g(this,f,"m",b).call(this,e).catch(e=>S("Error logging signature:",e))}},d=function(e,t){const a=new Map(t?.map(e=>[e.id,e])??[]);for(const t of e){const e=a.get(t.id);e&&e.simulationData===t.simulationData||this.checkCoverage(t).catch(e=>S("Error checking coverage:",e)),t.status===w.TransactionStatus.submitted&&t.status!==e?.status&&g(this,f,"m",m).call(this,t).catch(e=>S("Error logging transaction:",e))}},l=function(e,t){const a=g(this,f,"m",p).call(this,e);if(a&&t.coverageId!==a)throw new Error("Coverage ID has changed");this.update(a=>{let f=!1,s=a.coverageResults[e];s||(f=!0,s={results:[]},a.coverageResults[e]=s),s.results.length>=g(this,n,"f")&&s.results.pop(),s.results.unshift(t);const{orderedTransactionHistory:r}=a;let o;f&&(r.length>=g(this,i,"f")&&(o=r.pop(),o&&delete a.coverageResults[o]),r.unshift(e))})},b=async function(e){const t=e.rawSig;if(!t)throw new Error("Signature not found");const{status:a}=g(this,f,"m",u).call(this,e.id);await g(this,s,"f").logSignature({signatureRequest:e,signature:t,status:a})},m=async function(e){const t=e.hash;if(!t)throw new Error("Transaction hash not found");const{status:a}=g(this,f,"m",u).call(this,e.id);await g(this,s,"f").logTransaction({txMeta:e,transactionHash:t,status:a})},u=function(e){let t="shown";return g(this,f,"m",p).call(this,e)||(S("Coverage ID not found for",e),t="not_shown"),{status:t}},p=function(e){return this.state.coverageResults[e]?.results[0]?.coverageId}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/ShieldController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/backend.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c,d,l,b=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},m=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ShieldRemoteBackend=void 0;async function u(e){return new Promise(t=>setTimeout(t,e))}function p(e){return{txParams:[{from:e.txParams.from,to:e.txParams.to,value:e.txParams.value,data:e.txParams.data,nonce:e.txParams.nonce}],chainId:e.chainId,origin:e.origin}}function h(e){if("string"!=typeof e.messageParams.data)throw new Error("Signature data must be a string");return{chainId:e.chainId,data:e.messageParams.data,from:e.messageParams.from,method:e.type,origin:e.messageParams.origin}}a.ShieldRemoteBackend=class{constructor({getAccessToken:e,getCoverageResultTimeout:t=5e3,getCoverageResultPollInterval:a=1e3,baseUrl:c,fetch:d}){f.add(this),s.set(this,void 0),n.set(this,void 0),i.set(this,void 0),r.set(this,void 0),o.set(this,void 0),b(this,s,e,"f"),b(this,n,t,"f"),b(this,i,a,"f"),b(this,r,c,"f"),b(this,o,d,"f")}async checkCoverage(e){let{coverageId:t}=e;if(!t){const a=p(e.txMeta);({coverageId:t}=await m(this,f,"m",c).call(this,"v1/transaction/coverage/init",a))}const a=await m(this,f,"m",d).call(this,t);return{coverageId:t,message:a.message,reasonCode:a.reasonCode,status:a.status}}async checkSignatureCoverage(e){let{coverageId:t}=e;if(!t){const a=h(e.signatureRequest);({coverageId:t}=await m(this,f,"m",c).call(this,"v1/signature/coverage/init",a))}const a=await m(this,f,"m",d).call(this,t);return{coverageId:t,message:a.message,reasonCode:a.reasonCode,status:a.status}}async logSignature(e){const t=h(e.signatureRequest),a={signature:e.signature,status:e.status,...t},s=await m(this,o,"f").call(this,`${m(this,r,"f")}/v1/signature/coverage/log`,{method:"POST",headers:await m(this,f,"m",l).call(this),body:JSON.stringify(a)});if(200!==s.status)throw new Error(`Failed to log signature: ${s.status}`)}async logTransaction(e){const t=p(e.txMeta),a={transactionHash:e.transactionHash,status:e.status,...t},s=await m(this,o,"f").call(this,`${m(this,r,"f")}/v1/transaction/coverage/log`,{method:"POST",headers:await m(this,f,"m",l).call(this),body:JSON.stringify(a)});if(200!==s.status)throw new Error(`Failed to log transaction: ${s.status}`)}},s=new WeakMap,n=new WeakMap,i=new WeakMap,r=new WeakMap,o=new WeakMap,f=new WeakSet,c=async function(e,t){const a=await m(this,o,"f").call(this,`${m(this,r,"f")}/${e}`,{method:"POST",headers:await m(this,f,"m",l).call(this),body:JSON.stringify(t)});if(200!==a.status)throw new Error(`Failed to init coverage check: ${a.status}`);return await a.json()},d=async function(e,t=m(this,n,"f"),a=m(this,i,"f")){const s={coverageId:e},c=await m(this,f,"m",l).call(this);return await new Promise((e,f)=>{let n=!1;setTimeout(()=>{n=!0,f(new Error("Timeout waiting for coverage result"))},t);(async()=>{for(;!n;){const e=Date.now(),t=await m(this,o,"f").call(this,`${m(this,r,"f")}/v1/transaction/coverage/result`,{method:"POST",headers:c,body:JSON.stringify(s)});if(200===t.status)return await t.json();await u(a-(Date.now()-e))}throw new Error("unexpected error")})().then(e).catch(f)})},l=async function(){return{"Content-Type":"application/json",Authorization:`Bearer ${await m(this,s,"f").call(this)}`}}}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/backend.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.controllerName=void 0,a.controllerName="ShieldController"}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/index.cjs",{"./ShieldController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/ShieldController.cjs","./backend.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/backend.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ShieldRemoteBackend=a.getDefaultShieldControllerState=a.ShieldController=void 0;var f=e("./ShieldController.cjs");Object.defineProperty(a,"ShieldController",{enumerable:!0,get:function(){return f.ShieldController}}),Object.defineProperty(a,"getDefaultShieldControllerState",{enumerable:!0,get:function(){return f.getDefaultShieldControllerState}});var s=e("./backend.cjs");Object.defineProperty(a,"ShieldRemoteBackend",{enumerable:!0,get:function(){return s.ShieldRemoteBackend}})}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/logger.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/shield-controller/dist/constants.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createModuleLogger=a.projectLogger=void 0;const f=e("@metamask/utils");Object.defineProperty(a,"createModuleLogger",{enumerable:!0,get:function(){return f.createModuleLogger}});const s=e("./constants.cjs");a.projectLogger=(0,f.createProjectLogger)(s.controllerName)}}},{package:"@metamask/shield-controller",file:"node_modules/@metamask/shield-controller/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs",{"../snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","../snaps/constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js",luxon:"/home/runner/work/metamask-extension/metamask-extension/node_modules/luxon/build/cjs-browser/luxon.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){s(e,t),t.set(e,a)}function s(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function n(e,t){return e.get(r(e,t))}function i(e,t,a){return e.set(r(e,t),a),a}function r(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.CronjobController=a.DAILY_TIMEOUT=void 0;const o=e("@metamask/base-controller"),c=e("@metamask/snaps-rpc-methods"),d=e("@metamask/snaps-utils"),l=e("@metamask/utils"),b=e("immer"),m=e("luxon"),u=e("nanoid"),p=e("./utils.cjs"),h=e("../snaps/constants.cjs"),g=e("../snaps/Timer.cjs");a.DAILY_TIMEOUT=(0,l.inMilliseconds)(24,l.Duration.Hour);const k="CronjobController";var y=new WeakMap,w=new WeakMap,x=new WeakMap,v=new WeakSet,S=new WeakMap,_=new WeakMap,j=new WeakMap,P=new WeakMap,T=new WeakMap;class E extends o.BaseController{constructor({messenger:e,state:t,stateManager:o}){var c,d;super({messenger:e,metadata:{events:{includeInStateLogs:!1,persist:!1,anonymous:!1,usedInUi:!1}},name:k,state:{events:{},...t,...o.getInitialState()}}),s(c=this,d=v),d.add(c),f(this,y,void 0),f(this,w,void 0),f(this,x,new g.Timer(a.DAILY_TIMEOUT)),f(this,S,e=>{this.unregister(e.id),this.register(e.id)}),f(this,_,e=>{const t=this.get(e.id);r(v,this,N).call(this,t),this.register(e.id)}),f(this,j,e=>{this.unregister(e.id)}),f(this,P,e=>{this.unregister(e.id)}),f(this,T,e=>{this.unregister(e.id),this.register(e.id)}),i(y,this,new Map),i(w,this,o),this.messagingSystem.subscribe("SnapController:snapInstalled",n(S,this)),this.messagingSystem.subscribe("SnapController:snapUninstalled",n(j,this)),this.messagingSystem.subscribe("SnapController:snapEnabled",n(_,this)),this.messagingSystem.subscribe("SnapController:snapDisabled",n(P,this)),this.messagingSystem.subscribe("SnapController:snapUpdated",n(T,this)),this.messagingSystem.registerActionHandler(`${k}:init`,(...e)=>this.init(...e)),this.messagingSystem.registerActionHandler(`${k}:schedule`,(...e)=>this.schedule(...e)),this.messagingSystem.registerActionHandler(`${k}:cancel`,(...e)=>this.cancel(...e)),this.messagingSystem.registerActionHandler(`${k}:get`,(...e)=>this.get(...e))}init(){r(v,this,O).call(this),r(v,this,L).call(this),r(v,this,N).call(this)}schedule(e){return r(v,this,M).call(this,{...e,recurring:!1})}cancel(e,t){(0,l.assert)(this.state.events[t],`A background event with the id of "${t}" does not exist.`),(0,l.assert)(this.state.events[t].snapId===e,"Only the origin that scheduled this event can cancel it."),r(v,this,R).call(this,t)}get(e){return Object.values(this.state.events).filter(t=>t.snapId===e&&!t.recurring).map(e=>({...e,date:(0,d.toCensoredISO8601String)(e.date),scheduledAt:(0,d.toCensoredISO8601String)(e.scheduledAt)}))}register(e){const t=r(v,this,$).call(this,e);null==t||t.forEach(e=>r(v,this,M).call(this,e))}unregister(e){for(const[t,a]of Object.entries(this.state.events))a.snapId===e&&r(v,this,R).call(this,t)}destroy(){super.destroy(),this.messagingSystem.unsubscribe("SnapController:snapInstalled",n(S,this)),this.messagingSystem.unsubscribe("SnapController:snapUninstalled",n(j,this)),this.messagingSystem.unsubscribe("SnapController:snapEnabled",n(_,this)),this.messagingSystem.unsubscribe("SnapController:snapDisabled",n(P,this)),this.messagingSystem.unsubscribe("SnapController:snapUpdated",n(T,this)),n(y,this).forEach(e=>e.cancel()),n(y,this).clear(),"running"===n(x,this).status&&n(x,this).cancel()}}function O(){i(x,this,new g.Timer(a.DAILY_TIMEOUT)),n(x,this).start(()=>{r(v,this,N).call(this),r(v,this,O).call(this)})}function M(e){const t=e.id??(0,u.nanoid)(),a={...e,id:t,date:(0,p.getExecutionDate)(e.schedule),scheduledAt:(new Date).toISOString()},{nextState:f}=this.update(e=>{e.events[a.id]=(0,b.castDraft)(a)});return n(w,this).set(f),r(v,this,I).call(this,a),t}function I(e,t=!0){if(!t)return void r(v,this,C).call(this,e);const a=(0,p.getExecutionDate)(e.schedule),{nextState:f}=this.update(t=>{t.events[e.id].date=a});n(w,this).set(f),r(v,this,C).call(this,{...e,date:a})}function C(e){const t=m.DateTime.fromISO(e.date,{setZone:!0}).toMillis()-Date.now();if(t>a.DAILY_TIMEOUT)return;if(t<=0)return void r(v,this,A).call(this,e);const f=new g.Timer(t);f.start(()=>{r(v,this,A).call(this,e)}),n(y,this).set(e.id,f)}function A(e){if(this.messagingSystem.call("SnapController:handleRequest",{snapId:e.snapId,origin:h.METAMASK_ORIGIN,handler:d.HandlerType.OnCronjob,request:e.request}).catch(t=>{(0,d.logError)(`An error occurred while executing an event for Snap "${e.snapId}":`,t)}),n(y,this).delete(e.id),!e.recurring){const{nextState:t}=this.update(t=>{delete t.events[e.id]});return void n(w,this).set(t)}r(v,this,I).call(this,e)}function R(e){const t=n(y,this).get(e);null==t||t.cancel(),n(y,this).delete(e);const{nextState:a}=this.update(t=>{delete t.events[e]});n(w,this).set(a)}function $(e){const t=this.messagingSystem.call("PermissionController:getPermissions",e),a=null==t?void 0:t[c.SnapEndowments.Cronjob],f=(0,c.getCronjobCaveatJobs)(a);return f?f.map((t,a)=>({snapId:e,id:`cronjob-${e}-${a}`,request:t.request,schedule:(0,p.getCronjobSpecificationSchedule)(t),recurring:!0})):[]}function N(e=Object.values(this.state.events)){const t=Date.now();for(const a of e){if(n(y,this).has(a.id))continue;const e=m.DateTime.fromISO(a.date,{setZone:!0}).toUTC().toMillis();a.recurring&&e<=t?r(v,this,A).call(this,a):r(v,this,I).call(this,a,!1)}}function L(){const e=Date.now();for(const t of Object.values(this.state.events)){const a=m.DateTime.fromISO(t.date,{setZone:!0}).toUTC().toMillis();!t.recurring&&a<e&&r(v,this,R).call(this,t.id)}}a.CronjobController=E}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs",{"./CronjobController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./CronjobController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","cron-parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/cron-parser/lib/parser.js",luxon:"/home/runner/work/metamask-extension/metamask-extension/node_modules/luxon/build/cjs-browser/luxon.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getExecutionDate=a.getCronjobSpecificationSchedule=void 0;const f=e("@metamask/utils"),s=e("cron-parser"),n=e("luxon");a.getCronjobSpecificationSchedule=function(e){return(0,f.hasProperty)(e,"duration")?e.duration:e.expression},a.getExecutionDate=function(e){const t=n.DateTime.fromISO(e,{setZone:!0});if(t.isValid){const e=Date.now(),a=t.toUTC().startOf("second");if(a.toMillis()<e)throw new Error("Cannot schedule an event in the past.");return a.toISO({suppressMilliseconds:!0})}const a=n.Duration.fromISO(e);if(a.isValid){const e=function(e){return e.as("seconds")<1?n.Duration.fromObject({seconds:1}):e}(a);return n.DateTime.now().toUTC().plus(e).toISO()}try{const t=(0,s.parseExpression)(e,{utc:!0}).next(),a=n.DateTime.fromJSDate(t.toDate());return(0,f.assert)(a.isValid),a.toUTC().toISO()}catch{throw new Error(`Unable to parse "${e}" as ISO 8601 date, ISO 8601 duration, or cron expression.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/fsm.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@xstate/fsm":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@xstate/fsm/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.forceStrict=a.validateMachine=void 0;const f=e("@metamask/utils"),s=e("@xstate/fsm");a.validateMachine=function(e){(0,f.assert)("_options"in e,"The machine is not an @xstate/fsm machine");const t=e,a=new Set,s=e=>{return(t=e,Array.isArray(t)?t:t===undefined||null===t?[]:[t]).flatMap(e=>"string"==typeof e?[e]:((0,f.assert)("function"==typeof e),[])).forEach(a.add.bind(a));var t};for(const e of Object.values(t.config.states)){s(e.entry),s(e.exit);for(const t of Object.values(e.on??{}))s(t.actions)}a.forEach(e=>(0,f.assert)(t._options.actions!==undefined&&e in t._options.actions,`Action "${e}" doesn't have an implementation`))},a.forceStrict=function(e){let t=!1;e.subscribe(e=>{(0,f.assert)(!t||e.changed,"Invalid state transition"),t=!0});const a=e.send.bind(e);e.send=(...t)=>((0,f.assert)(e.status===s.InterpreterStatus.Running,"Interpreter is stopped"),a(...t))}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/fsm.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/index.cjs",{"./cronjob/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs","./insights/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/index.cjs","./interface/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/index.cjs","./multichain/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs","./services/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/index.cjs","./snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","./websocket/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./services/index.cjs"),a),s(e("./snaps/index.cjs"),a),s(e("./utils.cjs"),a),s(e("./cronjob/index.cjs"),a),s(e("./interface/index.cjs"),a),s(e("./insights/index.cjs"),a),s(e("./multichain/index.cjs"),a),s(e("./websocket/index.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function s(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.SnapInsightsController=void 0;const n=e("@metamask/base-controller"),i=e("@metamask/snaps-rpc-methods"),r=e("@metamask/snaps-utils"),o=e("@metamask/utils"),c=e("../snaps/index.cjs");var d=new WeakSet;class l extends n.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{insights:{includeInStateLogs:!0,persist:!1,anonymous:!1,usedInUi:!0}},name:"SnapInsightsController",state:{insights:{},...t}}),f(this,d),this.messagingSystem.subscribe("TransactionController:unapprovedTransactionAdded",s(d,this,u).bind(this)),this.messagingSystem.subscribe("TransactionController:transactionStatusUpdated",s(d,this,g).bind(this)),this.messagingSystem.subscribe("SignatureController:stateChange",s(d,this,p).bind(this))}}function b(e){return(0,o.hasProperty)(this.state.insights,e)}function m(e){const t=this.messagingSystem.call("SnapController:getAll");return(0,c.getRunnableSnaps)(t).reduce((t,a)=>{const f=this.messagingSystem.call("PermissionController:getPermissions",a.id);return f&&(0,o.hasProperty)(f,e)&&t.push({snapId:a.id,permission:f[e]}),t},[])}function u(e){const{id:t,txParams:a,chainId:f,origin:n}=e,c=`eip155:${(0,o.hexToBigInt)(f).toString(10)}`;s(d,this,m).call(this,i.SnapEndowments.TransactionInsight).forEach(({snapId:e,permission:f})=>{const o=(0,i.getTransactionOriginCaveat)(f)&&n?n:null;this.update(a=>{var f;(f=a.insights)[t]??(f[t]={}),a.insights[t][e]={snapId:e,loading:!0}}),s(d,this,y).call(this,{snapId:e,handler:r.HandlerType.OnTransaction,params:{transaction:a,chainId:c,transactionOrigin:o}}).then(a=>s(d,this,w).call(this,{id:t,snapId:e,response:a})).catch(a=>s(d,this,w).call(this,{id:t,snapId:e,error:a}))})}function p(e){for(const t of Object.keys(this.state.insights))(0,o.hasProperty)(e.unapprovedTypedMessages,t)||(0,o.hasProperty)(e.unapprovedPersonalMsgs,t)||s(d,this,k).call(this,t);if(e.unapprovedPersonalMsgCount>0||e.unapprovedTypedMessagesCount>0){const t=s(d,this,m).call(this,i.SnapEndowments.SignatureInsight);for(const a of Object.values(e.unapprovedPersonalMsgs))s(d,this,h).call(this,t,a);for(const a of Object.values(e.unapprovedTypedMessages))s(d,this,h).call(this,t,a)}}function h(e,t){const{id:a,msgParams:f}=t;if(s(d,this,b).call(this,a))return;const{from:n,data:o,signatureMethod:c,origin:l}=f,m={from:n,data:"eth_signTypedData_v3"===c||"eth_signTypedData_v4"===c?JSON.parse(o):o,signatureMethod:c};e.forEach(({snapId:e,permission:t})=>{const f=(0,i.getSignatureOriginCaveat)(t),n=l&&f?l:null;this.update(t=>{var f;(f=t.insights)[a]??(f[a]={}),t.insights[a][e]={snapId:e,loading:!0}}),s(d,this,y).call(this,{snapId:e,handler:r.HandlerType.OnSignature,params:{signature:m,signatureOrigin:n}}).then(t=>s(d,this,w).call(this,{id:a,snapId:e,response:t})).catch(t=>s(d,this,w).call(this,{id:a,snapId:e,error:t}))})}function g({transactionMeta:e}){"unapproved"!==e.status&&s(d,this,k).call(this,e.id)}function k(e){s(d,this,b).call(this,e)&&(Object.values(this.state.insights[e]).filter(e=>e.interfaceId).forEach(e=>{this.messagingSystem.call("SnapInterfaceController:deleteInterface",e.interfaceId)}),this.update(t=>{delete t.insights[e]}))}async function y({snapId:e,handler:t,params:a}){return this.messagingSystem.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:t,request:{method:"",params:a}})}function w({id:e,snapId:t,response:a,error:f}){s(d,this,b).call(this,e)&&this.update(s=>{s.insights[e][t].loading=!1,s.insights[e][t].interfaceId=null==a?void 0:a.id,s.insights[e][t].severity=null==a?void 0:a.severity,s.insights[e][t].error=null==f?void 0:f.message})}a.SnapInsightsController=l}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/index.cjs",{"./SnapInsightsController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./SnapInsightsController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function s(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.SnapInterfaceController=void 0;const n=e("@metamask/base-controller"),i=e("@metamask/snaps-sdk"),r=e("@metamask/snaps-utils"),o=e("@metamask/utils"),c=e("immer"),d=e("nanoid"),l=e("./utils.cjs"),b=1e7,m="SnapInterfaceController";var u=new WeakSet;class p extends n.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{interfaces:{includeInStateLogs:!0,persist:e=>Object.entries(e).reduce((e,[t,a])=>a.contentType===i.ContentType.Notification?(e[t]=a,e):e,{}),anonymous:!1,usedInUi:!0}},name:m,state:{interfaces:{},...t}}),f(this,u),this.messagingSystem.subscribe("NotificationServicesController:notificationsListUpdated",s(u,this,E).bind(this)),s(u,this,h).call(this)}createInterface(e,t,a,f){const n=(0,l.getJsxInterface)(t);s(u,this,T).call(this,n),(0,l.validateInterfaceContext)(a);const i=(0,d.nanoid)(),o=(0,l.constructState)({},n,{getAssetsState:s(u,this,j).bind(this),getAccountByAddress:s(u,this,_).bind(this),getSelectedAccount:s(u,this,v).bind(this),listAccounts:s(u,this,S).bind(this),snapOwnsAccount:t=>(0,r.snapOwnsAccount)(e,t)});return this.update(t=>{t.interfaces[i]={snapId:e,content:(0,c.castDraft)(n),state:o,context:a??null,contentType:f??null}}),i}getInterface(e,t){return s(u,this,g).call(this,e,t),this.state.interfaces[t]}updateInterface(e,t,a,f){s(u,this,g).call(this,e,t);const n=(0,l.getJsxInterface)(a);s(u,this,T).call(this,n),(0,l.validateInterfaceContext)(f);const i=this.state.interfaces[t].state,o=(0,l.constructState)(i,n,{getAssetsState:s(u,this,j).bind(this),getAccountByAddress:s(u,this,_).bind(this),getSelectedAccount:s(u,this,v).bind(this),listAccounts:s(u,this,S).bind(this),snapOwnsAccount:t=>(0,r.snapOwnsAccount)(e,t)});this.update(e=>{e.interfaces[t].state=o,e.interfaces[t].content=(0,c.castDraft)(n),f&&(e.interfaces[t].context=f)})}deleteInterface(e){this.update(t=>{delete t.interfaces[e]})}updateInterfaceState(e,t){this.update(a=>{a.interfaces[e].state=t})}async resolveInterface(e,t,a){s(u,this,g).call(this,e,t),s(u,this,k).call(this,t),await s(u,this,x).call(this,t,a),this.deleteInterface(t)}}function h(){this.messagingSystem.registerActionHandler(`${m}:createInterface`,this.createInterface.bind(this)),this.messagingSystem.registerActionHandler(`${m}:getInterface`,this.getInterface.bind(this)),this.messagingSystem.registerActionHandler(`${m}:updateInterface`,this.updateInterface.bind(this)),this.messagingSystem.registerActionHandler(`${m}:deleteInterface`,this.deleteInterface.bind(this)),this.messagingSystem.registerActionHandler(`${m}:updateInterfaceState`,this.updateInterfaceState.bind(this)),this.messagingSystem.registerActionHandler(`${m}:resolveInterface`,this.resolveInterface.bind(this))}function g(e,t){const a=this.state.interfaces[t];(0,o.assert)(a!==undefined,`Interface with id '${t}' not found.`),(0,o.assert)(a.snapId===e,`Interface not created by ${e}.`)}function k(e){(0,o.assert)(s(u,this,w).call(this,e),`Approval request with id '${e}' not found.`)}function y(e){return this.messagingSystem.call("PhishingController:testOrigin",e).result}function w(e){return this.messagingSystem.call("ApprovalController:hasRequest",{id:e})}async function x(e,t){await this.messagingSystem.call("ApprovalController:acceptRequest",e,t)}function v(){return this.messagingSystem.call("AccountsController:getSelectedMultichainAccount")}function S(e){const t=this.messagingSystem.call("AccountsController:listMultichainAccounts");return e&&0!==e.length?t.filter(t=>t.scopes.some(t=>(0,l.isMatchingChainId)(t,e))):t}function _(e){const{address:t}=(0,o.parseCaipAccountId)(e);return this.messagingSystem.call("AccountsController:getAccountByAddress",t)}function j(){return this.messagingSystem.call("MultichainAssetsController:getState")}function P(e){return this.messagingSystem.call("SnapController:get",e)}function T(e){const t=(0,r.getJsonSizeUnsafe)(e);(0,o.assert)(t<=b,"A Snap UI may not be larger than 10 MB."),(0,r.validateJsxElements)(e,{isOnPhishingList:s(u,this,y).bind(this),getSnap:s(u,this,P).bind(this),getAccountByAddress:s(u,this,_).bind(this)})}function E(e){const t=e.filter(e=>"snap"===e.type&&(0,o.hasProperty)(e.data,"detailedView")),a=new Set(t.map(e=>e.data.detailedView.interfaceId));this.update(e=>{Object.entries(e.interfaces).forEach(([t,f])=>{f.contentType!==i.ContentType.Notification||a.has(t)||delete e.interfaces[t]})})}a.SnapInterfaceController=p}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/index.cjs",{"./SnapInterfaceController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./SnapInterfaceController.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs",{"@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-sdk/jsx":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/jsx.js","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.validateInterfaceContext=a.constructState=a.getAccountSelectorStateValue=a.getAssetSelectorStateValue=a.getAccountSelectorDefaultStateValue=a.getDefaultAsset=a.formatAccountSelectorStateValue=a.isMatchingChainId=a.assertNameIsUnique=a.getJsxInterface=a.isStatefulComponent=void 0;const f=e("@metamask/snaps-sdk"),s=e("@metamask/snaps-sdk/jsx"),n=e("@metamask/snaps-utils"),i=e("@metamask/utils"),r=["Input","Dropdown","RadioGroup","FileInput","Checkbox","Selector","AssetSelector","AddressInput","AccountSelector"];function o(e){return r.includes(e.type)}function c(e,t){(0,f.assert)(e[t]===undefined,`Duplicate component names are not allowed, found multiple instances of: "${t}".`)}function d(e,t){return"eip155:0"===e?t.some(e=>{const{namespace:t}=(0,i.parseCaipChainId)(e);return t===i.KnownCaipNamespace.Eip155}):t.includes(e)}function l(e,t){const{id:a,address:f,scopes:s}=e,i=(0,n.createChainIdList)(s,t);return{accountId:a,addresses:(0,n.createAccountList)(f,i)}}function b(e,t,{getAccountByAddress:a,getAssetsState:s}){var n;const{assetsMetadata:r,accountsAssets:o}=s(),c=e.map(e=>(0,i.parseCaipAccountId)(e)).map(({chainId:e})=>e),d=t&&t.length>0?c.filter(e=>t.includes(e)):c,l=null===(n=a(e[0]))||void 0===n?void 0:n.id;(0,f.assert)(l,`Account not found for address: ${e[0]}.`);const b=o[l];if(0===b.length)return null;const m=b.find(e=>{const{chainId:t,assetNamespace:a}=(0,i.parseCaipAssetType)(e);return d.includes(t)&&"slip44"===a});return m?{asset:m,name:r[m].name,symbol:r[m].symbol}:{asset:b[0],name:r[b[0]].name,symbol:r[b[0]].symbol}}function m(e,{getSelectedAccount:t,listAccounts:a,snapOwnsAccount:f}){const{chainIds:s,hideExternalAccounts:n}=e.props,i=t();if((!s||0===s.length||i.scopes.some(e=>d(e,s)))&&(!n||n&&f(i)))return l(i,s);const r=a(s),o=n?r.filter(e=>f(e)):r;return 0===o.length?null:l(o[0],s)}function u(e,t){if(!e)return null;const{assetsMetadata:a}=t(),f=a[e];return f?{asset:e,name:f.name??f.symbol??"Unknown",symbol:f.symbol??"Unknown"}:null}function p(e,{getAccountByAddress:t,snapOwnsAccount:a}){const{value:f,hideExternalAccounts:s}=e.props;if(!f)return null;const n=t(f);return n?s&&!a(n)?null:l(n,e.props.chainIds):null}function h(e,t,a,f){const s=f?e[f]:e,r=null==s?void 0:s[t.props.name];return"FileInput"===t.type?r??null:function(e,t){switch(e.type){case"Checkbox":return e.props.checked;case"AssetSelector":return u(e.props.value,t.getAssetsState);case"AddressInput":{if(!e.props.value)return null;const{namespace:t,reference:a}=(0,i.parseCaipChainId)(e.props.chainId);return(0,i.toCaipAccountId)(t,a,e.props.value)}case"AccountSelector":return p(e,t);default:return e.props.value}}(t,a)??r??function(e,t){switch(e.type){case"Dropdown":var a;return null===(a=(0,n.getJsxChildren)(e)[0])||void 0===a?void 0:a.props.value;case"RadioGroup":var f;return null===(f=(0,n.getJsxChildren)(e)[0])||void 0===f?void 0:f.props.value;case"Selector":var s;return null===(s=(0,n.getJsxChildren)(e)[0])||void 0===s?void 0:s.props.value;case"AccountSelector":return m(e,t);case"Checkbox":return!1;case"AssetSelector":return b(e.props.addresses,e.props.chainIds,t);default:return null}}(t,a)??null}a.isStatefulComponent=o,a.getJsxInterface=function(e){return(0,s.isJSXElementUnsafe)(e)?e:(0,n.getJsxElementFromComponent)(e)},a.assertNameIsUnique=c,a.isMatchingChainId=d,a.formatAccountSelectorStateValue=l,a.getDefaultAsset=b,a.getAccountSelectorDefaultStateValue=m,a.getAssetSelectorStateValue=u,a.getAccountSelectorStateValue=p,a.constructState=function(e,t,a){const f={},s=[];return(0,n.walkJsx)(t,(t,n)=>{let i=s[s.length-1];if(i&&n<=i.depth&&(s.pop(),i=s[s.length-1]),"Form"===t.type)return c(f,t.props.name),s.push({name:t.props.name,depth:n}),void(f[t.props.name]={});if(i&&o(t)){const s=f[i.name];return c(s,t.props.name),void(s[t.props.name]=h(e,t,a,i.name))}o(t)&&(c(f,t.props.name),f[t.props.name]=h(e,t,a))}),f};const g=5e6;a.validateInterfaceContext=function(e){if(!e)return;const t=(0,n.getJsonSizeUnsafe)(e);(0,f.assert)(t<=g,"A Snap interface context may not be larger than 5 MB.")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.log=void 0;const f=e("@metamask/snaps-utils"),s=e("@metamask/utils");a.log=(0,s.createModuleLogger)(f.snapsLogger,"snaps-controllers")}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/logging.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){s(e,t),t.set(e,a)}function s(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t){return e.get(o(e,t))}function r(e,t,a){return e.set(o(e,t),a),a}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.MultichainRouter=void 0;const c=e("@metamask/rpc-errors"),d=e("@metamask/snaps-rpc-methods"),l=e("@metamask/snaps-utils"),b=e("@metamask/utils"),m=e("nanoid"),u=e("../snaps/index.cjs"),p="MultichainRouter";var h=new WeakMap,g=new WeakMap,k=new WeakSet;async function y(e,t,a){try{const f=await i(g,this).call(this,async({keyring:f})=>f.resolveAccountAddress(e,t,a)),s=null==f?void 0:f.address;return s?(0,b.parseCaipAccountId)(s).address:null}catch{throw c.rpcErrors.internal()}}async function w(e,t,a){const f=i(h,this).call("AccountsController:listMultichainAccounts",t).filter(e=>{var t;return Boolean(null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled)&&e.methods.includes(a.method)});if(0===f.length)return null;const s=f[0].metadata.snap.id,n=await o(k,this,y).call(this,s,t,a),r=e.map(e=>(0,b.parseCaipAccountId)(e).address),d=f.find(e=>r.includes(e.address)&&(!n||e.address===n));if(!d)throw c.rpcErrors.invalidParams({message:"No available account found for request."});return d.id}function x(e){const t=i(h,this).call("SnapController:getAll");return(0,u.getRunnableSnaps)(t).reduce((t,a)=>{const f=i(h,this).call("PermissionController:getPermissions",a.id);if(f&&(0,b.hasProperty)(f,d.SnapEndowments.Protocol)){const s=f[d.SnapEndowments.Protocol],n=(0,d.getProtocolCaveatScopes)(s);n&&(0,b.hasProperty)(n,e)&&t.push({snapId:a.id,methods:n[e].methods})}return t},[])}function v(e){return i(h,this).call("AccountsController:listMultichainAccounts",e).filter(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})}a.MultichainRouter=class{constructor({messenger:e,withSnapKeyring:t}){var a,o;s(a=this,o=k),o.add(a),n(this,"name",p),n(this,"state",null),f(this,h,void 0),f(this,g,void 0),r(h,this,e),r(g,this,t),i(h,this).registerActionHandler(`${p}:handleRequest`,async(...e)=>this.handleRequest(...e)),i(h,this).registerActionHandler(`${p}:getSupportedMethods`,(...e)=>this.getSupportedMethods(...e)),i(h,this).registerActionHandler(`${p}:getSupportedAccounts`,(...e)=>this.getSupportedAccounts(...e)),i(h,this).registerActionHandler(`${p}:isSupportedScope`,(...e)=>this.isSupportedScope(...e))}async handleRequest({connectedAddresses:e,origin:t,scope:a,request:f}){(0,b.assert)(!a.startsWith(b.KnownCaipNamespace.Eip155)&&!a.startsWith("wallet:eip155"));const s={jsonrpc:"2.0",id:f.id??(0,m.nanoid)(),method:f.method,...f.params?{params:f.params}:{}},{method:n,params:r}=s,d=await o(k,this,w).call(this,e,a,s);if(d)return i(g,this).call(this,async({keyring:e})=>e.submitRequest({origin:t,account:d,scope:a,method:n,params:r}));const u=o(k,this,x).call(this,a).find(e=>e.methods.includes(n));if(u)return i(h,this).call("SnapController:handleRequest",{snapId:u.snapId,origin:t,request:{method:"",params:{request:s,scope:a}},handler:l.HandlerType.OnProtocolRequest});throw c.rpcErrors.methodNotFound()}getSupportedMethods(e){const t=o(k,this,v).call(this,e).flatMap(e=>e.methods),a=o(k,this,x).call(this,e).flatMap(e=>e.methods);return Array.from(new Set([...t,...a]))}getSupportedAccounts(e){return o(k,this,v).call(this,e).map(t=>`${e}:${t.address}`)}isSupportedScope(e){return i(h,this).call("AccountsController:listMultichainAccounts",e).some(e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled})||o(k,this,x).call(this,e).length>0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs",{"./MultichainRouter.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./MultichainRouter.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs",{"../logging.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs","../snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/json-rpc-middleware-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs","@metamask/object-multiplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/object-multiplex/dist/index.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){s(e,t),t.set(e,a)}function s(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t){return e.get(o(e,t))}function r(e,t,a){return e.set(o(e,t),a),a}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}var c=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.setupMultiplex=a.AbstractExecutionService=void 0;const d=e("@metamask/json-rpc-engine"),l=e("@metamask/json-rpc-middleware-stream"),b=c(e("@metamask/object-multiplex")),m=e("@metamask/rpc-errors"),u=e("@metamask/snaps-utils"),p=e("@metamask/utils"),h=e("nanoid"),g=e("readable-stream"),k=e("../logging.cjs"),y=e("../snaps/Timer.cjs"),w=e("../utils.cjs"),x="ExecutionService";var v=new WeakMap,S=new WeakMap,_=new WeakMap,j=new WeakMap,P=new WeakMap,T=new WeakMap,E=new WeakMap,O=new WeakMap,M=new WeakSet;function I(){i(j,this).registerActionHandler(`${x}:handleRpcRequest`,async(e,t)=>this.handleRpcRequest(e,t)),i(j,this).registerActionHandler(`${x}:executeSnap`,async e=>this.executeSnap(e)),i(j,this).registerActionHandler(`${x}:terminateSnap`,async e=>this.terminateSnap(e)),i(j,this).registerActionHandler(`${x}:terminateAllSnaps`,async()=>this.terminateAllSnaps())}async function C(e,t){const{streams:a,worker:f}=await o(M,this,A).call(this,e,t),s=new d.JsonRpcEngine,n=(0,l.createStreamMiddleware)();(0,g.pipeline)(n.stream,a.command,n.stream,e=>{var t;!e||null!==(t=e.message)&&void 0!==t&&t.match("Premature close")||(0,u.logError)("Command stream failure.",e)}),s.push(n.middleware);const r={id:e,streams:a,rpcEngine:s,worker:f};return i(v,this).set(e,r),r}async function A(e,t){const a=await(0,w.withTimeout)(this.initEnvStream(e),t);if(a===w.hasTimedOut){this.terminateJob({id:e});if("created"===i(S,this).get(e))throw new Error(`The executor for "${e}" couldn't start initialization. The offscreen document may not exist.`);throw new Error(`The executor for "${e}" failed to initialize. The iframe/webview/worker failed to load.`)}const{worker:f,stream:s}=a,n=$(s,`Snap: "${e}"`),r=n.createStream(u.SNAP_STREAM_NAMES.COMMAND),o=t=>{(0,p.hasProperty)(t,"id")||("OutboundRequest"===t.method?i(j,this).publish("ExecutionService:outboundRequest",e):"OutboundResponse"===t.method?i(j,this).publish("ExecutionService:outboundResponse",e):"UnhandledError"===t.method?(i(j,this).publish("ExecutionService:unhandledError",e,t.params.error),r.removeListener("data",o)):(0,u.logError)(new Error(`Received unexpected command stream notification "${t.method}".`)))};r.on("data",o);const c=n.createStream(u.SNAP_STREAM_NAMES.JSON_RPC);c.on("data",t=>{null!=t&&t.data&&(0,p.hasProperty)(null==t?void 0:t.data,"id")&&i(j,this).publish("ExecutionService:outboundRequest",e)});const d=c.write.bind(c);return c.write=(t,a,f)=>{var s;return"metamask_chainChanged"===(null==t||null===(s=t.data)||void 0===s?void 0:s.method)||(null!=t&&t.data&&(0,p.hasProperty)(null==t?void 0:t.data,"id")&&i(j,this).publish("ExecutionService:outboundResponse",e),d(t,a,f))},{streams:{command:r,rpc:c,_connection:s},worker:f}}async function R(e,t){const a=i(v,this).get(e);if(!a)throw new Error(`"${e}" is not currently running.`);(0,k.log)("Parent: Sending Command",t);const f=await a.rpcEngine.handle(t);if((0,p.hasProperty)(f,"error")){const e=f.error;throw new m.JsonRpcError(e.code,e.message,e.data)}return f.result}function $(e,t){const a=new b.default;return(0,g.pipeline)(e,a,e,e=>{var a;!e||null!==(a=e.message)&&void 0!==a&&a.match("Premature close")||(0,u.logError)(`"${t}" stream failure.`,e)}),a}a.AbstractExecutionService=class{constructor({setupSnapProvider:e,messenger:t,initTimeout:a=(0,p.inMilliseconds)(60,p.Duration.Second),pingTimeout:i=(0,p.inMilliseconds)(2,p.Duration.Second),terminationTimeout:c=(0,p.inMilliseconds)(1,p.Duration.Second),usePing:d=!0}){var l,b;s(l=this,b=M),b.add(l),n(this,"name",x),n(this,"state",null),f(this,v,void 0),f(this,S,void 0),f(this,_,void 0),f(this,j,void 0),f(this,P,void 0),f(this,T,void 0),f(this,E,void 0),f(this,O,void 0),r(v,this,new Map),r(S,this,new Map),r(_,this,e),r(j,this,t),r(P,this,a),r(T,this,i),r(E,this,c),r(O,this,d),o(M,this,I).call(this)}async terminateSnap(e){const t=i(v,this).get(e);if(t){try{const t=await(0,w.withTimeout)(o(M,this,R).call(this,e,{jsonrpc:"2.0",method:"terminate",params:[],id:(0,h.nanoid)()}),i(E,this));t!==w.hasTimedOut&&"OK"===t||(0,u.logWarning)(`Snap "${e}" failed to terminate gracefully.`)}catch{}Object.values(t.streams).forEach(e=>{try{e.destroyed||e.destroy()}catch(e){(0,u.logError)("Error while destroying stream",e)}}),this.terminateJob(t),i(v,this).delete(e),i(S,this).delete(e),(0,k.log)(`Snap "${e}" terminated.`)}}setSnapStatus(e,t){i(S,this).set(e,t)}async terminateAllSnaps(){await Promise.all([...i(v,this).keys()].map(async e=>this.terminateSnap(e)))}async executeSnap({snapId:e,sourceCode:t,endowments:a}){if(i(v,this).has(e))throw new Error(`"${e}" is already running.`);this.setSnapStatus(e,"created");const f=new y.Timer(i(P,this)),s=await o(M,this,C).call(this,e,f);if(i(O,this)){if(await(0,w.withTimeout)(o(M,this,R).call(this,s.id,{jsonrpc:"2.0",method:"ping",id:(0,h.nanoid)()}),i(T,this))===w.hasTimedOut)throw new Error(`The executor for "${e}" was unreachable. The executor did not respond in time.`)}const n=s.streams.rpc;i(_,this).call(this,e,n);const r=Math.max(f.remaining,i(P,this)/2);this.setSnapStatus(e,"initialized");const c={jsonrpc:"2.0",method:"executeSnap",params:{snapId:e,sourceCode:t,endowments:a},id:(0,h.nanoid)()};(0,p.assertIsJsonRpcRequest)(c),this.setSnapStatus(e,"executing");const d=await(0,w.withTimeout)(o(M,this,R).call(this,s.id,c),r);if(d===w.hasTimedOut)throw new Error(`${e} failed to start.`);return"OK"===d&&this.setSnapStatus(e,"running"),d}async handleRpcRequest(e,t){const{handler:a,request:f,origin:s}=t;return await o(M,this,R).call(this,e,{id:(0,h.nanoid)(),jsonrpc:"2.0",method:"snapRpc",params:{origin:s,handler:a,request:f,target:e}})}},a.setupMultiplex=$}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs",{"@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){s(e,t),t.set(e,a)}function s(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function n(e,t){return e.get(r(e,t))}function i(e,t,a){return e.set(r(e,t),a),a}function r(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.ProxyPostMessageStream=void 0;const o=e("@metamask/post-message-stream");var c=new WeakMap,d=new WeakMap,l=new WeakSet;class b extends o.BasePostMessageStream{constructor({stream:e,jobId:t}){var a,o;super(),s(a=this,o=l),o.add(a),f(this,c,void 0),f(this,d,void 0),i(c,this,e),i(d,this,t),n(c,this).on("data",r(l,this,m).bind(this))}_postMessage(e){n(c,this).write({jobId:n(d,this),data:e})}}function m(e){e.jobId===n(d,this)&&this.push(e.data)}a.ProxyPostMessageStream=b}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs",{"../AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}Object.defineProperty(a,"__esModule",{value:!0}),a.IframeExecutionService=void 0;const s=e("@metamask/post-message-stream"),n=e("@metamask/snaps-utils"),i=e("../AbstractExecutionService.cjs");class r extends i.AbstractExecutionService{constructor({iframeUrl:e,messenger:t,setupSnapProvider:a,...s}){super({...s,messenger:t,setupSnapProvider:a}),f(this,"iframeUrl",void 0),this.iframeUrl=e}terminateJob(e){var t;null===(t=document.getElementById(e.id))||void 0===t||t.remove()}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=await(0,n.createWindow)({uri:this.iframeUrl.toString(),id:e});return{worker:t,stream:new s.WindowPostMessageStream({name:"parent",target:"child",targetWindow:t,targetOrigin:"*"})}}}a.IframeExecutionService=r}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs",{"./IframeExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./IframeExecutionService.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/index.cjs",{"./AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","./ProxyPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs","./iframe/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs","./offscreen/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./AbstractExecutionService.cjs"),a),s(e("./ProxyPostMessageStream.cjs"),a),s(e("./iframe/index.cjs"),a),s(e("./offscreen/index.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs",{"../proxy/ProxyExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs","@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function s(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.OffscreenExecutionService=void 0;const n=e("@metamask/post-message-stream"),i=e("../proxy/ProxyExecutionService.cjs");var r=new WeakMap;class o extends i.ProxyExecutionService{constructor({messenger:e,setupSnapProvider:t,offscreenPromise:a,...i}){var o,c,d;super({...i,messenger:e,setupSnapProvider:t,stream:new n.BrowserRuntimePostMessageStream({name:"parent",target:"child"})}),f(this,r,void 0),c=this,d=a,(o=r).set(s(o,c),d)}async initEnvStream(e){var t,a;return await(t=r,a=this,t.get(s(t,a))),await super.initEnvStream(e)}}a.OffscreenExecutionService=o}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs",{"./OffscreenExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./OffscreenExecutionService.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs",{"../AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","../ProxyPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function s(e,t){return e.get(n(e,t))}function n(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.ProxyExecutionService=void 0;const i=e("nanoid"),r=e("../AbstractExecutionService.cjs"),o=e("../ProxyPostMessageStream.cjs");var c=new WeakMap;class d extends r.AbstractExecutionService{constructor({stream:e,messenger:t,setupSnapProvider:a,...s}){var i,r,o;super({...s,messenger:t,setupSnapProvider:a,usePing:!1}),f(this,c,void 0),r=this,o=e,(i=c).set(n(i,r),o)}async terminateJob(e){s(c,this).write({jobId:e.id,data:{jsonrpc:"2.0",method:"terminateJob",id:(0,i.nanoid)()}})}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=new o.ProxyPostMessageStream({stream:s(c,this),jobId:e});return await new Promise(e=>{t.once("data",e),t.write({name:"command",data:{jsonrpc:"2.0",method:"ping",id:(0,i.nanoid)()}})}),{worker:e,stream:t}}}a.ProxyExecutionService=d}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs",{"../fsm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/fsm.cjs","../logging.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","./Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./location/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs","./registry/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs","@metamask/approval-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/approval-controller/dist/index.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/permission-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-controller/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@xstate/fsm":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@xstate/fsm/lib/index.js","async-mutex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/async-mutex/lib/index.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs",semver:"/home/runner/work/metamask-extension/metamask-extension/node_modules/semver/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function s(e,t,a){n(e,t),t.set(e,a)}function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t){return e.get(o(e,t))}function r(e,t,a){return e.set(o(e,t),a),a}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.SnapController=a.SNAP_APPROVAL_RESULT=a.SNAP_APPROVAL_UPDATE=a.SNAP_APPROVAL_INSTALL=a.controllerName=void 0;const c=e("@metamask/approval-controller"),d=e("@metamask/base-controller"),l=e("@metamask/permission-controller"),b=e("@metamask/rpc-errors"),m=e("@metamask/snaps-rpc-methods"),u=e("@metamask/snaps-sdk"),p=e("@metamask/snaps-utils"),h=e("@metamask/utils"),g=e("@xstate/fsm"),k=e("async-mutex"),y=e("nanoid"),w=e("semver"),x=e("./constants.cjs"),v=e("./location/index.cjs"),S=e("./registry/index.cjs"),_=e("./selectors.cjs"),j=e("./Timer.cjs"),P=e("../fsm.cjs"),T=e("../logging.cjs"),E=e("../utils.cjs");a.controllerName="SnapController",a.SNAP_APPROVAL_INSTALL="wallet_installSnap",a.SNAP_APPROVAL_UPDATE="wallet_updateSnap",a.SNAP_APPROVAL_RESULT="wallet_installSnapResult";const O=new Set(["initialPermissions","id","version","enabled","blocked"]),M={snaps:{},snapStates:{},unencryptedSnapStates:{}};function I(e){return Object.keys(e).reduce((t,a)=>(O.has(a)&&(t[a]=e[a]),t),{})}var C=new WeakMap,A=new WeakMap,R=new WeakMap,$=new WeakMap,N=new WeakMap,L=new WeakMap,D=new WeakMap,F=new WeakMap,B=new WeakMap,U=new WeakMap,q=new WeakMap,H=new WeakMap,V=new WeakMap,G=new WeakMap,W=new WeakMap,K=new WeakMap,z=new WeakMap,J=new WeakMap,Y=new WeakMap,Z=new WeakMap,X=new WeakSet,Q=new WeakMap;class ee extends d.BaseController{constructor({closeAllConnections:e,messenger:t,state:c,dynamicPermissions:d=["eth_accounts"],environmentEndowmentPermissions:l=[],excludedPermissions:b={},idleTimeCheckInterval:m=(0,h.inMilliseconds)(5,h.Duration.Second),maxIdleTime:g=(0,h.inMilliseconds)(30,h.Duration.Second),maxRequestTime:k=(0,h.inMilliseconds)(60,h.Duration.Second),fetchFunction:y=globalThis.fetch.bind(undefined),featureFlags:w={},detectSnapLocation:S=v.detectSnapLocation,preinstalledSnaps:_=null,encryptor:j,getMnemonicSeed:P,getFeatureFlags:T=()=>({}),clientCryptography:O,trackEvent:I}){var ee,ne,ie;super({messenger:t,metadata:{snapStates:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1},unencryptedSnapStates:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1},snaps:{includeInStateLogs:e=>Object.values(e).reduce((e,t)=>{const a={...t};return delete a.sourceCode,delete a.auxiliaryFiles,e[t.id]=a,e},{}),persist:e=>Object.values(e).filter(e=>e.status!==p.SnapStatus.Installing).map(e=>({...e,status:p.SnapStatus.Stopped})).reduce((e,t)=>(e[t.id]=t,e),{}),anonymous:!1,usedInUi:!0}},name:a.controllerName,state:{...M,...c}}),n(ne=this,ie=X),ie.add(ne),s(this,C,void 0),s(this,A,void 0),s(this,R,void 0),s(this,$,void 0),s(this,N,void 0),s(this,L,void 0),s(this,D,void 0),s(this,F,void 0),f(this,"maxRequestTime",void 0),s(this,B,void 0),s(this,U,void 0),s(this,q,void 0),s(this,H,void 0),s(this,V,void 0),s(this,G,void 0),s(this,W,void 0),s(this,K,void 0),s(this,z,void 0),s(this,J,void 0),s(this,Y,void 0),s(this,Z,void 0),s(this,Q,(0,E.debouncePersistState)((e,t,a)=>{o(X,this,Ye).call(this,e).stateMutex.runExclusive(async()=>{const f=await o(X,this,ge).call(this,e,t,a);return a?this.update(t=>{t.snapStates[e]=f}):this.update(t=>{t.unencryptedSnapStates[e]=f})}).catch(p.logError)},x.STATE_DEBOUNCE_TIMEOUT)),r(C,this,e),r(A,this,d),r(R,this,l),r($,this,b),r(N,this,w),r(L,this,y),r(D,this,m),r(F,this,g),this.maxRequestTime=k,r(V,this,S),r(B,this,j),r(U,this,P),r(q,this,T),r(H,this,O),r(J,this,_),this._onUnhandledSnapError=this._onUnhandledSnapError.bind(this),this._onOutboundRequest=this._onOutboundRequest.bind(this),this._onOutboundResponse=this._onOutboundResponse.bind(this),r(W,this,new Map),r(G,this,new Map),r(Y,this,I),o(X,this,se).call(this),this.messagingSystem.subscribe("ExecutionService:unhandledError",this._onUnhandledSnapError),this.messagingSystem.subscribe("ExecutionService:outboundRequest",this._onOutboundRequest),this.messagingSystem.subscribe("ExecutionService:outboundResponse",this._onOutboundResponse),this.messagingSystem.subscribe("SnapController:snapInstalled",({id:e},t)=>{o(X,this,nt).call(this,t,e,p.HandlerType.OnInstall).catch(t=>{(0,p.logError)(`Error when calling \`onInstall\` lifecycle hook for snap "${e}": ${(0,u.getErrorMessage)(t)}`)})}),this.messagingSystem.subscribe("SnapController:snapUpdated",({id:e},t,a)=>{o(X,this,nt).call(this,a,e,p.HandlerType.OnUpdate).catch(t=>{(0,p.logError)(`Error when calling \`onUpdate\` lifecycle hook for snap "${e}": ${(0,u.getErrorMessage)(t)}`)})}),this.messagingSystem.subscribe("KeyringController:lock",o(X,this,it).bind(this)),o(X,this,te).call(this),o(X,this,ae).call(this),Object.values((null===(ee=this.state)||void 0===ee?void 0:ee.snaps)??{}).forEach(e=>o(X,this,Ze).call(this,e.id)),i(J,this)&&o(X,this,fe).call(this,i(J,this)),r(Z,this,(0,E.throttleTracking)((e,t,a,f)=>{const s=this.messagingSystem.call("SnapsRegistry:getMetadata",e);i(Y,this).call(this,{event:"Snap Export Used",category:"Snaps",properties:{snap_id:e,export:t,snap_category:null==s?void 0:s.category,success:a,origin:f}})}))}init(){o(X,this,st).call(this,x.METAMASK_ORIGIN,p.HandlerType.OnStart)}async updateRegistry(){o(X,this,ce).call(this),await this.messagingSystem.call("SnapsRegistry:update");const e=await this.messagingSystem.call("SnapsRegistry:get",Object.values(this.state.snaps).reduce((e,t)=>(e[t.id]={version:t.version,checksum:t.manifest.source.shasum},e),{}));if(await Promise.all(Object.entries(e).map(async([e,{status:t,reason:a}])=>t===S.SnapsRegistryStatus.Blocked?o(X,this,ne).call(this,e,a):o(X,this,ie).call(this,e))),!i(N,this).autoUpdatePreinstalledSnaps)return;await Promise.allSettled(Object.values(this.state.snaps).filter(e=>e.preinstalled).map(async e=>{const t=await o(X,this,Pe).call(this,e.id,"*");if("*"!==t&&(0,h.gtVersion)(t,e.version)){const a=i(V,this).call(this,e.id,{versionRange:t,fetch:i(L,this),allowLocal:!1});await o(X,this,je).call(this,{origin:c.ORIGIN_METAMASK,snapId:e.id,location:a,versionRange:t,automaticUpdate:!0})}}))}_onUnhandledSnapError(e,t){(0,p.logError)(`Unhandled error from "${e}":`,t),this.stopSnap(e,p.SnapStatusEvents.Crash).catch(e=>{(0,p.logError)(e)})}_onOutboundRequest(e){const t=o(X,this,Ye).call(this,e);t.pendingInboundRequests.filter(e=>"running"===e.timer.status).forEach(e=>e.timer.pause()),t.pendingOutboundRequests+=1}_onOutboundResponse(e){const t=o(X,this,Ye).call(this,e);t.pendingOutboundRequests-=1,0===t.pendingOutboundRequests&&t.pendingInboundRequests.filter(e=>"paused"===e.timer.status).forEach(e=>e.timer.resume())}async startSnap(e){o(X,this,ce).call(this);const t=this.state.snaps[e];if(!t.enabled)throw new Error(`Snap "${e}" is disabled.`);await o(X,this,Ee).call(this,{snapId:e,sourceCode:t.sourceCode})}enableSnap(e){if(this.getExpect(e),this.state.snaps[e].blocked)throw new Error(`Snap "${e}" is blocked and cannot be enabled.`);this.update(t=>{t.snaps[e].enabled=!0}),this.messagingSystem.publish("SnapController:snapEnabled",this.getTruncatedExpect(e))}async disableSnap(e){if(!this.has(e))throw new Error(`Snap "${e}" not found.`);this.update(t=>{t.snaps[e].enabled=!1}),this.isRunning(e)&&await this.stopSnap(e,p.SnapStatusEvents.Stop),this.messagingSystem.publish("SnapController:snapDisabled",this.getTruncatedExpect(e))}async stopSnap(e,t=p.SnapStatusEvents.Stop){const a=o(X,this,Je).call(this,e);if(!a)throw new Error(`The snap "${e}" is not running.`);if(a.stopPromise)return void await a.stopPromise;const{promise:f,resolve:s}=(0,h.createDeferredPromise)();a.stopPromise=f;try{var n;if(this.isRunning(e))null===(n=i(C,this))||void 0===n||n.call(this,e),await o(X,this,be).call(this,e)}finally{a.lastRequest=null,a.pendingInboundRequests=[],a.pendingOutboundRequests=0,a.stopPromise=null,this.isRunning(e)&&o(X,this,le).call(this,e,t),s()}}async stopAllSnaps(e=p.SnapStatusEvents.Stop){const t=Object.values(this.state.snaps).filter(e=>this.isRunning(e.id)).map(async t=>this.stopSnap(t.id,e));await Promise.allSettled(t)}isRunning(e){return"running"===this.getExpect(e).status}has(e){return Boolean(this.get(e))}get(e){return this.state.snaps[e]}getExpect(e){const t=this.get(e);return(0,h.assert)(t!==undefined,`Snap "${e}" not found.`),t}getTruncated(e){const t=this.get(e);return t?I(t):null}getTruncatedExpect(e){return I(this.getExpect(e))}async updateSnapState(e,t,a){const f=o(X,this,Ye).call(this,e);a?f.state=t:f.unencryptedState=t,i(Q,this).call(this,e,t,a)}clearSnapState(e,t){const a=o(X,this,Ye).call(this,e);t?a.state=null:a.unencryptedState=null,i(Q,this).call(this,e,null,t)}async getSnapState(e,t){const a=o(X,this,Ye).call(this,e);return await a.getStateMutex.runExclusive(async()=>{const f=t?a.state:a.unencryptedState;if(f!==undefined)return f;const s=t?this.state.snapStates[e]:this.state.unencryptedSnapStates[e];if(null===s||s===undefined)return null;if(!t){const e=JSON.parse(s);return a.unencryptedState=e,e}const n=await o(X,this,pe).call(this,e,s);return a.state=n,n})}async getSnapFile(e,t,a=u.AuxiliaryFileEncoding.Base64){var f;const s=this.getExpect(e),n=(0,p.normalizeRelative)(t),i=null===(f=s.auxiliaryFiles)||void 0===f||null===(f=f.find(e=>e.path===n))||void 0===f?void 0:f.value;if(!i)return null;const r=await(0,p.encodeAuxiliaryFile)(i,a);return(0,h.assert)(r.length<p.MAX_FILE_SIZE,`Failed to encode static file to "${a}": Static files must be less than 64 MB when encoded.`),r}isMinimumPlatformVersion(e,t){const a=this.getExpect(e),{platformVersion:f}=a.manifest;return!!f&&(0,w.gte)(f,t)}async clearState(){const e=Object.keys(this.state.snaps);await this.stopAllSnaps(),e.forEach(e=>o(X,this,xe).call(this,e)),this.update(e=>{e.snaps={},e.snapStates={},e.unencryptedSnapStates={}}),i(G,this).clear(),i(W,this).clear(),i(J,this)&&o(X,this,fe).call(this,i(J,this))}async removeSnap(e){return this.removeSnaps([e])}async removeSnaps(e){if(!Array.isArray(e))throw new Error("Expected array of snap ids.");e.forEach(e=>{const t=this.getExpect(e);(0,h.assert)(!1!==t.removable,`${e} is not removable.`)}),await Promise.all(e.map(async e=>{const t=this.getExpect(e),a=this.getTruncatedExpect(e);await this.disableSnap(e),o(X,this,xe).call(this,e),o(X,this,we).call(this,e),i(G,this).delete(e),this.update(t=>{delete t.snaps[e],delete t.snapStates[e],delete t.unencryptedSnapStates[e]}),t.status!==p.SnapStatus.Installing&&this.messagingSystem.publish("SnapController:snapUninstalled",a)}))}removeSnapFromSubject(e,t){var a,f;const s=this.messagingSystem.call("PermissionController:getPermissions",e),n=null==s||null===(a=s[m.WALLET_SNAP_PERMISSION_KEY])||void 0===a||null===(a=a.caveats)||void 0===a?void 0:a.find(e=>e.type===p.SnapCaveatType.SnapIds);if(!n)return;if(Boolean(null===(f=n.value)||void 0===f?void 0:f[t])){const a={...n.value};delete a[t],Object.keys(a).length>0?this.messagingSystem.call("PermissionController:updateCaveat",e,m.WALLET_SNAP_PERMISSION_KEY,p.SnapCaveatType.SnapIds,a):this.messagingSystem.call("PermissionController:revokePermissions",{[e]:[m.WALLET_SNAP_PERMISSION_KEY]})}}revokeDynamicSnapPermissions(e,t){(0,h.assert)(t.every(e=>i(A,this).includes(e)),"Non-dynamic permissions cannot be revoked"),this.messagingSystem.call("PermissionController:revokePermissions",{[e]:t})}incrementActiveReferences(e){o(X,this,Ye).call(this,e).activeReferences+=1}decrementActiveReferences(e){const t=o(X,this,Ye).call(this,e);(0,h.assert)(t.activeReferences>0,"SnapController reference management is in an invalid state."),t.activeReferences-=1}getAllSnaps(){return Object.values(this.state.snaps).map(I)}getRunnableSnaps(){return(0,_.getRunnableSnaps)(this.getAllSnaps())}getPermittedSnaps(e){var t;const a=(null===(t=(this.messagingSystem.call("PermissionController:getPermissions",e)??{})[m.WALLET_SNAP_PERMISSION_KEY])||void 0===t||null===(t=t.caveats)||void 0===t||null===(t=t.find(e=>e.type===p.SnapCaveatType.SnapIds))||void 0===t?void 0:t.value)??{};return Object.keys(a).reduce((e,t)=>{const a=this.get(t),f=this.getTruncated(t);return f&&(null==a?void 0:a.status)!==p.SnapStatus.Installing&&(e[t]=f),e},{})}async installSnaps(e,t){o(X,this,ce).call(this);const a={},f=Object.keys(t),s=[],n=[];try{for(const[f,{version:r}]of Object.entries(t)){(0,p.assertIsValidSnapId)(f);const[t,c]=(0,p.resolveVersionRange)(r);if(t)throw b.rpcErrors.invalidParams(`The "version" field must be a valid SemVer version range if specified. Received: "${r}".`);const d=i(V,this).call(this,f,{versionRange:c,fetch:i(L,this),allowLocal:i(N,this).allowLocalSnaps,resolveVersion:async e=>i(N,this).requireAllowlist?await o(X,this,Pe).call(this,f,e):e}),l=this.has(f)&&!d.shouldAlwaysReload;if(l&&o(X,this,ft).call(this,f,c)){const e=this.getExpect(f);s.push({snapId:f,oldVersion:e.version});let t=o(X,this,Ge).call(this,f);if(t!==undefined)throw new Error("This snap is already being updated.");t=o(X,this,We).call(this,f),t.newVersion=c}else l||n.push(f);a[f]=await o(X,this,ve).call(this,e,f,d,c)}n.forEach(t=>this.messagingSystem.publish("SnapController:snapInstalled",this.getTruncatedExpect(t),e,!1)),s.forEach(({snapId:t,oldVersion:a})=>this.messagingSystem.publish("SnapController:snapUpdated",this.getTruncatedExpect(t),a,e,!1)),f.forEach(e=>i(W,this).delete(e))}catch(e){const t=n.filter(e=>this.has(e));await this.removeSnaps(t);const a=[...i(W,this).keys()],f=s.map(({snapId:e})=>e).filter(e=>a.includes(e));throw await o(X,this,ze).call(this,f),e}return a}destroy(){super.destroy(),i(K,this)&&clearTimeout(i(K,this)),this.messagingSystem.unsubscribe("ExecutionService:unhandledError",this._onUnhandledSnapError),this.messagingSystem.unsubscribe("ExecutionService:outboundRequest",this._onOutboundRequest),this.messagingSystem.unsubscribe("ExecutionService:outboundResponse",this._onOutboundResponse),this.messagingSystem.clearEventSubscriptions("SnapController:snapInstalled"),this.messagingSystem.clearEventSubscriptions("SnapController:snapUpdated")}async handleRequest({snapId:e,origin:t,handler:a,request:f}){o(X,this,ce).call(this),(0,h.assert)(t===x.METAMASK_ORIGIN||(0,p.isValidUrl)(t),"'origin' must be a valid URL or 'metamask'.");const s={jsonrpc:"2.0",id:(0,y.nanoid)(),...f};(0,h.assertIsJsonRpcRequest)(s);const n=m.handlerEndowments[a];(0,h.assert)("string"==typeof n||null===n,"'permissionName' must be either a string or null.");const i=this.messagingSystem.call("PermissionController:getPermissions",e);if(!(null===n||i&&(0,h.hasProperty)(i,n)))throw new Error(`Snap "${e}" is not permitted to use "${n}".`);const r=n?i[n]:undefined;if(n===m.SnapEndowments.Rpc||n===m.SnapEndowments.Keyring){(0,h.assert)(r);const a=this.messagingSystem.call("SubjectMetadataController:getSubjectMetadata",t),f=n===m.SnapEndowments.Rpc?(0,m.getRpcCaveatOrigins)(r):(0,m.getKeyringCaveatOrigins)(r);if((0,h.assert)(f),!(0,p.isOriginAllowed)(f,(null==a?void 0:a.subjectType)??l.SubjectType.Website,t))throw new Error(`Snap "${e}" is not permitted to handle requests from "${t}".`)}if(t!==x.METAMASK_ORIGIN&&x.CLIENT_ONLY_HANDLERS.includes(a))throw new Error(`"${a}" can only be invoked by MetaMask.`);if(!this.state.snaps[e].enabled)throw new Error(`Snap "${e}" is disabled.`);if(this.state.snaps[e].status===p.SnapStatus.Installing)throw new Error(`Snap "${e}" is currently being installed. Please try again later.`);const c=o(X,this,Re).call(this,r),d=o(X,this,Ye).call(this,e);if(d.stopPromise&&await d.stopPromise,!this.isRunning(e)){d.startPromise||(d.startPromise=this.startSnap(e));try{await d.startPromise}finally{d.startPromise=null}}const b=o(X,this,Ue).call(this,e,a,s),u=new j.Timer(c);o(X,this,He).call(this,e,b.id,u);const g=this.messagingSystem.call("ExecutionService:handleRpcRequest",e,{origin:t,handler:a,request:b});try{const f=await(0,E.withTimeout)(g,u);if(f===E.hasTimedOut){const t=null!==d.stopPromise||!this.isRunning(e);throw new Error(t?`${e} was stopped and the request was cancelled. This is likely because the Snap crashed.`:`${e} failed to respond to the request in time.`)}await o(X,this,qe).call(this,e,a,f);const s=await o(X,this,Le).call(this,e,a,b,f);return o(X,this,Ve).call(this,e,b.id,a,t,!0),s}catch(f){o(X,this,Ve).call(this,e,b.id,a,t,!1);const[s,n]=(0,p.unwrapError)(f),i=null!==d.stopPromise||!this.isRunning(e);throw n||(i||(0,p.logError)(`"${e}" crashed due to an unhandled error:`,s),await this.stopSnap(e,p.SnapStatusEvents.Crash)),s}}setClientActive(e){e?o(X,this,st).call(this,x.METAMASK_ORIGIN,p.HandlerType.OnActive):o(X,this,st).call(this,x.METAMASK_ORIGIN,p.HandlerType.OnInactive)}}function te(){const e=({snapId:e})=>this.getExpect(e).enabled,t={initial:p.SnapStatus.Installing,states:{[p.SnapStatus.Installing]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e}}},[p.SnapStatus.Updating]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e},[p.SnapStatusEvents.Stop]:p.SnapStatus.Stopped}},[p.SnapStatus.Running]:{on:{[p.SnapStatusEvents.Stop]:p.SnapStatus.Stopped,[p.SnapStatusEvents.Crash]:p.SnapStatus.Crashed}},[p.SnapStatus.Stopped]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e},[p.SnapStatusEvents.Update]:p.SnapStatus.Updating}},[p.SnapStatus.Crashed]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e},[p.SnapStatusEvents.Update]:p.SnapStatus.Updating}}}};r(z,this,(0,g.createMachine)(t)),(0,P.validateMachine)(i(z,this))}function ae(){this.messagingSystem.registerActionHandler(`${a.controllerName}:init`,(...e)=>this.init(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:clearSnapState`,(...e)=>this.clearSnapState(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:get`,(...e)=>this.get(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:getSnapState`,async(...e)=>this.getSnapState(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:handleRequest`,async(...e)=>this.handleRequest(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:has`,(...e)=>this.has(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:updateRegistry`,async()=>this.updateRegistry()),this.messagingSystem.registerActionHandler(`${a.controllerName}:updateSnapState`,async(...e)=>this.updateSnapState(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:enable`,(...e)=>this.enableSnap(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:disable`,async(...e)=>this.disableSnap(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:remove`,async(...e)=>this.removeSnap(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:getPermitted`,(...e)=>this.getPermittedSnaps(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:install`,async(...e)=>this.installSnaps(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:getAll`,(...e)=>this.getAllSnaps(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:getRunnableSnaps`,(...e)=>this.getRunnableSnaps(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:incrementActiveReferences`,(...e)=>this.incrementActiveReferences(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:decrementActiveReferences`,(...e)=>this.decrementActiveReferences(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:disconnectOrigin`,(...e)=>this.removeSnapFromSubject(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:revokeDynamicPermissions`,(...e)=>this.revokeDynamicSnapPermissions(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:getFile`,async(...e)=>this.getSnapFile(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:stopAllSnaps`,async(...e)=>this.stopAllSnaps(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:isMinimumPlatformVersion`,(...e)=>this.isMinimumPlatformVersion(...e)),this.messagingSystem.registerActionHandler(`${a.controllerName}:setClientActive`,(...e)=>this.setClientActive(...e))}function fe(e){for(const{snapId:a,manifest:f,files:s,removable:n,hidden:i,hideSnapBranding:r}of e){var t;const e=this.get(a),c=e!==undefined,d=c&&(0,h.gtVersion)(f.version,e.version);if(c&&(!d||!0!==e.preinstalled))continue;const l=new p.VirtualFile({path:p.NpmSnapFileNames.Manifest,value:JSON.stringify(f),result:f}),b=s.map(({path:e,value:t})=>new p.VirtualFile({value:t,path:e})),{filePath:u,iconPath:g}=f.source.location.npm,k=b.find(e=>e.path===u),y=g?b.find(e=>e.path===g):undefined;(0,h.assert)(k,"Source code not provided for preinstalled snap."),(0,h.assert)(!g||g&&y,"Icon not provided for preinstalled snap."),(0,h.assert)(f.source.files===undefined,"Auxiliary files are not currently supported for preinstalled snaps.");const w=(null===(t=f.source.locales)||void 0===t?void 0:t.map(e=>b.find(t=>t.path===e)))??[],v=(0,p.getValidatedLocalizationFiles)(w.filter(Boolean));(0,h.assert)(w.length===v.length,"Missing localization files for preinstalled snap.");const S={manifest:l,sourceCode:k,svgIcon:y,auxiliaryFiles:[],localizationFiles:v};o(X,this,Me).call(this,{id:a,origin:x.METAMASK_ORIGIN,files:S,removable:n,hidden:i,hideSnapBranding:r,preinstalled:!0});const _=(0,m.processSnapPermissions)(f.initialPermissions);o(X,this,Ie).call(this,_);const{newPermissions:j,unusedPermissions:P}=o(X,this,Xe).call(this,a,_);o(X,this,at).call(this,{snapId:a,newPermissions:j,unusedPermissions:P}),f.initialConnections&&o(X,this,ke).call(this,a,(null==e?void 0:e.initialConnections)??null,f.initialConnections),this.update(e=>{e.snaps[a].status=p.SnapStatus.Stopped}),o(X,this,Ze).call(this,a),d?this.messagingSystem.publish("SnapController:snapUpdated",this.getTruncatedExpect(a),e.version,x.METAMASK_ORIGIN,!0):this.messagingSystem.publish("SnapController:snapInstalled",this.getTruncatedExpect(a),x.METAMASK_ORIGIN,!0)}}function se(){r(K,this,setTimeout(()=>{o(X,this,de).call(this).catch(e=>{(0,p.logError)(e)}),o(X,this,se).call(this)},i(D,this)))}async function ne(e,t){if(this.has(e)){try{this.update(a=>{a.snaps[e].blocked=!0,a.snaps[e].blockInformation=t}),await this.disableSnap(e)}catch(t){(0,p.logError)(`Encountered error when stopping blocked snap "${e}".`,t)}this.messagingSystem.publish(`${a.controllerName}:snapBlocked`,e,t)}}function ie(e){this.has(e)&&this.state.snaps[e].blocked&&(this.update(t=>{t.snaps[e].blocked=!1,delete t.snaps[e].blockInformation}),this.messagingSystem.publish(`${a.controllerName}:snapUnblocked`,e))}async function re(e,{platformVersion:t,...a}){const f=(await this.messagingSystem.call("SnapsRegistry:get",{[e]:a}))[e];var s;if(f.status===S.SnapsRegistryStatus.Blocked)throw new Error(`Cannot install version "${a.version}" of snap "${e}": The version is blocked. ${(null===(s=f.reason)||void 0===s?void 0:s.explanation)??""}`);const n=Object.keys(a.permissions).some(e=>!x.ALLOWED_PERMISSIONS.includes(e));if(i(N,this).requireAllowlist&&n&&f.status!==S.SnapsRegistryStatus.Verified)throw new Error(`Cannot install version "${a.version}" of snap "${e}": ${f.status===S.SnapsRegistryStatus.Unavailable?"The registry is temporarily unavailable.":"The snap is not on the allowlist."}`);o(X,this,Ce).call(this,e,t)}function oe(){(0,h.assert)(!0!==i(N,this).disableSnapInstallation,"Installing Snaps is currently disabled in this version of MetaMask.")}function ce(){const e=i(q,this).call(this);(0,h.assert)(!0!==e.disableSnaps,"The Snaps platform requires basic functionality to be used. Enable basic functionality in the settings to use the Snaps platform.")}async function de(){const e=[...i(G,this).entries()];return Promise.all(e.filter(([e,t])=>0===t.activeReferences&&0===t.pendingInboundRequests.length&&t.lastRequest&&i(F,this)&&(0,h.timeSince)(t.lastRequest)>i(F,this)).map(async([e])=>this.stopSnap(e,p.SnapStatusEvents.Stop)))}function le(e,t){const{interpreter:a}=o(X,this,Ye).call(this,e);a.send(t),this.update(t=>{t.snaps[e].status=a.state.value})}async function be(e){await this.messagingSystem.call("ExecutionService:terminateSnap",e),await new Promise(e=>setTimeout(e,1));o(X,this,Ye).call(this,e).pendingInboundRequests.filter(e=>"finished"!==e.timer.status).forEach(e=>e.timer.finish()),await new Promise(e=>setTimeout(e,1)),this.messagingSystem.publish("SnapController:snapTerminated",this.getTruncatedExpect(e))}function me(e,t=o(X,this,Ye).call(this,e)){return null!==t.encryptionKey&&null!==t.encryptionSalt}async function ue({snapId:e,salt:t,useCache:a,keyMetadata:f}){const s=o(X,this,Ye).call(this,e);if(o(X,this,me).call(this,e,s)&&a)return{key:await i(B,this).importKey(s.encryptionKey),salt:s.encryptionSalt};const n=t??i(B,this).generateSalt(),r=await i(U,this).call(this),c=await(0,m.getEncryptionEntropy)({snapId:e,seed:r,cryptographicFunctions:i(H,this)}),d=await i(B,this).keyFromPassword(c,n,!0,f),l=await i(B,this).exportKey(d);return a&&(s.encryptionKey=l,s.encryptionSalt=n),{key:d,salt:n}}async function pe(e,t){try{const a=JSON.parse(t),{salt:f,keyMetadata:s}=a,n=o(X,this,me).call(this,e)||i(B,this).isVaultUpdated(t),{key:r}=await o(X,this,ue).call(this,{snapId:e,salt:f,useCache:n,keyMetadata:s??x.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS});return await i(B,this).decryptWithKey(r,a)}catch{throw b.rpcErrors.internal({message:"Failed to decrypt snap state, the state must be corrupted."})}}async function he(e,t){const{key:a,salt:f}=await o(X,this,ue).call(this,{snapId:e,useCache:!0}),s=await i(B,this).encryptWithKey(a,t);return s.salt=f,JSON.stringify(s)}async function ge(e,t,a){return null===t?null:a?await o(X,this,he).call(this,e,t):JSON.stringify(t)}function ke(e,t,a){if(t){const f=(0,E.setDiff)(t,a);for(const t of Object.keys(f))this.removeSnapFromSubject(t,e)}for(const t of Object.keys(a))o(X,this,ye).call(this,t,e)}function ye(e,t){var a,f;const s=this.messagingSystem.call("PermissionController:getPermissions",e),n=null==s||null===(a=s[m.WALLET_SNAP_PERMISSION_KEY])||void 0===a||null===(a=a.caveats)||void 0===a?void 0:a.find(e=>e.type===p.SnapCaveatType.SnapIds);if(Boolean(null==n||null===(f=n.value)||void 0===f?void 0:f[t]))return;if(n)return void this.messagingSystem.call("PermissionController:updateCaveat",e,m.WALLET_SNAP_PERMISSION_KEY,p.SnapCaveatType.SnapIds,{...n.value,[t]:{}});const i={[m.WALLET_SNAP_PERMISSION_KEY]:{caveats:[{type:p.SnapCaveatType.SnapIds,value:{[t]:{}}}]}};this.messagingSystem.call("PermissionController:grantPermissions",{approvedPermissions:i,subject:{origin:e}})}function we(e){const t=this.messagingSystem.call("PermissionController:getSubjectNames");for(const a of t)this.removeSnapFromSubject(a,e)}function xe(e){this.messagingSystem.call("PermissionController:hasPermissions",e)&&this.messagingSystem.call("PermissionController:revokeAllPermissions",e)}async function ve(e,t,f,s){const n=this.getTruncated(t);if(n&&!f.shouldAlwaysReload)return(0,h.satisfiesVersionRange)(n.version,s)?n:await o(X,this,je).call(this,{origin:e,snapId:t,location:f,versionRange:s});o(X,this,oe).call(this);let i=o(X,this,Se).call(this,{origin:e,snapId:t,type:a.SNAP_APPROVAL_INSTALL});this.messagingSystem.publish("SnapController:snapInstallStarted",t,e,!1),n&&this.isRunning(t)&&await this.stopSnap(t,p.SnapStatusEvents.Stop),n&&f.shouldAlwaysReload&&o(X,this,xe).call(this,t);try{const{sourceCode:n}=await o(X,this,Te).call(this,{origin:e,id:t,location:f,versionRange:s});await o(X,this,Ae).call(this,t,i),i=o(X,this,Se).call(this,{origin:e,snapId:t,type:a.SNAP_APPROVAL_RESULT}),await o(X,this,Ee).call(this,{snapId:t,sourceCode:n});const r=this.getTruncatedExpect(t);return o(X,this,_e).call(this,i.id,{loading:!1,type:a.SNAP_APPROVAL_INSTALL}),r}catch(f){(0,p.logError)(`Error when adding ${t}.`,f);const s=f instanceof Error?f.message:f.toString();throw o(X,this,_e).call(this,i.id,{loading:!1,type:a.SNAP_APPROVAL_INSTALL,error:s}),this.messagingSystem.publish("SnapController:snapInstallFailed",t,e,!1,s),f}}function Se({origin:e,snapId:t,type:a}){const f=(0,y.nanoid)();return{id:f,promise:this.messagingSystem.call("ApprovalController:addRequest",{origin:e,id:f,type:a,requestData:{metadata:{id:f,origin:t,dappOrigin:e},snapId:t},requestState:{loading:!0}},!0)}}function _e(e,t){try{this.messagingSystem.call("ApprovalController:updateRequestState",{id:e,requestState:t})}catch{}}async function je({origin:e,snapId:t,location:f,versionRange:s,automaticUpdate:n=!1}){o(X,this,oe).call(this),o(X,this,ce).call(this);const i=this.getExpect(t),{preinstalled:r,removable:c,hidden:d,hideSnapBranding:l}=i;if(r&&!n)throw new Error("Preinstalled Snaps cannot be manually updated.");let u=n?null:o(X,this,Se).call(this,{origin:e,snapId:t,type:a.SNAP_APPROVAL_UPDATE});try{this.messagingSystem.publish("SnapController:snapInstallStarted",t,e,!0);const g=i.manifest,k=await(0,E.fetchSnap)(t,f),{sourceCode:y,manifest:w}=k,x=w.result,v=x.version;if(!(0,h.gtVersion)(v,i.version))throw b.rpcErrors.invalidParams(`Snap "${t}@${i.version}" is already installed. Couldn't update to a version inside requested "${s}" range.`);if(!(0,h.satisfiesVersionRange)(v,s))throw new Error(`Version mismatch. Manifest for "${t}" specifies version "${v}" which doesn't satisfy requested version range "${s}".`);await o(X,this,re).call(this,t,{version:v,checksum:x.source.shasum,permissions:x.initialPermissions,platformVersion:x.platformVersion});const S=(0,m.processSnapPermissions)(x.initialPermissions);o(X,this,Ie).call(this,S);const{newPermissions:_,unusedPermissions:j,approvedPermissions:P}=o(X,this,Xe).call(this,t,S),{newConnections:T,unusedConnections:O,approvedConnections:M}=o(X,this,et).call(this,t,g.initialConnections??{},x.initialConnections??{});let I,C;if(u){o(X,this,_e).call(this,u.id,{permissions:_,newVersion:x.version,newPermissions:_,approvedPermissions:P,unusedPermissions:j,newConnections:T,unusedConnections:O,approvedConnections:M,loading:!1});const{permissions:f,...s}=await u.promise;I=f,C=s,u=o(X,this,Se).call(this,{origin:e,snapId:t,type:a.SNAP_APPROVAL_RESULT})}else(0,h.assert)(n),I=_;this.isRunning(t)&&await this.stopSnap(t,p.SnapStatusEvents.Stop),o(X,this,le).call(this,t,p.SnapStatusEvents.Update),o(X,this,Me).call(this,{origin:e,id:t,files:k,removable:c,preinstalled:r,hidden:d,hideSnapBranding:l,isUpdate:!0}),o(X,this,at).call(this,{snapId:t,unusedPermissions:j,newPermissions:I,requestData:C});const A=g.initialConnections??null,R=x.initialConnections??{};o(X,this,ke).call(this,t,A,R);const $=o(X,this,Ge).call(this,t);$!==undefined&&($.permissions.revoked=j,$.permissions.granted=I,$.permissions.requestData=C,$.previousInitialConnections=A,$.newInitialConnections=R);const N=y.toString();(0,h.assert)("string"==typeof N&&N.length>0,`Invalid source code for snap "${t}".`);try{await o(X,this,Ee).call(this,{snapId:t,sourceCode:N})}catch{throw new Error(`Snap ${t} crashed with updated source code.`)}const L=this.getTruncatedExpect(t);return u&&o(X,this,_e).call(this,u.id,{loading:!1,type:a.SNAP_APPROVAL_UPDATE}),L}catch(f){(0,p.logError)(`Error when updating ${t},`,f);const s=f instanceof Error?f.message:f.toString();throw u&&o(X,this,_e).call(this,u.id,{loading:!1,error:s,type:a.SNAP_APPROVAL_UPDATE}),this.messagingSystem.publish("SnapController:snapInstallFailed",t,e,!0,s),f}}async function Pe(e,t){return await this.messagingSystem.call("SnapsRegistry:resolveVersion",e,t)}async function Te(e){const{id:t,location:a,versionRange:f}=e;o(X,this,Ze).call(this,t);const s=o(X,this,Ye).call(this,t);s.installPromise||((0,T.log)(`Adding snap: ${t}`),s.installPromise=(async()=>{const s=await(0,E.fetchSnap)(t,a),n=s.manifest.result;if(!(0,h.satisfiesVersionRange)(n.version,f))throw new Error(`Version mismatch. Manifest for "${t}" specifies version "${n.version}" which doesn't satisfy requested version range "${f}".`);await o(X,this,re).call(this,t,{version:n.version,checksum:n.source.shasum,permissions:n.initialPermissions,platformVersion:n.platformVersion});const r=i(N,this).forcePreinstalledSnaps&&(0,E.isLocalSnapId)(t)?{preinstalled:!0,hideSnapBranding:!0,hidden:!1}:{};return o(X,this,Me).call(this,{...e,files:s,id:t,...r})})());try{return await s.installPromise}catch(e){throw s.installPromise=null,e}}async function Ee(e){const{snapId:t}=e;if(this.isRunning(t))throw new Error(`Snap "${t}" is already started.`);try{const a=o(X,this,Ye).call(this,t),f=await this.messagingSystem.call("ExecutionService:executeSnap",{...e,endowments:await o(X,this,Oe).call(this,t)});return o(X,this,le).call(this,t,p.SnapStatusEvents.Start),a.lastRequest=Date.now(),f}catch(e){throw await o(X,this,be).call(this,t),e}}async function Oe(e){let t=[];for(const a of i(R,this))if(this.messagingSystem.call("PermissionController:hasPermission",e,a)){const f=await this.messagingSystem.call("PermissionController:getEndowments",e,a);if(f){if(!Array.isArray(f)||f.some(e=>"string"!=typeof e))throw new Error("Expected an array of string endowment names.");t=t.concat(f)}}const a=[...new Set([...p.DEFAULT_ENDOWMENTS,...t])];return a.length<p.DEFAULT_ENDOWMENTS.length+t.length&&(0,p.logError)(`Duplicate endowments found for ${e}. Default endowments should not be requested.`,t),a}function Me(e){const{id:t,origin:a,files:f,isUpdate:s=!1,removable:n,preinstalled:r,hidden:c,hideSnapBranding:d}=e,{manifest:b,sourceCode:m,svgIcon:u,auxiliaryFiles:g,localizationFiles:k}=f;(0,p.assertIsSnapManifest)(b.result);const{version:y}=b.result,w=m.toString();(0,h.assert)("string"==typeof w&&w.length>0,`Invalid source code for snap "${t}".`);const x=g.map(e=>((0,h.assert)("string"==typeof e.data.base64),{path:e.path,value:e.data.base64})),v=this.state.snaps[t],S=[...(null==v?void 0:v.versionHistory)??[],{version:y,date:Date.now(),origin:a}],_=k.map(e=>e.result),j={...v,blocked:!1,enabled:!0,removable:n,preinstalled:r,hidden:c,hideSnapBranding:d,id:t,initialConnections:b.result.initialConnections,initialPermissions:b.result.initialPermissions,manifest:b.result,status:i(z,this).config.initial,sourceCode:w,version:y,versionHistory:S,auxiliaryFiles:x,localizationFiles:_};delete j.blockInformation;const{inversePatches:P}=this.update(e=>{e.snaps[t]=j});if(s){const e=o(X,this,Ge).call(this,t);e!==undefined&&(e.statePatches=P)}const{proposedName:T}=(0,p.getLocalizedSnapManifest)(b.result,"en",_);return this.messagingSystem.call("SubjectMetadataController:addSubjectMetadata",{subjectType:l.SubjectType.Snap,name:T,origin:j.id,version:y,svgIcon:(null==u?void 0:u.toString())??null}),{...j,sourceCode:w}}function Ie(e){const t=Object.keys(e),a=Array.from(new Set(Object.values(m.handlerEndowments)));(0,h.assert)(t.some(e=>a.includes(e)),`A snap must request at least one of the following permissions: ${a.filter(e=>null!==e).join(", ")}.`);const f=t.reduce((e,t)=>((0,h.hasProperty)(i($,this),t)&&e.push(i($,this)[t]),e),[]);(0,h.assert)(0===f.length,`One or more permissions are not allowed:\n${f.join("\n")}`)}function Ce(e,t){if(t!==undefined&&(0,w.gt)(t,(0,p.getPlatformVersion)())){const a=`The Snap "${e}" requires platform version "${t}" which is greater than the current platform version "${(0,p.getPlatformVersion)()}".`;if(i(N,this).rejectInvalidPlatformVersion)throw new Error(a);(0,p.logWarning)(a)}}async function Ae(e,t){(0,T.log)(`Authorizing snap: ${e}`);const a=this.state.snaps[e],{initialPermissions:f,initialConnections:s}=a;try{const n=(0,m.processSnapPermissions)(f);o(X,this,Ie).call(this,n),o(X,this,_e).call(this,t.id,{loading:!1,connections:s??{},permissions:n});const{permissions:i,...r}=await t.promise;o(X,this,at).call(this,{snapId:e,newPermissions:i,requestData:r}),a.manifest.initialConnections&&o(X,this,ke).call(this,e,null,a.manifest.initialConnections)}finally{o(X,this,Ye).call(this,e).installPromise=null}}function Re(e){return(0,m.getMaxRequestTimeCaveat)(e)??this.maxRequestTime}async function $e(e,t,a){return this.messagingSystem.call("SnapInterfaceController:createInterface",e,t,undefined,a)}function Ne(e,t){(0,h.assert)(this.messagingSystem.call("SnapInterfaceController:getInterface",e,t))}async function Le(e,t,a,f){switch(t){case p.HandlerType.OnTransaction:case p.HandlerType.OnSignature:case p.HandlerType.OnHomePage:case p.HandlerType.OnSettingsPage:{const t=f;if(t&&(0,h.hasProperty)(t,"content")){const{content:a,...f}=t;return{...f,id:await o(X,this,$e).call(this,e,a)}}return f}case p.HandlerType.OnAssetsLookup:return o(X,this,De).call(this,e,a,f);case p.HandlerType.OnAssetsConversion:return o(X,this,Fe).call(this,a,f);case p.HandlerType.OnAssetsMarketData:return o(X,this,Be).call(this,a,f);default:return f}}function De(e,{params:t},{assets:a}){const f=this.messagingSystem.call("PermissionController:getPermissions",e);(0,h.assert)(f);const s=f[m.SnapEndowments.Assets],n=(0,m.getChainIdsCaveat)(s);(0,h.assert)(n);const{assets:i}=t;return{assets:Object.keys(a).reduce((e,t)=>{const f=t;return n.some(e=>f.startsWith(e))&&i.includes(f)&&(e[f]=a[f]),e},{})}}function Fe({params:e},{conversionRates:t}){const{conversions:a}=e;return{conversionRates:a.reduce((e,a)=>{var f;const s=null===(f=t[a.from])||void 0===f?void 0:f[a.to];var n;s&&(e[n=a.from]??(e[n]={}),e[a.from][a.to]=s);return e},{})}}function Be({params:e},{marketData:t}){const{assets:a}=e;return{marketData:a.reduce((e,a)=>{var f;const s=null===(f=t[a.asset])||void 0===f?void 0:f[a.unit];var n;s&&(e[n=a.asset]??(e[n]={}),e[a.asset][a.unit]=s);return e},{})}}function Ue(e,t,a){if(t===p.HandlerType.OnUserInput){(0,h.assert)(a.params&&(0,h.hasProperty)(a.params,"id"));const t=a.params.id,{context:f}=this.messagingSystem.call("SnapInterfaceController:getInterface",e,t);return{...a,params:{...a.params,context:f}}}return a}async function qe(e,t,a){switch(t){case p.HandlerType.OnTransaction:(0,h.assertStruct)(a,p.OnTransactionResponseStruct),a&&(0,h.hasProperty)(a,"id")&&o(X,this,Ne).call(this,e,a.id);break;case p.HandlerType.OnSignature:(0,h.assertStruct)(a,p.OnSignatureResponseStruct),a&&(0,h.hasProperty)(a,"id")&&o(X,this,Ne).call(this,e,a.id);break;case p.HandlerType.OnHomePage:(0,h.assertStruct)(a,p.OnHomePageResponseStruct),a&&(0,h.hasProperty)(a,"id")&&o(X,this,Ne).call(this,e,a.id);break;case p.HandlerType.OnSettingsPage:(0,h.assertStruct)(a,p.OnSettingsPageResponseStruct),a&&(0,h.hasProperty)(a,"id")&&o(X,this,Ne).call(this,e,a.id);break;case p.HandlerType.OnNameLookup:(0,h.assertStruct)(a,p.OnNameLookupResponseStruct);break;case p.HandlerType.OnAssetsLookup:(0,h.assertStruct)(a,u.OnAssetsLookupResponseStruct);break;case p.HandlerType.OnAssetsConversion:(0,h.assertStruct)(a,p.OnAssetsConversionResponseStruct);break;case p.HandlerType.OnAssetHistoricalPrice:(0,h.assertStruct)(a,p.OnAssetHistoricalPriceResponseStruct);break;case p.HandlerType.OnAssetsMarketData:(0,h.assertStruct)(a,p.OnAssetsMarketDataResponseStruct)}}function He(e,t,a){const f=o(X,this,Ye).call(this,e);f.pendingInboundRequests.push({requestId:t,timer:a}),f.lastRequest=null}function Ve(e,t,a,f,s){const n=o(X,this,Ye).call(this,e);n.pendingInboundRequests=n.pendingInboundRequests.filter(e=>e.requestId!==t),0===n.pendingInboundRequests.length&&(n.lastRequest=Date.now());const r=this.get(e);if((0,E.isTrackableHandler)(a)&&(null==r||!r.preinstalled))try{i(Z,this).call(this,e,a,s,f)}catch(e){(0,p.logError)(`Error when calling MetaMetrics hook for snap "${null==r?void 0:r.id}": ${(0,u.getErrorMessage)(e)}`)}}function Ge(e){return i(W,this).get(e)}function We(e){(0,h.assert)(i(W,this).get(e)===undefined,`Snap "${e}" rollback snapshot already exists.`),i(W,this).set(e,{statePatches:[],permissions:{},newVersion:""});const t=i(W,this).get(e);return(0,h.assert)(t!==undefined,`Snapshot creation failed for ${e}.`),t}async function Ke(e){var t,a;const f=o(X,this,Ge).call(this,e);if(!f)throw new Error("A snapshot does not exist for this snap.");await this.stopSnap(e,p.SnapStatusEvents.Stop),(null===(t=this.get(e))||void 0===t?void 0:t.status)!==p.SnapStatus.Stopped&&o(X,this,le).call(this,e,p.SnapStatusEvents.Stop);const{statePatches:s,permissions:n,previousInitialConnections:r,newInitialConnections:c}=f;null!=s&&s.length&&this.applyPatches(s),(null===(a=this.get(e))||void 0===a?void 0:a.status)!==p.SnapStatus.Stopped&&this.update(t=>{t.snaps[e].status=p.SnapStatus.Stopped}),o(X,this,at).call(this,{snapId:e,unusedPermissions:n.granted,newPermissions:n.revoked,requestData:n.requestData}),o(X,this,ke).call(this,e,c??null,r??{});const d=this.getTruncatedExpect(e);this.messagingSystem.publish("SnapController:snapRolledback",d,f.newVersion),i(W,this).delete(e)}async function ze(e){for(const t of e)await o(X,this,Ke).call(this,t)}function Je(e){return i(G,this).get(e)}function Ye(e){const t=o(X,this,Je).call(this,e);return(0,h.assert)(t!==undefined,`Snap "${e}" runtime data not found`),t}function Ze(e){if(i(G,this).has(e))return;const t=this.get(e),a=(0,g.interpret)(i(z,this));a.start({context:{snapId:e},value:(null==t?void 0:t.status)??i(z,this).config.initial}),(0,P.forceStrict)(a),i(G,this).set(e,{lastRequest:null,startPromise:null,stopPromise:null,installPromise:null,encryptionKey:null,encryptionSalt:null,activeReferences:0,pendingInboundRequests:[],pendingOutboundRequests:0,interpreter:a,stateMutex:new k.Mutex,getStateMutex:new k.Mutex})}function Xe(e,t){const a=this.messagingSystem.call("PermissionController:getPermissions",e)??{},f=(0,E.permissionsDiff)(t,a),s=(0,E.permissionsDiff)(a,t);return{newPermissions:f,unusedPermissions:s,approvedPermissions:(0,E.permissionsDiff)(a,s)}}function Qe(e,t){var a,f;const s=this.messagingSystem.call("PermissionController:getPermissions",t),n=null==s||null===(a=s[m.WALLET_SNAP_PERMISSION_KEY])||void 0===a||null===(a=a.caveats)||void 0===a?void 0:a.find(e=>e.type===p.SnapCaveatType.SnapIds);return Boolean(null==n||null===(f=n.value)||void 0===f?void 0:f[e])}function et(e,t,a){const f=Object.keys(t).filter(t=>o(X,this,Qe).call(this,e,t)).reduce((e,a)=>(e[a]=t[a],e),{}),s=(0,E.setDiff)(a,f),n=(0,E.setDiff)(f,a);return{newConnections:s,unusedConnections:n,approvedConnections:(0,E.setDiff)(f,n)}}function tt(e,t){if(Object.keys(t).includes(m.SnapEndowments.EthereumProvider)){const a=this.messagingSystem.call("SelectedNetworkController:getNetworkClientIdForDomain",e),{configuration:f}=this.messagingSystem.call("NetworkController:getNetworkClientById",a),s=(0,h.hexToNumber)(f.chainId);return{...t,"endowment:caip25":{caveats:[{type:"authorizedScopes",value:{requiredScopes:{},optionalScopes:{[`eip155:${s}`]:{accounts:[]}},sessionProperties:{},isMultichainOrigin:!1}}]}}}return t}function at({snapId:e,unusedPermissions:t={},newPermissions:a={},requestData:f}){const s=Object.keys(t);if((0,h.isNonEmptyArray)(s)&&this.messagingSystem.call("PermissionController:revokePermissions",{[e]:s}),(0,h.isNonEmptyArray)(Object.keys(a))){const t=o(X,this,tt).call(this,e,a);this.messagingSystem.call("PermissionController:grantPermissions",{approvedPermissions:t,subject:{origin:e},requestData:f})}}function ft(e,t){const a=this.getExpect(e);return!(0,h.satisfiesVersionRange)(a.version,t)&&!(0,h.gtRange)(a.version,t)}function st(e,t){const a=this.getRunnableSnaps();for(const{id:f}of a){this.messagingSystem.call("PermissionController:hasPermission",f,m.SnapEndowments.LifecycleHooks)&&o(X,this,nt).call(this,e,f,t).catch(e=>{(0,p.logError)(`Error calling lifecycle hook "${t}" for Snap "${f}": ${(0,u.getErrorMessage)(e)}`)})}}async function nt(e,t,a){const f=m.handlerEndowments[a];(0,h.assert)(f,"Lifecycle hook must have an endowment.");this.messagingSystem.call("PermissionController:hasPermission",t,f)&&await this.handleRequest({snapId:t,handler:a,origin:e,request:{jsonrpc:"2.0",method:a}})}function it(){for(const e of i(G,this).values())e.encryptionKey=null,e.encryptionSalt=null,e.state=undefined}a.SnapController=ee}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}Object.defineProperty(a,"__esModule",{value:!0}),a.Timer=void 0;const s=e("@metamask/utils");a.Timer=class{constructor(e){f(this,"state",void 0),(0,s.assert)(!Number.isNaN(e),new TypeError("Can't start a timer with NaN time")),(0,s.assert)(e>=0,new TypeError("Can't start a timer with negative time")),this.state={value:"stopped",remaining:e}}get status(){return this.state.value}get remaining(){return this.state.remaining}cancel(){(0,s.assert)("paused"===this.status||"running"===this.status,"Tried to cancel a not running Timer"),this.onFinish(!1)}finish(){(0,s.assert)("finished"!==this.status,"Tried to finish a finished Timer."),this.onFinish(!0)}pause(){(0,s.assert)("running"===this.state.value,"Tried to pause a not running Timer");const{callback:e,start:t,timeout:a,remaining:f}=this.state;a!==undefined&&clearTimeout(a),this.state={value:"paused",callback:e,remaining:f-(Date.now()-t)}}start(e){(0,s.assert)("stopped"===this.state.value,"Tried to start an already running Timer");const{remaining:t}=this.state;this.state={value:"paused",remaining:t,callback:e},this.resume()}resume(){(0,s.assert)("paused"===this.state.value,"Tried to resume not paused Timer");const{remaining:e,callback:t}=this.state,a=Date.now();let f;e!==Number.POSITIVE_INFINITY&&(f=setTimeout(()=>this.onFinish(!0),e)),this.state={value:"running",callback:t,remaining:e,start:a,timeout:f}}onFinish(e){(0,s.assert)("running"===this.state.value||"paused"===this.state.value),"running"===this.state.value&&this.state.timeout!==undefined&&clearTimeout(this.state.timeout);const{callback:t,remaining:a}=this.state;this.state={value:"finished",remaining:"running"===this.state.value?a-(Date.now()-this.state.start):a},e&&t()}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs",{"@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.CLIENT_ONLY_HANDLERS=a.METAMASK_ORIGIN=a.STATE_DEBOUNCE_TIMEOUT=a.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS=a.ALLOWED_PERMISSIONS=void 0;const f=e("@metamask/snaps-rpc-methods"),s=e("@metamask/snaps-utils");a.ALLOWED_PERMISSIONS=Object.freeze(["snap_dialog","snap_manageState","snap_notify","snap_getLocale",f.SnapEndowments.Cronjob,f.SnapEndowments.HomePage,f.SnapEndowments.LifecycleHooks,f.SnapEndowments.EthereumProvider,f.SnapEndowments.TransactionInsight,f.SnapEndowments.SignatureInsight]),a.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS={algorithm:"PBKDF2",params:{iterations:1e4}},a.STATE_DEBOUNCE_TIMEOUT=500,a.METAMASK_ORIGIN="metamask",a.CLIENT_ONLY_HANDLERS=Object.freeze([s.HandlerType.OnClientRequest,s.HandlerType.OnSignature,s.HandlerType.OnTransaction,s.HandlerType.OnCronjob,s.HandlerType.OnNameLookup,s.HandlerType.OnHomePage,s.HandlerType.OnSettingsPage,s.HandlerType.OnUserInput,s.HandlerType.OnAssetsLookup,s.HandlerType.OnAssetsConversion,s.HandlerType.OnAssetHistoricalPrice,s.HandlerType.OnAssetsMarketData,s.HandlerType.OnWebSocketEvent])}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs",{"./SnapController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./location/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs","./registry/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./constants.cjs"),a),s(e("./location/index.cjs"),a),s(e("./SnapController.cjs"),a),s(e("./selectors.cjs"),a),s(e("./registry/index.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}Object.defineProperty(a,"__esModule",{value:!0}),a.HttpLocation=void 0;const s=e("@metamask/snaps-utils"),n=e("@metamask/utils");a.HttpLocation=class{constructor(e,t={}){f(this,"cache",new Map),f(this,"validatedManifest",void 0),f(this,"url",void 0),f(this,"fetchFn",void 0),f(this,"fetchOptions",void 0),(0,n.assertStruct)(e.toString(),s.HttpSnapIdStruct,"Invalid Snap Id: "),this.fetchFn=t.fetch??globalThis.fetch.bind(undefined),this.fetchOptions=t.fetchOptions,this.url=e}async manifest(){if(this.validatedManifest)return this.validatedManifest.clone();const e=new URL(s.NpmSnapFileNames.Manifest,this.url).toString(),t=await this.fetchFn(e,this.fetchOptions);if(!t.ok)throw new Error(`Failed to fetch "${e}". Status code: ${t.status}.`);const a=await t.text(),f=(0,s.parseJson)(a),n=new s.VirtualFile({value:a,result:(0,s.createSnapManifest)(f),path:s.NpmSnapFileNames.Manifest,data:{canonicalPath:e}});return this.validatedManifest=n,this.manifest()}async fetch(e){const t=(0,s.normalizeRelative)(e),a=this.cache.get(t);if(a!==undefined)return a.clone();const f=this.toCanonical(t).toString(),i=await this.fetchFn(f,this.fetchOptions);if(!i.ok)throw new Error(`Failed to fetch "${f}". Status code: ${i.status}.`);const r=await i.arrayBuffer(),o=new s.VirtualFile({value:new Uint8Array(r),path:t,data:{canonicalPath:f}});return(0,n.assert)(!this.cache.has(t),"Corrupted cache, multiple files with same path."),this.cache.set(t,o),this.fetch(t)}get root(){return new URL(this.url)}toCanonical(e){return(0,n.assert)(!e.startsWith("/"),"Tried to parse absolute path."),new URL(e,this.url)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","./local.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs","./location.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs","./npm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./location.cjs"),a),s(e("./npm.cjs"),a),s(e("./local.cjs"),a),s(e("./http.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,a)}function s(e,t){return e.get(n(e,t))}function n(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.LocalLocation=void 0;const i=e("@metamask/snaps-utils"),r=e("@metamask/utils"),o=e("./http.cjs");var c=new WeakMap;function d(e){return(0,r.assert)(e.data.canonicalPath!==undefined),e.data.canonicalPath=`local:${e.data.canonicalPath}`,e}a.LocalLocation=class{constructor(e,t={}){var a,s,d;f(this,c,void 0),(0,r.assertStruct)(e.toString(),i.LocalSnapIdStruct,"Invalid Snap Id"),(0,r.assert)(t.fetchOptions===undefined,"Currently adding fetch options to local: is unsupported."),a=c,s=this,d=new o.HttpLocation(new URL(e.toString().slice(i.SnapIdPrefixes.local.length)),{...t,fetchOptions:{cache:"no-cache"}}),a.set(n(a,s),d)}async manifest(){return d(await s(c,this).manifest())}async fetch(e){return d(await s(c,this).fetch(e))}get shouldAlwaysReload(){return!0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","./local.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs","./npm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.detectSnapLocation=void 0;const f=e("@metamask/utils"),s=e("./http.cjs"),n=e("./local.cjs"),i=e("./npm.cjs");a.detectSnapLocation=function(e,t){const a=(null==t?void 0:t.allowHttp)??!1,r=(null==t?void 0:t.allowLocal)??!1,o=new URL(e);switch(o.protocol){case"npm:":return new i.NpmLocation(o,t);case"local:":return(0,f.assert)(r,new TypeError("Fetching local snaps is disabled.")),new n.LocalLocation(o,t);case"http:":case"https:":return(0,f.assert)(a,new TypeError("Fetching snaps through http/https is disabled.")),new s.HttpLocation(o,t);default:throw new TypeError(`Unrecognized "${o.protocol}" snap location protocol.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","concat-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js","get-npm-tarball-url":"/home/runner/work/metamask-extension/metamask-extension/node_modules/get-npm-tarball-url/lib/index.js","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js","readable-web-to-node-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/lib/index.js","tar-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){s(e,t),t.set(e,a)}function s(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t,a){return e.set(o(e,t),a),a}function r(e,t){return e.get(o(e,t))}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}var c=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.getNpmCanonicalBasePath=a.fetchNpmMetadata=a.NpmLocation=a.TARBALL_SIZE_SAFETY_LIMIT=a.BaseNpmLocation=a.DEFAULT_NPM_REGISTRY=void 0;const d=e("@metamask/snaps-utils"),l=e("@metamask/utils"),b=c(e("concat-stream")),m=c(e("get-npm-tarball-url")),u=e("readable-stream"),p=e("readable-web-to-node-stream"),h=e("tar-stream");a.DEFAULT_NPM_REGISTRY=new URL("https://registry.npmjs.org");var g=new WeakMap,k=new WeakMap,y=new WeakSet;class w{constructor(e,t={}){var i,r;s(i=this,r=y),r.add(i),n(this,"meta",void 0),f(this,g,void 0),f(this,k,void 0);const o=t.allowCustomRegistries??!1,c=t.fetch??globalThis.fetch.bind(undefined),b=t.versionRange??d.DEFAULT_REQUESTED_SNAP_VERSION,m=t.resolveVersion??(async e=>e);let u;(0,l.assertStruct)(e.toString(),d.NpmSnapIdStruct,"Invalid Snap Id: "),""===e.host&&""===e.port&&""===e.username&&""===e.password?u=a.DEFAULT_NPM_REGISTRY:(u="https://",e.username&&(u+=e.username,e.password&&(u+=`:${e.password}`),u+="@"),u+=e.host,u=new URL(u),(0,l.assert)(o,new TypeError(`Custom NPM registries are disabled, tried to use "${u.toString()}".`))),(0,l.assert)("/"===u.pathname&&""===u.search&&""===u.hash),(0,l.assert)(""!==e.pathname&&"/"!==e.pathname,new TypeError("The package name in NPM location is empty."));let p=e.pathname;p.startsWith("/")&&(p=p.slice(1)),this.meta={requestedRange:b,registry:u,packageName:p,fetch:c,resolveVersion:m}}async manifest(){if(r(g,this))return r(g,this).clone();const e=await this.fetch("snap.manifest.json"),t=(0,d.parseJson)(e.toString());return e.result=(0,d.createSnapManifest)(t),i(g,this,e),this.manifest()}async fetch(e){const t=(0,d.normalizeRelative)(e);r(k,this)||(await o(y,this,x).call(this),(0,l.assert)(r(k,this)!==undefined));const a=r(k,this).get(t);return(0,l.assert)(a!==undefined,new TypeError(`File "${e}" not found in package.`)),a.clone()}get packageName(){return this.meta.packageName}get version(){return(0,l.assert)(this.meta.version!==undefined,"Tried to access version without first fetching NPM package."),this.meta.version}get registry(){return this.meta.registry}get versionRange(){return this.meta.requestedRange}}async function x(){(0,l.assert)(r(k,this)===undefined);const e=await this.meta.resolveVersion(this.meta.requestedRange),{tarballURL:t,targetVersion:a}=await async function(e,t,a,f){var s;if(_(a)&&(0,l.isValidSemVerVersion)(t))return{tarballURL:(0,m.default)(e,t),targetVersion:t};const n=await v(e,a,f),i=Object.keys((null==n?void 0:n.versions)??{}).map(e=>((0,l.assertIsSemVerVersion)(e),e)),r=(0,d.getTargetVersion)(i,t);if(null===r)throw new Error(`Failed to find a matching version in npm metadata for package "${e}" and requested semver range "${t}".`);const o=null==n||null===(s=n.versions)||void 0===s||null===(s=s[r])||void 0===s||null===(s=s.dist)||void 0===s?void 0:s.tarball;return{tarballURL:o,targetVersion:r}}(this.meta.packageName,e,this.meta.registry,this.meta.fetch);if(!(0,d.isValidUrl)(t)||!t.toString().endsWith(".tgz"))throw new Error(`Failed to find valid tarball URL in NPM metadata for package "${this.meta.packageName}".`);const f=new URL(t);f.hostname=this.meta.registry.hostname,f.protocol=this.meta.registry.protocol;const s=await this.fetchNpmTarball(f);i(k,this,s),this.meta.version=a}a.BaseNpmLocation=w,a.TARBALL_SIZE_SAFETY_LIMIT=262144e3;async function v(e,t,a){const f=await a(new URL(e,t).toString(),{headers:{accept:_(t)?"application/vnd.npm.install-v1+json; q=1.0, application/json; q=0.8, */*":"application/json"}});if(!f.ok)throw new Error(`Failed to fetch NPM registry entry. Status code: ${f.status}.`);const s=await f.json();if(!(0,l.isObject)(s))throw new Error(`Failed to fetch package "${e}" metadata from npm.`);return s}function S(e,t){let a="npm://";return""!==e.username&&(a+=e.username,""!==e.password&&(a+=`:${e.password}`),a+="@"),`${a}${e.host}/${t}/`}function _(e){return e.toString()===a.DEFAULT_NPM_REGISTRY.toString()}a.NpmLocation=class extends w{async fetchNpmTarball(e){const t=await this.meta.fetch(e.toString());(0,l.assert)(404!==t.status,`"${this.meta.packageName}" was not found in the NPM registry`),(0,l.assert)(t.ok&&t.body,`Failed to fetch tarball for package "${this.meta.packageName}"`);const f=t.headers.get("content-length");(0,l.assert)(f,"Snap tarball has invalid content-length");const s=parseInt(f,10);return(0,l.assert)(s<=a.TARBALL_SIZE_SAFETY_LIMIT,"Snap tarball exceeds size limit"),new Promise((e,f)=>{const s=new Map,n=function(e,t){(0,l.assert)(e.endsWith("/"),"Base needs to end with '/' for relative paths to be added as children instead of siblings."),(0,l.assert)(e.startsWith("npm:"),'Protocol mismatch, expected "npm:".');const f=(0,h.extract)();let s=0;return f.on("entry",(n,i,r)=>{const{name:o,type:c}=n;if("file"===c){const n=o.replace(j,"");return i.pipe((0,b.default)({encoding:"uint8array"},i=>{try{s+=i.byteLength,(0,l.assert)(s<a.TARBALL_SIZE_SAFETY_LIMIT,`Snap tarball exceeds limit of ${a.TARBALL_SIZE_SAFETY_LIMIT} bytes.`);const f=new d.VirtualFile({value:i,path:n,data:{canonicalPath:new URL(n,e).toString()}});return(0,l.assert)(!t.has(n),"Malformed tarball, multiple files with the same path."),t.set(n,f),r()}catch(e){return f.destroy(e)}}))}return i.on("end",()=>r()),i.resume()}),f}(S(this.meta.registry,this.meta.packageName),s),i=t.body,r=new DecompressionStream("gzip"),o=i.pipeThrough(r);(0,u.pipeline)(function(e){if("function"!=typeof e.getReader)return e;return new p.ReadableWebToNodeStream(e)}(o),n,t=>{t?f(t):e(s)})})}},a.fetchNpmMetadata=v,a.getNpmCanonicalBasePath=S;const j=/^package\//u}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs",{"./json.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs","./registry.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./registry.cjs"),a),s(e("./json.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs",{"./registry.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-registry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/index.js","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){s(e,t),t.set(e,a)}function s(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function n(e,t){return e.get(r(e,t))}function i(e,t,a){return e.set(r(e,t),a),a}function r(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.JsonSnapsRegistry=void 0;const o=e("@metamask/base-controller"),c=e("@metamask/snaps-registry"),d=e("@metamask/snaps-utils"),l=e("@metamask/utils"),b=e("./registry.cjs"),m={database:null,lastUpdated:null,databaseUnavailable:!1};var u=new WeakMap,p=new WeakMap,h=new WeakMap,g=new WeakMap,k=new WeakMap,y=new WeakMap,w=new WeakSet;class x extends o.BaseController{constructor({messenger:e,state:t,url:a={registry:"https://acl.execution.metamask.io/latest/registry.json",signature:"https://acl.execution.metamask.io/latest/signature.json"},publicKey:n="0x025b65308f0f0fb8bc7f7ff87bfc296e0330eee5d3c1d1ee4a048b2fd6a86fa0a6",fetchFunction:o=globalThis.fetch.bind(undefined),recentFetchThreshold:c=(0,l.inMilliseconds)(5,l.Duration.Minute),refetchOnAllowlistMiss:d=!0}){var b,x;super({messenger:e,metadata:{database:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!0},lastUpdated:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1},databaseUnavailable:{includeInStateLogs:!0,persist:!0,anonymous:!1,usedInUi:!1}},name:"SnapsRegistry",state:{...m,...t}}),s(b=this,x=w),x.add(b),f(this,u,void 0),f(this,p,void 0),f(this,h,void 0),f(this,g,void 0),f(this,k,void 0),f(this,y,void 0),i(u,this,a),i(p,this,n),i(h,this,o),i(g,this,c),i(k,this,d),i(y,this,null),this.messagingSystem.registerActionHandler("SnapsRegistry:get",async(...e)=>r(w,this,T).call(this,...e)),this.messagingSystem.registerActionHandler("SnapsRegistry:getMetadata",(...e)=>r(w,this,O).call(this,...e)),this.messagingSystem.registerActionHandler("SnapsRegistry:resolveVersion",async(...e)=>r(w,this,E).call(this,...e)),this.messagingSystem.registerActionHandler("SnapsRegistry:update",async()=>r(w,this,S).call(this))}}function v(){return this.state.lastUpdated&&Date.now()-this.state.lastUpdated<n(g,this)}async function S(){n(y,this)?await n(y,this):(null===n(y,this)&&i(y,this,r(w,this,_).call(this)),await n(y,this),i(y,this,null))}async function _(){if(!r(w,this,v).call(this))try{const[e,t]=await Promise.all([r(w,this,I).call(this,n(u,this).registry),r(w,this,I).call(this,n(u,this).signature)]);r(w,this,M).call(this,e,t),this.update(t=>{t.database=JSON.parse(e),t.lastUpdated=Date.now(),t.databaseUnavailable=!1})}catch{this.update(e=>{e.databaseUnavailable=!0})}}async function j(){return null===this.state.database&&await r(w,this,S).call(this),this.state.database}async function P(e,t,a=!1){var f;const s=await r(w,this,j).call(this),i=null==s?void 0:s.blockedSnaps.find(a=>"id"in a?a.id===e&&(0,l.satisfiesVersionRange)(t.version,a.versionRange):a.checksum===t.checksum);if(i)return{status:b.SnapsRegistryStatus.Blocked,reason:i.reason};const o=null==s?void 0:s.verifiedSnaps[e],c=null==o||null===(f=o.versions)||void 0===f?void 0:f[t.version];return c&&c.checksum===t.checksum?{status:b.SnapsRegistryStatus.Verified}:n(k,this)&&!a?(await r(w,this,S).call(this),r(w,this,P).call(this,e,t,!0)):{status:this.state.databaseUnavailable?b.SnapsRegistryStatus.Unavailable:b.SnapsRegistryStatus.Unverified}}async function T(e){return Object.entries(e).reduce(async(e,[t,a])=>{const f=await r(w,this,P).call(this,t,a),s=await e;return s[t]=f,s},Promise.resolve({}))}async function E(e,t,a=!1){var f;const s=await r(w,this,j).call(this),i=(null==s||null===(f=s.verifiedSnaps[e])||void 0===f?void 0:f.versions)??null;if(!i&&n(k,this)&&!a)return await r(w,this,S).call(this),r(w,this,E).call(this,e,t,!0);if(!i)return t;const o=(0,d.getTargetVersion)(Object.keys(i),t);return o||!n(k,this)||a?o?((0,l.assertIsSemVerRange)(o),o):t:(await r(w,this,S).call(this),r(w,this,E).call(this,e,t,!0))}function O(e){var t;return(null===(t=this.state)||void 0===t||null===(t=t.database)||void 0===t||null===(t=t.verifiedSnaps[e])||void 0===t?void 0:t.metadata)??null}function M(e,t){(0,l.assert)(n(p,this),"No public key provided.");const a=(0,c.verify)({registry:e,signature:JSON.parse(t),publicKey:n(p,this)});(0,l.assert)(a,"Invalid registry signature.")}async function I(e){const t=await n(h,this).call(this,e);if(!t.ok)throw new Error(`Failed to fetch ${e}.`);return await t.text()}a.JsonSnapsRegistry=x}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f;Object.defineProperty(a,"__esModule",{value:!0}),a.SnapsRegistryStatus=void 0,function(e){e[e.Unverified=0]="Unverified",e[e.Blocked=1]="Blocked",e[e.Verified=2]="Verified",e[e.Unavailable=3]="Unavailable"}(f||(a.SnapsRegistryStatus=f={}))}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getRunnableSnaps=void 0;a.getRunnableSnaps=e=>e.filter(e=>e.enabled&&!e.blocked)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs",{"./snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","fast-deep-equal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-deep-equal/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.isLocalSnapId=a.isTrackableHandler=a.throttleTracking=a.TRACKABLE_HANDLERS=a.debouncePersistState=a.fetchSnap=a.getSnapFiles=a.withTimeout=a.hasTimedOut=a.delayWithTimer=a.delay=a.permissionsDiff=a.setDiff=void 0;const s=e("@metamask/snaps-sdk"),n=e("@metamask/snaps-utils"),i=f(e("fast-deep-equal")),r=e("./snaps/Timer.cjs");function o(e,t){let a;const f=new Promise((f,s)=>{e.start(()=>{t===undefined?f():f(t)}),a=s});return f.cancel=()=>{"finished"!==e.status&&(e.cancel(),a(new Error("The delay has been canceled.")))},f}async function c(e,t){return t&&0!==t.length?await Promise.all(t.map(async t=>e.fetch(t))):[]}a.setDiff=function(e,t){return Object.entries(e).reduce((e,[a,f])=>(a in t||(e[a]=f),e),{})},a.permissionsDiff=function(e,t){return Object.entries(e).reduce((e,[a,f])=>{const s=a in t;return(!s||s&&!(0,i.default)(f.caveats??[],t[a].caveats??[]))&&(e[a]=f),e},{})},a.delay=function(e,t){return o(new r.Timer(e),t)},a.delayWithTimer=o,a.hasTimedOut=Symbol("Used to check if the requested promise has timeout (see withTimeout)"),a.withTimeout=async function(e,t){const f=o("number"==typeof t?new r.Timer(t):t,a.hasTimedOut);try{return await Promise.race([e,f])}finally{f.cancel()}},a.getSnapFiles=c,a.fetchSnap=async function(e,t){try{const e=await t.manifest(),a=await t.fetch(e.result.source.location.npm.filePath);(0,s.assert)(a.size<n.MAX_FILE_SIZE,"Snap source code must be smaller than 64 MB.");const{iconPath:f}=e.result.source.location.npm,i=f?await t.fetch(f):undefined,r=await c(t,e.result.source.files);(0,n.validateAuxiliaryFiles)(r),await Promise.all(r.map(async e=>{e.data.base64=await(0,n.encodeBase64)(e)}));const o=await c(t,e.result.source.locales),d={manifest:e,sourceCode:a,svgIcon:i,auxiliaryFiles:r,localizationFiles:(0,n.getValidatedLocalizationFiles)(o)};return await(0,n.validateFetchedSnap)(d),d}catch(t){throw new Error(`Failed to fetch snap "${e}": ${(0,s.getErrorMessage)(t)}.`)}},a.debouncePersistState=function(e,t=1e3){const a=new Map;return(f,s,n)=>{const i=`${f}-${n}`;a.has(i)&&clearTimeout(a.get(i)),a.set(i,setTimeout(()=>{e(f,s,n),a.delete(i)},t))}},a.TRACKABLE_HANDLERS=Object.freeze([n.HandlerType.OnHomePage,n.HandlerType.OnInstall,n.HandlerType.OnNameLookup,n.HandlerType.OnRpcRequest,n.HandlerType.OnSignature,n.HandlerType.OnTransaction,n.HandlerType.OnUpdate]),a.throttleTracking=function(e,t=6e4){const a=new Map,f=new Map;return(s,n,i,r)=>{const o=`${s}${n}${i}${r}`,c=Date.now(),d=a.get(o)??0,l=[s,n,i,r];if(c-d>=t)return a.set(o,c),void e(...l);const b=f.get(o);null!=b&&b.timer&&clearTimeout(b.timer),a.set(o,c),f.set(o,{args:l,timer:setTimeout(()=>{e(...l),f.delete(o)},t)})}},a.isTrackableHandler=function(e){return a.TRACKABLE_HANDLERS.includes(e)},a.isLocalSnapId=function(e){return e.startsWith("local:")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){function f(e,t,a){s(e,t),t.set(e,a)}function s(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function n(e,t,a){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var a=e[Symbol.toPrimitive];if(void 0!==a){var f=a.call(e,t||"default");if("object"!=typeof f)return f;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}function i(e,t){return e.get(o(e,t))}function r(e,t,a){return e.set(o(e,t),a),a}function o(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}Object.defineProperty(a,"__esModule",{value:!0}),a.WebSocketService=void 0;const c=e("@metamask/rpc-errors"),d=e("@metamask/snaps-utils"),l=e("@metamask/utils"),b=e("nanoid"),m=e("../snaps/index.cjs"),u="WebSocketService";var p=new WeakMap,h=new WeakMap,g=new WeakSet;function k(e,t){const a=i(h,this).get(t);return(0,l.assert)(a&&a.snapId===e,`Socket with ID "${t}" not found.`),a}function y(e,t,a){return o(g,this,j).call(this,e).some(e=>e.url===t&&(0,d.isEqual)(e.protocols,a))}function w(e,t){i(p,this).call("SnapController:handleRequest",{origin:m.METAMASK_ORIGIN,snapId:e,handler:d.HandlerType.OnWebSocketEvent,request:{method:"",params:{event:t}}}).catch(t=>{(0,d.logError)(`An error occurred while handling a WebSocket message for Snap "${e}":`,t)})}async function x(e,t,a=[]){(0,l.assert)(!o(g,this,y).call(this,e,t,a),`An open WebSocket connection to ${t} already exists.`);const f=new URL(t),{origin:s}=f,n=(0,b.nanoid)(),r=new WebSocket(t,a);r.binaryType="arraybuffer";const{promise:d,resolve:m,reject:u}=(0,l.createDeferredPromise)();r.addEventListener("open",()=>{m(),o(g,this,w).call(this,e,{type:"open",id:n,origin:s})}),r.addEventListener("close",t=>{i(h,this).delete(n),o(g,this,w).call(this,e,{type:"close",id:n,origin:s,code:t.code,reason:t.reason,wasClean:t.wasClean??null})});const p=()=>{u(c.rpcErrors.resourceUnavailable("An error occurred while opening the WebSocket."))};return r.addEventListener("error",p),r.addEventListener("message",t=>{const a="string"==typeof t.data?{type:"text",message:t.data}:{type:"binary",message:Array.from(new Uint8Array(t.data))};o(g,this,w).call(this,e,{type:"message",id:n,origin:s,data:a})}),i(h,this).set(n,{id:n,snapId:e,url:t,protocols:a,socket:r,openPromise:d}),await d,r.removeEventListener("error",p),n}function v(e,t){const{socket:a}=o(g,this,k).call(this,e,t);a.close()}function S(e){for(const t of o(g,this,j).call(this,e))o(g,this,v).call(this,e,t.id)}async function _(e,t,a){const{socket:f,openPromise:s}=o(g,this,k).call(this,e,t);await s;const n=Array.isArray(a)?new Uint8Array(a):a;f.send(n)}function j(e){return[...i(h,this).values()].filter(t=>t.snapId===e).map(e=>({id:e.id,url:e.url,protocols:e.protocols}))}a.WebSocketService=class{constructor({messenger:e}){var t,a;s(t=this,a=g),a.add(t),n(this,"name",u),n(this,"state",null),f(this,p,void 0),f(this,h,void 0),r(p,this,e),r(h,this,new Map),i(p,this).registerActionHandler(`${u}:open`,async(...e)=>o(g,this,x).call(this,...e)),i(p,this).registerActionHandler(`${u}:close`,(...e)=>o(g,this,v).call(this,...e)),i(p,this).registerActionHandler(`${u}:sendMessage`,async(...e)=>o(g,this,_).call(this,...e)),i(p,this).registerActionHandler(`${u}:getAll`,(...e)=>o(g,this,j).call(this,...e)),i(p,this).subscribe("SnapController:snapUpdated",e=>{o(g,this,S).call(this,e.id)}),i(p,this).subscribe("SnapController:snapUninstalled",e=>{o(g,this,S).call(this,e.id)}),i(p,this).subscribe("SnapController:snapInstalled",e=>{o(g,this,S).call(this,e.id)})}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs",{"./WebSocketService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]},s=function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./WebSocketService.cjs"),a)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","buffer-from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/buffer-from/index.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js",typedarray:"/home/runner/work/metamask-extension/metamask-extension/node_modules/typedarray/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(a){(function(){var f=e("readable-stream").Writable,s=e("inherits"),n=e("buffer-from");if("undefined"==typeof Uint8Array)var i=e("typedarray").Uint8Array;else i=Uint8Array;function r(e,t){if(!(this instanceof r))return new r(e,t);"function"==typeof e&&(t=e,e={}),e||(e={});var a=e.encoding,s=!1;a?"u8"!==(a=String(a).toLowerCase())&&"uint8"!==a||(a="uint8array"):s=!0,f.call(this,{objectMode:!0}),this.encoding=a,this.shouldInferEncoding=s,t&&this.on("finish",function(){t(this.getBody())}),this.body=[]}t.exports=r,s(r,f),r.prototype._write=function(e,t,a){this.body.push(e),a()},r.prototype.inferEncoding=function(e){var t=e===undefined?this.body[0]:e;return a.isBuffer(t)?"buffer":"undefined"!=typeof Uint8Array&&t instanceof Uint8Array?"uint8array":Array.isArray(t)?"array":"string"==typeof t?"string":"[object Object]"===Object.prototype.toString.call(t)?"object":"buffer"},r.prototype.getBody=function(){return this.encoding||0!==this.body.length?(this.shouldInferEncoding&&(this.encoding=this.inferEncoding()),"array"===this.encoding?function(e){for(var t=[],a=0;a<e.length;a++)t.push.apply(t,e[a]);return t}(this.body):"string"===this.encoding?function(e){for(var t=[],f=0;f<e.length;f++){var s=e[f];"string"==typeof s||a.isBuffer(s)?t.push(s):o(s)?t.push(n(s)):t.push(n(String(s)))}t=a.isBuffer(e[0])?(t=a.concat(t)).toString("utf8"):t.join("");return t}(this.body):"buffer"===this.encoding?function(e){for(var t=[],f=0;f<e.length;f++){var s=e[f];a.isBuffer(s)?t.push(s):o(s)?t.push(n(s)):t.push(n(String(s)))}return a.concat(t)}(this.body):"uint8array"===this.encoding?function(e){for(var t=0,a=0;a<e.length;a++)"string"==typeof e[a]&&(e[a]=n(e[a])),t+=e[a].length;for(var f=new i(t),s=(a=0,0);a<e.length;a++)for(var r=e[a],o=0;o<r.length;o++)f[s++]=r[o];return f}(this.body):this.body):[]};Array.isArray;function o(e){return"string"==typeof e||(t=e,/Array\]$/.test(Object.prototype.toString.call(t)))||e&&"function"==typeof e.subarray;var t}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/snaps-controllers>concat-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js",{fs:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){const f={S_IFMT:61440,S_IFDIR:16384,S_IFCHR:8192,S_IFBLK:24576,S_IFIFO:4096,S_IFLNK:40960};try{t.exports=e("fs").constants||f}catch{t.exports=f}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js",{"./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js","fast-fifo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-fifo/index.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){const{Writable:f,Readable:s,getStreamError:n}=e("streamx"),i=e("fast-fifo"),r=e("b4a"),o=e("./headers"),c=r.alloc(0);class d{constructor(){this.buffered=0,this.shifted=0,this.queue=new i,this._offset=0}push(e){this.buffered+=e.byteLength,this.queue.push(e)}shiftFirst(e){return 0===this._buffered?null:this._next(e)}shift(e){if(e>this.buffered)return null;if(0===e)return c;let t=this._next(e);if(e===t.byteLength)return t;const a=[t];for(;(e-=t.byteLength)>0;)t=this._next(e),a.push(t);return r.concat(a)}_next(e){const t=this.queue.peek(),a=t.byteLength-this._offset;if(e>=a){const e=this._offset?t.subarray(this._offset,t.byteLength):t;return this.queue.shift(),this._offset=0,this.buffered-=a,this.shifted+=a,e}return this.buffered-=e,this.shifted+=e,t.subarray(this._offset,this._offset+=e)}}class l extends s{constructor(e,t,a){super(),this.header=t,this.offset=a,this._parent=e}_read(e){0===this.header.size&&this.push(null),this._parent._stream===this&&this._parent._update(),e(null)}_predestroy(){this._parent.destroy(n(this))}_detach(){this._parent._stream===this&&(this._parent._stream=null,this._parent._missing=u(this.header.size),this._parent._update())}_destroy(e){this._detach(),e(null)}}class b extends f{constructor(e){super(e),e||(e={}),this._buffer=new d,this._offset=0,this._header=null,this._stream=null,this._missing=0,this._longHeader=!1,this._callback=m,this._locked=!1,this._finished=!1,this._pax=null,this._paxGlobal=null,this._gnuLongPath=null,this._gnuLongLinkPath=null,this._filenameEncoding=e.filenameEncoding||"utf-8",this._allowUnknownFormat=!!e.allowUnknownFormat,this._unlockBound=this._unlock.bind(this)}_unlock(e){if(this._locked=!1,e)return this.destroy(e),void this._continueWrite(e);this._update()}_consumeHeader(){if(this._locked)return!1;this._offset=this._buffer.shifted;try{this._header=o.decode(this._buffer.shift(512),this._filenameEncoding,this._allowUnknownFormat)}catch(e){return this._continueWrite(e),!1}if(!this._header)return!0;switch(this._header.type){case"gnu-long-path":case"gnu-long-link-path":case"pax-global-header":case"pax-header":return this._longHeader=!0,this._missing=this._header.size,!0}return this._locked=!0,this._applyLongHeaders(),0===this._header.size||"directory"===this._header.type?(this.emit("entry",this._header,this._createStream(),this._unlockBound),!0):(this._stream=this._createStream(),this._missing=this._header.size,this.emit("entry",this._header,this._stream,this._unlockBound),!0)}_applyLongHeaders(){this._gnuLongPath&&(this._header.name=this._gnuLongPath,this._gnuLongPath=null),this._gnuLongLinkPath&&(this._header.linkname=this._gnuLongLinkPath,this._gnuLongLinkPath=null),this._pax&&(this._pax.path&&(this._header.name=this._pax.path),this._pax.linkpath&&(this._header.linkname=this._pax.linkpath),this._pax.size&&(this._header.size=parseInt(this._pax.size,10)),this._header.pax=this._pax,this._pax=null)}_decodeLongHeader(e){switch(this._header.type){case"gnu-long-path":this._gnuLongPath=o.decodeLongPath(e,this._filenameEncoding);break;case"gnu-long-link-path":this._gnuLongLinkPath=o.decodeLongPath(e,this._filenameEncoding);break;case"pax-global-header":this._paxGlobal=o.decodePax(e);break;case"pax-header":this._pax=null===this._paxGlobal?o.decodePax(e):Object.assign({},this._paxGlobal,o.decodePax(e))}}_consumeLongHeader(){this._longHeader=!1,this._missing=u(this._header.size);const e=this._buffer.shift(this._header.size);try{this._decodeLongHeader(e)}catch(e){return this._continueWrite(e),!1}return!0}_consumeStream(){const e=this._buffer.shiftFirst(this._missing);if(null===e)return!1;this._missing-=e.byteLength;const t=this._stream.push(e);return 0===this._missing?(this._stream.push(null),t&&this._stream._detach(),t&&!1===this._locked):t}_createStream(){return new l(this,this._header,this._offset)}_update(){for(;this._buffer.buffered>0&&!this.destroying;){if(this._missing>0){if(null!==this._stream){if(!1===this._consumeStream())return;continue}if(!0===this._longHeader){if(this._missing>this._buffer.buffered)break;if(!1===this._consumeLongHeader())return!1;continue}const e=this._buffer.shiftFirst(this._missing);null!==e&&(this._missing-=e.byteLength);continue}if(this._buffer.buffered<512)break;if(null!==this._stream||!1===this._consumeHeader())return}this._continueWrite(null)}_continueWrite(e){const t=this._callback;this._callback=m,t(e)}_write(e,t){this._callback=t,this._buffer.push(e),this._update()}_final(e){this._finished=0===this._missing&&0===this._buffer.buffered,e(this._finished?null:new Error("Unexpected end of data"))}_predestroy(){this._continueWrite(null)}_destroy(e){this._stream&&this._stream.destroy(n(this)),e(null)}[Symbol.asyncIterator](){let e=null,t=null,a=null,f=null,s=null;const n=this;return this.on("entry",function(e,n,i){s=i,n.on("error",m),t?(t({value:n,done:!1}),t=a=null):f=n}),this.on("error",t=>{e=t}),this.on("close",function(){if(i(e),!t)return;e?a(e):t({value:undefined,done:!0});t=a=null}),{[Symbol.asyncIterator](){return this},next:()=>new Promise(r),return:()=>o(null),throw:e=>o(e)};function i(e){if(!s)return;const t=s;s=null,t(e)}function r(s,r){return e?r(e):f?(s({value:f,done:!1}),void(f=null)):(t=s,a=r,i(null),void(n._finished&&t&&(t({value:undefined,done:!0}),t=a=null)))}function o(e){return n.destroy(e),i(e),new Promise((t,a)=>{if(n.destroyed)return t({value:undefined,done:!0});n.once("close",function(){e?a(e):t({value:undefined,done:!0})})})}}}function m(){}function u(e){return(e&=511)&&512-e}t.exports=function(e){return new b(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",{b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){const f=e("b4a"),s="0".charCodeAt(0),n=f.from([117,115,116,97,114,0]),i=f.from([s,s]),r=f.from([117,115,116,97,114,32]),o=f.from([32,0]),c=257,d=263;function l(e,t,a,f){for(;a<f;a++)if(e[a]===t)return a;return f}function b(e){let t=256;for(let a=0;a<148;a++)t+=e[a];for(let a=156;a<512;a++)t+=e[a];return t}function m(e,t){return(e=e.toString(8)).length>t?"7777777777777777777".slice(0,t)+" ":"0000000000000000000".slice(0,t-e.length)+e+" "}function u(e,t,a){if(128&(e=e.subarray(t,t+a))[t=0])return function(e){let t;if(128===e[0])t=!0;else{if(255!==e[0])return null;t=!1}const a=[];let f;for(f=e.length-1;f>0;f--){const s=e[f];t?a.push(s):a.push(255-s)}let s=0;const n=a.length;for(f=0;f<n;f++)s+=a[f]*Math.pow(256,f);return t?s:-1*s}(e);{for(;t<e.length&&32===e[t];)t++;const a=(s=l(e,32,t,e.length),n=e.length,i=e.length,"number"!=typeof s?i:(s=~~s)>=n?n:s>=0||(s+=n)>=0?s:0);for(;t<a&&0===e[t];)t++;return a===t?0:parseInt(f.toString(e.subarray(t,a)),8)}var s,n,i}function p(e,t,a,s){return f.toString(e.subarray(t,l(e,0,t,t+a)),s)}function h(e){const t=f.byteLength(e);let a=Math.floor(Math.log(t)/Math.log(10))+1;return t+a>=Math.pow(10,a)&&a++,t+a+e}a.decodeLongPath=function(e,t){return p(e,0,e.length,t)},a.encodePax=function(e){let t="";e.name&&(t+=h(" path="+e.name+"\n")),e.linkname&&(t+=h(" linkpath="+e.linkname+"\n"));const a=e.pax;if(a)for(const e in a)t+=h(" "+e+"="+a[e]+"\n");return f.from(t)},a.decodePax=function(e){const t={};for(;e.length;){let a=0;for(;a<e.length&&32!==e[a];)a++;const s=parseInt(f.toString(e.subarray(0,a)),10);if(!s)return t;const n=f.toString(e.subarray(a+1,s-1)),i=n.indexOf("=");if(-1===i)return t;t[n.slice(0,i)]=n.slice(i+1),e=e.subarray(s)}return t},a.encode=function(e){const t=f.alloc(512);let a=e.name,r="";if(5===e.typeflag&&"/"!==a[a.length-1]&&(a+="/"),f.byteLength(a)!==a.length)return null;for(;f.byteLength(a)>100;){const e=a.indexOf("/");if(-1===e)return null;r+=r?"/"+a.slice(0,e):a.slice(0,e),a=a.slice(e+1)}return f.byteLength(a)>100||f.byteLength(r)>155||e.linkname&&f.byteLength(e.linkname)>100?null:(f.write(t,a),f.write(t,m(4095&e.mode,6),100),f.write(t,m(e.uid,6),108),f.write(t,m(e.gid,6),116),function(e,t,a){e.toString(8).length>11?function(e,t,a){t[a]=128;for(let f=11;f>0;f--)t[a+f]=255&e,e=Math.floor(e/256)}(e,t,a):f.write(t,m(e,11),a)}(e.size,t,124),f.write(t,m(e.mtime.getTime()/1e3|0,11),136),t[156]=s+function(e){switch(e){case"file":return 0;case"link":return 1;case"symlink":return 2;case"character-device":return 3;case"block-device":return 4;case"directory":return 5;case"fifo":return 6;case"contiguous-file":return 7;case"pax-header":return 72}return 0}(e.type),e.linkname&&f.write(t,e.linkname,157),f.copy(n,t,c),f.copy(i,t,263),e.uname&&f.write(t,e.uname,265),e.gname&&f.write(t,e.gname,297),f.write(t,m(e.devmajor||0,6),329),f.write(t,m(e.devminor||0,6),337),r&&f.write(t,r,345),f.write(t,m(b(t),6),148),t)},a.decode=function(e,t,a){let i=0===e[156]?0:e[156]-s,l=p(e,0,100,t);const m=u(e,100,8),h=u(e,108,8),g=u(e,116,8),k=u(e,124,12),y=u(e,136,12),w=function(e){switch(e){case 0:return"file";case 1:return"link";case 2:return"symlink";case 3:return"character-device";case 4:return"block-device";case 5:return"directory";case 6:return"fifo";case 7:return"contiguous-file";case 72:return"pax-header";case 55:return"pax-global-header";case 27:return"gnu-long-link-path";case 28:case 30:return"gnu-long-path"}return null}(i),x=0===e[157]?null:p(e,157,100,t),v=p(e,265,32),S=p(e,297,32),_=u(e,329,8),j=u(e,337,8),P=b(e);if(256===P)return null;if(P!==u(e,148,8))throw new Error("Invalid tar header. Maybe the tar is corrupted or it needs to be gunzipped?");if(function(e){return f.equals(n,e.subarray(c,263))}(e))e[345]&&(l=p(e,345,155,t)+"/"+l);else if(function(e){return f.equals(r,e.subarray(c,263))&&f.equals(o,e.subarray(d,265))}(e));else if(!a)throw new Error("Invalid tar header: unknown format.");return 0===i&&l&&"/"===l[l.length-1]&&(i=5),{name:l,mode:m,uid:h,gid:g,size:k,mtime:new Date(1e3*y),type:w,linkname:x,uname:v,gname:S,devmajor:_,devminor:j,pax:null}}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js",{"./extract":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js","./pack":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){a.extract=e("./extract"),a.pack=e("./pack")}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js","./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){const{Readable:f,Writable:s,getStreamError:n}=e("streamx"),i=e("b4a"),r=e("./constants"),o=e("./headers"),c=i.alloc(1024);class d extends s{constructor(e,t,a){super({mapWritable:u,eagerOpen:!0}),this.written=0,this.header=t,this._callback=a,this._linkname=null,this._isLinkname="symlink"===t.type&&!t.linkname,this._isVoid="file"!==t.type&&"contiguous-file"!==t.type,this._finished=!1,this._pack=e,this._openCallback=null,null===this._pack._stream?this._pack._stream=this:this._pack._pending.push(this)}_open(e){this._openCallback=e,this._pack._stream===this&&this._continueOpen()}_continuePack(e){if(null===this._callback)return;const t=this._callback;this._callback=null,t(e)}_continueOpen(){null===this._pack._stream&&(this._pack._stream=this);const e=this._openCallback;if(this._openCallback=null,null!==e){if(this._pack.destroying)return e(new Error("pack stream destroyed"));if(this._pack._finalized)return e(new Error("pack stream is already finalized"));this._pack._stream=this,this._isLinkname||this._pack._encode(this.header),this._isVoid&&(this._finish(),this._continuePack(null)),e(null)}}_write(e,t){return this._isLinkname?(this._linkname=this._linkname?i.concat([this._linkname,e]):e,t(null)):this._isVoid?e.byteLength>0?t(new Error("No body allowed for this entry")):t():(this.written+=e.byteLength,this._pack.push(e)?t():void(this._pack._drain=t))}_finish(){this._finished||(this._finished=!0,this._isLinkname&&(this.header.linkname=this._linkname?i.toString(this._linkname,"utf-8"):"",this._pack._encode(this.header)),m(this._pack,this.header.size),this._pack._done(this))}_final(e){if(this.written!==this.header.size)return e(new Error("Size mismatch"));this._finish(),e(null)}_getError(){return n(this)||new Error("tar entry destroyed")}_predestroy(){this._pack.destroy(this._getError())}_destroy(e){this._pack._done(this),this._continuePack(this._finished?null:this._getError()),e()}}class l extends f{constructor(e){super(e),this._drain=b,this._finalized=!1,this._finalizing=!1,this._pending=[],this._stream=null}entry(e,t,a){if(this._finalized||this.destroying)throw new Error("already finalized or destroyed");"function"==typeof t&&(a=t,t=null),a||(a=b),e.size&&"symlink"!==e.type||(e.size=0),e.type||(e.type=function(e){switch(e&r.S_IFMT){case r.S_IFBLK:return"block-device";case r.S_IFCHR:return"character-device";case r.S_IFDIR:return"directory";case r.S_IFIFO:return"fifo";case r.S_IFLNK:return"symlink"}return"file"}(e.mode)),e.mode||(e.mode="directory"===e.type?493:420),e.uid||(e.uid=0),e.gid||(e.gid=0),e.mtime||(e.mtime=new Date),"string"==typeof t&&(t=i.from(t));const f=new d(this,e,a);return i.isBuffer(t)?(e.size=t.byteLength,f.write(t),f.end(),f):(f._isVoid,f)}finalize(){this._stream||this._pending.length>0?this._finalizing=!0:this._finalized||(this._finalized=!0,this.push(c),this.push(null))}_done(e){e===this._stream&&(this._stream=null,this._finalizing&&this.finalize(),this._pending.length&&this._pending.shift()._continueOpen())}_encode(e){if(!e.pax){const t=o.encode(e);if(t)return void this.push(t)}this._encodePax(e)}_encodePax(e){const t=o.encodePax({name:e.name,linkname:e.linkname,pax:e.pax}),a={name:"PaxHeader",mode:e.mode,uid:e.uid,gid:e.gid,size:t.byteLength,mtime:e.mtime,type:"pax-header",linkname:e.linkname&&"PaxHeader",uname:e.uname,gname:e.gname,devmajor:e.devmajor,devminor:e.devminor};this.push(o.encode(a)),this.push(t),m(this,t.byteLength),a.size=e.size,a.type=e.type,this.push(o.encode(a))}_doDrain(){const e=this._drain;this._drain=b,e()}_predestroy(){const e=n(this);for(this._stream&&this._stream.destroy(e);this._pending.length;){const t=this._pending.shift();t.destroy(e),t._continueOpen()}this._doDrain()}_read(e){this._doDrain(),e()}}function b(){}function m(e,t){(t&=511)&&e.push(c.subarray(0,512-t))}function u(e){return i.isBuffer(e)?e:i.from(e)}t.exports=function(e){return new l(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/index.js",{"./verify":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/verify.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__createBinding||(Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]}),s=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),a.SnapsRegistryDatabaseStruct=a.BlockedSnapStruct=a.BlockReasonStruct=a.VerifiedSnapStruct=a.ImagePathStruct=a.AdditionalSourceCodeStruct=a.SupportStruct=a.AuditStruct=a.AuthorStruct=void 0;const n=e("@metamask/superstruct"),i=e("@metamask/utils"),r=(0,n.refine)((0,n.string)(),"Npm ID",e=>e.startsWith("npm:")),o=(0,n.object)({checksum:i.ChecksumStruct});a.AuthorStruct=(0,n.object)({name:(0,n.string)(),website:(0,n.string)()}),a.AuditStruct=(0,n.object)({auditor:(0,n.string)(),report:(0,n.string)()}),a.SupportStruct=(0,n.object)({knowledgeBase:(0,n.optional)((0,n.string)()),faq:(0,n.optional)((0,n.string)()),contact:(0,n.optional)((0,n.string)()),keyRecovery:(0,n.optional)((0,n.string)())}),a.AdditionalSourceCodeStruct=(0,n.object)({name:(0,n.string)(),url:(0,n.string)()}),a.ImagePathStruct=(0,n.pattern)((0,n.string)(),/\.\/images\/.*\/\d+\.(?:png|jpe?g)$/u),a.VerifiedSnapStruct=(0,n.object)({id:r,metadata:(0,n.object)({name:(0,n.string)(),type:(0,n.optional)((0,n.enums)(["account"])),author:(0,n.optional)(a.AuthorStruct),website:(0,n.optional)((0,n.string)()),onboard:(0,n.optional)((0,n.boolean)()),summary:(0,n.optional)((0,n.string)()),description:(0,n.optional)((0,n.string)()),audits:(0,n.optional)((0,n.array)(a.AuditStruct)),category:(0,n.optional)((0,n.enums)(["interoperability","notifications","transaction insights","account management","name resolution"])),tags:(0,n.optional)((0,n.array)((0,n.string)())),support:(0,n.optional)(a.SupportStruct),sourceCode:(0,n.optional)((0,n.string)()),hidden:(0,n.optional)((0,n.boolean)()),privateCode:(0,n.optional)((0,n.boolean)()),privacyPolicy:(0,n.optional)((0,n.string)()),termsOfUse:(0,n.optional)((0,n.string)()),additionalSourceCode:(0,n.optional)((0,n.array)(a.AdditionalSourceCodeStruct)),screenshots:(0,n.optional)((0,n.size)((0,n.array)(a.ImagePathStruct),3,3))}),versions:(0,n.record)(i.VersionStruct,o)}),a.BlockReasonStruct=(0,n.object)({explanation:(0,n.optional)((0,n.string)()),url:(0,n.optional)((0,n.string)())}),a.BlockedSnapStruct=(0,n.union)([(0,n.object)({id:r,versionRange:i.VersionRangeStruct,reason:(0,n.optional)(a.BlockReasonStruct)}),(0,n.object)({checksum:i.ChecksumStruct,reason:(0,n.optional)(a.BlockReasonStruct)})]),a.SnapsRegistryDatabaseStruct=(0,n.object)({verifiedSnaps:(0,n.record)(r,a.VerifiedSnapStruct),blockedSnaps:(0,n.array)(a.BlockedSnapStruct)}),s(e("./verify"),a)}}},{package:"@metamask/snaps-utils>@metamask/snaps-registry",file:"node_modules/@metamask/snaps-registry/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/verify.js",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/secp256k1.js","@noble/hashes/sha256":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha256.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.verify=a.SignatureStruct=void 0;const f=e("@metamask/superstruct"),s=e("@metamask/utils"),n=e("@noble/curves/secp256k1"),i=e("@noble/hashes/sha256");a.SignatureStruct=(0,f.object)({signature:s.StrictHexStruct,curve:(0,f.literal)("secp256k1"),format:(0,f.literal)("DER")}),a.verify=function({registry:e,signature:t,publicKey:f}){(0,s.assertStruct)(t,a.SignatureStruct,"Invalid signature object");const r=(0,s.hexToBytes)(f);return n.secp256k1.verify((0,s.remove0x)(t.signature),(0,i.sha256)((0,s.stringToBytes)(e)),r)}}}},{package:"@metamask/snaps-utils>@metamask/snaps-registry",file:"node_modules/@metamask/snaps-registry/dist/verify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/test-dapp/dist/constants.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports={hstBytecode:"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",hstAbi:[{inputs:[{internalType:"uint256",name:"initialAmount",type:"uint256"},{internalType:"string",name:"tokenName",type:"string"},{internalType:"uint8",name:"decimalUnits",type:"uint8"},{internalType:"string",name:"tokenSymbol",type:"string"}],stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"address",name:"spender",type:"address"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"}],name:"Approval",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"previousOwner",type:"address"},{indexed:!0,internalType:"address",name:"newOwner",type:"address"}],name:"OwnershipTransferred",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"}],name:"Transfer",type:"event"},{inputs:[],name:"DOMAIN_SEPARATOR",outputs:[{internalType:"bytes32",name:"",type:"bytes32"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"address",name:"spender",type:"address"}],name:"allowance",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"amount",type:"uint256"}],name:"approve",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"}],name:"balanceOf",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[],name:"decimals",outputs:[{internalType:"uint8",name:"",type:"uint8"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"subtractedValue",type:"uint256"}],name:"decreaseAllowance",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"addedValue",type:"uint256"}],name:"increaseAllowance",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"amount",type:"uint256"}],name:"mint",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"name",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"}],name:"nonces",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[],name:"owner",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"uint256",name:"deadline",type:"uint256"},{internalType:"uint8",name:"v",type:"uint8"},{internalType:"bytes32",name:"r",type:"bytes32"},{internalType:"bytes32",name:"s",type:"bytes32"}],name:"permit",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"renounceOwnership",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"symbol",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[],name:"totalSupply",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"amount",type:"uint256"}],name:"transfer",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"amount",type:"uint256"}],name:"transferFrom",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"newOwner",type:"address"}],name:"transferOwnership",outputs:[],stateMutability:"nonpayable",type:"function"}],piggybankBytecode:"0x608060405234801561001057600080fd5b5033600160006101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff1602179055506000808190555061023b806100686000396000f300608060405260043610610057576000357c0100000000000000000000000000000000000000000000000000000000900463ffffffff1680632e1a7d4d1461005c5780638da5cb5b1461009d578063d0e30db0146100f4575b600080fd5b34801561006857600080fd5b5061008760048036038101908080359060200190929190505050610112565b6040518082815260200191505060405180910390f35b3480156100a957600080fd5b506100b26101d0565b604051808273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200191505060405180910390f35b6100fc6101f6565b6040518082815260200191505060405180910390f35b6000600160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff163373ffffffffffffffffffffffffffffffffffffffff1614151561017057600080fd5b8160008082825403925050819055503373ffffffffffffffffffffffffffffffffffffffff166108fc839081150290604051600060405180830381858888f193505050501580156101c5573d6000803e3d6000fd5b506000549050919050565b600160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1681565b60003460008082825401925050819055506000549050905600a165627a7a72305820f237db3ec816a52589d82512117bc85bc08d3537683ffeff9059108caf3e5d400029",piggybankAbi:[{constant:!1,inputs:[{name:"withdrawAmount",type:"uint256"}],name:"withdraw",outputs:[{name:"remainingBal",type:"uint256"}],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!0,inputs:[],name:"owner",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[],name:"deposit",outputs:[{name:"",type:"uint256"}],payable:!0,stateMutability:"payable",type:"function"},{inputs:[],payable:!1,stateMutability:"nonpayable",type:"constructor"}],nftsAbi:[{inputs:[],stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"address",name:"approved",type:"address"},{indexed:!0,internalType:"uint256",name:"tokenId",type:"uint256"}],name:"Approval",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!1,internalType:"bool",name:"approved",type:"bool"}],name:"ApprovalForAll",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!0,internalType:"uint256",name:"tokenId",type:"uint256"}],name:"Transfer",type:"event"},{inputs:[{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"tokenId",type:"uint256"}],name:"approve",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"}],name:"balanceOf",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[],name:"currentTokenId",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"tokenId",type:"uint256"}],name:"getApproved",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"address",name:"operator",type:"address"}],name:"isApprovedForAll",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"numberOfTokens",type:"uint256"}],name:"mintNFTs",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"name",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"tokenId",type:"uint256"}],name:"ownerOf",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"tokenId",type:"uint256"}],name:"safeTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"tokenId",type:"uint256"},{internalType:"bytes",name:"data",type:"bytes"}],name:"safeTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"operator",type:"address"},{internalType:"bool",name:"approved",type:"bool"}],name:"setApprovalForAll",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"bytes4",name:"interfaceId",type:"bytes4"}],name:"supportsInterface",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[],name:"symbol",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"tokenId",type:"uint256"}],name:"tokenURI",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"pure",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"tokenId",type:"uint256"}],name:"transferFrom",outputs:[],stateMutability:"nonpayable",type:"function"}],nftsBytecode:"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",failingContractAbi:[{payable:!0,stateMutability:"payable",type:"fallback"}],failingContractBytecode:"0x6080604052348015600f57600080fd5b50608b8061001e6000396000f3fe6080604052610fff3411600e57fe5b3373ffffffffffffffffffffffffffffffffffffffff166108fc349081150290604051600060405180830381858888f193505050501580156053573d6000803e3d6000fd5b5000fea265627a7a72315820631b0dbb6b871cdbfdec2773af15ebfb8e52c794cf836fe27ec21f1aed17180f64736f6c634300050c0032",multisigBytecode:"0x60806040523480156200001157600080fd5b50600060405180606001604052807307be9763a718c0539017e2ab6fc42853b4aeeb6b73ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001731c53dc20d1e36ed8359250de626acae36bd28a2973ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001733ebf9d63c3ae5d70b252a885d65168960102e7f873ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815250905060006001905060005b6003811015620002f65760008382600381106200011c576200011b62000306565b5b60200201519050600073ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff160362000195576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004016200018c9062000396565b60405180910390fd5b600160008273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff161562000225576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004016200021c9062000408565b60405180910390fd5b60018060008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81548160ff0219169083151502179055506000819080600181540180825580915050600190039060005260206000200160009091909190916101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff160217905550508080620002ed9062000463565b915050620000fa565b50806002819055505050620004b0565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052603260045260246000fd5b600082825260208201905092915050565b7f696e76616c6964206f776e657200000000000000000000000000000000000000600082015250565b60006200037e600d8362000335565b91506200038b8262000346565b602082019050919050565b60006020820190508181036000830152620003b1816200036f565b9050919050565b7f6f776e6572206e6f7420756e6971756500000000000000000000000000000000600082015250565b6000620003f060108362000335565b9150620003fd82620003b8565b602082019050919050565b600060208201905081810360008301526200042381620003e1565b9050919050565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052601160045260246000fd5b6000819050919050565b6000620004708262000459565b91507fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff8203620004a557620004a46200042a565b5b600182019050919050565b611e6b80620004c06000396000f3fe6080604052600436106100ab5760003560e01c80639ace38c2116100645780639ace38c214610253578063a0e67e2b14610294578063c01a8c84146102bf578063c6427474146102e8578063d0549b8514610311578063ee22610b1461033c57610102565b8063025e7c271461010757806320ea8d86146101445780632e7700f01461016d5780632f54bf6e1461019857806333ea3dc8146101d557806380f59a651461021657610102565b36610102573373ffffffffffffffffffffffffffffffffffffffff167f90890809c654f11d6e72a28fa60149770a0d11ec6c92319d6ceb2bb0a4ea1a1534476040516100f892919061116d565b60405180910390a2005b600080fd5b34801561011357600080fd5b5061012e600480360381019061012991906111d6565b610365565b60405161013b9190611244565b60405180910390f35b34801561015057600080fd5b5061016b600480360381019061016691906111d6565b6103a4565b005b34801561017957600080fd5b5061018261067e565b60405161018f919061125f565b60405180910390f35b3480156101a457600080fd5b506101bf60048036038101906101ba91906112a6565b61068b565b6040516101cc91906112ee565b60405180910390f35b3480156101e157600080fd5b506101fc60048036038101906101f791906111d6565b6106ab565b60405161020d959493929190611399565b60405180910390f35b34801561022257600080fd5b5061023d600480360381019061023891906113f3565b6107be565b60405161024a91906112ee565b60405180910390f35b34801561025f57600080fd5b5061027a600480360381019061027591906111d6565b6107ed565b60405161028b959493929190611399565b60405180910390f35b3480156102a057600080fd5b506102a96108e8565b6040516102b691906114f1565b60405180910390f35b3480156102cb57600080fd5b506102e660048036038101906102e191906111d6565b610976565b005b3480156102f457600080fd5b5061030f600480360381019061030a9190611648565b610c53565b005b34801561031d57600080fd5b50610326610e56565b604051610333919061125f565b60405180910390f35b34801561034857600080fd5b50610363600480360381019061035e91906111d6565b610e5c565b005b6000818154811061037557600080fd5b906000526020600020016000915054906101000a900473ffffffffffffffffffffffffffffffffffffffff1681565b600160003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16610430576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161042790611714565b60405180910390fd5b806004805490508110610478576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161046f90611780565b60405180910390fd5b816004818154811061048d5761048c6117a0565b5b906000526020600020906005020160030160009054906101000a900460ff16156104ec576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004016104e39061181b565b60405180910390fd5b600060048481548110610502576105016117a0565b5b906000526020600020906005020190506003600085815260200190815260200160002060003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff166105af576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004016105a690611887565b60405180910390fd5b60018160040160008282546105c491906118d6565b9250508190555060006003600086815260200190815260200160002060003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81548160ff021916908315150217905550833373ffffffffffffffffffffffffffffffffffffffff167ff0dca620e2e81f7841d07bcc105e1704fb01475b278a9d4c236e1c62945edd5560405160405180910390a350505050565b6000600480549050905090565b60016020528060005260406000206000915054906101000a900460ff1681565b60008060606000806000600487815481106106c9576106c86117a0565b5b906000526020600020906005020190508060000160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff168160010154826002018360030160009054906101000a900460ff16846004015482805461072a90611939565b80601f016020809104026020016040519081016040528092919081815260200182805461075690611939565b80156107a35780601f10610778576101008083540402835291602001916107a3565b820191906000526020600020905b81548152906001019060200180831161078657829003601f168201915b50505050509250955095509550955095505091939590929450565b60036020528160005260406000206020528060005260406000206000915091509054906101000a900460ff1681565b600481815481106107fd57600080fd5b90600052602060002090600502016000915090508060000160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff169080600101549080600201805461084c90611939565b80601f016020809104026020016040519081016040528092919081815260200182805461087890611939565b80156108c55780601f1061089a576101008083540402835291602001916108c5565b820191906000526020600020905b8154815290600101906020018083116108a857829003601f168201915b5050505050908060030160009054906101000a900460ff16908060040154905085565b6060600080548060200260200160405190810160405280929190818152602001828054801561096c57602002820191906000526020600020905b8160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019060010190808311610922575b5050505050905090565b600160003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16610a02576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004016109f990611714565b60405180910390fd5b806004805490508110610a4a576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610a4190611780565b60405180910390fd5b8160048181548110610a5f57610a5e6117a0565b5b906000526020600020906005020160030160009054906101000a900460ff1615610abe576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610ab59061181b565b60405180910390fd5b826003600082815260200190815260200160002060003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff1615610b5d576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610b54906119b6565b60405180910390fd5b600060048581548110610b7357610b726117a0565b5b906000526020600020906005020190506001816004016000828254610b9891906119d6565b9250508190555060016003600087815260200190815260200160002060003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81548160ff021916908315150217905550843373ffffffffffffffffffffffffffffffffffffffff167f5cbe105e36805f7820e291f799d5794ff948af2a5f664e580382defb6339004160405160405180910390a35050505050565b600160003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16610cdf576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610cd690611714565b60405180910390fd5b6000600480549050905060046040518060a001604052808673ffffffffffffffffffffffffffffffffffffffff1681526020018581526020018481526020016000151581526020016000815250908060018154018082558091505060019003906000526020600020906005020160009091909190915060008201518160000160006101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff160217905550602082015181600101556040820151816002019081610dbb9190611bb6565b5060608201518160030160006101000a81548160ff0219169083151502179055506080820151816004015550508373ffffffffffffffffffffffffffffffffffffffff16813373ffffffffffffffffffffffffffffffffffffffff167fd5a05bf70715ad82a09a756320284a1b54c9ff74cd0f8cce6219e79b563fe59d8686604051610e48929190611c88565b60405180910390a450505050565b60025481565b600160003373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16610ee8576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610edf90611714565b60405180910390fd5b806004805490508110610f30576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610f2790611780565b60405180910390fd5b8160048181548110610f4557610f446117a0565b5b906000526020600020906005020160030160009054906101000a900460ff1615610fa4576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401610f9b9061181b565b60405180910390fd5b600060048481548110610fba57610fb96117a0565b5b9060005260206000209060050201905060025481600401541015611013576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161100a90611d04565b60405180910390fd5b60018160030160006101000a81548160ff02191690831515021790555060008160000160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168260010154836002016040516110839190611db2565b60006040518083038185875af1925050503d80600081146110c0576040519150601f19603f3d011682016040523d82523d6000602084013e6110c5565b606091505b5050905080611109576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161110090611e15565b60405180910390fd5b843373ffffffffffffffffffffffffffffffffffffffff167f5445f318f4f5fcfb66592e68e0cc5822aa15664039bd5f0ffde24c5a8142b1ac60405160405180910390a35050505050565b6000819050919050565b61116781611154565b82525050565b6000604082019050611182600083018561115e565b61118f602083018461115e565b9392505050565b6000604051905090565b600080fd5b600080fd5b6111b381611154565b81146111be57600080fd5b50565b6000813590506111d0816111aa565b92915050565b6000602082840312156111ec576111eb6111a0565b5b60006111fa848285016111c1565b91505092915050565b600073ffffffffffffffffffffffffffffffffffffffff82169050919050565b600061122e82611203565b9050919050565b61123e81611223565b82525050565b60006020820190506112596000830184611235565b92915050565b6000602082019050611274600083018461115e565b92915050565b61128381611223565b811461128e57600080fd5b50565b6000813590506112a08161127a565b92915050565b6000602082840312156112bc576112bb6111a0565b5b60006112ca84828501611291565b91505092915050565b60008115159050919050565b6112e8816112d3565b82525050565b600060208201905061130360008301846112df565b92915050565b600081519050919050565b600082825260208201905092915050565b60005b83811015611343578082015181840152602081019050611328565b60008484015250505050565b6000601f19601f8301169050919050565b600061136b82611309565b6113758185611314565b9350611385818560208601611325565b61138e8161134f565b840191505092915050565b600060a0820190506113ae6000830188611235565b6113bb602083018761115e565b81810360408301526113cd8186611360565b90506113dc60608301856112df565b6113e9608083018461115e565b9695505050505050565b6000806040838503121561140a576114096111a0565b5b6000611418858286016111c1565b925050602061142985828601611291565b9150509250929050565b600081519050919050565b600082825260208201905092915050565b6000819050602082019050919050565b61146881611223565b82525050565b600061147a838361145f565b60208301905092915050565b6000602082019050919050565b600061149e82611433565b6114a8818561143e565b93506114b38361144f565b8060005b838110156114e45781516114cb888261146e565b97506114d683611486565b9250506001810190506114b7565b5085935050505092915050565b6000602082019050818103600083015261150b8184611493565b905092915050565b600080fd5b600080fd5b7f4e487b7100000000000000000000000000000000000000000000000000000000600052604160045260246000fd5b6115558261134f565b810181811067ffffffffffffffff821117156115745761157361151d565b5b80604052505050565b6000611587611196565b9050611593828261154c565b919050565b600067ffffffffffffffff8211156115b3576115b261151d565b5b6115bc8261134f565b9050602081019050919050565b82818337600083830152505050565b60006115eb6115e684611598565b61157d565b90508281526020810184848401111561160757611606611518565b5b6116128482856115c9565b509392505050565b600082601f83011261162f5761162e611513565b5b813561163f8482602086016115d8565b91505092915050565b600080600060608486031215611661576116606111a0565b5b600061166f86828701611291565b9350506020611680868287016111c1565b925050604084013567ffffffffffffffff8111156116a1576116a06111a5565b5b6116ad8682870161161a565b9150509250925092565b600082825260208201905092915050565b7f6e6f74206f776e65720000000000000000000000000000000000000000000000600082015250565b60006116fe6009836116b7565b9150611709826116c8565b602082019050919050565b6000602082019050818103600083015261172d816116f1565b9050919050565b7f747820646f6573206e6f74206578697374000000000000000000000000000000600082015250565b600061176a6011836116b7565b915061177582611734565b602082019050919050565b600060208201905081810360008301526117998161175d565b9050919050565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052603260045260246000fd5b7f747820616c726561647920657865637574656400000000000000000000000000600082015250565b60006118056013836116b7565b9150611810826117cf565b602082019050919050565b60006020820190508181036000830152611834816117f8565b9050919050565b7f7478206e6f7420636f6e6669726d656400000000000000000000000000000000600082015250565b60006118716010836116b7565b915061187c8261183b565b602082019050919050565b600060208201905081810360008301526118a081611864565b9050919050565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052601160045260246000fd5b60006118e182611154565b91506118ec83611154565b9250828203905081811115611904576119036118a7565b5b92915050565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052602260045260246000fd5b6000600282049050600182168061195157607f821691505b6020821081036119645761196361190a565b5b50919050565b7f747820616c726561647920636f6e6669726d6564000000000000000000000000600082015250565b60006119a06014836116b7565b91506119ab8261196a565b602082019050919050565b600060208201905081810360008301526119cf81611993565b9050919050565b60006119e182611154565b91506119ec83611154565b9250828201905080821115611a0457611a036118a7565b5b92915050565b60008190508160005260206000209050919050565b60006020601f8301049050919050565b600082821b905092915050565b600060088302611a6c7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff82611a2f565b611a768683611a2f565b95508019841693508086168417925050509392505050565b6000819050919050565b6000611ab3611aae611aa984611154565b611a8e565b611154565b9050919050565b6000819050919050565b611acd83611a98565b611ae1611ad982611aba565b848454611a3c565b825550505050565b600090565b611af6611ae9565b611b01818484611ac4565b505050565b5b81811015611b2557611b1a600082611aee565b600181019050611b07565b5050565b601f821115611b6a57611b3b81611a0a565b611b4484611a1f565b81016020851015611b53578190505b611b67611b5f85611a1f565b830182611b06565b50505b505050565b600082821c905092915050565b6000611b8d60001984600802611b6f565b1980831691505092915050565b6000611ba68383611b7c565b9150826002028217905092915050565b611bbf82611309565b67ffffffffffffffff811115611bd857611bd761151d565b5b611be28254611939565b611bed828285611b29565b600060209050601f831160018114611c205760008415611c0e578287015190505b611c188582611b9a565b865550611c80565b601f198416611c2e86611a0a565b60005b82811015611c5657848901518255600182019150602085019450602081019050611c31565b86831015611c735784890151611c6f601f891682611b7c565b8355505b6001600288020188555050505b505050505050565b6000604082019050611c9d600083018561115e565b8181036020830152611caf8184611360565b90509392505050565b7f63616e6e6f742065786563757465207478000000000000000000000000000000600082015250565b6000611cee6011836116b7565b9150611cf982611cb8565b602082019050919050565b60006020820190508181036000830152611d1d81611ce1565b9050919050565b600081905092915050565b60008154611d3c81611939565b611d468186611d24565b94506001821660008114611d615760018114611d7657611da9565b60ff1983168652811515820286019350611da9565b611d7f85611a0a565b60005b83811015611da157815481890152600182019150602081019050611d82565b838801955050505b50505092915050565b6000611dbe8284611d2f565b915081905092915050565b7f7478206661696c65640000000000000000000000000000000000000000000000600082015250565b6000611dff6009836116b7565b9150611e0a82611dc9565b602082019050919050565b60006020820190508181036000830152611e2e81611df2565b905091905056fea2646970667358221220e80b06134352e414f93f26d7441824c8082a405d8e55c88888f0cb1868b6c4bf64736f6c63430008110033",multisigAbi:[{inputs:[{internalType:"uint256",name:"_txIndex",type:"uint256"}],name:"confirmTransaction",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"uint256",name:"txIndex",type:"uint256"}],name:"ConfirmTransaction",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"sender",type:"address"},{indexed:!1,internalType:"uint256",name:"amount",type:"uint256"},{indexed:!1,internalType:"uint256",name:"balance",type:"uint256"}],name:"Deposit",type:"event"},{inputs:[{internalType:"uint256",name:"_txIndex",type:"uint256"}],name:"executeTransaction",outputs:[],stateMutability:"nonpayable",type:"function"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"uint256",name:"txIndex",type:"uint256"}],name:"ExecuteTransaction",type:"event"},{inputs:[{internalType:"uint256",name:"_txIndex",type:"uint256"}],name:"revokeConfirmation",outputs:[],stateMutability:"nonpayable",type:"function"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"uint256",name:"txIndex",type:"uint256"}],name:"RevokeConfirmation",type:"event"},{inputs:[{internalType:"address",name:"_to",type:"address"},{internalType:"uint256",name:"_value",type:"uint256"},{internalType:"bytes",name:"_data",type:"bytes"}],name:"submitTransaction",outputs:[],stateMutability:"nonpayable",type:"function"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"uint256",name:"txIndex",type:"uint256"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"},{indexed:!1,internalType:"bytes",name:"data",type:"bytes"}],name:"SubmitTransaction",type:"event"},{stateMutability:"payable",type:"receive"},{inputs:[],name:"getOwners",outputs:[{internalType:"address[]",name:"",type:"address[]"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"_txIndex",type:"uint256"}],name:"getTransaction",outputs:[{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"bytes",name:"data",type:"bytes"},{internalType:"bool",name:"executed",type:"bool"},{internalType:"uint256",name:"numConfirmations",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[],name:"getTransactionCount",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"",type:"uint256"},{internalType:"address",name:"",type:"address"}],name:"isConfirmed",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"",type:"address"}],name:"isOwner",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[],name:"numConfirmationsRequired",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"",type:"uint256"}],name:"owners",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"",type:"uint256"}],name:"transactions",outputs:[{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"bytes",name:"data",type:"bytes"},{internalType:"bool",name:"executed",type:"bool"},{internalType:"uint256",name:"numConfirmations",type:"uint256"}],stateMutability:"view",type:"function"}],erc1155Abi:[{inputs:[],stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!1,internalType:"bool",name:"approved",type:"bool"}],name:"ApprovalForAll",type:"event"},{inputs:[{internalType:"address",name:"to",type:"address"},{internalType:"uint256[]",name:"ids",type:"uint256[]"},{internalType:"uint256[]",name:"amounts",type:"uint256[]"},{internalType:"bytes",name:"data",type:"bytes"}],name:"mintBatch",outputs:[],stateMutability:"nonpayable",type:"function"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"previousOwner",type:"address"},{indexed:!0,internalType:"address",name:"newOwner",type:"address"}],name:"OwnershipTransferred",type:"event"},{inputs:[],name:"renounceOwnership",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256[]",name:"ids",type:"uint256[]"},{internalType:"uint256[]",name:"amounts",type:"uint256[]"},{internalType:"bytes",name:"data",type:"bytes"}],name:"safeBatchTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"id",type:"uint256"},{internalType:"uint256",name:"amount",type:"uint256"},{internalType:"bytes",name:"data",type:"bytes"}],name:"safeTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"operator",type:"address"},{internalType:"bool",name:"approved",type:"bool"}],name:"setApprovalForAll",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"string",name:"newuri",type:"string"}],name:"setURI",outputs:[],stateMutability:"nonpayable",type:"function"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256[]",name:"ids",type:"uint256[]"},{indexed:!1,internalType:"uint256[]",name:"values",type:"uint256[]"}],name:"TransferBatch",type:"event"},{inputs:[{internalType:"address",name:"newOwner",type:"address"}],name:"transferOwnership",outputs:[],stateMutability:"nonpayable",type:"function"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256",name:"id",type:"uint256"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"}],name:"TransferSingle",type:"event"},{anonymous:!1,inputs:[{indexed:!1,internalType:"string",name:"value",type:"string"},{indexed:!0,internalType:"uint256",name:"id",type:"uint256"}],name:"URI",type:"event"},{inputs:[{internalType:"address",name:"account",type:"address"},{internalType:"uint256",name:"id",type:"uint256"}],name:"balanceOf",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address[]",name:"accounts",type:"address[]"},{internalType:"uint256[]",name:"ids",type:"uint256[]"}],name:"balanceOfBatch",outputs:[{internalType:"uint256[]",name:"",type:"uint256[]"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"},{internalType:"address",name:"operator",type:"address"}],name:"isApprovedForAll",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[],name:"name",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[],name:"owner",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"bytes4",name:"interfaceId",type:"bytes4"}],name:"supportsInterface",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"_tokenid",type:"uint256"}],name:"uri",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"}],erc1155Bytecode:"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",heavyCallData:"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"}}}},{package:"@metamask/test-dapp",file:"node_modules/@metamask/test-dapp/dist/constants.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/UserOperationController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/constants.cjs","./helpers/Bundler.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/Bundler.cjs","./helpers/PendingUserOperationTracker.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/PendingUserOperationTracker.cjs","./helpers/SnapSmartContractAccount.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/SnapSmartContractAccount.cjs","./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/logger.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/types.cjs","./utils/gas-fees.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/gas-fees.cjs","./utils/gas.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/gas.cjs","./utils/transaction.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/transaction.cjs","./utils/validation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/validation.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/eth-query":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c,d,l,b,m,u,p,h,g,k,y,w,x,v,S,_,j,P,T=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},E=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)},O=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.UserOperationController=void 0;const M=e("@metamask/base-controller"),I=e("@metamask/controller-utils"),C=O(e("@metamask/eth-query")),A=e("@metamask/rpc-errors"),R=e("@metamask/transaction-controller"),$=e("@metamask/utils"),N=O(e("events")),L=e("lodash"),D=e("uuid"),F=e("./constants.cjs"),B=e("./helpers/Bundler.cjs"),U=e("./helpers/PendingUserOperationTracker.cjs"),q=e("./helpers/SnapSmartContractAccount.cjs"),H=e("./logger.cjs"),V=e("./types.cjs"),G=e("./utils/gas.cjs"),W=e("./utils/gas-fees.cjs"),K=e("./utils/transaction.cjs"),z=e("./utils/validation.cjs"),J={userOperations:{persist:!0,anonymous:!1}};class Y extends M.BaseController{constructor({entrypoint:e,getGasFeeEstimates:t,messenger:a,state:r}){super({name:"UserOperationController",metadata:J,messenger:a,state:{userOperations:{},...r}}),f.add(this),s.set(this,void 0),n.set(this,void 0),i.set(this,void 0),this.hub=new N.default,T(this,s,e,"f"),T(this,n,t,"f"),T(this,i,new U.PendingUserOperationTracker({getUserOperations:()=>(0,L.cloneDeep)(Object.values(this.state.userOperations)),messenger:a}),"f"),E(this,f,"m",x).call(this)}async addUserOperation(e,t){return(0,z.validateAddUserOperationRequest)(e),(0,z.validateAddUserOperationOptions)(t),await E(this,f,"m",r).call(this,e,t)}async addUserOperationFromTransaction(e,t){(0,z.validateAddUserOperationOptions)(t);const{data:a,from:s,maxFeePerGas:n,maxPriorityFeePerGas:i,to:o,value:c}=e,d={data:""===a?undefined:a,from:s,maxFeePerGas:n,maxPriorityFeePerGas:i,to:o,value:c};return(0,z.validateAddUserOperationRequest)(d),await E(this,f,"m",r).call(this,d,{...t,transaction:e})}startPollingByNetworkClientId(e){return E(this,i,"f").startPolling({networkClientId:e})}}a.UserOperationController=Y,s=new WeakMap,n=new WeakMap,i=new WeakMap,f=new WeakSet,r=async function(e,t){(0,H.projectLogger)("Adding user operation",{request:e,options:t});const{networkClientId:a,origin:s,smartContractAccount:n,swaps:i,transaction:r}=t,{chainId:l,provider:b}=await E(this,f,"m",_).call(this,a),m=await E(this,f,"m",d).call(this,l,s,r,i),u=n??new q.SnapSmartContractAccount(this.messagingSystem),p={chainId:l,metadata:m,options:{...t,smartContractAccount:u},provider:b,request:e,transaction:r},{id:g}=m;let k=!1;const y=(async()=>{try{return await E(this,f,"m",o).call(this,p)}catch(e){if(E(this,f,"m",h).call(this,m,e),k)throw e;return undefined}})(),w=async()=>(k=!0,await y);return{id:g,hash:w,transactionHash:async()=>{await w();const{transactionHash:e}=await E(this,f,"m",c).call(this,m);return e}}},o=async function(e){const{metadata:t,options:a}=e,{requireApproval:s,smartContractAccount:n}=a;let i;try{return await E(this,f,"m",l).call(this,e),await E(this,f,"m",b).call(this,t,n),this.hub.emit("user-operation-added",t),!1!==s&&(i=await E(this,f,"m",m).call(this,e)),await E(this,f,"m",u).call(this,t,n),await E(this,f,"m",p).call(this,t),i?.success(),t.hash}catch(e){throw i?.error(e),e}},c=async function(e){const{id:t,hash:a}=e;return(0,H.projectLogger)("Waiting for confirmation",t,a),new Promise((e,a)=>{this.hub.once(`${t}:confirmed`,t=>{e(t)}),this.hub.once(`${t}:failed`,(e,t)=>{a(t)})})},d=async function(e,t,a,s){const n={actualGasCost:null,actualGasUsed:null,baseFeePerGas:null,bundlerUrl:null,chainId:e,error:null,hash:null,id:(0,D.v1)(),origin:t,status:V.UserOperationStatus.Unapproved,swapsMetadata:s?{approvalTxId:s.approvalTxId??null,destinationTokenAddress:s.destinationTokenAddress??null,destinationTokenAmount:s.destinationTokenAmount??null,destinationTokenDecimals:s.destinationTokenDecimals??null,destinationTokenSymbol:s.destinationTokenSymbol??null,estimatedBaseFee:s.estimatedBaseFee??null,sourceTokenAddress:s.sourceTokenAddress??null,sourceTokenAmount:s.sourceTokenAmount??null,sourceTokenDecimals:s.sourceTokenDecimals??null,sourceTokenSymbol:s.sourceTokenSymbol??null,swapAndSendRecipient:s.swapAndSendRecipient??null,swapMetaData:s.swapMetaData??null,swapTokenValue:s.swapTokenValue??null}:null,time:Date.now(),transactionHash:null,transactionParams:a??null,transactionType:null,userFeeLevel:null,userOperation:E(this,f,"m",g).call(this,a)};return E(this,f,"m",k).call(this,n),(0,H.projectLogger)("Added user operation",n.id),n},l=async function(e){const{chainId:t,metadata:a,options:i,provider:r,request:o,transaction:c}=e,{data:d,from:l,to:b,value:m}=o,{id:u,transactionParams:p,userOperation:h}=a,{smartContractAccount:g}=i;(0,H.projectLogger)("Preparing user operation",{id:u});const y=await E(this,f,"m",S).call(this,c,r,i);a.transactionType=y??null,(0,H.projectLogger)("Determined transaction type",y),await(0,W.updateGasFees)({getGasFeeEstimates:E(this,n,"f"),metadata:a,originalRequest:o,provider:r,transaction:p??undefined});const w=await g.prepareUserOperation({chainId:t,data:d,from:l,to:b,value:m});(0,z.validatePrepareUserOperationResponse)(w);const{bundler:x,callData:v,dummyPaymasterAndData:_,dummySignature:j,initCode:P,nonce:T,sender:O}=w;h.callData=v,h.initCode=P??F.EMPTY_BYTES,h.nonce=T,h.paymasterAndData=_??F.EMPTY_BYTES,h.sender=O,h.signature=j??F.EMPTY_BYTES,a.bundlerUrl=x,await(0,G.updateGas)(a,w,E(this,s,"f")),E(this,f,"m",k).call(this,a)},b=async function(e,t){const{id:a,userOperation:s,chainId:n}=e;(0,H.projectLogger)("Requesting paymaster data",{id:a});const i=await t.updateUserOperation({userOperation:s,chainId:n});(0,z.validateUpdateUserOperationResponse)(i),s.paymasterAndData=i.paymasterAndData??F.EMPTY_BYTES,i.callGasLimit&&(s.callGasLimit=i.callGasLimit),i.preVerificationGas&&(s.preVerificationGas=i.preVerificationGas),i.verificationGasLimit&&(s.verificationGasLimit=i.verificationGasLimit),E(this,f,"m",k).call(this,e)},m=async function(e){(0,H.projectLogger)("Requesting approval");const{metadata:t}=e,{resultCallbacks:a,value:s}=await E(this,f,"m",v).call(this,t),n=s?.txMeta;return n&&await E(this,f,"m",j).call(this,e,n),t.status=V.UserOperationStatus.Approved,E(this,f,"m",k).call(this,t),a},u=async function(e,t){const{id:a,chainId:s,userOperation:n}=e;(0,H.projectLogger)("Signing user operation",a,n);const i=await t.signUserOperation({userOperation:n,chainId:s});(0,z.validateSignUserOperationResponse)(i);const{signature:r}=i;n.signature=r,(0,H.projectLogger)("Signed user operation",r),e.status=V.UserOperationStatus.Signed,E(this,f,"m",k).call(this,e)},p=async function(e){const{userOperation:t}=e;(0,H.projectLogger)("Submitting user operation",t);const a=new B.Bundler(e.bundlerUrl),n=await a.sendUserOperation(t,E(this,s,"f"));e.hash=n,e.status=V.UserOperationStatus.Submitted,E(this,f,"m",k).call(this,e)},h=function(e,t){const{id:a}=e,s=t;(0,H.projectLogger)("User operation failed",a,t),e.error={name:s.name,message:s.message,stack:s.stack,code:s.code,rpc:s.value},e.status=V.UserOperationStatus.Failed,E(this,f,"m",k).call(this,e),String(s.code)===String(A.errorCodes.provider.userRejectedRequest)&&E(this,f,"m",y).call(this,a)},g=function(e){return{callData:F.EMPTY_BYTES,callGasLimit:F.EMPTY_BYTES,initCode:F.EMPTY_BYTES,maxFeePerGas:e?.maxFeePerGas??F.EMPTY_BYTES,maxPriorityFeePerGas:e?.maxPriorityFeePerGas??F.EMPTY_BYTES,nonce:F.EMPTY_BYTES,paymasterAndData:F.EMPTY_BYTES,preVerificationGas:F.EMPTY_BYTES,sender:F.ADDRESS_ZERO,signature:F.EMPTY_BYTES,verificationGasLimit:F.EMPTY_BYTES}},k=function(e){const{id:t}=e;this.update(a=>{a.userOperations[t]=(0,L.cloneDeep)(e)}),E(this,f,"m",w).call(this,e)},y=function(e){this.update(t=>{delete t.userOperations[e]})},w=function(e){if(!e.transactionParams)return;const t=(0,K.getTransactionMetadata)(e);this.hub.emit("transaction-updated",t)},x=function(){E(this,i,"f").hub.on("user-operation-confirmed",e=>{(0,H.projectLogger)("In listener..."),this.hub.emit("user-operation-confirmed",e),this.hub.emit(`${e.id}:confirmed`,e)}),E(this,i,"f").hub.on("user-operation-failed",(e,t)=>{this.hub.emit("user-operation-failed",e,t),this.hub.emit(`${e.id}:failed`,e,t)}),E(this,i,"f").hub.on("user-operation-updated",e=>{E(this,f,"m",k).call(this,e)})},v=async function(e){const{id:t,origin:a}=e,f=I.ApprovalType.Transaction,s={txId:t};return await this.messagingSystem.call("ApprovalController:addRequest",{id:t,origin:a,type:f,requestData:s,expectsResult:!0},!0)},S=async function(e,t,a){if(!e)return undefined;if(a.type)return a.type;const f=new C.default(t),s=(0,R.determineTransactionType)(e,f);return(await s).type},_=async function(e){const{provider:t,configuration:a}=this.messagingSystem.call("NetworkController:getNetworkClientById",e),{chainId:f}=a;return{provider:t,chainId:f}},j=async function(e,t){(0,H.projectLogger)("Found updated transaction in approval",{updatedTransaction:t});const{metadata:a,request:s}=e,{userOperation:n}=a,i=n.paymasterAndData!==F.EMPTY_BYTES,r=(0,$.add0x)(t.txParams.maxFeePerGas),o=(0,$.add0x)(t.txParams.maxPriorityFeePerGas);let c=!1;const d=n.maxFeePerGas,l=n.maxPriorityFeePerGas,b=d!==r||l!==o,m=i&&r===F.VALUE_ZERO&&o===F.VALUE_ZERO;b&&!m&&((0,H.projectLogger)("Gas fees updated during approval",{previousMaxFeePerGas:d,previousMaxPriorityFeePerGas:l,updatedMaxFeePerGas:r,updatedMaxPriorityFeePerGas:o}),n.maxFeePerGas=r,n.maxPriorityFeePerGas=o,c=i);const u=s.data??F.EMPTY_BYTES,p=t.txParams.data??F.EMPTY_BYTES;u!==p&&((0,H.projectLogger)("Data updated during approval",{previousData:u,updatedData:p}),c=!0);const h=s.value??F.VALUE_ZERO,g=t.txParams.value??F.VALUE_ZERO;if(h!==g&&((0,H.projectLogger)("Value updated during approval",{previousValue:h,updatedValue:g}),c=!0),c){const t={...s,data:p,maxFeePerGas:r,maxPriorityFeePerGas:o,value:g};await E(this,f,"m",P).call(this,{...e,request:t})}},P=async function(e){(0,H.projectLogger)("Regenerating user operation as parameters were updated during approval");const{options:{smartContractAccount:t},metadata:a}=e;await E(this,f,"m",l).call(this,e),await E(this,f,"m",b).call(this,a,t),(0,H.projectLogger)("Regenerated user operation",a.userOperation)}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/UserOperationController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.VALUE_ZERO=a.ADDRESS_ZERO=a.EMPTY_BYTES=void 0,a.EMPTY_BYTES="0x",a.ADDRESS_ZERO="0x0000000000000000000000000000000000000000",a.VALUE_ZERO="0x0"}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/Bundler.cjs",{"../logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/logger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},r=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.Bundler=void 0;const o=e("../logger.cjs"),c=(0,o.createModuleLogger)(o.projectLogger,"bundler");a.Bundler=class{constructor(e){f.add(this),s.set(this,void 0),i(this,s,e,"f")}async estimateUserOperationGas(e,t){c("Estimating gas",{url:r(this,s,"f"),userOperation:e,entrypoint:t});const a=await r(this,f,"m",n).call(this,"eth_estimateUserOperationGas",[e,t]);return c("Estimated gas",{response:a}),a}async getUserOperationReceipt(e){return c("Getting user operation receipt",{url:r(this,s,"f"),hash:e}),await r(this,f,"m",n).call(this,"eth_getUserOperationReceipt",[e])}async sendUserOperation(e,t){c("Sending user operation",{url:r(this,s,"f"),userOperation:e,entrypoint:t});const a=await r(this,f,"m",n).call(this,"eth_sendUserOperation",[e,t]);return c("Sent user operation",a),a}},s=new WeakMap,f=new WeakSet,n=async function(e,t){const a={method:"POST",headers:{Accept:"application/json","Content-Type":"application/json"},body:JSON.stringify({jsonrpc:"2.0",id:1,method:e,params:t})},f=await fetch(r(this,s,"f"),a),n=await f.json();if(n.error){const e=new Error(n.error.message||n.error);throw e.code=n.error.code,e}return n.result}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/helpers/Bundler.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/PendingUserOperationTracker.cjs",{"../logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/logger.cjs","../types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/types.cjs","./Bundler.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/Bundler.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/eth-query":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js","@metamask/polling-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/polling-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s,n,i,r,o,c,d,l,b,m,u=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},p=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)},h=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.PendingUserOperationTracker=void 0;const g=e("@metamask/controller-utils"),k=h(e("@metamask/eth-query")),y=e("@metamask/polling-controller"),w=e("@metamask/utils"),x=h(e("events")),v=e("../logger.cjs"),S=e("../types.cjs"),_=e("./Bundler.cjs"),j=(0,w.createModuleLogger)(v.projectLogger,"pending-user-operations");class P extends((0,y.BlockTrackerPollingControllerOnly)()){constructor({getUserOperations:e,messenger:t}){super(),f.add(this),s.set(this,void 0),n.set(this,void 0),this.hub=new x.default,u(this,s,e,"f"),u(this,n,t,"f")}async _executePoll({networkClientId:e}){try{const{blockTracker:t,configuration:a,provider:s}=this._getNetworkClientById(e);j("Polling",{blockNumber:t.getCurrentBlock(),chainId:a.chainId}),await p(this,f,"m",i).call(this,a.chainId,s)}catch(e){j("Failed to check user operations",e)}}_getNetworkClientById(e){return p(this,n,"f").call("NetworkController:getNetworkClientById",e)}}a.PendingUserOperationTracker=P,s=new WeakMap,n=new WeakMap,f=new WeakSet,i=async function(e,t){const a=p(this,f,"m",d).call(this).filter(t=>t.chainId===e);a.length?(j("Found pending user operations to check",{count:a.length,ids:a.map(e=>e.id)}),await Promise.all(a.map(e=>p(this,f,"m",r).call(this,e,t)))):j("No pending user operations to check")},r=async function(e,t){const{bundlerUrl:a,hash:s,id:n}=e;if(s&&a)try{const i=await p(this,f,"m",b).call(this,s,a),r=i?.success;if(i&&!r)return void p(this,f,"m",c).call(this,e,i);if(r)return void await p(this,f,"m",o).call(this,e,i,t);j("No receipt found for user operation",{id:n,hash:s})}catch(e){j("Failed to check user operation",n,e)}else j("Skipping user operation as missing hash or bundler",n)},o=async function(e,t,a){const{id:s}=e,{actualGasCost:n,actualGasUsed:i,receipt:{blockHash:r,transactionHash:o}}=t;j("User operation confirmed",s,o);const{baseFeePerGas:c}=await(0,g.query)(new k.default(a),"getBlockByHash",[r,!1]);e.actualGasCost=p(this,f,"m",m).call(this,n),e.actualGasUsed=p(this,f,"m",m).call(this,i),e.baseFeePerGas=c,e.status=S.UserOperationStatus.Confirmed,e.transactionHash=o,p(this,f,"m",l).call(this,e),this.hub.emit("user-operation-confirmed",e)},c=function(e,t){const{id:a}=e;j("User operation failed",a),e.status=S.UserOperationStatus.Failed,p(this,f,"m",l).call(this,e),this.hub.emit("user-operation-failed",e,new Error("User operation receipt has failed status"))},d=function(){return p(this,s,"f").call(this).filter(e=>e.status===S.UserOperationStatus.Submitted)},l=function(e){this.hub.emit("user-operation-updated",e)},b=async function(e,t){return new _.Bundler(t).getUserOperationReceipt(e)},m=function(e){return"number"==typeof e?(0,g.toHex)(e):e}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/helpers/PendingUserOperationTracker.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/SnapSmartContractAccount.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/constants.cjs","../utils/chain-id.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/chain-id.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f,s=this&&this.__classPrivateFieldSet||function(e,t,a,f,s){if("m"===f)throw new TypeError("Private method is not writable");if("a"===f&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===f?s.call(e,a):s?s.value=a:t.set(e,a),a},n=this&&this.__classPrivateFieldGet||function(e,t,a,f){if("a"===a&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!f:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?f:"a"===a?f.call(e):f?f.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.SnapSmartContractAccount=void 0;const i=e("../constants.cjs"),r=e("../utils/chain-id.cjs");a.SnapSmartContractAccount=class{constructor(e){f.set(this,void 0),s(this,f,e,"f")}async prepareUserOperation(e){const{chainId:t,data:a,from:s,to:o,value:c}=e,d=a??i.EMPTY_BYTES,l=o??i.ADDRESS_ZERO,b=c??i.VALUE_ZERO,m=await n(this,f,"f").call("KeyringController:prepareUserOperation",s,[{data:d,to:l,value:b}],{chainId:(0,r.toEip155ChainId)(t)}),{bundlerUrl:u,callData:p,dummyPaymasterAndData:h,dummySignature:g,gasLimits:k,initCode:y,nonce:w}=m;return{bundler:u,callData:p,dummyPaymasterAndData:h,dummySignature:g,gas:k,initCode:y,nonce:w,sender:s}}async updateUserOperation(e){const{userOperation:t,chainId:a}=e,{sender:s}=t,{paymasterAndData:o,verificationGasLimit:c,preVerificationGas:d,callGasLimit:l}=await n(this,f,"f").call("KeyringController:patchUserOperation",s,t,{chainId:(0,r.toEip155ChainId)(a)});return{paymasterAndData:o===i.EMPTY_BYTES?undefined:o,verificationGasLimit:c,preVerificationGas:d,callGasLimit:l}}async signUserOperation(e){const{userOperation:t,chainId:a}=e,{sender:s}=t;return{signature:await n(this,f,"f").call("KeyringController:signUserOperation",s,t,{chainId:(0,r.toEip155ChainId)(a)})}}},f=new WeakMap}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/helpers/SnapSmartContractAccount.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/index.cjs",{"./UserOperationController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/UserOperationController.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__createBinding||(Object.create?function(e,t,a,f){f===undefined&&(f=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,f,s)}:function(e,t,a,f){f===undefined&&(f=a),e[f]=t[a]}),s=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||f(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),s(e("./UserOperationController.cjs"),a),s(e("./types.cjs"),a)}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createModuleLogger=a.projectLogger=void 0;const f=e("@metamask/utils");Object.defineProperty(a,"createModuleLogger",{enumerable:!0,get:function(){return f.createModuleLogger}}),a.projectLogger=(0,f.createProjectLogger)("user-operation-controller")}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f;Object.defineProperty(a,"__esModule",{value:!0}),a.UserOperationStatus=void 0,function(e){e.Unapproved="unapproved",e.Approved="approved",e.Signed="signed",e.Submitted="submitted",e.Failed="failed",e.Confirmed="confirmed"}(f||(a.UserOperationStatus=f={}))}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/chain-id.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.toEip155ChainId=void 0,a.toEip155ChainId=function(e){const t=Number(e);return Number.isInteger(t)?t.toString():e}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/utils/chain-id.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/gas-fees.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/constants.cjs","../logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/logger.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/eth-query":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js","@metamask/gas-fee-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/index.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.updateGasFees=void 0;const s=e("@metamask/controller-utils"),n=f(e("@metamask/eth-query")),i=e("@metamask/gas-fee-controller"),r=e("@metamask/transaction-controller"),o=e("@metamask/utils"),c=e("../constants.cjs"),d=e("../logger.cjs"),l=(0,d.createModuleLogger)(d.projectLogger,"gas-fees");function b(e){return(0,s.toHex)((0,s.gweiDecToWEIBN)(e))}function m(e){return!e||e===c.EMPTY_BYTES}a.updateGasFees=async function(e){const{metadata:t,originalRequest:a,transaction:f}=e,{userOperation:c}=t;let d;const u=async()=>(d||(d=await async function(e){const{getGasFeeEstimates:t,provider:a}=e;try{const{gasFeeEstimates:e,gasEstimateType:a}=await t();if(a===i.GAS_ESTIMATE_TYPES.FEE_MARKET){const{medium:{suggestedMaxPriorityFeePerGas:t,suggestedMaxFeePerGas:a}={}}=e;if(t&&a){const e={maxFeePerGas:b(a),maxPriorityFeePerGas:b(t)};return l("Using medium values from fee market estimate",e),e}}if(a===i.GAS_ESTIMATE_TYPES.LEGACY){const t=b(e.medium);return l("Using medium value from legacy estimate",t),{maxFeePerGas:t}}if(a===i.GAS_ESTIMATE_TYPES.ETH_GASPRICE){const t=b(e.gasPrice);return l("Using gasPrice from estimate",t),{maxFeePerGas:t}}}catch(e){l("Failed to get estimate",e)}const f=await(0,s.query)(new n.default(a),"gasPrice");if(!f)return{};const r=(0,o.add0x)(f.toString(16));return l("Using gasPrice from network as fallback",r),{maxFeePerGas:r}}(e)),d);c.maxFeePerGas=await async function(e,t,a){const{maxFeePerGas:f,maxPriorityFeePerGas:s}=e,{gasPrice:n}=a??{};if(!m(f))return l("Using maxFeePerGas from request",f),f;if(m(s)&&n)return l("Setting maxFeePerGas to transaction gasPrice",n),n;const{maxFeePerGas:i}=await t();if(!i)throw new Error("Failed to get gas fee estimate for maxFeePerGas");return l("Using maxFeePerGas from estimate",i),i}(a,u,f),c.maxPriorityFeePerGas=await async function(e,t,a,f){const{maxFeePerGas:s,maxPriorityFeePerGas:n}=e,{gasPrice:i}=f??{},{maxFeePerGas:r}=a;if(!m(n))return l("Using maxPriorityFeePerGas from request",n),n;if(m(s)&&i)return l("Setting maxPriorityFeePerGas to transaction gasPrice",i),i;const{maxPriorityFeePerGas:o}=await t();if(o)return l("Using maxPriorityFeePerGas from estimate",o),o;return l("Setting maxPriorityFeePerGas to maxFeePerGas",r),r}(a,u,c,f),t.userFeeLevel=function(e,t,a,f){const{origin:n}=e,{maxFeePerGas:i,maxPriorityFeePerGas:o}=t,{maxFeePerGas:c,maxPriorityFeePerGas:d}=a||{};if(m(i)&&m(o)&&f?.gasPrice)return n===s.ORIGIN_METAMASK?r.UserFeeLevel.CUSTOM:r.UserFeeLevel.DAPP_SUGGESTED;if(m(i)&&m(o)&&c&&d)return r.UserFeeLevel.MEDIUM;if(n===s.ORIGIN_METAMASK)return r.UserFeeLevel.CUSTOM;return r.UserFeeLevel.DAPP_SUGGESTED}(t,a,d,f)}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/utils/gas-fees.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/gas.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/constants.cjs","../helpers/Bundler.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/helpers/Bundler.cjs","../logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/logger.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.updateGas=void 0;const s=e("@metamask/controller-utils"),n=e("@metamask/utils"),i=f(e("bn.js")),r=e("../constants.cjs"),o=e("../helpers/Bundler.cjs"),c=e("../logger.cjs"),d=(0,c.createModuleLogger)(c.projectLogger,"gas");function l(e){const t=("string"==typeof e?(0,s.hexToBN)(e):new i.default(e)).muln(1.5);return(0,n.add0x)(t.toString(16))}a.updateGas=async function(e,t,a){const{userOperation:f}=e;if(t.gas)return f.callGasLimit=t.gas.callGasLimit,f.preVerificationGas=t.gas.preVerificationGas,f.verificationGasLimit=t.gas.verificationGasLimit,void d("Using gas values from smart contract account",{callGasLimit:f.callGasLimit,preVerificationGas:f.preVerificationGas,verificationGasLimit:f.verificationGasLimit});const s={...f,maxFeePerGas:r.VALUE_ZERO,maxPriorityFeePerGas:r.VALUE_ZERO,callGasLimit:r.VALUE_ZERO,preVerificationGas:r.VALUE_ZERO,verificationGasLimit:"0xF4240"},n=new o.Bundler(e.bundlerUrl),i=await n.estimateUserOperationGas(s,a);f.callGasLimit=l(i.callGasLimit),f.preVerificationGas=l(i.preVerificationGas),f.verificationGasLimit=l(i.verificationGasLimit??i.verificationGas),d("Using buffered gas values from bundler estimate",{callGasLimit:f.callGasLimit,preVerificationGas:f.preVerificationGas,verificationGasLimit:f.verificationGasLimit,multiplier:1.5,estimate:i})}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/utils/gas.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/transaction.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/constants.cjs","../types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/types.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.getTransactionMetadata=void 0;const s=e("@metamask/transaction-controller"),n=e("@metamask/utils"),i=f(e("bn.js")),r=e("../constants.cjs"),o=e("../types.cjs");a.getTransactionMetadata=function(e){const{actualGasCost:t,actualGasUsed:a,baseFeePerGas:f,chainId:c,error:d,origin:l,transactionHash:b,id:m,swapsMetadata:u,time:p,transactionParams:h,transactionType:g,userFeeLevel:k,userOperation:y}=e;if(!h)return undefined;const w=t&&a?(0,n.add0x)(new i.default((0,n.remove0x)(t),16).div(new i.default((0,n.remove0x)(a),16)).toString(16)):undefined,x=d?{name:d.name,message:d.message,stack:d.stack,code:d.code,rpc:d.rpc}:undefined,v={[o.UserOperationStatus.Unapproved]:s.TransactionStatus.unapproved,[o.UserOperationStatus.Approved]:s.TransactionStatus.approved,[o.UserOperationStatus.Signed]:s.TransactionStatus.signed,[o.UserOperationStatus.Submitted]:s.TransactionStatus.submitted,[o.UserOperationStatus.Confirmed]:s.TransactionStatus.confirmed,[o.UserOperationStatus.Failed]:s.TransactionStatus.failed}[e.status],S=function(...e){const t=new i.default(0);for(const a of e)a&&t.iadd(new i.default((0,n.remove0x)(a),16));return(0,n.add0x)(t.toString(16))}(y.preVerificationGas,y.verificationGasLimit,y.callGasLimit),_=y.paymasterAndData!==r.EMPTY_BYTES,j=_?r.VALUE_ZERO:y.maxFeePerGas,P=_?r.VALUE_ZERO:y.maxPriorityFeePerGas,T=y.nonce===r.EMPTY_BYTES?undefined:y.nonce,E={...h,from:y.sender,gas:S,nonce:T,maxFeePerGas:j,maxPriorityFeePerGas:P};delete E.gasPrice;const O={approvalTxId:u?.approvalTxId??undefined,destinationTokenAddress:u?.destinationTokenAddress??undefined,destinationTokenAmount:u?.destinationTokenAmount??undefined,destinationTokenDecimals:u?.destinationTokenDecimals??undefined,destinationTokenSymbol:u?.destinationTokenSymbol??undefined,estimatedBaseFee:u?.estimatedBaseFee??undefined,sourceTokenAddress:u?.sourceTokenAddress??undefined,sourceTokenAmount:u?.sourceTokenAmount??undefined,sourceTokenDecimals:u?.sourceTokenDecimals??undefined,sourceTokenSymbol:u?.sourceTokenSymbol??undefined,swapAndSendRecipient:u?.swapAndSendRecipient??undefined,swapMetaData:u?.swapMetaData??undefined,swapTokenValue:u?.swapTokenValue??undefined},M=_?s.UserFeeLevel.CUSTOM:k;return{baseFeePerGas:f??undefined,chainId:c,error:x,hash:b??undefined,id:m,isUserOperation:!0,networkClientId:"user-operation",origin:l,status:v,time:p,txParams:E,txReceipt:{effectiveGasPrice:w??undefined,gasUsed:a??undefined},type:g??undefined,userFeeLevel:M,...O}}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/utils/transaction.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/utils/validation.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/user-operation-controller/dist/constants.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.validateSignUserOperationResponse=a.validateUpdateUserOperationResponse=a.validatePrepareUserOperationResponse=a.validateAddUserOperationOptions=a.validateAddUserOperationRequest=void 0;const f=e("@metamask/superstruct"),s=e("@metamask/transaction-controller"),n=e("@metamask/utils"),i=e("../constants.cjs");function r(e,t,a){try{(0,f.assert)(e,t,a)}catch(e){const t=e.failures().map(e=>e.path.length?`${e.path.join(".")} - ${e.message}`:e.message).join("\n");throw new Error(`${a}\n${t}`)}}function o(){return(0,f.define)("Hexadecimal String",e=>(0,n.isStrictHexString)(e))}function c(){return(0,f.define)("Hexadecimal String or 0x",e=>(0,n.isStrictHexString)(e)||e===i.EMPTY_BYTES)}a.validateAddUserOperationRequest=function(e){const t=o(),a=c();r(e,(0,f.object)({data:(0,f.optional)(a),from:t,maxFeePerGas:(0,f.optional)(t),maxPriorityFeePerGas:(0,f.optional)(t),to:(0,f.optional)(t),value:(0,f.optional)(t)}),"Invalid request to add user operation")},a.validateAddUserOperationOptions=function(e){r(e,(0,f.object)({networkClientId:(0,f.string)(),origin:(0,f.string)(),requireApproval:(0,f.optional)((0,f.boolean)()),smartContractAccount:(0,f.optional)((0,f.object)({prepareUserOperation:(0,f.func)(),updateUserOperation:(0,f.func)(),signUserOperation:(0,f.func)()})),swaps:(0,f.optional)((0,f.object)({approvalTxId:(0,f.optional)((0,f.string)()),destinationTokenAddress:(0,f.optional)((0,f.string)()),destinationTokenDecimals:(0,f.optional)((0,f.number)()),destinationTokenSymbol:(0,f.optional)((0,f.string)()),estimatedBaseFee:(0,f.optional)((0,f.string)()),sourceTokenSymbol:(0,f.optional)((0,f.string)()),swapMetaData:(0,f.optional)((0,f.object)()),swapTokenValue:(0,f.optional)((0,f.string)()),destinationTokenAmount:(0,f.optional)((0,f.string)()),sourceTokenAddress:(0,f.optional)((0,f.string)()),sourceTokenAmount:(0,f.optional)((0,f.string)()),sourceTokenDecimals:(0,f.optional)((0,f.number)()),swapAndSendRecipient:(0,f.optional)((0,f.string)())})),type:(0,f.optional)((0,f.enums)(Object.values(s.TransactionType)))}),"Invalid options to add user operation")},a.validatePrepareUserOperationResponse=function(e){const t=o(),a=c();r(e,(0,f.refine)((0,f.object)({bundler:(0,f.string)(),callData:t,dummyPaymasterAndData:(0,f.optional)(a),dummySignature:(0,f.optional)(a),gas:(0,f.optional)((0,f.object)({callGasLimit:t,preVerificationGas:t,verificationGasLimit:t})),initCode:(0,f.optional)(a),nonce:t,sender:t}),"ValidPrepareUserOperationResponse",({gas:e,dummySignature:t})=>!!(e||t&&t!==i.EMPTY_BYTES)||"Must specify dummySignature if not specifying gas"),"Invalid response when preparing user operation")},a.validateUpdateUserOperationResponse=function(e){r(e,(0,f.optional)((0,f.object)({paymasterAndData:(0,f.optional)(c()),callGasLimit:(0,f.optional)(c()),preVerificationGas:(0,f.optional)(c()),verificationGasLimit:(0,f.optional)(c())})),"Invalid response when updating user operation")},a.validateSignUserOperationResponse=function(e){const t=o();r(e,(0,f.object)({signature:t}),"Invalid response when signing user operation")}}}},{package:"@metamask/user-operation-controller",file:"node_modules/@metamask/user-operation-controller/dist/utils/validation.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@multiformats/base-x/src/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports=function(e){if(e.length>=255)throw new TypeError("Alphabet too long");for(var t=new Uint8Array(256),a=0;a<t.length;a++)t[a]=255;for(var f=0;f<e.length;f++){var s=e.charAt(f),n=s.charCodeAt(0);if(255!==t[n])throw new TypeError(s+" is ambiguous");t[n]=f}var i=e.length,r=e.charAt(0),o=Math.log(i)/Math.log(256),c=Math.log(256)/Math.log(i);function d(e){if("string"!=typeof e)throw new TypeError("Expected String");if(0===e.length)return new Uint8Array;var a=0;if(" "!==e[a]){for(var f=0,s=0;e[a]===r;)f++,a++;for(var n=(e.length-a)*o+1>>>0,c=new Uint8Array(n);e[a];){var d=t[e.charCodeAt(a)];if(255===d)return;for(var l=0,b=n-1;(0!==d||l<s)&&-1!==b;b--,l++)d+=i*c[b]>>>0,c[b]=d%256>>>0,d=d/256>>>0;if(0!==d)throw new Error("Non-zero carry");s=l,a++}if(" "!==e[a]){for(var m=n-s;m!==n&&0===c[m];)m++;for(var u=new Uint8Array(f+(n-m)),p=f;m!==n;)u[p++]=c[m++];return u}}}return{encode:function(t){if(t instanceof Uint8Array||(ArrayBuffer.isView(t)?t=new Uint8Array(t.buffer,t.byteOffset,t.byteLength):Array.isArray(t)&&(t=Uint8Array.from(t))),!(t instanceof Uint8Array))throw new TypeError("Expected Uint8Array");if(0===t.length)return"";for(var a=0,f=0,s=0,n=t.length;s!==n&&0===t[s];)s++,a++;for(var o=(n-s)*c+1>>>0,d=new Uint8Array(o);s!==n;){for(var l=t[s],b=0,m=o-1;(0!==l||b<f)&&-1!==m;m--,b++)l+=256*d[m]>>>0,d[m]=l%i>>>0,l=l/i>>>0;if(0!==l)throw new Error("Non-zero carry");f=b,s++}for(var u=o-f;u!==o&&0===d[u];)u++;for(var p=r.repeat(a);u<o;++u)p+=e.charAt(d[u]);return p},decodeUnsafe:d,decode:function(e){var t=d(e);if(t)return t;throw new Error("Non-base"+i+" character")}}}}}},{package:"@ensdomains/content-hash>cids>multibase>@multiformats/base-x",file:"node_modules/@multiformats/base-x/src/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@open-rpc/meta-schema/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.openrpcDocument=void 0,a.openrpcDocument={$schema:"https://meta.json-schema.tools/",$id:"https://meta.open-rpc.org/",title:"openrpcDocument",type:"object",required:["info","methods","openrpc"],additionalProperties:!1,patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}},properties:{openrpc:{title:"openrpc",type:"string",enum:["1.3.2","1.3.1","1.3.0","1.2.6","1.2.5","1.2.4","1.2.3","1.2.2","1.2.1","1.2.0","1.1.12","1.1.11","1.1.10","1.1.9","1.1.8","1.1.7","1.1.6","1.1.5","1.1.4","1.1.3","1.1.2","1.1.1","1.1.0","1.0.0","1.0.0-rc1","1.0.0-rc0"]},info:{$ref:"#/definitions/infoObject"},externalDocs:{$ref:"#/definitions/externalDocumentationObject"},servers:{title:"servers",type:"array",additionalItems:!1,items:{$ref:"#/definitions/serverObject"}},methods:{title:"methods",type:"array",additionalItems:!1,items:{title:"methodOrReference",oneOf:[{$ref:"#/definitions/methodObject"},{$ref:"#/definitions/referenceObject"}]}},components:{title:"components",type:"object",properties:{schemas:{title:"schemaComponents",type:"object",patternProperties:{"[0-z]+":{$ref:"#/definitions/JSONSchema"}}},links:{title:"linkComponents",type:"object",patternProperties:{"[0-z]+":{$ref:"#/definitions/linkObject"}}},errors:{title:"errorComponents",type:"object",patternProperties:{"[0-z]+":{$ref:"#/definitions/errorObject"}}},examples:{title:"exampleComponents",type:"object",patternProperties:{"[0-z]+":{$ref:"#/definitions/exampleObject"}}},examplePairings:{title:"examplePairingComponents",type:"object",patternProperties:{"[0-z]+":{$ref:"#/definitions/examplePairingObject"}}},contentDescriptors:{title:"contentDescriptorComponents",type:"object",patternProperties:{"[0-z]+":{$ref:"#/definitions/contentDescriptorObject"}}},tags:{title:"tagComponents",type:"object",patternProperties:{"[0-z]+":{$ref:"#/definitions/tagObject"}}}}},$schema:{title:"metaSchema",description:"JSON Schema URI (used by some editors)",type:"string",default:"https://meta.open-rpc.org/"}},definitions:{specificationExtension:{title:"specificationExtension"},JSONSchema:{$ref:"https://meta.json-schema.tools"},referenceObject:{title:"referenceObject",type:"object",additionalProperties:!1,required:["$ref"],properties:{$ref:{$ref:"https://meta.json-schema.tools/#/definitions/JSONSchemaObject/properties/$ref"}}},errorObject:{title:"errorObject",type:"object",description:"Defines an application level error.",additionalProperties:!1,required:["code","message"],properties:{code:{title:"errorObjectCode",description:"A Number that indicates the error type that occurred. This MUST be an integer. The error codes from and including -32768 to -32000 are reserved for pre-defined errors. These pre-defined errors SHOULD be assumed to be returned from any JSON-RPC api.",type:"integer"},message:{title:"errorObjectMessage",description:"A String providing a short description of the error. The message SHOULD be limited to a concise single sentence.",type:"string"},data:{title:"errorObjectData",description:"A Primitive or Structured value that contains additional information about the error. This may be omitted. The value of this member is defined by the Server (e.g. detailed error information, nested errors etc.)."}}},licenseObject:{title:"licenseObject",type:"object",additionalProperties:!1,properties:{name:{title:"licenseObjectName",type:"string"},url:{title:"licenseObjectUrl",type:"string"}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},contactObject:{title:"contactObject",type:"object",additionalProperties:!1,properties:{name:{title:"contactObjectName",type:"string"},email:{title:"contactObjectEmail",type:"string"},url:{title:"contactObjectUrl",type:"string"}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},infoObject:{title:"infoObject",type:"object",additionalProperties:!1,required:["title","version"],properties:{title:{title:"infoObjectProperties",type:"string"},description:{title:"infoObjectDescription",type:"string"},termsOfService:{title:"infoObjectTermsOfService",type:"string",format:"uri"},version:{title:"infoObjectVersion",type:"string"},contact:{$ref:"#/definitions/contactObject"},license:{$ref:"#/definitions/licenseObject"}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},serverObject:{title:"serverObject",type:"object",required:["url"],additionalProperties:!1,properties:{url:{title:"serverObjectUrl",type:"string",format:"uri"},name:{title:"serverObjectName",type:"string"},description:{title:"serverObjectDescription",type:"string"},summary:{title:"serverObjectSummary",type:"string"},variables:{title:"serverObjectVariables",type:"object",patternProperties:{"[0-z]+":{title:"serverObjectVariable",type:"object",required:["default"],properties:{default:{title:"serverObjectVariableDefault",type:"string"},description:{title:"serverObjectVariableDescription",type:"string"},enum:{title:"serverObjectVariableEnum",type:"array",items:{title:"serverObjectVariableEnumItem",type:"string"}}}}}}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},linkObject:{title:"linkObject",type:"object",additionalProperties:!1,properties:{name:{title:"linkObjectName",type:"string",minLength:1},summary:{title:"linkObjectSummary",type:"string"},method:{title:"linkObjectMethod",type:"string"},description:{title:"linkObjectDescription",type:"string"},params:{title:"linkObjectParams"},server:{title:"linkObjectServer",$ref:"#/definitions/serverObject"}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},externalDocumentationObject:{title:"externalDocumentationObject",type:"object",additionalProperties:!1,description:"information about external documentation",required:["url"],properties:{description:{title:"externalDocumentationObjectDescription",type:"string"},url:{title:"externalDocumentationObjectUrl",type:"string",format:"uri"}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},methodObject:{title:"methodObject",type:"object",required:["name","params"],additionalProperties:!1,properties:{name:{title:"methodObjectName",description:"The cannonical name for the method. The name MUST be unique within the methods array.",type:"string",minLength:1},description:{title:"methodObjectDescription",description:"A verbose explanation of the method behavior. GitHub Flavored Markdown syntax MAY be used for rich text representation.",type:"string"},summary:{title:"methodObjectSummary",description:"A short summary of what the method does.",type:"string"},servers:{title:"servers",type:"array",additionalItems:!1,items:{$ref:"#/definitions/serverObject"}},tags:{title:"methodObjectTags",type:"array",items:{title:"tagOrReference",oneOf:[{$ref:"#/definitions/tagObject"},{$ref:"#/definitions/referenceObject"}]}},paramStructure:{title:"methodObjectParamStructure",type:"string",description:"Format the server expects the params. Defaults to 'either'.",enum:["by-position","by-name","either"],default:"either"},params:{title:"methodObjectParams",type:"array",items:{title:"contentDescriptorOrReference",oneOf:[{$ref:"#/definitions/contentDescriptorObject"},{$ref:"#/definitions/referenceObject"}]}},result:{title:"methodObjectResult",oneOf:[{$ref:"#/definitions/contentDescriptorObject"},{$ref:"#/definitions/referenceObject"}]},errors:{title:"methodObjectErrors",description:"Defines an application level error.",type:"array",items:{title:"errorOrReference",oneOf:[{$ref:"#/definitions/errorObject"},{$ref:"#/definitions/referenceObject"}]}},links:{title:"methodObjectLinks",type:"array",items:{title:"linkOrReference",oneOf:[{$ref:"#/definitions/linkObject"},{$ref:"#/definitions/referenceObject"}]}},examples:{title:"methodObjectExamples",type:"array",items:{title:"examplePairingOrReference",oneOf:[{$ref:"#/definitions/examplePairingObject"},{$ref:"#/definitions/referenceObject"}]}},deprecated:{title:"methodObjectDeprecated",type:"boolean",default:!1},externalDocs:{$ref:"#/definitions/externalDocumentationObject"}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},tagObject:{title:"tagObject",type:"object",additionalProperties:!1,required:["name"],properties:{name:{title:"tagObjectName",type:"string",minLength:1},description:{title:"tagObjectDescription",type:"string"},externalDocs:{$ref:"#/definitions/externalDocumentationObject"}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},exampleObject:{title:"exampleObject",type:"object",required:["name","value"],properties:{summary:{title:"exampleObjectSummary",type:"string"},value:{title:"exampleObjectValue"},description:{title:"exampleObjectDescription",type:"string"},name:{title:"exampleObjectName",type:"string",minLength:1}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}},examplePairingObject:{title:"examplePairingObject",type:"object",required:["name","params"],properties:{name:{title:"examplePairingObjectName",type:"string",minLength:1},description:{title:"examplePairingObjectDescription",type:"string"},params:{title:"examplePairingObjectParams",type:"array",items:{title:"exampleOrReference",oneOf:[{$ref:"#/definitions/exampleObject"},{$ref:"#/definitions/referenceObject"}]}},result:{title:"examplePairingObjectResult",oneOf:[{$ref:"#/definitions/exampleObject"},{$ref:"#/definitions/referenceObject"}]}}},contentDescriptorObject:{title:"contentDescriptorObject",type:"object",additionalProperties:!1,required:["name","schema"],properties:{name:{title:"contentDescriptorObjectName",type:"string",minLength:1},description:{title:"contentDescriptorObjectDescription",type:"string"},summary:{title:"contentDescriptorObjectSummary",type:"string"},schema:{$ref:"#/definitions/JSONSchema"},required:{title:"contentDescriptorObjectRequired",type:"boolean",default:!1},deprecated:{title:"contentDescriptorObjectDeprecated",type:"boolean",default:!1}},patternProperties:{"^x-":{$ref:"#/definitions/specificationExtension"}}}}},a.default=a.openrpcDocument}}},{package:"@open-rpc/meta-schema",file:"node_modules/@open-rpc/meta-schema/index.js"}]],[],{});