LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={openrpc:"1.2.4",info:{title:"MetaMask MultiChain API",version:"1.0.0",description:"This provides the specs for the MultiChain API Layer for the MetaMask API"},methods:[{name:"wallet_notify",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"notification",description:"an object containing a JSON-RPC notification with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}]},{name:"wallet_invokeMethod",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"request",description:"an object containing a JSON-RPC request with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}],result:{name:"wallet_invokeMethodResult",schema:!0},examples:[{name:"wallet_invokeMethodExample",params:[{name:"scope",value:"eip155:1"},{name:"request",value:{method:"eth_getBalance",params:[]}}],result:{name:"wallet_invokeMethodResult",value:"0x1"}}]},{name:"wallet_revokeSession",description:"The `wallet_revokeSession` method revokes the entire active session.",params:[],result:{name:"wallet_revokeSessionResult",schema:{type:"boolean"}},examples:[{name:"wallet_revokeSessionExample",params:[],result:{name:"wallet_revokeSessionExampleResult",value:!0}}],errors:[{$ref:"#/components/errors/UnknownError"}]},{name:"wallet_sessionChanged",paramStructure:"by-name",description:"This notification is published by the wallet to notify the callers of updates to a shared session's authorization scopes. The event payload contains the new `sessionScopes`.",params:[{name:"sessionScopes",schema:{$ref:"#/components/schemas/SessionScopes"}}],examples:[{name:"wallet_sessionChangedExample",description:"Example of a wallet_sessionChanged notification.",params:[{name:"sessionScopes",value:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}]}]},{name:"wallet_getSession",description:"The `wallet_getSession` method returns an active session.",params:[],result:{name:"wallet_getSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"}}}},examples:[{name:"wallet_getSessionExample",description:"Example of a getSession request.",params:[],result:{name:"wallet_getSessionResultExample",value:{sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}}]},{name:"wallet_createSession",paramStructure:"by-name",params:[{name:"requiredScopes",description:"Scopes that the wallet must support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"optionalScopes",description:"Scopes that the wallet may support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"sessionProperties",description:"Properties that the wallet may use to determine if the session is valid.",schema:{type:"object"}}],result:{name:"wallet_createSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"},sessionProperties:{type:"object"}}}},examples:[{name:"wallet_createSessionEthExample",description:"Example of a createSession request.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{methods:["wallet_addEthereumChain"],notifications:[]}}}],result:{name:"wallet_createSessionResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionEthUnsupportedMethodsExample",description:"Example of a createSession request with unsupported eip155 methods.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["not_supported"],notifications:[]},wallet:{methods:[],notifications:[]},"wallet:eip155":{methods:[],notifications:[]}}}],result:{name:"wallet_createSessionEthUnsupportedMethodsResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionUnsupportedScopesExample",description:"Example of a createSession request with unsupported scopes.",params:[{name:"optionalScopes",value:{foobar:{methods:["eth_getBalance"],notifications:["eth_subscription"]},"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}],result:{name:"wallet_createSessionUnsupportedScopesResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}}}],errors:[{$ref:"#/components/errors/UnknownError"},{code:5100,message:"Requested networks are not supported"},{code:5101,message:"Requested methods are not supported"},{code:5102,message:"Requested notifications are not supported"},{code:5300,message:"Invalid scopedProperties requested"},{code:5301,message:"scopedProperties can only be outside of sessionScopes"},{code:5302,message:"Invalid sessionProperties requested"}]}],components:{errors:{UnknownError:{code:5e3,message:"Unknown error with request"}},schemas:{SessionScopes:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}},ScopeString:{type:"string",pattern:"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?"},Scope:{type:"object",title:"Scope",description:"Scope for a multi-chain connection",additionalProperties:!0,required:["notifications","methods"],properties:{scopes:{type:"array",items:{$ref:"#/components/schemas/ScopeString"}},methods:{description:"Methods that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},notifications:{description:"Notifications that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},rpcEndpoints:{description:"JSON-RPC endpoints for this namespace.",type:"array",items:{type:"string",format:"uri"}},rpcDocuments:{type:"array",description:"OpenRPC documents that define RPC methods in which to anchor the methods authorized in a CAIP-25 interaction.",items:{type:"string",format:"uri"}}}}}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js",{"./build/multichain-openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json","./build/openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.MultiChainOpenRPCDocument=n.MetaMaskOpenRPCDocument=void 0;const r=s(e("./build/openrpc.json"));n.MetaMaskOpenRPCDocument=r.default;const a=s(e("./build/multichain-openrpc.json"));n.MultiChainOpenRPCDocument=a.default,n.default=r.default}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={"0x12652C6d93FDB6F4f37d48A8687783C782BB0d10":{name:"Entangle",logo:"NGL.svg",erc20:!0,symbol:"NGL",decimals:18},"0xB50721BCf8d664c30412Cfbc6cf7a15145234ad1":{name:"Arbitrum",logo:"Arb.svg",erc20:!0,symbol:"ARB",decimals:18},"0x4D0528598F916Fd1D8dc80e5f54a8fEEDcFd4b18":{name:"Atoshi",logo:"ATOS.svg",erc20:!0,symbol:"ATOS",decimals:18},"0x57B946008913B82E4dF85f501cbAeD910e58D26C":{name:"POND",logo:"POND.svg",erc20:!0,symbol:"POND",decimals:18},"0x5eed99d066a8CaF10f3E4327c1b3D8b673485eED":{name:"SEED",logo:"SEED.svg",erc20:!0,symbol:"SEED",decimals:18},"0x487d62468282Bd04ddf976631C23128A425555EE":{name:"UPCX",logo:"UPC.svg",erc20:!0,symbol:"UPC",decimals:5},"0xd3210F246Ae54C5a45A7b4A83315bf718F591bfc":{name:"ArkiTech",logo:"ARKI.svg",erc20:!0,symbol:"ARKI",decimals:9},"0x7d51888C5ABb7CDfa9cdd6A50673c7F8afAccD7F":{name:"DuckDAO Token",logo:"duckdao.svg",erc20:!0,symbol:"DD",decimals:18},"0x49642110B712C1FD7261Bc074105E9E44676c68F":{name:"DinoLFG",logo:"DINO.svg",erc20:!0,symbol:"DINO",decimals:18},"0xB8BAa0e4287890a5F79863aB62b7F175ceCbD433":{name:"Swerve DAO Token",logo:"swrv.svg",erc20:!0,symbol:"SWRV",decimals:18},"0x8b79656FC38a04044E495e22fAD747126ca305C4":{name:"AgaveCoin",logo:"agvc.svg",erc20:!0,symbol:"AGVC",decimals:18},"0x967da4048cD07aB37855c090aAF366e4ce1b9F48":{name:"Ocean Token",logo:"ocean.svg",erc20:!0,symbol:"OCEAN",decimals:18},"0x83e6f1E41cdd28eAcEB20Cb649155049Fac3D5Aa":{name:"PolkastarterToken",logo:"pols.svg",erc20:!0,symbol:"POLS",decimals:18},"0x08d967bb0134F2d07f7cfb6E246680c53927DD30":{name:"MATH Token",logo:"math.svg",erc20:!0,symbol:"MATH",decimals:18},"0xccC8cb5229B0ac8069C51fd58367Fd1e622aFD97":{name:"Gods Unchained",logo:"gods.svg",erc20:!0,symbol:"GODS",decimals:18},"0xF57e7e7C23978C3cAEC3C3548E3D615c346e79fF":{name:"Immutable X",logo:"imx.svg",erc20:!0,symbol:"IMX",decimals:18},"0x40D16FC0246aD3160Ccc09B8D0D3A2cD28aE6C2f":{name:"Gho Token",logo:"GHO.svg",erc20:!0,symbol:"GHO",decimals:18},"0x536381a8628dBcC8C70aC9A30A7258442eAb4c92":{name:"Pantos Token ",logo:"pan.svg",erc20:!0,symbol:"PAN",decimals:8},"0x011E128Ec62840186F4A07E85E3ACe28858c5606":{name:"Valeria",logo:"val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x6c3ea9036406852006290770BEdFcAbA0e23A0e8":{name:"PayPal USD",logo:"pyusd.svg",erc20:!0,symbol:"PYUSD",decimals:6},"0x8b385Ca3592A5EFc34E0C9fE663de56897F1751F":{name:"INFibit",logo:"INFibit.svg",erc20:!0,symbol:"IBIT",decimals:18},"0x9bf1D7D63dD7a4ce167CF4866388226EEefa702E":{name:"Ben Coin",logo:"BEN.svg",erc20:!0,symbol:"BEN",decimals:18},"0xC7a2572fA8FDB0f7E81d6D3c4e3CCF78FB0DC374":{name:"Bens Finale",logo:"BensFinale.svg",erc20:!0,symbol:"FINALE",decimals:18},"0x99cFB8cBA9c821B4a343c6a1Fc630465C9708DF5":{name:"Pepe Inu",logo:"PepeInu.svg",erc20:!0,symbol:"$PEPEINU",decimals:18},"0xCEBA2a8F6Ec221AEB5f3a7bcd15Cbc7e6a387bfb":{name:"Peter Pan",logo:"PeterPan.svg",erc20:!0,symbol:"PAN",decimals:18},"0x467719aD09025FcC6cF6F8311755809d45a5E5f3":{name:"Axelar",logo:"axelar.svg",erc20:!0,symbol:"AXL",decimals:6},"0x665F77fbA5975ab40Ce61c90F28007fb5b09D7B1":{name:"Genieswap",logo:"Genieswap.svg",erc20:!0,symbol:"GENIE",decimals:18},"0x09E6d500D14D13e0528d2c0fff24E5ffF68237B4":{name:"Dohrnii",logo:"dhn.svg",erc20:!0,symbol:"DHN",decimals:18},"0xaE0585a259A3BCAB258D6EE02FB583f7B33C2a12":{name:"TempleCoin",logo:"tem.svg",erc20:!0,symbol:"TEM",decimals:18},"0xaeDf386B755465871fF874E3E37Af5976E247064":{name:"Fasttoken",logo:"ftn.svg",erc20:!0,symbol:"FTN",decimals:18},"0x7BEF710a5759d197EC0Bf621c3Df802C2D60D848":{name:"SHOPX",logo:"SHOPX.svg",erc20:!0,symbol:"SHOPX",decimals:18},"0xBa3335588D9403515223F109EdC4eB7269a9Ab5D":{name:"Gearbox",logo:"gear.svg",erc20:!0,symbol:"GEAR",decimals:18},"0x9B6B9d2468E165a02FEf69E61B6D3D6CBC0Ac409":{name:"OASISLIFE",logo:"OFE.svg",erc20:!0,symbol:"OFE",decimals:18},"0xdf0162A6B3e9fDf0302c1e949739DeeaFafd8F89":{name:"METAOASIS",logo:"MOA.svg",erc20:!0,symbol:"MOA",decimals:18},"0xe4dae00bc1c46ea2F44ae71B1BEb8b171C15d812":{name:"PREMA",logo:"PREMA.svg",erc20:!0,symbol:"PRMX",decimals:18},"0x1416946162B1C2c871A73B07E932D2fB6C932069":{name:"Energi",logo:"energi.svg",erc20:!0,symbol:"NRG",decimals:18},"0x0d88eD6E74bbFD96B831231638b66C05571e824F":{name:"Aventus",logo:"aventus.svg",erc20:!0,symbol:"AVT",decimals:18},"0x4FC15c91a9c4A9efB404174464687E8e128730C2":{name:"STAT",logo:"STAT.svg",erc20:!0,erc721:!1,symbol:"STAT",decimals:18},"0x4ad7a056191F4c9519fAcd6D75FA94CA26003aCE":{name:"GoldPesa Option",logo:"GPO.svg",erc20:!0,symbol:"GPO",decimals:18},"0x767FE9EDC9E0dF98E07454847909b5E959D7ca0E":{name:"Illuvium",logo:"illuvium.svg",erc20:!0,erc721:!1,symbol:"ILV",decimals:18},"0x85F17Cf997934a597031b2E18a9aB6ebD4B9f6a4":{name:"NEAR",logo:"NEAR.svg",erc20:!0,symbol:"NEAR",decimals:24},"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2":{name:"SushiSwap",logo:"sushi.svg",erc20:!0,erc721:!1,symbol:"SUSHI",decimals:18},"0x881Ba05de1E78f549cC63a8f6Cabb1d4AD32250D":{name:"00",logo:"00.svg",erc20:!0,erc721:!1,symbol:"00",decimals:18},"0xC211477cb4098aC22a98432781f5f26a1E07a4d4":{name:"CULTURED",logo:"CULTURED.svg",erc20:!0,erc721:!1,symbol:"CULTURED",decimals:18},"0x86f2A193b116d1f9C53Ed26d97F77cDC8BcF4c2b":{name:"EHTAGA",logo:"EHTAGA.svg",erc20:!0,erc721:!1,symbol:"EHTAGA",decimals:18},"0x54b79A15b2e2c55c736A66bb0A978fb840407aC8":{name:"FEVER",logo:"FEVER.svg",erc20:!0,erc721:!1,symbol:"FEVER",decimals:18},"0x677c9fE4396D3D13A0F9013a8118eAE386C843A5":{name:"IAM",logo:"IAM.svg",erc20:!0,erc721:!1,symbol:"IAM",decimals:18},"0xf63c65E855020E4B74f0Ad842D9537dA0E6162eC":{name:"ISH",logo:"ISH.svg",erc20:!0,erc721:!1,symbol:"ISH",decimals:18},"0xc105fA46510F32c0444CCdB4e51065da95caA1B4":{name:"LITA",logo:"LITA.svg",erc20:!0,erc721:!1,symbol:"LITA",decimals:18},"0x5401F949cDfa3E5aF32538167c0314230769209C":{name:"MAHCOIN",logo:"MAHCOIN.svg",erc20:!0,erc721:!1,symbol:"MAHCOIN",decimals:18},"0x711D2C47aFf84B96AD0F36983b1c41Be2C509e18":{name:"NIKITA",logo:"NIKITA.svg",erc20:!0,erc721:!1,symbol:"NIKITA",decimals:18},"0x3C44aEc33993b6830e5C2a705ea879b9C9ba0f7c":{name:"NYELA",logo:"NYELA.svg",erc20:!0,erc721:!1,symbol:"NYELA",decimals:18},"0xfa9096c99e687ea8E0064C23DAaCFE87cc99E4Ba":{name:"RON",logo:"RON.svg",erc20:!0,erc721:!1,symbol:"RON",decimals:18},"0x287a7C95aD00bBDd48599Ad2919567fD09281f07":{name:"STEELO",logo:"STEELO.svg",erc20:!0,erc721:!1,symbol:"STEELO",decimals:18},"0x2Ec3275f7aCe4044e499823F511cd58250be8E3d":{name:"Privilege",logo:"prvg.svg",erc20:!0,symbol:"PRVG",decimals:8},"0x65BB569FAaDD324a00883FdE4c46346cc96D5c0A":{name:"Provide",logo:"prvd.svg",erc20:!0,symbol:"PRVD",decimals:8},"0xB4272071eCAdd69d933AdcD19cA99fe80664fc08":{name:"CryptoFranc",logo:"XCHF.svg",erc20:!0,symbol:"XCHF",decimals:18},"0x5aFE3855358E112B5647B952709E6165e1c1eEEe":{name:"Safe Token",logo:"safe-green-token.svg",erc20:!0,symbol:"SAFE",decimals:18},"0x9C8fF314C9Bc7F6e59A9d9225Fb22946427eDC03":{name:"Nouns",erc20:!1,erc721:!0,symbol:"NOUN",decimals:0,logo:"nouns.svg"},"0xBC4CA0EdA7647A8aB7C2061c2E118A18a936f13D":{name:"BoredApeYachtClub",erc20:!1,erc721:!0,symbol:"BAYC",decimals:0,logo:"bayc.svg"},"0x08D7C0242953446436F34b4C78Fe9da38c73668d":{name:"PROOF Collective",erc20:!1,erc721:!0,symbol:"PROOF",decimals:0,logo:"proof.svg"},"0x23581767a106ae21c074b2276D25e5C3e136a68b":{name:"Moonbirds",erc20:!1,erc721:!0,symbol:"MOONBIRD",decimals:0,logo:"moonbirds.svg"},"0x60E4d786628Fea6478F785A6d7e704777c86a7c6":{name:"MutantApeYachtClub",erc20:!1,erc721:!0,symbol:"MAYC",decimals:0,logo:"mayc.svg"},"0x49cF6f5d44E70224e2E23fDcdd2C053F30aDA28B":{name:"CloneX",erc20:!1,erc721:!0,symbol:"CloneX",decimals:0,logo:"clonex.svg"},"0x8a90CAb2b38dba80c64b7734e58Ee1dB38B8992e":{name:"Doodles",erc20:!1,erc721:!0,symbol:"DOODLE",decimals:0,logo:"doodles.svg"},"0xED5AF388653567Af2F388E6224dC7C4b3241C544":{name:"Azuki",erc20:!1,erc721:!0,symbol:"AZUKI",decimals:0,logo:"azuki.svg"},"0xa3AEe8BcE55BEeA1951EF834b99f3Ac60d1ABeeB":{name:"VeeFriends",erc20:!1,erc721:!0,symbol:"VFT",decimals:0,logo:"veefriends.svg"},"0x34d85c9CDeB23FA97cb08333b511ac86E1C4E258":{name:"Otherdeed",erc20:!1,erc721:!0,symbol:"OTHR",decimals:0,logo:"otherdeed.svg"},"0xBBc2AE13b23d715c30720F079fcd9B4a74093505":{name:"Ethernity Chain Token",logo:"ERN.svg",erc20:!0,symbol:"ERN",decimals:18},"0x243cACb4D5fF6814AD668C3e225246efA886AD5a":{name:"Shina Inu",logo:"shina.svg",erc20:!0,symbol:"SHI",decimals:18},"0xD057B63f5E69CF1B929b356b579Cba08D7688048":{name:"CoW Protocol Virtual Token",logo:"vCOW.svg",erc20:!0,symbol:"vCOW",decimals:18},"0xDEf1CA1fb7FBcDC777520aa7f396b4E015F497aB":{name:"CoW Protocol Token",logo:"COW.svg",erc20:!0,symbol:"COW",decimals:18},"0xEd04915c23f00A313a544955524EB7DBD823143d":{name:"Alchemy Pay",logo:"ACH.svg",erc20:!0,symbol:"ACH",decimals:8},"0xeDF6568618A00C6F0908Bf7758A16F76B6E04aF9":{name:"Arianee",logo:"aria20.svg",erc20:!0,symbol:"ARIA20",decimals:18},"0x88D8DA2A8D0fA5b1f4E38030AC486aDE0AFA2798":{name:"Terrapass Coin",logo:"tpsc.svg",erc20:!0,symbol:"TPSC",decimals:18},"0x4730fB1463A6F1F44AEB45F6c5c422427f37F4D0":{name:"The 4th Pillar Token",logo:"four.svg",erc20:!0,symbol:"FOUR",decimals:18},"0x875773784Af8135eA0ef43b5a374AaD105c5D39e":{name:"Idle DAO Token",logo:"idle.svg",erc20:!0,symbol:"IDLE",decimals:18},"0x6BeA7CFEF803D1e3d5f7C0103f7ded065644e197":{name:"Gamma",logo:"Gamma.svg",erc20:!0,symbol:"GAMMA",decimals:18},"0x26805021988F1a45dC708B5FB75Fc75F21747D8c":{name:"xGamma",logo:"xGamma.svg",erc20:!0,symbol:"xGAMMA",decimals:18},"0xc7D9c108D4E1dD1484D3e2568d7f74bfD763d356":{name:"SORA Synthetic USD",logo:"sora-xstusd.svg",erc20:!0,symbol:"XSTUSD",decimals:18},"0x519C1001D550C0a1DaE7d1fC220f7d14c2A521BB":{name:"Polkaswap",logo:"sora-pswap.svg",erc20:!0,symbol:"PSWAP",decimals:18},"0x40FD72257597aA14C7231A7B1aaa29Fce868F677":{name:"SORA",logo:"sora-xor.svg",erc20:!0,symbol:"XOR",decimals:18},"0x909E34d3f6124C324ac83DccA84b74398a6fa173":{name:"$ZKP Token",logo:"ZKP.svg",erc20:!0,erc721:!1,symbol:"$ZKP",decimals:18},"0xe88f8313e61A97cEc1871EE37fBbe2a8bf3ed1E4":{name:"SORA Validator",logo:"sora-val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x7A58c0Be72BE218B41C608b7Fe7C5bB630736C71":{name:"ConstitutionDAO",logo:"PEOPLE.svg",erc20:!0,symbol:"PEOPLE",decimals:18},"0x32E6C34Cd57087aBBD59B5A4AECC4cB495924356":{name:"BitBase",logo:"BTBS.svg",erc20:!0,symbol:"BTBS",decimals:18},"0x3fa400483487A489EC9b1dB29C4129063EEC4654":{name:"Cryptokek.com",logo:"cryptokek.svg",erc20:!0,symbol:"KEK",decimals:18},"0xEd3D4e446A96dC3b181B64B75c3c70dA41dC3CBe":{name:"Vodra",logo:"Vodra.svg",erc20:!0,symbol:"VDR",decimals:18},"0xb753428af26E81097e7fD17f40c88aaA3E04902c":{name:"Spice",logo:"sfi.svg",erc20:!0,symbol:"SFI",decimals:18},"0xd084944d3c05CD115C09d072B9F44bA3E0E45921":{name:"Manifold Finance",logo:"Manifold.svg",erc20:!0,symbol:"FOLD",decimals:18},"0x9a0242b7a33DAcbe40eDb927834F96eB39f8fBCB":{name:"BABB",logo:"bax.svg",erc20:!0,symbol:"BAX",decimals:18},"0x4Cf89ca06ad997bC732Dc876ed2A7F26a9E7f361":{name:"Mysterium",logo:"MYST.svg",erc20:!0,symbol:"MYST",decimals:18},"0x697eF32B4a3F5a4C39dE1cB7563f24CA7BfC5947":{name:"Insula Token",logo:"Insula.svg",erc20:!0,symbol:"ISLA",decimals:18},"0x62Dc4817588d53a056cBbD18231d91ffCcd34b2A":{name:"DeHive",logo:"dehive.svg",erc20:!0,erc721:!1,symbol:"DHV",decimals:18},"0x8400D94A5cb0fa0D041a3788e395285d61c9ee5e":{name:"Unibright",logo:"ubt.svg",erc20:!0,symbol:"UBT",decimals:8},"0xfAd45E47083e4607302aa43c65fB3106F1cd7607":{name:"Hoge Finance",logo:"HogeFinanceLogo.svg",erc20:!0,symbol:"HOGE",decimals:9},"0xBB0E17EF65F82Ab018d8EDd776e8DD940327B28b":{name:"Axie Infinity Shard",logo:"AXS.svg",erc20:!0,symbol:"AXS",decimals:18},"0xCC8Fa225D80b9c7D42F96e9570156c65D6cAAa25":{name:"Smooth Love Potion",logo:"SLP.svg",erc20:!0,symbol:"SLP",decimals:0},"0x10633216E7E8281e33c86F02Bf8e565a635D9770":{name:"Dvision Network",logo:"dvision.svg",erc20:!0,symbol:"DVI",decimals:18},"0x898BAD2774EB97cF6b94605677F43b41871410B1":{name:"vEth2",logo:"vEth2.svg",erc20:!0,symbol:"vEth2",decimals:18},"0x321C2fE4446C7c963dc41Dd58879AF648838f98D":{name:"Cryptex Finance",logo:"ctx.svg",erc20:!0,symbol:"CTX",decimals:18},"0x16c52CeeCE2ed57dAd87319D91B5e3637d50aFa4":{name:"TCAP Token",logo:"tcap.svg",erc20:!0,symbol:"TCAP",decimals:18},"0xE94B97b6b43639E238c851A7e693F50033EfD75C":{name:"Rainbow Token",logo:"halodao-rnbw.svg",erc20:!0,symbol:"RNBW",decimals:18},"0x47BE779De87de6580d0548cde80710a93c502405":{name:"Rainbow Pool",logo:"halodao-xrnbw.svg",erc20:!0,symbol:"xRNBW",decimals:18},"0xe7aE6D0C56CACaf007b7e4d312f9af686a9E9a04":{name:"Vabble",logo:"VAB.svg",erc20:!0,symbol:"VAB",decimals:18},"0x853d955aCEf822Db058eb8505911ED77F175b99e":{name:"Frax",logo:"frax.svg",erc20:!0,symbol:"FRAX",decimals:18},"0x3432B6A60D23Ca0dFCa7761B7ab56459D9C964D0":{name:"Frax Share",logo:"fxs.svg",erc20:!0,symbol:"FXS",decimals:18},"0x84810bcF08744d5862B8181f12d17bfd57d3b078":{name:"SharedStake",logo:"sharedstake.svg",erc20:!0,symbol:"SGT",decimals:18},"0x75387e1287Dd85482aB66102DA9f6577E027f609":{name:"MindsyncAI",logo:"MAI.svg",erc20:!0,symbol:"MAI",decimals:18},"0x196f4727526eA7FB1e17b2071B3d8eAA38486988":{name:"Reserve",logo:"rsv.svg",erc20:!0,symbol:"RSV",decimals:18},"0x320623b8E4fF03373931769A31Fc52A4E78B5d70":{name:"Reserve Rights",logo:"rsr.svg",erc20:!0,symbol:"RSR",decimals:18},"0x1cF4592ebfFd730c7dc92c1bdFFDfc3B9EfCf29a":{name:"WAVES",logo:"waves.svg",erc20:!0,symbol:"WAVES",decimals:18},"0x252739487C1fa66eaeaE7CED41d6358aB2a6bCa9":{name:"ArCoin",logo:"ArCoin.svg",erc20:!0,symbol:"RCOIN",decimals:8},"0x18aAA7115705e8be94bfFEBDE57Af9BFc265B998":{name:"Audius",logo:"audius.svg",erc20:!0,symbol:"AUDIO",decimals:18},"0x8E3BCC334657560253B83f08331d85267316e08a":{name:"Rubic",logo:"brbc.svg",erc20:!0,symbol:"BRBC",decimals:18},"0xca1207647Ff814039530D7d35df0e1Dd2e91Fa84":{name:"dHEDGE DAO Token",logo:"DHT.svg",erc20:!0,symbol:"DHT",decimals:18},"0x6243d8CEA23066d098a15582d81a598b4e8391F4":{name:"Reflexer Ungovernance Token",logo:"flx.svg",erc20:!0,symbol:"FLX",decimals:18},"0x03ab458634910AaD20eF5f1C8ee96F1D6ac54919":{name:"Rai Reflex Index",logo:"rai.svg",erc20:!0,symbol:"RAI",decimals:18},"0xF25c91C87e0B1fd9B4064Af0F427157AaB0193A7":{name:"BASIC Token",logo:"basic.svg",erc20:!0,symbol:"BASIC",decimals:18},"0x53C8395465A84955c95159814461466053DedEDE":{name:"DeGate Token",logo:"DG.svg",erc20:!0,symbol:"DG",decimals:18},"0xBCf9dBf8B14eD096B2BA08b7269356197fDd1b5D":{name:"Avaluse",logo:"avaluse.svg",erc20:!0,symbol:"AVAL",decimals:18},"0x6E765D26388A17A6e86c49A8E41DF3F58aBcd337":{name:"Kangal",logo:"kangal.svg",erc20:!0,symbol:"KANGAL",decimals:18},"0x9AF4f26941677C706cfEcf6D3379FF01bB85D5Ab":{name:"DomRaiderToken",logo:"drt.svg",erc20:!0,symbol:"DRT",decimals:8},"0x06B179e292f080871825beD5D722162fD96B4c95":{name:"10x.gg",logo:"xgg.svg",erc20:!0,symbol:"XGG",decimals:18},"0xF29992D7b589A0A6bD2de7Be29a97A6EB73EaF85":{name:"DMScript",logo:"dmst.svg",erc20:!0,symbol:"DMST",decimals:18},"0x64aa3364F17a4D01c6f1751Fd97C2BD3D7e7f1D5":{name:"Olympus",logo:"OHM.svg",erc20:!0,symbol:"OHM",decimals:9},"0x0ab87046fBb341D058F17CBC4c1133F25a20a52f":{name:"Governance OHM",logo:"gOHM.svg",erc20:!0,symbol:"gOHM",decimals:18},"0xDd1Ad9A21Ce722C151A836373baBe42c868cE9a4":{name:"Universal Basic Income",logo:"ubi.svg",erc20:!0,symbol:"UBI",decimals:18},"0xf293d23BF2CDc05411Ca0edDD588eb1977e8dcd4":{name:"Sylo",logo:"SYLO.svg",erc20:!0,symbol:"SYLO",decimals:18},"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84":{name:"Liquid staked Ether 2.0",logo:"stETH.svg",erc20:!0,symbol:"stETH",decimals:18},"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0":{name:"Wrapped liquid staked Ether 2.0",logo:"wstETH.svg",erc20:!0,symbol:"wstETH",decimals:18},"0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32":{name:"Lido DAO Token",logo:"LDO.svg",erc20:!0,symbol:"LDO",decimals:18},"0xbd31EA8212119f94A611FA969881CBa3EA06Fa3d":{name:"LUNA Token",logo:"Luna.svg",erc20:!0,symbol:"LUNA",decimals:6},"0xa693B19d2931d498c5B318dF961919BB4aee87a5":{name:"UST Token",logo:"UST.svg",erc20:!0,symbol:"UST",decimals:6},"0xd2877702675e6cEb975b4A1dFf9fb7BAF4C91ea9":{name:"LUNA Token - Shuttle",logo:"lunc.svg",erc20:!0,symbol:"LUNC",decimals:18},"0xa47c8bf37f92aBed4A126BDA807A7b7498661acD":{name:"UST Token - Shuttle",logo:"ustc.svg",erc20:!0,symbol:"USTC",decimals:18},"0xcAAfF72A8CbBfc5Cf343BA4e26f65a257065bFF1":{name:"KRT Token - Shuttle",logo:"KRT.svg",erc20:!0,symbol:"KRT-S",decimals:18},"0x676Ad1b33ae6423c6618C1AEcf53BAa29cf39EE5":{name:"SDT Token - Shuttle",logo:"SDT.svg",erc20:!0,symbol:"SDT-S",decimals:18},"0x156B36ec68FdBF84a925230BA96cb1Ca4c4bdE45":{name:"MNT Token - Shuttle",logo:"MNT.svg",erc20:!0,symbol:"MNT-S",decimals:18},"0x09a3EcAFa817268f77BE1283176B946C4ff2E608":{name:"MIR Token - Shuttle",logo:"MIR.svg",erc20:!0,symbol:"MIR-S",decimals:18},"0xd36932143F6eBDEDD872D5Fb0651f4B72Fd15a84":{name:"Mirror AAPL Token - Shuttle",logo:"mAAPL.svg",erc20:!0,symbol:"mAAPL-S",decimals:18},"0x59A921Db27Dd6d4d974745B7FfC5c33932653442":{name:"Mirror GOOGL Token - Shuttle",logo:"mGOOGL.svg",erc20:!0,symbol:"mGOGL-S",decimals:18},"0x21cA39943E91d704678F5D00b6616650F066fD63":{name:"Mirror TSLA Token - Shuttle",logo:"mTSLA.svg",erc20:!0,symbol:"mTSLA-S",decimals:18},"0xC8d674114bac90148d11D3C1d33C61835a0F9DCD":{name:"Mirror NFLX Token - Shuttle",logo:"mNFLX.svg",erc20:!0,symbol:"mNFLX-S",decimals:18},"0x13B02c8dE71680e71F0820c996E4bE43c2F57d15":{name:"Mirror QQQ Token - Shuttle",logo:"mQQQ.svg",erc20:!0,symbol:"mQQQ-S",decimals:18},"0xEdb0414627E6f1e3F082DE65cD4F9C693D78CCA9":{name:"Mirror TWTR Token - Shuttle",logo:"mTWTR.svg",erc20:!0,symbol:"mTWTR-S",decimals:18},"0x41BbEDd7286dAab5910a1f15d12CBda839852BD7":{name:"Mirror MSFT Token - Shuttle",logo:"mMSFT.svg",erc20:!0,symbol:"mMSFT-S",decimals:18},"0x0cae9e4d663793c2a2A0b211c1Cf4bBca2B9cAa7":{name:"Mirror AMZN Token - Shuttle",logo:"mAMZN.svg",erc20:!0,symbol:"mAMZN-S",decimals:18},"0x56aA298a19C93c6801FDde870fA63EF75Cc0aF72":{name:"Mirror BABA Token - Shuttle",logo:"mBABA.svg",erc20:!0,symbol:"mBABA-S",decimals:18},"0x1d350417d9787E000cc1b95d70E9536DcD91F373":{name:"Mirror IAU Token - Shuttle",logo:"mIAU.svg",erc20:!0,symbol:"mIAU-S",decimals:18},"0x9d1555d8cB3C846Bb4f7D5B1B1080872c3166676":{name:"Mirror SLV Token - Shuttle",logo:"mSLV.svg",erc20:!0,symbol:"mSLV-S",decimals:18},"0x31c63146a635EB7465e5853020b39713AC356991":{name:"Mirror USO Token - Shuttle",logo:"mUSO.svg",erc20:!0,symbol:"mUSO-S",decimals:18},"0xf72FCd9DCF0190923Fadd44811E240Ef4533fc86":{name:"Mirror VIXY Token - Shuttle",logo:"mVIXY.svg",erc20:!0,symbol:"mVIXY-S",decimals:18},"0x21BfBDa47A0B4B5b1248c767Ee49F7caA9B23697":{name:"OVR",logo:"OVR.svg",erc20:!0,symbol:"OVR",decimals:18},"0x4691937a7508860F876c9c0a2a617E7d9E945D4B":{name:"Wootrade Network",logo:"wootrade.svg",erc20:!0,symbol:"WOO",decimals:18},"0xaf9f549774ecEDbD0966C52f250aCc548D3F36E5":{name:"RFUEL",logo:"RFUEL.svg",erc20:!0,symbol:"RFUEL",decimals:18},"0x7420B4b9a0110cdC71fB720908340C03F9Bc03EC":{name:"JasmyCoin",logo:"JASMY.svg",erc20:!0,symbol:"JASMY",decimals:18},"0x947AEb02304391f8fbE5B25D7D98D649b57b1788":{name:"Mandala Exchange Token",logo:"mandala.svg",erc20:!0,symbol:"MDX",decimals:18},"0xCdeee767beD58c5325f68500115d4B722b3724EE":{name:"Carbon",logo:"CRBN.svg",erc20:!0,symbol:"CRBN",decimals:18},"0xA4EED63db85311E22dF4473f87CcfC3DaDCFA3E3":{name:"Rubic",logo:"Rubic.svg",erc20:!0,symbol:"RBC",decimals:18},"0x3A880652F47bFaa771908C07Dd8673A787dAEd3A":{name:"DerivaDAO",logo:"DDX.svg",erc20:!0,symbol:"DDX",decimals:18},"0xbC396689893D065F41bc2C6EcbeE5e0085233447":{name:"Perpetual",logo:"PERP.svg",erc20:!0,symbol:"PERP",decimals:18},"0xeca82185adCE47f39c684352B0439f030f860318":{name:"Perlin",logo:"PERL.svg",erc20:!0,symbol:"PERL",decimals:18},"0xA1AFFfE3F4D611d252010E3EAf6f4D77088b0cd7":{name:"Reflect Finance",logo:"RFI.svg",erc20:!0,symbol:"RFI",decimals:9},"0xC0bA369c8Db6eB3924965e5c4FD0b4C1B91e305F":{name:"DLP Duck Token",logo:"dlpducktoken.svg",erc20:!0,symbol:"DUCK",decimals:18},"0xFbEEa1C75E4c4465CB2FCCc9c6d6afe984558E20":{name:"DuckDaoDime",logo:"ddim.svg",erc20:!0,symbol:"DDIM",decimals:18},"0x745407c86DF8DB893011912d3aB28e68B62E49B0":{name:"MahaDAO",logo:"MAHA.svg",erc20:!0,symbol:"MAHA",decimals:18},"0x8CC0F052fff7eaD7f2EdCCcaC895502E884a8a71":{name:"ARTH Valuecoin",logo:"ARTH.svg",erc20:!0,symbol:"ARTH",decimals:18},"0x3231Cb76718CDeF2155FC47b5286d82e6eDA273f":{name:"Monerium EUR",logo:"EURe.svg",erc20:!0,symbol:"EURe",decimals:18},"0x7ba92741Bf2A568abC6f1D3413c58c6e0244F8fD":{name:"Monerium GBP",logo:"GBPe.svg",erc20:!0,symbol:"GBPe",decimals:18},"0xBc5142e0CC5eB16b47c63B0f033d4c2480853a52":{name:"Monerium USD",logo:"USDe.svg",erc20:!0,symbol:"USDe",decimals:18},"0xC642549743A93674cf38D6431f75d6443F88E3E2":{name:"Monerium ISK",logo:"ISKe.svg",erc20:!0,symbol:"ISKe",decimals:18},"0x66a0f676479Cee1d7373f3DC2e2952778BfF5bd6":{name:"WISE Token",logo:"wise.svg",erc20:!0,symbol:"WISE",decimals:18},"0x72F020f8f3E8fd9382705723Cd26380f8D0c66Bb":{name:"PlotX",logo:"plotx.svg",erc20:!0,symbol:"PLOT",decimals:18},"0x44197A4c44D6A059297cAf6be4F7e172BD56Caaf":{name:"ELTCOIN",logo:"ELTCOIN.svg",erc20:!0,symbol:"ELT",decimals:8},"0x6781a0F84c7E9e846DCb84A9a5bd49333067b104":{name:"ZAP TOKEN",logo:"zapicon.svg",erc20:!0,symbol:"ZAP",decimals:18},"0x00c83aeCC790e8a4453e5dD3B0B4b3680501a7A7":{name:"SKALE",logo:"skl.svg",erc20:!0,symbol:"SKL",decimals:18},"0x674C6Ad92Fd080e4004b2312b45f796a192D27a0":{name:"Neutrino USD",logo:"usdn.svg",erc20:!0,symbol:"USDN",decimals:18},"0xE5CAeF4Af8780E59Df925470b050Fb23C43CA68C":{name:"Ferrum Network Token",logo:"frm.svg",erc20:!0,symbol:"FRM",decimals:6},"0x998FFE1E43fAcffb941dc337dD0468d52bA5b48A":{name:"Rupiah Token",logo:"idrt.svg",erc20:!0,symbol:"IDRT",decimals:2},"0x4E15361FD6b4BB609Fa63C81A2be19d873717870":{name:"Fantom",logo:"ftm.svg",erc20:!0,symbol:"FTM",decimals:18},"0x557B933a7C2c45672B610F8954A3deB39a51A8Ca":{name:"REVV",logo:"revv.svg",erc20:!0,symbol:"REVV",decimals:18},"0xFFC97d72E13E01096502Cb8Eb52dEe56f74DAD7B":{name:"Aave AAVE",logo:"aAAVE.svg",erc20:!0,symbol:"aAAVE",decimals:18},"0x05Ec93c0365baAeAbF7AefFb0972ea7ECdD39CF1":{name:"Aave BAT",logo:"aBAT.svg",erc20:!0,symbol:"aBAT",decimals:18},"0xA361718326c15715591c299427c62086F69923D9":{name:"Aave BUSD",logo:"aBUSD.svg",erc20:!0,symbol:"aBUSD",decimals:18},"0x028171bCA77440897B824Ca71D1c56caC55b68A3":{name:"Aave DAI",logo:"aDAI.svg",erc20:!0,symbol:"aDAI",decimals:18},"0xaC6Df26a590F08dcC95D5a4705ae8abbc88509Ef":{name:"Aave ENJ",logo:"aENJ.svg",erc20:!0,symbol:"aENJ",decimals:18},"0xD37EE7e4f452C6638c96536e68090De8cBcdb583":{name:"Aave GUSD",logo:"aGUSD.svg",erc20:!0,symbol:"aGUSD",decimals:2},"0x39C6b3e42d6A679d7D776778Fe880BC9487C2EDA":{name:"Aave KNC",logo:"aKNC.svg",erc20:!0,symbol:"aKNC",decimals:18},"0xa06bC25B5805d5F8d82847D191Cb4Af5A3e873E0":{name:"Aave LINK",logo:"aLINK.svg",erc20:!0,symbol:"aLINK",decimals:18},"0xa685a61171bb30d4072B338c80Cb7b2c865c873E":{name:"Aave MANA",logo:"aMANA.svg",erc20:!0,symbol:"aMANA",decimals:18},"0xc713e5E149D5D0715DcD1c156a020976e7E56B88":{name:"Aave MKR",logo:"aMKR.svg",erc20:!0,symbol:"aMKR",decimals:18},"0xCC12AbE4ff81c9378D670De1b57F8e0Dd228D77a":{name:"Aave REN",logo:"aREN.svg",erc20:!0,symbol:"aREN",decimals:18},"0x35f6B052C598d933D69A4EEC4D04c73A191fE6c2":{name:"Aave SNX",logo:"aSNX.svg",erc20:!0,symbol:"aSNX",decimals:18},"0x6C5024Cd4F8A59110119C56f8933403A539555EB":{name:"Aave SUSD",logo:"aSUSD.svg",erc20:!0,symbol:"aSUSD",decimals:18},"0x101cc05f4A51C0319f570d5E146a8C625198e636":{name:"Aave TUSD",logo:"aTUSD.svg",erc20:!0,symbol:"aTUSD",decimals:18},"0xB9D7CB55f463405CDfBe4E90a6D2Df01C2B92BF1":{name:"Aave UNI",logo:"aUNI.svg",erc20:!0,symbol:"aUNI",decimals:18},"0xBcca60bB61934080951369a648Fb03DF4F96263C":{name:"Aave USDC",logo:"aUSDC.svg",erc20:!0,symbol:"aUSDC",decimals:6},"0x3Ed3B47Dd13EC9a98b44e6204A523E766B225811":{name:"Aave USDT",logo:"aUSDT.svg",erc20:!0,symbol:"aUSDT",decimals:6},"0x9ff58f4fFB29fA2266Ab25e75e2A8b3503311656":{name:"Aave WBTC",logo:"aWBTC.svg",erc20:!0,symbol:"aWBTC",decimals:8},"0x030bA81f1c18d280636F32af80b9AAd02Cf0854e":{name:"Aave WETH",logo:"aWETH.svg",erc20:!0,symbol:"aWETH",decimals:18},"0x5165d24277cD063F5ac44Efd447B27025e888f37":{name:"Aave YFI",logo:"aYFI.svg",erc20:!0,symbol:"aYFI",decimals:18},"0xdef1fac7Bf08f173D286BbBDcBeeADe695129840":{name:"Defi Factory Token",logo:"DEFT.svg",erc20:!0,symbol:"DEFT",decimals:18},"0xDf7FF54aAcAcbFf42dfe29DD6144A69b629f8C9e":{name:"Aave ZRX",logo:"aZRX.svg",erc20:!0,symbol:"aZRX",decimals:18},"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9":{name:"Aave",logo:"AAVE.svg",erc20:!0,symbol:"AAVE",decimals:18},"0x44e2deC86B9F0e0266E9AA66e10323A2bd69CF9A":{name:"Attrace",logo:"attr.svg",erc20:!0,symbol:"ATTR",decimals:18},"0x1Da87b114f35E1DC91F72bF57fc07A768Ad40Bb0":{name:"Equalizer",logo:"EQZ.svg",erc20:!0,symbol:"EQZ",decimals:18},"0x4da27a545c0c5B758a6BA100e3a049001de870f5":{name:"Staked Aave",logo:"stkAAVE.svg",erc20:!0,symbol:"stAAVE",decimals:18},"0xba9d4199faB4f26eFE3551D490E3821486f135Ba":{name:"SwissBorg",logo:"chsb.svg",erc20:!0,symbol:"CHSB",decimals:8},"0x7DD9c5Cba05E151C895FDe1CF355C9A1D5DA6429":{name:"Golem Network Token",logo:"glm.svg",erc20:!0,symbol:"GLM",decimals:18},"0x7240aC91f01233BaAf8b064248E80feaA5912BA3":{name:"OctoFi",logo:"octo.svg",erc20:!0,symbol:"OCTO",decimals:18},"0xff56Cc6b1E6dEd347aA0B7676C85AB0B3D08B0FA":{name:"Orbs",logo:"orbs.svg",erc20:!0,symbol:"ORBS",decimals:18},"0x63f88A2298a5c4AEE3c216Aa6D926B184a4b2437":{name:"GAME Credits",logo:"GAMECreditsLogo.svg",erc20:!0,symbol:"GAME",decimals:18},"0x5150956E082C748Ca837a5dFa0a7C10CA4697f9c":{name:"Zeedex",logo:"zdex.svg",erc20:!0,symbol:"ZDEX",decimals:18},"0x84cA8bc7997272c7CfB4D0Cd3D55cd942B3c9419":{name:"DIAdata",logo:"dia.svg",erc20:!0,symbol:"DIA",decimals:18},"0xb78B3320493a4EFaa1028130C5Ba26f0B6085Ef8":{name:"Dracula",logo:"dracula.svg",erc20:!0,symbol:"DRC",decimals:18},"0xF433089366899D83a9f26A773D59ec7eCF30355e":{name:"Metal",logo:"mtl.svg",erc20:!0,symbol:"MTL",decimals:8},"0x85Eee30c52B0b379b046Fb0F85F4f3Dc3009aFEC":{name:"KEEP",logo:"keep.svg",erc20:!0,symbol:"KEEP",decimals:18},"0x8dAEBADE922dF735c38C80C7eBD708Af50815fAa":{name:"tBTC",logo:"tbtc.svg",erc20:!0,symbol:"TBTC",decimals:18},"0xD7EFB00d12C2c13131FD319336Fdf952525dA2af":{name:"Proton",logo:"proton.svg",erc20:!0,symbol:"XPR",decimals:4},"0x178c820f862B14f316509ec36b13123DA19A6054":{name:"Energy Web Token Bridged",logo:"ewtb.svg",erc20:!0,symbol:"EWTB",decimals:18},"0x2b591e99afE9f32eAA6214f7B7629768c40Eeb39":{name:"HEX",logo:"hex.svg",erc20:!0,symbol:"HEX",decimals:8},"0xFca59Cd816aB1eaD66534D82bc21E7515cE441CF":{name:"Rarible",logo:"rari.svg",erc20:!0,symbol:"RARI",decimals:18},"0x7865af71cf0b288b4E7F654f4F7851EB46a2B7F8":{name:"Sentivate",logo:"sentivate.svg",erc20:!0,symbol:"SNTVT",decimals:18},"0xa3d58c4E56fedCae3a7c43A725aeE9A71F0ece4e":{name:"Metronome",logo:"metronome.svg",erc20:!0,symbol:"MET",decimals:18},"0x49d716DFe60b37379010A75329ae09428f17118d":{name:"PoolTogether Dai",logo:"pldai.svg",erc20:!0,symbol:"PLDAI",decimals:18},"0xfE6892654CBB05eB73d28DCc1Ff938f59666Fe9f":{name:"PoolTogether Sai",logo:"plsai.svg",erc20:!0,symbol:"PLSAI",decimals:18},"0x5732046A883704404F284Ce41FfADd5b007FD668":{name:"Bluzelle Token",logo:"Bluzelle.svg",erc20:!0,symbol:"BLZ",decimals:18},"0xBD87447F48ad729C5c4b8bcb503e1395F62e8B98":{name:"PoolTogether USDC",logo:"plusdc.svg",erc20:!0,symbol:"PLUSDC",decimals:6},"0x69A95185ee2a045CDC4bCd1b1Df10710395e4e23":{name:"$Poolz Finance",logo:"Poolz.svg",erc20:!0,symbol:"POOLZ",decimals:18},"0x0adA190c81b814548ddC2F6AdC4a689ce7C1FE73":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAXIS",decimals:18},"0xb1dC9124c395c1e97773ab855d66E879f053A289":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAX",decimals:18},"0xeF31Cb88048416E301Fee1eA13e7664b887BA7e8":{name:"Staked yAxis",logo:"yaxis.svg",erc20:!0,symbol:"sYAX",decimals:18},"0x28cb7e841ee97947a86B06fA4090C8451f64c0be":{name:"YF Link",logo:"YFL.svg",erc20:!0,symbol:"YFL",decimals:18},"0x75D1aA733920b14fC74c9F6e6faB7ac1EcE8482E":{name:"YFLink Staking Share",logo:"YFL.svg",erc20:!0,symbol:"yYFL",decimals:18},"0x7b760D06E401f85545F3B50c44bf5B05308b7b62":{name:"YFLink USD",logo:"YFLUSD.svg",erc20:!0,symbol:"YFLUSD",decimals:18},"0x8282df223AC402d04B2097d16f758Af4F70e7Db0":{name:"YFLink Synthetic",logo:"sYFL.svg",erc20:!0,symbol:"sYFL",decimals:18},"0x008377EB0C62cE8e0BA3D7Bb4A5638591f21588E":{name:"YFLink Bond",logo:"bYFL.svg",erc20:!0,symbol:"bYFL",decimals:18},"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e":{name:"yearn.finance",logo:"yfi.svg",erc20:!0,symbol:"YFI",decimals:18},"0x261b45D85cCFeAbb11F022eBa346ee8D1cd488c0":{name:"rDAI",logo:"rdai.svg",erc20:!0,symbol:"rDAI",decimals:18},"0xea8b224eDD3e342DEb514C4176c2E72Bcce6fFF9":{name:"rSAI",logo:"rsai.svg",erc20:!0,symbol:"rSAI",decimals:18},"0x12B19D3e2ccc14Da04FAe33e63652ce469b3F2FD":{name:"GridPlus",logo:"GridPlus.svg",erc20:!0,symbol:"GRID",decimals:12},"0xDb05EA0877A2622883941b939f0bb11d1ac7c400":{name:"Opacity",logo:"opct.svg",erc20:!0,symbol:"OPCT",decimals:18},"0x4575f41308EC1483f3d399aa9a2826d74Da13Deb":{name:"Orchid",logo:"OXT.svg",erc20:!0,symbol:"OXT",decimals:18},"0x4CC19356f2D37338b9802aa8E8fc58B0373296E7":{name:"Selfkey",logo:"KEY.svg",erc20:!0,symbol:"KEY",decimals:18},"0x92A5B04D0ED5D94D7a193d1d334D3D16996f4E13":{name:"Eristica",logo:"Eristica.svg",erc20:!0,symbol:"ERT",decimals:18},"0xdAC17F958D2ee523a2206206994597C13D831ec7":{name:"Tether USD",logo:"usdt.svg",erc20:!0,symbol:"USDT",decimals:6},"0x06AF07097C9Eeb7fD685c692751D5C66dB49c215":{name:"Chai",logo:"CHAI.svg",erc20:!0,symbol:"CHAI",decimals:18},"0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828":{name:"UMA",logo:"uma.svg",erc20:!0,symbol:"UMA",decimals:18},"0x5f778ec4B31a506c1Dfd8b06F131E9B451a61D39":{name:"UPX Token",logo:"UPX.svg",erc20:!0,symbol:"UPX",decimals:18},"0xb1CD6e4153B2a390Cf00A6556b0fC1458C4A5533":{name:"ETHBNT Liquidity Pool",logo:"ETHBNT.svg",erc20:!0,symbol:"ETHBNT",decimals:18},"0xf0Ee6b27b759C9893Ce4f094b49ad28fd15A23e4":{name:"Enigma",logo:"enigma.svg",erc20:!0,symbol:"ENG",decimals:8},"0xaaAEBE6Fe48E54f431b0C390CfaF0b017d09D42d":{name:"Celsius",logo:"celsius.svg",erc20:!0,symbol:"CEL",decimals:4},"0xb683D83a532e2Cb7DFa5275eED3698436371cc9f":{name:"BTU",logo:"BTU.svg",erc20:!0,symbol:"BTU",decimals:18},"0x746DdA2ea243400D5a63e0700F190aB79f06489e":{name:"BOSAGORA",logo:"BOA.svg",erc20:!0,symbol:"BOA",decimals:7},"0x5D858bcd53E085920620549214a8b27CE2f04670":{name:"POP Network Token",logo:"POP.svg",erc20:!0,symbol:"POP",decimals:18},"0x048Fe49BE32adfC9ED68C37D32B5ec9Df17b3603":{name:"Skrumble Network V2",logo:"skm.svg",erc20:!0,symbol:"SKM",decimals:18},"0x16EA01aCB4b0Bca2000ee5473348B6937ee6f72F":{name:"Enecuum",logo:"ENQ-logo.svg",erc20:!0,symbol:"ENQ",decimals:10},"0xE5B826Ca2Ca02F09c1725e9bd98d9a8874C30532":{name:"ZEON Network",logo:"ZEON_logo.png",erc20:!0,symbol:"ZEON",decimals:18},"0x13cb85823f78Cff38f0B0E90D3e975b8CB3AAd64":{name:"REMIIT REMI Token",logo:"remi.svg",erc20:!0,symbol:"REMI",decimals:18},"0x93a7174dafd31d13400cD9fa01f4e5B5BAa00D39":{name:"Shaka",logo:"hak.svg",erc20:!0,symbol:"HAK",decimals:18},"0x6fB3e0A217407EFFf7Ca062D46c26E5d60a14d69":{name:"IoTeX",logo:"iotex.svg",erc20:!0,symbol:"IOTX",decimals:18},"0xE5a3229CCb22b6484594973A03a3851dCd948756":{name:"RAE Token",logo:"rae.svg",erc20:!0,symbol:"RAE",decimals:18},"0x4470BB87d77b963A013DB939BE332f927f2b992e":{name:"AdEx Legacy Token",logo:"adex.svg",erc20:!0,symbol:"ADXL",decimals:4},"0xADE00C28244d5CE17D72E40330B1c318cD12B7c3":{name:"AdEx Token",logo:"adex.svg",erc20:!0,symbol:"ADX",decimals:18},"0xDc5864eDe28BD4405aa04d93E05A0531797D9D59":{name:"Falcon",logo:"fnt.svg",erc20:!0,symbol:"FNT",decimals:6},"0x1966d718A565566e8E202792658D7b5Ff4ECe469":{name:"nDEX",logo:"nDEX.png",erc20:!0,symbol:"NDX",decimals:18},"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599":{name:"Wrapped BTC",logo:"wbtc.svg",erc20:!0,symbol:"WBTC",decimals:8},"0x150b0b96933B75Ce27af8b92441F8fB683bF9739":{name:"Dragonereum Gold",logo:"gold.svg",erc20:!0,symbol:"GOLD",decimals:18},"0x82f4dED9Cec9B5750FBFf5C2185AEe35AfC16587":{name:"DreamTeam Token",logo:"dream.svg",erc20:!0,symbol:"DREAM",decimals:6},"0x5d60d8d7eF6d37E16EBABc324de3bE57f135e0BC":{name:"MyBit",logo:"MYB.svg",erc20:!0,symbol:"MYB",decimals:18},"0x01FA555c97D7958Fa6f771f3BbD5CCD508f81e22":{name:"Civil Token",logo:"CVL_token.svg",erc20:!0,symbol:"CVL",decimals:18},"0x5adc961D6AC3f7062D2eA45FEFB8D8167d44b190":{name:"Dether",logo:"dether.svg",erc20:!0,symbol:"DTH",decimals:18},"0x3F17Dd476faF0a4855572F0B6ed5115D9bBA22AD":{name:"Wibson",logo:"wibson-logo.png",erc20:!0,symbol:"WIB",decimals:9},"0xDF347911910b6c9A4286bA8E2EE5ea4a39eB2134":{name:"Bob's Repair",logo:"bobsrepair.png",erc20:!0,symbol:"BOB",decimals:18},"0x3505F494c3f0fed0B594E01Fa41Dd3967645ca39":{name:"SWARM",logo:"swarm.svg",erc20:!0,symbol:"SWM",decimals:18},"0x6863bE0e7CF7ce860A574760e9020D519a8bDC47":{name:"On.Live",logo:"onlive.svg",erc20:!0,symbol:"ONL",decimals:18},"0xea5f88E54d982Cbb0c441cde4E79bC305e5b43Bc":{name:"Pareto",logo:"ParetoLogo.png",erc20:!0,symbol:"PARETO",decimals:18},"0x2e91E3e54C5788e9FdD6A181497FDcEa1De1bcc1":{name:"Hercules",logo:"herc.png",erc20:!0,symbol:"HERC",decimals:18},"0x4946Fcea7C692606e8908002e55A582af44AC121":{name:"FOAM",logo:"FOAM.svg",erc20:!0,symbol:"FOAM",decimals:18},"0x4D807509aECe24C0fa5A102b6a3B059Ec6E14392":{name:"Menlo One",logo:"Menlo_One.png",erc20:!0,symbol:"ONE",decimals:18},"0x27054b13b1B798B345b591a4d22e6562d47eA75a":{name:"AirSwap Token",logo:"AirSwapLogo.svg",erc20:!0,symbol:"AST",decimals:4},"0x8D5682941cE456900b12d47ac06a88b47C764CE1":{name:"RightMesh Token",logo:"Rmesh.png",erc20:!0,symbol:"RMESH",decimals:18},"0xDDe12a12A6f67156e0DA672be05c374e1B0a3e57":{name:"JOYSO",logo:"JOY.png",erc20:!0,symbol:"JOY",decimals:6},"0x0D262e5dC4A06a0F1c90cE79C7a60C09DfC884E4":{name:"JET8 Token",logo:"J8T.svg",erc20:!0,symbol:"J8T",decimals:8},"0x4a220E6096B25EADb88358cb44068A3248254675":{name:"Quant Network",logo:"quant-network.svg",erc20:!0,symbol:"QNT",decimals:18},"0xBC86727E770de68B1060C91f6BB6945c73e10388":{name:"Ink Protocol",logo:"ink_protocol.svg",erc20:!0,symbol:"XNK",decimals:18},"0xa95592DCFfA3C080B4B40E459c5f5692F67DB7F8":{name:"ELY Token",logo:"ely.png",erc20:!0,symbol:"ELY",decimals:18},"0x9E46A38F5DaaBe8683E10793b06749EEF7D733d1":{name:"PolySwarm Nectar",logo:"polyswarm_nectar.svg",erc20:!0,symbol:"NCT",decimals:18},"0xe1A178B681BD05964d3e3Ed33AE731577d9d96dD":{name:"BOX Token",logo:"box_token.png",erc20:!0,symbol:"BOX",decimals:18},"0x543Ff227F64Aa17eA132Bf9886cAb5DB55DCAddf":{name:"DAOstack",logo:"gen.svg",erc20:!0,symbol:"GEN",decimals:18},"0x6aEDbF8dFF31437220dF351950Ba2a3362168d1b":{name:"Dragonglass",logo:"dragonglass.svg",erc20:!0,symbol:"DGS",decimals:8},"0xd26114cd6EE289AccF82350c8d8487fedB8A0C07":{name:"OmiseGO",logo:"omg.svg",erc20:!0,symbol:"OMG",decimals:18},"0x99ea4dB9EE77ACD40B119BD1dC4E33e1C070b80d":{name:"Quantstamp",logo:"qsp.svg",erc20:!0,symbol:"QSP",decimals:18},"0xB64ef51C888972c908CFacf59B47C1AfBC0Ab8aC":{name:"Storj",logo:"storj.svg",erc20:!0,symbol:"STORJ",decimals:8},"0xD8E3FB3b08eBA982F2754988d70D57eDc0055ae6":{name:"Zoracles",logo:"zora.svg",erc20:!0,symbol:"ZORA",decimals:9},"0xF938424F7210f31dF2Aee3011291b658f872e91e":{name:"VISOR",logo:"VISR.svg",erc20:!0,symbol:"VISR",decimals:18},"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942":{name:"Decentraland",logo:"mana.svg",erc20:!0,symbol:"MANA",decimals:18},"0x0F513fFb4926ff82D7F60A05069047AcA295C413":{name:"CrowdstartCoin",logo:"XSC_Logo.svg",erc20:!0,symbol:"XSC",decimals:18},"0x5BC7e5f0Ab8b2E10D2D0a3F21739FCe62459aeF3":{name:"Hut34 Entropy Token",logo:"ENTRP.png",symbol:"ENTRP",erc20:!0,decimals:18},"0x946112efaB61C3636CBD52DE2E1392D7A75A6f01":{name:"HYDRO TOKEN",logo:"hydro.svg",erc20:!0,symbol:"HYDRO",decimals:18},"0x2604FA406Be957E542BEb89E6754fCdE6815e83f":{name:"Playkey Token",logo:"playkey.svg",erc20:!0,symbol:"PKT",decimals:18},"0xE41d2489571d322189246DaFA5ebDe1F4699F498":{name:"0x",logo:"zrx.svg",erc20:!0,symbol:"ZRX",decimals:18},"0x957c30aB0426e0C93CD8241E2c60392d08c6aC8e":{name:"Modum Token",logo:"modum.svg",erc20:!0,symbol:"MOD",decimals:0},"0x1a7a8BD9106F2B8D977E08582DC7d24c723ab0DB":{name:"AppCoins",logo:"appc.svg",erc20:!0,decimals:18,symbol:"APPC"},"0xdB25f211AB05b1c97D595516F45794528a807ad8":{name:"STASIS EURS Token",logo:"stasis-eurs.svg",erc20:!0,decimals:2,symbol:"EURS"},"0xCA0e7269600d353F70b14Ad118A49575455C0f2f":{name:"AMLT",logo:"amlt.png",erc20:!0,decimals:18,symbol:"AMLT"},"0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F":{name:"Synthetix Network Token",logo:"synthetix.svg",erc20:!0,decimals:18,symbol:"SNX"},"0x57Ab1ec28D129707052df4dF418D58a2D46d5f51":{name:"Synth sUSD",logo:"synthetix_susd.svg",erc20:!0,decimals:18,symbol:"SUSD"},"0x5e74C9036fb86BD7eCdcb084a0673EFc32eA31cb":{name:"Synth sETH",logo:"synthetix_seth.svg",erc20:!0,decimals:18,symbol:"SETH"},"0xfE18be6b3Bd88A2D2A7f928d00292E7a9963CfC6":{name:"Synth sBTC",logo:"synthetix_sbtc.svg",erc20:!0,decimals:18,symbol:"SBTC"},"0x0DB8D8b76BC361bAcbB72E2C491E06085A97Ab31":{name:"IQeon",logo:"iqeon.svg",erc20:!0,decimals:18,symbol:"IQN"},"0x000C100050E98C91f9114fa5Dd75CE6869Bf4F53":{name:"CRYPTO10 Hedged",logo:"c10.svg",erc20:!0,symbol:"C10",decimals:18},"0x26E75307Fc0C021472fEb8F727839531F112f317":{name:"Crypto20",logo:"c20.svg",erc20:!0,symbol:"C20",decimals:18},"0x06012c8cf97BEaD5deAe237070F9587f8E7A266d":{name:"Crypto Kitties",logo:"ck.svg",erc20:!1,erc721:!0,symbol:"CK",decimals:0},"0xE477292f1B3268687A29376116B0ED27A9c76170":{name:"Herocoin",logo:"herocoin_logo.png",erc20:!0,symbol:"PLAY",decimals:18},"0x4F4f0Db4de903B88f2B1a2847971E231D54F8fd3":{name:"Geens Platform Token",logo:"gee-icon.svg",erc20:!0,symbol:"GEE",decimals:8},"0xec67005c4E498Ec7f55E092bd1d35cbC47C91892":{name:"Enzyme Finance",logo:"mln.svg",erc20:!0,symbol:"MLN",decimals:18},"0xba2184520A1cC49a6159c57e61E1844E085615B6":{name:"HelloGold Token",logo:"hgt.png",erc20:!0,symbol:"HGT",decimals:8},"0xba358B6f5b4c0215650444B8C30D870B55050D2D":{name:"Hub Token",logo:"hub.svg",erc20:!0,symbol:"HUB",decimals:18},"0x8727c112C712c4a03371AC87a74dD6aB104Af768":{name:"Jetcoin Institute Token",logo:"JETCOIN28.png",erc20:!0,symbol:"JET",decimals:18},"0xf8e386EDa857484f5a12e4B5DAa9984E06E73705":{name:"Indorse Token",logo:"indorseLogo.jpg",erc20:!0,symbol:"IND",decimals:18},"0xA54ddC7B3CcE7FC8b1E3Fa0256D0DB80D2c10970":{name:"NEVERDIE Coin",logo:"ndc.png",erc20:!0,symbol:"NDC",decimals:18},"0x1c4481750daa5Ff521A2a7490d9981eD46465Dbd":{name:"BlockMason Credit Protocol Token",logo:"bcpt.svg",erc20:!0,symbol:"BCPT",decimals:18},"0x20F7A3DdF244dc9299975b4Da1C39F8D5D75f05A":{name:"Sapien Network Token",logo:"spn.svg",erc20:!0,symbol:"SPN",decimals:6},"0xA4e8C3Ec456107eA67d3075bF9e3DF3A75823DB0":{name:"Loom Token",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x42476F744292107e34519F9c357927074Ea3F75D":{name:"Loom",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x4F9254C83EB525f9FCf346490bbb3ed28a81C667":{name:"Celer Network Token",logo:"CELR.svg",erc20:!0,symbol:"CELR",decimals:18},"0x71D01dB8d6a2fBEa7f8d434599C237980C234e4C":{name:"Gladius",logo:"gladius.svg",erc20:!0,symbol:"GLA",decimals:8},"0xdd974D5C2e2928deA5F71b9825b8b646686BD200":{name:"Kyber Network Crystal",logo:"kyber.svg",erc20:!0,symbol:"KNC",decimals:18},"0x1F573D6Fb3F13d689FF844B4cE37794d79a7FF1C":{name:"Bancor Network Token",logo:"bnt.svg",erc20:!0,symbol:"BNT",decimals:18},"0xfa05A73FfE78ef8f1a739473e462c54bae6567D9":{name:"Lunyr Token",logo:"lun.svg",erc20:!0,symbol:"LUN",decimals:18},"0xC741f06082AA47F93729070aD0dD95E223Bda091":{name:"LEDU Token",logo:"edu.svg",erc20:!0,symbol:"LEDU",decimals:8},"0x5c543e7AE0A1104f78406C340E9C64FD9fCE5170":{name:"vSlice",logo:"vslice.png",erc20:!0,symbol:"VSL",decimals:18},"0x1f41E42D0a9e3c0Dd3BA15B527342783B43200A9":{name:"Blockchain Capital",logo:"bcap.svg",erc20:!0,symbol:"BCAP",decimals:0},"0x6531f133e6DeeBe7F2dcE5A0441aA7ef330B4e53":{name:"Chronobank TIME",logo:"chronobank.png",erc20:!0,symbol:"TIME",decimals:8},"0xaAAf91D9b90dF800Df4F55c205fd6989c977E73a":{name:"Monolith TKN",logo:"tkn.svg",erc20:!0,symbol:"TKN",decimals:8},"0x08711D3B02C8758F2FB3ab4e80228418a7F8e39c":{name:"Edgeless",logo:"edg.svg",erc20:!0,symbol:"EDG",decimals:0},"0xf7B098298f7C69Fc14610bf71d5e02c60792894C":{name:"Guppy",logo:"guppy.png",erc20:!0,symbol:"GUP",decimals:3},"0x4DF812F6064def1e5e029f1ca858777CC98D2D81":{name:"Xaurum",logo:"xaurum_logo.svg",erc20:!0,symbol:"XAUR",decimals:8},"0xB9e7F8568e08d5659f5D29C4997173d84CdF2607":{name:"Swarm City Token",logo:"swt.svg",erc20:!0,symbol:"SWT",decimals:18},"0xCb94be6f13A1182E4A4B6140cb7bf2025d28e41B":{name:"Trustcoin",logo:"trst.svg",erc20:!0,symbol:"TRST",decimals:6},"0xCB56b52316041A62B6b5D0583DcE4A8AE7a3C629":{name:"Cigarettes",logo:"cig.svg",erc20:!0,symbol:"CIG",decimals:18},"0x960b236A07cf122663c4303350609A66A7B288C0":{name:"Aragon Network Token v1",logo:"antv1.svg",erc20:!0,symbol:"ANTv1",decimals:18},"0x667088b212ce3d06a1b553a7221E1fD19000d9aF":{name:"WINGS",logo:"wings_logo.svg",erc20:!0,symbol:"WINGS",decimals:18},"0x16484d73Ac08d2355F466d448D2b79D2039F6EBB":{name:"FortKnoxster",logo:"FortKnoxster.svg",erc20:!0,symbol:"FKX",decimals:18},"0xAf30D2a7E90d7DC361c8C4585e9BB7D2F6f15bc7":{name:"FirstBlood Token",logo:"1st.svg",erc20:!0,symbol:"1ST",decimals:18},"0x607F4C5BB672230e8672085532f7e901544a7375":{name:"iExec RLC Token",logo:"rlc.svg",erc20:!0,symbol:"RLC",decimals:9},"0xaeC2E87E0A235266D9C5ADc9DEb4b2E29b54D009":{name:"SingularDTV",logo:"singulardtv.svg",erc20:!0,symbol:"SNGLS",decimals:0},"0x888666CA69E0f178DED6D75b5726Cee99A87D698":{name:"ICONOMI",logo:"iconomi.png",erc20:!0,symbol:"ICN",decimals:18},"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2":{name:"Maker",logo:"mkr.svg",erc20:!0,symbol:"MKR",decimals:18},"0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359":{name:"Sai Stablecoin v1.0",logo:"sai.svg",erc20:!0,symbol:"SAI",decimals:18},"0x6B175474E89094C44Da98b954EedeAC495271d0F":{name:"Dai Stablecoin",logo:"dai.svg",erc20:!0,symbol:"DAI",decimals:18},"0xC477D038d5420C6A9e0b031712f61c5120090de9":{name:"Boson Token",logo:"boson.svg",erc20:!0,symbol:"BOSON",decimals:18},"0xD46bA6D942050d489DBd938a2C909A5d5039A161":{name:"Ampleforth",logo:"ampl.svg",erc20:!0,symbol:"AMPL",decimals:9},"0x4b9278b94a1112cAD404048903b8d343a810B07e":{name:"Hifi Finance",logo:"hifi.svg",erc20:!0,symbol:"HIFI",decimals:18},"0x0D8775F648430679A709E98d2b0Cb6250d2887EF":{name:"Basic Attention Token",logo:"bat.svg",erc20:!0,symbol:"BAT",decimals:18},"0x4D8fc1453a0F359e99c9675954e656D80d996FbF":{name:"BEE Token",logo:"bee_token.svg",erc20:!0,symbol:"BEE",decimals:18},"0x6810e776880C02933D47DB1b9fc05908e5386b96":{name:"Gnosis Token",logo:"gnosis.svg",erc20:!0,symbol:"GNO",decimals:18},"0x514910771AF9Ca656af840dff83E8264EcF986CA":{name:"Chainlink Token",logo:"chainlink.svg",erc20:!0,symbol:"LINK",decimals:18},"0xD8912C10681D8B21Fd3742244f44658dBA12264E":{name:"Pluton",logo:"plutus-god.svg",erc20:!0,symbol:"PLU",decimals:18},"0x1985365e9f78359a9B6AD760e32412f4a445E862":{name:"Reputation Old",logo:"rep.svg",erc20:!0,symbol:"REP",decimals:18},"0x221657776846890989a759BA2973e427DfF5C9bB":{name:"Reputation",logo:"repv2.svg",erc20:!0,symbol:"REPv2",decimals:18},"0xd0929d411954c47438dc1d871dd6081F5C5e149c":{name:"Refereum",logo:"rfr.svg",erc20:!0,symbol:"RFR",decimals:4},"0xb0866289e870D2efc282406cF4123Df6E5BcB652":{name:"NoFakeCoin",logo:"nfticon.png",erc20:!0,symbol:"NFC",decimals:18},"0x2C4e8f2D746113d0696cE89B35F0d8bF88E0AEcA":{name:"Open Simple Token",logo:"OST.svg",erc20:!0,symbol:"OST",decimals:18},"0x408e41876cCCDC0F92210600ef50372656052a38":{name:"Republic Token",logo:"ren.svg",erc20:!0,symbol:"REN",decimals:18},"0xEB4C2781e4ebA804CE9a9803C67d0893436bB27D":{name:"renBTC",logo:"renBTC.svg",erc20:!0,symbol:"renBTC",decimals:8},"0x1C5db575E2Ff833E46a2E9864C22F4B22E0B37C2":{name:"renZEC",logo:"renZEC.svg",erc20:!0,symbol:"renZEC",decimals:8},"0x459086F2376525BdCebA5bDDA135e4E9d3FeF5bf":{name:"renBCH",logo:"renBCH.svg",erc20:!0,symbol:"renBCH",decimals:8},"0xD5147bc8e386d91Cc5DBE72099DAC6C9b99276F5":{name:"renFIL",logo:"renFIL.svg",erc20:!0,symbol:"renFIL",decimals:18},"0xa74476443119A942dE498590Fe1f2454d7D4aC0d":{name:"Golem Network Token",logo:"golem.svg",erc20:!0,symbol:"GNT",decimals:18},"0x6888a16eA9792c15A4DCF2f6C623D055c8eDe792":{name:"Spectiv Signal Token",logo:"spectiv.svg",erc20:!0,symbol:"SIG",decimals:18},"0x9a642d6b3368ddc662CA244bAdf32cDA716005BC":{name:"Qtum",logo:"qtum.svg",erc20:!0,decimals:18,symbol:"QTUM"},"0x1234567461d3f8Db7496581774Bd869C83D51c93":{name:"BitClave",logo:"bitclave.svg",erc20:!0,decimals:18,symbol:"CAT"},"0x7d4b8Cce0591C9044a22ee543533b72E976E36C3":{name:"Change",logo:"change.svg",erc20:!0,decimals:18,symbol:"CAG"},"0x1d462414fe14cf489c7A21CaC78509f4bF8CD7c0":{name:"CanYaCoin",logo:"CanYa.svg",erc20:!0,decimals:6,symbol:"CAN"},"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72":{name:"Ethereum Name Service",logo:"ens.svg",erc20:!0,decimals:18,symbol:"ENS"},"0x3d1BA9be9f66B8ee101911bC36D3fB562eaC2244":{name:"Rivetz",logo:"rivetz.png",erc20:!0,decimals:18,symbol:"RVT"},"0x056017c55aE7AE32d12AeF7C679dF83A85ca75Ff":{name:"Project Wyvern Token",logo:"wyvern-logo.svg",erc20:!0,symbol:"WYV",decimals:18},"0xfec0cF7fE078a500abf15F1284958F22049c2C7e":{name:"Maecenas ART Token",logo:"art.svg",erc20:!0,symbol:"ART",decimals:18},"0x05f4a42e251f2d52b8ed15E9FEdAacFcEF1FAD27":{name:"Zilliqa",logo:"zilliqa.svg",erc20:!0,symbol:"ZIL",decimals:12},"0x986EE2B944c42D017F52Af21c4c69B84DBeA35d8":{name:"BitMartToken",logo:"bitmart.png",erc20:!0,symbol:"BMX",decimals:18},"0xF03f8D65BaFA598611C3495124093c56e8F638f0":{name:"Viewly",logo:"viewly.svg",erc20:!0,symbol:"VIEW",decimals:18},"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2":{name:"Wrapped Ether",logo:"weth.svg",erc20:!0,symbol:"WETH",decimals:18},"0xba5BDe662c17e2aDFF1075610382B9B691296350":{name:"SuperRare Token",logo:"rare.svg",erc20:!0,symbol:"RARE",decimals:18},"0x6C8c6b02E7b2BE14d4fA6022Dfd6d75921D90E4E":{name:"Compound Basic Attention Token",logo:"ctoken-bat.svg",erc20:!0,symbol:"cBAT",decimals:8},"0x70e36f6BF80a52b3B46b3aF8e106CC0ed743E8e4":{name:"Compound Collateral",logo:"ctoken-comp.svg",erc20:!0,symbol:"cCOMP",decimals:8},"0x5d3a536E4D6DbD6114cc1Ead35777bAB948E3643":{name:"Compound Dai",logo:"ctoken-dai.svg",erc20:!0,symbol:"cDAI",decimals:8},"0xF5DCe57282A584D2746FaF1593d3121Fcac444dC":{name:"Compound Sai (Legacy Dai)",logo:"ctoken-sai.svg",erc20:!0,symbol:"cSAI",decimals:8},"0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5":{name:"Compound Ether",logo:"ctoken-eth.svg",erc20:!0,symbol:"cETH",decimals:8},"0x158079Ee67Fce2f58472A96584A73C7Ab9AC95c1":{name:"Compound Augur",logo:"ctoken-rep.svg",erc20:!0,symbol:"cREP",decimals:8},"0x39AA39c021dfbaE8faC545936693aC917d5E7563":{name:"Compound USD Coin",logo:"ctoken-usdc.svg",erc20:!0,symbol:"cUSDC",decimals:8},"0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9":{name:"Compound Tether",logo:"ctoken-usdt.svg",erc20:!0,symbol:"cUSDT",decimals:8},"0xC11b1268C1A384e55C48c2391d8d480264A3A7F4":{name:"Compound Wrapped BTC",logo:"ctoken-wbtc.svg",erc20:!0,symbol:"cWBTC",decimals:8},"0xB3319f5D18Bc0D84dD1b4825Dcde5d5f7266d407":{name:"Compound 0x",logo:"ctoken-zrx.svg",erc20:!0,symbol:"cZRX",decimals:8},"0xc00e94Cb662C3520282E6f5717214004A7f26888":{name:"Compound",logo:"comp.svg",erc20:!0,symbol:"COMP",decimals:18},"0xFFE02ee4C69eDf1b340fCaD64fbd6b37a7b9e265":{name:"NANJCOIN",logo:"nanjcoin.svg",erc20:!0,symbol:"NANJ",decimals:8},"0xB6eD7644C69416d67B522e20bC294A9a9B405B31":{name:"0xBitcoin Token",logo:"0xbitcoin.svg",erc20:!0,symbol:"0xBTC",decimals:8},"0x744d70FDBE2Ba4CF95131626614a1763DF805B9E":{name:"Status Network Token",logo:"snt.svg",erc20:!0,symbol:"SNT",decimals:18},"0x42d6622deCe394b54999Fbd73D108123806f6a18":{name:"SPANK",logo:"spank.svg",erc20:!0,symbol:"SPANK",decimals:18},"0x6B01c3170ae1EFEBEe1a3159172CB3F7A5ECf9E5":{name:"BOOTY",logo:"booty.png",erc20:!0,symbol:"BOOTY",decimals:18},"0x4a6058666cf1057eaC3CD3A5a614620547559fc9":{name:"Brickblock",logo:"Brickblock.svg",erc20:!0,symbol:"BBK",decimals:18},"0x80fB784B7eD66730e8b1DBd9820aFD29931aab03":{name:"ETHLend Token",logo:"lend.svg",erc20:!0,symbol:"LEND",decimals:18},"0x48FF53777F747cFB694101222a944dE070c15D36":{name:"Ether Kingdoms Token",logo:"IMP.svg",erc20:!0,symbol:"IMP",decimals:7},"0x02F61Fd266DA6E8B102D4121f5CE7b992640CF98":{name:"LikeCoin",logo:"like.svg",erc20:!0,symbol:"LIKE",decimals:18},"0xB8c77482e45F1F44dE1745F52C74426C631bDD52":{name:"Binance Coin",logo:"bnb.png",erc20:!0,symbol:"BNB",decimals:18},"0xD850942eF8811f2A866692A623011bDE52a462C1":{name:"VeChain",logo:"ven.svg",erc20:!0,symbol:"VEN",decimals:18},"0x91Af0fBB28ABA7E31403Cb457106Ce79397FD4E6":{name:"Aergo",logo:"Aergo.svg",erc20:!0,symbol:"AERGO",decimals:18},"0x5CA9a71B1d01849C0a95490Cc00559717fCF0D1d":{name:"Aeternity",logo:"aeternity.svg",erc20:!0,symbol:"AE",decimals:18},"0xd4fa1460F537bb9085d22C7bcCB5DD450Ef28e3a":{name:"Populous",logo:"ppt.svg",erc20:!0,symbol:"PPT",decimals:8},"0xFA1a856Cfa3409CFa145Fa4e20Eb270dF3EB21ab":{name:"IOST",logo:"iost.png",erc20:!0,symbol:"IOST",decimals:18},"0x039B5649A59967e3e936D7471f9c3700100Ee1ab":{name:"Kucoin Shares",logo:"kucoin.svg",erc20:!0,symbol:"KCS",decimals:6},"0x3893b9422Cd5D70a81eDeFfe3d5A1c6A978310BB":{name:"Mithril",logo:"mith.svg",erc20:!0,symbol:"MITH",decimals:18},"0xb7cB1C96dB6B22b0D3d9536E0108d062BD488F74":{name:"Walton Token",logo:"wtc.svg",erc20:!0,symbol:"WTC",decimals:18},"0x1776e1F26f98b1A5dF9cD347953a26dd3Cb46671":{name:"Numeraire",logo:"nmr.png",erc20:!0,symbol:"NMR",decimals:18},"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd":{name:"Gemini Dollar",logo:"gusd.svg",erc20:!0,symbol:"GUSD",decimals:2},"0xA4Bdb11dc0a2bEC88d24A3aa1E6Bb17201112eBe":{name:"StableUSD",logo:"usds.svg",erc20:!0,symbol:"USDS",decimals:6},"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48":{name:"USDC",logo:"usdc.svg",erc20:!0,symbol:"USDC",decimals:6},"0x1aBaEA1f7C830bD89Acc67eC4af516284b1bC33c":{name:"EURC",logo:"eurc.svg",erc20:!0,symbol:"EURC",decimals:6},"0x93ED3FBe21207Ec2E8f2d3c3de6e058Cb73Bc04d":{name:"Pinakion Token",logo:"pinakion.svg",erc20:!0,symbol:"PNK",decimals:18},"0x419D0d8BdD9aF5e606Ae2232ed285Aff190E711b":{name:"FunFair",logo:"fun.svg",erc20:!0,symbol:"FUN",decimals:8},"0xcA2796F9F61dc7b238Aab043971e49c6164DF375":{name:"YGGDRASH YEED Token",logo:"yggdrash.svg",erc20:!0,symbol:"YEED",decimals:18},"0x03e3f0c25965f13DbbC58246738C183E27b26a56":{name:"Disciplina Token",logo:"disciplina.svg",erc20:!0,symbol:"DSCP",decimals:18},"0xE814aeE960a85208C3dB542C53E7D4a6C8D5f60F":{name:"Chronologic DAY Token",logo:"DAY.png",erc20:!0,symbol:"DAY",decimals:18},"0x7E43581b19ab509BCF9397a2eFd1ab10233f27dE":{name:"PLATINUM",logo:"plat.png",erc20:!0,symbol:"PLAT",decimals:18},"0x8E870D67F660D95d5be530380D0eC0bd388289E1":{name:"Pax Dollar",logo:"usdp.svg",erc20:!0,symbol:"USDP",decimals:18},"0x45804880De22913dAFE09f4980848ECE6EcbAf78":{name:"PAX Gold",logo:"paxg.svg",erc20:!0,symbol:"PAXG",decimals:18},"0x0000000000085d4780B73119b644AE5ecd22b376":{name:"TrueUSD",logo:"TUSD.svg",erc20:!0,symbol:"TUSD",decimals:18},"0x00000000441378008EA67F4284A57932B1c000a5":{name:"TrueGBP",logo:"TGBP.svg",erc20:!0,symbol:"TGBP",decimals:18},"0x00006100F7090010005F1bd7aE6122c3C2CF0090":{name:"TrueAUD",logo:"TAUD.svg",erc20:!0,symbol:"TAUD",decimals:18},"0x00000100F2A2bd000715001920eB70D229700085":{name:"TrueCAD",logo:"TCAD.svg",erc20:!0,symbol:"TCAD",decimals:18},"0x0000852600CEB001E08e00bC008be620d60031F2":{name:"TrueHKD",logo:"THKD.svg",erc20:!0,symbol:"THKD",decimals:18},"0x4Fabb145d64652a948d72533023f6E7A623C7C53":{name:"Binance USD",logo:"busd.svg",erc20:!0,symbol:"BUSD",decimals:18},"0x23Ccc43365D9dD3882eab88F43d515208f832430":{name:"MidasProtocol",logo:"MAS.png",erc20:!0,symbol:"MAS",decimals:18},"0xC16b542ff490e01fcc0DC58a60e1EFdc3e357cA6":{name:"ICE ROCK MINING",logo:"rock2.png",erc20:!0,symbol:"ROCK2",decimals:0},"0x6758B7d441a9739b98552B373703d8d3d14f9e62":{name:"POA20 Token",logo:"POA20.png",erc20:!0,symbol:"POA20",decimals:18},"0x3DB6Ba6ab6F95efed1a6E794caD492fAAabF294D":{name:"LTO Network Token (old)",logo:"LTO.svg",erc20:!0,symbol:"LTOOLD",decimals:8},"0xd01409314aCb3b245CEa9500eCE3F6Fd4d70ea30":{name:"LTO Network Token",logo:"LTO.svg",erc20:!0,symbol:"LTO",decimals:8},"0xfeF4185594457050cC9c23980d301908FE057Bb1":{name:"VIDT Datalink",logo:"VIDT.svg",erc20:!0,symbol:"VIDT-OLD",decimals:18},"0x3BE7bF1A5F23BD8336787D0289B70602f1940875":{name:"VIDT DAO",logo:"VIDT.svg",erc20:!0,symbol:"VIDT",decimals:18},"0x7064aAb39A0Fcf7221c3396719D0917a65E35515":{name:"Cpollo",logo:"Cpollo.svg",erc20:!0,symbol:"CPLO",decimals:18},"0xd8446236FA95b9b5f9fd0f8E7Df1a944823c683d":{name:"NEEO",logo:"neeo.png",erc20:!0,symbol:"NEEO",decimals:18},"0xA823E6722006afe99E91c30FF5295052fe6b8E32":{name:"Neumark",logo:"neu.svg",erc20:!0,symbol:"NEU",decimals:18},"0x8f693ca8D21b157107184d29D398A8D082b38b76":{name:"Streamr",logo:"streamr.svg",erc20:!0,symbol:"DATA",decimals:18},"0x0Cf0Ee63788A0849fE5297F3407f701E122cC023":{name:"Streamr (old)",logo:"streamr_old.svg",erc20:!0,symbol:"XDATA",decimals:18},"0xA0b73E1Ff0B80914AB6fe0444E65848C4C34450b":{name:"Cronos",logo:"cro.svg",erc20:!0,symbol:"CRO",decimals:8},"0xF70a642bD387F94380fFb90451C2c81d4Eb82CBc":{name:"STAR",logo:"starbase.png",erc20:!0,symbol:"STAR",decimals:18},"0x7C5A0CE9267ED19B22F8cae653F198e3E8daf098":{name:"Santiment",logo:"santiment.svg",erc20:!0,symbol:"SAN",decimals:18},"0x58b6A8A3302369DAEc383334672404Ee733aB239":{name:"Livepeer",logo:"lpt.svg",erc20:!0,symbol:"LPT",decimals:18},"0x6fe56C0bcdD471359019FcBC48863d6c3e9d4F41":{name:"Props",logo:"props.png",erc20:!0,symbol:"PROPS",decimals:18},"0x6c6EE5e31d828De241282B9606C8e98Ea48526E2":{name:"HoloToken",logo:"hot.svg",erc20:!0,symbol:"HOT",decimals:18},"0xF629cBd94d3791C9250152BD8dfBDF380E2a3B9c":{name:"Enjin Coin",logo:"enj.svg",erc20:!0,symbol:"ENJ",decimals:18},"0xbf2179859fc6D5BEE9Bf9158632Dc51678a4100e":{name:"AELF",logo:"elf.svg",erc20:!0,symbol:"ELF",decimals:18},"0x39Bb259F66E1C59d5ABEF88375979b4D20D98022":{name:"WAX Token",logo:"wax.svg",erc20:!0,symbol:"WAX",decimals:8},"0x595832F8FC6BF59c85C527fEC3740A1b7a361269":{name:"PowerLedger",logo:"powr.svg",erc20:!0,symbol:"POWR",decimals:6},"0x28dee01D53FED0Edf5f6E310BF8Ef9311513Ae40":{name:"BlitzPredict",logo:"blitzpredict.svg",erc20:!0,symbol:"XBP",decimals:18},"0x33349B282065b0284d756F0577FB39c158F935e6":{name:"Maple Finance",logo:"maple-finance.svg",erc20:!0,erc721:!1,symbol:"MPL",decimals:18},"0xFBeef911Dc5821886e1dda71586d90eD28174B7d":{name:"KnownOrigin",logo:"knownorigin.svg",erc20:!0,symbol:"KODA",decimals:0},"0x8207c1FfC5B6804F6024322CcF34F29c3541Ae26":{name:"Origin Protocol",logo:"ogn.svg",erc20:!0,symbol:"OGN",decimals:18},"0x2A8e1E676Ec238d8A992307B495b45B3fEAa5e86":{name:"Origin Dollar",logo:"ousd.svg",erc20:!0,symbol:"OUSD",decimals:18},"0x856c4Efb76C1D1AE02e20CEB03A2A6a08b0b8dC3":{name:"Origin Ether",logo:"oeth.svg",erc20:!0,symbol:"OETH",decimals:18},"0x9c354503C38481a7A7a51629142963F98eCC12D0":{name:"Origin DeFi Governance",logo:"ogv.svg",erc20:!0,symbol:"OGV",decimals:18},"0x0C4576Ca1c365868E162554AF8e385dc3e7C66D9":{name:"Vote Escrowed Origin DeFi Governance",logo:"veogv.svg",erc20:!0,symbol:"veOGV",decimals:18},"0x8f8221aFbB33998d8584A2B05749bA73c37a938a":{name:"Request",logo:"request.svg",erc20:!0,symbol:"REQ",decimals:18},"0x2aEa4Add166EBf38b63d09a75dE1a7b94Aa24163":{name:"Kudos",logo:"kudos.svg",erc20:!1,erc721:!0,symbol:"KDO",decimals:0},"0x14C926F2290044B647e1Bf2072e67B495eff1905":{name:"Bethereum",logo:"bether.jpg",erc20:!0,symbol:"BETHER",decimals:18},"0x9AAb071B4129B083B01cB5A0Cb513Ce7ecA26fa5":{name:"Hunt Token",logo:"hunt.png",erc20:!0,symbol:"HUNT",decimals:18},"0xFEF3884b603C33EF8eD4183346E093A173C94da6":{name:"Metamorph",logo:"metamorph.svg",erc20:!0,symbol:"METM",decimals:18},"0x0AbdAce70D3790235af448C88547603b945604ea":{name:"district0x",logo:"district0x.svg",erc20:!0,symbol:"DNT",decimals:18},"0xB26631c6dda06aD89B93C71400D25692de89c068":{name:"Minds",logo:"minds.svg",erc20:!0,symbol:"MINDS",decimals:18},"0xBb1f24C0c1554b9990222f036b0AaD6Ee4CAec29":{name:"CryptoSoul",logo:"SOUL.svg",erc20:!0,symbol:"SOUL",decimals:18},"0xFF0E5e014cf97e0615cb50F6f39Da6388E2FaE6E":{name:"Origo",logo:"origo.svg",erc20:!0,symbol:"OGO",decimals:18},"0x0cB8D0B37C7487b11d57F1f33dEfA2B1d3cFccfE":{name:"DANKToken",logo:"dank-logo.svg",erc20:!0,symbol:"DANK",decimals:18},"0x3a4f40631a4f906c2BaD353Ed06De7A5D3fCb430":{name:"PlayDapp Token",logo:"playdapp.svg",erc20:!0,symbol:"PLA",decimals:18},"0xE9e3F9cfc1A64DFca53614a0182CFAD56c10624F":{name:"Su Squares",logo:"Su-Squares.svg",erc20:!1,erc721:!0,symbol:"SU",decimals:0},"0xfA5047c9c78B8877af97BDcb85Db743fD7313d4a":{name:"ROOK",logo:"Rook.svg",erc20:!0,symbol:"ROOK",decimals:18},"0xa62cc35625B0C8dc1fAEA39d33625Bb4C15bD71C":{name:"StormX",logo:"stormx.svg",erc20:!0,symbol:"STMX",decimals:18},"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0":{name:"Matic Network Token",logo:"matic.svg",erc20:!0,symbol:"MATIC",decimals:18},"0x9992eC3cF6A55b00978cdDF2b27BC6882d88D1eC":{name:"Polymath",logo:"poly.svg",erc20:!0,symbol:"POLY",decimals:18},"0x0a50C93c762fDD6E56D86215C24AaAD43aB629aa":{name:"LGO Token",logo:"lgo.png",erc20:!0,symbol:"LGO",decimals:8},"0xc8Cac7672f4669685817cF332a33Eb249F085475":{name:"LivenCoin",logo:"LVN.svg",erc20:!0,symbol:"LVN",decimals:18},"0xBBbbCA6A901c926F240b89EacB641d8Aec7AEafD":{name:"Loopring",logo:"LRC.svg",erc20:!0,symbol:"LRC",decimals:18},"0x255Aa6DF07540Cb5d3d297f0D0D4D84cb52bc8e6":{name:"Raiden Network Token",logo:"raiden.svg",erc20:!0,symbol:"RDN",decimals:18},"0x66fD97a78d8854fEc445cd1C80a07896B0b4851f":{name:"Lunch Money",logo:"LMY.svg",erc20:!0,symbol:"LMY",decimals:18},"0x679131F591B4f369acB8cd8c51E68596806c3916":{name:"Trustlines Network Token",logo:"TLN128.png",erc20:!0,symbol:"TLN",decimals:18},"0xdcD85914b8aE28c1E62f1C488E1D968D5aaFfE2b":{name:"TOP Network Token",logo:"TOP.svg",erc20:!0,symbol:"TOP",decimals:18},"0xaea46A60368A7bD060eec7DF8CBa43b7EF41Ad85":{name:"Fetch",logo:"fetch.svg",erc20:!0,symbol:"FET",decimals:18},"0x2e1E15C44Ffe4Df6a0cb7371CD00d5028e571d14":{name:"Mettalex",logo:"mettalex.svg",erc20:!0,symbol:"MTLX",decimals:18},"0xf21661D0D1d76d3ECb8e1B9F1c923DBfffAe4097":{name:"Realio Network",logo:"rio.svg",erc20:!0,symbol:"RIO",decimals:18},"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{name:"Uniswap",logo:"uni.svg",erc20:!0,symbol:"UNI",decimals:18},"0x2e6539edc3b76f1E21B71d214527FAbA875F70F3":{name:"Yearn Finance Dot",logo:"YFDOT.svg",erc20:!0,symbol:"YFDOT",decimals:18},"0x9F284E1337A815fe77D2Ff4aE46544645B20c5ff":{name:"Darwinia Commitment Token",logo:"kton.svg",erc20:!0,symbol:"KTON",decimals:18},"0xE48972fCd82a274411c01834e2f031D4377Fa2c0":{name:"TwoKeyEconomy",logo:"2key.svg",erc20:!0,symbol:"2KEY",decimals:18},"0x970B9bB2C0444F5E81e9d0eFb84C8ccdcdcAf84d":{name:"Fuse Token",logo:"fuse.svg",erc20:!0,symbol:"FUSE",decimals:18},"0x0Ae055097C6d159879521C384F1D2123D1f195e6":{name:"STAKE Token",logo:"stake.svg",erc20:!0,symbol:"STAKE",decimals:18},"0x5dc60C4D5e75D22588FA17fFEB90A63E535efCE0":{name:"dKargo",logo:"DKA.svg",erc20:!0,symbol:"DKA",decimals:18},"0x9469D013805bFfB7D3DEBe5E7839237e535ec483":{name:"Darwinia Network Native Token",logo:"ring.svg",erc20:!0,symbol:"RING",decimals:18},"0xA31B1767e09f842ECFd4bc471Fe44F830E3891AA":{name:"ROOBEE",logo:"ROOBEE.svg",erc20:!0,symbol:"ROOBEE",decimals:18},"0xC7e43A1c8E118aA2965F5EAbe0e718D83DB7A63C":{name:"ZCore Token",logo:"zcrt.svg",erc20:!0,symbol:"ZCRT",decimals:18},"0x08d32b0da63e2C3bcF8019c9c5d849d7a9d791e6":{name:"Dentacoin Token",logo:"dcn.svg",erc20:!0,symbol:"DCN",decimals:0},"0xe2f2a5C287993345a840Db3B0845fbC70f5935a5":{name:"mStable USD",logo:"mUSD.svg",erc20:!0,symbol:"mUSD",decimals:18},"0xa3BeD4E1c75D00fa6f4E5E6922DB7261B5E9AcD2":{name:"Meta",logo:"MTA.svg",erc20:!0,symbol:"MTA",decimals:18},"0xe3818504c1B32bF1557b16C238B2E01Fd3149C17":{name:"Pillar",logo:"plr.svg",erc20:!0,symbol:"PLR",decimals:18},"0xba100000625a3754423978a60c9317c58a424e3D":{name:"Balancer (BAL)",logo:"balancer.svg",erc20:!0,symbol:"BAL",decimals:18},"0x8a854288a5976036A725879164Ca3e91d30c6A1B":{name:"Guaranteed Entrance Token",logo:"get-logo.svg",erc20:!0,symbol:"GET",decimals:18},"0x2781246fe707bB15CeE3e5ea354e2154a2877B16":{name:"Elysia",logo:"el.svg",erc20:!0,symbol:"EL",decimals:18},"0x4dA34f8264CB33A5c9F17081B9EF5Ff6091116f4":{name:"Elyfi",logo:"elyfi.svg",erc20:!0,symbol:"ELFI",decimals:18},"0xc12d099be31567add4e4e4d0D45691C3F58f5663":{name:"Auctus",logo:"auc.svg",erc20:!0,symbol:"AUC",decimals:18},"0xdF574c24545E5FfEcb9a659c229253D4111d87e1":{name:"HUSD",logo:"HUSD.svg",erc20:!0,symbol:"HUSD",decimals:8},"0x2ecB13A8c458c379c4d9a7259e202De03c8F3D19":{name:"Block-Chain.com Token",logo:"block-chain.svg",erc20:!0,symbol:"BC",decimals:18},"0x38e4adB44ef08F22F5B5b76A8f0c2d0dCbE7DcA1":{name:"Concentrated Voting Power",logo:"PowerPool.svg",erc20:!0,symbol:"CVP",decimals:18},"0xa117000000f279D81A1D3cc75430fAA017FA5A2e":{name:"Aragon Network Token",logo:"antv2.svg",erc20:!0,symbol:"ANT",decimals:18},"0xDecade1c6Bf2cD9fb89aFad73e4a519C867adcF5":{name:"Experty Wisdom Token",logo:"wisdom-token.svg",erc20:!0,symbol:"WIS",decimals:18},"0x7D85e23014F84E6E21d5663aCD8751bEF3562352":{name:"Axion Old",logo:"obsolete.svg",erc20:!0,symbol:"AXNv1",decimals:18},"0x358AA737e033F34df7c54306960a38d09AaBd523":{name:"Ares Token",logo:"ares.svg",erc20:!0,symbol:"ARES",decimals:18},"0xB62132e35a6c13ee1EE0f84dC5d40bad8d815206":{name:"NEXO",logo:"NEXO.svg",erc20:!0,symbol:"NEXO",decimals:18},"0x4612021C75809160Be60DB21fBc9D6adD0B32deF":{name:"BCP Coin",logo:"BCP.svg",erc20:!0,symbol:"BCP",decimals:18},"0xE9E73E1aE76D17A16cC53E3e87a9a7dA78834d37":{name:"Camp",logo:"Camp.svg",erc20:!0,symbol:"CAMP",decimals:18},"0xdacD69347dE42baBfAEcD09dC88958378780FB62":{name:"Atari Token",logo:"atrilast.svg",erc20:!0,symbol:"ATRI",decimals:0},"0x71F85B2E46976bD21302B64329868fd15eb0D127":{name:"Axion",logo:"axion.svg",erc20:!0,symbol:"AXN",decimals:18},"0xc944E90C64B2c07662A292be6244BDf05Cda44a7":{name:"Graph Token",logo:"graphToken.svg",erc20:!0,symbol:"GRT",decimals:18},"0xFE3E6a25e6b192A42a44ecDDCd13796471735ACf":{name:"Reef Finance",logo:"reef.svg",erc20:!0,symbol:"REEF",decimals:18},"0x43Dfc4159D86F3A37A5A4B3D4580b888ad7d4DDd":{name:"DODO bird",logo:"DODO.svg",erc20:!0,symbol:"DODO",decimals:18},"0x4a615bB7166210CCe20E6642a6f8Fb5d4D044496":{name:"NAOS Finance",logo:"naos.svg",erc20:!0,symbol:"NAOS",decimals:18},"0x111111111117dC0aa78b770fA6A738034120C302":{name:"1INCH Token",logo:"1inch.svg",erc20:!0,symbol:"1INCH",decimals:18},"0x27702a26126e0B3702af63Ee09aC4d1A084EF628":{name:"Aleph.im Token",logo:"aleph.svg",erc20:!0,symbol:"ALEPH",decimals:18},"0x32a7C02e79c4ea1008dD6564b35F131428673c41":{name:"CRUST",logo:"crust.svg",erc20:!0,symbol:"CRU",decimals:18},"0x3472A5A71965499acd81997a54BBA8D852C6E53d":{name:"BADGER",logo:"badger.svg",erc20:!0,symbol:"BADGER",decimals:18},"0x65Def5029A0e7591e46B38742bFEdd1Fb7b24436":{name:"Kanpeki",logo:"kanpeki-green.svg",erc20:!0,symbol:"KAE",decimals:18},"0xF94b5C5651c888d928439aB6514B93944eEE6F48":{name:"Yield App",logo:"yield-app.svg",erc20:!0,symbol:"YLD",decimals:18},"0xDcB01cc464238396E213a6fDd933E36796eAfF9f":{name:"Yield",logo:"yield-logo.svg",erc20:!0,symbol:"YLD",decimals:18},"0x968F6f898a6Df937fC1859b323aC2F14643e3fED":{name:"Newscrypto",logo:"NWC.svg",erc20:!0,symbol:"NWC",decimals:18},"0xeb269732ab75A6fD61Ea60b06fE994cD32a83549":{name:"dForce USDx",logo:"USDx.svg",erc20:!0,symbol:"USDx",decimals:18},"0x6e0daDE58D2d89eBBe7aFc384e3E4f15b70b14D8":{name:"QuiverX",logo:"quiverx.svg",erc20:!0,symbol:"QRX",decimals:18},"0x0beAD9a1bcc1b84D06E3f2df67E3549Fd55aB054":{name:"EURxb",logo:"eurxb.svg",erc20:!0,symbol:"EURxb",decimals:18},"0x9F9c8ec3534c3cE16F928381372BfbFBFb9F4D24":{name:"GraphLinq",logo:"glq.svg",erc20:!0,symbol:"GLQ",decimals:18},"0xEB58343b36C7528F23CAAe63a150240241310049":{name:"NBU",logo:"NBU.svg",erc20:!0,symbol:"NBU",decimals:18},"0x16ECCfDbb4eE1A85A33f3A9B21175Cd7Ae753dB4":{name:"Route",logo:"route.svg",erc20:!0,symbol:"ROUTE",decimals:18},"0x75739d5944534115d7C54ee8C73F186D793BAE02":{name:"Collective",logo:"CO2.svg",erc20:!0,symbol:"CO2",decimals:18},"0x35bD01FC9d6D5D81CA9E055Db88Dc49aa2c699A8":{name:"FWB Pro",logo:"FWB.svg",erc20:!0,symbol:"FWB",decimals:18},"0x9B99CcA871Be05119B2012fd4474731dd653FEBe":{name:"Antimatter",logo:"antimatter.svg",erc20:!0,symbol:"MATTER",decimals:18},"0x6De037ef9aD2725EB40118Bb1702EBb27e4Aeb24":{name:"Render Token",logo:"RNDR.svg",erc20:!0,symbol:"RNDR",decimals:18},"0xDf49C9f599A0A9049D97CFF34D0C30E468987389":{name:"SaTT",logo:"SaTT.svg",erc20:!0,symbol:"SATT",decimals:18},"0x431ad2ff6a9C365805eBaD47Ee021148d6f7DBe0":{name:"dForce",logo:"DF.svg",erc20:!0,symbol:"DF",decimals:18},"0x6e1A19F235bE7ED8E3369eF73b196C07257494DE":{name:"Wrapped Filecoin",logo:"WFIL.svg",erc20:!0,symbol:"WFIL",decimals:18},"0xE452E6Ea2dDeB012e20dB73bf5d3863A3Ac8d77a":{name:"Wrapped Celo",logo:"WCELO.svg",erc20:!0,symbol:"wCELO",decimals:18},"0x4A64515E5E1d1073e83f30cB97BEd20400b66E10":{name:"Wrapped ZEC",logo:"WZEC.svg",erc20:!0,symbol:"WZEC",decimals:18},"0xA3865E64121537b5b59B5e239Db4aCBe6F36aa74":{name:"Wrapped Tezos",logo:"WXTZ.svg",erc20:!0,symbol:"WXTZ",decimals:18},"0x53c4871322Bb47e7A24136fce291a6dcC832a294":{name:"Wrapped Litecoin",logo:"WLTC.svg",erc20:!0,symbol:"WLTC",decimals:18},"0xad3E3Fc59dff318BecEaAb7D00EB4F68b1EcF195":{name:"Wrapped Celo USD",logo:"WCUSD.svg",erc20:!0,symbol:"wCUSD",decimals:18},"0x85D7bdfc9c3426b33A684241eEEE70385Bc42820":{name:"Wrapped Kadena",logo:"WKDA.svg",erc20:!0,symbol:"WKDA",decimals:18},"0x39fBBABf11738317a448031930706cd3e612e1B9":{name:"Wrapped XRP",logo:"WXRP.svg",erc20:!0,symbol:"WXRP",decimals:18},"0xBBC7f7A6AADAc103769C66CBC69AB720f7F9Eae3":{name:"INX Token",logo:"INX.svg",erc20:!0,symbol:"INX",decimals:18},"0x1b40183EFB4Dd766f11bDa7A7c3AD8982e998421":{name:"Vesper",logo:"vsp.svg",erc20:!0,symbol:"VSP",decimals:18},"0x544c42fBB96B39B21DF61cf322b5EDC285EE7429":{name:"InsurAce",logo:"INSUR.svg",erc20:!0,symbol:"INSUR",decimals:18},"0xcC665390b03c5D324D8fAF81C15eCee29A73bCB4":{name:"ChainSwap.com Governance Token",logo:"chainswap.svg",erc20:!0,symbol:"ASAP",decimals:18},"0x182F4c4C97cd1c24E1Df8FC4c053E5C47bf53Bef":{name:"keyTango Token",logo:"keyTango.svg",erc20:!0,symbol:"TANGO",decimals:18},"0x0275E1001e293C46CFe158B3702AADe0B99f88a5":{name:"Oiler",logo:"oiler.svg",erc20:!0,symbol:"OIL",decimals:18},"0xDe30da39c46104798bB5aA3fe8B9e0e1F348163F":{name:"Gitcoin",logo:"gtc.svg",erc20:!0,symbol:"GTC",decimals:18},"0x1796ae0b0fa4862485106a0de9b654eFE301D0b2":{name:"Polychain Monsters",logo:"PMON.svg",erc20:!0,symbol:"PMON",decimals:18},"0x8eEF5a82E6Aa222a60F009ac18c24EE12dBf4b41":{name:"Tixl",logo:"TXL.svg",erc20:!0,symbol:"TXL",decimals:18},"0x5218E472cFCFE0b64A064F055B43b4cdC9EfD3A6":{name:"unFederalReserve Token",logo:"eRSDL.svg",erc20:!0,symbol:"eRSDL",decimals:18},"0xE4cC5A22B39fFB0A56d67F94f9300db20D786a5F":{name:"unFederal eRSDL",logo:"uneRSDL.svg",erc20:!0,symbol:"uneRSDL",decimals:8},"0x2dbA05B51eF5A7DE3E7c3327201CA2F8a25C2414":{name:"unFederal DAI",logo:"unDAI.svg",erc20:!0,symbol:"unDAI",decimals:8},"0xFaCecE87e14B50eafc85C44C01702F5f485CA460":{name:"unFederal ETH",logo:"unETH.svg",erc20:!0,symbol:"unETH",decimals:8},"0x6b576972de33BebDe3A703BfF52a091e79f8c87A":{name:"unFederal USDC",logo:"unUSDC.svg",erc20:!0,symbol:"unUSDC",decimals:8},"0x6e2aA5bB90ac37D9006685AFc651ef067E1c7b44":{name:"unFederal USDT",logo:"unUSDT.svg",erc20:!0,symbol:"unUSDT",decimals:8},"0x5D446FC8DBd10EBAcfE9A427aB5402586af98cD4":{name:"unFederal WBTC",logo:"unWBTC.svg",erc20:!0,symbol:"unWBTC",decimals:8},"0xD837eCa6C91c67D98461A411BA2f00bdA9960a9D":{name:"unFederal AAVE",logo:"unAAVE.svg",erc20:!0,symbol:"unAAVE",decimals:8},"0x9e29Ce9cD25F4141dF6BB85b27Ef6933a16A5824":{name:"unFederal YFI",logo:"unYFI.svg",erc20:!0,symbol:"unYFI",decimals:8},"0x031002d15B0D0Cd7c9129d6F644446368deaE391":{name:"unFederal LINK",logo:"unLINK.svg",erc20:!0,symbol:"unLINK",decimals:8},"0xB8E2e2101eD11e9138803cd3e06e16dd19910647":{name:"ArdCoin",logo:"ardcoin.svg",erc20:!0,symbol:"ARDX",decimals:2},"0x6D0F5149c502faf215C89ab306ec3E50b15e2892":{name:"Portion Token",logo:"PRT.svg",erc20:!0,symbol:"PRT",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"3SPACE ART",logo:"3SPACE.svg",erc20:!0,symbol:"PACE",decimals:18},"0x3845badAde8e6dFF049820680d1F14bD3903a5d0":{name:"SAND",logo:"SAND.svg",erc20:!0,symbol:"SAND",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"Spacelens",logo:"SPACE.svg",erc20:!0,symbol:"SPACE",decimals:18},"0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a":{name:"Sandbox's LANDs",logo:"SAND.svg",erc20:!1,erc721:!0,symbol:"LAND",decimals:0},"0x362bc847A3a9637d3af6624EeC853618a43ed7D2":{name:"PARSIQ",logo:"parsiq.svg",erc20:!0,symbol:"PRQ",decimals:18},"0x21381e026Ad6d8266244f2A583b35F9E4413FA2a":{name:"Formation Finance",logo:"form.svg",erc20:!0,symbol:"FORM",decimals:18},"0x2ba592F78dB6436527729929AAf6c908497cB200":{name:"Cream",logo:"cream.svg",erc20:!0,symbol:"CREAM",decimals:18},"0x46576e20EC5F25586A6Fa2E0d6B6058354B72E72":{name:"Cryptomind",logo:"CR.svg",erc20:!0,erc721:!1,symbol:"CR",decimals:8},"0x5ab21Ec0bfa0B29545230395e3Adaca7d552C948":{name:"PUNKS Comic",logo:"punks-comic.svg",erc20:!1,erc721:!0,symbol:"COMIC",decimals:0},"0x9C2dc0c3CC2BADdE84B0025Cf4df1c5aF288D835":{name:"Coreto",logo:"coreto.svg",erc20:!0,symbol:"COR",decimals:18},"0x0De05F6447ab4D22c8827449EE4bA2D5C288379B":{name:"OOKI",logo:"ooki.svg",erc20:!0,symbol:"OOKI",decimals:18},"0x6B4c7A5e3f0B99FCD83e9c089BDDD6c7FCe5c611":{name:"Million",logo:"million.svg",erc20:!0,symbol:"MM",decimals:18},"0x56d811088235F11C8920698a204A5010a788f4b3":{name:"bZx Protocol Token (BZRX)",logo:"ic_token_bzrx.svg",erc20:!0,symbol:"BZRX",decimals:18},"0xB72B31907C1C95F3650b64b2469e08EdACeE5e8F":{name:"bZx Vesting Token (vBZRX)",logo:"ic_token_vbzrx.svg",erc20:!0,symbol:"vBZRX",decimals:18},"0x3085154623F51b00Dedfc6Ceeb5197277A66B17B":{name:"NIFTY",logo:"nfty.svg",erc20:!0,symbol:"NFTY",decimals:18},"0xB983E01458529665007fF7E0CDdeCDB74B967Eb6":{name:"Fulcrum ETH iToken (iETH)",logo:"ic_token_ieth.svg",erc20:!0,symbol:"iETH",decimals:18},"0x32E4c68B3A4a813b710595AebA7f6B7604Ab9c15":{name:"Fulcrum USDC iToken (iUSDC)",logo:"ic_token_iusdc.svg",erc20:!0,symbol:"iUSDC",decimals:6},"0x2ffa85f655752fB2aCB210287c60b9ef335f5b6E":{name:"Fulcrum WBTC iToken (iWBTC)",logo:"ic_token_ibtc.svg",erc20:!0,symbol:"iWBTC",decimals:8},"0x687642347a9282Be8FD809d8309910A3f984Ac5a":{name:"Fulcrum KNC iToken (iKNC)",logo:"ic_token_iknc.svg",erc20:!0,symbol:"iKNC",decimals:18},"0x463538705E7d22aA7f03Ebf8ab09B067e1001B54":{name:"Fulcrum LINK iToken (iLINK)",logo:"ic_token_ilink.svg",erc20:!0,symbol:"iLINK",decimals:18},"0x6b093998D36f2C7F0cc359441FBB24CC629D5FF0":{name:"Fulcrum DAI iToken (iDAI)",logo:"ic_token_idai.svg",erc20:!0,symbol:"iDAI",decimals:18},"0x7e9997a38A439b2be7ed9c9C4628391d3e055D48":{name:"Fulcrum USDT iToken (iUSDT)",logo:"ic_token_iusdt.svg",erc20:!0,symbol:"iUSDT",decimals:6},"0x9189c499727f88F8eCC7dC4EEA22c828E6AaC015":{name:"Fulcrum MKR iToken (iMKR)",logo:"ic_token_imkr.svg",erc20:!0,symbol:"iMKR",decimals:18},"0x18240BD9C07fA6156Ce3F3f61921cC82b2619157":{name:"Fulcrum BZRX iToken (iBZRX)",logo:"ic_token_ibzrx.svg",erc20:!0,symbol:"iBZRX",decimals:18},"0x7F3Fe9D492A9a60aEBb06d82cBa23c6F32CAd10b":{name:"Fulcrum YFI iToken (iYFI)",logo:"ic_token_iyfi.svg",erc20:!0,symbol:"iYFI",decimals:18},"0x0a625FceC657053Fe2D9FFFdeb1DBb4e412Cf8A8":{name:"Fulcrum UNI iToken (iUNI)",logo:"ic_token_iuni.svg",erc20:!0,symbol:"iUNI",decimals:18},"0x0cae8d91E0b1b7Bd00D906E990C3625b2c220db1":{name:"Fulcrum AAVE iToken (iAAVE)",logo:"ic_token_iaave.svg",erc20:!0,symbol:"iAAVE",decimals:18},"0x3dA0e01472Dee3746b4D324a65D7EdFaECa9Aa4f":{name:"Fulcrum LRC iToken (iLRC)",logo:"ic_token_ilrc.svg",erc20:!0,symbol:"iLRC",decimals:18},"0x6d29903BC2c4318b59B35d97Ab98ab9eC08Ed70D":{name:"Fulcrum COMP iToken (iCOMP)",logo:"ic_token_icomp.svg",erc20:!0,symbol:"iCOMP",decimals:18},"0x08c32b0726C5684024ea6e141C50aDe9690bBdcc":{name:"Stratos Token",logo:"stos.svg",erc20:!0,symbol:"STOS",decimals:18},"0xe28b3B32B6c345A34Ff64674606124Dd5Aceca30":{name:"Injective",logo:"inj.svg",erc20:!0,symbol:"INJ",decimals:18},"0xe516D78d784C77D479977BE58905B3f2b1111126":{name:"Bitspawn",logo:"spwn.svg",erc20:!0,symbol:"SPWN",decimals:18},"0xB16e967ff83DE3F1e9FCeAfbc2C28c1c5c56eF91":{name:"Polkadog",logo:"polkadog.svg",erc20:!0,symbol:"PDOG",decimals:18},"0x07c52c2537D84e532a9F15d32E152C8B94D2b232":{name:"ZkTube",logo:"ZKT.svg",erc20:!0,symbol:"ZKT",decimals:18},"0xF4d861575ecC9493420A3f5a14F85B13f0b50EB3":{name:"Fractal Protocol",logo:"fractal.svg",erc20:!0,symbol:"FCL",decimals:18},"0x3af33bEF05C2dCb3C7288b77fe1C8d2AeBA4d789":{name:"Kromatika",logo:"krom.svg",erc20:!0,symbol:"KROM",decimals:18},"0xA130E3a33a4d84b04c3918c4E5762223Ae252F80":{name:"Swash Token",logo:"swash.svg",erc20:!0,symbol:"SWASH",decimals:18},"0xea7Cc765eBC94C4805e3BFf28D7E4aE48D06468A":{name:"NearPad Token",logo:"nearpad.svg",erc20:!0,symbol:"PAD",decimals:18},"0x87C22615435998D69ACA34889D03155B694a94fc":{name:"DiemLibre",logo:"DLB.svg",erc20:!0,symbol:"DLB",decimals:18},"0x4d224452801ACEd8B2F0aebE155379bb5D594381":{name:"ApeCoin",logo:"APE.svg",erc20:!0,symbol:"APE",decimals:18},"0xCd1fAFf6e578Fa5cAC469d2418C95671bA1a62Fe":{name:"Torum Token",logo:"torum.svg",erc20:!0,symbol:"XTM",decimals:18},"0xcf0C122c6b73ff809C693DB761e7BaeBe62b6a2E":{name:"FLOKI",logo:"floki.svg",erc20:!0,symbol:"FLOKI",decimals:9},"0xe831F96A7a1DcE1aa2EB760b1e296c6A74CaA9d5":{name:"Nexum Coin",logo:"nexum.svg",erc20:!0,symbol:"Nexm",decimals:8},"0x6710c63432A2De02954fc0f851db07146a6c0312":{name:"MFG",logo:"mfg.svg",erc20:!0,symbol:"MFG",decimals:18},"0xae78736Cd615f374D3085123A210448E74Fc6393":{name:"Rocket Pool ETH",logo:"rETH.svg",erc20:!0,symbol:"rETH",decimals:18},"0x0C10bF8FcB7Bf5412187A595ab97a3609160b5c6":{name:"Decentralized USD",logo:"USDD.svg",erc20:!0,symbol:"USDD",decimals:18},"0xD33526068D116cE69F19A9ee46F0bd304F21A51f":{name:"Rocket Pool",logo:"rpl.svg",erc20:!0,symbol:"RPL",decimals:18},"0x9d38F670D15C14716BE1F109a4F453E966A2B6D4":{name:"Quid Ika",logo:"QuidIka.svg",erc20:!0,symbol:"QUID",decimals:9},"0xD3c625F54dec647DB8780dBBe0E880eF21BA4329":{name:"HollaEx Token",logo:"xht.svg",erc20:!0,symbol:"XHT",decimals:18},"0x01e0E2e61f554eCAaeC0cC933E739Ad90f24a86d":{name:"GTON",logo:"gton.svg",erc20:!0,symbol:"GTON",decimals:18},"0xeFF66B4A84C8a6b69b99EB1C5e39aF8fc35d13db":{name:"sGTON",logo:"sgton.svg",erc20:!0,symbol:"sGTON",decimals:18},"0x7659CE147D0e714454073a5dd7003544234b6Aa0":{name:"XCAD Token",logo:"xcad.svg",erc20:!0,symbol:"XCAD",decimals:18},"0x88dF592F8eb5D7Bd38bFeF7dEb0fBc02cf3778a0":{name:"Tellor Tributes",logo:"TRB.svg",erc20:!0,symbol:"TRB",decimals:18},"0x8d96B4ab6C741a4C8679AE323a100d74f085BA8F":{name:"Bazaars",logo:"BZR.svg",erc20:!0,symbol:"BZR",decimals:18},"0x9ee91F9f426fA633d227f7a9b000E28b9dfd8599":{name:"Liquid staked MATIC",logo:"stMATIC.svg",erc20:!0,symbol:"stMATIC",decimals:18},"0x0d02755a5700414B26FF040e1dE35D337DF56218":{name:"Bend Token",logo:"BendDAO.svg",erc20:!0,symbol:"BEND",decimals:18},"0x1A4b46696b2bB4794Eb3D4c26f1c55F9170fa4C5":{name:"BitDAO",logo:"BitDAO.svg",erc20:!0,erc721:!1,symbol:"BIT",decimals:18},"0xb8919522331C59f5C16bDfAA6A121a6E03A91F62":{name:"Home",logo:"home.svg",erc20:!0,erc721:!1,symbol:"HOME",decimals:6},"0xa54d2EBfD977ad836203c85F18db2F0a0cF88854":{name:"Bacon",logo:"bacon.svg",erc20:!0,erc721:!1,symbol:"BACON",decimals:18},"0x249cA82617eC3DfB2589c4c17ab7EC9765350a18":{name:"Verse",logo:"VERSE.svg",erc20:!0,erc721:!1,symbol:"VERSE",decimals:18},"0x317eb4ad9cfaC6232f0046831322E895507bcBeb":{name:"Tidex Token",logo:"tidex.svg",erc20:!0,symbol:"TDX",decimals:18},"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE":{name:"SHIBA INU",logo:"shib.svg",erc20:!0,symbol:"SHIB",decimals:18},"0x3506424F91fD33084466F402d5D97f05F8e3b4AF":{name:"chiliZ",logo:"chz.svg",erc20:!0,symbol:"CHZ",decimals:18},"0x15D4c048F83bd7e37d49eA4C83a07267Ec4203dA":{name:"Gala",logo:"gala.svg",erc20:!0,symbol:"GALA",decimals:8},"0x69af81e73A73B40adF4f3d4223Cd9b1ECE623074":{name:"Mask Network",logo:"mask.svg",erc20:!0,symbol:"MASK",decimals:18},"0xD533a949740bb3306d119CC777fa900bA034cd52":{name:"Curve DAO Token",logo:"crv.svg",erc20:!0,symbol:"CRV",decimals:18},"0x92D6C1e31e14520e676a687F0a93788B716BEff5":{name:"dYdX",logo:"dydx.svg",erc20:!0,symbol:"DYDX",decimals:18},"0x60bE1e1fE41c1370ADaF5d8e66f07Cf1C2Df2268":{name:"Perion Credits",logo:"perc.svg",erc20:!0,symbol:"PERC",decimals:18},"0x8971f9fd7196e5cEE2C1032B50F656855af7Dd26":{name:"Lambda",logo:"LAMB.svg",erc20:!0,symbol:"LAMB",decimals:18},"0x65514b352d1d4a17DE97f95C7faB177C625Bd6ff":{name:"KIBBLE Token",logo:"kibble.svg",erc20:!0,erc721:!1,symbol:"KBLE",decimals:18},"0xd9Fcd98c322942075A5C3860693e9f4f03AAE07b":{name:"Euler",logo:"eul.svg",erc20:!0,erc721:!1,symbol:"EUL",decimals:18},"0x777fD20c983d6658c1D50b3958B3A1733d1cd1E1":{name:"PUBLISH",logo:"publish.svg",erc20:!0,symbol:"NEWS",decimals:9},"0x19062190B1925b5b6689D7073fDfC8c2976EF8Cb":{name:"Swarm",logo:"ethswarm.svg",erc20:!0,symbol:"BZZ",decimals:16},"0x6aA030a9710CAD6E719A4EC0a85260Eb3F4F86c1":{name:"Real World Asset",logo:"rwa.svg",erc20:!0,symbol:"RWA",decimals:18},"0xde16Ce60804a881e9F8c4eBB3824646EDecd478D":{name:"MagicCraft",logo:"magiccraft.svg",erc20:!0,symbol:"MCRT",decimals:9},"0x7163436b8EfFfB469F6BB81cc908b1661d4795e6":{name:"Esco coin",logo:"escocoin.svg",erc20:!0,symbol:"ESCO",decimals:18},"0x9625cE7753ace1fa1865A47aAe2c5C2Ce4418569":{name:"KAP Games",logo:"kap-games.svg",erc20:!0,symbol:"KAP",decimals:18},"0x4FbB350052Bca5417566f188eB2EBCE5b19BC964":{name:"Rigo",logo:"grg.svg",erc20:!0,symbol:"GRG",decimals:18},"0xD8E163967FED76806Df0097B704bA721B9b37656":{name:"Cope",logo:"cope.svg",erc20:!0,symbol:"COPE",decimals:18},"0xdfbc9050F5B01DF53512DCC39B4f2B2BBaCD517A":{name:"Jobchain",logo:"job.svg",erc20:!0,symbol:"JOB",decimals:8},"0x083D41d6DD21EE938f0c055CA4fb12268DF0EfaC":{name:"GogolCoin",logo:"gol.svg",erc20:!0,symbol:"GOL",decimals:4},"0x9B4a69dE6CA0deFDD02c0c4ce6Cb84de5202944E":{name:"PROOF Platform",erc20:!0,symbol:"PROOF",decimals:9,logo:"proof-platform.svg"},"0x4507cEf57C46789eF8d1a19EA45f4216bae2B528":{name:"TokenFi",logo:"tokenfi.svg",erc20:!0,symbol:"TOKEN",decimals:9},"0x8B39B70E39Aa811b69365398e0aACe9bee238AEb":{name:"PolkaFoundry",logo:"pkf.svg",erc20:!0,symbol:"PKF",decimals:18},"0x2c95D751DA37A5C1d9c5a7Fd465c1d50F3d96160":{name:"WASSIE",logo:"wassie.svg",erc20:!0,symbol:"WASSIE",decimals:18},"0x06325440D014e39736583c165C2963BA99fAf14E":{name:"Curve.fi",logo:"steCRV.png",erc20:!0,symbol:"steCRV",decimals:18},"0x4E241A9EC66832a16bceaeB9156E524487f061D7":{name:"ETF Rocks",logo:"etf.svg",erc20:!0,symbol:"ETF",decimals:18},"0xA849EaaE994fb86Afa73382e9Bd88c2B6b18Dc71":{name:"Mass Vehicle Ledger",logo:"mvl.svg",erc20:!0,symbol:"MVL",decimals:18},"0xd5F7838F5C461fefF7FE49ea5ebaF7728bB0ADfa":{name:"Mantle Staked Ether",logo:"mETH.svg",erc20:!0,erc721:!1,symbol:"mETH",decimals:18}}}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/contract-map.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/index.js",{"./contract-map.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./contract-map.json")}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.NETWORKS_BYPASSING_VALIDATION=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=void 0;const s=e("./types.cjs");var r;n.RPC="rpc",n.FALL_BACK_VS_CURRENCY="ETH",n.IPFS_DEFAULT_GATEWAY_URL="https://cloudflare-ipfs.com/ipfs/",n.GANACHE_CHAIN_ID="0x539",n.MAX_SAFE_CHAIN_ID=0xfffffffffffec,n.ERC721="ERC721",n.ERC1155="ERC1155",n.ERC20="ERC20",n.ERC721_INTERFACE_ID="0x80ac58cd",n.ERC721_METADATA_INTERFACE_ID="0x5b5e139f",n.ERC721_ENUMERABLE_INTERFACE_ID="0x780e9d63",n.ERC1155_INTERFACE_ID="0xd9b67a26",n.ERC1155_METADATA_URI_INTERFACE_ID="0x0e89341c",n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID="0x4e2312e0",n.GWEI="gwei",n.ASSET_TYPES={NATIVE:"NATIVE",TOKEN:"TOKEN",NFT:"NFT",UNKNOWN:"UNKNOWN"},n.TESTNET_TICKER_SYMBOLS={GOERLI:"GoerliETH",SEPOLIA:"SepoliaETH",LINEA_GOERLI:"LineaETH",LINEA_SEPOLIA:"LineaETH",MEGAETH_TESTNET:"MegaETH"},n.BUILT_IN_CUSTOM_NETWORKS_RPC={MEGAETH_TESTNET:"https://carrot.megaeth.com/rpc","megaeth-testnet":"https://carrot.megaeth.com/rpc","monad-testnet":"https://testnet-rpc.monad.xyz"},n.BUILT_IN_NETWORKS={[s.NetworkType.goerli]:{chainId:s.ChainId.goerli,ticker:s.NetworksTicker.goerli,rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl.goerli}},[s.NetworkType.sepolia]:{chainId:s.ChainId.sepolia,ticker:s.NetworksTicker.sepolia,rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl.sepolia}},[s.NetworkType.mainnet]:{chainId:s.ChainId.mainnet,ticker:s.NetworksTicker.mainnet,rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl.mainnet}},[s.NetworkType["linea-goerli"]]:{chainId:s.ChainId["linea-goerli"],ticker:s.NetworksTicker["linea-goerli"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["linea-goerli"]}},[s.NetworkType["linea-sepolia"]]:{chainId:s.ChainId["linea-sepolia"],ticker:s.NetworksTicker["linea-sepolia"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["linea-sepolia"]}},[s.NetworkType["linea-mainnet"]]:{chainId:s.ChainId["linea-mainnet"],ticker:s.NetworksTicker["linea-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["linea-mainnet"]}},[s.NetworkType["megaeth-testnet"]]:{chainId:s.ChainId["megaeth-testnet"],ticker:s.NetworksTicker["megaeth-testnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["megaeth-testnet"]}},[s.NetworkType["monad-testnet"]]:{chainId:s.ChainId["monad-testnet"],ticker:s.NetworksTicker["monad-testnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["monad-testnet"]}},[s.NetworkType["base-mainnet"]]:{chainId:s.ChainId["base-mainnet"],ticker:s.NetworksTicker["base-mainnet"],rpcPrefs:{blockExplorerUrl:s.BlockExplorerUrl["base-mainnet"]}},[s.NetworkType.rpc]:{chainId:undefined,blockExplorerUrl:undefined,ticker:undefined,rpcPrefs:undefined}},n.NETWORKS_BYPASSING_VALIDATION={"0x3e7":{name:"HyperEVM",symbol:"HYPE",rpcUrl:"https://rpc.hyperliquid.xyz"}},n.OPENSEA_PROXY_URL="https://proxy.api.cx.metamask.io/opensea/v1/api/v2",n.NFT_API_BASE_URL="https://nft.api.cx.metamask.io",n.NFT_API_VERSION="1",n.NFT_API_TIMEOUT=15e3,n.ORIGIN_METAMASK="metamask",function(e){e.AddEthereumChain="wallet_addEthereumChain",e.ConnectAccounts="connect_accounts",e.EthDecrypt="eth_decrypt",e.EthGetEncryptionPublicKey="eth_getEncryptionPublicKey",e.EthSignTypedData="eth_signTypedData",e.PersonalSign="personal_sign",e.ResultError="result_error",e.ResultSuccess="result_success",e.SnapDialogAlert="snap_dialog:alert",e.SnapDialogConfirmation="snap_dialog:confirmation",e.SnapDialogPrompt="snap_dialog:prompt",e.SnapDialogDefault="snap_dialog",e.SwitchEthereumChain="wallet_switchEthereumChain",e.Transaction="transaction",e.TransactionBatch="transaction_batch",e.Unlock="unlock",e.WalletConnect="wallet_connect",e.WalletRequestPermissions="wallet_requestPermissions",e.WatchAsset="wallet_watchAsset"}(r||(n.ApprovalType=r={})),n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP={[s.ChainId.goerli]:s.BuiltInNetworkName.Goerli,[s.ChainId.sepolia]:s.BuiltInNetworkName.Sepolia,[s.ChainId.mainnet]:s.BuiltInNetworkName.Mainnet,[s.ChainId["linea-goerli"]]:s.BuiltInNetworkName.LineaGoerli,[s.ChainId["linea-sepolia"]]:s.BuiltInNetworkName.LineaSepolia,[s.ChainId["linea-mainnet"]]:s.BuiltInNetworkName.LineaMainnet,[s.ChainId.aurora]:s.BuiltInNetworkName.Aurora},n.SECOND=1e3,n.SECONDS=n.SECOND,n.MINUTE=60*n.SECONDS,n.MINUTES=n.MINUTE,n.HOUR=60*n.MINUTES,n.HOURS=n.HOUR,n.DAY=24*n.HOURS,n.DAYS=n.DAY}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs",{cockatiel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/cockatiel/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createServicePolicy=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_MAX_RETRIES=n.handleWhen=n.handleAll=n.ExponentialBackoff=n.ConstantBackoff=n.CircuitState=n.BrokenCircuitError=void 0;const s=e("cockatiel");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return s.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return s.CircuitState}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return s.ExponentialBackoff}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return s.ConstantBackoff}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return s.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return s.handleWhen}}),n.DEFAULT_MAX_RETRIES=3,n.DEFAULT_MAX_CONSECUTIVE_FAILURES=3*(1+n.DEFAULT_MAX_RETRIES),n.DEFAULT_CIRCUIT_BREAK_DURATION=18e5,n.DEFAULT_DEGRADED_THRESHOLD=5e3;const r=e=>"object"!=typeof e||null===e||!("httpStatus"in e)||"number"!=typeof e.httpStatus||e.httpStatus>=500;function a(e){return e===s.CircuitState.Open?{state:e,openedAt:Date.now()}:{state:e}}n.createServicePolicy=function(e={}){const{maxRetries:t=n.DEFAULT_MAX_RETRIES,retryFilterPolicy:o=s.handleAll,maxConsecutiveFailures:i=n.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:c=n.DEFAULT_CIRCUIT_BREAK_DURATION,degradedThreshold:m=n.DEFAULT_DEGRADED_THRESHOLD,backoff:d=new s.ExponentialBackoff}=e,u=(0,s.retry)(o,{maxAttempts:t,backoff:d}),l=u.onRetry.bind(u),h=(0,s.circuitBreaker)((0,s.handleWhen)(r),{halfOpenAfter:c,breaker:new s.ConsecutiveBreaker(i)});let p=a(h.state);h.onStateChange(e=>{p=a(e)});const f=h.onBreak.bind(h),g=new s.EventEmitter;u.onGiveUp(e=>{h.state===s.CircuitState.Closed&&g.emit(e)}),u.onSuccess(({duration:e})=>{h.state===s.CircuitState.Closed&&e>m&&g.emit()});const y=g.addListener;return{...(0,s.wrap)(u,h),circuitBreakerPolicy:h,circuitBreakDuration:c,getRemainingCircuitOpenDuration:()=>p.state===s.CircuitState.Open?p.openedAt+c-Date.now():null,retryPolicy:u,onBreak:f,onDegraded:y,onRetry:l}}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/create-service-policy.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","./create-service-policy.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs","./siwe.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs","./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.fractionBN=n.fetchWithErrorHandling=n.convertHexToDecimal=n.BNToHex=n.NETWORKS_BYPASSING_VALIDATION=n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=n.handleWhen=n.handleAll=n.createServicePolicy=n.ExponentialBackoff=n.DEFAULT_MAX_RETRIES=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.ConstantBackoff=n.CircuitState=n.BrokenCircuitError=void 0,n.isEqualCaseInsensitive=n.weiHexToGweiDec=n.toHex=n.toChecksumHexAddress=n.timeoutFetch=n.successfulFetch=n.safelyExecuteWithTimeout=n.safelyExecute=n.query=n.normalizeEnsName=n.isValidHexAddress=n.isValidJson=n.isSmartContractCode=n.isSafeDynamicKey=n.isSafeChainId=n.isPlainObject=n.isNonEmptyArray=n.HttpError=n.hexToText=n.hexToBN=n.handleFetch=n.gweiDecToWEIBN=n.getBuyURL=n.fromHex=void 0;var a=e("./create-service-policy.cjs");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return a.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return a.CircuitState}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return a.ConstantBackoff}}),Object.defineProperty(n,"DEFAULT_CIRCUIT_BREAK_DURATION",{enumerable:!0,get:function(){return a.DEFAULT_CIRCUIT_BREAK_DURATION}}),Object.defineProperty(n,"DEFAULT_DEGRADED_THRESHOLD",{enumerable:!0,get:function(){return a.DEFAULT_DEGRADED_THRESHOLD}}),Object.defineProperty(n,"DEFAULT_MAX_CONSECUTIVE_FAILURES",{enumerable:!0,get:function(){return a.DEFAULT_MAX_CONSECUTIVE_FAILURES}}),Object.defineProperty(n,"DEFAULT_MAX_RETRIES",{enumerable:!0,get:function(){return a.DEFAULT_MAX_RETRIES}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return a.ExponentialBackoff}}),Object.defineProperty(n,"createServicePolicy",{enumerable:!0,get:function(){return a.createServicePolicy}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return a.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return a.handleWhen}});var o=e("./constants.cjs");Object.defineProperty(n,"RPC",{enumerable:!0,get:function(){return o.RPC}}),Object.defineProperty(n,"FALL_BACK_VS_CURRENCY",{enumerable:!0,get:function(){return o.FALL_BACK_VS_CURRENCY}}),Object.defineProperty(n,"IPFS_DEFAULT_GATEWAY_URL",{enumerable:!0,get:function(){return o.IPFS_DEFAULT_GATEWAY_URL}}),Object.defineProperty(n,"GANACHE_CHAIN_ID",{enumerable:!0,get:function(){return o.GANACHE_CHAIN_ID}}),Object.defineProperty(n,"MAX_SAFE_CHAIN_ID",{enumerable:!0,get:function(){return o.MAX_SAFE_CHAIN_ID}}),Object.defineProperty(n,"ERC721",{enumerable:!0,get:function(){return o.ERC721}}),Object.defineProperty(n,"ERC1155",{enumerable:!0,get:function(){return o.ERC1155}}),Object.defineProperty(n,"ERC20",{enumerable:!0,get:function(){return o.ERC20}}),Object.defineProperty(n,"ERC721_INTERFACE_ID",{enumerable:!0,get:function(){return o.ERC721_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_METADATA_INTERFACE_ID",{enumerable:!0,get:function(){return o.ERC721_METADATA_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_ENUMERABLE_INTERFACE_ID",{enumerable:!0,get:function(){return o.ERC721_ENUMERABLE_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_INTERFACE_ID",{enumerable:!0,get:function(){return o.ERC1155_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_METADATA_URI_INTERFACE_ID",{enumerable:!0,get:function(){return o.ERC1155_METADATA_URI_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_TOKEN_RECEIVER_INTERFACE_ID",{enumerable:!0,get:function(){return o.ERC1155_TOKEN_RECEIVER_INTERFACE_ID}}),Object.defineProperty(n,"GWEI",{enumerable:!0,get:function(){return o.GWEI}}),Object.defineProperty(n,"ASSET_TYPES",{enumerable:!0,get:function(){return o.ASSET_TYPES}}),Object.defineProperty(n,"TESTNET_TICKER_SYMBOLS",{enumerable:!0,get:function(){return o.TESTNET_TICKER_SYMBOLS}}),Object.defineProperty(n,"BUILT_IN_CUSTOM_NETWORKS_RPC",{enumerable:!0,get:function(){return o.BUILT_IN_CUSTOM_NETWORKS_RPC}}),Object.defineProperty(n,"BUILT_IN_NETWORKS",{enumerable:!0,get:function(){return o.BUILT_IN_NETWORKS}}),Object.defineProperty(n,"OPENSEA_PROXY_URL",{enumerable:!0,get:function(){return o.OPENSEA_PROXY_URL}}),Object.defineProperty(n,"NFT_API_BASE_URL",{enumerable:!0,get:function(){return o.NFT_API_BASE_URL}}),Object.defineProperty(n,"NFT_API_VERSION",{enumerable:!0,get:function(){return o.NFT_API_VERSION}}),Object.defineProperty(n,"NFT_API_TIMEOUT",{enumerable:!0,get:function(){return o.NFT_API_TIMEOUT}}),Object.defineProperty(n,"ORIGIN_METAMASK",{enumerable:!0,get:function(){return o.ORIGIN_METAMASK}}),Object.defineProperty(n,"ApprovalType",{enumerable:!0,get:function(){return o.ApprovalType}}),Object.defineProperty(n,"CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP",{enumerable:!0,get:function(){return o.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP}}),Object.defineProperty(n,"SECOND",{enumerable:!0,get:function(){return o.SECOND}}),Object.defineProperty(n,"SECONDS",{enumerable:!0,get:function(){return o.SECONDS}}),Object.defineProperty(n,"MINUTE",{enumerable:!0,get:function(){return o.MINUTE}}),Object.defineProperty(n,"MINUTES",{enumerable:!0,get:function(){return o.MINUTES}}),Object.defineProperty(n,"HOUR",{enumerable:!0,get:function(){return o.HOUR}}),Object.defineProperty(n,"HOURS",{enumerable:!0,get:function(){return o.HOURS}}),Object.defineProperty(n,"DAY",{enumerable:!0,get:function(){return o.DAY}}),Object.defineProperty(n,"DAYS",{enumerable:!0,get:function(){return o.DAYS}}),Object.defineProperty(n,"NETWORKS_BYPASSING_VALIDATION",{enumerable:!0,get:function(){return o.NETWORKS_BYPASSING_VALIDATION}});var i=e("./util.cjs");Object.defineProperty(n,"BNToHex",{enumerable:!0,get:function(){return i.BNToHex}}),Object.defineProperty(n,"convertHexToDecimal",{enumerable:!0,get:function(){return i.convertHexToDecimal}}),Object.defineProperty(n,"fetchWithErrorHandling",{enumerable:!0,get:function(){return i.fetchWithErrorHandling}}),Object.defineProperty(n,"fractionBN",{enumerable:!0,get:function(){return i.fractionBN}}),Object.defineProperty(n,"fromHex",{enumerable:!0,get:function(){return i.fromHex}}),Object.defineProperty(n,"getBuyURL",{enumerable:!0,get:function(){return i.getBuyURL}}),Object.defineProperty(n,"gweiDecToWEIBN",{enumerable:!0,get:function(){return i.gweiDecToWEIBN}}),Object.defineProperty(n,"handleFetch",{enumerable:!0,get:function(){return i.handleFetch}}),Object.defineProperty(n,"hexToBN",{enumerable:!0,get:function(){return i.hexToBN}}),Object.defineProperty(n,"hexToText",{enumerable:!0,get:function(){return i.hexToText}}),Object.defineProperty(n,"HttpError",{enumerable:!0,get:function(){return i.HttpError}}),Object.defineProperty(n,"isNonEmptyArray",{enumerable:!0,get:function(){return i.isNonEmptyArray}}),Object.defineProperty(n,"isPlainObject",{enumerable:!0,get:function(){return i.isPlainObject}}),Object.defineProperty(n,"isSafeChainId",{enumerable:!0,get:function(){return i.isSafeChainId}}),Object.defineProperty(n,"isSafeDynamicKey",{enumerable:!0,get:function(){return i.isSafeDynamicKey}}),Object.defineProperty(n,"isSmartContractCode",{enumerable:!0,get:function(){return i.isSmartContractCode}}),Object.defineProperty(n,"isValidJson",{enumerable:!0,get:function(){return i.isValidJson}}),Object.defineProperty(n,"isValidHexAddress",{enumerable:!0,get:function(){return i.isValidHexAddress}}),Object.defineProperty(n,"normalizeEnsName",{enumerable:!0,get:function(){return i.normalizeEnsName}}),Object.defineProperty(n,"query",{enumerable:!0,get:function(){return i.query}}),Object.defineProperty(n,"safelyExecute",{enumerable:!0,get:function(){return i.safelyExecute}}),Object.defineProperty(n,"safelyExecuteWithTimeout",{enumerable:!0,get:function(){return i.safelyExecuteWithTimeout}}),Object.defineProperty(n,"successfulFetch",{enumerable:!0,get:function(){return i.successfulFetch}}),Object.defineProperty(n,"timeoutFetch",{enumerable:!0,get:function(){return i.timeoutFetch}}),Object.defineProperty(n,"toChecksumHexAddress",{enumerable:!0,get:function(){return i.toChecksumHexAddress}}),Object.defineProperty(n,"toHex",{enumerable:!0,get:function(){return i.toHex}}),Object.defineProperty(n,"weiHexToGweiDec",{enumerable:!0,get:function(){return i.weiHexToGweiDec}}),Object.defineProperty(n,"isEqualCaseInsensitive",{enumerable:!0,get:function(){return i.isEqualCaseInsensitive}}),r(e("./types.cjs"),n),r(e("./siwe.cjs"),n)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("controller-utils")}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs",{"./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@spruceid/siwe-parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@spruceid/siwe-parser/dist/parsers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.detectSIWE=n.isValidSIWEOrigin=n.parseDomainParts=void 0;const s=e("@metamask/utils"),r=e("@spruceid/siwe-parser"),a=e("./logger.cjs"),o=(0,a.createModuleLogger)(a.projectLogger,"detect-siwe");function i(e){try{const r="string"!=typeof(n=e)?n:(0,s.remove0x)(n),a=t.from(r,"hex");return 32===a.length?e:a.toString("utf8")}catch(t){return o(t),e}var n}const c={"http:":"80","https:":"443"};n.parseDomainParts=(e,t)=>e.match(/^[^/:]*:\/\//u)?new URL(e):new URL(`${t}//${e}`);n.isValidSIWEOrigin=e=>{try{const{origin:t,siwe:s}=e;if(!t||!s?.parsedMessage?.domain)return!1;const r=new URL(t),a=(0,n.parseDomainParts)(s.parsedMessage.domain,r.protocol);return 0===a.hostname.localeCompare(r.hostname,undefined,{sensitivity:"accent"})&&(""!==a.port&&a.port!==r.port?""===r.port&&a.port===c[r.protocol]:""===a.username||a.username===r.username)}catch(e){return o(e),!1}};n.detectSIWE=e=>{try{const{data:t}=e,n=i(t);return{isSIWEMessage:!0,parsedMessage:new r.ParsedMessage(n)}}catch(e){return{isSIWEMessage:!1,parsedMessage:null}}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/siwe.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r;Object.defineProperty(n,"__esModule",{value:!0}),n.NetworkNickname=n.BlockExplorerUrl=n.NetworksTicker=n.ChainId=n.BuiltInNetworkName=n.isInfuraNetworkType=n.isNetworkType=n.NetworkType=n.CustomNetworkType=n.InfuraNetworkType=void 0,n.InfuraNetworkType={mainnet:"mainnet",goerli:"goerli",sepolia:"sepolia","linea-goerli":"linea-goerli","linea-sepolia":"linea-sepolia","linea-mainnet":"linea-mainnet","base-mainnet":"base-mainnet"},n.CustomNetworkType={"megaeth-testnet":"megaeth-testnet","monad-testnet":"monad-testnet"},n.NetworkType={...n.InfuraNetworkType,...n.CustomNetworkType,rpc:"rpc"},n.isNetworkType=function(e){return Object.values(n.NetworkType).includes(e)},n.isInfuraNetworkType=function(e){return Object.keys(n.InfuraNetworkType).includes(e)},function(e){e.Mainnet="mainnet",e.Goerli="goerli",e.Sepolia="sepolia",e.LineaGoerli="linea-goerli",e.LineaSepolia="linea-sepolia",e.LineaMainnet="linea-mainnet",e.Aurora="aurora",e.MegaETHTestnet="megaeth-testnet",e.MonadTestnet="monad-testnet",e.BaseMainnet="base-mainnet"}(s||(n.BuiltInNetworkName=s={})),n.ChainId={[s.Mainnet]:"0x1",[s.Goerli]:"0x5",[s.Sepolia]:"0xaa36a7",[s.Aurora]:"0x4e454152",[s.LineaGoerli]:"0xe704",[s.LineaSepolia]:"0xe705",[s.LineaMainnet]:"0xe708",[s.MegaETHTestnet]:"0x18c6",[s.MonadTestnet]:"0x279f",[s.BaseMainnet]:"0x2105"},function(e){e.mainnet="ETH",e.goerli="GoerliETH",e.sepolia="SepoliaETH",e["linea-goerli"]="LineaETH",e["linea-sepolia"]="LineaETH",e["linea-mainnet"]="ETH",e["megaeth-testnet"]="MegaETH",e["monad-testnet"]="MON",e["base-mainnet"]="ETH",e.rpc=""}(r||(n.NetworksTicker=r={})),n.BlockExplorerUrl={[s.Mainnet]:"https://etherscan.io",[s.Goerli]:"https://goerli.etherscan.io",[s.Sepolia]:"https://sepolia.etherscan.io",[s.LineaGoerli]:"https://goerli.lineascan.build",[s.LineaSepolia]:"https://sepolia.lineascan.build",[s.LineaMainnet]:"https://lineascan.build",[s.MegaETHTestnet]:"https://megaexplorer.xyz",[s.MonadTestnet]:"https://testnet.monadexplorer.com",[s.BaseMainnet]:"https://basescan.org"},n.NetworkNickname={[s.Mainnet]:"Ethereum Mainnet",[s.Goerli]:"Goerli",[s.Sepolia]:"Sepolia",[s.LineaGoerli]:"Linea Goerli",[s.LineaSepolia]:"Linea Sepolia",[s.LineaMainnet]:"Linea",[s.MegaETHTestnet]:"Mega Testnet",[s.MonadTestnet]:"Monad Testnet",[s.BaseMainnet]:"Base Mainnet"}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","@metamask/ethjs-unit":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-unit/lib/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","eth-ens-namehash":"/home/runner/work/metamask-extension/metamask-extension/node_modules/eth-ens-namehash/index.js","fast-deep-equal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-deep-equal/index.js",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.isEqualCaseInsensitive=n.isValidJson=n.isNonEmptyArray=n.isPlainObject=n.convertHexToDecimal=n.query=n.normalizeEnsName=n.timeoutFetch=n.fetchWithErrorHandling=n.handleFetch=n.successfulFetch=n.HttpError=n.isSmartContractCode=n.isValidHexAddress=n.toChecksumHexAddress=n.safelyExecuteWithTimeout=n.safelyExecute=n.toHex=n.fromHex=n.hexToText=n.hexToBN=n.getBuyURL=n.weiHexToGweiDec=n.gweiDecToWEIBN=n.fractionBN=n.BNToHex=n.isSafeChainId=n.isSafeDynamicKey=n.PROTOTYPE_POLLUTION_BLOCKLIST=void 0;const r=e("@metamask/ethjs-unit"),a=e("@metamask/utils"),o=s(e("bn.js")),i=s(e("eth-ens-namehash")),c=s(e("fast-deep-equal")),m=e("lodash"),d=e("./constants.cjs"),u=new Error("timeout");function l(e){return e?new o.default((0,a.remove0x)(e),16):new o.default(0)}n.PROTOTYPE_POLLUTION_BLOCKLIST=["__proto__","constructor","prototype"],n.isSafeDynamicKey=function(e){return"string"==typeof e&&!n.PROTOTYPE_POLLUTION_BLOCKLIST.some(t=>e===t)},n.isSafeChainId=function(e){if(!(0,a.isHexString)(e))return!1;const t=Number.parseInt(e,(0,a.isStrictHexString)(e)?16:10);return Number.isSafeInteger(t)&&t>0&&t<=d.MAX_SAFE_CHAIN_ID},n.BNToHex=function(e){return(0,a.add0x)(e.toString(16))},n.fractionBN=function(e,t,n){const s=new o.default(t),r=new o.default(n);return e.mul(s).div(r)},n.gweiDecToWEIBN=function(e){if(Number.isNaN(e))return new o.default(0);const t=e.toString().split("."),n=t[0]||"0";let s=t[1]||"";if(!s)return(0,r.toWei)(n,"gwei");if(s.length<=9)return(0,r.toWei)(`${n}.${s}`,"gwei");const a=s.slice(9)[0];s=s.slice(0,9);let i=(0,r.toWei)(`${n}.${s}`,"gwei");return Number(a)>=5&&(i=i.add(new o.default(1))),i},n.weiHexToGweiDec=function(e){const t=new o.default((0,a.remove0x)(e),16);return(0,r.fromWei)(t,"gwei")},n.getBuyURL=function(e="1",t,n=5){switch(e){case"1":return`https://buy.coinbase.com/?code=9ec56d01-7e81-5017-930c-513daa27bb6a&amount=${n}&address=${t}&crypto_currency=ETH`;case"5":return"https://goerli-faucet.slock.it/";case"11155111":return"https://sepoliafaucet.net/";default:return undefined}},n.hexToBN=l,n.hexToText=function(e){try{const n=(0,a.remove0x)(e);return t.from(n,"hex").toString("utf8")}catch(t){return e}},n.fromHex=function(e){return o.default.isBN(e)?e:new o.default(l(e).toString(10))},n.toHex=function(e){return"string"==typeof e&&(0,a.isStrictHexString)(e)?e:`0x${o.default.isBN(e)||"bigint"==typeof e?e.toString(16):new o.default(e.toString(),10).toString(16)}`},n.safelyExecute=async function(e,t=!1){try{return await e()}catch(e){return t&&console.error(e),undefined}},n.safelyExecuteWithTimeout=async function(e,t=!1,n=500){try{return await Promise.race([e(),new Promise((e,t)=>setTimeout(()=>{t(u)},n))])}catch(e){return t&&console.error(e),undefined}},n.toChecksumHexAddress=(0,m.memoize)(function(e){if("string"!=typeof e)return e;const t=(0,a.add0x)(e);if(!(0,a.isHexString)(t))return t;try{return(0,a.getChecksumAddress)(t)}catch(e){if(e instanceof Error&&"Invalid hex address."===e.message)return t;throw e}}),n.isValidHexAddress=(0,m.memoize)(function(e,{allowNonPrefixed:t=!0}={}){const n=t?(0,a.add0x)(e):e;return!!(0,a.isStrictHexString)(n)&&(0,a.isHexChecksumAddress)(n)},(e,{allowNonPrefixed:t=!0}={})=>`${e}-${t}`),n.isSmartContractCode=function(e){return!!e&&("0x"!==e&&"0x0"!==e)};class h extends Error{constructor(e,t){super(t||`Fetch failed with status '${e}'`),this.httpStatus=e}}async function p(e,t){const n=await fetch(e,t);if(!n.ok)throw new h(n.status,`Fetch failed with status '${n.status}' for request '${String(e)}'`);return n}async function f(e,t){const n=await p(e,t);return await n.json()}n.HttpError=h,n.successfulFetch=p,n.handleFetch=f,n.fetchWithErrorHandling=async function({url:e,options:t,timeout:n,errorCodesToCatch:s}){let r;try{r=n?Promise.race([await f(e,t),new Promise((e,t)=>setTimeout(()=>{t(u)},n))]):await f(e,t)}catch(e){!function(e,t=[]){if(!e)return;if(!(e instanceof Error))throw e;if(!t.some(t=>e.message.includes(`Fetch failed with status '${t}'`))&&!e.message.includes("Failed to fetch")&&e!==u)throw e;console.error(e)}(e,s)}return r},n.timeoutFetch=async function(e,t,n=500){return Promise.race([p(e,t),new Promise((e,t)=>setTimeout(()=>{t(u)},n))])},n.normalizeEnsName=function(e){if("."===e)return e;if(e&&"string"==typeof e)try{const t=i.default.normalize(e.trim());if(t.match(/^(([\w\d-]+)\.)*[\w\d-]{7,}\.(eth|test)$/u))return t}catch(e){}return null},n.query=function(e,t,n=[]){return new Promise((s,r)=>{const a=(e,t)=>{e?r(e):s(t)};t in e&&"function"==typeof e[t]?e[t](...n,a):e.sendAsync({method:t,params:n},a)})};n.convertHexToDecimal=(e="0x0")=>(0,a.isStrictHexString)(e)?parseInt(e,16):Number(e)?Number(e):0,n.isPlainObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)},n.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},n.isValidJson=function(e){try{return(0,c.default)(e,JSON.parse(JSON.stringify(e)))}catch(e){return!1}},n.isEqualCaseInsensitive=function(e,t){return"string"==typeof e&&"string"==typeof t&&e.toLowerCase()===t.toLowerCase()}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js",{"./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.js","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i,c,m,d=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},u=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},l=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.PollingBlockTracker=void 0;const h=l(e("@metamask/safe-event-emitter")),p=e("@metamask/utils"),f=l(e("json-rpc-random-id")),g=e("./logging-utils"),y=(0,g.createModuleLogger)(g.projectLogger,"polling-block-tracker"),k=(0,f.default)(),b=["sync","latest"];class x extends h.default{constructor(e={}){if(!e.provider)throw new Error("PollingBlockTracker - no provider specified.");super(),s.add(this),r.set(this,[]),a.set(this,void 0),o.set(this,void 0),this._blockResetDuration=e.blockResetDuration||2e4,this._usePastBlocks=e.usePastBlocks||!1,this._currentBlock=null,this._isRunning=!1,this._onNewListener=this._onNewListener.bind(this),this._onRemoveListener=this._onRemoveListener.bind(this),this._resetCurrentBlock=this._resetCurrentBlock.bind(this),this._setupInternalEvents(),this._provider=e.provider,this._pollingInterval=e.pollingInterval||2e4,this._retryTimeout=e.retryTimeout||this._pollingInterval/10,this._keepEventLoopActive=e.keepEventLoopActive===undefined||e.keepEventLoopActive,this._setSkipCacheFlag=e.setSkipCacheFlag||!1}async destroy(){this._cancelBlockResetTimeout(),super.removeAllListeners(),this._maybeEnd()}isRunning(){return this._isRunning}getCurrentBlock(){return this._currentBlock}async getLatestBlock(){if(this._currentBlock)return this._currentBlock;if(d(this,a,"f"))return await d(this,a,"f").promise;const{promise:e,resolve:t,reject:n}=(0,p.createDeferredPromise)({suppressUnhandledRejection:!0});u(this,a,{reject:n,promise:e},"f");try{if(!this._isRunning){const e=await this._fetchLatestBlock();return this._newPotentialLatest(e),t(e),e}const n=e=>{d(this,s,"m",c).call(this,n),this.removeListener("latest",n),t(e)};return d(this,s,"m",i).call(this,n),this.once("latest",n),await e}catch(e){throw n(e),e}finally{u(this,a,undefined,"f")}}removeAllListeners(e){return e?super.removeAllListeners(e):super.removeAllListeners(),this._setupInternalEvents(),this._onRemoveListener(),this}_setupInternalEvents(){this.removeListener("newListener",this._onNewListener),this.removeListener("removeListener",this._onRemoveListener),this.on("newListener",this._onNewListener),this.on("removeListener",this._onRemoveListener)}_onNewListener(e){b.includes(e)&&this._maybeStart()}_onRemoveListener(){this._getBlockTrackerEventCount()>0||this._maybeEnd()}_maybeStart(){this._isRunning||(this._isRunning=!0,this._cancelBlockResetTimeout(),this._start(),this.emit("_started"))}_maybeEnd(){this._isRunning&&(this._isRunning=!1,this._setupBlockResetTimeout(),this._end(),d(this,s,"m",m).call(this,new Error("Block tracker destroyed")),this.emit("_ended"))}_getBlockTrackerEventCount(){return b.map(e=>this.listeners(e)).flat().filter(e=>d(this,r,"f").every(t=>!Object.is(t,e))).length}_shouldUseNewBlock(e){const t=this._currentBlock;if(!t)return!0;const n=w(e),s=w(t);return this._usePastBlocks&&n<s||n>s}_newPotentialLatest(e){this._shouldUseNewBlock(e)&&this._setCurrentBlock(e)}_setCurrentBlock(e){const t=this._currentBlock;this._currentBlock=e,this.emit("latest",e),this.emit("sync",{oldBlock:t,newBlock:e})}_setupBlockResetTimeout(){this._cancelBlockResetTimeout(),this._blockResetTimeout=setTimeout(this._resetCurrentBlock,this._blockResetDuration),this._blockResetTimeout.unref&&this._blockResetTimeout.unref()}_cancelBlockResetTimeout(){this._blockResetTimeout&&clearTimeout(this._blockResetTimeout)}_resetCurrentBlock(){this._currentBlock=null}async checkForLatestBlock(){return await this._updateLatestBlock(),await this.getLatestBlock()}_start(){this._updateAndQueue()}_end(){this._clearPollingTimeout()}async _updateLatestBlock(){const e=await this._fetchLatestBlock();this._newPotentialLatest(e)}async _fetchLatestBlock(){if(d(this,o,"f"))return await d(this,o,"f").promise;const{promise:e,resolve:t,reject:n}=(0,p.createDeferredPromise)({suppressUnhandledRejection:!0});u(this,o,{reject:n,promise:e},"f");try{const e={jsonrpc:"2.0",id:k(),method:"eth_blockNumber",params:[]};this._setSkipCacheFlag&&(e.skipCache=!0),y("Making request",e);const n=await this._provider.request(e);return y("Got result",n),t(n),n}catch(e){throw y("Encountered error fetching block",(0,p.getErrorMessage)(e)),n(e),d(this,s,"m",m).call(this,e),e}finally{u(this,o,undefined,"f")}}async _updateAndQueue(){let e=this._pollingInterval;try{await this._updateLatestBlock()}catch(t){try{this.emit("error",t)}catch(e){console.error(`Error updating latest block: ${(0,p.getErrorMessage)(t)}`)}e=this._retryTimeout}if(!this._isRunning)return;this._clearPollingTimeout();const t=setTimeout(()=>{this._updateAndQueue()},e);t.unref&&!this._keepEventLoopActive&&t.unref(),this._pollingTimeout=t,this.emit("_waitingForNextIteration")}_clearPollingTimeout(){this._pollingTimeout&&(clearTimeout(this._pollingTimeout),this._pollingTimeout=undefined)}}function w(e){return Number.parseInt(e,16)}n.PollingBlockTracker=x,r=new WeakMap,a=new WeakMap,o=new WeakMap,s=new WeakSet,i=function(e){d(this,r,"f").push(e)},c=function(e){d(this,r,"f").splice(d(this,r,"f").indexOf(e),1)},m=function(e){var t;null===(t=d(this,a,"f"))||void 0===t||t.reject(e),u(this,a,undefined,"f")}}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/index.js",{"./BlockTracker":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js","./PollingBlockTracker":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./PollingBlockTracker"),n),r(e("./BlockTracker"),n)}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("eth-block-tracker")}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/logging-utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/key-tree":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/index.cjs","@metamask/scure-bip39":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/index.js","@metamask/scure-bip39/dist/wordlists/english.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/wordlists/english.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/hdkey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/hdkey.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var s,r,a,o,i,c,m,d,u,l,h,p=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},f=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;const g=e("@ethereumjs/util"),y=e("@metamask/eth-sig-util"),k=e("@metamask/key-tree"),b=e("@metamask/scure-bip39"),x=e("@metamask/scure-bip39/dist/wordlists/english.js"),w=e("@metamask/utils"),_=e("ethereum-cryptography/hdkey"),v=e("ethereum-cryptography/keccak"),E="m/44'/60'/0'/0",T="HD Key Tree";class j{constructor(e={}){s.add(this),this.type=T,this.hdPath=E,r.set(this,new Map),a.set(this,void 0),p(this,a,e.cryptographicFunctions,"f")}async generateRandomMnemonic(){await f(this,s,"m",u).call(this,(0,b.generateMnemonic)(x.wordlist))}async serialize(){let e=[];if(this.mnemonic){const t=f(this,s,"m",o).call(this,this.mnemonic);e=Array.from((new TextEncoder).encode(t))}return{mnemonic:e,numberOfAccounts:f(this,r,"f").size,hdPath:this.hdPath}}async deserialize(e){if(e.numberOfAccounts&&!e.mnemonic)throw new Error("Eth-Hd-Keyring: Deserialize method cannot be called with an opts value for numberOfAccounts and no menmonic");if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");f(this,r,"f").clear(),this.mnemonic=null,this.seed=null,this.root=null,this.hdPath=e.hdPath??E,e.mnemonic&&await f(this,s,"m",u).call(this,e.mnemonic),e.numberOfAccounts&&await this.addAccounts(e.numberOfAccounts)}async addAccounts(e=1){if(!this.root)throw new Error("Eth-Hd-Keyring: No secret recovery phrase provided");const t=f(this,r,"f").size,n=[];for(let a=t;a<e+t;a++){const e=this.root.deriveChild(a);(0,w.assert)(e.publicKey,"Expected public key to be set");const t=f(this,s,"m",l).call(this,e.publicKey),o={hdKey:e,address:t};f(this,r,"f").set(t,o),n.push(t)}return Promise.resolve(n)}async getAccounts(){return Array.from(f(this,r,"f").keys())}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const n=f(this,s,"m",d).call(this,e,{withAppKeyOrigin:t});(0,w.assert)(n.publicKey,"Expected public key to be set");return f(this,s,"m",h).call(this,(0,w.bytesToHex)((0,g.publicToAddress)(n.publicKey)))}async exportAccount(e,t){const n=t?f(this,s,"m",d).call(this,e,t):f(this,s,"m",d).call(this,e),{privateKey:r}=n;return(0,w.assert)(r instanceof Uint8Array,"Expected private key to be of type Uint8Array"),(0,w.remove0x)((0,w.bytesToHex)(r))}async signTransaction(e,n,r={}){const a=f(this,s,"m",m).call(this,e,r);return n.sign(t.from(a))??n}async signMessage(e,n,r={}){(0,w.assertIsHexString)(n);const a=(0,w.remove0x)(n),o=f(this,s,"m",m).call(this,e,r),i=(0,g.ecsign)(t.from(a,"hex"),t.from(o));return(0,y.concatSig)(t.from((0,w.bigIntToBytes)(i.v)),t.from(i.r),t.from(i.s))}async signPersonalMessage(e,n,r={}){const a=f(this,s,"m",m).call(this,e,r),o=t.from(a);return(0,y.personalSign)({privateKey:o,data:n})}async decryptMessage(e,n){const r=f(this,s,"m",d).call(this,e),{privateKey:a}=r;(0,w.assert)(a,"Expected private key to be set");const o=t.from(a).toString("hex");return(0,y.decrypt)({privateKey:o,encryptedData:n})}async signTypedData(e,n,r){let{version:a}=r??{version:y.SignTypedDataVersion.V1};a&&Object.keys(y.SignTypedDataVersion).includes(a)||(a=y.SignTypedDataVersion.V1);const o=f(this,s,"m",m).call(this,e,r);return(0,y.signTypedData)({privateKey:t.from(o),data:n,version:a})}async signEip7702Authorization(e,n,r){const a=f(this,s,"m",m).call(this,e,r);return(0,y.signEIP7702Authorization)({privateKey:t.from(a),authorization:n})}removeAccount(e){const t=f(this,s,"m",h).call(this,e);if(!f(this,r,"f").has(t))throw new Error(`Address ${t} not found in this keyring`);f(this,r,"f").delete(t)}async getEncryptionPublicKey(e,t={}){const n=f(this,s,"m",m).call(this,e,t);return(0,y.getEncryptionPublicKey)((0,w.remove0x)((0,w.bytesToHex)(n)))}}n.HdKeyring=j,r=new WeakMap,a=new WeakMap,s=new WeakSet,o=function(e){return Array.from(new Uint16Array(new Uint8Array(e).buffer)).map(e=>x.wordlist[e]).join(" ")},i=function(e){const t=e.split(" ").map(e=>x.wordlist.indexOf(e));return new Uint8Array(new Uint16Array(t).buffer)},c=function(e){let n=e;var r;if("object"==typeof(r=e)&&null!==r&&"type"in r&&"Buffer"===r.type&&"data"in r&&Array.isArray(r.data)&&(n=e.data),"string"==typeof n||t.isBuffer(n)||Array.isArray(n)){let e;return e=Array.isArray(n)?t.from(n).toString():t.isBuffer(n)?n.toString():n,f(this,s,"m",i).call(this,e)}return n instanceof Object&&!(n instanceof Uint8Array)?Uint8Array.from(Object.values(n)):((0,w.assert)(n instanceof Uint8Array,"Expected Uint8Array mnemonic"),n)},m=function(e,t){if(!e)throw new Error("Must specify address.");const n=f(this,s,"m",d).call(this,e,t);return(0,w.assert)(n.privateKey,"Missing private key"),n.privateKey},d=function(e,{withAppKeyOrigin:n}={}){const a=f(this,s,"m",h).call(this,e),o=f(this,r,"f").get(a);if(!o)throw new Error("HD Keyring - Unable to find matching address.");if(n){const{privateKey:e}=o.hdKey;(0,w.assert)(e,"Expected private key to be set");const s=t.from(n,"utf8"),r=t.concat([e,s]),a=t.from((0,v.keccak256)(r));return{privateKey:a,publicKey:t.from((0,g.privateToPublic)(a))}}return o.hdKey},u=async function(e){if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");this.mnemonic=f(this,s,"m",c).call(this,e),this.seed=await(0,k.mnemonicToSeed)(this.mnemonic,"",f(this,a,"f")),this.hdWallet=_.HDKey.fromMasterSeed(this.seed),this.root=this.hdWallet.derive(this.hdPath)},l=function(e){return(0,w.add0x)((0,w.bytesToHex)((0,g.publicToAddress)(t.from(e),!0)).toLowerCase())},h=function(e){const t=(0,y.normalize)(e);return(0,w.assert)(t,"Expected address to be set"),(0,w.add0x)(t)},j.type=T}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/index.cjs",{"./hd-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;var s=e("./hd-keyring.cjs");Object.defineProperty(n,"HdKeyring",{enumerable:!0,get:function(){return s.HdKeyring}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js",{"./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js","./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createInfuraMiddlewareWithoutRpcService=n.createInfuraMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("@metamask/rpc-errors"),a=e("./fetch-config-from-req"),o=e("./logging-utils"),i=(0,o.createModuleLogger)(o.projectLogger,"create-infura-middleware"),c=["Gateway timeout","ETIMEDOUT","ECONNRESET","SyntaxError"];function m({network:e="mainnet",maxAttempts:t=5,source:n,projectId:r,headers:a={}}){if(!r||"string"!=typeof r)throw new Error(`Invalid value for 'projectId': "${r}"`);if(!a||"object"!=typeof a)throw new Error(`Invalid value for 'headers': "${a}"`);if(!t)throw new Error(`Invalid value for 'maxAttempts': "${t}" (${typeof t})`);return(0,s.createAsyncMiddleware)(async(s,o)=>{for(let c=1;c<=t;c++)try{i("Attempting request to Infura. network = %o, projectId = %s, headers = %o, req = %o",e,r,a,s),await d(e,r,a,s,o,n);break}catch(e){if(!l(e))throw i("Non-retriable request error encountered. req = %o, res = %o, error = %o",s,o,e),e;if(!(t-c)){i("Retriable request error encountered, but exceeded max attempts. req = %o, res = %o, error = %o",s,o,e);const t=`InfuraProvider - cannot complete request. All retries exhausted.\nOriginal Error:\n${e.toString()}\n\n`;throw new Error(t)}i("Retriable request error encountered. req = %o, res = %o, error = %o",s,o,e),i("Waiting 1 second to try again..."),await h(1e3)}})}async function d(e,t,n,s,o,i){const{fetchUrl:c,fetchParams:m}=(0,a.fetchConfigFromReq)({network:e,projectId:t,extraHeaders:n,req:s,source:i}),d=await fetch(c,m),l=await d.text();if(!d.ok)switch(d.status){case 405:throw r.rpcErrors.methodNotFound();case 429:throw u("Request is being rate limited.");case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",u(e)}();default:throw u(l)}if("eth_getBlockByNumber"===s.method&&"Not Found"===l)return void(o.result=null);const h=JSON.parse(l);o.result=h.result,o.error=h.error}function u(e){return r.rpcErrors.internal(e)}function l(e){const t=e.toString();return c.some(e=>t.includes(e))}async function h(e){return new Promise(t=>{setTimeout(t,e)})}n.createInfuraMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){const{source:n,headers:r={}}=t;return(0,s.createAsyncMiddleware)(async(t,s)=>{const a=n!==undefined&&t.origin!==undefined?Object.assign(Object.assign({},r),{"Infura-Source":`${n}/${t.origin}`}):r,o=await e.request({id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},{headers:a});"error"in o?s.error=o.error:(s.result=o.result,s.error=undefined)})}(e):m(e)},n.createInfuraMiddlewareWithoutRpcService=m}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","@metamask/eth-json-rpc-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createProvider=void 0;const s=e("@metamask/eth-json-rpc-provider"),r=e("@metamask/json-rpc-engine"),a=e("./create-infura-middleware");n.createProvider=function(e){const t=new r.JsonRpcEngine;return t.push((0,a.createInfuraMiddleware)(e)),(0,s.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){return{id:e.id,jsonrpc:e.jsonrpc,method:e.method,params:e.params}}Object.defineProperty(n,"__esModule",{value:!0}),n.fetchConfigFromReq=void 0,n.fetchConfigFromReq=function({network:e,projectId:t,extraHeaders:n={},req:r,source:a}){const o=r.origin||"internal",i=Object.assign({},n,{Accept:"application/json","Content-Type":"application/json"});return a&&(i["Infura-Source"]=`${a}/${o}`),{fetchUrl:`https://${e}.infura.io/v3/${t}`,fetchParams:{method:"POST",headers:i,body:JSON.stringify(s(r))}}}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/index.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","./create-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js","./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./create-infura-middleware"),n),r(e("./fetch-config-from-req"),n),r(e("./create-provider"),n)}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("eth-json-rpc-infura")}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs",{"./provider-from-engine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs","./provider-from-middleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs","./safe-event-emitter-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.SafeEventEmitterProvider=void 0,r(e("./provider-from-engine.cjs"),n),r(e("./provider-from-middleware.cjs"),n);var a=e("./safe-event-emitter-provider.cjs");Object.defineProperty(n,"SafeEventEmitterProvider",{enumerable:!0,get:function(){return a.SafeEventEmitterProvider}})}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs",{"./safe-event-emitter-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerFromEngine=void 0;const s=e("./safe-event-emitter-provider.cjs");n.providerFromEngine=function(e){return new s.SafeEventEmitterProvider({engine:e})}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs",{"./provider-from-engine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerFromMiddleware=void 0;const s=e("@metamask/json-rpc-engine"),r=e("./provider-from-engine.cjs");n.providerFromMiddleware=function(e){const t=new s.JsonRpcEngine;return t.push(e),(0,r.providerFromEngine)(t)}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},a=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.SafeEventEmitterProvider=n.convertEip1193RequestToJsonRpcRequest=void 0;const i=e("@metamask/rpc-errors"),c=o(e("@metamask/safe-event-emitter")),m=e("uuid");function d(e){const{id:t=(0,m.v4)(),jsonrpc:n="2.0",method:s,params:r}=e;return r?{id:t,jsonrpc:n,method:s,params:r}:{id:t,jsonrpc:n,method:s}}n.convertEip1193RequestToJsonRpcRequest=d;class u extends c.default{constructor({engine:e}){super(),s.set(this,void 0),this.sendAsync=(e,t)=>{const n=d(e);a(this,s,"f").handle(n,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const n=d(e);a(this,s,"f").handle(n,t)},r(this,s,e,"f"),e.on&&e.on("notification",e=>{this.emit("data",null,e)})}async request(e){const t=d(e),n=await a(this,s,"f").handle(t);if("result"in n)return n.result;const r=new i.JsonRpcError(n.error.code,n.error.message,n.error.data);throw"stack"in n.error&&(r.stack=n.error.stack),r}}n.SafeEventEmitterProvider=u,s=new WeakMap}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/device.cjs",{"./qr-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/cjs/index.js","@ethereumjs/tx":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/tx/dist/cjs/index.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@keystonehq/bc-ur-registry-eth":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",hdkey:"/home/runner/work/metamask-extension/metamask-extension/node_modules/hdkey/lib/hdkey.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var s,r,a,o,i,c,m=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},d=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},u=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Device=n.DeviceMode=n.SUPPORTED_UR_TYPE=void 0;const l=e("@ethereumjs/rlp"),h=e("@ethereumjs/tx"),p=e("@ethereumjs/util"),f=e("@keystonehq/bc-ur-registry-eth"),g=e("@metamask/utils"),y=u(e("hdkey")),k=e("uuid"),b=e("./qr-keyring.cjs");var x;n.SUPPORTED_UR_TYPE={CRYPTO_HDKEY:"crypto-hdkey",CRYPTO_ACCOUNT:"crypto-account",ETH_SIGNATURE:"eth-signature"},function(e){e.HD="hd",e.ACCOUNT="account"}(x||(n.DeviceMode=x={}));function w(e){return e instanceof f.CryptoAccount?e.getMasterFingerprint()?.toString("hex"):e.getOrigin()?.getSourceFingerprint()?.toString("hex")}n.Device=class{constructor({requestScan:e,source:t}){s.add(this),r.set(this,void 0),a.set(this,void 0),m(this,r,e,"f"),m(this,a,"string"==typeof t||"cbor"in t?d(this,s,"m",o).call(this,t):t,"f")}addressFromIndex(e){if(d(this,a,"f").keyringMode===x.ACCOUNT){const t=Object.keys(d(this,a,"f").paths)[e];if(!t)throw new Error(`Address not found for index ${e}`);return(0,g.add0x)(t)}const n=`m/${d(this,a,"f").childrenPath.replace("*",e.toString())}`,s=y.default.fromExtendedKey(d(this,a,"f").xpub).derive(n),r=t.from((0,p.publicToAddress)(s.publicKey,!0)).toString("hex"),o=(0,g.getChecksumAddress)((0,g.add0x)(r));return d(this,a,"f").indexes[o]=e,o}pathFromAddress(e){const t=(0,g.getChecksumAddress)((0,g.add0x)(e));if(d(this,a,"f").keyringMode===x.ACCOUNT){const e=d(this,a,"f").paths[t];if(e===undefined)throw new Error(`Unknown address ${t}`);return e}let n=d(this,a,"f").indexes[t];if(n===undefined){for(let e=0;e<1e3;e++){if(this.addressFromIndex(e)===t){n=e;break}}if(n===undefined)throw new Error(`Unknown address ${t}`)}return`${d(this,a,"f").hdPath}/${d(this,a,"f").childrenPath.replace("*",n.toString()).replace(/\*/gu,"0")}`}getAddressesPage(e,t=5){const n=e*t,s=n+t,r=[];for(let e=n;e<s;e++){const t=this.addressFromIndex(e);r.push({address:t,index:e})}return r}getDeviceDetails(){return d(this,a,"f")}async signTransaction(e,n){const r=n.type===h.TransactionType.Legacy?f.DataType.transaction:f.DataType.typedTransaction,o=n.getMessageToSign(),c=t.from(Array.isArray(o)?l.RLP.encode(o):o),m=(0,k.v4)(),u=f.EthSignRequest.constructETHRequest(c,r,this.pathFromAddress(e),d(this,a,"f").xfp,m,Number(n.common.chainId())).toUR(),{r:p,s:g,v:y}=await d(this,s,"m",i).call(this,{requestId:m,payload:{type:u.type,cbor:u.cbor.toString("hex")},requestTitle:"Scan with your hardware wallet",requestDescription:'After your device has signed this message, click on "Scan" to receive the signature'});return h.TransactionFactory.fromTxData({...n.toJSON(),r:p,s:g,v:y},{common:n.common})}async signTypedData(e,n){const r=(0,k.v4)(),o=f.EthSignRequest.constructETHRequest(t.from(JSON.stringify(n),"utf8"),f.DataType.typedData,this.pathFromAddress(e),d(this,a,"f").xfp,r,undefined,e).toUR(),{r:c,s:m,v:u}=await d(this,s,"m",i).call(this,{requestId:r,payload:{type:o.type,cbor:o.cbor.toString("hex")}});return(0,g.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(m),Uint8Array.from(u)]).toString("hex"))}async signPersonalMessage(e,n){const r=(0,k.v4)(),o=f.EthSignRequest.constructETHRequest(t.from((0,g.remove0x)(n),"hex"),f.DataType.personalMessage,this.pathFromAddress(e),d(this,a,"f").xfp,r,undefined,e).toUR(),{r:c,s:m,v:u}=await d(this,s,"m",i).call(this,{requestId:r,payload:{type:o.type,cbor:o.cbor.toString("hex")}});return(0,g.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(m),Uint8Array.from(u)]).toString("hex"))}},r=new WeakMap,a=new WeakMap,s=new WeakSet,o=function(e){const n=d(this,s,"m",c).call(this,e),r=w(n);if(n instanceof f.CryptoAccount){const{name:e,xfp:s,paths:r,keyringAccount:a}=function(e){const n=e.getOutputDescriptors();if(!n||0===n.length)throw new Error("No output descriptors found in CryptoAccount");let s="",r="";return{paths:n.reduce((e,n)=>{const a=n.getHDKey();if(a){const n=`M/${a.getOrigin().getPath()}`;e[(0,g.getChecksumAddress)((0,g.add0x)(t.from((0,p.publicToAddress)(a.getKey(),!0)).toString("hex")))]=n,s=a.getName(),r=a.getNote()}return e},{}),name:s,keyringAccount:r,xfp:w(e)}}(n);return{keyringMode:x.ACCOUNT,keyringAccount:a,name:e,xfp:s,paths:r,indexes:{}}}const{getBip32Key:a,getOrigin:o,getChildren:i,getName:m,getNote:u}=n;return{keyringMode:x.HD,keyringAccount:u(),name:m(),xfp:r,hdPath:`m/${o().getPath()}`,childrenPath:i()?.getPath()||"0/*",xpub:a(),indexes:{}}},i=async function(e){const n=await d(this,r,"f").call(this,{type:b.QrScanRequestType.SIGN,request:e}),s=f.ETHSignature.fromCBOR(t.from(n.cbor,"hex")),a=s.getSignature(),o=s.getRequestId();if(!o)throw new Error("Signature request ID is missing.");if(e.requestId!==(0,k.stringify)(o))throw new Error(`Signature request ID mismatch. Expected: ${e.requestId}, received: ${o.toString("hex")}`);return{r:a.subarray(0,32),s:a.subarray(32,64),v:a.subarray(64)}},c=function(e){const s="string"==typeof e?f.URRegistryDecoder.decode(e):{type:e.type,cbor:t.from(e.cbor,"hex")},{type:r,cbor:a}=s;switch(r){case n.SUPPORTED_UR_TYPE.CRYPTO_HDKEY:return f.CryptoHDKey.fromCBOR(a);case n.SUPPORTED_UR_TYPE.CRYPTO_ACCOUNT:return f.CryptoAccount.fromCBOR(a);default:throw new Error("Unsupported UR type")}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/device.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/index.cjs",{"./qr-keyring-deferred-promise-bridge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs","./qr-keyring-scanner-bridge.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs","./qr-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.QrScanRequestType=n.QR_KEYRING_TYPE=n.QrKeyring=n.QrKeyringDeferredPromiseBridge=n.QrKeyringScannerBridge=void 0;var s=e("./qr-keyring-scanner-bridge.cjs");Object.defineProperty(n,"QrKeyringScannerBridge",{enumerable:!0,get:function(){return s.QrKeyringScannerBridge}});var r=e("./qr-keyring-deferred-promise-bridge.cjs");Object.defineProperty(n,"QrKeyringDeferredPromiseBridge",{enumerable:!0,get:function(){return r.QrKeyringDeferredPromiseBridge}});var a=e("./qr-keyring.cjs");Object.defineProperty(n,"QrKeyring",{enumerable:!0,get:function(){return a.QrKeyring}}),Object.defineProperty(n,"QR_KEYRING_TYPE",{enumerable:!0,get:function(){return a.QR_KEYRING_TYPE}}),Object.defineProperty(n,"QrScanRequestType",{enumerable:!0,get:function(){return a.QrScanRequestType}})}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","async-mutex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/async-mutex/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i,c=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},m=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyringDeferredPromiseBridge=void 0;const d=e("@metamask/utils"),u=e("async-mutex");n.QrKeyringDeferredPromiseBridge=class{constructor({onScanRequested:e,onScanResolved:t,onScanRejected:n}={}){s.set(this,new u.Mutex),r.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),c(this,r,e,"f"),c(this,a,t,"f"),c(this,o,n,"f")}async requestScan(e){return m(this,s,"f").runExclusive(async()=>{const t=(0,d.createDeferredPromise)();return c(this,i,t,"f"),m(this,r,"f")?.call(this,e),t.promise})}resolvePendingScan(e){if(!m(this,i,"f"))throw new Error("No pending scan to resolve.");m(this,i,"f").resolve(e),c(this,i,null,"f"),m(this,a,"f")?.call(this,e)}rejectPendingScan(e){if(!m(this,i,"f"))throw new Error("No pending scan to reject.");m(this,i,"f").reject(e),c(this,i,null,"f"),m(this,o,"f")?.call(this,e)}},s=new WeakMap,r=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},a=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyringScannerBridge=void 0;n.QrKeyringScannerBridge=class{constructor({requestScan:e}){s.set(this,void 0),r(this,s,e,"f")}async requestScan(e){return a(this,s,"f").call(this,e)}},s=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs",{"./device.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/dist/device.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i,c,m=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},d=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyring=n.getDefaultSerializedQrKeyringState=n.QrScanRequestType=n.QR_KEYRING_TYPE=void 0;const u=e("@metamask/utils"),l=e("./device.cjs");var h;n.QR_KEYRING_TYPE="QR Hardware Wallet Device",function(e){e.PAIR="pair",e.SIGN="sign"}(h||(n.QrScanRequestType=h={}));function p(e){return(0,u.getChecksumAddress)((0,u.add0x)(e))}n.getDefaultSerializedQrKeyringState=()=>({initialized:!1,accounts:[]});class f{constructor(e){s.add(this),this.type=n.QR_KEYRING_TYPE,r.set(this,void 0),a.set(this,[]),o.set(this,void 0),i.set(this,0),this.bridge=e.bridge,e?.ur&&this.pairDevice(e.ur)}async serialize(){const e=m(this,r,"f")?m(this,r,"f").getDeviceDetails():undefined;return e&&[l.DeviceMode.HD,l.DeviceMode.ACCOUNT].includes(e.keyringMode)?{...e,initialized:!0,accounts:m(this,a,"f").slice()}:(0,n.getDefaultSerializedQrKeyringState)()}async deserialize(e){if(!e.initialized)return d(this,a,[],"f"),void d(this,r,undefined,"f");d(this,r,new l.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f"),d(this,a,(e.accounts??[]).map(p),"f")}async addAccounts(e){if(!m(this,r,"f"))throw new Error("No device paired.");const t=[];for(let n=0;n<e;n++){const e=m(this,o,"f")??m(this,a,"f").length+n,s=m(this,r,"f").addressFromIndex(e);this.setAccountToUnlock(e+1),m(this,a,"f").includes(s)||(m(this,a,"f").push(s),t.push(s))}return t}async getAccounts(){return m(this,a,"f").slice()}removeAccount(e){const t=p(e);d(this,a,m(this,a,"f").filter(e=>e!==t),"f")}pairDevice(e){d(this,r,new l.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f")}setAccountToUnlock(e){d(this,o,e,"f")}getName(){if(!m(this,r,"f"))return n.QR_KEYRING_TYPE;return m(this,r,"f").getDeviceDetails().name}async getFirstPage(){return d(this,i,0,"f"),this.getCurrentPage()}async getNextPage(){return d(this,i,m(this,i,"f")+1,"f"),this.getCurrentPage()}async getPreviousPage(){return m(this,i,"f")>0?d(this,i,m(this,i,"f")-1,"f"):d(this,i,0,"f"),this.getCurrentPage()}async getCurrentPage(){return m(this,r,"f")||await m(this,s,"m",c).call(this),(0,u.assert)(m(this,r,"f"),"A device is expected to be paired before fetching accounts."),m(this,r,"f").getAddressesPage(m(this,i,"f"))}async forgetDevice(){d(this,r,undefined,"f"),d(this,a,[],"f"),d(this,o,undefined,"f"),d(this,i,0,"f")}async signTransaction(e,t){if(!m(this,r,"f"))throw new Error("No device paired.");return m(this,r,"f").signTransaction(e,t)}async signTypedData(e,t){if(!m(this,r,"f"))throw new Error("No device paired.");return m(this,r,"f").signTypedData(e,t)}async signPersonalMessage(e,t){if(!m(this,r,"f"))throw new Error("No device paired.");return m(this,r,"f").signPersonalMessage(e,t)}}n.QrKeyring=f,r=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,s=new WeakSet,c=async function(){this.pairDevice(await this.bridge.requestScan({type:h.PAIR}))},f.type=n.QR_KEYRING_TYPE}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.development.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js","@keystonehq/bc-ur-registry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",hdkey:"/home/runner/work/metamask-extension/metamask-extension/node_modules/hdkey/lib/hdkey.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0});var s,r=e("@keystonehq/bc-ur-registry"),a=e("uuid"),o=(s=e("hdkey"))&&"object"==typeof s&&"default"in s?s.default:s,i=e("@ethereumjs/util");const c={ETH_SIGN_REQUEST:new r.RegistryType("eth-sign-request",401),ETH_SIGNATURE:new r.RegistryType("eth-signature",402),ETH_NFT_ITEM:new r.RegistryType("eth-nft-item",403)},{decodeToDataItem:m,RegistryTypes:d}=r.extend;var u,l;!function(e){e[e.requestId=1]="requestId",e[e.signData=2]="signData",e[e.dataType=3]="dataType",e[e.chainId=4]="chainId",e[e.derivationPath=5]="derivationPath",e[e.address=6]="address",e[e.origin=7]="origin"}(u||(u={})),(l=n.DataType||(n.DataType={}))[l.transaction=1]="transaction",l[l.typedData=2]="typedData",l[l.personalMessage=3]="personalMessage",l[l.typedTransaction=4]="typedTransaction";class h extends r.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_SIGN_REQUEST,this.getRequestId=()=>this.requestId,this.getSignData=()=>this.signData,this.getDataType=()=>this.dataType,this.getChainId=()=>this.chainId,this.getDerivationPath=()=>this.derivationPath.getPath(),this.getSourceFingerprint=()=>this.derivationPath.getSourceFingerprint(),this.getSignRequestAddress=()=>this.address,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};this.requestId&&(e[u.requestId]=new r.DataItem(this.requestId,d.UUID.getTag())),this.address&&(e[u.address]=this.address),this.chainId&&(e[u.chainId]=Number(this.chainId)),this.origin&&(e[u.origin]=this.origin),e[u.signData]=this.signData,e[u.dataType]=this.dataType;const t=this.derivationPath.toDataItem();return t.setTag(this.derivationPath.getRegistryType().getTag()),e[u.derivationPath]=t,new r.DataItem(e)},this.requestId=e.requestId,this.signData=e.signData,this.dataType=e.dataType,this.chainId=e.chainId,this.derivationPath=e.derivationPath,this.address=e.address,this.origin=e.origin}static constructETHRequest(e,n,s,o,i,c,m,d){const u=s.replace(/[m|M]\//,"").split("/"),l=new r.CryptoKeypath(u.map(e=>{const t=parseInt(e.replace("'",""));let n=!1;return e.endsWith("'")&&(n=!0),new r.PathComponent({index:t,hardened:n})}),t.from(o,"hex"));return new h({requestId:i?t.from(a.parse(i)):undefined,signData:e,dataType:n,derivationPath:l,chainId:c,address:m?t.from(m.replace("0x",""),"hex"):undefined,origin:d||undefined})}}h.fromDataItem=e=>{const t=e.getData(),n=t[u.signData],s=t[u.dataType],a=r.CryptoKeypath.fromDataItem(t[u.derivationPath]),o=t[u.chainId]?t[u.chainId]:undefined,i=t[u.address]?t[u.address]:undefined,c=t[u.requestId]?t[u.requestId].getData():undefined,m=t[u.origin]?t[u.origin]:undefined;return new h({requestId:c,signData:n,dataType:s,chainId:o,derivationPath:a,address:i,origin:m})},h.fromCBOR=e=>{const t=m(e);return h.fromDataItem(t)};const{RegistryTypes:p,decodeToDataItem:f}=r.extend;var g;!function(e){e[e.requestId=1]="requestId",e[e.signature=2]="signature",e[e.origin=3]="origin"}(g||(g={}));class y extends r.RegistryItem{constructor(e,t,n){super(),this.getRegistryType=()=>c.ETH_SIGNATURE,this.getRequestId=()=>this.requestId,this.getSignature=()=>this.signature,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};return this.requestId&&(e[g.requestId]=new r.DataItem(this.requestId,p.UUID.getTag())),this.origin&&(e[g.origin]=this.origin),e[g.signature]=this.signature,new r.DataItem(e)},this.signature=e,this.requestId=t,this.origin=n}}y.fromDataItem=e=>{const t=e.getData(),n=t[g.signature],s=t[g.requestId]?t[g.requestId].getData():undefined;return new y(n,s,t[g.origin])},y.fromCBOR=e=>{const t=f(e);return y.fromDataItem(t)};const{decodeToDataItem:k}=r.extend;var b;!function(e){e[e.chainId=1]="chainId",e[e.contractAddress=2]="contractAddress",e[e.contractName=3]="contractName",e[e.name=4]="name",e[e.mediaData=5]="mediaData"}(b||(b={}));class x extends r.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_NFT_ITEM,this.getChainId=()=>this.chainId,this.getName=()=>this.name,this.getmediaData=()=>this.mediaData,this.getContractAddress=()=>this.contractAddress,this.getContractName=()=>this.contractName,this.toDataItem=()=>{const e={};return e[b.chainId]=this.chainId,e[b.name]=this.name,e[b.contractAddress]=this.contractAddress,e[b.contractName]=this.contractName,e[b.mediaData]=this.mediaData,new r.DataItem(e)},this.chainId=e.chainId,this.name=e.name,this.contractAddress=e.contractAddress,this.contractName=e.contractName,this.mediaData=e.mediaData}static constructETHNFTItem(e,t,n,s,r){return new x({chainId:e,contractAddress:t,contractName:n,mediaData:r,name:s})}}x.fromDataItem=e=>{const t=e.getData(),n=t[b.chainId],s=t[b.name],r=t[b.mediaData],a=t[b.contractAddress],o=t[b.contractName];return new x({chainId:n,name:s,contractAddress:a,contractName:o,mediaData:r})},x.fromCBOR=e=>{const t=k(e);return x.fromDataItem(t)};const w=(e,t)=>{const n=o.fromExtendedKey(e).derive(t),s="0x"+i.publicToAddress(n.publicKey,!0).toString("hex");return i.toChecksumAddress(s)};r.patchTags(Object.values(c).filter(e=>!!e.getTag()).map(e=>e.getTag())),Object.keys(r).forEach(function(e){"default"!==e&&Object.defineProperty(n,e,{enumerable:!0,get:function(){return r[e]}})}),n.ETHNFTItem=x,n.ETHSignature=y,n.EthSignRequest=h,n.findHDPathFromAddress=(e,t,n,s)=>{for(let r=0;r<n;r++){const n=w(t,`M/0/${r}`);if(e.toLowerCase()==n.toLowerCase())return`${s}/0/${r}`}return null},n.generateAddressFromXpub=w}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.development.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.production.min.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js","@keystonehq/bc-ur-registry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",hdkey:"/home/runner/work/metamask-extension/metamask-extension/node_modules/hdkey/lib/hdkey.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0});var s,r=e("@keystonehq/bc-ur-registry"),a=e("uuid"),o=(s=e("hdkey"))&&"object"==typeof s&&"default"in s?s.default:s,i=e("@ethereumjs/util");const c={ETH_SIGN_REQUEST:new r.RegistryType("eth-sign-request",401),ETH_SIGNATURE:new r.RegistryType("eth-signature",402),ETH_NFT_ITEM:new r.RegistryType("eth-nft-item",403)},{decodeToDataItem:m,RegistryTypes:d}=r.extend;var u,l;!function(e){e[e.requestId=1]="requestId",e[e.signData=2]="signData",e[e.dataType=3]="dataType",e[e.chainId=4]="chainId",e[e.derivationPath=5]="derivationPath",e[e.address=6]="address",e[e.origin=7]="origin"}(u||(u={})),(l=n.DataType||(n.DataType={}))[l.transaction=1]="transaction",l[l.typedData=2]="typedData",l[l.personalMessage=3]="personalMessage",l[l.typedTransaction=4]="typedTransaction";class h extends r.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_SIGN_REQUEST,this.getRequestId=()=>this.requestId,this.getSignData=()=>this.signData,this.getDataType=()=>this.dataType,this.getChainId=()=>this.chainId,this.getDerivationPath=()=>this.derivationPath.getPath(),this.getSourceFingerprint=()=>this.derivationPath.getSourceFingerprint(),this.getSignRequestAddress=()=>this.address,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};this.requestId&&(e[u.requestId]=new r.DataItem(this.requestId,d.UUID.getTag())),this.address&&(e[u.address]=this.address),this.chainId&&(e[u.chainId]=Number(this.chainId)),this.origin&&(e[u.origin]=this.origin),e[u.signData]=this.signData,e[u.dataType]=this.dataType;const t=this.derivationPath.toDataItem();return t.setTag(this.derivationPath.getRegistryType().getTag()),e[u.derivationPath]=t,new r.DataItem(e)},this.requestId=e.requestId,this.signData=e.signData,this.dataType=e.dataType,this.chainId=e.chainId,this.derivationPath=e.derivationPath,this.address=e.address,this.origin=e.origin}static constructETHRequest(e,n,s,o,i,c,m,d){const u=s.replace(/[m|M]\//,"").split("/"),l=new r.CryptoKeypath(u.map(e=>{const t=parseInt(e.replace("'",""));let n=!1;return e.endsWith("'")&&(n=!0),new r.PathComponent({index:t,hardened:n})}),t.from(o,"hex"));return new h({requestId:i?t.from(a.parse(i)):void 0,signData:e,dataType:n,derivationPath:l,chainId:c,address:m?t.from(m.replace("0x",""),"hex"):void 0,origin:d||void 0})}}h.fromDataItem=e=>{const t=e.getData(),n=t[u.signData],s=t[u.dataType],a=r.CryptoKeypath.fromDataItem(t[u.derivationPath]),o=t[u.chainId]?t[u.chainId]:void 0,i=t[u.address]?t[u.address]:void 0,c=t[u.requestId]?t[u.requestId].getData():void 0;return new h({requestId:c,signData:n,dataType:s,chainId:o,derivationPath:a,address:i,origin:t[u.origin]?t[u.origin]:void 0})},h.fromCBOR=e=>{const t=m(e);return h.fromDataItem(t)};const{RegistryTypes:p,decodeToDataItem:f}=r.extend;var g;!function(e){e[e.requestId=1]="requestId",e[e.signature=2]="signature",e[e.origin=3]="origin"}(g||(g={}));class y extends r.RegistryItem{constructor(e,t,n){super(),this.getRegistryType=()=>c.ETH_SIGNATURE,this.getRequestId=()=>this.requestId,this.getSignature=()=>this.signature,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};return this.requestId&&(e[g.requestId]=new r.DataItem(this.requestId,p.UUID.getTag())),this.origin&&(e[g.origin]=this.origin),e[g.signature]=this.signature,new r.DataItem(e)},this.signature=e,this.requestId=t,this.origin=n}}y.fromDataItem=e=>{const t=e.getData(),n=t[g.signature],s=t[g.requestId]?t[g.requestId].getData():void 0;return new y(n,s,t[g.origin])},y.fromCBOR=e=>{const t=f(e);return y.fromDataItem(t)};const{decodeToDataItem:k}=r.extend;var b;!function(e){e[e.chainId=1]="chainId",e[e.contractAddress=2]="contractAddress",e[e.contractName=3]="contractName",e[e.name=4]="name",e[e.mediaData=5]="mediaData"}(b||(b={}));class x extends r.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_NFT_ITEM,this.getChainId=()=>this.chainId,this.getName=()=>this.name,this.getmediaData=()=>this.mediaData,this.getContractAddress=()=>this.contractAddress,this.getContractName=()=>this.contractName,this.toDataItem=()=>{const e={};return e[b.chainId]=this.chainId,e[b.name]=this.name,e[b.contractAddress]=this.contractAddress,e[b.contractName]=this.contractName,e[b.mediaData]=this.mediaData,new r.DataItem(e)},this.chainId=e.chainId,this.name=e.name,this.contractAddress=e.contractAddress,this.contractName=e.contractName,this.mediaData=e.mediaData}static constructETHNFTItem(e,t,n,s,r){return new x({chainId:e,contractAddress:t,contractName:n,mediaData:r,name:s})}}x.fromDataItem=e=>{const t=e.getData();return new x({chainId:t[b.chainId],name:t[b.name],contractAddress:t[b.contractAddress],contractName:t[b.contractName],mediaData:t[b.mediaData]})},x.fromCBOR=e=>{const t=k(e);return x.fromDataItem(t)};const w=(e,t)=>{const n=o.fromExtendedKey(e).derive(t),s="0x"+i.publicToAddress(n.publicKey,!0).toString("hex");return i.toChecksumAddress(s)};r.patchTags(Object.values(c).filter(e=>!!e.getTag()).map(e=>e.getTag())),Object.keys(r).forEach(function(e){"default"!==e&&Object.defineProperty(n,e,{enumerable:!0,get:function(){return r[e]}})}),n.ETHNFTItem=x,n.ETHSignature=y,n.EthSignRequest=h,n.findHDPathFromAddress=(e,t,n,s)=>{for(let r=0;r<n;r++){const n=w(t,"M/0/"+r);if(e.toLowerCase()==n.toLowerCase())return`${s}/0/${r}`}return null},n.generateAddressFromXpub=w}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.production.min.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/index.js",{"./bc-ur-registry-eth.cjs.development.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.development.js","./bc-ur-registry-eth.cjs.production.min.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.production.min.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./bc-ur-registry-eth.cjs.production.min.js")}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/rlp/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){if(Array.isArray(e)){const t=[];let n=0;for(let r=0;r<e.length;r++){const a=s(e[r]);t.push(a),n+=a.length}return h(o(n,192),...t)}const t=y(e);return 1===t.length&&t[0]<128?t:h(o(t.length,128),t)}function r(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function a(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return u(d(e))}function o(e,t){if(e<56)return Uint8Array.from([e+t]);const n=f(e),s=f(t+55+n.length/2);return Uint8Array.from(l(s+n))}function i(e,t=!1){if(null==e||0===e.length)return Uint8Array.from([]);const n=c(y(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function c(e){let t,n,s,o,i;const m=[],d=e[0];if(d<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(d<=183){if(t=d-127,s=128===d?Uint8Array.from([]):r(e,1,t),2===t&&s[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:s,remainder:e.slice(t)}}if(d<=191){if(n=d-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=a(r(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return s=r(e,n,t+n),{data:s,remainder:e.slice(t+n)}}if(d<=247){for(t=d-191,o=r(e,1,t);o.length;)i=c(o),m.push(i.data),o=i.remainder;return{data:m,remainder:e.slice(t)}}{if(n=d-246,t=a(r(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const s=n+t;if(s>e.length)throw new Error("invalid RLP: total length is larger than the data");for(o=r(e,n,s);o.length;)i=c(o),m.push(i.data),o=i.remainder;return{data:m,remainder:e.slice(s)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.RLP=n.utils=n.decode=n.encode=void 0,n.encode=s,n.decode=i;const m=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function d(e){let t="";for(let n=0;n<e.length;n++)t+=m[e[n]];return t}function u(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function l(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const s=2*n;t[n]=u(e.slice(s,s+2))}return t}function h(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,s=0;t<e.length;t++){const r=e[t];n.set(r,s),s+=r.length}return n}function p(e){return(new TextEncoder).encode(e)}function f(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function g(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function y(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return g(e)?l((t="string"!=typeof(n=e)?n:g(n)?n.slice(2):n).length%2?`0${t}`:t):p(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?l(f(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:d,concatBytes:h,hexToBytes:l,utf8ToBytes:p},n.RLP={encode:s,decode:i}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util>@ethereumjs/rlp",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/rlp/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.accountBodyToRLP=n.accountBodyToSlim=n.accountBodyFromSlim=n.isZeroAddress=n.zeroAddress=n.importPublic=n.privateToAddress=n.privateToPublic=n.publicToAddress=n.pubToAddress=n.isValidPublic=n.isValidPrivate=n.generateAddress2=n.generateAddress=n.isValidChecksumAddress=n.toChecksumAddress=n.isValidAddress=n.Account=void 0;const s=e("@ethereumjs/rlp"),r=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),m=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,n=c.KECCAK256_RLP,s=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=n,this.codeHash=s,this._validate()}static fromAccountData(e){const{nonce:t,balance:n,storageRoot:s,codeHash:r}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,n!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(n)):undefined,s!==undefined?(0,i.toBuffer)(s):undefined,r!==undefined?(0,i.toBuffer)(r):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(s.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,n,s,r]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(n),s,r)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(s.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(c.KECCAK256_NULL)}}n.Account=l;n.isValidAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};n.toChecksumAddress=function(e,n){(0,m.assertIsHexString)(e);const s=(0,d.stripHexPrefix)(e).toLowerCase();let a="";if(n!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(n)).toString()+"0x"}const c=t.from(a+s,"utf8"),u=(0,o.bytesToHex)((0,r.keccak256)(c));let l="0x";for(let e=0;e<s.length;e++)parseInt(u[e],16)>=8?l+=s[e].toUpperCase():l+=s[e];return l};n.isValidChecksumAddress=function(e,t){return(0,n.isValidAddress)(e)&&(0,n.toChecksumAddress)(e,t)===e};n.generateAddress=function(e,n){return(0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,i.bufferToBigInt)(n)===BigInt(0)?t.from((0,r.keccak256)(s.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,r.keccak256)(s.RLP.encode((0,i.bufArrToArr)([e,n])))).slice(-20)};n.generateAddress2=function(e,n,s){if((0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,m.assertIsBuffer)(s),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==n.length)throw new Error("Expected salt to be of length 32");const a=(0,r.keccak256)(t.concat([t.from("ff","hex"),e,n,(0,r.keccak256)(s)]));return(0,i.toBuffer)(a).slice(-20)};n.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};n.isValidPublic=function(e,n=!1){if((0,m.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!n)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};n.pubToAddress=function(e,n=!1){if((0,m.assertIsBuffer)(e),n&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,r.keccak256)(e)).slice(-20)},n.publicToAddress=n.pubToAddress;n.privateToPublic=function(e){return(0,m.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};n.privateToAddress=function(e){return(0,n.publicToAddress)((0,n.privateToPublic)(e))};n.importPublic=function(e){return(0,m.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};n.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function h(e){const[t,n,s,r]=e;return[t,n,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_RLP:s,0===(0,i.arrToBufArr)(r).length?c.KECCAK256_NULL:r]}n.isZeroAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return(0,n.zeroAddress)()===e},n.accountBodyFromSlim=h;const p=new Uint8Array(0);n.accountBodyToSlim=function(e){const[t,n,s,r]=e;return[t,n,(0,i.arrToBufArr)(s).equals(c.KECCAK256_RLP)?p:s,(0,i.arrToBufArr)(r).equals(c.KECCAK256_NULL)?p:r]},n.accountBodyToRLP=function(e,t=!0){const n=t?h(e):e;return(0,i.arrToBufArr)(s.RLP.encode(n))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Address=void 0;const s=e("./account"),r=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,r.zeros)(20))}static fromString(e){if(!(0,s.isValidAddress)(e))throw new Error("Invalid address");return new a((0,r.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const n=(0,s.pubToAddress)(e);return new a(n)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const n=(0,s.privateToAddress)(e);return new a(n)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,s.generateAddress)(e.buf,(0,r.bigIntToBuffer)(t)))}static generate2(e,n,r){if(!t.isBuffer(n))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(r))throw new Error("Expected initCode to be a Buffer");return new a((0,s.generateAddress2)(e.buf,n,r))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,r.bufferToBigInt)(this.buf),t=BigInt(0),n=BigInt("0xffff");return e>=t&&e<=n}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}n.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncEventEmitter=void 0;const s=e("events");class r extends s.EventEmitter{emit(e,...t){let[n,s]=t;const r=this;let a=r._events[e]??[];return s===undefined&&"function"==typeof n&&(s=n,n=undefined),"newListener"!==e&&"removeListener"!==e||(n={event:n,fn:s},s=undefined),a=Array.isArray(a)?a:[a],async function(e,t,n){let s;for await(const r of t)try{r.length<2?r.call(e,n):await new Promise((t,s)=>{r.call(e,n,e=>{e?s(e):t()})})}catch(e){s=e}if(s)throw s}(r,a.slice(),n).then(s).catch(s),r.listenerCount(e)>0}once(e,t){const n=this;let s;if("function"!=typeof t)throw new TypeError("listener must be a function");return s=t.length>=2?function(r,a){n.removeListener(e,s),t(r,a)}:function(r){n.removeListener(e,s),t(r,s)},n.on(e,s),n}first(e,t){let n=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(n)||(this._events[e]=n=[n]),n.unshift(t),this}before(e,t,n){return this.beforeOrAfter(e,t,n)}after(e,t,n){return this.beforeOrAfter(e,t,n,"after")}beforeOrAfter(e,t,n,s){let r,a,o=this._events[e]??[];const i="after"===s?1:0;if("function"!=typeof n)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,r=o.length;r--;)if(o[r]===t){a=r+i;break}return o.splice(a,0,n),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}n.AsyncEventEmitter=r}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.intToUnpaddedBuffer=n.bigIntToUnpaddedBuffer=n.bigIntToHex=n.bufArrToArr=n.arrToBufArr=n.validateNoLeadingZeroes=n.baToJSON=n.toUtf8=n.short=n.addHexPrefix=n.toUnsigned=n.fromSigned=n.bufferToInt=n.bigIntToBuffer=n.bufferToBigInt=n.bufferToHex=n.toBuffer=n.unpadHexString=n.unpadArray=n.unpadBuffer=n.setLengthRight=n.setLengthLeft=n.zeros=n.intToBuffer=n.intToHex=void 0;const s=e("./helpers"),r=e("./internal");n.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};n.intToBuffer=function(e){const s=(0,n.intToHex)(e);return t.from((0,r.padToEven)(s.slice(2)),"hex")};n.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,s){const r=(0,n.zeros)(t);return s?e.length<t?(e.copy(r),r):e.slice(0,t):e.length<t?(e.copy(r,t-e.length),r):e.slice(-t)};n.setLengthLeft=function(e,t){return(0,s.assertIsBuffer)(e),a(e,t,!1)};n.setLengthRight=function(e,t){return(0,s.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};n.unpadBuffer=function(e){return(0,s.assertIsBuffer)(e),o(e)};n.unpadArray=function(e){return(0,s.assertIsArray)(e),o(e)};n.unpadHexString=function(e){return(0,s.assertIsHexString)(e),e=(0,r.stripHexPrefix)(e),"0x"+o(e)};n.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,r.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,r.padToEven)((0,r.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,n.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let n=e.toString(16);return n.length%2&&(n="0"+n),t.from(n,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,n.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,n.toBuffer)("0x"+e.toString(16))}n.bufferToHex=function(e){return"0x"+(e=(0,n.toBuffer)(e)).toString("hex")},n.bufferToBigInt=i,n.bigIntToBuffer=c;n.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};n.fromSigned=function(e){return BigInt.asIntN(256,i(e))};n.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};n.addHexPrefix=function(e){return"string"!=typeof e||(0,r.isHexPrefixed)(e)?e:"0x"+e},n.short=function(e,n=50){const s=t.isBuffer(e)?e.toString("hex"):e;return s.length<=n?s:s.slice(0,n)+"…"};n.toUtf8=function(e){if((e=(0,r.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};n.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let s=0;s<e.length;s++)t.push((0,n.baToJSON)(e[s]));return t}};n.validateNoLeadingZeroes=function(e){for(const[t,n]of Object.entries(e))if(n!==undefined&&n.length>0&&0===n[0])throw new Error(`${t} cannot have leading zeroes, received: ${n.toString("hex")}`)},n.arrToBufArr=function e(n){return Array.isArray(n)?n.map(t=>e(t)):t.from(n)},n.bufArrToArr=function e(t){return Array.isArray(t)?t.map(t=>e(t)):Uint8Array.from(t??[])};n.bigIntToHex=e=>"0x"+e.toString(16),n.bigIntToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)(c(e))},n.intToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)((0,n.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAX_WITHDRAWALS_PER_PAYLOAD=n.RLP_EMPTY_STRING=n.KECCAK256_RLP=n.KECCAK256_RLP_S=n.KECCAK256_RLP_ARRAY=n.KECCAK256_RLP_ARRAY_S=n.KECCAK256_NULL=n.KECCAK256_NULL_S=n.TWO_POW256=n.SECP256K1_ORDER_DIV_2=n.SECP256K1_ORDER=n.MAX_INTEGER_BIGINT=n.MAX_INTEGER=n.MAX_UINT64=void 0;const s=e("buffer"),r=e("ethereum-cryptography/secp256k1");n.MAX_UINT64=BigInt("0xffffffffffffffff"),n.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),n.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),n.SECP256K1_ORDER=r.secp256k1.CURVE.n,n.SECP256K1_ORDER_DIV_2=r.secp256k1.CURVE.n/BigInt(2),n.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),n.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",n.KECCAK256_NULL=s.Buffer.from(n.KECCAK256_NULL_S,"hex"),n.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",n.KECCAK256_RLP_ARRAY=s.Buffer.from(n.KECCAK256_RLP_ARRAY_S,"hex"),n.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",n.KECCAK256_RLP=s.Buffer.from(n.KECCAK256_RLP_S,"hex"),n.RLP_EMPTY_STRING=s.Buffer.from([128]),n.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compactBytesToNibbles=n.bytesToNibbles=n.nibblesToCompactBytes=n.nibblesToBytes=n.hasTerminator=void 0;n.hasTerminator=e=>e.length>0&&16===e[e.length-1];n.nibblesToBytes=(e,t)=>{for(let n=0,s=0;s<e.length;n+=1,s+=2)t[n]=e[s]<<4|e[s+1]};n.nibblesToCompactBytes=e=>{let t=0;(0,n.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const s=new Uint8Array(e.length/2+1);return s[0]=t<<5,1&~e.length||(s[0]|=16,s[0]|=e[0],e=e.subarray(1)),(0,n.nibblesToBytes)(e,s.subarray(1)),s};n.bytesToNibbles=e=>{const t=2*e.length+1,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const s=e[t];n[2*t]=s/16,n[2*t+1]=s%16}return n[t-1]=16,n};n.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,n.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const s=2-(1&t[0]);return t.subarray(s)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.assertIsString=n.assertIsArray=n.assertIsBuffer=n.assertIsHexString=void 0;const s=e("./internal");n.assertIsHexString=function(e){if(!(0,s.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};n.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};n.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};n.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.toAscii=n.stripHexPrefix=n.padToEven=n.isHexString=n.isHexPrefixed=n.getKeys=n.getBinarySize=n.fromUtf8=n.fromAscii=n.arrayContainsArray=void 0,r(e("./constants"),n),r(e("./units"),n),r(e("./account"),n),r(e("./address"),n),r(e("./withdrawal"),n),r(e("./signature"),n),r(e("./bytes"),n),r(e("./types"),n),r(e("./encoding"),n),r(e("./asyncEventEmitter"),n);var a=e("./internal");Object.defineProperty(n,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(n,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(n,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(n,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(n,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(n,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(n,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(n,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(n,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(n,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),r(e("./lock"),n),r(e("./provider"),n)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(n,"__esModule",{value:!0}),n.isHexString=n.getKeys=n.fromAscii=n.fromUtf8=n.toAscii=n.arrayContainsArray=n.getBinarySize=n.padToEven=n.stripHexPrefix=n.isHexPrefixed=void 0,n.isHexPrefixed=t;function s(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}n.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},n.padToEven=s,n.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},n.arrayContainsArray=function(e,t,n){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===n?"some":"every"](t=>e.indexOf(t)>=0)},n.toAscii=function(e){let t="",n=0;const s=e.length;for("0x"===e.substring(0,2)&&(n=2);n<s;n+=2){const s=parseInt(e.substr(n,2),16);t+=String.fromCharCode(s)}return t},n.fromUtf8=function(t){return`0x${s(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},n.fromAscii=function(e){let t="";for(let n=0;n<e.length;n++){const s=e.charCodeAt(n).toString(16);t+=s.length<2?`0${s}`:s}return`0x${t}`},n.getKeys=function(e,t,n){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const s=[];for(let r=0;r<e.length;r++){let a=e[r][t];if(!0!==n||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";s.push(a)}return s},n.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Lock=void 0;n.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise(e=>this.promiseResolverQueue.push(e))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getProvider=n.fetchFromProvider=void 0;const s=e("micro-ftch");n.fetchFromProvider=async(e,t)=>(await(0,s.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;n.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashPersonalMessage=n.isValidSignature=n.fromRpcSig=n.toCompactSig=n.toRpcSig=n.ecrecover=n.ecsign=void 0;const s=e("ethereum-cryptography/keccak"),r=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function m(e){return e===BigInt(0)||e===BigInt(1)}n.ecsign=function(e,n,s){const a=r.secp256k1.sign(e,n),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:s===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(s)*BigInt(2)}};n.ecrecover=function(e,n,s,o,i){const d=t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(o,32)],64),u=c(n,i);if(!m(u))throw new Error("Invalid signature v value");const l=r.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};n.toRpcSig=function(e,n,s,r){if(!m(c(e,r)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(s,32),(0,a.toBuffer)(e)]))};n.toCompactSig=function(e,n,s,r){if(!m(c(e,r)))throw new Error("Invalid signature v value");let o=s;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(s),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(o,32)]))};n.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let n,s,r;if(t.length>=65)n=t.slice(0,32),s=t.slice(32,64),r=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");n=t.slice(0,32),s=t.slice(32,64),r=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),s[0]&=127}return r<27&&(r+=BigInt(27)),{v:r,r:n,s:s}};n.isValidSignature=function(e,t,n,s=!0,r){if(32!==t.length||32!==n.length)return!1;if(!m(c(e,r)))return!1;const i=(0,a.bufferToBigInt)(t),d=(0,a.bufferToBigInt)(n);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||d===BigInt(0)||d>=o.SECP256K1_ORDER)&&!(s&&d>=o.SECP256K1_ORDER_DIV_2)};n.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const n=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,s.keccak256)(t.concat([n,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toType=n.TypeOutput=void 0;const s=e("./bytes"),r=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=n.TypeOutput||(n.TypeOutput={})),n.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,r.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const n=(0,s.toBuffer)(e);switch(t){case a.Buffer:return n;case a.BigInt:return(0,s.bufferToBigInt)(n);case a.Number:{const e=(0,s.bufferToBigInt)(n);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,s.bufferToHex)(n);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.GWEI_TO_WEI=void 0,n.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Withdrawal=void 0;const s=e("./address"),r=e("./bytes"),a=e("./types");class o{constructor(e,t,n,s){this.index=e,this.validatorIndex=t,this.address=n,this.amount=s}static fromWithdrawalData(e){const{index:t,validatorIndex:n,address:r,amount:i}=e,c=(0,a.toType)(t,a.TypeOutput.BigInt),m=(0,a.toType)(n,a.TypeOutput.BigInt),d=new s.Address((0,a.toType)(r,a.TypeOutput.Buffer)),u=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(c,m,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,n,s,r]=e;return o.fromWithdrawalData({index:t,validatorIndex:n,address:s,amount:r})}static toBufferArray(e){const{index:n,validatorIndex:r,address:o,amount:i}=e,c=(0,a.toType)(n,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(n,a.TypeOutput.Buffer),m=(0,a.toType)(r,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(r,a.TypeOutput.Buffer);let d;d=o instanceof s.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[c,m,d,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,r.bigIntToHex)(this.index),validatorIndex:(0,r.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,r.bigIntToHex)(this.amount)}}}n.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return m.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return u.default}});var s=l(e("./v1.js")),r=l(e("./v3.js")),a=l(e("./v4.js")),o=l(e("./v5.js")),i=l(e("./nil.js")),c=l(e("./version.js")),m=l(e("./validate.js")),d=l(e("./stringify.js")),u=l(e("./parse.js"));function l(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){return 14+(e+64>>>9<<4)+1}function r(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function a(e,t,n,s,a,o){return r((i=r(r(t,e),r(s,o)))<<(c=a)|i>>>32-c,n);var i,c}function o(e,t,n,s,r,o,i){return a(t&n|~t&s,e,t,r,o,i)}function i(e,t,n,s,r,o,i){return a(t&s|n&~s,e,t,r,o,i)}function c(e,t,n,s,r,o,i){return a(t^n^s,e,t,r,o,i)}function m(e,t,n,s,r,o,i){return a(n^(t|~s),e,t,r,o,i)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var d=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,s="0123456789abcdef";for(let r=0;r<n;r+=8){const n=e[r>>5]>>>r%32&255,a=parseInt(s.charAt(n>>>4&15)+s.charAt(15&n),16);t.push(a)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[s(t)-1]=t;let n=1732584193,a=-271733879,d=-1732584194,u=271733878;for(let t=0;t<e.length;t+=16){const s=n,l=a,h=d,p=u;n=o(n,a,d,u,e[t],7,-680876936),u=o(u,n,a,d,e[t+1],12,-389564586),d=o(d,u,n,a,e[t+2],17,606105819),a=o(a,d,u,n,e[t+3],22,-1044525330),n=o(n,a,d,u,e[t+4],7,-176418897),u=o(u,n,a,d,e[t+5],12,1200080426),d=o(d,u,n,a,e[t+6],17,-1473231341),a=o(a,d,u,n,e[t+7],22,-45705983),n=o(n,a,d,u,e[t+8],7,1770035416),u=o(u,n,a,d,e[t+9],12,-1958414417),d=o(d,u,n,a,e[t+10],17,-42063),a=o(a,d,u,n,e[t+11],22,-1990404162),n=o(n,a,d,u,e[t+12],7,1804603682),u=o(u,n,a,d,e[t+13],12,-40341101),d=o(d,u,n,a,e[t+14],17,-1502002290),a=o(a,d,u,n,e[t+15],22,1236535329),n=i(n,a,d,u,e[t+1],5,-165796510),u=i(u,n,a,d,e[t+6],9,-1069501632),d=i(d,u,n,a,e[t+11],14,643717713),a=i(a,d,u,n,e[t],20,-373897302),n=i(n,a,d,u,e[t+5],5,-701558691),u=i(u,n,a,d,e[t+10],9,38016083),d=i(d,u,n,a,e[t+15],14,-660478335),a=i(a,d,u,n,e[t+4],20,-405537848),n=i(n,a,d,u,e[t+9],5,568446438),u=i(u,n,a,d,e[t+14],9,-1019803690),d=i(d,u,n,a,e[t+3],14,-187363961),a=i(a,d,u,n,e[t+8],20,1163531501),n=i(n,a,d,u,e[t+13],5,-1444681467),u=i(u,n,a,d,e[t+2],9,-51403784),d=i(d,u,n,a,e[t+7],14,1735328473),a=i(a,d,u,n,e[t+12],20,-1926607734),n=c(n,a,d,u,e[t+5],4,-378558),u=c(u,n,a,d,e[t+8],11,-2022574463),d=c(d,u,n,a,e[t+11],16,1839030562),a=c(a,d,u,n,e[t+14],23,-35309556),n=c(n,a,d,u,e[t+1],4,-1530992060),u=c(u,n,a,d,e[t+4],11,1272893353),d=c(d,u,n,a,e[t+7],16,-155497632),a=c(a,d,u,n,e[t+10],23,-1094730640),n=c(n,a,d,u,e[t+13],4,681279174),u=c(u,n,a,d,e[t],11,-358537222),d=c(d,u,n,a,e[t+3],16,-722521979),a=c(a,d,u,n,e[t+6],23,76029189),n=c(n,a,d,u,e[t+9],4,-640364487),u=c(u,n,a,d,e[t+12],11,-421815835),d=c(d,u,n,a,e[t+15],16,530742520),a=c(a,d,u,n,e[t+2],23,-995338651),n=m(n,a,d,u,e[t],6,-198630844),u=m(u,n,a,d,e[t+7],10,1126891415),d=m(d,u,n,a,e[t+14],15,-1416354905),a=m(a,d,u,n,e[t+5],21,-57434055),n=m(n,a,d,u,e[t+12],6,1700485571),u=m(u,n,a,d,e[t+3],10,-1894986606),d=m(d,u,n,a,e[t+10],15,-1051523),a=m(a,d,u,n,e[t+1],21,-2054922799),n=m(n,a,d,u,e[t+8],6,1873313359),u=m(u,n,a,d,e[t+15],10,-30611744),d=m(d,u,n,a,e[t+6],15,-1560198380),a=m(a,d,u,n,e[t+13],21,1309151649),n=m(n,a,d,u,e[t+4],6,-145523070),u=m(u,n,a,d,e[t+11],10,-1120210379),d=m(d,u,n,a,e[t+2],15,718787259),a=m(a,d,u,n,e[t+9],21,-343485551),n=r(n,s),a=r(a,l),d=r(d,h),u=r(u,p)}return[n,a,d,u]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(s(t));for(let s=0;s<t;s+=8)n[s>>5]|=(255&e[s/8])<<s%32;return n}(e),8*e.length))};n.default=d}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let s;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!s&&(s="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto),!s))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return s(r)};const r=new Uint8Array(16)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e,t,n,s){switch(e){case 0:return t&n^~t&s;case 1:case 3:return t^n^s;case 2:return t&n^t&s^n&s}}function r(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var a=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const a=e.length/4+2,o=Math.ceil(a/16),i=new Array(o);for(let t=0;t<o;++t){const n=new Uint32Array(16);for(let s=0;s<16;++s)n[s]=e[64*t+4*s]<<24|e[64*t+4*s+1]<<16|e[64*t+4*s+2]<<8|e[64*t+4*s+3];i[t]=n}i[o-1][14]=8*(e.length-1)/Math.pow(2,32),i[o-1][14]=Math.floor(i[o-1][14]),i[o-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<o;++e){const a=new Uint32Array(80);for(let t=0;t<16;++t)a[t]=i[e][t];for(let e=16;e<80;++e)a[e]=r(a[e-3]^a[e-8]^a[e-14]^a[e-16],1);let o=n[0],c=n[1],m=n[2],d=n[3],u=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),i=r(o,5)+s(n,c,m,d)+u+t[n]+a[e]>>>0;u=d,d=m,m=r(c,30)>>>0,c=o,o=i}n[0]=n[0]+o>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+m>>>0,n[3]=n[3]+d>>>0,n[4]=n[4]+u>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};const a=[];for(let e=0;e<256;++e)a.push((e+256).toString(16).substr(1));var o=function(e,t=0){const n=(a[e[t+0]]+a[e[t+1]]+a[e[t+2]]+a[e[t+3]]+"-"+a[e[t+4]]+a[e[t+5]]+"-"+a[e[t+6]]+a[e[t+7]]+"-"+a[e[t+8]]+a[e[t+9]]+"-"+a[e[t+10]]+a[e[t+11]]+a[e[t+12]]+a[e[t+13]]+a[e[t+14]]+a[e[t+15]]).toLowerCase();if(!(0,r.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./rng.js")),r=a(e("./stringify.js"));function a(e){return e&&e.__esModule?e:{default:e}}let o,i,c=0,m=0;var d=function(e,t,n){let a=t&&n||0;const d=t||new Array(16);let u=(e=e||{}).node||o,l=e.clockseq!==undefined?e.clockseq:i;if(null==u||null==l){const t=e.random||(e.rng||s.default)();null==u&&(u=o=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==l&&(l=i=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),p=e.nsecs!==undefined?e.nsecs:m+1;const f=h-c+(p-m)/1e4;if(f<0&&e.clockseq===undefined&&(l=l+1&16383),(f<0||h>c)&&e.nsecs===undefined&&(p=0),p>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,m=p,i=l,h+=122192928e5;const g=(1e4*(268435455&h)+p)%4294967296;d[a++]=g>>>24&255,d[a++]=g>>>16&255,d[a++]=g>>>8&255,d[a++]=255&g;const y=h/4294967296*1e4&268435455;d[a++]=y>>>8&255,d[a++]=255&y,d[a++]=y>>>24&15|16,d[a++]=y>>>16&255,d[a++]=l>>>8|128,d[a++]=255&l;for(let e=0;e<6;++e)d[a+e]=u[e];return t||(0,r.default)(d)};n.default=d}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./md5.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v3",48,r.default);n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,t,n){function a(e,a,o,i){if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof a&&(a=(0,r.default)(a)),16!==a.length)throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let c=new Uint8Array(16+e.length);if(c.set(a),c.set(e,a.length),c=n(c),c[6]=15&c[6]|t,c[8]=63&c[8]|128,o){i=i||0;for(let e=0;e<16;++e)o[i+e]=c[e];return o}return(0,s.default)(c)}try{a.name=e}catch(e){}return a.DNS=o,a.URL=i,a},n.URL=n.DNS=void 0;var s=a(e("./stringify.js")),r=a(e("./parse.js"));function a(e){return e&&e.__esModule?e:{default:e}}const o="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=o;const i="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v4.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./rng.js")),r=a(e("./stringify.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=function(e,t,n){const a=(e=e||{}).random||(e.rng||s.default)();if(a[6]=15&a[6]|64,a[8]=63&a[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=a[e];return t}return(0,r.default)(a)};n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./sha1.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v5",80,r.default);n.default=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./regex.js"))&&s.__esModule?s:{default:s};var a=function(e){return"string"==typeof e&&r.default.test(e)};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");return parseInt(e.substr(14,1),16)};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Bytes.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Bytes=void 0;const s=e("./lib"),r=e("./RegistryItem"),a=e("./RegistryType");class o extends r.RegistryItem{constructor(e){super(),this.bytes=e,this.getRegistryType=()=>a.RegistryTypes.BYTES,this.getData=()=>this.bytes,this.toDataItem=()=>new s.DataItem(this.bytes)}}n.Bytes=o,o.fromDataItem=e=>{const t=e.getData();if(!t)throw new Error(`#[ur-registry][Bytes][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${e}`);return new o(t)},o.fromCBOR=e=>{const t=(0,s.decodeToDataItem)(e);return o.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoAccount.js",{".":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoAccount=void 0;const s=e("."),r=e("./lib"),a=e("./RegistryItem"),o=e("./RegistryType");var i;!function(e){e[e.masterFingerprint=1]="masterFingerprint",e[e.outputDescriptors=2]="outputDescriptors"}(i||(i={}));class c extends a.RegistryItem{constructor(e,t){super(),this.masterFingerprint=e,this.outputDescriptors=t,this.getRegistryType=()=>o.RegistryTypes.CRYPTO_ACCOUNT,this.getMasterFingerprint=()=>this.masterFingerprint,this.getOutputDescriptors=()=>this.outputDescriptors,this.toDataItem=()=>{const e={};return this.masterFingerprint&&(e[i.masterFingerprint]=this.masterFingerprint.readUInt32BE(0)),this.outputDescriptors&&(e[i.outputDescriptors]=this.outputDescriptors.map(e=>e.toDataItem())),new r.DataItem(e)}}}n.CryptoAccount=c,c.fromDataItem=e=>{const n=e.getData(),r=t.alloc(4),a=n[i.masterFingerprint];a&&r.writeUInt32BE(a,0);const o=n[i.outputDescriptors].map(e=>s.CryptoOutput.fromDataItem(e));return new c(r,o)},c.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoAccount.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoCoinInfo=n.Network=n.Type=void 0;const s=e("./lib"),r=e("./RegistryItem"),a=e("./RegistryType");var o,i,c;!function(e){e.type="1",e.network="2"}(o||(o={})),function(e){e[e.bitcoin=0]="bitcoin"}(i=n.Type||(n.Type={})),function(e){e[e.mainnet=0]="mainnet",e[e.testnet=1]="testnet"}(c=n.Network||(n.Network={}));class m extends r.RegistryItem{constructor(e,t){super(),this.type=e,this.network=t,this.getRegistryType=()=>a.RegistryTypes.CRYPTO_COIN_INFO,this.getType=()=>this.type||i.bitcoin,this.getNetwork=()=>this.network||c.mainnet,this.toDataItem=()=>{const e={};return this.type&&(e[o.type]=this.type),this.network&&(e[o.network]=this.network),new s.DataItem(e)}}}n.CryptoCoinInfo=m,m.fromDataItem=e=>{const t=e.getData(),n=t[o.type],s=t[o.network];return new m(n,s)},m.fromCBOR=e=>{const t=(0,s.decodeToDataItem)(e);return m.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoECKey=void 0;const s=e("./lib"),r=e("./RegistryItem"),a=e("./RegistryType");var o;!function(e){e[e.curve=1]="curve",e[e.private=2]="private",e[e.data=3]="data"}(o||(o={}));class i extends r.RegistryItem{constructor(e){super(),this.isECKey=()=>!0,this.getCurve=()=>this.curve||0,this.isPrivateKey=()=>this.privateKey||!1,this.getData=()=>this.data,this.getRegistryType=()=>a.RegistryTypes.CRYPTO_ECKEY,this.toDataItem=()=>{const e={};return this.curve&&(e[o.curve]=this.curve),this.privateKey!==undefined&&(e[o.private]=this.privateKey),e[o.data]=this.data,new s.DataItem(e)},this.getOutputDescriptorContent=()=>this.data.toString("hex"),this.data=e.data,this.curve=e.curve,this.privateKey=e.privateKey||undefined}}n.CryptoECKey=i,i.fromDataItem=e=>{const t=e.getData(),n=t[o.curve],s=t[o.private],r=t[o.data];if(!r)throw new Error(`#[ur-registry][CryptoECKey][fn.fromDataItem]: decoded [dataItem][#data.data] is undefined: ${e}`);return new i({data:r,curve:n,privateKey:s})},i.fromCBOR=e=>{const t=(0,s.decodeToDataItem)(e);return i.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js",{"./CryptoCoinInfo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js","./CryptoKeypath":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",bs58check:"/home/runner/work/metamask-extension/metamask-extension/node_modules/bs58check/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoHDKey=void 0;const s=e("bs58check"),r=e("./CryptoCoinInfo"),a=e("./CryptoKeypath"),o=e("./lib"),i=e("./RegistryItem"),c=e("./RegistryType");var m;!function(e){e[e.is_master=1]="is_master",e[e.is_private=2]="is_private",e[e.key_data=3]="key_data",e[e.chain_code=4]="chain_code",e[e.use_info=5]="use_info",e[e.origin=6]="origin",e[e.children=7]="children",e[e.parent_fingerprint=8]="parent_fingerprint",e[e.name=9]="name",e[e.note=10]="note"}(m||(m={}));class d extends i.RegistryItem{constructor(e){super(),this.isECKey=()=>!1,this.getKey=()=>this.key,this.getChainCode=()=>this.chainCode,this.isMaster=()=>this.master,this.isPrivateKey=()=>!!this.privateKey,this.getUseInfo=()=>this.useInfo,this.getOrigin=()=>this.origin,this.getChildren=()=>this.children,this.getParentFingerprint=()=>this.parentFingerprint,this.getName=()=>this.name,this.getNote=()=>this.note,this.getBip32Key=()=>{var e,n,r;let a,o,i=0,c=t.alloc(4).fill(0);if(this.isMaster())a=t.from("0488ADE4","hex"),o=0,i=0;else{o=(null===(e=this.getOrigin())||void 0===e?void 0:e.getComponents().length)||(null===(n=this.getOrigin())||void 0===n?void 0:n.getDepth());const s=null===(r=this.getOrigin())||void 0===r?void 0:r.getComponents(),m=s[s.length-1];m&&(i=m.isHardened()?m.getIndex()+2147483648:m.getIndex(),this.getParentFingerprint()&&(c=this.getParentFingerprint())),a=this.isPrivateKey()?t.from("0488ADE4","hex"):t.from("0488B21E","hex")}const m=t.alloc(1);m.writeUInt8(o,0);const d=t.alloc(4);d.writeUInt32BE(i,0);const u=this.getChainCode(),l=this.getKey();return(0,s.encode)(t.concat([a,m,c,d,u,l]))},this.getRegistryType=()=>c.RegistryTypes.CRYPTO_HDKEY,this.getOutputDescriptorContent=()=>{var e,t,n,s,r,a,o;let i="";return this.getOrigin()&&(null===(e=this.getOrigin())||void 0===e?void 0:e.getSourceFingerprint())&&(null===(t=this.getOrigin())||void 0===t?void 0:t.getPath())&&(i+=`${null===(s=null===(n=this.getOrigin())||void 0===n?void 0:n.getSourceFingerprint())||void 0===s?void 0:s.toString("hex")}/${null===(r=this.getOrigin())||void 0===r?void 0:r.getPath()}`),i+=this.getBip32Key(),this.getChildren()&&(null===(a=this.getChildren())||void 0===a?void 0:a.getPath())&&(i+=`/${null===(o=this.getChildren())||void 0===o?void 0:o.getPath()}`),i},this.setupMasterKey=e=>{this.master=!0,this.key=e.key,this.chainCode=e.chainCode},this.setupDeriveKey=e=>{this.master=!1,this.privateKey=e.isPrivateKey,this.key=e.key,this.chainCode=e.chainCode,this.useInfo=e.useInfo,this.origin=e.origin,this.children=e.children,this.parentFingerprint=e.parentFingerprint,this.name=e.name,this.note=e.note},this.toDataItem=()=>{const e={};if(this.master)e[m.is_master]=!0,e[m.key_data]=this.key,e[m.chain_code]=this.chainCode;else{if(this.privateKey!==undefined&&(e[m.is_private]=this.privateKey),e[m.key_data]=this.key,this.chainCode&&(e[m.chain_code]=this.chainCode),this.useInfo){const t=this.useInfo.toDataItem();t.setTag(this.useInfo.getRegistryType().getTag()),e[m.use_info]=t}if(this.origin){const t=this.origin.toDataItem();t.setTag(this.origin.getRegistryType().getTag()),e[m.origin]=t}if(this.children){const t=this.children.toDataItem();t.setTag(this.children.getRegistryType().getTag()),e[m.children]=t}this.parentFingerprint&&(e[m.parent_fingerprint]=this.parentFingerprint.readUInt32BE(0)),this.name!==undefined&&(e[m.name]=this.name),this.note!==undefined&&(e[m.note]=this.note)}return new o.DataItem(e)},e.isMaster?this.setupMasterKey(e):this.setupDeriveKey(e)}}n.CryptoHDKey=d,d.fromDataItem=e=>{const n=e.getData(),s=!!n[m.is_master],o=n[m.is_private],i=n[m.key_data],c=n[m.chain_code],u=n[m.use_info]?r.CryptoCoinInfo.fromDataItem(n[m.use_info]):undefined,l=n[m.origin]?a.CryptoKeypath.fromDataItem(n[m.origin]):undefined,h=n[m.children]?a.CryptoKeypath.fromDataItem(n[m.children]):undefined,p=n[m.parent_fingerprint];let f=undefined;p&&(f=t.alloc(4),f.writeUInt32BE(p,0));const g=n[m.name],y=n[m.note];return new d({isMaster:s,isPrivateKey:o,key:i,chainCode:c,useInfo:u,origin:l,children:h,parentFingerprint:f,name:g,note:y})},d.fromCBOR=e=>{const t=(0,o.decodeToDataItem)(e);return d.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js",{"./PathComponent":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoKeypath=void 0;const s=e("./lib"),r=e("./PathComponent"),a=e("./RegistryItem"),o=e("./RegistryType");var i;!function(e){e[e.components=1]="components",e[e.source_fingerprint=2]="source_fingerprint",e[e.depth=3]="depth"}(i||(i={}));class c extends a.RegistryItem{constructor(e=[],t,n){super(),this.components=e,this.sourceFingerprint=t,this.depth=n,this.getRegistryType=()=>o.RegistryTypes.CRYPTO_KEYPATH,this.getPath=()=>{if(0===this.components.length)return undefined;return this.components.map(e=>`${e.isWildcard()?"*":e.getIndex()}${e.isHardened()?"'":""}`).join("/")},this.getComponents=()=>this.components,this.getSourceFingerprint=()=>this.sourceFingerprint,this.getDepth=()=>this.depth,this.toDataItem=()=>{const e={},t=[];return this.components&&this.components.forEach(e=>{e.isWildcard()?t.push([]):t.push(e.getIndex()),t.push(e.isHardened())}),e[i.components]=t,this.sourceFingerprint&&(e[i.source_fingerprint]=this.sourceFingerprint.readUInt32BE(0)),this.depth!==undefined&&(e[i.depth]=this.depth),new s.DataItem(e)}}}n.CryptoKeypath=c,c.fromDataItem=e=>{const n=e.getData(),s=[],a=n[i.components];if(a)for(let e=0;e<a.length;e+=2){const t=a[e+1],n=a[e];"number"==typeof n?s.push(new r.PathComponent({index:n,hardened:t})):s.push(new r.PathComponent({hardened:t}))}const o=n[i.source_fingerprint];let m;o&&(m=t.alloc(4),m.writeUInt32BE(o,0));const d=n[i.depth];return new c(s,m,d)},c.fromCBOR=e=>{const t=(0,s.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoOutput.js",{"./CryptoECKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js","./CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","./MultiKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./ScriptExpression":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoOutput=void 0;const s=e("./CryptoECKey"),r=e("./CryptoHDKey"),a=e("./lib"),o=e("./MultiKey"),i=e("./RegistryItem"),c=e("./RegistryType"),m=e("./ScriptExpression");class d extends i.RegistryItem{constructor(e,t){super(),this.scriptExpressions=e,this.cryptoKey=t,this.getRegistryType=()=>c.RegistryTypes.CRYPTO_OUTPUT,this.getCryptoKey=()=>this.cryptoKey,this.getHDKey=()=>this.cryptoKey instanceof r.CryptoHDKey?this.cryptoKey:undefined,this.getECKey=()=>this.cryptoKey instanceof s.CryptoECKey?this.cryptoKey:undefined,this.getMultiKey=()=>this.cryptoKey instanceof o.MultiKey?this.cryptoKey:undefined,this.getScriptExpressions=()=>this.scriptExpressions,this._toOutputDescriptor=e=>e>=this.scriptExpressions.length?this.cryptoKey.getOutputDescriptorContent():`${this.scriptExpressions[e].getExpression()}(${this._toOutputDescriptor(e+1)})`,this.toString=()=>this._toOutputDescriptor(0),this.toDataItem=()=>{let e=this.cryptoKey.toDataItem();(this.cryptoKey instanceof s.CryptoECKey||this.cryptoKey instanceof r.CryptoHDKey)&&e.setTag(this.cryptoKey.getRegistryType().getTag());return[...this.scriptExpressions].reverse().forEach(t=>{const n=t.getTag();e.getTag()===undefined?e.setTag(n):e=new a.DataItem(e,n)}),e}}}n.CryptoOutput=d,d.fromDataItem=e=>{const t=[];let n=e;for(;;){let e=n.getTag();const s=m.ScriptExpression.fromTag(e);if(!s)break;if(t.push(s),!(n.getData()instanceof a.DataItem))break;n=n.getData(),e=n.getTag()}const i=t.length;if(i>0&&(t[i-1].getExpression()===m.ScriptExpressions.MULTISIG.getExpression()||t[i-1].getExpression()===m.ScriptExpressions.SORTED_MULTISIG.getExpression())){const e=o.MultiKey.fromDataItem(n);return new d(t,e)}if(n.getTag()===c.RegistryTypes.CRYPTO_HDKEY.getTag()){const e=r.CryptoHDKey.fromDataItem(n);return new d(t,e)}{const e=s.CryptoECKey.fromDataItem(n);return new d(t,e)}},d.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return d.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoOutput.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoPSBT.js",{"./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoPSBT=void 0;const s=e("./lib"),r=e("./RegistryItem"),a=e("./RegistryType");class o extends r.RegistryItem{constructor(e){super(),this.psbt=e,this.getRegistryType=()=>a.RegistryTypes.CRYPTO_PSBT,this.getPSBT=()=>this.psbt,this.toDataItem=()=>new s.DataItem(this.psbt)}}n.CryptoPSBT=o,o.fromDataItem=e=>{const t=e.getData();if(!t)throw new Error(`#[ur-registry][CryptoPSBT][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${e}`);return new o(t)},o.fromCBOR=e=>{const t=(0,s.decodeToDataItem)(e);return o.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoPSBT.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Decoder/index.js",{"..":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js","@ngraveio/bc-ur":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ngraveio/bc-ur/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URRegistryDecoder=void 0;const s=e("@ngraveio/bc-ur"),r=e(".."),a=e("../RegistryType"),o=e("../errors");class i extends s.URDecoder{constructor(){super(...arguments),this.resultRegistryType=()=>{const e=this.resultUR();switch(e.type){case a.RegistryTypes.BYTES.getType():return r.Bytes.fromCBOR(e.cbor);case a.RegistryTypes.CRYPTO_HDKEY.getType():return r.CryptoHDKey.fromCBOR(e.cbor);case a.RegistryTypes.CRYPTO_KEYPATH.getType():return r.CryptoKeypath.fromCBOR(e.cbor);case a.RegistryTypes.CRYPTO_COIN_INFO.getType():return r.CryptoCoinInfo.fromCBOR(e.cbor);case a.RegistryTypes.CRYPTO_ECKEY.getType():return r.CryptoECKey.fromCBOR(e.cbor);case a.RegistryTypes.CRYPTO_OUTPUT.getType():return r.CryptoOutput.fromCBOR(e.cbor);case a.RegistryTypes.CRYPTO_PSBT.getType():return r.CryptoPSBT.fromCBOR(e.cbor);case a.RegistryTypes.CRYPTO_ACCOUNT.getType():return r.CryptoAccount.fromCBOR(e.cbor);default:throw new o.UnknownURTypeError(`#[ur-registry][Decoder][fn.resultRegistryType]: registry type ${e.type} is not supported now`)}}}}n.URRegistryDecoder=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Decoder/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js",{"./CryptoECKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js","./CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./lib/DataItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MultiKey=void 0;const s=e("./CryptoECKey"),r=e("./CryptoHDKey"),a=e("./lib/DataItem"),o=e("./RegistryItem"),i=e("./RegistryType");var c;!function(e){e[e.threshold=1]="threshold",e[e.keys=2]="keys"}(c||(c={}));class m extends o.RegistryItem{constructor(e,t){super(),this.threshold=e,this.keys=t,this.getThreshold=()=>this.threshold,this.getKeys=()=>this.keys,this.toDataItem=()=>{const e={};e[c.threshold]=this.threshold;const t=this.keys.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t});return e[c.keys]=t,new a.DataItem(e)},this.getOutputDescriptorContent=()=>[this.getThreshold(),this.keys.map(e=>e.getOutputDescriptorContent()).join(",")].join(",")}}n.MultiKey=m,m.fromDataItem=e=>{const t=e.getData(),n=t[c.threshold],a=t[c.keys],o=[];return a.forEach(e=>{e.getTag()===i.RegistryTypes.CRYPTO_HDKEY.getTag()?o.push(r.CryptoHDKey.fromDataItem(e)):e.getTag()===i.RegistryTypes.CRYPTO_ECKEY.getTag()&&o.push(s.CryptoECKey.fromDataItem(e))}),new m(n,o)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PathComponent=void 0;class s{constructor(e){if(this.getIndex=()=>this.index,this.isWildcard=()=>this.wildcard,this.isHardened=()=>this.hardened,this.index=e.index,this.hardened=e.hardened,this.index!==undefined?this.wildcard=!1:this.wildcard=!0,this.index&&0!==(this.index&s.HARDENED_BIT))throw new Error(`#[ur-registry][PathComponent][fn.constructor]: Invalid index ${this.index} - most significant bit cannot be set`)}}n.PathComponent=s,s.HARDENED_BIT=2147483648}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js",{"./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","@ngraveio/bc-ur":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ngraveio/bc-ur/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RegistryItem=void 0;const s=e("@ngraveio/bc-ur"),r=e("./lib");n.RegistryItem=class{constructor(){this.toCBOR=()=>{if(this.toDataItem()===undefined)throw new Error(`#[ur-registry][RegistryItem][fn.toCBOR]: registry ${this.getRegistryType()}'s method toDataItem returns undefined`);return(0,r.encodeDataItem)(this.toDataItem())},this.toUR=()=>new s.UR(this.toCBOR(),this.getRegistryType().getType()),this.toUREncoder=(e,t,n)=>{const r=this.toUR();return new s.UREncoder(r,e,t,n)}}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RegistryTypes=n.RegistryType=void 0;class s{constructor(e,t){this.type=e,this.tag=t,this.getTag=()=>this.tag,this.getType=()=>this.type}}n.RegistryType=s,n.RegistryTypes={UUID:new s("uuid",37),BYTES:new s("bytes",undefined),CRYPTO_HDKEY:new s("crypto-hdkey",303),CRYPTO_KEYPATH:new s("crypto-keypath",304),CRYPTO_COIN_INFO:new s("crypto-coin-info",305),CRYPTO_ECKEY:new s("crypto-eckey",306),CRYPTO_OUTPUT:new s("crypto-output",308),CRYPTO_PSBT:new s("crypto-psbt",310),CRYPTO_ACCOUNT:new s("crypto-account",311),CRYPTO_MULTI_ACCOUNTS:new s("crypto-multi-accounts",1103),QR_HARDWARE_CALL:new s("qr-hardware-call",1201),KEY_DERIVATION_CALL:new s("key-derivation-call",1301),KEY_DERIVATION_SCHEMA:new s("key-derivation-schema",1302)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ScriptExpressions=n.ScriptExpression=void 0;class s{constructor(e,t){this.tag=e,this.expression=t,this.getTag=()=>this.tag,this.getExpression=()=>this.expression}}n.ScriptExpression=s,s.fromTag=e=>Object.values(n.ScriptExpressions).find(t=>t.getTag()===e),n.ScriptExpressions={SCRIPT_HASH:new s(400,"sh"),WITNESS_SCRIPT_HASH:new s(401,"wsh"),PUBLIC_KEY:new s(402,"pk"),PUBLIC_KEY_HASH:new s(403,"pkh"),WITNESS_PUBLIC_KEY_HASH:new s(404,"wpkh"),COMBO:new s(405,"combo"),MULTISIG:new s(406,"multi"),SORTED_MULTISIG:new s(407,"sortedmulti"),ADDRESS:new s(307,"addr"),RAW_SCRIPT:new s(408,"raw")}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.UnknownURTypeError=void 0;class s extends Error{constructor(e){super(e)}}n.UnknownURTypeError=s}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/CryptoMultiAccounts.js",{"../CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoMultiAccounts=void 0;const s=e("../RegistryType"),r=e("../CryptoHDKey"),a=e("../RegistryItem"),o=e("../lib");var i;!function(e){e[e.masterFingerprint=1]="masterFingerprint",e[e.keys=2]="keys",e[e.device=3]="device",e[e.deviceId=4]="deviceId",e[e.version=5]="version"}(i||(i={}));class c extends a.RegistryItem{constructor(e,t,n,r,a){super(),this.masterFingerprint=e,this.keys=t,this.device=n,this.deviceId=r,this.version=a,this.getRegistryType=()=>s.RegistryTypes.CRYPTO_MULTI_ACCOUNTS,this.getMasterFingerprint=()=>this.masterFingerprint,this.getKeys=()=>this.keys,this.getDevice=()=>this.device,this.getDeviceId=()=>this.deviceId,this.getVersion=()=>this.version,this.toDataItem=()=>{const e={};return this.masterFingerprint&&(e[i.masterFingerprint]=this.masterFingerprint.readUInt32BE(0)),this.keys&&(e[i.keys]=this.keys.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t})),this.device&&(e[i.device]=this.device),this.deviceId&&(e[i.deviceId]=this.deviceId),this.version&&(e[i.version]=this.version),new o.DataItem(e)}}}n.CryptoMultiAccounts=c,c.fromDataItem=e=>{const n=e.getData(),s=t.alloc(4),a=n[i.masterFingerprint];a&&s.writeUInt32BE(a,0);const o=n[i.keys].map(e=>r.CryptoHDKey.fromDataItem(e)),m=n[i.device],d=n[i.deviceId],u=n[i.version];return new c(s,o,m,d,u)},c.fromCBOR=e=>{const t=(0,o.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/CryptoMultiAccounts.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js",{"../CryptoKeypath":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js","../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyDerivationSchema=n.DerivationAlgorithm=n.Curve=void 0;const s=e("../RegistryType"),r=e("../RegistryItem"),a=e("../lib"),o=e("../CryptoKeypath");var i,c,m;!function(e){e[e.keyPath=1]="keyPath",e[e.curve=2]="curve",e[e.algo=3]="algo"}(i||(i={})),function(e){e[e.secp256k1=0]="secp256k1",e[e.ed25519=1]="ed25519"}(c=n.Curve||(n.Curve={})),function(e){e[e.slip10=0]="slip10",e[e.bip32ed25519=1]="bip32ed25519"}(m=n.DerivationAlgorithm||(n.DerivationAlgorithm={}));class d extends r.RegistryItem{constructor(e,t=c.secp256k1,n=m.slip10){super(),this.keypath=e,this.curve=t,this.algo=n,this.getRegistryType=()=>s.RegistryTypes.KEY_DERIVATION_SCHEMA,this.getKeypath=()=>this.keypath,this.getCurve=()=>this.curve,this.getAlgo=()=>this.algo,this.toDataItem=()=>{const e={},t=this.getKeypath().toDataItem();return t.setTag(this.getKeypath().getRegistryType().getTag()),e[i.keyPath]=t,e[i.curve]=this.curve,e[i.algo]=this.algo,new a.DataItem(e)}}}n.KeyDerivationSchema=d,d.fromDataItem=e=>{const t=e.getData(),n=o.CryptoKeypath.fromDataItem(t[i.keyPath]),s=t[i.curve],r=t[i.algo];return new d(n,s,r)},d.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return d.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js",{"../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","./DerivationSchema":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyDerivation=void 0;const s=e("../RegistryType"),r=e("../RegistryItem"),a=e("../lib"),o=e("./DerivationSchema");var i;!function(e){e[e.schemas=1]="schemas"}(i||(i={}));class c extends r.RegistryItem{constructor(e){super(),this.schemas=e,this.getRegistryType=()=>s.RegistryTypes.KEY_DERIVATION_CALL,this.getSchemas=()=>this.schemas,this.toDataItem=()=>{const e={};return e[i.schemas]=this.schemas.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t}),new a.DataItem(e)}}}n.KeyDerivation=c,c.fromDataItem=e=>{const t=e.getData()[i.schemas].map(e=>o.KeyDerivationSchema.fromDataItem(e));return new c(t)},c.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return c.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/QRHardwareCall.js",{"../RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","../RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","../lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","./KeyDerivation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.QRHardwareCall=n.QRHardwareCallType=void 0;const s=e("../RegistryType"),r=e("../RegistryItem"),a=e("../lib"),o=e("./KeyDerivation");var i,c;!function(e){e[e.type=1]="type",e[e.params=2]="params",e[e.origin=3]="origin"}(i||(i={})),function(e){e[e.KeyDerivation=0]="KeyDerivation"}(c=n.QRHardwareCallType||(n.QRHardwareCallType={}));class m extends r.RegistryItem{constructor(e,t,n){super(),this.type=e,this.params=t,this.origin=n,this.getRegistryType=()=>s.RegistryTypes.QR_HARDWARE_CALL,this.getType=()=>this.type,this.getParams=()=>this.params,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};e[i.type]=this.type;const t=this.params.toDataItem();return t.setTag(this.params.getRegistryType().getTag()),e[i.params]=t,this.origin&&(e[i.origin]=this.origin),new a.DataItem(e)}}}n.QRHardwareCall=m,m.fromDataItem=e=>{const t=e.getData(),n=t[i.type]||c.KeyDerivation;let s;if(n===c.KeyDerivation)s=o.KeyDerivation.fromDataItem(t[i.params]);const r=t[i.origin];return new m(n,s,r)},m.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return m.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/QRHardwareCall.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js",{"./Bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Bytes.js","./CryptoAccount":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoAccount.js","./CryptoCoinInfo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js","./CryptoECKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js","./CryptoHDKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js","./CryptoKeypath":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js","./CryptoOutput":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoOutput.js","./CryptoPSBT":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoPSBT.js","./Decoder":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Decoder/index.js","./MultiKey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js","./PathComponent":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js","./RegistryItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js","./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./ScriptExpression":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js","./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js","./extended/CryptoMultiAccounts":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/CryptoMultiAccounts.js","./extended/DerivationSchema":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js","./extended/KeyDerivation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js","./extended/QRHardwareCall":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/QRHardwareCall.js","./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js","./patchCBOR":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/patchCBOR.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/types.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js","buffer/":"/home/runner/work/metamask-extension/metamask-extension/node_modules/buffer/index.js",tslib:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tslib/tslib.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Buffer=n.extend=n.PathComponent=n.ScriptExpressions=n.MultiKey=n.CryptoPSBT=n.CryptoOutput=n.CryptoECKey=n.CryptoCoinInfoNetwork=n.CryptoCoinInfoType=n.CryptoCoinInfo=n.CryptoKeypath=n.CryptoMultiAccounts=n.CryptoHDKey=n.CryptoAccount=n.Bytes=n.URRegistryDecoder=n.DataItem=void 0;const s=e("tslib");e("./patchCBOR");const r=e("buffer/");Object.defineProperty(n,"Buffer",{enumerable:!0,get:function(){return r.Buffer}});const a=e("./CryptoHDKey");Object.defineProperty(n,"CryptoHDKey",{enumerable:!0,get:function(){return a.CryptoHDKey}});const o=e("./CryptoKeypath");Object.defineProperty(n,"CryptoKeypath",{enumerable:!0,get:function(){return o.CryptoKeypath}});const i=e("./CryptoCoinInfo");Object.defineProperty(n,"CryptoCoinInfo",{enumerable:!0,get:function(){return i.CryptoCoinInfo}}),Object.defineProperty(n,"CryptoCoinInfoType",{enumerable:!0,get:function(){return i.Type}}),Object.defineProperty(n,"CryptoCoinInfoNetwork",{enumerable:!0,get:function(){return i.Network}});const c=e("./CryptoECKey");Object.defineProperty(n,"CryptoECKey",{enumerable:!0,get:function(){return c.CryptoECKey}});const m=e("./Bytes");Object.defineProperty(n,"Bytes",{enumerable:!0,get:function(){return m.Bytes}});const d=e("./CryptoOutput");Object.defineProperty(n,"CryptoOutput",{enumerable:!0,get:function(){return d.CryptoOutput}});const u=e("./CryptoPSBT");Object.defineProperty(n,"CryptoPSBT",{enumerable:!0,get:function(){return u.CryptoPSBT}});const l=e("./CryptoAccount");Object.defineProperty(n,"CryptoAccount",{enumerable:!0,get:function(){return l.CryptoAccount}});const h=e("./Decoder");Object.defineProperty(n,"URRegistryDecoder",{enumerable:!0,get:function(){return h.URRegistryDecoder}});const p=e("./MultiKey");Object.defineProperty(n,"MultiKey",{enumerable:!0,get:function(){return p.MultiKey}});const f=e("./ScriptExpression");Object.defineProperty(n,"ScriptExpressions",{enumerable:!0,get:function(){return f.ScriptExpressions}});const g=e("./PathComponent");Object.defineProperty(n,"PathComponent",{enumerable:!0,get:function(){return g.PathComponent}});const y=e("./RegistryItem"),k=e("./RegistryType"),b=e("./lib");var x=e("./lib");Object.defineProperty(n,"DataItem",{enumerable:!0,get:function(){return x.DataItem}});const w=e("./utils"),_=e("./extended/CryptoMultiAccounts");Object.defineProperty(n,"CryptoMultiAccounts",{enumerable:!0,get:function(){return _.CryptoMultiAccounts}});const v={URRegistryDecoder:h.URRegistryDecoder,Bytes:m.Bytes,CryptoAccount:l.CryptoAccount,CryptoHDKey:a.CryptoHDKey,CryptoMultiAccounts:_.CryptoMultiAccounts,CryptoKeypath:o.CryptoKeypath,CryptoCoinInfo:i.CryptoCoinInfo,CryptoCoinInfoType:i.Type,CryptoCoinInfoNetwork:i.Network,CryptoECKey:c.CryptoECKey,CryptoOutput:d.CryptoOutput,CryptoPSBT:u.CryptoPSBT,MultiKey:p.MultiKey,ScriptExpressions:f.ScriptExpressions,PathComponent:g.PathComponent},E={addReader:b.addReader,addSemanticDecode:b.addSemanticDecode,addSemanticEncode:b.addSemanticEncode,addWriter:b.addWriter,patchTags:w.patchTags},T={RegistryTypes:k.RegistryTypes,RegistryItem:y.RegistryItem,RegistryType:k.RegistryType,decodeToDataItem:b.decodeToDataItem,encodeDataItem:b.encodeDataItem,cbor:E};n.extend=T,(0,s.__exportStar)(e("./errors"),n),(0,s.__exportStar)(e("./Decoder"),n),(0,s.__exportStar)(e("./lib"),n),(0,s.__exportStar)(e("./CryptoAccount"),n),(0,s.__exportStar)(e("./CryptoPSBT"),n),(0,s.__exportStar)(e("./CryptoHDKey"),n),(0,s.__exportStar)(e("./extended/CryptoMultiAccounts"),n),(0,s.__exportStar)(e("./extended/QRHardwareCall"),n),(0,s.__exportStar)(e("./extended/KeyDerivation"),n),(0,s.__exportStar)(e("./extended/DerivationSchema"),n),(0,s.__exportStar)(e("./CryptoOutput"),n),(0,s.__exportStar)(e("./CryptoCoinInfo"),n),(0,s.__exportStar)(e("./CryptoECKey"),n),(0,s.__exportStar)(e("./MultiKey"),n),(0,s.__exportStar)(e("./CryptoKeypath"),n),(0,s.__exportStar)(e("./patchCBOR"),n),(0,s.__exportStar)(e("./PathComponent"),n),(0,s.__exportStar)(e("./RegistryItem"),n),(0,s.__exportStar)(e("./RegistryType"),n),(0,s.__exportStar)(e("./types"),n),(0,s.__exportStar)(e("./utils"),n),n.default=v}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DataItem=void 0;n.DataItem=class{constructor(e,t){this.setTag=e=>{this.tag=e},this.clearTag=()=>{this.tag=undefined},this.getTag=()=>this.tag,this.getData=()=>this.data,this.data=e,this.tag=t}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/cbor-sync.js",{"./DataItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var s,r;s=this,r=function(){const{DataItem:t}=e("./DataItem");var s=function(){function e(e){this.$hex=e}e.prototype={length:function(){return this.$hex.length/2},toString:function(e){if(!e||"hex"===e||16===e)return this.$hex;if("utf-8"===e){for(var t="",n=0;n<this.$hex.length;n+=2)t+="%"+this.$hex.substring(n,n+2);return decodeURIComponent(t)}if("latin"===e){for(t=[],n=0;n<this.$hex.length;n+=2)t.push(parseInt(this.$hex.substring(n,n+2),16));return String.fromCharCode.apply(String,t)}throw new Error("Unrecognised format: "+e)}},e.fromLatinString=function(t){for(var n="",s=0;s<t.length;s++){var r=t.charCodeAt(s).toString(16);1===r.length&&(r="0"+r),n+=r}return new e(n)},e.fromUtf8String=function(t){for(var n=encodeURIComponent(t),s="",r=0;r<n.length;r++)if("%"===n.charAt(r))s+=n.substring(r+1,r+3),r+=2;else{var a=n.charCodeAt(r).toString(16);a.length<2&&(a="0"+a),s+=a}return new e(s)};var s=[],r={},a=function(e){return function(){throw new Error(e+" not implemented")}};function o(){}function i(){}function c(e,t){var n=e.value;return n<24?n:24==n?t.readByte():25==n?t.readUint16():26==n?t.readUint32():27==n?t.readUint64():31==n?null:void a("Additional info: "+n)()}function m(e,t,n){var s=e<<5;t<24?n.writeByte(s|t):t<256?(n.writeByte(24|s),n.writeByte(t)):t<65536?(n.writeByte(25|s),n.writeUint16(t)):t<4294967296?(n.writeByte(26|s),n.writeUint32(t)):(n.writeByte(27|s),n.writeUint64(t))}o.prototype={peekByte:a("peekByte"),readByte:a("readByte"),readChunk:a("readChunk"),readFloat16:function(){var e=this.readUint16(),t=(32767&e)>>10,n=1023&e,s=32768&e;if(31===t)return 0===n?s?-Infinity:Infinity:NaN;var r=t?Math.pow(2,t-25)*(1024+n):Math.pow(2,-24)*n;return s?-r:r},readFloat32:function(){var e=this.readUint32(),t=(2147483647&e)>>23,n=8388607&e,s=2147483648&e;if(255===t)return 0===n?s?-Infinity:Infinity:NaN;var r=t?Math.pow(2,t-23-127)*(8388608+n):Math.pow(2,-149)*n;return s?-r:r},readFloat64:function(){var e=this.readUint32(),t=e>>20&2047,n=4294967296*(1048575&e)+this.readUint32(),s=2147483648&e;if(2047===t)return 0===n?s?-Infinity:Infinity:NaN;var r=t?Math.pow(2,t-52-1023)*(4503599627370496+n):Math.pow(2,-1074)*n;return s?-r:r},readUint16:function(){return 256*this.readByte()+this.readByte()},readUint32:function(){return 65536*this.readUint16()+this.readUint16()},readUint64:function(){return 4294967296*this.readUint32()+this.readUint32()}},i.prototype={writeByte:a("writeByte"),result:a("result"),writeFloat16:a("writeFloat16"),writeFloat32:a("writeFloat32"),writeFloat64:a("writeFloat64"),writeUint16:function(e){this.writeByte(e>>8&255),this.writeByte(255&e)},writeUint32:function(e){this.writeUint16(e>>16&65535),this.writeUint16(65535&e)},writeUint64:function(e){if(e>=9007199254740992||e<=-9007199254740992)throw new Error("Cannot encode Uint64 of: "+e+" magnitude to big (floating point errors)");this.writeUint32(Math.floor(e/4294967296)),this.writeUint32(e%4294967296)},writeString:a("writeString"),canWriteBinary:function(e){return!1},writeBinary:a("writeChunk")};var d=new Error;function u(e){var t=function(e){var t=e.readByte();return{type:t>>5,value:31&t}}(e);switch(t.type){case 0:return c(t,e);case 1:return-1-c(t,e);case 2:return e.readChunk(c(t,e));case 3:return e.readChunk(c(t,e)).toString("utf-8");case 4:case 5:var n=c(t,e),s=[];if(null!==n){5===t.type&&(n*=2);for(var a=0;a<n;a++)s[a]=u(e)}else for(var o;(o=u(e))!==d;)s.push(o);if(5===t.type){var i={};for(a=0;a<s.length;a+=2)i[s[a]]=s[a+1];return i}return s;case 6:var m=c(t,e),l=r[m];return s=u(e),l?l(s):s;case 7:if(25===t.value)return e.readFloat16();if(26===t.value)return e.readFloat32();if(27===t.value)return e.readFloat64();switch(c(t,e)){case 20:return!1;case 21:return!0;case 22:return null;case 23:return undefined;case null:return d;default:throw new Error("Unknown fixed value: "+t.value)}default:throw new Error("Unsupported header: "+JSON.stringify(t))}throw new Error("not implemented yet")}function l(e,t){for(var n=0;n<s.length;n++){var r=s[n].fn(e);if(r!==undefined)return m(6,s[n].tag,t),l(r,t)}if(e&&"function"==typeof e.toCBOR&&(e=e.toCBOR()),!1===e)m(7,20,t);else if(!0===e)m(7,21,t);else if(null===e)m(7,22,t);else if(e===undefined)m(7,23,t);else if("number"==typeof e)Math.floor(e)===e&&e<9007199254740992&&e>-9007199254740992?e<0?m(1,-1-e,t):m(0,e,t):(function(e,t,n){n.writeByte(e<<5|t)}(7,27,t),t.writeFloat64(e));else if("string"==typeof e)t.writeString(e,function(e){m(3,e,t)});else if(t.canWriteBinary(e))t.writeBinary(e,function(e){m(2,e,t)});else{if("object"!=typeof e)throw new Error("CBOR encoding not supported: "+e);if(f.config.useToJSON&&"function"==typeof e.toJSON&&(e=e.toJSON()),Array.isArray(e))for(m(4,e.length,t),n=0;n<e.length;n++)l(e[n],t);else{var a=Object.keys(e);for(m(5,a.length,t),n=0;n<a.length;n++){const s=parseInt(a[n]);isNaN(s)?(l(a[n],t),l(e[a[n]],t)):(l(s,t),l(e[a[n]],t))}}}}var h=[],p=[],f={config:{useToJSON:!0},addWriter:function(e,t){"string"==typeof e?p.push(function(n){if(e===n)return t(n)}):p.push(e)},addReader:function(e,t){"string"==typeof e?h.push(function(n,s){if(e===s)return t(n,s)}):h.push(e)},encode:function(e,t){for(var n=0;n<p.length;n++){var s=(0,p[n])(t);if(s)return l(e,s),s.result()}throw new Error("Unsupported output format: "+t)},encodeDataItem:function(e,t){for(var n=0;n<p.length;n++){var s=(0,p[n])(t);if(s)return e.getTag()!==undefined?(l(e,s),s.result()):(l(e.getData(),s),s.result())}throw new Error("Unsupported output format: "+t)},decode:function(e,t){for(var n=0;n<h.length;n++){var s=(0,h[n])(e,t);if(s)return u(s)}throw new Error("Unsupported input format: "+t)},decodeToDataItem:function(e,n){for(var s=0;s<h.length;s++){var r=(0,h[s])(e,n);if(r){const e=u(r);return e instanceof t?e:new t(e)}}throw new Error("Unsupported input format: "+n)},addSemanticEncode:function(e,t){if("number"!=typeof e||e%1!=0||e<0)throw new Error("Tag must be a positive integer");return s.push({tag:e,fn:t}),this},addSemanticDecode:function(e,t){if("number"!=typeof e||e%1!=0||e<0)throw new Error("Tag must be a positive integer");return r[e]=t,this}};function g(e){this.buffer=e,this.pos=0}function y(e){this.byteLength=0,this.defaultBufferLength=16384,this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0,this.completeBuffers=[],this.stringFormat=e}function k(e){this.hex=e,this.pos=0}function b(e){this.$hex="",this.finalFormat=e||"hex"}return g.prototype=Object.create(o.prototype),g.prototype.peekByte=function(){return this.buffer[this.pos]},g.prototype.readByte=function(){return this.buffer[this.pos++]},g.prototype.readUint16=function(){var e=this.buffer.readUInt16BE(this.pos);return this.pos+=2,e},g.prototype.readUint32=function(){var e=this.buffer.readUInt32BE(this.pos);return this.pos+=4,e},g.prototype.readFloat32=function(){var e=this.buffer.readFloatBE(this.pos);return this.pos+=4,e},g.prototype.readFloat64=function(){var e=this.buffer.readDoubleBE(this.pos);return this.pos+=8,e},g.prototype.readChunk=function(e){var t=n.alloc(e);return this.buffer.copy(t,0,this.pos,this.pos+=e),t},y.prototype=Object.create(i.prototype),y.prototype.writeByte=function(e){this.latestBuffer[this.latestBufferOffset++]=e,this.latestBufferOffset>=this.latestBuffer.length&&(this.completeBuffers.push(this.latestBuffer),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0),this.byteLength++},y.prototype.writeFloat32=function(e){var t=n.alloc(4);t.writeFloatBE(e,0),this.writeBuffer(t)},y.prototype.writeFloat64=function(e){var t=n.alloc(8);t.writeDoubleBE(e,0),this.writeBuffer(t)},y.prototype.writeString=function(e,t){var s=n.from(e,"utf-8");t(s.length),this.writeBuffer(s)},y.prototype.canWriteBinary=function(e){return e instanceof n},y.prototype.writeBinary=function(e,t){t(e.length),this.writeBuffer(e)},y.prototype.writeBuffer=function(e){if(!(e instanceof n))throw new TypeError("BufferWriter only accepts Buffers");this.latestBufferOffset?this.latestBuffer.length-this.latestBufferOffset>=e.length?(e.copy(this.latestBuffer,this.latestBufferOffset),this.latestBufferOffset+=e.length,this.latestBufferOffset>=this.latestBuffer.length&&(this.completeBuffers.push(this.latestBuffer),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0)):(this.completeBuffers.push(this.latestBuffer.slice(0,this.latestBufferOffset)),this.completeBuffers.push(e),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0):this.completeBuffers.push(e),this.byteLength+=e.length},y.prototype.result=function(){for(var e=n.alloc(this.byteLength),t=0,s=0;s<this.completeBuffers.length;s++){var r=this.completeBuffers[s];r.copy(e,t,0,r.length),t+=r.length}return this.latestBufferOffset&&this.latestBuffer.copy(e,t,0,this.latestBufferOffset),this.stringFormat?e.toString(this.stringFormat):e},"function"==typeof n&&(f.addReader(function(e,t){return n.isBuffer(e)?new g(e):"hex"===t||"base64"===t?new g(n.from(e,t)):void 0}),f.addWriter(function(e){return e&&"buffer"!==e?"hex"===e||"base64"===e?new y(e):void 0:new y})),k.prototype=Object.create(o.prototype),k.prototype.peekByte=function(){var e=this.hex.substring(this.pos,2);return parseInt(e,16)},k.prototype.readByte=function(){var e=this.hex.substring(this.pos,this.pos+2);return this.pos+=2,parseInt(e,16)},k.prototype.readChunk=function(t){var s=this.hex.substring(this.pos,this.pos+2*t);return this.pos+=2*t,"function"==typeof n?n.from(s,"hex"):new e(s)},b.prototype=Object.create(i.prototype),b.prototype.writeByte=function(e){if(e<0||e>255)throw new Error("Byte value out of range: "+e);var t=e.toString(16);1==t.length&&(t="0"+t),this.$hex+=t},b.prototype.canWriteBinary=function(t){return t instanceof e||"function"==typeof n&&t instanceof n},b.prototype.writeBinary=function(t,s){if(t instanceof e)s(t.length()),this.$hex+=t.$hex;else{if(!("function"==typeof n&&t instanceof n))throw new TypeError("HexWriter only accepts BinaryHex or Buffers");s(t.length),this.$hex+=t.toString("hex")}},b.prototype.result=function(){return"buffer"===this.finalFormat&&"function"==typeof n?n.from(this.$hex,"hex"):new e(this.$hex).toString(this.finalFormat)},b.prototype.writeString=function(t,n){var s=e.fromUtf8String(t);n(s.length()),this.$hex+=s.$hex},f.addReader(function(t,n){return t instanceof e||t.$hex?new k(t.$hex):"hex"===n?new k(t):void 0}),f.addWriter(function(e){if("hex"===e)return new b}),f}();return s.addSemanticEncode(0,function(e){if(e instanceof Date)return e.toISOString()}).addSemanticDecode(0,function(e){return new Date(e)}).addSemanticDecode(1,function(e){return new Date(e)}),s},"function"==typeof define&&define.amd?define([],r):void 0!==t&&t.exports?t.exports=r():s.CBOR=r()}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/cbor-sync.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js",{"./DataItem":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js","./cbor-sync":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/cbor-sync.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DataItem=n.addWriter=n.addReader=n.addSemanticEncode=n.addSemanticDecode=n.decodeToDataItem=n.encodeDataItem=void 0;var s=e("./cbor-sync");Object.defineProperty(n,"encodeDataItem",{enumerable:!0,get:function(){return s.encodeDataItem}}),Object.defineProperty(n,"decodeToDataItem",{enumerable:!0,get:function(){return s.decodeToDataItem}}),Object.defineProperty(n,"addSemanticDecode",{enumerable:!0,get:function(){return s.addSemanticDecode}}),Object.defineProperty(n,"addSemanticEncode",{enumerable:!0,get:function(){return s.addSemanticEncode}}),Object.defineProperty(n,"addReader",{enumerable:!0,get:function(){return s.addReader}}),Object.defineProperty(n,"addWriter",{enumerable:!0,get:function(){return s.addWriter}});var r=e("./DataItem");Object.defineProperty(n,"DataItem",{enumerable:!0,get:function(){return r.DataItem}})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/patchCBOR.js",{"./RegistryType":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js","./ScriptExpression":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const s=e("./utils"),r=e("./RegistryType"),a=e("./ScriptExpression"),o=Object.values(r.RegistryTypes).filter(e=>!!e.getTag()).map(e=>e.getTag()),i=Object.values(a.ScriptExpressions).map(e=>e.getTag());(0,s.patchTags)(o.concat(i))}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/patchCBOR.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/types.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js",{"./lib":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.patchTags=void 0;const s=e("./lib"),r=[];n.patchTags=e=>{e.forEach(e=>{r.find(t=>t===e)||((0,s.addSemanticEncode)(e,t=>{if(t instanceof s.DataItem&&t.getTag()===e)return t.getData()}),(0,s.addSemanticDecode)(e,t=>new s.DataItem(t,e)),r.push(e))})}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return m.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}});var s=l(e("./v1.js")),r=l(e("./v3.js")),a=l(e("./v4.js")),o=l(e("./v5.js")),i=l(e("./nil.js")),c=l(e("./version.js")),m=l(e("./validate.js")),d=l(e("./stringify.js")),u=l(e("./parse.js"));function l(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){return 14+(e+64>>>9<<4)+1}function r(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function a(e,t,n,s,a,o){return r((i=r(r(t,e),r(s,o)))<<(c=a)|i>>>32-c,n);var i,c}function o(e,t,n,s,r,o,i){return a(t&n|~t&s,e,t,r,o,i)}function i(e,t,n,s,r,o,i){return a(t&s|n&~s,e,t,r,o,i)}function c(e,t,n,s,r,o,i){return a(t^n^s,e,t,r,o,i)}function m(e,t,n,s,r,o,i){return a(n^(t|~s),e,t,r,o,i)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var d=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,s="0123456789abcdef";for(let r=0;r<n;r+=8){const n=e[r>>5]>>>r%32&255,a=parseInt(s.charAt(n>>>4&15)+s.charAt(15&n),16);t.push(a)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[s(t)-1]=t;let n=1732584193,a=-271733879,d=-1732584194,u=271733878;for(let t=0;t<e.length;t+=16){const s=n,l=a,h=d,p=u;n=o(n,a,d,u,e[t],7,-680876936),u=o(u,n,a,d,e[t+1],12,-389564586),d=o(d,u,n,a,e[t+2],17,606105819),a=o(a,d,u,n,e[t+3],22,-1044525330),n=o(n,a,d,u,e[t+4],7,-176418897),u=o(u,n,a,d,e[t+5],12,1200080426),d=o(d,u,n,a,e[t+6],17,-1473231341),a=o(a,d,u,n,e[t+7],22,-45705983),n=o(n,a,d,u,e[t+8],7,1770035416),u=o(u,n,a,d,e[t+9],12,-1958414417),d=o(d,u,n,a,e[t+10],17,-42063),a=o(a,d,u,n,e[t+11],22,-1990404162),n=o(n,a,d,u,e[t+12],7,1804603682),u=o(u,n,a,d,e[t+13],12,-40341101),d=o(d,u,n,a,e[t+14],17,-1502002290),a=o(a,d,u,n,e[t+15],22,1236535329),n=i(n,a,d,u,e[t+1],5,-165796510),u=i(u,n,a,d,e[t+6],9,-1069501632),d=i(d,u,n,a,e[t+11],14,643717713),a=i(a,d,u,n,e[t],20,-373897302),n=i(n,a,d,u,e[t+5],5,-701558691),u=i(u,n,a,d,e[t+10],9,38016083),d=i(d,u,n,a,e[t+15],14,-660478335),a=i(a,d,u,n,e[t+4],20,-405537848),n=i(n,a,d,u,e[t+9],5,568446438),u=i(u,n,a,d,e[t+14],9,-1019803690),d=i(d,u,n,a,e[t+3],14,-187363961),a=i(a,d,u,n,e[t+8],20,1163531501),n=i(n,a,d,u,e[t+13],5,-1444681467),u=i(u,n,a,d,e[t+2],9,-51403784),d=i(d,u,n,a,e[t+7],14,1735328473),a=i(a,d,u,n,e[t+12],20,-1926607734),n=c(n,a,d,u,e[t+5],4,-378558),u=c(u,n,a,d,e[t+8],11,-2022574463),d=c(d,u,n,a,e[t+11],16,1839030562),a=c(a,d,u,n,e[t+14],23,-35309556),n=c(n,a,d,u,e[t+1],4,-1530992060),u=c(u,n,a,d,e[t+4],11,1272893353),d=c(d,u,n,a,e[t+7],16,-155497632),a=c(a,d,u,n,e[t+10],23,-1094730640),n=c(n,a,d,u,e[t+13],4,681279174),u=c(u,n,a,d,e[t],11,-358537222),d=c(d,u,n,a,e[t+3],16,-722521979),a=c(a,d,u,n,e[t+6],23,76029189),n=c(n,a,d,u,e[t+9],4,-640364487),u=c(u,n,a,d,e[t+12],11,-421815835),d=c(d,u,n,a,e[t+15],16,530742520),a=c(a,d,u,n,e[t+2],23,-995338651),n=m(n,a,d,u,e[t],6,-198630844),u=m(u,n,a,d,e[t+7],10,1126891415),d=m(d,u,n,a,e[t+14],15,-1416354905),a=m(a,d,u,n,e[t+5],21,-57434055),n=m(n,a,d,u,e[t+12],6,1700485571),u=m(u,n,a,d,e[t+3],10,-1894986606),d=m(d,u,n,a,e[t+10],15,-1051523),a=m(a,d,u,n,e[t+1],21,-2054922799),n=m(n,a,d,u,e[t+8],6,1873313359),u=m(u,n,a,d,e[t+15],10,-30611744),d=m(d,u,n,a,e[t+6],15,-1560198380),a=m(a,d,u,n,e[t+13],21,1309151649),n=m(n,a,d,u,e[t+4],6,-145523070),u=m(u,n,a,d,e[t+11],10,-1120210379),d=m(d,u,n,a,e[t+2],15,718787259),a=m(a,d,u,n,e[t+9],21,-343485551),n=r(n,s),a=r(a,l),d=r(d,h),u=r(u,p)}return[n,a,d,u]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(s(t));for(let s=0;s<t;s+=8)n[s>>5]|=(255&e[s/8])<<s%32;return n}(e),8*e.length))};n.default=d}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/native-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=s}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/native-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let s;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!s&&(s="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!s))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return s(r)};const r=new Uint8Array(16)}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e,t,n,s){switch(e){case 0:return t&n^~t&s;case 1:case 3:return t^n^s;case 2:return t&n^t&s^n&s}}function r(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var a=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const a=e.length/4+2,o=Math.ceil(a/16),i=new Array(o);for(let t=0;t<o;++t){const n=new Uint32Array(16);for(let s=0;s<16;++s)n[s]=e[64*t+4*s]<<24|e[64*t+4*s+1]<<16|e[64*t+4*s+2]<<8|e[64*t+4*s+3];i[t]=n}i[o-1][14]=8*(e.length-1)/Math.pow(2,32),i[o-1][14]=Math.floor(i[o-1][14]),i[o-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<o;++e){const a=new Uint32Array(80);for(let t=0;t<16;++t)a[t]=i[e][t];for(let e=16;e<80;++e)a[e]=r(a[e-3]^a[e-8]^a[e-14]^a[e-16],1);let o=n[0],c=n[1],m=n[2],d=n[3],u=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),i=r(o,5)+s(n,c,m,d)+u+t[n]+a[e]>>>0;u=d,d=m,m=r(c,30)>>>0,c=o,o=i}n[0]=n[0]+o>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+m>>>0,n[3]=n[3]+d>>>0,n[4]=n[4]+u>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=o;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};const a=[];for(let e=0;e<256;++e)a.push((e+256).toString(16).slice(1));function o(e,t=0){return a[e[t+0]]+a[e[t+1]]+a[e[t+2]]+a[e[t+3]]+"-"+a[e[t+4]]+a[e[t+5]]+"-"+a[e[t+6]]+a[e[t+7]]+"-"+a[e[t+8]]+a[e[t+9]]+"-"+a[e[t+10]]+a[e[t+11]]+a[e[t+12]]+a[e[t+13]]+a[e[t+14]]+a[e[t+15]]}var i=function(e,t=0){const n=o(e,t);if(!(0,r.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./rng.js"))&&s.__esModule?s:{default:s},a=e("./stringify.js");let o,i,c=0,m=0;var d=function(e,t,n){let s=t&&n||0;const d=t||new Array(16);let u=(e=e||{}).node||o,l=e.clockseq!==undefined?e.clockseq:i;if(null==u||null==l){const t=e.random||(e.rng||r.default)();null==u&&(u=o=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==l&&(l=i=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),p=e.nsecs!==undefined?e.nsecs:m+1;const f=h-c+(p-m)/1e4;if(f<0&&e.clockseq===undefined&&(l=l+1&16383),(f<0||h>c)&&e.nsecs===undefined&&(p=0),p>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,m=p,i=l,h+=122192928e5;const g=(1e4*(268435455&h)+p)%4294967296;d[s++]=g>>>24&255,d[s++]=g>>>16&255,d[s++]=g>>>8&255,d[s++]=255&g;const y=h/4294967296*1e4&268435455;d[s++]=y>>>8&255,d[s++]=255&y,d[s++]=y>>>24&15|16,d[s++]=y>>>16&255,d[s++]=l>>>8|128,d[s++]=255&l;for(let e=0;e<6;++e)d[s+e]=u[e];return t||(0,a.unsafeStringify)(d)};n.default=d}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./md5.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v3",48,r.default);n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function s(e,s,o,i){var c;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof s&&(s=(0,a.default)(s)),16!==(null===(c=s)||void 0===c?void 0:c.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let m=new Uint8Array(16+e.length);if(m.set(s),m.set(e,s.length),m=n(m),m[6]=15&m[6]|t,m[8]=63&m[8]|128,o){i=i||0;for(let e=0;e<16;++e)o[i+e]=m[e];return o}return(0,r.unsafeStringify)(m)}try{s.name=e}catch(e){}return s.DNS=o,s.URL=i,s};var s,r=e("./stringify.js"),a=(s=e("./parse.js"))&&s.__esModule?s:{default:s};const o="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=o;const i="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v4.js",{"./native.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/native-browser.js","./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=o(e("./native.js")),r=o(e("./rng.js")),a=e("./stringify.js");function o(e){return e&&e.__esModule?e:{default:e}}var i=function(e,t,n){if(s.default.randomUUID&&!t&&!e)return s.default.randomUUID();const o=(e=e||{}).random||(e.rng||r.default)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=o[e];return t}return(0,a.unsafeStringify)(o)};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./sha1.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v5",80,r.default);n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./regex.js"))&&s.__esModule?s:{default:s};var a=function(e){return"string"==typeof e&&r.default.test(e)};n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js",{"json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js",xtend:"/home/runner/work/metamask-extension/metamask-extension/node_modules/xtend/immutable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const s=e("json-rpc-random-id")(),r=e("xtend");function a(e){this.currentProvider=e}function o(e){return function(...t){const n=t.pop();this.sendAsync({method:e,params:t},n)}}function i(e,t){return function(...n){const s=n.pop();n.length<e&&n.push("latest"),this.sendAsync({method:t,params:n},s)}}t.exports=a,a.prototype.getBalance=i(2,"eth_getBalance"),a.prototype.getCode=i(2,"eth_getCode"),a.prototype.getTransactionCount=i(2,"eth_getTransactionCount"),a.prototype.getStorageAt=i(3,"eth_getStorageAt"),a.prototype.call=i(2,"eth_call"),a.prototype.protocolVersion=o("eth_protocolVersion"),a.prototype.syncing=o("eth_syncing"),a.prototype.coinbase=o("eth_coinbase"),a.prototype.mining=o("eth_mining"),a.prototype.hashrate=o("eth_hashrate"),a.prototype.gasPrice=o("eth_gasPrice"),a.prototype.accounts=o("eth_accounts"),a.prototype.blockNumber=o("eth_blockNumber"),a.prototype.getBlockTransactionCountByHash=o("eth_getBlockTransactionCountByHash"),a.prototype.getBlockTransactionCountByNumber=o("eth_getBlockTransactionCountByNumber"),a.prototype.getUncleCountByBlockHash=o("eth_getUncleCountByBlockHash"),a.prototype.getUncleCountByBlockNumber=o("eth_getUncleCountByBlockNumber"),a.prototype.sign=o("eth_sign"),a.prototype.sendTransaction=o("eth_sendTransaction"),a.prototype.sendRawTransaction=o("eth_sendRawTransaction"),a.prototype.estimateGas=o("eth_estimateGas"),a.prototype.getBlockByHash=o("eth_getBlockByHash"),a.prototype.getBlockByNumber=o("eth_getBlockByNumber"),a.prototype.getTransactionByHash=o("eth_getTransactionByHash"),a.prototype.getTransactionByBlockHashAndIndex=o("eth_getTransactionByBlockHashAndIndex"),a.prototype.getTransactionByBlockNumberAndIndex=o("eth_getTransactionByBlockNumberAndIndex"),a.prototype.getTransactionReceipt=o("eth_getTransactionReceipt"),a.prototype.getUncleByBlockHashAndIndex=o("eth_getUncleByBlockHashAndIndex"),a.prototype.getUncleByBlockNumberAndIndex=o("eth_getUncleByBlockNumberAndIndex"),a.prototype.getCompilers=o("eth_getCompilers"),a.prototype.compileLLL=o("eth_compileLLL"),a.prototype.compileSolidity=o("eth_compileSolidity"),a.prototype.compileSerpent=o("eth_compileSerpent"),a.prototype.newFilter=o("eth_newFilter"),a.prototype.newBlockFilter=o("eth_newBlockFilter"),a.prototype.newPendingTransactionFilter=o("eth_newPendingTransactionFilter"),a.prototype.uninstallFilter=o("eth_uninstallFilter"),a.prototype.getFilterChanges=o("eth_getFilterChanges"),a.prototype.getFilterLogs=o("eth_getFilterLogs"),a.prototype.getLogs=o("eth_getLogs"),a.prototype.getWork=o("eth_getWork"),a.prototype.submitWork=o("eth_submitWork"),a.prototype.submitHashrate=o("eth_submitHashrate"),a.prototype.sendAsync=function(e,t){var n;this.currentProvider.sendAsync((n=e,r({id:s(),jsonrpc:"2.0",params:[]},n)),function(e,n){let s=e;return!e&&n.error&&(s=new Error(`EthQuery - RPC Error - ${n.error.message}`)),s?t(s):t(null,n.result)})}}}},{package:"@metamask/controller-utils>@metamask/eth-query",file:"node_modules/@metamask/eth-query/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/encryption.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",tweetnacl:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tweetnacl/nacl-fast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.getEncryptionPublicKey=n.decryptSafely=n.decrypt=n.encryptSafely=n.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),c=e("./utils");function m({publicKey:e,data:t,version:n}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(n))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===n){if("string"!=typeof t)throw new Error("Message data must be given as a string");const n=i.box.keyPair();let s;try{s=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const r=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),c=i.box(r,a,s,n.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(n.publicKey),ciphertext:o.base64.encode(c)}}throw new Error("Encryption type/version not supported")}function d({encryptedData:e,privateKey:n}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(n))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const s=t.from(n,"hex"),r=i.box.keyPair.fromSecretKey(s).secretKey,a=o.base64.decode(e.nonce),c=o.base64.decode(e.ciphertext),m=o.base64.decode(e.ephemPublicKey),d=i.box.open(c,a,m,r);try{if(!d)throw new Error;const e=o.utf8.encode(d);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}n.encrypt=m,n.encryptSafely=function({publicKey:e,data:n,version:s}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(n))throw new Error("Missing data parameter");if((0,c.isNullish)(s))throw new Error("Missing version parameter");if("object"==typeof n&&n&&"toJSON"in n)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const r={data:n,padding:""},a=t.byteLength(JSON.stringify(r),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),r.padding="0".repeat(o),m({publicKey:e,data:JSON.stringify(r),version:s})},n.decrypt=d,n.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(d({encryptedData:e,privateKey:t})).data},n.getEncryptionPublicKey=function(e){const n=t.from(e,"hex"),s=i.box.keyPair.fromSecretKey(n).publicKey;return o.base64.encode(s)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/encryption.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js",{"./encryption":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/encryption.js","./personal-sign":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/personal-sign.js","./sign-eip7702-authorization":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js","./sign-typed-data":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.normalize=n.concatSig=void 0,r(e("./personal-sign"),n),r(e("./sign-typed-data"),n),r(e("./encryption"),n),r(e("./sign-eip7702-authorization"),n);var a=e("./utils");Object.defineProperty(n,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(n,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/personal-sign.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.extractPublicKey=n.recoverPersonalSignature=n.personalSign=void 0;const s=e("@ethereumjs/util"),r=e("./utils");function a(e,t){const n=(0,s.hashPersonalMessage)((0,r.legacyToBuffer)(e));return(0,r.recoverPublicKey)(n,t)}n.personalSign=function({privateKey:e,data:t}){if((0,r.isNullish)(t))throw new Error("Missing data parameter");if((0,r.isNullish)(e))throw new Error("Missing privateKey parameter");const n=(0,r.legacyToBuffer)(t),a=(0,s.hashPersonalMessage)(n),o=(0,s.ecsign)(a,e);return(0,r.concatSig)((0,s.toBuffer)(o.v),o.r,o.s)},n.recoverPersonalSignature=function({data:e,signature:t}){if((0,r.isNullish)(e))throw new Error("Missing data parameter");if((0,r.isNullish)(t))throw new Error("Missing signature parameter");const n=a(e,t),o=(0,s.publicToAddress)(n);return(0,s.bufferToHex)(o)},n.extractPublicKey=function({data:e,signature:t}){if((0,r.isNullish)(e))throw new Error("Missing data parameter");if((0,r.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashEIP7702Authorization=n.recoverEIP7702Authorization=n.signEIP7702Authorization=void 0;const s=e("@ethereumjs/rlp"),r=e("@ethereumjs/util"),a=e("@metamask/utils"),o=e("ethereum-cryptography/keccak"),i=e("./utils");function c(e){m(e);const n=(0,s.encode)(e),r=t.concat([t.from("05","hex"),n]);return t.from((0,o.keccak256)(r))}function m(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,n,s]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(n))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(s))throw new Error("Missing nonce parameter")}n.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(m(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const n=c(t),{r:s,s:a,v:o}=(0,r.ecsign)(n,e),d=(0,r.toBuffer)(o);return(0,i.concatSig)(d,s,a)},n.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(m(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const n=c(t),s=(0,i.recoverPublicKey)(n,e),o=(0,r.publicToAddress)(s);return(0,a.bytesToHex)(o)},n.hashEIP7702Authorization=c}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/index.js","@metamask/abi-utils/dist/parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/parsers/index.js","@metamask/abi-utils/dist/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.recoverTypedSignature=n.signTypedData=n.typedSignatureHash=n.TypedDataUtils=n.TYPED_MESSAGE_SCHEMA=n.SignTypedDataVersion=void 0;const s=e("@ethereumjs/util"),r=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),c=e("ethereum-cryptography/keccak"),m=e("./utils");var d;function u(e,t){if(!Object.keys(d).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function l(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const n=BigInt(t),s=(0,a.getLength)(e),r=BigInt(2)**BigInt(s)-BigInt(1);return(0,i.assert)(n>=-r&&n<=r,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),n}function h(e){let t=BigInt(0);for(let n=0;n<e.length;n++){const s=BigInt(e.charCodeAt(n)-48);t*=BigInt(10),t+=s>=49?s-BigInt(49)+BigInt(10):s>=17?s-BigInt(17)+BigInt(10):s}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function p(e,t,n,a,m){if(u(m,[d.V3,d.V4]),e[n]!==undefined)return["bytes32",m===d.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,s.arrToBufArr)((0,c.keccak256)(f(n,a,e,m)))];if("function"===n)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${n}`);if("address"===n){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",h(a).subarray(0,20)]}if("bool"===n)return["bool",Boolean(a)];if("bytes"===n)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,s.arrToBufArr)((0,c.keccak256)(a))];if(n.startsWith("bytes")&&"bytes"!==n&&!n.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(n.startsWith("int")&&!n.includes("[")){const e=l(n,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===n)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,s.arrToBufArr)((0,c.keccak256)(a))];if(n.endsWith("]")){if(m===d.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=n.slice(0,n.lastIndexOf("[")),i=a.map(n=>p(e,t,o,n,m));return["bytes32",(0,s.arrToBufArr)((0,c.keccak256)((0,r.encode)(i.map(([e])=>e),i.map(([,e])=>e))))]}return[n,a]}function f(e,t,n,a){u(a,[d.V3,d.V4]);const o=["bytes32"],i=[b(e,n)];for(const s of n[e]){if(a===d.V3&&t[s.name]===undefined)continue;const[e,r]=p(n,s.name,s.type,t[s.name],a);o.push(e),i.push(r)}return(0,s.arrToBufArr)((0,r.encode)(o,i))}function g(e,t){let n="";const s=y(e,t);s.delete(e);const r=[e,...Array.from(s).sort()];for(const e of r){if(!t[e])throw new Error(`No type definition specified: ${e}`);n+=`${e}(${t[e].map(({name:e,type:t})=>`${t} ${e}`).join(",")})`}return n}function y(e,t,n=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const s=e.match(/^\w*/u);if([e]=s,n.has(e)||t[e]===undefined)return n;n.add(e);for(const s of t[e])y(s.type,t,n);return n}function k(e,t,n,r){u(r,[d.V3,d.V4]);const a=f(e,t,n,r),o=(0,c.keccak256)(a);return(0,s.arrToBufArr)(o)}function b(e,t){const n=(0,i.stringToBytes)(g(e,t));return(0,s.arrToBufArr)((0,c.keccak256)(n))}function x(e){const t={};for(const s in n.TYPED_MESSAGE_SCHEMA.properties)e[s]&&(t[s]=e[s]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function w(e,t){u(t,[d.V3,d.V4]);const n=x(e),{domain:s}=n;return k("EIP712Domain",s,{EIP712Domain:n.types.EIP712Domain},t)}function _(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[n]=(0,a.getArrayType)(e);return t.map(e=>_(n,e))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const n=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,n);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,n);if(t instanceof Uint8Array)return t.subarray(0,n)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const n=(0,a.getLength)(e);return BigInt.asIntN(n,BigInt(t))}return t}function v(e,t){return t.map(t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const n=l(e,t);if(n>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(n),32);const s=(0,a.getLength)(e),r=BigInt.asIntN(s,n);return(0,i.signedBigIntToBytes)(r,32)}return t})}function E(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const n=e.map(({name:e,type:t,value:n})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(s=n,s.map(e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e))};var s;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[s,r]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=r?r:""}]`,value:v(s,n)}}return{name:e,type:t,value:_(t,n)}}),d=n.map(e=>"bytes"!==e.type?e.value:(0,m.legacyToBuffer)(e.value)),u=n.map(e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type}),l=e.map(e=>{if(!e.name)throw t;return`${e.type} ${e.name}`});return(0,s.arrToBufArr)((0,c.keccak256)((0,r.encodePacked)(["bytes32","bytes32"],[(0,c.keccak256)((0,r.encodePacked)(["string[]"],[l],!0)),(0,c.keccak256)((0,r.encodePacked)(u,d,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(d=n.SignTypedDataVersion||(n.SignTypedDataVersion={})),n.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},n.TypedDataUtils={encodeData:f,encodeType:g,findTypeDependencies:y,hashStruct:k,hashType:b,sanitizeData:x,eip712Hash:function(e,t){u(t,[d.V3,d.V4]);const n=x(e),r=[(0,i.hexToBytes)("1901")];return r.push(w(e,t)),"EIP712Domain"!==n.primaryType&&r.push(k(n.primaryType,n.message,n.types,t)),(0,s.arrToBufArr)((0,c.keccak256)((0,i.concatBytes)(r)))},eip712DomainHash:w},n.typedSignatureHash=function(e){const t=E(e);return(0,i.bytesToHex)(t)},n.signTypedData=function({privateKey:e,data:t,version:r}){if(u(r),(0,m.isNullish)(t))throw new Error("Missing data parameter");if((0,m.isNullish)(e))throw new Error("Missing private key parameter");const a=r===d.V1?E(t):n.TypedDataUtils.eip712Hash(t,r),o=(0,s.ecsign)(a,e);return(0,m.concatSig)((0,s.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},n.recoverTypedSignature=function({data:e,signature:t,version:r}){if(u(r),(0,m.isNullish)(e))throw new Error("Missing data parameter");if((0,m.isNullish)(t))throw new Error("Missing signature parameter");const a=r===d.V1?E(e):n.TypedDataUtils.eip712Hash(e,r),o=(0,m.recoverPublicKey)(a,t),c=(0,s.publicToAddress)(o);return(0,i.bytesToHex)(c)}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.normalize=n.recoverPublicKey=n.concatSig=n.legacyToBuffer=n.isNullish=n.padWithZeroes=void 0;const s=e("@ethereumjs/util"),r=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}n.padWithZeroes=a,n.isNullish=o,n.legacyToBuffer=function(e){return"string"!=typeof e||(0,s.isHexString)(e)?(0,s.toBuffer)(e):t.from(e)},n.concatSig=function(e,t,n){const o=(0,s.fromSigned)(t),i=(0,s.fromSigned)(n),c=(0,s.bufferToInt)(e),m=a((0,s.toUnsigned)(o).toString("hex"),64),d=a((0,s.toUnsigned)(i).toString("hex"),64),u=(0,r.remove0x)((0,r.numberToHex)(c));return(0,r.add0x)(m.concat(d,u))},n.recoverPublicKey=function(e,t){const n=(0,s.fromRpcSig)(t);return(0,s.ecrecover)(e,n.v,n.r,n.s)},n.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,r.numberToBytes)(e);e=(0,r.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,r.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){if(Array.isArray(e)){const t=[];let n=0;for(let r=0;r<e.length;r++){const a=s(e[r]);t.push(a),n+=a.length}return h(o(n,192),...t)}const t=y(e);return 1===t.length&&t[0]<128?t:h(o(t.length,128),t)}function r(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function a(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return u(d(e))}function o(e,t){if(e<56)return Uint8Array.from([e+t]);const n=f(e),s=f(t+55+n.length/2);return Uint8Array.from(l(s+n))}function i(e,t=!1){if(null==e||0===e.length)return Uint8Array.from([]);const n=c(y(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function c(e){let t,n,s,o,i;const m=[],d=e[0];if(d<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(d<=183){if(t=d-127,s=128===d?Uint8Array.from([]):r(e,1,t),2===t&&s[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:s,remainder:e.slice(t)}}if(d<=191){if(n=d-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=a(r(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return s=r(e,n,t+n),{data:s,remainder:e.slice(t+n)}}if(d<=247){for(t=d-191,o=r(e,1,t);o.length;)i=c(o),m.push(i.data),o=i.remainder;return{data:m,remainder:e.slice(t)}}{if(n=d-246,t=a(r(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const s=n+t;if(s>e.length)throw new Error("invalid RLP: total length is larger than the data");for(o=r(e,n,s);o.length;)i=c(o),m.push(i.data),o=i.remainder;return{data:m,remainder:e.slice(s)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.RLP=n.utils=n.decode=n.encode=void 0,n.encode=s,n.decode=i;const m=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function d(e){let t="";for(let n=0;n<e.length;n++)t+=m[e[n]];return t}function u(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function l(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const s=2*n;t[n]=u(e.slice(s,s+2))}return t}function h(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,s=0;t<e.length;t++){const r=e[t];n.set(r,s),s+=r.length}return n}function p(e){return(new TextEncoder).encode(e)}function f(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function g(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function y(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return g(e)?l((t="string"!=typeof(n=e)?n:g(n)?n.slice(2):n).length%2?`0${t}`:t):p(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?l(f(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:d,concatBytes:h,hexToBytes:l,utf8ToBytes:p},n.RLP={encode:s,decode:i}}}},{package:"@metamask/eth-sig-util>@ethereumjs/rlp",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.accountBodyToRLP=n.accountBodyToSlim=n.accountBodyFromSlim=n.isZeroAddress=n.zeroAddress=n.importPublic=n.privateToAddress=n.privateToPublic=n.publicToAddress=n.pubToAddress=n.isValidPublic=n.isValidPrivate=n.generateAddress2=n.generateAddress=n.isValidChecksumAddress=n.toChecksumAddress=n.isValidAddress=n.Account=void 0;const s=e("@ethereumjs/rlp"),r=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),m=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,n=c.KECCAK256_RLP,s=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=n,this.codeHash=s,this._validate()}static fromAccountData(e){const{nonce:t,balance:n,storageRoot:s,codeHash:r}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,n!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(n)):undefined,s!==undefined?(0,i.toBuffer)(s):undefined,r!==undefined?(0,i.toBuffer)(r):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(s.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,n,s,r]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(n),s,r)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(s.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(c.KECCAK256_NULL)}}n.Account=l;n.isValidAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};n.toChecksumAddress=function(e,n){(0,m.assertIsHexString)(e);const s=(0,d.stripHexPrefix)(e).toLowerCase();let a="";if(n!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(n)).toString()+"0x"}const c=t.from(a+s,"utf8"),u=(0,o.bytesToHex)((0,r.keccak256)(c));let l="0x";for(let e=0;e<s.length;e++)parseInt(u[e],16)>=8?l+=s[e].toUpperCase():l+=s[e];return l};n.isValidChecksumAddress=function(e,t){return(0,n.isValidAddress)(e)&&(0,n.toChecksumAddress)(e,t)===e};n.generateAddress=function(e,n){return(0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,i.bufferToBigInt)(n)===BigInt(0)?t.from((0,r.keccak256)(s.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,r.keccak256)(s.RLP.encode((0,i.bufArrToArr)([e,n])))).slice(-20)};n.generateAddress2=function(e,n,s){if((0,m.assertIsBuffer)(e),(0,m.assertIsBuffer)(n),(0,m.assertIsBuffer)(s),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==n.length)throw new Error("Expected salt to be of length 32");const a=(0,r.keccak256)(t.concat([t.from("ff","hex"),e,n,(0,r.keccak256)(s)]));return(0,i.toBuffer)(a).slice(-20)};n.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};n.isValidPublic=function(e,n=!1){if((0,m.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!n)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};n.pubToAddress=function(e,n=!1){if((0,m.assertIsBuffer)(e),n&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,r.keccak256)(e)).slice(-20)},n.publicToAddress=n.pubToAddress;n.privateToPublic=function(e){return(0,m.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};n.privateToAddress=function(e){return(0,n.publicToAddress)((0,n.privateToPublic)(e))};n.importPublic=function(e){return(0,m.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};n.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function h(e){const[t,n,s,r]=e;return[t,n,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_RLP:s,0===(0,i.arrToBufArr)(r).length?c.KECCAK256_NULL:r]}n.isZeroAddress=function(e){try{(0,m.assertIsString)(e)}catch(e){return!1}return(0,n.zeroAddress)()===e},n.accountBodyFromSlim=h;const p=new Uint8Array(0);n.accountBodyToSlim=function(e){const[t,n,s,r]=e;return[t,n,(0,i.arrToBufArr)(s).equals(c.KECCAK256_RLP)?p:s,(0,i.arrToBufArr)(r).equals(c.KECCAK256_NULL)?p:r]},n.accountBodyToRLP=function(e,t=!0){const n=t?h(e):e;return(0,i.arrToBufArr)(s.RLP.encode(n))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Address=void 0;const s=e("./account"),r=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,r.zeros)(20))}static fromString(e){if(!(0,s.isValidAddress)(e))throw new Error("Invalid address");return new a((0,r.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const n=(0,s.pubToAddress)(e);return new a(n)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const n=(0,s.privateToAddress)(e);return new a(n)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,s.generateAddress)(e.buf,(0,r.bigIntToBuffer)(t)))}static generate2(e,n,r){if(!t.isBuffer(n))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(r))throw new Error("Expected initCode to be a Buffer");return new a((0,s.generateAddress2)(e.buf,n,r))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,r.bufferToBigInt)(this.buf),t=BigInt(0),n=BigInt("0xffff");return e>=t&&e<=n}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}n.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncEventEmitter=void 0;const s=e("events");class r extends s.EventEmitter{emit(e,...t){let[n,s]=t;const r=this;let a=r._events[e]??[];return s===undefined&&"function"==typeof n&&(s=n,n=undefined),"newListener"!==e&&"removeListener"!==e||(n={event:n,fn:s},s=undefined),a=Array.isArray(a)?a:[a],async function(e,t,n){let s;for await(const r of t)try{r.length<2?r.call(e,n):await new Promise((t,s)=>{r.call(e,n,e=>{e?s(e):t()})})}catch(e){s=e}if(s)throw s}(r,a.slice(),n).then(s).catch(s),r.listenerCount(e)>0}once(e,t){const n=this;let s;if("function"!=typeof t)throw new TypeError("listener must be a function");return s=t.length>=2?function(r,a){n.removeListener(e,s),t(r,a)}:function(r){n.removeListener(e,s),t(r,s)},n.on(e,s),n}first(e,t){let n=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(n)||(this._events[e]=n=[n]),n.unshift(t),this}before(e,t,n){return this.beforeOrAfter(e,t,n)}after(e,t,n){return this.beforeOrAfter(e,t,n,"after")}beforeOrAfter(e,t,n,s){let r,a,o=this._events[e]??[];const i="after"===s?1:0;if("function"!=typeof n)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,r=o.length;r--;)if(o[r]===t){a=r+i;break}return o.splice(a,0,n),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}n.AsyncEventEmitter=r}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.intToUnpaddedBuffer=n.bigIntToUnpaddedBuffer=n.bigIntToHex=n.bufArrToArr=n.arrToBufArr=n.validateNoLeadingZeroes=n.baToJSON=n.toUtf8=n.short=n.addHexPrefix=n.toUnsigned=n.fromSigned=n.bufferToInt=n.bigIntToBuffer=n.bufferToBigInt=n.bufferToHex=n.toBuffer=n.unpadHexString=n.unpadArray=n.unpadBuffer=n.setLengthRight=n.setLengthLeft=n.zeros=n.intToBuffer=n.intToHex=void 0;const s=e("./helpers"),r=e("./internal");n.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};n.intToBuffer=function(e){const s=(0,n.intToHex)(e);return t.from((0,r.padToEven)(s.slice(2)),"hex")};n.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,s){const r=(0,n.zeros)(t);return s?e.length<t?(e.copy(r),r):e.slice(0,t):e.length<t?(e.copy(r,t-e.length),r):e.slice(-t)};n.setLengthLeft=function(e,t){return(0,s.assertIsBuffer)(e),a(e,t,!1)};n.setLengthRight=function(e,t){return(0,s.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};n.unpadBuffer=function(e){return(0,s.assertIsBuffer)(e),o(e)};n.unpadArray=function(e){return(0,s.assertIsArray)(e),o(e)};n.unpadHexString=function(e){return(0,s.assertIsHexString)(e),e=(0,r.stripHexPrefix)(e),"0x"+o(e)};n.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,r.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,r.padToEven)((0,r.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,n.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let n=e.toString(16);return n.length%2&&(n="0"+n),t.from(n,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,n.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,n.toBuffer)("0x"+e.toString(16))}n.bufferToHex=function(e){return"0x"+(e=(0,n.toBuffer)(e)).toString("hex")},n.bufferToBigInt=i,n.bigIntToBuffer=c;n.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};n.fromSigned=function(e){return BigInt.asIntN(256,i(e))};n.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};n.addHexPrefix=function(e){return"string"!=typeof e||(0,r.isHexPrefixed)(e)?e:"0x"+e},n.short=function(e,n=50){const s=t.isBuffer(e)?e.toString("hex"):e;return s.length<=n?s:s.slice(0,n)+"…"};n.toUtf8=function(e){if((e=(0,r.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};n.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let s=0;s<e.length;s++)t.push((0,n.baToJSON)(e[s]));return t}};n.validateNoLeadingZeroes=function(e){for(const[t,n]of Object.entries(e))if(n!==undefined&&n.length>0&&0===n[0])throw new Error(`${t} cannot have leading zeroes, received: ${n.toString("hex")}`)},n.arrToBufArr=function e(n){return Array.isArray(n)?n.map(t=>e(t)):t.from(n)},n.bufArrToArr=function e(t){return Array.isArray(t)?t.map(t=>e(t)):Uint8Array.from(t??[])};n.bigIntToHex=e=>"0x"+e.toString(16),n.bigIntToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)(c(e))},n.intToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)((0,n.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAX_WITHDRAWALS_PER_PAYLOAD=n.RLP_EMPTY_STRING=n.KECCAK256_RLP=n.KECCAK256_RLP_S=n.KECCAK256_RLP_ARRAY=n.KECCAK256_RLP_ARRAY_S=n.KECCAK256_NULL=n.KECCAK256_NULL_S=n.TWO_POW256=n.SECP256K1_ORDER_DIV_2=n.SECP256K1_ORDER=n.MAX_INTEGER_BIGINT=n.MAX_INTEGER=n.MAX_UINT64=void 0;const s=e("buffer"),r=e("ethereum-cryptography/secp256k1");n.MAX_UINT64=BigInt("0xffffffffffffffff"),n.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),n.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),n.SECP256K1_ORDER=r.secp256k1.CURVE.n,n.SECP256K1_ORDER_DIV_2=r.secp256k1.CURVE.n/BigInt(2),n.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),n.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",n.KECCAK256_NULL=s.Buffer.from(n.KECCAK256_NULL_S,"hex"),n.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",n.KECCAK256_RLP_ARRAY=s.Buffer.from(n.KECCAK256_RLP_ARRAY_S,"hex"),n.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",n.KECCAK256_RLP=s.Buffer.from(n.KECCAK256_RLP_S,"hex"),n.RLP_EMPTY_STRING=s.Buffer.from([128]),n.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compactBytesToNibbles=n.bytesToNibbles=n.nibblesToCompactBytes=n.nibblesToBytes=n.hasTerminator=void 0;n.hasTerminator=e=>e.length>0&&16===e[e.length-1];n.nibblesToBytes=(e,t)=>{for(let n=0,s=0;s<e.length;n+=1,s+=2)t[n]=e[s]<<4|e[s+1]};n.nibblesToCompactBytes=e=>{let t=0;(0,n.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const s=new Uint8Array(e.length/2+1);return s[0]=t<<5,1&~e.length||(s[0]|=16,s[0]|=e[0],e=e.subarray(1)),(0,n.nibblesToBytes)(e,s.subarray(1)),s};n.bytesToNibbles=e=>{const t=2*e.length+1,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const s=e[t];n[2*t]=s/16,n[2*t+1]=s%16}return n[t-1]=16,n};n.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,n.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const s=2-(1&t[0]);return t.subarray(s)}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.assertIsString=n.assertIsArray=n.assertIsBuffer=n.assertIsHexString=void 0;const s=e("./internal");n.assertIsHexString=function(e){if(!(0,s.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};n.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};n.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};n.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.toAscii=n.stripHexPrefix=n.padToEven=n.isHexString=n.isHexPrefixed=n.getKeys=n.getBinarySize=n.fromUtf8=n.fromAscii=n.arrayContainsArray=void 0,r(e("./constants"),n),r(e("./units"),n),r(e("./account"),n),r(e("./address"),n),r(e("./withdrawal"),n),r(e("./signature"),n),r(e("./bytes"),n),r(e("./types"),n),r(e("./encoding"),n),r(e("./asyncEventEmitter"),n);var a=e("./internal");Object.defineProperty(n,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(n,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(n,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(n,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(n,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(n,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(n,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(n,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(n,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(n,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),r(e("./lock"),n),r(e("./provider"),n)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(n,"__esModule",{value:!0}),n.isHexString=n.getKeys=n.fromAscii=n.fromUtf8=n.toAscii=n.arrayContainsArray=n.getBinarySize=n.padToEven=n.stripHexPrefix=n.isHexPrefixed=void 0,n.isHexPrefixed=t;function s(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}n.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},n.padToEven=s,n.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},n.arrayContainsArray=function(e,t,n){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===n?"some":"every"](t=>e.indexOf(t)>=0)},n.toAscii=function(e){let t="",n=0;const s=e.length;for("0x"===e.substring(0,2)&&(n=2);n<s;n+=2){const s=parseInt(e.substr(n,2),16);t+=String.fromCharCode(s)}return t},n.fromUtf8=function(t){return`0x${s(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},n.fromAscii=function(e){let t="";for(let n=0;n<e.length;n++){const s=e.charCodeAt(n).toString(16);t+=s.length<2?`0${s}`:s}return`0x${t}`},n.getKeys=function(e,t,n){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const s=[];for(let r=0;r<e.length;r++){let a=e[r][t];if(!0!==n||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";s.push(a)}return s},n.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Lock=void 0;n.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise(e=>this.promiseResolverQueue.push(e))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getProvider=n.fetchFromProvider=void 0;const s=e("micro-ftch");n.fetchFromProvider=async(e,t)=>(await(0,s.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;n.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashPersonalMessage=n.isValidSignature=n.fromRpcSig=n.toCompactSig=n.toRpcSig=n.ecrecover=n.ecsign=void 0;const s=e("ethereum-cryptography/keccak"),r=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function m(e){return e===BigInt(0)||e===BigInt(1)}n.ecsign=function(e,n,s){const a=r.secp256k1.sign(e,n),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:s===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(s)*BigInt(2)}};n.ecrecover=function(e,n,s,o,i){const d=t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(o,32)],64),u=c(n,i);if(!m(u))throw new Error("Invalid signature v value");const l=r.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};n.toRpcSig=function(e,n,s,r){if(!m(c(e,r)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(s,32),(0,a.toBuffer)(e)]))};n.toCompactSig=function(e,n,s,r){if(!m(c(e,r)))throw new Error("Invalid signature v value");let o=s;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(s),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(o,32)]))};n.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let n,s,r;if(t.length>=65)n=t.slice(0,32),s=t.slice(32,64),r=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");n=t.slice(0,32),s=t.slice(32,64),r=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),s[0]&=127}return r<27&&(r+=BigInt(27)),{v:r,r:n,s:s}};n.isValidSignature=function(e,t,n,s=!0,r){if(32!==t.length||32!==n.length)return!1;if(!m(c(e,r)))return!1;const i=(0,a.bufferToBigInt)(t),d=(0,a.bufferToBigInt)(n);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||d===BigInt(0)||d>=o.SECP256K1_ORDER)&&!(s&&d>=o.SECP256K1_ORDER_DIV_2)};n.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const n=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,s.keccak256)(t.concat([n,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toType=n.TypeOutput=void 0;const s=e("./bytes"),r=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=n.TypeOutput||(n.TypeOutput={})),n.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,r.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const n=(0,s.toBuffer)(e);switch(t){case a.Buffer:return n;case a.BigInt:return(0,s.bufferToBigInt)(n);case a.Number:{const e=(0,s.bufferToBigInt)(n);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,s.bufferToHex)(n);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.GWEI_TO_WEI=void 0,n.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Withdrawal=void 0;const s=e("./address"),r=e("./bytes"),a=e("./types");class o{constructor(e,t,n,s){this.index=e,this.validatorIndex=t,this.address=n,this.amount=s}static fromWithdrawalData(e){const{index:t,validatorIndex:n,address:r,amount:i}=e,c=(0,a.toType)(t,a.TypeOutput.BigInt),m=(0,a.toType)(n,a.TypeOutput.BigInt),d=new s.Address((0,a.toType)(r,a.TypeOutput.Buffer)),u=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(c,m,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,n,s,r]=e;return o.fromWithdrawalData({index:t,validatorIndex:n,address:s,amount:r})}static toBufferArray(e){const{index:n,validatorIndex:r,address:o,amount:i}=e,c=(0,a.toType)(n,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(n,a.TypeOutput.Buffer),m=(0,a.toType)(r,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(r,a.TypeOutput.Buffer);let d;d=o instanceof s.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[c,m,d,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,r.bigIntToHex)(this.index),validatorIndex:(0,r.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,r.bigIntToHex)(this.amount)}}}n.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function r(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,n=(e,t)=>n=>e(t(n));return{encode:e.map(e=>e.encode).reduceRight(n,t),decode:e.map(e=>e.decode).reduce(n,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map(t=>{if(s(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]})},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map(t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const n=e.indexOf(t);if(-1===n)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return n})}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(s(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(n){if(!Array.isArray(n)||n.length&&"string"!=typeof n[0])throw new Error("padding.encode input should be array of strings");for(let e of n)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;n.length*e%8;)n.push(t);return n},decode(n){if(!Array.isArray(n)||n.length&&"string"!=typeof n[0])throw new Error("padding.encode input should be array of strings");for(let e of n)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let s=n.length;if(s*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;s>0&&n[s-1]===t;s--)if(!((s-1)*e%8))throw new Error("Invalid padding: string has too much padding");return n.slice(0,s)}}}function m(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function d(e,t,n){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(n<2)throw new Error(`convertRadix: wrong to=${n}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let r=0;const a=[],o=Array.from(e);for(o.forEach(e=>{if(s(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)});;){let e=0,s=!0;for(let a=r;a<o.length;a++){const i=o[a],c=t*e+i;if(!Number.isSafeInteger(c)||t*e/t!==e||c-i!==t*e)throw new Error("convertRadix: carry overflow");e=c%n;const m=Math.floor(c/n);if(o[a]=m,!Number.isSafeInteger(m)||m*n+e!==c)throw new Error("convertRadix: carry overflow");s&&(m?s=!1:r=a)}if(a.push(e),s)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(n,"__esModule",{value:!0}),n.bytes=n.stringToBytes=n.str=n.bytesToString=n.hex=n.utf8=n.bech32m=n.bech32=n.base58check=n.createBase58check=n.base58xmr=n.base58xrp=n.base58flickr=n.base58=n.base64urlnopad=n.base64url=n.base64nopad=n.base64=n.base32crockford=n.base32hexnopad=n.base32hex=n.base32nopad=n.base32=n.base16=n.utils=void 0,n.assertNumber=s;const u=(e,t)=>t?u(t,e%t):e,l=(e,t)=>e+(t-u(e,t));function h(e,t,n,r){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(n<=0||n>32)throw new Error(`convertRadix2: wrong to=${n}`);if(l(t,n)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${n} carryBits=${l(t,n)}`);let a=0,o=0;const i=2**n-1,c=[];for(const r of e){if(s(r),r>=2**t)throw new Error(`convertRadix2: invalid data word=${r} from=${t}`);if(a=a<<t|r,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=n;o-=n)c.push((a>>o-n&i)>>>0);a&=2**o-1}if(a=a<<n-o&i,!r&&o>=t)throw new Error("Excess padding");if(!r&&a)throw new Error(`Non-zero padding: ${a}`);return r&&o>0&&c.push(a>>>0),c}function p(e){return s(e),{encode:t=>{if(!r(t))throw new Error("radix.encode input should be Uint8Array");return d(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(d(t,e,256))}}}function f(e,t=!1){if(s(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(l(8,e)>32||l(e,8)>32)throw new Error("radix2: carry overflow");return{encode:n=>{if(!r(n))throw new Error("radix2.encode input should be Uint8Array");return h(Array.from(n),8,e,!t)},decode:n=>{if(!Array.isArray(n)||n.length&&"number"!=typeof n[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(h(n,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function y(e,t){if(s(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(n){if(!r(n))throw new Error("checksum.encode: input should be Uint8Array");const s=t(n).slice(0,e),a=new Uint8Array(n.length+e);return a.set(n),a.set(s,n.length),a},decode(n){if(!r(n))throw new Error("checksum.decode: input should be Uint8Array");const s=n.slice(0,-e),a=t(s).slice(0,e),o=n.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return s}}}n.utils={alphabet:o,chain:a,checksum:y,convertRadix:d,convertRadix2:h,radix:p,radix2:f,join:i,padding:c},n.base16=a(f(4),o("0123456789ABCDEF"),i("")),n.base32=a(f(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),i("")),n.base32nopad=a(f(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),n.base32hex=a(f(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),i("")),n.base32hexnopad=a(f(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),n.base32crockford=a(f(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),m(e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1"))),n.base64=a(f(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),i("")),n.base64nopad=a(f(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),n.base64url=a(f(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),i("")),n.base64urlnopad=a(f(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const k=e=>a(p(58),o(e),i(""));n.base58=k("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),n.base58flickr=k("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),n.base58xrp=k("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const b=[0,2,3,5,6,7,9,10,11];n.base58xmr={encode(e){let t="";for(let s=0;s<e.length;s+=8){const r=e.subarray(s,s+8);t+=n.base58.encode(r).padStart(b[r.length],"1")}return t},decode(e){let t=[];for(let s=0;s<e.length;s+=11){const r=e.slice(s,s+11),a=b.indexOf(r.length),o=n.base58.decode(r);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};n.createBase58check=e=>a(y(4,t=>e(e(t))),n.base58),n.base58check=n.createBase58check;const x=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),w=[996825010,642813549,513874426,1027748829,705979059];function _(e){const t=e>>25;let n=(33554431&e)<<5;for(let e=0;e<w.length;e++)1==(t>>e&1)&&(n^=w[e]);return n}function v(e,t,n=1){const s=e.length;let r=1;for(let t=0;t<s;t++){const n=e.charCodeAt(t);if(n<33||n>126)throw new Error(`Invalid prefix (${e})`);r=_(r)^n>>5}r=_(r);for(let t=0;t<s;t++)r=_(r)^31&e.charCodeAt(t);for(let e of t)r=_(r)^e;for(let e=0;e<6;e++)r=_(r);return r^=n,x.encode(h([r%2**30],30,5,!1))}function E(e){const t="bech32"===e?1:734539939,n=f(5),s=n.decode,r=n.encode,a=g(s);function o(e,n,s=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(n instanceof Uint8Array&&(n=Array.from(n)),!Array.isArray(n)||n.length&&"number"!=typeof n[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof n);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const r=e.length+7+n.length;if(!1!==s&&r>s)throw new TypeError(`Length ${r} exceeds limit ${s}`);const a=e.toLowerCase(),o=v(a,n,t);return`${a}1${x.encode(n)}${o}`}function i(e,n=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==n&&e.length>n)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${n})`);const s=e.toLowerCase();if(e!==s&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const r=s.lastIndexOf("1");if(0===r||-1===r)throw new Error('Letter "1" must be present between prefix and data only');const a=s.slice(0,r),o=s.slice(r+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=x.decode(o).slice(0,-6),c=v(a,i,t);if(!o.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,r(t))},decodeToBytes:function(e){const{prefix:t,words:n}=i(e,!1);return{prefix:t,words:n,bytes:s(n)}},decodeUnsafe:g(i),fromWords:s,fromWordsUnsafe:a,toWords:r}}n.bech32=E("bech32"),n.bech32m=E("bech32m"),n.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},n.hex=a(f(4),o("0123456789abcdef"),i(""),m(e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()}));const T={utf8:n.utf8,hex:n.hex,base16:n.base16,base32:n.base32,base64:n.base64,base64url:n.base64url,base58:n.base58,base58xmr:n.base58xmr},j="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";n.bytesToString=(e,t)=>{if("string"!=typeof e||!T.hasOwnProperty(e))throw new TypeError(j);if(!r(t))throw new TypeError("bytesToString() expects Uint8Array");return T[e].encode(t)},n.str=n.bytesToString;n.stringToBytes=(e,t)=>{if(!T.hasOwnProperty(e))throw new TypeError(j);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return T[e].decode(t)},n.bytes=n.stringToBytes}}},{package:"@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/index.cjs",{"./simple-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=e("./simple-keyring.cjs");Object.defineProperty(n,"default",{enumerable:!0,get:function(){return s(r).default}})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js",randombytes:"/home/runner/work/metamask-extension/metamask-extension/node_modules/randombytes/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var s,r,a,o,i=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},c=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},m=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0});const d=e("@ethereumjs/util"),u=e("@metamask/eth-sig-util"),l=e("@metamask/utils"),h=e("ethereum-cryptography/keccak"),p=m(e("randombytes")),f="Simple Key Pair";class g{constructor(e=[]){s.add(this),r.set(this,void 0),this.type=f,i(this,r,[],"f"),this.deserialize(e).catch(e=>{throw new Error(`Problem deserializing SimpleKeyring ${e.message}`)})}async serialize(){return c(this,r,"f").map(e=>e.privateKey.toString("hex"))}async deserialize(e){i(this,r,e.map(e=>{const n=(0,d.stripHexPrefix)(e),s=t.from(n,"hex");return{privateKey:s,publicKey:t.from((0,d.privateToPublic)(s))}}),"f")}async addAccounts(e=1){const n=[];for(let s=0;s<e;s++){const e=y(),s=t.from((0,d.privateToPublic)(e));n.push({privateKey:e,publicKey:s})}i(this,r,c(this,r,"f").concat(n),"f");return n.map(({publicKey:e})=>(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(e))))}async getAccounts(){return c(this,r,"f").map(({publicKey:e})=>(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(e))))}async signTransaction(e,t,n={}){const r=c(this,s,"m",a).call(this,e,n);return t.sign(r)??t}async signEip7702Authorization(e,t,n={}){const r=c(this,s,"m",a).call(this,e,n);return(0,u.signEIP7702Authorization)({privateKey:r,authorization:t})}async signMessage(e,n,r={withAppKeyOrigin:"",validateMessage:!0}){const o=(0,d.stripHexPrefix)(n);if(r.validateMessage&&(0===o.length||!o.match(/^[a-fA-F0-9]*$/u)))throw new Error("Cannot sign invalid message");const i=c(this,s,"m",a).call(this,e,r),m=(0,d.ecsign)(t.from(o,"hex"),i);return(0,u.concatSig)(t.from((0,l.bigIntToBytes)(m.v)),t.from(m.r),t.from(m.s))}async signPersonalMessage(e,t,n={withAppKeyOrigin:""}){const r=c(this,s,"m",a).call(this,e,n);return(0,u.personalSign)({privateKey:r,data:t})}async decryptMessage(e,t){const n=c(this,s,"m",o).call(this,e).privateKey.toString("hex");return(0,u.decrypt)({privateKey:n,encryptedData:t})}async signTypedData(e,t,n){let{version:r}=n??{version:u.SignTypedDataVersion.V1};r&&function(e){return e in u.SignTypedDataVersion}(r)||(r=u.SignTypedDataVersion.V1);const o=c(this,s,"m",a).call(this,e,n);return(0,u.signTypedData)({privateKey:o,data:t,version:r})}async getEncryptionPublicKey(e,t){const n=c(this,s,"m",a).call(this,e,t);return(0,u.getEncryptionPublicKey)(n.toString("hex"))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const n=c(this,s,"m",o).call(this,e,{withAppKeyOrigin:t});return(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(n.publicKey)))}async exportAccount(e,t={withAppKeyOrigin:""}){return c(this,s,"m",o).call(this,e,t).privateKey.toString("hex")}removeAccount(e){if(!c(this,r,"f").map(({publicKey:e})=>(0,l.bytesToHex)((0,d.publicToAddress)(e)).toLowerCase()).includes(e.toLowerCase()))throw new Error(`Address ${e} not found in this keyring`);i(this,r,c(this,r,"f").filter(({publicKey:t})=>(0,l.bytesToHex)((0,d.publicToAddress)(t)).toLowerCase()!==e.toLowerCase()),"f")}}function y(){const e=(0,p.default)(32);if(!(0,d.isValidPrivate)(e))throw new Error("Private key does not satisfy the curve requirements (ie. it is invalid)");return e}r=new WeakMap,s=new WeakSet,a=function(e,t={withAppKeyOrigin:""}){if(!e)throw new Error("Must specify address.");return c(this,s,"m",o).call(this,e,t).privateKey},o=function(e,n={}){const s=(0,u.normalize)(e);let a=c(this,r,"f").find(({publicKey:e})=>(0,l.bytesToHex)((0,d.publicToAddress)(e))===s);if(!a)throw new Error("Simple Keyring - Unable to find matching address.");if(n.withAppKeyOrigin){const{privateKey:e}=a,s=t.from(n.withAppKeyOrigin,"utf8"),r=t.concat([e,s]),o=(0,h.keccak256)(r),i=(0,d.privateToPublic)(o);a={privateKey:t.from(o),publicKey:t.from(i)}}return a},g.type=f,n.default=g}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/CaseInsensitiveMap.cjs",{"./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/util.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CaseInsensitiveMap=void 0;const s=e("./util.cjs");class r extends Map{static fromObject(e){return new r(Object.entries(e))}toObject(){return Object.fromEntries(this.entries())}get(e){return super.get(e.toLowerCase())}getOrThrow(e,t="Key"){return this.get(e)??(0,s.throwError)(`${t} '${e}' not found`)}has(e){return super.has(e.toLowerCase())}set(e,t){return super.set(e.toLowerCase(),t)}delete(e){return super.delete(e.toLowerCase())}}n.CaseInsensitiveMap=r}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/CaseInsensitiveMap.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/DeferredPromise.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DeferredPromise=void 0;n.DeferredPromise=class{constructor(){if(this.resolve=undefined,this.reject=undefined,this.promise=new Promise((e,t)=>{this.resolve=e,this.reject=t}),!this.resolve||!this.reject)throw new Error("Promise constructor failed")}}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/DeferredPromise.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapIdMap.cjs",{"./CaseInsensitiveMap.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/CaseInsensitiveMap.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},a=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.SnapIdMap=n.InvalidSnapIdError=void 0;const o=e("./CaseInsensitiveMap.cjs");class i extends Error{constructor(e,t){super(`Snap "${e}" is not allowed to set "${t}"`),this.name="InvalidSnapIdError",this.snapId=e,this.key=t}}n.InvalidSnapIdError=i;class c{constructor(e){s.set(this,void 0),r(this,s,new o.CaseInsensitiveMap(e),"f")}toObject(){return a(this,s,"f").toObject()}static fromObject(e){return new c(Object.entries(e))}get(e,t){const n=a(this,s,"f").get(t);return n?.snapId===e?n:undefined}pop(e,t){const n=this.get(e,t);return this.delete(e,t),n}has(e,t){return this.get(e,t)!==undefined}hasSnapId(e){return[...a(this,s,"f").values()].some(t=>t.snapId===e)}delete(e,t){return this.has(e,t)&&a(this,s,"f").delete(t)}set(e,t){if(a(this,s,"f").has(e)&&!this.has(t.snapId,e))throw new i(t.snapId,e);return a(this,s,"f").set(e,t),this}values(){return a(this,s,"f").values()}get size(){return a(this,s,"f").size}}n.SnapIdMap=c,s=new WeakMap}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/SnapIdMap.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapKeyring.cjs",{"./DeferredPromise.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/DeferredPromise.cjs","./SnapIdMap.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapIdMap.cjs","./account.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs","./events.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/events.cjs","./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/logger.cjs","./migrations/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs","./options.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/options.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/types.cjs","./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/util.cjs","./versions.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/versions.cjs","@ethereumjs/tx":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/tx/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-internal-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/index.cjs","@metamask/keyring-internal-snap-client":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-snap-client/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i,c,m,d,u,l,h,p,f,g,y,k,b,x,w,_,v,E,T,j,A,C,P,B,S,I,D,R,O,F,M,N=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},q=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.SnapKeyring=n.SNAP_KEYRING_TYPE=void 0;const K=e("@ethereumjs/tx"),U=e("@metamask/eth-sig-util"),L=e("@metamask/keyring-api"),$=e("@metamask/keyring-internal-api"),H=e("@metamask/keyring-internal-snap-client"),G=e("@metamask/keyring-utils"),V=e("@metamask/superstruct"),W=e("@metamask/utils"),z=e("events"),Y=e("uuid"),J=e("./account.cjs"),X=e("./DeferredPromise.cjs"),Q=e("./events.cjs"),Z=e("./logger.cjs"),ee=e("./migrations/index.cjs"),te=e("./options.cjs"),ne=e("./SnapIdMap.cjs"),se=e("./types.cjs"),re=e("./util.cjs"),ae=e("./versions.cjs");function oe(e){return(0,L.isEvmAccountType)(e.type)?e.address.toLowerCase():e.address}n.SNAP_KEYRING_TYPE="Snap Keyring";class ie extends z.EventEmitter{constructor({messenger:e,callbacks:t,isAnyAccountTypeAllowed:n=!1}){super(),s.add(this),r.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),c.set(this,void 0),m.set(this,void 0),d.set(this,void 0),this.type=ie.type,N(this,r,e,"f"),N(this,a,new H.KeyringInternalSnapClient({messenger:e}),"f"),N(this,i,new ne.SnapIdMap,"f"),N(this,o,new ne.SnapIdMap,"f"),N(this,c,new ne.SnapIdMap,"f"),N(this,m,t,"f"),N(this,d,n,"f")}async handleKeyringSnapMessage(e,t){switch((0,V.assert)(t,se.SnapMessageStruct),t.method){case`${L.KeyringEvent.AccountCreated}`:return q(this,s,"m",h).call(this,e,t);case`${L.KeyringEvent.AccountUpdated}`:return q(this,s,"m",p).call(this,e,t);case`${L.KeyringEvent.AccountDeleted}`:return q(this,s,"m",f).call(this,e,t);case`${L.KeyringEvent.RequestApproved}`:return q(this,s,"m",g).call(this,e,t);case`${L.KeyringEvent.RequestRejected}`:return q(this,s,"m",y).call(this,e,t);case`${L.KeyringEvent.AccountBalancesUpdated}`:return q(this,s,"m",b).call(this,e,t);case`${L.KeyringEvent.AccountAssetListUpdated}`:return q(this,s,"m",x).call(this,e,t);case`${L.KeyringEvent.AccountTransactionsUpdated}`:return q(this,s,"m",w).call(this,e,t);default:throw new Error(`Method not supported: ${t.method}`)}}async serialize(){return{accounts:q(this,o,"f").toObject()}}async deserialize(e){if(e===undefined)return;const t={};for(const[n,s]of Object.entries(e.accounts))(0,ee.isAccountV1)(s.account)?(console.info(`SnapKeyring - Found a KeyringAccountV1, migrating to V2: ${s.account.id}`),t[n]={...s,account:(0,ee.migrateAccountV1)(s.account)}):t[n]=s;N(this,o,ne.SnapIdMap.fromObject(t),"f")}async getAccounts(){return(0,re.unique)([...q(this,o,"f").values()].map(({account:e})=>oe(e)))}async getAccountsBySnapId(e){return(0,re.unique)([...q(this,o,"f").values()].filter(({snapId:t})=>t===e).map(({account:e})=>oe(e)))}async createAccount(e,t,n){const s=new H.KeyringInternalSnapClient({messenger:q(this,r,"f"),snapId:e}),a="metamask";if((0,W.hasProperty)(t,a))throw new Error(`The '${a}' property is reserved for internal use`);if(!n)return await s.createAccount(t);const o=(0,Y.v4)();return q(this,c,"f").set(o,{snapId:e,options:n}),await s.createAccount({...t,metamask:{correlationId:o}})}hasSnapId(e){return q(this,o,"f").hasSnapId(e)}async resolveAccountAddress(e,t,n){if(!this.hasSnapId(e))throw new Error(`Unable to resolve account address: unknown Snap ID: ${e}`);return await q(this,a,"f").withSnapId(e).resolveAccountAddress(t,n)}async submitRequest({origin:e,account:t,method:n,params:r,scope:a}){const{account:o,snapId:i}=q(this,s,"m",_).call(this,t);return await q(this,s,"m",T).call(this,{origin:e,snapId:i,account:o,method:n,params:r,scope:a,noPending:!0})}async signTransaction(e,t,n={}){const r=t.common.chainId(),a=(0,re.toJson)({...t.toJSON(),from:e,type:`0x${t.type.toString(16)}`,chainId:(0,W.bigIntToHex)(r)}),o=await q(this,s,"m",v).call(this,{origin:"metamask",address:e,method:L.EthMethod.SignTransaction,params:[a],scope:(0,W.toCaipChainId)(W.KnownCaipNamespace.Eip155,`${r}`)}),i=(0,V.mask)(o,(0,V.object)({r:(0,V.string)(),s:(0,V.string)(),v:(0,V.string)()}));return K.TransactionFactory.fromTxData({...a,r:i.r,s:i.s,v:i.v})}async signTypedData(e,t,n={version:U.SignTypedDataVersion.V1}){const r={[U.SignTypedDataVersion.V1]:L.EthMethod.SignTypedDataV1,[U.SignTypedDataVersion.V3]:L.EthMethod.SignTypedDataV3,[U.SignTypedDataVersion.V4]:L.EthMethod.SignTypedDataV4}[n.version]||L.EthMethod.SignTypedDataV1,a=t.domain?.chainId;return(0,G.strictMask)(await q(this,s,"m",v).call(this,{origin:"metamask",address:e,method:r,params:(0,re.toJson)([e,t]),...a===undefined?{}:{scope:(0,W.toCaipChainId)(W.KnownCaipNamespace.Eip155,`${a}`)}}),L.EthBytesStruct)}async signMessage(e,t){return(0,G.strictMask)(await q(this,s,"m",v).call(this,{origin:"metamask",address:e,method:L.EthMethod.Sign,params:(0,re.toJson)([e,t])}),L.EthBytesStruct)}async signPersonalMessage(e,t){return(0,G.strictMask)(await q(this,s,"m",v).call(this,{origin:"metamask",address:e,method:L.EthMethod.PersonalSign,params:(0,re.toJson)([t,e])}),L.EthBytesStruct)}async prepareUserOperation(e,t,n){return(0,G.strictMask)(await q(this,s,"m",v).call(this,{origin:"metamask",address:e,method:L.EthMethod.PrepareUserOperation,params:(0,re.toJson)(t),noPending:!0,scope:(0,W.toCaipChainId)(W.KnownCaipNamespace.Eip155,n.chainId)}),L.EthBaseUserOperationStruct)}async patchUserOperation(e,t,n){return(0,G.strictMask)(await q(this,s,"m",v).call(this,{origin:"metamask",address:e,method:L.EthMethod.PatchUserOperation,params:(0,re.toJson)([t]),noPending:!0,scope:(0,W.toCaipChainId)(W.KnownCaipNamespace.Eip155,n.chainId)}),L.EthUserOperationPatchStruct)}async signUserOperation(e,t,n){return(0,G.strictMask)(await q(this,s,"m",v).call(this,{origin:"metamask",address:e,method:L.EthMethod.SignUserOperation,params:(0,re.toJson)([t]),scope:(0,W.toCaipChainId)(W.KnownCaipNamespace.Eip155,n.chainId)}),L.EthBytesStruct)}exportAccount(e){throw new Error("Exporting accounts from snaps is not supported.")}async removeAccount(e){const{account:t,snapId:n}=q(this,s,"m",R).call(this,e);await q(this,s,"m",D).call(this,n,t)}getAccountByAddress(e){return this.listAccounts().find(({address:t})=>(0,re.equalsIgnoreCase)(t,e))}listAccounts(){return[...q(this,o,"f").values()].map(({account:e,snapId:t})=>{const n=q(this,s,"m",F).call(this,t);return{...e,address:oe(e),metadata:{name:"",importTime:0,keyring:{type:this.type},...n!==undefined&&{snap:n}}}})}}n.SnapKeyring=ie,r=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,c=new WeakMap,m=new WeakMap,d=new WeakMap,s=new WeakSet,u=function(e){return(0,ae.getKeyringVersionFromPlatform)(t=>q(this,r,"f").call("SnapController:isMinimumPlatformVersion",e,t))},l=function(e,t){if(t){const n=q(this,c,"f").pop(e,t);if(n)return n.options;console.warn(`SnapKeyring - Received unmapped correlation ID: "${t}"`)}return undefined},h=async function(e,t){(0,V.assert)(t,Q.AccountCreatedEventStruct);const{metamask:n,account:r,accountNameSuggestion:a,displayAccountNameSuggestion:i,displayConfirmation:c}=t.params,u=(0,J.transformAccount)(r);if(!q(this,d,"f")&&u.type===L.AnyAccountType.Account)throw new Error(`Cannot create generic account '${u.id}'`);const h=oe(u);if(await q(this,m,"f").addressExists(h))throw new Error(`Account address '${h}' already exists`);if(q(this,o,"f").has(e,u.id))throw new Error(`Account '${u.id}' already exists`);const p=new X.DeferredPromise;return await q(this,m,"f").addAccount(h,e,async t=>{t&&(q(this,o,"f").set(u.id,{account:u,snapId:e}),q(this,m,"f").saveState().then(()=>{p.resolve(u.id)}).catch(async t=>{await q(this,s,"m",D).call(this,e,u),p.reject(t)}))},p.promise,a,(0,te.getInternalOptionsOf)([q(this,s,"m",l).call(this,e,n?.correlationId)??{},{displayConfirmation:c,displayAccountNameSuggestion:i}])),null},p=async function(e,t){(0,V.assert)(t,Q.AccountUpdatedEventStruct);const{account:n}=t.params,{account:s}=q(this,o,"f").get(e,n.id)??(0,re.throwError)(`Account '${n.id}' not found`),r=(0,J.transformAccount)(n),a=r.type===L.AnyAccountType.Account||s.type===L.AnyAccountType.Account;if(!q(this,d,"f")&&a)throw new Error(`Cannot update generic account '${r.id}'`);if(!(0,re.equalsIgnoreCase)(s.address,r.address))throw new Error(`Cannot change address of account '${r.id}'`);return q(this,o,"f").set(r.id,{account:r,snapId:e}),await q(this,m,"f").saveState(),null},f=async function(e,t){(0,V.assert)(t,Q.AccountDeletedEventStruct);const{id:n}=t.params,s=q(this,o,"f").get(e,n);if(s===undefined)return null;const{account:r}=s;return await q(this,m,"f").removeAccount(oe(r),e,async e=>{e&&await q(this,m,"f").saveState()}),null},g=async function(e,t){(0,V.assert)(t,Q.RequestApprovedEventStruct);const{id:n,result:s}=t.params,{promise:r}=q(this,i,"f").get(e,n)??(0,re.throwError)(`Request '${n}' not found`);return q(this,i,"f").delete(e,n),r.resolve(s),null},y=async function(e,t){(0,V.assert)(t,Q.RequestRejectedEventStruct);const{id:n}=t.params,{promise:s}=q(this,i,"f").get(e,n)??(0,re.throwError)(`Request '${n}' not found`);return q(this,i,"f").delete(e,n),s.reject(new Error("Request rejected by user or snap.")),null},k=async function(e,t,n){return q(this,r,"f").publish(t,...n(n=>Object.entries(n).reduce((n,[s,r])=>(q(this,o,"f").has(e,s)?n[s]=r:console.warn(`SnapKeyring - ${t} - Found an unknown account ID "${s}" for Snap ID "${e}". Skipping.`),n),{}))),null},b=async function(e,t){(0,V.assert)(t,L.AccountBalancesUpdatedEventStruct);const n=t.params;return q(this,s,"m",k).call(this,e,"SnapKeyring:accountBalancesUpdated",e=>(n.balances=e(n.balances),[n]))},x=async function(e,t){(0,V.assert)(t,L.AccountAssetListUpdatedEventStruct);const n=t.params;return q(this,s,"m",k).call(this,e,"SnapKeyring:accountAssetListUpdated",e=>(n.assets=e(n.assets),[n]))},w=async function(e,t){(0,V.assert)(t,L.AccountTransactionsUpdatedEventStruct);const n=t.params;return q(this,s,"m",k).call(this,e,"SnapKeyring:accountTransactionsUpdated",e=>(n.transactions=e(n.transactions),[n]))},_=function(e){const t=[...q(this,o,"f").values()].find(t=>t.account.id===e);if(!t)throw new Error(`Unable to get account: unknown account ID: '${e}'`);return t},v=async function({origin:e,address:t,method:n,params:r,scope:a="",noPending:o=!1}){const{account:i,snapId:c}=q(this,s,"m",R).call(this,t);return await q(this,s,"m",T).call(this,{origin:e,snapId:c,account:i,method:n,params:r,scope:a,noPending:o})},E=async function({snapId:e,version:t,request:n}){const s=q(this,a,"f").withSnapId(e);return t===$.KeyringVersion.V1?await s.submitRequestV1((0,$.toKeyringRequestV1)(n)):await s.submitRequest(n)},T=async function({origin:e,snapId:t,account:n,method:r,params:a,scope:o,noPending:i}){if(!q(this,s,"m",j).call(this,n,r))throw new Error(`Method '${r}' not supported for account ${n.address}`);if(!e?.trim())throw new Error("An `origin` is required");const c=(0,Y.v4)(),m=q(this,s,"m",A).call(this,c,t);try{const d=q(this,s,"m",u).call(this,t),l={id:c,origin:e,scope:o,account:n.id,request:{method:r,...a!==undefined&&{params:a}}};(0,Z.projectLogger)("Submit Snap request: ",l);const h=await q(this,s,"m",E).call(this,{version:d,snapId:t,request:l});if(i&&h.pending)throw new Error(`Request '${c}' to Snap '${t}' is pending and noPending is true.`);return h.pending?((h.redirect?.message||h.redirect?.url)&&await q(this,s,"m",B).call(this,h.redirect,t),m.promise):q(this,s,"m",P).call(this,h,c,t)}catch(e){throw(0,Z.projectLogger)("Snap Request failed: ",{requestId:c}),q(this,s,"m",C).call(this,c,t),e}},j=function(e,t){return e.methods.includes(t)},A=function(e,t){const n=new X.DeferredPromise;return q(this,i,"f").set(e,{promise:n,snapId:t}),n},C=function(e,t){q(this,i,"f").delete(t,e)},P=function(e,t,n){return q(this,i,"f").delete(n,t),e.result},B=async function(e,t){const{message:n="",url:r=""}=e,a=q(this,s,"m",S).call(this,r);a&&q(this,s,"m",I).call(this,a,t),await q(this,m,"f").redirectUser(t,a,n)},S=function(e){return e?(0,re.sanitizeUrl)(e):e},I=function(e,t){const{origin:n}=new URL(e),r=q(this,s,"m",O).call(this,t);if(!r)throw new Error(`Snap '${t}' not found.`);if(!q(this,s,"m",M).call(this,r).includes(n))throw new Error(`Redirect URL domain '${n}' is not an allowed origin by snap '${t}'`)},D=async function(e,t){q(this,o,"f").delete(e,t.id);try{await q(this,a,"f").withSnapId(e).deleteAccount(t.id)}catch(n){console.error(`Account '${t.address}' may not have been removed from snap '${e}':`,n)}},R=function(e){return[...q(this,o,"f").values()].find(({account:t})=>(0,re.equalsIgnoreCase)(t.address,e))??(0,re.throwError)(`Account '${e}' not found`)},O=function(e){return q(this,r,"f").call("SnapController:get",e)},F=function(e){const t=q(this,s,"m",O).call(this,e);return t?{id:e,name:t.manifest.proposedName,enabled:t.enabled}:undefined},M=function(e){return e.manifest.initialPermissions["endowment:keyring"]?.allowedOrigins??[]},ie.type=n.SNAP_KEYRING_TYPE}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/SnapKeyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs",{"./migrations/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountV1Struct=void 0,n.assertKeyringAccount=o,n.transformAccount=function(e){return o((0,a.isAccountV1)(e)?(0,a.transformAccountV1)(e):e)};const s=e("@metamask/keyring-api"),r=e("@metamask/superstruct"),a=e("./migrations/index.cjs");function o(e){switch(e.type){case s.BtcAccountType.P2pkh:return(0,r.assert)(e,s.BtcP2pkhAccountStruct),e;case s.BtcAccountType.P2sh:return(0,r.assert)(e,s.BtcP2shAccountStruct),e;case s.BtcAccountType.P2wpkh:return(0,r.assert)(e,s.BtcP2wpkhAccountStruct),e;case s.BtcAccountType.P2tr:return(0,r.assert)(e,s.BtcP2trAccountStruct),e;case s.SolAccountType.DataAccount:return(0,r.assert)(e,s.SolDataAccountStruct),e;case s.EthAccountType.Erc4337:return(0,r.assert)(e,s.EthErc4337AccountStruct),e;case s.EthAccountType.Eoa:return(0,r.assert)(e,s.EthEoaAccountStruct),e;case s.TrxAccountType.Eoa:return(0,r.assert)(e,s.TrxEoaAccountStruct),e;case s.AnyAccountType.Account:return(0,r.assert)(e,s.KeyringAccountStruct),e;default:throw new Error(`Unknown account type: '${e.type}'`)}}n.KeyringAccountV1Struct=(0,r.omit)(s.KeyringAccountStruct,["scopes"])}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/account.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/events.cjs",{"./account.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RequestRejectedEventStruct=n.RequestApprovedEventStruct=n.AccountDeletedEventStruct=n.AccountUpdatedEventStruct=n.AccountCreatedEventStruct=void 0;const s=e("@metamask/keyring-api");Object.defineProperty(n,"AccountDeletedEventStruct",{enumerable:!0,get:function(){return s.AccountDeletedEventStruct}}),Object.defineProperty(n,"RequestApprovedEventStruct",{enumerable:!0,get:function(){return s.RequestApprovedEventStruct}}),Object.defineProperty(n,"RequestRejectedEventStruct",{enumerable:!0,get:function(){return s.RequestRejectedEventStruct}});const r=e("@metamask/keyring-utils"),a=e("@metamask/superstruct"),o=e("./account.cjs");n.AccountCreatedEventStruct=(0,r.object)({...s.AccountCreatedEventStruct.schema,params:(0,r.object)({...s.AccountCreatedEventStruct.schema.params.schema,account:(0,a.union)([o.KeyringAccountV1Struct,s.KeyringAccountStruct])})}),n.AccountUpdatedEventStruct=(0,r.object)({...s.AccountUpdatedEventStruct.schema,params:(0,r.object)({...s.AccountUpdatedEventStruct.schema.params.schema,account:(0,a.union)([o.KeyringAccountV1Struct,s.KeyringAccountStruct])})})}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/events.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/index.cjs",{"./SnapKeyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/SnapKeyring.cjs","./options.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/options.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./options.cjs"),n),r(e("./types.cjs"),n),r(e("./SnapKeyring.cjs"),n)}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return s.createModuleLogger}}),n.projectLogger=(0,s.createProjectLogger)("eth-snap-keyring")}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs",{"./v1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/v1.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./v1.cjs"),n)}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/migrations/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/migrations/v1.cjs",{"../account.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/account.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isAccountV1=i,n.getScopesForAccountV1=c,n.transformAccountV1=function(e){const{type:t}=e;if(t===s.EthAccountType.Eoa)return{...e,scopes:c(e)};return(0,o.assertKeyringAccount)(e)},n.migrateAccountV1=function(e){if(!i(e))return e;return{...e,scopes:c(e)}};const s=e("@metamask/keyring-api"),r=e("@metamask/keyring-utils"),a=e("@metamask/superstruct"),o=e("../account.cjs");function i(e){return(0,a.is)(e,o.KeyringAccountV1Struct)}function c(e){switch(e.type){case s.EthAccountType.Eoa:return[s.EthScope.Eoa];case s.EthAccountType.Erc4337:return[s.EthScope.Testnet];case s.BtcAccountType.P2pkh:case s.BtcAccountType.P2sh:case s.BtcAccountType.P2wpkh:case s.BtcAccountType.P2tr:return[(0,r.isBtcMainnetAddress)(e.address)?s.BtcScope.Mainnet:s.BtcScope.Testnet];case s.SolAccountType.DataAccount:return[s.SolScope.Mainnet,s.SolScope.Testnet,s.SolScope.Devnet];case s.TrxAccountType.Eoa:return[s.TrxScope.Mainnet,s.TrxScope.Nile,s.TrxScope.Shasta];default:return[s.EthScope.Eoa]}}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/migrations/v1.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/options.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(){return{displayAccountNameSuggestion:!0,displayConfirmation:!0,setSelectedAccount:!0}}Object.defineProperty(n,"__esModule",{value:!0}),n.getDefaultInternalOptions=s,n.getInternalOptionsOf=function(e){const t={},n={displayAccountNameSuggestion:!0,displayConfirmation:!0,setSelectedAccount:!0},s=Object.keys(n);for(const r of s){t[r]=undefined;for(const s of[...e,n])s[r]!==undefined&&t[r]===undefined&&(t[r]=s[r])}return t}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/options.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/types.cjs",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SnapMessageStruct=void 0;const s=e("@metamask/superstruct"),r=e("@metamask/utils");n.SnapMessageStruct=(0,s.object)({method:(0,s.string)(),params:(0,s.optional)((0,s.union)([(0,s.array)(r.JsonStruct),(0,s.record)((0,s.string)(),r.JsonStruct)]))})}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/util.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.unique=function(e){return[...new Set(e)]},n.toJson=function(e){return JSON.parse(JSON.stringify(e))},n.ensureDefined=function(e){if(e===undefined)throw new Error("Argument is undefined")},n.throwError=function(e){throw new Error(e)},n.equalsIgnoreCase=function(e,t){return e.toLowerCase()===t.toLowerCase()},n.sanitizeUrl=function(e){return new URL(e).toString()}}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/dist/versions.cjs",{"@metamask/keyring-internal-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PLATFORM_VERSION_TO_KEYRING_VERSION=void 0,n.getKeyringVersionFromPlatform=function(e){for(const[t,s]of n.PLATFORM_VERSION_TO_KEYRING_VERSION)if(e(t))return s;return s.KeyringVersion.V1};const s=e("@metamask/keyring-internal-api");n.PLATFORM_VERSION_TO_KEYRING_VERSION=[["7.0.0",s.KeyringVersion.V2]]}}},{package:"@metamask/eth-snap-keyring",file:"node_modules/@metamask/eth-snap-keyring/dist/versions.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return m.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}});var s=l(e("./v1.js")),r=l(e("./v3.js")),a=l(e("./v4.js")),o=l(e("./v5.js")),i=l(e("./nil.js")),c=l(e("./version.js")),m=l(e("./validate.js")),d=l(e("./stringify.js")),u=l(e("./parse.js"));function l(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){return 14+(e+64>>>9<<4)+1}function r(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function a(e,t,n,s,a,o){return r((i=r(r(t,e),r(s,o)))<<(c=a)|i>>>32-c,n);var i,c}function o(e,t,n,s,r,o,i){return a(t&n|~t&s,e,t,r,o,i)}function i(e,t,n,s,r,o,i){return a(t&s|n&~s,e,t,r,o,i)}function c(e,t,n,s,r,o,i){return a(t^n^s,e,t,r,o,i)}function m(e,t,n,s,r,o,i){return a(n^(t|~s),e,t,r,o,i)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var d=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,s="0123456789abcdef";for(let r=0;r<n;r+=8){const n=e[r>>5]>>>r%32&255,a=parseInt(s.charAt(n>>>4&15)+s.charAt(15&n),16);t.push(a)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[s(t)-1]=t;let n=1732584193,a=-271733879,d=-1732584194,u=271733878;for(let t=0;t<e.length;t+=16){const s=n,l=a,h=d,p=u;n=o(n,a,d,u,e[t],7,-680876936),u=o(u,n,a,d,e[t+1],12,-389564586),d=o(d,u,n,a,e[t+2],17,606105819),a=o(a,d,u,n,e[t+3],22,-1044525330),n=o(n,a,d,u,e[t+4],7,-176418897),u=o(u,n,a,d,e[t+5],12,1200080426),d=o(d,u,n,a,e[t+6],17,-1473231341),a=o(a,d,u,n,e[t+7],22,-45705983),n=o(n,a,d,u,e[t+8],7,1770035416),u=o(u,n,a,d,e[t+9],12,-1958414417),d=o(d,u,n,a,e[t+10],17,-42063),a=o(a,d,u,n,e[t+11],22,-1990404162),n=o(n,a,d,u,e[t+12],7,1804603682),u=o(u,n,a,d,e[t+13],12,-40341101),d=o(d,u,n,a,e[t+14],17,-1502002290),a=o(a,d,u,n,e[t+15],22,1236535329),n=i(n,a,d,u,e[t+1],5,-165796510),u=i(u,n,a,d,e[t+6],9,-1069501632),d=i(d,u,n,a,e[t+11],14,643717713),a=i(a,d,u,n,e[t],20,-373897302),n=i(n,a,d,u,e[t+5],5,-701558691),u=i(u,n,a,d,e[t+10],9,38016083),d=i(d,u,n,a,e[t+15],14,-660478335),a=i(a,d,u,n,e[t+4],20,-405537848),n=i(n,a,d,u,e[t+9],5,568446438),u=i(u,n,a,d,e[t+14],9,-1019803690),d=i(d,u,n,a,e[t+3],14,-187363961),a=i(a,d,u,n,e[t+8],20,1163531501),n=i(n,a,d,u,e[t+13],5,-1444681467),u=i(u,n,a,d,e[t+2],9,-51403784),d=i(d,u,n,a,e[t+7],14,1735328473),a=i(a,d,u,n,e[t+12],20,-1926607734),n=c(n,a,d,u,e[t+5],4,-378558),u=c(u,n,a,d,e[t+8],11,-2022574463),d=c(d,u,n,a,e[t+11],16,1839030562),a=c(a,d,u,n,e[t+14],23,-35309556),n=c(n,a,d,u,e[t+1],4,-1530992060),u=c(u,n,a,d,e[t+4],11,1272893353),d=c(d,u,n,a,e[t+7],16,-155497632),a=c(a,d,u,n,e[t+10],23,-1094730640),n=c(n,a,d,u,e[t+13],4,681279174),u=c(u,n,a,d,e[t],11,-358537222),d=c(d,u,n,a,e[t+3],16,-722521979),a=c(a,d,u,n,e[t+6],23,76029189),n=c(n,a,d,u,e[t+9],4,-640364487),u=c(u,n,a,d,e[t+12],11,-421815835),d=c(d,u,n,a,e[t+15],16,530742520),a=c(a,d,u,n,e[t+2],23,-995338651),n=m(n,a,d,u,e[t],6,-198630844),u=m(u,n,a,d,e[t+7],10,1126891415),d=m(d,u,n,a,e[t+14],15,-1416354905),a=m(a,d,u,n,e[t+5],21,-57434055),n=m(n,a,d,u,e[t+12],6,1700485571),u=m(u,n,a,d,e[t+3],10,-1894986606),d=m(d,u,n,a,e[t+10],15,-1051523),a=m(a,d,u,n,e[t+1],21,-2054922799),n=m(n,a,d,u,e[t+8],6,1873313359),u=m(u,n,a,d,e[t+15],10,-30611744),d=m(d,u,n,a,e[t+6],15,-1560198380),a=m(a,d,u,n,e[t+13],21,1309151649),n=m(n,a,d,u,e[t+4],6,-145523070),u=m(u,n,a,d,e[t+11],10,-1120210379),d=m(d,u,n,a,e[t+2],15,718787259),a=m(a,d,u,n,e[t+9],21,-343485551),n=r(n,s),a=r(a,l),d=r(d,h),u=r(u,p)}return[n,a,d,u]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(s(t));for(let s=0;s<t;s+=8)n[s>>5]|=(255&e[s/8])<<s%32;return n}(e),8*e.length))};n.default=d}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/native-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=s}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/native-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=a}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let s;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!s&&(s="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!s))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return s(r)};const r=new Uint8Array(16)}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e,t,n,s){switch(e){case 0:return t&n^~t&s;case 1:case 3:return t^n^s;case 2:return t&n^t&s^n&s}}function r(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var a=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const a=e.length/4+2,o=Math.ceil(a/16),i=new Array(o);for(let t=0;t<o;++t){const n=new Uint32Array(16);for(let s=0;s<16;++s)n[s]=e[64*t+4*s]<<24|e[64*t+4*s+1]<<16|e[64*t+4*s+2]<<8|e[64*t+4*s+3];i[t]=n}i[o-1][14]=8*(e.length-1)/Math.pow(2,32),i[o-1][14]=Math.floor(i[o-1][14]),i[o-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<o;++e){const a=new Uint32Array(80);for(let t=0;t<16;++t)a[t]=i[e][t];for(let e=16;e<80;++e)a[e]=r(a[e-3]^a[e-8]^a[e-14]^a[e-16],1);let o=n[0],c=n[1],m=n[2],d=n[3],u=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),i=r(o,5)+s(n,c,m,d)+u+t[n]+a[e]>>>0;u=d,d=m,m=r(c,30)>>>0,c=o,o=i}n[0]=n[0]+o>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+m>>>0,n[3]=n[3]+d>>>0,n[4]=n[4]+u>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=a}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=o;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};const a=[];for(let e=0;e<256;++e)a.push((e+256).toString(16).slice(1));function o(e,t=0){return a[e[t+0]]+a[e[t+1]]+a[e[t+2]]+a[e[t+3]]+"-"+a[e[t+4]]+a[e[t+5]]+"-"+a[e[t+6]]+a[e[t+7]]+"-"+a[e[t+8]]+a[e[t+9]]+"-"+a[e[t+10]]+a[e[t+11]]+a[e[t+12]]+a[e[t+13]]+a[e[t+14]]+a[e[t+15]]}var i=function(e,t=0){const n=o(e,t);if(!(0,r.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./rng.js"))&&s.__esModule?s:{default:s},a=e("./stringify.js");let o,i,c=0,m=0;var d=function(e,t,n){let s=t&&n||0;const d=t||new Array(16);let u=(e=e||{}).node||o,l=e.clockseq!==undefined?e.clockseq:i;if(null==u||null==l){const t=e.random||(e.rng||r.default)();null==u&&(u=o=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==l&&(l=i=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),p=e.nsecs!==undefined?e.nsecs:m+1;const f=h-c+(p-m)/1e4;if(f<0&&e.clockseq===undefined&&(l=l+1&16383),(f<0||h>c)&&e.nsecs===undefined&&(p=0),p>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,m=p,i=l,h+=122192928e5;const g=(1e4*(268435455&h)+p)%4294967296;d[s++]=g>>>24&255,d[s++]=g>>>16&255,d[s++]=g>>>8&255,d[s++]=255&g;const y=h/4294967296*1e4&268435455;d[s++]=y>>>8&255,d[s++]=255&y,d[s++]=y>>>24&15|16,d[s++]=y>>>16&255,d[s++]=l>>>8|128,d[s++]=255&l;for(let e=0;e<6;++e)d[s+e]=u[e];return t||(0,a.unsafeStringify)(d)};n.default=d}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./md5.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v3",48,r.default);n.default=o}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function s(e,s,o,i){var c;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof s&&(s=(0,a.default)(s)),16!==(null===(c=s)||void 0===c?void 0:c.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let m=new Uint8Array(16+e.length);if(m.set(s),m.set(e,s.length),m=n(m),m[6]=15&m[6]|t,m[8]=63&m[8]|128,o){i=i||0;for(let e=0;e<16;++e)o[i+e]=m[e];return o}return(0,r.unsafeStringify)(m)}try{s.name=e}catch(e){}return s.DNS=o,s.URL=i,s};var s,r=e("./stringify.js"),a=(s=e("./parse.js"))&&s.__esModule?s:{default:s};const o="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=o;const i="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v4.js",{"./native.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/native-browser.js","./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=o(e("./native.js")),r=o(e("./rng.js")),a=e("./stringify.js");function o(e){return e&&e.__esModule?e:{default:e}}var i=function(e,t,n){if(s.default.randomUUID&&!t&&!e)return s.default.randomUUID();const o=(e=e||{}).random||(e.rng||r.default)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=o[e];return t}return(0,a.unsafeStringify)(o)};n.default=i}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./sha1.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v5",80,r.default);n.default=o}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./regex.js"))&&s.__esModule?s:{default:s};var a=function(e){return"string"==typeof e&&r.default.test(e)};n.default=a}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=a}}},{package:"@metamask/eth-snap-keyring>uuid",file:"node_modules/@metamask/eth-snap-keyring/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/account-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getAccountLink=n.createCustomAccountLink=n.createAccountLinkForChain=n.createAccountLink=void 0;const r=e("./helpers"),a=s(e("./prefix-for-chain")),o=s(e("./prefix-for-network"));function i(e,t){const n=o.default(t);return null===n?"":`https://${n}etherscan.io/address/${e}`}function c(e,t){const n=a.default(t);return null===n?"":`https://${n}etherscan.io/address/${e}`}function m(e,t){return r.addPathToUrl(t,"address",e)}n.createAccountLink=i,n.createAccountLinkForChain=c,n.createCustomAccountLink=m,n.getAccountLink=function(e,t,n={},s=""){return n.blockExplorerUrl?m(e,n.blockExplorerUrl):s?i(e,s):c(e,t)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/account-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/explorer-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getBlockExplorerLink=n.createExplorerLinkForChain=n.createExplorerLink=n.createCustomExplorerLink=void 0;const r=e("./helpers"),a=s(e("./prefix-for-chain")),o=s(e("./prefix-for-network"));function i(e,t){return r.addPathToUrl(t,"tx",e)}function c(e,t){const n=o.default(t);return null===n?"":`https://${n}etherscan.io/tx/${e}`}function m(e,t){const n=a.default(t);return null===n?"":`https://${n}etherscan.io/tx/${e}`}n.createCustomExplorerLink=i,n.createExplorerLink=c,n.createExplorerLinkForChain=m,n.getBlockExplorerLink=function(e,t={}){return t.blockExplorerUrl?i(e.hash,t.blockExplorerUrl):e.chainId?m(e.hash,e.chainId):c(e.hash,e.metamaskNetworkId)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/explorer-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.addPathToUrl=void 0,n.addPathToUrl=(e,t,n)=>{const{username:s,password:r,protocol:a,host:o,pathname:i,search:c,hash:m}=new URL(e),d=i.endsWith("/")?`${i}${t}/${n}`:`${i}/${t}/${n}`;return new URL(`${a}//${s?`${s}:${r}`:""}${o}${d}${c}${m}`).toString()}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/index.js",{"./account-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/account-link.js","./explorer-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/explorer-link.js","./token-tracker-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/token-tracker-link.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const s=e("./account-link"),r=e("./explorer-link"),a=e("./token-tracker-link");t.exports={createExplorerLink:r.createExplorerLink,createCustomExplorerLink:r.createCustomExplorerLink,createExplorerLinkForChain:r.createExplorerLinkForChain,createAccountLink:s.createAccountLink,createCustomAccountLink:s.createCustomAccountLink,createAccountLinkForChain:s.createAccountLinkForChain,createTokenTrackerLink:a.createTokenTrackerLink,createCustomTokenTrackerLink:a.createCustomTokenTrackerLink,createTokenTrackerLinkForChain:a.createTokenTrackerLinkForChain,getBlockExplorerLink:r.getBlockExplorerLink,getAccountLink:s.getAccountLink,getTokenTrackerLink:a.getTokenTrackerLink}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){let t;switch(e){case"0x1":t="";break;case"0x5":t="goerli.";break;case"0xaa36a7":t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){let t;switch(parseInt(e)){case 1:t="";break;case 5:t="goerli.";break;case 11155111:t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/token-tracker-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getTokenTrackerLink=n.createTokenTrackerLinkForChain=n.createCustomTokenTrackerLink=n.createTokenTrackerLink=void 0;const r=e("./helpers"),a=s(e("./prefix-for-chain")),o=s(e("./prefix-for-network"));function i(e,t,n){const s=o.default(t);return null===s?"":`https://${s}etherscan.io/token/${e}${n?`?a=${n}`:""}`}function c(e,t){return r.addPathToUrl(t,"token",e)}function m(e,t,n){const s=a.default(t);return null===s?"":`https://${s}etherscan.io/token/${e}${n?`?a=${n}`:""}`}n.createTokenTrackerLink=i,n.createCustomTokenTrackerLink=c,n.createTokenTrackerLinkForChain=m,n.getTokenTrackerLink=function(e,t,n,s,r={}){return r.blockExplorerUrl?c(e,r.blockExplorerUrl):n?i(e,n,s):m(e,t,s)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/token-tracker-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/contract.js",{"./has-tx-object":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js","@babel/runtime/helpers/asyncToGenerator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/helpers/asyncToGenerator.js","@babel/runtime/helpers/interopRequireDefault":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/helpers/interopRequireDefault.js","@babel/runtime/regenerator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/regenerator/index.js","@metamask/ethjs-filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js","@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","ethjs-abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-abi/lib/index.js","js-sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/js-sha3/src/sha3.js","promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("@babel/runtime/helpers/interopRequireDefault"),r=s(e("@babel/runtime/regenerator")),a=s(e("@babel/runtime/helpers/asyncToGenerator")),o=e("ethjs-abi"),i=e("@metamask/ethjs-filter"),c=e("@metamask/ethjs-util").getKeys,m=e("js-sha3").keccak_256,d=e("promise-to-callback"),u=e("./has-tx-object");t.exports=function(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{},t=this;function n(e){return function(){var t,n=[].slice.call(arguments);"function"==typeof n[n.length-1]&&(t=n.pop());var r=function(e){return s.apply(this,arguments)}({methodObject:e,methodArgs:n});return t?d(r)(t):r}}function s(){return(s=(0,a.default)(r.default.mark(function e(n){var s,a,i,c,m,d,l;return r.default.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return s=n.methodObject,a=n.methodArgs,i="call",c={},u(a)&&(c=a.pop()),(m=Object.assign({},t.defaultTxObject,c,{to:t.address})).data=o.encodeMethod(s,a),!1===s.constant&&(i="sendTransaction"),e.next=9,t.query[i](m);case 9:if(d=e.sent,"call"!==i){e.next=20;break}return e.prev=11,l=o.decodeMethod(s,d),e.abrupt("return",l);case 16:throw e.prev=16,e.t0=e.catch(11),new Error("[ethjs-contract] while formatting incoming raw call data "+JSON.stringify(d)+" "+e.t0);case 20:return e.abrupt("return",d);case 21:case"end":return e.stop()}},e,null,[[11,16]])}))).apply(this,arguments)}t.abi=e.contractABI||[],t.query=e.query,t.address=e.address||"0x",t.bytecode=e.contractBytecode||"0x",t.defaultTxObject=e.contractDefaultTxObject||{},t.filters=new i(t.query),(l=t.abi,l.filter(function(e){return("function"===e.type||"event"===e.type)&&e.name.length>0})).forEach(function(e){"function"===e.type?t[e.name]=n(e):"event"===e.type&&(t[e.name]=function(e){return function(){var n=[].slice.call(arguments),s=c(e.inputs,"type",!1),r=["0x"+m(e.name+"("+s.join(",")+")")],a=Object.assign({},n[0])||{},i=Object.assign({},n[0]||{},{to:t.address,topics:r}),d=Object.assign({},a,{decoder:function(t){return o.decodeEvent(e,t,r)},defaultFilterObject:i});return new t.filters.Filter(d)}}(e))});var l}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/contract.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=["from","to","data","value","gasPrice","gas"];t.exports=function(e){if(!Array.isArray(e)||0===e.length)return!1;var t=e[e.length-1];if(!t)return!1;if("object"!=typeof t)return!1;if(0===Object.keys(t).length)return!0;var n=Object.keys(t);if(s.some(function(e){return n.includes(e)}))return!0;return!1}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/has-tx-object.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/index.js",{"./contract":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/contract.js","./has-tx-object":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js","@metamask/ethjs-filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js","@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","ethjs-abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-abi/lib/index.js","js-sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/js-sha3/src/sha3.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("ethjs-abi"),r=(e("js-sha3").keccak_256,e("@metamask/ethjs-filter"),e("@metamask/ethjs-util").getKeys),a=e("./contract"),o=e("./has-tx-object");t.exports=function(e){return function(t,n,i){if(!Array.isArray(t))throw new Error("[ethjs-contract] Contract ABI must be type Array, got type "+typeof t);if(void 0!==n&&"string"!=typeof n)throw new Error("[ethjs-contract] Contract bytecode must be type String, got type "+typeof n);if(void 0!==i&&"object"!=typeof i)throw new Error("[ethjs-contract] Contract default tx object must be type Object, got type "+typeof t);var c={at:function(s){return new a({address:s,query:e,contractBytecode:n,contractDefaultTxObject:i,contractABI:t})},new:function(){var a={},c=null,m=[].slice.call(arguments);"function"==typeof m[m.length-1]&&(c=m.pop()),o(m)&&(a=m.pop());var d=function(e){return e.filter(function(e){return"constructor"===e.type})[0]}(t),u=Object.assign({},i,a);if(n&&(u.data=n),d){var l=s.encodeParams(r(d.inputs,"type"),m).substring(2);u.data=""+u.data+l}return c?e.sendTransaction(u,c):e.sendTransaction(u)}};return c}}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e,t){function n(e){var n=this;n.filterId=null,n.options=Object.assign({delay:300,decoder:function(e){return e},defaultFilterObject:{}},e||{}),n.watchers={},n.interval=setInterval(function(){null!==n.filterId&&Object.keys(n.watchers).length>0&&t.getFilterChanges(n.filterId,function(e,t){var s=[],r=null;if(!e)try{t.forEach(function(e,r){s[r]=t[r],"object"==typeof t[r]&&(s[r].data=n.options.decoder(s[r].data))})}catch(e){r=new Error("[ethjs-filter] while decoding filter change event data from RPC '"+JSON.stringify(s)+"': "+e)}Object.keys(n.watchers).forEach(function(a){var o=n.watchers[a];!0!==o.stop?r?o.callback(r,null):e?o.callback(e,null):Array.isArray(s)&&t.length>0&&o.callback(e,s):delete n.watchers[a]})})},n.options.delay)}return n.prototype.at=function(e){this.filterId=e},n.prototype.watch=function(e){var t=e||function(){},n=this,s=Math.random().toString(36).substring(7);return n.watchers[s]={callback:t,stop:!1,stopWatching:function(){n.watchers[s].stop=!0}},n.watchers[s]},n.prototype.uninstall=function(e){var n=this,s=e||null;n.watchers=Object.assign({}),clearInterval(n.interval);var r=new Promise(function(e,s){t.uninstallFilter(n.filterId,function(t,n){t?s(t):e(n)})});return s&&r.then(function(e){return s(null,e)}).catch(function(e){return s(e,null)}),s?null:r},n.prototype.new=function(){var n=null,s=this,r=[],a=[].slice.call(arguments);"function"==typeof a[a.length-1]&&(n=a.pop()),"Filter"===e&&r.push(Object.assign(s.options.defaultFilterObject,a[a.length-1]||{}));var o=new Promise(function(n,a){r.push(function(e,t){e?a(e):(s.filterId=t,n(t))}),t["new"+e].apply(t,r)});return n&&o.then(function(e){return n(null,e)}).catch(function(e){return n(e,null)}),n?null:o},n}t.exports=function e(t){var n=this;if(!(n instanceof e))throw new Error("the EthFilter object must be instantiated with `new` flag.. (e.g. `const filters = new EthFilter(query);`)");if("object"!=typeof t)throw new Error("the EthFilter object must be instantiated with an EthQuery instance (e.g. `const filters = new EthFilter(new EthQuery(provider));`). See github.com/ethjs/ethjs-query for more details..");n.Filter=s("Filter",t),n.BlockFilter=s("BlockFilter",t),n.PendingTransactionFilter=s("PendingTransactionFilter",t)}}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-filter",file:"node_modules/@metamask/ethjs-filter/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-format/lib/index.js",{"@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","@metamask/number-to-bn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/number-to-bn/src/index.js","ethjs-schema":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-schema/src/schema.json","strip-hex-prefix":"/home/runner/work/metamask-extension/metamask-extension/node_modules/strip-hex-prefix/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("@metamask/number-to-bn"),r=e("ethjs-schema"),a=e("@metamask/ethjs-util"),o=a.arrayContainsArray,i=a.getBinarySize,c=a.padToEven,m=e("strip-hex-prefix");function d(e,t,n){if(-1===["string","number","object"].indexOf(typeof e)||null===e)return e;var r=s(e),a=n&&r.toString(16).length%2?"0":"";if(s(e).isNeg())throw new Error("[ethjs-format] while formatting quantity '"+r.toString(10)+"', invalid negative number. Number must be positive or zero.");return t?"0x"+a+r.toString(16):r}function u(e,t){var n=e;return-1===r.tags.indexOf(e)&&(n=d(e,t)),n}function l(e,t){var n=e,s=0;if("string"==typeof e&&(n="0x"+c(m(e)),s=i(n)),"0x00"===n&&(n="0x0"),"number"==typeof t&&null!==e&&"0x"!==n&&"0x0"!==n&&(!/^[0-9A-Fa-f]+$/.test(m(n))||s!==2+2*t))throw new Error("[ethjs-format] hex string '"+n+"' must be an alphanumeric "+(2+2*t)+" utf8 byte hex (chars: a-fA-F) string, is "+s+" bytes");return n}function h(e,t,n){var s=Object.assign({},t),a=null;if("string"==typeof e&&(a="Boolean|EthSyncing"===e?Object.assign({},r.objects.EthSyncing):"DATA|Transaction"===e?Object.assign({},r.objects.Transaction):Object.assign({},r.objects[e])),!o(Object.keys(t),a.__required))throw new Error("[ethjs-format] object "+JSON.stringify(t)+" must contain properties: "+a.__required.join(", "));return Object.keys(a).forEach(function(e){"__required"!==e&&void 0!==t[e]&&(s[e]=f(a[e],t[e],n))}),s}function p(e,t,n,s){var r=t.slice(),a=e;if("Array|DATA"===e&&(a=["D"]),"FilterChange"===e&&"string"==typeof t[0]&&(a=["D32"]),!0===n&&"number"==typeof s&&t.length<s)throw new Error("array "+JSON.stringify(t)+" must contain at least "+s+" params, but only contains "+t.length+".");return a=a.slice(),t.forEach(function(e,t){var s=0;a.length>1&&(s=t),r[t]=f(a[s],e,n)}),r}function f(e,t,n,s){var r=t;return"Q"===e?r=d(t,n):"QP"===e?r=d(t,n,!0):"Q|T"===e?r=u(t,n):"D"===e?r=l(t):"D20"===e?r=l(t,20):"D32"===e?r=l(t,32):"object"==typeof t&&null!==t&&!1===Array.isArray(t)?r=h(e,t,n):Array.isArray(t)&&(r=p(e,t,n,s)),r}t.exports={schema:r,formatQuantity:d,formatQuantityOrTag:u,formatObject:h,formatArray:p,format:f,formatInputs:function(e,t){return f(r.methods[e][0],t,!0,r.methods[e][2])},formatOutputs:function(e,t){return f(r.methods[e][1],t,!1)}}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-format",file:"node_modules/@metamask/ethjs-format/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-query/lib/index.js",{"@metamask/ethjs-format":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-format/lib/index.js","@metamask/ethjs-rpc":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-rpc/lib/index.js","promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("@metamask/ethjs-format"),r=e("@metamask/ethjs-rpc"),a=e("promise-to-callback");function o(e,t){var n=this,s=t||{};if(!(this instanceof o))throw new Error('[ethjs-query] the Eth object requires the "new" flag in order to function normally (i.e. `const eth = new Eth(provider);`).');if("object"!=typeof e)throw new Error("[ethjs-query] the Eth object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new Eth(provider);')");n.options=Object.assign({debug:s.debug||!1,logger:s.logger||console,jsonSpace:s.jsonSpace||0}),n.rpc=new r(e),n.setProvider=n.rpc.setProvider}function i(e,t){return function(){var n=null,r=null,o=this,i=[].slice.call(arguments),c=e.replace("eth_","");i.length>0&&"function"==typeof i[i.length-1]&&(n=i.pop());var m=function(){var n=this;return new Promise(function(a,m){if(i.length<t[2])m(new Error("[ethjs-query] method '"+c+"' requires at least "+t[2]+" input (format type "+t[0][0]+"), "+i.length+" provided. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else if(i.length>t[0].length)m(new Error("[ethjs-query] method '"+c+"' requires at most "+t[0].length+" params, "+i.length+" provided '"+JSON.stringify(i,null,o.options.jsonSpace)+"'. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else{t[3]&&i.length<t[3]&&i.push("latest"),n.log("attempting method formatting for '"+c+"' with inputs "+JSON.stringify(i,null,n.options.jsonSpace));try{r=s.formatInputs(e,i),n.log("method formatting success for '"+c+"' with formatted result: "+JSON.stringify(r,null,n.options.jsonSpace))}catch(e){return void m(new Error("[ethjs-query] while formatting inputs '"+JSON.stringify(i,null,n.options.jsonSpace)+"' for method '"+c+"' error: "+e))}n.rpc.sendAsync({method:e,params:r}).then(function(t){n.log("attempting method formatting for '"+c+"' with raw outputs: "+JSON.stringify(t,null,n.options.jsonSpace));var r=s.formatOutputs(e,t);n.log("method formatting success for '"+c+"' formatted result: "+JSON.stringify(r,null,n.options.jsonSpace)),a(r)}).catch(function(e){m(e)})}})}.call(this);return n?a(m)(n):m}}t.exports=o,o.prototype.log=function(e){this.options.debug&&this.options.logger.log("[ethjs-query log] "+e)},Object.keys(s.schema.methods).forEach(function(e){Object.defineProperty(o.prototype,e.replace("eth_",""),{enumerable:!0,value:i(e,s.schema.methods[e])})})}}},{package:"eth-method-registry>@metamask/ethjs-query",file:"node_modules/@metamask/ethjs-query/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-rpc/lib/index.js",{"promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("promise-to-callback");function r(e,t){var n=this,s=t||{};if(!(this instanceof r))throw new Error('[ethjs-rpc] the EthRPC object requires the "new" flag in order to function normally (i.e. `const eth = new EthRPC(provider);`).');n.options=Object.assign({jsonSpace:s.jsonSpace||0,max:s.max||9999999999999}),n.idCounter=Math.floor(Math.random()*n.options.max),n.setProvider=function(e){if("object"!=typeof e)throw new Error("[ethjs-rpc] the EthRPC object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new EthRPC(provider);')");n.currentProvider=e},n.setProvider(e)}t.exports=r,r.prototype.sendAsync=function(e,t){var n=this;n.idCounter=n.idCounter%n.options.max;var r,a,o=(r=e,a=n.idCounter++,Object.assign({},{id:a,jsonrpc:"2.0",params:[]},r)),i=new Promise(function(e,t){n.currentProvider.sendAsync(o,function(s,r){var a=r||{};if(s||a.error){var i="[ethjs-rpc] "+(a.error?"rpc":"")+" error with payload "+JSON.stringify(o,null,n.options.jsonSpace)+" "+(s?String(s):JSON.stringify(a.error,null,n.options.jsonSpace)),c=new Error(i);return c.value=s||a.error,void t(c)}e(a.result)})});return t?s(i)(t):i}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-rpc",file:"node_modules/@metamask/ethjs-rpc/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-unit/lib/index.js",{"@metamask/number-to-bn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/number-to-bn/src/index.js","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("bn.js"),r=e("@metamask/number-to-bn"),a=new s(0),o=new s(-1),i={noether:"0",wei:"1",kwei:"1000",Kwei:"1000",babbage:"1000",femtoether:"1000",mwei:"1000000",Mwei:"1000000",lovelace:"1000000",picoether:"1000000",gwei:"1000000000",Gwei:"1000000000",shannon:"1000000000",nanoether:"1000000000",nano:"1000000000",szabo:"1000000000000",microether:"1000000000000",micro:"1000000000000",finney:"1000000000000000",milliether:"1000000000000000",milli:"1000000000000000",ether:"1000000000000000000",kether:"1000000000000000000000",grand:"1000000000000000000000",mether:"1000000000000000000000000",gether:"1000000000000000000000000000",tether:"1000000000000000000000000000000"};function c(e){var t=e?e.toLowerCase():"ether",n=i[t];if("string"!=typeof n)throw new Error("[ethjs-unit] the unit provided "+e+" doesn't exists, please use the one of the following units "+JSON.stringify(i,null,2));return new s(n,10)}function m(e){if("string"==typeof e){if(!e.match(/^-?[0-9.]+$/))throw new Error("while converting number to string, invalid number value '"+e+"', should be a number matching (^-?[0-9.]+).");return e}if("number"==typeof e)return String(e);if("object"==typeof e&&e.toString&&(e.toTwos||e.dividedToIntegerBy))return e.toPrecision?String(e.toPrecision()):e.toString(10);throw new Error("while converting number to string, invalid number value '"+e+"' type "+typeof e+".")}t.exports={unitMap:i,numberToString:m,getValueOfUnit:c,fromWei:function(e,t,n){var s=r(e),m=s.lt(a),d=c(t),u=i[t].length-1||1,l=n||{};m&&(s=s.mul(o));for(var h=s.mod(d).toString(10);h.length<u;)h="0"+h;l.pad||(h=h.match(/^([0-9]*[1-9]|0)(0*)/)[1]);var p=s.div(d).toString(10);l.commify&&(p=p.replace(/\B(?=(\d{3})+(?!\d))/g,","));var f=p+("0"==h?"":"."+h);return m&&(f="-"+f),f},toWei:function(e,t){var n=m(e),r=c(t),a=i[t].length-1||1,d="-"===n.substring(0,1);if(d&&(n=n.substring(1)),"."===n)throw new Error("[ethjs-unit] while converting number "+e+" to wei, invalid value");var u=n.split(".");if(u.length>2)throw new Error("[ethjs-unit] while converting number "+e+" to wei,  too many decimal points");var l=u[0],h=u[1];if(l||(l="0"),h||(h="0"),h.length>a)throw new Error("[ethjs-unit] while converting number "+e+" to wei, too many decimal places");for(;h.length<a;)h+="0";l=new s(l),h=new s(h);var p=l.mul(r).add(h);return d&&(p=p.mul(o)),new s(p.toString(10),10)}}}}},{package:"@metamask/controller-utils>@metamask/ethjs-unit",file:"node_modules/@metamask/ethjs-unit/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","is-hex-prefixed":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-hex-prefixed/src/index.js","strip-hex-prefix":"/home/runner/work/metamask-extension/metamask-extension/node_modules/strip-hex-prefix/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var s=e("is-hex-prefixed"),r=e("strip-hex-prefix");function a(e){var t=e;if("string"!=typeof t)throw new Error("[ethjs-util] while padding to even, value must be string, is currently "+typeof t+", while padToEven.");return t.length%2&&(t="0"+t),t}function o(e){return"0x"+e.toString(16)}t.exports={arrayContainsArray:function(e,t,n){if(!0!==Array.isArray(e))throw new Error("[ethjs-util] method arrayContainsArray requires input 'superset' to be an array got type '"+typeof e+"'");if(!0!==Array.isArray(t))throw new Error("[ethjs-util] method arrayContainsArray requires input 'subset' to be an array got type '"+typeof t+"'");return t[Boolean(n)?"some":"every"](function(t){return e.indexOf(t)>=0})},intToBuffer:function(e){var t=o(e);return n.from(a(t.slice(2)),"hex")},getBinarySize:function(e){if("string"!=typeof e)throw new Error("[ethjs-util] while getting binary size, method getBinarySize requires input 'str' to be type String, got '"+typeof e+"'.");return n.byteLength(e,"utf8")},isHexPrefixed:s,stripHexPrefix:r,padToEven:a,intToHex:o,fromAscii:function(e){for(var t="",n=0;n<e.length;n++){var s=e.charCodeAt(n).toString(16);t+=s.length<2?"0"+s:s}return"0x"+t},fromUtf8:function(e){return"0x"+a(n.from(e,"utf8").toString("hex")).replace(/^0+|0+$/g,"")},toAscii:function(e){var t="",n=0,s=e.length;for("0x"===e.substring(0,2)&&(n=2);n<s;n+=2){var r=parseInt(e.substr(n,2),16);t+=String.fromCharCode(r)}return t},toUtf8:function(e){return n.from(a(r(e).replace(/^0+|0+$/g,"")),"hex").toString("utf8")},getKeys:function(e,t,n){if(!Array.isArray(e))throw new Error("[ethjs-util] method getKeys expecting type Array as 'params' input, got '"+typeof e+"'");if("string"!=typeof t)throw new Error("[ethjs-util] method getKeys expecting type String for input 'key' got '"+typeof t+"'.");for(var s=[],r=0;r<e.length;r++){var a=e[r][t];if(n&&!a)a="";else if("string"!=typeof a)throw new Error("invalid abi");s.push(a)}return s},isHexString:function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&(!t||e.length===2+2*t)}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-util",file:"node_modules/@metamask/ethjs-util/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs",{"./determineGasFeeCalculations.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/determineGasFeeCalculations.cjs","./gas-util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/gas-util.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/eth-query":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js","@metamask/polling-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/polling-controller/dist/index.cjs",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},c=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.GasFeeController=n.GAS_ESTIMATE_TYPES=n.LEGACY_GAS_PRICES_API_URL=void 0;const m=e("@metamask/controller-utils"),d=c(e("@metamask/eth-query")),u=e("@metamask/polling-controller"),l=e("uuid"),h=c(e("./determineGasFeeCalculations.cjs")),p=e("./gas-util.cjs");n.LEGACY_GAS_PRICES_API_URL="https://api.metaswap.codefi.network/gasPrices",n.GAS_ESTIMATE_TYPES={FEE_MARKET:"fee-market",LEGACY:"legacy",ETH_GASPRICE:"eth_gasPrice",NONE:"none"};const f={gasFeeEstimatesByChainId:{persist:!0,anonymous:!1},gasFeeEstimates:{persist:!0,anonymous:!1},estimatedGasFeeTimeBounds:{persist:!0,anonymous:!1},gasEstimateType:{persist:!0,anonymous:!1},nonRPCGasFeeApisDisabled:{persist:!0,anonymous:!1}},g={gasFeeEstimatesByChainId:{},gasFeeEstimates:{},estimatedGasFeeTimeBounds:{},gasEstimateType:n.GAS_ESTIMATE_TYPES.NONE,nonRPCGasFeeApisDisabled:!1};class y extends((0,u.StaticIntervalPollingController)()){constructor({interval:e=15e3,messenger:t,state:c,getCurrentNetworkEIP1559Compatibility:m,getCurrentAccountEIP1559Compatibility:u,getChainId:l,getCurrentNetworkLegacyGasAPICompatibility:h,getProvider:p,onNetworkDidChange:y,legacyAPIEndpoint:k=n.LEGACY_GAS_PRICES_API_URL,EIP1559APIEndpoint:b,clientId:x}){if(super({name:"GasFeeController",metadata:f,messenger:t,state:{...g,...c}}),s.add(this),r.set(this,void 0),this.intervalDelay=e,this.setIntervalLength(e),this.pollTokens=new Set,this.getCurrentNetworkEIP1559Compatibility=m,this.getCurrentNetworkLegacyGasAPICompatibility=h,this.getCurrentAccountEIP1559Compatibility=u,o(this,r,p,"f"),this.EIP1559APIEndpoint=b,this.legacyAPIEndpoint=k,this.clientId=x,this.ethQuery=new d.default(i(this,r,"f").call(this)),y&&l)this.currentChainId=l(),y(async e=>{await i(this,s,"m",a).call(this,e)});else{const{selectedNetworkClientId:e}=this.messagingSystem.call("NetworkController:getState");this.currentChainId=this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId,this.messagingSystem.subscribe("NetworkController:networkDidChange",async e=>{await i(this,s,"m",a).call(this,e)})}}async resetPolling(){if(0!==this.pollTokens.size){const e=Array.from(this.pollTokens);this.stopPolling(),await this.getGasFeeEstimatesAndStartPolling(e[0]),e.slice(1).forEach(e=>{this.pollTokens.add(e)})}}async fetchGasFeeEstimates(e){return await this._fetchGasFeeEstimateData(e)}async getGasFeeEstimatesAndStartPolling(e){const t=e||(0,l.v1)();return this.pollTokens.add(t),1===this.pollTokens.size&&(await this._fetchGasFeeEstimateData(),this._poll()),t}async _fetchGasFeeEstimateData(e={}){const{shouldUpdateState:t=!0,networkClientId:n}=e;let s,r,a,o;if(n!==undefined){const e=this.messagingSystem.call("NetworkController:getNetworkClientById",n);a="0x38"===e.configuration.chainId,o=(0,m.convertHexToDecimal)(e.configuration.chainId);try{r=await this.messagingSystem.call("NetworkController:getEIP1559Compatibility",n)||!1}catch{r=!1}s=new d.default(e.provider)}s??(s=this.ethQuery),a??(a=this.getCurrentNetworkLegacyGasAPICompatibility()),o??(o=(0,m.convertHexToDecimal)(this.currentChainId));try{r??(r=await this.getEIP1559Compatibility())}catch(e){console.error(e),r??(r=!1)}const i=await(0,h.default)({isEIP1559Compatible:r,isLegacyGasAPICompatible:a,fetchGasEstimates:p.fetchGasEstimates,fetchGasEstimatesUrl:this.EIP1559APIEndpoint.replace("<chain_id>",`${o}`),fetchLegacyGasPriceEstimates:p.fetchLegacyGasPriceEstimates,fetchLegacyGasPriceEstimatesUrl:this.legacyAPIEndpoint.replace("<chain_id>",`${o}`),fetchEthGasPriceEstimate:p.fetchEthGasPriceEstimate,calculateTimeEstimate:p.calculateTimeEstimate,clientId:this.clientId,ethQuery:s,nonRPCGasFeeApisDisabled:this.state.nonRPCGasFeeApisDisabled});if(t){const e=(0,m.toHex)(o);this.update(t=>{this.currentChainId===e&&(t.gasFeeEstimates=i.gasFeeEstimates,t.estimatedGasFeeTimeBounds=i.estimatedGasFeeTimeBounds,t.gasEstimateType=i.gasEstimateType),t.gasFeeEstimatesByChainId??(t.gasFeeEstimatesByChainId={}),t.gasFeeEstimatesByChainId[e]={gasFeeEstimates:i.gasFeeEstimates,estimatedGasFeeTimeBounds:i.estimatedGasFeeTimeBounds,gasEstimateType:i.gasEstimateType}})}return i}disconnectPoller(e){this.pollTokens.delete(e),0===this.pollTokens.size&&this.stopPolling()}stopPolling(){this.intervalId&&clearInterval(this.intervalId),this.pollTokens.clear(),this.resetState()}destroy(){super.destroy(),this.stopPolling()}_poll(){this.intervalId&&clearInterval(this.intervalId),this.intervalId=setInterval(async()=>{await(0,m.safelyExecute)(()=>this._fetchGasFeeEstimateData())},this.intervalDelay)}async _executePoll({networkClientId:e}){await this._fetchGasFeeEstimateData({networkClientId:e})}resetState(){this.update(()=>g)}async getEIP1559Compatibility(){const e=await this.getCurrentNetworkEIP1559Compatibility(),t=this.getCurrentAccountEIP1559Compatibility?.()??!0;return e&&t}getTimeEstimate(e,t){return this.state.gasFeeEstimates&&this.state.gasEstimateType===n.GAS_ESTIMATE_TYPES.FEE_MARKET?(0,p.calculateTimeEstimate)(e,t,this.state.gasFeeEstimates):{}}enableNonRPCGasFeeApis(){this.update(e=>{e.nonRPCGasFeeApisDisabled=!1})}disableNonRPCGasFeeApis(){this.update(e=>{e.nonRPCGasFeeApisDisabled=!0})}}n.GasFeeController=y,r=new WeakMap,s=new WeakSet,a=async function({selectedNetworkClientId:e}){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId;t!==this.currentChainId&&(this.ethQuery=new d.default(i(this,r,"f").call(this)),await this.resetPolling(),this.currentChainId=t)},n.default=y}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/determineGasFeeCalculations.cjs",{"./GasFeeController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const s=e("./GasFeeController.cjs");n.default=async function(e){try{return await async function(e){const{isEIP1559Compatible:t,isLegacyGasAPICompatible:n,nonRPCGasFeeApisDisabled:r}=e;try{if(t&&!r)return await async function(e){const{fetchGasEstimates:t,fetchGasEstimatesUrl:n,clientId:r,calculateTimeEstimate:a}=e,o=await t(n,r),{suggestedMaxPriorityFeePerGas:i,suggestedMaxFeePerGas:c}=o.medium,m=a(i,c,o);return{gasFeeEstimates:o,estimatedGasFeeTimeBounds:m,gasEstimateType:s.GAS_ESTIMATE_TYPES.FEE_MARKET}}(e);if(n&&!r)return await async function(e){const{fetchLegacyGasPriceEstimates:t,fetchLegacyGasPriceEstimatesUrl:n,clientId:r}=e;return{gasFeeEstimates:await t(n,r),estimatedGasFeeTimeBounds:{},gasEstimateType:s.GAS_ESTIMATE_TYPES.LEGACY}}(e);throw new Error("Main gas fee/price estimation failed. Use fallback")}catch{return await async function(e){const{ethQuery:t,fetchEthGasPriceEstimate:n}=e;return{gasFeeEstimates:await n(t),estimatedGasFeeTimeBounds:{},gasEstimateType:s.GAS_ESTIMATE_TYPES.ETH_GASPRICE}}(e)}}(e)}catch(e){if(e instanceof Error)throw new Error(`Gas fee/price estimation failed. Message: ${e.message}`);throw e}}}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/determineGasFeeCalculations.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/gas-util.cjs",{"@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.calculateTimeEstimate=n.fetchEthGasPriceEstimate=n.fetchLegacyGasPriceEstimates=n.fetchGasEstimates=n.normalizeGWEIDecimalNumbers=void 0;const r=e("@metamask/controller-utils"),a=s(e("bn.js")),o=e=>({"X-Client-Id":e});function i(e){const t=(0,r.gweiDecToWEIBN)(e).toString(16);return(0,r.weiHexToGweiDec)(t)}n.normalizeGWEIDecimalNumbers=i,n.fetchGasEstimates=async function(e,t){const n=await(0,r.handleFetch)(e,t?{headers:o(t)}:undefined);return{low:{...n.low,suggestedMaxPriorityFeePerGas:i(n.low.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:i(n.low.suggestedMaxFeePerGas)},medium:{...n.medium,suggestedMaxPriorityFeePerGas:i(n.medium.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:i(n.medium.suggestedMaxFeePerGas)},high:{...n.high,suggestedMaxPriorityFeePerGas:i(n.high.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:i(n.high.suggestedMaxFeePerGas)},estimatedBaseFee:i(n.estimatedBaseFee),historicalBaseFeeRange:n.historicalBaseFeeRange,baseFeeTrend:n.baseFeeTrend,latestPriorityFeeRange:n.latestPriorityFeeRange,historicalPriorityFeeRange:n.historicalPriorityFeeRange,priorityFeeTrend:n.priorityFeeTrend,networkCongestion:n.networkCongestion}},n.fetchLegacyGasPriceEstimates=async function(e,t){const n=await(0,r.handleFetch)(e,{referrer:e,referrerPolicy:"no-referrer-when-downgrade",method:"GET",mode:"cors",headers:{"Content-Type":"application/json",...t&&o(t)}});return{low:n.SafeGasPrice,medium:n.ProposeGasPrice,high:n.FastGasPrice}},n.fetchEthGasPriceEstimate=async function(e){const t=await(0,r.query)(e,"gasPrice");return{gasPrice:(0,r.weiHexToGweiDec)(t).toString()}},n.calculateTimeEstimate=function(e,t,n){const{low:s,medium:o,high:i,estimatedBaseFee:c}=n,m=(0,r.gweiDecToWEIBN)(e),d=(0,r.gweiDecToWEIBN)(t),u=(0,r.gweiDecToWEIBN)(c),l=a.default.min(m,d.sub(u)),h=(0,r.gweiDecToWEIBN)(s.suggestedMaxPriorityFeePerGas),p=(0,r.gweiDecToWEIBN)(o.suggestedMaxPriorityFeePerGas),f=(0,r.gweiDecToWEIBN)(i.suggestedMaxPriorityFeePerGas);let g,y;return l.lt(h)?(g=null,y="unknown"):l.gte(h)&&l.lt(p)?(g=s.minWaitTimeEstimate,y=s.maxWaitTimeEstimate):l.gte(p)&&l.lt(f)?(g=o.minWaitTimeEstimate,y=o.maxWaitTimeEstimate):l.eq(f)?(g=i.minWaitTimeEstimate,y=i.maxWaitTimeEstimate):(g=0,y=i.maxWaitTimeEstimate),{lowerTimeBound:g,upperTimeBound:y}}}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/gas-util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/index.cjs",{"./GasFeeController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./GasFeeController.cjs"),n)}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/colors.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=["#01888C","#FC7500","#034F5D","#F73F01","#FC1960","#C7144C","#F3C100","#1598F2","#2465E1","#F19E02"]}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/colors.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/index.js",{"./colors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/colors.js","./paper":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/paper.js",color:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color/index.js","mersenne-twister":"/home/runner/work/metamask-extension/metamask-extension/node_modules/mersenne-twister/src/mersenne-twister.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=e("mersenne-twister"),a=e("./paper"),o=e("color"),i=e("./colors"),c="http://www.w3.org/2000/svg";function m(e,t,n,r,a){var o=t/2,i=document.createElementNS(c,"rect");i.setAttributeNS(null,"x","0"),i.setAttributeNS(null,"y","0"),i.setAttributeNS(null,"width",t),i.setAttributeNS(null,"height",t);var m=s.random(),u=2*Math.PI*m,l=t/r*s.random()+n*t/r,h="translate("+Math.cos(u)*l+" "+Math.sin(u)*l+")"+" "+("rotate("+(360*m+180*s.random()).toFixed(1)+" "+o+" "+o+")");i.setAttributeNS(null,"transform",h);var p=d(e);i.setAttributeNS(null,"fill",p),a.appendChild(i)}function d(e){s.random();var t=Math.floor(e.length*s.random());return e.splice(t,1)[0]}t.exports=function(e,t){s=new r(t);var n=function(e,t){var n=30*t.random()-u/2;return e.map(function(e){var t=o(e);return t.rotate(n),t.hexString()})}(i.slice(),s),l=a(e,d(n)).container,h=document.createElementNS(c,"svg");h.setAttributeNS(null,"x","0"),h.setAttributeNS(null,"y","0"),h.setAttributeNS(null,"width",e),h.setAttributeNS(null,"height",e),l.appendChild(h);for(var p=0;p<3;p++)m(n,e,p,3,h);return l};var u=30}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-convert/conversions.js",{"color-name":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-name/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("color-name"),r={};for(var a in s)s.hasOwnProperty(a)&&(r[s[a]]=a);var o=t.exports={rgb:{channels:3,labels:"rgb"},hsl:{channels:3,labels:"hsl"},hsv:{channels:3,labels:"hsv"},hwb:{channels:3,labels:"hwb"},cmyk:{channels:4,labels:"cmyk"},xyz:{channels:3,labels:"xyz"},lab:{channels:3,labels:"lab"},lch:{channels:3,labels:"lch"},hex:{channels:1,labels:["hex"]},keyword:{channels:1,labels:["keyword"]},ansi16:{channels:1,labels:["ansi16"]},ansi256:{channels:1,labels:["ansi256"]},hcg:{channels:3,labels:["h","c","g"]},apple:{channels:3,labels:["r16","g16","b16"]},gray:{channels:1,labels:["gray"]}};for(var i in o)if(o.hasOwnProperty(i)){if(!("channels"in o[i]))throw new Error("missing channels property: "+i);if(!("labels"in o[i]))throw new Error("missing channel labels property: "+i);if(o[i].labels.length!==o[i].channels)throw new Error("channel and label counts mismatch: "+i);var c=o[i].channels,m=o[i].labels;delete o[i].channels,delete o[i].labels,Object.defineProperty(o[i],"channels",{value:c}),Object.defineProperty(o[i],"labels",{value:m})}function d(e,t){return Math.pow(e[0]-t[0],2)+Math.pow(e[1]-t[1],2)+Math.pow(e[2]-t[2],2)}o.rgb.hsl=function(e){var t,n,s=e[0]/255,r=e[1]/255,a=e[2]/255,o=Math.min(s,r,a),i=Math.max(s,r,a),c=i-o;return i===o?t=0:s===i?t=(r-a)/c:r===i?t=2+(a-s)/c:a===i&&(t=4+(s-r)/c),(t=Math.min(60*t,360))<0&&(t+=360),n=(o+i)/2,[t,100*(i===o?0:n<=.5?c/(i+o):c/(2-i-o)),100*n]},o.rgb.hsv=function(e){var t,n,s,r,a,o=e[0]/255,i=e[1]/255,c=e[2]/255,m=Math.max(o,i,c),d=m-Math.min(o,i,c),u=function(e){return(m-e)/6/d+.5};return 0===d?r=a=0:(a=d/m,t=u(o),n=u(i),s=u(c),o===m?r=s-n:i===m?r=1/3+t-s:c===m&&(r=2/3+n-t),r<0?r+=1:r>1&&(r-=1)),[360*r,100*a,100*m]},o.rgb.hwb=function(e){var t=e[0],n=e[1],s=e[2];return[o.rgb.hsl(e)[0],100*(1/255*Math.min(t,Math.min(n,s))),100*(s=1-1/255*Math.max(t,Math.max(n,s)))]},o.rgb.cmyk=function(e){var t,n=e[0]/255,s=e[1]/255,r=e[2]/255;return[100*((1-n-(t=Math.min(1-n,1-s,1-r)))/(1-t)||0),100*((1-s-t)/(1-t)||0),100*((1-r-t)/(1-t)||0),100*t]},o.rgb.keyword=function(e){var t=r[e];if(t)return t;var n,a=Infinity;for(var o in s)if(s.hasOwnProperty(o)){var i=d(e,s[o]);i<a&&(a=i,n=o)}return n},o.keyword.rgb=function(e){return s[e]},o.rgb.xyz=function(e){var t=e[0]/255,n=e[1]/255,s=e[2]/255;return[100*(.4124*(t=t>.04045?Math.pow((t+.055)/1.055,2.4):t/12.92)+.3576*(n=n>.04045?Math.pow((n+.055)/1.055,2.4):n/12.92)+.1805*(s=s>.04045?Math.pow((s+.055)/1.055,2.4):s/12.92)),100*(.2126*t+.7152*n+.0722*s),100*(.0193*t+.1192*n+.9505*s)]},o.rgb.lab=function(e){var t=o.rgb.xyz(e),n=t[0],s=t[1],r=t[2];return s/=100,r/=108.883,n=(n/=95.047)>.008856?Math.pow(n,1/3):7.787*n+16/116,[116*(s=s>.008856?Math.pow(s,1/3):7.787*s+16/116)-16,500*(n-s),200*(s-(r=r>.008856?Math.pow(r,1/3):7.787*r+16/116))]},o.hsl.rgb=function(e){var t,n,s,r,a,o=e[0]/360,i=e[1]/100,c=e[2]/100;if(0===i)return[a=255*c,a,a];t=2*c-(n=c<.5?c*(1+i):c+i-c*i),r=[0,0,0];for(var m=0;m<3;m++)(s=o+1/3*-(m-1))<0&&s++,s>1&&s--,a=6*s<1?t+6*(n-t)*s:2*s<1?n:3*s<2?t+(n-t)*(2/3-s)*6:t,r[m]=255*a;return r},o.hsl.hsv=function(e){var t=e[0],n=e[1]/100,s=e[2]/100,r=n,a=Math.max(s,.01);return n*=(s*=2)<=1?s:2-s,r*=a<=1?a:2-a,[t,100*(0===s?2*r/(a+r):2*n/(s+n)),100*((s+n)/2)]},o.hsv.rgb=function(e){var t=e[0]/60,n=e[1]/100,s=e[2]/100,r=Math.floor(t)%6,a=t-Math.floor(t),o=255*s*(1-n),i=255*s*(1-n*a),c=255*s*(1-n*(1-a));switch(s*=255,r){case 0:return[s,c,o];case 1:return[i,s,o];case 2:return[o,s,c];case 3:return[o,i,s];case 4:return[c,o,s];case 5:return[s,o,i]}},o.hsv.hsl=function(e){var t,n,s,r=e[0],a=e[1]/100,o=e[2]/100,i=Math.max(o,.01);return s=(2-a)*o,n=a*i,[r,100*(n=(n/=(t=(2-a)*i)<=1?t:2-t)||0),100*(s/=2)]},o.hwb.rgb=function(e){var t,n,s,r,a,o,i,c=e[0]/360,m=e[1]/100,d=e[2]/100,u=m+d;switch(u>1&&(m/=u,d/=u),s=6*c-(t=Math.floor(6*c)),1&t&&(s=1-s),r=m+s*((n=1-d)-m),t){default:case 6:case 0:a=n,o=r,i=m;break;case 1:a=r,o=n,i=m;break;case 2:a=m,o=n,i=r;break;case 3:a=m,o=r,i=n;break;case 4:a=r,o=m,i=n;break;case 5:a=n,o=m,i=r}return[255*a,255*o,255*i]},o.cmyk.rgb=function(e){var t=e[0]/100,n=e[1]/100,s=e[2]/100,r=e[3]/100;return[255*(1-Math.min(1,t*(1-r)+r)),255*(1-Math.min(1,n*(1-r)+r)),255*(1-Math.min(1,s*(1-r)+r))]},o.xyz.rgb=function(e){var t,n,s,r=e[0]/100,a=e[1]/100,o=e[2]/100;return n=-.9689*r+1.8758*a+.0415*o,s=.0557*r+-.204*a+1.057*o,t=(t=3.2406*r+-1.5372*a+-.4986*o)>.0031308?1.055*Math.pow(t,1/2.4)-.055:12.92*t,n=n>.0031308?1.055*Math.pow(n,1/2.4)-.055:12.92*n,s=s>.0031308?1.055*Math.pow(s,1/2.4)-.055:12.92*s,[255*(t=Math.min(Math.max(0,t),1)),255*(n=Math.min(Math.max(0,n),1)),255*(s=Math.min(Math.max(0,s),1))]},o.xyz.lab=function(e){var t=e[0],n=e[1],s=e[2];return n/=100,s/=108.883,t=(t/=95.047)>.008856?Math.pow(t,1/3):7.787*t+16/116,[116*(n=n>.008856?Math.pow(n,1/3):7.787*n+16/116)-16,500*(t-n),200*(n-(s=s>.008856?Math.pow(s,1/3):7.787*s+16/116))]},o.lab.xyz=function(e){var t,n,s,r=e[0];t=e[1]/500+(n=(r+16)/116),s=n-e[2]/200;var a=Math.pow(n,3),o=Math.pow(t,3),i=Math.pow(s,3);return n=a>.008856?a:(n-16/116)/7.787,t=o>.008856?o:(t-16/116)/7.787,s=i>.008856?i:(s-16/116)/7.787,[t*=95.047,n*=100,s*=108.883]},o.lab.lch=function(e){var t,n=e[0],s=e[1],r=e[2];return(t=360*Math.atan2(r,s)/2/Math.PI)<0&&(t+=360),[n,Math.sqrt(s*s+r*r),t]},o.lch.lab=function(e){var t,n=e[0],s=e[1];return t=e[2]/360*2*Math.PI,[n,s*Math.cos(t),s*Math.sin(t)]},o.rgb.ansi16=function(e){var t=e[0],n=e[1],s=e[2],r=1 in arguments?arguments[1]:o.rgb.hsv(e)[2];if(0===(r=Math.round(r/50)))return 30;var a=30+(Math.round(s/255)<<2|Math.round(n/255)<<1|Math.round(t/255));return 2===r&&(a+=60),a},o.hsv.ansi16=function(e){return o.rgb.ansi16(o.hsv.rgb(e),e[2])},o.rgb.ansi256=function(e){var t=e[0],n=e[1],s=e[2];return t===n&&n===s?t<8?16:t>248?231:Math.round((t-8)/247*24)+232:16+36*Math.round(t/255*5)+6*Math.round(n/255*5)+Math.round(s/255*5)},o.ansi16.rgb=function(e){var t=e%10;if(0===t||7===t)return e>50&&(t+=3.5),[t=t/10.5*255,t,t];var n=.5*(1+~~(e>50));return[(1&t)*n*255,(t>>1&1)*n*255,(t>>2&1)*n*255]},o.ansi256.rgb=function(e){if(e>=232){var t=10*(e-232)+8;return[t,t,t]}var n;return e-=16,[Math.floor(e/36)/5*255,Math.floor((n=e%36)/6)/5*255,n%6/5*255]},o.rgb.hex=function(e){var t=(((255&Math.round(e[0]))<<16)+((255&Math.round(e[1]))<<8)+(255&Math.round(e[2]))).toString(16).toUpperCase();return"000000".substring(t.length)+t},o.hex.rgb=function(e){var t=e.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!t)return[0,0,0];var n=t[0];3===t[0].length&&(n=n.split("").map(function(e){return e+e}).join(""));var s=parseInt(n,16);return[s>>16&255,s>>8&255,255&s]},o.rgb.hcg=function(e){var t,n=e[0]/255,s=e[1]/255,r=e[2]/255,a=Math.max(Math.max(n,s),r),o=Math.min(Math.min(n,s),r),i=a-o;return t=i<=0?0:a===n?(s-r)/i%6:a===s?2+(r-n)/i:4+(n-s)/i+4,t/=6,[360*(t%=1),100*i,100*(i<1?o/(1-i):0)]},o.hsl.hcg=function(e){var t=e[1]/100,n=e[2]/100,s=1,r=0;return(s=n<.5?2*t*n:2*t*(1-n))<1&&(r=(n-.5*s)/(1-s)),[e[0],100*s,100*r]},o.hsv.hcg=function(e){var t=e[1]/100,n=e[2]/100,s=t*n,r=0;return s<1&&(r=(n-s)/(1-s)),[e[0],100*s,100*r]},o.hcg.rgb=function(e){var t=e[0]/360,n=e[1]/100,s=e[2]/100;if(0===n)return[255*s,255*s,255*s];var r,a=[0,0,0],o=t%1*6,i=o%1,c=1-i;switch(Math.floor(o)){case 0:a[0]=1,a[1]=i,a[2]=0;break;case 1:a[0]=c,a[1]=1,a[2]=0;break;case 2:a[0]=0,a[1]=1,a[2]=i;break;case 3:a[0]=0,a[1]=c,a[2]=1;break;case 4:a[0]=i,a[1]=0,a[2]=1;break;default:a[0]=1,a[1]=0,a[2]=c}return r=(1-n)*s,[255*(n*a[0]+r),255*(n*a[1]+r),255*(n*a[2]+r)]},o.hcg.hsv=function(e){var t=e[1]/100,n=t+e[2]/100*(1-t),s=0;return n>0&&(s=t/n),[e[0],100*s,100*n]},o.hcg.hsl=function(e){var t=e[1]/100,n=e[2]/100*(1-t)+.5*t,s=0;return n>0&&n<.5?s=t/(2*n):n>=.5&&n<1&&(s=t/(2*(1-n))),[e[0],100*s,100*n]},o.hcg.hwb=function(e){var t=e[1]/100,n=t+e[2]/100*(1-t);return[e[0],100*(n-t),100*(1-n)]},o.hwb.hcg=function(e){var t=e[1]/100,n=1-e[2]/100,s=n-t,r=0;return s<1&&(r=(n-s)/(1-s)),[e[0],100*s,100*r]},o.apple.rgb=function(e){return[e[0]/65535*255,e[1]/65535*255,e[2]/65535*255]},o.rgb.apple=function(e){return[e[0]/255*65535,e[1]/255*65535,e[2]/255*65535]},o.gray.rgb=function(e){return[e[0]/100*255,e[0]/100*255,e[0]/100*255]},o.gray.hsl=o.gray.hsv=function(e){return[0,0,e[0]]},o.gray.hwb=function(e){return[0,100,e[0]]},o.gray.cmyk=function(e){return[0,0,0,e[0]]},o.gray.lab=function(e){return[e[0],0,0]},o.gray.hex=function(e){var t=255&Math.round(e[0]/100*255),n=((t<<16)+(t<<8)+t).toString(16).toUpperCase();return"000000".substring(n.length)+n},o.rgb.gray=function(e){return[(e[0]+e[1]+e[2])/3/255*100]}}}},{package:"@metamask/jazzicon>color>color-convert",file:"node_modules/@metamask/jazzicon/node_modules/color-convert/conversions.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-convert/index.js",{"./conversions":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-convert/conversions.js","./route":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-convert/route.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("./conversions"),r=e("./route"),a={};Object.keys(s).forEach(function(e){a[e]={},Object.defineProperty(a[e],"channels",{value:s[e].channels}),Object.defineProperty(a[e],"labels",{value:s[e].labels});var t=r(e);Object.keys(t).forEach(function(n){var s=t[n];a[e][n]=function(e){var t=function(t){if(t===undefined||null===t)return t;arguments.length>1&&(t=Array.prototype.slice.call(arguments));var n=e(t);if("object"==typeof n)for(var s=n.length,r=0;r<s;r++)n[r]=Math.round(n[r]);return n};return"conversion"in e&&(t.conversion=e.conversion),t}(s),a[e][n].raw=function(e){var t=function(t){return t===undefined||null===t?t:(arguments.length>1&&(t=Array.prototype.slice.call(arguments)),e(t))};return"conversion"in e&&(t.conversion=e.conversion),t}(s)})}),t.exports=a}}},{package:"@metamask/jazzicon>color>color-convert",file:"node_modules/@metamask/jazzicon/node_modules/color-convert/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-convert/route.js",{"./conversions":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-convert/conversions.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("./conversions");function r(e){var t=function(){for(var e={},t=Object.keys(s),n=t.length,r=0;r<n;r++)e[t[r]]={distance:-1,parent:null};return e}(),n=[e];for(t[e].distance=0;n.length;)for(var r=n.pop(),a=Object.keys(s[r]),o=a.length,i=0;i<o;i++){var c=a[i],m=t[c];-1===m.distance&&(m.distance=t[r].distance+1,m.parent=r,n.unshift(c))}return t}function a(e,t){return function(n){return t(e(n))}}function o(e,t){for(var n=[t[e].parent,e],r=s[t[e].parent][e],o=t[e].parent;t[o].parent;)n.unshift(t[o].parent),r=a(s[t[o].parent][o],r),o=t[o].parent;return r.conversion=n,r}t.exports=function(e){for(var t=r(e),n={},s=Object.keys(t),a=s.length,i=0;i<a;i++){var c=s[i];null!==t[c].parent&&(n[c]=o(c,t))}return n}}}},{package:"@metamask/jazzicon>color>color-convert",file:"node_modules/@metamask/jazzicon/node_modules/color-convert/route.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-name/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}}}},{package:"@metamask/jazzicon>color>color-convert>color-name",file:"node_modules/@metamask/jazzicon/node_modules/color-name/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color/index.js",{clone:"/home/runner/work/metamask-extension/metamask-extension/node_modules/clone/clone.js","color-convert":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/node_modules/color-convert/index.js","color-string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/color-string/color-string.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=e("clone"),r=e("color-convert"),a=e("color-string"),o=function(e){if(e instanceof o)return e;if(!(this instanceof o))return new o(e);var t;if(this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1},"string"==typeof e)if(t=a.getRgba(e))this.setValues("rgb",t);else if(t=a.getHsla(e))this.setValues("hsl",t);else{if(!(t=a.getHwb(e)))throw new Error('Unable to parse color from string "'+e+'"');this.setValues("hwb",t)}else if("object"==typeof e)if((t=e).r!==undefined||t.red!==undefined)this.setValues("rgb",t);else if(t.l!==undefined||t.lightness!==undefined)this.setValues("hsl",t);else if(t.v!==undefined||t.value!==undefined)this.setValues("hsv",t);else if(t.w!==undefined||t.whiteness!==undefined)this.setValues("hwb",t);else{if(t.c===undefined&&t.cyan===undefined)throw new Error("Unable to parse color from object "+JSON.stringify(e));this.setValues("cmyk",t)}};o.prototype={rgb:function(){return this.setSpace("rgb",arguments)},hsl:function(){return this.setSpace("hsl",arguments)},hsv:function(){return this.setSpace("hsv",arguments)},hwb:function(){return this.setSpace("hwb",arguments)},cmyk:function(){return this.setSpace("cmyk",arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){return 1!==this.values.alpha?this.values.hwb.concat([this.values.alpha]):this.values.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){return this.values.rgb.concat([this.values.alpha])},rgbaArrayNormalized:function(){for(var e=this.values.rgb,t=[],n=0;n<3;n++)t[n]=e[n]/255;return t.push(this.values.alpha),t},hslaArray:function(){return this.values.hsl.concat([this.values.alpha])},alpha:function(e){return e===undefined?this.values.alpha:(this.setValues("alpha",e),this)},red:function(e){return this.setChannel("rgb",0,e)},green:function(e){return this.setChannel("rgb",1,e)},blue:function(e){return this.setChannel("rgb",2,e)},hue:function(e){return e&&(e=(e%=360)<0?360+e:e),this.setChannel("hsl",0,e)},saturation:function(e){return this.setChannel("hsl",1,e)},lightness:function(e){return this.setChannel("hsl",2,e)},saturationv:function(e){return this.setChannel("hsv",1,e)},whiteness:function(e){return this.setChannel("hwb",1,e)},blackness:function(e){return this.setChannel("hwb",2,e)},value:function(e){return this.setChannel("hsv",2,e)},cyan:function(e){return this.setChannel("cmyk",0,e)},magenta:function(e){return this.setChannel("cmyk",1,e)},yellow:function(e){return this.setChannel("cmyk",2,e)},black:function(e){return this.setChannel("cmyk",3,e)},hexString:function(){return a.hexString(this.values.rgb)},rgbString:function(){return a.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return a.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return a.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return a.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return a.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return a.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return a.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){return this.values.rgb[0]<<16|this.values.rgb[1]<<8|this.values.rgb[2]},luminosity:function(){for(var e=this.values.rgb,t=[],n=0;n<e.length;n++){var s=e[n]/255;t[n]=s<=.03928?s/12.92:Math.pow((s+.055)/1.055,2.4)}return.2126*t[0]+.7152*t[1]+.0722*t[2]},contrast:function(e){var t=this.luminosity(),n=e.luminosity();return t>n?(t+.05)/(n+.05):(n+.05)/(t+.05)},level:function(e){var t=this.contrast(e);return t>=7.1?"AAA":t>=4.5?"AA":""},dark:function(){var e=this.values.rgb;return(299*e[0]+587*e[1]+114*e[2])/1e3<128},light:function(){return!this.dark()},negate:function(){for(var e=[],t=0;t<3;t++)e[t]=255-this.values.rgb[t];return this.setValues("rgb",e),this},lighten:function(e){return this.values.hsl[2]+=this.values.hsl[2]*e,this.setValues("hsl",this.values.hsl),this},darken:function(e){return this.values.hsl[2]-=this.values.hsl[2]*e,this.setValues("hsl",this.values.hsl),this},saturate:function(e){return this.values.hsl[1]+=this.values.hsl[1]*e,this.setValues("hsl",this.values.hsl),this},desaturate:function(e){return this.values.hsl[1]-=this.values.hsl[1]*e,this.setValues("hsl",this.values.hsl),this},whiten:function(e){return this.values.hwb[1]+=this.values.hwb[1]*e,this.setValues("hwb",this.values.hwb),this},blacken:function(e){return this.values.hwb[2]+=this.values.hwb[2]*e,this.setValues("hwb",this.values.hwb),this},greyscale:function(){var e=this.values.rgb,t=.3*e[0]+.59*e[1]+.11*e[2];return this.setValues("rgb",[t,t,t]),this},clearer:function(e){return this.setValues("alpha",this.values.alpha-this.values.alpha*e),this},opaquer:function(e){return this.setValues("alpha",this.values.alpha+this.values.alpha*e),this},rotate:function(e){var t=this.values.hsl[0];return t=(t=(t+e)%360)<0?360+t:t,this.values.hsl[0]=t,this.setValues("hsl",this.values.hsl),this},mix:function(e,t){var n=this,s=e,r=t===undefined?.5:t,a=2*r-1,o=n.alpha()-s.alpha(),i=((a*o===-1?a:(a+o)/(1+a*o))+1)/2,c=1-i;return this.rgb(i*n.red()+c*s.red(),i*n.green()+c*s.green(),i*n.blue()+c*s.blue()).alpha(n.alpha()*r+s.alpha()*(1-r))},toJSON:function(){return this.rgb()},clone:function(){var e=new o;return e.values=s(this.values),e}},o.prototype.getValues=function(e){for(var t={},n=0;n<e.length;n++)t[e.charAt(n)]=this.values[e][n];return 1!==this.values.alpha&&(t.a=this.values.alpha),t},o.prototype.setValues=function(e,t){var n,s,a={rgb:["red","green","blue"],hsl:["hue","saturation","lightness"],hsv:["hue","saturation","value"],hwb:["hue","whiteness","blackness"],cmyk:["cyan","magenta","yellow","black"]},o={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]},i=1;if("alpha"===e)i=t;else if(t.length)this.values[e]=t.slice(0,e.length),i=t[e.length];else if(t[e.charAt(0)]!==undefined){for(n=0;n<e.length;n++)this.values[e][n]=t[e.charAt(n)];i=t.a}else if(t[a[e][0]]!==undefined){var c=a[e];for(n=0;n<e.length;n++)this.values[e][n]=t[c[n]];i=t.alpha}if(this.values.alpha=Math.max(0,Math.min(1,i===undefined?this.values.alpha:i)),"alpha"===e)return!1;for(n=0;n<e.length;n++)s=Math.max(0,Math.min(o[e][n],this.values[e][n])),this.values[e][n]=Math.round(s);for(var m in a)for(m!==e&&(this.values[m]=r[e][m](this.values[e])),n=0;n<m.length;n++)s=Math.max(0,Math.min(o[m][n],this.values[m][n])),this.values[m][n]=Math.round(s);return!0},o.prototype.setSpace=function(e,t){var n=t[0];return n===undefined?this.getValues(e):("number"==typeof n&&(n=Array.prototype.slice.call(t)),this.setValues(e,n),this)},o.prototype.setChannel=function(e,t,n){return n===undefined?this.values[e][t]:(n===this.values[e][t]||(this.values[e][t]=n,this.setValues(e,this.values[e])),this)},t.exports=o}}},{package:"@metamask/jazzicon>color",file:"node_modules/@metamask/jazzicon/node_modules/color/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/paper.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e,t){var n=document.createElement("div");return n.style.borderRadius="50px",n.style.overflow="hidden",n.style.padding="0px",n.style.margin="0px",n.style.width=e+"px",n.style.height=e+"px",n.style.display="inline-block",n.style.background=t,{container:n}}}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/paper.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i,c,m,d,u,l,h,p,f,g=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},y=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},k=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcEngine=void 0;const b=e("@metamask/rpc-errors"),x=k(e("@metamask/safe-event-emitter")),w=e("@metamask/utils");class _ extends x.default{constructor({notificationHandler:e}={}){super(),s.add(this),a.set(this,!1),o.set(this,void 0),i.set(this,void 0),g(this,o,[],"f"),g(this,i,e,"f")}destroy(){y(this,o,"f").forEach(e=>{"destroy"in e&&"function"==typeof e.destroy&&e.destroy()}),g(this,o,[],"f"),g(this,a,!0,"f")}push(e){y(this,s,"m",c).call(this),y(this,o,"f").push(e)}handle(e,t){if(y(this,s,"m",c).call(this),t&&"function"!=typeof t)throw new Error('"callback" must be a function if provided.');return Array.isArray(e)?t?y(this,s,"m",m).call(this,e,t):y(this,s,"m",m).call(this,e):t?y(this,s,"m",d).call(this,e,t):this._promiseHandle(e)}asMiddleware(){return y(this,s,"m",c).call(this),async(e,t,n,s)=>{try{const[a,i,c]=await y(r,r,"m",l).call(r,e,t,y(this,o,"f"));return i?(await y(r,r,"m",p).call(r,c),s(a)):n(async e=>{try{await y(r,r,"m",p).call(r,c)}catch(t){return e(t)}return e()})}catch(e){return s(e)}}}async _promiseHandle(e){return new Promise((t,n)=>{y(this,s,"m",d).call(this,e,(e,s)=>{e&&s===undefined?n(e):t(s)}).catch(n)})}}function v(e){return JSON.stringify(e,null,2)}n.JsonRpcEngine=_,r=_,a=new WeakMap,o=new WeakMap,i=new WeakMap,s=new WeakSet,c=function(){if(y(this,a,"f"))throw new Error("This engine is destroyed and can no longer be used.")},m=async function(e,t){try{if(0===e.length){const e=[{id:null,jsonrpc:"2.0",error:new b.JsonRpcError(b.errorCodes.rpc.invalidRequest,"Request batch must contain plain objects. Received an empty array")}];return t?t(null,e):e}const n=(await Promise.all(e.map(this._promiseHandle.bind(this)))).filter(e=>e!==undefined);return t?t(null,n):n}catch(e){if(t)return t(e);throw e}},d=async function(e,t){if(!e||Array.isArray(e)||"object"!=typeof e){const n=new b.JsonRpcError(b.errorCodes.rpc.invalidRequest,"Requests must be plain objects. Received: "+typeof e,{request:e});return t(n,{id:null,jsonrpc:"2.0",error:n})}if("string"!=typeof e.method){const n=new b.JsonRpcError(b.errorCodes.rpc.invalidRequest,"Must specify a string method. Received: "+typeof e.method,{request:e});return y(this,i,"f")&&!(0,w.isJsonRpcRequest)(e)?t(null):t(n,{id:e.id??null,jsonrpc:"2.0",error:n})}if(y(this,i,"f")&&(0,w.isJsonRpcNotification)(e)&&!(0,w.isJsonRpcRequest)(e)){try{await y(this,i,"f").call(this,e)}catch(n){return t(n)}return t(null)}let n=null;const s={...e},a={id:s.id,jsonrpc:s.jsonrpc};try{await y(r,r,"m",u).call(r,s,a,y(this,o,"f"))}catch(e){n=e}return n&&(delete a.result,a.error||(a.error=(0,b.serializeError)(n))),t(n,a)},u=async function(e,t,n){const[s,a,o]=await y(r,r,"m",l).call(r,e,t,n);if(y(r,r,"m",f).call(r,e,t,a),await y(r,r,"m",p).call(r,o),s)throw s},l=async function(e,t,n){const s=[];let a=null,o=!1;for(const i of n)if([a,o]=await y(r,r,"m",h).call(r,e,t,i,s),o)break;return[a,o,s.reverse()]},h=async function(e,t,n,s){return new Promise(r=>{const a=e=>{const n=e||t.error;n&&(t.error=(0,b.serializeError)(n)),r([n,!0])},o=n=>{t.error?a(t.error):(n&&("function"!=typeof n&&a(new b.JsonRpcError(b.errorCodes.rpc.internal,`JsonRpcEngine: "next" return handlers must be functions. Received "${typeof n}" for request:\n${v(e)}`,{request:e})),s.push(n)),r([null,!1]))};try{n(e,t,o,a)}catch(e){a(e)}})},p=async function(e){for(const t of e)await new Promise((e,n)=>{t(t=>t?n(t):e())})},f=function(e,t,n){if(!(0,w.hasProperty)(t,"result")&&!(0,w.hasProperty)(t,"error"))throw new b.JsonRpcError(b.errorCodes.rpc.internal,`JsonRpcEngine: Response has no error or result for request:\n${v(e)}`,{request:e});if(!n)throw new b.JsonRpcError(b.errorCodes.rpc.internal,`JsonRpcEngine: Nothing ended request:\n${v(e)}`,{request:e})}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createAsyncMiddleware=void 0,n.createAsyncMiddleware=function(e){return async(t,n,s,r)=>{let a;const o=new Promise(e=>{a=e});let i=null,c=!1;const m=async()=>(c=!0,s(e=>{i=e,a()}),o);try{await e(t,n,m),c?(await o,i(null)):r(null)}catch(e){i?i(e):r(e)}}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createScaffoldMiddleware=void 0,n.createScaffoldMiddleware=function(e){return(t,n,s,r)=>{const a=e[t.method];return a===undefined?s():"function"==typeof a?a(t,n,s,r):(n.result=a,r())}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getUniqueId=void 0;const s=4294967295;let r=Math.floor(Math.random()*s);n.getUniqueId=function(){return r=(r+1)%s,r}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs",{"./getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createIdRemapMiddleware=void 0;const s=e("./getUniqueId.cjs");n.createIdRemapMiddleware=function(){return(e,t,n,r)=>{const a=e.id,o=(0,s.getUniqueId)();e.id=o,t.id=o,n(n=>{e.id=a,t.id=a,n()})}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs",{"./JsonRpcEngine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs","./createAsyncMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs","./createScaffoldMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs","./getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs","./idRemapMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs","./mergeMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMiddleware=n.JsonRpcEngine=n.createIdRemapMiddleware=n.getUniqueId=n.createScaffoldMiddleware=n.createAsyncMiddleware=void 0;var s=e("./createAsyncMiddleware.cjs");Object.defineProperty(n,"createAsyncMiddleware",{enumerable:!0,get:function(){return s.createAsyncMiddleware}});var r=e("./createScaffoldMiddleware.cjs");Object.defineProperty(n,"createScaffoldMiddleware",{enumerable:!0,get:function(){return r.createScaffoldMiddleware}});var a=e("./getUniqueId.cjs");Object.defineProperty(n,"getUniqueId",{enumerable:!0,get:function(){return a.getUniqueId}});var o=e("./idRemapMiddleware.cjs");Object.defineProperty(n,"createIdRemapMiddleware",{enumerable:!0,get:function(){return o.createIdRemapMiddleware}});var i=e("./JsonRpcEngine.cjs");Object.defineProperty(n,"JsonRpcEngine",{enumerable:!0,get:function(){return i.JsonRpcEngine}});var c=e("./mergeMiddleware.cjs");Object.defineProperty(n,"mergeMiddleware",{enumerable:!0,get:function(){return c.mergeMiddleware}})}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs",{"./JsonRpcEngine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMiddleware=void 0;const s=e("./JsonRpcEngine.cjs");n.mergeMiddleware=function(e){const t=new s.JsonRpcEngine;return e.forEach(e=>t.push(e)),t.asMiddleware()}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createEngineStream.cjs",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const s=e("readable-stream");n.default=function(e){if(!e?.engine)throw new Error("Missing engine parameter!");const{engine:t}=e,n=new s.Duplex({objectMode:!0,read:()=>undefined,write:function(e,s,r){t.handle(e,(e,t)=>{n.push(t)}),r()}});return t.on&&t.on("notification",e=>{n.push(e)}),n}}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/createEngineStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createStreamMiddleware.cjs",{"@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0});const r=s(e("@metamask/safe-event-emitter")),a=e("@metamask/utils"),o=e("readable-stream");n.default=function(e={}){const t={},n=new o.Duplex({objectMode:!0,read:()=>undefined,write:function(n,r,o){let c=null;try{!(0,a.hasProperty)(n,"id")?function(n){e?.retryOnMessage&&n.method===e.retryOnMessage&&Object.values(t).forEach(({req:e,retryCount:n=0})=>{if(!e.id)return;if(n>=3)throw new Error(`StreamMiddleware - Retry limit exceeded for request id "${e.id}"`);const s=t[e.id];s&&(s.retryCount=n+1),i(e)});s.emit("notification",n)}(n):function(e){const{id:n}=e;if(null===n)return;const s=t[n];if(!s)return void console.warn(`StreamMiddleware - Unknown response id "${n}"`);delete t[n],Object.assign(s.res,e),setTimeout(s.end)}(n)}catch(e){c=e}o(c)}}),s=new r.default;return{events:s,middleware:(e,n,s,r)=>{t[e.id]={req:e,res:n,next:s,end:r},i(e)},stream:n};function i(e){n.push(e)}}}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/createStreamMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs",{"./createEngineStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createEngineStream.cjs","./createStreamMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/createStreamMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.createStreamMiddleware=n.createEngineStream=void 0;const r=s(e("./createEngineStream.cjs"));n.createEngineStream=r.default;const a=s(e("./createStreamMiddleware.cjs"));n.createStreamMiddleware=a.default}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs",{"./BIP44Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs","./SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},a=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.getBIP44AddressKeyDeriver=n.deriveBIP44AddressKey=n.BIP44CoinTypeNode=n.BIP_44_COIN_TYPE_DEPTH=void 0;const o=e("./BIP44Node.cjs"),i=e("./constants.cjs"),c=e("./SLIP10Node.cjs"),m=e("./utils.cjs");n.BIP_44_COIN_TYPE_DEPTH=2;class d{static async fromJSON(e,t,n){l(t),u(e.depth);const s=await o.BIP44Node.fromExtendedKey({depth:e.depth,index:e.index,network:e.network,parentFingerprint:e.parentFingerprint,chainCode:(0,m.hexStringToBytes)(e.chainCode),privateKey:(0,m.nullableHexStringToBytes)(e.privateKey),publicKey:(0,m.hexStringToBytes)(e.publicKey)},n);return new d(s,t)}static async fromDerivationPath(e,t,n){u(e.length-1);const s=await o.BIP44Node.fromDerivationPath({derivationPath:e,network:t},n),r=(0,m.getBIP44CoinType)(e);return new d(s,r)}static async fromSeed({derivationPath:e,network:t},n){u(e.length-1);const s=await o.BIP44Node.fromSeed({derivationPath:e,network:t},n),r=(0,m.getBIP44CoinType)(e);return new d(s,r)}static async fromNode(e,t){if(!(e instanceof o.BIP44Node))throw new Error("Invalid node: Expected an instance of BIP44Node.");return l(t),u(e.depth),Promise.resolve(new d(e,t))}constructor(e,t){s.set(this,void 0),r(this,s,e,"f"),this.coin_type=t,this.path=(0,m.getBIP44CoinTypePathString)(t),Object.freeze(this)}get depth(){return a(this,s,"f").depth}get privateKeyBytes(){return a(this,s,"f").privateKeyBytes}get publicKeyBytes(){return a(this,s,"f").publicKeyBytes}get chainCodeBytes(){return a(this,s,"f").chainCodeBytes}get privateKey(){return a(this,s,"f").privateKey}get publicKey(){return a(this,s,"f").publicKey}get compressedPublicKey(){return a(this,s,"f").compressedPublicKey}get compressedPublicKeyBytes(){return a(this,s,"f").compressedPublicKeyBytes}get chainCode(){return a(this,s,"f").chainCode}get address(){return a(this,s,"f").address}get masterFingerprint(){return a(this,s,"f").masterFingerprint}get parentFingerprint(){return a(this,s,"f").parentFingerprint}get fingerprint(){return a(this,s,"f").fingerprint}get index(){return a(this,s,"f").index}get network(){return a(this,s,"f").network}get curve(){return a(this,s,"f").curve}get extendedKey(){return a(this,s,"f").extendedKey}async deriveBIP44AddressKey({account:e=0,change:t=0,address_index:n}){return await a(this,s,"f").derive((0,m.getBIP44CoinTypeToAddressPathTuple)({account:e,change:t,address_index:n}))}toJSON(){return{...a(this,s,"f").toJSON(),coin_type:this.coin_type,path:this.path}}}function u(e){if(e!==n.BIP_44_COIN_TYPE_DEPTH)throw new Error(`Invalid depth: Coin type nodes must be of depth ${n.BIP_44_COIN_TYPE_DEPTH}. Received: "${e}"`)}function l(e){if("number"!=typeof e||!Number.isInteger(e)||e<0)throw new Error("Invalid coin type: The specified coin type must be a non-negative integer number.")}async function h(e,t){if(e instanceof d)return u(e.depth),e;if("string"==typeof e){const n=await o.BIP44Node.fromExtendedKey(e,t),s=await d.fromNode(n,n.index-i.BIP_32_HARDENED_OFFSET);return u(s.depth),s}return d.fromJSON(e,e.coin_type,t)}n.BIP44CoinTypeNode=d,s=new WeakMap,n.deriveBIP44AddressKey=async function(e,{account:t=0,change:n=0,address_index:s},r){const a=(0,m.getBIP44CoinTypeToAddressPathTuple)({account:t,change:n,address_index:s}),i=await h(e,r),d=await(0,c.deriveChildNode)({path:a,node:i},r);return new o.BIP44Node(d)},n.getBIP44AddressKeyDeriver=async function(e,t,n){const{account:s=0,change:r=0}=t??{},a=await h(e,n),i=(0,m.getHardenedBIP32NodeToken)(s),d=(0,m.getBIP32NodeToken)(r),u=async(e,t=!1)=>{const s=await(0,c.deriveChildNode)({path:[i,d,t?(0,m.getHardenedBIP32NodeToken)(e):(0,m.getUnhardenedBIP32NodeToken)(e)],node:a},n);return new o.BIP44Node(s)};return u.coin_type=a.coin_type,u.path=(0,m.getBIP44ChangePathString)(a.path,{account:s,change:r}),Object.freeze(u),u}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs",{"./SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./extended-keys.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/extended-keys.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},a=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.validateBIP44Depth=n.BIP44Node=void 0;const o=e("@metamask/utils"),i=e("./constants.cjs"),c=e("./extended-keys.cjs"),m=e("./SLIP10Node.cjs"),d=e("./utils.cjs");class u{static async fromJSON(e,t){return u.fromExtendedKey(e,t)}static async fromExtendedKey(e,t){if("string"==typeof e){const n=(0,c.decodeExtendedKey)(e),{type:s,chainCode:r,depth:a,parentFingerprint:o,index:i,network:m}=n;if("private"===s){const{privateKey:e}=n;return u.fromExtendedKey({depth:a,parentFingerprint:o,index:i,network:m,privateKey:e,chainCode:r},t)}const{publicKey:d}=n;return u.fromExtendedKey({depth:a,parentFingerprint:o,index:i,network:m,publicKey:d,chainCode:r},t)}const{privateKey:n,publicKey:s,chainCode:r,depth:a,parentFingerprint:o,index:i,network:d}=e;l(a);const h=await m.SLIP10Node.fromExtendedKey({privateKey:n,publicKey:s,chainCode:r,depth:a,parentFingerprint:o,index:i,network:d,curve:"secp256k1"},t);return new u(h)}static async fromDerivationPath({derivationPath:e,network:t},n){l(e.length-1),h(e,i.MIN_BIP_44_DEPTH);const s=await m.SLIP10Node.fromDerivationPath({derivationPath:e,network:t,curve:"secp256k1"},n);return new u(s)}static async fromSeed({derivationPath:e,network:t},n){l(e.length-1),h(e,i.MIN_BIP_44_DEPTH);const s=await m.SLIP10Node.fromSeed({derivationPath:e,network:t,curve:"secp256k1"},n);return new u(s)}get depth(){return r(this,s,"f").depth}get privateKeyBytes(){return r(this,s,"f").privateKeyBytes}get publicKeyBytes(){return r(this,s,"f").publicKeyBytes}get chainCodeBytes(){return r(this,s,"f").chainCodeBytes}get privateKey(){return r(this,s,"f").privateKey}get publicKey(){return r(this,s,"f").publicKey}get compressedPublicKey(){return r(this,s,"f").compressedPublicKey}get compressedPublicKeyBytes(){return r(this,s,"f").compressedPublicKeyBytes}get chainCode(){return r(this,s,"f").chainCode}get address(){return r(this,s,"f").address}get masterFingerprint(){return r(this,s,"f").masterFingerprint}get parentFingerprint(){return r(this,s,"f").parentFingerprint}get fingerprint(){return r(this,s,"f").fingerprint}get index(){return r(this,s,"f").index}get network(){return r(this,s,"f").network}get extendedKey(){return r(this,s,"f").extendedKey}get curve(){return r(this,s,"f").curve}constructor(e){s.set(this,void 0),a(this,s,e,"f"),Object.freeze(this)}neuter(){const e=r(this,s,"f").neuter();return new u(e)}async derive(e){if(this.depth===i.MAX_BIP_44_DEPTH)throw new Error("Illegal operation: This HD tree node is already a leaf node.");l(this.depth+e.length),h(e,this.depth+1);const t=await r(this,s,"f").derive(e);return new u(t)}toJSON(){return{depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,privateKey:this.privateKey,publicKey:this.publicKey,chainCode:this.chainCode}}}function l(e){if((0,m.validateBIP32Depth)(e),e<i.MIN_BIP_44_DEPTH||e>i.MAX_BIP_44_DEPTH)throw new Error(`Invalid HD tree path depth: The depth must be a positive integer N such that 0 <= N <= 5. Received: "${e}"`)}function h(e,t){e.forEach((e,n)=>{const s=t+n;if(s!==i.MIN_BIP_44_DEPTH)switch((0,o.assert)("string"==typeof e),s){case 1:if(e!==i.BIP44PurposeNodeToken)throw new Error(`Invalid derivation path: The "purpose" node (depth 1) must be the string "${i.BIP44PurposeNodeToken}".`);break;case 2:if(!i.BIP_32_PATH_REGEX.test(e)||!(0,d.isHardened)(e))throw new Error('Invalid derivation path: The "coin_type" node (depth 2) must be a hardened BIP-32 node.');break;case 3:if(!i.BIP_32_PATH_REGEX.test(e)||!(0,d.isHardened)(e))throw new Error('Invalid derivation path: The "account" node (depth 3) must be a hardened BIP-32 node.');break;case 4:if(!i.BIP_32_PATH_REGEX.test(e))throw new Error('Invalid derivation path: The "change" node (depth 4) must be a BIP-32 node.');break;case i.MAX_BIP_44_DEPTH:if(!i.BIP_32_PATH_REGEX.test(e))throw new Error('Invalid derivation path: The "address_index" node (depth 5) must be a BIP-32 node.')}else if(!(e instanceof Uint8Array||i.BIP_39_PATH_REGEX.test(e)))throw new Error('Invalid derivation path: The "m" / seed node (depth 0) must be a BIP-39 node.')})}n.BIP44Node=u,s=new WeakMap,n.validateBIP44Depth=l}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/BIP44Node.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","./derivation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivation.cjs","./derivers/bip32.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip32.cjs","./derivers/bip39.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip39.cjs","./extended-keys.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/extended-keys.cjs","./guard.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/guard.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},c=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildNode=n.validateRootIndex=n.validateMasterParentFingerprint=n.validateParentFingerprint=n.validateBIP32Depth=n.SLIP10Node=void 0;const m=e("@metamask/utils"),d=e("./constants.cjs"),u=e("./curves/index.cjs"),l=e("./derivation.cjs"),h=e("./derivers/bip32.cjs"),p=e("./derivers/bip39.cjs"),f=e("./extended-keys.cjs"),g=e("./guard.cjs"),y=e("./utils.cjs");class k{static async fromJSON(e,t){return s.fromExtendedKey(e,t)}static async fromExtendedKey(e,t){if("string"==typeof e){const n=(0,f.decodeExtendedKey)(e),{chainCode:r,depth:a,parentFingerprint:o,index:i}=n;if("private"===n.type){const{privateKey:e}=n;return s.fromExtendedKey({depth:a,parentFingerprint:o,index:i,privateKey:e,chainCode:r,curve:"secp256k1"},t)}const{publicKey:c}=n;return s.fromExtendedKey({depth:a,parentFingerprint:o,index:i,publicKey:c,chainCode:r,curve:"secp256k1"},t)}const{depth:n,masterFingerprint:a,parentFingerprint:o,index:c,network:l,privateKey:h,publicKey:p,chainCode:k,curve:v,guard:E}=e,T=(0,y.getBytes)(k,d.BYTES_KEY_LENGTH);(0,y.validateCurve)(v),b(n),(0,y.validateBIP32Index)(c),_(c,n),(0,y.validateNetwork)(l),x(o,n),w(a,o,n);const j=(0,u.getCurveByName)(v);if(h){const e=(0,y.getBytesUnsafe)(h,j.privateKeyLength);(0,m.assert)(j.isValidPrivateKey(e),`Invalid private key: Value is not a valid ${v} private key.`);const d=E===g.PUBLIC_KEY_GUARD&&p?(0,y.getBytes)(p,j.publicKeyLength):undefined;return new s({depth:n,masterFingerprint:a,parentFingerprint:o,index:c,network:l,chainCode:T,privateKey:e,publicKey:d,curve:v},t,i(this,s,"f",r))}if(p){const e=(0,y.getBytes)(p,j.publicKeyLength);return new s({depth:n,masterFingerprint:a,parentFingerprint:o,index:c,network:l,chainCode:T,publicKey:e,curve:v},t,i(this,s,"f",r))}throw new Error("Invalid options: Must provide either a private key or a public key.")}static async fromDerivationPath({derivationPath:e,network:t,curve:n},s){if((0,y.validateCurve)(n),!e)throw new Error("Invalid options: Must provide a derivation path.");if(0===e.length)throw new Error("Invalid derivation path: May not specify an empty derivation path.");const r=await(0,p.getDerivationPathWithSeed)({path:e,curve:n},s);return await(0,l.deriveKeyFromPath)({path:r,depth:e.length-1,network:t,curve:n},s)}static async fromSeed({derivationPath:e,network:t,curve:n},s){if((0,y.validateCurve)(n),"ed25519Bip32"===n)throw new Error('Invalid curve: The curve "ed25519Bip32" is not supported by the `fromSeed` function.');if(!e)throw new Error("Invalid options: Must provide a derivation path.");if(0===e.length)throw new Error("Invalid derivation path: May not specify an empty derivation path.");return await(0,l.deriveKeyFromPath)({path:e,depth:e.length-1,network:t,curve:n},s)}constructor({depth:e,masterFingerprint:t,parentFingerprint:n,index:d,network:u="mainnet",chainCode:l,privateKey:h,publicKey:p,curve:f},g={},y){a.set(this,void 0),o.set(this,void 0),(0,m.assert)(y===i(s,s,"f",r),"SLIP10Node can only be constructed using `SLIP10Node.fromJSON`, `SLIP10Node.fromExtendedKey`, `SLIP10Node.fromDerivationPath`, or `SLIP10Node.fromSeed`."),(0,m.assert)(h!==undefined||p!==undefined,"SLIP10Node requires either a private key or a public key to be set."),this.depth=e,this.masterFingerprint=t,this.parentFingerprint=n,this.index=d,this.network=u,this.chainCodeBytes=l,this.privateKeyBytes=h,this.curve=f,c(this,a,p,"f"),c(this,o,g,"f"),Object.freeze(this)}get chainCode(){return(0,m.bytesToHex)(this.chainCodeBytes)}get privateKey(){return this.privateKeyBytes?(0,m.bytesToHex)(this.privateKeyBytes):undefined}get publicKey(){return(0,m.bytesToHex)(this.publicKeyBytes)}get publicKeyBytes(){return i(this,a,"f")!==undefined||((0,m.assert)(this.privateKeyBytes,"Either a private key or public key is required."),c(this,a,(0,u.getCurveByName)(this.curve).getPublicKey(this.privateKeyBytes),"f")),i(this,a,"f")}get compressedPublicKeyBytes(){return(0,u.getCurveByName)(this.curve).compressPublicKey(this.publicKeyBytes)}get compressedPublicKey(){return(0,m.bytesToHex)(this.compressedPublicKeyBytes)}get address(){if("secp256k1"!==this.curve)throw new Error("Unable to get address for this node: Only secp256k1 is supported.");return(0,m.bytesToHex)((0,h.publicKeyToEthAddress)(this.publicKeyBytes))}get fingerprint(){return(0,y.getFingerprint)(this.compressedPublicKeyBytes,(0,u.getCurveByName)(this.curve).compressedPublicKeyLength)}get extendedKey(){(0,m.assert)("secp256k1"===this.curve,"Unable to get extended key for this node: Only secp256k1 is supported.");const e={depth:this.depth,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,chainCode:this.chainCodeBytes};return this.privateKeyBytes?(0,f.encodeExtendedKey)({...e,type:"private",privateKey:this.privateKeyBytes}):(0,f.encodeExtendedKey)({...e,type:"public",publicKey:this.publicKeyBytes})}neuter(){return new s({depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,chainCode:this.chainCodeBytes,publicKey:this.publicKeyBytes,curve:this.curve,network:this.network},i(this,o,"f"),i(s,s,"f",r))}async derive(e){return await v({path:e,node:this},i(this,o,"f"))}toJSON(){return{depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,curve:this.curve,privateKey:this.privateKey,publicKey:this.publicKey,chainCode:this.chainCode}}}function b(e){if(!(0,y.isValidInteger)(e))throw new Error(`Invalid HD tree path depth: The depth must be a positive integer. Received: "${String(e)}".`)}function x(e,t){if(!(0,y.isValidInteger)(e))throw new Error(`Invalid parent fingerprint: The fingerprint must be a positive integer. Received: "${String(e)}".`);if(0===t&&0!==e)throw new Error(`Invalid parent fingerprint: The fingerprint of the root node must be 0. Received: "${String(e)}".`);if(t>0&&0===e)throw new Error(`Invalid parent fingerprint: The fingerprint of a child node must not be 0. Received: "${String(e)}".`)}function w(e,t,n){if(e&&n>=2&&e===t)throw new Error(`Invalid parent fingerprint: The fingerprint of a child node cannot be equal to the master fingerprint. Received: "${String(t)}".`)}function _(e,t){if(0===t&&0!==e)throw new Error(`Invalid index: The index of the root node must be 0. Received: "${String(e)}".`)}async function v({path:e,node:t},n){if(0===e.length)throw new Error("Invalid HD tree derivation path: Deriving a path of length 0 is not defined.");const s=t.depth+e.length;return b(s),await(0,l.deriveKeyFromPath)({path:e,node:t,depth:s},n)}n.SLIP10Node=k,s=k,a=new WeakMap,o=new WeakMap,r={value:Symbol("SLIP10Node.constructor")},n.validateBIP32Depth=b,n.validateParentFingerprint=x,n.validateMasterParentFingerprint=w,n.validateRootIndex=_,n.deriveChildNode=v}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/SLIP10Node.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BIP_32_HARDENED_OFFSET=n.BIP_39_PATH_REGEX=n.CIP_3_PATH_REGEX=n.SLIP_10_PATH_REGEX=n.BIP_32_PATH_REGEX=n.UNPREFIXED_BIP_32_PATH_REGEX=n.UNPREFIXED_PATH_REGEX=n.BIP44PurposeNodeToken=n.MAX_BIP_32_INDEX=n.MAX_UNHARDENED_BIP_32_INDEX=n.MAX_BIP_44_DEPTH=n.MIN_BIP_44_DEPTH=n.BYTES_KEY_LENGTH=void 0,n.BYTES_KEY_LENGTH=32,n.MIN_BIP_44_DEPTH=0,n.MAX_BIP_44_DEPTH=5,n.MAX_UNHARDENED_BIP_32_INDEX=2147483647,n.MAX_BIP_32_INDEX=4294967295,n.BIP44PurposeNodeToken="bip32:44'",n.UNPREFIXED_PATH_REGEX=/^\d+$/u,n.UNPREFIXED_BIP_32_PATH_REGEX=/^(?<index>\d+)'?$/u,n.BIP_32_PATH_REGEX=/^bip32:\d+'?$/u,n.SLIP_10_PATH_REGEX=/^slip10:\d+'?$/u,n.CIP_3_PATH_REGEX=/^cip3:\d+'?$/u,n.BIP_39_PATH_REGEX=/^bip39:([a-z]+){1}( [a-z]+){11,23}$/u,n.BIP_32_HARDENED_OFFSET=2147483648}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@noble/hashes/hmac":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/hmac.js","@noble/hashes/pbkdf2":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/pbkdf2.js","@noble/hashes/ripemd160":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/ripemd160.js","@noble/hashes/sha256":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha256.js","@noble/hashes/sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha3.js","@noble/hashes/sha512":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha512.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.sha256=n.ripemd160=n.pbkdf2Sha512=n.keccak256=n.hmacSha512=void 0;const s=e("@noble/hashes/hmac"),r=e("@noble/hashes/pbkdf2"),a=e("@noble/hashes/ripemd160"),o=e("@noble/hashes/sha256"),i=e("@noble/hashes/sha3"),c=e("@noble/hashes/sha512"),m=e("./utils.cjs");n.hmacSha512=async function(e,t,n={}){if(n.hmacSha512)return await n.hmacSha512(e,t);if((0,m.isWebCryptoSupported)()){const n=await crypto.subtle.importKey("raw",e,{name:"HMAC",hash:"SHA-512"},!1,["sign"]),s=await crypto.subtle.sign("HMAC",n,t);return new Uint8Array(s)}return(0,s.hmac)(c.sha512,e,t)},n.keccak256=function(e){return(0,i.keccak_256)(e)},n.pbkdf2Sha512=async function(e,t,n,s,a={}){if(a.pbkdf2Sha512)return await a.pbkdf2Sha512(e,t,n,s);if((0,m.isWebCryptoSupported)()){const r=await crypto.subtle.importKey("raw",e,{name:"PBKDF2"},!1,["deriveBits"]),a=await crypto.subtle.deriveBits({name:"PBKDF2",salt:t,iterations:n,hash:{name:"SHA-512"}},r,8*s);return new Uint8Array(a)}return await(0,r.pbkdf2Async)(c.sha512,e,t,{c:n,dkLen:s})},n.ripemd160=function(e){return(0,a.ripemd160)(e)},n.sha256=function(e){return(0,o.sha256)(e)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/cryptography.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/curve.cjs",{"./ed25519.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519.cjs","./ed25519Bip32.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs","./secp256k1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs","@noble/curves/abstract/modular":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/abstract/modular.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.mod=n.getCurveByName=n.curves=void 0;const o=a(e("./ed25519.cjs")),i=a(e("./ed25519Bip32.cjs")),c=a(e("./secp256k1.cjs"));n.curves={secp256k1:c,ed25519:o,ed25519Bip32:i},n.getCurveByName=function(e){return n.curves[e]};var m=e("@noble/curves/abstract/modular");Object.defineProperty(n,"mod",{enumerable:!0,get:function(){return m.mod}})}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/curve.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/ed25519":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/ed25519.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.publicKeyLength=n.deriveUnhardenedKeys=n.isValidPrivateKey=n.secret=n.name=n.curve=void 0;const s=e("@metamask/utils"),r=e("@noble/curves/ed25519");n.curve=r.ed25519.CURVE,n.name="ed25519",n.secret=(0,s.stringToBytes)("ed25519 seed");n.isValidPrivateKey=e=>!0,n.deriveUnhardenedKeys=!1,n.publicKeyLength=33;n.getPublicKey=(()=>{let e=!1;return(t,n)=>{e||(r.ed25519.ExtendedPoint.BASE._setWindowSize(4),e=!0);const a=r.ed25519.getPublicKey(t);return(0,s.concatBytes)([new Uint8Array([0]),a])}})();n.publicAdd=(e,t)=>{throw new Error("Ed25519 does not support public key derivation.")};n.compressPublicKey=e=>e;n.decompressPublicKey=e=>e,n.privateKeyLength=32,n.masterNodeGenerationSpec="slip10",n.compressedPublicKeyLength=33}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/ed25519.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/abstract/modular":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/abstract/modular.js","@noble/curves/ed25519":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/ed25519.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.multiplyWithBase=n.bytesToNumberLE=n.publicKeyLength=n.deriveUnhardenedKeys=n.isValidPrivateKey=n.secret=n.name=n.curve=void 0;const s=e("@metamask/utils"),r=e("@noble/curves/abstract/modular"),a=e("@noble/curves/ed25519");function o(e,t){const n=e[t];return(0,s.assert)(n!==undefined,"Private key is too short."),n}n.curve=a.ed25519.CURVE,n.name="ed25519Bip32",n.secret=(0,s.stringToBytes)("");n.isValidPrivateKey=e=>!(7&o(e,0))&&(!(128&o(e,31))&&!(64&~o(e,31))),n.deriveUnhardenedKeys=!0,n.publicKeyLength=32;n.bytesToNumberLE=e=>(0,s.hexToBigInt)((0,s.bytesToHex)(Uint8Array.from(e).reverse()));n.multiplyWithBase=e=>{const t=(0,r.mod)((0,n.bytesToNumberLE)(e),n.curve.n);return a.ed25519.ExtendedPoint.BASE.multiply(t).toRawBytes()};n.getPublicKey=(e,t)=>(0,n.multiplyWithBase)(e.slice(0,32));n.publicAdd=(e,t)=>a.ed25519.ExtendedPoint.fromHex((0,s.remove0x)((0,s.bytesToHex)(e))).add(a.ed25519.ExtendedPoint.fromHex((0,s.remove0x)((0,s.bytesToHex)(t)))).toRawBytes();n.compressPublicKey=e=>e;n.decompressPublicKey=e=>e,n.privateKeyLength=64,n.masterNodeGenerationSpec="cip3",n.compressedPublicKeyLength=32}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs",{"./curve.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/curve.cjs","./ed25519.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519.cjs","./ed25519Bip32.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs","./secp256k1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)},o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ed25519Bip32=n.ed25519=n.secp256k1=void 0,a(e("./curve.cjs"),n),n.secp256k1=o(e("./secp256k1.cjs")),n.ed25519=o(e("./ed25519.cjs")),n.ed25519Bip32=o(e("./ed25519Bip32.cjs"))}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs",{"../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.isValidPrivateKey=n.publicKeyLength=n.deriveUnhardenedKeys=n.secret=n.name=n.curve=void 0;const s=e("@metamask/utils"),r=e("@noble/curves/secp256k1"),a=e("../utils.cjs");n.curve=r.secp256k1.CURVE,n.name="secp256k1",n.secret=(0,s.stringToBytes)("Bitcoin seed"),n.deriveUnhardenedKeys=!0,n.publicKeyLength=65;n.isValidPrivateKey=e=>r.secp256k1.utils.isValidPrivateKey(e);n.getPublicKey=(()=>{let e=!1;return(t,n=!1)=>(e||(r.secp256k1.ProjectivePoint.BASE._setWindowSize(4),e=!0),r.secp256k1.getPublicKey(t,n))})();n.publicAdd=(e,t)=>{(0,s.assert)((0,a.isValidBytesKey)(t,32),"Invalid tweak: Tweak must be a non-zero 32-byte Uint8Array.");const n=r.secp256k1.ProjectivePoint.fromHex(e).add(r.secp256k1.ProjectivePoint.fromPrivateKey(t));return n.assertValidity(),n.toRawBytes(!1)};n.compressPublicKey=e=>r.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!0);n.decompressPublicKey=e=>r.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1),n.privateKeyLength=32,n.masterNodeGenerationSpec="slip10",n.compressedPublicKeyLength=33}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivation.cjs",{"./BIP44CoinTypeNode.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs","./BIP44Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs","./SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","./derivers/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.validatePathSegment=n.deriveKeyFromPath=void 0;const s=e("@metamask/utils"),r=e("./BIP44CoinTypeNode.cjs"),a=e("./BIP44Node.cjs"),o=e("./constants.cjs"),i=e("./curves/index.cjs"),c=e("./derivers/index.cjs"),m=e("./SLIP10Node.cjs");function d(e,t,n){if(0===e.length)throw new Error("Invalid HD path segment: The segment must not be empty.");let r=!1;if(e.forEach((e,t)=>{if(0===t){if(r=e instanceof Uint8Array||o.BIP_39_PATH_REGEX.test(e),!(e instanceof Uint8Array||r||o.BIP_32_PATH_REGEX.test(e)||o.SLIP_10_PATH_REGEX.test(e)||o.CIP_3_PATH_REGEX.test(e)))throw u()}else if(e instanceof Uint8Array||!o.BIP_32_PATH_REGEX.test(e)&&!o.SLIP_10_PATH_REGEX.test(e)&&!o.CIP_3_PATH_REGEX.test(e))throw u()}),n===o.MIN_BIP_44_DEPTH&&(!r||1!==e.length))throw new Error(`Invalid HD path segment: The segment must consist of a single BIP-39 node for depths of ${o.MIN_BIP_44_DEPTH}. Received: "${String(e)}".`);if(!t&&!r)throw new Error("Invalid derivation parameters: Must specify parent key if the first node of the path segment is not a BIP-39 node.");if(t&&r)throw new Error("Invalid derivation parameters: May not specify parent key if the path segment starts with a BIP-39 node.");const a=r?e.slice(1):e;if(a.length>0){const e=a[0]?.split(":")[0];(0,s.assert)(e),(0,s.assert)(a.every(t=>t.startsWith(`${e}:`)),"Invalid HD path segment: Cannot mix 'bip32' and 'slip10' path segments.")}}function u(){return new Error("Invalid HD path segment: The path segment is malformed.")}n.deriveKeyFromPath=async function(e,t){const{path:n,depth:o=n.length}=e,l="node"in e?e.node:undefined,h="network"in e?e.network:l?.network,p="curve"in e?e.curve:l?.curve;if(l&&!(l instanceof m.SLIP10Node)&&!(l instanceof a.BIP44Node)&&!(l instanceof r.BIP44CoinTypeNode))throw new Error("Invalid arguments: Node must be a SLIP-10 node or a BIP-44 node when provided.");if(!p)throw new Error("Invalid arguments: Must specify either a parent node or curve.");return d(n,Boolean(l?.privateKey)||Boolean(l?.publicKey),o),await n.reduce(async(e,n,r)=>{const a=await e;if("string"==typeof n){const[e,r]=n.split(":");(0,s.assert)(e),(0,s.assert)(r),(0,s.assert)(function(e){return e in c.derivers}(e),`Unknown derivation type: "${e}".`);const o=c.derivers[e];return await o.deriveChildKey({path:r,node:a,curve:(0,i.getCurveByName)(p),network:h},t)}return(0,s.assert)(0===r,u()),await c.derivers.bip39.deriveChildKey({path:n,node:a,curve:(0,i.getCurveByName)(p),network:h},t)},Promise.resolve(l))},n.validatePathSegment=d}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivation.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip32.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","../cryptography.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs","../curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","./shared.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/shared.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildKey=n.publicKeyToEthAddress=n.privateKeyToEthAddress=void 0;const s=e("@metamask/utils"),r=e("./shared.cjs"),a=e("../constants.cjs"),o=e("../cryptography.cjs"),i=e("../curves/index.cjs"),c=e("../utils.cjs");function m(e){return(0,s.assert)(e instanceof Uint8Array&&(0,c.isValidBytesKey)(e,i.secp256k1.publicKeyLength),"Invalid key: The key must be a 65-byte, non-zero Uint8Array."),(0,o.keccak256)(e.slice(1)).slice(-20)}async function d(e,t,n){const{childIndex:s,privateKey:a,publicKey:o,isHardened:i,chainCode:m,curve:d}=t;if((0,c.validateBIP32Index)(s+1),a){const e=await(0,r.deriveSecretExtension)({privateKey:a,publicKey:d.compressPublicKey(o),childIndex:s+1,isHardened:i,curve:d}),c=await(0,r.generateEntropy)({chainCode:m,extension:e},n);return{...t,childIndex:s+1,entropy:c}}const u=(0,r.derivePublicExtension)({parentPublicKey:o,childIndex:s+1}),l=await(0,r.generateEntropy)({chainCode:m,extension:u});return{...t,childIndex:s+1,entropy:l}}n.privateKeyToEthAddress=function(e){return(0,s.assert)(e instanceof Uint8Array&&(0,c.isValidBytesKey)(e,a.BYTES_KEY_LENGTH),"Invalid key: The key must be a 32-byte, non-zero Uint8Array."),m(i.secp256k1.getPublicKey(e,!1))},n.publicKeyToEthAddress=m,n.deriveChildKey=async function(e,t){return(0,s.assert)("secp256k1"===e.curve.name,"Invalid curve: Only secp256k1 is supported by BIP-32."),(0,r.deriveChildKey)(e,d,t)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/bip32.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip39.cjs",{"../SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","../cryptography.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs","../curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","../guard.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/guard.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/scure-bip39":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/index.js","@metamask/scure-bip39/dist/wordlists/english.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/wordlists/english.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.entropyToCip3MasterNode=n.createBip39KeyFromSeed=n.deriveChildKey=n.getDerivationPathWithSeed=n.multipathToBip39Mnemonic=n.bip39MnemonicToMultipath=n.mnemonicToSeed=void 0;const s=e("@metamask/scure-bip39"),r=e("@metamask/scure-bip39/dist/wordlists/english.js"),a=e("@metamask/utils"),o=e("../constants.cjs"),i=e("../cryptography.cjs"),c=e("../curves/index.cjs"),m=e("../guard.cjs"),d=e("../SLIP10Node.cjs"),u=e("../utils.cjs"),l=[12,15,18,21,24];function h(e){const t=e.split(" ");(0,a.assert)(l.includes(t.length),"Invalid mnemonic phrase: The mnemonic phrase must consist of 12, 15, 18, 21, or 24 words."),(0,a.assert)(t.every(e=>r.wordlist.includes(e)),"Invalid mnemonic phrase: The mnemonic phrase contains an unknown word.")}async function p(e,t="",n){const s=`mnemonic${t}`.normalize("NFKD");return await(0,i.pbkdf2Sha512)(function(e,t){if("string"==typeof e)return h(e),(0,a.stringToBytes)(e.normalize("NFKD"));const n=Array.from(new Uint16Array(e.buffer)).map(e=>t[e]).join(" ");return h(n),(0,a.stringToBytes)(n)}(e,r.wordlist),(0,a.stringToBytes)(s),2048,64,n)}function f(e){return e instanceof Uint8Array?e:((0,a.assert)(e.startsWith("bip39:"),'Invalid HD path segment: The BIP-39 path must start with "bip39:".'),e.slice(6))}async function g(e,t,n,s){(0,a.assert)(e.length>=16&&e.length<=64,"Invalid seed: The seed must be between 16 and 64 bytes long.");const r=await(0,i.hmacSha512)(t.secret,e,s),c=r.slice(0,o.BYTES_KEY_LENGTH),l=r.slice(o.BYTES_KEY_LENGTH);(0,a.assert)(t.isValidPrivateKey(c),"Invalid private key: The private key must greater than 0 and less than the curve order.");const h=t.getPublicKey(c,!1),p=(0,u.getFingerprint)(t.compressPublicKey(h),t.compressedPublicKeyLength);return d.SLIP10Node.fromExtendedKey({privateKey:c,publicKey:h,chainCode:l,masterFingerprint:p,network:n,depth:0,parentFingerprint:0,index:0,curve:t.name,guard:m.PUBLIC_KEY_GUARD},s)}async function y(e,t,n,s){(0,a.assert)(e.length>=16&&e.length<=64,"Invalid entropy: The entropy must be between 16 and 64 bytes long.");const r=await(0,i.pbkdf2Sha512)(t.secret,e,4096,96,s);r[0]&=248,r[31]&=31,r[31]|=64;const o=r.slice(0,t.privateKeyLength),c=r.slice(t.privateKeyLength);(0,a.assert)(t.isValidPrivateKey(o),"Invalid private key.");const l=t.getPublicKey(o,!1),h=(0,u.getFingerprint)(t.compressPublicKey(l),t.compressedPublicKeyLength);return d.SLIP10Node.fromExtendedKey({privateKey:o,publicKey:l,chainCode:c,masterFingerprint:h,network:n,depth:0,parentFingerprint:0,index:0,curve:t.name,guard:m.PUBLIC_KEY_GUARD},s)}n.mnemonicToSeed=p,n.bip39MnemonicToMultipath=function(e){return`bip39:${e.toLowerCase().trim()}`},n.multipathToBip39Mnemonic=f,n.getDerivationPathWithSeed=async function({path:e,curve:t},n){const[o,...i]=e,m=f(o),d=(0,c.getCurveByName)(t);switch(d.masterNodeGenerationSpec){case"slip10":return[await p(m,"",n),...i];case"cip3":return[(0,s.mnemonicToEntropy)(m,r.wordlist),...i];default:return(0,a.assertExhaustive)(d)}},n.deriveChildKey=async function({path:e,curve:t,network:n},s){switch((0,a.assert)(e instanceof Uint8Array,"Invalid path: The path must be a Uint8Array."),t.masterNodeGenerationSpec){case"slip10":return g(e,t,n,s);case"cip3":return y(e,t,n,s);default:throw new Error("Unsupported master node generation spec.")}},n.createBip39KeyFromSeed=g,n.entropyToCip3MasterNode=y}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/bip39.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/cip3.cjs",{"../SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","../curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","./shared.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/shared.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildKey=n.derivePublicKey=n.deriveChainCode=n.derivePrivateKey=n.getKeyExtension=n.add=n.mod2Pow256=n.trunc28Mul8=n.padEnd32Bytes=n.bigIntToBytes=n.bytesToBigInt=n.toReversed=void 0;const s=e("@metamask/utils"),r=e("./shared.cjs"),a=e("../constants.cjs"),o=e("../curves/index.cjs"),i=e("../SLIP10Node.cjs"),c=e("../utils.cjs");n.toReversed=e=>e.slice().reverse();n.bytesToBigInt=e=>{const t=(0,n.toReversed)(e),r=(0,s.bytesToHex)(t);return BigInt(r)};n.bigIntToBytes=e=>{const t=e.toString(16);return(0,n.toReversed)((0,s.hexToBytes)(t))};n.padEnd32Bytes=e=>(0,s.concatBytes)([e,new Uint8Array(Math.max(32-e.length,0)).fill(0)]);n.trunc28Mul8=e=>{const t=(0,n.bytesToBigInt)(e.slice(0,28))*BigInt(8);return(0,n.padEnd32Bytes)((0,n.bigIntToBytes)(t))};n.mod2Pow256=e=>(0,n.padEnd32Bytes)((0,n.bigIntToBytes)((0,o.mod)((0,n.bytesToBigInt)(e),BigInt(2)**BigInt(256))));n.add=(e,t)=>{const s=(0,n.bytesToBigInt)(e)+(0,n.bytesToBigInt)(t);return(0,n.padEnd32Bytes)((0,n.bigIntToBytes)(s)).slice(0,32)};n.getKeyExtension=(e,t,n)=>(0,s.concatBytes)([new Uint8Array([e]),t,(0,c.numberToUint32)(n,!0)]);const m=2,d=0;n.derivePrivateKey=async({parentNode:e,childIndex:t,isHardened:o},i)=>{const c=o?(0,n.getKeyExtension)(d,e.privateKeyBytes,t+a.BIP_32_HARDENED_OFFSET):(0,n.getKeyExtension)(m,e.publicKeyBytes,t),u=await(0,r.generateEntropy)({chainCode:e.chainCodeBytes,extension:c},i),l=u.subarray(0,32),h=u.subarray(32),p=e.privateKeyBytes.subarray(0,32),f=e.privateKeyBytes.subarray(32),g=(0,n.add)((0,n.trunc28Mul8)(l),p),y=(0,n.add)(h,f);return(0,s.concatBytes)([g,y])};const u=3,l=1;n.deriveChainCode=async({parentNode:e,childIndex:t,isHardened:s},o)=>{const i=s?(0,n.getKeyExtension)(l,e.privateKeyBytes,t+a.BIP_32_HARDENED_OFFSET):(0,n.getKeyExtension)(u,e.publicKeyBytes,t);return(await(0,r.generateEntropy)({chainCode:e.chainCodeBytes,extension:i},o)).subarray(32)};const h=2;n.derivePublicKey=async({parentNode:e,childIndex:t,curve:s},a)=>{const o=(0,n.getKeyExtension)(h,e.publicKeyBytes,t),i=(await(0,r.generateEntropy)({chainCode:e.chainCodeBytes,extension:o},a)).slice(0,32),c=s.getPublicKey((0,n.trunc28Mul8)(i));return s.publicAdd(e.publicKeyBytes,c)},n.deriveChildKey=async function(e,t){const{curve:o,node:c,path:m}=e;(0,r.validateNode)(c);const{childIndex:d,isHardened:u}=(0,r.getValidatedPath)(m,c,o);if("ed25519Bip32"!==o.name||!c)throw new Error("Unsupported curve: Only ed25519Bip32 is supported by CIP3.");const l=d+(u?a.BIP_32_HARDENED_OFFSET:0),{privateKeyBytes:h,chainCodeBytes:p,publicKeyBytes:f,masterFingerprint:g,depth:y,fingerprint:k}=c;if(h){const e={privateKeyBytes:h,chainCodeBytes:p,publicKeyBytes:f},r=await(0,n.derivePrivateKey)({parentNode:e,childIndex:d,isHardened:u},t),a=await(0,n.deriveChainCode)({parentNode:e,childIndex:d,isHardened:u},t);return i.SLIP10Node.fromExtendedKey({privateKey:(0,s.bytesToHex)(r),chainCode:(0,s.bytesToHex)(a),masterFingerprint:g,depth:y+1,parentFingerprint:k,index:l,curve:o.name},t)}(0,s.assert)(!u,"Invalid parameters: Cannot derive hardened child keys without a private key.");const b={chainCodeBytes:p,publicKeyBytes:f},x=await(0,n.derivePublicKey)({parentNode:b,childIndex:d,isHardened:!1,curve:o},t),w=await(0,n.deriveChainCode)({parentNode:b,childIndex:d,isHardened:!1},t);return i.SLIP10Node.fromExtendedKey({publicKey:(0,s.bytesToHex)(x),chainCode:(0,s.bytesToHex)(w),masterFingerprint:g,depth:y+1,parentFingerprint:k,index:l,curve:o.name},t)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/cip3.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/index.cjs",{"./bip32.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip32.cjs","./bip39.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/bip39.cjs","./cip3.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/cip3.cjs","./slip10.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/slip10.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&s(t,e,n);return r(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.mnemonicToSeed=n.createBip39KeyFromSeed=n.derivers=void 0;const o=a(e("./bip32.cjs")),i=a(e("./bip39.cjs")),c=a(e("./cip3.cjs")),m=a(e("./slip10.cjs"));n.derivers={bip32:o,bip39:i,slip10:m,cip3:c};var d=e("./bip39.cjs");Object.defineProperty(n,"createBip39KeyFromSeed",{enumerable:!0,get:function(){return d.createBip39KeyFromSeed}}),Object.defineProperty(n,"mnemonicToSeed",{enumerable:!0,get:function(){return d.mnemonicToSeed}})}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/shared.cjs",{"../SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","../cryptography.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs","../curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","../guard.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/guard.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getValidatedPath=n.validateNode=n.generateEntropy=n.privateAdd=n.derivePublicChildKey=n.derivePublicExtension=n.deriveSecretExtension=n.deriveChildKey=void 0;const s=e("@metamask/utils"),r=e("../constants.cjs"),a=e("../cryptography.cjs"),o=e("../curves/index.cjs"),i=e("../guard.cjs"),c=e("../SLIP10Node.cjs"),m=e("../utils.cjs");async function d(e,t,n){const{privateKey:s,publicKey:a,entropy:o,childIndex:m,isHardened:u,depth:l,parentFingerprint:f,masterFingerprint:g,curve:y,network:k}=e;try{return s?await async function({entropy:e,privateKey:t,depth:n,masterFingerprint:s,parentFingerprint:a,childIndex:o,isHardened:m,curve:d,network:u},l){const h=o+(m?r.BIP_32_HARDENED_OFFSET:0),{privateKey:f,chainCode:g}=function({privateKey:e,entropy:t,curve:n}){const s=t.slice(0,32),r=t.slice(32);if("ed25519"===n.name)return{privateKey:s,chainCode:r};const a=p(e,s,n);return{privateKey:a,chainCode:r}}({privateKey:t,entropy:e,curve:d});return await c.SLIP10Node.fromExtendedKey({privateKey:f,chainCode:g,depth:n+1,masterFingerprint:s,parentFingerprint:a,index:h,curve:d.name,network:u,guard:i.PUBLIC_KEY_GUARD},l)}({entropy:o,privateKey:s,depth:l,masterFingerprint:g,parentFingerprint:f,childIndex:m,isHardened:u,curve:y,network:k},n):await h({entropy:o,publicKey:a,depth:l,masterFingerprint:g,parentFingerprint:f,childIndex:m,curve:y,network:k},n)}catch(s){return await d(await t(s,e,n),t,n)}}async function u({privateKey:e,publicKey:t,childIndex:n,isHardened:a,curve:o}){return a?(0,s.concatBytes)([new Uint8Array([0]),e,(0,m.numberToUint32)(n+r.BIP_32_HARDENED_OFFSET)]):((0,m.validateBytes)(t,o.compressedPublicKeyLength),l({parentPublicKey:t,childIndex:n}))}function l({parentPublicKey:e,childIndex:t}){return(0,s.concatBytes)([e,(0,m.numberToUint32)(t)])}async function h({entropy:e,publicKey:t,depth:n,masterFingerprint:s,parentFingerprint:r,childIndex:a,curve:o,network:i},m){const{publicKey:d,chainCode:u}=function({publicKey:e,entropy:t,curve:n}){const s=t.slice(0,32),r=t.slice(32);return{publicKey:n.publicAdd(e,s),chainCode:r}}({publicKey:t,entropy:e,curve:o});return await c.SLIP10Node.fromExtendedKey({publicKey:d,chainCode:u,depth:n+1,masterFingerprint:s,parentFingerprint:r,index:a,curve:o.name,network:i},m)}function p(e,t,n){(0,s.assert)((0,m.isValidBytesKey)(t,32),"Invalid tweak: Tweak must be a non-zero 32-byte Uint8Array.");const r=(0,s.bytesToBigInt)(e),a=(0,s.bytesToBigInt)(t);if(a>=n.curve.n)throw new Error("Invalid tweak: Tweak is larger than the curve order.");const i=(0,o.mod)(r+a,n.curve.n),c=(0,s.hexToBytes)(i.toString(16).padStart(64,"0"));if(!n.isValidPrivateKey(c))throw new Error("Invalid private key or tweak: The resulting private key is invalid.");return c}async function f({chainCode:e,extension:t},n){return await(0,a.hmacSha512)(e,t,n)}function g(e){(0,s.assert)(e,"Invalid parameters: Must specify a node to derive from.")}function y(e,t,n){!function(e,t,n){(0,s.assert)("string"==typeof e,"Invalid path: Must be a string.");const r=e.endsWith("'");(0,s.assert)(!r||t.privateKey,"Invalid parameters: Cannot derive hardened child keys without a private key."),(0,s.assert)(r||n.deriveUnhardenedKeys,`Invalid path: Cannot derive unhardened child keys with ${n.name}.`)}(e,t,n);const a=e.split("'")[0];(0,s.assert)(a);const o=parseInt(a,10);if(!r.UNPREFIXED_PATH_REGEX.test(a)||!Number.isInteger(o)||o<0||o>=r.BIP_32_HARDENED_OFFSET)throw new Error(`Invalid path: The index must be a non-negative decimal integer less than ${r.BIP_32_HARDENED_OFFSET}.`);return{childIndex:o,isHardened:e.includes("'")}}n.deriveChildKey=async function({path:e,node:t,curve:n,network:s},r,a){g(t);const{childIndex:o,isHardened:i}=y(e,t,n),c={chainCode:t.chainCodeBytes,childIndex:o,isHardened:i,depth:t.depth,parentFingerprint:t.fingerprint,masterFingerprint:t.masterFingerprint,curve:n,network:s};if(t.privateKeyBytes){const e=await u({privateKey:t.privateKeyBytes,get publicKey(){return t.compressedPublicKeyBytes},childIndex:o,isHardened:i,curve:n}),s=await f({chainCode:t.chainCodeBytes,extension:e},a);return await d({privateKey:t.privateKeyBytes,get publicKey(){return t.publicKeyBytes},entropy:s,...c},r,a)}const m=l({parentPublicKey:t.compressedPublicKeyBytes,childIndex:o}),h=await f({chainCode:t.chainCodeBytes,extension:m},a);return await d({publicKey:t.compressedPublicKeyBytes,entropy:h,...c},r,a)},n.deriveSecretExtension=u,n.derivePublicExtension=l,n.derivePublicChildKey=h,n.privateAdd=p,n.generateEntropy=f,n.validateNode=g,n.getValidatedPath=y}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/shared.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/slip10.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","./shared.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/shared.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildKey=void 0;const s=e("@metamask/utils"),r=e("./shared.cjs"),a=e("../constants.cjs"),o=e("../utils.cjs");async function i(e,t,n){const{curve:i,isHardened:c,childIndex:m,entropy:d,chainCode:u}=t;if("ed25519"===i.name)throw e;const l=c?m+a.BIP_32_HARDENED_OFFSET:m,h=await(0,r.generateEntropy)({chainCode:u,extension:(0,s.concatBytes)([1,d.slice(32,64),(0,o.numberToUint32)(l)])},n);return{...t,entropy:h}}n.deriveChildKey=async function(e,t){return await(0,r.deriveChildKey)(e,i,t)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/slip10.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/extended-keys.cjs",{"./BIP44Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs","./curves/secp256k1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.encodeExtendedKey=n.decodeExtendedKey=void 0;const s=e("@metamask/utils"),r=e("./BIP44Node.cjs"),a=e("./curves/secp256k1.cjs"),o=e("./utils.cjs"),i=76067358,c=76066276,m=70617039,d=70615956;n.decodeExtendedKey=e=>{const t=(0,o.decodeBase58check)(e);if(78!==t.length)throw new Error(`Invalid extended key: Expected a length of 78, got ${t.length}.`);const n=(0,s.createDataView)(t),u=n.getUint32(0,!1),{network:l,type:h}=function(e){switch(e){case i:return{type:"public",network:"mainnet"};case m:return{type:"public",network:"testnet"};case c:return{type:"private",network:"mainnet"};case d:return{type:"private",network:"testnet"};default:throw new Error("Invalid extended key: Expected a public (xpub) or private key (xprv) version.")}}(u),p=n.getUint8(4);(0,r.validateBIP44Depth)(p);const f=n.getUint32(5,!1),g=n.getUint32(9,!1),y=t.slice(13,45);if(!(0,o.isValidBytesKey)(y,32))throw new Error("Invalid extended key: Chain code must be a 32-byte non-zero byte array.");const k=t.slice(45,78);if(!(0,o.isValidBytesKey)(k,33))throw new Error("Invalid extended key: Key must be a 33-byte non-zero byte array.");const b=(0,s.createDataView)(k);if("public"===h){if(2!==b.getUint8(0)&&3!==b.getUint8(0))throw new Error("Invalid extended key: Public key must start with 0x02 or 0x03.");return{type:h,depth:p,parentFingerprint:f,index:g,network:l,chainCode:y,publicKey:(0,a.decompressPublicKey)(k)}}if(0!==b.getUint8(0))throw new Error("Invalid extended key: Private key must start with 0x00.");return{type:h,depth:p,parentFingerprint:f,index:g,network:l,chainCode:y,privateKey:k.slice(1)}};n.encodeExtendedKey=e=>{const{type:t,depth:n,parentFingerprint:r,index:u,network:l,chainCode:h}=e,p=new Uint8Array(78),f=(0,s.createDataView)(p),g=function(e,t){switch(e){case"mainnet":return"public"===t?i:c;case"testnet":return"public"===t?m:d;default:return(0,s.assertExhaustive)(e)}}(l,t);if(f.setUint32(0,g,!1),f.setUint8(4,n),f.setUint32(5,r,!1),f.setUint32(9,u,!1),p.set(h,13),"public"===t){const{publicKey:t}=e,n=(0,a.compressPublicKey)(t);p.set(n,45)}if("private"===t){const{privateKey:t}=e;p.set(t,46)}return(0,o.encodeBase58check)(p)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/extended-keys.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/guard.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PUBLIC_KEY_GUARD=void 0,n.PUBLIC_KEY_GUARD=Symbol("Public key guard. Do not export this from the module.")}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/guard.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/index.cjs",{"./BIP44CoinTypeNode.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs","./BIP44Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44Node.cjs","./SLIP10Node.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/SLIP10Node.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","./derivers/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/derivers/index.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.mnemonicToSeed=n.createBip39KeyFromSeed=n.mnemonicPhraseToBytes=n.isValidBIP32PathSegment=n.getBIP44CoinTypeToAddressPathTuple=n.getBIP44AddressKeyDeriver=n.deriveBIP44AddressKey=n.BIP_44_COIN_TYPE_DEPTH=n.BIP44CoinTypeNode=n.ed25519Bip32=n.ed25519=n.secp256k1=n.SLIP10Node=n.BIP44Node=void 0;var a=e("./BIP44Node.cjs");Object.defineProperty(n,"BIP44Node",{enumerable:!0,get:function(){return a.BIP44Node}});var o=e("./SLIP10Node.cjs");Object.defineProperty(n,"SLIP10Node",{enumerable:!0,get:function(){return o.SLIP10Node}});var i=e("./curves/index.cjs");Object.defineProperty(n,"secp256k1",{enumerable:!0,get:function(){return i.secp256k1}}),Object.defineProperty(n,"ed25519",{enumerable:!0,get:function(){return i.ed25519}}),Object.defineProperty(n,"ed25519Bip32",{enumerable:!0,get:function(){return i.ed25519Bip32}});var c=e("./BIP44CoinTypeNode.cjs");Object.defineProperty(n,"BIP44CoinTypeNode",{enumerable:!0,get:function(){return c.BIP44CoinTypeNode}}),Object.defineProperty(n,"BIP_44_COIN_TYPE_DEPTH",{enumerable:!0,get:function(){return c.BIP_44_COIN_TYPE_DEPTH}}),Object.defineProperty(n,"deriveBIP44AddressKey",{enumerable:!0,get:function(){return c.deriveBIP44AddressKey}}),Object.defineProperty(n,"getBIP44AddressKeyDeriver",{enumerable:!0,get:function(){return c.getBIP44AddressKeyDeriver}}),r(e("./constants.cjs"),n);var m=e("./utils.cjs");Object.defineProperty(n,"getBIP44CoinTypeToAddressPathTuple",{enumerable:!0,get:function(){return m.getBIP44CoinTypeToAddressPathTuple}}),Object.defineProperty(n,"isValidBIP32PathSegment",{enumerable:!0,get:function(){return m.isValidBIP32PathSegment}}),Object.defineProperty(n,"mnemonicPhraseToBytes",{enumerable:!0,get:function(){return m.mnemonicPhraseToBytes}});var d=e("./derivers/index.cjs");Object.defineProperty(n,"createBip39KeyFromSeed",{enumerable:!0,get:function(){return d.createBip39KeyFromSeed}}),Object.defineProperty(n,"mnemonicToSeed",{enumerable:!0,get:function(){return d.mnemonicToSeed}})}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/utils.cjs",{"./BIP44CoinTypeNode.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/constants.cjs","./cryptography.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/cryptography.cjs","./curves/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/curves/index.cjs","@metamask/scure-bip39/dist/wordlists/english.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/wordlists/english.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@scure/base/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getBIP44CoinType=n.validateNetwork=n.isWebCryptoSupported=n.numberToUint32=n.validateCurve=n.mnemonicPhraseToBytes=n.getFingerprint=n.encodeBase58check=n.decodeBase58check=n.validateBytes=n.getBytesUnsafe=n.getBytes=n.isValidInteger=n.isValidBytesKey=n.nullableHexStringToBytes=n.hexStringToBytes=n.isHardened=n.isValidBIP32PathSegment=n.isValidBIP32Index=n.validateBIP32Index=n.getBIP32NodeToken=n.getUnhardenedBIP32NodeToken=n.getHardenedBIP32NodeToken=n.getBIP44CoinTypeToAddressPathTuple=n.getBIP44ChangePathString=n.getBIP44CoinTypePathString=void 0;const s=e("@metamask/scure-bip39/dist/wordlists/english.js"),r=e("@metamask/utils"),a=e("@scure/base"),o=e("./BIP44CoinTypeNode.cjs"),i=e("./constants.cjs"),c=e("./cryptography.cjs"),m=e("./curves/index.cjs");function d(e){return h(e),`${u(e)}'`}function u(e){return h(e),`bip32:${e}`}function l(e){if("number"==typeof e)return u(e);if(!e||!Number.isInteger(e.index)||"boolean"!=typeof e.hardened)throw new Error("Invalid BIP-32 index: Must be an object containing the index and whether it is hardened.");return e.hardened?d(e.index):u(e.index)}function h(e){if(!p(e))throw new Error("Invalid BIP-32 index: Must be a non-negative integer.")}function p(e){return y(e)&&e<=i.MAX_BIP_32_INDEX}function f(e){return e instanceof Uint8Array?e:(0,r.hexToBytes)(e)}function g(e,t){if(e.length!==t)return!1;for(const t of e)if(0!==t)return!0;return!1}function y(e){return"number"==typeof e&&Number.isInteger(e)&&e>=0}function k(e,t){if(!g(e,t))throw new Error(`Invalid value: Must be a non-zero ${t}-byte byte array.`)}n.getBIP44CoinTypePathString=function(e){return`m / ${i.BIP44PurposeNodeToken} / ${d(e)}`},n.getBIP44ChangePathString=function(e,t){return`${e} / ${d(t.account??0)} / ${l(t.change??0)}`},n.getBIP44CoinTypeToAddressPathTuple=function({account:e=0,change:t=0,address_index:n}){return[d(e),l(t),l(n)]},n.getHardenedBIP32NodeToken=d,n.getUnhardenedBIP32NodeToken=u,n.getBIP32NodeToken=l,n.validateBIP32Index=h,n.isValidBIP32Index=p,n.isValidBIP32PathSegment=function(e){if("string"!=typeof e)return!1;const t=e.match(i.UNPREFIXED_BIP_32_PATH_REGEX);if(void 0===t?.groups?.index)return!1;const n=parseInt(t.groups.index,10);return y(n)&&n<=i.MAX_UNHARDENED_BIP_32_INDEX},n.isHardened=function(e){return e.endsWith("'")},n.hexStringToBytes=f,n.nullableHexStringToBytes=function(e){return e!==undefined?f(e):undefined},n.isValidBytesKey=g,n.isValidInteger=y,n.getBytes=function(e,t){if(e instanceof Uint8Array)return k(e,t),e;if("string"==typeof e){const n=(0,r.hexToBytes)(e);return k(n,t),n}throw new Error("Invalid value: Expected an instance of Uint8Array or hexadecimal string.")},n.getBytesUnsafe=function e(t,n){if(t instanceof Uint8Array)return(0,r.assert)(t.length===n,`Invalid value: Must be a ${n}-byte byte array.`),t;if("string"==typeof t)return e((0,r.hexToBytes)(t),n);throw new Error("Invalid value: Expected an instance of Uint8Array or hexadecimal string.")},n.validateBytes=k;n.decodeBase58check=e=>{const t=(0,a.base58check)(c.sha256);try{return t.decode(e)}catch{throw new Error("Invalid extended key: Value is not base58-encoded, or the checksum is invalid.")}};n.encodeBase58check=e=>(0,a.base58check)(c.sha256).encode(e);n.getFingerprint=(e,t)=>{if(!g(e,t))throw new Error(`Invalid public key: The key must be a ${t}-byte, non-zero byte array.`);const n=(0,c.ripemd160)((0,c.sha256)(e));return(0,r.createDataView)(n).getUint32(0,!1)},n.mnemonicPhraseToBytes=function(e){const t=e.split(" ").map(e=>{const t=s.wordlist.indexOf(e);return(0,r.assert)(-1!==t,`Invalid mnemonic phrase: Unknown word "${e}".`),t});return new Uint8Array(new Uint16Array(t).buffer)},n.validateCurve=function(e){if(!e||"string"!=typeof e)throw new Error("Invalid curve: Must specify a curve.");if(!Object.keys(m.curves).includes(e))throw new Error(`Invalid curve: Only the following curves are supported: ${Object.keys(m.curves).join(", ")}.`)},n.numberToUint32=function(e,t=!1){const n=new Uint8Array(4);return(0,r.createDataView)(n).setUint32(0,e,t),n},n.isWebCryptoSupported=function(){return Boolean(globalThis.crypto?.subtle)},n.validateNetwork=function(e){if(e!==undefined){if("string"!=typeof e)throw new Error("Invalid network: Must be a string if specified.");if(!["mainnet","testnet"].includes(e))throw new Error('Invalid network: Must be either "mainnet" or "testnet" if specified.')}},n.getBIP44CoinType=function(e){const t=e[o.BIP_44_COIN_TYPE_DEPTH].split(":")[1]?.replace("'","");(0,r.assert)(t,"Invalid derivation path: Coin type is not specified.");const n=Number.parseInt(t,10);return(0,r.assert)(y(n),"Invalid derivation path: Coin type is not a valid integer."),n}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/account-options.cjs",{"@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountOptionsStruct=n.KeyringAccountEntropyOptionsStruct=n.KeyringAccountEntropyPrivateKeyOptionsStruct=n.KeyringAccountEntropyMnemonicOptionsStruct=n.KeyringAccountEntropyTypeOption=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils");var o;!function(e){e.Mnemonic="mnemonic",e.PrivateKey="private-key"}(o||(n.KeyringAccountEntropyTypeOption=o={})),n.KeyringAccountEntropyMnemonicOptionsStruct=(0,r.object)({type:(0,r.literal)(`${o.Mnemonic}`),id:(0,r.string)(),derivationPath:(0,r.string)(),groupIndex:(0,r.number)()}),n.KeyringAccountEntropyPrivateKeyOptionsStruct=(0,r.object)({type:(0,r.literal)(`${o.PrivateKey}`)}),n.KeyringAccountEntropyOptionsStruct=(0,s.selectiveUnion)(e=>(0,a.isPlainObject)(e)&&e.type===o.PrivateKey?n.KeyringAccountEntropyPrivateKeyOptionsStruct:n.KeyringAccountEntropyMnemonicOptionsStruct),n.KeyringAccountOptionsStruct=(0,r.intersection)([(0,r.record)((0,r.string)(),a.JsonStruct),(0,s.type)({entropy:(0,s.exactOptional)(n.KeyringAccountEntropyOptionsStruct),exportable:(0,s.exactOptional)((0,r.boolean)())})])}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/account-options.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/account.cjs",{"./account-options.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/account-options.cjs","./caip.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/caip.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountStruct=n.AnyAccountType=n.TrxAccountType=n.SolAccountType=n.BtcAccountType=n.EthAccountType=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("./account-options.cjs"),o=e("./caip.cjs");var i,c,m,d,u;!function(e){e.Eoa="eip155:eoa",e.Erc4337="eip155:erc4337"}(i||(n.EthAccountType=i={})),function(e){e.P2pkh="bip122:p2pkh",e.P2sh="bip122:p2sh",e.P2wpkh="bip122:p2wpkh",e.P2tr="bip122:p2tr"}(c||(n.BtcAccountType=c={})),function(e){e.DataAccount="solana:data-account"}(m||(n.SolAccountType=m={})),function(e){e.Eoa="tron:eoa"}(d||(n.TrxAccountType=d={})),function(e){e.Account="any:account"}(u||(n.AnyAccountType=u={})),n.KeyringAccountStruct=(0,s.object)({id:s.AccountIdStruct,type:(0,r.enums)([`${i.Eoa}`,`${i.Erc4337}`,`${c.P2pkh}`,`${c.P2sh}`,`${c.P2wpkh}`,`${c.P2tr}`,`${m.DataAccount}`,`${d.Eoa}`,`${u.Account}`]),address:(0,r.string)(),scopes:(0,r.nonempty)((0,r.array)(o.CaipChainIdStruct)),options:a.KeyringAccountOptionsStruct,methods:(0,r.array)((0,r.string)())})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/account.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/address.cjs",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ResolvedAccountAddressStruct=void 0;const s=e("@metamask/superstruct"),r=e("@metamask/utils");n.ResolvedAccountAddressStruct=(0,s.object)({address:r.CaipAccountIdStruct})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/address.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/asset.cjs",{"@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AssetStruct=n.NonFungibleAssetStruct=n.FungibleAssetStruct=n.FungibleAssetAmountStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils");n.FungibleAssetAmountStruct=(0,s.object)({unit:(0,r.string)(),amount:s.StringNumberStruct}),n.FungibleAssetStruct=(0,s.object)({fungible:(0,r.literal)(!0),type:a.CaipAssetTypeStruct,...n.FungibleAssetAmountStruct.schema}),n.NonFungibleAssetStruct=(0,s.object)({fungible:(0,r.literal)(!1),id:a.CaipAssetIdStruct}),n.AssetStruct=(0,s.selectiveUnion)(e=>(0,a.isPlainObject)(e)&&!e.fungible?n.NonFungibleAssetStruct:n.FungibleAssetStruct)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/asset.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/balance.cjs",{"@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BalanceStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct");n.BalanceStruct=(0,s.object)({amount:s.StringNumberStruct,unit:(0,r.string)()})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/balance.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/caip.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CaipChainIdStruct=n.CaipAssetTypeOrIdStruct=n.CaipAssetTypeStruct=n.CaipAssetIdStruct=n.CaipAccountIdStruct=void 0;const s=e("@metamask/utils");Object.defineProperty(n,"CaipAccountIdStruct",{enumerable:!0,get:function(){return s.CaipAccountIdStruct}}),Object.defineProperty(n,"CaipAssetIdStruct",{enumerable:!0,get:function(){return s.CaipAssetIdStruct}}),Object.defineProperty(n,"CaipAssetTypeStruct",{enumerable:!0,get:function(){return s.CaipAssetTypeStruct}}),Object.defineProperty(n,"CaipAssetTypeOrIdStruct",{enumerable:!0,get:function(){return s.CaipAssetTypeOrIdStruct}}),Object.defineProperty(n,"CaipChainIdStruct",{enumerable:!0,get:function(){return s.CaipChainIdStruct}})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/caip.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/derivation.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DerivationPathStruct=void 0;const s=e("@metamask/utils");n.DerivationPathStruct=(0,s.definePattern)("DerivationPath",/^m(?:\/\d+'?)+$/u)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/derivation.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/discovery.cjs",{"./caip.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/caip.cjs","./derivation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/derivation.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DiscoveredAccountStruct=n.DiscoveredBip44AccountStruct=n.DiscoveredAccountType=void 0;const s=e("@metamask/superstruct"),r=e("./caip.cjs"),a=e("./derivation.cjs");var o;!function(e){e.Bip44="bip44"}(o||(n.DiscoveredAccountType=o={})),n.DiscoveredBip44AccountStruct=(0,s.object)({type:(0,s.literal)(`${o.Bip44}`),scopes:(0,s.array)(r.CaipChainIdStruct),derivationPath:a.DerivationPathStruct}),n.DiscoveredAccountStruct=n.DiscoveredBip44AccountStruct}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/discovery.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/export.cjs",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountDataStruct=void 0;const s=e("@metamask/superstruct"),r=e("@metamask/utils");n.KeyringAccountDataStruct=(0,s.record)((0,s.string)(),r.JsonStruct)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/export.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs",{"./account-options.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/account-options.cjs","./account.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/account.cjs","./address.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/address.cjs","./asset.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/asset.cjs","./balance.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/balance.cjs","./caip.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/caip.cjs","./discovery.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/discovery.cjs","./export.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/export.cjs","./options.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/options.cjs","./pagination.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/pagination.cjs","./request.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/request.cjs","./response.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/response.cjs","./transaction.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/transaction.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./account.cjs"),n),r(e("./account-options.cjs"),n),r(e("./address.cjs"),n),r(e("./asset.cjs"),n),r(e("./balance.cjs"),n),r(e("./caip.cjs"),n),r(e("./discovery.cjs"),n),r(e("./export.cjs"),n),r(e("./request.cjs"),n),r(e("./response.cjs"),n),r(e("./transaction.cjs"),n),r(e("./pagination.cjs"),n),r(e("./options.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/options.cjs",{"@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MetaMaskOptionsStruct=void 0;const s=e("@metamask/keyring-utils");n.MetaMaskOptionsStruct=(0,s.object)({metamask:(0,s.exactOptional)((0,s.object)({correlationId:s.UuidStruct}))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/options.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/pagination.cjs",{"@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PaginationStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct");n.PaginationStruct=(0,s.object)({limit:(0,r.number)(),next:(0,s.exactOptional)((0,r.nullable)((0,r.string)()))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/pagination.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/request.cjs",{"@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringRequestStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils");n.KeyringRequestStruct=(0,s.object)({id:s.UuidStruct,scope:(0,r.string)(),account:s.UuidStruct,origin:(0,r.string)(),request:(0,s.object)({method:(0,r.string)(),params:(0,s.exactOptional)((0,r.union)([(0,r.array)(a.JsonStruct),(0,r.record)((0,r.string)(),a.JsonStruct)]))})})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/request.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/response.cjs",{"@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringResponseStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils");n.KeyringResponseStruct=(0,r.union)([(0,s.object)({pending:(0,r.literal)(!0),redirect:(0,s.exactOptional)((0,s.object)({message:(0,s.exactOptional)((0,r.string)()),url:(0,s.exactOptional)((0,r.string)())}))}),(0,s.object)({pending:(0,r.literal)(!1),result:a.JsonStruct})])}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/response.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/transaction.cjs",{"./asset.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/asset.cjs","./caip.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/caip.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TransactionsPageStruct=n.TransactionStruct=n.TransactionEventStruct=n.TransactionType=n.TransactionStatus=n.FeeType=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("./asset.cjs"),o=e("./caip.cjs"),i=(0,s.object)({address:(0,r.string)(),asset:(0,r.nullable)(a.AssetStruct)});var c;!function(e){e.Base="base",e.Priority="priority"}(c||(n.FeeType=c={}));const m=(0,s.object)({type:(0,r.enums)([`${c.Base}`,`${c.Priority}`]),asset:a.AssetStruct});var d,u;!function(e){e.Submitted="submitted",e.Unconfirmed="unconfirmed",e.Confirmed="confirmed",e.Failed="failed"}(d||(n.TransactionStatus=d={})),function(e){e.Send="send",e.Receive="receive",e.Swap="swap",e.BridgeSend="bridge:send",e.BridgeReceive="bridge:receive",e.Unknown="unknown"}(u||(n.TransactionType=u={})),n.TransactionEventStruct=(0,s.object)({status:(0,r.enums)([`${d.Submitted}`,`${d.Unconfirmed}`,`${d.Confirmed}`,`${d.Failed}`]),timestamp:(0,r.nullable)((0,r.number)())}),n.TransactionStruct=(0,s.object)({id:(0,r.string)(),chain:o.CaipChainIdStruct,account:s.UuidStruct,status:(0,r.enums)([`${d.Submitted}`,`${d.Unconfirmed}`,`${d.Confirmed}`,`${d.Failed}`]),timestamp:(0,r.nullable)((0,r.number)()),type:(0,r.enums)([`${u.Send}`,`${u.Receive}`,`${u.Swap}`,`${u.BridgeSend}`,`${u.BridgeReceive}`,`${u.Unknown}`]),from:(0,r.array)(i),to:(0,r.array)(i),fees:(0,r.array)(m),events:(0,r.array)(n.TransactionEventStruct)}),n.TransactionsPageStruct=(0,s.object)({data:(0,r.array)(n.TransactionStruct),next:(0,r.nullable)((0,r.string)())})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/transaction.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/btc/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s;Object.defineProperty(n,"__esModule",{value:!0}),n.BtcScope=void 0,function(e){e.Mainnet="bip122:000000000019d6689c085ae165831e93",e.Testnet="bip122:000000000933ea01ad0ee984209779ba",e.Testnet4="bip122:00000000da84f2bafbbc53dee25a72ae",e.Signet="bip122:00000008819873e925422c1ff0f99f7c",e.Regtest="bip122:regtest"}(s||(n.BtcScope=s={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/btc/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/btc/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/btc/constants.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/btc/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./constants.cjs"),n),r(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/btc/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/btc/types.cjs",{"../api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","bitcoin-address-validation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bitcoin-address-validation/lib/index.cjs.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BtcP2trAccountStruct=n.BtcP2wpkhAccountStruct=n.BtcP2shAccountStruct=n.BtcP2pkhAccountStruct=n.BtcMethod=n.BtcP2trAddressStruct=n.BtcP2wpkhAddressStruct=n.BtcP2shAddressStruct=n.BtcP2pkhAddressStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("bitcoin-address-validation"),o=e("../api/index.cjs"),i=(e,t)=>{try{return(0,a.getAddressInfo)(e).type===t||new Error(`Invalid ${t} address`)}catch(e){return new Error(`Failed to decode ${t} address: ${e.message}`)}};var c;n.BtcP2pkhAddressStruct=(0,r.refine)((0,r.string)(),"BtcP2pkhAddressStruct",e=>i(e,a.AddressType.p2pkh)),n.BtcP2shAddressStruct=(0,r.refine)((0,r.string)(),"BtcP2shAddressStruct",e=>i(e,a.AddressType.p2sh)),n.BtcP2wpkhAddressStruct=(0,r.refine)((0,r.string)(),"BtcP2wpkhAddressStruct",e=>i(e,a.AddressType.p2wpkh)),n.BtcP2trAddressStruct=(0,r.refine)((0,r.string)(),"BtcP2trAddressStruct",e=>i(e,a.AddressType.p2tr)),function(e){e.SignPsbt="signPsbt",e.ComputeFee="computeFee",e.FillPsbt="fillPsbt",e.BroadcastPsbt="broadcastPsbt",e.SendTransfer="sendTransfer",e.GetUtxo="getUtxo",e.ListUtxos="listUtxos",e.PublicDescriptor="publicDescriptor",e.SignMessage="signMessage"}(c||(n.BtcMethod=c={}));const m=(0,s.object)({...o.KeyringAccountStruct.schema,scopes:(0,r.nonempty)((0,r.array)(o.CaipChainIdStruct)),methods:(0,r.array)((0,r.enums)(Object.values(c)))});n.BtcP2pkhAccountStruct=(0,s.object)({...m.schema,address:n.BtcP2pkhAddressStruct,type:(0,r.literal)(`${o.BtcAccountType.P2pkh}`)}),n.BtcP2shAccountStruct=(0,s.object)({...m.schema,address:n.BtcP2shAddressStruct,type:(0,r.literal)(`${o.BtcAccountType.P2sh}`)}),n.BtcP2wpkhAccountStruct=(0,s.object)({...m.schema,address:n.BtcP2wpkhAddressStruct,type:(0,r.literal)(`${o.BtcAccountType.P2wpkh}`)}),n.BtcP2trAccountStruct=(0,s.object)({...m.schema,address:n.BtcP2trAddressStruct,type:(0,r.literal)(`${o.BtcAccountType.P2tr}`)})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/btc/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s;Object.defineProperty(n,"__esModule",{value:!0}),n.EthScope=void 0,function(e){e.Eoa="eip155:0",e.Mainnet="eip155:1",e.Testnet="eip155:11155111"}(s||(n.EthScope=s={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/erc4337/index.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/erc4337/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/erc4337/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/erc4337/types.cjs",{"../types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/types.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.EthUserOperationPatchStruct=n.EthBaseUserOperationStruct=n.EthBaseTransactionStruct=n.EthUserOperationStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("../types.cjs");n.EthUserOperationStruct=(0,s.object)({sender:r.EthAddressStruct,nonce:r.EthUint256Struct,initCode:r.EthBytesStruct,callData:r.EthBytesStruct,callGasLimit:r.EthUint256Struct,verificationGasLimit:r.EthUint256Struct,preVerificationGas:r.EthUint256Struct,maxFeePerGas:r.EthUint256Struct,maxPriorityFeePerGas:r.EthUint256Struct,paymasterAndData:r.EthBytesStruct,signature:r.EthBytesStruct}),n.EthBaseTransactionStruct=(0,s.object)({to:r.EthAddressStruct,value:r.EthUint256Struct,data:r.EthBytesStruct}),n.EthBaseUserOperationStruct=(0,s.object)({nonce:r.EthUint256Struct,initCode:r.EthBytesStruct,callData:r.EthBytesStruct,gasLimits:(0,s.exactOptional)((0,s.object)({callGasLimit:r.EthUint256Struct,verificationGasLimit:r.EthUint256Struct,preVerificationGas:r.EthUint256Struct})),dummyPaymasterAndData:r.EthBytesStruct,dummySignature:r.EthBytesStruct,bundlerUrl:s.UrlStruct}),n.EthUserOperationPatchStruct=(0,s.object)({paymasterAndData:r.EthBytesStruct,callGasLimit:(0,s.exactOptional)(r.EthUint256Struct),verificationGasLimit:(0,s.exactOptional)(r.EthUint256Struct),preVerificationGas:(0,s.exactOptional)(r.EthUint256Struct)})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/erc4337/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/constants.cjs","./erc4337/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/erc4337/index.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/types.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./constants.cjs"),n),r(e("./erc4337/index.cjs"),n),r(e("./types.cjs"),n),r(e("./utils.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/types.cjs",{"../api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs","./index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.EthErc4337AccountStruct=n.EthEoaAccountStruct=n.EthMethod=n.EthUint256Struct=n.EthAddressStruct=n.EthBytesStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("./index.cjs"),i=e("../api/index.cjs");var c;n.EthBytesStruct=(0,a.definePattern)("EthBytes",/^0x[0-9a-f]*$/iu),n.EthAddressStruct=(0,a.definePattern)("EthAddress",/^0x[0-9a-f]{40}$/iu),n.EthUint256Struct=(0,a.definePattern)("EthUint256",/^0x([1-9a-f][0-9a-f]*|0)$/iu),function(e){e.PersonalSign="personal_sign",e.Sign="eth_sign",e.SignTransaction="eth_signTransaction",e.SignTypedDataV1="eth_signTypedData_v1",e.SignTypedDataV3="eth_signTypedData_v3",e.SignTypedDataV4="eth_signTypedData_v4",e.PrepareUserOperation="eth_prepareUserOperation",e.PatchUserOperation="eth_patchUserOperation",e.SignUserOperation="eth_signUserOperation"}(c||(n.EthMethod=c={})),n.EthEoaAccountStruct=(0,s.object)({...i.KeyringAccountStruct.schema,address:n.EthAddressStruct,type:(0,r.literal)(`${i.EthAccountType.Eoa}`),scopes:(0,r.nonempty)((0,r.array)((0,r.literal)(o.EthScope.Eoa))),methods:(0,r.array)((0,r.enums)([`${c.PersonalSign}`,`${c.Sign}`,`${c.SignTransaction}`,`${c.SignTypedDataV1}`,`${c.SignTypedDataV3}`,`${c.SignTypedDataV4}`]))}),n.EthErc4337AccountStruct=(0,s.object)({...i.KeyringAccountStruct.schema,address:n.EthAddressStruct,type:(0,r.literal)(`${i.EthAccountType.Erc4337}`),scopes:(0,r.nonempty)((0,r.array)(i.CaipChainIdStruct)),methods:(0,r.array)((0,r.enums)([`${c.PersonalSign}`,`${c.Sign}`,`${c.SignTypedDataV1}`,`${c.SignTypedDataV3}`,`${c.SignTypedDataV4}`,`${c.PrepareUserOperation}`,`${c.PatchUserOperation}`,`${c.SignUserOperation}`]))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/utils.cjs",{"../api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isEvmAccountType=function(e){return e===s.EthAccountType.Eoa||e===s.EthAccountType.Erc4337};const s=e("../api/index.cjs")}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/events.cjs",{"./api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AccountAssetListUpdatedEventStruct=n.AccountTransactionsUpdatedEventStruct=n.AccountBalancesUpdatedEventStruct=n.RequestRejectedEventStruct=n.RequestApprovedEventStruct=n.AccountDeletedEventStruct=n.AccountUpdatedEventStruct=n.AccountCreatedEventStruct=n.KeyringEvent=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("./api/index.cjs");var i;!function(e){e.AccountCreated="notify:accountCreated",e.AccountUpdated="notify:accountUpdated",e.AccountDeleted="notify:accountDeleted",e.RequestApproved="notify:requestApproved",e.RequestRejected="notify:requestRejected",e.AccountBalancesUpdated="notify:accountBalancesUpdated",e.AccountAssetListUpdated="notify:accountAssetListUpdated",e.AccountTransactionsUpdated="notify:accountTransactionsUpdated"}(i||(n.KeyringEvent=i={})),n.AccountCreatedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.AccountCreated}`),params:(0,s.object)({account:o.KeyringAccountStruct,accountNameSuggestion:(0,s.exactOptional)((0,r.string)()),displayConfirmation:(0,s.exactOptional)((0,r.boolean)()),displayAccountNameSuggestion:(0,s.exactOptional)((0,r.boolean)()),...o.MetaMaskOptionsStruct.schema})}),n.AccountUpdatedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.AccountUpdated}`),params:(0,s.object)({account:o.KeyringAccountStruct})}),n.AccountDeletedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.AccountDeleted}`),params:(0,s.object)({id:s.UuidStruct})}),n.RequestApprovedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.RequestApproved}`),params:(0,s.object)({id:s.UuidStruct,result:a.JsonStruct})}),n.RequestRejectedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.RequestRejected}`),params:(0,s.object)({id:s.UuidStruct})}),n.AccountBalancesUpdatedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.AccountBalancesUpdated}`),params:(0,s.object)({balances:(0,r.record)(s.AccountIdStruct,(0,r.record)(a.CaipAssetTypeStruct,o.FungibleAssetAmountStruct))})}),n.AccountTransactionsUpdatedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.AccountTransactionsUpdated}`),params:(0,s.object)({transactions:(0,r.record)(s.AccountIdStruct,(0,r.array)(o.TransactionStruct))})}),n.AccountAssetListUpdatedEventStruct=(0,s.object)({method:(0,r.literal)(`${i.AccountAssetListUpdated}`),params:(0,s.object)({assets:(0,r.record)(s.AccountIdStruct,(0,s.object)({added:(0,r.array)(a.CaipAssetTypeOrIdStruct),removed:(0,r.array)(a.CaipAssetTypeOrIdStruct)}))})})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/events.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs",{"./api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs","./btc/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/btc/index.cjs","./eth/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/eth/index.cjs","./events.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/events.cjs","./rpc.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/rpc.cjs","./sol/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/sol/index.cjs","./trx/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/trx/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./api/index.cjs"),n),r(e("./btc/index.cjs"),n),r(e("./sol/index.cjs"),n),r(e("./eth/index.cjs"),n),r(e("./trx/index.cjs"),n),r(e("./rpc.cjs"),n),r(e("./events.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/rpc.cjs",{"./api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RejectRequestResponseStruct=n.RejectRequestRequestStruct=n.ApproveRequestResponseStruct=n.ApproveRequestRequestStruct=n.SubmitRequestResponseStruct=n.SubmitRequestRequestStruct=n.GetRequestResponseStruct=n.GetRequestRequestStruct=n.ListRequestsResponseStruct=n.ListRequestsRequestStruct=n.ExportAccountResponseStruct=n.ExportAccountRequestStruct=n.DeleteAccountResponseStruct=n.DeleteAccountRequestStruct=n.UpdateAccountResponseStruct=n.UpdateAccountRequestStruct=n.FilterAccountChainsResponseStruct=n.FilterAccountChainsStruct=n.ResolveAccountAddressResponseStruct=n.ResolveAccountAddressRequestStruct=n.GetAccountBalancesResponseStruct=n.GetAccountBalancesRequestStruct=n.ListAccountAssetsResponseStruct=n.ListAccountAssetsRequestStruct=n.ListAccountTransactionsResponseStruct=n.ListAccountTransactionsRequestStruct=n.DiscoverAccountsResponseStruct=n.DiscoverAccountsRequestStruct=n.CreateAccountResponseStruct=n.CreateAccountRequestStruct=n.GetAccountResponseStruct=n.GetAccountRequestStruct=n.ListAccountsResponseStruct=n.ListAccountsRequestStruct=n.KeyringRpcMethod=void 0,n.isKeyringRpcMethod=function(e){return Object.values(i).includes(e)};const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("./api/index.cjs");var i;!function(e){e.ListAccounts="keyring_listAccounts",e.GetAccount="keyring_getAccount",e.CreateAccount="keyring_createAccount",e.DiscoverAccounts="keyring_discoverAccounts",e.ListAccountAssets="keyring_listAccountAssets",e.ListAccountTransactions="keyring_listAccountTransactions",e.GetAccountBalances="keyring_getAccountBalances",e.ResolveAccountAddress="keyring_resolveAccountAddress",e.FilterAccountChains="keyring_filterAccountChains",e.UpdateAccount="keyring_updateAccount",e.DeleteAccount="keyring_deleteAccount",e.ExportAccount="keyring_exportAccount",e.ListRequests="keyring_listRequests",e.GetRequest="keyring_getRequest",e.SubmitRequest="keyring_submitRequest",e.ApproveRequest="keyring_approveRequest",e.RejectRequest="keyring_rejectRequest"}(i||(n.KeyringRpcMethod=i={}));const c={jsonrpc:(0,r.literal)("2.0"),id:(0,r.union)([(0,r.string)(),(0,r.number)(),(0,r.literal)(null)])};n.ListAccountsRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_listAccounts")}),n.ListAccountsResponseStruct=(0,r.array)(o.KeyringAccountStruct),n.GetAccountRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_getAccount"),params:(0,s.object)({id:s.UuidStruct})}),n.GetAccountResponseStruct=o.KeyringAccountStruct,n.CreateAccountRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_createAccount"),params:(0,s.object)({options:(0,r.record)((0,r.string)(),a.JsonStruct)})}),n.CreateAccountResponseStruct=o.KeyringAccountStruct,n.DiscoverAccountsRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_discoverAccounts"),params:(0,s.object)({scopes:(0,r.array)(o.CaipChainIdStruct),entropySource:(0,r.string)(),groupIndex:(0,r.number)()})}),n.DiscoverAccountsResponseStruct=(0,r.array)(o.DiscoveredAccountStruct),n.ListAccountTransactionsRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_listAccountTransactions"),params:(0,s.object)({id:s.UuidStruct,pagination:o.PaginationStruct})}),n.ListAccountTransactionsResponseStruct=o.TransactionsPageStruct,n.ListAccountAssetsRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_listAccountAssets"),params:(0,s.object)({id:s.UuidStruct})}),n.ListAccountAssetsResponseStruct=(0,r.array)(o.CaipAssetTypeOrIdStruct),n.GetAccountBalancesRequestStruct=(0,s.object)({...c,method:(0,r.literal)(`${i.GetAccountBalances}`),params:(0,s.object)({id:s.UuidStruct,assets:(0,r.array)(o.CaipAssetTypeStruct)})}),n.GetAccountBalancesResponseStruct=(0,r.record)(o.CaipAssetTypeStruct,o.BalanceStruct),n.ResolveAccountAddressRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_resolveAccountAddress"),params:(0,s.object)({scope:o.CaipChainIdStruct,request:s.JsonRpcRequestStruct})}),n.ResolveAccountAddressResponseStruct=(0,r.nullable)((0,s.object)({address:o.CaipAccountIdStruct})),n.FilterAccountChainsStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_filterAccountChains"),params:(0,s.object)({id:s.UuidStruct,chains:(0,r.array)((0,r.string)())})}),n.FilterAccountChainsResponseStruct=(0,r.array)((0,r.string)()),n.UpdateAccountRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_updateAccount"),params:(0,s.object)({account:o.KeyringAccountStruct})}),n.UpdateAccountResponseStruct=(0,r.literal)(null),n.DeleteAccountRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_deleteAccount"),params:(0,s.object)({id:s.UuidStruct})}),n.DeleteAccountResponseStruct=(0,r.literal)(null),n.ExportAccountRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_exportAccount"),params:(0,s.object)({id:s.UuidStruct})}),n.ExportAccountResponseStruct=o.KeyringAccountDataStruct,n.ListRequestsRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_listRequests")}),n.ListRequestsResponseStruct=(0,r.array)(o.KeyringRequestStruct),n.GetRequestRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_getRequest"),params:(0,s.object)({id:s.UuidStruct})}),n.GetRequestResponseStruct=o.KeyringRequestStruct,n.SubmitRequestRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_submitRequest"),params:o.KeyringRequestStruct}),n.SubmitRequestResponseStruct=o.KeyringResponseStruct,n.ApproveRequestRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_approveRequest"),params:(0,s.object)({id:s.UuidStruct,data:(0,r.record)((0,r.string)(),a.JsonStruct)})}),n.ApproveRequestResponseStruct=(0,r.literal)(null),n.RejectRequestRequestStruct=(0,s.object)({...c,method:(0,r.literal)("keyring_rejectRequest"),params:(0,s.object)({id:s.UuidStruct})}),n.RejectRequestResponseStruct=(0,r.literal)(null)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/rpc.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/sol/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s;Object.defineProperty(n,"__esModule",{value:!0}),n.SolScope=void 0,function(e){e.Devnet="solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1",e.Mainnet="solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp",e.Testnet="solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z"}(s||(n.SolScope=s={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/sol/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/sol/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/sol/constants.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/sol/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./constants.cjs"),n),r(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/sol/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/sol/types.cjs",{"../api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SolDataAccountStruct=n.SolMethod=n.SolAddressStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../api/index.cjs");var i;n.SolAddressStruct=(0,a.definePattern)("SolAddress",/^[1-9A-HJ-NP-Za-km-z]{32,44}$/iu),function(e){e.SendAndConfirmTransaction="sendAndConfirmTransaction",e.SignAndSendTransaction="signAndSendTransaction",e.SignTransaction="signTransaction",e.SignMessage="signMessage",e.SignIn="signIn"}(i||(n.SolMethod=i={})),n.SolDataAccountStruct=(0,s.object)({...o.KeyringAccountStruct.schema,address:n.SolAddressStruct,type:(0,r.literal)(`${o.SolAccountType.DataAccount}`),scopes:(0,r.nonempty)((0,r.array)(o.CaipChainIdStruct)),methods:(0,r.array)((0,r.enums)(Object.values(i)))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/sol/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/trx/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s;Object.defineProperty(n,"__esModule",{value:!0}),n.TrxScope=void 0,function(e){e.Mainnet="tron:728126428",e.Nile="tron:3448148188",e.Shasta="tron:2494104990"}(s||(n.TrxScope=s={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/trx/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/trx/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/trx/constants.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/trx/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./constants.cjs"),n),r(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/trx/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/trx/types.cjs",{"../api/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/api/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TrxEoaAccountStruct=n.TrxMethod=n.TrxAddressStruct=void 0;const s=e("@metamask/keyring-utils"),r=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../api/index.cjs");var i;n.TrxAddressStruct=(0,a.definePattern)("TrxAddress",/^T[1-9A-HJ-NP-Za-km-z]{33}$/iu),function(e){e.SignMessageV2="signMessageV2",e.VerifyMessageV2="verifyMessageV2"}(i||(n.TrxMethod=i={})),n.TrxEoaAccountStruct=(0,s.object)({...o.KeyringAccountStruct.schema,address:n.TrxAddressStruct,type:(0,r.literal)(`${o.TrxAccountType.Eoa}`),scopes:(0,r.nonempty)((0,r.array)(o.CaipChainIdStruct)),methods:(0,r.array)((0,r.enums)(Object.values(i)))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/trx/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-controller/dist/KeyringController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-controller/dist/constants.cjs","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/browser-passworder":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/browser-passworder/dist/index.js","@metamask/eth-hd-keyring":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/index.cjs","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/eth-simple-keyring":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","async-mutex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/async-mutex/lib/index.js","ethereumjs-wallet":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereumjs-wallet/dist.browser/index.js",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js",ulid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/ulid/dist/index.umd.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i,c,m,d,u,l,h,p,f,g,y,k,b,x,w,_,v,E,T,j,A,C,P,B,S,I,D,R,O,F,M,N,q,K,U,L=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),$=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),H=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&L(t,e,n);return $(t,e),t},G=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},V=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)},W=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringController=n.getDefaultKeyringState=n.keyringBuilderFactory=n.SignTypedDataVersion=n.AccountImportStrategy=n.isCustodyKeyring=n.KeyringTypes=void 0;const z=e("@ethereumjs/util"),Y=e("@metamask/base-controller"),J=H(e("@metamask/browser-passworder")),X=e("@metamask/eth-hd-keyring"),Q=e("@metamask/eth-sig-util"),Z=W(e("@metamask/eth-simple-keyring")),ee=e("@metamask/utils"),te=e("async-mutex"),ne=H(e("ethereumjs-wallet")),se=e("lodash"),re=e("ulid"),ae=e("./constants.cjs"),oe="KeyringController";var ie;!function(e){e.simple="Simple Key Pair",e.hd="HD Key Tree",e.qr="QR Hardware Wallet Device",e.trezor="Trezor Hardware",e.oneKey="OneKey Hardware",e.ledger="Ledger Hardware",e.lattice="Lattice Hardware",e.snap="Snap Keyring"}(ie||(n.KeyringTypes=ie={}));var ce,me;function de(e){const t=()=>new e;return t.type=e.type,t}n.isCustodyKeyring=e=>e.startsWith("Custody"),function(e){e.privateKey="privateKey",e.json="json"}(ce||(n.AccountImportStrategy=ce={})),function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(me||(n.SignTypedDataVersion=me={})),n.keyringBuilderFactory=de;const ue=[de(Z.default),de(X.HdKeyring)];function le(e){if(!((0,ee.hasProperty)(e,"mnemonic")&&e.mnemonic instanceof Uint8Array))throw new Error("Can't get mnemonic bytes from keyring")}function he(e){if(!("importKey"in e&&"function"==typeof e.importKey&&"decryptWithKey"in e&&"function"==typeof e.decryptWithKey&&"encryptWithKey"in e&&"function"==typeof e.encryptWithKey))throw new Error(ae.KeyringControllerError.UnsupportedEncryptionKeyExport)}function pe(e){if("string"!=typeof e)throw new Error(ae.KeyringControllerError.WrongPasswordType);if(!e||!e.length)throw new Error(ae.KeyringControllerError.InvalidEmptyPassword)}async function fe({keyring:e,metadata:t}){const n=await e.getAccounts();return{type:e.type,accounts:n.map(ge),metadata:t}}function ge(e){return function(e){return(0,ee.isStrictHexString)(e.toLowerCase())&&(0,ee.isValidHexAddress)(e)}(e)?(0,Q.normalize)(e):e}n.getDefaultKeyringState=()=>({isUnlocked:!1,keyrings:[]});class ye extends Y.BaseController{constructor(e){const{encryptor:t=J,keyringBuilders:h,messenger:p,state:f}=e;super({name:oe,metadata:{vault:{includeInStateLogs:!1,persist:!0,anonymous:!1,usedInUi:!1},isUnlocked:{includeInStateLogs:!0,persist:!1,anonymous:!0,usedInUi:!0},keyrings:{includeInStateLogs:!0,persist:!1,anonymous:!1,usedInUi:!0},encryptionKey:{includeInStateLogs:!1,persist:!1,anonymous:!1,usedInUi:!1},encryptionSalt:{includeInStateLogs:!1,persist:!1,anonymous:!1,usedInUi:!1}},messenger:p,state:{...(0,n.getDefaultKeyringState)(),...f}}),s.add(this),r.set(this,new te.Mutex),a.set(this,new te.Mutex),o.set(this,void 0),i.set(this,void 0),c.set(this,void 0),m.set(this,void 0),d.set(this,void 0),u.set(this,void 0),G(this,o,h?h.concat(ue):ue,"f"),G(this,i,t,"f"),G(this,m,[],"f"),G(this,d,[],"f"),G(this,c,Boolean(e.cacheEncryptionKey),"f"),V(this,c,"f")&&he(t),V(this,s,"m",l).call(this)}async addNewAccount(e){return V(this,s,"m",F).call(this),V(this,s,"m",M).call(this,async()=>{const t=this.getKeyringsByType("HD Key Tree")[0];if(!t)throw new Error("No HD keyring found");const n=await t.getAccounts();if(e&&n.length!==e){if(e>n.length)throw new Error("Account out of sequence");const t=n[e];if(!t)throw new Error(`Can't find account at index ${e}`);return t}const[r]=await t.addAccounts(1);return await V(this,s,"m",k).call(this),r})}async addNewAccountForKeyring(e,t){return V(this,s,"m",F).call(this),V(this,s,"m",M).call(this,async()=>{const n=await V(this,s,"m",j).call(this);if(t&&n.length!==t){if(t>n.length)throw new Error("Account out of sequence");const e=n[t];return(0,ee.assertIsStrictHexString)(e),e}await e.addAccounts(1);const r=(await V(this,s,"m",j).call(this)).find(e=>!n.includes(e));return(0,ee.assertIsStrictHexString)(r),r})}async createNewVaultAndRestore(e,t){return V(this,s,"m",M).call(this,async()=>{pe(e),await V(this,s,"m",y).call(this,e,{type:ie.hd,opts:{mnemonic:t,numberOfAccounts:1}})})}async createNewVaultAndKeychain(e){return V(this,s,"m",M).call(this,async()=>{(await V(this,s,"m",j).call(this)).length||await V(this,s,"m",y).call(this,e,{type:ie.hd})})}async addNewKeyring(e,t){return V(this,s,"m",F).call(this),V(this,s,"m",f).call(this,await V(this,s,"m",M).call(this,async()=>V(this,s,"m",C).call(this,e,t)))}async verifyPassword(e){if(!this.state.vault)throw new Error(ae.KeyringControllerError.VaultError);await V(this,i,"f").decrypt(e,this.state.vault)}isUnlocked(){return this.state.isUnlocked}async exportSeedPhrase(e,t){V(this,s,"m",F).call(this),await this.verifyPassword(e);const n=V(this,s,"m",p).call(this,t);if(!n)throw new Error("Keyring not found");return le(n),n.mnemonic}async exportAccount(e,t){await this.verifyPassword(e);const n=await this.getKeyringForAccount(t);if(!n.exportAccount)throw new Error(ae.KeyringControllerError.UnsupportedExportAccount);return await n.exportAccount(ge(t))}async getAccounts(){return V(this,s,"m",F).call(this),this.state.keyrings.reduce((e,t)=>e.concat(t.accounts),[])}async getEncryptionPublicKey(e,t){V(this,s,"m",F).call(this);const n=(0,Q.normalize)(e),r=await this.getKeyringForAccount(e);if(!r.getEncryptionPublicKey)throw new Error(ae.KeyringControllerError.UnsupportedGetEncryptionPublicKey);return await r.getEncryptionPublicKey(n,t)}async decryptMessage(e){V(this,s,"m",F).call(this);const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.decryptMessage)throw new Error(ae.KeyringControllerError.UnsupportedDecryptMessage);return n.decryptMessage(t,e.data)}async getKeyringForAccount(e){V(this,s,"m",F).call(this);const t=ge(e),n=await Promise.all(V(this,m,"f").map(async({keyring:e})=>Promise.all([e,e.getAccounts()]))),r=n.filter(e=>e[1].map(ge).includes(t));if(r.length&&r[0]?.length)return r[0][0];let a="";throw n.length?r.length||(a="There are keyrings, but none match the address"):a="There are no keyrings",new Error(`${ae.KeyringControllerError.NoKeyring}. Error info: ${a}`)}getKeyringsByType(e){return V(this,s,"m",F).call(this),V(this,m,"f").filter(({keyring:t})=>t.type===e).map(({keyring:e})=>e)}async persistAllKeyrings(){return V(this,s,"m",N).call(this,async()=>(V(this,s,"m",F).call(this),await V(this,s,"m",E).call(this),!0))}async importAccountWithStrategy(e,t){return V(this,s,"m",F).call(this),V(this,s,"m",M).call(this,async()=>{let n;switch(e){case ce.privateKey:const[s]=t;if(!s)throw new Error("Cannot import an empty key.");const r=(0,ee.add0x)(s);let a;try{a=(0,ee.hexToBytes)(r)}catch{throw new Error("Cannot import invalid private key.")}if(!(0,z.isValidPrivate)(a)||66!==(0,z.getBinarySize)(r))throw new Error("Cannot import invalid private key.");n=(0,ee.remove0x)(r);break;case ce.json:let o;const[i,c]=t;try{o=ne.thirdparty.fromEtherWallet(i,c)}catch(e){o=o||await ne.default.fromV3(i,c,!0)}n=(0,ee.bytesToHex)(o.getPrivateKey());break;default:throw new Error(`Unexpected import strategy: '${String(e)}'`)}const r=await V(this,s,"m",C).call(this,ie.simple,[n]);return(await r.getAccounts())[0]})}async removeAccount(e){V(this,s,"m",F).call(this),await V(this,s,"m",M).call(this,async()=>{const t=await this.getKeyringForAccount(e),n=0===this.state.keyrings.findIndex(t=>t.accounts.includes(e)),r=1===(await t.getAccounts()).length;if(n&&r)throw new Error(ae.KeyringControllerError.LastAccountInPrimaryKeyring);if(!t.removeAccount)throw new Error(ae.KeyringControllerError.UnsupportedRemoveAccount);t.removeAccount(e),r&&await V(this,s,"m",D).call(this)}),this.messagingSystem.publish(`${oe}:accountRemoved`,e)}async setLocked(){return V(this,s,"m",F).call(this),V(this,s,"m",N).call(this,async()=>{G(this,u,undefined,"f"),await V(this,s,"m",B).call(this),this.update(e=>{e.isUnlocked=!1,e.keyrings=[],delete e.encryptionKey,delete e.encryptionSalt}),this.messagingSystem.publish(`${oe}:lock`)})}async signMessage(e){if(V(this,s,"m",F).call(this),!e.data)throw new Error("Can't sign an empty message");const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.signMessage)throw new Error(ae.KeyringControllerError.UnsupportedSignMessage);return await n.signMessage(t,e.data)}async signEip7702Authorization(e){const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.signEip7702Authorization)throw new Error(ae.KeyringControllerError.UnsupportedSignEip7702Authorization);const{chainId:s,nonce:r}=e,a=(0,Q.normalize)(e.contractAddress);if(a===undefined)throw new Error(ae.KeyringControllerError.MissingEip7702AuthorizationContractAddress);return await n.signEip7702Authorization(t,[s,a,r])}async signPersonalMessage(e){V(this,s,"m",F).call(this);const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.signPersonalMessage)throw new Error(ae.KeyringControllerError.UnsupportedSignPersonalMessage);const r=ge(e.data);return await n.signPersonalMessage(t,r)}async signTypedMessage(e,t){V(this,s,"m",F).call(this);try{if(![me.V1,me.V3,me.V4].includes(t))throw new Error(`Unexpected signTypedMessage version: '${t}'`);const n=(0,Q.normalize)(e.from),s=await this.getKeyringForAccount(n);if(!s.signTypedData)throw new Error(ae.KeyringControllerError.UnsupportedSignTypedMessage);return await s.signTypedData(n,t!==me.V1&&"string"==typeof e.data?JSON.parse(e.data):e.data,{version:t})}catch(e){throw new Error(`Keyring Controller signTypedMessage: ${e}`)}}async signTransaction(e,t,n){V(this,s,"m",F).call(this);const r=(0,Q.normalize)(t),a=await this.getKeyringForAccount(r);if(!a.signTransaction)throw new Error(ae.KeyringControllerError.UnsupportedSignTransaction);return await a.signTransaction(r,e,n)}async prepareUserOperation(e,t,n){V(this,s,"m",F).call(this);const r=(0,Q.normalize)(e),a=await this.getKeyringForAccount(r);if(!a.prepareUserOperation)throw new Error(ae.KeyringControllerError.UnsupportedPrepareUserOperation);return await a.prepareUserOperation(r,t,n)}async patchUserOperation(e,t,n){V(this,s,"m",F).call(this);const r=(0,Q.normalize)(e),a=await this.getKeyringForAccount(r);if(!a.patchUserOperation)throw new Error(ae.KeyringControllerError.UnsupportedPatchUserOperation);return await a.patchUserOperation(r,t,n)}async signUserOperation(e,t,n){V(this,s,"m",F).call(this);const r=(0,Q.normalize)(e),a=await this.getKeyringForAccount(r);if(!a.signUserOperation)throw new Error(ae.KeyringControllerError.UnsupportedSignUserOperation);return await a.signUserOperation(r,t,n)}changePassword(e){return V(this,s,"m",F).call(this),V(this,u,"f")===e?Promise.resolve():V(this,s,"m",M).call(this,async()=>{pe(e),G(this,u,e,"f"),V(this,c,"f")&&this.update(e=>{delete e.encryptionKey,delete e.encryptionSalt})})}async submitEncryptionKey(e,t){const{newMetadata:n}=await V(this,s,"m",N).call(this,async()=>{const n=await V(this,s,"m",v).call(this,undefined,e,t);return V(this,s,"m",O).call(this),n});try{await V(this,s,"m",N).call(this,async()=>{n&&await V(this,s,"m",E).call(this)})}catch(e){console.error("Failed to update vault during login:",e)}}async exportEncryptionKey(){return V(this,s,"m",F).call(this),await V(this,s,"m",K).call(this,async()=>{const{encryptionKey:e}=this.state;return function(e){if(!e)throw new Error(ae.KeyringControllerError.EncryptionKeyNotSet)}(e),e})}async submitPassword(e){const{newMetadata:t}=await V(this,s,"m",N).call(this,async()=>{const t=await V(this,s,"m",v).call(this,e);return V(this,s,"m",O).call(this),t});try{await V(this,s,"m",N).call(this,async()=>{(t||V(this,s,"m",T).call(this))&&await V(this,s,"m",E).call(this)})}catch(e){console.error("Failed to update vault during login:",e)}}async verifySeedPhrase(e){return V(this,s,"m",F).call(this),V(this,s,"m",K).call(this,async()=>V(this,s,"m",k).call(this,e))}async withKeyring(e,t,n={createIfMissing:!1}){return V(this,s,"m",F).call(this),V(this,s,"m",M).call(this,async()=>{let r;if("address"in e?r=await this.getKeyringForAccount(e.address):"type"in e?(r=this.getKeyringsByType(e.type)[e.index||0],!r&&n.createIfMissing&&(r=await V(this,s,"m",C).call(this,e.type,n.createWithData))):"id"in e&&(r=V(this,s,"m",h).call(this,e.id)),!r)throw new Error(ae.KeyringControllerError.KeyringNotFound);const a=await t({keyring:r,metadata:V(this,s,"m",f).call(this,r)});if(Object.is(a,r))throw new Error(ae.KeyringControllerError.UnsafeDirectKeyringAccess);return a})}async getAccountKeyringType(e){V(this,s,"m",F).call(this);return(await this.getKeyringForAccount(e)).type}}async function ke(e,t){const n=await e.acquire();try{return await t({releaseLock:n})}finally{n()}}function be(){return{id:(0,re.ulid)(),name:""}}n.KeyringController=ye,r=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,c=new WeakMap,m=new WeakMap,d=new WeakMap,u=new WeakMap,s=new WeakSet,l=function(){this.messagingSystem.registerActionHandler(`${oe}:signMessage`,this.signMessage.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:signEip7702Authorization`,this.signEip7702Authorization.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:signPersonalMessage`,this.signPersonalMessage.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:signTypedMessage`,this.signTypedMessage.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:decryptMessage`,this.decryptMessage.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:getEncryptionPublicKey`,this.getEncryptionPublicKey.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:getAccounts`,this.getAccounts.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:getKeyringsByType`,this.getKeyringsByType.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:getKeyringForAccount`,this.getKeyringForAccount.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:persistAllKeyrings`,this.persistAllKeyrings.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:prepareUserOperation`,this.prepareUserOperation.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:patchUserOperation`,this.patchUserOperation.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:signUserOperation`,this.signUserOperation.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:addNewAccount`,this.addNewAccount.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:withKeyring`,this.withKeyring.bind(this)),this.messagingSystem.registerActionHandler(`${oe}:addNewKeyring`,this.addNewKeyring.bind(this))},h=function(e){return V(this,m,"f").find(({metadata:t})=>t.id===e)?.keyring},p=function(e){return e?V(this,s,"m",h).call(this,e):V(this,m,"f")[0]?.keyring},f=function(e){const t=V(this,m,"f").find(t=>t.keyring===e);if(!t)throw new Error(ae.KeyringControllerError.KeyringNotFound);return t.metadata},g=function(e){return V(this,o,"f").find(t=>t.type===e)},y=async function(e,t){if(V(this,s,"m",q).call(this),"string"!=typeof e)throw new TypeError(ae.KeyringControllerError.WrongPasswordType);this.update(e=>{delete e.encryptionKey,delete e.encryptionSalt}),G(this,u,e,"f"),await V(this,s,"m",B).call(this),await V(this,s,"m",A).call(this,t.type,t.opts),V(this,s,"m",O).call(this)},k=async function(e){V(this,s,"m",q).call(this);const t=V(this,s,"m",p).call(this,e);if(!t)throw new Error(ae.KeyringControllerError.KeyringNotFound);if(t.type!==ie.hd)throw new Error(ae.KeyringControllerError.UnsupportedVerifySeedPhrase);le(t);const n=t.mnemonic,r=await t.getAccounts();if(0===r.length)throw new Error("Cannot verify an empty keyring.");const a=V(this,s,"m",g).call(this,ie.hd)();await a.deserialize({mnemonic:n,numberOfAccounts:r.length});const o=await a.getAccounts();if(o.length!==r.length)throw new Error("Seed phrase imported incorrect number of accounts.");return o.forEach((e,t)=>{if(e.toLowerCase()!==r[t].toLowerCase())throw new Error("Seed phrase imported different accounts.")}),n},b=async function(){return Promise.all(V(this,m,"f").map(fe))},x=async function({includeUnsupported:e}={includeUnsupported:!0}){const t=await Promise.all(V(this,m,"f").map(async({keyring:e,metadata:t})=>({type:e.type,data:await e.serialize(),metadata:t})));return e&&t.push(...V(this,d,"f")),t},w=async function(){return{keyrings:await V(this,s,"m",x).call(this),password:V(this,u,"f")}},_=async function(e){await V(this,s,"m",B).call(this);const t=[];let n=!1;for(const r of e){const e=await V(this,s,"m",S).call(this,r);if(e){const{keyring:s,metadata:r}=e;t.push({keyring:s,metadata:r}),e.newMetadata&&(n=!0)}}return{keyrings:t,newMetadata:n}},v=async function(e,t,n){return V(this,s,"m",U).call(this,async()=>{const r=this.state.vault;if(!r)throw new Error(ae.KeyringControllerError.VaultError);let a;const o={};if(V(this,c,"f"))if(he(V(this,i,"f")),e){const t=await V(this,i,"f").decryptWithDetail(e,r);a=t.vault,G(this,u,e,"f"),o.encryptionKey=t.exportedKeyString,o.encryptionSalt=t.salt}else{const e=JSON.parse(r);if(n&&n!==e.salt)throw new Error(ae.KeyringControllerError.ExpiredCredentials);if(n=e.salt,"string"!=typeof t)throw new TypeError(ae.KeyringControllerError.WrongPasswordType);const s=await V(this,i,"f").importKey(t);a=await V(this,i,"f").decryptWithKey(s,e),o.encryptionKey=t,o.encryptionSalt=n}else{if("string"!=typeof e)throw new TypeError(ae.KeyringControllerError.WrongPasswordType);a=await V(this,i,"f").decrypt(e,r),G(this,u,e,"f")}if("object"!=typeof(m=a)||!Array.isArray(m)||!m.every(e=>e.type&&(0,ee.isValidJson)(e.data)))throw new Error(ae.KeyringControllerError.VaultDataError);var m;const{keyrings:d,newMetadata:l}=await V(this,s,"m",_).call(this,a),h=await V(this,s,"m",b).call(this);return this.update(e=>{e.keyrings=h,(o.encryptionKey||o.encryptionSalt)&&(e.encryptionKey=o.encryptionKey,e.encryptionSalt=o.encryptionSalt)}),{keyrings:d,newMetadata:l}})},E=function(){return V(this,s,"m",U).call(this,async()=>{await V(this,s,"m",R).call(this);const{encryptionKey:e,encryptionSalt:t,vault:n}=this.state,r=e&&n&&V(this,i,"f").isVaultUpdated?.(n);if(!V(this,u,"f")&&!e)throw new Error(ae.KeyringControllerError.MissingCredentials);const a=await V(this,s,"m",x).call(this);if(!a.some(e=>e.type===ie.hd))throw new Error(ae.KeyringControllerError.NoHdKeyring);const o={};if(V(this,c,"f")){if(he(V(this,i,"f")),r){const n=await V(this,i,"f").importKey(e),s=await V(this,i,"f").encryptWithKey(n,a);s.salt=t,o.vault=JSON.stringify(s)}else if(V(this,u,"f")){const{vault:e,exportedKeyString:t}=await V(this,i,"f").encryptWithDetail(V(this,u,"f"),a);o.vault=e,o.encryptionKey=t}}else pe(V(this,u,"f")),o.vault=await V(this,i,"f").encrypt(V(this,u,"f"),a);if(!o.vault)throw new Error(ae.KeyringControllerError.MissingVaultData);const m=await V(this,s,"m",b).call(this);return this.update(e=>{e.vault=o.vault,e.keyrings=m,o.encryptionKey&&(e.encryptionKey=o.encryptionKey,e.encryptionSalt=JSON.parse(o.vault).salt)}),!0})},T=function(){const{vault:e}=this.state;return!!(e&&V(this,u,"f")&&V(this,i,"f").isVaultUpdated)&&!V(this,i,"f").isVaultUpdated(e)},j=async function(e=[]){const t=V(this,m,"f").map(({keyring:e})=>e);return(await Promise.all([...t,...e].map(async e=>e.getAccounts()))).reduce((e,t)=>e.concat(t),[]).map(ge)},A=async function(e,t){V(this,s,"m",q).call(this);const n=await V(this,s,"m",C).call(this,e,t),[r]=await n.getAccounts();if(!r)throw new Error(ae.KeyringControllerError.NoFirstAccount);return r},C=async function(e,t){const n=await V(this,s,"m",P).call(this,e,t);return V(this,m,"f").push({keyring:n,metadata:be()}),n},P=async function(e,t){V(this,s,"m",q).call(this);const n=V(this,s,"m",g).call(this,e);if(!n)throw new Error(`${ae.KeyringControllerError.NoKeyringBuilder}. Keyring type: ${e}`);const r=n();if(t&&await r.deserialize(t),r.init&&await r.init(),!(e!==ie.hd||(0,ee.isObject)(t)&&t.mnemonic)){if(!r.generateRandomMnemonic)throw new Error(ae.KeyringControllerError.UnsupportedGenerateRandomMnemonic);await r.generateRandomMnemonic(),await r.addAccounts(1)}return r},B=async function(){V(this,s,"m",q).call(this);for(const{keyring:e}of V(this,m,"f"))await V(this,s,"m",I).call(this,e);G(this,m,[],"f"),G(this,d,[],"f")},S=async function(e){V(this,s,"m",q).call(this);try{const{type:t,data:n,metadata:r}=e;let a=!1,o=r;const i=await V(this,s,"m",P).call(this,t,n);return await V(this,s,"m",R).call(this,[i]),o||(a=!0,o=be()),V(this,m,"f").push({keyring:i,metadata:o}),{keyring:i,metadata:o,newMetadata:a}}catch(t){return console.error(t),V(this,d,"f").push(e),undefined}},I=async function(e){await(e.destroy?.())},D=async function(){V(this,s,"m",q).call(this);const e=[];await Promise.all(V(this,m,"f").map(async({keyring:t,metadata:n})=>{(await t.getAccounts()).length>0?e.push({keyring:t,metadata:n}):await V(this,s,"m",I).call(this,t)})),G(this,m,e,"f")},R=async function(e=[]){const t=await V(this,s,"m",j).call(this,e);if(new Set(t).size!==t.length)throw new Error(ae.KeyringControllerError.DuplicatedAccount)},O=function(){V(this,s,"m",q).call(this),this.update(e=>{e.isUnlocked=!0}),this.messagingSystem.publish(`${oe}:unlock`)},F=function(){if(!this.state.isUnlocked)throw new Error(ae.KeyringControllerError.ControllerLocked)},M=async function(e){return V(this,s,"m",N).call(this,async({releaseLock:t})=>{const n=JSON.stringify(await V(this,s,"m",w).call(this)),r=await e({releaseLock:t}),a=JSON.stringify(await V(this,s,"m",w).call(this));return(0,se.isEqual)(n,a)||await V(this,s,"m",E).call(this),r})},N=async function(e){return V(this,s,"m",K).call(this,async({releaseLock:t})=>{const n=await V(this,s,"m",x).call(this),r=V(this,u,"f");try{return await e({releaseLock:t})}catch(e){throw G(this,u,r,"f"),await V(this,s,"m",_).call(this,n),e}})},q=function(){if(!V(this,r,"f").isLocked())throw new Error(ae.KeyringControllerError.ControllerLockRequired)},K=async function(e){return ke(V(this,r,"f"),e)},U=async function(e){return V(this,s,"m",q).call(this),ke(V(this,a,"f"),e)},n.default=ye}}},{package:"@metamask/keyring-controller",file:"node_modules/@metamask/keyring-controller/dist/KeyringController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s;Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringControllerError=void 0,function(e){e.NoKeyring="KeyringController - No keyring found",e.KeyringNotFound="KeyringController - Keyring not found.",e.UnsafeDirectKeyringAccess="KeyringController - Returning keyring instances is unsafe",e.WrongPasswordType="KeyringController - Password must be of type string.",e.InvalidEmptyPassword="KeyringController - Password cannot be empty.",e.NoFirstAccount="KeyringController - First Account not found.",e.DuplicatedAccount="KeyringController - The account you are trying to import is a duplicate",e.VaultError="KeyringController - Cannot unlock without a previous vault.",e.VaultDataError="KeyringController - The decrypted vault has an unexpected shape.",e.UnsupportedEncryptionKeyExport="KeyringController - The encryptor does not support encryption key export.",e.UnsupportedGenerateRandomMnemonic="KeyringController - The current keyring does not support the method generateRandomMnemonic.",e.UnsupportedExportAccount="`KeyringController - The keyring for the current address does not support the method exportAccount",e.UnsupportedRemoveAccount="`KeyringController - The keyring for the current address does not support the method removeAccount",e.UnsupportedSignTransaction="KeyringController - The keyring for the current address does not support the method signTransaction.",e.UnsupportedSignMessage="KeyringController - The keyring for the current address does not support the method signMessage.",e.UnsupportedSignPersonalMessage="KeyringController - The keyring for the current address does not support the method signPersonalMessage.",e.UnsupportedSignEip7702Authorization="KeyringController - The keyring for the current address does not support the method signEip7702Authorization.",e.UnsupportedGetEncryptionPublicKey="KeyringController - The keyring for the current address does not support the method getEncryptionPublicKey.",e.UnsupportedDecryptMessage="KeyringController - The keyring for the current address does not support the method decryptMessage.",e.UnsupportedSignTypedMessage="KeyringController - The keyring for the current address does not support the method signTypedMessage.",e.UnsupportedGetAppKeyAddress="KeyringController - The keyring for the current address does not support the method getAppKeyAddress.",e.UnsupportedExportAppKeyForAddress="KeyringController - The keyring for the current address does not support the method exportAppKeyForAddress.",e.UnsupportedPrepareUserOperation="KeyringController - The keyring for the current address does not support the method prepareUserOperation.",e.UnsupportedPatchUserOperation="KeyringController - The keyring for the current address does not support the method patchUserOperation.",e.UnsupportedSignUserOperation="KeyringController - The keyring for the current address does not support the method signUserOperation.",e.UnsupportedVerifySeedPhrase="KeyringController - The keyring does not support the method verifySeedPhrase.",e.MissingEip7702AuthorizationContractAddress="KeyringController - The EIP-7702 Authorization is invalid. No contract address provided.",e.NoAccountOnKeychain="KeyringController - The keychain doesn't have accounts.",e.ControllerLocked="KeyringController - The operation cannot be completed while the controller is locked.",e.MissingCredentials="KeyringController - Cannot persist vault without password and encryption key",e.MissingVaultData="KeyringController - Cannot persist vault without vault information",e.ExpiredCredentials="KeyringController - Encryption key and salt provided are expired",e.NoKeyringBuilder="KeyringController - No keyringBuilder found for keyring",e.DataType="KeyringController - Incorrect data type provided",e.NoHdKeyring="KeyringController - No HD Keyring found",e.ControllerLockRequired="KeyringController - attempt to update vault during a non mutually exclusive operation",e.LastAccountInPrimaryKeyring="KeyringController - Last account in primary keyring cannot be removed",e.EncryptionKeyNotSet="KeyringController - Encryption key not set"}(s||(n.KeyringControllerError=s={}))}}},{package:"@metamask/keyring-controller",file:"node_modules/@metamask/keyring-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-controller/dist/index.cjs",{"./KeyringController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-controller/dist/KeyringController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./KeyringController.cjs"),n)}}},{package:"@metamask/keyring-controller",file:"node_modules/@metamask/keyring-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/compatibility/index.cjs",{"./v1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/compatibility/v1.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./v1.cjs"),n)}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/compatibility/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/compatibility/v1.cjs",{"@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SubmitRequestResponseV1Struct=n.KeyringResponseV1Struct=n.KeyringRequestV1Struct=void 0,n.toKeyringRequestV1=function(e){const{origin:t,...n}=e;return n};const s=e("@metamask/keyring-api"),r=e("@metamask/superstruct");n.KeyringRequestV1Struct=(0,r.omit)(s.KeyringRequestStruct,["origin"]),n.KeyringResponseV1Struct=s.KeyringResponseStruct,n.SubmitRequestResponseV1Struct=n.KeyringResponseV1Struct}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/compatibility/v1.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/index.cjs",{"./compatibility/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/compatibility/index.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/types.cjs","./versions.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/versions.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./compatibility/index.cjs"),n),r(e("./types.cjs"),n),r(e("./versions.cjs"),n)}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/types.cjs",{"@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.InternalAccountStruct=n.InternalAccountStructs=n.InternalTrxEoaAccountStruct=n.InternalSolDataAccountStruct=n.InternalBtcP2trAccountStruct=n.InternalBtcP2wpkhAccountStruct=n.InternalBtcP2shAccountStruct=n.InternalBtcP2pkhAccountStruct=n.InternalEthErc4337AccountStruct=n.InternalEthEoaAccountStruct=n.InternalAccountMetadataStruct=void 0;const s=e("@metamask/keyring-api"),r=e("@metamask/keyring-utils"),a=e("@metamask/superstruct");n.InternalAccountMetadataStruct=(0,r.object)({metadata:(0,r.object)({name:(0,a.string)(),nameLastUpdatedAt:(0,r.exactOptional)((0,a.number)()),snap:(0,r.exactOptional)((0,r.object)({id:(0,a.string)(),enabled:(0,a.boolean)(),name:(0,a.string)()})),lastSelected:(0,r.exactOptional)((0,a.number)()),importTime:(0,a.number)(),keyring:(0,r.object)({type:(0,a.string)()})})}),n.InternalEthEoaAccountStruct=(0,r.object)({...s.EthEoaAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalEthErc4337AccountStruct=(0,r.object)({...s.EthErc4337AccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2pkhAccountStruct=(0,r.object)({...s.BtcP2pkhAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2shAccountStruct=(0,r.object)({...s.BtcP2shAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2wpkhAccountStruct=(0,r.object)({...s.BtcP2wpkhAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2trAccountStruct=(0,r.object)({...s.BtcP2trAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalSolDataAccountStruct=(0,r.object)({...s.SolDataAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalTrxEoaAccountStruct=(0,r.object)({...s.TrxEoaAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalAccountStructs={[`${s.EthAccountType.Eoa}`]:n.InternalEthEoaAccountStruct,[`${s.EthAccountType.Erc4337}`]:n.InternalEthErc4337AccountStruct,[`${s.BtcAccountType.P2pkh}`]:n.InternalBtcP2pkhAccountStruct,[`${s.BtcAccountType.P2sh}`]:n.InternalBtcP2shAccountStruct,[`${s.BtcAccountType.P2wpkh}`]:n.InternalBtcP2wpkhAccountStruct,[`${s.BtcAccountType.P2tr}`]:n.InternalBtcP2trAccountStruct,[`${s.SolAccountType.DataAccount}`]:n.InternalSolDataAccountStruct,[`${s.TrxAccountType.Eoa}`]:n.InternalTrxEoaAccountStruct},n.InternalAccountStruct=(0,r.object)({...s.KeyringAccountStruct.schema,...n.InternalAccountMetadataStruct.schema})}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/versions.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s;Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringVersion=void 0,function(e){e.V1="v1",e.V2="v2"}(s||(n.KeyringVersion=s={}))}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/versions.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-snap-client/dist/KeyringInternalSnapClient.cjs",{"@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-internal-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-api/dist/index.cjs","@metamask/keyring-snap-client":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a,o,i,c=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},m=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringInternalSnapClient=void 0;const d=e("@metamask/keyring-api"),u=e("@metamask/keyring-internal-api"),l=e("@metamask/keyring-snap-client"),h=e("@metamask/keyring-utils");class p{constructor(e,t,n,i){s.set(this,void 0),r.set(this,void 0),a.set(this,void 0),o.set(this,void 0),c(this,a,e,"f"),c(this,s,t,"f"),c(this,r,n,"f"),c(this,o,i,"f")}async send(e){return m(this,a,"f").call("SnapController:handleRequest",{snapId:m(this,s,"f"),origin:m(this,r,"f"),handler:m(this,o,"f"),request:e})}}s=new WeakMap,r=new WeakMap,a=new WeakMap,o=new WeakMap;class f extends l.KeyringClient{constructor({messenger:e,snapId:t="undefined",origin:n="metamask",handler:s="onKeyringRequest"}){super(new p(e,t,n,s)),i.set(this,void 0),c(this,i,e,"f")}withSnapId(e){return new f({messenger:m(this,i,"f"),snapId:e})}async submitRequestV1(e){return(0,h.strictMask)(await this.send({method:d.KeyringRpcMethod.SubmitRequest,params:e}),u.SubmitRequestResponseV1Struct)}}n.KeyringInternalSnapClient=f,i=new WeakMap}}},{package:"@metamask/keyring-internal-snap-client",file:"node_modules/@metamask/keyring-internal-snap-client/dist/KeyringInternalSnapClient.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-snap-client/dist/index.cjs",{"./KeyringInternalSnapClient.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-internal-snap-client/dist/KeyringInternalSnapClient.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./KeyringInternalSnapClient.cjs"),n)}}},{package:"@metamask/keyring-internal-snap-client",file:"node_modules/@metamask/keyring-internal-snap-client/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringClient.cjs",{"@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs","@metamask/keyring-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},a=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringClient=void 0;const o=e("@metamask/keyring-api"),i=e("@metamask/keyring-utils"),c=e("@metamask/superstruct"),m=e("uuid");n.KeyringClient=class{constructor(e){s.set(this,void 0),r(this,s,e,"f")}async send(e){return a(this,s,"f").send({jsonrpc:"2.0",id:(0,m.v4)(),...e})}async listAccounts(){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.ListAccounts}),o.ListAccountsResponseStruct)}async getAccount(e){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.GetAccount,params:{id:e}}),o.GetAccountResponseStruct)}async getAccountBalances(e,t){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.GetAccountBalances,params:{id:e,assets:t}}),o.GetAccountBalancesResponseStruct)}async createAccount(e={}){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.CreateAccount,params:{options:e}}),o.CreateAccountResponseStruct)}async discoverAccounts(e,t,n){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.DiscoverAccounts,params:{scopes:e,entropySource:t,groupIndex:n}}),o.DiscoverAccountsResponseStruct)}async listAccountTransactions(e,t){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.ListAccountTransactions,params:{id:e,pagination:t}}),o.ListAccountTransactionsResponseStruct)}async listAccountAssets(e){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.ListAccountAssets,params:{id:e}}),o.ListAccountAssetsResponseStruct)}async resolveAccountAddress(e,t){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.ResolveAccountAddress,params:{scope:e,request:t}}),o.ResolveAccountAddressResponseStruct)}async filterAccountChains(e,t){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.FilterAccountChains,params:{id:e,chains:t}}),o.FilterAccountChainsResponseStruct)}async updateAccount(e){(0,c.assert)(await this.send({method:o.KeyringRpcMethod.UpdateAccount,params:{account:e}}),o.UpdateAccountResponseStruct)}async deleteAccount(e){(0,c.assert)(await this.send({method:o.KeyringRpcMethod.DeleteAccount,params:{id:e}}),o.DeleteAccountResponseStruct)}async exportAccount(e){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.ExportAccount,params:{id:e}}),o.ExportAccountResponseStruct)}async listRequests(){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.ListRequests}),o.ListRequestsResponseStruct)}async getRequest(e){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.GetRequest,params:{id:e}}),o.GetRequestResponseStruct)}async submitRequest(e){return(0,i.strictMask)(await this.send({method:o.KeyringRpcMethod.SubmitRequest,params:e}),o.SubmitRequestResponseStruct)}async approveRequest(e,t={}){(0,c.assert)(await this.send({method:o.KeyringRpcMethod.ApproveRequest,params:{id:e,data:t}}),o.ApproveRequestResponseStruct)}async rejectRequest(e){(0,c.assert)(await this.send({method:o.KeyringRpcMethod.RejectRequest,params:{id:e}}),o.RejectRequestResponseStruct)}},s=new WeakMap}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/KeyringClient.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringPublicClient.cjs",{"./KeyringClient.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringClient.cjs","@metamask/keyring-api":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-api/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},a=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringPublicClient=n.KeyringPublicRpcMethod=void 0;const o=e("@metamask/keyring-api"),i=e("./KeyringClient.cjs");n.KeyringPublicRpcMethod=[o.KeyringRpcMethod.CreateAccount,o.KeyringRpcMethod.GetAccount,o.KeyringRpcMethod.UpdateAccount,o.KeyringRpcMethod.DeleteAccount,o.KeyringRpcMethod.ExportAccount,o.KeyringRpcMethod.ListAccounts,o.KeyringRpcMethod.FilterAccountChains,o.KeyringRpcMethod.GetRequest,o.KeyringRpcMethod.ApproveRequest,o.KeyringRpcMethod.RejectRequest,o.KeyringRpcMethod.ListRequests];n.KeyringPublicClient=class{constructor(e){s.set(this,void 0),r(this,s,new i.KeyringClient(e),"f")}async createAccount(e){return a(this,s,"f").createAccount(e)}async deleteAccount(e){return a(this,s,"f").deleteAccount(e)}async listAccounts(){return a(this,s,"f").listAccounts()}async getAccount(e){return a(this,s,"f").getAccount(e)}async getRequest(e){return a(this,s,"f").getRequest(e)}async listRequests(){return a(this,s,"f").listRequests()}async updateAccount(e){return a(this,s,"f").updateAccount(e)}async approveRequest(e,t){return a(this,s,"f").approveRequest(e,t)}async rejectRequest(e){return a(this,s,"f").rejectRequest(e)}async filterAccountChains(e,t){return a(this,s,"f").filterAccountChains(e,t)}async exportAccount(e){return a(this,s,"f").exportAccount(e)}},s=new WeakMap}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/KeyringPublicClient.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringSnapRpcClient.cjs",{"./KeyringPublicClient.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringPublicClient.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a=this&&this.__classPrivateFieldSet||function(e,t,n,s,r){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?r.call(e,n):r?r.value=n:t.set(e,n),n},o=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringSnapRpcClient=n.SnapRpcSender=void 0;const i=e("./KeyringPublicClient.cjs");class c{constructor(e,t){s.set(this,void 0),r.set(this,void 0),a(this,s,e,"f"),a(this,r,t,"f")}async send(e){return o(this,r,"f").request({method:"wallet_invokeKeyring",params:{snapId:o(this,s,"f"),request:e}})}}n.SnapRpcSender=c,s=new WeakMap,r=new WeakMap;class m extends i.KeyringPublicClient{constructor(e,t){super(new c(e,t))}}n.KeyringSnapRpcClient=m}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/KeyringSnapRpcClient.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/index.cjs",{"./KeyringClient.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringClient.cjs","./KeyringPublicClient.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringPublicClient.cjs","./KeyringSnapRpcClient.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/dist/KeyringSnapRpcClient.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./KeyringClient.cjs"),n),r(e("./KeyringSnapRpcClient.cjs"),n),r(e("./KeyringPublicClient.cjs"),n)}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/index.js",{"./nil.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/nil.js","./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/stringify.js","./v1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v1.js","./v3.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v3.js","./v4.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v4.js","./v5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v5.js","./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/validate.js","./version.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/version.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return m.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}});var s=l(e("./v1.js")),r=l(e("./v3.js")),a=l(e("./v4.js")),o=l(e("./v5.js")),i=l(e("./nil.js")),c=l(e("./version.js")),m=l(e("./validate.js")),d=l(e("./stringify.js")),u=l(e("./parse.js"));function l(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/md5-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e){return 14+(e+64>>>9<<4)+1}function r(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function a(e,t,n,s,a,o){return r((i=r(r(t,e),r(s,o)))<<(c=a)|i>>>32-c,n);var i,c}function o(e,t,n,s,r,o,i){return a(t&n|~t&s,e,t,r,o,i)}function i(e,t,n,s,r,o,i){return a(t&s|n&~s,e,t,r,o,i)}function c(e,t,n,s,r,o,i){return a(t^n^s,e,t,r,o,i)}function m(e,t,n,s,r,o,i){return a(n^(t|~s),e,t,r,o,i)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var d=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,s="0123456789abcdef";for(let r=0;r<n;r+=8){const n=e[r>>5]>>>r%32&255,a=parseInt(s.charAt(n>>>4&15)+s.charAt(15&n),16);t.push(a)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[s(t)-1]=t;let n=1732584193,a=-271733879,d=-1732584194,u=271733878;for(let t=0;t<e.length;t+=16){const s=n,l=a,h=d,p=u;n=o(n,a,d,u,e[t],7,-680876936),u=o(u,n,a,d,e[t+1],12,-389564586),d=o(d,u,n,a,e[t+2],17,606105819),a=o(a,d,u,n,e[t+3],22,-1044525330),n=o(n,a,d,u,e[t+4],7,-176418897),u=o(u,n,a,d,e[t+5],12,1200080426),d=o(d,u,n,a,e[t+6],17,-1473231341),a=o(a,d,u,n,e[t+7],22,-45705983),n=o(n,a,d,u,e[t+8],7,1770035416),u=o(u,n,a,d,e[t+9],12,-1958414417),d=o(d,u,n,a,e[t+10],17,-42063),a=o(a,d,u,n,e[t+11],22,-1990404162),n=o(n,a,d,u,e[t+12],7,1804603682),u=o(u,n,a,d,e[t+13],12,-40341101),d=o(d,u,n,a,e[t+14],17,-1502002290),a=o(a,d,u,n,e[t+15],22,1236535329),n=i(n,a,d,u,e[t+1],5,-165796510),u=i(u,n,a,d,e[t+6],9,-1069501632),d=i(d,u,n,a,e[t+11],14,643717713),a=i(a,d,u,n,e[t],20,-373897302),n=i(n,a,d,u,e[t+5],5,-701558691),u=i(u,n,a,d,e[t+10],9,38016083),d=i(d,u,n,a,e[t+15],14,-660478335),a=i(a,d,u,n,e[t+4],20,-405537848),n=i(n,a,d,u,e[t+9],5,568446438),u=i(u,n,a,d,e[t+14],9,-1019803690),d=i(d,u,n,a,e[t+3],14,-187363961),a=i(a,d,u,n,e[t+8],20,1163531501),n=i(n,a,d,u,e[t+13],5,-1444681467),u=i(u,n,a,d,e[t+2],9,-51403784),d=i(d,u,n,a,e[t+7],14,1735328473),a=i(a,d,u,n,e[t+12],20,-1926607734),n=c(n,a,d,u,e[t+5],4,-378558),u=c(u,n,a,d,e[t+8],11,-2022574463),d=c(d,u,n,a,e[t+11],16,1839030562),a=c(a,d,u,n,e[t+14],23,-35309556),n=c(n,a,d,u,e[t+1],4,-1530992060),u=c(u,n,a,d,e[t+4],11,1272893353),d=c(d,u,n,a,e[t+7],16,-155497632),a=c(a,d,u,n,e[t+10],23,-1094730640),n=c(n,a,d,u,e[t+13],4,681279174),u=c(u,n,a,d,e[t],11,-358537222),d=c(d,u,n,a,e[t+3],16,-722521979),a=c(a,d,u,n,e[t+6],23,76029189),n=c(n,a,d,u,e[t+9],4,-640364487),u=c(u,n,a,d,e[t+12],11,-421815835),d=c(d,u,n,a,e[t+15],16,530742520),a=c(a,d,u,n,e[t+2],23,-995338651),n=m(n,a,d,u,e[t],6,-198630844),u=m(u,n,a,d,e[t+7],10,1126891415),d=m(d,u,n,a,e[t+14],15,-1416354905),a=m(a,d,u,n,e[t+5],21,-57434055),n=m(n,a,d,u,e[t+12],6,1700485571),u=m(u,n,a,d,e[t+3],10,-1894986606),d=m(d,u,n,a,e[t+10],15,-1051523),a=m(a,d,u,n,e[t+1],21,-2054922799),n=m(n,a,d,u,e[t+8],6,1873313359),u=m(u,n,a,d,e[t+15],10,-30611744),d=m(d,u,n,a,e[t+6],15,-1560198380),a=m(a,d,u,n,e[t+13],21,1309151649),n=m(n,a,d,u,e[t+4],6,-145523070),u=m(u,n,a,d,e[t+11],10,-1120210379),d=m(d,u,n,a,e[t+2],15,718787259),a=m(a,d,u,n,e[t+9],21,-343485551),n=r(n,s),a=r(a,l),d=r(d,h),u=r(u,p)}return[n,a,d,u]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(s(t));for(let s=0;s<t;s+=8)n[s>>5]|=(255&e[s/8])<<s%32;return n}(e),8*e.length))};n.default=d}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/md5-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/native-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=s}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/native-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/nil.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/nil.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/parse.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=a}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/parse.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/regex.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/regex.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/rng-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let s;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!s&&(s="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!s))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return s(r)};const r=new Uint8Array(16)}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/rng-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/sha1-browser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function s(e,t,n,s){switch(e){case 0:return t&n^~t&s;case 1:case 3:return t^n^s;case 2:return t&n^t&s^n&s}}function r(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var a=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const a=e.length/4+2,o=Math.ceil(a/16),i=new Array(o);for(let t=0;t<o;++t){const n=new Uint32Array(16);for(let s=0;s<16;++s)n[s]=e[64*t+4*s]<<24|e[64*t+4*s+1]<<16|e[64*t+4*s+2]<<8|e[64*t+4*s+3];i[t]=n}i[o-1][14]=8*(e.length-1)/Math.pow(2,32),i[o-1][14]=Math.floor(i[o-1][14]),i[o-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<o;++e){const a=new Uint32Array(80);for(let t=0;t<16;++t)a[t]=i[e][t];for(let e=16;e<80;++e)a[e]=r(a[e-3]^a[e-8]^a[e-14]^a[e-16],1);let o=n[0],c=n[1],m=n[2],d=n[3],u=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),i=r(o,5)+s(n,c,m,d)+u+t[n]+a[e]>>>0;u=d,d=m,m=r(c,30)>>>0,c=o,o=i}n[0]=n[0]+o>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+m>>>0,n[3]=n[3]+d>>>0,n[4]=n[4]+u>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=a}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/sha1-browser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/stringify.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=o;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};const a=[];for(let e=0;e<256;++e)a.push((e+256).toString(16).slice(1));function o(e,t=0){return a[e[t+0]]+a[e[t+1]]+a[e[t+2]]+a[e[t+3]]+"-"+a[e[t+4]]+a[e[t+5]]+"-"+a[e[t+6]]+a[e[t+7]]+"-"+a[e[t+8]]+a[e[t+9]]+"-"+a[e[t+10]]+a[e[t+11]]+a[e[t+12]]+a[e[t+13]]+a[e[t+14]]+a[e[t+15]]}var i=function(e,t=0){const n=o(e,t);if(!(0,r.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/stringify.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v1.js",{"./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./rng.js"))&&s.__esModule?s:{default:s},a=e("./stringify.js");let o,i,c=0,m=0;var d=function(e,t,n){let s=t&&n||0;const d=t||new Array(16);let u=(e=e||{}).node||o,l=e.clockseq!==undefined?e.clockseq:i;if(null==u||null==l){const t=e.random||(e.rng||r.default)();null==u&&(u=o=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==l&&(l=i=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),p=e.nsecs!==undefined?e.nsecs:m+1;const f=h-c+(p-m)/1e4;if(f<0&&e.clockseq===undefined&&(l=l+1&16383),(f<0||h>c)&&e.nsecs===undefined&&(p=0),p>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,m=p,i=l,h+=122192928e5;const g=(1e4*(268435455&h)+p)%4294967296;d[s++]=g>>>24&255,d[s++]=g>>>16&255,d[s++]=g>>>8&255,d[s++]=255&g;const y=h/4294967296*1e4&268435455;d[s++]=y>>>8&255,d[s++]=255&y,d[s++]=y>>>24&15|16,d[s++]=y>>>16&255,d[s++]=l>>>8|128,d[s++]=255&l;for(let e=0;e<6;++e)d[s+e]=u[e];return t||(0,a.unsafeStringify)(d)};n.default=d}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v1.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v3.js",{"./md5.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/md5-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./md5.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v3",48,r.default);n.default=o}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v3.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v35.js",{"./parse.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/parse.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function s(e,s,o,i){var c;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof s&&(s=(0,a.default)(s)),16!==(null===(c=s)||void 0===c?void 0:c.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let m=new Uint8Array(16+e.length);if(m.set(s),m.set(e,s.length),m=n(m),m[6]=15&m[6]|t,m[8]=63&m[8]|128,o){i=i||0;for(let e=0;e<16;++e)o[i+e]=m[e];return o}return(0,r.unsafeStringify)(m)}try{s.name=e}catch(e){}return s.DNS=o,s.URL=i,s};var s,r=e("./stringify.js"),a=(s=e("./parse.js"))&&s.__esModule?s:{default:s};const o="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=o;const i="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v35.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v4.js",{"./native.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/native-browser.js","./rng.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/rng-browser.js","./stringify.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/stringify.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=o(e("./native.js")),r=o(e("./rng.js")),a=e("./stringify.js");function o(e){return e&&e.__esModule?e:{default:e}}var i=function(e,t,n){if(s.default.randomUUID&&!t&&!e)return s.default.randomUUID();const o=(e=e||{}).random||(e.rng||r.default)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=o[e];return t}return(0,a.unsafeStringify)(o)};n.default=i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v4.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v5.js",{"./sha1.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/sha1-browser.js","./v35.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v35.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=a(e("./v35.js")),r=a(e("./sha1.js"));function a(e){return e&&e.__esModule?e:{default:e}}var o=(0,s.default)("v5",80,r.default);n.default=o}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v5.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/validate.js",{"./regex.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/regex.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./regex.js"))&&s.__esModule?s:{default:s};var a=function(e){return"string"==typeof e&&r.default.test(e)};n.default=a}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/validate.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/version.js",{"./validate.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/validate.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s,r=(s=e("./validate.js"))&&s.__esModule?s:{default:s};var a=function(e){if(!(0,r.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=a}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/version.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/JsonRpcRequest.cjs",{"./index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcRequestStruct=void 0;const s=e("@metamask/superstruct"),r=e("@metamask/utils"),a=e("./index.cjs");n.JsonRpcRequestStruct=(0,a.object)({jsonrpc:(0,s.literal)("2.0"),id:(0,s.union)([(0,s.string)(),(0,s.number)(),(0,s.literal)(null)]),method:(0,s.string)(),params:(0,a.exactOptional)((0,s.union)([(0,s.array)(r.JsonStruct),(0,s.record)((0,s.string)(),r.JsonStruct)]))})}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/JsonRpcRequest.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/btc/address.cjs",{"bitcoin-address-validation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bitcoin-address-validation/lib/index.cjs.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isBtcMainnetAddress=function(e){return(0,s.validate)(e,s.Network.mainnet)},n.isBtcTestnetAddress=function(e){return(0,s.validate)(e,s.Network.testnet)};const s=e("bitcoin-address-validation")}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/btc/address.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/btc/index.cjs",{"./address.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/btc/address.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./address.cjs"),n)}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/btc/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/index.cjs",{"./JsonRpcRequest.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/JsonRpcRequest.cjs","./btc/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/btc/index.cjs","./scopes.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/scopes.cjs","./superstruct.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/superstruct.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/types.cjs","./typing.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/typing.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./btc/index.cjs"),n),r(e("./types.cjs"),n),r(e("./typing.cjs"),n),r(e("./scopes.cjs"),n),r(e("./superstruct.cjs"),n),r(e("./JsonRpcRequest.cjs"),n)}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/scopes.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ETH_SCOPE_EOA=void 0,n.isScopeEqual=a,n.isScopeEqualToAny=function(e,t){return t.some(t=>a(e,t))};const s=e("@metamask/utils");n.ETH_SCOPE_EOA=`${s.KnownCaipNamespace.Eip155}:0`;const r=`${s.KnownCaipNamespace.Eip155}:`;function a(e,t){const s=e===n.ETH_SCOPE_EOA,a=t===n.ETH_SCOPE_EOA;return s?t.startsWith(r):a?e.startsWith(r):e===t}}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/scopes.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/superstruct.cjs",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.object=function(e){return(0,s.object)(e)},n.type=function(e){return(0,s.type)(e)},n.exactOptional=function(e){return new s.Struct({...e,validator:(t,n)=>!r(n)||e.validator(t,n),refiner:(t,n)=>!r(n)||e.refiner(t,n)})},n.strictMask=function(e,t,n){return(0,s.assert)(e,t,n),e},n.selectiveUnion=function(e){return new s.Struct({type:"union",schema:null,*entries(t,n){yield*e(t).entries(t,n)},*refiner(t,n){yield*e(t).refiner(t,n)},coercer:(t,n)=>e(t).coercer(t,n),validator:(t,n)=>e(t).validator(t,n)})};const s=e("@metamask/superstruct");function r(e){return e.path[e.path.length-1]in e.branch[e.branch.length-2]}}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/superstruct.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/types.cjs",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.StringNumberStruct=n.UrlStruct=n.AccountIdStruct=n.UuidStruct=void 0;const s=e("@metamask/superstruct"),r=e("@metamask/utils");n.UuidStruct=(0,r.definePattern)("UuidV4",/^[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/iu),n.AccountIdStruct=n.UuidStruct,n.UrlStruct=(0,s.define)("Url",e=>{try{const t=new URL(e);return"http:"===t.protocol||"https:"===t.protocol}catch{return!1}}),n.StringNumberStruct=(0,r.definePattern)("StringNumber",/^\d+(\.\d+)?$/u)}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/keyring-utils/dist/typing.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.expectTrue=function(){}}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/typing.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/LoggingController.cjs",{"@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r,a=this&&this.__classPrivateFieldGet||function(e,t,n,s){if("a"===n&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?s:"a"===n?s.call(e):s?s.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.LoggingController=void 0;const o=e("@metamask/base-controller"),i=e("uuid"),c="LoggingController",m={logs:{persist:!0,anonymous:!1}},d={logs:{}};class u extends o.BaseController{constructor({messenger:e,state:t}){super({name:c,metadata:m,messenger:e,state:{...d,...t}}),s.add(this),this.messagingSystem.registerActionHandler(`${c}:add`,e=>this.add(e))}add(e){const t={id:a(this,s,"m",r).call(this),timestamp:Date.now(),log:e};this.update(e=>{e.logs[t.id]=t})}clear(){this.update(e=>{e.logs={}})}}n.LoggingController=u,s=new WeakSet,r=function(){let e=(0,i.v1)();for(;e in this.state.logs;)e=(0,i.v1)();return e}}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/LoggingController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/index.cjs",{"./LoggingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/LoggingController.cjs","./logTypes/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./LoggingController.cjs"),n),r(e("./logTypes/index.cjs"),n)}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/EthSignLog.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s,r;Object.defineProperty(n,"__esModule",{value:!0}),n.SigningStage=n.SigningMethod=void 0,function(e){e.PersonalSign="personal_sign",e.EthSignTypedData="eth_signTypedData",e.EthSignTypedDataV3="eth_signTypedData_v3",e.EthSignTypedDataV4="eth_signTypedData_v4"}(s||(n.SigningMethod=s={})),function(e){e.Proposed="proposed",e.Rejected="rejected",e.Signed="signed"}(r||(n.SigningStage=r={}))}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/EthSignLog.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/GenericLog.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/GenericLog.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/LogType.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s;Object.defineProperty(n,"__esModule",{value:!0}),n.LogType=void 0,function(e){e.GenericLog="GenericLog",e.EthSignLog="EthSignLog"}(s||(n.LogType=s={}))}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/LogType.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/index.cjs",{"./EthSignLog.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/EthSignLog.cjs","./GenericLog.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/GenericLog.cjs","./LogType.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/logging-controller/dist/logTypes/LogType.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var s=this&&this.__createBinding||(Object.create?function(e,t,n,s){s===undefined&&(s=n);var r=Object.getOwnPropertyDescriptor(t,n);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,s,r)}:function(e,t,n,s){s===undefined&&(s=n),e[s]=t[n]}),r=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||s(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),r(e("./EthSignLog.cjs"),n),r(e("./GenericLog.cjs"),n),r(e("./LogType.cjs"),n)}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC1155.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiERC1155=void 0,n.abiERC1155=[{inputs:[{internalType:"string",name:"uri_",type:"string"}],stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!1,internalType:"bool",name:"approved",type:"bool"}],name:"ApprovalForAll",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256[]",name:"ids",type:"uint256[]"},{indexed:!1,internalType:"uint256[]",name:"values",type:"uint256[]"}],name:"TransferBatch",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256",name:"id",type:"uint256"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"}],name:"TransferSingle",type:"event"},{anonymous:!1,inputs:[{indexed:!1,internalType:"string",name:"value",type:"string"},{indexed:!0,internalType:"uint256",name:"id",type:"uint256"}],name:"URI",type:"event"},{inputs:[{internalType:"address",name:"account",type:"address"},{internalType:"uint256",name:"id",type:"uint256"}],name:"balanceOf",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address[]",name:"accounts",type:"address[]"},{internalType:"uint256[]",name:"ids",type:"uint256[]"}],name:"balanceOfBatch",outputs:[{internalType:"uint256[]",name:"",type:"uint256[]"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"},{internalType:"address",name:"operator",type:"address"}],name:"isApprovedForAll",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256[]",name:"ids",type:"uint256[]"},{internalType:"uint256[]",name:"amounts",type:"uint256[]"},{internalType:"bytes",name:"data",type:"bytes"}],name:"safeBatchTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"id",type:"uint256"},{internalType:"uint256",name:"amount",type:"uint256"},{internalType:"bytes",name:"data",type:"bytes"}],name:"safeTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"operator",type:"address"},{internalType:"bool",name:"approved",type:"bool"}],name:"setApprovalForAll",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"bytes4",name:"interfaceId",type:"bytes4"}],name:"supportsInterface",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"",type:"uint256"}],name:"uri",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"}]}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC1155.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC20.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiERC20=void 0,n.abiERC20=[{constant:!0,inputs:[],name:"name",outputs:[{name:"",type:"string"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_spender",type:"address"},{name:"_value",type:"uint256"}],name:"approve",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"totalSupply",outputs:[{name:"",type:"uint256"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_value",type:"uint256"}],name:"transferFrom",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"decimals",outputs:[{name:"",type:"uint256"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"version",outputs:[{name:"",type:"string"}],payable:!1,type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"}],name:"balanceOf",outputs:[{name:"balance",type:"uint256"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"symbol",outputs:[{name:"",type:"string"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_to",type:"address"},{name:"_value",type:"uint256"}],name:"transfer",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_spender",type:"address"},{name:"_value",type:"uint256"},{name:"_extraData",type:"bytes"}],name:"approveAndCall",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"},{name:"_spender",type:"address"}],name:"allowance",outputs:[{name:"remaining",type:"uint256"}],payable:!1,type:"function"},{inputs:[{name:"_initialAmount",type:"uint256"},{name:"_tokenName",type:"string"},{name:"_decimalUnits",type:"uint8"},{name:"_tokenSymbol",type:"string"}],type:"constructor"},{payable:!1,type:"fallback"},{anonymous:!1,inputs:[{indexed:!0,name:"_from",type:"address"},{indexed:!0,name:"_to",type:"address"},{indexed:!1,name:"_value",type:"uint256"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"_owner",type:"address"},{indexed:!0,name:"_spender",type:"address"},{indexed:!1,name:"_value",type:"uint256"}],name:"Approval",type:"event"}]}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC20.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC721.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiERC721=void 0,n.abiERC721=[{constant:!0,inputs:[{name:"interfaceID",type:"bytes4"}],name:"supportsInterface",outputs:[{name:"",type:"bool"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[],name:"name",outputs:[{name:"_name",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_tokenId",type:"uint256"}],name:"getApproved",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_approved",type:"address"},{name:"_tokenId",type:"uint256"}],name:"approve",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[],name:"totalSupply",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_tokenId",type:"uint256"}],name:"transferFrom",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"},{name:"_index",type:"uint256"}],name:"tokenOfOwnerByIndex",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_tokenId",type:"uint256"}],name:"safeTransferFrom",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[{name:"_index",type:"uint256"}],name:"tokenByIndex",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_tokenId",type:"uint256"}],name:"ownerOf",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"}],name:"balanceOf",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[],name:"symbol",outputs:[{name:"_symbol",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_operator",type:"address"},{name:"_approved",type:"bool"}],name:"setApprovalForAll",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_tokenId",type:"uint256"},{name:"data",type:"bytes"}],name:"safeTransferFrom",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[{name:"_tokenId",type:"uint256"}],name:"tokenURI",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"},{name:"_operator",type:"address"}],name:"isApprovedForAll",outputs:[{name:"",type:"bool"}],payable:!1,stateMutability:"view",type:"function"},{anonymous:!1,inputs:[{indexed:!0,name:"_from",type:"address"},{indexed:!0,name:"_to",type:"address"},{indexed:!0,name:"_tokenId",type:"uint256"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"_owner",type:"address"},{indexed:!0,name:"_approved",type:"address"},{indexed:!0,name:"_tokenId",type:"uint256"}],name:"Approval",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"_owner",type:"address"},{indexed:!0,name:"_operator",type:"address"},{indexed:!1,name:"_approved",type:"bool"}],name:"ApprovalForAll",type:"event"}]}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC721.js"}]],[],{});