LavaPack.loadBundle([[1223,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[1224,{"./build/multichain-openrpc.json":1222,"./build/openrpc.json":1223},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.MultiChainOpenRPCDocument=n.MetaMaskOpenRPCDocument=void 0;const s=r(e("./build/openrpc.json"));n.MetaMaskOpenRPCDocument=s.default;const i=r(e("./build/multichain-openrpc.json"));n.MultiChainOpenRPCDocument=i.default,n.default=s.default}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js"}],[1225,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={"0x12652C6d93FDB6F4f37d48A8687783C782BB0d10":{name:"Entangle",logo:"NGL.svg",erc20:!0,symbol:"NGL",decimals:18},"0xB50721BCf8d664c30412Cfbc6cf7a15145234ad1":{name:"Arbitrum",logo:"Arb.svg",erc20:!0,symbol:"ARB",decimals:18},"0x4D0528598F916Fd1D8dc80e5f54a8fEEDcFd4b18":{name:"Atoshi",logo:"ATOS.svg",erc20:!0,symbol:"ATOS",decimals:18},"0x57B946008913B82E4dF85f501cbAeD910e58D26C":{name:"POND",logo:"POND.svg",erc20:!0,symbol:"POND",decimals:18},"0x5eed99d066a8CaF10f3E4327c1b3D8b673485eED":{name:"SEED",logo:"SEED.svg",erc20:!0,symbol:"SEED",decimals:18},"0x487d62468282Bd04ddf976631C23128A425555EE":{name:"UPCX",logo:"UPC.svg",erc20:!0,symbol:"UPC",decimals:5},"0xd3210F246Ae54C5a45A7b4A83315bf718F591bfc":{name:"ArkiTech",logo:"ARKI.svg",erc20:!0,symbol:"ARKI",decimals:9},"0x7d51888C5ABb7CDfa9cdd6A50673c7F8afAccD7F":{name:"DuckDAO Token",logo:"duckdao.svg",erc20:!0,symbol:"DD",decimals:18},"0x49642110B712C1FD7261Bc074105E9E44676c68F":{name:"DinoLFG",logo:"DINO.svg",erc20:!0,symbol:"DINO",decimals:18},"0xB8BAa0e4287890a5F79863aB62b7F175ceCbD433":{name:"Swerve DAO Token",logo:"swrv.svg",erc20:!0,symbol:"SWRV",decimals:18},"0x8b79656FC38a04044E495e22fAD747126ca305C4":{name:"AgaveCoin",logo:"agvc.svg",erc20:!0,symbol:"AGVC",decimals:18},"0x967da4048cD07aB37855c090aAF366e4ce1b9F48":{name:"Ocean Token",logo:"ocean.svg",erc20:!0,symbol:"OCEAN",decimals:18},"0x83e6f1E41cdd28eAcEB20Cb649155049Fac3D5Aa":{name:"PolkastarterToken",logo:"pols.svg",erc20:!0,symbol:"POLS",decimals:18},"0x08d967bb0134F2d07f7cfb6E246680c53927DD30":{name:"MATH Token",logo:"math.svg",erc20:!0,symbol:"MATH",decimals:18},"0xccC8cb5229B0ac8069C51fd58367Fd1e622aFD97":{name:"Gods Unchained",logo:"gods.svg",erc20:!0,symbol:"GODS",decimals:18},"0xF57e7e7C23978C3cAEC3C3548E3D615c346e79fF":{name:"Immutable X",logo:"imx.svg",erc20:!0,symbol:"IMX",decimals:18},"0x40D16FC0246aD3160Ccc09B8D0D3A2cD28aE6C2f":{name:"Gho Token",logo:"GHO.svg",erc20:!0,symbol:"GHO",decimals:18},"0x536381a8628dBcC8C70aC9A30A7258442eAb4c92":{name:"Pantos Token ",logo:"pan.svg",erc20:!0,symbol:"PAN",decimals:8},"0x011E128Ec62840186F4A07E85E3ACe28858c5606":{name:"Valeria",logo:"val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x6c3ea9036406852006290770BEdFcAbA0e23A0e8":{name:"PayPal USD",logo:"pyusd.svg",erc20:!0,symbol:"PYUSD",decimals:6},"0x8b385Ca3592A5EFc34E0C9fE663de56897F1751F":{name:"INFibit",logo:"INFibit.svg",erc20:!0,symbol:"IBIT",decimals:18},"0x9bf1D7D63dD7a4ce167CF4866388226EEefa702E":{name:"Ben Coin",logo:"BEN.svg",erc20:!0,symbol:"BEN",decimals:18},"0xC7a2572fA8FDB0f7E81d6D3c4e3CCF78FB0DC374":{name:"Bens Finale",logo:"BensFinale.svg",erc20:!0,symbol:"FINALE",decimals:18},"0x99cFB8cBA9c821B4a343c6a1Fc630465C9708DF5":{name:"Pepe Inu",logo:"PepeInu.svg",erc20:!0,symbol:"$PEPEINU",decimals:18},"0xCEBA2a8F6Ec221AEB5f3a7bcd15Cbc7e6a387bfb":{name:"Peter Pan",logo:"PeterPan.svg",erc20:!0,symbol:"PAN",decimals:18},"0x467719aD09025FcC6cF6F8311755809d45a5E5f3":{name:"Axelar",logo:"axelar.svg",erc20:!0,symbol:"AXL",decimals:6},"0x665F77fbA5975ab40Ce61c90F28007fb5b09D7B1":{name:"Genieswap",logo:"Genieswap.svg",erc20:!0,symbol:"GENIE",decimals:18},"0x09E6d500D14D13e0528d2c0fff24E5ffF68237B4":{name:"Dohrnii",logo:"dhn.svg",erc20:!0,symbol:"DHN",decimals:18},"0xaE0585a259A3BCAB258D6EE02FB583f7B33C2a12":{name:"TempleCoin",logo:"tem.svg",erc20:!0,symbol:"TEM",decimals:18},"0xaeDf386B755465871fF874E3E37Af5976E247064":{name:"Fasttoken",logo:"ftn.svg",erc20:!0,symbol:"FTN",decimals:18},"0x7BEF710a5759d197EC0Bf621c3Df802C2D60D848":{name:"SHOPX",logo:"SHOPX.svg",erc20:!0,symbol:"SHOPX",decimals:18},"0xBa3335588D9403515223F109EdC4eB7269a9Ab5D":{name:"Gearbox",logo:"gear.svg",erc20:!0,symbol:"GEAR",decimals:18},"0x9B6B9d2468E165a02FEf69E61B6D3D6CBC0Ac409":{name:"OASISLIFE",logo:"OFE.svg",erc20:!0,symbol:"OFE",decimals:18},"0xdf0162A6B3e9fDf0302c1e949739DeeaFafd8F89":{name:"METAOASIS",logo:"MOA.svg",erc20:!0,symbol:"MOA",decimals:18},"0xe4dae00bc1c46ea2F44ae71B1BEb8b171C15d812":{name:"PREMA",logo:"PREMA.svg",erc20:!0,symbol:"PRMX",decimals:18},"0x1416946162B1C2c871A73B07E932D2fB6C932069":{name:"Energi",logo:"energi.svg",erc20:!0,symbol:"NRG",decimals:18},"0x0d88eD6E74bbFD96B831231638b66C05571e824F":{name:"Aventus",logo:"aventus.svg",erc20:!0,symbol:"AVT",decimals:18},"0x4FC15c91a9c4A9efB404174464687E8e128730C2":{name:"STAT",logo:"STAT.svg",erc20:!0,erc721:!1,symbol:"STAT",decimals:18},"0x4ad7a056191F4c9519fAcd6D75FA94CA26003aCE":{name:"GoldPesa Option",logo:"GPO.svg",erc20:!0,symbol:"GPO",decimals:18},"0x767FE9EDC9E0dF98E07454847909b5E959D7ca0E":{name:"Illuvium",logo:"illuvium.svg",erc20:!0,erc721:!1,symbol:"ILV",decimals:18},"0x85F17Cf997934a597031b2E18a9aB6ebD4B9f6a4":{name:"NEAR",logo:"NEAR.svg",erc20:!0,symbol:"NEAR",decimals:24},"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2":{name:"SushiSwap",logo:"sushi.svg",erc20:!0,erc721:!1,symbol:"SUSHI",decimals:18},"0x881Ba05de1E78f549cC63a8f6Cabb1d4AD32250D":{name:"00",logo:"00.svg",erc20:!0,erc721:!1,symbol:"00",decimals:18},"0xC211477cb4098aC22a98432781f5f26a1E07a4d4":{name:"CULTURED",logo:"CULTURED.svg",erc20:!0,erc721:!1,symbol:"CULTURED",decimals:18},"0x86f2A193b116d1f9C53Ed26d97F77cDC8BcF4c2b":{name:"EHTAGA",logo:"EHTAGA.svg",erc20:!0,erc721:!1,symbol:"EHTAGA",decimals:18},"0x54b79A15b2e2c55c736A66bb0A978fb840407aC8":{name:"FEVER",logo:"FEVER.svg",erc20:!0,erc721:!1,symbol:"FEVER",decimals:18},"0x677c9fE4396D3D13A0F9013a8118eAE386C843A5":{name:"IAM",logo:"IAM.svg",erc20:!0,erc721:!1,symbol:"IAM",decimals:18},"0xf63c65E855020E4B74f0Ad842D9537dA0E6162eC":{name:"ISH",logo:"ISH.svg",erc20:!0,erc721:!1,symbol:"ISH",decimals:18},"0xc105fA46510F32c0444CCdB4e51065da95caA1B4":{name:"LITA",logo:"LITA.svg",erc20:!0,erc721:!1,symbol:"LITA",decimals:18},"0x5401F949cDfa3E5aF32538167c0314230769209C":{name:"MAHCOIN",logo:"MAHCOIN.svg",erc20:!0,erc721:!1,symbol:"MAHCOIN",decimals:18},"0x711D2C47aFf84B96AD0F36983b1c41Be2C509e18":{name:"NIKITA",logo:"NIKITA.svg",erc20:!0,erc721:!1,symbol:"NIKITA",decimals:18},"0x3C44aEc33993b6830e5C2a705ea879b9C9ba0f7c":{name:"NYELA",logo:"NYELA.svg",erc20:!0,erc721:!1,symbol:"NYELA",decimals:18},"0xfa9096c99e687ea8E0064C23DAaCFE87cc99E4Ba":{name:"RON",logo:"RON.svg",erc20:!0,erc721:!1,symbol:"RON",decimals:18},"0x287a7C95aD00bBDd48599Ad2919567fD09281f07":{name:"STEELO",logo:"STEELO.svg",erc20:!0,erc721:!1,symbol:"STEELO",decimals:18},"0x2Ec3275f7aCe4044e499823F511cd58250be8E3d":{name:"Privilege",logo:"prvg.svg",erc20:!0,symbol:"PRVG",decimals:8},"0x65BB569FAaDD324a00883FdE4c46346cc96D5c0A":{name:"Provide",logo:"prvd.svg",erc20:!0,symbol:"PRVD",decimals:8},"0xB4272071eCAdd69d933AdcD19cA99fe80664fc08":{name:"CryptoFranc",logo:"XCHF.svg",erc20:!0,symbol:"XCHF",decimals:18},"0x5aFE3855358E112B5647B952709E6165e1c1eEEe":{name:"Safe Token",logo:"safe-green-token.svg",erc20:!0,symbol:"SAFE",decimals:18},"0x9C8fF314C9Bc7F6e59A9d9225Fb22946427eDC03":{name:"Nouns",erc20:!1,erc721:!0,symbol:"NOUN",decimals:0,logo:"nouns.svg"},"0xBC4CA0EdA7647A8aB7C2061c2E118A18a936f13D":{name:"BoredApeYachtClub",erc20:!1,erc721:!0,symbol:"BAYC",decimals:0,logo:"bayc.svg"},"0x08D7C0242953446436F34b4C78Fe9da38c73668d":{name:"PROOF Collective",erc20:!1,erc721:!0,symbol:"PROOF",decimals:0,logo:"proof.svg"},"0x23581767a106ae21c074b2276D25e5C3e136a68b":{name:"Moonbirds",erc20:!1,erc721:!0,symbol:"MOONBIRD",decimals:0,logo:"moonbirds.svg"},"0x60E4d786628Fea6478F785A6d7e704777c86a7c6":{name:"MutantApeYachtClub",erc20:!1,erc721:!0,symbol:"MAYC",decimals:0,logo:"mayc.svg"},"0x49cF6f5d44E70224e2E23fDcdd2C053F30aDA28B":{name:"CloneX",erc20:!1,erc721:!0,symbol:"CloneX",decimals:0,logo:"clonex.svg"},"0x8a90CAb2b38dba80c64b7734e58Ee1dB38B8992e":{name:"Doodles",erc20:!1,erc721:!0,symbol:"DOODLE",decimals:0,logo:"doodles.svg"},"0xED5AF388653567Af2F388E6224dC7C4b3241C544":{name:"Azuki",erc20:!1,erc721:!0,symbol:"AZUKI",decimals:0,logo:"azuki.svg"},"0xa3AEe8BcE55BEeA1951EF834b99f3Ac60d1ABeeB":{name:"VeeFriends",erc20:!1,erc721:!0,symbol:"VFT",decimals:0,logo:"veefriends.svg"},"0x34d85c9CDeB23FA97cb08333b511ac86E1C4E258":{name:"Otherdeed",erc20:!1,erc721:!0,symbol:"OTHR",decimals:0,logo:"otherdeed.svg"},"0xBBc2AE13b23d715c30720F079fcd9B4a74093505":{name:"Ethernity Chain Token",logo:"ERN.svg",erc20:!0,symbol:"ERN",decimals:18},"0x243cACb4D5fF6814AD668C3e225246efA886AD5a":{name:"Shina Inu",logo:"shina.svg",erc20:!0,symbol:"SHI",decimals:18},"0xD057B63f5E69CF1B929b356b579Cba08D7688048":{name:"CoW Protocol Virtual Token",logo:"vCOW.svg",erc20:!0,symbol:"vCOW",decimals:18},"0xDEf1CA1fb7FBcDC777520aa7f396b4E015F497aB":{name:"CoW Protocol Token",logo:"COW.svg",erc20:!0,symbol:"COW",decimals:18},"0xEd04915c23f00A313a544955524EB7DBD823143d":{name:"Alchemy Pay",logo:"ACH.svg",erc20:!0,symbol:"ACH",decimals:8},"0xeDF6568618A00C6F0908Bf7758A16F76B6E04aF9":{name:"Arianee",logo:"aria20.svg",erc20:!0,symbol:"ARIA20",decimals:18},"0x88D8DA2A8D0fA5b1f4E38030AC486aDE0AFA2798":{name:"Terrapass Coin",logo:"tpsc.svg",erc20:!0,symbol:"TPSC",decimals:18},"0x4730fB1463A6F1F44AEB45F6c5c422427f37F4D0":{name:"The 4th Pillar Token",logo:"four.svg",erc20:!0,symbol:"FOUR",decimals:18},"0x875773784Af8135eA0ef43b5a374AaD105c5D39e":{name:"Idle DAO Token",logo:"idle.svg",erc20:!0,symbol:"IDLE",decimals:18},"0x6BeA7CFEF803D1e3d5f7C0103f7ded065644e197":{name:"Gamma",logo:"Gamma.svg",erc20:!0,symbol:"GAMMA",decimals:18},"0x26805021988F1a45dC708B5FB75Fc75F21747D8c":{name:"xGamma",logo:"xGamma.svg",erc20:!0,symbol:"xGAMMA",decimals:18},"0xc7D9c108D4E1dD1484D3e2568d7f74bfD763d356":{name:"SORA Synthetic USD",logo:"sora-xstusd.svg",erc20:!0,symbol:"XSTUSD",decimals:18},"0x519C1001D550C0a1DaE7d1fC220f7d14c2A521BB":{name:"Polkaswap",logo:"sora-pswap.svg",erc20:!0,symbol:"PSWAP",decimals:18},"0x40FD72257597aA14C7231A7B1aaa29Fce868F677":{name:"SORA",logo:"sora-xor.svg",erc20:!0,symbol:"XOR",decimals:18},"0x909E34d3f6124C324ac83DccA84b74398a6fa173":{name:"$ZKP Token",logo:"ZKP.svg",erc20:!0,erc721:!1,symbol:"$ZKP",decimals:18},"0xe88f8313e61A97cEc1871EE37fBbe2a8bf3ed1E4":{name:"SORA Validator",logo:"sora-val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x7A58c0Be72BE218B41C608b7Fe7C5bB630736C71":{name:"ConstitutionDAO",logo:"PEOPLE.svg",erc20:!0,symbol:"PEOPLE",decimals:18},"0x32E6C34Cd57087aBBD59B5A4AECC4cB495924356":{name:"BitBase",logo:"BTBS.svg",erc20:!0,symbol:"BTBS",decimals:18},"0x3fa400483487A489EC9b1dB29C4129063EEC4654":{name:"Cryptokek.com",logo:"cryptokek.svg",erc20:!0,symbol:"KEK",decimals:18},"0xEd3D4e446A96dC3b181B64B75c3c70dA41dC3CBe":{name:"Vodra",logo:"Vodra.svg",erc20:!0,symbol:"VDR",decimals:18},"0xb753428af26E81097e7fD17f40c88aaA3E04902c":{name:"Spice",logo:"sfi.svg",erc20:!0,symbol:"SFI",decimals:18},"0xd084944d3c05CD115C09d072B9F44bA3E0E45921":{name:"Manifold Finance",logo:"Manifold.svg",erc20:!0,symbol:"FOLD",decimals:18},"0x9a0242b7a33DAcbe40eDb927834F96eB39f8fBCB":{name:"BABB",logo:"bax.svg",erc20:!0,symbol:"BAX",decimals:18},"0x4Cf89ca06ad997bC732Dc876ed2A7F26a9E7f361":{name:"Mysterium",logo:"MYST.svg",erc20:!0,symbol:"MYST",decimals:18},"0x697eF32B4a3F5a4C39dE1cB7563f24CA7BfC5947":{name:"Insula Token",logo:"Insula.svg",erc20:!0,symbol:"ISLA",decimals:18},"0x62Dc4817588d53a056cBbD18231d91ffCcd34b2A":{name:"DeHive",logo:"dehive.svg",erc20:!0,erc721:!1,symbol:"DHV",decimals:18},"0x8400D94A5cb0fa0D041a3788e395285d61c9ee5e":{name:"Unibright",logo:"ubt.svg",erc20:!0,symbol:"UBT",decimals:8},"0xfAd45E47083e4607302aa43c65fB3106F1cd7607":{name:"Hoge Finance",logo:"HogeFinanceLogo.svg",erc20:!0,symbol:"HOGE",decimals:9},"0xBB0E17EF65F82Ab018d8EDd776e8DD940327B28b":{name:"Axie Infinity Shard",logo:"AXS.svg",erc20:!0,symbol:"AXS",decimals:18},"0xCC8Fa225D80b9c7D42F96e9570156c65D6cAAa25":{name:"Smooth Love Potion",logo:"SLP.svg",erc20:!0,symbol:"SLP",decimals:0},"0x10633216E7E8281e33c86F02Bf8e565a635D9770":{name:"Dvision Network",logo:"dvision.svg",erc20:!0,symbol:"DVI",decimals:18},"0x898BAD2774EB97cF6b94605677F43b41871410B1":{name:"vEth2",logo:"vEth2.svg",erc20:!0,symbol:"vEth2",decimals:18},"0x321C2fE4446C7c963dc41Dd58879AF648838f98D":{name:"Cryptex Finance",logo:"ctx.svg",erc20:!0,symbol:"CTX",decimals:18},"0x16c52CeeCE2ed57dAd87319D91B5e3637d50aFa4":{name:"TCAP Token",logo:"tcap.svg",erc20:!0,symbol:"TCAP",decimals:18},"0xE94B97b6b43639E238c851A7e693F50033EfD75C":{name:"Rainbow Token",logo:"halodao-rnbw.svg",erc20:!0,symbol:"RNBW",decimals:18},"0x47BE779De87de6580d0548cde80710a93c502405":{name:"Rainbow Pool",logo:"halodao-xrnbw.svg",erc20:!0,symbol:"xRNBW",decimals:18},"0xe7aE6D0C56CACaf007b7e4d312f9af686a9E9a04":{name:"Vabble",logo:"VAB.svg",erc20:!0,symbol:"VAB",decimals:18},"0x853d955aCEf822Db058eb8505911ED77F175b99e":{name:"Frax",logo:"frax.svg",erc20:!0,symbol:"FRAX",decimals:18},"0x3432B6A60D23Ca0dFCa7761B7ab56459D9C964D0":{name:"Frax Share",logo:"fxs.svg",erc20:!0,symbol:"FXS",decimals:18},"0x84810bcF08744d5862B8181f12d17bfd57d3b078":{name:"SharedStake",logo:"sharedstake.svg",erc20:!0,symbol:"SGT",decimals:18},"0x75387e1287Dd85482aB66102DA9f6577E027f609":{name:"MindsyncAI",logo:"MAI.svg",erc20:!0,symbol:"MAI",decimals:18},"0x196f4727526eA7FB1e17b2071B3d8eAA38486988":{name:"Reserve",logo:"rsv.svg",erc20:!0,symbol:"RSV",decimals:18},"0x320623b8E4fF03373931769A31Fc52A4E78B5d70":{name:"Reserve Rights",logo:"rsr.svg",erc20:!0,symbol:"RSR",decimals:18},"0x1cF4592ebfFd730c7dc92c1bdFFDfc3B9EfCf29a":{name:"WAVES",logo:"waves.svg",erc20:!0,symbol:"WAVES",decimals:18},"0x252739487C1fa66eaeaE7CED41d6358aB2a6bCa9":{name:"ArCoin",logo:"ArCoin.svg",erc20:!0,symbol:"RCOIN",decimals:8},"0x18aAA7115705e8be94bfFEBDE57Af9BFc265B998":{name:"Audius",logo:"audius.svg",erc20:!0,symbol:"AUDIO",decimals:18},"0x8E3BCC334657560253B83f08331d85267316e08a":{name:"Rubic",logo:"brbc.svg",erc20:!0,symbol:"BRBC",decimals:18},"0xca1207647Ff814039530D7d35df0e1Dd2e91Fa84":{name:"dHEDGE DAO Token",logo:"DHT.svg",erc20:!0,symbol:"DHT",decimals:18},"0x6243d8CEA23066d098a15582d81a598b4e8391F4":{name:"Reflexer Ungovernance Token",logo:"flx.svg",erc20:!0,symbol:"FLX",decimals:18},"0x03ab458634910AaD20eF5f1C8ee96F1D6ac54919":{name:"Rai Reflex Index",logo:"rai.svg",erc20:!0,symbol:"RAI",decimals:18},"0xF25c91C87e0B1fd9B4064Af0F427157AaB0193A7":{name:"BASIC Token",logo:"basic.svg",erc20:!0,symbol:"BASIC",decimals:18},"0x53C8395465A84955c95159814461466053DedEDE":{name:"DeGate Token",logo:"DG.svg",erc20:!0,symbol:"DG",decimals:18},"0xBCf9dBf8B14eD096B2BA08b7269356197fDd1b5D":{name:"Avaluse",logo:"avaluse.svg",erc20:!0,symbol:"AVAL",decimals:18},"0x6E765D26388A17A6e86c49A8E41DF3F58aBcd337":{name:"Kangal",logo:"kangal.svg",erc20:!0,symbol:"KANGAL",decimals:18},"0x9AF4f26941677C706cfEcf6D3379FF01bB85D5Ab":{name:"DomRaiderToken",logo:"drt.svg",erc20:!0,symbol:"DRT",decimals:8},"0x06B179e292f080871825beD5D722162fD96B4c95":{name:"10x.gg",logo:"xgg.svg",erc20:!0,symbol:"XGG",decimals:18},"0xF29992D7b589A0A6bD2de7Be29a97A6EB73EaF85":{name:"DMScript",logo:"dmst.svg",erc20:!0,symbol:"DMST",decimals:18},"0x64aa3364F17a4D01c6f1751Fd97C2BD3D7e7f1D5":{name:"Olympus",logo:"OHM.svg",erc20:!0,symbol:"OHM",decimals:9},"0x0ab87046fBb341D058F17CBC4c1133F25a20a52f":{name:"Governance OHM",logo:"gOHM.svg",erc20:!0,symbol:"gOHM",decimals:18},"0xDd1Ad9A21Ce722C151A836373baBe42c868cE9a4":{name:"Universal Basic Income",logo:"ubi.svg",erc20:!0,symbol:"UBI",decimals:18},"0xf293d23BF2CDc05411Ca0edDD588eb1977e8dcd4":{name:"Sylo",logo:"SYLO.svg",erc20:!0,symbol:"SYLO",decimals:18},"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84":{name:"Liquid staked Ether 2.0",logo:"stETH.svg",erc20:!0,symbol:"stETH",decimals:18},"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0":{name:"Wrapped liquid staked Ether 2.0",logo:"wstETH.svg",erc20:!0,symbol:"wstETH",decimals:18},"0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32":{name:"Lido DAO Token",logo:"LDO.svg",erc20:!0,symbol:"LDO",decimals:18},"0xbd31EA8212119f94A611FA969881CBa3EA06Fa3d":{name:"LUNA Token",logo:"Luna.svg",erc20:!0,symbol:"LUNA",decimals:6},"0xa693B19d2931d498c5B318dF961919BB4aee87a5":{name:"UST Token",logo:"UST.svg",erc20:!0,symbol:"UST",decimals:6},"0xd2877702675e6cEb975b4A1dFf9fb7BAF4C91ea9":{name:"LUNA Token - Shuttle",logo:"lunc.svg",erc20:!0,symbol:"LUNC",decimals:18},"0xa47c8bf37f92aBed4A126BDA807A7b7498661acD":{name:"UST Token - Shuttle",logo:"ustc.svg",erc20:!0,symbol:"USTC",decimals:18},"0xcAAfF72A8CbBfc5Cf343BA4e26f65a257065bFF1":{name:"KRT Token - Shuttle",logo:"KRT.svg",erc20:!0,symbol:"KRT-S",decimals:18},"0x676Ad1b33ae6423c6618C1AEcf53BAa29cf39EE5":{name:"SDT Token - Shuttle",logo:"SDT.svg",erc20:!0,symbol:"SDT-S",decimals:18},"0x156B36ec68FdBF84a925230BA96cb1Ca4c4bdE45":{name:"MNT Token - Shuttle",logo:"MNT.svg",erc20:!0,symbol:"MNT-S",decimals:18},"0x09a3EcAFa817268f77BE1283176B946C4ff2E608":{name:"MIR Token - Shuttle",logo:"MIR.svg",erc20:!0,symbol:"MIR-S",decimals:18},"0xd36932143F6eBDEDD872D5Fb0651f4B72Fd15a84":{name:"Mirror AAPL Token - Shuttle",logo:"mAAPL.svg",erc20:!0,symbol:"mAAPL-S",decimals:18},"0x59A921Db27Dd6d4d974745B7FfC5c33932653442":{name:"Mirror GOOGL Token - Shuttle",logo:"mGOOGL.svg",erc20:!0,symbol:"mGOGL-S",decimals:18},"0x21cA39943E91d704678F5D00b6616650F066fD63":{name:"Mirror TSLA Token - Shuttle",logo:"mTSLA.svg",erc20:!0,symbol:"mTSLA-S",decimals:18},"0xC8d674114bac90148d11D3C1d33C61835a0F9DCD":{name:"Mirror NFLX Token - Shuttle",logo:"mNFLX.svg",erc20:!0,symbol:"mNFLX-S",decimals:18},"0x13B02c8dE71680e71F0820c996E4bE43c2F57d15":{name:"Mirror QQQ Token - Shuttle",logo:"mQQQ.svg",erc20:!0,symbol:"mQQQ-S",decimals:18},"0xEdb0414627E6f1e3F082DE65cD4F9C693D78CCA9":{name:"Mirror TWTR Token - Shuttle",logo:"mTWTR.svg",erc20:!0,symbol:"mTWTR-S",decimals:18},"0x41BbEDd7286dAab5910a1f15d12CBda839852BD7":{name:"Mirror MSFT Token - Shuttle",logo:"mMSFT.svg",erc20:!0,symbol:"mMSFT-S",decimals:18},"0x0cae9e4d663793c2a2A0b211c1Cf4bBca2B9cAa7":{name:"Mirror AMZN Token - Shuttle",logo:"mAMZN.svg",erc20:!0,symbol:"mAMZN-S",decimals:18},"0x56aA298a19C93c6801FDde870fA63EF75Cc0aF72":{name:"Mirror BABA Token - Shuttle",logo:"mBABA.svg",erc20:!0,symbol:"mBABA-S",decimals:18},"0x1d350417d9787E000cc1b95d70E9536DcD91F373":{name:"Mirror IAU Token - Shuttle",logo:"mIAU.svg",erc20:!0,symbol:"mIAU-S",decimals:18},"0x9d1555d8cB3C846Bb4f7D5B1B1080872c3166676":{name:"Mirror SLV Token - Shuttle",logo:"mSLV.svg",erc20:!0,symbol:"mSLV-S",decimals:18},"0x31c63146a635EB7465e5853020b39713AC356991":{name:"Mirror USO Token - Shuttle",logo:"mUSO.svg",erc20:!0,symbol:"mUSO-S",decimals:18},"0xf72FCd9DCF0190923Fadd44811E240Ef4533fc86":{name:"Mirror VIXY Token - Shuttle",logo:"mVIXY.svg",erc20:!0,symbol:"mVIXY-S",decimals:18},"0x21BfBDa47A0B4B5b1248c767Ee49F7caA9B23697":{name:"OVR",logo:"OVR.svg",erc20:!0,symbol:"OVR",decimals:18},"0x4691937a7508860F876c9c0a2a617E7d9E945D4B":{name:"Wootrade Network",logo:"wootrade.svg",erc20:!0,symbol:"WOO",decimals:18},"0xaf9f549774ecEDbD0966C52f250aCc548D3F36E5":{name:"RFUEL",logo:"RFUEL.svg",erc20:!0,symbol:"RFUEL",decimals:18},"0x7420B4b9a0110cdC71fB720908340C03F9Bc03EC":{name:"JasmyCoin",logo:"JASMY.svg",erc20:!0,symbol:"JASMY",decimals:18},"0x947AEb02304391f8fbE5B25D7D98D649b57b1788":{name:"Mandala Exchange Token",logo:"mandala.svg",erc20:!0,symbol:"MDX",decimals:18},"0xCdeee767beD58c5325f68500115d4B722b3724EE":{name:"Carbon",logo:"CRBN.svg",erc20:!0,symbol:"CRBN",decimals:18},"0xA4EED63db85311E22dF4473f87CcfC3DaDCFA3E3":{name:"Rubic",logo:"Rubic.svg",erc20:!0,symbol:"RBC",decimals:18},"0x3A880652F47bFaa771908C07Dd8673A787dAEd3A":{name:"DerivaDAO",logo:"DDX.svg",erc20:!0,symbol:"DDX",decimals:18},"0xbC396689893D065F41bc2C6EcbeE5e0085233447":{name:"Perpetual",logo:"PERP.svg",erc20:!0,symbol:"PERP",decimals:18},"0xeca82185adCE47f39c684352B0439f030f860318":{name:"Perlin",logo:"PERL.svg",erc20:!0,symbol:"PERL",decimals:18},"0xA1AFFfE3F4D611d252010E3EAf6f4D77088b0cd7":{name:"Reflect Finance",logo:"RFI.svg",erc20:!0,symbol:"RFI",decimals:9},"0xC0bA369c8Db6eB3924965e5c4FD0b4C1B91e305F":{name:"DLP Duck Token",logo:"dlpducktoken.svg",erc20:!0,symbol:"DUCK",decimals:18},"0xFbEEa1C75E4c4465CB2FCCc9c6d6afe984558E20":{name:"DuckDaoDime",logo:"ddim.svg",erc20:!0,symbol:"DDIM",decimals:18},"0x745407c86DF8DB893011912d3aB28e68B62E49B0":{name:"MahaDAO",logo:"MAHA.svg",erc20:!0,symbol:"MAHA",decimals:18},"0x8CC0F052fff7eaD7f2EdCCcaC895502E884a8a71":{name:"ARTH Valuecoin",logo:"ARTH.svg",erc20:!0,symbol:"ARTH",decimals:18},"0x3231Cb76718CDeF2155FC47b5286d82e6eDA273f":{name:"Monerium EUR",logo:"EURe.svg",erc20:!0,symbol:"EURe",decimals:18},"0x7ba92741Bf2A568abC6f1D3413c58c6e0244F8fD":{name:"Monerium GBP",logo:"GBPe.svg",erc20:!0,symbol:"GBPe",decimals:18},"0xBc5142e0CC5eB16b47c63B0f033d4c2480853a52":{name:"Monerium USD",logo:"USDe.svg",erc20:!0,symbol:"USDe",decimals:18},"0xC642549743A93674cf38D6431f75d6443F88E3E2":{name:"Monerium ISK",logo:"ISKe.svg",erc20:!0,symbol:"ISKe",decimals:18},"0x66a0f676479Cee1d7373f3DC2e2952778BfF5bd6":{name:"WISE Token",logo:"wise.svg",erc20:!0,symbol:"WISE",decimals:18},"0x72F020f8f3E8fd9382705723Cd26380f8D0c66Bb":{name:"PlotX",logo:"plotx.svg",erc20:!0,symbol:"PLOT",decimals:18},"0x44197A4c44D6A059297cAf6be4F7e172BD56Caaf":{name:"ELTCOIN",logo:"ELTCOIN.svg",erc20:!0,symbol:"ELT",decimals:8},"0x6781a0F84c7E9e846DCb84A9a5bd49333067b104":{name:"ZAP TOKEN",logo:"zapicon.svg",erc20:!0,symbol:"ZAP",decimals:18},"0x00c83aeCC790e8a4453e5dD3B0B4b3680501a7A7":{name:"SKALE",logo:"skl.svg",erc20:!0,symbol:"SKL",decimals:18},"0x674C6Ad92Fd080e4004b2312b45f796a192D27a0":{name:"Neutrino USD",logo:"usdn.svg",erc20:!0,symbol:"USDN",decimals:18},"0xE5CAeF4Af8780E59Df925470b050Fb23C43CA68C":{name:"Ferrum Network Token",logo:"frm.svg",erc20:!0,symbol:"FRM",decimals:6},"0x998FFE1E43fAcffb941dc337dD0468d52bA5b48A":{name:"Rupiah Token",logo:"idrt.svg",erc20:!0,symbol:"IDRT",decimals:2},"0x4E15361FD6b4BB609Fa63C81A2be19d873717870":{name:"Fantom",logo:"ftm.svg",erc20:!0,symbol:"FTM",decimals:18},"0x557B933a7C2c45672B610F8954A3deB39a51A8Ca":{name:"REVV",logo:"revv.svg",erc20:!0,symbol:"REVV",decimals:18},"0xFFC97d72E13E01096502Cb8Eb52dEe56f74DAD7B":{name:"Aave AAVE",logo:"aAAVE.svg",erc20:!0,symbol:"aAAVE",decimals:18},"0x05Ec93c0365baAeAbF7AefFb0972ea7ECdD39CF1":{name:"Aave BAT",logo:"aBAT.svg",erc20:!0,symbol:"aBAT",decimals:18},"0xA361718326c15715591c299427c62086F69923D9":{name:"Aave BUSD",logo:"aBUSD.svg",erc20:!0,symbol:"aBUSD",decimals:18},"0x028171bCA77440897B824Ca71D1c56caC55b68A3":{name:"Aave DAI",logo:"aDAI.svg",erc20:!0,symbol:"aDAI",decimals:18},"0xaC6Df26a590F08dcC95D5a4705ae8abbc88509Ef":{name:"Aave ENJ",logo:"aENJ.svg",erc20:!0,symbol:"aENJ",decimals:18},"0xD37EE7e4f452C6638c96536e68090De8cBcdb583":{name:"Aave GUSD",logo:"aGUSD.svg",erc20:!0,symbol:"aGUSD",decimals:2},"0x39C6b3e42d6A679d7D776778Fe880BC9487C2EDA":{name:"Aave KNC",logo:"aKNC.svg",erc20:!0,symbol:"aKNC",decimals:18},"0xa06bC25B5805d5F8d82847D191Cb4Af5A3e873E0":{name:"Aave LINK",logo:"aLINK.svg",erc20:!0,symbol:"aLINK",decimals:18},"0xa685a61171bb30d4072B338c80Cb7b2c865c873E":{name:"Aave MANA",logo:"aMANA.svg",erc20:!0,symbol:"aMANA",decimals:18},"0xc713e5E149D5D0715DcD1c156a020976e7E56B88":{name:"Aave MKR",logo:"aMKR.svg",erc20:!0,symbol:"aMKR",decimals:18},"0xCC12AbE4ff81c9378D670De1b57F8e0Dd228D77a":{name:"Aave REN",logo:"aREN.svg",erc20:!0,symbol:"aREN",decimals:18},"0x35f6B052C598d933D69A4EEC4D04c73A191fE6c2":{name:"Aave SNX",logo:"aSNX.svg",erc20:!0,symbol:"aSNX",decimals:18},"0x6C5024Cd4F8A59110119C56f8933403A539555EB":{name:"Aave SUSD",logo:"aSUSD.svg",erc20:!0,symbol:"aSUSD",decimals:18},"0x101cc05f4A51C0319f570d5E146a8C625198e636":{name:"Aave TUSD",logo:"aTUSD.svg",erc20:!0,symbol:"aTUSD",decimals:18},"0xB9D7CB55f463405CDfBe4E90a6D2Df01C2B92BF1":{name:"Aave UNI",logo:"aUNI.svg",erc20:!0,symbol:"aUNI",decimals:18},"0xBcca60bB61934080951369a648Fb03DF4F96263C":{name:"Aave USDC",logo:"aUSDC.svg",erc20:!0,symbol:"aUSDC",decimals:6},"0x3Ed3B47Dd13EC9a98b44e6204A523E766B225811":{name:"Aave USDT",logo:"aUSDT.svg",erc20:!0,symbol:"aUSDT",decimals:6},"0x9ff58f4fFB29fA2266Ab25e75e2A8b3503311656":{name:"Aave WBTC",logo:"aWBTC.svg",erc20:!0,symbol:"aWBTC",decimals:8},"0x030bA81f1c18d280636F32af80b9AAd02Cf0854e":{name:"Aave WETH",logo:"aWETH.svg",erc20:!0,symbol:"aWETH",decimals:18},"0x5165d24277cD063F5ac44Efd447B27025e888f37":{name:"Aave YFI",logo:"aYFI.svg",erc20:!0,symbol:"aYFI",decimals:18},"0xdef1fac7Bf08f173D286BbBDcBeeADe695129840":{name:"Defi Factory Token",logo:"DEFT.svg",erc20:!0,symbol:"DEFT",decimals:18},"0xDf7FF54aAcAcbFf42dfe29DD6144A69b629f8C9e":{name:"Aave ZRX",logo:"aZRX.svg",erc20:!0,symbol:"aZRX",decimals:18},"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9":{name:"Aave",logo:"AAVE.svg",erc20:!0,symbol:"AAVE",decimals:18},"0x44e2deC86B9F0e0266E9AA66e10323A2bd69CF9A":{name:"Attrace",logo:"attr.svg",erc20:!0,symbol:"ATTR",decimals:18},"0x1Da87b114f35E1DC91F72bF57fc07A768Ad40Bb0":{name:"Equalizer",logo:"EQZ.svg",erc20:!0,symbol:"EQZ",decimals:18},"0x4da27a545c0c5B758a6BA100e3a049001de870f5":{name:"Staked Aave",logo:"stkAAVE.svg",erc20:!0,symbol:"stAAVE",decimals:18},"0xba9d4199faB4f26eFE3551D490E3821486f135Ba":{name:"SwissBorg",logo:"chsb.svg",erc20:!0,symbol:"CHSB",decimals:8},"0x7DD9c5Cba05E151C895FDe1CF355C9A1D5DA6429":{name:"Golem Network Token",logo:"glm.svg",erc20:!0,symbol:"GLM",decimals:18},"0x7240aC91f01233BaAf8b064248E80feaA5912BA3":{name:"OctoFi",logo:"octo.svg",erc20:!0,symbol:"OCTO",decimals:18},"0xff56Cc6b1E6dEd347aA0B7676C85AB0B3D08B0FA":{name:"Orbs",logo:"orbs.svg",erc20:!0,symbol:"ORBS",decimals:18},"0x63f88A2298a5c4AEE3c216Aa6D926B184a4b2437":{name:"GAME Credits",logo:"GAMECreditsLogo.svg",erc20:!0,symbol:"GAME",decimals:18},"0x5150956E082C748Ca837a5dFa0a7C10CA4697f9c":{name:"Zeedex",logo:"zdex.svg",erc20:!0,symbol:"ZDEX",decimals:18},"0x84cA8bc7997272c7CfB4D0Cd3D55cd942B3c9419":{name:"DIAdata",logo:"dia.svg",erc20:!0,symbol:"DIA",decimals:18},"0xb78B3320493a4EFaa1028130C5Ba26f0B6085Ef8":{name:"Dracula",logo:"dracula.svg",erc20:!0,symbol:"DRC",decimals:18},"0xF433089366899D83a9f26A773D59ec7eCF30355e":{name:"Metal",logo:"mtl.svg",erc20:!0,symbol:"MTL",decimals:8},"0x85Eee30c52B0b379b046Fb0F85F4f3Dc3009aFEC":{name:"KEEP",logo:"keep.svg",erc20:!0,symbol:"KEEP",decimals:18},"0x8dAEBADE922dF735c38C80C7eBD708Af50815fAa":{name:"tBTC",logo:"tbtc.svg",erc20:!0,symbol:"TBTC",decimals:18},"0xD7EFB00d12C2c13131FD319336Fdf952525dA2af":{name:"Proton",logo:"proton.svg",erc20:!0,symbol:"XPR",decimals:4},"0x178c820f862B14f316509ec36b13123DA19A6054":{name:"Energy Web Token Bridged",logo:"ewtb.svg",erc20:!0,symbol:"EWTB",decimals:18},"0x2b591e99afE9f32eAA6214f7B7629768c40Eeb39":{name:"HEX",logo:"hex.svg",erc20:!0,symbol:"HEX",decimals:8},"0xFca59Cd816aB1eaD66534D82bc21E7515cE441CF":{name:"Rarible",logo:"rari.svg",erc20:!0,symbol:"RARI",decimals:18},"0x7865af71cf0b288b4E7F654f4F7851EB46a2B7F8":{name:"Sentivate",logo:"sentivate.svg",erc20:!0,symbol:"SNTVT",decimals:18},"0xa3d58c4E56fedCae3a7c43A725aeE9A71F0ece4e":{name:"Metronome",logo:"metronome.svg",erc20:!0,symbol:"MET",decimals:18},"0x49d716DFe60b37379010A75329ae09428f17118d":{name:"PoolTogether Dai",logo:"pldai.svg",erc20:!0,symbol:"PLDAI",decimals:18},"0xfE6892654CBB05eB73d28DCc1Ff938f59666Fe9f":{name:"PoolTogether Sai",logo:"plsai.svg",erc20:!0,symbol:"PLSAI",decimals:18},"0x5732046A883704404F284Ce41FfADd5b007FD668":{name:"Bluzelle Token",logo:"Bluzelle.svg",erc20:!0,symbol:"BLZ",decimals:18},"0xBD87447F48ad729C5c4b8bcb503e1395F62e8B98":{name:"PoolTogether USDC",logo:"plusdc.svg",erc20:!0,symbol:"PLUSDC",decimals:6},"0x69A95185ee2a045CDC4bCd1b1Df10710395e4e23":{name:"$Poolz Finance",logo:"Poolz.svg",erc20:!0,symbol:"POOLZ",decimals:18},"0x0adA190c81b814548ddC2F6AdC4a689ce7C1FE73":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAXIS",decimals:18},"0xb1dC9124c395c1e97773ab855d66E879f053A289":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAX",decimals:18},"0xeF31Cb88048416E301Fee1eA13e7664b887BA7e8":{name:"Staked yAxis",logo:"yaxis.svg",erc20:!0,symbol:"sYAX",decimals:18},"0x28cb7e841ee97947a86B06fA4090C8451f64c0be":{name:"YF Link",logo:"YFL.svg",erc20:!0,symbol:"YFL",decimals:18},"0x75D1aA733920b14fC74c9F6e6faB7ac1EcE8482E":{name:"YFLink Staking Share",logo:"YFL.svg",erc20:!0,symbol:"yYFL",decimals:18},"0x7b760D06E401f85545F3B50c44bf5B05308b7b62":{name:"YFLink USD",logo:"YFLUSD.svg",erc20:!0,symbol:"YFLUSD",decimals:18},"0x8282df223AC402d04B2097d16f758Af4F70e7Db0":{name:"YFLink Synthetic",logo:"sYFL.svg",erc20:!0,symbol:"sYFL",decimals:18},"0x008377EB0C62cE8e0BA3D7Bb4A5638591f21588E":{name:"YFLink Bond",logo:"bYFL.svg",erc20:!0,symbol:"bYFL",decimals:18},"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e":{name:"yearn.finance",logo:"yfi.svg",erc20:!0,symbol:"YFI",decimals:18},"0x261b45D85cCFeAbb11F022eBa346ee8D1cd488c0":{name:"rDAI",logo:"rdai.svg",erc20:!0,symbol:"rDAI",decimals:18},"0xea8b224eDD3e342DEb514C4176c2E72Bcce6fFF9":{name:"rSAI",logo:"rsai.svg",erc20:!0,symbol:"rSAI",decimals:18},"0x12B19D3e2ccc14Da04FAe33e63652ce469b3F2FD":{name:"GridPlus",logo:"GridPlus.svg",erc20:!0,symbol:"GRID",decimals:12},"0xDb05EA0877A2622883941b939f0bb11d1ac7c400":{name:"Opacity",logo:"opct.svg",erc20:!0,symbol:"OPCT",decimals:18},"0x4575f41308EC1483f3d399aa9a2826d74Da13Deb":{name:"Orchid",logo:"OXT.svg",erc20:!0,symbol:"OXT",decimals:18},"0x4CC19356f2D37338b9802aa8E8fc58B0373296E7":{name:"Selfkey",logo:"KEY.svg",erc20:!0,symbol:"KEY",decimals:18},"0x92A5B04D0ED5D94D7a193d1d334D3D16996f4E13":{name:"Eristica",logo:"Eristica.svg",erc20:!0,symbol:"ERT",decimals:18},"0xdAC17F958D2ee523a2206206994597C13D831ec7":{name:"Tether USD",logo:"usdt.svg",erc20:!0,symbol:"USDT",decimals:6},"0x06AF07097C9Eeb7fD685c692751D5C66dB49c215":{name:"Chai",logo:"CHAI.svg",erc20:!0,symbol:"CHAI",decimals:18},"0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828":{name:"UMA",logo:"uma.svg",erc20:!0,symbol:"UMA",decimals:18},"0x5f778ec4B31a506c1Dfd8b06F131E9B451a61D39":{name:"UPX Token",logo:"UPX.svg",erc20:!0,symbol:"UPX",decimals:18},"0xb1CD6e4153B2a390Cf00A6556b0fC1458C4A5533":{name:"ETHBNT Liquidity Pool",logo:"ETHBNT.svg",erc20:!0,symbol:"ETHBNT",decimals:18},"0xf0Ee6b27b759C9893Ce4f094b49ad28fd15A23e4":{name:"Enigma",logo:"enigma.svg",erc20:!0,symbol:"ENG",decimals:8},"0xaaAEBE6Fe48E54f431b0C390CfaF0b017d09D42d":{name:"Celsius",logo:"celsius.svg",erc20:!0,symbol:"CEL",decimals:4},"0xb683D83a532e2Cb7DFa5275eED3698436371cc9f":{name:"BTU",logo:"BTU.svg",erc20:!0,symbol:"BTU",decimals:18},"0x746DdA2ea243400D5a63e0700F190aB79f06489e":{name:"BOSAGORA",logo:"BOA.svg",erc20:!0,symbol:"BOA",decimals:7},"0x5D858bcd53E085920620549214a8b27CE2f04670":{name:"POP Network Token",logo:"POP.svg",erc20:!0,symbol:"POP",decimals:18},"0x048Fe49BE32adfC9ED68C37D32B5ec9Df17b3603":{name:"Skrumble Network V2",logo:"skm.svg",erc20:!0,symbol:"SKM",decimals:18},"0x16EA01aCB4b0Bca2000ee5473348B6937ee6f72F":{name:"Enecuum",logo:"ENQ-logo.svg",erc20:!0,symbol:"ENQ",decimals:10},"0xE5B826Ca2Ca02F09c1725e9bd98d9a8874C30532":{name:"ZEON Network",logo:"ZEON_logo.png",erc20:!0,symbol:"ZEON",decimals:18},"0x13cb85823f78Cff38f0B0E90D3e975b8CB3AAd64":{name:"REMIIT REMI Token",logo:"remi.svg",erc20:!0,symbol:"REMI",decimals:18},"0x93a7174dafd31d13400cD9fa01f4e5B5BAa00D39":{name:"Shaka",logo:"hak.svg",erc20:!0,symbol:"HAK",decimals:18},"0x6fB3e0A217407EFFf7Ca062D46c26E5d60a14d69":{name:"IoTeX",logo:"iotex.svg",erc20:!0,symbol:"IOTX",decimals:18},"0xE5a3229CCb22b6484594973A03a3851dCd948756":{name:"RAE Token",logo:"rae.svg",erc20:!0,symbol:"RAE",decimals:18},"0x4470BB87d77b963A013DB939BE332f927f2b992e":{name:"AdEx Legacy Token",logo:"adex.svg",erc20:!0,symbol:"ADXL",decimals:4},"0xADE00C28244d5CE17D72E40330B1c318cD12B7c3":{name:"AdEx Token",logo:"adex.svg",erc20:!0,symbol:"ADX",decimals:18},"0xDc5864eDe28BD4405aa04d93E05A0531797D9D59":{name:"Falcon",logo:"fnt.svg",erc20:!0,symbol:"FNT",decimals:6},"0x1966d718A565566e8E202792658D7b5Ff4ECe469":{name:"nDEX",logo:"nDEX.png",erc20:!0,symbol:"NDX",decimals:18},"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599":{name:"Wrapped BTC",logo:"wbtc.svg",erc20:!0,symbol:"WBTC",decimals:8},"0x150b0b96933B75Ce27af8b92441F8fB683bF9739":{name:"Dragonereum Gold",logo:"gold.svg",erc20:!0,symbol:"GOLD",decimals:18},"0x82f4dED9Cec9B5750FBFf5C2185AEe35AfC16587":{name:"DreamTeam Token",logo:"dream.svg",erc20:!0,symbol:"DREAM",decimals:6},"0x5d60d8d7eF6d37E16EBABc324de3bE57f135e0BC":{name:"MyBit",logo:"MYB.svg",erc20:!0,symbol:"MYB",decimals:18},"0x01FA555c97D7958Fa6f771f3BbD5CCD508f81e22":{name:"Civil Token",logo:"CVL_token.svg",erc20:!0,symbol:"CVL",decimals:18},"0x5adc961D6AC3f7062D2eA45FEFB8D8167d44b190":{name:"Dether",logo:"dether.svg",erc20:!0,symbol:"DTH",decimals:18},"0x3F17Dd476faF0a4855572F0B6ed5115D9bBA22AD":{name:"Wibson",logo:"wibson-logo.png",erc20:!0,symbol:"WIB",decimals:9},"0xDF347911910b6c9A4286bA8E2EE5ea4a39eB2134":{name:"Bob's Repair",logo:"bobsrepair.png",erc20:!0,symbol:"BOB",decimals:18},"0x3505F494c3f0fed0B594E01Fa41Dd3967645ca39":{name:"SWARM",logo:"swarm.svg",erc20:!0,symbol:"SWM",decimals:18},"0x6863bE0e7CF7ce860A574760e9020D519a8bDC47":{name:"On.Live",logo:"onlive.svg",erc20:!0,symbol:"ONL",decimals:18},"0xea5f88E54d982Cbb0c441cde4E79bC305e5b43Bc":{name:"Pareto",logo:"ParetoLogo.png",erc20:!0,symbol:"PARETO",decimals:18},"0x2e91E3e54C5788e9FdD6A181497FDcEa1De1bcc1":{name:"Hercules",logo:"herc.png",erc20:!0,symbol:"HERC",decimals:18},"0x4946Fcea7C692606e8908002e55A582af44AC121":{name:"FOAM",logo:"FOAM.svg",erc20:!0,symbol:"FOAM",decimals:18},"0x4D807509aECe24C0fa5A102b6a3B059Ec6E14392":{name:"Menlo One",logo:"Menlo_One.png",erc20:!0,symbol:"ONE",decimals:18},"0x27054b13b1B798B345b591a4d22e6562d47eA75a":{name:"AirSwap Token",logo:"AirSwapLogo.svg",erc20:!0,symbol:"AST",decimals:4},"0x8D5682941cE456900b12d47ac06a88b47C764CE1":{name:"RightMesh Token",logo:"Rmesh.png",erc20:!0,symbol:"RMESH",decimals:18},"0xDDe12a12A6f67156e0DA672be05c374e1B0a3e57":{name:"JOYSO",logo:"JOY.png",erc20:!0,symbol:"JOY",decimals:6},"0x0D262e5dC4A06a0F1c90cE79C7a60C09DfC884E4":{name:"JET8 Token",logo:"J8T.svg",erc20:!0,symbol:"J8T",decimals:8},"0x4a220E6096B25EADb88358cb44068A3248254675":{name:"Quant Network",logo:"quant-network.svg",erc20:!0,symbol:"QNT",decimals:18},"0xBC86727E770de68B1060C91f6BB6945c73e10388":{name:"Ink Protocol",logo:"ink_protocol.svg",erc20:!0,symbol:"XNK",decimals:18},"0xa95592DCFfA3C080B4B40E459c5f5692F67DB7F8":{name:"ELY Token",logo:"ely.png",erc20:!0,symbol:"ELY",decimals:18},"0x9E46A38F5DaaBe8683E10793b06749EEF7D733d1":{name:"PolySwarm Nectar",logo:"polyswarm_nectar.svg",erc20:!0,symbol:"NCT",decimals:18},"0xe1A178B681BD05964d3e3Ed33AE731577d9d96dD":{name:"BOX Token",logo:"box_token.png",erc20:!0,symbol:"BOX",decimals:18},"0x543Ff227F64Aa17eA132Bf9886cAb5DB55DCAddf":{name:"DAOstack",logo:"gen.svg",erc20:!0,symbol:"GEN",decimals:18},"0x6aEDbF8dFF31437220dF351950Ba2a3362168d1b":{name:"Dragonglass",logo:"dragonglass.svg",erc20:!0,symbol:"DGS",decimals:8},"0xd26114cd6EE289AccF82350c8d8487fedB8A0C07":{name:"OmiseGO",logo:"omg.svg",erc20:!0,symbol:"OMG",decimals:18},"0x99ea4dB9EE77ACD40B119BD1dC4E33e1C070b80d":{name:"Quantstamp",logo:"qsp.svg",erc20:!0,symbol:"QSP",decimals:18},"0xB64ef51C888972c908CFacf59B47C1AfBC0Ab8aC":{name:"Storj",logo:"storj.svg",erc20:!0,symbol:"STORJ",decimals:8},"0xD8E3FB3b08eBA982F2754988d70D57eDc0055ae6":{name:"Zoracles",logo:"zora.svg",erc20:!0,symbol:"ZORA",decimals:9},"0xF938424F7210f31dF2Aee3011291b658f872e91e":{name:"VISOR",logo:"VISR.svg",erc20:!0,symbol:"VISR",decimals:18},"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942":{name:"Decentraland",logo:"mana.svg",erc20:!0,symbol:"MANA",decimals:18},"0x0F513fFb4926ff82D7F60A05069047AcA295C413":{name:"CrowdstartCoin",logo:"XSC_Logo.svg",erc20:!0,symbol:"XSC",decimals:18},"0x5BC7e5f0Ab8b2E10D2D0a3F21739FCe62459aeF3":{name:"Hut34 Entropy Token",logo:"ENTRP.png",symbol:"ENTRP",erc20:!0,decimals:18},"0x946112efaB61C3636CBD52DE2E1392D7A75A6f01":{name:"HYDRO TOKEN",logo:"hydro.svg",erc20:!0,symbol:"HYDRO",decimals:18},"0x2604FA406Be957E542BEb89E6754fCdE6815e83f":{name:"Playkey Token",logo:"playkey.svg",erc20:!0,symbol:"PKT",decimals:18},"0xE41d2489571d322189246DaFA5ebDe1F4699F498":{name:"0x",logo:"zrx.svg",erc20:!0,symbol:"ZRX",decimals:18},"0x957c30aB0426e0C93CD8241E2c60392d08c6aC8e":{name:"Modum Token",logo:"modum.svg",erc20:!0,symbol:"MOD",decimals:0},"0x1a7a8BD9106F2B8D977E08582DC7d24c723ab0DB":{name:"AppCoins",logo:"appc.svg",erc20:!0,decimals:18,symbol:"APPC"},"0xdB25f211AB05b1c97D595516F45794528a807ad8":{name:"STASIS EURS Token",logo:"stasis-eurs.svg",erc20:!0,decimals:2,symbol:"EURS"},"0xCA0e7269600d353F70b14Ad118A49575455C0f2f":{name:"AMLT",logo:"amlt.png",erc20:!0,decimals:18,symbol:"AMLT"},"0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F":{name:"Synthetix Network Token",logo:"synthetix.svg",erc20:!0,decimals:18,symbol:"SNX"},"0x57Ab1ec28D129707052df4dF418D58a2D46d5f51":{name:"Synth sUSD",logo:"synthetix_susd.svg",erc20:!0,decimals:18,symbol:"SUSD"},"0x5e74C9036fb86BD7eCdcb084a0673EFc32eA31cb":{name:"Synth sETH",logo:"synthetix_seth.svg",erc20:!0,decimals:18,symbol:"SETH"},"0xfE18be6b3Bd88A2D2A7f928d00292E7a9963CfC6":{name:"Synth sBTC",logo:"synthetix_sbtc.svg",erc20:!0,decimals:18,symbol:"SBTC"},"0x0DB8D8b76BC361bAcbB72E2C491E06085A97Ab31":{name:"IQeon",logo:"iqeon.svg",erc20:!0,decimals:18,symbol:"IQN"},"0x000C100050E98C91f9114fa5Dd75CE6869Bf4F53":{name:"CRYPTO10 Hedged",logo:"c10.svg",erc20:!0,symbol:"C10",decimals:18},"0x26E75307Fc0C021472fEb8F727839531F112f317":{name:"Crypto20",logo:"c20.svg",erc20:!0,symbol:"C20",decimals:18},"0x06012c8cf97BEaD5deAe237070F9587f8E7A266d":{name:"Crypto Kitties",logo:"ck.svg",erc20:!1,erc721:!0,symbol:"CK",decimals:0},"0xE477292f1B3268687A29376116B0ED27A9c76170":{name:"Herocoin",logo:"herocoin_logo.png",erc20:!0,symbol:"PLAY",decimals:18},"0x4F4f0Db4de903B88f2B1a2847971E231D54F8fd3":{name:"Geens Platform Token",logo:"gee-icon.svg",erc20:!0,symbol:"GEE",decimals:8},"0xec67005c4E498Ec7f55E092bd1d35cbC47C91892":{name:"Enzyme Finance",logo:"mln.svg",erc20:!0,symbol:"MLN",decimals:18},"0xba2184520A1cC49a6159c57e61E1844E085615B6":{name:"HelloGold Token",logo:"hgt.png",erc20:!0,symbol:"HGT",decimals:8},"0xba358B6f5b4c0215650444B8C30D870B55050D2D":{name:"Hub Token",logo:"hub.svg",erc20:!0,symbol:"HUB",decimals:18},"0x8727c112C712c4a03371AC87a74dD6aB104Af768":{name:"Jetcoin Institute Token",logo:"JETCOIN28.png",erc20:!0,symbol:"JET",decimals:18},"0xf8e386EDa857484f5a12e4B5DAa9984E06E73705":{name:"Indorse Token",logo:"indorseLogo.jpg",erc20:!0,symbol:"IND",decimals:18},"0xA54ddC7B3CcE7FC8b1E3Fa0256D0DB80D2c10970":{name:"NEVERDIE Coin",logo:"ndc.png",erc20:!0,symbol:"NDC",decimals:18},"0x1c4481750daa5Ff521A2a7490d9981eD46465Dbd":{name:"BlockMason Credit Protocol Token",logo:"bcpt.svg",erc20:!0,symbol:"BCPT",decimals:18},"0x20F7A3DdF244dc9299975b4Da1C39F8D5D75f05A":{name:"Sapien Network Token",logo:"spn.svg",erc20:!0,symbol:"SPN",decimals:6},"0xA4e8C3Ec456107eA67d3075bF9e3DF3A75823DB0":{name:"Loom Token",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x42476F744292107e34519F9c357927074Ea3F75D":{name:"Loom",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x4F9254C83EB525f9FCf346490bbb3ed28a81C667":{name:"Celer Network Token",logo:"CELR.svg",erc20:!0,symbol:"CELR",decimals:18},"0x71D01dB8d6a2fBEa7f8d434599C237980C234e4C":{name:"Gladius",logo:"gladius.svg",erc20:!0,symbol:"GLA",decimals:8},"0xdd974D5C2e2928deA5F71b9825b8b646686BD200":{name:"Kyber Network Crystal",logo:"kyber.svg",erc20:!0,symbol:"KNC",decimals:18},"0x1F573D6Fb3F13d689FF844B4cE37794d79a7FF1C":{name:"Bancor Network Token",logo:"bnt.svg",erc20:!0,symbol:"BNT",decimals:18},"0xfa05A73FfE78ef8f1a739473e462c54bae6567D9":{name:"Lunyr Token",logo:"lun.svg",erc20:!0,symbol:"LUN",decimals:18},"0xC741f06082AA47F93729070aD0dD95E223Bda091":{name:"LEDU Token",logo:"edu.svg",erc20:!0,symbol:"LEDU",decimals:8},"0x5c543e7AE0A1104f78406C340E9C64FD9fCE5170":{name:"vSlice",logo:"vslice.png",erc20:!0,symbol:"VSL",decimals:18},"0x1f41E42D0a9e3c0Dd3BA15B527342783B43200A9":{name:"Blockchain Capital",logo:"bcap.svg",erc20:!0,symbol:"BCAP",decimals:0},"0x6531f133e6DeeBe7F2dcE5A0441aA7ef330B4e53":{name:"Chronobank TIME",logo:"chronobank.png",erc20:!0,symbol:"TIME",decimals:8},"0xaAAf91D9b90dF800Df4F55c205fd6989c977E73a":{name:"Monolith TKN",logo:"tkn.svg",erc20:!0,symbol:"TKN",decimals:8},"0x08711D3B02C8758F2FB3ab4e80228418a7F8e39c":{name:"Edgeless",logo:"edg.svg",erc20:!0,symbol:"EDG",decimals:0},"0xf7B098298f7C69Fc14610bf71d5e02c60792894C":{name:"Guppy",logo:"guppy.png",erc20:!0,symbol:"GUP",decimals:3},"0x4DF812F6064def1e5e029f1ca858777CC98D2D81":{name:"Xaurum",logo:"xaurum_logo.svg",erc20:!0,symbol:"XAUR",decimals:8},"0xB9e7F8568e08d5659f5D29C4997173d84CdF2607":{name:"Swarm City Token",logo:"swt.svg",erc20:!0,symbol:"SWT",decimals:18},"0xCb94be6f13A1182E4A4B6140cb7bf2025d28e41B":{name:"Trustcoin",logo:"trst.svg",erc20:!0,symbol:"TRST",decimals:6},"0xCB56b52316041A62B6b5D0583DcE4A8AE7a3C629":{name:"Cigarettes",logo:"cig.svg",erc20:!0,symbol:"CIG",decimals:18},"0x960b236A07cf122663c4303350609A66A7B288C0":{name:"Aragon Network Token v1",logo:"antv1.svg",erc20:!0,symbol:"ANTv1",decimals:18},"0x667088b212ce3d06a1b553a7221E1fD19000d9aF":{name:"WINGS",logo:"wings_logo.svg",erc20:!0,symbol:"WINGS",decimals:18},"0x16484d73Ac08d2355F466d448D2b79D2039F6EBB":{name:"FortKnoxster",logo:"FortKnoxster.svg",erc20:!0,symbol:"FKX",decimals:18},"0xAf30D2a7E90d7DC361c8C4585e9BB7D2F6f15bc7":{name:"FirstBlood Token",logo:"1st.svg",erc20:!0,symbol:"1ST",decimals:18},"0x607F4C5BB672230e8672085532f7e901544a7375":{name:"iExec RLC Token",logo:"rlc.svg",erc20:!0,symbol:"RLC",decimals:9},"0xaeC2E87E0A235266D9C5ADc9DEb4b2E29b54D009":{name:"SingularDTV",logo:"singulardtv.svg",erc20:!0,symbol:"SNGLS",decimals:0},"0x888666CA69E0f178DED6D75b5726Cee99A87D698":{name:"ICONOMI",logo:"iconomi.png",erc20:!0,symbol:"ICN",decimals:18},"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2":{name:"Maker",logo:"mkr.svg",erc20:!0,symbol:"MKR",decimals:18},"0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359":{name:"Sai Stablecoin v1.0",logo:"sai.svg",erc20:!0,symbol:"SAI",decimals:18},"0x6B175474E89094C44Da98b954EedeAC495271d0F":{name:"Dai Stablecoin",logo:"dai.svg",erc20:!0,symbol:"DAI",decimals:18},"0xC477D038d5420C6A9e0b031712f61c5120090de9":{name:"Boson Token",logo:"boson.svg",erc20:!0,symbol:"BOSON",decimals:18},"0xD46bA6D942050d489DBd938a2C909A5d5039A161":{name:"Ampleforth",logo:"ampl.svg",erc20:!0,symbol:"AMPL",decimals:9},"0x4b9278b94a1112cAD404048903b8d343a810B07e":{name:"Hifi Finance",logo:"hifi.svg",erc20:!0,symbol:"HIFI",decimals:18},"0x0D8775F648430679A709E98d2b0Cb6250d2887EF":{name:"Basic Attention Token",logo:"bat.svg",erc20:!0,symbol:"BAT",decimals:18},"0x4D8fc1453a0F359e99c9675954e656D80d996FbF":{name:"BEE Token",logo:"bee_token.svg",erc20:!0,symbol:"BEE",decimals:18},"0x6810e776880C02933D47DB1b9fc05908e5386b96":{name:"Gnosis Token",logo:"gnosis.svg",erc20:!0,symbol:"GNO",decimals:18},"0x514910771AF9Ca656af840dff83E8264EcF986CA":{name:"Chainlink Token",logo:"chainlink.svg",erc20:!0,symbol:"LINK",decimals:18},"0xD8912C10681D8B21Fd3742244f44658dBA12264E":{name:"Pluton",logo:"plutus-god.svg",erc20:!0,symbol:"PLU",decimals:18},"0x1985365e9f78359a9B6AD760e32412f4a445E862":{name:"Reputation Old",logo:"rep.svg",erc20:!0,symbol:"REP",decimals:18},"0x221657776846890989a759BA2973e427DfF5C9bB":{name:"Reputation",logo:"repv2.svg",erc20:!0,symbol:"REPv2",decimals:18},"0xd0929d411954c47438dc1d871dd6081F5C5e149c":{name:"Refereum",logo:"rfr.svg",erc20:!0,symbol:"RFR",decimals:4},"0xb0866289e870D2efc282406cF4123Df6E5BcB652":{name:"NoFakeCoin",logo:"nfticon.png",erc20:!0,symbol:"NFC",decimals:18},"0x2C4e8f2D746113d0696cE89B35F0d8bF88E0AEcA":{name:"Open Simple Token",logo:"OST.svg",erc20:!0,symbol:"OST",decimals:18},"0x408e41876cCCDC0F92210600ef50372656052a38":{name:"Republic Token",logo:"ren.svg",erc20:!0,symbol:"REN",decimals:18},"0xEB4C2781e4ebA804CE9a9803C67d0893436bB27D":{name:"renBTC",logo:"renBTC.svg",erc20:!0,symbol:"renBTC",decimals:8},"0x1C5db575E2Ff833E46a2E9864C22F4B22E0B37C2":{name:"renZEC",logo:"renZEC.svg",erc20:!0,symbol:"renZEC",decimals:8},"0x459086F2376525BdCebA5bDDA135e4E9d3FeF5bf":{name:"renBCH",logo:"renBCH.svg",erc20:!0,symbol:"renBCH",decimals:8},"0xD5147bc8e386d91Cc5DBE72099DAC6C9b99276F5":{name:"renFIL",logo:"renFIL.svg",erc20:!0,symbol:"renFIL",decimals:18},"0xa74476443119A942dE498590Fe1f2454d7D4aC0d":{name:"Golem Network Token",logo:"golem.svg",erc20:!0,symbol:"GNT",decimals:18},"0x6888a16eA9792c15A4DCF2f6C623D055c8eDe792":{name:"Spectiv Signal Token",logo:"spectiv.svg",erc20:!0,symbol:"SIG",decimals:18},"0x9a642d6b3368ddc662CA244bAdf32cDA716005BC":{name:"Qtum",logo:"qtum.svg",erc20:!0,decimals:18,symbol:"QTUM"},"0x1234567461d3f8Db7496581774Bd869C83D51c93":{name:"BitClave",logo:"bitclave.svg",erc20:!0,decimals:18,symbol:"CAT"},"0x7d4b8Cce0591C9044a22ee543533b72E976E36C3":{name:"Change",logo:"change.svg",erc20:!0,decimals:18,symbol:"CAG"},"0x1d462414fe14cf489c7A21CaC78509f4bF8CD7c0":{name:"CanYaCoin",logo:"CanYa.svg",erc20:!0,decimals:6,symbol:"CAN"},"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72":{name:"Ethereum Name Service",logo:"ens.svg",erc20:!0,decimals:18,symbol:"ENS"},"0x3d1BA9be9f66B8ee101911bC36D3fB562eaC2244":{name:"Rivetz",logo:"rivetz.png",erc20:!0,decimals:18,symbol:"RVT"},"0x056017c55aE7AE32d12AeF7C679dF83A85ca75Ff":{name:"Project Wyvern Token",logo:"wyvern-logo.svg",erc20:!0,symbol:"WYV",decimals:18},"0xfec0cF7fE078a500abf15F1284958F22049c2C7e":{name:"Maecenas ART Token",logo:"art.svg",erc20:!0,symbol:"ART",decimals:18},"0x05f4a42e251f2d52b8ed15E9FEdAacFcEF1FAD27":{name:"Zilliqa",logo:"zilliqa.svg",erc20:!0,symbol:"ZIL",decimals:12},"0x986EE2B944c42D017F52Af21c4c69B84DBeA35d8":{name:"BitMartToken",logo:"bitmart.png",erc20:!0,symbol:"BMX",decimals:18},"0xF03f8D65BaFA598611C3495124093c56e8F638f0":{name:"Viewly",logo:"viewly.svg",erc20:!0,symbol:"VIEW",decimals:18},"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2":{name:"Wrapped Ether",logo:"weth.svg",erc20:!0,symbol:"WETH",decimals:18},"0xba5BDe662c17e2aDFF1075610382B9B691296350":{name:"SuperRare Token",logo:"rare.svg",erc20:!0,symbol:"RARE",decimals:18},"0x6C8c6b02E7b2BE14d4fA6022Dfd6d75921D90E4E":{name:"Compound Basic Attention Token",logo:"ctoken-bat.svg",erc20:!0,symbol:"cBAT",decimals:8},"0x70e36f6BF80a52b3B46b3aF8e106CC0ed743E8e4":{name:"Compound Collateral",logo:"ctoken-comp.svg",erc20:!0,symbol:"cCOMP",decimals:8},"0x5d3a536E4D6DbD6114cc1Ead35777bAB948E3643":{name:"Compound Dai",logo:"ctoken-dai.svg",erc20:!0,symbol:"cDAI",decimals:8},"0xF5DCe57282A584D2746FaF1593d3121Fcac444dC":{name:"Compound Sai (Legacy Dai)",logo:"ctoken-sai.svg",erc20:!0,symbol:"cSAI",decimals:8},"0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5":{name:"Compound Ether",logo:"ctoken-eth.svg",erc20:!0,symbol:"cETH",decimals:8},"0x158079Ee67Fce2f58472A96584A73C7Ab9AC95c1":{name:"Compound Augur",logo:"ctoken-rep.svg",erc20:!0,symbol:"cREP",decimals:8},"0x39AA39c021dfbaE8faC545936693aC917d5E7563":{name:"Compound USD Coin",logo:"ctoken-usdc.svg",erc20:!0,symbol:"cUSDC",decimals:8},"0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9":{name:"Compound Tether",logo:"ctoken-usdt.svg",erc20:!0,symbol:"cUSDT",decimals:8},"0xC11b1268C1A384e55C48c2391d8d480264A3A7F4":{name:"Compound Wrapped BTC",logo:"ctoken-wbtc.svg",erc20:!0,symbol:"cWBTC",decimals:8},"0xB3319f5D18Bc0D84dD1b4825Dcde5d5f7266d407":{name:"Compound 0x",logo:"ctoken-zrx.svg",erc20:!0,symbol:"cZRX",decimals:8},"0xc00e94Cb662C3520282E6f5717214004A7f26888":{name:"Compound",logo:"comp.svg",erc20:!0,symbol:"COMP",decimals:18},"0xFFE02ee4C69eDf1b340fCaD64fbd6b37a7b9e265":{name:"NANJCOIN",logo:"nanjcoin.svg",erc20:!0,symbol:"NANJ",decimals:8},"0xB6eD7644C69416d67B522e20bC294A9a9B405B31":{name:"0xBitcoin Token",logo:"0xbitcoin.svg",erc20:!0,symbol:"0xBTC",decimals:8},"0x744d70FDBE2Ba4CF95131626614a1763DF805B9E":{name:"Status Network Token",logo:"snt.svg",erc20:!0,symbol:"SNT",decimals:18},"0x42d6622deCe394b54999Fbd73D108123806f6a18":{name:"SPANK",logo:"spank.svg",erc20:!0,symbol:"SPANK",decimals:18},"0x6B01c3170ae1EFEBEe1a3159172CB3F7A5ECf9E5":{name:"BOOTY",logo:"booty.png",erc20:!0,symbol:"BOOTY",decimals:18},"0x4a6058666cf1057eaC3CD3A5a614620547559fc9":{name:"Brickblock",logo:"Brickblock.svg",erc20:!0,symbol:"BBK",decimals:18},"0x80fB784B7eD66730e8b1DBd9820aFD29931aab03":{name:"ETHLend Token",logo:"lend.svg",erc20:!0,symbol:"LEND",decimals:18},"0x48FF53777F747cFB694101222a944dE070c15D36":{name:"Ether Kingdoms Token",logo:"IMP.svg",erc20:!0,symbol:"IMP",decimals:7},"0x02F61Fd266DA6E8B102D4121f5CE7b992640CF98":{name:"LikeCoin",logo:"like.svg",erc20:!0,symbol:"LIKE",decimals:18},"0xB8c77482e45F1F44dE1745F52C74426C631bDD52":{name:"Binance Coin",logo:"bnb.png",erc20:!0,symbol:"BNB",decimals:18},"0xD850942eF8811f2A866692A623011bDE52a462C1":{name:"VeChain",logo:"ven.svg",erc20:!0,symbol:"VEN",decimals:18},"0x91Af0fBB28ABA7E31403Cb457106Ce79397FD4E6":{name:"Aergo",logo:"Aergo.svg",erc20:!0,symbol:"AERGO",decimals:18},"0x5CA9a71B1d01849C0a95490Cc00559717fCF0D1d":{name:"Aeternity",logo:"aeternity.svg",erc20:!0,symbol:"AE",decimals:18},"0xd4fa1460F537bb9085d22C7bcCB5DD450Ef28e3a":{name:"Populous",logo:"ppt.svg",erc20:!0,symbol:"PPT",decimals:8},"0xFA1a856Cfa3409CFa145Fa4e20Eb270dF3EB21ab":{name:"IOST",logo:"iost.png",erc20:!0,symbol:"IOST",decimals:18},"0x039B5649A59967e3e936D7471f9c3700100Ee1ab":{name:"Kucoin Shares",logo:"kucoin.svg",erc20:!0,symbol:"KCS",decimals:6},"0x3893b9422Cd5D70a81eDeFfe3d5A1c6A978310BB":{name:"Mithril",logo:"mith.svg",erc20:!0,symbol:"MITH",decimals:18},"0xb7cB1C96dB6B22b0D3d9536E0108d062BD488F74":{name:"Walton Token",logo:"wtc.svg",erc20:!0,symbol:"WTC",decimals:18},"0x1776e1F26f98b1A5dF9cD347953a26dd3Cb46671":{name:"Numeraire",logo:"nmr.png",erc20:!0,symbol:"NMR",decimals:18},"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd":{name:"Gemini Dollar",logo:"gusd.svg",erc20:!0,symbol:"GUSD",decimals:2},"0xA4Bdb11dc0a2bEC88d24A3aa1E6Bb17201112eBe":{name:"StableUSD",logo:"usds.svg",erc20:!0,symbol:"USDS",decimals:6},"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48":{name:"USDC",logo:"usdc.svg",erc20:!0,symbol:"USDC",decimals:6},"0x1aBaEA1f7C830bD89Acc67eC4af516284b1bC33c":{name:"EURC",logo:"eurc.svg",erc20:!0,symbol:"EURC",decimals:6},"0x93ED3FBe21207Ec2E8f2d3c3de6e058Cb73Bc04d":{name:"Pinakion Token",logo:"pinakion.svg",erc20:!0,symbol:"PNK",decimals:18},"0x419D0d8BdD9aF5e606Ae2232ed285Aff190E711b":{name:"FunFair",logo:"fun.svg",erc20:!0,symbol:"FUN",decimals:8},"0xcA2796F9F61dc7b238Aab043971e49c6164DF375":{name:"YGGDRASH YEED Token",logo:"yggdrash.svg",erc20:!0,symbol:"YEED",decimals:18},"0x03e3f0c25965f13DbbC58246738C183E27b26a56":{name:"Disciplina Token",logo:"disciplina.svg",erc20:!0,symbol:"DSCP",decimals:18},"0xE814aeE960a85208C3dB542C53E7D4a6C8D5f60F":{name:"Chronologic DAY Token",logo:"DAY.png",erc20:!0,symbol:"DAY",decimals:18},"0x7E43581b19ab509BCF9397a2eFd1ab10233f27dE":{name:"PLATINUM",logo:"plat.png",erc20:!0,symbol:"PLAT",decimals:18},"0x8E870D67F660D95d5be530380D0eC0bd388289E1":{name:"Pax Dollar",logo:"usdp.svg",erc20:!0,symbol:"USDP",decimals:18},"0x45804880De22913dAFE09f4980848ECE6EcbAf78":{name:"PAX Gold",logo:"paxg.svg",erc20:!0,symbol:"PAXG",decimals:18},"0x0000000000085d4780B73119b644AE5ecd22b376":{name:"TrueUSD",logo:"TUSD.svg",erc20:!0,symbol:"TUSD",decimals:18},"0x00000000441378008EA67F4284A57932B1c000a5":{name:"TrueGBP",logo:"TGBP.svg",erc20:!0,symbol:"TGBP",decimals:18},"0x00006100F7090010005F1bd7aE6122c3C2CF0090":{name:"TrueAUD",logo:"TAUD.svg",erc20:!0,symbol:"TAUD",decimals:18},"0x00000100F2A2bd000715001920eB70D229700085":{name:"TrueCAD",logo:"TCAD.svg",erc20:!0,symbol:"TCAD",decimals:18},"0x0000852600CEB001E08e00bC008be620d60031F2":{name:"TrueHKD",logo:"THKD.svg",erc20:!0,symbol:"THKD",decimals:18},"0x4Fabb145d64652a948d72533023f6E7A623C7C53":{name:"Binance USD",logo:"busd.svg",erc20:!0,symbol:"BUSD",decimals:18},"0x23Ccc43365D9dD3882eab88F43d515208f832430":{name:"MidasProtocol",logo:"MAS.png",erc20:!0,symbol:"MAS",decimals:18},"0xC16b542ff490e01fcc0DC58a60e1EFdc3e357cA6":{name:"ICE ROCK MINING",logo:"rock2.png",erc20:!0,symbol:"ROCK2",decimals:0},"0x6758B7d441a9739b98552B373703d8d3d14f9e62":{name:"POA20 Token",logo:"POA20.png",erc20:!0,symbol:"POA20",decimals:18},"0x3DB6Ba6ab6F95efed1a6E794caD492fAAabF294D":{name:"LTO Network Token (old)",logo:"LTO.svg",erc20:!0,symbol:"LTOOLD",decimals:8},"0xd01409314aCb3b245CEa9500eCE3F6Fd4d70ea30":{name:"LTO Network Token",logo:"LTO.svg",erc20:!0,symbol:"LTO",decimals:8},"0xfeF4185594457050cC9c23980d301908FE057Bb1":{name:"VIDT Datalink",logo:"VIDT.svg",erc20:!0,symbol:"VIDT-OLD",decimals:18},"0x3BE7bF1A5F23BD8336787D0289B70602f1940875":{name:"VIDT DAO",logo:"VIDT.svg",erc20:!0,symbol:"VIDT",decimals:18},"0x7064aAb39A0Fcf7221c3396719D0917a65E35515":{name:"Cpollo",logo:"Cpollo.svg",erc20:!0,symbol:"CPLO",decimals:18},"0xd8446236FA95b9b5f9fd0f8E7Df1a944823c683d":{name:"NEEO",logo:"neeo.png",erc20:!0,symbol:"NEEO",decimals:18},"0xA823E6722006afe99E91c30FF5295052fe6b8E32":{name:"Neumark",logo:"neu.svg",erc20:!0,symbol:"NEU",decimals:18},"0x8f693ca8D21b157107184d29D398A8D082b38b76":{name:"Streamr",logo:"streamr.svg",erc20:!0,symbol:"DATA",decimals:18},"0x0Cf0Ee63788A0849fE5297F3407f701E122cC023":{name:"Streamr (old)",logo:"streamr_old.svg",erc20:!0,symbol:"XDATA",decimals:18},"0xA0b73E1Ff0B80914AB6fe0444E65848C4C34450b":{name:"Cronos",logo:"cro.svg",erc20:!0,symbol:"CRO",decimals:8},"0xF70a642bD387F94380fFb90451C2c81d4Eb82CBc":{name:"STAR",logo:"starbase.png",erc20:!0,symbol:"STAR",decimals:18},"0x7C5A0CE9267ED19B22F8cae653F198e3E8daf098":{name:"Santiment",logo:"santiment.svg",erc20:!0,symbol:"SAN",decimals:18},"0x58b6A8A3302369DAEc383334672404Ee733aB239":{name:"Livepeer",logo:"lpt.svg",erc20:!0,symbol:"LPT",decimals:18},"0x6fe56C0bcdD471359019FcBC48863d6c3e9d4F41":{name:"Props",logo:"props.png",erc20:!0,symbol:"PROPS",decimals:18},"0x6c6EE5e31d828De241282B9606C8e98Ea48526E2":{name:"HoloToken",logo:"hot.svg",erc20:!0,symbol:"HOT",decimals:18},"0xF629cBd94d3791C9250152BD8dfBDF380E2a3B9c":{name:"Enjin Coin",logo:"enj.svg",erc20:!0,symbol:"ENJ",decimals:18},"0xbf2179859fc6D5BEE9Bf9158632Dc51678a4100e":{name:"AELF",logo:"elf.svg",erc20:!0,symbol:"ELF",decimals:18},"0x39Bb259F66E1C59d5ABEF88375979b4D20D98022":{name:"WAX Token",logo:"wax.svg",erc20:!0,symbol:"WAX",decimals:8},"0x595832F8FC6BF59c85C527fEC3740A1b7a361269":{name:"PowerLedger",logo:"powr.svg",erc20:!0,symbol:"POWR",decimals:6},"0x28dee01D53FED0Edf5f6E310BF8Ef9311513Ae40":{name:"BlitzPredict",logo:"blitzpredict.svg",erc20:!0,symbol:"XBP",decimals:18},"0x33349B282065b0284d756F0577FB39c158F935e6":{name:"Maple Finance",logo:"maple-finance.svg",erc20:!0,erc721:!1,symbol:"MPL",decimals:18},"0xFBeef911Dc5821886e1dda71586d90eD28174B7d":{name:"KnownOrigin",logo:"knownorigin.svg",erc20:!0,symbol:"KODA",decimals:0},"0x8207c1FfC5B6804F6024322CcF34F29c3541Ae26":{name:"Origin Protocol",logo:"ogn.svg",erc20:!0,symbol:"OGN",decimals:18},"0x2A8e1E676Ec238d8A992307B495b45B3fEAa5e86":{name:"Origin Dollar",logo:"ousd.svg",erc20:!0,symbol:"OUSD",decimals:18},"0x856c4Efb76C1D1AE02e20CEB03A2A6a08b0b8dC3":{name:"Origin Ether",logo:"oeth.svg",erc20:!0,symbol:"OETH",decimals:18},"0x9c354503C38481a7A7a51629142963F98eCC12D0":{name:"Origin DeFi Governance",logo:"ogv.svg",erc20:!0,symbol:"OGV",decimals:18},"0x0C4576Ca1c365868E162554AF8e385dc3e7C66D9":{name:"Vote Escrowed Origin DeFi Governance",logo:"veogv.svg",erc20:!0,symbol:"veOGV",decimals:18},"0x8f8221aFbB33998d8584A2B05749bA73c37a938a":{name:"Request",logo:"request.svg",erc20:!0,symbol:"REQ",decimals:18},"0x2aEa4Add166EBf38b63d09a75dE1a7b94Aa24163":{name:"Kudos",logo:"kudos.svg",erc20:!1,erc721:!0,symbol:"KDO",decimals:0},"0x14C926F2290044B647e1Bf2072e67B495eff1905":{name:"Bethereum",logo:"bether.jpg",erc20:!0,symbol:"BETHER",decimals:18},"0x9AAb071B4129B083B01cB5A0Cb513Ce7ecA26fa5":{name:"Hunt Token",logo:"hunt.png",erc20:!0,symbol:"HUNT",decimals:18},"0xFEF3884b603C33EF8eD4183346E093A173C94da6":{name:"Metamorph",logo:"metamorph.svg",erc20:!0,symbol:"METM",decimals:18},"0x0AbdAce70D3790235af448C88547603b945604ea":{name:"district0x",logo:"district0x.svg",erc20:!0,symbol:"DNT",decimals:18},"0xB26631c6dda06aD89B93C71400D25692de89c068":{name:"Minds",logo:"minds.svg",erc20:!0,symbol:"MINDS",decimals:18},"0xBb1f24C0c1554b9990222f036b0AaD6Ee4CAec29":{name:"CryptoSoul",logo:"SOUL.svg",erc20:!0,symbol:"SOUL",decimals:18},"0xFF0E5e014cf97e0615cb50F6f39Da6388E2FaE6E":{name:"Origo",logo:"origo.svg",erc20:!0,symbol:"OGO",decimals:18},"0x0cB8D0B37C7487b11d57F1f33dEfA2B1d3cFccfE":{name:"DANKToken",logo:"dank-logo.svg",erc20:!0,symbol:"DANK",decimals:18},"0x3a4f40631a4f906c2BaD353Ed06De7A5D3fCb430":{name:"PlayDapp Token",logo:"playdapp.svg",erc20:!0,symbol:"PLA",decimals:18},"0xE9e3F9cfc1A64DFca53614a0182CFAD56c10624F":{name:"Su Squares",logo:"Su-Squares.svg",erc20:!1,erc721:!0,symbol:"SU",decimals:0},"0xfA5047c9c78B8877af97BDcb85Db743fD7313d4a":{name:"ROOK",logo:"Rook.svg",erc20:!0,symbol:"ROOK",decimals:18},"0xa62cc35625B0C8dc1fAEA39d33625Bb4C15bD71C":{name:"StormX",logo:"stormx.svg",erc20:!0,symbol:"STMX",decimals:18},"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0":{name:"Matic Network Token",logo:"matic.svg",erc20:!0,symbol:"MATIC",decimals:18},"0x9992eC3cF6A55b00978cdDF2b27BC6882d88D1eC":{name:"Polymath",logo:"poly.svg",erc20:!0,symbol:"POLY",decimals:18},"0x0a50C93c762fDD6E56D86215C24AaAD43aB629aa":{name:"LGO Token",logo:"lgo.png",erc20:!0,symbol:"LGO",decimals:8},"0xc8Cac7672f4669685817cF332a33Eb249F085475":{name:"LivenCoin",logo:"LVN.svg",erc20:!0,symbol:"LVN",decimals:18},"0xBBbbCA6A901c926F240b89EacB641d8Aec7AEafD":{name:"Loopring",logo:"LRC.svg",erc20:!0,symbol:"LRC",decimals:18},"0x255Aa6DF07540Cb5d3d297f0D0D4D84cb52bc8e6":{name:"Raiden Network Token",logo:"raiden.svg",erc20:!0,symbol:"RDN",decimals:18},"0x66fD97a78d8854fEc445cd1C80a07896B0b4851f":{name:"Lunch Money",logo:"LMY.svg",erc20:!0,symbol:"LMY",decimals:18},"0x679131F591B4f369acB8cd8c51E68596806c3916":{name:"Trustlines Network Token",logo:"TLN128.png",erc20:!0,symbol:"TLN",decimals:18},"0xdcD85914b8aE28c1E62f1C488E1D968D5aaFfE2b":{name:"TOP Network Token",logo:"TOP.svg",erc20:!0,symbol:"TOP",decimals:18},"0xaea46A60368A7bD060eec7DF8CBa43b7EF41Ad85":{name:"Fetch",logo:"fetch.svg",erc20:!0,symbol:"FET",decimals:18},"0x2e1E15C44Ffe4Df6a0cb7371CD00d5028e571d14":{name:"Mettalex",logo:"mettalex.svg",erc20:!0,symbol:"MTLX",decimals:18},"0xf21661D0D1d76d3ECb8e1B9F1c923DBfffAe4097":{name:"Realio Network",logo:"rio.svg",erc20:!0,symbol:"RIO",decimals:18},"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{name:"Uniswap",logo:"uni.svg",erc20:!0,symbol:"UNI",decimals:18},"0x2e6539edc3b76f1E21B71d214527FAbA875F70F3":{name:"Yearn Finance Dot",logo:"YFDOT.svg",erc20:!0,symbol:"YFDOT",decimals:18},"0x9F284E1337A815fe77D2Ff4aE46544645B20c5ff":{name:"Darwinia Commitment Token",logo:"kton.svg",erc20:!0,symbol:"KTON",decimals:18},"0xE48972fCd82a274411c01834e2f031D4377Fa2c0":{name:"TwoKeyEconomy",logo:"2key.svg",erc20:!0,symbol:"2KEY",decimals:18},"0x970B9bB2C0444F5E81e9d0eFb84C8ccdcdcAf84d":{name:"Fuse Token",logo:"fuse.svg",erc20:!0,symbol:"FUSE",decimals:18},"0x0Ae055097C6d159879521C384F1D2123D1f195e6":{name:"STAKE Token",logo:"stake.svg",erc20:!0,symbol:"STAKE",decimals:18},"0x5dc60C4D5e75D22588FA17fFEB90A63E535efCE0":{name:"dKargo",logo:"DKA.svg",erc20:!0,symbol:"DKA",decimals:18},"0x9469D013805bFfB7D3DEBe5E7839237e535ec483":{name:"Darwinia Network Native Token",logo:"ring.svg",erc20:!0,symbol:"RING",decimals:18},"0xA31B1767e09f842ECFd4bc471Fe44F830E3891AA":{name:"ROOBEE",logo:"ROOBEE.svg",erc20:!0,symbol:"ROOBEE",decimals:18},"0xC7e43A1c8E118aA2965F5EAbe0e718D83DB7A63C":{name:"ZCore Token",logo:"zcrt.svg",erc20:!0,symbol:"ZCRT",decimals:18},"0x08d32b0da63e2C3bcF8019c9c5d849d7a9d791e6":{name:"Dentacoin Token",logo:"dcn.svg",erc20:!0,symbol:"DCN",decimals:0},"0xe2f2a5C287993345a840Db3B0845fbC70f5935a5":{name:"mStable USD",logo:"mUSD.svg",erc20:!0,symbol:"mUSD",decimals:18},"0xa3BeD4E1c75D00fa6f4E5E6922DB7261B5E9AcD2":{name:"Meta",logo:"MTA.svg",erc20:!0,symbol:"MTA",decimals:18},"0xe3818504c1B32bF1557b16C238B2E01Fd3149C17":{name:"Pillar",logo:"plr.svg",erc20:!0,symbol:"PLR",decimals:18},"0xba100000625a3754423978a60c9317c58a424e3D":{name:"Balancer (BAL)",logo:"balancer.svg",erc20:!0,symbol:"BAL",decimals:18},"0x8a854288a5976036A725879164Ca3e91d30c6A1B":{name:"Guaranteed Entrance Token",logo:"get-logo.svg",erc20:!0,symbol:"GET",decimals:18},"0x2781246fe707bB15CeE3e5ea354e2154a2877B16":{name:"Elysia",logo:"el.svg",erc20:!0,symbol:"EL",decimals:18},"0x4dA34f8264CB33A5c9F17081B9EF5Ff6091116f4":{name:"Elyfi",logo:"elyfi.svg",erc20:!0,symbol:"ELFI",decimals:18},"0xc12d099be31567add4e4e4d0D45691C3F58f5663":{name:"Auctus",logo:"auc.svg",erc20:!0,symbol:"AUC",decimals:18},"0xdF574c24545E5FfEcb9a659c229253D4111d87e1":{name:"HUSD",logo:"HUSD.svg",erc20:!0,symbol:"HUSD",decimals:8},"0x2ecB13A8c458c379c4d9a7259e202De03c8F3D19":{name:"Block-Chain.com Token",logo:"block-chain.svg",erc20:!0,symbol:"BC",decimals:18},"0x38e4adB44ef08F22F5B5b76A8f0c2d0dCbE7DcA1":{name:"Concentrated Voting Power",logo:"PowerPool.svg",erc20:!0,symbol:"CVP",decimals:18},"0xa117000000f279D81A1D3cc75430fAA017FA5A2e":{name:"Aragon Network Token",logo:"antv2.svg",erc20:!0,symbol:"ANT",decimals:18},"0xDecade1c6Bf2cD9fb89aFad73e4a519C867adcF5":{name:"Experty Wisdom Token",logo:"wisdom-token.svg",erc20:!0,symbol:"WIS",decimals:18},"0x7D85e23014F84E6E21d5663aCD8751bEF3562352":{name:"Axion Old",logo:"obsolete.svg",erc20:!0,symbol:"AXNv1",decimals:18},"0x358AA737e033F34df7c54306960a38d09AaBd523":{name:"Ares Token",logo:"ares.svg",erc20:!0,symbol:"ARES",decimals:18},"0xB62132e35a6c13ee1EE0f84dC5d40bad8d815206":{name:"NEXO",logo:"NEXO.svg",erc20:!0,symbol:"NEXO",decimals:18},"0x4612021C75809160Be60DB21fBc9D6adD0B32deF":{name:"BCP Coin",logo:"BCP.svg",erc20:!0,symbol:"BCP",decimals:18},"0xE9E73E1aE76D17A16cC53E3e87a9a7dA78834d37":{name:"Camp",logo:"Camp.svg",erc20:!0,symbol:"CAMP",decimals:18},"0xdacD69347dE42baBfAEcD09dC88958378780FB62":{name:"Atari Token",logo:"atrilast.svg",erc20:!0,symbol:"ATRI",decimals:0},"0x71F85B2E46976bD21302B64329868fd15eb0D127":{name:"Axion",logo:"axion.svg",erc20:!0,symbol:"AXN",decimals:18},"0xc944E90C64B2c07662A292be6244BDf05Cda44a7":{name:"Graph Token",logo:"graphToken.svg",erc20:!0,symbol:"GRT",decimals:18},"0xFE3E6a25e6b192A42a44ecDDCd13796471735ACf":{name:"Reef Finance",logo:"reef.svg",erc20:!0,symbol:"REEF",decimals:18},"0x43Dfc4159D86F3A37A5A4B3D4580b888ad7d4DDd":{name:"DODO bird",logo:"DODO.svg",erc20:!0,symbol:"DODO",decimals:18},"0x4a615bB7166210CCe20E6642a6f8Fb5d4D044496":{name:"NAOS Finance",logo:"naos.svg",erc20:!0,symbol:"NAOS",decimals:18},"0x111111111117dC0aa78b770fA6A738034120C302":{name:"1INCH Token",logo:"1inch.svg",erc20:!0,symbol:"1INCH",decimals:18},"0x27702a26126e0B3702af63Ee09aC4d1A084EF628":{name:"Aleph.im Token",logo:"aleph.svg",erc20:!0,symbol:"ALEPH",decimals:18},"0x32a7C02e79c4ea1008dD6564b35F131428673c41":{name:"CRUST",logo:"crust.svg",erc20:!0,symbol:"CRU",decimals:18},"0x3472A5A71965499acd81997a54BBA8D852C6E53d":{name:"BADGER",logo:"badger.svg",erc20:!0,symbol:"BADGER",decimals:18},"0x65Def5029A0e7591e46B38742bFEdd1Fb7b24436":{name:"Kanpeki",logo:"kanpeki-green.svg",erc20:!0,symbol:"KAE",decimals:18},"0xF94b5C5651c888d928439aB6514B93944eEE6F48":{name:"Yield App",logo:"yield-app.svg",erc20:!0,symbol:"YLD",decimals:18},"0xDcB01cc464238396E213a6fDd933E36796eAfF9f":{name:"Yield",logo:"yield-logo.svg",erc20:!0,symbol:"YLD",decimals:18},"0x968F6f898a6Df937fC1859b323aC2F14643e3fED":{name:"Newscrypto",logo:"NWC.svg",erc20:!0,symbol:"NWC",decimals:18},"0xeb269732ab75A6fD61Ea60b06fE994cD32a83549":{name:"dForce USDx",logo:"USDx.svg",erc20:!0,symbol:"USDx",decimals:18},"0x6e0daDE58D2d89eBBe7aFc384e3E4f15b70b14D8":{name:"QuiverX",logo:"quiverx.svg",erc20:!0,symbol:"QRX",decimals:18},"0x0beAD9a1bcc1b84D06E3f2df67E3549Fd55aB054":{name:"EURxb",logo:"eurxb.svg",erc20:!0,symbol:"EURxb",decimals:18},"0x9F9c8ec3534c3cE16F928381372BfbFBFb9F4D24":{name:"GraphLinq",logo:"glq.svg",erc20:!0,symbol:"GLQ",decimals:18},"0xEB58343b36C7528F23CAAe63a150240241310049":{name:"NBU",logo:"NBU.svg",erc20:!0,symbol:"NBU",decimals:18},"0x16ECCfDbb4eE1A85A33f3A9B21175Cd7Ae753dB4":{name:"Route",logo:"route.svg",erc20:!0,symbol:"ROUTE",decimals:18},"0x75739d5944534115d7C54ee8C73F186D793BAE02":{name:"Collective",logo:"CO2.svg",erc20:!0,symbol:"CO2",decimals:18},"0x35bD01FC9d6D5D81CA9E055Db88Dc49aa2c699A8":{name:"FWB Pro",logo:"FWB.svg",erc20:!0,symbol:"FWB",decimals:18},"0x9B99CcA871Be05119B2012fd4474731dd653FEBe":{name:"Antimatter",logo:"antimatter.svg",erc20:!0,symbol:"MATTER",decimals:18},"0x6De037ef9aD2725EB40118Bb1702EBb27e4Aeb24":{name:"Render Token",logo:"RNDR.svg",erc20:!0,symbol:"RNDR",decimals:18},"0xDf49C9f599A0A9049D97CFF34D0C30E468987389":{name:"SaTT",logo:"SaTT.svg",erc20:!0,symbol:"SATT",decimals:18},"0x431ad2ff6a9C365805eBaD47Ee021148d6f7DBe0":{name:"dForce",logo:"DF.svg",erc20:!0,symbol:"DF",decimals:18},"0x6e1A19F235bE7ED8E3369eF73b196C07257494DE":{name:"Wrapped Filecoin",logo:"WFIL.svg",erc20:!0,symbol:"WFIL",decimals:18},"0xE452E6Ea2dDeB012e20dB73bf5d3863A3Ac8d77a":{name:"Wrapped Celo",logo:"WCELO.svg",erc20:!0,symbol:"wCELO",decimals:18},"0x4A64515E5E1d1073e83f30cB97BEd20400b66E10":{name:"Wrapped ZEC",logo:"WZEC.svg",erc20:!0,symbol:"WZEC",decimals:18},"0xA3865E64121537b5b59B5e239Db4aCBe6F36aa74":{name:"Wrapped Tezos",logo:"WXTZ.svg",erc20:!0,symbol:"WXTZ",decimals:18},"0x53c4871322Bb47e7A24136fce291a6dcC832a294":{name:"Wrapped Litecoin",logo:"WLTC.svg",erc20:!0,symbol:"WLTC",decimals:18},"0xad3E3Fc59dff318BecEaAb7D00EB4F68b1EcF195":{name:"Wrapped Celo USD",logo:"WCUSD.svg",erc20:!0,symbol:"wCUSD",decimals:18},"0x85D7bdfc9c3426b33A684241eEEE70385Bc42820":{name:"Wrapped Kadena",logo:"WKDA.svg",erc20:!0,symbol:"WKDA",decimals:18},"0x39fBBABf11738317a448031930706cd3e612e1B9":{name:"Wrapped XRP",logo:"WXRP.svg",erc20:!0,symbol:"WXRP",decimals:18},"0xBBC7f7A6AADAc103769C66CBC69AB720f7F9Eae3":{name:"INX Token",logo:"INX.svg",erc20:!0,symbol:"INX",decimals:18},"0x1b40183EFB4Dd766f11bDa7A7c3AD8982e998421":{name:"Vesper",logo:"vsp.svg",erc20:!0,symbol:"VSP",decimals:18},"0x544c42fBB96B39B21DF61cf322b5EDC285EE7429":{name:"InsurAce",logo:"INSUR.svg",erc20:!0,symbol:"INSUR",decimals:18},"0xcC665390b03c5D324D8fAF81C15eCee29A73bCB4":{name:"ChainSwap.com Governance Token",logo:"chainswap.svg",erc20:!0,symbol:"ASAP",decimals:18},"0x182F4c4C97cd1c24E1Df8FC4c053E5C47bf53Bef":{name:"keyTango Token",logo:"keyTango.svg",erc20:!0,symbol:"TANGO",decimals:18},"0x0275E1001e293C46CFe158B3702AADe0B99f88a5":{name:"Oiler",logo:"oiler.svg",erc20:!0,symbol:"OIL",decimals:18},"0xDe30da39c46104798bB5aA3fe8B9e0e1F348163F":{name:"Gitcoin",logo:"gtc.svg",erc20:!0,symbol:"GTC",decimals:18},"0x1796ae0b0fa4862485106a0de9b654eFE301D0b2":{name:"Polychain Monsters",logo:"PMON.svg",erc20:!0,symbol:"PMON",decimals:18},"0x8eEF5a82E6Aa222a60F009ac18c24EE12dBf4b41":{name:"Tixl",logo:"TXL.svg",erc20:!0,symbol:"TXL",decimals:18},"0x5218E472cFCFE0b64A064F055B43b4cdC9EfD3A6":{name:"unFederalReserve Token",logo:"eRSDL.svg",erc20:!0,symbol:"eRSDL",decimals:18},"0xE4cC5A22B39fFB0A56d67F94f9300db20D786a5F":{name:"unFederal eRSDL",logo:"uneRSDL.svg",erc20:!0,symbol:"uneRSDL",decimals:8},"0x2dbA05B51eF5A7DE3E7c3327201CA2F8a25C2414":{name:"unFederal DAI",logo:"unDAI.svg",erc20:!0,symbol:"unDAI",decimals:8},"0xFaCecE87e14B50eafc85C44C01702F5f485CA460":{name:"unFederal ETH",logo:"unETH.svg",erc20:!0,symbol:"unETH",decimals:8},"0x6b576972de33BebDe3A703BfF52a091e79f8c87A":{name:"unFederal USDC",logo:"unUSDC.svg",erc20:!0,symbol:"unUSDC",decimals:8},"0x6e2aA5bB90ac37D9006685AFc651ef067E1c7b44":{name:"unFederal USDT",logo:"unUSDT.svg",erc20:!0,symbol:"unUSDT",decimals:8},"0x5D446FC8DBd10EBAcfE9A427aB5402586af98cD4":{name:"unFederal WBTC",logo:"unWBTC.svg",erc20:!0,symbol:"unWBTC",decimals:8},"0xD837eCa6C91c67D98461A411BA2f00bdA9960a9D":{name:"unFederal AAVE",logo:"unAAVE.svg",erc20:!0,symbol:"unAAVE",decimals:8},"0x9e29Ce9cD25F4141dF6BB85b27Ef6933a16A5824":{name:"unFederal YFI",logo:"unYFI.svg",erc20:!0,symbol:"unYFI",decimals:8},"0x031002d15B0D0Cd7c9129d6F644446368deaE391":{name:"unFederal LINK",logo:"unLINK.svg",erc20:!0,symbol:"unLINK",decimals:8},"0xB8E2e2101eD11e9138803cd3e06e16dd19910647":{name:"ArdCoin",logo:"ardcoin.svg",erc20:!0,symbol:"ARDX",decimals:2},"0x6D0F5149c502faf215C89ab306ec3E50b15e2892":{name:"Portion Token",logo:"PRT.svg",erc20:!0,symbol:"PRT",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"3SPACE ART",logo:"3SPACE.svg",erc20:!0,symbol:"PACE",decimals:18},"0x3845badAde8e6dFF049820680d1F14bD3903a5d0":{name:"SAND",logo:"SAND.svg",erc20:!0,symbol:"SAND",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"Spacelens",logo:"SPACE.svg",erc20:!0,symbol:"SPACE",decimals:18},"0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a":{name:"Sandbox's LANDs",logo:"SAND.svg",erc20:!1,erc721:!0,symbol:"LAND",decimals:0},"0x362bc847A3a9637d3af6624EeC853618a43ed7D2":{name:"PARSIQ",logo:"parsiq.svg",erc20:!0,symbol:"PRQ",decimals:18},"0x21381e026Ad6d8266244f2A583b35F9E4413FA2a":{name:"Formation Finance",logo:"form.svg",erc20:!0,symbol:"FORM",decimals:18},"0x2ba592F78dB6436527729929AAf6c908497cB200":{name:"Cream",logo:"cream.svg",erc20:!0,symbol:"CREAM",decimals:18},"0x46576e20EC5F25586A6Fa2E0d6B6058354B72E72":{name:"Cryptomind",logo:"CR.svg",erc20:!0,erc721:!1,symbol:"CR",decimals:8},"0x5ab21Ec0bfa0B29545230395e3Adaca7d552C948":{name:"PUNKS Comic",logo:"punks-comic.svg",erc20:!1,erc721:!0,symbol:"COMIC",decimals:0},"0x9C2dc0c3CC2BADdE84B0025Cf4df1c5aF288D835":{name:"Coreto",logo:"coreto.svg",erc20:!0,symbol:"COR",decimals:18},"0x0De05F6447ab4D22c8827449EE4bA2D5C288379B":{name:"OOKI",logo:"ooki.svg",erc20:!0,symbol:"OOKI",decimals:18},"0x6B4c7A5e3f0B99FCD83e9c089BDDD6c7FCe5c611":{name:"Million",logo:"million.svg",erc20:!0,symbol:"MM",decimals:18},"0x56d811088235F11C8920698a204A5010a788f4b3":{name:"bZx Protocol Token (BZRX)",logo:"ic_token_bzrx.svg",erc20:!0,symbol:"BZRX",decimals:18},"0xB72B31907C1C95F3650b64b2469e08EdACeE5e8F":{name:"bZx Vesting Token (vBZRX)",logo:"ic_token_vbzrx.svg",erc20:!0,symbol:"vBZRX",decimals:18},"0x3085154623F51b00Dedfc6Ceeb5197277A66B17B":{name:"NIFTY",logo:"nfty.svg",erc20:!0,symbol:"NFTY",decimals:18},"0xB983E01458529665007fF7E0CDdeCDB74B967Eb6":{name:"Fulcrum ETH iToken (iETH)",logo:"ic_token_ieth.svg",erc20:!0,symbol:"iETH",decimals:18},"0x32E4c68B3A4a813b710595AebA7f6B7604Ab9c15":{name:"Fulcrum USDC iToken (iUSDC)",logo:"ic_token_iusdc.svg",erc20:!0,symbol:"iUSDC",decimals:6},"0x2ffa85f655752fB2aCB210287c60b9ef335f5b6E":{name:"Fulcrum WBTC iToken (iWBTC)",logo:"ic_token_ibtc.svg",erc20:!0,symbol:"iWBTC",decimals:8},"0x687642347a9282Be8FD809d8309910A3f984Ac5a":{name:"Fulcrum KNC iToken (iKNC)",logo:"ic_token_iknc.svg",erc20:!0,symbol:"iKNC",decimals:18},"0x463538705E7d22aA7f03Ebf8ab09B067e1001B54":{name:"Fulcrum LINK iToken (iLINK)",logo:"ic_token_ilink.svg",erc20:!0,symbol:"iLINK",decimals:18},"0x6b093998D36f2C7F0cc359441FBB24CC629D5FF0":{name:"Fulcrum DAI iToken (iDAI)",logo:"ic_token_idai.svg",erc20:!0,symbol:"iDAI",decimals:18},"0x7e9997a38A439b2be7ed9c9C4628391d3e055D48":{name:"Fulcrum USDT iToken (iUSDT)",logo:"ic_token_iusdt.svg",erc20:!0,symbol:"iUSDT",decimals:6},"0x9189c499727f88F8eCC7dC4EEA22c828E6AaC015":{name:"Fulcrum MKR iToken (iMKR)",logo:"ic_token_imkr.svg",erc20:!0,symbol:"iMKR",decimals:18},"0x18240BD9C07fA6156Ce3F3f61921cC82b2619157":{name:"Fulcrum BZRX iToken (iBZRX)",logo:"ic_token_ibzrx.svg",erc20:!0,symbol:"iBZRX",decimals:18},"0x7F3Fe9D492A9a60aEBb06d82cBa23c6F32CAd10b":{name:"Fulcrum YFI iToken (iYFI)",logo:"ic_token_iyfi.svg",erc20:!0,symbol:"iYFI",decimals:18},"0x0a625FceC657053Fe2D9FFFdeb1DBb4e412Cf8A8":{name:"Fulcrum UNI iToken (iUNI)",logo:"ic_token_iuni.svg",erc20:!0,symbol:"iUNI",decimals:18},"0x0cae8d91E0b1b7Bd00D906E990C3625b2c220db1":{name:"Fulcrum AAVE iToken (iAAVE)",logo:"ic_token_iaave.svg",erc20:!0,symbol:"iAAVE",decimals:18},"0x3dA0e01472Dee3746b4D324a65D7EdFaECa9Aa4f":{name:"Fulcrum LRC iToken (iLRC)",logo:"ic_token_ilrc.svg",erc20:!0,symbol:"iLRC",decimals:18},"0x6d29903BC2c4318b59B35d97Ab98ab9eC08Ed70D":{name:"Fulcrum COMP iToken (iCOMP)",logo:"ic_token_icomp.svg",erc20:!0,symbol:"iCOMP",decimals:18},"0x08c32b0726C5684024ea6e141C50aDe9690bBdcc":{name:"Stratos Token",logo:"stos.svg",erc20:!0,symbol:"STOS",decimals:18},"0xe28b3B32B6c345A34Ff64674606124Dd5Aceca30":{name:"Injective",logo:"inj.svg",erc20:!0,symbol:"INJ",decimals:18},"0xe516D78d784C77D479977BE58905B3f2b1111126":{name:"Bitspawn",logo:"spwn.svg",erc20:!0,symbol:"SPWN",decimals:18},"0xB16e967ff83DE3F1e9FCeAfbc2C28c1c5c56eF91":{name:"Polkadog",logo:"polkadog.svg",erc20:!0,symbol:"PDOG",decimals:18},"0x07c52c2537D84e532a9F15d32E152C8B94D2b232":{name:"ZkTube",logo:"ZKT.svg",erc20:!0,symbol:"ZKT",decimals:18},"0xF4d861575ecC9493420A3f5a14F85B13f0b50EB3":{name:"Fractal Protocol",logo:"fractal.svg",erc20:!0,symbol:"FCL",decimals:18},"0x3af33bEF05C2dCb3C7288b77fe1C8d2AeBA4d789":{name:"Kromatika",logo:"krom.svg",erc20:!0,symbol:"KROM",decimals:18},"0xA130E3a33a4d84b04c3918c4E5762223Ae252F80":{name:"Swash Token",logo:"swash.svg",erc20:!0,symbol:"SWASH",decimals:18},"0xea7Cc765eBC94C4805e3BFf28D7E4aE48D06468A":{name:"NearPad Token",logo:"nearpad.svg",erc20:!0,symbol:"PAD",decimals:18},"0x87C22615435998D69ACA34889D03155B694a94fc":{name:"DiemLibre",logo:"DLB.svg",erc20:!0,symbol:"DLB",decimals:18},"0x4d224452801ACEd8B2F0aebE155379bb5D594381":{name:"ApeCoin",logo:"APE.svg",erc20:!0,symbol:"APE",decimals:18},"0xCd1fAFf6e578Fa5cAC469d2418C95671bA1a62Fe":{name:"Torum Token",logo:"torum.svg",erc20:!0,symbol:"XTM",decimals:18},"0xcf0C122c6b73ff809C693DB761e7BaeBe62b6a2E":{name:"FLOKI",logo:"floki.svg",erc20:!0,symbol:"FLOKI",decimals:9},"0xe831F96A7a1DcE1aa2EB760b1e296c6A74CaA9d5":{name:"Nexum Coin",logo:"nexum.svg",erc20:!0,symbol:"Nexm",decimals:8},"0x6710c63432A2De02954fc0f851db07146a6c0312":{name:"MFG",logo:"mfg.svg",erc20:!0,symbol:"MFG",decimals:18},"0xae78736Cd615f374D3085123A210448E74Fc6393":{name:"Rocket Pool ETH",logo:"rETH.svg",erc20:!0,symbol:"rETH",decimals:18},"0x0C10bF8FcB7Bf5412187A595ab97a3609160b5c6":{name:"Decentralized USD",logo:"USDD.svg",erc20:!0,symbol:"USDD",decimals:18},"0xD33526068D116cE69F19A9ee46F0bd304F21A51f":{name:"Rocket Pool",logo:"rpl.svg",erc20:!0,symbol:"RPL",decimals:18},"0x9d38F670D15C14716BE1F109a4F453E966A2B6D4":{name:"Quid Ika",logo:"QuidIka.svg",erc20:!0,symbol:"QUID",decimals:9},"0xD3c625F54dec647DB8780dBBe0E880eF21BA4329":{name:"HollaEx Token",logo:"xht.svg",erc20:!0,symbol:"XHT",decimals:18},"0x01e0E2e61f554eCAaeC0cC933E739Ad90f24a86d":{name:"GTON",logo:"gton.svg",erc20:!0,symbol:"GTON",decimals:18},"0xeFF66B4A84C8a6b69b99EB1C5e39aF8fc35d13db":{name:"sGTON",logo:"sgton.svg",erc20:!0,symbol:"sGTON",decimals:18},"0x7659CE147D0e714454073a5dd7003544234b6Aa0":{name:"XCAD Token",logo:"xcad.svg",erc20:!0,symbol:"XCAD",decimals:18},"0x88dF592F8eb5D7Bd38bFeF7dEb0fBc02cf3778a0":{name:"Tellor Tributes",logo:"TRB.svg",erc20:!0,symbol:"TRB",decimals:18},"0x8d96B4ab6C741a4C8679AE323a100d74f085BA8F":{name:"Bazaars",logo:"BZR.svg",erc20:!0,symbol:"BZR",decimals:18},"0x9ee91F9f426fA633d227f7a9b000E28b9dfd8599":{name:"Liquid staked MATIC",logo:"stMATIC.svg",erc20:!0,symbol:"stMATIC",decimals:18},"0x0d02755a5700414B26FF040e1dE35D337DF56218":{name:"Bend Token",logo:"BendDAO.svg",erc20:!0,symbol:"BEND",decimals:18},"0x1A4b46696b2bB4794Eb3D4c26f1c55F9170fa4C5":{name:"BitDAO",logo:"BitDAO.svg",erc20:!0,erc721:!1,symbol:"BIT",decimals:18},"0xb8919522331C59f5C16bDfAA6A121a6E03A91F62":{name:"Home",logo:"home.svg",erc20:!0,erc721:!1,symbol:"HOME",decimals:6},"0xa54d2EBfD977ad836203c85F18db2F0a0cF88854":{name:"Bacon",logo:"bacon.svg",erc20:!0,erc721:!1,symbol:"BACON",decimals:18},"0x249cA82617eC3DfB2589c4c17ab7EC9765350a18":{name:"Verse",logo:"VERSE.svg",erc20:!0,erc721:!1,symbol:"VERSE",decimals:18},"0x317eb4ad9cfaC6232f0046831322E895507bcBeb":{name:"Tidex Token",logo:"tidex.svg",erc20:!0,symbol:"TDX",decimals:18},"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE":{name:"SHIBA INU",logo:"shib.svg",erc20:!0,symbol:"SHIB",decimals:18},"0x3506424F91fD33084466F402d5D97f05F8e3b4AF":{name:"chiliZ",logo:"chz.svg",erc20:!0,symbol:"CHZ",decimals:18},"0x15D4c048F83bd7e37d49eA4C83a07267Ec4203dA":{name:"Gala",logo:"gala.svg",erc20:!0,symbol:"GALA",decimals:8},"0x69af81e73A73B40adF4f3d4223Cd9b1ECE623074":{name:"Mask Network",logo:"mask.svg",erc20:!0,symbol:"MASK",decimals:18},"0xD533a949740bb3306d119CC777fa900bA034cd52":{name:"Curve DAO Token",logo:"crv.svg",erc20:!0,symbol:"CRV",decimals:18},"0x92D6C1e31e14520e676a687F0a93788B716BEff5":{name:"dYdX",logo:"dydx.svg",erc20:!0,symbol:"DYDX",decimals:18},"0x60bE1e1fE41c1370ADaF5d8e66f07Cf1C2Df2268":{name:"Perion Credits",logo:"perc.svg",erc20:!0,symbol:"PERC",decimals:18},"0x8971f9fd7196e5cEE2C1032B50F656855af7Dd26":{name:"Lambda",logo:"LAMB.svg",erc20:!0,symbol:"LAMB",decimals:18},"0x65514b352d1d4a17DE97f95C7faB177C625Bd6ff":{name:"KIBBLE Token",logo:"kibble.svg",erc20:!0,erc721:!1,symbol:"KBLE",decimals:18},"0xd9Fcd98c322942075A5C3860693e9f4f03AAE07b":{name:"Euler",logo:"eul.svg",erc20:!0,erc721:!1,symbol:"EUL",decimals:18},"0x777fD20c983d6658c1D50b3958B3A1733d1cd1E1":{name:"PUBLISH",logo:"publish.svg",erc20:!0,symbol:"NEWS",decimals:9},"0x19062190B1925b5b6689D7073fDfC8c2976EF8Cb":{name:"Swarm",logo:"ethswarm.svg",erc20:!0,symbol:"BZZ",decimals:16},"0x6aA030a9710CAD6E719A4EC0a85260Eb3F4F86c1":{name:"Real World Asset",logo:"rwa.svg",erc20:!0,symbol:"RWA",decimals:18},"0xde16Ce60804a881e9F8c4eBB3824646EDecd478D":{name:"MagicCraft",logo:"magiccraft.svg",erc20:!0,symbol:"MCRT",decimals:9},"0x7163436b8EfFfB469F6BB81cc908b1661d4795e6":{name:"Esco coin",logo:"escocoin.svg",erc20:!0,symbol:"ESCO",decimals:18},"0x9625cE7753ace1fa1865A47aAe2c5C2Ce4418569":{name:"KAP Games",logo:"kap-games.svg",erc20:!0,symbol:"KAP",decimals:18},"0x4FbB350052Bca5417566f188eB2EBCE5b19BC964":{name:"Rigo",logo:"grg.svg",erc20:!0,symbol:"GRG",decimals:18},"0xD8E163967FED76806Df0097B704bA721B9b37656":{name:"Cope",logo:"cope.svg",erc20:!0,symbol:"COPE",decimals:18},"0xdfbc9050F5B01DF53512DCC39B4f2B2BBaCD517A":{name:"Jobchain",logo:"job.svg",erc20:!0,symbol:"JOB",decimals:8},"0x083D41d6DD21EE938f0c055CA4fb12268DF0EfaC":{name:"GogolCoin",logo:"gol.svg",erc20:!0,symbol:"GOL",decimals:4},"0x9B4a69dE6CA0deFDD02c0c4ce6Cb84de5202944E":{name:"PROOF Platform",erc20:!0,symbol:"PROOF",decimals:9,logo:"proof-platform.svg"},"0x4507cEf57C46789eF8d1a19EA45f4216bae2B528":{name:"TokenFi",logo:"tokenfi.svg",erc20:!0,symbol:"TOKEN",decimals:9},"0x8B39B70E39Aa811b69365398e0aACe9bee238AEb":{name:"PolkaFoundry",logo:"pkf.svg",erc20:!0,symbol:"PKF",decimals:18},"0x2c95D751DA37A5C1d9c5a7Fd465c1d50F3d96160":{name:"WASSIE",logo:"wassie.svg",erc20:!0,symbol:"WASSIE",decimals:18},"0x06325440D014e39736583c165C2963BA99fAf14E":{name:"Curve.fi",logo:"steCRV.png",erc20:!0,symbol:"steCRV",decimals:18},"0x4E241A9EC66832a16bceaeB9156E524487f061D7":{name:"ETF Rocks",logo:"etf.svg",erc20:!0,symbol:"ETF",decimals:18},"0xA849EaaE994fb86Afa73382e9Bd88c2B6b18Dc71":{name:"Mass Vehicle Ledger",logo:"mvl.svg",erc20:!0,symbol:"MVL",decimals:18},"0xd5F7838F5C461fefF7FE49ea5ebaF7728bB0ADfa":{name:"Mantle Staked Ether",logo:"mETH.svg",erc20:!0,erc721:!1,symbol:"mETH",decimals:18}}}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/contract-map.json"}],[1226,{"./contract-map.json":1225},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./contract-map.json")}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/index.js"}],[1227,{"./types.cjs":1232},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=void 0;const r=e("./types.cjs");var s;n.RPC="rpc",n.FALL_BACK_VS_CURRENCY="ETH",n.IPFS_DEFAULT_GATEWAY_URL="https://cloudflare-ipfs.com/ipfs/",n.GANACHE_CHAIN_ID="0x539",n.MAX_SAFE_CHAIN_ID=0xfffffffffffec,n.ERC721="ERC721",n.ERC1155="ERC1155",n.ERC20="ERC20",n.ERC721_INTERFACE_ID="0x80ac58cd",n.ERC721_METADATA_INTERFACE_ID="0x5b5e139f",n.ERC721_ENUMERABLE_INTERFACE_ID="0x780e9d63",n.ERC1155_INTERFACE_ID="0xd9b67a26",n.ERC1155_METADATA_URI_INTERFACE_ID="0x0e89341c",n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID="0x4e2312e0",n.GWEI="gwei",n.ASSET_TYPES={NATIVE:"NATIVE",TOKEN:"TOKEN",NFT:"NFT",UNKNOWN:"UNKNOWN"},n.TESTNET_TICKER_SYMBOLS={GOERLI:"GoerliETH",SEPOLIA:"SepoliaETH",LINEA_GOERLI:"LineaETH",LINEA_SEPOLIA:"LineaETH",MEGAETH_TESTNET:"MegaETH"},n.BUILT_IN_CUSTOM_NETWORKS_RPC={MEGAETH_TESTNET:"https://carrot.megaeth.com/rpc","megaeth-testnet":"https://carrot.megaeth.com/rpc","monad-testnet":"https://testnet-rpc.monad.xyz"},n.BUILT_IN_NETWORKS={[r.NetworkType.goerli]:{chainId:r.ChainId.goerli,ticker:r.NetworksTicker.goerli,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.goerli}},[r.NetworkType.sepolia]:{chainId:r.ChainId.sepolia,ticker:r.NetworksTicker.sepolia,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.sepolia}},[r.NetworkType.mainnet]:{chainId:r.ChainId.mainnet,ticker:r.NetworksTicker.mainnet,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.mainnet}},[r.NetworkType["linea-goerli"]]:{chainId:r.ChainId["linea-goerli"],ticker:r.NetworksTicker["linea-goerli"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-goerli"]}},[r.NetworkType["linea-sepolia"]]:{chainId:r.ChainId["linea-sepolia"],ticker:r.NetworksTicker["linea-sepolia"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-sepolia"]}},[r.NetworkType["linea-mainnet"]]:{chainId:r.ChainId["linea-mainnet"],ticker:r.NetworksTicker["linea-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-mainnet"]}},[r.NetworkType["megaeth-testnet"]]:{chainId:r.ChainId["megaeth-testnet"],ticker:r.NetworksTicker["megaeth-testnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["megaeth-testnet"]}},[r.NetworkType["monad-testnet"]]:{chainId:r.ChainId["monad-testnet"],ticker:r.NetworksTicker["monad-testnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["monad-testnet"]}},[r.NetworkType["base-mainnet"]]:{chainId:r.ChainId["base-mainnet"],ticker:r.NetworksTicker["base-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["base-mainnet"]}},[r.NetworkType.rpc]:{chainId:undefined,blockExplorerUrl:undefined,ticker:undefined,rpcPrefs:undefined}},n.OPENSEA_PROXY_URL="https://proxy.api.cx.metamask.io/opensea/v1/api/v2",n.NFT_API_BASE_URL="https://nft.api.cx.metamask.io",n.NFT_API_VERSION="1",n.NFT_API_TIMEOUT=15e3,n.ORIGIN_METAMASK="metamask",function(e){e.AddEthereumChain="wallet_addEthereumChain",e.ConnectAccounts="connect_accounts",e.EthDecrypt="eth_decrypt",e.EthGetEncryptionPublicKey="eth_getEncryptionPublicKey",e.EthSignTypedData="eth_signTypedData",e.PersonalSign="personal_sign",e.ResultError="result_error",e.ResultSuccess="result_success",e.SnapDialogAlert="snap_dialog:alert",e.SnapDialogConfirmation="snap_dialog:confirmation",e.SnapDialogPrompt="snap_dialog:prompt",e.SnapDialogDefault="snap_dialog",e.SwitchEthereumChain="wallet_switchEthereumChain",e.Transaction="transaction",e.TransactionBatch="transaction_batch",e.Unlock="unlock",e.WalletConnect="wallet_connect",e.WalletRequestPermissions="wallet_requestPermissions",e.WatchAsset="wallet_watchAsset"}(s||(n.ApprovalType=s={})),n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP={[r.ChainId.goerli]:r.BuiltInNetworkName.Goerli,[r.ChainId.sepolia]:r.BuiltInNetworkName.Sepolia,[r.ChainId.mainnet]:r.BuiltInNetworkName.Mainnet,[r.ChainId["linea-goerli"]]:r.BuiltInNetworkName.LineaGoerli,[r.ChainId["linea-sepolia"]]:r.BuiltInNetworkName.LineaSepolia,[r.ChainId["linea-mainnet"]]:r.BuiltInNetworkName.LineaMainnet,[r.ChainId.aurora]:r.BuiltInNetworkName.Aurora},n.SECOND=1e3,n.SECONDS=n.SECOND,n.MINUTE=60*n.SECONDS,n.MINUTES=n.MINUTE,n.HOUR=60*n.MINUTES,n.HOURS=n.HOUR,n.DAY=24*n.HOURS,n.DAYS=n.DAY}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/constants.cjs"}],[1228,{cockatiel:3675},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createServicePolicy=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_MAX_RETRIES=n.handleWhen=n.handleAll=n.ExponentialBackoff=n.ConstantBackoff=n.CircuitState=n.BrokenCircuitError=void 0;const r=e("cockatiel");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return r.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return r.CircuitState}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return r.ExponentialBackoff}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return r.ConstantBackoff}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return r.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return r.handleWhen}}),n.DEFAULT_MAX_RETRIES=3,n.DEFAULT_MAX_CONSECUTIVE_FAILURES=3*(1+n.DEFAULT_MAX_RETRIES),n.DEFAULT_CIRCUIT_BREAK_DURATION=18e5,n.DEFAULT_DEGRADED_THRESHOLD=5e3;const s=e=>"object"!=typeof e||null===e||!("httpStatus"in e)||"number"!=typeof e.httpStatus||e.httpStatus>=500;n.createServicePolicy=function(e={}){const{maxRetries:t=n.DEFAULT_MAX_RETRIES,retryFilterPolicy:i=r.handleAll,maxConsecutiveFailures:a=n.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:o=n.DEFAULT_CIRCUIT_BREAK_DURATION,degradedThreshold:c=n.DEFAULT_DEGRADED_THRESHOLD,backoff:u=new r.ExponentialBackoff}=e,l=(0,r.retry)(i,{maxAttempts:t,backoff:u}),d=l.onRetry.bind(l),m=(0,r.circuitBreaker)((0,r.handleWhen)(s),{halfOpenAfter:o,breaker:new r.ConsecutiveBreaker(a)}),h=m.onBreak.bind(m),f=new r.EventEmitter;l.onGiveUp(e=>{m.state===r.CircuitState.Closed&&f.emit(e)}),l.onSuccess(({duration:e})=>{m.state===r.CircuitState.Closed&&e>c&&f.emit()});const p=f.addListener;return{...(0,r.wrap)(l,m),circuitBreakerPolicy:m,retryPolicy:l,onBreak:h,onDegraded:p,onRetry:d}}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/create-service-policy.cjs"}],[1229,{"./constants.cjs":1227,"./create-service-policy.cjs":1228,"./siwe.cjs":1231,"./types.cjs":1232,"./util.cjs":1233},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.fromHex=n.fractionBN=n.fetchWithErrorHandling=n.convertHexToDecimal=n.BNToHex=n.DAYS=n.DAY=n.HOURS=n.HOUR=n.MINUTES=n.MINUTE=n.SECONDS=n.SECOND=n.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=n.ApprovalType=n.ORIGIN_METAMASK=n.NFT_API_TIMEOUT=n.NFT_API_VERSION=n.NFT_API_BASE_URL=n.OPENSEA_PROXY_URL=n.BUILT_IN_NETWORKS=n.BUILT_IN_CUSTOM_NETWORKS_RPC=n.TESTNET_TICKER_SYMBOLS=n.ASSET_TYPES=n.GWEI=n.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=n.ERC1155_METADATA_URI_INTERFACE_ID=n.ERC1155_INTERFACE_ID=n.ERC721_ENUMERABLE_INTERFACE_ID=n.ERC721_METADATA_INTERFACE_ID=n.ERC721_INTERFACE_ID=n.ERC20=n.ERC1155=n.ERC721=n.MAX_SAFE_CHAIN_ID=n.GANACHE_CHAIN_ID=n.IPFS_DEFAULT_GATEWAY_URL=n.FALL_BACK_VS_CURRENCY=n.RPC=n.handleWhen=n.handleAll=n.createServicePolicy=n.ExponentialBackoff=n.DEFAULT_MAX_RETRIES=n.DEFAULT_MAX_CONSECUTIVE_FAILURES=n.DEFAULT_DEGRADED_THRESHOLD=n.DEFAULT_CIRCUIT_BREAK_DURATION=n.ConstantBackoff=n.CircuitState=n.BrokenCircuitError=void 0,n.isEqualCaseInsensitive=n.weiHexToGweiDec=n.toHex=n.toChecksumHexAddress=n.timeoutFetch=n.successfulFetch=n.safelyExecuteWithTimeout=n.safelyExecute=n.query=n.normalizeEnsName=n.isValidHexAddress=n.isValidJson=n.isSmartContractCode=n.isSafeDynamicKey=n.isSafeChainId=n.isPlainObject=n.isNonEmptyArray=n.HttpError=n.hexToText=n.hexToBN=n.handleFetch=n.gweiDecToWEIBN=n.getBuyURL=void 0;var i=e("./create-service-policy.cjs");Object.defineProperty(n,"BrokenCircuitError",{enumerable:!0,get:function(){return i.BrokenCircuitError}}),Object.defineProperty(n,"CircuitState",{enumerable:!0,get:function(){return i.CircuitState}}),Object.defineProperty(n,"ConstantBackoff",{enumerable:!0,get:function(){return i.ConstantBackoff}}),Object.defineProperty(n,"DEFAULT_CIRCUIT_BREAK_DURATION",{enumerable:!0,get:function(){return i.DEFAULT_CIRCUIT_BREAK_DURATION}}),Object.defineProperty(n,"DEFAULT_DEGRADED_THRESHOLD",{enumerable:!0,get:function(){return i.DEFAULT_DEGRADED_THRESHOLD}}),Object.defineProperty(n,"DEFAULT_MAX_CONSECUTIVE_FAILURES",{enumerable:!0,get:function(){return i.DEFAULT_MAX_CONSECUTIVE_FAILURES}}),Object.defineProperty(n,"DEFAULT_MAX_RETRIES",{enumerable:!0,get:function(){return i.DEFAULT_MAX_RETRIES}}),Object.defineProperty(n,"ExponentialBackoff",{enumerable:!0,get:function(){return i.ExponentialBackoff}}),Object.defineProperty(n,"createServicePolicy",{enumerable:!0,get:function(){return i.createServicePolicy}}),Object.defineProperty(n,"handleAll",{enumerable:!0,get:function(){return i.handleAll}}),Object.defineProperty(n,"handleWhen",{enumerable:!0,get:function(){return i.handleWhen}});var a=e("./constants.cjs");Object.defineProperty(n,"RPC",{enumerable:!0,get:function(){return a.RPC}}),Object.defineProperty(n,"FALL_BACK_VS_CURRENCY",{enumerable:!0,get:function(){return a.FALL_BACK_VS_CURRENCY}}),Object.defineProperty(n,"IPFS_DEFAULT_GATEWAY_URL",{enumerable:!0,get:function(){return a.IPFS_DEFAULT_GATEWAY_URL}}),Object.defineProperty(n,"GANACHE_CHAIN_ID",{enumerable:!0,get:function(){return a.GANACHE_CHAIN_ID}}),Object.defineProperty(n,"MAX_SAFE_CHAIN_ID",{enumerable:!0,get:function(){return a.MAX_SAFE_CHAIN_ID}}),Object.defineProperty(n,"ERC721",{enumerable:!0,get:function(){return a.ERC721}}),Object.defineProperty(n,"ERC1155",{enumerable:!0,get:function(){return a.ERC1155}}),Object.defineProperty(n,"ERC20",{enumerable:!0,get:function(){return a.ERC20}}),Object.defineProperty(n,"ERC721_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_METADATA_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_METADATA_INTERFACE_ID}}),Object.defineProperty(n,"ERC721_ENUMERABLE_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC721_ENUMERABLE_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_METADATA_URI_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_METADATA_URI_INTERFACE_ID}}),Object.defineProperty(n,"ERC1155_TOKEN_RECEIVER_INTERFACE_ID",{enumerable:!0,get:function(){return a.ERC1155_TOKEN_RECEIVER_INTERFACE_ID}}),Object.defineProperty(n,"GWEI",{enumerable:!0,get:function(){return a.GWEI}}),Object.defineProperty(n,"ASSET_TYPES",{enumerable:!0,get:function(){return a.ASSET_TYPES}}),Object.defineProperty(n,"TESTNET_TICKER_SYMBOLS",{enumerable:!0,get:function(){return a.TESTNET_TICKER_SYMBOLS}}),Object.defineProperty(n,"BUILT_IN_CUSTOM_NETWORKS_RPC",{enumerable:!0,get:function(){return a.BUILT_IN_CUSTOM_NETWORKS_RPC}}),Object.defineProperty(n,"BUILT_IN_NETWORKS",{enumerable:!0,get:function(){return a.BUILT_IN_NETWORKS}}),Object.defineProperty(n,"OPENSEA_PROXY_URL",{enumerable:!0,get:function(){return a.OPENSEA_PROXY_URL}}),Object.defineProperty(n,"NFT_API_BASE_URL",{enumerable:!0,get:function(){return a.NFT_API_BASE_URL}}),Object.defineProperty(n,"NFT_API_VERSION",{enumerable:!0,get:function(){return a.NFT_API_VERSION}}),Object.defineProperty(n,"NFT_API_TIMEOUT",{enumerable:!0,get:function(){return a.NFT_API_TIMEOUT}}),Object.defineProperty(n,"ORIGIN_METAMASK",{enumerable:!0,get:function(){return a.ORIGIN_METAMASK}}),Object.defineProperty(n,"ApprovalType",{enumerable:!0,get:function(){return a.ApprovalType}}),Object.defineProperty(n,"CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP",{enumerable:!0,get:function(){return a.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP}}),Object.defineProperty(n,"SECOND",{enumerable:!0,get:function(){return a.SECOND}}),Object.defineProperty(n,"SECONDS",{enumerable:!0,get:function(){return a.SECONDS}}),Object.defineProperty(n,"MINUTE",{enumerable:!0,get:function(){return a.MINUTE}}),Object.defineProperty(n,"MINUTES",{enumerable:!0,get:function(){return a.MINUTES}}),Object.defineProperty(n,"HOUR",{enumerable:!0,get:function(){return a.HOUR}}),Object.defineProperty(n,"HOURS",{enumerable:!0,get:function(){return a.HOURS}}),Object.defineProperty(n,"DAY",{enumerable:!0,get:function(){return a.DAY}}),Object.defineProperty(n,"DAYS",{enumerable:!0,get:function(){return a.DAYS}});var o=e("./util.cjs");Object.defineProperty(n,"BNToHex",{enumerable:!0,get:function(){return o.BNToHex}}),Object.defineProperty(n,"convertHexToDecimal",{enumerable:!0,get:function(){return o.convertHexToDecimal}}),Object.defineProperty(n,"fetchWithErrorHandling",{enumerable:!0,get:function(){return o.fetchWithErrorHandling}}),Object.defineProperty(n,"fractionBN",{enumerable:!0,get:function(){return o.fractionBN}}),Object.defineProperty(n,"fromHex",{enumerable:!0,get:function(){return o.fromHex}}),Object.defineProperty(n,"getBuyURL",{enumerable:!0,get:function(){return o.getBuyURL}}),Object.defineProperty(n,"gweiDecToWEIBN",{enumerable:!0,get:function(){return o.gweiDecToWEIBN}}),Object.defineProperty(n,"handleFetch",{enumerable:!0,get:function(){return o.handleFetch}}),Object.defineProperty(n,"hexToBN",{enumerable:!0,get:function(){return o.hexToBN}}),Object.defineProperty(n,"hexToText",{enumerable:!0,get:function(){return o.hexToText}}),Object.defineProperty(n,"HttpError",{enumerable:!0,get:function(){return o.HttpError}}),Object.defineProperty(n,"isNonEmptyArray",{enumerable:!0,get:function(){return o.isNonEmptyArray}}),Object.defineProperty(n,"isPlainObject",{enumerable:!0,get:function(){return o.isPlainObject}}),Object.defineProperty(n,"isSafeChainId",{enumerable:!0,get:function(){return o.isSafeChainId}}),Object.defineProperty(n,"isSafeDynamicKey",{enumerable:!0,get:function(){return o.isSafeDynamicKey}}),Object.defineProperty(n,"isSmartContractCode",{enumerable:!0,get:function(){return o.isSmartContractCode}}),Object.defineProperty(n,"isValidJson",{enumerable:!0,get:function(){return o.isValidJson}}),Object.defineProperty(n,"isValidHexAddress",{enumerable:!0,get:function(){return o.isValidHexAddress}}),Object.defineProperty(n,"normalizeEnsName",{enumerable:!0,get:function(){return o.normalizeEnsName}}),Object.defineProperty(n,"query",{enumerable:!0,get:function(){return o.query}}),Object.defineProperty(n,"safelyExecute",{enumerable:!0,get:function(){return o.safelyExecute}}),Object.defineProperty(n,"safelyExecuteWithTimeout",{enumerable:!0,get:function(){return o.safelyExecuteWithTimeout}}),Object.defineProperty(n,"successfulFetch",{enumerable:!0,get:function(){return o.successfulFetch}}),Object.defineProperty(n,"timeoutFetch",{enumerable:!0,get:function(){return o.timeoutFetch}}),Object.defineProperty(n,"toChecksumHexAddress",{enumerable:!0,get:function(){return o.toChecksumHexAddress}}),Object.defineProperty(n,"toHex",{enumerable:!0,get:function(){return o.toHex}}),Object.defineProperty(n,"weiHexToGweiDec",{enumerable:!0,get:function(){return o.weiHexToGweiDec}}),Object.defineProperty(n,"isEqualCaseInsensitive",{enumerable:!0,get:function(){return o.isEqualCaseInsensitive}}),s(e("./types.cjs"),n),s(e("./siwe.cjs"),n)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/index.cjs"}],[123,{"./background-api":120,"./differs":121,"./enums":122,"./selectors":124,"./specifications":125},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e("./background-api");Object.keys(r).forEach(function(e){"default"!==e&&"__esModule"!==e&&(e in n&&n[e]===r[e]||Object.defineProperty(n,e,{enumerable:!0,get:function(){return r[e]}}))});var s=e("./differs");Object.keys(s).forEach(function(e){"default"!==e&&"__esModule"!==e&&(e in n&&n[e]===s[e]||Object.defineProperty(n,e,{enumerable:!0,get:function(){return s[e]}}))});var i=e("./enums");Object.keys(i).forEach(function(e){"default"!==e&&"__esModule"!==e&&(e in n&&n[e]===i[e]||Object.defineProperty(n,e,{enumerable:!0,get:function(){return i[e]}}))});var a=e("./specifications");Object.keys(a).forEach(function(e){"default"!==e&&"__esModule"!==e&&(e in n&&n[e]===a[e]||Object.defineProperty(n,e,{enumerable:!0,get:function(){return a[e]}}))});var o=e("./selectors");Object.keys(o).forEach(function(e){"default"!==e&&"__esModule"!==e&&(e in n&&n[e]===o[e]||Object.defineProperty(n,e,{enumerable:!0,get:function(){return o[e]}}))})}}},{package:"$root$",file:"app/scripts/controllers/permissions/index.js"}],[1230,{"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("controller-utils")}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/logger.cjs"}],[1231,{"./logger.cjs":1230,"@metamask/utils":2656,"@spruceid/siwe-parser":2741,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.detectSIWE=n.isValidSIWEOrigin=n.parseDomainParts=void 0;const r=e("@metamask/utils"),s=e("@spruceid/siwe-parser"),i=e("./logger.cjs"),a=(0,i.createModuleLogger)(i.projectLogger,"detect-siwe");function o(e){try{const s="string"!=typeof(n=e)?n:(0,r.remove0x)(n),i=t.from(s,"hex");return 32===i.length?e:i.toString("utf8")}catch(t){return a(t),e}var n}const c={"http:":"80","https:":"443"};n.parseDomainParts=(e,t)=>e.match(/^[^/:]*:\/\//u)?new URL(e):new URL(`${t}//${e}`);n.isValidSIWEOrigin=e=>{try{const{origin:t,siwe:r}=e;if(!t||!r?.parsedMessage?.domain)return!1;const s=new URL(t),i=(0,n.parseDomainParts)(r.parsedMessage.domain,s.protocol);return 0===i.hostname.localeCompare(s.hostname,undefined,{sensitivity:"accent"})&&(""!==i.port&&i.port!==s.port?""===s.port&&i.port===c[s.protocol]:""===i.username||i.username===s.username)}catch(e){return a(e),!1}};n.detectSIWE=e=>{try{const{data:t}=e,n=o(t);return{isSIWEMessage:!0,parsedMessage:new s.ParsedMessage(n)}}catch(e){return{isSIWEMessage:!1,parsedMessage:null}}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/siwe.cjs"}],[1232,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s;Object.defineProperty(n,"__esModule",{value:!0}),n.NetworkNickname=n.BlockExplorerUrl=n.NetworksTicker=n.ChainId=n.BuiltInNetworkName=n.isInfuraNetworkType=n.isNetworkType=n.NetworkType=n.CustomNetworkType=n.InfuraNetworkType=void 0,n.InfuraNetworkType={mainnet:"mainnet",goerli:"goerli",sepolia:"sepolia","linea-goerli":"linea-goerli","linea-sepolia":"linea-sepolia","linea-mainnet":"linea-mainnet","base-mainnet":"base-mainnet"},n.CustomNetworkType={"megaeth-testnet":"megaeth-testnet","monad-testnet":"monad-testnet"},n.NetworkType={...n.InfuraNetworkType,...n.CustomNetworkType,rpc:"rpc"},n.isNetworkType=function(e){return Object.values(n.NetworkType).includes(e)},n.isInfuraNetworkType=function(e){return Object.keys(n.InfuraNetworkType).includes(e)},function(e){e.Mainnet="mainnet",e.Goerli="goerli",e.Sepolia="sepolia",e.LineaGoerli="linea-goerli",e.LineaSepolia="linea-sepolia",e.LineaMainnet="linea-mainnet",e.Aurora="aurora",e.MegaETHTestnet="megaeth-testnet",e.MonadTestnet="monad-testnet",e.BaseMainnet="base-mainnet"}(r||(n.BuiltInNetworkName=r={})),n.ChainId={[r.Mainnet]:"0x1",[r.Goerli]:"0x5",[r.Sepolia]:"0xaa36a7",[r.Aurora]:"0x4e454152",[r.LineaGoerli]:"0xe704",[r.LineaSepolia]:"0xe705",[r.LineaMainnet]:"0xe708",[r.MegaETHTestnet]:"0x18c6",[r.MonadTestnet]:"0x279f",[r.BaseMainnet]:"0x2105"},function(e){e.mainnet="ETH",e.goerli="GoerliETH",e.sepolia="SepoliaETH",e["linea-goerli"]="LineaETH",e["linea-sepolia"]="LineaETH",e["linea-mainnet"]="ETH",e["megaeth-testnet"]="MegaETH",e["monad-testnet"]="MON",e["base-mainnet"]="ETH",e.rpc=""}(s||(n.NetworksTicker=s={})),n.BlockExplorerUrl={[r.Mainnet]:"https://etherscan.io",[r.Goerli]:"https://goerli.etherscan.io",[r.Sepolia]:"https://sepolia.etherscan.io",[r.LineaGoerli]:"https://goerli.lineascan.build",[r.LineaSepolia]:"https://sepolia.lineascan.build",[r.LineaMainnet]:"https://lineascan.build",[r.MegaETHTestnet]:"https://megaexplorer.xyz",[r.MonadTestnet]:"https://testnet.monadexplorer.com",[r.BaseMainnet]:"https://basescan.org"},n.NetworkNickname={[r.Mainnet]:"Ethereum Mainnet",[r.Goerli]:"Goerli",[r.Sepolia]:"Sepolia",[r.LineaGoerli]:"Linea Goerli",[r.LineaSepolia]:"Linea Sepolia",[r.LineaMainnet]:"Linea",[r.MegaETHTestnet]:"Mega Testnet",[r.MonadTestnet]:"Monad Testnet",[r.BaseMainnet]:"Base Mainnet"}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/types.cjs"}],[1233,{"./constants.cjs":1227,"@metamask/ethjs-unit":1844,"@metamask/utils":2656,"bn.js":3553,buffer:3614,"eth-ens-namehash":3819,"fast-deep-equal":3955,lodash:4386},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.isEqualCaseInsensitive=n.isValidJson=n.isNonEmptyArray=n.isPlainObject=n.convertHexToDecimal=n.query=n.normalizeEnsName=n.timeoutFetch=n.fetchWithErrorHandling=n.handleFetch=n.successfulFetch=n.HttpError=n.isSmartContractCode=n.isValidHexAddress=n.toChecksumHexAddress=n.safelyExecuteWithTimeout=n.safelyExecute=n.toHex=n.fromHex=n.hexToText=n.hexToBN=n.getBuyURL=n.weiHexToGweiDec=n.gweiDecToWEIBN=n.fractionBN=n.BNToHex=n.isSafeChainId=n.isSafeDynamicKey=n.PROTOTYPE_POLLUTION_BLOCKLIST=void 0;const s=e("@metamask/ethjs-unit"),i=e("@metamask/utils"),a=r(e("bn.js")),o=r(e("eth-ens-namehash")),c=r(e("fast-deep-equal")),u=e("lodash"),l=e("./constants.cjs"),d=new Error("timeout");function m(e){return e?new a.default((0,i.remove0x)(e),16):new a.default(0)}n.PROTOTYPE_POLLUTION_BLOCKLIST=["__proto__","constructor","prototype"],n.isSafeDynamicKey=function(e){return"string"==typeof e&&!n.PROTOTYPE_POLLUTION_BLOCKLIST.some(t=>e===t)},n.isSafeChainId=function(e){if(!(0,i.isHexString)(e))return!1;const t=Number.parseInt(e,(0,i.isStrictHexString)(e)?16:10);return Number.isSafeInteger(t)&&t>0&&t<=l.MAX_SAFE_CHAIN_ID},n.BNToHex=function(e){return(0,i.add0x)(e.toString(16))},n.fractionBN=function(e,t,n){const r=new a.default(t),s=new a.default(n);return e.mul(r).div(s)},n.gweiDecToWEIBN=function(e){if(Number.isNaN(e))return new a.default(0);const t=e.toString().split("."),n=t[0]||"0";let r=t[1]||"";if(!r)return(0,s.toWei)(n,"gwei");if(r.length<=9)return(0,s.toWei)(`${n}.${r}`,"gwei");const i=r.slice(9)[0];r=r.slice(0,9);let o=(0,s.toWei)(`${n}.${r}`,"gwei");return Number(i)>=5&&(o=o.add(new a.default(1))),o},n.weiHexToGweiDec=function(e){const t=new a.default((0,i.remove0x)(e),16);return(0,s.fromWei)(t,"gwei")},n.getBuyURL=function(e="1",t,n=5){switch(e){case"1":return`https://buy.coinbase.com/?code=9ec56d01-7e81-5017-930c-513daa27bb6a&amount=${n}&address=${t}&crypto_currency=ETH`;case"5":return"https://goerli-faucet.slock.it/";case"11155111":return"https://sepoliafaucet.net/";default:return undefined}},n.hexToBN=m,n.hexToText=function(e){try{const n=(0,i.remove0x)(e);return t.from(n,"hex").toString("utf8")}catch(t){return e}},n.fromHex=function(e){return a.default.isBN(e)?e:new a.default(m(e).toString(10))},n.toHex=function(e){return"string"==typeof e&&(0,i.isStrictHexString)(e)?e:`0x${a.default.isBN(e)||"bigint"==typeof e?e.toString(16):new a.default(e.toString(),10).toString(16)}`},n.safelyExecute=async function(e,t=!1){try{return await e()}catch(e){return t&&console.error(e),undefined}},n.safelyExecuteWithTimeout=async function(e,t=!1,n=500){try{return await Promise.race([e(),new Promise((e,t)=>setTimeout(()=>{t(d)},n))])}catch(e){return t&&console.error(e),undefined}},n.toChecksumHexAddress=(0,u.memoize)(function(e){if("string"!=typeof e)return e;const t=(0,i.add0x)(e);if(!(0,i.isHexString)(t))return t;try{return(0,i.getChecksumAddress)(t)}catch(e){if(e instanceof Error&&"Invalid hex address."===e.message)return t;throw e}}),n.isValidHexAddress=(0,u.memoize)(function(e,{allowNonPrefixed:t=!0}={}){const n=t?(0,i.add0x)(e):e;return!!(0,i.isStrictHexString)(n)&&(0,i.isHexChecksumAddress)(n)},(e,{allowNonPrefixed:t=!0}={})=>`${e}-${t}`),n.isSmartContractCode=function(e){return!!e&&("0x"!==e&&"0x0"!==e)};class h extends Error{constructor(e,t){super(t||`Fetch failed with status '${e}'`),this.httpStatus=e}}async function f(e,t){const n=await fetch(e,t);if(!n.ok)throw new h(n.status,`Fetch failed with status '${n.status}' for request '${String(e)}'`);return n}async function p(e,t){const n=await f(e,t);return await n.json()}n.HttpError=h,n.successfulFetch=f,n.handleFetch=p,n.fetchWithErrorHandling=async function({url:e,options:t,timeout:n,errorCodesToCatch:r}){let s;try{s=n?Promise.race([await p(e,t),new Promise((e,t)=>setTimeout(()=>{t(d)},n))]):await p(e,t)}catch(e){!function(e,t=[]){if(!e)return;if(!(e instanceof Error))throw e;if(!t.some(t=>e.message.includes(`Fetch failed with status '${t}'`))&&!e.message.includes("Failed to fetch")&&e!==d)throw e;console.error(e)}(e,r)}return s},n.timeoutFetch=async function(e,t,n=500){return Promise.race([f(e,t),new Promise((e,t)=>setTimeout(()=>{t(d)},n))])},n.normalizeEnsName=function(e){if("."===e)return e;if(e&&"string"==typeof e)try{const t=o.default.normalize(e.trim());if(t.match(/^(([\w\d-]+)\.)*[\w\d-]{7,}\.(eth|test)$/u))return t}catch(e){}return null},n.query=function(e,t,n=[]){return new Promise((r,s)=>{const i=(e,t)=>{e?s(e):r(t)};t in e&&"function"==typeof e[t]?e[t](...n,i):e.sendAsync({method:t,params:n},i)})};n.convertHexToDecimal=(e="0x0")=>(0,i.isStrictHexString)(e)?parseInt(e,16):Number(e)?Number(e):0,n.isPlainObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)},n.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},n.isValidJson=function(e){try{return(0,c.default)(e,JSON.parse(JSON.stringify(e)))}catch(e){return!1}},n.isEqualCaseInsensitive=function(e,t){return"string"==typeof e&&"string"==typeof t&&e.toLowerCase()===t.toLowerCase()}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/util.cjs"}],[124,{"@metamask/chain-agnostic-permission":1209,reselect:4840},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getPermittedChainsByOrigin=n.getPermittedAccountsForScopesByOrigin=n.getPermittedAccountsByOrigin=n.getOriginsWithSessionProperty=n.getAuthorizedScopesByOrigin=void 0;var r=e("@metamask/chain-agnostic-permission"),s=e("reselect");const i=e=>e.subjects;n.getPermittedAccountsByOrigin=(0,s.createSelector)(i,e=>{const t=new Map;return Object.values(e).forEach(e=>{var n;const s=((null===(n=e.permissions)||void 0===n||null===(n=n[r.Caip25EndowmentPermissionName])||void 0===n?void 0:n.caveats)||[]).find(({type:e})=>e===r.Caip25CaveatType);if(s){const n=(0,r.getEthAccounts)(s.value);t.set(e.origin,n)}}),t}),n.getPermittedAccountsForScopesByOrigin=(0,s.createSelector)(i,(e,t)=>t,(e,t)=>{const n=new Map;return Object.values(e).forEach(e=>{var s;const i=((null===(s=e.permissions)||void 0===s||null===(s=s[r.Caip25EndowmentPermissionName])||void 0===s?void 0:s.caveats)||[]).find(({type:e})=>e===r.Caip25CaveatType);if(i){const s=(0,r.getPermittedAccountsForScopes)(i.value,t);s.length>0&&n.set(e.origin,s)}}),n}),n.getOriginsWithSessionProperty=(0,s.createSelector)(i,(e,t)=>t,(e,t)=>{const n={};return Object.values(e).forEach(e=>{var s,i;const a=((null===(s=e.permissions)||void 0===s||null===(s=s[r.Caip25EndowmentPermissionName])||void 0===s?void 0:s.caveats)||[]).find(({type:e})=>e===r.Caip25CaveatType),o=null==a||null===(i=a.value)||void 0===i||null===(i=i.sessionProperties)||void 0===i?void 0:i[t];o!==undefined&&(n[e.origin]=o)}),n}),n.getAuthorizedScopesByOrigin=(0,s.createSelector)(i,e=>Object.values(e).reduce((e,t)=>{var n;const s=((null===(n=t.permissions)||void 0===n||null===(n=n[r.Caip25EndowmentPermissionName])||void 0===n?void 0:n.caveats)||[]).find(({type:e})=>e===r.Caip25CaveatType);return s&&e.set(t.origin,s.value),e},new Map)),n.getPermittedChainsByOrigin=(0,s.createSelector)(i,e=>Object.values(e).reduce((e,t)=>{var n;const s=((null===(n=t.permissions)||void 0===n||null===(n=n[r.Caip25EndowmentPermissionName])||void 0===n?void 0:n.caveats)||[]).find(({type:e})=>e===r.Caip25CaveatType);if(s){const n=(0,r.getPermittedEthChainIds)(s.value);e.set(t.origin,n)}return e},new Map))}}},{package:"$root$",file:"app/scripts/controllers/permissions/selectors.js"}],[125,{"../../../../shared/constants/permissions":5292,"@metamask/chain-agnostic-permission":1209,"@metamask/snaps-rpc-methods":2370},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.unrestrictedMethods=n.unrestrictedEthSigningMethods=n.getPermissionSpecifications=n.getCaveatSpecifications=n.PermissionNames=n.CaveatFactories=void 0;var r=e("@metamask/snaps-rpc-methods"),s=e("@metamask/chain-agnostic-permission"),i=e("../../../../shared/constants/permissions");n.PermissionNames=Object.freeze({...i.RestrictedMethods,...i.EndowmentTypes}),n.CaveatFactories=Object.freeze({[s.Caip25CaveatType]:s.createCaip25Caveat});n.getCaveatSpecifications=({listAccounts:e,findNetworkClientIdByChainId:t,isNonEvmScopeSupported:n,getNonEvmAccountAddresses:i})=>({[s.Caip25CaveatType]:(0,s.caip25CaveatBuilder)({listAccounts:e,findNetworkClientIdByChainId:t,isNonEvmScopeSupported:n,getNonEvmAccountAddresses:i}),...r.caveatSpecifications,...r.endowmentCaveatSpecifications});n.getPermissionSpecifications=()=>({[s.caip25EndowmentBuilder.targetName]:s.caip25EndowmentBuilder.specificationBuilder({})});n.unrestrictedEthSigningMethods=Object.freeze(["eth_sendRawTransaction","eth_sendTransaction","eth_signTypedData","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4"]),n.unrestrictedMethods=Object.freeze(["eth_blockNumber","eth_call","eth_chainId","eth_coinbase","eth_decrypt","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getEncryptionPublicKey","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleByBlockHashAndIndex","eth_getUncleByBlockNumberAndIndex","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_getWork","eth_hashrate","eth_mining","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_protocolVersion","eth_requestAccounts","eth_sendRawTransaction","eth_sendTransaction","eth_signTypedData","eth_signTypedData_v1","eth_signTypedData_v3","eth_signTypedData_v4","eth_submitHashrate","eth_submitWork","eth_subscribe","eth_syncing","eth_uninstallFilter","eth_unsubscribe","metamask_getProviderState","metamask_logWeb3ShimUsage","metamask_sendDomainMetadata","metamask_watchAsset","net_listening","net_peerCount","net_version","personal_ecRecover","personal_sign","wallet_requestExecutionPermissions","wallet_addEthereumChain","wallet_getCallsStatus","wallet_getCapabilities","wallet_getPermissions","wallet_requestPermissions","wallet_revokePermissions","wallet_registerOnboarding","wallet_sendCalls","wallet_switchEthereumChain","wallet_watchAsset","web3_clientVersion","web3_sha3","wallet_getAllSnaps","wallet_getSnaps","wallet_requestSnaps","wallet_invokeSnap","wallet_invokeKeyring","snap_getClientStatus","snap_getCurrencyRate","snap_clearState","snap_getFile","snap_getState","snap_listEntropySources","snap_createInterface","snap_updateInterface","snap_getInterfaceState","snap_getInterfaceContext","snap_resolveInterface","snap_setState","snap_scheduleBackgroundEvent","snap_cancelBackgroundEvent","snap_getBackgroundEvents","snap_experimentalProviderRequest","snap_trackError","snap_trackEvent","snap_openWebSocket","snap_sendWebSocketMessage","snap_closeWebSocket","snap_getWebSockets","snap_startTrace","snap_endTrace"])}}},{package:"$root$",file:"app/scripts/controllers/permissions/specifications.js"}],[1630,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js"}],[1631,{"./logging-utils":1633,"@metamask/safe-event-emitter":2254,"@metamask/utils":2656,"json-rpc-random-id":4217},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c,u,l=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},d=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},m=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.PollingBlockTracker=void 0;const h=m(e("@metamask/safe-event-emitter")),f=e("@metamask/utils"),p=m(e("json-rpc-random-id")),y=e("./logging-utils"),g=(0,y.createModuleLogger)(y.projectLogger,"polling-block-tracker"),b=(0,p.default)(),v=["sync","latest"];class k extends h.default{constructor(e={}){if(!e.provider)throw new Error("PollingBlockTracker - no provider specified.");super(),r.add(this),s.set(this,[]),i.set(this,void 0),a.set(this,void 0),this._blockResetDuration=e.blockResetDuration||2e4,this._usePastBlocks=e.usePastBlocks||!1,this._currentBlock=null,this._isRunning=!1,this._onNewListener=this._onNewListener.bind(this),this._onRemoveListener=this._onRemoveListener.bind(this),this._resetCurrentBlock=this._resetCurrentBlock.bind(this),this._setupInternalEvents(),this._provider=e.provider,this._pollingInterval=e.pollingInterval||2e4,this._retryTimeout=e.retryTimeout||this._pollingInterval/10,this._keepEventLoopActive=e.keepEventLoopActive===undefined||e.keepEventLoopActive,this._setSkipCacheFlag=e.setSkipCacheFlag||!1}async destroy(){this._cancelBlockResetTimeout(),super.removeAllListeners(),this._maybeEnd()}isRunning(){return this._isRunning}getCurrentBlock(){return this._currentBlock}async getLatestBlock(){if(this._currentBlock)return this._currentBlock;if(l(this,i,"f"))return await l(this,i,"f").promise;const{promise:e,resolve:t,reject:n}=(0,f.createDeferredPromise)({suppressUnhandledRejection:!0});d(this,i,{reject:n,promise:e},"f");try{if(!this._isRunning){const e=await this._fetchLatestBlock();return this._newPotentialLatest(e),t(e),e}const n=e=>{l(this,r,"m",c).call(this,n),this.removeListener("latest",n),t(e)};return l(this,r,"m",o).call(this,n),this.once("latest",n),await e}catch(e){throw n(e),e}finally{d(this,i,undefined,"f")}}removeAllListeners(e){return e?super.removeAllListeners(e):super.removeAllListeners(),this._setupInternalEvents(),this._onRemoveListener(),this}_setupInternalEvents(){this.removeListener("newListener",this._onNewListener),this.removeListener("removeListener",this._onRemoveListener),this.on("newListener",this._onNewListener),this.on("removeListener",this._onRemoveListener)}_onNewListener(e){v.includes(e)&&this._maybeStart()}_onRemoveListener(){this._getBlockTrackerEventCount()>0||this._maybeEnd()}_maybeStart(){this._isRunning||(this._isRunning=!0,this._cancelBlockResetTimeout(),this._start(),this.emit("_started"))}_maybeEnd(){this._isRunning&&(this._isRunning=!1,this._setupBlockResetTimeout(),this._end(),l(this,r,"m",u).call(this,new Error("Block tracker destroyed")),this.emit("_ended"))}_getBlockTrackerEventCount(){return v.map(e=>this.listeners(e)).flat().filter(e=>l(this,s,"f").every(t=>!Object.is(t,e))).length}_shouldUseNewBlock(e){const t=this._currentBlock;if(!t)return!0;const n=E(e),r=E(t);return this._usePastBlocks&&n<r||n>r}_newPotentialLatest(e){this._shouldUseNewBlock(e)&&this._setCurrentBlock(e)}_setCurrentBlock(e){const t=this._currentBlock;this._currentBlock=e,this.emit("latest",e),this.emit("sync",{oldBlock:t,newBlock:e})}_setupBlockResetTimeout(){this._cancelBlockResetTimeout(),this._blockResetTimeout=setTimeout(this._resetCurrentBlock,this._blockResetDuration),this._blockResetTimeout.unref&&this._blockResetTimeout.unref()}_cancelBlockResetTimeout(){this._blockResetTimeout&&clearTimeout(this._blockResetTimeout)}_resetCurrentBlock(){this._currentBlock=null}async checkForLatestBlock(){return await this._updateLatestBlock(),await this.getLatestBlock()}_start(){this._updateAndQueue()}_end(){this._clearPollingTimeout()}async _updateLatestBlock(){const e=await this._fetchLatestBlock();this._newPotentialLatest(e)}async _fetchLatestBlock(){if(l(this,a,"f"))return await l(this,a,"f").promise;const{promise:e,resolve:t,reject:n}=(0,f.createDeferredPromise)({suppressUnhandledRejection:!0});d(this,a,{reject:n,promise:e},"f");try{const e={jsonrpc:"2.0",id:b(),method:"eth_blockNumber",params:[]};this._setSkipCacheFlag&&(e.skipCache=!0),g("Making request",e);const n=await this._provider.request(e);return g("Got result",n),t(n),n}catch(e){throw g("Encountered error fetching block",(0,f.getErrorMessage)(e)),n(e),l(this,r,"m",u).call(this,e),e}finally{d(this,a,undefined,"f")}}async _updateAndQueue(){let e=this._pollingInterval;try{await this._updateLatestBlock()}catch(t){try{this.emit("error",t)}catch(e){console.error(`Error updating latest block: ${(0,f.getErrorMessage)(t)}`)}e=this._retryTimeout}if(!this._isRunning)return;this._clearPollingTimeout();const t=setTimeout(()=>{this._updateAndQueue()},e);t.unref&&!this._keepEventLoopActive&&t.unref(),this._pollingTimeout=t,this.emit("_waitingForNextIteration")}_clearPollingTimeout(){this._pollingTimeout&&(clearTimeout(this._pollingTimeout),this._pollingTimeout=undefined)}}function E(e){return Number.parseInt(e,16)}n.PollingBlockTracker=k,s=new WeakMap,i=new WeakMap,a=new WeakMap,r=new WeakSet,o=function(e){l(this,s,"f").push(e)},c=function(e){l(this,s,"f").splice(l(this,s,"f").indexOf(e),1)},u=function(e){var t;null===(t=l(this,i,"f"))||void 0===t||t.reject(e),d(this,i,undefined,"f")}}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js"}],[1632,{"./BlockTracker":1630,"./PollingBlockTracker":1631},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./PollingBlockTracker"),n),s(e("./BlockTracker"),n)}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/index.js"}],[1633,{"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("eth-block-tracker")}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/logging-utils.js"}],[1634,{"@ethereumjs/util":551,"@metamask/eth-sig-util":1764,"@metamask/key-tree":1893,"@metamask/scure-bip39":2255,"@metamask/scure-bip39/dist/wordlists/english.js":2256,"@metamask/utils":2656,buffer:3614,"ethereum-cryptography/hdkey":3841,"ethereum-cryptography/keccak":3842},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r,s,i,a,o,c,u,l,d,m,h,f=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},p=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;const y=e("@ethereumjs/util"),g=e("@metamask/eth-sig-util"),b=e("@metamask/key-tree"),v=e("@metamask/scure-bip39"),k=e("@metamask/scure-bip39/dist/wordlists/english.js"),E=e("@metamask/utils"),w=e("ethereum-cryptography/hdkey"),T=e("ethereum-cryptography/keccak"),A="m/44'/60'/0'/0",C="HD Key Tree";class _{constructor(e={}){r.add(this),this.type=C,this.hdPath=A,s.set(this,[]),i.set(this,void 0),f(this,i,e.cryptographicFunctions,"f")}async generateRandomMnemonic(){await p(this,r,"m",d).call(this,(0,v.generateMnemonic)(k.wordlist))}async serialize(){let e=[];if(this.mnemonic){const t=p(this,r,"m",a).call(this,this.mnemonic);e=Array.from((new TextEncoder).encode(t))}return{mnemonic:e,numberOfAccounts:p(this,s,"f").length,hdPath:this.hdPath}}async deserialize(e={}){if(e.numberOfAccounts&&!e.mnemonic)throw new Error("Eth-Hd-Keyring: Deserialize method cannot be called with an opts value for numberOfAccounts and no menmonic");if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");return f(this,s,[],"f"),this.mnemonic=null,this.seed=null,this.root=null,this.hdPath=e.hdPath??A,e.mnemonic&&await p(this,r,"m",d).call(this,e.mnemonic),e.numberOfAccounts?this.addAccounts(e.numberOfAccounts):[]}async addAccounts(e=1){if(!this.root)throw new Error("Eth-Hd-Keyring: No secret recovery phrase provided");const t=p(this,s,"f").length,n=[];for(let r=t;r<e+t;r++){const e=this.root.deriveChild(r);n.push(e),p(this,s,"f").push(e)}const i=n.map(e=>((0,E.assert)(e.publicKey,"Expected public key to be set"),p(this,r,"m",m).call(this,e.publicKey)));return Promise.resolve(i)}getAccounts(){return p(this,s,"f").map(e=>((0,E.assert)(e.publicKey,"Expected public key to be set"),p(this,r,"m",m).call(this,e.publicKey)))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const n=p(this,r,"m",l).call(this,e,{withAppKeyOrigin:t});(0,E.assert)(n.publicKey,"Expected public key to be set");return p(this,r,"m",h).call(this,(0,E.bytesToHex)((0,y.publicToAddress)(n.publicKey)))}async exportAccount(e,t){const n=t?p(this,r,"m",l).call(this,e,t):p(this,r,"m",l).call(this,e),{privateKey:s}=n;return(0,E.assert)(s instanceof Uint8Array,"Expected private key to be of type Uint8Array"),(0,E.remove0x)((0,E.bytesToHex)(s))}async signTransaction(e,n,s={}){const i=p(this,r,"m",u).call(this,e,s);return n.sign(t.from(i))??n}async signMessage(e,n,s={}){(0,E.assertIsHexString)(n);const i=(0,E.remove0x)(n),a=p(this,r,"m",u).call(this,e,s),o=(0,y.ecsign)(t.from(i,"hex"),t.from(a));return(0,g.concatSig)(t.from((0,E.bigIntToBytes)(o.v)),t.from(o.r),t.from(o.s))}async signPersonalMessage(e,n,s={}){const i=p(this,r,"m",u).call(this,e,s),a=t.from(i);return(0,g.personalSign)({privateKey:a,data:n})}async decryptMessage(e,n){const s=p(this,r,"m",l).call(this,e),{privateKey:i}=s;(0,E.assert)(i,"Expected private key to be set");const a=t.from(i).toString("hex");return(0,g.decrypt)({privateKey:a,encryptedData:n})}async signTypedData(e,n,s={version:g.SignTypedDataVersion.V1}){const i=Object.keys(g.SignTypedDataVersion).includes(s.version)?s.version:g.SignTypedDataVersion.V1,a=p(this,r,"m",u).call(this,e,s);return(0,g.signTypedData)({privateKey:t.from(a),data:n,version:i})}async signEip7702Authorization(e,n,s){const i=p(this,r,"m",u).call(this,e,s);return(0,g.signEIP7702Authorization)({privateKey:t.from(i),authorization:n})}removeAccount(e){const t=p(this,r,"m",h).call(this,e);if(!p(this,s,"f").map(({publicKey:e})=>e&&p(this,r,"m",m).call(this,e)).includes(t))throw new Error(`Address ${t} not found in this keyring`);f(this,s,p(this,s,"f").filter(({publicKey:e})=>e&&p(this,r,"m",m).call(this,e)!==t),"f")}async getEncryptionPublicKey(e,t={}){const n=p(this,r,"m",u).call(this,e,t);return(0,g.getEncryptionPublicKey)((0,E.remove0x)((0,E.bytesToHex)(n)))}}n.HdKeyring=_,s=new WeakMap,i=new WeakMap,r=new WeakSet,a=function(e){return Array.from(new Uint16Array(new Uint8Array(e).buffer)).map(e=>k.wordlist[e]).join(" ")},o=function(e){const t=e.split(" ").map(e=>k.wordlist.indexOf(e));return new Uint8Array(new Uint16Array(t).buffer)},c=function(e){let n=e;var s;if("object"==typeof(s=e)&&null!==s&&"type"in s&&"Buffer"===s.type&&"data"in s&&Array.isArray(s.data)&&(n=e.data),"string"==typeof n||t.isBuffer(n)||Array.isArray(n)){let e;return e=Array.isArray(n)?t.from(n).toString():t.isBuffer(n)?n.toString():n,p(this,r,"m",o).call(this,e)}return n instanceof Object&&!(n instanceof Uint8Array)?Uint8Array.from(Object.values(n)):((0,E.assert)(n instanceof Uint8Array,"Expected Uint8Array mnemonic"),n)},u=function(e,t){if(!e)throw new Error("Must specify address.");const n=p(this,r,"m",l).call(this,e,t);return(0,E.assert)(n.privateKey,"Missing private key"),n.privateKey},l=function(e,{withAppKeyOrigin:n}={}){const i=p(this,r,"m",h).call(this,e),a=p(this,s,"f").find(({publicKey:e})=>e&&p(this,r,"m",m).call(this,e)===i);if(!a)throw new Error("HD Keyring - Unable to find matching address.");if(n){const{privateKey:e}=a;(0,E.assert)(e,"Expected private key to be set");const r=t.from(n,"utf8"),s=t.concat([e,r]),i=t.from((0,T.keccak256)(s));return{privateKey:i,publicKey:t.from((0,y.privateToPublic)(i))}}return a},d=async function(e){if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");this.mnemonic=p(this,r,"m",c).call(this,e),this.seed=await(0,b.mnemonicToSeed)(this.mnemonic,"",p(this,i,"f")),this.hdWallet=w.HDKey.fromMasterSeed(this.seed),this.root=this.hdWallet.derive(this.hdPath)},m=function(e){return(0,E.add0x)((0,E.bytesToHex)((0,y.publicToAddress)(t.from(e),!0)).toLowerCase())},h=function(e){const t=(0,g.normalize)(e);return(0,E.assert)(t,"Expected address to be set"),(0,E.add0x)(t)},_.type=C}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"}],[1635,{"./hd-keyring.cjs":1634},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.HdKeyring=void 0;var r=e("./hd-keyring.cjs");Object.defineProperty(n,"HdKeyring",{enumerable:!0,get:function(){return r.HdKeyring}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/index.cjs"}],[1645,{"./fetch-config-from-req":1647,"./logging-utils":1649,"@metamask/json-rpc-engine":1869,"@metamask/rpc-errors":2252},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createInfuraMiddlewareWithoutRpcService=n.createInfuraMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),s=e("@metamask/rpc-errors"),i=e("./fetch-config-from-req"),a=e("./logging-utils"),o=(0,a.createModuleLogger)(a.projectLogger,"create-infura-middleware"),c=["Gateway timeout","ETIMEDOUT","ECONNRESET","SyntaxError"];function u({network:e="mainnet",maxAttempts:t=5,source:n,projectId:s,headers:i={}}){if(!s||"string"!=typeof s)throw new Error(`Invalid value for 'projectId': "${s}"`);if(!i||"object"!=typeof i)throw new Error(`Invalid value for 'headers': "${i}"`);if(!t)throw new Error(`Invalid value for 'maxAttempts': "${t}" (${typeof t})`);return(0,r.createAsyncMiddleware)(async(r,a)=>{for(let c=1;c<=t;c++)try{o("Attempting request to Infura. network = %o, projectId = %s, headers = %o, req = %o",e,s,i,r),await l(e,s,i,r,a,n);break}catch(e){if(!m(e))throw o("Non-retriable request error encountered. req = %o, res = %o, error = %o",r,a,e),e;if(!(t-c)){o("Retriable request error encountered, but exceeded max attempts. req = %o, res = %o, error = %o",r,a,e);const t=`InfuraProvider - cannot complete request. All retries exhausted.\nOriginal Error:\n${e.toString()}\n\n`;throw new Error(t)}o("Retriable request error encountered. req = %o, res = %o, error = %o",r,a,e),o("Waiting 1 second to try again..."),await h(1e3)}})}async function l(e,t,n,r,a,o){const{fetchUrl:c,fetchParams:u}=(0,i.fetchConfigFromReq)({network:e,projectId:t,extraHeaders:n,req:r,source:o}),l=await fetch(c,u),m=await l.text();if(!l.ok)switch(l.status){case 405:throw s.rpcErrors.methodNotFound();case 429:throw d("Request is being rate limited.");case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",d(e)}();default:throw d(m)}if("eth_getBlockByNumber"===r.method&&"Not Found"===m)return void(a.result=null);const h=JSON.parse(m);a.result=h.result,a.error=h.error}function d(e){return s.rpcErrors.internal(e)}function m(e){const t=e.toString();return c.some(e=>t.includes(e))}async function h(e){return new Promise(t=>{setTimeout(t,e)})}n.createInfuraMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){const{source:n,headers:s={}}=t;return(0,r.createAsyncMiddleware)(async(t,r)=>{const i=n!==undefined&&t.origin!==undefined?Object.assign(Object.assign({},s),{"Infura-Source":`${n}/${t.origin}`}):s,a=await e.request({id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},{headers:i});"error"in a?r.error=a.error:(r.result=a.result,r.error=undefined)})}(e):u(e)},n.createInfuraMiddlewareWithoutRpcService=u}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js"}],[1646,{"./create-infura-middleware":1645,"@metamask/eth-json-rpc-provider":1669,"@metamask/json-rpc-engine":1869},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createProvider=void 0;const r=e("@metamask/eth-json-rpc-provider"),s=e("@metamask/json-rpc-engine"),i=e("./create-infura-middleware");n.createProvider=function(e){const t=new s.JsonRpcEngine;return t.push((0,i.createInfuraMiddleware)(e)),(0,r.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js"}],[1647,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return{id:e.id,jsonrpc:e.jsonrpc,method:e.method,params:e.params}}Object.defineProperty(n,"__esModule",{value:!0}),n.fetchConfigFromReq=void 0,n.fetchConfigFromReq=function({network:e,projectId:t,extraHeaders:n={},req:s,source:i}){const a=s.origin||"internal",o=Object.assign({},n,{Accept:"application/json","Content-Type":"application/json"});return i&&(o["Infura-Source"]=`${i}/${a}`),{fetchUrl:`https://${e}.infura.io/v3/${t}`,fetchParams:{method:"POST",headers:o,body:JSON.stringify(r(s))}}}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"}],[1648,{"./create-infura-middleware":1645,"./create-provider":1646,"./fetch-config-from-req":1647},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./create-infura-middleware"),n),s(e("./fetch-config-from-req"),n),s(e("./create-provider"),n)}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/index.js"}],[1649,{"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("eth-json-rpc-infura")}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js"}],[1669,{"./provider-from-engine.cjs":1670,"./provider-from-middleware.cjs":1671,"./safe-event-emitter-provider.cjs":1672},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.SafeEventEmitterProvider=void 0,s(e("./provider-from-engine.cjs"),n),s(e("./provider-from-middleware.cjs"),n);var i=e("./safe-event-emitter-provider.cjs");Object.defineProperty(n,"SafeEventEmitterProvider",{enumerable:!0,get:function(){return i.SafeEventEmitterProvider}})}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],[1670,{"./safe-event-emitter-provider.cjs":1672},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerFromEngine=void 0;const r=e("./safe-event-emitter-provider.cjs");n.providerFromEngine=function(e){return new r.SafeEventEmitterProvider({engine:e})}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs"}],[1671,{"./provider-from-engine.cjs":1670,"@metamask/json-rpc-engine":1869},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.providerFromMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),s=e("./provider-from-engine.cjs");n.providerFromMiddleware=function(e){const t=new r.JsonRpcEngine;return t.push(e),(0,s.providerFromEngine)(t)}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],[1672,{"@metamask/rpc-errors":2252,"@metamask/safe-event-emitter":2254,uuid:5219},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.SafeEventEmitterProvider=n.convertEip1193RequestToJsonRpcRequest=void 0;const o=e("@metamask/rpc-errors"),c=a(e("@metamask/safe-event-emitter")),u=e("uuid");function l(e){const{id:t=(0,u.v4)(),jsonrpc:n="2.0",method:r,params:s}=e;return s?{id:t,jsonrpc:n,method:r,params:s}:{id:t,jsonrpc:n,method:r}}n.convertEip1193RequestToJsonRpcRequest=l;class d extends c.default{constructor({engine:e}){super(),r.set(this,void 0),this.sendAsync=(e,t)=>{const n=l(e);i(this,r,"f").handle(n,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const n=l(e);i(this,r,"f").handle(n,t)},s(this,r,e,"f"),e.on&&e.on("notification",e=>{this.emit("data",null,e)})}async request(e){const t=l(e),n=await i(this,r,"f").handle(t);if("result"in n)return n.result;const s=new o.JsonRpcError(n.error.code,n.error.message,n.error.data);throw"stack"in n.error&&(s.stack=n.error.stack),s}}n.SafeEventEmitterProvider=d,r=new WeakMap}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"}],[1681,{"./qr-keyring.cjs":1685,"@ethereumjs/rlp":524,"@ethereumjs/tx":537,"@ethereumjs/util":551,"@keystonehq/bc-ur-registry-eth":1688,"@metamask/utils":2656,buffer:3614,hdkey:4161,uuid:1746},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r,s,i,a,o,c,u=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},l=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},d=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.Device=n.DeviceMode=n.SUPPORTED_UR_TYPE=void 0;const m=e("@ethereumjs/rlp"),h=e("@ethereumjs/tx"),f=e("@ethereumjs/util"),p=e("@keystonehq/bc-ur-registry-eth"),y=e("@metamask/utils"),g=d(e("hdkey")),b=e("uuid"),v=e("./qr-keyring.cjs");var k;n.SUPPORTED_UR_TYPE={CRYPTO_HDKEY:"crypto-hdkey",CRYPTO_ACCOUNT:"crypto-account",ETH_SIGNATURE:"eth-signature"},function(e){e.HD="hd",e.ACCOUNT="account"}(k||(n.DeviceMode=k={}));function E(e){return e instanceof p.CryptoAccount?e.getMasterFingerprint()?.toString("hex"):e.getOrigin()?.getSourceFingerprint()?.toString("hex")}n.Device=class{constructor({requestScan:e,source:t}){r.add(this),s.set(this,void 0),i.set(this,void 0),u(this,s,e,"f"),u(this,i,"string"==typeof t||"cbor"in t?l(this,r,"m",a).call(this,t):t,"f")}addressFromIndex(e){if(l(this,i,"f").keyringMode===k.ACCOUNT){const t=Object.keys(l(this,i,"f").paths)[e];if(!t)throw new Error(`Address not found for index ${e}`);return(0,y.add0x)(t)}const n=`m/${l(this,i,"f").childrenPath.replace("*",e.toString())}`,r=g.default.fromExtendedKey(l(this,i,"f").xpub).derive(n),s=t.from((0,f.publicToAddress)(r.publicKey,!0)).toString("hex"),a=(0,y.getChecksumAddress)((0,y.add0x)(s));return l(this,i,"f").indexes[a]=e,a}pathFromAddress(e){const t=(0,y.getChecksumAddress)((0,y.add0x)(e));if(l(this,i,"f").keyringMode===k.ACCOUNT){const e=l(this,i,"f").paths[t];if(e===undefined)throw new Error(`Unknown address ${t}`);return e}let n=l(this,i,"f").indexes[t];if(n===undefined){for(let e=0;e<1e3;e++){if(this.addressFromIndex(e)===t){n=e;break}}if(n===undefined)throw new Error(`Unknown address ${t}`)}return`${l(this,i,"f").hdPath}/${l(this,i,"f").childrenPath.replace("*",n.toString()).replace(/\*/gu,"0")}`}getAddressesPage(e,t=5){const n=e*t,r=n+t,s=[];for(let e=n;e<r;e++){const t=this.addressFromIndex(e);s.push({address:t,index:e})}return s}getDeviceDetails(){return l(this,i,"f")}async signTransaction(e,n){const s=n.type===h.TransactionType.Legacy?p.DataType.transaction:p.DataType.typedTransaction,a=n.getMessageToSign(),c=t.from(Array.isArray(a)?m.RLP.encode(a):a),u=(0,b.v4)(),d=p.EthSignRequest.constructETHRequest(c,s,this.pathFromAddress(e),l(this,i,"f").xfp,u,Number(n.common.chainId())).toUR(),{r:f,s:y,v:g}=await l(this,r,"m",o).call(this,{requestId:u,payload:{type:d.type,cbor:d.cbor.toString("hex")},requestTitle:"Scan with your hardware wallet",requestDescription:'After your device has signed this message, click on "Scan" to receive the signature'});return h.TransactionFactory.fromTxData({...n.toJSON(),r:f,s:y,v:g},{common:n.common})}async signTypedData(e,n){const s=(0,b.v4)(),a=p.EthSignRequest.constructETHRequest(t.from(JSON.stringify(n),"utf8"),p.DataType.typedData,this.pathFromAddress(e),l(this,i,"f").xfp,s,undefined,e).toUR(),{r:c,s:u,v:d}=await l(this,r,"m",o).call(this,{requestId:s,payload:{type:a.type,cbor:a.cbor.toString("hex")}});return(0,y.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(u),Uint8Array.from(d)]).toString("hex"))}async signPersonalMessage(e,n){const s=(0,b.v4)(),a=p.EthSignRequest.constructETHRequest(t.from((0,y.remove0x)(n),"hex"),p.DataType.personalMessage,this.pathFromAddress(e),l(this,i,"f").xfp,s,undefined,e).toUR(),{r:c,s:u,v:d}=await l(this,r,"m",o).call(this,{requestId:s,payload:{type:a.type,cbor:a.cbor.toString("hex")}});return(0,y.add0x)(t.concat([Uint8Array.from(c),Uint8Array.from(u),Uint8Array.from(d)]).toString("hex"))}},s=new WeakMap,i=new WeakMap,r=new WeakSet,a=function(e){const n=l(this,r,"m",c).call(this,e),s=E(n);if(n instanceof p.CryptoAccount){const{name:e,xfp:r,paths:s,keyringAccount:i}=function(e){const n=e.getOutputDescriptors();if(!n||0===n.length)throw new Error("No output descriptors found in CryptoAccount");let r="",s="";return{paths:n.reduce((e,n)=>{const i=n.getHDKey();if(i){const n=`M/${i.getOrigin().getPath()}`;e[(0,y.getChecksumAddress)((0,y.add0x)(t.from((0,f.publicToAddress)(i.getKey(),!0)).toString("hex")))]=n,r=i.getName(),s=i.getNote()}return e},{}),name:r,keyringAccount:s,xfp:E(e)}}(n);return{keyringMode:k.ACCOUNT,keyringAccount:i,name:e,xfp:r,paths:s,indexes:{}}}const{getBip32Key:i,getOrigin:a,getChildren:o,getName:u,getNote:d}=n;return{keyringMode:k.HD,keyringAccount:d(),name:u(),xfp:s,hdPath:`m/${a().getPath()}`,childrenPath:o()?.getPath()||"0/*",xpub:i(),indexes:{}}},o=async function(e){const n=await l(this,s,"f").call(this,{type:v.QrScanRequestType.SIGN,request:e}),r=p.ETHSignature.fromCBOR(t.from(n.cbor,"hex")),i=r.getSignature(),a=r.getRequestId();if(!a)throw new Error("Signature request ID is missing.");if(e.requestId!==(0,b.stringify)(a))throw new Error(`Signature request ID mismatch. Expected: ${e.requestId}, received: ${a.toString("hex")}`);return{r:i.subarray(0,32),s:i.subarray(32,64),v:i.subarray(64)}},c=function(e){const r="string"==typeof e?p.URRegistryDecoder.decode(e):{type:e.type,cbor:t.from(e.cbor,"hex")},{type:s,cbor:i}=r;switch(s){case n.SUPPORTED_UR_TYPE.CRYPTO_HDKEY:return p.CryptoHDKey.fromCBOR(i);case n.SUPPORTED_UR_TYPE.CRYPTO_ACCOUNT:return p.CryptoAccount.fromCBOR(i);default:throw new Error("Unsupported UR type")}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/device.cjs"}],[1682,{"./qr-keyring-deferred-promise-bridge.cjs":1683,"./qr-keyring-scanner-bridge.cjs":1684,"./qr-keyring.cjs":1685},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.QrScanRequestType=n.QR_KEYRING_TYPE=n.QrKeyring=n.QrKeyringDeferredPromiseBridge=n.QrKeyringScannerBridge=void 0;var r=e("./qr-keyring-scanner-bridge.cjs");Object.defineProperty(n,"QrKeyringScannerBridge",{enumerable:!0,get:function(){return r.QrKeyringScannerBridge}});var s=e("./qr-keyring-deferred-promise-bridge.cjs");Object.defineProperty(n,"QrKeyringDeferredPromiseBridge",{enumerable:!0,get:function(){return s.QrKeyringDeferredPromiseBridge}});var i=e("./qr-keyring.cjs");Object.defineProperty(n,"QrKeyring",{enumerable:!0,get:function(){return i.QrKeyring}}),Object.defineProperty(n,"QR_KEYRING_TYPE",{enumerable:!0,get:function(){return i.QR_KEYRING_TYPE}}),Object.defineProperty(n,"QrScanRequestType",{enumerable:!0,get:function(){return i.QrScanRequestType}})}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/index.cjs"}],[1683,{"@metamask/utils":2656,"async-mutex":3439},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},u=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyringDeferredPromiseBridge=void 0;const l=e("@metamask/utils"),d=e("async-mutex");n.QrKeyringDeferredPromiseBridge=class{constructor({onScanRequested:e,onScanResolved:t,onScanRejected:n}={}){r.set(this,new d.Mutex),s.set(this,void 0),i.set(this,void 0),a.set(this,void 0),o.set(this,void 0),c(this,s,e,"f"),c(this,i,t,"f"),c(this,a,n,"f")}async requestScan(e){return u(this,r,"f").runExclusive(async()=>{const t=(0,l.createDeferredPromise)();return c(this,o,t,"f"),u(this,s,"f")?.call(this,e),t.promise})}resolvePendingScan(e){if(!u(this,o,"f"))throw new Error("No pending scan to resolve.");u(this,o,"f").resolve(e),c(this,o,null,"f"),u(this,i,"f")?.call(this,e)}rejectPendingScan(e){if(!u(this,o,"f"))throw new Error("No pending scan to reject.");u(this,o,"f").reject(e),c(this,o,null,"f"),u(this,a,"f")?.call(this,e)}},r=new WeakMap,s=new WeakMap,i=new WeakMap,a=new WeakMap,o=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-deferred-promise-bridge.cjs"}],[1684,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyringScannerBridge=void 0;n.QrKeyringScannerBridge=class{constructor({requestScan:e}){r.set(this,void 0),s(this,r,e,"f")}async requestScan(e){return i(this,r,"f").call(this,e)}},r=new WeakMap}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring-scanner-bridge.cjs"}],[1685,{"./device.cjs":1681,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c,u=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},l=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.QrKeyring=n.getDefaultSerializedQrKeyringState=n.QrScanRequestType=n.QR_KEYRING_TYPE=void 0;const d=e("@metamask/utils"),m=e("./device.cjs");var h;n.QR_KEYRING_TYPE="QR Hardware Wallet Device",function(e){e.PAIR="pair",e.SIGN="sign"}(h||(n.QrScanRequestType=h={}));function f(e){return(0,d.getChecksumAddress)((0,d.add0x)(e))}n.getDefaultSerializedQrKeyringState=()=>({initialized:!1,accounts:[]});class p{constructor(e){r.add(this),this.type=n.QR_KEYRING_TYPE,s.set(this,void 0),i.set(this,[]),a.set(this,void 0),o.set(this,0),this.bridge=e.bridge,e?.ur&&this.pairDevice(e.ur)}async serialize(){const e=u(this,s,"f")?u(this,s,"f").getDeviceDetails():undefined;return e&&[m.DeviceMode.HD,m.DeviceMode.ACCOUNT].includes(e.keyringMode)?{...e,initialized:!0,accounts:u(this,i,"f").slice()}:(0,n.getDefaultSerializedQrKeyringState)()}async deserialize(e){if(!e.initialized)return l(this,i,[],"f"),void l(this,s,undefined,"f");l(this,s,new m.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f"),l(this,i,(e.accounts??[]).map(f),"f")}async addAccounts(e){if(!u(this,s,"f"))throw new Error("No device paired.");const t=[];for(let n=0;n<e;n++){const e=u(this,a,"f")??u(this,i,"f").length+n,r=u(this,s,"f").addressFromIndex(e);this.setAccountToUnlock(e+1),u(this,i,"f").includes(r)||(u(this,i,"f").push(r),t.push(r))}return t}async getAccounts(){return u(this,i,"f").slice()}removeAccount(e){const t=f(e);l(this,i,u(this,i,"f").filter(e=>e!==t),"f")}pairDevice(e){l(this,s,new m.Device({requestScan:this.bridge.requestScan.bind(this.bridge),source:e}),"f")}setAccountToUnlock(e){l(this,a,e,"f")}getName(){if(!u(this,s,"f"))return n.QR_KEYRING_TYPE;return u(this,s,"f").getDeviceDetails().name}async getFirstPage(){return l(this,o,0,"f"),this.getCurrentPage()}async getNextPage(){return l(this,o,u(this,o,"f")+1,"f"),this.getCurrentPage()}async getPreviousPage(){return u(this,o,"f")>0?l(this,o,u(this,o,"f")-1,"f"):l(this,o,0,"f"),this.getCurrentPage()}async getCurrentPage(){return u(this,s,"f")||await u(this,r,"m",c).call(this),(0,d.assert)(u(this,s,"f"),"A device is expected to be paired before fetching accounts."),u(this,s,"f").getAddressesPage(u(this,o,"f"))}async forgetDevice(){l(this,s,undefined,"f"),l(this,i,[],"f"),l(this,a,undefined,"f"),l(this,o,0,"f")}async signTransaction(e,t){if(!u(this,s,"f"))throw new Error("No device paired.");return u(this,s,"f").signTransaction(e,t)}async signTypedData(e,t){if(!u(this,s,"f"))throw new Error("No device paired.");return u(this,s,"f").signTypedData(e,t)}async signPersonalMessage(e,t){if(!u(this,s,"f"))throw new Error("No device paired.");return u(this,s,"f").signPersonalMessage(e,t)}}n.QrKeyring=p,s=new WeakMap,i=new WeakMap,a=new WeakMap,o=new WeakMap,r=new WeakSet,c=async function(){this.pairDevice(await this.bridge.requestScan({type:h.PAIR}))},p.type=n.QR_KEYRING_TYPE}}},{package:"@metamask/eth-qr-keyring",file:"node_modules/@metamask/eth-qr-keyring/dist/qr-keyring.cjs"}],[1686,{"@ethereumjs/util":1697,"@keystonehq/bc-ur-registry":1739,buffer:3614,hdkey:4161,uuid:1705},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0});var r,s=e("@keystonehq/bc-ur-registry"),i=e("uuid"),a=(r=e("hdkey"))&&"object"==typeof r&&"default"in r?r.default:r,o=e("@ethereumjs/util");const c={ETH_SIGN_REQUEST:new s.RegistryType("eth-sign-request",401),ETH_SIGNATURE:new s.RegistryType("eth-signature",402),ETH_NFT_ITEM:new s.RegistryType("eth-nft-item",403)},{decodeToDataItem:u,RegistryTypes:l}=s.extend;var d,m;!function(e){e[e.requestId=1]="requestId",e[e.signData=2]="signData",e[e.dataType=3]="dataType",e[e.chainId=4]="chainId",e[e.derivationPath=5]="derivationPath",e[e.address=6]="address",e[e.origin=7]="origin"}(d||(d={})),(m=n.DataType||(n.DataType={}))[m.transaction=1]="transaction",m[m.typedData=2]="typedData",m[m.personalMessage=3]="personalMessage",m[m.typedTransaction=4]="typedTransaction";class h extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_SIGN_REQUEST,this.getRequestId=()=>this.requestId,this.getSignData=()=>this.signData,this.getDataType=()=>this.dataType,this.getChainId=()=>this.chainId,this.getDerivationPath=()=>this.derivationPath.getPath(),this.getSourceFingerprint=()=>this.derivationPath.getSourceFingerprint(),this.getSignRequestAddress=()=>this.address,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};this.requestId&&(e[d.requestId]=new s.DataItem(this.requestId,l.UUID.getTag())),this.address&&(e[d.address]=this.address),this.chainId&&(e[d.chainId]=Number(this.chainId)),this.origin&&(e[d.origin]=this.origin),e[d.signData]=this.signData,e[d.dataType]=this.dataType;const t=this.derivationPath.toDataItem();return t.setTag(this.derivationPath.getRegistryType().getTag()),e[d.derivationPath]=t,new s.DataItem(e)},this.requestId=e.requestId,this.signData=e.signData,this.dataType=e.dataType,this.chainId=e.chainId,this.derivationPath=e.derivationPath,this.address=e.address,this.origin=e.origin}static constructETHRequest(e,n,r,a,o,c,u,l){const d=r.replace(/[m|M]\//,"").split("/"),m=new s.CryptoKeypath(d.map(e=>{const t=parseInt(e.replace("'",""));let n=!1;return e.endsWith("'")&&(n=!0),new s.PathComponent({index:t,hardened:n})}),t.from(a,"hex"));return new h({requestId:o?t.from(i.parse(o)):undefined,signData:e,dataType:n,derivationPath:m,chainId:c,address:u?t.from(u.replace("0x",""),"hex"):undefined,origin:l||undefined})}}h.fromDataItem=e=>{const t=e.getData(),n=t[d.signData],r=t[d.dataType],i=s.CryptoKeypath.fromDataItem(t[d.derivationPath]),a=t[d.chainId]?t[d.chainId]:undefined,o=t[d.address]?t[d.address]:undefined,c=t[d.requestId]?t[d.requestId].getData():undefined,u=t[d.origin]?t[d.origin]:undefined;return new h({requestId:c,signData:n,dataType:r,chainId:a,derivationPath:i,address:o,origin:u})},h.fromCBOR=e=>{const t=u(e);return h.fromDataItem(t)};const{RegistryTypes:f,decodeToDataItem:p}=s.extend;var y;!function(e){e[e.requestId=1]="requestId",e[e.signature=2]="signature",e[e.origin=3]="origin"}(y||(y={}));class g extends s.RegistryItem{constructor(e,t,n){super(),this.getRegistryType=()=>c.ETH_SIGNATURE,this.getRequestId=()=>this.requestId,this.getSignature=()=>this.signature,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};return this.requestId&&(e[y.requestId]=new s.DataItem(this.requestId,f.UUID.getTag())),this.origin&&(e[y.origin]=this.origin),e[y.signature]=this.signature,new s.DataItem(e)},this.signature=e,this.requestId=t,this.origin=n}}g.fromDataItem=e=>{const t=e.getData(),n=t[y.signature],r=t[y.requestId]?t[y.requestId].getData():undefined;return new g(n,r,t[y.origin])},g.fromCBOR=e=>{const t=p(e);return g.fromDataItem(t)};const{decodeToDataItem:b}=s.extend;var v;!function(e){e[e.chainId=1]="chainId",e[e.contractAddress=2]="contractAddress",e[e.contractName=3]="contractName",e[e.name=4]="name",e[e.mediaData=5]="mediaData"}(v||(v={}));class k extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_NFT_ITEM,this.getChainId=()=>this.chainId,this.getName=()=>this.name,this.getmediaData=()=>this.mediaData,this.getContractAddress=()=>this.contractAddress,this.getContractName=()=>this.contractName,this.toDataItem=()=>{const e={};return e[v.chainId]=this.chainId,e[v.name]=this.name,e[v.contractAddress]=this.contractAddress,e[v.contractName]=this.contractName,e[v.mediaData]=this.mediaData,new s.DataItem(e)},this.chainId=e.chainId,this.name=e.name,this.contractAddress=e.contractAddress,this.contractName=e.contractName,this.mediaData=e.mediaData}static constructETHNFTItem(e,t,n,r,s){return new k({chainId:e,contractAddress:t,contractName:n,mediaData:s,name:r})}}k.fromDataItem=e=>{const t=e.getData(),n=t[v.chainId],r=t[v.name],s=t[v.mediaData],i=t[v.contractAddress],a=t[v.contractName];return new k({chainId:n,name:r,contractAddress:i,contractName:a,mediaData:s})},k.fromCBOR=e=>{const t=b(e);return k.fromDataItem(t)};const E=(e,t)=>{const n=a.fromExtendedKey(e).derive(t),r="0x"+o.publicToAddress(n.publicKey,!0).toString("hex");return o.toChecksumAddress(r)};s.patchTags(Object.values(c).filter(e=>!!e.getTag()).map(e=>e.getTag())),Object.keys(s).forEach(function(e){"default"!==e&&Object.defineProperty(n,e,{enumerable:!0,get:function(){return s[e]}})}),n.ETHNFTItem=k,n.ETHSignature=g,n.EthSignRequest=h,n.findHDPathFromAddress=(e,t,n,r)=>{for(let s=0;s<n;s++){const n=E(t,`M/0/${s}`);if(e.toLowerCase()==n.toLowerCase())return`${r}/0/${s}`}return null},n.generateAddressFromXpub=E}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.development.js"}],[1687,{"@ethereumjs/util":1697,"@keystonehq/bc-ur-registry":1739,buffer:3614,hdkey:4161,uuid:1705},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0});var r,s=e("@keystonehq/bc-ur-registry"),i=e("uuid"),a=(r=e("hdkey"))&&"object"==typeof r&&"default"in r?r.default:r,o=e("@ethereumjs/util");const c={ETH_SIGN_REQUEST:new s.RegistryType("eth-sign-request",401),ETH_SIGNATURE:new s.RegistryType("eth-signature",402),ETH_NFT_ITEM:new s.RegistryType("eth-nft-item",403)},{decodeToDataItem:u,RegistryTypes:l}=s.extend;var d,m;!function(e){e[e.requestId=1]="requestId",e[e.signData=2]="signData",e[e.dataType=3]="dataType",e[e.chainId=4]="chainId",e[e.derivationPath=5]="derivationPath",e[e.address=6]="address",e[e.origin=7]="origin"}(d||(d={})),(m=n.DataType||(n.DataType={}))[m.transaction=1]="transaction",m[m.typedData=2]="typedData",m[m.personalMessage=3]="personalMessage",m[m.typedTransaction=4]="typedTransaction";class h extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_SIGN_REQUEST,this.getRequestId=()=>this.requestId,this.getSignData=()=>this.signData,this.getDataType=()=>this.dataType,this.getChainId=()=>this.chainId,this.getDerivationPath=()=>this.derivationPath.getPath(),this.getSourceFingerprint=()=>this.derivationPath.getSourceFingerprint(),this.getSignRequestAddress=()=>this.address,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};this.requestId&&(e[d.requestId]=new s.DataItem(this.requestId,l.UUID.getTag())),this.address&&(e[d.address]=this.address),this.chainId&&(e[d.chainId]=Number(this.chainId)),this.origin&&(e[d.origin]=this.origin),e[d.signData]=this.signData,e[d.dataType]=this.dataType;const t=this.derivationPath.toDataItem();return t.setTag(this.derivationPath.getRegistryType().getTag()),e[d.derivationPath]=t,new s.DataItem(e)},this.requestId=e.requestId,this.signData=e.signData,this.dataType=e.dataType,this.chainId=e.chainId,this.derivationPath=e.derivationPath,this.address=e.address,this.origin=e.origin}static constructETHRequest(e,n,r,a,o,c,u,l){const d=r.replace(/[m|M]\//,"").split("/"),m=new s.CryptoKeypath(d.map(e=>{const t=parseInt(e.replace("'",""));let n=!1;return e.endsWith("'")&&(n=!0),new s.PathComponent({index:t,hardened:n})}),t.from(a,"hex"));return new h({requestId:o?t.from(i.parse(o)):void 0,signData:e,dataType:n,derivationPath:m,chainId:c,address:u?t.from(u.replace("0x",""),"hex"):void 0,origin:l||void 0})}}h.fromDataItem=e=>{const t=e.getData(),n=t[d.signData],r=t[d.dataType],i=s.CryptoKeypath.fromDataItem(t[d.derivationPath]),a=t[d.chainId]?t[d.chainId]:void 0,o=t[d.address]?t[d.address]:void 0,c=t[d.requestId]?t[d.requestId].getData():void 0;return new h({requestId:c,signData:n,dataType:r,chainId:a,derivationPath:i,address:o,origin:t[d.origin]?t[d.origin]:void 0})},h.fromCBOR=e=>{const t=u(e);return h.fromDataItem(t)};const{RegistryTypes:f,decodeToDataItem:p}=s.extend;var y;!function(e){e[e.requestId=1]="requestId",e[e.signature=2]="signature",e[e.origin=3]="origin"}(y||(y={}));class g extends s.RegistryItem{constructor(e,t,n){super(),this.getRegistryType=()=>c.ETH_SIGNATURE,this.getRequestId=()=>this.requestId,this.getSignature=()=>this.signature,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};return this.requestId&&(e[y.requestId]=new s.DataItem(this.requestId,f.UUID.getTag())),this.origin&&(e[y.origin]=this.origin),e[y.signature]=this.signature,new s.DataItem(e)},this.signature=e,this.requestId=t,this.origin=n}}g.fromDataItem=e=>{const t=e.getData(),n=t[y.signature],r=t[y.requestId]?t[y.requestId].getData():void 0;return new g(n,r,t[y.origin])},g.fromCBOR=e=>{const t=p(e);return g.fromDataItem(t)};const{decodeToDataItem:b}=s.extend;var v;!function(e){e[e.chainId=1]="chainId",e[e.contractAddress=2]="contractAddress",e[e.contractName=3]="contractName",e[e.name=4]="name",e[e.mediaData=5]="mediaData"}(v||(v={}));class k extends s.RegistryItem{constructor(e){super(),this.getRegistryType=()=>c.ETH_NFT_ITEM,this.getChainId=()=>this.chainId,this.getName=()=>this.name,this.getmediaData=()=>this.mediaData,this.getContractAddress=()=>this.contractAddress,this.getContractName=()=>this.contractName,this.toDataItem=()=>{const e={};return e[v.chainId]=this.chainId,e[v.name]=this.name,e[v.contractAddress]=this.contractAddress,e[v.contractName]=this.contractName,e[v.mediaData]=this.mediaData,new s.DataItem(e)},this.chainId=e.chainId,this.name=e.name,this.contractAddress=e.contractAddress,this.contractName=e.contractName,this.mediaData=e.mediaData}static constructETHNFTItem(e,t,n,r,s){return new k({chainId:e,contractAddress:t,contractName:n,mediaData:s,name:r})}}k.fromDataItem=e=>{const t=e.getData();return new k({chainId:t[v.chainId],name:t[v.name],contractAddress:t[v.contractAddress],contractName:t[v.contractName],mediaData:t[v.mediaData]})},k.fromCBOR=e=>{const t=b(e);return k.fromDataItem(t)};const E=(e,t)=>{const n=a.fromExtendedKey(e).derive(t),r="0x"+o.publicToAddress(n.publicKey,!0).toString("hex");return o.toChecksumAddress(r)};s.patchTags(Object.values(c).filter(e=>!!e.getTag()).map(e=>e.getTag())),Object.keys(s).forEach(function(e){"default"!==e&&Object.defineProperty(n,e,{enumerable:!0,get:function(){return s[e]}})}),n.ETHNFTItem=k,n.ETHSignature=g,n.EthSignRequest=h,n.findHDPathFromAddress=(e,t,n,r)=>{for(let s=0;s<n;s++){const n=E(t,"M/0/"+s);if(e.toLowerCase()==n.toLowerCase())return`${r}/0/${s}`}return null},n.generateAddressFromXpub=E}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/bc-ur-registry-eth.cjs.production.min.js"}],[1688,{"./bc-ur-registry-eth.cjs.development.js":1686,"./bc-ur-registry-eth.cjs.production.min.js":1687},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=e("./bc-ur-registry-eth.cjs.production.min.js")}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/dist/index.js"}],[1689,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(Array.isArray(e)){const t=[];let n=0;for(let s=0;s<e.length;s++){const i=r(e[s]);t.push(i),n+=i.length}return h(a(n,192),...t)}const t=g(e);return 1===t.length&&t[0]<128?t:h(a(t.length,128),t)}function s(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function i(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return d(l(e))}function a(e,t){if(e<56)return Uint8Array.from([e+t]);const n=p(e),r=p(t+55+n.length/2);return Uint8Array.from(m(r+n))}function o(e,t=!1){if(null==e||0===e.length)return Uint8Array.from([]);const n=c(g(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function c(e){let t,n,r,a,o;const u=[],l=e[0];if(l<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(l<=183){if(t=l-127,r=128===l?Uint8Array.from([]):s(e,1,t),2===t&&r[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:r,remainder:e.slice(t)}}if(l<=191){if(n=l-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=i(s(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return r=s(e,n,t+n),{data:r,remainder:e.slice(t+n)}}if(l<=247){for(t=l-191,a=s(e,1,t);a.length;)o=c(a),u.push(o.data),a=o.remainder;return{data:u,remainder:e.slice(t)}}{if(n=l-246,t=i(s(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const r=n+t;if(r>e.length)throw new Error("invalid RLP: total length is larger than the data");for(a=s(e,n,r);a.length;)o=c(a),u.push(o.data),a=o.remainder;return{data:u,remainder:e.slice(r)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.RLP=n.utils=n.decode=n.encode=void 0,n.encode=r,n.decode=o;const u=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function l(e){let t="";for(let n=0;n<e.length;n++)t+=u[e[n]];return t}function d(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function m(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const r=2*n;t[n]=d(e.slice(r,r+2))}return t}function h(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,r=0;t<e.length;t++){const s=e[t];n.set(s,r),r+=s.length}return n}function f(e){return(new TextEncoder).encode(e)}function p(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function y(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function g(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return y(e)?m((t="string"!=typeof(n=e)?n:y(n)?n.slice(2):n).length%2?`0${t}`:t):f(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?m(p(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:l,concatBytes:h,hexToBytes:m,utf8ToBytes:f},n.RLP={encode:r,decode:o}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util>@ethereumjs/rlp",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/rlp/dist/index.js"}],[1690,{"./bytes":1693,"./constants":1694,"./helpers":1696,"./internal":1698,"@ethereumjs/rlp":1689,buffer:3614,"ethereum-cryptography/keccak":3842,"ethereum-cryptography/secp256k1":3863,"ethereum-cryptography/utils":3865},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.accountBodyToRLP=n.accountBodyToSlim=n.accountBodyFromSlim=n.isZeroAddress=n.zeroAddress=n.importPublic=n.privateToAddress=n.privateToPublic=n.publicToAddress=n.pubToAddress=n.isValidPublic=n.isValidPrivate=n.generateAddress2=n.generateAddress=n.isValidChecksumAddress=n.toChecksumAddress=n.isValidAddress=n.Account=void 0;const r=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),i=e("ethereum-cryptography/secp256k1"),a=e("ethereum-cryptography/utils"),o=e("./bytes"),c=e("./constants"),u=e("./helpers"),l=e("./internal"),d=BigInt(0);class m{constructor(e=d,t=d,n=c.KECCAK256_RLP,r=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=n,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:n,storageRoot:r,codeHash:s}=e;return new m(t!==undefined?(0,o.bufferToBigInt)((0,o.toBuffer)(t)):undefined,n!==undefined?(0,o.bufferToBigInt)((0,o.toBuffer)(n)):undefined,r!==undefined?(0,o.toBuffer)(r):undefined,s!==undefined?(0,o.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,o.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,n,r,s]=e;return new m((0,o.bufferToBigInt)(t),(0,o.bufferToBigInt)(n),r,s)}_validate(){if(this.nonce<d)throw new Error("nonce must be greater than zero");if(this.balance<d)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,o.bigIntToUnpaddedBuffer)(this.nonce),(0,o.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,o.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===d&&this.nonce===d&&this.codeHash.equals(c.KECCAK256_NULL)}}n.Account=m;n.isValidAddress=function(e){try{(0,u.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};n.toChecksumAddress=function(e,n){(0,u.assertIsHexString)(e);const r=(0,l.stripHexPrefix)(e).toLowerCase();let i="";if(n!==undefined){i=(0,o.bufferToBigInt)((0,o.toBuffer)(n)).toString()+"0x"}const c=t.from(i+r,"utf8"),d=(0,a.bytesToHex)((0,s.keccak256)(c));let m="0x";for(let e=0;e<r.length;e++)parseInt(d[e],16)>=8?m+=r[e].toUpperCase():m+=r[e];return m};n.isValidChecksumAddress=function(e,t){return(0,n.isValidAddress)(e)&&(0,n.toChecksumAddress)(e,t)===e};n.generateAddress=function(e,n){return(0,u.assertIsBuffer)(e),(0,u.assertIsBuffer)(n),(0,o.bufferToBigInt)(n)===BigInt(0)?t.from((0,s.keccak256)(r.RLP.encode((0,o.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(r.RLP.encode((0,o.bufArrToArr)([e,n])))).slice(-20)};n.generateAddress2=function(e,n,r){if((0,u.assertIsBuffer)(e),(0,u.assertIsBuffer)(n),(0,u.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==n.length)throw new Error("Expected salt to be of length 32");const i=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,n,(0,s.keccak256)(r)]));return(0,o.toBuffer)(i).slice(-20)};n.isValidPrivate=function(e){return i.secp256k1.utils.isValidPrivateKey(e)};n.isValidPublic=function(e,n=!1){if((0,u.assertIsBuffer)(e),64===e.length)try{return i.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!n)return!1;try{return i.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};n.pubToAddress=function(e,n=!1){if((0,u.assertIsBuffer)(e),n&&64!==e.length&&(e=t.from(i.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},n.publicToAddress=n.pubToAddress;n.privateToPublic=function(e){return(0,u.assertIsBuffer)(e),t.from(i.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};n.privateToAddress=function(e){return(0,n.publicToAddress)((0,n.privateToPublic)(e))};n.importPublic=function(e){return(0,u.assertIsBuffer)(e),64!==e.length&&(e=t.from(i.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};n.zeroAddress=function(){const e=(0,o.zeros)(20);return(0,o.bufferToHex)(e)};function h(e){const[t,n,r,s]=e;return[t,n,0===(0,o.arrToBufArr)(r).length?c.KECCAK256_RLP:r,0===(0,o.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}n.isZeroAddress=function(e){try{(0,u.assertIsString)(e)}catch(e){return!1}return(0,n.zeroAddress)()===e},n.accountBodyFromSlim=h;const f=new Uint8Array(0);n.accountBodyToSlim=function(e){const[t,n,r,s]=e;return[t,n,(0,o.arrToBufArr)(r).equals(c.KECCAK256_RLP)?f:r,(0,o.arrToBufArr)(s).equals(c.KECCAK256_NULL)?f:s]},n.accountBodyToRLP=function(e,t=!0){const n=t?h(e):e;return(0,o.arrToBufArr)(r.RLP.encode(n))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/account.js"}],[1691,{"./account":1690,"./bytes":1693,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Address=void 0;const r=e("./account"),s=e("./bytes");class i{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new i((0,s.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new i((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const n=(0,r.pubToAddress)(e);return new i(n)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const n=(0,r.privateToAddress)(e);return new i(n)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new i((0,r.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,n,s){if(!t.isBuffer(n))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new i((0,r.generateAddress2)(e.buf,n,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(i.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),n=BigInt("0xffff");return e>=t&&e<=n}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}n.Address=i}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/address.js"}],[1692,{events:3926},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncEventEmitter=void 0;const r=e("events");class s extends r.EventEmitter{emit(e,...t){let[n,r]=t;const s=this;let i=s._events[e]??[];return r===undefined&&"function"==typeof n&&(r=n,n=undefined),"newListener"!==e&&"removeListener"!==e||(n={event:n,fn:r},r=undefined),i=Array.isArray(i)?i:[i],async function(e,t,n){let r;for await(const s of t)try{s.length<2?s.call(e,n):await new Promise((t,r)=>{s.call(e,n,e=>{e?r(e):t()})})}catch(e){r=e}if(r)throw r}(s,i.slice(),n).then(r).catch(r),s.listenerCount(e)>0}once(e,t){const n=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(s,i){n.removeListener(e,r),t(s,i)}:function(s){n.removeListener(e,r),t(s,r)},n.on(e,r),n}first(e,t){let n=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(n)||(this._events[e]=n=[n]),n.unshift(t),this}before(e,t,n){return this.beforeOrAfter(e,t,n)}after(e,t,n){return this.beforeOrAfter(e,t,n,"after")}beforeOrAfter(e,t,n,r){let s,i,a=this._events[e]??[];const o="after"===r?1:0;if("function"!=typeof n)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(a)||(this._events[e]=a=[a]),i=a.length,s=a.length;s--;)if(a[s]===t){i=s+o;break}return a.splice(i,0,n),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}n.AsyncEventEmitter=s}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],[1693,{"./helpers":1696,"./internal":1698,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.intToUnpaddedBuffer=n.bigIntToUnpaddedBuffer=n.bigIntToHex=n.bufArrToArr=n.arrToBufArr=n.validateNoLeadingZeroes=n.baToJSON=n.toUtf8=n.short=n.addHexPrefix=n.toUnsigned=n.fromSigned=n.bufferToInt=n.bigIntToBuffer=n.bufferToBigInt=n.bufferToHex=n.toBuffer=n.unpadHexString=n.unpadArray=n.unpadBuffer=n.setLengthRight=n.setLengthLeft=n.zeros=n.intToBuffer=n.intToHex=void 0;const r=e("./helpers"),s=e("./internal");n.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};n.intToBuffer=function(e){const r=(0,n.intToHex)(e);return t.from((0,s.padToEven)(r.slice(2)),"hex")};n.zeros=function(e){return t.allocUnsafe(e).fill(0)};const i=function(e,t,r){const s=(0,n.zeros)(t);return r?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};n.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),i(e,t,!1)};n.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),i(e,t,!0)};const a=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};n.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),a(e)};n.unpadArray=function(e){return(0,r.assertIsArray)(e),a(e)};n.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+a(e)};n.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,n.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let n=e.toString(16);return n.length%2&&(n="0"+n),t.from(n,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function o(e){const t=(0,n.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,n.toBuffer)("0x"+e.toString(16))}n.bufferToHex=function(e){return"0x"+(e=(0,n.toBuffer)(e)).toString("hex")},n.bufferToBigInt=o,n.bigIntToBuffer=c;n.bufferToInt=function(e){const t=Number(o(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};n.fromSigned=function(e){return BigInt.asIntN(256,o(e))};n.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};n.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},n.short=function(e,n=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=n?r:r.slice(0,n)+"…"};n.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};n.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,n.baToJSON)(e[r]));return t}};n.validateNoLeadingZeroes=function(e){for(const[t,n]of Object.entries(e))if(n!==undefined&&n.length>0&&0===n[0])throw new Error(`${t} cannot have leading zeroes, received: ${n.toString("hex")}`)},n.arrToBufArr=function e(n){return Array.isArray(n)?n.map(t=>e(t)):t.from(n)},n.bufArrToArr=function e(t){return Array.isArray(t)?t.map(t=>e(t)):Uint8Array.from(t??[])};n.bigIntToHex=e=>"0x"+e.toString(16),n.bigIntToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)(c(e))},n.intToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)((0,n.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/bytes.js"}],[1694,{buffer:3614,"ethereum-cryptography/secp256k1":3863},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAX_WITHDRAWALS_PER_PAYLOAD=n.RLP_EMPTY_STRING=n.KECCAK256_RLP=n.KECCAK256_RLP_S=n.KECCAK256_RLP_ARRAY=n.KECCAK256_RLP_ARRAY_S=n.KECCAK256_NULL=n.KECCAK256_NULL_S=n.TWO_POW256=n.SECP256K1_ORDER_DIV_2=n.SECP256K1_ORDER=n.MAX_INTEGER_BIGINT=n.MAX_INTEGER=n.MAX_UINT64=void 0;const r=e("buffer"),s=e("ethereum-cryptography/secp256k1");n.MAX_UINT64=BigInt("0xffffffffffffffff"),n.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),n.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),n.SECP256K1_ORDER=s.secp256k1.CURVE.n,n.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),n.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),n.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",n.KECCAK256_NULL=r.Buffer.from(n.KECCAK256_NULL_S,"hex"),n.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",n.KECCAK256_RLP_ARRAY=r.Buffer.from(n.KECCAK256_RLP_ARRAY_S,"hex"),n.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",n.KECCAK256_RLP=r.Buffer.from(n.KECCAK256_RLP_S,"hex"),n.RLP_EMPTY_STRING=r.Buffer.from([128]),n.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/constants.js"}],[1695,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compactBytesToNibbles=n.bytesToNibbles=n.nibblesToCompactBytes=n.nibblesToBytes=n.hasTerminator=void 0;n.hasTerminator=e=>e.length>0&&16===e[e.length-1];n.nibblesToBytes=(e,t)=>{for(let n=0,r=0;r<e.length;n+=1,r+=2)t[n]=e[r]<<4|e[r+1]};n.nibblesToCompactBytes=e=>{let t=0;(0,n.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,n.nibblesToBytes)(e,r.subarray(1)),r};n.bytesToNibbles=e=>{const t=2*e.length+1,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];n[2*t]=r/16,n[2*t+1]=r%16}return n[t-1]=16,n};n.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,n.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/encoding.js"}],[1696,{"../../../../../../../../../is-buffer/index.js":4189,"./internal":1698},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.assertIsString=n.assertIsArray=n.assertIsBuffer=n.assertIsHexString=void 0;const r=e("./internal");n.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};n.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};n.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};n.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/helpers.js"}],[1697,{"./account":1690,"./address":1691,"./asyncEventEmitter":1692,"./bytes":1693,"./constants":1694,"./encoding":1695,"./internal":1698,"./lock":1699,"./provider":1700,"./signature":1701,"./types":1702,"./units":1703,"./withdrawal":1704},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.toAscii=n.stripHexPrefix=n.padToEven=n.isHexString=n.isHexPrefixed=n.getKeys=n.getBinarySize=n.fromUtf8=n.fromAscii=n.arrayContainsArray=void 0,s(e("./constants"),n),s(e("./units"),n),s(e("./account"),n),s(e("./address"),n),s(e("./withdrawal"),n),s(e("./signature"),n),s(e("./bytes"),n),s(e("./types"),n),s(e("./encoding"),n),s(e("./asyncEventEmitter"),n);var i=e("./internal");Object.defineProperty(n,"arrayContainsArray",{enumerable:!0,get:function(){return i.arrayContainsArray}}),Object.defineProperty(n,"fromAscii",{enumerable:!0,get:function(){return i.fromAscii}}),Object.defineProperty(n,"fromUtf8",{enumerable:!0,get:function(){return i.fromUtf8}}),Object.defineProperty(n,"getBinarySize",{enumerable:!0,get:function(){return i.getBinarySize}}),Object.defineProperty(n,"getKeys",{enumerable:!0,get:function(){return i.getKeys}}),Object.defineProperty(n,"isHexPrefixed",{enumerable:!0,get:function(){return i.isHexPrefixed}}),Object.defineProperty(n,"isHexString",{enumerable:!0,get:function(){return i.isHexString}}),Object.defineProperty(n,"padToEven",{enumerable:!0,get:function(){return i.padToEven}}),Object.defineProperty(n,"stripHexPrefix",{enumerable:!0,get:function(){return i.stripHexPrefix}}),Object.defineProperty(n,"toAscii",{enumerable:!0,get:function(){return i.toAscii}}),s(e("./lock"),n),s(e("./provider"),n)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/index.js"}],[1698,{buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(n,"__esModule",{value:!0}),n.isHexString=n.getKeys=n.fromAscii=n.fromUtf8=n.toAscii=n.arrayContainsArray=n.getBinarySize=n.padToEven=n.stripHexPrefix=n.isHexPrefixed=void 0,n.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}n.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},n.padToEven=r,n.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},n.arrayContainsArray=function(e,t,n){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===n?"some":"every"](t=>e.indexOf(t)>=0)},n.toAscii=function(e){let t="",n=0;const r=e.length;for("0x"===e.substring(0,2)&&(n=2);n<r;n+=2){const r=parseInt(e.substr(n,2),16);t+=String.fromCharCode(r)}return t},n.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},n.fromAscii=function(e){let t="";for(let n=0;n<e.length;n++){const r=e.charCodeAt(n).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},n.getKeys=function(e,t,n){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let s=0;s<e.length;s++){let i=e[s][t];if(!0!==n||i){if("string"!=typeof i)throw new Error("invalid abi - expected type 'string', received "+typeof i)}else i="";r.push(i)}return r},n.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/internal.js"}],[1699,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Lock=void 0;n.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise(e=>this.promiseResolverQueue.push(e))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/lock.js"}],[170,{"../../../../shared/modules/hexstring-utils":5386,"@metamask/eth-sig-util":1764,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isEthAddress=a,n.normalizeAddress=function(e){return a(e)?(0,s.normalize)(e):e},n.normalizeSafeAddress=function(e){return a(e)?(0,i.toChecksumHexAddress)(e):e};var r=e("@metamask/utils"),s=e("@metamask/eth-sig-util"),i=e("../../../../shared/modules/hexstring-utils");function a(e){return(0,r.isValidHexAddress)(e)}}}},{package:"$root$",file:"app/scripts/lib/multichain/address.ts"}],[1700,{"micro-ftch":4446},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getProvider=n.fetchFromProvider=void 0;const r=e("micro-ftch");n.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;n.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/provider.js"}],[1701,{"./bytes":1693,"./constants":1694,"./helpers":1696,buffer:3614,"ethereum-cryptography/keccak":3842,"ethereum-cryptography/secp256k1":3863},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashPersonalMessage=n.isValidSignature=n.fromRpcSig=n.toCompactSig=n.toRpcSig=n.ecrecover=n.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),i=e("./bytes"),a=e("./constants"),o=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function u(e){return e===BigInt(0)||e===BigInt(1)}n.ecsign=function(e,n,r){const i=s.secp256k1.sign(e,n),a=i.toCompactRawBytes();return{r:t.from(a.slice(0,32)),s:t.from(a.slice(32,64)),v:r===undefined?BigInt(i.recovery+27):BigInt(i.recovery+35)+BigInt(r)*BigInt(2)}};n.ecrecover=function(e,n,r,a,o){const l=t.concat([(0,i.setLengthLeft)(r,32),(0,i.setLengthLeft)(a,32)],64),d=c(n,o);if(!u(d))throw new Error("Invalid signature v value");const m=s.secp256k1.Signature.fromCompact(l).addRecoveryBit(Number(d)).recoverPublicKey(e);return t.from(m.toRawBytes(!1).slice(1))};n.toRpcSig=function(e,n,r,s){if(!u(c(e,s)))throw new Error("Invalid signature v value");return(0,i.bufferToHex)(t.concat([(0,i.setLengthLeft)(n,32),(0,i.setLengthLeft)(r,32),(0,i.toBuffer)(e)]))};n.toCompactSig=function(e,n,r,s){if(!u(c(e,s)))throw new Error("Invalid signature v value");let a=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(a=t.from(r),a[0]|=128),(0,i.bufferToHex)(t.concat([(0,i.setLengthLeft)(n,32),(0,i.setLengthLeft)(a,32)]))};n.fromRpcSig=function(e){const t=(0,i.toBuffer)(e);let n,r,s;if(t.length>=65)n=t.slice(0,32),r=t.slice(32,64),s=(0,i.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");n=t.slice(0,32),r=t.slice(32,64),s=BigInt((0,i.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:n,s:r}};n.isValidSignature=function(e,t,n,r=!0,s){if(32!==t.length||32!==n.length)return!1;if(!u(c(e,s)))return!1;const o=(0,i.bufferToBigInt)(t),l=(0,i.bufferToBigInt)(n);return!(o===BigInt(0)||o>=a.SECP256K1_ORDER||l===BigInt(0)||l>=a.SECP256K1_ORDER)&&!(r&&l>=a.SECP256K1_ORDER_DIV_2)};n.hashPersonalMessage=function(e){(0,o.assertIsBuffer)(e);const n=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([n,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/signature.js"}],[1702,{"./bytes":1693,"./internal":1698},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toType=n.TypeOutput=void 0;const r=e("./bytes"),s=e("./internal");var i;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(i=n.TypeOutput||(n.TypeOutput={})),n.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const n=(0,r.toBuffer)(e);switch(t){case i.Buffer:return n;case i.BigInt:return(0,r.bufferToBigInt)(n);case i.Number:{const e=(0,r.bufferToBigInt)(n);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case i.PrefixedHexString:return(0,r.bufferToHex)(n);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/types.js"}],[1703,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.GWEI_TO_WEI=void 0,n.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/units.js"}],[1704,{"./address":1691,"./bytes":1693,"./types":1702,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Withdrawal=void 0;const r=e("./address"),s=e("./bytes"),i=e("./types");class a{constructor(e,t,n,r){this.index=e,this.validatorIndex=t,this.address=n,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:n,address:s,amount:o}=e,c=(0,i.toType)(t,i.TypeOutput.BigInt),u=(0,i.toType)(n,i.TypeOutput.BigInt),l=new r.Address((0,i.toType)(s,i.TypeOutput.Buffer)),d=(0,i.toType)(o,i.TypeOutput.BigInt);return new a(c,u,l,d)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,n,r,s]=e;return a.fromWithdrawalData({index:t,validatorIndex:n,address:r,amount:s})}static toBufferArray(e){const{index:n,validatorIndex:s,address:a,amount:o}=e,c=(0,i.toType)(n,i.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,i.toType)(n,i.TypeOutput.Buffer),u=(0,i.toType)(s,i.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,i.toType)(s,i.TypeOutput.Buffer);let l;l=a instanceof r.Address?a.buf:(0,i.toType)(a,i.TypeOutput.Buffer);return[c,u,l,(0,i.toType)(o,i.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,i.toType)(o,i.TypeOutput.Buffer)]}raw(){return a.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}n.Withdrawal=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@ethereumjs/util",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/@ethereumjs/util/dist/withdrawal.js"}],[1705,{"./nil.js":1707,"./parse.js":1708,"./stringify.js":1712,"./v1.js":1713,"./v3.js":1714,"./v4.js":1716,"./v5.js":1717,"./validate.js":1718,"./version.js":1719},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return l.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return d.default}});var r=m(e("./v1.js")),s=m(e("./v3.js")),i=m(e("./v4.js")),a=m(e("./v5.js")),o=m(e("./nil.js")),c=m(e("./version.js")),u=m(e("./validate.js")),l=m(e("./stringify.js")),d=m(e("./parse.js"));function m(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/index.js"}],[1706,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return 14+(e+64>>>9<<4)+1}function s(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function i(e,t,n,r,i,a){return s((o=s(s(t,e),s(r,a)))<<(c=i)|o>>>32-c,n);var o,c}function a(e,t,n,r,s,a,o){return i(t&n|~t&r,e,t,s,a,o)}function o(e,t,n,r,s,a,o){return i(t&r|n&~r,e,t,s,a,o)}function c(e,t,n,r,s,a,o){return i(t^n^r,e,t,s,a,o)}function u(e,t,n,r,s,a,o){return i(n^(t|~r),e,t,s,a,o)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var l=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,r="0123456789abcdef";for(let s=0;s<n;s+=8){const n=e[s>>5]>>>s%32&255,i=parseInt(r.charAt(n>>>4&15)+r.charAt(15&n),16);t.push(i)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[r(t)-1]=t;let n=1732584193,i=-271733879,l=-1732584194,d=271733878;for(let t=0;t<e.length;t+=16){const r=n,m=i,h=l,f=d;n=a(n,i,l,d,e[t],7,-680876936),d=a(d,n,i,l,e[t+1],12,-389564586),l=a(l,d,n,i,e[t+2],17,606105819),i=a(i,l,d,n,e[t+3],22,-1044525330),n=a(n,i,l,d,e[t+4],7,-176418897),d=a(d,n,i,l,e[t+5],12,1200080426),l=a(l,d,n,i,e[t+6],17,-1473231341),i=a(i,l,d,n,e[t+7],22,-45705983),n=a(n,i,l,d,e[t+8],7,1770035416),d=a(d,n,i,l,e[t+9],12,-1958414417),l=a(l,d,n,i,e[t+10],17,-42063),i=a(i,l,d,n,e[t+11],22,-1990404162),n=a(n,i,l,d,e[t+12],7,1804603682),d=a(d,n,i,l,e[t+13],12,-40341101),l=a(l,d,n,i,e[t+14],17,-1502002290),i=a(i,l,d,n,e[t+15],22,1236535329),n=o(n,i,l,d,e[t+1],5,-165796510),d=o(d,n,i,l,e[t+6],9,-1069501632),l=o(l,d,n,i,e[t+11],14,643717713),i=o(i,l,d,n,e[t],20,-373897302),n=o(n,i,l,d,e[t+5],5,-701558691),d=o(d,n,i,l,e[t+10],9,38016083),l=o(l,d,n,i,e[t+15],14,-660478335),i=o(i,l,d,n,e[t+4],20,-405537848),n=o(n,i,l,d,e[t+9],5,568446438),d=o(d,n,i,l,e[t+14],9,-1019803690),l=o(l,d,n,i,e[t+3],14,-187363961),i=o(i,l,d,n,e[t+8],20,1163531501),n=o(n,i,l,d,e[t+13],5,-1444681467),d=o(d,n,i,l,e[t+2],9,-51403784),l=o(l,d,n,i,e[t+7],14,1735328473),i=o(i,l,d,n,e[t+12],20,-1926607734),n=c(n,i,l,d,e[t+5],4,-378558),d=c(d,n,i,l,e[t+8],11,-2022574463),l=c(l,d,n,i,e[t+11],16,1839030562),i=c(i,l,d,n,e[t+14],23,-35309556),n=c(n,i,l,d,e[t+1],4,-1530992060),d=c(d,n,i,l,e[t+4],11,1272893353),l=c(l,d,n,i,e[t+7],16,-155497632),i=c(i,l,d,n,e[t+10],23,-1094730640),n=c(n,i,l,d,e[t+13],4,681279174),d=c(d,n,i,l,e[t],11,-358537222),l=c(l,d,n,i,e[t+3],16,-722521979),i=c(i,l,d,n,e[t+6],23,76029189),n=c(n,i,l,d,e[t+9],4,-640364487),d=c(d,n,i,l,e[t+12],11,-421815835),l=c(l,d,n,i,e[t+15],16,530742520),i=c(i,l,d,n,e[t+2],23,-995338651),n=u(n,i,l,d,e[t],6,-198630844),d=u(d,n,i,l,e[t+7],10,1126891415),l=u(l,d,n,i,e[t+14],15,-1416354905),i=u(i,l,d,n,e[t+5],21,-57434055),n=u(n,i,l,d,e[t+12],6,1700485571),d=u(d,n,i,l,e[t+3],10,-1894986606),l=u(l,d,n,i,e[t+10],15,-1051523),i=u(i,l,d,n,e[t+1],21,-2054922799),n=u(n,i,l,d,e[t+8],6,1873313359),d=u(d,n,i,l,e[t+15],10,-30611744),l=u(l,d,n,i,e[t+6],15,-1560198380),i=u(i,l,d,n,e[t+13],21,1309151649),n=u(n,i,l,d,e[t+4],6,-145523070),d=u(d,n,i,l,e[t+11],10,-1120210379),l=u(l,d,n,i,e[t+2],15,718787259),i=u(i,l,d,n,e[t+9],21,-343485551),n=s(n,r),i=s(i,m),l=s(l,h),d=s(d,f)}return[n,i,l,d]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(r(t));for(let r=0;r<t;r+=8)n[r>>5]|=(255&e[r/8])<<r%32;return n}(e),8*e.length))};n.default=l}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/md5-browser.js"}],[1707,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/nil.js"}],[1708,{"./validate.js":1718},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var i=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/parse.js"}],[1709,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/regex.js"}],[1710,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let r;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!r&&(r="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto),!r))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return r(s)};const s=new Uint8Array(16)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/rng-browser.js"}],[1711,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n,r){switch(e){case 0:return t&n^~t&r;case 1:case 3:return t^n^r;case 2:return t&n^t&r^n&r}}function s(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var i=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const i=e.length/4+2,a=Math.ceil(i/16),o=new Array(a);for(let t=0;t<a;++t){const n=new Uint32Array(16);for(let r=0;r<16;++r)n[r]=e[64*t+4*r]<<24|e[64*t+4*r+1]<<16|e[64*t+4*r+2]<<8|e[64*t+4*r+3];o[t]=n}o[a-1][14]=8*(e.length-1)/Math.pow(2,32),o[a-1][14]=Math.floor(o[a-1][14]),o[a-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<a;++e){const i=new Uint32Array(80);for(let t=0;t<16;++t)i[t]=o[e][t];for(let e=16;e<80;++e)i[e]=s(i[e-3]^i[e-8]^i[e-14]^i[e-16],1);let a=n[0],c=n[1],u=n[2],l=n[3],d=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),o=s(a,5)+r(n,c,u,l)+d+t[n]+i[e]>>>0;d=l,l=u,u=s(c,30)>>>0,c=a,a=o}n[0]=n[0]+a>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+u>>>0,n[3]=n[3]+l>>>0,n[4]=n[4]+d>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/sha1-browser.js"}],[1712,{"./validate.js":1718},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};const i=[];for(let e=0;e<256;++e)i.push((e+256).toString(16).substr(1));var a=function(e,t=0){const n=(i[e[t+0]]+i[e[t+1]]+i[e[t+2]]+i[e[t+3]]+"-"+i[e[t+4]]+i[e[t+5]]+"-"+i[e[t+6]]+i[e[t+7]]+"-"+i[e[t+8]]+i[e[t+9]]+"-"+i[e[t+10]]+i[e[t+11]]+i[e[t+12]]+i[e[t+13]]+i[e[t+14]]+i[e[t+15]]).toLowerCase();if(!(0,s.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/stringify.js"}],[1713,{"./rng.js":1710,"./stringify.js":1712},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./rng.js")),s=i(e("./stringify.js"));function i(e){return e&&e.__esModule?e:{default:e}}let a,o,c=0,u=0;var l=function(e,t,n){let i=t&&n||0;const l=t||new Array(16);let d=(e=e||{}).node||a,m=e.clockseq!==undefined?e.clockseq:o;if(null==d||null==m){const t=e.random||(e.rng||r.default)();null==d&&(d=a=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==m&&(m=o=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),f=e.nsecs!==undefined?e.nsecs:u+1;const p=h-c+(f-u)/1e4;if(p<0&&e.clockseq===undefined&&(m=m+1&16383),(p<0||h>c)&&e.nsecs===undefined&&(f=0),f>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,u=f,o=m,h+=122192928e5;const y=(1e4*(268435455&h)+f)%4294967296;l[i++]=y>>>24&255,l[i++]=y>>>16&255,l[i++]=y>>>8&255,l[i++]=255&y;const g=h/4294967296*1e4&268435455;l[i++]=g>>>8&255,l[i++]=255&g,l[i++]=g>>>24&15|16,l[i++]=g>>>16&255,l[i++]=m>>>8|128,l[i++]=255&m;for(let e=0;e<6;++e)l[i+e]=d[e];return t||(0,s.default)(l)};n.default=l}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v1.js"}],[1714,{"./md5.js":1706,"./v35.js":1715},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./v35.js")),s=i(e("./md5.js"));function i(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v3",48,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v3.js"}],[1715,{"./parse.js":1708,"./stringify.js":1712},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,t,n){function i(e,i,a,o){if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof i&&(i=(0,s.default)(i)),16!==i.length)throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let c=new Uint8Array(16+e.length);if(c.set(i),c.set(e,i.length),c=n(c),c[6]=15&c[6]|t,c[8]=63&c[8]|128,a){o=o||0;for(let e=0;e<16;++e)a[o+e]=c[e];return a}return(0,r.default)(c)}try{i.name=e}catch(e){}return i.DNS=a,i.URL=o,i},n.URL=n.DNS=void 0;var r=i(e("./stringify.js")),s=i(e("./parse.js"));function i(e){return e&&e.__esModule?e:{default:e}}const a="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=a;const o="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v35.js"}],[1716,{"./rng.js":1710,"./stringify.js":1712},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./rng.js")),s=i(e("./stringify.js"));function i(e){return e&&e.__esModule?e:{default:e}}var a=function(e,t,n){const i=(e=e||{}).random||(e.rng||r.default)();if(i[6]=15&i[6]|64,i[8]=63&i[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=i[e];return t}return(0,s.default)(i)};n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v4.js"}],[1717,{"./sha1.js":1711,"./v35.js":1715},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./v35.js")),s=i(e("./sha1.js"));function i(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v5",80,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/v5.js"}],[1718,{"./regex.js":1709},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./regex.js"))&&r.__esModule?r:{default:r};var i=function(e){return"string"==typeof e&&s.default.test(e)};n.default=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/validate.js"}],[1719,{"./validate.js":1718},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var i=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");return parseInt(e.substr(14,1),16)};n.default=i}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry-eth/node_modules/uuid/dist/version.js"}],[1720,{"./RegistryItem":1731,"./RegistryType":1732,"./lib":1742},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Bytes=void 0;const r=e("./lib"),s=e("./RegistryItem"),i=e("./RegistryType");class a extends s.RegistryItem{constructor(e){super(),this.bytes=e,this.getRegistryType=()=>i.RegistryTypes.BYTES,this.getData=()=>this.bytes,this.toDataItem=()=>new r.DataItem(this.bytes)}}n.Bytes=a,a.fromDataItem=e=>{const t=e.getData();if(!t)throw new Error(`#[ur-registry][Bytes][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${e}`);return new a(t)},a.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return a.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Bytes.js"}],[1721,{".":1739,"./RegistryItem":1731,"./RegistryType":1732,"./lib":1742,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoAccount=void 0;const r=e("."),s=e("./lib"),i=e("./RegistryItem"),a=e("./RegistryType");var o;!function(e){e[e.masterFingerprint=1]="masterFingerprint",e[e.outputDescriptors=2]="outputDescriptors"}(o||(o={}));class c extends i.RegistryItem{constructor(e,t){super(),this.masterFingerprint=e,this.outputDescriptors=t,this.getRegistryType=()=>a.RegistryTypes.CRYPTO_ACCOUNT,this.getMasterFingerprint=()=>this.masterFingerprint,this.getOutputDescriptors=()=>this.outputDescriptors,this.toDataItem=()=>{const e={};return this.masterFingerprint&&(e[o.masterFingerprint]=this.masterFingerprint.readUInt32BE(0)),this.outputDescriptors&&(e[o.outputDescriptors]=this.outputDescriptors.map(e=>e.toDataItem())),new s.DataItem(e)}}}n.CryptoAccount=c,c.fromDataItem=e=>{const n=e.getData(),s=t.alloc(4),i=n[o.masterFingerprint];i&&s.writeUInt32BE(i,0);const a=n[o.outputDescriptors].map(e=>r.CryptoOutput.fromDataItem(e));return new c(s,a)},c.fromCBOR=e=>{const t=(0,s.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoAccount.js"}],[1722,{"./RegistryItem":1731,"./RegistryType":1732,"./lib":1742},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoCoinInfo=n.Network=n.Type=void 0;const r=e("./lib"),s=e("./RegistryItem"),i=e("./RegistryType");var a,o,c;!function(e){e.type="1",e.network="2"}(a||(a={})),function(e){e[e.bitcoin=0]="bitcoin"}(o=n.Type||(n.Type={})),function(e){e[e.mainnet=0]="mainnet",e[e.testnet=1]="testnet"}(c=n.Network||(n.Network={}));class u extends s.RegistryItem{constructor(e,t){super(),this.type=e,this.network=t,this.getRegistryType=()=>i.RegistryTypes.CRYPTO_COIN_INFO,this.getType=()=>this.type||o.bitcoin,this.getNetwork=()=>this.network||c.mainnet,this.toDataItem=()=>{const e={};return this.type&&(e[a.type]=this.type),this.network&&(e[a.network]=this.network),new r.DataItem(e)}}}n.CryptoCoinInfo=u,u.fromDataItem=e=>{const t=e.getData(),n=t[a.type],r=t[a.network];return new u(n,r)},u.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return u.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoCoinInfo.js"}],[1723,{"./RegistryItem":1731,"./RegistryType":1732,"./lib":1742},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoECKey=void 0;const r=e("./lib"),s=e("./RegistryItem"),i=e("./RegistryType");var a;!function(e){e[e.curve=1]="curve",e[e.private=2]="private",e[e.data=3]="data"}(a||(a={}));class o extends s.RegistryItem{constructor(e){super(),this.isECKey=()=>!0,this.getCurve=()=>this.curve||0,this.isPrivateKey=()=>this.privateKey||!1,this.getData=()=>this.data,this.getRegistryType=()=>i.RegistryTypes.CRYPTO_ECKEY,this.toDataItem=()=>{const e={};return this.curve&&(e[a.curve]=this.curve),this.privateKey!==undefined&&(e[a.private]=this.privateKey),e[a.data]=this.data,new r.DataItem(e)},this.getOutputDescriptorContent=()=>this.data.toString("hex"),this.data=e.data,this.curve=e.curve,this.privateKey=e.privateKey||undefined}}n.CryptoECKey=o,o.fromDataItem=e=>{const t=e.getData(),n=t[a.curve],r=t[a.private],s=t[a.data];if(!s)throw new Error(`#[ur-registry][CryptoECKey][fn.fromDataItem]: decoded [dataItem][#data.data] is undefined: ${e}`);return new o({data:s,curve:n,privateKey:r})},o.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return o.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoECKey.js"}],[1724,{"./CryptoCoinInfo":1722,"./CryptoKeypath":1725,"./RegistryItem":1731,"./RegistryType":1732,"./lib":1742,bs58check:3618,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoHDKey=void 0;const r=e("bs58check"),s=e("./CryptoCoinInfo"),i=e("./CryptoKeypath"),a=e("./lib"),o=e("./RegistryItem"),c=e("./RegistryType");var u;!function(e){e[e.is_master=1]="is_master",e[e.is_private=2]="is_private",e[e.key_data=3]="key_data",e[e.chain_code=4]="chain_code",e[e.use_info=5]="use_info",e[e.origin=6]="origin",e[e.children=7]="children",e[e.parent_fingerprint=8]="parent_fingerprint",e[e.name=9]="name",e[e.note=10]="note"}(u||(u={}));class l extends o.RegistryItem{constructor(e){super(),this.isECKey=()=>!1,this.getKey=()=>this.key,this.getChainCode=()=>this.chainCode,this.isMaster=()=>this.master,this.isPrivateKey=()=>!!this.privateKey,this.getUseInfo=()=>this.useInfo,this.getOrigin=()=>this.origin,this.getChildren=()=>this.children,this.getParentFingerprint=()=>this.parentFingerprint,this.getName=()=>this.name,this.getNote=()=>this.note,this.getBip32Key=()=>{var e,n,s;let i,a,o=0,c=t.alloc(4).fill(0);if(this.isMaster())i=t.from("0488ADE4","hex"),a=0,o=0;else{a=(null===(e=this.getOrigin())||void 0===e?void 0:e.getComponents().length)||(null===(n=this.getOrigin())||void 0===n?void 0:n.getDepth());const r=null===(s=this.getOrigin())||void 0===s?void 0:s.getComponents(),u=r[r.length-1];u&&(o=u.isHardened()?u.getIndex()+2147483648:u.getIndex(),this.getParentFingerprint()&&(c=this.getParentFingerprint())),i=this.isPrivateKey()?t.from("0488ADE4","hex"):t.from("0488B21E","hex")}const u=t.alloc(1);u.writeUInt8(a,0);const l=t.alloc(4);l.writeUInt32BE(o,0);const d=this.getChainCode(),m=this.getKey();return(0,r.encode)(t.concat([i,u,c,l,d,m]))},this.getRegistryType=()=>c.RegistryTypes.CRYPTO_HDKEY,this.getOutputDescriptorContent=()=>{var e,t,n,r,s,i,a;let o="";return this.getOrigin()&&(null===(e=this.getOrigin())||void 0===e?void 0:e.getSourceFingerprint())&&(null===(t=this.getOrigin())||void 0===t?void 0:t.getPath())&&(o+=`${null===(r=null===(n=this.getOrigin())||void 0===n?void 0:n.getSourceFingerprint())||void 0===r?void 0:r.toString("hex")}/${null===(s=this.getOrigin())||void 0===s?void 0:s.getPath()}`),o+=this.getBip32Key(),this.getChildren()&&(null===(i=this.getChildren())||void 0===i?void 0:i.getPath())&&(o+=`/${null===(a=this.getChildren())||void 0===a?void 0:a.getPath()}`),o},this.setupMasterKey=e=>{this.master=!0,this.key=e.key,this.chainCode=e.chainCode},this.setupDeriveKey=e=>{this.master=!1,this.privateKey=e.isPrivateKey,this.key=e.key,this.chainCode=e.chainCode,this.useInfo=e.useInfo,this.origin=e.origin,this.children=e.children,this.parentFingerprint=e.parentFingerprint,this.name=e.name,this.note=e.note},this.toDataItem=()=>{const e={};if(this.master)e[u.is_master]=!0,e[u.key_data]=this.key,e[u.chain_code]=this.chainCode;else{if(this.privateKey!==undefined&&(e[u.is_private]=this.privateKey),e[u.key_data]=this.key,this.chainCode&&(e[u.chain_code]=this.chainCode),this.useInfo){const t=this.useInfo.toDataItem();t.setTag(this.useInfo.getRegistryType().getTag()),e[u.use_info]=t}if(this.origin){const t=this.origin.toDataItem();t.setTag(this.origin.getRegistryType().getTag()),e[u.origin]=t}if(this.children){const t=this.children.toDataItem();t.setTag(this.children.getRegistryType().getTag()),e[u.children]=t}this.parentFingerprint&&(e[u.parent_fingerprint]=this.parentFingerprint.readUInt32BE(0)),this.name!==undefined&&(e[u.name]=this.name),this.note!==undefined&&(e[u.note]=this.note)}return new a.DataItem(e)},e.isMaster?this.setupMasterKey(e):this.setupDeriveKey(e)}}n.CryptoHDKey=l,l.fromDataItem=e=>{const n=e.getData(),r=!!n[u.is_master],a=n[u.is_private],o=n[u.key_data],c=n[u.chain_code],d=n[u.use_info]?s.CryptoCoinInfo.fromDataItem(n[u.use_info]):undefined,m=n[u.origin]?i.CryptoKeypath.fromDataItem(n[u.origin]):undefined,h=n[u.children]?i.CryptoKeypath.fromDataItem(n[u.children]):undefined,f=n[u.parent_fingerprint];let p=undefined;f&&(p=t.alloc(4),p.writeUInt32BE(f,0));const y=n[u.name],g=n[u.note];return new l({isMaster:r,isPrivateKey:a,key:o,chainCode:c,useInfo:d,origin:m,children:h,parentFingerprint:p,name:y,note:g})},l.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return l.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoHDKey.js"}],[1725,{"./PathComponent":1730,"./RegistryItem":1731,"./RegistryType":1732,"./lib":1742,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoKeypath=void 0;const r=e("./lib"),s=e("./PathComponent"),i=e("./RegistryItem"),a=e("./RegistryType");var o;!function(e){e[e.components=1]="components",e[e.source_fingerprint=2]="source_fingerprint",e[e.depth=3]="depth"}(o||(o={}));class c extends i.RegistryItem{constructor(e=[],t,n){super(),this.components=e,this.sourceFingerprint=t,this.depth=n,this.getRegistryType=()=>a.RegistryTypes.CRYPTO_KEYPATH,this.getPath=()=>{if(0===this.components.length)return undefined;return this.components.map(e=>`${e.isWildcard()?"*":e.getIndex()}${e.isHardened()?"'":""}`).join("/")},this.getComponents=()=>this.components,this.getSourceFingerprint=()=>this.sourceFingerprint,this.getDepth=()=>this.depth,this.toDataItem=()=>{const e={},t=[];return this.components&&this.components.forEach(e=>{e.isWildcard()?t.push([]):t.push(e.getIndex()),t.push(e.isHardened())}),e[o.components]=t,this.sourceFingerprint&&(e[o.source_fingerprint]=this.sourceFingerprint.readUInt32BE(0)),this.depth!==undefined&&(e[o.depth]=this.depth),new r.DataItem(e)}}}n.CryptoKeypath=c,c.fromDataItem=e=>{const n=e.getData(),r=[],i=n[o.components];if(i)for(let e=0;e<i.length;e+=2){const t=i[e+1],n=i[e];"number"==typeof n?r.push(new s.PathComponent({index:n,hardened:t})):r.push(new s.PathComponent({hardened:t}))}const a=n[o.source_fingerprint];let u;a&&(u=t.alloc(4),u.writeUInt32BE(a,0));const l=n[o.depth];return new c(r,u,l)},c.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoKeypath.js"}],[1726,{"./CryptoECKey":1723,"./CryptoHDKey":1724,"./MultiKey":1729,"./RegistryItem":1731,"./RegistryType":1732,"./ScriptExpression":1733,"./lib":1742},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoOutput=void 0;const r=e("./CryptoECKey"),s=e("./CryptoHDKey"),i=e("./lib"),a=e("./MultiKey"),o=e("./RegistryItem"),c=e("./RegistryType"),u=e("./ScriptExpression");class l extends o.RegistryItem{constructor(e,t){super(),this.scriptExpressions=e,this.cryptoKey=t,this.getRegistryType=()=>c.RegistryTypes.CRYPTO_OUTPUT,this.getCryptoKey=()=>this.cryptoKey,this.getHDKey=()=>this.cryptoKey instanceof s.CryptoHDKey?this.cryptoKey:undefined,this.getECKey=()=>this.cryptoKey instanceof r.CryptoECKey?this.cryptoKey:undefined,this.getMultiKey=()=>this.cryptoKey instanceof a.MultiKey?this.cryptoKey:undefined,this.getScriptExpressions=()=>this.scriptExpressions,this._toOutputDescriptor=e=>e>=this.scriptExpressions.length?this.cryptoKey.getOutputDescriptorContent():`${this.scriptExpressions[e].getExpression()}(${this._toOutputDescriptor(e+1)})`,this.toString=()=>this._toOutputDescriptor(0),this.toDataItem=()=>{let e=this.cryptoKey.toDataItem();(this.cryptoKey instanceof r.CryptoECKey||this.cryptoKey instanceof s.CryptoHDKey)&&e.setTag(this.cryptoKey.getRegistryType().getTag());return[...this.scriptExpressions].reverse().forEach(t=>{const n=t.getTag();e.getTag()===undefined?e.setTag(n):e=new i.DataItem(e,n)}),e}}}n.CryptoOutput=l,l.fromDataItem=e=>{const t=[];let n=e;for(;;){let e=n.getTag();const r=u.ScriptExpression.fromTag(e);if(!r)break;if(t.push(r),!(n.getData()instanceof i.DataItem))break;n=n.getData(),e=n.getTag()}const o=t.length;if(o>0&&(t[o-1].getExpression()===u.ScriptExpressions.MULTISIG.getExpression()||t[o-1].getExpression()===u.ScriptExpressions.SORTED_MULTISIG.getExpression())){const e=a.MultiKey.fromDataItem(n);return new l(t,e)}if(n.getTag()===c.RegistryTypes.CRYPTO_HDKEY.getTag()){const e=s.CryptoHDKey.fromDataItem(n);return new l(t,e)}{const e=r.CryptoECKey.fromDataItem(n);return new l(t,e)}},l.fromCBOR=e=>{const t=(0,i.decodeToDataItem)(e);return l.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoOutput.js"}],[1727,{"./RegistryItem":1731,"./RegistryType":1732,"./lib":1742},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoPSBT=void 0;const r=e("./lib"),s=e("./RegistryItem"),i=e("./RegistryType");class a extends s.RegistryItem{constructor(e){super(),this.psbt=e,this.getRegistryType=()=>i.RegistryTypes.CRYPTO_PSBT,this.getPSBT=()=>this.psbt,this.toDataItem=()=>new r.DataItem(this.psbt)}}n.CryptoPSBT=a,a.fromDataItem=e=>{const t=e.getData();if(!t)throw new Error(`#[ur-registry][CryptoPSBT][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${e}`);return new a(t)},a.fromCBOR=e=>{const t=(0,r.decodeToDataItem)(e);return a.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/CryptoPSBT.js"}],[1728,{"..":1739,"../RegistryType":1732,"../errors":1734,"@ngraveio/bc-ur":2676},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URRegistryDecoder=void 0;const r=e("@ngraveio/bc-ur"),s=e(".."),i=e("../RegistryType"),a=e("../errors");class o extends r.URDecoder{constructor(){super(...arguments),this.resultRegistryType=()=>{const e=this.resultUR();switch(e.type){case i.RegistryTypes.BYTES.getType():return s.Bytes.fromCBOR(e.cbor);case i.RegistryTypes.CRYPTO_HDKEY.getType():return s.CryptoHDKey.fromCBOR(e.cbor);case i.RegistryTypes.CRYPTO_KEYPATH.getType():return s.CryptoKeypath.fromCBOR(e.cbor);case i.RegistryTypes.CRYPTO_COIN_INFO.getType():return s.CryptoCoinInfo.fromCBOR(e.cbor);case i.RegistryTypes.CRYPTO_ECKEY.getType():return s.CryptoECKey.fromCBOR(e.cbor);case i.RegistryTypes.CRYPTO_OUTPUT.getType():return s.CryptoOutput.fromCBOR(e.cbor);case i.RegistryTypes.CRYPTO_PSBT.getType():return s.CryptoPSBT.fromCBOR(e.cbor);case i.RegistryTypes.CRYPTO_ACCOUNT.getType():return s.CryptoAccount.fromCBOR(e.cbor);default:throw new a.UnknownURTypeError(`#[ur-registry][Decoder][fn.resultRegistryType]: registry type ${e.type} is not supported now`)}}}}n.URRegistryDecoder=o}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/Decoder/index.js"}],[1729,{"./CryptoECKey":1723,"./CryptoHDKey":1724,"./RegistryItem":1731,"./RegistryType":1732,"./lib/DataItem":1740},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MultiKey=void 0;const r=e("./CryptoECKey"),s=e("./CryptoHDKey"),i=e("./lib/DataItem"),a=e("./RegistryItem"),o=e("./RegistryType");var c;!function(e){e[e.threshold=1]="threshold",e[e.keys=2]="keys"}(c||(c={}));class u extends a.RegistryItem{constructor(e,t){super(),this.threshold=e,this.keys=t,this.getThreshold=()=>this.threshold,this.getKeys=()=>this.keys,this.toDataItem=()=>{const e={};e[c.threshold]=this.threshold;const t=this.keys.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t});return e[c.keys]=t,new i.DataItem(e)},this.getOutputDescriptorContent=()=>[this.getThreshold(),this.keys.map(e=>e.getOutputDescriptorContent()).join(",")].join(",")}}n.MultiKey=u,u.fromDataItem=e=>{const t=e.getData(),n=t[c.threshold],i=t[c.keys],a=[];return i.forEach(e=>{e.getTag()===o.RegistryTypes.CRYPTO_HDKEY.getTag()?a.push(s.CryptoHDKey.fromDataItem(e)):e.getTag()===o.RegistryTypes.CRYPTO_ECKEY.getTag()&&a.push(r.CryptoECKey.fromDataItem(e))}),new u(n,a)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/MultiKey.js"}],[1730,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PathComponent=void 0;class r{constructor(e){if(this.getIndex=()=>this.index,this.isWildcard=()=>this.wildcard,this.isHardened=()=>this.hardened,this.index=e.index,this.hardened=e.hardened,this.index!==undefined?this.wildcard=!1:this.wildcard=!0,this.index&&0!==(this.index&r.HARDENED_BIT))throw new Error(`#[ur-registry][PathComponent][fn.constructor]: Invalid index ${this.index} - most significant bit cannot be set`)}}n.PathComponent=r,r.HARDENED_BIT=2147483648}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/PathComponent.js"}],[1731,{"./lib":1742,"@ngraveio/bc-ur":2676},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RegistryItem=void 0;const r=e("@ngraveio/bc-ur"),s=e("./lib");n.RegistryItem=class{constructor(){this.toCBOR=()=>{if(this.toDataItem()===undefined)throw new Error(`#[ur-registry][RegistryItem][fn.toCBOR]: registry ${this.getRegistryType()}'s method toDataItem returns undefined`);return(0,s.encodeDataItem)(this.toDataItem())},this.toUR=()=>new r.UR(this.toCBOR(),this.getRegistryType().getType()),this.toUREncoder=(e,t,n)=>{const s=this.toUR();return new r.UREncoder(s,e,t,n)}}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryItem.js"}],[1732,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RegistryTypes=n.RegistryType=void 0;class r{constructor(e,t){this.type=e,this.tag=t,this.getTag=()=>this.tag,this.getType=()=>this.type}}n.RegistryType=r,n.RegistryTypes={UUID:new r("uuid",37),BYTES:new r("bytes",undefined),CRYPTO_HDKEY:new r("crypto-hdkey",303),CRYPTO_KEYPATH:new r("crypto-keypath",304),CRYPTO_COIN_INFO:new r("crypto-coin-info",305),CRYPTO_ECKEY:new r("crypto-eckey",306),CRYPTO_OUTPUT:new r("crypto-output",308),CRYPTO_PSBT:new r("crypto-psbt",310),CRYPTO_ACCOUNT:new r("crypto-account",311),CRYPTO_MULTI_ACCOUNTS:new r("crypto-multi-accounts",1103),QR_HARDWARE_CALL:new r("qr-hardware-call",1201),KEY_DERIVATION_CALL:new r("key-derivation-call",1301),KEY_DERIVATION_SCHEMA:new r("key-derivation-schema",1302)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/RegistryType.js"}],[1733,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ScriptExpressions=n.ScriptExpression=void 0;class r{constructor(e,t){this.tag=e,this.expression=t,this.getTag=()=>this.tag,this.getExpression=()=>this.expression}}n.ScriptExpression=r,r.fromTag=e=>Object.values(n.ScriptExpressions).find(t=>t.getTag()===e),n.ScriptExpressions={SCRIPT_HASH:new r(400,"sh"),WITNESS_SCRIPT_HASH:new r(401,"wsh"),PUBLIC_KEY:new r(402,"pk"),PUBLIC_KEY_HASH:new r(403,"pkh"),WITNESS_PUBLIC_KEY_HASH:new r(404,"wpkh"),COMBO:new r(405,"combo"),MULTISIG:new r(406,"multi"),SORTED_MULTISIG:new r(407,"sortedmulti"),ADDRESS:new r(307,"addr"),RAW_SCRIPT:new r(408,"raw")}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/ScriptExpression.js"}],[1734,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.UnknownURTypeError=void 0;class r extends Error{constructor(e){super(e)}}n.UnknownURTypeError=r}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/errors/index.js"}],[1735,{"../CryptoHDKey":1724,"../RegistryItem":1731,"../RegistryType":1732,"../lib":1742,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.CryptoMultiAccounts=void 0;const r=e("../RegistryType"),s=e("../CryptoHDKey"),i=e("../RegistryItem"),a=e("../lib");var o;!function(e){e[e.masterFingerprint=1]="masterFingerprint",e[e.keys=2]="keys",e[e.device=3]="device",e[e.deviceId=4]="deviceId",e[e.version=5]="version"}(o||(o={}));class c extends i.RegistryItem{constructor(e,t,n,s,i){super(),this.masterFingerprint=e,this.keys=t,this.device=n,this.deviceId=s,this.version=i,this.getRegistryType=()=>r.RegistryTypes.CRYPTO_MULTI_ACCOUNTS,this.getMasterFingerprint=()=>this.masterFingerprint,this.getKeys=()=>this.keys,this.getDevice=()=>this.device,this.getDeviceId=()=>this.deviceId,this.getVersion=()=>this.version,this.toDataItem=()=>{const e={};return this.masterFingerprint&&(e[o.masterFingerprint]=this.masterFingerprint.readUInt32BE(0)),this.keys&&(e[o.keys]=this.keys.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t})),this.device&&(e[o.device]=this.device),this.deviceId&&(e[o.deviceId]=this.deviceId),this.version&&(e[o.version]=this.version),new a.DataItem(e)}}}n.CryptoMultiAccounts=c,c.fromDataItem=e=>{const n=e.getData(),r=t.alloc(4),i=n[o.masterFingerprint];i&&r.writeUInt32BE(i,0);const a=n[o.keys].map(e=>s.CryptoHDKey.fromDataItem(e)),u=n[o.device],l=n[o.deviceId],d=n[o.version];return new c(r,a,u,l,d)},c.fromCBOR=e=>{const t=(0,a.decodeToDataItem)(e);return c.fromDataItem(t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/CryptoMultiAccounts.js"}],[1736,{"../CryptoKeypath":1725,"../RegistryItem":1731,"../RegistryType":1732,"../lib":1742},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyDerivationSchema=n.DerivationAlgorithm=n.Curve=void 0;const r=e("../RegistryType"),s=e("../RegistryItem"),i=e("../lib"),a=e("../CryptoKeypath");var o,c,u;!function(e){e[e.keyPath=1]="keyPath",e[e.curve=2]="curve",e[e.algo=3]="algo"}(o||(o={})),function(e){e[e.secp256k1=0]="secp256k1",e[e.ed25519=1]="ed25519"}(c=n.Curve||(n.Curve={})),function(e){e[e.slip10=0]="slip10",e[e.bip32ed25519=1]="bip32ed25519"}(u=n.DerivationAlgorithm||(n.DerivationAlgorithm={}));class l extends s.RegistryItem{constructor(e,t=c.secp256k1,n=u.slip10){super(),this.keypath=e,this.curve=t,this.algo=n,this.getRegistryType=()=>r.RegistryTypes.KEY_DERIVATION_SCHEMA,this.getKeypath=()=>this.keypath,this.getCurve=()=>this.curve,this.getAlgo=()=>this.algo,this.toDataItem=()=>{const e={},t=this.getKeypath().toDataItem();return t.setTag(this.getKeypath().getRegistryType().getTag()),e[o.keyPath]=t,e[o.curve]=this.curve,e[o.algo]=this.algo,new i.DataItem(e)}}}n.KeyDerivationSchema=l,l.fromDataItem=e=>{const t=e.getData(),n=a.CryptoKeypath.fromDataItem(t[o.keyPath]),r=t[o.curve],s=t[o.algo];return new l(n,r,s)},l.fromCBOR=e=>{const t=(0,i.decodeToDataItem)(e);return l.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/DerivationSchema.js"}],[1737,{"../RegistryItem":1731,"../RegistryType":1732,"../lib":1742,"./DerivationSchema":1736},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyDerivation=void 0;const r=e("../RegistryType"),s=e("../RegistryItem"),i=e("../lib"),a=e("./DerivationSchema");var o;!function(e){e[e.schemas=1]="schemas"}(o||(o={}));class c extends s.RegistryItem{constructor(e){super(),this.schemas=e,this.getRegistryType=()=>r.RegistryTypes.KEY_DERIVATION_CALL,this.getSchemas=()=>this.schemas,this.toDataItem=()=>{const e={};return e[o.schemas]=this.schemas.map(e=>{const t=e.toDataItem();return t.setTag(e.getRegistryType().getTag()),t}),new i.DataItem(e)}}}n.KeyDerivation=c,c.fromDataItem=e=>{const t=e.getData()[o.schemas].map(e=>a.KeyDerivationSchema.fromDataItem(e));return new c(t)},c.fromCBOR=e=>{const t=(0,i.decodeToDataItem)(e);return c.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/KeyDerivation.js"}],[1738,{"../RegistryItem":1731,"../RegistryType":1732,"../lib":1742,"./KeyDerivation":1737},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.QRHardwareCall=n.QRHardwareCallType=void 0;const r=e("../RegistryType"),s=e("../RegistryItem"),i=e("../lib"),a=e("./KeyDerivation");var o,c;!function(e){e[e.type=1]="type",e[e.params=2]="params",e[e.origin=3]="origin"}(o||(o={})),function(e){e[e.KeyDerivation=0]="KeyDerivation"}(c=n.QRHardwareCallType||(n.QRHardwareCallType={}));class u extends s.RegistryItem{constructor(e,t,n){super(),this.type=e,this.params=t,this.origin=n,this.getRegistryType=()=>r.RegistryTypes.QR_HARDWARE_CALL,this.getType=()=>this.type,this.getParams=()=>this.params,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const e={};e[o.type]=this.type;const t=this.params.toDataItem();return t.setTag(this.params.getRegistryType().getTag()),e[o.params]=t,this.origin&&(e[o.origin]=this.origin),new i.DataItem(e)}}}n.QRHardwareCall=u,u.fromDataItem=e=>{const t=e.getData(),n=t[o.type]||c.KeyDerivation;let r;if(n===c.KeyDerivation)r=a.KeyDerivation.fromDataItem(t[o.params]);const s=t[o.origin];return new u(n,r,s)},u.fromCBOR=e=>{const t=(0,i.decodeToDataItem)(e);return u.fromDataItem(t)}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/extended/QRHardwareCall.js"}],[1739,{"./Bytes":1720,"./CryptoAccount":1721,"./CryptoCoinInfo":1722,"./CryptoECKey":1723,"./CryptoHDKey":1724,"./CryptoKeypath":1725,"./CryptoOutput":1726,"./CryptoPSBT":1727,"./Decoder":1728,"./MultiKey":1729,"./PathComponent":1730,"./RegistryItem":1731,"./RegistryType":1732,"./ScriptExpression":1733,"./errors":1734,"./extended/CryptoMultiAccounts":1735,"./extended/DerivationSchema":1736,"./extended/KeyDerivation":1737,"./extended/QRHardwareCall":1738,"./lib":1742,"./patchCBOR":1743,"./types":1744,"./utils":1745,"buffer/":3622,tslib:5173},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Buffer=n.extend=n.PathComponent=n.ScriptExpressions=n.MultiKey=n.CryptoPSBT=n.CryptoOutput=n.CryptoECKey=n.CryptoCoinInfoNetwork=n.CryptoCoinInfoType=n.CryptoCoinInfo=n.CryptoKeypath=n.CryptoMultiAccounts=n.CryptoHDKey=n.CryptoAccount=n.Bytes=n.URRegistryDecoder=n.DataItem=void 0;const r=e("tslib");e("./patchCBOR");const s=e("buffer/");Object.defineProperty(n,"Buffer",{enumerable:!0,get:function(){return s.Buffer}});const i=e("./CryptoHDKey");Object.defineProperty(n,"CryptoHDKey",{enumerable:!0,get:function(){return i.CryptoHDKey}});const a=e("./CryptoKeypath");Object.defineProperty(n,"CryptoKeypath",{enumerable:!0,get:function(){return a.CryptoKeypath}});const o=e("./CryptoCoinInfo");Object.defineProperty(n,"CryptoCoinInfo",{enumerable:!0,get:function(){return o.CryptoCoinInfo}}),Object.defineProperty(n,"CryptoCoinInfoType",{enumerable:!0,get:function(){return o.Type}}),Object.defineProperty(n,"CryptoCoinInfoNetwork",{enumerable:!0,get:function(){return o.Network}});const c=e("./CryptoECKey");Object.defineProperty(n,"CryptoECKey",{enumerable:!0,get:function(){return c.CryptoECKey}});const u=e("./Bytes");Object.defineProperty(n,"Bytes",{enumerable:!0,get:function(){return u.Bytes}});const l=e("./CryptoOutput");Object.defineProperty(n,"CryptoOutput",{enumerable:!0,get:function(){return l.CryptoOutput}});const d=e("./CryptoPSBT");Object.defineProperty(n,"CryptoPSBT",{enumerable:!0,get:function(){return d.CryptoPSBT}});const m=e("./CryptoAccount");Object.defineProperty(n,"CryptoAccount",{enumerable:!0,get:function(){return m.CryptoAccount}});const h=e("./Decoder");Object.defineProperty(n,"URRegistryDecoder",{enumerable:!0,get:function(){return h.URRegistryDecoder}});const f=e("./MultiKey");Object.defineProperty(n,"MultiKey",{enumerable:!0,get:function(){return f.MultiKey}});const p=e("./ScriptExpression");Object.defineProperty(n,"ScriptExpressions",{enumerable:!0,get:function(){return p.ScriptExpressions}});const y=e("./PathComponent");Object.defineProperty(n,"PathComponent",{enumerable:!0,get:function(){return y.PathComponent}});const g=e("./RegistryItem"),b=e("./RegistryType"),v=e("./lib");var k=e("./lib");Object.defineProperty(n,"DataItem",{enumerable:!0,get:function(){return k.DataItem}});const E=e("./utils"),w=e("./extended/CryptoMultiAccounts");Object.defineProperty(n,"CryptoMultiAccounts",{enumerable:!0,get:function(){return w.CryptoMultiAccounts}});const T={URRegistryDecoder:h.URRegistryDecoder,Bytes:u.Bytes,CryptoAccount:m.CryptoAccount,CryptoHDKey:i.CryptoHDKey,CryptoMultiAccounts:w.CryptoMultiAccounts,CryptoKeypath:a.CryptoKeypath,CryptoCoinInfo:o.CryptoCoinInfo,CryptoCoinInfoType:o.Type,CryptoCoinInfoNetwork:o.Network,CryptoECKey:c.CryptoECKey,CryptoOutput:l.CryptoOutput,CryptoPSBT:d.CryptoPSBT,MultiKey:f.MultiKey,ScriptExpressions:p.ScriptExpressions,PathComponent:y.PathComponent},A={addReader:v.addReader,addSemanticDecode:v.addSemanticDecode,addSemanticEncode:v.addSemanticEncode,addWriter:v.addWriter,patchTags:E.patchTags},C={RegistryTypes:b.RegistryTypes,RegistryItem:g.RegistryItem,RegistryType:b.RegistryType,decodeToDataItem:v.decodeToDataItem,encodeDataItem:v.encodeDataItem,cbor:A};n.extend=C,(0,r.__exportStar)(e("./errors"),n),(0,r.__exportStar)(e("./Decoder"),n),(0,r.__exportStar)(e("./lib"),n),(0,r.__exportStar)(e("./CryptoAccount"),n),(0,r.__exportStar)(e("./CryptoPSBT"),n),(0,r.__exportStar)(e("./CryptoHDKey"),n),(0,r.__exportStar)(e("./extended/CryptoMultiAccounts"),n),(0,r.__exportStar)(e("./extended/QRHardwareCall"),n),(0,r.__exportStar)(e("./extended/KeyDerivation"),n),(0,r.__exportStar)(e("./extended/DerivationSchema"),n),(0,r.__exportStar)(e("./CryptoOutput"),n),(0,r.__exportStar)(e("./CryptoCoinInfo"),n),(0,r.__exportStar)(e("./CryptoECKey"),n),(0,r.__exportStar)(e("./MultiKey"),n),(0,r.__exportStar)(e("./CryptoKeypath"),n),(0,r.__exportStar)(e("./patchCBOR"),n),(0,r.__exportStar)(e("./PathComponent"),n),(0,r.__exportStar)(e("./RegistryItem"),n),(0,r.__exportStar)(e("./RegistryType"),n),(0,r.__exportStar)(e("./types"),n),(0,r.__exportStar)(e("./utils"),n),n.default=T}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/index.js"}],[1740,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DataItem=void 0;n.DataItem=class{constructor(e,t){this.setTag=e=>{this.tag=e},this.clearTag=()=>{this.tag=undefined},this.getTag=()=>this.tag,this.getData=()=>this.data,this.data=e,this.tag=t}}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/DataItem.js"}],[1741,{"./DataItem":1740,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r,s;r=this,s=function(){const{DataItem:t}=e("./DataItem");var r=function(){function e(e){this.$hex=e}e.prototype={length:function(){return this.$hex.length/2},toString:function(e){if(!e||"hex"===e||16===e)return this.$hex;if("utf-8"===e){for(var t="",n=0;n<this.$hex.length;n+=2)t+="%"+this.$hex.substring(n,n+2);return decodeURIComponent(t)}if("latin"===e){for(t=[],n=0;n<this.$hex.length;n+=2)t.push(parseInt(this.$hex.substring(n,n+2),16));return String.fromCharCode.apply(String,t)}throw new Error("Unrecognised format: "+e)}},e.fromLatinString=function(t){for(var n="",r=0;r<t.length;r++){var s=t.charCodeAt(r).toString(16);1===s.length&&(s="0"+s),n+=s}return new e(n)},e.fromUtf8String=function(t){for(var n=encodeURIComponent(t),r="",s=0;s<n.length;s++)if("%"===n.charAt(s))r+=n.substring(s+1,s+3),s+=2;else{var i=n.charCodeAt(s).toString(16);i.length<2&&(i="0"+i),r+=i}return new e(r)};var r=[],s={},i=function(e){return function(){throw new Error(e+" not implemented")}};function a(){}function o(){}function c(e,t){var n=e.value;return n<24?n:24==n?t.readByte():25==n?t.readUint16():26==n?t.readUint32():27==n?t.readUint64():31==n?null:void i("Additional info: "+n)()}function u(e,t,n){var r=e<<5;t<24?n.writeByte(r|t):t<256?(n.writeByte(24|r),n.writeByte(t)):t<65536?(n.writeByte(25|r),n.writeUint16(t)):t<4294967296?(n.writeByte(26|r),n.writeUint32(t)):(n.writeByte(27|r),n.writeUint64(t))}a.prototype={peekByte:i("peekByte"),readByte:i("readByte"),readChunk:i("readChunk"),readFloat16:function(){var e=this.readUint16(),t=(32767&e)>>10,n=1023&e,r=32768&e;if(31===t)return 0===n?r?-Infinity:Infinity:NaN;var s=t?Math.pow(2,t-25)*(1024+n):Math.pow(2,-24)*n;return r?-s:s},readFloat32:function(){var e=this.readUint32(),t=(2147483647&e)>>23,n=8388607&e,r=2147483648&e;if(255===t)return 0===n?r?-Infinity:Infinity:NaN;var s=t?Math.pow(2,t-23-127)*(8388608+n):Math.pow(2,-149)*n;return r?-s:s},readFloat64:function(){var e=this.readUint32(),t=e>>20&2047,n=4294967296*(1048575&e)+this.readUint32(),r=2147483648&e;if(2047===t)return 0===n?r?-Infinity:Infinity:NaN;var s=t?Math.pow(2,t-52-1023)*(4503599627370496+n):Math.pow(2,-1074)*n;return r?-s:s},readUint16:function(){return 256*this.readByte()+this.readByte()},readUint32:function(){return 65536*this.readUint16()+this.readUint16()},readUint64:function(){return 4294967296*this.readUint32()+this.readUint32()}},o.prototype={writeByte:i("writeByte"),result:i("result"),writeFloat16:i("writeFloat16"),writeFloat32:i("writeFloat32"),writeFloat64:i("writeFloat64"),writeUint16:function(e){this.writeByte(e>>8&255),this.writeByte(255&e)},writeUint32:function(e){this.writeUint16(e>>16&65535),this.writeUint16(65535&e)},writeUint64:function(e){if(e>=9007199254740992||e<=-9007199254740992)throw new Error("Cannot encode Uint64 of: "+e+" magnitude to big (floating point errors)");this.writeUint32(Math.floor(e/4294967296)),this.writeUint32(e%4294967296)},writeString:i("writeString"),canWriteBinary:function(e){return!1},writeBinary:i("writeChunk")};var l=new Error;function d(e){var t=function(e){var t=e.readByte();return{type:t>>5,value:31&t}}(e);switch(t.type){case 0:return c(t,e);case 1:return-1-c(t,e);case 2:return e.readChunk(c(t,e));case 3:return e.readChunk(c(t,e)).toString("utf-8");case 4:case 5:var n=c(t,e),r=[];if(null!==n){5===t.type&&(n*=2);for(var i=0;i<n;i++)r[i]=d(e)}else for(var a;(a=d(e))!==l;)r.push(a);if(5===t.type){var o={};for(i=0;i<r.length;i+=2)o[r[i]]=r[i+1];return o}return r;case 6:var u=c(t,e),m=s[u];return r=d(e),m?m(r):r;case 7:if(25===t.value)return e.readFloat16();if(26===t.value)return e.readFloat32();if(27===t.value)return e.readFloat64();switch(c(t,e)){case 20:return!1;case 21:return!0;case 22:return null;case 23:return undefined;case null:return l;default:throw new Error("Unknown fixed value: "+t.value)}default:throw new Error("Unsupported header: "+JSON.stringify(t))}throw new Error("not implemented yet")}function m(e,t){for(var n=0;n<r.length;n++){var s=r[n].fn(e);if(s!==undefined)return u(6,r[n].tag,t),m(s,t)}if(e&&"function"==typeof e.toCBOR&&(e=e.toCBOR()),!1===e)u(7,20,t);else if(!0===e)u(7,21,t);else if(null===e)u(7,22,t);else if(e===undefined)u(7,23,t);else if("number"==typeof e)Math.floor(e)===e&&e<9007199254740992&&e>-9007199254740992?e<0?u(1,-1-e,t):u(0,e,t):(function(e,t,n){n.writeByte(e<<5|t)}(7,27,t),t.writeFloat64(e));else if("string"==typeof e)t.writeString(e,function(e){u(3,e,t)});else if(t.canWriteBinary(e))t.writeBinary(e,function(e){u(2,e,t)});else{if("object"!=typeof e)throw new Error("CBOR encoding not supported: "+e);if(p.config.useToJSON&&"function"==typeof e.toJSON&&(e=e.toJSON()),Array.isArray(e))for(u(4,e.length,t),n=0;n<e.length;n++)m(e[n],t);else{var i=Object.keys(e);for(u(5,i.length,t),n=0;n<i.length;n++){const r=parseInt(i[n]);isNaN(r)?(m(i[n],t),m(e[i[n]],t)):(m(r,t),m(e[i[n]],t))}}}}var h=[],f=[],p={config:{useToJSON:!0},addWriter:function(e,t){"string"==typeof e?f.push(function(n){if(e===n)return t(n)}):f.push(e)},addReader:function(e,t){"string"==typeof e?h.push(function(n,r){if(e===r)return t(n,r)}):h.push(e)},encode:function(e,t){for(var n=0;n<f.length;n++){var r=(0,f[n])(t);if(r)return m(e,r),r.result()}throw new Error("Unsupported output format: "+t)},encodeDataItem:function(e,t){for(var n=0;n<f.length;n++){var r=(0,f[n])(t);if(r)return e.getTag()!==undefined?(m(e,r),r.result()):(m(e.getData(),r),r.result())}throw new Error("Unsupported output format: "+t)},decode:function(e,t){for(var n=0;n<h.length;n++){var r=(0,h[n])(e,t);if(r)return d(r)}throw new Error("Unsupported input format: "+t)},decodeToDataItem:function(e,n){for(var r=0;r<h.length;r++){var s=(0,h[r])(e,n);if(s){const e=d(s);return e instanceof t?e:new t(e)}}throw new Error("Unsupported input format: "+n)},addSemanticEncode:function(e,t){if("number"!=typeof e||e%1!=0||e<0)throw new Error("Tag must be a positive integer");return r.push({tag:e,fn:t}),this},addSemanticDecode:function(e,t){if("number"!=typeof e||e%1!=0||e<0)throw new Error("Tag must be a positive integer");return s[e]=t,this}};function y(e){this.buffer=e,this.pos=0}function g(e){this.byteLength=0,this.defaultBufferLength=16384,this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0,this.completeBuffers=[],this.stringFormat=e}function b(e){this.hex=e,this.pos=0}function v(e){this.$hex="",this.finalFormat=e||"hex"}return y.prototype=Object.create(a.prototype),y.prototype.peekByte=function(){return this.buffer[this.pos]},y.prototype.readByte=function(){return this.buffer[this.pos++]},y.prototype.readUint16=function(){var e=this.buffer.readUInt16BE(this.pos);return this.pos+=2,e},y.prototype.readUint32=function(){var e=this.buffer.readUInt32BE(this.pos);return this.pos+=4,e},y.prototype.readFloat32=function(){var e=this.buffer.readFloatBE(this.pos);return this.pos+=4,e},y.prototype.readFloat64=function(){var e=this.buffer.readDoubleBE(this.pos);return this.pos+=8,e},y.prototype.readChunk=function(e){var t=n.alloc(e);return this.buffer.copy(t,0,this.pos,this.pos+=e),t},g.prototype=Object.create(o.prototype),g.prototype.writeByte=function(e){this.latestBuffer[this.latestBufferOffset++]=e,this.latestBufferOffset>=this.latestBuffer.length&&(this.completeBuffers.push(this.latestBuffer),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0),this.byteLength++},g.prototype.writeFloat32=function(e){var t=n.alloc(4);t.writeFloatBE(e,0),this.writeBuffer(t)},g.prototype.writeFloat64=function(e){var t=n.alloc(8);t.writeDoubleBE(e,0),this.writeBuffer(t)},g.prototype.writeString=function(e,t){var r=n.from(e,"utf-8");t(r.length),this.writeBuffer(r)},g.prototype.canWriteBinary=function(e){return e instanceof n},g.prototype.writeBinary=function(e,t){t(e.length),this.writeBuffer(e)},g.prototype.writeBuffer=function(e){if(!(e instanceof n))throw new TypeError("BufferWriter only accepts Buffers");this.latestBufferOffset?this.latestBuffer.length-this.latestBufferOffset>=e.length?(e.copy(this.latestBuffer,this.latestBufferOffset),this.latestBufferOffset+=e.length,this.latestBufferOffset>=this.latestBuffer.length&&(this.completeBuffers.push(this.latestBuffer),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0)):(this.completeBuffers.push(this.latestBuffer.slice(0,this.latestBufferOffset)),this.completeBuffers.push(e),this.latestBuffer=n.alloc(this.defaultBufferLength),this.latestBufferOffset=0):this.completeBuffers.push(e),this.byteLength+=e.length},g.prototype.result=function(){for(var e=n.alloc(this.byteLength),t=0,r=0;r<this.completeBuffers.length;r++){var s=this.completeBuffers[r];s.copy(e,t,0,s.length),t+=s.length}return this.latestBufferOffset&&this.latestBuffer.copy(e,t,0,this.latestBufferOffset),this.stringFormat?e.toString(this.stringFormat):e},"function"==typeof n&&(p.addReader(function(e,t){return n.isBuffer(e)?new y(e):"hex"===t||"base64"===t?new y(n.from(e,t)):void 0}),p.addWriter(function(e){return e&&"buffer"!==e?"hex"===e||"base64"===e?new g(e):void 0:new g})),b.prototype=Object.create(a.prototype),b.prototype.peekByte=function(){var e=this.hex.substring(this.pos,2);return parseInt(e,16)},b.prototype.readByte=function(){var e=this.hex.substring(this.pos,this.pos+2);return this.pos+=2,parseInt(e,16)},b.prototype.readChunk=function(t){var r=this.hex.substring(this.pos,this.pos+2*t);return this.pos+=2*t,"function"==typeof n?n.from(r,"hex"):new e(r)},v.prototype=Object.create(o.prototype),v.prototype.writeByte=function(e){if(e<0||e>255)throw new Error("Byte value out of range: "+e);var t=e.toString(16);1==t.length&&(t="0"+t),this.$hex+=t},v.prototype.canWriteBinary=function(t){return t instanceof e||"function"==typeof n&&t instanceof n},v.prototype.writeBinary=function(t,r){if(t instanceof e)r(t.length()),this.$hex+=t.$hex;else{if(!("function"==typeof n&&t instanceof n))throw new TypeError("HexWriter only accepts BinaryHex or Buffers");r(t.length),this.$hex+=t.toString("hex")}},v.prototype.result=function(){return"buffer"===this.finalFormat&&"function"==typeof n?n.from(this.$hex,"hex"):new e(this.$hex).toString(this.finalFormat)},v.prototype.writeString=function(t,n){var r=e.fromUtf8String(t);n(r.length()),this.$hex+=r.$hex},p.addReader(function(t,n){return t instanceof e||t.$hex?new b(t.$hex):"hex"===n?new b(t):void 0}),p.addWriter(function(e){if("hex"===e)return new v}),p}();return r.addSemanticEncode(0,function(e){if(e instanceof Date)return e.toISOString()}).addSemanticDecode(0,function(e){return new Date(e)}).addSemanticDecode(1,function(e){return new Date(e)}),r},"function"==typeof define&&define.amd?define([],s):void 0!==t&&t.exports?t.exports=s():r.CBOR=s()}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/cbor-sync.js"}],[1742,{"./DataItem":1740,"./cbor-sync":1741},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DataItem=n.addWriter=n.addReader=n.addSemanticEncode=n.addSemanticDecode=n.decodeToDataItem=n.encodeDataItem=void 0;var r=e("./cbor-sync");Object.defineProperty(n,"encodeDataItem",{enumerable:!0,get:function(){return r.encodeDataItem}}),Object.defineProperty(n,"decodeToDataItem",{enumerable:!0,get:function(){return r.decodeToDataItem}}),Object.defineProperty(n,"addSemanticDecode",{enumerable:!0,get:function(){return r.addSemanticDecode}}),Object.defineProperty(n,"addSemanticEncode",{enumerable:!0,get:function(){return r.addSemanticEncode}}),Object.defineProperty(n,"addReader",{enumerable:!0,get:function(){return r.addReader}}),Object.defineProperty(n,"addWriter",{enumerable:!0,get:function(){return r.addWriter}});var s=e("./DataItem");Object.defineProperty(n,"DataItem",{enumerable:!0,get:function(){return s.DataItem}})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/lib/index.js"}],[1743,{"./RegistryType":1732,"./ScriptExpression":1733,"./utils":1745},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("./utils"),s=e("./RegistryType"),i=e("./ScriptExpression"),a=Object.values(s.RegistryTypes).filter(e=>!!e.getTag()).map(e=>e.getTag()),o=Object.values(i.ScriptExpressions).map(e=>e.getTag());(0,r.patchTags)(a.concat(o))}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/patchCBOR.js"}],[1744,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/types.js"}],[1745,{"./lib":1742},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.patchTags=void 0;const r=e("./lib"),s=[];n.patchTags=e=>{e.forEach(e=>{s.find(t=>t===e)||((0,r.addSemanticEncode)(e,t=>{if(t instanceof r.DataItem&&t.getTag()===e)return t.getData()}),(0,r.addSemanticDecode)(e,t=>new r.DataItem(t,e)),s.push(e))})}}}},{package:"@metamask/eth-qr-keyring>@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules/@metamask/eth-qr-keyring/node_modules/@keystonehq/bc-ur-registry/dist/utils.js"}],[1746,{"./nil.js":1749,"./parse.js":1750,"./stringify.js":1754,"./v1.js":1755,"./v3.js":1756,"./v4.js":1758,"./v5.js":1759,"./validate.js":1760,"./version.js":1761},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return l.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}});var r=m(e("./v1.js")),s=m(e("./v3.js")),i=m(e("./v4.js")),a=m(e("./v5.js")),o=m(e("./nil.js")),c=m(e("./version.js")),u=m(e("./validate.js")),l=m(e("./stringify.js")),d=m(e("./parse.js"));function m(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/index.js"}],[1747,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return 14+(e+64>>>9<<4)+1}function s(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function i(e,t,n,r,i,a){return s((o=s(s(t,e),s(r,a)))<<(c=i)|o>>>32-c,n);var o,c}function a(e,t,n,r,s,a,o){return i(t&n|~t&r,e,t,s,a,o)}function o(e,t,n,r,s,a,o){return i(t&r|n&~r,e,t,s,a,o)}function c(e,t,n,r,s,a,o){return i(t^n^r,e,t,s,a,o)}function u(e,t,n,r,s,a,o){return i(n^(t|~r),e,t,s,a,o)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var l=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,r="0123456789abcdef";for(let s=0;s<n;s+=8){const n=e[s>>5]>>>s%32&255,i=parseInt(r.charAt(n>>>4&15)+r.charAt(15&n),16);t.push(i)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[r(t)-1]=t;let n=1732584193,i=-271733879,l=-1732584194,d=271733878;for(let t=0;t<e.length;t+=16){const r=n,m=i,h=l,f=d;n=a(n,i,l,d,e[t],7,-680876936),d=a(d,n,i,l,e[t+1],12,-389564586),l=a(l,d,n,i,e[t+2],17,606105819),i=a(i,l,d,n,e[t+3],22,-1044525330),n=a(n,i,l,d,e[t+4],7,-176418897),d=a(d,n,i,l,e[t+5],12,1200080426),l=a(l,d,n,i,e[t+6],17,-1473231341),i=a(i,l,d,n,e[t+7],22,-45705983),n=a(n,i,l,d,e[t+8],7,1770035416),d=a(d,n,i,l,e[t+9],12,-1958414417),l=a(l,d,n,i,e[t+10],17,-42063),i=a(i,l,d,n,e[t+11],22,-1990404162),n=a(n,i,l,d,e[t+12],7,1804603682),d=a(d,n,i,l,e[t+13],12,-40341101),l=a(l,d,n,i,e[t+14],17,-1502002290),i=a(i,l,d,n,e[t+15],22,1236535329),n=o(n,i,l,d,e[t+1],5,-165796510),d=o(d,n,i,l,e[t+6],9,-1069501632),l=o(l,d,n,i,e[t+11],14,643717713),i=o(i,l,d,n,e[t],20,-373897302),n=o(n,i,l,d,e[t+5],5,-701558691),d=o(d,n,i,l,e[t+10],9,38016083),l=o(l,d,n,i,e[t+15],14,-660478335),i=o(i,l,d,n,e[t+4],20,-405537848),n=o(n,i,l,d,e[t+9],5,568446438),d=o(d,n,i,l,e[t+14],9,-1019803690),l=o(l,d,n,i,e[t+3],14,-187363961),i=o(i,l,d,n,e[t+8],20,1163531501),n=o(n,i,l,d,e[t+13],5,-1444681467),d=o(d,n,i,l,e[t+2],9,-51403784),l=o(l,d,n,i,e[t+7],14,1735328473),i=o(i,l,d,n,e[t+12],20,-1926607734),n=c(n,i,l,d,e[t+5],4,-378558),d=c(d,n,i,l,e[t+8],11,-2022574463),l=c(l,d,n,i,e[t+11],16,1839030562),i=c(i,l,d,n,e[t+14],23,-35309556),n=c(n,i,l,d,e[t+1],4,-1530992060),d=c(d,n,i,l,e[t+4],11,1272893353),l=c(l,d,n,i,e[t+7],16,-155497632),i=c(i,l,d,n,e[t+10],23,-1094730640),n=c(n,i,l,d,e[t+13],4,681279174),d=c(d,n,i,l,e[t],11,-358537222),l=c(l,d,n,i,e[t+3],16,-722521979),i=c(i,l,d,n,e[t+6],23,76029189),n=c(n,i,l,d,e[t+9],4,-640364487),d=c(d,n,i,l,e[t+12],11,-421815835),l=c(l,d,n,i,e[t+15],16,530742520),i=c(i,l,d,n,e[t+2],23,-995338651),n=u(n,i,l,d,e[t],6,-198630844),d=u(d,n,i,l,e[t+7],10,1126891415),l=u(l,d,n,i,e[t+14],15,-1416354905),i=u(i,l,d,n,e[t+5],21,-57434055),n=u(n,i,l,d,e[t+12],6,1700485571),d=u(d,n,i,l,e[t+3],10,-1894986606),l=u(l,d,n,i,e[t+10],15,-1051523),i=u(i,l,d,n,e[t+1],21,-2054922799),n=u(n,i,l,d,e[t+8],6,1873313359),d=u(d,n,i,l,e[t+15],10,-30611744),l=u(l,d,n,i,e[t+6],15,-1560198380),i=u(i,l,d,n,e[t+13],21,1309151649),n=u(n,i,l,d,e[t+4],6,-145523070),d=u(d,n,i,l,e[t+11],10,-1120210379),l=u(l,d,n,i,e[t+2],15,718787259),i=u(i,l,d,n,e[t+9],21,-343485551),n=s(n,r),i=s(i,m),l=s(l,h),d=s(d,f)}return[n,i,l,d]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(r(t));for(let r=0;r<t;r+=8)n[r>>5]|=(255&e[r/8])<<r%32;return n}(e),8*e.length))};n.default=l}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/md5-browser.js"}],[1748,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=r}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/native-browser.js"}],[1749,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/nil.js"}],[1750,{"./validate.js":1760},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var i=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/parse.js"}],[1751,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/regex.js"}],[1752,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let r;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!r&&(r="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!r))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return r(s)};const s=new Uint8Array(16)}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/rng-browser.js"}],[1753,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n,r){switch(e){case 0:return t&n^~t&r;case 1:case 3:return t^n^r;case 2:return t&n^t&r^n&r}}function s(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var i=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const i=e.length/4+2,a=Math.ceil(i/16),o=new Array(a);for(let t=0;t<a;++t){const n=new Uint32Array(16);for(let r=0;r<16;++r)n[r]=e[64*t+4*r]<<24|e[64*t+4*r+1]<<16|e[64*t+4*r+2]<<8|e[64*t+4*r+3];o[t]=n}o[a-1][14]=8*(e.length-1)/Math.pow(2,32),o[a-1][14]=Math.floor(o[a-1][14]),o[a-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<a;++e){const i=new Uint32Array(80);for(let t=0;t<16;++t)i[t]=o[e][t];for(let e=16;e<80;++e)i[e]=s(i[e-3]^i[e-8]^i[e-14]^i[e-16],1);let a=n[0],c=n[1],u=n[2],l=n[3],d=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),o=s(a,5)+r(n,c,u,l)+d+t[n]+i[e]>>>0;d=l,l=u,u=s(c,30)>>>0,c=a,a=o}n[0]=n[0]+a>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+u>>>0,n[3]=n[3]+l>>>0,n[4]=n[4]+d>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/sha1-browser.js"}],[1754,{"./validate.js":1760},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=a;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};const i=[];for(let e=0;e<256;++e)i.push((e+256).toString(16).slice(1));function a(e,t=0){return i[e[t+0]]+i[e[t+1]]+i[e[t+2]]+i[e[t+3]]+"-"+i[e[t+4]]+i[e[t+5]]+"-"+i[e[t+6]]+i[e[t+7]]+"-"+i[e[t+8]]+i[e[t+9]]+"-"+i[e[t+10]]+i[e[t+11]]+i[e[t+12]]+i[e[t+13]]+i[e[t+14]]+i[e[t+15]]}var o=function(e,t=0){const n=a(e,t);if(!(0,s.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/stringify.js"}],[1755,{"./rng.js":1752,"./stringify.js":1754},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./rng.js"))&&r.__esModule?r:{default:r},i=e("./stringify.js");let a,o,c=0,u=0;var l=function(e,t,n){let r=t&&n||0;const l=t||new Array(16);let d=(e=e||{}).node||a,m=e.clockseq!==undefined?e.clockseq:o;if(null==d||null==m){const t=e.random||(e.rng||s.default)();null==d&&(d=a=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==m&&(m=o=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),f=e.nsecs!==undefined?e.nsecs:u+1;const p=h-c+(f-u)/1e4;if(p<0&&e.clockseq===undefined&&(m=m+1&16383),(p<0||h>c)&&e.nsecs===undefined&&(f=0),f>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,u=f,o=m,h+=122192928e5;const y=(1e4*(268435455&h)+f)%4294967296;l[r++]=y>>>24&255,l[r++]=y>>>16&255,l[r++]=y>>>8&255,l[r++]=255&y;const g=h/4294967296*1e4&268435455;l[r++]=g>>>8&255,l[r++]=255&g,l[r++]=g>>>24&15|16,l[r++]=g>>>16&255,l[r++]=m>>>8|128,l[r++]=255&m;for(let e=0;e<6;++e)l[r+e]=d[e];return t||(0,i.unsafeStringify)(l)};n.default=l}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v1.js"}],[1756,{"./md5.js":1747,"./v35.js":1757},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./v35.js")),s=i(e("./md5.js"));function i(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v3",48,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v3.js"}],[1757,{"./parse.js":1750,"./stringify.js":1754},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function r(e,r,a,o){var c;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof r&&(r=(0,i.default)(r)),16!==(null===(c=r)||void 0===c?void 0:c.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let u=new Uint8Array(16+e.length);if(u.set(r),u.set(e,r.length),u=n(u),u[6]=15&u[6]|t,u[8]=63&u[8]|128,a){o=o||0;for(let e=0;e<16;++e)a[o+e]=u[e];return a}return(0,s.unsafeStringify)(u)}try{r.name=e}catch(e){}return r.DNS=a,r.URL=o,r};var r,s=e("./stringify.js"),i=(r=e("./parse.js"))&&r.__esModule?r:{default:r};const a="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=a;const o="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v35.js"}],[1758,{"./native.js":1748,"./rng.js":1752,"./stringify.js":1754},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=a(e("./native.js")),s=a(e("./rng.js")),i=e("./stringify.js");function a(e){return e&&e.__esModule?e:{default:e}}var o=function(e,t,n){if(r.default.randomUUID&&!t&&!e)return r.default.randomUUID();const a=(e=e||{}).random||(e.rng||s.default)();if(a[6]=15&a[6]|64,a[8]=63&a[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=a[e];return t}return(0,i.unsafeStringify)(a)};n.default=o}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v4.js"}],[1759,{"./sha1.js":1753,"./v35.js":1757},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./v35.js")),s=i(e("./sha1.js"));function i(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v5",80,s.default);n.default=a}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/v5.js"}],[1760,{"./regex.js":1751},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./regex.js"))&&r.__esModule?r:{default:r};var i=function(e){return"string"==typeof e&&s.default.test(e)};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/validate.js"}],[1761,{"./validate.js":1760},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var i=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=i}}},{package:"@metamask/eth-qr-keyring>uuid",file:"node_modules/@metamask/eth-qr-keyring/node_modules/uuid/dist/version.js"}],[1762,{"json-rpc-random-id":4217,xtend:5257},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("json-rpc-random-id")(),s=e("xtend");function i(e){this.currentProvider=e}function a(e){return function(...t){const n=t.pop();this.sendAsync({method:e,params:t},n)}}function o(e,t){return function(...n){const r=n.pop();n.length<e&&n.push("latest"),this.sendAsync({method:t,params:n},r)}}t.exports=i,i.prototype.getBalance=o(2,"eth_getBalance"),i.prototype.getCode=o(2,"eth_getCode"),i.prototype.getTransactionCount=o(2,"eth_getTransactionCount"),i.prototype.getStorageAt=o(3,"eth_getStorageAt"),i.prototype.call=o(2,"eth_call"),i.prototype.protocolVersion=a("eth_protocolVersion"),i.prototype.syncing=a("eth_syncing"),i.prototype.coinbase=a("eth_coinbase"),i.prototype.mining=a("eth_mining"),i.prototype.hashrate=a("eth_hashrate"),i.prototype.gasPrice=a("eth_gasPrice"),i.prototype.accounts=a("eth_accounts"),i.prototype.blockNumber=a("eth_blockNumber"),i.prototype.getBlockTransactionCountByHash=a("eth_getBlockTransactionCountByHash"),i.prototype.getBlockTransactionCountByNumber=a("eth_getBlockTransactionCountByNumber"),i.prototype.getUncleCountByBlockHash=a("eth_getUncleCountByBlockHash"),i.prototype.getUncleCountByBlockNumber=a("eth_getUncleCountByBlockNumber"),i.prototype.sign=a("eth_sign"),i.prototype.sendTransaction=a("eth_sendTransaction"),i.prototype.sendRawTransaction=a("eth_sendRawTransaction"),i.prototype.estimateGas=a("eth_estimateGas"),i.prototype.getBlockByHash=a("eth_getBlockByHash"),i.prototype.getBlockByNumber=a("eth_getBlockByNumber"),i.prototype.getTransactionByHash=a("eth_getTransactionByHash"),i.prototype.getTransactionByBlockHashAndIndex=a("eth_getTransactionByBlockHashAndIndex"),i.prototype.getTransactionByBlockNumberAndIndex=a("eth_getTransactionByBlockNumberAndIndex"),i.prototype.getTransactionReceipt=a("eth_getTransactionReceipt"),i.prototype.getUncleByBlockHashAndIndex=a("eth_getUncleByBlockHashAndIndex"),i.prototype.getUncleByBlockNumberAndIndex=a("eth_getUncleByBlockNumberAndIndex"),i.prototype.getCompilers=a("eth_getCompilers"),i.prototype.compileLLL=a("eth_compileLLL"),i.prototype.compileSolidity=a("eth_compileSolidity"),i.prototype.compileSerpent=a("eth_compileSerpent"),i.prototype.newFilter=a("eth_newFilter"),i.prototype.newBlockFilter=a("eth_newBlockFilter"),i.prototype.newPendingTransactionFilter=a("eth_newPendingTransactionFilter"),i.prototype.uninstallFilter=a("eth_uninstallFilter"),i.prototype.getFilterChanges=a("eth_getFilterChanges"),i.prototype.getFilterLogs=a("eth_getFilterLogs"),i.prototype.getLogs=a("eth_getLogs"),i.prototype.getWork=a("eth_getWork"),i.prototype.submitWork=a("eth_submitWork"),i.prototype.submitHashrate=a("eth_submitHashrate"),i.prototype.sendAsync=function(e,t){var n;this.currentProvider.sendAsync((n=e,s({id:r(),jsonrpc:"2.0",params:[]},n)),function(e,n){let r=e;return!e&&n.error&&(r=new Error(`EthQuery - RPC Error - ${n.error.message}`)),r?t(r):t(null,n.result)})}}}},{package:"@metamask/controller-utils>@metamask/eth-query",file:"node_modules/@metamask/eth-query/index.js"}],[1763,{"./utils":1768,"@scure/base":1785,buffer:3614,tweetnacl:5174},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.getEncryptionPublicKey=n.decryptSafely=n.decrypt=n.encryptSafely=n.encrypt=void 0;const a=e("@scure/base"),o=i(e("tweetnacl")),c=e("./utils");function u({publicKey:e,data:t,version:n}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(n))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===n){if("string"!=typeof t)throw new Error("Message data must be given as a string");const n=o.box.keyPair();let r;try{r=a.base64.decode(e)}catch(e){throw new Error("Bad public key")}const s=a.utf8.decode(t),i=o.randomBytes(o.box.nonceLength),c=o.box(s,i,r,n.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:a.base64.encode(i),ephemPublicKey:a.base64.encode(n.publicKey),ciphertext:a.base64.encode(c)}}throw new Error("Encryption type/version not supported")}function l({encryptedData:e,privateKey:n}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(n))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const r=t.from(n,"hex"),s=o.box.keyPair.fromSecretKey(r).secretKey,i=a.base64.decode(e.nonce),c=a.base64.decode(e.ciphertext),u=a.base64.decode(e.ephemPublicKey),l=o.box.open(c,i,u,s);try{if(!l)throw new Error;const e=a.utf8.encode(l);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}n.encrypt=u,n.encryptSafely=function({publicKey:e,data:n,version:r}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(n))throw new Error("Missing data parameter");if((0,c.isNullish)(r))throw new Error("Missing version parameter");if("object"==typeof n&&n&&"toJSON"in n)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const s={data:n,padding:""},i=t.byteLength(JSON.stringify(s),"utf-8")%2048;let a=0;return i>0&&(a=2048-i-16),s.padding="0".repeat(a),u({publicKey:e,data:JSON.stringify(s),version:r})},n.decrypt=l,n.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(l({encryptedData:e,privateKey:t})).data},n.getEncryptionPublicKey=function(e){const n=t.from(e,"hex"),r=o.box.keyPair.fromSecretKey(n).publicKey;return a.base64.encode(r)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/encryption.js"}],[1764,{"./encryption":1763,"./personal-sign":1765,"./sign-eip7702-authorization":1766,"./sign-typed-data":1767,"./utils":1768},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.normalize=n.concatSig=void 0,s(e("./personal-sign"),n),s(e("./sign-typed-data"),n),s(e("./encryption"),n),s(e("./sign-eip7702-authorization"),n);var i=e("./utils");Object.defineProperty(n,"concatSig",{enumerable:!0,get:function(){return i.concatSig}}),Object.defineProperty(n,"normalize",{enumerable:!0,get:function(){return i.normalize}})}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/index.js"}],[1765,{"./utils":1768,"@ethereumjs/util":1777},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.extractPublicKey=n.recoverPersonalSignature=n.personalSign=void 0;const r=e("@ethereumjs/util"),s=e("./utils");function i(e,t){const n=(0,r.hashPersonalMessage)((0,s.legacyToBuffer)(e));return(0,s.recoverPublicKey)(n,t)}n.personalSign=function({privateKey:e,data:t}){if((0,s.isNullish)(t))throw new Error("Missing data parameter");if((0,s.isNullish)(e))throw new Error("Missing privateKey parameter");const n=(0,s.legacyToBuffer)(t),i=(0,r.hashPersonalMessage)(n),a=(0,r.ecsign)(i,e);return(0,s.concatSig)((0,r.toBuffer)(a.v),a.r,a.s)},n.recoverPersonalSignature=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");const n=i(e,t),a=(0,r.publicToAddress)(n);return(0,r.bufferToHex)(a)},n.extractPublicKey=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");return`0x${i(e,t).toString("hex")}`}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],[1766,{"./utils":1768,"@ethereumjs/rlp":1769,"@ethereumjs/util":1777,"@metamask/utils":2656,buffer:3614,"ethereum-cryptography/keccak":3842},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashEIP7702Authorization=n.recoverEIP7702Authorization=n.signEIP7702Authorization=void 0;const r=e("@ethereumjs/rlp"),s=e("@ethereumjs/util"),i=e("@metamask/utils"),a=e("ethereum-cryptography/keccak"),o=e("./utils");function c(e){u(e);const n=(0,r.encode)(e),s=t.concat([t.from("05","hex"),n]);return t.from((0,a.keccak256)(s))}function u(e){if((0,o.isNullish)(e))throw new Error("Missing authorization parameter");const[t,n,r]=e;if((0,o.isNullish)(t))throw new Error("Missing chainId parameter");if((0,o.isNullish)(n))throw new Error("Missing contractAddress parameter");if((0,o.isNullish)(r))throw new Error("Missing nonce parameter")}n.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(u(t),(0,o.isNullish)(e))throw new Error("Missing privateKey parameter");const n=c(t),{r:r,s:i,v:a}=(0,s.ecsign)(n,e),l=(0,s.toBuffer)(a);return(0,o.concatSig)(l,r,i)},n.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(u(t),(0,o.isNullish)(e))throw new Error("Missing signature parameter");const n=c(t),r=(0,o.recoverPublicKey)(n,e),a=(0,s.publicToAddress)(r);return(0,i.bytesToHex)(a)},n.hashEIP7702Authorization=c}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],[1767,{"./utils":1768,"@ethereumjs/util":1777,"@metamask/abi-utils":1001,"@metamask/abi-utils/dist/parsers":1010,"@metamask/abi-utils/dist/utils":1018,"@metamask/utils":2656,"ethereum-cryptography/keccak":3842},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.recoverTypedSignature=n.signTypedData=n.typedSignatureHash=n.TypedDataUtils=n.TYPED_MESSAGE_SCHEMA=n.SignTypedDataVersion=void 0;const r=e("@ethereumjs/util"),s=e("@metamask/abi-utils"),i=e("@metamask/abi-utils/dist/parsers"),a=e("@metamask/abi-utils/dist/utils"),o=e("@metamask/utils"),c=e("ethereum-cryptography/keccak"),u=e("./utils");var l;function d(e,t){if(!Object.keys(l).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function m(e,t){(0,o.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const n=BigInt(t),r=(0,i.getLength)(e),s=BigInt(2)**BigInt(r)-BigInt(1);return(0,o.assert)(n>=-s&&n<=s,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),n}function h(e){let t=BigInt(0);for(let n=0;n<e.length;n++){const r=BigInt(e.charCodeAt(n)-48);t*=BigInt(10),t+=r>=49?r-BigInt(49)+BigInt(10):r>=17?r-BigInt(17)+BigInt(10):r}return(0,a.padStart)((0,o.bigIntToBytes)(t),20)}function f(e,t,n,i,u){if(d(u,[l.V3,l.V4]),e[n]!==undefined)return["bytes32",u===l.V4&&null==i?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,r.arrToBufArr)((0,c.keccak256)(p(n,i,e,u)))];if("function"===n)throw new Error('Unsupported or invalid type: "function"');if(i===undefined)throw new Error(`missing value for field ${t} of type ${n}`);if("address"===n){if("number"==typeof i)return["address",(0,a.padStart)((0,o.numberToBytes)(i),20)];if((0,o.isStrictHexString)(i))return["address",(0,o.add0x)(i)];if("string"==typeof i)return["address",h(i).subarray(0,20)]}if("bool"===n)return["bool",Boolean(i)];if("bytes"===n)return"number"==typeof i?i=(0,o.numberToBytes)(i):(0,o.isStrictHexString)(i)||"0x"===i?i=(0,o.hexToBytes)(i):"string"==typeof i&&(i=(0,o.stringToBytes)(i)),["bytes32",(0,r.arrToBufArr)((0,c.keccak256)(i))];if(n.startsWith("bytes")&&"bytes"!==n&&!n.includes("["))return"number"==typeof i?i<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,o.bigIntToBytes)(BigInt(i))]:(0,o.isStrictHexString)(i)?["bytes32",(0,o.hexToBytes)(i)]:["bytes32",i];if(n.startsWith("int")&&!n.includes("[")){const e=m(n,i);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===n)return i="number"==typeof i?(0,o.numberToBytes)(i):(0,o.stringToBytes)(null!=i?i:""),["bytes32",(0,r.arrToBufArr)((0,c.keccak256)(i))];if(n.endsWith("]")){if(u===l.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const a=n.slice(0,n.lastIndexOf("[")),o=i.map(n=>f(e,t,a,n,u));return["bytes32",(0,r.arrToBufArr)((0,c.keccak256)((0,s.encode)(o.map(([e])=>e),o.map(([,e])=>e))))]}return[n,i]}function p(e,t,n,i){d(i,[l.V3,l.V4]);const a=["bytes32"],o=[v(e,n)];for(const r of n[e]){if(i===l.V3&&t[r.name]===undefined)continue;const[e,s]=f(n,r.name,r.type,t[r.name],i);a.push(e),o.push(s)}return(0,r.arrToBufArr)((0,s.encode)(a,o))}function y(e,t){let n="";const r=g(e,t);r.delete(e);const s=[e,...Array.from(r).sort()];for(const e of s){if(!t[e])throw new Error(`No type definition specified: ${e}`);n+=`${e}(${t[e].map(({name:e,type:t})=>`${t} ${e}`).join(",")})`}return n}function g(e,t,n=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const r=e.match(/^\w*/u);if([e]=r,n.has(e)||t[e]===undefined)return n;n.add(e);for(const r of t[e])g(r.type,t,n);return n}function b(e,t,n,s){d(s,[l.V3,l.V4]);const i=p(e,t,n,s),a=(0,c.keccak256)(i);return(0,r.arrToBufArr)(a)}function v(e,t){const n=(0,o.stringToBytes)(y(e,t));return(0,r.arrToBufArr)((0,c.keccak256)(n))}function k(e){const t={};for(const r in n.TYPED_MESSAGE_SCHEMA.properties)e[r]&&(t[r]=e[r]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function E(e,t){d(t,[l.V3,l.V4]);const n=k(e),{domain:r}=n;return b("EIP712Domain",r,{EIP712Domain:n.types.EIP712Domain},t)}function w(e,t){if((0,i.isArrayType)(e)&&Array.isArray(t)){const[n]=(0,i.getArrayType)(e);return t.map(e=>w(n,e))}if("address"===e){if((0,o.isStrictHexString)(t))return(0,a.padStart)((0,o.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,a.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const n=(0,i.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,o.numberToBytes)(t).subarray(0,n);if((0,o.isStrictHexString)(t))return(0,o.hexToBytes)(t).subarray(0,n);if(t instanceof Uint8Array)return t.subarray(0,n)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const n=(0,i.getLength)(e);return BigInt.asIntN(n,BigInt(t))}return t}function T(e,t){return t.map(t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const n=m(e,t);if(n>=BigInt(0))return(0,a.padStart)((0,o.bigIntToBytes)(n),32);const r=(0,i.getLength)(e),s=BigInt.asIntN(r,n);return(0,o.signedBigIntToBytes)(s,32)}return t})}function A(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const n=e.map(({name:e,type:t,value:n})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(r=n,r.map(e=>"number"==typeof e?(0,a.padStart)((0,o.numberToBytes)(e),32):(0,o.isStrictHexString)(e)?(0,a.padStart)((0,o.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,a.padStart)(e.subarray(0,32),32):e))};var r;if(t.startsWith("int")&&(0,i.isArrayType)(t)){const[r,s]=(0,i.getArrayType)(t);return{name:e,type:`bytes32[${null!=s?s:""}]`,value:T(r,n)}}return{name:e,type:t,value:w(t,n)}}),l=n.map(e=>"bytes"!==e.type?e.value:(0,u.legacyToBuffer)(e.value)),d=n.map(e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type}),m=e.map(e=>{if(!e.name)throw t;return`${e.type} ${e.name}`});return(0,r.arrToBufArr)((0,c.keccak256)((0,s.encodePacked)(["bytes32","bytes32"],[(0,c.keccak256)((0,s.encodePacked)(["string[]"],[m],!0)),(0,c.keccak256)((0,s.encodePacked)(d,l,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(l=n.SignTypedDataVersion||(n.SignTypedDataVersion={})),n.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},n.TypedDataUtils={encodeData:p,encodeType:y,findTypeDependencies:g,hashStruct:b,hashType:v,sanitizeData:k,eip712Hash:function(e,t){d(t,[l.V3,l.V4]);const n=k(e),s=[(0,o.hexToBytes)("1901")];return s.push(E(e,t)),"EIP712Domain"!==n.primaryType&&s.push(b(n.primaryType,n.message,n.types,t)),(0,r.arrToBufArr)((0,c.keccak256)((0,o.concatBytes)(s)))},eip712DomainHash:E},n.typedSignatureHash=function(e){const t=A(e);return(0,o.bytesToHex)(t)},n.signTypedData=function({privateKey:e,data:t,version:s}){if(d(s),(0,u.isNullish)(t))throw new Error("Missing data parameter");if((0,u.isNullish)(e))throw new Error("Missing private key parameter");const i=s===l.V1?A(t):n.TypedDataUtils.eip712Hash(t,s),a=(0,r.ecsign)(i,e);return(0,u.concatSig)((0,r.arrToBufArr)((0,o.bigIntToBytes)(a.v)),a.r,a.s)},n.recoverTypedSignature=function({data:e,signature:t,version:s}){if(d(s),(0,u.isNullish)(e))throw new Error("Missing data parameter");if((0,u.isNullish)(t))throw new Error("Missing signature parameter");const i=s===l.V1?A(e):n.TypedDataUtils.eip712Hash(e,s),a=(0,u.recoverPublicKey)(i,t),c=(0,r.publicToAddress)(a);return(0,o.bytesToHex)(c)}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],[1768,{"@ethereumjs/util":1777,"@metamask/utils":2656,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.normalize=n.recoverPublicKey=n.concatSig=n.legacyToBuffer=n.isNullish=n.padWithZeroes=void 0;const r=e("@ethereumjs/util"),s=e("@metamask/utils");function i(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function a(e){return null===e||e===undefined}n.padWithZeroes=i,n.isNullish=a,n.legacyToBuffer=function(e){return"string"!=typeof e||(0,r.isHexString)(e)?(0,r.toBuffer)(e):t.from(e)},n.concatSig=function(e,t,n){const a=(0,r.fromSigned)(t),o=(0,r.fromSigned)(n),c=(0,r.bufferToInt)(e),u=i((0,r.toUnsigned)(a).toString("hex"),64),l=i((0,r.toUnsigned)(o).toString("hex"),64),d=(0,s.remove0x)((0,s.numberToHex)(c));return(0,s.add0x)(u.concat(l,d))},n.recoverPublicKey=function(e,t){const n=(0,r.fromRpcSig)(t);return(0,r.ecrecover)(e,n.v,n.r,n.s)},n.normalize=function(e){if(a(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,s.numberToBytes)(e);e=(0,s.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,s.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/utils.js"}],[1769,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(Array.isArray(e)){const t=[];let n=0;for(let s=0;s<e.length;s++){const i=r(e[s]);t.push(i),n+=i.length}return h(a(n,192),...t)}const t=g(e);return 1===t.length&&t[0]<128?t:h(a(t.length,128),t)}function s(e,t,n){if(n>e.length)throw new Error("invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds");return e.slice(t,n)}function i(e){if(0===e[0])throw new Error("invalid RLP: extra zeros");return d(l(e))}function a(e,t){if(e<56)return Uint8Array.from([e+t]);const n=p(e),r=p(t+55+n.length/2);return Uint8Array.from(m(r+n))}function o(e,t=!1){if(null==e||0===e.length)return Uint8Array.from([]);const n=c(g(e));if(t)return n;if(0!==n.remainder.length)throw new Error("invalid RLP: remainder must be zero");return n.data}function c(e){let t,n,r,a,o;const u=[],l=e[0];if(l<=127)return{data:e.slice(0,1),remainder:e.slice(1)};if(l<=183){if(t=l-127,r=128===l?Uint8Array.from([]):s(e,1,t),2===t&&r[0]<128)throw new Error("invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed");return{data:r,remainder:e.slice(t)}}if(l<=191){if(n=l-182,e.length-1<n)throw new Error("invalid RLP: not enough bytes for string length");if(t=i(s(e,1,n)),t<=55)throw new Error("invalid RLP: expected string length to be greater than 55");return r=s(e,n,t+n),{data:r,remainder:e.slice(t+n)}}if(l<=247){for(t=l-191,a=s(e,1,t);a.length;)o=c(a),u.push(o.data),a=o.remainder;return{data:u,remainder:e.slice(t)}}{if(n=l-246,t=i(s(e,1,n)),t<56)throw new Error("invalid RLP: encoded list too short");const r=n+t;if(r>e.length)throw new Error("invalid RLP: total length is larger than the data");for(a=s(e,n,r);a.length;)o=c(a),u.push(o.data),a=o.remainder;return{data:u,remainder:e.slice(r)}}}Object.defineProperty(n,"__esModule",{value:!0}),n.RLP=n.utils=n.decode=n.encode=void 0,n.encode=r,n.decode=o;const u=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function l(e){let t="";for(let n=0;n<e.length;n++)t+=u[e[n]];return t}function d(e){const t=Number.parseInt(e,16);if(Number.isNaN(t))throw new Error("Invalid byte sequence");return t}function m(e){if("string"!=typeof e)throw new TypeError("hexToBytes: expected string, got "+typeof e);if(e.length%2)throw new Error("hexToBytes: received invalid unpadded hex");const t=new Uint8Array(e.length/2);for(let n=0;n<t.length;n++){const r=2*n;t[n]=d(e.slice(r,r+2))}return t}function h(...e){if(1===e.length)return e[0];const t=e.reduce((e,t)=>e+t.length,0),n=new Uint8Array(t);for(let t=0,r=0;t<e.length;t++){const s=e[t];n.set(s,r),r+=s.length}return n}function f(e){return(new TextEncoder).encode(e)}function p(e){if(e<0)throw new Error("Invalid integer as argument, must be unsigned!");const t=e.toString(16);return t.length%2?`0${t}`:t}function y(e){return e.length>=2&&"0"===e[0]&&"x"===e[1]}function g(e){if(e instanceof Uint8Array)return e;if("string"==typeof e)return y(e)?m((t="string"!=typeof(n=e)?n:y(n)?n.slice(2):n).length%2?`0${t}`:t):f(e);var t,n;if("number"==typeof e||"bigint"==typeof e)return e?m(p(e)):Uint8Array.from([]);if(null===e||e===undefined)return Uint8Array.from([]);throw new Error("toBytes: received unsupported type "+typeof e)}n.utils={bytesToHex:l,concatBytes:h,hexToBytes:m,utf8ToBytes:f},n.RLP={encode:r,decode:o}}}},{package:"@metamask/eth-sig-util>@ethereumjs/rlp",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/rlp/dist/index.js"}],[1770,{"./bytes":1773,"./constants":1774,"./helpers":1776,"./internal":1778,"@ethereumjs/rlp":1769,buffer:3614,"ethereum-cryptography/keccak":3842,"ethereum-cryptography/secp256k1":3863,"ethereum-cryptography/utils":3865},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.accountBodyToRLP=n.accountBodyToSlim=n.accountBodyFromSlim=n.isZeroAddress=n.zeroAddress=n.importPublic=n.privateToAddress=n.privateToPublic=n.publicToAddress=n.pubToAddress=n.isValidPublic=n.isValidPrivate=n.generateAddress2=n.generateAddress=n.isValidChecksumAddress=n.toChecksumAddress=n.isValidAddress=n.Account=void 0;const r=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),i=e("ethereum-cryptography/secp256k1"),a=e("ethereum-cryptography/utils"),o=e("./bytes"),c=e("./constants"),u=e("./helpers"),l=e("./internal"),d=BigInt(0);class m{constructor(e=d,t=d,n=c.KECCAK256_RLP,r=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=n,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:n,storageRoot:r,codeHash:s}=e;return new m(t!==undefined?(0,o.bufferToBigInt)((0,o.toBuffer)(t)):undefined,n!==undefined?(0,o.bufferToBigInt)((0,o.toBuffer)(n)):undefined,r!==undefined?(0,o.toBuffer)(r):undefined,s!==undefined?(0,o.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,o.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,n,r,s]=e;return new m((0,o.bufferToBigInt)(t),(0,o.bufferToBigInt)(n),r,s)}_validate(){if(this.nonce<d)throw new Error("nonce must be greater than zero");if(this.balance<d)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,o.bigIntToUnpaddedBuffer)(this.nonce),(0,o.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,o.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===d&&this.nonce===d&&this.codeHash.equals(c.KECCAK256_NULL)}}n.Account=m;n.isValidAddress=function(e){try{(0,u.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};n.toChecksumAddress=function(e,n){(0,u.assertIsHexString)(e);const r=(0,l.stripHexPrefix)(e).toLowerCase();let i="";if(n!==undefined){i=(0,o.bufferToBigInt)((0,o.toBuffer)(n)).toString()+"0x"}const c=t.from(i+r,"utf8"),d=(0,a.bytesToHex)((0,s.keccak256)(c));let m="0x";for(let e=0;e<r.length;e++)parseInt(d[e],16)>=8?m+=r[e].toUpperCase():m+=r[e];return m};n.isValidChecksumAddress=function(e,t){return(0,n.isValidAddress)(e)&&(0,n.toChecksumAddress)(e,t)===e};n.generateAddress=function(e,n){return(0,u.assertIsBuffer)(e),(0,u.assertIsBuffer)(n),(0,o.bufferToBigInt)(n)===BigInt(0)?t.from((0,s.keccak256)(r.RLP.encode((0,o.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(r.RLP.encode((0,o.bufArrToArr)([e,n])))).slice(-20)};n.generateAddress2=function(e,n,r){if((0,u.assertIsBuffer)(e),(0,u.assertIsBuffer)(n),(0,u.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==n.length)throw new Error("Expected salt to be of length 32");const i=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,n,(0,s.keccak256)(r)]));return(0,o.toBuffer)(i).slice(-20)};n.isValidPrivate=function(e){return i.secp256k1.utils.isValidPrivateKey(e)};n.isValidPublic=function(e,n=!1){if((0,u.assertIsBuffer)(e),64===e.length)try{return i.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!n)return!1;try{return i.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};n.pubToAddress=function(e,n=!1){if((0,u.assertIsBuffer)(e),n&&64!==e.length&&(e=t.from(i.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},n.publicToAddress=n.pubToAddress;n.privateToPublic=function(e){return(0,u.assertIsBuffer)(e),t.from(i.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};n.privateToAddress=function(e){return(0,n.publicToAddress)((0,n.privateToPublic)(e))};n.importPublic=function(e){return(0,u.assertIsBuffer)(e),64!==e.length&&(e=t.from(i.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};n.zeroAddress=function(){const e=(0,o.zeros)(20);return(0,o.bufferToHex)(e)};function h(e){const[t,n,r,s]=e;return[t,n,0===(0,o.arrToBufArr)(r).length?c.KECCAK256_RLP:r,0===(0,o.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}n.isZeroAddress=function(e){try{(0,u.assertIsString)(e)}catch(e){return!1}return(0,n.zeroAddress)()===e},n.accountBodyFromSlim=h;const f=new Uint8Array(0);n.accountBodyToSlim=function(e){const[t,n,r,s]=e;return[t,n,(0,o.arrToBufArr)(r).equals(c.KECCAK256_RLP)?f:r,(0,o.arrToBufArr)(s).equals(c.KECCAK256_NULL)?f:s]},n.accountBodyToRLP=function(e,t=!0){const n=t?h(e):e;return(0,o.arrToBufArr)(r.RLP.encode(n))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],[1771,{"./account":1770,"./bytes":1773,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Address=void 0;const r=e("./account"),s=e("./bytes");class i{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new i((0,s.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new i((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const n=(0,r.pubToAddress)(e);return new i(n)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const n=(0,r.privateToAddress)(e);return new i(n)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new i((0,r.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,n,s){if(!t.isBuffer(n))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new i((0,r.generateAddress2)(e.buf,n,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(i.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),n=BigInt("0xffff");return e>=t&&e<=n}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}n.Address=i}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],[1772,{events:3926},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AsyncEventEmitter=void 0;const r=e("events");class s extends r.EventEmitter{emit(e,...t){let[n,r]=t;const s=this;let i=s._events[e]??[];return r===undefined&&"function"==typeof n&&(r=n,n=undefined),"newListener"!==e&&"removeListener"!==e||(n={event:n,fn:r},r=undefined),i=Array.isArray(i)?i:[i],async function(e,t,n){let r;for await(const s of t)try{s.length<2?s.call(e,n):await new Promise((t,r)=>{s.call(e,n,e=>{e?r(e):t()})})}catch(e){r=e}if(r)throw r}(s,i.slice(),n).then(r).catch(r),s.listenerCount(e)>0}once(e,t){const n=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(s,i){n.removeListener(e,r),t(s,i)}:function(s){n.removeListener(e,r),t(s,r)},n.on(e,r),n}first(e,t){let n=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(n)||(this._events[e]=n=[n]),n.unshift(t),this}before(e,t,n){return this.beforeOrAfter(e,t,n)}after(e,t,n){return this.beforeOrAfter(e,t,n,"after")}beforeOrAfter(e,t,n,r){let s,i,a=this._events[e]??[];const o="after"===r?1:0;if("function"!=typeof n)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(a)||(this._events[e]=a=[a]),i=a.length,s=a.length;s--;)if(a[s]===t){i=s+o;break}return a.splice(i,0,n),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}n.AsyncEventEmitter=s}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],[1773,{"./helpers":1776,"./internal":1778,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.intToUnpaddedBuffer=n.bigIntToUnpaddedBuffer=n.bigIntToHex=n.bufArrToArr=n.arrToBufArr=n.validateNoLeadingZeroes=n.baToJSON=n.toUtf8=n.short=n.addHexPrefix=n.toUnsigned=n.fromSigned=n.bufferToInt=n.bigIntToBuffer=n.bufferToBigInt=n.bufferToHex=n.toBuffer=n.unpadHexString=n.unpadArray=n.unpadBuffer=n.setLengthRight=n.setLengthLeft=n.zeros=n.intToBuffer=n.intToHex=void 0;const r=e("./helpers"),s=e("./internal");n.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};n.intToBuffer=function(e){const r=(0,n.intToHex)(e);return t.from((0,s.padToEven)(r.slice(2)),"hex")};n.zeros=function(e){return t.allocUnsafe(e).fill(0)};const i=function(e,t,r){const s=(0,n.zeros)(t);return r?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};n.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),i(e,t,!1)};n.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),i(e,t,!0)};const a=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};n.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),a(e)};n.unpadArray=function(e){return(0,r.assertIsArray)(e),a(e)};n.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+a(e)};n.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,n.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let n=e.toString(16);return n.length%2&&(n="0"+n),t.from(n,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function o(e){const t=(0,n.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,n.toBuffer)("0x"+e.toString(16))}n.bufferToHex=function(e){return"0x"+(e=(0,n.toBuffer)(e)).toString("hex")},n.bufferToBigInt=o,n.bigIntToBuffer=c;n.bufferToInt=function(e){const t=Number(o(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};n.fromSigned=function(e){return BigInt.asIntN(256,o(e))};n.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};n.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},n.short=function(e,n=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=n?r:r.slice(0,n)+"…"};n.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};n.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,n.baToJSON)(e[r]));return t}};n.validateNoLeadingZeroes=function(e){for(const[t,n]of Object.entries(e))if(n!==undefined&&n.length>0&&0===n[0])throw new Error(`${t} cannot have leading zeroes, received: ${n.toString("hex")}`)},n.arrToBufArr=function e(n){return Array.isArray(n)?n.map(t=>e(t)):t.from(n)},n.bufArrToArr=function e(t){return Array.isArray(t)?t.map(t=>e(t)):Uint8Array.from(t??[])};n.bigIntToHex=e=>"0x"+e.toString(16),n.bigIntToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)(c(e))},n.intToUnpaddedBuffer=function(e){return(0,n.unpadBuffer)((0,n.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],[1774,{buffer:3614,"ethereum-cryptography/secp256k1":3863},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MAX_WITHDRAWALS_PER_PAYLOAD=n.RLP_EMPTY_STRING=n.KECCAK256_RLP=n.KECCAK256_RLP_S=n.KECCAK256_RLP_ARRAY=n.KECCAK256_RLP_ARRAY_S=n.KECCAK256_NULL=n.KECCAK256_NULL_S=n.TWO_POW256=n.SECP256K1_ORDER_DIV_2=n.SECP256K1_ORDER=n.MAX_INTEGER_BIGINT=n.MAX_INTEGER=n.MAX_UINT64=void 0;const r=e("buffer"),s=e("ethereum-cryptography/secp256k1");n.MAX_UINT64=BigInt("0xffffffffffffffff"),n.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),n.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),n.SECP256K1_ORDER=s.secp256k1.CURVE.n,n.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),n.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),n.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",n.KECCAK256_NULL=r.Buffer.from(n.KECCAK256_NULL_S,"hex"),n.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",n.KECCAK256_RLP_ARRAY=r.Buffer.from(n.KECCAK256_RLP_ARRAY_S,"hex"),n.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",n.KECCAK256_RLP=r.Buffer.from(n.KECCAK256_RLP_S,"hex"),n.RLP_EMPTY_STRING=r.Buffer.from([128]),n.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],[1775,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compactBytesToNibbles=n.bytesToNibbles=n.nibblesToCompactBytes=n.nibblesToBytes=n.hasTerminator=void 0;n.hasTerminator=e=>e.length>0&&16===e[e.length-1];n.nibblesToBytes=(e,t)=>{for(let n=0,r=0;r<e.length;n+=1,r+=2)t[n]=e[r]<<4|e[r+1]};n.nibblesToCompactBytes=e=>{let t=0;(0,n.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,n.nibblesToBytes)(e,r.subarray(1)),r};n.bytesToNibbles=e=>{const t=2*e.length+1,n=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];n[2*t]=r/16,n[2*t+1]=r%16}return n[t-1]=16,n};n.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,n.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],[1776,{"../../../../../../is-buffer/index.js":4189,"./internal":1778},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.assertIsString=n.assertIsArray=n.assertIsBuffer=n.assertIsHexString=void 0;const r=e("./internal");n.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};n.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};n.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};n.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],[1777,{"./account":1770,"./address":1771,"./asyncEventEmitter":1772,"./bytes":1773,"./constants":1774,"./encoding":1775,"./internal":1778,"./lock":1779,"./provider":1780,"./signature":1781,"./types":1782,"./units":1783,"./withdrawal":1784},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.toAscii=n.stripHexPrefix=n.padToEven=n.isHexString=n.isHexPrefixed=n.getKeys=n.getBinarySize=n.fromUtf8=n.fromAscii=n.arrayContainsArray=void 0,s(e("./constants"),n),s(e("./units"),n),s(e("./account"),n),s(e("./address"),n),s(e("./withdrawal"),n),s(e("./signature"),n),s(e("./bytes"),n),s(e("./types"),n),s(e("./encoding"),n),s(e("./asyncEventEmitter"),n);var i=e("./internal");Object.defineProperty(n,"arrayContainsArray",{enumerable:!0,get:function(){return i.arrayContainsArray}}),Object.defineProperty(n,"fromAscii",{enumerable:!0,get:function(){return i.fromAscii}}),Object.defineProperty(n,"fromUtf8",{enumerable:!0,get:function(){return i.fromUtf8}}),Object.defineProperty(n,"getBinarySize",{enumerable:!0,get:function(){return i.getBinarySize}}),Object.defineProperty(n,"getKeys",{enumerable:!0,get:function(){return i.getKeys}}),Object.defineProperty(n,"isHexPrefixed",{enumerable:!0,get:function(){return i.isHexPrefixed}}),Object.defineProperty(n,"isHexString",{enumerable:!0,get:function(){return i.isHexString}}),Object.defineProperty(n,"padToEven",{enumerable:!0,get:function(){return i.padToEven}}),Object.defineProperty(n,"stripHexPrefix",{enumerable:!0,get:function(){return i.stripHexPrefix}}),Object.defineProperty(n,"toAscii",{enumerable:!0,get:function(){return i.toAscii}}),s(e("./lock"),n),s(e("./provider"),n)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],[1778,{buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(n,"__esModule",{value:!0}),n.isHexString=n.getKeys=n.fromAscii=n.fromUtf8=n.toAscii=n.arrayContainsArray=n.getBinarySize=n.padToEven=n.stripHexPrefix=n.isHexPrefixed=void 0,n.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}n.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},n.padToEven=r,n.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},n.arrayContainsArray=function(e,t,n){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===n?"some":"every"](t=>e.indexOf(t)>=0)},n.toAscii=function(e){let t="",n=0;const r=e.length;for("0x"===e.substring(0,2)&&(n=2);n<r;n+=2){const r=parseInt(e.substr(n,2),16);t+=String.fromCharCode(r)}return t},n.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},n.fromAscii=function(e){let t="";for(let n=0;n<e.length;n++){const r=e.charCodeAt(n).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},n.getKeys=function(e,t,n){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let s=0;s<e.length;s++){let i=e[s][t];if(!0!==n||i){if("string"!=typeof i)throw new Error("invalid abi - expected type 'string', received "+typeof i)}else i="";r.push(i)}return r},n.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],[1779,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Lock=void 0;n.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise(e=>this.promiseResolverQueue.push(e))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],[1780,{"micro-ftch":4446},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getProvider=n.fetchFromProvider=void 0;const r=e("micro-ftch");n.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;n.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],[1781,{"./bytes":1773,"./constants":1774,"./helpers":1776,buffer:3614,"ethereum-cryptography/keccak":3842,"ethereum-cryptography/secp256k1":3863},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.hashPersonalMessage=n.isValidSignature=n.fromRpcSig=n.toCompactSig=n.toRpcSig=n.ecrecover=n.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),i=e("./bytes"),a=e("./constants"),o=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function u(e){return e===BigInt(0)||e===BigInt(1)}n.ecsign=function(e,n,r){const i=s.secp256k1.sign(e,n),a=i.toCompactRawBytes();return{r:t.from(a.slice(0,32)),s:t.from(a.slice(32,64)),v:r===undefined?BigInt(i.recovery+27):BigInt(i.recovery+35)+BigInt(r)*BigInt(2)}};n.ecrecover=function(e,n,r,a,o){const l=t.concat([(0,i.setLengthLeft)(r,32),(0,i.setLengthLeft)(a,32)],64),d=c(n,o);if(!u(d))throw new Error("Invalid signature v value");const m=s.secp256k1.Signature.fromCompact(l).addRecoveryBit(Number(d)).recoverPublicKey(e);return t.from(m.toRawBytes(!1).slice(1))};n.toRpcSig=function(e,n,r,s){if(!u(c(e,s)))throw new Error("Invalid signature v value");return(0,i.bufferToHex)(t.concat([(0,i.setLengthLeft)(n,32),(0,i.setLengthLeft)(r,32),(0,i.toBuffer)(e)]))};n.toCompactSig=function(e,n,r,s){if(!u(c(e,s)))throw new Error("Invalid signature v value");let a=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(a=t.from(r),a[0]|=128),(0,i.bufferToHex)(t.concat([(0,i.setLengthLeft)(n,32),(0,i.setLengthLeft)(a,32)]))};n.fromRpcSig=function(e){const t=(0,i.toBuffer)(e);let n,r,s;if(t.length>=65)n=t.slice(0,32),r=t.slice(32,64),s=(0,i.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");n=t.slice(0,32),r=t.slice(32,64),s=BigInt((0,i.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:n,s:r}};n.isValidSignature=function(e,t,n,r=!0,s){if(32!==t.length||32!==n.length)return!1;if(!u(c(e,s)))return!1;const o=(0,i.bufferToBigInt)(t),l=(0,i.bufferToBigInt)(n);return!(o===BigInt(0)||o>=a.SECP256K1_ORDER||l===BigInt(0)||l>=a.SECP256K1_ORDER)&&!(r&&l>=a.SECP256K1_ORDER_DIV_2)};n.hashPersonalMessage=function(e){(0,o.assertIsBuffer)(e);const n=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([n,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],[1782,{"./bytes":1773,"./internal":1778},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toType=n.TypeOutput=void 0;const r=e("./bytes"),s=e("./internal");var i;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(i=n.TypeOutput||(n.TypeOutput={})),n.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const n=(0,r.toBuffer)(e);switch(t){case i.Buffer:return n;case i.BigInt:return(0,r.bufferToBigInt)(n);case i.Number:{const e=(0,r.bufferToBigInt)(n);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case i.PrefixedHexString:return(0,r.bufferToHex)(n);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],[1783,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.GWEI_TO_WEI=void 0,n.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],[1784,{"./address":1771,"./bytes":1773,"./types":1782,buffer:3614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){Object.defineProperty(n,"__esModule",{value:!0}),n.Withdrawal=void 0;const r=e("./address"),s=e("./bytes"),i=e("./types");class a{constructor(e,t,n,r){this.index=e,this.validatorIndex=t,this.address=n,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:n,address:s,amount:o}=e,c=(0,i.toType)(t,i.TypeOutput.BigInt),u=(0,i.toType)(n,i.TypeOutput.BigInt),l=new r.Address((0,i.toType)(s,i.TypeOutput.Buffer)),d=(0,i.toType)(o,i.TypeOutput.BigInt);return new a(c,u,l,d)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,n,r,s]=e;return a.fromWithdrawalData({index:t,validatorIndex:n,address:r,amount:s})}static toBufferArray(e){const{index:n,validatorIndex:s,address:a,amount:o}=e,c=(0,i.toType)(n,i.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,i.toType)(n,i.TypeOutput.Buffer),u=(0,i.toType)(s,i.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,i.toType)(s,i.TypeOutput.Buffer);let l;l=a instanceof r.Address?a.buf:(0,i.toType)(a,i.TypeOutput.Buffer);return[c,u,l,(0,i.toType)(o,i.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,i.toType)(o,i.TypeOutput.Buffer)]}raw(){return a.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}n.Withdrawal=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],[1785,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function s(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function i(...e){const t=e=>e,n=(e,t)=>n=>e(t(n));return{encode:e.map(e=>e.encode).reduceRight(n,t),decode:e.map(e=>e.decode).reduce(n,t)}}function a(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map(t=>{if(r(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]})},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map(t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const n=e.indexOf(t);if(-1===n)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return n})}}}function o(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(r(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(n){if(!Array.isArray(n)||n.length&&"string"!=typeof n[0])throw new Error("padding.encode input should be array of strings");for(let e of n)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;n.length*e%8;)n.push(t);return n},decode(n){if(!Array.isArray(n)||n.length&&"string"!=typeof n[0])throw new Error("padding.encode input should be array of strings");for(let e of n)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let r=n.length;if(r*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;r>0&&n[r-1]===t;r--)if(!((r-1)*e%8))throw new Error("Invalid padding: string has too much padding");return n.slice(0,r)}}}function u(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function l(e,t,n){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(n<2)throw new Error(`convertRadix: wrong to=${n}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let s=0;const i=[],a=Array.from(e);for(a.forEach(e=>{if(r(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)});;){let e=0,r=!0;for(let i=s;i<a.length;i++){const o=a[i],c=t*e+o;if(!Number.isSafeInteger(c)||t*e/t!==e||c-o!==t*e)throw new Error("convertRadix: carry overflow");e=c%n;const u=Math.floor(c/n);if(a[i]=u,!Number.isSafeInteger(u)||u*n+e!==c)throw new Error("convertRadix: carry overflow");r&&(u?r=!1:s=i)}if(i.push(e),r)break}for(let t=0;t<e.length-1&&0===e[t];t++)i.push(0);return i.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(n,"__esModule",{value:!0}),n.bytes=n.stringToBytes=n.str=n.bytesToString=n.hex=n.utf8=n.bech32m=n.bech32=n.base58check=n.createBase58check=n.base58xmr=n.base58xrp=n.base58flickr=n.base58=n.base64urlnopad=n.base64url=n.base64nopad=n.base64=n.base32crockford=n.base32hexnopad=n.base32hex=n.base32nopad=n.base32=n.base16=n.utils=void 0,n.assertNumber=r;const d=(e,t)=>t?d(t,e%t):e,m=(e,t)=>e+(t-d(e,t));function h(e,t,n,s){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(n<=0||n>32)throw new Error(`convertRadix2: wrong to=${n}`);if(m(t,n)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${n} carryBits=${m(t,n)}`);let i=0,a=0;const o=2**n-1,c=[];for(const s of e){if(r(s),s>=2**t)throw new Error(`convertRadix2: invalid data word=${s} from=${t}`);if(i=i<<t|s,a+t>32)throw new Error(`convertRadix2: carry overflow pos=${a} from=${t}`);for(a+=t;a>=n;a-=n)c.push((i>>a-n&o)>>>0);i&=2**a-1}if(i=i<<n-a&o,!s&&a>=t)throw new Error("Excess padding");if(!s&&i)throw new Error(`Non-zero padding: ${i}`);return s&&a>0&&c.push(i>>>0),c}function f(e){return r(e),{encode:t=>{if(!s(t))throw new Error("radix.encode input should be Uint8Array");return l(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(l(t,e,256))}}}function p(e,t=!1){if(r(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(m(8,e)>32||m(e,8)>32)throw new Error("radix2: carry overflow");return{encode:n=>{if(!s(n))throw new Error("radix2.encode input should be Uint8Array");return h(Array.from(n),8,e,!t)},decode:n=>{if(!Array.isArray(n)||n.length&&"number"!=typeof n[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(h(n,e,8,t))}}}function y(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function g(e,t){if(r(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(n){if(!s(n))throw new Error("checksum.encode: input should be Uint8Array");const r=t(n).slice(0,e),i=new Uint8Array(n.length+e);return i.set(n),i.set(r,n.length),i},decode(n){if(!s(n))throw new Error("checksum.decode: input should be Uint8Array");const r=n.slice(0,-e),i=t(r).slice(0,e),a=n.slice(-e);for(let t=0;t<e;t++)if(i[t]!==a[t])throw new Error("Invalid checksum");return r}}}n.utils={alphabet:a,chain:i,checksum:g,convertRadix:l,convertRadix2:h,radix:f,radix2:p,join:o,padding:c},n.base16=i(p(4),a("0123456789ABCDEF"),o("")),n.base32=i(p(5),a("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),o("")),n.base32nopad=i(p(5),a("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),o("")),n.base32hex=i(p(5),a("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),o("")),n.base32hexnopad=i(p(5),a("0123456789ABCDEFGHIJKLMNOPQRSTUV"),o("")),n.base32crockford=i(p(5),a("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),o(""),u(e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1"))),n.base64=i(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),o("")),n.base64nopad=i(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),o("")),n.base64url=i(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),o("")),n.base64urlnopad=i(p(6),a("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),o(""));const b=e=>i(f(58),a(e),o(""));n.base58=b("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),n.base58flickr=b("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),n.base58xrp=b("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const v=[0,2,3,5,6,7,9,10,11];n.base58xmr={encode(e){let t="";for(let r=0;r<e.length;r+=8){const s=e.subarray(r,r+8);t+=n.base58.encode(s).padStart(v[s.length],"1")}return t},decode(e){let t=[];for(let r=0;r<e.length;r+=11){const s=e.slice(r,r+11),i=v.indexOf(s.length),a=n.base58.decode(s);for(let e=0;e<a.length-i;e++)if(0!==a[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(a.slice(a.length-i)))}return Uint8Array.from(t)}};n.createBase58check=e=>i(g(4,t=>e(e(t))),n.base58),n.base58check=n.createBase58check;const k=i(a("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),o("")),E=[996825010,642813549,513874426,1027748829,705979059];function w(e){const t=e>>25;let n=(33554431&e)<<5;for(let e=0;e<E.length;e++)1==(t>>e&1)&&(n^=E[e]);return n}function T(e,t,n=1){const r=e.length;let s=1;for(let t=0;t<r;t++){const n=e.charCodeAt(t);if(n<33||n>126)throw new Error(`Invalid prefix (${e})`);s=w(s)^n>>5}s=w(s);for(let t=0;t<r;t++)s=w(s)^31&e.charCodeAt(t);for(let e of t)s=w(s)^e;for(let e=0;e<6;e++)s=w(s);return s^=n,k.encode(h([s%2**30],30,5,!1))}function A(e){const t="bech32"===e?1:734539939,n=p(5),r=n.decode,s=n.encode,i=y(r);function a(e,n,r=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(n instanceof Uint8Array&&(n=Array.from(n)),!Array.isArray(n)||n.length&&"number"!=typeof n[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof n);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const s=e.length+7+n.length;if(!1!==r&&s>r)throw new TypeError(`Length ${s} exceeds limit ${r}`);const i=e.toLowerCase(),a=T(i,n,t);return`${i}1${k.encode(n)}${a}`}function o(e,n=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==n&&e.length>n)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${n})`);const r=e.toLowerCase();if(e!==r&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const s=r.lastIndexOf("1");if(0===s||-1===s)throw new Error('Letter "1" must be present between prefix and data only');const i=r.slice(0,s),a=r.slice(s+1);if(a.length<6)throw new Error("Data must be at least 6 characters long");const o=k.decode(a).slice(0,-6),c=T(i,o,t);if(!a.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:i,words:o}}return{encode:a,decode:o,encodeFromBytes:function(e,t){return a(e,s(t))},decodeToBytes:function(e){const{prefix:t,words:n}=o(e,!1);return{prefix:t,words:n,bytes:r(n)}},decodeUnsafe:y(o),fromWords:r,fromWordsUnsafe:i,toWords:s}}n.bech32=A("bech32"),n.bech32m=A("bech32m"),n.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},n.hex=i(p(4),a("0123456789abcdef"),o(""),u(e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()}));const C={utf8:n.utf8,hex:n.hex,base16:n.base16,base32:n.base32,base64:n.base64,base64url:n.base64url,base58:n.base58,base58xmr:n.base58xmr},_="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";n.bytesToString=(e,t)=>{if("string"!=typeof e||!C.hasOwnProperty(e))throw new TypeError(_);if(!s(t))throw new TypeError("bytesToString() expects Uint8Array");return C[e].encode(t)},n.str=n.bytesToString;n.stringToBytes=(e,t)=>{if(!C.hasOwnProperty(e))throw new TypeError(_);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return C[e].decode(t)},n.bytes=n.stringToBytes}}},{package:"@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js"}],[1786,{"./simple-keyring.cjs":1787},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var s=e("./simple-keyring.cjs");Object.defineProperty(n,"default",{enumerable:!0,get:function(){return r(s).default}})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/index.cjs"}],[1787,{"@ethereumjs/util":551,"@metamask/eth-sig-util":1764,"@metamask/utils":2656,buffer:3614,"ethereum-cryptography/keccak":3842,randombytes:4700},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(t){(function(){var r,s,i,a,o=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},c=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},u=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0});const l=e("@ethereumjs/util"),d=e("@metamask/eth-sig-util"),m=e("@metamask/utils"),h=e("ethereum-cryptography/keccak"),f=u(e("randombytes")),p="Simple Key Pair";class y{constructor(e=[]){r.add(this),s.set(this,void 0),this.type=p,o(this,s,[],"f"),this.deserialize(e).catch(e=>{throw new Error(`Problem deserializing SimpleKeyring ${e.message}`)})}async serialize(){return c(this,s,"f").map(e=>e.privateKey.toString("hex"))}async deserialize(e){o(this,s,e.map(e=>{const n=(0,l.stripHexPrefix)(e),r=t.from(n,"hex");return{privateKey:r,publicKey:t.from((0,l.privateToPublic)(r))}}),"f")}async addAccounts(e=1){const n=[];for(let r=0;r<e;r++){const e=g(),r=t.from((0,l.privateToPublic)(e));n.push({privateKey:e,publicKey:r})}o(this,s,c(this,s,"f").concat(n),"f");return n.map(({publicKey:e})=>(0,m.add0x)((0,m.bytesToHex)((0,l.publicToAddress)(e))))}async getAccounts(){return c(this,s,"f").map(({publicKey:e})=>(0,m.add0x)((0,m.bytesToHex)((0,l.publicToAddress)(e))))}async signTransaction(e,t,n={}){const s=c(this,r,"m",i).call(this,e,n);return t.sign(s)??t}async signEip7702Authorization(e,t,n={}){const s=c(this,r,"m",i).call(this,e,n);return(0,d.signEIP7702Authorization)({privateKey:s,authorization:t})}async signMessage(e,n,s={withAppKeyOrigin:"",validateMessage:!0}){const a=(0,l.stripHexPrefix)(n);if(s.validateMessage&&(0===a.length||!a.match(/^[a-fA-F0-9]*$/u)))throw new Error("Cannot sign invalid message");const o=c(this,r,"m",i).call(this,e,s),u=(0,l.ecsign)(t.from(a,"hex"),o);return(0,d.concatSig)(t.from((0,m.bigIntToBytes)(u.v)),t.from(u.r),t.from(u.s))}async signPersonalMessage(e,t,n={withAppKeyOrigin:""}){const s=c(this,r,"m",i).call(this,e,n);return(0,d.personalSign)({privateKey:s,data:t})}async decryptMessage(e,t){const n=c(this,r,"m",a).call(this,e).privateKey.toString("hex");return(0,d.decrypt)({privateKey:n,encryptedData:t})}async signTypedData(e,t,n={version:d.SignTypedDataVersion.V1}){let s=d.SignTypedDataVersion.V1;n.version&&function(e){return e in d.SignTypedDataVersion}(n.version)&&(s=d.SignTypedDataVersion[n.version]);const a=c(this,r,"m",i).call(this,e,n);return(0,d.signTypedData)({privateKey:a,data:t,version:s})}async getEncryptionPublicKey(e,t){const n=c(this,r,"m",i).call(this,e,t);return(0,d.getEncryptionPublicKey)(n.toString("hex"))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const n=c(this,r,"m",a).call(this,e,{withAppKeyOrigin:t});return(0,m.add0x)((0,m.bytesToHex)((0,l.publicToAddress)(n.publicKey)))}async exportAccount(e,t={withAppKeyOrigin:""}){return c(this,r,"m",a).call(this,e,t).privateKey.toString("hex")}removeAccount(e){if(!c(this,s,"f").map(({publicKey:e})=>(0,m.bytesToHex)((0,l.publicToAddress)(e)).toLowerCase()).includes(e.toLowerCase()))throw new Error(`Address ${e} not found in this keyring`);o(this,s,c(this,s,"f").filter(({publicKey:t})=>(0,m.bytesToHex)((0,l.publicToAddress)(t)).toLowerCase()!==e.toLowerCase()),"f")}}function g(){const e=(0,f.default)(32);if(!(0,l.isValidPrivate)(e))throw new Error("Private key does not satisfy the curve requirements (ie. it is invalid)");return e}s=new WeakMap,r=new WeakSet,i=function(e,t={withAppKeyOrigin:""}){if(!e)throw new Error("Must specify address.");return c(this,r,"m",a).call(this,e,t).privateKey},a=function(e,n={}){const r=(0,d.normalize)(e);let i=c(this,s,"f").find(({publicKey:e})=>(0,m.bytesToHex)((0,l.publicToAddress)(e))===r);if(!i)throw new Error("Simple Keyring - Unable to find matching address.");if(n.withAppKeyOrigin){const{privateKey:e}=i,r=t.from(n.withAppKeyOrigin,"utf8"),s=t.concat([e,r]),a=(0,h.keccak256)(s),o=(0,l.privateToPublic)(a);i={privateKey:t.from(a),publicKey:t.from(o)}}return i},y.type=p,n.default=y}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"}],[183,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isSecurityAlertsAPIEnabled=function(){const e="true";return"true"===e.toString()},n.validateWithSecurityAlertsAPI=async function(e,t,n){let s=function(e){const t="https://security-alerts.api.cx.metamask.io";if(!t)throw new Error("Security alerts API URL is not set");return`${t}/${e}`}(`${r}/${e}`);const{newUrl:i,authorization:a}=await(null==n?void 0:n(s))||{};i&&(s=i);const o={"Content-Type":"application/json"};a&&(o.Authorization=a);return async function(e,t){const n=await fetch(e,t);if(!n.ok)throw new Error(`Security alerts API request failed with status: ${n.status}`);return await n.json()}(s,{method:"POST",body:JSON.stringify(t),headers:o})};const r="validate"}}},{package:"$root$",file:"app/scripts/lib/ppom/security-alerts-api.ts"}],[1830,{"./helpers":1832,"./prefix-for-chain":1834,"./prefix-for-network":1835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getAccountLink=n.createCustomAccountLink=n.createAccountLinkForChain=n.createAccountLink=void 0;const s=e("./helpers"),i=r(e("./prefix-for-chain")),a=r(e("./prefix-for-network"));function o(e,t){const n=a.default(t);return null===n?"":`https://${n}etherscan.io/address/${e}`}function c(e,t){const n=i.default(t);return null===n?"":`https://${n}etherscan.io/address/${e}`}function u(e,t){return s.addPathToUrl(t,"address",e)}n.createAccountLink=o,n.createAccountLinkForChain=c,n.createCustomAccountLink=u,n.getAccountLink=function(e,t,n={},r=""){return n.blockExplorerUrl?u(e,n.blockExplorerUrl):r?o(e,r):c(e,t)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/account-link.js"}],[1831,{"./helpers":1832,"./prefix-for-chain":1834,"./prefix-for-network":1835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getBlockExplorerLink=n.createExplorerLinkForChain=n.createExplorerLink=n.createCustomExplorerLink=void 0;const s=e("./helpers"),i=r(e("./prefix-for-chain")),a=r(e("./prefix-for-network"));function o(e,t){return s.addPathToUrl(t,"tx",e)}function c(e,t){const n=a.default(t);return null===n?"":`https://${n}etherscan.io/tx/${e}`}function u(e,t){const n=i.default(t);return null===n?"":`https://${n}etherscan.io/tx/${e}`}n.createCustomExplorerLink=o,n.createExplorerLink=c,n.createExplorerLinkForChain=u,n.getBlockExplorerLink=function(e,t={}){return t.blockExplorerUrl?o(e.hash,t.blockExplorerUrl):e.chainId?u(e.hash,e.chainId):c(e.hash,e.metamaskNetworkId)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/explorer-link.js"}],[1832,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.addPathToUrl=void 0,n.addPathToUrl=(e,t,n)=>{const{username:r,password:s,protocol:i,host:a,pathname:o,search:c,hash:u}=new URL(e),l=o.endsWith("/")?`${o}${t}/${n}`:`${o}/${t}/${n}`;return new URL(`${i}//${r?`${r}:${s}`:""}${a}${l}${c}${u}`).toString()}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/helpers.js"}],[1833,{"./account-link":1830,"./explorer-link":1831,"./token-tracker-link":1836},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){const r=e("./account-link"),s=e("./explorer-link"),i=e("./token-tracker-link");t.exports={createExplorerLink:s.createExplorerLink,createCustomExplorerLink:s.createCustomExplorerLink,createExplorerLinkForChain:s.createExplorerLinkForChain,createAccountLink:r.createAccountLink,createCustomAccountLink:r.createCustomAccountLink,createAccountLinkForChain:r.createAccountLinkForChain,createTokenTrackerLink:i.createTokenTrackerLink,createCustomTokenTrackerLink:i.createCustomTokenTrackerLink,createTokenTrackerLinkForChain:i.createTokenTrackerLinkForChain,getBlockExplorerLink:s.getBlockExplorerLink,getAccountLink:r.getAccountLink,getTokenTrackerLink:i.getTokenTrackerLink}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/index.js"}],[1834,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){let t;switch(e){case"0x1":t="";break;case"0x5":t="goerli.";break;case"0xaa36a7":t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js"}],[1835,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e){let t;switch(parseInt(e)){case 1:t="";break;case 5:t="goerli.";break;case 11155111:t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"}],[1836,{"./helpers":1832,"./prefix-for-chain":1834,"./prefix-for-network":1835},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.getTokenTrackerLink=n.createTokenTrackerLinkForChain=n.createCustomTokenTrackerLink=n.createTokenTrackerLink=void 0;const s=e("./helpers"),i=r(e("./prefix-for-chain")),a=r(e("./prefix-for-network"));function o(e,t,n){const r=a.default(t);return null===r?"":`https://${r}etherscan.io/token/${e}${n?`?a=${n}`:""}`}function c(e,t){return s.addPathToUrl(t,"token",e)}function u(e,t,n){const r=i.default(t);return null===r?"":`https://${r}etherscan.io/token/${e}${n?`?a=${n}`:""}`}n.createTokenTrackerLink=o,n.createCustomTokenTrackerLink=c,n.createTokenTrackerLinkForChain=u,n.getTokenTrackerLink=function(e,t,n,r,s={}){return s.blockExplorerUrl?c(e,s.blockExplorerUrl):n?o(e,n,r):u(e,t,r)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/token-tracker-link.js"}],[1837,{"./has-tx-object":1838,"@babel/runtime/helpers/asyncToGenerator":471,"@babel/runtime/helpers/interopRequireDefault":479,"@babel/runtime/regenerator":497,"@metamask/ethjs-filter":1840,"@metamask/ethjs-util":1845,"ethjs-abi":3923,"js-sha3":4215,"promise-to-callback":4625},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("@babel/runtime/helpers/interopRequireDefault"),s=r(e("@babel/runtime/regenerator")),i=r(e("@babel/runtime/helpers/asyncToGenerator")),a=e("ethjs-abi"),o=e("@metamask/ethjs-filter"),c=e("@metamask/ethjs-util").getKeys,u=e("js-sha3").keccak_256,l=e("promise-to-callback"),d=e("./has-tx-object");t.exports=function(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{},t=this;function n(e){return function(){var t,n=[].slice.call(arguments);"function"==typeof n[n.length-1]&&(t=n.pop());var s=function(e){return r.apply(this,arguments)}({methodObject:e,methodArgs:n});return t?l(s)(t):s}}function r(){return(r=(0,i.default)(s.default.mark(function e(n){var r,i,o,c,u,l,m;return s.default.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return r=n.methodObject,i=n.methodArgs,o="call",c={},d(i)&&(c=i.pop()),(u=Object.assign({},t.defaultTxObject,c,{to:t.address})).data=a.encodeMethod(r,i),!1===r.constant&&(o="sendTransaction"),e.next=9,t.query[o](u);case 9:if(l=e.sent,"call"!==o){e.next=20;break}return e.prev=11,m=a.decodeMethod(r,l),e.abrupt("return",m);case 16:throw e.prev=16,e.t0=e.catch(11),new Error("[ethjs-contract] while formatting incoming raw call data "+JSON.stringify(l)+" "+e.t0);case 20:return e.abrupt("return",l);case 21:case"end":return e.stop()}},e,null,[[11,16]])}))).apply(this,arguments)}t.abi=e.contractABI||[],t.query=e.query,t.address=e.address||"0x",t.bytecode=e.contractBytecode||"0x",t.defaultTxObject=e.contractDefaultTxObject||{},t.filters=new o(t.query),(m=t.abi,m.filter(function(e){return("function"===e.type||"event"===e.type)&&e.name.length>0})).forEach(function(e){"function"===e.type?t[e.name]=n(e):"event"===e.type&&(t[e.name]=function(e){return function(){var n=[].slice.call(arguments),r=c(e.inputs,"type",!1),s=["0x"+u(e.name+"("+r.join(",")+")")],i=Object.assign({},n[0])||{},o=Object.assign({},n[0]||{},{to:t.address,topics:s}),l=Object.assign({},i,{decoder:function(t){return a.decodeEvent(e,t,s)},defaultFilterObject:o});return new t.filters.Filter(l)}}(e))});var m}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/contract.js"}],[1838,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=["from","to","data","value","gasPrice","gas"];t.exports=function(e){if(!Array.isArray(e)||0===e.length)return!1;var t=e[e.length-1];if(!t)return!1;if("object"!=typeof t)return!1;if(0===Object.keys(t).length)return!0;var n=Object.keys(t);if(r.some(function(e){return n.includes(e)}))return!0;return!1}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/has-tx-object.js"}],[1839,{"./contract":1837,"./has-tx-object":1838,"@metamask/ethjs-filter":1840,"@metamask/ethjs-util":1845,"ethjs-abi":3923,"js-sha3":4215},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("ethjs-abi"),s=(e("js-sha3").keccak_256,e("@metamask/ethjs-filter"),e("@metamask/ethjs-util").getKeys),i=e("./contract"),a=e("./has-tx-object");t.exports=function(e){return function(t,n,o){if(!Array.isArray(t))throw new Error("[ethjs-contract] Contract ABI must be type Array, got type "+typeof t);if(void 0!==n&&"string"!=typeof n)throw new Error("[ethjs-contract] Contract bytecode must be type String, got type "+typeof n);if(void 0!==o&&"object"!=typeof o)throw new Error("[ethjs-contract] Contract default tx object must be type Object, got type "+typeof t);var c={at:function(r){return new i({address:r,query:e,contractBytecode:n,contractDefaultTxObject:o,contractABI:t})},new:function(){var i={},c=null,u=[].slice.call(arguments);"function"==typeof u[u.length-1]&&(c=u.pop()),a(u)&&(i=u.pop());var l=function(e){return e.filter(function(e){return"constructor"===e.type})[0]}(t),d=Object.assign({},o,i);if(n&&(d.data=n),l){var m=r.encodeParams(s(l.inputs,"type"),u).substring(2);d.data=""+d.data+m}return c?e.sendTransaction(d,c):e.sendTransaction(d)}};return c}}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/index.js"}],[1840,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t){function n(e){var n=this;n.filterId=null,n.options=Object.assign({delay:300,decoder:function(e){return e},defaultFilterObject:{}},e||{}),n.watchers={},n.interval=setInterval(function(){null!==n.filterId&&Object.keys(n.watchers).length>0&&t.getFilterChanges(n.filterId,function(e,t){var r=[],s=null;if(!e)try{t.forEach(function(e,s){r[s]=t[s],"object"==typeof t[s]&&(r[s].data=n.options.decoder(r[s].data))})}catch(e){s=new Error("[ethjs-filter] while decoding filter change event data from RPC '"+JSON.stringify(r)+"': "+e)}Object.keys(n.watchers).forEach(function(i){var a=n.watchers[i];!0!==a.stop?s?a.callback(s,null):e?a.callback(e,null):Array.isArray(r)&&t.length>0&&a.callback(e,r):delete n.watchers[i]})})},n.options.delay)}return n.prototype.at=function(e){this.filterId=e},n.prototype.watch=function(e){var t=e||function(){},n=this,r=Math.random().toString(36).substring(7);return n.watchers[r]={callback:t,stop:!1,stopWatching:function(){n.watchers[r].stop=!0}},n.watchers[r]},n.prototype.uninstall=function(e){var n=this,r=e||null;n.watchers=Object.assign({}),clearInterval(n.interval);var s=new Promise(function(e,r){t.uninstallFilter(n.filterId,function(t,n){t?r(t):e(n)})});return r&&s.then(function(e){return r(null,e)}).catch(function(e){return r(e,null)}),r?null:s},n.prototype.new=function(){var n=null,r=this,s=[],i=[].slice.call(arguments);"function"==typeof i[i.length-1]&&(n=i.pop()),"Filter"===e&&s.push(Object.assign(r.options.defaultFilterObject,i[i.length-1]||{}));var a=new Promise(function(n,i){s.push(function(e,t){e?i(e):(r.filterId=t,n(t))}),t["new"+e].apply(t,s)});return n&&a.then(function(e){return n(null,e)}).catch(function(e){return n(e,null)}),n?null:a},n}t.exports=function e(t){var n=this;if(!(n instanceof e))throw new Error("the EthFilter object must be instantiated with `new` flag.. (e.g. `const filters = new EthFilter(query);`)");if("object"!=typeof t)throw new Error("the EthFilter object must be instantiated with an EthQuery instance (e.g. `const filters = new EthFilter(new EthQuery(provider));`). See github.com/ethjs/ethjs-query for more details..");n.Filter=r("Filter",t),n.BlockFilter=r("BlockFilter",t),n.PendingTransactionFilter=r("PendingTransactionFilter",t)}}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-filter",file:"node_modules/@metamask/ethjs-filter/lib/index.js"}],[1841,{"@metamask/ethjs-util":1845,"@metamask/number-to-bn":2103,"ethjs-schema":3925,"strip-hex-prefix":5155},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("@metamask/number-to-bn"),s=e("ethjs-schema"),i=e("@metamask/ethjs-util"),a=i.arrayContainsArray,o=i.getBinarySize,c=i.padToEven,u=e("strip-hex-prefix");function l(e,t,n){if(-1===["string","number","object"].indexOf(typeof e)||null===e)return e;var s=r(e),i=n&&s.toString(16).length%2?"0":"";if(r(e).isNeg())throw new Error("[ethjs-format] while formatting quantity '"+s.toString(10)+"', invalid negative number. Number must be positive or zero.");return t?"0x"+i+s.toString(16):s}function d(e,t){var n=e;return-1===s.tags.indexOf(e)&&(n=l(e,t)),n}function m(e,t){var n=e,r=0;if("string"==typeof e&&(n="0x"+c(u(e)),r=o(n)),"0x00"===n&&(n="0x0"),"number"==typeof t&&null!==e&&"0x"!==n&&"0x0"!==n&&(!/^[0-9A-Fa-f]+$/.test(u(n))||r!==2+2*t))throw new Error("[ethjs-format] hex string '"+n+"' must be an alphanumeric "+(2+2*t)+" utf8 byte hex (chars: a-fA-F) string, is "+r+" bytes");return n}function h(e,t,n){var r=Object.assign({},t),i=null;if("string"==typeof e&&(i="Boolean|EthSyncing"===e?Object.assign({},s.objects.EthSyncing):"DATA|Transaction"===e?Object.assign({},s.objects.Transaction):Object.assign({},s.objects[e])),!a(Object.keys(t),i.__required))throw new Error("[ethjs-format] object "+JSON.stringify(t)+" must contain properties: "+i.__required.join(", "));return Object.keys(i).forEach(function(e){"__required"!==e&&void 0!==t[e]&&(r[e]=p(i[e],t[e],n))}),r}function f(e,t,n,r){var s=t.slice(),i=e;if("Array|DATA"===e&&(i=["D"]),"FilterChange"===e&&"string"==typeof t[0]&&(i=["D32"]),!0===n&&"number"==typeof r&&t.length<r)throw new Error("array "+JSON.stringify(t)+" must contain at least "+r+" params, but only contains "+t.length+".");return i=i.slice(),t.forEach(function(e,t){var r=0;i.length>1&&(r=t),s[t]=p(i[r],e,n)}),s}function p(e,t,n,r){var s=t;return"Q"===e?s=l(t,n):"QP"===e?s=l(t,n,!0):"Q|T"===e?s=d(t,n):"D"===e?s=m(t):"D20"===e?s=m(t,20):"D32"===e?s=m(t,32):"object"==typeof t&&null!==t&&!1===Array.isArray(t)?s=h(e,t,n):Array.isArray(t)&&(s=f(e,t,n,r)),s}t.exports={schema:s,formatQuantity:l,formatQuantityOrTag:d,formatObject:h,formatArray:f,format:p,formatInputs:function(e,t){return p(s.methods[e][0],t,!0,s.methods[e][2])},formatOutputs:function(e,t){return p(s.methods[e][1],t,!1)}}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-format",file:"node_modules/@metamask/ethjs-format/lib/index.js"}],[1842,{"@metamask/ethjs-format":1841,"@metamask/ethjs-rpc":1843,"promise-to-callback":4625},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("@metamask/ethjs-format"),s=e("@metamask/ethjs-rpc"),i=e("promise-to-callback");function a(e,t){var n=this,r=t||{};if(!(this instanceof a))throw new Error('[ethjs-query] the Eth object requires the "new" flag in order to function normally (i.e. `const eth = new Eth(provider);`).');if("object"!=typeof e)throw new Error("[ethjs-query] the Eth object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new Eth(provider);')");n.options=Object.assign({debug:r.debug||!1,logger:r.logger||console,jsonSpace:r.jsonSpace||0}),n.rpc=new s(e),n.setProvider=n.rpc.setProvider}function o(e,t){return function(){var n=null,s=null,a=this,o=[].slice.call(arguments),c=e.replace("eth_","");o.length>0&&"function"==typeof o[o.length-1]&&(n=o.pop());var u=function(){var n=this;return new Promise(function(i,u){if(o.length<t[2])u(new Error("[ethjs-query] method '"+c+"' requires at least "+t[2]+" input (format type "+t[0][0]+"), "+o.length+" provided. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else if(o.length>t[0].length)u(new Error("[ethjs-query] method '"+c+"' requires at most "+t[0].length+" params, "+o.length+" provided '"+JSON.stringify(o,null,a.options.jsonSpace)+"'. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else{t[3]&&o.length<t[3]&&o.push("latest"),n.log("attempting method formatting for '"+c+"' with inputs "+JSON.stringify(o,null,n.options.jsonSpace));try{s=r.formatInputs(e,o),n.log("method formatting success for '"+c+"' with formatted result: "+JSON.stringify(s,null,n.options.jsonSpace))}catch(e){return void u(new Error("[ethjs-query] while formatting inputs '"+JSON.stringify(o,null,n.options.jsonSpace)+"' for method '"+c+"' error: "+e))}n.rpc.sendAsync({method:e,params:s}).then(function(t){n.log("attempting method formatting for '"+c+"' with raw outputs: "+JSON.stringify(t,null,n.options.jsonSpace));var s=r.formatOutputs(e,t);n.log("method formatting success for '"+c+"' formatted result: "+JSON.stringify(s,null,n.options.jsonSpace)),i(s)}).catch(function(e){u(e)})}})}.call(this);return n?i(u)(n):u}}t.exports=a,a.prototype.log=function(e){this.options.debug&&this.options.logger.log("[ethjs-query log] "+e)},Object.keys(r.schema.methods).forEach(function(e){Object.defineProperty(a.prototype,e.replace("eth_",""),{enumerable:!0,value:o(e,r.schema.methods[e])})})}}},{package:"eth-method-registry>@metamask/ethjs-query",file:"node_modules/@metamask/ethjs-query/lib/index.js"}],[1843,{"promise-to-callback":4625},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("promise-to-callback");function s(e,t){var n=this,r=t||{};if(!(this instanceof s))throw new Error('[ethjs-rpc] the EthRPC object requires the "new" flag in order to function normally (i.e. `const eth = new EthRPC(provider);`).');n.options=Object.assign({jsonSpace:r.jsonSpace||0,max:r.max||9999999999999}),n.idCounter=Math.floor(Math.random()*n.options.max),n.setProvider=function(e){if("object"!=typeof e)throw new Error("[ethjs-rpc] the EthRPC object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new EthRPC(provider);')");n.currentProvider=e},n.setProvider(e)}t.exports=s,s.prototype.sendAsync=function(e,t){var n=this;n.idCounter=n.idCounter%n.options.max;var s,i,a=(s=e,i=n.idCounter++,Object.assign({},{id:i,jsonrpc:"2.0",params:[]},s)),o=new Promise(function(e,t){n.currentProvider.sendAsync(a,function(r,s){var i=s||{};if(r||i.error){var o="[ethjs-rpc] "+(i.error?"rpc":"")+" error with payload "+JSON.stringify(a,null,n.options.jsonSpace)+" "+(r?String(r):JSON.stringify(i.error,null,n.options.jsonSpace)),c=new Error(o);return c.value=r||i.error,void t(c)}e(i.result)})});return t?r(o)(t):o}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-rpc",file:"node_modules/@metamask/ethjs-rpc/lib/index.js"}],[1844,{"@metamask/number-to-bn":2103,"bn.js":3553},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("bn.js"),s=e("@metamask/number-to-bn"),i=new r(0),a=new r(-1),o={noether:"0",wei:"1",kwei:"1000",Kwei:"1000",babbage:"1000",femtoether:"1000",mwei:"1000000",Mwei:"1000000",lovelace:"1000000",picoether:"1000000",gwei:"1000000000",Gwei:"1000000000",shannon:"1000000000",nanoether:"1000000000",nano:"1000000000",szabo:"1000000000000",microether:"1000000000000",micro:"1000000000000",finney:"1000000000000000",milliether:"1000000000000000",milli:"1000000000000000",ether:"1000000000000000000",kether:"1000000000000000000000",grand:"1000000000000000000000",mether:"1000000000000000000000000",gether:"1000000000000000000000000000",tether:"1000000000000000000000000000000"};function c(e){var t=e?e.toLowerCase():"ether",n=o[t];if("string"!=typeof n)throw new Error("[ethjs-unit] the unit provided "+e+" doesn't exists, please use the one of the following units "+JSON.stringify(o,null,2));return new r(n,10)}function u(e){if("string"==typeof e){if(!e.match(/^-?[0-9.]+$/))throw new Error("while converting number to string, invalid number value '"+e+"', should be a number matching (^-?[0-9.]+).");return e}if("number"==typeof e)return String(e);if("object"==typeof e&&e.toString&&(e.toTwos||e.dividedToIntegerBy))return e.toPrecision?String(e.toPrecision()):e.toString(10);throw new Error("while converting number to string, invalid number value '"+e+"' type "+typeof e+".")}t.exports={unitMap:o,numberToString:u,getValueOfUnit:c,fromWei:function(e,t,n){var r=s(e),u=r.lt(i),l=c(t),d=o[t].length-1||1,m=n||{};u&&(r=r.mul(a));for(var h=r.mod(l).toString(10);h.length<d;)h="0"+h;m.pad||(h=h.match(/^([0-9]*[1-9]|0)(0*)/)[1]);var f=r.div(l).toString(10);m.commify&&(f=f.replace(/\B(?=(\d{3})+(?!\d))/g,","));var p=f+("0"==h?"":"."+h);return u&&(p="-"+p),p},toWei:function(e,t){var n=u(e),s=c(t),i=o[t].length-1||1,l="-"===n.substring(0,1);if(l&&(n=n.substring(1)),"."===n)throw new Error("[ethjs-unit] while converting number "+e+" to wei, invalid value");var d=n.split(".");if(d.length>2)throw new Error("[ethjs-unit] while converting number "+e+" to wei,  too many decimal points");var m=d[0],h=d[1];if(m||(m="0"),h||(h="0"),h.length>i)throw new Error("[ethjs-unit] while converting number "+e+" to wei, too many decimal places");for(;h.length<i;)h+="0";m=new r(m),h=new r(h);var f=m.mul(s).add(h);return l&&(f=f.mul(a)),new r(f.toString(10),10)}}}}},{package:"@metamask/controller-utils>@metamask/ethjs-unit",file:"node_modules/@metamask/ethjs-unit/lib/index.js"}],[1845,{buffer:3614,"is-hex-prefixed":4194,"strip-hex-prefix":5155},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){(function(n){(function(){var r=e("is-hex-prefixed"),s=e("strip-hex-prefix");function i(e){var t=e;if("string"!=typeof t)throw new Error("[ethjs-util] while padding to even, value must be string, is currently "+typeof t+", while padToEven.");return t.length%2&&(t="0"+t),t}function a(e){return"0x"+e.toString(16)}t.exports={arrayContainsArray:function(e,t,n){if(!0!==Array.isArray(e))throw new Error("[ethjs-util] method arrayContainsArray requires input 'superset' to be an array got type '"+typeof e+"'");if(!0!==Array.isArray(t))throw new Error("[ethjs-util] method arrayContainsArray requires input 'subset' to be an array got type '"+typeof t+"'");return t[Boolean(n)?"some":"every"](function(t){return e.indexOf(t)>=0})},intToBuffer:function(e){var t=a(e);return n.from(i(t.slice(2)),"hex")},getBinarySize:function(e){if("string"!=typeof e)throw new Error("[ethjs-util] while getting binary size, method getBinarySize requires input 'str' to be type String, got '"+typeof e+"'.");return n.byteLength(e,"utf8")},isHexPrefixed:r,stripHexPrefix:s,padToEven:i,intToHex:a,fromAscii:function(e){for(var t="",n=0;n<e.length;n++){var r=e.charCodeAt(n).toString(16);t+=r.length<2?"0"+r:r}return"0x"+t},fromUtf8:function(e){return"0x"+i(n.from(e,"utf8").toString("hex")).replace(/^0+|0+$/g,"")},toAscii:function(e){var t="",n=0,r=e.length;for("0x"===e.substring(0,2)&&(n=2);n<r;n+=2){var s=parseInt(e.substr(n,2),16);t+=String.fromCharCode(s)}return t},toUtf8:function(e){return n.from(i(s(e).replace(/^0+|0+$/g,"")),"hex").toString("utf8")},getKeys:function(e,t,n){if(!Array.isArray(e))throw new Error("[ethjs-util] method getKeys expecting type Array as 'params' input, got '"+typeof e+"'");if("string"!=typeof t)throw new Error("[ethjs-util] method getKeys expecting type String for input 'key' got '"+typeof t+"'.");for(var r=[],s=0;s<e.length;s++){var i=e[s][t];if(n&&!i)i="";else if("string"!=typeof i)throw new Error("invalid abi");r.push(i)}return r},isHexString:function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&(!t||e.length===2+2*t)}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-util",file:"node_modules/@metamask/ethjs-util/lib/index.js"}],[1846,{"./determineGasFeeCalculations.cjs":1847,"./gas-util.cjs":1848,"@metamask/controller-utils":1229,"@metamask/eth-query":1762,"@metamask/polling-controller":2137,uuid:5219},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},c=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.GasFeeController=n.GAS_ESTIMATE_TYPES=n.LEGACY_GAS_PRICES_API_URL=void 0;const u=e("@metamask/controller-utils"),l=c(e("@metamask/eth-query")),d=e("@metamask/polling-controller"),m=e("uuid"),h=c(e("./determineGasFeeCalculations.cjs")),f=e("./gas-util.cjs");n.LEGACY_GAS_PRICES_API_URL="https://api.metaswap.codefi.network/gasPrices",n.GAS_ESTIMATE_TYPES={FEE_MARKET:"fee-market",LEGACY:"legacy",ETH_GASPRICE:"eth_gasPrice",NONE:"none"};const p={gasFeeEstimatesByChainId:{persist:!0,anonymous:!1},gasFeeEstimates:{persist:!0,anonymous:!1},estimatedGasFeeTimeBounds:{persist:!0,anonymous:!1},gasEstimateType:{persist:!0,anonymous:!1},nonRPCGasFeeApisDisabled:{persist:!0,anonymous:!1}},y={gasFeeEstimatesByChainId:{},gasFeeEstimates:{},estimatedGasFeeTimeBounds:{},gasEstimateType:n.GAS_ESTIMATE_TYPES.NONE,nonRPCGasFeeApisDisabled:!1};class g extends((0,d.StaticIntervalPollingController)()){constructor({interval:e=15e3,messenger:t,state:c,getCurrentNetworkEIP1559Compatibility:u,getCurrentAccountEIP1559Compatibility:d,getChainId:m,getCurrentNetworkLegacyGasAPICompatibility:h,getProvider:f,onNetworkDidChange:g,legacyAPIEndpoint:b=n.LEGACY_GAS_PRICES_API_URL,EIP1559APIEndpoint:v,clientId:k}){if(super({name:"GasFeeController",metadata:p,messenger:t,state:{...y,...c}}),r.add(this),s.set(this,void 0),this.intervalDelay=e,this.setIntervalLength(e),this.pollTokens=new Set,this.getCurrentNetworkEIP1559Compatibility=u,this.getCurrentNetworkLegacyGasAPICompatibility=h,this.getCurrentAccountEIP1559Compatibility=d,a(this,s,f,"f"),this.EIP1559APIEndpoint=v,this.legacyAPIEndpoint=b,this.clientId=k,this.ethQuery=new l.default(o(this,s,"f").call(this)),g&&m)this.currentChainId=m(),g(async e=>{await o(this,r,"m",i).call(this,e)});else{const{selectedNetworkClientId:e}=this.messagingSystem.call("NetworkController:getState");this.currentChainId=this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId,this.messagingSystem.subscribe("NetworkController:networkDidChange",async e=>{await o(this,r,"m",i).call(this,e)})}}async resetPolling(){if(0!==this.pollTokens.size){const e=Array.from(this.pollTokens);this.stopPolling(),await this.getGasFeeEstimatesAndStartPolling(e[0]),e.slice(1).forEach(e=>{this.pollTokens.add(e)})}}async fetchGasFeeEstimates(e){return await this._fetchGasFeeEstimateData(e)}async getGasFeeEstimatesAndStartPolling(e){const t=e||(0,m.v1)();return this.pollTokens.add(t),1===this.pollTokens.size&&(await this._fetchGasFeeEstimateData(),this._poll()),t}async _fetchGasFeeEstimateData(e={}){const{shouldUpdateState:t=!0,networkClientId:n}=e;let r,s,i,a;if(n!==undefined){const e=this.messagingSystem.call("NetworkController:getNetworkClientById",n);i="0x38"===e.configuration.chainId,a=(0,u.convertHexToDecimal)(e.configuration.chainId);try{s=await this.messagingSystem.call("NetworkController:getEIP1559Compatibility",n)||!1}catch{s=!1}r=new l.default(e.provider)}r??(r=this.ethQuery),i??(i=this.getCurrentNetworkLegacyGasAPICompatibility()),a??(a=(0,u.convertHexToDecimal)(this.currentChainId));try{s??(s=await this.getEIP1559Compatibility())}catch(e){console.error(e),s??(s=!1)}const o=await(0,h.default)({isEIP1559Compatible:s,isLegacyGasAPICompatible:i,fetchGasEstimates:f.fetchGasEstimates,fetchGasEstimatesUrl:this.EIP1559APIEndpoint.replace("<chain_id>",`${a}`),fetchLegacyGasPriceEstimates:f.fetchLegacyGasPriceEstimates,fetchLegacyGasPriceEstimatesUrl:this.legacyAPIEndpoint.replace("<chain_id>",`${a}`),fetchEthGasPriceEstimate:f.fetchEthGasPriceEstimate,calculateTimeEstimate:f.calculateTimeEstimate,clientId:this.clientId,ethQuery:r,nonRPCGasFeeApisDisabled:this.state.nonRPCGasFeeApisDisabled});if(t){const e=(0,u.toHex)(a);this.update(t=>{this.currentChainId===e&&(t.gasFeeEstimates=o.gasFeeEstimates,t.estimatedGasFeeTimeBounds=o.estimatedGasFeeTimeBounds,t.gasEstimateType=o.gasEstimateType),t.gasFeeEstimatesByChainId??(t.gasFeeEstimatesByChainId={}),t.gasFeeEstimatesByChainId[e]={gasFeeEstimates:o.gasFeeEstimates,estimatedGasFeeTimeBounds:o.estimatedGasFeeTimeBounds,gasEstimateType:o.gasEstimateType}})}return o}disconnectPoller(e){this.pollTokens.delete(e),0===this.pollTokens.size&&this.stopPolling()}stopPolling(){this.intervalId&&clearInterval(this.intervalId),this.pollTokens.clear(),this.resetState()}destroy(){super.destroy(),this.stopPolling()}_poll(){this.intervalId&&clearInterval(this.intervalId),this.intervalId=setInterval(async()=>{await(0,u.safelyExecute)(()=>this._fetchGasFeeEstimateData())},this.intervalDelay)}async _executePoll({networkClientId:e}){await this._fetchGasFeeEstimateData({networkClientId:e})}resetState(){this.update(()=>y)}async getEIP1559Compatibility(){const e=await this.getCurrentNetworkEIP1559Compatibility(),t=this.getCurrentAccountEIP1559Compatibility?.()??!0;return e&&t}getTimeEstimate(e,t){return this.state.gasFeeEstimates&&this.state.gasEstimateType===n.GAS_ESTIMATE_TYPES.FEE_MARKET?(0,f.calculateTimeEstimate)(e,t,this.state.gasFeeEstimates):{}}enableNonRPCGasFeeApis(){this.update(e=>{e.nonRPCGasFeeApisDisabled=!1})}disableNonRPCGasFeeApis(){this.update(e=>{e.nonRPCGasFeeApisDisabled=!0})}}n.GasFeeController=g,s=new WeakMap,r=new WeakSet,i=async function({selectedNetworkClientId:e}){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId;t!==this.currentChainId&&(this.ethQuery=new l.default(o(this,s,"f").call(this)),await this.resetPolling(),this.currentChainId=t)},n.default=g}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs"}],[1847,{"./GasFeeController.cjs":1846},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("./GasFeeController.cjs");n.default=async function(e){try{return await async function(e){const{isEIP1559Compatible:t,isLegacyGasAPICompatible:n,nonRPCGasFeeApisDisabled:s}=e;try{if(t&&!s)return await async function(e){const{fetchGasEstimates:t,fetchGasEstimatesUrl:n,clientId:s,calculateTimeEstimate:i}=e,a=await t(n,s),{suggestedMaxPriorityFeePerGas:o,suggestedMaxFeePerGas:c}=a.medium,u=i(o,c,a);return{gasFeeEstimates:a,estimatedGasFeeTimeBounds:u,gasEstimateType:r.GAS_ESTIMATE_TYPES.FEE_MARKET}}(e);if(n&&!s)return await async function(e){const{fetchLegacyGasPriceEstimates:t,fetchLegacyGasPriceEstimatesUrl:n,clientId:s}=e;return{gasFeeEstimates:await t(n,s),estimatedGasFeeTimeBounds:{},gasEstimateType:r.GAS_ESTIMATE_TYPES.LEGACY}}(e);throw new Error("Main gas fee/price estimation failed. Use fallback")}catch{return await async function(e){const{ethQuery:t,fetchEthGasPriceEstimate:n}=e;return{gasFeeEstimates:await n(t),estimatedGasFeeTimeBounds:{},gasEstimateType:r.GAS_ESTIMATE_TYPES.ETH_GASPRICE}}(e)}}(e)}catch(e){if(e instanceof Error)throw new Error(`Gas fee/price estimation failed. Message: ${e.message}`);throw e}}}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/determineGasFeeCalculations.cjs"}],[1848,{"@metamask/controller-utils":1229,"bn.js":3553},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.calculateTimeEstimate=n.fetchEthGasPriceEstimate=n.fetchLegacyGasPriceEstimates=n.fetchGasEstimates=n.normalizeGWEIDecimalNumbers=void 0;const s=e("@metamask/controller-utils"),i=r(e("bn.js")),a=e=>({"X-Client-Id":e});function o(e){const t=(0,s.gweiDecToWEIBN)(e).toString(16);return(0,s.weiHexToGweiDec)(t)}n.normalizeGWEIDecimalNumbers=o,n.fetchGasEstimates=async function(e,t){const n=await(0,s.handleFetch)(e,t?{headers:a(t)}:undefined);return{low:{...n.low,suggestedMaxPriorityFeePerGas:o(n.low.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:o(n.low.suggestedMaxFeePerGas)},medium:{...n.medium,suggestedMaxPriorityFeePerGas:o(n.medium.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:o(n.medium.suggestedMaxFeePerGas)},high:{...n.high,suggestedMaxPriorityFeePerGas:o(n.high.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:o(n.high.suggestedMaxFeePerGas)},estimatedBaseFee:o(n.estimatedBaseFee),historicalBaseFeeRange:n.historicalBaseFeeRange,baseFeeTrend:n.baseFeeTrend,latestPriorityFeeRange:n.latestPriorityFeeRange,historicalPriorityFeeRange:n.historicalPriorityFeeRange,priorityFeeTrend:n.priorityFeeTrend,networkCongestion:n.networkCongestion}},n.fetchLegacyGasPriceEstimates=async function(e,t){const n=await(0,s.handleFetch)(e,{referrer:e,referrerPolicy:"no-referrer-when-downgrade",method:"GET",mode:"cors",headers:{"Content-Type":"application/json",...t&&a(t)}});return{low:n.SafeGasPrice,medium:n.ProposeGasPrice,high:n.FastGasPrice}},n.fetchEthGasPriceEstimate=async function(e){const t=await(0,s.query)(e,"gasPrice");return{gasPrice:(0,s.weiHexToGweiDec)(t).toString()}},n.calculateTimeEstimate=function(e,t,n){const{low:r,medium:a,high:o,estimatedBaseFee:c}=n,u=(0,s.gweiDecToWEIBN)(e),l=(0,s.gweiDecToWEIBN)(t),d=(0,s.gweiDecToWEIBN)(c),m=i.default.min(u,l.sub(d)),h=(0,s.gweiDecToWEIBN)(r.suggestedMaxPriorityFeePerGas),f=(0,s.gweiDecToWEIBN)(a.suggestedMaxPriorityFeePerGas),p=(0,s.gweiDecToWEIBN)(o.suggestedMaxPriorityFeePerGas);let y,g;return m.lt(h)?(y=null,g="unknown"):m.gte(h)&&m.lt(f)?(y=r.minWaitTimeEstimate,g=r.maxWaitTimeEstimate):m.gte(f)&&m.lt(p)?(y=a.minWaitTimeEstimate,g=a.maxWaitTimeEstimate):m.eq(p)?(y=o.minWaitTimeEstimate,g=o.maxWaitTimeEstimate):(y=0,g=o.maxWaitTimeEstimate),{lowerTimeBound:y,upperTimeBound:g}}}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/gas-util.cjs"}],[1849,{"./GasFeeController.cjs":1846},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./GasFeeController.cjs"),n)}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/index.cjs"}],[1856,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=["#01888C","#FC7500","#034F5D","#F73F01","#FC1960","#C7144C","#F3C100","#1598F2","#2465E1","#F19E02"]}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/colors.js"}],[1857,{"./colors":1856,"./paper":1863,color:1862,"mersenne-twister":4445},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=e("mersenne-twister"),i=e("./paper"),a=e("color"),o=e("./colors"),c="http://www.w3.org/2000/svg";function u(e,t,n,s,i){var a=t/2,o=document.createElementNS(c,"rect");o.setAttributeNS(null,"x","0"),o.setAttributeNS(null,"y","0"),o.setAttributeNS(null,"width",t),o.setAttributeNS(null,"height",t);var u=r.random(),d=2*Math.PI*u,m=t/s*r.random()+n*t/s,h="translate("+Math.cos(d)*m+" "+Math.sin(d)*m+")"+" "+("rotate("+(360*u+180*r.random()).toFixed(1)+" "+a+" "+a+")");o.setAttributeNS(null,"transform",h);var f=l(e);o.setAttributeNS(null,"fill",f),i.appendChild(o)}function l(e){r.random();var t=Math.floor(e.length*r.random());return e.splice(t,1)[0]}t.exports=function(e,t){r=new s(t);var n=function(e,t){var n=30*t.random()-d/2;return e.map(function(e){var t=a(e);return t.rotate(n),t.hexString()})}(o.slice(),r),m=i(e,l(n)).container,h=document.createElementNS(c,"svg");h.setAttributeNS(null,"x","0"),h.setAttributeNS(null,"y","0"),h.setAttributeNS(null,"width",e),h.setAttributeNS(null,"height",e),m.appendChild(h);for(var f=0;f<3;f++)u(n,e,f,3,h);return m};var d=30}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/index.js"}],[1858,{"color-name":1861},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("color-name"),s={};for(var i in r)r.hasOwnProperty(i)&&(s[r[i]]=i);var a=t.exports={rgb:{channels:3,labels:"rgb"},hsl:{channels:3,labels:"hsl"},hsv:{channels:3,labels:"hsv"},hwb:{channels:3,labels:"hwb"},cmyk:{channels:4,labels:"cmyk"},xyz:{channels:3,labels:"xyz"},lab:{channels:3,labels:"lab"},lch:{channels:3,labels:"lch"},hex:{channels:1,labels:["hex"]},keyword:{channels:1,labels:["keyword"]},ansi16:{channels:1,labels:["ansi16"]},ansi256:{channels:1,labels:["ansi256"]},hcg:{channels:3,labels:["h","c","g"]},apple:{channels:3,labels:["r16","g16","b16"]},gray:{channels:1,labels:["gray"]}};for(var o in a)if(a.hasOwnProperty(o)){if(!("channels"in a[o]))throw new Error("missing channels property: "+o);if(!("labels"in a[o]))throw new Error("missing channel labels property: "+o);if(a[o].labels.length!==a[o].channels)throw new Error("channel and label counts mismatch: "+o);var c=a[o].channels,u=a[o].labels;delete a[o].channels,delete a[o].labels,Object.defineProperty(a[o],"channels",{value:c}),Object.defineProperty(a[o],"labels",{value:u})}function l(e,t){return Math.pow(e[0]-t[0],2)+Math.pow(e[1]-t[1],2)+Math.pow(e[2]-t[2],2)}a.rgb.hsl=function(e){var t,n,r=e[0]/255,s=e[1]/255,i=e[2]/255,a=Math.min(r,s,i),o=Math.max(r,s,i),c=o-a;return o===a?t=0:r===o?t=(s-i)/c:s===o?t=2+(i-r)/c:i===o&&(t=4+(r-s)/c),(t=Math.min(60*t,360))<0&&(t+=360),n=(a+o)/2,[t,100*(o===a?0:n<=.5?c/(o+a):c/(2-o-a)),100*n]},a.rgb.hsv=function(e){var t,n,r,s,i,a=e[0]/255,o=e[1]/255,c=e[2]/255,u=Math.max(a,o,c),l=u-Math.min(a,o,c),d=function(e){return(u-e)/6/l+.5};return 0===l?s=i=0:(i=l/u,t=d(a),n=d(o),r=d(c),a===u?s=r-n:o===u?s=1/3+t-r:c===u&&(s=2/3+n-t),s<0?s+=1:s>1&&(s-=1)),[360*s,100*i,100*u]},a.rgb.hwb=function(e){var t=e[0],n=e[1],r=e[2];return[a.rgb.hsl(e)[0],100*(1/255*Math.min(t,Math.min(n,r))),100*(r=1-1/255*Math.max(t,Math.max(n,r)))]},a.rgb.cmyk=function(e){var t,n=e[0]/255,r=e[1]/255,s=e[2]/255;return[100*((1-n-(t=Math.min(1-n,1-r,1-s)))/(1-t)||0),100*((1-r-t)/(1-t)||0),100*((1-s-t)/(1-t)||0),100*t]},a.rgb.keyword=function(e){var t=s[e];if(t)return t;var n,i=Infinity;for(var a in r)if(r.hasOwnProperty(a)){var o=l(e,r[a]);o<i&&(i=o,n=a)}return n},a.keyword.rgb=function(e){return r[e]},a.rgb.xyz=function(e){var t=e[0]/255,n=e[1]/255,r=e[2]/255;return[100*(.4124*(t=t>.04045?Math.pow((t+.055)/1.055,2.4):t/12.92)+.3576*(n=n>.04045?Math.pow((n+.055)/1.055,2.4):n/12.92)+.1805*(r=r>.04045?Math.pow((r+.055)/1.055,2.4):r/12.92)),100*(.2126*t+.7152*n+.0722*r),100*(.0193*t+.1192*n+.9505*r)]},a.rgb.lab=function(e){var t=a.rgb.xyz(e),n=t[0],r=t[1],s=t[2];return r/=100,s/=108.883,n=(n/=95.047)>.008856?Math.pow(n,1/3):7.787*n+16/116,[116*(r=r>.008856?Math.pow(r,1/3):7.787*r+16/116)-16,500*(n-r),200*(r-(s=s>.008856?Math.pow(s,1/3):7.787*s+16/116))]},a.hsl.rgb=function(e){var t,n,r,s,i,a=e[0]/360,o=e[1]/100,c=e[2]/100;if(0===o)return[i=255*c,i,i];t=2*c-(n=c<.5?c*(1+o):c+o-c*o),s=[0,0,0];for(var u=0;u<3;u++)(r=a+1/3*-(u-1))<0&&r++,r>1&&r--,i=6*r<1?t+6*(n-t)*r:2*r<1?n:3*r<2?t+(n-t)*(2/3-r)*6:t,s[u]=255*i;return s},a.hsl.hsv=function(e){var t=e[0],n=e[1]/100,r=e[2]/100,s=n,i=Math.max(r,.01);return n*=(r*=2)<=1?r:2-r,s*=i<=1?i:2-i,[t,100*(0===r?2*s/(i+s):2*n/(r+n)),100*((r+n)/2)]},a.hsv.rgb=function(e){var t=e[0]/60,n=e[1]/100,r=e[2]/100,s=Math.floor(t)%6,i=t-Math.floor(t),a=255*r*(1-n),o=255*r*(1-n*i),c=255*r*(1-n*(1-i));switch(r*=255,s){case 0:return[r,c,a];case 1:return[o,r,a];case 2:return[a,r,c];case 3:return[a,o,r];case 4:return[c,a,r];case 5:return[r,a,o]}},a.hsv.hsl=function(e){var t,n,r,s=e[0],i=e[1]/100,a=e[2]/100,o=Math.max(a,.01);return r=(2-i)*a,n=i*o,[s,100*(n=(n/=(t=(2-i)*o)<=1?t:2-t)||0),100*(r/=2)]},a.hwb.rgb=function(e){var t,n,r,s,i,a,o,c=e[0]/360,u=e[1]/100,l=e[2]/100,d=u+l;switch(d>1&&(u/=d,l/=d),r=6*c-(t=Math.floor(6*c)),1&t&&(r=1-r),s=u+r*((n=1-l)-u),t){default:case 6:case 0:i=n,a=s,o=u;break;case 1:i=s,a=n,o=u;break;case 2:i=u,a=n,o=s;break;case 3:i=u,a=s,o=n;break;case 4:i=s,a=u,o=n;break;case 5:i=n,a=u,o=s}return[255*i,255*a,255*o]},a.cmyk.rgb=function(e){var t=e[0]/100,n=e[1]/100,r=e[2]/100,s=e[3]/100;return[255*(1-Math.min(1,t*(1-s)+s)),255*(1-Math.min(1,n*(1-s)+s)),255*(1-Math.min(1,r*(1-s)+s))]},a.xyz.rgb=function(e){var t,n,r,s=e[0]/100,i=e[1]/100,a=e[2]/100;return n=-.9689*s+1.8758*i+.0415*a,r=.0557*s+-.204*i+1.057*a,t=(t=3.2406*s+-1.5372*i+-.4986*a)>.0031308?1.055*Math.pow(t,1/2.4)-.055:12.92*t,n=n>.0031308?1.055*Math.pow(n,1/2.4)-.055:12.92*n,r=r>.0031308?1.055*Math.pow(r,1/2.4)-.055:12.92*r,[255*(t=Math.min(Math.max(0,t),1)),255*(n=Math.min(Math.max(0,n),1)),255*(r=Math.min(Math.max(0,r),1))]},a.xyz.lab=function(e){var t=e[0],n=e[1],r=e[2];return n/=100,r/=108.883,t=(t/=95.047)>.008856?Math.pow(t,1/3):7.787*t+16/116,[116*(n=n>.008856?Math.pow(n,1/3):7.787*n+16/116)-16,500*(t-n),200*(n-(r=r>.008856?Math.pow(r,1/3):7.787*r+16/116))]},a.lab.xyz=function(e){var t,n,r,s=e[0];t=e[1]/500+(n=(s+16)/116),r=n-e[2]/200;var i=Math.pow(n,3),a=Math.pow(t,3),o=Math.pow(r,3);return n=i>.008856?i:(n-16/116)/7.787,t=a>.008856?a:(t-16/116)/7.787,r=o>.008856?o:(r-16/116)/7.787,[t*=95.047,n*=100,r*=108.883]},a.lab.lch=function(e){var t,n=e[0],r=e[1],s=e[2];return(t=360*Math.atan2(s,r)/2/Math.PI)<0&&(t+=360),[n,Math.sqrt(r*r+s*s),t]},a.lch.lab=function(e){var t,n=e[0],r=e[1];return t=e[2]/360*2*Math.PI,[n,r*Math.cos(t),r*Math.sin(t)]},a.rgb.ansi16=function(e){var t=e[0],n=e[1],r=e[2],s=1 in arguments?arguments[1]:a.rgb.hsv(e)[2];if(0===(s=Math.round(s/50)))return 30;var i=30+(Math.round(r/255)<<2|Math.round(n/255)<<1|Math.round(t/255));return 2===s&&(i+=60),i},a.hsv.ansi16=function(e){return a.rgb.ansi16(a.hsv.rgb(e),e[2])},a.rgb.ansi256=function(e){var t=e[0],n=e[1],r=e[2];return t===n&&n===r?t<8?16:t>248?231:Math.round((t-8)/247*24)+232:16+36*Math.round(t/255*5)+6*Math.round(n/255*5)+Math.round(r/255*5)},a.ansi16.rgb=function(e){var t=e%10;if(0===t||7===t)return e>50&&(t+=3.5),[t=t/10.5*255,t,t];var n=.5*(1+~~(e>50));return[(1&t)*n*255,(t>>1&1)*n*255,(t>>2&1)*n*255]},a.ansi256.rgb=function(e){if(e>=232){var t=10*(e-232)+8;return[t,t,t]}var n;return e-=16,[Math.floor(e/36)/5*255,Math.floor((n=e%36)/6)/5*255,n%6/5*255]},a.rgb.hex=function(e){var t=(((255&Math.round(e[0]))<<16)+((255&Math.round(e[1]))<<8)+(255&Math.round(e[2]))).toString(16).toUpperCase();return"000000".substring(t.length)+t},a.hex.rgb=function(e){var t=e.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!t)return[0,0,0];var n=t[0];3===t[0].length&&(n=n.split("").map(function(e){return e+e}).join(""));var r=parseInt(n,16);return[r>>16&255,r>>8&255,255&r]},a.rgb.hcg=function(e){var t,n=e[0]/255,r=e[1]/255,s=e[2]/255,i=Math.max(Math.max(n,r),s),a=Math.min(Math.min(n,r),s),o=i-a;return t=o<=0?0:i===n?(r-s)/o%6:i===r?2+(s-n)/o:4+(n-r)/o+4,t/=6,[360*(t%=1),100*o,100*(o<1?a/(1-o):0)]},a.hsl.hcg=function(e){var t=e[1]/100,n=e[2]/100,r=1,s=0;return(r=n<.5?2*t*n:2*t*(1-n))<1&&(s=(n-.5*r)/(1-r)),[e[0],100*r,100*s]},a.hsv.hcg=function(e){var t=e[1]/100,n=e[2]/100,r=t*n,s=0;return r<1&&(s=(n-r)/(1-r)),[e[0],100*r,100*s]},a.hcg.rgb=function(e){var t=e[0]/360,n=e[1]/100,r=e[2]/100;if(0===n)return[255*r,255*r,255*r];var s,i=[0,0,0],a=t%1*6,o=a%1,c=1-o;switch(Math.floor(a)){case 0:i[0]=1,i[1]=o,i[2]=0;break;case 1:i[0]=c,i[1]=1,i[2]=0;break;case 2:i[0]=0,i[1]=1,i[2]=o;break;case 3:i[0]=0,i[1]=c,i[2]=1;break;case 4:i[0]=o,i[1]=0,i[2]=1;break;default:i[0]=1,i[1]=0,i[2]=c}return s=(1-n)*r,[255*(n*i[0]+s),255*(n*i[1]+s),255*(n*i[2]+s)]},a.hcg.hsv=function(e){var t=e[1]/100,n=t+e[2]/100*(1-t),r=0;return n>0&&(r=t/n),[e[0],100*r,100*n]},a.hcg.hsl=function(e){var t=e[1]/100,n=e[2]/100*(1-t)+.5*t,r=0;return n>0&&n<.5?r=t/(2*n):n>=.5&&n<1&&(r=t/(2*(1-n))),[e[0],100*r,100*n]},a.hcg.hwb=function(e){var t=e[1]/100,n=t+e[2]/100*(1-t);return[e[0],100*(n-t),100*(1-n)]},a.hwb.hcg=function(e){var t=e[1]/100,n=1-e[2]/100,r=n-t,s=0;return r<1&&(s=(n-r)/(1-r)),[e[0],100*r,100*s]},a.apple.rgb=function(e){return[e[0]/65535*255,e[1]/65535*255,e[2]/65535*255]},a.rgb.apple=function(e){return[e[0]/255*65535,e[1]/255*65535,e[2]/255*65535]},a.gray.rgb=function(e){return[e[0]/100*255,e[0]/100*255,e[0]/100*255]},a.gray.hsl=a.gray.hsv=function(e){return[0,0,e[0]]},a.gray.hwb=function(e){return[0,100,e[0]]},a.gray.cmyk=function(e){return[0,0,0,e[0]]},a.gray.lab=function(e){return[e[0],0,0]},a.gray.hex=function(e){var t=255&Math.round(e[0]/100*255),n=((t<<16)+(t<<8)+t).toString(16).toUpperCase();return"000000".substring(n.length)+n},a.rgb.gray=function(e){return[(e[0]+e[1]+e[2])/3/255*100]}}}},{package:"@metamask/jazzicon>color>color-convert",file:"node_modules/@metamask/jazzicon/node_modules/color-convert/conversions.js"}],[1859,{"./conversions":1858,"./route":1860},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./conversions"),s=e("./route"),i={};Object.keys(r).forEach(function(e){i[e]={},Object.defineProperty(i[e],"channels",{value:r[e].channels}),Object.defineProperty(i[e],"labels",{value:r[e].labels});var t=s(e);Object.keys(t).forEach(function(n){var r=t[n];i[e][n]=function(e){var t=function(t){if(t===undefined||null===t)return t;arguments.length>1&&(t=Array.prototype.slice.call(arguments));var n=e(t);if("object"==typeof n)for(var r=n.length,s=0;s<r;s++)n[s]=Math.round(n[s]);return n};return"conversion"in e&&(t.conversion=e.conversion),t}(r),i[e][n].raw=function(e){var t=function(t){return t===undefined||null===t?t:(arguments.length>1&&(t=Array.prototype.slice.call(arguments)),e(t))};return"conversion"in e&&(t.conversion=e.conversion),t}(r)})}),t.exports=i}}},{package:"@metamask/jazzicon>color>color-convert",file:"node_modules/@metamask/jazzicon/node_modules/color-convert/index.js"}],[1860,{"./conversions":1858},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("./conversions");function s(e){var t=function(){for(var e={},t=Object.keys(r),n=t.length,s=0;s<n;s++)e[t[s]]={distance:-1,parent:null};return e}(),n=[e];for(t[e].distance=0;n.length;)for(var s=n.pop(),i=Object.keys(r[s]),a=i.length,o=0;o<a;o++){var c=i[o],u=t[c];-1===u.distance&&(u.distance=t[s].distance+1,u.parent=s,n.unshift(c))}return t}function i(e,t){return function(n){return t(e(n))}}function a(e,t){for(var n=[t[e].parent,e],s=r[t[e].parent][e],a=t[e].parent;t[a].parent;)n.unshift(t[a].parent),s=i(r[t[a].parent][a],s),a=t[a].parent;return s.conversion=n,s}t.exports=function(e){for(var t=s(e),n={},r=Object.keys(t),i=r.length,o=0;o<i;o++){var c=r[o];null!==t[c].parent&&(n[c]=a(c,t))}return n}}}},{package:"@metamask/jazzicon>color>color-convert",file:"node_modules/@metamask/jazzicon/node_modules/color-convert/route.js"}],[1861,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}}}},{package:"@metamask/jazzicon>color>color-convert>color-name",file:"node_modules/@metamask/jazzicon/node_modules/color-name/index.js"}],[1862,{clone:3648,"color-convert":1859,"color-string":3680},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=e("clone"),s=e("color-convert"),i=e("color-string"),a=function(e){if(e instanceof a)return e;if(!(this instanceof a))return new a(e);var t;if(this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1},"string"==typeof e)if(t=i.getRgba(e))this.setValues("rgb",t);else if(t=i.getHsla(e))this.setValues("hsl",t);else{if(!(t=i.getHwb(e)))throw new Error('Unable to parse color from string "'+e+'"');this.setValues("hwb",t)}else if("object"==typeof e)if((t=e).r!==undefined||t.red!==undefined)this.setValues("rgb",t);else if(t.l!==undefined||t.lightness!==undefined)this.setValues("hsl",t);else if(t.v!==undefined||t.value!==undefined)this.setValues("hsv",t);else if(t.w!==undefined||t.whiteness!==undefined)this.setValues("hwb",t);else{if(t.c===undefined&&t.cyan===undefined)throw new Error("Unable to parse color from object "+JSON.stringify(e));this.setValues("cmyk",t)}};a.prototype={rgb:function(){return this.setSpace("rgb",arguments)},hsl:function(){return this.setSpace("hsl",arguments)},hsv:function(){return this.setSpace("hsv",arguments)},hwb:function(){return this.setSpace("hwb",arguments)},cmyk:function(){return this.setSpace("cmyk",arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){return 1!==this.values.alpha?this.values.hwb.concat([this.values.alpha]):this.values.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){return this.values.rgb.concat([this.values.alpha])},rgbaArrayNormalized:function(){for(var e=this.values.rgb,t=[],n=0;n<3;n++)t[n]=e[n]/255;return t.push(this.values.alpha),t},hslaArray:function(){return this.values.hsl.concat([this.values.alpha])},alpha:function(e){return e===undefined?this.values.alpha:(this.setValues("alpha",e),this)},red:function(e){return this.setChannel("rgb",0,e)},green:function(e){return this.setChannel("rgb",1,e)},blue:function(e){return this.setChannel("rgb",2,e)},hue:function(e){return e&&(e=(e%=360)<0?360+e:e),this.setChannel("hsl",0,e)},saturation:function(e){return this.setChannel("hsl",1,e)},lightness:function(e){return this.setChannel("hsl",2,e)},saturationv:function(e){return this.setChannel("hsv",1,e)},whiteness:function(e){return this.setChannel("hwb",1,e)},blackness:function(e){return this.setChannel("hwb",2,e)},value:function(e){return this.setChannel("hsv",2,e)},cyan:function(e){return this.setChannel("cmyk",0,e)},magenta:function(e){return this.setChannel("cmyk",1,e)},yellow:function(e){return this.setChannel("cmyk",2,e)},black:function(e){return this.setChannel("cmyk",3,e)},hexString:function(){return i.hexString(this.values.rgb)},rgbString:function(){return i.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return i.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return i.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return i.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return i.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return i.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return i.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){return this.values.rgb[0]<<16|this.values.rgb[1]<<8|this.values.rgb[2]},luminosity:function(){for(var e=this.values.rgb,t=[],n=0;n<e.length;n++){var r=e[n]/255;t[n]=r<=.03928?r/12.92:Math.pow((r+.055)/1.055,2.4)}return.2126*t[0]+.7152*t[1]+.0722*t[2]},contrast:function(e){var t=this.luminosity(),n=e.luminosity();return t>n?(t+.05)/(n+.05):(n+.05)/(t+.05)},level:function(e){var t=this.contrast(e);return t>=7.1?"AAA":t>=4.5?"AA":""},dark:function(){var e=this.values.rgb;return(299*e[0]+587*e[1]+114*e[2])/1e3<128},light:function(){return!this.dark()},negate:function(){for(var e=[],t=0;t<3;t++)e[t]=255-this.values.rgb[t];return this.setValues("rgb",e),this},lighten:function(e){return this.values.hsl[2]+=this.values.hsl[2]*e,this.setValues("hsl",this.values.hsl),this},darken:function(e){return this.values.hsl[2]-=this.values.hsl[2]*e,this.setValues("hsl",this.values.hsl),this},saturate:function(e){return this.values.hsl[1]+=this.values.hsl[1]*e,this.setValues("hsl",this.values.hsl),this},desaturate:function(e){return this.values.hsl[1]-=this.values.hsl[1]*e,this.setValues("hsl",this.values.hsl),this},whiten:function(e){return this.values.hwb[1]+=this.values.hwb[1]*e,this.setValues("hwb",this.values.hwb),this},blacken:function(e){return this.values.hwb[2]+=this.values.hwb[2]*e,this.setValues("hwb",this.values.hwb),this},greyscale:function(){var e=this.values.rgb,t=.3*e[0]+.59*e[1]+.11*e[2];return this.setValues("rgb",[t,t,t]),this},clearer:function(e){return this.setValues("alpha",this.values.alpha-this.values.alpha*e),this},opaquer:function(e){return this.setValues("alpha",this.values.alpha+this.values.alpha*e),this},rotate:function(e){var t=this.values.hsl[0];return t=(t=(t+e)%360)<0?360+t:t,this.values.hsl[0]=t,this.setValues("hsl",this.values.hsl),this},mix:function(e,t){var n=this,r=e,s=t===undefined?.5:t,i=2*s-1,a=n.alpha()-r.alpha(),o=((i*a===-1?i:(i+a)/(1+i*a))+1)/2,c=1-o;return this.rgb(o*n.red()+c*r.red(),o*n.green()+c*r.green(),o*n.blue()+c*r.blue()).alpha(n.alpha()*s+r.alpha()*(1-s))},toJSON:function(){return this.rgb()},clone:function(){var e=new a;return e.values=r(this.values),e}},a.prototype.getValues=function(e){for(var t={},n=0;n<e.length;n++)t[e.charAt(n)]=this.values[e][n];return 1!==this.values.alpha&&(t.a=this.values.alpha),t},a.prototype.setValues=function(e,t){var n,r,i={rgb:["red","green","blue"],hsl:["hue","saturation","lightness"],hsv:["hue","saturation","value"],hwb:["hue","whiteness","blackness"],cmyk:["cyan","magenta","yellow","black"]},a={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]},o=1;if("alpha"===e)o=t;else if(t.length)this.values[e]=t.slice(0,e.length),o=t[e.length];else if(t[e.charAt(0)]!==undefined){for(n=0;n<e.length;n++)this.values[e][n]=t[e.charAt(n)];o=t.a}else if(t[i[e][0]]!==undefined){var c=i[e];for(n=0;n<e.length;n++)this.values[e][n]=t[c[n]];o=t.alpha}if(this.values.alpha=Math.max(0,Math.min(1,o===undefined?this.values.alpha:o)),"alpha"===e)return!1;for(n=0;n<e.length;n++)r=Math.max(0,Math.min(a[e][n],this.values[e][n])),this.values[e][n]=Math.round(r);for(var u in i)for(u!==e&&(this.values[u]=s[e][u](this.values[e])),n=0;n<u.length;n++)r=Math.max(0,Math.min(a[u][n],this.values[u][n])),this.values[u][n]=Math.round(r);return!0},a.prototype.setSpace=function(e,t){var n=t[0];return n===undefined?this.getValues(e):("number"==typeof n&&(n=Array.prototype.slice.call(t)),this.setValues(e,n),this)},a.prototype.setChannel=function(e,t,n){return n===undefined?this.values[e][t]:(n===this.values[e][t]||(this.values[e][t]=n,this.setValues(e,this.values[e])),this)},t.exports=a}}},{package:"@metamask/jazzicon>color",file:"node_modules/@metamask/jazzicon/node_modules/color/index.js"}],[1863,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=function(e,t){var n=document.createElement("div");return n.style.borderRadius="50px",n.style.overflow="hidden",n.style.padding="0px",n.style.margin="0px",n.style.width=e+"px",n.style.height=e+"px",n.style.display="inline-block",n.style.background=t,{container:n}}}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/paper.js"}],[1864,{"@metamask/rpc-errors":2252,"@metamask/safe-event-emitter":2254,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c,u,l,d,m,h,f,p,y=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},g=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},b=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcEngine=void 0;const v=e("@metamask/rpc-errors"),k=b(e("@metamask/safe-event-emitter")),E=e("@metamask/utils");class w extends k.default{constructor({notificationHandler:e}={}){super(),r.add(this),i.set(this,!1),a.set(this,void 0),o.set(this,void 0),y(this,a,[],"f"),y(this,o,e,"f")}destroy(){g(this,a,"f").forEach(e=>{"destroy"in e&&"function"==typeof e.destroy&&e.destroy()}),y(this,a,[],"f"),y(this,i,!0,"f")}push(e){g(this,r,"m",c).call(this),g(this,a,"f").push(e)}handle(e,t){if(g(this,r,"m",c).call(this),t&&"function"!=typeof t)throw new Error('"callback" must be a function if provided.');return Array.isArray(e)?t?g(this,r,"m",u).call(this,e,t):g(this,r,"m",u).call(this,e):t?g(this,r,"m",l).call(this,e,t):this._promiseHandle(e)}asMiddleware(){return g(this,r,"m",c).call(this),async(e,t,n,r)=>{try{const[i,o,c]=await g(s,s,"m",m).call(s,e,t,g(this,a,"f"));return o?(await g(s,s,"m",f).call(s,c),r(i)):n(async e=>{try{await g(s,s,"m",f).call(s,c)}catch(t){return e(t)}return e()})}catch(e){return r(e)}}}async _promiseHandle(e){return new Promise((t,n)=>{g(this,r,"m",l).call(this,e,(e,r)=>{e&&r===undefined?n(e):t(r)}).catch(n)})}}function T(e){return JSON.stringify(e,null,2)}n.JsonRpcEngine=w,s=w,i=new WeakMap,a=new WeakMap,o=new WeakMap,r=new WeakSet,c=function(){if(g(this,i,"f"))throw new Error("This engine is destroyed and can no longer be used.")},u=async function(e,t){try{if(0===e.length){const e=[{id:null,jsonrpc:"2.0",error:new v.JsonRpcError(v.errorCodes.rpc.invalidRequest,"Request batch must contain plain objects. Received an empty array")}];return t?t(null,e):e}const n=(await Promise.all(e.map(this._promiseHandle.bind(this)))).filter(e=>e!==undefined);return t?t(null,n):n}catch(e){if(t)return t(e);throw e}},l=async function(e,t){if(!e||Array.isArray(e)||"object"!=typeof e){const n=new v.JsonRpcError(v.errorCodes.rpc.invalidRequest,"Requests must be plain objects. Received: "+typeof e,{request:e});return t(n,{id:null,jsonrpc:"2.0",error:n})}if("string"!=typeof e.method){const n=new v.JsonRpcError(v.errorCodes.rpc.invalidRequest,"Must specify a string method. Received: "+typeof e.method,{request:e});return g(this,o,"f")&&!(0,E.isJsonRpcRequest)(e)?t(null):t(n,{id:e.id??null,jsonrpc:"2.0",error:n})}if(g(this,o,"f")&&(0,E.isJsonRpcNotification)(e)&&!(0,E.isJsonRpcRequest)(e)){try{await g(this,o,"f").call(this,e)}catch(n){return t(n)}return t(null)}let n=null;const r={...e},i={id:r.id,jsonrpc:r.jsonrpc};try{await g(s,s,"m",d).call(s,r,i,g(this,a,"f"))}catch(e){n=e}return n&&(delete i.result,i.error||(i.error=(0,v.serializeError)(n))),t(n,i)},d=async function(e,t,n){const[r,i,a]=await g(s,s,"m",m).call(s,e,t,n);if(g(s,s,"m",p).call(s,e,t,i),await g(s,s,"m",f).call(s,a),r)throw r},m=async function(e,t,n){const r=[];let i=null,a=!1;for(const o of n)if([i,a]=await g(s,s,"m",h).call(s,e,t,o,r),a)break;return[i,a,r.reverse()]},h=async function(e,t,n,r){return new Promise(s=>{const i=e=>{const n=e||t.error;n&&(t.error=(0,v.serializeError)(n)),s([n,!0])},a=n=>{t.error?i(t.error):(n&&("function"!=typeof n&&i(new v.JsonRpcError(v.errorCodes.rpc.internal,`JsonRpcEngine: "next" return handlers must be functions. Received "${typeof n}" for request:\n${T(e)}`,{request:e})),r.push(n)),s([null,!1]))};try{n(e,t,a,i)}catch(e){i(e)}})},f=async function(e){for(const t of e)await new Promise((e,n)=>{t(t=>t?n(t):e())})},p=function(e,t,n){if(!(0,E.hasProperty)(t,"result")&&!(0,E.hasProperty)(t,"error"))throw new v.JsonRpcError(v.errorCodes.rpc.internal,`JsonRpcEngine: Response has no error or result for request:\n${T(e)}`,{request:e});if(!n)throw new v.JsonRpcError(v.errorCodes.rpc.internal,`JsonRpcEngine: Nothing ended request:\n${T(e)}`,{request:e})}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs"}],[1865,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createAsyncMiddleware=void 0,n.createAsyncMiddleware=function(e){return async(t,n,r,s)=>{let i;const a=new Promise(e=>{i=e});let o=null,c=!1;const u=async()=>(c=!0,r(e=>{o=e,i()}),a);try{await e(t,n,u),c?(await a,o(null)):s(null)}catch(e){o?o(e):s(e)}}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs"}],[1866,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createScaffoldMiddleware=void 0,n.createScaffoldMiddleware=function(e){return(t,n,r,s)=>{const i=e[t.method];return i===undefined?r():"function"==typeof i?i(t,n,r,s):(n.result=i,s())}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs"}],[1867,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getUniqueId=void 0;const r=4294967295;let s=Math.floor(Math.random()*r);n.getUniqueId=function(){return s=(s+1)%r,s}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs"}],[1868,{"./getUniqueId.cjs":1867},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createIdRemapMiddleware=void 0;const r=e("./getUniqueId.cjs");n.createIdRemapMiddleware=function(){return(e,t,n,s)=>{const i=e.id,a=(0,r.getUniqueId)();e.id=a,t.id=a,n(n=>{e.id=i,t.id=i,n()})}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs"}],[1869,{"./JsonRpcEngine.cjs":1864,"./createAsyncMiddleware.cjs":1865,"./createScaffoldMiddleware.cjs":1866,"./getUniqueId.cjs":1867,"./idRemapMiddleware.cjs":1868,"./mergeMiddleware.cjs":1870},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMiddleware=n.JsonRpcEngine=n.createIdRemapMiddleware=n.getUniqueId=n.createScaffoldMiddleware=n.createAsyncMiddleware=void 0;var r=e("./createAsyncMiddleware.cjs");Object.defineProperty(n,"createAsyncMiddleware",{enumerable:!0,get:function(){return r.createAsyncMiddleware}});var s=e("./createScaffoldMiddleware.cjs");Object.defineProperty(n,"createScaffoldMiddleware",{enumerable:!0,get:function(){return s.createScaffoldMiddleware}});var i=e("./getUniqueId.cjs");Object.defineProperty(n,"getUniqueId",{enumerable:!0,get:function(){return i.getUniqueId}});var a=e("./idRemapMiddleware.cjs");Object.defineProperty(n,"createIdRemapMiddleware",{enumerable:!0,get:function(){return a.createIdRemapMiddleware}});var o=e("./JsonRpcEngine.cjs");Object.defineProperty(n,"JsonRpcEngine",{enumerable:!0,get:function(){return o.JsonRpcEngine}});var c=e("./mergeMiddleware.cjs");Object.defineProperty(n,"mergeMiddleware",{enumerable:!0,get:function(){return c.mergeMiddleware}})}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/index.cjs"}],[1870,{"./JsonRpcEngine.cjs":1864},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.mergeMiddleware=void 0;const r=e("./JsonRpcEngine.cjs");n.mergeMiddleware=function(e){const t=new r.JsonRpcEngine;return e.forEach(e=>t.push(e)),t.asMiddleware()}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs"}],[1871,{"readable-stream":4829},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e("readable-stream");n.default=function(e){if(!e?.engine)throw new Error("Missing engine parameter!");const{engine:t}=e,n=new r.Duplex({objectMode:!0,read:()=>undefined,write:function(e,r,s){t.handle(e,(e,t)=>{n.push(t)}),s()}});return t.on&&t.on("notification",e=>{n.push(e)}),n}}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/createEngineStream.cjs"}],[1872,{"@metamask/safe-event-emitter":2254,"@metamask/utils":2656,"readable-stream":4829},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0});const s=r(e("@metamask/safe-event-emitter")),i=e("@metamask/utils"),a=e("readable-stream");n.default=function(e={}){const t={},n=new a.Duplex({objectMode:!0,read:()=>undefined,write:function(n,s,a){let c=null;try{!(0,i.hasProperty)(n,"id")?function(n){e?.retryOnMessage&&n.method===e.retryOnMessage&&Object.values(t).forEach(({req:e,retryCount:n=0})=>{if(!e.id)return;if(n>=3)throw new Error(`StreamMiddleware - Retry limit exceeded for request id "${e.id}"`);const r=t[e.id];r&&(r.retryCount=n+1),o(e)});r.emit("notification",n)}(n):function(e){const{id:n}=e;if(null===n)return;const r=t[n];if(!r)return void console.warn(`StreamMiddleware - Unknown response id "${n}"`);delete t[n],Object.assign(r.res,e),setTimeout(r.end)}(n)}catch(e){c=e}a(c)}}),r=new s.default;return{events:r,middleware:(e,n,r,s)=>{t[e.id]={req:e,res:n,next:r,end:s},o(e)},stream:n};function o(e){n.push(e)}}}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/createStreamMiddleware.cjs"}],[1873,{"./createEngineStream.cjs":1871,"./createStreamMiddleware.cjs":1872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.createStreamMiddleware=n.createEngineStream=void 0;const s=r(e("./createEngineStream.cjs"));n.createEngineStream=s.default;const i=r(e("./createStreamMiddleware.cjs"));n.createStreamMiddleware=i.default}}},{package:"@metamask/json-rpc-middleware-stream",file:"node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs"}],[1874,{"./BIP44Node.cjs":1875,"./SLIP10Node.cjs":1876,"./constants.cjs":1877,"./utils.cjs":1894},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.getBIP44AddressKeyDeriver=n.deriveBIP44AddressKey=n.BIP44CoinTypeNode=n.BIP_44_COIN_TYPE_DEPTH=void 0;const a=e("./BIP44Node.cjs"),o=e("./constants.cjs"),c=e("./SLIP10Node.cjs"),u=e("./utils.cjs");n.BIP_44_COIN_TYPE_DEPTH=2;class l{static async fromJSON(e,t,n){m(t),d(e.depth);const r=await a.BIP44Node.fromExtendedKey({depth:e.depth,index:e.index,network:e.network,parentFingerprint:e.parentFingerprint,chainCode:(0,u.hexStringToBytes)(e.chainCode),privateKey:(0,u.nullableHexStringToBytes)(e.privateKey),publicKey:(0,u.hexStringToBytes)(e.publicKey)},n);return new l(r,t)}static async fromDerivationPath(e,t,n){d(e.length-1);const r=await a.BIP44Node.fromDerivationPath({derivationPath:e,network:t},n),s=(0,u.getBIP44CoinType)(e);return new l(r,s)}static async fromSeed({derivationPath:e,network:t},n){d(e.length-1);const r=await a.BIP44Node.fromSeed({derivationPath:e,network:t},n),s=(0,u.getBIP44CoinType)(e);return new l(r,s)}static async fromNode(e,t){if(!(e instanceof a.BIP44Node))throw new Error("Invalid node: Expected an instance of BIP44Node.");return m(t),d(e.depth),Promise.resolve(new l(e,t))}constructor(e,t){r.set(this,void 0),s(this,r,e,"f"),this.coin_type=t,this.path=(0,u.getBIP44CoinTypePathString)(t),Object.freeze(this)}get depth(){return i(this,r,"f").depth}get privateKeyBytes(){return i(this,r,"f").privateKeyBytes}get publicKeyBytes(){return i(this,r,"f").publicKeyBytes}get chainCodeBytes(){return i(this,r,"f").chainCodeBytes}get privateKey(){return i(this,r,"f").privateKey}get publicKey(){return i(this,r,"f").publicKey}get compressedPublicKey(){return i(this,r,"f").compressedPublicKey}get compressedPublicKeyBytes(){return i(this,r,"f").compressedPublicKeyBytes}get chainCode(){return i(this,r,"f").chainCode}get address(){return i(this,r,"f").address}get masterFingerprint(){return i(this,r,"f").masterFingerprint}get parentFingerprint(){return i(this,r,"f").parentFingerprint}get fingerprint(){return i(this,r,"f").fingerprint}get index(){return i(this,r,"f").index}get network(){return i(this,r,"f").network}get curve(){return i(this,r,"f").curve}get extendedKey(){return i(this,r,"f").extendedKey}async deriveBIP44AddressKey({account:e=0,change:t=0,address_index:n}){return await i(this,r,"f").derive((0,u.getBIP44CoinTypeToAddressPathTuple)({account:e,change:t,address_index:n}))}toJSON(){return{...i(this,r,"f").toJSON(),coin_type:this.coin_type,path:this.path}}}function d(e){if(e!==n.BIP_44_COIN_TYPE_DEPTH)throw new Error(`Invalid depth: Coin type nodes must be of depth ${n.BIP_44_COIN_TYPE_DEPTH}. Received: "${e}"`)}function m(e){if("number"!=typeof e||!Number.isInteger(e)||e<0)throw new Error("Invalid coin type: The specified coin type must be a non-negative integer number.")}async function h(e,t){if(e instanceof l)return d(e.depth),e;if("string"==typeof e){const n=await a.BIP44Node.fromExtendedKey(e,t),r=await l.fromNode(n,n.index-o.BIP_32_HARDENED_OFFSET);return d(r.depth),r}return l.fromJSON(e,e.coin_type,t)}n.BIP44CoinTypeNode=l,r=new WeakMap,n.deriveBIP44AddressKey=async function(e,{account:t=0,change:n=0,address_index:r},s){const i=(0,u.getBIP44CoinTypeToAddressPathTuple)({account:t,change:n,address_index:r}),o=await h(e,s),l=await(0,c.deriveChildNode)({path:i,node:o},s);return new a.BIP44Node(l)},n.getBIP44AddressKeyDeriver=async function(e,t,n){const{account:r=0,change:s=0}=t??{},i=await h(e,n),o=(0,u.getHardenedBIP32NodeToken)(r),l=(0,u.getBIP32NodeToken)(s),d=async(e,t=!1)=>{const r=await(0,c.deriveChildNode)({path:[o,l,t?(0,u.getHardenedBIP32NodeToken)(e):(0,u.getUnhardenedBIP32NodeToken)(e)],node:i},n);return new a.BIP44Node(r)};return d.coin_type=i.coin_type,d.path=(0,u.getBIP44ChangePathString)(i.path,{account:r,change:s}),Object.freeze(d),d}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/BIP44CoinTypeNode.cjs"}],[1875,{"./SLIP10Node.cjs":1876,"./constants.cjs":1877,"./extended-keys.cjs":1891,"./utils.cjs":1894,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},i=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.validateBIP44Depth=n.BIP44Node=void 0;const a=e("@metamask/utils"),o=e("./constants.cjs"),c=e("./extended-keys.cjs"),u=e("./SLIP10Node.cjs"),l=e("./utils.cjs");class d{static async fromJSON(e,t){return d.fromExtendedKey(e,t)}static async fromExtendedKey(e,t){if("string"==typeof e){const n=(0,c.decodeExtendedKey)(e),{type:r,chainCode:s,depth:i,parentFingerprint:a,index:o,network:u}=n;if("private"===r){const{privateKey:e}=n;return d.fromExtendedKey({depth:i,parentFingerprint:a,index:o,network:u,privateKey:e,chainCode:s},t)}const{publicKey:l}=n;return d.fromExtendedKey({depth:i,parentFingerprint:a,index:o,network:u,publicKey:l,chainCode:s},t)}const{privateKey:n,publicKey:r,chainCode:s,depth:i,parentFingerprint:a,index:o,network:l}=e;m(i);const h=await u.SLIP10Node.fromExtendedKey({privateKey:n,publicKey:r,chainCode:s,depth:i,parentFingerprint:a,index:o,network:l,curve:"secp256k1"},t);return new d(h)}static async fromDerivationPath({derivationPath:e,network:t},n){m(e.length-1),h(e,o.MIN_BIP_44_DEPTH);const r=await u.SLIP10Node.fromDerivationPath({derivationPath:e,network:t,curve:"secp256k1"},n);return new d(r)}static async fromSeed({derivationPath:e,network:t},n){m(e.length-1),h(e,o.MIN_BIP_44_DEPTH);const r=await u.SLIP10Node.fromSeed({derivationPath:e,network:t,curve:"secp256k1"},n);return new d(r)}get depth(){return s(this,r,"f").depth}get privateKeyBytes(){return s(this,r,"f").privateKeyBytes}get publicKeyBytes(){return s(this,r,"f").publicKeyBytes}get chainCodeBytes(){return s(this,r,"f").chainCodeBytes}get privateKey(){return s(this,r,"f").privateKey}get publicKey(){return s(this,r,"f").publicKey}get compressedPublicKey(){return s(this,r,"f").compressedPublicKey}get compressedPublicKeyBytes(){return s(this,r,"f").compressedPublicKeyBytes}get chainCode(){return s(this,r,"f").chainCode}get address(){return s(this,r,"f").address}get masterFingerprint(){return s(this,r,"f").masterFingerprint}get parentFingerprint(){return s(this,r,"f").parentFingerprint}get fingerprint(){return s(this,r,"f").fingerprint}get index(){return s(this,r,"f").index}get network(){return s(this,r,"f").network}get extendedKey(){return s(this,r,"f").extendedKey}get curve(){return s(this,r,"f").curve}constructor(e){r.set(this,void 0),i(this,r,e,"f"),Object.freeze(this)}neuter(){const e=s(this,r,"f").neuter();return new d(e)}async derive(e){if(this.depth===o.MAX_BIP_44_DEPTH)throw new Error("Illegal operation: This HD tree node is already a leaf node.");m(this.depth+e.length),h(e,this.depth+1);const t=await s(this,r,"f").derive(e);return new d(t)}toJSON(){return{depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,privateKey:this.privateKey,publicKey:this.publicKey,chainCode:this.chainCode}}}function m(e){if((0,u.validateBIP32Depth)(e),e<o.MIN_BIP_44_DEPTH||e>o.MAX_BIP_44_DEPTH)throw new Error(`Invalid HD tree path depth: The depth must be a positive integer N such that 0 <= N <= 5. Received: "${e}"`)}function h(e,t){e.forEach((e,n)=>{const r=t+n;if(r!==o.MIN_BIP_44_DEPTH)switch((0,a.assert)("string"==typeof e),r){case 1:if(e!==o.BIP44PurposeNodeToken)throw new Error(`Invalid derivation path: The "purpose" node (depth 1) must be the string "${o.BIP44PurposeNodeToken}".`);break;case 2:if(!o.BIP_32_PATH_REGEX.test(e)||!(0,l.isHardened)(e))throw new Error('Invalid derivation path: The "coin_type" node (depth 2) must be a hardened BIP-32 node.');break;case 3:if(!o.BIP_32_PATH_REGEX.test(e)||!(0,l.isHardened)(e))throw new Error('Invalid derivation path: The "account" node (depth 3) must be a hardened BIP-32 node.');break;case 4:if(!o.BIP_32_PATH_REGEX.test(e))throw new Error('Invalid derivation path: The "change" node (depth 4) must be a BIP-32 node.');break;case o.MAX_BIP_44_DEPTH:if(!o.BIP_32_PATH_REGEX.test(e))throw new Error('Invalid derivation path: The "address_index" node (depth 5) must be a BIP-32 node.')}else if(!(e instanceof Uint8Array||o.BIP_39_PATH_REGEX.test(e)))throw new Error('Invalid derivation path: The "m" / seed node (depth 0) must be a BIP-39 node.')})}n.BIP44Node=d,r=new WeakMap,n.validateBIP44Depth=m}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/BIP44Node.cjs"}],[1876,{"./constants.cjs":1877,"./curves/index.cjs":1882,"./derivation.cjs":1884,"./derivers/bip32.cjs":1885,"./derivers/bip39.cjs":1886,"./extended-keys.cjs":1891,"./guard.cjs":1892,"./utils.cjs":1894,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},c=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n};Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildNode=n.validateRootIndex=n.validateMasterParentFingerprint=n.validateParentFingerprint=n.validateBIP32Depth=n.SLIP10Node=void 0;const u=e("@metamask/utils"),l=e("./constants.cjs"),d=e("./curves/index.cjs"),m=e("./derivation.cjs"),h=e("./derivers/bip32.cjs"),f=e("./derivers/bip39.cjs"),p=e("./extended-keys.cjs"),y=e("./guard.cjs"),g=e("./utils.cjs");class b{static async fromJSON(e,t){return r.fromExtendedKey(e,t)}static async fromExtendedKey(e,t){if("string"==typeof e){const n=(0,p.decodeExtendedKey)(e),{chainCode:s,depth:i,parentFingerprint:a,index:o}=n;if("private"===n.type){const{privateKey:e}=n;return r.fromExtendedKey({depth:i,parentFingerprint:a,index:o,privateKey:e,chainCode:s,curve:"secp256k1"},t)}const{publicKey:c}=n;return r.fromExtendedKey({depth:i,parentFingerprint:a,index:o,publicKey:c,chainCode:s,curve:"secp256k1"},t)}const{depth:n,masterFingerprint:i,parentFingerprint:a,index:c,network:m,privateKey:h,publicKey:f,chainCode:b,curve:T,guard:A}=e,C=(0,g.getBytes)(b,l.BYTES_KEY_LENGTH);(0,g.validateCurve)(T),v(n),(0,g.validateBIP32Index)(c),w(c,n),(0,g.validateNetwork)(m),k(a,n),E(i,a,n);const _=(0,d.getCurveByName)(T);if(h){const e=(0,g.getBytesUnsafe)(h,_.privateKeyLength);(0,u.assert)(_.isValidPrivateKey(e),`Invalid private key: Value is not a valid ${T} private key.`);const l=A===y.PUBLIC_KEY_GUARD&&f?(0,g.getBytes)(f,_.publicKeyLength):undefined;return new r({depth:n,masterFingerprint:i,parentFingerprint:a,index:c,network:m,chainCode:C,privateKey:e,publicKey:l,curve:T},t,o(this,r,"f",s))}if(f){const e=(0,g.getBytes)(f,_.publicKeyLength);return new r({depth:n,masterFingerprint:i,parentFingerprint:a,index:c,network:m,chainCode:C,publicKey:e,curve:T},t,o(this,r,"f",s))}throw new Error("Invalid options: Must provide either a private key or a public key.")}static async fromDerivationPath({derivationPath:e,network:t,curve:n},r){if((0,g.validateCurve)(n),!e)throw new Error("Invalid options: Must provide a derivation path.");if(0===e.length)throw new Error("Invalid derivation path: May not specify an empty derivation path.");const s=await(0,f.getDerivationPathWithSeed)({path:e,curve:n},r);return await(0,m.deriveKeyFromPath)({path:s,depth:e.length-1,network:t,curve:n},r)}static async fromSeed({derivationPath:e,network:t,curve:n},r){if((0,g.validateCurve)(n),"ed25519Bip32"===n)throw new Error('Invalid curve: The curve "ed25519Bip32" is not supported by the `fromSeed` function.');if(!e)throw new Error("Invalid options: Must provide a derivation path.");if(0===e.length)throw new Error("Invalid derivation path: May not specify an empty derivation path.");return await(0,m.deriveKeyFromPath)({path:e,depth:e.length-1,network:t,curve:n},r)}constructor({depth:e,masterFingerprint:t,parentFingerprint:n,index:l,network:d="mainnet",chainCode:m,privateKey:h,publicKey:f,curve:p},y={},g){i.set(this,void 0),a.set(this,void 0),(0,u.assert)(g===o(r,r,"f",s),"SLIP10Node can only be constructed using `SLIP10Node.fromJSON`, `SLIP10Node.fromExtendedKey`, `SLIP10Node.fromDerivationPath`, or `SLIP10Node.fromSeed`."),(0,u.assert)(h!==undefined||f!==undefined,"SLIP10Node requires either a private key or a public key to be set."),this.depth=e,this.masterFingerprint=t,this.parentFingerprint=n,this.index=l,this.network=d,this.chainCodeBytes=m,this.privateKeyBytes=h,this.curve=p,c(this,i,f,"f"),c(this,a,y,"f"),Object.freeze(this)}get chainCode(){return(0,u.bytesToHex)(this.chainCodeBytes)}get privateKey(){return this.privateKeyBytes?(0,u.bytesToHex)(this.privateKeyBytes):undefined}get publicKey(){return(0,u.bytesToHex)(this.publicKeyBytes)}get publicKeyBytes(){return o(this,i,"f")!==undefined||((0,u.assert)(this.privateKeyBytes,"Either a private key or public key is required."),c(this,i,(0,d.getCurveByName)(this.curve).getPublicKey(this.privateKeyBytes),"f")),o(this,i,"f")}get compressedPublicKeyBytes(){return(0,d.getCurveByName)(this.curve).compressPublicKey(this.publicKeyBytes)}get compressedPublicKey(){return(0,u.bytesToHex)(this.compressedPublicKeyBytes)}get address(){if("secp256k1"!==this.curve)throw new Error("Unable to get address for this node: Only secp256k1 is supported.");return(0,u.bytesToHex)((0,h.publicKeyToEthAddress)(this.publicKeyBytes))}get fingerprint(){return(0,g.getFingerprint)(this.compressedPublicKeyBytes,(0,d.getCurveByName)(this.curve).compressedPublicKeyLength)}get extendedKey(){(0,u.assert)("secp256k1"===this.curve,"Unable to get extended key for this node: Only secp256k1 is supported.");const e={depth:this.depth,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,chainCode:this.chainCodeBytes};return this.privateKeyBytes?(0,p.encodeExtendedKey)({...e,type:"private",privateKey:this.privateKeyBytes}):(0,p.encodeExtendedKey)({...e,type:"public",publicKey:this.publicKeyBytes})}neuter(){return new r({depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,chainCode:this.chainCodeBytes,publicKey:this.publicKeyBytes,curve:this.curve,network:this.network},o(this,a,"f"),o(r,r,"f",s))}async derive(e){return await T({path:e,node:this},o(this,a,"f"))}toJSON(){return{depth:this.depth,masterFingerprint:this.masterFingerprint,parentFingerprint:this.parentFingerprint,index:this.index,network:this.network,curve:this.curve,privateKey:this.privateKey,publicKey:this.publicKey,chainCode:this.chainCode}}}function v(e){if(!(0,g.isValidInteger)(e))throw new Error(`Invalid HD tree path depth: The depth must be a positive integer. Received: "${String(e)}".`)}function k(e,t){if(!(0,g.isValidInteger)(e))throw new Error(`Invalid parent fingerprint: The fingerprint must be a positive integer. Received: "${String(e)}".`);if(0===t&&0!==e)throw new Error(`Invalid parent fingerprint: The fingerprint of the root node must be 0. Received: "${String(e)}".`);if(t>0&&0===e)throw new Error(`Invalid parent fingerprint: The fingerprint of a child node must not be 0. Received: "${String(e)}".`)}function E(e,t,n){if(e&&n>=2&&e===t)throw new Error(`Invalid parent fingerprint: The fingerprint of a child node cannot be equal to the master fingerprint. Received: "${String(t)}".`)}function w(e,t){if(0===t&&0!==e)throw new Error(`Invalid index: The index of the root node must be 0. Received: "${String(e)}".`)}async function T({path:e,node:t},n){if(0===e.length)throw new Error("Invalid HD tree derivation path: Deriving a path of length 0 is not defined.");const r=t.depth+e.length;return v(r),await(0,m.deriveKeyFromPath)({path:e,node:t,depth:r},n)}n.SLIP10Node=b,r=b,i=new WeakMap,a=new WeakMap,s={value:Symbol("SLIP10Node.constructor")},n.validateBIP32Depth=v,n.validateParentFingerprint=k,n.validateMasterParentFingerprint=E,n.validateRootIndex=w,n.deriveChildNode=T}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/SLIP10Node.cjs"}],[1877,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BIP_32_HARDENED_OFFSET=n.BIP_39_PATH_REGEX=n.CIP_3_PATH_REGEX=n.SLIP_10_PATH_REGEX=n.BIP_32_PATH_REGEX=n.UNPREFIXED_BIP_32_PATH_REGEX=n.UNPREFIXED_PATH_REGEX=n.BIP44PurposeNodeToken=n.MAX_BIP_32_INDEX=n.MAX_UNHARDENED_BIP_32_INDEX=n.MAX_BIP_44_DEPTH=n.MIN_BIP_44_DEPTH=n.BYTES_KEY_LENGTH=void 0,n.BYTES_KEY_LENGTH=32,n.MIN_BIP_44_DEPTH=0,n.MAX_BIP_44_DEPTH=5,n.MAX_UNHARDENED_BIP_32_INDEX=2147483647,n.MAX_BIP_32_INDEX=4294967295,n.BIP44PurposeNodeToken="bip32:44'",n.UNPREFIXED_PATH_REGEX=/^\d+$/u,n.UNPREFIXED_BIP_32_PATH_REGEX=/^(?<index>\d+)'?$/u,n.BIP_32_PATH_REGEX=/^bip32:\d+'?$/u,n.SLIP_10_PATH_REGEX=/^slip10:\d+'?$/u,n.CIP_3_PATH_REGEX=/^cip3:\d+'?$/u,n.BIP_39_PATH_REGEX=/^bip39:([a-z]+){1}( [a-z]+){11,23}$/u,n.BIP_32_HARDENED_OFFSET=2147483648}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/constants.cjs"}],[1878,{"./utils.cjs":1894,"@noble/hashes/hmac":2703,"@noble/hashes/pbkdf2":2705,"@noble/hashes/ripemd160":2706,"@noble/hashes/sha256":2709,"@noble/hashes/sha3":2710,"@noble/hashes/sha512":2711},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.sha256=n.ripemd160=n.pbkdf2Sha512=n.keccak256=n.hmacSha512=void 0;const r=e("@noble/hashes/hmac"),s=e("@noble/hashes/pbkdf2"),i=e("@noble/hashes/ripemd160"),a=e("@noble/hashes/sha256"),o=e("@noble/hashes/sha3"),c=e("@noble/hashes/sha512"),u=e("./utils.cjs");n.hmacSha512=async function(e,t,n={}){if(n.hmacSha512)return await n.hmacSha512(e,t);if((0,u.isWebCryptoSupported)()){const n=await crypto.subtle.importKey("raw",e,{name:"HMAC",hash:"SHA-512"},!1,["sign"]),r=await crypto.subtle.sign("HMAC",n,t);return new Uint8Array(r)}return(0,r.hmac)(c.sha512,e,t)},n.keccak256=function(e){return(0,o.keccak_256)(e)},n.pbkdf2Sha512=async function(e,t,n,r,i={}){if(i.pbkdf2Sha512)return await i.pbkdf2Sha512(e,t,n,r);if((0,u.isWebCryptoSupported)()){const s=await crypto.subtle.importKey("raw",e,{name:"PBKDF2"},!1,["deriveBits"]),i=await crypto.subtle.deriveBits({name:"PBKDF2",salt:t,iterations:n,hash:{name:"SHA-512"}},s,8*r);return new Uint8Array(i)}return await(0,s.pbkdf2Async)(c.sha512,e,t,{c:n,dkLen:r})},n.ripemd160=function(e){return(0,i.ripemd160)(e)},n.sha256=function(e){return(0,a.sha256)(e)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/cryptography.cjs"}],[1879,{"./ed25519.cjs":1880,"./ed25519Bip32.cjs":1881,"./secp256k1.cjs":1883,"@noble/curves/abstract/modular":2692},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.mod=n.getCurveByName=n.curves=void 0;const a=i(e("./ed25519.cjs")),o=i(e("./ed25519Bip32.cjs")),c=i(e("./secp256k1.cjs"));n.curves={secp256k1:c,ed25519:a,ed25519Bip32:o},n.getCurveByName=function(e){return n.curves[e]};var u=e("@noble/curves/abstract/modular");Object.defineProperty(n,"mod",{enumerable:!0,get:function(){return u.mod}})}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/curve.cjs"}],[1880,{"@metamask/utils":2656,"@noble/curves/ed25519":2696},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.publicKeyLength=n.deriveUnhardenedKeys=n.isValidPrivateKey=n.secret=n.name=n.curve=void 0;const r=e("@metamask/utils"),s=e("@noble/curves/ed25519");n.curve=s.ed25519.CURVE,n.name="ed25519",n.secret=(0,r.stringToBytes)("ed25519 seed");n.isValidPrivateKey=e=>!0,n.deriveUnhardenedKeys=!1,n.publicKeyLength=33;n.getPublicKey=(()=>{let e=!1;return(t,n)=>{e||(s.ed25519.ExtendedPoint.BASE._setWindowSize(4),e=!0);const i=s.ed25519.getPublicKey(t);return(0,r.concatBytes)([new Uint8Array([0]),i])}})();n.publicAdd=(e,t)=>{throw new Error("Ed25519 does not support public key derivation.")};n.compressPublicKey=e=>e;n.decompressPublicKey=e=>e,n.privateKeyLength=32,n.masterNodeGenerationSpec="slip10",n.compressedPublicKeyLength=33}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/ed25519.cjs"}],[1881,{"@metamask/utils":2656,"@noble/curves/abstract/modular":2692,"@noble/curves/ed25519":2696},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.multiplyWithBase=n.bytesToNumberLE=n.publicKeyLength=n.deriveUnhardenedKeys=n.isValidPrivateKey=n.secret=n.name=n.curve=void 0;const r=e("@metamask/utils"),s=e("@noble/curves/abstract/modular"),i=e("@noble/curves/ed25519");function a(e,t){const n=e[t];return(0,r.assert)(n!==undefined,"Private key is too short."),n}n.curve=i.ed25519.CURVE,n.name="ed25519Bip32",n.secret=(0,r.stringToBytes)("");n.isValidPrivateKey=e=>!(7&a(e,0))&&(!(128&a(e,31))&&!(64&~a(e,31))),n.deriveUnhardenedKeys=!0,n.publicKeyLength=32;n.bytesToNumberLE=e=>(0,r.hexToBigInt)((0,r.bytesToHex)(Uint8Array.from(e).reverse()));n.multiplyWithBase=e=>{const t=(0,s.mod)((0,n.bytesToNumberLE)(e),n.curve.n);return i.ed25519.ExtendedPoint.BASE.multiply(t).toRawBytes()};n.getPublicKey=(e,t)=>(0,n.multiplyWithBase)(e.slice(0,32));n.publicAdd=(e,t)=>i.ed25519.ExtendedPoint.fromHex((0,r.remove0x)((0,r.bytesToHex)(e))).add(i.ed25519.ExtendedPoint.fromHex((0,r.remove0x)((0,r.bytesToHex)(t)))).toRawBytes();n.compressPublicKey=e=>e;n.decompressPublicKey=e=>e,n.privateKeyLength=64,n.masterNodeGenerationSpec="cip3",n.compressedPublicKeyLength=32}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/ed25519Bip32.cjs"}],[1882,{"./curve.cjs":1879,"./ed25519.cjs":1880,"./ed25519Bip32.cjs":1881,"./secp256k1.cjs":1883},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)},a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.ed25519Bip32=n.ed25519=n.secp256k1=void 0,i(e("./curve.cjs"),n),n.secp256k1=a(e("./secp256k1.cjs")),n.ed25519=a(e("./ed25519.cjs")),n.ed25519Bip32=a(e("./ed25519Bip32.cjs"))}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/index.cjs"}],[1883,{"../utils.cjs":1894,"@metamask/utils":2656,"@noble/curves/secp256k1":2697},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.compressedPublicKeyLength=n.masterNodeGenerationSpec=n.privateKeyLength=n.decompressPublicKey=n.compressPublicKey=n.publicAdd=n.getPublicKey=n.isValidPrivateKey=n.publicKeyLength=n.deriveUnhardenedKeys=n.secret=n.name=n.curve=void 0;const r=e("@metamask/utils"),s=e("@noble/curves/secp256k1"),i=e("../utils.cjs");n.curve=s.secp256k1.CURVE,n.name="secp256k1",n.secret=(0,r.stringToBytes)("Bitcoin seed"),n.deriveUnhardenedKeys=!0,n.publicKeyLength=65;n.isValidPrivateKey=e=>s.secp256k1.utils.isValidPrivateKey(e);n.getPublicKey=(()=>{let e=!1;return(t,n=!1)=>(e||(s.secp256k1.ProjectivePoint.BASE._setWindowSize(4),e=!0),s.secp256k1.getPublicKey(t,n))})();n.publicAdd=(e,t)=>{(0,r.assert)((0,i.isValidBytesKey)(t,32),"Invalid tweak: Tweak must be a non-zero 32-byte Uint8Array.");const n=s.secp256k1.ProjectivePoint.fromHex(e).add(s.secp256k1.ProjectivePoint.fromPrivateKey(t));return n.assertValidity(),n.toRawBytes(!1)};n.compressPublicKey=e=>s.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!0);n.decompressPublicKey=e=>s.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1),n.privateKeyLength=32,n.masterNodeGenerationSpec="slip10",n.compressedPublicKeyLength=33}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/curves/secp256k1.cjs"}],[1884,{"./BIP44CoinTypeNode.cjs":1874,"./BIP44Node.cjs":1875,"./SLIP10Node.cjs":1876,"./constants.cjs":1877,"./curves/index.cjs":1882,"./derivers/index.cjs":1888,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.validatePathSegment=n.deriveKeyFromPath=void 0;const r=e("@metamask/utils"),s=e("./BIP44CoinTypeNode.cjs"),i=e("./BIP44Node.cjs"),a=e("./constants.cjs"),o=e("./curves/index.cjs"),c=e("./derivers/index.cjs"),u=e("./SLIP10Node.cjs");function l(e,t,n){if(0===e.length)throw new Error("Invalid HD path segment: The segment must not be empty.");let s=!1;if(e.forEach((e,t)=>{if(0===t){if(s=e instanceof Uint8Array||a.BIP_39_PATH_REGEX.test(e),!(e instanceof Uint8Array||s||a.BIP_32_PATH_REGEX.test(e)||a.SLIP_10_PATH_REGEX.test(e)||a.CIP_3_PATH_REGEX.test(e)))throw d()}else if(e instanceof Uint8Array||!a.BIP_32_PATH_REGEX.test(e)&&!a.SLIP_10_PATH_REGEX.test(e)&&!a.CIP_3_PATH_REGEX.test(e))throw d()}),n===a.MIN_BIP_44_DEPTH&&(!s||1!==e.length))throw new Error(`Invalid HD path segment: The segment must consist of a single BIP-39 node for depths of ${a.MIN_BIP_44_DEPTH}. Received: "${String(e)}".`);if(!t&&!s)throw new Error("Invalid derivation parameters: Must specify parent key if the first node of the path segment is not a BIP-39 node.");if(t&&s)throw new Error("Invalid derivation parameters: May not specify parent key if the path segment starts with a BIP-39 node.");const i=s?e.slice(1):e;if(i.length>0){const e=i[0]?.split(":")[0];(0,r.assert)(e),(0,r.assert)(i.every(t=>t.startsWith(`${e}:`)),"Invalid HD path segment: Cannot mix 'bip32' and 'slip10' path segments.")}}function d(){return new Error("Invalid HD path segment: The path segment is malformed.")}n.deriveKeyFromPath=async function(e,t){const{path:n,depth:a=n.length}=e,m="node"in e?e.node:undefined,h="network"in e?e.network:m?.network,f="curve"in e?e.curve:m?.curve;if(m&&!(m instanceof u.SLIP10Node)&&!(m instanceof i.BIP44Node)&&!(m instanceof s.BIP44CoinTypeNode))throw new Error("Invalid arguments: Node must be a SLIP-10 node or a BIP-44 node when provided.");if(!f)throw new Error("Invalid arguments: Must specify either a parent node or curve.");return l(n,Boolean(m?.privateKey)||Boolean(m?.publicKey),a),await n.reduce(async(e,n,s)=>{const i=await e;if("string"==typeof n){const[e,s]=n.split(":");(0,r.assert)(e),(0,r.assert)(s),(0,r.assert)(function(e){return e in c.derivers}(e),`Unknown derivation type: "${e}".`);const a=c.derivers[e];return await a.deriveChildKey({path:s,node:i,curve:(0,o.getCurveByName)(f),network:h},t)}return(0,r.assert)(0===s,d()),await c.derivers.bip39.deriveChildKey({path:n,node:i,curve:(0,o.getCurveByName)(f),network:h},t)},Promise.resolve(m))},n.validatePathSegment=l}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivation.cjs"}],[1885,{"../constants.cjs":1877,"../cryptography.cjs":1878,"../curves/index.cjs":1882,"../utils.cjs":1894,"./shared.cjs":1889,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildKey=n.publicKeyToEthAddress=n.privateKeyToEthAddress=void 0;const r=e("@metamask/utils"),s=e("./shared.cjs"),i=e("../constants.cjs"),a=e("../cryptography.cjs"),o=e("../curves/index.cjs"),c=e("../utils.cjs");function u(e){return(0,r.assert)(e instanceof Uint8Array&&(0,c.isValidBytesKey)(e,o.secp256k1.publicKeyLength),"Invalid key: The key must be a 65-byte, non-zero Uint8Array."),(0,a.keccak256)(e.slice(1)).slice(-20)}async function l(e,t,n){const{childIndex:r,privateKey:i,publicKey:a,isHardened:o,chainCode:u,curve:l}=t;if((0,c.validateBIP32Index)(r+1),i){const e=await(0,s.deriveSecretExtension)({privateKey:i,publicKey:l.compressPublicKey(a),childIndex:r+1,isHardened:o,curve:l}),c=await(0,s.generateEntropy)({chainCode:u,extension:e},n);return{...t,childIndex:r+1,entropy:c}}const d=(0,s.derivePublicExtension)({parentPublicKey:a,childIndex:r+1}),m=await(0,s.generateEntropy)({chainCode:u,extension:d});return{...t,childIndex:r+1,entropy:m}}n.privateKeyToEthAddress=function(e){return(0,r.assert)(e instanceof Uint8Array&&(0,c.isValidBytesKey)(e,i.BYTES_KEY_LENGTH),"Invalid key: The key must be a 32-byte, non-zero Uint8Array."),u(o.secp256k1.getPublicKey(e,!1))},n.publicKeyToEthAddress=u,n.deriveChildKey=async function(e,t){return(0,r.assert)("secp256k1"===e.curve.name,"Invalid curve: Only secp256k1 is supported by BIP-32."),(0,s.deriveChildKey)(e,l,t)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/bip32.cjs"}],[1886,{"../SLIP10Node.cjs":1876,"../constants.cjs":1877,"../cryptography.cjs":1878,"../curves/index.cjs":1882,"../guard.cjs":1892,"../utils.cjs":1894,"@metamask/scure-bip39":2255,"@metamask/scure-bip39/dist/wordlists/english.js":2256,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.entropyToCip3MasterNode=n.createBip39KeyFromSeed=n.deriveChildKey=n.getDerivationPathWithSeed=n.multipathToBip39Mnemonic=n.bip39MnemonicToMultipath=n.mnemonicToSeed=void 0;const r=e("@metamask/scure-bip39"),s=e("@metamask/scure-bip39/dist/wordlists/english.js"),i=e("@metamask/utils"),a=e("../constants.cjs"),o=e("../cryptography.cjs"),c=e("../curves/index.cjs"),u=e("../guard.cjs"),l=e("../SLIP10Node.cjs"),d=e("../utils.cjs"),m=[12,15,18,21,24];function h(e){const t=e.split(" ");(0,i.assert)(m.includes(t.length),"Invalid mnemonic phrase: The mnemonic phrase must consist of 12, 15, 18, 21, or 24 words."),(0,i.assert)(t.every(e=>s.wordlist.includes(e)),"Invalid mnemonic phrase: The mnemonic phrase contains an unknown word.")}async function f(e,t="",n){const r=`mnemonic${t}`.normalize("NFKD");return await(0,o.pbkdf2Sha512)(function(e,t){if("string"==typeof e)return h(e),(0,i.stringToBytes)(e.normalize("NFKD"));const n=Array.from(new Uint16Array(e.buffer)).map(e=>t[e]).join(" ");return h(n),(0,i.stringToBytes)(n)}(e,s.wordlist),(0,i.stringToBytes)(r),2048,64,n)}function p(e){return e instanceof Uint8Array?e:((0,i.assert)(e.startsWith("bip39:"),'Invalid HD path segment: The BIP-39 path must start with "bip39:".'),e.slice(6))}async function y(e,t,n,r){(0,i.assert)(e.length>=16&&e.length<=64,"Invalid seed: The seed must be between 16 and 64 bytes long.");const s=await(0,o.hmacSha512)(t.secret,e,r),c=s.slice(0,a.BYTES_KEY_LENGTH),m=s.slice(a.BYTES_KEY_LENGTH);(0,i.assert)(t.isValidPrivateKey(c),"Invalid private key: The private key must greater than 0 and less than the curve order.");const h=t.getPublicKey(c,!1),f=(0,d.getFingerprint)(t.compressPublicKey(h),t.compressedPublicKeyLength);return l.SLIP10Node.fromExtendedKey({privateKey:c,publicKey:h,chainCode:m,masterFingerprint:f,network:n,depth:0,parentFingerprint:0,index:0,curve:t.name,guard:u.PUBLIC_KEY_GUARD},r)}async function g(e,t,n,r){(0,i.assert)(e.length>=16&&e.length<=64,"Invalid entropy: The entropy must be between 16 and 64 bytes long.");const s=await(0,o.pbkdf2Sha512)(t.secret,e,4096,96,r);s[0]&=248,s[31]&=31,s[31]|=64;const a=s.slice(0,t.privateKeyLength),c=s.slice(t.privateKeyLength);(0,i.assert)(t.isValidPrivateKey(a),"Invalid private key.");const m=t.getPublicKey(a,!1),h=(0,d.getFingerprint)(t.compressPublicKey(m),t.compressedPublicKeyLength);return l.SLIP10Node.fromExtendedKey({privateKey:a,publicKey:m,chainCode:c,masterFingerprint:h,network:n,depth:0,parentFingerprint:0,index:0,curve:t.name,guard:u.PUBLIC_KEY_GUARD},r)}n.mnemonicToSeed=f,n.bip39MnemonicToMultipath=function(e){return`bip39:${e.toLowerCase().trim()}`},n.multipathToBip39Mnemonic=p,n.getDerivationPathWithSeed=async function({path:e,curve:t},n){const[a,...o]=e,u=p(a),l=(0,c.getCurveByName)(t);switch(l.masterNodeGenerationSpec){case"slip10":return[await f(u,"",n),...o];case"cip3":return[(0,r.mnemonicToEntropy)(u,s.wordlist),...o];default:return(0,i.assertExhaustive)(l)}},n.deriveChildKey=async function({path:e,curve:t,network:n},r){switch((0,i.assert)(e instanceof Uint8Array,"Invalid path: The path must be a Uint8Array."),t.masterNodeGenerationSpec){case"slip10":return y(e,t,n,r);case"cip3":return g(e,t,n,r);default:throw new Error("Unsupported master node generation spec.")}},n.createBip39KeyFromSeed=y,n.entropyToCip3MasterNode=g}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/bip39.cjs"}],[1887,{"../SLIP10Node.cjs":1876,"../constants.cjs":1877,"../curves/index.cjs":1882,"../utils.cjs":1894,"./shared.cjs":1889,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildKey=n.derivePublicKey=n.deriveChainCode=n.derivePrivateKey=n.getKeyExtension=n.add=n.mod2Pow256=n.trunc28Mul8=n.padEnd32Bytes=n.bigIntToBytes=n.bytesToBigInt=n.toReversed=void 0;const r=e("@metamask/utils"),s=e("./shared.cjs"),i=e("../constants.cjs"),a=e("../curves/index.cjs"),o=e("../SLIP10Node.cjs"),c=e("../utils.cjs");n.toReversed=e=>e.slice().reverse();n.bytesToBigInt=e=>{const t=(0,n.toReversed)(e),s=(0,r.bytesToHex)(t);return BigInt(s)};n.bigIntToBytes=e=>{const t=e.toString(16);return(0,n.toReversed)((0,r.hexToBytes)(t))};n.padEnd32Bytes=e=>(0,r.concatBytes)([e,new Uint8Array(Math.max(32-e.length,0)).fill(0)]);n.trunc28Mul8=e=>{const t=(0,n.bytesToBigInt)(e.slice(0,28))*BigInt(8);return(0,n.padEnd32Bytes)((0,n.bigIntToBytes)(t))};n.mod2Pow256=e=>(0,n.padEnd32Bytes)((0,n.bigIntToBytes)((0,a.mod)((0,n.bytesToBigInt)(e),BigInt(2)**BigInt(256))));n.add=(e,t)=>{const r=(0,n.bytesToBigInt)(e)+(0,n.bytesToBigInt)(t);return(0,n.padEnd32Bytes)((0,n.bigIntToBytes)(r)).slice(0,32)};n.getKeyExtension=(e,t,n)=>(0,r.concatBytes)([new Uint8Array([e]),t,(0,c.numberToUint32)(n,!0)]);const u=2,l=0;n.derivePrivateKey=async({parentNode:e,childIndex:t,isHardened:a},o)=>{const c=a?(0,n.getKeyExtension)(l,e.privateKeyBytes,t+i.BIP_32_HARDENED_OFFSET):(0,n.getKeyExtension)(u,e.publicKeyBytes,t),d=await(0,s.generateEntropy)({chainCode:e.chainCodeBytes,extension:c},o),m=d.subarray(0,32),h=d.subarray(32),f=e.privateKeyBytes.subarray(0,32),p=e.privateKeyBytes.subarray(32),y=(0,n.add)((0,n.trunc28Mul8)(m),f),g=(0,n.add)(h,p);return(0,r.concatBytes)([y,g])};const d=3,m=1;n.deriveChainCode=async({parentNode:e,childIndex:t,isHardened:r},a)=>{const o=r?(0,n.getKeyExtension)(m,e.privateKeyBytes,t+i.BIP_32_HARDENED_OFFSET):(0,n.getKeyExtension)(d,e.publicKeyBytes,t);return(await(0,s.generateEntropy)({chainCode:e.chainCodeBytes,extension:o},a)).subarray(32)};const h=2;n.derivePublicKey=async({parentNode:e,childIndex:t,curve:r},i)=>{const a=(0,n.getKeyExtension)(h,e.publicKeyBytes,t),o=(await(0,s.generateEntropy)({chainCode:e.chainCodeBytes,extension:a},i)).slice(0,32),c=r.getPublicKey((0,n.trunc28Mul8)(o));return r.publicAdd(e.publicKeyBytes,c)},n.deriveChildKey=async function(e,t){const{curve:a,node:c,path:u}=e;(0,s.validateNode)(c);const{childIndex:l,isHardened:d}=(0,s.getValidatedPath)(u,c,a);if("ed25519Bip32"!==a.name||!c)throw new Error("Unsupported curve: Only ed25519Bip32 is supported by CIP3.");const m=l+(d?i.BIP_32_HARDENED_OFFSET:0),{privateKeyBytes:h,chainCodeBytes:f,publicKeyBytes:p,masterFingerprint:y,depth:g,fingerprint:b}=c;if(h){const e={privateKeyBytes:h,chainCodeBytes:f,publicKeyBytes:p},s=await(0,n.derivePrivateKey)({parentNode:e,childIndex:l,isHardened:d},t),i=await(0,n.deriveChainCode)({parentNode:e,childIndex:l,isHardened:d},t);return o.SLIP10Node.fromExtendedKey({privateKey:(0,r.bytesToHex)(s),chainCode:(0,r.bytesToHex)(i),masterFingerprint:y,depth:g+1,parentFingerprint:b,index:m,curve:a.name},t)}(0,r.assert)(!d,"Invalid parameters: Cannot derive hardened child keys without a private key.");const v={chainCodeBytes:f,publicKeyBytes:p},k=await(0,n.derivePublicKey)({parentNode:v,childIndex:l,isHardened:!1,curve:a},t),E=await(0,n.deriveChainCode)({parentNode:v,childIndex:l,isHardened:!1},t);return o.SLIP10Node.fromExtendedKey({publicKey:(0,r.bytesToHex)(k),chainCode:(0,r.bytesToHex)(E),masterFingerprint:y,depth:g+1,parentFingerprint:b,index:m,curve:a.name},t)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/cip3.cjs"}],[1888,{"./bip32.cjs":1885,"./bip39.cjs":1886,"./cip3.cjs":1887,"./slip10.cjs":1890},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&r(t,e,n);return s(t,e),t};Object.defineProperty(n,"__esModule",{value:!0}),n.mnemonicToSeed=n.createBip39KeyFromSeed=n.derivers=void 0;const a=i(e("./bip32.cjs")),o=i(e("./bip39.cjs")),c=i(e("./cip3.cjs")),u=i(e("./slip10.cjs"));n.derivers={bip32:a,bip39:o,slip10:u,cip3:c};var l=e("./bip39.cjs");Object.defineProperty(n,"createBip39KeyFromSeed",{enumerable:!0,get:function(){return l.createBip39KeyFromSeed}}),Object.defineProperty(n,"mnemonicToSeed",{enumerable:!0,get:function(){return l.mnemonicToSeed}})}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/index.cjs"}],[1889,{"../SLIP10Node.cjs":1876,"../constants.cjs":1877,"../cryptography.cjs":1878,"../curves/index.cjs":1882,"../guard.cjs":1892,"../utils.cjs":1894,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getValidatedPath=n.validateNode=n.generateEntropy=n.privateAdd=n.derivePublicChildKey=n.derivePublicExtension=n.deriveSecretExtension=n.deriveChildKey=void 0;const r=e("@metamask/utils"),s=e("../constants.cjs"),i=e("../cryptography.cjs"),a=e("../curves/index.cjs"),o=e("../guard.cjs"),c=e("../SLIP10Node.cjs"),u=e("../utils.cjs");async function l(e,t,n){const{privateKey:r,publicKey:i,entropy:a,childIndex:u,isHardened:d,depth:m,parentFingerprint:p,masterFingerprint:y,curve:g,network:b}=e;try{return r?await async function({entropy:e,privateKey:t,depth:n,masterFingerprint:r,parentFingerprint:i,childIndex:a,isHardened:u,curve:l,network:d},m){const h=a+(u?s.BIP_32_HARDENED_OFFSET:0),{privateKey:p,chainCode:y}=function({privateKey:e,entropy:t,curve:n}){const r=t.slice(0,32),s=t.slice(32);if("ed25519"===n.name)return{privateKey:r,chainCode:s};const i=f(e,r,n);return{privateKey:i,chainCode:s}}({privateKey:t,entropy:e,curve:l});return await c.SLIP10Node.fromExtendedKey({privateKey:p,chainCode:y,depth:n+1,masterFingerprint:r,parentFingerprint:i,index:h,curve:l.name,network:d,guard:o.PUBLIC_KEY_GUARD},m)}({entropy:a,privateKey:r,depth:m,masterFingerprint:y,parentFingerprint:p,childIndex:u,isHardened:d,curve:g,network:b},n):await h({entropy:a,publicKey:i,depth:m,masterFingerprint:y,parentFingerprint:p,childIndex:u,curve:g,network:b},n)}catch(r){return await l(await t(r,e,n),t,n)}}async function d({privateKey:e,publicKey:t,childIndex:n,isHardened:i,curve:a}){return i?(0,r.concatBytes)([new Uint8Array([0]),e,(0,u.numberToUint32)(n+s.BIP_32_HARDENED_OFFSET)]):((0,u.validateBytes)(t,a.compressedPublicKeyLength),m({parentPublicKey:t,childIndex:n}))}function m({parentPublicKey:e,childIndex:t}){return(0,r.concatBytes)([e,(0,u.numberToUint32)(t)])}async function h({entropy:e,publicKey:t,depth:n,masterFingerprint:r,parentFingerprint:s,childIndex:i,curve:a,network:o},u){const{publicKey:l,chainCode:d}=function({publicKey:e,entropy:t,curve:n}){const r=t.slice(0,32),s=t.slice(32);return{publicKey:n.publicAdd(e,r),chainCode:s}}({publicKey:t,entropy:e,curve:a});return await c.SLIP10Node.fromExtendedKey({publicKey:l,chainCode:d,depth:n+1,masterFingerprint:r,parentFingerprint:s,index:i,curve:a.name,network:o},u)}function f(e,t,n){(0,r.assert)((0,u.isValidBytesKey)(t,32),"Invalid tweak: Tweak must be a non-zero 32-byte Uint8Array.");const s=(0,r.bytesToBigInt)(e),i=(0,r.bytesToBigInt)(t);if(i>=n.curve.n)throw new Error("Invalid tweak: Tweak is larger than the curve order.");const o=(0,a.mod)(s+i,n.curve.n),c=(0,r.hexToBytes)(o.toString(16).padStart(64,"0"));if(!n.isValidPrivateKey(c))throw new Error("Invalid private key or tweak: The resulting private key is invalid.");return c}async function p({chainCode:e,extension:t},n){return await(0,i.hmacSha512)(e,t,n)}function y(e){(0,r.assert)(e,"Invalid parameters: Must specify a node to derive from.")}function g(e,t,n){!function(e,t,n){(0,r.assert)("string"==typeof e,"Invalid path: Must be a string.");const s=e.endsWith("'");(0,r.assert)(!s||t.privateKey,"Invalid parameters: Cannot derive hardened child keys without a private key."),(0,r.assert)(s||n.deriveUnhardenedKeys,`Invalid path: Cannot derive unhardened child keys with ${n.name}.`)}(e,t,n);const i=e.split("'")[0];(0,r.assert)(i);const a=parseInt(i,10);if(!s.UNPREFIXED_PATH_REGEX.test(i)||!Number.isInteger(a)||a<0||a>=s.BIP_32_HARDENED_OFFSET)throw new Error(`Invalid path: The index must be a non-negative decimal integer less than ${s.BIP_32_HARDENED_OFFSET}.`);return{childIndex:a,isHardened:e.includes("'")}}n.deriveChildKey=async function({path:e,node:t,curve:n,network:r},s,i){y(t);const{childIndex:a,isHardened:o}=g(e,t,n),c={chainCode:t.chainCodeBytes,childIndex:a,isHardened:o,depth:t.depth,parentFingerprint:t.fingerprint,masterFingerprint:t.masterFingerprint,curve:n,network:r};if(t.privateKeyBytes){const e=await d({privateKey:t.privateKeyBytes,get publicKey(){return t.compressedPublicKeyBytes},childIndex:a,isHardened:o,curve:n}),r=await p({chainCode:t.chainCodeBytes,extension:e},i);return await l({privateKey:t.privateKeyBytes,get publicKey(){return t.publicKeyBytes},entropy:r,...c},s,i)}const u=m({parentPublicKey:t.compressedPublicKeyBytes,childIndex:a}),h=await p({chainCode:t.chainCodeBytes,extension:u},i);return await l({publicKey:t.compressedPublicKeyBytes,entropy:h,...c},s,i)},n.deriveSecretExtension=d,n.derivePublicExtension=m,n.derivePublicChildKey=h,n.privateAdd=f,n.generateEntropy=p,n.validateNode=y,n.getValidatedPath=g}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/shared.cjs"}],[1890,{"../constants.cjs":1877,"../utils.cjs":1894,"./shared.cjs":1889,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.deriveChildKey=void 0;const r=e("@metamask/utils"),s=e("./shared.cjs"),i=e("../constants.cjs"),a=e("../utils.cjs");async function o(e,t,n){const{curve:o,isHardened:c,childIndex:u,entropy:l,chainCode:d}=t;if("ed25519"===o.name)throw e;const m=c?u+i.BIP_32_HARDENED_OFFSET:u,h=await(0,s.generateEntropy)({chainCode:d,extension:(0,r.concatBytes)([1,l.slice(32,64),(0,a.numberToUint32)(m)])},n);return{...t,entropy:h}}n.deriveChildKey=async function(e,t){return await(0,s.deriveChildKey)(e,o,t)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/derivers/slip10.cjs"}],[1891,{"./BIP44Node.cjs":1875,"./curves/secp256k1.cjs":1883,"./utils.cjs":1894,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.encodeExtendedKey=n.decodeExtendedKey=void 0;const r=e("@metamask/utils"),s=e("./BIP44Node.cjs"),i=e("./curves/secp256k1.cjs"),a=e("./utils.cjs"),o=76067358,c=76066276,u=70617039,l=70615956;n.decodeExtendedKey=e=>{const t=(0,a.decodeBase58check)(e);if(78!==t.length)throw new Error(`Invalid extended key: Expected a length of 78, got ${t.length}.`);const n=(0,r.createDataView)(t),d=n.getUint32(0,!1),{network:m,type:h}=function(e){switch(e){case o:return{type:"public",network:"mainnet"};case u:return{type:"public",network:"testnet"};case c:return{type:"private",network:"mainnet"};case l:return{type:"private",network:"testnet"};default:throw new Error("Invalid extended key: Expected a public (xpub) or private key (xprv) version.")}}(d),f=n.getUint8(4);(0,s.validateBIP44Depth)(f);const p=n.getUint32(5,!1),y=n.getUint32(9,!1),g=t.slice(13,45);if(!(0,a.isValidBytesKey)(g,32))throw new Error("Invalid extended key: Chain code must be a 32-byte non-zero byte array.");const b=t.slice(45,78);if(!(0,a.isValidBytesKey)(b,33))throw new Error("Invalid extended key: Key must be a 33-byte non-zero byte array.");const v=(0,r.createDataView)(b);if("public"===h){if(2!==v.getUint8(0)&&3!==v.getUint8(0))throw new Error("Invalid extended key: Public key must start with 0x02 or 0x03.");return{type:h,depth:f,parentFingerprint:p,index:y,network:m,chainCode:g,publicKey:(0,i.decompressPublicKey)(b)}}if(0!==v.getUint8(0))throw new Error("Invalid extended key: Private key must start with 0x00.");return{type:h,depth:f,parentFingerprint:p,index:y,network:m,chainCode:g,privateKey:b.slice(1)}};n.encodeExtendedKey=e=>{const{type:t,depth:n,parentFingerprint:s,index:d,network:m,chainCode:h}=e,f=new Uint8Array(78),p=(0,r.createDataView)(f),y=function(e,t){switch(e){case"mainnet":return"public"===t?o:c;case"testnet":return"public"===t?u:l;default:return(0,r.assertExhaustive)(e)}}(m,t);if(p.setUint32(0,y,!1),p.setUint8(4,n),p.setUint32(5,s,!1),p.setUint32(9,d,!1),f.set(h,13),"public"===t){const{publicKey:t}=e,n=(0,i.compressPublicKey)(t);f.set(n,45)}if("private"===t){const{privateKey:t}=e;f.set(t,46)}return(0,a.encodeBase58check)(f)}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/extended-keys.cjs"}],[1892,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PUBLIC_KEY_GUARD=void 0,n.PUBLIC_KEY_GUARD=Symbol("Public key guard. Do not export this from the module.")}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/guard.cjs"}],[1893,{"./BIP44CoinTypeNode.cjs":1874,"./BIP44Node.cjs":1875,"./SLIP10Node.cjs":1876,"./constants.cjs":1877,"./curves/index.cjs":1882,"./derivers/index.cjs":1888,"./utils.cjs":1894},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),n.mnemonicToSeed=n.createBip39KeyFromSeed=n.mnemonicPhraseToBytes=n.isValidBIP32PathSegment=n.getBIP44CoinTypeToAddressPathTuple=n.getBIP44AddressKeyDeriver=n.deriveBIP44AddressKey=n.BIP_44_COIN_TYPE_DEPTH=n.BIP44CoinTypeNode=n.ed25519Bip32=n.ed25519=n.secp256k1=n.SLIP10Node=n.BIP44Node=void 0;var i=e("./BIP44Node.cjs");Object.defineProperty(n,"BIP44Node",{enumerable:!0,get:function(){return i.BIP44Node}});var a=e("./SLIP10Node.cjs");Object.defineProperty(n,"SLIP10Node",{enumerable:!0,get:function(){return a.SLIP10Node}});var o=e("./curves/index.cjs");Object.defineProperty(n,"secp256k1",{enumerable:!0,get:function(){return o.secp256k1}}),Object.defineProperty(n,"ed25519",{enumerable:!0,get:function(){return o.ed25519}}),Object.defineProperty(n,"ed25519Bip32",{enumerable:!0,get:function(){return o.ed25519Bip32}});var c=e("./BIP44CoinTypeNode.cjs");Object.defineProperty(n,"BIP44CoinTypeNode",{enumerable:!0,get:function(){return c.BIP44CoinTypeNode}}),Object.defineProperty(n,"BIP_44_COIN_TYPE_DEPTH",{enumerable:!0,get:function(){return c.BIP_44_COIN_TYPE_DEPTH}}),Object.defineProperty(n,"deriveBIP44AddressKey",{enumerable:!0,get:function(){return c.deriveBIP44AddressKey}}),Object.defineProperty(n,"getBIP44AddressKeyDeriver",{enumerable:!0,get:function(){return c.getBIP44AddressKeyDeriver}}),s(e("./constants.cjs"),n);var u=e("./utils.cjs");Object.defineProperty(n,"getBIP44CoinTypeToAddressPathTuple",{enumerable:!0,get:function(){return u.getBIP44CoinTypeToAddressPathTuple}}),Object.defineProperty(n,"isValidBIP32PathSegment",{enumerable:!0,get:function(){return u.isValidBIP32PathSegment}}),Object.defineProperty(n,"mnemonicPhraseToBytes",{enumerable:!0,get:function(){return u.mnemonicPhraseToBytes}});var l=e("./derivers/index.cjs");Object.defineProperty(n,"createBip39KeyFromSeed",{enumerable:!0,get:function(){return l.createBip39KeyFromSeed}}),Object.defineProperty(n,"mnemonicToSeed",{enumerable:!0,get:function(){return l.mnemonicToSeed}})}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/index.cjs"}],[1894,{"./BIP44CoinTypeNode.cjs":1874,"./constants.cjs":1877,"./cryptography.cjs":1878,"./curves/index.cjs":1882,"@metamask/scure-bip39/dist/wordlists/english.js":2256,"@metamask/utils":2656,"@scure/base":2733},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.getBIP44CoinType=n.validateNetwork=n.isWebCryptoSupported=n.numberToUint32=n.validateCurve=n.mnemonicPhraseToBytes=n.getFingerprint=n.encodeBase58check=n.decodeBase58check=n.validateBytes=n.getBytesUnsafe=n.getBytes=n.isValidInteger=n.isValidBytesKey=n.nullableHexStringToBytes=n.hexStringToBytes=n.isHardened=n.isValidBIP32PathSegment=n.isValidBIP32Index=n.validateBIP32Index=n.getBIP32NodeToken=n.getUnhardenedBIP32NodeToken=n.getHardenedBIP32NodeToken=n.getBIP44CoinTypeToAddressPathTuple=n.getBIP44ChangePathString=n.getBIP44CoinTypePathString=void 0;const r=e("@metamask/scure-bip39/dist/wordlists/english.js"),s=e("@metamask/utils"),i=e("@scure/base"),a=e("./BIP44CoinTypeNode.cjs"),o=e("./constants.cjs"),c=e("./cryptography.cjs"),u=e("./curves/index.cjs");function l(e){return h(e),`${d(e)}'`}function d(e){return h(e),`bip32:${e}`}function m(e){if("number"==typeof e)return d(e);if(!e||!Number.isInteger(e.index)||"boolean"!=typeof e.hardened)throw new Error("Invalid BIP-32 index: Must be an object containing the index and whether it is hardened.");return e.hardened?l(e.index):d(e.index)}function h(e){if(!f(e))throw new Error("Invalid BIP-32 index: Must be a non-negative integer.")}function f(e){return g(e)&&e<=o.MAX_BIP_32_INDEX}function p(e){return e instanceof Uint8Array?e:(0,s.hexToBytes)(e)}function y(e,t){if(e.length!==t)return!1;for(const t of e)if(0!==t)return!0;return!1}function g(e){return"number"==typeof e&&Number.isInteger(e)&&e>=0}function b(e,t){if(!y(e,t))throw new Error(`Invalid value: Must be a non-zero ${t}-byte byte array.`)}n.getBIP44CoinTypePathString=function(e){return`m / ${o.BIP44PurposeNodeToken} / ${l(e)}`},n.getBIP44ChangePathString=function(e,t){return`${e} / ${l(t.account??0)} / ${m(t.change??0)}`},n.getBIP44CoinTypeToAddressPathTuple=function({account:e=0,change:t=0,address_index:n}){return[l(e),m(t),m(n)]},n.getHardenedBIP32NodeToken=l,n.getUnhardenedBIP32NodeToken=d,n.getBIP32NodeToken=m,n.validateBIP32Index=h,n.isValidBIP32Index=f,n.isValidBIP32PathSegment=function(e){if("string"!=typeof e)return!1;const t=e.match(o.UNPREFIXED_BIP_32_PATH_REGEX);if(void 0===t?.groups?.index)return!1;const n=parseInt(t.groups.index,10);return g(n)&&n<=o.MAX_UNHARDENED_BIP_32_INDEX},n.isHardened=function(e){return e.endsWith("'")},n.hexStringToBytes=p,n.nullableHexStringToBytes=function(e){return e!==undefined?p(e):undefined},n.isValidBytesKey=y,n.isValidInteger=g,n.getBytes=function(e,t){if(e instanceof Uint8Array)return b(e,t),e;if("string"==typeof e){const n=(0,s.hexToBytes)(e);return b(n,t),n}throw new Error("Invalid value: Expected an instance of Uint8Array or hexadecimal string.")},n.getBytesUnsafe=function e(t,n){if(t instanceof Uint8Array)return(0,s.assert)(t.length===n,`Invalid value: Must be a ${n}-byte byte array.`),t;if("string"==typeof t)return e((0,s.hexToBytes)(t),n);throw new Error("Invalid value: Expected an instance of Uint8Array or hexadecimal string.")},n.validateBytes=b;n.decodeBase58check=e=>{const t=(0,i.base58check)(c.sha256);try{return t.decode(e)}catch{throw new Error("Invalid extended key: Value is not base58-encoded, or the checksum is invalid.")}};n.encodeBase58check=e=>(0,i.base58check)(c.sha256).encode(e);n.getFingerprint=(e,t)=>{if(!y(e,t))throw new Error(`Invalid public key: The key must be a ${t}-byte, non-zero byte array.`);const n=(0,c.ripemd160)((0,c.sha256)(e));return(0,s.createDataView)(n).getUint32(0,!1)},n.mnemonicPhraseToBytes=function(e){const t=e.split(" ").map(e=>{const t=r.wordlist.indexOf(e);return(0,s.assert)(-1!==t,`Invalid mnemonic phrase: Unknown word "${e}".`),t});return new Uint8Array(new Uint16Array(t).buffer)},n.validateCurve=function(e){if(!e||"string"!=typeof e)throw new Error("Invalid curve: Must specify a curve.");if(!Object.keys(u.curves).includes(e))throw new Error(`Invalid curve: Only the following curves are supported: ${Object.keys(u.curves).join(", ")}.`)},n.numberToUint32=function(e,t=!1){const n=new Uint8Array(4);return(0,s.createDataView)(n).setUint32(0,e,t),n},n.isWebCryptoSupported=function(){return Boolean(globalThis.crypto?.subtle)},n.validateNetwork=function(e){if(e!==undefined){if("string"!=typeof e)throw new Error("Invalid network: Must be a string if specified.");if(!["mainnet","testnet"].includes(e))throw new Error('Invalid network: Must be either "mainnet" or "testnet" if specified.')}},n.getBIP44CoinType=function(e){const t=e[a.BIP_44_COIN_TYPE_DEPTH].split(":")[1]?.replace("'","");(0,s.assert)(t,"Invalid derivation path: Coin type is not specified.");const n=Number.parseInt(t,10);return(0,s.assert)(g(n),"Invalid derivation path: Coin type is not a valid integer."),n}}}},{package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules/@metamask/key-tree/dist/utils.cjs"}],[1895,{"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountOptionsStruct=n.KeyringAccountEntropyOptionsStruct=n.KeyringAccountEntropyPrivateKeyOptionsStruct=n.KeyringAccountEntropyMnemonicOptionsStruct=n.KeyringAccountEntropyTypeOption=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils");var a;!function(e){e.Mnemonic="mnemonic",e.PrivateKey="private-key"}(a||(n.KeyringAccountEntropyTypeOption=a={})),n.KeyringAccountEntropyMnemonicOptionsStruct=(0,s.object)({type:(0,s.literal)(`${a.Mnemonic}`),id:(0,s.string)(),derivationPath:(0,s.string)(),groupIndex:(0,s.number)()}),n.KeyringAccountEntropyPrivateKeyOptionsStruct=(0,s.object)({type:(0,s.literal)(`${a.PrivateKey}`)}),n.KeyringAccountEntropyOptionsStruct=(0,r.selectiveUnion)(e=>(0,i.isPlainObject)(e)&&e.type===a.PrivateKey?n.KeyringAccountEntropyPrivateKeyOptionsStruct:n.KeyringAccountEntropyMnemonicOptionsStruct),n.KeyringAccountOptionsStruct=(0,s.intersection)([(0,s.record)((0,s.string)(),i.JsonStruct),(0,r.type)({entropy:(0,r.exactOptional)(n.KeyringAccountEntropyOptionsStruct),exportable:(0,r.exactOptional)((0,s.boolean)())})])}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/account-options.cjs"}],[1896,{"./account-options.cjs":1895,"./caip.cjs":1900,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountStruct=n.AnyAccountType=n.TrxAccountType=n.SolAccountType=n.BtcAccountType=n.EthAccountType=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("./account-options.cjs"),a=e("./caip.cjs");var o,c,u,l,d;!function(e){e.Eoa="eip155:eoa",e.Erc4337="eip155:erc4337"}(o||(n.EthAccountType=o={})),function(e){e.P2pkh="bip122:p2pkh",e.P2sh="bip122:p2sh",e.P2wpkh="bip122:p2wpkh",e.P2tr="bip122:p2tr"}(c||(n.BtcAccountType=c={})),function(e){e.DataAccount="solana:data-account"}(u||(n.SolAccountType=u={})),function(e){e.Eoa="tron:eoa"}(l||(n.TrxAccountType=l={})),function(e){e.Account="any:account"}(d||(n.AnyAccountType=d={})),n.KeyringAccountStruct=(0,r.object)({id:r.AccountIdStruct,type:(0,s.enums)([`${o.Eoa}`,`${o.Erc4337}`,`${c.P2pkh}`,`${c.P2sh}`,`${c.P2wpkh}`,`${c.P2tr}`,`${u.DataAccount}`,`${l.Eoa}`,`${d.Account}`]),address:(0,s.string)(),scopes:(0,s.nonempty)((0,s.array)(a.CaipChainIdStruct)),options:i.KeyringAccountOptionsStruct,methods:(0,s.array)((0,s.string)())})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/account.cjs"}],[1897,{"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ResolvedAccountAddressStruct=void 0;const r=e("@metamask/superstruct"),s=e("@metamask/utils");n.ResolvedAccountAddressStruct=(0,r.object)({address:s.CaipAccountIdStruct})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/address.cjs"}],[1898,{"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AssetStruct=n.NonFungibleAssetStruct=n.FungibleAssetStruct=n.FungibleAssetAmountStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils");n.FungibleAssetAmountStruct=(0,r.object)({unit:(0,s.string)(),amount:r.StringNumberStruct}),n.FungibleAssetStruct=(0,r.object)({fungible:(0,s.literal)(!0),type:i.CaipAssetTypeStruct,...n.FungibleAssetAmountStruct.schema}),n.NonFungibleAssetStruct=(0,r.object)({fungible:(0,s.literal)(!1),id:i.CaipAssetIdStruct}),n.AssetStruct=(0,r.selectiveUnion)(e=>(0,i.isPlainObject)(e)&&!e.fungible?n.NonFungibleAssetStruct:n.FungibleAssetStruct)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/asset.cjs"}],[1899,{"@metamask/keyring-utils":1961,"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BalanceStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct");n.BalanceStruct=(0,r.object)({amount:r.StringNumberStruct,unit:(0,s.string)()})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/balance.cjs"}],[1900,{"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.CaipChainIdStruct=n.CaipAssetTypeOrIdStruct=n.CaipAssetTypeStruct=n.CaipAssetIdStruct=n.CaipAccountIdStruct=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"CaipAccountIdStruct",{enumerable:!0,get:function(){return r.CaipAccountIdStruct}}),Object.defineProperty(n,"CaipAssetIdStruct",{enumerable:!0,get:function(){return r.CaipAssetIdStruct}}),Object.defineProperty(n,"CaipAssetTypeStruct",{enumerable:!0,get:function(){return r.CaipAssetTypeStruct}}),Object.defineProperty(n,"CaipAssetTypeOrIdStruct",{enumerable:!0,get:function(){return r.CaipAssetTypeOrIdStruct}}),Object.defineProperty(n,"CaipChainIdStruct",{enumerable:!0,get:function(){return r.CaipChainIdStruct}})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/caip.cjs"}],[1901,{"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DerivationPathStruct=void 0;const r=e("@metamask/utils");n.DerivationPathStruct=(0,r.definePattern)("DerivationPath",/^m(?:\/\d+'?)+$/u)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/derivation.cjs"}],[1902,{"./caip.cjs":1900,"./derivation.cjs":1901,"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.DiscoveredAccountStruct=n.DiscoveredBip44AccountStruct=n.DiscoveredAccountType=void 0;const r=e("@metamask/superstruct"),s=e("./caip.cjs"),i=e("./derivation.cjs");var a;!function(e){e.Bip44="bip44"}(a||(n.DiscoveredAccountType=a={})),n.DiscoveredBip44AccountStruct=(0,r.object)({type:(0,r.literal)(`${a.Bip44}`),scopes:(0,r.array)(s.CaipChainIdStruct),derivationPath:i.DerivationPathStruct}),n.DiscoveredAccountStruct=n.DiscoveredBip44AccountStruct}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/discovery.cjs"}],[1903,{"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringAccountDataStruct=void 0;const r=e("@metamask/superstruct"),s=e("@metamask/utils");n.KeyringAccountDataStruct=(0,r.record)((0,r.string)(),s.JsonStruct)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/export.cjs"}],[1904,{"./account-options.cjs":1895,"./account.cjs":1896,"./address.cjs":1897,"./asset.cjs":1898,"./balance.cjs":1899,"./caip.cjs":1900,"./discovery.cjs":1902,"./export.cjs":1903,"./options.cjs":1905,"./pagination.cjs":1906,"./request.cjs":1907,"./response.cjs":1908,"./transaction.cjs":1909},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./account.cjs"),n),s(e("./account-options.cjs"),n),s(e("./address.cjs"),n),s(e("./asset.cjs"),n),s(e("./balance.cjs"),n),s(e("./caip.cjs"),n),s(e("./discovery.cjs"),n),s(e("./export.cjs"),n),s(e("./request.cjs"),n),s(e("./response.cjs"),n),s(e("./transaction.cjs"),n),s(e("./pagination.cjs"),n),s(e("./options.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/index.cjs"}],[1905,{"@metamask/keyring-utils":1961},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MetaMaskOptionsStruct=void 0;const r=e("@metamask/keyring-utils");n.MetaMaskOptionsStruct=(0,r.object)({metamask:(0,r.exactOptional)((0,r.object)({correlationId:r.UuidStruct}))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/options.cjs"}],[1906,{"@metamask/keyring-utils":1961,"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.PaginationStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct");n.PaginationStruct=(0,r.object)({limit:(0,s.number)(),next:(0,r.exactOptional)((0,s.nullable)((0,s.string)()))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/pagination.cjs"}],[1907,{"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringRequestStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils");n.KeyringRequestStruct=(0,r.object)({id:r.UuidStruct,scope:(0,s.string)(),account:r.UuidStruct,origin:(0,s.string)(),request:(0,r.object)({method:(0,s.string)(),params:(0,r.exactOptional)((0,s.union)([(0,s.array)(i.JsonStruct),(0,s.record)((0,s.string)(),i.JsonStruct)]))})})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/request.cjs"}],[1908,{"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringResponseStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils");n.KeyringResponseStruct=(0,s.union)([(0,r.object)({pending:(0,s.literal)(!0),redirect:(0,r.exactOptional)((0,r.object)({message:(0,r.exactOptional)((0,s.string)()),url:(0,r.exactOptional)((0,s.string)())}))}),(0,r.object)({pending:(0,s.literal)(!1),result:i.JsonStruct})])}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/response.cjs"}],[1909,{"./asset.cjs":1898,"./caip.cjs":1900,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TransactionsPageStruct=n.TransactionStruct=n.TransactionEventStruct=n.TransactionType=n.TransactionStatus=n.FeeType=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("./asset.cjs"),a=e("./caip.cjs"),o=(0,r.object)({address:(0,s.string)(),asset:(0,s.nullable)(i.AssetStruct)});var c;!function(e){e.Base="base",e.Priority="priority"}(c||(n.FeeType=c={}));const u=(0,r.object)({type:(0,s.enums)([`${c.Base}`,`${c.Priority}`]),asset:i.AssetStruct});var l,d;!function(e){e.Submitted="submitted",e.Unconfirmed="unconfirmed",e.Confirmed="confirmed",e.Failed="failed"}(l||(n.TransactionStatus=l={})),function(e){e.Send="send",e.Receive="receive",e.Swap="swap",e.BridgeSend="bridge:send",e.BridgeReceive="bridge:receive",e.Unknown="unknown"}(d||(n.TransactionType=d={})),n.TransactionEventStruct=(0,r.object)({status:(0,s.enums)([`${l.Submitted}`,`${l.Unconfirmed}`,`${l.Confirmed}`,`${l.Failed}`]),timestamp:(0,s.nullable)((0,s.number)())}),n.TransactionStruct=(0,r.object)({id:(0,s.string)(),chain:a.CaipChainIdStruct,account:r.UuidStruct,status:(0,s.enums)([`${l.Submitted}`,`${l.Unconfirmed}`,`${l.Confirmed}`,`${l.Failed}`]),timestamp:(0,s.nullable)((0,s.number)()),type:(0,s.enums)([`${d.Send}`,`${d.Receive}`,`${d.Swap}`,`${d.BridgeSend}`,`${d.BridgeReceive}`,`${d.Unknown}`]),from:(0,s.array)(o),to:(0,s.array)(o),fees:(0,s.array)(u),events:(0,s.array)(n.TransactionEventStruct)}),n.TransactionsPageStruct=(0,r.object)({data:(0,s.array)(n.TransactionStruct),next:(0,s.nullable)((0,s.string)())})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/api/transaction.cjs"}],[1910,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.BtcScope=void 0,function(e){e.Mainnet="bip122:000000000019d6689c085ae165831e93",e.Testnet="bip122:000000000933ea01ad0ee984209779ba",e.Testnet4="bip122:00000000da84f2bafbbc53dee25a72ae",e.Signet="bip122:00000008819873e925422c1ff0f99f7c",e.Regtest="bip122:regtest"}(r||(n.BtcScope=r={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/btc/constants.cjs"}],[1911,{"./constants.cjs":1910,"./types.cjs":1912},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./constants.cjs"),n),s(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/btc/index.cjs"}],[1912,{"../api/index.cjs":1904,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"bitcoin-address-validation":3506},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.BtcP2trAccountStruct=n.BtcP2wpkhAccountStruct=n.BtcP2shAccountStruct=n.BtcP2pkhAccountStruct=n.BtcMethod=n.BtcP2trAddressStruct=n.BtcP2wpkhAddressStruct=n.BtcP2shAddressStruct=n.BtcP2pkhAddressStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("bitcoin-address-validation"),a=e("../api/index.cjs"),o=(e,t)=>{try{return(0,i.getAddressInfo)(e).type===t||new Error(`Invalid ${t} address`)}catch(e){return new Error(`Failed to decode ${t} address: ${e.message}`)}};var c;n.BtcP2pkhAddressStruct=(0,s.refine)((0,s.string)(),"BtcP2pkhAddressStruct",e=>o(e,i.AddressType.p2pkh)),n.BtcP2shAddressStruct=(0,s.refine)((0,s.string)(),"BtcP2shAddressStruct",e=>o(e,i.AddressType.p2sh)),n.BtcP2wpkhAddressStruct=(0,s.refine)((0,s.string)(),"BtcP2wpkhAddressStruct",e=>o(e,i.AddressType.p2wpkh)),n.BtcP2trAddressStruct=(0,s.refine)((0,s.string)(),"BtcP2trAddressStruct",e=>o(e,i.AddressType.p2tr)),function(e){e.SignPsbt="signPsbt",e.ComputeFee="computeFee",e.FillPsbt="fillPsbt",e.BroadcastPsbt="broadcastPsbt",e.SendTransfer="sendTransfer",e.GetUtxo="getUtxo",e.ListUtxos="listUtxos",e.PublicDescriptor="publicDescriptor",e.SignMessage="signMessage"}(c||(n.BtcMethod=c={}));const u=(0,r.object)({...a.KeyringAccountStruct.schema,scopes:(0,s.nonempty)((0,s.array)(a.CaipChainIdStruct)),methods:(0,s.array)((0,s.enums)(Object.values(c)))});n.BtcP2pkhAccountStruct=(0,r.object)({...u.schema,address:n.BtcP2pkhAddressStruct,type:(0,s.literal)(`${a.BtcAccountType.P2pkh}`)}),n.BtcP2shAccountStruct=(0,r.object)({...u.schema,address:n.BtcP2shAddressStruct,type:(0,s.literal)(`${a.BtcAccountType.P2sh}`)}),n.BtcP2wpkhAccountStruct=(0,r.object)({...u.schema,address:n.BtcP2wpkhAddressStruct,type:(0,s.literal)(`${a.BtcAccountType.P2wpkh}`)}),n.BtcP2trAccountStruct=(0,r.object)({...u.schema,address:n.BtcP2trAddressStruct,type:(0,s.literal)(`${a.BtcAccountType.P2tr}`)})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/btc/types.cjs"}],[1913,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.EthScope=void 0,function(e){e.Eoa="eip155:0",e.Mainnet="eip155:1",e.Testnet="eip155:11155111"}(r||(n.EthScope=r={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/constants.cjs"}],[1914,{"./types.cjs":1915},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/erc4337/index.cjs"}],[1915,{"../types.cjs":1917,"@metamask/keyring-utils":1961},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.EthUserOperationPatchStruct=n.EthBaseUserOperationStruct=n.EthBaseTransactionStruct=n.EthUserOperationStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("../types.cjs");n.EthUserOperationStruct=(0,r.object)({sender:s.EthAddressStruct,nonce:s.EthUint256Struct,initCode:s.EthBytesStruct,callData:s.EthBytesStruct,callGasLimit:s.EthUint256Struct,verificationGasLimit:s.EthUint256Struct,preVerificationGas:s.EthUint256Struct,maxFeePerGas:s.EthUint256Struct,maxPriorityFeePerGas:s.EthUint256Struct,paymasterAndData:s.EthBytesStruct,signature:s.EthBytesStruct}),n.EthBaseTransactionStruct=(0,r.object)({to:s.EthAddressStruct,value:s.EthUint256Struct,data:s.EthBytesStruct}),n.EthBaseUserOperationStruct=(0,r.object)({nonce:s.EthUint256Struct,initCode:s.EthBytesStruct,callData:s.EthBytesStruct,gasLimits:(0,r.exactOptional)((0,r.object)({callGasLimit:s.EthUint256Struct,verificationGasLimit:s.EthUint256Struct,preVerificationGas:s.EthUint256Struct})),dummyPaymasterAndData:s.EthBytesStruct,dummySignature:s.EthBytesStruct,bundlerUrl:r.UrlStruct}),n.EthUserOperationPatchStruct=(0,r.object)({paymasterAndData:s.EthBytesStruct,callGasLimit:(0,r.exactOptional)(s.EthUint256Struct),verificationGasLimit:(0,r.exactOptional)(s.EthUint256Struct),preVerificationGas:(0,r.exactOptional)(s.EthUint256Struct)})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/erc4337/types.cjs"}],[1916,{"./constants.cjs":1913,"./erc4337/index.cjs":1914,"./types.cjs":1917,"./utils.cjs":1918},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./constants.cjs"),n),s(e("./erc4337/index.cjs"),n),s(e("./types.cjs"),n),s(e("./utils.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/index.cjs"}],[1917,{"../api/index.cjs":1904,"./index.cjs":1916,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.EthErc4337AccountStruct=n.EthEoaAccountStruct=n.EthMethod=n.EthUint256Struct=n.EthAddressStruct=n.EthBytesStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils"),a=e("./index.cjs"),o=e("../api/index.cjs");var c;n.EthBytesStruct=(0,i.definePattern)("EthBytes",/^0x[0-9a-f]*$/iu),n.EthAddressStruct=(0,i.definePattern)("EthAddress",/^0x[0-9a-f]{40}$/iu),n.EthUint256Struct=(0,i.definePattern)("EthUint256",/^0x([1-9a-f][0-9a-f]*|0)$/iu),function(e){e.PersonalSign="personal_sign",e.Sign="eth_sign",e.SignTransaction="eth_signTransaction",e.SignTypedDataV1="eth_signTypedData_v1",e.SignTypedDataV3="eth_signTypedData_v3",e.SignTypedDataV4="eth_signTypedData_v4",e.PrepareUserOperation="eth_prepareUserOperation",e.PatchUserOperation="eth_patchUserOperation",e.SignUserOperation="eth_signUserOperation"}(c||(n.EthMethod=c={})),n.EthEoaAccountStruct=(0,r.object)({...o.KeyringAccountStruct.schema,address:n.EthAddressStruct,type:(0,s.literal)(`${o.EthAccountType.Eoa}`),scopes:(0,s.nonempty)((0,s.array)((0,s.literal)(a.EthScope.Eoa))),methods:(0,s.array)((0,s.enums)([`${c.PersonalSign}`,`${c.Sign}`,`${c.SignTransaction}`,`${c.SignTypedDataV1}`,`${c.SignTypedDataV3}`,`${c.SignTypedDataV4}`]))}),n.EthErc4337AccountStruct=(0,r.object)({...o.KeyringAccountStruct.schema,address:n.EthAddressStruct,type:(0,s.literal)(`${o.EthAccountType.Erc4337}`),scopes:(0,s.nonempty)((0,s.array)(o.CaipChainIdStruct)),methods:(0,s.array)((0,s.enums)([`${c.PersonalSign}`,`${c.Sign}`,`${c.SignTypedDataV1}`,`${c.SignTypedDataV3}`,`${c.SignTypedDataV4}`,`${c.PrepareUserOperation}`,`${c.PatchUserOperation}`,`${c.SignUserOperation}`]))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/types.cjs"}],[1918,{"../api/index.cjs":1904},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isEvmAccountType=function(e){return e===r.EthAccountType.Eoa||e===r.EthAccountType.Erc4337};const r=e("../api/index.cjs")}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/eth/utils.cjs"}],[1919,{"./api/index.cjs":1904,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.AccountAssetListUpdatedEventStruct=n.AccountTransactionsUpdatedEventStruct=n.AccountBalancesUpdatedEventStruct=n.RequestRejectedEventStruct=n.RequestApprovedEventStruct=n.AccountDeletedEventStruct=n.AccountUpdatedEventStruct=n.AccountCreatedEventStruct=n.KeyringEvent=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils"),a=e("./api/index.cjs");var o;!function(e){e.AccountCreated="notify:accountCreated",e.AccountUpdated="notify:accountUpdated",e.AccountDeleted="notify:accountDeleted",e.RequestApproved="notify:requestApproved",e.RequestRejected="notify:requestRejected",e.AccountBalancesUpdated="notify:accountBalancesUpdated",e.AccountAssetListUpdated="notify:accountAssetListUpdated",e.AccountTransactionsUpdated="notify:accountTransactionsUpdated"}(o||(n.KeyringEvent=o={})),n.AccountCreatedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.AccountCreated}`),params:(0,r.object)({account:a.KeyringAccountStruct,accountNameSuggestion:(0,r.exactOptional)((0,s.string)()),displayConfirmation:(0,r.exactOptional)((0,s.boolean)()),displayAccountNameSuggestion:(0,r.exactOptional)((0,s.boolean)()),...a.MetaMaskOptionsStruct.schema})}),n.AccountUpdatedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.AccountUpdated}`),params:(0,r.object)({account:a.KeyringAccountStruct})}),n.AccountDeletedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.AccountDeleted}`),params:(0,r.object)({id:r.UuidStruct})}),n.RequestApprovedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.RequestApproved}`),params:(0,r.object)({id:r.UuidStruct,result:i.JsonStruct})}),n.RequestRejectedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.RequestRejected}`),params:(0,r.object)({id:r.UuidStruct})}),n.AccountBalancesUpdatedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.AccountBalancesUpdated}`),params:(0,r.object)({balances:(0,s.record)(r.AccountIdStruct,(0,s.record)(i.CaipAssetTypeStruct,a.FungibleAssetAmountStruct))})}),n.AccountTransactionsUpdatedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.AccountTransactionsUpdated}`),params:(0,r.object)({transactions:(0,s.record)(r.AccountIdStruct,(0,s.array)(a.TransactionStruct))})}),n.AccountAssetListUpdatedEventStruct=(0,r.object)({method:(0,s.literal)(`${o.AccountAssetListUpdated}`),params:(0,r.object)({assets:(0,s.record)(r.AccountIdStruct,(0,r.object)({added:(0,s.array)(i.CaipAssetTypeOrIdStruct),removed:(0,s.array)(i.CaipAssetTypeOrIdStruct)}))})})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/events.cjs"}],[1920,{"./api/index.cjs":1904,"./btc/index.cjs":1911,"./eth/index.cjs":1916,"./events.cjs":1919,"./rpc.cjs":1921,"./sol/index.cjs":1923,"./trx/index.cjs":1926},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./api/index.cjs"),n),s(e("./btc/index.cjs"),n),s(e("./sol/index.cjs"),n),s(e("./eth/index.cjs"),n),s(e("./trx/index.cjs"),n),s(e("./rpc.cjs"),n),s(e("./events.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/index.cjs"}],[1921,{"./api/index.cjs":1904,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.RejectRequestResponseStruct=n.RejectRequestRequestStruct=n.ApproveRequestResponseStruct=n.ApproveRequestRequestStruct=n.SubmitRequestResponseStruct=n.SubmitRequestRequestStruct=n.GetRequestResponseStruct=n.GetRequestRequestStruct=n.ListRequestsResponseStruct=n.ListRequestsRequestStruct=n.ExportAccountResponseStruct=n.ExportAccountRequestStruct=n.DeleteAccountResponseStruct=n.DeleteAccountRequestStruct=n.UpdateAccountResponseStruct=n.UpdateAccountRequestStruct=n.FilterAccountChainsResponseStruct=n.FilterAccountChainsStruct=n.ResolveAccountAddressResponseStruct=n.ResolveAccountAddressRequestStruct=n.GetAccountBalancesResponseStruct=n.GetAccountBalancesRequestStruct=n.ListAccountAssetsResponseStruct=n.ListAccountAssetsRequestStruct=n.ListAccountTransactionsResponseStruct=n.ListAccountTransactionsRequestStruct=n.DiscoverAccountsResponseStruct=n.DiscoverAccountsRequestStruct=n.CreateAccountResponseStruct=n.CreateAccountRequestStruct=n.GetAccountResponseStruct=n.GetAccountRequestStruct=n.ListAccountsResponseStruct=n.ListAccountsRequestStruct=n.KeyringRpcMethod=void 0,n.isKeyringRpcMethod=function(e){return Object.values(o).includes(e)};const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils"),a=e("./api/index.cjs");var o;!function(e){e.ListAccounts="keyring_listAccounts",e.GetAccount="keyring_getAccount",e.CreateAccount="keyring_createAccount",e.DiscoverAccounts="keyring_discoverAccounts",e.ListAccountAssets="keyring_listAccountAssets",e.ListAccountTransactions="keyring_listAccountTransactions",e.GetAccountBalances="keyring_getAccountBalances",e.ResolveAccountAddress="keyring_resolveAccountAddress",e.FilterAccountChains="keyring_filterAccountChains",e.UpdateAccount="keyring_updateAccount",e.DeleteAccount="keyring_deleteAccount",e.ExportAccount="keyring_exportAccount",e.ListRequests="keyring_listRequests",e.GetRequest="keyring_getRequest",e.SubmitRequest="keyring_submitRequest",e.ApproveRequest="keyring_approveRequest",e.RejectRequest="keyring_rejectRequest"}(o||(n.KeyringRpcMethod=o={}));const c={jsonrpc:(0,s.literal)("2.0"),id:(0,s.union)([(0,s.string)(),(0,s.number)(),(0,s.literal)(null)])};n.ListAccountsRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_listAccounts")}),n.ListAccountsResponseStruct=(0,s.array)(a.KeyringAccountStruct),n.GetAccountRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_getAccount"),params:(0,r.object)({id:r.UuidStruct})}),n.GetAccountResponseStruct=a.KeyringAccountStruct,n.CreateAccountRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_createAccount"),params:(0,r.object)({options:(0,s.record)((0,s.string)(),i.JsonStruct)})}),n.CreateAccountResponseStruct=a.KeyringAccountStruct,n.DiscoverAccountsRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_discoverAccounts"),params:(0,r.object)({scopes:(0,s.array)(a.CaipChainIdStruct),entropySource:(0,s.string)(),groupIndex:(0,s.number)()})}),n.DiscoverAccountsResponseStruct=(0,s.array)(a.DiscoveredAccountStruct),n.ListAccountTransactionsRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_listAccountTransactions"),params:(0,r.object)({id:r.UuidStruct,pagination:a.PaginationStruct})}),n.ListAccountTransactionsResponseStruct=a.TransactionsPageStruct,n.ListAccountAssetsRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_listAccountAssets"),params:(0,r.object)({id:r.UuidStruct})}),n.ListAccountAssetsResponseStruct=(0,s.array)(a.CaipAssetTypeOrIdStruct),n.GetAccountBalancesRequestStruct=(0,r.object)({...c,method:(0,s.literal)(`${o.GetAccountBalances}`),params:(0,r.object)({id:r.UuidStruct,assets:(0,s.array)(a.CaipAssetTypeStruct)})}),n.GetAccountBalancesResponseStruct=(0,s.record)(a.CaipAssetTypeStruct,a.BalanceStruct),n.ResolveAccountAddressRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_resolveAccountAddress"),params:(0,r.object)({scope:a.CaipChainIdStruct,request:r.JsonRpcRequestStruct})}),n.ResolveAccountAddressResponseStruct=(0,s.nullable)((0,r.object)({address:a.CaipAccountIdStruct})),n.FilterAccountChainsStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_filterAccountChains"),params:(0,r.object)({id:r.UuidStruct,chains:(0,s.array)((0,s.string)())})}),n.FilterAccountChainsResponseStruct=(0,s.array)((0,s.string)()),n.UpdateAccountRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_updateAccount"),params:(0,r.object)({account:a.KeyringAccountStruct})}),n.UpdateAccountResponseStruct=(0,s.literal)(null),n.DeleteAccountRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_deleteAccount"),params:(0,r.object)({id:r.UuidStruct})}),n.DeleteAccountResponseStruct=(0,s.literal)(null),n.ExportAccountRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_exportAccount"),params:(0,r.object)({id:r.UuidStruct})}),n.ExportAccountResponseStruct=a.KeyringAccountDataStruct,n.ListRequestsRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_listRequests")}),n.ListRequestsResponseStruct=(0,s.array)(a.KeyringRequestStruct),n.GetRequestRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_getRequest"),params:(0,r.object)({id:r.UuidStruct})}),n.GetRequestResponseStruct=a.KeyringRequestStruct,n.SubmitRequestRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_submitRequest"),params:a.KeyringRequestStruct}),n.SubmitRequestResponseStruct=a.KeyringResponseStruct,n.ApproveRequestRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_approveRequest"),params:(0,r.object)({id:r.UuidStruct,data:(0,s.record)((0,s.string)(),i.JsonStruct)})}),n.ApproveRequestResponseStruct=(0,s.literal)(null),n.RejectRequestRequestStruct=(0,r.object)({...c,method:(0,s.literal)("keyring_rejectRequest"),params:(0,r.object)({id:r.UuidStruct})}),n.RejectRequestResponseStruct=(0,s.literal)(null)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/rpc.cjs"}],[1922,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.SolScope=void 0,function(e){e.Devnet="solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1",e.Mainnet="solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp",e.Testnet="solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z"}(r||(n.SolScope=r={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/sol/constants.cjs"}],[1923,{"./constants.cjs":1922,"./types.cjs":1924},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./constants.cjs"),n),s(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/sol/index.cjs"}],[1924,{"../api/index.cjs":1904,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SolDataAccountStruct=n.SolMethod=n.SolAddressStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils"),a=e("../api/index.cjs");var o;n.SolAddressStruct=(0,i.definePattern)("SolAddress",/^[1-9A-HJ-NP-Za-km-z]{32,44}$/iu),function(e){e.SendAndConfirmTransaction="sendAndConfirmTransaction",e.SignAndSendTransaction="signAndSendTransaction",e.SignTransaction="signTransaction",e.SignMessage="signMessage",e.SignIn="signIn"}(o||(n.SolMethod=o={})),n.SolDataAccountStruct=(0,r.object)({...a.KeyringAccountStruct.schema,address:n.SolAddressStruct,type:(0,s.literal)(`${a.SolAccountType.DataAccount}`),scopes:(0,s.nonempty)((0,s.array)(a.CaipChainIdStruct)),methods:(0,s.array)((0,s.enums)(Object.values(o)))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/sol/types.cjs"}],[1925,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.TrxScope=void 0,function(e){e.Mainnet="tron:728126428",e.Nile="tron:3448148188",e.Shasta="tron:2494104990"}(r||(n.TrxScope=r={}))}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/trx/constants.cjs"}],[1926,{"./constants.cjs":1925,"./types.cjs":1927},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./constants.cjs"),n),s(e("./types.cjs"),n)}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/trx/index.cjs"}],[1927,{"../api/index.cjs":1904,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.TrxEoaAccountStruct=n.TrxMethod=n.TrxAddressStruct=void 0;const r=e("@metamask/keyring-utils"),s=e("@metamask/superstruct"),i=e("@metamask/utils"),a=e("../api/index.cjs");var o;n.TrxAddressStruct=(0,i.definePattern)("TrxAddress",/^T[1-9A-HJ-NP-Za-km-z]{33}$/iu),function(e){e.SignMessageV2="signMessageV2",e.VerifyMessageV2="verifyMessageV2"}(o||(n.TrxMethod=o={})),n.TrxEoaAccountStruct=(0,r.object)({...a.KeyringAccountStruct.schema,address:n.TrxAddressStruct,type:(0,s.literal)(`${a.TrxAccountType.Eoa}`),scopes:(0,s.nonempty)((0,s.array)(a.CaipChainIdStruct)),methods:(0,s.array)((0,s.enums)(Object.values(o)))})}}},{package:"@metamask/keyring-api",file:"node_modules/@metamask/keyring-api/dist/trx/types.cjs"}],[1928,{"./constants.cjs":1929,"@ethereumjs/util":551,"@metamask/base-controller":1145,"@metamask/browser-passworder":1185,"@metamask/eth-hd-keyring":1635,"@metamask/eth-sig-util":1764,"@metamask/eth-simple-keyring":1786,"@metamask/utils":2656,"async-mutex":3439,"ethereumjs-wallet":3883,lodash:4386,ulid:5178},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c,u,l,d,m,h,f,p,y,g,b,v,k,E,w,T,A,C,_,x,P,B,S,I,D,j,R,O,M,F,N,K,U,L,q=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),H=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),$=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&q(t,e,n);return H(t,e),t},G=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},V=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},W=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringController=n.getDefaultKeyringState=n.keyringBuilderFactory=n.SignTypedDataVersion=n.AccountImportStrategy=n.isCustodyKeyring=n.KeyringTypes=void 0;const z=e("@ethereumjs/util"),Y=e("@metamask/base-controller"),X=$(e("@metamask/browser-passworder")),J=e("@metamask/eth-hd-keyring"),Q=e("@metamask/eth-sig-util"),Z=W(e("@metamask/eth-simple-keyring")),ee=e("@metamask/utils"),te=e("async-mutex"),ne=$(e("ethereumjs-wallet")),re=e("lodash"),se=e("ulid"),ie=e("./constants.cjs"),ae="KeyringController";var oe;!function(e){e.simple="Simple Key Pair",e.hd="HD Key Tree",e.qr="QR Hardware Wallet Device",e.trezor="Trezor Hardware",e.oneKey="OneKey Hardware",e.ledger="Ledger Hardware",e.lattice="Lattice Hardware",e.snap="Snap Keyring"}(oe||(n.KeyringTypes=oe={}));var ce,ue;function le(e){const t=()=>new e;return t.type=e.type,t}n.isCustodyKeyring=e=>e.startsWith("Custody"),function(e){e.privateKey="privateKey",e.json="json"}(ce||(n.AccountImportStrategy=ce={})),function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(ue||(n.SignTypedDataVersion=ue={})),n.keyringBuilderFactory=le;const de=[le(Z.default),le(J.HdKeyring)];function me(e){if(!((0,ee.hasProperty)(e,"mnemonic")&&e.mnemonic instanceof Uint8Array))throw new Error("Can't get mnemonic bytes from keyring")}function he(e){if(!("importKey"in e&&"function"==typeof e.importKey&&"decryptWithKey"in e&&"function"==typeof e.decryptWithKey&&"encryptWithKey"in e&&"function"==typeof e.encryptWithKey))throw new Error(ie.KeyringControllerError.UnsupportedEncryptionKeyExport)}function fe(e){if("string"!=typeof e)throw new Error(ie.KeyringControllerError.WrongPasswordType);if(!e||!e.length)throw new Error(ie.KeyringControllerError.InvalidEmptyPassword)}async function pe({keyring:e,metadata:t}){const n=await e.getAccounts();return{type:e.type,accounts:n.map(ye),metadata:t}}function ye(e){return function(e){return(0,ee.isStrictHexString)(e.toLowerCase())&&(0,ee.isValidHexAddress)(e)}(e)?(0,Q.normalize)(e):e}n.getDefaultKeyringState=()=>({isUnlocked:!1,keyrings:[]});class ge extends Y.BaseController{constructor(e){const{encryptor:t=X,keyringBuilders:h,messenger:f,state:p}=e;super({name:ae,metadata:{vault:{persist:!0,anonymous:!1},isUnlocked:{persist:!1,anonymous:!0},keyrings:{persist:!1,anonymous:!1},encryptionKey:{persist:!1,anonymous:!1},encryptionSalt:{persist:!1,anonymous:!1}},messenger:f,state:{...(0,n.getDefaultKeyringState)(),...p}}),r.add(this),s.set(this,new te.Mutex),i.set(this,new te.Mutex),a.set(this,void 0),o.set(this,void 0),c.set(this,void 0),u.set(this,void 0),l.set(this,void 0),d.set(this,void 0),G(this,a,h?h.concat(de):de,"f"),G(this,o,t,"f"),G(this,u,[],"f"),G(this,l,[],"f"),G(this,c,Boolean(e.cacheEncryptionKey),"f"),V(this,c,"f")&&he(t),V(this,r,"m",m).call(this)}async addNewAccount(e){return V(this,r,"m",M).call(this),V(this,r,"m",F).call(this,async()=>{const t=this.getKeyringsByType("HD Key Tree")[0];if(!t)throw new Error("No HD keyring found");const n=await t.getAccounts();if(e&&n.length!==e){if(e>n.length)throw new Error("Account out of sequence");const t=n[e];if(!t)throw new Error(`Can't find account at index ${e}`);return t}const[s]=await t.addAccounts(1);return await V(this,r,"m",b).call(this),s})}async addNewAccountForKeyring(e,t){return V(this,r,"m",M).call(this),V(this,r,"m",F).call(this,async()=>{const n=await V(this,r,"m",_).call(this);if(t&&n.length!==t){if(t>n.length)throw new Error("Account out of sequence");const e=n[t];return(0,ee.assertIsStrictHexString)(e),e}await e.addAccounts(1);const s=(await V(this,r,"m",_).call(this)).find(e=>!n.includes(e));return(0,ee.assertIsStrictHexString)(s),s})}async createNewVaultAndRestore(e,t){return V(this,r,"m",F).call(this,async()=>{fe(e),await V(this,r,"m",g).call(this,e,{type:oe.hd,opts:{mnemonic:t,numberOfAccounts:1}})})}async createNewVaultAndKeychain(e){return V(this,r,"m",F).call(this,async()=>{(await V(this,r,"m",_).call(this)).length||await V(this,r,"m",g).call(this,e,{type:oe.hd})})}async addNewKeyring(e,t){return V(this,r,"m",M).call(this),V(this,r,"m",p).call(this,await V(this,r,"m",F).call(this,async()=>V(this,r,"m",P).call(this,e,t)))}async verifyPassword(e){if(!this.state.vault)throw new Error(ie.KeyringControllerError.VaultError);await V(this,o,"f").decrypt(e,this.state.vault)}isUnlocked(){return this.state.isUnlocked}async exportSeedPhrase(e,t){V(this,r,"m",M).call(this),await this.verifyPassword(e);const n=V(this,r,"m",f).call(this,t);if(!n)throw new Error("Keyring not found");return me(n),n.mnemonic}async exportAccount(e,t){await this.verifyPassword(e);const n=await this.getKeyringForAccount(t);if(!n.exportAccount)throw new Error(ie.KeyringControllerError.UnsupportedExportAccount);return await n.exportAccount(ye(t))}async getAccounts(){return V(this,r,"m",M).call(this),this.state.keyrings.reduce((e,t)=>e.concat(t.accounts),[])}async getEncryptionPublicKey(e,t){V(this,r,"m",M).call(this);const n=(0,Q.normalize)(e),s=await this.getKeyringForAccount(e);if(!s.getEncryptionPublicKey)throw new Error(ie.KeyringControllerError.UnsupportedGetEncryptionPublicKey);return await s.getEncryptionPublicKey(n,t)}async decryptMessage(e){V(this,r,"m",M).call(this);const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.decryptMessage)throw new Error(ie.KeyringControllerError.UnsupportedDecryptMessage);return n.decryptMessage(t,e.data)}async getKeyringForAccount(e){V(this,r,"m",M).call(this);const t=ye(e),n=await Promise.all(V(this,u,"f").map(async({keyring:e})=>Promise.all([e,e.getAccounts()]))),s=n.filter(e=>e[1].map(ye).includes(t));if(s.length&&s[0]?.length)return s[0][0];let i="";throw n.length?s.length||(i="There are keyrings, but none match the address"):i="There are no keyrings",new Error(`${ie.KeyringControllerError.NoKeyring}. Error info: ${i}`)}getKeyringsByType(e){return V(this,r,"m",M).call(this),V(this,u,"f").filter(({keyring:t})=>t.type===e).map(({keyring:e})=>e)}async persistAllKeyrings(){return V(this,r,"m",N).call(this,async()=>(V(this,r,"m",M).call(this),await V(this,r,"m",A).call(this),!0))}async importAccountWithStrategy(e,t){return V(this,r,"m",M).call(this),V(this,r,"m",F).call(this,async()=>{let n;switch(e){case ce.privateKey:const[r]=t;if(!r)throw new Error("Cannot import an empty key.");const s=(0,ee.add0x)(r);let i;try{i=(0,ee.hexToBytes)(s)}catch{throw new Error("Cannot import invalid private key.")}if(!(0,z.isValidPrivate)(i)||66!==(0,z.getBinarySize)(s))throw new Error("Cannot import invalid private key.");n=(0,ee.remove0x)(s);break;case ce.json:let a;const[o,c]=t;try{a=ne.thirdparty.fromEtherWallet(o,c)}catch(e){a=a||await ne.default.fromV3(o,c,!0)}n=(0,ee.bytesToHex)(a.getPrivateKey());break;default:throw new Error(`Unexpected import strategy: '${String(e)}'`)}const s=await V(this,r,"m",P).call(this,oe.simple,[n]);return(await s.getAccounts())[0]})}async removeAccount(e){V(this,r,"m",M).call(this),await V(this,r,"m",F).call(this,async()=>{const t=await this.getKeyringForAccount(e),n=0===this.state.keyrings.findIndex(t=>t.accounts.includes(e)),s=1===(await t.getAccounts()).length;if(n&&s)throw new Error(ie.KeyringControllerError.LastAccountInPrimaryKeyring);if(!t.removeAccount)throw new Error(ie.KeyringControllerError.UnsupportedRemoveAccount);t.removeAccount(e),s&&await V(this,r,"m",j).call(this)}),this.messagingSystem.publish(`${ae}:accountRemoved`,e)}async setLocked(){return V(this,r,"m",M).call(this),V(this,r,"m",N).call(this,async()=>{G(this,d,undefined,"f"),await V(this,r,"m",S).call(this),this.update(e=>{e.isUnlocked=!1,e.keyrings=[],delete e.encryptionKey,delete e.encryptionSalt}),this.messagingSystem.publish(`${ae}:lock`)})}async signMessage(e){if(V(this,r,"m",M).call(this),!e.data)throw new Error("Can't sign an empty message");const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.signMessage)throw new Error(ie.KeyringControllerError.UnsupportedSignMessage);return await n.signMessage(t,e.data)}async signEip7702Authorization(e){const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.signEip7702Authorization)throw new Error(ie.KeyringControllerError.UnsupportedSignEip7702Authorization);const{chainId:r,nonce:s}=e,i=(0,Q.normalize)(e.contractAddress);if(i===undefined)throw new Error(ie.KeyringControllerError.MissingEip7702AuthorizationContractAddress);return await n.signEip7702Authorization(t,[r,i,s])}async signPersonalMessage(e){V(this,r,"m",M).call(this);const t=(0,Q.normalize)(e.from),n=await this.getKeyringForAccount(t);if(!n.signPersonalMessage)throw new Error(ie.KeyringControllerError.UnsupportedSignPersonalMessage);const s=ye(e.data);return await n.signPersonalMessage(t,s)}async signTypedMessage(e,t){V(this,r,"m",M).call(this);try{if(![ue.V1,ue.V3,ue.V4].includes(t))throw new Error(`Unexpected signTypedMessage version: '${t}'`);const n=(0,Q.normalize)(e.from),r=await this.getKeyringForAccount(n);if(!r.signTypedData)throw new Error(ie.KeyringControllerError.UnsupportedSignTypedMessage);return await r.signTypedData(n,t!==ue.V1&&"string"==typeof e.data?JSON.parse(e.data):e.data,{version:t})}catch(e){throw new Error(`Keyring Controller signTypedMessage: ${e}`)}}async signTransaction(e,t,n){V(this,r,"m",M).call(this);const s=(0,Q.normalize)(t),i=await this.getKeyringForAccount(s);if(!i.signTransaction)throw new Error(ie.KeyringControllerError.UnsupportedSignTransaction);return await i.signTransaction(s,e,n)}async prepareUserOperation(e,t,n){V(this,r,"m",M).call(this);const s=(0,Q.normalize)(e),i=await this.getKeyringForAccount(s);if(!i.prepareUserOperation)throw new Error(ie.KeyringControllerError.UnsupportedPrepareUserOperation);return await i.prepareUserOperation(s,t,n)}async patchUserOperation(e,t,n){V(this,r,"m",M).call(this);const s=(0,Q.normalize)(e),i=await this.getKeyringForAccount(s);if(!i.patchUserOperation)throw new Error(ie.KeyringControllerError.UnsupportedPatchUserOperation);return await i.patchUserOperation(s,t,n)}async signUserOperation(e,t,n){V(this,r,"m",M).call(this);const s=(0,Q.normalize)(e),i=await this.getKeyringForAccount(s);if(!i.signUserOperation)throw new Error(ie.KeyringControllerError.UnsupportedSignUserOperation);return await i.signUserOperation(s,t,n)}changePassword(e){return V(this,r,"m",M).call(this),V(this,d,"f")===e?Promise.resolve():V(this,r,"m",F).call(this,async()=>{fe(e),G(this,d,e,"f"),V(this,c,"f")&&this.update(e=>{delete e.encryptionKey,delete e.encryptionSalt})})}async submitEncryptionKey(e,t){const{newMetadata:n}=await V(this,r,"m",N).call(this,async()=>{const n=await V(this,r,"m",T).call(this,undefined,e,t);return V(this,r,"m",O).call(this),n});try{await V(this,r,"m",N).call(this,async()=>{n&&await V(this,r,"m",A).call(this)})}catch(e){console.error("Failed to update vault during login:",e)}}async exportEncryptionKey(){return V(this,r,"m",M).call(this),await V(this,r,"m",U).call(this,async()=>{const{encryptionKey:e}=this.state;return function(e){if(!e)throw new Error(ie.KeyringControllerError.EncryptionKeyNotSet)}(e),e})}async submitPassword(e){const{newMetadata:t}=await V(this,r,"m",N).call(this,async()=>{const t=await V(this,r,"m",T).call(this,e);return V(this,r,"m",O).call(this),t});try{await V(this,r,"m",N).call(this,async()=>{(t||V(this,r,"m",C).call(this))&&await V(this,r,"m",A).call(this)})}catch(e){console.error("Failed to update vault during login:",e)}}async verifySeedPhrase(e){return V(this,r,"m",M).call(this),V(this,r,"m",U).call(this,async()=>V(this,r,"m",b).call(this,e))}async withKeyring(e,t,n={createIfMissing:!1}){return V(this,r,"m",M).call(this),V(this,r,"m",F).call(this,async()=>{let s;if("address"in e?s=await this.getKeyringForAccount(e.address):"type"in e?(s=this.getKeyringsByType(e.type)[e.index||0],!s&&n.createIfMissing&&(s=await V(this,r,"m",P).call(this,e.type,n.createWithData))):"id"in e&&(s=V(this,r,"m",h).call(this,e.id)),!s)throw new Error(ie.KeyringControllerError.KeyringNotFound);const i=await t({keyring:s,metadata:V(this,r,"m",p).call(this,s)});if(Object.is(i,s))throw new Error(ie.KeyringControllerError.UnsafeDirectKeyringAccess);return i})}async getAccountKeyringType(e){V(this,r,"m",M).call(this);return(await this.getKeyringForAccount(e)).type}}async function be(e,t){const n=await e.acquire();try{return await t({releaseLock:n})}finally{n()}}function ve(){return{id:(0,se.ulid)(),name:""}}n.KeyringController=ge,s=new WeakMap,i=new WeakMap,a=new WeakMap,o=new WeakMap,c=new WeakMap,u=new WeakMap,l=new WeakMap,d=new WeakMap,r=new WeakSet,m=function(){this.messagingSystem.registerActionHandler(`${ae}:signMessage`,this.signMessage.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:signEip7702Authorization`,this.signEip7702Authorization.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:signPersonalMessage`,this.signPersonalMessage.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:signTypedMessage`,this.signTypedMessage.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:decryptMessage`,this.decryptMessage.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:getEncryptionPublicKey`,this.getEncryptionPublicKey.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:getAccounts`,this.getAccounts.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:getKeyringsByType`,this.getKeyringsByType.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:getKeyringForAccount`,this.getKeyringForAccount.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:persistAllKeyrings`,this.persistAllKeyrings.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:prepareUserOperation`,this.prepareUserOperation.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:patchUserOperation`,this.patchUserOperation.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:signUserOperation`,this.signUserOperation.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:addNewAccount`,this.addNewAccount.bind(this)),this.messagingSystem.registerActionHandler(`${ae}:withKeyring`,this.withKeyring.bind(this))},h=function(e){return V(this,u,"f").find(({metadata:t})=>t.id===e)?.keyring},f=function(e){return e?V(this,r,"m",h).call(this,e):V(this,u,"f")[0]?.keyring},p=function(e){const t=V(this,u,"f").find(t=>t.keyring===e);if(!t)throw new Error(ie.KeyringControllerError.KeyringNotFound);return t.metadata},y=function(e){return V(this,a,"f").find(t=>t.type===e)},g=async function(e,t){if(V(this,r,"m",K).call(this),"string"!=typeof e)throw new TypeError(ie.KeyringControllerError.WrongPasswordType);this.update(e=>{delete e.encryptionKey,delete e.encryptionSalt}),G(this,d,e,"f"),await V(this,r,"m",S).call(this),await V(this,r,"m",x).call(this,t.type,t.opts),V(this,r,"m",O).call(this)},b=async function(e){V(this,r,"m",K).call(this);const t=V(this,r,"m",f).call(this,e);if(!t)throw new Error(ie.KeyringControllerError.KeyringNotFound);if(t.type!==oe.hd)throw new Error(ie.KeyringControllerError.UnsupportedVerifySeedPhrase);me(t);const n=t.mnemonic,s=await t.getAccounts();if(0===s.length)throw new Error("Cannot verify an empty keyring.");const i=V(this,r,"m",y).call(this,oe.hd)();await i.deserialize({mnemonic:n,numberOfAccounts:s.length});const a=await i.getAccounts();if(a.length!==s.length)throw new Error("Seed phrase imported incorrect number of accounts.");return a.forEach((e,t)=>{if(e.toLowerCase()!==s[t].toLowerCase())throw new Error("Seed phrase imported different accounts.")}),n},v=async function(){return Promise.all(V(this,u,"f").map(pe))},k=async function({includeUnsupported:e}={includeUnsupported:!0}){const t=await Promise.all(V(this,u,"f").map(async({keyring:e,metadata:t})=>({type:e.type,data:await e.serialize(),metadata:t})));return e&&t.push(...V(this,l,"f")),t},E=async function(){return{keyrings:await V(this,r,"m",k).call(this),password:V(this,d,"f")}},w=async function(e){await V(this,r,"m",S).call(this);const t=[];let n=!1;for(const s of e){const e=await V(this,r,"m",I).call(this,s);if(e){const{keyring:r,metadata:s}=e;t.push({keyring:r,metadata:s}),e.newMetadata&&(n=!0)}}return{keyrings:t,newMetadata:n}},T=async function(e,t,n){return V(this,r,"m",L).call(this,async()=>{const s=this.state.vault;if(!s)throw new Error(ie.KeyringControllerError.VaultError);let i;const a={};if(V(this,c,"f"))if(he(V(this,o,"f")),e){const t=await V(this,o,"f").decryptWithDetail(e,s);i=t.vault,G(this,d,e,"f"),a.encryptionKey=t.exportedKeyString,a.encryptionSalt=t.salt}else{const e=JSON.parse(s);if(n&&n!==e.salt)throw new Error(ie.KeyringControllerError.ExpiredCredentials);if(n=e.salt,"string"!=typeof t)throw new TypeError(ie.KeyringControllerError.WrongPasswordType);const r=await V(this,o,"f").importKey(t);i=await V(this,o,"f").decryptWithKey(r,e),a.encryptionKey=t,a.encryptionSalt=n}else{if("string"!=typeof e)throw new TypeError(ie.KeyringControllerError.WrongPasswordType);i=await V(this,o,"f").decrypt(e,s),G(this,d,e,"f")}if("object"!=typeof(u=i)||!Array.isArray(u)||!u.every(e=>e.type&&(0,ee.isValidJson)(e.data)))throw new Error(ie.KeyringControllerError.VaultDataError);var u;const{keyrings:l,newMetadata:m}=await V(this,r,"m",w).call(this,i),h=await V(this,r,"m",v).call(this);return this.update(e=>{e.keyrings=h,(a.encryptionKey||a.encryptionSalt)&&(e.encryptionKey=a.encryptionKey,e.encryptionSalt=a.encryptionSalt)}),{keyrings:l,newMetadata:m}})},A=function(){return V(this,r,"m",L).call(this,async()=>{await V(this,r,"m",R).call(this);const{encryptionKey:e,encryptionSalt:t,vault:n}=this.state,s=e&&n&&V(this,o,"f").isVaultUpdated?.(n);if(!V(this,d,"f")&&!e)throw new Error(ie.KeyringControllerError.MissingCredentials);const i=await V(this,r,"m",k).call(this);if(!i.some(e=>e.type===oe.hd))throw new Error(ie.KeyringControllerError.NoHdKeyring);const a={};if(V(this,c,"f")){if(he(V(this,o,"f")),s){const n=await V(this,o,"f").importKey(e),r=await V(this,o,"f").encryptWithKey(n,i);r.salt=t,a.vault=JSON.stringify(r)}else if(V(this,d,"f")){const{vault:e,exportedKeyString:t}=await V(this,o,"f").encryptWithDetail(V(this,d,"f"),i);a.vault=e,a.encryptionKey=t}}else fe(V(this,d,"f")),a.vault=await V(this,o,"f").encrypt(V(this,d,"f"),i);if(!a.vault)throw new Error(ie.KeyringControllerError.MissingVaultData);const u=await V(this,r,"m",v).call(this);return this.update(e=>{e.vault=a.vault,e.keyrings=u,a.encryptionKey&&(e.encryptionKey=a.encryptionKey,e.encryptionSalt=JSON.parse(a.vault).salt)}),!0})},C=function(){const{vault:e}=this.state;return!!(e&&V(this,d,"f")&&V(this,o,"f").isVaultUpdated)&&!V(this,o,"f").isVaultUpdated(e)},_=async function(e=[]){const t=V(this,u,"f").map(({keyring:e})=>e);return(await Promise.all([...t,...e].map(async e=>e.getAccounts()))).reduce((e,t)=>e.concat(t),[]).map(ye)},x=async function(e,t){V(this,r,"m",K).call(this);const n=await V(this,r,"m",P).call(this,e,t),[s]=await n.getAccounts();if(!s)throw new Error(ie.KeyringControllerError.NoFirstAccount);return s},P=async function(e,t){const n=await V(this,r,"m",B).call(this,e,t);return V(this,u,"f").push({keyring:n,metadata:ve()}),n},B=async function(e,t){V(this,r,"m",K).call(this);const n=V(this,r,"m",y).call(this,e);if(!n)throw new Error(`${ie.KeyringControllerError.NoKeyringBuilder}. Keyring type: ${e}`);const s=n();if(t&&await s.deserialize(t),s.init&&await s.init(),!(e!==oe.hd||(0,ee.isObject)(t)&&t.mnemonic)){if(!s.generateRandomMnemonic)throw new Error(ie.KeyringControllerError.UnsupportedGenerateRandomMnemonic);await s.generateRandomMnemonic(),await s.addAccounts(1)}return s},S=async function(){V(this,r,"m",K).call(this);for(const{keyring:e}of V(this,u,"f"))await V(this,r,"m",D).call(this,e);G(this,u,[],"f"),G(this,l,[],"f")},I=async function(e){V(this,r,"m",K).call(this);try{const{type:t,data:n,metadata:s}=e;let i=!1,a=s;const o=await V(this,r,"m",B).call(this,t,n);return await V(this,r,"m",R).call(this,[o]),a||(i=!0,a=ve()),V(this,u,"f").push({keyring:o,metadata:a}),{keyring:o,metadata:a,newMetadata:i}}catch(t){return console.error(t),V(this,l,"f").push(e),undefined}},D=async function(e){await(e.destroy?.())},j=async function(){V(this,r,"m",K).call(this);const e=[];await Promise.all(V(this,u,"f").map(async({keyring:t,metadata:n})=>{(await t.getAccounts()).length>0?e.push({keyring:t,metadata:n}):await V(this,r,"m",D).call(this,t)})),G(this,u,e,"f")},R=async function(e=[]){const t=await V(this,r,"m",_).call(this,e);if(new Set(t).size!==t.length)throw new Error(ie.KeyringControllerError.DuplicatedAccount)},O=function(){V(this,r,"m",K).call(this),this.update(e=>{e.isUnlocked=!0}),this.messagingSystem.publish(`${ae}:unlock`)},M=function(){if(!this.state.isUnlocked)throw new Error(ie.KeyringControllerError.ControllerLocked)},F=async function(e){return V(this,r,"m",N).call(this,async({releaseLock:t})=>{const n=JSON.stringify(await V(this,r,"m",E).call(this)),s=await e({releaseLock:t}),i=JSON.stringify(await V(this,r,"m",E).call(this));return(0,re.isEqual)(n,i)||await V(this,r,"m",A).call(this),s})},N=async function(e){return V(this,r,"m",U).call(this,async({releaseLock:t})=>{const n=await V(this,r,"m",k).call(this),s=V(this,d,"f");try{return await e({releaseLock:t})}catch(e){throw G(this,d,s,"f"),await V(this,r,"m",w).call(this,n),e}})},K=function(){if(!V(this,s,"f").isLocked())throw new Error(ie.KeyringControllerError.ControllerLockRequired)},U=async function(e){return be(V(this,s,"f"),e)},L=async function(e){return V(this,r,"m",K).call(this),be(V(this,i,"f"),e)},n.default=ge}}},{package:"@metamask/keyring-controller",file:"node_modules/@metamask/keyring-controller/dist/KeyringController.cjs"}],[1929,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringControllerError=void 0,function(e){e.NoKeyring="KeyringController - No keyring found",e.KeyringNotFound="KeyringController - Keyring not found.",e.UnsafeDirectKeyringAccess="KeyringController - Returning keyring instances is unsafe",e.WrongPasswordType="KeyringController - Password must be of type string.",e.InvalidEmptyPassword="KeyringController - Password cannot be empty.",e.NoFirstAccount="KeyringController - First Account not found.",e.DuplicatedAccount="KeyringController - The account you are trying to import is a duplicate",e.VaultError="KeyringController - Cannot unlock without a previous vault.",e.VaultDataError="KeyringController - The decrypted vault has an unexpected shape.",e.UnsupportedEncryptionKeyExport="KeyringController - The encryptor does not support encryption key export.",e.UnsupportedGenerateRandomMnemonic="KeyringController - The current keyring does not support the method generateRandomMnemonic.",e.UnsupportedExportAccount="`KeyringController - The keyring for the current address does not support the method exportAccount",e.UnsupportedRemoveAccount="`KeyringController - The keyring for the current address does not support the method removeAccount",e.UnsupportedSignTransaction="KeyringController - The keyring for the current address does not support the method signTransaction.",e.UnsupportedSignMessage="KeyringController - The keyring for the current address does not support the method signMessage.",e.UnsupportedSignPersonalMessage="KeyringController - The keyring for the current address does not support the method signPersonalMessage.",e.UnsupportedSignEip7702Authorization="KeyringController - The keyring for the current address does not support the method signEip7702Authorization.",e.UnsupportedGetEncryptionPublicKey="KeyringController - The keyring for the current address does not support the method getEncryptionPublicKey.",e.UnsupportedDecryptMessage="KeyringController - The keyring for the current address does not support the method decryptMessage.",e.UnsupportedSignTypedMessage="KeyringController - The keyring for the current address does not support the method signTypedMessage.",e.UnsupportedGetAppKeyAddress="KeyringController - The keyring for the current address does not support the method getAppKeyAddress.",e.UnsupportedExportAppKeyForAddress="KeyringController - The keyring for the current address does not support the method exportAppKeyForAddress.",e.UnsupportedPrepareUserOperation="KeyringController - The keyring for the current address does not support the method prepareUserOperation.",e.UnsupportedPatchUserOperation="KeyringController - The keyring for the current address does not support the method patchUserOperation.",e.UnsupportedSignUserOperation="KeyringController - The keyring for the current address does not support the method signUserOperation.",e.UnsupportedVerifySeedPhrase="KeyringController - The keyring does not support the method verifySeedPhrase.",e.MissingEip7702AuthorizationContractAddress="KeyringController - The EIP-7702 Authorization is invalid. No contract address provided.",e.NoAccountOnKeychain="KeyringController - The keychain doesn't have accounts.",e.ControllerLocked="KeyringController - The operation cannot be completed while the controller is locked.",e.MissingCredentials="KeyringController - Cannot persist vault without password and encryption key",e.MissingVaultData="KeyringController - Cannot persist vault without vault information",e.ExpiredCredentials="KeyringController - Encryption key and salt provided are expired",e.NoKeyringBuilder="KeyringController - No keyringBuilder found for keyring",e.DataType="KeyringController - Incorrect data type provided",e.NoHdKeyring="KeyringController - No HD Keyring found",e.ControllerLockRequired="KeyringController - attempt to update vault during a non mutually exclusive operation",e.LastAccountInPrimaryKeyring="KeyringController - Last account in primary keyring cannot be removed",e.EncryptionKeyNotSet="KeyringController - Encryption key not set"}(r||(n.KeyringControllerError=r={}))}}},{package:"@metamask/keyring-controller",file:"node_modules/@metamask/keyring-controller/dist/constants.cjs"}],[1930,{"./KeyringController.cjs":1928},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./KeyringController.cjs"),n)}}},{package:"@metamask/keyring-controller",file:"node_modules/@metamask/keyring-controller/dist/index.cjs"}],[1931,{"./v1.cjs":1932},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./v1.cjs"),n)}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/compatibility/index.cjs"}],[1932,{"@metamask/keyring-api":1920,"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.SubmitRequestResponseV1Struct=n.KeyringResponseV1Struct=n.KeyringRequestV1Struct=void 0,n.toKeyringRequestV1=function(e){const{origin:t,...n}=e;return n};const r=e("@metamask/keyring-api"),s=e("@metamask/superstruct");n.KeyringRequestV1Struct=(0,s.omit)(r.KeyringRequestStruct,["origin"]),n.KeyringResponseV1Struct=r.KeyringResponseStruct,n.SubmitRequestResponseV1Struct=n.KeyringResponseV1Struct}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/compatibility/v1.cjs"}],[1933,{"./compatibility/index.cjs":1931,"./types.cjs":1934,"./versions.cjs":1935},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./compatibility/index.cjs"),n),s(e("./types.cjs"),n),s(e("./versions.cjs"),n)}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/index.cjs"}],[1934,{"@metamask/keyring-api":1920,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.InternalAccountStruct=n.InternalAccountStructs=n.InternalTrxEoaAccountStruct=n.InternalSolDataAccountStruct=n.InternalBtcP2trAccountStruct=n.InternalBtcP2wpkhAccountStruct=n.InternalBtcP2shAccountStruct=n.InternalBtcP2pkhAccountStruct=n.InternalEthErc4337AccountStruct=n.InternalEthEoaAccountStruct=n.InternalAccountMetadataStruct=void 0;const r=e("@metamask/keyring-api"),s=e("@metamask/keyring-utils"),i=e("@metamask/superstruct");n.InternalAccountMetadataStruct=(0,s.object)({metadata:(0,s.object)({name:(0,i.string)(),nameLastUpdatedAt:(0,s.exactOptional)((0,i.number)()),snap:(0,s.exactOptional)((0,s.object)({id:(0,i.string)(),enabled:(0,i.boolean)(),name:(0,i.string)()})),lastSelected:(0,s.exactOptional)((0,i.number)()),importTime:(0,i.number)(),keyring:(0,s.object)({type:(0,i.string)()})})}),n.InternalEthEoaAccountStruct=(0,s.object)({...r.EthEoaAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalEthErc4337AccountStruct=(0,s.object)({...r.EthErc4337AccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2pkhAccountStruct=(0,s.object)({...r.BtcP2pkhAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2shAccountStruct=(0,s.object)({...r.BtcP2shAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2wpkhAccountStruct=(0,s.object)({...r.BtcP2wpkhAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalBtcP2trAccountStruct=(0,s.object)({...r.BtcP2trAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalSolDataAccountStruct=(0,s.object)({...r.SolDataAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalTrxEoaAccountStruct=(0,s.object)({...r.TrxEoaAccountStruct.schema,...n.InternalAccountMetadataStruct.schema}),n.InternalAccountStructs={[`${r.EthAccountType.Eoa}`]:n.InternalEthEoaAccountStruct,[`${r.EthAccountType.Erc4337}`]:n.InternalEthErc4337AccountStruct,[`${r.BtcAccountType.P2pkh}`]:n.InternalBtcP2pkhAccountStruct,[`${r.BtcAccountType.P2sh}`]:n.InternalBtcP2shAccountStruct,[`${r.BtcAccountType.P2wpkh}`]:n.InternalBtcP2wpkhAccountStruct,[`${r.BtcAccountType.P2tr}`]:n.InternalBtcP2trAccountStruct,[`${r.SolAccountType.DataAccount}`]:n.InternalSolDataAccountStruct,[`${r.TrxAccountType.Eoa}`]:n.InternalTrxEoaAccountStruct},n.InternalAccountStruct=(0,s.object)({...r.KeyringAccountStruct.schema,...n.InternalAccountMetadataStruct.schema})}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/types.cjs"}],[1935,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringVersion=void 0,function(e){e.V1="v1",e.V2="v2"}(r||(n.KeyringVersion=r={}))}}},{package:"@metamask/keyring-internal-api",file:"node_modules/@metamask/keyring-internal-api/dist/versions.cjs"}],[1936,{"@metamask/keyring-api":1920,"@metamask/keyring-internal-api":1933,"@metamask/keyring-snap-client":1941,"@metamask/keyring-utils":1961},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},u=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringInternalSnapClient=void 0;const l=e("@metamask/keyring-api"),d=e("@metamask/keyring-internal-api"),m=e("@metamask/keyring-snap-client"),h=e("@metamask/keyring-utils");class f{constructor(e,t,n,o){r.set(this,void 0),s.set(this,void 0),i.set(this,void 0),a.set(this,void 0),c(this,i,e,"f"),c(this,r,t,"f"),c(this,s,n,"f"),c(this,a,o,"f")}async send(e){return u(this,i,"f").call("SnapController:handleRequest",{snapId:u(this,r,"f"),origin:u(this,s,"f"),handler:u(this,a,"f"),request:e})}}r=new WeakMap,s=new WeakMap,i=new WeakMap,a=new WeakMap;class p extends m.KeyringClient{constructor({messenger:e,snapId:t="undefined",origin:n="metamask",handler:r="onKeyringRequest"}){super(new f(e,t,n,r)),o.set(this,void 0),c(this,o,e,"f")}withSnapId(e){return new p({messenger:u(this,o,"f"),snapId:e})}async submitRequestV1(e){return(0,h.strictMask)(await this.send({method:l.KeyringRpcMethod.SubmitRequest,params:e}),d.SubmitRequestResponseV1Struct)}}n.KeyringInternalSnapClient=p,o=new WeakMap}}},{package:"@metamask/keyring-internal-snap-client",file:"node_modules/@metamask/keyring-internal-snap-client/dist/KeyringInternalSnapClient.cjs"}],[1937,{"./KeyringInternalSnapClient.cjs":1936},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./KeyringInternalSnapClient.cjs"),n)}}},{package:"@metamask/keyring-internal-snap-client",file:"node_modules/@metamask/keyring-internal-snap-client/dist/index.cjs"}],[1938,{"@metamask/keyring-api":1920,"@metamask/keyring-utils":1961,"@metamask/superstruct":2562,uuid:1942},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringClient=void 0;const a=e("@metamask/keyring-api"),o=e("@metamask/keyring-utils"),c=e("@metamask/superstruct"),u=e("uuid");n.KeyringClient=class{constructor(e){r.set(this,void 0),s(this,r,e,"f")}async send(e){return i(this,r,"f").send({jsonrpc:"2.0",id:(0,u.v4)(),...e})}async listAccounts(){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.ListAccounts}),a.ListAccountsResponseStruct)}async getAccount(e){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.GetAccount,params:{id:e}}),a.GetAccountResponseStruct)}async getAccountBalances(e,t){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.GetAccountBalances,params:{id:e,assets:t}}),a.GetAccountBalancesResponseStruct)}async createAccount(e={}){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.CreateAccount,params:{options:e}}),a.CreateAccountResponseStruct)}async discoverAccounts(e,t,n){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.DiscoverAccounts,params:{scopes:e,entropySource:t,groupIndex:n}}),a.DiscoverAccountsResponseStruct)}async listAccountTransactions(e,t){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.ListAccountTransactions,params:{id:e,pagination:t}}),a.ListAccountTransactionsResponseStruct)}async listAccountAssets(e){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.ListAccountAssets,params:{id:e}}),a.ListAccountAssetsResponseStruct)}async resolveAccountAddress(e,t){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.ResolveAccountAddress,params:{scope:e,request:t}}),a.ResolveAccountAddressResponseStruct)}async filterAccountChains(e,t){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.FilterAccountChains,params:{id:e,chains:t}}),a.FilterAccountChainsResponseStruct)}async updateAccount(e){(0,c.assert)(await this.send({method:a.KeyringRpcMethod.UpdateAccount,params:{account:e}}),a.UpdateAccountResponseStruct)}async deleteAccount(e){(0,c.assert)(await this.send({method:a.KeyringRpcMethod.DeleteAccount,params:{id:e}}),a.DeleteAccountResponseStruct)}async exportAccount(e){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.ExportAccount,params:{id:e}}),a.ExportAccountResponseStruct)}async listRequests(){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.ListRequests}),a.ListRequestsResponseStruct)}async getRequest(e){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.GetRequest,params:{id:e}}),a.GetRequestResponseStruct)}async submitRequest(e){return(0,o.strictMask)(await this.send({method:a.KeyringRpcMethod.SubmitRequest,params:e}),a.SubmitRequestResponseStruct)}async approveRequest(e,t={}){(0,c.assert)(await this.send({method:a.KeyringRpcMethod.ApproveRequest,params:{id:e,data:t}}),a.ApproveRequestResponseStruct)}async rejectRequest(e){(0,c.assert)(await this.send({method:a.KeyringRpcMethod.RejectRequest,params:{id:e}}),a.RejectRequestResponseStruct)}},r=new WeakMap}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/KeyringClient.cjs"}],[1939,{"./KeyringClient.cjs":1938,"@metamask/keyring-api":1920},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringPublicClient=n.KeyringPublicRpcMethod=void 0;const a=e("@metamask/keyring-api"),o=e("./KeyringClient.cjs");n.KeyringPublicRpcMethod=[a.KeyringRpcMethod.CreateAccount,a.KeyringRpcMethod.GetAccount,a.KeyringRpcMethod.UpdateAccount,a.KeyringRpcMethod.DeleteAccount,a.KeyringRpcMethod.ExportAccount,a.KeyringRpcMethod.ListAccounts,a.KeyringRpcMethod.FilterAccountChains,a.KeyringRpcMethod.GetRequest,a.KeyringRpcMethod.ApproveRequest,a.KeyringRpcMethod.RejectRequest,a.KeyringRpcMethod.ListRequests];n.KeyringPublicClient=class{constructor(e){r.set(this,void 0),s(this,r,new o.KeyringClient(e),"f")}async createAccount(e){return i(this,r,"f").createAccount(e)}async deleteAccount(e){return i(this,r,"f").deleteAccount(e)}async listAccounts(){return i(this,r,"f").listAccounts()}async getAccount(e){return i(this,r,"f").getAccount(e)}async getRequest(e){return i(this,r,"f").getRequest(e)}async listRequests(){return i(this,r,"f").listRequests()}async updateAccount(e){return i(this,r,"f").updateAccount(e)}async approveRequest(e,t){return i(this,r,"f").approveRequest(e,t)}async rejectRequest(e){return i(this,r,"f").rejectRequest(e)}async filterAccountChains(e,t){return i(this,r,"f").filterAccountChains(e,t)}async exportAccount(e){return i(this,r,"f").exportAccount(e)}},r=new WeakMap}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/KeyringPublicClient.cjs"}],[1940,{"./KeyringPublicClient.cjs":1939},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},a=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.KeyringSnapRpcClient=n.SnapRpcSender=void 0;const o=e("./KeyringPublicClient.cjs");class c{constructor(e,t){r.set(this,void 0),s.set(this,void 0),i(this,r,e,"f"),i(this,s,t,"f")}async send(e){return a(this,s,"f").request({method:"wallet_invokeKeyring",params:{snapId:a(this,r,"f"),request:e}})}}n.SnapRpcSender=c,r=new WeakMap,s=new WeakMap;class u extends o.KeyringPublicClient{constructor(e,t){super(new c(e,t))}}n.KeyringSnapRpcClient=u}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/KeyringSnapRpcClient.cjs"}],[1941,{"./KeyringClient.cjs":1938,"./KeyringPublicClient.cjs":1939,"./KeyringSnapRpcClient.cjs":1940},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./KeyringClient.cjs"),n),s(e("./KeyringSnapRpcClient.cjs"),n),s(e("./KeyringPublicClient.cjs"),n)}}},{package:"@metamask/keyring-snap-client",file:"node_modules/@metamask/keyring-snap-client/dist/index.cjs"}],[1942,{"./nil.js":1945,"./parse.js":1946,"./stringify.js":1950,"./v1.js":1951,"./v3.js":1952,"./v4.js":1954,"./v5.js":1955,"./validate.js":1956,"./version.js":1957},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),Object.defineProperty(n,"NIL",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(n,"parse",{enumerable:!0,get:function(){return d.default}}),Object.defineProperty(n,"stringify",{enumerable:!0,get:function(){return l.default}}),Object.defineProperty(n,"v1",{enumerable:!0,get:function(){return r.default}}),Object.defineProperty(n,"v3",{enumerable:!0,get:function(){return s.default}}),Object.defineProperty(n,"v4",{enumerable:!0,get:function(){return i.default}}),Object.defineProperty(n,"v5",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(n,"validate",{enumerable:!0,get:function(){return u.default}}),Object.defineProperty(n,"version",{enumerable:!0,get:function(){return c.default}});var r=m(e("./v1.js")),s=m(e("./v3.js")),i=m(e("./v4.js")),a=m(e("./v5.js")),o=m(e("./nil.js")),c=m(e("./version.js")),u=m(e("./validate.js")),l=m(e("./stringify.js")),d=m(e("./parse.js"));function m(e){return e&&e.__esModule?e:{default:e}}}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/index.js"}],[1943,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e){return 14+(e+64>>>9<<4)+1}function s(e,t){const n=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(n>>16)<<16|65535&n}function i(e,t,n,r,i,a){return s((o=s(s(t,e),s(r,a)))<<(c=i)|o>>>32-c,n);var o,c}function a(e,t,n,r,s,a,o){return i(t&n|~t&r,e,t,s,a,o)}function o(e,t,n,r,s,a,o){return i(t&r|n&~r,e,t,s,a,o)}function c(e,t,n,r,s,a,o){return i(t^n^r,e,t,s,a,o)}function u(e,t,n,r,s,a,o){return i(n^(t|~r),e,t,s,a,o)}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var l=function(e){if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=new Uint8Array(t.length);for(let n=0;n<t.length;++n)e[n]=t.charCodeAt(n)}return function(e){const t=[],n=32*e.length,r="0123456789abcdef";for(let s=0;s<n;s+=8){const n=e[s>>5]>>>s%32&255,i=parseInt(r.charAt(n>>>4&15)+r.charAt(15&n),16);t.push(i)}return t}(function(e,t){e[t>>5]|=128<<t%32,e[r(t)-1]=t;let n=1732584193,i=-271733879,l=-1732584194,d=271733878;for(let t=0;t<e.length;t+=16){const r=n,m=i,h=l,f=d;n=a(n,i,l,d,e[t],7,-680876936),d=a(d,n,i,l,e[t+1],12,-389564586),l=a(l,d,n,i,e[t+2],17,606105819),i=a(i,l,d,n,e[t+3],22,-1044525330),n=a(n,i,l,d,e[t+4],7,-176418897),d=a(d,n,i,l,e[t+5],12,1200080426),l=a(l,d,n,i,e[t+6],17,-1473231341),i=a(i,l,d,n,e[t+7],22,-45705983),n=a(n,i,l,d,e[t+8],7,1770035416),d=a(d,n,i,l,e[t+9],12,-1958414417),l=a(l,d,n,i,e[t+10],17,-42063),i=a(i,l,d,n,e[t+11],22,-1990404162),n=a(n,i,l,d,e[t+12],7,1804603682),d=a(d,n,i,l,e[t+13],12,-40341101),l=a(l,d,n,i,e[t+14],17,-1502002290),i=a(i,l,d,n,e[t+15],22,1236535329),n=o(n,i,l,d,e[t+1],5,-165796510),d=o(d,n,i,l,e[t+6],9,-1069501632),l=o(l,d,n,i,e[t+11],14,643717713),i=o(i,l,d,n,e[t],20,-373897302),n=o(n,i,l,d,e[t+5],5,-701558691),d=o(d,n,i,l,e[t+10],9,38016083),l=o(l,d,n,i,e[t+15],14,-660478335),i=o(i,l,d,n,e[t+4],20,-405537848),n=o(n,i,l,d,e[t+9],5,568446438),d=o(d,n,i,l,e[t+14],9,-1019803690),l=o(l,d,n,i,e[t+3],14,-187363961),i=o(i,l,d,n,e[t+8],20,1163531501),n=o(n,i,l,d,e[t+13],5,-1444681467),d=o(d,n,i,l,e[t+2],9,-51403784),l=o(l,d,n,i,e[t+7],14,1735328473),i=o(i,l,d,n,e[t+12],20,-1926607734),n=c(n,i,l,d,e[t+5],4,-378558),d=c(d,n,i,l,e[t+8],11,-2022574463),l=c(l,d,n,i,e[t+11],16,1839030562),i=c(i,l,d,n,e[t+14],23,-35309556),n=c(n,i,l,d,e[t+1],4,-1530992060),d=c(d,n,i,l,e[t+4],11,1272893353),l=c(l,d,n,i,e[t+7],16,-155497632),i=c(i,l,d,n,e[t+10],23,-1094730640),n=c(n,i,l,d,e[t+13],4,681279174),d=c(d,n,i,l,e[t],11,-358537222),l=c(l,d,n,i,e[t+3],16,-722521979),i=c(i,l,d,n,e[t+6],23,76029189),n=c(n,i,l,d,e[t+9],4,-640364487),d=c(d,n,i,l,e[t+12],11,-421815835),l=c(l,d,n,i,e[t+15],16,530742520),i=c(i,l,d,n,e[t+2],23,-995338651),n=u(n,i,l,d,e[t],6,-198630844),d=u(d,n,i,l,e[t+7],10,1126891415),l=u(l,d,n,i,e[t+14],15,-1416354905),i=u(i,l,d,n,e[t+5],21,-57434055),n=u(n,i,l,d,e[t+12],6,1700485571),d=u(d,n,i,l,e[t+3],10,-1894986606),l=u(l,d,n,i,e[t+10],15,-1051523),i=u(i,l,d,n,e[t+1],21,-2054922799),n=u(n,i,l,d,e[t+8],6,1873313359),d=u(d,n,i,l,e[t+15],10,-30611744),l=u(l,d,n,i,e[t+6],15,-1560198380),i=u(i,l,d,n,e[t+13],21,1309151649),n=u(n,i,l,d,e[t+4],6,-145523070),d=u(d,n,i,l,e[t+11],10,-1120210379),l=u(l,d,n,i,e[t+2],15,718787259),i=u(i,l,d,n,e[t+9],21,-343485551),n=s(n,r),i=s(i,m),l=s(l,h),d=s(d,f)}return[n,i,l,d]}(function(e){if(0===e.length)return[];const t=8*e.length,n=new Uint32Array(r(t));for(let r=0;r<t;r+=8)n[r>>5]|=(255&e[r/8])<<r%32;return n}(e),8*e.length))};n.default=l}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/md5-browser.js"}],[1944,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};n.default=r}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/native-browser.js"}],[1945,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default="00000000-0000-0000-0000-000000000000"}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/nil.js"}],[1946,{"./validate.js":1956},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var i=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");let t;const n=new Uint8Array(16);return n[0]=(t=parseInt(e.slice(0,8),16))>>>24,n[1]=t>>>16&255,n[2]=t>>>8&255,n[3]=255&t,n[4]=(t=parseInt(e.slice(9,13),16))>>>8,n[5]=255&t,n[6]=(t=parseInt(e.slice(14,18),16))>>>8,n[7]=255&t,n[8]=(t=parseInt(e.slice(19,23),16))>>>8,n[9]=255&t,n[10]=(t=parseInt(e.slice(24,36),16))/1099511627776&255,n[11]=t/4294967296&255,n[12]=t>>>24&255,n[13]=t>>>16&255,n[14]=t>>>8&255,n[15]=255&t,n};n.default=i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/parse.js"}],[1947,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;n.default=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/regex.js"}],[1948,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){let r;Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(){if(!r&&(r="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto),!r))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return r(s)};const s=new Uint8Array(16)}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/rng-browser.js"}],[1949,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){function r(e,t,n,r){switch(e){case 0:return t&n^~t&r;case 1:case 3:return t^n^r;case 2:return t&n^t&r^n&r}}function s(e,t){return e<<t|e>>>32-t}Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var i=function(e){const t=[1518500249,1859775393,2400959708,3395469782],n=[1732584193,4023233417,2562383102,271733878,3285377520];if("string"==typeof e){const t=unescape(encodeURIComponent(e));e=[];for(let n=0;n<t.length;++n)e.push(t.charCodeAt(n))}else Array.isArray(e)||(e=Array.prototype.slice.call(e));e.push(128);const i=e.length/4+2,a=Math.ceil(i/16),o=new Array(a);for(let t=0;t<a;++t){const n=new Uint32Array(16);for(let r=0;r<16;++r)n[r]=e[64*t+4*r]<<24|e[64*t+4*r+1]<<16|e[64*t+4*r+2]<<8|e[64*t+4*r+3];o[t]=n}o[a-1][14]=8*(e.length-1)/Math.pow(2,32),o[a-1][14]=Math.floor(o[a-1][14]),o[a-1][15]=8*(e.length-1)&4294967295;for(let e=0;e<a;++e){const i=new Uint32Array(80);for(let t=0;t<16;++t)i[t]=o[e][t];for(let e=16;e<80;++e)i[e]=s(i[e-3]^i[e-8]^i[e-14]^i[e-16],1);let a=n[0],c=n[1],u=n[2],l=n[3],d=n[4];for(let e=0;e<80;++e){const n=Math.floor(e/20),o=s(a,5)+r(n,c,u,l)+d+t[n]+i[e]>>>0;d=l,l=u,u=s(c,30)>>>0,c=a,a=o}n[0]=n[0]+a>>>0,n[1]=n[1]+c>>>0,n[2]=n[2]+u>>>0,n[3]=n[3]+l>>>0,n[4]=n[4]+d>>>0}return[n[0]>>24&255,n[0]>>16&255,n[0]>>8&255,255&n[0],n[1]>>24&255,n[1]>>16&255,n[1]>>8&255,255&n[1],n[2]>>24&255,n[2]>>16&255,n[2]>>8&255,255&n[2],n[3]>>24&255,n[3]>>16&255,n[3]>>8&255,255&n[3],n[4]>>24&255,n[4]>>16&255,n[4]>>8&255,255&n[4]]};n.default=i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/sha1-browser.js"}],[1950,{"./validate.js":1956},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0,n.unsafeStringify=a;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};const i=[];for(let e=0;e<256;++e)i.push((e+256).toString(16).slice(1));function a(e,t=0){return i[e[t+0]]+i[e[t+1]]+i[e[t+2]]+i[e[t+3]]+"-"+i[e[t+4]]+i[e[t+5]]+"-"+i[e[t+6]]+i[e[t+7]]+"-"+i[e[t+8]]+i[e[t+9]]+"-"+i[e[t+10]]+i[e[t+11]]+i[e[t+12]]+i[e[t+13]]+i[e[t+14]]+i[e[t+15]]}var o=function(e,t=0){const n=a(e,t);if(!(0,s.default)(n))throw TypeError("Stringified UUID is invalid");return n};n.default=o}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/stringify.js"}],[1951,{"./rng.js":1948,"./stringify.js":1950},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./rng.js"))&&r.__esModule?r:{default:r},i=e("./stringify.js");let a,o,c=0,u=0;var l=function(e,t,n){let r=t&&n||0;const l=t||new Array(16);let d=(e=e||{}).node||a,m=e.clockseq!==undefined?e.clockseq:o;if(null==d||null==m){const t=e.random||(e.rng||s.default)();null==d&&(d=a=[1|t[0],t[1],t[2],t[3],t[4],t[5]]),null==m&&(m=o=16383&(t[6]<<8|t[7]))}let h=e.msecs!==undefined?e.msecs:Date.now(),f=e.nsecs!==undefined?e.nsecs:u+1;const p=h-c+(f-u)/1e4;if(p<0&&e.clockseq===undefined&&(m=m+1&16383),(p<0||h>c)&&e.nsecs===undefined&&(f=0),f>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");c=h,u=f,o=m,h+=122192928e5;const y=(1e4*(268435455&h)+f)%4294967296;l[r++]=y>>>24&255,l[r++]=y>>>16&255,l[r++]=y>>>8&255,l[r++]=255&y;const g=h/4294967296*1e4&268435455;l[r++]=g>>>8&255,l[r++]=255&g,l[r++]=g>>>24&15|16,l[r++]=g>>>16&255,l[r++]=m>>>8|128,l[r++]=255&m;for(let e=0;e<6;++e)l[r+e]=d[e];return t||(0,i.unsafeStringify)(l)};n.default=l}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v1.js"}],[1952,{"./md5.js":1943,"./v35.js":1953},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./v35.js")),s=i(e("./md5.js"));function i(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v3",48,s.default);n.default=a}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v3.js"}],[1953,{"./parse.js":1946,"./stringify.js":1950},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.URL=n.DNS=void 0,n.default=function(e,t,n){function r(e,r,a,o){var c;if("string"==typeof e&&(e=function(e){e=unescape(encodeURIComponent(e));const t=[];for(let n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t}(e)),"string"==typeof r&&(r=(0,i.default)(r)),16!==(null===(c=r)||void 0===c?void 0:c.length))throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");let u=new Uint8Array(16+e.length);if(u.set(r),u.set(e,r.length),u=n(u),u[6]=15&u[6]|t,u[8]=63&u[8]|128,a){o=o||0;for(let e=0;e<16;++e)a[o+e]=u[e];return a}return(0,s.unsafeStringify)(u)}try{r.name=e}catch(e){}return r.DNS=a,r.URL=o,r};var r,s=e("./stringify.js"),i=(r=e("./parse.js"))&&r.__esModule?r:{default:r};const a="6ba7b810-9dad-11d1-80b4-00c04fd430c8";n.DNS=a;const o="6ba7b811-9dad-11d1-80b4-00c04fd430c8";n.URL=o}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v35.js"}],[1954,{"./native.js":1944,"./rng.js":1948,"./stringify.js":1950},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=a(e("./native.js")),s=a(e("./rng.js")),i=e("./stringify.js");function a(e){return e&&e.__esModule?e:{default:e}}var o=function(e,t,n){if(r.default.randomUUID&&!t&&!e)return r.default.randomUUID();const a=(e=e||{}).random||(e.rng||s.default)();if(a[6]=15&a[6]|64,a[8]=63&a[8]|128,t){n=n||0;for(let e=0;e<16;++e)t[n+e]=a[e];return t}return(0,i.unsafeStringify)(a)};n.default=o}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v4.js"}],[1955,{"./sha1.js":1949,"./v35.js":1953},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r=i(e("./v35.js")),s=i(e("./sha1.js"));function i(e){return e&&e.__esModule?e:{default:e}}var a=(0,r.default)("v5",80,s.default);n.default=a}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/v5.js"}],[1956,{"./regex.js":1947},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./regex.js"))&&r.__esModule?r:{default:r};var i=function(e){return"string"==typeof e&&s.default.test(e)};n.default=i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/validate.js"}],[1957,{"./validate.js":1956},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var r,s=(r=e("./validate.js"))&&r.__esModule?r:{default:r};var i=function(e){if(!(0,s.default)(e))throw TypeError("Invalid UUID");return parseInt(e.slice(14,15),16)};n.default=i}}},{package:"@metamask/keyring-snap-client>uuid",file:"node_modules/@metamask/keyring-snap-client/node_modules/uuid/dist/version.js"}],[1958,{"./index.cjs":1961,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.JsonRpcRequestStruct=void 0;const r=e("@metamask/superstruct"),s=e("@metamask/utils"),i=e("./index.cjs");n.JsonRpcRequestStruct=(0,i.object)({jsonrpc:(0,r.literal)("2.0"),id:(0,r.union)([(0,r.string)(),(0,r.number)(),(0,r.literal)(null)]),method:(0,r.string)(),params:(0,i.exactOptional)((0,r.union)([(0,r.array)(s.JsonStruct),(0,r.record)((0,r.string)(),s.JsonStruct)]))})}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/JsonRpcRequest.cjs"}],[1959,{"bitcoin-address-validation":3506},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isBtcMainnetAddress=function(e){return(0,r.validate)(e,r.Network.mainnet)},n.isBtcTestnetAddress=function(e){return(0,r.validate)(e,r.Network.testnet)};const r=e("bitcoin-address-validation")}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/btc/address.cjs"}],[1960,{"./address.cjs":1959},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./address.cjs"),n)}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/btc/index.cjs"}],[1961,{"./JsonRpcRequest.cjs":1958,"./btc/index.cjs":1960,"./scopes.cjs":1962,"./superstruct.cjs":1963,"./types.cjs":1964,"./typing.cjs":1965},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./btc/index.cjs"),n),s(e("./types.cjs"),n),s(e("./typing.cjs"),n),s(e("./scopes.cjs"),n),s(e("./superstruct.cjs"),n),s(e("./JsonRpcRequest.cjs"),n)}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/index.cjs"}],[1962,{"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ETH_SCOPE_EOA=void 0,n.isScopeEqual=i,n.isScopeEqualToAny=function(e,t){return t.some(t=>i(e,t))};const r=e("@metamask/utils");n.ETH_SCOPE_EOA=`${r.KnownCaipNamespace.Eip155}:0`;const s=`${r.KnownCaipNamespace.Eip155}:`;function i(e,t){const r=e===n.ETH_SCOPE_EOA,i=t===n.ETH_SCOPE_EOA;return r?t.startsWith(s):i?e.startsWith(s):e===t}}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/scopes.cjs"}],[1963,{"@metamask/superstruct":2562},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.object=function(e){return(0,r.object)(e)},n.type=function(e){return(0,r.type)(e)},n.exactOptional=function(e){return new r.Struct({...e,validator:(t,n)=>!s(n)||e.validator(t,n),refiner:(t,n)=>!s(n)||e.refiner(t,n)})},n.strictMask=function(e,t,n){return(0,r.assert)(e,t,n),e},n.selectiveUnion=function(e){return new r.Struct({type:"union",schema:null,*entries(t,n){yield*e(t).entries(t,n)},*refiner(t,n){yield*e(t).refiner(t,n)},coercer:(t,n)=>e(t).coercer(t,n),validator:(t,n)=>e(t).validator(t,n)})};const r=e("@metamask/superstruct");function s(e){return e.path[e.path.length-1]in e.branch[e.branch.length-2]}}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/superstruct.cjs"}],[1964,{"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.StringNumberStruct=n.UrlStruct=n.AccountIdStruct=n.UuidStruct=void 0;const r=e("@metamask/superstruct"),s=e("@metamask/utils");n.UuidStruct=(0,s.definePattern)("UuidV4",/^[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/iu),n.AccountIdStruct=n.UuidStruct,n.UrlStruct=(0,r.define)("Url",e=>{try{const t=new URL(e);return"http:"===t.protocol||"https:"===t.protocol}catch{return!1}}),n.StringNumberStruct=(0,s.definePattern)("StringNumber",/^\d+(\.\d+)?$/u)}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/types.cjs"}],[1965,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.expectTrue=function(){}}}},{package:"@metamask/account-api>@metamask/keyring-utils",file:"node_modules/@metamask/keyring-utils/dist/typing.cjs"}],[1966,{"@metamask/base-controller":1145,uuid:5219},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.LoggingController=void 0;const a=e("@metamask/base-controller"),o=e("uuid"),c="LoggingController",u={logs:{persist:!0,anonymous:!1}},l={logs:{}};class d extends a.BaseController{constructor({messenger:e,state:t}){super({name:c,metadata:u,messenger:e,state:{...l,...t}}),r.add(this),this.messagingSystem.registerActionHandler(`${c}:add`,e=>this.add(e))}add(e){const t={id:i(this,r,"m",s).call(this),timestamp:Date.now(),log:e};this.update(e=>{e.logs[t.id]=t})}clear(){this.update(e=>{e.logs={}})}}n.LoggingController=d,r=new WeakSet,s=function(){let e=(0,o.v1)();for(;e in this.state.logs;)e=(0,o.v1)();return e}}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/LoggingController.cjs"}],[1967,{"./LoggingController.cjs":1966,"./logTypes/index.cjs":1971},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./LoggingController.cjs"),n),s(e("./logTypes/index.cjs"),n)}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/index.cjs"}],[1968,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s;Object.defineProperty(n,"__esModule",{value:!0}),n.SigningStage=n.SigningMethod=void 0,function(e){e.PersonalSign="personal_sign",e.EthSignTypedData="eth_signTypedData",e.EthSignTypedDataV3="eth_signTypedData_v3",e.EthSignTypedDataV4="eth_signTypedData_v4"}(r||(n.SigningMethod=r={})),function(e){e.Proposed="proposed",e.Rejected="rejected",e.Signed="signed"}(s||(n.SigningStage=s={}))}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/EthSignLog.cjs"}],[1969,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0})}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/GenericLog.cjs"}],[1970,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r;Object.defineProperty(n,"__esModule",{value:!0}),n.LogType=void 0,function(e){e.GenericLog="GenericLog",e.EthSignLog="EthSignLog"}(r||(n.LogType=r={}))}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/LogType.cjs"}],[1971,{"./EthSignLog.cjs":1968,"./GenericLog.cjs":1969,"./LogType.cjs":1970},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./EthSignLog.cjs"),n),s(e("./GenericLog.cjs"),n),s(e("./LogType.cjs"),n)}}},{package:"@metamask/logging-controller",file:"node_modules/@metamask/logging-controller/dist/logTypes/index.cjs"}],[1981,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiERC1155=void 0,n.abiERC1155=[{inputs:[{internalType:"string",name:"uri_",type:"string"}],stateMutability:"nonpayable",type:"constructor"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"account",type:"address"},{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!1,internalType:"bool",name:"approved",type:"bool"}],name:"ApprovalForAll",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256[]",name:"ids",type:"uint256[]"},{indexed:!1,internalType:"uint256[]",name:"values",type:"uint256[]"}],name:"TransferBatch",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"operator",type:"address"},{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256",name:"id",type:"uint256"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"}],name:"TransferSingle",type:"event"},{anonymous:!1,inputs:[{indexed:!1,internalType:"string",name:"value",type:"string"},{indexed:!0,internalType:"uint256",name:"id",type:"uint256"}],name:"URI",type:"event"},{inputs:[{internalType:"address",name:"account",type:"address"},{internalType:"uint256",name:"id",type:"uint256"}],name:"balanceOf",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address[]",name:"accounts",type:"address[]"},{internalType:"uint256[]",name:"ids",type:"uint256[]"}],name:"balanceOfBatch",outputs:[{internalType:"uint256[]",name:"",type:"uint256[]"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"},{internalType:"address",name:"operator",type:"address"}],name:"isApprovedForAll",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256[]",name:"ids",type:"uint256[]"},{internalType:"uint256[]",name:"amounts",type:"uint256[]"},{internalType:"bytes",name:"data",type:"bytes"}],name:"safeBatchTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"id",type:"uint256"},{internalType:"uint256",name:"amount",type:"uint256"},{internalType:"bytes",name:"data",type:"bytes"}],name:"safeTransferFrom",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"operator",type:"address"},{internalType:"bool",name:"approved",type:"bool"}],name:"setApprovalForAll",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"bytes4",name:"interfaceId",type:"bytes4"}],name:"supportsInterface",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"",type:"uint256"}],name:"uri",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"}]}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC1155.js"}],[1982,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiERC20=void 0,n.abiERC20=[{constant:!0,inputs:[],name:"name",outputs:[{name:"",type:"string"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_spender",type:"address"},{name:"_value",type:"uint256"}],name:"approve",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"totalSupply",outputs:[{name:"",type:"uint256"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_value",type:"uint256"}],name:"transferFrom",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"decimals",outputs:[{name:"",type:"uint256"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"version",outputs:[{name:"",type:"string"}],payable:!1,type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"}],name:"balanceOf",outputs:[{name:"balance",type:"uint256"}],payable:!1,type:"function"},{constant:!0,inputs:[],name:"symbol",outputs:[{name:"",type:"string"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_to",type:"address"},{name:"_value",type:"uint256"}],name:"transfer",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!1,inputs:[{name:"_spender",type:"address"},{name:"_value",type:"uint256"},{name:"_extraData",type:"bytes"}],name:"approveAndCall",outputs:[{name:"success",type:"bool"}],payable:!1,type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"},{name:"_spender",type:"address"}],name:"allowance",outputs:[{name:"remaining",type:"uint256"}],payable:!1,type:"function"},{inputs:[{name:"_initialAmount",type:"uint256"},{name:"_tokenName",type:"string"},{name:"_decimalUnits",type:"uint8"},{name:"_tokenSymbol",type:"string"}],type:"constructor"},{payable:!1,type:"fallback"},{anonymous:!1,inputs:[{indexed:!0,name:"_from",type:"address"},{indexed:!0,name:"_to",type:"address"},{indexed:!1,name:"_value",type:"uint256"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"_owner",type:"address"},{indexed:!0,name:"_spender",type:"address"},{indexed:!1,name:"_value",type:"uint256"}],name:"Approval",type:"event"}]}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC20.js"}],[1983,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiERC721=void 0,n.abiERC721=[{constant:!0,inputs:[{name:"interfaceID",type:"bytes4"}],name:"supportsInterface",outputs:[{name:"",type:"bool"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[],name:"name",outputs:[{name:"_name",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_tokenId",type:"uint256"}],name:"getApproved",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_approved",type:"address"},{name:"_tokenId",type:"uint256"}],name:"approve",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[],name:"totalSupply",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_tokenId",type:"uint256"}],name:"transferFrom",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"},{name:"_index",type:"uint256"}],name:"tokenOfOwnerByIndex",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_tokenId",type:"uint256"}],name:"safeTransferFrom",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[{name:"_index",type:"uint256"}],name:"tokenByIndex",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_tokenId",type:"uint256"}],name:"ownerOf",outputs:[{name:"",type:"address"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"}],name:"balanceOf",outputs:[{name:"",type:"uint256"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[],name:"symbol",outputs:[{name:"_symbol",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!1,inputs:[{name:"_operator",type:"address"},{name:"_approved",type:"bool"}],name:"setApprovalForAll",outputs:[],payable:!1,stateMutability:"nonpayable",type:"function"},{constant:!1,inputs:[{name:"_from",type:"address"},{name:"_to",type:"address"},{name:"_tokenId",type:"uint256"},{name:"data",type:"bytes"}],name:"safeTransferFrom",outputs:[],payable:!0,stateMutability:"payable",type:"function"},{constant:!0,inputs:[{name:"_tokenId",type:"uint256"}],name:"tokenURI",outputs:[{name:"",type:"string"}],payable:!1,stateMutability:"view",type:"function"},{constant:!0,inputs:[{name:"_owner",type:"address"},{name:"_operator",type:"address"}],name:"isApprovedForAll",outputs:[{name:"",type:"bool"}],payable:!1,stateMutability:"view",type:"function"},{anonymous:!1,inputs:[{indexed:!0,name:"_from",type:"address"},{indexed:!0,name:"_to",type:"address"},{indexed:!0,name:"_tokenId",type:"uint256"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"_owner",type:"address"},{indexed:!0,name:"_approved",type:"address"},{indexed:!0,name:"_tokenId",type:"uint256"}],name:"Approval",type:"event"},{anonymous:!1,inputs:[{indexed:!0,name:"_owner",type:"address"},{indexed:!0,name:"_operator",type:"address"},{indexed:!1,name:"_approved",type:"bool"}],name:"ApprovalForAll",type:"event"}]}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/abis/abiERC721.js"}],[1984,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiFiatTokenV2=void 0,n.abiFiatTokenV2=[{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"owner",type:"address"},{indexed:!0,internalType:"address",name:"spender",type:"address"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"}],name:"Approval",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"authorizer",type:"address"},{indexed:!0,internalType:"bytes32",name:"nonce",type:"bytes32"}],name:"AuthorizationCanceled",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"authorizer",type:"address"},{indexed:!0,internalType:"bytes32",name:"nonce",type:"bytes32"}],name:"AuthorizationUsed",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"_account",type:"address"}],name:"Blacklisted",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"newBlacklister",type:"address"}],name:"BlacklisterChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"burner",type:"address"},{indexed:!1,internalType:"uint256",name:"amount",type:"uint256"}],name:"Burn",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"newMasterMinter",type:"address"}],name:"MasterMinterChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"minter",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256",name:"amount",type:"uint256"}],name:"Mint",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"minter",type:"address"},{indexed:!1,internalType:"uint256",name:"minterAllowedAmount",type:"uint256"}],name:"MinterConfigured",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"oldMinter",type:"address"}],name:"MinterRemoved",type:"event"},{anonymous:!1,inputs:[{indexed:!1,internalType:"address",name:"previousOwner",type:"address"},{indexed:!1,internalType:"address",name:"newOwner",type:"address"}],name:"OwnershipTransferred",type:"event"},{anonymous:!1,inputs:[],name:"Pause",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"newAddress",type:"address"}],name:"PauserChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"newRescuer",type:"address"}],name:"RescuerChanged",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"from",type:"address"},{indexed:!0,internalType:"address",name:"to",type:"address"},{indexed:!1,internalType:"uint256",name:"value",type:"uint256"}],name:"Transfer",type:"event"},{anonymous:!1,inputs:[{indexed:!0,internalType:"address",name:"_account",type:"address"}],name:"UnBlacklisted",type:"event"},{anonymous:!1,inputs:[],name:"Unpause",type:"event"},{inputs:[],name:"CANCEL_AUTHORIZATION_TYPEHASH",outputs:[{internalType:"bytes32",name:"",type:"bytes32"}],stateMutability:"view",type:"function"},{inputs:[],name:"DOMAIN_SEPARATOR",outputs:[{internalType:"bytes32",name:"",type:"bytes32"}],stateMutability:"view",type:"function"},{inputs:[],name:"PERMIT_TYPEHASH",outputs:[{internalType:"bytes32",name:"",type:"bytes32"}],stateMutability:"view",type:"function"},{inputs:[],name:"RECEIVE_WITH_AUTHORIZATION_TYPEHASH",outputs:[{internalType:"bytes32",name:"",type:"bytes32"}],stateMutability:"view",type:"function"},{inputs:[],name:"TRANSFER_WITH_AUTHORIZATION_TYPEHASH",outputs:[{internalType:"bytes32",name:"",type:"bytes32"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"address",name:"spender",type:"address"}],name:"allowance",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"value",type:"uint256"}],name:"approve",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"authorizer",type:"address"},{internalType:"bytes32",name:"nonce",type:"bytes32"}],name:"authorizationState",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"}],name:"balanceOf",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"_account",type:"address"}],name:"blacklist",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"blacklister",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"uint256",name:"_amount",type:"uint256"}],name:"burn",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"authorizer",type:"address"},{internalType:"bytes32",name:"nonce",type:"bytes32"},{internalType:"uint8",name:"v",type:"uint8"},{internalType:"bytes32",name:"r",type:"bytes32"},{internalType:"bytes32",name:"s",type:"bytes32"}],name:"cancelAuthorization",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"authorizer",type:"address"},{internalType:"bytes32",name:"nonce",type:"bytes32"},{internalType:"bytes",name:"signature",type:"bytes"}],name:"cancelAuthorization",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"minter",type:"address"},{internalType:"uint256",name:"minterAllowedAmount",type:"uint256"}],name:"configureMinter",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"currency",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[],name:"decimals",outputs:[{internalType:"uint8",name:"",type:"uint8"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"decrement",type:"uint256"}],name:"decreaseAllowance",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"increment",type:"uint256"}],name:"increaseAllowance",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"string",name:"tokenName",type:"string"},{internalType:"string",name:"tokenSymbol",type:"string"},{internalType:"string",name:"tokenCurrency",type:"string"},{internalType:"uint8",name:"tokenDecimals",type:"uint8"},{internalType:"address",name:"newMasterMinter",type:"address"},{internalType:"address",name:"newPauser",type:"address"},{internalType:"address",name:"newBlacklister",type:"address"},{internalType:"address",name:"newOwner",type:"address"}],name:"initialize",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"string",name:"newName",type:"string"}],name:"initializeV2",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"lostAndFound",type:"address"}],name:"initializeV2_1",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address[]",name:"accountsToBlacklist",type:"address[]"},{internalType:"string",name:"newSymbol",type:"string"}],name:"initializeV2_2",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"_account",type:"address"}],name:"isBlacklisted",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"account",type:"address"}],name:"isMinter",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[],name:"masterMinter",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"_to",type:"address"},{internalType:"uint256",name:"_amount",type:"uint256"}],name:"mint",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"minter",type:"address"}],name:"minterAllowance",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[],name:"name",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"}],name:"nonces",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[],name:"owner",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[],name:"pause",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"paused",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"view",type:"function"},{inputs:[],name:"pauser",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"uint256",name:"deadline",type:"uint256"},{internalType:"bytes",name:"signature",type:"bytes"}],name:"permit",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"owner",type:"address"},{internalType:"address",name:"spender",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"uint256",name:"deadline",type:"uint256"},{internalType:"uint8",name:"v",type:"uint8"},{internalType:"bytes32",name:"r",type:"bytes32"},{internalType:"bytes32",name:"s",type:"bytes32"}],name:"permit",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"uint256",name:"validAfter",type:"uint256"},{internalType:"uint256",name:"validBefore",type:"uint256"},{internalType:"bytes32",name:"nonce",type:"bytes32"},{internalType:"bytes",name:"signature",type:"bytes"}],name:"receiveWithAuthorization",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"uint256",name:"validAfter",type:"uint256"},{internalType:"uint256",name:"validBefore",type:"uint256"},{internalType:"bytes32",name:"nonce",type:"bytes32"},{internalType:"uint8",name:"v",type:"uint8"},{internalType:"bytes32",name:"r",type:"bytes32"},{internalType:"bytes32",name:"s",type:"bytes32"}],name:"receiveWithAuthorization",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"minter",type:"address"}],name:"removeMinter",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"contract IERC20",name:"tokenContract",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"amount",type:"uint256"}],name:"rescueERC20",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"rescuer",outputs:[{internalType:"address",name:"",type:"address"}],stateMutability:"view",type:"function"},{inputs:[],name:"symbol",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"view",type:"function"},{inputs:[],name:"totalSupply",outputs:[{internalType:"uint256",name:"",type:"uint256"}],stateMutability:"view",type:"function"},{inputs:[{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"}],name:"transfer",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"}],name:"transferFrom",outputs:[{internalType:"bool",name:"",type:"bool"}],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"newOwner",type:"address"}],name:"transferOwnership",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"uint256",name:"validAfter",type:"uint256"},{internalType:"uint256",name:"validBefore",type:"uint256"},{internalType:"bytes32",name:"nonce",type:"bytes32"},{internalType:"bytes",name:"signature",type:"bytes"}],name:"transferWithAuthorization",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"from",type:"address"},{internalType:"address",name:"to",type:"address"},{internalType:"uint256",name:"value",type:"uint256"},{internalType:"uint256",name:"validAfter",type:"uint256"},{internalType:"uint256",name:"validBefore",type:"uint256"},{internalType:"bytes32",name:"nonce",type:"bytes32"},{internalType:"uint8",name:"v",type:"uint8"},{internalType:"bytes32",name:"r",type:"bytes32"},{internalType:"bytes32",name:"s",type:"bytes32"}],name:"transferWithAuthorization",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"_account",type:"address"}],name:"unBlacklist",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"unpause",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"_newBlacklister",type:"address"}],name:"updateBlacklister",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"_newMasterMinter",type:"address"}],name:"updateMasterMinter",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"_newPauser",type:"address"}],name:"updatePauser",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[{internalType:"address",name:"newRescuer",type:"address"}],name:"updateRescuer",outputs:[],stateMutability:"nonpayable",type:"function"},{inputs:[],name:"version",outputs:[{internalType:"string",name:"",type:"string"}],stateMutability:"pure",type:"function"}]}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/abis/fiatTokenV2.js"}],[1985,{"./abis/abiERC1155":1981,"./abis/abiERC20":1982,"./abis/abiERC721":1983,"./abis/fiatTokenV2":1984},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.abiFiatTokenV2=n.abiERC1155=n.abiERC721=n.abiERC20=void 0;const r=e("./abis/abiERC20");Object.defineProperty(n,"abiERC20",{enumerable:!0,get:function(){return r.abiERC20}});const s=e("./abis/abiERC721");Object.defineProperty(n,"abiERC721",{enumerable:!0,get:function(){return s.abiERC721}});const i=e("./abis/abiERC1155");Object.defineProperty(n,"abiERC1155",{enumerable:!0,get:function(){return i.abiERC1155}});const a=e("./abis/fiatTokenV2");Object.defineProperty(n,"abiFiatTokenV2",{enumerable:!0,get:function(){return a.abiFiatTokenV2}})}}},{package:"@metamask/metamask-eth-abis",file:"node_modules/@metamask/metamask-eth-abis/dist/index.js"}],[2,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){t.exports=[{code:"am",name:"አማርኛ"},{code:"ar",name:"العربية"},{code:"bg",name:"български"},{code:"bn",name:"বাংলা"},{code:"ca",name:"Català"},{code:"cs",name:"Čeština"},{code:"da",name:"Dansk"},{code:"de",name:"Deutsch"},{code:"el",name:"ελληνικά"},{code:"en",name:"English"},{code:"es",name:"Español"},{code:"es_419",name:"Español (Latin America)"},{code:"et",name:"Estonian"},{code:"fa",name:"فارسی"},{code:"fi",name:"Suomi"},{code:"fil",name:"Filipino"},{code:"fr",name:"Français"},{code:"gu",name:"ગુજરાત"},{code:"he",name:"עברית"},{code:"hi",name:"मानक हिन्दी"},{code:"hn",name:"हिन्दी"},{code:"hr",name:"Hrvatski"},{code:"ht",name:"Kreyòl ayisyen"},{code:"hu",name:"Magyar"},{code:"id",name:"Bahasa Indonesia"},{code:"it",name:"Italiano"},{code:"ja",name:"日本語"},{code:"kn",name:"ಕನ್ನಡ"},{code:"ko",name:"한국어"},{code:"lt",name:"Lietuviškai"},{code:"lv",name:"Latvian"},{code:"ml",name:"മലയാളം"},{code:"mr",name:"मराठी"},{code:"ms",name:"Malay"},{code:"nl",name:"Nederlands"},{code:"no",name:"Norwegian"},{code:"ph",name:"Pilipino"},{code:"pl",name:"Polskie"},{code:"pt",name:"Português"},{code:"pt_BR",name:"Português (Brazillian)"},{code:"pt_PT",name:"Português (European)"},{code:"ro",name:"Limba română"},{code:"ru",name:"Русский"},{code:"sk",name:"Slovenčina"},{code:"sl",name:"Slovenščina"},{code:"sr",name:"српски"},{code:"sv",name:"Svenska"},{code:"sw",name:"Swahili"},{code:"ta",name:"தமிழ்"},{code:"te",name:"తెలుగు"},{code:"th",name:"ไทย"},{code:"tl",name:"Wikang Tagalog"},{code:"tr",name:"Türkçe"},{code:"uk",name:"Українська мова"},{code:"vi",name:"Tiếng Việt"},{code:"zh_CN",name:"中文(简体)"},{code:"zh_TW",name:"中文(繁體)"}]}}},{package:"$root$",file:"app/_locales/index.json"}],[2008,{"../api/accounts-api.cjs":2010,"../constants.cjs":2011,"../types.cjs":2013,"../utils.cjs":2014,"@metamask/base-controller":1145,"@metamask/keyring-api":1920,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c,u,l,d,m=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},h=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.MultichainNetworkController=void 0;const f=e("@metamask/base-controller"),p=e("@metamask/keyring-api"),y=e("@metamask/utils"),g=e("../api/accounts-api.cjs"),b=e("../constants.cjs"),v=e("../types.cjs"),k=e("../utils.cjs");class E extends f.BaseController{constructor({messenger:e,state:t,networkService:n}){super({messenger:e,name:v.MULTICHAIN_NETWORK_CONTROLLER_NAME,metadata:b.MULTICHAIN_NETWORK_CONTROLLER_METADATA,state:{...(0,b.getDefaultMultichainNetworkControllerState)(),...t,multichainNetworkConfigurationsByChainId:b.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS}}),r.add(this),s.set(this,void 0),m(this,s,n,"f"),h(this,r,"m",l).call(this),h(this,r,"m",d).call(this)}async setActiveNetwork(e){if((0,y.isCaipChainId)(e)){if(!(0,k.checkIfSupportedCaipChainId)(e))throw new Error(`Unsupported Caip chain ID: ${String(e)}`);return h(this,r,"m",a).call(this,e)}return await h(this,r,"m",i).call(this,e)}async getNetworksWithTransactionActivityByAccounts(){const e=this.messagingSystem.call("AccountsController:listMultichainAccounts").filter(e=>(0,p.isEvmAccountType)(e.type));if(!e||0===e.length)return this.state.networksWithTransactionActivity;const t=e.map(e=>(0,g.toAllowedCaipAccountIds)(e)).flat(),n=await h(this,s,"f").fetchNetworkActivity(t),r=(0,g.toActiveNetworksByAddress)(n);return this.update(e=>{e.networksWithTransactionActivity=r}),this.state.networksWithTransactionActivity}async removeNetwork(e){return(0,k.isEvmCaipChainId)(e)?await h(this,r,"m",o).call(this,e):h(this,r,"m",c).call(this,e)}}n.MultichainNetworkController=E,s=new WeakMap,r=new WeakSet,i=async function(e){const{selectedNetworkClientId:t}=this.messagingSystem.call("NetworkController:getState"),n=!this.state.isEvmSelected,r=e!==t;(n||r)&&(n&&this.update(e=>{e.isEvmSelected=!0}),r&&await this.messagingSystem.call("NetworkController:setActiveNetwork",e),(n||r)&&this.messagingSystem.publish("MultichainNetworkController:networkDidChange",e))},a=function(e){(e!==this.state.selectedMultichainNetworkChainId||this.state.isEvmSelected)&&(this.update(t=>{t.selectedMultichainNetworkChainId=e,t.isEvmSelected=!1}),this.messagingSystem.publish("MultichainNetworkController:networkDidChange",e))},o=async function(e){const t=(0,k.convertEvmCaipToHexChainId)(e);if(this.messagingSystem.call("NetworkController:getSelectedChainId")===t){if(this.state.isEvmSelected)throw new Error("Cannot remove the currently selected network");const e="0x1",t=this.messagingSystem.call("NetworkController:findNetworkClientIdByChainId",e);await this.messagingSystem.call("NetworkController:setActiveNetwork",t)}this.messagingSystem.call("NetworkController:removeNetwork",t)},c=function(e){throw new Error("Removal of non-EVM networks is not supported")},u=function(e){const{type:t,scopes:n}=e;if((0,p.isEvmAccountType)(t)){if(this.state.isEvmSelected)return;return void this.update(e=>{e.isEvmSelected=!0})}if(n.includes(this.state.selectedMultichainNetworkChainId))return void this.update(e=>{e.isEvmSelected=!1});const r=(0,k.getChainIdForNonEvm)(n);this.update(e=>{e.selectedMultichainNetworkChainId=r,e.isEvmSelected=!1})},l=function(){this.messagingSystem.subscribe("AccountsController:selectedAccountChange",e=>h(this,r,"m",u).call(this,e))},d=function(){this.messagingSystem.registerActionHandler("MultichainNetworkController:setActiveNetwork",this.setActiveNetwork.bind(this)),this.messagingSystem.registerActionHandler("MultichainNetworkController:getNetworksWithTransactionActivityByAccounts",this.getNetworksWithTransactionActivityByAccounts.bind(this))}}}},{package:"@metamask/multichain-network-controller",file:"node_modules/@metamask/multichain-network-controller/dist/MultichainNetworkController/MultichainNetworkController.cjs"}],[2009,{"../api/accounts-api.cjs":2010,"@metamask/superstruct":2562,lodash:4386},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},c=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.MultichainNetworkService=void 0;const u=e("@metamask/superstruct"),l=e("lodash"),d=e("../api/accounts-api.cjs");n.MultichainNetworkService=class{constructor({fetch:e,batchSize:t}){r.add(this),s.set(this,void 0),i.set(this,void 0),o(this,s,e,"f"),o(this,i,t??20,"f")}async fetchNetworkActivity(e){if(0===e.length)return{activeNetworks:[]};if(e.length<=c(this,i,"f"))return c(this,r,"m",a).call(this,e);const t=(0,l.chunk)(e,c(this,i,"f"));return{activeNetworks:(await Promise.all(t.map(e=>c(this,r,"m",a).call(this,e)))).flatMap(e=>e.activeNetworks)}}},s=new WeakMap,i=new WeakMap,r=new WeakSet,a=async function(e){try{const t=(0,d.buildActiveNetworksUrl)(e),n=await c(this,s,"f").call(this,t.toString(),{method:"GET",headers:{[d.MULTICHAIN_ACCOUNTS_CLIENT_HEADER]:d.MULTICHAIN_ACCOUNTS_CLIENT_ID,Accept:"application/json"}});if(!n.ok)throw new Error(`HTTP error! status: ${n.status}`);const r=await n.json();return(0,u.assert)(r,d.ActiveNetworksResponseStruct),r}catch(e){if(e instanceof Error){if("AbortError"===e.name)throw new Error("Request timeout: Failed to fetch active networks");throw e}throw new Error(`Failed to fetch active networks: ${String(e)}`)}}}}},{package:"@metamask/multichain-network-controller",file:"node_modules/@metamask/multichain-network-controller/dist/MultichainNetworkService/MultichainNetworkService.cjs"}],[2010,{"@metamask/keyring-api":1920,"@metamask/superstruct":2562,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.buildActiveNetworksUrl=n.toActiveNetworksByAddress=n.toAllowedCaipAccountIds=n.MULTICHAIN_ALLOWED_ACTIVE_NETWORK_SCOPES=n.MULTICHAIN_ACCOUNTS_CLIENT_ID=n.MULTICHAIN_ACCOUNTS_CLIENT_HEADER=n.MULTICHAIN_ACCOUNTS_BASE_URL=n.ActiveNetworksResponseStruct=void 0;const r=e("@metamask/keyring-api"),s=e("@metamask/superstruct"),i=e("@metamask/utils");n.ActiveNetworksResponseStruct=(0,s.object)({activeNetworks:(0,s.array)(i.CaipAccountIdStruct)}),n.MULTICHAIN_ACCOUNTS_BASE_URL="https://accounts.api.cx.metamask.io",n.MULTICHAIN_ACCOUNTS_CLIENT_HEADER="x-metamask-clientproduct",n.MULTICHAIN_ACCOUNTS_CLIENT_ID="metamask-multichain-network-controller",n.MULTICHAIN_ALLOWED_ACTIVE_NETWORK_SCOPES=[String(r.BtcScope.Mainnet),String(r.BtcScope.Testnet),String(r.BtcScope.Testnet4),String(r.BtcScope.Signet),String(r.BtcScope.Regtest),String(r.SolScope.Mainnet),String(r.EthScope.Mainnet),String(r.EthScope.Testnet),String(r.EthScope.Eoa)],n.toAllowedCaipAccountIds=function(e){const t=[];for(const r of e.scopes)n.MULTICHAIN_ALLOWED_ACTIVE_NETWORK_SCOPES.includes(r)&&t.push(`${r}:${e.address}`);return t},n.toActiveNetworksByAddress=function(e){const t={};return e.activeNetworks.forEach(e=>{const{address:n,chain:{namespace:r,reference:s}}=(0,i.parseCaipAccountId)(e);t[n]||(t[n]={namespace:r,activeChains:[]}),t[n].activeChains.push(s)}),t},n.buildActiveNetworksUrl=function(e){const t=new URL(`${n.MULTICHAIN_ACCOUNTS_BASE_URL}/v2/activeNetworks`);return t.searchParams.append("accountIds",e.join(",")),t}}}},{package:"@metamask/multichain-network-controller",file:"node_modules/@metamask/multichain-network-controller/dist/api/accounts-api.cjs"}],[2011,{"@metamask/keyring-api":1920,"@metamask/network-controller":2032},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MULTICHAIN_NETWORK_DECIMAL_PLACES=n.MULTICHAIN_NETWORK_TICKER=n.MULTICHAIN_NETWORK_CONTROLLER_METADATA=n.getDefaultMultichainNetworkControllerState=n.NETWORKS_METADATA=n.NON_EVM_TESTNET_IDS=n.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS=n.SOL_DEVNET_NATIVE_ASSET=n.SOL_TESTNET_NATIVE_ASSET=n.SOL_NATIVE_ASSET=n.BTC_REGTEST_NATIVE_ASSET=n.BTC_SIGNET_NATIVE_ASSET=n.BTC_TESTNET4_NATIVE_ASSET=n.BTC_TESTNET_NATIVE_ASSET=n.BTC_NATIVE_ASSET=void 0;const r=e("@metamask/keyring-api"),s=e("@metamask/network-controller");n.BTC_NATIVE_ASSET=`${r.BtcScope.Mainnet}/slip44:0`,n.BTC_TESTNET_NATIVE_ASSET=`${r.BtcScope.Testnet}/slip44:0`,n.BTC_TESTNET4_NATIVE_ASSET=`${r.BtcScope.Testnet4}/slip44:0`,n.BTC_SIGNET_NATIVE_ASSET=`${r.BtcScope.Signet}/slip44:0`,n.BTC_REGTEST_NATIVE_ASSET=`${r.BtcScope.Regtest}/slip44:0`,n.SOL_NATIVE_ASSET=`${r.SolScope.Mainnet}/slip44:501`,n.SOL_TESTNET_NATIVE_ASSET=`${r.SolScope.Testnet}/slip44:501`,n.SOL_DEVNET_NATIVE_ASSET=`${r.SolScope.Devnet}/slip44:501`,n.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS={[r.BtcScope.Mainnet]:{chainId:r.BtcScope.Mainnet,name:"Bitcoin",nativeCurrency:n.BTC_NATIVE_ASSET,isEvm:!1},[r.BtcScope.Testnet]:{chainId:r.BtcScope.Testnet,name:"Bitcoin Testnet",nativeCurrency:n.BTC_TESTNET_NATIVE_ASSET,isEvm:!1},[r.BtcScope.Testnet4]:{chainId:r.BtcScope.Testnet4,name:"Bitcoin Testnet4",nativeCurrency:n.BTC_TESTNET4_NATIVE_ASSET,isEvm:!1},[r.BtcScope.Signet]:{chainId:r.BtcScope.Signet,name:"Bitcoin Mutinynet",nativeCurrency:n.BTC_SIGNET_NATIVE_ASSET,isEvm:!1},[r.BtcScope.Regtest]:{chainId:r.BtcScope.Regtest,name:"Bitcoin Regtest",nativeCurrency:n.BTC_REGTEST_NATIVE_ASSET,isEvm:!1},[r.SolScope.Mainnet]:{chainId:r.SolScope.Mainnet,name:"Solana",nativeCurrency:n.SOL_NATIVE_ASSET,isEvm:!1},[r.SolScope.Testnet]:{chainId:r.SolScope.Testnet,name:"Solana Testnet",nativeCurrency:n.SOL_TESTNET_NATIVE_ASSET,isEvm:!1},[r.SolScope.Devnet]:{chainId:r.SolScope.Devnet,name:"Solana Devnet",nativeCurrency:n.SOL_DEVNET_NATIVE_ASSET,isEvm:!1}},n.NON_EVM_TESTNET_IDS=[r.BtcScope.Testnet,r.BtcScope.Testnet4,r.BtcScope.Signet,r.BtcScope.Regtest,r.SolScope.Testnet,r.SolScope.Devnet],n.NETWORKS_METADATA={[r.BtcScope.Mainnet]:{features:[],status:s.NetworkStatus.Available},[r.SolScope.Mainnet]:{features:[],status:s.NetworkStatus.Available}};n.getDefaultMultichainNetworkControllerState=()=>({multichainNetworkConfigurationsByChainId:n.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS,selectedMultichainNetworkChainId:r.SolScope.Mainnet,isEvmSelected:!0,networksWithTransactionActivity:{}}),n.MULTICHAIN_NETWORK_CONTROLLER_METADATA={multichainNetworkConfigurationsByChainId:{persist:!0,anonymous:!0},selectedMultichainNetworkChainId:{persist:!0,anonymous:!0},isEvmSelected:{persist:!0,anonymous:!0},networksWithTransactionActivity:{persist:!0,anonymous:!0}},n.MULTICHAIN_NETWORK_TICKER={[r.BtcScope.Mainnet]:"BTC",[r.BtcScope.Testnet]:"tBTC",[r.BtcScope.Testnet4]:"tBTC",[r.BtcScope.Signet]:"sBTC",[r.BtcScope.Regtest]:"rBTC",[r.SolScope.Mainnet]:"SOL",[r.SolScope.Testnet]:"tSOL",[r.SolScope.Devnet]:"dSOL"},n.MULTICHAIN_NETWORK_DECIMAL_PLACES={[r.BtcScope.Mainnet]:8,[r.BtcScope.Testnet]:8,[r.BtcScope.Testnet4]:8,[r.BtcScope.Signet]:8,[r.BtcScope.Regtest]:8,[r.SolScope.Mainnet]:5,[r.SolScope.Testnet]:5,[r.SolScope.Devnet]:5}}}},{package:"@metamask/multichain-network-controller",file:"node_modules/@metamask/multichain-network-controller/dist/constants.cjs"}],[2012,{"./MultichainNetworkController/MultichainNetworkController.cjs":2008,"./MultichainNetworkService/MultichainNetworkService.cjs":2009,"./constants.cjs":2011,"./utils.cjs":2014},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.toEvmCaipChainId=n.toMultichainNetworkConfigurationsByChainId=n.toMultichainNetworkConfiguration=n.checkIfSupportedCaipChainId=n.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS=n.MULTICHAIN_NETWORK_DECIMAL_PLACES=n.MULTICHAIN_NETWORK_TICKER=n.NON_EVM_TESTNET_IDS=n.getDefaultMultichainNetworkControllerState=n.MultichainNetworkService=n.MultichainNetworkController=void 0;var r=e("./MultichainNetworkController/MultichainNetworkController.cjs");Object.defineProperty(n,"MultichainNetworkController",{enumerable:!0,get:function(){return r.MultichainNetworkController}});var s=e("./MultichainNetworkService/MultichainNetworkService.cjs");Object.defineProperty(n,"MultichainNetworkService",{enumerable:!0,get:function(){return s.MultichainNetworkService}});var i=e("./constants.cjs");Object.defineProperty(n,"getDefaultMultichainNetworkControllerState",{enumerable:!0,get:function(){return i.getDefaultMultichainNetworkControllerState}}),Object.defineProperty(n,"NON_EVM_TESTNET_IDS",{enumerable:!0,get:function(){return i.NON_EVM_TESTNET_IDS}}),Object.defineProperty(n,"MULTICHAIN_NETWORK_TICKER",{enumerable:!0,get:function(){return i.MULTICHAIN_NETWORK_TICKER}}),Object.defineProperty(n,"MULTICHAIN_NETWORK_DECIMAL_PLACES",{enumerable:!0,get:function(){return i.MULTICHAIN_NETWORK_DECIMAL_PLACES}}),Object.defineProperty(n,"AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS",{enumerable:!0,get:function(){return i.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS}});var a=e("./utils.cjs");Object.defineProperty(n,"checkIfSupportedCaipChainId",{enumerable:!0,get:function(){return a.checkIfSupportedCaipChainId}}),Object.defineProperty(n,"toMultichainNetworkConfiguration",{enumerable:!0,get:function(){return a.toMultichainNetworkConfiguration}}),Object.defineProperty(n,"toMultichainNetworkConfigurationsByChainId",{enumerable:!0,get:function(){return a.toMultichainNetworkConfigurationsByChainId}}),Object.defineProperty(n,"toEvmCaipChainId",{enumerable:!0,get:function(){return a.toEvmCaipChainId}})}}},{package:"@metamask/multichain-network-controller",file:"node_modules/@metamask/multichain-network-controller/dist/index.cjs"}],[2013,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MULTICHAIN_NETWORK_CONTROLLER_NAME=void 0,n.MULTICHAIN_NETWORK_CONTROLLER_NAME="MultichainNetworkController"}}},{package:"@metamask/multichain-network-controller",file:"node_modules/@metamask/multichain-network-controller/dist/types.cjs"}],[2014,{"./constants.cjs":2011,"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.isKnownCaipNamespace=n.toMultichainNetworkConfigurationsByChainId=n.toMultichainNetworkConfiguration=n.convertEvmCaipToHexChainId=n.toEvmCaipChainId=n.checkIfSupportedCaipChainId=n.getChainIdForNonEvm=n.isEvmCaipChainId=void 0;const r=e("@metamask/utils"),s=e("./constants.cjs");n.isEvmCaipChainId=function(e){const{namespace:t}=(0,r.parseCaipChainId)(e);return t===r.KnownCaipNamespace.Eip155},n.getChainIdForNonEvm=function(e){const t=e.find(e=>Object.keys(s.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS).includes(e));if(t)return t;throw new Error(`Unsupported scope: ${e.join(", ")}.`)},n.checkIfSupportedCaipChainId=function(e){return Object.keys(s.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS).includes(e)};n.toEvmCaipChainId=e=>(0,r.toCaipChainId)(r.KnownCaipNamespace.Eip155,(0,r.hexToNumber)(e).toString()),n.convertEvmCaipToHexChainId=function(e){const{namespace:t,reference:n}=(0,r.parseCaipChainId)(e);if(t===r.KnownCaipNamespace.Eip155)return(0,r.add0x)(parseInt(n,10).toString(16));throw new Error(`Unsupported CAIP chain ID namespace: ${t}. Only eip155 is supported.`)};n.toMultichainNetworkConfiguration=e=>{const{chainId:t,name:r,rpcEndpoints:s,defaultRpcEndpointIndex:i,nativeCurrency:a,blockExplorerUrls:o,defaultBlockExplorerUrlIndex:c}=e;return{chainId:(0,n.toEvmCaipChainId)(t),isEvm:!0,name:r||s[i].url,nativeCurrency:a,blockExplorerUrls:o,defaultBlockExplorerUrlIndex:c||0}};n.toMultichainNetworkConfigurationsByChainId=e=>Object.entries(e).reduce((e,[,t])=>({...e,[(0,n.toEvmCaipChainId)(t.chainId)]:(0,n.toMultichainNetworkConfiguration)(t)}),{}),n.isKnownCaipNamespace=function(e){return Object.values(r.KnownCaipNamespace).includes(e)}}}},{package:"@metamask/multichain-network-controller",file:"node_modules/@metamask/multichain-network-controller/dist/utils.cjs"}],[2015,{"@metamask/base-controller":1145,"@metamask/keyring-api":1920,"@metamask/keyring-snap-client":1941,"@metamask/snaps-utils":2540},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c,u,l,d,m,h=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.MultichainTransactionsController=n.getDefaultMultichainTransactionsControllerState=void 0;const f=e("@metamask/base-controller"),p=e("@metamask/keyring-api"),y=e("@metamask/keyring-snap-client"),g=e("@metamask/snaps-utils");function b(){return{nonEvmTransactions:{}}}n.getDefaultMultichainTransactionsControllerState=b;const v={nonEvmTransactions:{persist:!0,anonymous:!1}};class k extends f.BaseController{constructor({messenger:e,state:t}){super({messenger:e,name:"MultichainTransactionsController",metadata:v,state:{nonEvmTransactions:{},...t}}),r.add(this);for(const e of h(this,r,"m",i).call(this))this.updateTransactionsForAccount(e.id).catch(t=>{console.error(`Failed to fetch initial transactions for account ${e.id}:`,t)});this.messagingSystem.subscribe("AccountsController:accountAdded",e=>h(this,r,"m",c).call(this,e)),this.messagingSystem.subscribe("AccountsController:accountRemoved",e=>h(this,r,"m",u).call(this,e)),this.messagingSystem.subscribe("AccountsController:accountTransactionsUpdated",e=>h(this,r,"m",d).call(this,e))}async updateTransactionsForAccount(e){const{isUnlocked:t}=this.messagingSystem.call("KeyringController:getState");if(t)try{const t=h(this,r,"m",i).call(this).find(t=>t.id===e);if(t?.metadata.snap){const e=await h(this,r,"m",a).call(this,t.id,t.metadata.snap.id,{limit:10}),n={};e.data.forEach(e=>{const{chain:t}=e;n[t]||(n[t]=[]),n[t].push(e)});const s=Object.entries(n).map(([t,n])=>({chain:t,entry:{transactions:n,next:e.next,lastUpdated:Date.now()}}));this.update(e=>{e.nonEvmTransactions[t.id]||(e.nonEvmTransactions[t.id]={}),s.forEach(({chain:n,entry:r})=>{e.nonEvmTransactions[t.id][n]=r})})}}catch(t){console.error(`Failed to fetch transactions for account ${e}:`,t)}}}n.MultichainTransactionsController=k,r=new WeakSet,s=function(){return this.messagingSystem.call("AccountsController:listMultichainAccounts")},i=function(){return h(this,r,"m",s).call(this).filter(e=>h(this,r,"m",o).call(this,e))},a=async function(e,t,n){return await h(this,r,"m",m).call(this,t).listAccountTransactions(e,n)},o=function(e){return!(0,p.isEvmAccountType)(e.type)&&e.metadata.snap!==undefined},c=async function(e){h(this,r,"m",o).call(this,e)&&await this.updateTransactionsForAccount(e.id)},u=async function(e){e in this.state.nonEvmTransactions&&this.update(t=>{delete t.nonEvmTransactions[e]})},l=function(e){e.status===p.TransactionStatus.Confirmed&&this.messagingSystem.publish("MultichainTransactionsController:transactionConfirmed",e),e.status===p.TransactionStatus.Submitted&&this.messagingSystem.publish("MultichainTransactionsController:transactionSubmitted",e)},d=function(e){const t={},n=[];e?.transactions&&(Object.entries(e.transactions).forEach(([e,r])=>{t[e]={},r.forEach(r=>{const{chain:s}=r;t[e][s]||(t[e][s]=[]),t[e][s].push(r),n.push(r)}),Object.entries(t[e]).forEach(([n,r])=>{const s=this.state.nonEvmTransactions[e]?.[n]?.transactions??[],i=new Map;s.forEach(e=>{i.set(e.id,e)}),r.forEach(e=>{i.set(e.id,e)}),t[e][n]=Array.from(i.values()).sort((e,t)=>(t.timestamp??0)-(e.timestamp??0))})}),this.update(e=>{Object.entries(t).forEach(([t,n])=>{e.nonEvmTransactions[t]||(e.nonEvmTransactions[t]={}),Object.entries(n).forEach(([n,r])=>{e.nonEvmTransactions[t][n]={transactions:r,next:null,lastUpdated:Date.now()}})})}),n.forEach(e=>{h(this,r,"m",l).call(this,e)}))},m=function(e){return new y.KeyringClient({send:async t=>await this.messagingSystem.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:g.HandlerType.OnKeyringRequest,request:t})})}}}},{package:"@metamask/multichain-transactions-controller",file:"node_modules/@metamask/multichain-transactions-controller/dist/MultichainTransactionsController.cjs"}],[2016,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s;Object.defineProperty(n,"__esModule",{value:!0}),n.MultichainNativeAsset=n.MultichainNetwork=void 0,function(e){e.Bitcoin="bip122:000000000019d6689c085ae165831e93",e.BitcoinTestnet="bip122:000000000933ea01ad0ee984209779ba",e.Solana="solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp",e.SolanaDevnet="solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1",e.SolanaTestnet="solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z"}(r||(n.MultichainNetwork=r={})),function(e){e.Bitcoin="bip122:000000000019d6689c085ae165831e93/slip44:0",e.BitcoinTestnet="bip122:000000000933ea01ad0ee984209779ba/slip44:0",e.Solana="solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp/slip44:501",e.SolanaDevnet="solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1/slip44:501",e.SolanaTestnet="solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z/slip44:501"}(s||(n.MultichainNativeAsset=s={}))}}},{package:"@metamask/multichain-transactions-controller",file:"node_modules/@metamask/multichain-transactions-controller/dist/constants.cjs"}],[2017,{"./MultichainTransactionsController.cjs":2015,"./constants.cjs":2016},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.MultichainNativeAsset=n.MultichainNetwork=n.MultichainTransactionsController=void 0;var r=e("./MultichainTransactionsController.cjs");Object.defineProperty(n,"MultichainTransactionsController",{enumerable:!0,get:function(){return r.MultichainTransactionsController}});var s=e("./constants.cjs");Object.defineProperty(n,"MultichainNetwork",{enumerable:!0,get:function(){return s.MultichainNetwork}}),Object.defineProperty(n,"MultichainNativeAsset",{enumerable:!0,get:function(){return s.MultichainNativeAsset}})}}},{package:"@metamask/multichain-transactions-controller",file:"node_modules/@metamask/multichain-transactions-controller/dist/index.cjs"}],[2018,{"./types.cjs":2026,"@metamask/base-controller":1145,"@metamask/controller-utils":1229},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r,s,i,a,o,c,u,l,d,m,h,f,p,y,g,b,v,k,E,w,T,A,C,_,x,P,B,S,I=this&&this.__classPrivateFieldSet||function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},D=this&&this.__classPrivateFieldGet||function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};Object.defineProperty(n,"__esModule",{value:!0}),n.NameController=n.NameOrigin=n.PROPOSED_NAME_EXPIRE_DURATION=n.FALLBACK_VARIATION=void 0;const j=e("@metamask/base-controller"),R=e("@metamask/controller-utils"),O=e("./types.cjs");var M;n.FALLBACK_VARIATION="*",n.PROPOSED_NAME_EXPIRE_DURATION=86400,function(e){e.ACCOUNT_IDENTITY="account-identity",e.ADDRESS_BOOK="address-book",e.API="api",e.UI="ui"}(M||(n.NameOrigin=M={}));const F={names:{persist:!0,anonymous:!1},nameSources:{persist:!0,anonymous:!1}};class N extends j.BaseController{constructor({messenger:e,providers:t,state:n,updateDelay:a}){super({name:"NameController",metadata:F,messenger:e,state:{names:{[O.NameType.ETHEREUM_ADDRESS]:{}},nameSources:{},...n}}),r.add(this),s.set(this,void 0),i.set(this,void 0),I(this,s,t,"f"),I(this,i,a??120,"f")}setName(e){D(this,r,"m",y).call(this,e);const{value:t,type:n,name:s,sourceId:i,origin:a,variation:o}=e,c=i??null,u=null===s?null:M.API,l=a??u;D(this,r,"m",f).call(this,t,n,o,e=>{e.name=s,e.sourceId=c,e.origin=l})}async updateProposedNames(e){D(this,r,"m",g).call(this,e);const t=(await Promise.all(D(this,s,"f").map(t=>D(this,r,"m",u).call(this,e,t)))).filter(e=>Boolean(e));return D(this,r,"m",a).call(this,e,t),D(this,r,"m",o).call(this,D(this,s,"f")),D(this,r,"m",B).call(this),D(this,r,"m",c).call(this,t)}}n.NameController=N,s=new WeakMap,i=new WeakMap,r=new WeakSet,a=function(e,t){const{value:n,type:s,variation:i}=e,a=D(this,r,"m",p).call(this);D(this,r,"m",f).call(this,n,s,i,e=>{D(this,r,"m",P).call(this,e.proposedNames,s);for(const n of t){const{results:t}=n;for(const r of Object.keys(n.results)){const n=t[r],{proposedNames:s,updateDelay:i}=n,o=e.proposedNames[r]??{proposedNames:[],lastRequestTime:null,updateDelay:null};e.proposedNames[r]=o,s&&(o.proposedNames=s),o.lastRequestTime=a,o.updateDelay=i??null}}})},o=function(e){const t={...this.state.nameSources};for(const n of e){const{sourceLabels:e}=n.getMetadata();for(const n of Object.keys(e))t[n]={label:e[n]}}this.update(e=>{e.nameSources=t})},c=function(e){return e.reduce((e,t)=>{const{results:n}=t;for(const t of Object.keys(n)){const{proposedNames:r,error:s}=n[t];e.results[t]={proposedNames:r,error:s}}return e},{results:{}})},u=async function(e,t){const{value:n,type:s,sourceIds:a,onlyUpdateAfterDelay:o,variation:c}=e,u=c??"",d=D(this,r,"m",x).call(this,t,s),f=D(this,r,"m",p).call(this),y=D(this,r,"m",m).call(this,n,s),g=d.filter(e=>{if(a&&!a.includes(e))return!1;if(o){const t=this.state.names[s]?.[y]?.[u]??{},n=t.proposedNames?.[e]??{},r=n.lastRequestTime??0,a=n.updateDelay??D(this,i,"f");if(f-r<a)return!1}return!0});if(!g.length)return undefined;const b={value:D(this,r,"m",m).call(this,n,s),type:s,sourceIds:a?g:undefined,variation:D(this,r,"m",h).call(this,u,s)};let v,k;try{k=await t.getProposedNames(b),v=k.error}catch(e){v=e}return D(this,r,"m",l).call(this,k,v,g)},l=function(e,t,n){const s=t??undefined;return{results:n.reduce((n,s)=>{const i=e?.results?.[s],a=D(this,r,"m",d).call(this,i,t);return{...n,[s]:a}},{}),error:s}},d=function(e,t){const n=e?.error??t??undefined,r=e?.updateDelay??undefined;let s=n?undefined:e?.proposedNames??undefined;return s&&(s=s.filter(e=>e?.length)),{proposedNames:s,error:n,updateDelay:r}},m=function(e,t){return t===O.NameType.ETHEREUM_ADDRESS?e.toLowerCase():e},h=function(e,t){return t===O.NameType.ETHEREUM_ADDRESS?e.toLowerCase():e},f=function(e,t,n,s){const i=n??"",a=D(this,r,"m",m).call(this,e,t),o=D(this,r,"m",h).call(this,i,t);[a,o].some(e=>!(0,R.isSafeDynamicKey)(e))||this.update(e=>{const n=e.names[t]||{};e.names[t]=n;const r=n[a]||{};n[a]=r;const i=r[o]??{proposedNames:{},name:null,sourceId:null,origin:null};r[o]=i,s(i)})},p=function(){return Math.round(Date.now()/1e3)},y=function(e){const{name:t,value:n,type:s,sourceId:i,variation:a,origin:o}=e,c=[];if(D(this,r,"m",b).call(this,n,c),D(this,r,"m",v).call(this,s,c),D(this,r,"m",k).call(this,t,c),D(this,r,"m",w).call(this,i,s,t,c),D(this,r,"m",A).call(this,a,s,c),D(this,r,"m",C).call(this,o,t,c),c.length)throw new Error(c.join(" "))},g=function(e){const{value:t,type:n,sourceIds:s,variation:i}=e,a=[];if(D(this,r,"m",b).call(this,t,a),D(this,r,"m",v).call(this,n,a),D(this,r,"m",E).call(this,s,n,a),D(this,r,"m",T).call(this,n,a),D(this,r,"m",A).call(this,i,n,a),a.length)throw new Error(a.join(" "))},b=function(e,t){e?.length&&"string"==typeof e||t.push("Must specify a non-empty string for value.")},v=function(e,t){Object.values(O.NameType).includes(e)||t.push(`Must specify one of the following types: ${Object.values(O.NameType).join(", ")}`)},k=function(e,t){null!==e&&(e?.length&&"string"==typeof e||t.push("Must specify a non-empty string or null for name."))},E=function(e,t,n){if(!e)return;const s=D(this,r,"m",_).call(this,t),i=[];for(const t of e)s.includes(t)||i.push(t);i.length&&n.push(`Unknown source IDs for type '${t}': ${i.join(", ")}`)},w=function(e,t,n,s){if(null===e||e===undefined)return;if(null===n)return void s.push(`Cannot specify a source ID when clearing the saved name: ${e}`);const i=D(this,r,"m",_).call(this,t);e.length&&"string"==typeof e?i.includes(e)||s.push(`Unknown source ID for type '${t}': ${e}`):s.push("Must specify a non-empty string for sourceId.")},T=function(e,t){const n=D(this,r,"m",_).call(this,e),s=n.filter((e,t)=>n.indexOf(e)!==t);s.length&&t.push(`Duplicate source IDs found for type '${e}': ${s.join(", ")}`)},A=function(e,t,r){t===O.NameType.ETHEREUM_ADDRESS&&(e?.length&&"string"==typeof e&&(e.match(/^0x[0-9A-Fa-f]+$/u)||e===n.FALLBACK_VARIATION)||r.push(`Must specify a chain ID in hexidecimal format or the fallback, "${n.FALLBACK_VARIATION}", for variation when using '${t}' type.`))},C=function(e,t,n){e&&(null!==t?Object.values(M).includes(e)||n.push(`Must specify one of the following origins: ${Object.values(M).join(", ")}`):n.push(`Cannot specify an origin when clearing the saved name: ${e}`))},_=function(e){return D(this,s,"f").map(t=>D(this,r,"m",x).call(this,t,e)).flat()},x=function(e,t){return e.getMetadata().sourceIds[t]},P=function(e,t){if(0===Object.keys(e).length)return;const n=D(this,r,"m",_).call(this,t),s=Object.keys(e).filter(e=>!n.includes(e));for(const t of s)delete e[t]},B=function(){const e=D(this,r,"m",p).call(this);this.update(t=>{const s=D(this,r,"m",S).call(this,t);for(const{nameType:r,value:i,variation:a,entry:o}of s){if(null!==o.name)continue;Object.values(o.proposedNames).every(t=>e-(t.lastRequestTime??0)>=n.PROPOSED_NAME_EXPIRE_DURATION)&&delete t.names[r][i][a]}})},S=function(e){return Object.entries(e.names).flatMap(([e,t])=>Object.entries(t).flatMap(([t,n])=>Object.entries(n).map(([n,r])=>({entry:r,nameType:e,value:t,variation:n}))))}}}},{package:"@metamask/name-controller",file:"node_modules/@metamask/name-controller/dist/NameController.cjs"}],[2019,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.ETHERSCAN_SUPPORTED_NETWORKS=n.CHAIN_IDS=void 0,n.CHAIN_IDS={MAINNET:"0x1",GOERLI:"0x5",BSC:"0x38",BSC_TESTNET:"0x61",OPTIMISM:"0xa",OPTIMISM_SEPOLIA:"0xaa37dc",POLYGON:"0x89",POLYGON_TESTNET:"0x13881",AVALANCHE:"0xa86a",AVALANCHE_TESTNET:"0xa869",FANTOM:"0xfa",FANTOM_TESTNET:"0xfa2",SEPOLIA:"0xaa36a7",LINEA_GOERLI:"0xe704",LINEA_SEPOLIA:"0xe705",LINEA_MAINNET:"0xe708",MOONBEAM:"0x504",MOONBEAM_TESTNET:"0x507",MOONRIVER:"0x505",GNOSIS:"0x64"};const r="etherscan.io",s="api";n.ETHERSCAN_SUPPORTED_NETWORKS={[n.CHAIN_IDS.GOERLI]:{domain:r,subdomain:`${s}-goerli`},[n.CHAIN_IDS.MAINNET]:{domain:r,subdomain:s},[n.CHAIN_IDS.SEPOLIA]:{domain:r,subdomain:`${s}-sepolia`},[n.CHAIN_IDS.LINEA_GOERLI]:{domain:"lineascan.build",subdomain:"goerli"},[n.CHAIN_IDS.LINEA_SEPOLIA]:{domain:"lineascan.build",subdomain:"sepolia"},[n.CHAIN_IDS.LINEA_MAINNET]:{domain:"lineascan.build",subdomain:s},[n.CHAIN_IDS.BSC]:{domain:"bscscan.com",subdomain:s},[n.CHAIN_IDS.BSC_TESTNET]:{domain:"bscscan.com",subdomain:`${s}-testnet`},[n.CHAIN_IDS.OPTIMISM]:{domain:r,subdomain:`${s}-optimistic`},[n.CHAIN_IDS.OPTIMISM_SEPOLIA]:{domain:r,subdomain:`${s}-sepolia-optimistic`},[n.CHAIN_IDS.POLYGON]:{domain:"polygonscan.com",subdomain:s},[n.CHAIN_IDS.POLYGON_TESTNET]:{domain:"polygonscan.com",subdomain:`${s}-mumbai`},[n.CHAIN_IDS.AVALANCHE]:{domain:"snowtrace.io",subdomain:s},[n.CHAIN_IDS.AVALANCHE_TESTNET]:{domain:"snowtrace.io",subdomain:`${s}-testnet`},[n.CHAIN_IDS.FANTOM]:{domain:"ftmscan.com",subdomain:s},[n.CHAIN_IDS.FANTOM_TESTNET]:{domain:"ftmscan.com",subdomain:`${s}-testnet`},[n.CHAIN_IDS.MOONBEAM]:{domain:"moonscan.io",subdomain:`${s}-moonbeam`},[n.CHAIN_IDS.MOONBEAM_TESTNET]:{domain:"moonscan.io",subdomain:`${s}-moonbase`},[n.CHAIN_IDS.MOONRIVER]:{domain:"moonscan.io",subdomain:`${s}-moonriver`},[n.CHAIN_IDS.GNOSIS]:{domain:"gnosisscan.io",subdomain:`${s}-gnosis`}}}}},{package:"@metamask/name-controller",file:"node_modules/@metamask/name-controller/dist/constants.cjs"}],[2020,{"./NameController.cjs":2018,"./providers/ens.cjs":2022,"./providers/etherscan.cjs":2023,"./providers/lens.cjs":2024,"./providers/token.cjs":2025,"./types.cjs":2026},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){r===undefined&&(r=n);var s=Object.getOwnPropertyDescriptor(t,n);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,r,s)}:function(e,t,n,r){r===undefined&&(r=n),e[r]=t[n]}),s=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||r(t,e,n)};Object.defineProperty(n,"__esModule",{value:!0}),s(e("./NameController.cjs"),n),s(e("./types.cjs"),n),s(e("./providers/ens.cjs"),n),s(e("./providers/etherscan.cjs"),n),s(e("./providers/token.cjs"),n),s(e("./providers/lens.cjs"),n)}}},{package:"@metamask/name-controller",file:"node_modules/@metamask/name-controller/dist/index.cjs"}],[2021,{"@metamask/utils":2656},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.createModuleLogger=n.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(n,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),n.projectLogger=(0,r.createProjectLogger)("name-controller")}}},{package:"@metamask/name-controller",file:"node_modules/@metamask/name-controller/dist/logger.cjs"}]],[],{});