LavaPack.loadBundle([[1965,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports={openrpc:"1.2.4",info:{title:"MetaMask MultiChain API",version:"1.0.0",description:"This provides the specs for the MultiChain API Layer for the MetaMask API"},methods:[{name:"wallet_notify",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"notification",description:"an object containing a JSON-RPC notification with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}]},{name:"wallet_invokeMethod",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"request",description:"an object containing a JSON-RPC request with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}],result:{name:"wallet_invokeMethodResult",schema:!0},examples:[{name:"wallet_invokeMethodExample",params:[{name:"scope",value:"eip155:1"},{name:"request",value:{method:"eth_getBalance",params:[]}}],result:{name:"wallet_invokeMethodResult",value:"0x1"}}]},{name:"wallet_revokeSession",description:"The `wallet_revokeSession` method revokes the entire active session.",params:[],result:{name:"wallet_revokeSessionResult",schema:{type:"boolean"}},examples:[{name:"wallet_revokeSessionExample",params:[],result:{name:"wallet_revokeSessionExampleResult",value:!0}}],errors:[{$ref:"#/components/errors/UnknownError"}]},{name:"wallet_sessionChanged",paramStructure:"by-name",description:"This notification is published by the wallet to notify the callers of updates to a shared session's authorization scopes. The event payload contains the new `sessionScopes`.",params:[{name:"sessionScopes",schema:{$ref:"#/components/schemas/SessionScopes"}}],examples:[{name:"wallet_sessionChangedExample",description:"Example of a wallet_sessionChanged notification.",params:[{name:"sessionScopes",value:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}]}]},{name:"wallet_getSession",description:"The `wallet_getSession` method returns an active session.",params:[],result:{name:"wallet_getSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"}}}},examples:[{name:"wallet_getSessionExample",description:"Example of a getSession request.",params:[],result:{name:"wallet_getSessionResultExample",value:{sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}}]},{name:"wallet_createSession",paramStructure:"by-name",params:[{name:"requiredScopes",description:"Scopes that the wallet must support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"optionalScopes",description:"Scopes that the wallet may support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"sessionProperties",description:"Properties that the wallet may use to determine if the session is valid.",schema:{type:"object"}}],result:{name:"wallet_createSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"},sessionProperties:{type:"object"}}}},examples:[{name:"wallet_createSessionEthExample",description:"Example of a createSession request.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{methods:["wallet_addEthereumChain"],notifications:[]}}}],result:{name:"wallet_createSessionResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionEthUnsupportedMethodsExample",description:"Example of a createSession request with unsupported eip155 methods.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["not_supported"],notifications:[]},wallet:{methods:[],notifications:[]},"wallet:eip155":{methods:[],notifications:[]}}}],result:{name:"wallet_createSessionEthUnsupportedMethodsResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionUnsupportedScopesExample",description:"Example of a createSession request with unsupported scopes.",params:[{name:"optionalScopes",value:{foobar:{methods:["eth_getBalance"],notifications:["eth_subscription"]},"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}],result:{name:"wallet_createSessionUnsupportedScopesResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}}}],errors:[{$ref:"#/components/errors/UnknownError"},{code:5100,message:"Requested networks are not supported"},{code:5101,message:"Requested methods are not supported"},{code:5102,message:"Requested notifications are not supported"},{code:5300,message:"Invalid scopedProperties requested"},{code:5301,message:"scopedProperties can only be outside of sessionScopes"},{code:5302,message:"Invalid sessionProperties requested"}]}],components:{errors:{UnknownError:{code:5e3,message:"Unknown error with request"}},schemas:{SessionScopes:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}},ScopeString:{type:"string",pattern:"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?"},Scope:{type:"object",title:"Scope",description:"Scope for a multi-chain connection",additionalProperties:!0,required:["notifications","methods"],properties:{scopes:{type:"array",items:{$ref:"#/components/schemas/ScopeString"}},methods:{description:"Methods that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},notifications:{description:"Notifications that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},rpcEndpoints:{description:"JSON-RPC endpoints for this namespace.",type:"array",items:{type:"string",format:"uri"}},rpcDocuments:{type:"array",description:"OpenRPC documents that define RPC methods in which to anchor the methods authorized in a CAIP-25 interaction.",items:{type:"string",format:"uri"}}}}}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json"}],[1966,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[1967,{"./build/multichain-openrpc.json":1965,"./build/openrpc.json":1966},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.MultiChainOpenRPCDocument=a.MetaMaskOpenRPCDocument=void 0;const n=s(e("./build/openrpc.json"));a.MetaMaskOpenRPCDocument=n.default;const r=s(e("./build/multichain-openrpc.json"));a.MultiChainOpenRPCDocument=r.default,a.default=n.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],[199,{"../../../../../shared/lib/delegation":5368,"../../../../../shared/lib/delegation/delegation":5365,"@metamask/transaction-controller":2637,"@metamask/utils":2682,"bignumber.js":3531},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.enforceSimulations=async function({messenger:e,transactionMeta:t,useRealSignature:a=!1}){c("Enforcing simulations",{transactionMeta:t,useRealSignature:a});const{chainId:r,simulationData:m={tokenBalanceChanges:[]},txParams:u}=t,p=u.from,h=(0,n.hexToNumber)(r),f=(0,i.getDeleGatorEnvironment)(h),b=f.DelegationManager,g=function(e,t){const a=e.call("AppStateController:getState"),s=a.enforcedSimulationsSlippage;return a.enforcedSimulationsSlippageForTransactions[t]??s}(e,t.id),y=function({accountAddress:e,environment:t,simulationData:a,slippage:n}){const r=function(e,t,a,n){const r=(0,i.createCaveatBuilder)(t),{nativeBalanceChange:o,tokenBalanceChanges:d=[]}=a;if(o){const{difference:t,isDecrease:a}=o,s=l(t,n,a);c("Caveat - Native Balance Change",{enforceDecrease:a,recipient:e,delta:BigInt(t),slippage:n,deltaWithSlippage:s}),r.addCaveat("nativeBalanceChange",a,e,s)}for(const t of d){const{difference:a,isDecrease:i,address:o,standard:d,id:m}=t,u=BigInt(a),p=l(a,n,i),h=m?BigInt(m):0n;switch(c("Caveat - Token Balance Change",{enforceDecrease:i,token:o,recipient:e,delta:u,slippage:n,deltaWithSlippage:p}),d){case s.SimulationTokenStandard.erc20:r.addCaveat("erc20BalanceChange",i,o,e,p);break;case s.SimulationTokenStandard.erc721:r.addCaveat("erc721BalanceChange",i,o,e,u);break;case s.SimulationTokenStandard.erc1155:r.addCaveat("erc1155BalanceChange",i,o,e,h,u);break;default:c("Unsupported token standard",d)}}return r.build()}(e,t,a,n);c("Caveats",r);const o=(0,i.createDelegation)({from:e,to:e,caveats:r});return o}({accountAddress:p,environment:f,simulationData:m,slippage:g});c("Delegation",y);let _=d;a&&(c("Signing delegation"),_=await e.call("DelegationController:signDelegation",{chainId:r,delegation:y}));c("Delegation signature",_);const w=function({transaction:e,delegation:t}){const a=[[t]],s=[i.SINGLE_DEFAULT_MODE],n=[[{target:e.to,callData:e.data??"0x",value:e.value?BigInt(e.value):0n}]];return(0,o.encodeRedeemDelegations)({delegations:a,modes:s,executions:n})}({transaction:u,delegation:{...y,signature:_}});return c("Data",w),{updateTransaction:e=>{e.txParams.data=w,e.txParams.to=b,e.txParams.value="0x0"}}};var s=e("@metamask/transaction-controller"),n=e("@metamask/utils"),r=e("bignumber.js"),i=e("../../../../../shared/lib/delegation"),o=e("../../../../../shared/lib/delegation/delegation");const c=(0,n.createProjectLogger)("enforced-simulations"),d="0x2261a7810ed3e9cde160895909e138e2f68adb2da86fcf98ea0840701df107721fb369ab9b52550ea98832c09f8185284aca4c94bd345e867a4f4461868dd7751b";function l(e,t,a){const s=new r.BigNumber(e),n=(100+(a?t:-t))/100;return BigInt(s.mul(n).toFixed(0))}}}},{package:"$root$",file:"app/scripts/lib/transaction/containers/enforced-simulations.ts"}],[20,{"../../../../shared/lib/delegation":5368,"@metamask/delegation-controller":1295,"@metamask/transaction-controller":2637},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.DelegationControllerInit=void 0,a.awaitDeleteDelegationEntry=o;var s=e("@metamask/delegation-controller"),n=e("@metamask/transaction-controller"),r=e("../../../../shared/lib/delegation");const i=e=>(0,r.getDeleGatorEnvironment)(Number(e));async function o(e,t,{hash:a,txMeta:s,entryToStore:r}){let{id:i}=s,o="continue";const c=({transactionMeta:s})=>{if(s.id===i)if(s.status===n.TransactionStatus.dropped&&s.replacedById)i=s.replacedById;else{switch(s.type){case n.TransactionType.contractInteraction:case n.TransactionType.retry:switch(s.status){case n.TransactionStatus.confirmed:o="delete";break;case n.TransactionStatus.dropped:case n.TransactionStatus.failed:case n.TransactionStatus.rejected:o="unsubscribe";break;default:return}break;case n.TransactionType.cancel:o="unsubscribe";break;default:return void console.warn("awaitDeleteDelegationEntry: Unexpected tx type",s.type)}"delete"===o&&(e.delete(a),r&&e.store({entry:r})),"unsubscribe"!==o&&"delete"!==o||t.unsubscribe("TransactionController:transactionStatusUpdated",c)}};t.subscribe("TransactionController:transactionStatusUpdated",c)}a.DelegationControllerInit=({controllerMessenger:e,persistedState:t,initMessenger:a})=>{const n=new s.DelegationController({messenger:e,state:t.DelegationController,hashDelegation:r.getDelegationHashOffchain,getDelegationEnvironment:i});return e.registerActionHandler("DelegationController:signDelegation",n.signDelegation.bind(n)),{controller:n,api:{signDelegation:n.signDelegation.bind(n),storeDelegationEntry:n.store.bind(n),listDelegationEntries:n.list.bind(n),getDelegationEntry:n.retrieve.bind(n),getDelegationEntryChain:n.chain.bind(n),deleteDelegationEntry:n.delete.bind(n),awaitDeleteDelegationEntry:o.bind(null,n,a)}}}}}},{package:"$root$",file:"app/scripts/controller-init/delegation/delegation-controller-init.ts"}],[200,{"./enforced-simulations":199,"@metamask/transaction-controller":2637,"@metamask/utils":2682,lodash:4410},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.applyTransactionContainers=c,a.applyTransactionContainersExisting=async function({containerTypes:e,transactionId:t,messenger:a,updateEditableParams:s}){const r=(await a.call("TransactionController:getState")).transactions.find(e=>e.id===t);if(!r)throw new Error(`Transaction with ID ${t} not found.`);const{updateTransaction:i}=await c({isApproved:!1,messenger:a,transactionMeta:r,types:e}),o=(0,n.cloneDeep)(r);i(o),s(t,{containerTypes:e,data:o.txParams.data,gas:o.txParams.gas,to:o.txParams.to,value:o.txParams.value})};var s=e("@metamask/transaction-controller"),n=e("lodash"),r=e("@metamask/utils"),i=e("./enforced-simulations");const o=(0,r.createProjectLogger)("transaction-containers");async function c({isApproved:e,messenger:t,transactionMeta:a,types:r}){const{txParamsOriginal:c}=a,d=(0,n.cloneDeep)(a);if(c&&(d.txParams=(0,n.cloneDeep)(c)),r.includes(s.TransactionContainerType.EnforcedSimulations)){const{updateTransaction:a}=await(0,i.enforceSimulations)({messenger:t,transactionMeta:d,useRealSignature:e});a(d)}let l;if(!e){const{gas:e}=await t.call("TransactionController:estimateGas",d.txParams,d.networkClientId,{ignoreDelegationSignatures:!0});o("Estimated gas",e),l=e}return{updateTransaction:e=>{e.containerTypes=r,e.txParams=(0,n.cloneDeep)(d.txParams),l&&(e.txParams.gas=l)}}}}}},{package:"$root$",file:"app/scripts/lib/transaction/containers/util.ts"}],[201,{"../../../../../shared/lib/four-byte":5372,"@ethersproject/abi":552,"@metamask/utils":2682,"ethereumjs-util":3897},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.decodeTransactionDataWithFourByte=async function(e){const t=e.slice(0,10),a=await(0,i.getMethodFrom4Byte)(t);if(!a)return undefined;const r=a.split("(")[0],m=function(e){let t=e.slice(e.indexOf("(")+1,-1);const a=[];for(;t.includes("(");){const e=l(t);if(!e)break;a.push(e.value),t=`${t.slice(0,e.start)}${a.length-1}#${t.slice(e.end+1)}`}return d(t,a)}(a);o("Generated inputs",m);const u=(0,s.addHexPrefix)(e.slice(10)),p=n.Interface.getAbiCoder().decode(m,u),h=m.map((e,t)=>c(e,t,p));return{name:r,params:h}};var s=e("ethereumjs-util"),n=e("@ethersproject/abi"),r=e("@metamask/utils"),i=e("../../../../../shared/lib/four-byte");const o=(0,r.createProjectLogger)("four-byte");function c(e,t,a){var s;const n=a[t],{type:r,name:i}=e;let o=null===(s=e.components)||void 0===s?void 0:s.map((e,t)=>c(e,t,n));if(r.endsWith("[]")){const t=r.slice(0,-2);o=n.map((a,s)=>{const r=`Item ${s+1}`;return c({...e,name:r,type:t},s,n)})}return{name:i,type:r,value:n,children:o}}function d(e,t){return e.split(",").map(e=>{const a=e.split("#"),s=a.length>1?parseInt(a[0],10):undefined;return{type:s===undefined?e:`tuple${a[1]??""}`,components:s===undefined?undefined:d(t[s],t)}})}function l(e){let t=-1;for(let a=0;a<e.length;a++)if("("===e[a])t=a;else if(")"===e[a]&&-1!==t)return{start:t,end:a,value:e.slice(t+1,a)};return undefined}}}},{package:"$root$",file:"app/scripts/lib/transaction/decode/four-byte.ts"}],[202,{"ethereumjs-util":3897},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getContractProxyAddress=async function(e,t){const a=(await Promise.all(n.map(a=>t.request({method:"eth_getStorageAt",params:[e,a,"latest"]})))).find(e=>(0,s.stripHexPrefix)(e)!==r);return a&&(0,s.addHexPrefix)(a.slice(26))};var s=e("ethereumjs-util");const n=["0x7050c9e0f4ca769c69bd3a8ef740bc37934f8e2c036e5a723fd8ee048ed3f8c3","0x360894a13ba1a3210667c828492db98dca3e2076cc3735a920a3ca505d382bbc"],r="0".padEnd(64,"0")}}},{package:"$root$",file:"app/scripts/lib/transaction/decode/proxy.ts"}],[203,{"@ethersproject/abi":552,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.decodeTransactionDataWithSourcify=async function(e,t,a){var o,c;const d=await async function(e,t){var a;const s=await async function(e,t){const a=parseInt(t,16),s=await fetch(`https://sourcify.dev/server/files/any/${a}/${e}`);if(!s.ok)throw new Error("Failed to fetch Sourcify files");return s.json()}(e,t),n=null===(a=s.files)||void 0===a?void 0:a.find(e=>e.name.includes("metadata.json"));if(!n)throw new Error("Metadata not found");return JSON.parse(n.content)}(t,a);n("Retrieved Sourcify metadata",{contractAddress:t,chainId:a,metadata:d});const{abi:l}=d.output,m=new s.Interface(l),u=e.slice(0,10);let p;try{p=m.getFunction(u)}catch(e){}if(!p)return n("Failed to find function in ABI",u,l),undefined;const{name:h,inputs:f}=p,b=i(h,f),g=null===(o=d.output.userdoc)||void 0===o?void 0:o.methods[b],y=null===(c=d.output.devdoc)||void 0===c?void 0:c.methods[b],_=(null==g?void 0:g.notice)??(null==y?void 0:y.details);n("Extracted NatSpec",{signature:b,userDoc:g,devDoc:y});const w=m.decodeFunctionData(u,e),v=f.map((e,t)=>r(e,t,w,g,y));return{name:h,description:_,params:v}};var s=e("@ethersproject/abi");const n=(0,e("@metamask/utils").createProjectLogger)("sourcify");function r(e,t,a,s,n){var i,o;const{name:c,type:d,components:l}=e,m=(null==s||null===(i=s.params)||void 0===i?void 0:i[c])??(null==n||null===(o=n.params)||void 0===o?void 0:o[c]),u=a[t];let p=null==l?void 0:l.map((e,t)=>r(e,t,u,{},{}));if(d.endsWith("[]")){const t=d.slice(0,-2);p=u.map((a,s)=>{const n=`Item ${s+1}`;return r({...e,name:n,type:t},s,u,{},{})})}return{name:c,description:m,type:d,value:u,children:p}}function i(e,t){return`${e??""}(${t.map(e=>{var t;return null!==(t=e.components)&&void 0!==t&&t.length?`${i(undefined,e.components)}${e.type.endsWith("[]")?"[]":""}`:e.type}).join(",")})`}}}},{package:"$root$",file:"app/scripts/lib/transaction/decode/sourcify.ts"}],[204,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.UNISWAP_ROUTER_COMMANDS=void 0;a.UNISWAP_ROUTER_COMMANDS={0:{name:"V3_SWAP_EXACT_IN",params:[{type:"address",description:"The recipient of the output of the trade",name:"recipient"},{type:"uint256",description:"The amount of input tokens for the trade",name:"amountIn"},{type:"uint256",description:"The minimum amount of output tokens the user wants",name:"amountOutMin"},{type:"bytes",description:"The UniswapV3 encoded path to trade along",name:"path"},{type:"bool",description:"A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter",name:"payerIsUser"}]},1:{name:"V3_SWAP_EXACT_OUT",params:[{type:"address",description:"The recipient of the output of the trade",name:"recipient"},{type:"uint256",description:"The amount of output tokens to receive",name:"amountOut"},{type:"uint256",description:"The maximum number of input tokens that should be spent",name:"amountInMax"},{type:"bytes",description:"The UniswapV3 encoded path to trade along",name:"path"},{type:"bool",description:"A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter",name:"payerIsUser"}]},2:{name:"PERMIT2_TRANSFER_FROM",params:[{type:"address",description:"The token to fetch from Permit2",name:"token"},{type:"address",description:"The recipient of the tokens fetched",name:"recipient"},{type:"uint256",description:"The amount of token to fetch",name:"amount"}]},3:{name:"PERMIT2_PERMIT_BATCH",params:[{type:"bytes",description:"A PermitBatch struct outlining all of the Permit2 permits to execute.",name:"batch"},{type:"bytes",description:"The signature to provide to Permit2",name:"data"}]},4:{name:"SWEEP",params:[{type:"address",description:"The ERC20 token to sweep (or Constants.ETH for ETH)",name:"token"},{type:"address",description:"The recipient of the sweep",name:"recipient"},{type:"uint256",description:"The minimum required tokens to receive from the sweep",name:"amountMin"}]},5:{name:"TRANSFER",params:[{type:"address",description:"The ERC20 token to transfer (or Constants.ETH for ETH)",name:"token"},{type:"address",description:"The recipient of the transfer",name:"recipient"},{type:"uint256",description:"The amount to transfer",name:"value"}]},6:{name:"PAY_PORTION",params:[{type:"address",description:"The ERC20 token to transfer (or Constants.ETH for ETH)",name:"token"},{type:"address",description:"The recipient of the transfer",name:"recipient"},{type:"uint256",description:"In basis points, the percentage of the contract’s balance to transfer",name:"bips"}]},8:{name:"V2_SWAP_EXACT_IN",params:[{type:"address",description:"The recipient of the output of the trade",name:"recipient"},{type:"uint256",description:"The amount of input tokens for the trade",name:"amountIn"},{type:"uint256",description:"The minimum amount of output tokens the user wants",name:"amountOutMin"},{type:"address[]",description:"The UniswapV2 token path to trade along",name:"path"},{type:"bool",description:"A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter",name:"payerIsUser"}]},9:{name:"V2_SWAP_EXACT_OUT",params:[{type:"address",description:"The recipient of the output of the trade",name:"recipient"},{type:"uint256",description:"The amount of output tokens to receive",name:"amountOut"},{type:"uint256",description:"The maximum number of input tokens that should be spent",name:"amountInMax"},{type:"address[]",description:"The UniswapV2 token path to trade along",name:"path"},{type:"bool",description:"A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter",name:"payerIsUser"}]},10:{name:"PERMIT2_PERMIT",params:[{type:"bytes",description:"A PermitSingle struct outlining the Permit2 permit to execute",name:"permitSingle"},{type:"bytes",description:"The signature to provide to Permit2",name:"signature"}]},11:{name:"WRAP_ETH",params:[{type:"address",description:"The recipient of the WETH",name:"recipient"},{type:"uint256",description:"The amount of ETH to wrap",name:"amountMin"}]},12:{name:"UNWRAP_WETH",params:[{type:"address",description:"The recipient of the ETH",name:"recipient"},{type:"uint256",description:"The minimum required ETH to receive from the unwrapping",name:"amountMin"}]},13:{name:"PERMIT2_TRANSFER_FROM_BATCH",params:[{type:"bytes",description:"An array of AllowanceTransferDetails structs that each describe a Permit2 transfer to perform",name:"batchDetails"}]},16:{name:"SEAPORT",params:[{type:"uint256",description:"The ETH value to forward to the Seaport contract",name:"value"},{type:"bytes",description:"The calldata to use to call the Seaport contract",name:"data"}]},17:{name:"LOOKS_RARE_721",params:[{type:"uint256",description:"The ETH value to forward to the LooksRare contract",name:"value"},{type:"bytes",description:"The calldata to use to call the LooksRare contract",name:"data"},{type:"address",description:"The recipient of the ERC721",name:"recipient"},{type:"address",description:"The ERC721 token address",name:"token"},{type:"uint256",description:"The ID of the ERC721",name:"id"}]},18:{name:"NFTX",params:[{type:"uint256",description:"The ETH value to forward to the NFTX contract",name:"value"},{type:"bytes",description:"The calldata to use to call the NFTX contract",name:"data"}]},19:{name:"CRYPTOPUNKS",params:[{type:"uint256",description:"The PunkID to purchase",name:"punkId"},{type:"address",description:"The recipient for the cryptopunk",name:"recipient"},{type:"uint256",description:"The ETH value to forward to the Cryptopunks contract",name:"value"}]},20:{name:"LOOKS_RARE_1155",params:[{type:"uint256",description:"The ETH value to forward to the LooksRare contract",name:"value"},{type:"bytes",description:"The calldata to use to call the LooksRare contract",name:"data"},{type:"address",description:"The recipient of the ERC1155",name:"recipient"},{type:"address",description:"The ERC1155 token address",name:"token"},{type:"uint256",description:"The ID of the ERC1155",name:"id"},{type:"uint256",description:"The amount of the ERC1155 to transfer",name:"amount"}]},21:{name:"OWNER_CHECK_721",params:[{type:"address",description:"The required owner of the ERC721",name:"owner"},{type:"address",description:"The ERC721 token address",name:"token"},{type:"uint256",description:"The ID of the ERC721",name:"id"}]},22:{name:"OWNER_CHECK_1155",params:[{type:"address",description:"The required owner of the ERC1155",name:"owner"},{type:"address",description:"The ERC721 token address",name:"token"},{type:"uint256",description:"The ID of the ERC1155",name:"id"},{type:"uint256",description:"The minimum required amount of the ERC1155",name:"minBalance"}]},23:{name:"SWEEP_ERC721",params:[{type:"address",description:"The ERC721 token address to transfer",name:"token"},{type:"address",description:"The recipient of the transfer",name:"recipient"},{type:"uint256",description:"The token ID to transfer",name:"id"}]},24:{name:"X2Y2_721",params:[{type:"uint256",description:"The ETH value to forward to the X2Y2 contract",name:"value"},{type:"bytes",description:"The calldata to use to call the X2Y2 contract",name:"data"},{type:"address",description:"The recipient of the ERC721",name:"recipient"},{type:"address",description:"The ERC721 token address",name:"token"},{type:"uint256",description:"The ID of the ERC721",name:"id"}]},25:{name:"SUDOSWAP",params:[{type:"uint256",description:"The ETH value to forward to the Sudoswap contract",name:"value"},{type:"bytes",description:"The calldata to use to call the Sudoswap contract",name:"data"}]},26:{name:"NFT20",params:[{type:"uint256",description:"The ETH value to forward to the NFT20 contract",name:"value"},{type:"bytes",description:"The calldata to use to call the NFT20 contract",name:"data"}]},27:{name:"X2Y2_1155",params:[{type:"uint256",description:"The ETH value to forward to the X2Y2 contract",name:"value"},{type:"bytes",description:"The calldata to use to call the X2Y2 contract",name:"data"},{type:"address",description:"The recipient of the ERC1155",name:"recipient"},{type:"address",description:"The ERC1155 token address",name:"token"},{type:"uint256",description:"The ID of the ERC1155",name:"id"},{type:"uint256",description:"The amount of the ERC1155 to transfer",name:"amount"}]},28:{name:"FOUNDATION",params:[{type:"uint256",description:"The ETH value to forward to the Foundation contract",name:"value"},{type:"bytes",description:"The calldata to use to call the Foundation contract",name:"data"},{type:"address",description:"The recipient of the ERC721",name:"recipient"},{type:"address",description:"The ERC721 token address",name:"token"},{type:"uint256",description:"The ID of the ERC721",name:"id"}]},29:{name:"SWEEP_ERC1155",params:[{type:"address",description:"The ERC1155 token address to sweep",name:"token"},{type:"address",description:"The recipient of the sweep",name:"recipient"},{type:"uint256",description:"The token ID to sweep",name:"id"},{type:"uint256",description:"The minimum required tokens to receive from the sweep",name:"amount"}]}}}}},{package:"$root$",file:"app/scripts/lib/transaction/decode/uniswap-commands.ts"}],[205,{"../../../../../shared/constants/network":5310,"./uniswap-commands":204,"@ethersproject/abi":552,"ethereumjs-util":3897},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.UNISWAP_UNIVERSAL_ROUTER_ADDRESSES=void 0,a.decodeUniswapRouterTransactionData=function({transactionData:e,contractAddress:t,chainId:a}){const r=d[a];if(null==r||!r.map(e=>e.toLowerCase()).includes(t.toLowerCase()))return undefined;const m=new s.Interface(l);let u;try{u=m.parseTransaction({data:e})}catch(e){return undefined}const p=u.args.commands,h=u.args.inputs;return p.slice(2).match(/.{1,2}/gu).map((e,t)=>function(e,t){const a=parseInt(e,16),r=31&a,d=i.UNISWAP_ROUTER_COMMANDS[String(r)];if(!d)return undefined;const l=d.params.map(e=>e.type),m=s.Interface.getAbiCoder().decode(l,t),{name:u}=d,p=d.params.map((e,t)=>{const{name:a,type:s,description:r}=e,i=m[t];return{name:a,type:s,value:"path"===a?function(e){const t=[];let a=(0,n.stripHexPrefix)(e),s={},r=!0;for(;a.length;){if(r){const e=(0,n.addHexPrefix)(a.slice(0,o));s.firstAddress?(s.secondAddress=e,t.push(s),s={firstAddress:e}):s.firstAddress=e,a=a.slice(o)}else s.tickSpacing=parseInt(a.slice(0,c),16),a=a.slice(c);r=!r}return t}(i):i,description:r}});return{name:u,params:p}}(e,h[t])).filter(e=>e!==undefined)};var s=e("@ethersproject/abi"),n=e("ethereumjs-util"),r=e("../../../../../shared/constants/network"),i=e("./uniswap-commands");const o=40,c=6,d=a.UNISWAP_UNIVERSAL_ROUTER_ADDRESSES={[r.CHAIN_IDS.ARBITRUM]:["0x4C60051384bd2d3C01bfc845Cf5F4b44bcbE9de5","0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4","0x5E325eDA8064b456f4781070C0738d849c824258"],[r.CHAIN_IDS.AVALANCHE]:["0x82635AF6146972cD6601161c4472ffe97237D292","0x4Dae2f939ACf50408e13d58534Ff8c2776d45265"],[r.CHAIN_IDS.BASE]:["0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4","0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD"],[r.CHAIN_IDS.BSC]:["0x5Dc88340E1c5c6366864Ee415d6034cadd1A9897","0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4","0x4Dae2f939ACf50408e13d58534Ff8c2776d45265"],[r.CHAIN_IDS.MAINNET]:["0xEf1c6E67703c7BD7107eed8303Fbe6EC2554BF6B","0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD"],[r.CHAIN_IDS.OPTIMISM]:["0xb555edF5dcF85f42cEeF1f3630a52A108E55A654","0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4","0xCb1355ff08Ab38bBCE60111F1bb2B784bE25D7e8"],[r.CHAIN_IDS.POLYGON]:["0x4C60051384bd2d3C01bfc845Cf5F4b44bcbE9de5","0x643770E279d5D0733F21d6DC03A8efbABf3255B4","0xec7BE89e9d109e7e3Fec59c222CF297125FEFda2"],[r.CHAIN_IDS.SEPOLIA]:["0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD"]},l=[{constant:!0,inputs:[{name:"commands",type:"bytes"},{name:"inputs",type:"bytes[]"},{name:"deadline",type:"uint256"}],name:"execute",type:"function"},{constant:!0,inputs:[{name:"commands",type:"bytes"},{name:"inputs",type:"bytes[]"}],name:"execute",type:"function"}]}}},{package:"$root$",file:"app/scripts/lib/transaction/decode/uniswap.ts"}],[206,{"../../../../../shared/types/transaction-decode":5426,"./four-byte":201,"./proxy":202,"./sourcify":203,"./uniswap":205,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.decodeTransactionData=async function({transactionData:e,contractAddress:t,chainId:a,provider:s}){d("Decoding transaction data",{transactionData:e,contractAddress:t,chainId:a});const m=(0,r.decodeUniswapRouterTransactionData)({transactionData:e,contractAddress:t,chainId:a});if(m)return d("Decoded with Uniswap commands",m),{data:l(m),source:n.DecodedTransactionDataSource.Uniswap};const u=await(0,o.getContractProxyAddress)(t,s);u&&d("Retrieved proxy implementation address",u);const p=u??t,h=(0,i.decodeTransactionDataWithSourcify)(e,p,a),f=(0,c.decodeTransactionDataWithFourByte)(e),[b,g]=await Promise.allSettled([h,f]);if("fulfilled"===b.status&&b.value)return d("Decoded data with Sourcify",b.value),{data:l([b.value]),source:n.DecodedTransactionDataSource.Sourcify};if(d("Failed to decode data with Sourcify",b),"fulfilled"===g.status&&g.value)return d("Decoded data with 4Byte",g.value),{data:l([g.value]),source:n.DecodedTransactionDataSource.FourByte};return d("Failed to decode data with 4Byte",g),undefined};var s=e("@metamask/utils"),n=e("../../../../../shared/types/transaction-decode"),r=e("./uniswap"),i=e("./sourcify"),o=e("./proxy"),c=e("./four-byte");const d=(0,s.createProjectLogger)("transaction-decode");function l(e){return e.map(e=>function(e){return{...e,params:e.params.map(e=>m(e))}}(e))}function m(e){var t;return{...e,value:u(e.value),children:null===(t=e.children)||void 0===t?void 0:t.map(e=>m(e))}}function u(e){const t=e._hex;return t?BigInt(t).toString():e}}}},{package:"$root$",file:"app/scripts/lib/transaction/decode/util.ts"}],[207,{"@ethersproject/abi":552,"@metamask/keyring-controller":1891,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ROOT_AUTHORITY=a.ExecutionMode=a.ANY_BENEFICIARY=void 0,a.encodeRedeemDelegations=function(e,t,a){return new r.Interface(l).encodeFunctionData("redeemDelegations",[u(e),t,(s=a,s.map(p))]);var s},a.signDelegation=async function({chainId:e,delegation:t,from:a,messenger:r}){const c={types:m,primaryType:i,domain:{chainId:String((0,s.hexToNumber)(e)),name:o,version:"1",verifyingContract:"0xdb9B1e94B5b69Df7e401DDbedE43491141047dB3"},message:{...t,chainId:(0,s.hexToNumber)(e)}};return await r.call("KeyringController:signTypedMessage",{from:a,data:c},n.SignTypedDataVersion.V4)};var s=e("@metamask/utils"),n=e("@metamask/keyring-controller"),r=e("@ethersproject/abi");a.ExecutionMode=function(e){return e.BATCH_DEFAULT_MODE="0x0100000000000000000000000000000000000000000000000000000000000000",e}({});a.ROOT_AUTHORITY="0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",a.ANY_BENEFICIARY="0x0000000000000000000000000000000000000a11";const i="Delegation",o="DelegationManager",c=[{type:"address",name:"delegate"},{type:"address",name:"delegator"},{type:"bytes32",name:"authority"},{type:"tuple[]",name:"caveats",components:[{type:"address",name:"enforcer"},{type:"bytes",name:"terms"},{type:"bytes",name:"args"}]},{type:"uint256",name:"salt"},{type:"bytes",name:"signature"}],d=[{type:"address",name:"target"},{type:"uint256",name:"value"},{type:"bytes",name:"callData"}],l=[{type:"function",name:"redeemDelegations",inputs:[{name:"_permissionContexts",type:"bytes[]",internalType:"bytes[]"},{name:"_modes",type:"bytes32[]",internalType:"ModeCode[]"},{name:"_executionCallDatas",type:"bytes[]",internalType:"bytes[]"}],outputs:[],stateMutability:"nonpayable"}],m={EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Caveat:[{name:"enforcer",type:"address"},{name:"terms",type:"bytes"}],Delegation:[{name:"delegate",type:"address"},{name:"delegator",type:"address"},{name:"authority",type:"bytes32"},{name:"caveats",type:"Caveat[]"},{name:"salt",type:"uint256"}]};function u(e){return e.map(e=>{return t=e,r.defaultAbiCoder.encode([r.ParamType.from({components:c,name:"delegations",type:"tuple[]"})],[t]);var t})}function p(e){return r.defaultAbiCoder.encode([r.ParamType.from({components:d,name:"executions",type:"tuple[]"})],[e])}}}},{package:"$root$",file:"app/scripts/lib/transaction/delegation.ts"}],[208,{"../../../../shared/constants/app":5294,"../../../../shared/constants/keyring":5303,"../../../../shared/constants/transaction":5327,"../ppom/ppom-util":159,"@metamask/eth-json-rpc-middleware":1702,"@metamask/rpc-errors":2283,"@metamask/transaction-controller":2637,"@metamask/utils":2682,uuid:5243},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.AtomicCapabilityStatus=void 0,a.getCallsStatus=function(e,t){const a=e.call("TransactionController:getState").transactions.filter(e=>e.batchId===t);if(null==a||!a.length)throw new s.JsonRpcError(c.EIP5792ErrorCode.UnknownBundleId,"No matching bundle found");const r=a[0],{chainId:o,txReceipt:d}=r,l=function(e){const{hash:t,status:a}=e;if(a===n.TransactionStatus.confirmed)return i.GetCallsStatusCode.CONFIRMED;if(a===n.TransactionStatus.failed)return t?i.GetCallsStatusCode.REVERTED:i.GetCallsStatusCode.FAILED_OFFCHAIN;if(a===n.TransactionStatus.dropped)return i.GetCallsStatusCode.REVERTED;return i.GetCallsStatusCode.PENDING}(r),m=d,u=(null==m?void 0:m.logs)??[],h=m&&[{blockHash:m.blockHash,blockNumber:m.blockNumber,gasUsed:m.gasUsed,logs:u.map(e=>({address:e.address,data:e.data,topics:e.topics})),status:m.status,transactionHash:m.transactionHash}];return{version:p,id:t,chainId:o,atomic:!0,status:l,receipts:h}},a.getCapabilities=async function(e,t,a,s){var n;const{getDismissSmartAccountSuggestionEnabled:r,getIsSmartTransaction:i,isAtomicBatchSupported:o,isRelaySupported:c,getSendBundleSupportedChains:d}=e;let m=null==s?void 0:s.map(e=>e.toLowerCase());if(null===(n=m)||void 0===n||!n.length){const e=t.call("NetworkController:getState").networkConfigurationsByChainId;m=Object.keys(e)}const p=await o({address:a,chainIds:m}),h=await async function(e,t,a,s,n,r){const i=r.call("PreferencesController:getState").useTransactionSimulations,o=await Promise.all(t.map(({chainId:e})=>e).map(e=>s(e))),c=await n(e),d=t.map((e,t)=>({...e,relaySupportedForChain:o[t]}));return e.reduce((e,t)=>{const s=d.find(({chainId:e})=>e===t)??{},{isSupported:n=!1,relaySupportedForChain:r}=s,o=a(t),l=c[t]??!1;return i&&(o&&l||n&&r)&&(e[t]={alternateGasFees:{supported:!0}}),e},{})}(m,p,i,c,d,t);return m.reduce((e,s)=>{const n=p.find(({chainId:e})=>e===s)??{},{delegationAddress:i,isSupported:o,upgradeContractAddress:c}=n,d=r();let m=!1;try{const e=g(a,t);m=l.KEYRING_TYPES_SUPPORTING_7702.includes(e)}catch(e){}if(!o&&!(!d&&c&&!i&&m))return e;const h=o?u.Supported:u.Ready;return e[s]===undefined&&(e[s]={}),e[s].atomic={status:h},e},h)},a.processSendCalls=async function(e,t,a,i){const{addTransactionBatch:u,addTransaction:p,getDismissSmartAccountSuggestionEnabled:y,isAtomicBatchSupported:_,validateSecurity:w}=e,{calls:v,from:T}=a,{networkClientId:E,origin:P}=i,S=v.map(e=>({params:e})),{chainId:k}=t.call("NetworkController:getNetworkClientById",E).configuration,x=T??t.call("AccountsController:getSelectedAccount").address,C=(0,m.generateSecurityAlertId)(),A=w.bind(null,C);let M;M=1===Object.keys(S).length?await async function({addTransaction:e,chainId:t,from:a,networkClientId:s,origin:i,securityAlertId:c,sendCalls:l,transactions:m,validateSecurity:u}){!function(e,t){h(e),b(e),f(e,t)}(l,t);const p={from:a,...m[0].params,type:n.TransactionEnvelopeType.feeMarket},g={method:d.MESSAGE_TYPE.ETH_SEND_TRANSACTION,params:[p],origin:i};u(g,t);const y=function(){const e=(0,o.v4)(),t=new Uint8Array((0,o.parse)(e));return(0,r.bytesToHex)(t)}();return await e(p,{networkClientId:s,origin:i,securityAlertResponse:{securityAlertId:c},batchId:y}),y}({addTransaction:p,chainId:k,from:x,networkClientId:E,origin:P,securityAlertId:C,sendCalls:a,transactions:S,validateSecurity:A}):await async function({addTransactionBatch:e,isAtomicBatchSupported:t,chainId:a,from:n,getDismissSmartAccountSuggestionEnabled:r,networkClientId:i,messenger:o,origin:d,sendCalls:m,securityAlertId:u,transactions:p,validateSecurity:y}){const _=await t({address:n,chainIds:[a]}),w=null==_?void 0:_[0],v=g(n,o),T=r();!function(e,t,a,n,r){h(e),function(e,t,a){if(f(e,t),!a)throw new s.JsonRpcError(c.EIP5792ErrorCode.UnsupportedChainId,`EIP-7702 not supported on chain: ${t}`)}(e,t,n),b(e),function(e,t,a){if(null!=t&&t.delegationAddress)return;if(e)throw new s.JsonRpcError(c.EIP5792ErrorCode.RejectedUpgrade,"EIP-7702 upgrade disabled by the user");if(!l.KEYRING_TYPES_SUPPORTING_7702.includes(a))throw new s.JsonRpcError(c.EIP5792ErrorCode.RejectedUpgrade,"EIP-7702 upgrade not supported on account")}(a,n,r)}(m,a,T,w,v);const E=await e({from:n,networkClientId:i,origin:d,securityAlertId:u,transactions:p,validateSecurity:y});return E.batchId}({addTransactionBatch:u,isAtomicBatchSupported:_,chainId:k,from:x,getDismissSmartAccountSuggestionEnabled:y,messenger:t,networkClientId:E,origin:P,sendCalls:a,securityAlertId:C,transactions:S,validateSecurity:A});return{id:M}};var s=e("@metamask/rpc-errors"),n=e("@metamask/transaction-controller"),r=e("@metamask/utils"),i=e("@metamask/eth-json-rpc-middleware"),o=e("uuid"),c=e("../../../../shared/constants/transaction"),d=e("../../../../shared/constants/app"),l=e("../../../../shared/constants/keyring"),m=e("../ppom/ppom-util");let u=a.AtomicCapabilityStatus=function(e){return e.Supported="supported",e.Ready="ready",e.Unsupported="unsupported",e}({});const p="2.0.0";function h(e){const{version:t}=e;if(t!==p)throw s.rpcErrors.invalidInput(`Version not supported: Got ${t}, expected ${p}`)}function f(e,t){const{chainId:a}=e;if(a&&a.toLowerCase()!==t.toLowerCase())throw s.rpcErrors.invalidParams(`Chain ID must match the dApp selected network: Got ${a}, expected ${t}`)}function b(e){const{calls:t,capabilities:a}=e,n=[...Object.keys(a??{}).filter(e=>!0!==(null==a?void 0:a[e].optional)),...t.flatMap(e=>Object.keys(e.capabilities??{}).filter(t=>{var a;return!0!==(null===(a=e.capabilities)||void 0===a?void 0:a[t].optional)}))];if(null!=n&&n.length)throw new s.JsonRpcError(c.EIP5792ErrorCode.UnsupportedNonOptionalCapability,`Unsupported non-optional capabilities: ${n.join(", ")}`)}function g(e,t){var a;const{accounts:n}=t.call("AccountsController:getState").internalAccounts,r=Object.values(n).find(t=>t.address.toLowerCase()===e.toLowerCase()),i=null==r||null===(a=r.metadata)||void 0===a||null===(a=a.keyring)||void 0===a?void 0:a.type;if(!i)throw new s.JsonRpcError(c.EIP5792ErrorCode.RejectedUpgrade,"EIP-7702 upgrade not supported as account type is unknown");return i}}}},{package:"$root$",file:"app/scripts/lib/transaction/eip5792.ts"}],[209,{"../delegation":207,"../transaction-relay":213,"@ethersproject/abi":552,"@metamask/metamask-eth-abis":1946,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.Delegation7702PublishHook=void 0;var s=e("@metamask/utils"),n=e("@metamask/metamask-eth-abis"),r=e("@ethersproject/abi"),i=e("../delegation"),o=e("../transaction-relay");function c(e,t,a){d(e,t),t.set(e,a)}function d(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function l(e,t){return e.get(u(e,t))}function m(e,t,a){return e.set(u(e,t),a),a}function u(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}const p="0x",h={transactionHash:undefined},f=(0,s.createProjectLogger)("delegation-7702-publish-hook");var b=new WeakMap,g=new WeakMap,y=new WeakSet;async function _(e,t){try{return await u(y,this,w).call(this,e,t)}catch(e){throw f("Error",e),e}}async function w(e,t){const{chainId:a,gasFeeTokens:s,selectedGasFeeToken:n,txParams:r}=e,{from:c}=r,d=(await l(b,this).call(this,{address:c,chainIds:[a]})).find(e=>e.chainId.toLowerCase()===a.toLowerCase());if(!(d&&(!d.delegationAddress||d.isSupported)))return f("Skipping as EIP-7702 is not supported",{from:c,chainId:a}),h;const{delegationAddress:m,upgradeContractAddress:p}=d;if(!n||null==s||!s.length)return f("Skipping as no selected gas fee token"),h;const g=s.find(e=>e.tokenAddress.toLowerCase()===n.toLowerCase());if(!g)throw new Error("Selected gas fee token not found");const _=await u(y,this,T).call(this,e,g),w=u(y,this,v).call(this,e,g),E=(0,i.encodeRedeemDelegations)([[_]],[i.ExecutionMode.BATCH_DEFAULT_MODE],[w]),S={chainId:a,data:E,to:"0xdb9B1e94B5b69Df7e401DDbedE43491141047dB3"};m||(S.authorizationList=await u(y,this,P).call(this,e,p)),f("Relay request",S);const{uuid:k}=await(0,o.submitRelayTransaction)(S),{transactionHash:x,status:C}=await(0,o.waitForRelayResult)({chainId:a,uuid:k,interval:1e3});if(C!==o.RelayStatus.Success)throw new Error(`Transaction relay error - ${C}`);return{transactionHash:x}}function v(e,t){const{txParams:a}=e,{data:s,to:n,value:r}=a;return[{target:n,value:r??"0x0",callData:s??p},{target:t.tokenAddress,value:"0x0",callData:u(y,this,S).call(this,t.recipient,t.amount)}]}async function T(e,t){const{chainId:a,txParams:s}=e,{from:n}=s,r=u(y,this,E).call(this,s,t);f("Caveats",r);const o={authority:i.ROOT_AUTHORITY,caveats:r,delegate:i.ANY_BENEFICIARY,delegator:n,salt:(new Date).getTime()};f("Unsigned delegation",o);const c=await(0,i.signDelegation)({chainId:a,delegation:o,from:n,messenger:l(g,this)});return f("Delegation signature",c),{...o,signature:c}}function E(e,t){const{amount:a,recipient:n,tokenAddress:r}=t,{data:i,to:o}=e,c=(0,s.add0x)((0,s.remove0x)(a).padStart(64,"0"));return[{enforcer:"0x00e0251aaA263dfE3B3541B758A82D1CBA1c3B6D",terms:(0,s.add0x)([r,n,c,o,i??p].map(s.remove0x).join("")),args:p}]}async function P(e,t){const{chainId:a,txParams:s}=e,{from:n,nonce:r}=s;if(f("Including authorization as not upgraded"),!t)throw new Error("Upgrade contract address not found");const i=await l(g,this).call("KeyringController:signEip7702Authorization",{chainId:parseInt(a,16),contractAddress:t,from:n,nonce:parseInt(r,16)}),{r:o,s:c,yParity:d}=u(y,this,k).call(this,i);return f("Authorization signature",{authorizationSignature:i,r:o,s:c,yParity:d}),[{address:t,chainId:a,nonce:r,r:o,s:c,yParity:d}]}function S(e,t){return new r.Interface(n.abiERC20).encodeFunctionData("transfer",[e,t])}function k(e){return{r:e.slice(0,66),s:`0x${e.slice(66,130)}`,yParity:parseInt(e.slice(130,132),16)-27==0?"0x":"0x1"}}a.Delegation7702PublishHook=class{constructor({isAtomicBatchSupported:e,messenger:t}){var a,s;d(a=this,s=y),s.add(a),c(this,b,void 0),c(this,g,void 0),m(b,this,e),m(g,this,t)}getHook(){return u(y,this,_).bind(this)}}}}},{package:"$root$",file:"app/scripts/lib/transaction/hooks/delegation-7702-publish.ts"}],[21,{"@metamask/profile-sync-controller/auth":2185,"@metamask/profile-sync-controller/sdk":2210},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.AuthenticationControllerInit=void 0;var s=e("@metamask/profile-sync-controller/auth"),n=e("@metamask/profile-sync-controller/sdk");a.AuthenticationControllerInit=({controllerMessenger:e,persistedState:t,getMetaMetricsId:a})=>({controller:new s.Controller({messenger:e,state:t.AuthenticationController,metametrics:{getMetaMetricsId:a,agent:n.Platform.EXTENSION}})})}}},{package:"$root$",file:"app/scripts/controller-init/identity/authentication-controller-init.ts"}],[210,{"../containers/util":200,"@metamask/controller-utils":1288,"@metamask/transaction-controller":2637,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.EnforceSimulationHook=void 0;e("@metamask/transaction-controller");var s=e("@metamask/utils");e("@metamask/controller-utils"),e("../containers/util");function n(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function r(e,t){return e.get(i(e,t))}function i(e,t,a){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:a;throw new TypeError("Private element is not present on this object")}const o=(0,s.createProjectLogger)("enforce-simulation-hook");var c=new WeakMap,d=new WeakSet;async function l(e,t){const{transactionMeta:a}=t,{isFinal:s}=e,{containerTypes:n,delegationAddress:i,id:d,origin:l,simulationData:m,txParamsOriginal:u}=a,p=r(c,this).call("AppStateController:getState");(null==p?void 0:p.enableEnforcedSimulationsForTransactions[d])??(null==p||p.enableEnforcedSimulations);return o("Skipping as enforced simulations are disabled"),{skipSimulation:!1}}a.EnforceSimulationHook=class{constructor({messenger:e}){var t,a;n(t=this,a=d),a.add(t),function(e,t,a){n(e,t),t.set(e,a)}(this,c,void 0),function(e,t,a){e.set(i(e,t),a)}(c,this,e)}getAfterSimulateHook(){return i(d,this,l).bind(this,{})}getBeforeSignHook(){return i(d,this,l).bind(this,{isFinal:!0})}}}}},{package:"$root$",file:"app/scripts/lib/transaction/hooks/enforce-simulation-hook.ts"}],[211,{"../../../../shared/constants/app":5294,"../../../../shared/constants/gas":5301,"../../../../shared/constants/metametrics":5307,"../../../../shared/constants/transaction":5327,"../../../../shared/lib/confirmation.utils":5339,"../../../../shared/lib/transactions-controller-utils":5390,"../../../../shared/modules/Numeric":5395,"../../../../shared/modules/conversion.utils":5400,"../../../../shared/modules/gas.utils":5405,"../../../../shared/modules/metametrics":5408,"../../../../shared/modules/transaction.utils":5422,"../../../../ui/helpers/utils/metrics":6514,"../snap-keyring/metrics":186,"../util":220,"@metamask/transaction-controller":2637,"@metamask/utils":2682,"bignumber.js":3531,"ethereumjs-util":3897},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.handleTransactionSubmitted=a.handleTransactionRejected=a.handleTransactionFailed=a.handleTransactionDropped=a.handleTransactionConfirmed=a.handleTransactionApproved=a.handleTransactionAdded=a.handlePostTransactionBalanceUpdate=a.createTransactionEventFragmentWithTxId=a.METRICS_STATUS_FAILED=void 0;var s=e("bignumber.js"),n=e("ethereumjs-util"),r=e("@metamask/transaction-controller"),i=e("@metamask/utils"),o=e("../../../../shared/constants/app"),c=e("../../../../shared/constants/gas"),d=e("../../../../shared/constants/metametrics"),l=e("../../../../shared/constants/transaction"),m=e("../../../../shared/lib/transactions-controller-utils"),u=e("../../../../shared/modules/conversion.utils"),p=e("../../../../shared/modules/metametrics"),h=e("../../../../shared/modules/transaction.utils"),f=e("../../../../ui/helpers/utils/metrics"),b=e("../snap-keyring/metrics"),g=e("../../../../shared/lib/confirmation.utils"),y=e("../../../../shared/modules/gas.utils"),_=e("../../../../shared/modules/Numeric"),w=e("../util");const v=(0,i.createProjectLogger)("transaction-metrics"),T=a.METRICS_STATUS_FAILED="failed on-chain",E=[r.TransactionType.bridge,r.TransactionType.bridgeApproval,r.TransactionType.contractInteraction,r.TransactionType.tokenMethodApprove,r.TransactionType.tokenMethodIncreaseAllowance,r.TransactionType.tokenMethodSafeTransferFrom,r.TransactionType.tokenMethodSetApprovalForAll,r.TransactionType.tokenMethodTransfer,r.TransactionType.tokenMethodTransferFrom,r.TransactionType.swap,r.TransactionType.swapAndSend,r.TransactionType.swapApproval];var P=function(e){return e.swap="mm_swap",e.bridge="mm_bridge",e}(P||{});a.handleTransactionAdded=async(e,t)=>{if(!t.transactionMeta)return;const{properties:a,sensitiveProperties:s}=await C({transactionEventPayload:t,transactionMetricsRequest:e});S({eventName:l.TransactionMetaMetricsEvent.added,transactionEventPayload:t,transactionMetricsRequest:e,payload:{properties:a,sensitiveProperties:s}})};a.handleTransactionApproved=async(e,t)=>{t.transactionMeta&&await k({eventName:l.TransactionMetaMetricsEvent.approved,transactionEventPayload:t,transactionMetricsRequest:e})};a.handleTransactionFailed=async(e,t)=>{if(!t.transactionMeta)return;const a={};t.error&&(a.error=t.error),await k({eventName:l.TransactionMetaMetricsEvent.finalized,extraParams:a,transactionEventPayload:t,transactionMetricsRequest:e})};a.handleTransactionConfirmed=async(e,t)=>{if(0===Object.keys(t).length)return;const a={},s={...t},{txReceipt:n}=s;a.gas_used=null==n?void 0:n.gasUsed,a.block_number=(null==n?void 0:n.blockNumber)&&(0,u.hexToDecimal)(n.blockNumber);const{submittedTime:r,blockTimestamp:i}=s;r&&(a.completion_time=function(e){return Math.round((Date.now()-e)/1e3).toString()}(r)),r&&i&&(a.completion_time_onchain=function(e,t){const a=2,s=Number((0,u.hexToDecimal)(t))-e/1e3;return(Math.round(s*10**a)/10**a).toString()}(r,i)),"0x0"===(null==n?void 0:n.status)&&(a.status=T),await k({eventName:l.TransactionMetaMetricsEvent.finalized,extraParams:a,transactionEventPayload:{actionId:s.actionId,transactionMeta:s},transactionMetricsRequest:e})};a.handleTransactionDropped=async(e,t)=>{if(!t.transactionMeta)return;await k({eventName:l.TransactionMetaMetricsEvent.finalized,extraParams:{dropped:!0},transactionEventPayload:t,transactionMetricsRequest:e})};a.handleTransactionRejected=async(e,t)=>{t.transactionMeta&&await k({eventName:l.TransactionMetaMetricsEvent.rejected,transactionEventPayload:t,transactionMetricsRequest:e})};a.handleTransactionSubmitted=async(e,t)=>{if(!t.transactionMeta)return;const{properties:a,sensitiveProperties:s}=await C({transactionEventPayload:t,transactionMetricsRequest:e});S({eventName:l.TransactionMetaMetricsEvent.submitted,transactionEventPayload:t,transactionMetricsRequest:e,payload:{properties:a,sensitiveProperties:s}})};a.createTransactionEventFragmentWithTxId=async(e,{transactionId:t,actionId:a})=>{const s={...e.getTransaction(t),actionId:a},{properties:n,sensitiveProperties:r}=await C({transactionEventPayload:{transactionMeta:s},transactionMetricsRequest:e});S({eventName:l.TransactionMetaMetricsEvent.approved,transactionEventPayload:{actionId:s.actionId,transactionMeta:s},transactionMetricsRequest:e,payload:{properties:n,sensitiveProperties:r}})};function S({eventName:e,transactionEventPayload:{transactionMeta:t,actionId:a},transactionMetricsRequest:s,payload:n}){if(function(e,t,a){const s=x(t,a.id);return void 0!==e(s)}(s.getEventFragmentById,e,t)&&e!==l.TransactionMetaMetricsEvent.submitted)return;const r=x(e,t.id);switch(e){case l.TransactionMetaMetricsEvent.added:s.createEventFragment({category:d.MetaMetricsEventCategory.Transactions,initialEvent:l.TransactionMetaMetricsEvent.added,successEvent:l.TransactionMetaMetricsEvent.approved,failureEvent:l.TransactionMetaMetricsEvent.rejected,properties:n.properties,sensitiveProperties:n.sensitiveProperties,actionId:a,uniqueIdentifier:r,persist:!0});break;case l.TransactionMetaMetricsEvent.approved:case l.TransactionMetaMetricsEvent.rejected:s.createEventFragment({category:d.MetaMetricsEventCategory.Transactions,successEvent:l.TransactionMetaMetricsEvent.approved,failureEvent:l.TransactionMetaMetricsEvent.rejected,properties:n.properties,sensitiveProperties:n.sensitiveProperties,actionId:a,uniqueIdentifier:r,persist:!0});break;case l.TransactionMetaMetricsEvent.submitted:s.createEventFragment({category:d.MetaMetricsEventCategory.Transactions,initialEvent:l.TransactionMetaMetricsEvent.submitted,successEvent:l.TransactionMetaMetricsEvent.finalized,properties:n.properties,sensitiveProperties:n.sensitiveProperties,actionId:a,uniqueIdentifier:r,persist:!0});break;case l.TransactionMetaMetricsEvent.finalized:s.createEventFragment({category:d.MetaMetricsEventCategory.Transactions,successEvent:l.TransactionMetaMetricsEvent.finalized,properties:n.properties,sensitiveProperties:n.sensitiveProperties,actionId:a,uniqueIdentifier:r,persist:!0})}}async function k({eventName:e,transactionEventPayload:t,transactionMetricsRequest:a,extraParams:s={}}){const{properties:n,sensitiveProperties:r}=await C({transactionEventPayload:t,transactionMetricsRequest:a,extraParams:s});S({eventName:e,transactionEventPayload:t,transactionMetricsRequest:a,payload:{properties:n,sensitiveProperties:r}}),function({eventName:e,transactionEventPayload:{transactionMeta:t},transactionMetricsRequest:a,payload:s}){const n=x(e,t.id);switch(e){case l.TransactionMetaMetricsEvent.approved:case l.TransactionMetaMetricsEvent.rejected:case l.TransactionMetaMetricsEvent.finalized:a.updateEventFragment(n,{properties:s.properties,sensitiveProperties:s.sensitiveProperties})}}({eventName:e,transactionEventPayload:t,transactionMetricsRequest:a,payload:{properties:n,sensitiveProperties:r}}),function({eventName:e,transactionMetricsRequest:t,transactionEventPayload:{transactionMeta:a}}){const s=x(e,a.id);switch(e){case l.TransactionMetaMetricsEvent.approved:case l.TransactionMetaMetricsEvent.finalized:t.finalizeEventFragment(s);break;case l.TransactionMetaMetricsEvent.rejected:t.finalizeEventFragment(s,{abandoned:!0})}}({eventName:e,transactionEventPayload:t,transactionMetricsRequest:a})}function x(e,t){return`transaction-${e===l.TransactionMetaMetricsEvent.finalized||e===l.TransactionMetaMetricsEvent.submitted?"submitted":"added"}-${t}`}async function C({transactionEventPayload:{transactionMeta:e},transactionMetricsRequest:t,extraParams:a={}}){var T;const{type:P,time:S,status:k,chainId:x,origin:C,txParams:{gasPrice:M,gas:I,maxFeePerGas:R,maxPriorityFeePerGas:O,estimateSuggested:N,estimateUsed:$},defaultGasEstimates:B,originalType:D,replacedById:j,customTokenAmount:H,dappProposedTokenAmount:F,currentTokenBalance:L,originalApprovalAmount:U,finalApprovalAmount:q,securityProviderResponse:V,simulationFails:G,id:W,userFeeLevel:K}=e,J=C===o.ORIGIN_METAMASK?"user":"dapp",z="dappSuggested"===K?"dapp_proposed":K,{assetType:Y,tokenStandard:X}=await(0,h.determineTransactionAssetType)(e,t.provider,t.getTokenStandardAndDetails);let Z;if(e.txParams.data){const a=await t.getMethodData(e.txParams.data);Z=null==a?void 0:a.name}const Q={};if((0,h.isEIP1559Transaction)(e)?(Q.max_fee_per_gas=R,Q.max_priority_fee_per_gas=O):(Q.gas_price=M,Q.default_estimate=d.MetaMetricsEventTransactionEstimateType.DefaultEstimate),B){var ee,te;const{estimateType:a}=B;if(a){var ae,se;Q.default_estimate=a===c.PriorityLevels.dAppSuggested?d.MetaMetricsEventTransactionEstimateType.DappProposed:a;let s=null===(ae=e.defaultGasEstimates)||void 0===ae?void 0:ae.maxFeePerGas,n=null===(se=e.defaultGasEstimates)||void 0===se?void 0:se.maxPriorityFeePerGas;if([c.GasRecommendations.low,c.GasRecommendations.medium,c.GasRecommendations.high].includes(a)){var ne,re;const{gasFeeEstimates:e}=await t.getEIP1559GasFeeEstimates();var ie,oe;if(null!=e&&null!==(ne=e[a])&&void 0!==ne&&ne.suggestedMaxFeePerGas)s=null===(ie=e[a])||void 0===ie?void 0:ie.suggestedMaxFeePerGas,Q.default_max_fee_per_gas=s;if(null!=e&&null!==(re=e[a])&&void 0!==re&&re.suggestedMaxPriorityFeePerGas)n=null===(oe=e[a])||void 0===oe?void 0:oe.suggestedMaxPriorityFeePerGas,Q.default_max_priority_fee_per_gas=n}}null!==(ee=e.defaultGasEstimates)&&void 0!==ee&&ee.gas&&(Q.default_gas=e.defaultGasEstimates.gas),null!==(te=e.defaultGasEstimates)&&void 0!==te&&te.gasPrice&&(Q.default_gas_price=e.defaultGasEstimates.gasPrice)}N&&(Q.estimate_suggested=N),$&&(Q.estimate_used=$),null!=a&&a.gas_used&&(Q.gas_used=a.gas_used);const ce=function(e){const t={};for(const a in e)(0,n.isHexString)(e[a])?t[a]=(0,u.hexWEIToDecGWEI)(e[a]):t[a]=e[a];return t}(Q);let de="0";e.txParams.maxFeePerGas&&(de="2");const le="Approve";let me,ue,pe,he,fe,be;const{transactionType:ge,isContractInteraction:ye}=function(e,t){const a=e&&E.includes(e);if([r.TransactionType.swapAndSend,r.TransactionType.cancel,r.TransactionType.deployContract,r.TransactionType.gasPayment,r.TransactionType.batch].includes(e))return{transactionType:e,isContractInteraction:a};if(e===r.TransactionType.retry&&t)return{transactionType:t,isContractInteraction:a};if(a){const t=A(e);return t?{transactionType:t,isContractInteraction:!0}:{transactionType:r.TransactionType.contractInteraction,isContractInteraction:!0}}return{transactionType:r.TransactionType.simpleSend,isContractInteraction:!1}}(P,D);var _e,we;ye&&(ue=Z,fe=null===(_e=e.txParams)||void 0===_e?void 0:_e.to,be=null===(we=e.txParams)||void 0===we||null===(we=we.data)||void 0===we?void 0:we.slice(0,10),ue===le&&X===l.TokenStandard.ERC20&&("0"===F||"0"===H?me=l.TransactionApprovalAmountType.revoke:H&&H!==F?me=l.TransactionApprovalAmountType.custom:F&&(me=l.TransactionApprovalAmountType.dappProposed),pe=function(e,t,a){if(e===l.TransactionApprovalAmountType.custom&&t&&a)return`${new s.BigNumber(t,10).div(a,10).times(100).round(2)}`;return null}(me,U,q),he=function(e,t,a){if((e===l.TransactionApprovalAmountType.custom||e===l.TransactionApprovalAmountType.dappProposed)&&t&&a)return`${new s.BigNumber(t,16).div(a,10).times(100).round(2)}`;return null}(me,F,L)));const ve=t.getTransaction(j),Te={RETRY:r.TransactionType.retry,CANCEL:r.TransactionType.cancel,SAME_NONCE:"other"};let Ee;null!=a&&a.dropped&&(Ee=Te.SAME_NONCE,(null==ve?void 0:ve.type)===r.TransactionType.cancel?Ee=Te.CANCEL:(null==ve?void 0:ve.type)===r.TransactionType.retry&&(Ee=Te.RETRY));const Pe=[];let Se=null;1===(null==V?void 0:V.flagAsDangerous)?Pe.push(d.MetaMetricsEventUiCustomization.FlaggedAsMalicious):2===(null==V?void 0:V.flagAsDangerous)&&Pe.push(d.MetaMetricsEventUiCustomization.FlaggedAsSafetyUnknown);const ke=(0,f.getBlockaidMetricsProps)(e);(null==ke||null===(T=ke.ui_customizations)||void 0===T?void 0:T.length)>0&&Pe.push(...ke.ui_customizations),G&&Pe.push(d.MetaMetricsEventUiCustomization.GasEstimationFailed);(0,g.shouldUseRedesignForTransactions)({transactionMetadataType:e.type})&&(Pe.push(d.MetaMetricsEventUiCustomization.RedesignedConfirmation),Se=t.getIsConfirmationAdvancedDetailsOpen());const xe=(0,p.getSmartTransactionMetricsProperties)(t,e),Ce=(0,f.getSwapAndSendMetricsProps)(e),Ae={hd_entropy_index:t.getHDEntropyIndex()};let Me;try{Me=await t.getAccountType(t.getSelectedAddress())}catch(e){Me="error",v("Error getting account type for transaction metrics:",e)}let Ie={chain_id:x,referrer:C,source:J,status:k,network:`${parseInt(x,16)}`,eip_1559_version:de,gas_edit_type:"none",gas_edit_attempted:"none",gas_estimation_failed:Boolean(G),account_type:Me,device_model:await t.getDeviceModel(t.getSelectedAddress()),asset_type:Y,token_standard:X,transaction_type:ge,transaction_speed_up:P===r.TransactionType.retry,transaction_internal_id:W,gas_fee_selected:z,...ke,ui_customizations:Pe.length>0?Pe:null,transaction_advanced_view:Se,transaction_contract_method:ue?[ue]:[],...xe,...Ce,...Ae};const Re=await(0,b.getSnapAndHardwareInfoForMetrics)(t.getAccountType,t.getDeviceModel,t.getHardwareTypeForMetric,t.snapAndHardwareMessenger);var Oe,Ne;(Object.assign(Ie,Re),ue===le||A(P))&&(Ie={...Ie,simulation_receiving_assets_total_value:Ie.simulation_receiving_assets_total_value??(null==e||null===(Oe=e.assetsFiatValues)||void 0===Oe?void 0:Oe.receiving),simulation_sending_assets_total_value:Ie.simulation_sending_assets_total_value??(null==e||null===(Ne=e.assetsFiatValues)||void 0===Ne?void 0:Ne.sending),transaction_approval_amount_type:me});let $e={transaction_envelope_type:(0,h.isEIP1559Transaction)(e)?m.TRANSACTION_ENVELOPE_TYPE_NAMES.FEE_MARKET:m.TRANSACTION_ENVELOPE_TYPE_NAMES.LEGACY,first_seen:S,gas_limit:I,transaction_replaced:Ee,transaction_contract_address:fe?[fe]:[],transaction_contract_method_4byte:be,...a,...ce};if(ue===le&&($e={...$e,transaction_approval_amount_vs_balance_ratio:he,transaction_approval_amount_vs_proposed_ratio:pe}),await async function(e,t,a,s){const n=origin&&origin!==o.ORIGIN_METAMASK,{delegationAddress:i,nestedTransactions:c,txParams:d}=e,{authorizationList:m}=d,u=Boolean(null==c?void 0:c.length),p=Boolean(null==m?void 0:m.length);n&&(a.api_method=u?o.MESSAGE_TYPE.WALLET_SEND_CALLS:o.MESSAGE_TYPE.ETH_SEND_TRANSACTION);u&&(a.batch_transaction_count=null==c?void 0:c.length,a.batch_transaction_method="eip7702",a.transaction_contract_method=await async function(e,t){const a=e.filter(e=>E.includes(e.type)&&e.data).map(e=>e.data),s=await Promise.all(a.map(e=>t(e)));return s.map(e=>null==e?void 0:e.name).filter(e=>null==e?void 0:e.length)}(c??[],t),s.transaction_contract_address=null==c?void 0:c.filter(e=>{var t;return E.includes(e.type)&&(null===(t=e.to)||void 0===t?void 0:t.length)}).map(e=>e.to));if(e.status===r.TransactionStatus.rejected){const{error:t}=e;a.eip7702_upgrade_rejection=p&&t.code===l.EIP5792ErrorCode.RejectedUpgrade}a.eip7702_upgrade_transaction=p,s.account_eip7702_upgraded=i}(e,t.getMethodData,Ie,$e),function(e,t,a,s){var n;const{gasFeeTokens:r,selectedGasFeeToken:o}=e;t.gas_payment_tokens_available=null==r?void 0:r.map(e=>e.symbol),t.gas_paid_with=null==r||null===(n=r.find(e=>e.tokenAddress.toLowerCase()===(null==o?void 0:o.toLowerCase())))||void 0===n?void 0:n.symbol,(null==o?void 0:o.toLowerCase())===l.NATIVE_TOKEN_ADDRESS&&(t.gas_paid_with="pre-funded_ETH");t.gas_insufficient_native_asset=function(e,t){const{chainId:a,txParams:s}=e,{from:n,gas:r,gasPrice:o,maxFeePerGas:c,value:d}=s,l=t(n,a),m=(0,y.getMaximumGasTotalInHexWei)({gasLimit:r,gasPrice:o,maxFeePerGas:c}),p=(0,i.add0x)((0,u.addHexes)(m,d??"0x0"));return new _.Numeric(p,16).greaterThan(new _.Numeric(l,16))}(e,s)}(e,Ie,0,t.getAccountBalance),k===r.TransactionStatus.submitted||k===r.TransactionStatus.confirmed){const a=t.getNetworkRpcUrl(e.chainId),s=(0,w.extractRpcDomain)(a);Ie.rpc_domain=s}return{properties:Ie,sensitiveProperties:$e}}function A(e){return e===r.TransactionType.swap?P.swap:e===r.TransactionType.bridge?P.bridge:null}a.handlePostTransactionBalanceUpdate=async({getParticipateInMetrics:e,trackEvent:t,getHDEntropyIndex:a},{transactionMeta:n,approvalTransactionMeta:r})=>{var i;if(e()&&n.swapMetaData)if("0x0"===(null===(i=n.txReceipt)||void 0===i?void 0:i.status))t({event:d.MetaMetricsEventName.SwapFailed,category:d.MetaMetricsEventCategory.Swaps,sensitiveProperties:{...n.swapMetaData},properties:{hd_entropy_index:a()}});else{var o;const e=(0,m.getSwapsTokensReceivedFromTxMeta)(n.destinationTokenSymbol,n,n.destinationTokenAddress,n.txParams.from,n.destinationTokenDecimals,r,n.chainId),i=e?`${new s.BigNumber(e,10).div(n.swapMetaData.token_to_amount,10).times(100).round(2)}%`:null,c=null!==(o=n.txReceipt)&&void 0!==o&&o.gasUsed&&n.swapMetaData.estimated_gas?`${new s.BigNumber(n.txReceipt.gasUsed,16).div(n.swapMetaData.estimated_gas,10).times(100).round(2)}%`:null,l=function(e,t){var a,n;let r="0x0";null!=t&&t.txReceipt&&(r=(0,m.calcGasTotal)(t.txReceipt.gasUsed,t.txReceipt.effectiveGasPrice));const i=(0,m.calcGasTotal)(null===(a=e.txReceipt)||void 0===a?void 0:a.gasUsed,null===(n=e.txReceipt)||void 0===n?void 0:n.effectiveGasPrice),o=new s.BigNumber(i,16).plus(r,16).toString(16);return{approvalGasCostInEth:Number((0,u.hexWEIToDecETH)(r)),tradeGasCostInEth:Number((0,u.hexWEIToDecETH)(i)),tradeAndApprovalGasCostInEth:Number((0,u.hexWEIToDecETH)(o))}}(n,r);t({event:d.MetaMetricsEventName.SwapCompleted,category:d.MetaMetricsEventCategory.Swaps,sensitiveProperties:{...n.swapMetaData,token_to_amount_received:e,quote_vs_executionRatio:i,estimated_vs_used_gasRatio:c,approval_gas_cost_in_eth:l.approvalGasCostInEth,trade_gas_cost_in_eth:l.tradeGasCostInEth,trade_and_approval_gas_cost_in_eth:l.tradeAndApprovalGasCostInEth,token_to_amount:n.swapMetaData.token_to_amount.toString(10)},properties:{hd_entropy_index:a()}})}}}}},{package:"$root$",file:"app/scripts/lib/transaction/metrics.ts"}],[212,{"../../../../shared/modules/conversion.utils":5400,"../../../../shared/modules/fetch-with-timeout":5404},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.buildUrl=l,a.getSendBundleSupportedChains=async function(e){const t=await c();return e.reduce((e,a)=>{const s=(0,n.hexToDecimal)(a),r=t[s];return e[a]=(null==r?void 0:r.sendBundle)??!1,e},{})},a.getSentinelNetworkFlags=d,a.isSendBundleSupported=async function(e){const t=await d(e);if(null==t||!t.sendBundle)return!1;return!0};var s,n=e("../../../../shared/modules/conversion.utils"),r=(s=e("../../../../shared/modules/fetch-with-timeout"))&&s.__esModule?s:{default:s};const i="https://tx-sentinel-{0}.api.cx.metamask.io/",o="networks";async function c(){const e=`${l("ethereum-mainnet")}${o}`;return(await(0,r.default)()(e)).json()}async function d(e){const t=(0,n.hexToDecimal)(e);return(await c())[t]}function l(e){return i.replace("{0}",e)}}}},{package:"$root$",file:"app/scripts/lib/transaction/sentinel-api.ts"}],[2122,{"./push-utils.cjs":2123},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=void 0;var s=e("./push-utils.cjs");Object.defineProperty(a,"createRegToken",{enumerable:!0,get:function(){return s.createRegToken}}),Object.defineProperty(a,"deleteRegToken",{enumerable:!0,get:function(){return s.deleteRegToken}}),Object.defineProperty(a,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return s.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],[2123,{"../../NotificationServicesController/index.cjs":2096,"../../shared/to-raw-notification.cjs":2127,"firebase/app":4002,"firebase/messaging":4003,"firebase/messaging/sw":4004,loglevel:4418},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.createSubscribeToPushNotifications=a.deleteRegToken=a.createRegToken=a.supportedCache=void 0;const n=e("firebase/app"),r=e("firebase/messaging"),i=e("firebase/messaging/sw"),o=s(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),d=e("../../shared/to-raw-notification.cjs");a.supportedCache=null;const l=async e=>{if(!await(async()=>(a.supportedCache??(a.supportedCache=await(0,i.isSupported)()),a.supportedCache))())return null;const t=await(async e=>{try{return(0,n.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,n.initializeApp)(t)}})(e);return(0,i.getMessaging)(t)};a.createRegToken=async function(e){try{const t=await l(e);if(!t)return null;return await(0,r.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},a.deleteRegToken=async function(e){try{const t=await l(e);return!t||(await(0,r.deleteToken)(t),!0)}catch{return!1}},a.createSubscribeToPushNotifications=function(e){return async function(t){const a=await async function(e,t){const a=await l(e);if(!a)return null;const s=(0,i.onBackgroundMessage)(a,async e=>{try{const a=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!a)return;const s=(0,d.toRawOnChainNotification)(a),n=c.Processors.processNotification(s);await t(n)}catch(t){throw o.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}});return()=>s()}(t,async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)}),s=function(e){const t=t=>{const a=t?.notification?.data;e(t,a)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}((t,a)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",a),e.onClickHandler(t,a)});return()=>{a?.(),s()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],[213,{"../../../../shared/modules/fetch-with-timeout":5404,"../../../../shared/modules/rpc.utils":5413,"./sentinel-api":212,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RelayStatus=a.RELAY_RPC_METHOD=void 0,a.isRelaySupported=async function(e){return Boolean(await m(e))},a.submitRelayTransaction=async function(e){const{chainId:t}=e,a=await m(t);if(!a)throw new Error(`Chain not supported by transaction relay - ${t}`);c("Request",a,e);const s=await(0,r.jsonRpcRequest)(a,l,[e]);return c("Response",s),s},a.waitForRelayResult=async function(e){const{chainId:t,interval:a,uuid:s}=e,n=await m(t);if(!n)throw new Error(`Chain not supported by transaction relay - ${t}`);const r=`${n}smart-transactions/${s}`;return new Promise((e,t)=>{const s=setInterval(async()=>{try{const t=await async function(e){c("Polling request",e);const t=await(0,i.default)()(e);if(c("Polling response",t),!t.ok){const e=await t.text();throw new Error(`Failed to fetch relay transaction status: ${t.status} - ${e}`)}const a=await t.json(),s=null==a?void 0:a.transactions[0],{hash:n,status:r}=s||{};return{status:r,transactionHash:n}}(r);t.status!==d.Pending&&(clearInterval(s),e(t))}catch(e){clearInterval(s),t(e)}},a)})};var s,n=e("@metamask/utils"),r=e("../../../../shared/modules/rpc.utils"),i=(s=e("../../../../shared/modules/fetch-with-timeout"))&&s.__esModule?s:{default:s},o=e("./sentinel-api");const c=(0,n.createProjectLogger)("transaction-relay");let d=a.RelayStatus=function(e){return e.Pending="PENDING",e.Success="VALIDATED",e}({});const l=a.RELAY_RPC_METHOD="eth_sendRelayTransaction";async function m(e){const t=await(0,o.getSentinelNetworkFlags)(e);return null!=t&&t.relayTransactions?(0,o.buildUrl)(t.network):(c("Chain is not supported",e),undefined)}}}},{package:"$root$",file:"app/scripts/lib/transaction/transaction-relay.ts"}],[2133,{"./ObservableStore":2135},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ComposedStore=void 0;const s=e("./ObservableStore");class n extends s.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach(e=>{const t=this._children[e];this._addChild(e,t)})}_addChild(e,t){const a=t=>{const a=this.getState();a[e]=t,this.putState(a)};t.subscribe(a),a(t.getState())}}a.ComposedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],[2134,{"./ObservableStore":2135},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.MergedStore=void 0;const s=e("./ObservableStore");class n extends s.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach(e=>this._addChild(e)),this._updateWholeState()}_addChild(e){e.subscribe(()=>this._updateWholeState())}_updateWholeState(){const e=this._children.map(e=>e.getState()),t=Object.assign({},...e);this.putState(t)}}a.MergedStore=n}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],[2135,{"@metamask/safe-event-emitter":2285},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.ObservableStore=void 0;const n=s(e("@metamask/safe-event-emitter"));class r extends n.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}a.ObservableStore=r}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],[2136,{"readable-stream":4853},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeAsStream=void 0;const s=e("readable-stream");class n extends s.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const a=super.pipe(e,t);return e.write(this.obsStore.getState()),a}_write(e,t,a){this.obsStore.putState(e),a()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}a.storeAsStream=function(e){return new n(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],[2137,{"./ComposedStore":2133,"./MergedStore":2134,"./ObservableStore":2135,"./asStream":2136,"./transform":2138},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a),Object.defineProperty(e,s,{enumerable:!0,get:function(){return t[a]}})}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./asStream"),a),n(e("./ComposedStore"),a),n(e("./MergedStore"),a),n(e("./ObservableStore"),a),n(e("./transform"),a)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],[2138,{"readable-stream":4853},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.storeTransformStream=void 0;const s=e("readable-stream");a.storeTransformStream=function(e){return new s.Transform({objectMode:!0,transform:(t,a,s)=>{try{const a=e(t);return s(undefined,a),undefined}catch(e){return s(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],[214,{"../../../../shared/constants/app":5294,"../../../../shared/constants/security-provider":5317,"../../../../shared/lib/trace":5388,"../ppom/ppom-util":159,"../trust-signals/security-alerts-api":215,"../trust-signals/trust-signals-util":217,"@metamask/keyring-api":1881,"ethereumjs-util":3897},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.addDappTransaction=async function(e){const{dappRequest:t}=e,{id:a,method:s,origin:n}=t,{securityAlertResponse:r,traceContext:i}=t,c={actionId:a,method:s,origin:n,requireApproval:!0,securityAlertResponse:r};(0,o.endTrace)({name:o.TraceName.Middleware,id:a});const{waitForHash:d}=await m({...e,transactionOptions:{...c,traceContext:i}}),l=await d();return(0,o.endTrace)({name:o.TraceName.Transaction,id:a}),l},a.addTransaction=async function(e){await async function(e){const{chainId:t,ppomController:a,securityAlertsEnabled:s,transactionOptions:n,transactionParams:o,updateSecurityAlertResponse:m,internalAccounts:u,getSecurityAlertsConfig:p}=e;!function(e){const{getSecurityAlertResponse:t,addSecurityAlertResponse:a,securityAlertsEnabled:s,transactionOptions:n,transactionParams:r,chainId:i}=e,{origin:o}=n;if(o!==c.ORIGIN_METAMASK||!s)return;const{to:m}=r;if("string"!=typeof m)return;const u=(0,l.mapChainIdToSupportedEVMChain)(i);if(!u)return;(0,d.scanAddressAndAddToCache)(m,t,a,u).catch(e=>{console.error("[scanAddressForTrustSignals] error scanning address for trust signals:",e)})}(e);const{type:h}=n,f=i.SECURITY_PROVIDER_EXCLUDED_TRANSACTION_TYPES.includes(h);if(!s||f)return;if(u.some(({address:e})=>{var t;return e.toLowerCase()===(null===(t=o.to)||void 0===t?void 0:t.toLowerCase())}))return;try{const{from:s,to:c,value:d,data:l}=o,{actionId:u,origin:h}=n,f={method:"eth_sendTransaction",id:u??"",origin:h??"",params:[{from:s,to:c??"",value:d??"",data:l??""}],jsonrpc:"2.0"},b=(0,r.generateSecurityAlertId)();(0,r.validateRequestWithPPOM)({ppomController:a,request:f,securityAlertId:b,chainId:t,updateSecurityAlertResponse:m,getSecurityAlertsConfig:p});const g={...i.LOADING_SECURITY_ALERT_RESPONSE,securityAlertId:b};e.transactionOptions.securityAlertResponse=g}catch(e){(0,r.handlePPOMError)(e,"Error validating JSON RPC using PPOM: ")}}(e);const{transactionMeta:t,waitForHash:a}=await m(e);if(!e.waitForSubmit)return a().catch(()=>{}),t;const s=await a();return function(e,t){return t.state.transactions.find(t=>t.hash===e)}(s,e.transactionController)},a.getTransactionById=u;var s=e("@metamask/keyring-api"),n=e("ethereumjs-util"),r=e("../ppom/ppom-util"),i=e("../../../../shared/constants/security-provider"),o=e("../../../../shared/lib/trace"),c=e("../../../../shared/constants/app"),d=e("../trust-signals/security-alerts-api"),l=e("../trust-signals/trust-signals-util");async function m(e){const{selectedAccount:t}=e;return t.type===s.EthAccountType.Erc4337?async function(e){var t;const{networkClientId:a,transactionController:s,transactionOptions:r,transactionParams:i,userOperationController:o}=e,{maxFeePerGas:c,maxPriorityFeePerGas:d}=i,{origin:l,requireApproval:m,type:p}=r,h={...i,maxFeePerGas:(0,n.addHexPrefix)(c),maxPriorityFeePerGas:(0,n.addHexPrefix)(d)},f=null==r||null===(t=r.swaps)||void 0===t?void 0:t.meta;null!=f&&f.type&&delete f.type;const b={networkClientId:a,origin:l,requireApproval:m,swaps:f,type:p},g=await o.addUserOperationFromTransaction(h,b);o.startPollingByNetworkClientId(a);return{transactionMeta:u(g.id,s),waitForHash:g.transactionHash}}(e):async function(e){const{transactionController:t,transactionOptions:a,transactionParams:s,networkClientId:n}=e,{result:r,transactionMeta:i}=await t.addTransaction(s,{...a,networkClientId:n});return{transactionMeta:i,waitForHash:()=>r}}(e)}function u(e,t){return t.state.transactions.find(t=>t.id===e)}}}},{package:"$root$",file:"app/scripts/lib/transaction/util.ts"}],[215,{"../../../../shared/constants/time":5325,"../../../../shared/modules/fetch-with-timeout":5404},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.scanAddress=c,a.scanAddressAndAddToCache=async function(e,t,a,s){const n=t(e);if(n)return n;const r=await c(s,e);return a(e,r),r};var s,n=e("../../../../shared/constants/time"),r=(s=e("../../../../shared/modules/fetch-with-timeout"))&&s.__esModule?s:{default:s};const i=5*n.SECOND,o="address/evm/scan";async function c(e,t){const a="https://security-alerts.api.cx.metamask.io";const s=`${a}/${o}`,n={chain:e,address:t},c=await(0,r.default)(i)(s,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)});return await c.json()}}}},{package:"$root$",file:"app/scripts/lib/trust-signals/security-alerts-api.ts"}],[2151,{"./enums.cjs":2152,"@metamask/base-controller":1211,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,d,l,m,u=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},p=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PermissionLogController=void 0;const h=e("@metamask/base-controller"),f=e("@metamask/utils"),b=e("./enums.cjs"),g={permissionHistory:{},permissionActivityLog:[]};class y extends h.BaseController{constructor({messenger:e,restrictedMethods:t,state:a}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{persist:!0,anonymous:!1},permissionActivityLog:{persist:!1,anonymous:!1}},state:{...g,...a}}),s.add(this),n.set(this,void 0),u(this,n,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const a={eth_accounts:{accounts:p(this,s,"m",r).call(this,t,Date.now())}};p(this,s,"m",d).call(this,e,a)}createMiddleware(){return(e,t,a)=>{const{origin:r,method:d}=e,m=d.startsWith(b.WALLET_PREFIX),u="eth_requestAccounts"===d;if(!b.LOG_IGNORE_METHODS.includes(d)&&(m||p(this,n,"f").has(d))||u){const n=p(this,s,"m",i).call(this,e,m),d=p(this,s,"m",l).call(this,e);return void a(e=>{const a=Date.now();p(this,s,"m",o).call(this,n,t,a),d&&!t.error&&t.result&&r&&p(this,s,"m",c).call(this,d,r,t.result,a,u),e()})}a()}}}a.PermissionLogController=y,n=new WeakMap,s=new WeakSet,r=function(e,t){return e.reduce((e,a)=>({...e,[a]:t}),{})},i=function(e,t){const a={id:e.id,method:e.method,methodType:t?b.LOG_METHOD_TYPES.internal:b.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update(e=>{const t=[...e.permissionActivityLog,a];e.permissionActivityLog=t.length>b.LOG_LIMIT?t.slice(1):t}),a},o=function(e,t,a){e&&t&&this.update(s=>{s.permissionActivityLog=s.permissionActivityLog.map(s=>s.id===e.id?{...s,success:(0,f.hasProperty)(t,"result"),responseTime:a}:s)})},c=function(e,t,a,n,i){let o;if(i){const e=a;o={eth_accounts:{accounts:p(this,s,"m",r).call(this,e,n),lastApproved:n}}}else{o=a.reduce((t,a)=>{const i=a.parentCapability;if(!e.includes(i))return t;if("eth_accounts"===i){const e=p(this,s,"m",m).call(this,a);return{...t,[i]:{lastApproved:n,accounts:p(this,s,"m",r).call(this,e,n)}}}return{...t,[i]:{lastApproved:n}}},{})}Object.keys(o).length>0&&p(this,s,"m",d).call(this,t,o)},d=function(e,t){const{permissionHistory:a}=this.state,s=a[e]??{},n={...s,...t},r=s.eth_accounts,i=t.eth_accounts;if(r&&i){const e=i.lastApproved??r.lastApproved;n.eth_accounts={lastApproved:e,accounts:{...r.accounts,...i.accounts}}}this.update(t=>{t.permissionHistory={...a,[e]:n}})},l=function(e){const{method:t,params:a}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${b.WALLET_PREFIX}requestPermissions`&&a&&Array.isArray(a)&&a[0]&&"object"==typeof a[0]&&!Array.isArray(a[0])?Object.keys(a[0]):null},m=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const a of e.caveats)if(a.type===b.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(a.value))for(const e of a.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],[2152,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s;Object.defineProperty(a,"__esModule",{value:!0}),a.LOG_LIMIT=a.LOG_METHOD_TYPES=a.LOG_IGNORE_METHODS=a.CAVEAT_TYPES=a.WALLET_PREFIX=void 0,a.WALLET_PREFIX="wallet_",a.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),a.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(s||(a.LOG_METHOD_TYPES=s={})),a.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],[2153,{"./PermissionLogController.cjs":2151},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./PermissionLogController.cjs"),a)}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],[216,{"../../../../shared/modules/transaction.utils":5422,"../ppom/security-alerts-api":161,"./security-alerts-api":215,"./trust-signals-util":217},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createTrustSignalsMiddleware=function(e,t,a,c,d){return async(l,m,u)=>{try{if(!(0,i.isSecurityAlertsEnabledByUser)(c)||!(0,n.isSecurityAlertsAPIEnabled)())return;(0,i.isEthSendTransaction)(l)?(!function(e,t,a){if(!(0,i.hasValidTransactionParams)(e))return;const{to:s}=e.params[0];let n;try{n=(0,i.getChainId)(a)}catch(e){return void console.error("[createTrustSignalsMiddleware] error getting chainId:",e)}if(!n)return;(0,r.scanAddressAndAddToCache)(s,t.getAddressSecurityAlertResponse,t.addAddressSecurityAlertResponse,n).catch(e=>{console.error("[createTrustSignalsMiddleware] error scanning address for transaction:",e)})}(l,t,e),o(l,a)):(0,i.isEthSignTypedData)(l)?(!function(e,t,a){var n;if(!(0,i.hasValidTypedDataParams)(e))return;const o=(0,s.parseTypedDataMessage)("string"==typeof e.params[1]?e.params[1]:JSON.stringify(e.params[1])),c=null===(n=o.domain)||void 0===n?void 0:n.verifyingContract;if(!c)return;let d;try{d=(0,i.getChainId)(a)}catch(e){return void console.error("[createTrustSignalsMiddleware] error getting chainId:",e)}if(!d)return;(0,r.scanAddressAndAddToCache)(c,t.getAddressSecurityAlertResponse,t.addAddressSecurityAlertResponse,d).catch(e=>{console.error("[createTrustSignalsMiddleware] error scanning address for signature:",e)})}(l,t,e),o(l,a)):((0,i.isConnected)(l,d)||(0,i.connectScreenHasBeenPrompted)(l))&&o(l,a)}catch(e){console.error("[createTrustSignalsMiddleware] error: ",e)}finally{u()}}};var s=e("../../../../shared/modules/transaction.utils"),n=e("../ppom/security-alerts-api"),r=e("./security-alerts-api"),i=e("./trust-signals-util");function o(e,t){e.origin&&t.scanUrl(e.origin).catch(e=>{console.error("[createTrustSignalsMiddleware] error:",e)})}}}},{package:"$root$",file:"app/scripts/lib/trust-signals/trust-signals-middleware.ts"}],[2164,{"readable-stream":4853},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.BasePostMessageStream=void 0;const s=e("readable-stream"),n=()=>undefined,r="SYN",i="ACK";class o extends s.Duplex{constructor(e){super(Object.assign({objectMode:!0},e)),this._init=!1,this._haveSyn=!1,this._log=()=>null}_handshake(){this._write(r,null,n),this.cork()}_onData(e){if(this._init)try{this.push(e),this._log(e,!1)}catch(e){this.emit("error",e)}else e===r?(this._haveSyn=!0,this._write(i,null,n)):e===i&&(this._init=!0,this._haveSyn||this._write(i,null,n),this.uncork())}_read(){return undefined}_write(e,t,a){e!==i&&e!==r&&this._log(e,!0),this._postMessage(e),a()}_setLogger(e){this._log=e}}a.BasePostMessageStream=o}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs"}],[2165,{"./BasePostMessageStream.cjs":2164,"./runtime/BrowserRuntimePostMessageStream.cjs":2166,"./utils.cjs":2167,"./web-worker/WebWorkerParentPostMessageStream.cjs":2168,"./web-worker/WebWorkerPostMessageStream.cjs":2169,"./window/WindowPostMessageStream.cjs":2170},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),a.isValidStreamMessage=void 0,n(e("./window/WindowPostMessageStream.cjs"),a),n(e("./web-worker/WebWorkerPostMessageStream.cjs"),a),n(e("./web-worker/WebWorkerParentPostMessageStream.cjs"),a),n(e("./runtime/BrowserRuntimePostMessageStream.cjs"),a),n(e("./BasePostMessageStream.cjs"),a);var r=e("./utils.cjs");Object.defineProperty(a,"isValidStreamMessage",{enumerable:!0,get:function(){return r.isValidStreamMessage}})}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/index.cjs"}],[2166,{"../BasePostMessageStream.cjs":2164,"../utils.cjs":2167},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},i=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)},o=this&&this.__rest||function(e,t){var a={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(a[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(s=Object.getOwnPropertySymbols(e);n<s.length;n++)t.indexOf(s[n])<0&&Object.prototype.propertyIsEnumerable.call(e,s[n])&&(a[s[n]]=e[s[n]])}return a};Object.defineProperty(a,"__esModule",{value:!0}),a.BrowserRuntimePostMessageStream=void 0;const c=e("../BasePostMessageStream.cjs"),d=e("../utils.cjs");class l extends c.BasePostMessageStream{constructor(e){var{name:t,target:a}=e;super(o(e,["name","target"])),s.set(this,void 0),n.set(this,void 0),r(this,s,t,"f"),r(this,n,a,"f"),this._onMessage=this._onMessage.bind(this),this._getRuntime().onMessage.addListener(this._onMessage),this._handshake()}_postMessage(e){this._getRuntime().sendMessage({target:i(this,n,"f"),data:e})}_onMessage(e){(0,d.isValidStreamMessage)(e)&&e.target===i(this,s,"f")&&this._onData(e.data)}_getRuntime(){var e,t;if("chrome"in globalThis&&"function"==typeof(null===(e=null===chrome||void 0===chrome?void 0:chrome.runtime)||void 0===e?void 0:e.sendMessage))return chrome.runtime;if("browser"in globalThis&&"function"==typeof(null===(t=null===browser||void 0===browser?void 0:browser.runtime)||void 0===t?void 0:t.sendMessage))return browser.runtime;throw new Error("browser.runtime.sendMessage is not a function. This class should only be instantiated in a web extension.")}_destroy(){this._getRuntime().onMessage.removeListener(this._onMessage)}}a.BrowserRuntimePostMessageStream=l,s=new WeakMap,n=new WeakMap}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/runtime/BrowserRuntimePostMessageStream.cjs"}],[2167,{"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.isValidStreamMessage=a.DEDICATED_WORKER_NAME=void 0;const s=e("@metamask/utils");a.DEDICATED_WORKER_NAME="dedicatedWorker",a.isValidStreamMessage=function(e){return(0,s.isObject)(e)&&Boolean(e.data)&&("number"==typeof e.data||"object"==typeof e.data||"string"==typeof e.data)}}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/utils.cjs"}],[2168,{"../BasePostMessageStream.cjs":2164,"../utils.cjs":2167},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__rest||function(e,t){var a={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(a[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(s=Object.getOwnPropertySymbols(e);n<s.length;n++)t.indexOf(s[n])<0&&Object.prototype.propertyIsEnumerable.call(e,s[n])&&(a[s[n]]=e[s[n]])}return a};Object.defineProperty(a,"__esModule",{value:!0}),a.WebWorkerParentPostMessageStream=void 0;const n=e("../BasePostMessageStream.cjs"),r=e("../utils.cjs");class i extends n.BasePostMessageStream{constructor(e){var{worker:t}=e;super(s(e,["worker"])),this._target=r.DEDICATED_WORKER_NAME,this._worker=t,this._worker.onmessage=this._onMessage.bind(this),this._handshake()}_postMessage(e){this._worker.postMessage({target:this._target,data:e})}_onMessage(e){const t=e.data;(0,r.isValidStreamMessage)(t)&&this._onData(t.data)}_destroy(){this._worker.onmessage=null,this._worker=null}}a.WebWorkerParentPostMessageStream=i}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerParentPostMessageStream.cjs"}],[2169,{"../BasePostMessageStream.cjs":2164,"../utils.cjs":2167},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.WebWorkerPostMessageStream=void 0;const s=e("../BasePostMessageStream.cjs"),n=e("../utils.cjs");class r extends s.BasePostMessageStream{constructor(e={}){if("undefined"==typeof self||"undefined"==typeof WorkerGlobalScope)throw new Error("WorkerGlobalScope not found. This class should only be instantiated in a WebWorker.");super(e),this._name=n.DEDICATED_WORKER_NAME,self.addEventListener("message",this._onMessage.bind(this)),this._handshake()}_postMessage(e){self.postMessage({data:e})}_onMessage(e){const t=e.data;(0,n.isValidStreamMessage)(t)&&t.target===this._name&&this._onData(t.data)}_destroy(){return undefined}}a.WebWorkerPostMessageStream=r}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerPostMessageStream.cjs"}],[217,{"../../../../shared/constants/app":5294,"../../../../shared/constants/network":5310,"../../../../shared/modules/selectors/networks":5417,"./types":218},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.connectScreenHasBeenPrompted=function(e){return e.method===r.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS||e.method===r.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS},a.getChainId=function(e){var t;const a=null===(t=(0,n.getProviderConfig)({metamask:e.state}))||void 0===t?void 0:t.chainId;if(!a)throw new Error("Chain ID not found");return c(a)},a.hasValidTransactionParams=function(e){if(!("params"in e)||!e.params)return!1;if(!Array.isArray(e.params)||0===e.params.length)return!1;const t=e.params[0];return"object"==typeof t&&null!==t&&"to"in t},a.hasValidTypedDataParams=function(e){if(!("params"in e)||!e.params)return!1;if(!Array.isArray(e.params)||e.params.length<2)return!1;return e.params[1]!==undefined&&null!==e.params[1]},a.isConnected=function(e,t){if(!e.origin||e.method!==r.MESSAGE_TYPE.ETH_ACCOUNTS)return!1;const a=t(e.origin);return Array.isArray(a)&&a.length>0},a.isEthSendTransaction=function(e){return e.method===r.MESSAGE_TYPE.ETH_SEND_TRANSACTION},a.isEthSignTypedData=function(e){return e.method===r.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA||e.method===r.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1||e.method===r.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3||e.method===r.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4},a.isSecurityAlertsEnabledByUser=function(e){const{securityAlertsEnabled:t}=e.state;return t},a.mapChainIdToSupportedEVMChain=c;var s=e("../../../../shared/constants/network"),n=e("../../../../shared/modules/selectors/networks"),r=e("../../../../shared/constants/app"),i=e("./types");const o={[s.CHAIN_IDS.ARBITRUM.toLowerCase()]:i.SupportedEVMChain.Arbitrum,[s.CHAIN_IDS.AVALANCHE.toLowerCase()]:i.SupportedEVMChain.Avalanche,[s.CHAIN_IDS.BASE.toLowerCase()]:i.SupportedEVMChain.Base,[s.CHAIN_IDS.BASE_SEPOLIA.toLowerCase()]:i.SupportedEVMChain.BaseSepolia,[s.CHAIN_IDS.BSC.toLowerCase()]:i.SupportedEVMChain.Bsc,[s.CHAIN_IDS.MAINNET.toLowerCase()]:i.SupportedEVMChain.Ethereum,[s.CHAIN_IDS.OPTIMISM.toLowerCase()]:i.SupportedEVMChain.Optimism,[s.CHAIN_IDS.POLYGON.toLowerCase()]:i.SupportedEVMChain.Polygon,[s.CHAIN_IDS.ZKSYNC_ERA.toLowerCase()]:i.SupportedEVMChain.Zksync,[s.CHAIN_IDS.ZK_SYNC_ERA_TESTNET.toLowerCase()]:i.SupportedEVMChain.ZksyncSepolia,"0x76adf1":i.SupportedEVMChain.Zora,[s.CHAIN_IDS.LINEA_MAINNET.toLowerCase()]:i.SupportedEVMChain.Linea,[s.CHAIN_IDS.BLAST.toLowerCase()]:i.SupportedEVMChain.Blast,[s.CHAIN_IDS.SCROLL.toLowerCase()]:i.SupportedEVMChain.Scroll,[s.CHAIN_IDS.SEPOLIA.toLowerCase()]:i.SupportedEVMChain.EthereumSepolia,"0x27bc86aa":i.SupportedEVMChain.Degen,[s.CHAIN_IDS.AVALANCHE_TESTNET.toLowerCase()]:i.SupportedEVMChain.AvalancheFuji,"0x343b":i.SupportedEVMChain.ImmutableZkevm,"0x34a1":i.SupportedEVMChain.ImmutableZkevmTestnet,[s.CHAIN_IDS.GNOSIS.toLowerCase()]:i.SupportedEVMChain.Gnosis,"0x1e0":i.SupportedEVMChain.Worldchain,"0x79a":i.SupportedEVMChain.SoneiumMinato,"0x7e4":i.SupportedEVMChain.Ronin,[s.CHAIN_IDS.APECHAIN_MAINNET.toLowerCase()]:i.SupportedEVMChain.ApeChain,"0x849ea":i.SupportedEVMChain.ZeroNetwork,[s.CHAIN_IDS.BERACHAIN.toLowerCase()]:i.SupportedEVMChain.Berachain,"0x138c5":i.SupportedEVMChain.BerachainBartio,[s.CHAIN_IDS.INK.toLowerCase()]:i.SupportedEVMChain.Ink,[s.CHAIN_IDS.INK_SEPOLIA.toLowerCase()]:i.SupportedEVMChain.InkSepolia,"0xab5":i.SupportedEVMChain.Abstract,"0x2b74":i.SupportedEVMChain.AbstractTestnet,"0x74c":i.SupportedEVMChain.Soneium,[s.CHAIN_IDS.UNICHAIN.toLowerCase()]:i.SupportedEVMChain.Unichain,[s.CHAIN_IDS.SEI.toLowerCase()]:i.SupportedEVMChain.Sei,[s.CHAIN_IDS.FLOW.toLowerCase()]:i.SupportedEVMChain.FlowEvm};function c(e){return"string"==typeof e&&e?o[e.toLowerCase()]:undefined}}}},{package:"$root$",file:"app/scripts/lib/trust-signals/trust-signals-util.ts"}],[2170,{"../BasePostMessageStream.cjs":2164,"../utils.cjs":2167,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r=this&&this.__rest||function(e,t){var a={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(a[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(s=Object.getOwnPropertySymbols(e);n<s.length;n++)t.indexOf(s[n])<0&&Object.prototype.propertyIsEnumerable.call(e,s[n])&&(a[s[n]]=e[s[n]])}return a};Object.defineProperty(a,"__esModule",{value:!0}),a.WindowPostMessageStream=void 0;const i=e("@metamask/utils"),o=e("../BasePostMessageStream.cjs"),c=e("../utils.cjs"),d=null===(s=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"source"))||void 0===s?void 0:s.get;(0,i.assert)(d,"MessageEvent.prototype.source getter is not defined.");const l=null===(n=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"origin"))||void 0===n?void 0:n.get;(0,i.assert)(l,"MessageEvent.prototype.origin getter is not defined.");class m extends o.BasePostMessageStream{constructor(e){var{name:t,target:a,targetOrigin:s=location.origin,targetWindow:n=window}=e;if(super(r(e,["name","target","targetOrigin","targetWindow"])),"undefined"==typeof window||"function"!=typeof window.postMessage)throw new Error("window.postMessage is not a function. This class should only be instantiated in a Window.");this._name=t,this._target=a,this._targetOrigin=s,this._targetWindow=n,this._onMessage=this._onMessage.bind(this),window.addEventListener("message",this._onMessage,!1),this._handshake()}_postMessage(e){this._targetWindow.postMessage({target:this._target,data:e},this._targetOrigin)}_onMessage(e){const t=e.data;"*"!==this._targetOrigin&&l.call(e)!==this._targetOrigin||d.call(e)!==this._targetWindow||!(0,c.isValidStreamMessage)(t)||t.target!==this._name||this._onData(t.data)}_destroy(){window.removeEventListener("message",this._onMessage,!1)}}a.WindowPostMessageStream=m}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/window/WindowPostMessageStream.cjs"}],[2171,{"./ppom-controller":2172},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;var s=e("./ppom-controller");Object.defineProperty(a,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return s.NETWORK_CACHE_DURATION}}),Object.defineProperty(a,"PPOMController",{enumerable:!0,get:function(){return s.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],[2172,{"./ppom-storage":2173,"./util":2174,"@metamask/base-controller":2179,"@metamask/controller-utils":1288,"await-semaphore":3469},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,d,l,m,u,p,h,f,b,g,y,_,w,v,T,E,P,S,k,x,C,A,M,I,R,O,N,$=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},B=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMController=a.NETWORK_CACHE_DURATION=void 0;const D=e("@metamask/base-controller"),j=e("@metamask/controller-utils"),H=e("await-semaphore"),F=e("./ppom-storage"),L=e("./util");a.NETWORK_CACHE_DURATION=6048e5;const U=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],q={versionInfo:{persist:!0,anonymous:!1},storageMetadata:{persist:!0,anonymous:!1}},V="PPOMController",G={headers:{"Content-Type":"application/json"}};class W extends D.BaseController{constructor({chainId:e,messenger:t,provider:a,storageBackend:y,securityAlertsEnabled:_,onPreferencesChange:w,ppomProvider:P,cdnBaseUrl:S,providerRequestLimit:k,state:x,blockaidPublicKey:C,nativeCrypto:A}){super({name:V,metadata:q,messenger:t,state:{versionInfo:x?.versionInfo??[],storageMetadata:x?.storageMetadata??[]}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),c.set(this,void 0),d.set(this,void 0),l.set(this,void 0),m.set(this,0),u.set(this,void 0),p.set(this,void 0),h.set(this,{}),f.set(this,void 0),b.set(this,!1),g.set(this,undefined),$(this,u,(0,L.addHexPrefix)(e),"f"),$(this,r,a,"f"),$(this,c,P,"f"),$(this,i,new F.PPOMStorage({storageBackend:y,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update(t=>{t.storageMetadata=e})}}),"f"),$(this,o,new H.Mutex,"f"),$(this,d,S,"f"),$(this,l,k??300,"f"),$(this,p,_,"f"),$(this,f,C,"f"),$(this,g,A,"f"),w(B(this,s,"m",v).bind(this)),B(this,s,"m",T).call(this),B(this,s,"m",E).call(this)}async usePPOM(e,t){const a=t??B(this,u,"f");if(!B(this,p,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,L.blockaidValidationSupportedForNetwork)(a))throw Error(`Blockaid validation not available on network with chainId: ${a}`);return await B(this,o,"f").use(async()=>{const t=await B(this,s,"m",S).call(this,a);$(this,m,0,"f"),$(this,h,{},"f");return{...await e(t),providerRequestsCount:{...B(this,h,"f")}}})}}a.PPOMController=W,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,d=new WeakMap,l=new WeakMap,m=new WeakMap,u=new WeakMap,p=new WeakMap,h=new WeakMap,f=new WeakMap,b=new WeakMap,g=new WeakMap,s=new WeakSet,y=async function(){if(B(this,p,"f")&&!B(this,b,"f")){const{ppomInit:e}=B(this,c,"f");await e("./ppom_bg.wasm"),$(this,b,!0,"f")}},_=function(){B(this,s,"m",P).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)});const{storageMetadata:e}=this.state;this.update(e=>{e.versionInfo=[],e.storageMetadata=[]}),B(this,i,"f").deleteAllFiles(e).catch(e=>{console.error(`Error in deleting files: ${e.message}`)})},w=function(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:a}=t.configuration,n=(0,L.addHexPrefix)(a);n!==B(this,u,"f")&&($(this,u,n,"f"),B(this,s,"m",P).call(this).catch(e=>{console.error(`Error in resetting ppom: ${e.message}`)}))},v=function(e){const t=e.securityAlertsEnabled;t!==B(this,p,"f")&&($(this,p,t,"f"),t||B(this,s,"m",_).call(this))},T=function(){this.messagingSystem.registerActionHandler(`${V}:usePPOM`,this.usePPOM.bind(this))},E=function(){const e=B(this,s,"m",w).bind(this);this.messagingSystem.subscribe("NetworkController:networkDidChange",e)},P=async function(){await B(this,o,"f").use(async()=>{B(this,n,"f")&&(B(this,n,"f").free(),$(this,n,undefined,"f"))})},S=async function(e){const t=await B(this,s,"m",k).call(this);let a;return(B(this,n,"f")===undefined||t)&&(a=await B(this,s,"m",N).call(this,e),B(this,u,"f")===e&&(B(this,n,"f")&&B(this,n,"f").free(),$(this,n,a,"f")),B(this,i,"f").syncMetadata(this.state.versionInfo).catch(e=>{console.error(`Error while trying to sync metadata: ${e.message}`)})),a},k=async function(){const e=await B(this,s,"m",I).call(this);return!!e&&(this.update(t=>{t.versionInfo=e}),!0)},x=function(e,t){return e.find(e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum)},C=async function(e){const t=await Promise.all(e.map(async e=>{let t;try{t=await B(this,s,"m",A).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined}));return t?.filter(e=>e?.[1]!==undefined)},A=async function(e){const{storageMetadata:t}=this.state;if(B(this,s,"m",x).call(this,t,e))try{return await B(this,i,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,L.checkFilePath)(e.filePath);const a=(0,L.constructURLHref)(B(this,d,"f"),e.filePath),n=await B(this,s,"m",R).call(this,a);return await(0,L.validateSignature)(n,e.hashSignature,B(this,f,"f"),e.filePath,B(this,g,"f")),await B(this,i,"f").writeFile({data:n,...e}).catch(e=>{console.error(`Error in writing file: ${e.message}`)}),n},M=async function(e,t={},a="GET"){const s=await(0,j.safelyExecute)(async()=>(0,j.timeoutFetch)(e,{method:a,cache:"no-cache",redirect:"error",...t},1e4),!0),n=304===s?.status;if(!s?.status||s?.status<200||s?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:n,response:s}},I=async function(){const e=(0,L.constructURLHref)(B(this,d,"f"),"ppom_version.json"),{cached:t,response:a}=await B(this,s,"m",M).call(this,e,{headers:G});return t&&this.state.versionInfo?.length?undefined:a.json()},R=async function(e){const{response:t}=await B(this,s,"m",M).call(this,e);return await t.arrayBuffer()},O=async function(e,t){if(B(this,m,"f")>B(this,l,"f"))return L.PROVIDER_ERRORS.limitExceeded();if($(this,m,B(this,m,"f")+1,"f"),!U.includes(e))return L.PROVIDER_ERRORS.methodNotSupported();B(this,h,"f")[e]=B(this,h,"f")[e]?Number(B(this,h,"f")[e])+1:1;const a=(0,L.createPayload)(e,t);try{const e=await B(this,r,"f").request(a);return{jsonrpc:"2.0",id:a.id,result:e}}catch(e){return{jsonrpc:"2.0",id:a.id,error:e}}},N=async function(e){await B(this,s,"m",y).call(this);const t=this.state.versionInfo.filter(({chainId:t})=>t===e);if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const a=await B(this,s,"m",C).call(this,t);if(a?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:n}=B(this,c,"f");return n.new(B(this,s,"m",O).bind(this),a)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],[2173,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},o=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PPOMStorage=void 0;a.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:a}){s.set(this,void 0),n.set(this,void 0),r.set(this,void 0),i(this,s,e,"f"),i(this,n,t,"f"),i(this,r,a,"f")}async syncMetadata(e){const t=o(this,n,"f").call(this),a=[];for(const s of t){try{await this.readFile(s.name,s.chainId)}catch(e){console.error("Error: ",e);continue}e.find(e=>e.name===s.name&&e.chainId===s.chainId&&e.version===s.version&&e.checksum===s.checksum)&&a.push(s)}const i=await o(this,s,"f").dir();for(const{name:e,chainId:t}of i)a.find(a=>a.name===e&&a.chainId===t)||await o(this,s,"f").delete({name:e,chainId:t});return o(this,r,"f").call(this,a),a}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:a}=t;try{await o(this,s,"f").delete({name:e,chainId:a})}catch(t){console.error(`Error in deleting file: ${e}, ${a}`,t)}}}async readFile(e,t){const a=o(this,n,"f").call(this).find(a=>a.name===e&&a.chainId===t);if(!a)throw new Error(`File metadata (${e}, ${t}) not found`);const r=await o(this,s,"f").read({name:e,chainId:t},a.checksum);if(!r)throw new Error(`Storage File (${e}, ${t}) not found`);return r}async writeFile({data:e,name:t,chainId:a,version:i,checksum:c}){await o(this,s,"f").write({name:t,chainId:a},e,c);const d=o(this,n,"f").call(this),l=d.find(e=>e.name===t&&e.chainId===a);l?(l.version=i,l.checksum=c):d.push({name:t,chainId:a,version:i,checksum:c}),o(this,r,"f").call(this,d)}},s=new WeakMap,n=new WeakMap,r=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],[2174,{buffer:3640,"crypto-js":3758,elliptic:3814,"json-rpc-random-id":4241},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){(function(t){(function(){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),r=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&s(t,e,a);return n(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.checkFilePath=a.addHexPrefix=a.constructURLHref=a.validateSignature=a.PROVIDER_ERRORS=a.createPayload=a.IdGenerator=a.blockaidValidationSupportedForNetwork=a.SUPPORTED_NETWORK_CHAINIDS=void 0;const o=r(e("crypto-js")),c=i(e("elliptic")),d=i(e("json-rpc-random-id")),l=c.default.eddsa;a.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};a.blockaidValidationSupportedForNetwork=e=>Object.values(a.SUPPORTED_NETWORK_CHAINIDS).some(t=>t===e),a.IdGenerator=(0,d.default)();a.createPayload=(e,t)=>({id:(0,a.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),a.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,a.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};a.validateSignature=async(e,a,s,n,r,i)=>{const c=await(async(e,t,a=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&a){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map(e=>e.toString(16).padStart(2,"0")).join("")}return(0,o.SHA256)(o.default.lib.WordArray.create(e)).toString()})(e,r,i);if(!new l("ed25519").keyFromPublic(s).verify(t.from(c),a))throw Error(`Signature verification failed for file path: ${n}`)};a.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;a.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;a.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],[2175,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.BaseControllerV1=a.isBaseControllerV1=void 0,a.isBaseControllerV1=function(e){return"name"in e&&"string"==typeof e.name&&"config"in e&&"object"==typeof e.config&&"defaultConfig"in e&&"object"==typeof e.defaultConfig&&"state"in e&&"object"==typeof e.state&&"defaultState"in e&&"object"==typeof e.defaultState&&"disabled"in e&&"boolean"==typeof e.disabled&&"subscribe"in e&&"function"==typeof e.subscribe};class s{constructor(e={},t={}){this.defaultConfig={},this.defaultState={},this.disabled=!1,this.name="BaseController",this.internalConfig=this.defaultConfig,this.internalState=this.defaultState,this.internalListeners=[],this.initialState=t,this.initialConfig=e}initialize(){return this.internalState=this.defaultState,this.internalConfig=this.defaultConfig,this.configure(this.initialConfig),this.update(this.initialState),this}get config(){return this.internalConfig}get state(){return this.internalState}configure(e,t=!1,a=!0){if(a){this.internalConfig=t?e:Object.assign(this.internalConfig,e);for(const e of Object.keys(this.internalConfig)){const t=this.internalConfig[e];t!==undefined&&(this[e]=t)}}else for(const t of Object.keys(e))if(this.internalConfig[t]!==undefined){const a=e[t];this.internalConfig[t]=a,this[t]=a}}notify(){this.disabled||this.internalListeners.forEach(e=>{e(this.internalState)})}subscribe(e){this.internalListeners.push(e)}unsubscribe(e){const t=this.internalListeners.findIndex(t=>e===t);return t>-1&&this.internalListeners.splice(t,1),t>-1}update(e,t=!1){this.internalState=t?Object.assign({},e):Object.assign({},this.internalState,e),this.notify()}}a.BaseControllerV1=s,a.default=s}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV1.cjs"}],[2176,{immer:4205},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},r=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.getPersistentState=a.getAnonymizedState=a.BaseController=a.isBaseController=void 0;const i=e("immer");(0,i.enablePatches)(),a.isBaseController=function(e){return"name"in e&&"string"==typeof e.name&&"state"in e&&"object"==typeof e.state&&"metadata"in e&&"object"==typeof e.metadata};function o(e,t,a){return Object.keys(e).reduce((s,n)=>{try{const r=t[n];if(!r)throw new Error(`No metadata found for '${String(n)}'`);const i=r[a],o=e[n];return"function"==typeof i?s[n]=i(o):i&&(s[n]=o),s}catch(e){return setTimeout(()=>{throw e}),s}},{})}a.BaseController=class{constructor({messenger:e,metadata:t,name:a,state:r}){s.set(this,void 0),this.messagingSystem=e,this.name=a,n(this,s,(0,i.freeze)(r,!0),"f"),this.metadata=t,this.messagingSystem.registerActionHandler(`${a}:getState`,()=>this.state),this.messagingSystem.registerInitialEventPayload({eventType:`${a}:stateChange`,getPayload:()=>[this.state,[]]})}get state(){return r(this,s,"f")}set state(e){throw new Error("Controller state cannot be directly mutated; use 'update' method instead.")}update(e){const[t,a,o]=i.produceWithPatches(r(this,s,"f"),e);return n(this,s,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,a),{nextState:t,patches:a,inversePatches:o}}applyPatches(e){const t=(0,i.applyPatches)(r(this,s,"f"),e);n(this,s,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,e)}destroy(){this.messagingSystem.clearEventSubscriptions(`${this.name}:stateChange`)}},s=new WeakMap,a.getAnonymizedState=function(e,t){return o(e,t,"anonymous")},a.getPersistentState=function(e,t){return o(e,t,"persist")}}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs"}],[2177,{"./RestrictedMessenger.cjs":2178},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.ControllerMessenger=a.Messenger=void 0;const c=e("./RestrictedMessenger.cjs");class d{constructor(){s.set(this,new Map),n.set(this,new Map),r.set(this,new Map),i.set(this,new Map)}registerActionHandler(e,t){if(o(this,s,"f").has(e))throw new Error(`A handler for ${e} has already been registered`);o(this,s,"f").set(e,t)}unregisterActionHandler(e){o(this,s,"f").delete(e)}clearActions(){o(this,s,"f").clear()}call(e,...t){const a=o(this,s,"f").get(e);if(!a)throw new Error(`A handler for ${e} has not been registered`);return a(...t)}registerInitialEventPayload({eventType:e,getPayload:t}){o(this,r,"f").set(e,t)}publish(e,...t){const a=o(this,n,"f").get(e);if(a)for(const[e,s]of a.entries())try{if(s){const a=o(this,i,"f").get(e),n=s(...t);n!==a&&(o(this,i,"f").set(e,n),e(n,a))}else e(...t)}catch(e){setTimeout(()=>{throw e})}}subscribe(e,t,a){let s=o(this,n,"f").get(e);if(s||(s=new Map,o(this,n,"f").set(e,s)),s.set(t,a),a){const s=o(this,r,"f").get(e);if(s){const e=a(...s());o(this,i,"f").set(t,e)}}}unsubscribe(e,t){const a=o(this,n,"f").get(e);if(!a||!a.has(t))throw new Error(`Subscription not found for event: ${e}`);a.get(t)&&o(this,i,"f").delete(t),a.delete(t)}clearEventSubscriptions(e){o(this,n,"f").delete(e)}clearSubscriptions(){o(this,n,"f").clear()}getRestricted({name:e,allowedActions:t,allowedEvents:a}){return new c.RestrictedMessenger({messenger:this,name:e,allowedActions:t,allowedEvents:a})}}a.Messenger=d,a.ControllerMessenger=d,s=new WeakMap,n=new WeakMap,r=new WeakMap,i=new WeakMap}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/Messenger.cjs"}],[2178,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,d,l,m=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a},u=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.RestrictedControllerMessenger=a.RestrictedMessenger=void 0;class p{constructor({controllerMessenger:e,messenger:t,name:a,allowedActions:c,allowedEvents:d}){if(s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,void 0),o.set(this,void 0),t&&e)throw new Error("Both messenger properties provided. Provide message using only 'messenger' option, 'controllerMessenger' is deprecated");if(!t&&!e)throw new Error("Messenger not provided");m(this,n,t??e,"f"),m(this,r,a,"f"),m(this,i,c,"f"),m(this,o,d,"f")}registerActionHandler(e,t){if(!u(this,s,"m",l).call(this,e))throw new Error(`Only allowed registering action handlers prefixed by '${u(this,r,"f")}:'`);u(this,n,"f").registerActionHandler(e,t)}unregisterActionHandler(e){if(!u(this,s,"m",l).call(this,e))throw new Error(`Only allowed unregistering action handlers prefixed by '${u(this,r,"f")}:'`);u(this,n,"f").unregisterActionHandler(e)}call(e,...t){if(!u(this,s,"m",d).call(this,e))throw new Error(`Action missing from allow list: ${e}`);return u(this,n,"f").call(e,...t)}registerInitialEventPayload({eventType:e,getPayload:t}){if(!u(this,s,"m",l).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,r,"f")}:'`);u(this,n,"f").registerInitialEventPayload({eventType:e,getPayload:t})}publish(e,...t){if(!u(this,s,"m",l).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,r,"f")}:'`);u(this,n,"f").publish(e,...t)}subscribe(e,t,a){if(!u(this,s,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);return a?u(this,n,"f").subscribe(e,t,a):u(this,n,"f").subscribe(e,t)}unsubscribe(e,t){if(!u(this,s,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);u(this,n,"f").unsubscribe(e,t)}clearEventSubscriptions(e){if(!u(this,s,"m",l).call(this,e))throw new Error(`Only allowed clearing events prefixed by '${u(this,r,"f")}:'`);u(this,n,"f").clearEventSubscriptions(e)}}a.RestrictedMessenger=p,a.RestrictedControllerMessenger=p,n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,s=new WeakSet,c=function(e){const t=u(this,o,"f");return u(this,s,"m",l).call(this,e)||null!==t&&t.includes(e)},d=function(e){const t=u(this,i,"f");return u(this,s,"m",l).call(this,e)||null!==t&&t.includes(e)},l=function(e){return e.startsWith(`${u(this,r,"f")}:`)}}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"}],[2179,{"./BaseControllerV1.cjs":2175,"./BaseControllerV2.cjs":2176,"./Messenger.cjs":2177,"./RestrictedMessenger.cjs":2178},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.RestrictedMessenger=a.RestrictedControllerMessenger=a.Messenger=a.ControllerMessenger=a.isBaseController=a.getPersistentState=a.getAnonymizedState=a.BaseController=a.isBaseControllerV1=a.BaseControllerV1=void 0;var s=e("./BaseControllerV1.cjs");Object.defineProperty(a,"BaseControllerV1",{enumerable:!0,get:function(){return s.BaseControllerV1}}),Object.defineProperty(a,"isBaseControllerV1",{enumerable:!0,get:function(){return s.isBaseControllerV1}});var n=e("./BaseControllerV2.cjs");Object.defineProperty(a,"BaseController",{enumerable:!0,get:function(){return n.BaseController}}),Object.defineProperty(a,"getAnonymizedState",{enumerable:!0,get:function(){return n.getAnonymizedState}}),Object.defineProperty(a,"getPersistentState",{enumerable:!0,get:function(){return n.getPersistentState}}),Object.defineProperty(a,"isBaseController",{enumerable:!0,get:function(){return n.isBaseController}});var r=e("./Messenger.cjs");Object.defineProperty(a,"ControllerMessenger",{enumerable:!0,get:function(){return r.ControllerMessenger}}),Object.defineProperty(a,"Messenger",{enumerable:!0,get:function(){return r.Messenger}});var i=e("./RestrictedMessenger.cjs");Object.defineProperty(a,"RestrictedControllerMessenger",{enumerable:!0,get:function(){return i.RestrictedControllerMessenger}}),Object.defineProperty(a,"RestrictedMessenger",{enumerable:!0,get:function(){return i.RestrictedMessenger}})}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/index.cjs"}],[2180,{"./constants.cjs":2181,"@metamask/base-controller":1211,"@metamask/controller-utils":1288},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)};Object.defineProperty(a,"__esModule",{value:!0}),a.PreferencesController=a.getDefaultPreferencesState=void 0;const i=e("@metamask/base-controller"),o=e("@metamask/controller-utils"),c=e("./constants.cjs"),d={featureFlags:{persist:!0,anonymous:!0},identities:{persist:!0,anonymous:!1},ipfsGateway:{persist:!0,anonymous:!1},isIpfsGatewayEnabled:{persist:!0,anonymous:!0},isMultiAccountBalancesEnabled:{persist:!0,anonymous:!0},lostIdentities:{persist:!0,anonymous:!1},openSeaEnabled:{persist:!0,anonymous:!0},securityAlertsEnabled:{persist:!0,anonymous:!0},selectedAddress:{persist:!0,anonymous:!1},showTestNetworks:{persist:!0,anonymous:!0},showIncomingTransactions:{persist:!0,anonymous:!0},useNftDetection:{persist:!0,anonymous:!0},useTokenDetection:{persist:!0,anonymous:!0},smartTransactionsOptInStatus:{persist:!0,anonymous:!1},useTransactionSimulations:{persist:!0,anonymous:!0},useMultiRpcMigration:{persist:!0,anonymous:!0},useSafeChainsListValidation:{persist:!0,anonymous:!0},tokenSortConfig:{persist:!0,anonymous:!0},privacyMode:{persist:!0,anonymous:!0}};function l(){return{featureFlags:{},identities:{},ipfsGateway:"https://ipfs.io/ipfs/",isIpfsGatewayEnabled:!0,isMultiAccountBalancesEnabled:!0,lostIdentities:{},openSeaEnabled:!1,securityAlertsEnabled:!1,selectedAddress:"",showIncomingTransactions:{[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MAINNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.GOERLI]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.BSC]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.BSC_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.OPTIMISM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.OPTIMISM_SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.POLYGON]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.POLYGON_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.AVALANCHE]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.AVALANCHE_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.FANTOM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.FANTOM_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_GOERLI]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_MAINNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONBEAM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONBEAM_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONRIVER]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.GNOSIS]:!0},showTestNetworks:!1,useNftDetection:!1,useTokenDetection:!0,useMultiRpcMigration:!0,smartTransactionsOptInStatus:!0,useTransactionSimulations:!0,useSafeChainsListValidation:!0,tokenSortConfig:{key:"tokenFiatAmount",order:"dsc",sortCallback:"stringNumeric"},privacyMode:!1}}a.getDefaultPreferencesState=l;class m extends i.BaseController{constructor({messenger:e,state:t}){super({name:"PreferencesController",metadata:d,messenger:e,state:{...l(),...t}}),s.add(this),e.subscribe("KeyringController:stateChange",e=>{const t=new Set;for(const a of e.keyrings)for(const e of a.accounts)t.add(e);t.size>0&&r(this,s,"m",n).call(this,Array.from(t))})}addIdentities(e){const t=e.map(e=>(0,o.toChecksumHexAddress)(e));this.update(e=>{const{identities:a}=e;for(const e of t){if(a[e])continue;const t=Object.keys(a).length;a[e]={name:`Account ${t+1}`,address:e,importTime:Date.now()}}})}removeIdentity(e){e=(0,o.toChecksumHexAddress)(e);const{identities:t}=this.state;t[e]&&this.update(t=>{delete t.identities[e],e===t.selectedAddress&&(t.selectedAddress=Object.keys(t.identities)[0])})}setAccountLabel(e,t){e=(0,o.toChecksumHexAddress)(e),this.update(a=>{const s=a.identities[e]||{};s.name=t,a.identities[e]=s})}setFeatureFlag(e,t){this.update(a=>{a.featureFlags[e]=t})}setSelectedAddress(e){this.update(t=>{t.selectedAddress=(0,o.toChecksumHexAddress)(e)})}setIpfsGateway(e){this.update(t=>{t.ipfsGateway=e})}setUseTokenDetection(e){this.update(t=>{t.useTokenDetection=e})}setUseNftDetection(e){if(e&&!this.state.openSeaEnabled)throw new Error("useNftDetection cannot be enabled if openSeaEnabled is false");this.update(t=>{t.useNftDetection=e})}setOpenSeaEnabled(e){this.update(t=>{t.openSeaEnabled=e,e||(t.useNftDetection=!1)})}setSecurityAlertsEnabled(e){this.update(t=>{t.securityAlertsEnabled=e})}setIsMultiAccountBalancesEnabled(e){this.update(t=>{t.isMultiAccountBalancesEnabled=e})}setShowTestNetworks(e){this.update(t=>{t.showTestNetworks=e})}setIsIpfsGatewayEnabled(e){this.update(t=>{t.isIpfsGatewayEnabled=e})}setEnableNetworkIncomingTransactions(e,t){Object.values(c.ETHERSCAN_SUPPORTED_CHAIN_IDS).includes(e)&&this.update(a=>{a.showIncomingTransactions={...this.state.showIncomingTransactions,[e]:t}})}setUseMultiRpcMigration(e){this.update(t=>{t.useMultiRpcMigration=e,e||(t.useMultiRpcMigration=!1)})}setSmartTransactionsOptInStatus(e){this.update(t=>{t.smartTransactionsOptInStatus=e})}setUseTransactionSimulations(e){this.update(t=>{t.useTransactionSimulations=e})}setTokenSortConfig(e){this.update(t=>{t.tokenSortConfig=e})}setUseSafeChainsListValidation(e){this.update(t=>{t.useSafeChainsListValidation=e})}setPrivacyMode(e){this.update(t=>{t.privacyMode=e})}}a.PreferencesController=m,s=new WeakSet,n=function(e){e=e.map(e=>(0,o.toChecksumHexAddress)(e)),this.update(t=>{const{identities:a}=t,s={};for(const[t,n]of Object.entries(a))e.includes(t)||(s[t]=n,delete a[t]);for(const[e,a]of Object.entries(s))t.lostIdentities[e]=a}),this.addIdentities(e),e.includes(this.state.selectedAddress)||this.update(t=>{t.selectedAddress=e[0]})},a.default=m}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/PreferencesController.cjs"}],[2181,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.ETHERSCAN_SUPPORTED_CHAIN_IDS=void 0,a.ETHERSCAN_SUPPORTED_CHAIN_IDS={MAINNET:"0x1",GOERLI:"0x5",BSC:"0x38",BSC_TESTNET:"0x61",OPTIMISM:"0xa",OPTIMISM_SEPOLIA:"0xaa37dc",POLYGON:"0x89",POLYGON_TESTNET:"0x13881",AVALANCHE:"0xa86a",AVALANCHE_TESTNET:"0xa869",FANTOM:"0xfa",FANTOM_TESTNET:"0xfa2",SEPOLIA:"0xaa36a7",LINEA_GOERLI:"0xe704",LINEA_SEPOLIA:"0xe705",LINEA_MAINNET:"0xe708",MOONBEAM:"0x504",MOONBEAM_TESTNET:"0x507",MOONRIVER:"0x505",GNOSIS:"0x64"}}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/constants.cjs"}],[2182,{"./PreferencesController.cjs":2180,"./constants.cjs":2181},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),a.ETHERSCAN_SUPPORTED_CHAIN_IDS=void 0,n(e("./PreferencesController.cjs"),a);var r=e("./constants.cjs");Object.defineProperty(a,"ETHERSCAN_SUPPORTED_CHAIN_IDS",{enumerable:!0,get:function(){return r.ETHERSCAN_SUPPORTED_CHAIN_IDS}})}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/index.cjs"}],[2183,{"../../sdk/index.cjs":2210,"./auth-snap-requests.cjs":2184,"@metamask/base-controller":1211},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s,n,r,i,o,c,d,l,m,u,p,h,f,b,g=this&&this.__classPrivateFieldGet||function(e,t,a,s){if("a"===a&&!s)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?s:"a"===a?s.call(e):s?s.value:t.get(e)},y=this&&this.__classPrivateFieldSet||function(e,t,a,s,n){if("m"===s)throw new TypeError("Private method is not writable");if("a"===s&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===s?n.call(e,a):n?n.value=a:t.set(e,a),a};Object.defineProperty(a,"__esModule",{value:!0}),a.defaultState=void 0;const _=e("@metamask/base-controller"),w=e("./auth-snap-requests.cjs"),v=e("../../sdk/index.cjs");a.defaultState={isSignedIn:!1};const T={isSignedIn:{persist:!0,anonymous:!0},srpSessionData:{persist:!0,anonymous:!1}};class E extends _.BaseController{constructor({messenger:e,state:t,config:u,metametrics:h}){if(super({messenger:e,metadata:T,name:"AuthenticationController",state:{...a.defaultState,...t}}),s.add(this),n.set(this,void 0),r.set(this,void 0),i.set(this,{env:v.Env.PRD}),o.set(this,!1),c.set(this,{setupLockedStateSubscriptions:()=>{const{isUnlocked:e}=this.messagingSystem.call("KeyringController:getState");y(this,o,e,"f"),this.messagingSystem.subscribe("KeyringController:unlock",()=>{y(this,o,!0,"f")}),this.messagingSystem.subscribe("KeyringController:lock",()=>{y(this,o,!1,"f")})}}),f.set(this,{}),!h)throw new Error("`metametrics` field is required");y(this,i,{...g(this,i,"f"),...u},"f"),y(this,n,h,"f"),y(this,r,new v.JwtBearerAuth({env:g(this,i,"f").env,platform:h.agent,type:v.AuthType.SRP},{storage:{getLoginResponse:g(this,s,"m",l).bind(this),setLoginResponse:g(this,s,"m",m).bind(this)},signing:{getIdentifier:g(this,s,"m",p).bind(this),signMessage:g(this,s,"m",b).bind(this)},metametrics:g(this,n,"f")}),"f"),g(this,c,"f").setupLockedStateSubscriptions(),g(this,s,"m",d).call(this)}async performSignIn(){g(this,s,"m",u).call(this,"performSignIn");const e=await g(this,s,"m",h).call(this),t=[];for(const[a]of e){const e=await g(this,r,"f").getAccessToken(a);t.push(e)}return t}performSignOut(){this.update(e=>{e.isSignedIn=!1,e.srpSessionData=undefined})}async getBearerToken(e){return g(this,s,"m",u).call(this,"getBearerToken"),await g(this,r,"f").getAccessToken(e)}async getSessionProfile(e){return g(this,s,"m",u).call(this,"getSessionProfile"),await g(this,r,"f").getUserProfile(e)}async getUserProfileLineage(){return g(this,s,"m",u).call(this,"getUserProfileLineage"),await g(this,r,"f").getUserProfileLineage()}isSignedIn(){return this.state.isSignedIn}}n=new WeakMap,r=new WeakMap,i=new WeakMap,o=new WeakMap,c=new WeakMap,f=new WeakMap,s=new WeakSet,d=function(){this.messagingSystem.registerActionHandler("AuthenticationController:getBearerToken",this.getBearerToken.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:getSessionProfile",this.getSessionProfile.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:isSignedIn",this.isSignedIn.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:performSignIn",this.performSignIn.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:performSignOut",this.performSignOut.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:getUserProfileLineage",this.getUserProfileLineage.bind(this))},l=async function(e){if(e)return this.state.srpSessionData?.[e]?this.state.srpSessionData[e]:null;const t=Object.values(this.state.srpSessionData||{})?.[0];return t||null},m=async function(e,t){const a=await g(this,n,"f").getMetaMetricsId();this.update(s=>{t&&(s.isSignedIn=!0,s.srpSessionData||(s.srpSessionData={}),s.srpSessionData[t]={...e,profile:{...e.profile,metaMetricsId:a}})})},u=function(e){if(!g(this,o,"f"))throw new Error(`${e} - unable to proceed, wallet is locked`)},p=async function(e){g(this,s,"m",u).call(this,"#snapGetPublicKey");return await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapPublicKeyRequest)(e))},h=async function(){g(this,s,"m",u).call(this,"#snapGetAllPublicKeys");return await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapAllPublicKeysRequest)())},b=async function(e,t){if((0,v.assertMessageStartsWithMetamask)(e),g(this,f,"f")[e])return g(this,f,"f")[e];g(this,s,"m",u).call(this,"#snapSignMessage");const a=await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapSignMessageRequest)(e,t));return g(this,f,"f")[e]=a,a},a.default=E}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/AuthenticationController.cjs"}],[2185,{"./AuthenticationController.cjs":2183,"./mocks/index.cjs":2186},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),r=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)},i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&s(t,e,a);return n(t,e),t},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(a,"__esModule",{value:!0}),a.Mocks=a.Controller=void 0;const c=o(e("./AuthenticationController.cjs"));a.Controller=c.default;const d=c.default;a.default=d,r(e("./AuthenticationController.cjs"),a),a.Mocks=i(e("./mocks/index.cjs"))}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/index.cjs"}],[2186,{"./mockResponses.cjs":2187},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){var s=this&&this.__createBinding||(Object.create?function(e,t,a,s){s===undefined&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,n)}:function(e,t,a,s){s===undefined&&(s=a),e[s]=t[a]}),n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||s(t,e,a)};Object.defineProperty(a,"__esModule",{value:!0}),n(e("./mockResponses.cjs"),a)}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/index.cjs"}],[2187,{"../../../sdk/mocks/auth.cjs":2211},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.getMockAuthAccessTokenResponse=a.MOCK_OATH_TOKEN_RESPONSE=a.getMockAuthLoginResponse=a.MOCK_LOGIN_RESPONSE=a.getMockAuthNonceResponse=a.MOCK_JWT=a.MOCK_NONCE=a.MOCK_NONCE_RESPONSE=void 0;const s=e("../../../sdk/mocks/auth.cjs");a.MOCK_NONCE_RESPONSE=s.MOCK_NONCE_RESPONSE,a.MOCK_NONCE=a.MOCK_NONCE_RESPONSE.nonce,a.MOCK_JWT=s.MOCK_JWT;a.getMockAuthNonceResponse=()=>({url:s.MOCK_NONCE_URL,requestMethod:"GET",response:(e,t,s)=>{const n=t?.split("?identifier=")[1],r=s?.(n??"");return{...a.MOCK_NONCE_RESPONSE,nonce:r??a.MOCK_NONCE_RESPONSE.nonce,identifier:a.MOCK_NONCE_RESPONSE.identifier}}}),a.MOCK_LOGIN_RESPONSE=s.MOCK_SRP_LOGIN_RESPONSE;a.getMockAuthLoginResponse=()=>({url:s.MOCK_SRP_LOGIN_URL,requestMethod:"POST",response:e=>{const t=e?.raw_message.split(":"),s=t?.[t.length-2];return{...a.MOCK_LOGIN_RESPONSE,token:s??a.MOCK_LOGIN_RESPONSE.token,profile:{...a.MOCK_LOGIN_RESPONSE.profile,profile_id:s??a.MOCK_LOGIN_RESPONSE.profile.profile_id,identifier_id:s??a.MOCK_LOGIN_RESPONSE.profile.identifier_id}}}}),a.MOCK_OATH_TOKEN_RESPONSE=s.MOCK_OIDC_TOKEN_RESPONSE;a.getMockAuthAccessTokenResponse=()=>({url:s.MOCK_OIDC_TOKEN_URL,requestMethod:"POST",response:e=>{const t=new URLSearchParams(e).get("assertion");return{...a.MOCK_OATH_TOKEN_RESPONSE,access_token:t??a.MOCK_OATH_TOKEN_RESPONSE.access_token}}})}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/mockResponses.cjs"}],[219,{"../../../../shared/constants/app":5294,"../../../../shared/constants/verification":5329,"../../../../shared/modules/selectors/networks":5417,"@ethersproject/hash":581,"@ethersproject/wallet":648,"@metamask/rpc-errors":2283,"@metamask/utils":2682},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.createTxVerificationMiddleware=function(e,t=o.TRUSTED_SIGNERS){return function(a,l,m,u){if(a.method!==c.MESSAGE_TYPE.ETH_SEND_TRANSACTION||!Array.isArray(a.params)||!function(e){return(0,i.isObject)(e[0])&&"string"==typeof e[0].data&&"string"==typeof e[0].from&&"string"==typeof e[0].to&&"string"==typeof e[0].value&&(!(0,i.hasProperty)(e[0],"chainId")||"string"==typeof e[0].chainId&&e[0].chainId.startsWith("0x"))}(a.params))return m();const p=a.params[0],h="string"==typeof p.chainId?p.chainId.toLowerCase():(0,d.getCurrentChainId)({metamask:e.state}),f=(0,o.getExperience)(p.to.toLowerCase(),h);if(!f||!o.EXPERIENCES_TO_VERIFY.includes(f))return m();const b=`0x${p.data.slice(-o.TX_SIG_LEN)}`,g=(0,n.verifyMessage)(function(e){const t={to:(0,s.hashMessage)(e.to.toLowerCase()),from:(0,s.hashMessage)(e.from.toLowerCase()),data:(0,s.hashMessage)(e.data.toLowerCase().slice(0,e.data.length-o.TX_SIG_LEN)),value:(0,s.hashMessage)(e.value.toLowerCase())};return(0,s.hashMessage)(JSON.stringify(t))}(p),b);return g!==t[f]?u(r.rpcErrors.invalidParams("Invalid transaction signature.")):m()}};var s=e("@ethersproject/hash"),n=e("@ethersproject/wallet"),r=e("@metamask/rpc-errors"),i=e("@metamask/utils"),o=e("../../../../shared/constants/verification"),c=e("../../../../shared/constants/app"),d=e("../../../../shared/modules/selectors/networks")}}},{package:"$root$",file:"app/scripts/lib/tx-verification/tx-verification-middleware.ts"}],[22,{"../../../../shared/constants/metametrics":5307,"../../../../shared/lib/sentry":5382,"../../../../shared/lib/trace":5388,"../../../../shared/modules/environment":5401,"@metamask/profile-sync-controller/user-storage":2200},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,a){Object.defineProperty(a,"__esModule",{value:!0}),a.UserStorageControllerInit=void 0;var s=e("@metamask/profile-sync-controller/user-storage"),n=e("../../../../shared/modules/environment"),r=e("../../../../shared/constants/metametrics"),i=e("../../../../shared/lib/trace"),o=e("../../../../shared/lib/sentry");a.UserStorageControllerInit=e=>{const{controllerMessenger:t,persistedState:a,trackEvent:c}=e;return{controller:new s.Controller({messenger:t,state:a.UserStorageController,trace:i.trace,config:{accountSyncing:{maxNumberOfAccountsToAdd:(0,n.isProduction)()?undefined:100,onAccountAdded:e=>{c({category:r.MetaMetricsEventCategory.BackupAndSync,event:r.MetaMetricsEventName.AccountsSyncAdded,properties:{profile_id:e}})},onAccountNameUpdated:e=>{c({category:r.MetaMetricsEventCategory.BackupAndSync,event:r.MetaMetricsEventName.AccountsSyncNameUpdated,properties:{profile_id:e}})},onAccountSyncErroneousSituation:(e,t,a)=>{(0,o.captureException)(new Error(`Account sync - ${t}`),a),c({category:r.MetaMetricsEventCategory.BackupAndSync,event:r.MetaMetricsEventName.AccountsSyncErroneousSituation,properties:{profile_id:e,situation_message:t}})}},contactSyncing:{onContactUpdated:e=>{c({category:r.MetaMetricsEventCategory.BackupAndSync,event:r.MetaMetricsEventName.ProfileActivityUpdated,properties:{profile_id:e,feature_name:"Backup And Sync",action:"Contacts Sync Contact Updated"}})},onContactDeleted:e=>{c({category:r.MetaMetricsEventCategory.BackupAndSync,event:r.MetaMetricsEventName.ProfileActivityUpdated,properties:{profile_id:e,feature_name:"Backup And Sync",action:"Contacts Sync Contact Deleted"}})},onContactSyncErroneousSituation:(e,t,a)=>{(0,o.captureException)(new Error(`Contact sync - ${t}`),a),c({category:r.MetaMetricsEventCategory.BackupAndSync,event:r.MetaMetricsEventName.ProfileActivityUpdated,properties:{profile_id:e,feature_name:"Backup And Sync",action:"Contacts Sync Erroneous Situation",additional_description:t}})}}}})}}}}},{package:"$root$",file:"app/scripts/controller-init/identity/user-storage-controller-init.ts"}]],[],{});