LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={openrpc:"1.2.4",info:{title:"MetaMask MultiChain API",version:"1.0.0",description:"This provides the specs for the MultiChain API Layer for the MetaMask API"},methods:[{name:"wallet_notify",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"notification",description:"an object containing a JSON-RPC notification with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}]},{name:"wallet_invokeMethod",paramStructure:"by-name",params:[{name:"scope",description:"a valid `scope` string that has been previously authorized via `provider_authorize`",required:!0,schema:{$ref:"#/components/schemas/ScopeString"}},{name:"request",description:"an object containing a JSON-RPC request with `method` and `params`",deprecated:!1,required:!0,schema:{type:"object",properties:{method:{type:"string"},params:!0}}}],result:{name:"wallet_invokeMethodResult",schema:!0},examples:[{name:"wallet_invokeMethodExample",params:[{name:"scope",value:"eip155:1"},{name:"request",value:{method:"eth_getBalance",params:[]}}],result:{name:"wallet_invokeMethodResult",value:"0x1"}}]},{name:"wallet_revokeSession",description:"The `wallet_revokeSession` method revokes the entire active session.",params:[],result:{name:"wallet_revokeSessionResult",schema:{type:"boolean"}},examples:[{name:"wallet_revokeSessionExample",params:[],result:{name:"wallet_revokeSessionExampleResult",value:!0}}],errors:[{$ref:"#/components/errors/UnknownError"}]},{name:"wallet_sessionChanged",paramStructure:"by-name",description:"This notification is published by the wallet to notify the callers of updates to a shared session's authorization scopes. The event payload contains the new `sessionScopes`.",params:[{name:"sessionScopes",schema:{$ref:"#/components/schemas/SessionScopes"}}],examples:[{name:"wallet_sessionChangedExample",description:"Example of a wallet_sessionChanged notification.",params:[{name:"sessionScopes",value:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}]}]},{name:"wallet_getSession",description:"The `wallet_getSession` method returns an active session.",params:[],result:{name:"wallet_getSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"}}}},examples:[{name:"wallet_getSessionExample",description:"Example of a getSession request.",params:[],result:{name:"wallet_getSessionResultExample",value:{sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}}]},{name:"wallet_createSession",paramStructure:"by-name",params:[{name:"requiredScopes",description:"Scopes that the wallet must support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"optionalScopes",description:"Scopes that the wallet may support in order to be used with this provider.",schema:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}}},{name:"sessionProperties",description:"Properties that the wallet may use to determine if the session is valid.",schema:{type:"object"}}],result:{name:"wallet_createSessionResult",schema:{type:"object",properties:{sessionScopes:{$ref:"#/components/schemas/SessionScopes"},sessionProperties:{type:"object"}}}},examples:[{name:"wallet_createSessionEthExample",description:"Example of a createSession request.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{methods:["wallet_addEthereumChain"],notifications:[]}}}],result:{name:"wallet_createSessionResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionEthUnsupportedMethodsExample",description:"Example of a createSession request with unsupported eip155 methods.",params:[{name:"optionalScopes",value:{"eip155:1337":{methods:["not_supported"],notifications:[]},wallet:{methods:[],notifications:[]},"wallet:eip155":{methods:[],notifications:[]}}}],result:{name:"wallet_createSessionEthUnsupportedMethodsResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1337":{accounts:["eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]},wallet:{accounts:[],methods:["wallet_registerOnboarding","wallet_scanQRCode"],notifications:[]},"wallet:eip155":{accounts:["wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["wallet_addEthereumChain"],notifications:[]}}}}},{name:"wallet_createSessionUnsupportedScopesExample",description:"Example of a createSession request with unsupported scopes.",params:[{name:"optionalScopes",value:{foobar:{methods:["eth_getBalance"],notifications:["eth_subscription"]},"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}],result:{name:"wallet_createSessionUnsupportedScopesResultExample",value:{sessionProperties:{},sessionScopes:{"eip155:1":{accounts:["eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"],methods:["personal_sign","eth_signTypedData_v4","wallet_watchAsset","eth_sendTransaction","eth_decrypt","eth_getEncryptionPublicKey","web3_clientVersion","eth_subscribe","eth_unsubscribe","wallet_swapAsset","eth_blockNumber","eth_call","eth_chainId","eth_estimateGas","eth_feeHistory","eth_gasPrice","eth_getBalance","eth_getBlockByHash","eth_getBlockByNumber","eth_getBlockTransactionCountByHash","eth_getBlockTransactionCountByNumber","eth_getCode","eth_getFilterChanges","eth_getFilterLogs","eth_getLogs","eth_getProof","eth_getStorageAt","eth_getTransactionByBlockHashAndIndex","eth_getTransactionByBlockNumberAndIndex","eth_getTransactionByHash","eth_getTransactionCount","eth_getTransactionReceipt","eth_getUncleCountByBlockHash","eth_getUncleCountByBlockNumber","eth_newBlockFilter","eth_newFilter","eth_newPendingTransactionFilter","eth_sendRawTransaction","eth_syncing","eth_uninstallFilter"],notifications:["eth_subscription"]}}}}}],errors:[{$ref:"#/components/errors/UnknownError"},{code:5100,message:"Requested networks are not supported"},{code:5101,message:"Requested methods are not supported"},{code:5102,message:"Requested notifications are not supported"},{code:5300,message:"Invalid scopedProperties requested"},{code:5301,message:"scopedProperties can only be outside of sessionScopes"},{code:5302,message:"Invalid sessionProperties requested"}]}],components:{errors:{UnknownError:{code:5e3,message:"Unknown error with request"}},schemas:{SessionScopes:{type:"object",patternProperties:{"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?":{$ref:"#/components/schemas/Scope"}}},ScopeString:{type:"string",pattern:"[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?"},Scope:{type:"object",title:"Scope",description:"Scope for a multi-chain connection",additionalProperties:!0,required:["notifications","methods"],properties:{scopes:{type:"array",items:{$ref:"#/components/schemas/ScopeString"}},methods:{description:"Methods that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},notifications:{description:"Notifications that the wallet must support in order to be used with this provider.",type:"array",items:{type:"string"}},rpcEndpoints:{description:"JSON-RPC endpoints for this namespace.",type:"array",items:{type:"string",format:"uri"}},rpcDocuments:{type:"array",description:"OpenRPC documents that define RPC methods in which to anchor the methods authorized in a CAIP-25 interaction.",items:{type:"string",format:"uri"}}}}}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js",{"./build/multichain-openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json","./build/openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.MultiChainOpenRPCDocument=s.MetaMaskOpenRPCDocument=void 0;const a=n(e("./build/openrpc.json"));s.MetaMaskOpenRPCDocument=a.default;const i=n(e("./build/multichain-openrpc.json"));s.MultiChainOpenRPCDocument=i.default,s.default=a.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-accounts.cjs",{"../scope/constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/constants.cjs","../scope/transform.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs","../scope/types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isCaipAccountIdInPermittedAccountIds=s.isInternalAccountInPermittedAccountIds=s.setNonSCACaipAccountIdsInCaip25CaveatValue=s.getCaipAccountIdsFromCaip25CaveatValue=s.getCaipAccountIdsFromScopesObjects=s.setEthAccounts=s.getEthAccounts=void 0;const n=e("@metamask/controller-utils"),a=e("@metamask/utils"),i=e("../scope/constants.cjs"),o=e("../scope/transform.cjs"),r=e("../scope/types.cjs"),c=e=>{const{namespace:t}=(0,r.parseScopeString)(e);return t===a.KnownCaipNamespace.Eip155||e===i.KnownWalletScopeString.Eip155},l=e=>{const t=[];return Object.entries(e).forEach((([e,{accounts:s}])=>{s?.forEach((e=>{const{address:s,chainId:n}=(0,a.parseCaipAccountId)(e);c(n)&&((0,a.assertIsStrictHexString)(s),t.push(s))}))})),t};s.getEthAccounts=e=>{const{requiredScopes:t,optionalScopes:s}=e,n=[...l(t),...l(s)];return(0,o.getUniqueArrayItems)(n)};const m=(e,t)=>{const s={};return Object.entries(e).forEach((([e,n])=>{const i=e,o=i===a.KnownCaipNamespace.Wallet,{namespace:l,reference:m}=(0,r.parseScopeString)(i);if(!c(i)&&!o)return void(s[i]=n);let d=[];l&&m&&(d=t.map((e=>`${l}:${m}:${e}`))),s[i]={...n,accounts:d}})),s};function d(e){const t=new Set;for(const s of e)for(const{accounts:e}of Object.values(s))for(const s of e)t.add(s);return Array.from(t)}s.setEthAccounts=(e,t)=>({...e,requiredScopes:m(e.requiredScopes,t),optionalScopes:m(e.optionalScopes,t)}),s.getCaipAccountIdsFromScopesObjects=d,s.getCaipAccountIdsFromCaip25CaveatValue=function(e){return d([e.requiredScopes,e.optionalScopes])};const u=(e,t)=>{const s=new Map;for(const e of t){const{chain:{namespace:t},address:n}=(0,a.parseCaipAccountId)(e);s.has(t)||s.set(t,new Set),s.get(t)?.add(n)}const n={};for(const[t,a]of Object.entries(e)){const{namespace:e,reference:i}=(0,r.parseScopeString)(t);let c=[];if(e&&i&&s.has(e)){const t=s.get(e);t&&(c=Array.from(t).map((t=>`${e}:${i}:${t}`)))}n[t]={...a,accounts:(0,o.getUniqueArrayItems)(c)}}return n};function h(e,t,s){return!!(e&&t.length&&s.length)&&s.some((s=>{const i=(0,a.parseCaipAccountId)(s);return t.some((({namespace:t,reference:s})=>t===i.chain.namespace&&(t===a.KnownCaipNamespace.Eip155?("0"===s||s===i.chain.reference)&&(0,n.isEqualCaseInsensitive)(e,i.address):s===i.chain.reference&&e===i.address)))}))}s.setNonSCACaipAccountIdsInCaip25CaveatValue=(e,t)=>({...e,requiredScopes:u(e.requiredScopes,t),optionalScopes:u(e.optionalScopes,t)}),s.isInternalAccountInPermittedAccountIds=function(e,t){const s=e.scopes.map((e=>(0,r.parseScopeString)(e)));return h(e.address,s,t)},s.isCaipAccountIdInPermittedAccountIds=function(e,t){const{address:s,chain:n}=(0,a.parseCaipAccountId)(e);return h(s,[n],t)}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-accounts.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-permittedChains.cjs",{"../caip25Permission.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/caip25Permission.cjs","../scope/transform.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs","../scope/types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.setChainIdsInCaip25CaveatValue=s.addCaipChainIdInCaip25CaveatValue=s.getAllScopesFromPermission=s.getAllNamespacesFromCaip25CaveatValue=s.getAllScopesFromCaip25CaveatValue=s.getAllScopesFromScopesObjects=s.setPermittedEthChainIds=s.addPermittedEthChainId=s.getPermittedEthChainIds=void 0;const n=e("@metamask/controller-utils"),a=e("@metamask/utils"),i=e("../caip25Permission.cjs"),o=e("../scope/transform.cjs"),r=e("../scope/types.cjs"),c=e=>{const t=[];return Object.keys(e).forEach((e=>{const{namespace:s,reference:i}=(0,r.parseScopeString)(e);s===a.KnownCaipNamespace.Eip155&&i&&t.push((0,n.toHex)(i))})),t};s.getPermittedEthChainIds=e=>{const{requiredScopes:t,optionalScopes:s}=e,n=[...c(t),...c(s)];return(0,o.getUniqueArrayItems)(n)};s.addPermittedEthChainId=(e,t)=>{const s=`eip155:${(0,a.hexToBigInt)(t).toString(10)}`;return Object.keys(e.requiredScopes).includes(s)||Object.keys(e.optionalScopes).includes(s)?e:{...e,optionalScopes:{...e.optionalScopes,[s]:{accounts:[]}}}};const l=(e,t)=>{const s={};return Object.entries(e).forEach((([e,i])=>{const o=e,{namespace:c,reference:l}=(0,r.parseScopeString)(o);if(l)if(c===a.KnownCaipNamespace.Eip155){const e=(0,n.toHex)(l);t.includes(e)&&(s[o]=i)}else s[o]=i;else s[o]=i})),s};function m(e){const t=new Set;for(const s of e)for(const e of Object.keys(s))t.add(e);return Array.from(t)}function d(e){return m([e.requiredScopes,e.optionalScopes])}s.setPermittedEthChainIds=(e,t)=>{let n={...e,requiredScopes:l(e.requiredScopes,t),optionalScopes:l(e.optionalScopes,t)};return t.forEach((e=>{n=(0,s.addPermittedEthChainId)(n,e)})),n},s.getAllScopesFromScopesObjects=m,s.getAllScopesFromCaip25CaveatValue=d,s.getAllNamespacesFromCaip25CaveatValue=function(e){const t=d(e),s=new Set;for(const e of t){const{namespace:t,reference:n}=(0,r.parseScopeString)(e);t===a.KnownCaipNamespace.Wallet?s.add(n??t):t&&s.add(t)}return Array.from(s)},s.getAllScopesFromPermission=function(e){const t=e.caveats.find((e=>e.type===i.Caip25CaveatType));return t?d(t.value):[]};s.addCaipChainIdInCaip25CaveatValue=(e,t)=>e.requiredScopes[t]||e.optionalScopes[t]?e:{...e,optionalScopes:{...e.optionalScopes,[t]:{accounts:[]}}};s.setChainIdsInCaip25CaveatValue=(e,t)=>{const s=new Set(t),n={requiredScopes:{},optionalScopes:{},sessionProperties:e.sessionProperties,isMultichainOrigin:e.isMultichainOrigin};for(const[t,a]of Object.entries(e.requiredScopes)){const e=t;((0,r.isWalletScope)(e)||s.has(e))&&(n.requiredScopes[e]=a)}for(const[t,a]of Object.entries(e.optionalScopes)){const e=t;((0,r.isWalletScope)(e)||s.has(e))&&(n.optionalScopes[e]=a)}for(const e of t)n.requiredScopes[e]||n.optionalScopes[e]||(n.optionalScopes[e]={accounts:[]});return n}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-permittedChains.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-session-scopes.cjs",{"../scope/constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/constants.cjs","../scope/transform.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs","../scope/types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getPermittedAccountsForScopes=s.getSessionScopes=s.getInternalScopesObject=void 0;const n=e("@metamask/utils"),a=e("../scope/constants.cjs"),i=e("../scope/transform.cjs"),o=e("../scope/types.cjs");s.getInternalScopesObject=e=>{const t={};return Object.entries(e).forEach((([e,{accounts:s}])=>{t[e]={accounts:s}})),t};const r=(e,{getNonEvmSupportedMethods:t})=>{const s={};return Object.entries(e).forEach((([e,{accounts:i}])=>{const r=e,{namespace:c,reference:l}=(0,o.parseScopeString)(r);let m=[],d=[];r===n.KnownCaipNamespace.Wallet||c===n.KnownCaipNamespace.Wallet?m=l===n.KnownCaipNamespace.Eip155?a.KnownWalletNamespaceRpcMethods[l]:(0,n.isCaipChainId)(r)?t(r):a.KnownWalletRpcMethods:c===n.KnownCaipNamespace.Eip155?(m=a.KnownRpcMethods[c],d=a.KnownNotifications[c]):(m=t(r),d=[]),s[r]={methods:m,notifications:d,accounts:i}})),s};s.getSessionScopes=(e,{getNonEvmSupportedMethods:t})=>(0,i.mergeNormalizedScopes)(r(e.requiredScopes,{getNonEvmSupportedMethods:t}),r(e.optionalScopes,{getNonEvmSupportedMethods:t}));s.getPermittedAccountsForScopes=(e,t)=>{const s=[];return t.forEach((t=>{const n=e.requiredScopes[t],a=e.optionalScopes[t];n&&s.push(...n.accounts),a&&s.push(...a.accounts)})),[...new Set(s)]}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-session-scopes.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/caip25Permission.cjs",{"./adapters/caip-permission-adapter-accounts.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-accounts.cjs","./adapters/caip-permission-adapter-permittedChains.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-permittedChains.cjs","./scope/assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/assert.cjs","./scope/supported.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/supported.cjs","./scope/transform.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs","./scope/types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs","@metamask/permission-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getCaip25CaveatFromPermission=s.generateCaip25Caveat=s.Caip25CaveatMutators=s.caip25EndowmentBuilder=s.caip25CaveatBuilder=s.diffScopesForCaip25CaveatValue=s.createCaip25Caveat=s.Caip25EndowmentPermissionName=s.Caip25CaveatType=void 0;const n=e("@metamask/permission-controller"),a=e("@metamask/utils"),i=e("lodash"),o=e("./adapters/caip-permission-adapter-accounts.cjs"),r=e("./adapters/caip-permission-adapter-permittedChains.cjs"),c=e("./scope/assert.cjs"),l=e("./scope/supported.cjs"),m=e("./scope/transform.cjs"),d=e("./scope/types.cjs");s.Caip25CaveatType="authorizedScopes",s.Caip25EndowmentPermissionName="endowment:caip25";function u(e,t,s){const n=(0,i.cloneDeep)(e),a=t[s];for(const[e,t]of Object.entries(a)){const a=e,i=n[s][a];if(i){const e=t.accounts.filter((e=>!i?.accounts.includes(e)));if(e.length>0){n[s][a]={accounts:e};continue}delete n[s][a]}else n[s][a]=t}return n}function h(e,t,s){return Object.values(e).every((e=>e.accounts.every((e=>(0,l.isSupportedAccount)(e,{getEvmInternalAccounts:t,getNonEvmAccountAddresses:s})))))}s.createCaip25Caveat=e=>({type:s.Caip25CaveatType,value:e}),s.diffScopesForCaip25CaveatValue=u;s.caip25CaveatBuilder=({findNetworkClientIdByChainId:e,listAccounts:t,isNonEvmScopeSupported:n,getNonEvmAccountAddresses:i})=>({type:s.Caip25CaveatType,validator:(o,r,m)=>{if(!(o.value&&(0,a.hasProperty)(o.value,"requiredScopes")&&(0,a.hasProperty)(o.value,"optionalScopes")&&(0,a.hasProperty)(o.value,"isMultichainOrigin")&&(0,a.hasProperty)(o.value,"sessionProperties")&&"boolean"==typeof o.value.isMultichainOrigin&&(0,a.isObject)(o.value.sessionProperties)))throw new Error(`${s.Caip25EndowmentPermissionName} error: Received invalid value for caveat of type "${s.Caip25CaveatType}".`);const{requiredScopes:d,optionalScopes:u,sessionProperties:p}=o.value;if(!Object.keys(p).every((e=>(0,l.isSupportedSessionProperty)(e))))throw new Error(`${s.Caip25EndowmentPermissionName} error: Received unknown session property(s) for caveat of type "${s.Caip25CaveatType}".`);if((0,c.assertIsInternalScopesObject)(d),(0,c.assertIsInternalScopesObject)(u),0===Object.keys(d).length&&0===Object.keys(u).length)throw new Error(`${s.Caip25EndowmentPermissionName} error: Received no scopes for caveat of type "${s.Caip25CaveatType}".`);const f=t=>{try{return e(t),!0}catch{return!1}},g=Object.keys(d).every((e=>(0,l.isSupportedScopeString)(e,{isEvmChainIdSupported:f,isNonEvmScopeSupported:n}))),b=Object.keys(u).every((e=>(0,l.isSupportedScopeString)(e,{isEvmChainIdSupported:f,isNonEvmScopeSupported:n})));if(!g||!b)throw new Error(`${s.Caip25EndowmentPermissionName} error: Received scopeString value(s) for caveat of type "${s.Caip25CaveatType}" that are not supported by the wallet.`);const k=h(d,t,i),y=h(u,t,i);if(!k||!y)throw new Error(`${s.Caip25EndowmentPermissionName} error: Received account value(s) for caveat of type "${s.Caip25CaveatType}" that are not supported by the wallet.`)},merger:(e,t)=>{const s={requiredScopes:(0,m.mergeInternalScopes)(e.requiredScopes,t.requiredScopes),optionalScopes:(0,m.mergeInternalScopes)(e.optionalScopes,t.optionalScopes),sessionProperties:{...e.sessionProperties,...t.sessionProperties},isMultichainOrigin:e.isMultichainOrigin},n=u(e,s,"requiredScopes");return[s,u(n,s,"optionalScopes")]}});s.caip25EndowmentBuilder=Object.freeze({targetName:s.Caip25EndowmentPermissionName,specificationBuilder:()=>({permissionType:n.PermissionType.Endowment,targetName:s.Caip25EndowmentPermissionName,allowedCaveats:[s.Caip25CaveatType],endowmentGetter:e=>null,validator:e=>{if(1!==e.caveats?.length||e.caveats?.[0]?.type!==s.Caip25CaveatType)throw new Error(`${s.Caip25EndowmentPermissionName} error: Invalid caveats. There must be a single caveat of type "${s.Caip25CaveatType}".`)}})}),s.Caip25CaveatMutators={[s.Caip25CaveatType]:{removeScope:function(e,t){const s=Object.entries(e.requiredScopes).filter((([e])=>e!==t)),i=Object.entries(e.optionalScopes).filter((([e])=>e!==t)),o=s.length!==Object.keys(e.requiredScopes).length,r=i.length!==Object.keys(e.optionalScopes).length;if(!o&&!r)return{operation:n.CaveatMutatorOperation.Noop};const c={...e,requiredScopes:Object.fromEntries(s),optionalScopes:Object.fromEntries(i)};if([...s,...i].some((([e])=>{const{namespace:t}=(0,d.parseScopeString)(e);return t!==a.KnownCaipNamespace.Wallet})))return{operation:n.CaveatMutatorOperation.UpdateValue,value:c};return{operation:n.CaveatMutatorOperation.RevokePermission}},removeAccount:function(e,t){const s=(0,i.cloneDeep)(e);[s.requiredScopes,s.optionalScopes].forEach((e=>{Object.entries(e).forEach((([,e])=>{!function(e,t){e.accounts&&(e.accounts=e.accounts.filter(function(e){return t=>(0,a.parseCaipAccountId)(t).address!==e}(t)))}(e,t)}))}));if((0,i.isEqual)(s,e))return{operation:n.CaveatMutatorOperation.Noop};if([...Object.values(s.requiredScopes),...Object.values(s.optionalScopes)].some((({accounts:e})=>e.length>0)))return{operation:n.CaveatMutatorOperation.UpdateValue,value:s};return{operation:n.CaveatMutatorOperation.RevokePermission}}}};s.generateCaip25Caveat=(e,t,n)=>{const a=(0,r.setChainIdsInCaip25CaveatValue)(e,n),i=(0,o.setNonSCACaipAccountIdsInCaip25CaveatValue)(a,t);return{[s.Caip25EndowmentPermissionName]:{caveats:[{type:s.Caip25CaveatType,value:i}]}}},s.getCaip25CaveatFromPermission=function(e){return e?.caveats.find((e=>e.type===s.Caip25CaveatType))}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/caip25Permission.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/index.cjs",{"./adapters/caip-permission-adapter-accounts.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-accounts.cjs","./adapters/caip-permission-adapter-permittedChains.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-permittedChains.cjs","./adapters/caip-permission-adapter-session-scopes.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-session-scopes.cjs","./caip25Permission.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/caip25Permission.cjs","./scope/assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/assert.cjs","./scope/authorization.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/authorization.cjs","./scope/constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/constants.cjs","./scope/errors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/errors.cjs","./scope/filter.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/filter.cjs","./scope/transform.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs","./scope/types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.Caip25Errors=s.KnownSessionProperties=s.getCaip25CaveatFromPermission=s.generateCaip25Caveat=s.Caip25CaveatMutators=s.caip25EndowmentBuilder=s.Caip25EndowmentPermissionName=s.createCaip25Caveat=s.Caip25CaveatType=s.caip25CaveatBuilder=s.normalizeAndMergeScopes=s.mergeInternalScopes=s.mergeNormalizedScopes=s.mergeScopeObject=s.normalizeScope=s.getUniqueArrayItems=s.parseScopeString=s.getSupportedScopeObjects=s.isKnownSessionPropertyValue=s.KnownWalletScopeString=s.KnownNotifications=s.KnownWalletNamespaceRpcMethods=s.KnownRpcMethods=s.KnownWalletRpcMethods=s.assertIsInternalScopeString=s.isNamespaceInScopesObject=s.bucketScopes=s.validateAndNormalizeScopes=s.getPermittedAccountsForScopes=s.getSessionScopes=s.getInternalScopesObject=s.getAllScopesFromScopesObjects=s.getAllScopesFromCaip25CaveatValue=s.getAllScopesFromPermission=s.getAllNamespacesFromCaip25CaveatValue=s.addCaipChainIdInCaip25CaveatValue=s.setChainIdsInCaip25CaveatValue=s.setPermittedEthChainIds=s.addPermittedEthChainId=s.getPermittedEthChainIds=s.isCaipAccountIdInPermittedAccountIds=s.isInternalAccountInPermittedAccountIds=s.getCaipAccountIdsFromCaip25CaveatValue=s.getCaipAccountIdsFromScopesObjects=s.setNonSCACaipAccountIdsInCaip25CaveatValue=s.setEthAccounts=s.getEthAccounts=void 0;var n=e("./adapters/caip-permission-adapter-accounts.cjs");Object.defineProperty(s,"getEthAccounts",{enumerable:!0,get:function(){return n.getEthAccounts}}),Object.defineProperty(s,"setEthAccounts",{enumerable:!0,get:function(){return n.setEthAccounts}}),Object.defineProperty(s,"setNonSCACaipAccountIdsInCaip25CaveatValue",{enumerable:!0,get:function(){return n.setNonSCACaipAccountIdsInCaip25CaveatValue}}),Object.defineProperty(s,"getCaipAccountIdsFromScopesObjects",{enumerable:!0,get:function(){return n.getCaipAccountIdsFromScopesObjects}}),Object.defineProperty(s,"getCaipAccountIdsFromCaip25CaveatValue",{enumerable:!0,get:function(){return n.getCaipAccountIdsFromCaip25CaveatValue}}),Object.defineProperty(s,"isInternalAccountInPermittedAccountIds",{enumerable:!0,get:function(){return n.isInternalAccountInPermittedAccountIds}}),Object.defineProperty(s,"isCaipAccountIdInPermittedAccountIds",{enumerable:!0,get:function(){return n.isCaipAccountIdInPermittedAccountIds}});var a=e("./adapters/caip-permission-adapter-permittedChains.cjs");Object.defineProperty(s,"getPermittedEthChainIds",{enumerable:!0,get:function(){return a.getPermittedEthChainIds}}),Object.defineProperty(s,"addPermittedEthChainId",{enumerable:!0,get:function(){return a.addPermittedEthChainId}}),Object.defineProperty(s,"setPermittedEthChainIds",{enumerable:!0,get:function(){return a.setPermittedEthChainIds}}),Object.defineProperty(s,"setChainIdsInCaip25CaveatValue",{enumerable:!0,get:function(){return a.setChainIdsInCaip25CaveatValue}}),Object.defineProperty(s,"addCaipChainIdInCaip25CaveatValue",{enumerable:!0,get:function(){return a.addCaipChainIdInCaip25CaveatValue}}),Object.defineProperty(s,"getAllNamespacesFromCaip25CaveatValue",{enumerable:!0,get:function(){return a.getAllNamespacesFromCaip25CaveatValue}}),Object.defineProperty(s,"getAllScopesFromPermission",{enumerable:!0,get:function(){return a.getAllScopesFromPermission}}),Object.defineProperty(s,"getAllScopesFromCaip25CaveatValue",{enumerable:!0,get:function(){return a.getAllScopesFromCaip25CaveatValue}}),Object.defineProperty(s,"getAllScopesFromScopesObjects",{enumerable:!0,get:function(){return a.getAllScopesFromScopesObjects}});var i=e("./adapters/caip-permission-adapter-session-scopes.cjs");Object.defineProperty(s,"getInternalScopesObject",{enumerable:!0,get:function(){return i.getInternalScopesObject}}),Object.defineProperty(s,"getSessionScopes",{enumerable:!0,get:function(){return i.getSessionScopes}}),Object.defineProperty(s,"getPermittedAccountsForScopes",{enumerable:!0,get:function(){return i.getPermittedAccountsForScopes}});var o=e("./scope/authorization.cjs");Object.defineProperty(s,"validateAndNormalizeScopes",{enumerable:!0,get:function(){return o.validateAndNormalizeScopes}}),Object.defineProperty(s,"bucketScopes",{enumerable:!0,get:function(){return o.bucketScopes}}),Object.defineProperty(s,"isNamespaceInScopesObject",{enumerable:!0,get:function(){return o.isNamespaceInScopesObject}});var r=e("./scope/assert.cjs");Object.defineProperty(s,"assertIsInternalScopeString",{enumerable:!0,get:function(){return r.assertIsInternalScopeString}});var c=e("./scope/constants.cjs");Object.defineProperty(s,"KnownWalletRpcMethods",{enumerable:!0,get:function(){return c.KnownWalletRpcMethods}}),Object.defineProperty(s,"KnownRpcMethods",{enumerable:!0,get:function(){return c.KnownRpcMethods}}),Object.defineProperty(s,"KnownWalletNamespaceRpcMethods",{enumerable:!0,get:function(){return c.KnownWalletNamespaceRpcMethods}}),Object.defineProperty(s,"KnownNotifications",{enumerable:!0,get:function(){return c.KnownNotifications}}),Object.defineProperty(s,"KnownWalletScopeString",{enumerable:!0,get:function(){return c.KnownWalletScopeString}}),Object.defineProperty(s,"isKnownSessionPropertyValue",{enumerable:!0,get:function(){return c.isKnownSessionPropertyValue}});var l=e("./scope/filter.cjs");Object.defineProperty(s,"getSupportedScopeObjects",{enumerable:!0,get:function(){return l.getSupportedScopeObjects}});var m=e("./scope/types.cjs");Object.defineProperty(s,"parseScopeString",{enumerable:!0,get:function(){return m.parseScopeString}});var d=e("./scope/transform.cjs");Object.defineProperty(s,"getUniqueArrayItems",{enumerable:!0,get:function(){return d.getUniqueArrayItems}}),Object.defineProperty(s,"normalizeScope",{enumerable:!0,get:function(){return d.normalizeScope}}),Object.defineProperty(s,"mergeScopeObject",{enumerable:!0,get:function(){return d.mergeScopeObject}}),Object.defineProperty(s,"mergeNormalizedScopes",{enumerable:!0,get:function(){return d.mergeNormalizedScopes}}),Object.defineProperty(s,"mergeInternalScopes",{enumerable:!0,get:function(){return d.mergeInternalScopes}}),Object.defineProperty(s,"normalizeAndMergeScopes",{enumerable:!0,get:function(){return d.normalizeAndMergeScopes}});var u=e("./caip25Permission.cjs");Object.defineProperty(s,"caip25CaveatBuilder",{enumerable:!0,get:function(){return u.caip25CaveatBuilder}}),Object.defineProperty(s,"Caip25CaveatType",{enumerable:!0,get:function(){return u.Caip25CaveatType}}),Object.defineProperty(s,"createCaip25Caveat",{enumerable:!0,get:function(){return u.createCaip25Caveat}}),Object.defineProperty(s,"Caip25EndowmentPermissionName",{enumerable:!0,get:function(){return u.Caip25EndowmentPermissionName}}),Object.defineProperty(s,"caip25EndowmentBuilder",{enumerable:!0,get:function(){return u.caip25EndowmentBuilder}}),Object.defineProperty(s,"Caip25CaveatMutators",{enumerable:!0,get:function(){return u.Caip25CaveatMutators}}),Object.defineProperty(s,"generateCaip25Caveat",{enumerable:!0,get:function(){return u.generateCaip25Caveat}}),Object.defineProperty(s,"getCaip25CaveatFromPermission",{enumerable:!0,get:function(){return u.getCaip25CaveatFromPermission}});var h=e("./scope/constants.cjs");Object.defineProperty(s,"KnownSessionProperties",{enumerable:!0,get:function(){return h.KnownSessionProperties}});var p=e("./scope/errors.cjs");Object.defineProperty(s,"Caip25Errors",{enumerable:!0,get:function(){return p.Caip25Errors}})}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/assert.cjs",{"./errors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/errors.cjs","./supported.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/supported.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.assertIsInternalScopesObject=s.assertIsInternalScopeString=s.assertIsExternalScopesObject=s.assertScopesSupported=s.assertScopeSupported=void 0;const n=e("@metamask/utils"),a=e("./errors.cjs"),i=e("./supported.cjs");s.assertScopeSupported=(e,t,{isEvmChainIdSupported:s,isNonEvmScopeSupported:n,getNonEvmSupportedMethods:o})=>{const{methods:r,notifications:c}=t;if(!(0,i.isSupportedScopeString)(e,{isEvmChainIdSupported:s,isNonEvmScopeSupported:n}))throw a.Caip25Errors.requestedChainsNotSupportedError();if(!r.every((t=>(0,i.isSupportedMethod)(e,t,{getNonEvmSupportedMethods:o}))))throw a.Caip25Errors.requestedMethodsNotSupportedError();if(c&&!c.every((t=>(0,i.isSupportedNotification)(e,t))))throw a.Caip25Errors.requestedNotificationsNotSupportedError()};function o(e){if("object"!=typeof e||null===e)throw new Error("ExternalScopeObject must be an object");if((0,n.hasProperty)(e,"references")&&(!Array.isArray(e.references)||!e.references.every(n.isCaipReference)))throw new Error("ExternalScopeObject.references must be an array of CaipReference");if((0,n.hasProperty)(e,"accounts")&&(!Array.isArray(e.accounts)||!e.accounts.every(n.isCaipAccountId)))throw new Error("ExternalScopeObject.accounts must be an array of CaipAccountId");if((0,n.hasProperty)(e,"methods")&&(!Array.isArray(e.methods)||!e.methods.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.methods must be an array of strings");if((0,n.hasProperty)(e,"notifications")&&(!Array.isArray(e.notifications)||!e.notifications.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.notifications must be an array of strings");if((0,n.hasProperty)(e,"rpcDocuments")&&(!Array.isArray(e.rpcDocuments)||!e.rpcDocuments.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.rpcDocuments must be an array of strings");if((0,n.hasProperty)(e,"rpcEndpoints")&&(!Array.isArray(e.rpcEndpoints)||!e.rpcEndpoints.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.rpcEndpoints must be an array of strings")}function r(e){if("string"!=typeof e||!(0,n.isCaipNamespace)(e)&&!(0,n.isCaipChainId)(e))throw new Error("scopeString is not a valid ExternalScopeString")}function c(e){if("object"!=typeof e||null===e)throw new Error("InternalScopeObject must be an object");if(!(0,n.hasProperty)(e,"accounts")||!Array.isArray(e.accounts)||!e.accounts.every(n.isCaipAccountId))throw new Error("InternalScopeObject.accounts must be an array of CaipAccountId")}function l(e){if("string"!=typeof e||e!==n.KnownCaipNamespace.Wallet&&!(0,n.isCaipChainId)(e))throw new Error("scopeString is not a valid InternalScopeString")}s.assertScopesSupported=(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:n,getNonEvmSupportedMethods:a})=>{for(const[i,o]of Object.entries(e))(0,s.assertScopeSupported)(i,o,{isEvmChainIdSupported:t,isNonEvmScopeSupported:n,getNonEvmSupportedMethods:a})},s.assertIsExternalScopesObject=function(e){if("object"!=typeof e||null===e)throw new Error("ExternalScopesObject must be an object");for(const[t,s]of Object.entries(e))r(t),o(s)},s.assertIsInternalScopeString=l,s.assertIsInternalScopesObject=function(e){if("object"!=typeof e||null===e)throw new Error("InternalScopesObject must be an object");for(const[t,s]of Object.entries(e))l(t),c(s)}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/assert.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/authorization.cjs",{"./filter.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/filter.cjs","./transform.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs","./validation.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/validation.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isNamespaceInScopesObject=s.bucketScopes=s.validateAndNormalizeScopes=void 0;const n=e("./filter.cjs"),a=e("./transform.cjs"),i=e("./types.cjs"),o=e("./validation.cjs");s.validateAndNormalizeScopes=(e,t)=>{const{validRequiredScopes:s,validOptionalScopes:n}=(0,o.getValidScopes)(e,t);return{normalizedRequiredScopes:(0,a.normalizeAndMergeScopes)(s),normalizedOptionalScopes:(0,a.normalizeAndMergeScopes)(n)}};s.bucketScopes=(e,{isEvmChainIdSupported:t,isEvmChainIdSupportable:s,isNonEvmScopeSupported:a,getNonEvmSupportedMethods:i})=>{const{supportedScopes:o,unsupportedScopes:r}=(0,n.bucketScopesBySupport)(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:a,getNonEvmSupportedMethods:i}),{supportedScopes:c,unsupportedScopes:l}=(0,n.bucketScopesBySupport)(r,{isEvmChainIdSupported:s,isNonEvmScopeSupported:a,getNonEvmSupportedMethods:i});return{supportedScopes:o,supportableScopes:c,unsupportableScopes:l}},s.isNamespaceInScopesObject=function(e,t){return Object.keys(e).some((e=>{const{namespace:s}=(0,i.parseScopeString)(e);return s===t}))}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/authorization.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/constants.cjs",{"@metamask/api-specs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.isKnownSessionPropertyValue=s.KnownSessionProperties=s.KnownNotifications=s.KnownWalletNamespaceRpcMethods=s.KnownRpcMethods=s.Eip1193OnlyMethods=s.KnownWalletRpcMethods=s.CaipReferenceRegexes=s.KnownWalletScopeString=void 0;const a=n(e("@metamask/api-specs"));var i;!function(e){e.Eip155="wallet:eip155"}(i||(s.KnownWalletScopeString=i={})),s.CaipReferenceRegexes={eip155:/^(0|[1-9][0-9]*)$/u,bip122:/.*/u,solana:/.*/u},s.KnownWalletRpcMethods=["wallet_registerOnboarding","wallet_scanQRCode"];const o=["wallet_addEthereumChain"];s.Eip1193OnlyMethods=["wallet_switchEthereumChain","wallet_getPermissions","wallet_requestPermissions","wallet_revokePermissions","eth_requestAccounts","eth_accounts","eth_coinbase","net_version","metamask_logWeb3ShimUsage","metamask_getProviderState","metamask_sendDomainMetadata","wallet_registerOnboarding"];const r=a.default.methods.map((({name:e})=>e)).filter((e=>!o.includes(e))).filter((e=>!s.KnownWalletRpcMethods.includes(e))).filter((e=>!s.Eip1193OnlyMethods.includes(e)));var c;s.KnownRpcMethods={eip155:r,bip122:[],solana:[]},s.KnownWalletNamespaceRpcMethods={eip155:o,bip122:[],solana:[]},s.KnownNotifications={eip155:["eth_subscription"],bip122:[],solana:[]},function(e){e.SolanaAccountChangedNotifications="solana_accountChanged_notifications"}(c||(s.KnownSessionProperties=c={})),s.isKnownSessionPropertyValue=function(e){return Object.values(c).includes(e)}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/errors.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.Caip25Errors=void 0;const n=e("@metamask/rpc-errors");s.Caip25Errors={requestedChainsNotSupportedError:()=>new n.JsonRpcError(5100,"Requested chains are not supported"),requestedMethodsNotSupportedError:()=>new n.JsonRpcError(5101,"Requested methods are not supported"),requestedNotificationsNotSupportedError:()=>new n.JsonRpcError(5102,"Requested notifications are not supported"),unknownMethodsRequestedError:()=>new n.JsonRpcError(5201,"Unknown method(s) requested"),unknownNotificationsRequestedError:()=>new n.JsonRpcError(5202,"Unknown notification(s) requested")}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/errors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/filter.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/assert.cjs","./supported.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/supported.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getSupportedScopeObjects=s.bucketScopesBySupport=void 0;const n=e("./assert.cjs"),a=e("./supported.cjs");s.bucketScopesBySupport=(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:s,getNonEvmSupportedMethods:a})=>{const i={},o={};for(const[r,c]of Object.entries(e)){(0,n.assertIsInternalScopeString)(r);try{(0,n.assertScopeSupported)(r,c,{isEvmChainIdSupported:t,isNonEvmScopeSupported:s,getNonEvmSupportedMethods:a}),i[r]=c}catch{o[r]=c}}return{supportedScopes:i,unsupportedScopes:o}};const i=(e,t,{getNonEvmSupportedMethods:s})=>{const{methods:n,notifications:i}=t,o=n.filter((t=>(0,a.isSupportedMethod)(e,t,{getNonEvmSupportedMethods:s}))),r=i.filter((t=>(0,a.isSupportedNotification)(e,t)));return{...t,methods:o,notifications:r}};s.getSupportedScopeObjects=(e,{getNonEvmSupportedMethods:t})=>{const s={};for(const[a,o]of Object.entries(e))(0,n.assertIsInternalScopeString)(a),s[a]=i(a,o,{getNonEvmSupportedMethods:t});return s}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/filter.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/supported.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/constants.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isSupportedSessionProperty=s.isSupportedNotification=s.isSupportedMethod=s.isSupportedAccount=s.isSupportedScopeString=void 0;const n=e("@metamask/controller-utils"),a=e("@metamask/utils"),i=e("./constants.cjs"),o=e("./types.cjs");s.isSupportedScopeString=(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:s})=>{const{namespace:r,reference:c}=(0,o.parseScopeString)(e);switch(r){case a.KnownCaipNamespace.Wallet:return!(0,a.isCaipChainId)(e)||c===a.KnownCaipNamespace.Eip155||s(e);case a.KnownCaipNamespace.Eip155:return!c||i.CaipReferenceRegexes.eip155.test(c)&&t((0,n.toHex)(c));default:return!!(0,a.isCaipChainId)(e)&&s(e)}};s.isSupportedAccount=(e,{getEvmInternalAccounts:t,getNonEvmAccountAddresses:s})=>{const{address:i,chainId:o,chain:{namespace:r,reference:c}}=(0,a.parseCaipAccountId)(e),l=()=>t().some((e=>["eip155:eoa","eip155:erc4337"].includes(e.type)&&(0,n.isEqualCaseInsensitive)(i,e.address))),m=()=>s(o).includes(e);switch(r){case a.KnownCaipNamespace.Wallet:return c===a.KnownCaipNamespace.Eip155?l():m();case a.KnownCaipNamespace.Eip155:return l();default:return m()}};s.isSupportedMethod=(e,t,{getNonEvmSupportedMethods:s})=>{const{namespace:n,reference:r}=(0,o.parseScopeString)(e);if(!n)return!1;const c=()=>(0,a.isCaipChainId)(e)&&s(e).includes(t);return n===a.KnownCaipNamespace.Wallet?r?r===a.KnownCaipNamespace.Eip155?i.KnownWalletNamespaceRpcMethods[r].includes(t):c():i.KnownWalletRpcMethods.includes(t):n===a.KnownCaipNamespace.Eip155?i.KnownRpcMethods[n].includes(t):c()};s.isSupportedNotification=(e,t)=>{const{namespace:s}=(0,o.parseScopeString)(e);return s===a.KnownCaipNamespace.Eip155&&i.KnownNotifications[s].includes(t)};s.isSupportedSessionProperty=e=>Object.values(i.KnownSessionProperties).includes(e)}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/supported.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.normalizeAndMergeScopes=s.mergeInternalScopes=s.mergeNormalizedScopes=s.mergeScopeObject=s.normalizeScope=s.getUniqueArrayItems=void 0;const n=e("lodash"),a=e("./types.cjs");s.getUniqueArrayItems=e=>Array.from(new Set(e));s.normalizeScope=(e,t)=>{const{references:s,...i}=t,{namespace:o,reference:r}=(0,a.parseScopeString)(e),c={accounts:[],...i};return o&&!r&&s!==undefined&&s.length>0?Object.fromEntries(s.map((e=>[`${o}:${e}`,(0,n.cloneDeep)(c)]))):{[e]:c}};s.mergeScopeObject=(e,t)=>{const n={methods:(0,s.getUniqueArrayItems)([...e.methods,...t.methods]),notifications:(0,s.getUniqueArrayItems)([...e.notifications,...t.notifications]),accounts:(0,s.getUniqueArrayItems)([...e.accounts,...t.accounts])};return(e.rpcDocuments||t.rpcDocuments)&&(n.rpcDocuments=(0,s.getUniqueArrayItems)([...e.rpcDocuments??[],...t.rpcDocuments??[]])),(e.rpcEndpoints||t.rpcEndpoints)&&(n.rpcEndpoints=(0,s.getUniqueArrayItems)([...e.rpcEndpoints??[],...t.rpcEndpoints??[]])),n};s.mergeNormalizedScopes=(e,t)=>{const n={};return Object.entries(e).forEach((([e,a])=>{const i=e,o=t[i];n[i]=o?(0,s.mergeScopeObject)(a,o):a})),Object.entries(t).forEach((([t,s])=>{const a=t;e[a]||(n[a]=s)})),n};s.mergeInternalScopes=(e,t)=>{const a=(0,n.cloneDeep)(e);return Object.entries(t).forEach((([e,t])=>{const n=e,i=a[n];a[n]=i?{accounts:(0,s.getUniqueArrayItems)([...i.accounts,...t.accounts])}:t})),a};s.normalizeAndMergeScopes=e=>{let t={};return Object.keys(e).forEach((n=>{const a=(0,s.normalizeScope)(n,e[n]);t=(0,s.mergeNormalizedScopes)(t,a)})),t}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isWalletScope=s.parseScopeString=void 0;const n=e("@metamask/utils");s.parseScopeString=e=>(0,n.isCaipNamespace)(e)?{namespace:e}:(0,n.isCaipChainId)(e)?(0,n.parseCaipChainId)(e):{};s.isWalletScope=e=>{const{namespace:t}=(0,s.parseScopeString)(e);return t===n.KnownCaipNamespace.Wallet}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/validation.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getValidScopes=s.isValidScope=void 0;const n=e("@metamask/utils"),a=e("./types.cjs");s.isValidScope=(e,t)=>{const{namespace:s,reference:i}=(0,a.parseScopeString)(e);if(!s)return!1;const{references:o,methods:r,notifications:c,accounts:l,rpcDocuments:m,rpcEndpoints:d,...u}=t;if(!r||!c)return!1;if(!("wallet"===s||i||o&&0!==o.length))return!1;if(o){if(i)return!1;if(!o.every((e=>(0,n.isCaipReference)(e))))return!1}if(!r.every((e=>"string"==typeof e&&""!==e.trim())))return!1;return!!c.every((e=>"string"==typeof e&&""!==e.trim()))&&!(Object.keys(u).length>0)};s.getValidScopes=(e,t)=>{const n={};for(const[t,a]of Object.entries(e||{}))(0,s.isValidScope)(t,a)&&(n[t]={accounts:[],...a});const a={};for(const[e,n]of Object.entries(t||{}))(0,s.isValidScope)(e,n)&&(a[e]={accounts:[],...n});return{validRequiredScopes:n,validOptionalScopes:a}}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/validation.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs",{"./push-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=void 0;var n=e("./push-utils.cjs");Object.defineProperty(s,"createRegToken",{enumerable:!0,get:function(){return n.createRegToken}}),Object.defineProperty(s,"deleteRegToken",{enumerable:!0,get:function(){return n.deleteRegToken}}),Object.defineProperty(s,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return n.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs",{"../../NotificationServicesController/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/NotificationServicesController/index.cjs","../../shared/to-raw-notification.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/notification-services-controller/dist/shared/to-raw-notification.cjs","firebase/app":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/app/dist/esm/index.esm.js","firebase/messaging":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/messaging/dist/esm/index.esm.js","firebase/messaging/sw":"/home/runner/work/metamask-extension/metamask-extension/node_modules/firebase/messaging/sw/dist/esm/index.esm.js",loglevel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/loglevel/lib/loglevel.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.createSubscribeToPushNotifications=s.deleteRegToken=s.createRegToken=s.supportedCache=void 0;const a=e("firebase/app"),i=e("firebase/messaging"),o=e("firebase/messaging/sw"),r=n(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),l=e("../../shared/to-raw-notification.cjs");s.supportedCache=null;const m=async e=>{if(!await(async()=>(s.supportedCache??(s.supportedCache=await(0,o.isSupported)()),s.supportedCache))())return null;const t=await(async e=>{try{return(0,a.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,a.initializeApp)(t)}})(e);return(0,o.getMessaging)(t)};s.createRegToken=async function(e){try{const t=await m(e);if(!t)return null;return await(0,i.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},s.deleteRegToken=async function(e){try{const t=await m(e);return!t||(await(0,i.deleteToken)(t),!0)}catch{return!1}},s.createSubscribeToPushNotifications=function(e){return async function(t){const s=await async function(e,t){const s=await m(e);if(!s)return null;const n=(0,o.onBackgroundMessage)(s,(async e=>{try{const s=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!s)return;const n=(0,l.toRawOnChainNotification)(s),a=c.Processors.processNotification(n);await t(a)}catch(t){throw r.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}}));return()=>n()}(t,(async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)})),n=function(e){const t=t=>{const s=t?.notification?.data;e(t,s)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}(((t,s)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",s),e.onClickHandler(t,s)}));return()=>{s?.(),n()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ComposedStore.js",{"./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ComposedStore=void 0;const n=e("./ObservableStore");class a extends n.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach((e=>{const t=this._children[e];this._addChild(e,t)}))}_addChild(e,t){const s=t=>{const s=this.getState();s[e]=t,this.putState(s)};t.subscribe(s),s(t.getState())}}s.ComposedStore=a}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/MergedStore.js",{"./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MergedStore=void 0;const n=e("./ObservableStore");class a extends n.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach((e=>this._addChild(e))),this._updateWholeState()}_addChild(e){e.subscribe((()=>this._updateWholeState()))}_updateWholeState(){const e=this._children.map((e=>e.getState())),t=Object.assign({},...e);this.putState(t)}}s.MergedStore=a}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js",{"@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.ObservableStore=void 0;const a=n(e("@metamask/safe-event-emitter"));class i extends a.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}s.ObservableStore=i}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/asStream.js",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeAsStream=void 0;const n=e("readable-stream");class a extends n.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const s=super.pipe(e,t);return e.write(this.obsStore.getState()),s}_write(e,t,s){this.obsStore.putState(e),s()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}s.storeAsStream=function(e){return new a(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/index.js",{"./ComposedStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ComposedStore.js","./MergedStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/MergedStore.js","./ObservableStore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/ObservableStore.js","./asStream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/asStream.js","./transform":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/transform.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s),Object.defineProperty(e,n,{enumerable:!0,get:function(){return t[s]}})}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./asStream"),s),a(e("./ComposedStore"),s),a(e("./MergedStore"),s),a(e("./ObservableStore"),s),a(e("./transform"),s)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/obs-store/dist/transform.js",{"readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.storeTransformStream=void 0;const n=e("readable-stream");s.storeTransformStream=function(e){return new n.Transform({objectMode:!0,transform:(t,s,n)=>{try{const s=e(t);return n(undefined,s),undefined}catch(e){return n(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs",{"./enums.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/enums.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PermissionLogController=void 0;const p=e("@metamask/base-controller"),f=e("@metamask/utils"),g=e("./enums.cjs"),b={permissionHistory:{},permissionActivityLog:[]};class k extends p.BaseController{constructor({messenger:e,restrictedMethods:t,state:s}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{persist:!0,anonymous:!1},permissionActivityLog:{persist:!1,anonymous:!1}},state:{...b,...s}}),n.add(this),a.set(this,void 0),u(this,a,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const s={eth_accounts:{accounts:h(this,n,"m",i).call(this,t,Date.now())}};h(this,n,"m",l).call(this,e,s)}createMiddleware(){return(e,t,s)=>{const{origin:i,method:l}=e,d=l.startsWith(g.WALLET_PREFIX),u="eth_requestAccounts"===l;if(!g.LOG_IGNORE_METHODS.includes(l)&&(d||h(this,a,"f").has(l))||u){const a=h(this,n,"m",o).call(this,e,d),l=h(this,n,"m",m).call(this,e);s((e=>{const s=Date.now();h(this,n,"m",r).call(this,a,t,s),l&&!t.error&&t.result&&i&&h(this,n,"m",c).call(this,l,i,t.result,s,u),e()}))}else s()}}}s.PermissionLogController=k,a=new WeakMap,n=new WeakSet,i=function(e,t){return e.reduce(((e,s)=>({...e,[s]:t})),{})},o=function(e,t){const s={id:e.id,method:e.method,methodType:t?g.LOG_METHOD_TYPES.internal:g.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update((e=>{const t=[...e.permissionActivityLog,s];e.permissionActivityLog=t.length>g.LOG_LIMIT?t.slice(1):t})),s},r=function(e,t,s){e&&t&&this.update((n=>{n.permissionActivityLog=n.permissionActivityLog.map((n=>n.id===e.id?{...n,success:(0,f.hasProperty)(t,"result"),responseTime:s}:n))}))},c=function(e,t,s,a,o){let r;if(o){const e=s;r={eth_accounts:{accounts:h(this,n,"m",i).call(this,e,a),lastApproved:a}}}else{r=s.reduce(((t,s)=>{const o=s.parentCapability;if(!e.includes(o))return t;if("eth_accounts"===o){const e=h(this,n,"m",d).call(this,s);return{...t,[o]:{lastApproved:a,accounts:h(this,n,"m",i).call(this,e,a)}}}return{...t,[o]:{lastApproved:a}}}),{})}Object.keys(r).length>0&&h(this,n,"m",l).call(this,t,r)},l=function(e,t){const{permissionHistory:s}=this.state,n=s[e]??{},a={...n,...t},i=n.eth_accounts,o=t.eth_accounts;if(i&&o){const e=o.lastApproved??i.lastApproved;a.eth_accounts={lastApproved:e,accounts:{...i.accounts,...o.accounts}}}this.update((t=>{t.permissionHistory={...s,[e]:a}}))},m=function(e){const{method:t,params:s}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${g.WALLET_PREFIX}requestPermissions`&&s&&Array.isArray(s)&&s[0]&&"object"==typeof s[0]&&!Array.isArray(s[0])?Object.keys(s[0]):null},d=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const s of e.caveats)if(s.type===g.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(s.value))for(const e of s.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/enums.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n;Object.defineProperty(s,"__esModule",{value:!0}),s.LOG_LIMIT=s.LOG_METHOD_TYPES=s.LOG_IGNORE_METHODS=s.CAVEAT_TYPES=s.WALLET_PREFIX=void 0,s.WALLET_PREFIX="wallet_",s.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),s.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(n||(s.LOG_METHOD_TYPES=n={})),s.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/index.cjs",{"./PermissionLogController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./PermissionLogController.cjs"),s)}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/index.js",{"./ppom-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-controller.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;var n=e("./ppom-controller");Object.defineProperty(s,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return n.NETWORK_CACHE_DURATION}}),Object.defineProperty(s,"PPOMController",{enumerable:!0,get:function(){return n.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-controller.js",{"./ppom-storage":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-storage.js","./util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/util.js","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","await-semaphore":"/home/runner/work/metamask-extension/metamask-extension/node_modules/await-semaphore/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d,u,h,p,f,g,b,k,y,w,S,_,v,x,P,j,E,T,C,I,O,A,M,R,N=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},$=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMController=s.NETWORK_CACHE_DURATION=void 0;const B=e("@metamask/base-controller"),L=e("@metamask/controller-utils"),D=e("await-semaphore"),F=e("./ppom-storage"),H=e("./util");s.NETWORK_CACHE_DURATION=6048e5;const U=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],q={versionInfo:{persist:!0,anonymous:!1},storageMetadata:{persist:!0,anonymous:!1}},V="PPOMController",W={headers:{"Content-Type":"application/json"}};class K extends B.BaseController{constructor({chainId:e,messenger:t,provider:s,storageBackend:k,securityAlertsEnabled:y,onPreferencesChange:w,ppomProvider:x,cdnBaseUrl:P,providerRequestLimit:j,state:E,blockaidPublicKey:T,nativeCrypto:C}){super({name:V,metadata:q,messenger:t,state:{versionInfo:E?.versionInfo??[],storageMetadata:E?.storageMetadata??[]}}),n.add(this),a.set(this,void 0),i.set(this,void 0),o.set(this,void 0),r.set(this,void 0),c.set(this,void 0),l.set(this,void 0),m.set(this,void 0),d.set(this,0),u.set(this,void 0),h.set(this,void 0),p.set(this,{}),f.set(this,void 0),g.set(this,!1),b.set(this,undefined),N(this,u,(0,H.addHexPrefix)(e),"f"),N(this,i,s,"f"),N(this,c,x,"f"),N(this,o,new F.PPOMStorage({storageBackend:k,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update((t=>{t.storageMetadata=e}))}}),"f"),N(this,r,new D.Mutex,"f"),N(this,l,P,"f"),N(this,m,j??300,"f"),N(this,h,y,"f"),N(this,f,T,"f"),N(this,b,C,"f"),w($(this,n,"m",S).bind(this)),$(this,n,"m",_).call(this),$(this,n,"m",v).call(this)}async usePPOM(e,t){const s=t??$(this,u,"f");if(!$(this,h,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,H.blockaidValidationSupportedForNetwork)(s))throw Error(`Blockaid validation not available on network with chainId: ${s}`);return await $(this,r,"f").use((async()=>{const t=await $(this,n,"m",P).call(this,s);N(this,d,0,"f"),N(this,p,{},"f");return{...await e(t),providerRequestsCount:{...$(this,p,"f")}}}))}}s.PPOMController=K,a=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakMap,c=new WeakMap,l=new WeakMap,m=new WeakMap,d=new WeakMap,u=new WeakMap,h=new WeakMap,p=new WeakMap,f=new WeakMap,g=new WeakMap,b=new WeakMap,n=new WeakSet,k=async function(){if($(this,h,"f")&&!$(this,g,"f")){const{ppomInit:e}=$(this,c,"f");await e("./ppom_bg.wasm"),N(this,g,!0,"f")}},y=function(){$(this,n,"m",x).call(this).catch((e=>{console.error(`Error in resetting ppom: ${e.message}`)}));const{storageMetadata:e}=this.state;this.update((e=>{e.versionInfo=[],e.storageMetadata=[]})),$(this,o,"f").deleteAllFiles(e).catch((e=>{console.error(`Error in deleting files: ${e.message}`)}))},w=function(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:s}=t.configuration,a=(0,H.addHexPrefix)(s);a!==$(this,u,"f")&&(N(this,u,a,"f"),$(this,n,"m",x).call(this).catch((e=>{console.error(`Error in resetting ppom: ${e.message}`)})))},S=function(e){const t=e.securityAlertsEnabled;t!==$(this,h,"f")&&(N(this,h,t,"f"),t||$(this,n,"m",y).call(this))},_=function(){this.messagingSystem.registerActionHandler(`${V}:usePPOM`,this.usePPOM.bind(this))},v=function(){const e=$(this,n,"m",w).bind(this);this.messagingSystem.subscribe("NetworkController:networkDidChange",e)},x=async function(){await $(this,r,"f").use((async()=>{$(this,a,"f")&&($(this,a,"f").free(),N(this,a,undefined,"f"))}))},P=async function(e){const t=await $(this,n,"m",j).call(this);let s;return($(this,a,"f")===undefined||t)&&(s=await $(this,n,"m",R).call(this,e),$(this,u,"f")===e&&($(this,a,"f")&&$(this,a,"f").free(),N(this,a,s,"f")),$(this,o,"f").syncMetadata(this.state.versionInfo).catch((e=>{console.error(`Error while trying to sync metadata: ${e.message}`)}))),s},j=async function(){const e=await $(this,n,"m",O).call(this);return!!e&&(this.update((t=>{t.versionInfo=e})),!0)},E=function(e,t){return e.find((e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum))},T=async function(e){const t=await Promise.all(e.map((async e=>{let t;try{t=await $(this,n,"m",C).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined})));return t?.filter((e=>e?.[1]!==undefined))},C=async function(e){const{storageMetadata:t}=this.state;if($(this,n,"m",E).call(this,t,e))try{return await $(this,o,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,H.checkFilePath)(e.filePath);const s=(0,H.constructURLHref)($(this,l,"f"),e.filePath),a=await $(this,n,"m",A).call(this,s);return await(0,H.validateSignature)(a,e.hashSignature,$(this,f,"f"),e.filePath,$(this,b,"f")),await $(this,o,"f").writeFile({data:a,...e}).catch((e=>{console.error(`Error in writing file: ${e.message}`)})),a},I=async function(e,t={},s="GET"){const n=await(0,L.safelyExecute)((async()=>(0,L.timeoutFetch)(e,{method:s,cache:"no-cache",redirect:"error",...t},1e4)),!0),a=304===n?.status;if(!n?.status||n?.status<200||n?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:a,response:n}},O=async function(){const e=(0,H.constructURLHref)($(this,l,"f"),"ppom_version.json"),{cached:t,response:s}=await $(this,n,"m",I).call(this,e,{headers:W});return t&&this.state.versionInfo?.length?undefined:s.json()},A=async function(e){const{response:t}=await $(this,n,"m",I).call(this,e);return await t.arrayBuffer()},M=async function(e,t){if($(this,d,"f")>$(this,m,"f"))return H.PROVIDER_ERRORS.limitExceeded();if(N(this,d,$(this,d,"f")+1,"f"),!U.includes(e))return H.PROVIDER_ERRORS.methodNotSupported();$(this,p,"f")[e]=$(this,p,"f")[e]?Number($(this,p,"f")[e])+1:1;const s=(0,H.createPayload)(e,t);try{const e=await $(this,i,"f").request(s);return{jsonrpc:"2.0",id:s.id,result:e}}catch(e){return{jsonrpc:"2.0",id:s.id,error:e}}},R=async function(e){await $(this,n,"m",k).call(this);const t=this.state.versionInfo.filter((({chainId:t})=>t===e));if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const s=await $(this,n,"m",T).call(this,t);if(s?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:a}=$(this,c,"f");return a.new($(this,n,"m",M).bind(this),s)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/ppom-storage.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},r=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PPOMStorage=void 0;s.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:s}){n.set(this,void 0),a.set(this,void 0),i.set(this,void 0),o(this,n,e,"f"),o(this,a,t,"f"),o(this,i,s,"f")}async syncMetadata(e){const t=r(this,a,"f").call(this),s=[];for(const n of t){try{await this.readFile(n.name,n.chainId)}catch(e){console.error("Error: ",e);continue}e.find((e=>e.name===n.name&&e.chainId===n.chainId&&e.version===n.version&&e.checksum===n.checksum))&&s.push(n)}const o=await r(this,n,"f").dir();for(const{name:e,chainId:t}of o)s.find((s=>s.name===e&&s.chainId===t))||await r(this,n,"f").delete({name:e,chainId:t});return r(this,i,"f").call(this,s),s}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:s}=t;try{await r(this,n,"f").delete({name:e,chainId:s})}catch(t){console.error(`Error in deleting file: ${e}, ${s}`,t)}}}async readFile(e,t){const s=r(this,a,"f").call(this).find((s=>s.name===e&&s.chainId===t));if(!s)throw new Error(`File metadata (${e}, ${t}) not found`);const i=await r(this,n,"f").read({name:e,chainId:t},s.checksum);if(!i)throw new Error(`Storage File (${e}, ${t}) not found`);return i}async writeFile({data:e,name:t,chainId:s,version:o,checksum:c}){await r(this,n,"f").write({name:t,chainId:s},e,c);const l=r(this,a,"f").call(this),m=l.find((e=>e.name===t&&e.chainId===s));m?(m.version=o,m.checksum=c):l.push({name:t,chainId:s,version:o,checksum:c}),r(this,i,"f").call(this,l)}},n=new WeakMap,a=new WeakMap,i=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/dist/util.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","crypto-js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/crypto-js/index.js",elliptic:"/home/runner/work/metamask-extension/metamask-extension/node_modules/elliptic/lib/elliptic.js","json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&n(t,e,s);return a(t,e),t},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.checkFilePath=s.addHexPrefix=s.constructURLHref=s.validateSignature=s.PROVIDER_ERRORS=s.createPayload=s.IdGenerator=s.blockaidValidationSupportedForNetwork=s.SUPPORTED_NETWORK_CHAINIDS=void 0;const r=i(e("crypto-js")),c=o(e("elliptic")),l=o(e("json-rpc-random-id")),m=c.default.eddsa;s.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};s.blockaidValidationSupportedForNetwork=e=>Object.values(s.SUPPORTED_NETWORK_CHAINIDS).some((t=>t===e)),s.IdGenerator=(0,l.default)();s.createPayload=(e,t)=>({id:(0,s.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),s.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,s.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};s.validateSignature=async(e,s,n,a,i,o)=>{const c=await(async(e,t,s=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&s){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map((e=>e.toString(16).padStart(2,"0"))).join("")}return(0,r.SHA256)(r.default.lib.WordArray.create(e)).toString()})(e,i,o);if(!new m("ed25519").keyFromPublic(n).verify(t.from(c),s))throw Error(`Signature verification failed for file path: ${a}`)};s.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;s.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;s.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV1.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BaseControllerV1=s.isBaseControllerV1=void 0,s.isBaseControllerV1=function(e){return"name"in e&&"string"==typeof e.name&&"config"in e&&"object"==typeof e.config&&"defaultConfig"in e&&"object"==typeof e.defaultConfig&&"state"in e&&"object"==typeof e.state&&"defaultState"in e&&"object"==typeof e.defaultState&&"disabled"in e&&"boolean"==typeof e.disabled&&"subscribe"in e&&"function"==typeof e.subscribe};class n{constructor(e={},t={}){this.defaultConfig={},this.defaultState={},this.disabled=!1,this.name="BaseController",this.internalConfig=this.defaultConfig,this.internalState=this.defaultState,this.internalListeners=[],this.initialState=t,this.initialConfig=e}initialize(){return this.internalState=this.defaultState,this.internalConfig=this.defaultConfig,this.configure(this.initialConfig),this.update(this.initialState),this}get config(){return this.internalConfig}get state(){return this.internalState}configure(e,t=!1,s=!0){if(s){this.internalConfig=t?e:Object.assign(this.internalConfig,e);for(const e of Object.keys(this.internalConfig)){const t=this.internalConfig[e];t!==undefined&&(this[e]=t)}}else for(const t of Object.keys(e))if(this.internalConfig[t]!==undefined){const s=e[t];this.internalConfig[t]=s,this[t]=s}}notify(){this.disabled||this.internalListeners.forEach((e=>{e(this.internalState)}))}subscribe(e){this.internalListeners.push(e)}unsubscribe(e){const t=this.internalListeners.findIndex((t=>e===t));return t>-1&&this.internalListeners.splice(t,1),t>-1}update(e,t=!1){this.internalState=t?Object.assign({},e):Object.assign({},this.internalState,e),this.notify()}}s.BaseControllerV1=n,s.default=n}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV1.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs",{immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},i=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.getPersistentState=s.getAnonymizedState=s.BaseController=s.isBaseController=void 0;const o=e("immer");(0,o.enablePatches)(),s.isBaseController=function(e){return"name"in e&&"string"==typeof e.name&&"state"in e&&"object"==typeof e.state&&"metadata"in e&&"object"==typeof e.metadata};function r(e,t,s){return Object.keys(e).reduce(((n,a)=>{try{const i=t[a];if(!i)throw new Error(`No metadata found for '${String(a)}'`);const o=i[s],r=e[a];return"function"==typeof o?n[a]=o(r):o&&(n[a]=r),n}catch(e){return setTimeout((()=>{throw e})),n}}),{})}s.BaseController=class{constructor({messenger:e,metadata:t,name:s,state:i}){n.set(this,void 0),this.messagingSystem=e,this.name=s,a(this,n,(0,o.freeze)(i,!0),"f"),this.metadata=t,this.messagingSystem.registerActionHandler(`${s}:getState`,(()=>this.state)),this.messagingSystem.registerInitialEventPayload({eventType:`${s}:stateChange`,getPayload:()=>[this.state,[]]})}get state(){return i(this,n,"f")}set state(e){throw new Error("Controller state cannot be directly mutated; use 'update' method instead.")}update(e){const[t,s,r]=o.produceWithPatches(i(this,n,"f"),e);return a(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,s),{nextState:t,patches:s,inversePatches:r}}applyPatches(e){const t=(0,o.applyPatches)(i(this,n,"f"),e);a(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,e)}destroy(){this.messagingSystem.clearEventSubscriptions(`${this.name}:stateChange`)}},n=new WeakMap,s.getAnonymizedState=function(e,t){return r(e,t,"anonymous")},s.getPersistentState=function(e,t){return r(e,t,"persist")}}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/Messenger.cjs",{"./RestrictedMessenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ControllerMessenger=s.Messenger=void 0;const c=e("./RestrictedMessenger.cjs");class l{constructor(){n.set(this,new Map),a.set(this,new Map),i.set(this,new Map),o.set(this,new Map)}registerActionHandler(e,t){if(r(this,n,"f").has(e))throw new Error(`A handler for ${e} has already been registered`);r(this,n,"f").set(e,t)}unregisterActionHandler(e){r(this,n,"f").delete(e)}clearActions(){r(this,n,"f").clear()}call(e,...t){const s=r(this,n,"f").get(e);if(!s)throw new Error(`A handler for ${e} has not been registered`);return s(...t)}registerInitialEventPayload({eventType:e,getPayload:t}){r(this,i,"f").set(e,t)}publish(e,...t){const s=r(this,a,"f").get(e);if(s)for(const[e,n]of s.entries())try{if(n){const s=r(this,o,"f").get(e),a=n(...t);a!==s&&(r(this,o,"f").set(e,a),e(a,s))}else e(...t)}catch(e){setTimeout((()=>{throw e}))}}subscribe(e,t,s){let n=r(this,a,"f").get(e);if(n||(n=new Map,r(this,a,"f").set(e,n)),n.set(t,s),s){const n=r(this,i,"f").get(e);if(n){const e=s(...n());r(this,o,"f").set(t,e)}}}unsubscribe(e,t){const s=r(this,a,"f").get(e);if(!s||!s.has(t))throw new Error(`Subscription not found for event: ${e}`);s.get(t)&&r(this,o,"f").delete(t),s.delete(t)}clearEventSubscriptions(e){r(this,a,"f").delete(e)}clearSubscriptions(){r(this,a,"f").clear()}getRestricted({name:e,allowedActions:t,allowedEvents:s}){return new c.RestrictedMessenger({messenger:this,name:e,allowedActions:t,allowedEvents:s})}}s.Messenger=l,s.ControllerMessenger=l,n=new WeakMap,a=new WeakMap,i=new WeakMap,o=new WeakMap}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/Messenger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},u=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedControllerMessenger=s.RestrictedMessenger=void 0;class h{constructor({controllerMessenger:e,messenger:t,name:s,allowedActions:c,allowedEvents:l}){if(n.add(this),a.set(this,void 0),i.set(this,void 0),o.set(this,void 0),r.set(this,void 0),t&&e)throw new Error("Both messenger properties provided. Provide message using only 'messenger' option, 'controllerMessenger' is deprecated");if(!t&&!e)throw new Error("Messenger not provided");d(this,a,t??e,"f"),d(this,i,s,"f"),d(this,o,c,"f"),d(this,r,l,"f")}registerActionHandler(e,t){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed registering action handlers prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").registerActionHandler(e,t)}unregisterActionHandler(e){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed unregistering action handlers prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").unregisterActionHandler(e)}call(e,...t){if(!u(this,n,"m",l).call(this,e))throw new Error(`Action missing from allow list: ${e}`);return u(this,a,"f").call(e,...t)}registerInitialEventPayload({eventType:e,getPayload:t}){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").registerInitialEventPayload({eventType:e,getPayload:t})}publish(e,...t){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").publish(e,...t)}subscribe(e,t,s){if(!u(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);return s?u(this,a,"f").subscribe(e,t,s):u(this,a,"f").subscribe(e,t)}unsubscribe(e,t){if(!u(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);u(this,a,"f").unsubscribe(e,t)}clearEventSubscriptions(e){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed clearing events prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").clearEventSubscriptions(e)}}s.RestrictedMessenger=h,s.RestrictedControllerMessenger=h,a=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakMap,n=new WeakSet,c=function(e){const t=u(this,r,"f");return u(this,n,"m",m).call(this,e)||null!==t&&t.includes(e)},l=function(e){const t=u(this,o,"f");return u(this,n,"m",m).call(this,e)||null!==t&&t.includes(e)},m=function(e){return e.startsWith(`${u(this,i,"f")}:`)}}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/index.cjs",{"./BaseControllerV1.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV1.cjs","./BaseControllerV2.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs","./Messenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/Messenger.cjs","./RestrictedMessenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedMessenger=s.RestrictedControllerMessenger=s.Messenger=s.ControllerMessenger=s.isBaseController=s.getPersistentState=s.getAnonymizedState=s.BaseController=s.isBaseControllerV1=s.BaseControllerV1=void 0;var n=e("./BaseControllerV1.cjs");Object.defineProperty(s,"BaseControllerV1",{enumerable:!0,get:function(){return n.BaseControllerV1}}),Object.defineProperty(s,"isBaseControllerV1",{enumerable:!0,get:function(){return n.isBaseControllerV1}});var a=e("./BaseControllerV2.cjs");Object.defineProperty(s,"BaseController",{enumerable:!0,get:function(){return a.BaseController}}),Object.defineProperty(s,"getAnonymizedState",{enumerable:!0,get:function(){return a.getAnonymizedState}}),Object.defineProperty(s,"getPersistentState",{enumerable:!0,get:function(){return a.getPersistentState}}),Object.defineProperty(s,"isBaseController",{enumerable:!0,get:function(){return a.isBaseController}});var i=e("./Messenger.cjs");Object.defineProperty(s,"ControllerMessenger",{enumerable:!0,get:function(){return i.ControllerMessenger}}),Object.defineProperty(s,"Messenger",{enumerable:!0,get:function(){return i.Messenger}});var o=e("./RestrictedMessenger.cjs");Object.defineProperty(s,"RestrictedControllerMessenger",{enumerable:!0,get:function(){return o.RestrictedControllerMessenger}}),Object.defineProperty(s,"RestrictedMessenger",{enumerable:!0,get:function(){return o.RestrictedMessenger}})}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/preferences-controller/dist/PreferencesController.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/preferences-controller/dist/constants.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.PreferencesController=s.getDefaultPreferencesState=void 0;const o=e("@metamask/base-controller"),r=e("@metamask/controller-utils"),c=e("./constants.cjs"),l={featureFlags:{persist:!0,anonymous:!0},identities:{persist:!0,anonymous:!1},ipfsGateway:{persist:!0,anonymous:!1},isIpfsGatewayEnabled:{persist:!0,anonymous:!0},isMultiAccountBalancesEnabled:{persist:!0,anonymous:!0},lostIdentities:{persist:!0,anonymous:!1},openSeaEnabled:{persist:!0,anonymous:!0},securityAlertsEnabled:{persist:!0,anonymous:!0},selectedAddress:{persist:!0,anonymous:!1},showTestNetworks:{persist:!0,anonymous:!0},showIncomingTransactions:{persist:!0,anonymous:!0},useNftDetection:{persist:!0,anonymous:!0},useTokenDetection:{persist:!0,anonymous:!0},smartTransactionsOptInStatus:{persist:!0,anonymous:!1},useTransactionSimulations:{persist:!0,anonymous:!0},useMultiRpcMigration:{persist:!0,anonymous:!0},useSafeChainsListValidation:{persist:!0,anonymous:!0},tokenSortConfig:{persist:!0,anonymous:!0},privacyMode:{persist:!0,anonymous:!0}};function m(){return{featureFlags:{},identities:{},ipfsGateway:"https://ipfs.io/ipfs/",isIpfsGatewayEnabled:!0,isMultiAccountBalancesEnabled:!0,lostIdentities:{},openSeaEnabled:!1,securityAlertsEnabled:!1,selectedAddress:"",showIncomingTransactions:{[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MAINNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.GOERLI]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.BSC]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.BSC_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.OPTIMISM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.OPTIMISM_SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.POLYGON]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.POLYGON_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.AVALANCHE]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.AVALANCHE_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.FANTOM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.FANTOM_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_GOERLI]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_MAINNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONBEAM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONBEAM_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONRIVER]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.GNOSIS]:!0},showTestNetworks:!1,useNftDetection:!1,useTokenDetection:!0,useMultiRpcMigration:!0,smartTransactionsOptInStatus:!0,useTransactionSimulations:!0,useSafeChainsListValidation:!0,tokenSortConfig:{key:"tokenFiatAmount",order:"dsc",sortCallback:"stringNumeric"},privacyMode:!1}}s.getDefaultPreferencesState=m;class d extends o.BaseController{constructor({messenger:e,state:t}){super({name:"PreferencesController",metadata:l,messenger:e,state:{...m(),...t}}),n.add(this),e.subscribe("KeyringController:stateChange",(e=>{const t=new Set;for(const s of e.keyrings)for(const e of s.accounts)t.add(e);t.size>0&&i(this,n,"m",a).call(this,Array.from(t))}))}addIdentities(e){const t=e.map((e=>(0,r.toChecksumHexAddress)(e)));this.update((e=>{const{identities:s}=e;for(const e of t){if(s[e])continue;const t=Object.keys(s).length;s[e]={name:`Account ${t+1}`,address:e,importTime:Date.now()}}}))}removeIdentity(e){e=(0,r.toChecksumHexAddress)(e);const{identities:t}=this.state;t[e]&&this.update((t=>{delete t.identities[e],e===t.selectedAddress&&(t.selectedAddress=Object.keys(t.identities)[0])}))}setAccountLabel(e,t){e=(0,r.toChecksumHexAddress)(e),this.update((s=>{const n=s.identities[e]||{};n.name=t,s.identities[e]=n}))}setFeatureFlag(e,t){this.update((s=>{s.featureFlags[e]=t}))}setSelectedAddress(e){this.update((t=>{t.selectedAddress=(0,r.toChecksumHexAddress)(e)}))}setIpfsGateway(e){this.update((t=>{t.ipfsGateway=e}))}setUseTokenDetection(e){this.update((t=>{t.useTokenDetection=e}))}setUseNftDetection(e){if(e&&!this.state.openSeaEnabled)throw new Error("useNftDetection cannot be enabled if openSeaEnabled is false");this.update((t=>{t.useNftDetection=e}))}setOpenSeaEnabled(e){this.update((t=>{t.openSeaEnabled=e,e||(t.useNftDetection=!1)}))}setSecurityAlertsEnabled(e){this.update((t=>{t.securityAlertsEnabled=e}))}setIsMultiAccountBalancesEnabled(e){this.update((t=>{t.isMultiAccountBalancesEnabled=e}))}setShowTestNetworks(e){this.update((t=>{t.showTestNetworks=e}))}setIsIpfsGatewayEnabled(e){this.update((t=>{t.isIpfsGatewayEnabled=e}))}setEnableNetworkIncomingTransactions(e,t){Object.values(c.ETHERSCAN_SUPPORTED_CHAIN_IDS).includes(e)&&this.update((s=>{s.showIncomingTransactions={...this.state.showIncomingTransactions,[e]:t}}))}setUseMultiRpcMigration(e){this.update((t=>{t.useMultiRpcMigration=e,e||(t.useMultiRpcMigration=!1)}))}setSmartTransactionsOptInStatus(e){this.update((t=>{t.smartTransactionsOptInStatus=e}))}setUseTransactionSimulations(e){this.update((t=>{t.useTransactionSimulations=e}))}setTokenSortConfig(e){this.update((t=>{t.tokenSortConfig=e}))}setUseSafeChainsListValidation(e){this.update((t=>{t.useSafeChainsListValidation=e}))}setPrivacyMode(e){this.update((t=>{t.privacyMode=e}))}}s.PreferencesController=d,n=new WeakSet,a=function(e){e=e.map((e=>(0,r.toChecksumHexAddress)(e))),this.update((t=>{const{identities:s}=t,n={};for(const[t,a]of Object.entries(s))e.includes(t)||(n[t]=a,delete s[t]);for(const[e,s]of Object.entries(n))t.lostIdentities[e]=s})),this.addIdentities(e),e.includes(this.state.selectedAddress)||this.update((t=>{t.selectedAddress=e[0]}))},s.default=d}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/PreferencesController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/preferences-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ETHERSCAN_SUPPORTED_CHAIN_IDS=void 0,s.ETHERSCAN_SUPPORTED_CHAIN_IDS={MAINNET:"0x1",GOERLI:"0x5",BSC:"0x38",BSC_TESTNET:"0x61",OPTIMISM:"0xa",OPTIMISM_SEPOLIA:"0xaa37dc",POLYGON:"0x89",POLYGON_TESTNET:"0x13881",AVALANCHE:"0xa86a",AVALANCHE_TESTNET:"0xa869",FANTOM:"0xfa",FANTOM_TESTNET:"0xfa2",SEPOLIA:"0xaa36a7",LINEA_GOERLI:"0xe704",LINEA_SEPOLIA:"0xe705",LINEA_MAINNET:"0xe708",MOONBEAM:"0x504",MOONBEAM_TESTNET:"0x507",MOONRIVER:"0x505",GNOSIS:"0x64"}}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/preferences-controller/dist/index.cjs",{"./PreferencesController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/preferences-controller/dist/PreferencesController.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/preferences-controller/dist/constants.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.ETHERSCAN_SUPPORTED_CHAIN_IDS=void 0,a(e("./PreferencesController.cjs"),s);var i=e("./constants.cjs");Object.defineProperty(s,"ETHERSCAN_SUPPORTED_CHAIN_IDS",{enumerable:!0,get:function(){return i.ETHERSCAN_SUPPORTED_CHAIN_IDS}})}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/AuthenticationController.cjs",{"../../sdk/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/sdk/index.cjs","./auth-snap-requests.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/auth-snap-requests.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d,u,h,p,f,g,b=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)},k=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s};Object.defineProperty(s,"__esModule",{value:!0}),s.defaultState=void 0;const y=e("@metamask/base-controller"),w=e("./auth-snap-requests.cjs"),S=e("../../sdk/index.cjs");s.defaultState={isSignedIn:!1};const _={isSignedIn:{persist:!0,anonymous:!0},srpSessionData:{persist:!0,anonymous:!1}};class v extends y.BaseController{constructor({messenger:e,state:t,config:u,metametrics:p}){if(super({messenger:e,metadata:_,name:"AuthenticationController",state:{...s.defaultState,...t}}),n.add(this),a.set(this,void 0),i.set(this,void 0),o.set(this,{env:S.Env.PRD}),r.set(this,!1),c.set(this,{setupLockedStateSubscriptions:()=>{const{isUnlocked:e}=this.messagingSystem.call("KeyringController:getState");k(this,r,e,"f"),this.messagingSystem.subscribe("KeyringController:unlock",(()=>{k(this,r,!0,"f")})),this.messagingSystem.subscribe("KeyringController:lock",(()=>{k(this,r,!1,"f")}))}}),f.set(this,{}),!p)throw new Error("`metametrics` field is required");k(this,o,{...b(this,o,"f"),...u},"f"),k(this,a,p,"f"),k(this,i,new S.JwtBearerAuth({env:b(this,o,"f").env,platform:p.agent,type:S.AuthType.SRP},{storage:{getLoginResponse:b(this,n,"m",m).bind(this),setLoginResponse:b(this,n,"m",d).bind(this)},signing:{getIdentifier:b(this,n,"m",h).bind(this),signMessage:b(this,n,"m",g).bind(this)},metametrics:b(this,a,"f")}),"f"),b(this,c,"f").setupLockedStateSubscriptions(),b(this,n,"m",l).call(this)}async performSignIn(){b(this,n,"m",u).call(this,"performSignIn");const e=await b(this,n,"m",p).call(this),t=[];for(const[s]of e){const e=await b(this,i,"f").getAccessToken(s);t.push(e)}return t}performSignOut(){this.update((e=>{e.isSignedIn=!1,e.srpSessionData=undefined}))}async getBearerToken(e){return b(this,n,"m",u).call(this,"getBearerToken"),await b(this,i,"f").getAccessToken(e)}async getSessionProfile(e){return b(this,n,"m",u).call(this,"getSessionProfile"),await b(this,i,"f").getUserProfile(e)}async getUserProfileMetaMetrics(){return b(this,n,"m",u).call(this,"getUserProfileMetaMetrics"),await b(this,i,"f").getUserProfileMetaMetrics()}isSignedIn(){return this.state.isSignedIn}}a=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakMap,c=new WeakMap,f=new WeakMap,n=new WeakSet,l=function(){this.messagingSystem.registerActionHandler("AuthenticationController:getBearerToken",this.getBearerToken.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:getSessionProfile",this.getSessionProfile.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:isSignedIn",this.isSignedIn.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:performSignIn",this.performSignIn.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:performSignOut",this.performSignOut.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:getUserProfileMetaMetrics",this.getUserProfileMetaMetrics.bind(this))},m=async function(e){if(e)return this.state.srpSessionData?.[e]?this.state.srpSessionData[e]:null;const t=Object.values(this.state.srpSessionData||{})?.[0];return t||null},d=async function(e,t){const s=await b(this,a,"f").getMetaMetricsId();this.update((n=>{t&&(n.isSignedIn=!0,n.srpSessionData||(n.srpSessionData={}),n.srpSessionData[t]={...e,profile:{...e.profile,metaMetricsId:s}})}))},u=function(e){if(!b(this,r,"f"))throw new Error(`${e} - unable to proceed, wallet is locked`)},h=async function(e){b(this,n,"m",u).call(this,"#snapGetPublicKey");return await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapPublicKeyRequest)(e))},p=async function(){b(this,n,"m",u).call(this,"#snapGetAllPublicKeys");return await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapAllPublicKeysRequest)())},g=async function(e,t){if((0,S.assertMessageStartsWithMetamask)(e),b(this,f,"f")[e])return b(this,f,"f")[e];b(this,n,"m",u).call(this,"#snapSignMessage");const s=await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapSignMessageRequest)(e,t));return b(this,f,"f")[e]=s,s},s.default=v}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/AuthenticationController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/index.cjs",{"./AuthenticationController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/AuthenticationController.cjs","./mocks/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)},o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&n(t,e,s);return a(t,e),t},r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.Mocks=s.Controller=void 0;const c=r(e("./AuthenticationController.cjs"));s.Controller=c.default;const l=c.default;s.default=l,i(e("./AuthenticationController.cjs"),s),s.Mocks=o(e("./mocks/index.cjs"))}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/index.cjs",{"./mockResponses.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/mockResponses.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./mockResponses.cjs"),s)}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/mockResponses.cjs",{"../../../sdk/mocks/auth.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/sdk/mocks/auth.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getMockAuthAccessTokenResponse=s.MOCK_OATH_TOKEN_RESPONSE=s.getMockAuthLoginResponse=s.MOCK_LOGIN_RESPONSE=s.getMockAuthNonceResponse=s.MOCK_JWT=s.MOCK_NONCE=s.MOCK_NONCE_RESPONSE=void 0;const n=e("../../../sdk/mocks/auth.cjs");s.MOCK_NONCE_RESPONSE=n.MOCK_NONCE_RESPONSE,s.MOCK_NONCE=s.MOCK_NONCE_RESPONSE.nonce,s.MOCK_JWT=n.MOCK_JWT;s.getMockAuthNonceResponse=()=>({url:n.MOCK_NONCE_URL,requestMethod:"GET",response:(e,t,n)=>{const a=t?.split("?identifier=")[1],i=n?.(a??"");return{...s.MOCK_NONCE_RESPONSE,nonce:i??s.MOCK_NONCE_RESPONSE.nonce,identifier:s.MOCK_NONCE_RESPONSE.identifier}}}),s.MOCK_LOGIN_RESPONSE=n.MOCK_SRP_LOGIN_RESPONSE;s.getMockAuthLoginResponse=()=>({url:n.MOCK_SRP_LOGIN_URL,requestMethod:"POST",response:e=>{const t=e?.raw_message.split(":"),n=t?.[t.length-2];return{...s.MOCK_LOGIN_RESPONSE,token:n??s.MOCK_LOGIN_RESPONSE.token,profile:{...s.MOCK_LOGIN_RESPONSE.profile,profile_id:n??s.MOCK_LOGIN_RESPONSE.profile.profile_id,identifier_id:n??s.MOCK_LOGIN_RESPONSE.profile.identifier_id}}}}),s.MOCK_OATH_TOKEN_RESPONSE=n.MOCK_OIDC_TOKEN_RESPONSE;s.getMockAuthAccessTokenResponse=()=>({url:n.MOCK_OIDC_TOKEN_URL,requestMethod:"POST",response:e=>{const t=new URLSearchParams(e).get("assertion");return{...s.MOCK_OATH_TOKEN_RESPONSE,access_token:t??s.MOCK_OATH_TOKEN_RESPONSE.access_token}}})}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/mockResponses.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/sdk/mocks/auth.cjs",{"../../shared/env.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/shared/env.cjs","../authentication-jwt-bearer/services.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/profile-sync-controller/dist/sdk/authentication-jwt-bearer/services.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MOCK_USER_PROFILE_METAMETRICS_RESPONSE=s.MOCK_OIDC_TOKEN_RESPONSE=s.MOCK_SRP_LOGIN_RESPONSE=s.MOCK_SIWE_LOGIN_RESPONSE=s.MOCK_NONCE_RESPONSE=s.MOCK_ACCESS_JWT=s.MOCK_JWT=s.MOCK_PROFILE_METAMETRICS_URL=s.MOCK_PAIR_IDENTIFIERS_URL=s.MOCK_SIWE_LOGIN_URL=s.MOCK_OIDC_TOKEN_URL=s.MOCK_SRP_LOGIN_URL=s.MOCK_NONCE_URL=void 0;const n=e("../../shared/env.cjs"),a=e("../authentication-jwt-bearer/services.cjs");s.MOCK_NONCE_URL=(0,a.NONCE_URL)(n.Env.PRD),s.MOCK_SRP_LOGIN_URL=(0,a.SRP_LOGIN_URL)(n.Env.PRD),s.MOCK_OIDC_TOKEN_URL=(0,a.OIDC_TOKEN_URL)(n.Env.PRD),s.MOCK_SIWE_LOGIN_URL=(0,a.SIWE_LOGIN_URL)(n.Env.PRD),s.MOCK_PAIR_IDENTIFIERS_URL=(0,a.PAIR_IDENTIFIERS)(n.Env.PRD),s.MOCK_PROFILE_METAMETRICS_URL=(0,a.PROFILE_METAMETRICS_URL)(n.Env.PRD),s.MOCK_JWT="eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6ImIwNzE2N2U2LWJjNWUtNDgyZC1hNjRhLWU1MjQ0MjY2MGU3NyJ9.eyJzdWIiOiI1MzE0ODc5YWM2NDU1OGI3OTQ5ZmI4NWIzMjg2ZjZjNjUwODAzYmFiMTY0Y2QyOWNmMmM3YzdmMjMzMWMwZTRlIiwiaWF0IjoxNzA2MTEzMDYyLCJleHAiOjE3NjkxODUwNjMsImlzcyI6ImF1dGgubWV0YW1hc2suaW8iLCJhdWQiOiJwb3J0Zm9saW8ubWV0YW1hc2suaW8ifQ.E5UL6oABNweS8t5a6IBTqTf7NLOJbrhJSmEcsr7kwLp4bGvcENJzACwnsHDkA6PlzfDV09ZhAGU_F3hlS0j-erbY0k0AFR-GAtyS7E9N02D8RgUDz5oDR65CKmzM8JilgFA8UvruJ6OJGogroaOSOqzRES_s8MjHpP47RJ9lXrUesajsbOudXbuksXWg5QmWip6LLvjwr8UUzcJzNQilyIhiEpo4WdzWM4R3VtTwr4rHnWEvtYnYCov1jmI2w3YQ48y0M-3Y9IOO0ov_vlITRrOnR7Y7fRUGLUFmU5msD8mNWRywjQFLHfJJ1yNP5aJ8TkuCK3sC6kcUH335IVvukQ",s.MOCK_ACCESS_JWT="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c",s.MOCK_NONCE_RESPONSE={nonce:"xGMm9SoihEKeAEfV",identifier:"0xd8641601Cb79a94FD872fE42d5b4a067A44a7e88",expires_in:300},s.MOCK_SIWE_LOGIN_RESPONSE={token:s.MOCK_JWT,expires_in:3600,profile:{profile_id:"fa2bbf82-bd9a-4e6b-aabc-9ca0d0319b6e",metametrics_id:"de742679-4960-4977-a415-4718b5f8e86c",identifier_id:"ec9a4e9906836497efad2fd4d4290b34d2c6a2c0d93eb174aa3cd88a133adbaf",identifier_type:"SIWE",encrypted_storage_key:"2c6a2c0d93eb174aa3cd88a133adbaf"}},s.MOCK_SRP_LOGIN_RESPONSE={token:s.MOCK_JWT,expires_in:3600,profile:{profile_id:"f88227bd-b615-41a3-b0be-467dd781a4ad",metametrics_id:"561ec651-a844-4b36-a451-04d6eac35740",identifier_id:"da9a9fc7b09edde9cc23cec9b7e11a71fb0ab4d2ddd8af8af905306f3e1456fb",identifier_type:"SRP",encrypted_storage_key:"d2ddd8af8af905306f3e1456fb"}},s.MOCK_OIDC_TOKEN_RESPONSE={access_token:s.MOCK_ACCESS_JWT,expires_in:3600},s.MOCK_USER_PROFILE_METAMETRICS_RESPONSE={profile_id:"f88227bd-b615-41a3-b0be-467dd781a4ad",created_at:"2025-10-01T12:00:00Z",lineage:[{metametrics_id:"561ec651-a844-4b36-a451-04d6eac35740",agent:n.Platform.MOBILE,created_at:"2025-10-01T12:00:00Z",updated_at:"2025-10-01T12:00:00Z",counter:1},{metametrics_id:"de742679-4960-4977-a415-4718b5f8e86c",agent:n.Platform.EXTENSION,created_at:"2025-10-01T12:00:00Z",updated_at:"2025-10-01T12:00:00Z",counter:2}]}}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/sdk/mocks/auth.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs",{"@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;const n=e("@metamask/base-controller"),a=e("@metamask/rpc-errors"),i=e("@metamask/utils"),o="RateLimitController",r={requests:{persist:!1,anonymous:!1}};class c extends n.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:s,state:n,implementations:a}){const c={requests:(0,i.getKnownPropertyNames)(a).reduce(((e,t)=>({...e,[t]:{}})),{})};super({name:o,metadata:r,messenger:s,state:{...c,...n}}),this.implementations=a,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messagingSystem.registerActionHandler(`${o}:call`,((e,t,...s)=>this.call(e,t,...s)))}async call(e,t,...s){if(this.isRateLimited(t,e))throw a.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const n=this.implementations[t].method;if(!n)throw new Error("Invalid api type");return n(...s)}isRateLimited(e,t){const s=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=s}recordRequest(e,t){const s=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,n=this.state.requests[e][t]??0;this.update((a=>{0===n&&setTimeout((()=>this.resetRequestCount(e,t)),s),Object.assign(a,{requests:{...a.requests,[e]:{[t]:n+1}}})}))}resetRequestCount(e,t){this.update((s=>{Object.assign(s,{requests:{...s.requests,[e]:{[t]:0}}})}))}}s.RateLimitController=c}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/index.cjs",{"./RateLimitController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RateLimitController=void 0;var n=e("./RateLimitController.cjs");Object.defineProperty(s,"RateLimitController",{enumerable:!0,get:function(){return n.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs",{"../constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},l=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.ClientConfigApiService=void 0;const m=e("@metamask/controller-utils"),d=e("../constants.cjs");s.ClientConfigApiService=class{constructor({fetch:e,retries:t=m.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:s=m.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:d=m.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:u,onDegraded:h,config:p}){n.set(this,void 0),a.set(this,void 0),i.set(this,void 0),o.set(this,void 0),r.set(this,void 0),c(this,n,e,"f"),c(this,i,p.client,"f"),c(this,o,p.distribution,"f"),c(this,r,p.environment,"f"),c(this,a,(0,m.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:s,circuitBreakDuration:d}),"f"),u&&l(this,a,"f").onBreak(u),h&&l(this,a,"f").onDegraded(h)}onBreak(...e){return l(this,a,"f").onBreak(...e)}onDegraded(...e){return l(this,a,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${d.BASE_URL}/flags?client=${l(this,i,"f")}&distribution=${l(this,o,"f")}&environment=${l(this,r,"f")}`,t=await l(this,a,"f").execute((()=>l(this,n,"f").call(this,e,{cache:"no-cache"})));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const s=await t.json();if(!Array.isArray(s))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(s),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce(((e,t)=>({...e,...t})),{})}},n=new WeakMap,a=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.BASE_URL=void 0,s.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs",{"./client-config-api-service/client-config-api-service.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs","./remote-feature-flag-controller-types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs","./remote-feature-flag-controller.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs","./utils/user-segmentation-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.generateDeterministicRandomNumber=s.ClientConfigApiService=s.EnvironmentType=s.DistributionType=s.ClientType=s.RemoteFeatureFlagController=void 0;var n=e("./remote-feature-flag-controller.cjs");Object.defineProperty(s,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return n.RemoteFeatureFlagController}});var a=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(s,"ClientType",{enumerable:!0,get:function(){return a.ClientType}}),Object.defineProperty(s,"DistributionType",{enumerable:!0,get:function(){return a.DistributionType}}),Object.defineProperty(s,"EnvironmentType",{enumerable:!0,get:function(){return a.EnvironmentType}});var i=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(s,"ClientConfigApiService",{enumerable:!0,get:function(){return i.ClientConfigApiService}});var o=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(s,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return o.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i;Object.defineProperty(s,"__esModule",{value:!0}),s.EnvironmentType=s.DistributionType=s.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(n||(s.ClientType=n={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(a||(s.DistributionType=a={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev"}(i||(s.EnvironmentType=i={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs",{"./utils/user-segmentation-utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d,u=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},h=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RemoteFeatureFlagController=s.getDefaultRemoteFeatureFlagControllerState=s.DEFAULT_CACHE_DURATION=s.controllerName=void 0;const p=e("@metamask/base-controller"),f=e("./utils/user-segmentation-utils.cjs");s.controllerName="RemoteFeatureFlagController",s.DEFAULT_CACHE_DURATION=864e5;const g={remoteFeatureFlags:{persist:!0,anonymous:!0},cacheTimestamp:{persist:!0,anonymous:!0}};function b(){return{remoteFeatureFlags:{},cacheTimestamp:0}}s.getDefaultRemoteFeatureFlagControllerState=b;class k extends p.BaseController{constructor({messenger:e,state:t,clientConfigApiService:l,fetchInterval:m=s.DEFAULT_CACHE_DURATION,disabled:d=!1,getMetaMetricsId:h}){super({name:s.controllerName,metadata:g,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),n.add(this),a.set(this,void 0),i.set(this,void 0),o.set(this,void 0),r.set(this,void 0),c.set(this,void 0),u(this,a,m,"f"),u(this,i,d,"f"),u(this,o,l,"f"),u(this,c,h,"f")}async updateRemoteFeatureFlags(){if(h(this,i,"f")||!h(this,n,"m",l).call(this))return;let e;if(h(this,r,"f"))await h(this,r,"f");else{try{u(this,r,h(this,o,"f").fetchRemoteFeatureFlags(),"f"),e=await h(this,r,"f")}finally{u(this,r,undefined,"f")}await h(this,n,"m",m).call(this,e.remoteFeatureFlags)}}enable(){u(this,i,!1,"f")}disable(){u(this,i,!0,"f")}}s.RemoteFeatureFlagController=k,a=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakMap,c=new WeakMap,n=new WeakSet,l=function(){return Date.now()-this.state.cacheTimestamp>h(this,a,"f")},m=async function(e){const t=await h(this,n,"m",d).call(this,e);this.update((()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()})))},d=async function(e){const t={},s=h(this,c,"f").call(this),n=(0,f.generateDeterministicRandomNumber)(s);for(const[s,a]of Object.entries(e)){let e=a;if(Array.isArray(a)&&n){const t=a.find((e=>!!(0,f.isFeatureFlagWithScopeValue)(e)&&n<=e.scope.value));t&&(e={name:t.name,value:t.value})}t[s]=e}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs",{uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isFeatureFlagWithScopeValue=s.generateDeterministicRandomNumber=void 0;const n=e("uuid");function a(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const i=a("00000000-0000-4000-8000-000000000000"),o=a("ffffffff-ffff-4fff-bfff-ffffffffffff")-i;s.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,s;if((0,n.validate)(e)){if(4!==(0,n.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,n.version)(e)}`);t=a(e)-i,s=o}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const n=e.slice(2),a=64;if(n.length!==a)throw new Error(`Invalid hex ID length. Expected ${a} characters, got ${n.length}`);if(!/^[0-9a-f]+$/iu.test(n))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${n}`),s=BigInt(`0x${"f".repeat(n.length)}`)}return Number(t*BigInt(1e6)/s)/1e6};s.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs",{"@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/swappable-obj-proxy":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/swappable-obj-proxy/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},u=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=s.METAMASK_DOMAIN=s.controllerName=void 0;const h=e("@metamask/base-controller"),p=e("@metamask/swappable-obj-proxy");s.controllerName="SelectedNetworkController";const f={domains:{persist:!0,anonymous:!1}};s.METAMASK_DOMAIN="metamask",s.SelectedNetworkControllerActionTypes={getState:`${s.controllerName}:getState`,getNetworkClientIdForDomain:`${s.controllerName}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${s.controllerName}:setNetworkClientIdForDomain`},s.SelectedNetworkControllerEventTypes={stateChange:`${s.controllerName}:stateChange`};class g extends h.BaseController{constructor({messenger:e,state:t={domains:{}},useRequestQueuePreference:r,onPreferencesStateChange:l,domainProxyMap:h}){super({name:s.controllerName,metadata:f,messenger:e,state:t}),n.add(this),a.set(this,void 0),i.set(this,void 0),d(this,i,r,"f"),d(this,a,h,"f"),u(this,n,"m",o).call(this),this.messagingSystem.call("PermissionController:getSubjectNames").filter((e=>this.state.domains[e]===undefined)).forEach((e=>this.setNetworkClientIdForDomain(e,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId))),this.messagingSystem.subscribe("PermissionController:stateChange",((e,t)=>{t.forEach((({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const s=t[1];"add"===e&&this.state.domains[s]===undefined?this.setNetworkClientIdForDomain(s,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[s]!==undefined&&u(this,n,"m",c).call(this,s)}}))})),this.messagingSystem.subscribe("NetworkController:stateChange",(({selectedNetworkClientId:e,networkConfigurationsByChainId:t},s)=>{const n=s.find((({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]));if(n){const s=Object.values(t).reduce(((e,t)=>(t.rpcEndpoints.forEach((({networkClientId:s})=>e[s]=t.chainId)),e)),{});Object.entries(this.state.domains).forEach((([a,i])=>{const o=s[i];if("remove"!==n.op||o){if("replace"===n.op){const e=n.path[1];if(!o||o===e){const s=t[e],{networkClientId:n}=s.rpcEndpoints[s.defaultRpcEndpointIndex];i!==n&&this.setNetworkClientIdForDomain(a,n)}}}else this.setNetworkClientIdForDomain(a,e)}))}})),l((({useRequestQueue:e})=>{u(this,i,"f")!==e&&(e?u(this,n,"m",m).call(this):Object.keys(this.state.domains).forEach((e=>{u(this,n,"m",c).call(this,e)})),d(this,i,e,"f"))}))}setNetworkClientIdForDomain(e,t){if(u(this,i,"f")){if(e===s.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${s.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!u(this,n,"m",l).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");u(this,n,"m",r).call(this,e,t)}}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messagingSystem.call("NetworkController:getState");return u(this,i,"f")?this.state.domains[e]??t:t}getProviderAndBlockTracker(e){if(e===s.METAMASK_DOMAIN){const e=this.messagingSystem.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=u(this,a,"f").get(e);if(t===undefined){let s;if(u(this,i,"f")&&u(this,n,"m",l).call(this,e)){const t=this.getNetworkClientIdForDomain(e);s=this.messagingSystem.call("NetworkController:getNetworkClientById",t)}else if(s=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),s===undefined)throw new Error("Selected network not initialized");t={provider:(0,p.createEventEmitterProxy)(s.provider),blockTracker:(0,p.createEventEmitterProxy)(s.blockTracker,{eventFilter:"skipInternal"})},u(this,a,"f").set(e,t)}return t}}s.SelectedNetworkController=g,a=new WeakMap,i=new WeakMap,n=new WeakSet,o=function(){this.messagingSystem.registerActionHandler(s.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messagingSystem.registerActionHandler(s.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},r=function(e,t){const s=this.messagingSystem.call("NetworkController:getNetworkClientById",t);this.update((s=>{s.domains[e]=t}));const n=this.getProviderAndBlockTracker(e);n.provider.setTarget(s.provider),n.blockTracker.setTarget(s.blockTracker)},c=function(e){const t=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),s=u(this,a,"f").get(e);s&&t?(s.provider.setTarget(t.provider),s.blockTracker.setTarget(t.blockTracker)):s&&u(this,a,"f").delete(e),this.update((t=>{delete t.domains[e]}))},l=function(e){return this.messagingSystem.call("PermissionController:hasPermissions",e)},m=function(){u(this,a,"f").forEach(((e,t)=>{const{selectedNetworkClientId:s}=this.messagingSystem.call("NetworkController:getState");u(this,n,"m",l).call(this,t)&&u(this,n,"m",r).call(this,t,s)}))}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs",{"./SelectedNetworkController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=void 0;const n=e("./SelectedNetworkController.cjs");s.createSelectedNetworkMiddleware=e=>(t,s,a)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var i;return t.networkClientId=(i=t.origin,e.call(n.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,i)),a()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/index.cjs",{"./SelectedNetworkController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs","./SelectedNetworkMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createSelectedNetworkMiddleware=s.METAMASK_DOMAIN=s.SelectedNetworkController=s.SelectedNetworkControllerEventTypes=s.SelectedNetworkControllerActionTypes=void 0;var n=e("./SelectedNetworkController.cjs");Object.defineProperty(s,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return n.SelectedNetworkControllerActionTypes}}),Object.defineProperty(s,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return n.SelectedNetworkControllerEventTypes}}),Object.defineProperty(s,"SelectedNetworkController",{enumerable:!0,get:function(){return n.SelectedNetworkController}}),Object.defineProperty(s,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return n.METAMASK_DOMAIN}});var a=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(s,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return a.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/constants.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/types.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/utils.js","@ethersproject/bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/bytes/lib/index.js","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/eth-query":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js","@metamask/polling-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","bignumber.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js","lodash/cloneDeep":"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/cloneDeep.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d,u,h,p,f,g,b,k,y,w,S,_,v,x,P,j,E,T,C,I=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},O=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)},A=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getDefaultSmartTransactionsControllerState=s.DEFAULT_INTERVAL=void 0;const M=e("@ethersproject/bytes"),R=e("@metamask/controller-utils"),N=A(e("@metamask/eth-query")),$=e("@metamask/polling-controller"),B=e("@metamask/transaction-controller"),L=e("bignumber.js"),D=A(e("lodash/cloneDeep")),F=e("./constants"),H=e("./types"),U=e("./utils");s.DEFAULT_INTERVAL=5e3;const q="`ethQuery` is not defined on SmartTransactionsController",V="SmartTransactionsController",W={smartTransactionsState:{persist:!0,anonymous:!0}};function K(){return{smartTransactionsState:{smartTransactions:{},userOptIn:null,userOptInV2:null,fees:{approvalTxFees:null,tradeTxFees:null},liveness:!0,livenessByChainId:{[R.ChainId.mainnet]:!0,[R.ChainId.sepolia]:!0},feesByChainId:{[R.ChainId.mainnet]:{approvalTxFees:null,tradeTxFees:null},[R.ChainId.sepolia]:{approvalTxFees:null,tradeTxFees:null}}}}}s.getDefaultSmartTransactionsControllerState=K;class G extends((0,$.StaticIntervalPollingController)()){constructor({interval:e=s.DEFAULT_INTERVAL,clientId:t,chainId:b=R.ChainId.mainnet,supportedChainIds:k=[R.ChainId.mainnet,R.ChainId.sepolia],getNonceLock:y,confirmExternalTransaction:w,trackMetaMetricsEvent:S,state:_={},messenger:v,getTransactions:x,getMetaMetricsProps:P,getFeatureFlags:j,updateTransaction:E,trace:T}){super({name:V,metadata:W,messenger:v,state:Object.assign(Object.assign({},K()),_)}),n.add(this),a.set(this,void 0),i.set(this,void 0),o.set(this,void 0),r.set(this,void 0),c.set(this,void 0),l.set(this,void 0),m.set(this,void 0),d.set(this,void 0),u.set(this,void 0),h.set(this,void 0),p.set(this,void 0),f.set(this,void 0),g.set(this,void 0),I(this,a,e,"f"),I(this,i,t,"f"),I(this,o,b,"f"),I(this,r,k,"f"),this.setIntervalLength(e),I(this,c,y,"f"),I(this,l,undefined,"f"),I(this,m,w,"f"),I(this,d,x,"f"),I(this,u,S,"f"),I(this,h,P,"f"),I(this,p,j,"f"),I(this,f,E,"f"),I(this,g,null!=T?T:(e,t)=>null==t?void 0:t(),"f"),this.initializeSmartTransactionsForChainId(),this.messagingSystem.subscribe("NetworkController:stateChange",(({selectedNetworkClientId:e})=>{const{configuration:{chainId:t},provider:s}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);I(this,o,t,"f"),I(this,l,new N.default(s),"f"),this.initializeSmartTransactionsForChainId(),this.checkPoll(this.state)})),this.messagingSystem.subscribe(`${V}:stateChange`,(e=>this.checkPoll(e)))}async _executePoll({chainIds:e}){const t=(null!=e?e:[]).filter((e=>O(this,r,"f").includes(e)));return 0===t.length?Promise.resolve():this.updateSmartTransactions({chainIds:t})}checkPoll({smartTransactionsState:{smartTransactions:e}}){const t=Object.values(e).flat(),s=null==t?void 0:t.filter(U.isSmartTransactionPending);!this.timeoutHandle&&(null==s?void 0:s.length)>0?this.poll():this.timeoutHandle&&0===(null==s?void 0:s.length)&&this.stop()}initializeSmartTransactionsForChainId(){O(this,r,"f").includes(O(this,o,"f"))&&this.update((e=>{var t;e.smartTransactionsState.smartTransactions[O(this,o,"f")]=null!==(t=e.smartTransactionsState.smartTransactions[O(this,o,"f")])&&void 0!==t?t:[]}))}async poll(e){e&&I(this,a,e,"f"),this.timeoutHandle&&clearInterval(this.timeoutHandle),O(this,r,"f").includes(O(this,o,"f"))&&(this.timeoutHandle=setInterval((()=>{(0,R.safelyExecute)((async()=>this.updateSmartTransactions()))}),O(this,a,"f")),await(0,R.safelyExecute)((async()=>this.updateSmartTransactions())))}async stop(){this.timeoutHandle&&clearInterval(this.timeoutHandle),this.timeoutHandle=undefined}setOptInState(e){this.update((t=>{t.smartTransactionsState.userOptInV2=e}))}trackStxStatusChange(e,t){let s=(0,D.default)(e);s=Object.assign(Object.assign({},(0,D.default)(t)),s),s.status!==(null==t?void 0:t.status)&&O(this,u,"f").call(this,{event:F.MetaMetricsEventName.StxStatusUpdated,category:F.MetaMetricsEventCategory.Transactions,properties:(0,U.getSmartTransactionMetricsProperties)(s),sensitiveProperties:(0,U.getSmartTransactionMetricsSensitiveProperties)(s)})}isNewSmartTransaction(e,t){const{smartTransactionsState:{smartTransactions:s}}=this.state,n=s[null!=t?t:O(this,o,"f")],a=null==n?void 0:n.findIndex((t=>t.uuid===e));return-1===a||a===undefined}updateSmartTransaction(e,{networkClientId:t}={}){let s=O(this,l,"f"),a=O(this,o,"f");if(t){const{configuration:e,provider:n}=this.messagingSystem.call("NetworkController:getNetworkClientById",t);a=e.chainId,s=new N.default(n)}O(this,n,"m",w).call(this,e,{chainId:a,ethQuery:s})}async updateSmartTransactions({chainIds:e}={chainIds:O(this,n,"m",P).call(this)}){const{smartTransactionsState:{smartTransactions:t}}=this.state;for(const[s,a]of Object.entries(t)){if(e&&!e.includes(s))continue;const t=a.filter(U.isSmartTransactionPending).map((e=>{const t=O(this,n,"m",j).call(this,{chainId:s});return{uuid:e.uuid,networkClientId:t,chainId:e.chainId}}));t.length>0&&await this.fetchSmartTransactionsStatus(t)}}async fetchSmartTransactionsStatus(e){const{chainId:t}=e[0],s=e.map((e=>e.uuid)),a=new URLSearchParams({uuids:s.join(",")}),i=O(this,n,"m",E).call(this,{networkClientId:e[0].networkClientId}),o=`${(0,U.getAPIRequestURL)(H.APIType.BATCH_STATUS,t)}?${a.toString()}`,r=await O(this,n,"m",b).call(this,o);for(const[s,a]of Object.entries(r)){const o=e.find((e=>e.uuid===s));if(!o){console.error(`No matching transaction found for uuid: ${s}`);continue}const r={statusMetadata:a,status:(0,U.calculateStatus)(a),cancellable:(0,U.isSmartTransactionCancellable)(a),uuid:s,networkClientId:o.networkClientId};await O(this,n,"m",w).call(this,r,{chainId:t,ethQuery:i})}return r}clearFees(){const e={approvalTxFees:null,tradeTxFees:null};return this.update((t=>{t.smartTransactionsState.fees=e})),e}async getFees(e,t,{networkClientId:s}={}){const a=null!=s?s:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,i=O(this,n,"m",x).call(this,{networkClientId:a}),r=[];let c;if(t){const s=await O(this,n,"m",v).call(this,t,a);r.push(s),c=Object.assign(Object.assign({},e),{nonce:(0,U.incrementNonceInHex)(s.nonce)})}else c=e.nonce?e:await O(this,n,"m",v).call(this,e,a);r.push(c);const l=await O(this,g,"f").call(this,{name:F.SmartTransactionsTraceName.GetFees},(async()=>await O(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.GET_FEES,i),{method:"POST",body:JSON.stringify({txs:r})})));let m,d;return t?(m=null==l?void 0:l.txs[0],d=null==l?void 0:l.txs[1]):(m=null,d=null==l?void 0:l.txs[0]),this.update((e=>{i===O(this,o,"f")&&(e.smartTransactionsState.fees={approvalTxFees:m,tradeTxFees:d}),e.smartTransactionsState.feesByChainId[i]={approvalTxFees:m,tradeTxFees:d}})),{approvalTxFees:m,tradeTxFees:d}}async submitSignedTransactions({transactionMeta:e,txParams:t,signedTransactions:s,signedCanceledTransactions:a=[],networkClientId:i}){var o,r;const l=null!=i?i:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,m=O(this,n,"m",x).call(this,{networkClientId:l}),d=O(this,n,"m",E).call(this,{networkClientId:l}),u=await O(this,g,"f").call(this,{name:F.SmartTransactionsTraceName.SubmitTransactions},(async()=>await O(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.SUBMIT_TRANSACTIONS,m),{method:"POST",body:JSON.stringify({rawTxs:s,rawCancelTxs:a})}))),h=Date.now();let p;try{if(null==t?void 0:t.from){const e=await(0,R.query)(d,"getBalance",[t.from]);p=new L.BigNumber(e).toString(16)}}catch(e){console.error("ethQuery.getBalance error:",e)}let f,k,y={};if(t&&!t.nonce)try{k=await O(this,c,"f").call(this,t.from,l),f=(0,M.hexlify)(k.nextNonce),y=k.nonceDetails,null!==(o=t.nonce)&&void 0!==o||(t.nonce=f)}catch(e){throw console.error("Failed to acquire nonce lock:",e),e}const S=s.map((e=>(0,U.getTxHash)(e))),_=Object.assign(Object.assign({},u),{txHash:S[S.length-1],txHashes:S});try{await O(this,n,"m",w).call(this,{chainId:m,nonceDetails:y,preTxBalance:p,status:H.SmartTransactionStatuses.PENDING,time:h,txParams:t,uuid:_.uuid,txHash:_.txHash,cancellable:!0,type:null!==(r=null==e?void 0:e.type)&&void 0!==r?r:"swap",transactionId:null==e?void 0:e.id,networkClientId:l,txHashes:S},{chainId:m,ethQuery:d})}catch(e){throw console.error("Failed to create a smart transaction:",e),e}finally{k&&k.releaseLock()}return _}async cancelSmartTransaction(e,{networkClientId:t}={}){const s=O(this,n,"m",x).call(this,{networkClientId:t});await O(this,g,"f").call(this,{name:F.SmartTransactionsTraceName.CancelTransaction},(async()=>await O(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.CANCEL,s),{method:"POST",body:JSON.stringify({uuid:e})})))}async fetchLiveness({networkClientId:e}={}){const t=O(this,n,"m",x).call(this,{networkClientId:e});let s=!1;try{const e=await O(this,g,"f").call(this,{name:F.SmartTransactionsTraceName.FetchLiveness},(async()=>await O(this,n,"m",b).call(this,(0,U.getAPIRequestURL)(H.APIType.LIVENESS,t))));s=Boolean(e.smartTransactions)}catch(e){console.log('"fetchLiveness" API call failed')}return this.update((e=>{t===O(this,o,"f")&&(e.smartTransactionsState.liveness=s),e.smartTransactionsState.livenessByChainId[t]=s})),s}async setStatusRefreshInterval(e){e!==O(this,a,"f")&&I(this,a,e,"f")}getTransactions({addressFrom:e,status:t}){return O(this,n,"m",T).call(this).filter((s=>{var n;return s.status===t&&(null===(n=s.txParams)||void 0===n?void 0:n.from)===e}))}getSmartTransactionByMinedTxHash(e){if(!e)return undefined;return O(this,n,"m",T).call(this).find((t=>{var s,n;return(null===(n=null===(s=t.statusMetadata)||void 0===s?void 0:s.minedHash)||void 0===n?void 0:n.toLowerCase())===e.toLowerCase()}))}wipeSmartTransactions({address:e,ignoreNetwork:t}){if(!e)return;const s=e.toLowerCase();if(t){const{smartTransactionsState:{smartTransactions:e}}=this.state;Object.keys(e).forEach((e=>{O(this,n,"m",C).call(this,{chainId:e,addressLowerCase:s})}))}else O(this,n,"m",C).call(this,{chainId:O(this,o,"f"),addressLowerCase:s})}}s.default=G,a=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakMap,c=new WeakMap,l=new WeakMap,m=new WeakMap,d=new WeakMap,u=new WeakMap,h=new WeakMap,p=new WeakMap,f=new WeakMap,g=new WeakMap,n=new WeakSet,b=async function(e,t){const s=Object.assign(Object.assign({},t),{headers:Object.assign({"Content-Type":"application/json"},O(this,i,"f")&&{"X-Client-Id":O(this,i,"f")})});return(0,U.handleFetch)(e,s)},k=function(e,{chainId:t=O(this,o,"f")}){var s;const{smartTransactionsState:{smartTransactions:n}}=this.state,a=null!==(s=n[t])&&void 0!==s?s:[],i=null==a?void 0:a.findIndex((t=>t.uuid===e.uuid));-1!==i&&(0,R.isSafeDynamicKey)(t)&&this.update((s=>{s.smartTransactionsState.smartTransactions[t][i]=Object.assign(Object.assign({},s.smartTransactionsState.smartTransactions[t][i]),e)}))},y=async function(e){const t=await O(this,h,"f").call(this);e.accountHardwareType=null==t?void 0:t.accountHardwareType,e.accountType=null==t?void 0:t.accountType,e.deviceModel=null==t?void 0:t.deviceModel},w=async function(e,{chainId:t=O(this,o,"f"),ethQuery:s=O(this,l,"f")}){var a;const{smartTransactionsState:{smartTransactions:r}}=this.state,c=null!==(a=r[t])&&void 0!==a?a:[],m=null==c?void 0:c.findIndex((t=>t.uuid===e.uuid)),u=this.isNewSmartTransaction(e.uuid,t);if(s===undefined)throw new Error(q);if(u)try{await O(this,n,"m",y).call(this,e)}catch(e){console.error("Failed to add metrics props to smart transaction:",e)}if(this.trackStxStatusChange(e,u?undefined:c[m]),u){const s=null==c?void 0:c.findIndex((t=>{var s,n,a;return(null===(s=t.txParams)||void 0===s?void 0:s.nonce)===(null===(n=e.txParams)||void 0===n?void 0:n.nonce)&&(null===(a=t.status)||void 0===a?void 0:a.startsWith("cancelled"))})),n=[(0,D.default)(e)],a=Object.assign(Object.assign({},e),{history:n}),i=s>-1?c.slice(0,s).concat(c.slice(s+1)).concat(a):c.concat(a);return void this.update((e=>{e.smartTransactionsState.smartTransactions[t]=i}))}const h=c[m],g=Object.assign(Object.assign({},h),e);this.messagingSystem.publish("SmartTransactionsController:smartTransaction",g),(0,U.shouldMarkRegularTransactionAsFailed)({smartTransaction:g,clientId:O(this,i,"f"),getFeatureFlags:O(this,p,"f")})&&(0,U.markRegularTransactionAsFailed)({smartTransaction:g,getRegularTransactions:O(this,d,"f"),updateTransaction:O(this,f,"f")}),e.status!==H.SmartTransactionStatuses.SUCCESS&&e.status!==H.SmartTransactionStatuses.REVERTED||e.confirmed?O(this,n,"m",k).call(this,e,{chainId:t}):await O(this,n,"m",_).call(this,g,{chainId:t,ethQuery:s})},S=function(e){if(!e)return!0;const t=O(this,d,"f").call(this),s=null==t?void 0:t.find((t=>{var s;return(null===(s=t.hash)||void 0===s?void 0:s.toLowerCase())===e.toLowerCase()}));return!s||![B.TransactionStatus.confirmed,B.TransactionStatus.submitted].includes(s.status)},_=async function(e,{chainId:t=O(this,o,"f"),ethQuery:s=O(this,l,"f")}){var a;if(s===undefined)throw new Error(q);const i=null===(a=e.statusMetadata)||void 0===a?void 0:a.minedHash;try{const a=await(0,R.query)(s,"getTransactionReceipt",[i]),o=await(0,R.query)(s,"getTransactionByHash",[i]),r=null==o?void 0:o.maxFeePerGas,c=null==o?void 0:o.maxPriorityFeePerGas;if(null==a?void 0:a.blockNumber){const o=await(0,R.query)(s,"getBlockByNumber",[null==a?void 0:a.blockNumber,!1]),l=null==o?void 0:o.baseFeePerGas,d=Object.assign(Object.assign({},e.txParams),{maxFeePerGas:r,maxPriorityFeePerGas:c}),h=Object.assign(Object.assign({},e),{id:e.uuid,status:B.TransactionStatus.confirmed,hash:i,txParams:d}),p=(0,U.snapshotFromTxMeta)(h),f=(0,U.replayHistory)(h.history),g=(0,U.generateHistoryEntry)(f,p,"txStateManager: setting status to confirmed"),b=g.length>0?Object.assign(Object.assign({},h),{history:h.history.concat(g)}):h;O(this,n,"m",S).call(this,i)&&O(this,m,"f").call(this,b,a,l),O(this,u,"f").call(this,{event:F.MetaMetricsEventName.StxConfirmed,category:F.MetaMetricsEventCategory.Transactions,properties:(0,U.getSmartTransactionMetricsProperties)(e),sensitiveProperties:(0,U.getSmartTransactionMetricsSensitiveProperties)(e)}),O(this,n,"m",k).call(this,Object.assign(Object.assign({},e),{confirmed:!0}),{chainId:t})}}catch(e){O(this,u,"f").call(this,{event:F.MetaMetricsEventName.StxConfirmationFailed,category:F.MetaMetricsEventCategory.Transactions}),console.error("confirm error",e)}finally{this.messagingSystem.publish("SmartTransactionsController:smartTransactionConfirmationDone",e)}},v=async function(e,t){const s=await O(this,c,"f").call(this,e.from,t),n=s.nextNonce;return s.releaseLock(),Object.assign(Object.assign({},e),{nonce:`0x${n.toString(16)}`})},x=function({networkClientId:e}={}){return e?this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId:O(this,o,"f")},P=function(){const{networkConfigurationsByChainId:e}=this.messagingSystem.call("NetworkController:getState");return Object.keys(e).filter((e=>O(this,r,"f").includes(e)))},j=function({chainId:e}){const{networkConfigurationsByChainId:t}=this.messagingSystem.call("NetworkController:getState");return t[e].rpcEndpoints[t[e].defaultRpcEndpointIndex].networkClientId},E=function({networkClientId:e}={}){if(e){const{provider:t}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);return new N.default(t)}if(O(this,l,"f")===undefined)throw new Error(q);return O(this,l,"f")},T=function(){const{smartTransactionsState:{smartTransactions:e}}=this.state,t=Object.values(e).flat();return t&&0!==t.length?t:[]},C=function({chainId:e,addressLowerCase:t}){const{smartTransactionsState:{smartTransactions:s}}=this.state,n=null==s?void 0:s[e];if(!n||0===n.length)return;const a=n.filter((e=>{var s;return(null===(s=e.txParams)||void 0===s?void 0:s.from)!==t}));this.update((t=>{t.smartTransactionsState.smartTransactions[e]=a}))}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/constants.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.SmartTransactionsTraceName=s.MetaMetricsEventCategory=s.MetaMetricsEventName=s.SENTINEL_API_BASE_URL_MAP=s.API_BASE_URL=void 0,s.API_BASE_URL="https://transaction.api.cx.metamask.io",s.SENTINEL_API_BASE_URL_MAP={1:"https://tx-sentinel-ethereum-mainnet.api.cx.metamask.io",56:"https://tx-sentinel-bsc-mainnet.api.cx.metamask.io",8453:"https://tx-sentinel-base-mainnet.api.cx.metamask.io",42161:"https://tx-sentinel-arbitrum-mainnet.api.cx.metamask.io",11155111:"https://tx-sentinel-ethereum-sepolia.api.cx.metamask.io"},function(e){e.StxStatusUpdated="STX Status Updated",e.StxConfirmed="STX Confirmed",e.StxConfirmationFailed="STX Confirmation Failed",e.ReceiveRequest="Receive Request"}(s.MetaMetricsEventName||(s.MetaMetricsEventName={})),function(e){e.Transactions="Transactions",e.Navigation="Navigation"}(s.MetaMetricsEventCategory||(s.MetaMetricsEventCategory={})),function(e){e.GetFees="Smart Transactions: Get Fees",e.SubmitTransactions="Smart Transactions: Submit Transactions",e.CancelTransaction="Smart Transactions: Cancel Transaction",e.FetchLiveness="Smart Transactions: Fetch Liveness"}(s.SmartTransactionsTraceName||(s.SmartTransactionsTraceName={}))}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/index.js",{"./SmartTransactionsController":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var a=e("./SmartTransactionsController");Object.defineProperty(s,"default",{enumerable:!0,get:function(){return n(a).default}})}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/utils.js",{"../package.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/package.json","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/constants.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/dist/types.js","@ethersproject/bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/bytes/lib/index.js","@ethersproject/keccak256":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/keccak256/lib/index.js","@ethersproject/transactions":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethersproject/transactions/lib/index.js","@metamask/transaction-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/transaction-controller/dist/index.cjs","bignumber.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js","fast-json-patch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-json-patch/index.js",lodash:"/home/runner/work/metamask-extension/metamask-extension/node_modules/lodash/lodash.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.markRegularTransactionAsFailed=s.shouldMarkRegularTransactionAsFailed=s.getReturnTxHashAsap=s.getSmartTransactionMetricsSensitiveProperties=s.getSmartTransactionMetricsProperties=s.getTxHash=s.incrementNonceInHex=s.isSmartTransactionCancellable=s.handleFetch=s.mapKeysToCamel=s.getStxProcessingTime=s.snapshotFromTxMeta=s.replayHistory=s.generateHistoryEntry=s.calculateStatus=s.getAPIRequestURL=s.isSmartTransactionStatusResolved=s.isSmartTransactionPending=void 0;const a=e("@ethersproject/bytes"),i=e("@ethersproject/keccak256"),o=e("@ethersproject/transactions"),r=e("@metamask/transaction-controller"),c=e("bignumber.js"),l=n(e("fast-json-patch")),m=n(e("lodash")),d=n(e("../package.json")),u=e("./constants"),h=e("./types");s.isSmartTransactionPending=function(e){return e.status===h.SmartTransactionStatuses.PENDING};s.isSmartTransactionStatusResolved=e=>"uuid_not_found"===e,s.getAPIRequestURL=function(e,t){const s=parseInt(t,16);switch(e){case h.APIType.GET_FEES:return`${u.API_BASE_URL}/networks/${s}/getFees`;case h.APIType.ESTIMATE_GAS:return`${u.API_BASE_URL}/networks/${s}/estimateGas`;case h.APIType.SUBMIT_TRANSACTIONS:return`${u.API_BASE_URL}/networks/${s}/submitTransactions?stxControllerVersion=${d.default.version}`;case h.APIType.CANCEL:return`${u.API_BASE_URL}/networks/${s}/cancel`;case h.APIType.BATCH_STATUS:return`${u.API_BASE_URL}/networks/${s}/batchStatus`;case h.APIType.LIVENESS:return`${u.SENTINEL_API_BASE_URL_MAP[s]}/network`;default:throw new Error("Invalid APIType")}};s.calculateStatus=e=>{if((0,s.isSmartTransactionStatusResolved)(e))return h.SmartTransactionStatuses.RESOLVED;const t=[h.SmartTransactionCancellationReason.WOULD_REVERT,h.SmartTransactionCancellationReason.TOO_CHEAP,h.SmartTransactionCancellationReason.DEADLINE_MISSED,h.SmartTransactionCancellationReason.INVALID_NONCE,h.SmartTransactionCancellationReason.USER_CANCELLED];if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.NOT_MINED){if(e.cancellationReason===h.SmartTransactionCancellationReason.NOT_CANCELLED)return h.SmartTransactionStatuses.PENDING;const s=t.findIndex((t=>t===e.cancellationReason))>-1;if(e.cancellationReason&&s)return e.isSettled?h.cancellationReasonToStatusMap[e.cancellationReason]:h.SmartTransactionStatuses.PENDING}else{if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.SUCCESS)return h.SmartTransactionStatuses.SUCCESS;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.CANCELLED)return h.SmartTransactionStatuses.CANCELLED;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.REVERTED)return h.SmartTransactionStatuses.REVERTED;if((null==e?void 0:e.minedTx)===h.SmartTransactionMinedTx.UNKNOWN)return h.SmartTransactionStatuses.UNKNOWN}return h.SmartTransactionStatuses.UNKNOWN},s.generateHistoryEntry=function(e,t,s){const n=l.default.compare(e,t);return n[0]&&(s&&(n[0].note=s),n[0].timestamp=Date.now()),n},s.replayHistory=function(e){return m.default.cloneDeep(e).reduce(((e,t)=>l.default.applyPatch(e,t).newDocument))},s.snapshotFromTxMeta=function(e){const t=Object.assign({},e);return delete t.history,m.default.cloneDeep(t)};s.getStxProcessingTime=e=>e?Math.round((Date.now()-e)/1e3):undefined;s.mapKeysToCamel=e=>{if(!m.default.isObject(e))return e;const t=m.default.mapValues(e,(e=>m.default.isArray(e)?e.map(s.mapKeysToCamel):m.default.isObject(e)?(0,s.mapKeysToCamel)(e):e));return m.default.mapKeys(t,((e,t)=>m.default.camelCase(t)))},s.handleFetch=async function(e,t){const n=await fetch(e,t),a=await n.json();if(!n.ok)throw console.log("response",n),new Error(`Fetch error:${JSON.stringify(Object.assign({status:n.status},(0,s.mapKeysToCamel)(a)))}`);return a};s.isSmartTransactionCancellable=e=>e.minedTx===h.SmartTransactionMinedTx.NOT_MINED&&(!e.cancellationReason||e.cancellationReason===h.SmartTransactionCancellationReason.NOT_CANCELLED);s.incrementNonceInHex=e=>{const t=new c.BigNumber(e,16).toString(10);return(0,a.hexlify)(Number(t)+1)};s.getTxHash=e=>{var t;if(!e)return"";try{const s=(0,o.parse)(e);return null!==(t=null==s?void 0:s.hash)&&void 0!==t?t:""}catch(t){if((e=>"string"==typeof e&&e.startsWith("0x04"))(e))return(0,a.hexlify)((0,i.keccak256)((0,a.arrayify)(e)));throw t}};s.getSmartTransactionMetricsProperties=e=>{if(!e)return{};const t=e.statusMetadata;return{stx_status:e.status,type:e.type,processing_time:(0,s.getStxProcessingTime)(e.time),is_smart_transaction:!0,stx_enabled:!0,current_stx_enabled:!0,stx_user_opt_in:!0,stx_duplicated:null==t?void 0:t.duplicated,stx_timed_out:null==t?void 0:t.timedOut,stx_proxied:null==t?void 0:t.proxied}};s.getSmartTransactionMetricsSensitiveProperties=e=>e?{token_from_symbol:e.sourceTokenSymbol,token_to_symbol:e.destinationTokenSymbol,account_hardware_type:e.accountHardwareType,account_type:e.accountType,device_model:e.deviceModel}:{};s.getReturnTxHashAsap=(e,t)=>e===h.ClientId.Extension?null==t?void 0:t.extensionReturnTxHashAsap:null==t?void 0:t.mobileReturnTxHashAsap;s.shouldMarkRegularTransactionAsFailed=({smartTransaction:e,clientId:t,getFeatureFlags:n})=>{var a;const{status:i,transactionId:o}=e,r=[h.SmartTransactionStatuses.CANCELLED,h.SmartTransactionStatuses.CANCELLED_USER_CANCELLED,h.SmartTransactionStatuses.UNKNOWN,h.SmartTransactionStatuses.RESOLVED];if(!i||!r.includes(i))return!1;const{smartTransactions:c}=null!==(a=n())&&void 0!==a?a:{},l=(0,s.getReturnTxHashAsap)(t,c);return Boolean(l&&o)};s.markRegularTransactionAsFailed=({smartTransaction:e,getRegularTransactions:t,updateTransaction:s})=>{const{transactionId:n,status:a}=e,i=t().find((e=>e.id===n));if(!i)throw new Error("Cannot find regular transaction to mark it as failed");if(i.status===r.TransactionStatus.failed)return;s(Object.assign(Object.assign({},i),{status:r.TransactionStatus.failed,error:{name:"SmartTransactionFailed",message:`Smart transaction failed with status: ${a}`}}),`Smart transaction status: ${a}`)}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs",{"fast-json-stable-stringify":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-json-stable-stringify/index.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)},a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.AbstractPollingControllerBaseMixin=s.getKey=void 0;const i=a(e("fast-json-stable-stringify")),o=e("uuid");s.getKey=e=>(0,i.default)(e),s.AbstractPollingControllerBaseMixin=function(e){var t,a;return t=new WeakMap,a=new WeakMap,class extends e{constructor(){super(...arguments),t.set(this,new Map),a.set(this,new Map)}startPolling(e){const a=(0,o.v4)(),i=(0,s.getKey)(e),r=n(this,t,"f").get(i)??new Set;return r.add(a),n(this,t,"f").set(i,r),1===r.size&&this._startPolling(e),a}stopAllPolling(){n(this,t,"f").forEach(((e,t)=>{e.forEach((e=>{this.stopPollingByPollingToken(e)}))}))}stopPollingByPollingToken(e){if(!e)throw new Error("pollingToken required");let s=null;for(const[a,i]of n(this,t,"f"))if(i.delete(e)){0===i.size&&(s=a);break}if(s){this._stopPollingByPollingTokenSetId(s),n(this,t,"f").delete(s);const e=n(this,a,"f").get(s);if(e){for(const t of e)t(JSON.parse(s));e.clear()}}}onPollingComplete(e,t){const i=(0,s.getKey)(e),o=n(this,a,"f").get(i)??new Set;o.add(t),n(this,a,"f").set(i,o)}}}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs",{"./AbstractPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.BlockTrackerPollingController=s.BlockTrackerPollingControllerOnly=void 0;const a=e("@metamask/base-controller"),i=e("./AbstractPollingController.cjs");function o(e){var t;class s extends((0,i.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{})}_startPolling(e){const s=(0,i.getKey)(e);if(n(this,t,"f")[s])return;const a=this._getNetworkClientById(e.networkClientId);if(!a)throw new Error(`Unable to retrieve blockTracker for networkClientId ${e.networkClientId}`);{const i=this._executePoll.bind(this,e);a.blockTracker.addListener("latest",i),n(this,t,"f")[s]=i}}_stopPollingByPollingTokenSetId(e){const{networkClientId:s}=JSON.parse(e),a=this._getNetworkClientById(s);if(a&&n(this,t,"f")[e]){const s=n(this,t,"f")[e];s&&(a.blockTracker.removeListener("latest",s),delete n(this,t,"f")[e])}}}return t=new WeakMap,s}class r{}s.BlockTrackerPollingControllerOnly=()=>o(r);s.BlockTrackerPollingController=()=>o(a.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs",{"./AbstractPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},a=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.StaticIntervalPollingController=s.StaticIntervalPollingControllerOnly=void 0;const i=e("@metamask/base-controller"),o=e("./AbstractPollingController.cjs");function r(e){var t,s;class i extends((0,o.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{}),s.set(this,1e3)}setIntervalLength(e){n(this,s,e,"f")}getIntervalLength(){return a(this,s,"f")}_startPolling(e){if(!a(this,s,"f"))throw new Error("intervalLength must be defined and greater than 0");const n=(0,o.getKey)(e),i=a(this,t,"f")[n];this._stopPollingByPollingTokenSetId(n);const r=a(this,t,"f")[n]=setTimeout((async()=>{try{await this._executePoll(e)}catch(e){console.error(e)}r===a(this,t,"f")[n]&&this._startPolling(e)}),i?a(this,s,"f"):0)}_stopPollingByPollingTokenSetId(e){const s=a(this,t,"f")[e];s&&(clearTimeout(s),delete a(this,t,"f")[e])}}return t=new WeakMap,s=new WeakMap,i}class c{}s.StaticIntervalPollingControllerOnly=()=>r(c);s.StaticIntervalPollingController=()=>r(i.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs",{"./BlockTrackerPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs","./StaticIntervalPollingController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.StaticIntervalPollingController=s.StaticIntervalPollingControllerOnly=s.BlockTrackerPollingController=s.BlockTrackerPollingControllerOnly=void 0;var n=e("./BlockTrackerPollingController.cjs");Object.defineProperty(s,"BlockTrackerPollingControllerOnly",{enumerable:!0,get:function(){return n.BlockTrackerPollingControllerOnly}}),Object.defineProperty(s,"BlockTrackerPollingController",{enumerable:!0,get:function(){return n.BlockTrackerPollingController}});var a=e("./StaticIntervalPollingController.cjs");Object.defineProperty(s,"StaticIntervalPollingControllerOnly",{enumerable:!0,get:function(){return a.StaticIntervalPollingControllerOnly}}),Object.defineProperty(s,"StaticIntervalPollingController",{enumerable:!0,get:function(){return a.StaticIntervalPollingController}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs",{immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},i=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.getPersistentState=s.getAnonymizedState=s.BaseController=s.isBaseController=void 0;const o=e("immer");(0,o.enablePatches)(),s.isBaseController=function(e){return"object"==typeof e&&null!==e&&"name"in e&&"string"==typeof e.name&&"state"in e&&"object"==typeof e.state&&"metadata"in e&&"object"==typeof e.metadata};function r(e,t,s){return Object.keys(e).reduce(((n,a)=>{try{const i=t[a];if(!i)throw new Error(`No metadata found for '${String(a)}'`);const o=i[s],r=e[a];return"function"==typeof o?n[a]=o(r):o&&(n[a]=r),n}catch(e){return setTimeout((()=>{throw e})),n}}),{})}s.BaseController=class{constructor({messenger:e,metadata:t,name:s,state:i}){n.set(this,void 0),this.messagingSystem=e,this.name=s,a(this,n,(0,o.freeze)(i,!0),"f"),this.metadata=t,this.messagingSystem.registerActionHandler(`${s}:getState`,(()=>this.state)),this.messagingSystem.registerInitialEventPayload({eventType:`${s}:stateChange`,getPayload:()=>[this.state,[]]})}get state(){return i(this,n,"f")}set state(e){throw new Error("Controller state cannot be directly mutated; use 'update' method instead.")}update(e){const[t,s,r]=o.produceWithPatches(i(this,n,"f"),e);return s.length>0&&(a(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,s)),{nextState:t,patches:s,inversePatches:r}}applyPatches(e){const t=(0,o.applyPatches)(i(this,n,"f"),e);a(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,e)}destroy(){this.messagingSystem.clearEventSubscriptions(`${this.name}:stateChange`)}},n=new WeakMap,s.getAnonymizedState=function(e,t){return r(e,t,"anonymous")},s.getPersistentState=function(e,t){return r(e,t,"persist")}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs",{"./RestrictedMessenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.Messenger=void 0;const c=e("./RestrictedMessenger.cjs");s.Messenger=class{constructor(){n.set(this,new Map),a.set(this,new Map),i.set(this,new Map),o.set(this,new Map)}registerActionHandler(e,t){if(r(this,n,"f").has(e))throw new Error(`A handler for ${e} has already been registered`);r(this,n,"f").set(e,t)}unregisterActionHandler(e){r(this,n,"f").delete(e)}clearActions(){r(this,n,"f").clear()}call(e,...t){const s=r(this,n,"f").get(e);if(!s)throw new Error(`A handler for ${e} has not been registered`);return s(...t)}registerInitialEventPayload({eventType:e,getPayload:t}){r(this,i,"f").set(e,t)}publish(e,...t){const s=r(this,a,"f").get(e);if(s)for(const[e,n]of s.entries())try{if(n){const s=r(this,o,"f").get(e),a=n(...t);a!==s&&(r(this,o,"f").set(e,a),e(a,s))}else e(...t)}catch(e){setTimeout((()=>{throw e}))}}subscribe(e,t,s){let n=r(this,a,"f").get(e);if(n||(n=new Map,r(this,a,"f").set(e,n)),n.set(t,s),s){const n=r(this,i,"f").get(e);if(n){const e=s(...n());r(this,o,"f").set(t,e)}}}unsubscribe(e,t){const s=r(this,a,"f").get(e);if(!s||!s.has(t))throw new Error(`Subscription not found for event: ${e}`);s.get(t)&&r(this,o,"f").delete(t),s.delete(t)}clearEventSubscriptions(e){r(this,a,"f").delete(e)}clearSubscriptions(){r(this,a,"f").clear()}getRestricted({name:e,allowedActions:t,allowedEvents:s}){return new c.RestrictedMessenger({messenger:this,name:e,allowedActions:t,allowedEvents:s})}},n=new WeakMap,a=new WeakMap,i=new WeakMap,o=new WeakMap}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n,a,i,o,r,c,l,m,d=this&&this.__classPrivateFieldSet||function(e,t,s,n,a){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?a.call(e,s):a?a.value=s:t.set(e,s),s},u=this&&this.__classPrivateFieldGet||function(e,t,s,n){if("a"===s&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?n:"a"===s?n.call(e):n?n.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedMessenger=void 0;s.RestrictedMessenger=class{constructor({messenger:e,name:t,allowedActions:s,allowedEvents:c}){if(n.add(this),a.set(this,void 0),i.set(this,void 0),o.set(this,void 0),r.set(this,void 0),!e)throw new Error("Messenger not provided");d(this,a,e,"f"),d(this,i,t,"f"),d(this,o,s,"f"),d(this,r,c,"f")}registerActionHandler(e,t){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed registering action handlers prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").registerActionHandler(e,t)}unregisterActionHandler(e){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed unregistering action handlers prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").unregisterActionHandler(e)}call(e,...t){if(!u(this,n,"m",l).call(this,e))throw new Error(`Action missing from allow list: ${e}`);return u(this,a,"f").call(e,...t)}registerInitialEventPayload({eventType:e,getPayload:t}){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").registerInitialEventPayload({eventType:e,getPayload:t})}publish(e,...t){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").publish(e,...t)}subscribe(e,t,s){if(!u(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);return s?u(this,a,"f").subscribe(e,t,s):u(this,a,"f").subscribe(e,t)}unsubscribe(e,t){if(!u(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);u(this,a,"f").unsubscribe(e,t)}clearEventSubscriptions(e){if(!u(this,n,"m",m).call(this,e))throw new Error(`Only allowed clearing events prefixed by '${u(this,i,"f")}:'`);u(this,a,"f").clearEventSubscriptions(e)}},a=new WeakMap,i=new WeakMap,o=new WeakMap,r=new WeakMap,n=new WeakSet,c=function(e){const t=u(this,r,"f");return u(this,n,"m",m).call(this,e)||null!==t&&t.includes(e)},l=function(e){const t=u(this,o,"f");return u(this,n,"m",m).call(this,e)||null!==t&&t.includes(e)},m=function(e){return e.startsWith(`${u(this,i,"f")}:`)}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs",{"./BaseControllerV2.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs","./Messenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs","./RestrictedMessenger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.RestrictedMessenger=s.Messenger=s.isBaseController=s.getPersistentState=s.getAnonymizedState=s.BaseController=void 0;var n=e("./BaseControllerV2.cjs");Object.defineProperty(s,"BaseController",{enumerable:!0,get:function(){return n.BaseController}}),Object.defineProperty(s,"getAnonymizedState",{enumerable:!0,get:function(){return n.getAnonymizedState}}),Object.defineProperty(s,"getPersistentState",{enumerable:!0,get:function(){return n.getPersistentState}}),Object.defineProperty(s,"isBaseController",{enumerable:!0,get:function(){return n.isBaseController}});var a=e("./Messenger.cjs");Object.defineProperty(s,"Messenger",{enumerable:!0,get:function(){return a.Messenger}});var i=e("./RestrictedMessenger.cjs");Object.defineProperty(s,"RestrictedMessenger",{enumerable:!0,get:function(){return i.RestrictedMessenger}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){!function(e){var s,n=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,a=Math.ceil,i=Math.floor,o="[BigNumber Error] ",r=o+"Number primitive has more than 15 significant digits: ",c=1e14,l=14,m=9007199254740991,d=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],u=1e7,h=1e9;function p(e){var t=0|e;return e>0||e===t?t:t-1}function f(e){for(var t,s,n=1,a=e.length,i=e[0]+"";n<a;){for(t=e[n++]+"",s=l-t.length;s--;t="0"+t);i+=t}for(a=i.length;48===i.charCodeAt(--a););return i.slice(0,a+1||1)}function g(e,t){var s,n,a=e.c,i=t.c,o=e.s,r=t.s,c=e.e,l=t.e;if(!o||!r)return null;if(s=a&&!a[0],n=i&&!i[0],s||n)return s?n?0:-r:o;if(o!=r)return o;if(s=o<0,n=c==l,!a||!i)return n?0:!a^s?1:-1;if(!n)return c>l^s?1:-1;for(r=(c=a.length)<(l=i.length)?c:l,o=0;o<r;o++)if(a[o]!=i[o])return a[o]>i[o]^s?1:-1;return c==l?0:c>l^s?1:-1}function b(e,t,s,n){if(e<t||e>s||e!==i(e))throw Error(o+(n||"Argument")+("number"==typeof e?e<t||e>s?" out of range: ":" not an integer: ":" not a primitive number: ")+String(e))}function k(e){var t=e.c.length-1;return p(e.e/l)==t&&e.c[t]%2!=0}function y(e,t){return(e.length>1?e.charAt(0)+"."+e.slice(1):e)+(t<0?"e":"e+")+t}function w(e,t,s){var n,a;if(t<0){for(a=s+".";++t;a+=s);e=a+e}else if(++t>(n=e.length)){for(a=s,t-=n;--t;a+=s);e+=a}else t<n&&(e=e.slice(0,t)+"."+e.slice(t));return e}s=function e(t){var s,S,_,v,x,P,j,E,T,C,I=V.prototype={constructor:V,toString:null,valueOf:null},O=new V(1),A=20,M=4,R=-7,N=21,$=-1e7,B=1e7,L=!1,D=1,F=0,H={prefix:"",groupSize:3,secondaryGroupSize:0,groupSeparator:",",decimalSeparator:".",fractionGroupSize:0,fractionGroupSeparator:" ",suffix:""},U="0123456789abcdefghijklmnopqrstuvwxyz",q=!0;function V(e,t){var s,a,o,c,d,u,h,p,f=this;if(!(f instanceof V))return new V(e,t);if(null==t){if(e&&!0===e._isBigNumber)return f.s=e.s,void(!e.c||e.e>B?f.c=f.e=null:e.e<$?f.c=[f.e=0]:(f.e=e.e,f.c=e.c.slice()));if((u="number"==typeof e)&&0*e==0){if(f.s=1/e<0?(e=-e,-1):1,e===~~e){for(c=0,d=e;d>=10;d/=10,c++);return void(c>B?f.c=f.e=null:(f.e=c,f.c=[e]))}p=String(e)}else{if(!n.test(p=String(e)))return _(f,p,u);f.s=45==p.charCodeAt(0)?(p=p.slice(1),-1):1}(c=p.indexOf("."))>-1&&(p=p.replace(".","")),(d=p.search(/e/i))>0?(c<0&&(c=d),c+=+p.slice(d+1),p=p.substring(0,d)):c<0&&(c=p.length)}else{if(b(t,2,U.length,"Base"),10==t&&q)return z(f=new V(e),A+f.e+1,M);if(p=String(e),u="number"==typeof e){if(0*e!=0)return _(f,p,u,t);if(f.s=1/e<0?(p=p.slice(1),-1):1,V.DEBUG&&p.replace(/^0\.0*|\./,"").length>15)throw Error(r+e)}else f.s=45===p.charCodeAt(0)?(p=p.slice(1),-1):1;for(s=U.slice(0,t),c=d=0,h=p.length;d<h;d++)if(s.indexOf(a=p.charAt(d))<0){if("."==a){if(d>c){c=h;continue}}else if(!o&&(p==p.toUpperCase()&&(p=p.toLowerCase())||p==p.toLowerCase()&&(p=p.toUpperCase()))){o=!0,d=-1,c=0;continue}return _(f,String(e),u,t)}u=!1,(c=(p=S(p,t,10,f.s)).indexOf("."))>-1?p=p.replace(".",""):c=p.length}for(d=0;48===p.charCodeAt(d);d++);for(h=p.length;48===p.charCodeAt(--h););if(p=p.slice(d,++h)){if(h-=d,u&&V.DEBUG&&h>15&&(e>m||e!==i(e)))throw Error(r+f.s*e);if((c=c-d-1)>B)f.c=f.e=null;else if(c<$)f.c=[f.e=0];else{if(f.e=c,f.c=[],d=(c+1)%l,c<0&&(d+=l),d<h){for(d&&f.c.push(+p.slice(0,d)),h-=l;d<h;)f.c.push(+p.slice(d,d+=l));d=l-(p=p.slice(d)).length}else d-=h;for(;d--;p+="0");f.c.push(+p)}}else f.c=[f.e=0]}function W(e,t,s,n){var a,i,o,r,c;if(null==s?s=M:b(s,0,8),!e.c)return e.toString();if(a=e.c[0],o=e.e,null==t)c=f(e.c),c=1==n||2==n&&(o<=R||o>=N)?y(c,o):w(c,o,"0");else if(i=(e=z(new V(e),t,s)).e,r=(c=f(e.c)).length,1==n||2==n&&(t<=i||i<=R)){for(;r<t;c+="0",r++);c=y(c,i)}else if(t-=o,c=w(c,i,"0"),i+1>r){if(--t>0)for(c+=".";t--;c+="0");}else if((t+=i-r)>0)for(i+1==r&&(c+=".");t--;c+="0");return e.s<0&&a?"-"+c:c}function K(e,t){for(var s,n,a=1,i=new V(e[0]);a<e.length;a++)(!(n=new V(e[a])).s||(s=g(i,n))===t||0===s&&i.s===t)&&(i=n);return i}function G(e,t,s){for(var n=1,a=t.length;!t[--a];t.pop());for(a=t[0];a>=10;a/=10,n++);return(s=n+s*l-1)>B?e.c=e.e=null:s<$?e.c=[e.e=0]:(e.e=s,e.c=t),e}function z(e,t,s,n){var o,r,m,u,h,p,f,g=e.c,b=d;if(g){e:{for(o=1,u=g[0];u>=10;u/=10,o++);if((r=t-o)<0)r+=l,m=t,h=g[p=0],f=i(h/b[o-m-1]%10);else if((p=a((r+1)/l))>=g.length){if(!n)break e;for(;g.length<=p;g.push(0));h=f=0,o=1,m=(r%=l)-l+1}else{for(h=u=g[p],o=1;u>=10;u/=10,o++);f=(m=(r%=l)-l+o)<0?0:i(h/b[o-m-1]%10)}if(n=n||t<0||null!=g[p+1]||(m<0?h:h%b[o-m-1]),n=s<4?(f||n)&&(0==s||s==(e.s<0?3:2)):f>5||5==f&&(4==s||n||6==s&&(r>0?m>0?h/b[o-m]:0:g[p-1])%10&1||s==(e.s<0?8:7)),t<1||!g[0])return g.length=0,n?(t-=e.e+1,g[0]=b[(l-t%l)%l],e.e=-t||0):g[0]=e.e=0,e;if(0==r?(g.length=p,u=1,p--):(g.length=p+1,u=b[l-r],g[p]=m>0?i(h/b[o-m]%b[m])*u:0),n)for(;;){if(0==p){for(r=1,m=g[0];m>=10;m/=10,r++);for(m=g[0]+=u,u=1;m>=10;m/=10,u++);r!=u&&(e.e++,g[0]==c&&(g[0]=1));break}if(g[p]+=u,g[p]!=c)break;g[p--]=0,u=1}for(r=g.length;0===g[--r];g.pop());}e.e>B?e.c=e.e=null:e.e<$&&(e.c=[e.e=0])}return e}function J(e){var t,s=e.e;return null===s?e.toString():(t=f(e.c),t=s<=R||s>=N?y(t,s):w(t,s,"0"),e.s<0?"-"+t:t)}return V.clone=e,V.ROUND_UP=0,V.ROUND_DOWN=1,V.ROUND_CEIL=2,V.ROUND_FLOOR=3,V.ROUND_HALF_UP=4,V.ROUND_HALF_DOWN=5,V.ROUND_HALF_EVEN=6,V.ROUND_HALF_CEIL=7,V.ROUND_HALF_FLOOR=8,V.EUCLID=9,V.config=V.set=function(e){var t,s;if(null!=e){if("object"!=typeof e)throw Error(o+"Object expected: "+e);if(e.hasOwnProperty(t="DECIMAL_PLACES")&&(b(s=e[t],0,h,t),A=s),e.hasOwnProperty(t="ROUNDING_MODE")&&(b(s=e[t],0,8,t),M=s),e.hasOwnProperty(t="EXPONENTIAL_AT")&&((s=e[t])&&s.pop?(b(s[0],-h,0,t),b(s[1],0,h,t),R=s[0],N=s[1]):(b(s,-h,h,t),R=-(N=s<0?-s:s))),e.hasOwnProperty(t="RANGE"))if((s=e[t])&&s.pop)b(s[0],-h,-1,t),b(s[1],1,h,t),$=s[0],B=s[1];else{if(b(s,-h,h,t),!s)throw Error(o+t+" cannot be zero: "+s);$=-(B=s<0?-s:s)}if(e.hasOwnProperty(t="CRYPTO")){if((s=e[t])!==!!s)throw Error(o+t+" not true or false: "+s);if(s){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw L=!s,Error(o+"crypto unavailable");L=s}else L=s}if(e.hasOwnProperty(t="MODULO_MODE")&&(b(s=e[t],0,9,t),D=s),e.hasOwnProperty(t="POW_PRECISION")&&(b(s=e[t],0,h,t),F=s),e.hasOwnProperty(t="FORMAT")){if("object"!=typeof(s=e[t]))throw Error(o+t+" not an object: "+s);H=s}if(e.hasOwnProperty(t="ALPHABET")){if("string"!=typeof(s=e[t])||/^.?$|[+\-.\s]|(.).*\1/.test(s))throw Error(o+t+" invalid: "+s);q="0123456789"==s.slice(0,10),U=s}}return{DECIMAL_PLACES:A,ROUNDING_MODE:M,EXPONENTIAL_AT:[R,N],RANGE:[$,B],CRYPTO:L,MODULO_MODE:D,POW_PRECISION:F,FORMAT:H,ALPHABET:U}},V.isBigNumber=function(e){if(!e||!0!==e._isBigNumber)return!1;if(!V.DEBUG)return!0;var t,s,n=e.c,a=e.e,r=e.s;e:if("[object Array]"=={}.toString.call(n)){if((1===r||-1===r)&&a>=-h&&a<=h&&a===i(a)){if(0===n[0]){if(0===a&&1===n.length)return!0;break e}if((t=(a+1)%l)<1&&(t+=l),String(n[0]).length==t){for(t=0;t<n.length;t++)if((s=n[t])<0||s>=c||s!==i(s))break e;if(0!==s)return!0}}}else if(null===n&&null===a&&(null===r||1===r||-1===r))return!0;throw Error(o+"Invalid BigNumber: "+e)},V.maximum=V.max=function(){return K(arguments,-1)},V.minimum=V.min=function(){return K(arguments,1)},V.random=(v=9007199254740992,x=Math.random()*v&2097151?function(){return i(Math.random()*v)}:function(){return 8388608*(1073741824*Math.random()|0)+(8388608*Math.random()|0)},function(e){var t,s,n,r,c,m=0,u=[],p=new V(O);if(null==e?e=A:b(e,0,h),r=a(e/l),L)if(crypto.getRandomValues){for(t=crypto.getRandomValues(new Uint32Array(r*=2));m<r;)(c=131072*t[m]+(t[m+1]>>>11))>=9e15?(s=crypto.getRandomValues(new Uint32Array(2)),t[m]=s[0],t[m+1]=s[1]):(u.push(c%1e14),m+=2);m=r/2}else{if(!crypto.randomBytes)throw L=!1,Error(o+"crypto unavailable");for(t=crypto.randomBytes(r*=7);m<r;)(c=281474976710656*(31&t[m])+1099511627776*t[m+1]+4294967296*t[m+2]+16777216*t[m+3]+(t[m+4]<<16)+(t[m+5]<<8)+t[m+6])>=9e15?crypto.randomBytes(7).copy(t,m):(u.push(c%1e14),m+=7);m=r/7}if(!L)for(;m<r;)(c=x())<9e15&&(u[m++]=c%1e14);for(r=u[--m],e%=l,r&&e&&(c=d[l-e],u[m]=i(r/c)*c);0===u[m];u.pop(),m--);if(m<0)u=[n=0];else{for(n=-1;0===u[0];u.splice(0,1),n-=l);for(m=1,c=u[0];c>=10;c/=10,m++);m<l&&(n-=l-m)}return p.e=n,p.c=u,p}),V.sum=function(){for(var e=1,t=arguments,s=new V(t[0]);e<t.length;)s=s.plus(t[e++]);return s},S=function(){var e="0123456789";function t(e,t,s,n){for(var a,i,o=[0],r=0,c=e.length;r<c;){for(i=o.length;i--;o[i]*=t);for(o[0]+=n.indexOf(e.charAt(r++)),a=0;a<o.length;a++)o[a]>s-1&&(null==o[a+1]&&(o[a+1]=0),o[a+1]+=o[a]/s|0,o[a]%=s)}return o.reverse()}return function(n,a,i,o,r){var c,l,m,d,u,h,p,g,b=n.indexOf("."),k=A,y=M;for(b>=0&&(d=F,F=0,n=n.replace(".",""),h=(g=new V(a)).pow(n.length-b),F=d,g.c=t(w(f(h.c),h.e,"0"),10,i,e),g.e=g.c.length),m=d=(p=t(n,a,i,r?(c=U,e):(c=e,U))).length;0==p[--d];p.pop());if(!p[0])return c.charAt(0);if(b<0?--m:(h.c=p,h.e=m,h.s=o,p=(h=s(h,g,k,y,i)).c,u=h.r,m=h.e),b=p[l=m+k+1],d=i/2,u=u||l<0||null!=p[l+1],u=y<4?(null!=b||u)&&(0==y||y==(h.s<0?3:2)):b>d||b==d&&(4==y||u||6==y&&1&p[l-1]||y==(h.s<0?8:7)),l<1||!p[0])n=u?w(c.charAt(1),-k,c.charAt(0)):c.charAt(0);else{if(p.length=l,u)for(--i;++p[--l]>i;)p[l]=0,l||(++m,p=[1].concat(p));for(d=p.length;!p[--d];);for(b=0,n="";b<=d;n+=c.charAt(p[b++]));n=w(n,m,c.charAt(0))}return n}}(),s=function(){function e(e,t,s){var n,a,i,o,r=0,c=e.length,l=t%u,m=t/u|0;for(e=e.slice();c--;)r=((a=l*(i=e[c]%u)+(n=m*i+(o=e[c]/u|0)*l)%u*u+r)/s|0)+(n/u|0)+m*o,e[c]=a%s;return r&&(e=[r].concat(e)),e}function t(e,t,s,n){var a,i;if(s!=n)i=s>n?1:-1;else for(a=i=0;a<s;a++)if(e[a]!=t[a]){i=e[a]>t[a]?1:-1;break}return i}function s(e,t,s,n){for(var a=0;s--;)e[s]-=a,a=e[s]<t[s]?1:0,e[s]=a*n+e[s]-t[s];for(;!e[0]&&e.length>1;e.splice(0,1));}return function(n,a,o,r,m){var d,u,h,f,g,b,k,y,w,S,_,v,x,P,j,E,T,C=n.s==a.s?1:-1,I=n.c,O=a.c;if(!(I&&I[0]&&O&&O[0]))return new V(n.s&&a.s&&(I?!O||I[0]!=O[0]:O)?I&&0==I[0]||!O?0*C:C/0:NaN);for(w=(y=new V(C)).c=[],C=o+(u=n.e-a.e)+1,m||(m=c,u=p(n.e/l)-p(a.e/l),C=C/l|0),h=0;O[h]==(I[h]||0);h++);if(O[h]>(I[h]||0)&&u--,C<0)w.push(1),f=!0;else{for(P=I.length,E=O.length,h=0,C+=2,(g=i(m/(O[0]+1)))>1&&(O=e(O,g,m),I=e(I,g,m),E=O.length,P=I.length),x=E,_=(S=I.slice(0,E)).length;_<E;S[_++]=0);T=O.slice(),T=[0].concat(T),j=O[0],O[1]>=m/2&&j++;do{if(g=0,(d=t(O,S,E,_))<0){if(v=S[0],E!=_&&(v=v*m+(S[1]||0)),(g=i(v/j))>1)for(g>=m&&(g=m-1),k=(b=e(O,g,m)).length,_=S.length;1==t(b,S,k,_);)g--,s(b,E<k?T:O,k,m),k=b.length,d=1;else 0==g&&(d=g=1),k=(b=O.slice()).length;if(k<_&&(b=[0].concat(b)),s(S,b,_,m),_=S.length,-1==d)for(;t(O,S,E,_)<1;)g++,s(S,E<_?T:O,_,m),_=S.length}else 0===d&&(g++,S=[0]);w[h++]=g,S[0]?S[_++]=I[x]||0:(S=[I[x]],_=1)}while((x++<P||null!=S[0])&&C--);f=null!=S[0],w[0]||w.splice(0,1)}if(m==c){for(h=1,C=w[0];C>=10;C/=10,h++);z(y,o+(y.e=h+u*l-1)+1,r,f)}else y.e=u,y.r=+f;return y}}(),P=/^(-?)0([xbo])(?=\w[\w.]*$)/i,j=/^([^.]+)\.$/,E=/^\.([^.]+)$/,T=/^-?(Infinity|NaN)$/,C=/^\s*\+(?=[\w.])|^\s+|\s+$/g,_=function(e,t,s,n){var a,i=s?t:t.replace(C,"");if(T.test(i))e.s=isNaN(i)?null:i<0?-1:1;else{if(!s&&(i=i.replace(P,(function(e,t,s){return a="x"==(s=s.toLowerCase())?16:"b"==s?2:8,n&&n!=a?e:t})),n&&(a=n,i=i.replace(j,"$1").replace(E,"0.$1")),t!=i))return new V(i,a);if(V.DEBUG)throw Error(o+"Not a"+(n?" base "+n:"")+" number: "+t);e.s=null}e.c=e.e=null},I.absoluteValue=I.abs=function(){var e=new V(this);return e.s<0&&(e.s=1),e},I.comparedTo=function(e,t){return g(this,new V(e,t))},I.decimalPlaces=I.dp=function(e,t){var s,n,a,i=this;if(null!=e)return b(e,0,h),null==t?t=M:b(t,0,8),z(new V(i),e+i.e+1,t);if(!(s=i.c))return null;if(n=((a=s.length-1)-p(this.e/l))*l,a=s[a])for(;a%10==0;a/=10,n--);return n<0&&(n=0),n},I.dividedBy=I.div=function(e,t){return s(this,new V(e,t),A,M)},I.dividedToIntegerBy=I.idiv=function(e,t){return s(this,new V(e,t),0,1)},I.exponentiatedBy=I.pow=function(e,t){var s,n,r,c,m,d,u,h,p=this;if((e=new V(e)).c&&!e.isInteger())throw Error(o+"Exponent not an integer: "+J(e));if(null!=t&&(t=new V(t)),m=e.e>14,!p.c||!p.c[0]||1==p.c[0]&&!p.e&&1==p.c.length||!e.c||!e.c[0])return h=new V(Math.pow(+J(p),m?e.s*(2-k(e)):+J(e))),t?h.mod(t):h;if(d=e.s<0,t){if(t.c?!t.c[0]:!t.s)return new V(NaN);(n=!d&&p.isInteger()&&t.isInteger())&&(p=p.mod(t))}else{if(e.e>9&&(p.e>0||p.e<-1||(0==p.e?p.c[0]>1||m&&p.c[1]>=24e7:p.c[0]<8e13||m&&p.c[0]<=9999975e7)))return c=p.s<0&&k(e)?-0:0,p.e>-1&&(c=1/c),new V(d?1/c:c);F&&(c=a(F/l+2))}for(m?(s=new V(.5),d&&(e.s=1),u=k(e)):u=(r=Math.abs(+J(e)))%2,h=new V(O);;){if(u){if(!(h=h.times(p)).c)break;c?h.c.length>c&&(h.c.length=c):n&&(h=h.mod(t))}if(r){if(0===(r=i(r/2)))break;u=r%2}else if(z(e=e.times(s),e.e+1,1),e.e>14)u=k(e);else{if(0===(r=+J(e)))break;u=r%2}p=p.times(p),c?p.c&&p.c.length>c&&(p.c.length=c):n&&(p=p.mod(t))}return n?h:(d&&(h=O.div(h)),t?h.mod(t):c?z(h,F,M,undefined):h)},I.integerValue=function(e){var t=new V(this);return null==e?e=M:b(e,0,8),z(t,t.e+1,e)},I.isEqualTo=I.eq=function(e,t){return 0===g(this,new V(e,t))},I.isFinite=function(){return!!this.c},I.isGreaterThan=I.gt=function(e,t){return g(this,new V(e,t))>0},I.isGreaterThanOrEqualTo=I.gte=function(e,t){return 1===(t=g(this,new V(e,t)))||0===t},I.isInteger=function(){return!!this.c&&p(this.e/l)>this.c.length-2},I.isLessThan=I.lt=function(e,t){return g(this,new V(e,t))<0},I.isLessThanOrEqualTo=I.lte=function(e,t){return-1===(t=g(this,new V(e,t)))||0===t},I.isNaN=function(){return!this.s},I.isNegative=function(){return this.s<0},I.isPositive=function(){return this.s>0},I.isZero=function(){return!!this.c&&0==this.c[0]},I.minus=function(e,t){var s,n,a,i,o=this,r=o.s;if(t=(e=new V(e,t)).s,!r||!t)return new V(NaN);if(r!=t)return e.s=-t,o.plus(e);var m=o.e/l,d=e.e/l,u=o.c,h=e.c;if(!m||!d){if(!u||!h)return u?(e.s=-t,e):new V(h?o:NaN);if(!u[0]||!h[0])return h[0]?(e.s=-t,e):new V(u[0]?o:3==M?-0:0)}if(m=p(m),d=p(d),u=u.slice(),r=m-d){for((i=r<0)?(r=-r,a=u):(d=m,a=h),a.reverse(),t=r;t--;a.push(0));a.reverse()}else for(n=(i=(r=u.length)<(t=h.length))?r:t,r=t=0;t<n;t++)if(u[t]!=h[t]){i=u[t]<h[t];break}if(i&&(a=u,u=h,h=a,e.s=-e.s),(t=(n=h.length)-(s=u.length))>0)for(;t--;u[s++]=0);for(t=c-1;n>r;){if(u[--n]<h[n]){for(s=n;s&&!u[--s];u[s]=t);--u[s],u[n]+=c}u[n]-=h[n]}for(;0==u[0];u.splice(0,1),--d);return u[0]?G(e,u,d):(e.s=3==M?-1:1,e.c=[e.e=0],e)},I.modulo=I.mod=function(e,t){var n,a,i=this;return e=new V(e,t),!i.c||!e.s||e.c&&!e.c[0]?new V(NaN):!e.c||i.c&&!i.c[0]?new V(i):(9==D?(a=e.s,e.s=1,n=s(i,e,0,3),e.s=a,n.s*=a):n=s(i,e,0,D),(e=i.minus(n.times(e))).c[0]||1!=D||(e.s=i.s),e)},I.multipliedBy=I.times=function(e,t){var s,n,a,i,o,r,m,d,h,f,g,b,k,y,w,S=this,_=S.c,v=(e=new V(e,t)).c;if(!(_&&v&&_[0]&&v[0]))return!S.s||!e.s||_&&!_[0]&&!v||v&&!v[0]&&!_?e.c=e.e=e.s=null:(e.s*=S.s,_&&v?(e.c=[0],e.e=0):e.c=e.e=null),e;for(n=p(S.e/l)+p(e.e/l),e.s*=S.s,(m=_.length)<(f=v.length)&&(k=_,_=v,v=k,a=m,m=f,f=a),a=m+f,k=[];a--;k.push(0));for(y=c,w=u,a=f;--a>=0;){for(s=0,g=v[a]%w,b=v[a]/w|0,i=a+(o=m);i>a;)s=((d=g*(d=_[--o]%w)+(r=b*d+(h=_[o]/w|0)*g)%w*w+k[i]+s)/y|0)+(r/w|0)+b*h,k[i--]=d%y;k[i]=s}return s?++n:k.splice(0,1),G(e,k,n)},I.negated=function(){var e=new V(this);return e.s=-e.s||null,e},I.plus=function(e,t){var s,n=this,a=n.s;if(t=(e=new V(e,t)).s,!a||!t)return new V(NaN);if(a!=t)return e.s=-t,n.minus(e);var i=n.e/l,o=e.e/l,r=n.c,m=e.c;if(!i||!o){if(!r||!m)return new V(a/0);if(!r[0]||!m[0])return m[0]?e:new V(r[0]?n:0*a)}if(i=p(i),o=p(o),r=r.slice(),a=i-o){for(a>0?(o=i,s=m):(a=-a,s=r),s.reverse();a--;s.push(0));s.reverse()}for((a=r.length)-(t=m.length)<0&&(s=m,m=r,r=s,t=a),a=0;t;)a=(r[--t]=r[t]+m[t]+a)/c|0,r[t]=c===r[t]?0:r[t]%c;return a&&(r=[a].concat(r),++o),G(e,r,o)},I.precision=I.sd=function(e,t){var s,n,a,i=this;if(null!=e&&e!==!!e)return b(e,1,h),null==t?t=M:b(t,0,8),z(new V(i),e,t);if(!(s=i.c))return null;if(n=(a=s.length-1)*l+1,a=s[a]){for(;a%10==0;a/=10,n--);for(a=s[0];a>=10;a/=10,n++);}return e&&i.e+1>n&&(n=i.e+1),n},I.shiftedBy=function(e){return b(e,-9007199254740991,m),this.times("1e"+e)},I.squareRoot=I.sqrt=function(){var e,t,n,a,i,o=this,r=o.c,c=o.s,l=o.e,m=A+4,d=new V("0.5");if(1!==c||!r||!r[0])return new V(!c||c<0&&(!r||r[0])?NaN:r?o:1/0);if(0==(c=Math.sqrt(+J(o)))||c==1/0?(((t=f(r)).length+l)%2==0&&(t+="0"),c=Math.sqrt(+t),l=p((l+1)/2)-(l<0||l%2),n=new V(t=c==1/0?"5e"+l:(t=c.toExponential()).slice(0,t.indexOf("e")+1)+l)):n=new V(c+""),n.c[0])for((c=(l=n.e)+m)<3&&(c=0);;)if(i=n,n=d.times(i.plus(s(o,i,m,1))),f(i.c).slice(0,c)===(t=f(n.c)).slice(0,c)){if(n.e<l&&--c,"9999"!=(t=t.slice(c-3,c+1))&&(a||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(z(n,n.e+A+2,1),e=!n.times(n).eq(o));break}if(!a&&(z(i,i.e+A+2,0),i.times(i).eq(o))){n=i;break}m+=4,c+=4,a=1}return z(n,n.e+A+1,M,e)},I.toExponential=function(e,t){return null!=e&&(b(e,0,h),e++),W(this,e,t,1)},I.toFixed=function(e,t){return null!=e&&(b(e,0,h),e=e+this.e+1),W(this,e,t)},I.toFormat=function(e,t,s){var n,a=this;if(null==s)null!=e&&t&&"object"==typeof t?(s=t,t=null):e&&"object"==typeof e?(s=e,e=t=null):s=H;else if("object"!=typeof s)throw Error(o+"Argument not an object: "+s);if(n=a.toFixed(e,t),a.c){var i,r=n.split("."),c=+s.groupSize,l=+s.secondaryGroupSize,m=s.groupSeparator||"",d=r[0],u=r[1],h=a.s<0,p=h?d.slice(1):d,f=p.length;if(l&&(i=c,c=l,l=i,f-=i),c>0&&f>0){for(i=f%c||c,d=p.substr(0,i);i<f;i+=c)d+=m+p.substr(i,c);l>0&&(d+=m+p.slice(i)),h&&(d="-"+d)}n=u?d+(s.decimalSeparator||"")+((l=+s.fractionGroupSize)?u.replace(new RegExp("\\d{"+l+"}\\B","g"),"$&"+(s.fractionGroupSeparator||"")):u):d}return(s.prefix||"")+n+(s.suffix||"")},I.toFraction=function(e){var t,n,a,i,r,c,m,u,h,p,g,b,k=this,y=k.c;if(null!=e&&(!(m=new V(e)).isInteger()&&(m.c||1!==m.s)||m.lt(O)))throw Error(o+"Argument "+(m.isInteger()?"out of range: ":"not an integer: ")+J(m));if(!y)return new V(k);for(t=new V(O),h=n=new V(O),a=u=new V(O),b=f(y),r=t.e=b.length-k.e-1,t.c[0]=d[(c=r%l)<0?l+c:c],e=!e||m.comparedTo(t)>0?r>0?t:h:m,c=B,B=1/0,m=new V(b),u.c[0]=0;p=s(m,t,0,1),1!=(i=n.plus(p.times(a))).comparedTo(e);)n=a,a=i,h=u.plus(p.times(i=h)),u=i,t=m.minus(p.times(i=t)),m=i;return i=s(e.minus(n),a,0,1),u=u.plus(i.times(h)),n=n.plus(i.times(a)),u.s=h.s=k.s,g=s(h,a,r*=2,M).minus(k).abs().comparedTo(s(u,n,r,M).minus(k).abs())<1?[h,a]:[u,n],B=c,g},I.toNumber=function(){return+J(this)},I.toPrecision=function(e,t){return null!=e&&b(e,1,h),W(this,e,t,2)},I.toString=function(e){var t,s=this,n=s.s,a=s.e;return null===a?n?(t="Infinity",n<0&&(t="-"+t)):t="NaN":(null==e?t=a<=R||a>=N?y(f(s.c),a):w(f(s.c),a,"0"):10===e&&q?t=w(f((s=z(new V(s),A+a+1,M)).c),s.e,"0"):(b(e,2,U.length,"Base"),t=S(w(f(s.c),a,"0"),10,e,n,!0)),n<0&&s.c[0]&&(t="-"+t)),t},I.valueOf=I.toJSON=function(){return J(this)},I._isBigNumber=!0,null!=t&&V.set(t),V}(),s.default=s.BigNumber=s,"function"==typeof define&&define.amd?define((function(){return s})):void 0!==t&&t.exports?t.exports=s:(e||(e="undefined"!=typeof self&&self?self:window),e.BigNumber=s)}(this)}}},{package:"@metamask/smart-transactions-controller>bignumber.js",file:"node_modules/@metamask/smart-transactions-controller/node_modules/bignumber.js/bignumber.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/smart-transactions-controller/package.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={name:"@metamask/smart-transactions-controller",version:"17.0.0",description:"Improves success rates for swaps by trialing transactions privately and finding minimum fees",repository:{type:"git",url:"https://github.com/MetaMask/smart-transactions-controller.git"},license:"SEE LICENSE IN LICENSE",main:"dist/index.js",types:"dist/index.d.ts",files:["dist/"],scripts:{build:"tsc --project tsconfig.build.json","build:clean":"rm -rf dist && yarn build","build:link":"yarn build && cd dist && yarn link && rm -rf node_modules && cd ..",lint:"yarn lint:eslint && yarn lint:misc --check && yarn lint:changelog","lint:changelog":"auto-changelog validate --prettier","lint:eslint":"eslint . --cache --ext js,ts","lint:fix":"yarn lint:eslint --fix && yarn lint:misc --write && yarn lint:changelog","lint:misc":"prettier '**/*.json' '**/*.md' '**/*.yml' '!.yarnrc.yml' --ignore-path .gitignore --no-error-on-unmatched-pattern",prepack:"./scripts/prepack.sh",test:"jest","test:watch":"jest --watchAll"},dependencies:{"@babel/runtime":"^7.24.1","@ethereumjs/tx":"^5.2.1","@ethereumjs/util":"^9.0.2","@ethersproject/bytes":"^5.7.0","@ethersproject/keccak256":"^5.8.0","@ethersproject/transactions":"^5.7.0","@metamask/base-controller":"^7.0.1","@metamask/controller-utils":"^11.0.0","@metamask/eth-json-rpc-provider":"^4.1.6","@metamask/eth-query":"^4.0.0","@metamask/polling-controller":"^12.0.0","bignumber.js":"^9.0.1","fast-json-patch":"^3.1.0",lodash:"^4.17.21"},devDependencies:{"@lavamoat/allow-scripts":"^3.2.1","@lavamoat/preinstall-always-fail":"^2.1.0","@metamask/auto-changelog":"^3.1.0","@metamask/eslint-config":"^12.2.0","@metamask/eslint-config-jest":"^12.1.0","@metamask/eslint-config-nodejs":"^12.1.0","@metamask/eslint-config-typescript":"^12.1.0","@metamask/gas-fee-controller":"^22.0.0","@metamask/json-rpc-engine":"^10.0.1","@metamask/network-controller":"^24.0.0","@metamask/transaction-controller":"^42.0.0","@types/jest":"^26.0.24","@types/lodash":"^4.14.194","@types/node":"^18.19.17","@types/sinon":"^9.0.10","@typescript-eslint/eslint-plugin":"^5.33.0","@typescript-eslint/parser":"^5.33.0",eslint:"^8.48.0","eslint-config-prettier":"^8.8.0","eslint-plugin-import":"~2.26.0","eslint-plugin-jest":"^27.1.5","eslint-plugin-jsdoc":"^39.2.9","eslint-plugin-n":"^15.7.0","eslint-plugin-prettier":"^4.2.1","eslint-plugin-promise":"^6.1.1","isomorphic-fetch":"^3.0.0",jest:"^29.7.0",nock:"^14.0.0-beta.7",prettier:"^2.8.8","prettier-plugin-packagejson":"^2.4.3",sinon:"^9.2.4","ts-jest":"^29.1.4",typescript:"~4.8.4"},peerDependencies:{"@metamask/network-controller":"^24.0.0","@metamask/transaction-controller":"^42.0.0"},peerDependenciesMeta:{"@metamask/accounts-controller":{optional:!0},"@metamask/approval-controller":{optional:!0}},packageManager:"yarn@3.2.1",engines:{node:"^18.18 || >=20"},publishConfig:{access:"public",registry:"https://registry.npmjs.org/"},lavamoat:{allowScripts:{"@lavamoat/preinstall-always-fail":!1,"@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>keccak":!1,"@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>secp256k1":!1,"@metamask/controller-utils>babel-runtime>core-js":!1,"@metamask/transaction-controller>@metamask/accounts-controller>@metamask/keyring-controller>ethereumjs-wallet>ethereum-cryptography>keccak":!1,"@metamask/transaction-controller>@metamask/accounts-controller>@metamask/keyring-controller>ethereumjs-wallet>ethereum-cryptography>secp256k1":!1}}}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/package.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs",{"../snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","../snaps/constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js",luxon:"/home/runner/work/metamask-extension/metamask-extension/node_modules/luxon/build/cjs-browser/luxon.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t){return e.get(r(e,t))}function o(e,t,s){return e.set(r(e,t),s),s}function r(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.CronjobController=s.DAILY_TIMEOUT=void 0;const c=e("@metamask/base-controller"),l=e("@metamask/snaps-rpc-methods"),m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=e("immer"),h=e("luxon"),p=e("nanoid"),f=e("./utils.cjs"),g=e("../snaps/constants.cjs"),b=e("../snaps/Timer.cjs");s.DAILY_TIMEOUT=(0,d.inMilliseconds)(24,d.Duration.Hour);const k="CronjobController";var y=new WeakMap,w=new WeakMap,S=new WeakMap,_=new WeakSet,v=new WeakMap,x=new WeakMap,P=new WeakMap,j=new WeakMap,E=new WeakMap;class T extends c.BaseController{constructor({messenger:e,state:t,stateManager:c}){var l,m;super({messenger:e,metadata:{events:{persist:!1,anonymous:!1}},name:k,state:{events:{},...t,...c.getInitialState()}}),a(l=this,m=_),m.add(l),n(this,y,void 0),n(this,w,void 0),n(this,S,new b.Timer(s.DAILY_TIMEOUT)),n(this,v,(e=>{this.unregister(e.id),this.register(e.id)})),n(this,x,(e=>{const t=this.get(e.id);r(_,this,$).call(this,t),this.register(e.id)})),n(this,P,(e=>{this.unregister(e.id)})),n(this,j,(e=>{this.unregister(e.id)})),n(this,E,(e=>{this.unregister(e.id),this.register(e.id)})),o(y,this,new Map),o(w,this,c),this.messagingSystem.subscribe("SnapController:snapInstalled",i(v,this)),this.messagingSystem.subscribe("SnapController:snapUninstalled",i(P,this)),this.messagingSystem.subscribe("SnapController:snapEnabled",i(x,this)),this.messagingSystem.subscribe("SnapController:snapDisabled",i(j,this)),this.messagingSystem.subscribe("SnapController:snapUpdated",i(E,this)),this.messagingSystem.registerActionHandler(`${k}:init`,((...e)=>this.init(...e))),this.messagingSystem.registerActionHandler(`${k}:schedule`,((...e)=>this.schedule(...e))),this.messagingSystem.registerActionHandler(`${k}:cancel`,((...e)=>this.cancel(...e))),this.messagingSystem.registerActionHandler(`${k}:get`,((...e)=>this.get(...e)))}init(){r(_,this,C).call(this),r(_,this,B).call(this),r(_,this,$).call(this)}schedule(e){return r(_,this,I).call(this,{...e,recurring:!1})}cancel(e,t){(0,d.assert)(this.state.events[t],`A background event with the id of "${t}" does not exist.`),(0,d.assert)(this.state.events[t].snapId===e,"Only the origin that scheduled this event can cancel it."),r(_,this,R).call(this,t)}get(e){return Object.values(this.state.events).filter((t=>t.snapId===e&&!t.recurring)).map((e=>({...e,date:(0,m.toCensoredISO8601String)(e.date),scheduledAt:(0,m.toCensoredISO8601String)(e.scheduledAt)})))}register(e){const t=r(_,this,N).call(this,e);null==t||t.forEach((e=>r(_,this,I).call(this,e)))}unregister(e){for(const[t,s]of Object.entries(this.state.events))s.snapId===e&&r(_,this,R).call(this,t)}destroy(){super.destroy(),this.messagingSystem.unsubscribe("SnapController:snapInstalled",i(v,this)),this.messagingSystem.unsubscribe("SnapController:snapUninstalled",i(P,this)),this.messagingSystem.unsubscribe("SnapController:snapEnabled",i(x,this)),this.messagingSystem.unsubscribe("SnapController:snapDisabled",i(j,this)),this.messagingSystem.unsubscribe("SnapController:snapUpdated",i(E,this)),i(y,this).forEach((e=>e.cancel())),i(y,this).clear(),"running"===i(S,this).status&&i(S,this).cancel()}}function C(){o(S,this,new b.Timer(s.DAILY_TIMEOUT)),i(S,this).start((()=>{r(_,this,$).call(this),r(_,this,C).call(this)}))}function I(e){const t=e.id??(0,p.nanoid)(),s={...e,id:t,date:(0,f.getExecutionDate)(e.schedule),scheduledAt:(new Date).toISOString()},{nextState:n}=this.update((e=>{e.events[s.id]=(0,u.castDraft)(s)}));return i(w,this).set(n),r(_,this,O).call(this,s),t}function O(e){const t=(0,f.getExecutionDate)(e.schedule),{nextState:s}=this.update((s=>{s.events[e.id].date=t}));i(w,this).set(s),r(_,this,A).call(this,{...e,date:t})}function A(e){const t=h.DateTime.fromISO(e.date,{setZone:!0}).toMillis()-Date.now();if(t>s.DAILY_TIMEOUT)return;if(t<=0)return void r(_,this,M).call(this,e);const n=new b.Timer(t);n.start((()=>{r(_,this,M).call(this,e)})),i(y,this).set(e.id,n)}function M(e){if(this.messagingSystem.call("SnapController:handleRequest",{snapId:e.snapId,origin:g.METAMASK_ORIGIN,handler:m.HandlerType.OnCronjob,request:e.request}).catch((t=>{(0,m.logError)(`An error occurred while executing an event for Snap "${e.snapId}":`,t)})),i(y,this).delete(e.id),e.recurring)r(_,this,O).call(this,e);else{const{nextState:t}=this.update((t=>{delete t.events[e.id]}));i(w,this).set(t)}}function R(e){const t=i(y,this).get(e);null==t||t.cancel(),i(y,this).delete(e);const{nextState:s}=this.update((t=>{delete t.events[e]}));i(w,this).set(s)}function N(e){const t=this.messagingSystem.call("PermissionController:getPermissions",e),s=null==t?void 0:t[l.SnapEndowments.Cronjob],n=(0,l.getCronjobCaveatJobs)(s);return n?n.map(((t,s)=>({snapId:e,id:`cronjob-${e}-${s}`,request:t.request,schedule:(0,f.getCronjobSpecificationSchedule)(t),recurring:!0}))):[]}function $(e=Object.values(this.state.events)){const t=Date.now();for(const s of e){if(i(y,this).has(s.id))continue;const e=h.DateTime.fromISO(s.date,{setZone:!0}).toUTC().toMillis();s.recurring&&e<=t&&r(_,this,M).call(this,s),r(_,this,O).call(this,s)}}function B(){const e=Date.now();for(const t of Object.values(this.state.events)){const s=h.DateTime.fromISO(t.date,{setZone:!0}).toUTC().toMillis();!t.recurring&&s<e&&r(_,this,R).call(this,t.id)}}s.CronjobController=T}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs",{"./CronjobController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/CronjobController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./CronjobController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","cron-parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/cron-parser/lib/parser.js",luxon:"/home/runner/work/metamask-extension/metamask-extension/node_modules/luxon/build/cjs-browser/luxon.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getExecutionDate=s.getCronjobSpecificationSchedule=void 0;const n=e("@metamask/utils"),a=e("cron-parser"),i=e("luxon");s.getCronjobSpecificationSchedule=function(e){return(0,n.hasProperty)(e,"duration")?e.duration:e.expression},s.getExecutionDate=function(e){const t=i.DateTime.fromISO(e,{setZone:!0});if(t.isValid){const e=Date.now(),s=t.toUTC().startOf("second");if(s.toMillis()<e)throw new Error("Cannot schedule an event in the past.");return s.toISO({suppressMilliseconds:!0})}const s=i.Duration.fromISO(e);if(s.isValid){const e=function(e){return e.as("seconds")<1?i.Duration.fromObject({seconds:1}):e}(s);return i.DateTime.now().toUTC().plus(e).toISO()}try{const t=(0,a.parseExpression)(e,{utc:!0}).next(),s=i.DateTime.fromJSDate(t.toDate());return(0,n.assert)(s.isValid),s.toUTC().toISO()}catch{throw new Error(`Unable to parse "${e}" as ISO 8601 date, ISO 8601 duration, or cron expression.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/cronjob/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/fsm.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@xstate/fsm":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@xstate/fsm/lib/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.forceStrict=s.validateMachine=void 0;const n=e("@metamask/utils"),a=e("@xstate/fsm");s.validateMachine=function(e){(0,n.assert)("_options"in e,"The machine is not an @xstate/fsm machine");const t=e,s=new Set,a=e=>{return(t=e,Array.isArray(t)?t:t===undefined||null===t?[]:[t]).flatMap((e=>"string"==typeof e?[e]:((0,n.assert)("function"==typeof e),[]))).forEach(s.add.bind(s));var t};for(const e of Object.values(t.config.states)){a(e.entry),a(e.exit);for(const t of Object.values(e.on??{}))a(t.actions)}s.forEach((e=>(0,n.assert)(t._options.actions!==undefined&&e in t._options.actions,`Action "${e}" doesn't have an implementation`)))},s.forceStrict=function(e){let t=!1;e.subscribe((e=>{(0,n.assert)(!t||e.changed,"Invalid state transition"),t=!0}));const s=e.send.bind(e);e.send=(...t)=>((0,n.assert)(e.status===a.InterpreterStatus.Running,"Interpreter is stopped"),s(...t))}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/fsm.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/index.cjs",{"./cronjob/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/cronjob/index.cjs","./insights/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/index.cjs","./interface/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/index.cjs","./multichain/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs","./services/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/index.cjs","./snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","./websocket/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./services/index.cjs"),s),a(e("./snaps/index.cjs"),s),a(e("./utils.cjs"),s),a(e("./cronjob/index.cjs"),s),a(e("./interface/index.cjs"),s),a(e("./insights/index.cjs"),s),a(e("./multichain/index.cjs"),s),a(e("./websocket/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function a(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapInsightsController=void 0;const i=e("@metamask/base-controller"),o=e("@metamask/snaps-rpc-methods"),r=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("../snaps/index.cjs");var m=new WeakSet;class d extends i.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{insights:{persist:!1,anonymous:!1}},name:"SnapInsightsController",state:{insights:{},...t}}),n(this,m),this.messagingSystem.subscribe("TransactionController:unapprovedTransactionAdded",a(m,this,p).bind(this)),this.messagingSystem.subscribe("TransactionController:transactionStatusUpdated",a(m,this,b).bind(this)),this.messagingSystem.subscribe("SignatureController:stateChange",a(m,this,f).bind(this))}}function u(e){return(0,c.hasProperty)(this.state.insights,e)}function h(e){const t=this.messagingSystem.call("SnapController:getAll");return(0,l.getRunnableSnaps)(t).reduce(((t,s)=>{const n=this.messagingSystem.call("PermissionController:getPermissions",s.id);return n&&(0,c.hasProperty)(n,e)&&t.push({snapId:s.id,permission:n[e]}),t}),[])}function p(e){const{id:t,txParams:s,chainId:n,origin:i}=e,l=`eip155:${(0,c.hexToBigInt)(n).toString(10)}`;a(m,this,h).call(this,o.SnapEndowments.TransactionInsight).forEach((({snapId:e,permission:n})=>{const c=(0,o.getTransactionOriginCaveat)(n)&&i?i:null;this.update((s=>{var n;(n=s.insights)[t]??(n[t]={}),s.insights[t][e]={snapId:e,loading:!0}})),a(m,this,y).call(this,{snapId:e,handler:r.HandlerType.OnTransaction,params:{transaction:s,chainId:l,transactionOrigin:c}}).then((s=>a(m,this,w).call(this,{id:t,snapId:e,response:s}))).catch((s=>a(m,this,w).call(this,{id:t,snapId:e,error:s})))}))}function f(e){for(const t of Object.keys(this.state.insights))(0,c.hasProperty)(e.unapprovedTypedMessages,t)||(0,c.hasProperty)(e.unapprovedPersonalMsgs,t)||a(m,this,k).call(this,t);if(e.unapprovedPersonalMsgCount>0||e.unapprovedTypedMessagesCount>0){const t=a(m,this,h).call(this,o.SnapEndowments.SignatureInsight);for(const s of Object.values(e.unapprovedPersonalMsgs))a(m,this,g).call(this,t,s);for(const s of Object.values(e.unapprovedTypedMessages))a(m,this,g).call(this,t,s)}}function g(e,t){const{id:s,msgParams:n}=t;if(a(m,this,u).call(this,s))return;const{from:i,data:c,signatureMethod:l,origin:d}=n,h={from:i,data:"eth_signTypedData_v3"===l||"eth_signTypedData_v4"===l?JSON.parse(c):c,signatureMethod:l};e.forEach((({snapId:e,permission:t})=>{const n=(0,o.getSignatureOriginCaveat)(t),i=d&&n?d:null;this.update((t=>{var n;(n=t.insights)[s]??(n[s]={}),t.insights[s][e]={snapId:e,loading:!0}})),a(m,this,y).call(this,{snapId:e,handler:r.HandlerType.OnSignature,params:{signature:h,signatureOrigin:i}}).then((t=>a(m,this,w).call(this,{id:s,snapId:e,response:t}))).catch((t=>a(m,this,w).call(this,{id:s,snapId:e,error:t})))}))}function b({transactionMeta:e}){"unapproved"!==e.status&&a(m,this,k).call(this,e.id)}function k(e){a(m,this,u).call(this,e)&&(Object.values(this.state.insights[e]).filter((e=>e.interfaceId)).forEach((e=>{this.messagingSystem.call("SnapInterfaceController:deleteInterface",e.interfaceId)})),this.update((t=>{delete t.insights[e]})))}async function y({snapId:e,handler:t,params:s}){return this.messagingSystem.call("SnapController:handleRequest",{snapId:e,origin:"metamask",handler:t,request:{method:"",params:s}})}function w({id:e,snapId:t,response:s,error:n}){a(m,this,u).call(this,e)&&this.update((a=>{a.insights[e][t].loading=!1,a.insights[e][t].interfaceId=null==s?void 0:s.id,a.insights[e][t].severity=null==s?void 0:s.severity,a.insights[e][t].error=null==n?void 0:n.message}))}s.SnapInsightsController=d}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/index.cjs",{"./SnapInsightsController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/insights/SnapInsightsController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./SnapInsightsController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/insights/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs",{"./utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",immer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/immer/dist/index.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function a(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapInterfaceController=void 0;const i=e("@metamask/base-controller"),o=e("@metamask/snaps-sdk"),r=e("@metamask/snaps-utils"),c=e("@metamask/utils"),l=e("immer"),m=e("nanoid"),d=e("./utils.cjs"),u=1e7,h="SnapInterfaceController";var p=new WeakSet;class f extends i.BaseController{constructor({messenger:e,state:t}){super({messenger:e,metadata:{interfaces:{persist:e=>Object.entries(e).reduce(((e,[t,s])=>s.contentType===o.ContentType.Notification?(e[t]=s,e):e),{}),anonymous:!1}},name:h,state:{interfaces:{},...t}}),n(this,p),this.messagingSystem.subscribe("NotificationServicesController:notificationsListUpdated",a(p,this,T).bind(this)),a(p,this,g).call(this)}async createInterface(e,t,s,n){const i=(0,d.getJsxInterface)(t);await a(p,this,E).call(this,i),(0,d.validateInterfaceContext)(s);const o=(0,m.nanoid)(),c=(0,d.constructState)({},i,{getAssetsState:a(p,this,P).bind(this),getAccountByAddress:a(p,this,x).bind(this),getSelectedAccount:a(p,this,_).bind(this),listAccounts:a(p,this,v).bind(this),snapOwnsAccount:t=>(0,r.snapOwnsAccount)(e,t)});return this.update((t=>{t.interfaces[o]={snapId:e,content:(0,l.castDraft)(i),state:c,context:s??null,contentType:n??null}})),o}getInterface(e,t){return a(p,this,b).call(this,e,t),this.state.interfaces[t]}async updateInterface(e,t,s,n){a(p,this,b).call(this,e,t);const i=(0,d.getJsxInterface)(s);await a(p,this,E).call(this,i),(0,d.validateInterfaceContext)(n);const o=this.state.interfaces[t].state,c=(0,d.constructState)(o,i,{getAssetsState:a(p,this,P).bind(this),getAccountByAddress:a(p,this,x).bind(this),getSelectedAccount:a(p,this,_).bind(this),listAccounts:a(p,this,v).bind(this),snapOwnsAccount:t=>(0,r.snapOwnsAccount)(e,t)});this.update((e=>{e.interfaces[t].state=c,e.interfaces[t].content=(0,l.castDraft)(i),n&&(e.interfaces[t].context=n)}))}deleteInterface(e){this.update((t=>{delete t.interfaces[e]}))}updateInterfaceState(e,t){this.update((s=>{s.interfaces[e].state=t}))}async resolveInterface(e,t,s){a(p,this,b).call(this,e,t),a(p,this,k).call(this,t),await a(p,this,S).call(this,t,s),this.deleteInterface(t)}}function g(){this.messagingSystem.registerActionHandler(`${h}:createInterface`,this.createInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:getInterface`,this.getInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterface`,this.updateInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:deleteInterface`,this.deleteInterface.bind(this)),this.messagingSystem.registerActionHandler(`${h}:updateInterfaceState`,this.updateInterfaceState.bind(this)),this.messagingSystem.registerActionHandler(`${h}:resolveInterface`,this.resolveInterface.bind(this))}function b(e,t){const s=this.state.interfaces[t];(0,c.assert)(s!==undefined,`Interface with id '${t}' not found.`),(0,c.assert)(s.snapId===e,`Interface not created by ${e}.`)}function k(e){(0,c.assert)(a(p,this,w).call(this,e),`Approval request with id '${e}' not found.`)}function y(e){return this.messagingSystem.call("PhishingController:testOrigin",e).result}function w(e){return this.messagingSystem.call("ApprovalController:hasRequest",{id:e})}async function S(e,t){await this.messagingSystem.call("ApprovalController:acceptRequest",e,t)}function _(){return this.messagingSystem.call("AccountsController:getSelectedMultichainAccount")}function v(e){const t=this.messagingSystem.call("AccountsController:listMultichainAccounts");return e&&0!==e.length?t.filter((t=>t.scopes.some((t=>(0,d.isMatchingChainId)(t,e))))):t}function x(e){const{address:t}=(0,c.parseCaipAccountId)(e);return this.messagingSystem.call("AccountsController:getAccountByAddress",t)}function P(){return this.messagingSystem.call("MultichainAssetsController:getState")}function j(e){return this.messagingSystem.call("SnapController:get",e)}async function E(e){const t=(0,r.getJsonSizeUnsafe)(e);(0,c.assert)(t<=u,"A Snap UI may not be larger than 10 MB."),(0,r.validateJsxElements)(e,{isOnPhishingList:a(p,this,y).bind(this),getSnap:a(p,this,j).bind(this),getAccountByAddress:a(p,this,x).bind(this)})}function T(e){const t=e.filter((e=>"snap"===e.type&&(0,c.hasProperty)(e.data,"detailedView"))),s=new Set(t.map((e=>e.data.detailedView.interfaceId)));this.update((e=>{Object.entries(e.interfaces).forEach((([t,n])=>{n.contentType!==o.ContentType.Notification||s.has(t)||delete e.interfaces[t]}))}))}s.SnapInterfaceController=f}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/index.cjs",{"./SnapInterfaceController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/SnapInterfaceController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./SnapInterfaceController.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs",{"@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-sdk/jsx":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/jsx.js","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.validateInterfaceContext=s.constructState=s.getAccountSelectorStateValue=s.getAssetSelectorStateValue=s.getAccountSelectorDefaultStateValue=s.getDefaultAsset=s.formatAccountSelectorStateValue=s.isMatchingChainId=s.assertNameIsUnique=s.getJsxInterface=s.isStatefulComponent=void 0;const n=e("@metamask/snaps-sdk"),a=e("@metamask/snaps-sdk/jsx"),i=e("@metamask/snaps-utils"),o=e("@metamask/utils"),r=["Input","Dropdown","RadioGroup","FileInput","Checkbox","Selector","AssetSelector","AddressInput","AccountSelector"];function c(e){return r.includes(e.type)}function l(e,t){(0,n.assert)(e[t]===undefined,`Duplicate component names are not allowed, found multiple instances of: "${t}".`)}function m(e,t){return"eip155:0"===e?t.some((e=>{const{namespace:t}=(0,o.parseCaipChainId)(e);return t===o.KnownCaipNamespace.Eip155})):t.includes(e)}function d(e,t){const{id:s,address:n,scopes:a}=e,o=(0,i.createChainIdList)(a,t);return{accountId:s,addresses:(0,i.createAccountList)(n,o)}}function u(e,t,{getAccountByAddress:s,getAssetsState:a}){var i;const{assetsMetadata:r,accountsAssets:c}=a(),l=e.map((e=>(0,o.parseCaipAccountId)(e))).map((({chainId:e})=>e)),m=t&&t.length>0?l.filter((e=>t.includes(e))):l,d=null===(i=s(e[0]))||void 0===i?void 0:i.id;(0,n.assert)(d,`Account not found for address: ${e[0]}.`);const u=c[d];if(0===u.length)return null;const h=u.find((e=>{const{chainId:t,assetNamespace:s}=(0,o.parseCaipAssetType)(e);return m.includes(t)&&"slip44"===s}));return h?{asset:h,name:r[h].name,symbol:r[h].symbol}:{asset:u[0],name:r[u[0]].name,symbol:r[u[0]].symbol}}function h(e,{getSelectedAccount:t,listAccounts:s,snapOwnsAccount:n}){const{chainIds:a,hideExternalAccounts:i}=e.props,o=t();if((!a||0===a.length||o.scopes.some((e=>m(e,a))))&&(!i||i&&n(o)))return d(o,a);const r=s(a),c=i?r.filter((e=>n(e))):r;return 0===c.length?null:d(c[0],a)}function p(e,t){if(!e)return null;const{assetsMetadata:s}=t(),n=s[e];return n?{asset:e,name:n.name??n.symbol??"Unknown",symbol:n.symbol??"Unknown"}:null}function f(e,{getAccountByAddress:t,snapOwnsAccount:s}){const{value:n,hideExternalAccounts:a}=e.props;if(!n)return null;const i=t(n);return i?a&&!s(i)?null:d(i,e.props.chainIds):null}function g(e,t,s,n){const a=n?e[n]:e,r=null==a?void 0:a[t.props.name];return"FileInput"===t.type?r??null:function(e,t){switch(e.type){case"Checkbox":return e.props.checked;case"AssetSelector":return p(e.props.value,t.getAssetsState);case"AddressInput":{if(!e.props.value)return null;const{namespace:t,reference:s}=(0,o.parseCaipChainId)(e.props.chainId);return(0,o.toCaipAccountId)(t,s,e.props.value)}case"AccountSelector":return f(e,t);default:return e.props.value}}(t,s)??r??function(e,t){switch(e.type){case"Dropdown":var s;return null===(s=(0,i.getJsxChildren)(e)[0])||void 0===s?void 0:s.props.value;case"RadioGroup":var n;return null===(n=(0,i.getJsxChildren)(e)[0])||void 0===n?void 0:n.props.value;case"Selector":var a;return null===(a=(0,i.getJsxChildren)(e)[0])||void 0===a?void 0:a.props.value;case"AccountSelector":return h(e,t);case"Checkbox":return!1;case"AssetSelector":return u(e.props.addresses,e.props.chainIds,t);default:return null}}(t,s)??null}s.isStatefulComponent=c,s.getJsxInterface=function(e){return(0,a.isJSXElementUnsafe)(e)?e:(0,i.getJsxElementFromComponent)(e)},s.assertNameIsUnique=l,s.isMatchingChainId=m,s.formatAccountSelectorStateValue=d,s.getDefaultAsset=u,s.getAccountSelectorDefaultStateValue=h,s.getAssetSelectorStateValue=p,s.getAccountSelectorStateValue=f,s.constructState=function(e,t,s){const n={},a=[];return(0,i.walkJsx)(t,((t,i)=>{let o=a[a.length-1];if(o&&i<=o.depth&&(a.pop(),o=a[a.length-1]),"Form"===t.type)return l(n,t.props.name),a.push({name:t.props.name,depth:i}),void(n[t.props.name]={});if(o&&c(t)){const a=n[o.name];return l(a,t.props.name),void(a[t.props.name]=g(e,t,s,o.name))}c(t)&&(l(n,t.props.name),n[t.props.name]=g(e,t,s))})),n};const b=5e6;s.validateInterfaceContext=function(e){if(!e)return;const t=(0,i.getJsonSizeUnsafe)(e);(0,n.assert)(t<=b,"A Snap interface context may not be larger than 5 MB.")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/interface/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.log=void 0;const n=e("@metamask/snaps-utils"),a=e("@metamask/utils");s.log=(0,a.createModuleLogger)(n.snapsLogger,"snaps-controllers")}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/logging.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function o(e,t){return e.get(c(e,t))}function r(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.MultichainRouter=void 0;const l=e("@metamask/rpc-errors"),m=e("@metamask/snaps-rpc-methods"),d=e("@metamask/snaps-utils"),u=e("@metamask/utils"),h=e("nanoid"),p=e("../snaps/index.cjs"),f="MultichainRouter";var g=new WeakMap,b=new WeakMap,k=new WeakSet;async function y(e,t,s){try{const n=await o(b,this).call(this,(async({keyring:n})=>n.resolveAccountAddress(e,t,s))),a=null==n?void 0:n.address;return a?(0,u.parseCaipAccountId)(a).address:null}catch{throw l.rpcErrors.internal()}}async function w(e,t,s){const n=o(g,this).call("AccountsController:listMultichainAccounts",t).filter((e=>{var t;return Boolean(null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled)&&e.methods.includes(s.method)}));if(0===n.length)return null;const a=n[0].metadata.snap.id,i=await c(k,this,y).call(this,a,t,s),r=e.map((e=>(0,u.parseCaipAccountId)(e).address)),m=n.find((e=>r.includes(e.address)&&(!i||e.address===i)));if(!m)throw l.rpcErrors.invalidParams({message:"No available account found for request."});return m.id}function S(e){const t=o(g,this).call("SnapController:getAll");return(0,p.getRunnableSnaps)(t).reduce(((t,s)=>{const n=o(g,this).call("PermissionController:getPermissions",s.id);if(n&&(0,u.hasProperty)(n,m.SnapEndowments.Protocol)){const a=n[m.SnapEndowments.Protocol],i=(0,m.getProtocolCaveatScopes)(a);i&&(0,u.hasProperty)(i,e)&&t.push({snapId:s.id,methods:i[e].methods})}return t}),[])}function _(e){return o(g,this).call("AccountsController:listMultichainAccounts",e).filter((e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled}))}s.MultichainRouter=class{constructor({messenger:e,withSnapKeyring:t}){var s,c;a(s=this,c=k),c.add(s),i(this,"name",f),i(this,"state",null),n(this,g,void 0),n(this,b,void 0),r(g,this,e),r(b,this,t),o(g,this).registerActionHandler(`${f}:handleRequest`,(async(...e)=>this.handleRequest(...e))),o(g,this).registerActionHandler(`${f}:getSupportedMethods`,((...e)=>this.getSupportedMethods(...e))),o(g,this).registerActionHandler(`${f}:getSupportedAccounts`,((...e)=>this.getSupportedAccounts(...e))),o(g,this).registerActionHandler(`${f}:isSupportedScope`,((...e)=>this.isSupportedScope(...e)))}async handleRequest({connectedAddresses:e,origin:t,scope:s,request:n}){(0,u.assert)(!s.startsWith(u.KnownCaipNamespace.Eip155)&&!s.startsWith("wallet:eip155"));const a={jsonrpc:"2.0",id:n.id??(0,h.nanoid)(),method:n.method,...n.params?{params:n.params}:{}},{method:i,params:r}=a,m=await c(k,this,w).call(this,e,s,a);if(m)return o(b,this).call(this,(async({keyring:e})=>e.submitRequest({origin:t,account:m,scope:s,method:i,params:r})));const p=c(k,this,S).call(this,s).find((e=>e.methods.includes(i)));if(p)return o(g,this).call("SnapController:handleRequest",{snapId:p.snapId,origin:t,request:{method:"",params:{request:a,scope:s}},handler:d.HandlerType.OnProtocolRequest});throw l.rpcErrors.methodNotFound()}getSupportedMethods(e){const t=c(k,this,_).call(this,e).flatMap((e=>e.methods)),s=c(k,this,S).call(this,e).flatMap((e=>e.methods));return Array.from(new Set([...t,...s]))}getSupportedAccounts(e){return c(k,this,_).call(this,e).map((t=>`${e}:${t.address}`))}isSupportedScope(e){return o(g,this).call("AccountsController:listMultichainAccounts",e).some((e=>{var t;return null===(t=e.metadata.snap)||void 0===t?void 0:t.enabled}))||c(k,this,S).call(this,e).length>0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs",{"./MultichainRouter.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/multichain/MultichainRouter.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./MultichainRouter.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/multichain/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs",{"../logging.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs","../snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/json-rpc-middleware-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-middleware-stream/dist/index.cjs","@metamask/object-multiplex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/object-multiplex/dist/index.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function o(e,t){return e.get(c(e,t))}function r(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var l=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.setupMultiplex=s.AbstractExecutionService=void 0;const m=e("@metamask/json-rpc-engine"),d=e("@metamask/json-rpc-middleware-stream"),u=l(e("@metamask/object-multiplex")),h=e("@metamask/rpc-errors"),p=e("@metamask/snaps-utils"),f=e("@metamask/utils"),g=e("nanoid"),b=e("readable-stream"),k=e("../logging.cjs"),y=e("../snaps/Timer.cjs"),w=e("../utils.cjs"),S="ExecutionService";var _=new WeakMap,v=new WeakMap,x=new WeakMap,P=new WeakMap,j=new WeakMap,E=new WeakMap,T=new WeakMap,C=new WeakMap,I=new WeakSet;function O(){o(P,this).registerActionHandler(`${S}:handleRpcRequest`,(async(e,t)=>this.handleRpcRequest(e,t))),o(P,this).registerActionHandler(`${S}:executeSnap`,(async e=>this.executeSnap(e))),o(P,this).registerActionHandler(`${S}:terminateSnap`,(async e=>this.terminateSnap(e))),o(P,this).registerActionHandler(`${S}:terminateAllSnaps`,(async()=>this.terminateAllSnaps()))}async function A(e,t){const{streams:s,worker:n}=await c(I,this,M).call(this,e,t),a=new m.JsonRpcEngine,i=(0,d.createStreamMiddleware)();(0,b.pipeline)(i.stream,s.command,i.stream,(e=>{e&&(0,p.logError)("Command stream failure.",e)})),a.push(i.middleware);const r={id:e,streams:s,rpcEngine:a,worker:n};return o(_,this).set(e,r),r}async function M(e,t){const s=await(0,w.withTimeout)(this.initEnvStream(e),t);if(s===w.hasTimedOut){this.terminateJob({id:e});if("created"===o(v,this).get(e))throw new Error(`The executor for "${e}" couldn't start initialization. The offscreen document may not exist.`);throw new Error(`The executor for "${e}" failed to initialize. The iframe/webview/worker failed to load.`)}const{worker:n,stream:a}=s,i=N(a,`Snap: "${e}"`),r=i.createStream(p.SNAP_STREAM_NAMES.COMMAND),c=t=>{(0,f.hasProperty)(t,"id")||("OutboundRequest"===t.method?o(P,this).publish("ExecutionService:outboundRequest",e):"OutboundResponse"===t.method?o(P,this).publish("ExecutionService:outboundResponse",e):"UnhandledError"===t.method?(o(P,this).publish("ExecutionService:unhandledError",e,t.params.error),r.removeListener("data",c)):(0,p.logError)(new Error(`Received unexpected command stream notification "${t.method}".`)))};r.on("data",c);const l=i.createStream(p.SNAP_STREAM_NAMES.JSON_RPC);return{streams:{command:r,rpc:l,_connection:a},worker:n}}async function R(e,t){const s=o(_,this).get(e);if(!s)throw new Error(`"${e}" is not currently running.`);(0,k.log)("Parent: Sending Command",t);const n=await s.rpcEngine.handle(t);if((0,f.isJsonRpcFailure)(n))throw new h.JsonRpcError(n.error.code,n.error.message,n.error.data);return n.result}function N(e,t){const s=new u.default;return(0,b.pipeline)(e,s,e,(e=>{e&&(0,p.logError)(`"${t}" stream failure.`,e)})),s}s.AbstractExecutionService=class{constructor({setupSnapProvider:e,messenger:t,initTimeout:s=(0,f.inMilliseconds)(60,f.Duration.Second),pingTimeout:o=(0,f.inMilliseconds)(2,f.Duration.Second),terminationTimeout:l=(0,f.inMilliseconds)(1,f.Duration.Second),usePing:m=!0}){var d,u;a(d=this,u=I),u.add(d),i(this,"name",S),i(this,"state",null),n(this,_,void 0),n(this,v,void 0),n(this,x,void 0),n(this,P,void 0),n(this,j,void 0),n(this,E,void 0),n(this,T,void 0),n(this,C,void 0),r(_,this,new Map),r(v,this,new Map),r(x,this,e),r(P,this,t),r(j,this,s),r(E,this,o),r(T,this,l),r(C,this,m),c(I,this,O).call(this)}async terminateSnap(e){const t=o(_,this).get(e);if(!t)throw new Error(`"${e}" is not currently running.`);try{const t=await(0,w.withTimeout)(c(I,this,R).call(this,e,{jsonrpc:"2.0",method:"terminate",params:[],id:(0,g.nanoid)()}),o(T,this));t!==w.hasTimedOut&&"OK"===t||(0,p.logError)(`Snap "${e}" failed to terminate gracefully.`,t)}catch{}Object.values(t.streams).forEach((e=>{try{!e.destroyed&&e.destroy(),e.removeAllListeners()}catch(e){(0,p.logError)("Error while destroying stream",e)}})),this.terminateJob(t),o(_,this).delete(e),o(v,this).delete(e),(0,k.log)(`Snap "${e}" terminated.`)}setSnapStatus(e,t){o(v,this).set(e,t)}async terminateAllSnaps(){await Promise.all([...o(_,this).keys()].map((async e=>this.terminateSnap(e))))}async executeSnap({snapId:e,sourceCode:t,endowments:s}){if(o(_,this).has(e))throw new Error(`"${e}" is already running.`);this.setSnapStatus(e,"created");const n=new y.Timer(o(j,this)),a=await c(I,this,A).call(this,e,n);if(o(C,this)){if(await(0,w.withTimeout)(c(I,this,R).call(this,a.id,{jsonrpc:"2.0",method:"ping",id:(0,g.nanoid)()}),o(E,this))===w.hasTimedOut)throw new Error(`The executor for "${e}" was unreachable. The executor did not respond in time.`)}const i=a.streams.rpc;o(x,this).call(this,e,i);const r=Math.max(n.remaining,o(j,this)/2);this.setSnapStatus(e,"initialized");const l={jsonrpc:"2.0",method:"executeSnap",params:{snapId:e,sourceCode:t,endowments:s},id:(0,g.nanoid)()};(0,f.assertIsJsonRpcRequest)(l),this.setSnapStatus(e,"executing");const m=await(0,w.withTimeout)(c(I,this,R).call(this,a.id,l),r);if(m===w.hasTimedOut)throw new Error(`${e} failed to start.`);return"OK"===m&&this.setSnapStatus(e,"running"),m}async handleRpcRequest(e,t){const{handler:s,request:n,origin:a}=t;return await c(I,this,R).call(this,e,{id:(0,g.nanoid)(),jsonrpc:"2.0",method:"snapRpc",params:{origin:a,handler:s,request:n,target:e}})}},s.setupMultiplex=N}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs",{"@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t){return e.get(r(e,t))}function o(e,t,s){return e.set(r(e,t),s),s}function r(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.ProxyPostMessageStream=void 0;const c=e("@metamask/post-message-stream");var l=new WeakMap,m=new WeakMap,d=new WeakSet;class u extends c.BasePostMessageStream{constructor({stream:e,jobId:t}){var s,c;super(),a(s=this,c=d),c.add(s),n(this,l,void 0),n(this,m,void 0),o(l,this,e),o(m,this,t),i(l,this).on("data",r(d,this,h).bind(this))}_postMessage(e){i(l,this).write({jobId:i(m,this),data:e})}}function h(e){e.jobId===i(m,this)&&this.push(e.data)}s.ProxyPostMessageStream=u}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs",{"../AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.IframeExecutionService=void 0;const a=e("@metamask/post-message-stream"),i=e("@metamask/snaps-utils"),o=e("../AbstractExecutionService.cjs");class r extends o.AbstractExecutionService{constructor({iframeUrl:e,messenger:t,setupSnapProvider:s,...a}){super({...a,messenger:t,setupSnapProvider:s}),n(this,"iframeUrl",void 0),this.iframeUrl=e}terminateJob(e){var t;null===(t=document.getElementById(e.id))||void 0===t||t.remove()}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=await(0,i.createWindow)({uri:this.iframeUrl.toString(),id:e});return{worker:t,stream:new a.WindowPostMessageStream({name:"parent",target:"child",targetWindow:t,targetOrigin:"*"})}}}s.IframeExecutionService=r}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs",{"./IframeExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/IframeExecutionService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./IframeExecutionService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/index.cjs",{"./AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","./ProxyPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs","./iframe/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/iframe/index.cjs","./offscreen/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./AbstractExecutionService.cjs"),s),a(e("./ProxyPostMessageStream.cjs"),s),a(e("./iframe/index.cjs"),s),a(e("./offscreen/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs",{"../proxy/ProxyExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs","@metamask/post-message-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/post-message-stream/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function a(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.OffscreenExecutionService=void 0;const i=e("@metamask/post-message-stream"),o=e("../proxy/ProxyExecutionService.cjs");var r=new WeakMap;class c extends o.ProxyExecutionService{constructor({messenger:e,setupSnapProvider:t,offscreenPromise:s,...o}){var c,l,m;super({...o,messenger:e,setupSnapProvider:t,stream:new i.BrowserRuntimePostMessageStream({name:"parent",target:"child"})}),n(this,r,void 0),l=this,m=s,(c=r).set(a(c,l),m)}async initEnvStream(e){var t,s;return await(t=r,s=this,t.get(a(t,s))),await super.initEnvStream(e)}}s.OffscreenExecutionService=c}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs",{"./OffscreenExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/offscreen/OffscreenExecutionService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./OffscreenExecutionService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/offscreen/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs",{"../AbstractExecutionService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/AbstractExecutionService.cjs","../ProxyPostMessageStream.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/services/ProxyPostMessageStream.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function a(e,t){return e.get(i(e,t))}function i(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.ProxyExecutionService=void 0;const o=e("nanoid"),r=e("../AbstractExecutionService.cjs"),c=e("../ProxyPostMessageStream.cjs");var l=new WeakMap;class m extends r.AbstractExecutionService{constructor({stream:e,messenger:t,setupSnapProvider:s,...a}){var o,r,c;super({...a,messenger:t,setupSnapProvider:s,usePing:!1}),n(this,l,void 0),r=this,c=e,(o=l).set(i(o,r),c)}async terminateJob(e){a(l,this).write({jobId:e.id,data:{jsonrpc:"2.0",method:"terminateJob",id:(0,o.nanoid)()}})}async initEnvStream(e){this.setSnapStatus(e,"initializing");const t=new c.ProxyPostMessageStream({stream:a(l,this),jobId:e});return await new Promise((e=>{t.once("data",e),t.write({name:"command",data:{jsonrpc:"2.0",method:"ping",id:(0,o.nanoid)()}})})),{worker:e,stream:t}}}s.ProxyExecutionService=m}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/services/proxy/ProxyExecutionService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs",{"../fsm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/fsm.cjs","../logging.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/logging.cjs","../utils.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs","./Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./location/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs","./registry/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/permission-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/permission-controller/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@xstate/fsm":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@xstate/fsm/lib/index.js","async-mutex":"/home/runner/work/metamask-extension/metamask-extension/node_modules/async-mutex/lib/index.js",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs",semver:"/home/runner/work/metamask-extension/metamask-extension/node_modules/semver/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function a(e,t,s){i(e,t),t.set(e,s)}function i(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function o(e,t){return e.get(c(e,t))}function r(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.SnapController=s.SNAP_APPROVAL_RESULT=s.SNAP_APPROVAL_UPDATE=s.SNAP_APPROVAL_INSTALL=s.controllerName=void 0;const l=e("@metamask/base-controller"),m=e("@metamask/permission-controller"),d=e("@metamask/rpc-errors"),u=e("@metamask/snaps-rpc-methods"),h=e("@metamask/snaps-sdk"),p=e("@metamask/snaps-utils"),f=e("@metamask/utils"),g=e("@xstate/fsm"),b=e("async-mutex"),k=e("nanoid"),y=e("semver"),w=e("./constants.cjs"),S=e("./location/index.cjs"),_=e("./registry/index.cjs"),v=e("./selectors.cjs"),x=e("./Timer.cjs"),P=e("../fsm.cjs"),j=e("../logging.cjs"),E=e("../utils.cjs");s.controllerName="SnapController",s.SNAP_APPROVAL_INSTALL="wallet_installSnap",s.SNAP_APPROVAL_UPDATE="wallet_updateSnap",s.SNAP_APPROVAL_RESULT="wallet_installSnapResult";const T=new Set(["initialPermissions","id","version","enabled","blocked"]),C={snaps:{},snapStates:{},unencryptedSnapStates:{}};function I(e){return Object.keys(e).reduce(((t,s)=>(T.has(s)&&(t[s]=e[s]),t)),{})}var O=new WeakMap,A=new WeakMap,M=new WeakMap,R=new WeakMap,N=new WeakMap,$=new WeakMap,B=new WeakMap,L=new WeakMap,D=new WeakMap,F=new WeakMap,H=new WeakMap,U=new WeakMap,q=new WeakMap,V=new WeakMap,W=new WeakMap,K=new WeakMap,G=new WeakMap,z=new WeakMap,J=new WeakMap,Y=new WeakMap,Q=new WeakSet,Z=new WeakMap;class X extends l.BaseController{constructor({closeAllConnections:e,messenger:t,state:l,dynamicPermissions:m=["eth_accounts"],environmentEndowmentPermissions:d=[],excludedPermissions:u={},idleTimeCheckInterval:g=(0,f.inMilliseconds)(5,f.Duration.Second),maxIdleTime:b=(0,f.inMilliseconds)(30,f.Duration.Second),maxRequestTime:k=(0,f.inMilliseconds)(60,f.Duration.Second),fetchFunction:y=globalThis.fetch.bind(undefined),featureFlags:_={},detectSnapLocation:v=S.detectSnapLocation,preinstalledSnaps:x=null,encryptor:P,getMnemonicSeed:j,getFeatureFlags:T=(()=>({})),clientCryptography:I,trackEvent:X}){var ae,ie,oe;super({messenger:t,metadata:{snapStates:{persist:!0,anonymous:!1},unencryptedSnapStates:{persist:!0,anonymous:!1},snaps:{persist:e=>Object.values(e).filter((e=>e.status!==p.SnapStatus.Installing)).map((e=>({...e,status:p.SnapStatus.Stopped}))).reduce(((e,t)=>(e[t.id]=t,e)),{}),anonymous:!1}},name:s.controllerName,state:{...C,...l}}),i(ie=this,oe=Q),oe.add(ie),a(this,O,void 0),a(this,A,void 0),a(this,M,void 0),a(this,R,void 0),a(this,N,void 0),a(this,$,void 0),a(this,B,void 0),a(this,L,void 0),n(this,"maxRequestTime",void 0),a(this,D,void 0),a(this,F,void 0),a(this,H,void 0),a(this,U,void 0),a(this,q,void 0),a(this,V,void 0),a(this,W,void 0),a(this,K,void 0),a(this,G,void 0),a(this,z,void 0),a(this,J,void 0),a(this,Y,void 0),a(this,Z,(0,E.debouncePersistState)(((e,t,s)=>{c(Q,this,Ke).call(this,e).stateMutex.runExclusive((async()=>{const n=await c(Q,this,ge).call(this,e,t,s);return s?this.update((t=>{t.snapStates[e]=n})):this.update((t=>{t.unencryptedSnapStates[e]=n}))})).catch(p.logError)}),w.STATE_DEBOUNCE_TIMEOUT)),r(O,this,e),r(A,this,m),r(M,this,d),r(R,this,u),r(N,this,_),r($,this,y),r(B,this,g),r(L,this,b),this.maxRequestTime=k,r(q,this,v),r(D,this,P),r(F,this,j),r(H,this,T),r(U,this,I),r(z,this,x),this._onUnhandledSnapError=this._onUnhandledSnapError.bind(this),this._onOutboundRequest=this._onOutboundRequest.bind(this),this._onOutboundResponse=this._onOutboundResponse.bind(this),r(W,this,new Map),r(V,this,new Map),r(J,this,X),c(Q,this,ne).call(this),this.messagingSystem.subscribe("ExecutionService:unhandledError",this._onUnhandledSnapError),this.messagingSystem.subscribe("ExecutionService:outboundRequest",this._onOutboundRequest),this.messagingSystem.subscribe("ExecutionService:outboundResponse",this._onOutboundResponse),this.messagingSystem.subscribe("SnapController:snapInstalled",(({id:e},t)=>{c(Q,this,tt).call(this,t,e,p.HandlerType.OnInstall).catch((t=>{(0,p.logError)(`Error when calling \`onInstall\` lifecycle hook for snap "${e}": ${(0,h.getErrorMessage)(t)}`)}))})),this.messagingSystem.subscribe("SnapController:snapUpdated",(({id:e},t,s)=>{c(Q,this,tt).call(this,s,e,p.HandlerType.OnUpdate).catch((t=>{(0,p.logError)(`Error when calling \`onUpdate\` lifecycle hook for snap "${e}": ${(0,h.getErrorMessage)(t)}`)}))})),this.messagingSystem.subscribe("KeyringController:lock",c(Q,this,st).bind(this)),c(Q,this,ee).call(this),c(Q,this,te).call(this),Object.values((null===(ae=this.state)||void 0===ae?void 0:ae.snaps)??{}).forEach((e=>c(Q,this,Ge).call(this,e.id))),o(z,this)&&c(Q,this,se).call(this,o(z,this)),r(Y,this,(0,E.throttleTracking)(((e,t,s,n)=>{const a=this.messagingSystem.call("SnapsRegistry:getMetadata",e);o(J,this).call(this,{event:"Snap Export Used",category:"Snaps",properties:{snap_id:e,export:t,snap_category:null==a?void 0:a.category,success:s,origin:n}})})))}init(){c(Q,this,et).call(this,w.METAMASK_ORIGIN,p.HandlerType.OnStart)}async updateBlockedSnaps(){c(Q,this,ce).call(this),await this.messagingSystem.call("SnapsRegistry:update");const e=await this.messagingSystem.call("SnapsRegistry:get",Object.values(this.state.snaps).reduce(((e,t)=>(e[t.id]={version:t.version,checksum:t.manifest.source.shasum},e)),{}));await Promise.all(Object.entries(e).map((async([e,{status:t,reason:s}])=>t===_.SnapsRegistryStatus.Blocked?c(Q,this,ae).call(this,e,s):c(Q,this,ie).call(this,e))))}_onUnhandledSnapError(e,t){(0,p.logError)(`Unhandled error from "${e}":`,t),this.stopSnap(e,p.SnapStatusEvents.Crash).catch((e=>{(0,p.logError)(e)}))}_onOutboundRequest(e){const t=c(Q,this,Ke).call(this,e);t.pendingInboundRequests.filter((e=>"running"===e.timer.status)).forEach((e=>e.timer.pause())),t.pendingOutboundRequests+=1}_onOutboundResponse(e){const t=c(Q,this,Ke).call(this,e);t.pendingOutboundRequests-=1,0===t.pendingOutboundRequests&&t.pendingInboundRequests.filter((e=>"paused"===e.timer.status)).forEach((e=>e.timer.resume()))}async startSnap(e){c(Q,this,ce).call(this);const t=this.state.snaps[e];if(!t.enabled)throw new Error(`Snap "${e}" is disabled.`);await c(Q,this,Pe).call(this,{snapId:e,sourceCode:t.sourceCode})}enableSnap(e){if(this.getExpect(e),this.state.snaps[e].blocked)throw new Error(`Snap "${e}" is blocked and cannot be enabled.`);this.update((t=>{t.snaps[e].enabled=!0})),this.messagingSystem.publish("SnapController:snapEnabled",this.getTruncatedExpect(e))}async disableSnap(e){if(!this.has(e))throw new Error(`Snap "${e}" not found.`);this.update((t=>{t.snaps[e].enabled=!1})),this.isRunning(e)&&await this.stopSnap(e,p.SnapStatusEvents.Stop),this.messagingSystem.publish("SnapController:snapDisabled",this.getTruncatedExpect(e))}async stopSnap(e,t=p.SnapStatusEvents.Stop){const s=c(Q,this,We).call(this,e);if(!s)throw new Error(`The snap "${e}" is not running.`);if(s.stopPromise)return void await s.stopPromise;const{promise:n,resolve:a}=(0,f.createDeferredPromise)();s.stopPromise=n;try{var i;if(this.isRunning(e))null===(i=o(O,this))||void 0===i||i.call(this,e),await c(Q,this,de).call(this,e)}finally{s.lastRequest=null,s.pendingInboundRequests=[],s.pendingOutboundRequests=0,s.stopPromise=null,this.isRunning(e)&&c(Q,this,me).call(this,e,t),a()}}async stopAllSnaps(e=p.SnapStatusEvents.Stop){const t=Object.values(this.state.snaps).filter((e=>this.isRunning(e.id))).map((async t=>this.stopSnap(t.id,e)));await Promise.allSettled(t)}isRunning(e){return"running"===this.getExpect(e).status}has(e){return Boolean(this.get(e))}get(e){return this.state.snaps[e]}getExpect(e){const t=this.get(e);return(0,f.assert)(t!==undefined,new Error(`Snap "${e}" not found.`)),t}getTruncated(e){const t=this.get(e);return t?I(t):null}getTruncatedExpect(e){return I(this.getExpect(e))}async updateSnapState(e,t,s){const n=c(Q,this,Ke).call(this,e);s?n.state=t:n.unencryptedState=t,o(Z,this).call(this,e,t,s)}clearSnapState(e,t){const s=c(Q,this,Ke).call(this,e);t?s.state=null:s.unencryptedState=null,o(Z,this).call(this,e,null,t)}async getSnapState(e,t){const s=c(Q,this,Ke).call(this,e);return await s.getStateMutex.runExclusive((async()=>{const n=t?s.state:s.unencryptedState;if(n!==undefined)return n;const a=t?this.state.snapStates[e]:this.state.unencryptedSnapStates[e];if(null===a||a===undefined)return null;if(!t){const e=JSON.parse(a);return s.unencryptedState=e,e}const i=await c(Q,this,pe).call(this,e,a);return s.state=i,i}))}async getSnapFile(e,t,s=h.AuxiliaryFileEncoding.Base64){var n;const a=this.getExpect(e),i=(0,p.normalizeRelative)(t),o=null===(n=a.auxiliaryFiles)||void 0===n||null===(n=n.find((e=>e.path===i)))||void 0===n?void 0:n.value;if(!o)return null;const r=await(0,p.encodeAuxiliaryFile)(o,s);return(0,f.assert)(r.length<p.MAX_FILE_SIZE,`Failed to encode static file to "${s}": Static files must be less than 64 MB when encoded.`),r}isMinimumPlatformVersion(e,t){const s=this.getExpect(e),{platformVersion:n}=s.manifest;return!!n&&(0,y.gte)(n,t)}async clearState(){const e=Object.keys(this.state.snaps);o(O,this)&&e.forEach((e=>{var t;null===(t=o(O,this))||void 0===t||t.call(this,e)})),await this.messagingSystem.call("ExecutionService:terminateAllSnaps"),e.forEach((e=>c(Q,this,we).call(this,e))),this.update((e=>{e.snaps={},e.snapStates={},e.unencryptedSnapStates={}})),o(V,this).clear(),o(W,this).clear(),o(z,this)&&c(Q,this,se).call(this,o(z,this))}async removeSnap(e){return this.removeSnaps([e])}async removeSnaps(e){if(!Array.isArray(e))throw new Error("Expected array of snap ids.");e.forEach((e=>{const t=this.getExpect(e);(0,f.assert)(!1!==t.removable,`${e} is not removable.`)})),await Promise.all(e.map((async e=>{const t=this.getExpect(e),s=this.getTruncatedExpect(e);await this.disableSnap(e),c(Q,this,we).call(this,e),c(Q,this,ye).call(this,e),o(V,this).delete(e),this.update((t=>{delete t.snaps[e],delete t.snapStates[e],delete t.unencryptedSnapStates[e]})),t.status!==p.SnapStatus.Installing&&this.messagingSystem.publish("SnapController:snapUninstalled",s)})))}removeSnapFromSubject(e,t){var s,n;const a=this.messagingSystem.call("PermissionController:getPermissions",e),i=null==a||null===(s=a[u.WALLET_SNAP_PERMISSION_KEY])||void 0===s||null===(s=s.caveats)||void 0===s?void 0:s.find((e=>e.type===p.SnapCaveatType.SnapIds));if(!i)return;if(Boolean(null===(n=i.value)||void 0===n?void 0:n[t])){const s={...i.value};delete s[t],Object.keys(s).length>0?this.messagingSystem.call("PermissionController:updateCaveat",e,u.WALLET_SNAP_PERMISSION_KEY,p.SnapCaveatType.SnapIds,s):this.messagingSystem.call("PermissionController:revokePermissions",{[e]:[u.WALLET_SNAP_PERMISSION_KEY]})}}revokeDynamicSnapPermissions(e,t){(0,f.assert)(t.every((e=>o(A,this).includes(e))),"Non-dynamic permissions cannot be revoked"),this.messagingSystem.call("PermissionController:revokePermissions",{[e]:t})}incrementActiveReferences(e){c(Q,this,Ke).call(this,e).activeReferences+=1}decrementActiveReferences(e){const t=c(Q,this,Ke).call(this,e);(0,f.assert)(t.activeReferences>0,"SnapController reference management is in an invalid state."),t.activeReferences-=1}getAllSnaps(){return Object.values(this.state.snaps).map(I)}getRunnableSnaps(){return(0,v.getRunnableSnaps)(this.getAllSnaps())}getPermittedSnaps(e){var t;const s=(null===(t=(this.messagingSystem.call("PermissionController:getPermissions",e)??{})[u.WALLET_SNAP_PERMISSION_KEY])||void 0===t||null===(t=t.caveats)||void 0===t||null===(t=t.find((e=>e.type===p.SnapCaveatType.SnapIds)))||void 0===t?void 0:t.value)??{};return Object.keys(s).reduce(((e,t)=>{const s=this.get(t),n=this.getTruncated(t);return n&&(null==s?void 0:s.status)!==p.SnapStatus.Installing&&(e[t]=n),e}),{})}async installSnaps(e,t){c(Q,this,ce).call(this);const s={},n=Object.keys(t),a=[],i=[];try{for(const[n,{version:r}]of Object.entries(t)){(0,p.assertIsValidSnapId)(n);const[t,l]=(0,p.resolveVersionRange)(r);if(t)throw d.rpcErrors.invalidParams(`The "version" field must be a valid SemVer version range if specified. Received: "${r}".`);const m=o(q,this).call(this,n,{versionRange:l,fetch:o($,this),allowLocal:o(N,this).allowLocalSnaps,resolveVersion:async e=>o(N,this).requireAllowlist?await c(Q,this,ve).call(this,n,e):e}),u=this.has(n)&&!m.shouldAlwaysReload;if(u&&c(Q,this,Xe).call(this,n,l)){const e=this.getExpect(n);a.push({snapId:n,oldVersion:e.version});let t=c(Q,this,He).call(this,n);if(t!==undefined)throw new Error("This snap is already being updated.");t=c(Q,this,Ue).call(this,n),t.newVersion=l}else u||i.push(n);s[n]=await this.processRequestedSnap(e,n,m,l)}i.forEach((t=>this.messagingSystem.publish("SnapController:snapInstalled",this.getTruncatedExpect(t),e,!1))),a.forEach((({snapId:t,oldVersion:s})=>this.messagingSystem.publish("SnapController:snapUpdated",this.getTruncatedExpect(t),s,e,!1))),n.forEach((e=>o(W,this).delete(e)))}catch(e){const t=i.filter((e=>this.has(e)));await this.removeSnaps(t);const s=[...o(W,this).keys()],n=a.map((({snapId:e})=>e)).filter((e=>s.includes(e)));throw await c(Q,this,Ve).call(this,n),e}return s}async processRequestedSnap(e,t,n,a){const i=this.getTruncated(t);if(i&&!n.shouldAlwaysReload)return(0,f.satisfiesVersionRange)(i.version,a)?i:await this.updateSnap(e,t,n,a,!1);c(Q,this,re).call(this);let o=c(Q,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_INSTALL});this.messagingSystem.publish("SnapController:snapInstallStarted",t,e,!1),i&&this.isRunning(t)&&await this.stopSnap(t,p.SnapStatusEvents.Stop),i&&n.shouldAlwaysReload&&c(Q,this,we).call(this,t);try{const{sourceCode:i}=await c(Q,this,xe).call(this,{origin:e,id:t,location:n,versionRange:a});await this.authorize(t,o),o=c(Q,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_RESULT}),await c(Q,this,Pe).call(this,{snapId:t,sourceCode:i});const r=this.getTruncatedExpect(t);return c(Q,this,_e).call(this,o.id,{loading:!1,type:s.SNAP_APPROVAL_INSTALL}),r}catch(n){(0,p.logError)(`Error when adding ${t}.`,n);const a=n instanceof Error?n.message:n.toString();throw c(Q,this,_e).call(this,o.id,{loading:!1,type:s.SNAP_APPROVAL_INSTALL,error:a}),this.messagingSystem.publish("SnapController:snapInstallFailed",t,e,!1,a),n}}async updateSnap(e,t,n,a=p.DEFAULT_REQUESTED_SNAP_VERSION,i=!0){c(Q,this,re).call(this),c(Q,this,ce).call(this);const o=this.getExpect(t);if(o.preinstalled)throw new Error("Preinstalled Snaps cannot be manually updated.");if(!(0,f.isValidSemVerRange)(a))throw new Error(`Received invalid snap version range: "${a}".`);let r=c(Q,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_UPDATE});try{this.messagingSystem.publish("SnapController:snapInstallStarted",t,e,!0);const l=o.manifest,m=await(0,E.fetchSnap)(t,n),{sourceCode:h,manifest:g}=m,b=g.result,k=b.version;if(!(0,f.gtVersion)(k,o.version))throw d.rpcErrors.invalidParams(`Snap "${t}@${o.version}" is already installed. Couldn't update to a version inside requested "${a}" range.`);if(!(0,f.satisfiesVersionRange)(k,a))throw new Error(`Version mismatch. Manifest for "${t}" specifies version "${k}" which doesn't satisfy requested version range "${a}".`);await c(Q,this,oe).call(this,t,{version:k,checksum:b.source.shasum,permissions:b.initialPermissions,platformVersion:b.platformVersion});const y=(0,u.processSnapPermissions)(b.initialPermissions);c(Q,this,Te).call(this,y);const{newPermissions:w,unusedPermissions:S,approvedPermissions:_}=c(Q,this,ze).call(this,t,y),{newConnections:v,unusedConnections:x,approvedConnections:P}=c(Q,this,Ye).call(this,t,l.initialConnections??{},b.initialConnections??{});c(Q,this,_e).call(this,r.id,{permissions:w,newVersion:b.version,newPermissions:w,approvedPermissions:_,unusedPermissions:S,newConnections:v,unusedConnections:x,approvedConnections:P,loading:!1});const{permissions:j,...T}=await r.promise;r=c(Q,this,Se).call(this,{origin:e,snapId:t,type:s.SNAP_APPROVAL_RESULT}),this.isRunning(t)&&await this.stopSnap(t,p.SnapStatusEvents.Stop),c(Q,this,me).call(this,t,p.SnapStatusEvents.Update),c(Q,this,Ee).call(this,{origin:e,id:t,files:m,isUpdate:!0}),c(Q,this,Ze).call(this,{snapId:t,unusedPermissions:S,newPermissions:j,requestData:T}),b.initialConnections&&c(Q,this,be).call(this,t,l.initialConnections??null,b.initialConnections);const C=c(Q,this,He).call(this,t);C!==undefined&&(C.permissions.revoked=S,C.permissions.granted=j,C.permissions.requestData=T);const I=h.toString();(0,f.assert)("string"==typeof I&&I.length>0,`Invalid source code for snap "${t}".`);try{await c(Q,this,Pe).call(this,{snapId:t,sourceCode:I})}catch{throw new Error(`Snap ${t} crashed with updated source code.`)}const O=this.getTruncatedExpect(t);return i&&this.messagingSystem.publish("SnapController:snapUpdated",O,o.version,e,!1),c(Q,this,_e).call(this,r.id,{loading:!1,type:s.SNAP_APPROVAL_UPDATE}),O}catch(n){(0,p.logError)(`Error when updating ${t},`,n);const a=n instanceof Error?n.message:n.toString();throw c(Q,this,_e).call(this,r.id,{loading:!1,error:a,type:s.SNAP_APPROVAL_UPDATE}),this.messagingSystem.publish("SnapController:snapInstallFailed",t,e,!0,a),n}}async authorize(e,t){(0,j.log)(`Authorizing snap: ${e}`);const s=this.state.snaps[e],{initialPermissions:n,initialConnections:a}=s;try{const i=(0,u.processSnapPermissions)(n);c(Q,this,Te).call(this,i),c(Q,this,_e).call(this,t.id,{loading:!1,connections:a??{},permissions:i});const{permissions:o,...r}=await t.promise;c(Q,this,Ze).call(this,{snapId:e,newPermissions:o,requestData:r}),s.manifest.initialConnections&&c(Q,this,be).call(this,e,null,s.manifest.initialConnections)}finally{c(Q,this,Ke).call(this,e).installPromise=null}}destroy(){super.destroy(),o(K,this)&&clearTimeout(o(K,this)),this.messagingSystem.unsubscribe("ExecutionService:unhandledError",this._onUnhandledSnapError),this.messagingSystem.unsubscribe("ExecutionService:outboundRequest",this._onOutboundRequest),this.messagingSystem.unsubscribe("ExecutionService:outboundResponse",this._onOutboundResponse),this.messagingSystem.clearEventSubscriptions("SnapController:snapInstalled"),this.messagingSystem.clearEventSubscriptions("SnapController:snapUpdated")}async handleRequest({snapId:e,origin:t,handler:s,request:n}){c(Q,this,ce).call(this),(0,f.assert)(t===w.METAMASK_ORIGIN||(0,p.isValidUrl)(t),"'origin' must be a valid URL or 'metamask'.");const a={jsonrpc:"2.0",id:(0,k.nanoid)(),...n};(0,f.assertIsJsonRpcRequest)(a);const i=u.handlerEndowments[s];(0,f.assert)("string"==typeof i||null===i,"'permissionName' must be either a string or null.");const o=this.messagingSystem.call("PermissionController:getPermissions",e);if(!(null===i||o&&(0,f.hasProperty)(o,i)))throw new Error(`Snap "${e}" is not permitted to use "${i}".`);const r=i?o[i]:undefined;if(i===u.SnapEndowments.Rpc||i===u.SnapEndowments.Keyring){(0,f.assert)(r);const s=this.messagingSystem.call("SubjectMetadataController:getSubjectMetadata",t),n=i===u.SnapEndowments.Rpc?(0,u.getRpcCaveatOrigins)(r):(0,u.getKeyringCaveatOrigins)(r);if((0,f.assert)(n),!(0,p.isOriginAllowed)(n,(null==s?void 0:s.subjectType)??m.SubjectType.Website,t))throw new Error(`Snap "${e}" is not permitted to handle requests from "${t}".`)}if(t!==w.METAMASK_ORIGIN&&w.CLIENT_ONLY_HANDLERS.includes(s))throw new Error(`"${s}" can only be invoked by MetaMask.`);if(!this.state.snaps[e].enabled)throw new Error(`Snap "${e}" is disabled.`);if(this.state.snaps[e].status===p.SnapStatus.Installing)throw new Error(`Snap "${e}" is currently being installed. Please try again later.`);const l=c(Q,this,Ie).call(this,r),d=c(Q,this,Ke).call(this,e);if(d.stopPromise&&await d.stopPromise,!this.isRunning(e)){d.startPromise||(d.startPromise=this.startSnap(e));try{await d.startPromise}finally{d.startPromise=null}}const h=c(Q,this,Be).call(this,e,s,a),g=new x.Timer(l);c(Q,this,De).call(this,e,h.id,g);const b=this.messagingSystem.call("ExecutionService:handleRpcRequest",e,{origin:t,handler:s,request:h});try{const n=await(0,E.withTimeout)(b,g);if(n===E.hasTimedOut){const t=null!==d.stopPromise||!this.isRunning(e);throw new Error(t?`${e} was stopped and the request was cancelled. This is likely because the Snap crashed.`:`${e} failed to respond to the request in time.`)}await c(Q,this,Le).call(this,e,s,n);const a=await c(Q,this,Me).call(this,e,s,h,n);return c(Q,this,Fe).call(this,e,h.id,s,t,!0),a}catch(n){c(Q,this,Fe).call(this,e,h.id,s,t,!1);const[a,i]=(0,p.unwrapError)(n);throw i||((0,p.logError)(`"${e}" crashed due to an unhandled error:`,a),await this.stopSnap(e,p.SnapStatusEvents.Crash)),a}}setClientActive(e){e?c(Q,this,et).call(this,w.METAMASK_ORIGIN,p.HandlerType.OnActive):c(Q,this,et).call(this,w.METAMASK_ORIGIN,p.HandlerType.OnInactive)}}function ee(){const e=({snapId:e})=>this.getExpect(e).enabled,t={initial:p.SnapStatus.Installing,states:{[p.SnapStatus.Installing]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e}}},[p.SnapStatus.Updating]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e},[p.SnapStatusEvents.Stop]:p.SnapStatus.Stopped}},[p.SnapStatus.Running]:{on:{[p.SnapStatusEvents.Stop]:p.SnapStatus.Stopped,[p.SnapStatusEvents.Crash]:p.SnapStatus.Crashed}},[p.SnapStatus.Stopped]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e},[p.SnapStatusEvents.Update]:p.SnapStatus.Updating}},[p.SnapStatus.Crashed]:{on:{[p.SnapStatusEvents.Start]:{target:p.SnapStatus.Running,cond:e},[p.SnapStatusEvents.Update]:p.SnapStatus.Updating}}}};r(G,this,(0,g.createMachine)(t)),(0,P.validateMachine)(o(G,this))}function te(){this.messagingSystem.registerActionHandler(`${s.controllerName}:init`,((...e)=>this.init(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:clearSnapState`,((...e)=>this.clearSnapState(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:get`,((...e)=>this.get(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:getSnapState`,(async(...e)=>this.getSnapState(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:handleRequest`,(async(...e)=>this.handleRequest(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:has`,((...e)=>this.has(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:updateBlockedSnaps`,(async()=>this.updateBlockedSnaps())),this.messagingSystem.registerActionHandler(`${s.controllerName}:updateSnapState`,(async(...e)=>this.updateSnapState(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:enable`,((...e)=>this.enableSnap(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:disable`,(async(...e)=>this.disableSnap(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:remove`,(async(...e)=>this.removeSnap(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:getPermitted`,((...e)=>this.getPermittedSnaps(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:install`,(async(...e)=>this.installSnaps(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:getAll`,((...e)=>this.getAllSnaps(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:getRunnableSnaps`,((...e)=>this.getRunnableSnaps(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:incrementActiveReferences`,((...e)=>this.incrementActiveReferences(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:decrementActiveReferences`,((...e)=>this.decrementActiveReferences(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:disconnectOrigin`,((...e)=>this.removeSnapFromSubject(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:revokeDynamicPermissions`,((...e)=>this.revokeDynamicSnapPermissions(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:getFile`,(async(...e)=>this.getSnapFile(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:stopAllSnaps`,(async(...e)=>this.stopAllSnaps(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:isMinimumPlatformVersion`,((...e)=>this.isMinimumPlatformVersion(...e))),this.messagingSystem.registerActionHandler(`${s.controllerName}:setClientActive`,((...e)=>this.setClientActive(...e)))}function se(e){for(const{snapId:s,manifest:n,files:a,removable:i,hidden:o,hideSnapBranding:r}of e){var t;const e=this.get(s),l=e!==undefined,m=l&&(0,f.gtVersion)(n.version,e.version);if(l&&(!m||!0!==e.preinstalled))continue;const d=new p.VirtualFile({path:p.NpmSnapFileNames.Manifest,value:JSON.stringify(n),result:n}),h=a.map((({path:e,value:t})=>new p.VirtualFile({value:t,path:e}))),{filePath:g,iconPath:b}=n.source.location.npm,k=h.find((e=>e.path===g)),y=b?h.find((e=>e.path===b)):undefined;(0,f.assert)(k,"Source code not provided for preinstalled snap."),(0,f.assert)(!b||b&&y,"Icon not provided for preinstalled snap."),(0,f.assert)(n.source.files===undefined,"Auxiliary files are not currently supported for preinstalled snaps.");const S=(null===(t=n.source.locales)||void 0===t?void 0:t.map((e=>h.find((t=>t.path===e)))))??[],_=(0,p.getValidatedLocalizationFiles)(S.filter(Boolean));(0,f.assert)(S.length===_.length,"Missing localization files for preinstalled snap.");const v={manifest:d,sourceCode:k,svgIcon:y,auxiliaryFiles:[],localizationFiles:_};c(Q,this,Ee).call(this,{id:s,origin:w.METAMASK_ORIGIN,files:v,removable:i,hidden:o,hideSnapBranding:r,preinstalled:!0});const x=(0,u.processSnapPermissions)(n.initialPermissions);c(Q,this,Te).call(this,x);const{newPermissions:P,unusedPermissions:j}=c(Q,this,ze).call(this,s,x);c(Q,this,Ze).call(this,{snapId:s,newPermissions:P,unusedPermissions:j}),n.initialConnections&&c(Q,this,be).call(this,s,(null==e?void 0:e.initialConnections)??null,n.initialConnections),this.update((e=>{e.snaps[s].status=p.SnapStatus.Stopped})),c(Q,this,Ge).call(this,s),m?this.messagingSystem.publish("SnapController:snapUpdated",this.getTruncatedExpect(s),e.version,w.METAMASK_ORIGIN,!0):this.messagingSystem.publish("SnapController:snapInstalled",this.getTruncatedExpect(s),w.METAMASK_ORIGIN,!0)}}function ne(){r(K,this,setTimeout((()=>{c(Q,this,le).call(this).catch((e=>{(0,p.logError)(e)})),c(Q,this,ne).call(this)}),o(B,this)))}async function ae(e,t){if(this.has(e)){try{this.update((s=>{s.snaps[e].blocked=!0,s.snaps[e].blockInformation=t})),await this.disableSnap(e)}catch(t){(0,p.logError)(`Encountered error when stopping blocked snap "${e}".`,t)}this.messagingSystem.publish(`${s.controllerName}:snapBlocked`,e,t)}}function ie(e){this.has(e)&&this.state.snaps[e].blocked&&(this.update((t=>{t.snaps[e].blocked=!1,delete t.snaps[e].blockInformation})),this.messagingSystem.publish(`${s.controllerName}:snapUnblocked`,e))}async function oe(e,{platformVersion:t,...s}){const n=(await this.messagingSystem.call("SnapsRegistry:get",{[e]:s}))[e];var a;if(n.status===_.SnapsRegistryStatus.Blocked)throw new Error(`Cannot install version "${s.version}" of snap "${e}": The version is blocked. ${(null===(a=n.reason)||void 0===a?void 0:a.explanation)??""}`);const i=Object.keys(s.permissions).some((e=>!w.ALLOWED_PERMISSIONS.includes(e)));if(o(N,this).requireAllowlist&&i&&n.status!==_.SnapsRegistryStatus.Verified)throw new Error(`Cannot install version "${s.version}" of snap "${e}": ${n.status===_.SnapsRegistryStatus.Unavailable?"The registry is temporarily unavailable.":"The snap is not on the allowlist."}`);c(Q,this,Ce).call(this,e,t)}function re(){(0,f.assert)(!0!==o(N,this).disableSnapInstallation,"Installing Snaps is currently disabled in this version of MetaMask.")}function ce(){const e=o(H,this).call(this);(0,f.assert)(!0!==e.disableSnaps,"The Snaps platform requires basic functionality to be used. Enable basic functionality in the settings to use the Snaps platform.")}async function le(){const e=[...o(V,this).entries()];return Promise.all(e.filter((([e,t])=>0===t.activeReferences&&0===t.pendingInboundRequests.length&&t.lastRequest&&o(L,this)&&(0,f.timeSince)(t.lastRequest)>o(L,this))).map((async([e])=>this.stopSnap(e,p.SnapStatusEvents.Stop))))}function me(e,t){const{interpreter:s}=c(Q,this,Ke).call(this,e);s.send(t),this.update((t=>{t.snaps[e].status=s.state.value}))}async function de(e){await this.messagingSystem.call("ExecutionService:terminateSnap",e),await new Promise((e=>setTimeout(e,1)));c(Q,this,Ke).call(this,e).pendingInboundRequests.filter((e=>"finished"!==e.timer.status)).forEach((e=>e.timer.finish())),await new Promise((e=>setTimeout(e,1))),this.messagingSystem.publish("SnapController:snapTerminated",this.getTruncatedExpect(e))}function ue(e,t=c(Q,this,Ke).call(this,e)){return null!==t.encryptionKey&&null!==t.encryptionSalt}async function he({snapId:e,salt:t,useCache:s,keyMetadata:n}){const a=c(Q,this,Ke).call(this,e);if(c(Q,this,ue).call(this,e,a)&&s)return{key:await o(D,this).importKey(a.encryptionKey),salt:a.encryptionSalt};const i=t??o(D,this).generateSalt(),r=await o(F,this).call(this),l=await(0,u.getEncryptionEntropy)({snapId:e,seed:r,cryptographicFunctions:o(U,this)}),m=await o(D,this).keyFromPassword(l,i,!0,n),d=await o(D,this).exportKey(m);return s&&(a.encryptionKey=d,a.encryptionSalt=i),{key:m,salt:i}}async function pe(e,t){try{const s=JSON.parse(t),{salt:n,keyMetadata:a}=s,i=c(Q,this,ue).call(this,e)||o(D,this).isVaultUpdated(t),{key:r}=await c(Q,this,he).call(this,{snapId:e,salt:n,useCache:i,keyMetadata:a??w.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS});return await o(D,this).decryptWithKey(r,s)}catch{throw d.rpcErrors.internal({message:"Failed to decrypt snap state, the state must be corrupted."})}}async function fe(e,t){const{key:s,salt:n}=await c(Q,this,he).call(this,{snapId:e,useCache:!0}),a=await o(D,this).encryptWithKey(s,t);return a.salt=n,JSON.stringify(a)}async function ge(e,t,s){return null===t?null:s?await c(Q,this,fe).call(this,e,t):JSON.stringify(t)}function be(e,t,s){if(t){const n=(0,E.setDiff)(t,s);for(const t of Object.keys(n))this.removeSnapFromSubject(t,e)}for(const t of Object.keys(s))c(Q,this,ke).call(this,t,e)}function ke(e,t){var s,n;const a=this.messagingSystem.call("PermissionController:getPermissions",e),i=null==a||null===(s=a[u.WALLET_SNAP_PERMISSION_KEY])||void 0===s||null===(s=s.caveats)||void 0===s?void 0:s.find((e=>e.type===p.SnapCaveatType.SnapIds));if(Boolean(null==i||null===(n=i.value)||void 0===n?void 0:n[t]))return;if(i)return void this.messagingSystem.call("PermissionController:updateCaveat",e,u.WALLET_SNAP_PERMISSION_KEY,p.SnapCaveatType.SnapIds,{...i.value,[t]:{}});const o={[u.WALLET_SNAP_PERMISSION_KEY]:{caveats:[{type:p.SnapCaveatType.SnapIds,value:{[t]:{}}}]}};this.messagingSystem.call("PermissionController:grantPermissions",{approvedPermissions:o,subject:{origin:e}})}function ye(e){const t=this.messagingSystem.call("PermissionController:getSubjectNames");for(const s of t)this.removeSnapFromSubject(s,e)}function we(e){this.messagingSystem.call("PermissionController:hasPermissions",e)&&this.messagingSystem.call("PermissionController:revokeAllPermissions",e)}function Se({origin:e,snapId:t,type:s}){const n=(0,k.nanoid)();return{id:n,promise:this.messagingSystem.call("ApprovalController:addRequest",{origin:e,id:n,type:s,requestData:{metadata:{id:n,origin:t,dappOrigin:e},snapId:t},requestState:{loading:!0}},!0)}}function _e(e,t){try{this.messagingSystem.call("ApprovalController:updateRequestState",{id:e,requestState:t})}catch{}}async function ve(e,t){return await this.messagingSystem.call("SnapsRegistry:resolveVersion",e,t)}async function xe(e){const{id:t,location:s,versionRange:n}=e;c(Q,this,Ge).call(this,t);const a=c(Q,this,Ke).call(this,t);a.installPromise||((0,j.log)(`Adding snap: ${t}`),a.installPromise=(async()=>{const a=await(0,E.fetchSnap)(t,s),i=a.manifest.result;if(!(0,f.satisfiesVersionRange)(i.version,n))throw new Error(`Version mismatch. Manifest for "${t}" specifies version "${i.version}" which doesn't satisfy requested version range "${n}".`);await c(Q,this,oe).call(this,t,{version:i.version,checksum:i.source.shasum,permissions:i.initialPermissions,platformVersion:i.platformVersion});const r=o(N,this).forcePreinstalledSnaps&&(0,E.isLocalSnapId)(t)?{preinstalled:!0,hideSnapBranding:!0,hidden:!1}:{};return c(Q,this,Ee).call(this,{...e,files:a,id:t,...r})})());try{return await a.installPromise}catch(e){throw a.installPromise=null,e}}async function Pe(e){const{snapId:t}=e;if(this.isRunning(t))throw new Error(`Snap "${t}" is already started.`);try{const s=c(Q,this,Ke).call(this,t),n=await this.messagingSystem.call("ExecutionService:executeSnap",{...e,endowments:await c(Q,this,je).call(this,t)});return c(Q,this,me).call(this,t,p.SnapStatusEvents.Start),s.lastRequest=Date.now(),n}catch(e){throw await c(Q,this,de).call(this,t),e}}async function je(e){let t=[];for(const s of o(M,this))if(this.messagingSystem.call("PermissionController:hasPermission",e,s)){const n=await this.messagingSystem.call("PermissionController:getEndowments",e,s);if(n){if(!Array.isArray(n)||n.some((e=>"string"!=typeof e)))throw new Error("Expected an array of string endowment names.");t=t.concat(n)}}const s=[...new Set([...p.DEFAULT_ENDOWMENTS,...t])];return s.length<p.DEFAULT_ENDOWMENTS.length+t.length&&(0,p.logError)(`Duplicate endowments found for ${e}. Default endowments should not be requested.`,t),s}function Ee(e){const{id:t,origin:s,files:n,isUpdate:a=!1,removable:i,preinstalled:r,hidden:l,hideSnapBranding:d}=e,{manifest:u,sourceCode:h,svgIcon:g,auxiliaryFiles:b,localizationFiles:k}=n;(0,p.assertIsSnapManifest)(u.result);const{version:y}=u.result,w=h.toString();(0,f.assert)("string"==typeof w&&w.length>0,`Invalid source code for snap "${t}".`);const S=b.map((e=>((0,f.assert)("string"==typeof e.data.base64),{path:e.path,value:e.data.base64}))),_=this.state.snaps[t],v=[...(null==_?void 0:_.versionHistory)??[],{version:y,date:Date.now(),origin:s}],x=k.map((e=>e.result)),P={..._,blocked:!1,enabled:!0,removable:i,preinstalled:r,hidden:l,hideSnapBranding:d,id:t,initialConnections:u.result.initialConnections,initialPermissions:u.result.initialPermissions,manifest:u.result,status:o(G,this).config.initial,sourceCode:w,version:y,versionHistory:v,auxiliaryFiles:S,localizationFiles:x};delete P.blockInformation;const{inversePatches:j}=this.update((e=>{e.snaps[t]=P}));if(a){const e=c(Q,this,He).call(this,t);e!==undefined&&(e.statePatches=j)}const{proposedName:E}=(0,p.getLocalizedSnapManifest)(u.result,"en",x);return this.messagingSystem.call("SubjectMetadataController:addSubjectMetadata",{subjectType:m.SubjectType.Snap,name:E,origin:P.id,version:y,svgIcon:(null==g?void 0:g.toString())??null}),{...P,sourceCode:w}}function Te(e){const t=Object.keys(e),s=Array.from(new Set(Object.values(u.handlerEndowments)));(0,f.assert)(t.some((e=>s.includes(e))),`A snap must request at least one of the following permissions: ${s.filter((e=>null!==e)).join(", ")}.`);const n=t.reduce(((e,t)=>((0,f.hasProperty)(o(R,this),t)&&e.push(o(R,this)[t]),e)),[]);(0,f.assert)(0===n.length,`One or more permissions are not allowed:\n${n.join("\n")}`)}function Ce(e,t){if(t!==undefined&&(0,y.gt)(t,(0,p.getPlatformVersion)())){const s=`The Snap "${e}" requires platform version "${t}" which is greater than the current platform version "${(0,p.getPlatformVersion)()}".`;if(o(N,this).rejectInvalidPlatformVersion)throw new Error(s);(0,p.logWarning)(s)}}function Ie(e){return(0,u.getMaxRequestTimeCaveat)(e)??this.maxRequestTime}async function Oe(e,t,s){return this.messagingSystem.call("SnapInterfaceController:createInterface",e,t,undefined,s)}function Ae(e,t){(0,f.assert)(this.messagingSystem.call("SnapInterfaceController:getInterface",e,t))}async function Me(e,t,s,n){switch(t){case p.HandlerType.OnTransaction:case p.HandlerType.OnSignature:case p.HandlerType.OnHomePage:case p.HandlerType.OnSettingsPage:{const t=n;if(t&&(0,f.hasProperty)(t,"content")){const{content:s,...n}=t;return{...n,id:await c(Q,this,Oe).call(this,e,s)}}return n}case p.HandlerType.OnAssetsLookup:return c(Q,this,Re).call(this,e,s,n);case p.HandlerType.OnAssetsConversion:return c(Q,this,Ne).call(this,s,n);case p.HandlerType.OnAssetsMarketData:return c(Q,this,$e).call(this,s,n);default:return n}}function Re(e,{params:t},{assets:s}){const n=this.messagingSystem.call("PermissionController:getPermissions",e);(0,f.assert)(n);const a=n[u.SnapEndowments.Assets],i=(0,u.getChainIdsCaveat)(a);(0,f.assert)(i);const{assets:o}=t;return{assets:Object.keys(s).reduce(((e,t)=>{const n=t;return i.some((e=>n.startsWith(e)))&&o.includes(n)&&(e[n]=s[n]),e}),{})}}function Ne({params:e},{conversionRates:t}){const{conversions:s}=e;return{conversionRates:s.reduce(((e,s)=>{var n;const a=null===(n=t[s.from])||void 0===n?void 0:n[s.to];var i;a&&(e[i=s.from]??(e[i]={}),e[s.from][s.to]=a);return e}),{})}}function $e({params:e},{marketData:t}){const{assets:s}=e;return{marketData:s.reduce(((e,s)=>{var n;const a=null===(n=t[s.asset])||void 0===n?void 0:n[s.unit];var i;a&&(e[i=s.asset]??(e[i]={}),e[s.asset][s.unit]=a);return e}),{})}}function Be(e,t,s){if(t===p.HandlerType.OnUserInput){(0,f.assert)(s.params&&(0,f.hasProperty)(s.params,"id"));const t=s.params.id,{context:n}=this.messagingSystem.call("SnapInterfaceController:getInterface",e,t);return{...s,params:{...s.params,context:n}}}return s}async function Le(e,t,s){switch(t){case p.HandlerType.OnTransaction:(0,f.assertStruct)(s,p.OnTransactionResponseStruct),s&&(0,f.hasProperty)(s,"id")&&c(Q,this,Ae).call(this,e,s.id);break;case p.HandlerType.OnSignature:(0,f.assertStruct)(s,p.OnSignatureResponseStruct),s&&(0,f.hasProperty)(s,"id")&&c(Q,this,Ae).call(this,e,s.id);break;case p.HandlerType.OnHomePage:(0,f.assertStruct)(s,p.OnHomePageResponseStruct),s&&(0,f.hasProperty)(s,"id")&&c(Q,this,Ae).call(this,e,s.id);break;case p.HandlerType.OnSettingsPage:(0,f.assertStruct)(s,p.OnSettingsPageResponseStruct),s&&(0,f.hasProperty)(s,"id")&&c(Q,this,Ae).call(this,e,s.id);break;case p.HandlerType.OnNameLookup:(0,f.assertStruct)(s,p.OnNameLookupResponseStruct);break;case p.HandlerType.OnAssetsLookup:(0,f.assertStruct)(s,h.OnAssetsLookupResponseStruct);break;case p.HandlerType.OnAssetsConversion:(0,f.assertStruct)(s,p.OnAssetsConversionResponseStruct);break;case p.HandlerType.OnAssetHistoricalPrice:(0,f.assertStruct)(s,p.OnAssetHistoricalPriceResponseStruct);break;case p.HandlerType.OnAssetsMarketData:(0,f.assertStruct)(s,p.OnAssetsMarketDataResponseStruct)}}function De(e,t,s){const n=c(Q,this,Ke).call(this,e);n.pendingInboundRequests.push({requestId:t,timer:s}),n.lastRequest=null}function Fe(e,t,s,n,a){const i=c(Q,this,Ke).call(this,e);i.pendingInboundRequests=i.pendingInboundRequests.filter((e=>e.requestId!==t)),0===i.pendingInboundRequests.length&&(i.lastRequest=Date.now());const r=this.get(e);if((0,E.isTrackableHandler)(s)&&(null==r||!r.preinstalled))try{o(Y,this).call(this,e,s,a,n)}catch(e){(0,p.logError)(`Error when calling MetaMetrics hook for snap "${null==r?void 0:r.id}": ${(0,h.getErrorMessage)(e)}`)}}function He(e){return o(W,this).get(e)}function Ue(e){(0,f.assert)(o(W,this).get(e)===undefined,new Error(`Snap "${e}" rollback snapshot already exists.`)),o(W,this).set(e,{statePatches:[],permissions:{},newVersion:""});const t=o(W,this).get(e);return(0,f.assert)(t!==undefined,new Error(`Snapshot creation failed for ${e}.`)),t}async function qe(e){var t,s;const n=c(Q,this,He).call(this,e);if(!n)throw new Error("A snapshot does not exist for this snap.");await this.stopSnap(e,p.SnapStatusEvents.Stop),(null===(t=this.get(e))||void 0===t?void 0:t.status)!==p.SnapStatus.Stopped&&c(Q,this,me).call(this,e,p.SnapStatusEvents.Stop);const{statePatches:a,permissions:i}=n;null!=a&&a.length&&this.applyPatches(a),(null===(s=this.get(e))||void 0===s?void 0:s.status)!==p.SnapStatus.Stopped&&this.update((t=>{t.snaps[e].status=p.SnapStatus.Stopped})),c(Q,this,Ze).call(this,{snapId:e,unusedPermissions:i.granted,newPermissions:i.revoked,requestData:i.requestData});const r=this.getTruncatedExpect(e);this.messagingSystem.publish("SnapController:snapRolledback",r,n.newVersion),o(W,this).delete(e)}async function Ve(e){for(const t of e)await c(Q,this,qe).call(this,t)}function We(e){return o(V,this).get(e)}function Ke(e){const t=c(Q,this,We).call(this,e);return(0,f.assert)(t!==undefined,new Error(`Snap "${e}" runtime data not found`)),t}function Ge(e){if(o(V,this).has(e))return;const t=this.get(e),s=(0,g.interpret)(o(G,this));s.start({context:{snapId:e},value:(null==t?void 0:t.status)??o(G,this).config.initial}),(0,P.forceStrict)(s),o(V,this).set(e,{lastRequest:null,startPromise:null,stopPromise:null,installPromise:null,encryptionKey:null,encryptionSalt:null,activeReferences:0,pendingInboundRequests:[],pendingOutboundRequests:0,interpreter:s,stateMutex:new b.Mutex,getStateMutex:new b.Mutex})}function ze(e,t){const s=this.messagingSystem.call("PermissionController:getPermissions",e)??{},n=(0,E.permissionsDiff)(t,s),a=(0,E.permissionsDiff)(s,t);return{newPermissions:n,unusedPermissions:a,approvedPermissions:(0,E.permissionsDiff)(s,a)}}function Je(e,t){var s,n;const a=this.messagingSystem.call("PermissionController:getPermissions",t),i=null==a||null===(s=a[u.WALLET_SNAP_PERMISSION_KEY])||void 0===s||null===(s=s.caveats)||void 0===s?void 0:s.find((e=>e.type===p.SnapCaveatType.SnapIds));return Boolean(null==i||null===(n=i.value)||void 0===n?void 0:n[e])}function Ye(e,t,s){const n=Object.keys(t).filter((t=>c(Q,this,Je).call(this,e,t))).reduce(((e,s)=>(e[s]=t[s],e)),{}),a=(0,E.setDiff)(s,n),i=(0,E.setDiff)(n,s);return{newConnections:a,unusedConnections:i,approvedConnections:(0,E.setDiff)(n,i)}}function Qe(e,t){if(o(N,this).useCaip25Permission&&Object.keys(t).includes(u.SnapEndowments.EthereumProvider)){const s=this.messagingSystem.call("SelectedNetworkController:getNetworkClientIdForDomain",e),{configuration:n}=this.messagingSystem.call("NetworkController:getNetworkClientById",s),a=(0,f.hexToNumber)(n.chainId);return{...t,"endowment:caip25":{caveats:[{type:"authorizedScopes",value:{requiredScopes:{},optionalScopes:{[`eip155:${a}`]:{accounts:[]}},sessionProperties:{},isMultichainOrigin:!1}}]}}}return t}function Ze({snapId:e,unusedPermissions:t={},newPermissions:s={},requestData:n}){const a=Object.keys(t);if((0,f.isNonEmptyArray)(a)&&this.messagingSystem.call("PermissionController:revokePermissions",{[e]:a}),(0,f.isNonEmptyArray)(Object.keys(s))){const t=c(Q,this,Qe).call(this,e,s);this.messagingSystem.call("PermissionController:grantPermissions",{approvedPermissions:t,subject:{origin:e},requestData:n})}}function Xe(e,t){const s=this.getExpect(e);return!(0,f.satisfiesVersionRange)(s.version,t)&&!(0,f.gtRange)(s.version,t)}function et(e,t){const s=this.getRunnableSnaps();for(const{id:n}of s){this.messagingSystem.call("PermissionController:hasPermission",n,u.SnapEndowments.LifecycleHooks)&&c(Q,this,tt).call(this,e,n,t).catch((e=>{(0,p.logError)(`Error calling lifecycle hook "${t}" for Snap "${n}": ${(0,h.getErrorMessage)(e)}`)}))}}async function tt(e,t,s){const n=u.handlerEndowments[s];(0,f.assert)(n,"Lifecycle hook must have an endowment.");this.messagingSystem.call("PermissionController:hasPermission",t,n)&&await this.handleRequest({snapId:t,handler:s,origin:e,request:{jsonrpc:"2.0",method:s}})}function st(){for(const e of o(V,this).values())e.encryptionKey=null,e.encryptionSalt=null,e.state=undefined}s.SnapController=X}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.Timer=void 0;const a=e("@metamask/utils");s.Timer=class{constructor(e){n(this,"state",void 0),(0,a.assert)(!Number.isNaN(e),new TypeError("Can't start a timer with NaN time")),(0,a.assert)(e>=0,new TypeError("Can't start a timer with negative time")),this.state={value:"stopped",remaining:e}}get status(){return this.state.value}get remaining(){return this.state.remaining}cancel(){(0,a.assert)("paused"===this.status||"running"===this.status,new Error("Tried to cancel a not running Timer")),this.onFinish(!1)}finish(){(0,a.assert)("finished"!==this.status,new Error("Tried to finish a finished Timer.")),this.onFinish(!0)}pause(){(0,a.assert)("running"===this.state.value,new Error("Tried to pause a not running Timer"));const{callback:e,start:t,timeout:s,remaining:n}=this.state;s!==undefined&&clearTimeout(s),this.state={value:"paused",callback:e,remaining:n-(Date.now()-t)}}start(e){(0,a.assert)("stopped"===this.state.value,new Error("Tried to start an already running Timer"));const{remaining:t}=this.state;this.state={value:"paused",remaining:t,callback:e},this.resume()}resume(){(0,a.assert)("paused"===this.state.value,new Error("Tried to resume not paused Timer"));const{remaining:e,callback:t}=this.state,s=Date.now();let n;e!==Number.POSITIVE_INFINITY&&(n=setTimeout((()=>this.onFinish(!0)),e)),this.state={value:"running",callback:t,remaining:e,start:s,timeout:n}}onFinish(e){(0,a.assert)("running"===this.state.value||"paused"===this.state.value),"running"===this.state.value&&this.state.timeout!==undefined&&clearTimeout(this.state.timeout);const{callback:t,remaining:s}=this.state;this.state={value:"finished",remaining:"running"===this.state.value?s-(Date.now()-this.state.start):s},e&&t()}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs",{"@metamask/snaps-rpc-methods":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-rpc-methods/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.CLIENT_ONLY_HANDLERS=s.METAMASK_ORIGIN=s.STATE_DEBOUNCE_TIMEOUT=s.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS=s.ALLOWED_PERMISSIONS=void 0;const n=e("@metamask/snaps-rpc-methods"),a=e("@metamask/snaps-utils");s.ALLOWED_PERMISSIONS=Object.freeze(["snap_dialog","snap_manageState","snap_notify","snap_getLocale",n.SnapEndowments.Cronjob,n.SnapEndowments.HomePage,n.SnapEndowments.LifecycleHooks,n.SnapEndowments.EthereumProvider,n.SnapEndowments.TransactionInsight,n.SnapEndowments.SignatureInsight]),s.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS={algorithm:"PBKDF2",params:{iterations:1e4}},s.STATE_DEBOUNCE_TIMEOUT=500,s.METAMASK_ORIGIN="metamask",s.CLIENT_ONLY_HANDLERS=Object.freeze([a.HandlerType.OnClientRequest,a.HandlerType.OnSignature,a.HandlerType.OnTransaction,a.HandlerType.OnCronjob,a.HandlerType.OnNameLookup,a.HandlerType.OnHomePage,a.HandlerType.OnSettingsPage,a.HandlerType.OnUserInput,a.HandlerType.OnAssetsLookup,a.HandlerType.OnAssetsConversion,a.HandlerType.OnAssetHistoricalPrice,a.HandlerType.OnAssetsMarketData,a.HandlerType.OnWebSocketEvent])}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs",{"./SnapController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/SnapController.cjs","./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/constants.cjs","./location/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs","./registry/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs","./selectors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./constants.cjs"),s),a(e("./location/index.cjs"),s),a(e("./SnapController.cjs"),s),a(e("./selectors.cjs"),s),a(e("./registry/index.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}Object.defineProperty(s,"__esModule",{value:!0}),s.HttpLocation=void 0;const a=e("@metamask/snaps-utils"),i=e("@metamask/utils");s.HttpLocation=class{constructor(e,t={}){n(this,"cache",new Map),n(this,"validatedManifest",void 0),n(this,"url",void 0),n(this,"fetchFn",void 0),n(this,"fetchOptions",void 0),(0,i.assertStruct)(e.toString(),a.HttpSnapIdStruct,"Invalid Snap Id: "),this.fetchFn=t.fetch??globalThis.fetch.bind(undefined),this.fetchOptions=t.fetchOptions,this.url=e}async manifest(){if(this.validatedManifest)return this.validatedManifest.clone();const e=new URL(a.NpmSnapFileNames.Manifest,this.url).toString(),t=await this.fetchFn(e,this.fetchOptions);if(!t.ok)throw new Error(`Failed to fetch "${e}". Status code: ${t.status}.`);const s=await t.text(),n=(0,a.parseJson)(s),i=new a.VirtualFile({value:s,result:(0,a.createSnapManifest)(n),path:a.NpmSnapFileNames.Manifest,data:{canonicalPath:e}});return this.validatedManifest=i,this.manifest()}async fetch(e){const t=(0,a.normalizeRelative)(e),s=this.cache.get(t);if(s!==undefined)return s.clone();const n=this.toCanonical(t).toString(),o=await this.fetchFn(n,this.fetchOptions);if(!o.ok)throw new Error(`Failed to fetch "${n}". Status code: ${o.status}.`);const r=await o.arrayBuffer(),c=new a.VirtualFile({value:new Uint8Array(r),path:t,data:{canonicalPath:n}});return(0,i.assert)(!this.cache.has(t),"Corrupted cache, multiple files with same path."),this.cache.set(t,c),this.fetch(t)}get root(){return new URL(this.url)}toCanonical(e){return(0,i.assert)(!e.startsWith("/"),"Tried to parse absolute path."),new URL(e,this.url)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","./local.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs","./location.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs","./npm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./location.cjs"),s),a(e("./npm.cjs"),s),a(e("./local.cjs"),s),a(e("./http.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,s)}function a(e,t){return e.get(i(e,t))}function i(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.LocalLocation=void 0;const o=e("@metamask/snaps-utils"),r=e("@metamask/utils"),c=e("./http.cjs");var l=new WeakMap;function m(e){return(0,r.assert)(e.data.canonicalPath!==undefined),e.data.canonicalPath=`local:${e.data.canonicalPath}`,e}s.LocalLocation=class{constructor(e,t={}){var s,a,m;n(this,l,void 0),(0,r.assertStruct)(e.toString(),o.LocalSnapIdStruct,"Invalid Snap Id"),(0,r.assert)(t.fetchOptions===undefined,"Currently adding fetch options to local: is unsupported."),s=l,a=this,m=new c.HttpLocation(new URL(e.toString().slice(o.SnapIdPrefixes.local.length)),{...t,fetchOptions:{cache:"no-cache"}}),s.set(i(s,a),m)}async manifest(){return m(await a(l,this).manifest())}async fetch(e){return m(await a(l,this).fetch(e))}get shouldAlwaysReload(){return!0}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs",{"./http.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/http.cjs","./local.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/local.cjs","./npm.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.detectSnapLocation=void 0;const n=e("@metamask/utils"),a=e("./http.cjs"),i=e("./local.cjs"),o=e("./npm.cjs");s.detectSnapLocation=function(e,t){const s=(null==t?void 0:t.allowHttp)??!1,r=(null==t?void 0:t.allowLocal)??!1,c=new URL(e);switch(c.protocol){case"npm:":return new o.NpmLocation(c,t);case"local:":return(0,n.assert)(r,new TypeError("Fetching local snaps is disabled.")),new i.LocalLocation(c,t);case"http:":case"https:":return(0,n.assert)(s,new TypeError("Fetching snaps through http/https is disabled.")),new a.HttpLocation(c,t);default:throw new TypeError(`Unrecognized "${c.protocol}" snap location protocol.`)}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/location.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs",{"@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","concat-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js","get-npm-tarball-url":"/home/runner/work/metamask-extension/metamask-extension/node_modules/get-npm-tarball-url/lib/index.js","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js","readable-web-to-node-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-web-to-node-stream/lib/index.js","tar-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function o(e,t,s){return e.set(c(e,t),s),s}function r(e,t){return e.get(c(e,t))}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}var l=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getNpmCanonicalBasePath=s.fetchNpmMetadata=s.NpmLocation=s.TARBALL_SIZE_SAFETY_LIMIT=s.BaseNpmLocation=s.DEFAULT_NPM_REGISTRY=void 0;const m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=l(e("concat-stream")),h=l(e("get-npm-tarball-url")),p=e("readable-stream"),f=e("readable-web-to-node-stream"),g=e("tar-stream");s.DEFAULT_NPM_REGISTRY=new URL("https://registry.npmjs.org");var b=new WeakMap,k=new WeakMap,y=new WeakSet;class w{constructor(e,t={}){var o,r;a(o=this,r=y),r.add(o),i(this,"meta",void 0),n(this,b,void 0),n(this,k,void 0);const c=t.allowCustomRegistries??!1,l=t.fetch??globalThis.fetch.bind(undefined),u=t.versionRange??m.DEFAULT_REQUESTED_SNAP_VERSION,h=t.resolveVersion??(async e=>e);let p;(0,d.assertStruct)(e.toString(),m.NpmSnapIdStruct,"Invalid Snap Id: "),""===e.host&&""===e.port&&""===e.username&&""===e.password?p=s.DEFAULT_NPM_REGISTRY:(p="https://",e.username&&(p+=e.username,e.password&&(p+=`:${e.password}`),p+="@"),p+=e.host,p=new URL(p),(0,d.assert)(c,new TypeError(`Custom NPM registries are disabled, tried to use "${p.toString()}".`))),(0,d.assert)("/"===p.pathname&&""===p.search&&""===p.hash),(0,d.assert)(""!==e.pathname&&"/"!==e.pathname,new TypeError("The package name in NPM location is empty."));let f=e.pathname;f.startsWith("/")&&(f=f.slice(1)),this.meta={requestedRange:u,registry:p,packageName:f,fetch:l,resolveVersion:h}}async manifest(){if(r(b,this))return r(b,this).clone();const e=await this.fetch("snap.manifest.json"),t=(0,m.parseJson)(e.toString());return e.result=(0,m.createSnapManifest)(t),o(b,this,e),this.manifest()}async fetch(e){const t=(0,m.normalizeRelative)(e);r(k,this)||(await c(y,this,S).call(this),(0,d.assert)(r(k,this)!==undefined));const s=r(k,this).get(t);return(0,d.assert)(s!==undefined,new TypeError(`File "${e}" not found in package.`)),s.clone()}get packageName(){return this.meta.packageName}get version(){return(0,d.assert)(this.meta.version!==undefined,"Tried to access version without first fetching NPM package."),this.meta.version}get registry(){return this.meta.registry}get versionRange(){return this.meta.requestedRange}}async function S(){(0,d.assert)(r(k,this)===undefined);const e=await this.meta.resolveVersion(this.meta.requestedRange),{tarballURL:t,targetVersion:s}=await async function(e,t,s,n){var a;if(x(s)&&(0,d.isValidSemVerVersion)(t))return{tarballURL:(0,h.default)(e,t),targetVersion:t};const i=await _(e,s,n),o=Object.keys((null==i?void 0:i.versions)??{}).map((e=>((0,d.assertIsSemVerVersion)(e),e))),r=(0,m.getTargetVersion)(o,t);if(null===r)throw new Error(`Failed to find a matching version in npm metadata for package "${e}" and requested semver range "${t}".`);const c=null==i||null===(a=i.versions)||void 0===a||null===(a=a[r])||void 0===a||null===(a=a.dist)||void 0===a?void 0:a.tarball;return{tarballURL:c,targetVersion:r}}(this.meta.packageName,e,this.meta.registry,this.meta.fetch);if(!(0,m.isValidUrl)(t)||!t.toString().endsWith(".tgz"))throw new Error(`Failed to find valid tarball URL in NPM metadata for package "${this.meta.packageName}".`);const n=new URL(t);n.hostname=this.meta.registry.hostname,n.protocol=this.meta.registry.protocol;const a=await this.fetchNpmTarball(n);o(k,this,a),this.meta.version=s}s.BaseNpmLocation=w,s.TARBALL_SIZE_SAFETY_LIMIT=262144e3;async function _(e,t,s){const n=await s(new URL(e,t).toString(),{headers:{accept:x(t)?"application/vnd.npm.install-v1+json; q=1.0, application/json; q=0.8, */*":"application/json"}});if(!n.ok)throw new Error(`Failed to fetch NPM registry entry. Status code: ${n.status}.`);const a=await n.json();if(!(0,d.isObject)(a))throw new Error(`Failed to fetch package "${e}" metadata from npm.`);return a}function v(e,t){let s="npm://";return""!==e.username&&(s+=e.username,""!==e.password&&(s+=`:${e.password}`),s+="@"),`${s}${e.host}/${t}/`}function x(e){return e.toString()===s.DEFAULT_NPM_REGISTRY.toString()}s.NpmLocation=class extends w{async fetchNpmTarball(e){const t=await this.meta.fetch(e.toString());if(!t.ok||!t.body)throw new Error(`Failed to fetch tarball for package "${this.meta.packageName}".`);const n=t.headers.get("content-length");(0,d.assert)(n,"Snap tarball has invalid content-length");const a=parseInt(n,10);return(0,d.assert)(a<=s.TARBALL_SIZE_SAFETY_LIMIT,"Snap tarball exceeds size limit"),new Promise(((e,n)=>{const a=new Map,i=function(e,t){(0,d.assert)(e.endsWith("/"),"Base needs to end with '/' for relative paths to be added as children instead of siblings."),(0,d.assert)(e.startsWith("npm:"),'Protocol mismatch, expected "npm:".');const n=(0,g.extract)();let a=0;return n.on("entry",((i,o,r)=>{const{name:c,type:l}=i;if("file"===l){const i=c.replace(P,"");return o.pipe((0,u.default)({encoding:"uint8array"},(o=>{try{a+=o.byteLength,(0,d.assert)(a<s.TARBALL_SIZE_SAFETY_LIMIT,`Snap tarball exceeds limit of ${s.TARBALL_SIZE_SAFETY_LIMIT} bytes.`);const n=new m.VirtualFile({value:o,path:i,data:{canonicalPath:new URL(i,e).toString()}});return(0,d.assert)(!t.has(i),"Malformed tarball, multiple files with the same path."),t.set(i,n),r()}catch(e){return n.destroy(e)}})))}return o.on("end",(()=>r())),o.resume()})),n}(v(this.meta.registry,this.meta.packageName),a),o=t.body,r=new DecompressionStream("gzip"),c=o.pipeThrough(r);(0,p.pipeline)(function(e){if("function"!=typeof e.getReader)return e;return new f.ReadableWebToNodeStream(e)}(c),i,(t=>{t?n(t):e(a)}))}))}},s.fetchNpmMetadata=_,s.getNpmCanonicalBasePath=v;const P=/^package\//u}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/location/npm.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs",{"./json.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs","./registry.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./registry.cjs"),s),a(e("./json.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs",{"./registry.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs","@metamask/base-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/base-controller/dist/index.cjs","@metamask/snaps-registry":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/index.js","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t){return e.get(r(e,t))}function o(e,t,s){return e.set(r(e,t),s),s}function r(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.JsonSnapsRegistry=void 0;const c=e("@metamask/base-controller"),l=e("@metamask/snaps-registry"),m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=e("./registry.cjs"),h={database:null,lastUpdated:null,databaseUnavailable:!1};var p=new WeakMap,f=new WeakMap,g=new WeakMap,b=new WeakMap,k=new WeakMap,y=new WeakMap,w=new WeakSet;class S extends c.BaseController{constructor({messenger:e,state:t,url:s={registry:"https://acl.execution.metamask.io/latest/registry.json",signature:"https://acl.execution.metamask.io/latest/signature.json"},publicKey:i="0x025b65308f0f0fb8bc7f7ff87bfc296e0330eee5d3c1d1ee4a048b2fd6a86fa0a6",fetchFunction:c=globalThis.fetch.bind(undefined),recentFetchThreshold:l=(0,d.inMilliseconds)(5,d.Duration.Minute),refetchOnAllowlistMiss:m=!0}){var u,S;super({messenger:e,metadata:{database:{persist:!0,anonymous:!1},lastUpdated:{persist:!0,anonymous:!1},databaseUnavailable:{persist:!0,anonymous:!1}},name:"SnapsRegistry",state:{...h,...t}}),a(u=this,S=w),S.add(u),n(this,p,void 0),n(this,f,void 0),n(this,g,void 0),n(this,b,void 0),n(this,k,void 0),n(this,y,void 0),o(p,this,s),o(f,this,i),o(g,this,c),o(b,this,l),o(k,this,m),o(y,this,null),this.messagingSystem.registerActionHandler("SnapsRegistry:get",(async(...e)=>r(w,this,E).call(this,...e))),this.messagingSystem.registerActionHandler("SnapsRegistry:getMetadata",((...e)=>r(w,this,C).call(this,...e))),this.messagingSystem.registerActionHandler("SnapsRegistry:resolveVersion",(async(...e)=>r(w,this,T).call(this,...e))),this.messagingSystem.registerActionHandler("SnapsRegistry:update",(async()=>r(w,this,v).call(this)))}}function _(){return this.state.lastUpdated&&Date.now()-this.state.lastUpdated<i(b,this)}async function v(){i(y,this)?await i(y,this):(null===i(y,this)&&o(y,this,r(w,this,x).call(this)),await i(y,this),o(y,this,null))}async function x(){if(!r(w,this,_).call(this))try{const[e,t]=await Promise.all([r(w,this,O).call(this,i(p,this).registry),r(w,this,O).call(this,i(p,this).signature)]);r(w,this,I).call(this,e,t),this.update((t=>{t.database=JSON.parse(e),t.lastUpdated=Date.now(),t.databaseUnavailable=!1}))}catch{this.update((e=>{e.databaseUnavailable=!0}))}}async function P(){return null===this.state.database&&await r(w,this,v).call(this),this.state.database}async function j(e,t,s=!1){var n;const a=await r(w,this,P).call(this),o=null==a?void 0:a.blockedSnaps.find((s=>"id"in s?s.id===e&&(0,d.satisfiesVersionRange)(t.version,s.versionRange):s.checksum===t.checksum));if(o)return{status:u.SnapsRegistryStatus.Blocked,reason:o.reason};const c=null==a?void 0:a.verifiedSnaps[e],l=null==c||null===(n=c.versions)||void 0===n?void 0:n[t.version];return l&&l.checksum===t.checksum?{status:u.SnapsRegistryStatus.Verified}:i(k,this)&&!s?(await r(w,this,v).call(this),r(w,this,j).call(this,e,t,!0)):{status:this.state.databaseUnavailable?u.SnapsRegistryStatus.Unavailable:u.SnapsRegistryStatus.Unverified}}async function E(e){return Object.entries(e).reduce((async(e,[t,s])=>{const n=await r(w,this,j).call(this,t,s),a=await e;return a[t]=n,a}),Promise.resolve({}))}async function T(e,t,s=!1){var n;const a=await r(w,this,P).call(this),o=(null==a||null===(n=a.verifiedSnaps[e])||void 0===n?void 0:n.versions)??null;if(!o&&i(k,this)&&!s)return await r(w,this,v).call(this),r(w,this,T).call(this,e,t,!0);if(!o)return t;const c=(0,m.getTargetVersion)(Object.keys(o),t);return c||!i(k,this)||s?c?((0,d.assertIsSemVerRange)(c),c):t:(await r(w,this,v).call(this),r(w,this,T).call(this,e,t,!0))}function C(e){var t;return(null===(t=this.state)||void 0===t||null===(t=t.database)||void 0===t||null===(t=t.verifiedSnaps[e])||void 0===t?void 0:t.metadata)??null}function I(e,t){(0,d.assert)(i(f,this),"No public key provided.");const s=(0,l.verify)({registry:e,signature:JSON.parse(t),publicKey:i(f,this)});(0,d.assert)(s,"Invalid registry signature.")}async function O(e){const t=await i(g,this).call(this,e);if(!t.ok)throw new Error(`Failed to fetch ${e}.`);return await t.text()}s.JsonSnapsRegistry=S}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/json.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n;Object.defineProperty(s,"__esModule",{value:!0}),s.SnapsRegistryStatus=void 0,function(e){e[e.Unverified=0]="Unverified",e[e.Blocked=1]="Blocked",e[e.Verified=2]="Verified",e[e.Unavailable=3]="Unavailable"}(n||(s.SnapsRegistryStatus=n={}))}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/registry/registry.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getRunnableSnaps=void 0;s.getRunnableSnaps=e=>e.filter((e=>e.enabled&&!e.blocked))}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/snaps/selectors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/utils.cjs",{"./snaps/Timer.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/Timer.cjs","@metamask/snaps-sdk":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-sdk/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","fast-deep-equal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-deep-equal/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.isLocalSnapId=s.isTrackableHandler=s.throttleTracking=s.TRACKABLE_HANDLERS=s.debouncePersistState=s.fetchSnap=s.getSnapFiles=s.withTimeout=s.hasTimedOut=s.delayWithTimer=s.delay=s.permissionsDiff=s.setDiff=void 0;const a=e("@metamask/snaps-sdk"),i=e("@metamask/snaps-utils"),o=n(e("fast-deep-equal")),r=e("./snaps/Timer.cjs");function c(e,t){let s;const n=new Promise(((n,a)=>{e.start((()=>{t===undefined?n():n(t)})),s=a}));return n.cancel=()=>{"finished"!==e.status&&(e.cancel(),s(new Error("The delay has been canceled.")))},n}async function l(e,t){return t&&0!==t.length?await Promise.all(t.map((async t=>e.fetch(t)))):[]}s.setDiff=function(e,t){return Object.entries(e).reduce(((e,[s,n])=>(s in t||(e[s]=n),e)),{})},s.permissionsDiff=function(e,t){return Object.entries(e).reduce(((e,[s,n])=>{const a=s in t;return(!a||a&&!(0,o.default)(n.caveats??[],t[s].caveats??[]))&&(e[s]=n),e}),{})},s.delay=function(e,t){return c(new r.Timer(e),t)},s.delayWithTimer=c,s.hasTimedOut=Symbol("Used to check if the requested promise has timeout (see withTimeout)"),s.withTimeout=async function(e,t){const n=c("number"==typeof t?new r.Timer(t):t,s.hasTimedOut);try{return await Promise.race([e,n])}finally{n.cancel()}},s.getSnapFiles=l,s.fetchSnap=async function(e,t){try{const e=await t.manifest(),s=await t.fetch(e.result.source.location.npm.filePath);(0,a.assert)(s.size<i.MAX_FILE_SIZE,"Snap source code must be smaller than 64 MB.");const{iconPath:n}=e.result.source.location.npm,o=n?await t.fetch(n):undefined,r=await l(t,e.result.source.files);(0,i.validateAuxiliaryFiles)(r),await Promise.all(r.map((async e=>{e.data.base64=await(0,i.encodeBase64)(e)})));const c=await l(t,e.result.source.locales),m={manifest:e,sourceCode:s,svgIcon:o,auxiliaryFiles:r,localizationFiles:(0,i.getValidatedLocalizationFiles)(c)};return await(0,i.validateFetchedSnap)(m),m}catch(t){throw new Error(`Failed to fetch snap "${e}": ${(0,a.getErrorMessage)(t)}.`)}},s.debouncePersistState=function(e,t=1e3){const s=new Map;return(n,a,i)=>{const o=`${n}-${i}`;s.has(o)&&clearTimeout(s.get(o)),s.set(o,setTimeout((()=>{e(n,a,i),s.delete(o)}),t))}},s.TRACKABLE_HANDLERS=Object.freeze([i.HandlerType.OnHomePage,i.HandlerType.OnInstall,i.HandlerType.OnNameLookup,i.HandlerType.OnRpcRequest,i.HandlerType.OnSignature,i.HandlerType.OnTransaction,i.HandlerType.OnUpdate]),s.throttleTracking=function(e,t=6e4){const s=new Map,n=new Map;return(a,i,o,r)=>{const c=`${a}${i}${o}${r}`,l=Date.now(),m=s.get(c)??0,d=[a,i,o,r];if(l-m>=t)return s.set(c,l),void e(...d);const u=n.get(c);null!=u&&u.timer&&clearTimeout(u.timer),s.set(c,l),n.set(c,{args:d,timer:setTimeout((()=>{e(...d),n.delete(c)}),t)})}},s.isTrackableHandler=function(e){return s.TRACKABLE_HANDLERS.includes(e)},s.isLocalSnapId=function(e){return e.startsWith("local:")}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/utils.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs",{"../snaps/index.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/snaps/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/snaps-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-utils/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",nanoid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/nanoid/index.browser.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function n(e,t,s){a(e,t),t.set(e,s)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t,s){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var s=e[Symbol.toPrimitive];if(void 0!==s){var n=s.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:s,enumerable:!0,configurable:!0,writable:!0}):e[t]=s,e}function o(e,t){return e.get(c(e,t))}function r(e,t,s){return e.set(c(e,t),s),s}function c(e,t,s){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:s;throw new TypeError("Private element is not present on this object")}Object.defineProperty(s,"__esModule",{value:!0}),s.WebSocketService=void 0;const l=e("@metamask/rpc-errors"),m=e("@metamask/snaps-utils"),d=e("@metamask/utils"),u=e("nanoid"),h=e("../snaps/index.cjs"),p="WebSocketService";var f=new WeakMap,g=new WeakMap,b=new WeakSet;function k(e,t){const s=o(g,this).get(t);return(0,d.assert)(s&&s.snapId===e,`Socket with ID "${t}" not found.`),s}function y(e,t,s){return c(b,this,P).call(this,e).some((e=>e.url===t&&(0,m.isEqual)(e.protocols,s)))}function w(e,t){o(f,this).call("SnapController:handleRequest",{origin:h.METAMASK_ORIGIN,snapId:e,handler:m.HandlerType.OnWebSocketEvent,request:{method:"",params:{event:t}}}).catch((t=>{(0,m.logError)(`An error occurred while handling a WebSocket message for Snap "${e}":`,t)}))}async function S(e,t,s=[]){(0,d.assert)(!c(b,this,y).call(this,e,t,s),`An open WebSocket connection to ${t} already exists.`);const n=new URL(t),{origin:a}=n,i=(0,u.nanoid)(),r=new WebSocket(t,s);r.binaryType="arraybuffer";const{promise:m,resolve:h,reject:p}=(0,d.createDeferredPromise)();r.addEventListener("open",(()=>{h(),c(b,this,w).call(this,e,{type:"open",id:i,origin:a})})),r.addEventListener("close",(t=>{o(g,this).delete(i),c(b,this,w).call(this,e,{type:"close",id:i,origin:a,code:t.code,reason:t.reason,wasClean:t.wasClean??null})}));const f=()=>{p(l.rpcErrors.resourceUnavailable("An error occurred while opening the WebSocket."))};return r.addEventListener("error",f),r.addEventListener("message",(t=>{const s="string"==typeof t.data?{type:"text",message:t.data}:{type:"binary",message:Array.from(new Uint8Array(t.data))};c(b,this,w).call(this,e,{type:"message",id:i,origin:a,data:s})})),o(g,this).set(i,{id:i,snapId:e,url:t,protocols:s,socket:r,openPromise:m}),await m,r.removeEventListener("error",f),i}function _(e,t){const{socket:s}=c(b,this,k).call(this,e,t);s.close()}function v(e){for(const t of c(b,this,P).call(this,e))c(b,this,_).call(this,e,t.id)}async function x(e,t,s){const{socket:n,openPromise:a}=c(b,this,k).call(this,e,t);await a;const i=Array.isArray(s)?new Uint8Array(s):s;n.send(i)}function P(e){return[...o(g,this).values()].filter((t=>t.snapId===e)).map((e=>({id:e.id,url:e.url,protocols:e.protocols})))}s.WebSocketService=class{constructor({messenger:e}){var t,s;a(t=this,s=b),s.add(t),i(this,"name",p),i(this,"state",null),n(this,f,void 0),n(this,g,void 0),r(f,this,e),r(g,this,new Map),o(f,this).registerActionHandler(`${p}:open`,(async(...e)=>c(b,this,S).call(this,...e))),o(f,this).registerActionHandler(`${p}:close`,((...e)=>c(b,this,_).call(this,...e))),o(f,this).registerActionHandler(`${p}:sendMessage`,(async(...e)=>c(b,this,x).call(this,...e))),o(f,this).registerActionHandler(`${p}:getAll`,((...e)=>c(b,this,P).call(this,...e))),o(f,this).subscribe("SnapController:snapUpdated",(e=>{c(b,this,v).call(this,e.id)})),o(f,this).subscribe("SnapController:snapUninstalled",(e=>{c(b,this,v).call(this,e.id)})),o(f,this).subscribe("SnapController:snapInstalled",(e=>{c(b,this,v).call(this,e.id)}))}}}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs",{"./WebSocketService.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/dist/websocket/WebSocketService.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]},a=function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),a(e("./WebSocketService.cjs"),s)}}},{package:"@metamask/snaps-controllers",file:"node_modules/@metamask/snaps-controllers/dist/websocket/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","buffer-from":"/home/runner/work/metamask-extension/metamask-extension/node_modules/buffer-from/index.js",inherits:"/home/runner/work/metamask-extension/metamask-extension/node_modules/inherits/inherits_browser.js","readable-stream":"/home/runner/work/metamask-extension/metamask-extension/node_modules/readable-stream/readable-browser.js",typedarray:"/home/runner/work/metamask-extension/metamask-extension/node_modules/typedarray/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var n=e("readable-stream").Writable,a=e("inherits"),i=e("buffer-from");if("undefined"==typeof Uint8Array)var o=e("typedarray").Uint8Array;else o=Uint8Array;function r(e,t){if(!(this instanceof r))return new r(e,t);"function"==typeof e&&(t=e,e={}),e||(e={});var s=e.encoding,a=!1;s?"u8"!==(s=String(s).toLowerCase())&&"uint8"!==s||(s="uint8array"):a=!0,n.call(this,{objectMode:!0}),this.encoding=s,this.shouldInferEncoding=a,t&&this.on("finish",(function(){t(this.getBody())})),this.body=[]}t.exports=r,a(r,n),r.prototype._write=function(e,t,s){this.body.push(e),s()},r.prototype.inferEncoding=function(e){var t=e===undefined?this.body[0]:e;return s.isBuffer(t)?"buffer":"undefined"!=typeof Uint8Array&&t instanceof Uint8Array?"uint8array":Array.isArray(t)?"array":"string"==typeof t?"string":"[object Object]"===Object.prototype.toString.call(t)?"object":"buffer"},r.prototype.getBody=function(){return this.encoding||0!==this.body.length?(this.shouldInferEncoding&&(this.encoding=this.inferEncoding()),"array"===this.encoding?function(e){for(var t=[],s=0;s<e.length;s++)t.push.apply(t,e[s]);return t}(this.body):"string"===this.encoding?function(e){for(var t=[],n=0;n<e.length;n++){var a=e[n];"string"==typeof a||s.isBuffer(a)?t.push(a):c(a)?t.push(i(a)):t.push(i(String(a)))}t=s.isBuffer(e[0])?(t=s.concat(t)).toString("utf8"):t.join("");return t}(this.body):"buffer"===this.encoding?function(e){for(var t=[],n=0;n<e.length;n++){var a=e[n];s.isBuffer(a)?t.push(a):c(a)?t.push(i(a)):t.push(i(String(a)))}return s.concat(t)}(this.body):"uint8array"===this.encoding?function(e){for(var t=0,s=0;s<e.length;s++)"string"==typeof e[s]&&(e[s]=i(e[s])),t+=e[s].length;for(var n=new o(t),a=(s=0,0);s<e.length;s++)for(var r=e[s],c=0;c<r.length;c++)n[a++]=r[c];return n}(this.body):this.body):[]};Array.isArray;function c(e){return"string"==typeof e||(t=e,/Array\]$/.test(Object.prototype.toString.call(t)))||e&&"function"==typeof e.subarray;var t}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/snaps-controllers>concat-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/concat-stream/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js",{fs:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browser-resolve/empty.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const n={S_IFMT:61440,S_IFDIR:16384,S_IFCHR:8192,S_IFBLK:24576,S_IFIFO:4096,S_IFLNK:40960};try{t.exports=e("fs").constants||n}catch{t.exports=n}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js",{"./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js","fast-fifo":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-fifo/index.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const{Writable:n,Readable:a,getStreamError:i}=e("streamx"),o=e("fast-fifo"),r=e("b4a"),c=e("./headers"),l=r.alloc(0);class m{constructor(){this.buffered=0,this.shifted=0,this.queue=new o,this._offset=0}push(e){this.buffered+=e.byteLength,this.queue.push(e)}shiftFirst(e){return 0===this._buffered?null:this._next(e)}shift(e){if(e>this.buffered)return null;if(0===e)return l;let t=this._next(e);if(e===t.byteLength)return t;const s=[t];for(;(e-=t.byteLength)>0;)t=this._next(e),s.push(t);return r.concat(s)}_next(e){const t=this.queue.peek(),s=t.byteLength-this._offset;if(e>=s){const e=this._offset?t.subarray(this._offset,t.byteLength):t;return this.queue.shift(),this._offset=0,this.buffered-=s,this.shifted+=s,e}return this.buffered-=e,this.shifted+=e,t.subarray(this._offset,this._offset+=e)}}class d extends a{constructor(e,t,s){super(),this.header=t,this.offset=s,this._parent=e}_read(e){0===this.header.size&&this.push(null),this._parent._stream===this&&this._parent._update(),e(null)}_predestroy(){this._parent.destroy(i(this))}_detach(){this._parent._stream===this&&(this._parent._stream=null,this._parent._missing=p(this.header.size),this._parent._update())}_destroy(e){this._detach(),e(null)}}class u extends n{constructor(e){super(e),e||(e={}),this._buffer=new m,this._offset=0,this._header=null,this._stream=null,this._missing=0,this._longHeader=!1,this._callback=h,this._locked=!1,this._finished=!1,this._pax=null,this._paxGlobal=null,this._gnuLongPath=null,this._gnuLongLinkPath=null,this._filenameEncoding=e.filenameEncoding||"utf-8",this._allowUnknownFormat=!!e.allowUnknownFormat,this._unlockBound=this._unlock.bind(this)}_unlock(e){if(this._locked=!1,e)return this.destroy(e),void this._continueWrite(e);this._update()}_consumeHeader(){if(this._locked)return!1;this._offset=this._buffer.shifted;try{this._header=c.decode(this._buffer.shift(512),this._filenameEncoding,this._allowUnknownFormat)}catch(e){return this._continueWrite(e),!1}if(!this._header)return!0;switch(this._header.type){case"gnu-long-path":case"gnu-long-link-path":case"pax-global-header":case"pax-header":return this._longHeader=!0,this._missing=this._header.size,!0}return this._locked=!0,this._applyLongHeaders(),0===this._header.size||"directory"===this._header.type?(this.emit("entry",this._header,this._createStream(),this._unlockBound),!0):(this._stream=this._createStream(),this._missing=this._header.size,this.emit("entry",this._header,this._stream,this._unlockBound),!0)}_applyLongHeaders(){this._gnuLongPath&&(this._header.name=this._gnuLongPath,this._gnuLongPath=null),this._gnuLongLinkPath&&(this._header.linkname=this._gnuLongLinkPath,this._gnuLongLinkPath=null),this._pax&&(this._pax.path&&(this._header.name=this._pax.path),this._pax.linkpath&&(this._header.linkname=this._pax.linkpath),this._pax.size&&(this._header.size=parseInt(this._pax.size,10)),this._header.pax=this._pax,this._pax=null)}_decodeLongHeader(e){switch(this._header.type){case"gnu-long-path":this._gnuLongPath=c.decodeLongPath(e,this._filenameEncoding);break;case"gnu-long-link-path":this._gnuLongLinkPath=c.decodeLongPath(e,this._filenameEncoding);break;case"pax-global-header":this._paxGlobal=c.decodePax(e);break;case"pax-header":this._pax=null===this._paxGlobal?c.decodePax(e):Object.assign({},this._paxGlobal,c.decodePax(e))}}_consumeLongHeader(){this._longHeader=!1,this._missing=p(this._header.size);const e=this._buffer.shift(this._header.size);try{this._decodeLongHeader(e)}catch(e){return this._continueWrite(e),!1}return!0}_consumeStream(){const e=this._buffer.shiftFirst(this._missing);if(null===e)return!1;this._missing-=e.byteLength;const t=this._stream.push(e);return 0===this._missing?(this._stream.push(null),t&&this._stream._detach(),t&&!1===this._locked):t}_createStream(){return new d(this,this._header,this._offset)}_update(){for(;this._buffer.buffered>0&&!this.destroying;)if(this._missing>0){if(null!==this._stream){if(!1===this._consumeStream())return;continue}if(!0===this._longHeader){if(this._missing>this._buffer.buffered)break;if(!1===this._consumeLongHeader())return!1;continue}const e=this._buffer.shiftFirst(this._missing);null!==e&&(this._missing-=e.byteLength)}else{if(this._buffer.buffered<512)break;if(null!==this._stream||!1===this._consumeHeader())return}this._continueWrite(null)}_continueWrite(e){const t=this._callback;this._callback=h,t(e)}_write(e,t){this._callback=t,this._buffer.push(e),this._update()}_final(e){this._finished=0===this._missing&&0===this._buffer.buffered,e(this._finished?null:new Error("Unexpected end of data"))}_predestroy(){this._continueWrite(null)}_destroy(e){this._stream&&this._stream.destroy(i(this)),e(null)}[Symbol.asyncIterator](){let e=null,t=null,s=null,n=null,a=null;const i=this;return this.on("entry",(function(e,i,o){a=o,i.on("error",h),t?(t({value:i,done:!1}),t=s=null):n=i})),this.on("error",(t=>{e=t})),this.on("close",(function(){if(o(e),!t)return;e?s(e):t({value:undefined,done:!0});t=s=null})),{[Symbol.asyncIterator](){return this},next:()=>new Promise(r),return:()=>c(null),throw:e=>c(e)};function o(e){if(!a)return;const t=a;a=null,t(e)}function r(a,r){return e?r(e):n?(a({value:n,done:!1}),void(n=null)):(t=a,s=r,o(null),void(i._finished&&t&&(t({value:undefined,done:!0}),t=s=null)))}function c(e){return i.destroy(e),o(e),new Promise(((t,s)=>{if(i.destroyed)return t({value:undefined,done:!0});i.once("close",(function(){e?s(e):t({value:undefined,done:!0})}))}))}}}function h(){}function p(e){return(e&=511)&&512-e}t.exports=function(e){return new u(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",{b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const n=e("b4a"),a="0000000000000000000",i="7777777777777777777",o="0".charCodeAt(0),r=n.from([117,115,116,97,114,0]),c=n.from([o,o]),l=n.from([117,115,116,97,114,32]),m=n.from([32,0]),d=257,u=263;function h(e,t,s,n){for(;s<n;s++)if(e[s]===t)return s;return n}function p(e){let t=256;for(let s=0;s<148;s++)t+=e[s];for(let s=156;s<512;s++)t+=e[s];return t}function f(e,t){return(e=e.toString(8)).length>t?i.slice(0,t)+" ":a.slice(0,t-e.length)+e+" "}function g(e,t,s){if(128&(e=e.subarray(t,t+s))[t=0])return function(e){let t;if(128===e[0])t=!0;else{if(255!==e[0])return null;t=!1}const s=[];let n;for(n=e.length-1;n>0;n--){const a=e[n];t?s.push(a):s.push(255-a)}let a=0;const i=s.length;for(n=0;n<i;n++)a+=s[n]*Math.pow(256,n);return t?a:-1*a}(e);{for(;t<e.length&&32===e[t];)t++;const s=(a=h(e,32,t,e.length),i=e.length,o=e.length,"number"!=typeof a?o:(a=~~a)>=i?i:a>=0||(a+=i)>=0?a:0);for(;t<s&&0===e[t];)t++;return s===t?0:parseInt(n.toString(e.subarray(t,s)),8)}var a,i,o}function b(e,t,s,a){return n.toString(e.subarray(t,h(e,0,t,t+s)),a)}function k(e){const t=n.byteLength(e);let s=Math.floor(Math.log(t)/Math.log(10))+1;return t+s>=Math.pow(10,s)&&s++,t+s+e}s.decodeLongPath=function(e,t){return b(e,0,e.length,t)},s.encodePax=function(e){let t="";e.name&&(t+=k(" path="+e.name+"\n")),e.linkname&&(t+=k(" linkpath="+e.linkname+"\n"));const s=e.pax;if(s)for(const e in s)t+=k(" "+e+"="+s[e]+"\n");return n.from(t)},s.decodePax=function(e){const t={};for(;e.length;){let s=0;for(;s<e.length&&32!==e[s];)s++;const a=parseInt(n.toString(e.subarray(0,s)),10);if(!a)return t;const i=n.toString(e.subarray(s+1,a-1)),o=i.indexOf("=");if(-1===o)return t;t[i.slice(0,o)]=i.slice(o+1),e=e.subarray(a)}return t},s.encode=function(e){const t=n.alloc(512);let s=e.name,a="";if(5===e.typeflag&&"/"!==s[s.length-1]&&(s+="/"),n.byteLength(s)!==s.length)return null;for(;n.byteLength(s)>100;){const e=s.indexOf("/");if(-1===e)return null;a+=a?"/"+s.slice(0,e):s.slice(0,e),s=s.slice(e+1)}return n.byteLength(s)>100||n.byteLength(a)>155||e.linkname&&n.byteLength(e.linkname)>100?null:(n.write(t,s),n.write(t,f(4095&e.mode,6),100),n.write(t,f(e.uid,6),108),n.write(t,f(e.gid,6),116),function(e,t,s){e.toString(8).length>11?function(e,t,s){t[s]=128;for(let n=11;n>0;n--)t[s+n]=255&e,e=Math.floor(e/256)}(e,t,s):n.write(t,f(e,11),s)}(e.size,t,124),n.write(t,f(e.mtime.getTime()/1e3|0,11),136),t[156]=o+function(e){switch(e){case"file":return 0;case"link":return 1;case"symlink":return 2;case"character-device":return 3;case"block-device":return 4;case"directory":return 5;case"fifo":return 6;case"contiguous-file":return 7;case"pax-header":return 72}return 0}(e.type),e.linkname&&n.write(t,e.linkname,157),n.copy(r,t,d),n.copy(c,t,263),e.uname&&n.write(t,e.uname,265),e.gname&&n.write(t,e.gname,297),n.write(t,f(e.devmajor||0,6),329),n.write(t,f(e.devminor||0,6),337),a&&n.write(t,a,345),n.write(t,f(p(t),6),148),t)},s.decode=function(e,t,s){let a=0===e[156]?0:e[156]-o,i=b(e,0,100,t);const c=g(e,100,8),h=g(e,108,8),f=g(e,116,8),k=g(e,124,12),y=g(e,136,12),w=function(e){switch(e){case 0:return"file";case 1:return"link";case 2:return"symlink";case 3:return"character-device";case 4:return"block-device";case 5:return"directory";case 6:return"fifo";case 7:return"contiguous-file";case 72:return"pax-header";case 55:return"pax-global-header";case 27:return"gnu-long-link-path";case 28:case 30:return"gnu-long-path"}return null}(a),S=0===e[157]?null:b(e,157,100,t),_=b(e,265,32),v=b(e,297,32),x=g(e,329,8),P=g(e,337,8),j=p(e);if(256===j)return null;if(j!==g(e,148,8))throw new Error("Invalid tar header. Maybe the tar is corrupted or it needs to be gunzipped?");if(function(e){return n.equals(r,e.subarray(d,263))}(e))e[345]&&(i=b(e,345,155,t)+"/"+i);else if(function(e){return n.equals(l,e.subarray(d,263))&&n.equals(m,e.subarray(u,265))}(e));else if(!s)throw new Error("Invalid tar header: unknown format.");return 0===a&&i&&"/"===i[i.length-1]&&(a=5),{name:i,mode:c,uid:h,gid:f,size:k,mtime:new Date(1e3*y),type:w,linkname:S,uname:_,gname:v,devmajor:x,devminor:P,pax:null}}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js",{"./extract":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/extract.js","./pack":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){s.extract=e("./extract"),s.pack=e("./pack")}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js",{"./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/constants.js","./headers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-controllers/node_modules/tar-stream/headers.js",b4a:"/home/runner/work/metamask-extension/metamask-extension/node_modules/b4a/browser.js",streamx:"/home/runner/work/metamask-extension/metamask-extension/node_modules/streamx/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const{Readable:n,Writable:a,getStreamError:i}=e("streamx"),o=e("b4a"),r=e("./constants"),c=e("./headers"),l=o.alloc(1024);class m extends a{constructor(e,t,s){super({mapWritable:p,eagerOpen:!0}),this.written=0,this.header=t,this._callback=s,this._linkname=null,this._isLinkname="symlink"===t.type&&!t.linkname,this._isVoid="file"!==t.type&&"contiguous-file"!==t.type,this._finished=!1,this._pack=e,this._openCallback=null,null===this._pack._stream?this._pack._stream=this:this._pack._pending.push(this)}_open(e){this._openCallback=e,this._pack._stream===this&&this._continueOpen()}_continuePack(e){if(null===this._callback)return;const t=this._callback;this._callback=null,t(e)}_continueOpen(){null===this._pack._stream&&(this._pack._stream=this);const e=this._openCallback;if(this._openCallback=null,null!==e){if(this._pack.destroying)return e(new Error("pack stream destroyed"));if(this._pack._finalized)return e(new Error("pack stream is already finalized"));this._pack._stream=this,this._isLinkname||this._pack._encode(this.header),this._isVoid&&(this._finish(),this._continuePack(null)),e(null)}}_write(e,t){return this._isLinkname?(this._linkname=this._linkname?o.concat([this._linkname,e]):e,t(null)):this._isVoid?e.byteLength>0?t(new Error("No body allowed for this entry")):t():(this.written+=e.byteLength,this._pack.push(e)?t():void(this._pack._drain=t))}_finish(){this._finished||(this._finished=!0,this._isLinkname&&(this.header.linkname=this._linkname?o.toString(this._linkname,"utf-8"):"",this._pack._encode(this.header)),h(this._pack,this.header.size),this._pack._done(this))}_final(e){if(this.written!==this.header.size)return e(new Error("Size mismatch"));this._finish(),e(null)}_getError(){return i(this)||new Error("tar entry destroyed")}_predestroy(){this._pack.destroy(this._getError())}_destroy(e){this._pack._done(this),this._continuePack(this._finished?null:this._getError()),e()}}class d extends n{constructor(e){super(e),this._drain=u,this._finalized=!1,this._finalizing=!1,this._pending=[],this._stream=null}entry(e,t,s){if(this._finalized||this.destroying)throw new Error("already finalized or destroyed");"function"==typeof t&&(s=t,t=null),s||(s=u),e.size&&"symlink"!==e.type||(e.size=0),e.type||(e.type=function(e){switch(e&r.S_IFMT){case r.S_IFBLK:return"block-device";case r.S_IFCHR:return"character-device";case r.S_IFDIR:return"directory";case r.S_IFIFO:return"fifo";case r.S_IFLNK:return"symlink"}return"file"}(e.mode)),e.mode||(e.mode="directory"===e.type?493:420),e.uid||(e.uid=0),e.gid||(e.gid=0),e.mtime||(e.mtime=new Date),"string"==typeof t&&(t=o.from(t));const n=new m(this,e,s);return o.isBuffer(t)?(e.size=t.byteLength,n.write(t),n.end(),n):(n._isVoid,n)}finalize(){this._stream||this._pending.length>0?this._finalizing=!0:this._finalized||(this._finalized=!0,this.push(l),this.push(null))}_done(e){e===this._stream&&(this._stream=null,this._finalizing&&this.finalize(),this._pending.length&&this._pending.shift()._continueOpen())}_encode(e){if(!e.pax){const t=c.encode(e);if(t)return void this.push(t)}this._encodePax(e)}_encodePax(e){const t=c.encodePax({name:e.name,linkname:e.linkname,pax:e.pax}),s={name:"PaxHeader",mode:e.mode,uid:e.uid,gid:e.gid,size:t.byteLength,mtime:e.mtime,type:"pax-header",linkname:e.linkname&&"PaxHeader",uname:e.uname,gname:e.gname,devmajor:e.devmajor,devminor:e.devminor};this.push(c.encode(s)),this.push(t),h(this,t.byteLength),s.size=e.size,s.type=e.type,this.push(c.encode(s))}_doDrain(){const e=this._drain;this._drain=u,e()}_predestroy(){const e=i(this);for(this._stream&&this._stream.destroy(e);this._pending.length;){const t=this._pending.shift();t.destroy(e),t._continueOpen()}this._doDrain()}_read(e){this._doDrain(),e()}}function u(){}function h(e,t){(t&=511)&&e.push(l.subarray(0,512-t))}function p(e){return o.isBuffer(e)?e:o.from(e)}t.exports=function(e){return new d(e)}}}},{package:"@metamask/snaps-controllers>tar-stream",file:"node_modules/@metamask/snaps-controllers/node_modules/tar-stream/pack.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/index.js",{"./verify":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/verify.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var n=this&&this.__createBinding||(Object.create?function(e,t,s,n){n===undefined&&(n=s);var a=Object.getOwnPropertyDescriptor(t,s);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,n,a)}:function(e,t,s,n){n===undefined&&(n=s),e[n]=t[s]}),a=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||n(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.SnapsRegistryDatabaseStruct=s.BlockedSnapStruct=s.BlockReasonStruct=s.VerifiedSnapStruct=s.ImagePathStruct=s.AdditionalSourceCodeStruct=s.SupportStruct=s.AuditStruct=s.AuthorStruct=void 0;const i=e("@metamask/superstruct"),o=e("@metamask/utils"),r=(0,i.refine)((0,i.string)(),"Npm ID",(e=>e.startsWith("npm:"))),c=(0,i.object)({checksum:o.ChecksumStruct});s.AuthorStruct=(0,i.object)({name:(0,i.string)(),website:(0,i.string)()}),s.AuditStruct=(0,i.object)({auditor:(0,i.string)(),report:(0,i.string)()}),s.SupportStruct=(0,i.object)({knowledgeBase:(0,i.optional)((0,i.string)()),faq:(0,i.optional)((0,i.string)()),contact:(0,i.optional)((0,i.string)()),keyRecovery:(0,i.optional)((0,i.string)())}),s.AdditionalSourceCodeStruct=(0,i.object)({name:(0,i.string)(),url:(0,i.string)()}),s.ImagePathStruct=(0,i.pattern)((0,i.string)(),/\.\/images\/.*\/\d+\.(?:png|jpe?g)$/u),s.VerifiedSnapStruct=(0,i.object)({id:r,metadata:(0,i.object)({name:(0,i.string)(),type:(0,i.optional)((0,i.enums)(["account"])),author:(0,i.optional)(s.AuthorStruct),website:(0,i.optional)((0,i.string)()),onboard:(0,i.optional)((0,i.boolean)()),summary:(0,i.optional)((0,i.string)()),description:(0,i.optional)((0,i.string)()),audits:(0,i.optional)((0,i.array)(s.AuditStruct)),category:(0,i.optional)((0,i.enums)(["interoperability","notifications","transaction insights","account management","name resolution"])),tags:(0,i.optional)((0,i.array)((0,i.string)())),support:(0,i.optional)(s.SupportStruct),sourceCode:(0,i.optional)((0,i.string)()),hidden:(0,i.optional)((0,i.boolean)()),privateCode:(0,i.optional)((0,i.boolean)()),privacyPolicy:(0,i.optional)((0,i.string)()),termsOfUse:(0,i.optional)((0,i.string)()),additionalSourceCode:(0,i.optional)((0,i.array)(s.AdditionalSourceCodeStruct)),screenshots:(0,i.optional)((0,i.size)((0,i.array)(s.ImagePathStruct),3,3))}),versions:(0,i.record)(o.VersionStruct,c)}),s.BlockReasonStruct=(0,i.object)({explanation:(0,i.optional)((0,i.string)()),url:(0,i.optional)((0,i.string)())}),s.BlockedSnapStruct=(0,i.union)([(0,i.object)({id:r,versionRange:o.VersionRangeStruct,reason:(0,i.optional)(s.BlockReasonStruct)}),(0,i.object)({checksum:o.ChecksumStruct,reason:(0,i.optional)(s.BlockReasonStruct)})]),s.SnapsRegistryDatabaseStruct=(0,i.object)({verifiedSnaps:(0,i.record)(r,s.VerifiedSnapStruct),blockedSnaps:(0,i.array)(s.BlockedSnapStruct)}),a(e("./verify"),s)}}},{package:"@metamask/snaps-utils>@metamask/snaps-registry",file:"node_modules/@metamask/snaps-registry/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/snaps-registry/dist/verify.js",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@noble/curves/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/curves/secp256k1.js","@noble/hashes/sha256":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha256.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.verify=s.SignatureStruct=void 0;const n=e("@metamask/superstruct"),a=e("@metamask/utils"),i=e("@noble/curves/secp256k1"),o=e("@noble/hashes/sha256");s.SignatureStruct=(0,n.object)({signature:a.StrictHexStruct,curve:(0,n.literal)("secp256k1"),format:(0,n.literal)("DER")}),s.verify=function({registry:e,signature:t,publicKey:n}){(0,a.assertStruct)(t,s.SignatureStruct,"Invalid signature object");const r=(0,a.hexToBytes)(n);return i.secp256k1.verify((0,a.remove0x)(t.signature),(0,o.sha256)((0,a.stringToBytes)(e)),r)}}}},{package:"@metamask/snaps-utils>@metamask/snaps-registry",file:"node_modules/@metamask/snaps-registry/dist/verify.js"}]],[],{});