LavaPack.loadBundle([[2190,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[2191,{"./build/multichain-openrpc.json":2189,"./build/openrpc.json":2190},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.MultiChainOpenRPCDocument=r.MetaMaskOpenRPCDocument=void 0;const s=n(e("./build/openrpc.json"));r.MetaMaskOpenRPCDocument=s.default;const a=n(e("./build/multichain-openrpc.json"));r.MultiChainOpenRPCDocument=a.default,r.default=s.default}}},{package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/api-specs/dist/index.js"}],[2192,{"../scope/constants.cjs":2199,"../scope/transform.cjs":2203,"../scope/types.cjs":2204,"@metamask/controller-utils":1557,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isCaipAccountIdInPermittedAccountIds=r.isInternalAccountInPermittedAccountIds=r.setNonSCACaipAccountIdsInCaip25CaveatValue=r.getCaipAccountIdsFromCaip25CaveatValue=r.getCaipAccountIdsFromScopesObjects=r.setEthAccounts=r.getEthAccounts=void 0;const n=e("@metamask/controller-utils"),s=e("@metamask/utils"),a=e("../scope/constants.cjs"),o=e("../scope/transform.cjs"),i=e("../scope/types.cjs"),c=e=>{const{namespace:t}=(0,i.parseScopeString)(e);return t===s.KnownCaipNamespace.Eip155||e===a.KnownWalletScopeString.Eip155},l=e=>{const t=[];return Object.entries(e).forEach((([e,{accounts:r}])=>{r?.forEach((e=>{const{address:r,chainId:n}=(0,s.parseCaipAccountId)(e);c(n)&&((0,s.assertIsStrictHexString)(r),t.push(r))}))})),t};r.getEthAccounts=e=>{const{requiredScopes:t,optionalScopes:r}=e,n=[...l(t),...l(r)];return(0,o.getUniqueArrayItems)(n)};const d=(e,t)=>{const r={};return Object.entries(e).forEach((([e,n])=>{const a=e,o=a===s.KnownCaipNamespace.Wallet,{namespace:l,reference:d}=(0,i.parseScopeString)(a);if(!c(a)&&!o)return void(r[a]=n);let u=[];l&&d&&(u=t.map((e=>`${l}:${d}:${e}`))),r[a]={...n,accounts:u}})),r};function u(e){const t=new Set;for(const r of e)for(const{accounts:e}of Object.values(r))for(const r of e)t.add(r);return Array.from(t)}r.setEthAccounts=(e,t)=>({...e,requiredScopes:d(e.requiredScopes,t),optionalScopes:d(e.optionalScopes,t)}),r.getCaipAccountIdsFromScopesObjects=u,r.getCaipAccountIdsFromCaip25CaveatValue=function(e){return u([e.requiredScopes,e.optionalScopes])};const h=(e,t)=>{const r=new Map;for(const e of t){const{chain:{namespace:t},address:n}=(0,s.parseCaipAccountId)(e);r.has(t)||r.set(t,new Set),r.get(t)?.add(n)}const n={};for(const[t,s]of Object.entries(e)){const{namespace:e,reference:a}=(0,i.parseScopeString)(t);let c=[];if(e&&a&&r.has(e)){const t=r.get(e);t&&(c=Array.from(t).map((t=>`${e}:${a}:${t}`)))}n[t]={...s,accounts:(0,o.getUniqueArrayItems)(c)}}return n};function p(e,t,r){return!!(e&&t.length&&r.length)&&r.some((r=>{const a=(0,s.parseCaipAccountId)(r);return t.some((({namespace:t,reference:r})=>t===a.chain.namespace&&(t===s.KnownCaipNamespace.Eip155?("0"===r||r===a.chain.reference)&&(0,n.isEqualCaseInsensitive)(e,a.address):r===a.chain.reference&&e===a.address)))}))}r.setNonSCACaipAccountIdsInCaip25CaveatValue=(e,t)=>({...e,requiredScopes:h(e.requiredScopes,t),optionalScopes:h(e.optionalScopes,t)}),r.isInternalAccountInPermittedAccountIds=function(e,t){const r=e.scopes.map((e=>(0,i.parseScopeString)(e)));return p(e.address,r,t)},r.isCaipAccountIdInPermittedAccountIds=function(e,t){const{address:r,chain:n}=(0,s.parseCaipAccountId)(e);return p(r,[n],t)}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-accounts.cjs"}],[2193,{"../caip25Permission.cjs":2195,"../scope/transform.cjs":2203,"../scope/types.cjs":2204,"@metamask/controller-utils":1557,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.setChainIdsInCaip25CaveatValue=r.addCaipChainIdInCaip25CaveatValue=r.getAllScopesFromPermission=r.getAllNamespacesFromCaip25CaveatValue=r.getAllScopesFromCaip25CaveatValue=r.getAllScopesFromScopesObjects=r.setPermittedEthChainIds=r.addPermittedEthChainId=r.getPermittedEthChainIds=void 0;const n=e("@metamask/controller-utils"),s=e("@metamask/utils"),a=e("../caip25Permission.cjs"),o=e("../scope/transform.cjs"),i=e("../scope/types.cjs"),c=e=>{const t=[];return Object.keys(e).forEach((e=>{const{namespace:r,reference:a}=(0,i.parseScopeString)(e);r===s.KnownCaipNamespace.Eip155&&a&&t.push((0,n.toHex)(a))})),t};r.getPermittedEthChainIds=e=>{const{requiredScopes:t,optionalScopes:r}=e,n=[...c(t),...c(r)];return(0,o.getUniqueArrayItems)(n)};r.addPermittedEthChainId=(e,t)=>{const r=`eip155:${(0,s.hexToBigInt)(t).toString(10)}`;return Object.keys(e.requiredScopes).includes(r)||Object.keys(e.optionalScopes).includes(r)?e:{...e,optionalScopes:{...e.optionalScopes,[r]:{accounts:[]}}}};const l=(e,t)=>{const r={};return Object.entries(e).forEach((([e,a])=>{const o=e,{namespace:c,reference:l}=(0,i.parseScopeString)(o);if(l)if(c===s.KnownCaipNamespace.Eip155){const e=(0,n.toHex)(l);t.includes(e)&&(r[o]=a)}else r[o]=a;else r[o]=a})),r};function d(e){const t=new Set;for(const r of e)for(const e of Object.keys(r))t.add(e);return Array.from(t)}function u(e){return d([e.requiredScopes,e.optionalScopes])}r.setPermittedEthChainIds=(e,t)=>{let n={...e,requiredScopes:l(e.requiredScopes,t),optionalScopes:l(e.optionalScopes,t)};return t.forEach((e=>{n=(0,r.addPermittedEthChainId)(n,e)})),n},r.getAllScopesFromScopesObjects=d,r.getAllScopesFromCaip25CaveatValue=u,r.getAllNamespacesFromCaip25CaveatValue=function(e){const t=u(e),r=new Set;for(const e of t){const{namespace:t,reference:n}=(0,i.parseScopeString)(e);t===s.KnownCaipNamespace.Wallet?r.add(n??t):t&&r.add(t)}return Array.from(r)},r.getAllScopesFromPermission=function(e){const t=e.caveats.find((e=>e.type===a.Caip25CaveatType));return t?u(t.value):[]};r.addCaipChainIdInCaip25CaveatValue=(e,t)=>e.requiredScopes[t]||e.optionalScopes[t]?e:{...e,optionalScopes:{...e.optionalScopes,[t]:{accounts:[]}}};r.setChainIdsInCaip25CaveatValue=(e,t)=>{const r=new Set(t),n={requiredScopes:{},optionalScopes:{},sessionProperties:e.sessionProperties,isMultichainOrigin:e.isMultichainOrigin};for(const[t,s]of Object.entries(e.requiredScopes)){const e=t;((0,i.isWalletScope)(e)||r.has(e))&&(n.requiredScopes[e]=s)}for(const[t,s]of Object.entries(e.optionalScopes)){const e=t;((0,i.isWalletScope)(e)||r.has(e))&&(n.optionalScopes[e]=s)}for(const e of t)n.requiredScopes[e]||n.optionalScopes[e]||(n.optionalScopes[e]={accounts:[]});return n}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-permittedChains.cjs"}],[2194,{"../scope/constants.cjs":2199,"../scope/transform.cjs":2203,"../scope/types.cjs":2204,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getPermittedAccountsForScopes=r.getSessionScopes=r.getInternalScopesObject=void 0;const n=e("@metamask/utils"),s=e("../scope/constants.cjs"),a=e("../scope/transform.cjs"),o=e("../scope/types.cjs");r.getInternalScopesObject=e=>{const t={};return Object.entries(e).forEach((([e,{accounts:r}])=>{t[e]={accounts:r}})),t};const i=(e,{getNonEvmSupportedMethods:t})=>{const r={};return Object.entries(e).forEach((([e,{accounts:a}])=>{const i=e,{namespace:c,reference:l}=(0,o.parseScopeString)(i);let d=[],u=[];i===n.KnownCaipNamespace.Wallet||c===n.KnownCaipNamespace.Wallet?d=l===n.KnownCaipNamespace.Eip155?s.KnownWalletNamespaceRpcMethods[l]:(0,n.isCaipChainId)(i)?t(i):s.KnownWalletRpcMethods:c===n.KnownCaipNamespace.Eip155?(d=s.KnownRpcMethods[c],u=s.KnownNotifications[c]):(d=t(i),u=[]),r[i]={methods:d,notifications:u,accounts:a}})),r};r.getSessionScopes=(e,{getNonEvmSupportedMethods:t})=>(0,a.mergeNormalizedScopes)(i(e.requiredScopes,{getNonEvmSupportedMethods:t}),i(e.optionalScopes,{getNonEvmSupportedMethods:t}));r.getPermittedAccountsForScopes=(e,t)=>{const r=[];return t.forEach((t=>{const n=e.requiredScopes[t],s=e.optionalScopes[t];n&&r.push(...n.accounts),s&&r.push(...s.accounts)})),[...new Set(r)]}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/adapters/caip-permission-adapter-session-scopes.cjs"}],[2195,{"./adapters/caip-permission-adapter-accounts.cjs":2192,"./adapters/caip-permission-adapter-permittedChains.cjs":2193,"./scope/assert.cjs":2197,"./scope/supported.cjs":2202,"./scope/transform.cjs":2203,"./scope/types.cjs":2204,"@metamask/permission-controller":2383,"@metamask/utils":2967,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getCaip25CaveatFromPermission=r.generateCaip25Caveat=r.Caip25CaveatMutators=r.caip25EndowmentBuilder=r.caip25CaveatBuilder=r.diffScopesForCaip25CaveatValue=r.createCaip25Caveat=r.Caip25EndowmentPermissionName=r.Caip25CaveatType=void 0;const n=e("@metamask/permission-controller"),s=e("@metamask/utils"),a=e("lodash"),o=e("./adapters/caip-permission-adapter-accounts.cjs"),i=e("./adapters/caip-permission-adapter-permittedChains.cjs"),c=e("./scope/assert.cjs"),l=e("./scope/supported.cjs"),d=e("./scope/transform.cjs"),u=e("./scope/types.cjs");r.Caip25CaveatType="authorizedScopes",r.Caip25EndowmentPermissionName="endowment:caip25";function h(e,t,r){const n=(0,a.cloneDeep)(e),s=t[r];for(const[e,t]of Object.entries(s)){const s=e,a=n[r][s];if(a){const e=t.accounts.filter((e=>!a?.accounts.includes(e)));if(e.length>0){n[r][s]={accounts:e};continue}delete n[r][s]}else n[r][s]=t}return n}function p(e,t,r){return Object.values(e).every((e=>e.accounts.every((e=>(0,l.isSupportedAccount)(e,{getEvmInternalAccounts:t,getNonEvmAccountAddresses:r})))))}r.createCaip25Caveat=e=>({type:r.Caip25CaveatType,value:e}),r.diffScopesForCaip25CaveatValue=h;r.caip25CaveatBuilder=({findNetworkClientIdByChainId:e,listAccounts:t,isNonEvmScopeSupported:n,getNonEvmAccountAddresses:a})=>({type:r.Caip25CaveatType,validator:(o,i,d)=>{if(!(o.value&&(0,s.hasProperty)(o.value,"requiredScopes")&&(0,s.hasProperty)(o.value,"optionalScopes")&&(0,s.hasProperty)(o.value,"isMultichainOrigin")&&(0,s.hasProperty)(o.value,"sessionProperties")&&"boolean"==typeof o.value.isMultichainOrigin&&(0,s.isObject)(o.value.sessionProperties)))throw new Error(`${r.Caip25EndowmentPermissionName} error: Received invalid value for caveat of type "${r.Caip25CaveatType}".`);const{requiredScopes:u,optionalScopes:h,sessionProperties:m}=o.value;if(!Object.keys(m).every((e=>(0,l.isSupportedSessionProperty)(e))))throw new Error(`${r.Caip25EndowmentPermissionName} error: Received unknown session property(s) for caveat of type "${r.Caip25CaveatType}".`);if((0,c.assertIsInternalScopesObject)(u),(0,c.assertIsInternalScopesObject)(h),0===Object.keys(u).length&&0===Object.keys(h).length)throw new Error(`${r.Caip25EndowmentPermissionName} error: Received no scopes for caveat of type "${r.Caip25CaveatType}".`);const f=t=>{try{return e(t),!0}catch{return!1}},g=Object.keys(u).every((e=>(0,l.isSupportedScopeString)(e,{isEvmChainIdSupported:f,isNonEvmScopeSupported:n}))),b=Object.keys(h).every((e=>(0,l.isSupportedScopeString)(e,{isEvmChainIdSupported:f,isNonEvmScopeSupported:n})));if(!g||!b)throw new Error(`${r.Caip25EndowmentPermissionName} error: Received scopeString value(s) for caveat of type "${r.Caip25CaveatType}" that are not supported by the wallet.`);const C=p(u,t,a),y=p(h,t,a);if(!C||!y)throw new Error(`${r.Caip25EndowmentPermissionName} error: Received account value(s) for caveat of type "${r.Caip25CaveatType}" that are not supported by the wallet.`)},merger:(e,t)=>{const r={requiredScopes:(0,d.mergeInternalScopes)(e.requiredScopes,t.requiredScopes),optionalScopes:(0,d.mergeInternalScopes)(e.optionalScopes,t.optionalScopes),sessionProperties:{...e.sessionProperties,...t.sessionProperties},isMultichainOrigin:e.isMultichainOrigin},n=h(e,r,"requiredScopes");return[r,h(n,r,"optionalScopes")]}});r.caip25EndowmentBuilder=Object.freeze({targetName:r.Caip25EndowmentPermissionName,specificationBuilder:()=>({permissionType:n.PermissionType.Endowment,targetName:r.Caip25EndowmentPermissionName,allowedCaveats:[r.Caip25CaveatType],endowmentGetter:e=>null,validator:e=>{if(1!==e.caveats?.length||e.caveats?.[0]?.type!==r.Caip25CaveatType)throw new Error(`${r.Caip25EndowmentPermissionName} error: Invalid caveats. There must be a single caveat of type "${r.Caip25CaveatType}".`)}})}),r.Caip25CaveatMutators={[r.Caip25CaveatType]:{removeScope:function(e,t){const r=Object.entries(e.requiredScopes).filter((([e])=>e!==t)),a=Object.entries(e.optionalScopes).filter((([e])=>e!==t)),o=r.length!==Object.keys(e.requiredScopes).length,i=a.length!==Object.keys(e.optionalScopes).length;if(!o&&!i)return{operation:n.CaveatMutatorOperation.Noop};const c={...e,requiredScopes:Object.fromEntries(r),optionalScopes:Object.fromEntries(a)};if([...r,...a].some((([e])=>{const{namespace:t}=(0,u.parseScopeString)(e);return t!==s.KnownCaipNamespace.Wallet})))return{operation:n.CaveatMutatorOperation.UpdateValue,value:c};return{operation:n.CaveatMutatorOperation.RevokePermission}},removeAccount:function(e,t){const r=(0,a.cloneDeep)(e);[r.requiredScopes,r.optionalScopes].forEach((e=>{Object.entries(e).forEach((([,e])=>{!function(e,t){e.accounts&&(e.accounts=e.accounts.filter(function(e){return t=>(0,s.parseCaipAccountId)(t).address!==e}(t)))}(e,t)}))}));if((0,a.isEqual)(r,e))return{operation:n.CaveatMutatorOperation.Noop};if([...Object.values(r.requiredScopes),...Object.values(r.optionalScopes)].some((({accounts:e})=>e.length>0)))return{operation:n.CaveatMutatorOperation.UpdateValue,value:r};return{operation:n.CaveatMutatorOperation.RevokePermission}}}};r.generateCaip25Caveat=(e,t,n)=>{const s=(0,i.setChainIdsInCaip25CaveatValue)(e,n),a=(0,o.setNonSCACaipAccountIdsInCaip25CaveatValue)(s,t);return{[r.Caip25EndowmentPermissionName]:{caveats:[{type:r.Caip25CaveatType,value:a}]}}},r.getCaip25CaveatFromPermission=function(e){return e?.caveats.find((e=>e.type===r.Caip25CaveatType))}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/caip25Permission.cjs"}],[2196,{"./adapters/caip-permission-adapter-accounts.cjs":2192,"./adapters/caip-permission-adapter-permittedChains.cjs":2193,"./adapters/caip-permission-adapter-session-scopes.cjs":2194,"./caip25Permission.cjs":2195,"./scope/assert.cjs":2197,"./scope/authorization.cjs":2198,"./scope/constants.cjs":2199,"./scope/errors.cjs":2200,"./scope/filter.cjs":2201,"./scope/transform.cjs":2203,"./scope/types.cjs":2204},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Caip25Errors=r.KnownSessionProperties=r.getCaip25CaveatFromPermission=r.generateCaip25Caveat=r.Caip25CaveatMutators=r.caip25EndowmentBuilder=r.Caip25EndowmentPermissionName=r.createCaip25Caveat=r.Caip25CaveatType=r.caip25CaveatBuilder=r.normalizeAndMergeScopes=r.mergeInternalScopes=r.mergeNormalizedScopes=r.mergeScopeObject=r.normalizeScope=r.getUniqueArrayItems=r.parseScopeString=r.getSupportedScopeObjects=r.isKnownSessionPropertyValue=r.KnownWalletScopeString=r.KnownNotifications=r.KnownWalletNamespaceRpcMethods=r.KnownRpcMethods=r.KnownWalletRpcMethods=r.assertIsInternalScopeString=r.isNamespaceInScopesObject=r.bucketScopes=r.validateAndNormalizeScopes=r.getPermittedAccountsForScopes=r.getSessionScopes=r.getInternalScopesObject=r.getAllScopesFromScopesObjects=r.getAllScopesFromCaip25CaveatValue=r.getAllScopesFromPermission=r.getAllNamespacesFromCaip25CaveatValue=r.addCaipChainIdInCaip25CaveatValue=r.setChainIdsInCaip25CaveatValue=r.setPermittedEthChainIds=r.addPermittedEthChainId=r.getPermittedEthChainIds=r.isCaipAccountIdInPermittedAccountIds=r.isInternalAccountInPermittedAccountIds=r.getCaipAccountIdsFromCaip25CaveatValue=r.getCaipAccountIdsFromScopesObjects=r.setNonSCACaipAccountIdsInCaip25CaveatValue=r.setEthAccounts=r.getEthAccounts=void 0;var n=e("./adapters/caip-permission-adapter-accounts.cjs");Object.defineProperty(r,"getEthAccounts",{enumerable:!0,get:function(){return n.getEthAccounts}}),Object.defineProperty(r,"setEthAccounts",{enumerable:!0,get:function(){return n.setEthAccounts}}),Object.defineProperty(r,"setNonSCACaipAccountIdsInCaip25CaveatValue",{enumerable:!0,get:function(){return n.setNonSCACaipAccountIdsInCaip25CaveatValue}}),Object.defineProperty(r,"getCaipAccountIdsFromScopesObjects",{enumerable:!0,get:function(){return n.getCaipAccountIdsFromScopesObjects}}),Object.defineProperty(r,"getCaipAccountIdsFromCaip25CaveatValue",{enumerable:!0,get:function(){return n.getCaipAccountIdsFromCaip25CaveatValue}}),Object.defineProperty(r,"isInternalAccountInPermittedAccountIds",{enumerable:!0,get:function(){return n.isInternalAccountInPermittedAccountIds}}),Object.defineProperty(r,"isCaipAccountIdInPermittedAccountIds",{enumerable:!0,get:function(){return n.isCaipAccountIdInPermittedAccountIds}});var s=e("./adapters/caip-permission-adapter-permittedChains.cjs");Object.defineProperty(r,"getPermittedEthChainIds",{enumerable:!0,get:function(){return s.getPermittedEthChainIds}}),Object.defineProperty(r,"addPermittedEthChainId",{enumerable:!0,get:function(){return s.addPermittedEthChainId}}),Object.defineProperty(r,"setPermittedEthChainIds",{enumerable:!0,get:function(){return s.setPermittedEthChainIds}}),Object.defineProperty(r,"setChainIdsInCaip25CaveatValue",{enumerable:!0,get:function(){return s.setChainIdsInCaip25CaveatValue}}),Object.defineProperty(r,"addCaipChainIdInCaip25CaveatValue",{enumerable:!0,get:function(){return s.addCaipChainIdInCaip25CaveatValue}}),Object.defineProperty(r,"getAllNamespacesFromCaip25CaveatValue",{enumerable:!0,get:function(){return s.getAllNamespacesFromCaip25CaveatValue}}),Object.defineProperty(r,"getAllScopesFromPermission",{enumerable:!0,get:function(){return s.getAllScopesFromPermission}}),Object.defineProperty(r,"getAllScopesFromCaip25CaveatValue",{enumerable:!0,get:function(){return s.getAllScopesFromCaip25CaveatValue}}),Object.defineProperty(r,"getAllScopesFromScopesObjects",{enumerable:!0,get:function(){return s.getAllScopesFromScopesObjects}});var a=e("./adapters/caip-permission-adapter-session-scopes.cjs");Object.defineProperty(r,"getInternalScopesObject",{enumerable:!0,get:function(){return a.getInternalScopesObject}}),Object.defineProperty(r,"getSessionScopes",{enumerable:!0,get:function(){return a.getSessionScopes}}),Object.defineProperty(r,"getPermittedAccountsForScopes",{enumerable:!0,get:function(){return a.getPermittedAccountsForScopes}});var o=e("./scope/authorization.cjs");Object.defineProperty(r,"validateAndNormalizeScopes",{enumerable:!0,get:function(){return o.validateAndNormalizeScopes}}),Object.defineProperty(r,"bucketScopes",{enumerable:!0,get:function(){return o.bucketScopes}}),Object.defineProperty(r,"isNamespaceInScopesObject",{enumerable:!0,get:function(){return o.isNamespaceInScopesObject}});var i=e("./scope/assert.cjs");Object.defineProperty(r,"assertIsInternalScopeString",{enumerable:!0,get:function(){return i.assertIsInternalScopeString}});var c=e("./scope/constants.cjs");Object.defineProperty(r,"KnownWalletRpcMethods",{enumerable:!0,get:function(){return c.KnownWalletRpcMethods}}),Object.defineProperty(r,"KnownRpcMethods",{enumerable:!0,get:function(){return c.KnownRpcMethods}}),Object.defineProperty(r,"KnownWalletNamespaceRpcMethods",{enumerable:!0,get:function(){return c.KnownWalletNamespaceRpcMethods}}),Object.defineProperty(r,"KnownNotifications",{enumerable:!0,get:function(){return c.KnownNotifications}}),Object.defineProperty(r,"KnownWalletScopeString",{enumerable:!0,get:function(){return c.KnownWalletScopeString}}),Object.defineProperty(r,"isKnownSessionPropertyValue",{enumerable:!0,get:function(){return c.isKnownSessionPropertyValue}});var l=e("./scope/filter.cjs");Object.defineProperty(r,"getSupportedScopeObjects",{enumerable:!0,get:function(){return l.getSupportedScopeObjects}});var d=e("./scope/types.cjs");Object.defineProperty(r,"parseScopeString",{enumerable:!0,get:function(){return d.parseScopeString}});var u=e("./scope/transform.cjs");Object.defineProperty(r,"getUniqueArrayItems",{enumerable:!0,get:function(){return u.getUniqueArrayItems}}),Object.defineProperty(r,"normalizeScope",{enumerable:!0,get:function(){return u.normalizeScope}}),Object.defineProperty(r,"mergeScopeObject",{enumerable:!0,get:function(){return u.mergeScopeObject}}),Object.defineProperty(r,"mergeNormalizedScopes",{enumerable:!0,get:function(){return u.mergeNormalizedScopes}}),Object.defineProperty(r,"mergeInternalScopes",{enumerable:!0,get:function(){return u.mergeInternalScopes}}),Object.defineProperty(r,"normalizeAndMergeScopes",{enumerable:!0,get:function(){return u.normalizeAndMergeScopes}});var h=e("./caip25Permission.cjs");Object.defineProperty(r,"caip25CaveatBuilder",{enumerable:!0,get:function(){return h.caip25CaveatBuilder}}),Object.defineProperty(r,"Caip25CaveatType",{enumerable:!0,get:function(){return h.Caip25CaveatType}}),Object.defineProperty(r,"createCaip25Caveat",{enumerable:!0,get:function(){return h.createCaip25Caveat}}),Object.defineProperty(r,"Caip25EndowmentPermissionName",{enumerable:!0,get:function(){return h.Caip25EndowmentPermissionName}}),Object.defineProperty(r,"caip25EndowmentBuilder",{enumerable:!0,get:function(){return h.caip25EndowmentBuilder}}),Object.defineProperty(r,"Caip25CaveatMutators",{enumerable:!0,get:function(){return h.Caip25CaveatMutators}}),Object.defineProperty(r,"generateCaip25Caveat",{enumerable:!0,get:function(){return h.generateCaip25Caveat}}),Object.defineProperty(r,"getCaip25CaveatFromPermission",{enumerable:!0,get:function(){return h.getCaip25CaveatFromPermission}});var p=e("./scope/constants.cjs");Object.defineProperty(r,"KnownSessionProperties",{enumerable:!0,get:function(){return p.KnownSessionProperties}});var m=e("./scope/errors.cjs");Object.defineProperty(r,"Caip25Errors",{enumerable:!0,get:function(){return m.Caip25Errors}})}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/index.cjs"}],[2197,{"./errors.cjs":2200,"./supported.cjs":2202,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.assertIsInternalScopesObject=r.assertIsInternalScopeString=r.assertIsExternalScopesObject=r.assertScopesSupported=r.assertScopeSupported=void 0;const n=e("@metamask/utils"),s=e("./errors.cjs"),a=e("./supported.cjs");r.assertScopeSupported=(e,t,{isEvmChainIdSupported:r,isNonEvmScopeSupported:n,getNonEvmSupportedMethods:o})=>{const{methods:i,notifications:c}=t;if(!(0,a.isSupportedScopeString)(e,{isEvmChainIdSupported:r,isNonEvmScopeSupported:n}))throw s.Caip25Errors.requestedChainsNotSupportedError();if(!i.every((t=>(0,a.isSupportedMethod)(e,t,{getNonEvmSupportedMethods:o}))))throw s.Caip25Errors.requestedMethodsNotSupportedError();if(c&&!c.every((t=>(0,a.isSupportedNotification)(e,t))))throw s.Caip25Errors.requestedNotificationsNotSupportedError()};function o(e){if("object"!=typeof e||null===e)throw new Error("ExternalScopeObject must be an object");if((0,n.hasProperty)(e,"references")&&(!Array.isArray(e.references)||!e.references.every(n.isCaipReference)))throw new Error("ExternalScopeObject.references must be an array of CaipReference");if((0,n.hasProperty)(e,"accounts")&&(!Array.isArray(e.accounts)||!e.accounts.every(n.isCaipAccountId)))throw new Error("ExternalScopeObject.accounts must be an array of CaipAccountId");if((0,n.hasProperty)(e,"methods")&&(!Array.isArray(e.methods)||!e.methods.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.methods must be an array of strings");if((0,n.hasProperty)(e,"notifications")&&(!Array.isArray(e.notifications)||!e.notifications.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.notifications must be an array of strings");if((0,n.hasProperty)(e,"rpcDocuments")&&(!Array.isArray(e.rpcDocuments)||!e.rpcDocuments.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.rpcDocuments must be an array of strings");if((0,n.hasProperty)(e,"rpcEndpoints")&&(!Array.isArray(e.rpcEndpoints)||!e.rpcEndpoints.every((e=>"string"==typeof e))))throw new Error("ExternalScopeObject.rpcEndpoints must be an array of strings")}function i(e){if("string"!=typeof e||!(0,n.isCaipNamespace)(e)&&!(0,n.isCaipChainId)(e))throw new Error("scopeString is not a valid ExternalScopeString")}function c(e){if("object"!=typeof e||null===e)throw new Error("InternalScopeObject must be an object");if(!(0,n.hasProperty)(e,"accounts")||!Array.isArray(e.accounts)||!e.accounts.every(n.isCaipAccountId))throw new Error("InternalScopeObject.accounts must be an array of CaipAccountId")}function l(e){if("string"!=typeof e||e!==n.KnownCaipNamespace.Wallet&&!(0,n.isCaipChainId)(e))throw new Error("scopeString is not a valid InternalScopeString")}r.assertScopesSupported=(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:n,getNonEvmSupportedMethods:s})=>{for(const[a,o]of Object.entries(e))(0,r.assertScopeSupported)(a,o,{isEvmChainIdSupported:t,isNonEvmScopeSupported:n,getNonEvmSupportedMethods:s})},r.assertIsExternalScopesObject=function(e){if("object"!=typeof e||null===e)throw new Error("ExternalScopesObject must be an object");for(const[t,r]of Object.entries(e))i(t),o(r)},r.assertIsInternalScopeString=l,r.assertIsInternalScopesObject=function(e){if("object"!=typeof e||null===e)throw new Error("InternalScopesObject must be an object");for(const[t,r]of Object.entries(e))l(t),c(r)}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/assert.cjs"}],[2198,{"./filter.cjs":2201,"./transform.cjs":2203,"./types.cjs":2204,"./validation.cjs":2205},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isNamespaceInScopesObject=r.bucketScopes=r.validateAndNormalizeScopes=void 0;const n=e("./filter.cjs"),s=e("./transform.cjs"),a=e("./types.cjs"),o=e("./validation.cjs");r.validateAndNormalizeScopes=(e,t)=>{const{validRequiredScopes:r,validOptionalScopes:n}=(0,o.getValidScopes)(e,t);return{normalizedRequiredScopes:(0,s.normalizeAndMergeScopes)(r),normalizedOptionalScopes:(0,s.normalizeAndMergeScopes)(n)}};r.bucketScopes=(e,{isEvmChainIdSupported:t,isEvmChainIdSupportable:r,isNonEvmScopeSupported:s,getNonEvmSupportedMethods:a})=>{const{supportedScopes:o,unsupportedScopes:i}=(0,n.bucketScopesBySupport)(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:s,getNonEvmSupportedMethods:a}),{supportedScopes:c,unsupportedScopes:l}=(0,n.bucketScopesBySupport)(i,{isEvmChainIdSupported:r,isNonEvmScopeSupported:s,getNonEvmSupportedMethods:a});return{supportedScopes:o,supportableScopes:c,unsupportableScopes:l}},r.isNamespaceInScopesObject=function(e,t){return Object.keys(e).some((e=>{const{namespace:r}=(0,a.parseScopeString)(e);return r===t}))}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/authorization.cjs"}],[2199,{"@metamask/api-specs":2191},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.isKnownSessionPropertyValue=r.KnownSessionProperties=r.KnownNotifications=r.KnownWalletNamespaceRpcMethods=r.KnownRpcMethods=r.Eip1193OnlyMethods=r.KnownWalletRpcMethods=r.CaipReferenceRegexes=r.KnownWalletScopeString=void 0;const s=n(e("@metamask/api-specs"));var a;!function(e){e.Eip155="wallet:eip155"}(a||(r.KnownWalletScopeString=a={})),r.CaipReferenceRegexes={eip155:/^(0|[1-9][0-9]*)$/u,bip122:/.*/u,solana:/.*/u},r.KnownWalletRpcMethods=["wallet_registerOnboarding","wallet_scanQRCode"];const o=["wallet_addEthereumChain"];r.Eip1193OnlyMethods=["wallet_switchEthereumChain","wallet_getPermissions","wallet_requestPermissions","wallet_revokePermissions","eth_requestAccounts","eth_accounts","eth_coinbase","net_version","metamask_logWeb3ShimUsage","metamask_getProviderState","metamask_sendDomainMetadata","wallet_registerOnboarding"];const i=s.default.methods.map((({name:e})=>e)).filter((e=>!o.includes(e))).filter((e=>!r.KnownWalletRpcMethods.includes(e))).filter((e=>!r.Eip1193OnlyMethods.includes(e)));var c;r.KnownRpcMethods={eip155:i,bip122:[],solana:[]},r.KnownWalletNamespaceRpcMethods={eip155:o,bip122:[],solana:[]},r.KnownNotifications={eip155:["eth_subscription"],bip122:[],solana:[]},function(e){e.SolanaAccountChangedNotifications="solana_accountChanged_notifications"}(c||(r.KnownSessionProperties=c={})),r.isKnownSessionPropertyValue=function(e){return Object.values(c).includes(e)}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/constants.cjs"}],[22,{"../../controllers/institutional-snap/InstitutionalSnapController":90},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.InstitutionalSnapControllerInit=void 0;var n=e("../../controllers/institutional-snap/InstitutionalSnapController");r.InstitutionalSnapControllerInit=e=>({controller:new n.InstitutionalSnapController({messenger:e.controllerMessenger})})}}},{package:"$root$",file:"app/scripts/controller-init/institutional-snap/institutional-snap-controller-init.ts"}],[220,{"../../../../shared/constants/time":5815,"../../../../shared/modules/fetch-with-timeout":5895,"./trust-signals-util":222},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.scanAddress=l,r.scanAddressAndAddToCache=async function(e,t,r){const n=t.getAddressSecurityAlertResponse(e);if(n)return n;const s=(0,o.getChainId)(r),a=await l(s,e);return t.addAddressSecurityAlertResponse(e,a),a};var n,s=e("../../../../shared/constants/time"),a=(n=e("../../../../shared/modules/fetch-with-timeout"))&&n.__esModule?n:{default:n},o=e("./trust-signals-util");const i=5*s.SECOND,c="address/evm/scan";async function l(e,t){const r="https://security-alerts.api.cx.metamask.io";const n=`${r}/${c}`,s={chain:e,address:t},o=await(0,a.default)(i)(n,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(s)});return await o.json()}}}},{package:"$root$",file:"app/scripts/lib/trust-signals/security-alerts-api.ts"}],[2200,{"@metamask/rpc-errors":2522},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Caip25Errors=void 0;const n=e("@metamask/rpc-errors");r.Caip25Errors={requestedChainsNotSupportedError:()=>new n.JsonRpcError(5100,"Requested chains are not supported"),requestedMethodsNotSupportedError:()=>new n.JsonRpcError(5101,"Requested methods are not supported"),requestedNotificationsNotSupportedError:()=>new n.JsonRpcError(5102,"Requested notifications are not supported"),unknownMethodsRequestedError:()=>new n.JsonRpcError(5201,"Unknown method(s) requested"),unknownNotificationsRequestedError:()=>new n.JsonRpcError(5202,"Unknown notification(s) requested")}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/errors.cjs"}],[2201,{"./assert.cjs":2197,"./supported.cjs":2202},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getSupportedScopeObjects=r.bucketScopesBySupport=void 0;const n=e("./assert.cjs"),s=e("./supported.cjs");r.bucketScopesBySupport=(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:r,getNonEvmSupportedMethods:s})=>{const a={},o={};for(const[i,c]of Object.entries(e)){(0,n.assertIsInternalScopeString)(i);try{(0,n.assertScopeSupported)(i,c,{isEvmChainIdSupported:t,isNonEvmScopeSupported:r,getNonEvmSupportedMethods:s}),a[i]=c}catch{o[i]=c}}return{supportedScopes:a,unsupportedScopes:o}};const a=(e,t,{getNonEvmSupportedMethods:r})=>{const{methods:n,notifications:a}=t,o=n.filter((t=>(0,s.isSupportedMethod)(e,t,{getNonEvmSupportedMethods:r}))),i=a.filter((t=>(0,s.isSupportedNotification)(e,t)));return{...t,methods:o,notifications:i}};r.getSupportedScopeObjects=(e,{getNonEvmSupportedMethods:t})=>{const r={};for(const[s,o]of Object.entries(e))(0,n.assertIsInternalScopeString)(s),r[s]=a(s,o,{getNonEvmSupportedMethods:t});return r}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/filter.cjs"}],[2202,{"./constants.cjs":2199,"./types.cjs":2204,"@metamask/controller-utils":1557,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isSupportedSessionProperty=r.isSupportedNotification=r.isSupportedMethod=r.isSupportedAccount=r.isSupportedScopeString=void 0;const n=e("@metamask/controller-utils"),s=e("@metamask/utils"),a=e("./constants.cjs"),o=e("./types.cjs");r.isSupportedScopeString=(e,{isEvmChainIdSupported:t,isNonEvmScopeSupported:r})=>{const{namespace:i,reference:c}=(0,o.parseScopeString)(e);switch(i){case s.KnownCaipNamespace.Wallet:return!(0,s.isCaipChainId)(e)||c===s.KnownCaipNamespace.Eip155||r(e);case s.KnownCaipNamespace.Eip155:return!c||a.CaipReferenceRegexes.eip155.test(c)&&t((0,n.toHex)(c));default:return!!(0,s.isCaipChainId)(e)&&r(e)}};r.isSupportedAccount=(e,{getEvmInternalAccounts:t,getNonEvmAccountAddresses:r})=>{const{address:a,chainId:o,chain:{namespace:i,reference:c}}=(0,s.parseCaipAccountId)(e),l=()=>t().some((e=>["eip155:eoa","eip155:erc4337"].includes(e.type)&&(0,n.isEqualCaseInsensitive)(a,e.address))),d=()=>r(o).includes(e);switch(i){case s.KnownCaipNamespace.Wallet:return c===s.KnownCaipNamespace.Eip155?l():d();case s.KnownCaipNamespace.Eip155:return l();default:return d()}};r.isSupportedMethod=(e,t,{getNonEvmSupportedMethods:r})=>{const{namespace:n,reference:i}=(0,o.parseScopeString)(e);if(!n)return!1;const c=()=>(0,s.isCaipChainId)(e)&&r(e).includes(t);return n===s.KnownCaipNamespace.Wallet?i?i===s.KnownCaipNamespace.Eip155?a.KnownWalletNamespaceRpcMethods[i].includes(t):c():a.KnownWalletRpcMethods.includes(t):n===s.KnownCaipNamespace.Eip155?a.KnownRpcMethods[n].includes(t):c()};r.isSupportedNotification=(e,t)=>{const{namespace:r}=(0,o.parseScopeString)(e);return r===s.KnownCaipNamespace.Eip155&&a.KnownNotifications[r].includes(t)};r.isSupportedSessionProperty=e=>Object.values(a.KnownSessionProperties).includes(e)}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/supported.cjs"}],[2203,{"./types.cjs":2204,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.normalizeAndMergeScopes=r.mergeInternalScopes=r.mergeNormalizedScopes=r.mergeScopeObject=r.normalizeScope=r.getUniqueArrayItems=void 0;const n=e("lodash"),s=e("./types.cjs");r.getUniqueArrayItems=e=>Array.from(new Set(e));r.normalizeScope=(e,t)=>{const{references:r,...a}=t,{namespace:o,reference:i}=(0,s.parseScopeString)(e),c={accounts:[],...a};return o&&!i&&r!==undefined&&r.length>0?Object.fromEntries(r.map((e=>[`${o}:${e}`,(0,n.cloneDeep)(c)]))):{[e]:c}};r.mergeScopeObject=(e,t)=>{const n={methods:(0,r.getUniqueArrayItems)([...e.methods,...t.methods]),notifications:(0,r.getUniqueArrayItems)([...e.notifications,...t.notifications]),accounts:(0,r.getUniqueArrayItems)([...e.accounts,...t.accounts])};return(e.rpcDocuments||t.rpcDocuments)&&(n.rpcDocuments=(0,r.getUniqueArrayItems)([...e.rpcDocuments??[],...t.rpcDocuments??[]])),(e.rpcEndpoints||t.rpcEndpoints)&&(n.rpcEndpoints=(0,r.getUniqueArrayItems)([...e.rpcEndpoints??[],...t.rpcEndpoints??[]])),n};r.mergeNormalizedScopes=(e,t)=>{const n={};return Object.entries(e).forEach((([e,s])=>{const a=e,o=t[a];n[a]=o?(0,r.mergeScopeObject)(s,o):s})),Object.entries(t).forEach((([t,r])=>{const s=t;e[s]||(n[s]=r)})),n};r.mergeInternalScopes=(e,t)=>{const s=(0,n.cloneDeep)(e);return Object.entries(t).forEach((([e,t])=>{const n=e,a=s[n];s[n]=a?{accounts:(0,r.getUniqueArrayItems)([...a.accounts,...t.accounts])}:t})),s};r.normalizeAndMergeScopes=e=>{let t={};return Object.keys(e).forEach((n=>{const s=(0,r.normalizeScope)(n,e[n]);t=(0,r.mergeNormalizedScopes)(t,s)})),t}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/transform.cjs"}],[2204,{"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isWalletScope=r.parseScopeString=void 0;const n=e("@metamask/utils");r.parseScopeString=e=>(0,n.isCaipNamespace)(e)?{namespace:e}:(0,n.isCaipChainId)(e)?(0,n.parseCaipChainId)(e):{};r.isWalletScope=e=>{const{namespace:t}=(0,r.parseScopeString)(e);return t===n.KnownCaipNamespace.Wallet}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/types.cjs"}],[2205,{"./types.cjs":2204,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getValidScopes=r.isValidScope=void 0;const n=e("@metamask/utils"),s=e("./types.cjs");r.isValidScope=(e,t)=>{const{namespace:r,reference:a}=(0,s.parseScopeString)(e);if(!r)return!1;const{references:o,methods:i,notifications:c,accounts:l,rpcDocuments:d,rpcEndpoints:u,...h}=t;if(!i||!c)return!1;if(!("wallet"===r||a||o&&0!==o.length))return!1;if(o){if(a)return!1;if(!o.every((e=>(0,n.isCaipReference)(e))))return!1}if(!i.every((e=>"string"==typeof e&&""!==e.trim())))return!1;return!!c.every((e=>"string"==typeof e&&""!==e.trim()))&&!(Object.keys(h).length>0)};r.getValidScopes=(e,t)=>{const n={};for(const[t,s]of Object.entries(e||{}))(0,r.isValidScope)(t,s)&&(n[t]={accounts:[],...s});const s={};for(const[e,n]of Object.entries(t||{}))(0,r.isValidScope)(e,n)&&(s[e]={accounts:[],...n});return{validRequiredScopes:n,validOptionalScopes:s}}}}},{package:"@metamask/multichain-api-middleware>@metamask/chain-agnostic-permission",file:"node_modules/@metamask/multichain-api-middleware/node_modules/@metamask/chain-agnostic-permission/dist/scope/validation.cjs"}],[221,{"../../../../shared/modules/transaction.utils":5913,"../ppom/security-alerts-api":165,"./security-alerts-api":220,"./trust-signals-util":222},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createTrustSignalsMiddleware=function(e,t,r,c){return async(l,d,u)=>{try{if(!(0,o.isSecurityAlertsEnabledByUser)(c)||!(0,s.isSecurityAlertsAPIEnabled)())return;(0,o.isEthSendTransaction)(l)?(!function(e,t,r){if(!(0,o.hasValidTransactionParams)(e))return;const{to:n}=e.params[0];(0,a.scanAddressAndAddToCache)(n,t,r).catch((e=>{console.error("[createTrustSignalsMiddleware] error scanning address for transaction:",e)}))}(l,t,e),i(l,r)):(0,o.isEthSignTypedData)(l)?(!function(e,t,r){var s;if(!(0,o.hasValidTypedDataParams)(e))return;const i=(0,n.parseTypedDataMessage)("string"==typeof e.params[1]?e.params[1]:JSON.stringify(e.params[1])),c=null===(s=i.domain)||void 0===s?void 0:s.verifyingContract;if(!c)return;(0,a.scanAddressAndAddToCache)(c,t,r).catch((e=>{console.error("[createTrustSignalsMiddleware] error scanning address for signature:",e)}))}(l,t,e),i(l,r)):(0,o.isEthAccounts)(l)&&i(l,r)}catch(e){console.error("[createTrustSignalsMiddleware] error: ",e)}finally{u()}}};var n=e("../../../../shared/modules/transaction.utils"),s=e("../ppom/security-alerts-api"),a=e("./security-alerts-api"),o=e("./trust-signals-util");function i(e,t){e.mainFrameOrigin&&t.scanUrl(e.mainFrameOrigin).catch((e=>{console.error("[createTrustSignalsMiddleware] error:",e)}))}}}},{package:"$root$",file:"app/scripts/lib/trust-signals/trust-signals-middleware.ts"}],[222,{"../../../../shared/constants/app":5786,"../../../../shared/constants/network":5801,"../../../../shared/modules/selectors/networks":5908,"./types":223},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getChainId=function(e){var t;const r=null===(t=(0,s.getProviderConfig)({metamask:e.state}))||void 0===t?void 0:t.chainId;if(!r)throw new Error("Chain ID not found");return function(e){return{[n.CHAIN_IDS.ARBITRUM]:o.SupportedEVMChain.Arbitrum,[n.CHAIN_IDS.AVALANCHE]:o.SupportedEVMChain.Avalanche,[n.CHAIN_IDS.BASE]:o.SupportedEVMChain.Base,[n.CHAIN_IDS.BASE_SEPOLIA]:o.SupportedEVMChain.BaseSepolia,[n.CHAIN_IDS.BSC]:o.SupportedEVMChain.Bsc,[n.CHAIN_IDS.MAINNET]:o.SupportedEVMChain.Ethereum,[n.CHAIN_IDS.OPTIMISM]:o.SupportedEVMChain.Optimism,[n.CHAIN_IDS.POLYGON]:o.SupportedEVMChain.Polygon,[n.CHAIN_IDS.ZKSYNC_ERA]:o.SupportedEVMChain.Zksync,[n.CHAIN_IDS.ZK_SYNC_ERA_TESTNET]:o.SupportedEVMChain.ZksyncSepolia,"0x76adf1":o.SupportedEVMChain.Zora,[n.CHAIN_IDS.LINEA_MAINNET]:o.SupportedEVMChain.Linea,[n.CHAIN_IDS.BLAST]:o.SupportedEVMChain.Blast,[n.CHAIN_IDS.SCROLL]:o.SupportedEVMChain.Scroll,[n.CHAIN_IDS.SEPOLIA]:o.SupportedEVMChain.EthereumSepolia,"0x27bc86aa":o.SupportedEVMChain.Degen,[n.CHAIN_IDS.AVALANCHE_TESTNET]:o.SupportedEVMChain.AvalancheFuji,"0x343b":o.SupportedEVMChain.ImmutableZkevm,"0x34a1":o.SupportedEVMChain.ImmutableZkevmTestnet,[n.CHAIN_IDS.GNOSIS]:o.SupportedEVMChain.Gnosis,"0x1e0":o.SupportedEVMChain.Worldchain,"0x79a":o.SupportedEVMChain.SoneiumMinato,"0x7e4":o.SupportedEVMChain.Ronin,[n.CHAIN_IDS.APECHAIN_MAINNET]:o.SupportedEVMChain.ApeChain,"0x849ea":o.SupportedEVMChain.ZeroNetwork,[n.CHAIN_IDS.BERACHAIN]:o.SupportedEVMChain.Berachain,"0x138c5":o.SupportedEVMChain.BerachainBartio,[n.CHAIN_IDS.INK]:o.SupportedEVMChain.Ink,[n.CHAIN_IDS.INK_SEPOLIA]:o.SupportedEVMChain.InkSepolia,"0xab5":o.SupportedEVMChain.Abstract,"0x2b74":o.SupportedEVMChain.AbstractTestnet,"0x74c":o.SupportedEVMChain.Soneium,[n.CHAIN_IDS.UNICHAIN]:o.SupportedEVMChain.Unichain,[n.CHAIN_IDS.SEI]:o.SupportedEVMChain.Sei,[n.CHAIN_IDS.FLOW]:o.SupportedEVMChain.FlowEvm}[e.toLowerCase()]}(r)},r.hasValidTransactionParams=function(e){if(!("params"in e)||!e.params)return!1;if(!Array.isArray(e.params)||0===e.params.length)return!1;const t=e.params[0];return"object"==typeof t&&null!==t&&"to"in t},r.hasValidTypedDataParams=function(e){if(!("params"in e)||!e.params)return!1;if(!Array.isArray(e.params)||e.params.length<2)return!1;return e.params[1]!==undefined&&null!==e.params[1]},r.isEthAccounts=function(e){return e.method===a.MESSAGE_TYPE.ETH_ACCOUNTS},r.isEthSendTransaction=function(e){return e.method===a.MESSAGE_TYPE.ETH_SEND_TRANSACTION},r.isEthSignTypedData=function(e){return e.method===a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA||e.method===a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1||e.method===a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3||e.method===a.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4},r.isSecurityAlertsEnabledByUser=function(e){const{securityAlertsEnabled:t}=e.state;return t};var n=e("../../../../shared/constants/network"),s=e("../../../../shared/modules/selectors/networks"),a=e("../../../../shared/constants/app"),o=e("./types")}}},{package:"$root$",file:"app/scripts/lib/trust-signals/trust-signals-util.ts"}],[224,{"../../../../shared/constants/app":5786,"../../../../shared/constants/verification":5819,"../../../../shared/modules/selectors/networks":5908,"@ethersproject/hash":585,"@ethersproject/wallet":652,"@metamask/rpc-errors":2522,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createTxVerificationMiddleware=function(e,t=i.TRUSTED_SIGNERS){return function(r,d,u,h){if(r.method!==c.MESSAGE_TYPE.ETH_SEND_TRANSACTION||!Array.isArray(r.params)||!function(e){return(0,o.isObject)(e[0])&&"string"==typeof e[0].data&&"string"==typeof e[0].from&&"string"==typeof e[0].to&&"string"==typeof e[0].value&&(!(0,o.hasProperty)(e[0],"chainId")||"string"==typeof e[0].chainId&&e[0].chainId.startsWith("0x"))}(r.params))return u();const p=r.params[0],m="string"==typeof p.chainId?p.chainId.toLowerCase():(0,l.getCurrentChainId)({metamask:e.state}),f=(0,i.getExperience)(p.to.toLowerCase(),m);if(!f||!i.EXPERIENCES_TO_VERIFY.includes(f))return u();const g=`0x${p.data.slice(-i.TX_SIG_LEN)}`,b=(0,s.verifyMessage)(function(e){const t={to:(0,n.hashMessage)(e.to.toLowerCase()),from:(0,n.hashMessage)(e.from.toLowerCase()),data:(0,n.hashMessage)(e.data.toLowerCase().slice(0,e.data.length-i.TX_SIG_LEN)),value:(0,n.hashMessage)(e.value.toLowerCase())};return(0,n.hashMessage)(JSON.stringify(t))}(p),g);return b!==t[f]?h(a.rpcErrors.invalidParams("Invalid transaction signature.")):u()}};var n=e("@ethersproject/hash"),s=e("@ethersproject/wallet"),a=e("@metamask/rpc-errors"),o=e("@metamask/utils"),i=e("../../../../shared/constants/verification"),c=e("../../../../shared/constants/app"),l=e("../../../../shared/modules/selectors/networks")}}},{package:"$root$",file:"app/scripts/lib/tx-verification/tx-verification-middleware.ts"}],[226,{"../../development/build/constants":441,"../../shared/constants/app":5786,"../../shared/constants/bridge":5787,"../../shared/constants/hardware-wallets":5794,"../../shared/constants/keyring":5795,"../../shared/constants/logs":5797,"../../shared/constants/metametrics":5798,"../../shared/constants/multichain/networks":5800,"../../shared/constants/network":5801,"../../shared/constants/onboarding":5804,"../../shared/constants/permissions":5805,"../../shared/constants/swaps":5813,"../../shared/constants/time":5815,"../../shared/constants/tokens":5816,"../../shared/constants/transaction":5817,"../../shared/constants/urls":5818,"../../shared/lib/accounts":5822,"../../shared/lib/accounts/solana-wallet-snap":5825,"../../shared/lib/fetch-with-cache":5862,"../../shared/lib/metamask-controller-utils":5867,"../../shared/lib/snaps/snaps":5874,"../../shared/lib/storage-helpers":5875,"../../shared/lib/token-util":5878,"../../shared/lib/trace":5879,"../../shared/lib/transactions-controller-utils":5881,"../../shared/lib/translate":5884,"../../shared/modules/environment":5892,"../../shared/modules/mv3.utils":5900,"../../shared/modules/network.utils":5901,"../../shared/modules/selectors":5907,"../../shared/modules/selectors/networks":5908,"../../shared/modules/string-utils":5911,"../../shared/modules/transaction.utils":5913,"../../shared/notifications":5915,"./constants/stream":9,"./controller-init/accounts/account-tree-controller-init":10,"./controller-init/assets":12,"./controller-init/confirmations/ppom-controller-init":16,"./controller-init/confirmations/transaction-controller-init":17,"./controller-init/defi-positions/defi-positions-controller-init":18,"./controller-init/delegation/delegation-controller-init":19,"./controller-init/identity/authentication-controller-init":20,"./controller-init/identity/user-storage-controller-init":21,"./controller-init/institutional-snap/institutional-snap-controller-init":22,"./controller-init/multichain":61,"./controller-init/notifications/notification-services-controller-init":68,"./controller-init/notifications/notification-services-push-controller-init":69,"./controller-init/seedless-onboarding/seedless-onboarding-controller-init":70,"./controller-init/smart-transactions/smart-transactions-controller-init":71,"./controller-init/snaps":74,"./controller-init/utils":82,"./controllers/account-order":83,"./controllers/account-tracker-controller":84,"./controllers/alert-controller":85,"./controllers/app-metadata":86,"./controllers/app-state-controller":87,"./controllers/decrypt-message":88,"./controllers/encryption-public-key":89,"./controllers/metametrics-controller":91,"./controllers/metametrics-data-deletion/metametrics-data-deletion":92,"./controllers/network-order":93,"./controllers/onboarding":94,"./controllers/permissions":98,"./controllers/preferences-controller":101,"./controllers/swaps":105,"./detect-multiple-instances":108,"./lib/AccountIdentitiesPetnamesBridge":119,"./lib/AddressBookPetnamesBridge":120,"./lib/ComposableObservableStore":121,"./lib/PatchStore":123,"./lib/SnapsNameProvider":124,"./lib/WeakRefObjectMap":125,"./lib/approval/utils":126,"./lib/backup":127,"./lib/createDupeReqFilterStream":128,"./lib/createEvmMethodsToNonEvmAccountReqFilterMiddleware":129,"./lib/createLoggerMiddleware":130,"./lib/createMainFrameOriginMiddleware":131,"./lib/createMetaRPCHandler":132,"./lib/createMetamaskMiddleware":133,"./lib/createOnboardingMiddleware":134,"./lib/createOriginMiddleware":135,"./lib/createOriginThrottlingMiddleware":136,"./lib/createRPCMethodTrackingMiddleware":137,"./lib/createTabIdMiddleware":138,"./lib/createTracingMiddleware":139,"./lib/encryptor-factory":142,"./lib/hardware-keyring-builder-factory":149,"./lib/multichain/address":153,"./lib/network-controller/messenger-action-handlers":154,"./lib/network-controller/utils":155,"./lib/offscreen-bridge/lattice-offscreen-keyring":157,"./lib/offscreen-bridge/ledger-offscreen-bridge":158,"./lib/offscreen-bridge/trezor-offscreen-bridge":159,"./lib/ppom/ppom-middleware":162,"./lib/ppom/ppom-util":163,"./lib/rpc-method-middleware":182,"./lib/segment":185,"./lib/signature/util":189,"./lib/snap-keyring":191,"./lib/snap-keyring/keyring-snaps-permissions":192,"./lib/state-utils":199,"./lib/stream-utils":204,"./lib/transaction/containers/util":206,"./lib/transaction/decode/util":212,"./lib/transaction/eip5792":214,"./lib/transaction/metrics":217,"./lib/transaction/transaction-relay":218,"./lib/transaction/util":219,"./lib/trust-signals/trust-signals-middleware":221,"./lib/tx-verification/tx-verification-middleware":224,"./lib/util":225,"./services/data-deletion-service":430,"./services/oauth/oauth-service":436,"./services/oauth/web-authenticator-factory":438,"@ethersproject/abi":556,"@keystonehq/metamask-airgapped-keyring":762,"@metamask/accounts-controller":1413,"@metamask/address-book-controller":1416,"@metamask/announcement-controller":1418,"@metamask/approval-controller":1421,"@metamask/assets-controllers":1455,"@metamask/base-controller":1474,"@metamask/bridge-controller":1481,"@metamask/bridge-status-controller":1506,"@metamask/chain-agnostic-permission":1540,"@metamask/controller-utils":1557,"@metamask/ens-controller":1590,"@metamask/error-reporting-service":1592,"@metamask/eth-json-rpc-filters":1646,"@metamask/eth-json-rpc-filters/subscriptionManager":1648,"@metamask/eth-json-rpc-middleware":1660,"@metamask/eth-ledger-bridge-keyring":1721,"@metamask/eth-sig-util":1775,"@metamask/eth-trezor-keyring":1941,"@metamask/gas-fee-controller":2007,"@metamask/json-rpc-engine":2025,"@metamask/json-rpc-middleware-stream":2029,"@metamask/keyring-api":2075,"@metamask/keyring-controller":2082,"@metamask/logging-controller":2161,"@metamask/metamask-eth-abis":2179,"@metamask/multichain-api-middleware":2185,"@metamask/name-controller":2307,"@metamask/network-controller":2319,"@metamask/notification-services-controller/notification-services":2335,"@metamask/obs-store":2376,"@metamask/obs-store/dist/asStream":2375,"@metamask/permission-controller":2383,"@metamask/permission-log-controller":2392,"@metamask/phishing-controller":2396,"@metamask/remote-feature-flag-controller":2515,"@metamask/rpc-errors":2522,"@metamask/scure-bip39/dist/wordlists/english":2526,"@metamask/seedless-onboarding-controller":2541,"@metamask/selected-network-controller":2546,"@metamask/signature-controller":2548,"@metamask/snaps-controllers":2616,"@metamask/snaps-rpc-methods":2676,"@metamask/transaction-controller":2918,"@metamask/user-operation-controller":2945,"@metamask/utils":2967,"@sentry/browser":3084,"await-semaphore":3929,buffer:4099,"eth-chainlist":4300,"eth-lattice-keyring":4305,events:4447,lodash:4905,loglevel:4913,nanoid:5014,"readable-stream":5270},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.default=r.METAMASK_CONTROLLER_EVENTS=void 0;var n=hr(e("events")),s=e("readable-stream"),a=e("@metamask/assets-controllers"),o=e("@metamask/json-rpc-engine"),i=e("@metamask/json-rpc-middleware-stream"),c=e("@metamask/obs-store"),l=e("@metamask/obs-store/dist/asStream"),d=e("@metamask/eth-json-rpc-middleware"),u=e("lodash"),h=e("@metamask/keyring-controller"),p=hr(e("@metamask/eth-json-rpc-filters")),m=hr(e("@metamask/eth-json-rpc-filters/subscriptionManager")),f=e("@metamask/rpc-errors"),g=e("await-semaphore"),b=hr(e("loglevel")),C=e("@metamask/eth-trezor-keyring"),y=e("@metamask/eth-ledger-bridge-keyring"),w=hr(e("eth-lattice-keyring")),S=e("eth-chainlist"),v=e("@keystonehq/metamask-airgapped-keyring"),k=e("nanoid"),T=e("@sentry/browser"),P=e("@metamask/address-book-controller"),M=e("@metamask/approval-controller"),E=e("@metamask/base-controller"),A=e("@metamask/ens-controller"),I=e("@metamask/phishing-controller"),N=e("@metamask/announcement-controller"),_=e("@metamask/network-controller"),O=e("@metamask/gas-fee-controller"),R=e("@metamask/permission-controller"),x=e("@metamask/selected-network-controller"),j=e("@metamask/logging-controller"),B=e("@metamask/permission-log-controller"),D=e("@metamask/snaps-controllers"),F=e("@metamask/snaps-rpc-methods"),$=e("@metamask/controller-utils"),L=e("@metamask/accounts-controller"),U=e("@metamask/remote-feature-flag-controller"),K=e("@metamask/signature-controller"),q=e("@metamask/scure-bip39/dist/wordlists/english"),H=e("@metamask/name-controller"),V=e("@metamask/user-operation-controller"),W=e("@metamask/bridge-controller"),G=e("@metamask/transaction-controller"),z=e("@ethersproject/abi"),J=e("@metamask/metamask-eth-abis"),Y=e("@metamask/keyring-api"),Q=e("@metamask/utils"),X=e("@metamask/eth-sig-util"),Z=e("@metamask/notification-services-controller/notification-services"),ee=e("@metamask/multichain-api-middleware"),te=e("@metamask/chain-agnostic-permission"),re=e("@metamask/bridge-status-controller"),ne=e("@metamask/error-reporting-service"),se=e("@metamask/seedless-onboarding-controller"),ae=e("../../shared/constants/transaction"),oe=e("../../shared/constants/swaps"),ie=e("../../shared/constants/network"),ce=e("../../shared/constants/hardware-wallets"),le=e("../../shared/constants/keyring"),de=e("../../shared/constants/permissions"),ue=e("../../shared/notifications"),he=e("../../shared/constants/time"),pe=e("../../shared/constants/app"),me=e("../../shared/constants/metametrics"),fe=e("../../shared/constants/logs"),ge=e("../../shared/lib/storage-helpers"),be=e("../../shared/lib/token-util"),Ce=e("../../shared/modules/string-utils"),ye=e("../../shared/modules/transaction.utils"),we=e("../../shared/constants/tokens"),Se=e("../../shared/lib/metamask-controller-utils"),ve=e("../../shared/modules/mv3.utils"),ke=e("../../shared/modules/network.utils"),Te=e("../../shared/modules/selectors"),Pe=e("../../shared/constants/urls"),Me=e("../../shared/lib/transactions-controller-utils"),Ee=e("../../shared/modules/selectors/networks"),Ae=e("../../shared/lib/trace"),Ie=e("../../development/build/constants"),Ne=hr(e("../../shared/lib/fetch-with-cache")),_e=e("../../shared/constants/multichain/networks"),Oe=e("../../shared/constants/bridge"),Re=e("../../shared/lib/accounts"),xe=e("../../shared/lib/accounts/solana-wallet-snap"),je=e("../../shared/constants/onboarding"),Be=e("../../shared/lib/translate"),De=e("../../shared/modules/environment"),Fe=e("../../shared/lib/snaps/snaps"),$e=e("./lib/transaction/metrics"),Le=e("./lib/snap-keyring/keyring-snaps-permissions"),Ue=e("./lib/SnapsNameProvider"),Ke=e("./lib/AddressBookPetnamesBridge"),qe=e("./lib/AccountIdentitiesPetnamesBridge"),He=e("./lib/ppom/ppom-middleware"),Ve=e("./lib/trust-signals/trust-signals-middleware"),We=e("./detect-multiple-instances"),Ge=hr(e("./lib/ComposableObservableStore")),ze=hr(e("./controllers/account-tracker-controller")),Je=hr(e("./lib/createDupeReqFilterStream")),Ye=hr(e("./lib/createLoggerMiddleware")),Qe=e("./lib/rpc-method-middleware"),Xe=hr(e("./lib/createOriginMiddleware")),Ze=hr(e("./lib/createMainFrameOriginMiddleware")),et=hr(e("./lib/createTabIdMiddleware")),tt=e("./controllers/network-order"),rt=e("./controllers/account-order"),nt=hr(e("./lib/createOnboardingMiddleware")),st=e("./lib/stream-utils"),at=e("./controllers/preferences-controller"),ot=e("./controllers/app-state-controller"),it=e("./controllers/alert-controller"),ct=hr(e("./controllers/onboarding")),lt=hr(e("./lib/backup")),dt=hr(e("./controllers/decrypt-message")),ut=hr(e("./controllers/swaps")),ht=hr(e("./controllers/metametrics-controller")),pt=e("./lib/segment"),mt=hr(e("./lib/createMetaRPCHandler")),ft=e("./lib/util"),gt=hr(e("./lib/createMetamaskMiddleware")),bt=e("./lib/hardware-keyring-builder-factory"),Ct=hr(e("./controllers/encryption-public-key")),yt=hr(e("./controllers/app-metadata")),wt=e("./controllers/permissions"),St=e("./controllers/metametrics-data-deletion/metametrics-data-deletion"),vt=e("./services/data-deletion-service"),kt=hr(e("./lib/createRPCMethodTrackingMiddleware")),Tt=e("./lib/offscreen-bridge/trezor-offscreen-bridge"),Pt=e("./lib/offscreen-bridge/ledger-offscreen-bridge"),Mt=e("./lib/snap-keyring"),Et=e("./lib/encryptor-factory"),At=e("./lib/transaction/util"),It=e("./lib/signature/util"),Nt=e("./lib/offscreen-bridge/lattice-offscreen-keyring"),_t=e("./lib/WeakRefObjectMap"),Ot=e("./constants/stream"),Rt=e("./lib/tx-verification/tx-verification-middleware"),xt=e("./lib/ppom/ppom-util"),jt=hr(e("./lib/createEvmMethodsToNonEvmAccountReqFilterMiddleware")),Bt=e("./lib/multichain/address"),Dt=e("./lib/transaction/decode/util"),Ft=hr(e("./lib/createTracingMiddleware")),$t=hr(e("./lib/createOriginThrottlingMiddleware")),Lt=e("./lib/PatchStore"),Ut=e("./lib/state-utils"),Kt=e("./lib/approval/utils"),qt=e("./controller-init/institutional-snap/institutional-snap-controller-init"),Ht=e("./controller-init/multichain"),Vt=e("./controller-init/assets"),Wt=e("./controller-init/confirmations/transaction-controller-init"),Gt=e("./controller-init/confirmations/ppom-controller-init"),zt=e("./controller-init/smart-transactions/smart-transactions-controller-init"),Jt=e("./controller-init/utils"),Yt=e("./controller-init/snaps"),Qt=e("./controller-init/identity/authentication-controller-init"),Xt=e("./controller-init/identity/user-storage-controller-init"),Zt=e("./controller-init/defi-positions/defi-positions-controller-init"),er=e("./lib/transaction/eip5792"),tr=e("./controller-init/notifications/notification-services-controller-init"),rr=e("./controller-init/notifications/notification-services-push-controller-init"),nr=e("./controller-init/delegation/delegation-controller-init"),sr=e("./lib/network-controller/messenger-action-handlers"),ar=e("./lib/network-controller/utils"),or=e("./lib/transaction/transaction-relay"),ir=e("./controller-init/accounts/account-tree-controller-init"),cr=hr(e("./services/oauth/oauth-service")),lr=e("./services/oauth/web-authenticator-factory"),dr=e("./controller-init/seedless-onboarding/seedless-onboarding-controller-init"),ur=e("./lib/transaction/containers/util");function hr(e){return e&&e.__esModule?e:{default:e}}function pr(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function mr(e,t,r){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var r=e[Symbol.toPrimitive];if(void 0!==r){var n=r.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}function fr(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}r.METAMASK_CONTROLLER_EVENTS={UPDATE_BADGE:"updateBadge",DECRYPT_MESSAGE_MANAGER_UPDATE_BADGE:"DecryptMessageManager:updateBadge",ENCRYPTION_PUBLIC_KEY_MANAGER_UPDATE_BADGE:"EncryptionPublicKeyManager:updateBadge",APPROVAL_STATE_CHANGE:"ApprovalController:stateChange",APP_STATE_UNLOCK_CHANGE:"AppStateController:unlockChange",METAMASK_NOTIFICATIONS_LIST_UPDATED:"NotificationServicesController:notificationsListUpdated",METAMASK_NOTIFICATIONS_MARK_AS_READ:"NotificationServicesController:markNotificationsAsRead"};const gr="eip-1193",br="caip-multichain",Cr={[Ie.ENVIRONMENT.DEVELOPMENT]:U.EnvironmentType.Development,[Ie.ENVIRONMENT.RELEASE_CANDIDATE]:U.EnvironmentType.ReleaseCandidate,[Ie.ENVIRONMENT.PRODUCTION]:U.EnvironmentType.Production},yr={flask:U.DistributionType.Flask,main:U.DistributionType.Main,beta:U.DistributionType.Beta,experimental:U.DistributionType.Main};var wr=new WeakSet;class Sr extends n.default{constructor(e){var t;super(),pr(this,wr),mr(this,"handleWatchAssetRequest",(({asset:e,type:t,origin:r,networkClientId:n})=>{switch(t){case $.ERC20:return this.tokensController.watchAsset({asset:e,type:t,networkClientId:n});case $.ERC721:case $.ERC1155:return this.nftController.watchNft(e,t,r,n);default:throw new Error(`Asset type ${t} not supported`)}})),mr(this,"removePermissionsFor",(e=>{try{this.permissionController.revokePermissions(e)}catch(e){if(!(e instanceof R.PermissionsRequestNotFoundError))throw e}})),mr(this,"updateCaveat",((e,t,r,n)=>{try{this.controllerMessenger.call("PermissionController:updateCaveat",e,t,r,n)}catch(e){if(!(e instanceof R.PermissionsRequestNotFoundError))throw e}})),mr(this,"updateNetworksList",(e=>{try{this.networkOrderController.updateNetworksList(e)}catch(e){throw b.default.error(e.message),e}})),mr(this,"updateAccountsList",(e=>{try{this.accountOrderController.updateAccountsList(e)}catch(e){throw b.default.error(e.message),e}})),mr(this,"setEnabledNetworks",((e,t)=>{try{this.networkOrderController.setEnabledNetworks(e,t)}catch(e){throw b.default.error(e.message),e}})),mr(this,"updateHiddenAccountsList",(e=>{try{this.accountOrderController.updateHiddenAccountsList(e)}catch(e){throw b.default.error(e.message),e}})),mr(this,"rejectPermissionsRequest",(e=>{try{this.permissionController.rejectPermissionsRequest(e)}catch(e){if(!(e instanceof R.PermissionsRequestNotFoundError))throw e}})),mr(this,"acceptPermissionsRequest",(e=>{try{this.permissionController.acceptPermissionsRequest(e)}catch(e){if(!(e instanceof R.PermissionsRequestNotFoundError))throw e}})),mr(this,"resolvePendingApproval",(async(e,t,r)=>{try{await this.approvalController.accept(e,t,r)}catch(e){if(!(e instanceof M.ApprovalRequestNotFoundError))throw e}})),mr(this,"rejectPendingApproval",((e,t)=>{try{this.approvalController.reject(e,new f.JsonRpcError(t.code,t.message,t.data))}catch(e){if(!(e instanceof M.ApprovalRequestNotFoundError))throw e}}));const{isFirstMetaMaskControllerSetup:r}=e;this.defaultMaxListeners=20,this.sendUpdate=(0,u.debounce)(this.privateSendUpdate.bind(this),200*he.MILLISECOND),this.opts=e,this.requestSafeReload=e.requestSafeReload??(()=>Promise.resolve()),this.extension=e.browser,this.platform=e.platform,this.notificationManager=e.notificationManager;const n=e.initState||{},s="12.23.0";this.recordFirstTimeInfo(n),this.featureFlags=e.featureFlags,this.activeControllerConnections=0,this.offscreenPromise=e.offscreenPromise??Promise.resolve(),this.getRequestAccountTabIds=e.getRequestAccountTabIds,this.getOpenMetamaskTabsIds=e.getOpenMetamaskTabsIds,this.initializeChainlist(),this.controllerMessenger=new E.Messenger,this.loggingController=new j.LoggingController({messenger:this.controllerMessenger.getRestricted({name:"LoggingController",allowedActions:[],allowedEvents:[]}),state:n.LoggingController}),this.currentMigrationVersion=e.currentMigrationVersion,this.store=new Ge.default({state:n,controllerMessenger:this.controllerMessenger,persist:!0}),this.connections={},this.createVaultMutex=new g.Mutex,this.syncSeedlessGlobalPasswordMutex=new g.Mutex,this.extension.runtime.onInstalled.addListener((e=>{"update"===e.reason&&this.loggingController.add({type:j.LogType.GenericLog,data:{event:fe.LOG_EVENT.VERSION_UPDATE,previousVersion:e.previousVersion,version:s}})})),this.appMetadataController=new yt.default({state:n.AppMetadataController,messenger:this.controllerMessenger.getRestricted({name:"AppMetadataController",allowedActions:[],allowedEvents:[]}),currentMigrationVersion:this.currentMigrationVersion,currentAppVersion:s}),this.approvalController=new M.ApprovalController({messenger:this.controllerMessenger.getRestricted({name:"ApprovalController"}),showApprovalRequest:e.showUserConfirmation,typesExcludedFromRateLimiting:[$.ApprovalType.PersonalSign,$.ApprovalType.EthSignTypedData,$.ApprovalType.Transaction,$.ApprovalType.WatchAsset,$.ApprovalType.EthGetEncryptionPublicKey,$.ApprovalType.EthDecrypt,pe.SMART_TRANSACTION_CONFIRMATION_TYPES.showSmartTransactionStatusPage]});const o=this.controllerMessenger.getRestricted({name:"ErrorReportingService",allowedActions:[],allowedEvents:[]});new ne.ErrorReportingService({messenger:o,captureException:T.captureException});const i=this.controllerMessenger.getRestricted({name:"NetworkController",allowedEvents:[],allowedActions:["ErrorReportingService:captureException"]});let c=n.NetworkController;const l=[$.ChainId["megaeth-testnet"],$.ChainId["monad-testnet"]];if(!c){c=(0,_.getDefaultNetworkControllerState)(l);const e=c.networkConfigurationsByChainId;let t;Object.values(e).forEach((e=>{const t=e.rpcEndpoints[0].networkClientId;(0,Q.hasProperty)($.BlockExplorerUrl,t)&&(e.blockExplorerUrls=[$.BlockExplorerUrl[t]]),e.defaultBlockExplorerUrlIndex=0})),e[ie.CHAIN_IDS.MAINNET].rpcEndpoints[0].failoverUrls=(0,ie.getFailoverUrlsForInfuraNetwork)("ethereum-mainnet"),e[ie.CHAIN_IDS.LINEA_MAINNET].rpcEndpoints[0].failoverUrls=(0,ie.getFailoverUrlsForInfuraNetwork)("linea-mainnet"),e[ie.CHAIN_IDS.BASE].rpcEndpoints[0].failoverUrls=(0,ie.getFailoverUrlsForInfuraNetwork)("base-mainnet"),t=e[ie.CHAIN_IDS.MAINNET],c.selectedNetworkClientId=t.rpcEndpoints[t.defaultRpcEndpointIndex].networkClientId}c.networkConfigurationsByChainId&&!Object.values(c.networkConfigurationsByChainId).flatMap((e=>e.rpcEndpoints.map((e=>e.networkClientId)))).includes(c.selectedNetworkClientId)&&((0,T.captureException)(new Error(`NetworkController state is invalid: \`selectedNetworkClientId\` '${c.selectedNetworkClientId}' does not refer to an RPC endpoint within a network configuration`)),c.selectedNetworkClientId=c.networkConfigurationsByChainId[ie.CHAIN_IDS.MAINNET].rpcEndpoints[0].networkClientId),this.networkController=new _.NetworkController({messenger:i,state:c,infuraProjectId:e.infuraProjectId,getBlockTrackerOptions:()=>({pollingInterval:20*he.SECOND,retryTimeout:20*he.SECOND}),getRpcServiceOptions:e=>{const t={fetch:globalThis.fetch.bind(globalThis),btoa:globalThis.btoa.bind(globalThis)};return(0,ar.getIsQuicknodeEndpointUrl)(e)?{...t,policyOptions:{maxRetries:4,maxConsecutiveFailures:70}}:{...t,policyOptions:{maxRetries:4,maxConsecutiveFailures:35}}},additionalDefaultNetworks:l}),i.subscribe("NetworkController:rpcEndpointUnavailable",(async({chainId:t,endpointUrl:r,error:n})=>{(0,sr.onRpcEndpointUnavailable)({chainId:t,endpointUrl:r,error:n,infuraProjectId:e.infuraProjectId,trackEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController),metaMetricsId:this.metaMetricsController.state.metaMetricsId})})),i.subscribe("NetworkController:rpcEndpointDegraded",(async({chainId:t,endpointUrl:r})=>{(0,sr.onRpcEndpointDegraded)({chainId:t,endpointUrl:r,infuraProjectId:e.infuraProjectId,trackEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController),metaMetricsId:this.metaMetricsController.state.metaMetricsId})})),this.networkController.initializeProvider(),this.multichainSubscriptionManager=new ee.MultichainSubscriptionManager({getNetworkClientById:this.networkController.getNetworkClientById.bind(this.networkController),findNetworkClientIdByChainId:this.networkController.findNetworkClientIdByChainId.bind(this.networkController)}),this.multichainMiddlewareManager=new ee.MultichainMiddlewareManager,this.provider=this.networkController.getProviderAndBlockTracker().provider,this.blockTracker=this.networkController.getProviderAndBlockTracker().blockTracker,this.deprecatedNetworkVersions={};const d=this.controllerMessenger.getRestricted({name:"AccountsController",allowedEvents:["SnapController:stateChange","KeyringController:accountRemoved","KeyringController:stateChange","SnapKeyring:accountAssetListUpdated","SnapKeyring:accountBalancesUpdated","SnapKeyring:accountTransactionsUpdated","MultichainNetworkController:networkDidChange"],allowedActions:["KeyringController:getState","KeyringController:getKeyringsByType"]});this.accountsController=new L.AccountsController({messenger:d,state:n.AccountsController});const p=this.controllerMessenger.getRestricted({name:"PreferencesController",allowedActions:["AccountsController:setSelectedAccount","AccountsController:getSelectedAccount","AccountsController:getAccountByAddress","AccountsController:setAccountName","NetworkController:getState"],allowedEvents:["AccountsController:stateChange"]});this.preferencesController=new at.PreferencesController({state:{currentLocale:e.initLangCode??"",...n.PreferencesController},messenger:p});const m=this.controllerMessenger.getRestricted({name:"TokenListController",allowedActions:["NetworkController:getNetworkClientById"],allowedEvents:["NetworkController:stateChange"]});this.tokenListController=new a.TokenListController({chainId:fr(wr,this,Pr).call(this,{metamask:this.networkController.state}),preventPollingOnNetworkRestart:!fr(wr,this,Tr).call(this,this.preferencesController.state),messenger:m,state:n.TokenListController});const S=this.controllerMessenger.getRestricted({name:"TokensController",allowedActions:["ApprovalController:addRequest","NetworkController:getNetworkClientById","AccountsController:getSelectedAccount","AccountsController:getAccount","AccountsController:listAccounts"],allowedEvents:["NetworkController:networkDidChange","AccountsController:selectedEvmAccountChange","PreferencesController:stateChange","TokenListController:stateChange","NetworkController:stateChange","KeyringController:accountRemoved"]});this.tokensController=new a.TokensController({state:n.TokensController,provider:this.provider,messenger:S,chainId:fr(wr,this,Pr).call(this)});const k=this.controllerMessenger.getRestricted({name:"MetaMetricsController",allowedActions:["PreferencesController:getState","NetworkController:getState","NetworkController:getNetworkClientById"],allowedEvents:["PreferencesController:stateChange","NetworkController:networkDidChange"]});this.metaMetricsController=new ht.default({state:n.MetaMetricsController,messenger:k,segment:pt.segment,version:"12.23.0",environment:"pull-request",extension:this.extension,captureException:T.captureException}),this.on("update",(e=>{this.metaMetricsController.handleMetaMaskStateUpdate(e)}));const F=new vt.DataDeletionService,q=this.controllerMessenger.getRestricted({name:"MetaMetricsDataDeletionController",allowedActions:["MetaMetricsController:getState"],allowedEvents:[]});this.metaMetricsDataDeletionController=new St.MetaMetricsDataDeletionController({dataDeletionService:F,messenger:q,state:n.metaMetricsDataDeletionController});const z=this.controllerMessenger.getRestricted({name:"GasFeeController",allowedActions:["NetworkController:getEIP1559Compatibility","NetworkController:getNetworkClientById","NetworkController:getState"],allowedEvents:["NetworkController:stateChange"]}),J=oe.GAS_API_BASE_URL;this.gasFeeController=new O.GasFeeController({state:n.GasFeeController,interval:1e4,messenger:z,clientId:oe.SWAPS_CLIENT_ID,getProvider:()=>this.networkController.getProviderAndBlockTracker().provider,onNetworkDidChange:e=>{i.subscribe("NetworkController:networkDidChange",(()=>e(this.networkController.state)))},getCurrentNetworkEIP1559Compatibility:this.networkController.getEIP1559Compatibility.bind(this.networkController),getCurrentAccountEIP1559Compatibility:this.getCurrentAccountEIP1559Compatibility.bind(this),legacyAPIEndpoint:`${J}/networks/<chain_id>/gasPrices`,EIP1559APIEndpoint:`${J}/networks/<chain_id>/suggestedGasFees`,getCurrentNetworkLegacyGasAPICompatibility:()=>fr(wr,this,Pr).call(this)===ie.CHAIN_IDS.BSC,getChainId:()=>fr(wr,this,Pr).call(this)}),this.appStateController=new ot.AppStateController({addUnlockListener:this.on.bind(this,"unlock"),isUnlocked:this.isUnlocked.bind(this),state:n.AppStateController,onInactiveTimeout:()=>this.setLocked(),messenger:this.controllerMessenger.getRestricted({name:"AppStateController",allowedActions:[`${this.approvalController.name}:addRequest`,`${this.approvalController.name}:acceptRequest`,"PreferencesController:getState"],allowedEvents:["KeyringController:qrKeyringStateChange","PreferencesController:stateChange"]}),extension:this.extension});const Y=this.controllerMessenger.getRestricted({name:"CurrencyRateController",allowedActions:[`${this.networkController.name}:getNetworkClientById`]});this.currencyRateController=new a.CurrencyRateController({includeUsdRate:!0,messenger:Y,state:n.CurrencyController});const X=this.currencyRateController.fetchMultiExchangeRate.bind(this.currencyRateController);this.currencyRateController.fetchMultiExchangeRate=(...e)=>this.preferencesController.state.useCurrencyRateCheck?X(...e):{conversionRate:null,usdConversionRate:null};const Z=this.controllerMessenger.getRestricted({name:"TokenBalancesController",allowedActions:["NetworkController:getState","NetworkController:getNetworkClientById","TokensController:getState","PreferencesController:getState","AccountsController:getSelectedAccount","AccountsController:listAccounts"],allowedEvents:["PreferencesController:stateChange","TokensController:stateChange","NetworkController:stateChange","KeyringController:accountRemoved"]});this.tokenBalancesController=new a.TokenBalancesController({messenger:Z,state:n.TokenBalancesController,interval:3e4});const te=this.controllerMessenger.getRestricted({name:"PhishingController"});this.phishingController=new I.PhishingController({messenger:te,state:n.PhishingController,hotlistRefreshInterval:undefined,stalelistRefreshInterval:undefined});const se=this.controllerMessenger.getRestricted({name:"AnnouncementController"});this.announcementController=new N.AnnouncementController({messenger:se,allAnnouncements:ue.UI_NOTIFICATIONS,state:n.AnnouncementController});const ae=this.controllerMessenger.getRestricted({name:"NetworkOrderController",allowedEvents:["NetworkController:stateChange","NetworkController:networkRemoved"],allowedActions:["NetworkController:getState","NetworkController:getNetworkClientById","NetworkController:setActiveNetwork"]});let ce=n.NetworkOrderController;this.networkOrderController=new tt.NetworkOrderController({messenger:ae,state:ce});const le=this.controllerMessenger.getRestricted({name:"AccountOrderController"});this.accountOrderController=new rt.AccountOrderController({messenger:le,state:n.AccountOrderController});const ge=this.controllerMessenger.getRestricted({name:"RatesController"});this.multichainRatesController=new a.RatesController({state:n.MultichainRatesController,messenger:ge,includeUsdRate:!0,fetchMultiExchangeRate:a.fetchMultiExchangeRate}),this.controllerMessenger.subscribe("PreferencesController:stateChange",(0,ft.previousValueComparator)(((e,t)=>{const{useCurrencyRateCheck:r}=e,{useCurrencyRateCheck:n}=t;n&&!r?this.tokenRatesController.enable():!n&&r&&this.tokenRatesController.disable()}),this.preferencesController.state)),this.ensController=new A.EnsController({messenger:this.controllerMessenger.getRestricted({name:"EnsController",allowedActions:["NetworkController:getNetworkClientById","NetworkController:getState"],allowedEvents:[]}),onNetworkDidChange:i.subscribe.bind(i,"NetworkController:networkDidChange")});const be=this.controllerMessenger.getRestricted({name:"OnboardingController",allowedActions:[],allowedEvents:[]});this.onboardingController=new ct.default({messenger:be,state:n.OnboardingController}),this.oauthService=new cr.default({env:{googleClientId:"387141446914-olajr83p1bbvabh1u8tfglt1k4u6jlcb.apps.googleusercontent.com",appleClientId:"io.metamask.appleloginclient.uat"},webAuthenticator:(0,lr.webAuthenticatorFactory)(),bufferedTrace:this.metaMetricsController.bufferedTrace.bind(this.metaMetricsController),bufferedEndTrace:this.metaMetricsController.bufferedEndTrace.bind(this.metaMetricsController)});let Ce=[(0,h.keyringBuilderFactory)(v.MetaMaskKeyring)];const ye=null===(t=this.opts.overrides)||void 0===t?void 0:t.keyrings;if(!1===ve.isManifestV3){const e=[(null==ye?void 0:ye.lattice)||w.default,v.MetaMaskKeyring],t=[{keyring:(null==ye?void 0:ye.trezor)||C.TrezorKeyring,bridge:(null==ye?void 0:ye.trezorBridge)||C.TrezorConnectBridge},{keyring:(null==ye?void 0:ye.oneKey)||C.OneKeyKeyring,bridge:(null==ye?void 0:ye.oneKeyBridge)||C.TrezorConnectBridge},{keyring:(null==ye?void 0:ye.ledger)||y.LedgerKeyring,bridge:(null==ye?void 0:ye.ledgerBridge)||y.LedgerIframeBridge}];Ce=e.map((e=>(0,h.keyringBuilderFactory)(e))),t.forEach((e=>Ce.push((0,bt.hardwareKeyringBuilderFactory)(e.keyring,e.bridge))))}else Ce.push((0,bt.hardwareKeyringBuilderFactory)(C.TrezorKeyring,(null==ye?void 0:ye.trezorBridge)||Tt.TrezorOffscreenBridge),(0,bt.hardwareKeyringBuilderFactory)(C.OneKeyKeyring,(null==ye?void 0:ye.oneKey)||Tt.TrezorOffscreenBridge),(0,bt.hardwareKeyringBuilderFactory)(y.LedgerKeyring,(null==ye?void 0:ye.ledgerBridge)||Pt.LedgerOffscreenBridge),(0,h.keyringBuilderFactory)(Nt.LatticeKeyringOffscreen));const we=this.controllerMessenger.getRestricted({name:"SnapKeyring",allowedActions:["ApprovalController:addRequest","ApprovalController:acceptRequest","ApprovalController:rejectRequest","ApprovalController:startFlow","ApprovalController:endFlow","ApprovalController:showSuccess","ApprovalController:showError","PhishingController:test","PhishingController:maybeUpdateState","KeyringController:getAccounts","AccountsController:setSelectedAccount","AccountsController:getAccountByAddress","AccountsController:setAccountName","AccountsController:listMultichainAccounts","SnapController:handleRequest","SnapController:get","SnapController:isMinimumPlatformVersion","PreferencesController:getState"]}),Se=async()=>{await this.keyringController.persistAllKeyrings(),await this.accountsController.updateAccounts()};Ce.push((0,Mt.snapKeyringBuilder)(we,{persistKeyringHelper:()=>Se(),removeAccountHelper:e=>this.removeAccount(e),trackEvent:(...e)=>this.metaMetricsController.trackEvent(...e)}));const ke=this.controllerMessenger.getRestricted({name:"KeyringController"});this.keyringController=new h.KeyringController({cacheEncryptionKey:!0,keyringBuilders:Ce,state:n.KeyringController,encryptor:e.encryptor||(0,Et.encryptorFactory)(6e5),messenger:ke}),this.controllerMessenger.subscribe("KeyringController:unlock",(()=>this._onUnlock())),this.controllerMessenger.subscribe("KeyringController:lock",(()=>this._onLock())),this.controllerMessenger.subscribe("KeyringController:stateChange",(e=>{this._onKeyringControllerUpdate(e)})),this.permissionController=new R.PermissionController({messenger:this.controllerMessenger.getRestricted({name:"PermissionController",allowedActions:[`${this.approvalController.name}:addRequest`,`${this.approvalController.name}:hasRequest`,`${this.approvalController.name}:acceptRequest`,`${this.approvalController.name}:rejectRequest`,"SnapController:getPermitted","SnapController:install","SubjectMetadataController:getSubjectMetadata"]}),state:n.PermissionController,caveatSpecifications:(0,wt.getCaveatSpecifications)({listAccounts:this.accountsController.listAccounts.bind(this.accountsController),findNetworkClientIdByChainId:this.networkController.findNetworkClientIdByChainId.bind(this.networkController),isNonEvmScopeSupported:this.controllerMessenger.call.bind(this.controllerMessenger,"MultichainRouter:isSupportedScope"),getNonEvmAccountAddresses:this.controllerMessenger.call.bind(this.controllerMessenger,"MultichainRouter:getSupportedAccounts")}),permissionSpecifications:{...(0,wt.getPermissionSpecifications)(),...this.getSnapPermissionSpecifications()},unrestrictedMethods:wt.unrestrictedMethods}),this.selectedNetworkController=new x.SelectedNetworkController({messenger:this.controllerMessenger.getRestricted({name:"SelectedNetworkController",allowedActions:["NetworkController:getNetworkClientById","NetworkController:getState","NetworkController:getSelectedNetworkClient","PermissionController:hasPermissions","PermissionController:getSubjectNames"],allowedEvents:["NetworkController:stateChange","PermissionController:stateChange"]}),state:n.SelectedNetworkController,useRequestQueuePreference:!0,onPreferencesStateChange:()=>{},domainProxyMap:new _t.WeakRefObjectMap}),this.permissionLogController=new B.PermissionLogController({messenger:this.controllerMessenger.getRestricted({name:"PermissionLogController"}),restrictedMethods:new Set(Object.keys(de.RestrictedMethods)),state:n.PermissionLogController}),this.subjectMetadataController=new R.SubjectMetadataController({messenger:this.controllerMessenger.getRestricted({name:"SubjectMetadataController",allowedActions:[`${this.permissionController.name}:hasPermissions`]}),state:n.SubjectMetadataController,subjectCacheLimit:100});const Pe=this.controllerMessenger.getRestricted({name:"MultichainRouter",allowedActions:["SnapController:getAll","SnapController:handleRequest",`${this.permissionController.name}:getPermissions`,"AccountsController:listMultichainAccounts"],allowedEvents:[]});this.multichainRouter=new D.MultichainRouter({messenger:Pe,withSnapKeyring:async e=>e({keyring:await this.getSnapKeyring()})}),this.accountTrackerController=new ze.default({state:{accounts:{}},messenger:this.controllerMessenger.getRestricted({name:"AccountTrackerController",allowedActions:["AccountsController:getSelectedAccount","NetworkController:getState","NetworkController:getNetworkClientById","OnboardingController:getState","PreferencesController:getState"],allowedEvents:["AccountsController:selectedEvmAccountChange","OnboardingController:stateChange","KeyringController:accountRemoved"]}),provider:this.provider,blockTracker:this.blockTracker,getNetworkIdentifier:e=>{const{type:t,rpcUrl:r}=e??(0,Ee.getProviderConfig)({metamask:this.networkController.state});return t===ie.NETWORK_TYPES.RPC?r:t}}),this.on("controllerConnectionChanged",(e=>{const{completedOnboarding:t}=this.onboardingController.state;e>0&&t?this.triggerNetworkrequests():this.stopNetworkRequests()})),this.controllerMessenger.subscribe(`${this.onboardingController.name}:stateChange`,(0,ft.previousValueComparator)((async(e,t)=>{const{completedOnboarding:r}=e,{completedOnboarding:n,firstTimeFlowType:s}=t;if(!r&&n){const{address:e}=this.accountsController.getSelectedAccount();s===je.FirstTimeFlowType.socialImport?await this._importAccountsWithBalances():await this._addAccountsWithBalance(),this.postOnboardingInitialization(),this.triggerNetworkrequests(),await this.tokenDetectionController.detectTokens({selectedAddress:e})}}),this.onboardingController.state));const Me=this.controllerMessenger.getRestricted({name:"TokenDetectionController",allowedActions:["AccountsController:getAccount","AccountsController:getSelectedAccount","KeyringController:getState","NetworkController:getNetworkClientById","NetworkController:getNetworkConfigurationByNetworkClientId","NetworkController:getState","PreferencesController:getState","TokenListController:getState","TokensController:getState","TokensController:addDetectedTokens"],allowedEvents:["AccountsController:selectedEvmAccountChange","KeyringController:lock","KeyringController:unlock","NetworkController:networkDidChange","PreferencesController:stateChange","TokenListController:stateChange","TransactionController:transactionConfirmed"]});this.tokenDetectionController=new a.TokenDetectionController({messenger:Me,getBalancesInSingleCall:(...e)=>this.assetsContractController.getBalancesInSingleCall(...e),trackMetaMetricsEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController),useAccountsAPI:!0,platform:"extension"});const Ie=this.controllerMessenger.getRestricted({name:"AddressBookController",allowedActions:[],allowedEvents:[]});this.addressBookController=new P.AddressBookController({messenger:Ie,state:n.AddressBookController}),this.alertController=new it.AlertController({state:n.AlertController,messenger:this.controllerMessenger.getRestricted({name:"AlertController",allowedEvents:["AccountsController:selectedAccountChange"],allowedActions:["AccountsController:getSelectedAccount"]})}),this.backup=new lt.default({preferencesController:this.preferencesController,addressBookController:this.addressBookController,accountsController:this.accountsController,networkController:this.networkController,trackMetaMetricsEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController)}),this.snapAndHardwareMetricsParams={getSelectedAccount:this.accountsController.getSelectedAccount.bind(this.accountsController),getAccountType:this.getAccountType.bind(this),getDeviceModel:this.getDeviceModel.bind(this),getHardwareTypeForMetric:this.getHardwareTypeForMetric.bind(this),snapAndHardwareMessenger:this.controllerMessenger.getRestricted({name:"SnapAndHardwareMessenger",allowedActions:["KeyringController:getKeyringForAccount","SnapController:get","AccountsController:getSelectedAccount"]})},this.decryptMessageController=new dt.default({getState:this.getState.bind(this),messenger:this.controllerMessenger.getRestricted({name:"DecryptMessageController",allowedActions:[`${this.approvalController.name}:addRequest`,`${this.approvalController.name}:acceptRequest`,`${this.approvalController.name}:rejectRequest`,`${this.keyringController.name}:decryptMessage`],allowedEvents:["DecryptMessageManager:stateChange","DecryptMessageManager:unapprovedMessage"]}),managerMessenger:this.controllerMessenger.getRestricted({name:"DecryptMessageManager"}),metricsEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController)}),this.encryptionPublicKeyController=new Ct.default({messenger:this.controllerMessenger.getRestricted({name:"EncryptionPublicKeyController",allowedActions:[`${this.approvalController.name}:addRequest`,`${this.approvalController.name}:acceptRequest`,`${this.approvalController.name}:rejectRequest`],allowedEvents:["EncryptionPublicKeyManager:stateChange","EncryptionPublicKeyManager:unapprovedMessage"]}),managerMessenger:this.controllerMessenger.getRestricted({name:"EncryptionPublicKeyManager"}),getEncryptionPublicKey:this.keyringController.getEncryptionPublicKey.bind(this.keyringController),getAccountKeyringType:this.keyringController.getAccountKeyringType.bind(this.keyringController),getState:this.getState.bind(this),metricsEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController)}),this.signatureController=new K.SignatureController({messenger:this.controllerMessenger.getRestricted({name:"SignatureController",allowedActions:[`${this.accountsController.name}:getState`,`${this.approvalController.name}:addRequest`,`${this.keyringController.name}:signMessage`,`${this.keyringController.name}:signPersonalMessage`,`${this.keyringController.name}:signTypedMessage`,`${this.loggingController.name}:add`,`${this.networkController.name}:getNetworkClientById`]}),trace:Ae.trace,decodingApiUrl:"https://signature-insights.api.cx.metamask.io/v1",isDecodeSignatureRequestEnabled:()=>this.preferencesController.state.useTransactionSimulations}),this.signatureController.hub.on("cancelWithReason",(({metadata:e,reason:t})=>{this.metaMetricsController.trackEvent({event:t,category:me.MetaMetricsEventCategory.Transactions,properties:{action:"Sign Request",type:e.type}})}));const _e=this.controllerMessenger.getRestricted({name:"SwapsController",allowedActions:["NetworkController:getState","NetworkController:getNetworkClientById","TokenRatesController:getState"],allowedEvents:[]});this.swapsController=new ut.default({messenger:_e,getBufferedGasLimit:async(e,t)=>{const{gas:r,simulationFails:n}=await this.txController.estimateGasBuffered(e.txParams,t,fr(wr,this,Mr).call(this));return{gasLimit:r,simulationFails:n}},getEIP1559GasFeeEstimates:this.gasFeeController.fetchGasFeeEstimates.bind(this.gasFeeController),getLayer1GasFee:(...e)=>this.txController.getLayer1GasFee(...e),trackMetaMetricsEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController)},n.SwapsController);const Re=this.controllerMessenger.getRestricted({name:W.BRIDGE_CONTROLLER_NAME,allowedActions:["AccountsController:getSelectedMultichainAccount","SnapController:handleRequest","NetworkController:getState","NetworkController:getNetworkClientById","NetworkController:findNetworkClientIdByChainId","TokenRatesController:getState","MultichainAssetsRatesController:getState","RemoteFeatureFlagController:getState","CurrencyRateController:getState"],allowedEvents:[]});this.bridgeController=new W.BridgeController({messenger:Re,clientId:W.BridgeClientId.EXTENSION,getLayer1GasFee:(...e)=>this.txController.getLayer1GasFee(...e),fetchFn:async(e,{cacheOptions:t,functionName:r,...n})=>"fetchBridgeTokens"===r?await(0,Ne.default)({url:e,fetchOptions:{method:"GET",...n},cacheOptions:t,functionName:r}):await(0,$.handleFetch)(e,{method:"GET",...n}),trackMetaMetricsFn:(e,t)=>{const r=(Date.now()+Math.random()).toString();this.metaMetricsController.trackEvent.bind(this.metaMetricsController)({category:W.UNIFIED_SWAP_BRIDGE_EVENT_CATEGORY,event:e,properties:{...t??{},environmentType:(0,ft.getEnvironmentType)(),actionId:r}})},traceFn:(...e)=>(0,Ae.trace)(...e),config:{customBridgeApiBaseUrl:Oe.BRIDGE_API_BASE_URL}});const xe=this.controllerMessenger.getRestricted({name:re.BRIDGE_STATUS_CONTROLLER_NAME,allowedActions:["AccountsController:getSelectedMultichainAccount","NetworkController:getNetworkClientById","NetworkController:findNetworkClientIdByChainId","NetworkController:getState","BridgeController:getBridgeERC20Allowance","BridgeController:trackUnifiedSwapBridgeEvent","BridgeController:stopPollingForQuotes","GasFeeController:getState","AccountsController:getAccountByAddress","SnapController:handleRequest","TransactionController:getState","RemoteFeatureFlagController:getState"],allowedEvents:["MultichainTransactionsController:transactionConfirmed","TransactionController:transactionFailed","TransactionController:transactionConfirmed"]});this.bridgeStatusController=new re.BridgeStatusController({messenger:xe,state:n.BridgeStatusController,fetchFn:async(e,t)=>await(0,$.handleFetch)(e,{method:"GET",...t}),addTransactionFn:(...e)=>this.txController.addTransaction(...e),addTransactionBatchFn:(...e)=>this.txController.addTransactionBatch(...e),estimateGasFeeFn:(...e)=>this.txController.estimateGasFee(...e),updateTransactionFn:(...e)=>this.txController.updateTransaction(...e),config:{customBridgeApiBaseUrl:Oe.BRIDGE_API_BASE_URL},traceFn:(...e)=>(0,Ae.trace)(...e)});const Be=()=>this.preferencesController.state.useExternalNameSources;this.nameController=new H.NameController({messenger:this.controllerMessenger.getRestricted({name:"NameController",allowedActions:[]}),providers:[new H.ENSNameProvider({reverseLookup:this.ensController.reverseResolveAddress.bind(this.ensController)}),new H.EtherscanNameProvider({isEnabled:Be}),new H.TokenNameProvider({isEnabled:Be}),new H.LensNameProvider({isEnabled:Be}),new Ue.SnapsNameProvider({messenger:this.controllerMessenger.getRestricted({name:"SnapsNameProvider",allowedActions:["SnapController:getAll","SnapController:get","SnapController:handleRequest","PermissionController:getState"]})})],state:n.NameController});const De=this.controllerMessenger.getRestricted({name:"PetnamesBridge",allowedEvents:["NameController:stateChange","AccountsController:stateChange","AddressBookController:stateChange"],allowedActions:["AccountsController:listAccounts"]});new Ke.AddressBookPetnamesBridge({addressBookController:this.addressBookController,nameController:this.nameController,messenger:De}).init(),new qe.AccountIdentitiesPetnamesBridge({nameController:this.nameController,messenger:De}).init(),this.userOperationController=new V.UserOperationController({entrypoint:null,getGasFeeEstimates:this.gasFeeController.fetchGasFeeEstimates.bind(this.gasFeeController),messenger:this.controllerMessenger.getRestricted({name:"UserOperationController",allowedActions:["ApprovalController:addRequest","NetworkController:getNetworkClientById","KeyringController:prepareUserOperation","KeyringController:patchUserOperation","KeyringController:signUserOperation"]}),state:n.UserOperationController}),this.userOperationController.hub.on("user-operation-added",this._onUserOperationAdded.bind(this)),this.userOperationController.hub.on("transaction-updated",this._onUserOperationTransactionUpdated.bind(this)),i.subscribe("NetworkController:networkDidChange",(()=>{this.accountTrackerController.updateAccounts()})),this.controllerMessenger.subscribe("PreferencesController:stateChange",(0,ft.previousValueComparator)(((e,t)=>{const{useExternalServices:r}=e,{useExternalServices:n}=t;n&&!r?(this.remoteFeatureFlagController.enable(),this.remoteFeatureFlagController.updateRemoteFeatureFlags()):!n&&r&&this.remoteFeatureFlagController.disable()}),this.preferencesController.state));const Fe=this.controllerMessenger.getRestricted({name:"RemoteFeatureFlagController",allowedActions:[],allowedEvents:[]});Fe.subscribe("RemoteFeatureFlagController:stateChange",(e=>{e?(console.log("isRpcFailoverEnabled = ",e,", enabling RPC failover"),this.networkController.enableRpcFailover()):(console.log("isRpcFailoverEnabled = ",e,", disabling RPC failover"),this.networkController.disableRpcFailover())}),(e=>e.remoteFeatureFlags.walletFrameworkRpcFailoverEnabled)),this.remoteFeatureFlagController=new U.RemoteFeatureFlagController({messenger:Fe,fetchInterval:9e5,disabled:!this.preferencesController.state.useExternalServices,getMetaMetricsId:()=>this.metaMetricsController.getMetaMetricsId(),clientConfigApiService:new U.ClientConfigApiService({fetch:globalThis.fetch.bind(globalThis),config:{client:U.ClientType.Extension,distribution:this._getConfigForRemoteFeatureFlagRequest().distribution,environment:this._getConfigForRemoteFeatureFlagRequest().environment}})});const $e=[this.networkController,this.preferencesController,this.gasFeeController,this.onboardingController,this.keyringController,this.metaMetricsController,this.accountsController],Le={ExecutionService:Yt.ExecutionServiceInit,InstitutionalSnapController:qt.InstitutionalSnapControllerInit,RateLimitController:Yt.RateLimitControllerInit,SnapsRegistry:Yt.SnapsRegistryInit,CronjobController:Yt.CronjobControllerInit,SnapController:Yt.SnapControllerInit,SnapInsightsController:Yt.SnapInsightsControllerInit,SnapInterfaceController:Yt.SnapInterfaceControllerInit,WebSocketService:Yt.WebSocketServiceInit,PPOMController:Gt.PPOMControllerInit,TransactionController:Wt.TransactionControllerInit,SmartTransactionsController:zt.SmartTransactionsControllerInit,NftController:Vt.NftControllerInit,AssetsContractController:Vt.AssetsContractControllerInit,NftDetectionController:Vt.NftDetectionControllerInit,TokenRatesController:Vt.TokenRatesControllerInit,MultichainAssetsController:Ht.MultichainAssetsControllerInit,MultichainAssetsRatesController:Ht.MultichainAssetsRatesControllerInit,MultichainBalancesController:Ht.MultichainBalancesControllerInit,MultichainTransactionsController:Ht.MultichainTransactionsControllerInit,MultichainNetworkController:Ht.MultichainNetworkControllerInit,AuthenticationController:Qt.AuthenticationControllerInit,UserStorageController:Xt.UserStorageControllerInit,NotificationServicesController:tr.NotificationServicesControllerInit,NotificationServicesPushController:rr.NotificationServicesPushControllerInit,DeFiPositionsController:Zt.DeFiPositionsControllerInit,DelegationController:nr.DelegationControllerInit,AccountTreeController:ir.AccountTreeControllerInit,SeedlessOnboardingController:dr.SeedlessOnboardingControllerInit},{controllerApi:He,controllerMemState:Ve,controllerPersistedState:Je,controllersByName:Ye}=fr(wr,this,Er).call(this,{existingControllers:$e,initFunctions:Le,initState:n});this.controllerApi=He,this.controllerMemState=Ve,this.controllerPersistedState=Je,this.controllersByName=Ye,this.cronjobController=Ye.CronjobController,this.rateLimitController=Ye.RateLimitController,this.snapController=Ye.SnapController,this.snapInsightsController=Ye.SnapInsightsController,this.snapInterfaceController=Ye.SnapInterfaceController,this.snapsRegistry=Ye.SnapsRegistry,this.ppomController=Ye.PPOMController,this.txController=Ye.TransactionController,this.smartTransactionsController=Ye.SmartTransactionsController,this.nftController=Ye.NftController,this.nftDetectionController=Ye.NftDetectionController,this.assetsContractController=Ye.AssetsContractController,this.multichainAssetsController=Ye.MultichainAssetsController,this.multichainBalancesController=Ye.MultichainBalancesController,this.multichainTransactionsController=Ye.MultichainTransactionsController,this.multichainAssetsRatesController=Ye.MultichainAssetsRatesController,this.tokenRatesController=Ye.TokenRatesController,this.multichainNetworkController=Ye.MultichainNetworkController,this.authenticationController=Ye.AuthenticationController,this.userStorageController=Ye.UserStorageController,this.delegationController=Ye.DelegationController,this.notificationServicesController=Ye.NotificationServicesController,this.notificationServicesPushController=Ye.NotificationServicesPushController,this.deFiPositionsController=Ye.DeFiPositionsController,this.accountWalletController=Ye.AccountTreeController,this.seedlessOnboardingController=Ye.SeedlessOnboardingController,this.notificationServicesController.init(),this.snapController.init(),this.cronjobController.init(),this.controllerMessenger.subscribe("TransactionController:transactionStatusUpdated",(({transactionMeta:e})=>{this._onFinishedTransaction(e)})),this.controllerMessenger.subscribe("NotificationServicesPushController:onNewNotifications",(e=>{this.metaMetricsController.trackEvent({category:me.MetaMetricsEventCategory.PushNotifications,event:me.MetaMetricsEventName.PushNotificationReceived,properties:{notification_id:e.id,notification_type:e.type,chain_id:null==e?void 0:e.chain_id}})})),this.controllerMessenger.subscribe("NotificationServicesPushController:pushNotificationClicked",(e=>{this.metaMetricsController.trackEvent({category:me.MetaMetricsEventCategory.PushNotifications,event:me.MetaMetricsEventName.PushNotificationClicked,properties:{notification_id:e.id,notification_type:e.type,chain_id:null==e?void 0:e.chain_id}})})),this.metamaskMiddleware=(0,gt.default)({static:{eth_syncing:!1,web3_clientVersion:`MetaMask/v${s}`},version:s,getAccounts:({origin:e})=>{if(e===pe.ORIGIN_METAMASK){const e=this.accountsController.getSelectedAccount().address;return e?[e]:[]}return this.isUnlocked()?this.getPermittedAccounts(e):[]},processTransaction:(e,t)=>(0,At.addDappTransaction)(this.getAddTransactionRequest({transactionParams:e,dappRequest:t})),processTypedMessage:(...e)=>(0,It.addTypedMessage)({signatureController:this.signatureController,signatureParams:e}),processTypedMessageV3:(...e)=>(0,It.addTypedMessage)({signatureController:this.signatureController,signatureParams:e}),processTypedMessageV4:(...e)=>(0,It.addTypedMessage)({signatureController:this.signatureController,signatureParams:e}),processPersonalMessage:(...e)=>(0,It.addPersonalMessage)({signatureController:this.signatureController,signatureParams:e}),processEncryptionPublicKey:this.encryptionPublicKeyController.newRequestEncryptionPublicKey.bind(this.encryptionPublicKeyController),processDecryptMessage:this.decryptMessageController.newRequestDecryptMessage.bind(this.decryptMessageController),getPendingNonce:this.getPendingNonce.bind(this),getPendingTransactionByHash:e=>this.txController.state.transactions.find((t=>t.hash===e&&t.status===G.TransactionStatus.submitted)),processSendCalls:er.processSendCalls.bind(null,{addTransaction:this.txController.addTransaction.bind(this.txController),addTransactionBatch:this.txController.addTransactionBatch.bind(this.txController),getDismissSmartAccountSuggestionEnabled:()=>this.preferencesController.state.preferences.dismissSmartAccountSuggestionEnabled,isAtomicBatchSupported:this.txController.isAtomicBatchSupported.bind(this.txController),validateSecurity:(e,t,r)=>(0,xt.validateRequestWithPPOM)({chainId:r,ppomController:this.ppomController,request:t,securityAlertId:e,updateSecurityAlertResponse:this.updateSecurityAlertResponse.bind(this)})},this.controllerMessenger),getCallsStatus:er.getCallsStatus.bind(null,this.controllerMessenger),getCapabilities:er.getCapabilities.bind(null,{getDismissSmartAccountSuggestionEnabled:()=>this.preferencesController.state.preferences.dismissSmartAccountSuggestionEnabled,getIsSmartTransaction:e=>(0,Te.getIsSmartTransaction)(this._getMetaMaskState(),e),isAtomicBatchSupported:this.txController.isAtomicBatchSupported.bind(this.txController),isRelaySupported:or.isRelaySupported},this.controllerMessenger)}),this.on("update",(e=>this._onStateUpdate(e)));const Qe={AccountTracker:this.accountTrackerController,TokenRatesController:this.tokenRatesController,DecryptMessageController:this.decryptMessageController,EncryptionPublicKeyController:this.encryptionPublicKeyController,SignatureController:this.signatureController,SwapsController:this.swapsController,BridgeController:this.bridgeController,BridgeStatusController:this.bridgeStatusController,EnsController:this.ensController,ApprovalController:this.approvalController};this.store.updateStructure({AccountsController:this.accountsController,AppStateController:this.appStateController,AppMetadataController:this.appMetadataController,KeyringController:this.keyringController,PreferencesController:this.preferencesController,MetaMetricsController:this.metaMetricsController,MetaMetricsDataDeletionController:this.metaMetricsDataDeletionController,AddressBookController:this.addressBookController,CurrencyController:this.currencyRateController,MultichainNetworkController:this.multichainNetworkController,NetworkController:this.networkController,AlertController:this.alertController,OnboardingController:this.onboardingController,SeedlessOnboardingController:this.seedlessOnboardingController,PermissionController:this.permissionController,PermissionLogController:this.permissionLogController,SubjectMetadataController:this.subjectMetadataController,AnnouncementController:this.announcementController,NetworkOrderController:this.networkOrderController,AccountOrderController:this.accountOrderController,GasFeeController:this.gasFeeController,TokenListController:this.tokenListController,TokensController:this.tokensController,TokenBalancesController:this.tokenBalancesController,SmartTransactionsController:this.smartTransactionsController,NftController:this.nftController,PhishingController:this.phishingController,SelectedNetworkController:this.selectedNetworkController,LoggingController:this.loggingController,MultichainRatesController:this.multichainRatesController,NameController:this.nameController,UserOperationController:this.userOperationController,AuthenticationController:this.authenticationController,UserStorageController:this.userStorageController,NotificationServicesController:this.notificationServicesController,NotificationServicesPushController:this.notificationServicesPushController,RemoteFeatureFlagController:this.remoteFeatureFlagController,DeFiPositionsController:this.deFiPositionsController,...Qe,...Je}),this.memStore=new Ge.default({config:{AccountsController:this.accountsController,AppStateController:this.appStateController,AppMetadataController:this.appMetadataController,MultichainAssetsController:this.multichainAssetsController,MultichainBalancesController:this.multichainBalancesController,MultichainTransactionsController:this.multichainTransactionsController,MultichainAssetsRatesController:this.multichainAssetsRatesController,TokenRatesController:this.tokenRatesController,MultichainNetworkController:this.multichainNetworkController,NetworkController:this.networkController,KeyringController:this.keyringController,PreferencesController:this.preferencesController,MetaMetricsController:this.metaMetricsController,MetaMetricsDataDeletionController:this.metaMetricsDataDeletionController,AddressBookController:this.addressBookController,CurrencyController:this.currencyRateController,AlertController:this.alertController,OnboardingController:this.onboardingController,SeedlessOnboardingController:this.seedlessOnboardingController,PermissionController:this.permissionController,PermissionLogController:this.permissionLogController,SubjectMetadataController:this.subjectMetadataController,AnnouncementController:this.announcementController,NetworkOrderController:this.networkOrderController,AccountOrderController:this.accountOrderController,GasFeeController:this.gasFeeController,TokenListController:this.tokenListController,TokensController:this.tokensController,TokenBalancesController:this.tokenBalancesController,SmartTransactionsController:this.smartTransactionsController,NftController:this.nftController,SelectedNetworkController:this.selectedNetworkController,LoggingController:this.loggingController,MultichainRatesController:this.multichainRatesController,SnapController:this.snapController,CronjobController:this.cronjobController,SnapsRegistry:this.snapsRegistry,SnapInterfaceController:this.snapInterfaceController,SnapInsightsController:this.snapInsightsController,NameController:this.nameController,UserOperationController:this.userOperationController,AuthenticationController:this.authenticationController,UserStorageController:this.userStorageController,NotificationServicesController:this.notificationServicesController,NotificationServicesPushController:this.notificationServicesPushController,RemoteFeatureFlagController:this.remoteFeatureFlagController,DeFiPositionsController:this.deFiPositionsController,PhishingController:this.phishingController,...Qe,...Ve},controllerMessenger:this.controllerMessenger});const Xe=[this.accountTrackerController.resetState.bind(this.accountTrackerController),this.decryptMessageController.resetState.bind(this.decryptMessageController),this.encryptionPublicKeyController.resetState.bind(this.encryptionPublicKeyController),this.signatureController.resetState.bind(this.signatureController),this.swapsController.resetState.bind(this.swapsController),this.bridgeController.resetState.bind(this.bridgeController),this.ensController.resetState.bind(this.ensController),this.approvalController.clear.bind(this.approvalController)];ve.isManifestV3?!0===r&&(this.resetStates(Xe),this.extension.storage.session.set({isFirstMetaMaskControllerSetup:!1})):this.resetStates(Xe);!this.isUnlocked()&&this.onboardingController.state.completedOnboarding,this._startUISync(),this.extension.runtime.getPlatformInfo().then((({os:e})=>{this.appStateController.setBrowserEnvironment(e,this.extension.runtime.getBrowserInfo===undefined?"chrome":"firefox")})),this.setupControllerEventSubscriptions(),this.setupMultichainDataAndSubscriptions(),this.publicConfigStore=this.createPublicConfigStore(),this.extension.runtime.onMessageExternal.addListener(We.onMessageReceived),(0,We.checkForMultipleVersionsRunning)(),this.onboardingController.state.completedOnboarding&&this.postOnboardingInitialization()}getInfuraFeatureFlags(){(0,Ne.default)({url:"https://swap.api.cx.metamask.io/featureFlags",cacheRefreshTime:20*he.MINUTE}).then(this.onFeatureFlagResponseReceived).catch((e=>{b.default.warn("Feature flag endpoint is unreachable",e)}))}onFeatureFlagResponseReceived(e){const{multiChainAssets:t={}}=e,{pollInterval:r}=t;r>0&&this.tokenBalancesController.setIntervalLength(r*he.SECOND)}postOnboardingInitialization(){const{usePhishDetect:e}=this.preferencesController.state;this.networkController.lookupNetwork(),e&&this.phishingController.maybeUpdateState()}triggerNetworkrequests(){this.tokenDetectionController.enable(),this.getInfuraFeatureFlags(),(0,Y.isEvmAccountType)(this.accountsController.getSelectedMultichainAccount().type)||this.multichainRatesController.start()}stopNetworkRequests(){this.txController.stopIncomingTransactionPolling(),this.tokenDetectionController.disable(),this.multichainRatesController.stop()}resetStates(e){e.forEach((e=>{try{e()}catch(e){console.error(e)}}))}async getSnapKeyring(){let[e]=this.keyringController.getKeyringsByType(le.KeyringType.snap);return e||(await this.keyringController.addNewKeyring(le.KeyringType.snap),[e]=this.keyringController.getKeyringsByType(le.KeyringType.snap)),e}trackInsightSnapView(e){this.metaMetricsController.trackEvent({event:me.MetaMetricsEventName.InsightSnapViewed,category:me.MetaMetricsEventCategory.Snaps,properties:{snap_id:e}})}_getSnapMetadata(e){var t;return null===(t=this.snapsRegistry.state.database)||void 0===t||null===(t=t.verifiedSnaps)||void 0===t||null===(t=t[e])||void 0===t?void 0:t.metadata}async handleSnapRequest(e){return await this.controllerMessenger.call("SnapController:handleRequest",e)}getLocale(){const{currentLocale:e}=this.preferencesController.state;return e}getPreferences(){const{preferences:e,securityAlertsEnabled:t,useCurrencyRateCheck:r,useTransactionSimulations:n,useTokenDetection:s,useMultiAccountBalanceChecker:a,openSeaEnabled:o,useNftDetection:i}=this.preferencesController.state;return{privacyMode:e.privacyMode,showTestnets:e.showTestNetworks,securityAlertsEnabled:t,useCurrencyRateCheck:r,useTransactionSimulations:n,useTokenDetection:s,useMultiAccountBalanceChecker:a,openSeaEnabled:o,useNftDetection:i}}getSnapPermissionSpecifications(){return{...(0,F.buildSnapEndowmentSpecifications)(Object.keys(de.ExcludedSnapEndowments)),...(0,F.buildSnapRestrictedMethodSpecifications)(Object.keys(de.ExcludedSnapPermissions),{getPreferences:()=>{const e=this.getLocale(),t=this.currencyRateController.state.currentCurrency,{privacyMode:r,securityAlertsEnabled:n,useCurrencyRateCheck:s,useTransactionSimulations:a,useTokenDetection:o,useMultiAccountBalanceChecker:i,openSeaEnabled:c,useNftDetection:l,showTestnets:d}=this.getPreferences();return{locale:e,currency:t,hideBalances:r,useSecurityAlerts:n,useExternalPricingData:s,simulateOnChainActions:a,useTokenDetection:o,batchCheckBalances:i,displayNftMedia:c,useNftDetection:l,showTestnets:d}},clearSnapState:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:clearSnapState"),getMnemonic:async e=>{if(!e)return this.getPrimaryKeyringMnemonic();try{const{type:t,mnemonic:r}=await this.controllerMessenger.call("KeyringController:withKeyring",{id:e},(async({keyring:e})=>({type:e.type,mnemonic:e.mnemonic})));if(t!==h.KeyringTypes.hd||!r)throw new Error(`Entropy source with ID "${e}" not found.`);return r}catch{throw new Error(`Entropy source with ID "${e}" not found.`)}},getMnemonicSeed:async e=>{if(!e)return this.getPrimaryKeyringMnemonicSeed();try{const{type:t,seed:r}=await this.controllerMessenger.call("KeyringController:withKeyring",{id:e},(async({keyring:e})=>({type:e.type,seed:e.seed})));if(t!==h.KeyringTypes.hd||!r)throw new Error(`Entropy source with ID "${e}" not found.`);return r}catch{throw new Error(`Entropy source with ID "${e}" not found.`)}},getUnlockPromise:this.appStateController.getUnlockPromise.bind(this.appStateController),getSnap:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:get"),handleSnapRpcRequest:this.handleSnapRequest.bind(this),getSnapState:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:getSnapState"),requestUserApproval:this.approvalController.addAndShowApprovalRequest.bind(this.approvalController),showNativeNotification:(e,t)=>this.controllerMessenger.call("RateLimitController:call",e,"showNativeNotification",e,t.message),showInAppNotification:(e,t)=>{const{message:r,title:n,footerLink:s}=t,a={interfaceId:t.content,message:r,title:n,footerLink:s};return this.controllerMessenger.call("RateLimitController:call",e,"showInAppNotification",e,a)},updateSnapState:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:updateSnapState"),maybeUpdatePhishingList:()=>{const{usePhishDetect:e}=this.preferencesController.state;e&&this.controllerMessenger.call("PhishingController:maybeUpdateState")},isOnPhishingList:e=>{const{usePhishDetect:t}=this.preferencesController.state;return!!t&&this.controllerMessenger.call("PhishingController:testOrigin",e).result},createInterface:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapInterfaceController:createInterface"),getInterface:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapInterfaceController:getInterface"),getClientCryptography:()=>({}),getSnapKeyring:this.getSnapKeyring.bind(this)})}}setupControllerEventSubscriptions(){let e,t;try{var r;t=null===(r=this.accountsController.getSelectedMultichainAccount(_e.MultichainNetworks.SOLANA))||void 0===r?void 0:r.address}catch{}this.controllerMessenger.subscribe("PreferencesController:stateChange",(0,ft.previousValueComparator)((async(e,t)=>{const{currentLocale:r}=t;await(0,Be.updateCurrentLocale)(r),fr(wr,this,kr).call(this,t,e)}),this.preferencesController.state)),this.controllerMessenger.subscribe(`${this.accountsController.name}:selectedAccountChange`,(async t=>{t.address&&t.address!==e&&(e=t.address,await this._onAccountChange(t.address))})),this.controllerMessenger.subscribe(`${this.permissionController.name}:stateChange`,(async(e,t)=>{const r=(0,wt.diffMap)(e,t);for(const[e,t]of r.entries())this._notifyAccountsChange(e,t)}),wt.getPermittedAccountsByOrigin),this.controllerMessenger.subscribe(`${this.permissionController.name}:stateChange`,(async(e,t)=>{const r=(0,wt.getChangedAuthorizations)(e,t),n=(0,wt.getRemovedAuthorizations)(e,t);for(const[e,t]of n.entries()){const r=(0,te.getSessionScopes)(t,{getNonEvmSupportedMethods:this.getNonEvmSupportedMethods.bind(this)});Object.entries(r).forEach((([t,r])=>{r.notifications.includes("eth_subscription")&&r.methods.includes("eth_subscribe")&&this.removeMultichainApiEthSubscriptionMiddleware({scope:t,origin:e})}))}for(const[e,t]of r.entries()){const r=(0,te.getSessionScopes)(t,{getNonEvmSupportedMethods:this.getNonEvmSupportedMethods.bind(this)});Object.entries(r).forEach((([t,r])=>{r.notifications.includes("eth_subscription")&&r.methods.includes("eth_subscribe")?Object.values(this.connections[e]??{}).forEach((({tabId:r})=>{this.addMultichainApiEthSubscriptionMiddleware({scope:t,origin:e,tabId:r})})):this.removeMultichainApiEthSubscriptionMiddleware({scope:t,origin:e})})),this._notifyAuthorizationChange(e,t)}}),wt.getAuthorizedScopesByOrigin),this.controllerMessenger.subscribe(`${this.permissionController.name}:stateChange`,(async(e,t)=>{(0,u.uniq)([...t.keys(),...e.keys()]).forEach((r=>{var n,s;const a=t.get(r),o=e.get(r),i=Boolean(null==a||null===(n=a.sessionProperties)||void 0===n?void 0:n[te.KnownSessionProperties.SolanaAccountChangedNotifications]),c=Boolean(null==o||null===(s=o.sessionProperties)||void 0===s?void 0:s[te.KnownSessionProperties.SolanaAccountChangedNotifications]);if(!i&&!c)return;const l=(a?(0,te.getPermittedAccountsForScopes)(a,[_e.MultichainNetworks.SOLANA,_e.MultichainNetworks.SOLANA_DEVNET,_e.MultichainNetworks.SOLANA_TESTNET]):[]).map((e=>{const{address:t}=(0,Q.parseCaipAccountId)(e);return t})),d=(0,u.uniq)(l),[h]=this.sortMultichainAccountsByLastSelected(d),p=(o?(0,te.getPermittedAccountsForScopes)(o,[_e.MultichainNetworks.SOLANA,_e.MultichainNetworks.SOLANA_DEVNET,_e.MultichainNetworks.SOLANA_TESTNET]):[]).map((e=>{const{address:t}=(0,Q.parseCaipAccountId)(e);return t})),m=(0,u.uniq)(p),[f]=this.sortMultichainAccountsByLastSelected(m);h!==f&&this._notifySolanaAccountChange(r,f?[f]:[])}))}),wt.getAuthorizedScopesByOrigin),this.controllerMessenger.subscribe(`${this.accountsController.name}:selectedAccountChange`,(async e=>{if(e.type===Y.SolAccountType.DataAccount&&e.address!==t){t=e.address;const r=(0,wt.getOriginsWithSessionProperty)(this.permissionController.state,te.KnownSessionProperties.SolanaAccountChangedNotifications),n=(0,wt.getPermittedAccountsForScopesByOrigin)(this.permissionController.state,[_e.MultichainNetworks.SOLANA,_e.MultichainNetworks.SOLANA_DEVNET,_e.MultichainNetworks.SOLANA_TESTNET]);if(n.size>0)for(const[t,s]of n.entries()){s.map((e=>{const{address:t}=(0,Q.parseCaipAccountId)(e);return t})).includes(e.address)&&r[t]&&this._notifySolanaAccountChange(t,[e.address])}}})),this.controllerMessenger.subscribe(`${this.permissionController.name}:stateChange`,(async(e,t)=>{const r=(0,wt.diffMap)(e,t);for(const[e,t]of r.entries()){const r=this.selectedNetworkController.getNetworkClientIdForDomain(e),n=this.networkController.getNetworkConfigurationByNetworkClientId(r);if(!n){b.default.warn(`No network configuration found for clientId: ${r}`);continue}const{chainId:s}=n;if(t.length>0&&!t.includes(s)){const r=this.networkController.findNetworkClientIdByChainId(t[0]);this.networkController.setActiveNetwork(r),this.selectedNetworkController.setNetworkClientIdForDomain(e,r)}}}),wt.getPermittedChainsByOrigin),this.controllerMessenger.subscribe("NetworkController:networkRemoved",(({chainId:e})=>{const t=(0,Q.toCaipChainId)("eip155",(0,Q.hexToBigInt)(e).toString(10));this.removeAllScopePermissions(t)})),this.controllerMessenger.subscribe(`${this.snapController.name}:snapInstallStarted`,((e,t,r)=>{var n;const s=null===(n=this._getSnapMetadata(e))||void 0===n?void 0:n.category;this.metaMetricsController.trackEvent({event:r?me.MetaMetricsEventName.SnapUpdateStarted:me.MetaMetricsEventName.SnapInstallStarted,category:me.MetaMetricsEventCategory.Snaps,properties:{snap_id:e,origin:t,snap_category:s}})})),this.controllerMessenger.subscribe(`${this.snapController.name}:snapInstallFailed`,((e,t,r,n)=>{var s;const a=n.includes("User rejected the request."),o=r?me.MetaMetricsEventName.SnapUpdateFailed:me.MetaMetricsEventName.SnapInstallFailed,i=r?me.MetaMetricsEventName.SnapUpdateRejected:me.MetaMetricsEventName.SnapInstallRejected,c=null===(s=this._getSnapMetadata(e))||void 0===s?void 0:s.category;this.metaMetricsController.trackEvent({event:a?i:o,category:me.MetaMetricsEventCategory.Snaps,properties:{snap_id:e,origin:t,snap_category:c}})})),this.controllerMessenger.subscribe(`${this.snapController.name}:snapInstalled`,((e,t,r)=>{var n;if(r)return;const s=e.id,a=null===(n=this._getSnapMetadata(s))||void 0===n?void 0:n.category;this.metaMetricsController.trackEvent({event:me.MetaMetricsEventName.SnapInstalled,category:me.MetaMetricsEventCategory.Snaps,properties:{snap_id:s,version:e.version,origin:t,snap_category:a}})})),this.controllerMessenger.subscribe(`${this.snapController.name}:snapUpdated`,((e,t,r,n)=>{var s;if(n)return;const a=e.id,o=null===(s=this._getSnapMetadata(a))||void 0===s?void 0:s.category;this.metaMetricsController.trackEvent({event:me.MetaMetricsEventName.SnapUpdated,category:me.MetaMetricsEventCategory.Snaps,properties:{snap_id:a,old_version:t,new_version:e.version,origin:r,snap_category:o}})})),this.controllerMessenger.subscribe(`${this.snapController.name}:snapTerminated`,(e=>{const t=Object.values(this.approvalController.state.pendingApprovals).filter((t=>t.origin===e.id&&t.type.startsWith(de.RestrictedMethods.snap_dialog)));for(const e of t)this.approvalController.reject(e.id,new Error("Snap was terminated."))})),this.controllerMessenger.subscribe(`${this.snapController.name}:snapUninstalled`,(e=>{var t;const r=this.notificationServicesController.getNotificationsByType(Z.TRIGGER_TYPES.SNAP).filter((t=>t.data.origin===e.id)).map((e=>e.id));this.notificationServicesController.deleteNotificationsById(r);const n=e.id,s=null===(t=this._getSnapMetadata(n))||void 0===t?void 0:t.category;this.metaMetricsController.trackEvent({event:me.MetaMetricsEventName.SnapUninstalled,category:me.MetaMetricsEventCategory.Snaps,properties:{snap_id:n,version:e.version,snap_category:s}})}))}setupMultichainDataAndSubscriptions(){this.controllerMessenger.subscribe("AccountsController:selectedAccountChange",(e=>{0===this.activeControllerConnections||(0,Y.isEvmAccountType)(e.type)?this.multichainRatesController.stop():this.multichainRatesController.start()})),this.controllerMessenger.subscribe("CurrencyRateController:stateChange",(({currentCurrency:e})=>{e!==this.multichainRatesController.state.fiatCurrency&&this.multichainRatesController.setFiatCurrency(e)}))}addMultichainApiEthSubscriptionMiddleware({scope:e,origin:t,tabId:r}){const n=this.multichainSubscriptionManager.subscribe({scope:e,origin:t,tabId:r});this.multichainMiddlewareManager.addMiddleware({scope:e,origin:t,tabId:r,middleware:n.middleware})}removeMultichainApiEthSubscriptionMiddleware({scope:e,origin:t}){this.multichainMiddlewareManager.removeMiddlewareByScopeAndOrigin(e,t),this.multichainSubscriptionManager.unsubscribeByScopeAndOrigin(e,t)}createPublicConfigStore(){const e=new c.ObservableStore,t=async({isUnlocked:e})=>{const{chainId:t,networkVersion:r,isConnected:n}=await this.getProviderNetworkState();return{isUnlocked:e,chainId:t,networkVersion:n?r:"loading"}},r=async r=>{var n;(null===(n=r.networksMetadata[r.selectedNetworkClientId])||void 0===n?void 0:n.status)===ie.NetworkStatus.Available&&e.putState(await t(r))};return this.on("update",r),r(this.getState()),e}async getProviderState(e){const t=await this.getProviderNetworkState(e),r={};if(ve.isManifestV3){var n;const{chrome:e}=globalThis;r.extensionId=null==e||null===(n=e.runtime)||void 0===n?void 0:n.id}return{isUnlocked:!0,accounts:this.getPermittedAccounts(e),...r,...t}}async getProviderNetworkState(e=x.METAMASK_DOMAIN){const t=this.controllerMessenger.call("SelectedNetworkController:getNetworkClientIdForDomain",e),r=this.controllerMessenger.call("NetworkController:getNetworkClientById",t),{chainId:n}=r.configuration,{completedOnboarding:s}=this.onboardingController.state;let a=this.deprecatedNetworkVersions[t];if(a===undefined&&s){try{const e=await r.provider.request({method:"net_version"});a=(0,ke.convertNetworkId)(e)}catch(e){console.error(e),a=null}this.deprecatedNetworkVersions[t]=a}const o=this.networkController.state.networksMetadata[t];return{chainId:n,networkVersion:a??"loading",isConnected:(null==o?void 0:o.status)===ie.NetworkStatus.Available}}getState(){const{vault:e}=this.keyringController.state,t=Boolean(e),r=this.memStore.getFlatState();return{isInitialized:t,...(0,Ut.sanitizeUIState)(r)}}getApi(){const{accountsController:e,addressBookController:t,alertController:r,appStateController:n,keyringController:s,nftController:a,nftDetectionController:o,currencyRateController:i,tokenBalancesController:c,tokenDetectionController:l,ensController:d,tokenListController:u,gasFeeController:h,metaMetricsController:p,networkController:m,multichainNetworkController:f,announcementController:g,onboardingController:b,permissionController:C,preferencesController:y,tokensController:w,smartTransactionsController:S,txController:v,backup:k,approvalController:T,phishingController:P,tokenRatesController:M,accountTrackerController:E,authenticationController:A,userStorageController:I,notificationServicesController:N,notificationServicesPushController:_,deFiPositionsController:O}=this;return{getState:this.getState.bind(this),setCurrentCurrency:i.setCurrentCurrency.bind(i),setUseBlockie:y.setUseBlockie.bind(y),setUsePhishDetect:y.setUsePhishDetect.bind(y),setUseMultiAccountBalanceChecker:y.setUseMultiAccountBalanceChecker.bind(y),setUseSafeChainsListValidation:y.setUseSafeChainsListValidation.bind(y),setUseTokenDetection:y.setUseTokenDetection.bind(y),setUseNftDetection:y.setUseNftDetection.bind(y),setUse4ByteResolution:y.setUse4ByteResolution.bind(y),setUseCurrencyRateCheck:y.setUseCurrencyRateCheck.bind(y),setOpenSeaEnabled:y.setOpenSeaEnabled.bind(y),getProviderConfig:()=>(0,Ee.getProviderConfig)({metamask:this.networkController.state}),grantPermissionsIncremental:this.permissionController.grantPermissionsIncremental.bind(this.permissionController),grantPermissions:this.permissionController.grantPermissions.bind(this.permissionController),setSecurityAlertsEnabled:y.setSecurityAlertsEnabled.bind(y),setAddSnapAccountEnabled:y.setAddSnapAccountEnabled.bind(y),setUseExternalNameSources:y.setUseExternalNameSources.bind(y),setUseTransactionSimulations:y.setUseTransactionSimulations.bind(y),setIpfsGateway:y.setIpfsGateway.bind(y),setIsIpfsGatewayEnabled:y.setIsIpfsGatewayEnabled.bind(y),setUseAddressBarEnsResolution:y.setUseAddressBarEnsResolution.bind(y),setParticipateInMetaMetrics:p.setParticipateInMetaMetrics.bind(p),setDataCollectionForMarketing:p.setDataCollectionForMarketing.bind(p),setMarketingCampaignCookieId:p.setMarketingCampaignCookieId.bind(p),setCurrentLocale:y.setCurrentLocale.bind(y),setServiceWorkerKeepAlivePreference:y.setServiceWorkerKeepAlivePreference.bind(y),markPasswordForgotten:this.markPasswordForgotten.bind(this),unMarkPasswordForgotten:this.unMarkPasswordForgotten.bind(this),getRequestAccountTabIds:this.getRequestAccountTabIds,getOpenMetamaskTabsIds:this.getOpenMetamaskTabsIds,markNotificationPopupAsAutomaticallyClosed:()=>this.notificationManager.markAsAutomaticallyClosed(),getCode:this.getCode.bind(this),addNewAccount:this.addNewAccount.bind(this),getSeedPhrase:this.getSeedPhrase.bind(this),resetAccount:this.resetAccount.bind(this),removeAccount:this.removeAccount.bind(this),importAccountWithStrategy:this.importAccountWithStrategy.bind(this),getNextAvailableAccountName:e.getNextAvailableAccountName.bind(e),getAccountsBySnapId:e=>(0,Mt.getAccountsBySnapId)(this.getSnapKeyring.bind(this),e),checkIsSeedlessPasswordOutdated:this.checkIsSeedlessPasswordOutdated.bind(this),syncPasswordAndUnlockWallet:this.syncPasswordAndUnlockWallet.bind(this),connectHardware:this.connectHardware.bind(this),forgetDevice:this.forgetDevice.bind(this),checkHardwareStatus:this.checkHardwareStatus.bind(this),unlockHardwareWalletAccount:this.unlockHardwareWalletAccount.bind(this),attemptLedgerTransportCreation:this.attemptLedgerTransportCreation.bind(this),submitQRHardwareCryptoHDKey:s.submitQRCryptoHDKey.bind(s),submitQRHardwareCryptoAccount:s.submitQRCryptoAccount.bind(s),cancelSyncQRHardware:s.cancelQRSynchronization.bind(s),submitQRHardwareSignature:s.submitQRSignature.bind(s),cancelQRHardwareSignRequest:s.cancelQRSignRequest.bind(s),submitPassword:this.submitPassword.bind(this),verifyPassword:this.verifyPassword.bind(this),setActiveNetwork:async e=>await this.multichainNetworkController.setActiveNetwork(e),getNetworksWithTransactionActivityByAccounts:this.multichainNetworkController.getNetworksWithTransactionActivityByAccounts.bind(this.multichainNetworkController),setActiveNetworkConfigurationId:e=>{this.networkController.setActiveNetwork(e)},setNetworkClientIdForDomain:(e,t)=>this.selectedNetworkController.setNetworkClientIdForDomain(e,t),rollbackToPreviousProvider:m.rollbackToPreviousProvider.bind(m),addNetwork:this.networkController.addNetwork.bind(this.networkController),updateNetwork:this.networkController.updateNetwork.bind(this.networkController),removeNetwork:this.multichainNetworkController.removeNetwork.bind(this.multichainNetworkController),getCurrentNetworkEIP1559Compatibility:this.networkController.getEIP1559Compatibility.bind(this.networkController),getNetworkConfigurationByNetworkClientId:this.networkController.getNetworkConfigurationByNetworkClientId.bind(this.networkController),setSelectedAddress:e=>{const t=this.accountsController.getAccountByAddress(e);if(!t)throw new Error(`No account found for address: ${e}`);this.accountsController.setSelectedAccount(t.id)},toggleExternalServices:this.toggleExternalServices.bind(this),addToken:w.addToken.bind(w),updateTokenType:w.updateTokenType.bind(w),setFeatureFlag:y.setFeatureFlag.bind(y),setPreference:y.setPreference.bind(y),addKnownMethodData:y.addKnownMethodData.bind(y),setDismissSeedBackUpReminder:y.setDismissSeedBackUpReminder.bind(y),setOverrideContentSecurityPolicyHeader:y.setOverrideContentSecurityPolicyHeader.bind(y),setAdvancedGasFee:y.setAdvancedGasFee.bind(y),setTheme:y.setTheme.bind(y),setSnapsAddSnapAccountModalDismissed:y.setSnapsAddSnapAccountModalDismissed.bind(y),setManageInstitutionalWallets:y.setManageInstitutionalWallets.bind(y),setSelectedInternalAccount:e=>{this.accountsController.getAccount(e)&&this.accountsController.setSelectedAccount(e)},setAccountName:e.setAccountName.bind(e),setAccountLabel:(e,t)=>{const r=this.accountsController.getAccountByAddress(e);if(r===undefined)throw new Error(`No account found for address: ${e}`);this.accountsController.setAccountName(r.id,t)},getTokenStandardAndDetails:this.getTokenStandardAndDetails.bind(this),getTokenSymbol:this.getTokenSymbol.bind(this),getTokenStandardAndDetailsByChain:this.getTokenStandardAndDetailsByChain.bind(this),addNft:a.addNft.bind(a),addNftVerifyOwnership:a.addNftVerifyOwnership.bind(a),removeAndIgnoreNft:a.removeAndIgnoreNft.bind(a),removeNft:a.removeNft.bind(a),checkAndUpdateAllNftsOwnershipStatus:a.checkAndUpdateAllNftsOwnershipStatus.bind(a),checkAndUpdateSingleNftOwnershipStatus:a.checkAndUpdateSingleNftOwnershipStatus.bind(a),getNFTContractInfo:a.getNFTContractInfo.bind(a),isNftOwner:a.isNftOwner.bind(a),updateIncomingTransactions:v.updateIncomingTransactions.bind(v),setAddressBook:t.set.bind(t),removeFromAddressBook:t.delete.bind(t),setLastActiveTime:n.setLastActiveTime.bind(n),setCurrentExtensionPopupId:n.setCurrentExtensionPopupId.bind(n),setDefaultHomeActiveTabName:n.setDefaultHomeActiveTabName.bind(n),setConnectedStatusPopoverHasBeenShown:n.setConnectedStatusPopoverHasBeenShown.bind(n),setRecoveryPhraseReminderHasBeenShown:n.setRecoveryPhraseReminderHasBeenShown.bind(n),setRecoveryPhraseReminderLastShown:n.setRecoveryPhraseReminderLastShown.bind(n),setTermsOfUseLastAgreed:n.setTermsOfUseLastAgreed.bind(n),setSurveyLinkLastClickedOrClosed:n.setSurveyLinkLastClickedOrClosed.bind(n),setOnboardingDate:n.setOnboardingDate.bind(n),setLastViewedUserSurvey:n.setLastViewedUserSurvey.bind(n),setRampCardClosed:n.setRampCardClosed.bind(n),setNewPrivacyPolicyToastClickedOrClosed:n.setNewPrivacyPolicyToastClickedOrClosed.bind(n),setNewPrivacyPolicyToastShownDate:n.setNewPrivacyPolicyToastShownDate.bind(n),setSnapsInstallPrivacyWarningShownStatus:n.setSnapsInstallPrivacyWarningShownStatus.bind(n),setOutdatedBrowserWarningLastShown:n.setOutdatedBrowserWarningLastShown.bind(n),setIsUpdateAvailable:n.setIsUpdateAvailable.bind(n),setUpdateModalLastDismissedAt:n.setUpdateModalLastDismissedAt.bind(n),setLastUpdatedAt:n.setLastUpdatedAt.bind(n),setShowTestnetMessageInDropdown:n.setShowTestnetMessageInDropdown.bind(n),setShowBetaHeader:n.setShowBetaHeader.bind(n),setShowPermissionsTour:n.setShowPermissionsTour.bind(n),setShowAccountBanner:n.setShowAccountBanner.bind(n),setShowNetworkBanner:n.setShowNetworkBanner.bind(n),updateNftDropDownState:n.updateNftDropDownState.bind(n),getLastInteractedConfirmationInfo:n.getLastInteractedConfirmationInfo.bind(n),setLastInteractedConfirmationInfo:n.setLastInteractedConfirmationInfo.bind(n),updateSlides:n.updateSlides.bind(n),removeSlide:n.removeSlide.bind(n),setEnableEnforcedSimulations:n.setEnableEnforcedSimulations.bind(n),setEnableEnforcedSimulationsForTransaction:n.setEnableEnforcedSimulationsForTransaction.bind(n),tryReverseResolveAddress:d.reverseResolveAddress.bind(d),startOAuthLogin:this.oauthService.startOAuthLogin.bind(this.oauthService),authenticate:this.seedlessOnboardingController.authenticate.bind(this.seedlessOnboardingController),resetOAuthLoginState:this.seedlessOnboardingController.clearState.bind(this.seedlessOnboardingController),createSeedPhraseBackup:this.createSeedPhraseBackup.bind(this),storeKeyringEncryptionKey:this.seedlessOnboardingController.storeKeyringEncryptionKey.bind(this.seedlessOnboardingController),restoreSocialBackupAndGetSeedPhrase:this.restoreSocialBackupAndGetSeedPhrase.bind(this),syncSeedPhrases:this.syncSeedPhrases.bind(this),socialSyncChangePassword:this.seedlessOnboardingController.changePassword.bind(this.seedlessOnboardingController),setLocked:this.setLocked.bind(this),createNewVaultAndKeychain:this.createNewVaultAndKeychain.bind(this),createNewVaultAndRestore:this.createNewVaultAndRestore.bind(this),generateNewMnemonicAndAddToVault:this.generateNewMnemonicAndAddToVault.bind(this),importMnemonicToVault:this.importMnemonicToVault.bind(this),exportAccount:this.exportAccount.bind(this),keyringChangePassword:this.keyringController.changePassword.bind(this.keyringController),exportEncryptionKey:this.keyringController.exportEncryptionKey.bind(this.keyringController),updateTransaction:v.updateTransaction.bind(v),approveTransactionsWithSameNonce:v.approveTransactionsWithSameNonce.bind(v),createCancelTransaction:this.createCancelTransaction.bind(this),createSpeedUpTransaction:this.createSpeedUpTransaction.bind(this),estimateGas:this.estimateGas.bind(this),estimateGasFee:v.estimateGasFee.bind(v),getNextNonce:this.getNextNonce.bind(this),addTransaction:(e,t)=>(0,At.addTransaction)(this.getAddTransactionRequest({transactionParams:e,transactionOptions:t,waitForSubmit:!1})),addTransactionAndWaitForPublish:(e,t)=>(0,At.addTransaction)(this.getAddTransactionRequest({transactionParams:e,transactionOptions:t,waitForSubmit:!0})),createTransactionEventFragment:$e.createTransactionEventFragmentWithTxId.bind(null,this.getTransactionMetricsRequest()),setTransactionActive:v.setTransactionActive.bind(v),decryptMessage:this.decryptMessageController.decryptMessage.bind(this.decryptMessageController),decryptMessageInline:this.decryptMessageController.decryptMessageInline.bind(this.decryptMessageController),cancelDecryptMessage:this.decryptMessageController.cancelDecryptMessage.bind(this.decryptMessageController),encryptionPublicKey:this.encryptionPublicKeyController.encryptionPublicKey.bind(this.encryptionPublicKeyController),cancelEncryptionPublicKey:this.encryptionPublicKeyController.cancelEncryptionPublicKey.bind(this.encryptionPublicKeyController),setSeedPhraseBackedUp:b.setSeedPhraseBackedUp.bind(b),completeOnboarding:b.completeOnboarding.bind(b),setFirstTimeFlowType:b.setFirstTimeFlowType.bind(b),setAlertEnabledness:r.setAlertEnabledness.bind(r),setUnconnectedAccountAlertShown:r.setUnconnectedAccountAlertShown.bind(r),setWeb3ShimUsageAlertDismissed:r.setWeb3ShimUsageAlertDismissed.bind(r),removePermissionsFor:this.removePermissionsFor,approvePermissionsRequest:this.acceptPermissionsRequest,rejectPermissionsRequest:this.rejectPermissionsRequest,...(0,wt.getPermissionBackgroundApiMethods)({permissionController:C,approvalController:T,accountsController:e,networkController:m,multichainNetworkController:f}),disableSnap:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:disable"),enableSnap:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:enable"),updateSnap:(e,t)=>(this.controllerMessenger.call("SnapController:install",e,t),null),removeSnap:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:remove"),handleSnapRequest:this.handleSnapRequest.bind(this),revokeDynamicSnapPermissions:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:revokeDynamicPermissions"),disconnectOriginFromSnap:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:disconnectOrigin"),updateNetworksList:this.updateNetworksList.bind(this),updateAccountsList:this.updateAccountsList.bind(this),setEnabledNetworks:this.setEnabledNetworks.bind(this),updateHiddenAccountsList:this.updateHiddenAccountsList.bind(this),getPhishingResult:async e=>(await P.maybeUpdateState(),P.test(e)),deleteInterface:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapInterfaceController:deleteInterface"),updateInterfaceState:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapInterfaceController:updateInterfaceState"),fetchAndSetQuotes:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:fetchAndSetQuotes"),setSelectedQuoteAggId:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSelectedQuoteAggId"),resetSwapsState:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:resetSwapsState"),setSwapsTokens:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsTokens"),clearSwapsQuotes:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:clearSwapsQuotes"),setApproveTxId:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setApproveTxId"),setTradeTxId:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setTradeTxId"),setSwapsTxGasPrice:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsTxGasPrice"),setSwapsTxGasLimit:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsTxGasLimit"),setSwapsTxMaxFeePerGas:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsTxMaxFeePerGas"),setSwapsTxMaxFeePriorityPerGas:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsTxMaxFeePriorityPerGas"),safeRefetchQuotes:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:safeRefetchQuotes"),stopPollingForQuotes:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:stopPollingForQuotes"),setBackgroundSwapRouteState:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setBackgroundSwapRouteState"),resetPostFetchState:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:resetPostFetchState"),setSwapsErrorKey:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsErrorKey"),setInitialGasEstimate:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setInitialGasEstimate"),setCustomApproveTxData:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setCustomApproveTxData"),setSwapsLiveness:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsLiveness"),setSwapsFeatureFlags:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsFeatureFlags"),setSwapsUserFeeLevel:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsUserFeeLevel"),setSwapsQuotesPollingLimitEnabled:this.controllerMessenger.call.bind(this.controllerMessenger,"SwapsController:setSwapsQuotesPollingLimitEnabled"),[W.BridgeBackgroundAction.RESET_STATE]:this.controllerMessenger.call.bind(this.controllerMessenger,`${W.BRIDGE_CONTROLLER_NAME}:${W.BridgeBackgroundAction.RESET_STATE}`),[W.BridgeUserAction.UPDATE_QUOTE_PARAMS]:this.controllerMessenger.call.bind(this.controllerMessenger,`${W.BRIDGE_CONTROLLER_NAME}:${W.BridgeUserAction.UPDATE_QUOTE_PARAMS}`),[W.BridgeBackgroundAction.TRACK_METAMETRICS_EVENT]:this.controllerMessenger.call.bind(this.controllerMessenger,`${W.BRIDGE_CONTROLLER_NAME}:${W.BridgeBackgroundAction.TRACK_METAMETRICS_EVENT}`),[re.BridgeStatusAction.SUBMIT_TX]:this.controllerMessenger.call.bind(this.controllerMessenger,`${re.BRIDGE_STATUS_CONTROLLER_NAME}:${re.BridgeStatusAction.SUBMIT_TX}`),fetchSmartTransactionFees:S.getFees.bind(S),clearSmartTransactionFees:S.clearFees.bind(S),submitSignedTransactions:S.submitSignedTransactions.bind(S),cancelSmartTransaction:S.cancelSmartTransaction.bind(S),fetchSmartTransactionsLiveness:S.fetchLiveness.bind(S),updateSmartTransaction:S.updateSmartTransaction.bind(S),setStatusRefreshInterval:S.setStatusRefreshInterval.bind(S),trackMetaMetricsEvent:p.trackEvent.bind(p),trackMetaMetricsPage:p.trackPage.bind(p),createEventFragment:p.createEventFragment.bind(p),updateEventFragment:p.updateEventFragment.bind(p),finalizeEventFragment:p.finalizeEventFragment.bind(p),trackInsightSnapView:this.trackInsightSnapView.bind(this),addEventBeforeMetricsOptIn:p.addEventBeforeMetricsOptIn.bind(p),bufferedTrace:p.bufferedTrace.bind(p),bufferedEndTrace:p.bufferedEndTrace.bind(p),rejectAllPendingApprovals:this.rejectAllPendingApprovals.bind(this),rejectPendingApproval:this.rejectPendingApproval,requestUserApproval:T.addAndShowApprovalRequest.bind(T),resolvePendingApproval:this.resolvePendingApproval,resetViewedNotifications:g.resetViewed.bind(g),updateViewedNotifications:g.updateViewed.bind(g),currencyRateStartPolling:i.startPolling.bind(i),currencyRateStopPollingByPollingToken:i.stopPollingByPollingToken.bind(i),tokenRatesStartPolling:M.startPolling.bind(M),tokenRatesStopPollingByPollingToken:M.stopPollingByPollingToken.bind(M),accountTrackerStartPolling:E.startPollingByNetworkClientId.bind(E),accountTrackerStopPollingByPollingToken:E.stopPollingByPollingToken.bind(E),tokenDetectionStartPolling:l.startPolling.bind(l),tokenDetectionStopPollingByPollingToken:l.stopPollingByPollingToken.bind(l),tokenListStartPolling:u.startPolling.bind(u),tokenListStopPollingByPollingToken:u.stopPollingByPollingToken.bind(u),tokenBalancesStartPolling:c.startPolling.bind(c),tokenBalancesStopPollingByPollingToken:c.stopPollingByPollingToken.bind(c),deFiStartPolling:O.startPolling.bind(O),deFiStopPolling:O.stopPollingByPollingToken.bind(O),gasFeeStartPolling:h.startPolling.bind(h),gasFeeStopPollingByPollingToken:h.stopPollingByPollingToken.bind(h),getGasFeeTimeEstimate:h.getTimeEstimate.bind(h),addPollingTokenToAppState:n.addPollingToken.bind(n),removePollingTokenFromAppState:n.removePollingToken.bind(n),updateThrottledOriginState:n.updateThrottledOriginState.bind(n),backupUserData:k.backupUserData.bind(k),restoreUserData:k.restoreUserData.bind(k),detectTokens:l.detectTokens.bind(l),fetchHistoricalPricesForAsset:(...e)=>this.multichainAssetsRatesController.fetchHistoricalPricesForAsset(...e),detectNfts:o.detectNfts.bind(o),addDetectedTokens:w.addDetectedTokens.bind(w),addImportedTokens:w.addTokens.bind(w),ignoreTokens:w.ignoreTokens.bind(w),getBalancesInSingleCall:(...e)=>this.assetsContractController.getBalancesInSingleCall(...e),performSignIn:A.performSignIn.bind(A),performSignOut:A.performSignOut.bind(A),getUserProfileMetaMetrics:A.getUserProfileMetaMetrics.bind(A),setIsBackupAndSyncFeatureEnabled:I.setIsBackupAndSyncFeatureEnabled.bind(I),syncInternalAccountsWithUserStorage:I.syncInternalAccountsWithUserStorage.bind(I),setHasAccountSyncingSyncedAtLeastOnce:I.setHasAccountSyncingSyncedAtLeastOnce.bind(I),setIsAccountSyncingReadyToBeDispatched:I.setIsAccountSyncingReadyToBeDispatched.bind(I),deleteAccountSyncingDataFromUserStorage:I.performDeleteStorageAllFeatureEntries.bind(I),syncContactsWithUserStorage:I.syncContactsWithUserStorage.bind(I),checkAccountsPresence:N.checkAccountsPresence.bind(N),createOnChainTriggers:N.createOnChainTriggers.bind(N),disableAccounts:N.disableAccounts.bind(N),enableAccounts:N.enableAccounts.bind(N),fetchAndUpdateMetamaskNotifications:N.fetchAndUpdateMetamaskNotifications.bind(N),deleteNotificationsById:N.deleteNotificationsById.bind(N),getNotificationsByType:N.getNotificationsByType.bind(N),markMetamaskNotificationsAsRead:N.markMetamaskNotificationsAsRead.bind(N),setFeatureAnnouncementsEnabled:N.setFeatureAnnouncementsEnabled.bind(N),enablePushNotifications:_.enablePushNotifications.bind(_),disablePushNotifications:_.disablePushNotifications.bind(_),enableMetamaskNotifications:N.enableMetamaskNotifications.bind(N),disableMetamaskNotifications:N.disableNotificationServices.bind(N),throwTestError:this.throwTestError.bind(this),updateProposedNames:this.nameController.updateProposedNames.bind(this.nameController),setName:this.nameController.setName.bind(this.nameController),createSnapAccount:async(e,t,r)=>{const n=await this.getSnapKeyring();return await n.createAccount(e,t,r)},multichainUpdateBalance:e=>this.multichainBalancesController.updateBalance(e),multichainUpdateTransactions:e=>this.multichainTransactionsController.updateTransactionsForAccount(e),decodeTransactionData:e=>(0,Dt.decodeTransactionData)({...e,provider:this.provider}),createMetaMetricsDataDeletionTask:this.metaMetricsDataDeletionController.createMetaMetricsDataDeletionTask.bind(this.metaMetricsDataDeletionController),updateDataDeletionTaskStatus:this.metaMetricsDataDeletionController.updateDataDeletionTaskStatus.bind(this.metaMetricsDataDeletionController),endTrace:Ae.endTrace,isRelaySupported:or.isRelaySupported,requestSafeReload:this.requestSafeReload.bind(this),applyTransactionContainersExisting:(e,t)=>(0,ur.applyTransactionContainersExisting)({containerTypes:t,messenger:this.controllerMessenger,transactionId:e,updateEditableParams:this.txController.updateEditableParams.bind(this.txController)})}}rejectOriginPendingApprovals(e){(0,Kt.rejectOriginApprovals)({approvalController:this.approvalController,deleteInterface:e=>this.controllerMessenger.call("SnapInterfaceController:deleteInterface",e),origin:e})}async exportAccount(e,t){return await this.verifyPassword(t),this.keyringController.exportAccount(t,e)}async getTokenStandardAndDetails(e,t,r){var n,s,a,o;const i=fr(wr,this,Pr).call(this),{tokensChainsCache:c}=this.tokenListController.state,l=(null==c||null===(n=c[i])||void 0===n?void 0:n.data)||{},{allTokens:d}=this.tokensController.state,u=(null==d||null===(s=d[i])||void 0===s?void 0:s[t])||[],h={...we.STATIC_MAINNET_TOKEN_LIST[null==e?void 0:e.toLowerCase()]||{},...l[null==e?void 0:e.toLowerCase()]||{},...u.find((({address:t})=>(0,Ce.isEqualCaseInsensitive)(t,e)))||{}},p=(0,Ce.isEqualCaseInsensitive)(h.standard,ae.TokenStandard.ERC20)||!0===h.erc20,m=!(r||(0,Ce.isEqualCaseInsensitive)(h.standard,ae.TokenStandard.ERC1155)||(0,Ce.isEqualCaseInsensitive)(h.standard,ae.TokenStandard.ERC721)||h.erc721),f=h.decimals!==undefined&&h.symbol;let g;if(p||m&&f)try{const r=t?await(0,be.fetchTokenBalance)(e,t,this.provider):undefined;g={address:e,balance:r,standard:ae.TokenStandard.ERC20,decimals:h.decimals,symbol:h.symbol}}catch(e){b.default.warn(`Failed to get token balance. Error: ${e}`)}if(g===undefined)try{g=await this.assetsContractController.getTokenStandardAndDetails(e,t,r)}catch(e){b.default.warn(`Failed to get token standard and details. Error: ${e}`)}if(g){if((0,Ce.isEqualCaseInsensitive)(g.standard,ae.TokenStandard.ERC1155))try{const n=await(0,be.fetchERC1155Balance)(e,t,r,this.provider),s=null!=n&&n._hex?parseInt(n._hex,16).toString():null;g={...g,balance:s}}catch(e){b.default.warn("Failed to get token balance. Error:",e)}}return{...g,decimals:null===(a=g)||void 0===a||null===(a=a.decimals)||void 0===a?void 0:a.toString(10),balance:null===(o=g)||void 0===o||null===(o=o.balance)||void 0===o?void 0:o.toString(10)}}async getTokenStandardAndDetailsByChain(e,t,r,n){var s,a,o,i;const{tokensChainsCache:c}=this.tokenListController.state,l=(null==c||null===(s=c[n])||void 0===s?void 0:s.data)||{},{allTokens:d}=this.tokensController.state,u=this.accountsController.getSelectedAccount(),h=(null==d||null===(a=d[n])||void 0===a?void 0:a[u.address])||[];let p={};n===ie.CHAIN_IDS.MAINNET&&(p=we.STATIC_MAINNET_TOKEN_LIST[null==e?void 0:e.toLowerCase()]||{});const m=l[null==e?void 0:e.toLowerCase()]||{},f=h.find((({address:t})=>(0,Ce.isEqualCaseInsensitive)(t,e)))||{},g={...p,...m,...f},C=(0,Ce.isEqualCaseInsensitive)(g.standard,ae.TokenStandard.ERC20)||!0===g.erc20,y=!(r||(0,Ce.isEqualCaseInsensitive)(g.standard,ae.TokenStandard.ERC1155)||(0,Ce.isEqualCaseInsensitive)(g.standard,ae.TokenStandard.ERC721)||g.erc721),w=g.decimals!==undefined&&g.symbol;let S;if(C||y&&w)try{let r=0;fr(wr,this,Pr).call(this)===n&&(r=await(0,be.fetchTokenBalance)(e,t,this.provider)),S={address:e,balance:r,standard:ae.TokenStandard.ERC20,decimals:g.decimals,symbol:g.symbol}}catch(e){b.default.warn(`Failed to get token balance. Error: ${e}`)}if(S===undefined)try{var v,k;const s=null===(v=this.networkController)||void 0===v||null===(v=v.state)||void 0===v||null===(v=v.networkConfigurationsByChainId)||void 0===v||null===(v=v[n])||void 0===v||null===(v=v.rpcEndpoints[null===(k=this.networkController)||void 0===k||null===(k=k.state)||void 0===k||null===(k=k.networkConfigurationsByChainId)||void 0===k||null===(k=k[n])||void 0===k?void 0:k.defaultRpcEndpointIndex])||void 0===v?void 0:v.networkClientId;S=await this.assetsContractController.getTokenStandardAndDetails(e,t,r,s)}catch(e){b.default.warn(`Failed to get token standard and details. Error: ${e}`)}if(S){if((0,Ce.isEqualCaseInsensitive)(S.standard,ae.TokenStandard.ERC1155))try{const n=await(0,be.fetchERC1155Balance)(e,t,r,this.provider),s=null!=n&&n._hex?parseInt(n._hex,16).toString():null;S={...S,balance:s}}catch(e){b.default.warn("Failed to get token balance. Error:",e)}}return{...S,decimals:null===(o=S)||void 0===o||null===(o=o.decimals)||void 0===o?void 0:o.toString(10),balance:null===(i=S)||void 0===i||null===(i=i.balance)||void 0===i?void 0:i.toString(10)}}async getTokenSymbol(e){try{const t=await this.assetsContractController.getTokenStandardAndDetails(e);return null==t?void 0:t.symbol}catch(e){return null}}async createSeedPhraseBackup(e,r,n){let s=!1;try{var a,o;null===(a=(o=this.metaMetricsController).bufferedTrace)||void 0===a||a.call(o,{name:Ae.TraceName.OnboardingCreateKeyAndBackupSrp,op:Ae.TraceOperation.OnboardingSecurityOp});const i=t.from(r),c=this._convertMnemonicToWordlistIndices(i);await this.seedlessOnboardingController.createToprfKeyAndBackupSeedPhrase(e,c,n),s=!0,await this.syncKeyringEncryptionKey()}catch(e){var i,c,l,d;const t=e instanceof Error?e.message:"Unknown error";throw null===(i=(c=this.metaMetricsController).bufferedTrace)||void 0===i||i.call(c,{name:Ae.TraceName.OnboardingCreateKeyAndBackupSrpError,op:Ae.TraceOperation.OnboardingError,tags:{errorMessage:t}}),null===(l=(d=this.metaMetricsController).bufferedEndTrace)||void 0===l||l.call(d,{name:Ae.TraceName.OnboardingCreateKeyAndBackupSrpError}),b.default.error("[createSeedPhraseBackup] error",e),e}finally{var u,h;null===(u=(h=this.metaMetricsController).bufferedEndTrace)||void 0===u||u.call(h,{name:Ae.TraceName.OnboardingCreateKeyAndBackupSrp,data:{success:s}})}}async fetchAllSecretData(e){let t=!1;try{var r,n;null===(r=(n=this.metaMetricsController).bufferedTrace)||void 0===r||r.call(n,{name:Ae.TraceName.OnboardingFetchSrps,op:Ae.TraceOperation.OnboardingSecurityOp});const s=await this.seedlessOnboardingController.fetchAllSecretData(e);return t=!0,s}catch(e){var s,a,o,i;const t=e instanceof Error?e.message:"Unknown error";throw null===(s=(a=this.metaMetricsController).bufferedTrace)||void 0===s||s.call(a,{name:Ae.TraceName.OnboardingFetchSrpsError,op:Ae.TraceOperation.OnboardingError,tags:{errorMessage:t}}),null===(o=(i=this.metaMetricsController).bufferedEndTrace)||void 0===o||o.call(i,{name:Ae.TraceName.OnboardingFetchSrpsError}),e}finally{var c,l;null===(c=(l=this.metaMetricsController).bufferedEndTrace)||void 0===c||c.call(l,{name:Ae.TraceName.OnboardingFetchSrps,data:{success:t}})}}async syncPasswordAndUnlockWallet(e){const t=this.onboardingController.getIsSocialLoginFlow(),r=!!t&&await this.seedlessOnboardingController.checkIsPasswordOutdated({skipCache:!1});if(!t||!r)return void await this.submitPassword(e);const n=await this.syncSeedlessGlobalPasswordMutex.acquire();try{throw await this.keyringController.verifyPassword(e),new Error(se.SeedlessOnboardingControllerErrorMessage.OutdatedPassword)}catch(t){if(t.message===se.SeedlessOnboardingControllerErrorMessage.OutdatedPassword)throw t;await this.seedlessOnboardingController.submitGlobalPassword({globalPassword:e});const r=await this.seedlessOnboardingController.loadKeyringEncryptionKey();await this.submitEncryptionKey(r);let n=!1;try{var s,a;await this.seedlessOnboardingController.syncLatestGlobalPassword({globalPassword:e}),null===(s=(a=this.metaMetricsController).bufferedTrace)||void 0===s||s.call(a,{name:Ae.TraceName.OnboardingResetPassword,op:Ae.TraceOperation.OnboardingSecurityOp}),await this.keyringController.changePassword(e),n=!0,await this.syncKeyringEncryptionKey(),await this.seedlessOnboardingController.checkIsPasswordOutdated({skipCache:!0})}catch(e){var o,i,c,l;const t=e instanceof Error?e.message:"Unknown error";throw null===(o=(i=this.metaMetricsController).bufferedTrace)||void 0===o||o.call(i,{name:Ae.TraceName.OnboardingResetPasswordError,op:Ae.TraceOperation.OnboardingError,tags:{errorMessage:t}}),null===(c=(l=this.metaMetricsController).bufferedEndTrace)||void 0===c||c.call(l,{name:Ae.TraceName.OnboardingResetPasswordError}),await this.setLocked(),e}finally{var d,u;null===(d=(u=this.metaMetricsController).bufferedEndTrace)||void 0===d||d.call(u,{name:Ae.TraceName.OnboardingResetPassword,data:{success:n}})}}finally{n()}}async syncKeyringEncryptionKey(){const e=await this.keyringController.exportEncryptionKey();await this.seedlessOnboardingController.storeKeyringEncryptionKey(e)}async checkIsSeedlessPasswordOutdated(e=!1){const t=this.onboardingController.getIsSocialLoginFlow(),{completedOnboarding:r}=this.onboardingController.state;if(!t||!r)return!1;return await this.seedlessOnboardingController.checkIsPasswordOutdated({skipCache:e})}async syncSeedPhrases(){if(!this.onboardingController.getIsSocialLoginFlow())throw new Error("Syncing seed phrases is only available for social login flow");const[e,...r]=await this.fetchAllSecretData();if(!e)throw new Error("No root SRP found");for(const e of r){if(!this.seedlessOnboardingController.getSecretDataBackupState(e.data,e.type)){if(e.type===se.SecretType.PrivateKey){await this.importAccountWithStrategy("privateKey",[(0,Q.bytesToHex)(e.data)],{shouldCreateSocialBackup:!1,shouldSelectAccount:!1});continue}const r=this._convertEnglishWordlistIndicesToCodepoints(e.data),n=t.from(r).toString("utf8");await this.importMnemonicToVault(n,{shouldCreateSocialBackup:!1,shouldSelectAccount:!1,shouldImportSolanaAccount:!0})}}}async addNewSeedPhraseBackup(e,r,n=!0){const s=t.from(e,"utf8"),a=this._convertMnemonicToWordlistIndices(s);if(n){let e=!1;try{var o,i;null===(o=(i=this.metaMetricsController).bufferedTrace)||void 0===o||o.call(i,{name:Ae.TraceName.OnboardingAddSrp,op:Ae.TraceOperation.OnboardingSecurityOp}),await this.seedlessOnboardingController.addNewSecretData(a,se.SecretType.Mnemonic,{keyringId:r}),e=!0}catch(e){var c,l,d,u;const t=e instanceof Error?e.message:"Unknown error";throw null===(c=(l=this.metaMetricsController).bufferedTrace)||void 0===c||c.call(l,{name:Ae.TraceName.OnboardingAddSrpError,op:Ae.TraceOperation.OnboardingError,tags:{errorMessage:t}}),null===(d=(u=this.metaMetricsController).bufferedEndTrace)||void 0===d||d.call(u,{name:Ae.TraceName.OnboardingAddSrpError}),e}finally{var h,p;null===(h=(p=this.metaMetricsController).bufferedEndTrace)||void 0===h||h.call(p,{name:Ae.TraceName.OnboardingAddSrp,data:{success:e}})}}else this.seedlessOnboardingController.updateBackupMetadataState({keyringId:r,data:a,type:se.SecretType.Mnemonic})}async createNewVaultAndKeychain(e){const t=await this.createVaultMutex.acquire();try{return await this.keyringController.createNewVaultAndKeychain(e),this.keyringController.state.keyrings[0]}finally{t()}}async importMnemonicToVault(e,r={shouldCreateSocialBackup:!0,shouldSelectAccount:!0,shouldImportSolanaAccount:!0}){const{shouldCreateSocialBackup:n,shouldSelectAccount:s,shouldImportSolanaAccount:a}=r,o=await this.createVaultMutex.acquire();try{if(this.keyringController.getKeyringsByType(h.KeyringTypes.hd).some((r=>t.from(this._convertEnglishWordlistIndicesToCodepoints(r.mnemonic)).toString("utf8")===e)))throw new Error("This Secret Recovery Phrase has already been imported.");const{id:r}=await this.keyringController.addNewKeyring(h.KeyringTypes.hd,{mnemonic:e,numberOfAccounts:1}),[o]=await this.keyringController.withKeyring({id:r},(async({keyring:e})=>e.getAccounts()));if(this.onboardingController.getIsSocialLoginFlow())try{await this.addNewSeedPhraseBackup(e,r,n)}catch(e){throw await this.keyringController.removeAccount(o),e}if(s){const e=this.accountsController.getAccountByAddress(o);this.accountsController.setSelectedAccount(e.id)}return{newAccountAddress:o,discoveredAccounts:await this._addAccountsWithBalance(r,a)}}finally{o()}}async restoreSeedPhrasesToVault(e){if(!this.onboardingController.getIsSocialLoginFlow())return;const r=!1,n=!1;for(const s of e){if(this.seedlessOnboardingController.getSecretDataBackupState(s.data,s.type))continue;if(s.type===se.SecretType.PrivateKey){await this.importAccountWithStrategy("privateKey",[(0,Q.bytesToHex)(s.data)],{shouldCreateSocialBackup:r,shouldSelectAccount:n});continue}const e=this._convertEnglishWordlistIndicesToCodepoints(s.data),a=t.from(e).toString("utf8");await this.importMnemonicToVault(a,{shouldCreateSocialBackup:r,shouldSelectAccount:n,shouldImportSolanaAccount:false})}}async restoreSocialBackupAndGetSeedPhrase(e){try{const[r,...n]=await this.fetchAllSecretData(e),s=this._convertEnglishWordlistIndicesToCodepoints(r.data),a=t.from(s).toString("utf8"),o=Array.from(t.from(a,"utf8").values());return await this.createNewVaultAndRestore(e,o),n.length>0&&await this.restoreSeedPhrasesToVault(n),a}catch(e){if(b.default.error("Error restoring social backup and getting seed phrase",e),e instanceof se.RecoveryError)throw new f.JsonRpcError(-32603,e.message,e.data);throw e}}async generateNewMnemonicAndAddToVault(){const e=await this.createVaultMutex.acquire();try{const{id:e}=await this.keyringController.addNewKeyring(h.KeyringTypes.hd),[t]=await this.keyringController.withKeyring({id:e},(async({keyring:e})=>e.getAccounts())),r=this.accountsController.getAccountByAddress(t);return this.accountsController.setSelectedAccount(r.id),t}finally{e()}}async createNewVaultAndRestore(e,r){const n=await this.createVaultMutex.acquire();try{const{completedOnboarding:n}=this.onboardingController.state,s=t.from(r);this.permissionController.clearState(),await this.snapController.clearState(),this.accountOrderController.updateHiddenAccountsList([]),this.accountTrackerController.clearAccounts(),this.txController.clearUnapprovedTransactions(),n&&this.tokenDetectionController.enable();const a=this._convertMnemonicToWordlistIndices(s);if(await this.keyringController.createNewVaultAndRestore(e,a),n&&(await this._addAccountsWithBalance(),fr(wr,this,vr).call(this,{name:ce.HardwareDeviceNames.ledger},(async e=>this.setLedgerTransportPreference(e)))),(0,De.getIsSeedlessOnboardingFeatureEnabled)()){if(this.onboardingController.getIsSocialLoginFlow()){const e=this.keyringController.state.keyrings[0].metadata.id;this.seedlessOnboardingController.updateBackupMetadataState({keyringId:e,data:a,type:se.SecretType.Mnemonic}),await this.syncKeyringEncryptionKey()}}}finally{n()}}async _getMultichainWalletSnapClient(e){const t=await this.getSnapKeyring(),r=this.controllerMessenger;return new Re.MultichainWalletSnapClient(e,t,r)}async _addAccountsWithBalance(e,t=!0){try{await this.userStorageController.setHasAccountSyncingSyncedAtLeastOnce(!1),await this.userStorageController.setIsAccountSyncingReadyToBeDispatched(!1);const s=fr(wr,this,Pr).call(this),a=e?{id:e}:{type:h.KeyringTypes.hd},{accounts:o,entropySource:i}=await this.keyringController.withKeyring(a,(async({keyring:e,metadata:t})=>({accounts:await e.getAccounts(),entropySource:t.id})));let c=o[o.length-1];for(let e=o.length;;e++){if("0x0"===await this.getBalance(c,this.provider)){var r,n;await this.tokenDetectionController.detectTokens({chainIds:[s],selectedAddress:c});const t=null===(r=this.tokensController.state.allTokens)||void 0===r||null===(r=r[s])||void 0===r?void 0:r[c],a=null===(n=this.tokensController.state.allDetectedTokens)||void 0===n||null===(n=n[s])||void 0===n?void 0:n[c];if(0===((null==t?void 0:t.length)??0)&&0===((null==a?void 0:a.length)??0)){1!==e&&await this.removeAccount(c);break}}c=await this.keyringController.withKeyring(a,(async({keyring:e})=>{const[t]=await e.addAccounts(1);return t}))}const l={bitcoin:0,solana:0};if(t){const e=await this._getMultichainWalletSnapClient(xe.SOLANA_WALLET_SNAP_ID),t=Y.SolScope.Mainnet,r=await e.discoverAccounts(i,t);l.solana=r.length,0===r.length&&await this._addSnapAccount(i,e,{scope:t})}return l}catch(e){return b.default.warn(`Failed to add accounts with balance. Error: ${e}`),{bitcoin:0,solana:0}}finally{await this.userStorageController.setHasAccountSyncingSyncedAtLeastOnce(!0),await this.userStorageController.setIsAccountSyncingReadyToBeDispatched(!0)}}async _importAccountsWithBalances(){const{keyrings:e}=this.keyringController.state;for(const{metadata:t}of e){await this.keyringController.withKeyring({id:t.id},(async({keyring:e})=>e.type===h.KeyringTypes.hd))&&await this._addAccountsWithBalance(t.id,true)}}async _addSnapAccount(e,t,r={}){let n=e;try{if(!n){n=await this.keyringController.withKeyring({type:h.KeyringTypes.hd},(async({metadata:e})=>e.id))}return await t.createAccount({...r,entropySource:n},{displayConfirmation:!1,displayAccountNameSuggestion:!1,setSelectedAccount:!1})}catch(e){return b.default.warn(`Failed to add Snap account. Error: ${e}`),(0,T.captureException)(e),null}}_convertMnemonicToWordlistIndices(e){const t=e.toString().split(" ").map((e=>q.wordlist.indexOf(e)));return new Uint8Array(new Uint16Array(t).buffer)}_convertEnglishWordlistIndicesToCodepoints(e){return t.from(Array.from(new Uint16Array(e.buffer)).map((e=>q.wordlist[e])).join(" "))}async getBalance(e,t){const r=this.accountTrackerController.state.accountsByChainId[fr(wr,this,Pr).call(this)],n=null==r?void 0:r[e];if(n&&n.balance)return n.balance;try{return await t.request({method:"eth_getBalance",params:[e,"latest"]})||"0x0"}catch(e){throw b.default.error(e),e}}async submitPassword(e){await this.submitPasswordOrEncryptionKey({password:e})}async submitEncryptionKey(e){await this.submitPasswordOrEncryptionKey({encryptionKey:e})}async submitPasswordOrEncryptionKey({password:e,encryptionKey:t}){const{completedOnboarding:r}=this.onboardingController.state,n=this.onboardingController.getIsSocialLoginFlow();await this.offscreenPromise,t?await this.keyringController.submitEncryptionKey(t):(await this.keyringController.submitPassword(e),n&&await this.seedlessOnboardingController.submitPassword(e));try{await this.blockTracker.checkForLatestBlock()}catch(e){b.default.error("Error while unlocking extension.",e)}await this.accountsController.updateAccounts(),this.accountWalletController.init(),r&&fr(wr,this,vr).call(this,{name:ce.HardwareDeviceNames.ledger},(async e=>this.setLedgerTransportPreference(e)))}async _loginUser(e){try{await this.submitPassword(e),await this.accountTrackerController.updateAccountsAllActiveNetworks()}finally{this._startUISync()}}_startUISync(){this.emit("startUISync"),this.startUISync=!0,this.memStore.subscribe(this.sendUpdate.bind(this))}async submitEncryptionKeyFromSessionStorage(){try{const{loginToken:e,loginSalt:t}=await this.extension.storage.session.get(["loginToken","loginSalt"]);if(e&&t){const{vault:r}=this.keyringController.state;if(JSON.parse(r).salt!==t)return console.warn("submitEncryptionKey: Stored salt and vault salt do not match"),void await this.clearLoginArtifacts();await this.keyringController.submitEncryptionKey(e,t)}}catch(e){throw await this.clearLoginArtifacts(),e}}async clearLoginArtifacts(){await this.extension.storage.session.remove(["loginToken","loginSalt"])}async verifyPassword(e){await this.keyringController.verifyPassword(e)}getPrimaryKeyringMnemonic(){const[e]=this.keyringController.getKeyringsByType(le.KeyringType.hdKeyTree);if(!e.mnemonic)throw new Error("Primary keyring mnemonic unavailable.");return e.mnemonic}getPrimaryKeyringMnemonicSeed(){const[e]=this.keyringController.getKeyringsByType(le.KeyringType.hdKeyTree);if(!e.seed)throw new Error("Primary keyring mnemonic unavailable.");return e.seed}async attemptLedgerTransportCreation(){return await fr(wr,this,vr).call(this,{name:ce.HardwareDeviceNames.ledger},(async e=>e.attemptMakeApp()))}async connectHardware(e,t,r){return fr(wr,this,vr).call(this,{name:e,hdPath:r},(async r=>{e===ce.HardwareDeviceNames.ledger&&await this.setLedgerTransportPreference(r);let n=[];switch(t){case-1:n=await r.getPreviousPage();break;case 1:n=await r.getNextPage();break;default:n=await r.getFirstPage()}const s=await this.keyringController.getAccounts(),a=[...new Set(s.concat(n.map((e=>e.address.toLowerCase()))))];return this.accountTrackerController.syncWithAddresses(a),n}))}async checkHardwareStatus(e,t){return fr(wr,this,vr).call(this,{name:e,hdPath:t},(async e=>e.isUnlocked()))}async getHardwareTypeForMetric(e){return await this.keyringController.withKeyring({address:e},(({keyring:e})=>ce.HardwareKeyringType[e.type]))}async forgetDevice(e){return fr(wr,this,vr).call(this,{name:e},(async e=>{for(const t of e.accounts)this._onAccountRemoved(t);return e.forgetDevice(),!0}))}async getAccountType(e){switch(await this.keyringController.getAccountKeyringType(e)){case le.KeyringType.trezor:case le.KeyringType.oneKey:case le.KeyringType.lattice:case le.KeyringType.qr:case le.KeyringType.ledger:return"hardware";case le.KeyringType.imported:return"imported";case le.KeyringType.snap:return"snap";default:return"MetaMask"}}async getDeviceModel(e){return this.keyringController.withKeyring({address:e},(async({keyring:e})=>{switch(e.type){case le.KeyringType.trezor:case le.KeyringType.oneKey:return e.getModel();case le.KeyringType.qr:return e.getName();case le.KeyringType.ledger:return ce.HardwareDeviceNames.ledger;case le.KeyringType.lattice:return ce.HardwareDeviceNames.lattice;default:return undefined}}))}getAccountLabel(e,t,r){return`${e[0].toUpperCase()}${e.slice(1)} ${parseInt(t,10)+1} ${r||""}`.trim()}async unlockHardwareWalletAccount(e,t,r,n){const{address:s}=await fr(wr,this,vr).call(this,{name:t,hdPath:r},(async r=>{r.setAccountToUnlock(e);const[s]=await r.addAccounts(1);return{address:(0,X.normalize)(s),label:this.getAccountLabel(t===ce.HardwareDeviceNames.qr?r.getName():t,e,n)}}));this.preferencesController.setSelectedAddress(s);const a=this.accountsController.listAccounts(),{identities:o}=this.preferencesController.state;return{unlockedAccount:s,identities:o,accounts:a}}async addNewAccount(e,t){const r=await this.keyringController.getAccounts(),n=t?{id:t}:{type:h.KeyringTypes.hd},s=await this.keyringController.withKeyring(n,(async({keyring:t})=>{if(t.type!==h.KeyringTypes.hd)throw new Error("Cannot add account to non-HD keyring");const n=await t.getAccounts();if(e&&e!==n.length){if(e>n.length)throw new Error("Account out of sequence");const t=n[e];if(!t)throw new Error(`Can't find account at index ${e}`);return t}const[s]=await t.addAccounts(1);if(r.includes(s))throw await t.removeAccount(s),new Error(`Cannot add duplicate ${s} account`);return s}));return r.includes(s)||this.preferencesController.setSelectedAddress(s),s}async getSeedPhrase(e,t){return this._convertEnglishWordlistIndicesToCodepoints(await this.keyringController.exportSeedPhrase(e,t))}async resetAccount(){const e=this.accountsController.getSelectedAccount().address,t=fr(wr,this,Pr).call(this);return this.txController.wipeTransactions({address:e,chainId:t}),this.smartTransactionsController.wipeSmartTransactions({address:e,ignoreNetwork:!1}),this.bridgeStatusController.wipeBridgeStatus({address:e,ignoreNetwork:!1}),this.networkController.resetConnection(),e}captureKeyringTypesWithMissingIdentities(e=[],t=[]){const r=t.filter((t=>!e.some((e=>e.address.toLowerCase()===t.toLowerCase())))).map((e=>this.keyringController.getAccountKeyringType(e))),n=e.length,s=this.accountTrackerController.state.accountsByChainId[fr(wr,this,Pr).call(this)],a=Object.keys(s||{}).length;(0,T.captureException)(new Error(`Attempt to get permission specifications failed because their were ${t.length} accounts, but ${n} identities, and the ${r} keyrings included accounts with missing identities. Meanwhile, there are ${a} accounts in the account tracker.`))}sortEvmAccountsByLastSelected(e){const t=this.accountsController.listAccounts();return this.sortAddressesWithInternalAccounts(e,t)}sortMultichainAccountsByLastSelected(e){const t=this.accountsController.listMultichainAccounts();return this.sortAddressesWithInternalAccounts(e,t)}sortAddressesWithInternalAccounts(e,t){return e.sort(((r,n)=>{const s=t.find((e=>e.address.toLowerCase()===r.toLowerCase())),a=t.find((e=>e.address.toLowerCase()===n.toLowerCase()));if(!s)throw this.captureKeyringTypesWithMissingIdentities(t,e),new Error(`Missing identity for address: "${r}".`);if(!a)throw this.captureKeyringTypesWithMissingIdentities(t,e),new Error(`Missing identity for address: "${n}".`);return s.metadata.lastSelected===a.metadata.lastSelected?0:s.metadata.lastSelected===undefined?1:a.metadata.lastSelected===undefined?-1:a.metadata.lastSelected-s.metadata.lastSelected}))}getPermittedAccounts(e,{ignoreLock:t}={}){let r;try{r=this.permissionController.getCaveat(e,te.Caip25EndowmentPermissionName,te.Caip25CaveatType)}catch(e){if(e instanceof R.PermissionDoesNotExistError)return[];throw e}if(!this.isUnlocked()&&!t)return[];const n=(0,te.getEthAccounts)(r.value);return this.sortEvmAccountsByLastSelected(n)}removeAllScopePermissions(e){this.permissionController.updatePermissionsByCaveat(te.Caip25CaveatType,(t=>te.Caip25CaveatMutators[te.Caip25CaveatType].removeScope(t,e)))}removeAllAccountPermissions(e){this.permissionController.updatePermissionsByCaveat(te.Caip25CaveatType,(t=>te.Caip25CaveatMutators[te.Caip25CaveatType].removeAccount(t,e)))}async removeAccount(e){return this._onAccountRemoved(e),await this.keyringController.removeAccount(e),e}async importAccountWithStrategy(e,t,r={shouldCreateSocialBackup:!0,shouldSelectAccount:!0}){const{shouldCreateSocialBackup:n,shouldSelectAccount:s}=r,a=await this.keyringController.importAccountWithStrategy(e,t);if(this.onboardingController.getIsSocialLoginFlow()){const{id:e,privateKey:t}=await this.keyringController.withKeyring({address:a},(async({keyring:e,metadata:t})=>{const r=await e.exportAccount(a);return{id:t.id,privateKey:r}}));try{await this.addNewPrivateKeyBackup(t,e,n)}catch(e){throw await this.keyringController.removeAccount(a),e}}s&&this.preferencesController.setSelectedAddress(a)}async addNewPrivateKeyBackup(e,t,r=!0){const n=(0,Q.hexToBytes)((0,Q.add0x)(e));r?await this.seedlessOnboardingController.addNewSecretData(n,se.SecretType.PrivateKey,{keyringId:t}):this.seedlessOnboardingController.updateBackupMetadataState({keyringId:t,data:n,type:se.SecretType.PrivateKey})}async requestPermissionApproval(e,t,r={}){const n=(0,k.nanoid)();return this.approvalController.addAndShowApprovalRequest({id:n,origin:e,requestData:{metadata:{id:n,origin:e},permissions:t,...r},type:R.MethodNames.RequestPermissions})}async requestApprovalPermittedChainsPermission(e,t){const r=(0,te.setPermittedEthChainIds)({requiredScopes:{},optionalScopes:{},sessionProperties:{},isMultichainOrigin:!1},[t]);await this.permissionController.requestPermissionsIncremental({origin:e},{[te.Caip25EndowmentPermissionName]:{caveats:[{type:te.Caip25CaveatType,value:r}]}})}async requestPermittedChainsPermissionIncremental({origin:e,chainId:t,autoApprove:r,metadata:n}){const s=(0,te.setPermittedEthChainIds)({requiredScopes:{},optionalScopes:{},sessionProperties:{},isMultichainOrigin:!1},[t]);if(!r){let t;return n&&(t={metadata:n}),void await this.permissionController.requestPermissionsIncremental({origin:e},{[te.Caip25EndowmentPermissionName]:{caveats:[{type:te.Caip25CaveatType,value:s}]}},t)}await this.permissionController.grantPermissionsIncremental({subject:{origin:e},approvedPermissions:{[te.Caip25EndowmentPermissionName]:{caveats:[{type:te.Caip25CaveatType,value:s}]}}})}getCaip25PermissionFromLegacyPermissions(e,t={}){var r,n;const s=(0,u.pick)(t,[de.RestrictedMethods.eth_accounts,wt.PermissionNames.permittedChains]);s[de.RestrictedMethods.eth_accounts]||(s[de.RestrictedMethods.eth_accounts]={}),s[wt.PermissionNames.permittedChains]||(s[wt.PermissionNames.permittedChains]={});const a=(null===(r=s[de.RestrictedMethods.eth_accounts])||void 0===r||null===(r=r.caveats)||void 0===r||null===(r=r.find((e=>e.type===de.CaveatTypes.restrictReturnedAccounts)))||void 0===r?void 0:r.value)??[],o=(null===(n=s[wt.PermissionNames.permittedChains])||void 0===n||null===(n=n.caveats)||void 0===n||null===(n=n.find((e=>e.type===de.CaveatTypes.restrictNetworkSwitching)))||void 0===n?void 0:n.value)??[],i=(0,te.setPermittedEthChainIds)({requiredScopes:{},optionalScopes:{"wallet:eip155":{accounts:[]}},sessionProperties:{},isMultichainOrigin:!1},o),c=(0,te.setEthAccounts)(i,a);return{[te.Caip25EndowmentPermissionName]:{caveats:[{type:te.Caip25CaveatType,value:c}]}}}getNonEvmSupportedMethods(e){return this.controllerMessenger.call("MultichainRouter:getSupportedMethods",e)}notifySolanaAccountChangedForCurrentAccount(e){let t;try{t=this.permissionController.getCaveat(e,te.Caip25EndowmentPermissionName,te.Caip25CaveatType)}catch{}if(!t)return;const r=t.value.sessionProperties[te.KnownSessionProperties.SolanaAccountChangedNotifications],n=(0,te.getSessionScopes)(t.value,{getNonEvmSupportedMethods:this.getNonEvmSupportedMethods.bind(this)}),s=n[_e.MultichainNetworks.SOLANA]||n[_e.MultichainNetworks.SOLANA_DEVNET]||n[_e.MultichainNetworks.SOLANA_TESTNET];if(r&&s){const{accounts:t}=s,r=t.map((e=>{const{address:t}=(0,Q.parseCaipAccountId)(e);return t})),[n]=this.sortMultichainAccountsByLastSelected(r);n&&this._notifySolanaAccountChange(e,[n])}}getAddTransactionRequest({transactionParams:e,transactionOptions:t,dappRequest:r,...n}){var s;const a=(null==r?void 0:r.networkClientId)??(null==t?void 0:t.networkClientId),{chainId:o}=this.networkController.getNetworkConfigurationByNetworkClientId(a);return{internalAccounts:this.accountsController.listAccounts(),dappRequest:r,networkClientId:a,selectedAccount:this.accountsController.getAccountByAddress(e.from),transactionController:this.txController,transactionOptions:t,transactionParams:e,userOperationController:this.userOperationController,chainId:o,ppomController:this.ppomController,securityAlertsEnabled:null===(s=this.preferencesController.state)||void 0===s?void 0:s.securityAlertsEnabled,updateSecurityAlertResponse:this.updateSecurityAlertResponse.bind(this),...n}}async getCurrentAccountEIP1559Compatibility(){return!0}async createCancelTransaction(e,t,r){await this.txController.stopTransaction(e,t,r);return this.getState()}async createSpeedUpTransaction(e,t,r){await this.txController.speedUpTransaction(e,t,r);return this.getState()}async estimateGas(e){return new Promise(((t,r)=>{this.provider.request({method:"eth_estimateGas",params:[e]}).then((e=>t(e.toString(16)))).catch((e=>r(e)))}))}async updateSecurityAlertResponse(e,t,r){return await(0,xt.updateSecurityAlertResponse)({appStateController:this.appStateController,messenger:this.controllerMessenger,method:e,securityAlertId:t,securityAlertResponse:r,signatureController:this.signatureController,transactionController:this.txController})}getHDEntropyIndex(){const e=this.accountsController.getSelectedAccount(),t=this.keyringController.state.keyrings.filter((e=>e.type===h.KeyringTypes.hd)).findIndex((t=>t.accounts.includes(e.address)));return-1===t?undefined:t}markPasswordForgotten(){this.preferencesController.setPasswordForgotten(!0),this.sendUpdate()}unMarkPasswordForgotten(){this.preferencesController.setPasswordForgotten(!1),this.sendUpdate()}setupUntrustedCommunicationEip1193({connectionStream:e,sender:t,subjectType:r}){if(t.url&&this.onboardingController.state.completedOnboarding&&this.preferencesController.state.usePhishDetect){const{hostname:r}=new URL(t.url);this.phishingController.maybeUpdateState();const n=this.phishingController.test(t.url);if(null!=n&&n.result)return this.sendPhishingWarning(e,r),void this.metaMetricsController.trackEvent({event:me.MetaMetricsEventName.PhishingPageDisplayed,category:me.MetaMetricsEventCategory.Phishing,properties:{url:r}})}let n;n=r||(t.id&&t.id!==this.extension.runtime.id?R.SubjectType.Extension:R.SubjectType.Website);const s=(0,st.setupMultiplex)(e);s.ignoreStream(Ot.METAMASK_CAIP_MULTICHAIN_PROVIDER),this.setupProviderConnectionEip1193(s.createStream(Ot.METAMASK_EIP_1193_PROVIDER),t,n),t.url&&this.setupPublicConfig(s.createStream("publicConfig"))}setupUntrustedCommunicationCaip({connectionStream:e,sender:t,subjectType:r}){let n;n=r||(t.id&&t.id!==this.extension.runtime.id?R.SubjectType.Extension:R.SubjectType.Website),this.setupProviderConnectionCaip(e,t,n)}setupTrustedCommunication(e,t){const r=(0,st.setupMultiplex)(e);this.setupControllerConnection(r.createStream("controller")),this.setupProviderConnectionEip1193(r.createStream("provider"),t,R.SubjectType.Internal)}setupPhishingCommunication({connectionStream:e}){const{usePhishDetect:t}=this.preferencesController.state;if(!t)return;const r=(0,st.setupMultiplex)(e).createStream("metamask-phishing-safelist");r.on("data",(0,mt.default)({safelistPhishingDomain:this.safelistPhishingDomain.bind(this),backToSafetyPhishingWarning:this.backToSafetyPhishingWarning.bind(this)},r))}setUpCookieHandlerCommunication({connectionStream:e}){const{metaMetricsId:t,dataCollectionForMarketing:r,participateInMetaMetrics:n}=this.metaMetricsController.state;if(t&&r&&n){const t=(0,st.setupMultiplex)(e).createStream(Ot.METAMASK_COOKIE_HANDLER);t.on("data",(0,mt.default)({getCookieFromMarketingPage:this.getCookieFromMarketingPage.bind(this)},t))}}getCookieFromMarketingPage(e){const{ga_client_id:t}=e;this.metaMetricsController.setMarketingCampaignCookieId(t)}sendPhishingWarning(e,t){(0,st.setupMultiplex)(e).createStream("phishing").write({hostname:t})}setupControllerConnection(e){const t=new Lt.PatchStore(this.memStore);let r=!1;const n=()=>{if(!(0,st.isStreamWritable)(e)||!r)return;const n=t.flushPendingPatches();e.write({jsonrpc:"2.0",method:"sendUpdate",params:[n]})},a={...this.getApi(),...this.controllerApi,startPatches:()=>{r=!0,n()},getStatePatches:()=>t.flushPendingPatches()};this.on("update",n),this.activeControllerConnections+=1,this.emit("controllerConnectionChanged",this.activeControllerConnections),e.on("data",(0,mt.default)(a,e));const o=()=>{(0,st.isStreamWritable)(e)&&e.write({jsonrpc:"2.0",method:"startUISync"})};this.startUISync?o():this.once("startUISync",o);const i=()=>{e.mmFinished||(this.activeControllerConnections-=1,this.emit("controllerConnectionChanged",this.activeControllerConnections),e.mmFinished=!0,this.removeListener("update",n),t.destroy())};e.mmFinished=!1,(0,s.finished)(e,i),e.once("close",i),e.once("end",i)}setupProviderConnectionEip1193(e,t,r){let n,a;n=r===R.SubjectType.Internal?pe.ORIGIN_METAMASK:r===R.SubjectType.Snap?t.snapId:new URL(t.url).origin,t.id&&t.id!==this.extension.runtime.id&&this.subjectMetadataController.addSubjectMetadata({origin:n,extensionId:t.id,subjectType:R.SubjectType.Extension}),t.tab&&t.tab.id&&(a=t.tab.id);let o=n;t.tab&&t.tab.url&&(o=new URL(t.tab.url).origin);const c=this.setupProviderEngineEip1193({origin:n,sender:t,subjectType:r,tabId:a,mainFrameOrigin:o}),l=(0,Je.default)(),d=(0,i.createEngineStream)({engine:c}),u=this.addConnection(n,{tabId:a,apiType:gr,engine:c});(0,s.pipeline)(e,l,d,e,(e=>{var t;c.destroy(),u&&this.removeConnection(n,u),!e||null!==(t=e.message)&&void 0!==t&&t.match("Premature close")||b.default.error(e)})),r!==R.SubjectType.Internal&&this._notifyChainChangeForConnection({engine:c},n)}setupProviderConnectionCaip(e,t,r){let n,a;n=r===R.SubjectType.Internal?pe.ORIGIN_METAMASK:r===R.SubjectType.Snap?t.snapId:new URL(t.url).origin,t.id&&t.id!==this.extension.runtime.id&&this.subjectMetadataController.addSubjectMetadata({origin:n,extensionId:t.id,subjectType:R.SubjectType.Extension}),t.tab&&t.tab.id&&(a=t.tab.id);const o=this.setupProviderEngineCaip({origin:n,sender:t,subjectType:r,tabId:a}),c=(0,Je.default)(),l=(0,i.createEngineStream)({engine:o}),d=this.addConnection(n,{tabId:a,apiType:br,engine:o});setTimeout((()=>this.notifySolanaAccountChangedForCurrentAccount(n)),500),(0,s.pipeline)(e,c,l,e,(e=>{var t;o.destroy(),d&&this.removeConnection(n,d),!e||null!==(t=e.message)&&void 0!==t&&t.match("Premature close")||b.default.error(e)}))}setupCommonMiddlewareHooks(e){return{addSubjectMetadata:this.subjectMetadataController.addSubjectMetadata.bind(this.subjectMetadataController),getProviderState:this.getProviderState.bind(this),handleWatchAssetRequest:this.handleWatchAssetRequest.bind(this),requestUserApproval:this.approvalController.addAndShowApprovalRequest.bind(this.approvalController),getCaveat:({target:t,caveatType:r})=>{try{return this.permissionController.getCaveat(e,t,r)}catch(e){if(!(e instanceof R.PermissionDoesNotExistError))throw e}return undefined},requestPermittedChainsPermissionIncrementalForOrigin:t=>this.requestPermittedChainsPermissionIncremental({...t,origin:e}),addNetwork:this.networkController.addNetwork.bind(this.networkController),updateNetwork:this.networkController.updateNetwork.bind(this.networkController),setActiveNetwork:async t=>{await this.networkController.setActiveNetwork(t),this.permissionController.hasPermission(e,te.Caip25EndowmentPermissionName)&&this.selectedNetworkController.setNetworkClientIdForDomain(e,t)},getNetworkConfigurationByChainId:this.networkController.getNetworkConfigurationByChainId.bind(this.networkController),setTokenNetworkFilter:e=>{const{tokenNetworkFilter:t}=this.preferencesController.getPreferences();e&&1===Object.keys(t).length&&this.preferencesController.setPreference("tokenNetworkFilter",{[e]:!0})},setEnabledNetworks:(e,t)=>{this.networkOrderController.setEnabledNetworks(e,t)},getCurrentChainIdForDomain:e=>{const t=this.selectedNetworkController.getNetworkClientIdForDomain(e),{chainId:r}=this.networkController.getNetworkConfigurationByNetworkClientId(t);return r},getWeb3ShimUsageState:this.alertController.getWeb3ShimUsageState.bind(this.alertController),setWeb3ShimUsageRecorded:this.alertController.setWeb3ShimUsageRecorded.bind(this.alertController),rejectApprovalRequestsForOrigin:()=>this.rejectOriginPendingApprovals(e)}}setupProviderEngineEip1193({origin:e,subjectType:t,sender:r,tabId:n,mainFrameOrigin:s}){const a=new o.JsonRpcEngine;a.push((0,Xe.default)({origin:e})),s&&a.push((0,Ze.default)({mainFrameOrigin:s})),a.push((0,x.createSelectedNetworkMiddleware)(this.controllerMessenger));const i=this.selectedNetworkController.getProviderAndBlockTracker(e),c=(0,p.default)(i),l=(0,m.default)(i);return l.events.on("notification",(e=>a.emit("notification",e))),n&&a.push((0,et.default)({tabId:n})),a.push((0,Ye.default)({origin:e})),a.push(this.permissionLogController.createMiddleware()),e===Pe.BaseUrl.Portfolio&&a.push((0,Rt.createTxVerificationMiddleware)(this.networkController)),a.push((0,Ft.default)()),a.push((0,$t.default)({getThrottledOriginState:this.appStateController.getThrottledOriginState.bind(this.appStateController),updateThrottledOriginState:this.appStateController.updateThrottledOriginState.bind(this.appStateController)})),a.push((0,He.createPPOMMiddleware)(this.ppomController,this.preferencesController,this.networkController,this.appStateController,this.accountsController,this.updateSecurityAlertResponse.bind(this))),a.push((0,Ve.createTrustSignalsMiddleware)(this.networkController,this.appStateController,this.phishingController,this.preferencesController)),a.push((0,kt.default)({getAccountType:this.getAccountType.bind(this),getDeviceModel:this.getDeviceModel.bind(this),getHDEntropyIndex:this.getHDEntropyIndex.bind(this),getHardwareTypeForMetric:this.getHardwareTypeForMetric.bind(this),snapAndHardwareMessenger:this.controllerMessenger.getRestricted({name:"SnapAndHardwareMessenger",allowedActions:["KeyringController:getKeyringForAccount","SnapController:get","AccountsController:getSelectedAccount"]}),appStateController:this.appStateController,metaMetricsController:this.metaMetricsController})),a.push((0,Qe.createUnsupportedMethodMiddleware)()),t===R.SubjectType.Snap&&(0,Fe.isSnapPreinstalled)(e)&&a.push((0,F.createPreinstalledSnapsMiddleware)({getPermissions:this.permissionController.getPermissions.bind(this.permissionController,e),getAllEvmAccounts:()=>this.controllerMessenger.call("AccountsController:listAccounts").map((e=>e.address)),grantPermissions:t=>this.controllerMessenger.call("PermissionController:grantPermissions",{approvedPermissions:t,subject:{origin:e}})})),a.push((0,Qe.createEthAccountsMethodMiddleware)({getAccounts:this.getPermittedAccounts.bind(this,e)})),t!==R.SubjectType.Internal&&a.push(this.permissionController.createPermissionMiddleware({origin:e})),t===R.SubjectType.Website&&a.push((0,nt.default)({location:r.url,registerOnboarding:this.onboardingController.registerOnboarding})),a.push((0,jt.default)({messenger:this.controllerMessenger.getRestricted({name:"EvmMethodsToNonEvmAccountFilterMessenger",allowedActions:["AccountsController:getSelectedAccount"]})})),a.push((0,Qe.createEip1193MethodMiddleware)({subjectType:t,...this.setupCommonMiddlewareHooks(e),metamaskState:this.getState(),getUnlockPromise:this.appStateController.getUnlockPromise.bind(this.appStateController),sendMetrics:this.metaMetricsController.trackEvent.bind(this.metaMetricsController),getAccounts:this.getPermittedAccounts.bind(this,e),getCaip25PermissionFromLegacyPermissionsForOrigin:this.getCaip25PermissionFromLegacyPermissions.bind(this,e),getPermissionsForOrigin:this.permissionController.getPermissions.bind(this.permissionController,e),requestPermissionsForOrigin:t=>this.permissionController.requestPermissions({origin:e},t,{metadata:{isEip1193Request:!0}}),revokePermissionsForOrigin:t=>{try{this.permissionController.revokePermissions({[e]:t})}catch(e){console.log(e)}},updateCaveat:this.permissionController.updateCaveat.bind(this.permissionController,e),hasApprovalRequestsForOrigin:()=>this.approvalController.has({origin:e})})),a.push((0,F.createSnapsMethodMiddleware)(t===R.SubjectType.Snap,{clearSnapState:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:clearSnapState",e),getUnlockPromise:this.appStateController.getUnlockPromise.bind(this.appStateController),getSnaps:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:getPermitted",e),requestPermissions:async t=>await this.permissionController.requestPermissions({origin:e},t),getPermissions:this.permissionController.getPermissions.bind(this.permissionController,e),getSnapFile:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:getFile",e),getSnapState:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:getSnapState",e),updateSnapState:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:updateSnapState",e),installSnaps:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:install",e),invokeSnap:this.permissionController.executeRestrictedMethod.bind(this.permissionController,e,de.RestrictedMethods.wallet_snap),getIsLocked:()=>!this.appStateController.isUnlocked(),getIsActive:()=>this._isClientOpen,getInterfaceState:(...t)=>this.controllerMessenger.call("SnapInterfaceController:getInterface",e,...t).state,getInterfaceContext:(...t)=>this.controllerMessenger.call("SnapInterfaceController:getInterface",e,...t).context,createInterface:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapInterfaceController:createInterface",e),updateInterface:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapInterfaceController:updateInterface",e),resolveInterface:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapInterfaceController:resolveInterface",e),getSnap:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:get"),trackError:e=>(0,T.captureException)(e),trackEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController),getAllSnaps:this.controllerMessenger.call.bind(this.controllerMessenger,"SnapController:getAll"),openWebSocket:this.controllerMessenger.call.bind(this.controllerMessenger,"WebSocketService:open",e),closeWebSocket:this.controllerMessenger.call.bind(this.controllerMessenger,"WebSocketService:close",e),getWebSockets:this.controllerMessenger.call.bind(this.controllerMessenger,"WebSocketService:getAll",e),sendWebSocketMessage:this.controllerMessenger.call.bind(this.controllerMessenger,"WebSocketService:sendMessage",e),getCurrencyRate:e=>{const t=this.multichainRatesController.state.rates[e],{fiatCurrency:r}=this.multichainRatesController.state;return t?{...t,currency:r}:undefined},getEntropySources:()=>this.controllerMessenger.call("KeyringController:getState").keyrings.map(((e,t)=>e.type===h.KeyringTypes.hd?{id:e.metadata.id,name:e.metadata.name,type:"mnemonic",primary:0===t}:null)).filter(Boolean),hasPermission:this.permissionController.hasPermission.bind(this.permissionController,e),scheduleBackgroundEvent:t=>this.controllerMessenger.call("CronjobController:schedule",{...t,snapId:e}),cancelBackgroundEvent:this.controllerMessenger.call.bind(this.controllerMessenger,"CronjobController:cancel",e),getBackgroundEvents:this.controllerMessenger.call.bind(this.controllerMessenger,"CronjobController:get",e),getNetworkConfigurationByChainId:this.controllerMessenger.call.bind(this.controllerMessenger,"NetworkController:getNetworkConfigurationByChainId"),getNetworkClientById:this.controllerMessenger.call.bind(this.controllerMessenger,"NetworkController:getNetworkClientById"),startTrace:Ae.trace,endTrace:Ae.endTrace,handleSnapRpcRequest:t=>this.handleSnapRequest({...t,origin:e}),getAllowedKeyringMethods:(0,Le.keyringSnapPermissionsBuilder)(this.subjectMetadataController,e)})),a.push(c),a.push(l.middleware),a.push(this.metamaskMiddleware),a.push((0,d.providerAsMiddleware)(i.provider)),a}setupProviderEngineCaip({origin:e,sender:t,subjectType:r,tabId:n}){const s=new o.JsonRpcEngine;s.push((0,Xe.default)({origin:e})),n&&s.push((0,et.default)({tabId:n})),s.push((0,Ye.default)({origin:e})),s.push(((e,t,r,n)=>[pe.MESSAGE_TYPE.WALLET_CREATE_SESSION,pe.MESSAGE_TYPE.WALLET_INVOKE_METHOD,pe.MESSAGE_TYPE.WALLET_GET_SESSION,pe.MESSAGE_TYPE.WALLET_REVOKE_SESSION].includes(e.method)?r():n(f.rpcErrors.methodNotFound({data:{method:e.method}})))),s.push((0,kt.default)({getAccountType:this.getAccountType.bind(this),getDeviceModel:this.getDeviceModel.bind(this),getHDEntropyIndex:this.getHDEntropyIndex.bind(this),getHardwareTypeForMetric:this.getHardwareTypeForMetric.bind(this),snapAndHardwareMessenger:this.controllerMessenger.getRestricted({name:"SnapAndHardwareMessenger",allowedActions:["KeyringController:getKeyringForAccount","SnapController:get","AccountsController:getSelectedAccount"]}),appStateController:this.appStateController,metaMetricsController:this.metaMetricsController})),s.push(ee.multichainMethodCallValidatorMiddleware);const a=(0,Qe.makeMethodMiddlewareMaker)([ee.walletRevokeSession,ee.walletGetSession,ee.walletInvokeMethod,ee.walletCreateSession]);s.push(a({findNetworkClientIdByChainId:this.networkController.findNetworkClientIdByChainId.bind(this.networkController),listAccounts:this.accountsController.listAccounts.bind(this.accountsController),requestPermissionsForOrigin:(t,r={})=>this.permissionController.requestPermissions({origin:e},t,r),getCaveatForOrigin:this.permissionController.getCaveat.bind(this.permissionController,e),getSelectedNetworkClientId:()=>this.networkController.state.selectedNetworkClientId,revokePermissionForOrigin:this.permissionController.revokePermission.bind(this.permissionController,e),getNonEvmSupportedMethods:this.getNonEvmSupportedMethods.bind(this),isNonEvmScopeSupported:this.controllerMessenger.call.bind(this.controllerMessenger,"MultichainRouter:isSupportedScope"),handleNonEvmRequestForOrigin:t=>this.controllerMessenger.call("MultichainRouter:handleRequest",{...t,origin:e}),getNonEvmAccountAddresses:this.controllerMessenger.call.bind(this.controllerMessenger,"MultichainRouter:getSupportedAccounts"),trackSessionCreatedEvent:e=>this.metaMetricsController.trackEvent({event:me.MetaMetricsEventName.PermissionsRequested,properties:{api_source:me.MetaMetricsRequestedThrough.MultichainApi,method:pe.MESSAGE_TYPE.WALLET_CREATE_SESSION,chain_id_list:(0,te.getAllScopesFromCaip25CaveatValue)(e)}})})),s.push((0,Qe.createUnsupportedMethodMiddleware)(new Set([...ie.UNSUPPORTED_RPC_METHODS,"eth_requestAccounts","eth_accounts"]))),r===R.SubjectType.Website&&s.push((0,nt.default)({location:t.url,registerOnboarding:this.onboardingController.registerOnboarding})),s.push((0,Qe.createMultichainMethodMiddleware)({subjectType:r,...this.setupCommonMiddlewareHooks(e)})),s.push(this.metamaskMiddleware);try{const t=this.permissionController.getCaveat(e,te.Caip25EndowmentPermissionName,te.Caip25CaveatType),r=(0,te.getSessionScopes)(t.value,{getNonEvmSupportedMethods:this.getNonEvmSupportedMethods.bind(this)});Object.entries(r).forEach((([t,r])=>{r.notifications.includes("eth_subscription")&&r.methods.includes("eth_subscribe")&&this.addMultichainApiEthSubscriptionMiddleware({scope:t,origin:e,tabId:n})}))}catch(e){}return this.multichainSubscriptionManager.on("notification",((t,r,a)=>{e===t&&n===r&&s.emit("notification",a)})),s.push(this.multichainMiddlewareManager.generateMultichainMiddlewareForOriginAndTabId(e,n)),s.push((async(e,t,r,n)=>{const{provider:s}=this.networkController.getNetworkClientById(e.networkClientId);return t.result=await s.request(e),n()})),s}setupPublicConfig(e){const t=(0,l.storeAsStream)(this.publicConfigStore);(0,s.pipeline)(t,e,(e=>{var r;t.destroy(),!e||null!==(r=e.message)&&void 0!==r&&r.match("Premature close")||b.default.error(e)}))}addConnection(e,{tabId:t,apiType:r,engine:n}){if(e===pe.ORIGIN_METAMASK)return null;this.connections[e]||(this.connections[e]={});const s=(0,k.nanoid)();return this.connections[e][s]={tabId:t,apiType:r,engine:n},s}removeConnection(e,t){const r=this.connections[e];r&&(delete r[t],0===Object.keys(r).length&&delete this.connections[e])}removeAllConnections(e){const t=this.connections[e];t&&Object.keys(t).forEach((t=>{this.removeConnection(e,t)}))}notifyConnections(e,t,r){const n=this.connections[e];n&&Object.values(n).forEach((e=>{r&&e.apiType!==r||e.engine&&e.engine.emit("notification",t)}))}notifyAllConnections(e,t){const r="function"==typeof e?t=>e(t):()=>e;Object.keys(this.connections).forEach((e=>{Object.values(this.connections[e]).forEach((async n=>{if(!t||n.apiType===t)try{this.notifyConnection(n,await r(e))}catch(e){console.error(e)}}))}))}notifyConnection(e,t){try{e.engine&&e.engine.emit("notification",t)}catch(e){console.error(e)}}async _onKeyringControllerUpdate(e){const{keyrings:t}=e,r=t.reduce(((e,{accounts:t})=>e.concat(t)),[]).filter(Bt.isEthAddress);r.length&&this.accountTrackerController.syncWithAddresses(r)}_onUnlock(){this.unMarkPasswordForgotten(),this.emit("unlock")}_onLock(){this.emit("lock")}_onStateUpdate(e){this.isClientOpenAndUnlocked=e.isUnlocked&&this._isClientOpen,this._notifyChainChange()}_onAccountRemoved(e){this.removeAllAccountPermissions(e)}privateSendUpdate(){this.emit("update",this.getState())}isUnlocked(){return this.keyringController.state.isUnlocked}getExternalPendingTransactions(e){return this.smartTransactionsController.getTransactions({addressFrom:e,status:"pending"})}async initializeChainlist(){const e=`cachedFetch:${ie.CHAIN_SPEC_URL}`,{cachedResponse:t}=await(0,ge.getStorageItem)(e)||{};t||await(0,ge.setStorageItem)(e,{cachedResponse:(0,S.rawChainData)(),cachedTime:0}),await(0,ft.initializeRpcProviderDomains)()}async getPendingNonce(e,t){const{nonceDetails:r,releaseLock:n}=await this.txController.getNonceLock(e,t),s=r.params.highestSuggested;return n(),s}async getNextNonce(e,t){const r=await this.txController.getNonceLock(e,t);return r.releaseLock(),r.nextNonce}throwTestError(e){setTimeout((()=>{const t=new Error(e);throw t.name="TestError",t}))}getTransactionMetricsRequest(){return{...{createEventFragment:this.metaMetricsController.createEventFragment.bind(this.metaMetricsController),finalizeEventFragment:this.metaMetricsController.finalizeEventFragment.bind(this.metaMetricsController),getEventFragmentById:this.metaMetricsController.getEventFragmentById.bind(this.metaMetricsController),getParticipateInMetrics:()=>this.metaMetricsController.state.participateInMetaMetrics,trackEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController),updateEventFragment:this.metaMetricsController.updateEventFragment.bind(this.metaMetricsController),getAccountBalance:(e,t)=>{var r;return null===(r=this.accountTrackerController.state.accountsByChainId)||void 0===r||null===(r=r[t])||void 0===r||null===(r=r[e])||void 0===r?void 0:r.balance},getAccountType:this.getAccountType.bind(this),getDeviceModel:this.getDeviceModel.bind(this),getHardwareTypeForMetric:this.getHardwareTypeForMetric.bind(this),getEIP1559GasFeeEstimates:this.gasFeeController.fetchGasFeeEstimates.bind(this.gasFeeController),getSelectedAddress:()=>this.accountsController.getSelectedAccount().address,getTokenStandardAndDetails:this.getTokenStandardAndDetails.bind(this),getTransaction:e=>this.txController.state.transactions.find((t=>t.id===e)),getIsSmartTransaction:e=>(0,Te.getIsSmartTransaction)(this._getMetaMaskState(),e),getSmartTransactionByMinedTxHash:e=>this.smartTransactionsController.getSmartTransactionByMinedTxHash(e),getMethodData:e=>{if(!e)return null;const{knownMethodData:t,use4ByteResolution:r}=this.preferencesController.state,n=(0,ft.addHexPrefix)(e);return(0,ft.getMethodDataName)(t,r,n,this.preferencesController.addKnownMethodData.bind(this.preferencesController),this.provider)},getIsConfirmationAdvancedDetailsOpen:()=>this.preferencesController.state.preferences.showConfirmationAdvancedDetails,getHDEntropyIndex:this.getHDEntropyIndex.bind(this),getNetworkRpcUrl:e=>{try{var t;const n=this.networkController.findNetworkClientIdByChainId(e),s=this.networkController.getNetworkConfigurationByNetworkClientId(n);if(s.rpcUrl)return s.rpcUrl;if((null===(t=s.rpcEndpoints)||void 0===t?void 0:t.length)>0){var r;const e=s.defaultRpcEndpointIndex||0;return(null===(r=s.rpcEndpoints[e])||void 0===r?void 0:r.url)||s.rpcEndpoints[0].url}return"unknown"}catch(e){return console.error("Error getting RPC URL:",e),"unknown"}}},snapAndHardwareMessenger:this.controllerMessenger.getRestricted({name:"SnapAndHardwareMessenger",allowedActions:["KeyringController:getKeyringForAccount","SnapController:get","AccountsController:getSelectedAccount"]}),provider:this.provider}}updateAccountBalanceForTransactionNetwork(e){const{networkClientId:t,txParams:{from:r}}=e;this.accountTrackerController.updateAccountByAddress({address:r,networkClientId:t})}toggleExternalServices(e){this.preferencesController.toggleExternalServices(e),this.tokenListController.updatePreventPollingOnNetworkRestart(!e),e?(this.tokenDetectionController.enable(),this.gasFeeController.enableNonRPCGasFeeApis()):(this.tokenDetectionController.disable(),this.gasFeeController.disableNonRPCGasFeeApis())}async setLedgerTransportPreference(e){const t=window.navigator.hid?ce.LedgerTransportTypes.webhid:ce.LedgerTransportTypes.u2f;return null!=e&&e.updateTransportMethod?e.updateTransportMethod(t).catch((e=>{throw e})):undefined}recordFirstTimeInfo(e){if(!("firstTimeInfo"in e)){const t="12.23.0";e.firstTimeInfo={version:t,date:Date.now()}}}set isClientOpen(e){this._isClientOpen=e}onClientClosed(){try{this.gasFeeController.stopAllPolling(),this.currencyRateController.stopAllPolling(),this.tokenRatesController.stopAllPolling(),this.tokenDetectionController.stopAllPolling(),this.tokenListController.stopAllPolling(),this.tokenBalancesController.stopAllPolling(),this.appStateController.clearPollingTokens(),this.accountTrackerController.stopAllPolling(),this.deFiPositionsController.stopAllPolling()}catch(e){console.error(e)}}onEnvironmentTypeClosed(e){const t=pe.POLLING_TOKEN_ENVIRONMENT_TYPES[e];this.appStateController.state[t].forEach((e=>{this.gasFeeController.stopPollingByPollingToken(e),this.currencyRateController.stopPollingByPollingToken(e),this.tokenRatesController.stopPollingByPollingToken(e),this.tokenDetectionController.stopPollingByPollingToken(e),this.tokenListController.stopPollingByPollingToken(e),this.tokenBalancesController.stopPollingByPollingToken(e),this.accountTrackerController.stopPollingByPollingToken(e),this.appStateController.removePollingToken(e,t)}))}safelistPhishingDomain(e){return(0,ft.getPlatform)()===pe.PLATFORM_FIREFOX||this.metaMetricsController.trackEvent({category:me.MetaMetricsEventCategory.Phishing,event:me.MetaMetricsEventName.ProceedAnywayClicked,properties:{url:e,referrer:{url:e}}},{excludeMetaMetricsId:!0}),this.phishingController.bypass(e)}async backToSafetyPhishingWarning(){this.metaMetricsController.trackEvent({category:me.MetaMetricsEventCategory.Navigation,event:me.MetaMetricsEventName.PortfolioLinkClicked,properties:{location:"phishing_page",text:"Back to safety"}}),await this.platform.switchToAnotherURL(undefined,"https://portfolio.metamask.io/?metamaskEntry=phishing_page_portfolio_button")}setLocked(){return this.keyringController.setLocked()}rejectAllPendingApprovals(){(0,Kt.rejectAllApprovals)({approvalController:this.approvalController,deleteInterface:e=>this.controllerMessenger.call("SnapInterfaceController:deleteInterface",e)})}async getCode(e,t){const{provider:r}=this.networkController.getNetworkClientById(t);return await r.request({method:"eth_getCode",params:[e]})}async _onAccountChange(e){const t=(0,wt.getPermittedAccountsByOrigin)(this.permissionController.state);for(const[r,n]of t.entries())n.includes(e)&&this._notifyAccountsChange(r,n)}_notifyAccountsChange(e,t){this.notifyConnections(e,{method:wt.NOTIFICATION_NAMES.accountsChanged,params:t.length<2?t:this.getPermittedAccounts(e)},gr),this.permissionLogController.updateAccountsHistory(e,t)}async _notifyAuthorizationChange(e,t){this.notifyConnections(e,{method:ee.MultichainApiNotifications.sessionChanged,params:{sessionScopes:(0,te.getSessionScopes)(t,{getNonEvmSupportedMethods:this.getNonEvmSupportedMethods.bind(this)})}},br)}async _notifySolanaAccountChange(e,t){this.notifyConnections(e,{method:ee.MultichainApiNotifications.walletNotify,params:{scope:_e.MultichainNetworks.SOLANA,notification:{method:wt.NOTIFICATION_NAMES.accountsChanged,params:t}}},br)}async _notifyChainChange(){this.notifyAllConnections((async e=>({method:wt.NOTIFICATION_NAMES.chainChanged,params:await this.getProviderNetworkState(e)})),gr)}async _notifyChainChangeForConnection(e,t){this.notifyConnection(e,{method:wt.NOTIFICATION_NAMES.chainChanged,params:await this.getProviderNetworkState(t)})}async _onFinishedTransaction(e){if(![G.TransactionStatus.confirmed,G.TransactionStatus.failed].includes(e.status))return;const t=performance.now(),r=(0,Ae.trace)({name:Ae.TraceName.OnFinishedTransaction,startTime:performance.timeOrigin});(0,Ae.trace)({name:Ae.TraceName.OnFinishedTransaction,startTime:performance.timeOrigin,parentContext:r,data:{transactionMeta:e}}),await this._createTransactionNotifcation(e),await this._updateNFTOwnership(e),this._trackTransactionFailure(e),await this.tokenBalancesController.updateBalancesByChainId({chainId:e.chainId}),(0,Ae.endTrace)({name:Ae.TraceName.OnFinishedTransaction,timestamp:performance.timeOrigin+t})}async _createTransactionNotifcation(e){const{chainId:t}=e;let r={};if(t){var n,s;const e=null===(n=this.networkController.state.networkConfigurationsByChainId)||void 0===n?void 0:n[t];r={blockExplorerUrl:null==e||null===(s=e.blockExplorerUrls)||void 0===s?void 0:s[null==e?void 0:e.defaultBlockExplorerUrlIndex]}}try{await this.platform.showTransactionNotification(e,r)}catch(e){b.default.error("Failed to create transaction notification",e)}}async _updateNFTOwnership(e){var t,r;const{type:n,txParams:s,chainId:a,txReceipt:o}=e,i=this.accountsController.getSelectedAccount().address,{allNfts:c}=this.nftController.state,l=null==o?void 0:o.logs,d=n===G.TransactionType.contractInteraction&&l,u=(n===G.TransactionType.tokenMethodTransferFrom||n===G.TransactionType.tokenMethodSafeTransferFrom)&&s!==undefined;if(!d&&!u)return;const h=null===(t=this.networkController)||void 0===t||null===(t=t.state)||void 0===t||null===(t=t.networkConfigurationsByChainId)||void 0===t||null===(t=t[a])||void 0===t||null===(t=t.rpcEndpoints[null===(r=this.networkController)||void 0===r||null===(r=r.state)||void 0===r||null===(r=r.networkConfigurationsByChainId)||void 0===r||null===(r=r[a])||void 0===r?void 0:r.defaultRpcEndpointIndex])||void 0===t?void 0:t.networkClientId;if(u){var p;const{data:e,to:t,from:r}=s,n=(0,ye.parseStandardTokenTransactionData)(e),o=(0,be.getTokenIdParam)(n)??(0,Se.getTokenValueParam)(n),i=null==c||null===(p=c[r])||void 0===p||null===(p=p[a])||void 0===p?void 0:p.find((({address:e,tokenId:r})=>(0,Ce.isEqualCaseInsensitive)(e,t)&&r===o));i&&this.nftController.checkAndUpdateSingleNftOwnershipStatus(i,!1,h,{userAddress:r})}else{const e=l.map((e=>{const t=e.topics&&e.topics[0]===Me.TRANSFER_SINFLE_LOG_TOPIC_HASH,r=e.topics&&e.topics[0]===Me.TOKEN_TRANSFER_LOG_TOPIC_HASH;let n;return t&&(n=e.topics&&e.topics[3]&&e.topics[3].match(null==i?void 0:i.slice(2))),r&&(n=e.topics&&e.topics[2]&&e.topics[2].match(null==i?void 0:i.slice(2))),{isERC1155NftTransfer:t,isERC721NftTransfer:r,isTransferToSelectedAddress:n,...e}}));if(0!==e.length){const t=[];e.forEach((e=>{if(e.isTransferToSelectedAddress&&(e.isERC1155NftTransfer||e.isERC721NftTransfer)){let r;r=e.isERC1155NftTransfer?new z.Interface(J.abiERC1155):new z.Interface(J.abiERC721);try{const n=r.parseLog({data:e.data,topics:e.topics});t.push({contract:e.address,...n})}catch(e){}}}));const r=[],n=[];t.forEach((e=>{var t;const s=(0,be.getTokenIdParam)(e),o=null==c||null===(t=c[i])||void 0===t||null===(t=t[a])||void 0===t?void 0:t.find((({address:t,tokenId:r})=>(0,Ce.isEqualCaseInsensitive)(t,e.contract)&&r===s));o?r.push(o):n.push({tokenId:s,...e})}));const s=r.map((async e=>this.nftController.checkAndUpdateSingleNftOwnershipStatus(e,!1,h,{selectedAddress:i})));await Promise.allSettled(s);const o=n.map((async e=>this.nftController.addNft(e.contract,e.tokenId,h)));await Promise.allSettled(o)}}}_trackTransactionFailure(e){var t,r;const{txReceipt:n}=e,s=this.getState(),{allTokens:a}=this.tokensController.state,o=this.accountsController.getSelectedAccount(),i=(null==a||null===(t=a[e.chainId])||void 0===t?void 0:t[o.address])||[];n&&"0x0"===n.status&&this.metaMetricsController.trackEvent({event:"Tx Status Update: On-Chain Failure",category:me.MetaMetricsEventCategory.Background,properties:{action:"Transactions",errorMessage:null===(r=e.simulationFails)||void 0===r?void 0:r.reason,numberOfTokens:i.length,numberOfAccounts:Object.keys(s.accounts).length}},{matomoEvent:!0})}_onUserOperationAdded(e){const t=this.txController.state.transactions.find((t=>t.id===e.id));t&&(t.type===G.TransactionType.swap?this.controllerMessenger.publish("TransactionController:transactionNewSwap",{transactionMeta:t}):t.type===G.TransactionType.swapApproval&&this.controllerMessenger.publish("TransactionController:transactionNewSwapApproval",{transactionMeta:t}))}_onUserOperationTransactionUpdated(e){const t={...e,txParams:{...e.txParams,from:this.accountsController.getSelectedAccount().address}};this.txController.state.transactions.some((e=>e.id===t.id))||this.txController.update((e=>{e.transactions.push(t)})),this.txController.updateTransaction(t,"Generated from user operation"),this.controllerMessenger.publish("TransactionController:transactionStatusUpdated",{transactionMeta:t})}_getMetaMaskState(){return{metamask:this.getState()}}_getConfigForRemoteFeatureFlagRequest(){return{distribution:yr.main||U.DistributionType.Main,environment:Cr["pull-request"]||U.EnvironmentType.Development}}}async function vr(e,t){var r,n,s,a,o;const i=null===(r=this.opts.overrides)||void 0===r?void 0:r.keyrings;let c=null;switch(e.name){case ce.HardwareDeviceNames.trezor:c=(null==i||null===(n=i.trezor)||void 0===n?void 0:n.type)||C.TrezorKeyring.type;break;case ce.HardwareDeviceNames.oneKey:c=(null==i||null===(s=i.oneKey)||void 0===s?void 0:s.type)||(null===C.OneKeyKeyring||void 0===C.OneKeyKeyring?void 0:C.OneKeyKeyring.type);break;case ce.HardwareDeviceNames.ledger:c=(null==i||null===(a=i.ledger)||void 0===a?void 0:a.type)||y.LedgerKeyring.type;break;case ce.HardwareDeviceNames.qr:c=v.MetaMaskKeyring.type;break;case ce.HardwareDeviceNames.lattice:c=(null==i||null===(o=i.lattice)||void 0===o?void 0:o.type)||w.default.type;break;default:throw new Error("MetamaskController:#withKeyringForDevice - Unknown device")}return this.keyringController.withKeyring({type:c},(async({keyring:r})=>{if(e.hdPath&&r.setHdPath&&r.setHdPath(e.hdPath),e.name===ce.HardwareDeviceNames.lattice&&(r.appName="MetaMask"),e.name===ce.HardwareDeviceNames.trezor||e.name===ce.HardwareDeviceNames.oneKey){const e=r.getModel();this.appStateController.setTrezorModel(e)}return r.network=(0,Ee.getProviderConfig)({metamask:this.networkController.state}).type,await t(r)}),{createIfMissing:!0})}function kr(e,t){const r=fr(wr,this,Tr).call(this,t),n=fr(wr,this,Tr).call(this,e);r!==n&&this.tokenListController.updatePreventPollingOnNetworkRestart(!n)}function Tr(e){const{useTokenDetection:t,useTransactionSimulations:r,preferences:n}=e??{},{petnamesEnabled:s}=n??{};return t||s||r}function Pr(){const e=fr(wr,this,Mr).call(this);return this.networkController.getNetworkClientById(e).configuration.chainId}function Mr(){return this.networkController.state.selectedNetworkClientId}function Er({existingControllers:e,initFunctions:t,initState:r}){const n={getCronjobControllerStorageManager:()=>this.opts.cronjobControllerStorageManager,getFlatState:this.getState.bind(this),getGlobalChainId:fr(wr,this,Pr).bind(this),getGlobalNetworkClientId:fr(wr,this,Mr).bind(this),getPermittedAccounts:this.getPermittedAccounts.bind(this),getProvider:()=>this.provider,getStateUI:this._getMetaMaskState.bind(this),getTransactionMetricsRequest:this.getTransactionMetricsRequest.bind(this),updateAccountBalanceForTransactionNetwork:this.updateAccountBalanceForTransactionNetwork.bind(this),offscreenPromise:this.offscreenPromise,preinstalledSnaps:this.opts.preinstalledSnaps,persistedState:r,removeAllConnections:this.removeAllConnections.bind(this),setupUntrustedCommunicationEip1193:this.setupUntrustedCommunicationEip1193.bind(this),showNotification:this.platform._showNotification,getMetaMetricsId:this.metaMetricsController.getMetaMetricsId.bind(this.metaMetricsController),trackEvent:this.metaMetricsController.trackEvent.bind(this.metaMetricsController),refreshOAuthToken:this.oauthService.getNewRefreshToken.bind(this.oauthService),revokeAndGetNewRefreshToken:this.oauthService.revokeAndGetNewRefreshToken.bind(this.oauthService),getAccountType:this.getAccountType.bind(this),getDeviceModel:this.getDeviceModel.bind(this),getHardwareTypeForMetric:this.getHardwareTypeForMetric.bind(this),trace:Ae.trace};return(0,Jt.initControllers)({baseControllerMessenger:this.controllerMessenger,existingControllers:e,initFunctions:t,initRequest:n})}r.default=Sr}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"$root$",file:"app/scripts/metamask-controller.js"}],[227,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:2,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=2;try{"etherscan"===t.data.config.provider.type&&(t.data.config.provider.type="rpc",t.data.config.provider.rpcTarget="https://rpc.metamask.io/")}catch(e){}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/002.js"}],[228,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:3,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=3;try{"https://rawtestrpc.metamask.io/"===t.data.config.provider.rpcTarget&&(t.data.config.provider.rpcTarget="https://testrpc.metamask.io/")}catch(e){}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/003.js"}],[229,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:4,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=4;try{if("rpc"!==t.data.config.provider.type)return Promise.resolve(t);switch(t.data.config.provider.rpcTarget){case"https://testrpc.metamask.io/":t.data.config.provider={type:"testnet"};break;case"https://rpc.metamask.io/":t.data.config.provider={type:"mainnet"}}}catch(e){}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/004.js"}],[23,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){return e.getRestricted({name:"AccountTreeController",allowedEvents:["AccountsController:accountAdded","AccountsController:accountRemoved"],allowedActions:["AccountsController:listMultichainAccounts","SnapController:get","KeyringController:getState"]})}Object.defineProperty(r,"__esModule",{value:!0}),r.getAccountTreeControllerInitMessenger=function(e){return n(e)},r.getAccountTreeControllerMessenger=n}}},{package:"$root$",file:"app/scripts/controller-init/messengers/accounts/account-tree-controller-messenger.ts"}],[230,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:5,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=5;try{const e=function(e){const{config:t}=e,r={...e,KeyringController:{vault:e.vault,selectedAccount:t.selectedAccount,walletNicknames:e.walletNicknames}};return delete r.vault,delete r.walletNicknames,delete r.config.selectedAccount,r}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #5${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/005.js"}],[231,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:6,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=6;try{const e=function(e){const t=e.KeyringController,r={...e,PreferencesController:{selectedAddress:t.selectedAccount}};return delete r.KeyringController.selectedAccount,r}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #6${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/006.js"}],[232,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:7,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=7;try{const e=function(e){const t={...e,TransactionManager:{transactions:e.transactions||[],gasMultiplier:e.gasMultiplier||1}};return delete t.transactions,delete t.gasMultiplier,t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #7${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/007.js"}],[233,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:8,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=8;try{const e=function(e){const t={...e,NoticeController:{noticesList:e.noticesList||[]}};return delete t.noticesList,t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #8${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/008.js"}],[234,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:9,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=9;try{const e=function(e){const t=(0,n.merge)({},e,{CurrencyController:{currentCurrency:e.currentFiat||e.fiatCurrency||"USD",conversionRate:e.conversionRate,conversionDate:e.conversionDate}});return delete t.currentFiat,delete t.fiatCurrency,delete t.conversionRate,delete t.conversionDate,t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #9${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/009.js"}],[235,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:10,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=10;try{const e=function(e){const t=(0,n.merge)({},e,{ShapeShiftController:{shapeShiftTxList:e.shapeShiftTxList||[]}});return delete t.shapeShiftTxList,t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #10${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/010.js"}],[236,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:11,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=11;try{const e=function(e){const t=e;return delete t.TOSHash,delete t.isDisclaimerConfirmed,t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #11${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/011.js"}],[2361,{"./push-utils.cjs":2362},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createSubscribeToPushNotifications=r.deleteRegToken=r.createRegToken=void 0;var n=e("./push-utils.cjs");Object.defineProperty(r,"createRegToken",{enumerable:!0,get:function(){return n.createRegToken}}),Object.defineProperty(r,"deleteRegToken",{enumerable:!0,get:function(){return n.deleteRegToken}}),Object.defineProperty(r,"createSubscribeToPushNotifications",{enumerable:!0,get:function(){return n.createSubscribeToPushNotifications}})}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/index.cjs"}],[2362,{"../../NotificationServicesController/index.cjs":2335,"../../shared/to-raw-notification.cjs":2366,"firebase/app":4497,"firebase/messaging":4498,"firebase/messaging/sw":4499,loglevel:4913},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.createSubscribeToPushNotifications=r.deleteRegToken=r.createRegToken=r.supportedCache=void 0;const s=e("firebase/app"),a=e("firebase/messaging"),o=e("firebase/messaging/sw"),i=n(e("loglevel")),c=e("../../NotificationServicesController/index.cjs"),l=e("../../shared/to-raw-notification.cjs");r.supportedCache=null;const d=async e=>{if(!await(async()=>(r.supportedCache??(r.supportedCache=await(0,o.isSupported)()),r.supportedCache))())return null;const t=await(async e=>{try{return(0,s.getApp)()}catch{const t={apiKey:e.apiKey,authDomain:e.authDomain,storageBucket:e.storageBucket,projectId:e.projectId,messagingSenderId:e.messagingSenderId,appId:e.appId,measurementId:e.measurementId};return(0,s.initializeApp)(t)}})(e);return(0,o.getMessaging)(t)};r.createRegToken=async function(e){try{const t=await d(e);if(!t)return null;return await(0,a.getToken)(t,{serviceWorkerRegistration:self.registration,vapidKey:e.vapidKey})}catch{return null}},r.deleteRegToken=async function(e){try{const t=await d(e);return!t||(await(0,a.deleteToken)(t),!0)}catch{return!1}},r.createSubscribeToPushNotifications=function(e){return async function(t){const r=await async function(e,t){const r=await d(e);if(!r)return null;const n=(0,o.onBackgroundMessage)(r,(async e=>{try{const r=e?.data?.data?JSON.parse(e?.data?.data):undefined;if(!r)return;const n=(0,l.toRawOnChainNotification)(r),s=c.Processors.processNotification(n);await t(s)}catch(t){throw i.default.error("Unable to send push notification:",{notification:e?.data?.data,error:t}),new Error("Unable to send push notification")}}));return()=>n()}(t,(async t=>{e.messenger.publish("NotificationServicesPushController:onNewNotifications",t),await e.onReceivedHandler(t)})),n=function(e){const t=t=>{const r=t?.notification?.data;e(t,r)};return self.addEventListener("notificationclick",t),()=>self.removeEventListener("notificationclick",t)}(((t,r)=>{e.messenger.publish("NotificationServicesPushController:pushNotificationClicked",r),e.onClickHandler(t,r)}));return()=>{r?.(),n()}}}}}},{package:"@metamask/notification-services-controller",file:"node_modules/@metamask/notification-services-controller/dist/NotificationServicesPushController/web/push-utils.cjs"}],[237,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:12,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=12;try{const e=function(e){const t=e;return t.NoticeController.noticesList.forEach((e=>{e.read&&(e.body="")})),t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #12${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/012.js"}],[2372,{"./ObservableStore":2374},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ComposedStore=void 0;const n=e("./ObservableStore");class s extends n.ObservableStore{constructor(e){super({}),this._children=e||{},Object.keys(this._children).forEach((e=>{const t=this._children[e];this._addChild(e,t)}))}_addChild(e,t){const r=t=>{const r=this.getState();r[e]=t,this.putState(r)};t.subscribe(r),r(t.getState())}}r.ComposedStore=s}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ComposedStore.js"}],[2373,{"./ObservableStore":2374},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MergedStore=void 0;const n=e("./ObservableStore");class s extends n.ObservableStore{constructor(e=[]){super({}),this._children=e,e.forEach((e=>this._addChild(e))),this._updateWholeState()}_addChild(e){e.subscribe((()=>this._updateWholeState()))}_updateWholeState(){const e=this._children.map((e=>e.getState())),t=Object.assign({},...e);this.putState(t)}}r.MergedStore=s}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/MergedStore.js"}],[2374,{"@metamask/safe-event-emitter":2524},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.ObservableStore=void 0;const s=n(e("@metamask/safe-event-emitter"));class a extends s.default{constructor(e){super(),e===undefined?this._state={}:this._state=e}getState(){return this._getState()}putState(e){this._putState(e),this.emit("update",e)}updateState(e){if(e&&"object"==typeof e){const t=this.getState();this.putState(Object.assign(Object.assign({},t),e))}else this.putState(e)}subscribe(e){this.on("update",e)}unsubscribe(e){this.removeListener("update",e)}_getState(){return this._state}_putState(e){this._state=e}}r.ObservableStore=a}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/ObservableStore.js"}],[2375,{"readable-stream":5270},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.storeAsStream=void 0;const n=e("readable-stream");class s extends n.Duplex{constructor(e){super({objectMode:!0}),this.resume(),this.handler=e=>this.push(e),this.obsStore=e,this.obsStore.subscribe(this.handler)}pipe(e,t){const r=super.pipe(e,t);return e.write(this.obsStore.getState()),r}_write(e,t,r){this.obsStore.putState(e),r()}_read(e){return undefined}_destroy(e,t){this.obsStore.unsubscribe(this.handler),super._destroy(e,t)}}r.storeAsStream=function(e){return new s(e)}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/asStream.js"}],[2376,{"./ComposedStore":2372,"./MergedStore":2373,"./ObservableStore":2374,"./asStream":2375,"./transform":2377},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r),Object.defineProperty(e,n,{enumerable:!0,get:function(){return t[r]}})}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./asStream"),r),s(e("./ComposedStore"),r),s(e("./MergedStore"),r),s(e("./ObservableStore"),r),s(e("./transform"),r)}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/index.js"}],[2377,{"readable-stream":5270},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.storeTransformStream=void 0;const n=e("readable-stream");r.storeTransformStream=function(e){return new n.Transform({objectMode:!0,transform:(t,r,n)=>{try{const r=e(t);return n(undefined,r),undefined}catch(e){return n(e),undefined}}})}}}},{package:"@metamask/obs-store",file:"node_modules/@metamask/obs-store/dist/transform.js"}],[238,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:13,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=13;try{const e=function(e){const t=e,{config:r}=t;r&&r.provider&&"testnet"===r.provider.type&&(t.config.provider.type="ropsten");return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #13${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/013.js"}],[239,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:14,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=14;try{const e=function(e){const t=e;return t.NetworkController={},t.NetworkController.provider=t.config.provider,delete t.config.provider,t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #14${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/014.js"}],[2390,{"./enums.cjs":2391,"@metamask/base-controller":1474,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u,h=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},p=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.PermissionLogController=void 0;const m=e("@metamask/base-controller"),f=e("@metamask/utils"),g=e("./enums.cjs"),b={permissionHistory:{},permissionActivityLog:[]};class C extends m.BaseController{constructor({messenger:e,restrictedMethods:t,state:r}){super({messenger:e,name:"PermissionLogController",metadata:{permissionHistory:{persist:!0,anonymous:!1},permissionActivityLog:{persist:!0,anonymous:!1}},state:{...b,...r}}),n.add(this),s.set(this,void 0),h(this,s,t,"f")}updateAccountsHistory(e,t){if(0===t.length)return;const r={eth_accounts:{accounts:p(this,n,"m",a).call(this,t,Date.now())}};p(this,n,"m",l).call(this,e,r)}createMiddleware(){return(e,t,r)=>{const{origin:a,method:l}=e,u=l.startsWith(g.WALLET_PREFIX),h="eth_requestAccounts"===l;if(!g.LOG_IGNORE_METHODS.includes(l)&&(u||p(this,s,"f").has(l))||h){const s=p(this,n,"m",o).call(this,e,u),l=p(this,n,"m",d).call(this,e);r((e=>{const r=Date.now();p(this,n,"m",i).call(this,s,t,r),l&&!t.error&&t.result&&a&&p(this,n,"m",c).call(this,l,a,t.result,r,h),e()}))}else r()}}}r.PermissionLogController=C,s=new WeakMap,n=new WeakSet,a=function(e,t){return e.reduce(((e,r)=>({...e,[r]:t})),{})},o=function(e,t){const r={id:e.id,method:e.method,methodType:t?g.LOG_METHOD_TYPES.internal:g.LOG_METHOD_TYPES.restricted,origin:e.origin,requestTime:Date.now(),responseTime:null,success:null};return this.update((e=>{const t=[...e.permissionActivityLog,r];e.permissionActivityLog=t.length>g.LOG_LIMIT?t.slice(1):t})),r},i=function(e,t,r){e&&t&&this.update((n=>{n.permissionActivityLog=n.permissionActivityLog.map((n=>n.id===e.id?{...n,success:(0,f.hasProperty)(t,"result"),responseTime:r}:n))}))},c=function(e,t,r,s,o){let i;if(o){const e=r;i={eth_accounts:{accounts:p(this,n,"m",a).call(this,e,s),lastApproved:s}}}else{i=r.reduce(((t,r)=>{const o=r.parentCapability;if(!e.includes(o))return t;if("eth_accounts"===o){const e=p(this,n,"m",u).call(this,r);return{...t,[o]:{lastApproved:s,accounts:p(this,n,"m",a).call(this,e,s)}}}return{...t,[o]:{lastApproved:s}}}),{})}Object.keys(i).length>0&&p(this,n,"m",l).call(this,t,i)},l=function(e,t){const{permissionHistory:r}=this.state,n=r[e]??{},s={...n,...t},a=n.eth_accounts,o=t.eth_accounts;if(a&&o){const e=o.lastApproved??a.lastApproved;s.eth_accounts={lastApproved:e,accounts:{...a.accounts,...o.accounts}}}this.update((t=>{t.permissionHistory={...r,[e]:s}}))},d=function(e){const{method:t,params:r}=e;return"eth_requestAccounts"===t?["eth_accounts"]:t===`${g.WALLET_PREFIX}requestPermissions`&&r&&Array.isArray(r)&&r[0]&&"object"==typeof r[0]&&!Array.isArray(r[0])?Object.keys(r[0]):null},u=function(e){if("eth_accounts"!==e.parentCapability||!e.caveats)return[];const t=new Set;for(const r of e.caveats)if(r.type===g.CAVEAT_TYPES.restrictReturnedAccounts&&Array.isArray(r.value))for(const e of r.value)t.add(e);return[...t]}}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/PermissionLogController.cjs"}],[2391,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n;Object.defineProperty(r,"__esModule",{value:!0}),r.LOG_LIMIT=r.LOG_METHOD_TYPES=r.LOG_IGNORE_METHODS=r.CAVEAT_TYPES=r.WALLET_PREFIX=void 0,r.WALLET_PREFIX="wallet_",r.CAVEAT_TYPES=Object.freeze({restrictReturnedAccounts:"restrictReturnedAccounts"}),r.LOG_IGNORE_METHODS=["wallet_registerOnboarding","wallet_watchAsset"],function(e){e.restricted="restricted",e.internal="internal"}(n||(r.LOG_METHOD_TYPES=n={})),r.LOG_LIMIT=100}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/enums.cjs"}],[2392,{"./PermissionLogController.cjs":2390},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./PermissionLogController.cjs"),r)}}},{package:"@metamask/permission-log-controller",file:"node_modules/@metamask/permission-log-controller/dist/index.cjs"}],[24,{"./account-tree-controller-messenger":23,"./institutional-snap-controller-messenger":25},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),Object.defineProperty(r,"getAccountTreeControllerInitMessenger",{enumerable:!0,get:function(){return n.getAccountTreeControllerInitMessenger}}),Object.defineProperty(r,"getAccountTreeControllerMessenger",{enumerable:!0,get:function(){return n.getAccountTreeControllerMessenger}}),Object.defineProperty(r,"getInstitutionalSnapControllerMessenger",{enumerable:!0,get:function(){return s.getInstitutionalSnapControllerMessenger}});var n=e("./account-tree-controller-messenger"),s=e("./institutional-snap-controller-messenger")}}},{package:"$root$",file:"app/scripts/controller-init/messengers/accounts/index.ts"}],[240,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("@metamask/transaction-controller"),s=e("lodash");r.default={version:15,migrate(e){const t=(0,s.cloneDeep)(e);t.meta.version=15;try{const e=function(e){const t=e,{TransactionController:r}=t;if(r&&r.transactions){const{transactions:e}=r;t.TransactionController.transactions=e.map((e=>e.err?("Gave up submitting tx."===e.err.message&&(e.status=n.TransactionStatus.failed),e):e))}return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #15${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/015.js"}],[2403,{"readable-stream":5270},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BasePostMessageStream=void 0;const n=e("readable-stream"),s=()=>undefined,a="SYN",o="ACK";class i extends n.Duplex{constructor(e){super(Object.assign({objectMode:!0},e)),this._init=!1,this._haveSyn=!1,this._log=()=>null}_handshake(){this._write(a,null,s),this.cork()}_onData(e){if(this._init)try{this.push(e),this._log(e,!1)}catch(e){this.emit("error",e)}else e===a?(this._haveSyn=!0,this._write(o,null,s)):e===o&&(this._init=!0,this._haveSyn||this._write(o,null,s),this.uncork())}_read(){return undefined}_write(e,t,r){e!==o&&e!==a&&this._log(e,!0),this._postMessage(e),r()}_setLogger(e){this._log=e}}r.BasePostMessageStream=i}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/BasePostMessageStream.cjs"}],[2404,{"./BasePostMessageStream.cjs":2403,"./runtime/BrowserRuntimePostMessageStream.cjs":2405,"./utils.cjs":2406,"./web-worker/WebWorkerParentPostMessageStream.cjs":2407,"./web-worker/WebWorkerPostMessageStream.cjs":2408,"./window/WindowPostMessageStream.cjs":2409},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.isValidStreamMessage=void 0,s(e("./window/WindowPostMessageStream.cjs"),r),s(e("./web-worker/WebWorkerPostMessageStream.cjs"),r),s(e("./web-worker/WebWorkerParentPostMessageStream.cjs"),r),s(e("./runtime/BrowserRuntimePostMessageStream.cjs"),r),s(e("./BasePostMessageStream.cjs"),r);var a=e("./utils.cjs");Object.defineProperty(r,"isValidStreamMessage",{enumerable:!0,get:function(){return a.isValidStreamMessage}})}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/index.cjs"}],[2405,{"../BasePostMessageStream.cjs":2403,"../utils.cjs":2406},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},o=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},i=this&&this.__rest||function(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var s=0;for(n=Object.getOwnPropertySymbols(e);s<n.length;s++)t.indexOf(n[s])<0&&Object.prototype.propertyIsEnumerable.call(e,n[s])&&(r[n[s]]=e[n[s]])}return r};Object.defineProperty(r,"__esModule",{value:!0}),r.BrowserRuntimePostMessageStream=void 0;const c=e("../BasePostMessageStream.cjs"),l=e("../utils.cjs");class d extends c.BasePostMessageStream{constructor(e){var{name:t,target:r}=e;super(i(e,["name","target"])),n.set(this,void 0),s.set(this,void 0),a(this,n,t,"f"),a(this,s,r,"f"),this._onMessage=this._onMessage.bind(this),this._getRuntime().onMessage.addListener(this._onMessage),this._handshake()}_postMessage(e){this._getRuntime().sendMessage({target:o(this,s,"f"),data:e})}_onMessage(e){(0,l.isValidStreamMessage)(e)&&e.target===o(this,n,"f")&&this._onData(e.data)}_getRuntime(){var e,t;if("chrome"in globalThis&&"function"==typeof(null===(e=null===chrome||void 0===chrome?void 0:chrome.runtime)||void 0===e?void 0:e.sendMessage))return chrome.runtime;if("browser"in globalThis&&"function"==typeof(null===(t=null===browser||void 0===browser?void 0:browser.runtime)||void 0===t?void 0:t.sendMessage))return browser.runtime;throw new Error("browser.runtime.sendMessage is not a function. This class should only be instantiated in a web extension.")}_destroy(){this._getRuntime().onMessage.removeListener(this._onMessage)}}r.BrowserRuntimePostMessageStream=d,n=new WeakMap,s=new WeakMap}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/runtime/BrowserRuntimePostMessageStream.cjs"}],[2406,{"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isValidStreamMessage=r.DEDICATED_WORKER_NAME=void 0;const n=e("@metamask/utils");r.DEDICATED_WORKER_NAME="dedicatedWorker",r.isValidStreamMessage=function(e){return(0,n.isObject)(e)&&Boolean(e.data)&&("number"==typeof e.data||"object"==typeof e.data||"string"==typeof e.data)}}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/utils.cjs"}],[2407,{"../BasePostMessageStream.cjs":2403,"../utils.cjs":2406},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__rest||function(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var s=0;for(n=Object.getOwnPropertySymbols(e);s<n.length;s++)t.indexOf(n[s])<0&&Object.prototype.propertyIsEnumerable.call(e,n[s])&&(r[n[s]]=e[n[s]])}return r};Object.defineProperty(r,"__esModule",{value:!0}),r.WebWorkerParentPostMessageStream=void 0;const s=e("../BasePostMessageStream.cjs"),a=e("../utils.cjs");class o extends s.BasePostMessageStream{constructor(e){var{worker:t}=e;super(n(e,["worker"])),this._target=a.DEDICATED_WORKER_NAME,this._worker=t,this._worker.onmessage=this._onMessage.bind(this),this._handshake()}_postMessage(e){this._worker.postMessage({target:this._target,data:e})}_onMessage(e){const t=e.data;(0,a.isValidStreamMessage)(t)&&this._onData(t.data)}_destroy(){this._worker.onmessage=null,this._worker=null}}r.WebWorkerParentPostMessageStream=o}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerParentPostMessageStream.cjs"}],[2408,{"../BasePostMessageStream.cjs":2403,"../utils.cjs":2406},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.WebWorkerPostMessageStream=void 0;const n=e("../BasePostMessageStream.cjs"),s=e("../utils.cjs");class a extends n.BasePostMessageStream{constructor(e={}){if("undefined"==typeof self||"undefined"==typeof WorkerGlobalScope)throw new Error("WorkerGlobalScope not found. This class should only be instantiated in a WebWorker.");super(e),this._name=s.DEDICATED_WORKER_NAME,self.addEventListener("message",this._onMessage.bind(this)),this._handshake()}_postMessage(e){self.postMessage({data:e})}_onMessage(e){const t=e.data;(0,s.isValidStreamMessage)(t)&&t.target===this._name&&this._onData(t.data)}_destroy(){return undefined}}r.WebWorkerPostMessageStream=a}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/web-worker/WebWorkerPostMessageStream.cjs"}],[2409,{"../BasePostMessageStream.cjs":2403,"../utils.cjs":2406,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a=this&&this.__rest||function(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var s=0;for(n=Object.getOwnPropertySymbols(e);s<n.length;s++)t.indexOf(n[s])<0&&Object.prototype.propertyIsEnumerable.call(e,n[s])&&(r[n[s]]=e[n[s]])}return r};Object.defineProperty(r,"__esModule",{value:!0}),r.WindowPostMessageStream=void 0;const o=e("@metamask/utils"),i=e("../BasePostMessageStream.cjs"),c=e("../utils.cjs"),l=null===(n=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"source"))||void 0===n?void 0:n.get;(0,o.assert)(l,"MessageEvent.prototype.source getter is not defined.");const d=null===(s=Object.getOwnPropertyDescriptor(MessageEvent.prototype,"origin"))||void 0===s?void 0:s.get;(0,o.assert)(d,"MessageEvent.prototype.origin getter is not defined.");class u extends i.BasePostMessageStream{constructor(e){var{name:t,target:r,targetOrigin:n=location.origin,targetWindow:s=window}=e;if(super(a(e,["name","target","targetOrigin","targetWindow"])),"undefined"==typeof window||"function"!=typeof window.postMessage)throw new Error("window.postMessage is not a function. This class should only be instantiated in a Window.");this._name=t,this._target=r,this._targetOrigin=n,this._targetWindow=s,this._onMessage=this._onMessage.bind(this),window.addEventListener("message",this._onMessage,!1),this._handshake()}_postMessage(e){this._targetWindow.postMessage({target:this._target,data:e},this._targetOrigin)}_onMessage(e){const t=e.data;"*"!==this._targetOrigin&&d.call(e)!==this._targetOrigin||l.call(e)!==this._targetWindow||!(0,c.isValidStreamMessage)(t)||t.target!==this._name||this._onData(t.data)}_destroy(){window.removeEventListener("message",this._onMessage,!1)}}r.WindowPostMessageStream=u}}},{package:"@metamask/post-message-stream",file:"node_modules/@metamask/post-message-stream/dist/window/WindowPostMessageStream.cjs"}],[241,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("@metamask/transaction-controller"),s=e("lodash");r.default={version:16,migrate(e){const t=(0,s.cloneDeep)(e);t.meta.version=16;try{const e=function(e){const t=e,{TransactionController:r}=t;if(r&&r.transactions){const{transactions:e}=t.TransactionController;t.TransactionController.transactions=e.map((e=>e.err?("transaction with the same hash was already imported."===e.err&&(e.status=n.TransactionStatus.submitted,delete e.err),e):e))}return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #16${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/016.js"}],[2410,{"./ppom-controller":2411},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.PPOMController=r.NETWORK_CACHE_DURATION=void 0;var n=e("./ppom-controller");Object.defineProperty(r,"NETWORK_CACHE_DURATION",{enumerable:!0,get:function(){return n.NETWORK_CACHE_DURATION}}),Object.defineProperty(r,"PPOMController",{enumerable:!0,get:function(){return n.PPOMController}})}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/index.js"}],[2411,{"./ppom-storage":2412,"./util":2413,"@metamask/base-controller":2418,"@metamask/controller-utils":1557,"await-semaphore":3929},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u,h,p,m,f,g,b,C,y,w,S,v,k,T,P,M,E,A,I,N,_,O,R,x,j=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},B=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.PPOMController=r.NETWORK_CACHE_DURATION=void 0;const D=e("@metamask/base-controller"),F=e("@metamask/controller-utils"),$=e("await-semaphore"),L=e("./ppom-storage"),U=e("./util");r.NETWORK_CACHE_DURATION=6048e5;const K=["eth_call","eth_blockNumber","eth_createAccessList","eth_getLogs","eth_getFilterLogs","eth_getTransactionByHash","eth_chainId","eth_getBlockByHash","eth_getBlockByNumber","eth_getCode","eth_getStorageAt","eth_getBalance","eth_getTransactionCount","trace_call","trace_callMany","debug_traceCall","trace_filter"],q={versionInfo:{persist:!0,anonymous:!1},storageMetadata:{persist:!0,anonymous:!1}},H="PPOMController",V={headers:{"Content-Type":"application/json"}};class W extends D.BaseController{constructor({chainId:e,messenger:t,provider:r,storageBackend:C,securityAlertsEnabled:y,onPreferencesChange:w,ppomProvider:T,cdnBaseUrl:P,providerRequestLimit:M,state:E,blockaidPublicKey:A,nativeCrypto:I}){super({name:H,metadata:q,messenger:t,state:{versionInfo:E?.versionInfo??[],storageMetadata:E?.storageMetadata??[]}}),n.add(this),s.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),u.set(this,0),h.set(this,void 0),p.set(this,void 0),m.set(this,{}),f.set(this,void 0),g.set(this,!1),b.set(this,undefined),j(this,h,(0,U.addHexPrefix)(e),"f"),j(this,a,r,"f"),j(this,c,T,"f"),j(this,o,new L.PPOMStorage({storageBackend:C,readMetadata:()=>[...this.state.storageMetadata],writeMetadata:e=>{this.update((t=>{t.storageMetadata=e}))}}),"f"),j(this,i,new $.Mutex,"f"),j(this,l,P,"f"),j(this,d,M??300,"f"),j(this,p,y,"f"),j(this,f,A,"f"),j(this,b,I,"f"),w(B(this,n,"m",S).bind(this)),B(this,n,"m",v).call(this),B(this,n,"m",k).call(this)}async usePPOM(e,t){const r=t??B(this,h,"f");if(!B(this,p,"f"))throw Error("User has securityAlertsEnabled set to false");if(!(0,U.blockaidValidationSupportedForNetwork)(r))throw Error(`Blockaid validation not available on network with chainId: ${r}`);return await B(this,i,"f").use((async()=>{const t=await B(this,n,"m",P).call(this,r);j(this,u,0,"f"),j(this,m,{},"f");return{...await e(t),providerRequestsCount:{...B(this,m,"f")}}}))}}r.PPOMController=W,s=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,u=new WeakMap,h=new WeakMap,p=new WeakMap,m=new WeakMap,f=new WeakMap,g=new WeakMap,b=new WeakMap,n=new WeakSet,C=async function(){if(B(this,p,"f")&&!B(this,g,"f")){const{ppomInit:e}=B(this,c,"f");await e("./ppom_bg.wasm"),j(this,g,!0,"f")}},y=function(){B(this,n,"m",T).call(this).catch((e=>{console.error(`Error in resetting ppom: ${e.message}`)}));const{storageMetadata:e}=this.state;this.update((e=>{e.versionInfo=[],e.storageMetadata=[]})),B(this,o,"f").deleteAllFiles(e).catch((e=>{console.error(`Error in deleting files: ${e.message}`)}))},w=function(e){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e.selectedNetworkClientId),{chainId:r}=t.configuration,s=(0,U.addHexPrefix)(r);s!==B(this,h,"f")&&(j(this,h,s,"f"),B(this,n,"m",T).call(this).catch((e=>{console.error(`Error in resetting ppom: ${e.message}`)})))},S=function(e){const t=e.securityAlertsEnabled;t!==B(this,p,"f")&&(j(this,p,t,"f"),t||B(this,n,"m",y).call(this))},v=function(){this.messagingSystem.registerActionHandler(`${H}:usePPOM`,this.usePPOM.bind(this))},k=function(){const e=B(this,n,"m",w).bind(this);this.messagingSystem.subscribe("NetworkController:networkDidChange",e)},T=async function(){await B(this,i,"f").use((async()=>{B(this,s,"f")&&(B(this,s,"f").free(),j(this,s,undefined,"f"))}))},P=async function(e){const t=await B(this,n,"m",M).call(this);let r;return(B(this,s,"f")===undefined||t)&&(r=await B(this,n,"m",x).call(this,e),B(this,h,"f")===e&&(B(this,s,"f")&&B(this,s,"f").free(),j(this,s,r,"f")),B(this,o,"f").syncMetadata(this.state.versionInfo).catch((e=>{console.error(`Error while trying to sync metadata: ${e.message}`)}))),r},M=async function(){const e=await B(this,n,"m",_).call(this);return!!e&&(this.update((t=>{t.versionInfo=e})),!0)},E=function(e,t){return e.find((e=>e.name===t.name&&e.chainId===t.chainId&&e.version===t.version&&e.checksum===t.checksum))},A=async function(e){const t=await Promise.all(e.map((async e=>{let t;try{t=await B(this,n,"m",I).call(this,e)}catch(t){console.error(`Error in getting file ${e.filePath}: ${t.message}`)}return t?[e.name,new Uint8Array(t)]:undefined})));return t?.filter((e=>e?.[1]!==undefined))},I=async function(e){const{storageMetadata:t}=this.state;if(B(this,n,"m",E).call(this,t,e))try{return await B(this,o,"f").readFile(e.name,e.chainId)}catch(e){console.error(`Error in reading file: ${e.message}`)}(0,U.checkFilePath)(e.filePath);const r=(0,U.constructURLHref)(B(this,l,"f"),e.filePath),s=await B(this,n,"m",O).call(this,r);return await(0,U.validateSignature)(s,e.hashSignature,B(this,f,"f"),e.filePath,B(this,b,"f")),await B(this,o,"f").writeFile({data:s,...e}).catch((e=>{console.error(`Error in writing file: ${e.message}`)})),s},N=async function(e,t={},r="GET"){const n=await(0,F.safelyExecute)((async()=>(0,F.timeoutFetch)(e,{method:r,cache:"no-cache",redirect:"error",...t},1e4)),!0),s=304===n?.status;if(!n?.status||n?.status<200||n?.status>399)throw new Error(`Failed to fetch file with url: ${e}`);return{cached:s,response:n}},_=async function(){const e=(0,U.constructURLHref)(B(this,l,"f"),"ppom_version.json"),{cached:t,response:r}=await B(this,n,"m",N).call(this,e,{headers:V});return t&&this.state.versionInfo?.length?undefined:r.json()},O=async function(e){const{response:t}=await B(this,n,"m",N).call(this,e);return await t.arrayBuffer()},R=async function(e,t){if(B(this,u,"f")>B(this,d,"f"))return U.PROVIDER_ERRORS.limitExceeded();if(j(this,u,B(this,u,"f")+1,"f"),!K.includes(e))return U.PROVIDER_ERRORS.methodNotSupported();B(this,m,"f")[e]=B(this,m,"f")[e]?Number(B(this,m,"f")[e])+1:1;const r=(0,U.createPayload)(e,t);try{const e=await B(this,a,"f").request(r);return{jsonrpc:"2.0",id:r.id,result:e}}catch(e){return{jsonrpc:"2.0",id:r.id,error:e}}},x=async function(e){await B(this,n,"m",C).call(this);const t=this.state.versionInfo.filter((({chainId:t})=>t===e));if(t?.length===undefined||0===t?.length)throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${e}`);const r=await B(this,n,"m",A).call(this,t);if(r?.length!==t?.length)throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${e}`);const{PPOM:s}=B(this,c,"f");return s.new(B(this,n,"m",R).bind(this),r)}}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-controller.js"}],[2412,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},i=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.PPOMStorage=void 0;r.PPOMStorage=class{constructor({storageBackend:e,readMetadata:t,writeMetadata:r}){n.set(this,void 0),s.set(this,void 0),a.set(this,void 0),o(this,n,e,"f"),o(this,s,t,"f"),o(this,a,r,"f")}async syncMetadata(e){const t=i(this,s,"f").call(this),r=[];for(const n of t){try{await this.readFile(n.name,n.chainId)}catch(e){console.error("Error: ",e);continue}e.find((e=>e.name===n.name&&e.chainId===n.chainId&&e.version===n.version&&e.checksum===n.checksum))&&r.push(n)}const o=await i(this,n,"f").dir();for(const{name:e,chainId:t}of o)r.find((r=>r.name===e&&r.chainId===t))||await i(this,n,"f").delete({name:e,chainId:t});return i(this,a,"f").call(this,r),r}async deleteAllFiles(e){for(const t of e){const{name:e,chainId:r}=t;try{await i(this,n,"f").delete({name:e,chainId:r})}catch(t){console.error(`Error in deleting file: ${e}, ${r}`,t)}}}async readFile(e,t){const r=i(this,s,"f").call(this).find((r=>r.name===e&&r.chainId===t));if(!r)throw new Error(`File metadata (${e}, ${t}) not found`);const a=await i(this,n,"f").read({name:e,chainId:t},r.checksum);if(!a)throw new Error(`Storage File (${e}, ${t}) not found`);return a}async writeFile({data:e,name:t,chainId:r,version:o,checksum:c}){await i(this,n,"f").write({name:t,chainId:r},e,c);const l=i(this,s,"f").call(this),d=l.find((e=>e.name===t&&e.chainId===r));d?(d.version=o,d.checksum=c):l.push({name:t,chainId:r,version:o,checksum:c}),i(this,a,"f").call(this,l)}},n=new WeakMap,s=new WeakMap,a=new WeakMap}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/ppom-storage.js"}],[2413,{buffer:4099,"crypto-js":4217,elliptic:4273,"json-rpc-random-id":4736},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return s(t,e),t},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.checkFilePath=r.addHexPrefix=r.constructURLHref=r.validateSignature=r.PROVIDER_ERRORS=r.createPayload=r.IdGenerator=r.blockaidValidationSupportedForNetwork=r.SUPPORTED_NETWORK_CHAINIDS=void 0;const i=a(e("crypto-js")),c=o(e("elliptic")),l=o(e("json-rpc-random-id")),d=c.default.eddsa;r.SUPPORTED_NETWORK_CHAINIDS={MAINNET:"0x1",BSC:"0x38",OPTIMISM:"0xa",POLYGON:"0x89",AVALANCHE:"0xa86a",ARBITRUM:"0xa4b1",LINEA_MAINNET:"0xe708",BASE:"0x2105",SEPOLIA:"0xaa36a7",OPBNB:"0xcc",ZKSYNC:"0x144",SCROLL:"0x82750",BERACHAIN:"0x138d4",METACHAIN_ONE:"0x1b6e6"};r.blockaidValidationSupportedForNetwork=e=>Object.values(r.SUPPORTED_NETWORK_CHAINIDS).some((t=>t===e)),r.IdGenerator=(0,l.default)();r.createPayload=(e,t)=>({id:(0,r.IdGenerator)(),jsonrpc:"2.0",method:e,params:t??[]}),r.PROVIDER_ERRORS={limitExceeded:()=>({jsonrpc:"2.0",id:(0,r.IdGenerator)(),error:{code:-32005,message:"Limit exceeded"}}),methodNotSupported:()=>({jsonrpc:"2.0",id:(0,r.IdGenerator)(),error:{code:-32601,message:"Method not supported"}})};r.validateSignature=async(e,r,n,s,a,o)=>{const c=await(async(e,t,r=!0)=>{if(t)return t.createHash("sha256").update(e).digest("hex");if("crypto"in globalThis&&"object"==typeof globalThis.crypto&&globalThis.crypto.subtle?.digest&&r){const t=await globalThis.crypto.subtle.digest("SHA-256",e);return Array.from(new Uint8Array(t)).map((e=>e.toString(16).padStart(2,"0"))).join("")}return(0,i.SHA256)(i.default.lib.WordArray.create(e)).toString()})(e,a,o);if(!new d("ed25519").keyFromPublic(n).verify(t.from(c),r))throw Error(`Signature verification failed for file path: ${s}`)};r.constructURLHref=(e,t)=>new URL(`https://${e}/${t}`.replace(/https:\/\/https:\/\//gu,"https://").replace(/\/\//gu,"/")).href;r.addHexPrefix=e=>"string"!=typeof e||e.match(/^-?0x/u)?e:e.match(/^-?0X/u)?e.replace("0X","0x"):`0x${parseInt(e,10).toString(16)}`;r.checkFilePath=e=>{if(!e.match(/^[\w./]+$/u))throw new Error(`Invalid file path for data file: ${e}`)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/ppom-validator",file:"node_modules/@metamask/ppom-validator/dist/util.js"}],[2414,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BaseControllerV1=r.isBaseControllerV1=void 0,r.isBaseControllerV1=function(e){return"name"in e&&"string"==typeof e.name&&"config"in e&&"object"==typeof e.config&&"defaultConfig"in e&&"object"==typeof e.defaultConfig&&"state"in e&&"object"==typeof e.state&&"defaultState"in e&&"object"==typeof e.defaultState&&"disabled"in e&&"boolean"==typeof e.disabled&&"subscribe"in e&&"function"==typeof e.subscribe};class n{constructor(e={},t={}){this.defaultConfig={},this.defaultState={},this.disabled=!1,this.name="BaseController",this.internalConfig=this.defaultConfig,this.internalState=this.defaultState,this.internalListeners=[],this.initialState=t,this.initialConfig=e}initialize(){return this.internalState=this.defaultState,this.internalConfig=this.defaultConfig,this.configure(this.initialConfig),this.update(this.initialState),this}get config(){return this.internalConfig}get state(){return this.internalState}configure(e,t=!1,r=!0){if(r){this.internalConfig=t?e:Object.assign(this.internalConfig,e);for(const e of Object.keys(this.internalConfig)){const t=this.internalConfig[e];t!==undefined&&(this[e]=t)}}else for(const t of Object.keys(e))if(this.internalConfig[t]!==undefined){const r=e[t];this.internalConfig[t]=r,this[t]=r}}notify(){this.disabled||this.internalListeners.forEach((e=>{e(this.internalState)}))}subscribe(e){this.internalListeners.push(e)}unsubscribe(e){const t=this.internalListeners.findIndex((t=>e===t));return t>-1&&this.internalListeners.splice(t,1),t>-1}update(e,t=!1){this.internalState=t?Object.assign({},e):Object.assign({},this.internalState,e),this.notify()}}r.BaseControllerV1=n,r.default=n}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV1.cjs"}],[2415,{immer:4700},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},a=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.getPersistentState=r.getAnonymizedState=r.BaseController=r.isBaseController=void 0;const o=e("immer");(0,o.enablePatches)(),r.isBaseController=function(e){return"name"in e&&"string"==typeof e.name&&"state"in e&&"object"==typeof e.state&&"metadata"in e&&"object"==typeof e.metadata};function i(e,t,r){return Object.keys(e).reduce(((n,s)=>{try{const a=t[s];if(!a)throw new Error(`No metadata found for '${String(s)}'`);const o=a[r],i=e[s];return"function"==typeof o?n[s]=o(i):o&&(n[s]=i),n}catch(e){return setTimeout((()=>{throw e})),n}}),{})}r.BaseController=class{constructor({messenger:e,metadata:t,name:r,state:a}){n.set(this,void 0),this.messagingSystem=e,this.name=r,s(this,n,(0,o.freeze)(a,!0),"f"),this.metadata=t,this.messagingSystem.registerActionHandler(`${r}:getState`,(()=>this.state)),this.messagingSystem.registerInitialEventPayload({eventType:`${r}:stateChange`,getPayload:()=>[this.state,[]]})}get state(){return a(this,n,"f")}set state(e){throw new Error("Controller state cannot be directly mutated; use 'update' method instead.")}update(e){const[t,r,i]=o.produceWithPatches(a(this,n,"f"),e);return s(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,r),{nextState:t,patches:r,inversePatches:i}}applyPatches(e){const t=(0,o.applyPatches)(a(this,n,"f"),e);s(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,e)}destroy(){this.messagingSystem.clearEventSubscriptions(`${this.name}:stateChange`)}},n=new WeakMap,r.getAnonymizedState=function(e,t){return i(e,t,"anonymous")},r.getPersistentState=function(e,t){return i(e,t,"persist")}}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs"}],[2416,{"./RestrictedMessenger.cjs":2417},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.ControllerMessenger=r.Messenger=void 0;const c=e("./RestrictedMessenger.cjs");class l{constructor(){n.set(this,new Map),s.set(this,new Map),a.set(this,new Map),o.set(this,new Map)}registerActionHandler(e,t){if(i(this,n,"f").has(e))throw new Error(`A handler for ${e} has already been registered`);i(this,n,"f").set(e,t)}unregisterActionHandler(e){i(this,n,"f").delete(e)}clearActions(){i(this,n,"f").clear()}call(e,...t){const r=i(this,n,"f").get(e);if(!r)throw new Error(`A handler for ${e} has not been registered`);return r(...t)}registerInitialEventPayload({eventType:e,getPayload:t}){i(this,a,"f").set(e,t)}publish(e,...t){const r=i(this,s,"f").get(e);if(r)for(const[e,n]of r.entries())try{if(n){const r=i(this,o,"f").get(e),s=n(...t);s!==r&&(i(this,o,"f").set(e,s),e(s,r))}else e(...t)}catch(e){setTimeout((()=>{throw e}))}}subscribe(e,t,r){let n=i(this,s,"f").get(e);if(n||(n=new Map,i(this,s,"f").set(e,n)),n.set(t,r),r){const n=i(this,a,"f").get(e);if(n){const e=r(...n());i(this,o,"f").set(t,e)}}}unsubscribe(e,t){const r=i(this,s,"f").get(e);if(!r||!r.has(t))throw new Error(`Subscription not found for event: ${e}`);r.get(t)&&i(this,o,"f").delete(t),r.delete(t)}clearEventSubscriptions(e){i(this,s,"f").delete(e)}clearSubscriptions(){i(this,s,"f").clear()}getRestricted({name:e,allowedActions:t,allowedEvents:r}){return new c.RestrictedMessenger({messenger:this,name:e,allowedActions:t,allowedEvents:r})}}r.Messenger=l,r.ControllerMessenger=l,n=new WeakMap,s=new WeakMap,a=new WeakMap,o=new WeakMap}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/Messenger.cjs"}],[2417,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},h=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.RestrictedControllerMessenger=r.RestrictedMessenger=void 0;class p{constructor({controllerMessenger:e,messenger:t,name:r,allowedActions:c,allowedEvents:l}){if(n.add(this),s.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),t&&e)throw new Error("Both messenger properties provided. Provide message using only 'messenger' option, 'controllerMessenger' is deprecated");if(!t&&!e)throw new Error("Messenger not provided");u(this,s,t??e,"f"),u(this,a,r,"f"),u(this,o,c,"f"),u(this,i,l,"f")}registerActionHandler(e,t){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed registering action handlers prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").registerActionHandler(e,t)}unregisterActionHandler(e){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed unregistering action handlers prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").unregisterActionHandler(e)}call(e,...t){if(!h(this,n,"m",l).call(this,e))throw new Error(`Action missing from allow list: ${e}`);return h(this,s,"f").call(e,...t)}registerInitialEventPayload({eventType:e,getPayload:t}){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").registerInitialEventPayload({eventType:e,getPayload:t})}publish(e,...t){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").publish(e,...t)}subscribe(e,t,r){if(!h(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);return r?h(this,s,"f").subscribe(e,t,r):h(this,s,"f").subscribe(e,t)}unsubscribe(e,t){if(!h(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);h(this,s,"f").unsubscribe(e,t)}clearEventSubscriptions(e){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed clearing events prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").clearEventSubscriptions(e)}}r.RestrictedMessenger=p,r.RestrictedControllerMessenger=p,s=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,n=new WeakSet,c=function(e){const t=h(this,i,"f");return h(this,n,"m",d).call(this,e)||null!==t&&t.includes(e)},l=function(e){const t=h(this,o,"f");return h(this,n,"m",d).call(this,e)||null!==t&&t.includes(e)},d=function(e){return e.startsWith(`${h(this,a,"f")}:`)}}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"}],[2418,{"./BaseControllerV1.cjs":2414,"./BaseControllerV2.cjs":2415,"./Messenger.cjs":2416,"./RestrictedMessenger.cjs":2417},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.RestrictedMessenger=r.RestrictedControllerMessenger=r.Messenger=r.ControllerMessenger=r.isBaseController=r.getPersistentState=r.getAnonymizedState=r.BaseController=r.isBaseControllerV1=r.BaseControllerV1=void 0;var n=e("./BaseControllerV1.cjs");Object.defineProperty(r,"BaseControllerV1",{enumerable:!0,get:function(){return n.BaseControllerV1}}),Object.defineProperty(r,"isBaseControllerV1",{enumerable:!0,get:function(){return n.isBaseControllerV1}});var s=e("./BaseControllerV2.cjs");Object.defineProperty(r,"BaseController",{enumerable:!0,get:function(){return s.BaseController}}),Object.defineProperty(r,"getAnonymizedState",{enumerable:!0,get:function(){return s.getAnonymizedState}}),Object.defineProperty(r,"getPersistentState",{enumerable:!0,get:function(){return s.getPersistentState}}),Object.defineProperty(r,"isBaseController",{enumerable:!0,get:function(){return s.isBaseController}});var a=e("./Messenger.cjs");Object.defineProperty(r,"ControllerMessenger",{enumerable:!0,get:function(){return a.ControllerMessenger}}),Object.defineProperty(r,"Messenger",{enumerable:!0,get:function(){return a.Messenger}});var o=e("./RestrictedMessenger.cjs");Object.defineProperty(r,"RestrictedControllerMessenger",{enumerable:!0,get:function(){return o.RestrictedControllerMessenger}}),Object.defineProperty(r,"RestrictedMessenger",{enumerable:!0,get:function(){return o.RestrictedMessenger}})}}},{package:"@metamask/ppom-validator>@metamask/base-controller",file:"node_modules/@metamask/ppom-validator/node_modules/@metamask/base-controller/dist/index.cjs"}],[2419,{"./constants.cjs":2420,"@metamask/base-controller":1474,"@metamask/controller-utils":1557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.PreferencesController=r.getDefaultPreferencesState=void 0;const o=e("@metamask/base-controller"),i=e("@metamask/controller-utils"),c=e("./constants.cjs"),l={featureFlags:{persist:!0,anonymous:!0},identities:{persist:!0,anonymous:!1},ipfsGateway:{persist:!0,anonymous:!1},isIpfsGatewayEnabled:{persist:!0,anonymous:!0},isMultiAccountBalancesEnabled:{persist:!0,anonymous:!0},lostIdentities:{persist:!0,anonymous:!1},openSeaEnabled:{persist:!0,anonymous:!0},securityAlertsEnabled:{persist:!0,anonymous:!0},selectedAddress:{persist:!0,anonymous:!1},showTestNetworks:{persist:!0,anonymous:!0},showIncomingTransactions:{persist:!0,anonymous:!0},useNftDetection:{persist:!0,anonymous:!0},useTokenDetection:{persist:!0,anonymous:!0},smartTransactionsOptInStatus:{persist:!0,anonymous:!1},useTransactionSimulations:{persist:!0,anonymous:!0},useMultiRpcMigration:{persist:!0,anonymous:!0},useSafeChainsListValidation:{persist:!0,anonymous:!0},tokenSortConfig:{persist:!0,anonymous:!0},privacyMode:{persist:!0,anonymous:!0}};function d(){return{featureFlags:{},identities:{},ipfsGateway:"https://ipfs.io/ipfs/",isIpfsGatewayEnabled:!0,isMultiAccountBalancesEnabled:!0,lostIdentities:{},openSeaEnabled:!1,securityAlertsEnabled:!1,selectedAddress:"",showIncomingTransactions:{[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MAINNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.GOERLI]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.BSC]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.BSC_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.OPTIMISM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.OPTIMISM_SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.POLYGON]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.POLYGON_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.AVALANCHE]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.AVALANCHE_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.FANTOM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.FANTOM_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_GOERLI]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_SEPOLIA]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.LINEA_MAINNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONBEAM]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONBEAM_TESTNET]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.MOONRIVER]:!0,[c.ETHERSCAN_SUPPORTED_CHAIN_IDS.GNOSIS]:!0},showTestNetworks:!1,useNftDetection:!1,useTokenDetection:!0,useMultiRpcMigration:!0,smartTransactionsOptInStatus:!0,useTransactionSimulations:!0,useSafeChainsListValidation:!0,tokenSortConfig:{key:"tokenFiatAmount",order:"dsc",sortCallback:"stringNumeric"},privacyMode:!1}}r.getDefaultPreferencesState=d;class u extends o.BaseController{constructor({messenger:e,state:t}){super({name:"PreferencesController",metadata:l,messenger:e,state:{...d(),...t}}),n.add(this),e.subscribe("KeyringController:stateChange",(e=>{const t=new Set;for(const r of e.keyrings)for(const e of r.accounts)t.add(e);t.size>0&&a(this,n,"m",s).call(this,Array.from(t))}))}addIdentities(e){const t=e.map((e=>(0,i.toChecksumHexAddress)(e)));this.update((e=>{const{identities:r}=e;for(const e of t){if(r[e])continue;const t=Object.keys(r).length;r[e]={name:`Account ${t+1}`,address:e,importTime:Date.now()}}}))}removeIdentity(e){e=(0,i.toChecksumHexAddress)(e);const{identities:t}=this.state;t[e]&&this.update((t=>{delete t.identities[e],e===t.selectedAddress&&(t.selectedAddress=Object.keys(t.identities)[0])}))}setAccountLabel(e,t){e=(0,i.toChecksumHexAddress)(e),this.update((r=>{const n=r.identities[e]||{};n.name=t,r.identities[e]=n}))}setFeatureFlag(e,t){this.update((r=>{r.featureFlags[e]=t}))}setSelectedAddress(e){this.update((t=>{t.selectedAddress=(0,i.toChecksumHexAddress)(e)}))}setIpfsGateway(e){this.update((t=>{t.ipfsGateway=e}))}setUseTokenDetection(e){this.update((t=>{t.useTokenDetection=e}))}setUseNftDetection(e){if(e&&!this.state.openSeaEnabled)throw new Error("useNftDetection cannot be enabled if openSeaEnabled is false");this.update((t=>{t.useNftDetection=e}))}setOpenSeaEnabled(e){this.update((t=>{t.openSeaEnabled=e,e||(t.useNftDetection=!1)}))}setSecurityAlertsEnabled(e){this.update((t=>{t.securityAlertsEnabled=e}))}setIsMultiAccountBalancesEnabled(e){this.update((t=>{t.isMultiAccountBalancesEnabled=e}))}setShowTestNetworks(e){this.update((t=>{t.showTestNetworks=e}))}setIsIpfsGatewayEnabled(e){this.update((t=>{t.isIpfsGatewayEnabled=e}))}setEnableNetworkIncomingTransactions(e,t){Object.values(c.ETHERSCAN_SUPPORTED_CHAIN_IDS).includes(e)&&this.update((r=>{r.showIncomingTransactions={...this.state.showIncomingTransactions,[e]:t}}))}setUseMultiRpcMigration(e){this.update((t=>{t.useMultiRpcMigration=e,e||(t.useMultiRpcMigration=!1)}))}setSmartTransactionsOptInStatus(e){this.update((t=>{t.smartTransactionsOptInStatus=e}))}setUseTransactionSimulations(e){this.update((t=>{t.useTransactionSimulations=e}))}setTokenSortConfig(e){this.update((t=>{t.tokenSortConfig=e}))}setUseSafeChainsListValidation(e){this.update((t=>{t.useSafeChainsListValidation=e}))}setPrivacyMode(e){this.update((t=>{t.privacyMode=e}))}}r.PreferencesController=u,n=new WeakSet,s=function(e){e=e.map((e=>(0,i.toChecksumHexAddress)(e))),this.update((t=>{const{identities:r}=t,n={};for(const[t,s]of Object.entries(r))e.includes(t)||(n[t]=s,delete r[t]);for(const[e,r]of Object.entries(n))t.lostIdentities[e]=r})),this.addIdentities(e),e.includes(this.state.selectedAddress)||this.update((t=>{t.selectedAddress=e[0]}))},r.default=u}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/PreferencesController.cjs"}],[242,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("@metamask/transaction-controller"),s=e("lodash");r.default={version:17,migrate(e){const t=(0,s.cloneDeep)(e);t.meta.version=17;try{const e=function(e){const t=e,{TransactionController:r}=t;if(r&&r.transactions){const{transactions:e}=t.TransactionController;t.TransactionController.transactions=e.map((e=>(!e.status===n.TransactionStatus.failed||e.retryCount>0&&e.retryCount<2&&(e.status=n.TransactionStatus.submitted,delete e.err),e)))}return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #17${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/017.js"}],[2420,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ETHERSCAN_SUPPORTED_CHAIN_IDS=void 0,r.ETHERSCAN_SUPPORTED_CHAIN_IDS={MAINNET:"0x1",GOERLI:"0x5",BSC:"0x38",BSC_TESTNET:"0x61",OPTIMISM:"0xa",OPTIMISM_SEPOLIA:"0xaa37dc",POLYGON:"0x89",POLYGON_TESTNET:"0x13881",AVALANCHE:"0xa86a",AVALANCHE_TESTNET:"0xa869",FANTOM:"0xfa",FANTOM_TESTNET:"0xfa2",SEPOLIA:"0xaa36a7",LINEA_GOERLI:"0xe704",LINEA_SEPOLIA:"0xe705",LINEA_MAINNET:"0xe708",MOONBEAM:"0x504",MOONBEAM_TESTNET:"0x507",MOONRIVER:"0x505",GNOSIS:"0x64"}}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/constants.cjs"}],[2421,{"./PreferencesController.cjs":2419,"./constants.cjs":2420},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.ETHERSCAN_SUPPORTED_CHAIN_IDS=void 0,s(e("./PreferencesController.cjs"),r);var a=e("./constants.cjs");Object.defineProperty(r,"ETHERSCAN_SUPPORTED_CHAIN_IDS",{enumerable:!0,get:function(){return a.ETHERSCAN_SUPPORTED_CHAIN_IDS}})}}},{package:"@metamask/preferences-controller",file:"node_modules/@metamask/preferences-controller/dist/index.cjs"}],[2422,{"../../sdk/index.cjs":2449,"./auth-snap-requests.cjs":2423,"@metamask/base-controller":1474},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u,h,p,m,f,g,b=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},C=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r};Object.defineProperty(r,"__esModule",{value:!0}),r.defaultState=void 0;const y=e("@metamask/base-controller"),w=e("./auth-snap-requests.cjs"),S=e("../../sdk/index.cjs");r.defaultState={isSignedIn:!1};const v={isSignedIn:{persist:!0,anonymous:!0},srpSessionData:{persist:!0,anonymous:!1}};class k extends y.BaseController{constructor({messenger:e,state:t,config:h,metametrics:m}){if(super({messenger:e,metadata:v,name:"AuthenticationController",state:{...r.defaultState,...t}}),n.add(this),s.set(this,void 0),a.set(this,void 0),o.set(this,{env:S.Env.PRD}),i.set(this,!1),c.set(this,{setupLockedStateSubscriptions:()=>{const{isUnlocked:e}=this.messagingSystem.call("KeyringController:getState");C(this,i,e,"f"),this.messagingSystem.subscribe("KeyringController:unlock",(()=>{C(this,i,!0,"f")})),this.messagingSystem.subscribe("KeyringController:lock",(()=>{C(this,i,!1,"f")}))}}),f.set(this,{}),!m)throw new Error("`metametrics` field is required");C(this,o,{...b(this,o,"f"),...h},"f"),C(this,s,m,"f"),C(this,a,new S.JwtBearerAuth({env:b(this,o,"f").env,platform:m.agent,type:S.AuthType.SRP},{storage:{getLoginResponse:b(this,n,"m",d).bind(this),setLoginResponse:b(this,n,"m",u).bind(this)},signing:{getIdentifier:b(this,n,"m",p).bind(this),signMessage:b(this,n,"m",g).bind(this)},metametrics:b(this,s,"f")}),"f"),b(this,c,"f").setupLockedStateSubscriptions(),b(this,n,"m",l).call(this)}async performSignIn(){b(this,n,"m",h).call(this,"performSignIn");const e=await b(this,n,"m",m).call(this),t=[];for(const[r]of e){const e=await b(this,a,"f").getAccessToken(r);t.push(e)}return t}performSignOut(){this.update((e=>{e.isSignedIn=!1,e.srpSessionData=undefined}))}async getBearerToken(e){return b(this,n,"m",h).call(this,"getBearerToken"),await b(this,a,"f").getAccessToken(e)}async getSessionProfile(e){return b(this,n,"m",h).call(this,"getSessionProfile"),await b(this,a,"f").getUserProfile(e)}async getUserProfileMetaMetrics(){return b(this,n,"m",h).call(this,"getUserProfileMetaMetrics"),await b(this,a,"f").getUserProfileMetaMetrics()}isSignedIn(){return this.state.isSignedIn}}s=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,c=new WeakMap,f=new WeakMap,n=new WeakSet,l=function(){this.messagingSystem.registerActionHandler("AuthenticationController:getBearerToken",this.getBearerToken.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:getSessionProfile",this.getSessionProfile.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:isSignedIn",this.isSignedIn.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:performSignIn",this.performSignIn.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:performSignOut",this.performSignOut.bind(this)),this.messagingSystem.registerActionHandler("AuthenticationController:getUserProfileMetaMetrics",this.getUserProfileMetaMetrics.bind(this))},d=async function(e){if(e)return this.state.srpSessionData?.[e]?this.state.srpSessionData[e]:null;const t=Object.values(this.state.srpSessionData||{})?.[0];return t||null},u=async function(e,t){const r=await b(this,s,"f").getMetaMetricsId();this.update((n=>{t&&(n.isSignedIn=!0,n.srpSessionData||(n.srpSessionData={}),n.srpSessionData[t]={...e,profile:{...e.profile,metaMetricsId:r}})}))},h=function(e){if(!b(this,i,"f"))throw new Error(`${e} - unable to proceed, wallet is locked`)},p=async function(e){b(this,n,"m",h).call(this,"#snapGetPublicKey");return await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapPublicKeyRequest)(e))},m=async function(){b(this,n,"m",h).call(this,"#snapGetAllPublicKeys");return await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapAllPublicKeysRequest)())},g=async function(e,t){if((0,S.assertMessageStartsWithMetamask)(e),b(this,f,"f")[e])return b(this,f,"f")[e];b(this,n,"m",h).call(this,"#snapSignMessage");const r=await this.messagingSystem.call("SnapController:handleRequest",(0,w.createSnapSignMessageRequest)(e,t));return b(this,f,"f")[e]=r,r},r.default=k}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/AuthenticationController.cjs"}],[2424,{"./AuthenticationController.cjs":2422,"./mocks/index.cjs":2425},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)},o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return s(t,e),t},i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.Mocks=r.Controller=void 0;const c=i(e("./AuthenticationController.cjs"));r.Controller=c.default;const l=c.default;r.default=l,a(e("./AuthenticationController.cjs"),r),r.Mocks=o(e("./mocks/index.cjs"))}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/index.cjs"}],[2425,{"./mockResponses.cjs":2426},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./mockResponses.cjs"),r)}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/index.cjs"}],[2426,{"../../../sdk/mocks/auth.cjs":2450},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getMockAuthAccessTokenResponse=r.MOCK_OATH_TOKEN_RESPONSE=r.getMockAuthLoginResponse=r.MOCK_LOGIN_RESPONSE=r.getMockAuthNonceResponse=r.MOCK_JWT=r.MOCK_NONCE=r.MOCK_NONCE_RESPONSE=void 0;const n=e("../../../sdk/mocks/auth.cjs");r.MOCK_NONCE_RESPONSE=n.MOCK_NONCE_RESPONSE,r.MOCK_NONCE=r.MOCK_NONCE_RESPONSE.nonce,r.MOCK_JWT=n.MOCK_JWT;r.getMockAuthNonceResponse=()=>({url:n.MOCK_NONCE_URL,requestMethod:"GET",response:(e,t,n)=>{const s=t?.split("?identifier=")[1],a=n?.(s??"");return{...r.MOCK_NONCE_RESPONSE,nonce:a??r.MOCK_NONCE_RESPONSE.nonce,identifier:r.MOCK_NONCE_RESPONSE.identifier}}}),r.MOCK_LOGIN_RESPONSE=n.MOCK_SRP_LOGIN_RESPONSE;r.getMockAuthLoginResponse=()=>({url:n.MOCK_SRP_LOGIN_URL,requestMethod:"POST",response:e=>{const t=e?.raw_message.split(":"),n=t?.[t.length-2];return{...r.MOCK_LOGIN_RESPONSE,token:n??r.MOCK_LOGIN_RESPONSE.token,profile:{...r.MOCK_LOGIN_RESPONSE.profile,profile_id:n??r.MOCK_LOGIN_RESPONSE.profile.profile_id,identifier_id:n??r.MOCK_LOGIN_RESPONSE.profile.identifier_id}}}}),r.MOCK_OATH_TOKEN_RESPONSE=n.MOCK_OIDC_TOKEN_RESPONSE;r.getMockAuthAccessTokenResponse=()=>({url:n.MOCK_OIDC_TOKEN_URL,requestMethod:"POST",response:e=>{const t=new URLSearchParams(e).get("assertion");return{...r.MOCK_OATH_TOKEN_RESPONSE,access_token:t??r.MOCK_OATH_TOKEN_RESPONSE.access_token}}})}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/controllers/authentication/mocks/mockResponses.cjs"}],[243,{"fast-json-patch":4482,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n,s=(n=e("fast-json-patch"))&&n.__esModule?n:{default:n},a=e("lodash");r.default={version:18,migrate(e){const t=(0,a.cloneDeep)(e);t.meta.version=18;try{const e=function(e){const t=e,{TransactionController:r}=t;if(r&&r.transactions){const{transactions:e}=t.TransactionController;t.TransactionController.transactions=e.map((e=>{if(!e.history||0===e.history.length){const t=function(e){const t={...e};return delete t.history,(0,a.cloneDeep)(t)}(e);return e.history=[t],e}const t=(r=e.history,r.map(((e,t)=>0===t?e:function(e,t,r){const n=s.default.compare(e,t);return n[0]&&(r&&(n[0].note=r),n[0].timestamp=Date.now()),n}(r[t-1],e)))).filter((e=>!Array.isArray(e)||e.length>0));var r;return e.history=t,e}))}return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #18${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/018.js"}],[244,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("@metamask/transaction-controller"),s=e("lodash");r.default={version:19,migrate(e){const t=(0,s.cloneDeep)(e);t.meta.version=19;try{const e=function(e){const t=e,{TransactionController:r}=t;if(r&&r.transactions){const{transactions:e}=t.TransactionController;t.TransactionController.transactions=e.map(((e,t,r)=>{if(e.status!==n.TransactionStatus.submitted)return e;const s=function(e){const t=e.map((e=>{const{nonce:t}=e.txParams;return parseInt(t||"0x0",16)}));return Math.max.apply(null,t)}(r.filter((e=>e.status===n.TransactionStatus.confirmed)).filter((t=>t.txParams.from===e.txParams.from)).filter((t=>t.metamaskNetworkId.from===e.metamaskNetworkId.from))),a=function(e,t){const r=e.map((e=>{const{nonce:t}=e.txParams;return parseInt(t,16)}));let n=t;for(;r.includes(n);)n+=1;return n}(r.filter((e=>e.status===n.TransactionStatus.submitted)).filter((t=>t.txParams.from===e.txParams.from)).filter((t=>t.metamaskNetworkId.from===e.metamaskNetworkId.from)),s),o=Math.max(a,s);return parseInt(e.txParams.nonce,16)>o+1&&(e.status=n.TransactionStatus.failed,e.err={message:"nonce too high",note:"migration 019 custom error"}),e}))}return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #19${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/019.js"}],[245,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:20,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=20;try{const e=function(e){const t=e;"metamask"in t&&!("firstTimeInfo"in t.metamask)&&(t.metamask.firstTimeInfo={version:"3.12.0",date:Date.now()});return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #20${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/020.js"}],[2450,{"../../shared/env.cjs":2460,"../authentication-jwt-bearer/services.cjs":2445},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MOCK_USER_PROFILE_METAMETRICS_RESPONSE=r.MOCK_OIDC_TOKEN_RESPONSE=r.MOCK_SRP_LOGIN_RESPONSE=r.MOCK_SIWE_LOGIN_RESPONSE=r.MOCK_NONCE_RESPONSE=r.MOCK_ACCESS_JWT=r.MOCK_JWT=r.MOCK_PROFILE_METAMETRICS_URL=r.MOCK_PAIR_IDENTIFIERS_URL=r.MOCK_SIWE_LOGIN_URL=r.MOCK_OIDC_TOKEN_URL=r.MOCK_SRP_LOGIN_URL=r.MOCK_NONCE_URL=void 0;const n=e("../../shared/env.cjs"),s=e("../authentication-jwt-bearer/services.cjs");r.MOCK_NONCE_URL=(0,s.NONCE_URL)(n.Env.PRD),r.MOCK_SRP_LOGIN_URL=(0,s.SRP_LOGIN_URL)(n.Env.PRD),r.MOCK_OIDC_TOKEN_URL=(0,s.OIDC_TOKEN_URL)(n.Env.PRD),r.MOCK_SIWE_LOGIN_URL=(0,s.SIWE_LOGIN_URL)(n.Env.PRD),r.MOCK_PAIR_IDENTIFIERS_URL=(0,s.PAIR_IDENTIFIERS)(n.Env.PRD),r.MOCK_PROFILE_METAMETRICS_URL=(0,s.PROFILE_METAMETRICS_URL)(n.Env.PRD),r.MOCK_JWT="eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6ImIwNzE2N2U2LWJjNWUtNDgyZC1hNjRhLWU1MjQ0MjY2MGU3NyJ9.eyJzdWIiOiI1MzE0ODc5YWM2NDU1OGI3OTQ5ZmI4NWIzMjg2ZjZjNjUwODAzYmFiMTY0Y2QyOWNmMmM3YzdmMjMzMWMwZTRlIiwiaWF0IjoxNzA2MTEzMDYyLCJleHAiOjE3NjkxODUwNjMsImlzcyI6ImF1dGgubWV0YW1hc2suaW8iLCJhdWQiOiJwb3J0Zm9saW8ubWV0YW1hc2suaW8ifQ.E5UL6oABNweS8t5a6IBTqTf7NLOJbrhJSmEcsr7kwLp4bGvcENJzACwnsHDkA6PlzfDV09ZhAGU_F3hlS0j-erbY0k0AFR-GAtyS7E9N02D8RgUDz5oDR65CKmzM8JilgFA8UvruJ6OJGogroaOSOqzRES_s8MjHpP47RJ9lXrUesajsbOudXbuksXWg5QmWip6LLvjwr8UUzcJzNQilyIhiEpo4WdzWM4R3VtTwr4rHnWEvtYnYCov1jmI2w3YQ48y0M-3Y9IOO0ov_vlITRrOnR7Y7fRUGLUFmU5msD8mNWRywjQFLHfJJ1yNP5aJ8TkuCK3sC6kcUH335IVvukQ",r.MOCK_ACCESS_JWT="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c",r.MOCK_NONCE_RESPONSE={nonce:"xGMm9SoihEKeAEfV",identifier:"0xd8641601Cb79a94FD872fE42d5b4a067A44a7e88",expires_in:300},r.MOCK_SIWE_LOGIN_RESPONSE={token:r.MOCK_JWT,expires_in:3600,profile:{profile_id:"fa2bbf82-bd9a-4e6b-aabc-9ca0d0319b6e",metametrics_id:"de742679-4960-4977-a415-4718b5f8e86c",identifier_id:"ec9a4e9906836497efad2fd4d4290b34d2c6a2c0d93eb174aa3cd88a133adbaf",identifier_type:"SIWE",encrypted_storage_key:"2c6a2c0d93eb174aa3cd88a133adbaf"}},r.MOCK_SRP_LOGIN_RESPONSE={token:r.MOCK_JWT,expires_in:3600,profile:{profile_id:"f88227bd-b615-41a3-b0be-467dd781a4ad",metametrics_id:"561ec651-a844-4b36-a451-04d6eac35740",identifier_id:"da9a9fc7b09edde9cc23cec9b7e11a71fb0ab4d2ddd8af8af905306f3e1456fb",identifier_type:"SRP",encrypted_storage_key:"d2ddd8af8af905306f3e1456fb"}},r.MOCK_OIDC_TOKEN_RESPONSE={access_token:r.MOCK_ACCESS_JWT,expires_in:3600},r.MOCK_USER_PROFILE_METAMETRICS_RESPONSE={profile_id:"f88227bd-b615-41a3-b0be-467dd781a4ad",created_at:"2025-10-01T12:00:00Z",lineage:[{metametrics_id:"561ec651-a844-4b36-a451-04d6eac35740",agent:n.Platform.MOBILE,created_at:"2025-10-01T12:00:00Z",updated_at:"2025-10-01T12:00:00Z",counter:1},{metametrics_id:"de742679-4960-4977-a415-4718b5f8e86c",agent:n.Platform.EXTENSION,created_at:"2025-10-01T12:00:00Z",updated_at:"2025-10-01T12:00:00Z",counter:2}]}}}},{package:"@metamask/profile-sync-controller",file:"node_modules/@metamask/profile-sync-controller/dist/sdk/mocks/auth.cjs"}],[246,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:21,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=21;try{const e=function(e){const t=e;return delete t.BlacklistController,delete t.RecentBlocks,t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #21${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/021.js"}],[247,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("@metamask/transaction-controller"),s=e("lodash");r.default={version:22,migrate(e){const t=(0,s.cloneDeep)(e);t.meta.version=22;try{const e=function(e){const t=e,{TransactionController:r}=t;if(r&&r.transactions){const{transactions:e}=t.TransactionController;t.TransactionController.transactions=e.map((e=>(e.status!==n.TransactionStatus.submitted||e.submittedTime||(e.submittedTime=(new Date).getTime()),e)))}return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #22${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/022.js"}],[248,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash"),s=e("@metamask/transaction-controller");r.default={version:23,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=23;try{const e=function(e){const t=e,{TransactionController:r}=t;if(r&&r.transactions){const{transactions:e}=t.TransactionController;if(e.length<=40)return t;const r=e.reverse();let n=!0;for(;r.length>40&&n;){const e=r.findIndex((e=>e.status===s.TransactionStatus.failed||e.status===s.TransactionStatus.rejected||e.status===s.TransactionStatus.confirmed||e.status===s.TransactionStatus.dropped));e<0?n=!1:r.splice(e,1)}t.TransactionController.transactions=r.reverse()}return t}(t.data);t.data=e}catch(e){console.warn(`MetaMask Migration #23${e.stack}`)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/023.js"}],[249,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash"),s=e("@metamask/transaction-controller");r.default={version:24,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=24;const r=function(e){const t=e;if(!t.TransactionController)return t;const{transactions:r}=t.TransactionController;return t.TransactionController.transactions=r.map(((e,t)=>(e.status===s.TransactionStatus.unapproved&&e.txParams&&e.txParams.from&&(e.txParams.from=e.txParams.from.toLowerCase()),e))),t}(t.data);return t.data=r,t}}}}},{package:"$root$",file:"app/scripts/migrations/024.js"}],[25,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getInstitutionalSnapControllerMessenger=function(e){return e.getRestricted({name:"InstitutionalSnapController",allowedActions:["AccountsController:getAccountByAddress","SnapController:handleRequest","TransactionController:updateCustodialTransaction"],allowedEvents:[]})}}}},{package:"$root$",file:"app/scripts/controller-init/messengers/accounts/institutional-snap-controller-messenger.ts"}],[250,{"../lib/util":225,"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash"),s=e("@metamask/transaction-controller"),a=e("../lib/util");r.default={version:25,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=25;const r=function(e){const t=e;if(t.TransactionController&&t.TransactionController.transactions){const{transactions:e}=t.TransactionController;t.TransactionController.transactions=e.map((e=>(e.status!==s.TransactionStatus.unapproved||(e.txParams=function(e){const t={from:e=>(0,a.addHexPrefix)(e).toLowerCase(),to:()=>(0,a.addHexPrefix)(e.to).toLowerCase(),nonce:e=>(0,a.addHexPrefix)(e),value:e=>(0,a.addHexPrefix)(e),data:e=>(0,a.addHexPrefix)(e),gas:e=>(0,a.addHexPrefix)(e),gasPrice:e=>(0,a.addHexPrefix)(e)},r={};return Object.keys(t).forEach((n=>{e[n]&&(r[n]=t[n](e[n]))})),r}(e.txParams)),e)))}return t}(t.data);return t.data=r,t}}}}},{package:"$root$",file:"app/scripts/migrations/025.js"}],[251,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:26,migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=26;try{const e=t.data;t.data=function(e){if(!e.KeyringController||!e.PreferencesController)return e;if(!e.KeyringController.walletNicknames)return e;return e.PreferencesController.identities=Object.keys(e.KeyringController.walletNicknames).reduce(((t,r)=>(t[r]={name:e.KeyringController.walletNicknames[r],address:r},t)),{}),delete e.KeyringController.walletNicknames,e}(e)}catch(e){return console.warn(`MetaMask Migration #26${e.stack}`),Promise.reject(e)}return Promise.resolve(t)}}}}},{package:"$root$",file:"app/scripts/migrations/026.js"}],[2511,{"@metamask/base-controller":1474,"@metamask/rpc-errors":2522,"@metamask/utils":2967},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.RateLimitController=void 0;const n=e("@metamask/base-controller"),s=e("@metamask/rpc-errors"),a=e("@metamask/utils"),o="RateLimitController",i={requests:{persist:!1,anonymous:!1}};class c extends n.BaseController{constructor({rateLimitTimeout:e=5e3,rateLimitCount:t=1,messenger:r,state:n,implementations:s}){const c={requests:(0,a.getKnownPropertyNames)(s).reduce(((e,t)=>({...e,[t]:{}})),{})};super({name:o,metadata:i,messenger:r,state:{...c,...n}}),this.implementations=s,this.rateLimitTimeout=e,this.rateLimitCount=t,this.messagingSystem.registerActionHandler(`${o}:call`,((e,t,...r)=>this.call(e,t,...r)))}async call(e,t,...r){if(this.isRateLimited(t,e))throw s.rpcErrors.limitExceeded({message:`"${t.toString()}" is currently rate-limited. Please try again later.`});this.recordRequest(t,e);const n=this.implementations[t].method;if(!n)throw new Error("Invalid api type");return n(...r)}isRateLimited(e,t){const r=this.implementations[e].rateLimitCount??this.rateLimitCount;return this.state.requests[e][t]>=r}recordRequest(e,t){const r=this.implementations[e].rateLimitTimeout??this.rateLimitTimeout,n=this.state.requests[e][t]??0;this.update((s=>{0===n&&setTimeout((()=>this.resetRequestCount(e,t)),r),Object.assign(s,{requests:{...s.requests,[e]:{[t]:n+1}}})}))}resetRequestCount(e,t){this.update((r=>{Object.assign(r,{requests:{...r.requests,[e]:{[t]:0}}})}))}}r.RateLimitController=c}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/RateLimitController.cjs"}],[2512,{"./RateLimitController.cjs":2511},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.RateLimitController=void 0;var n=e("./RateLimitController.cjs");Object.defineProperty(r,"RateLimitController",{enumerable:!0,get:function(){return n.RateLimitController}})}}},{package:"@metamask/rate-limit-controller",file:"node_modules/@metamask/rate-limit-controller/dist/index.cjs"}],[2513,{"../constants.cjs":2514,"@metamask/controller-utils":1557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},l=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.ClientConfigApiService=void 0;const d=e("@metamask/controller-utils"),u=e("../constants.cjs");r.ClientConfigApiService=class{constructor({fetch:e,retries:t=d.DEFAULT_MAX_RETRIES,maximumConsecutiveFailures:r=d.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:u=d.DEFAULT_CIRCUIT_BREAK_DURATION,onBreak:h,onDegraded:p,config:m}){n.set(this,void 0),s.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),c(this,n,e,"f"),c(this,a,m.client,"f"),c(this,o,m.distribution,"f"),c(this,i,m.environment,"f"),c(this,s,(0,d.createServicePolicy)({maxRetries:t,maxConsecutiveFailures:r,circuitBreakDuration:u}),"f"),h&&l(this,s,"f").onBreak(h),p&&l(this,s,"f").onDegraded(p)}onBreak(...e){return l(this,s,"f").onBreak(...e)}onDegraded(...e){return l(this,s,"f").onDegraded(...e)}async fetchRemoteFeatureFlags(){const e=`${u.BASE_URL}/flags?client=${l(this,a,"f")}&distribution=${l(this,o,"f")}&environment=${l(this,i,"f")}`,t=await l(this,s,"f").execute((()=>l(this,n,"f").call(this,e,{cache:"no-cache"})));if(!t.ok)throw new Error("Failed to fetch remote feature flags");const r=await t.json();if(!Array.isArray(r))throw new Error("Feature flags api did not return an array");return{remoteFeatureFlags:this.flattenFeatureFlags(r),cacheTimestamp:Date.now()}}flattenFeatureFlags(e){return e.reduce(((e,t)=>({...e,...t})),{})}},n=new WeakMap,s=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/client-config-api-service/client-config-api-service.cjs"}],[2514,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.BASE_URL=void 0,r.BASE_URL="https://client-config.api.cx.metamask.io/v1"}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/constants.cjs"}],[2515,{"./client-config-api-service/client-config-api-service.cjs":2513,"./remote-feature-flag-controller-types.cjs":2516,"./remote-feature-flag-controller.cjs":2517,"./utils/user-segmentation-utils.cjs":2518},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.generateDeterministicRandomNumber=r.ClientConfigApiService=r.EnvironmentType=r.DistributionType=r.ClientType=r.RemoteFeatureFlagController=void 0;var n=e("./remote-feature-flag-controller.cjs");Object.defineProperty(r,"RemoteFeatureFlagController",{enumerable:!0,get:function(){return n.RemoteFeatureFlagController}});var s=e("./remote-feature-flag-controller-types.cjs");Object.defineProperty(r,"ClientType",{enumerable:!0,get:function(){return s.ClientType}}),Object.defineProperty(r,"DistributionType",{enumerable:!0,get:function(){return s.DistributionType}}),Object.defineProperty(r,"EnvironmentType",{enumerable:!0,get:function(){return s.EnvironmentType}});var a=e("./client-config-api-service/client-config-api-service.cjs");Object.defineProperty(r,"ClientConfigApiService",{enumerable:!0,get:function(){return a.ClientConfigApiService}});var o=e("./utils/user-segmentation-utils.cjs");Object.defineProperty(r,"generateDeterministicRandomNumber",{enumerable:!0,get:function(){return o.generateDeterministicRandomNumber}})}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/index.cjs"}],[2516,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a;Object.defineProperty(r,"__esModule",{value:!0}),r.EnvironmentType=r.DistributionType=r.ClientType=void 0,function(e){e.Extension="extension",e.Mobile="mobile"}(n||(r.ClientType=n={})),function(e){e.Main="main",e.Flask="flask",e.Beta="beta"}(s||(r.DistributionType=s={})),function(e){e.Production="prod",e.ReleaseCandidate="rc",e.Development="dev"}(a||(r.EnvironmentType=a={}))}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller-types.cjs"}],[2517,{"./utils/user-segmentation-utils.cjs":2518,"@metamask/base-controller":1474},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u,h=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},p=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.RemoteFeatureFlagController=r.getDefaultRemoteFeatureFlagControllerState=r.DEFAULT_CACHE_DURATION=r.controllerName=void 0;const m=e("@metamask/base-controller"),f=e("./utils/user-segmentation-utils.cjs");r.controllerName="RemoteFeatureFlagController",r.DEFAULT_CACHE_DURATION=864e5;const g={remoteFeatureFlags:{persist:!0,anonymous:!0},cacheTimestamp:{persist:!0,anonymous:!0}};function b(){return{remoteFeatureFlags:{},cacheTimestamp:0}}r.getDefaultRemoteFeatureFlagControllerState=b;class C extends m.BaseController{constructor({messenger:e,state:t,clientConfigApiService:l,fetchInterval:d=r.DEFAULT_CACHE_DURATION,disabled:u=!1,getMetaMetricsId:p}){super({name:r.controllerName,metadata:g,messenger:e,state:{remoteFeatureFlags:{},cacheTimestamp:0,...t}}),n.add(this),s.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),c.set(this,void 0),h(this,s,d,"f"),h(this,a,u,"f"),h(this,o,l,"f"),h(this,c,p,"f")}async updateRemoteFeatureFlags(){if(p(this,a,"f")||!p(this,n,"m",l).call(this))return;let e;if(p(this,i,"f"))await p(this,i,"f");else{try{h(this,i,p(this,o,"f").fetchRemoteFeatureFlags(),"f"),e=await p(this,i,"f")}finally{h(this,i,undefined,"f")}await p(this,n,"m",d).call(this,e.remoteFeatureFlags)}}enable(){h(this,a,!1,"f")}disable(){h(this,a,!0,"f")}}r.RemoteFeatureFlagController=C,s=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,c=new WeakMap,n=new WeakSet,l=function(){return Date.now()-this.state.cacheTimestamp>p(this,s,"f")},d=async function(e){const t=await p(this,n,"m",u).call(this,e);this.update((()=>({remoteFeatureFlags:t,cacheTimestamp:Date.now()})))},u=async function(e){const t={},r=p(this,c,"f").call(this),n=(0,f.generateDeterministicRandomNumber)(r);for(const[r,s]of Object.entries(e)){let e=s;if(Array.isArray(s)&&n){const t=s.find((e=>!!(0,f.isFeatureFlagWithScopeValue)(e)&&n<=e.scope.value));t&&(e={name:t.name,value:t.value})}t[r]=e}return t}}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/remote-feature-flag-controller.cjs"}],[2518,{uuid:5734},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isFeatureFlagWithScopeValue=r.generateDeterministicRandomNumber=void 0;const n=e("uuid");function s(e){return BigInt(`0x${e.replace(/-/gu,"")}`)}const a=s("00000000-0000-4000-8000-000000000000"),o=s("ffffffff-ffff-4fff-bfff-ffffffffffff")-a;r.generateDeterministicRandomNumber=function(e){if(!e)throw new Error("MetaMetrics ID cannot be empty");let t,r;if((0,n.validate)(e)){if(4!==(0,n.version)(e))throw new Error(`Invalid UUID version. Expected v4, got v${(0,n.version)(e)}`);t=s(e)-a,r=o}else{if(!e.startsWith("0x"))throw new Error("Hex ID must start with 0x prefix");const n=e.slice(2),s=64;if(n.length!==s)throw new Error(`Invalid hex ID length. Expected ${s} characters, got ${n.length}`);if(!/^[0-9a-f]+$/iu.test(n))throw new Error("Hex ID contains invalid characters");t=BigInt(`0x${n}`),r=BigInt(`0x${"f".repeat(n.length)}`)}return Number(t*BigInt(1e6)/r)/1e6};r.isFeatureFlagWithScopeValue=e=>"object"==typeof e&&null!==e&&"scope"in e}}},{package:"@metamask/remote-feature-flag-controller",file:"node_modules/@metamask/remote-feature-flag-controller/dist/utils/user-segmentation-utils.cjs"}],[252,{"@metamask/transaction-controller":2918,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash"),s=e("@metamask/transaction-controller");r.default={version:27,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=27;const r=function(e){const t=e;if(t.TransactionController&&t.TransactionController.transactions){const{transactions:e}=t.TransactionController;t.TransactionController.transactions=e.filter((e=>e.status!==s.TransactionStatus.rejected))}return t}(t.data);return t.data=r,t}}}}},{package:"$root$",file:"app/scripts/migrations/027.js"}],[253,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:28,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=28;const r=function(e){const t=e;if(t.PreferencesController&&t.PreferencesController.tokens&&t.PreferencesController.identities){const{identities:e,tokens:r}=t.PreferencesController;t.PreferencesController.accountTokens={},Object.keys(e).forEach((e=>{t.PreferencesController.accountTokens[e]={mainnet:r}})),t.PreferencesController.tokens=[]}return t}(t.data);return t.data=r,t}}}}},{package:"$root$",file:"app/scripts/migrations/028.js"}],[254,{"./fail-tx":426,"@metamask/transaction-controller":2918},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n,s=e("@metamask/transaction-controller"),a=(n=e("./fail-tx"))&&n.__esModule?n:{default:n};r.default={version:29,migrate:(0,a.default)(29,"Stuck in approved state for too long.",(e=>{const t=e.status===s.TransactionStatus.approved,r=e.submittedTime,n=Date.now();return t&&n-r>432e5}))}}}},{package:"$root$",file:"app/scripts/migrations/029.js"}],[2544,{"@metamask/base-controller":1474,"@metamask/swappable-obj-proxy":2877},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},h=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.SelectedNetworkController=r.SelectedNetworkControllerEventTypes=r.SelectedNetworkControllerActionTypes=r.METAMASK_DOMAIN=r.controllerName=void 0;const p=e("@metamask/base-controller"),m=e("@metamask/swappable-obj-proxy");r.controllerName="SelectedNetworkController";const f={domains:{persist:!0,anonymous:!1}};r.METAMASK_DOMAIN="metamask",r.SelectedNetworkControllerActionTypes={getState:`${r.controllerName}:getState`,getNetworkClientIdForDomain:`${r.controllerName}:getNetworkClientIdForDomain`,setNetworkClientIdForDomain:`${r.controllerName}:setNetworkClientIdForDomain`},r.SelectedNetworkControllerEventTypes={stateChange:`${r.controllerName}:stateChange`};class g extends p.BaseController{constructor({messenger:e,state:t={domains:{}},useRequestQueuePreference:i,onPreferencesStateChange:l,domainProxyMap:p}){super({name:r.controllerName,metadata:f,messenger:e,state:t}),n.add(this),s.set(this,void 0),a.set(this,void 0),u(this,a,i,"f"),u(this,s,p,"f"),h(this,n,"m",o).call(this),this.messagingSystem.call("PermissionController:getSubjectNames").filter((e=>this.state.domains[e]===undefined)).forEach((e=>this.setNetworkClientIdForDomain(e,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId))),this.messagingSystem.subscribe("PermissionController:stateChange",((e,t)=>{t.forEach((({op:e,path:t})=>{if("subjects"===t[0]&&t[1]!==undefined&&"string"==typeof t[1]){const r=t[1];"add"===e&&this.state.domains[r]===undefined?this.setNetworkClientIdForDomain(r,this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId):"remove"===e&&this.state.domains[r]!==undefined&&h(this,n,"m",c).call(this,r)}}))})),this.messagingSystem.subscribe("NetworkController:stateChange",(({selectedNetworkClientId:e,networkConfigurationsByChainId:t},r)=>{const n=r.find((({op:e,path:t})=>("replace"===e||"remove"===e)&&"networkConfigurationsByChainId"===t[0]));if(n){const r=Object.values(t).reduce(((e,t)=>(t.rpcEndpoints.forEach((({networkClientId:r})=>e[r]=t.chainId)),e)),{});Object.entries(this.state.domains).forEach((([s,a])=>{const o=r[a];if("remove"!==n.op||o){if("replace"===n.op){const e=n.path[1];if(!o||o===e){const r=t[e],{networkClientId:n}=r.rpcEndpoints[r.defaultRpcEndpointIndex];a!==n&&this.setNetworkClientIdForDomain(s,n)}}}else this.setNetworkClientIdForDomain(s,e)}))}})),l((({useRequestQueue:e})=>{h(this,a,"f")!==e&&(e?h(this,n,"m",d).call(this):Object.keys(this.state.domains).forEach((e=>{h(this,n,"m",c).call(this,e)})),u(this,a,e,"f"))}))}setNetworkClientIdForDomain(e,t){if(h(this,a,"f")){if(e===r.METAMASK_DOMAIN)throw new Error(`NetworkClientId for domain "${r.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);if(!h(this,n,"m",l).call(this,e))throw new Error("NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions");h(this,n,"m",i).call(this,e,t)}}getNetworkClientIdForDomain(e){const{selectedNetworkClientId:t}=this.messagingSystem.call("NetworkController:getState");return h(this,a,"f")?this.state.domains[e]??t:t}getProviderAndBlockTracker(e){if(e===r.METAMASK_DOMAIN){const e=this.messagingSystem.call("NetworkController:getSelectedNetworkClient");if(e===undefined)throw new Error("Selected network not initialized");return e}let t=h(this,s,"f").get(e);if(t===undefined){let r;if(h(this,a,"f")&&h(this,n,"m",l).call(this,e)){const t=this.getNetworkClientIdForDomain(e);r=this.messagingSystem.call("NetworkController:getNetworkClientById",t)}else if(r=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),r===undefined)throw new Error("Selected network not initialized");t={provider:(0,m.createEventEmitterProxy)(r.provider),blockTracker:(0,m.createEventEmitterProxy)(r.blockTracker,{eventFilter:"skipInternal"})},h(this,s,"f").set(e,t)}return t}}r.SelectedNetworkController=g,s=new WeakMap,a=new WeakMap,n=new WeakSet,o=function(){this.messagingSystem.registerActionHandler(r.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,this.getNetworkClientIdForDomain.bind(this)),this.messagingSystem.registerActionHandler(r.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain,this.setNetworkClientIdForDomain.bind(this))},i=function(e,t){const r=this.messagingSystem.call("NetworkController:getNetworkClientById",t);this.update((r=>{r.domains[e]=t}));const n=this.getProviderAndBlockTracker(e);n.provider.setTarget(r.provider),n.blockTracker.setTarget(r.blockTracker)},c=function(e){const t=this.messagingSystem.call("NetworkController:getSelectedNetworkClient"),r=h(this,s,"f").get(e);r&&t?(r.provider.setTarget(t.provider),r.blockTracker.setTarget(t.blockTracker)):r&&h(this,s,"f").delete(e),this.update((t=>{delete t.domains[e]}))},l=function(e){return this.messagingSystem.call("PermissionController:hasPermissions",e)},d=function(){h(this,s,"f").forEach(((e,t)=>{const{selectedNetworkClientId:r}=this.messagingSystem.call("NetworkController:getState");h(this,n,"m",l).call(this,t)&&h(this,n,"m",i).call(this,t,r)}))}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkController.cjs"}],[2545,{"./SelectedNetworkController.cjs":2544},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createSelectedNetworkMiddleware=void 0;const n=e("./SelectedNetworkController.cjs");r.createSelectedNetworkMiddleware=e=>(t,r,s)=>{if(!t.origin)throw new Error("Request object is lacking an 'origin'");var a;return t.networkClientId=(a=t.origin,e.call(n.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain,a)),s()}}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/SelectedNetworkMiddleware.cjs"}],[2546,{"./SelectedNetworkController.cjs":2544,"./SelectedNetworkMiddleware.cjs":2545},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createSelectedNetworkMiddleware=r.METAMASK_DOMAIN=r.SelectedNetworkController=r.SelectedNetworkControllerEventTypes=r.SelectedNetworkControllerActionTypes=void 0;var n=e("./SelectedNetworkController.cjs");Object.defineProperty(r,"SelectedNetworkControllerActionTypes",{enumerable:!0,get:function(){return n.SelectedNetworkControllerActionTypes}}),Object.defineProperty(r,"SelectedNetworkControllerEventTypes",{enumerable:!0,get:function(){return n.SelectedNetworkControllerEventTypes}}),Object.defineProperty(r,"SelectedNetworkController",{enumerable:!0,get:function(){return n.SelectedNetworkController}}),Object.defineProperty(r,"METAMASK_DOMAIN",{enumerable:!0,get:function(){return n.METAMASK_DOMAIN}});var s=e("./SelectedNetworkMiddleware.cjs");Object.defineProperty(r,"createSelectedNetworkMiddleware",{enumerable:!0,get:function(){return s.createSelectedNetworkMiddleware}})}}},{package:"@metamask/selected-network-controller",file:"node_modules/@metamask/selected-network-controller/dist/index.cjs"}],[255,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:30,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=30;const r=function(e){const t=e;if(e.PreferencesController){const{frequentRpcListDetail:e}=t.PreferencesController;e&&(e.forEach(((t,r)=>{Boolean(t.chainId)&&Number.isNaN(parseInt(t.chainId))&&delete e[r].chainId})),t.PreferencesController.frequentRpcListDetail=e)}e.NetworkController&&(t.NetworkController.network&&Number.isNaN(parseInt(t.NetworkController.network))&&delete t.NetworkController.network,t.NetworkController.provider&&t.NetworkController.provider.chainId&&Number.isNaN(parseInt(t.NetworkController.provider.chainId))&&delete t.NetworkController.provider.chainId);return t}(t.data);return t.data=r,t}}}}},{package:"$root$",file:"app/scripts/migrations/030.js"}],[256,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:31,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=31;const r=function(e){const{KeyringController:t,PreferencesController:r}=e;if(t&&r){const{vault:e}=t;r.completedOnboarding=Boolean(e)}return e}(t.data);return t.data=r,t}}}}},{package:"$root$",file:"app/scripts/migrations/031.js"}],[257,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:32,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=32;const r=t.data;return t.data=function(e){const{PreferencesController:t}=e;if(t){const{betaUI:e}=t.featureFlags||{};t.completedUiMigration=e}return e}(r),t}}}}},{package:"$root$",file:"app/scripts/migrations/032.js"}],[258,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:33,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=33;const r=function(e){const t=e;e.NoticeController&&delete t.NoticeController;return t}(t.data);return t.data=r,t}}}}},{package:"$root$",file:"app/scripts/migrations/033.js"}],[259,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:34,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=34;const r=t.data;return t.data=function(e){const{PreferencesController:t}=e;if(t){const e=t.featureFlags||{};e.privacyMode||void 0!==t.migratedPrivacyMode||(t.migratedPrivacyMode=!0,e.privacyMode=!0)}return e}(r),t}}}}},{package:"$root$",file:"app/scripts/migrations/034.js"}],[2597,{"./constants":2598,"./types":2600,"./utils":2601,"@ethersproject/bytes":572,"@metamask/controller-utils":1557,"@metamask/eth-query":1773,"@metamask/polling-controller":2605,"@metamask/transaction-controller":2918,"bignumber.js":2610,"lodash/cloneDeep":4881},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u,h,p,m,f,g,b,C,y,w,S,v,k,T,P,M,E,A,I,N=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},_=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},O=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.getDefaultSmartTransactionsControllerState=r.DEFAULT_INTERVAL=void 0;const R=e("@ethersproject/bytes"),x=e("@metamask/controller-utils"),j=O(e("@metamask/eth-query")),B=e("@metamask/polling-controller"),D=e("@metamask/transaction-controller"),F=e("bignumber.js"),$=O(e("lodash/cloneDeep")),L=e("./constants"),U=e("./types"),K=e("./utils");r.DEFAULT_INTERVAL=5e3;const q="`ethQuery` is not defined on SmartTransactionsController",H="SmartTransactionsController",V={smartTransactionsState:{persist:!0,anonymous:!0}};function W(){return{smartTransactionsState:{smartTransactions:{},userOptIn:null,userOptInV2:null,fees:{approvalTxFees:null,tradeTxFees:null},liveness:!0,livenessByChainId:{[x.ChainId.mainnet]:!0,[x.ChainId.sepolia]:!0},feesByChainId:{[x.ChainId.mainnet]:{approvalTxFees:null,tradeTxFees:null},[x.ChainId.sepolia]:{approvalTxFees:null,tradeTxFees:null}}}}}r.getDefaultSmartTransactionsControllerState=W;class G extends((0,B.StaticIntervalPollingController)()){constructor({interval:e=r.DEFAULT_INTERVAL,clientId:t,chainId:b=x.ChainId.mainnet,supportedChainIds:C=[x.ChainId.mainnet,x.ChainId.sepolia],getNonceLock:y,confirmExternalTransaction:w,trackMetaMetricsEvent:S,state:v={},messenger:k,getTransactions:T,getMetaMetricsProps:P,getFeatureFlags:M,updateTransaction:E,trace:A}){super({name:H,metadata:V,messenger:k,state:Object.assign(Object.assign({},W()),v)}),n.add(this),s.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),c.set(this,void 0),l.set(this,void 0),d.set(this,void 0),u.set(this,void 0),h.set(this,void 0),p.set(this,void 0),m.set(this,void 0),f.set(this,void 0),g.set(this,void 0),N(this,s,e,"f"),N(this,a,t,"f"),N(this,o,b,"f"),N(this,i,C,"f"),this.setIntervalLength(e),N(this,c,y,"f"),N(this,l,undefined,"f"),N(this,d,w,"f"),N(this,u,T,"f"),N(this,h,S,"f"),N(this,p,P,"f"),N(this,m,M,"f"),N(this,f,E,"f"),N(this,g,null!=A?A:(e,t)=>null==t?void 0:t(),"f"),this.initializeSmartTransactionsForChainId(),this.messagingSystem.subscribe("NetworkController:stateChange",(({selectedNetworkClientId:e})=>{const{configuration:{chainId:t},provider:r}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);N(this,o,t,"f"),N(this,l,new j.default(r),"f"),this.initializeSmartTransactionsForChainId(),this.checkPoll(this.state)})),this.messagingSystem.subscribe(`${H}:stateChange`,(e=>this.checkPoll(e)))}async _executePoll({chainIds:e}){const t=(null!=e?e:[]).filter((e=>_(this,i,"f").includes(e)));return 0===t.length?Promise.resolve():this.updateSmartTransactions({chainIds:t})}checkPoll({smartTransactionsState:{smartTransactions:e}}){const t=Object.values(e).flat(),r=null==t?void 0:t.filter(K.isSmartTransactionPending);!this.timeoutHandle&&(null==r?void 0:r.length)>0?this.poll():this.timeoutHandle&&0===(null==r?void 0:r.length)&&this.stop()}initializeSmartTransactionsForChainId(){_(this,i,"f").includes(_(this,o,"f"))&&this.update((e=>{var t;e.smartTransactionsState.smartTransactions[_(this,o,"f")]=null!==(t=e.smartTransactionsState.smartTransactions[_(this,o,"f")])&&void 0!==t?t:[]}))}async poll(e){e&&N(this,s,e,"f"),this.timeoutHandle&&clearInterval(this.timeoutHandle),_(this,i,"f").includes(_(this,o,"f"))&&(this.timeoutHandle=setInterval((()=>{(0,x.safelyExecute)((async()=>this.updateSmartTransactions()))}),_(this,s,"f")),await(0,x.safelyExecute)((async()=>this.updateSmartTransactions())))}async stop(){this.timeoutHandle&&clearInterval(this.timeoutHandle),this.timeoutHandle=undefined}setOptInState(e){this.update((t=>{t.smartTransactionsState.userOptInV2=e}))}trackStxStatusChange(e,t){let r=(0,$.default)(e);r=Object.assign(Object.assign({},(0,$.default)(t)),r),r.status!==(null==t?void 0:t.status)&&_(this,h,"f").call(this,{event:L.MetaMetricsEventName.StxStatusUpdated,category:L.MetaMetricsEventCategory.Transactions,properties:(0,K.getSmartTransactionMetricsProperties)(r),sensitiveProperties:(0,K.getSmartTransactionMetricsSensitiveProperties)(r)})}isNewSmartTransaction(e,t){const{smartTransactionsState:{smartTransactions:r}}=this.state,n=r[null!=t?t:_(this,o,"f")],s=null==n?void 0:n.findIndex((t=>t.uuid===e));return-1===s||s===undefined}updateSmartTransaction(e,{networkClientId:t}={}){let r=_(this,l,"f"),s=_(this,o,"f");if(t){const{configuration:e,provider:n}=this.messagingSystem.call("NetworkController:getNetworkClientById",t);s=e.chainId,r=new j.default(n)}_(this,n,"m",w).call(this,e,{chainId:s,ethQuery:r})}async updateSmartTransactions({chainIds:e}={chainIds:_(this,n,"m",P).call(this)}){const{smartTransactionsState:{smartTransactions:t}}=this.state;for(const[r,s]of Object.entries(t)){if(e&&!e.includes(r))continue;const t=s.filter(K.isSmartTransactionPending).map((e=>{const t=_(this,n,"m",M).call(this,{chainId:r});return{uuid:e.uuid,networkClientId:t,chainId:e.chainId}}));t.length>0&&await this.fetchSmartTransactionsStatus(t)}}async fetchSmartTransactionsStatus(e){const{chainId:t}=e[0],r=e.map((e=>e.uuid)),s=new URLSearchParams({uuids:r.join(",")}),a=_(this,n,"m",E).call(this,{networkClientId:e[0].networkClientId}),o=`${(0,K.getAPIRequestURL)(U.APIType.BATCH_STATUS,t)}?${s.toString()}`,i=await _(this,n,"m",b).call(this,o);for(const[r,s]of Object.entries(i)){const o=e.find((e=>e.uuid===r));if(!o){console.error(`No matching transaction found for uuid: ${r}`);continue}const i={statusMetadata:s,status:(0,K.calculateStatus)(s),cancellable:(0,K.isSmartTransactionCancellable)(s),uuid:r,networkClientId:o.networkClientId};await _(this,n,"m",w).call(this,i,{chainId:t,ethQuery:a})}return i}clearFees(){const e={approvalTxFees:null,tradeTxFees:null};return this.update((t=>{t.smartTransactionsState.fees=e})),e}async getFees(e,t,{networkClientId:r}={}){const s=null!=r?r:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,a=_(this,n,"m",T).call(this,{networkClientId:s}),i=[];let c;if(t){const r=await _(this,n,"m",k).call(this,t,s);i.push(r),c=Object.assign(Object.assign({},e),{nonce:(0,K.incrementNonceInHex)(r.nonce)})}else c=e.nonce?e:await _(this,n,"m",k).call(this,e,s);i.push(c);const l=await _(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.GetFees},(async()=>await _(this,n,"m",b).call(this,(0,K.getAPIRequestURL)(U.APIType.GET_FEES,a),{method:"POST",body:JSON.stringify({txs:i})})));let d,u;return t?(d=null==l?void 0:l.txs[0],u=null==l?void 0:l.txs[1]):(d=null,u=null==l?void 0:l.txs[0]),this.update((e=>{a===_(this,o,"f")&&(e.smartTransactionsState.fees={approvalTxFees:d,tradeTxFees:u}),e.smartTransactionsState.feesByChainId[a]={approvalTxFees:d,tradeTxFees:u}})),{approvalTxFees:d,tradeTxFees:u}}async submitSignedTransactions({transactionMeta:e,txParams:t,signedTransactions:r,signedCanceledTransactions:s=[],networkClientId:a}){var o,i;const l=null!=a?a:this.messagingSystem.call("NetworkController:getState").selectedNetworkClientId,d=_(this,n,"m",T).call(this,{networkClientId:l}),u=_(this,n,"m",E).call(this,{networkClientId:l}),h=await _(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.SubmitTransactions},(async()=>await _(this,n,"m",b).call(this,(0,K.getAPIRequestURL)(U.APIType.SUBMIT_TRANSACTIONS,d),{method:"POST",body:JSON.stringify({rawTxs:r,rawCancelTxs:s})}))),p=Date.now();let m;try{if(null==t?void 0:t.from){const e=await(0,x.query)(u,"getBalance",[t.from]);m=new F.BigNumber(e).toString(16)}}catch(e){console.error("ethQuery.getBalance error:",e)}let f,C,y={};if(t&&!t.nonce)try{C=await _(this,c,"f").call(this,t.from,l),f=(0,R.hexlify)(C.nextNonce),y=C.nonceDetails,null!==(o=t.nonce)&&void 0!==o||(t.nonce=f)}catch(e){throw console.error("Failed to acquire nonce lock:",e),e}const S=r.map((e=>(0,K.getTxHash)(e))),v=Object.assign(Object.assign({},h),{txHash:S[S.length-1],txHashes:S});try{await _(this,n,"m",w).call(this,{chainId:d,nonceDetails:y,preTxBalance:m,status:U.SmartTransactionStatuses.PENDING,time:p,txParams:t,uuid:v.uuid,txHash:v.txHash,cancellable:!0,type:null!==(i=null==e?void 0:e.type)&&void 0!==i?i:"swap",transactionId:null==e?void 0:e.id,networkClientId:l,txHashes:S},{chainId:d,ethQuery:u})}catch(e){throw console.error("Failed to create a smart transaction:",e),e}finally{C&&C.releaseLock()}return v}async cancelSmartTransaction(e,{networkClientId:t}={}){const r=_(this,n,"m",T).call(this,{networkClientId:t});await _(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.CancelTransaction},(async()=>await _(this,n,"m",b).call(this,(0,K.getAPIRequestURL)(U.APIType.CANCEL,r),{method:"POST",body:JSON.stringify({uuid:e})})))}async fetchLiveness({networkClientId:e}={}){const t=_(this,n,"m",T).call(this,{networkClientId:e});let r=!1;try{const e=await _(this,g,"f").call(this,{name:L.SmartTransactionsTraceName.FetchLiveness},(async()=>await _(this,n,"m",b).call(this,(0,K.getAPIRequestURL)(U.APIType.LIVENESS,t))));r=Boolean(e.smartTransactions)}catch(e){console.log('"fetchLiveness" API call failed')}return this.update((e=>{t===_(this,o,"f")&&(e.smartTransactionsState.liveness=r),e.smartTransactionsState.livenessByChainId[t]=r})),r}async setStatusRefreshInterval(e){e!==_(this,s,"f")&&N(this,s,e,"f")}getTransactions({addressFrom:e,status:t}){return _(this,n,"m",A).call(this).filter((r=>{var n;return r.status===t&&(null===(n=r.txParams)||void 0===n?void 0:n.from)===e}))}getSmartTransactionByMinedTxHash(e){if(!e)return undefined;return _(this,n,"m",A).call(this).find((t=>{var r,n;return(null===(n=null===(r=t.statusMetadata)||void 0===r?void 0:r.minedHash)||void 0===n?void 0:n.toLowerCase())===e.toLowerCase()}))}wipeSmartTransactions({address:e,ignoreNetwork:t}){if(!e)return;const r=e.toLowerCase();if(t){const{smartTransactionsState:{smartTransactions:e}}=this.state;Object.keys(e).forEach((e=>{_(this,n,"m",I).call(this,{chainId:e,addressLowerCase:r})}))}else _(this,n,"m",I).call(this,{chainId:_(this,o,"f"),addressLowerCase:r})}}r.default=G,s=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,c=new WeakMap,l=new WeakMap,d=new WeakMap,u=new WeakMap,h=new WeakMap,p=new WeakMap,m=new WeakMap,f=new WeakMap,g=new WeakMap,n=new WeakSet,b=async function(e,t){const r=Object.assign(Object.assign({},t),{headers:Object.assign({"Content-Type":"application/json"},_(this,a,"f")&&{"X-Client-Id":_(this,a,"f")})});return(0,K.handleFetch)(e,r)},C=function(e,{chainId:t=_(this,o,"f")}){var r;const{smartTransactionsState:{smartTransactions:n}}=this.state,s=null!==(r=n[t])&&void 0!==r?r:[],a=null==s?void 0:s.findIndex((t=>t.uuid===e.uuid));-1!==a&&(0,x.isSafeDynamicKey)(t)&&this.update((r=>{r.smartTransactionsState.smartTransactions[t][a]=Object.assign(Object.assign({},r.smartTransactionsState.smartTransactions[t][a]),e)}))},y=async function(e){const t=await _(this,p,"f").call(this);e.accountHardwareType=null==t?void 0:t.accountHardwareType,e.accountType=null==t?void 0:t.accountType,e.deviceModel=null==t?void 0:t.deviceModel},w=async function(e,{chainId:t=_(this,o,"f"),ethQuery:r=_(this,l,"f")}){var s;const{smartTransactionsState:{smartTransactions:i}}=this.state,c=null!==(s=i[t])&&void 0!==s?s:[],d=null==c?void 0:c.findIndex((t=>t.uuid===e.uuid)),h=this.isNewSmartTransaction(e.uuid,t);if(r===undefined)throw new Error(q);if(h)try{await _(this,n,"m",y).call(this,e)}catch(e){console.error("Failed to add metrics props to smart transaction:",e)}if(this.trackStxStatusChange(e,h?undefined:c[d]),h){const r=null==c?void 0:c.findIndex((t=>{var r,n,s;return(null===(r=t.txParams)||void 0===r?void 0:r.nonce)===(null===(n=e.txParams)||void 0===n?void 0:n.nonce)&&(null===(s=t.status)||void 0===s?void 0:s.startsWith("cancelled"))})),n=[(0,$.default)(e)],s=Object.assign(Object.assign({},e),{history:n}),a=r>-1?c.slice(0,r).concat(c.slice(r+1)).concat(s):c.concat(s);return void this.update((e=>{e.smartTransactionsState.smartTransactions[t]=a}))}const p=c[d],g=Object.assign(Object.assign({},p),e);this.messagingSystem.publish("SmartTransactionsController:smartTransaction",g),(0,K.shouldMarkRegularTransactionAsFailed)({smartTransaction:g,clientId:_(this,a,"f"),getFeatureFlags:_(this,m,"f")})&&(0,K.markRegularTransactionAsFailed)({smartTransaction:g,getRegularTransactions:_(this,u,"f"),updateTransaction:_(this,f,"f")}),e.status!==U.SmartTransactionStatuses.SUCCESS&&e.status!==U.SmartTransactionStatuses.REVERTED||e.confirmed?_(this,n,"m",C).call(this,e,{chainId:t}):await _(this,n,"m",v).call(this,g,{chainId:t,ethQuery:r})},S=function(e){if(!e)return!0;const t=_(this,u,"f").call(this),r=null==t?void 0:t.find((t=>{var r;return(null===(r=t.hash)||void 0===r?void 0:r.toLowerCase())===e.toLowerCase()}));return!r||![D.TransactionStatus.confirmed,D.TransactionStatus.submitted].includes(r.status)},v=async function(e,{chainId:t=_(this,o,"f"),ethQuery:r=_(this,l,"f")}){var s;if(r===undefined)throw new Error(q);const a=null===(s=e.statusMetadata)||void 0===s?void 0:s.minedHash;try{const s=await(0,x.query)(r,"getTransactionReceipt",[a]),o=await(0,x.query)(r,"getTransactionByHash",[a]),i=null==o?void 0:o.maxFeePerGas,c=null==o?void 0:o.maxPriorityFeePerGas;if(null==s?void 0:s.blockNumber){const o=await(0,x.query)(r,"getBlockByNumber",[null==s?void 0:s.blockNumber,!1]),l=null==o?void 0:o.baseFeePerGas,u=Object.assign(Object.assign({},e.txParams),{maxFeePerGas:i,maxPriorityFeePerGas:c}),p=Object.assign(Object.assign({},e),{id:e.uuid,status:D.TransactionStatus.confirmed,hash:a,txParams:u}),m=(0,K.snapshotFromTxMeta)(p),f=(0,K.replayHistory)(p.history),g=(0,K.generateHistoryEntry)(f,m,"txStateManager: setting status to confirmed"),b=g.length>0?Object.assign(Object.assign({},p),{history:p.history.concat(g)}):p;_(this,n,"m",S).call(this,a)&&_(this,d,"f").call(this,b,s,l),_(this,h,"f").call(this,{event:L.MetaMetricsEventName.StxConfirmed,category:L.MetaMetricsEventCategory.Transactions,properties:(0,K.getSmartTransactionMetricsProperties)(e),sensitiveProperties:(0,K.getSmartTransactionMetricsSensitiveProperties)(e)}),_(this,n,"m",C).call(this,Object.assign(Object.assign({},e),{confirmed:!0}),{chainId:t})}}catch(e){_(this,h,"f").call(this,{event:L.MetaMetricsEventName.StxConfirmationFailed,category:L.MetaMetricsEventCategory.Transactions}),console.error("confirm error",e)}finally{this.messagingSystem.publish("SmartTransactionsController:smartTransactionConfirmationDone",e)}},k=async function(e,t){const r=await _(this,c,"f").call(this,e.from,t),n=r.nextNonce;return r.releaseLock(),Object.assign(Object.assign({},e),{nonce:`0x${n.toString(16)}`})},T=function({networkClientId:e}={}){return e?this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId:_(this,o,"f")},P=function(){const{networkConfigurationsByChainId:e}=this.messagingSystem.call("NetworkController:getState");return Object.keys(e).filter((e=>_(this,i,"f").includes(e)))},M=function({chainId:e}){const{networkConfigurationsByChainId:t}=this.messagingSystem.call("NetworkController:getState");return t[e].rpcEndpoints[t[e].defaultRpcEndpointIndex].networkClientId},E=function({networkClientId:e}={}){if(e){const{provider:t}=this.messagingSystem.call("NetworkController:getNetworkClientById",e);return new j.default(t)}if(_(this,l,"f")===undefined)throw new Error(q);return _(this,l,"f")},A=function(){const{smartTransactionsState:{smartTransactions:e}}=this.state,t=Object.values(e).flat();return t&&0!==t.length?t:[]},I=function({chainId:e,addressLowerCase:t}){const{smartTransactionsState:{smartTransactions:r}}=this.state,n=null==r?void 0:r[e];if(!n||0===n.length)return;const s=n.filter((e=>{var r;return(null===(r=e.txParams)||void 0===r?void 0:r.from)!==t}));this.update((t=>{t.smartTransactionsState.smartTransactions[e]=s}))}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/SmartTransactionsController.js"}],[2598,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.SmartTransactionsTraceName=r.MetaMetricsEventCategory=r.MetaMetricsEventName=r.SENTINEL_API_BASE_URL_MAP=r.API_BASE_URL=void 0,r.API_BASE_URL="https://transaction.api.cx.metamask.io",r.SENTINEL_API_BASE_URL_MAP={1:"https://tx-sentinel-ethereum-mainnet.api.cx.metamask.io",56:"https://tx-sentinel-bsc-mainnet.api.cx.metamask.io",8453:"https://tx-sentinel-base-mainnet.api.cx.metamask.io",42161:"https://tx-sentinel-arbitrum-mainnet.api.cx.metamask.io",11155111:"https://tx-sentinel-ethereum-sepolia.api.cx.metamask.io"},function(e){e.StxStatusUpdated="STX Status Updated",e.StxConfirmed="STX Confirmed",e.StxConfirmationFailed="STX Confirmation Failed",e.ReceiveRequest="Receive Request"}(r.MetaMetricsEventName||(r.MetaMetricsEventName={})),function(e){e.Transactions="Transactions",e.Navigation="Navigation"}(r.MetaMetricsEventCategory||(r.MetaMetricsEventCategory={})),function(e){e.GetFees="Smart Transactions: Get Fees",e.SubmitTransactions="Smart Transactions: Submit Transactions",e.CancelTransaction="Smart Transactions: Cancel Transaction",e.FetchLiveness="Smart Transactions: Fetch Liveness"}(r.SmartTransactionsTraceName||(r.SmartTransactionsTraceName={}))}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/constants.js"}],[2599,{"./SmartTransactionsController":2597},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var s=e("./SmartTransactionsController");Object.defineProperty(r,"default",{enumerable:!0,get:function(){return n(s).default}})}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/index.js"}],[26,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getAssetsContractControllerMessenger=function(e){return e.getRestricted({name:"AssetsContractController",allowedActions:["NetworkController:getNetworkClientById","NetworkController:getNetworkConfigurationByNetworkClientId","NetworkController:getSelectedNetworkClient","NetworkController:getState"],allowedEvents:["PreferencesController:stateChange","NetworkController:networkDidChange"]})}}}},{package:"$root$",file:"app/scripts/controller-init/messengers/assets/assets-contract-controller-messenger.ts"}],[260,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:35,async migrate(e){const t=(0,n.cloneDeep)(e);return t.meta.version=35,t.data=function(e){e.PreferencesController&&e.PreferencesController.seedWords!==undefined&&delete e.PreferencesController.seedWords;return e}(t.data),t}}}}},{package:"$root$",file:"app/scripts/migrations/035.js"}],[2601,{"../package.json":2611,"./constants":2598,"./types":2600,"@ethersproject/bytes":572,"@ethersproject/keccak256":598,"@ethersproject/transactions":648,"@metamask/transaction-controller":2918,"bignumber.js":2610,"fast-json-patch":4482,lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.markRegularTransactionAsFailed=r.shouldMarkRegularTransactionAsFailed=r.getReturnTxHashAsap=r.getSmartTransactionMetricsSensitiveProperties=r.getSmartTransactionMetricsProperties=r.getTxHash=r.incrementNonceInHex=r.isSmartTransactionCancellable=r.handleFetch=r.mapKeysToCamel=r.getStxProcessingTime=r.snapshotFromTxMeta=r.replayHistory=r.generateHistoryEntry=r.calculateStatus=r.getAPIRequestURL=r.isSmartTransactionStatusResolved=r.isSmartTransactionPending=void 0;const s=e("@ethersproject/bytes"),a=e("@ethersproject/keccak256"),o=e("@ethersproject/transactions"),i=e("@metamask/transaction-controller"),c=e("bignumber.js"),l=n(e("fast-json-patch")),d=n(e("lodash")),u=n(e("../package.json")),h=e("./constants"),p=e("./types");r.isSmartTransactionPending=function(e){return e.status===p.SmartTransactionStatuses.PENDING};r.isSmartTransactionStatusResolved=e=>"uuid_not_found"===e,r.getAPIRequestURL=function(e,t){const r=parseInt(t,16);switch(e){case p.APIType.GET_FEES:return`${h.API_BASE_URL}/networks/${r}/getFees`;case p.APIType.ESTIMATE_GAS:return`${h.API_BASE_URL}/networks/${r}/estimateGas`;case p.APIType.SUBMIT_TRANSACTIONS:return`${h.API_BASE_URL}/networks/${r}/submitTransactions?stxControllerVersion=${u.default.version}`;case p.APIType.CANCEL:return`${h.API_BASE_URL}/networks/${r}/cancel`;case p.APIType.BATCH_STATUS:return`${h.API_BASE_URL}/networks/${r}/batchStatus`;case p.APIType.LIVENESS:return`${h.SENTINEL_API_BASE_URL_MAP[r]}/network`;default:throw new Error("Invalid APIType")}};r.calculateStatus=e=>{if((0,r.isSmartTransactionStatusResolved)(e))return p.SmartTransactionStatuses.RESOLVED;const t=[p.SmartTransactionCancellationReason.WOULD_REVERT,p.SmartTransactionCancellationReason.TOO_CHEAP,p.SmartTransactionCancellationReason.DEADLINE_MISSED,p.SmartTransactionCancellationReason.INVALID_NONCE,p.SmartTransactionCancellationReason.USER_CANCELLED];if((null==e?void 0:e.minedTx)===p.SmartTransactionMinedTx.NOT_MINED){if(e.cancellationReason===p.SmartTransactionCancellationReason.NOT_CANCELLED)return p.SmartTransactionStatuses.PENDING;const r=t.findIndex((t=>t===e.cancellationReason))>-1;if(e.cancellationReason&&r)return e.isSettled?p.cancellationReasonToStatusMap[e.cancellationReason]:p.SmartTransactionStatuses.PENDING}else{if((null==e?void 0:e.minedTx)===p.SmartTransactionMinedTx.SUCCESS)return p.SmartTransactionStatuses.SUCCESS;if((null==e?void 0:e.minedTx)===p.SmartTransactionMinedTx.CANCELLED)return p.SmartTransactionStatuses.CANCELLED;if((null==e?void 0:e.minedTx)===p.SmartTransactionMinedTx.REVERTED)return p.SmartTransactionStatuses.REVERTED;if((null==e?void 0:e.minedTx)===p.SmartTransactionMinedTx.UNKNOWN)return p.SmartTransactionStatuses.UNKNOWN}return p.SmartTransactionStatuses.UNKNOWN},r.generateHistoryEntry=function(e,t,r){const n=l.default.compare(e,t);return n[0]&&(r&&(n[0].note=r),n[0].timestamp=Date.now()),n},r.replayHistory=function(e){return d.default.cloneDeep(e).reduce(((e,t)=>l.default.applyPatch(e,t).newDocument))},r.snapshotFromTxMeta=function(e){const t=Object.assign({},e);return delete t.history,d.default.cloneDeep(t)};r.getStxProcessingTime=e=>e?Math.round((Date.now()-e)/1e3):undefined;r.mapKeysToCamel=e=>{if(!d.default.isObject(e))return e;const t=d.default.mapValues(e,(e=>d.default.isArray(e)?e.map(r.mapKeysToCamel):d.default.isObject(e)?(0,r.mapKeysToCamel)(e):e));return d.default.mapKeys(t,((e,t)=>d.default.camelCase(t)))},r.handleFetch=async function(e,t){const n=await fetch(e,t),s=await n.json();if(!n.ok)throw console.log("response",n),new Error(`Fetch error:${JSON.stringify(Object.assign({status:n.status},(0,r.mapKeysToCamel)(s)))}`);return s};r.isSmartTransactionCancellable=e=>e.minedTx===p.SmartTransactionMinedTx.NOT_MINED&&(!e.cancellationReason||e.cancellationReason===p.SmartTransactionCancellationReason.NOT_CANCELLED);r.incrementNonceInHex=e=>{const t=new c.BigNumber(e,16).toString(10);return(0,s.hexlify)(Number(t)+1)};r.getTxHash=e=>{var t;if(!e)return"";try{const r=(0,o.parse)(e);return null!==(t=null==r?void 0:r.hash)&&void 0!==t?t:""}catch(t){if((e=>"string"==typeof e&&e.startsWith("0x04"))(e))return(0,s.hexlify)((0,a.keccak256)((0,s.arrayify)(e)));throw t}};r.getSmartTransactionMetricsProperties=e=>{if(!e)return{};const t=e.statusMetadata;return{stx_status:e.status,type:e.type,processing_time:(0,r.getStxProcessingTime)(e.time),is_smart_transaction:!0,stx_enabled:!0,current_stx_enabled:!0,stx_user_opt_in:!0,stx_duplicated:null==t?void 0:t.duplicated,stx_timed_out:null==t?void 0:t.timedOut,stx_proxied:null==t?void 0:t.proxied}};r.getSmartTransactionMetricsSensitiveProperties=e=>e?{token_from_symbol:e.sourceTokenSymbol,token_to_symbol:e.destinationTokenSymbol,account_hardware_type:e.accountHardwareType,account_type:e.accountType,device_model:e.deviceModel}:{};r.getReturnTxHashAsap=(e,t)=>e===p.ClientId.Extension?null==t?void 0:t.extensionReturnTxHashAsap:null==t?void 0:t.mobileReturnTxHashAsap;r.shouldMarkRegularTransactionAsFailed=({smartTransaction:e,clientId:t,getFeatureFlags:n})=>{var s;const{status:a,transactionId:o}=e,i=[p.SmartTransactionStatuses.CANCELLED,p.SmartTransactionStatuses.CANCELLED_USER_CANCELLED,p.SmartTransactionStatuses.UNKNOWN,p.SmartTransactionStatuses.RESOLVED];if(!a||!i.includes(a))return!1;const{smartTransactions:c}=null!==(s=n())&&void 0!==s?s:{},l=(0,r.getReturnTxHashAsap)(t,c);return Boolean(l&&o)};r.markRegularTransactionAsFailed=({smartTransaction:e,getRegularTransactions:t,updateTransaction:r})=>{const{transactionId:n,status:s}=e,a=t().find((e=>e.id===n));if(!a)throw new Error("Cannot find regular transaction to mark it as failed");if(a.status===i.TransactionStatus.failed)return;r(Object.assign(Object.assign({},a),{status:i.TransactionStatus.failed,error:{name:"SmartTransactionFailed",message:`Smart transaction failed with status: ${s}`}}),`Smart transaction status: ${s}`)}}}},{package:"@metamask/smart-transactions-controller",file:"node_modules/@metamask/smart-transactions-controller/dist/utils.js"}],[2602,{"fast-json-stable-stringify":4483,uuid:5734},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.AbstractPollingControllerBaseMixin=r.getKey=void 0;const a=s(e("fast-json-stable-stringify")),o=e("uuid");r.getKey=e=>(0,a.default)(e),r.AbstractPollingControllerBaseMixin=function(e){var t,s;return t=new WeakMap,s=new WeakMap,class extends e{constructor(){super(...arguments),t.set(this,new Map),s.set(this,new Map)}startPolling(e){const s=(0,o.v4)(),a=(0,r.getKey)(e),i=n(this,t,"f").get(a)??new Set;return i.add(s),n(this,t,"f").set(a,i),1===i.size&&this._startPolling(e),s}stopAllPolling(){n(this,t,"f").forEach(((e,t)=>{e.forEach((e=>{this.stopPollingByPollingToken(e)}))}))}stopPollingByPollingToken(e){if(!e)throw new Error("pollingToken required");let r=null;for(const[s,a]of n(this,t,"f"))if(a.delete(e)){0===a.size&&(r=s);break}if(r){this._stopPollingByPollingTokenSetId(r),n(this,t,"f").delete(r);const e=n(this,s,"f").get(r);if(e){for(const t of e)t(JSON.parse(r));e.clear()}}}onPollingComplete(e,t){const a=(0,r.getKey)(e),o=n(this,s,"f").get(a)??new Set;o.add(t),n(this,s,"f").set(a,o)}}}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/AbstractPollingController.cjs"}],[2603,{"./AbstractPollingController.cjs":2602,"@metamask/base-controller":2609},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.BlockTrackerPollingController=r.BlockTrackerPollingControllerOnly=void 0;const s=e("@metamask/base-controller"),a=e("./AbstractPollingController.cjs");function o(e){var t;class r extends((0,a.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{})}_startPolling(e){const r=(0,a.getKey)(e);if(n(this,t,"f")[r])return;const s=this._getNetworkClientById(e.networkClientId);if(!s)throw new Error(`Unable to retrieve blockTracker for networkClientId ${e.networkClientId}`);{const a=this._executePoll.bind(this,e);s.blockTracker.addListener("latest",a),n(this,t,"f")[r]=a}}_stopPollingByPollingTokenSetId(e){const{networkClientId:r}=JSON.parse(e),s=this._getNetworkClientById(r);if(s&&n(this,t,"f")[e]){const r=n(this,t,"f")[e];r&&(s.blockTracker.removeListener("latest",r),delete n(this,t,"f")[e])}}}return t=new WeakMap,r}class i{}r.BlockTrackerPollingControllerOnly=()=>o(i);r.BlockTrackerPollingController=()=>o(s.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/BlockTrackerPollingController.cjs"}],[2604,{"./AbstractPollingController.cjs":2602,"@metamask/base-controller":2609},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},s=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.StaticIntervalPollingController=r.StaticIntervalPollingControllerOnly=void 0;const a=e("@metamask/base-controller"),o=e("./AbstractPollingController.cjs");function i(e){var t,r;class a extends((0,o.AbstractPollingControllerBaseMixin)(e)){constructor(){super(...arguments),t.set(this,{}),r.set(this,1e3)}setIntervalLength(e){n(this,r,e,"f")}getIntervalLength(){return s(this,r,"f")}_startPolling(e){if(!s(this,r,"f"))throw new Error("intervalLength must be defined and greater than 0");const n=(0,o.getKey)(e),a=s(this,t,"f")[n];this._stopPollingByPollingTokenSetId(n);const i=s(this,t,"f")[n]=setTimeout((async()=>{try{await this._executePoll(e)}catch(e){console.error(e)}i===s(this,t,"f")[n]&&this._startPolling(e)}),a?s(this,r,"f"):0)}_stopPollingByPollingTokenSetId(e){const r=s(this,t,"f")[e];r&&(clearTimeout(r),delete s(this,t,"f")[e])}}return t=new WeakMap,r=new WeakMap,a}class c{}r.StaticIntervalPollingControllerOnly=()=>i(c);r.StaticIntervalPollingController=()=>i(a.BaseController)}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/StaticIntervalPollingController.cjs"}],[2605,{"./BlockTrackerPollingController.cjs":2603,"./StaticIntervalPollingController.cjs":2604},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.StaticIntervalPollingController=r.StaticIntervalPollingControllerOnly=r.BlockTrackerPollingController=r.BlockTrackerPollingControllerOnly=void 0;var n=e("./BlockTrackerPollingController.cjs");Object.defineProperty(r,"BlockTrackerPollingControllerOnly",{enumerable:!0,get:function(){return n.BlockTrackerPollingControllerOnly}}),Object.defineProperty(r,"BlockTrackerPollingController",{enumerable:!0,get:function(){return n.BlockTrackerPollingController}});var s=e("./StaticIntervalPollingController.cjs");Object.defineProperty(r,"StaticIntervalPollingControllerOnly",{enumerable:!0,get:function(){return s.StaticIntervalPollingControllerOnly}}),Object.defineProperty(r,"StaticIntervalPollingController",{enumerable:!0,get:function(){return s.StaticIntervalPollingController}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/dist/index.cjs"}],[2606,{immer:4700},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},a=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.getPersistentState=r.getAnonymizedState=r.BaseController=r.isBaseController=void 0;const o=e("immer");(0,o.enablePatches)(),r.isBaseController=function(e){return"object"==typeof e&&null!==e&&"name"in e&&"string"==typeof e.name&&"state"in e&&"object"==typeof e.state&&"metadata"in e&&"object"==typeof e.metadata};function i(e,t,r){return Object.keys(e).reduce(((n,s)=>{try{const a=t[s];if(!a)throw new Error(`No metadata found for '${String(s)}'`);const o=a[r],i=e[s];return"function"==typeof o?n[s]=o(i):o&&(n[s]=i),n}catch(e){return setTimeout((()=>{throw e})),n}}),{})}r.BaseController=class{constructor({messenger:e,metadata:t,name:r,state:a}){n.set(this,void 0),this.messagingSystem=e,this.name=r,s(this,n,(0,o.freeze)(a,!0),"f"),this.metadata=t,this.messagingSystem.registerActionHandler(`${r}:getState`,(()=>this.state)),this.messagingSystem.registerInitialEventPayload({eventType:`${r}:stateChange`,getPayload:()=>[this.state,[]]})}get state(){return a(this,n,"f")}set state(e){throw new Error("Controller state cannot be directly mutated; use 'update' method instead.")}update(e){const[t,r,i]=o.produceWithPatches(a(this,n,"f"),e);return r.length>0&&(s(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,r)),{nextState:t,patches:r,inversePatches:i}}applyPatches(e){const t=(0,o.applyPatches)(a(this,n,"f"),e);s(this,n,t,"f"),this.messagingSystem.publish(`${this.name}:stateChange`,t,e)}destroy(){this.messagingSystem.clearEventSubscriptions(`${this.name}:stateChange`)}},n=new WeakMap,r.getAnonymizedState=function(e,t){return i(e,t,"anonymous")},r.getPersistentState=function(e,t){return i(e,t,"persist")}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/BaseControllerV2.cjs"}],[2607,{"./RestrictedMessenger.cjs":2608},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.Messenger=void 0;const c=e("./RestrictedMessenger.cjs");r.Messenger=class{constructor(){n.set(this,new Map),s.set(this,new Map),a.set(this,new Map),o.set(this,new Map)}registerActionHandler(e,t){if(i(this,n,"f").has(e))throw new Error(`A handler for ${e} has already been registered`);i(this,n,"f").set(e,t)}unregisterActionHandler(e){i(this,n,"f").delete(e)}clearActions(){i(this,n,"f").clear()}call(e,...t){const r=i(this,n,"f").get(e);if(!r)throw new Error(`A handler for ${e} has not been registered`);return r(...t)}registerInitialEventPayload({eventType:e,getPayload:t}){i(this,a,"f").set(e,t)}publish(e,...t){const r=i(this,s,"f").get(e);if(r)for(const[e,n]of r.entries())try{if(n){const r=i(this,o,"f").get(e),s=n(...t);s!==r&&(i(this,o,"f").set(e,s),e(s,r))}else e(...t)}catch(e){setTimeout((()=>{throw e}))}}subscribe(e,t,r){let n=i(this,s,"f").get(e);if(n||(n=new Map,i(this,s,"f").set(e,n)),n.set(t,r),r){const n=i(this,a,"f").get(e);if(n){const e=r(...n());i(this,o,"f").set(t,e)}}}unsubscribe(e,t){const r=i(this,s,"f").get(e);if(!r||!r.has(t))throw new Error(`Subscription not found for event: ${e}`);r.get(t)&&i(this,o,"f").delete(t),r.delete(t)}clearEventSubscriptions(e){i(this,s,"f").delete(e)}clearSubscriptions(){i(this,s,"f").clear()}getRestricted({name:e,allowedActions:t,allowedEvents:r}){return new c.RestrictedMessenger({messenger:this,name:e,allowedActions:t,allowedEvents:r})}},n=new WeakMap,s=new WeakMap,a=new WeakMap,o=new WeakMap}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/Messenger.cjs"}],[2608,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,d,u=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},h=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.RestrictedMessenger=void 0;r.RestrictedMessenger=class{constructor({messenger:e,name:t,allowedActions:r,allowedEvents:c}){if(n.add(this),s.set(this,void 0),a.set(this,void 0),o.set(this,void 0),i.set(this,void 0),!e)throw new Error("Messenger not provided");u(this,s,e,"f"),u(this,a,t,"f"),u(this,o,r,"f"),u(this,i,c,"f")}registerActionHandler(e,t){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed registering action handlers prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").registerActionHandler(e,t)}unregisterActionHandler(e){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed unregistering action handlers prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").unregisterActionHandler(e)}call(e,...t){if(!h(this,n,"m",l).call(this,e))throw new Error(`Action missing from allow list: ${e}`);return h(this,s,"f").call(e,...t)}registerInitialEventPayload({eventType:e,getPayload:t}){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").registerInitialEventPayload({eventType:e,getPayload:t})}publish(e,...t){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed publishing events prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").publish(e,...t)}subscribe(e,t,r){if(!h(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);return r?h(this,s,"f").subscribe(e,t,r):h(this,s,"f").subscribe(e,t)}unsubscribe(e,t){if(!h(this,n,"m",c).call(this,e))throw new Error(`Event missing from allow list: ${e}`);h(this,s,"f").unsubscribe(e,t)}clearEventSubscriptions(e){if(!h(this,n,"m",d).call(this,e))throw new Error(`Only allowed clearing events prefixed by '${h(this,a,"f")}:'`);h(this,s,"f").clearEventSubscriptions(e)}},s=new WeakMap,a=new WeakMap,o=new WeakMap,i=new WeakMap,n=new WeakSet,c=function(e){const t=h(this,i,"f");return h(this,n,"m",d).call(this,e)||null!==t&&t.includes(e)},l=function(e){const t=h(this,o,"f");return h(this,n,"m",d).call(this,e)||null!==t&&t.includes(e)},d=function(e){return e.startsWith(`${h(this,a,"f")}:`)}}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/RestrictedMessenger.cjs"}],[2609,{"./BaseControllerV2.cjs":2606,"./Messenger.cjs":2607,"./RestrictedMessenger.cjs":2608},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.RestrictedMessenger=r.Messenger=r.isBaseController=r.getPersistentState=r.getAnonymizedState=r.BaseController=void 0;var n=e("./BaseControllerV2.cjs");Object.defineProperty(r,"BaseController",{enumerable:!0,get:function(){return n.BaseController}}),Object.defineProperty(r,"getAnonymizedState",{enumerable:!0,get:function(){return n.getAnonymizedState}}),Object.defineProperty(r,"getPersistentState",{enumerable:!0,get:function(){return n.getPersistentState}}),Object.defineProperty(r,"isBaseController",{enumerable:!0,get:function(){return n.isBaseController}});var s=e("./Messenger.cjs");Object.defineProperty(r,"Messenger",{enumerable:!0,get:function(){return s.Messenger}});var a=e("./RestrictedMessenger.cjs");Object.defineProperty(r,"RestrictedMessenger",{enumerable:!0,get:function(){return a.RestrictedMessenger}})}}},{package:"@metamask/smart-transactions-controller>@metamask/polling-controller>@metamask/base-controller",file:"node_modules/@metamask/smart-transactions-controller/node_modules/@metamask/polling-controller/node_modules/@metamask/base-controller/dist/index.cjs"}],[261,{lodash:4905},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=e("lodash");r.default={version:36,async migrate(e){const t=(0,n.cloneDeep)(e);t.meta.version=36;const r=t.data;return t.data=function(e){const{PreferencesController:t}=e;if(t){const e=t.featureFlags||{};void 0!==e.privacyMode&&delete e.privacyMode}return e}(r),t}}}}},{package:"$root$",file:"app/scripts/migrations/036.js"}]],[],{});