LavaPack.loadBundle([[1548,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],[1549,{"./build/multichain-openrpc.json":1547,"./build/openrpc.json":1548},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.MultiChainOpenRPCDocument=r.MetaMaskOpenRPCDocument=void 0;const s=n(e("./build/openrpc.json"));r.MetaMaskOpenRPCDocument=s.default;const a=n(e("./build/multichain-openrpc.json"));r.MultiChainOpenRPCDocument=a.default,r.default=s.default}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js"}],[1550,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports={"0x12652C6d93FDB6F4f37d48A8687783C782BB0d10":{name:"Entangle",logo:"NGL.svg",erc20:!0,symbol:"NGL",decimals:18},"0xB50721BCf8d664c30412Cfbc6cf7a15145234ad1":{name:"Arbitrum",logo:"Arb.svg",erc20:!0,symbol:"ARB",decimals:18},"0x4D0528598F916Fd1D8dc80e5f54a8fEEDcFd4b18":{name:"Atoshi",logo:"ATOS.svg",erc20:!0,symbol:"ATOS",decimals:18},"0x57B946008913B82E4dF85f501cbAeD910e58D26C":{name:"POND",logo:"POND.svg",erc20:!0,symbol:"POND",decimals:18},"0x5eed99d066a8CaF10f3E4327c1b3D8b673485eED":{name:"SEED",logo:"SEED.svg",erc20:!0,symbol:"SEED",decimals:18},"0x487d62468282Bd04ddf976631C23128A425555EE":{name:"UPCX",logo:"UPC.svg",erc20:!0,symbol:"UPC",decimals:5},"0xd3210F246Ae54C5a45A7b4A83315bf718F591bfc":{name:"ArkiTech",logo:"ARKI.svg",erc20:!0,symbol:"ARKI",decimals:9},"0x7d51888C5ABb7CDfa9cdd6A50673c7F8afAccD7F":{name:"DuckDAO Token",logo:"duckdao.svg",erc20:!0,symbol:"DD",decimals:18},"0x49642110B712C1FD7261Bc074105E9E44676c68F":{name:"DinoLFG",logo:"DINO.svg",erc20:!0,symbol:"DINO",decimals:18},"0xB8BAa0e4287890a5F79863aB62b7F175ceCbD433":{name:"Swerve DAO Token",logo:"swrv.svg",erc20:!0,symbol:"SWRV",decimals:18},"0x8b79656FC38a04044E495e22fAD747126ca305C4":{name:"AgaveCoin",logo:"agvc.svg",erc20:!0,symbol:"AGVC",decimals:18},"0x967da4048cD07aB37855c090aAF366e4ce1b9F48":{name:"Ocean Token",logo:"ocean.svg",erc20:!0,symbol:"OCEAN",decimals:18},"0x83e6f1E41cdd28eAcEB20Cb649155049Fac3D5Aa":{name:"PolkastarterToken",logo:"pols.svg",erc20:!0,symbol:"POLS",decimals:18},"0x08d967bb0134F2d07f7cfb6E246680c53927DD30":{name:"MATH Token",logo:"math.svg",erc20:!0,symbol:"MATH",decimals:18},"0xccC8cb5229B0ac8069C51fd58367Fd1e622aFD97":{name:"Gods Unchained",logo:"gods.svg",erc20:!0,symbol:"GODS",decimals:18},"0xF57e7e7C23978C3cAEC3C3548E3D615c346e79fF":{name:"Immutable X",logo:"imx.svg",erc20:!0,symbol:"IMX",decimals:18},"0x40D16FC0246aD3160Ccc09B8D0D3A2cD28aE6C2f":{name:"Gho Token",logo:"GHO.svg",erc20:!0,symbol:"GHO",decimals:18},"0x536381a8628dBcC8C70aC9A30A7258442eAb4c92":{name:"Pantos Token ",logo:"pan.svg",erc20:!0,symbol:"PAN",decimals:8},"0x011E128Ec62840186F4A07E85E3ACe28858c5606":{name:"Valeria",logo:"val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x6c3ea9036406852006290770BEdFcAbA0e23A0e8":{name:"PayPal USD",logo:"pyusd.svg",erc20:!0,symbol:"PYUSD",decimals:6},"0x8b385Ca3592A5EFc34E0C9fE663de56897F1751F":{name:"INFibit",logo:"INFibit.svg",erc20:!0,symbol:"IBIT",decimals:18},"0x9bf1D7D63dD7a4ce167CF4866388226EEefa702E":{name:"Ben Coin",logo:"BEN.svg",erc20:!0,symbol:"BEN",decimals:18},"0xC7a2572fA8FDB0f7E81d6D3c4e3CCF78FB0DC374":{name:"Bens Finale",logo:"BensFinale.svg",erc20:!0,symbol:"FINALE",decimals:18},"0x99cFB8cBA9c821B4a343c6a1Fc630465C9708DF5":{name:"Pepe Inu",logo:"PepeInu.svg",erc20:!0,symbol:"$PEPEINU",decimals:18},"0xCEBA2a8F6Ec221AEB5f3a7bcd15Cbc7e6a387bfb":{name:"Peter Pan",logo:"PeterPan.svg",erc20:!0,symbol:"PAN",decimals:18},"0x467719aD09025FcC6cF6F8311755809d45a5E5f3":{name:"Axelar",logo:"axelar.svg",erc20:!0,symbol:"AXL",decimals:6},"0x665F77fbA5975ab40Ce61c90F28007fb5b09D7B1":{name:"Genieswap",logo:"Genieswap.svg",erc20:!0,symbol:"GENIE",decimals:18},"0x09E6d500D14D13e0528d2c0fff24E5ffF68237B4":{name:"Dohrnii",logo:"dhn.svg",erc20:!0,symbol:"DHN",decimals:18},"0xaE0585a259A3BCAB258D6EE02FB583f7B33C2a12":{name:"TempleCoin",logo:"tem.svg",erc20:!0,symbol:"TEM",decimals:18},"0xaeDf386B755465871fF874E3E37Af5976E247064":{name:"Fasttoken",logo:"ftn.svg",erc20:!0,symbol:"FTN",decimals:18},"0x7BEF710a5759d197EC0Bf621c3Df802C2D60D848":{name:"SHOPX",logo:"SHOPX.svg",erc20:!0,symbol:"SHOPX",decimals:18},"0xBa3335588D9403515223F109EdC4eB7269a9Ab5D":{name:"Gearbox",logo:"gear.svg",erc20:!0,symbol:"GEAR",decimals:18},"0x9B6B9d2468E165a02FEf69E61B6D3D6CBC0Ac409":{name:"OASISLIFE",logo:"OFE.svg",erc20:!0,symbol:"OFE",decimals:18},"0xdf0162A6B3e9fDf0302c1e949739DeeaFafd8F89":{name:"METAOASIS",logo:"MOA.svg",erc20:!0,symbol:"MOA",decimals:18},"0xe4dae00bc1c46ea2F44ae71B1BEb8b171C15d812":{name:"PREMA",logo:"PREMA.svg",erc20:!0,symbol:"PRMX",decimals:18},"0x1416946162B1C2c871A73B07E932D2fB6C932069":{name:"Energi",logo:"energi.svg",erc20:!0,symbol:"NRG",decimals:18},"0x0d88eD6E74bbFD96B831231638b66C05571e824F":{name:"Aventus",logo:"aventus.svg",erc20:!0,symbol:"AVT",decimals:18},"0x4FC15c91a9c4A9efB404174464687E8e128730C2":{name:"STAT",logo:"STAT.svg",erc20:!0,erc721:!1,symbol:"STAT",decimals:18},"0x4ad7a056191F4c9519fAcd6D75FA94CA26003aCE":{name:"GoldPesa Option",logo:"GPO.svg",erc20:!0,symbol:"GPO",decimals:18},"0x767FE9EDC9E0dF98E07454847909b5E959D7ca0E":{name:"Illuvium",logo:"illuvium.svg",erc20:!0,erc721:!1,symbol:"ILV",decimals:18},"0x85F17Cf997934a597031b2E18a9aB6ebD4B9f6a4":{name:"NEAR",logo:"NEAR.svg",erc20:!0,symbol:"NEAR",decimals:24},"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2":{name:"SushiSwap",logo:"sushi.svg",erc20:!0,erc721:!1,symbol:"SUSHI",decimals:18},"0x881Ba05de1E78f549cC63a8f6Cabb1d4AD32250D":{name:"00",logo:"00.svg",erc20:!0,erc721:!1,symbol:"00",decimals:18},"0xC211477cb4098aC22a98432781f5f26a1E07a4d4":{name:"CULTURED",logo:"CULTURED.svg",erc20:!0,erc721:!1,symbol:"CULTURED",decimals:18},"0x86f2A193b116d1f9C53Ed26d97F77cDC8BcF4c2b":{name:"EHTAGA",logo:"EHTAGA.svg",erc20:!0,erc721:!1,symbol:"EHTAGA",decimals:18},"0x54b79A15b2e2c55c736A66bb0A978fb840407aC8":{name:"FEVER",logo:"FEVER.svg",erc20:!0,erc721:!1,symbol:"FEVER",decimals:18},"0x677c9fE4396D3D13A0F9013a8118eAE386C843A5":{name:"IAM",logo:"IAM.svg",erc20:!0,erc721:!1,symbol:"IAM",decimals:18},"0xf63c65E855020E4B74f0Ad842D9537dA0E6162eC":{name:"ISH",logo:"ISH.svg",erc20:!0,erc721:!1,symbol:"ISH",decimals:18},"0xc105fA46510F32c0444CCdB4e51065da95caA1B4":{name:"LITA",logo:"LITA.svg",erc20:!0,erc721:!1,symbol:"LITA",decimals:18},"0x5401F949cDfa3E5aF32538167c0314230769209C":{name:"MAHCOIN",logo:"MAHCOIN.svg",erc20:!0,erc721:!1,symbol:"MAHCOIN",decimals:18},"0x711D2C47aFf84B96AD0F36983b1c41Be2C509e18":{name:"NIKITA",logo:"NIKITA.svg",erc20:!0,erc721:!1,symbol:"NIKITA",decimals:18},"0x3C44aEc33993b6830e5C2a705ea879b9C9ba0f7c":{name:"NYELA",logo:"NYELA.svg",erc20:!0,erc721:!1,symbol:"NYELA",decimals:18},"0xfa9096c99e687ea8E0064C23DAaCFE87cc99E4Ba":{name:"RON",logo:"RON.svg",erc20:!0,erc721:!1,symbol:"RON",decimals:18},"0x287a7C95aD00bBDd48599Ad2919567fD09281f07":{name:"STEELO",logo:"STEELO.svg",erc20:!0,erc721:!1,symbol:"STEELO",decimals:18},"0x2Ec3275f7aCe4044e499823F511cd58250be8E3d":{name:"Privilege",logo:"prvg.svg",erc20:!0,symbol:"PRVG",decimals:8},"0x65BB569FAaDD324a00883FdE4c46346cc96D5c0A":{name:"Provide",logo:"prvd.svg",erc20:!0,symbol:"PRVD",decimals:8},"0xB4272071eCAdd69d933AdcD19cA99fe80664fc08":{name:"CryptoFranc",logo:"XCHF.svg",erc20:!0,symbol:"XCHF",decimals:18},"0x5aFE3855358E112B5647B952709E6165e1c1eEEe":{name:"Safe Token",logo:"safe-green-token.svg",erc20:!0,symbol:"SAFE",decimals:18},"0x9C8fF314C9Bc7F6e59A9d9225Fb22946427eDC03":{name:"Nouns",erc20:!1,erc721:!0,symbol:"NOUN",decimals:0,logo:"nouns.svg"},"0xBC4CA0EdA7647A8aB7C2061c2E118A18a936f13D":{name:"BoredApeYachtClub",erc20:!1,erc721:!0,symbol:"BAYC",decimals:0,logo:"bayc.svg"},"0x08D7C0242953446436F34b4C78Fe9da38c73668d":{name:"PROOF Collective",erc20:!1,erc721:!0,symbol:"PROOF",decimals:0,logo:"proof.svg"},"0x23581767a106ae21c074b2276D25e5C3e136a68b":{name:"Moonbirds",erc20:!1,erc721:!0,symbol:"MOONBIRD",decimals:0,logo:"moonbirds.svg"},"0x60E4d786628Fea6478F785A6d7e704777c86a7c6":{name:"MutantApeYachtClub",erc20:!1,erc721:!0,symbol:"MAYC",decimals:0,logo:"mayc.svg"},"0x49cF6f5d44E70224e2E23fDcdd2C053F30aDA28B":{name:"CloneX",erc20:!1,erc721:!0,symbol:"CloneX",decimals:0,logo:"clonex.svg"},"0x8a90CAb2b38dba80c64b7734e58Ee1dB38B8992e":{name:"Doodles",erc20:!1,erc721:!0,symbol:"DOODLE",decimals:0,logo:"doodles.svg"},"0xED5AF388653567Af2F388E6224dC7C4b3241C544":{name:"Azuki",erc20:!1,erc721:!0,symbol:"AZUKI",decimals:0,logo:"azuki.svg"},"0xa3AEe8BcE55BEeA1951EF834b99f3Ac60d1ABeeB":{name:"VeeFriends",erc20:!1,erc721:!0,symbol:"VFT",decimals:0,logo:"veefriends.svg"},"0x34d85c9CDeB23FA97cb08333b511ac86E1C4E258":{name:"Otherdeed",erc20:!1,erc721:!0,symbol:"OTHR",decimals:0,logo:"otherdeed.svg"},"0xBBc2AE13b23d715c30720F079fcd9B4a74093505":{name:"Ethernity Chain Token",logo:"ERN.svg",erc20:!0,symbol:"ERN",decimals:18},"0x243cACb4D5fF6814AD668C3e225246efA886AD5a":{name:"Shina Inu",logo:"shina.svg",erc20:!0,symbol:"SHI",decimals:18},"0xD057B63f5E69CF1B929b356b579Cba08D7688048":{name:"CoW Protocol Virtual Token",logo:"vCOW.svg",erc20:!0,symbol:"vCOW",decimals:18},"0xDEf1CA1fb7FBcDC777520aa7f396b4E015F497aB":{name:"CoW Protocol Token",logo:"COW.svg",erc20:!0,symbol:"COW",decimals:18},"0xEd04915c23f00A313a544955524EB7DBD823143d":{name:"Alchemy Pay",logo:"ACH.svg",erc20:!0,symbol:"ACH",decimals:8},"0xeDF6568618A00C6F0908Bf7758A16F76B6E04aF9":{name:"Arianee",logo:"aria20.svg",erc20:!0,symbol:"ARIA20",decimals:18},"0x88D8DA2A8D0fA5b1f4E38030AC486aDE0AFA2798":{name:"Terrapass Coin",logo:"tpsc.svg",erc20:!0,symbol:"TPSC",decimals:18},"0x4730fB1463A6F1F44AEB45F6c5c422427f37F4D0":{name:"The 4th Pillar Token",logo:"four.svg",erc20:!0,symbol:"FOUR",decimals:18},"0x875773784Af8135eA0ef43b5a374AaD105c5D39e":{name:"Idle DAO Token",logo:"idle.svg",erc20:!0,symbol:"IDLE",decimals:18},"0x6BeA7CFEF803D1e3d5f7C0103f7ded065644e197":{name:"Gamma",logo:"Gamma.svg",erc20:!0,symbol:"GAMMA",decimals:18},"0x26805021988F1a45dC708B5FB75Fc75F21747D8c":{name:"xGamma",logo:"xGamma.svg",erc20:!0,symbol:"xGAMMA",decimals:18},"0xc7D9c108D4E1dD1484D3e2568d7f74bfD763d356":{name:"SORA Synthetic USD",logo:"sora-xstusd.svg",erc20:!0,symbol:"XSTUSD",decimals:18},"0x519C1001D550C0a1DaE7d1fC220f7d14c2A521BB":{name:"Polkaswap",logo:"sora-pswap.svg",erc20:!0,symbol:"PSWAP",decimals:18},"0x40FD72257597aA14C7231A7B1aaa29Fce868F677":{name:"SORA",logo:"sora-xor.svg",erc20:!0,symbol:"XOR",decimals:18},"0x909E34d3f6124C324ac83DccA84b74398a6fa173":{name:"$ZKP Token",logo:"ZKP.svg",erc20:!0,erc721:!1,symbol:"$ZKP",decimals:18},"0xe88f8313e61A97cEc1871EE37fBbe2a8bf3ed1E4":{name:"SORA Validator",logo:"sora-val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x7A58c0Be72BE218B41C608b7Fe7C5bB630736C71":{name:"ConstitutionDAO",logo:"PEOPLE.svg",erc20:!0,symbol:"PEOPLE",decimals:18},"0x32E6C34Cd57087aBBD59B5A4AECC4cB495924356":{name:"BitBase",logo:"BTBS.svg",erc20:!0,symbol:"BTBS",decimals:18},"0x3fa400483487A489EC9b1dB29C4129063EEC4654":{name:"Cryptokek.com",logo:"cryptokek.svg",erc20:!0,symbol:"KEK",decimals:18},"0xEd3D4e446A96dC3b181B64B75c3c70dA41dC3CBe":{name:"Vodra",logo:"Vodra.svg",erc20:!0,symbol:"VDR",decimals:18},"0xb753428af26E81097e7fD17f40c88aaA3E04902c":{name:"Spice",logo:"sfi.svg",erc20:!0,symbol:"SFI",decimals:18},"0xd084944d3c05CD115C09d072B9F44bA3E0E45921":{name:"Manifold Finance",logo:"Manifold.svg",erc20:!0,symbol:"FOLD",decimals:18},"0x9a0242b7a33DAcbe40eDb927834F96eB39f8fBCB":{name:"BABB",logo:"bax.svg",erc20:!0,symbol:"BAX",decimals:18},"0x4Cf89ca06ad997bC732Dc876ed2A7F26a9E7f361":{name:"Mysterium",logo:"MYST.svg",erc20:!0,symbol:"MYST",decimals:18},"0x697eF32B4a3F5a4C39dE1cB7563f24CA7BfC5947":{name:"Insula Token",logo:"Insula.svg",erc20:!0,symbol:"ISLA",decimals:18},"0x62Dc4817588d53a056cBbD18231d91ffCcd34b2A":{name:"DeHive",logo:"dehive.svg",erc20:!0,erc721:!1,symbol:"DHV",decimals:18},"0x8400D94A5cb0fa0D041a3788e395285d61c9ee5e":{name:"Unibright",logo:"ubt.svg",erc20:!0,symbol:"UBT",decimals:8},"0xfAd45E47083e4607302aa43c65fB3106F1cd7607":{name:"Hoge Finance",logo:"HogeFinanceLogo.svg",erc20:!0,symbol:"HOGE",decimals:9},"0xBB0E17EF65F82Ab018d8EDd776e8DD940327B28b":{name:"Axie Infinity Shard",logo:"AXS.svg",erc20:!0,symbol:"AXS",decimals:18},"0xCC8Fa225D80b9c7D42F96e9570156c65D6cAAa25":{name:"Smooth Love Potion",logo:"SLP.svg",erc20:!0,symbol:"SLP",decimals:0},"0x10633216E7E8281e33c86F02Bf8e565a635D9770":{name:"Dvision Network",logo:"dvision.svg",erc20:!0,symbol:"DVI",decimals:18},"0x898BAD2774EB97cF6b94605677F43b41871410B1":{name:"vEth2",logo:"vEth2.svg",erc20:!0,symbol:"vEth2",decimals:18},"0x321C2fE4446C7c963dc41Dd58879AF648838f98D":{name:"Cryptex Finance",logo:"ctx.svg",erc20:!0,symbol:"CTX",decimals:18},"0x16c52CeeCE2ed57dAd87319D91B5e3637d50aFa4":{name:"TCAP Token",logo:"tcap.svg",erc20:!0,symbol:"TCAP",decimals:18},"0xE94B97b6b43639E238c851A7e693F50033EfD75C":{name:"Rainbow Token",logo:"halodao-rnbw.svg",erc20:!0,symbol:"RNBW",decimals:18},"0x47BE779De87de6580d0548cde80710a93c502405":{name:"Rainbow Pool",logo:"halodao-xrnbw.svg",erc20:!0,symbol:"xRNBW",decimals:18},"0xe7aE6D0C56CACaf007b7e4d312f9af686a9E9a04":{name:"Vabble",logo:"VAB.svg",erc20:!0,symbol:"VAB",decimals:18},"0x853d955aCEf822Db058eb8505911ED77F175b99e":{name:"Frax",logo:"frax.svg",erc20:!0,symbol:"FRAX",decimals:18},"0x3432B6A60D23Ca0dFCa7761B7ab56459D9C964D0":{name:"Frax Share",logo:"fxs.svg",erc20:!0,symbol:"FXS",decimals:18},"0x84810bcF08744d5862B8181f12d17bfd57d3b078":{name:"SharedStake",logo:"sharedstake.svg",erc20:!0,symbol:"SGT",decimals:18},"0x75387e1287Dd85482aB66102DA9f6577E027f609":{name:"MindsyncAI",logo:"MAI.svg",erc20:!0,symbol:"MAI",decimals:18},"0x196f4727526eA7FB1e17b2071B3d8eAA38486988":{name:"Reserve",logo:"rsv.svg",erc20:!0,symbol:"RSV",decimals:18},"0x320623b8E4fF03373931769A31Fc52A4E78B5d70":{name:"Reserve Rights",logo:"rsr.svg",erc20:!0,symbol:"RSR",decimals:18},"0x1cF4592ebfFd730c7dc92c1bdFFDfc3B9EfCf29a":{name:"WAVES",logo:"waves.svg",erc20:!0,symbol:"WAVES",decimals:18},"0x252739487C1fa66eaeaE7CED41d6358aB2a6bCa9":{name:"ArCoin",logo:"ArCoin.svg",erc20:!0,symbol:"RCOIN",decimals:8},"0x18aAA7115705e8be94bfFEBDE57Af9BFc265B998":{name:"Audius",logo:"audius.svg",erc20:!0,symbol:"AUDIO",decimals:18},"0x8E3BCC334657560253B83f08331d85267316e08a":{name:"Rubic",logo:"brbc.svg",erc20:!0,symbol:"BRBC",decimals:18},"0xca1207647Ff814039530D7d35df0e1Dd2e91Fa84":{name:"dHEDGE DAO Token",logo:"DHT.svg",erc20:!0,symbol:"DHT",decimals:18},"0x6243d8CEA23066d098a15582d81a598b4e8391F4":{name:"Reflexer Ungovernance Token",logo:"flx.svg",erc20:!0,symbol:"FLX",decimals:18},"0x03ab458634910AaD20eF5f1C8ee96F1D6ac54919":{name:"Rai Reflex Index",logo:"rai.svg",erc20:!0,symbol:"RAI",decimals:18},"0xF25c91C87e0B1fd9B4064Af0F427157AaB0193A7":{name:"BASIC Token",logo:"basic.svg",erc20:!0,symbol:"BASIC",decimals:18},"0x53C8395465A84955c95159814461466053DedEDE":{name:"DeGate Token",logo:"DG.svg",erc20:!0,symbol:"DG",decimals:18},"0xBCf9dBf8B14eD096B2BA08b7269356197fDd1b5D":{name:"Avaluse",logo:"avaluse.svg",erc20:!0,symbol:"AVAL",decimals:18},"0x6E765D26388A17A6e86c49A8E41DF3F58aBcd337":{name:"Kangal",logo:"kangal.svg",erc20:!0,symbol:"KANGAL",decimals:18},"0x9AF4f26941677C706cfEcf6D3379FF01bB85D5Ab":{name:"DomRaiderToken",logo:"drt.svg",erc20:!0,symbol:"DRT",decimals:8},"0x06B179e292f080871825beD5D722162fD96B4c95":{name:"10x.gg",logo:"xgg.svg",erc20:!0,symbol:"XGG",decimals:18},"0xF29992D7b589A0A6bD2de7Be29a97A6EB73EaF85":{name:"DMScript",logo:"dmst.svg",erc20:!0,symbol:"DMST",decimals:18},"0x64aa3364F17a4D01c6f1751Fd97C2BD3D7e7f1D5":{name:"Olympus",logo:"OHM.svg",erc20:!0,symbol:"OHM",decimals:9},"0x0ab87046fBb341D058F17CBC4c1133F25a20a52f":{name:"Governance OHM",logo:"gOHM.svg",erc20:!0,symbol:"gOHM",decimals:18},"0xDd1Ad9A21Ce722C151A836373baBe42c868cE9a4":{name:"Universal Basic Income",logo:"ubi.svg",erc20:!0,symbol:"UBI",decimals:18},"0xf293d23BF2CDc05411Ca0edDD588eb1977e8dcd4":{name:"Sylo",logo:"SYLO.svg",erc20:!0,symbol:"SYLO",decimals:18},"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84":{name:"Liquid staked Ether 2.0",logo:"stETH.svg",erc20:!0,symbol:"stETH",decimals:18},"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0":{name:"Wrapped liquid staked Ether 2.0",logo:"wstETH.svg",erc20:!0,symbol:"wstETH",decimals:18},"0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32":{name:"Lido DAO Token",logo:"LDO.svg",erc20:!0,symbol:"LDO",decimals:18},"0xbd31EA8212119f94A611FA969881CBa3EA06Fa3d":{name:"LUNA Token",logo:"Luna.svg",erc20:!0,symbol:"LUNA",decimals:6},"0xa693B19d2931d498c5B318dF961919BB4aee87a5":{name:"UST Token",logo:"UST.svg",erc20:!0,symbol:"UST",decimals:6},"0xd2877702675e6cEb975b4A1dFf9fb7BAF4C91ea9":{name:"LUNA Token - Shuttle",logo:"lunc.svg",erc20:!0,symbol:"LUNC",decimals:18},"0xa47c8bf37f92aBed4A126BDA807A7b7498661acD":{name:"UST Token - Shuttle",logo:"ustc.svg",erc20:!0,symbol:"USTC",decimals:18},"0xcAAfF72A8CbBfc5Cf343BA4e26f65a257065bFF1":{name:"KRT Token - Shuttle",logo:"KRT.svg",erc20:!0,symbol:"KRT-S",decimals:18},"0x676Ad1b33ae6423c6618C1AEcf53BAa29cf39EE5":{name:"SDT Token - Shuttle",logo:"SDT.svg",erc20:!0,symbol:"SDT-S",decimals:18},"0x156B36ec68FdBF84a925230BA96cb1Ca4c4bdE45":{name:"MNT Token - Shuttle",logo:"MNT.svg",erc20:!0,symbol:"MNT-S",decimals:18},"0x09a3EcAFa817268f77BE1283176B946C4ff2E608":{name:"MIR Token - Shuttle",logo:"MIR.svg",erc20:!0,symbol:"MIR-S",decimals:18},"0xd36932143F6eBDEDD872D5Fb0651f4B72Fd15a84":{name:"Mirror AAPL Token - Shuttle",logo:"mAAPL.svg",erc20:!0,symbol:"mAAPL-S",decimals:18},"0x59A921Db27Dd6d4d974745B7FfC5c33932653442":{name:"Mirror GOOGL Token - Shuttle",logo:"mGOOGL.svg",erc20:!0,symbol:"mGOGL-S",decimals:18},"0x21cA39943E91d704678F5D00b6616650F066fD63":{name:"Mirror TSLA Token - Shuttle",logo:"mTSLA.svg",erc20:!0,symbol:"mTSLA-S",decimals:18},"0xC8d674114bac90148d11D3C1d33C61835a0F9DCD":{name:"Mirror NFLX Token - Shuttle",logo:"mNFLX.svg",erc20:!0,symbol:"mNFLX-S",decimals:18},"0x13B02c8dE71680e71F0820c996E4bE43c2F57d15":{name:"Mirror QQQ Token - Shuttle",logo:"mQQQ.svg",erc20:!0,symbol:"mQQQ-S",decimals:18},"0xEdb0414627E6f1e3F082DE65cD4F9C693D78CCA9":{name:"Mirror TWTR Token - Shuttle",logo:"mTWTR.svg",erc20:!0,symbol:"mTWTR-S",decimals:18},"0x41BbEDd7286dAab5910a1f15d12CBda839852BD7":{name:"Mirror MSFT Token - Shuttle",logo:"mMSFT.svg",erc20:!0,symbol:"mMSFT-S",decimals:18},"0x0cae9e4d663793c2a2A0b211c1Cf4bBca2B9cAa7":{name:"Mirror AMZN Token - Shuttle",logo:"mAMZN.svg",erc20:!0,symbol:"mAMZN-S",decimals:18},"0x56aA298a19C93c6801FDde870fA63EF75Cc0aF72":{name:"Mirror BABA Token - Shuttle",logo:"mBABA.svg",erc20:!0,symbol:"mBABA-S",decimals:18},"0x1d350417d9787E000cc1b95d70E9536DcD91F373":{name:"Mirror IAU Token - Shuttle",logo:"mIAU.svg",erc20:!0,symbol:"mIAU-S",decimals:18},"0x9d1555d8cB3C846Bb4f7D5B1B1080872c3166676":{name:"Mirror SLV Token - Shuttle",logo:"mSLV.svg",erc20:!0,symbol:"mSLV-S",decimals:18},"0x31c63146a635EB7465e5853020b39713AC356991":{name:"Mirror USO Token - Shuttle",logo:"mUSO.svg",erc20:!0,symbol:"mUSO-S",decimals:18},"0xf72FCd9DCF0190923Fadd44811E240Ef4533fc86":{name:"Mirror VIXY Token - Shuttle",logo:"mVIXY.svg",erc20:!0,symbol:"mVIXY-S",decimals:18},"0x21BfBDa47A0B4B5b1248c767Ee49F7caA9B23697":{name:"OVR",logo:"OVR.svg",erc20:!0,symbol:"OVR",decimals:18},"0x4691937a7508860F876c9c0a2a617E7d9E945D4B":{name:"Wootrade Network",logo:"wootrade.svg",erc20:!0,symbol:"WOO",decimals:18},"0xaf9f549774ecEDbD0966C52f250aCc548D3F36E5":{name:"RFUEL",logo:"RFUEL.svg",erc20:!0,symbol:"RFUEL",decimals:18},"0x7420B4b9a0110cdC71fB720908340C03F9Bc03EC":{name:"JasmyCoin",logo:"JASMY.svg",erc20:!0,symbol:"JASMY",decimals:18},"0x947AEb02304391f8fbE5B25D7D98D649b57b1788":{name:"Mandala Exchange Token",logo:"mandala.svg",erc20:!0,symbol:"MDX",decimals:18},"0xCdeee767beD58c5325f68500115d4B722b3724EE":{name:"Carbon",logo:"CRBN.svg",erc20:!0,symbol:"CRBN",decimals:18},"0xA4EED63db85311E22dF4473f87CcfC3DaDCFA3E3":{name:"Rubic",logo:"Rubic.svg",erc20:!0,symbol:"RBC",decimals:18},"0x3A880652F47bFaa771908C07Dd8673A787dAEd3A":{name:"DerivaDAO",logo:"DDX.svg",erc20:!0,symbol:"DDX",decimals:18},"0xbC396689893D065F41bc2C6EcbeE5e0085233447":{name:"Perpetual",logo:"PERP.svg",erc20:!0,symbol:"PERP",decimals:18},"0xeca82185adCE47f39c684352B0439f030f860318":{name:"Perlin",logo:"PERL.svg",erc20:!0,symbol:"PERL",decimals:18},"0xA1AFFfE3F4D611d252010E3EAf6f4D77088b0cd7":{name:"Reflect Finance",logo:"RFI.svg",erc20:!0,symbol:"RFI",decimals:9},"0xC0bA369c8Db6eB3924965e5c4FD0b4C1B91e305F":{name:"DLP Duck Token",logo:"dlpducktoken.svg",erc20:!0,symbol:"DUCK",decimals:18},"0xFbEEa1C75E4c4465CB2FCCc9c6d6afe984558E20":{name:"DuckDaoDime",logo:"ddim.svg",erc20:!0,symbol:"DDIM",decimals:18},"0x745407c86DF8DB893011912d3aB28e68B62E49B0":{name:"MahaDAO",logo:"MAHA.svg",erc20:!0,symbol:"MAHA",decimals:18},"0x8CC0F052fff7eaD7f2EdCCcaC895502E884a8a71":{name:"ARTH Valuecoin",logo:"ARTH.svg",erc20:!0,symbol:"ARTH",decimals:18},"0x3231Cb76718CDeF2155FC47b5286d82e6eDA273f":{name:"Monerium EUR",logo:"EURe.svg",erc20:!0,symbol:"EURe",decimals:18},"0x7ba92741Bf2A568abC6f1D3413c58c6e0244F8fD":{name:"Monerium GBP",logo:"GBPe.svg",erc20:!0,symbol:"GBPe",decimals:18},"0xBc5142e0CC5eB16b47c63B0f033d4c2480853a52":{name:"Monerium USD",logo:"USDe.svg",erc20:!0,symbol:"USDe",decimals:18},"0xC642549743A93674cf38D6431f75d6443F88E3E2":{name:"Monerium ISK",logo:"ISKe.svg",erc20:!0,symbol:"ISKe",decimals:18},"0x66a0f676479Cee1d7373f3DC2e2952778BfF5bd6":{name:"WISE Token",logo:"wise.svg",erc20:!0,symbol:"WISE",decimals:18},"0x72F020f8f3E8fd9382705723Cd26380f8D0c66Bb":{name:"PlotX",logo:"plotx.svg",erc20:!0,symbol:"PLOT",decimals:18},"0x44197A4c44D6A059297cAf6be4F7e172BD56Caaf":{name:"ELTCOIN",logo:"ELTCOIN.svg",erc20:!0,symbol:"ELT",decimals:8},"0x6781a0F84c7E9e846DCb84A9a5bd49333067b104":{name:"ZAP TOKEN",logo:"zapicon.svg",erc20:!0,symbol:"ZAP",decimals:18},"0x00c83aeCC790e8a4453e5dD3B0B4b3680501a7A7":{name:"SKALE",logo:"skl.svg",erc20:!0,symbol:"SKL",decimals:18},"0x674C6Ad92Fd080e4004b2312b45f796a192D27a0":{name:"Neutrino USD",logo:"usdn.svg",erc20:!0,symbol:"USDN",decimals:18},"0xE5CAeF4Af8780E59Df925470b050Fb23C43CA68C":{name:"Ferrum Network Token",logo:"frm.svg",erc20:!0,symbol:"FRM",decimals:6},"0x998FFE1E43fAcffb941dc337dD0468d52bA5b48A":{name:"Rupiah Token",logo:"idrt.svg",erc20:!0,symbol:"IDRT",decimals:2},"0x4E15361FD6b4BB609Fa63C81A2be19d873717870":{name:"Fantom",logo:"ftm.svg",erc20:!0,symbol:"FTM",decimals:18},"0x557B933a7C2c45672B610F8954A3deB39a51A8Ca":{name:"REVV",logo:"revv.svg",erc20:!0,symbol:"REVV",decimals:18},"0xFFC97d72E13E01096502Cb8Eb52dEe56f74DAD7B":{name:"Aave AAVE",logo:"aAAVE.svg",erc20:!0,symbol:"aAAVE",decimals:18},"0x05Ec93c0365baAeAbF7AefFb0972ea7ECdD39CF1":{name:"Aave BAT",logo:"aBAT.svg",erc20:!0,symbol:"aBAT",decimals:18},"0xA361718326c15715591c299427c62086F69923D9":{name:"Aave BUSD",logo:"aBUSD.svg",erc20:!0,symbol:"aBUSD",decimals:18},"0x028171bCA77440897B824Ca71D1c56caC55b68A3":{name:"Aave DAI",logo:"aDAI.svg",erc20:!0,symbol:"aDAI",decimals:18},"0xaC6Df26a590F08dcC95D5a4705ae8abbc88509Ef":{name:"Aave ENJ",logo:"aENJ.svg",erc20:!0,symbol:"aENJ",decimals:18},"0xD37EE7e4f452C6638c96536e68090De8cBcdb583":{name:"Aave GUSD",logo:"aGUSD.svg",erc20:!0,symbol:"aGUSD",decimals:2},"0x39C6b3e42d6A679d7D776778Fe880BC9487C2EDA":{name:"Aave KNC",logo:"aKNC.svg",erc20:!0,symbol:"aKNC",decimals:18},"0xa06bC25B5805d5F8d82847D191Cb4Af5A3e873E0":{name:"Aave LINK",logo:"aLINK.svg",erc20:!0,symbol:"aLINK",decimals:18},"0xa685a61171bb30d4072B338c80Cb7b2c865c873E":{name:"Aave MANA",logo:"aMANA.svg",erc20:!0,symbol:"aMANA",decimals:18},"0xc713e5E149D5D0715DcD1c156a020976e7E56B88":{name:"Aave MKR",logo:"aMKR.svg",erc20:!0,symbol:"aMKR",decimals:18},"0xCC12AbE4ff81c9378D670De1b57F8e0Dd228D77a":{name:"Aave REN",logo:"aREN.svg",erc20:!0,symbol:"aREN",decimals:18},"0x35f6B052C598d933D69A4EEC4D04c73A191fE6c2":{name:"Aave SNX",logo:"aSNX.svg",erc20:!0,symbol:"aSNX",decimals:18},"0x6C5024Cd4F8A59110119C56f8933403A539555EB":{name:"Aave SUSD",logo:"aSUSD.svg",erc20:!0,symbol:"aSUSD",decimals:18},"0x101cc05f4A51C0319f570d5E146a8C625198e636":{name:"Aave TUSD",logo:"aTUSD.svg",erc20:!0,symbol:"aTUSD",decimals:18},"0xB9D7CB55f463405CDfBe4E90a6D2Df01C2B92BF1":{name:"Aave UNI",logo:"aUNI.svg",erc20:!0,symbol:"aUNI",decimals:18},"0xBcca60bB61934080951369a648Fb03DF4F96263C":{name:"Aave USDC",logo:"aUSDC.svg",erc20:!0,symbol:"aUSDC",decimals:6},"0x3Ed3B47Dd13EC9a98b44e6204A523E766B225811":{name:"Aave USDT",logo:"aUSDT.svg",erc20:!0,symbol:"aUSDT",decimals:6},"0x9ff58f4fFB29fA2266Ab25e75e2A8b3503311656":{name:"Aave WBTC",logo:"aWBTC.svg",erc20:!0,symbol:"aWBTC",decimals:8},"0x030bA81f1c18d280636F32af80b9AAd02Cf0854e":{name:"Aave WETH",logo:"aWETH.svg",erc20:!0,symbol:"aWETH",decimals:18},"0x5165d24277cD063F5ac44Efd447B27025e888f37":{name:"Aave YFI",logo:"aYFI.svg",erc20:!0,symbol:"aYFI",decimals:18},"0xdef1fac7Bf08f173D286BbBDcBeeADe695129840":{name:"Defi Factory Token",logo:"DEFT.svg",erc20:!0,symbol:"DEFT",decimals:18},"0xDf7FF54aAcAcbFf42dfe29DD6144A69b629f8C9e":{name:"Aave ZRX",logo:"aZRX.svg",erc20:!0,symbol:"aZRX",decimals:18},"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9":{name:"Aave",logo:"AAVE.svg",erc20:!0,symbol:"AAVE",decimals:18},"0x44e2deC86B9F0e0266E9AA66e10323A2bd69CF9A":{name:"Attrace",logo:"attr.svg",erc20:!0,symbol:"ATTR",decimals:18},"0x1Da87b114f35E1DC91F72bF57fc07A768Ad40Bb0":{name:"Equalizer",logo:"EQZ.svg",erc20:!0,symbol:"EQZ",decimals:18},"0x4da27a545c0c5B758a6BA100e3a049001de870f5":{name:"Staked Aave",logo:"stkAAVE.svg",erc20:!0,symbol:"stAAVE",decimals:18},"0xba9d4199faB4f26eFE3551D490E3821486f135Ba":{name:"SwissBorg",logo:"chsb.svg",erc20:!0,symbol:"CHSB",decimals:8},"0x7DD9c5Cba05E151C895FDe1CF355C9A1D5DA6429":{name:"Golem Network Token",logo:"glm.svg",erc20:!0,symbol:"GLM",decimals:18},"0x7240aC91f01233BaAf8b064248E80feaA5912BA3":{name:"OctoFi",logo:"octo.svg",erc20:!0,symbol:"OCTO",decimals:18},"0xff56Cc6b1E6dEd347aA0B7676C85AB0B3D08B0FA":{name:"Orbs",logo:"orbs.svg",erc20:!0,symbol:"ORBS",decimals:18},"0x63f88A2298a5c4AEE3c216Aa6D926B184a4b2437":{name:"GAME Credits",logo:"GAMECreditsLogo.svg",erc20:!0,symbol:"GAME",decimals:18},"0x5150956E082C748Ca837a5dFa0a7C10CA4697f9c":{name:"Zeedex",logo:"zdex.svg",erc20:!0,symbol:"ZDEX",decimals:18},"0x84cA8bc7997272c7CfB4D0Cd3D55cd942B3c9419":{name:"DIAdata",logo:"dia.svg",erc20:!0,symbol:"DIA",decimals:18},"0xb78B3320493a4EFaa1028130C5Ba26f0B6085Ef8":{name:"Dracula",logo:"dracula.svg",erc20:!0,symbol:"DRC",decimals:18},"0xF433089366899D83a9f26A773D59ec7eCF30355e":{name:"Metal",logo:"mtl.svg",erc20:!0,symbol:"MTL",decimals:8},"0x85Eee30c52B0b379b046Fb0F85F4f3Dc3009aFEC":{name:"KEEP",logo:"keep.svg",erc20:!0,symbol:"KEEP",decimals:18},"0x8dAEBADE922dF735c38C80C7eBD708Af50815fAa":{name:"tBTC",logo:"tbtc.svg",erc20:!0,symbol:"TBTC",decimals:18},"0xD7EFB00d12C2c13131FD319336Fdf952525dA2af":{name:"Proton",logo:"proton.svg",erc20:!0,symbol:"XPR",decimals:4},"0x178c820f862B14f316509ec36b13123DA19A6054":{name:"Energy Web Token Bridged",logo:"ewtb.svg",erc20:!0,symbol:"EWTB",decimals:18},"0x2b591e99afE9f32eAA6214f7B7629768c40Eeb39":{name:"HEX",logo:"hex.svg",erc20:!0,symbol:"HEX",decimals:8},"0xFca59Cd816aB1eaD66534D82bc21E7515cE441CF":{name:"Rarible",logo:"rari.svg",erc20:!0,symbol:"RARI",decimals:18},"0x7865af71cf0b288b4E7F654f4F7851EB46a2B7F8":{name:"Sentivate",logo:"sentivate.svg",erc20:!0,symbol:"SNTVT",decimals:18},"0xa3d58c4E56fedCae3a7c43A725aeE9A71F0ece4e":{name:"Metronome",logo:"metronome.svg",erc20:!0,symbol:"MET",decimals:18},"0x49d716DFe60b37379010A75329ae09428f17118d":{name:"PoolTogether Dai",logo:"pldai.svg",erc20:!0,symbol:"PLDAI",decimals:18},"0xfE6892654CBB05eB73d28DCc1Ff938f59666Fe9f":{name:"PoolTogether Sai",logo:"plsai.svg",erc20:!0,symbol:"PLSAI",decimals:18},"0x5732046A883704404F284Ce41FfADd5b007FD668":{name:"Bluzelle Token",logo:"Bluzelle.svg",erc20:!0,symbol:"BLZ",decimals:18},"0xBD87447F48ad729C5c4b8bcb503e1395F62e8B98":{name:"PoolTogether USDC",logo:"plusdc.svg",erc20:!0,symbol:"PLUSDC",decimals:6},"0x69A95185ee2a045CDC4bCd1b1Df10710395e4e23":{name:"$Poolz Finance",logo:"Poolz.svg",erc20:!0,symbol:"POOLZ",decimals:18},"0x0adA190c81b814548ddC2F6AdC4a689ce7C1FE73":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAXIS",decimals:18},"0xb1dC9124c395c1e97773ab855d66E879f053A289":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAX",decimals:18},"0xeF31Cb88048416E301Fee1eA13e7664b887BA7e8":{name:"Staked yAxis",logo:"yaxis.svg",erc20:!0,symbol:"sYAX",decimals:18},"0x28cb7e841ee97947a86B06fA4090C8451f64c0be":{name:"YF Link",logo:"YFL.svg",erc20:!0,symbol:"YFL",decimals:18},"0x75D1aA733920b14fC74c9F6e6faB7ac1EcE8482E":{name:"YFLink Staking Share",logo:"YFL.svg",erc20:!0,symbol:"yYFL",decimals:18},"0x7b760D06E401f85545F3B50c44bf5B05308b7b62":{name:"YFLink USD",logo:"YFLUSD.svg",erc20:!0,symbol:"YFLUSD",decimals:18},"0x8282df223AC402d04B2097d16f758Af4F70e7Db0":{name:"YFLink Synthetic",logo:"sYFL.svg",erc20:!0,symbol:"sYFL",decimals:18},"0x008377EB0C62cE8e0BA3D7Bb4A5638591f21588E":{name:"YFLink Bond",logo:"bYFL.svg",erc20:!0,symbol:"bYFL",decimals:18},"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e":{name:"yearn.finance",logo:"yfi.svg",erc20:!0,symbol:"YFI",decimals:18},"0x261b45D85cCFeAbb11F022eBa346ee8D1cd488c0":{name:"rDAI",logo:"rdai.svg",erc20:!0,symbol:"rDAI",decimals:18},"0xea8b224eDD3e342DEb514C4176c2E72Bcce6fFF9":{name:"rSAI",logo:"rsai.svg",erc20:!0,symbol:"rSAI",decimals:18},"0x12B19D3e2ccc14Da04FAe33e63652ce469b3F2FD":{name:"GridPlus",logo:"GridPlus.svg",erc20:!0,symbol:"GRID",decimals:12},"0xDb05EA0877A2622883941b939f0bb11d1ac7c400":{name:"Opacity",logo:"opct.svg",erc20:!0,symbol:"OPCT",decimals:18},"0x4575f41308EC1483f3d399aa9a2826d74Da13Deb":{name:"Orchid",logo:"OXT.svg",erc20:!0,symbol:"OXT",decimals:18},"0x4CC19356f2D37338b9802aa8E8fc58B0373296E7":{name:"Selfkey",logo:"KEY.svg",erc20:!0,symbol:"KEY",decimals:18},"0x92A5B04D0ED5D94D7a193d1d334D3D16996f4E13":{name:"Eristica",logo:"Eristica.svg",erc20:!0,symbol:"ERT",decimals:18},"0xdAC17F958D2ee523a2206206994597C13D831ec7":{name:"Tether USD",logo:"usdt.svg",erc20:!0,symbol:"USDT",decimals:6},"0x06AF07097C9Eeb7fD685c692751D5C66dB49c215":{name:"Chai",logo:"CHAI.svg",erc20:!0,symbol:"CHAI",decimals:18},"0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828":{name:"UMA",logo:"uma.svg",erc20:!0,symbol:"UMA",decimals:18},"0x5f778ec4B31a506c1Dfd8b06F131E9B451a61D39":{name:"UPX Token",logo:"UPX.svg",erc20:!0,symbol:"UPX",decimals:18},"0xb1CD6e4153B2a390Cf00A6556b0fC1458C4A5533":{name:"ETHBNT Liquidity Pool",logo:"ETHBNT.svg",erc20:!0,symbol:"ETHBNT",decimals:18},"0xf0Ee6b27b759C9893Ce4f094b49ad28fd15A23e4":{name:"Enigma",logo:"enigma.svg",erc20:!0,symbol:"ENG",decimals:8},"0xaaAEBE6Fe48E54f431b0C390CfaF0b017d09D42d":{name:"Celsius",logo:"celsius.svg",erc20:!0,symbol:"CEL",decimals:4},"0xb683D83a532e2Cb7DFa5275eED3698436371cc9f":{name:"BTU",logo:"BTU.svg",erc20:!0,symbol:"BTU",decimals:18},"0x746DdA2ea243400D5a63e0700F190aB79f06489e":{name:"BOSAGORA",logo:"BOA.svg",erc20:!0,symbol:"BOA",decimals:7},"0x5D858bcd53E085920620549214a8b27CE2f04670":{name:"POP Network Token",logo:"POP.svg",erc20:!0,symbol:"POP",decimals:18},"0x048Fe49BE32adfC9ED68C37D32B5ec9Df17b3603":{name:"Skrumble Network V2",logo:"skm.svg",erc20:!0,symbol:"SKM",decimals:18},"0x16EA01aCB4b0Bca2000ee5473348B6937ee6f72F":{name:"Enecuum",logo:"ENQ-logo.svg",erc20:!0,symbol:"ENQ",decimals:10},"0xE5B826Ca2Ca02F09c1725e9bd98d9a8874C30532":{name:"ZEON Network",logo:"ZEON_logo.png",erc20:!0,symbol:"ZEON",decimals:18},"0x13cb85823f78Cff38f0B0E90D3e975b8CB3AAd64":{name:"REMIIT REMI Token",logo:"remi.svg",erc20:!0,symbol:"REMI",decimals:18},"0x93a7174dafd31d13400cD9fa01f4e5B5BAa00D39":{name:"Shaka",logo:"hak.svg",erc20:!0,symbol:"HAK",decimals:18},"0x6fB3e0A217407EFFf7Ca062D46c26E5d60a14d69":{name:"IoTeX",logo:"iotex.svg",erc20:!0,symbol:"IOTX",decimals:18},"0xE5a3229CCb22b6484594973A03a3851dCd948756":{name:"RAE Token",logo:"rae.svg",erc20:!0,symbol:"RAE",decimals:18},"0x4470BB87d77b963A013DB939BE332f927f2b992e":{name:"AdEx Legacy Token",logo:"adex.svg",erc20:!0,symbol:"ADXL",decimals:4},"0xADE00C28244d5CE17D72E40330B1c318cD12B7c3":{name:"AdEx Token",logo:"adex.svg",erc20:!0,symbol:"ADX",decimals:18},"0xDc5864eDe28BD4405aa04d93E05A0531797D9D59":{name:"Falcon",logo:"fnt.svg",erc20:!0,symbol:"FNT",decimals:6},"0x1966d718A565566e8E202792658D7b5Ff4ECe469":{name:"nDEX",logo:"nDEX.png",erc20:!0,symbol:"NDX",decimals:18},"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599":{name:"Wrapped BTC",logo:"wbtc.svg",erc20:!0,symbol:"WBTC",decimals:8},"0x150b0b96933B75Ce27af8b92441F8fB683bF9739":{name:"Dragonereum Gold",logo:"gold.svg",erc20:!0,symbol:"GOLD",decimals:18},"0x82f4dED9Cec9B5750FBFf5C2185AEe35AfC16587":{name:"DreamTeam Token",logo:"dream.svg",erc20:!0,symbol:"DREAM",decimals:6},"0x5d60d8d7eF6d37E16EBABc324de3bE57f135e0BC":{name:"MyBit",logo:"MYB.svg",erc20:!0,symbol:"MYB",decimals:18},"0x01FA555c97D7958Fa6f771f3BbD5CCD508f81e22":{name:"Civil Token",logo:"CVL_token.svg",erc20:!0,symbol:"CVL",decimals:18},"0x5adc961D6AC3f7062D2eA45FEFB8D8167d44b190":{name:"Dether",logo:"dether.svg",erc20:!0,symbol:"DTH",decimals:18},"0x3F17Dd476faF0a4855572F0B6ed5115D9bBA22AD":{name:"Wibson",logo:"wibson-logo.png",erc20:!0,symbol:"WIB",decimals:9},"0xDF347911910b6c9A4286bA8E2EE5ea4a39eB2134":{name:"Bob's Repair",logo:"bobsrepair.png",erc20:!0,symbol:"BOB",decimals:18},"0x3505F494c3f0fed0B594E01Fa41Dd3967645ca39":{name:"SWARM",logo:"swarm.svg",erc20:!0,symbol:"SWM",decimals:18},"0x6863bE0e7CF7ce860A574760e9020D519a8bDC47":{name:"On.Live",logo:"onlive.svg",erc20:!0,symbol:"ONL",decimals:18},"0xea5f88E54d982Cbb0c441cde4E79bC305e5b43Bc":{name:"Pareto",logo:"ParetoLogo.png",erc20:!0,symbol:"PARETO",decimals:18},"0x2e91E3e54C5788e9FdD6A181497FDcEa1De1bcc1":{name:"Hercules",logo:"herc.png",erc20:!0,symbol:"HERC",decimals:18},"0x4946Fcea7C692606e8908002e55A582af44AC121":{name:"FOAM",logo:"FOAM.svg",erc20:!0,symbol:"FOAM",decimals:18},"0x4D807509aECe24C0fa5A102b6a3B059Ec6E14392":{name:"Menlo One",logo:"Menlo_One.png",erc20:!0,symbol:"ONE",decimals:18},"0x27054b13b1B798B345b591a4d22e6562d47eA75a":{name:"AirSwap Token",logo:"AirSwapLogo.svg",erc20:!0,symbol:"AST",decimals:4},"0x8D5682941cE456900b12d47ac06a88b47C764CE1":{name:"RightMesh Token",logo:"Rmesh.png",erc20:!0,symbol:"RMESH",decimals:18},"0xDDe12a12A6f67156e0DA672be05c374e1B0a3e57":{name:"JOYSO",logo:"JOY.png",erc20:!0,symbol:"JOY",decimals:6},"0x0D262e5dC4A06a0F1c90cE79C7a60C09DfC884E4":{name:"JET8 Token",logo:"J8T.svg",erc20:!0,symbol:"J8T",decimals:8},"0x4a220E6096B25EADb88358cb44068A3248254675":{name:"Quant Network",logo:"quant-network.svg",erc20:!0,symbol:"QNT",decimals:18},"0xBC86727E770de68B1060C91f6BB6945c73e10388":{name:"Ink Protocol",logo:"ink_protocol.svg",erc20:!0,symbol:"XNK",decimals:18},"0xa95592DCFfA3C080B4B40E459c5f5692F67DB7F8":{name:"ELY Token",logo:"ely.png",erc20:!0,symbol:"ELY",decimals:18},"0x9E46A38F5DaaBe8683E10793b06749EEF7D733d1":{name:"PolySwarm Nectar",logo:"polyswarm_nectar.svg",erc20:!0,symbol:"NCT",decimals:18},"0xe1A178B681BD05964d3e3Ed33AE731577d9d96dD":{name:"BOX Token",logo:"box_token.png",erc20:!0,symbol:"BOX",decimals:18},"0x543Ff227F64Aa17eA132Bf9886cAb5DB55DCAddf":{name:"DAOstack",logo:"gen.svg",erc20:!0,symbol:"GEN",decimals:18},"0x6aEDbF8dFF31437220dF351950Ba2a3362168d1b":{name:"Dragonglass",logo:"dragonglass.svg",erc20:!0,symbol:"DGS",decimals:8},"0xd26114cd6EE289AccF82350c8d8487fedB8A0C07":{name:"OmiseGO",logo:"omg.svg",erc20:!0,symbol:"OMG",decimals:18},"0x99ea4dB9EE77ACD40B119BD1dC4E33e1C070b80d":{name:"Quantstamp",logo:"qsp.svg",erc20:!0,symbol:"QSP",decimals:18},"0xB64ef51C888972c908CFacf59B47C1AfBC0Ab8aC":{name:"Storj",logo:"storj.svg",erc20:!0,symbol:"STORJ",decimals:8},"0xD8E3FB3b08eBA982F2754988d70D57eDc0055ae6":{name:"Zoracles",logo:"zora.svg",erc20:!0,symbol:"ZORA",decimals:9},"0xF938424F7210f31dF2Aee3011291b658f872e91e":{name:"VISOR",logo:"VISR.svg",erc20:!0,symbol:"VISR",decimals:18},"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942":{name:"Decentraland",logo:"mana.svg",erc20:!0,symbol:"MANA",decimals:18},"0x0F513fFb4926ff82D7F60A05069047AcA295C413":{name:"CrowdstartCoin",logo:"XSC_Logo.svg",erc20:!0,symbol:"XSC",decimals:18},"0x5BC7e5f0Ab8b2E10D2D0a3F21739FCe62459aeF3":{name:"Hut34 Entropy Token",logo:"ENTRP.png",symbol:"ENTRP",erc20:!0,decimals:18},"0x946112efaB61C3636CBD52DE2E1392D7A75A6f01":{name:"HYDRO TOKEN",logo:"hydro.svg",erc20:!0,symbol:"HYDRO",decimals:18},"0x2604FA406Be957E542BEb89E6754fCdE6815e83f":{name:"Playkey Token",logo:"playkey.svg",erc20:!0,symbol:"PKT",decimals:18},"0xE41d2489571d322189246DaFA5ebDe1F4699F498":{name:"0x",logo:"zrx.svg",erc20:!0,symbol:"ZRX",decimals:18},"0x957c30aB0426e0C93CD8241E2c60392d08c6aC8e":{name:"Modum Token",logo:"modum.svg",erc20:!0,symbol:"MOD",decimals:0},"0x1a7a8BD9106F2B8D977E08582DC7d24c723ab0DB":{name:"AppCoins",logo:"appc.svg",erc20:!0,decimals:18,symbol:"APPC"},"0xdB25f211AB05b1c97D595516F45794528a807ad8":{name:"STASIS EURS Token",logo:"stasis-eurs.svg",erc20:!0,decimals:2,symbol:"EURS"},"0xCA0e7269600d353F70b14Ad118A49575455C0f2f":{name:"AMLT",logo:"amlt.png",erc20:!0,decimals:18,symbol:"AMLT"},"0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F":{name:"Synthetix Network Token",logo:"synthetix.svg",erc20:!0,decimals:18,symbol:"SNX"},"0x57Ab1ec28D129707052df4dF418D58a2D46d5f51":{name:"Synth sUSD",logo:"synthetix_susd.svg",erc20:!0,decimals:18,symbol:"SUSD"},"0x5e74C9036fb86BD7eCdcb084a0673EFc32eA31cb":{name:"Synth sETH",logo:"synthetix_seth.svg",erc20:!0,decimals:18,symbol:"SETH"},"0xfE18be6b3Bd88A2D2A7f928d00292E7a9963CfC6":{name:"Synth sBTC",logo:"synthetix_sbtc.svg",erc20:!0,decimals:18,symbol:"SBTC"},"0x0DB8D8b76BC361bAcbB72E2C491E06085A97Ab31":{name:"IQeon",logo:"iqeon.svg",erc20:!0,decimals:18,symbol:"IQN"},"0x000C100050E98C91f9114fa5Dd75CE6869Bf4F53":{name:"CRYPTO10 Hedged",logo:"c10.svg",erc20:!0,symbol:"C10",decimals:18},"0x26E75307Fc0C021472fEb8F727839531F112f317":{name:"Crypto20",logo:"c20.svg",erc20:!0,symbol:"C20",decimals:18},"0x06012c8cf97BEaD5deAe237070F9587f8E7A266d":{name:"Crypto Kitties",logo:"ck.svg",erc20:!1,erc721:!0,symbol:"CK",decimals:0},"0xE477292f1B3268687A29376116B0ED27A9c76170":{name:"Herocoin",logo:"herocoin_logo.png",erc20:!0,symbol:"PLAY",decimals:18},"0x4F4f0Db4de903B88f2B1a2847971E231D54F8fd3":{name:"Geens Platform Token",logo:"gee-icon.svg",erc20:!0,symbol:"GEE",decimals:8},"0xec67005c4E498Ec7f55E092bd1d35cbC47C91892":{name:"Enzyme Finance",logo:"mln.svg",erc20:!0,symbol:"MLN",decimals:18},"0xba2184520A1cC49a6159c57e61E1844E085615B6":{name:"HelloGold Token",logo:"hgt.png",erc20:!0,symbol:"HGT",decimals:8},"0xba358B6f5b4c0215650444B8C30D870B55050D2D":{name:"Hub Token",logo:"hub.svg",erc20:!0,symbol:"HUB",decimals:18},"0x8727c112C712c4a03371AC87a74dD6aB104Af768":{name:"Jetcoin Institute Token",logo:"JETCOIN28.png",erc20:!0,symbol:"JET",decimals:18},"0xf8e386EDa857484f5a12e4B5DAa9984E06E73705":{name:"Indorse Token",logo:"indorseLogo.jpg",erc20:!0,symbol:"IND",decimals:18},"0xA54ddC7B3CcE7FC8b1E3Fa0256D0DB80D2c10970":{name:"NEVERDIE Coin",logo:"ndc.png",erc20:!0,symbol:"NDC",decimals:18},"0x1c4481750daa5Ff521A2a7490d9981eD46465Dbd":{name:"BlockMason Credit Protocol Token",logo:"bcpt.svg",erc20:!0,symbol:"BCPT",decimals:18},"0x20F7A3DdF244dc9299975b4Da1C39F8D5D75f05A":{name:"Sapien Network Token",logo:"spn.svg",erc20:!0,symbol:"SPN",decimals:6},"0xA4e8C3Ec456107eA67d3075bF9e3DF3A75823DB0":{name:"Loom Token",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x42476F744292107e34519F9c357927074Ea3F75D":{name:"Loom",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x4F9254C83EB525f9FCf346490bbb3ed28a81C667":{name:"Celer Network Token",logo:"CELR.svg",erc20:!0,symbol:"CELR",decimals:18},"0x71D01dB8d6a2fBEa7f8d434599C237980C234e4C":{name:"Gladius",logo:"gladius.svg",erc20:!0,symbol:"GLA",decimals:8},"0xdd974D5C2e2928deA5F71b9825b8b646686BD200":{name:"Kyber Network Crystal",logo:"kyber.svg",erc20:!0,symbol:"KNC",decimals:18},"0x1F573D6Fb3F13d689FF844B4cE37794d79a7FF1C":{name:"Bancor Network Token",logo:"bnt.svg",erc20:!0,symbol:"BNT",decimals:18},"0xfa05A73FfE78ef8f1a739473e462c54bae6567D9":{name:"Lunyr Token",logo:"lun.svg",erc20:!0,symbol:"LUN",decimals:18},"0xC741f06082AA47F93729070aD0dD95E223Bda091":{name:"LEDU Token",logo:"edu.svg",erc20:!0,symbol:"LEDU",decimals:8},"0x5c543e7AE0A1104f78406C340E9C64FD9fCE5170":{name:"vSlice",logo:"vslice.png",erc20:!0,symbol:"VSL",decimals:18},"0x1f41E42D0a9e3c0Dd3BA15B527342783B43200A9":{name:"Blockchain Capital",logo:"bcap.svg",erc20:!0,symbol:"BCAP",decimals:0},"0x6531f133e6DeeBe7F2dcE5A0441aA7ef330B4e53":{name:"Chronobank TIME",logo:"chronobank.png",erc20:!0,symbol:"TIME",decimals:8},"0xaAAf91D9b90dF800Df4F55c205fd6989c977E73a":{name:"Monolith TKN",logo:"tkn.svg",erc20:!0,symbol:"TKN",decimals:8},"0x08711D3B02C8758F2FB3ab4e80228418a7F8e39c":{name:"Edgeless",logo:"edg.svg",erc20:!0,symbol:"EDG",decimals:0},"0xf7B098298f7C69Fc14610bf71d5e02c60792894C":{name:"Guppy",logo:"guppy.png",erc20:!0,symbol:"GUP",decimals:3},"0x4DF812F6064def1e5e029f1ca858777CC98D2D81":{name:"Xaurum",logo:"xaurum_logo.svg",erc20:!0,symbol:"XAUR",decimals:8},"0xB9e7F8568e08d5659f5D29C4997173d84CdF2607":{name:"Swarm City Token",logo:"swt.svg",erc20:!0,symbol:"SWT",decimals:18},"0xCb94be6f13A1182E4A4B6140cb7bf2025d28e41B":{name:"Trustcoin",logo:"trst.svg",erc20:!0,symbol:"TRST",decimals:6},"0xCB56b52316041A62B6b5D0583DcE4A8AE7a3C629":{name:"Cigarettes",logo:"cig.svg",erc20:!0,symbol:"CIG",decimals:18},"0x960b236A07cf122663c4303350609A66A7B288C0":{name:"Aragon Network Token v1",logo:"antv1.svg",erc20:!0,symbol:"ANTv1",decimals:18},"0x667088b212ce3d06a1b553a7221E1fD19000d9aF":{name:"WINGS",logo:"wings_logo.svg",erc20:!0,symbol:"WINGS",decimals:18},"0x16484d73Ac08d2355F466d448D2b79D2039F6EBB":{name:"FortKnoxster",logo:"FortKnoxster.svg",erc20:!0,symbol:"FKX",decimals:18},"0xAf30D2a7E90d7DC361c8C4585e9BB7D2F6f15bc7":{name:"FirstBlood Token",logo:"1st.svg",erc20:!0,symbol:"1ST",decimals:18},"0x607F4C5BB672230e8672085532f7e901544a7375":{name:"iExec RLC Token",logo:"rlc.svg",erc20:!0,symbol:"RLC",decimals:9},"0xaeC2E87E0A235266D9C5ADc9DEb4b2E29b54D009":{name:"SingularDTV",logo:"singulardtv.svg",erc20:!0,symbol:"SNGLS",decimals:0},"0x888666CA69E0f178DED6D75b5726Cee99A87D698":{name:"ICONOMI",logo:"iconomi.png",erc20:!0,symbol:"ICN",decimals:18},"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2":{name:"Maker",logo:"mkr.svg",erc20:!0,symbol:"MKR",decimals:18},"0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359":{name:"Sai Stablecoin v1.0",logo:"sai.svg",erc20:!0,symbol:"SAI",decimals:18},"0x6B175474E89094C44Da98b954EedeAC495271d0F":{name:"Dai Stablecoin",logo:"dai.svg",erc20:!0,symbol:"DAI",decimals:18},"0xC477D038d5420C6A9e0b031712f61c5120090de9":{name:"Boson Token",logo:"boson.svg",erc20:!0,symbol:"BOSON",decimals:18},"0xD46bA6D942050d489DBd938a2C909A5d5039A161":{name:"Ampleforth",logo:"ampl.svg",erc20:!0,symbol:"AMPL",decimals:9},"0x4b9278b94a1112cAD404048903b8d343a810B07e":{name:"Hifi Finance",logo:"hifi.svg",erc20:!0,symbol:"HIFI",decimals:18},"0x0D8775F648430679A709E98d2b0Cb6250d2887EF":{name:"Basic Attention Token",logo:"bat.svg",erc20:!0,symbol:"BAT",decimals:18},"0x4D8fc1453a0F359e99c9675954e656D80d996FbF":{name:"BEE Token",logo:"bee_token.svg",erc20:!0,symbol:"BEE",decimals:18},"0x6810e776880C02933D47DB1b9fc05908e5386b96":{name:"Gnosis Token",logo:"gnosis.svg",erc20:!0,symbol:"GNO",decimals:18},"0x514910771AF9Ca656af840dff83E8264EcF986CA":{name:"Chainlink Token",logo:"chainlink.svg",erc20:!0,symbol:"LINK",decimals:18},"0xD8912C10681D8B21Fd3742244f44658dBA12264E":{name:"Pluton",logo:"plutus-god.svg",erc20:!0,symbol:"PLU",decimals:18},"0x1985365e9f78359a9B6AD760e32412f4a445E862":{name:"Reputation Old",logo:"rep.svg",erc20:!0,symbol:"REP",decimals:18},"0x221657776846890989a759BA2973e427DfF5C9bB":{name:"Reputation",logo:"repv2.svg",erc20:!0,symbol:"REPv2",decimals:18},"0xd0929d411954c47438dc1d871dd6081F5C5e149c":{name:"Refereum",logo:"rfr.svg",erc20:!0,symbol:"RFR",decimals:4},"0xb0866289e870D2efc282406cF4123Df6E5BcB652":{name:"NoFakeCoin",logo:"nfticon.png",erc20:!0,symbol:"NFC",decimals:18},"0x2C4e8f2D746113d0696cE89B35F0d8bF88E0AEcA":{name:"Open Simple Token",logo:"OST.svg",erc20:!0,symbol:"OST",decimals:18},"0x408e41876cCCDC0F92210600ef50372656052a38":{name:"Republic Token",logo:"ren.svg",erc20:!0,symbol:"REN",decimals:18},"0xEB4C2781e4ebA804CE9a9803C67d0893436bB27D":{name:"renBTC",logo:"renBTC.svg",erc20:!0,symbol:"renBTC",decimals:8},"0x1C5db575E2Ff833E46a2E9864C22F4B22E0B37C2":{name:"renZEC",logo:"renZEC.svg",erc20:!0,symbol:"renZEC",decimals:8},"0x459086F2376525BdCebA5bDDA135e4E9d3FeF5bf":{name:"renBCH",logo:"renBCH.svg",erc20:!0,symbol:"renBCH",decimals:8},"0xD5147bc8e386d91Cc5DBE72099DAC6C9b99276F5":{name:"renFIL",logo:"renFIL.svg",erc20:!0,symbol:"renFIL",decimals:18},"0xa74476443119A942dE498590Fe1f2454d7D4aC0d":{name:"Golem Network Token",logo:"golem.svg",erc20:!0,symbol:"GNT",decimals:18},"0x6888a16eA9792c15A4DCF2f6C623D055c8eDe792":{name:"Spectiv Signal Token",logo:"spectiv.svg",erc20:!0,symbol:"SIG",decimals:18},"0x9a642d6b3368ddc662CA244bAdf32cDA716005BC":{name:"Qtum",logo:"qtum.svg",erc20:!0,decimals:18,symbol:"QTUM"},"0x1234567461d3f8Db7496581774Bd869C83D51c93":{name:"BitClave",logo:"bitclave.svg",erc20:!0,decimals:18,symbol:"CAT"},"0x7d4b8Cce0591C9044a22ee543533b72E976E36C3":{name:"Change",logo:"change.svg",erc20:!0,decimals:18,symbol:"CAG"},"0x1d462414fe14cf489c7A21CaC78509f4bF8CD7c0":{name:"CanYaCoin",logo:"CanYa.svg",erc20:!0,decimals:6,symbol:"CAN"},"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72":{name:"Ethereum Name Service",logo:"ens.svg",erc20:!0,decimals:18,symbol:"ENS"},"0x3d1BA9be9f66B8ee101911bC36D3fB562eaC2244":{name:"Rivetz",logo:"rivetz.png",erc20:!0,decimals:18,symbol:"RVT"},"0x056017c55aE7AE32d12AeF7C679dF83A85ca75Ff":{name:"Project Wyvern Token",logo:"wyvern-logo.svg",erc20:!0,symbol:"WYV",decimals:18},"0xfec0cF7fE078a500abf15F1284958F22049c2C7e":{name:"Maecenas ART Token",logo:"art.svg",erc20:!0,symbol:"ART",decimals:18},"0x05f4a42e251f2d52b8ed15E9FEdAacFcEF1FAD27":{name:"Zilliqa",logo:"zilliqa.svg",erc20:!0,symbol:"ZIL",decimals:12},"0x986EE2B944c42D017F52Af21c4c69B84DBeA35d8":{name:"BitMartToken",logo:"bitmart.png",erc20:!0,symbol:"BMX",decimals:18},"0xF03f8D65BaFA598611C3495124093c56e8F638f0":{name:"Viewly",logo:"viewly.svg",erc20:!0,symbol:"VIEW",decimals:18},"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2":{name:"Wrapped Ether",logo:"weth.svg",erc20:!0,symbol:"WETH",decimals:18},"0xba5BDe662c17e2aDFF1075610382B9B691296350":{name:"SuperRare Token",logo:"rare.svg",erc20:!0,symbol:"RARE",decimals:18},"0x6C8c6b02E7b2BE14d4fA6022Dfd6d75921D90E4E":{name:"Compound Basic Attention Token",logo:"ctoken-bat.svg",erc20:!0,symbol:"cBAT",decimals:8},"0x70e36f6BF80a52b3B46b3aF8e106CC0ed743E8e4":{name:"Compound Collateral",logo:"ctoken-comp.svg",erc20:!0,symbol:"cCOMP",decimals:8},"0x5d3a536E4D6DbD6114cc1Ead35777bAB948E3643":{name:"Compound Dai",logo:"ctoken-dai.svg",erc20:!0,symbol:"cDAI",decimals:8},"0xF5DCe57282A584D2746FaF1593d3121Fcac444dC":{name:"Compound Sai (Legacy Dai)",logo:"ctoken-sai.svg",erc20:!0,symbol:"cSAI",decimals:8},"0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5":{name:"Compound Ether",logo:"ctoken-eth.svg",erc20:!0,symbol:"cETH",decimals:8},"0x158079Ee67Fce2f58472A96584A73C7Ab9AC95c1":{name:"Compound Augur",logo:"ctoken-rep.svg",erc20:!0,symbol:"cREP",decimals:8},"0x39AA39c021dfbaE8faC545936693aC917d5E7563":{name:"Compound USD Coin",logo:"ctoken-usdc.svg",erc20:!0,symbol:"cUSDC",decimals:8},"0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9":{name:"Compound Tether",logo:"ctoken-usdt.svg",erc20:!0,symbol:"cUSDT",decimals:8},"0xC11b1268C1A384e55C48c2391d8d480264A3A7F4":{name:"Compound Wrapped BTC",logo:"ctoken-wbtc.svg",erc20:!0,symbol:"cWBTC",decimals:8},"0xB3319f5D18Bc0D84dD1b4825Dcde5d5f7266d407":{name:"Compound 0x",logo:"ctoken-zrx.svg",erc20:!0,symbol:"cZRX",decimals:8},"0xc00e94Cb662C3520282E6f5717214004A7f26888":{name:"Compound",logo:"comp.svg",erc20:!0,symbol:"COMP",decimals:18},"0xFFE02ee4C69eDf1b340fCaD64fbd6b37a7b9e265":{name:"NANJCOIN",logo:"nanjcoin.svg",erc20:!0,symbol:"NANJ",decimals:8},"0xB6eD7644C69416d67B522e20bC294A9a9B405B31":{name:"0xBitcoin Token",logo:"0xbitcoin.svg",erc20:!0,symbol:"0xBTC",decimals:8},"0x744d70FDBE2Ba4CF95131626614a1763DF805B9E":{name:"Status Network Token",logo:"snt.svg",erc20:!0,symbol:"SNT",decimals:18},"0x42d6622deCe394b54999Fbd73D108123806f6a18":{name:"SPANK",logo:"spank.svg",erc20:!0,symbol:"SPANK",decimals:18},"0x6B01c3170ae1EFEBEe1a3159172CB3F7A5ECf9E5":{name:"BOOTY",logo:"booty.png",erc20:!0,symbol:"BOOTY",decimals:18},"0x4a6058666cf1057eaC3CD3A5a614620547559fc9":{name:"Brickblock",logo:"Brickblock.svg",erc20:!0,symbol:"BBK",decimals:18},"0x80fB784B7eD66730e8b1DBd9820aFD29931aab03":{name:"ETHLend Token",logo:"lend.svg",erc20:!0,symbol:"LEND",decimals:18},"0x48FF53777F747cFB694101222a944dE070c15D36":{name:"Ether Kingdoms Token",logo:"IMP.svg",erc20:!0,symbol:"IMP",decimals:7},"0x02F61Fd266DA6E8B102D4121f5CE7b992640CF98":{name:"LikeCoin",logo:"like.svg",erc20:!0,symbol:"LIKE",decimals:18},"0xB8c77482e45F1F44dE1745F52C74426C631bDD52":{name:"Binance Coin",logo:"bnb.png",erc20:!0,symbol:"BNB",decimals:18},"0xD850942eF8811f2A866692A623011bDE52a462C1":{name:"VeChain",logo:"ven.svg",erc20:!0,symbol:"VEN",decimals:18},"0x91Af0fBB28ABA7E31403Cb457106Ce79397FD4E6":{name:"Aergo",logo:"Aergo.svg",erc20:!0,symbol:"AERGO",decimals:18},"0x5CA9a71B1d01849C0a95490Cc00559717fCF0D1d":{name:"Aeternity",logo:"aeternity.svg",erc20:!0,symbol:"AE",decimals:18},"0xd4fa1460F537bb9085d22C7bcCB5DD450Ef28e3a":{name:"Populous",logo:"ppt.svg",erc20:!0,symbol:"PPT",decimals:8},"0xFA1a856Cfa3409CFa145Fa4e20Eb270dF3EB21ab":{name:"IOST",logo:"iost.png",erc20:!0,symbol:"IOST",decimals:18},"0x039B5649A59967e3e936D7471f9c3700100Ee1ab":{name:"Kucoin Shares",logo:"kucoin.svg",erc20:!0,symbol:"KCS",decimals:6},"0x3893b9422Cd5D70a81eDeFfe3d5A1c6A978310BB":{name:"Mithril",logo:"mith.svg",erc20:!0,symbol:"MITH",decimals:18},"0xb7cB1C96dB6B22b0D3d9536E0108d062BD488F74":{name:"Walton Token",logo:"wtc.svg",erc20:!0,symbol:"WTC",decimals:18},"0x1776e1F26f98b1A5dF9cD347953a26dd3Cb46671":{name:"Numeraire",logo:"nmr.png",erc20:!0,symbol:"NMR",decimals:18},"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd":{name:"Gemini Dollar",logo:"gusd.svg",erc20:!0,symbol:"GUSD",decimals:2},"0xA4Bdb11dc0a2bEC88d24A3aa1E6Bb17201112eBe":{name:"StableUSD",logo:"usds.svg",erc20:!0,symbol:"USDS",decimals:6},"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48":{name:"USDC",logo:"usdc.svg",erc20:!0,symbol:"USDC",decimals:6},"0x1aBaEA1f7C830bD89Acc67eC4af516284b1bC33c":{name:"EURC",logo:"eurc.svg",erc20:!0,symbol:"EURC",decimals:6},"0x93ED3FBe21207Ec2E8f2d3c3de6e058Cb73Bc04d":{name:"Pinakion Token",logo:"pinakion.svg",erc20:!0,symbol:"PNK",decimals:18},"0x419D0d8BdD9aF5e606Ae2232ed285Aff190E711b":{name:"FunFair",logo:"fun.svg",erc20:!0,symbol:"FUN",decimals:8},"0xcA2796F9F61dc7b238Aab043971e49c6164DF375":{name:"YGGDRASH YEED Token",logo:"yggdrash.svg",erc20:!0,symbol:"YEED",decimals:18},"0x03e3f0c25965f13DbbC58246738C183E27b26a56":{name:"Disciplina Token",logo:"disciplina.svg",erc20:!0,symbol:"DSCP",decimals:18},"0xE814aeE960a85208C3dB542C53E7D4a6C8D5f60F":{name:"Chronologic DAY Token",logo:"DAY.png",erc20:!0,symbol:"DAY",decimals:18},"0x7E43581b19ab509BCF9397a2eFd1ab10233f27dE":{name:"PLATINUM",logo:"plat.png",erc20:!0,symbol:"PLAT",decimals:18},"0x8E870D67F660D95d5be530380D0eC0bd388289E1":{name:"Pax Dollar",logo:"usdp.svg",erc20:!0,symbol:"USDP",decimals:18},"0x45804880De22913dAFE09f4980848ECE6EcbAf78":{name:"PAX Gold",logo:"paxg.svg",erc20:!0,symbol:"PAXG",decimals:18},"0x0000000000085d4780B73119b644AE5ecd22b376":{name:"TrueUSD",logo:"TUSD.svg",erc20:!0,symbol:"TUSD",decimals:18},"0x00000000441378008EA67F4284A57932B1c000a5":{name:"TrueGBP",logo:"TGBP.svg",erc20:!0,symbol:"TGBP",decimals:18},"0x00006100F7090010005F1bd7aE6122c3C2CF0090":{name:"TrueAUD",logo:"TAUD.svg",erc20:!0,symbol:"TAUD",decimals:18},"0x00000100F2A2bd000715001920eB70D229700085":{name:"TrueCAD",logo:"TCAD.svg",erc20:!0,symbol:"TCAD",decimals:18},"0x0000852600CEB001E08e00bC008be620d60031F2":{name:"TrueHKD",logo:"THKD.svg",erc20:!0,symbol:"THKD",decimals:18},"0x4Fabb145d64652a948d72533023f6E7A623C7C53":{name:"Binance USD",logo:"busd.svg",erc20:!0,symbol:"BUSD",decimals:18},"0x23Ccc43365D9dD3882eab88F43d515208f832430":{name:"MidasProtocol",logo:"MAS.png",erc20:!0,symbol:"MAS",decimals:18},"0xC16b542ff490e01fcc0DC58a60e1EFdc3e357cA6":{name:"ICE ROCK MINING",logo:"rock2.png",erc20:!0,symbol:"ROCK2",decimals:0},"0x6758B7d441a9739b98552B373703d8d3d14f9e62":{name:"POA20 Token",logo:"POA20.png",erc20:!0,symbol:"POA20",decimals:18},"0x3DB6Ba6ab6F95efed1a6E794caD492fAAabF294D":{name:"LTO Network Token (old)",logo:"LTO.svg",erc20:!0,symbol:"LTOOLD",decimals:8},"0xd01409314aCb3b245CEa9500eCE3F6Fd4d70ea30":{name:"LTO Network Token",logo:"LTO.svg",erc20:!0,symbol:"LTO",decimals:8},"0xfeF4185594457050cC9c23980d301908FE057Bb1":{name:"VIDT Datalink",logo:"VIDT.svg",erc20:!0,symbol:"VIDT-OLD",decimals:18},"0x3BE7bF1A5F23BD8336787D0289B70602f1940875":{name:"VIDT DAO",logo:"VIDT.svg",erc20:!0,symbol:"VIDT",decimals:18},"0x7064aAb39A0Fcf7221c3396719D0917a65E35515":{name:"Cpollo",logo:"Cpollo.svg",erc20:!0,symbol:"CPLO",decimals:18},"0xd8446236FA95b9b5f9fd0f8E7Df1a944823c683d":{name:"NEEO",logo:"neeo.png",erc20:!0,symbol:"NEEO",decimals:18},"0xA823E6722006afe99E91c30FF5295052fe6b8E32":{name:"Neumark",logo:"neu.svg",erc20:!0,symbol:"NEU",decimals:18},"0x8f693ca8D21b157107184d29D398A8D082b38b76":{name:"Streamr",logo:"streamr.svg",erc20:!0,symbol:"DATA",decimals:18},"0x0Cf0Ee63788A0849fE5297F3407f701E122cC023":{name:"Streamr (old)",logo:"streamr_old.svg",erc20:!0,symbol:"XDATA",decimals:18},"0xA0b73E1Ff0B80914AB6fe0444E65848C4C34450b":{name:"Cronos",logo:"cro.svg",erc20:!0,symbol:"CRO",decimals:8},"0xF70a642bD387F94380fFb90451C2c81d4Eb82CBc":{name:"STAR",logo:"starbase.png",erc20:!0,symbol:"STAR",decimals:18},"0x7C5A0CE9267ED19B22F8cae653F198e3E8daf098":{name:"Santiment",logo:"santiment.svg",erc20:!0,symbol:"SAN",decimals:18},"0x58b6A8A3302369DAEc383334672404Ee733aB239":{name:"Livepeer",logo:"lpt.svg",erc20:!0,symbol:"LPT",decimals:18},"0x6fe56C0bcdD471359019FcBC48863d6c3e9d4F41":{name:"Props",logo:"props.png",erc20:!0,symbol:"PROPS",decimals:18},"0x6c6EE5e31d828De241282B9606C8e98Ea48526E2":{name:"HoloToken",logo:"hot.svg",erc20:!0,symbol:"HOT",decimals:18},"0xF629cBd94d3791C9250152BD8dfBDF380E2a3B9c":{name:"Enjin Coin",logo:"enj.svg",erc20:!0,symbol:"ENJ",decimals:18},"0xbf2179859fc6D5BEE9Bf9158632Dc51678a4100e":{name:"AELF",logo:"elf.svg",erc20:!0,symbol:"ELF",decimals:18},"0x39Bb259F66E1C59d5ABEF88375979b4D20D98022":{name:"WAX Token",logo:"wax.svg",erc20:!0,symbol:"WAX",decimals:8},"0x595832F8FC6BF59c85C527fEC3740A1b7a361269":{name:"PowerLedger",logo:"powr.svg",erc20:!0,symbol:"POWR",decimals:6},"0x28dee01D53FED0Edf5f6E310BF8Ef9311513Ae40":{name:"BlitzPredict",logo:"blitzpredict.svg",erc20:!0,symbol:"XBP",decimals:18},"0x33349B282065b0284d756F0577FB39c158F935e6":{name:"Maple Finance",logo:"maple-finance.svg",erc20:!0,erc721:!1,symbol:"MPL",decimals:18},"0xFBeef911Dc5821886e1dda71586d90eD28174B7d":{name:"KnownOrigin",logo:"knownorigin.svg",erc20:!0,symbol:"KODA",decimals:0},"0x8207c1FfC5B6804F6024322CcF34F29c3541Ae26":{name:"Origin Protocol",logo:"ogn.svg",erc20:!0,symbol:"OGN",decimals:18},"0x2A8e1E676Ec238d8A992307B495b45B3fEAa5e86":{name:"Origin Dollar",logo:"ousd.svg",erc20:!0,symbol:"OUSD",decimals:18},"0x856c4Efb76C1D1AE02e20CEB03A2A6a08b0b8dC3":{name:"Origin Ether",logo:"oeth.svg",erc20:!0,symbol:"OETH",decimals:18},"0x9c354503C38481a7A7a51629142963F98eCC12D0":{name:"Origin DeFi Governance",logo:"ogv.svg",erc20:!0,symbol:"OGV",decimals:18},"0x0C4576Ca1c365868E162554AF8e385dc3e7C66D9":{name:"Vote Escrowed Origin DeFi Governance",logo:"veogv.svg",erc20:!0,symbol:"veOGV",decimals:18},"0x8f8221aFbB33998d8584A2B05749bA73c37a938a":{name:"Request",logo:"request.svg",erc20:!0,symbol:"REQ",decimals:18},"0x2aEa4Add166EBf38b63d09a75dE1a7b94Aa24163":{name:"Kudos",logo:"kudos.svg",erc20:!1,erc721:!0,symbol:"KDO",decimals:0},"0x14C926F2290044B647e1Bf2072e67B495eff1905":{name:"Bethereum",logo:"bether.jpg",erc20:!0,symbol:"BETHER",decimals:18},"0x9AAb071B4129B083B01cB5A0Cb513Ce7ecA26fa5":{name:"Hunt Token",logo:"hunt.png",erc20:!0,symbol:"HUNT",decimals:18},"0xFEF3884b603C33EF8eD4183346E093A173C94da6":{name:"Metamorph",logo:"metamorph.svg",erc20:!0,symbol:"METM",decimals:18},"0x0AbdAce70D3790235af448C88547603b945604ea":{name:"district0x",logo:"district0x.svg",erc20:!0,symbol:"DNT",decimals:18},"0xB26631c6dda06aD89B93C71400D25692de89c068":{name:"Minds",logo:"minds.svg",erc20:!0,symbol:"MINDS",decimals:18},"0xBb1f24C0c1554b9990222f036b0AaD6Ee4CAec29":{name:"CryptoSoul",logo:"SOUL.svg",erc20:!0,symbol:"SOUL",decimals:18},"0xFF0E5e014cf97e0615cb50F6f39Da6388E2FaE6E":{name:"Origo",logo:"origo.svg",erc20:!0,symbol:"OGO",decimals:18},"0x0cB8D0B37C7487b11d57F1f33dEfA2B1d3cFccfE":{name:"DANKToken",logo:"dank-logo.svg",erc20:!0,symbol:"DANK",decimals:18},"0x3a4f40631a4f906c2BaD353Ed06De7A5D3fCb430":{name:"PlayDapp Token",logo:"playdapp.svg",erc20:!0,symbol:"PLA",decimals:18},"0xE9e3F9cfc1A64DFca53614a0182CFAD56c10624F":{name:"Su Squares",logo:"Su-Squares.svg",erc20:!1,erc721:!0,symbol:"SU",decimals:0},"0xfA5047c9c78B8877af97BDcb85Db743fD7313d4a":{name:"ROOK",logo:"Rook.svg",erc20:!0,symbol:"ROOK",decimals:18},"0xa62cc35625B0C8dc1fAEA39d33625Bb4C15bD71C":{name:"StormX",logo:"stormx.svg",erc20:!0,symbol:"STMX",decimals:18},"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0":{name:"Matic Network Token",logo:"matic.svg",erc20:!0,symbol:"MATIC",decimals:18},"0x9992eC3cF6A55b00978cdDF2b27BC6882d88D1eC":{name:"Polymath",logo:"poly.svg",erc20:!0,symbol:"POLY",decimals:18},"0x0a50C93c762fDD6E56D86215C24AaAD43aB629aa":{name:"LGO Token",logo:"lgo.png",erc20:!0,symbol:"LGO",decimals:8},"0xc8Cac7672f4669685817cF332a33Eb249F085475":{name:"LivenCoin",logo:"LVN.svg",erc20:!0,symbol:"LVN",decimals:18},"0xBBbbCA6A901c926F240b89EacB641d8Aec7AEafD":{name:"Loopring",logo:"LRC.svg",erc20:!0,symbol:"LRC",decimals:18},"0x255Aa6DF07540Cb5d3d297f0D0D4D84cb52bc8e6":{name:"Raiden Network Token",logo:"raiden.svg",erc20:!0,symbol:"RDN",decimals:18},"0x66fD97a78d8854fEc445cd1C80a07896B0b4851f":{name:"Lunch Money",logo:"LMY.svg",erc20:!0,symbol:"LMY",decimals:18},"0x679131F591B4f369acB8cd8c51E68596806c3916":{name:"Trustlines Network Token",logo:"TLN128.png",erc20:!0,symbol:"TLN",decimals:18},"0xdcD85914b8aE28c1E62f1C488E1D968D5aaFfE2b":{name:"TOP Network Token",logo:"TOP.svg",erc20:!0,symbol:"TOP",decimals:18},"0xaea46A60368A7bD060eec7DF8CBa43b7EF41Ad85":{name:"Fetch",logo:"fetch.svg",erc20:!0,symbol:"FET",decimals:18},"0x2e1E15C44Ffe4Df6a0cb7371CD00d5028e571d14":{name:"Mettalex",logo:"mettalex.svg",erc20:!0,symbol:"MTLX",decimals:18},"0xf21661D0D1d76d3ECb8e1B9F1c923DBfffAe4097":{name:"Realio Network",logo:"rio.svg",erc20:!0,symbol:"RIO",decimals:18},"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{name:"Uniswap",logo:"uni.svg",erc20:!0,symbol:"UNI",decimals:18},"0x2e6539edc3b76f1E21B71d214527FAbA875F70F3":{name:"Yearn Finance Dot",logo:"YFDOT.svg",erc20:!0,symbol:"YFDOT",decimals:18},"0x9F284E1337A815fe77D2Ff4aE46544645B20c5ff":{name:"Darwinia Commitment Token",logo:"kton.svg",erc20:!0,symbol:"KTON",decimals:18},"0xE48972fCd82a274411c01834e2f031D4377Fa2c0":{name:"TwoKeyEconomy",logo:"2key.svg",erc20:!0,symbol:"2KEY",decimals:18},"0x970B9bB2C0444F5E81e9d0eFb84C8ccdcdcAf84d":{name:"Fuse Token",logo:"fuse.svg",erc20:!0,symbol:"FUSE",decimals:18},"0x0Ae055097C6d159879521C384F1D2123D1f195e6":{name:"STAKE Token",logo:"stake.svg",erc20:!0,symbol:"STAKE",decimals:18},"0x5dc60C4D5e75D22588FA17fFEB90A63E535efCE0":{name:"dKargo",logo:"DKA.svg",erc20:!0,symbol:"DKA",decimals:18},"0x9469D013805bFfB7D3DEBe5E7839237e535ec483":{name:"Darwinia Network Native Token",logo:"ring.svg",erc20:!0,symbol:"RING",decimals:18},"0xA31B1767e09f842ECFd4bc471Fe44F830E3891AA":{name:"ROOBEE",logo:"ROOBEE.svg",erc20:!0,symbol:"ROOBEE",decimals:18},"0xC7e43A1c8E118aA2965F5EAbe0e718D83DB7A63C":{name:"ZCore Token",logo:"zcrt.svg",erc20:!0,symbol:"ZCRT",decimals:18},"0x08d32b0da63e2C3bcF8019c9c5d849d7a9d791e6":{name:"Dentacoin Token",logo:"dcn.svg",erc20:!0,symbol:"DCN",decimals:0},"0xe2f2a5C287993345a840Db3B0845fbC70f5935a5":{name:"mStable USD",logo:"mUSD.svg",erc20:!0,symbol:"mUSD",decimals:18},"0xa3BeD4E1c75D00fa6f4E5E6922DB7261B5E9AcD2":{name:"Meta",logo:"MTA.svg",erc20:!0,symbol:"MTA",decimals:18},"0xe3818504c1B32bF1557b16C238B2E01Fd3149C17":{name:"Pillar",logo:"plr.svg",erc20:!0,symbol:"PLR",decimals:18},"0xba100000625a3754423978a60c9317c58a424e3D":{name:"Balancer (BAL)",logo:"balancer.svg",erc20:!0,symbol:"BAL",decimals:18},"0x8a854288a5976036A725879164Ca3e91d30c6A1B":{name:"Guaranteed Entrance Token",logo:"get-logo.svg",erc20:!0,symbol:"GET",decimals:18},"0x2781246fe707bB15CeE3e5ea354e2154a2877B16":{name:"Elysia",logo:"el.svg",erc20:!0,symbol:"EL",decimals:18},"0x4dA34f8264CB33A5c9F17081B9EF5Ff6091116f4":{name:"Elyfi",logo:"elyfi.svg",erc20:!0,symbol:"ELFI",decimals:18},"0xc12d099be31567add4e4e4d0D45691C3F58f5663":{name:"Auctus",logo:"auc.svg",erc20:!0,symbol:"AUC",decimals:18},"0xdF574c24545E5FfEcb9a659c229253D4111d87e1":{name:"HUSD",logo:"HUSD.svg",erc20:!0,symbol:"HUSD",decimals:8},"0x2ecB13A8c458c379c4d9a7259e202De03c8F3D19":{name:"Block-Chain.com Token",logo:"block-chain.svg",erc20:!0,symbol:"BC",decimals:18},"0x38e4adB44ef08F22F5B5b76A8f0c2d0dCbE7DcA1":{name:"Concentrated Voting Power",logo:"PowerPool.svg",erc20:!0,symbol:"CVP",decimals:18},"0xa117000000f279D81A1D3cc75430fAA017FA5A2e":{name:"Aragon Network Token",logo:"antv2.svg",erc20:!0,symbol:"ANT",decimals:18},"0xDecade1c6Bf2cD9fb89aFad73e4a519C867adcF5":{name:"Experty Wisdom Token",logo:"wisdom-token.svg",erc20:!0,symbol:"WIS",decimals:18},"0x7D85e23014F84E6E21d5663aCD8751bEF3562352":{name:"Axion Old",logo:"obsolete.svg",erc20:!0,symbol:"AXNv1",decimals:18},"0x358AA737e033F34df7c54306960a38d09AaBd523":{name:"Ares Token",logo:"ares.svg",erc20:!0,symbol:"ARES",decimals:18},"0xB62132e35a6c13ee1EE0f84dC5d40bad8d815206":{name:"NEXO",logo:"NEXO.svg",erc20:!0,symbol:"NEXO",decimals:18},"0x4612021C75809160Be60DB21fBc9D6adD0B32deF":{name:"BCP Coin",logo:"BCP.svg",erc20:!0,symbol:"BCP",decimals:18},"0xE9E73E1aE76D17A16cC53E3e87a9a7dA78834d37":{name:"Camp",logo:"Camp.svg",erc20:!0,symbol:"CAMP",decimals:18},"0xdacD69347dE42baBfAEcD09dC88958378780FB62":{name:"Atari Token",logo:"atrilast.svg",erc20:!0,symbol:"ATRI",decimals:0},"0x71F85B2E46976bD21302B64329868fd15eb0D127":{name:"Axion",logo:"axion.svg",erc20:!0,symbol:"AXN",decimals:18},"0xc944E90C64B2c07662A292be6244BDf05Cda44a7":{name:"Graph Token",logo:"graphToken.svg",erc20:!0,symbol:"GRT",decimals:18},"0xFE3E6a25e6b192A42a44ecDDCd13796471735ACf":{name:"Reef Finance",logo:"reef.svg",erc20:!0,symbol:"REEF",decimals:18},"0x43Dfc4159D86F3A37A5A4B3D4580b888ad7d4DDd":{name:"DODO bird",logo:"DODO.svg",erc20:!0,symbol:"DODO",decimals:18},"0x4a615bB7166210CCe20E6642a6f8Fb5d4D044496":{name:"NAOS Finance",logo:"naos.svg",erc20:!0,symbol:"NAOS",decimals:18},"0x111111111117dC0aa78b770fA6A738034120C302":{name:"1INCH Token",logo:"1inch.svg",erc20:!0,symbol:"1INCH",decimals:18},"0x27702a26126e0B3702af63Ee09aC4d1A084EF628":{name:"Aleph.im Token",logo:"aleph.svg",erc20:!0,symbol:"ALEPH",decimals:18},"0x32a7C02e79c4ea1008dD6564b35F131428673c41":{name:"CRUST",logo:"crust.svg",erc20:!0,symbol:"CRU",decimals:18},"0x3472A5A71965499acd81997a54BBA8D852C6E53d":{name:"BADGER",logo:"badger.svg",erc20:!0,symbol:"BADGER",decimals:18},"0x65Def5029A0e7591e46B38742bFEdd1Fb7b24436":{name:"Kanpeki",logo:"kanpeki-green.svg",erc20:!0,symbol:"KAE",decimals:18},"0xF94b5C5651c888d928439aB6514B93944eEE6F48":{name:"Yield App",logo:"yield-app.svg",erc20:!0,symbol:"YLD",decimals:18},"0xDcB01cc464238396E213a6fDd933E36796eAfF9f":{name:"Yield",logo:"yield-logo.svg",erc20:!0,symbol:"YLD",decimals:18},"0x968F6f898a6Df937fC1859b323aC2F14643e3fED":{name:"Newscrypto",logo:"NWC.svg",erc20:!0,symbol:"NWC",decimals:18},"0xeb269732ab75A6fD61Ea60b06fE994cD32a83549":{name:"dForce USDx",logo:"USDx.svg",erc20:!0,symbol:"USDx",decimals:18},"0x6e0daDE58D2d89eBBe7aFc384e3E4f15b70b14D8":{name:"QuiverX",logo:"quiverx.svg",erc20:!0,symbol:"QRX",decimals:18},"0x0beAD9a1bcc1b84D06E3f2df67E3549Fd55aB054":{name:"EURxb",logo:"eurxb.svg",erc20:!0,symbol:"EURxb",decimals:18},"0x9F9c8ec3534c3cE16F928381372BfbFBFb9F4D24":{name:"GraphLinq",logo:"glq.svg",erc20:!0,symbol:"GLQ",decimals:18},"0xEB58343b36C7528F23CAAe63a150240241310049":{name:"NBU",logo:"NBU.svg",erc20:!0,symbol:"NBU",decimals:18},"0x16ECCfDbb4eE1A85A33f3A9B21175Cd7Ae753dB4":{name:"Route",logo:"route.svg",erc20:!0,symbol:"ROUTE",decimals:18},"0x75739d5944534115d7C54ee8C73F186D793BAE02":{name:"Collective",logo:"CO2.svg",erc20:!0,symbol:"CO2",decimals:18},"0x35bD01FC9d6D5D81CA9E055Db88Dc49aa2c699A8":{name:"FWB Pro",logo:"FWB.svg",erc20:!0,symbol:"FWB",decimals:18},"0x9B99CcA871Be05119B2012fd4474731dd653FEBe":{name:"Antimatter",logo:"antimatter.svg",erc20:!0,symbol:"MATTER",decimals:18},"0x6De037ef9aD2725EB40118Bb1702EBb27e4Aeb24":{name:"Render Token",logo:"RNDR.svg",erc20:!0,symbol:"RNDR",decimals:18},"0xDf49C9f599A0A9049D97CFF34D0C30E468987389":{name:"SaTT",logo:"SaTT.svg",erc20:!0,symbol:"SATT",decimals:18},"0x431ad2ff6a9C365805eBaD47Ee021148d6f7DBe0":{name:"dForce",logo:"DF.svg",erc20:!0,symbol:"DF",decimals:18},"0x6e1A19F235bE7ED8E3369eF73b196C07257494DE":{name:"Wrapped Filecoin",logo:"WFIL.svg",erc20:!0,symbol:"WFIL",decimals:18},"0xE452E6Ea2dDeB012e20dB73bf5d3863A3Ac8d77a":{name:"Wrapped Celo",logo:"WCELO.svg",erc20:!0,symbol:"wCELO",decimals:18},"0x4A64515E5E1d1073e83f30cB97BEd20400b66E10":{name:"Wrapped ZEC",logo:"WZEC.svg",erc20:!0,symbol:"WZEC",decimals:18},"0xA3865E64121537b5b59B5e239Db4aCBe6F36aa74":{name:"Wrapped Tezos",logo:"WXTZ.svg",erc20:!0,symbol:"WXTZ",decimals:18},"0x53c4871322Bb47e7A24136fce291a6dcC832a294":{name:"Wrapped Litecoin",logo:"WLTC.svg",erc20:!0,symbol:"WLTC",decimals:18},"0xad3E3Fc59dff318BecEaAb7D00EB4F68b1EcF195":{name:"Wrapped Celo USD",logo:"WCUSD.svg",erc20:!0,symbol:"wCUSD",decimals:18},"0x85D7bdfc9c3426b33A684241eEEE70385Bc42820":{name:"Wrapped Kadena",logo:"WKDA.svg",erc20:!0,symbol:"WKDA",decimals:18},"0x39fBBABf11738317a448031930706cd3e612e1B9":{name:"Wrapped XRP",logo:"WXRP.svg",erc20:!0,symbol:"WXRP",decimals:18},"0xBBC7f7A6AADAc103769C66CBC69AB720f7F9Eae3":{name:"INX Token",logo:"INX.svg",erc20:!0,symbol:"INX",decimals:18},"0x1b40183EFB4Dd766f11bDa7A7c3AD8982e998421":{name:"Vesper",logo:"vsp.svg",erc20:!0,symbol:"VSP",decimals:18},"0x544c42fBB96B39B21DF61cf322b5EDC285EE7429":{name:"InsurAce",logo:"INSUR.svg",erc20:!0,symbol:"INSUR",decimals:18},"0xcC665390b03c5D324D8fAF81C15eCee29A73bCB4":{name:"ChainSwap.com Governance Token",logo:"chainswap.svg",erc20:!0,symbol:"ASAP",decimals:18},"0x182F4c4C97cd1c24E1Df8FC4c053E5C47bf53Bef":{name:"keyTango Token",logo:"keyTango.svg",erc20:!0,symbol:"TANGO",decimals:18},"0x0275E1001e293C46CFe158B3702AADe0B99f88a5":{name:"Oiler",logo:"oiler.svg",erc20:!0,symbol:"OIL",decimals:18},"0xDe30da39c46104798bB5aA3fe8B9e0e1F348163F":{name:"Gitcoin",logo:"gtc.svg",erc20:!0,symbol:"GTC",decimals:18},"0x1796ae0b0fa4862485106a0de9b654eFE301D0b2":{name:"Polychain Monsters",logo:"PMON.svg",erc20:!0,symbol:"PMON",decimals:18},"0x8eEF5a82E6Aa222a60F009ac18c24EE12dBf4b41":{name:"Tixl",logo:"TXL.svg",erc20:!0,symbol:"TXL",decimals:18},"0x5218E472cFCFE0b64A064F055B43b4cdC9EfD3A6":{name:"unFederalReserve Token",logo:"eRSDL.svg",erc20:!0,symbol:"eRSDL",decimals:18},"0xE4cC5A22B39fFB0A56d67F94f9300db20D786a5F":{name:"unFederal eRSDL",logo:"uneRSDL.svg",erc20:!0,symbol:"uneRSDL",decimals:8},"0x2dbA05B51eF5A7DE3E7c3327201CA2F8a25C2414":{name:"unFederal DAI",logo:"unDAI.svg",erc20:!0,symbol:"unDAI",decimals:8},"0xFaCecE87e14B50eafc85C44C01702F5f485CA460":{name:"unFederal ETH",logo:"unETH.svg",erc20:!0,symbol:"unETH",decimals:8},"0x6b576972de33BebDe3A703BfF52a091e79f8c87A":{name:"unFederal USDC",logo:"unUSDC.svg",erc20:!0,symbol:"unUSDC",decimals:8},"0x6e2aA5bB90ac37D9006685AFc651ef067E1c7b44":{name:"unFederal USDT",logo:"unUSDT.svg",erc20:!0,symbol:"unUSDT",decimals:8},"0x5D446FC8DBd10EBAcfE9A427aB5402586af98cD4":{name:"unFederal WBTC",logo:"unWBTC.svg",erc20:!0,symbol:"unWBTC",decimals:8},"0xD837eCa6C91c67D98461A411BA2f00bdA9960a9D":{name:"unFederal AAVE",logo:"unAAVE.svg",erc20:!0,symbol:"unAAVE",decimals:8},"0x9e29Ce9cD25F4141dF6BB85b27Ef6933a16A5824":{name:"unFederal YFI",logo:"unYFI.svg",erc20:!0,symbol:"unYFI",decimals:8},"0x031002d15B0D0Cd7c9129d6F644446368deaE391":{name:"unFederal LINK",logo:"unLINK.svg",erc20:!0,symbol:"unLINK",decimals:8},"0xB8E2e2101eD11e9138803cd3e06e16dd19910647":{name:"ArdCoin",logo:"ardcoin.svg",erc20:!0,symbol:"ARDX",decimals:2},"0x6D0F5149c502faf215C89ab306ec3E50b15e2892":{name:"Portion Token",logo:"PRT.svg",erc20:!0,symbol:"PRT",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"3SPACE ART",logo:"3SPACE.svg",erc20:!0,symbol:"PACE",decimals:18},"0x3845badAde8e6dFF049820680d1F14bD3903a5d0":{name:"SAND",logo:"SAND.svg",erc20:!0,symbol:"SAND",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"Spacelens",logo:"SPACE.svg",erc20:!0,symbol:"SPACE",decimals:18},"0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a":{name:"Sandbox's LANDs",logo:"SAND.svg",erc20:!1,erc721:!0,symbol:"LAND",decimals:0},"0x362bc847A3a9637d3af6624EeC853618a43ed7D2":{name:"PARSIQ",logo:"parsiq.svg",erc20:!0,symbol:"PRQ",decimals:18},"0x21381e026Ad6d8266244f2A583b35F9E4413FA2a":{name:"Formation Finance",logo:"form.svg",erc20:!0,symbol:"FORM",decimals:18},"0x2ba592F78dB6436527729929AAf6c908497cB200":{name:"Cream",logo:"cream.svg",erc20:!0,symbol:"CREAM",decimals:18},"0x46576e20EC5F25586A6Fa2E0d6B6058354B72E72":{name:"Cryptomind",logo:"CR.svg",erc20:!0,erc721:!1,symbol:"CR",decimals:8},"0x5ab21Ec0bfa0B29545230395e3Adaca7d552C948":{name:"PUNKS Comic",logo:"punks-comic.svg",erc20:!1,erc721:!0,symbol:"COMIC",decimals:0},"0x9C2dc0c3CC2BADdE84B0025Cf4df1c5aF288D835":{name:"Coreto",logo:"coreto.svg",erc20:!0,symbol:"COR",decimals:18},"0x0De05F6447ab4D22c8827449EE4bA2D5C288379B":{name:"OOKI",logo:"ooki.svg",erc20:!0,symbol:"OOKI",decimals:18},"0x6B4c7A5e3f0B99FCD83e9c089BDDD6c7FCe5c611":{name:"Million",logo:"million.svg",erc20:!0,symbol:"MM",decimals:18},"0x56d811088235F11C8920698a204A5010a788f4b3":{name:"bZx Protocol Token (BZRX)",logo:"ic_token_bzrx.svg",erc20:!0,symbol:"BZRX",decimals:18},"0xB72B31907C1C95F3650b64b2469e08EdACeE5e8F":{name:"bZx Vesting Token (vBZRX)",logo:"ic_token_vbzrx.svg",erc20:!0,symbol:"vBZRX",decimals:18},"0x3085154623F51b00Dedfc6Ceeb5197277A66B17B":{name:"NIFTY",logo:"nfty.svg",erc20:!0,symbol:"NFTY",decimals:18},"0xB983E01458529665007fF7E0CDdeCDB74B967Eb6":{name:"Fulcrum ETH iToken (iETH)",logo:"ic_token_ieth.svg",erc20:!0,symbol:"iETH",decimals:18},"0x32E4c68B3A4a813b710595AebA7f6B7604Ab9c15":{name:"Fulcrum USDC iToken (iUSDC)",logo:"ic_token_iusdc.svg",erc20:!0,symbol:"iUSDC",decimals:6},"0x2ffa85f655752fB2aCB210287c60b9ef335f5b6E":{name:"Fulcrum WBTC iToken (iWBTC)",logo:"ic_token_ibtc.svg",erc20:!0,symbol:"iWBTC",decimals:8},"0x687642347a9282Be8FD809d8309910A3f984Ac5a":{name:"Fulcrum KNC iToken (iKNC)",logo:"ic_token_iknc.svg",erc20:!0,symbol:"iKNC",decimals:18},"0x463538705E7d22aA7f03Ebf8ab09B067e1001B54":{name:"Fulcrum LINK iToken (iLINK)",logo:"ic_token_ilink.svg",erc20:!0,symbol:"iLINK",decimals:18},"0x6b093998D36f2C7F0cc359441FBB24CC629D5FF0":{name:"Fulcrum DAI iToken (iDAI)",logo:"ic_token_idai.svg",erc20:!0,symbol:"iDAI",decimals:18},"0x7e9997a38A439b2be7ed9c9C4628391d3e055D48":{name:"Fulcrum USDT iToken (iUSDT)",logo:"ic_token_iusdt.svg",erc20:!0,symbol:"iUSDT",decimals:6},"0x9189c499727f88F8eCC7dC4EEA22c828E6AaC015":{name:"Fulcrum MKR iToken (iMKR)",logo:"ic_token_imkr.svg",erc20:!0,symbol:"iMKR",decimals:18},"0x18240BD9C07fA6156Ce3F3f61921cC82b2619157":{name:"Fulcrum BZRX iToken (iBZRX)",logo:"ic_token_ibzrx.svg",erc20:!0,symbol:"iBZRX",decimals:18},"0x7F3Fe9D492A9a60aEBb06d82cBa23c6F32CAd10b":{name:"Fulcrum YFI iToken (iYFI)",logo:"ic_token_iyfi.svg",erc20:!0,symbol:"iYFI",decimals:18},"0x0a625FceC657053Fe2D9FFFdeb1DBb4e412Cf8A8":{name:"Fulcrum UNI iToken (iUNI)",logo:"ic_token_iuni.svg",erc20:!0,symbol:"iUNI",decimals:18},"0x0cae8d91E0b1b7Bd00D906E990C3625b2c220db1":{name:"Fulcrum AAVE iToken (iAAVE)",logo:"ic_token_iaave.svg",erc20:!0,symbol:"iAAVE",decimals:18},"0x3dA0e01472Dee3746b4D324a65D7EdFaECa9Aa4f":{name:"Fulcrum LRC iToken (iLRC)",logo:"ic_token_ilrc.svg",erc20:!0,symbol:"iLRC",decimals:18},"0x6d29903BC2c4318b59B35d97Ab98ab9eC08Ed70D":{name:"Fulcrum COMP iToken (iCOMP)",logo:"ic_token_icomp.svg",erc20:!0,symbol:"iCOMP",decimals:18},"0x08c32b0726C5684024ea6e141C50aDe9690bBdcc":{name:"Stratos Token",logo:"stos.svg",erc20:!0,symbol:"STOS",decimals:18},"0xe28b3B32B6c345A34Ff64674606124Dd5Aceca30":{name:"Injective",logo:"inj.svg",erc20:!0,symbol:"INJ",decimals:18},"0xe516D78d784C77D479977BE58905B3f2b1111126":{name:"Bitspawn",logo:"spwn.svg",erc20:!0,symbol:"SPWN",decimals:18},"0xB16e967ff83DE3F1e9FCeAfbc2C28c1c5c56eF91":{name:"Polkadog",logo:"polkadog.svg",erc20:!0,symbol:"PDOG",decimals:18},"0x07c52c2537D84e532a9F15d32E152C8B94D2b232":{name:"ZkTube",logo:"ZKT.svg",erc20:!0,symbol:"ZKT",decimals:18},"0xF4d861575ecC9493420A3f5a14F85B13f0b50EB3":{name:"Fractal Protocol",logo:"fractal.svg",erc20:!0,symbol:"FCL",decimals:18},"0x3af33bEF05C2dCb3C7288b77fe1C8d2AeBA4d789":{name:"Kromatika",logo:"krom.svg",erc20:!0,symbol:"KROM",decimals:18},"0xA130E3a33a4d84b04c3918c4E5762223Ae252F80":{name:"Swash Token",logo:"swash.svg",erc20:!0,symbol:"SWASH",decimals:18},"0xea7Cc765eBC94C4805e3BFf28D7E4aE48D06468A":{name:"NearPad Token",logo:"nearpad.svg",erc20:!0,symbol:"PAD",decimals:18},"0x87C22615435998D69ACA34889D03155B694a94fc":{name:"DiemLibre",logo:"DLB.svg",erc20:!0,symbol:"DLB",decimals:18},"0x4d224452801ACEd8B2F0aebE155379bb5D594381":{name:"ApeCoin",logo:"APE.svg",erc20:!0,symbol:"APE",decimals:18},"0xCd1fAFf6e578Fa5cAC469d2418C95671bA1a62Fe":{name:"Torum Token",logo:"torum.svg",erc20:!0,symbol:"XTM",decimals:18},"0xcf0C122c6b73ff809C693DB761e7BaeBe62b6a2E":{name:"FLOKI",logo:"floki.svg",erc20:!0,symbol:"FLOKI",decimals:9},"0xe831F96A7a1DcE1aa2EB760b1e296c6A74CaA9d5":{name:"Nexum Coin",logo:"nexum.svg",erc20:!0,symbol:"Nexm",decimals:8},"0x6710c63432A2De02954fc0f851db07146a6c0312":{name:"MFG",logo:"mfg.svg",erc20:!0,symbol:"MFG",decimals:18},"0xae78736Cd615f374D3085123A210448E74Fc6393":{name:"Rocket Pool ETH",logo:"rETH.svg",erc20:!0,symbol:"rETH",decimals:18},"0x0C10bF8FcB7Bf5412187A595ab97a3609160b5c6":{name:"Decentralized USD",logo:"USDD.svg",erc20:!0,symbol:"USDD",decimals:18},"0xD33526068D116cE69F19A9ee46F0bd304F21A51f":{name:"Rocket Pool",logo:"rpl.svg",erc20:!0,symbol:"RPL",decimals:18},"0x9d38F670D15C14716BE1F109a4F453E966A2B6D4":{name:"Quid Ika",logo:"QuidIka.svg",erc20:!0,symbol:"QUID",decimals:9},"0xD3c625F54dec647DB8780dBBe0E880eF21BA4329":{name:"HollaEx Token",logo:"xht.svg",erc20:!0,symbol:"XHT",decimals:18},"0x01e0E2e61f554eCAaeC0cC933E739Ad90f24a86d":{name:"GTON",logo:"gton.svg",erc20:!0,symbol:"GTON",decimals:18},"0xeFF66B4A84C8a6b69b99EB1C5e39aF8fc35d13db":{name:"sGTON",logo:"sgton.svg",erc20:!0,symbol:"sGTON",decimals:18},"0x7659CE147D0e714454073a5dd7003544234b6Aa0":{name:"XCAD Token",logo:"xcad.svg",erc20:!0,symbol:"XCAD",decimals:18},"0x88dF592F8eb5D7Bd38bFeF7dEb0fBc02cf3778a0":{name:"Tellor Tributes",logo:"TRB.svg",erc20:!0,symbol:"TRB",decimals:18},"0x8d96B4ab6C741a4C8679AE323a100d74f085BA8F":{name:"Bazaars",logo:"BZR.svg",erc20:!0,symbol:"BZR",decimals:18},"0x9ee91F9f426fA633d227f7a9b000E28b9dfd8599":{name:"Liquid staked MATIC",logo:"stMATIC.svg",erc20:!0,symbol:"stMATIC",decimals:18},"0x0d02755a5700414B26FF040e1dE35D337DF56218":{name:"Bend Token",logo:"BendDAO.svg",erc20:!0,symbol:"BEND",decimals:18},"0x1A4b46696b2bB4794Eb3D4c26f1c55F9170fa4C5":{name:"BitDAO",logo:"BitDAO.svg",erc20:!0,erc721:!1,symbol:"BIT",decimals:18},"0xb8919522331C59f5C16bDfAA6A121a6E03A91F62":{name:"Home",logo:"home.svg",erc20:!0,erc721:!1,symbol:"HOME",decimals:6},"0xa54d2EBfD977ad836203c85F18db2F0a0cF88854":{name:"Bacon",logo:"bacon.svg",erc20:!0,erc721:!1,symbol:"BACON",decimals:18},"0x249cA82617eC3DfB2589c4c17ab7EC9765350a18":{name:"Verse",logo:"VERSE.svg",erc20:!0,erc721:!1,symbol:"VERSE",decimals:18},"0x317eb4ad9cfaC6232f0046831322E895507bcBeb":{name:"Tidex Token",logo:"tidex.svg",erc20:!0,symbol:"TDX",decimals:18},"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE":{name:"SHIBA INU",logo:"shib.svg",erc20:!0,symbol:"SHIB",decimals:18},"0x3506424F91fD33084466F402d5D97f05F8e3b4AF":{name:"chiliZ",logo:"chz.svg",erc20:!0,symbol:"CHZ",decimals:18},"0x15D4c048F83bd7e37d49eA4C83a07267Ec4203dA":{name:"Gala",logo:"gala.svg",erc20:!0,symbol:"GALA",decimals:8},"0x69af81e73A73B40adF4f3d4223Cd9b1ECE623074":{name:"Mask Network",logo:"mask.svg",erc20:!0,symbol:"MASK",decimals:18},"0xD533a949740bb3306d119CC777fa900bA034cd52":{name:"Curve DAO Token",logo:"crv.svg",erc20:!0,symbol:"CRV",decimals:18},"0x92D6C1e31e14520e676a687F0a93788B716BEff5":{name:"dYdX",logo:"dydx.svg",erc20:!0,symbol:"DYDX",decimals:18},"0x60bE1e1fE41c1370ADaF5d8e66f07Cf1C2Df2268":{name:"Perion Credits",logo:"perc.svg",erc20:!0,symbol:"PERC",decimals:18},"0x8971f9fd7196e5cEE2C1032B50F656855af7Dd26":{name:"Lambda",logo:"LAMB.svg",erc20:!0,symbol:"LAMB",decimals:18},"0x65514b352d1d4a17DE97f95C7faB177C625Bd6ff":{name:"KIBBLE Token",logo:"kibble.svg",erc20:!0,erc721:!1,symbol:"KBLE",decimals:18},"0xd9Fcd98c322942075A5C3860693e9f4f03AAE07b":{name:"Euler",logo:"eul.svg",erc20:!0,erc721:!1,symbol:"EUL",decimals:18},"0x777fD20c983d6658c1D50b3958B3A1733d1cd1E1":{name:"PUBLISH",logo:"publish.svg",erc20:!0,symbol:"NEWS",decimals:9},"0x19062190B1925b5b6689D7073fDfC8c2976EF8Cb":{name:"Swarm",logo:"ethswarm.svg",erc20:!0,symbol:"BZZ",decimals:16},"0x6aA030a9710CAD6E719A4EC0a85260Eb3F4F86c1":{name:"Real World Asset",logo:"rwa.svg",erc20:!0,symbol:"RWA",decimals:18},"0xde16Ce60804a881e9F8c4eBB3824646EDecd478D":{name:"MagicCraft",logo:"magiccraft.svg",erc20:!0,symbol:"MCRT",decimals:9},"0x7163436b8EfFfB469F6BB81cc908b1661d4795e6":{name:"Esco coin",logo:"escocoin.svg",erc20:!0,symbol:"ESCO",decimals:18},"0x9625cE7753ace1fa1865A47aAe2c5C2Ce4418569":{name:"KAP Games",logo:"kap-games.svg",erc20:!0,symbol:"KAP",decimals:18},"0x4FbB350052Bca5417566f188eB2EBCE5b19BC964":{name:"Rigo",logo:"grg.svg",erc20:!0,symbol:"GRG",decimals:18},"0xD8E163967FED76806Df0097B704bA721B9b37656":{name:"Cope",logo:"cope.svg",erc20:!0,symbol:"COPE",decimals:18},"0xdfbc9050F5B01DF53512DCC39B4f2B2BBaCD517A":{name:"Jobchain",logo:"job.svg",erc20:!0,symbol:"JOB",decimals:8},"0x083D41d6DD21EE938f0c055CA4fb12268DF0EfaC":{name:"GogolCoin",logo:"gol.svg",erc20:!0,symbol:"GOL",decimals:4},"0x9B4a69dE6CA0deFDD02c0c4ce6Cb84de5202944E":{name:"PROOF Platform",erc20:!0,symbol:"PROOF",decimals:9,logo:"proof-platform.svg"},"0x4507cEf57C46789eF8d1a19EA45f4216bae2B528":{name:"TokenFi",logo:"tokenfi.svg",erc20:!0,symbol:"TOKEN",decimals:9},"0x8B39B70E39Aa811b69365398e0aACe9bee238AEb":{name:"PolkaFoundry",logo:"pkf.svg",erc20:!0,symbol:"PKF",decimals:18},"0x2c95D751DA37A5C1d9c5a7Fd465c1d50F3d96160":{name:"WASSIE",logo:"wassie.svg",erc20:!0,symbol:"WASSIE",decimals:18},"0x06325440D014e39736583c165C2963BA99fAf14E":{name:"Curve.fi",logo:"steCRV.png",erc20:!0,symbol:"steCRV",decimals:18},"0x4E241A9EC66832a16bceaeB9156E524487f061D7":{name:"ETF Rocks",logo:"etf.svg",erc20:!0,symbol:"ETF",decimals:18},"0xA849EaaE994fb86Afa73382e9Bd88c2B6b18Dc71":{name:"Mass Vehicle Ledger",logo:"mvl.svg",erc20:!0,symbol:"MVL",decimals:18},"0xd5F7838F5C461fefF7FE49ea5ebaF7728bB0ADfa":{name:"Mantle Staked Ether",logo:"mETH.svg",erc20:!0,erc721:!1,symbol:"mETH",decimals:18}}}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/contract-map.json"}],[1551,{"./contract-map.json":1550},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){t.exports=e("./contract-map.json")}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/index.js"}],[1552,{"./types.cjs":1557},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=r.ApprovalType=r.ORIGIN_METAMASK=r.NFT_API_TIMEOUT=r.NFT_API_VERSION=r.NFT_API_BASE_URL=r.OPENSEA_PROXY_URL=r.BUILT_IN_NETWORKS=r.BUILT_IN_CUSTOM_NETWORKS_RPC=r.TESTNET_TICKER_SYMBOLS=r.ASSET_TYPES=r.GWEI=r.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=r.ERC1155_METADATA_URI_INTERFACE_ID=r.ERC1155_INTERFACE_ID=r.ERC721_ENUMERABLE_INTERFACE_ID=r.ERC721_METADATA_INTERFACE_ID=r.ERC721_INTERFACE_ID=r.ERC20=r.ERC1155=r.ERC721=r.MAX_SAFE_CHAIN_ID=r.GANACHE_CHAIN_ID=r.IPFS_DEFAULT_GATEWAY_URL=r.FALL_BACK_VS_CURRENCY=r.RPC=void 0;const n=e("./types.cjs");var s;r.RPC="rpc",r.FALL_BACK_VS_CURRENCY="ETH",r.IPFS_DEFAULT_GATEWAY_URL="https://cloudflare-ipfs.com/ipfs/",r.GANACHE_CHAIN_ID="0x539",r.MAX_SAFE_CHAIN_ID=0xfffffffffffec,r.ERC721="ERC721",r.ERC1155="ERC1155",r.ERC20="ERC20",r.ERC721_INTERFACE_ID="0x80ac58cd",r.ERC721_METADATA_INTERFACE_ID="0x5b5e139f",r.ERC721_ENUMERABLE_INTERFACE_ID="0x780e9d63",r.ERC1155_INTERFACE_ID="0xd9b67a26",r.ERC1155_METADATA_URI_INTERFACE_ID="0x0e89341c",r.ERC1155_TOKEN_RECEIVER_INTERFACE_ID="0x4e2312e0",r.GWEI="gwei",r.ASSET_TYPES={NATIVE:"NATIVE",TOKEN:"TOKEN",NFT:"NFT",UNKNOWN:"UNKNOWN"},r.TESTNET_TICKER_SYMBOLS={GOERLI:"GoerliETH",SEPOLIA:"SepoliaETH",LINEA_GOERLI:"LineaETH",LINEA_SEPOLIA:"LineaETH",MEGAETH_TESTNET:"MegaETH"},r.BUILT_IN_CUSTOM_NETWORKS_RPC={MEGAETH_TESTNET:"https://carrot.megaeth.com/rpc","megaeth-testnet":"https://carrot.megaeth.com/rpc","monad-testnet":"https://testnet-rpc.monad.xyz"},r.BUILT_IN_NETWORKS={[n.NetworkType.goerli]:{chainId:n.ChainId.goerli,ticker:n.NetworksTicker.goerli,rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl.goerli}},[n.NetworkType.sepolia]:{chainId:n.ChainId.sepolia,ticker:n.NetworksTicker.sepolia,rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl.sepolia}},[n.NetworkType.mainnet]:{chainId:n.ChainId.mainnet,ticker:n.NetworksTicker.mainnet,rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl.mainnet}},[n.NetworkType["linea-goerli"]]:{chainId:n.ChainId["linea-goerli"],ticker:n.NetworksTicker["linea-goerli"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["linea-goerli"]}},[n.NetworkType["linea-sepolia"]]:{chainId:n.ChainId["linea-sepolia"],ticker:n.NetworksTicker["linea-sepolia"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["linea-sepolia"]}},[n.NetworkType["linea-mainnet"]]:{chainId:n.ChainId["linea-mainnet"],ticker:n.NetworksTicker["linea-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["linea-mainnet"]}},[n.NetworkType["megaeth-testnet"]]:{chainId:n.ChainId["megaeth-testnet"],ticker:n.NetworksTicker["megaeth-testnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["megaeth-testnet"]}},[n.NetworkType["monad-testnet"]]:{chainId:n.ChainId["monad-testnet"],ticker:n.NetworksTicker["monad-testnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["monad-testnet"]}},[n.NetworkType["base-mainnet"]]:{chainId:n.ChainId["base-mainnet"],ticker:n.NetworksTicker["base-mainnet"],rpcPrefs:{blockExplorerUrl:n.BlockExplorerUrl["base-mainnet"]}},[n.NetworkType.rpc]:{chainId:undefined,blockExplorerUrl:undefined,ticker:undefined,rpcPrefs:undefined}},r.OPENSEA_PROXY_URL="https://proxy.api.cx.metamask.io/opensea/v1/api/v2",r.NFT_API_BASE_URL="https://nft.api.cx.metamask.io",r.NFT_API_VERSION="1",r.NFT_API_TIMEOUT=15e3,r.ORIGIN_METAMASK="metamask",function(e){e.AddEthereumChain="wallet_addEthereumChain",e.ConnectAccounts="connect_accounts",e.EthDecrypt="eth_decrypt",e.EthGetEncryptionPublicKey="eth_getEncryptionPublicKey",e.EthSignTypedData="eth_signTypedData",e.PersonalSign="personal_sign",e.ResultError="result_error",e.ResultSuccess="result_success",e.SnapDialogAlert="snap_dialog:alert",e.SnapDialogConfirmation="snap_dialog:confirmation",e.SnapDialogPrompt="snap_dialog:prompt",e.SnapDialogDefault="snap_dialog",e.SwitchEthereumChain="wallet_switchEthereumChain",e.Transaction="transaction",e.TransactionBatch="transaction_batch",e.Unlock="unlock",e.WalletConnect="wallet_connect",e.WalletRequestPermissions="wallet_requestPermissions",e.WatchAsset="wallet_watchAsset"}(s||(r.ApprovalType=s={})),r.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP={[n.ChainId.goerli]:n.BuiltInNetworkName.Goerli,[n.ChainId.sepolia]:n.BuiltInNetworkName.Sepolia,[n.ChainId.mainnet]:n.BuiltInNetworkName.Mainnet,[n.ChainId["linea-goerli"]]:n.BuiltInNetworkName.LineaGoerli,[n.ChainId["linea-sepolia"]]:n.BuiltInNetworkName.LineaSepolia,[n.ChainId["linea-mainnet"]]:n.BuiltInNetworkName.LineaMainnet,[n.ChainId.aurora]:n.BuiltInNetworkName.Aurora}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/constants.cjs"}],[1553,{cockatiel:4170},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createServicePolicy=r.DEFAULT_DEGRADED_THRESHOLD=r.DEFAULT_CIRCUIT_BREAK_DURATION=r.DEFAULT_MAX_CONSECUTIVE_FAILURES=r.DEFAULT_MAX_RETRIES=r.handleWhen=r.handleAll=r.ExponentialBackoff=r.ConstantBackoff=r.CircuitState=r.BrokenCircuitError=void 0;const n=e("cockatiel");Object.defineProperty(r,"BrokenCircuitError",{enumerable:!0,get:function(){return n.BrokenCircuitError}}),Object.defineProperty(r,"CircuitState",{enumerable:!0,get:function(){return n.CircuitState}}),Object.defineProperty(r,"ExponentialBackoff",{enumerable:!0,get:function(){return n.ExponentialBackoff}}),Object.defineProperty(r,"ConstantBackoff",{enumerable:!0,get:function(){return n.ConstantBackoff}}),Object.defineProperty(r,"handleAll",{enumerable:!0,get:function(){return n.handleAll}}),Object.defineProperty(r,"handleWhen",{enumerable:!0,get:function(){return n.handleWhen}}),r.DEFAULT_MAX_RETRIES=3,r.DEFAULT_MAX_CONSECUTIVE_FAILURES=3*(1+r.DEFAULT_MAX_RETRIES),r.DEFAULT_CIRCUIT_BREAK_DURATION=18e5,r.DEFAULT_DEGRADED_THRESHOLD=5e3;const s=e=>"object"!=typeof e||null===e||!("httpStatus"in e)||"number"!=typeof e.httpStatus||e.httpStatus>=500;r.createServicePolicy=function(e={}){const{maxRetries:t=r.DEFAULT_MAX_RETRIES,retryFilterPolicy:a=n.handleAll,maxConsecutiveFailures:o=r.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:i=r.DEFAULT_CIRCUIT_BREAK_DURATION,degradedThreshold:c=r.DEFAULT_DEGRADED_THRESHOLD,backoff:l=new n.ExponentialBackoff}=e,u=(0,n.retry)(a,{maxAttempts:t,backoff:l}),d=u.onRetry.bind(u),f=(0,n.circuitBreaker)((0,n.handleWhen)(s),{halfOpenAfter:i,breaker:new n.ConsecutiveBreaker(o)}),m=f.onBreak.bind(f),h=new n.EventEmitter;u.onGiveUp((()=>{f.state===n.CircuitState.Closed&&h.emit()})),u.onSuccess((({duration:e})=>{f.state===n.CircuitState.Closed&&e>c&&h.emit()}));const p=h.addListener;return{...(0,n.wrap)(u,f),circuitBreakerPolicy:f,retryPolicy:u,onBreak:m,onDegraded:p,onRetry:d}}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/create-service-policy.cjs"}],[1554,{"./constants.cjs":1552,"./create-service-policy.cjs":1553,"./siwe.cjs":1556,"./types.cjs":1557,"./util.cjs":1558},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.isEqualCaseInsensitive=r.weiHexToGweiDec=r.toHex=r.toChecksumHexAddress=r.timeoutFetch=r.successfulFetch=r.safelyExecuteWithTimeout=r.safelyExecute=r.query=r.normalizeEnsName=r.isValidHexAddress=r.isValidJson=r.isSmartContractCode=r.isSafeDynamicKey=r.isSafeChainId=r.isPlainObject=r.isNonEmptyArray=r.HttpError=r.hexToText=r.hexToBN=r.handleFetch=r.gweiDecToWEIBN=r.getBuyURL=r.fromHex=r.fractionBN=r.fetchWithErrorHandling=r.convertHexToDecimal=r.BNToHex=r.handleWhen=r.handleAll=r.createServicePolicy=r.ExponentialBackoff=r.DEFAULT_MAX_RETRIES=r.DEFAULT_MAX_CONSECUTIVE_FAILURES=r.DEFAULT_DEGRADED_THRESHOLD=r.DEFAULT_CIRCUIT_BREAK_DURATION=r.ConstantBackoff=r.CircuitState=r.BrokenCircuitError=void 0;var a=e("./create-service-policy.cjs");Object.defineProperty(r,"BrokenCircuitError",{enumerable:!0,get:function(){return a.BrokenCircuitError}}),Object.defineProperty(r,"CircuitState",{enumerable:!0,get:function(){return a.CircuitState}}),Object.defineProperty(r,"ConstantBackoff",{enumerable:!0,get:function(){return a.ConstantBackoff}}),Object.defineProperty(r,"DEFAULT_CIRCUIT_BREAK_DURATION",{enumerable:!0,get:function(){return a.DEFAULT_CIRCUIT_BREAK_DURATION}}),Object.defineProperty(r,"DEFAULT_DEGRADED_THRESHOLD",{enumerable:!0,get:function(){return a.DEFAULT_DEGRADED_THRESHOLD}}),Object.defineProperty(r,"DEFAULT_MAX_CONSECUTIVE_FAILURES",{enumerable:!0,get:function(){return a.DEFAULT_MAX_CONSECUTIVE_FAILURES}}),Object.defineProperty(r,"DEFAULT_MAX_RETRIES",{enumerable:!0,get:function(){return a.DEFAULT_MAX_RETRIES}}),Object.defineProperty(r,"ExponentialBackoff",{enumerable:!0,get:function(){return a.ExponentialBackoff}}),Object.defineProperty(r,"createServicePolicy",{enumerable:!0,get:function(){return a.createServicePolicy}}),Object.defineProperty(r,"handleAll",{enumerable:!0,get:function(){return a.handleAll}}),Object.defineProperty(r,"handleWhen",{enumerable:!0,get:function(){return a.handleWhen}}),s(e("./constants.cjs"),r);var o=e("./util.cjs");Object.defineProperty(r,"BNToHex",{enumerable:!0,get:function(){return o.BNToHex}}),Object.defineProperty(r,"convertHexToDecimal",{enumerable:!0,get:function(){return o.convertHexToDecimal}}),Object.defineProperty(r,"fetchWithErrorHandling",{enumerable:!0,get:function(){return o.fetchWithErrorHandling}}),Object.defineProperty(r,"fractionBN",{enumerable:!0,get:function(){return o.fractionBN}}),Object.defineProperty(r,"fromHex",{enumerable:!0,get:function(){return o.fromHex}}),Object.defineProperty(r,"getBuyURL",{enumerable:!0,get:function(){return o.getBuyURL}}),Object.defineProperty(r,"gweiDecToWEIBN",{enumerable:!0,get:function(){return o.gweiDecToWEIBN}}),Object.defineProperty(r,"handleFetch",{enumerable:!0,get:function(){return o.handleFetch}}),Object.defineProperty(r,"hexToBN",{enumerable:!0,get:function(){return o.hexToBN}}),Object.defineProperty(r,"hexToText",{enumerable:!0,get:function(){return o.hexToText}}),Object.defineProperty(r,"HttpError",{enumerable:!0,get:function(){return o.HttpError}}),Object.defineProperty(r,"isNonEmptyArray",{enumerable:!0,get:function(){return o.isNonEmptyArray}}),Object.defineProperty(r,"isPlainObject",{enumerable:!0,get:function(){return o.isPlainObject}}),Object.defineProperty(r,"isSafeChainId",{enumerable:!0,get:function(){return o.isSafeChainId}}),Object.defineProperty(r,"isSafeDynamicKey",{enumerable:!0,get:function(){return o.isSafeDynamicKey}}),Object.defineProperty(r,"isSmartContractCode",{enumerable:!0,get:function(){return o.isSmartContractCode}}),Object.defineProperty(r,"isValidJson",{enumerable:!0,get:function(){return o.isValidJson}}),Object.defineProperty(r,"isValidHexAddress",{enumerable:!0,get:function(){return o.isValidHexAddress}}),Object.defineProperty(r,"normalizeEnsName",{enumerable:!0,get:function(){return o.normalizeEnsName}}),Object.defineProperty(r,"query",{enumerable:!0,get:function(){return o.query}}),Object.defineProperty(r,"safelyExecute",{enumerable:!0,get:function(){return o.safelyExecute}}),Object.defineProperty(r,"safelyExecuteWithTimeout",{enumerable:!0,get:function(){return o.safelyExecuteWithTimeout}}),Object.defineProperty(r,"successfulFetch",{enumerable:!0,get:function(){return o.successfulFetch}}),Object.defineProperty(r,"timeoutFetch",{enumerable:!0,get:function(){return o.timeoutFetch}}),Object.defineProperty(r,"toChecksumHexAddress",{enumerable:!0,get:function(){return o.toChecksumHexAddress}}),Object.defineProperty(r,"toHex",{enumerable:!0,get:function(){return o.toHex}}),Object.defineProperty(r,"weiHexToGweiDec",{enumerable:!0,get:function(){return o.weiHexToGweiDec}}),Object.defineProperty(r,"isEqualCaseInsensitive",{enumerable:!0,get:function(){return o.isEqualCaseInsensitive}}),s(e("./types.cjs"),r),s(e("./siwe.cjs"),r)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/index.cjs"}],[1555,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("controller-utils")}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/logger.cjs"}],[1556,{"./logger.cjs":1555,"@metamask/utils":2976,"@spruceid/siwe-parser":3257,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.detectSIWE=r.isValidSIWEOrigin=r.parseDomainParts=void 0;const n=e("@metamask/utils"),s=e("@spruceid/siwe-parser"),a=e("./logger.cjs"),o=(0,a.createModuleLogger)(a.projectLogger,"detect-siwe");function i(e){try{const s="string"!=typeof(r=e)?r:(0,n.remove0x)(r),a=t.from(s,"hex");return 32===a.length?e:a.toString("utf8")}catch(t){return o(t),e}var r}const c={"http:":"80","https:":"443"};r.parseDomainParts=(e,t)=>e.match(/^[^/:]*:\/\//u)?new URL(e):new URL(`${t}//${e}`);r.isValidSIWEOrigin=e=>{try{const{origin:t,siwe:n}=e;if(!t||!n?.parsedMessage?.domain)return!1;const s=new URL(t),a=(0,r.parseDomainParts)(n.parsedMessage.domain,s.protocol);return 0===a.hostname.localeCompare(s.hostname,undefined,{sensitivity:"accent"})&&(""!==a.port&&a.port!==s.port?""===s.port&&a.port===c[s.protocol]:""===a.username||a.username===s.username)}catch(e){return o(e),!1}};r.detectSIWE=e=>{try{const{data:t}=e,r=i(t);return{isSIWEMessage:!0,parsedMessage:new s.ParsedMessage(r)}}catch(e){return{isSIWEMessage:!1,parsedMessage:null}}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/siwe.cjs"}],[1557,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s;Object.defineProperty(r,"__esModule",{value:!0}),r.NetworkNickname=r.BlockExplorerUrl=r.NetworksTicker=r.ChainId=r.BuiltInNetworkName=r.isInfuraNetworkType=r.isNetworkType=r.NetworkType=r.CustomNetworkType=r.InfuraNetworkType=void 0,r.InfuraNetworkType={mainnet:"mainnet",goerli:"goerli",sepolia:"sepolia","linea-goerli":"linea-goerli","linea-sepolia":"linea-sepolia","linea-mainnet":"linea-mainnet","base-mainnet":"base-mainnet"},r.CustomNetworkType={"megaeth-testnet":"megaeth-testnet","monad-testnet":"monad-testnet"},r.NetworkType={...r.InfuraNetworkType,...r.CustomNetworkType,rpc:"rpc"},r.isNetworkType=function(e){return Object.values(r.NetworkType).includes(e)},r.isInfuraNetworkType=function(e){return Object.keys(r.InfuraNetworkType).includes(e)},function(e){e.Mainnet="mainnet",e.Goerli="goerli",e.Sepolia="sepolia",e.LineaGoerli="linea-goerli",e.LineaSepolia="linea-sepolia",e.LineaMainnet="linea-mainnet",e.Aurora="aurora",e.MegaETHTestnet="megaeth-testnet",e.MonadTestnet="monad-testnet",e.BaseMainnet="base-mainnet"}(n||(r.BuiltInNetworkName=n={})),r.ChainId={[n.Mainnet]:"0x1",[n.Goerli]:"0x5",[n.Sepolia]:"0xaa36a7",[n.Aurora]:"0x4e454152",[n.LineaGoerli]:"0xe704",[n.LineaSepolia]:"0xe705",[n.LineaMainnet]:"0xe708",[n.MegaETHTestnet]:"0x18c6",[n.MonadTestnet]:"0x279f",[n.BaseMainnet]:"0x2105"},function(e){e.mainnet="ETH",e.goerli="GoerliETH",e.sepolia="SepoliaETH",e["linea-goerli"]="LineaETH",e["linea-sepolia"]="LineaETH",e["linea-mainnet"]="ETH",e["megaeth-testnet"]="MegaETH",e["monad-testnet"]="MON",e["base-mainnet"]="ETH",e.rpc=""}(s||(r.NetworksTicker=s={})),r.BlockExplorerUrl={[n.Mainnet]:"https://etherscan.io",[n.Goerli]:"https://goerli.etherscan.io",[n.Sepolia]:"https://sepolia.etherscan.io",[n.LineaGoerli]:"https://goerli.lineascan.build",[n.LineaSepolia]:"https://sepolia.lineascan.build",[n.LineaMainnet]:"https://lineascan.build",[n.MegaETHTestnet]:"https://megaexplorer.xyz",[n.MonadTestnet]:"https://testnet.monadexplorer.com",[n.BaseMainnet]:"https://basescan.org"},r.NetworkNickname={[n.Mainnet]:"Ethereum Mainnet",[n.Goerli]:"Goerli",[n.Sepolia]:"Sepolia",[n.LineaGoerli]:"Linea Goerli",[n.LineaSepolia]:"Linea Sepolia",[n.LineaMainnet]:"Linea",[n.MegaETHTestnet]:"Mega Testnet",[n.MonadTestnet]:"Monad Testnet",[n.BaseMainnet]:"Base Mainnet"}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/types.cjs"}],[1558,{"./constants.cjs":1552,"@ethereumjs/util":525,"@metamask/ethjs-unit":1999,"@metamask/utils":2976,"bn.js":4047,buffer:4108,"eth-ens-namehash":4316,"fast-deep-equal":4469},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.isEqualCaseInsensitive=r.isValidJson=r.isNonEmptyArray=r.isPlainObject=r.convertHexToDecimal=r.query=r.normalizeEnsName=r.timeoutFetch=r.fetchWithErrorHandling=r.handleFetch=r.successfulFetch=r.HttpError=r.isSmartContractCode=r.isValidHexAddress=r.toChecksumHexAddress=r.safelyExecuteWithTimeout=r.safelyExecute=r.toHex=r.fromHex=r.hexToText=r.hexToBN=r.getBuyURL=r.weiHexToGweiDec=r.gweiDecToWEIBN=r.fractionBN=r.BNToHex=r.isSafeChainId=r.isSafeDynamicKey=r.PROTOTYPE_POLLUTION_BLOCKLIST=void 0;const s=e("@ethereumjs/util"),a=e("@metamask/ethjs-unit"),o=e("@metamask/utils"),i=n(e("bn.js")),c=n(e("eth-ens-namehash")),l=n(e("fast-deep-equal")),u=e("./constants.cjs"),d=new Error("timeout");function f(e){return e?new i.default((0,o.remove0x)(e),16):new i.default(0)}r.PROTOTYPE_POLLUTION_BLOCKLIST=["__proto__","constructor","prototype"],r.isSafeDynamicKey=function(e){return"string"==typeof e&&!r.PROTOTYPE_POLLUTION_BLOCKLIST.some((t=>e===t))},r.isSafeChainId=function(e){if(!(0,o.isHexString)(e))return!1;const t=Number.parseInt(e,(0,o.isStrictHexString)(e)?16:10);return Number.isSafeInteger(t)&&t>0&&t<=u.MAX_SAFE_CHAIN_ID},r.BNToHex=function(e){return(0,o.add0x)(e.toString(16))},r.fractionBN=function(e,t,r){const n=new i.default(t),s=new i.default(r);return e.mul(n).div(s)},r.gweiDecToWEIBN=function(e){if(Number.isNaN(e))return new i.default(0);const t=e.toString().split("."),r=t[0]||"0";let n=t[1]||"";if(!n)return(0,a.toWei)(r,"gwei");if(n.length<=9)return(0,a.toWei)(`${r}.${n}`,"gwei");const s=n.slice(9)[0];n=n.slice(0,9);let o=(0,a.toWei)(`${r}.${n}`,"gwei");return Number(s)>=5&&(o=o.add(new i.default(1))),o},r.weiHexToGweiDec=function(e){const t=new i.default((0,o.remove0x)(e),16);return(0,a.fromWei)(t,"gwei")},r.getBuyURL=function(e="1",t,r=5){switch(e){case"1":return`https://buy.coinbase.com/?code=9ec56d01-7e81-5017-930c-513daa27bb6a&amount=${r}&address=${t}&crypto_currency=ETH`;case"5":return"https://goerli-faucet.slock.it/";case"11155111":return"https://sepoliafaucet.net/";default:return undefined}},r.hexToBN=f,r.hexToText=function(e){try{const r=(0,o.remove0x)(e);return t.from(r,"hex").toString("utf8")}catch(t){return e}},r.fromHex=function(e){return i.default.isBN(e)?e:new i.default(f(e).toString(10))},r.toHex=function(e){return"string"==typeof e&&(0,o.isStrictHexString)(e)?e:`0x${i.default.isBN(e)||"bigint"==typeof e?e.toString(16):new i.default(e.toString(),10).toString(16)}`},r.safelyExecute=async function(e,t=!1){try{return await e()}catch(e){return t&&console.error(e),undefined}},r.safelyExecuteWithTimeout=async function(e,t=!1,r=500){try{return await Promise.race([e(),new Promise(((e,t)=>setTimeout((()=>{t(d)}),r)))])}catch(e){return t&&console.error(e),undefined}},r.toChecksumHexAddress=function(e){if("string"!=typeof e)return e;const t=(0,o.add0x)(e);return(0,o.isHexString)(t)?(0,s.toChecksumAddress)(t):t},r.isValidHexAddress=function(e,{allowNonPrefixed:t=!0}={}){const r=t?(0,o.add0x)(e):e;return!!(0,o.isStrictHexString)(r)&&(0,s.isValidAddress)(r)},r.isSmartContractCode=function(e){return!!e&&("0x"!==e&&"0x0"!==e)};class m extends Error{constructor(e,t){super(t||`Fetch failed with status '${e}'`),this.httpStatus=e}}async function h(e,t){const r=await fetch(e,t);if(!r.ok)throw new m(r.status,`Fetch failed with status '${r.status}' for request '${String(e)}'`);return r}async function p(e,t){const r=await h(e,t);return await r.json()}r.HttpError=m,r.successfulFetch=h,r.handleFetch=p,r.fetchWithErrorHandling=async function({url:e,options:t,timeout:r,errorCodesToCatch:n}){let s;try{s=r?Promise.race([await p(e,t),new Promise(((e,t)=>setTimeout((()=>{t(d)}),r)))]):await p(e,t)}catch(e){!function(e,t=[]){if(!e)return;if(!(e instanceof Error))throw e;if(!t.some((t=>e.message.includes(`Fetch failed with status '${t}'`)))&&!e.message.includes("Failed to fetch")&&e!==d)throw e;console.error(e)}(e,n)}return s},r.timeoutFetch=async function(e,t,r=500){return Promise.race([h(e,t),new Promise(((e,t)=>setTimeout((()=>{t(d)}),r)))])},r.normalizeEnsName=function(e){if("."===e)return e;if(e&&"string"==typeof e)try{const t=c.default.normalize(e.trim());if(t.match(/^(([\w\d-]+)\.)*[\w\d-]{7,}\.(eth|test)$/u))return t}catch(e){}return null},r.query=function(e,t,r=[]){return new Promise(((n,s)=>{const a=(e,t)=>{e?s(e):n(t)};t in e&&"function"==typeof e[t]?e[t](...r,a):e.sendAsync({method:t,params:r},a)}))};r.convertHexToDecimal=(e="0x0")=>(0,o.isStrictHexString)(e)?parseInt(e,16):Number(e)?Number(e):0,r.isPlainObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)},r.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},r.isValidJson=function(e){try{return(0,l.default)(e,JSON.parse(JSON.stringify(e)))}catch(e){return!1}},r.isEqualCaseInsensitive=function(e,t){return"string"==typeof e&&"string"==typeof t&&e.toLowerCase()===t.toLowerCase()}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/util.cjs"}],[1563,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n={DelegationManager:"0xdb9B1e94B5b69Df7e401DDbedE43491141047dB3",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x69Aa2f9fe1572F1B640E1bbc512f5c3a734fc77c",MultiSigDeleGatorImpl:"0x56a9EdB16a0105eb5a4C54f4C062e2868844f3A7",HybridDeleGatorImpl:"0x48dBe696A4D990079e039489bA2053B36E8FFEC4",EIP7702StatelessDeleGatorImpl:"0x63c0c19a282a1B52b07dD5a65b58948A07DAE32B",AllowedCalldataEnforcer:"0xc2b0d624c1c4319760C96503BA27C347F3260f55",AllowedMethodsEnforcer:"0x2c21fD0Cb9DC8445CB3fb0DC5E7Bb0Aca01842B5",AllowedTargetsEnforcer:"0x7F20f61b1f09b08D970938F6fa563634d65c4EeB",BlockNumberEnforcer:"0x5d9818dF0AE3f66e9c3D0c5029DAF99d1823ca6c",DeployedEnforcer:"0x24ff2AA430D53a8CD6788018E902E098083dcCd2",ERC20BalanceChangeEnforcer:"0xcdF6aB796408598Cea671d79506d7D48E97a5437",ERC20TransferAmountEnforcer:"0xf100b0819427117EcF76Ed94B358B1A5b5C6D2Fc",ERC20PeriodTransferEnforcer:"0x474e3Ae7E169e940607cC624Da8A15Eb120139aB",ERC20StreamingEnforcer:"0x56c97aE02f233B29fa03502Ecc0457266d9be00e",ERC721BalanceChangeEnforcer:"0x8aFdf96eDBbe7e1eD3f5Cd89C7E084841e12A09e",ERC721TransferEnforcer:"0x3790e6B7233f779b09DA74C72b6e94813925b9aF",ERC1155BalanceChangeEnforcer:"0x63c322732695cAFbbD488Fc6937A0A7B66fC001A",ExactCalldataBatchEnforcer:"0x982FD5C86BBF425d7d1451f974192d4525113DfD",ExactCalldataEnforcer:"0x99F2e9bF15ce5eC84685604836F71aB835DBBdED",ExactExecutionBatchEnforcer:"0x1e141e455d08721Dd5BCDA1BaA6Ea5633Afd5017",ExactExecutionEnforcer:"0x146713078D39eCC1F5338309c28405ccf85Abfbb",IdEnforcer:"0xC8B5D93463c893401094cc70e66A206fb5987997",LimitedCallsEnforcer:"0x04658B29F6b82ed55274221a06Fc97D318E25416",NativeBalanceChangeEnforcer:"0xbD7B277507723490Cd50b12EaaFe87C616be6880",ArgsEqualityCheckEnforcer:"0x44B8C6ae3C304213c3e298495e12497Ed3E56E41",NativeTokenPaymentEnforcer:"0x4803a326ddED6dDBc60e659e5ed12d85c7582811",NativeTokenTransferAmountEnforcer:"0xF71af580b9c3078fbc2BBF16FbB8EEd82b330320",NativeTokenStreamingEnforcer:"0xD10b97905a320b13a0608f7E9cC506b56747df19",NativeTokenPeriodTransferEnforcer:"0x9BC0FAf4Aca5AE429F4c06aEEaC517520CB16BD9",NonceEnforcer:"0xDE4f2FAC4B3D87A1d9953Ca5FC09FCa7F366254f",OwnershipTransferEnforcer:"0x7EEf9734E7092032B5C56310Eb9BbD1f4A524681",RedeemerEnforcer:"0xE144b0b2618071B4E56f746313528a669c7E65c5",SpecificActionERC20TransferBatchEnforcer:"0x00e0251aaA263dfE3B3541B758A82D1CBA1c3B6D",TimestampEnforcer:"0x1046bb45C8d673d4ea75321280DB34899413c069",ValueLteEnforcer:"0x92Bf12322527cAA612fd31a0e810472BBB106A8F",MultiTokenPeriodEnforcer:"0xFB2f1a9BD76d3701B730E5d69C3219D42D80eBb7"},s={DelegationManager:"0x56D56e07e3d6Ee5a24e30203A37a0a460f42D7A3",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",MultiSigDeleGatorImpl:"0xd1f421EDbA5e3FA9efe3874827114b20C5BEC40C",HybridDeleGatorImpl:"0x941f3a016F8726d5643Ce62452d0D78492D42b42",AllowedCalldataEnforcer:"0xff71d60f3208469cBCE0859717B5198042DCB3F3",AllowedMethodsEnforcer:"0xe32C2561792e8446Abe73B9f557B881C13906186",AllowedTargetsEnforcer:"0x06aaE4c67EEA95277c46Bf79b1583d4a01772D22",BlockNumberEnforcer:"0x8E470D2Ae278457b42d2405E0B8Cd4BE21Ed9045",DeployedEnforcer:"0xf9088f013dBD9ebb7Cebd66fEB48253c6Ac5a820",ERC20BalanceGteEnforcer:"0xB7B6f32ec6343261D814e55Ed8C5925d91Cab861",ERC20TransferAmountEnforcer:"0x9A069b18032B31429A363AeCFb1B6A0564b44471",IdEnforcer:"0x91015c3b9D9523966eD2399885e5Df7A567f916c",LimitedCallsEnforcer:"0xe694bFfffEA3E85923b1210b37e6a0175e910863",NonceEnforcer:"0xE83BCFD8bBE672A96747e831050a91cf44F4F87A",TimestampEnforcer:"0x550FdD13eEBC1f22ea2a2480024BacBF0Ad7e5CE",ValueLteEnforcer:"0xBE32a6DB7471F63BB168C088c57Db01AfAe87967",NativeTokenTransferAmountEnforcer:"0x5eD3833d7B957A8DB8A461c3AF2d668Ec25382E0",NativeBalanceGteEnforcer:"0x376a98860E210DdEda3689fb39565592c563cB0A",ArgsEqualityCheckEnforcer:"0x7378dE585998d3E18Ce147867C335C25B3dB8Ee5",NativeTokenPaymentEnforcer:"0x87Fe18EbF99e42fcE8A03a25F1d20E119407f8e7",RedeemerEnforcer:"0x926672b130D1EF60A9d6b11D2048d121b30f40C1"},a={DelegationManager:"0xbe4138886cb096bdc1b930f2f0ca7892aa234d78",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",MultiSigDeleGatorImpl:"0x11f555af5844d85bfcf5d61d2a22866527eb585a",HybridDeleGatorImpl:"0xd6edd1256deccb2b06bdecef92dc16bcf26e531b",AllowedCalldataEnforcer:"0x48db3835a873d64a4af2c09f014052407c003bd7",AllowedMethodsEnforcer:"0xfd731951bf1c52afccee3e6f14ab656475b76dd4",AllowedTargetsEnforcer:"0xbc8673c0afa52d86d991c06881e55b2966920564",BlockNumberEnforcer:"0xc15faffa0d879b9263c15a46ce31eacfa2e0e8ae",DeployedEnforcer:"0x5accb9559b56a6c1e3f90e342c85c42d93720d43",ERC20BalanceGteEnforcer:"0xb5d6b1ec6d868a3bae5b7f48178eaa2686a7a087",ERC20TransferAmountEnforcer:"0x92ac423b9c111962179a6242e1adb58d02c103be",IdEnforcer:"0x34152d9f3f8f74338d50703e780389e829b4abac",LimitedCallsEnforcer:"0x4b3adad4a328bee8ba17b86074d92fe7372180cd",NonceEnforcer:"0x2f32ff3fc3086d7f63f16fe8d0065390d460b40d",TimestampEnforcer:"0x78e05f779490c24bf3bfa135b4112e7003b321cd",ValueLteEnforcer:"0xfc20ede0a1132e839fbda9d7ed3904ff3c89540f"},o={mainnet:1,polygon:137,bsc:56,optimism:10,arbitrum:42161,linea:59144,base:8453,gnosis:100,sepolia:11155111,lineaSepolia:59141,baseSepolia:84532,megaEthTestnet:6342,chiado:10200,lineaGoerli:59140},i={"1.0.0":{[o.optimism]:a,[o.polygon]:a,[o.base]:a,[o.arbitrum]:a,[o.linea]:a,[o.sepolia]:{...a,HybridDeleGatorImpl:"0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"},[o.lineaSepolia]:{...a,HybridDeleGatorImpl:"0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"}},"1.1.0":{[o.arbitrum]:s,[o.base]:s,[o.linea]:s,[o.optimism]:s,[o.polygon]:s,[o.sepolia]:s,[o.lineaSepolia]:s,[o.baseSepolia]:{...s,SimpleFactory:"0xE8eA1DE8D6AfE400B7C8C1A81B7C29B7876b4d02"}},"1.3.0":{[o.mainnet]:n,[o.polygon]:n,[o.bsc]:n,[o.optimism]:n,[o.arbitrum]:n,[o.linea]:n,[o.base]:n,[o.gnosis]:n,[o.sepolia]:n,[o.lineaSepolia]:n,[o.baseSepolia]:n,[o.megaEthTestnet]:n,[o.chiado]:n}};r.CHAIN_ID=o,r.DELEGATOR_CONTRACTS=i}}},{package:"@metamask/delegation-deployments",file:"node_modules/@metamask/delegation-deployments/dist/index.js"}],[1590,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js"}],[1591,{"./logging-utils":1593,"@metamask/safe-event-emitter":2529,"@metamask/utils":2976,"json-rpc-random-id":4729},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a,o,i,c,l,u=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},d=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},f=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.PollingBlockTracker=void 0;const m=f(e("@metamask/safe-event-emitter")),h=e("@metamask/utils"),p=f(e("json-rpc-random-id")),g=e("./logging-utils"),b=(0,g.createModuleLogger)(g.projectLogger,"polling-block-tracker"),y=(0,p.default)(),E=["sync","latest"];class w extends m.default{constructor(e={}){if(!e.provider)throw new Error("PollingBlockTracker - no provider specified.");super(),n.add(this),s.set(this,[]),a.set(this,void 0),o.set(this,void 0),this._blockResetDuration=e.blockResetDuration||2e4,this._usePastBlocks=e.usePastBlocks||!1,this._currentBlock=null,this._isRunning=!1,this._onNewListener=this._onNewListener.bind(this),this._onRemoveListener=this._onRemoveListener.bind(this),this._resetCurrentBlock=this._resetCurrentBlock.bind(this),this._setupInternalEvents(),this._provider=e.provider,this._pollingInterval=e.pollingInterval||2e4,this._retryTimeout=e.retryTimeout||this._pollingInterval/10,this._keepEventLoopActive=e.keepEventLoopActive===undefined||e.keepEventLoopActive,this._setSkipCacheFlag=e.setSkipCacheFlag||!1}async destroy(){this._cancelBlockResetTimeout(),super.removeAllListeners(),this._maybeEnd()}isRunning(){return this._isRunning}getCurrentBlock(){return this._currentBlock}async getLatestBlock(){if(this._currentBlock)return this._currentBlock;if(u(this,a,"f"))return await u(this,a,"f").promise;const{promise:e,resolve:t,reject:r}=(0,h.createDeferredPromise)({suppressUnhandledRejection:!0});d(this,a,{reject:r,promise:e},"f");try{if(!this._isRunning){const e=await this._fetchLatestBlock();return this._newPotentialLatest(e),t(e),e}const r=e=>{u(this,n,"m",c).call(this,r),this.removeListener("latest",r),t(e)};return u(this,n,"m",i).call(this,r),this.once("latest",r),await e}catch(e){throw r(e),e}finally{d(this,a,undefined,"f")}}removeAllListeners(e){return e?super.removeAllListeners(e):super.removeAllListeners(),this._setupInternalEvents(),this._onRemoveListener(),this}_setupInternalEvents(){this.removeListener("newListener",this._onNewListener),this.removeListener("removeListener",this._onRemoveListener),this.on("newListener",this._onNewListener),this.on("removeListener",this._onRemoveListener)}_onNewListener(e){E.includes(e)&&this._maybeStart()}_onRemoveListener(){this._getBlockTrackerEventCount()>0||this._maybeEnd()}_maybeStart(){this._isRunning||(this._isRunning=!0,this._cancelBlockResetTimeout(),this._start(),this.emit("_started"))}_maybeEnd(){this._isRunning&&(this._isRunning=!1,this._setupBlockResetTimeout(),this._end(),u(this,n,"m",l).call(this,new Error("Block tracker destroyed")),this.emit("_ended"))}_getBlockTrackerEventCount(){return E.map((e=>this.listeners(e))).flat().filter((e=>u(this,s,"f").every((t=>!Object.is(t,e))))).length}_shouldUseNewBlock(e){const t=this._currentBlock;if(!t)return!0;const r=k(e),n=k(t);return this._usePastBlocks&&r<n||r>n}_newPotentialLatest(e){this._shouldUseNewBlock(e)&&this._setCurrentBlock(e)}_setCurrentBlock(e){const t=this._currentBlock;this._currentBlock=e,this.emit("latest",e),this.emit("sync",{oldBlock:t,newBlock:e})}_setupBlockResetTimeout(){this._cancelBlockResetTimeout(),this._blockResetTimeout=setTimeout(this._resetCurrentBlock,this._blockResetDuration),this._blockResetTimeout.unref&&this._blockResetTimeout.unref()}_cancelBlockResetTimeout(){this._blockResetTimeout&&clearTimeout(this._blockResetTimeout)}_resetCurrentBlock(){this._currentBlock=null}async checkForLatestBlock(){return await this._updateLatestBlock(),await this.getLatestBlock()}_start(){this._updateAndQueue()}_end(){this._clearPollingTimeout()}async _updateLatestBlock(){const e=await this._fetchLatestBlock();this._newPotentialLatest(e)}async _fetchLatestBlock(){if(u(this,o,"f"))return await u(this,o,"f").promise;const{promise:e,resolve:t,reject:r}=(0,h.createDeferredPromise)({suppressUnhandledRejection:!0});d(this,o,{reject:r,promise:e},"f");try{const e={jsonrpc:"2.0",id:y(),method:"eth_blockNumber",params:[]};this._setSkipCacheFlag&&(e.skipCache=!0),b("Making request",e);const r=await this._provider.request(e);return b("Got result",r),t(r),r}catch(e){throw b("Encountered error fetching block",(0,h.getErrorMessage)(e)),r(e),u(this,n,"m",l).call(this,e),e}finally{d(this,o,undefined,"f")}}async _updateAndQueue(){let e=this._pollingInterval;try{await this._updateLatestBlock()}catch(t){try{this.emit("error",t)}catch(e){console.error(`Error updating latest block: ${(0,h.getErrorMessage)(t)}`)}e=this._retryTimeout}if(!this._isRunning)return;this._clearPollingTimeout();const t=setTimeout((()=>{this._updateAndQueue()}),e);t.unref&&!this._keepEventLoopActive&&t.unref(),this._pollingTimeout=t,this.emit("_waitingForNextIteration")}_clearPollingTimeout(){this._pollingTimeout&&(clearTimeout(this._pollingTimeout),this._pollingTimeout=undefined)}}function k(e){return Number.parseInt(e,16)}r.PollingBlockTracker=w,s=new WeakMap,a=new WeakMap,o=new WeakMap,n=new WeakSet,i=function(e){u(this,s,"f").push(e)},c=function(e){u(this,s,"f").splice(u(this,s,"f").indexOf(e),1)},l=function(e){var t;null===(t=u(this,a,"f"))||void 0===t||t.reject(e),d(this,a,undefined,"f")}}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js"}],[1592,{"./BlockTracker":1590,"./PollingBlockTracker":1591},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./PollingBlockTracker"),r),s(e("./BlockTracker"),r)}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/index.js"}],[1593,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("eth-block-tracker")}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/logging-utils.js"}],[1594,{"@ethereumjs/util":525,"@metamask/eth-sig-util":1617,"@metamask/key-tree":2046,"@metamask/scure-bip39":2530,"@metamask/scure-bip39/dist/wordlists/english.js":2531,"@metamask/utils":2976,buffer:4108,"ethereum-cryptography/hdkey":4336,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n,s,a,o,i,c,l,u,d,f,m,h=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},p=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)};Object.defineProperty(r,"__esModule",{value:!0}),r.HdKeyring=void 0;const g=e("@ethereumjs/util"),b=e("@metamask/eth-sig-util"),y=e("@metamask/key-tree"),E=e("@metamask/scure-bip39"),w=e("@metamask/scure-bip39/dist/wordlists/english.js"),k=e("@metamask/utils"),v=e("ethereum-cryptography/hdkey"),x=e("ethereum-cryptography/keccak"),A="m/44'/60'/0'/0",T="HD Key Tree";class B{constructor(e={}){n.add(this),this.type=T,this.hdPath=A,s.set(this,[]),a.set(this,void 0),h(this,a,e.cryptographicFunctions,"f")}async generateRandomMnemonic(){await p(this,n,"m",d).call(this,(0,E.generateMnemonic)(w.wordlist))}async serialize(){let e=[];if(this.mnemonic){const t=p(this,n,"m",o).call(this,this.mnemonic);e=Array.from((new TextEncoder).encode(t))}return{mnemonic:e,numberOfAccounts:p(this,s,"f").length,hdPath:this.hdPath}}async deserialize(e={}){if(e.numberOfAccounts&&!e.mnemonic)throw new Error("Eth-Hd-Keyring: Deserialize method cannot be called with an opts value for numberOfAccounts and no menmonic");if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");return h(this,s,[],"f"),this.mnemonic=null,this.seed=null,this.root=null,this.hdPath=e.hdPath??A,e.mnemonic&&await p(this,n,"m",d).call(this,e.mnemonic),e.numberOfAccounts?this.addAccounts(e.numberOfAccounts):[]}async addAccounts(e=1){if(!this.root)throw new Error("Eth-Hd-Keyring: No secret recovery phrase provided");const t=p(this,s,"f").length,r=[];for(let n=t;n<e+t;n++){const e=this.root.deriveChild(n);r.push(e),p(this,s,"f").push(e)}const a=r.map((e=>((0,k.assert)(e.publicKey,"Expected public key to be set"),p(this,n,"m",f).call(this,e.publicKey))));return Promise.resolve(a)}getAccounts(){return p(this,s,"f").map((e=>((0,k.assert)(e.publicKey,"Expected public key to be set"),p(this,n,"m",f).call(this,e.publicKey))))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const r=p(this,n,"m",u).call(this,e,{withAppKeyOrigin:t});(0,k.assert)(r.publicKey,"Expected public key to be set");return p(this,n,"m",m).call(this,(0,k.bytesToHex)((0,g.publicToAddress)(r.publicKey)))}async exportAccount(e,t){const r=t?p(this,n,"m",u).call(this,e,t):p(this,n,"m",u).call(this,e),{privateKey:s}=r;return(0,k.assert)(s instanceof Uint8Array,"Expected private key to be of type Uint8Array"),(0,k.remove0x)((0,k.bytesToHex)(s))}async signTransaction(e,r,s={}){const a=p(this,n,"m",l).call(this,e,s);return r.sign(t.from(a))??r}async signMessage(e,r,s={}){(0,k.assertIsHexString)(r);const a=(0,k.remove0x)(r),o=p(this,n,"m",l).call(this,e,s),i=(0,g.ecsign)(t.from(a,"hex"),t.from(o));return(0,b.concatSig)(t.from((0,k.bigIntToBytes)(i.v)),t.from(i.r),t.from(i.s))}async signPersonalMessage(e,r,s={}){const a=p(this,n,"m",l).call(this,e,s),o=t.from(a);return(0,b.personalSign)({privateKey:o,data:r})}async decryptMessage(e,r){const s=p(this,n,"m",u).call(this,e),{privateKey:a}=s;(0,k.assert)(a,"Expected private key to be set");const o=t.from(a).toString("hex");return(0,b.decrypt)({privateKey:o,encryptedData:r})}async signTypedData(e,r,s={version:b.SignTypedDataVersion.V1}){const a=Object.keys(b.SignTypedDataVersion).includes(s.version)?s.version:b.SignTypedDataVersion.V1,o=p(this,n,"m",l).call(this,e,s);return(0,b.signTypedData)({privateKey:t.from(o),data:r,version:a})}async signEip7702Authorization(e,r,s){const a=p(this,n,"m",l).call(this,e,s);return(0,b.signEIP7702Authorization)({privateKey:t.from(a),authorization:r})}removeAccount(e){const t=p(this,n,"m",m).call(this,e);if(!p(this,s,"f").map((({publicKey:e})=>e&&p(this,n,"m",f).call(this,e))).includes(t))throw new Error(`Address ${t} not found in this keyring`);h(this,s,p(this,s,"f").filter((({publicKey:e})=>e&&p(this,n,"m",f).call(this,e)!==t)),"f")}async getEncryptionPublicKey(e,t={}){const r=p(this,n,"m",l).call(this,e,t);return(0,b.getEncryptionPublicKey)((0,k.remove0x)((0,k.bytesToHex)(r)))}}r.HdKeyring=B,s=new WeakMap,a=new WeakMap,n=new WeakSet,o=function(e){return Array.from(new Uint16Array(new Uint8Array(e).buffer)).map((e=>w.wordlist[e])).join(" ")},i=function(e){const t=e.split(" ").map((e=>w.wordlist.indexOf(e)));return new Uint8Array(new Uint16Array(t).buffer)},c=function(e){let r=e;var s;if("object"==typeof(s=e)&&null!==s&&"type"in s&&"Buffer"===s.type&&"data"in s&&Array.isArray(s.data)&&(r=e.data),"string"==typeof r||t.isBuffer(r)||Array.isArray(r)){let e;return e=Array.isArray(r)?t.from(r).toString():t.isBuffer(r)?r.toString():r,p(this,n,"m",i).call(this,e)}return r instanceof Object&&!(r instanceof Uint8Array)?Uint8Array.from(Object.values(r)):((0,k.assert)(r instanceof Uint8Array,"Expected Uint8Array mnemonic"),r)},l=function(e,t){if(!e)throw new Error("Must specify address.");const r=p(this,n,"m",u).call(this,e,t);return(0,k.assert)(r.privateKey,"Missing private key"),r.privateKey},u=function(e,{withAppKeyOrigin:r}={}){const a=p(this,n,"m",m).call(this,e),o=p(this,s,"f").find((({publicKey:e})=>e&&p(this,n,"m",f).call(this,e)===a));if(!o)throw new Error("HD Keyring - Unable to find matching address.");if(r){const{privateKey:e}=o;(0,k.assert)(e,"Expected private key to be set");const n=t.from(r,"utf8"),s=t.concat([e,n]),a=t.from((0,x.keccak256)(s));return{privateKey:a,publicKey:t.from((0,g.privateToPublic)(a))}}return o},d=async function(e){if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");this.mnemonic=p(this,n,"m",c).call(this,e),this.seed=await(0,y.mnemonicToSeed)(this.mnemonic,"",p(this,a,"f")),this.hdWallet=v.HDKey.fromMasterSeed(this.seed),this.root=this.hdWallet.derive(this.hdPath)},f=function(e){return(0,k.add0x)((0,k.bytesToHex)((0,g.publicToAddress)(t.from(e),!0)).toLowerCase())},m=function(e){const t=(0,b.normalize)(e);return(0,k.assert)(t,"Expected address to be set"),(0,k.add0x)(t)},B.type=T}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"}],[1595,{"./hd-keyring.cjs":1594},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.HdKeyring=void 0;var n=e("./hd-keyring.cjs");Object.defineProperty(r,"HdKeyring",{enumerable:!0,get:function(){return n.HdKeyring}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/index.cjs"}],[1596,{"./errors":1597,"./packer":1600,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.decodeSingle=r.decode=r.encodePacked=r.encodeSingle=r.encode=void 0;const n=e("@metamask/utils"),s=e("./errors"),a=e("./packer");r.encode=(e,t,r,n)=>{try{return(0,a.pack)({types:e,values:t,packed:r,tight:n})}catch(e){if(e instanceof s.ParserError)throw new s.ParserError(`Unable to encode value: ${e.message}`,e);throw new s.ParserError(`An unexpected error occurred: ${(0,s.getErrorMessage)(e)}`,e)}};r.encodeSingle=(e,t)=>(0,r.encode)([e],[t]);r.encodePacked=(e,t,n)=>(0,r.encode)(e,t,!0,n);r.decode=(e,t)=>{const r=(0,n.createBytes)(t);try{return(0,a.unpack)(e,r)}catch(e){if(e instanceof s.ParserError)throw new s.ParserError(`Unable to decode value: ${e.message}`,e);throw new s.ParserError(`An unexpected error occurred: ${(0,s.getErrorMessage)(e)}`,e)}};r.decodeSingle=(e,t)=>{const a=(0,r.decode)([e],t);return(0,n.assert)(1===a.length,new s.ParserError("Decoded value array has unexpected length.")),a[0]}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/abi.js"}],[1597,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ParserError=r.getErrorStack=r.getErrorMessage=void 0;const n=e("@metamask/utils");r.getErrorMessage=e=>"string"==typeof e?e:e instanceof Error||(0,n.isObject)(e)&&(0,n.hasProperty)(e,"message")&&"string"==typeof e.message?e.message:"Unknown error.";r.getErrorStack=e=>e instanceof Error?e.stack:undefined;class s extends Error{constructor(e,t){super(e),this.name="ParserError";const n=(0,r.getErrorStack)(t);n&&(this.stack=n)}}r.ParserError=s}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js"}],[1598,{"./abi":1596,"./errors":1597,"./types":1613},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./abi"),r),s(e("./errors"),r),s(e("./types"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/index.js"}],[1599,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.iterate=void 0;const n=e("@metamask/utils");r.iterate=function*(e,t=32){for(let r=0;r<e.length;r+=t){const s=e=>{(0,n.assert)(e>=0,"Cannot skip a negative number of bytes."),(0,n.assert)(e%t==0,"Length must be a multiple of the size."),r+=e},a=e.subarray(r);yield{skip:s,value:a}}return{skip:()=>undefined,value:new Uint8Array}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/iterator.js"}],[1600,{"./errors":1597,"./iterator":1599,"./parsers":1607,"./utils":1615,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.unpack=r.pack=r.isDynamicParser=r.getParser=void 0;const n=e("@metamask/utils"),s=e("./errors"),a=e("./iterator"),o=e("./parsers"),i=e("./utils");r.getParser=e=>{const t={address:o.address,array:o.array,bool:o.bool,bytes:o.bytes,fixedBytes:o.fixedBytes,function:o.fn,number:o.number,string:o.string,tuple:o.tuple},r=t[e];if(r)return r;const n=Object.values(t).find((t=>t.isType(e)));if(n)return n;throw new s.ParserError(`The type "${e}" is not supported.`)};r.isDynamicParser=(e,t)=>{const{isDynamic:r}=e;return"function"==typeof r?r(t):r};r.pack=({types:e,values:t,packed:a=!1,tight:o=!1,arrayPacked:c=!1,byteArray:l=new Uint8Array})=>{(0,n.assert)(e.length===t.length,new s.ParserError(`The number of types (${e.length}) does not match the number of values (${t.length}).`));const{staticBuffer:u,dynamicBuffer:d,pointers:f}=e.reduce((({staticBuffer:e,dynamicBuffer:s,pointers:i},l,u)=>{const d=(0,r.getParser)(l),f=t[u];if(a||c||!(0,r.isDynamicParser)(d,l))return{staticBuffer:d.encode({buffer:e,value:f,type:l,packed:a,tight:o}),dynamicBuffer:s,pointers:i};return{staticBuffer:(0,n.concatBytes)([e,new Uint8Array(32)]),dynamicBuffer:d.encode({buffer:s,value:f,type:l,packed:a,tight:o}),pointers:[...i,{position:e.length,pointer:s.length}]}}),{staticBuffer:new Uint8Array,dynamicBuffer:new Uint8Array,pointers:[]});(0,n.assert)(!a&&!c||0===d.length,new s.ParserError("Invalid pack state."));const m=u.length,h=f.reduce(((e,{pointer:t,position:r})=>{const s=(0,i.padStart)((0,n.numberToBytes)(m+t));return(0,i.set)(e,s,r)}),u);return(0,n.concatBytes)([l,h,d])};r.unpack=(e,t)=>{const o=(0,a.iterate)(t);return e.map((e=>{const{value:{value:a,skip:i},done:c}=o.next();(0,n.assert)(!c,new s.ParserError(`The encoded value is invalid for the provided types. Reached end of buffer while attempting to parse "${e}".`));const l=(0,r.getParser)(e);if((0,r.isDynamicParser)(l,e)){const r=(0,n.bytesToNumber)(a.subarray(0,32)),s=t.subarray(r);return l.decode({type:e,value:s,skip:i})}return l.decode({type:e,value:a,skip:i})}))}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/packer.js"}],[1601,{"../errors":1597,"../utils":1615,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.address=r.getAddress=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils");r.getAddress=e=>{const t=(0,n.createBytes)(e);return(0,n.assert)(t.length<=20,new s.ParserError(`Invalid address value. Expected address to be 20 bytes long, but received ${t.length} bytes.`)),(0,a.padStart)(t,20)},r.address={isDynamic:!1,isType:e=>"address"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:s}){const o=(0,r.getAddress)(t);if(s)return(0,n.concatBytes)([e,o]);const i=(0,a.padStart)(o);return(0,n.concatBytes)([e,i])},decode:({value:e})=>(0,n.add0x)((0,n.bytesToHex)(e.slice(12,32)))}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js"}],[1602,{"../errors":1597,"../packer":1600,"../utils":1615,"./fixed-bytes":1605,"./tuple":1611,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.array=r.getTupleType=r.getArrayType=r.isArrayType=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../packer"),o=e("../utils"),i=e("./fixed-bytes"),c=e("./tuple"),l=/^(?<type>.*)\[(?<length>\d*?)\]$/u;r.isArrayType=e=>l.test(e);r.getArrayType=e=>{const t=e.match(l);return(0,n.assert)(t?.groups?.type,new s.ParserError(`Invalid array type. Expected an array type, but received "${e}".`)),[t.groups.type,t.groups.length?parseInt(t.groups.length,10):undefined]};r.getTupleType=(e,t)=>`(${new Array(t).fill(e).join(",")})`,r.array={isDynamic(e){const[t,n]=(0,r.getArrayType)(e);return n===undefined||(0,a.isDynamicParser)((0,a.getParser)(t),t)},isType:e=>(0,r.isArrayType)(e),getByteLength(e){(0,n.assert)((0,r.isArrayType)(e),new s.ParserError(`Expected an array type, but received "${e}".`));const[t,o]=(0,r.getArrayType)(e);return(0,a.isDynamicParser)(this,e)||o===undefined?32:c.tuple.getByteLength((0,r.getTupleType)(t,o))},encode({type:e,buffer:t,value:l,packed:u,tight:d}){const[f,m]=(0,r.getArrayType)(e);if((0,n.assert)(!u||!(0,r.isArrayType)(f),new s.ParserError("Cannot pack nested arrays.")),u&&(0,a.isDynamicParser)((0,a.getParser)(f),f))return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:t,packed:u,arrayPacked:!0,tight:d});if(m)return(0,n.assert)(m===l.length,new s.ParserError(`Array length does not match type length. Expected a length of ${m}, but received ${l.length}.`)),c.tuple.encode({type:(0,r.getTupleType)(f,m),buffer:t,value:l,packed:i.fixedBytes.isType(f)&&d,tight:d});if(u)return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:t,packed:i.fixedBytes.isType(f)&&d,arrayPacked:!0,tight:d});const h=(0,o.padStart)((0,n.numberToBytes)(l.length));return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:(0,n.concatBytes)([t,h]),packed:u,tight:d})},decode({type:e,value:t,...o}){const[i,l]=(0,r.getArrayType)(e);if(l){const e=c.tuple.decode({type:(0,r.getTupleType)(i,l),value:t,...o});return(0,n.assert)(e.length===l,new s.ParserError(`Array length does not match type length. Expected a length of ${l}, but received ${e.length}.`)),e}const u=(0,n.bytesToNumber)(t.subarray(0,32));return(0,a.unpack)(new Array(u).fill(i),t.subarray(32))}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js"}],[1603,{"../errors":1597,"./number":1608,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.bool=r.getBooleanValue=void 0;const n=e("@metamask/superstruct"),s=e("@metamask/utils"),a=e("../errors"),o=e("./number"),i=(0,n.coerce)((0,n.boolean)(),(0,n.union)([(0,n.literal)("true"),(0,n.literal)("false")]),(e=>"true"===e));r.getBooleanValue=e=>{try{return(0,n.create)(e,i)?BigInt(1):BigInt(0)}catch{throw new a.ParserError(`Invalid boolean value. Expected a boolean literal, or the string "true" or "false", but received "${e}".`)}},r.bool={isDynamic:!1,isType:e=>"bool"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n,tight:a}){const i=(0,r.getBooleanValue)(t);return n?(0,s.concatBytes)([e,(0,s.bigIntToBytes)(i)]):o.number.encode({type:"uint256",buffer:e,value:i,packed:n,tight:a})},decode:e=>o.number.decode({...e,type:"uint256"})===BigInt(1)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js"}],[1604,{"../utils":1615,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=void 0;const n=e("@metamask/utils"),s=e("../utils");r.bytes={isDynamic:!0,isType:e=>"bytes"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r}){const a=(0,n.createBytes)(t);if(r)return(0,n.concatBytes)([e,a]);const o=32*Math.ceil(a.byteLength/32);return(0,n.concatBytes)([e,(0,s.padStart)((0,n.numberToBytes)(a.byteLength)),(0,s.padEnd)(a,o)])},decode({value:e}){const t=e.subarray(0,32),r=(0,n.bytesToNumber)(t);return e.slice(32,32+r)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js"}],[1605,{"../errors":1597,"../utils":1615,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.fixedBytes=r.getByteLength=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils"),o=/^bytes([0-9]{1,2})$/u;r.getByteLength=e=>{const t=e.match(o)?.[1];(0,n.assert)(t,`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`);const r=Number(t);return(0,n.assert)(r>0&&r<=32,new s.ParserError(`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`)),r},r.fixedBytes={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:o,packed:i}){const c=(0,r.getByteLength)(e),l=(0,n.createBytes)(o);return(0,n.assert)(l.length<=c,new s.ParserError(`Expected a value of length ${c}, but received a value of length ${l.length}.`)),i?(0,n.concatBytes)([t,(0,a.padEnd)(l,c)]):(0,n.concatBytes)([t,(0,a.padEnd)(l)])},decode({type:e,value:t}){const n=(0,r.getByteLength)(e);return t.slice(0,n)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js"}],[1606,{"../errors":1597,"./fixed-bytes":1605,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.fn=r.getFunction=void 0;const n=e("@metamask/superstruct"),s=e("@metamask/utils"),a=e("../errors"),o=e("./fixed-bytes"),i=(0,n.coerce)((0,n.object)({address:s.StrictHexStruct,selector:s.StrictHexStruct}),(0,n.union)([s.StrictHexStruct,(0,n.instance)(Uint8Array)]),(e=>{const t=(0,s.createBytes)(e);return(0,s.assert)(24===t.length,new a.ParserError(`Invalid Solidity function. Expected function to be 24 bytes long, but received ${t.length} bytes.`)),{address:(0,s.bytesToHex)(t.subarray(0,20)),selector:(0,s.bytesToHex)(t.subarray(20,24))}}));r.getFunction=e=>{const t=(0,n.create)(e,i);return(0,s.concatBytes)([(0,s.hexToBytes)(t.address),(0,s.hexToBytes)(t.selector)])},r.fn={isDynamic:!1,isType:e=>"function"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n,tight:s}){const a=(0,r.getFunction)(t);return o.fixedBytes.encode({type:"bytes24",buffer:e,value:a,packed:n,tight:s})},decode:({value:e})=>({address:(0,s.bytesToHex)(e.slice(0,20)),selector:(0,s.bytesToHex)(e.slice(20,24))})}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js"}],[1607,{"./address":1601,"./array":1602,"./bool":1603,"./bytes":1604,"./fixed-bytes":1605,"./function":1606,"./number":1608,"./parser":1609,"./string":1610,"./tuple":1611},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./address"),r),s(e("./array"),r),s(e("./bool"),r),s(e("./bytes"),r),s(e("./fixed-bytes"),r),s(e("./function"),r),s(e("./number"),r),s(e("./parser"),r),s(e("./string"),r),s(e("./tuple"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js"}],[1608,{"../errors":1597,"../utils":1615,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.number=r.getBigInt=r.assertNumberLength=r.getLength=r.isSigned=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils"),o=/^u?int(?<length>[0-9]*)?$/u;r.isSigned=e=>!e.startsWith("u");r.getLength=e=>{if("int"===e||"uint"===e)return 256;const t=e.match(o);(0,n.assert)(t?.groups?.length,new s.ParserError(`Invalid number type. Expected a number type, but received "${e}".`));const r=parseInt(t.groups.length,10);return(0,n.assert)(r>=8&&r<=256,new s.ParserError(`Invalid number length. Expected a number between 8 and 256, but received "${e}".`)),(0,n.assert)(r%8==0,new s.ParserError(`Invalid number length. Expected a multiple of 8, but received "${e}".`)),r};r.assertNumberLength=(e,t)=>{const a=(0,r.getLength)(t),o=BigInt(2)**BigInt(a-((0,r.isSigned)(t)?1:0))-BigInt(1);(0,r.isSigned)(t)?(0,n.assert)(e>=-(o+BigInt(1))&&e<=o,new s.ParserError(`Number "${e}" is out of range for type "${t}".`)):(0,n.assert)(e<=o,new s.ParserError(`Number "${e}" is out of range for type "${t}".`))};r.getBigInt=e=>{try{return(0,n.createBigInt)(e)}catch{throw new s.ParserError(`Invalid number. Expected a valid number value, but received "${e}".`)}},r.number={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:s,packed:o}){const i=(0,r.getBigInt)(s);if((0,r.assertNumberLength)(i,e),(0,r.isSigned)(e)){if(o){const s=(0,r.getLength)(e)/8;return(0,n.concatBytes)([t,(0,n.signedBigIntToBytes)(i,s)])}return(0,n.concatBytes)([t,(0,a.padStart)((0,n.signedBigIntToBytes)(i,32))])}if(o){const s=(0,r.getLength)(e)/8;return(0,n.concatBytes)([t,(0,a.padStart)((0,n.bigIntToBytes)(i),s)])}return(0,n.concatBytes)([t,(0,a.padStart)((0,n.bigIntToBytes)(i))])},decode({type:e,value:t}){const s=t.subarray(0,32);if((0,r.isSigned)(e)){const t=(0,n.bytesToSignedBigInt)(s);return(0,r.assertNumberLength)(t,e),t}const a=(0,n.bytesToBigInt)(s);return(0,r.assertNumberLength)(a,e),a}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js"}],[1609,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js"}],[1610,{"./bytes":1604,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.string=void 0;const n=e("@metamask/utils"),s=e("./bytes");r.string={isDynamic:!0,isType:e=>"string"===e,getByteLength:()=>32,encode:({buffer:e,value:t,packed:r,tight:a})=>s.bytes.encode({type:"bytes",buffer:e,value:(0,n.stringToBytes)(t),packed:r,tight:a}),decode:e=>(0,n.bytesToString)(s.bytes.decode(e))}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js"}],[1611,{"../errors":1597,"../packer":1600,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.tuple=r.getTupleElements=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../packer"),o=/^\((.+)\)$/u;r.getTupleElements=e=>{(0,n.assert)(e.startsWith("(")&&e.endsWith(")"),new s.ParserError(`Invalid tuple type. Expected tuple type, but received "${e}".`));const t=[];let r="",a=0;for(let n=1;n<e.length-1;n++){const s=e[n];","===s&&0===a?(t.push(r.trim()),r=""):(r+=s,"("===s?a+=1:")"===s&&(a-=1))}return r.trim()&&t.push(r.trim()),t},r.tuple={isDynamic:e=>(0,r.getTupleElements)(e).some((e=>{const t=(0,a.getParser)(e);return(0,a.isDynamicParser)(t,e)})),isType:e=>(e=>o.test(e))(e),getByteLength(e){if((0,a.isDynamicParser)(this,e))return 32;return(0,r.getTupleElements)(e).reduce(((e,t)=>e+(0,a.getParser)(t).getByteLength(t)),0)},encode({type:e,buffer:t,value:n,packed:s,tight:o}){const i=(0,r.getTupleElements)(e);return(0,a.pack)({types:i,values:n,byteArray:t,packed:s,tight:o})},decode({type:e,value:t,skip:n}){const s=(0,r.getTupleElements)(e);return n(this.getByteLength(e)-32),(0,a.unpack)(s,t)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"}],[1612,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js"}],[1613,{"./abi":1612},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./abi"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/index.js"}],[1614,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.padEnd=r.padStart=r.set=void 0;const n=e("@metamask/utils");r.set=(e,t,r)=>(0,n.concatBytes)([e.subarray(0,r),t,e.subarray(r+t.length)]);r.padStart=(e,t=32)=>{const r=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,n.concatBytes)([r,e])};r.padEnd=(e,t=32)=>{const r=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,n.concatBytes)([e,r])}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js"}],[1615,{"./buffer":1614},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./buffer"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js"}],[1616,{"./utils":1621,"@scure/base":1637,buffer:4108,tweetnacl:5708},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return s(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.getEncryptionPublicKey=r.decryptSafely=r.decrypt=r.encryptSafely=r.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),c=e("./utils");function l({publicKey:e,data:t,version:r}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(r))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===r){if("string"!=typeof t)throw new Error("Message data must be given as a string");const r=i.box.keyPair();let n;try{n=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const s=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),c=i.box(s,a,n,r.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(r.publicKey),ciphertext:o.base64.encode(c)}}throw new Error("Encryption type/version not supported")}function u({encryptedData:e,privateKey:r}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(r))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const n=t.from(r,"hex"),s=i.box.keyPair.fromSecretKey(n).secretKey,a=o.base64.decode(e.nonce),c=o.base64.decode(e.ciphertext),l=o.base64.decode(e.ephemPublicKey),u=i.box.open(c,a,l,s);try{if(!u)throw new Error;const e=o.utf8.encode(u);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}r.encrypt=l,r.encryptSafely=function({publicKey:e,data:r,version:n}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(r))throw new Error("Missing data parameter");if((0,c.isNullish)(n))throw new Error("Missing version parameter");if("object"==typeof r&&r&&"toJSON"in r)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const s={data:r,padding:""},a=t.byteLength(JSON.stringify(s),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),s.padding="0".repeat(o),l({publicKey:e,data:JSON.stringify(s),version:n})},r.decrypt=u,r.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(u({encryptedData:e,privateKey:t})).data},r.getEncryptionPublicKey=function(e){const r=t.from(e,"hex"),n=i.box.keyPair.fromSecretKey(r).publicKey;return o.base64.encode(n)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js"}],[1617,{"./encryption":1616,"./personal-sign":1618,"./sign-eip7702-authorization":1619,"./sign-typed-data":1620,"./utils":1621},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.concatSig=void 0,s(e("./personal-sign"),r),s(e("./sign-typed-data"),r),s(e("./encryption"),r),s(e("./sign-eip7702-authorization"),r);var a=e("./utils");Object.defineProperty(r,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(r,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/index.js"}],[1618,{"./utils":1621,"@ethereumjs/util":1629},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.extractPublicKey=r.recoverPersonalSignature=r.personalSign=void 0;const n=e("@ethereumjs/util"),s=e("./utils");function a(e,t){const r=(0,n.hashPersonalMessage)((0,s.legacyToBuffer)(e));return(0,s.recoverPublicKey)(r,t)}r.personalSign=function({privateKey:e,data:t}){if((0,s.isNullish)(t))throw new Error("Missing data parameter");if((0,s.isNullish)(e))throw new Error("Missing privateKey parameter");const r=(0,s.legacyToBuffer)(t),a=(0,n.hashPersonalMessage)(r),o=(0,n.ecsign)(a,e);return(0,s.concatSig)((0,n.toBuffer)(o.v),o.r,o.s)},r.recoverPersonalSignature=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");const r=a(e,t),o=(0,n.publicToAddress)(r);return(0,n.bufferToHex)(o)},r.extractPublicKey=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],[1619,{"./utils":1621,"@ethereumjs/rlp":497,"@ethereumjs/util":1629,"@metamask/utils":2976,buffer:4108,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.hashEIP7702Authorization=r.recoverEIP7702Authorization=r.signEIP7702Authorization=void 0;const n=e("@ethereumjs/rlp"),s=e("@ethereumjs/util"),a=e("@metamask/utils"),o=e("ethereum-cryptography/keccak"),i=e("./utils");function c(e){l(e);const r=(0,n.encode)(e),s=t.concat([t.from("05","hex"),r]);return t.from((0,o.keccak256)(s))}function l(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,r,n]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(r))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(n))throw new Error("Missing nonce parameter")}r.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(l(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const r=c(t),{r:n,s:a,v:o}=(0,s.ecsign)(r,e),u=(0,s.toBuffer)(o);return(0,i.concatSig)(u,n,a)},r.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(l(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const r=c(t),n=(0,i.recoverPublicKey)(r,e),o=(0,s.publicToAddress)(n);return(0,a.bytesToHex)(o)},r.hashEIP7702Authorization=c}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],[162,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isSecurityAlertsAPIEnabled=function(){const e="true";return"true"===e.toString()},r.validateWithSecurityAlertsAPI=async function(e,t){return async function(e,t){const r=function(e){const t="https://security-alerts.api.cx.metamask.io";if(!t)throw new Error("Security alerts API URL is not set");return`${t}/${e}`}(e),n=await fetch(r,t);if(!n.ok)throw new Error(`Security alerts API request failed with status: ${n.status}`);return await n.json()}(`${n}/${e}`,{method:"POST",body:JSON.stringify(t),headers:{"Content-Type":"application/json"}})};const n="validate"}}},{package:"$root$",file:"app/scripts/lib/ppom/security-alerts-api.ts"}],[1620,{"./utils":1621,"@ethereumjs/util":1629,"@metamask/abi-utils":1598,"@metamask/abi-utils/dist/parsers":1607,"@metamask/abi-utils/dist/utils":1615,"@metamask/utils":2976,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.recoverTypedSignature=r.signTypedData=r.typedSignatureHash=r.TypedDataUtils=r.TYPED_MESSAGE_SCHEMA=r.SignTypedDataVersion=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),c=e("ethereum-cryptography/keccak"),l=e("./utils");var u;function d(e,t){if(!Object.keys(u).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function f(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const r=BigInt(t),n=(0,a.getLength)(e),s=BigInt(2)**BigInt(n)-BigInt(1);return(0,i.assert)(r>=-s&&r<=s,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),r}function m(e){let t=BigInt(0);for(let r=0;r<e.length;r++){const n=BigInt(e.charCodeAt(r)-48);t*=BigInt(10),t+=n>=49?n-BigInt(49)+BigInt(10):n>=17?n-BigInt(17)+BigInt(10):n}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,r,a,l){if(d(l,[u.V3,u.V4]),e[r]!==undefined)return["bytes32",l===u.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,n.arrToBufArr)((0,c.keccak256)(p(r,a,e,l)))];if("function"===r)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${r}`);if("address"===r){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",m(a).subarray(0,20)]}if("bool"===r)return["bool",Boolean(a)];if("bytes"===r)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.startsWith("bytes")&&"bytes"!==r&&!r.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(r.startsWith("int")&&!r.includes("[")){const e=f(r,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===r)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.endsWith("]")){if(l===u.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=r.slice(0,r.lastIndexOf("[")),i=a.map((r=>h(e,t,o,r,l)));return["bytes32",(0,n.arrToBufArr)((0,c.keccak256)((0,s.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[r,a]}function p(e,t,r,a){d(a,[u.V3,u.V4]);const o=["bytes32"],i=[E(e,r)];for(const n of r[e]){if(a===u.V3&&t[n.name]===undefined)continue;const[e,s]=h(r,n.name,n.type,t[n.name],a);o.push(e),i.push(s)}return(0,n.arrToBufArr)((0,s.encode)(o,i))}function g(e,t){let r="";const n=b(e,t);n.delete(e);const s=[e,...Array.from(n).sort()];for(const e of s){if(!t[e])throw new Error(`No type definition specified: ${e}`);r+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return r}function b(e,t,r=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const n=e.match(/^\w*/u);if([e]=n,r.has(e)||t[e]===undefined)return r;r.add(e);for(const n of t[e])b(n.type,t,r);return r}function y(e,t,r,s){d(s,[u.V3,u.V4]);const a=p(e,t,r,s),o=(0,c.keccak256)(a);return(0,n.arrToBufArr)(o)}function E(e,t){const r=(0,i.stringToBytes)(g(e,t));return(0,n.arrToBufArr)((0,c.keccak256)(r))}function w(e){const t={};for(const n in r.TYPED_MESSAGE_SCHEMA.properties)e[n]&&(t[n]=e[n]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function k(e,t){d(t,[u.V3,u.V4]);const r=w(e),{domain:n}=r;return y("EIP712Domain",n,{EIP712Domain:r.types.EIP712Domain},t)}function v(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[r]=(0,a.getArrayType)(e);return t.map((e=>v(r,e)))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const r=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,r);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,r);if(t instanceof Uint8Array)return t.subarray(0,r)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const r=(0,a.getLength)(e);return BigInt.asIntN(r,BigInt(t))}return t}function x(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const r=f(e,t);if(r>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(r),32);const n=(0,a.getLength)(e),s=BigInt.asIntN(n,r);return(0,i.signedBigIntToBytes)(s,32)}return t}))}function A(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const r=e.map((({name:e,type:t,value:r})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(n=r,n.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var n;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[n,s]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=s?s:""}]`,value:x(n,r)}}return{name:e,type:t,value:v(t,r)}})),u=r.map((e=>"bytes"!==e.type?e.value:(0,l.legacyToBuffer)(e.value))),d=r.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),f=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,n.arrToBufArr)((0,c.keccak256)((0,s.encodePacked)(["bytes32","bytes32"],[(0,c.keccak256)((0,s.encodePacked)(["string[]"],[f],!0)),(0,c.keccak256)((0,s.encodePacked)(d,u,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(u=r.SignTypedDataVersion||(r.SignTypedDataVersion={})),r.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},r.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:b,hashStruct:y,hashType:E,sanitizeData:w,eip712Hash:function(e,t){d(t,[u.V3,u.V4]);const r=w(e),s=[(0,i.hexToBytes)("1901")];return s.push(k(e,t)),"EIP712Domain"!==r.primaryType&&s.push(y(r.primaryType,r.message,r.types,t)),(0,n.arrToBufArr)((0,c.keccak256)((0,i.concatBytes)(s)))},eip712DomainHash:k},r.typedSignatureHash=function(e){const t=A(e);return(0,i.bytesToHex)(t)},r.signTypedData=function({privateKey:e,data:t,version:s}){if(d(s),(0,l.isNullish)(t))throw new Error("Missing data parameter");if((0,l.isNullish)(e))throw new Error("Missing private key parameter");const a=s===u.V1?A(t):r.TypedDataUtils.eip712Hash(t,s),o=(0,n.ecsign)(a,e);return(0,l.concatSig)((0,n.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},r.recoverTypedSignature=function({data:e,signature:t,version:s}){if(d(s),(0,l.isNullish)(e))throw new Error("Missing data parameter");if((0,l.isNullish)(t))throw new Error("Missing signature parameter");const a=s===u.V1?A(e):r.TypedDataUtils.eip712Hash(e,s),o=(0,l.recoverPublicKey)(a,t),c=(0,n.publicToAddress)(o);return(0,i.bytesToHex)(c)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],[1621,{"@ethereumjs/util":1629,"@metamask/utils":2976,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.recoverPublicKey=r.concatSig=r.legacyToBuffer=r.isNullish=r.padWithZeroes=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}r.padWithZeroes=a,r.isNullish=o,r.legacyToBuffer=function(e){return"string"!=typeof e||(0,n.isHexString)(e)?(0,n.toBuffer)(e):t.from(e)},r.concatSig=function(e,t,r){const o=(0,n.fromSigned)(t),i=(0,n.fromSigned)(r),c=(0,n.bufferToInt)(e),l=a((0,n.toUnsigned)(o).toString("hex"),64),u=a((0,n.toUnsigned)(i).toString("hex"),64),d=(0,s.remove0x)((0,s.numberToHex)(c));return(0,s.add0x)(l.concat(u,d))},r.recoverPublicKey=function(e,t){const r=(0,n.fromRpcSig)(t);return(0,n.ecrecover)(e,r.v,r.r,r.s)},r.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,s.numberToBytes)(e);e=(0,s.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,s.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js"}],[1622,{"./bytes":1625,"./constants":1626,"./helpers":1628,"./internal":1630,"@ethereumjs/rlp":497,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358,"ethereum-cryptography/utils":4360},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.accountBodyToRLP=r.accountBodyToSlim=r.accountBodyFromSlim=r.isZeroAddress=r.zeroAddress=r.importPublic=r.privateToAddress=r.privateToPublic=r.publicToAddress=r.pubToAddress=r.isValidPublic=r.isValidPrivate=r.generateAddress2=r.generateAddress=r.isValidChecksumAddress=r.toChecksumAddress=r.isValidAddress=r.Account=void 0;const n=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),l=e("./helpers"),u=e("./internal"),d=BigInt(0);class f{constructor(e=d,t=d,r=c.KECCAK256_RLP,n=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=r,this.codeHash=n,this._validate()}static fromAccountData(e){const{nonce:t,balance:r,storageRoot:n,codeHash:s}=e;return new f(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,r!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(r)):undefined,n!==undefined?(0,i.toBuffer)(n):undefined,s!==undefined?(0,i.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(n.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,r,n,s]=e;return new f((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(r),n,s)}_validate(){if(this.nonce<d)throw new Error("nonce must be greater than zero");if(this.balance<d)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(n.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===d&&this.nonce===d&&this.codeHash.equals(c.KECCAK256_NULL)}}r.Account=f;r.isValidAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};r.toChecksumAddress=function(e,r){(0,l.assertIsHexString)(e);const n=(0,u.stripHexPrefix)(e).toLowerCase();let a="";if(r!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(r)).toString()+"0x"}const c=t.from(a+n,"utf8"),d=(0,o.bytesToHex)((0,s.keccak256)(c));let f="0x";for(let e=0;e<n.length;e++)parseInt(d[e],16)>=8?f+=n[e].toUpperCase():f+=n[e];return f};r.isValidChecksumAddress=function(e,t){return(0,r.isValidAddress)(e)&&(0,r.toChecksumAddress)(e,t)===e};r.generateAddress=function(e,r){return(0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,i.bufferToBigInt)(r)===BigInt(0)?t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,r])))).slice(-20)};r.generateAddress2=function(e,r,n){if((0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,l.assertIsBuffer)(n),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==r.length)throw new Error("Expected salt to be of length 32");const a=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,r,(0,s.keccak256)(n)]));return(0,i.toBuffer)(a).slice(-20)};r.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};r.isValidPublic=function(e,r=!1){if((0,l.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!r)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};r.pubToAddress=function(e,r=!1){if((0,l.assertIsBuffer)(e),r&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},r.publicToAddress=r.pubToAddress;r.privateToPublic=function(e){return(0,l.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};r.privateToAddress=function(e){return(0,r.publicToAddress)((0,r.privateToPublic)(e))};r.importPublic=function(e){return(0,l.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};r.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function m(e){const[t,r,n,s]=e;return[t,r,0===(0,i.arrToBufArr)(n).length?c.KECCAK256_RLP:n,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}r.isZeroAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return(0,r.zeroAddress)()===e},r.accountBodyFromSlim=m;const h=new Uint8Array(0);r.accountBodyToSlim=function(e){const[t,r,n,s]=e;return[t,r,(0,i.arrToBufArr)(n).equals(c.KECCAK256_RLP)?h:n,(0,i.arrToBufArr)(s).equals(c.KECCAK256_NULL)?h:s]},r.accountBodyToRLP=function(e,t=!0){const r=t?m(e):e;return(0,i.arrToBufArr)(n.RLP.encode(r))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],[1623,{"./account":1622,"./bytes":1625,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Address=void 0;const n=e("./account"),s=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,s.zeros)(20))}static fromString(e){if(!(0,n.isValidAddress)(e))throw new Error("Invalid address");return new a((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const r=(0,n.pubToAddress)(e);return new a(r)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const r=(0,n.privateToAddress)(e);return new a(r)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,n.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,r,s){if(!t.isBuffer(r))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new a((0,n.generateAddress2)(e.buf,r,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),r=BigInt("0xffff");return e>=t&&e<=r}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}r.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],[1624,{events:4440},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AsyncEventEmitter=void 0;const n=e("events");class s extends n.EventEmitter{emit(e,...t){let[r,n]=t;const s=this;let a=s._events[e]??[];return n===undefined&&"function"==typeof r&&(n=r,r=undefined),"newListener"!==e&&"removeListener"!==e||(r={event:r,fn:n},n=undefined),a=Array.isArray(a)?a:[a],async function(e,t,r){let n;for await(const s of t)try{s.length<2?s.call(e,r):await new Promise(((t,n)=>{s.call(e,r,(e=>{e?n(e):t()}))}))}catch(e){n=e}if(n)throw n}(s,a.slice(),r).then(n).catch(n),s.listenerCount(e)>0}once(e,t){const r=this;let n;if("function"!=typeof t)throw new TypeError("listener must be a function");return n=t.length>=2?function(s,a){r.removeListener(e,n),t(s,a)}:function(s){r.removeListener(e,n),t(s,n)},r.on(e,n),r}first(e,t){let r=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(r)||(this._events[e]=r=[r]),r.unshift(t),this}before(e,t,r){return this.beforeOrAfter(e,t,r)}after(e,t,r){return this.beforeOrAfter(e,t,r,"after")}beforeOrAfter(e,t,r,n){let s,a,o=this._events[e]??[];const i="after"===n?1:0;if("function"!=typeof r)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,s=o.length;s--;)if(o[s]===t){a=s+i;break}return o.splice(a,0,r),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}r.AsyncEventEmitter=s}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],[1625,{"./helpers":1628,"./internal":1630,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.intToUnpaddedBuffer=r.bigIntToUnpaddedBuffer=r.bigIntToHex=r.bufArrToArr=r.arrToBufArr=r.validateNoLeadingZeroes=r.baToJSON=r.toUtf8=r.short=r.addHexPrefix=r.toUnsigned=r.fromSigned=r.bufferToInt=r.bigIntToBuffer=r.bufferToBigInt=r.bufferToHex=r.toBuffer=r.unpadHexString=r.unpadArray=r.unpadBuffer=r.setLengthRight=r.setLengthLeft=r.zeros=r.intToBuffer=r.intToHex=void 0;const n=e("./helpers"),s=e("./internal");r.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};r.intToBuffer=function(e){const n=(0,r.intToHex)(e);return t.from((0,s.padToEven)(n.slice(2)),"hex")};r.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,n){const s=(0,r.zeros)(t);return n?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};r.setLengthLeft=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!1)};r.setLengthRight=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};r.unpadBuffer=function(e){return(0,n.assertIsBuffer)(e),o(e)};r.unpadArray=function(e){return(0,n.assertIsArray)(e),o(e)};r.unpadHexString=function(e){return(0,n.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+o(e)};r.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,r.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let r=e.toString(16);return r.length%2&&(r="0"+r),t.from(r,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,r.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,r.toBuffer)("0x"+e.toString(16))}r.bufferToHex=function(e){return"0x"+(e=(0,r.toBuffer)(e)).toString("hex")},r.bufferToBigInt=i,r.bigIntToBuffer=c;r.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};r.fromSigned=function(e){return BigInt.asIntN(256,i(e))};r.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};r.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},r.short=function(e,r=50){const n=t.isBuffer(e)?e.toString("hex"):e;return n.length<=r?n:n.slice(0,r)+"…"};r.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};r.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let n=0;n<e.length;n++)t.push((0,r.baToJSON)(e[n]));return t}};r.validateNoLeadingZeroes=function(e){for(const[t,r]of Object.entries(e))if(r!==undefined&&r.length>0&&0===r[0])throw new Error(`${t} cannot have leading zeroes, received: ${r.toString("hex")}`)},r.arrToBufArr=function e(r){return Array.isArray(r)?r.map((t=>e(t))):t.from(r)},r.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};r.bigIntToHex=e=>"0x"+e.toString(16),r.bigIntToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)(c(e))},r.intToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)((0,r.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],[1626,{buffer:4108,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAX_WITHDRAWALS_PER_PAYLOAD=r.RLP_EMPTY_STRING=r.KECCAK256_RLP=r.KECCAK256_RLP_S=r.KECCAK256_RLP_ARRAY=r.KECCAK256_RLP_ARRAY_S=r.KECCAK256_NULL=r.KECCAK256_NULL_S=r.TWO_POW256=r.SECP256K1_ORDER_DIV_2=r.SECP256K1_ORDER=r.MAX_INTEGER_BIGINT=r.MAX_INTEGER=r.MAX_UINT64=void 0;const n=e("buffer"),s=e("ethereum-cryptography/secp256k1");r.MAX_UINT64=BigInt("0xffffffffffffffff"),r.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),r.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),r.SECP256K1_ORDER=s.secp256k1.CURVE.n,r.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),r.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),r.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",r.KECCAK256_NULL=n.Buffer.from(r.KECCAK256_NULL_S,"hex"),r.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",r.KECCAK256_RLP_ARRAY=n.Buffer.from(r.KECCAK256_RLP_ARRAY_S,"hex"),r.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",r.KECCAK256_RLP=n.Buffer.from(r.KECCAK256_RLP_S,"hex"),r.RLP_EMPTY_STRING=n.Buffer.from([128]),r.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],[1627,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.compactBytesToNibbles=r.bytesToNibbles=r.nibblesToCompactBytes=r.nibblesToBytes=r.hasTerminator=void 0;r.hasTerminator=e=>e.length>0&&16===e[e.length-1];r.nibblesToBytes=(e,t)=>{for(let r=0,n=0;n<e.length;r+=1,n+=2)t[r]=e[n]<<4|e[n+1]};r.nibblesToCompactBytes=e=>{let t=0;(0,r.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const n=new Uint8Array(e.length/2+1);return n[0]=t<<5,1&~e.length||(n[0]|=16,n[0]|=e[0],e=e.subarray(1)),(0,r.nibblesToBytes)(e,n.subarray(1)),n};r.bytesToNibbles=e=>{const t=2*e.length+1,r=new Uint8Array(t);for(let t=0;t<e.length;t++){const n=e[t];r[2*t]=n/16,r[2*t+1]=n%16}return r[t-1]=16,r};r.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,r.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const n=2-(1&t[0]);return t.subarray(n)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],[1628,{"../../../../../../../../../is-buffer/index.js":4701,"./internal":1630},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.assertIsString=r.assertIsArray=r.assertIsBuffer=r.assertIsHexString=void 0;const n=e("./internal");r.assertIsHexString=function(e){if(!(0,n.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};r.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};r.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};r.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../../../../is-buffer/index.js")})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],[1629,{"./account":1622,"./address":1623,"./asyncEventEmitter":1624,"./bytes":1625,"./constants":1626,"./encoding":1627,"./internal":1630,"./lock":1631,"./provider":1632,"./signature":1633,"./types":1634,"./units":1635,"./withdrawal":1636},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.toAscii=r.stripHexPrefix=r.padToEven=r.isHexString=r.isHexPrefixed=r.getKeys=r.getBinarySize=r.fromUtf8=r.fromAscii=r.arrayContainsArray=void 0,s(e("./constants"),r),s(e("./units"),r),s(e("./account"),r),s(e("./address"),r),s(e("./withdrawal"),r),s(e("./signature"),r),s(e("./bytes"),r),s(e("./types"),r),s(e("./encoding"),r),s(e("./asyncEventEmitter"),r);var a=e("./internal");Object.defineProperty(r,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(r,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(r,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(r,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(r,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(r,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(r,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(r,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(r,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(r,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),s(e("./lock"),r),s(e("./provider"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],[1630,{buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(r,"__esModule",{value:!0}),r.isHexString=r.getKeys=r.fromAscii=r.fromUtf8=r.toAscii=r.arrayContainsArray=r.getBinarySize=r.padToEven=r.stripHexPrefix=r.isHexPrefixed=void 0,r.isHexPrefixed=t;function n(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}r.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},r.padToEven=n,r.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},r.arrayContainsArray=function(e,t,r){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===r?"some":"every"]((t=>e.indexOf(t)>=0))},r.toAscii=function(e){let t="",r=0;const n=e.length;for("0x"===e.substring(0,2)&&(r=2);r<n;r+=2){const n=parseInt(e.substr(r,2),16);t+=String.fromCharCode(n)}return t},r.fromUtf8=function(t){return`0x${n(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},r.fromAscii=function(e){let t="";for(let r=0;r<e.length;r++){const n=e.charCodeAt(r).toString(16);t+=n.length<2?`0${n}`:n}return`0x${t}`},r.getKeys=function(e,t,r){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const n=[];for(let s=0;s<e.length;s++){let a=e[s][t];if(!0!==r||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";n.push(a)}return n},r.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],[1631,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Lock=void 0;r.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],[1632,{"micro-ftch":4981},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getProvider=r.fetchFromProvider=void 0;const n=e("micro-ftch");r.fetchFromProvider=async(e,t)=>(await(0,n.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;r.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],[1633,{"./bytes":1625,"./constants":1626,"./helpers":1628,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.hashPersonalMessage=r.isValidSignature=r.fromRpcSig=r.toCompactSig=r.toRpcSig=r.ecrecover=r.ecsign=void 0;const n=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function l(e){return e===BigInt(0)||e===BigInt(1)}r.ecsign=function(e,r,n){const a=s.secp256k1.sign(e,r),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:n===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(n)*BigInt(2)}};r.ecrecover=function(e,r,n,o,i){const u=t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(o,32)],64),d=c(r,i);if(!l(d))throw new Error("Invalid signature v value");const f=s.secp256k1.Signature.fromCompact(u).addRecoveryBit(Number(d)).recoverPublicKey(e);return t.from(f.toRawBytes(!1).slice(1))};r.toRpcSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(n,32),(0,a.toBuffer)(e)]))};r.toCompactSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");let o=n;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(n),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)]))};r.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let r,n,s;if(t.length>=65)r=t.slice(0,32),n=t.slice(32,64),s=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");r=t.slice(0,32),n=t.slice(32,64),s=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),n[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:r,s:n}};r.isValidSignature=function(e,t,r,n=!0,s){if(32!==t.length||32!==r.length)return!1;if(!l(c(e,s)))return!1;const i=(0,a.bufferToBigInt)(t),u=(0,a.bufferToBigInt)(r);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||u===BigInt(0)||u>=o.SECP256K1_ORDER)&&!(n&&u>=o.SECP256K1_ORDER_DIV_2)};r.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const r=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,n.keccak256)(t.concat([r,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],[1634,{"./bytes":1625,"./internal":1630},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.toType=r.TypeOutput=void 0;const n=e("./bytes"),s=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=r.TypeOutput||(r.TypeOutput={})),r.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const r=(0,n.toBuffer)(e);switch(t){case a.Buffer:return r;case a.BigInt:return(0,n.bufferToBigInt)(r);case a.Number:{const e=(0,n.bufferToBigInt)(r);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,n.bufferToHex)(r);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],[1635,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.GWEI_TO_WEI=void 0,r.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],[1636,{"./address":1623,"./bytes":1625,"./types":1634,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Withdrawal=void 0;const n=e("./address"),s=e("./bytes"),a=e("./types");class o{constructor(e,t,r,n){this.index=e,this.validatorIndex=t,this.address=r,this.amount=n}static fromWithdrawalData(e){const{index:t,validatorIndex:r,address:s,amount:i}=e,c=(0,a.toType)(t,a.TypeOutput.BigInt),l=(0,a.toType)(r,a.TypeOutput.BigInt),u=new n.Address((0,a.toType)(s,a.TypeOutput.Buffer)),d=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(c,l,u,d)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,r,n,s]=e;return o.fromWithdrawalData({index:t,validatorIndex:r,address:n,amount:s})}static toBufferArray(e){const{index:r,validatorIndex:s,address:o,amount:i}=e,c=(0,a.toType)(r,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(r,a.TypeOutput.Buffer),l=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer);let u;u=o instanceof n.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[c,l,u,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}r.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],[1637,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function s(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,r=(e,t)=>r=>e(t(r));return{encode:e.map((e=>e.encode)).reduceRight(r,t),decode:e.map((e=>e.decode)).reduce(r,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(n(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const r=e.indexOf(t);if(-1===r)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return r}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(n(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;r.length*e%8;)r.push(t);return r},decode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let n=r.length;if(n*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;n>0&&r[n-1]===t;n--)if(!((n-1)*e%8))throw new Error("Invalid padding: string has too much padding");return r.slice(0,n)}}}function l(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function u(e,t,r){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(r<2)throw new Error(`convertRadix: wrong to=${r}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let s=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(n(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,n=!0;for(let a=s;a<o.length;a++){const i=o[a],c=t*e+i;if(!Number.isSafeInteger(c)||t*e/t!==e||c-i!=t*e)throw new Error("convertRadix: carry overflow");e=c%r;const l=Math.floor(c/r);if(o[a]=l,!Number.isSafeInteger(l)||l*r+e!==c)throw new Error("convertRadix: carry overflow");n&&(l?n=!1:s=a)}if(a.push(e),n)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=r.stringToBytes=r.str=r.bytesToString=r.hex=r.utf8=r.bech32m=r.bech32=r.base58check=r.createBase58check=r.base58xmr=r.base58xrp=r.base58flickr=r.base58=r.base64urlnopad=r.base64url=r.base64nopad=r.base64=r.base32crockford=r.base32hexnopad=r.base32hex=r.base32nopad=r.base32=r.base16=r.utils=void 0,r.assertNumber=n;const d=(e,t)=>t?d(t,e%t):e,f=(e,t)=>e+(t-d(e,t));function m(e,t,r,s){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(r<=0||r>32)throw new Error(`convertRadix2: wrong to=${r}`);if(f(t,r)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${r} carryBits=${f(t,r)}`);let a=0,o=0;const i=2**r-1,c=[];for(const s of e){if(n(s),s>=2**t)throw new Error(`convertRadix2: invalid data word=${s} from=${t}`);if(a=a<<t|s,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=r;o-=r)c.push((a>>o-r&i)>>>0);a&=2**o-1}if(a=a<<r-o&i,!s&&o>=t)throw new Error("Excess padding");if(!s&&a)throw new Error(`Non-zero padding: ${a}`);return s&&o>0&&c.push(a>>>0),c}function h(e){return n(e),{encode:t=>{if(!s(t))throw new Error("radix.encode input should be Uint8Array");return u(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(u(t,e,256))}}}function p(e,t=!1){if(n(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(f(8,e)>32||f(e,8)>32)throw new Error("radix2: carry overflow");return{encode:r=>{if(!s(r))throw new Error("radix2.encode input should be Uint8Array");return m(Array.from(r),8,e,!t)},decode:r=>{if(!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(m(r,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function b(e,t){if(n(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(r){if(!s(r))throw new Error("checksum.encode: input should be Uint8Array");const n=t(r).slice(0,e),a=new Uint8Array(r.length+e);return a.set(r),a.set(n,r.length),a},decode(r){if(!s(r))throw new Error("checksum.decode: input should be Uint8Array");const n=r.slice(0,-e),a=t(n).slice(0,e),o=r.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return n}}}r.utils={alphabet:o,chain:a,checksum:b,convertRadix:u,convertRadix2:m,radix:h,radix2:p,join:i,padding:c},r.base16=a(p(4),o("0123456789ABCDEF"),i("")),r.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),i("")),r.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),r.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),i("")),r.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),r.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),l((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),r.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),i("")),r.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),r.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),i("")),r.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const y=e=>a(h(58),o(e),i(""));r.base58=y("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),r.base58flickr=y("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),r.base58xrp=y("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const E=[0,2,3,5,6,7,9,10,11];r.base58xmr={encode(e){let t="";for(let n=0;n<e.length;n+=8){const s=e.subarray(n,n+8);t+=r.base58.encode(s).padStart(E[s.length],"1")}return t},decode(e){let t=[];for(let n=0;n<e.length;n+=11){const s=e.slice(n,n+11),a=E.indexOf(s.length),o=r.base58.decode(s);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};r.createBase58check=e=>a(b(4,(t=>e(e(t)))),r.base58),r.base58check=r.createBase58check;const w=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),k=[996825010,642813549,513874426,1027748829,705979059];function v(e){const t=e>>25;let r=(33554431&e)<<5;for(let e=0;e<k.length;e++)1==(t>>e&1)&&(r^=k[e]);return r}function x(e,t,r=1){const n=e.length;let s=1;for(let t=0;t<n;t++){const r=e.charCodeAt(t);if(r<33||r>126)throw new Error(`Invalid prefix (${e})`);s=v(s)^r>>5}s=v(s);for(let t=0;t<n;t++)s=v(s)^31&e.charCodeAt(t);for(let e of t)s=v(s)^e;for(let e=0;e<6;e++)s=v(s);return s^=r,w.encode(m([s%2**30],30,5,!1))}function A(e){const t="bech32"===e?1:734539939,r=p(5),n=r.decode,s=r.encode,a=g(n);function o(e,r,n=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(r instanceof Uint8Array&&(r=Array.from(r)),!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof r);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const s=e.length+7+r.length;if(!1!==n&&s>n)throw new TypeError(`Length ${s} exceeds limit ${n}`);const a=e.toLowerCase(),o=x(a,r,t);return`${a}1${w.encode(r)}${o}`}function i(e,r=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==r&&e.length>r)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${r})`);const n=e.toLowerCase();if(e!==n&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const s=n.lastIndexOf("1");if(0===s||-1===s)throw new Error('Letter "1" must be present between prefix and data only');const a=n.slice(0,s),o=n.slice(s+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=w.decode(o).slice(0,-6),c=x(a,i,t);if(!o.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,s(t))},decodeToBytes:function(e){const{prefix:t,words:r}=i(e,!1);return{prefix:t,words:r,bytes:n(r)}},decodeUnsafe:g(i),fromWords:n,fromWordsUnsafe:a,toWords:s}}r.bech32=A("bech32"),r.bech32m=A("bech32m"),r.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},r.hex=a(p(4),o("0123456789abcdef"),i(""),l((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const T={utf8:r.utf8,hex:r.hex,base16:r.base16,base32:r.base32,base64:r.base64,base64url:r.base64url,base58:r.base58,base58xmr:r.base58xmr},B="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";r.bytesToString=(e,t)=>{if("string"!=typeof e||!T.hasOwnProperty(e))throw new TypeError(B);if(!s(t))throw new TypeError("bytesToString() expects Uint8Array");return T[e].encode(t)},r.str=r.bytesToString;r.stringToBytes=(e,t)=>{if(!T.hasOwnProperty(e))throw new TypeError(B);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return T[e].decode(t)},r.bytes=r.stringToBytes}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@scure/base/lib/index.js"}],[1647,{"./fetch-config-from-req":1649,"./logging-utils":1651,"@metamask/json-rpc-engine":2022,"@metamask/rpc-errors":2527},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createInfuraMiddlewareWithoutRpcService=r.createInfuraMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("@metamask/rpc-errors"),a=e("./fetch-config-from-req"),o=e("./logging-utils"),i=(0,o.createModuleLogger)(o.projectLogger,"create-infura-middleware"),c=["Gateway timeout","ETIMEDOUT","ECONNRESET","SyntaxError"];function l({network:e="mainnet",maxAttempts:t=5,source:r,projectId:s,headers:a={}}){if(!s||"string"!=typeof s)throw new Error(`Invalid value for 'projectId': "${s}"`);if(!a||"object"!=typeof a)throw new Error(`Invalid value for 'headers': "${a}"`);if(!t)throw new Error(`Invalid value for 'maxAttempts': "${t}" (${typeof t})`);return(0,n.createAsyncMiddleware)((async(n,o)=>{for(let c=1;c<=t;c++)try{i("Attempting request to Infura. network = %o, projectId = %s, headers = %o, req = %o",e,s,a,n),await u(e,s,a,n,o,r);break}catch(e){if(!f(e))throw i("Non-retriable request error encountered. req = %o, res = %o, error = %o",n,o,e),e;if(!(t-c)){i("Retriable request error encountered, but exceeded max attempts. req = %o, res = %o, error = %o",n,o,e);const t=`InfuraProvider - cannot complete request. All retries exhausted.\nOriginal Error:\n${e.toString()}\n\n`;throw new Error(t)}i("Retriable request error encountered. req = %o, res = %o, error = %o",n,o,e),i("Waiting 1 second to try again..."),await m(1e3)}}))}async function u(e,t,r,n,o,i){const{fetchUrl:c,fetchParams:l}=(0,a.fetchConfigFromReq)({network:e,projectId:t,extraHeaders:r,req:n,source:i}),u=await fetch(c,l),f=await u.text();if(!u.ok)switch(u.status){case 405:throw s.rpcErrors.methodNotFound();case 429:throw d("Request is being rate limited.");case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",d(e)}();default:throw d(f)}if("eth_getBlockByNumber"===n.method&&"Not Found"===f)return void(o.result=null);const m=JSON.parse(f);o.result=m.result,o.error=m.error}function d(e){return s.rpcErrors.internal(e)}function f(e){const t=e.toString();return c.some((e=>t.includes(e)))}async function m(e){return new Promise((t=>{setTimeout(t,e)}))}r.createInfuraMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){const{source:r,headers:s={}}=t;return(0,n.createAsyncMiddleware)((async(t,n)=>{const a=r!==undefined&&t.origin!==undefined?Object.assign(Object.assign({},s),{"Infura-Source":`${r}/${t.origin}`}):s,o=await e.request({id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},{headers:a});"error"in o?n.error=o.error:(n.result=o.result,n.error=undefined)}))}(e):l(e)},r.createInfuraMiddlewareWithoutRpcService=l}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js"}],[1648,{"./create-infura-middleware":1647,"@metamask/eth-json-rpc-provider":1714,"@metamask/json-rpc-engine":2022},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createProvider=void 0;const n=e("@metamask/eth-json-rpc-provider"),s=e("@metamask/json-rpc-engine"),a=e("./create-infura-middleware");r.createProvider=function(e){const t=new s.JsonRpcEngine;return t.push((0,a.createInfuraMiddleware)(e)),(0,n.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js"}],[1649,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){return{id:e.id,jsonrpc:e.jsonrpc,method:e.method,params:e.params}}Object.defineProperty(r,"__esModule",{value:!0}),r.fetchConfigFromReq=void 0,r.fetchConfigFromReq=function({network:e,projectId:t,extraHeaders:r={},req:s,source:a}){const o=s.origin||"internal",i=Object.assign({},r,{Accept:"application/json","Content-Type":"application/json"});return a&&(i["Infura-Source"]=`${a}/${o}`),{fetchUrl:`https://${e}.infura.io/v3/${t}`,fetchParams:{method:"POST",headers:i,body:JSON.stringify(n(s))}}}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"}],[1650,{"./create-infura-middleware":1647,"./create-provider":1648,"./fetch-config-from-req":1649},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./create-infura-middleware"),r),s(e("./fetch-config-from-req"),r),s(e("./create-provider"),r)}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/index.js"}],[1651,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("eth-json-rpc-infura")}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js"}],[1652,{"./logging-utils":1659,"./utils/cache":1665,"@metamask/json-rpc-engine":2022},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockCacheMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("./logging-utils"),a=e("./utils/cache"),o=(0,s.createModuleLogger)(s.projectLogger,"block-cache"),i=[undefined,null,"<nil>"];class c{constructor(){this.cache={}}getBlockCache(e){const t=Number.parseInt(e,16);let r=this.cache[t];if(!r){const e={};this.cache[t]=e,r=e}return r}async get(e,t){const r=this.getBlockCache(t),n=(0,a.cacheIdentifierForRequest)(e,!0);return n?r[n]:undefined}async set(e,t,r){if(!this.canCacheResult(e,r))return;const n=(0,a.cacheIdentifierForRequest)(e,!0);if(!n)return;this.getBlockCache(t)[n]=r}canCacheRequest(e){if(!(0,a.canCache)(e.method))return!1;return"pending"!==(0,a.blockTagForRequest)(e)}canCacheResult(e,t){return!i.includes(t)&&!(e.method&&["eth_getTransactionByHash","eth_getTransactionReceipt"].includes(e.method)&&(!t||!t.blockHash||"0x0000000000000000000000000000000000000000000000000000000000000000"===t.blockHash))}clearBefore(e){const t=Number.parseInt(e,16);Object.keys(this.cache).map(Number).filter((e=>e<t)).forEach((e=>delete this.cache[e]))}}r.createBlockCacheMiddleware=function({blockTracker:e}={}){if(!e)throw new Error("createBlockCacheMiddleware - No PollingBlockTracker specified");const t=new c,r={[a.CacheStrategy.Permanent]:t,[a.CacheStrategy.Block]:t,[a.CacheStrategy.Fork]:t,[a.CacheStrategy.Never]:undefined};return(0,n.createAsyncMiddleware)((async(n,s,i)=>{if(n.skipCache)return i();const c=(0,a.cacheTypeForMethod)(n.method),l=r[c];if(!l)return i();if(!l.canCacheRequest(n))return i();const u=(0,a.blockTagForRequest)(n),d=u&&"string"==typeof u?u:"latest";let f;if(o("blockTag = %o, req = %o",d,n),"earliest"===d)f="0x00";else if("latest"===d){o("Fetching latest block number to determine cache key");const r=await e.getLatestBlock();o("Clearing values stored under block numbers before %o",r),t.clearBefore(r),f=r}else f=d;const m=await l.get(n,f);return m===undefined?(o("No cache stored under block number %o, carrying request forward",f),await i(),o("Populating cache with",s),await l.set(n,f,s.result)):(o("Cache hit, reusing cache result stored under block number %o",f),s.result=m),undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.js"}],[1653,{"./utils/cache":1665,"@metamask/json-rpc-engine":2022},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockRefRewriteMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("./utils/cache");r.createBlockRefRewriteMiddleware=function({blockTracker:e}={}){if(!e)throw Error('BlockRefRewriteMiddleware - mandatory "blockTracker" option is missing.');return(0,n.createAsyncMiddleware)((async(t,r,n)=>{const a=(0,s.blockTagParamIndex)(t.method);if(a===undefined)return n();if("latest"!==(Array.isArray(t.params)&&t.params[a]?t.params[a]:"latest"))return n();const o=await e.getLatestBlock();return Array.isArray(t.params)&&(t.params[a]=o),n()}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.js"}],[1654,{"./logging-utils":1659,"./utils/cache":1665,"@metamask/json-rpc-engine":2022,"klona/full":4770},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockRefMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("klona/full"),a=e("./logging-utils"),o=e("./utils/cache"),i=(0,a.createModuleLogger)(a.projectLogger,"block-ref");r.createBlockRefMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('BlockRefMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('BlockRefMiddleware - mandatory "blockTracker" option is missing.');return(0,n.createAsyncMiddleware)((async(r,n,a)=>{var c;const l=(0,o.blockTagParamIndex)(r.method);if(l===undefined)return a();if("latest"!==(Array.isArray(r.params)&&null!==(c=r.params[l])&&void 0!==c?c:"latest"))return i('blockRef is not "latest", carrying request forward'),a();const u=await t.getLatestBlock();i(`blockRef is "latest", setting param ${l} to latest block ${u}`);const d=(0,s.klona)(r);return Array.isArray(d.params)&&(d.params[l]=u),i("Performing another request %o",d),n.result=await e.request(d),undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.js"}],[1655,{"./logging-utils":1659,"@metamask/json-rpc-engine":2022},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createBlockTrackerInspectorMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("./logging-utils"),a=(0,s.createModuleLogger)(s.projectLogger,"block-tracker-inspector"),o=["eth_getTransactionByHash","eth_getTransactionReceipt"];function i(e){const{result:t}=e;return t&&"object"==typeof t&&(r=t,n="blockNumber",Object.hasOwnProperty.call(r,n))&&"string"==typeof t.blockNumber?t.blockNumber:undefined;var r,n}r.createBlockTrackerInspectorMiddleware=function({blockTracker:e}){return(0,n.createAsyncMiddleware)((async(t,r,n)=>{if(!o.includes(t.method))return n();await n();const s=i(r);if(!s)return undefined;a("res.result.blockNumber exists, proceeding. res = %o",r);return Number.parseInt(s,16)>Number.parseInt(e.getCurrentBlock(),16)&&(a("blockNumber from response is greater than current block number, refreshing current block number"),await e.checkForLatestBlock()),undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.js"}],[1656,{"./utils/timeout":1669,"@metamask/json-rpc-engine":2022,"@metamask/rpc-errors":2527},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createFetchConfigFromReq=r.createFetchMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("@metamask/rpc-errors"),a=e("./utils/timeout"),o=["Gateway timeout","ETIMEDOUT","failed to parse response body","Failed to fetch"];function i(e){switch(e.status){case 405:throw s.rpcErrors.methodNotFound();case 418:throw s.rpcErrors.internal({message:"Request is being rate limited."});case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",s.rpcErrors.internal({message:e})}()}}function c(e,t){if(200!==e.status)throw s.rpcErrors.internal({message:`Non-200 status code: '${e.status}'`,data:t});if(t.error)throw s.rpcErrors.internal({data:t.error});return t.result}function l({btoa:e,req:t,rpcUrl:r,originHttpHeaderKey:n}){const s=new URL(r),a=function(e){let t="";t+=e.protocol,t+=`//${e.hostname}`,e.port&&(t+=`:${e.port}`);return t+=`${e.pathname}`,t+=`${e.search}`,t}(s),o={id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},i=t.origin,c={method:"POST",headers:{Accept:"application/json","Content-Type":"application/json"},body:JSON.stringify(o)};if(s.username&&s.password){const t=e(`${s.username}:${s.password}`);c.headers.Authorization=`Basic ${t}`}return n&&i&&(c.headers[n]=i),{fetchUrl:a,fetchParams:c}}r.createFetchMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){return(0,n.createAsyncMiddleware)((async(r,n)=>{const a="originHttpHeaderKey"in t&&t.originHttpHeaderKey!==undefined&&r.origin!==undefined?{[t.originHttpHeaderKey]:r.origin}:{},o=await e.request({id:r.id,jsonrpc:r.jsonrpc,method:r.method,params:r.params},{headers:a});if("error"in o)throw s.rpcErrors.internal({data:o.error});n.result=o.result}))}(e):function({btoa:e,fetch:t,rpcUrl:r,originHttpHeaderKey:s}){return(0,n.createAsyncMiddleware)((async(n,u,d)=>{const{fetchUrl:f,fetchParams:m}=l({btoa:e,req:n,rpcUrl:r,originHttpHeaderKey:s}),h=5,p=1e3;for(let e=0;e<h;e++){try{const e=await t(f,m);i(e);const r=await e.text();let n;try{n=JSON.parse(r)}catch(e){throw new Error(`FetchMiddleware - failed to parse response body: "${r}"`)}const s=c(e,n);return void(u.result=s)}catch(e){const t=e.toString();if(!o.some((e=>t.includes(e))))throw e}await(0,a.timeout)(p)}}))}(e)},r.createFetchConfigFromReq=l}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.js"}],[1657,{"./block-cache":1652,"./block-ref":1654,"./block-ref-rewrite":1653,"./block-tracker-inspector":1655,"./fetch":1656,"./inflight-cache":1658,"./methods/wallet-get-calls-status":1660,"./providerAsMiddleware":1663,"./retryOnEmpty":1664,"./wallet":1671},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.GetCallsStatusCode=void 0,s(e("./block-cache"),r),s(e("./block-ref-rewrite"),r),s(e("./block-ref"),r),s(e("./block-tracker-inspector"),r),s(e("./fetch"),r),s(e("./inflight-cache"),r);var a=e("./methods/wallet-get-calls-status");Object.defineProperty(r,"GetCallsStatusCode",{enumerable:!0,get:function(){return a.GetCallsStatusCode}}),s(e("./providerAsMiddleware"),r),s(e("./retryOnEmpty"),r),s(e("./wallet"),r)}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/index.js"}],[1658,{"./logging-utils":1659,"./utils/cache":1665,"@metamask/json-rpc-engine":2022,"klona/full":4770},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createInflightCacheMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("klona/full"),a=e("./logging-utils"),o=e("./utils/cache"),i=(0,a.createModuleLogger)(a.projectLogger,"inflight-cache");r.createInflightCacheMiddleware=function(){const e={};return(0,n.createAsyncMiddleware)((async(t,r,n)=>{if(t.skipCache)return n();const a=(0,o.cacheIdentifierForRequest)(t);if(!a)return i("Request is not cacheable, proceeding. req = %o",t),n();let c=e[a];return c?(i("Running %i handler(s) for request %o",c.length,t),await async function(e,t){const{resolve:r,promise:n}=function(){let e;const t=new Promise((t=>{e=t}));return{resolve:e,promise:t}}();return t.push((t=>{e.result=(0,s.klona)(t.result),e.error=(0,s.klona)(t.error),r()})),n}(r,c),undefined):(c=[],e[a]=c,i("Carrying original request forward %o",t),await n(),delete e[a],i("Running %i collected handler(s) for request %o",c.length,t),function(e,t){setTimeout((()=>{t.forEach((t=>{try{t(e)}catch(e){console.error(e)}}))}))}(r,c),undefined)}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.js"}],[1659,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.projectLogger=void 0;const n=e("@metamask/utils");Object.defineProperty(r,"createModuleLogger",{enumerable:!0,get:function(){return n.createModuleLogger}}),r.projectLogger=(0,n.createProjectLogger)("eth-json-rpc-middleware")}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js"}],[1660,{"../utils/validation":1670,"@metamask/rpc-errors":2527,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.walletGetCallsStatus=r.GetCallsStatusCode=void 0;const n=e("@metamask/rpc-errors"),s=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../utils/validation"),i=(0,s.tuple)([a.StrictHexStruct]);!function(e){e[e.PENDING=100]="PENDING",e[e.CONFIRMED=200]="CONFIRMED",e[e.FAILED_OFFCHAIN=400]="FAILED_OFFCHAIN",e[e.REVERTED=500]="REVERTED",e[e.REVERTED_PARTIAL=600]="REVERTED_PARTIAL"}(r.GetCallsStatusCode||(r.GetCallsStatusCode={})),r.walletGetCallsStatus=async function(e,t,{getCallsStatus:r}){if(!r)throw n.rpcErrors.methodNotSupported();(0,o.validateParams)(e.params,i);const s=e.params[0];t.result=await r(s,e)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-calls-status.js"}],[1661,{"../utils/validation":1670,"@metamask/rpc-errors":2527,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.walletGetCapabilities=void 0;const n=e("@metamask/rpc-errors"),s=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../utils/validation"),i=(0,s.tuple)([a.HexChecksumAddressStruct,(0,s.optional)((0,s.array)(a.StrictHexStruct))]);r.walletGetCapabilities=async function(e,t,{getAccounts:r,getCapabilities:s}){if(!s)throw n.rpcErrors.methodNotSupported();(0,o.validateParams)(e.params,i);const a=e.params[0],c=e.params[1];await(0,o.validateAndNormalizeKeyholder)(a,e,{getAccounts:r});const l=await s(a,c,e);t.result=l}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-capabilities.js"}],[1662,{"../utils/validation":1670,"@metamask/rpc-errors":2527,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.walletSendCalls=void 0;const n=e("@metamask/rpc-errors"),s=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../utils/validation"),i=(0,s.record)((0,s.string)(),(0,s.type)({optional:(0,s.optional)((0,s.boolean)())})),c=(0,s.tuple)([(0,s.object)({version:(0,s.nonempty)((0,s.string)()),id:(0,s.optional)(a.StrictHexStruct),from:(0,s.optional)(a.HexChecksumAddressStruct),chainId:a.StrictHexStruct,atomicRequired:(0,s.boolean)(),calls:(0,s.array)((0,s.object)({to:(0,s.optional)(a.HexChecksumAddressStruct),data:(0,s.optional)(a.StrictHexStruct),value:(0,s.optional)(a.StrictHexStruct),capabilities:(0,s.optional)(i)})),capabilities:(0,s.optional)(i)})]);r.walletSendCalls=async function(e,t,{getAccounts:r,processSendCalls:s}){if(!s)throw n.rpcErrors.methodNotSupported();(0,o.validateParams)(e.params,c);const a=e.params[0],i=a.from?await(0,o.validateAndNormalizeKeyholder)(a.from,e,{getAccounts:r}):undefined,l=Object.assign(Object.assign({},a),{from:i});t.result=await s(l,e)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-send-calls.js"}],[1663,{"@metamask/json-rpc-engine":2022},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ethersProviderAsMiddleware=r.providerAsMiddleware=void 0;const n=e("@metamask/json-rpc-engine");r.providerAsMiddleware=function(e){return(0,n.createAsyncMiddleware)((async(t,r)=>{r.result=await e.request(t)}))},r.ethersProviderAsMiddleware=function(e){return(t,r,n,s)=>{e.send(t,((e,t)=>e?s(e):(Object.assign(r,t),s())))}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.js"}],[1664,{"./logging-utils":1659,"./utils/cache":1665,"./utils/error":1667,"./utils/timeout":1669,"@metamask/json-rpc-engine":2022,"klona/full":4770},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createRetryOnEmptyMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("klona/full"),a=e("./logging-utils"),o=e("./utils/cache"),i=e("./utils/error"),c=e("./utils/timeout"),l=(0,a.createModuleLogger)(a.projectLogger,"retry-on-empty"),u=[undefined,null,"<nil>"];r.createRetryOnEmptyMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('RetryOnEmptyMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('RetryOnEmptyMiddleware - mandatory "blockTracker" option is missing.');return(0,n.createAsyncMiddleware)((async(r,n,a)=>{const d=(0,o.blockTagParamIndex)(r.method);if(d===undefined)return a();let f=Array.isArray(r.params)&&r.params[d]?r.params[d]:undefined;if(f===undefined&&(f="latest"),["latest","pending"].includes(f))return a();const m=Number.parseInt(f.slice(2),16);if(Number.isNaN(m))return a();const h=await t.getLatestBlock(),p=Number.parseInt(h.slice(2),16);if(m>p)return l("Requested block number %o is higher than latest block number %o, falling through to original request",m,p),a();l("Requested block number %o is not higher than latest block number %o, trying request until non-empty response is received",m,p);const g=(0,s.klona)(r),b=await async function(e,t){for(let r=0;r<e;r++)try{return await t()}catch(e){if((0,i.isExecutionRevertedError)(e))throw e;l("(call %i) Request failed, waiting 1s to retry again...",r+1),await(0,c.timeout)(1e3)}throw l("Retries exhausted"),new Error("RetryOnEmptyMiddleware - retries exhausted")}(10,(async()=>{l("Performing request %o",g);const t=await e.request(g);l("Result is %o",t);if(u.includes(t))throw new Error(`RetryOnEmptyMiddleware - empty result "${JSON.stringify(t)}" for request "${JSON.stringify(g)}"`);return t}));return l("Copying result %o",b),n.result=b,undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.js"}],[1665,{"safe-stable-stringify":5608},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.cacheTypeForMethod=r.blockTagParamIndex=r.blockTagForRequest=r.canCache=r.cacheIdentifierForRequest=r.CacheStrategy=void 0;const n=(0,e("safe-stable-stringify").configure)({bigint:!1,circularValue:Error});var s;function a(e){return i(e)!==s.Never}function o(e){switch(e){case"eth_getStorageAt":return 2;case"eth_getBalance":case"eth_getCode":case"eth_getTransactionCount":case"eth_call":return 1;case"eth_getBlockByNumber":return 0;default:return undefined}}function i(e){switch(e){case"web3_clientVersion":case"web3_sha3":case"eth_protocolVersion":case"eth_getBlockTransactionCountByHash":case"eth_getUncleCountByBlockHash":case"eth_getCode":case"eth_getBlockByHash":case"eth_getTransactionByHash":case"eth_getTransactionByBlockHashAndIndex":case"eth_getTransactionReceipt":case"eth_getUncleByBlockHashAndIndex":case"eth_getCompilers":case"eth_compileLLL":case"eth_compileSolidity":case"eth_compileSerpent":case"shh_version":case"test_permaCache":return s.Permanent;case"eth_getBlockByNumber":case"eth_getBlockTransactionCountByNumber":case"eth_getUncleCountByBlockNumber":case"eth_getTransactionByBlockNumberAndIndex":case"eth_getUncleByBlockNumberAndIndex":case"test_forkCache":return s.Fork;case"eth_gasPrice":case"eth_blockNumber":case"eth_getBalance":case"eth_getStorageAt":case"eth_getTransactionCount":case"eth_call":case"eth_estimateGas":case"eth_getFilterLogs":case"eth_getLogs":case"test_blockCache":return s.Block;default:return s.Never}}!function(e){e.Block="block",e.Fork="fork",e.Never="never",e.Permanent="perma"}(s=r.CacheStrategy||(r.CacheStrategy={})),r.cacheIdentifierForRequest=function(e,t){var r;const s=t?function(e){if(!e.params)return[];const t=o(e.method);if(t===undefined||!Array.isArray(e.params)||t>=e.params.length)return e.params;if("eth_getBlockByNumber"===e.method)return e.params.slice(1);return e.params.slice(0,t)}(e):null!==(r=e.params)&&void 0!==r?r:[];return a(e.method)?`${e.method}:${n(s)}`:null},r.canCache=a,r.blockTagForRequest=function(e){if(!e.params)return undefined;const t=o(e.method);return t===undefined||!Array.isArray(e.params)||t>=e.params.length?undefined:e.params[t]},r.blockTagParamIndex=o,r.cacheTypeForMethod=i}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js"}],[1666,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.stripArrayTypeIfPresent=void 0;r.stripArrayTypeIfPresent=e=>(null==e?void 0:e.match(/\S\[\d*\]$/u))?e.replace(/\[\d*\]$/gu,"").trim():e}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.js"}],[1667,{"@metamask/rpc-errors":2527,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.isExecutionRevertedError=void 0;const n=e("@metamask/rpc-errors"),s=e("@metamask/utils");r.isExecutionRevertedError=function(e){return(0,s.isJsonRpcError)(e)&&e.code===n.errorCodes.rpc.invalidInput&&"execution reverted"===e.message}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.js"}],[1668,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){return"string"!=typeof e?e:JSON.parse(e)}Object.defineProperty(r,"__esModule",{value:!0}),r.parseTypedMessage=r.normalizeTypedMessage=void 0,r.normalizeTypedMessage=function(e){var t;let r;try{r=n(e)}catch(t){return e}const{verifyingContract:s}=null!==(t=r.domain)&&void 0!==t?t:{};return s?(r.domain.verifyingContract=function(e){if(e.startsWith("0X"))return`0x${e.slice(2)}`;return e}(s),JSON.stringify(r)):e},r.parseTypedMessage=n}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.js"}],[1669,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.timeout=void 0,r.timeout=async function(e){return new Promise((t=>setTimeout(t,e)))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.js"}],[1670,{"@metamask/rpc-errors":2527,"@metamask/superstruct":2872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.resemblesAddress=r.validateParams=r.validateAndNormalizeKeyholder=void 0;const n=e("@metamask/rpc-errors"),s=e("@metamask/superstruct");function a(e){return 42===e.length}r.validateAndNormalizeKeyholder=async function(e,t,{getAccounts:r}){if("string"==typeof e&&e.length>0&&a(e)){const s=(await r(t)).map((e=>e.toLowerCase())),a=e.toLowerCase();if(s.includes(a))return a;throw n.providerErrors.unauthorized()}throw n.rpcErrors.invalidParams({message:"Invalid parameters: must provide an Ethereum address."})},r.validateParams=function(e,t){const[r]=(0,s.validate)(e,t);if(r)throw n.rpcErrors.invalidParams(function(e,t){return`${t}\n\n${e.failures().map((e=>`${e.path.join(" > ")}${e.path.length?" - ":""}${e.message}`)).join("\n")}`}(r,"Invalid params"))},r.resemblesAddress=a}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.js"}],[1671,{"./methods/wallet-get-calls-status":1660,"./methods/wallet-get-capabilities":1661,"./methods/wallet-send-calls":1662,"./utils/common":1666,"./utils/normalize":1668,"./utils/validation":1670,"@metamask/eth-sig-util":1708,"@metamask/json-rpc-engine":2022,"@metamask/rpc-errors":2527,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return s(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.createWalletMiddleware=void 0;const o=a(e("@metamask/eth-sig-util")),i=e("@metamask/json-rpc-engine"),c=e("@metamask/rpc-errors"),l=e("@metamask/utils"),u=e("./methods/wallet-get-calls-status"),d=e("./methods/wallet-get-capabilities"),f=e("./methods/wallet-send-calls"),m=e("./utils/common"),h=e("./utils/normalize"),p=e("./utils/validation");function g(e){const{primaryType:t,types:r}=(0,h.parseTypedMessage)(e);if(!r)throw c.rpcErrors.invalidInput();if(!r[(0,m.stripArrayTypeIfPresent)(t)])throw c.rpcErrors.invalidInput()}function b(e){const{domain:{verifyingContract:t}={}}=(0,h.parseTypedMessage)(e);if(t&&"cosmos"!==t&&!(0,l.isValidHexAddress)(t))throw c.rpcErrors.invalidInput()}r.createWalletMiddleware=function({getAccounts:e,getCallsStatus:t,getCapabilities:r,processDecryptMessage:n,processEncryptionPublicKey:s,processPersonalMessage:a,processTransaction:l,processSignTransaction:m,processTypedMessage:y,processTypedMessageV3:E,processTypedMessageV4:w,processSendCalls:k}){if(!e)throw new Error("opts.getAccounts is required");return(0,i.createScaffoldMiddleware)({eth_accounts:(0,i.createAsyncMiddleware)((async function(t,r){r.result=await e(t)})),eth_coinbase:(0,i.createAsyncMiddleware)((async function(t,r){const n=await e(t);r.result=n[0]||null})),eth_sendTransaction:(0,i.createAsyncMiddleware)((async function(e,t){if(!l)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params[0],n=Object.assign(Object.assign({},r),{from:await v((null==r?void 0:r.from)||"",e)});t.result=await l(n,e)})),eth_signTransaction:(0,i.createAsyncMiddleware)((async function(e,t){if(!m)throw c.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params[0],n=Object.assign(Object.assign({},r),{from:await v((null==r?void 0:r.from)||"",e)});t.result=await m(n,e)})),eth_signTypedData:(0,i.createAsyncMiddleware)((async function(e,t){if(!y)throw c.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=r[0],s=await v(r[1],e),a=r[2]||{},o=Object.assign(Object.assign({},a),{from:s,data:n,signatureMethod:"eth_signTypedData",version:"V1"});t.result=await y(o,e,"V1")})),eth_signTypedData_v3:(0,i.createAsyncMiddleware)((async function(e,t){if(!E)throw c.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=await v(r[0],e),s=(0,h.normalizeTypedMessage)(r[1]);g(s),b(s);const a={data:s,from:n,version:"V3",signatureMethod:"eth_signTypedData_v3"};t.result=await E(a,e,"V3")})),eth_signTypedData_v4:(0,i.createAsyncMiddleware)((async function(e,t){if(!w)throw c.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=await v(r[0],e),s=(0,h.normalizeTypedMessage)(r[1]);g(s),b(s);const a={data:s,from:n,version:"V4",signatureMethod:"eth_signTypedData_v4"};t.result=await w(a,e,"V4")})),personal_sign:(0,i.createAsyncMiddleware)((async function(e,t){if(!a)throw c.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=r[0],s=r[1],o=r[2]||{};let i,l;if((0,p.resemblesAddress)(n)&&!(0,p.resemblesAddress)(s)){let e="The eth_personalSign method requires params ordered ";e+="[message, address]. This was previously handled incorrectly, ",e+="and has been corrected automatically. ",e+="Please switch this param order for smooth behavior in the future.",t.warning=e,i=n,l=s}else l=n,i=s;i=await v(i,e);const u=Object.assign(Object.assign({},o),{from:i,data:l,signatureMethod:"personal_sign"});t.result=await a(u,e)})),eth_getEncryptionPublicKey:(0,i.createAsyncMiddleware)((async function(e,t){if(!s)throw c.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params,n=await v(r[0],e);t.result=await s(n,e)})),eth_decrypt:(0,i.createAsyncMiddleware)((async function(e,t){if(!n)throw c.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=1))throw c.rpcErrors.invalidInput();const r=e.params,s=r[0],a=await v(r[1],e),o=r[2]||{},i=Object.assign(Object.assign({},o),{from:a,data:s});t.result=await n(i,e)})),personal_ecRecover:(0,i.createAsyncMiddleware)((async function(e,t){if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw c.rpcErrors.invalidInput();const r=e.params,n=r[0],s=r[1],a=o.recoverPersonalSignature({data:n,signature:s});t.result=a})),wallet_getCapabilities:(0,i.createAsyncMiddleware)((async(t,n)=>(0,d.walletGetCapabilities)(t,n,{getAccounts:e,getCapabilities:r}))),wallet_sendCalls:(0,i.createAsyncMiddleware)((async(t,r)=>(0,f.walletSendCalls)(t,r,{getAccounts:e,processSendCalls:k}))),wallet_getCallsStatus:(0,i.createAsyncMiddleware)((async(e,r)=>(0,u.walletGetCallsStatus)(e,r,{getCallsStatus:t})))});async function v(t,r){return(0,p.validateAndNormalizeKeyholder)(t,r,{getAccounts:e})}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.js"}],[1672,{"./bytes":1675,"./constants":1676,"./helpers":1678,"./internal":1680,"@ethereumjs/rlp":497,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358,"ethereum-cryptography/utils":4360},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.accountBodyToRLP=r.accountBodyToSlim=r.accountBodyFromSlim=r.isZeroAddress=r.zeroAddress=r.importPublic=r.privateToAddress=r.privateToPublic=r.publicToAddress=r.pubToAddress=r.isValidPublic=r.isValidPrivate=r.generateAddress2=r.generateAddress=r.isValidChecksumAddress=r.toChecksumAddress=r.isValidAddress=r.Account=void 0;const n=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),l=e("./helpers"),u=e("./internal"),d=BigInt(0);class f{constructor(e=d,t=d,r=c.KECCAK256_RLP,n=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=r,this.codeHash=n,this._validate()}static fromAccountData(e){const{nonce:t,balance:r,storageRoot:n,codeHash:s}=e;return new f(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,r!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(r)):undefined,n!==undefined?(0,i.toBuffer)(n):undefined,s!==undefined?(0,i.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(n.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,r,n,s]=e;return new f((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(r),n,s)}_validate(){if(this.nonce<d)throw new Error("nonce must be greater than zero");if(this.balance<d)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(n.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===d&&this.nonce===d&&this.codeHash.equals(c.KECCAK256_NULL)}}r.Account=f;r.isValidAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};r.toChecksumAddress=function(e,r){(0,l.assertIsHexString)(e);const n=(0,u.stripHexPrefix)(e).toLowerCase();let a="";if(r!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(r)).toString()+"0x"}const c=t.from(a+n,"utf8"),d=(0,o.bytesToHex)((0,s.keccak256)(c));let f="0x";for(let e=0;e<n.length;e++)parseInt(d[e],16)>=8?f+=n[e].toUpperCase():f+=n[e];return f};r.isValidChecksumAddress=function(e,t){return(0,r.isValidAddress)(e)&&(0,r.toChecksumAddress)(e,t)===e};r.generateAddress=function(e,r){return(0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,i.bufferToBigInt)(r)===BigInt(0)?t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,r])))).slice(-20)};r.generateAddress2=function(e,r,n){if((0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,l.assertIsBuffer)(n),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==r.length)throw new Error("Expected salt to be of length 32");const a=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,r,(0,s.keccak256)(n)]));return(0,i.toBuffer)(a).slice(-20)};r.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};r.isValidPublic=function(e,r=!1){if((0,l.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!r)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};r.pubToAddress=function(e,r=!1){if((0,l.assertIsBuffer)(e),r&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},r.publicToAddress=r.pubToAddress;r.privateToPublic=function(e){return(0,l.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};r.privateToAddress=function(e){return(0,r.publicToAddress)((0,r.privateToPublic)(e))};r.importPublic=function(e){return(0,l.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};r.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function m(e){const[t,r,n,s]=e;return[t,r,0===(0,i.arrToBufArr)(n).length?c.KECCAK256_RLP:n,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}r.isZeroAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return(0,r.zeroAddress)()===e},r.accountBodyFromSlim=m;const h=new Uint8Array(0);r.accountBodyToSlim=function(e){const[t,r,n,s]=e;return[t,r,(0,i.arrToBufArr)(n).equals(c.KECCAK256_RLP)?h:n,(0,i.arrToBufArr)(s).equals(c.KECCAK256_NULL)?h:s]},r.accountBodyToRLP=function(e,t=!0){const r=t?m(e):e;return(0,i.arrToBufArr)(n.RLP.encode(r))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/account.js"}],[1673,{"./account":1672,"./bytes":1675,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Address=void 0;const n=e("./account"),s=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,s.zeros)(20))}static fromString(e){if(!(0,n.isValidAddress)(e))throw new Error("Invalid address");return new a((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const r=(0,n.pubToAddress)(e);return new a(r)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const r=(0,n.privateToAddress)(e);return new a(r)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,n.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,r,s){if(!t.isBuffer(r))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new a((0,n.generateAddress2)(e.buf,r,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),r=BigInt("0xffff");return e>=t&&e<=r}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}r.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/address.js"}],[1674,{events:4440},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AsyncEventEmitter=void 0;const n=e("events");class s extends n.EventEmitter{emit(e,...t){let[r,n]=t;const s=this;let a=s._events[e]??[];return n===undefined&&"function"==typeof r&&(n=r,r=undefined),"newListener"!==e&&"removeListener"!==e||(r={event:r,fn:n},n=undefined),a=Array.isArray(a)?a:[a],async function(e,t,r){let n;for await(const s of t)try{s.length<2?s.call(e,r):await new Promise(((t,n)=>{s.call(e,r,(e=>{e?n(e):t()}))}))}catch(e){n=e}if(n)throw n}(s,a.slice(),r).then(n).catch(n),s.listenerCount(e)>0}once(e,t){const r=this;let n;if("function"!=typeof t)throw new TypeError("listener must be a function");return n=t.length>=2?function(s,a){r.removeListener(e,n),t(s,a)}:function(s){r.removeListener(e,n),t(s,n)},r.on(e,n),r}first(e,t){let r=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(r)||(this._events[e]=r=[r]),r.unshift(t),this}before(e,t,r){return this.beforeOrAfter(e,t,r)}after(e,t,r){return this.beforeOrAfter(e,t,r,"after")}beforeOrAfter(e,t,r,n){let s,a,o=this._events[e]??[];const i="after"===n?1:0;if("function"!=typeof r)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,s=o.length;s--;)if(o[s]===t){a=s+i;break}return o.splice(a,0,r),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}r.AsyncEventEmitter=s}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],[1675,{"./helpers":1678,"./internal":1680,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.intToUnpaddedBuffer=r.bigIntToUnpaddedBuffer=r.bigIntToHex=r.bufArrToArr=r.arrToBufArr=r.validateNoLeadingZeroes=r.baToJSON=r.toUtf8=r.short=r.addHexPrefix=r.toUnsigned=r.fromSigned=r.bufferToInt=r.bigIntToBuffer=r.bufferToBigInt=r.bufferToHex=r.toBuffer=r.unpadHexString=r.unpadArray=r.unpadBuffer=r.setLengthRight=r.setLengthLeft=r.zeros=r.intToBuffer=r.intToHex=void 0;const n=e("./helpers"),s=e("./internal");r.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};r.intToBuffer=function(e){const n=(0,r.intToHex)(e);return t.from((0,s.padToEven)(n.slice(2)),"hex")};r.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,n){const s=(0,r.zeros)(t);return n?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};r.setLengthLeft=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!1)};r.setLengthRight=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};r.unpadBuffer=function(e){return(0,n.assertIsBuffer)(e),o(e)};r.unpadArray=function(e){return(0,n.assertIsArray)(e),o(e)};r.unpadHexString=function(e){return(0,n.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+o(e)};r.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,r.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let r=e.toString(16);return r.length%2&&(r="0"+r),t.from(r,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,r.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,r.toBuffer)("0x"+e.toString(16))}r.bufferToHex=function(e){return"0x"+(e=(0,r.toBuffer)(e)).toString("hex")},r.bufferToBigInt=i,r.bigIntToBuffer=c;r.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};r.fromSigned=function(e){return BigInt.asIntN(256,i(e))};r.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};r.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},r.short=function(e,r=50){const n=t.isBuffer(e)?e.toString("hex"):e;return n.length<=r?n:n.slice(0,r)+"…"};r.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};r.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let n=0;n<e.length;n++)t.push((0,r.baToJSON)(e[n]));return t}};r.validateNoLeadingZeroes=function(e){for(const[t,r]of Object.entries(e))if(r!==undefined&&r.length>0&&0===r[0])throw new Error(`${t} cannot have leading zeroes, received: ${r.toString("hex")}`)},r.arrToBufArr=function e(r){return Array.isArray(r)?r.map((t=>e(t))):t.from(r)},r.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};r.bigIntToHex=e=>"0x"+e.toString(16),r.bigIntToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)(c(e))},r.intToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)((0,r.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js"}],[1676,{buffer:4108,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAX_WITHDRAWALS_PER_PAYLOAD=r.RLP_EMPTY_STRING=r.KECCAK256_RLP=r.KECCAK256_RLP_S=r.KECCAK256_RLP_ARRAY=r.KECCAK256_RLP_ARRAY_S=r.KECCAK256_NULL=r.KECCAK256_NULL_S=r.TWO_POW256=r.SECP256K1_ORDER_DIV_2=r.SECP256K1_ORDER=r.MAX_INTEGER_BIGINT=r.MAX_INTEGER=r.MAX_UINT64=void 0;const n=e("buffer"),s=e("ethereum-cryptography/secp256k1");r.MAX_UINT64=BigInt("0xffffffffffffffff"),r.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),r.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),r.SECP256K1_ORDER=s.secp256k1.CURVE.n,r.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),r.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),r.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",r.KECCAK256_NULL=n.Buffer.from(r.KECCAK256_NULL_S,"hex"),r.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",r.KECCAK256_RLP_ARRAY=n.Buffer.from(r.KECCAK256_RLP_ARRAY_S,"hex"),r.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",r.KECCAK256_RLP=n.Buffer.from(r.KECCAK256_RLP_S,"hex"),r.RLP_EMPTY_STRING=n.Buffer.from([128]),r.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/constants.js"}],[1677,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.compactBytesToNibbles=r.bytesToNibbles=r.nibblesToCompactBytes=r.nibblesToBytes=r.hasTerminator=void 0;r.hasTerminator=e=>e.length>0&&16===e[e.length-1];r.nibblesToBytes=(e,t)=>{for(let r=0,n=0;n<e.length;r+=1,n+=2)t[r]=e[n]<<4|e[n+1]};r.nibblesToCompactBytes=e=>{let t=0;(0,r.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const n=new Uint8Array(e.length/2+1);return n[0]=t<<5,1&~e.length||(n[0]|=16,n[0]|=e[0],e=e.subarray(1)),(0,r.nibblesToBytes)(e,n.subarray(1)),n};r.bytesToNibbles=e=>{const t=2*e.length+1,r=new Uint8Array(t);for(let t=0;t<e.length;t++){const n=e[t];r[2*t]=n/16,r[2*t+1]=n%16}return r[t-1]=16,r};r.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,r.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const n=2-(1&t[0]);return t.subarray(n)}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/encoding.js"}],[1678,{"../../../../../../is-buffer/index.js":4701,"./internal":1680},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.assertIsString=r.assertIsArray=r.assertIsBuffer=r.assertIsHexString=void 0;const n=e("./internal");r.assertIsHexString=function(e){if(!(0,n.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};r.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};r.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};r.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/helpers.js"}],[1679,{"./account":1672,"./address":1673,"./asyncEventEmitter":1674,"./bytes":1675,"./constants":1676,"./encoding":1677,"./internal":1680,"./lock":1681,"./provider":1682,"./signature":1683,"./types":1684,"./units":1685,"./withdrawal":1686},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.toAscii=r.stripHexPrefix=r.padToEven=r.isHexString=r.isHexPrefixed=r.getKeys=r.getBinarySize=r.fromUtf8=r.fromAscii=r.arrayContainsArray=void 0,s(e("./constants"),r),s(e("./units"),r),s(e("./account"),r),s(e("./address"),r),s(e("./withdrawal"),r),s(e("./signature"),r),s(e("./bytes"),r),s(e("./types"),r),s(e("./encoding"),r),s(e("./asyncEventEmitter"),r);var a=e("./internal");Object.defineProperty(r,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(r,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(r,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(r,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(r,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(r,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(r,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(r,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(r,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(r,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),s(e("./lock"),r),s(e("./provider"),r)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/index.js"}],[1680,{buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(r,"__esModule",{value:!0}),r.isHexString=r.getKeys=r.fromAscii=r.fromUtf8=r.toAscii=r.arrayContainsArray=r.getBinarySize=r.padToEven=r.stripHexPrefix=r.isHexPrefixed=void 0,r.isHexPrefixed=t;function n(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}r.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},r.padToEven=n,r.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},r.arrayContainsArray=function(e,t,r){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===r?"some":"every"]((t=>e.indexOf(t)>=0))},r.toAscii=function(e){let t="",r=0;const n=e.length;for("0x"===e.substring(0,2)&&(r=2);r<n;r+=2){const n=parseInt(e.substr(r,2),16);t+=String.fromCharCode(n)}return t},r.fromUtf8=function(t){return`0x${n(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},r.fromAscii=function(e){let t="";for(let r=0;r<e.length;r++){const n=e.charCodeAt(r).toString(16);t+=n.length<2?`0${n}`:n}return`0x${t}`},r.getKeys=function(e,t,r){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const n=[];for(let s=0;s<e.length;s++){let a=e[s][t];if(!0!==r||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";n.push(a)}return n},r.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js"}],[1681,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Lock=void 0;r.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/lock.js"}],[1682,{"micro-ftch":4981},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getProvider=r.fetchFromProvider=void 0;const n=e("micro-ftch");r.fetchFromProvider=async(e,t)=>(await(0,n.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;r.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/provider.js"}],[1683,{"./bytes":1675,"./constants":1676,"./helpers":1678,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.hashPersonalMessage=r.isValidSignature=r.fromRpcSig=r.toCompactSig=r.toRpcSig=r.ecrecover=r.ecsign=void 0;const n=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function l(e){return e===BigInt(0)||e===BigInt(1)}r.ecsign=function(e,r,n){const a=s.secp256k1.sign(e,r),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:n===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(n)*BigInt(2)}};r.ecrecover=function(e,r,n,o,i){const u=t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(o,32)],64),d=c(r,i);if(!l(d))throw new Error("Invalid signature v value");const f=s.secp256k1.Signature.fromCompact(u).addRecoveryBit(Number(d)).recoverPublicKey(e);return t.from(f.toRawBytes(!1).slice(1))};r.toRpcSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(n,32),(0,a.toBuffer)(e)]))};r.toCompactSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");let o=n;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(n),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)]))};r.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let r,n,s;if(t.length>=65)r=t.slice(0,32),n=t.slice(32,64),s=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");r=t.slice(0,32),n=t.slice(32,64),s=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),n[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:r,s:n}};r.isValidSignature=function(e,t,r,n=!0,s){if(32!==t.length||32!==r.length)return!1;if(!l(c(e,s)))return!1;const i=(0,a.bufferToBigInt)(t),u=(0,a.bufferToBigInt)(r);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||u===BigInt(0)||u>=o.SECP256K1_ORDER)&&!(n&&u>=o.SECP256K1_ORDER_DIV_2)};r.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const r=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,n.keccak256)(t.concat([r,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/signature.js"}],[1684,{"./bytes":1675,"./internal":1680},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.toType=r.TypeOutput=void 0;const n=e("./bytes"),s=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=r.TypeOutput||(r.TypeOutput={})),r.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const r=(0,n.toBuffer)(e);switch(t){case a.Buffer:return r;case a.BigInt:return(0,n.bufferToBigInt)(r);case a.Number:{const e=(0,n.bufferToBigInt)(r);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,n.bufferToHex)(r);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/types.js"}],[1685,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.GWEI_TO_WEI=void 0,r.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/units.js"}],[1686,{"./address":1673,"./bytes":1675,"./types":1684,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Withdrawal=void 0;const n=e("./address"),s=e("./bytes"),a=e("./types");class o{constructor(e,t,r,n){this.index=e,this.validatorIndex=t,this.address=r,this.amount=n}static fromWithdrawalData(e){const{index:t,validatorIndex:r,address:s,amount:i}=e,c=(0,a.toType)(t,a.TypeOutput.BigInt),l=(0,a.toType)(r,a.TypeOutput.BigInt),u=new n.Address((0,a.toType)(s,a.TypeOutput.Buffer)),d=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(c,l,u,d)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,r,n,s]=e;return o.fromWithdrawalData({index:t,validatorIndex:r,address:n,amount:s})}static toBufferArray(e){const{index:r,validatorIndex:s,address:o,amount:i}=e,c=(0,a.toType)(r,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(r,a.TypeOutput.Buffer),l=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer);let u;u=o instanceof n.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[c,l,u,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}r.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/withdrawal.js"}],[1687,{"./errors":1688,"./packer":1691,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.decodeSingle=r.decode=r.encodePacked=r.encodeSingle=r.encode=void 0;const n=e("@metamask/utils"),s=e("./errors"),a=e("./packer");r.encode=(e,t,r,n)=>{try{return(0,a.pack)({types:e,values:t,packed:r,tight:n})}catch(e){if(e instanceof s.ParserError)throw new s.ParserError(`Unable to encode value: ${e.message}`,e);throw new s.ParserError(`An unexpected error occurred: ${(0,s.getErrorMessage)(e)}`,e)}};r.encodeSingle=(e,t)=>(0,r.encode)([e],[t]);r.encodePacked=(e,t,n)=>(0,r.encode)(e,t,!0,n);r.decode=(e,t)=>{const r=(0,n.createBytes)(t);try{return(0,a.unpack)(e,r)}catch(e){if(e instanceof s.ParserError)throw new s.ParserError(`Unable to decode value: ${e.message}`,e);throw new s.ParserError(`An unexpected error occurred: ${(0,s.getErrorMessage)(e)}`,e)}};r.decodeSingle=(e,t)=>{const a=(0,r.decode)([e],t);return(0,n.assert)(1===a.length,new s.ParserError("Decoded value array has unexpected length.")),a[0]}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/abi.js"}],[1688,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ParserError=r.getErrorStack=r.getErrorMessage=void 0;const n=e("@metamask/utils");r.getErrorMessage=e=>"string"==typeof e?e:e instanceof Error||(0,n.isObject)(e)&&(0,n.hasProperty)(e,"message")&&"string"==typeof e.message?e.message:"Unknown error.";r.getErrorStack=e=>e instanceof Error?e.stack:undefined;class s extends Error{constructor(e,t){super(e),this.name="ParserError";const n=(0,r.getErrorStack)(t);n&&(this.stack=n)}}r.ParserError=s}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js"}],[1689,{"./abi":1687,"./errors":1688,"./types":1704},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./abi"),r),s(e("./errors"),r),s(e("./types"),r)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/index.js"}],[1690,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.iterate=void 0;const n=e("@metamask/utils");r.iterate=function*(e,t=32){for(let r=0;r<e.length;r+=t){const s=e=>{(0,n.assert)(e>=0,"Cannot skip a negative number of bytes."),(0,n.assert)(e%t==0,"Length must be a multiple of the size."),r+=e},a=e.subarray(r);yield{skip:s,value:a}}return{skip:()=>undefined,value:new Uint8Array}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/iterator.js"}],[1691,{"./errors":1688,"./iterator":1690,"./parsers":1698,"./utils":1706,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.unpack=r.pack=r.isDynamicParser=r.getParser=void 0;const n=e("@metamask/utils"),s=e("./errors"),a=e("./iterator"),o=e("./parsers"),i=e("./utils");r.getParser=e=>{const t={address:o.address,array:o.array,bool:o.bool,bytes:o.bytes,fixedBytes:o.fixedBytes,function:o.fn,number:o.number,string:o.string,tuple:o.tuple},r=t[e];if(r)return r;const n=Object.values(t).find((t=>t.isType(e)));if(n)return n;throw new s.ParserError(`The type "${e}" is not supported.`)};r.isDynamicParser=(e,t)=>{const{isDynamic:r}=e;return"function"==typeof r?r(t):r};r.pack=({types:e,values:t,packed:a=!1,tight:o=!1,arrayPacked:c=!1,byteArray:l=new Uint8Array})=>{(0,n.assert)(e.length===t.length,new s.ParserError(`The number of types (${e.length}) does not match the number of values (${t.length}).`));const{staticBuffer:u,dynamicBuffer:d,pointers:f}=e.reduce((({staticBuffer:e,dynamicBuffer:s,pointers:i},l,u)=>{const d=(0,r.getParser)(l),f=t[u];if(a||c||!(0,r.isDynamicParser)(d,l))return{staticBuffer:d.encode({buffer:e,value:f,type:l,packed:a,tight:o}),dynamicBuffer:s,pointers:i};return{staticBuffer:(0,n.concatBytes)([e,new Uint8Array(32)]),dynamicBuffer:d.encode({buffer:s,value:f,type:l,packed:a,tight:o}),pointers:[...i,{position:e.length,pointer:s.length}]}}),{staticBuffer:new Uint8Array,dynamicBuffer:new Uint8Array,pointers:[]});(0,n.assert)(!a&&!c||0===d.length,new s.ParserError("Invalid pack state."));const m=u.length,h=f.reduce(((e,{pointer:t,position:r})=>{const s=(0,i.padStart)((0,n.numberToBytes)(m+t));return(0,i.set)(e,s,r)}),u);return(0,n.concatBytes)([l,h,d])};r.unpack=(e,t)=>{const o=(0,a.iterate)(t);return e.map((e=>{const{value:{value:a,skip:i},done:c}=o.next();(0,n.assert)(!c,new s.ParserError(`The encoded value is invalid for the provided types. Reached end of buffer while attempting to parse "${e}".`));const l=(0,r.getParser)(e);if((0,r.isDynamicParser)(l,e)){const r=(0,n.bytesToNumber)(a.subarray(0,32)),s=t.subarray(r);return l.decode({type:e,value:s,skip:i})}return l.decode({type:e,value:a,skip:i})}))}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/packer.js"}],[1692,{"../errors":1688,"../utils":1706,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.address=r.getAddress=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils");r.getAddress=e=>{const t=(0,n.createBytes)(e);return(0,n.assert)(t.length<=20,new s.ParserError(`Invalid address value. Expected address to be 20 bytes long, but received ${t.length} bytes.`)),(0,a.padStart)(t,20)},r.address={isDynamic:!1,isType:e=>"address"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:s}){const o=(0,r.getAddress)(t);if(s)return(0,n.concatBytes)([e,o]);const i=(0,a.padStart)(o);return(0,n.concatBytes)([e,i])},decode:({value:e})=>(0,n.add0x)((0,n.bytesToHex)(e.slice(12,32)))}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/address.js"}],[1693,{"../errors":1688,"../packer":1691,"../utils":1706,"./fixed-bytes":1696,"./tuple":1702,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.array=r.getTupleType=r.getArrayType=r.isArrayType=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../packer"),o=e("../utils"),i=e("./fixed-bytes"),c=e("./tuple"),l=/^(?<type>.*)\[(?<length>\d*?)\]$/u;r.isArrayType=e=>l.test(e);r.getArrayType=e=>{const t=e.match(l);return(0,n.assert)(t?.groups?.type,new s.ParserError(`Invalid array type. Expected an array type, but received "${e}".`)),[t.groups.type,t.groups.length?parseInt(t.groups.length,10):undefined]};r.getTupleType=(e,t)=>`(${new Array(t).fill(e).join(",")})`,r.array={isDynamic(e){const[t,n]=(0,r.getArrayType)(e);return n===undefined||(0,a.isDynamicParser)((0,a.getParser)(t),t)},isType:e=>(0,r.isArrayType)(e),getByteLength(e){(0,n.assert)((0,r.isArrayType)(e),new s.ParserError(`Expected an array type, but received "${e}".`));const[t,o]=(0,r.getArrayType)(e);return(0,a.isDynamicParser)(this,e)||o===undefined?32:c.tuple.getByteLength((0,r.getTupleType)(t,o))},encode({type:e,buffer:t,value:l,packed:u,tight:d}){const[f,m]=(0,r.getArrayType)(e);if((0,n.assert)(!u||!(0,r.isArrayType)(f),new s.ParserError("Cannot pack nested arrays.")),u&&(0,a.isDynamicParser)((0,a.getParser)(f),f))return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:t,packed:u,arrayPacked:!0,tight:d});if(m)return(0,n.assert)(m===l.length,new s.ParserError(`Array length does not match type length. Expected a length of ${m}, but received ${l.length}.`)),c.tuple.encode({type:(0,r.getTupleType)(f,m),buffer:t,value:l,packed:i.fixedBytes.isType(f)&&d,tight:d});if(u)return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:t,packed:i.fixedBytes.isType(f)&&d,arrayPacked:!0,tight:d});const h=(0,o.padStart)((0,n.numberToBytes)(l.length));return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:(0,n.concatBytes)([t,h]),packed:u,tight:d})},decode({type:e,value:t,...o}){const[i,l]=(0,r.getArrayType)(e);if(l){const e=c.tuple.decode({type:(0,r.getTupleType)(i,l),value:t,...o});return(0,n.assert)(e.length===l,new s.ParserError(`Array length does not match type length. Expected a length of ${l}, but received ${e.length}.`)),e}const u=(0,n.bytesToNumber)(t.subarray(0,32));return(0,a.unpack)(new Array(u).fill(i),t.subarray(32))}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/array.js"}],[1694,{"../errors":1688,"./number":1699,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.bool=r.getBooleanValue=void 0;const n=e("@metamask/superstruct"),s=e("@metamask/utils"),a=e("../errors"),o=e("./number"),i=(0,n.coerce)((0,n.boolean)(),(0,n.union)([(0,n.literal)("true"),(0,n.literal)("false")]),(e=>"true"===e));r.getBooleanValue=e=>{try{return(0,n.create)(e,i)?BigInt(1):BigInt(0)}catch{throw new a.ParserError(`Invalid boolean value. Expected a boolean literal, or the string "true" or "false", but received "${e}".`)}},r.bool={isDynamic:!1,isType:e=>"bool"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n,tight:a}){const i=(0,r.getBooleanValue)(t);return n?(0,s.concatBytes)([e,(0,s.bigIntToBytes)(i)]):o.number.encode({type:"uint256",buffer:e,value:i,packed:n,tight:a})},decode:e=>o.number.decode({...e,type:"uint256"})===BigInt(1)}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bool.js"}],[1695,{"../utils":1706,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=void 0;const n=e("@metamask/utils"),s=e("../utils");r.bytes={isDynamic:!0,isType:e=>"bytes"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r}){const a=(0,n.createBytes)(t);if(r)return(0,n.concatBytes)([e,a]);const o=32*Math.ceil(a.byteLength/32);return(0,n.concatBytes)([e,(0,s.padStart)((0,n.numberToBytes)(a.byteLength)),(0,s.padEnd)(a,o)])},decode({value:e}){const t=e.subarray(0,32),r=(0,n.bytesToNumber)(t);return e.slice(32,32+r)}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bytes.js"}],[1696,{"../errors":1688,"../utils":1706,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.fixedBytes=r.getByteLength=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils"),o=/^bytes([0-9]{1,2})$/u;r.getByteLength=e=>{const t=e.match(o)?.[1];(0,n.assert)(t,`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`);const r=Number(t);return(0,n.assert)(r>0&&r<=32,new s.ParserError(`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`)),r},r.fixedBytes={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:o,packed:i}){const c=(0,r.getByteLength)(e),l=(0,n.createBytes)(o);return(0,n.assert)(l.length<=c,new s.ParserError(`Expected a value of length ${c}, but received a value of length ${l.length}.`)),i?(0,n.concatBytes)([t,(0,a.padEnd)(l,c)]):(0,n.concatBytes)([t,(0,a.padEnd)(l)])},decode({type:e,value:t}){const n=(0,r.getByteLength)(e);return t.slice(0,n)}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js"}],[1697,{"../errors":1688,"./fixed-bytes":1696,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.fn=r.getFunction=void 0;const n=e("@metamask/superstruct"),s=e("@metamask/utils"),a=e("../errors"),o=e("./fixed-bytes"),i=(0,n.coerce)((0,n.object)({address:s.StrictHexStruct,selector:s.StrictHexStruct}),(0,n.union)([s.StrictHexStruct,(0,n.instance)(Uint8Array)]),(e=>{const t=(0,s.createBytes)(e);return(0,s.assert)(24===t.length,new a.ParserError(`Invalid Solidity function. Expected function to be 24 bytes long, but received ${t.length} bytes.`)),{address:(0,s.bytesToHex)(t.subarray(0,20)),selector:(0,s.bytesToHex)(t.subarray(20,24))}}));r.getFunction=e=>{const t=(0,n.create)(e,i);return(0,s.concatBytes)([(0,s.hexToBytes)(t.address),(0,s.hexToBytes)(t.selector)])},r.fn={isDynamic:!1,isType:e=>"function"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n,tight:s}){const a=(0,r.getFunction)(t);return o.fixedBytes.encode({type:"bytes24",buffer:e,value:a,packed:n,tight:s})},decode:({value:e})=>({address:(0,s.bytesToHex)(e.slice(0,20)),selector:(0,s.bytesToHex)(e.slice(20,24))})}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/function.js"}],[1698,{"./address":1692,"./array":1693,"./bool":1694,"./bytes":1695,"./fixed-bytes":1696,"./function":1697,"./number":1699,"./parser":1700,"./string":1701,"./tuple":1702},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./address"),r),s(e("./array"),r),s(e("./bool"),r),s(e("./bytes"),r),s(e("./fixed-bytes"),r),s(e("./function"),r),s(e("./number"),r),s(e("./parser"),r),s(e("./string"),r),s(e("./tuple"),r)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/index.js"}],[1699,{"../errors":1688,"../utils":1706,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.number=r.getBigInt=r.assertNumberLength=r.getLength=r.isSigned=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils"),o=/^u?int(?<length>[0-9]*)?$/u;r.isSigned=e=>!e.startsWith("u");r.getLength=e=>{if("int"===e||"uint"===e)return 256;const t=e.match(o);(0,n.assert)(t?.groups?.length,new s.ParserError(`Invalid number type. Expected a number type, but received "${e}".`));const r=parseInt(t.groups.length,10);return(0,n.assert)(r>=8&&r<=256,new s.ParserError(`Invalid number length. Expected a number between 8 and 256, but received "${e}".`)),(0,n.assert)(r%8==0,new s.ParserError(`Invalid number length. Expected a multiple of 8, but received "${e}".`)),r};r.assertNumberLength=(e,t)=>{const a=(0,r.getLength)(t),o=BigInt(2)**BigInt(a-((0,r.isSigned)(t)?1:0))-BigInt(1);(0,r.isSigned)(t)?(0,n.assert)(e>=-(o+BigInt(1))&&e<=o,new s.ParserError(`Number "${e}" is out of range for type "${t}".`)):(0,n.assert)(e<=o,new s.ParserError(`Number "${e}" is out of range for type "${t}".`))};r.getBigInt=e=>{try{return(0,n.createBigInt)(e)}catch{throw new s.ParserError(`Invalid number. Expected a valid number value, but received "${e}".`)}},r.number={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:s,packed:o}){const i=(0,r.getBigInt)(s);if((0,r.assertNumberLength)(i,e),(0,r.isSigned)(e)){if(o){const s=(0,r.getLength)(e)/8;return(0,n.concatBytes)([t,(0,n.signedBigIntToBytes)(i,s)])}return(0,n.concatBytes)([t,(0,a.padStart)((0,n.signedBigIntToBytes)(i,32))])}if(o){const s=(0,r.getLength)(e)/8;return(0,n.concatBytes)([t,(0,a.padStart)((0,n.bigIntToBytes)(i),s)])}return(0,n.concatBytes)([t,(0,a.padStart)((0,n.bigIntToBytes)(i))])},decode({type:e,value:t}){const s=t.subarray(0,32);if((0,r.isSigned)(e)){const t=(0,n.bytesToSignedBigInt)(s);return(0,r.assertNumberLength)(t,e),t}const a=(0,n.bytesToBigInt)(s);return(0,r.assertNumberLength)(a,e),a}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/number.js"}],[1700,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/parser.js"}],[1701,{"./bytes":1695,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.string=void 0;const n=e("@metamask/utils"),s=e("./bytes");r.string={isDynamic:!0,isType:e=>"string"===e,getByteLength:()=>32,encode:({buffer:e,value:t,packed:r,tight:a})=>s.bytes.encode({type:"bytes",buffer:e,value:(0,n.stringToBytes)(t),packed:r,tight:a}),decode:e=>(0,n.bytesToString)(s.bytes.decode(e))}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/string.js"}],[1702,{"../errors":1688,"../packer":1691,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.tuple=r.getTupleElements=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../packer"),o=/^\((.+)\)$/u;r.getTupleElements=e=>{(0,n.assert)(e.startsWith("(")&&e.endsWith(")"),new s.ParserError(`Invalid tuple type. Expected tuple type, but received "${e}".`));const t=[];let r="",a=0;for(let n=1;n<e.length-1;n++){const s=e[n];","===s&&0===a?(t.push(r.trim()),r=""):(r+=s,"("===s?a+=1:")"===s&&(a-=1))}return r.trim()&&t.push(r.trim()),t},r.tuple={isDynamic:e=>(0,r.getTupleElements)(e).some((e=>{const t=(0,a.getParser)(e);return(0,a.isDynamicParser)(t,e)})),isType:e=>(e=>o.test(e))(e),getByteLength(e){if((0,a.isDynamicParser)(this,e))return 32;return(0,r.getTupleElements)(e).reduce(((e,t)=>e+(0,a.getParser)(t).getByteLength(t)),0)},encode({type:e,buffer:t,value:n,packed:s,tight:o}){const i=(0,r.getTupleElements)(e);return(0,a.pack)({types:i,values:n,byteArray:t,packed:s,tight:o})},decode({type:e,value:t,skip:n}){const s=(0,r.getTupleElements)(e);return n(this.getByteLength(e)-32),(0,a.unpack)(s,t)}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"}],[1703,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/abi.js"}],[1704,{"./abi":1703},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./abi"),r)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/index.js"}],[1705,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.padEnd=r.padStart=r.set=void 0;const n=e("@metamask/utils");r.set=(e,t,r)=>(0,n.concatBytes)([e.subarray(0,r),t,e.subarray(r+t.length)]);r.padStart=(e,t=32)=>{const r=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,n.concatBytes)([r,e])};r.padEnd=(e,t=32)=>{const r=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,n.concatBytes)([e,r])}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/buffer.js"}],[1706,{"./buffer":1705},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./buffer"),r)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js"}],[1707,{"./utils":1712,"@scure/base":1713,buffer:4108,tweetnacl:5708},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return s(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.getEncryptionPublicKey=r.decryptSafely=r.decrypt=r.encryptSafely=r.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),c=e("./utils");function l({publicKey:e,data:t,version:r}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(r))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===r){if("string"!=typeof t)throw new Error("Message data must be given as a string");const r=i.box.keyPair();let n;try{n=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const s=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),c=i.box(s,a,n,r.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(r.publicKey),ciphertext:o.base64.encode(c)}}throw new Error("Encryption type/version not supported")}function u({encryptedData:e,privateKey:r}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(r))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const n=t.from(r,"hex"),s=i.box.keyPair.fromSecretKey(n).secretKey,a=o.base64.decode(e.nonce),c=o.base64.decode(e.ciphertext),l=o.base64.decode(e.ephemPublicKey),u=i.box.open(c,a,l,s);try{if(!u)throw new Error;const e=o.utf8.encode(u);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}r.encrypt=l,r.encryptSafely=function({publicKey:e,data:r,version:n}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(r))throw new Error("Missing data parameter");if((0,c.isNullish)(n))throw new Error("Missing version parameter");if("object"==typeof r&&r&&"toJSON"in r)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const s={data:r,padding:""},a=t.byteLength(JSON.stringify(s),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),s.padding="0".repeat(o),l({publicKey:e,data:JSON.stringify(s),version:n})},r.decrypt=u,r.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(u({encryptedData:e,privateKey:t})).data},r.getEncryptionPublicKey=function(e){const r=t.from(e,"hex"),n=i.box.keyPair.fromSecretKey(r).publicKey;return o.base64.encode(n)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/encryption.js"}],[1708,{"./encryption":1707,"./personal-sign":1709,"./sign-eip7702-authorization":1710,"./sign-typed-data":1711,"./utils":1712},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.concatSig=void 0,s(e("./personal-sign"),r),s(e("./sign-typed-data"),r),s(e("./encryption"),r),s(e("./sign-eip7702-authorization"),r);var a=e("./utils");Object.defineProperty(r,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(r,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/index.js"}],[1709,{"./utils":1712,"@ethereumjs/util":1679},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.extractPublicKey=r.recoverPersonalSignature=r.personalSign=void 0;const n=e("@ethereumjs/util"),s=e("./utils");function a(e,t){const r=(0,n.hashPersonalMessage)((0,s.legacyToBuffer)(e));return(0,s.recoverPublicKey)(r,t)}r.personalSign=function({privateKey:e,data:t}){if((0,s.isNullish)(t))throw new Error("Missing data parameter");if((0,s.isNullish)(e))throw new Error("Missing privateKey parameter");const r=(0,s.legacyToBuffer)(t),a=(0,n.hashPersonalMessage)(r),o=(0,n.ecsign)(a,e);return(0,s.concatSig)((0,n.toBuffer)(o.v),o.r,o.s)},r.recoverPersonalSignature=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");const r=a(e,t),o=(0,n.publicToAddress)(r);return(0,n.bufferToHex)(o)},r.extractPublicKey=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],[1710,{"./utils":1712,"@ethereumjs/rlp":497,"@ethereumjs/util":1679,"@metamask/utils":2976,buffer:4108,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.hashEIP7702Authorization=r.recoverEIP7702Authorization=r.signEIP7702Authorization=void 0;const n=e("@ethereumjs/rlp"),s=e("@ethereumjs/util"),a=e("@metamask/utils"),o=e("ethereum-cryptography/keccak"),i=e("./utils");function c(e){l(e);const r=(0,n.encode)(e),s=t.concat([t.from("05","hex"),r]);return t.from((0,o.keccak256)(s))}function l(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,r,n]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(r))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(n))throw new Error("Missing nonce parameter")}r.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(l(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const r=c(t),{r:n,s:a,v:o}=(0,s.ecsign)(r,e),u=(0,s.toBuffer)(o);return(0,i.concatSig)(u,n,a)},r.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(l(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const r=c(t),n=(0,i.recoverPublicKey)(r,e),o=(0,s.publicToAddress)(n);return(0,a.bytesToHex)(o)},r.hashEIP7702Authorization=c}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],[1711,{"./utils":1712,"@ethereumjs/util":1679,"@metamask/abi-utils":1689,"@metamask/abi-utils/dist/parsers":1698,"@metamask/abi-utils/dist/utils":1706,"@metamask/utils":2976,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.recoverTypedSignature=r.signTypedData=r.typedSignatureHash=r.TypedDataUtils=r.TYPED_MESSAGE_SCHEMA=r.SignTypedDataVersion=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),c=e("ethereum-cryptography/keccak"),l=e("./utils");var u;function d(e,t){if(!Object.keys(u).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function f(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const r=BigInt(t),n=(0,a.getLength)(e),s=BigInt(2)**BigInt(n)-BigInt(1);return(0,i.assert)(r>=-s&&r<=s,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),r}function m(e){let t=BigInt(0);for(let r=0;r<e.length;r++){const n=BigInt(e.charCodeAt(r)-48);t*=BigInt(10),t+=n>=49?n-BigInt(49)+BigInt(10):n>=17?n-BigInt(17)+BigInt(10):n}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,r,a,l){if(d(l,[u.V3,u.V4]),e[r]!==undefined)return["bytes32",l===u.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,n.arrToBufArr)((0,c.keccak256)(p(r,a,e,l)))];if("function"===r)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${r}`);if("address"===r){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",m(a).subarray(0,20)]}if("bool"===r)return["bool",Boolean(a)];if("bytes"===r)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.startsWith("bytes")&&"bytes"!==r&&!r.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(r.startsWith("int")&&!r.includes("[")){const e=f(r,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===r)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.endsWith("]")){if(l===u.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=r.slice(0,r.lastIndexOf("[")),i=a.map((r=>h(e,t,o,r,l)));return["bytes32",(0,n.arrToBufArr)((0,c.keccak256)((0,s.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[r,a]}function p(e,t,r,a){d(a,[u.V3,u.V4]);const o=["bytes32"],i=[E(e,r)];for(const n of r[e]){if(a===u.V3&&t[n.name]===undefined)continue;const[e,s]=h(r,n.name,n.type,t[n.name],a);o.push(e),i.push(s)}return(0,n.arrToBufArr)((0,s.encode)(o,i))}function g(e,t){let r="";const n=b(e,t);n.delete(e);const s=[e,...Array.from(n).sort()];for(const e of s){if(!t[e])throw new Error(`No type definition specified: ${e}`);r+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return r}function b(e,t,r=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const n=e.match(/^\w*/u);if([e]=n,r.has(e)||t[e]===undefined)return r;r.add(e);for(const n of t[e])b(n.type,t,r);return r}function y(e,t,r,s){d(s,[u.V3,u.V4]);const a=p(e,t,r,s),o=(0,c.keccak256)(a);return(0,n.arrToBufArr)(o)}function E(e,t){const r=(0,i.stringToBytes)(g(e,t));return(0,n.arrToBufArr)((0,c.keccak256)(r))}function w(e){const t={};for(const n in r.TYPED_MESSAGE_SCHEMA.properties)e[n]&&(t[n]=e[n]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function k(e,t){d(t,[u.V3,u.V4]);const r=w(e),{domain:n}=r;return y("EIP712Domain",n,{EIP712Domain:r.types.EIP712Domain},t)}function v(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[r]=(0,a.getArrayType)(e);return t.map((e=>v(r,e)))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const r=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,r);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,r);if(t instanceof Uint8Array)return t.subarray(0,r)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const r=(0,a.getLength)(e);return BigInt.asIntN(r,BigInt(t))}return t}function x(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const r=f(e,t);if(r>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(r),32);const n=(0,a.getLength)(e),s=BigInt.asIntN(n,r);return(0,i.signedBigIntToBytes)(s,32)}return t}))}function A(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const r=e.map((({name:e,type:t,value:r})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(n=r,n.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var n;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[n,s]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=s?s:""}]`,value:x(n,r)}}return{name:e,type:t,value:v(t,r)}})),u=r.map((e=>"bytes"!==e.type?e.value:(0,l.legacyToBuffer)(e.value))),d=r.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),f=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,n.arrToBufArr)((0,c.keccak256)((0,s.encodePacked)(["bytes32","bytes32"],[(0,c.keccak256)((0,s.encodePacked)(["string[]"],[f],!0)),(0,c.keccak256)((0,s.encodePacked)(d,u,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(u=r.SignTypedDataVersion||(r.SignTypedDataVersion={})),r.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},r.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:b,hashStruct:y,hashType:E,sanitizeData:w,eip712Hash:function(e,t){d(t,[u.V3,u.V4]);const r=w(e),s=[(0,i.hexToBytes)("1901")];return s.push(k(e,t)),"EIP712Domain"!==r.primaryType&&s.push(y(r.primaryType,r.message,r.types,t)),(0,n.arrToBufArr)((0,c.keccak256)((0,i.concatBytes)(s)))},eip712DomainHash:k},r.typedSignatureHash=function(e){const t=A(e);return(0,i.bytesToHex)(t)},r.signTypedData=function({privateKey:e,data:t,version:s}){if(d(s),(0,l.isNullish)(t))throw new Error("Missing data parameter");if((0,l.isNullish)(e))throw new Error("Missing private key parameter");const a=s===u.V1?A(t):r.TypedDataUtils.eip712Hash(t,s),o=(0,n.ecsign)(a,e);return(0,l.concatSig)((0,n.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},r.recoverTypedSignature=function({data:e,signature:t,version:s}){if(d(s),(0,l.isNullish)(e))throw new Error("Missing data parameter");if((0,l.isNullish)(t))throw new Error("Missing signature parameter");const a=s===u.V1?A(e):r.TypedDataUtils.eip712Hash(e,s),o=(0,l.recoverPublicKey)(a,t),c=(0,n.publicToAddress)(o);return(0,i.bytesToHex)(c)}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],[1712,{"@ethereumjs/util":1679,"@metamask/utils":2976,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.recoverPublicKey=r.concatSig=r.legacyToBuffer=r.isNullish=r.padWithZeroes=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}r.padWithZeroes=a,r.isNullish=o,r.legacyToBuffer=function(e){return"string"!=typeof e||(0,n.isHexString)(e)?(0,n.toBuffer)(e):t.from(e)},r.concatSig=function(e,t,r){const o=(0,n.fromSigned)(t),i=(0,n.fromSigned)(r),c=(0,n.bufferToInt)(e),l=a((0,n.toUnsigned)(o).toString("hex"),64),u=a((0,n.toUnsigned)(i).toString("hex"),64),d=(0,s.remove0x)((0,s.numberToHex)(c));return(0,s.add0x)(l.concat(u,d))},r.recoverPublicKey=function(e,t){const r=(0,n.fromRpcSig)(t);return(0,n.ecrecover)(e,r.v,r.r,r.s)},r.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,s.numberToBytes)(e);e=(0,s.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,s.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js"}],[1713,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function s(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,r=(e,t)=>r=>e(t(r));return{encode:e.map((e=>e.encode)).reduceRight(r,t),decode:e.map((e=>e.decode)).reduce(r,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(n(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const r=e.indexOf(t);if(-1===r)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return r}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(n(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;r.length*e%8;)r.push(t);return r},decode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let n=r.length;if(n*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;n>0&&r[n-1]===t;n--)if(!((n-1)*e%8))throw new Error("Invalid padding: string has too much padding");return r.slice(0,n)}}}function l(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function u(e,t,r){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(r<2)throw new Error(`convertRadix: wrong to=${r}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let s=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(n(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,n=!0;for(let a=s;a<o.length;a++){const i=o[a],c=t*e+i;if(!Number.isSafeInteger(c)||t*e/t!==e||c-i!=t*e)throw new Error("convertRadix: carry overflow");e=c%r;const l=Math.floor(c/r);if(o[a]=l,!Number.isSafeInteger(l)||l*r+e!==c)throw new Error("convertRadix: carry overflow");n&&(l?n=!1:s=a)}if(a.push(e),n)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=r.stringToBytes=r.str=r.bytesToString=r.hex=r.utf8=r.bech32m=r.bech32=r.base58check=r.createBase58check=r.base58xmr=r.base58xrp=r.base58flickr=r.base58=r.base64urlnopad=r.base64url=r.base64nopad=r.base64=r.base32crockford=r.base32hexnopad=r.base32hex=r.base32nopad=r.base32=r.base16=r.utils=void 0,r.assertNumber=n;const d=(e,t)=>t?d(t,e%t):e,f=(e,t)=>e+(t-d(e,t));function m(e,t,r,s){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(r<=0||r>32)throw new Error(`convertRadix2: wrong to=${r}`);if(f(t,r)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${r} carryBits=${f(t,r)}`);let a=0,o=0;const i=2**r-1,c=[];for(const s of e){if(n(s),s>=2**t)throw new Error(`convertRadix2: invalid data word=${s} from=${t}`);if(a=a<<t|s,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=r;o-=r)c.push((a>>o-r&i)>>>0);a&=2**o-1}if(a=a<<r-o&i,!s&&o>=t)throw new Error("Excess padding");if(!s&&a)throw new Error(`Non-zero padding: ${a}`);return s&&o>0&&c.push(a>>>0),c}function h(e){return n(e),{encode:t=>{if(!s(t))throw new Error("radix.encode input should be Uint8Array");return u(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(u(t,e,256))}}}function p(e,t=!1){if(n(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(f(8,e)>32||f(e,8)>32)throw new Error("radix2: carry overflow");return{encode:r=>{if(!s(r))throw new Error("radix2.encode input should be Uint8Array");return m(Array.from(r),8,e,!t)},decode:r=>{if(!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(m(r,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function b(e,t){if(n(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(r){if(!s(r))throw new Error("checksum.encode: input should be Uint8Array");const n=t(r).slice(0,e),a=new Uint8Array(r.length+e);return a.set(r),a.set(n,r.length),a},decode(r){if(!s(r))throw new Error("checksum.decode: input should be Uint8Array");const n=r.slice(0,-e),a=t(n).slice(0,e),o=r.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return n}}}r.utils={alphabet:o,chain:a,checksum:b,convertRadix:u,convertRadix2:m,radix:h,radix2:p,join:i,padding:c},r.base16=a(p(4),o("0123456789ABCDEF"),i("")),r.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),i("")),r.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),r.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),i("")),r.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),r.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),l((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),r.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),i("")),r.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),r.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),i("")),r.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const y=e=>a(h(58),o(e),i(""));r.base58=y("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),r.base58flickr=y("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),r.base58xrp=y("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const E=[0,2,3,5,6,7,9,10,11];r.base58xmr={encode(e){let t="";for(let n=0;n<e.length;n+=8){const s=e.subarray(n,n+8);t+=r.base58.encode(s).padStart(E[s.length],"1")}return t},decode(e){let t=[];for(let n=0;n<e.length;n+=11){const s=e.slice(n,n+11),a=E.indexOf(s.length),o=r.base58.decode(s);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};r.createBase58check=e=>a(b(4,(t=>e(e(t)))),r.base58),r.base58check=r.createBase58check;const w=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),k=[996825010,642813549,513874426,1027748829,705979059];function v(e){const t=e>>25;let r=(33554431&e)<<5;for(let e=0;e<k.length;e++)1==(t>>e&1)&&(r^=k[e]);return r}function x(e,t,r=1){const n=e.length;let s=1;for(let t=0;t<n;t++){const r=e.charCodeAt(t);if(r<33||r>126)throw new Error(`Invalid prefix (${e})`);s=v(s)^r>>5}s=v(s);for(let t=0;t<n;t++)s=v(s)^31&e.charCodeAt(t);for(let e of t)s=v(s)^e;for(let e=0;e<6;e++)s=v(s);return s^=r,w.encode(m([s%2**30],30,5,!1))}function A(e){const t="bech32"===e?1:734539939,r=p(5),n=r.decode,s=r.encode,a=g(n);function o(e,r,n=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(r instanceof Uint8Array&&(r=Array.from(r)),!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof r);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const s=e.length+7+r.length;if(!1!==n&&s>n)throw new TypeError(`Length ${s} exceeds limit ${n}`);const a=e.toLowerCase(),o=x(a,r,t);return`${a}1${w.encode(r)}${o}`}function i(e,r=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==r&&e.length>r)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${r})`);const n=e.toLowerCase();if(e!==n&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const s=n.lastIndexOf("1");if(0===s||-1===s)throw new Error('Letter "1" must be present between prefix and data only');const a=n.slice(0,s),o=n.slice(s+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=w.decode(o).slice(0,-6),c=x(a,i,t);if(!o.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,s(t))},decodeToBytes:function(e){const{prefix:t,words:r}=i(e,!1);return{prefix:t,words:r,bytes:n(r)}},decodeUnsafe:g(i),fromWords:n,fromWordsUnsafe:a,toWords:s}}r.bech32=A("bech32"),r.bech32m=A("bech32m"),r.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},r.hex=a(p(4),o("0123456789abcdef"),i(""),l((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const T={utf8:r.utf8,hex:r.hex,base16:r.base16,base32:r.base32,base64:r.base64,base64url:r.base64url,base58:r.base58,base58xmr:r.base58xmr},B="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";r.bytesToString=(e,t)=>{if("string"!=typeof e||!T.hasOwnProperty(e))throw new TypeError(B);if(!s(t))throw new TypeError("bytesToString() expects Uint8Array");return T[e].encode(t)},r.str=r.bytesToString;r.stringToBytes=(e,t)=>{if(!T.hasOwnProperty(e))throw new TypeError(B);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return T[e].decode(t)},r.bytes=r.stringToBytes}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@scure/base/lib/index.js"}],[1714,{"./provider-from-engine.cjs":1715,"./provider-from-middleware.cjs":1716,"./safe-event-emitter-provider.cjs":1717},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.SafeEventEmitterProvider=void 0,s(e("./provider-from-engine.cjs"),r),s(e("./provider-from-middleware.cjs"),r);var a=e("./safe-event-emitter-provider.cjs");Object.defineProperty(r,"SafeEventEmitterProvider",{enumerable:!0,get:function(){return a.SafeEventEmitterProvider}})}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],[1715,{"./safe-event-emitter-provider.cjs":1717},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.providerFromEngine=void 0;const n=e("./safe-event-emitter-provider.cjs");r.providerFromEngine=function(e){return new n.SafeEventEmitterProvider({engine:e})}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs"}],[1716,{"./provider-from-engine.cjs":1715,"@metamask/json-rpc-engine":2022},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.providerFromMiddleware=void 0;const n=e("@metamask/json-rpc-engine"),s=e("./provider-from-engine.cjs");r.providerFromMiddleware=function(e){const t=new n.JsonRpcEngine;return t.push(e),(0,s.providerFromEngine)(t)}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],[1717,{"@metamask/rpc-errors":2527,"@metamask/safe-event-emitter":2529,uuid:5754},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},a=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.SafeEventEmitterProvider=r.convertEip1193RequestToJsonRpcRequest=void 0;const i=e("@metamask/rpc-errors"),c=o(e("@metamask/safe-event-emitter")),l=e("uuid");function u(e){const{id:t=(0,l.v4)(),jsonrpc:r="2.0",method:n,params:s}=e;return s?{id:t,jsonrpc:r,method:n,params:s}:{id:t,jsonrpc:r,method:n}}r.convertEip1193RequestToJsonRpcRequest=u;class d extends c.default{constructor({engine:e}){super(),n.set(this,void 0),this.sendAsync=(e,t)=>{const r=u(e);a(this,n,"f").handle(r,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const r=u(e);a(this,n,"f").handle(r,t)},s(this,n,e,"f"),e.on&&e.on("notification",(e=>{this.emit("data",null,e)}))}async request(e){const t=u(e),r=await a(this,n,"f").handle(t);if("result"in r)return r.result;const s=new i.JsonRpcError(r.error.code,r.error.message,r.error.data);throw"stack"in r.error&&(s.stack=r.error.stack),s}}r.SafeEventEmitterProvider=d,n=new WeakMap}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"}],[1770,{"json-rpc-random-id":4729,xtend:5793},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){const n=e("json-rpc-random-id")(),s=e("xtend");function a(e){this.currentProvider=e}function o(e){return function(...t){const r=t.pop();this.sendAsync({method:e,params:t},r)}}function i(e,t){return function(...r){const n=r.pop();r.length<e&&r.push("latest"),this.sendAsync({method:t,params:r},n)}}t.exports=a,a.prototype.getBalance=i(2,"eth_getBalance"),a.prototype.getCode=i(2,"eth_getCode"),a.prototype.getTransactionCount=i(2,"eth_getTransactionCount"),a.prototype.getStorageAt=i(3,"eth_getStorageAt"),a.prototype.call=i(2,"eth_call"),a.prototype.protocolVersion=o("eth_protocolVersion"),a.prototype.syncing=o("eth_syncing"),a.prototype.coinbase=o("eth_coinbase"),a.prototype.mining=o("eth_mining"),a.prototype.hashrate=o("eth_hashrate"),a.prototype.gasPrice=o("eth_gasPrice"),a.prototype.accounts=o("eth_accounts"),a.prototype.blockNumber=o("eth_blockNumber"),a.prototype.getBlockTransactionCountByHash=o("eth_getBlockTransactionCountByHash"),a.prototype.getBlockTransactionCountByNumber=o("eth_getBlockTransactionCountByNumber"),a.prototype.getUncleCountByBlockHash=o("eth_getUncleCountByBlockHash"),a.prototype.getUncleCountByBlockNumber=o("eth_getUncleCountByBlockNumber"),a.prototype.sign=o("eth_sign"),a.prototype.sendTransaction=o("eth_sendTransaction"),a.prototype.sendRawTransaction=o("eth_sendRawTransaction"),a.prototype.estimateGas=o("eth_estimateGas"),a.prototype.getBlockByHash=o("eth_getBlockByHash"),a.prototype.getBlockByNumber=o("eth_getBlockByNumber"),a.prototype.getTransactionByHash=o("eth_getTransactionByHash"),a.prototype.getTransactionByBlockHashAndIndex=o("eth_getTransactionByBlockHashAndIndex"),a.prototype.getTransactionByBlockNumberAndIndex=o("eth_getTransactionByBlockNumberAndIndex"),a.prototype.getTransactionReceipt=o("eth_getTransactionReceipt"),a.prototype.getUncleByBlockHashAndIndex=o("eth_getUncleByBlockHashAndIndex"),a.prototype.getUncleByBlockNumberAndIndex=o("eth_getUncleByBlockNumberAndIndex"),a.prototype.getCompilers=o("eth_getCompilers"),a.prototype.compileLLL=o("eth_compileLLL"),a.prototype.compileSolidity=o("eth_compileSolidity"),a.prototype.compileSerpent=o("eth_compileSerpent"),a.prototype.newFilter=o("eth_newFilter"),a.prototype.newBlockFilter=o("eth_newBlockFilter"),a.prototype.newPendingTransactionFilter=o("eth_newPendingTransactionFilter"),a.prototype.uninstallFilter=o("eth_uninstallFilter"),a.prototype.getFilterChanges=o("eth_getFilterChanges"),a.prototype.getFilterLogs=o("eth_getFilterLogs"),a.prototype.getLogs=o("eth_getLogs"),a.prototype.getWork=o("eth_getWork"),a.prototype.submitWork=o("eth_submitWork"),a.prototype.submitHashrate=o("eth_submitHashrate"),a.prototype.sendAsync=function(e,t){var r;this.currentProvider.sendAsync((r=e,s({id:n(),jsonrpc:"2.0",params:[]},r)),(function(e,r){let n=e;return!e&&r.error&&(n=new Error(`EthQuery - RPC Error - ${r.error.message}`)),n?t(n):t(null,r.result)}))}}}},{package:"@metamask/controller-utils>@metamask/eth-query",file:"node_modules/@metamask/eth-query/index.js"}],[1771,{"./utils":1775,"@scure/base":1813,buffer:4108,tweetnacl:5708},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return s(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.getEncryptionPublicKey=r.decryptSafely=r.decrypt=r.encryptSafely=r.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),c=e("./utils");function l({publicKey:e,data:t,version:r}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(r))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===r){if("string"!=typeof t)throw new Error("Message data must be given as a string");const r=i.box.keyPair();let n;try{n=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const s=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),c=i.box(s,a,n,r.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(r.publicKey),ciphertext:o.base64.encode(c)}}throw new Error("Encryption type/version not supported")}function u({encryptedData:e,privateKey:r}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(r))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const n=t.from(r,"hex"),s=i.box.keyPair.fromSecretKey(n).secretKey,a=o.base64.decode(e.nonce),c=o.base64.decode(e.ciphertext),l=o.base64.decode(e.ephemPublicKey),u=i.box.open(c,a,l,s);try{if(!u)throw new Error;const e=o.utf8.encode(u);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}r.encrypt=l,r.encryptSafely=function({publicKey:e,data:r,version:n}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(r))throw new Error("Missing data parameter");if((0,c.isNullish)(n))throw new Error("Missing version parameter");if("object"==typeof r&&r&&"toJSON"in r)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const s={data:r,padding:""},a=t.byteLength(JSON.stringify(s),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),s.padding="0".repeat(o),l({publicKey:e,data:JSON.stringify(s),version:n})},r.decrypt=u,r.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(u({encryptedData:e,privateKey:t})).data},r.getEncryptionPublicKey=function(e){const r=t.from(e,"hex"),n=i.box.keyPair.fromSecretKey(r).publicKey;return o.base64.encode(n)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/encryption.js"}],[1772,{"./encryption":1771,"./personal-sign":1773,"./sign-typed-data":1774,"./utils":1775},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.concatSig=void 0,s(e("./personal-sign"),r),s(e("./sign-typed-data"),r),s(e("./encryption"),r);var a=e("./utils");Object.defineProperty(r,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(r,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/index.js"}],[1773,{"./utils":1775,"@ethereumjs/util":1783},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.extractPublicKey=r.recoverPersonalSignature=r.personalSign=void 0;const n=e("@ethereumjs/util"),s=e("./utils");function a(e,t){const r=(0,n.hashPersonalMessage)((0,s.legacyToBuffer)(e));return(0,s.recoverPublicKey)(r,t)}r.personalSign=function({privateKey:e,data:t}){if((0,s.isNullish)(t))throw new Error("Missing data parameter");if((0,s.isNullish)(e))throw new Error("Missing privateKey parameter");const r=(0,s.legacyToBuffer)(t),a=(0,n.hashPersonalMessage)(r),o=(0,n.ecsign)(a,e);return(0,s.concatSig)((0,n.toBuffer)(o.v),o.r,o.s)},r.recoverPersonalSignature=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");const r=a(e,t),o=(0,n.publicToAddress)(r);return(0,n.bufferToHex)(o)},r.extractPublicKey=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],[1774,{"./utils":1775,"@ethereumjs/util":1783,"@metamask/abi-utils":1318,"@metamask/abi-utils/dist/parsers":1327,"@metamask/abi-utils/dist/utils":1335,"@metamask/utils":1801,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.recoverTypedSignature=r.signTypedData=r.typedSignatureHash=r.TypedDataUtils=r.TYPED_MESSAGE_SCHEMA=r.SignTypedDataVersion=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),c=e("ethereum-cryptography/keccak"),l=e("./utils");var u;function d(e,t){if(!Object.keys(u).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function f(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const r=BigInt(t),n=(0,a.getLength)(e),s=BigInt(2)**BigInt(n)-BigInt(1);return(0,i.assert)(r>=-s&&r<=s,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),r}function m(e){let t=BigInt(0);for(let r=0;r<e.length;r++){const n=BigInt(e.charCodeAt(r)-48);t*=BigInt(10),t+=n>=49?n-BigInt(49)+BigInt(10):n>=17?n-BigInt(17)+BigInt(10):n}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,r,a,l){if(d(l,[u.V3,u.V4]),e[r]!==undefined)return["bytes32",l===u.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,n.arrToBufArr)((0,c.keccak256)(p(r,a,e,l)))];if("function"===r)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${r}`);if("address"===r){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",m(a).subarray(0,20)]}if("bool"===r)return["bool",Boolean(a)];if("bytes"===r)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.startsWith("bytes")&&"bytes"!==r&&!r.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(r.startsWith("int")&&!r.includes("[")){const e=f(r,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===r)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.endsWith("]")){if(l===u.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=r.slice(0,r.lastIndexOf("[")),i=a.map((r=>h(e,t,o,r,l)));return["bytes32",(0,n.arrToBufArr)((0,c.keccak256)((0,s.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[r,a]}function p(e,t,r,a){d(a,[u.V3,u.V4]);const o=["bytes32"],i=[E(e,r)];for(const n of r[e]){if(a===u.V3&&t[n.name]===undefined)continue;const[e,s]=h(r,n.name,n.type,t[n.name],a);o.push(e),i.push(s)}return(0,n.arrToBufArr)((0,s.encode)(o,i))}function g(e,t){let r="";const n=b(e,t);n.delete(e);const s=[e,...Array.from(n).sort()];for(const e of s){if(!t[e])throw new Error(`No type definition specified: ${e}`);r+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return r}function b(e,t,r=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const n=e.match(/^\w*/u);if([e]=n,r.has(e)||t[e]===undefined)return r;r.add(e);for(const n of t[e])b(n.type,t,r);return r}function y(e,t,r,s){d(s,[u.V3,u.V4]);const a=p(e,t,r,s),o=(0,c.keccak256)(a);return(0,n.arrToBufArr)(o)}function E(e,t){const r=(0,i.stringToBytes)(g(e,t));return(0,n.arrToBufArr)((0,c.keccak256)(r))}function w(e){const t={};for(const n in r.TYPED_MESSAGE_SCHEMA.properties)e[n]&&(t[n]=e[n]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function k(e,t){d(t,[u.V3,u.V4]);const r=w(e),{domain:n}=r;return y("EIP712Domain",n,{EIP712Domain:r.types.EIP712Domain},t)}function v(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[r]=(0,a.getArrayType)(e);return t.map((e=>v(r,e)))}if("address"===e){if("number"==typeof t)return(0,o.padStart)((0,i.numberToBytes)(t),20);if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const r=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,r);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,r);if(t instanceof Uint8Array)return t.subarray(0,r)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const r=(0,a.getLength)(e);return BigInt.asIntN(r,BigInt(t))}return t}function x(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const r=f(e,t);if(r>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(r),32);const n=(0,a.getLength)(e),s=BigInt.asIntN(n,r);return(0,i.signedBigIntToBytes)(s,32)}return t}))}function A(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const r=e.map((({name:e,type:t,value:r})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(n=r,n.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var n;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[n,s]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=s?s:""}]`,value:x(n,r)}}return{name:e,type:t,value:v(t,r)}})),u=r.map((e=>"bytes"!==e.type?e.value:(0,l.legacyToBuffer)(e.value))),d=r.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),f=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,n.arrToBufArr)((0,c.keccak256)((0,s.encodePacked)(["bytes32","bytes32"],[(0,c.keccak256)((0,s.encodePacked)(["string[]"],[f],!0)),(0,c.keccak256)((0,s.encodePacked)(d,u,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(u=r.SignTypedDataVersion||(r.SignTypedDataVersion={})),r.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},r.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:b,hashStruct:y,hashType:E,sanitizeData:w,eip712Hash:function(e,t){d(t,[u.V3,u.V4]);const r=w(e),s=[(0,i.hexToBytes)("1901")];return s.push(k(e,t)),"EIP712Domain"!==r.primaryType&&s.push(y(r.primaryType,r.message,r.types,t)),(0,n.arrToBufArr)((0,c.keccak256)((0,i.concatBytes)(s)))},eip712DomainHash:k},r.typedSignatureHash=function(e){const t=A(e);return(0,i.bytesToHex)(t)},r.signTypedData=function({privateKey:e,data:t,version:s}){if(d(s),(0,l.isNullish)(t))throw new Error("Missing data parameter");if((0,l.isNullish)(e))throw new Error("Missing private key parameter");const a=s===u.V1?A(t):r.TypedDataUtils.eip712Hash(t,s),o=(0,n.ecsign)(a,e);return(0,l.concatSig)((0,n.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},r.recoverTypedSignature=function({data:e,signature:t,version:s}){if(d(s),(0,l.isNullish)(e))throw new Error("Missing data parameter");if((0,l.isNullish)(t))throw new Error("Missing signature parameter");const a=s===u.V1?A(e):r.TypedDataUtils.eip712Hash(e,s),o=(0,l.recoverPublicKey)(a,t),c=(0,n.publicToAddress)(o);return(0,i.bytesToHex)(c)}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],[1775,{"@ethereumjs/util":1783,"@metamask/utils":1801,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.recoverPublicKey=r.concatSig=r.legacyToBuffer=r.isNullish=r.padWithZeroes=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}r.padWithZeroes=a,r.isNullish=o,r.legacyToBuffer=function(e){return"string"!=typeof e||(0,n.isHexString)(e)?(0,n.toBuffer)(e):t.from(e)},r.concatSig=function(e,t,r){const o=(0,n.fromSigned)(t),i=(0,n.fromSigned)(r),c=(0,n.bufferToInt)(e),l=a((0,n.toUnsigned)(o).toString("hex"),64),u=a((0,n.toUnsigned)(i).toString("hex"),64),d=(0,s.remove0x)((0,s.numberToHex)(c));return(0,s.add0x)(l.concat(u,d))},r.recoverPublicKey=function(e,t){const r=(0,n.fromRpcSig)(t);return(0,n.ecrecover)(e,r.v,r.r,r.s)},r.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,s.numberToBytes)(e);e=(0,s.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,s.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/utils.js"}],[1776,{"./bytes":1779,"./constants":1780,"./helpers":1782,"./internal":1784,"@ethereumjs/rlp":497,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358,"ethereum-cryptography/utils":4360},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.accountBodyToRLP=r.accountBodyToSlim=r.accountBodyFromSlim=r.isZeroAddress=r.zeroAddress=r.importPublic=r.privateToAddress=r.privateToPublic=r.publicToAddress=r.pubToAddress=r.isValidPublic=r.isValidPrivate=r.generateAddress2=r.generateAddress=r.isValidChecksumAddress=r.toChecksumAddress=r.isValidAddress=r.Account=void 0;const n=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),l=e("./helpers"),u=e("./internal"),d=BigInt(0);class f{constructor(e=d,t=d,r=c.KECCAK256_RLP,n=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=r,this.codeHash=n,this._validate()}static fromAccountData(e){const{nonce:t,balance:r,storageRoot:n,codeHash:s}=e;return new f(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,r!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(r)):undefined,n!==undefined?(0,i.toBuffer)(n):undefined,s!==undefined?(0,i.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(n.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,r,n,s]=e;return new f((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(r),n,s)}_validate(){if(this.nonce<d)throw new Error("nonce must be greater than zero");if(this.balance<d)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(n.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===d&&this.nonce===d&&this.codeHash.equals(c.KECCAK256_NULL)}}r.Account=f;r.isValidAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};r.toChecksumAddress=function(e,r){(0,l.assertIsHexString)(e);const n=(0,u.stripHexPrefix)(e).toLowerCase();let a="";if(r!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(r)).toString()+"0x"}const c=t.from(a+n,"utf8"),d=(0,o.bytesToHex)((0,s.keccak256)(c));let f="0x";for(let e=0;e<n.length;e++)parseInt(d[e],16)>=8?f+=n[e].toUpperCase():f+=n[e];return f};r.isValidChecksumAddress=function(e,t){return(0,r.isValidAddress)(e)&&(0,r.toChecksumAddress)(e,t)===e};r.generateAddress=function(e,r){return(0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,i.bufferToBigInt)(r)===BigInt(0)?t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,r])))).slice(-20)};r.generateAddress2=function(e,r,n){if((0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,l.assertIsBuffer)(n),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==r.length)throw new Error("Expected salt to be of length 32");const a=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,r,(0,s.keccak256)(n)]));return(0,i.toBuffer)(a).slice(-20)};r.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};r.isValidPublic=function(e,r=!1){if((0,l.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!r)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};r.pubToAddress=function(e,r=!1){if((0,l.assertIsBuffer)(e),r&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},r.publicToAddress=r.pubToAddress;r.privateToPublic=function(e){return(0,l.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};r.privateToAddress=function(e){return(0,r.publicToAddress)((0,r.privateToPublic)(e))};r.importPublic=function(e){return(0,l.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};r.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function m(e){const[t,r,n,s]=e;return[t,r,0===(0,i.arrToBufArr)(n).length?c.KECCAK256_RLP:n,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}r.isZeroAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return(0,r.zeroAddress)()===e},r.accountBodyFromSlim=m;const h=new Uint8Array(0);r.accountBodyToSlim=function(e){const[t,r,n,s]=e;return[t,r,(0,i.arrToBufArr)(n).equals(c.KECCAK256_RLP)?h:n,(0,i.arrToBufArr)(s).equals(c.KECCAK256_NULL)?h:s]},r.accountBodyToRLP=function(e,t=!0){const r=t?m(e):e;return(0,i.arrToBufArr)(n.RLP.encode(r))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],[1777,{"./account":1776,"./bytes":1779,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Address=void 0;const n=e("./account"),s=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,s.zeros)(20))}static fromString(e){if(!(0,n.isValidAddress)(e))throw new Error("Invalid address");return new a((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const r=(0,n.pubToAddress)(e);return new a(r)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const r=(0,n.privateToAddress)(e);return new a(r)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,n.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,r,s){if(!t.isBuffer(r))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new a((0,n.generateAddress2)(e.buf,r,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),r=BigInt("0xffff");return e>=t&&e<=r}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}r.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],[1778,{events:4440},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AsyncEventEmitter=void 0;const n=e("events");class s extends n.EventEmitter{emit(e,...t){let[r,n]=t;const s=this;let a=s._events[e]??[];return n===undefined&&"function"==typeof r&&(n=r,r=undefined),"newListener"!==e&&"removeListener"!==e||(r={event:r,fn:n},n=undefined),a=Array.isArray(a)?a:[a],async function(e,t,r){let n;for await(const s of t)try{s.length<2?s.call(e,r):await new Promise(((t,n)=>{s.call(e,r,(e=>{e?n(e):t()}))}))}catch(e){n=e}if(n)throw n}(s,a.slice(),r).then(n).catch(n),s.listenerCount(e)>0}once(e,t){const r=this;let n;if("function"!=typeof t)throw new TypeError("listener must be a function");return n=t.length>=2?function(s,a){r.removeListener(e,n),t(s,a)}:function(s){r.removeListener(e,n),t(s,n)},r.on(e,n),r}first(e,t){let r=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(r)||(this._events[e]=r=[r]),r.unshift(t),this}before(e,t,r){return this.beforeOrAfter(e,t,r)}after(e,t,r){return this.beforeOrAfter(e,t,r,"after")}beforeOrAfter(e,t,r,n){let s,a,o=this._events[e]??[];const i="after"===n?1:0;if("function"!=typeof r)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,s=o.length;s--;)if(o[s]===t){a=s+i;break}return o.splice(a,0,r),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}r.AsyncEventEmitter=s}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],[1779,{"./helpers":1782,"./internal":1784,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.intToUnpaddedBuffer=r.bigIntToUnpaddedBuffer=r.bigIntToHex=r.bufArrToArr=r.arrToBufArr=r.validateNoLeadingZeroes=r.baToJSON=r.toUtf8=r.short=r.addHexPrefix=r.toUnsigned=r.fromSigned=r.bufferToInt=r.bigIntToBuffer=r.bufferToBigInt=r.bufferToHex=r.toBuffer=r.unpadHexString=r.unpadArray=r.unpadBuffer=r.setLengthRight=r.setLengthLeft=r.zeros=r.intToBuffer=r.intToHex=void 0;const n=e("./helpers"),s=e("./internal");r.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};r.intToBuffer=function(e){const n=(0,r.intToHex)(e);return t.from((0,s.padToEven)(n.slice(2)),"hex")};r.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,n){const s=(0,r.zeros)(t);return n?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};r.setLengthLeft=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!1)};r.setLengthRight=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};r.unpadBuffer=function(e){return(0,n.assertIsBuffer)(e),o(e)};r.unpadArray=function(e){return(0,n.assertIsArray)(e),o(e)};r.unpadHexString=function(e){return(0,n.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+o(e)};r.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,r.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let r=e.toString(16);return r.length%2&&(r="0"+r),t.from(r,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,r.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,r.toBuffer)("0x"+e.toString(16))}r.bufferToHex=function(e){return"0x"+(e=(0,r.toBuffer)(e)).toString("hex")},r.bufferToBigInt=i,r.bigIntToBuffer=c;r.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};r.fromSigned=function(e){return BigInt.asIntN(256,i(e))};r.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};r.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},r.short=function(e,r=50){const n=t.isBuffer(e)?e.toString("hex"):e;return n.length<=r?n:n.slice(0,r)+"…"};r.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};r.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let n=0;n<e.length;n++)t.push((0,r.baToJSON)(e[n]));return t}};r.validateNoLeadingZeroes=function(e){for(const[t,r]of Object.entries(e))if(r!==undefined&&r.length>0&&0===r[0])throw new Error(`${t} cannot have leading zeroes, received: ${r.toString("hex")}`)},r.arrToBufArr=function e(r){return Array.isArray(r)?r.map((t=>e(t))):t.from(r)},r.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};r.bigIntToHex=e=>"0x"+e.toString(16),r.bigIntToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)(c(e))},r.intToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)((0,r.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],[1780,{buffer:4108,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAX_WITHDRAWALS_PER_PAYLOAD=r.RLP_EMPTY_STRING=r.KECCAK256_RLP=r.KECCAK256_RLP_S=r.KECCAK256_RLP_ARRAY=r.KECCAK256_RLP_ARRAY_S=r.KECCAK256_NULL=r.KECCAK256_NULL_S=r.TWO_POW256=r.SECP256K1_ORDER_DIV_2=r.SECP256K1_ORDER=r.MAX_INTEGER_BIGINT=r.MAX_INTEGER=r.MAX_UINT64=void 0;const n=e("buffer"),s=e("ethereum-cryptography/secp256k1");r.MAX_UINT64=BigInt("0xffffffffffffffff"),r.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),r.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),r.SECP256K1_ORDER=s.secp256k1.CURVE.n,r.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),r.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),r.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",r.KECCAK256_NULL=n.Buffer.from(r.KECCAK256_NULL_S,"hex"),r.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",r.KECCAK256_RLP_ARRAY=n.Buffer.from(r.KECCAK256_RLP_ARRAY_S,"hex"),r.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",r.KECCAK256_RLP=n.Buffer.from(r.KECCAK256_RLP_S,"hex"),r.RLP_EMPTY_STRING=n.Buffer.from([128]),r.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],[1781,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.compactBytesToNibbles=r.bytesToNibbles=r.nibblesToCompactBytes=r.nibblesToBytes=r.hasTerminator=void 0;r.hasTerminator=e=>e.length>0&&16===e[e.length-1];r.nibblesToBytes=(e,t)=>{for(let r=0,n=0;n<e.length;r+=1,n+=2)t[r]=e[n]<<4|e[n+1]};r.nibblesToCompactBytes=e=>{let t=0;(0,r.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const n=new Uint8Array(e.length/2+1);return n[0]=t<<5,1&~e.length||(n[0]|=16,n[0]|=e[0],e=e.subarray(1)),(0,r.nibblesToBytes)(e,n.subarray(1)),n};r.bytesToNibbles=e=>{const t=2*e.length+1,r=new Uint8Array(t);for(let t=0;t<e.length;t++){const n=e[t];r[2*t]=n/16,r[2*t+1]=n%16}return r[t-1]=16,r};r.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,r.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const n=2-(1&t[0]);return t.subarray(n)}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],[1782,{"../../../../../../is-buffer/index.js":4701,"./internal":1784},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.assertIsString=r.assertIsArray=r.assertIsBuffer=r.assertIsHexString=void 0;const n=e("./internal");r.assertIsHexString=function(e){if(!(0,n.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};r.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};r.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};r.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],[1783,{"./account":1776,"./address":1777,"./asyncEventEmitter":1778,"./bytes":1779,"./constants":1780,"./encoding":1781,"./internal":1784,"./lock":1785,"./provider":1786,"./signature":1787,"./types":1788,"./units":1789,"./withdrawal":1790},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.toAscii=r.stripHexPrefix=r.padToEven=r.isHexString=r.isHexPrefixed=r.getKeys=r.getBinarySize=r.fromUtf8=r.fromAscii=r.arrayContainsArray=void 0,s(e("./constants"),r),s(e("./units"),r),s(e("./account"),r),s(e("./address"),r),s(e("./withdrawal"),r),s(e("./signature"),r),s(e("./bytes"),r),s(e("./types"),r),s(e("./encoding"),r),s(e("./asyncEventEmitter"),r);var a=e("./internal");Object.defineProperty(r,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(r,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(r,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(r,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(r,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(r,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(r,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(r,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(r,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(r,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),s(e("./lock"),r),s(e("./provider"),r)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],[1784,{buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(r,"__esModule",{value:!0}),r.isHexString=r.getKeys=r.fromAscii=r.fromUtf8=r.toAscii=r.arrayContainsArray=r.getBinarySize=r.padToEven=r.stripHexPrefix=r.isHexPrefixed=void 0,r.isHexPrefixed=t;function n(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}r.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},r.padToEven=n,r.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},r.arrayContainsArray=function(e,t,r){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===r?"some":"every"]((t=>e.indexOf(t)>=0))},r.toAscii=function(e){let t="",r=0;const n=e.length;for("0x"===e.substring(0,2)&&(r=2);r<n;r+=2){const n=parseInt(e.substr(r,2),16);t+=String.fromCharCode(n)}return t},r.fromUtf8=function(t){return`0x${n(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},r.fromAscii=function(e){let t="";for(let r=0;r<e.length;r++){const n=e.charCodeAt(r).toString(16);t+=n.length<2?`0${n}`:n}return`0x${t}`},r.getKeys=function(e,t,r){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const n=[];for(let s=0;s<e.length;s++){let a=e[s][t];if(!0!==r||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";n.push(a)}return n},r.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],[1785,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Lock=void 0;r.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],[1786,{"micro-ftch":4981},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getProvider=r.fetchFromProvider=void 0;const n=e("micro-ftch");r.fetchFromProvider=async(e,t)=>(await(0,n.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;r.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],[1787,{"./bytes":1779,"./constants":1780,"./helpers":1782,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.hashPersonalMessage=r.isValidSignature=r.fromRpcSig=r.toCompactSig=r.toRpcSig=r.ecrecover=r.ecsign=void 0;const n=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function l(e){return e===BigInt(0)||e===BigInt(1)}r.ecsign=function(e,r,n){const a=s.secp256k1.sign(e,r),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:n===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(n)*BigInt(2)}};r.ecrecover=function(e,r,n,o,i){const u=t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(o,32)],64),d=c(r,i);if(!l(d))throw new Error("Invalid signature v value");const f=s.secp256k1.Signature.fromCompact(u).addRecoveryBit(Number(d)).recoverPublicKey(e);return t.from(f.toRawBytes(!1).slice(1))};r.toRpcSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(n,32),(0,a.toBuffer)(e)]))};r.toCompactSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");let o=n;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(n),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)]))};r.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let r,n,s;if(t.length>=65)r=t.slice(0,32),n=t.slice(32,64),s=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");r=t.slice(0,32),n=t.slice(32,64),s=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),n[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:r,s:n}};r.isValidSignature=function(e,t,r,n=!0,s){if(32!==t.length||32!==r.length)return!1;if(!l(c(e,s)))return!1;const i=(0,a.bufferToBigInt)(t),u=(0,a.bufferToBigInt)(r);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||u===BigInt(0)||u>=o.SECP256K1_ORDER)&&!(n&&u>=o.SECP256K1_ORDER_DIV_2)};r.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const r=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,n.keccak256)(t.concat([r,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],[1788,{"./bytes":1779,"./internal":1784},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.toType=r.TypeOutput=void 0;const n=e("./bytes"),s=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=r.TypeOutput||(r.TypeOutput={})),r.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const r=(0,n.toBuffer)(e);switch(t){case a.Buffer:return r;case a.BigInt:return(0,n.bufferToBigInt)(r);case a.Number:{const e=(0,n.bufferToBigInt)(r);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,n.bufferToHex)(r);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],[1789,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.GWEI_TO_WEI=void 0,r.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],[1790,{"./address":1777,"./bytes":1779,"./types":1788,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Withdrawal=void 0;const n=e("./address"),s=e("./bytes"),a=e("./types");class o{constructor(e,t,r,n){this.index=e,this.validatorIndex=t,this.address=r,this.amount=n}static fromWithdrawalData(e){const{index:t,validatorIndex:r,address:s,amount:i}=e,c=(0,a.toType)(t,a.TypeOutput.BigInt),l=(0,a.toType)(r,a.TypeOutput.BigInt),u=new n.Address((0,a.toType)(s,a.TypeOutput.Buffer)),d=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(c,l,u,d)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,r,n,s]=e;return o.fromWithdrawalData({index:t,validatorIndex:r,address:n,amount:s})}static toBufferArray(e){const{index:r,validatorIndex:s,address:o,amount:i}=e,c=(0,a.toType)(r,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(r,a.TypeOutput.Buffer),l=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer);let u;u=o instanceof n.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[c,l,u,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}r.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],[1791,{"./errors.cjs":1799,"@metamask/superstruct":2872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.assertExhaustive=r.assertStruct=r.assert=r.AssertionError=void 0;const n=e("@metamask/superstruct"),s=e("./errors.cjs");function a(e,t){return r=e,Boolean("string"==typeof r?.prototype?.constructor?.name)?new e({message:t}):e({message:t});var r}class o extends Error{constructor(e){super(e.message),this.code="ERR_ASSERTION"}}r.AssertionError=o,r.assert=function(e,t="Assertion failed.",r=o){if(!e){if(t instanceof Error)throw t;throw a(r,t)}},r.assertStruct=function(e,t,r="Assertion failed",i=o){try{(0,n.assert)(e,t)}catch(e){throw a(i,`${r}: ${function(e){return(0,s.getErrorMessage)(e).replace(/\.$/u,"")}(e)}.`)}},r.assertExhaustive=function(e){throw new Error("Invalid branch reached. Should be detected during compilation.")}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs"}],[1792,{"./assert.cjs":1791,"@metamask/superstruct":2872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.base64=void 0;const n=e("@metamask/superstruct"),s=e("./assert.cjs");r.base64=(e,t={})=>{const r=t.paddingRequired??!1,a=t.characterSet??"base64";let o,i;return"base64"===a?o=String.raw`[A-Za-z0-9+\/]`:((0,s.assert)("base64url"===a),o=String.raw`[-_A-Za-z0-9]`),i=r?new RegExp(`^(?:${o}{4})*(?:${o}{3}=|${o}{2}==)?$`,"u"):new RegExp(`^(?:${o}{4})*(?:${o}{2,3}|${o}{3}=|${o}{2}==)?$`,"u"),(0,n.pattern)(e,i)}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/base64.cjs"}],[1793,{"./assert.cjs":1791,"./hex.cjs":1800,"@scure/base":1812,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.createDataView=r.concatBytes=r.valueToBytes=r.base64ToBytes=r.stringToBytes=r.numberToBytes=r.signedBigIntToBytes=r.bigIntToBytes=r.hexToBytes=r.bytesToBase64=r.bytesToString=r.bytesToNumber=r.bytesToSignedBigInt=r.bytesToBigInt=r.bytesToHex=r.assertIsBytes=r.isBytes=void 0;const n=e("@scure/base"),s=e("./assert.cjs"),a=e("./hex.cjs"),o=48,i=58,c=87;const l=function(){const e=[];return()=>{if(0===e.length)for(let t=0;t<256;t++)e.push(t.toString(16).padStart(2,"0"));return e}}();function u(e){return e instanceof Uint8Array}function d(e){(0,s.assert)(u(e),"Value must be a Uint8Array.")}function f(e){if(d(e),0===e.length)return"0x";const t=l(),r=new Array(e.length);for(let n=0;n<e.length;n++)r[n]=t[e[n]];return(0,a.add0x)(r.join(""))}function m(e){d(e);const t=f(e);return BigInt(t)}function h(e){if("0x"===e?.toLowerCase?.())return new Uint8Array;(0,a.assertIsHexString)(e);const t=(0,a.remove0x)(e).toLowerCase(),r=t.length%2==0?t:`0${t}`,n=new Uint8Array(r.length/2);for(let e=0;e<n.length;e++){const t=r.charCodeAt(2*e),s=r.charCodeAt(2*e+1),a=t-(t<i?o:c),l=s-(s<i?o:c);n[e]=16*a+l}return n}function p(e){(0,s.assert)("bigint"==typeof e,"Value must be a bigint."),(0,s.assert)(e>=BigInt(0),"Value must be a non-negative bigint.");return h(e.toString(16))}function g(e){(0,s.assert)("number"==typeof e,"Value must be a number."),(0,s.assert)(e>=0,"Value must be a non-negative number."),(0,s.assert)(Number.isSafeInteger(e),"Value is not a safe integer. Use `bigIntToBytes` instead.");return h(e.toString(16))}function b(e){return(0,s.assert)("string"==typeof e,"Value must be a string."),(new TextEncoder).encode(e)}function y(e){if("bigint"==typeof e)return p(e);if("number"==typeof e)return g(e);if("string"==typeof e)return e.startsWith("0x")?h(e):b(e);if(u(e))return e;throw new TypeError(`Unsupported value type: "${typeof e}".`)}r.isBytes=u,r.assertIsBytes=d,r.bytesToHex=f,r.bytesToBigInt=m,r.bytesToSignedBigInt=function(e){d(e);let t=BigInt(0);for(const r of e)t=(t<<BigInt(8))+BigInt(r);return BigInt.asIntN(8*e.length,t)},r.bytesToNumber=function(e){d(e);const t=m(e);return(0,s.assert)(t<=BigInt(Number.MAX_SAFE_INTEGER),"Number is not a safe integer. Use `bytesToBigInt` instead."),Number(t)},r.bytesToString=function(e){return d(e),(new TextDecoder).decode(e)},r.bytesToBase64=function(e){return d(e),n.base64.encode(e)},r.hexToBytes=h,r.bigIntToBytes=p,r.signedBigIntToBytes=function(e,t){(0,s.assert)("bigint"==typeof e,"Value must be a bigint."),(0,s.assert)("number"==typeof t,"Byte length must be a number."),(0,s.assert)(t>0,"Byte length must be greater than 0."),(0,s.assert)(function(e,t){(0,s.assert)(t>0);const r=e>>BigInt(31);return!((~e&r)+(e&~r)>>BigInt(8*t-1))}(e,t),"Byte length is too small to represent the given value.");let r=e;const n=new Uint8Array(t);for(let e=0;e<n.length;e++)n[e]=Number(BigInt.asUintN(8,r)),r>>=BigInt(8);return n.reverse()},r.numberToBytes=g,r.stringToBytes=b,r.base64ToBytes=function(e){return(0,s.assert)("string"==typeof e,"Value must be a string."),n.base64.decode(e)},r.valueToBytes=y,r.concatBytes=function(e){const t=new Array(e.length);let r=0;for(let n=0;n<e.length;n++){const s=y(e[n]);t[n]=s,r+=s.length}const n=new Uint8Array(r);for(let e=0,r=0;e<t.length;e++)n.set(t[e],r),r+=t[e].length;return n},r.createDataView=function(e){if(void 0!==t&&e instanceof t){const t=e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength);return new DataView(t)}return new DataView(e.buffer,e.byteOffset,e.byteLength)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/bytes.cjs"}],[1794,{"@metamask/superstruct":2872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.toCaipChainId=r.parseCaipAccountId=r.parseCaipChainId=r.isCaipAssetId=r.isCaipAssetType=r.isCaipAccountAddress=r.isCaipAccountId=r.isCaipReference=r.isCaipNamespace=r.isCaipChainId=r.KnownCaipNamespace=r.CaipAssetIdStruct=r.CaipAssetTypeStruct=r.CaipAccountAddressStruct=r.CaipAccountIdStruct=r.CaipReferenceStruct=r.CaipNamespaceStruct=r.CaipChainIdStruct=r.CAIP_ASSET_ID_REGEX=r.CAIP_ASSET_TYPE_REGEX=r.CAIP_ACCOUNT_ADDRESS_REGEX=r.CAIP_ACCOUNT_ID_REGEX=r.CAIP_REFERENCE_REGEX=r.CAIP_NAMESPACE_REGEX=r.CAIP_CHAIN_ID_REGEX=void 0;const n=e("@metamask/superstruct");function s(e){return(0,n.is)(e,r.CaipNamespaceStruct)}function a(e){return(0,n.is)(e,r.CaipReferenceStruct)}r.CAIP_CHAIN_ID_REGEX=/^(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32})$/u,r.CAIP_NAMESPACE_REGEX=/^[-a-z0-9]{3,8}$/u,r.CAIP_REFERENCE_REGEX=/^[-_a-zA-Z0-9]{1,32}$/u,r.CAIP_ACCOUNT_ID_REGEX=/^(?<chainId>(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32})):(?<accountAddress>[-.%a-zA-Z0-9]{1,128})$/u,r.CAIP_ACCOUNT_ADDRESS_REGEX=/^[-.%a-zA-Z0-9]{1,128}$/u,r.CAIP_ASSET_TYPE_REGEX=/^(?<chainId>(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32}))\/(?<assetNamespace>[-a-z0-9]{3,8}):(?<assetReference>[-.%a-zA-Z0-9]{1,128})$/u,r.CAIP_ASSET_ID_REGEX=/^(?<chainId>(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32}))\/(?<assetNamespace>[-a-z0-9]{3,8}):(?<assetReference>[-.%a-zA-Z0-9]{1,128})\/(?<tokenId>[-.%a-zA-Z0-9]{1,78})$/u,r.CaipChainIdStruct=(0,n.pattern)((0,n.string)(),r.CAIP_CHAIN_ID_REGEX),r.CaipNamespaceStruct=(0,n.pattern)((0,n.string)(),r.CAIP_NAMESPACE_REGEX),r.CaipReferenceStruct=(0,n.pattern)((0,n.string)(),r.CAIP_REFERENCE_REGEX),r.CaipAccountIdStruct=(0,n.pattern)((0,n.string)(),r.CAIP_ACCOUNT_ID_REGEX),r.CaipAccountAddressStruct=(0,n.pattern)((0,n.string)(),r.CAIP_ACCOUNT_ADDRESS_REGEX),r.CaipAssetTypeStruct=(0,n.pattern)((0,n.string)(),r.CAIP_ASSET_TYPE_REGEX),r.CaipAssetIdStruct=(0,n.pattern)((0,n.string)(),r.CAIP_ASSET_ID_REGEX),function(e){e.Bip122="bip122",e.Eip155="eip155",e.Wallet="wallet"}(r.KnownCaipNamespace||(r.KnownCaipNamespace={})),r.isCaipChainId=function(e){return(0,n.is)(e,r.CaipChainIdStruct)},r.isCaipNamespace=s,r.isCaipReference=a,r.isCaipAccountId=function(e){return(0,n.is)(e,r.CaipAccountIdStruct)},r.isCaipAccountAddress=function(e){return(0,n.is)(e,r.CaipAccountAddressStruct)},r.isCaipAssetType=function(e){return(0,n.is)(e,r.CaipAssetTypeStruct)},r.isCaipAssetId=function(e){return(0,n.is)(e,r.CaipAssetIdStruct)},r.parseCaipChainId=function(e){const t=r.CAIP_CHAIN_ID_REGEX.exec(e);if(!t?.groups)throw new Error("Invalid CAIP chain ID.");return{namespace:t.groups.namespace,reference:t.groups.reference}},r.parseCaipAccountId=function(e){const t=r.CAIP_ACCOUNT_ID_REGEX.exec(e);if(!t?.groups)throw new Error("Invalid CAIP account ID.");return{address:t.groups.accountAddress,chainId:t.groups.chainId,chain:{namespace:t.groups.namespace,reference:t.groups.reference}}},r.toCaipChainId=function(e,t){if(!s(e))throw new Error(`Invalid "namespace", must match: ${r.CAIP_NAMESPACE_REGEX.toString()}`);if(!a(t))throw new Error(`Invalid "reference", must match: ${r.CAIP_REFERENCE_REGEX.toString()}`);return`${e}:${t}`}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/caip-types.cjs"}],[1795,{"./base64.cjs":1792,"@metamask/superstruct":2872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ChecksumStruct=void 0;const n=e("@metamask/superstruct"),s=e("./base64.cjs");r.ChecksumStruct=(0,n.size)((0,s.base64)((0,n.string)(),{paddingRequired:!0}),44,44)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/checksum.cjs"}],[1796,{"./assert.cjs":1791,"./bytes.cjs":1793,"./hex.cjs":1800,"@metamask/superstruct":2872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createHex=r.createBytes=r.createBigInt=r.createNumber=void 0;const n=e("@metamask/superstruct"),s=e("./assert.cjs"),a=e("./bytes.cjs"),o=e("./hex.cjs"),i=(0,n.union)([(0,n.number)(),(0,n.bigint)(),(0,n.string)(),o.StrictHexStruct]),c=(0,n.coerce)((0,n.number)(),i,Number),l=(0,n.coerce)((0,n.bigint)(),i,BigInt),u=((0,n.union)([o.StrictHexStruct,(0,n.instance)(Uint8Array)]),(0,n.coerce)((0,n.instance)(Uint8Array),(0,n.union)([o.StrictHexStruct]),a.hexToBytes)),d=(0,n.coerce)(o.StrictHexStruct,(0,n.instance)(Uint8Array),a.bytesToHex);r.createNumber=function(e){try{const t=(0,n.create)(e,c);return(0,s.assert)(Number.isFinite(t),`Expected a number-like value, got "${e}".`),t}catch(t){if(t instanceof n.StructError)throw new Error(`Expected a number-like value, got "${e}".`);throw t}},r.createBigInt=function(e){try{return(0,n.create)(e,l)}catch(e){if(e instanceof n.StructError)throw new Error(`Expected a number-like value, got "${String(e.value)}".`);throw e}},r.createBytes=function(e){if("string"==typeof e&&"0x"===e.toLowerCase())return new Uint8Array;try{return(0,n.create)(e,u)}catch(e){if(e instanceof n.StructError)throw new Error(`Expected a bytes-like value, got "${String(e.value)}".`);throw e}},r.createHex=function(e){if(e instanceof Uint8Array&&0===e.length||"string"==typeof e&&"0x"===e.toLowerCase())return"0x";try{return(0,n.create)(e,d)}catch(e){if(e instanceof n.StructError)throw new Error(`Expected a bytes-like value, got "${String(e.value)}".`);throw e}}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/coercers.cjs"}],[1797,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n,s,a=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},o=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r};Object.defineProperty(r,"__esModule",{value:!0}),r.FrozenSet=r.FrozenMap=void 0;class i{get size(){return a(this,n,"f").size}[(n=new WeakMap,Symbol.iterator)](){return a(this,n,"f")[Symbol.iterator]()}constructor(e){n.set(this,void 0),o(this,n,new Map(e),"f"),Object.freeze(this)}entries(){return a(this,n,"f").entries()}forEach(e,t){return a(this,n,"f").forEach(((r,n,s)=>e.call(t,r,n,this)))}get(e){return a(this,n,"f").get(e)}has(e){return a(this,n,"f").has(e)}keys(){return a(this,n,"f").keys()}values(){return a(this,n,"f").values()}toString(){return`FrozenMap(${this.size}) {${this.size>0?` ${[...this.entries()].map((([e,t])=>`${String(e)} => ${String(t)}`)).join(", ")} `:""}}`}}r.FrozenMap=i;class c{get size(){return a(this,s,"f").size}[(s=new WeakMap,Symbol.iterator)](){return a(this,s,"f")[Symbol.iterator]()}constructor(e){s.set(this,void 0),o(this,s,new Set(e),"f"),Object.freeze(this)}entries(){return a(this,s,"f").entries()}forEach(e,t){return a(this,s,"f").forEach(((r,n,s)=>e.call(t,r,n,this)))}has(e){return a(this,s,"f").has(e)}keys(){return a(this,s,"f").keys()}values(){return a(this,s,"f").values()}toString(){return`FrozenSet(${this.size}) {${this.size>0?` ${[...this.values()].map((e=>String(e))).join(", ")} `:""}}`}}r.FrozenSet=c,Object.freeze(i),Object.freeze(i.prototype),Object.freeze(c),Object.freeze(c.prototype)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/collections.cjs"}],[1798,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/encryption-types.cjs"}],[1799,{"./misc.cjs":1805,"pony-cause":5082},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.wrapError=r.getErrorMessage=r.isErrorWithStack=r.isErrorWithMessage=r.isErrorWithCode=void 0;const n=e("pony-cause"),s=e("./misc.cjs");function a(e){return"object"==typeof e&&null!==e&&"code"in e}function o(e){return"object"==typeof e&&null!==e&&"message"in e}r.isErrorWithCode=a,r.isErrorWithMessage=o,r.isErrorWithStack=function(e){return"object"==typeof e&&null!==e&&"stack"in e},r.getErrorMessage=function(e){return o(e)&&"string"==typeof e.message?e.message:(0,s.isNullOrUndefined)(e)?"":String(e)},r.wrapError=function(e,t){if((r=e)instanceof Error||(0,s.isObject)(r)&&"Error"===r.constructor.name){let r;return r=2===Error.length?new Error(t,{cause:e}):new n.ErrorWithCause(t,{cause:e}),a(e)&&(r.code=e.code),r}var r;return t.length>0?new Error(`${String(e)}: ${t}`):new Error(String(e))}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/errors.cjs"}],[1800,{"./assert.cjs":1791,"./bytes.cjs":1793,"@metamask/superstruct":2872,"@noble/hashes/sha3":3030},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.remove0x=r.add0x=r.isValidChecksumAddress=r.getChecksumAddress=r.isValidHexAddress=r.assertIsStrictHexString=r.assertIsHexString=r.isStrictHexString=r.isHexString=r.HexChecksumAddressStruct=r.HexAddressStruct=r.StrictHexStruct=r.HexStruct=void 0;const n=e("@metamask/superstruct"),s=e("@noble/hashes/sha3"),a=e("./assert.cjs"),o=e("./bytes.cjs");function i(e){return(0,n.is)(e,r.HexStruct)}function c(e){return(0,n.is)(e,r.StrictHexStruct)}function l(e){(0,a.assert)((0,n.is)(e,r.HexChecksumAddressStruct),"Invalid hex address.");const t=d(e.toLowerCase()),i=d((0,o.bytesToHex)((0,s.keccak_256)(t)));return`0x${t.split("").map(((e,t)=>{const r=i[t];return(0,a.assert)((0,n.is)(r,(0,n.string)()),"Hash shorter than address."),parseInt(r,16)>7?e.toUpperCase():e})).join("")}`}function u(e){return!!(0,n.is)(e,r.HexChecksumAddressStruct)&&l(e)===e}function d(e){return e.startsWith("0x")||e.startsWith("0X")?e.substring(2):e}r.HexStruct=(0,n.pattern)((0,n.string)(),/^(?:0x)?[0-9a-f]+$/iu),r.StrictHexStruct=(0,n.pattern)((0,n.string)(),/^0x[0-9a-f]+$/iu),r.HexAddressStruct=(0,n.pattern)((0,n.string)(),/^0x[0-9a-f]{40}$/u),r.HexChecksumAddressStruct=(0,n.pattern)((0,n.string)(),/^0x[0-9a-fA-F]{40}$/u),r.isHexString=i,r.isStrictHexString=c,r.assertIsHexString=function(e){(0,a.assert)(i(e),"Value must be a hexadecimal string.")},r.assertIsStrictHexString=function(e){(0,a.assert)(c(e),'Value must be a hexadecimal string, starting with "0x".')},r.isValidHexAddress=function(e){return(0,n.is)(e,r.HexAddressStruct)||u(e)},r.getChecksumAddress=l,r.isValidChecksumAddress=u,r.add0x=function(e){return e.startsWith("0x")?e:e.startsWith("0X")?`0x${e.substring(2)}`:`0x${e}`},r.remove0x=d}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/hex.cjs"}],[1801,{"./assert.cjs":1791,"./base64.cjs":1792,"./bytes.cjs":1793,"./caip-types.cjs":1794,"./checksum.cjs":1795,"./coercers.cjs":1796,"./collections.cjs":1797,"./encryption-types.cjs":1798,"./errors.cjs":1799,"./hex.cjs":1800,"./json.cjs":1802,"./keyring.cjs":1803,"./logging.cjs":1804,"./misc.cjs":1805,"./number.cjs":1806,"./opaque.cjs":1807,"./promise.cjs":1808,"./time.cjs":1809,"./transaction-types.cjs":1810,"./versions.cjs":1811},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./assert.cjs"),r),s(e("./base64.cjs"),r),s(e("./bytes.cjs"),r),s(e("./caip-types.cjs"),r),s(e("./checksum.cjs"),r),s(e("./coercers.cjs"),r),s(e("./collections.cjs"),r),s(e("./encryption-types.cjs"),r),s(e("./errors.cjs"),r),s(e("./hex.cjs"),r),s(e("./json.cjs"),r),s(e("./keyring.cjs"),r),s(e("./logging.cjs"),r),s(e("./misc.cjs"),r),s(e("./number.cjs"),r),s(e("./opaque.cjs"),r),s(e("./promise.cjs"),r),s(e("./time.cjs"),r),s(e("./transaction-types.cjs"),r),s(e("./versions.cjs"),r)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/index.cjs"}],[1802,{"./assert.cjs":1791,"./misc.cjs":1805,"@metamask/superstruct":2872},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getJsonRpcIdValidator=r.assertIsJsonRpcError=r.isJsonRpcError=r.assertIsJsonRpcFailure=r.isJsonRpcFailure=r.assertIsJsonRpcSuccess=r.isJsonRpcSuccess=r.assertIsJsonRpcResponse=r.isJsonRpcResponse=r.assertIsPendingJsonRpcResponse=r.isPendingJsonRpcResponse=r.JsonRpcResponseStruct=r.JsonRpcFailureStruct=r.JsonRpcSuccessStruct=r.PendingJsonRpcResponseStruct=r.assertIsJsonRpcRequest=r.isJsonRpcRequest=r.assertIsJsonRpcNotification=r.isJsonRpcNotification=r.JsonRpcNotificationStruct=r.JsonRpcRequestStruct=r.JsonRpcParamsStruct=r.JsonRpcErrorStruct=r.JsonRpcIdStruct=r.JsonRpcVersionStruct=r.jsonrpc2=r.getJsonSize=r.getSafeJson=r.isValidJson=r.JsonStruct=r.UnsafeJsonStruct=r.exactOptional=r.object=void 0;const n=e("@metamask/superstruct"),s=e("./assert.cjs"),a=e("./misc.cjs");function o({path:e,branch:t}){const r=e[e.length-1];return(0,a.hasProperty)(t[t.length-2],r)}function i(e){return new n.Struct({...e,type:`optional ${e.type}`,validator:(t,r)=>!o(r)||e.validator(t,r),refiner:(t,r)=>!o(r)||e.refiner(t,r)})}r.object=e=>(0,n.object)(e),r.exactOptional=i;function c(e){return(0,n.create)(e,r.JsonStruct)}r.UnsafeJsonStruct=(0,n.union)([(0,n.literal)(null),(0,n.boolean)(),(0,n.define)("finite number",(e=>(0,n.is)(e,(0,n.number)())&&Number.isFinite(e))),(0,n.string)(),(0,n.array)((0,n.lazy)((()=>r.UnsafeJsonStruct))),(0,n.record)((0,n.string)(),(0,n.lazy)((()=>r.UnsafeJsonStruct)))]),r.JsonStruct=(0,n.coerce)(r.UnsafeJsonStruct,(0,n.any)(),(e=>((0,s.assertStruct)(e,r.UnsafeJsonStruct),JSON.parse(JSON.stringify(e,((e,t)=>"__proto__"===e||"constructor"===e?undefined:t)))))),r.isValidJson=function(e){try{return c(e),!0}catch{return!1}},r.getSafeJson=c,r.getJsonSize=function(e){(0,s.assertStruct)(e,r.JsonStruct,"Invalid JSON value");const t=JSON.stringify(e);return(new TextEncoder).encode(t).byteLength},r.jsonrpc2="2.0",r.JsonRpcVersionStruct=(0,n.literal)(r.jsonrpc2),r.JsonRpcIdStruct=(0,n.nullable)((0,n.union)([(0,n.number)(),(0,n.string)()])),r.JsonRpcErrorStruct=(0,r.object)({code:(0,n.integer)(),message:(0,n.string)(),data:i(r.JsonStruct),stack:i((0,n.string)())}),r.JsonRpcParamsStruct=(0,n.union)([(0,n.record)((0,n.string)(),r.JsonStruct),(0,n.array)(r.JsonStruct)]),r.JsonRpcRequestStruct=(0,r.object)({id:r.JsonRpcIdStruct,jsonrpc:r.JsonRpcVersionStruct,method:(0,n.string)(),params:i(r.JsonRpcParamsStruct)}),r.JsonRpcNotificationStruct=(0,r.object)({jsonrpc:r.JsonRpcVersionStruct,method:(0,n.string)(),params:i(r.JsonRpcParamsStruct)}),r.isJsonRpcNotification=function(e){return(0,n.is)(e,r.JsonRpcNotificationStruct)},r.assertIsJsonRpcNotification=function(e,t){(0,s.assertStruct)(e,r.JsonRpcNotificationStruct,"Invalid JSON-RPC notification",t)},r.isJsonRpcRequest=function(e){return(0,n.is)(e,r.JsonRpcRequestStruct)},r.assertIsJsonRpcRequest=function(e,t){(0,s.assertStruct)(e,r.JsonRpcRequestStruct,"Invalid JSON-RPC request",t)},r.PendingJsonRpcResponseStruct=(0,n.object)({id:r.JsonRpcIdStruct,jsonrpc:r.JsonRpcVersionStruct,result:(0,n.optional)((0,n.unknown)()),error:(0,n.optional)(r.JsonRpcErrorStruct)}),r.JsonRpcSuccessStruct=(0,r.object)({id:r.JsonRpcIdStruct,jsonrpc:r.JsonRpcVersionStruct,result:r.JsonStruct}),r.JsonRpcFailureStruct=(0,r.object)({id:r.JsonRpcIdStruct,jsonrpc:r.JsonRpcVersionStruct,error:r.JsonRpcErrorStruct}),r.JsonRpcResponseStruct=(0,n.union)([r.JsonRpcSuccessStruct,r.JsonRpcFailureStruct]),r.isPendingJsonRpcResponse=function(e){return(0,n.is)(e,r.PendingJsonRpcResponseStruct)},r.assertIsPendingJsonRpcResponse=function(e,t){(0,s.assertStruct)(e,r.PendingJsonRpcResponseStruct,"Invalid pending JSON-RPC response",t)},r.isJsonRpcResponse=function(e){return(0,n.is)(e,r.JsonRpcResponseStruct)},r.assertIsJsonRpcResponse=function(e,t){(0,s.assertStruct)(e,r.JsonRpcResponseStruct,"Invalid JSON-RPC response",t)},r.isJsonRpcSuccess=function(e){return(0,n.is)(e,r.JsonRpcSuccessStruct)},r.assertIsJsonRpcSuccess=function(e,t){(0,s.assertStruct)(e,r.JsonRpcSuccessStruct,"Invalid JSON-RPC success response",t)},r.isJsonRpcFailure=function(e){return(0,n.is)(e,r.JsonRpcFailureStruct)},r.assertIsJsonRpcFailure=function(e,t){(0,s.assertStruct)(e,r.JsonRpcFailureStruct,"Invalid JSON-RPC failure response",t)},r.isJsonRpcError=function(e){return(0,n.is)(e,r.JsonRpcErrorStruct)},r.assertIsJsonRpcError=function(e,t){(0,s.assertStruct)(e,r.JsonRpcErrorStruct,"Invalid JSON-RPC error",t)},r.getJsonRpcIdValidator=function(e){const{permitEmptyString:t,permitFractions:r,permitNull:n}={permitEmptyString:!0,permitFractions:!1,permitNull:!0,...e};return e=>Boolean("number"==typeof e&&(r||Number.isInteger(e))||"string"==typeof e&&(t||e.length>0)||n&&null===e)}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/json.cjs"}],[1803,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/keyring.cjs"}],[1804,{debug:4259},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.createModuleLogger=r.createProjectLogger=void 0;const s=(0,n(e("debug")).default)("metamask");r.createProjectLogger=function(e){return s.extend(e)},r.createModuleLogger=function(e,t){return e.extend(t)}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/logging.cjs"}],[1805,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.calculateNumberSize=r.calculateStringSize=r.isASCII=r.isPlainObject=r.ESCAPE_CHARACTERS_REGEXP=r.JsonSize=r.getKnownPropertyNames=r.hasProperty=r.isObject=r.isNullOrUndefined=r.isNonEmptyArray=void 0,r.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},r.isNullOrUndefined=function(e){return null===e||e===undefined},r.isObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)};function n(e){return e.charCodeAt(0)<=127}r.hasProperty=(e,t)=>Object.hasOwnProperty.call(e,t),r.getKnownPropertyNames=function(e){return Object.getOwnPropertyNames(e)},function(e){e[e.Null=4]="Null",e[e.Comma=1]="Comma",e[e.Wrapper=1]="Wrapper",e[e.True=4]="True",e[e.False=5]="False",e[e.Quote=1]="Quote",e[e.Colon=1]="Colon",e[e.Date=24]="Date"}(r.JsonSize||(r.JsonSize={})),r.ESCAPE_CHARACTERS_REGEXP=/"|\\|\n|\r|\t/gu,r.isPlainObject=function(e){if("object"!=typeof e||null===e)return!1;try{let t=e;for(;null!==Object.getPrototypeOf(t);)t=Object.getPrototypeOf(t);return Object.getPrototypeOf(e)===t}catch(e){return!1}},r.isASCII=n,r.calculateStringSize=function(e){return e.split("").reduce(((e,t)=>n(t)?e+1:e+2),0)+(e.match(r.ESCAPE_CHARACTERS_REGEXP)??[]).length},r.calculateNumberSize=function(e){return e.toString().length}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/misc.cjs"}],[1806,{"./assert.cjs":1791,"./hex.cjs":1800},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.hexToBigInt=r.hexToNumber=r.bigIntToHex=r.numberToHex=void 0;const n=e("./assert.cjs"),s=e("./hex.cjs");r.numberToHex=e=>((0,n.assert)("number"==typeof e,"Value must be a number."),(0,n.assert)(e>=0,"Value must be a non-negative number."),(0,n.assert)(Number.isSafeInteger(e),"Value is not a safe integer. Use `bigIntToHex` instead."),(0,s.add0x)(e.toString(16)));r.bigIntToHex=e=>((0,n.assert)("bigint"==typeof e,"Value must be a bigint."),(0,n.assert)(e>=0,"Value must be a non-negative bigint."),(0,s.add0x)(e.toString(16)));r.hexToNumber=e=>{(0,s.assertIsHexString)(e);const t=parseInt(e,16);return(0,n.assert)(Number.isSafeInteger(t),"Value is not a safe integer. Use `hexToBigInt` instead."),t};r.hexToBigInt=e=>((0,s.assertIsHexString)(e),BigInt((0,s.add0x)(e)))}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/number.cjs"}],[1807,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/opaque.cjs"}],[1808,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.createDeferredPromise=void 0,r.createDeferredPromise=function({suppressUnhandledRejection:e=!1}={}){let t,r;const n=new Promise(((e,n)=>{t=e,r=n}));return e&&n.catch((e=>{})),{promise:n,resolve:t,reject:r}}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/promise.cjs"}],[1809,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.timeSince=r.inMilliseconds=r.Duration=void 0,function(e){e[e.Millisecond=1]="Millisecond",e[e.Second=1e3]="Second",e[e.Minute=6e4]="Minute",e[e.Hour=36e5]="Hour",e[e.Day=864e5]="Day",e[e.Week=6048e5]="Week",e[e.Year=31536e6]="Year"}(r.Duration||(r.Duration={}));const n=(e,t)=>{if(!(e=>Number.isInteger(e)&&e>=0)(e))throw new Error(`"${t}" must be a non-negative integer. Received: "${e}".`)};r.inMilliseconds=function(e,t){return n(e,"count"),e*t},r.timeSince=function(e){return n(e,"timestamp"),Date.now()-e}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/time.cjs"}],[1810,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/transaction-types.cjs"}],[1811,{"./assert.cjs":1791,"@metamask/superstruct":2872,semver:5640},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.satisfiesVersionRange=r.gtRange=r.gtVersion=r.assertIsSemVerRange=r.assertIsSemVerVersion=r.isValidSemVerRange=r.isValidSemVerVersion=r.VersionRangeStruct=r.VersionStruct=void 0;const n=e("@metamask/superstruct"),s=e("semver"),a=e("./assert.cjs");r.VersionStruct=(0,n.refine)((0,n.string)(),"Version",(e=>null!==(0,s.valid)(e)||`Expected SemVer version, got "${e}"`)),r.VersionRangeStruct=(0,n.refine)((0,n.string)(),"Version range",(e=>null!==(0,s.validRange)(e)||`Expected SemVer range, got "${e}"`)),r.isValidSemVerVersion=function(e){return(0,n.is)(e,r.VersionStruct)},r.isValidSemVerRange=function(e){return(0,n.is)(e,r.VersionRangeStruct)},r.assertIsSemVerVersion=function(e){(0,a.assertStruct)(e,r.VersionStruct)},r.assertIsSemVerRange=function(e){(0,a.assertStruct)(e,r.VersionRangeStruct)},r.gtVersion=function(e,t){return(0,s.gt)(e,t)},r.gtRange=function(e,t){return(0,s.gtr)(e,t)},r.satisfiesVersionRange=function(e,t){return(0,s.satisfies)(e,t,{includePrerelease:!0})}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/versions.cjs"}],[1812,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function s(e,...t){if(!n(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function a(e,t){return!!Array.isArray(t)&&(0===t.length||(e?t.every((e=>"string"==typeof e)):t.every((e=>Number.isSafeInteger(e)))))}function o(e){if("function"!=typeof e)throw new Error("function expected");return!0}function i(e,t){if("string"!=typeof t)throw new Error(`${e}: string expected`);return!0}function c(e){if(!Number.isSafeInteger(e))throw new Error(`invalid integer: ${e}`)}function l(e){if(!Array.isArray(e))throw new Error("array expected")}function u(e,t){if(!a(!0,t))throw new Error(`${e}: array of strings expected`)}function d(e,t){if(!a(!1,t))throw new Error(`${e}: array of numbers expected`)}function f(...e){const t=e=>e,r=(e,t)=>r=>e(t(r));return{encode:e.map((e=>e.encode)).reduceRight(r,t),decode:e.map((e=>e.decode)).reduce(r,t)}}function m(e){const t="string"==typeof e?e.split(""):e,r=t.length;u("alphabet",t);const n=new Map(t.map(((e,t)=>[e,t])));return{encode:n=>(l(n),n.map((n=>{if(!Number.isSafeInteger(n)||n<0||n>=r)throw new Error(`alphabet.encode: digit index outside alphabet "${n}". Allowed: ${e}`);return t[n]}))),decode:t=>(l(t),t.map((t=>{i("alphabet.decode",t);const r=n.get(t);if(r===undefined)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return r})))}}function h(e=""){return i("join",e),{encode:t=>(u("join.decode",t),t.join(e)),decode:t=>(i("join.decode",t),t.split(e))}}function p(e,t="="){return c(e),i("padding",t),{encode(r){for(u("padding.encode",r);r.length*e%8;)r.push(t);return r},decode(r){u("padding.decode",r);let n=r.length;if(n*e%8)throw new Error("padding: invalid, string should have whole number of bytes");for(;n>0&&r[n-1]===t;n--){if((n-1)*e%8==0)throw new Error("padding: invalid, string has too much padding")}return r.slice(0,n)}}}function g(e){return o(e),{encode:e=>e,decode:t=>e(t)}}function b(e,t,r){if(t<2)throw new Error(`convertRadix: invalid from=${t}, base cannot be less than 2`);if(r<2)throw new Error(`convertRadix: invalid to=${r}, base cannot be less than 2`);if(l(e),!e.length)return[];let n=0;const s=[],a=Array.from(e,(e=>{if(c(e),e<0||e>=t)throw new Error(`invalid integer: ${e}`);return e})),o=a.length;for(;;){let e=0,i=!0;for(let s=n;s<o;s++){const o=a[s],c=t*e,l=c+o;if(!Number.isSafeInteger(l)||c/t!==e||l-o!==c)throw new Error("convertRadix: carry overflow");const u=l/r;e=l%r;const d=Math.floor(u);if(a[s]=d,!Number.isSafeInteger(d)||d*r+e!==l)throw new Error("convertRadix: carry overflow");i&&(d?i=!1:n=s)}if(s.push(e),i)break}for(let t=0;t<e.length-1&&0===e[t];t++)s.push(0);return s.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=r.stringToBytes=r.str=r.bytesToString=r.hex=r.utf8=r.bech32m=r.bech32=r.base58check=r.createBase58check=r.base58xmr=r.base58xrp=r.base58flickr=r.base58=r.base64urlnopad=r.base64url=r.base64nopad=r.base64=r.base32crockford=r.base32hexnopad=r.base32hex=r.base32nopad=r.base32=r.base16=r.utils=void 0;const y=(e,t)=>0===t?e:y(t,e%t),E=(e,t)=>e+(t-y(e,t)),w=(()=>{let e=[];for(let t=0;t<40;t++)e.push(2**t);return e})();function k(e,t,r,n){if(l(e),t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(r<=0||r>32)throw new Error(`convertRadix2: wrong to=${r}`);if(E(t,r)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${r} carryBits=${E(t,r)}`);let s=0,a=0;const o=w[t],i=w[r]-1,u=[];for(const n of e){if(c(n),n>=o)throw new Error(`convertRadix2: invalid data word=${n} from=${t}`);if(s=s<<t|n,a+t>32)throw new Error(`convertRadix2: carry overflow pos=${a} from=${t}`);for(a+=t;a>=r;a-=r)u.push((s>>a-r&i)>>>0);const e=w[a];if(e===undefined)throw new Error("invalid carry");s&=e-1}if(s=s<<r-a&i,!n&&a>=t)throw new Error("Excess padding");if(!n&&s>0)throw new Error(`Non-zero padding: ${s}`);return n&&a>0&&u.push(s>>>0),u}function v(e){c(e);return{encode:t=>{if(!n(t))throw new Error("radix.encode input should be Uint8Array");return b(Array.from(t),256,e)},decode:t=>(d("radix.decode",t),Uint8Array.from(b(t,e,256)))}}function x(e,t=!1){if(c(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(E(8,e)>32||E(e,8)>32)throw new Error("radix2: carry overflow");return{encode:r=>{if(!n(r))throw new Error("radix2.encode input should be Uint8Array");return k(Array.from(r),8,e,!t)},decode:r=>(d("radix2.decode",r),Uint8Array.from(k(r,e,8,t)))}}function A(e){return o(e),function(...t){try{return e.apply(null,t)}catch(e){}}}function T(e,t){return c(e),o(t),{encode(r){if(!n(r))throw new Error("checksum.encode: input should be Uint8Array");const s=t(r).slice(0,e),a=new Uint8Array(r.length+e);return a.set(r),a.set(s,r.length),a},decode(r){if(!n(r))throw new Error("checksum.decode: input should be Uint8Array");const s=r.slice(0,-e),a=r.slice(-e),o=t(s).slice(0,e);for(let t=0;t<e;t++)if(o[t]!==a[t])throw new Error("Invalid checksum");return s}}}r.utils={alphabet:m,chain:f,checksum:T,convertRadix:b,convertRadix2:k,radix:v,radix2:x,join:h,padding:p},r.base16=f(x(4),m("0123456789ABCDEF"),h("")),r.base32=f(x(5),m("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),p(5),h("")),r.base32nopad=f(x(5),m("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),h("")),r.base32hex=f(x(5),m("0123456789ABCDEFGHIJKLMNOPQRSTUV"),p(5),h("")),r.base32hexnopad=f(x(5),m("0123456789ABCDEFGHIJKLMNOPQRSTUV"),h("")),r.base32crockford=f(x(5),m("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),h(""),g((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1"))));const B=(()=>"function"==typeof Uint8Array.from([]).toBase64&&"function"==typeof Uint8Array.fromBase64)();r.base64=B?{encode:e=>(s(e),e.toBase64()),decode:e=>(i("base64",e),Uint8Array.fromBase64(e,{lastChunkHandling:"strict"}))}:f(x(6),m("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),p(6),h("")),r.base64nopad=f(x(6),m("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),h("")),r.base64url=B?{encode:e=>(s(e),e.toBase64({alphabet:"base64url"})),decode:e=>(i("base64",e),Uint8Array.fromBase64(e,{alphabet:"base64url"}))}:f(x(6),m("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),p(6),h("")),r.base64urlnopad=f(x(6),m("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),h(""));const C=e=>f(v(58),m(e),h(""));r.base58=C("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),r.base58flickr=C("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),r.base58xrp=C("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const _=[0,2,3,5,6,7,9,10,11];r.base58xmr={encode(e){let t="";for(let n=0;n<e.length;n+=8){const s=e.subarray(n,n+8);t+=r.base58.encode(s).padStart(_[s.length],"1")}return t},decode(e){let t=[];for(let n=0;n<e.length;n+=11){const s=e.slice(n,n+11),a=_.indexOf(s.length),o=r.base58.decode(s);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};r.createBase58check=e=>f(T(4,(t=>e(e(t)))),r.base58),r.base58check=r.createBase58check;const P=f(m("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),h("")),S=[996825010,642813549,513874426,1027748829,705979059];function I(e){const t=e>>25;let r=(33554431&e)<<5;for(let e=0;e<S.length;e++)1==(t>>e&1)&&(r^=S[e]);return r}function D(e,t,r=1){const n=e.length;let s=1;for(let t=0;t<n;t++){const r=e.charCodeAt(t);if(r<33||r>126)throw new Error(`Invalid prefix (${e})`);s=I(s)^r>>5}s=I(s);for(let t=0;t<n;t++)s=I(s)^31&e.charCodeAt(t);for(let e of t)s=I(s)^e;for(let e=0;e<6;e++)s=I(s);return s^=r,P.encode(k([s%w[30]],30,5,!1))}function j(e){const t="bech32"===e?1:734539939,r=x(5),s=r.decode,a=r.encode,o=A(s);function c(e,r,s=90){i("bech32.encode prefix",e),n(r)&&(r=Array.from(r)),d("bech32.encode",r);const a=e.length;if(0===a)throw new TypeError(`Invalid prefix length ${a}`);const o=a+7+r.length;if(!1!==s&&o>s)throw new TypeError(`Length ${o} exceeds limit ${s}`);const c=e.toLowerCase(),l=D(c,r,t);return`${c}1${P.encode(r)}${l}`}function l(e,r=90){i("bech32.decode input",e);const n=e.length;if(n<8||!1!==r&&n>r)throw new TypeError(`invalid string length: ${n} (${e}). Expected (8..${r})`);const s=e.toLowerCase();if(e!==s&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const a=s.lastIndexOf("1");if(0===a||-1===a)throw new Error('Letter "1" must be present between prefix and data only');const o=s.slice(0,a),c=s.slice(a+1);if(c.length<6)throw new Error("Data must be at least 6 characters long");const l=P.decode(c).slice(0,-6),u=D(o,l,t);if(!c.endsWith(u))throw new Error(`Invalid checksum in ${e}: expected "${u}"`);return{prefix:o,words:l}}return{encode:c,decode:l,encodeFromBytes:function(e,t){return c(e,a(t))},decodeToBytes:function(e){const{prefix:t,words:r}=l(e,!1);return{prefix:t,words:r,bytes:s(r)}},decodeUnsafe:A(l),fromWords:s,fromWordsUnsafe:o,toWords:a}}r.bech32=j("bech32"),r.bech32m=j("bech32m"),r.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)};const R=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),F={encode:e=>(s(e),e.toHex()),decode:e=>(i("hex",e),Uint8Array.fromHex(e))};r.hex=R?F:f(x(4),m("0123456789abcdef"),h(""),g((e=>{if("string"!=typeof e||e.length%2!=0)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const O={utf8:r.utf8,hex:r.hex,base16:r.base16,base32:r.base32,base64:r.base64,base64url:r.base64url,base58:r.base58,base58xmr:r.base58xmr},N="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";r.bytesToString=(e,t)=>{if("string"!=typeof e||!O.hasOwnProperty(e))throw new TypeError(N);if(!n(t))throw new TypeError("bytesToString() expects Uint8Array");return O[e].encode(t)},r.str=r.bytesToString;r.stringToBytes=(e,t)=>{if(!O.hasOwnProperty(e))throw new TypeError(N);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return O[e].decode(t)},r.bytes=r.stringToBytes}}},{package:"@metamask/eth-sig-util>@metamask/utils>@scure/base",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/node_modules/@scure/base/lib/index.js"}],[1813,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function s(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,r=(e,t)=>r=>e(t(r));return{encode:e.map((e=>e.encode)).reduceRight(r,t),decode:e.map((e=>e.decode)).reduce(r,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(n(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const r=e.indexOf(t);if(-1===r)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return r}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(n(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;r.length*e%8;)r.push(t);return r},decode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let n=r.length;if(n*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;n>0&&r[n-1]===t;n--)if(!((n-1)*e%8))throw new Error("Invalid padding: string has too much padding");return r.slice(0,n)}}}function l(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function u(e,t,r){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(r<2)throw new Error(`convertRadix: wrong to=${r}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let s=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(n(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,n=!0;for(let a=s;a<o.length;a++){const i=o[a],c=t*e+i;if(!Number.isSafeInteger(c)||t*e/t!==e||c-i!=t*e)throw new Error("convertRadix: carry overflow");e=c%r;const l=Math.floor(c/r);if(o[a]=l,!Number.isSafeInteger(l)||l*r+e!==c)throw new Error("convertRadix: carry overflow");n&&(l?n=!1:s=a)}if(a.push(e),n)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=r.stringToBytes=r.str=r.bytesToString=r.hex=r.utf8=r.bech32m=r.bech32=r.base58check=r.createBase58check=r.base58xmr=r.base58xrp=r.base58flickr=r.base58=r.base64urlnopad=r.base64url=r.base64nopad=r.base64=r.base32crockford=r.base32hexnopad=r.base32hex=r.base32nopad=r.base32=r.base16=r.utils=void 0,r.assertNumber=n;const d=(e,t)=>t?d(t,e%t):e,f=(e,t)=>e+(t-d(e,t));function m(e,t,r,s){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(r<=0||r>32)throw new Error(`convertRadix2: wrong to=${r}`);if(f(t,r)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${r} carryBits=${f(t,r)}`);let a=0,o=0;const i=2**r-1,c=[];for(const s of e){if(n(s),s>=2**t)throw new Error(`convertRadix2: invalid data word=${s} from=${t}`);if(a=a<<t|s,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=r;o-=r)c.push((a>>o-r&i)>>>0);a&=2**o-1}if(a=a<<r-o&i,!s&&o>=t)throw new Error("Excess padding");if(!s&&a)throw new Error(`Non-zero padding: ${a}`);return s&&o>0&&c.push(a>>>0),c}function h(e){return n(e),{encode:t=>{if(!s(t))throw new Error("radix.encode input should be Uint8Array");return u(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(u(t,e,256))}}}function p(e,t=!1){if(n(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(f(8,e)>32||f(e,8)>32)throw new Error("radix2: carry overflow");return{encode:r=>{if(!s(r))throw new Error("radix2.encode input should be Uint8Array");return m(Array.from(r),8,e,!t)},decode:r=>{if(!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(m(r,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function b(e,t){if(n(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(r){if(!s(r))throw new Error("checksum.encode: input should be Uint8Array");const n=t(r).slice(0,e),a=new Uint8Array(r.length+e);return a.set(r),a.set(n,r.length),a},decode(r){if(!s(r))throw new Error("checksum.decode: input should be Uint8Array");const n=r.slice(0,-e),a=t(n).slice(0,e),o=r.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return n}}}r.utils={alphabet:o,chain:a,checksum:b,convertRadix:u,convertRadix2:m,radix:h,radix2:p,join:i,padding:c},r.base16=a(p(4),o("0123456789ABCDEF"),i("")),r.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),i("")),r.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),r.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),i("")),r.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),r.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),l((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),r.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),i("")),r.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),r.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),i("")),r.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const y=e=>a(h(58),o(e),i(""));r.base58=y("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),r.base58flickr=y("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),r.base58xrp=y("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const E=[0,2,3,5,6,7,9,10,11];r.base58xmr={encode(e){let t="";for(let n=0;n<e.length;n+=8){const s=e.subarray(n,n+8);t+=r.base58.encode(s).padStart(E[s.length],"1")}return t},decode(e){let t=[];for(let n=0;n<e.length;n+=11){const s=e.slice(n,n+11),a=E.indexOf(s.length),o=r.base58.decode(s);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};r.createBase58check=e=>a(b(4,(t=>e(e(t)))),r.base58),r.base58check=r.createBase58check;const w=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),k=[996825010,642813549,513874426,1027748829,705979059];function v(e){const t=e>>25;let r=(33554431&e)<<5;for(let e=0;e<k.length;e++)1==(t>>e&1)&&(r^=k[e]);return r}function x(e,t,r=1){const n=e.length;let s=1;for(let t=0;t<n;t++){const r=e.charCodeAt(t);if(r<33||r>126)throw new Error(`Invalid prefix (${e})`);s=v(s)^r>>5}s=v(s);for(let t=0;t<n;t++)s=v(s)^31&e.charCodeAt(t);for(let e of t)s=v(s)^e;for(let e=0;e<6;e++)s=v(s);return s^=r,w.encode(m([s%2**30],30,5,!1))}function A(e){const t="bech32"===e?1:734539939,r=p(5),n=r.decode,s=r.encode,a=g(n);function o(e,r,n=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(r instanceof Uint8Array&&(r=Array.from(r)),!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof r);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const s=e.length+7+r.length;if(!1!==n&&s>n)throw new TypeError(`Length ${s} exceeds limit ${n}`);const a=e.toLowerCase(),o=x(a,r,t);return`${a}1${w.encode(r)}${o}`}function i(e,r=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==r&&e.length>r)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${r})`);const n=e.toLowerCase();if(e!==n&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const s=n.lastIndexOf("1");if(0===s||-1===s)throw new Error('Letter "1" must be present between prefix and data only');const a=n.slice(0,s),o=n.slice(s+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=w.decode(o).slice(0,-6),c=x(a,i,t);if(!o.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,s(t))},decodeToBytes:function(e){const{prefix:t,words:r}=i(e,!1);return{prefix:t,words:r,bytes:n(r)}},decodeUnsafe:g(i),fromWords:n,fromWordsUnsafe:a,toWords:s}}r.bech32=A("bech32"),r.bech32m=A("bech32m"),r.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},r.hex=a(p(4),o("0123456789abcdef"),i(""),l((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const T={utf8:r.utf8,hex:r.hex,base16:r.base16,base32:r.base32,base64:r.base64,base64url:r.base64url,base58:r.base58,base58xmr:r.base58xmr},B="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";r.bytesToString=(e,t)=>{if("string"!=typeof e||!T.hasOwnProperty(e))throw new TypeError(B);if(!s(t))throw new TypeError("bytesToString() expects Uint8Array");return T[e].encode(t)},r.str=r.bytesToString;r.stringToBytes=(e,t)=>{if(!T.hasOwnProperty(e))throw new TypeError(B);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return T[e].decode(t)},r.bytes=r.stringToBytes}}},{package:"@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js"}],[1814,{"./simple-keyring.cjs":1815},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var s=e("./simple-keyring.cjs");Object.defineProperty(r,"default",{enumerable:!0,get:function(){return n(s).default}})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/index.cjs"}],[1815,{"@ethereumjs/util":525,"@metamask/eth-sig-util":1837,"@metamask/utils":2976,buffer:4108,"ethereum-cryptography/keccak":4337,randombytes:5164},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n,s,a,o,i=this&&this.__classPrivateFieldSet||function(e,t,r,n,s){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?s.call(e,r):s?s.value=r:t.set(e,r),r},c=this&&this.__classPrivateFieldGet||function(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)},l=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(r,"__esModule",{value:!0});const u=e("@ethereumjs/util"),d=e("@metamask/eth-sig-util"),f=e("@metamask/utils"),m=e("ethereum-cryptography/keccak"),h=l(e("randombytes")),p="Simple Key Pair";class g{constructor(e=[]){n.add(this),s.set(this,void 0),this.type=p,i(this,s,[],"f"),this.deserialize(e).catch((e=>{throw new Error(`Problem deserializing SimpleKeyring ${e.message}`)}))}async serialize(){return c(this,s,"f").map((e=>e.privateKey.toString("hex")))}async deserialize(e){i(this,s,e.map((e=>{const r=(0,u.stripHexPrefix)(e),n=t.from(r,"hex");return{privateKey:n,publicKey:t.from((0,u.privateToPublic)(n))}})),"f")}async addAccounts(e=1){const r=[];for(let n=0;n<e;n++){const e=b(),n=t.from((0,u.privateToPublic)(e));r.push({privateKey:e,publicKey:n})}i(this,s,c(this,s,"f").concat(r),"f");return r.map((({publicKey:e})=>(0,f.add0x)((0,f.bytesToHex)((0,u.publicToAddress)(e)))))}async getAccounts(){return c(this,s,"f").map((({publicKey:e})=>(0,f.add0x)((0,f.bytesToHex)((0,u.publicToAddress)(e)))))}async signTransaction(e,t,r={}){const s=c(this,n,"m",a).call(this,e,r);return t.sign(s)??t}async signEip7702Authorization(e,t,r={}){const s=c(this,n,"m",a).call(this,e,r);return(0,d.signEIP7702Authorization)({privateKey:s,authorization:t})}async signMessage(e,r,s={withAppKeyOrigin:"",validateMessage:!0}){const o=(0,u.stripHexPrefix)(r);if(s.validateMessage&&(0===o.length||!o.match(/^[a-fA-F0-9]*$/u)))throw new Error("Cannot sign invalid message");const i=c(this,n,"m",a).call(this,e,s),l=(0,u.ecsign)(t.from(o,"hex"),i);return(0,d.concatSig)(t.from((0,f.bigIntToBytes)(l.v)),t.from(l.r),t.from(l.s))}async signPersonalMessage(e,t,r={withAppKeyOrigin:""}){const s=c(this,n,"m",a).call(this,e,r);return(0,d.personalSign)({privateKey:s,data:t})}async decryptMessage(e,t){const r=c(this,n,"m",o).call(this,e).privateKey.toString("hex");return(0,d.decrypt)({privateKey:r,encryptedData:t})}async signTypedData(e,t,r={version:d.SignTypedDataVersion.V1}){let s=d.SignTypedDataVersion.V1;r.version&&function(e){return e in d.SignTypedDataVersion}(r.version)&&(s=d.SignTypedDataVersion[r.version]);const o=c(this,n,"m",a).call(this,e,r);return(0,d.signTypedData)({privateKey:o,data:t,version:s})}async getEncryptionPublicKey(e,t){const r=c(this,n,"m",a).call(this,e,t);return(0,d.getEncryptionPublicKey)(r.toString("hex"))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const r=c(this,n,"m",o).call(this,e,{withAppKeyOrigin:t});return(0,f.add0x)((0,f.bytesToHex)((0,u.publicToAddress)(r.publicKey)))}async exportAccount(e,t={withAppKeyOrigin:""}){return c(this,n,"m",o).call(this,e,t).privateKey.toString("hex")}removeAccount(e){if(!c(this,s,"f").map((({publicKey:e})=>(0,f.bytesToHex)((0,u.publicToAddress)(e)).toLowerCase())).includes(e.toLowerCase()))throw new Error(`Address ${e} not found in this keyring`);i(this,s,c(this,s,"f").filter((({publicKey:t})=>(0,f.bytesToHex)((0,u.publicToAddress)(t)).toLowerCase()!==e.toLowerCase())),"f")}}function b(){const e=(0,h.default)(32);if(!(0,u.isValidPrivate)(e))throw new Error("Private key does not satisfy the curve requirements (ie. it is invalid)");return e}s=new WeakMap,n=new WeakSet,a=function(e,t={withAppKeyOrigin:""}){if(!e)throw new Error("Must specify address.");return c(this,n,"m",o).call(this,e,t).privateKey},o=function(e,r={}){const n=(0,d.normalize)(e);let a=c(this,s,"f").find((({publicKey:e})=>(0,f.bytesToHex)((0,u.publicToAddress)(e))===n));if(!a)throw new Error("Simple Keyring - Unable to find matching address.");if(r.withAppKeyOrigin){const{privateKey:e}=a,n=t.from(r.withAppKeyOrigin,"utf8"),s=t.concat([e,n]),o=(0,m.keccak256)(s),i=(0,u.privateToPublic)(o);a={privateKey:t.from(o),publicKey:t.from(i)}}return a},g.type=p,r.default=g}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"}],[1816,{"./errors":1817,"./packer":1820,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.decodeSingle=r.decode=r.encodePacked=r.encodeSingle=r.encode=void 0;const n=e("@metamask/utils"),s=e("./errors"),a=e("./packer");r.encode=(e,t,r,n)=>{try{return(0,a.pack)({types:e,values:t,packed:r,tight:n})}catch(e){if(e instanceof s.ParserError)throw new s.ParserError(`Unable to encode value: ${e.message}`,e);throw new s.ParserError(`An unexpected error occurred: ${(0,s.getErrorMessage)(e)}`,e)}};r.encodeSingle=(e,t)=>(0,r.encode)([e],[t]);r.encodePacked=(e,t,n)=>(0,r.encode)(e,t,!0,n);r.decode=(e,t)=>{const r=(0,n.createBytes)(t);try{return(0,a.unpack)(e,r)}catch(e){if(e instanceof s.ParserError)throw new s.ParserError(`Unable to decode value: ${e.message}`,e);throw new s.ParserError(`An unexpected error occurred: ${(0,s.getErrorMessage)(e)}`,e)}};r.decodeSingle=(e,t)=>{const a=(0,r.decode)([e],t);return(0,n.assert)(1===a.length,new s.ParserError("Decoded value array has unexpected length.")),a[0]}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/abi.js"}],[1817,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ParserError=r.getErrorStack=r.getErrorMessage=void 0;const n=e("@metamask/utils");r.getErrorMessage=e=>"string"==typeof e?e:e instanceof Error||(0,n.isObject)(e)&&(0,n.hasProperty)(e,"message")&&"string"==typeof e.message?e.message:"Unknown error.";r.getErrorStack=e=>e instanceof Error?e.stack:undefined;class s extends Error{constructor(e,t){super(e),this.name="ParserError";const n=(0,r.getErrorStack)(t);n&&(this.stack=n)}}r.ParserError=s}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js"}],[1818,{"./abi":1816,"./errors":1817,"./types":1833},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./abi"),r),s(e("./errors"),r),s(e("./types"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/index.js"}],[1819,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.iterate=void 0;const n=e("@metamask/utils");r.iterate=function*(e,t=32){for(let r=0;r<e.length;r+=t){const s=e=>{(0,n.assert)(e>=0,"Cannot skip a negative number of bytes."),(0,n.assert)(e%t==0,"Length must be a multiple of the size."),r+=e},a=e.subarray(r);yield{skip:s,value:a}}return{skip:()=>undefined,value:new Uint8Array}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/iterator.js"}],[1820,{"./errors":1817,"./iterator":1819,"./parsers":1827,"./utils":1835,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.unpack=r.pack=r.isDynamicParser=r.getParser=void 0;const n=e("@metamask/utils"),s=e("./errors"),a=e("./iterator"),o=e("./parsers"),i=e("./utils");r.getParser=e=>{const t={address:o.address,array:o.array,bool:o.bool,bytes:o.bytes,fixedBytes:o.fixedBytes,function:o.fn,number:o.number,string:o.string,tuple:o.tuple},r=t[e];if(r)return r;const n=Object.values(t).find((t=>t.isType(e)));if(n)return n;throw new s.ParserError(`The type "${e}" is not supported.`)};r.isDynamicParser=(e,t)=>{const{isDynamic:r}=e;return"function"==typeof r?r(t):r};r.pack=({types:e,values:t,packed:a=!1,tight:o=!1,arrayPacked:c=!1,byteArray:l=new Uint8Array})=>{(0,n.assert)(e.length===t.length,new s.ParserError(`The number of types (${e.length}) does not match the number of values (${t.length}).`));const{staticBuffer:u,dynamicBuffer:d,pointers:f}=e.reduce((({staticBuffer:e,dynamicBuffer:s,pointers:i},l,u)=>{const d=(0,r.getParser)(l),f=t[u];if(a||c||!(0,r.isDynamicParser)(d,l))return{staticBuffer:d.encode({buffer:e,value:f,type:l,packed:a,tight:o}),dynamicBuffer:s,pointers:i};return{staticBuffer:(0,n.concatBytes)([e,new Uint8Array(32)]),dynamicBuffer:d.encode({buffer:s,value:f,type:l,packed:a,tight:o}),pointers:[...i,{position:e.length,pointer:s.length}]}}),{staticBuffer:new Uint8Array,dynamicBuffer:new Uint8Array,pointers:[]});(0,n.assert)(!a&&!c||0===d.length,new s.ParserError("Invalid pack state."));const m=u.length,h=f.reduce(((e,{pointer:t,position:r})=>{const s=(0,i.padStart)((0,n.numberToBytes)(m+t));return(0,i.set)(e,s,r)}),u);return(0,n.concatBytes)([l,h,d])};r.unpack=(e,t)=>{const o=(0,a.iterate)(t);return e.map((e=>{const{value:{value:a,skip:i},done:c}=o.next();(0,n.assert)(!c,new s.ParserError(`The encoded value is invalid for the provided types. Reached end of buffer while attempting to parse "${e}".`));const l=(0,r.getParser)(e);if((0,r.isDynamicParser)(l,e)){const r=(0,n.bytesToNumber)(a.subarray(0,32)),s=t.subarray(r);return l.decode({type:e,value:s,skip:i})}return l.decode({type:e,value:a,skip:i})}))}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/packer.js"}],[1821,{"../errors":1817,"../utils":1835,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.address=r.getAddress=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils");r.getAddress=e=>{const t=(0,n.createBytes)(e);return(0,n.assert)(t.length<=20,new s.ParserError(`Invalid address value. Expected address to be 20 bytes long, but received ${t.length} bytes.`)),(0,a.padStart)(t,20)},r.address={isDynamic:!1,isType:e=>"address"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:s}){const o=(0,r.getAddress)(t);if(s)return(0,n.concatBytes)([e,o]);const i=(0,a.padStart)(o);return(0,n.concatBytes)([e,i])},decode:({value:e})=>(0,n.add0x)((0,n.bytesToHex)(e.slice(12,32)))}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js"}],[1822,{"../errors":1817,"../packer":1820,"../utils":1835,"./fixed-bytes":1825,"./tuple":1831,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.array=r.getTupleType=r.getArrayType=r.isArrayType=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../packer"),o=e("../utils"),i=e("./fixed-bytes"),c=e("./tuple"),l=/^(?<type>.*)\[(?<length>\d*?)\]$/u;r.isArrayType=e=>l.test(e);r.getArrayType=e=>{const t=e.match(l);return(0,n.assert)(t?.groups?.type,new s.ParserError(`Invalid array type. Expected an array type, but received "${e}".`)),[t.groups.type,t.groups.length?parseInt(t.groups.length,10):undefined]};r.getTupleType=(e,t)=>`(${new Array(t).fill(e).join(",")})`,r.array={isDynamic(e){const[t,n]=(0,r.getArrayType)(e);return n===undefined||(0,a.isDynamicParser)((0,a.getParser)(t),t)},isType:e=>(0,r.isArrayType)(e),getByteLength(e){(0,n.assert)((0,r.isArrayType)(e),new s.ParserError(`Expected an array type, but received "${e}".`));const[t,o]=(0,r.getArrayType)(e);return(0,a.isDynamicParser)(this,e)||o===undefined?32:c.tuple.getByteLength((0,r.getTupleType)(t,o))},encode({type:e,buffer:t,value:l,packed:u,tight:d}){const[f,m]=(0,r.getArrayType)(e);if((0,n.assert)(!u||!(0,r.isArrayType)(f),new s.ParserError("Cannot pack nested arrays.")),u&&(0,a.isDynamicParser)((0,a.getParser)(f),f))return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:t,packed:u,arrayPacked:!0,tight:d});if(m)return(0,n.assert)(m===l.length,new s.ParserError(`Array length does not match type length. Expected a length of ${m}, but received ${l.length}.`)),c.tuple.encode({type:(0,r.getTupleType)(f,m),buffer:t,value:l,packed:i.fixedBytes.isType(f)&&d,tight:d});if(u)return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:t,packed:i.fixedBytes.isType(f)&&d,arrayPacked:!0,tight:d});const h=(0,o.padStart)((0,n.numberToBytes)(l.length));return(0,a.pack)({types:new Array(l.length).fill(f),values:l,byteArray:(0,n.concatBytes)([t,h]),packed:u,tight:d})},decode({type:e,value:t,...o}){const[i,l]=(0,r.getArrayType)(e);if(l){const e=c.tuple.decode({type:(0,r.getTupleType)(i,l),value:t,...o});return(0,n.assert)(e.length===l,new s.ParserError(`Array length does not match type length. Expected a length of ${l}, but received ${e.length}.`)),e}const u=(0,n.bytesToNumber)(t.subarray(0,32));return(0,a.unpack)(new Array(u).fill(i),t.subarray(32))}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js"}],[1823,{"../errors":1817,"./number":1828,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.bool=r.getBooleanValue=void 0;const n=e("@metamask/superstruct"),s=e("@metamask/utils"),a=e("../errors"),o=e("./number"),i=(0,n.coerce)((0,n.boolean)(),(0,n.union)([(0,n.literal)("true"),(0,n.literal)("false")]),(e=>"true"===e));r.getBooleanValue=e=>{try{return(0,n.create)(e,i)?BigInt(1):BigInt(0)}catch{throw new a.ParserError(`Invalid boolean value. Expected a boolean literal, or the string "true" or "false", but received "${e}".`)}},r.bool={isDynamic:!1,isType:e=>"bool"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n,tight:a}){const i=(0,r.getBooleanValue)(t);return n?(0,s.concatBytes)([e,(0,s.bigIntToBytes)(i)]):o.number.encode({type:"uint256",buffer:e,value:i,packed:n,tight:a})},decode:e=>o.number.decode({...e,type:"uint256"})===BigInt(1)}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js"}],[1824,{"../utils":1835,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=void 0;const n=e("@metamask/utils"),s=e("../utils");r.bytes={isDynamic:!0,isType:e=>"bytes"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r}){const a=(0,n.createBytes)(t);if(r)return(0,n.concatBytes)([e,a]);const o=32*Math.ceil(a.byteLength/32);return(0,n.concatBytes)([e,(0,s.padStart)((0,n.numberToBytes)(a.byteLength)),(0,s.padEnd)(a,o)])},decode({value:e}){const t=e.subarray(0,32),r=(0,n.bytesToNumber)(t);return e.slice(32,32+r)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js"}],[1825,{"../errors":1817,"../utils":1835,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.fixedBytes=r.getByteLength=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils"),o=/^bytes([0-9]{1,2})$/u;r.getByteLength=e=>{const t=e.match(o)?.[1];(0,n.assert)(t,`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`);const r=Number(t);return(0,n.assert)(r>0&&r<=32,new s.ParserError(`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`)),r},r.fixedBytes={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:o,packed:i}){const c=(0,r.getByteLength)(e),l=(0,n.createBytes)(o);return(0,n.assert)(l.length<=c,new s.ParserError(`Expected a value of length ${c}, but received a value of length ${l.length}.`)),i?(0,n.concatBytes)([t,(0,a.padEnd)(l,c)]):(0,n.concatBytes)([t,(0,a.padEnd)(l)])},decode({type:e,value:t}){const n=(0,r.getByteLength)(e);return t.slice(0,n)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js"}],[1826,{"../errors":1817,"./fixed-bytes":1825,"@metamask/superstruct":2872,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.fn=r.getFunction=void 0;const n=e("@metamask/superstruct"),s=e("@metamask/utils"),a=e("../errors"),o=e("./fixed-bytes"),i=(0,n.coerce)((0,n.object)({address:s.StrictHexStruct,selector:s.StrictHexStruct}),(0,n.union)([s.StrictHexStruct,(0,n.instance)(Uint8Array)]),(e=>{const t=(0,s.createBytes)(e);return(0,s.assert)(24===t.length,new a.ParserError(`Invalid Solidity function. Expected function to be 24 bytes long, but received ${t.length} bytes.`)),{address:(0,s.bytesToHex)(t.subarray(0,20)),selector:(0,s.bytesToHex)(t.subarray(20,24))}}));r.getFunction=e=>{const t=(0,n.create)(e,i);return(0,s.concatBytes)([(0,s.hexToBytes)(t.address),(0,s.hexToBytes)(t.selector)])},r.fn={isDynamic:!1,isType:e=>"function"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n,tight:s}){const a=(0,r.getFunction)(t);return o.fixedBytes.encode({type:"bytes24",buffer:e,value:a,packed:n,tight:s})},decode:({value:e})=>({address:(0,s.bytesToHex)(e.slice(0,20)),selector:(0,s.bytesToHex)(e.slice(20,24))})}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js"}],[1827,{"./address":1821,"./array":1822,"./bool":1823,"./bytes":1824,"./fixed-bytes":1825,"./function":1826,"./number":1828,"./parser":1829,"./string":1830,"./tuple":1831},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./address"),r),s(e("./array"),r),s(e("./bool"),r),s(e("./bytes"),r),s(e("./fixed-bytes"),r),s(e("./function"),r),s(e("./number"),r),s(e("./parser"),r),s(e("./string"),r),s(e("./tuple"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js"}],[1828,{"../errors":1817,"../utils":1835,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.number=r.getBigInt=r.assertNumberLength=r.getLength=r.isSigned=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../utils"),o=/^u?int(?<length>[0-9]*)?$/u;r.isSigned=e=>!e.startsWith("u");r.getLength=e=>{if("int"===e||"uint"===e)return 256;const t=e.match(o);(0,n.assert)(t?.groups?.length,new s.ParserError(`Invalid number type. Expected a number type, but received "${e}".`));const r=parseInt(t.groups.length,10);return(0,n.assert)(r>=8&&r<=256,new s.ParserError(`Invalid number length. Expected a number between 8 and 256, but received "${e}".`)),(0,n.assert)(r%8==0,new s.ParserError(`Invalid number length. Expected a multiple of 8, but received "${e}".`)),r};r.assertNumberLength=(e,t)=>{const a=(0,r.getLength)(t),o=BigInt(2)**BigInt(a-((0,r.isSigned)(t)?1:0))-BigInt(1);(0,r.isSigned)(t)?(0,n.assert)(e>=-(o+BigInt(1))&&e<=o,new s.ParserError(`Number "${e}" is out of range for type "${t}".`)):(0,n.assert)(e<=o,new s.ParserError(`Number "${e}" is out of range for type "${t}".`))};r.getBigInt=e=>{try{return(0,n.createBigInt)(e)}catch{throw new s.ParserError(`Invalid number. Expected a valid number value, but received "${e}".`)}},r.number={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:s,packed:o}){const i=(0,r.getBigInt)(s);if((0,r.assertNumberLength)(i,e),(0,r.isSigned)(e)){if(o){const s=(0,r.getLength)(e)/8;return(0,n.concatBytes)([t,(0,n.signedBigIntToBytes)(i,s)])}return(0,n.concatBytes)([t,(0,a.padStart)((0,n.signedBigIntToBytes)(i,32))])}if(o){const s=(0,r.getLength)(e)/8;return(0,n.concatBytes)([t,(0,a.padStart)((0,n.bigIntToBytes)(i),s)])}return(0,n.concatBytes)([t,(0,a.padStart)((0,n.bigIntToBytes)(i))])},decode({type:e,value:t}){const s=t.subarray(0,32);if((0,r.isSigned)(e)){const t=(0,n.bytesToSignedBigInt)(s);return(0,r.assertNumberLength)(t,e),t}const a=(0,n.bytesToBigInt)(s);return(0,r.assertNumberLength)(a,e),a}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js"}],[1829,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js"}],[183,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.filterEvents=function({getMetaMetricsEnabled:e,log:t}){return{name:n,processEvent:async r=>await e()?r:(t("Event dropped as metrics disabled"),null)}};const n="FilterEvents"}}},{package:"$root$",file:"app/scripts/lib/sentry-filter-events.ts"}],[1830,{"./bytes":1824,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.string=void 0;const n=e("@metamask/utils"),s=e("./bytes");r.string={isDynamic:!0,isType:e=>"string"===e,getByteLength:()=>32,encode:({buffer:e,value:t,packed:r,tight:a})=>s.bytes.encode({type:"bytes",buffer:e,value:(0,n.stringToBytes)(t),packed:r,tight:a}),decode:e=>(0,n.bytesToString)(s.bytes.decode(e))}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js"}],[1831,{"../errors":1817,"../packer":1820,"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.tuple=r.getTupleElements=void 0;const n=e("@metamask/utils"),s=e("../errors"),a=e("../packer"),o=/^\((.+)\)$/u;r.getTupleElements=e=>{(0,n.assert)(e.startsWith("(")&&e.endsWith(")"),new s.ParserError(`Invalid tuple type. Expected tuple type, but received "${e}".`));const t=[];let r="",a=0;for(let n=1;n<e.length-1;n++){const s=e[n];","===s&&0===a?(t.push(r.trim()),r=""):(r+=s,"("===s?a+=1:")"===s&&(a-=1))}return r.trim()&&t.push(r.trim()),t},r.tuple={isDynamic:e=>(0,r.getTupleElements)(e).some((e=>{const t=(0,a.getParser)(e);return(0,a.isDynamicParser)(t,e)})),isType:e=>(e=>o.test(e))(e),getByteLength(e){if((0,a.isDynamicParser)(this,e))return 32;return(0,r.getTupleElements)(e).reduce(((e,t)=>e+(0,a.getParser)(t).getByteLength(t)),0)},encode({type:e,buffer:t,value:n,packed:s,tight:o}){const i=(0,r.getTupleElements)(e);return(0,a.pack)({types:i,values:n,byteArray:t,packed:s,tight:o})},decode({type:e,value:t,skip:n}){const s=(0,r.getTupleElements)(e);return n(this.getByteLength(e)-32),(0,a.unpack)(s,t)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"}],[1832,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js"}],[1833,{"./abi":1832},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./abi"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/index.js"}],[1834,{"@metamask/utils":2976},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.padEnd=r.padStart=r.set=void 0;const n=e("@metamask/utils");r.set=(e,t,r)=>(0,n.concatBytes)([e.subarray(0,r),t,e.subarray(r+t.length)]);r.padStart=(e,t=32)=>{const r=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,n.concatBytes)([r,e])};r.padEnd=(e,t=32)=>{const r=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,n.concatBytes)([e,r])}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js"}],[1835,{"./buffer":1834},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),s(e("./buffer"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js"}],[1836,{"./utils":1841,"@scure/base":1857,buffer:4108,tweetnacl:5708},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&n(t,e,r);return s(t,e),t};Object.defineProperty(r,"__esModule",{value:!0}),r.getEncryptionPublicKey=r.decryptSafely=r.decrypt=r.encryptSafely=r.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),c=e("./utils");function l({publicKey:e,data:t,version:r}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(r))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===r){if("string"!=typeof t)throw new Error("Message data must be given as a string");const r=i.box.keyPair();let n;try{n=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const s=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),c=i.box(s,a,n,r.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(r.publicKey),ciphertext:o.base64.encode(c)}}throw new Error("Encryption type/version not supported")}function u({encryptedData:e,privateKey:r}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(r))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const n=t.from(r,"hex"),s=i.box.keyPair.fromSecretKey(n).secretKey,a=o.base64.decode(e.nonce),c=o.base64.decode(e.ciphertext),l=o.base64.decode(e.ephemPublicKey),u=i.box.open(c,a,l,s);try{if(!u)throw new Error;const e=o.utf8.encode(u);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}r.encrypt=l,r.encryptSafely=function({publicKey:e,data:r,version:n}){if((0,c.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,c.isNullish)(r))throw new Error("Missing data parameter");if((0,c.isNullish)(n))throw new Error("Missing version parameter");if("object"==typeof r&&r&&"toJSON"in r)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const s={data:r,padding:""},a=t.byteLength(JSON.stringify(s),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),s.padding="0".repeat(o),l({publicKey:e,data:JSON.stringify(s),version:n})},r.decrypt=u,r.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,c.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,c.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(u({encryptedData:e,privateKey:t})).data},r.getEncryptionPublicKey=function(e){const r=t.from(e,"hex"),n=i.box.keyPair.fromSecretKey(r).publicKey;return o.base64.encode(n)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js"}],[1837,{"./encryption":1836,"./personal-sign":1838,"./sign-eip7702-authorization":1839,"./sign-typed-data":1840,"./utils":1841},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.concatSig=void 0,s(e("./personal-sign"),r),s(e("./sign-typed-data"),r),s(e("./encryption"),r),s(e("./sign-eip7702-authorization"),r);var a=e("./utils");Object.defineProperty(r,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(r,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/index.js"}],[1838,{"./utils":1841,"@ethereumjs/util":1849},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.extractPublicKey=r.recoverPersonalSignature=r.personalSign=void 0;const n=e("@ethereumjs/util"),s=e("./utils");function a(e,t){const r=(0,n.hashPersonalMessage)((0,s.legacyToBuffer)(e));return(0,s.recoverPublicKey)(r,t)}r.personalSign=function({privateKey:e,data:t}){if((0,s.isNullish)(t))throw new Error("Missing data parameter");if((0,s.isNullish)(e))throw new Error("Missing privateKey parameter");const r=(0,s.legacyToBuffer)(t),a=(0,n.hashPersonalMessage)(r),o=(0,n.ecsign)(a,e);return(0,s.concatSig)((0,n.toBuffer)(o.v),o.r,o.s)},r.recoverPersonalSignature=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");const r=a(e,t),o=(0,n.publicToAddress)(r);return(0,n.bufferToHex)(o)},r.extractPublicKey=function({data:e,signature:t}){if((0,s.isNullish)(e))throw new Error("Missing data parameter");if((0,s.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],[1839,{"./utils":1841,"@ethereumjs/rlp":497,"@ethereumjs/util":1849,"@metamask/utils":2976,buffer:4108,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.hashEIP7702Authorization=r.recoverEIP7702Authorization=r.signEIP7702Authorization=void 0;const n=e("@ethereumjs/rlp"),s=e("@ethereumjs/util"),a=e("@metamask/utils"),o=e("ethereum-cryptography/keccak"),i=e("./utils");function c(e){l(e);const r=(0,n.encode)(e),s=t.concat([t.from("05","hex"),r]);return t.from((0,o.keccak256)(s))}function l(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,r,n]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(r))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(n))throw new Error("Missing nonce parameter")}r.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(l(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const r=c(t),{r:n,s:a,v:o}=(0,s.ecsign)(r,e),u=(0,s.toBuffer)(o);return(0,i.concatSig)(u,n,a)},r.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(l(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const r=c(t),n=(0,i.recoverPublicKey)(r,e),o=(0,s.publicToAddress)(n);return(0,a.bytesToHex)(o)},r.hashEIP7702Authorization=c}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],[184,{"../../../shared/modules/object.utils":5922,"../constants/sentry-state":7,"../platforms/extension":425,"./stores/extension-store":196,"./stores/persistence-manager":198,"./stores/read-only-network-store":199},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=e("../../../shared/modules/object.utils"),s=c(e("../platforms/extension")),a=e("../constants/sentry-state"),o=(c(e("./stores/read-only-network-store")),c(e("./stores/extension-store"))),i=e("./stores/persistence-manager");function c(e){return e&&e.__esModule?e:{default:e}}const l=new s.default,u=new i.PersistenceManager({localStore:new o.default});globalThis.stateHooks.getPersistedState=async function(){return await u.get({validateVault:!1})};const d={data:a.SENTRY_BACKGROUND_STATE,meta:{version:!0}};globalThis.stateHooks.getSentryState=function(){const e={browser:window.navigator.userAgent,version:l.getVersion()};if(globalThis.stateHooks.getSentryAppState)return u.cleanUpMostRecentRetrievedState(),{...e,state:globalThis.stateHooks.getSentryAppState()};if(u.mostRecentRetrievedState||globalThis.stateHooks.getMostRecentPersistedState){const t=u.mostRecentRetrievedState||globalThis.stateHooks.getMostRecentPersistedState();if(t)return{...e,persistedState:(0,n.maskObject)(t,d)}}return e}}}},{package:"$root$",file:"app/scripts/lib/setup-initial-state-hooks.js"}],[1840,{"./utils":1841,"@ethereumjs/util":1849,"@metamask/abi-utils":1818,"@metamask/abi-utils/dist/parsers":1827,"@metamask/abi-utils/dist/utils":1835,"@metamask/utils":2976,"ethereum-cryptography/keccak":4337},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.recoverTypedSignature=r.signTypedData=r.typedSignatureHash=r.TypedDataUtils=r.TYPED_MESSAGE_SCHEMA=r.SignTypedDataVersion=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),c=e("ethereum-cryptography/keccak"),l=e("./utils");var u;function d(e,t){if(!Object.keys(u).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function f(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const r=BigInt(t),n=(0,a.getLength)(e),s=BigInt(2)**BigInt(n)-BigInt(1);return(0,i.assert)(r>=-s&&r<=s,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),r}function m(e){let t=BigInt(0);for(let r=0;r<e.length;r++){const n=BigInt(e.charCodeAt(r)-48);t*=BigInt(10),t+=n>=49?n-BigInt(49)+BigInt(10):n>=17?n-BigInt(17)+BigInt(10):n}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,r,a,l){if(d(l,[u.V3,u.V4]),e[r]!==undefined)return["bytes32",l===u.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,n.arrToBufArr)((0,c.keccak256)(p(r,a,e,l)))];if("function"===r)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${r}`);if("address"===r){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",m(a).subarray(0,20)]}if("bool"===r)return["bool",Boolean(a)];if("bytes"===r)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.startsWith("bytes")&&"bytes"!==r&&!r.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(r.startsWith("int")&&!r.includes("[")){const e=f(r,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===r)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,n.arrToBufArr)((0,c.keccak256)(a))];if(r.endsWith("]")){if(l===u.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=r.slice(0,r.lastIndexOf("[")),i=a.map((r=>h(e,t,o,r,l)));return["bytes32",(0,n.arrToBufArr)((0,c.keccak256)((0,s.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[r,a]}function p(e,t,r,a){d(a,[u.V3,u.V4]);const o=["bytes32"],i=[E(e,r)];for(const n of r[e]){if(a===u.V3&&t[n.name]===undefined)continue;const[e,s]=h(r,n.name,n.type,t[n.name],a);o.push(e),i.push(s)}return(0,n.arrToBufArr)((0,s.encode)(o,i))}function g(e,t){let r="";const n=b(e,t);n.delete(e);const s=[e,...Array.from(n).sort()];for(const e of s){if(!t[e])throw new Error(`No type definition specified: ${e}`);r+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return r}function b(e,t,r=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const n=e.match(/^\w*/u);if([e]=n,r.has(e)||t[e]===undefined)return r;r.add(e);for(const n of t[e])b(n.type,t,r);return r}function y(e,t,r,s){d(s,[u.V3,u.V4]);const a=p(e,t,r,s),o=(0,c.keccak256)(a);return(0,n.arrToBufArr)(o)}function E(e,t){const r=(0,i.stringToBytes)(g(e,t));return(0,n.arrToBufArr)((0,c.keccak256)(r))}function w(e){const t={};for(const n in r.TYPED_MESSAGE_SCHEMA.properties)e[n]&&(t[n]=e[n]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function k(e,t){d(t,[u.V3,u.V4]);const r=w(e),{domain:n}=r;return y("EIP712Domain",n,{EIP712Domain:r.types.EIP712Domain},t)}function v(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[r]=(0,a.getArrayType)(e);return t.map((e=>v(r,e)))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const r=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,r);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,r);if(t instanceof Uint8Array)return t.subarray(0,r)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const r=(0,a.getLength)(e);return BigInt.asIntN(r,BigInt(t))}return t}function x(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const r=f(e,t);if(r>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(r),32);const n=(0,a.getLength)(e),s=BigInt.asIntN(n,r);return(0,i.signedBigIntToBytes)(s,32)}return t}))}function A(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const r=e.map((({name:e,type:t,value:r})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(n=r,n.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var n;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[n,s]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=s?s:""}]`,value:x(n,r)}}return{name:e,type:t,value:v(t,r)}})),u=r.map((e=>"bytes"!==e.type?e.value:(0,l.legacyToBuffer)(e.value))),d=r.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),f=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,n.arrToBufArr)((0,c.keccak256)((0,s.encodePacked)(["bytes32","bytes32"],[(0,c.keccak256)((0,s.encodePacked)(["string[]"],[f],!0)),(0,c.keccak256)((0,s.encodePacked)(d,u,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(u=r.SignTypedDataVersion||(r.SignTypedDataVersion={})),r.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},r.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:b,hashStruct:y,hashType:E,sanitizeData:w,eip712Hash:function(e,t){d(t,[u.V3,u.V4]);const r=w(e),s=[(0,i.hexToBytes)("1901")];return s.push(k(e,t)),"EIP712Domain"!==r.primaryType&&s.push(y(r.primaryType,r.message,r.types,t)),(0,n.arrToBufArr)((0,c.keccak256)((0,i.concatBytes)(s)))},eip712DomainHash:k},r.typedSignatureHash=function(e){const t=A(e);return(0,i.bytesToHex)(t)},r.signTypedData=function({privateKey:e,data:t,version:s}){if(d(s),(0,l.isNullish)(t))throw new Error("Missing data parameter");if((0,l.isNullish)(e))throw new Error("Missing private key parameter");const a=s===u.V1?A(t):r.TypedDataUtils.eip712Hash(t,s),o=(0,n.ecsign)(a,e);return(0,l.concatSig)((0,n.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},r.recoverTypedSignature=function({data:e,signature:t,version:s}){if(d(s),(0,l.isNullish)(e))throw new Error("Missing data parameter");if((0,l.isNullish)(t))throw new Error("Missing signature parameter");const a=s===u.V1?A(e):r.TypedDataUtils.eip712Hash(e,s),o=(0,l.recoverPublicKey)(a,t),c=(0,n.publicToAddress)(o);return(0,i.bytesToHex)(c)}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],[1841,{"@ethereumjs/util":1849,"@metamask/utils":2976,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.normalize=r.recoverPublicKey=r.concatSig=r.legacyToBuffer=r.isNullish=r.padWithZeroes=void 0;const n=e("@ethereumjs/util"),s=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}r.padWithZeroes=a,r.isNullish=o,r.legacyToBuffer=function(e){return"string"!=typeof e||(0,n.isHexString)(e)?(0,n.toBuffer)(e):t.from(e)},r.concatSig=function(e,t,r){const o=(0,n.fromSigned)(t),i=(0,n.fromSigned)(r),c=(0,n.bufferToInt)(e),l=a((0,n.toUnsigned)(o).toString("hex"),64),u=a((0,n.toUnsigned)(i).toString("hex"),64),d=(0,s.remove0x)((0,s.numberToHex)(c));return(0,s.add0x)(l.concat(u,d))},r.recoverPublicKey=function(e,t){const r=(0,n.fromRpcSig)(t);return(0,n.ecrecover)(e,r.v,r.r,r.s)},r.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,s.numberToBytes)(e);e=(0,s.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,s.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js"}],[1842,{"./bytes":1845,"./constants":1846,"./helpers":1848,"./internal":1850,"@ethereumjs/rlp":497,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358,"ethereum-cryptography/utils":4360},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.accountBodyToRLP=r.accountBodyToSlim=r.accountBodyFromSlim=r.isZeroAddress=r.zeroAddress=r.importPublic=r.privateToAddress=r.privateToPublic=r.publicToAddress=r.pubToAddress=r.isValidPublic=r.isValidPrivate=r.generateAddress2=r.generateAddress=r.isValidChecksumAddress=r.toChecksumAddress=r.isValidAddress=r.Account=void 0;const n=e("@ethereumjs/rlp"),s=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),c=e("./constants"),l=e("./helpers"),u=e("./internal"),d=BigInt(0);class f{constructor(e=d,t=d,r=c.KECCAK256_RLP,n=c.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=r,this.codeHash=n,this._validate()}static fromAccountData(e){const{nonce:t,balance:r,storageRoot:n,codeHash:s}=e;return new f(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,r!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(r)):undefined,n!==undefined?(0,i.toBuffer)(n):undefined,s!==undefined?(0,i.toBuffer)(s):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(n.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,r,n,s]=e;return new f((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(r),n,s)}_validate(){if(this.nonce<d)throw new Error("nonce must be greater than zero");if(this.balance<d)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(n.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(c.KECCAK256_NULL)}isEmpty(){return this.balance===d&&this.nonce===d&&this.codeHash.equals(c.KECCAK256_NULL)}}r.Account=f;r.isValidAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};r.toChecksumAddress=function(e,r){(0,l.assertIsHexString)(e);const n=(0,u.stripHexPrefix)(e).toLowerCase();let a="";if(r!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(r)).toString()+"0x"}const c=t.from(a+n,"utf8"),d=(0,o.bytesToHex)((0,s.keccak256)(c));let f="0x";for(let e=0;e<n.length;e++)parseInt(d[e],16)>=8?f+=n[e].toUpperCase():f+=n[e];return f};r.isValidChecksumAddress=function(e,t){return(0,r.isValidAddress)(e)&&(0,r.toChecksumAddress)(e,t)===e};r.generateAddress=function(e,r){return(0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,i.bufferToBigInt)(r)===BigInt(0)?t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,s.keccak256)(n.RLP.encode((0,i.bufArrToArr)([e,r])))).slice(-20)};r.generateAddress2=function(e,r,n){if((0,l.assertIsBuffer)(e),(0,l.assertIsBuffer)(r),(0,l.assertIsBuffer)(n),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==r.length)throw new Error("Expected salt to be of length 32");const a=(0,s.keccak256)(t.concat([t.from("ff","hex"),e,r,(0,s.keccak256)(n)]));return(0,i.toBuffer)(a).slice(-20)};r.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};r.isValidPublic=function(e,r=!1){if((0,l.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!r)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};r.pubToAddress=function(e,r=!1){if((0,l.assertIsBuffer)(e),r&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,s.keccak256)(e)).slice(-20)},r.publicToAddress=r.pubToAddress;r.privateToPublic=function(e){return(0,l.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};r.privateToAddress=function(e){return(0,r.publicToAddress)((0,r.privateToPublic)(e))};r.importPublic=function(e){return(0,l.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};r.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function m(e){const[t,r,n,s]=e;return[t,r,0===(0,i.arrToBufArr)(n).length?c.KECCAK256_RLP:n,0===(0,i.arrToBufArr)(s).length?c.KECCAK256_NULL:s]}r.isZeroAddress=function(e){try{(0,l.assertIsString)(e)}catch(e){return!1}return(0,r.zeroAddress)()===e},r.accountBodyFromSlim=m;const h=new Uint8Array(0);r.accountBodyToSlim=function(e){const[t,r,n,s]=e;return[t,r,(0,i.arrToBufArr)(n).equals(c.KECCAK256_RLP)?h:n,(0,i.arrToBufArr)(s).equals(c.KECCAK256_NULL)?h:s]},r.accountBodyToRLP=function(e,t=!0){const r=t?m(e):e;return(0,i.arrToBufArr)(n.RLP.encode(r))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],[1843,{"./account":1842,"./bytes":1845,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Address=void 0;const n=e("./account"),s=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,s.zeros)(20))}static fromString(e){if(!(0,n.isValidAddress)(e))throw new Error("Invalid address");return new a((0,s.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const r=(0,n.pubToAddress)(e);return new a(r)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const r=(0,n.privateToAddress)(e);return new a(r)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,n.generateAddress)(e.buf,(0,s.bigIntToBuffer)(t)))}static generate2(e,r,s){if(!t.isBuffer(r))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(s))throw new Error("Expected initCode to be a Buffer");return new a((0,n.generateAddress2)(e.buf,r,s))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,s.bufferToBigInt)(this.buf),t=BigInt(0),r=BigInt("0xffff");return e>=t&&e<=r}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}r.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],[1844,{events:4440},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.AsyncEventEmitter=void 0;const n=e("events");class s extends n.EventEmitter{emit(e,...t){let[r,n]=t;const s=this;let a=s._events[e]??[];return n===undefined&&"function"==typeof r&&(n=r,r=undefined),"newListener"!==e&&"removeListener"!==e||(r={event:r,fn:n},n=undefined),a=Array.isArray(a)?a:[a],async function(e,t,r){let n;for await(const s of t)try{s.length<2?s.call(e,r):await new Promise(((t,n)=>{s.call(e,r,(e=>{e?n(e):t()}))}))}catch(e){n=e}if(n)throw n}(s,a.slice(),r).then(n).catch(n),s.listenerCount(e)>0}once(e,t){const r=this;let n;if("function"!=typeof t)throw new TypeError("listener must be a function");return n=t.length>=2?function(s,a){r.removeListener(e,n),t(s,a)}:function(s){r.removeListener(e,n),t(s,n)},r.on(e,n),r}first(e,t){let r=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(r)||(this._events[e]=r=[r]),r.unshift(t),this}before(e,t,r){return this.beforeOrAfter(e,t,r)}after(e,t,r){return this.beforeOrAfter(e,t,r,"after")}beforeOrAfter(e,t,r,n){let s,a,o=this._events[e]??[];const i="after"===n?1:0;if("function"!=typeof r)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,s=o.length;s--;)if(o[s]===t){a=s+i;break}return o.splice(a,0,r),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}r.AsyncEventEmitter=s}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],[1845,{"./helpers":1848,"./internal":1850,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.intToUnpaddedBuffer=r.bigIntToUnpaddedBuffer=r.bigIntToHex=r.bufArrToArr=r.arrToBufArr=r.validateNoLeadingZeroes=r.baToJSON=r.toUtf8=r.short=r.addHexPrefix=r.toUnsigned=r.fromSigned=r.bufferToInt=r.bigIntToBuffer=r.bufferToBigInt=r.bufferToHex=r.toBuffer=r.unpadHexString=r.unpadArray=r.unpadBuffer=r.setLengthRight=r.setLengthLeft=r.zeros=r.intToBuffer=r.intToHex=void 0;const n=e("./helpers"),s=e("./internal");r.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};r.intToBuffer=function(e){const n=(0,r.intToHex)(e);return t.from((0,s.padToEven)(n.slice(2)),"hex")};r.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,n){const s=(0,r.zeros)(t);return n?e.length<t?(e.copy(s),s):e.slice(0,t):e.length<t?(e.copy(s,t-e.length),s):e.slice(-t)};r.setLengthLeft=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!1)};r.setLengthRight=function(e,t){return(0,n.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};r.unpadBuffer=function(e){return(0,n.assertIsBuffer)(e),o(e)};r.unpadArray=function(e){return(0,n.assertIsArray)(e),o(e)};r.unpadHexString=function(e){return(0,n.assertIsHexString)(e),e=(0,s.stripHexPrefix)(e),"0x"+o(e)};r.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,s.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,s.padToEven)((0,s.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,r.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let r=e.toString(16);return r.length%2&&(r="0"+r),t.from(r,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,r.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function c(e){return(0,r.toBuffer)("0x"+e.toString(16))}r.bufferToHex=function(e){return"0x"+(e=(0,r.toBuffer)(e)).toString("hex")},r.bufferToBigInt=i,r.bigIntToBuffer=c;r.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};r.fromSigned=function(e){return BigInt.asIntN(256,i(e))};r.toUnsigned=function(e){return c(BigInt.asUintN(256,e))};r.addHexPrefix=function(e){return"string"!=typeof e||(0,s.isHexPrefixed)(e)?e:"0x"+e},r.short=function(e,r=50){const n=t.isBuffer(e)?e.toString("hex"):e;return n.length<=r?n:n.slice(0,r)+"…"};r.toUtf8=function(e){if((e=(0,s.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};r.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let n=0;n<e.length;n++)t.push((0,r.baToJSON)(e[n]));return t}};r.validateNoLeadingZeroes=function(e){for(const[t,r]of Object.entries(e))if(r!==undefined&&r.length>0&&0===r[0])throw new Error(`${t} cannot have leading zeroes, received: ${r.toString("hex")}`)},r.arrToBufArr=function e(r){return Array.isArray(r)?r.map((t=>e(t))):t.from(r)},r.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};r.bigIntToHex=e=>"0x"+e.toString(16),r.bigIntToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)(c(e))},r.intToUnpaddedBuffer=function(e){return(0,r.unpadBuffer)((0,r.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],[1846,{buffer:4108,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.MAX_WITHDRAWALS_PER_PAYLOAD=r.RLP_EMPTY_STRING=r.KECCAK256_RLP=r.KECCAK256_RLP_S=r.KECCAK256_RLP_ARRAY=r.KECCAK256_RLP_ARRAY_S=r.KECCAK256_NULL=r.KECCAK256_NULL_S=r.TWO_POW256=r.SECP256K1_ORDER_DIV_2=r.SECP256K1_ORDER=r.MAX_INTEGER_BIGINT=r.MAX_INTEGER=r.MAX_UINT64=void 0;const n=e("buffer"),s=e("ethereum-cryptography/secp256k1");r.MAX_UINT64=BigInt("0xffffffffffffffff"),r.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),r.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),r.SECP256K1_ORDER=s.secp256k1.CURVE.n,r.SECP256K1_ORDER_DIV_2=s.secp256k1.CURVE.n/BigInt(2),r.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),r.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",r.KECCAK256_NULL=n.Buffer.from(r.KECCAK256_NULL_S,"hex"),r.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",r.KECCAK256_RLP_ARRAY=n.Buffer.from(r.KECCAK256_RLP_ARRAY_S,"hex"),r.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",r.KECCAK256_RLP=n.Buffer.from(r.KECCAK256_RLP_S,"hex"),r.RLP_EMPTY_STRING=n.Buffer.from([128]),r.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],[1847,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.compactBytesToNibbles=r.bytesToNibbles=r.nibblesToCompactBytes=r.nibblesToBytes=r.hasTerminator=void 0;r.hasTerminator=e=>e.length>0&&16===e[e.length-1];r.nibblesToBytes=(e,t)=>{for(let r=0,n=0;n<e.length;r+=1,n+=2)t[r]=e[n]<<4|e[n+1]};r.nibblesToCompactBytes=e=>{let t=0;(0,r.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const n=new Uint8Array(e.length/2+1);return n[0]=t<<5,1&~e.length||(n[0]|=16,n[0]|=e[0],e=e.subarray(1)),(0,r.nibblesToBytes)(e,n.subarray(1)),n};r.bytesToNibbles=e=>{const t=2*e.length+1,r=new Uint8Array(t);for(let t=0;t<e.length;t++){const n=e[t];r[2*t]=n/16,r[2*t+1]=n%16}return r[t-1]=16,r};r.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,r.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const n=2-(1&t[0]);return t.subarray(n)}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],[1848,{"../../../../../../../../../is-buffer/index.js":4701,"./internal":1850},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.assertIsString=r.assertIsArray=r.assertIsBuffer=r.assertIsHexString=void 0;const n=e("./internal");r.assertIsHexString=function(e){if(!(0,n.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};r.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};r.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};r.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../../../../is-buffer/index.js")})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],[1849,{"./account":1842,"./address":1843,"./asyncEventEmitter":1844,"./bytes":1845,"./constants":1846,"./encoding":1847,"./internal":1850,"./lock":1851,"./provider":1852,"./signature":1853,"./types":1854,"./units":1855,"./withdrawal":1856},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){var n=this&&this.__createBinding||(Object.create?function(e,t,r,n){n===undefined&&(n=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,s)}:function(e,t,r,n){n===undefined&&(n=r),e[n]=t[r]}),s=this&&this.__exportStar||function(e,t){for(var r in e)"default"===r||Object.prototype.hasOwnProperty.call(t,r)||n(t,e,r)};Object.defineProperty(r,"__esModule",{value:!0}),r.toAscii=r.stripHexPrefix=r.padToEven=r.isHexString=r.isHexPrefixed=r.getKeys=r.getBinarySize=r.fromUtf8=r.fromAscii=r.arrayContainsArray=void 0,s(e("./constants"),r),s(e("./units"),r),s(e("./account"),r),s(e("./address"),r),s(e("./withdrawal"),r),s(e("./signature"),r),s(e("./bytes"),r),s(e("./types"),r),s(e("./encoding"),r),s(e("./asyncEventEmitter"),r);var a=e("./internal");Object.defineProperty(r,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(r,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(r,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(r,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(r,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(r,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(r,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(r,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(r,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(r,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),s(e("./lock"),r),s(e("./provider"),r)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],[185,{"../../../shared/lib/manifestFlags":5886,"../../../shared/modules/mv3.utils":5920,"./extractEthjsErrorMessage":144,"./sentry-filter-events":183,"@metamask/utils":2976,"@sentry/browser":3093,"@sentry/utils":3213,"webextension-polyfill":5787},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.ERROR_URL_ALLOWLIST=void 0,r.beforeBreadcrumb=I,r.default=function(){if(!w)throw new Error("Missing release");if(!_())return p("Skipped initialization"),undefined;return p("Initializing"),o.default.management.getSelf().then((e=>{e.installType&&(h=e.installType)})).catch((e=>{p("Error getting extension installType",e)})),function(){if(!y)return;for(const e of["log","error"])a.logger[e]=(...t)=>{const r=t[0].replace(`Sentry Logger [${e}]: `,"");g(r,...t.slice(1))};p("Integrated logging")}(),function(){const e=function(){const e=function(){if("main"===b)return E;return`${E}-${b}`}(),t=_();return{beforeBreadcrumb:I(),beforeSend:e=>j(e),debug:y,dist:i.isManifestV3?"mv3":"mv2",dsn:t,environment:e,integrations:[s.dedupeIntegration(),s.extraErrorDataIntegration(),s.browserTracingIntegration({shouldCreateSpanForRequest:e=>!e.match(/^https?:\/\/([\w\d.@-]+\.)?sentry\.io(\/|$)/u)}),(0,u.filterEvents)({getMetaMetricsEnabled:P,log:p})],release:w,sendClientReports:!1,tracesSampleRate:T(t),transport:N}}(),{dsn:t,environment:r,release:n,tracesSampleRate:a}=e;globalThis.nw={},globalThis.history??(globalThis.history={}),p("Updating client",{environment:r,dsn:t,release:n,tracesSampleRate:a}),s.registerSpanErrorInstrumentation(),s.init(e),function(){const{ci:e}=(0,c.getManifestFlags)();null!=e&&e.enabled&&(s.setTag("ci.enabled",e.enabled),s.setTag("ci.branch",e.branch),s.setTag("ci.commitHash",e.commitHash),s.setTag("ci.job",e.job),s.setTag("ci.matrixIndex",e.matrixIndex),s.setTag("ci.prNumber",e.prNumber))}(),function(){if(!y)return;const e=s.getClient();null==e||e.on("beforeEnvelope",(e=>{(function(e){var t,r;const n=null==e||null===(t=e[1])||void 0===t||null===(t=t[0])||void 0===t||null===(t=t[0])||void 0===t?void 0:t.type,s=(null==e||null===(r=e[1])||void 0===r||null===(r=r[0])||void 0===r?void 0:r[1])??{};return"session"===n&&"exited"===s.status})(e)&&p("Completed session",e)})),null==e||e.on("afterSendEvent",(e=>{const t=function(e){if("transaction"===e.type)return"Trace";if("error"===e.level)return"Error";return"Event"}(e);p(t,e)})),p("Added debug listeners")}()}(),{...s,getMetaMetricsEnabled:P}},r.log=void 0,r.removeUrlsFromBreadCrumb=D,r.rewriteReport=j;var n=e("@metamask/utils"),s=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=f(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in e)if("default"!==a&&{}.hasOwnProperty.call(e,a)){var o=s?Object.getOwnPropertyDescriptor(e,a):null;o&&(o.get||o.set)?Object.defineProperty(n,a,o):n[a]=e[a]}return n.default=e,r&&r.set(e,n),n}(e("@sentry/browser")),a=e("@sentry/utils"),o=d(e("webextension-polyfill")),i=e("../../../shared/modules/mv3.utils"),c=e("../../../shared/lib/manifestFlags"),l=d(e("./extractEthjsErrorMessage")),u=e("./sentry-filter-events");function d(e){return e&&e.__esModule?e:{default:e}}function f(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(f=function(e){return e?r:t})(e)}const m=(0,n.createProjectLogger)("sentry");let h="unknown";const p=r.log=(0,n.createModuleLogger)(m,globalThis.document?"ui":"background"),g=(0,n.createModuleLogger)(p,"internal"),b="main",y=!1,E="pull-request",w="12.22.0",k="https://3567c198f8a8412082d32655da2961d0@sentry.io/273505",v="https://f59f3dd640d2429d9d0e2445a87ea8e1@sentry.io/273496",x="https://fake@sentry.io/0000000",A=r.ERROR_URL_ALLOWLIST={CRYPTOCOMPARE:"cryptocompare.com",COINGECKO:"coingecko.com",ETHERSCAN:"etherscan.io",CODEFI:"codefi.network",SEGMENT:"segment.io"};function T(e){var t;if(e===x)return 1;const r=(0,c.getManifestFlags)();return(null===(t=r.sentry)||void 0===t?void 0:t.tracesSampleRate)!==undefined?r.sentry.tracesSampleRate:r.ci?"main"===r.ci.branch?.015:0:y?1:.0075}function B(e){return e.persistedState?C(e.persistedState):!!e.state&&(e.state.metamask?Boolean(e.state.metamask.participateInMetaMetrics):Boolean(null===(t=e.state.MetaMetricsController)||void 0===t?void 0:t.participateInMetaMetrics));var t}function C(e){var t;return Boolean(null==e||null===(t=e.data)||void 0===t||null===(t=t.MetaMetricsController)||void 0===t?void 0:t.participateInMetaMetrics)}function _(){if("production"!==E)return v;if(!k)throw new Error("Missing SENTRY_DSN environment variable in production environment");return k}async function P(){const e=(0,c.getManifestFlags)();if(e.ci&&e.sentry.forceEnable)return!0;const t=O();if(t.state||t.persistedState)return B(t);try{return C(await globalThis.stateHooks.getPersistedState())}catch(e){return p("Error retrieving persisted state",e),!1}}function S(e){return e.match(/^(chrome-extension|moz-extension):\/\//u)?e:""}function I(){return e=>{if(!O)return null;if(!B(O())||"ui.input"===(null==e?void 0:e.category))return null;return D(e)}}function D(e){var t,r,n;return null!=e&&null!==(t=e.data)&&void 0!==t&&t.url&&(e.data.url=S(e.data.url)),null!=e&&null!==(r=e.data)&&void 0!==r&&r.to&&(e.data.to=S(e.data.to)),null!=e&&null!==(n=e.data)&&void 0!==n&&n.from&&(e.data.from=S(e.data.from)),e}function j(e){try{var t;!function(e){R(e,(e=>{let t=(0,l.default)(e);return 0===t.indexOf("Transaction Failed: known transaction")&&(t="Transaction Failed: known transaction"),t}))}(e),function(e){R(e,(e=>{let t=e;const r=/(([-.+a-zA-Z]+:\/\/)|(www\.))\S+[@:.]\S+/gu;return(t.match(r)||[]).forEach((e=>{try{const r=new URL(e),{hostname:n}=r;Object.values(A).some((e=>n===e||n.endsWith(`.${e}`)))||(t=t.replace(e,"**"))}catch(r){t=t.replace(e,"**")}})),t}))}(e),function(e){R(e,(e=>e.replace(/0x[A-Fa-f0-9]{40}/u,"0x**")))}(e),function(e){var t;null!==(t=e.request)&&void 0!==t&&t.url&&(e.request.url=F(e.request.url));e.exception&&e.exception.values&&e.exception.values.forEach((e=>{e.stacktrace&&e.stacktrace.frames.forEach((e=>{e.filename=F(e.filename)}))}))}(e);const r=O();e.extra||(e.extra={}),e.tags||(e.tags={}),Object.assign(e.extra,{appState:r,installType:h,extensionId:null===(t=o.default.runtime)||void 0===t?void 0:t.id}),e.tags.installType=h}catch(e){p("Error rewriting report",e)}return e}function R(e,t){"string"==typeof e.message&&(e.message=t(e.message)),e.exception&&e.exception.values&&e.exception.values.forEach((e=>{"string"==typeof e.value&&(e.value=t(e.value))}))}function F(e){var t;if(null===(t=globalThis.location)||void 0===t||!t.origin)return e;const r=null==e?void 0:e.split(globalThis.location.origin)[1];if(!r)return e;return`/metamask${r}`}function O(){var e,t;return(null===(e=globalThis.stateHooks)||void 0===e||null===(t=e.getSentryState)||void 0===t?void 0:t.call(e))||{}}function N(e){return s.makeFetchTransport(e,(async(...e)=>{if(!await P())throw new Error("Network request skipped as metrics disabled");return await fetch(...e)}))}}}},{package:"$root$",file:"app/scripts/lib/setupSentry.js"}],[1850,{buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(r,"__esModule",{value:!0}),r.isHexString=r.getKeys=r.fromAscii=r.fromUtf8=r.toAscii=r.arrayContainsArray=r.getBinarySize=r.padToEven=r.stripHexPrefix=r.isHexPrefixed=void 0,r.isHexPrefixed=t;function n(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}r.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},r.padToEven=n,r.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},r.arrayContainsArray=function(e,t,r){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===r?"some":"every"]((t=>e.indexOf(t)>=0))},r.toAscii=function(e){let t="",r=0;const n=e.length;for("0x"===e.substring(0,2)&&(r=2);r<n;r+=2){const n=parseInt(e.substr(r,2),16);t+=String.fromCharCode(n)}return t},r.fromUtf8=function(t){return`0x${n(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},r.fromAscii=function(e){let t="";for(let r=0;r<e.length;r++){const n=e.charCodeAt(r).toString(16);t+=n.length<2?`0${n}`:n}return`0x${t}`},r.getKeys=function(e,t,r){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const n=[];for(let s=0;s<e.length;s++){let a=e[s][t];if(!0!==r||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";n.push(a)}return n},r.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],[1851,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.Lock=void 0;r.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],[1852,{"micro-ftch":4981},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.getProvider=r.fetchFromProvider=void 0;const n=e("micro-ftch");r.fetchFromProvider=async(e,t)=>(await(0,n.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;r.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],[1853,{"./bytes":1845,"./constants":1846,"./helpers":1848,buffer:4108,"ethereum-cryptography/keccak":4337,"ethereum-cryptography/secp256k1":4358},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.hashPersonalMessage=r.isValidSignature=r.fromRpcSig=r.toCompactSig=r.toRpcSig=r.ecrecover=r.ecsign=void 0;const n=e("ethereum-cryptography/keccak"),s=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function c(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function l(e){return e===BigInt(0)||e===BigInt(1)}r.ecsign=function(e,r,n){const a=s.secp256k1.sign(e,r),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:n===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(n)*BigInt(2)}};r.ecrecover=function(e,r,n,o,i){const u=t.concat([(0,a.setLengthLeft)(n,32),(0,a.setLengthLeft)(o,32)],64),d=c(r,i);if(!l(d))throw new Error("Invalid signature v value");const f=s.secp256k1.Signature.fromCompact(u).addRecoveryBit(Number(d)).recoverPublicKey(e);return t.from(f.toRawBytes(!1).slice(1))};r.toRpcSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(n,32),(0,a.toBuffer)(e)]))};r.toCompactSig=function(e,r,n,s){if(!l(c(e,s)))throw new Error("Invalid signature v value");let o=n;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(n),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)]))};r.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let r,n,s;if(t.length>=65)r=t.slice(0,32),n=t.slice(32,64),s=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");r=t.slice(0,32),n=t.slice(32,64),s=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),n[0]&=127}return s<27&&(s+=BigInt(27)),{v:s,r:r,s:n}};r.isValidSignature=function(e,t,r,n=!0,s){if(32!==t.length||32!==r.length)return!1;if(!l(c(e,s)))return!1;const i=(0,a.bufferToBigInt)(t),u=(0,a.bufferToBigInt)(r);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||u===BigInt(0)||u>=o.SECP256K1_ORDER)&&!(n&&u>=o.SECP256K1_ORDER_DIV_2)};r.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const r=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,n.keccak256)(t.concat([r,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],[1854,{"./bytes":1845,"./internal":1850},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.toType=r.TypeOutput=void 0;const n=e("./bytes"),s=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=r.TypeOutput||(r.TypeOutput={})),r.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,s.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const r=(0,n.toBuffer)(e);switch(t){case a.Buffer:return r;case a.BigInt:return(0,n.bufferToBigInt)(r);case a.Number:{const e=(0,n.bufferToBigInt)(r);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,n.bufferToHex)(r);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],[1855,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.GWEI_TO_WEI=void 0,r.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],[1856,{"./address":1843,"./bytes":1845,"./types":1854,buffer:4108},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){(function(t){(function(){Object.defineProperty(r,"__esModule",{value:!0}),r.Withdrawal=void 0;const n=e("./address"),s=e("./bytes"),a=e("./types");class o{constructor(e,t,r,n){this.index=e,this.validatorIndex=t,this.address=r,this.amount=n}static fromWithdrawalData(e){const{index:t,validatorIndex:r,address:s,amount:i}=e,c=(0,a.toType)(t,a.TypeOutput.BigInt),l=(0,a.toType)(r,a.TypeOutput.BigInt),u=new n.Address((0,a.toType)(s,a.TypeOutput.Buffer)),d=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(c,l,u,d)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,r,n,s]=e;return o.fromWithdrawalData({index:t,validatorIndex:r,address:n,amount:s})}static toBufferArray(e){const{index:r,validatorIndex:s,address:o,amount:i}=e,c=(0,a.toType)(r,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(r,a.TypeOutput.Buffer),l=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer);let u;u=o instanceof n.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[c,l,u,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,s.bigIntToHex)(this.index),validatorIndex:(0,s.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,s.bigIntToHex)(this.amount)}}}r.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],[1857,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function s(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,r=(e,t)=>r=>e(t(r));return{encode:e.map((e=>e.encode)).reduceRight(r,t),decode:e.map((e=>e.decode)).reduce(r,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(n(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const r=e.indexOf(t);if(-1===r)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return r}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function c(e,t="="){if(n(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;r.length*e%8;)r.push(t);return r},decode(r){if(!Array.isArray(r)||r.length&&"string"!=typeof r[0])throw new Error("padding.encode input should be array of strings");for(let e of r)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let n=r.length;if(n*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;n>0&&r[n-1]===t;n--)if(!((n-1)*e%8))throw new Error("Invalid padding: string has too much padding");return r.slice(0,n)}}}function l(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function u(e,t,r){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(r<2)throw new Error(`convertRadix: wrong to=${r}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let s=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(n(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,n=!0;for(let a=s;a<o.length;a++){const i=o[a],c=t*e+i;if(!Number.isSafeInteger(c)||t*e/t!==e||c-i!=t*e)throw new Error("convertRadix: carry overflow");e=c%r;const l=Math.floor(c/r);if(o[a]=l,!Number.isSafeInteger(l)||l*r+e!==c)throw new Error("convertRadix: carry overflow");n&&(l?n=!1:s=a)}if(a.push(e),n)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(r,"__esModule",{value:!0}),r.bytes=r.stringToBytes=r.str=r.bytesToString=r.hex=r.utf8=r.bech32m=r.bech32=r.base58check=r.createBase58check=r.base58xmr=r.base58xrp=r.base58flickr=r.base58=r.base64urlnopad=r.base64url=r.base64nopad=r.base64=r.base32crockford=r.base32hexnopad=r.base32hex=r.base32nopad=r.base32=r.base16=r.utils=void 0,r.assertNumber=n;const d=(e,t)=>t?d(t,e%t):e,f=(e,t)=>e+(t-d(e,t));function m(e,t,r,s){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(r<=0||r>32)throw new Error(`convertRadix2: wrong to=${r}`);if(f(t,r)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${r} carryBits=${f(t,r)}`);let a=0,o=0;const i=2**r-1,c=[];for(const s of e){if(n(s),s>=2**t)throw new Error(`convertRadix2: invalid data word=${s} from=${t}`);if(a=a<<t|s,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=r;o-=r)c.push((a>>o-r&i)>>>0);a&=2**o-1}if(a=a<<r-o&i,!s&&o>=t)throw new Error("Excess padding");if(!s&&a)throw new Error(`Non-zero padding: ${a}`);return s&&o>0&&c.push(a>>>0),c}function h(e){return n(e),{encode:t=>{if(!s(t))throw new Error("radix.encode input should be Uint8Array");return u(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(u(t,e,256))}}}function p(e,t=!1){if(n(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(f(8,e)>32||f(e,8)>32)throw new Error("radix2: carry overflow");return{encode:r=>{if(!s(r))throw new Error("radix2.encode input should be Uint8Array");return m(Array.from(r),8,e,!t)},decode:r=>{if(!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(m(r,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function b(e,t){if(n(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(r){if(!s(r))throw new Error("checksum.encode: input should be Uint8Array");const n=t(r).slice(0,e),a=new Uint8Array(r.length+e);return a.set(r),a.set(n,r.length),a},decode(r){if(!s(r))throw new Error("checksum.decode: input should be Uint8Array");const n=r.slice(0,-e),a=t(n).slice(0,e),o=r.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return n}}}r.utils={alphabet:o,chain:a,checksum:b,convertRadix:u,convertRadix2:m,radix:h,radix2:p,join:i,padding:c},r.base16=a(p(4),o("0123456789ABCDEF"),i("")),r.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),c(5),i("")),r.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),r.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),c(5),i("")),r.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),r.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),l((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),r.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),c(6),i("")),r.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),r.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),c(6),i("")),r.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const y=e=>a(h(58),o(e),i(""));r.base58=y("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),r.base58flickr=y("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),r.base58xrp=y("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const E=[0,2,3,5,6,7,9,10,11];r.base58xmr={encode(e){let t="";for(let n=0;n<e.length;n+=8){const s=e.subarray(n,n+8);t+=r.base58.encode(s).padStart(E[s.length],"1")}return t},decode(e){let t=[];for(let n=0;n<e.length;n+=11){const s=e.slice(n,n+11),a=E.indexOf(s.length),o=r.base58.decode(s);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};r.createBase58check=e=>a(b(4,(t=>e(e(t)))),r.base58),r.base58check=r.createBase58check;const w=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),k=[996825010,642813549,513874426,1027748829,705979059];function v(e){const t=e>>25;let r=(33554431&e)<<5;for(let e=0;e<k.length;e++)1==(t>>e&1)&&(r^=k[e]);return r}function x(e,t,r=1){const n=e.length;let s=1;for(let t=0;t<n;t++){const r=e.charCodeAt(t);if(r<33||r>126)throw new Error(`Invalid prefix (${e})`);s=v(s)^r>>5}s=v(s);for(let t=0;t<n;t++)s=v(s)^31&e.charCodeAt(t);for(let e of t)s=v(s)^e;for(let e=0;e<6;e++)s=v(s);return s^=r,w.encode(m([s%2**30],30,5,!1))}function A(e){const t="bech32"===e?1:734539939,r=p(5),n=r.decode,s=r.encode,a=g(n);function o(e,r,n=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(r instanceof Uint8Array&&(r=Array.from(r)),!Array.isArray(r)||r.length&&"number"!=typeof r[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof r);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const s=e.length+7+r.length;if(!1!==n&&s>n)throw new TypeError(`Length ${s} exceeds limit ${n}`);const a=e.toLowerCase(),o=x(a,r,t);return`${a}1${w.encode(r)}${o}`}function i(e,r=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==r&&e.length>r)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${r})`);const n=e.toLowerCase();if(e!==n&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const s=n.lastIndexOf("1");if(0===s||-1===s)throw new Error('Letter "1" must be present between prefix and data only');const a=n.slice(0,s),o=n.slice(s+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=w.decode(o).slice(0,-6),c=x(a,i,t);if(!o.endsWith(c))throw new Error(`Invalid checksum in ${e}: expected "${c}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,s(t))},decodeToBytes:function(e){const{prefix:t,words:r}=i(e,!1);return{prefix:t,words:r,bytes:n(r)}},decodeUnsafe:g(i),fromWords:n,fromWordsUnsafe:a,toWords:s}}r.bech32=A("bech32"),r.bech32m=A("bech32m"),r.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},r.hex=a(p(4),o("0123456789abcdef"),i(""),l((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const T={utf8:r.utf8,hex:r.hex,base16:r.base16,base32:r.base32,base64:r.base64,base64url:r.base64url,base58:r.base58,base58xmr:r.base58xmr},B="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";r.bytesToString=(e,t)=>{if("string"!=typeof e||!T.hasOwnProperty(e))throw new TypeError(B);if(!s(t))throw new TypeError("bytesToString() expects Uint8Array");return T[e].encode(t)},r.str=r.bytesToString;r.stringToBytes=(e,t)=>{if(!T.hasOwnProperty(e))throw new TypeError(B);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return T[e].decode(t)},r.bytes=r.stringToBytes}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@scure/base/lib/index.js"}],[196,{loglevel:4933,"webextension-polyfill":5787},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=void 0;var n=a(e("webextension-polyfill")),s=a(e("loglevel"));function a(e){return e&&e.__esModule?e:{default:e}}function o(e,t,r){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var r=e[Symbol.toPrimitive];if(void 0!==r){var n=r.call(e,t||"default");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}r.default=class{constructor(){o(this,"isSupported",void 0),this.isSupported=Boolean(n.default.storage.local),this.isSupported||s.default.error("Storage local API not available.")}async get(){if(!this.isSupported)return s.default.error("Storage local API not available."),null;const{local:e}=n.default.storage;return await e.get(["data","meta"])}async set({data:e,meta:t}){if(!this.isSupported)throw new Error("Metamask- cannot persist state to local store as this browser does not support this action");const{local:r}=n.default.storage;return await r.set({data:e,meta:t})}async reset(){if(!this.isSupported)throw new Error("Metamask- cannot persist state to local store as this browser does not support this action");const{local:e}=n.default.storage;return await e.remove(["data","meta"])}}}}},{package:"$root$",file:"app/scripts/lib/stores/extension-store.ts"}],[197,{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,r){function n(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function s(e,t,r){return e.set(o(e,t),r),r}function a(e,t){return e.get(o(e,t))}function o(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}function i(e){return new Promise(((t,r)=>{e.oncomplete=()=>t(),e.onerror=()=>r(e.error)}))}Object.defineProperty(r,"__esModule",{value:!0}),r.IndexedDBStore=void 0;var c=new WeakMap;r.IndexedDBStore=class{constructor(){n(this,c,null)}async open(e,t){a(c,this)||await new Promise(((r,n)=>{const a=indexedDB.open(e,t);a.onupgradeneeded=async()=>{const e=a.result;e.objectStoreNames.contains("store")||e.createObjectStore("store")},a.onsuccess=()=>{s(c,this,a.result),r()},a.onerror=()=>{n(a.error)}}))}async set(e){if(!a(c,this))throw new Error("Database is not open");const t=Object.keys(e),r=a(c,this).transaction("store","readwrite"),n=r.objectStore("store");for(const r of t)n.put(e[r],r);await i(r)}async get(e){if(!a(c,this))throw new Error("Database is not open");const t=[...new Set(e)],r=a(c,this).transaction("store","readonly"),n=r.objectStore("store"),s=t.map((e=>n.get(e))),o=await Promise.all(s.map((e=>new Promise(((t,r)=>{e.onsuccess=()=>t(e.result),e.onerror=()=>r(e.error)})))));await i(r);const l=new Map(t.map(((e,t)=>[e,o[t]])));return e.map((e=>l.get(e)))}async remove(e){if(!a(c,this))throw new Error("Database is not open");const t=a(c,this).transaction("store","readwrite"),r=t.objectStore("store");for(const t of e)r.delete(t);await i(t)}async reset(){if(!a(c,this))throw new Error("Database is not open");const e=a(c,this).transaction("store","readwrite");e.objectStore("store").clear(),await i(e)}close(){a(c,this)&&(a(c,this).close(),s(c,this,null))}}}}},{package:"$root$",file:"app/scripts/lib/stores/indexeddb-store.ts"}]],[],{});